//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/usdImaging/usdImaging/materialBindingSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
#include "pxr/usdImaging/usdImaging/collectionMaterialBindingSchema.h"
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(UsdImagingMaterialBindingSchemaTokens,
    USD_IMAGING_MATERIAL_BINDING_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

UsdImagingDirectMaterialBindingSchema
UsdImagingMaterialBindingSchema::GetDirectMaterialBinding() const
{
    return UsdImagingDirectMaterialBindingSchema(_GetTypedDataSource<HdContainerDataSource>(
        UsdImagingMaterialBindingSchemaTokens->directMaterialBinding));
}

UsdImagingCollectionMaterialBindingVectorSchema
UsdImagingMaterialBindingSchema::GetCollectionMaterialBindings() const
{
    return UsdImagingCollectionMaterialBindingVectorSchema(_GetTypedDataSource<HdVectorDataSource>(
        UsdImagingMaterialBindingSchemaTokens->collectionMaterialBindings));
}

/*static*/
HdContainerDataSourceHandle
UsdImagingMaterialBindingSchema::BuildRetained(
        const HdContainerDataSourceHandle &directMaterialBinding,
        const HdVectorDataSourceHandle &collectionMaterialBindings
)
{
    TfToken _names[2];
    HdDataSourceBaseHandle _values[2];

    size_t _count = 0;

    if (directMaterialBinding) {
        _names[_count] = UsdImagingMaterialBindingSchemaTokens->directMaterialBinding;
        _values[_count++] = directMaterialBinding;
    }

    if (collectionMaterialBindings) {
        _names[_count] = UsdImagingMaterialBindingSchemaTokens->collectionMaterialBindings;
        _values[_count++] = collectionMaterialBindings;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

UsdImagingMaterialBindingSchema::Builder &
UsdImagingMaterialBindingSchema::Builder::SetDirectMaterialBinding(
    const HdContainerDataSourceHandle &directMaterialBinding)
{
    _directMaterialBinding = directMaterialBinding;
    return *this;
}

UsdImagingMaterialBindingSchema::Builder &
UsdImagingMaterialBindingSchema::Builder::SetCollectionMaterialBindings(
    const HdVectorDataSourceHandle &collectionMaterialBindings)
{
    _collectionMaterialBindings = collectionMaterialBindings;
    return *this;
}

HdContainerDataSourceHandle
UsdImagingMaterialBindingSchema::Builder::Build()
{
    return UsdImagingMaterialBindingSchema::BuildRetained(
        _directMaterialBinding,
        _collectionMaterialBindings
    );
}

/*static*/
UsdImagingMaterialBindingSchema
UsdImagingMaterialBindingSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return UsdImagingMaterialBindingSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                UsdImagingMaterialBindingSchemaTokens->usdMaterialBinding))
        : nullptr);
}

/*static*/
const TfToken &
UsdImagingMaterialBindingSchema::GetSchemaToken()
{
    return UsdImagingMaterialBindingSchemaTokens->usdMaterialBinding;
}

/*static*/
const HdDataSourceLocator &
UsdImagingMaterialBindingSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE