// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
	"github.com/go-acme/jdcloud-sdk-go/core"
)

type DeleteDomainRequest struct {
	core.JDCloudRequest

	/* 实例所属的地域ID  */
	RegionId string `json:"regionId"`

	/* 域名ID，请使用describeDomains接口获取。  */
	DomainId string `json:"domainId"`
}

/*
 * param regionId: 实例所属的地域ID (Required)
 * param domainId: 域名ID，请使用describeDomains接口获取。 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewDeleteDomainRequest(
	regionId string,
	domainId string,
) *DeleteDomainRequest {

	return &DeleteDomainRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/domain/{domainId}",
			Method:  "DELETE",
			Header:  nil,
			Version: "v2",
		},
		RegionId: regionId,
		DomainId: domainId,
	}
}

/*
 * param regionId: 实例所属的地域ID (Required)
 * param domainId: 域名ID，请使用describeDomains接口获取。 (Required)
 */
func NewDeleteDomainRequestWithAllParams(
	regionId string,
	domainId string,
) *DeleteDomainRequest {

	return &DeleteDomainRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/domain/{domainId}",
			Method:  "DELETE",
			Header:  nil,
			Version: "v2",
		},
		RegionId: regionId,
		DomainId: domainId,
	}
}

/* This constructor has better compatible ability when API parameters changed */
func NewDeleteDomainRequestWithoutParam() *DeleteDomainRequest {

	return &DeleteDomainRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/domain/{domainId}",
			Method:  "DELETE",
			Header:  nil,
			Version: "v2",
		},
	}
}

/* param regionId: 实例所属的地域ID(Required) */
func (r *DeleteDomainRequest) SetRegionId(regionId string) {
	r.RegionId = regionId
}

/* param domainId: 域名ID，请使用describeDomains接口获取。(Required) */
func (r *DeleteDomainRequest) SetDomainId(domainId string) {
	r.DomainId = domainId
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r DeleteDomainRequest) GetRegionId() string {
	return r.RegionId
}

type DeleteDomainResponse struct {
	RequestID string             `json:"requestId"`
	Error     core.ErrorResponse `json:"error"`
	Result    DeleteDomainResult `json:"result"`
}

type DeleteDomainResult struct {
}
