// python wrapper for ttkFiberSurface
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkFiberSurface.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkFiberSurface(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkFiberSurface_ClassNew(); }


static PyObject *
PyttkFiberSurface_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkFiberSurface::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkFiberSurface_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkFiberSurface *op = static_cast<ttkFiberSurface *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkFiberSurface::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkFiberSurface_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkFiberSurface *tempr = ttkFiberSurface::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkFiberSurface_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkFiberSurface *op = static_cast<ttkFiberSurface *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkFiberSurface *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkFiberSurface::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkFiberSurface_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkFiberSurface::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkFiberSurface_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkFiberSurface *op = static_cast<ttkFiberSurface *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkFiberSurface::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkFiberSurface_GetRangeCoordinates(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRangeCoordinates");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkFiberSurface *op = static_cast<ttkFiberSurface *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetRangeCoordinates() :
      op->ttkFiberSurface::GetRangeCoordinates());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkFiberSurface_SetRangeCoordinates(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRangeCoordinates");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkFiberSurface *op = static_cast<ttkFiberSurface *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRangeCoordinates(temp0);
    }
    else
    {
      op->ttkFiberSurface::SetRangeCoordinates(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkFiberSurface_GetEdgeParameterization(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEdgeParameterization");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkFiberSurface *op = static_cast<ttkFiberSurface *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetEdgeParameterization() :
      op->ttkFiberSurface::GetEdgeParameterization());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkFiberSurface_SetEdgeParameterization(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEdgeParameterization");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkFiberSurface *op = static_cast<ttkFiberSurface *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEdgeParameterization(temp0);
    }
    else
    {
      op->ttkFiberSurface::SetEdgeParameterization(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkFiberSurface_GetEdgeIds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEdgeIds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkFiberSurface *op = static_cast<ttkFiberSurface *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetEdgeIds() :
      op->ttkFiberSurface::GetEdgeIds());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkFiberSurface_SetEdgeIds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEdgeIds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkFiberSurface *op = static_cast<ttkFiberSurface *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEdgeIds(temp0);
    }
    else
    {
      op->ttkFiberSurface::SetEdgeIds(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkFiberSurface_GetTetIds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTetIds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkFiberSurface *op = static_cast<ttkFiberSurface *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetTetIds() :
      op->ttkFiberSurface::GetTetIds());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkFiberSurface_SetTetIds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTetIds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkFiberSurface *op = static_cast<ttkFiberSurface *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTetIds(temp0);
    }
    else
    {
      op->ttkFiberSurface::SetTetIds(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkFiberSurface_GetCaseIds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCaseIds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkFiberSurface *op = static_cast<ttkFiberSurface *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetCaseIds() :
      op->ttkFiberSurface::GetCaseIds());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkFiberSurface_SetCaseIds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCaseIds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkFiberSurface *op = static_cast<ttkFiberSurface *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCaseIds(temp0);
    }
    else
    {
      op->ttkFiberSurface::SetCaseIds(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkFiberSurface_GetPointMerge(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPointMerge");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkFiberSurface *op = static_cast<ttkFiberSurface *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetPointMerge() :
      op->ttkFiberSurface::GetPointMerge());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkFiberSurface_SetPointMerge(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPointMerge");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkFiberSurface *op = static_cast<ttkFiberSurface *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPointMerge(temp0);
    }
    else
    {
      op->ttkFiberSurface::SetPointMerge(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkFiberSurface_GetRangeOctree(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRangeOctree");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkFiberSurface *op = static_cast<ttkFiberSurface *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetRangeOctree() :
      op->ttkFiberSurface::GetRangeOctree());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkFiberSurface_SetRangeOctree(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRangeOctree");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkFiberSurface *op = static_cast<ttkFiberSurface *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRangeOctree(temp0);
    }
    else
    {
      op->ttkFiberSurface::SetRangeOctree(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkFiberSurface_GetPointMergeDistanceThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPointMergeDistanceThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkFiberSurface *op = static_cast<ttkFiberSurface *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetPointMergeDistanceThreshold() :
      op->ttkFiberSurface::GetPointMergeDistanceThreshold());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkFiberSurface_SetPointMergeDistanceThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPointMergeDistanceThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkFiberSurface *op = static_cast<ttkFiberSurface *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPointMergeDistanceThreshold(temp0);
    }
    else
    {
      op->ttkFiberSurface::SetPointMergeDistanceThreshold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyttkFiberSurface_Methods[] = {
  {"IsTypeOf", PyttkFiberSurface_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkFiberSurface_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkFiberSurface_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkFiberSurface\nC++: static ttkFiberSurface *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkFiberSurface_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkFiberSurface\nC++: ttkFiberSurface *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkFiberSurface_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkFiberSurface_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetRangeCoordinates", PyttkFiberSurface_GetRangeCoordinates, METH_VARARGS,
   "GetRangeCoordinates(self) -> bool\nC++: virtual bool GetRangeCoordinates()\n\n"},
  {"SetRangeCoordinates", PyttkFiberSurface_SetRangeCoordinates, METH_VARARGS,
   "SetRangeCoordinates(self, _arg:bool) -> None\nC++: virtual void SetRangeCoordinates(bool _arg)\n\n"},
  {"GetEdgeParameterization", PyttkFiberSurface_GetEdgeParameterization, METH_VARARGS,
   "GetEdgeParameterization(self) -> bool\nC++: virtual bool GetEdgeParameterization()\n\n"},
  {"SetEdgeParameterization", PyttkFiberSurface_SetEdgeParameterization, METH_VARARGS,
   "SetEdgeParameterization(self, _arg:bool) -> None\nC++: virtual void SetEdgeParameterization(bool _arg)\n\n"},
  {"GetEdgeIds", PyttkFiberSurface_GetEdgeIds, METH_VARARGS,
   "GetEdgeIds(self) -> bool\nC++: virtual bool GetEdgeIds()\n\n"},
  {"SetEdgeIds", PyttkFiberSurface_SetEdgeIds, METH_VARARGS,
   "SetEdgeIds(self, _arg:bool) -> None\nC++: virtual void SetEdgeIds(bool _arg)\n\n"},
  {"GetTetIds", PyttkFiberSurface_GetTetIds, METH_VARARGS,
   "GetTetIds(self) -> bool\nC++: virtual bool GetTetIds()\n\n"},
  {"SetTetIds", PyttkFiberSurface_SetTetIds, METH_VARARGS,
   "SetTetIds(self, _arg:bool) -> None\nC++: virtual void SetTetIds(bool _arg)\n\n"},
  {"GetCaseIds", PyttkFiberSurface_GetCaseIds, METH_VARARGS,
   "GetCaseIds(self) -> bool\nC++: virtual bool GetCaseIds()\n\n"},
  {"SetCaseIds", PyttkFiberSurface_SetCaseIds, METH_VARARGS,
   "SetCaseIds(self, _arg:bool) -> None\nC++: virtual void SetCaseIds(bool _arg)\n\n"},
  {"GetPointMerge", PyttkFiberSurface_GetPointMerge, METH_VARARGS,
   "GetPointMerge(self) -> bool\nC++: virtual bool GetPointMerge()\n\n"},
  {"SetPointMerge", PyttkFiberSurface_SetPointMerge, METH_VARARGS,
   "SetPointMerge(self, _arg:bool) -> None\nC++: virtual void SetPointMerge(bool _arg)\n\n"},
  {"GetRangeOctree", PyttkFiberSurface_GetRangeOctree, METH_VARARGS,
   "GetRangeOctree(self) -> bool\nC++: virtual bool GetRangeOctree()\n\n"},
  {"SetRangeOctree", PyttkFiberSurface_SetRangeOctree, METH_VARARGS,
   "SetRangeOctree(self, _arg:bool) -> None\nC++: virtual void SetRangeOctree(bool _arg)\n\n"},
  {"GetPointMergeDistanceThreshold", PyttkFiberSurface_GetPointMergeDistanceThreshold, METH_VARARGS,
   "GetPointMergeDistanceThreshold(self) -> float\nC++: virtual double GetPointMergeDistanceThreshold()\n\n"},
  {"SetPointMergeDistanceThreshold", PyttkFiberSurface_SetPointMergeDistanceThreshold, METH_VARARGS,
   "SetPointMergeDistanceThreshold(self, _arg:float) -> None\nC++: virtual void SetPointMergeDistanceThreshold(double _arg)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkFiberSurface_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("range_coordinates"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkFiberSurface_GetRangeCoordinates(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkFiberSurface_SetRangeCoordinates(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkFiberSurface_SetRangeCoordinates(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRangeCoordinates/SetRangeCoordinates\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("edge_parameterization"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkFiberSurface_GetEdgeParameterization(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkFiberSurface_SetEdgeParameterization(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkFiberSurface_SetEdgeParameterization(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEdgeParameterization/SetEdgeParameterization\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("edge_ids"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkFiberSurface_GetEdgeIds(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkFiberSurface_SetEdgeIds(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkFiberSurface_SetEdgeIds(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEdgeIds/SetEdgeIds\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tet_ids"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkFiberSurface_GetTetIds(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkFiberSurface_SetTetIds(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkFiberSurface_SetTetIds(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTetIds/SetTetIds\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("case_ids"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkFiberSurface_GetCaseIds(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkFiberSurface_SetCaseIds(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkFiberSurface_SetCaseIds(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCaseIds/SetCaseIds\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("point_merge"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkFiberSurface_GetPointMerge(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkFiberSurface_SetPointMerge(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkFiberSurface_SetPointMerge(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPointMerge/SetPointMerge\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("range_octree"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkFiberSurface_GetRangeOctree(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkFiberSurface_SetRangeOctree(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkFiberSurface_SetRangeOctree(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRangeOctree/SetRangeOctree\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("point_merge_distance_threshold"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkFiberSurface_GetPointMergeDistanceThreshold(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkFiberSurface_SetPointMergeDistanceThreshold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkFiberSurface_SetPointMergeDistanceThreshold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPointMergeDistanceThreshold/SetPointMergeDistanceThreshold\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkFiberSurface_Doc =
  "ttkFiberSurface - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Julien Tierny <julien.tierny@lip6.fr>\\date October 2015.\n\n"
  "TTK VTK-filter that computes fiber surfaces.\n\n"
  "Fiber surfaces are defined as the pre-images of curves drawn in the\n"
  "range of bivariate volumetric functions, typically on top of the\n"
  "continuous scatterplot. Fiber surfaces generalize the segmentation\n"
  "features of isosurfaces to bivariate data. This filter implements an\n"
  "exact, parallel and fast algorithm for fiber surface computation on\n"
  "(explicit or implicit) tetrahedral meshes.\n\n"
  "The input bivariate data must be provided as two independent scalar\n"
  "fields attached as point data to the input geometry. The input range\n"
  "polygon must be provided as a vtkUnstructuredGrid with the actual 2D\n"
  "locations of the vertices also provided as two independent scalar\n"
  "fields attached as point data to the geometry. See vtkRangePolygon to\n"
  "create such an input polygon from sparse user inputs.\n\n"
  "\\param Input0 Input bivariate volumetric data, either regular grid or\n"
  "triangulation (vtkDataSet)\n"
  "\\param Input1 Input range polygon (vtkUnstructuredGrid)\n"
  "\\param Output Output fiber surface (vtkPolyData)\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(), GetOutput()).\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n"
  "Related publication\n\n"
  "\"Fast and Exact Fiber Surface Extraction for Tetrahedral Meshes\"\n\n"
  "Pavol Klacansky, Julien Tierny, Hamish Carr, Zhao Geng\n\n"
  "IEEE Transactions on Visualization and Computer Graphics, 2016.\n\n"
  "\\sa ttk::FiberSurface\n"
  "\\sa vtkRangePolygon\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/builtInExample2/\"\n"
  "  > Builtin example 2\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkFiberSurface_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkFiberSurface.ttkFiberSurface", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkFiberSurface_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkFiberSurface_StaticNew()
{
  return ttkFiberSurface::New();
}

PyObject *PyttkFiberSurface_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkFiberSurface_Type, PyttkFiberSurface_Methods,
    "ttkFiberSurface",
 &PyttkFiberSurface_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkFiberSurface_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkFiberSurface(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkFiberSurface_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkFiberSurface", o) != 0)
  {
    Py_DECREF(o);
  }

}

