/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// VolumeNodeResourcesApplyConfiguration represents a declarative configuration of the VolumeNodeResources type for use
// with apply.
//
// VolumeNodeResources is a set of resource limits for scheduling of volumes.
type VolumeNodeResourcesApplyConfiguration struct {
	// count indicates the maximum number of unique volumes managed by the CSI driver that can be used on a node.
	// A volume that is both attached and mounted on a node is considered to be used once, not twice.
	// The same rule applies for a unique volume that is shared among multiple pods on the same node.
	// If this field is not specified, then the supported number of volumes on this node is unbounded.
	Count *int32 `json:"count,omitempty"`
}

// VolumeNodeResourcesApplyConfiguration constructs a declarative configuration of the VolumeNodeResources type for use with
// apply.
func VolumeNodeResources() *VolumeNodeResourcesApplyConfiguration {
	return &VolumeNodeResourcesApplyConfiguration{}
}

// WithCount sets the Count field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Count field is set to the value of the last call.
func (b *VolumeNodeResourcesApplyConfiguration) WithCount(value int32) *VolumeNodeResourcesApplyConfiguration {
	b.Count = &value
	return b
}
