/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta1

import (
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	v1 "k8s.io/client-go/applyconfigurations/meta/v1"
)

// PodCertificateRequestStatusApplyConfiguration represents a declarative configuration of the PodCertificateRequestStatus type for use
// with apply.
//
// PodCertificateRequestStatus describes the status of the request, and holds
// the certificate data if the request is issued.
type PodCertificateRequestStatusApplyConfiguration struct {
	// conditions applied to the request.
	//
	// The types "Issued", "Denied", and "Failed" have special handling.  At
	// most one of these conditions may be present, and they must have status
	// "True".
	//
	// If the request is denied with `Reason=UnsupportedKeyType`, the signer may
	// suggest a key type that will work in the message field.
	Conditions []v1.ConditionApplyConfiguration `json:"conditions,omitempty"`
	// certificateChain is populated with an issued certificate by the signer.
	// This field is set via the /status subresource. Once populated, this field
	// is immutable.
	//
	// If the certificate signing request is denied, a condition of type
	// "Denied" is added and this field remains empty. If the signer cannot
	// issue the certificate, a condition of type "Failed" is added and this
	// field remains empty.
	//
	// Validation requirements:
	// 1. certificateChain must consist of one or more PEM-formatted certificates.
	// 2. Each entry must be a valid PEM-wrapped, DER-encoded ASN.1 Certificate as
	// described in section 4 of RFC5280.
	//
	// If more than one block is present, and the definition of the requested
	// spec.signerName does not indicate otherwise, the first block is the
	// issued certificate, and subsequent blocks should be treated as
	// intermediate certificates and presented in TLS handshakes.  When
	// projecting the chain into a pod volume, kubelet will drop any data
	// in-between the PEM blocks, as well as any PEM block headers.
	CertificateChain *string `json:"certificateChain,omitempty"`
	// notBefore is the time at which the certificate becomes valid.  The value
	// must be the same as the notBefore value in the leaf certificate in
	// certificateChain.  This field is set via the /status subresource.  Once
	// populated, it is immutable. The signer must set this field at the same
	// time it sets certificateChain.
	NotBefore *metav1.Time `json:"notBefore,omitempty"`
	// beginRefreshAt is the time at which the kubelet should begin trying to
	// refresh the certificate.  This field is set via the /status subresource,
	// and must be set at the same time as certificateChain.  Once populated,
	// this field is immutable.
	//
	// This field is only a hint.  Kubelet may start refreshing before or after
	// this time if necessary.
	BeginRefreshAt *metav1.Time `json:"beginRefreshAt,omitempty"`
	// notAfter is the time at which the certificate expires.  The value must be
	// the same as the notAfter value in the leaf certificate in
	// certificateChain.  This field is set via the /status subresource.  Once
	// populated, it is immutable.  The signer must set this field at the same
	// time it sets certificateChain.
	NotAfter *metav1.Time `json:"notAfter,omitempty"`
}

// PodCertificateRequestStatusApplyConfiguration constructs a declarative configuration of the PodCertificateRequestStatus type for use with
// apply.
func PodCertificateRequestStatus() *PodCertificateRequestStatusApplyConfiguration {
	return &PodCertificateRequestStatusApplyConfiguration{}
}

// WithConditions adds the given value to the Conditions field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Conditions field.
func (b *PodCertificateRequestStatusApplyConfiguration) WithConditions(values ...*v1.ConditionApplyConfiguration) *PodCertificateRequestStatusApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithConditions")
		}
		b.Conditions = append(b.Conditions, *values[i])
	}
	return b
}

// WithCertificateChain sets the CertificateChain field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CertificateChain field is set to the value of the last call.
func (b *PodCertificateRequestStatusApplyConfiguration) WithCertificateChain(value string) *PodCertificateRequestStatusApplyConfiguration {
	b.CertificateChain = &value
	return b
}

// WithNotBefore sets the NotBefore field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NotBefore field is set to the value of the last call.
func (b *PodCertificateRequestStatusApplyConfiguration) WithNotBefore(value metav1.Time) *PodCertificateRequestStatusApplyConfiguration {
	b.NotBefore = &value
	return b
}

// WithBeginRefreshAt sets the BeginRefreshAt field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the BeginRefreshAt field is set to the value of the last call.
func (b *PodCertificateRequestStatusApplyConfiguration) WithBeginRefreshAt(value metav1.Time) *PodCertificateRequestStatusApplyConfiguration {
	b.BeginRefreshAt = &value
	return b
}

// WithNotAfter sets the NotAfter field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NotAfter field is set to the value of the last call.
func (b *PodCertificateRequestStatusApplyConfiguration) WithNotAfter(value metav1.Time) *PodCertificateRequestStatusApplyConfiguration {
	b.NotAfter = &value
	return b
}
