/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// VariableApplyConfiguration represents a declarative configuration of the Variable type for use
// with apply.
//
// Variable is the definition of a variable that is used for composition. A variable is defined as a named expression.
type VariableApplyConfiguration struct {
	// Name is the name of the variable. The name must be a valid CEL identifier and unique among all variables.
	// The variable can be accessed in other expressions through `variables`
	// For example, if name is "foo", the variable will be available as `variables.foo`
	Name *string `json:"name,omitempty"`
	// Expression is the expression that will be evaluated as the value of the variable.
	// The CEL expression has access to the same identifiers as the CEL expressions in Validation.
	Expression *string `json:"expression,omitempty"`
}

// VariableApplyConfiguration constructs a declarative configuration of the Variable type for use with
// apply.
func Variable() *VariableApplyConfiguration {
	return &VariableApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *VariableApplyConfiguration) WithName(value string) *VariableApplyConfiguration {
	b.Name = &value
	return b
}

// WithExpression sets the Expression field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Expression field is set to the value of the last call.
func (b *VariableApplyConfiguration) WithExpression(value string) *VariableApplyConfiguration {
	b.Expression = &value
	return b
}
