/* Plug.c generated by valac 0.56.17, the Vala compiler
 * generated from Plug.vala, do not modify */

/*
 * Copyright 2019 elementary, Inc. (https://elementary.io)
 *           2015 Adam Bieńkowski (https://launchpad.net/switchboard-plug-parental-controls)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 *
 * Authored by: Adam Bieńkowski <donadigos159@gmail.com>
 */

#include "screentime-limits.h"
#include <switchboard.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gmodule.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PC_PLUG_0_PROPERTY,
	PC_PLUG_NUM_PROPERTIES
};
static GParamSpec* pc_plug_properties[PC_PLUG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _PcPlugSearchData PcPlugSearchData;

struct _PCPlugPrivate {
	PCMainBox* main_box;
};

struct _PcPlugSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PCPlug* self;
	gchar* search;
	GeeTreeMap* result;
	GeeTreeMap* search_results;
	GeeTreeMap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
};

static gint PCPlug_private_offset;
static gpointer pc_plug_parent_class = NULL;

static GtkWidget* pc_plug_real_get_widget (SwitchboardPlug* base);
static void pc_plug_real_shown (SwitchboardPlug* base);
static void pc_plug_real_hidden (SwitchboardPlug* base);
static void pc_plug_real_search_callback (SwitchboardPlug* base,
                                   const gchar* location);
static void pc_plug_real_search_data_free (gpointer _data);
static void pc_plug_real_search (SwitchboardPlug* base,
                          const gchar* search,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_);
static gboolean pc_plug_real_search_co (PcPlugSearchData* _data_);
static void pc_plug_finalize (GObject * obj);
static GType pc_plug_get_type_once (void);

static inline gpointer
pc_plug_get_instance_private (PCPlug* self)
{
	return G_STRUCT_MEMBER_P (self, PCPlug_private_offset);
}

PCPlug*
pc_plug_construct (GType object_type)
{
	PCPlug * self = NULL;
	GeeTreeMap* settings = NULL;
	GeeTreeMap* _tmp0_;
	bindtextdomain (PC_CONSTANTS_GETTEXT_PACKAGE, PC_CONSTANTS_LOCALEDIR);
	bind_textdomain_codeset (PC_CONSTANTS_GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	settings = _tmp0_;
	gee_abstract_map_set ((GeeAbstractMap*) settings, "parental-controls", NULL);
	self = (PCPlug*) g_object_new (object_type, "category", SWITCHBOARD_PLUG_CATEGORY_SYSTEM, "code-name", "io.elementary.settings.screentime-limits", "display-name", _ ("Screen Time & Limits"), "description", _ ("Configure time limits and restrict application usage"), "icon", "io.elementary.settings.screentime-limits", "supported-settings", settings, NULL);
	_g_object_unref0 (settings);
	return self;
}

PCPlug*
pc_plug_new (void)
{
	return pc_plug_construct (PC_TYPE_PLUG);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GtkWidget*
pc_plug_real_get_widget (SwitchboardPlug* base)
{
	PCPlug * self;
	PCMainBox* _tmp0_;
	PCMainBox* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* result;
	self = (PCPlug*) base;
	_tmp0_ = self->priv->main_box;
	if (_tmp0_ == NULL) {
		PCMainBox* _tmp1_;
		_tmp1_ = pc_main_box_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->main_box);
		self->priv->main_box = _tmp1_;
	}
	_tmp2_ = self->priv->main_box;
	_tmp3_ = _g_object_ref0 ((GtkWidget*) _tmp2_);
	result = _tmp3_;
	return result;
}

static void
pc_plug_real_shown (SwitchboardPlug* base)
{
	PCPlug * self;
	self = (PCPlug*) base;
}

static void
pc_plug_real_hidden (SwitchboardPlug* base)
{
	PCPlug * self;
	self = (PCPlug*) base;
}

static void
pc_plug_real_search_callback (SwitchboardPlug* base,
                              const gchar* location)
{
	PCPlug * self;
	self = (PCPlug*) base;
	g_return_if_fail (location != NULL);
}

static void
pc_plug_real_search_data_free (gpointer _data)
{
	PcPlugSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->search);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (PcPlugSearchData, _data_);
}

static void
pc_plug_real_search (SwitchboardPlug* base,
                     const gchar* search,
                     GAsyncReadyCallback _callback_,
                     gpointer _user_data_)
{
	PCPlug * self;
	PcPlugSearchData* _data_;
	PCPlug* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (search != NULL);
	self = (PCPlug*) base;
	_data_ = g_slice_new0 (PcPlugSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pc_plug_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (search);
	_g_free0 (_data_->search);
	_data_->search = _tmp1_;
	pc_plug_real_search_co (_data_);
}

static GeeTreeMap*
pc_plug_search_finish (SwitchboardPlug* base,
                       GAsyncResult* _res_)
{
	GeeTreeMap* result;
	PcPlugSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
pc_plug_real_search_co (PcPlugSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->search_results = _data_->_tmp0_;
	_data_->_tmp1_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = g_strdup_printf ("%s → %s", _data_->_tmp2_, _ ("Limit computer use"));
	_data_->_tmp4_ = _data_->_tmp3_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp4_, "");
	_g_free0 (_data_->_tmp4_);
	_data_->_tmp5_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = g_strdup_printf ("%s → %s", _data_->_tmp6_, _ ("Prevent website access"));
	_data_->_tmp8_ = _data_->_tmp7_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp8_, "");
	_g_free0 (_data_->_tmp8_);
	_data_->_tmp9_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = g_strdup_printf ("%s → %s", _data_->_tmp10_, _ ("Prevent application access"));
	_data_->_tmp12_ = _data_->_tmp11_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp12_, "");
	_g_free0 (_data_->_tmp12_);
	_data_->result = _data_->search_results;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
pc_plug_class_init (PCPlugClass * klass,
                    gpointer klass_data)
{
	pc_plug_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PCPlug_private_offset);
	((SwitchboardPlugClass *) klass)->get_widget = (GtkWidget* (*) (SwitchboardPlug*)) pc_plug_real_get_widget;
	((SwitchboardPlugClass *) klass)->shown = (void (*) (SwitchboardPlug*)) pc_plug_real_shown;
	((SwitchboardPlugClass *) klass)->hidden = (void (*) (SwitchboardPlug*)) pc_plug_real_hidden;
	((SwitchboardPlugClass *) klass)->search_callback = (void (*) (SwitchboardPlug*, const gchar*)) pc_plug_real_search_callback;
	((SwitchboardPlugClass *) klass)->search = (void (*) (SwitchboardPlug*, const gchar*, GAsyncReadyCallback, gpointer)) pc_plug_real_search;
	((SwitchboardPlugClass *) klass)->search_finish = (GeeTreeMap* (*) (SwitchboardPlug*, GAsyncResult*)) pc_plug_search_finish;
	G_OBJECT_CLASS (klass)->finalize = pc_plug_finalize;
}

static void
pc_plug_instance_init (PCPlug * self,
                       gpointer klass)
{
	self->priv = pc_plug_get_instance_private (self);
	self->priv->main_box = NULL;
}

static void
pc_plug_finalize (GObject * obj)
{
	PCPlug * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PC_TYPE_PLUG, PCPlug);
	_g_object_unref0 (self->priv->main_box);
	G_OBJECT_CLASS (pc_plug_parent_class)->finalize (obj);
}

static GType
pc_plug_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PCPlugClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pc_plug_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PCPlug), 0, (GInstanceInitFunc) pc_plug_instance_init, NULL };
	GType pc_plug_type_id;
	pc_plug_type_id = g_type_register_static (SWITCHBOARD_TYPE_PLUG, "PCPlug", &g_define_type_info, 0);
	PCPlug_private_offset = g_type_add_instance_private (pc_plug_type_id, sizeof (PCPlugPrivate));
	return pc_plug_type_id;
}

GType
pc_plug_get_type (void)
{
	static volatile gsize pc_plug_type_id__once = 0;
	if (g_once_init_enter (&pc_plug_type_id__once)) {
		GType pc_plug_type_id;
		pc_plug_type_id = pc_plug_get_type_once ();
		g_once_init_leave (&pc_plug_type_id__once, pc_plug_type_id);
	}
	return pc_plug_type_id__once;
}

SwitchboardPlug*
get_plug (GModule* module)
{
	PCPlug* plug = NULL;
	PCPlug* _tmp0_;
	SwitchboardPlug* result;
	g_return_val_if_fail (module != NULL, NULL);
	g_debug ("Plug.vala:72: Activating Screen Time & Limits plug");
	_tmp0_ = pc_plug_new ();
	plug = _tmp0_;
	result = (SwitchboardPlug*) plug;
	return result;
}

