/* Parser.c generated by valac 0.56.17, the Vala compiler
 * generated from Parser.vala, do not modify */

/*-
 * Copyright (c) 2014 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Corentin Noël <corentin@elementaryos.org>
 */

#include "datetime.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DATE_TIME_PARSER_0_PROPERTY,
	DATE_TIME_PARSER_NUM_PROPERTIES
};
static GParamSpec* date_time_parser_properties[DATE_TIME_PARSER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _DateTimeParserPrivate {
	GList* lines;
};

static gint DateTimeParser_private_offset;
static gpointer date_time_parser_parent_class = NULL;
static DateTimeParser* date_time_parser_parser;
static DateTimeParser* date_time_parser_parser = NULL;

static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static DateTimeParser* date_time_parser_new (void);
static DateTimeParser* date_time_parser_construct (GType object_type);
static void date_time_parser_finalize (GObject * obj);
static GType date_time_parser_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
date_time_parser_get_instance_private (DateTimeParser* self)
{
	return G_STRUCT_MEMBER_P (self, DateTimeParser_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

DateTimeParser*
date_time_parser_get_default (void)
{
	DateTimeParser* _tmp0_;
	DateTimeParser* _tmp2_;
	DateTimeParser* _tmp3_;
	DateTimeParser* result;
	_tmp0_ = date_time_parser_parser;
	if (_tmp0_ == NULL) {
		DateTimeParser* _tmp1_;
		_tmp1_ = date_time_parser_new ();
		_g_object_unref0 (date_time_parser_parser);
		date_time_parser_parser = _tmp1_;
	}
	_tmp2_ = date_time_parser_parser;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static DateTimeParser*
date_time_parser_construct (GType object_type)
{
	DateTimeParser * self = NULL;
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	self = (DateTimeParser*) g_object_new (object_type, NULL);
	_tmp0_ = g_file_new_for_path ("/usr/share/zoneinfo/zone.tab");
	file = _tmp0_;
	_tmp1_ = file;
	if (!g_file_query_exists (_tmp1_, NULL)) {
		g_critical ("Parser.vala:32: /usr/share/zoneinfo/zone.tab doesn't exist !");
		_g_object_unref0 (file);
		return self;
	}
	(self->priv->lines == NULL) ? NULL : (self->priv->lines = (_g_list_free__g_free0_ (self->priv->lines), NULL));
	self->priv->lines = NULL;
	{
		GFileInputStream* _tmp2_ = NULL;
		GFile* _tmp3_;
		GFileInputStream* _tmp4_;
		GDataInputStream* dis = NULL;
		GDataInputStream* _tmp5_;
		gchar* line = NULL;
		_tmp3_ = file;
		_tmp4_ = g_file_read (_tmp3_, NULL, &_inner_error0_);
		_tmp2_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = g_data_input_stream_new ((GInputStream*) _tmp2_);
		dis = _tmp5_;
		while (TRUE) {
			gchar* _tmp6_ = NULL;
			GDataInputStream* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp7_ = dis;
			_tmp8_ = g_data_input_stream_read_line (_tmp7_, NULL, NULL, &_inner_error0_);
			_tmp6_ = _tmp8_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (line);
				_g_object_unref0 (dis);
				_g_object_unref0 (_tmp2_);
				goto __catch0_g_error;
			}
			_tmp9_ = _tmp6_;
			_tmp6_ = NULL;
			_g_free0 (line);
			line = _tmp9_;
			_tmp10_ = line;
			if (!(_tmp10_ != NULL)) {
				_g_free0 (_tmp6_);
				break;
			}
			_tmp11_ = line;
			if (g_str_has_prefix (_tmp11_, "#")) {
				_g_free0 (_tmp6_);
				continue;
			}
			_tmp12_ = line;
			_tmp13_ = g_strdup (_tmp12_);
			self->priv->lines = g_list_append (self->priv->lines, _tmp13_);
			_g_free0 (_tmp6_);
		}
		_g_free0 (line);
		_g_object_unref0 (dis);
		_g_object_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_critical ("Parser.vala:48: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_g_object_unref0 (file);
	return self;
}

static DateTimeParser*
date_time_parser_new (void)
{
	return date_time_parser_construct (DATE_TIME_TYPE_PARSER);
}

GHashTable*
date_time_parser_get_timezones_from_continent (DateTimeParser* self,
                                               const gchar* continent)
{
	GHashTable* timezones = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GList* _tmp3_;
	GHashTable* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (continent != NULL, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	timezones = _tmp2_;
	_tmp3_ = self->priv->lines;
	{
		GList* line_collection = NULL;
		GList* line_it = NULL;
		line_collection = _tmp3_;
		for (line_it = line_collection; line_it != NULL; line_it = line_it->next) {
			gchar* _tmp4_;
			gchar* line = NULL;
			_tmp4_ = g_strdup ((const gchar*) line_it->data);
			line = _tmp4_;
			{
				gchar** items = NULL;
				const gchar* _tmp5_;
				gchar** _tmp6_;
				gchar** _tmp7_;
				gint items_length1;
				gint _items_size_;
				gchar* value = NULL;
				gchar** _tmp8_;
				gint _tmp8__length1;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				const gchar* _tmp11_;
				gchar* tz_name_field = NULL;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_;
				gint _tmp13__length1;
				const gchar* _tmp14_;
				gchar* city = NULL;
				const gchar* _tmp23_;
				gchar** _tmp24_;
				gchar** _tmp25_;
				gchar** _tmp26_;
				gint _tmp26__length1;
				const gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				gboolean _tmp30_ = FALSE;
				const gchar* _tmp31_;
				_tmp5_ = line;
				_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "\t", 4);
				items = _tmp7_;
				items_length1 = _vala_array_length (_tmp6_);
				_items_size_ = items_length1;
				_tmp8_ = items;
				_tmp8__length1 = items_length1;
				_tmp9_ = _tmp8_[2];
				_tmp10_ = g_strdup (_tmp9_);
				value = _tmp10_;
				_tmp11_ = value;
				if (g_str_has_prefix (_tmp11_, continent) == FALSE) {
					_g_free0 (value);
					items = (_vala_array_free (items, items_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (line);
					continue;
				}
				_tmp13_ = items;
				_tmp13__length1 = items_length1;
				_tmp14_ = _tmp13_[2];
				if (_ (_tmp14_) == NULL) {
					_tmp12_ = TRUE;
				} else {
					gchar** _tmp15_;
					gint _tmp15__length1;
					const gchar* _tmp16_;
					_tmp15_ = items;
					_tmp15__length1 = items_length1;
					_tmp16_ = _tmp15_[2];
					_tmp12_ = g_strcmp0 (_ (_tmp16_), "") == 0;
				}
				if (_tmp12_) {
					gchar** _tmp17_;
					gint _tmp17__length1;
					const gchar* _tmp18_;
					gchar* _tmp19_;
					_tmp17_ = items;
					_tmp17__length1 = items_length1;
					_tmp18_ = _tmp17_[2];
					_tmp19_ = g_strdup (_tmp18_);
					_g_free0 (tz_name_field);
					tz_name_field = _tmp19_;
				} else {
					gchar** _tmp20_;
					gint _tmp20__length1;
					const gchar* _tmp21_;
					gchar* _tmp22_;
					_tmp20_ = items;
					_tmp20__length1 = items_length1;
					_tmp21_ = _tmp20_[2];
					_tmp22_ = g_strdup (_ (_tmp21_));
					_g_free0 (tz_name_field);
					tz_name_field = _tmp22_;
				}
				_tmp23_ = tz_name_field;
				_tmp25_ = _tmp24_ = g_strsplit (_tmp23_, "/", 2);
				_tmp26_ = _tmp25_;
				_tmp26__length1 = _vala_array_length (_tmp24_);
				_tmp27_ = _tmp26_[1];
				_tmp28_ = g_strdup (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp26_ = (_vala_array_free (_tmp26_, _tmp26__length1, (GDestroyNotify) g_free), NULL);
				city = _tmp29_;
				_tmp31_ = city;
				if (_tmp31_ != NULL) {
					const gchar* _tmp32_;
					_tmp32_ = city;
					_tmp30_ = g_strcmp0 (_tmp32_, "") != 0;
				} else {
					_tmp30_ = FALSE;
				}
				if (_tmp30_) {
					gchar* key = NULL;
					const gchar* _tmp33_;
					gchar* _tmp34_;
					gboolean _tmp35_ = FALSE;
					gchar** _tmp36_;
					gint _tmp36__length1;
					const gchar* _tmp37_;
					GHashTable* _tmp55_;
					const gchar* _tmp56_;
					gchar* _tmp57_;
					const gchar* _tmp58_;
					gchar* _tmp59_;
					_tmp33_ = city;
					_tmp34_ = date_time_parser_format_city (_tmp33_);
					key = _tmp34_;
					_tmp36_ = items;
					_tmp36__length1 = items_length1;
					_tmp37_ = _tmp36_[3];
					if (_tmp37_ != NULL) {
						gchar** _tmp38_;
						gint _tmp38__length1;
						const gchar* _tmp39_;
						_tmp38_ = items;
						_tmp38__length1 = items_length1;
						_tmp39_ = _tmp38_[3];
						_tmp35_ = g_strcmp0 (_tmp39_, "") != 0;
					} else {
						_tmp35_ = FALSE;
					}
					if (_tmp35_) {
						gboolean _tmp40_ = FALSE;
						gboolean _tmp41_ = FALSE;
						gchar** _tmp42_;
						gint _tmp42__length1;
						const gchar* _tmp43_;
						_tmp42_ = items;
						_tmp42__length1 = items_length1;
						_tmp43_ = _tmp42_[3];
						if (g_strcmp0 (_tmp43_, "mainland") != 0) {
							gchar** _tmp44_;
							gint _tmp44__length1;
							const gchar* _tmp45_;
							_tmp44_ = items;
							_tmp44__length1 = items_length1;
							_tmp45_ = _tmp44_[3];
							_tmp41_ = g_strcmp0 (_tmp45_, "most locations") != 0;
						} else {
							_tmp41_ = FALSE;
						}
						if (_tmp41_) {
							gchar** _tmp46_;
							gint _tmp46__length1;
							const gchar* _tmp47_;
							const gchar* _tmp48_;
							_tmp46_ = items;
							_tmp46__length1 = items_length1;
							_tmp47_ = _tmp46_[3];
							_tmp48_ = key;
							_tmp40_ = g_strcmp0 (_ (_tmp47_), _tmp48_) != 0;
						} else {
							_tmp40_ = FALSE;
						}
						if (_tmp40_) {
							const gchar* _tmp49_;
							gchar** _tmp50_;
							gint _tmp50__length1;
							const gchar* _tmp51_;
							gchar* _tmp52_;
							gchar* _tmp53_;
							gchar* _tmp54_;
							_tmp49_ = key;
							_tmp50_ = items;
							_tmp50__length1 = items_length1;
							_tmp51_ = _tmp50_[3];
							_tmp52_ = date_time_parser_format_city (_ (_tmp51_));
							_tmp53_ = _tmp52_;
							_tmp54_ = g_strdup_printf ("%s - %s", _tmp49_, _tmp53_);
							_g_free0 (key);
							key = _tmp54_;
							_g_free0 (_tmp53_);
						}
					}
					_tmp55_ = timezones;
					_tmp56_ = key;
					_tmp57_ = g_strdup (_tmp56_);
					_tmp58_ = value;
					_tmp59_ = g_strdup (_tmp58_);
					g_hash_table_insert (_tmp55_, _tmp57_, _tmp59_);
					_g_free0 (key);
				}
				_g_free0 (city);
				_g_free0 (tz_name_field);
				_g_free0 (value);
				items = (_vala_array_free (items, items_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (line);
			}
		}
	}
	result = timezones;
	return result;
}

GHashTable*
date_time_parser_get_locations (DateTimeParser* self)
{
	GHashTable* locations = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GList* _tmp3_;
	GHashTable* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	locations = _tmp2_;
	_tmp3_ = self->priv->lines;
	{
		GList* line_collection = NULL;
		GList* line_it = NULL;
		line_collection = _tmp3_;
		for (line_it = line_collection; line_it != NULL; line_it = line_it->next) {
			gchar* _tmp4_;
			gchar* line = NULL;
			_tmp4_ = g_strdup ((const gchar*) line_it->data);
			line = _tmp4_;
			{
				gchar** items = NULL;
				const gchar* _tmp5_;
				gchar** _tmp6_;
				gchar** _tmp7_;
				gint items_length1;
				gint _items_size_;
				gchar* key = NULL;
				gchar** _tmp8_;
				gint _tmp8__length1;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* value = NULL;
				gchar** _tmp11_;
				gint _tmp11__length1;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				GHashTable* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				_tmp5_ = line;
				_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "\t", 4);
				items = _tmp7_;
				items_length1 = _vala_array_length (_tmp6_);
				_items_size_ = items_length1;
				_tmp8_ = items;
				_tmp8__length1 = items_length1;
				_tmp9_ = _tmp8_[1];
				_tmp10_ = g_strdup (_tmp9_);
				key = _tmp10_;
				_tmp11_ = items;
				_tmp11__length1 = items_length1;
				_tmp12_ = _tmp11_[2];
				_tmp13_ = g_strdup (_tmp12_);
				value = _tmp13_;
				_tmp14_ = locations;
				_tmp15_ = key;
				_tmp16_ = g_strdup (_tmp15_);
				_tmp17_ = value;
				_tmp18_ = g_strdup (_tmp17_);
				g_hash_table_insert (_tmp14_, _tmp16_, _tmp18_);
				_g_free0 (value);
				_g_free0 (key);
				items = (_vala_array_free (items, items_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (line);
			}
		}
	}
	result = locations;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
date_time_parser_format_city (const gchar* city)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (city != NULL, NULL);
	_tmp0_ = string_replace (city, "_", " ");
	_tmp1_ = _tmp0_;
	_tmp2_ = string_replace (_tmp1_, "/", ", ");
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static void
date_time_parser_class_init (DateTimeParserClass * klass,
                             gpointer klass_data)
{
	date_time_parser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DateTimeParser_private_offset);
	G_OBJECT_CLASS (klass)->finalize = date_time_parser_finalize;
}

static void
date_time_parser_instance_init (DateTimeParser * self,
                                gpointer klass)
{
	self->priv = date_time_parser_get_instance_private (self);
}

static void
date_time_parser_finalize (GObject * obj)
{
	DateTimeParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DATE_TIME_TYPE_PARSER, DateTimeParser);
	(self->priv->lines == NULL) ? NULL : (self->priv->lines = (_g_list_free__g_free0_ (self->priv->lines), NULL));
	G_OBJECT_CLASS (date_time_parser_parent_class)->finalize (obj);
}

static GType
date_time_parser_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DateTimeParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) date_time_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DateTimeParser), 0, (GInstanceInitFunc) date_time_parser_instance_init, NULL };
	GType date_time_parser_type_id;
	date_time_parser_type_id = g_type_register_static (G_TYPE_OBJECT, "DateTimeParser", &g_define_type_info, 0);
	DateTimeParser_private_offset = g_type_add_instance_private (date_time_parser_type_id, sizeof (DateTimeParserPrivate));
	return date_time_parser_type_id;
}

GType
date_time_parser_get_type (void)
{
	static volatile gsize date_time_parser_type_id__once = 0;
	if (g_once_init_enter (&date_time_parser_type_id__once)) {
		GType date_time_parser_type_id;
		date_time_parser_type_id = date_time_parser_get_type_once ();
		g_once_init_leave (&date_time_parser_type_id__once, date_time_parser_type_id);
	}
	return date_time_parser_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

