/* LibraryItem.c generated by valac 0.56.18, the Vala compiler
 * generated from LibraryItem.vala, do not modify */

/*
* Copyright (c) 2017 Felipe Escoto (https://github.com/Philip-Scott/Spice-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <granite.h>
#include <glib/gstdio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <pango/pango.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SPICE_WIDGETS_LIBRARY_TYPE_LIBRARY_ITEM (spice_widgets_library_library_item_get_type ())
#define SPICE_WIDGETS_LIBRARY_LIBRARY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_WIDGETS_LIBRARY_TYPE_LIBRARY_ITEM, SpiceWidgetsLibraryLibraryItem))
#define SPICE_WIDGETS_LIBRARY_LIBRARY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_WIDGETS_LIBRARY_TYPE_LIBRARY_ITEM, SpiceWidgetsLibraryLibraryItemClass))
#define SPICE_WIDGETS_LIBRARY_IS_LIBRARY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_WIDGETS_LIBRARY_TYPE_LIBRARY_ITEM))
#define SPICE_WIDGETS_LIBRARY_IS_LIBRARY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_WIDGETS_LIBRARY_TYPE_LIBRARY_ITEM))
#define SPICE_WIDGETS_LIBRARY_LIBRARY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_WIDGETS_LIBRARY_TYPE_LIBRARY_ITEM, SpiceWidgetsLibraryLibraryItemClass))

typedef struct _SpiceWidgetsLibraryLibraryItem SpiceWidgetsLibraryLibraryItem;
typedef struct _SpiceWidgetsLibraryLibraryItemClass SpiceWidgetsLibraryLibraryItemClass;
typedef struct _SpiceWidgetsLibraryLibraryItemPrivate SpiceWidgetsLibraryLibraryItemPrivate;

#define SPICE_TYPE_SLIDE_WIDGET (spice_slide_widget_get_type ())
#define SPICE_SLIDE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_SLIDE_WIDGET, SpiceSlideWidget))
#define SPICE_SLIDE_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_SLIDE_WIDGET, SpiceSlideWidgetClass))
#define SPICE_IS_SLIDE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_SLIDE_WIDGET))
#define SPICE_IS_SLIDE_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_SLIDE_WIDGET))
#define SPICE_SLIDE_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_SLIDE_WIDGET, SpiceSlideWidgetClass))

typedef struct _SpiceSlideWidget SpiceSlideWidget;
typedef struct _SpiceSlideWidgetClass SpiceSlideWidgetClass;
enum  {
	SPICE_WIDGETS_LIBRARY_LIBRARY_ITEM_0_PROPERTY,
	SPICE_WIDGETS_LIBRARY_LIBRARY_ITEM_FILE_PROPERTY,
	SPICE_WIDGETS_LIBRARY_LIBRARY_ITEM_DATA_PROPERTY,
	SPICE_WIDGETS_LIBRARY_LIBRARY_ITEM_REAL_FILE_PROPERTY,
	SPICE_WIDGETS_LIBRARY_LIBRARY_ITEM_NUM_PROPERTIES
};
static GParamSpec* spice_widgets_library_library_item_properties[SPICE_WIDGETS_LIBRARY_LIBRARY_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block26Data Block26Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SPICE_TYPE_WINDOW (spice_window_get_type ())
#define SPICE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_WINDOW, SpiceWindow))
#define SPICE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_WINDOW, SpiceWindowClass))
#define SPICE_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_WINDOW))
#define SPICE_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_WINDOW))
#define SPICE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_WINDOW, SpiceWindowClass))

typedef struct _SpiceWindow SpiceWindow;
typedef struct _SpiceWindowClass SpiceWindowClass;

#define SPICE_SERVICES_TYPE_SETTINGS (spice_services_settings_get_type ())
#define SPICE_SERVICES_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_SERVICES_TYPE_SETTINGS, SpiceServicesSettings))
#define SPICE_SERVICES_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_SERVICES_TYPE_SETTINGS, SpiceServicesSettingsClass))
#define SPICE_SERVICES_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_SERVICES_TYPE_SETTINGS))
#define SPICE_SERVICES_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_SERVICES_TYPE_SETTINGS))
#define SPICE_SERVICES_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_SERVICES_TYPE_SETTINGS, SpiceServicesSettingsClass))

typedef struct _SpiceServicesSettings SpiceServicesSettings;
typedef struct _SpiceServicesSettingsClass SpiceServicesSettingsClass;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
typedef struct _Block27Data Block27Data;
typedef struct _SpiceSlideWidgetPrivate SpiceSlideWidgetPrivate;

struct _SpiceWidgetsLibraryLibraryItem {
	GtkFlowBoxChild parent_instance;
	SpiceWidgetsLibraryLibraryItemPrivate * priv;
};

struct _SpiceWidgetsLibraryLibraryItemClass {
	GtkFlowBoxChildClass parent_class;
};

struct _SpiceWidgetsLibraryLibraryItemPrivate {
	GFile* _file;
	gchar* _data;
	SpiceSlideWidget* slide_widget;
	GtkPopover* popover;
	GtkLabel* title_label;
	gchar* last_aspect_ratio;
	gboolean _real_file;
};

struct _Block26Data {
	int _ref_count_;
	SpiceWidgetsLibraryLibraryItem* self;
	GtkEntry* name_entry;
	GtkComboBoxText* aspect_ratio;
};

struct _Block27Data {
	int _ref_count_;
	SpiceWidgetsLibraryLibraryItem* self;
	GdkPixbuf* pixbuf;
};

struct _SpiceSlideWidget {
	GtkEventBox parent_instance;
	SpiceSlideWidgetPrivate * priv;
	gboolean show_button;
	GtkRevealer* settings_revealer;
};

struct _SpiceSlideWidgetClass {
	GtkEventBoxClass parent_class;
};

static gint SpiceWidgetsLibraryLibraryItem_private_offset;
static gpointer spice_widgets_library_library_item_parent_class = NULL;
VALA_EXTERN gint spice_slide_manager_aspect_ratio_override;

VALA_EXTERN GType spice_widgets_library_library_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceWidgetsLibraryLibraryItem, g_object_unref)
VALA_EXTERN GType spice_slide_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceSlideWidget, g_object_unref)
VALA_EXTERN SpiceWidgetsLibraryLibraryItem* spice_widgets_library_library_item_new (GFile* file,
                                                                        gboolean real_file);
VALA_EXTERN SpiceWidgetsLibraryLibraryItem* spice_widgets_library_library_item_construct (GType object_type,
                                                                              GFile* file,
                                                                              gboolean real_file);
static void spice_widgets_library_library_item_get_thumbnail (SpiceWidgetsLibraryLibraryItem* self);
static void spice_widgets_library_library_item_show_popover (SpiceWidgetsLibraryLibraryItem* self);
static Block26Data* block26_data_ref (Block26Data* _data26_);
static void block26_data_unref (void * _userdata_);
VALA_EXTERN GFile* spice_widgets_library_library_item_get_file (SpiceWidgetsLibraryLibraryItem* self);
static void ___lambda120_ (Block26Data* _data26_);
static void spice_widgets_library_library_item_attempt_name_change (SpiceWidgetsLibraryLibraryItem* self,
                                                             GtkEntry* name_entry);
static void ____lambda120__gtk_entry_activate (GtkEntry* _sender,
                                        gpointer self);
VALA_EXTERN gint spice_utils_get_aspect_ratio (const gchar* raw_json);
VALA_EXTERN const gchar* spice_widgets_library_library_item_get_data (SpiceWidgetsLibraryLibraryItem* self);
static void ___lambda121_ (SpiceWidgetsLibraryLibraryItem* self);
static void ____lambda121__gtk_button_clicked (GtkButton* _sender,
                                        gpointer self);
static void ___lambda122_ (Block26Data* _data26_);
static void ____lambda122__gtk_popover_closed (GtkPopover* _sender,
                                        gpointer self);
VALA_EXTERN GType spice_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceWindow, g_object_unref)
VALA_EXTERN SpiceWindow* spice_application_get_active_spice_window (void);
VALA_EXTERN void spice_window_add_toast_notification (SpiceWindow* self,
                                          GraniteWidgetsToast* toast);
VALA_EXTERN GType spice_services_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceServicesSettings, g_object_unref)
VALA_EXTERN SpiceServicesSettings* spice_services_settings_get_instance (void);
VALA_EXTERN void spice_services_settings_add_file (SpiceServicesSettings* self,
                                       const gchar* file);
VALA_EXTERN void spice_widgets_library_library_item_set_file (SpiceWidgetsLibraryLibraryItem* self,
                                                  GFile* value);
static void spice_widgets_library_library_item_get_file_data (SpiceWidgetsLibraryLibraryItem* self);
VALA_EXTERN gchar* spice_services_file_manager_get_presentation_data (GFile* file);
VALA_EXTERN void spice_widgets_library_library_item_set_data (SpiceWidgetsLibraryLibraryItem* self,
                                                  const gchar* value);
static void spice_widgets_library_library_item_get_template_data (SpiceWidgetsLibraryLibraryItem* self);
static void* ___lambda118_ (SpiceWidgetsLibraryLibraryItem* self);
VALA_EXTERN gboolean spice_widgets_library_library_item_get_real_file (SpiceWidgetsLibraryLibraryItem* self);
static void spice_widgets_library_library_item_load_thumbnail (SpiceWidgetsLibraryLibraryItem* self,
                                                        const gchar* base64_image);
VALA_EXTERN gchar* spice_utils_get_thumbnail_data (const gchar* raw_json);
static gpointer ____lambda118__gthread_func (gpointer self);
static Block27Data* block27_data_ref (Block27Data* _data27_);
static void block27_data_unref (void * _userdata_);
VALA_EXTERN GdkPixbuf* spice_utils_base64_to_pixbuf (const gchar* base64);
static gboolean __lambda119_ (Block27Data* _data27_);
VALA_EXTERN void spice_slide_widget_set_pixbuf (SpiceSlideWidget* self,
                                    GdkPixbuf* value);
static gboolean ___lambda119__gsource_func (gpointer self);
VALA_EXTERN void spice_widgets_library_library_item_set_real_file (SpiceWidgetsLibraryLibraryItem* self,
                                                       gboolean value);
static GObject * spice_widgets_library_library_item_constructor (GType type,
                                                          guint n_construct_properties,
                                                          GObjectConstructParam * construct_properties);
VALA_EXTERN SpiceSlideWidget* spice_slide_widget_new (void);
VALA_EXTERN SpiceSlideWidget* spice_slide_widget_construct (GType object_type);
static void _spice_widgets_library_library_item___lambda123_ (SpiceWidgetsLibraryLibraryItem* self);
static void __spice_widgets_library_library_item___lambda123__spice_slide_widget_settings_requested (SpiceSlideWidget* _sender,
                                                                                              gpointer self);
static gboolean _spice_widgets_library_library_item____lambda124_ (SpiceWidgetsLibraryLibraryItem* self,
                                                            GdkEventButton* event);
static gboolean __spice_widgets_library_library_item____lambda124__gtk_widget_button_release_event (GtkWidget* _sender,
                                                                                             GdkEventButton* event,
                                                                                             gpointer self);
static void spice_widgets_library_library_item_finalize (GObject * obj);
static GType spice_widgets_library_library_item_get_type_once (void);
static void _vala_spice_widgets_library_library_item_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec);
static void _vala_spice_widgets_library_library_item_set_property (GObject * object,
                                                            guint property_id,
                                                            const GValue * value,
                                                            GParamSpec * pspec);

static inline gpointer
spice_widgets_library_library_item_get_instance_private (SpiceWidgetsLibraryLibraryItem* self)
{
	return G_STRUCT_MEMBER_P (self, SpiceWidgetsLibraryLibraryItem_private_offset);
}

SpiceWidgetsLibraryLibraryItem*
spice_widgets_library_library_item_construct (GType object_type,
                                              GFile* file,
                                              gboolean real_file)
{
	SpiceWidgetsLibraryLibraryItem * self = NULL;
#line 49 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 50 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	self = (SpiceWidgetsLibraryLibraryItem*) g_object_new (object_type, "file", file, "real-file", real_file, NULL);
#line 51 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	spice_widgets_library_library_item_get_thumbnail (self);
#line 49 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	return self;
#line 264 "LibraryItem.c"
}

SpiceWidgetsLibraryLibraryItem*
spice_widgets_library_library_item_new (GFile* file,
                                        gboolean real_file)
{
#line 49 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	return spice_widgets_library_library_item_construct (SPICE_WIDGETS_LIBRARY_TYPE_LIBRARY_ITEM, file, real_file);
#line 273 "LibraryItem.c"
}

static Block26Data*
block26_data_ref (Block26Data* _data26_)
{
#line 97 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	g_atomic_int_inc (&_data26_->_ref_count_);
#line 97 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	return _data26_;
#line 283 "LibraryItem.c"
}

static void
block26_data_unref (void * _userdata_)
{
	Block26Data* _data26_;
	_data26_ = (Block26Data*) _userdata_;
#line 97 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	if (g_atomic_int_dec_and_test (&_data26_->_ref_count_)) {
#line 293 "LibraryItem.c"
		SpiceWidgetsLibraryLibraryItem* self;
#line 97 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		self = _data26_->self;
#line 97 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_g_object_unref0 (_data26_->aspect_ratio);
#line 97 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_g_object_unref0 (_data26_->name_entry);
#line 97 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_g_object_unref0 (self);
#line 97 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		g_slice_free (Block26Data, _data26_);
#line 305 "LibraryItem.c"
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1589 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 328 "LibraryItem.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 332 "LibraryItem.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 338 "LibraryItem.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 342 "LibraryItem.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp0_) {
#line 346 "LibraryItem.c"
		gchar* _tmp2_;
#line 1590 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1590 "glib-2.0.vapi"
		result = _tmp2_;
#line 1590 "glib-2.0.vapi"
		return result;
#line 354 "LibraryItem.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1593 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1593 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1593 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1593 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1593 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1593 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1593 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1593 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 382 "LibraryItem.c"
				goto __catch0_g_regex_error;
			}
#line 1593 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1593 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1593 "glib-2.0.vapi"
			return NULL;
#line 391 "LibraryItem.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1594 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1594 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1594 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1594 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 405 "LibraryItem.c"
				goto __catch0_g_regex_error;
			}
#line 1594 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1594 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1594 "glib-2.0.vapi"
			return NULL;
#line 414 "LibraryItem.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1594 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1594 "glib-2.0.vapi"
		result = _tmp10_;
#line 1594 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1594 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
		return result;
#line 428 "LibraryItem.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1592 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1596 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 437 "LibraryItem.c"
	}
	__finally0:
#line 1592 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1592 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1592 "glib-2.0.vapi"
	return NULL;
#line 446 "LibraryItem.c"
}

static void
___lambda120_ (Block26Data* _data26_)
{
	SpiceWidgetsLibraryLibraryItem* self;
	GtkEntry* _tmp0_;
#line 103 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	self = _data26_->self;
#line 103 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp0_ = _data26_->name_entry;
#line 103 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	spice_widgets_library_library_item_attempt_name_change (self, _tmp0_);
#line 460 "LibraryItem.c"
}

static void
____lambda120__gtk_entry_activate (GtkEntry* _sender,
                                   gpointer self)
{
#line 103 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	___lambda120_ (self);
#line 469 "LibraryItem.c"
}

static void
___lambda121_ (SpiceWidgetsLibraryLibraryItem* self)
{
	GtkPopover* _tmp0_;
	GError* _inner_error0_ = NULL;
#line 124 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp0_ = self->priv->popover;
#line 124 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 481 "LibraryItem.c"
	{
		GFile* _tmp1_;
		GFile* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 127 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp1_ = spice_widgets_library_library_item_get_file (self);
#line 127 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp2_ = _tmp1_;
#line 127 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp3_ = g_file_get_parent (_tmp2_);
#line 127 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp4_ = _tmp3_;
#line 127 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp5_ = g_file_get_uri (_tmp4_);
#line 127 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp6_ = _tmp5_;
#line 127 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		g_app_info_launch_default_for_uri (_tmp6_, NULL, &_inner_error0_);
#line 127 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_g_free0 (_tmp6_);
#line 127 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_g_object_unref0 (_tmp4_);
#line 127 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 509 "LibraryItem.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
#line 126 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		e = _inner_error0_;
#line 126 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_inner_error0_ = NULL;
#line 129 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp7_ = e;
#line 129 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp8_ = _tmp7_->message;
#line 129 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		g_warning ("LibraryItem.vala:129: No default app to open folders: %s", _tmp8_);
#line 126 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_g_error_free0 (e);
#line 531 "LibraryItem.c"
	}
	__finally0:
#line 126 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 126 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 126 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		g_clear_error (&_inner_error0_);
#line 126 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		return;
#line 542 "LibraryItem.c"
	}
}

static void
____lambda121__gtk_button_clicked (GtkButton* _sender,
                                   gpointer self)
{
#line 123 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	___lambda121_ ((SpiceWidgetsLibraryLibraryItem*) self);
#line 552 "LibraryItem.c"
}

static void
___lambda122_ (Block26Data* _data26_)
{
	SpiceWidgetsLibraryLibraryItem* self;
	GtkEntry* _tmp0_;
	GtkComboBoxText* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
#line 150 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	self = _data26_->self;
#line 151 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp0_ = _data26_->name_entry;
#line 151 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	spice_widgets_library_library_item_attempt_name_change (self, _tmp0_);
#line 153 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp1_ = _data26_->aspect_ratio;
#line 153 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp2_ = gtk_combo_box_get_active_id ((GtkComboBox*) _tmp1_);
#line 153 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp3_ = self->priv->last_aspect_ratio;
#line 153 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	if (g_strcmp0 (_tmp2_, _tmp3_) != 0) {
#line 577 "LibraryItem.c"
		GtkComboBoxText* _tmp4_;
		const gchar* _tmp5_;
#line 154 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp4_ = _data26_->aspect_ratio;
#line 154 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp5_ = gtk_combo_box_get_active_id ((GtkComboBox*) _tmp4_);
#line 154 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		spice_slide_manager_aspect_ratio_override = atoi (_tmp5_);
#line 155 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		g_signal_emit_by_name ((GtkFlowBoxChild*) self, "activate");
#line 588 "LibraryItem.c"
	}
}

static void
____lambda122__gtk_popover_closed (GtkPopover* _sender,
                                   gpointer self)
{
#line 150 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	___lambda122_ (self);
#line 598 "LibraryItem.c"
}

static void
spice_widgets_library_library_item_show_popover (SpiceWidgetsLibraryLibraryItem* self)
{
	GtkPopover* _tmp0_;
	GtkPopover* _tmp51_;
#line 96 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	g_return_if_fail (self != NULL);
#line 97 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp0_ = self->priv->popover;
#line 97 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	if (_tmp0_ == NULL) {
#line 612 "LibraryItem.c"
		Block26Data* _data26_;
		GtkLabel* name_label = NULL;
		GtkLabel* _tmp1_;
		GtkLabel* _tmp2_;
		GtkEntry* _tmp3_;
		GtkEntry* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GtkEntry* _tmp11_;
		GtkLabel* ratio_label = NULL;
		GtkLabel* _tmp12_;
		GtkLabel* _tmp13_;
		GtkComboBoxText* _tmp14_;
		GtkComboBoxText* _tmp15_;
		GtkComboBoxText* _tmp16_;
		GtkComboBoxText* _tmp17_;
		GtkComboBoxText* _tmp18_;
		GtkComboBoxText* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		GtkComboBoxText* _tmp22_;
		const gchar* _tmp23_;
		GtkButton* location_button = NULL;
		GtkButton* _tmp24_;
		GtkButton* _tmp25_;
		GtkStyleContext* _tmp26_;
		GtkButton* _tmp27_;
		GtkButton* _tmp28_;
		GtkButton* _tmp29_;
		GtkGrid* grid = NULL;
		GtkGrid* _tmp30_;
		GtkGrid* _tmp31_;
		GtkGrid* _tmp32_;
		GtkGrid* _tmp33_;
		GtkGrid* _tmp34_;
		GtkButton* _tmp35_;
		GtkGrid* _tmp36_;
		GtkLabel* _tmp37_;
		GtkGrid* _tmp38_;
		GtkEntry* _tmp39_;
		GtkGrid* _tmp40_;
		GtkLabel* _tmp41_;
		GtkGrid* _tmp42_;
		GtkComboBoxText* _tmp43_;
		GtkGrid* _tmp44_;
		SpiceSlideWidget* _tmp45_;
		GtkPopover* _tmp46_;
		GtkPopover* _tmp47_;
		GtkPopover* _tmp48_;
		GtkGrid* _tmp49_;
		GtkPopover* _tmp50_;
#line 97 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_data26_ = g_slice_new0 (Block26Data);
#line 97 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_data26_->_ref_count_ = 1;
#line 97 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_data26_->self = g_object_ref (self);
#line 98 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp1_ = (GtkLabel*) gtk_label_new (_ ("Name: "));
#line 98 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		g_object_ref_sink (_tmp1_);
#line 98 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		name_label = _tmp1_;
#line 99 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp2_ = name_label;
#line 99 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		gtk_widget_set_halign ((GtkWidget*) _tmp2_, GTK_ALIGN_END);
#line 101 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp3_ = (GtkEntry*) gtk_entry_new ();
#line 101 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		g_object_ref_sink (_tmp3_);
#line 101 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_data26_->name_entry = _tmp3_;
#line 102 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp4_ = _data26_->name_entry;
#line 102 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp5_ = spice_widgets_library_library_item_get_file (self);
#line 102 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp6_ = _tmp5_;
#line 102 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp7_ = g_file_get_basename (_tmp6_);
#line 102 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp8_ = _tmp7_;
#line 102 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp9_ = string_replace (_tmp8_, ".spice", "");
#line 102 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp10_ = _tmp9_;
#line 102 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		gtk_entry_set_text (_tmp4_, _tmp10_);
#line 102 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_g_free0 (_tmp10_);
#line 102 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_g_free0 (_tmp8_);
#line 103 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp11_ = _data26_->name_entry;
#line 103 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		g_signal_connect_data (_tmp11_, "activate", (GCallback) ____lambda120__gtk_entry_activate, block26_data_ref (_data26_), (GClosureNotify) block26_data_unref, 0);
#line 105 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp12_ = (GtkLabel*) gtk_label_new (_ ("Aspect Ratio: "));
#line 105 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		g_object_ref_sink (_tmp12_);
#line 105 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		ratio_label = _tmp12_;
#line 106 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp13_ = ratio_label;
#line 106 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		gtk_widget_set_halign ((GtkWidget*) _tmp13_, GTK_ALIGN_END);
#line 108 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp14_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
#line 108 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		g_object_ref_sink (_tmp14_);
#line 108 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_data26_->aspect_ratio = _tmp14_;
#line 109 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp15_ = _data26_->aspect_ratio;
#line 109 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		gtk_combo_box_text_append (_tmp15_, "1", "4:3");
#line 110 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp16_ = _data26_->aspect_ratio;
#line 110 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		gtk_combo_box_text_append (_tmp16_, "2", "16:9");
#line 111 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp17_ = _data26_->aspect_ratio;
#line 111 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		gtk_combo_box_text_append (_tmp17_, "3", "16:10");
#line 112 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp18_ = _data26_->aspect_ratio;
#line 112 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		gtk_combo_box_text_append (_tmp18_, "4", "3:2");
#line 113 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp19_ = _data26_->aspect_ratio;
#line 113 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		gtk_combo_box_text_append (_tmp19_, "5", "5:4");
#line 115 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp20_ = self->priv->_data;
#line 115 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp21_ = g_strdup_printf ("%d", spice_utils_get_aspect_ratio (_tmp20_));
#line 115 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_g_free0 (self->priv->last_aspect_ratio);
#line 115 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		self->priv->last_aspect_ratio = _tmp21_;
#line 116 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp22_ = _data26_->aspect_ratio;
#line 116 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp23_ = self->priv->last_aspect_ratio;
#line 116 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		gtk_combo_box_set_active_id ((GtkComboBox*) _tmp22_, _tmp23_);
#line 118 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp24_ = (GtkButton*) gtk_button_new_from_icon_name ("document-open-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
#line 118 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		g_object_ref_sink (_tmp24_);
#line 118 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		location_button = _tmp24_;
#line 119 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp25_ = location_button;
#line 119 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp26_ = gtk_widget_get_style_context ((GtkWidget*) _tmp25_);
#line 119 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		gtk_style_context_add_class (_tmp26_, "flat");
#line 120 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp27_ = location_button;
#line 120 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp27_, _ ("Open file location…"));
#line 121 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp28_ = location_button;
#line 121 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		gtk_widget_set_halign ((GtkWidget*) _tmp28_, GTK_ALIGN_START);
#line 123 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp29_ = location_button;
#line 123 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		g_signal_connect_object (_tmp29_, "clicked", (GCallback) ____lambda121__gtk_button_clicked, self, 0);
#line 133 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp30_ = (GtkGrid*) gtk_grid_new ();
#line 133 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		g_object_ref_sink (_tmp30_);
#line 133 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		grid = _tmp30_;
#line 134 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp31_ = grid;
#line 134 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		gtk_grid_set_row_spacing (_tmp31_, 6);
#line 135 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp32_ = grid;
#line 135 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		gtk_grid_set_column_spacing (_tmp32_, 6);
#line 136 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp33_ = grid;
#line 136 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		g_object_set ((GtkWidget*) _tmp33_, "margin", 6, NULL);
#line 138 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp34_ = grid;
#line 138 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp35_ = location_button;
#line 138 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		gtk_grid_attach (_tmp34_, (GtkWidget*) _tmp35_, 0, 2, 1, 1);
#line 139 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp36_ = grid;
#line 139 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp37_ = name_label;
#line 139 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		gtk_grid_attach (_tmp36_, (GtkWidget*) _tmp37_, 0, 0, 1, 1);
#line 140 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp38_ = grid;
#line 140 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp39_ = _data26_->name_entry;
#line 140 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		gtk_grid_attach (_tmp38_, (GtkWidget*) _tmp39_, 1, 0, 1, 1);
#line 141 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp40_ = grid;
#line 141 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp41_ = ratio_label;
#line 141 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		gtk_grid_attach (_tmp40_, (GtkWidget*) _tmp41_, 0, 1, 1, 1);
#line 142 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp42_ = grid;
#line 142 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp43_ = _data26_->aspect_ratio;
#line 142 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		gtk_grid_attach (_tmp42_, (GtkWidget*) _tmp43_, 1, 1, 1, 1);
#line 144 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp44_ = grid;
#line 144 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		gtk_widget_show_all ((GtkWidget*) _tmp44_);
#line 146 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp45_ = self->priv->slide_widget;
#line 146 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp46_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) _tmp45_);
#line 146 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		g_object_ref_sink (_tmp46_);
#line 146 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_g_object_unref0 (self->priv->popover);
#line 146 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		self->priv->popover = _tmp46_;
#line 147 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp47_ = self->priv->popover;
#line 147 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		gtk_popover_set_position (_tmp47_, GTK_POS_LEFT);
#line 148 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp48_ = self->priv->popover;
#line 148 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp49_ = grid;
#line 148 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		gtk_container_add ((GtkContainer*) _tmp48_, (GtkWidget*) _tmp49_);
#line 150 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp50_ = self->priv->popover;
#line 150 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		g_signal_connect_data (_tmp50_, "closed", (GCallback) ____lambda122__gtk_popover_closed, block26_data_ref (_data26_), (GClosureNotify) block26_data_unref, 0);
#line 97 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_g_object_unref0 (grid);
#line 97 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_g_object_unref0 (location_button);
#line 97 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_g_object_unref0 (ratio_label);
#line 97 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_g_object_unref0 (name_label);
#line 97 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		block26_data_unref (_data26_);
#line 97 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_data26_ = NULL;
#line 876 "LibraryItem.c"
	}
#line 160 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp51_ = self->priv->popover;
#line 160 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	gtk_widget_show ((GtkWidget*) _tmp51_);
#line 882 "LibraryItem.c"
}

static void
spice_widgets_library_library_item_attempt_name_change (SpiceWidgetsLibraryLibraryItem* self,
                                                        GtkEntry* name_entry)
{
	gchar* new_name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_;
#line 163 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	g_return_if_fail (self != NULL);
#line 163 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	g_return_if_fail (name_entry != NULL);
#line 164 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp0_ = gtk_entry_get_text (name_entry);
#line 164 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp1_ = string_replace (_tmp0_, "/", "");
#line 164 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp2_ = _tmp1_;
#line 164 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp3_ = g_strconcat (_tmp2_, ".spice", NULL);
#line 164 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp4_ = _tmp3_;
#line 164 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_g_free0 (_tmp2_);
#line 164 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	new_name = _tmp4_;
#line 166 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp5_ = new_name;
#line 166 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp6_ = spice_widgets_library_library_item_get_file (self);
#line 166 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp7_ = _tmp6_;
#line 166 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp8_ = g_file_get_basename (_tmp7_);
#line 166 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp9_ = _tmp8_;
#line 166 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp10_ = g_strcmp0 (_tmp5_, _tmp9_) != 0;
#line 166 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_g_free0 (_tmp9_);
#line 166 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	if (_tmp10_) {
#line 935 "LibraryItem.c"
		gchar* path = NULL;
		GFile* _tmp11_;
		GFile* _tmp12_;
		GFile* _tmp13_;
		GFile* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		GFile* new_file = NULL;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		GFile* _tmp21_;
		GFile* _tmp22_;
		GFile* _tmp23_;
		GFile* _tmp27_;
		GFile* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		GFile* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		SpiceServicesSettings* _tmp34_;
		SpiceServicesSettings* _tmp35_;
		GFile* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		GFile* _tmp39_;
#line 167 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp11_ = spice_widgets_library_library_item_get_file (self);
#line 167 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp12_ = _tmp11_;
#line 167 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp13_ = g_file_get_parent (_tmp12_);
#line 167 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp14_ = _tmp13_;
#line 167 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp15_ = g_file_get_path (_tmp14_);
#line 167 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp16_ = _tmp15_;
#line 167 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_g_object_unref0 (_tmp14_);
#line 167 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		path = _tmp16_;
#line 168 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp17_ = path;
#line 168 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp18_ = new_name;
#line 168 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp19_ = g_strdup_printf ("%s/%s", _tmp17_, _tmp18_);
#line 168 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp20_ = _tmp19_;
#line 168 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp21_ = g_file_new_for_path (_tmp20_);
#line 168 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp22_ = _tmp21_;
#line 168 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_g_free0 (_tmp20_);
#line 168 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		new_file = _tmp22_;
#line 170 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp23_ = new_file;
#line 170 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		if (g_file_query_exists (_tmp23_, NULL)) {
#line 1000 "LibraryItem.c"
			SpiceWindow* _tmp24_;
			GraniteWidgetsToast* _tmp25_;
			GraniteWidgetsToast* _tmp26_;
#line 171 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
			_tmp24_ = spice_application_get_active_spice_window ();
#line 171 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
			_tmp25_ = granite_widgets_toast_new (_ ("Could not rename: File already exists…"));
#line 171 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
			g_object_ref_sink (_tmp25_);
#line 171 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
			_tmp26_ = _tmp25_;
#line 171 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
			spice_window_add_toast_notification (_tmp24_, _tmp26_);
#line 171 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
			_g_object_unref0 (_tmp26_);
#line 172 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
			_g_object_unref0 (new_file);
#line 172 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
			_g_free0 (path);
#line 172 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
			_g_free0 (new_name);
#line 172 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
			return;
#line 1024 "LibraryItem.c"
		}
#line 175 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp27_ = spice_widgets_library_library_item_get_file (self);
#line 175 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp28_ = _tmp27_;
#line 175 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp29_ = g_file_get_path (_tmp28_);
#line 175 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp30_ = _tmp29_;
#line 175 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp31_ = new_file;
#line 175 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp32_ = g_file_get_path (_tmp31_);
#line 175 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp33_ = _tmp32_;
#line 175 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		g_rename (_tmp30_, _tmp33_);
#line 175 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_g_free0 (_tmp33_);
#line 175 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_g_free0 (_tmp30_);
#line 176 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp34_ = spice_services_settings_get_instance ();
#line 176 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp35_ = _tmp34_;
#line 176 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp36_ = new_file;
#line 176 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp37_ = g_file_get_path (_tmp36_);
#line 176 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp38_ = _tmp37_;
#line 176 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		spice_services_settings_add_file (_tmp35_, _tmp38_);
#line 176 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_g_free0 (_tmp38_);
#line 176 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_g_object_unref0 (_tmp35_);
#line 178 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp39_ = new_file;
#line 178 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		spice_widgets_library_library_item_set_file (self, _tmp39_);
#line 166 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_g_object_unref0 (new_file);
#line 166 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_g_free0 (path);
#line 1070 "LibraryItem.c"
	}
#line 163 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_g_free0 (new_name);
#line 1074 "LibraryItem.c"
}

static void
spice_widgets_library_library_item_get_file_data (SpiceWidgetsLibraryLibraryItem* self)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 182 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	g_return_if_fail (self != NULL);
#line 183 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp0_ = spice_widgets_library_library_item_get_file (self);
#line 183 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp1_ = _tmp0_;
#line 183 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp2_ = spice_services_file_manager_get_presentation_data (_tmp1_);
#line 183 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp3_ = _tmp2_;
#line 183 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	spice_widgets_library_library_item_set_data (self, _tmp3_);
#line 183 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_g_free0 (_tmp3_);
#line 1098 "LibraryItem.c"
}

static void
spice_widgets_library_library_item_get_template_data (SpiceWidgetsLibraryLibraryItem* self)
{
	GFileInputStream* _tmp0_ = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFileInputStream* _tmp3_;
	GDataInputStream* dis = NULL;
	GDataInputStream* _tmp4_;
	gsize size = 0UL;
	gchar* _tmp5_ = NULL;
	GDataInputStream* _tmp6_;
	gsize _tmp7_ = 0UL;
	gchar* _tmp8_;
	GError* _inner_error0_ = NULL;
#line 186 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	g_return_if_fail (self != NULL);
#line 187 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp1_ = spice_widgets_library_library_item_get_file (self);
#line 187 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp2_ = _tmp1_;
#line 187 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp3_ = g_file_read (_tmp2_, NULL, &_inner_error0_);
#line 187 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp0_ = _tmp3_;
#line 187 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 187 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 187 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		g_clear_error (&_inner_error0_);
#line 187 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		return;
#line 1134 "LibraryItem.c"
	}
#line 187 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp4_ = g_data_input_stream_new ((GInputStream*) _tmp0_);
#line 187 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	dis = _tmp4_;
#line 190 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp6_ = dis;
#line 190 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp8_ = g_data_input_stream_read_upto (_tmp6_, "\0", (gssize) -1, &_tmp7_, NULL, &_inner_error0_);
#line 190 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	size = _tmp7_;
#line 190 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp5_ = _tmp8_;
#line 190 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 190 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_g_object_unref0 (dis);
#line 190 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_g_object_unref0 (_tmp0_);
#line 190 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 190 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		g_clear_error (&_inner_error0_);
#line 190 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		return;
#line 1160 "LibraryItem.c"
	}
#line 190 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	spice_widgets_library_library_item_set_data (self, _tmp5_);
#line 186 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_g_free0 (_tmp5_);
#line 186 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_g_object_unref0 (dis);
#line 186 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_g_object_unref0 (_tmp0_);
#line 1170 "LibraryItem.c"
}

static void*
___lambda118_ (SpiceWidgetsLibraryLibraryItem* self)
{
	gboolean _tmp0_;
	void* result;
#line 196 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp0_ = self->priv->_real_file;
#line 196 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	if (_tmp0_) {
#line 1182 "LibraryItem.c"
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
#line 197 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		spice_widgets_library_library_item_get_file_data (self);
#line 198 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp1_ = self->priv->_data;
#line 198 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp2_ = spice_utils_get_thumbnail_data (_tmp1_);
#line 198 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp3_ = _tmp2_;
#line 198 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		spice_widgets_library_library_item_load_thumbnail (self, _tmp3_);
#line 198 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_g_free0 (_tmp3_);
#line 1198 "LibraryItem.c"
	} else {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 200 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		spice_widgets_library_library_item_get_template_data (self);
#line 201 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp4_ = self->priv->_data;
#line 201 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp5_ = spice_utils_get_thumbnail_data (_tmp4_);
#line 201 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp6_ = _tmp5_;
#line 201 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		spice_widgets_library_library_item_load_thumbnail (self, _tmp6_);
#line 201 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_g_free0 (_tmp6_);
#line 1215 "LibraryItem.c"
	}
#line 204 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	result = NULL;
#line 204 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	return result;
#line 1221 "LibraryItem.c"
}

static gpointer
____lambda118__gthread_func (gpointer self)
{
	gpointer result;
	result = ___lambda118_ ((SpiceWidgetsLibraryLibraryItem*) self);
#line 195 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	g_object_unref (self);
#line 195 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	return result;
#line 1233 "LibraryItem.c"
}

static void
spice_widgets_library_library_item_get_thumbnail (SpiceWidgetsLibraryLibraryItem* self)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
#line 193 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	g_return_if_fail (self != NULL);
#line 194 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp0_ = spice_widgets_library_library_item_get_file (self);
#line 194 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp1_ = _tmp0_;
#line 194 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	if (g_file_query_exists (_tmp1_, NULL)) {
#line 1249 "LibraryItem.c"
		GThread* _tmp2_;
		GThread* _tmp3_;
#line 195 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp2_ = g_thread_new ("content-loading", ____lambda118__gthread_func, g_object_ref (self));
#line 195 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp3_ = _tmp2_;
#line 195 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_g_thread_unref0 (_tmp3_);
#line 1258 "LibraryItem.c"
	}
}

static Block27Data*
block27_data_ref (Block27Data* _data27_)
{
#line 209 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	g_atomic_int_inc (&_data27_->_ref_count_);
#line 209 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	return _data27_;
#line 1269 "LibraryItem.c"
}

static void
block27_data_unref (void * _userdata_)
{
	Block27Data* _data27_;
	_data27_ = (Block27Data*) _userdata_;
#line 209 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	if (g_atomic_int_dec_and_test (&_data27_->_ref_count_)) {
#line 1279 "LibraryItem.c"
		SpiceWidgetsLibraryLibraryItem* self;
#line 209 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		self = _data27_->self;
#line 209 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_g_object_unref0 (_data27_->pixbuf);
#line 209 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_g_object_unref0 (self);
#line 209 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		g_slice_free (Block27Data, _data27_);
#line 1289 "LibraryItem.c"
	}
}

static gboolean
__lambda119_ (Block27Data* _data27_)
{
	SpiceWidgetsLibraryLibraryItem* self;
	SpiceSlideWidget* _tmp0_;
	gboolean result;
#line 212 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	self = _data27_->self;
#line 213 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp0_ = self->priv->slide_widget;
#line 213 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	spice_slide_widget_set_pixbuf (_tmp0_, _data27_->pixbuf);
#line 214 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	result = G_SOURCE_REMOVE;
#line 214 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	return result;
#line 1309 "LibraryItem.c"
}

static gboolean
___lambda119__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda119_ (self);
#line 212 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	return result;
#line 1319 "LibraryItem.c"
}

static void
spice_widgets_library_library_item_load_thumbnail (SpiceWidgetsLibraryLibraryItem* self,
                                                   const gchar* base64_image)
{
	Block27Data* _data27_;
	GdkPixbuf* _tmp0_;
#line 209 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	g_return_if_fail (self != NULL);
#line 209 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	g_return_if_fail (base64_image != NULL);
#line 209 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_data27_ = g_slice_new0 (Block27Data);
#line 209 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_data27_->_ref_count_ = 1;
#line 209 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_data27_->self = g_object_ref (self);
#line 210 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp0_ = spice_utils_base64_to_pixbuf (base64_image);
#line 210 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_data27_->pixbuf = _tmp0_;
#line 212 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda119__gsource_func, block27_data_ref (_data27_), block27_data_unref);
#line 209 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	block27_data_unref (_data27_);
#line 209 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_data27_ = NULL;
#line 1348 "LibraryItem.c"
}

GFile*
spice_widgets_library_library_item_get_file (SpiceWidgetsLibraryLibraryItem* self)
{
	GFile* result;
	GFile* _tmp0_;
#line 25 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 26 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp0_ = self->priv->_file;
#line 26 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	result = _tmp0_;
#line 26 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	return result;
#line 1364 "LibraryItem.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 28 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	return self ? g_object_ref (self) : NULL;
#line 1372 "LibraryItem.c"
}

void
spice_widgets_library_library_item_set_file (SpiceWidgetsLibraryLibraryItem* self,
                                             GFile* value)
{
	GFile* _tmp0_;
	GtkLabel* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
#line 27 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	g_return_if_fail (self != NULL);
#line 28 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp0_ = _g_object_ref0 (value);
#line 28 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_g_object_unref0 (self->priv->_file);
#line 28 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	self->priv->_file = _tmp0_;
#line 29 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp1_ = self->priv->title_label;
#line 29 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp2_ = spice_widgets_library_library_item_get_file (self);
#line 29 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp3_ = _tmp2_;
#line 29 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp4_ = g_file_get_basename (_tmp3_);
#line 29 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp5_ = _tmp4_;
#line 29 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp6_ = string_replace (_tmp5_, ".spice", "");
#line 29 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp7_ = _tmp6_;
#line 29 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	gtk_label_set_label (_tmp1_, _tmp7_);
#line 29 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_g_free0 (_tmp7_);
#line 29 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_g_free0 (_tmp5_);
#line 31 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp8_ = self->priv->_real_file;
#line 31 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	if (_tmp8_) {
#line 1420 "LibraryItem.c"
		GFile* _tmp9_;
		GFile* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
#line 32 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp9_ = spice_widgets_library_library_item_get_file (self);
#line 32 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp10_ = _tmp9_;
#line 32 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp11_ = g_file_get_path (_tmp10_);
#line 32 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp12_ = _tmp11_;
#line 32 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp13_ = g_strdup_printf (_ ("Open: %s"), _tmp12_);
#line 32 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp14_ = _tmp13_;
#line 32 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp14_);
#line 32 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_g_free0 (_tmp14_);
#line 32 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_g_free0 (_tmp12_);
#line 1445 "LibraryItem.c"
	} else {
#line 34 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		gtk_widget_set_tooltip_text ((GtkWidget*) self, _ ("Create Presentation"));
#line 1449 "LibraryItem.c"
	}
#line 27 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	g_object_notify_by_pspec ((GObject *) self, spice_widgets_library_library_item_properties[SPICE_WIDGETS_LIBRARY_LIBRARY_ITEM_FILE_PROPERTY]);
#line 1453 "LibraryItem.c"
}

const gchar*
spice_widgets_library_library_item_get_data (SpiceWidgetsLibraryLibraryItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 39 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 39 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp0_ = self->priv->_data;
#line 39 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	result = _tmp0_;
#line 39 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	return result;
#line 1469 "LibraryItem.c"
}

void
spice_widgets_library_library_item_set_data (SpiceWidgetsLibraryLibraryItem* self,
                                             const gchar* value)
{
	gchar* old_value;
#line 39 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	g_return_if_fail (self != NULL);
#line 39 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	old_value = spice_widgets_library_library_item_get_data (self);
#line 39 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1483 "LibraryItem.c"
		gchar* _tmp0_;
#line 39 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp0_ = g_strdup (value);
#line 39 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_g_free0 (self->priv->_data);
#line 39 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		self->priv->_data = _tmp0_;
#line 39 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_widgets_library_library_item_properties[SPICE_WIDGETS_LIBRARY_LIBRARY_ITEM_DATA_PROPERTY]);
#line 1493 "LibraryItem.c"
	}
}

gboolean
spice_widgets_library_library_item_get_real_file (SpiceWidgetsLibraryLibraryItem* self)
{
	gboolean result;
#line 47 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 47 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	result = self->priv->_real_file;
#line 47 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	return result;
#line 1507 "LibraryItem.c"
}

void
spice_widgets_library_library_item_set_real_file (SpiceWidgetsLibraryLibraryItem* self,
                                                  gboolean value)
{
	gboolean old_value;
#line 47 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	g_return_if_fail (self != NULL);
#line 47 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	old_value = spice_widgets_library_library_item_get_real_file (self);
#line 47 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	if (old_value != value) {
#line 47 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		self->priv->_real_file = value;
#line 47 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_widgets_library_library_item_properties[SPICE_WIDGETS_LIBRARY_LIBRARY_ITEM_REAL_FILE_PROPERTY]);
#line 1525 "LibraryItem.c"
	}
}

static void
_spice_widgets_library_library_item___lambda123_ (SpiceWidgetsLibraryLibraryItem* self)
{
#line 64 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	spice_widgets_library_library_item_show_popover (self);
#line 1534 "LibraryItem.c"
}

static void
__spice_widgets_library_library_item___lambda123__spice_slide_widget_settings_requested (SpiceSlideWidget* _sender,
                                                                                         gpointer self)
{
#line 63 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_spice_widgets_library_library_item___lambda123_ ((SpiceWidgetsLibraryLibraryItem*) self);
#line 1543 "LibraryItem.c"
}

static gboolean
_spice_widgets_library_library_item____lambda124_ (SpiceWidgetsLibraryLibraryItem* self,
                                                   GdkEventButton* event)
{
	gboolean result;
#line 87 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 88 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	if (event->button != ((guint) 3)) {
#line 88 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		result = FALSE;
#line 88 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		return result;
#line 1559 "LibraryItem.c"
	}
#line 89 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	spice_widgets_library_library_item_show_popover (self);
#line 91 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	result = TRUE;
#line 91 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	return result;
#line 1567 "LibraryItem.c"
}

static gboolean
__spice_widgets_library_library_item____lambda124__gtk_widget_button_release_event (GtkWidget* _sender,
                                                                                    GdkEventButton* event,
                                                                                    gpointer self)
{
	gboolean result;
	result = _spice_widgets_library_library_item____lambda124_ ((SpiceWidgetsLibraryLibraryItem*) self, event);
#line 87 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	return result;
#line 1579 "LibraryItem.c"
}

static GObject *
spice_widgets_library_library_item_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SpiceWidgetsLibraryLibraryItem * self;
	GtkEventBox* event_box = NULL;
	GtkEventBox* _tmp0_;
	GtkEventBox* _tmp1_;
	GtkEventBox* _tmp2_;
	GdkEventMask _tmp3_;
	GdkEventMask _tmp4_;
	SpiceSlideWidget* _tmp5_;
	SpiceSlideWidget* _tmp6_;
	gboolean _tmp7_;
	SpiceSlideWidget* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkStyleContext* _tmp11_;
	GtkLabel* _tmp12_;
	GtkStyleContext* _tmp13_;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	GtkLabel* _tmp18_;
	GtkGrid* box = NULL;
	GtkGrid* _tmp19_;
	GtkGrid* _tmp20_;
	GtkGrid* _tmp21_;
	SpiceSlideWidget* _tmp22_;
	GtkGrid* _tmp23_;
	GtkLabel* _tmp24_;
	GtkEventBox* _tmp25_;
	GtkGrid* _tmp26_;
	GtkEventBox* _tmp27_;
	gboolean _tmp28_;
#line 54 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	parent_class = G_OBJECT_CLASS (spice_widgets_library_library_item_parent_class);
#line 54 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 54 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_WIDGETS_LIBRARY_TYPE_LIBRARY_ITEM, SpiceWidgetsLibraryLibraryItem);
#line 55 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	gtk_widget_set_margin_top ((GtkWidget*) self, 3);
#line 56 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_CENTER);
#line 58 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp0_ = (GtkEventBox*) gtk_event_box_new ();
#line 58 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	g_object_ref_sink (_tmp0_);
#line 58 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	event_box = _tmp0_;
#line 59 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp1_ = event_box;
#line 59 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp2_ = event_box;
#line 59 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp3_ = gtk_widget_get_events ((GtkWidget*) _tmp2_);
#line 59 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp4_ = _tmp3_;
#line 59 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	gtk_widget_set_events ((GtkWidget*) _tmp2_, _tmp4_ | GDK_BUTTON_RELEASE_MASK);
#line 61 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp5_ = spice_slide_widget_new ();
#line 61 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	g_object_ref_sink (_tmp5_);
#line 61 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_g_object_unref0 (self->priv->slide_widget);
#line 61 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	self->priv->slide_widget = _tmp5_;
#line 62 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp6_ = self->priv->slide_widget;
#line 62 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp7_ = self->priv->_real_file;
#line 62 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp6_->show_button = _tmp7_;
#line 63 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp8_ = self->priv->slide_widget;
#line 63 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	g_signal_connect_object (_tmp8_, "settings-requested", (GCallback) __spice_widgets_library_library_item___lambda123__spice_slide_widget_settings_requested, self, 0);
#line 67 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp9_ = (GtkLabel*) gtk_label_new ("");
#line 67 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	g_object_ref_sink (_tmp9_);
#line 67 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_g_object_unref0 (self->priv->title_label);
#line 67 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	self->priv->title_label = _tmp9_;
#line 68 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp10_ = self->priv->title_label;
#line 68 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) _tmp10_);
#line 68 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	gtk_style_context_add_class (_tmp11_, GRANITE_STYLE_CLASS_H4_LABEL);
#line 69 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp12_ = self->priv->title_label;
#line 69 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) _tmp12_);
#line 69 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	gtk_style_context_add_class (_tmp13_, "remove-padding");
#line 70 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp14_ = self->priv->title_label;
#line 70 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	gtk_label_set_ellipsize (_tmp14_, PANGO_ELLIPSIZE_END);
#line 71 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp15_ = self->priv->title_label;
#line 71 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp15_, GTK_ALIGN_START);
#line 72 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp16_ = self->priv->title_label;
#line 72 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	gtk_widget_set_margin_start ((GtkWidget*) _tmp16_, 8);
#line 73 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp17_ = self->priv->title_label;
#line 73 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	gtk_widget_set_margin_end ((GtkWidget*) _tmp17_, 8);
#line 74 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp18_ = self->priv->title_label;
#line 74 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp18_, 6);
#line 76 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp19_ = (GtkGrid*) gtk_grid_new ();
#line 76 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	g_object_ref_sink (_tmp19_);
#line 76 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	box = _tmp19_;
#line 77 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp20_ = box;
#line 77 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp20_, GTK_ORIENTATION_VERTICAL);
#line 78 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp21_ = box;
#line 78 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp22_ = self->priv->slide_widget;
#line 78 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
#line 79 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp23_ = box;
#line 79 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp24_ = self->priv->title_label;
#line 79 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
#line 81 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp25_ = event_box;
#line 81 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp26_ = box;
#line 81 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	gtk_container_add ((GtkContainer*) _tmp25_, (GtkWidget*) _tmp26_);
#line 82 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp27_ = event_box;
#line 82 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp27_);
#line 84 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	gtk_widget_show_all ((GtkWidget*) self);
#line 86 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_tmp28_ = self->priv->_real_file;
#line 86 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	if (_tmp28_) {
#line 1743 "LibraryItem.c"
		GtkEventBox* _tmp29_;
#line 87 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		_tmp29_ = event_box;
#line 87 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		g_signal_connect_object ((GtkWidget*) _tmp29_, "button-release-event", (GCallback) __spice_widgets_library_library_item____lambda124__gtk_widget_button_release_event, self, 0);
#line 1749 "LibraryItem.c"
	}
#line 54 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_g_object_unref0 (box);
#line 54 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_g_object_unref0 (event_box);
#line 54 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	return obj;
#line 1757 "LibraryItem.c"
}

static void
spice_widgets_library_library_item_class_init (SpiceWidgetsLibraryLibraryItemClass * klass,
                                               gpointer klass_data)
{
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	spice_widgets_library_library_item_parent_class = g_type_class_peek_parent (klass);
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	g_type_class_adjust_private_offset (klass, &SpiceWidgetsLibraryLibraryItem_private_offset);
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_spice_widgets_library_library_item_get_property;
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_spice_widgets_library_library_item_set_property;
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	G_OBJECT_CLASS (klass)->constructor = spice_widgets_library_library_item_constructor;
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	G_OBJECT_CLASS (klass)->finalize = spice_widgets_library_library_item_finalize;
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_WIDGETS_LIBRARY_LIBRARY_ITEM_FILE_PROPERTY, spice_widgets_library_library_item_properties[SPICE_WIDGETS_LIBRARY_LIBRARY_ITEM_FILE_PROPERTY] = g_param_spec_object ("file", "file", "file", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_WIDGETS_LIBRARY_LIBRARY_ITEM_DATA_PROPERTY, spice_widgets_library_library_item_properties[SPICE_WIDGETS_LIBRARY_LIBRARY_ITEM_DATA_PROPERTY] = g_param_spec_string ("data", "data", "data", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_WIDGETS_LIBRARY_LIBRARY_ITEM_REAL_FILE_PROPERTY, spice_widgets_library_library_item_properties[SPICE_WIDGETS_LIBRARY_LIBRARY_ITEM_REAL_FILE_PROPERTY] = g_param_spec_boolean ("real-file", "real-file", "real-file", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 1782 "LibraryItem.c"
}

static void
spice_widgets_library_library_item_instance_init (SpiceWidgetsLibraryLibraryItem * self,
                                                  gpointer klass)
{
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	self->priv = spice_widgets_library_library_item_get_instance_private (self);
#line 42 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	self->priv->popover = NULL;
#line 1793 "LibraryItem.c"
}

static void
spice_widgets_library_library_item_finalize (GObject * obj)
{
	SpiceWidgetsLibraryLibraryItem * self;
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_WIDGETS_LIBRARY_TYPE_LIBRARY_ITEM, SpiceWidgetsLibraryLibraryItem);
#line 23 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_g_object_unref0 (self->priv->_file);
#line 39 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_g_free0 (self->priv->_data);
#line 41 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_g_object_unref0 (self->priv->slide_widget);
#line 42 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_g_object_unref0 (self->priv->popover);
#line 43 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_g_object_unref0 (self->priv->title_label);
#line 45 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	_g_free0 (self->priv->last_aspect_ratio);
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	G_OBJECT_CLASS (spice_widgets_library_library_item_parent_class)->finalize (obj);
#line 1816 "LibraryItem.c"
}

static GType
spice_widgets_library_library_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpiceWidgetsLibraryLibraryItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_widgets_library_library_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpiceWidgetsLibraryLibraryItem), 0, (GInstanceInitFunc) spice_widgets_library_library_item_instance_init, NULL };
	GType spice_widgets_library_library_item_type_id;
	spice_widgets_library_library_item_type_id = g_type_register_static (gtk_flow_box_child_get_type (), "SpiceWidgetsLibraryLibraryItem", &g_define_type_info, 0);
	SpiceWidgetsLibraryLibraryItem_private_offset = g_type_add_instance_private (spice_widgets_library_library_item_type_id, sizeof (SpiceWidgetsLibraryLibraryItemPrivate));
	return spice_widgets_library_library_item_type_id;
}

GType
spice_widgets_library_library_item_get_type (void)
{
	static volatile gsize spice_widgets_library_library_item_type_id__once = 0;
	if (g_once_init_enter (&spice_widgets_library_library_item_type_id__once)) {
		GType spice_widgets_library_library_item_type_id;
		spice_widgets_library_library_item_type_id = spice_widgets_library_library_item_get_type_once ();
		g_once_init_leave (&spice_widgets_library_library_item_type_id__once, spice_widgets_library_library_item_type_id);
	}
	return spice_widgets_library_library_item_type_id__once;
}

static void
_vala_spice_widgets_library_library_item_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec)
{
	SpiceWidgetsLibraryLibraryItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_WIDGETS_LIBRARY_TYPE_LIBRARY_ITEM, SpiceWidgetsLibraryLibraryItem);
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	switch (property_id) {
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		case SPICE_WIDGETS_LIBRARY_LIBRARY_ITEM_FILE_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		g_value_set_object (value, spice_widgets_library_library_item_get_file (self));
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		case SPICE_WIDGETS_LIBRARY_LIBRARY_ITEM_DATA_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		g_value_set_string (value, spice_widgets_library_library_item_get_data (self));
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		case SPICE_WIDGETS_LIBRARY_LIBRARY_ITEM_REAL_FILE_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		g_value_set_boolean (value, spice_widgets_library_library_item_get_real_file (self));
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		break;
#line 1869 "LibraryItem.c"
		default:
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		break;
#line 1875 "LibraryItem.c"
	}
}

static void
_vala_spice_widgets_library_library_item_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec)
{
	SpiceWidgetsLibraryLibraryItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_WIDGETS_LIBRARY_TYPE_LIBRARY_ITEM, SpiceWidgetsLibraryLibraryItem);
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
	switch (property_id) {
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		case SPICE_WIDGETS_LIBRARY_LIBRARY_ITEM_FILE_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		spice_widgets_library_library_item_set_file (self, g_value_get_object (value));
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		case SPICE_WIDGETS_LIBRARY_LIBRARY_ITEM_DATA_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		spice_widgets_library_library_item_set_data (self, g_value_get_string (value));
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		case SPICE_WIDGETS_LIBRARY_LIBRARY_ITEM_REAL_FILE_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		spice_widgets_library_library_item_set_real_file (self, g_value_get_boolean (value));
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		break;
#line 1907 "LibraryItem.c"
		default:
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "../Spice-up-1.9.1/src/Widgets/Library/LibraryItem.vala"
		break;
#line 1913 "LibraryItem.c"
	}
}

