/* client functions auto-generated by pidl */

#include "includes.h"
#include <tevent.h>
#include "lib/util/tevent_ntstatus.h"
#include "bin/default/librpc/gen_ndr/ndr_clusapi.h"
#include "bin/default/librpc/gen_ndr/ndr_clusapi_c.h"

/* clusapi - client functions generated by pidl */

struct dcerpc_clusapi_OpenCluster_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OpenCluster_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OpenCluster_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_OpenCluster *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OpenCluster_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OpenCluster_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OPENCLUSTER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OpenCluster_r_done, req);

	return req;
}

static void dcerpc_clusapi_OpenCluster_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OpenCluster_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OpenCluster_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_OpenCluster_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OpenCluster_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_OpenCluster *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OPENCLUSTER, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_OpenCluster_state {
	struct clusapi_OpenCluster orig;
	struct clusapi_OpenCluster tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OpenCluster_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OpenCluster_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   WERROR *_Status /* [out] [ref] */,
						   struct policy_handle *_Cluster /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OpenCluster_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OpenCluster_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */
	state->orig.out.Status = _Status;
	state->orig.out.Cluster = _Cluster;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_OpenCluster_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_OpenCluster_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OpenCluster_done, req);
	return req;
}

static void dcerpc_clusapi_OpenCluster_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_OpenCluster_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OpenCluster_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_OpenCluster_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.Status = *state->tmp.out.Status;
	*state->orig.out.Cluster = *state->tmp.out.Cluster;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OpenCluster_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OpenCluster_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OpenCluster_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OpenCluster(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    WERROR *_Status /* [out] [ref] */,
				    struct policy_handle *_Cluster /* [out] [ref] */)
{
	struct clusapi_OpenCluster r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */
	r.out.Status = _Status;
	r.out.Cluster = _Cluster;

	status = dcerpc_clusapi_OpenCluster_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_Status = *r.out.Status;
	*_Cluster = *r.out.Cluster;

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_CloseCluster_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CloseCluster_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CloseCluster_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_CloseCluster *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CloseCluster_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CloseCluster_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CLOSECLUSTER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CloseCluster_r_done, req);

	return req;
}

static void dcerpc_clusapi_CloseCluster_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CloseCluster_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CloseCluster_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_CloseCluster_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CloseCluster_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_CloseCluster *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CLOSECLUSTER, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_CloseCluster_state {
	struct clusapi_CloseCluster orig;
	struct clusapi_CloseCluster tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CloseCluster_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CloseCluster_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle *_Cluster /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CloseCluster_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CloseCluster_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.Cluster = _Cluster;

	/* Out parameters */
	state->orig.out.Cluster = _Cluster;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_CloseCluster_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_CloseCluster_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CloseCluster_done, req);
	return req;
}

static void dcerpc_clusapi_CloseCluster_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_CloseCluster_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CloseCluster_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_CloseCluster_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.Cluster = *state->tmp.out.Cluster;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CloseCluster_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_clusapi_CloseCluster_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CloseCluster_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CloseCluster(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *_Cluster /* [in,out] [ref] */,
				     WERROR *result)
{
	struct clusapi_CloseCluster r;
	NTSTATUS status;

	/* In parameters */
	r.in.Cluster = _Cluster;

	/* Out parameters */
	r.out.Cluster = _Cluster;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_CloseCluster_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_Cluster = *r.out.Cluster;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_SetClusterName_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_SetClusterName_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_SetClusterName_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_SetClusterName *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_SetClusterName_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_SetClusterName_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_SETCLUSTERNAME, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_SetClusterName_r_done, req);

	return req;
}

static void dcerpc_clusapi_SetClusterName_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_SetClusterName_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_SetClusterName_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_SetClusterName_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_SetClusterName_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_SetClusterName *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_SETCLUSTERNAME, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_SetClusterName_state {
	struct clusapi_SetClusterName orig;
	struct clusapi_SetClusterName tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_SetClusterName_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_SetClusterName_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      const char *_NewClusterName /* [in] [charset(UTF16),ref] */,
						      WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_SetClusterName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_SetClusterName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.NewClusterName = _NewClusterName;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_SetClusterName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_SetClusterName_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_SetClusterName_done, req);
	return req;
}

static void dcerpc_clusapi_SetClusterName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_SetClusterName_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_SetClusterName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_SetClusterName_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_SetClusterName_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_clusapi_SetClusterName_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_SetClusterName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_SetClusterName(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       const char *_NewClusterName /* [in] [charset(UTF16),ref] */,
				       WERROR *_rpc_status /* [out] [ref] */,
				       WERROR *result)
{
	struct clusapi_SetClusterName r;
	NTSTATUS status;

	/* In parameters */
	r.in.NewClusterName = _NewClusterName;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_SetClusterName_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_GetClusterName_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetClusterName_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetClusterName_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_GetClusterName *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetClusterName_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetClusterName_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETCLUSTERNAME, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetClusterName_r_done, req);

	return req;
}

static void dcerpc_clusapi_GetClusterName_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetClusterName_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_GetClusterName_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_GetClusterName_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetClusterName_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_GetClusterName *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETCLUSTERNAME, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_GetClusterName_state {
	struct clusapi_GetClusterName orig;
	struct clusapi_GetClusterName tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetClusterName_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetClusterName_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      const char **_ClusterName /* [out] [charset(UTF16),ref] */,
						      const char **_NodeName /* [out] [charset(UTF16),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetClusterName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetClusterName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */
	state->orig.out.ClusterName = _ClusterName;
	state->orig.out.NodeName = _NodeName;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_GetClusterName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_GetClusterName_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetClusterName_done, req);
	return req;
}

static void dcerpc_clusapi_GetClusterName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_GetClusterName_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetClusterName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_GetClusterName_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ClusterName = *state->tmp.out.ClusterName;
	*state->orig.out.NodeName = *state->tmp.out.NodeName;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetClusterName_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_clusapi_GetClusterName_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetClusterName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetClusterName(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       const char **_ClusterName /* [out] [charset(UTF16),ref] */,
				       const char **_NodeName /* [out] [charset(UTF16),ref] */,
				       WERROR *result)
{
	struct clusapi_GetClusterName r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */
	r.out.ClusterName = _ClusterName;
	r.out.NodeName = _NodeName;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_GetClusterName_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ClusterName = *r.out.ClusterName;
	*_NodeName = *r.out.NodeName;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_GetClusterVersion_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetClusterVersion_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetClusterVersion_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_GetClusterVersion *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetClusterVersion_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetClusterVersion_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETCLUSTERVERSION, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetClusterVersion_r_done, req);

	return req;
}

static void dcerpc_clusapi_GetClusterVersion_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetClusterVersion_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_GetClusterVersion_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_GetClusterVersion_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetClusterVersion_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_GetClusterVersion *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETCLUSTERVERSION, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_GetClusterVersion_state {
	struct clusapi_GetClusterVersion orig;
	struct clusapi_GetClusterVersion tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetClusterVersion_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetClusterVersion_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 uint16_t *_lpwMajorVersion /* [out] [ref] */,
							 uint16_t *_lpwMinorVersion /* [out] [ref] */,
							 uint16_t *_lpwBuildNumber /* [out] [ref] */,
							 const char **_lpszVendorId /* [out] [charset(UTF16),ref] */,
							 const char **_lpszCSDVersion /* [out] [charset(UTF16),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetClusterVersion_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetClusterVersion_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */
	state->orig.out.lpwMajorVersion = _lpwMajorVersion;
	state->orig.out.lpwMinorVersion = _lpwMinorVersion;
	state->orig.out.lpwBuildNumber = _lpwBuildNumber;
	state->orig.out.lpszVendorId = _lpszVendorId;
	state->orig.out.lpszCSDVersion = _lpszCSDVersion;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_GetClusterVersion_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_GetClusterVersion_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetClusterVersion_done, req);
	return req;
}

static void dcerpc_clusapi_GetClusterVersion_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_GetClusterVersion_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetClusterVersion_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_GetClusterVersion_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.lpwMajorVersion = *state->tmp.out.lpwMajorVersion;
	*state->orig.out.lpwMinorVersion = *state->tmp.out.lpwMinorVersion;
	*state->orig.out.lpwBuildNumber = *state->tmp.out.lpwBuildNumber;
	*state->orig.out.lpszVendorId = *state->tmp.out.lpszVendorId;
	*state->orig.out.lpszCSDVersion = *state->tmp.out.lpszCSDVersion;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetClusterVersion_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_clusapi_GetClusterVersion_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetClusterVersion_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetClusterVersion(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  uint16_t *_lpwMajorVersion /* [out] [ref] */,
					  uint16_t *_lpwMinorVersion /* [out] [ref] */,
					  uint16_t *_lpwBuildNumber /* [out] [ref] */,
					  const char **_lpszVendorId /* [out] [charset(UTF16),ref] */,
					  const char **_lpszCSDVersion /* [out] [charset(UTF16),ref] */,
					  WERROR *result)
{
	struct clusapi_GetClusterVersion r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */
	r.out.lpwMajorVersion = _lpwMajorVersion;
	r.out.lpwMinorVersion = _lpwMinorVersion;
	r.out.lpwBuildNumber = _lpwBuildNumber;
	r.out.lpszVendorId = _lpszVendorId;
	r.out.lpszCSDVersion = _lpszCSDVersion;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_GetClusterVersion_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_lpwMajorVersion = *r.out.lpwMajorVersion;
	*_lpwMinorVersion = *r.out.lpwMinorVersion;
	*_lpwBuildNumber = *r.out.lpwBuildNumber;
	*_lpszVendorId = *r.out.lpszVendorId;
	*_lpszCSDVersion = *r.out.lpszCSDVersion;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_GetQuorumResource_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetQuorumResource_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetQuorumResource_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_GetQuorumResource *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetQuorumResource_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetQuorumResource_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETQUORUMRESOURCE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetQuorumResource_r_done, req);

	return req;
}

static void dcerpc_clusapi_GetQuorumResource_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetQuorumResource_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_GetQuorumResource_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_GetQuorumResource_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetQuorumResource_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_GetQuorumResource *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETQUORUMRESOURCE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_GetQuorumResource_state {
	struct clusapi_GetQuorumResource orig;
	struct clusapi_GetQuorumResource tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetQuorumResource_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetQuorumResource_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 const char **_lpszResourceName /* [out] [charset(UTF16),ref] */,
							 const char **_lpszDeviceName /* [out] [charset(UTF16),ref] */,
							 uint32_t *_pdwMaxQuorumLogSize /* [out] [ref] */,
							 WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetQuorumResource_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetQuorumResource_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */
	state->orig.out.lpszResourceName = _lpszResourceName;
	state->orig.out.lpszDeviceName = _lpszDeviceName;
	state->orig.out.pdwMaxQuorumLogSize = _pdwMaxQuorumLogSize;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_GetQuorumResource_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_GetQuorumResource_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetQuorumResource_done, req);
	return req;
}

static void dcerpc_clusapi_GetQuorumResource_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_GetQuorumResource_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetQuorumResource_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_GetQuorumResource_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.lpszResourceName = *state->tmp.out.lpszResourceName;
	*state->orig.out.lpszDeviceName = *state->tmp.out.lpszDeviceName;
	*state->orig.out.pdwMaxQuorumLogSize = *state->tmp.out.pdwMaxQuorumLogSize;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetQuorumResource_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_clusapi_GetQuorumResource_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetQuorumResource_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetQuorumResource(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  const char **_lpszResourceName /* [out] [charset(UTF16),ref] */,
					  const char **_lpszDeviceName /* [out] [charset(UTF16),ref] */,
					  uint32_t *_pdwMaxQuorumLogSize /* [out] [ref] */,
					  WERROR *_rpc_status /* [out] [ref] */,
					  WERROR *result)
{
	struct clusapi_GetQuorumResource r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */
	r.out.lpszResourceName = _lpszResourceName;
	r.out.lpszDeviceName = _lpszDeviceName;
	r.out.pdwMaxQuorumLogSize = _pdwMaxQuorumLogSize;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_GetQuorumResource_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_lpszResourceName = *r.out.lpszResourceName;
	*_lpszDeviceName = *r.out.lpszDeviceName;
	*_pdwMaxQuorumLogSize = *r.out.pdwMaxQuorumLogSize;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_SetQuorumResource_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_SetQuorumResource_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_SetQuorumResource_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_SetQuorumResource *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_SetQuorumResource_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_SetQuorumResource_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_SETQUORUMRESOURCE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_SetQuorumResource_r_done, req);

	return req;
}

static void dcerpc_clusapi_SetQuorumResource_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_SetQuorumResource_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_SetQuorumResource_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_SetQuorumResource_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_SetQuorumResource_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_SetQuorumResource *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_SETQUORUMRESOURCE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_SetQuorumResource_state {
	struct clusapi_SetQuorumResource orig;
	struct clusapi_SetQuorumResource tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_SetQuorumResource_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_SetQuorumResource_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct policy_handle _hResource /* [in]  */,
							 const char *_lpszDeviceName /* [in] [charset(UTF16),ref] */,
							 uint32_t _dwMaxQuorumLogSize /* [in]  */,
							 WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_SetQuorumResource_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_SetQuorumResource_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hResource = _hResource;
	state->orig.in.lpszDeviceName = _lpszDeviceName;
	state->orig.in.dwMaxQuorumLogSize = _dwMaxQuorumLogSize;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_SetQuorumResource_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_SetQuorumResource_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_SetQuorumResource_done, req);
	return req;
}

static void dcerpc_clusapi_SetQuorumResource_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_SetQuorumResource_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_SetQuorumResource_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_SetQuorumResource_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_SetQuorumResource_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_clusapi_SetQuorumResource_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_SetQuorumResource_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_SetQuorumResource(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle _hResource /* [in]  */,
					  const char *_lpszDeviceName /* [in] [charset(UTF16),ref] */,
					  uint32_t _dwMaxQuorumLogSize /* [in]  */,
					  WERROR *_rpc_status /* [out] [ref] */,
					  WERROR *result)
{
	struct clusapi_SetQuorumResource r;
	NTSTATUS status;

	/* In parameters */
	r.in.hResource = _hResource;
	r.in.lpszDeviceName = _lpszDeviceName;
	r.in.dwMaxQuorumLogSize = _dwMaxQuorumLogSize;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_SetQuorumResource_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_CreateEnum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateEnum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateEnum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_CreateEnum *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateEnum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateEnum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATEENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateEnum_r_done, req);

	return req;
}

static void dcerpc_clusapi_CreateEnum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateEnum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CreateEnum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_CreateEnum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateEnum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_CreateEnum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATEENUM, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_CreateEnum_state {
	struct clusapi_CreateEnum orig;
	struct clusapi_CreateEnum tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateEnum_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateEnum_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  uint32_t _dwType /* [in]  */,
						  struct ENUM_LIST **_ReturnEnum /* [out] [ref] */,
						  WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateEnum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateEnum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.dwType = _dwType;

	/* Out parameters */
	state->orig.out.ReturnEnum = _ReturnEnum;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_CreateEnum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_CreateEnum_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateEnum_done, req);
	return req;
}

static void dcerpc_clusapi_CreateEnum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_CreateEnum_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateEnum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_CreateEnum_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ReturnEnum = *state->tmp.out.ReturnEnum;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateEnum_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct dcerpc_clusapi_CreateEnum_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateEnum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateEnum(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   uint32_t _dwType /* [in]  */,
				   struct ENUM_LIST **_ReturnEnum /* [out] [ref] */,
				   WERROR *_rpc_status /* [out] [ref] */,
				   WERROR *result)
{
	struct clusapi_CreateEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.dwType = _dwType;

	/* Out parameters */
	r.out.ReturnEnum = _ReturnEnum;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_CreateEnum_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ReturnEnum = *r.out.ReturnEnum;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_OpenResource_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OpenResource_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OpenResource_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_OpenResource *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OpenResource_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OpenResource_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OPENRESOURCE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OpenResource_r_done, req);

	return req;
}

static void dcerpc_clusapi_OpenResource_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OpenResource_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OpenResource_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_OpenResource_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OpenResource_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_OpenResource *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OPENRESOURCE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_OpenResource_state {
	struct clusapi_OpenResource orig;
	struct clusapi_OpenResource tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OpenResource_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OpenResource_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    const char *_lpszResourceName /* [in] [charset(UTF16),ref] */,
						    WERROR *_Status /* [out] [ref] */,
						    WERROR *_rpc_status /* [out] [ref] */,
						    struct policy_handle *_hResource /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OpenResource_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OpenResource_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.lpszResourceName = _lpszResourceName;

	/* Out parameters */
	state->orig.out.Status = _Status;
	state->orig.out.rpc_status = _rpc_status;
	state->orig.out.hResource = _hResource;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_OpenResource_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_OpenResource_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OpenResource_done, req);
	return req;
}

static void dcerpc_clusapi_OpenResource_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_OpenResource_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OpenResource_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_OpenResource_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.Status = *state->tmp.out.Status;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;
	*state->orig.out.hResource = *state->tmp.out.hResource;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OpenResource_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OpenResource_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OpenResource_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OpenResource(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     const char *_lpszResourceName /* [in] [charset(UTF16),ref] */,
				     WERROR *_Status /* [out] [ref] */,
				     WERROR *_rpc_status /* [out] [ref] */,
				     struct policy_handle *_hResource /* [out] [ref] */)
{
	struct clusapi_OpenResource r;
	NTSTATUS status;

	/* In parameters */
	r.in.lpszResourceName = _lpszResourceName;

	/* Out parameters */
	r.out.Status = _Status;
	r.out.rpc_status = _rpc_status;
	r.out.hResource = _hResource;

	status = dcerpc_clusapi_OpenResource_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_Status = *r.out.Status;
	*_rpc_status = *r.out.rpc_status;
	*_hResource = *r.out.hResource;

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_CreateResource_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateResource_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateResource_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_CreateResource *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateResource_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateResource_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATERESOURCE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateResource_r_done, req);

	return req;
}

static void dcerpc_clusapi_CreateResource_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateResource_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CreateResource_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_CreateResource_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateResource_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_CreateResource *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATERESOURCE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_CreateResource_state {
	struct clusapi_CreateResource orig;
	struct clusapi_CreateResource tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateResource_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateResource_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle _hGroup /* [in]  */,
						      const char *_lpszResourceName /* [in] [charset(UTF16),ref] */,
						      const char *_lpszResourceType /* [in] [charset(UTF16),ref] */,
						      enum clusapi_CreateResourceFlags _dwFlags /* [in]  */,
						      WERROR *_Status /* [out] [ref] */,
						      WERROR *_rpc_status /* [out] [ref] */,
						      struct policy_handle *_hResource /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateResource_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateResource_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hGroup = _hGroup;
	state->orig.in.lpszResourceName = _lpszResourceName;
	state->orig.in.lpszResourceType = _lpszResourceType;
	state->orig.in.dwFlags = _dwFlags;

	/* Out parameters */
	state->orig.out.Status = _Status;
	state->orig.out.rpc_status = _rpc_status;
	state->orig.out.hResource = _hResource;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_CreateResource_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_CreateResource_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateResource_done, req);
	return req;
}

static void dcerpc_clusapi_CreateResource_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_CreateResource_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateResource_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_CreateResource_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.Status = *state->tmp.out.Status;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;
	*state->orig.out.hResource = *state->tmp.out.hResource;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateResource_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CreateResource_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateResource_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateResource(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle _hGroup /* [in]  */,
				       const char *_lpszResourceName /* [in] [charset(UTF16),ref] */,
				       const char *_lpszResourceType /* [in] [charset(UTF16),ref] */,
				       enum clusapi_CreateResourceFlags _dwFlags /* [in]  */,
				       WERROR *_Status /* [out] [ref] */,
				       WERROR *_rpc_status /* [out] [ref] */,
				       struct policy_handle *_hResource /* [out] [ref] */)
{
	struct clusapi_CreateResource r;
	NTSTATUS status;

	/* In parameters */
	r.in.hGroup = _hGroup;
	r.in.lpszResourceName = _lpszResourceName;
	r.in.lpszResourceType = _lpszResourceType;
	r.in.dwFlags = _dwFlags;

	/* Out parameters */
	r.out.Status = _Status;
	r.out.rpc_status = _rpc_status;
	r.out.hResource = _hResource;

	status = dcerpc_clusapi_CreateResource_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_Status = *r.out.Status;
	*_rpc_status = *r.out.rpc_status;
	*_hResource = *r.out.hResource;

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_DeleteResource_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_DeleteResource_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_DeleteResource_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_DeleteResource *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_DeleteResource_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_DeleteResource_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_DELETERESOURCE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_DeleteResource_r_done, req);

	return req;
}

static void dcerpc_clusapi_DeleteResource_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_DeleteResource_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_DeleteResource_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_DeleteResource_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_DeleteResource_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_DeleteResource *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_DELETERESOURCE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_DeleteResource_state {
	struct clusapi_DeleteResource orig;
	struct clusapi_DeleteResource tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_DeleteResource_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_DeleteResource_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle _hResource /* [in]  */,
						      WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_DeleteResource_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_DeleteResource_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hResource = _hResource;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_DeleteResource_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_DeleteResource_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_DeleteResource_done, req);
	return req;
}

static void dcerpc_clusapi_DeleteResource_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_DeleteResource_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_DeleteResource_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_DeleteResource_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_DeleteResource_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_clusapi_DeleteResource_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_DeleteResource_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_DeleteResource(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle _hResource /* [in]  */,
				       WERROR *_rpc_status /* [out] [ref] */,
				       WERROR *result)
{
	struct clusapi_DeleteResource r;
	NTSTATUS status;

	/* In parameters */
	r.in.hResource = _hResource;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_DeleteResource_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_CloseResource_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CloseResource_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CloseResource_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_CloseResource *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CloseResource_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CloseResource_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CLOSERESOURCE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CloseResource_r_done, req);

	return req;
}

static void dcerpc_clusapi_CloseResource_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CloseResource_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CloseResource_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_CloseResource_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CloseResource_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_CloseResource *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CLOSERESOURCE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_CloseResource_state {
	struct clusapi_CloseResource orig;
	struct clusapi_CloseResource tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CloseResource_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CloseResource_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle *_Resource /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CloseResource_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CloseResource_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.Resource = _Resource;

	/* Out parameters */
	state->orig.out.Resource = _Resource;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_CloseResource_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_CloseResource_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CloseResource_done, req);
	return req;
}

static void dcerpc_clusapi_CloseResource_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_CloseResource_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CloseResource_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_CloseResource_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.Resource = *state->tmp.out.Resource;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CloseResource_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_clusapi_CloseResource_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CloseResource_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CloseResource(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *_Resource /* [in,out] [ref] */,
				      WERROR *result)
{
	struct clusapi_CloseResource r;
	NTSTATUS status;

	/* In parameters */
	r.in.Resource = _Resource;

	/* Out parameters */
	r.out.Resource = _Resource;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_CloseResource_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_Resource = *r.out.Resource;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_GetResourceState_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetResourceState_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetResourceState_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_GetResourceState *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetResourceState_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetResourceState_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETRESOURCESTATE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetResourceState_r_done, req);

	return req;
}

static void dcerpc_clusapi_GetResourceState_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetResourceState_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_GetResourceState_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_GetResourceState_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetResourceState_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_GetResourceState *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETRESOURCESTATE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_GetResourceState_state {
	struct clusapi_GetResourceState orig;
	struct clusapi_GetResourceState tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetResourceState_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetResourceState_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle _hResource /* [in]  */,
							enum clusapi_ClusterResourceState *_State /* [out] [ref] */,
							const char **_NodeName /* [out] [charset(UTF16),ref] */,
							const char **_GroupName /* [out] [charset(UTF16),ref] */,
							WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetResourceState_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetResourceState_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hResource = _hResource;

	/* Out parameters */
	state->orig.out.State = _State;
	state->orig.out.NodeName = _NodeName;
	state->orig.out.GroupName = _GroupName;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_GetResourceState_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_GetResourceState_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetResourceState_done, req);
	return req;
}

static void dcerpc_clusapi_GetResourceState_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_GetResourceState_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetResourceState_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_GetResourceState_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.State = *state->tmp.out.State;
	*state->orig.out.NodeName = *state->tmp.out.NodeName;
	*state->orig.out.GroupName = *state->tmp.out.GroupName;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetResourceState_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_clusapi_GetResourceState_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetResourceState_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetResourceState(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle _hResource /* [in]  */,
					 enum clusapi_ClusterResourceState *_State /* [out] [ref] */,
					 const char **_NodeName /* [out] [charset(UTF16),ref] */,
					 const char **_GroupName /* [out] [charset(UTF16),ref] */,
					 WERROR *_rpc_status /* [out] [ref] */,
					 WERROR *result)
{
	struct clusapi_GetResourceState r;
	NTSTATUS status;

	/* In parameters */
	r.in.hResource = _hResource;

	/* Out parameters */
	r.out.State = _State;
	r.out.NodeName = _NodeName;
	r.out.GroupName = _GroupName;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_GetResourceState_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_State = *r.out.State;
	*_NodeName = *r.out.NodeName;
	*_GroupName = *r.out.GroupName;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_SetResourceName_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_SetResourceName_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_SetResourceName_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_SetResourceName *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_SetResourceName_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_SetResourceName_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_SETRESOURCENAME, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_SetResourceName_r_done, req);

	return req;
}

static void dcerpc_clusapi_SetResourceName_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_SetResourceName_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_SetResourceName_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_SetResourceName_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_SetResourceName_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_SetResourceName *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_SETRESOURCENAME, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_SetResourceName_state {
	struct clusapi_SetResourceName orig;
	struct clusapi_SetResourceName tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_SetResourceName_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_SetResourceName_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       struct policy_handle _hResource /* [in]  */,
						       const char *_lpszResourceName /* [in] [charset(UTF16),ref] */,
						       WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_SetResourceName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_SetResourceName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hResource = _hResource;
	state->orig.in.lpszResourceName = _lpszResourceName;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_SetResourceName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_SetResourceName_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_SetResourceName_done, req);
	return req;
}

static void dcerpc_clusapi_SetResourceName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_SetResourceName_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_SetResourceName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_SetResourceName_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_SetResourceName_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct dcerpc_clusapi_SetResourceName_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_SetResourceName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_SetResourceName(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					struct policy_handle _hResource /* [in]  */,
					const char *_lpszResourceName /* [in] [charset(UTF16),ref] */,
					WERROR *_rpc_status /* [out] [ref] */,
					WERROR *result)
{
	struct clusapi_SetResourceName r;
	NTSTATUS status;

	/* In parameters */
	r.in.hResource = _hResource;
	r.in.lpszResourceName = _lpszResourceName;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_SetResourceName_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_GetResourceId_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetResourceId_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetResourceId_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_GetResourceId *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetResourceId_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetResourceId_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETRESOURCEID, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetResourceId_r_done, req);

	return req;
}

static void dcerpc_clusapi_GetResourceId_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetResourceId_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_GetResourceId_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_GetResourceId_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetResourceId_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_GetResourceId *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETRESOURCEID, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_GetResourceId_state {
	struct clusapi_GetResourceId orig;
	struct clusapi_GetResourceId tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetResourceId_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetResourceId_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle _hResource /* [in]  */,
						     const char **_pGuid /* [out] [charset(UTF16),ref] */,
						     WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetResourceId_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetResourceId_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hResource = _hResource;

	/* Out parameters */
	state->orig.out.pGuid = _pGuid;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_GetResourceId_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_GetResourceId_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetResourceId_done, req);
	return req;
}

static void dcerpc_clusapi_GetResourceId_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_GetResourceId_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetResourceId_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_GetResourceId_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pGuid = *state->tmp.out.pGuid;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetResourceId_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_clusapi_GetResourceId_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetResourceId_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetResourceId(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle _hResource /* [in]  */,
				      const char **_pGuid /* [out] [charset(UTF16),ref] */,
				      WERROR *_rpc_status /* [out] [ref] */,
				      WERROR *result)
{
	struct clusapi_GetResourceId r;
	NTSTATUS status;

	/* In parameters */
	r.in.hResource = _hResource;

	/* Out parameters */
	r.out.pGuid = _pGuid;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_GetResourceId_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pGuid = *r.out.pGuid;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_GetResourceType_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetResourceType_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetResourceType_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_GetResourceType *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetResourceType_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetResourceType_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETRESOURCETYPE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetResourceType_r_done, req);

	return req;
}

static void dcerpc_clusapi_GetResourceType_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetResourceType_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_GetResourceType_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_GetResourceType_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetResourceType_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_GetResourceType *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETRESOURCETYPE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_GetResourceType_state {
	struct clusapi_GetResourceType orig;
	struct clusapi_GetResourceType tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetResourceType_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetResourceType_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       struct policy_handle _hResource /* [in]  */,
						       const char **_lpszResourceType /* [out] [charset(UTF16),ref] */,
						       WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetResourceType_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetResourceType_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hResource = _hResource;

	/* Out parameters */
	state->orig.out.lpszResourceType = _lpszResourceType;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_GetResourceType_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_GetResourceType_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetResourceType_done, req);
	return req;
}

static void dcerpc_clusapi_GetResourceType_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_GetResourceType_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetResourceType_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_GetResourceType_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.lpszResourceType = *state->tmp.out.lpszResourceType;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetResourceType_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct dcerpc_clusapi_GetResourceType_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetResourceType_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetResourceType(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					struct policy_handle _hResource /* [in]  */,
					const char **_lpszResourceType /* [out] [charset(UTF16),ref] */,
					WERROR *_rpc_status /* [out] [ref] */,
					WERROR *result)
{
	struct clusapi_GetResourceType r;
	NTSTATUS status;

	/* In parameters */
	r.in.hResource = _hResource;

	/* Out parameters */
	r.out.lpszResourceType = _lpszResourceType;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_GetResourceType_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_lpszResourceType = *r.out.lpszResourceType;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_FailResource_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_FailResource_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_FailResource_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_FailResource *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_FailResource_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_FailResource_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_FAILRESOURCE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_FailResource_r_done, req);

	return req;
}

static void dcerpc_clusapi_FailResource_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_FailResource_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_FailResource_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_FailResource_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_FailResource_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_FailResource *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_FAILRESOURCE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_FailResource_state {
	struct clusapi_FailResource orig;
	struct clusapi_FailResource tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_FailResource_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_FailResource_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle _hResource /* [in]  */,
						    WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_FailResource_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_FailResource_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hResource = _hResource;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_FailResource_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_FailResource_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_FailResource_done, req);
	return req;
}

static void dcerpc_clusapi_FailResource_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_FailResource_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_FailResource_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_FailResource_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_FailResource_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_clusapi_FailResource_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_FailResource_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_FailResource(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle _hResource /* [in]  */,
				     WERROR *_rpc_status /* [out] [ref] */,
				     WERROR *result)
{
	struct clusapi_FailResource r;
	NTSTATUS status;

	/* In parameters */
	r.in.hResource = _hResource;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_FailResource_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_OnlineResource_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OnlineResource_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OnlineResource_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_OnlineResource *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OnlineResource_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OnlineResource_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ONLINERESOURCE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OnlineResource_r_done, req);

	return req;
}

static void dcerpc_clusapi_OnlineResource_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OnlineResource_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OnlineResource_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_OnlineResource_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OnlineResource_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_OnlineResource *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ONLINERESOURCE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_OnlineResource_state {
	struct clusapi_OnlineResource orig;
	struct clusapi_OnlineResource tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OnlineResource_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OnlineResource_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle _hResource /* [in]  */,
						      WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OnlineResource_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OnlineResource_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hResource = _hResource;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_OnlineResource_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_OnlineResource_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OnlineResource_done, req);
	return req;
}

static void dcerpc_clusapi_OnlineResource_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_OnlineResource_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OnlineResource_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_OnlineResource_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OnlineResource_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_clusapi_OnlineResource_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OnlineResource_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OnlineResource(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle _hResource /* [in]  */,
				       WERROR *_rpc_status /* [out] [ref] */,
				       WERROR *result)
{
	struct clusapi_OnlineResource r;
	NTSTATUS status;

	/* In parameters */
	r.in.hResource = _hResource;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_OnlineResource_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_OfflineResource_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OfflineResource_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OfflineResource_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_OfflineResource *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OfflineResource_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OfflineResource_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OFFLINERESOURCE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OfflineResource_r_done, req);

	return req;
}

static void dcerpc_clusapi_OfflineResource_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OfflineResource_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OfflineResource_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_OfflineResource_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OfflineResource_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_OfflineResource *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OFFLINERESOURCE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_OfflineResource_state {
	struct clusapi_OfflineResource orig;
	struct clusapi_OfflineResource tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OfflineResource_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OfflineResource_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       struct policy_handle _hResource /* [in]  */,
						       WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OfflineResource_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OfflineResource_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hResource = _hResource;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_OfflineResource_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_OfflineResource_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OfflineResource_done, req);
	return req;
}

static void dcerpc_clusapi_OfflineResource_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_OfflineResource_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OfflineResource_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_OfflineResource_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OfflineResource_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct dcerpc_clusapi_OfflineResource_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OfflineResource_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OfflineResource(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					struct policy_handle _hResource /* [in]  */,
					WERROR *_rpc_status /* [out] [ref] */,
					WERROR *result)
{
	struct clusapi_OfflineResource r;
	NTSTATUS status;

	/* In parameters */
	r.in.hResource = _hResource;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_OfflineResource_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_AddResourceDependency_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_AddResourceDependency_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_AddResourceDependency_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_AddResourceDependency *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_AddResourceDependency_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_AddResourceDependency_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ADDRESOURCEDEPENDENCY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_AddResourceDependency_r_done, req);

	return req;
}

static void dcerpc_clusapi_AddResourceDependency_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_AddResourceDependency_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_AddResourceDependency_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_AddResourceDependency_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_AddResourceDependency_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_AddResourceDependency *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ADDRESOURCEDEPENDENCY, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_AddResourceDependency_state {
	struct clusapi_AddResourceDependency orig;
	struct clusapi_AddResourceDependency tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_AddResourceDependency_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_AddResourceDependency_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct dcerpc_binding_handle *h,
							     struct policy_handle _hResource /* [in]  */,
							     struct policy_handle _hDependsOn /* [in]  */,
							     WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_AddResourceDependency_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_AddResourceDependency_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hResource = _hResource;
	state->orig.in.hDependsOn = _hDependsOn;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_AddResourceDependency_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_AddResourceDependency_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_AddResourceDependency_done, req);
	return req;
}

static void dcerpc_clusapi_AddResourceDependency_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_AddResourceDependency_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_AddResourceDependency_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_AddResourceDependency_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_AddResourceDependency_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result)
{
	struct dcerpc_clusapi_AddResourceDependency_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_AddResourceDependency_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_AddResourceDependency(struct dcerpc_binding_handle *h,
					      TALLOC_CTX *mem_ctx,
					      struct policy_handle _hResource /* [in]  */,
					      struct policy_handle _hDependsOn /* [in]  */,
					      WERROR *_rpc_status /* [out] [ref] */,
					      WERROR *result)
{
	struct clusapi_AddResourceDependency r;
	NTSTATUS status;

	/* In parameters */
	r.in.hResource = _hResource;
	r.in.hDependsOn = _hDependsOn;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_AddResourceDependency_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_RemoveResourceDependency_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_RemoveResourceDependency_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_RemoveResourceDependency_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_RemoveResourceDependency *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_RemoveResourceDependency_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_RemoveResourceDependency_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_REMOVERESOURCEDEPENDENCY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_RemoveResourceDependency_r_done, req);

	return req;
}

static void dcerpc_clusapi_RemoveResourceDependency_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_RemoveResourceDependency_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_RemoveResourceDependency_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_RemoveResourceDependency_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_RemoveResourceDependency_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_RemoveResourceDependency *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_REMOVERESOURCEDEPENDENCY, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_RemoveResourceDependency_state {
	struct clusapi_RemoveResourceDependency orig;
	struct clusapi_RemoveResourceDependency tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_RemoveResourceDependency_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_RemoveResourceDependency_send(TALLOC_CTX *mem_ctx,
								struct tevent_context *ev,
								struct dcerpc_binding_handle *h,
								struct policy_handle _hResource /* [in]  */,
								struct policy_handle _hDependsOn /* [in]  */,
								WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_RemoveResourceDependency_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_RemoveResourceDependency_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hResource = _hResource;
	state->orig.in.hDependsOn = _hDependsOn;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_RemoveResourceDependency_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_RemoveResourceDependency_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_RemoveResourceDependency_done, req);
	return req;
}

static void dcerpc_clusapi_RemoveResourceDependency_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_RemoveResourceDependency_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_RemoveResourceDependency_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_RemoveResourceDependency_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_RemoveResourceDependency_recv(struct tevent_req *req,
						      TALLOC_CTX *mem_ctx,
						      WERROR *result)
{
	struct dcerpc_clusapi_RemoveResourceDependency_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_RemoveResourceDependency_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_RemoveResourceDependency(struct dcerpc_binding_handle *h,
						 TALLOC_CTX *mem_ctx,
						 struct policy_handle _hResource /* [in]  */,
						 struct policy_handle _hDependsOn /* [in]  */,
						 WERROR *_rpc_status /* [out] [ref] */,
						 WERROR *result)
{
	struct clusapi_RemoveResourceDependency r;
	NTSTATUS status;

	/* In parameters */
	r.in.hResource = _hResource;
	r.in.hDependsOn = _hDependsOn;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_RemoveResourceDependency_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_CanResourceBeDependent_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CanResourceBeDependent_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CanResourceBeDependent_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_CanResourceBeDependent *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CanResourceBeDependent_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CanResourceBeDependent_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CANRESOURCEBEDEPENDENT, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CanResourceBeDependent_r_done, req);

	return req;
}

static void dcerpc_clusapi_CanResourceBeDependent_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CanResourceBeDependent_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CanResourceBeDependent_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_CanResourceBeDependent_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CanResourceBeDependent_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_CanResourceBeDependent *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CANRESOURCEBEDEPENDENT, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_CanResourceBeDependent_state {
	struct clusapi_CanResourceBeDependent orig;
	struct clusapi_CanResourceBeDependent tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CanResourceBeDependent_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CanResourceBeDependent_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct dcerpc_binding_handle *h,
							      struct policy_handle _hResource /* [in]  */,
							      struct policy_handle _hResourceDependent /* [in]  */,
							      WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CanResourceBeDependent_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CanResourceBeDependent_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hResource = _hResource;
	state->orig.in.hResourceDependent = _hResourceDependent;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_CanResourceBeDependent_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_CanResourceBeDependent_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CanResourceBeDependent_done, req);
	return req;
}

static void dcerpc_clusapi_CanResourceBeDependent_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_CanResourceBeDependent_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CanResourceBeDependent_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_CanResourceBeDependent_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CanResourceBeDependent_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    WERROR *result)
{
	struct dcerpc_clusapi_CanResourceBeDependent_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CanResourceBeDependent_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CanResourceBeDependent(struct dcerpc_binding_handle *h,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle _hResource /* [in]  */,
					       struct policy_handle _hResourceDependent /* [in]  */,
					       WERROR *_rpc_status /* [out] [ref] */,
					       WERROR *result)
{
	struct clusapi_CanResourceBeDependent r;
	NTSTATUS status;

	/* In parameters */
	r.in.hResource = _hResource;
	r.in.hResourceDependent = _hResourceDependent;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_CanResourceBeDependent_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_CreateResEnum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateResEnum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateResEnum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_CreateResEnum *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateResEnum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateResEnum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATERESENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateResEnum_r_done, req);

	return req;
}

static void dcerpc_clusapi_CreateResEnum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateResEnum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CreateResEnum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_CreateResEnum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateResEnum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_CreateResEnum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATERESENUM, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_CreateResEnum_state {
	struct clusapi_CreateResEnum orig;
	struct clusapi_CreateResEnum tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateResEnum_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateResEnum_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle _hResource /* [in]  */,
						     uint32_t _dwType /* [in]  */,
						     struct ENUM_LIST **_ReturnEnum /* [out] [ref] */,
						     WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateResEnum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateResEnum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hResource = _hResource;
	state->orig.in.dwType = _dwType;

	/* Out parameters */
	state->orig.out.ReturnEnum = _ReturnEnum;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_CreateResEnum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_CreateResEnum_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateResEnum_done, req);
	return req;
}

static void dcerpc_clusapi_CreateResEnum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_CreateResEnum_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateResEnum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_CreateResEnum_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ReturnEnum = *state->tmp.out.ReturnEnum;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateResEnum_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_clusapi_CreateResEnum_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateResEnum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateResEnum(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle _hResource /* [in]  */,
				      uint32_t _dwType /* [in]  */,
				      struct ENUM_LIST **_ReturnEnum /* [out] [ref] */,
				      WERROR *_rpc_status /* [out] [ref] */,
				      WERROR *result)
{
	struct clusapi_CreateResEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.hResource = _hResource;
	r.in.dwType = _dwType;

	/* Out parameters */
	r.out.ReturnEnum = _ReturnEnum;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_CreateResEnum_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ReturnEnum = *r.out.ReturnEnum;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_AddResourceNode_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_AddResourceNode_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_AddResourceNode_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_AddResourceNode *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_AddResourceNode_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_AddResourceNode_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ADDRESOURCENODE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_AddResourceNode_r_done, req);

	return req;
}

static void dcerpc_clusapi_AddResourceNode_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_AddResourceNode_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_AddResourceNode_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_AddResourceNode_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_AddResourceNode_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_AddResourceNode *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ADDRESOURCENODE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_AddResourceNode_state {
	struct clusapi_AddResourceNode orig;
	struct clusapi_AddResourceNode tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_AddResourceNode_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_AddResourceNode_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       struct policy_handle _hResource /* [in]  */,
						       struct policy_handle _hNode /* [in]  */,
						       WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_AddResourceNode_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_AddResourceNode_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hResource = _hResource;
	state->orig.in.hNode = _hNode;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_AddResourceNode_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_AddResourceNode_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_AddResourceNode_done, req);
	return req;
}

static void dcerpc_clusapi_AddResourceNode_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_AddResourceNode_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_AddResourceNode_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_AddResourceNode_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_AddResourceNode_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct dcerpc_clusapi_AddResourceNode_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_AddResourceNode_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_AddResourceNode(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					struct policy_handle _hResource /* [in]  */,
					struct policy_handle _hNode /* [in]  */,
					WERROR *_rpc_status /* [out] [ref] */,
					WERROR *result)
{
	struct clusapi_AddResourceNode r;
	NTSTATUS status;

	/* In parameters */
	r.in.hResource = _hResource;
	r.in.hNode = _hNode;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_AddResourceNode_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_RemoveResourceNode_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_RemoveResourceNode_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_RemoveResourceNode_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_RemoveResourceNode *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_RemoveResourceNode_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_RemoveResourceNode_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_REMOVERESOURCENODE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_RemoveResourceNode_r_done, req);

	return req;
}

static void dcerpc_clusapi_RemoveResourceNode_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_RemoveResourceNode_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_RemoveResourceNode_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_RemoveResourceNode_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_RemoveResourceNode_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_RemoveResourceNode *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_REMOVERESOURCENODE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_RemoveResourceNode_state {
	struct clusapi_RemoveResourceNode orig;
	struct clusapi_RemoveResourceNode tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_RemoveResourceNode_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_RemoveResourceNode_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle _hResource /* [in]  */,
							  struct policy_handle _hNode /* [in]  */,
							  WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_RemoveResourceNode_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_RemoveResourceNode_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hResource = _hResource;
	state->orig.in.hNode = _hNode;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_RemoveResourceNode_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_RemoveResourceNode_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_RemoveResourceNode_done, req);
	return req;
}

static void dcerpc_clusapi_RemoveResourceNode_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_RemoveResourceNode_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_RemoveResourceNode_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_RemoveResourceNode_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_RemoveResourceNode_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_clusapi_RemoveResourceNode_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_RemoveResourceNode_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_RemoveResourceNode(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle _hResource /* [in]  */,
					   struct policy_handle _hNode /* [in]  */,
					   WERROR *_rpc_status /* [out] [ref] */,
					   WERROR *result)
{
	struct clusapi_RemoveResourceNode r;
	NTSTATUS status;

	/* In parameters */
	r.in.hResource = _hResource;
	r.in.hNode = _hNode;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_RemoveResourceNode_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_ChangeResourceGroup_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_ChangeResourceGroup_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_ChangeResourceGroup_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_ChangeResourceGroup *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_ChangeResourceGroup_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_ChangeResourceGroup_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CHANGERESOURCEGROUP, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_ChangeResourceGroup_r_done, req);

	return req;
}

static void dcerpc_clusapi_ChangeResourceGroup_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_ChangeResourceGroup_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_ChangeResourceGroup_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_ChangeResourceGroup_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_ChangeResourceGroup_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_ChangeResourceGroup *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CHANGERESOURCEGROUP, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_ChangeResourceGroup_state {
	struct clusapi_ChangeResourceGroup orig;
	struct clusapi_ChangeResourceGroup tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_ChangeResourceGroup_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_ChangeResourceGroup_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   struct policy_handle _hResource /* [in]  */,
							   struct policy_handle _hGroup /* [in]  */,
							   WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_ChangeResourceGroup_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_ChangeResourceGroup_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hResource = _hResource;
	state->orig.in.hGroup = _hGroup;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_ChangeResourceGroup_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_ChangeResourceGroup_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_ChangeResourceGroup_done, req);
	return req;
}

static void dcerpc_clusapi_ChangeResourceGroup_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_ChangeResourceGroup_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_ChangeResourceGroup_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_ChangeResourceGroup_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_ChangeResourceGroup_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result)
{
	struct dcerpc_clusapi_ChangeResourceGroup_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_ChangeResourceGroup_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_ChangeResourceGroup(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle _hResource /* [in]  */,
					    struct policy_handle _hGroup /* [in]  */,
					    WERROR *_rpc_status /* [out] [ref] */,
					    WERROR *result)
{
	struct clusapi_ChangeResourceGroup r;
	NTSTATUS status;

	/* In parameters */
	r.in.hResource = _hResource;
	r.in.hGroup = _hGroup;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_ChangeResourceGroup_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_CreateResourceType_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateResourceType_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateResourceType_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_CreateResourceType *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateResourceType_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateResourceType_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATERESOURCETYPE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateResourceType_r_done, req);

	return req;
}

static void dcerpc_clusapi_CreateResourceType_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateResourceType_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CreateResourceType_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_CreateResourceType_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateResourceType_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_CreateResourceType *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATERESOURCETYPE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_CreateResourceType_state {
	struct clusapi_CreateResourceType orig;
	struct clusapi_CreateResourceType tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateResourceType_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateResourceType_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  const char *_lpszTypeName /* [in] [charset(UTF16),ref] */,
							  const char *_lpszDisplayName /* [in] [charset(UTF16),ref] */,
							  const char *_lpszDllName /* [in] [charset(UTF16),ref] */,
							  uint32_t _dwLooksAlive /* [in]  */,
							  uint32_t _dwIsAlive /* [in]  */,
							  WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateResourceType_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateResourceType_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.lpszTypeName = _lpszTypeName;
	state->orig.in.lpszDisplayName = _lpszDisplayName;
	state->orig.in.lpszDllName = _lpszDllName;
	state->orig.in.dwLooksAlive = _dwLooksAlive;
	state->orig.in.dwIsAlive = _dwIsAlive;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_CreateResourceType_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_CreateResourceType_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateResourceType_done, req);
	return req;
}

static void dcerpc_clusapi_CreateResourceType_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_CreateResourceType_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateResourceType_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_CreateResourceType_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateResourceType_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_clusapi_CreateResourceType_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateResourceType_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateResourceType(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   const char *_lpszTypeName /* [in] [charset(UTF16),ref] */,
					   const char *_lpszDisplayName /* [in] [charset(UTF16),ref] */,
					   const char *_lpszDllName /* [in] [charset(UTF16),ref] */,
					   uint32_t _dwLooksAlive /* [in]  */,
					   uint32_t _dwIsAlive /* [in]  */,
					   WERROR *_rpc_status /* [out] [ref] */,
					   WERROR *result)
{
	struct clusapi_CreateResourceType r;
	NTSTATUS status;

	/* In parameters */
	r.in.lpszTypeName = _lpszTypeName;
	r.in.lpszDisplayName = _lpszDisplayName;
	r.in.lpszDllName = _lpszDllName;
	r.in.dwLooksAlive = _dwLooksAlive;
	r.in.dwIsAlive = _dwIsAlive;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_CreateResourceType_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_DeleteResourceType_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_DeleteResourceType_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_DeleteResourceType_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_DeleteResourceType *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_DeleteResourceType_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_DeleteResourceType_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_DELETERESOURCETYPE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_DeleteResourceType_r_done, req);

	return req;
}

static void dcerpc_clusapi_DeleteResourceType_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_DeleteResourceType_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_DeleteResourceType_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_DeleteResourceType_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_DeleteResourceType_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_DeleteResourceType *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_DELETERESOURCETYPE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_DeleteResourceType_state {
	struct clusapi_DeleteResourceType orig;
	struct clusapi_DeleteResourceType tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_DeleteResourceType_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_DeleteResourceType_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  const char *_lpszTypeName /* [in] [charset(UTF16),ref] */,
							  WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_DeleteResourceType_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_DeleteResourceType_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.lpszTypeName = _lpszTypeName;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_DeleteResourceType_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_DeleteResourceType_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_DeleteResourceType_done, req);
	return req;
}

static void dcerpc_clusapi_DeleteResourceType_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_DeleteResourceType_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_DeleteResourceType_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_DeleteResourceType_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_DeleteResourceType_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_clusapi_DeleteResourceType_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_DeleteResourceType_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_DeleteResourceType(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   const char *_lpszTypeName /* [in] [charset(UTF16),ref] */,
					   WERROR *_rpc_status /* [out] [ref] */,
					   WERROR *result)
{
	struct clusapi_DeleteResourceType r;
	NTSTATUS status;

	/* In parameters */
	r.in.lpszTypeName = _lpszTypeName;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_DeleteResourceType_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_GetRootKey_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetRootKey_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetRootKey_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_GetRootKey *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetRootKey_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetRootKey_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETROOTKEY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetRootKey_r_done, req);

	return req;
}

static void dcerpc_clusapi_GetRootKey_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetRootKey_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_GetRootKey_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_GetRootKey_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetRootKey_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_GetRootKey *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETROOTKEY, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_GetRootKey_state {
	struct clusapi_GetRootKey orig;
	struct clusapi_GetRootKey tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetRootKey_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetRootKey_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  uint32_t _samDesired /* [in]  */,
						  WERROR *_Status /* [out] [ref] */,
						  WERROR *_rpc_status /* [out] [ref] */,
						  struct policy_handle *_phKey /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetRootKey_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetRootKey_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.samDesired = _samDesired;

	/* Out parameters */
	state->orig.out.Status = _Status;
	state->orig.out.rpc_status = _rpc_status;
	state->orig.out.phKey = _phKey;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_GetRootKey_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_GetRootKey_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetRootKey_done, req);
	return req;
}

static void dcerpc_clusapi_GetRootKey_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_GetRootKey_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetRootKey_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_GetRootKey_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.Status = *state->tmp.out.Status;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;
	*state->orig.out.phKey = *state->tmp.out.phKey;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetRootKey_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_GetRootKey_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetRootKey_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetRootKey(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   uint32_t _samDesired /* [in]  */,
				   WERROR *_Status /* [out] [ref] */,
				   WERROR *_rpc_status /* [out] [ref] */,
				   struct policy_handle *_phKey /* [out] [ref] */)
{
	struct clusapi_GetRootKey r;
	NTSTATUS status;

	/* In parameters */
	r.in.samDesired = _samDesired;

	/* Out parameters */
	r.out.Status = _Status;
	r.out.rpc_status = _rpc_status;
	r.out.phKey = _phKey;

	status = dcerpc_clusapi_GetRootKey_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_Status = *r.out.Status;
	*_rpc_status = *r.out.rpc_status;
	*_phKey = *r.out.phKey;

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_CreateKey_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateKey_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateKey_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_CreateKey *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateKey_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateKey_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATEKEY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateKey_r_done, req);

	return req;
}

static void dcerpc_clusapi_CreateKey_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateKey_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CreateKey_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_CreateKey_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateKey_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_CreateKey *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATEKEY, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_CreateKey_state {
	struct clusapi_CreateKey orig;
	struct clusapi_CreateKey tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateKey_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateKey_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 struct policy_handle _hKey /* [in]  */,
						 const char *_lpSubKey /* [in] [charset(UTF16),ref] */,
						 uint32_t _dwOptions /* [in]  */,
						 uint32_t _samDesired /* [in]  */,
						 struct RPC_SECURITY_ATTRIBUTES *_lpSecurityAttributes /* [in] [unique] */,
						 uint32_t *_lpdwDisposition /* [out] [ref] */,
						 WERROR *_Status /* [out] [ref] */,
						 WERROR *_rpc_status /* [out] [ref] */,
						 struct policy_handle *_phKey /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateKey_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateKey_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hKey = _hKey;
	state->orig.in.lpSubKey = _lpSubKey;
	state->orig.in.dwOptions = _dwOptions;
	state->orig.in.samDesired = _samDesired;
	state->orig.in.lpSecurityAttributes = _lpSecurityAttributes;

	/* Out parameters */
	state->orig.out.lpdwDisposition = _lpdwDisposition;
	state->orig.out.Status = _Status;
	state->orig.out.rpc_status = _rpc_status;
	state->orig.out.phKey = _phKey;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_CreateKey_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_CreateKey_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateKey_done, req);
	return req;
}

static void dcerpc_clusapi_CreateKey_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_CreateKey_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateKey_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_CreateKey_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.lpdwDisposition = *state->tmp.out.lpdwDisposition;
	*state->orig.out.Status = *state->tmp.out.Status;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;
	*state->orig.out.phKey = *state->tmp.out.phKey;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateKey_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CreateKey_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateKey_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateKey(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle _hKey /* [in]  */,
				  const char *_lpSubKey /* [in] [charset(UTF16),ref] */,
				  uint32_t _dwOptions /* [in]  */,
				  uint32_t _samDesired /* [in]  */,
				  struct RPC_SECURITY_ATTRIBUTES *_lpSecurityAttributes /* [in] [unique] */,
				  uint32_t *_lpdwDisposition /* [out] [ref] */,
				  WERROR *_Status /* [out] [ref] */,
				  WERROR *_rpc_status /* [out] [ref] */,
				  struct policy_handle *_phKey /* [out] [ref] */)
{
	struct clusapi_CreateKey r;
	NTSTATUS status;

	/* In parameters */
	r.in.hKey = _hKey;
	r.in.lpSubKey = _lpSubKey;
	r.in.dwOptions = _dwOptions;
	r.in.samDesired = _samDesired;
	r.in.lpSecurityAttributes = _lpSecurityAttributes;

	/* Out parameters */
	r.out.lpdwDisposition = _lpdwDisposition;
	r.out.Status = _Status;
	r.out.rpc_status = _rpc_status;
	r.out.phKey = _phKey;

	status = dcerpc_clusapi_CreateKey_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_lpdwDisposition = *r.out.lpdwDisposition;
	*_Status = *r.out.Status;
	*_rpc_status = *r.out.rpc_status;
	*_phKey = *r.out.phKey;

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_OpenKey_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OpenKey_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OpenKey_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_OpenKey *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OpenKey_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OpenKey_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OPENKEY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OpenKey_r_done, req);

	return req;
}

static void dcerpc_clusapi_OpenKey_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OpenKey_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OpenKey_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_OpenKey_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OpenKey_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_OpenKey *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OPENKEY, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_OpenKey_state {
	struct clusapi_OpenKey orig;
	struct clusapi_OpenKey tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OpenKey_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OpenKey_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       struct policy_handle _hKey /* [in]  */,
					       const char *_lpSubKey /* [in] [charset(UTF16),ref] */,
					       uint32_t _samDesired /* [in]  */,
					       WERROR *_Status /* [out] [ref] */,
					       WERROR *_rpc_status /* [out] [ref] */,
					       struct policy_handle *_phKey /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OpenKey_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OpenKey_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hKey = _hKey;
	state->orig.in.lpSubKey = _lpSubKey;
	state->orig.in.samDesired = _samDesired;

	/* Out parameters */
	state->orig.out.Status = _Status;
	state->orig.out.rpc_status = _rpc_status;
	state->orig.out.phKey = _phKey;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_OpenKey_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_OpenKey_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OpenKey_done, req);
	return req;
}

static void dcerpc_clusapi_OpenKey_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_OpenKey_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OpenKey_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_OpenKey_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.Status = *state->tmp.out.Status;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;
	*state->orig.out.phKey = *state->tmp.out.phKey;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OpenKey_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OpenKey_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OpenKey_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OpenKey(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				struct policy_handle _hKey /* [in]  */,
				const char *_lpSubKey /* [in] [charset(UTF16),ref] */,
				uint32_t _samDesired /* [in]  */,
				WERROR *_Status /* [out] [ref] */,
				WERROR *_rpc_status /* [out] [ref] */,
				struct policy_handle *_phKey /* [out] [ref] */)
{
	struct clusapi_OpenKey r;
	NTSTATUS status;

	/* In parameters */
	r.in.hKey = _hKey;
	r.in.lpSubKey = _lpSubKey;
	r.in.samDesired = _samDesired;

	/* Out parameters */
	r.out.Status = _Status;
	r.out.rpc_status = _rpc_status;
	r.out.phKey = _phKey;

	status = dcerpc_clusapi_OpenKey_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_Status = *r.out.Status;
	*_rpc_status = *r.out.rpc_status;
	*_phKey = *r.out.phKey;

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_EnumKey_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_EnumKey_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_EnumKey_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_EnumKey *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_EnumKey_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_EnumKey_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ENUMKEY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_EnumKey_r_done, req);

	return req;
}

static void dcerpc_clusapi_EnumKey_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_EnumKey_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_EnumKey_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_EnumKey_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_EnumKey_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_EnumKey *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ENUMKEY, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_EnumKey_state {
	struct clusapi_EnumKey orig;
	struct clusapi_EnumKey tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_EnumKey_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_EnumKey_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       struct policy_handle _hKey /* [in]  */,
					       uint32_t _dwIndex /* [in]  */,
					       const char **_KeyName /* [out] [charset(UTF16),ref] */,
					       NTTIME *_lpftLastWriteTime /* [out] [ref] */,
					       WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_EnumKey_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_EnumKey_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hKey = _hKey;
	state->orig.in.dwIndex = _dwIndex;

	/* Out parameters */
	state->orig.out.KeyName = _KeyName;
	state->orig.out.lpftLastWriteTime = _lpftLastWriteTime;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_EnumKey_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_EnumKey_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_EnumKey_done, req);
	return req;
}

static void dcerpc_clusapi_EnumKey_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_EnumKey_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_EnumKey_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_EnumKey_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.KeyName = *state->tmp.out.KeyName;
	*state->orig.out.lpftLastWriteTime = *state->tmp.out.lpftLastWriteTime;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_EnumKey_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct dcerpc_clusapi_EnumKey_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_EnumKey_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_EnumKey(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				struct policy_handle _hKey /* [in]  */,
				uint32_t _dwIndex /* [in]  */,
				const char **_KeyName /* [out] [charset(UTF16),ref] */,
				NTTIME *_lpftLastWriteTime /* [out] [ref] */,
				WERROR *_rpc_status /* [out] [ref] */,
				WERROR *result)
{
	struct clusapi_EnumKey r;
	NTSTATUS status;

	/* In parameters */
	r.in.hKey = _hKey;
	r.in.dwIndex = _dwIndex;

	/* Out parameters */
	r.out.KeyName = _KeyName;
	r.out.lpftLastWriteTime = _lpftLastWriteTime;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_EnumKey_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_KeyName = *r.out.KeyName;
	*_lpftLastWriteTime = *r.out.lpftLastWriteTime;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_SetValue_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_SetValue_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_SetValue_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_SetValue *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_SetValue_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_SetValue_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_SETVALUE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_SetValue_r_done, req);

	return req;
}

static void dcerpc_clusapi_SetValue_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_SetValue_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_SetValue_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_SetValue_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_SetValue_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_SetValue *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_SETVALUE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_SetValue_state {
	struct clusapi_SetValue orig;
	struct clusapi_SetValue tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_SetValue_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_SetValue_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						struct policy_handle _hKey /* [in]  */,
						const char *_lpValueName /* [in] [charset(UTF16),ref] */,
						enum winreg_Type _dwType /* [in]  */,
						uint8_t *_lpData /* [in] [ref,size_is(cbData)] */,
						uint32_t _cbData /* [in]  */,
						WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_SetValue_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_SetValue_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hKey = _hKey;
	state->orig.in.lpValueName = _lpValueName;
	state->orig.in.dwType = _dwType;
	state->orig.in.lpData = _lpData;
	state->orig.in.cbData = _cbData;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_SetValue_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_SetValue_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_SetValue_done, req);
	return req;
}

static void dcerpc_clusapi_SetValue_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_SetValue_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_SetValue_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_SetValue_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_SetValue_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct dcerpc_clusapi_SetValue_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_SetValue_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_SetValue(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle _hKey /* [in]  */,
				 const char *_lpValueName /* [in] [charset(UTF16),ref] */,
				 enum winreg_Type _dwType /* [in]  */,
				 uint8_t *_lpData /* [in] [ref,size_is(cbData)] */,
				 uint32_t _cbData /* [in]  */,
				 WERROR *_rpc_status /* [out] [ref] */,
				 WERROR *result)
{
	struct clusapi_SetValue r;
	NTSTATUS status;

	/* In parameters */
	r.in.hKey = _hKey;
	r.in.lpValueName = _lpValueName;
	r.in.dwType = _dwType;
	r.in.lpData = _lpData;
	r.in.cbData = _cbData;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_SetValue_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_DeleteValue_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_DeleteValue_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_DeleteValue_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_DeleteValue *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_DeleteValue_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_DeleteValue_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_DELETEVALUE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_DeleteValue_r_done, req);

	return req;
}

static void dcerpc_clusapi_DeleteValue_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_DeleteValue_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_DeleteValue_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_DeleteValue_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_DeleteValue_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_DeleteValue *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_DELETEVALUE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_DeleteValue_state {
	struct clusapi_DeleteValue orig;
	struct clusapi_DeleteValue tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_DeleteValue_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_DeleteValue_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   struct policy_handle _hKey /* [in]  */,
						   const char *_lpValueName /* [in] [charset(UTF16),ref] */,
						   WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_DeleteValue_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_DeleteValue_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hKey = _hKey;
	state->orig.in.lpValueName = _lpValueName;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_DeleteValue_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_DeleteValue_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_DeleteValue_done, req);
	return req;
}

static void dcerpc_clusapi_DeleteValue_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_DeleteValue_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_DeleteValue_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_DeleteValue_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_DeleteValue_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result)
{
	struct dcerpc_clusapi_DeleteValue_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_DeleteValue_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_DeleteValue(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle _hKey /* [in]  */,
				    const char *_lpValueName /* [in] [charset(UTF16),ref] */,
				    WERROR *_rpc_status /* [out] [ref] */,
				    WERROR *result)
{
	struct clusapi_DeleteValue r;
	NTSTATUS status;

	/* In parameters */
	r.in.hKey = _hKey;
	r.in.lpValueName = _lpValueName;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_DeleteValue_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_QueryValue_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_QueryValue_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_QueryValue_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_QueryValue *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_QueryValue_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_QueryValue_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_QUERYVALUE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_QueryValue_r_done, req);

	return req;
}

static void dcerpc_clusapi_QueryValue_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_QueryValue_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_QueryValue_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_QueryValue_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_QueryValue_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_QueryValue *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_QUERYVALUE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_QueryValue_state {
	struct clusapi_QueryValue orig;
	struct clusapi_QueryValue tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_QueryValue_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_QueryValue_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  struct policy_handle _hKey /* [in]  */,
						  const char *_lpValueName /* [in] [charset(UTF16),ref] */,
						  enum winreg_Type *_lpValueType /* [out] [ref] */,
						  uint8_t *_lpData /* [out] [ref,size_is(cbData)] */,
						  uint32_t _cbData /* [in]  */,
						  uint32_t *_lpcbRequired /* [out] [ref] */,
						  WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_QueryValue_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_QueryValue_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hKey = _hKey;
	state->orig.in.lpValueName = _lpValueName;
	state->orig.in.cbData = _cbData;

	/* Out parameters */
	state->orig.out.lpValueType = _lpValueType;
	state->orig.out.lpData = _lpData;
	state->orig.out.lpcbRequired = _lpcbRequired;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_QueryValue_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_QueryValue_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_QueryValue_done, req);
	return req;
}

static void dcerpc_clusapi_QueryValue_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_QueryValue_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_QueryValue_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_QueryValue_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.lpValueType = *state->tmp.out.lpValueType;
	{
		size_t _copy_len_lpData;
		_copy_len_lpData = state->tmp.in.cbData;
		if (state->orig.out.lpData != state->tmp.out.lpData) {
			memcpy(state->orig.out.lpData, state->tmp.out.lpData, _copy_len_lpData * sizeof(*state->orig.out.lpData));
		}
	}
	*state->orig.out.lpcbRequired = *state->tmp.out.lpcbRequired;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_QueryValue_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct dcerpc_clusapi_QueryValue_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_QueryValue_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_QueryValue(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle _hKey /* [in]  */,
				   const char *_lpValueName /* [in] [charset(UTF16),ref] */,
				   enum winreg_Type *_lpValueType /* [out] [ref] */,
				   uint8_t *_lpData /* [out] [ref,size_is(cbData)] */,
				   uint32_t _cbData /* [in]  */,
				   uint32_t *_lpcbRequired /* [out] [ref] */,
				   WERROR *_rpc_status /* [out] [ref] */,
				   WERROR *result)
{
	struct clusapi_QueryValue r;
	NTSTATUS status;

	/* In parameters */
	r.in.hKey = _hKey;
	r.in.lpValueName = _lpValueName;
	r.in.cbData = _cbData;

	/* Out parameters */
	r.out.lpValueType = _lpValueType;
	r.out.lpData = _lpData;
	r.out.lpcbRequired = _lpcbRequired;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_QueryValue_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_lpValueType = *r.out.lpValueType;
	{
		size_t _copy_len_lpData;
		_copy_len_lpData = r.in.cbData;
		if (_lpData != r.out.lpData) {
			memcpy(_lpData, r.out.lpData, _copy_len_lpData * sizeof(*_lpData));
		}
	}
	*_lpcbRequired = *r.out.lpcbRequired;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_DeleteKey_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_DeleteKey_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_DeleteKey_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_DeleteKey *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_DeleteKey_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_DeleteKey_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_DELETEKEY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_DeleteKey_r_done, req);

	return req;
}

static void dcerpc_clusapi_DeleteKey_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_DeleteKey_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_DeleteKey_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_DeleteKey_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_DeleteKey_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_DeleteKey *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_DELETEKEY, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_DeleteKey_state {
	struct clusapi_DeleteKey orig;
	struct clusapi_DeleteKey tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_DeleteKey_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_DeleteKey_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 struct policy_handle _hKey /* [in]  */,
						 const char *_lpSubKey /* [in] [charset(UTF16),ref] */,
						 WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_DeleteKey_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_DeleteKey_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hKey = _hKey;
	state->orig.in.lpSubKey = _lpSubKey;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_DeleteKey_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_DeleteKey_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_DeleteKey_done, req);
	return req;
}

static void dcerpc_clusapi_DeleteKey_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_DeleteKey_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_DeleteKey_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_DeleteKey_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_DeleteKey_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct dcerpc_clusapi_DeleteKey_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_DeleteKey_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_DeleteKey(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle _hKey /* [in]  */,
				  const char *_lpSubKey /* [in] [charset(UTF16),ref] */,
				  WERROR *_rpc_status /* [out] [ref] */,
				  WERROR *result)
{
	struct clusapi_DeleteKey r;
	NTSTATUS status;

	/* In parameters */
	r.in.hKey = _hKey;
	r.in.lpSubKey = _lpSubKey;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_DeleteKey_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_EnumValue_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_EnumValue_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_EnumValue_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_EnumValue *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_EnumValue_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_EnumValue_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ENUMVALUE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_EnumValue_r_done, req);

	return req;
}

static void dcerpc_clusapi_EnumValue_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_EnumValue_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_EnumValue_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_EnumValue_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_EnumValue_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_EnumValue *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ENUMVALUE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_EnumValue_state {
	struct clusapi_EnumValue orig;
	struct clusapi_EnumValue tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_EnumValue_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_EnumValue_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 struct policy_handle _hKey /* [in]  */,
						 uint32_t _dwIndex /* [in]  */,
						 const char **_lpValueName /* [out] [charset(UTF16),ref] */,
						 enum winreg_Type *_lpType /* [out] [ref] */,
						 uint8_t *_lpData /* [out] [ref,size_is(*lpcbData)] */,
						 uint32_t *_lpcbData /* [in,out] [ref] */,
						 uint32_t *_TotalSize /* [out] [ref] */,
						 WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_EnumValue_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_EnumValue_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hKey = _hKey;
	state->orig.in.dwIndex = _dwIndex;
	state->orig.in.lpcbData = _lpcbData;

	/* Out parameters */
	state->orig.out.lpValueName = _lpValueName;
	state->orig.out.lpType = _lpType;
	state->orig.out.lpData = _lpData;
	state->orig.out.lpcbData = _lpcbData;
	state->orig.out.TotalSize = _TotalSize;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_EnumValue_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_EnumValue_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_EnumValue_done, req);
	return req;
}

static void dcerpc_clusapi_EnumValue_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_EnumValue_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_EnumValue_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_EnumValue_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.lpValueName = *state->tmp.out.lpValueName;
	*state->orig.out.lpType = *state->tmp.out.lpType;
	{
		size_t _copy_len_lpData;
		if ((*state->tmp.out.lpcbData) > (*state->tmp.in.lpcbData)) {
			tevent_req_nterror(req, NT_STATUS_INVALID_NETWORK_RESPONSE);
			return;
		}
		_copy_len_lpData = *state->tmp.out.lpcbData;
		if (state->orig.out.lpData != state->tmp.out.lpData) {
			memcpy(state->orig.out.lpData, state->tmp.out.lpData, _copy_len_lpData * sizeof(*state->orig.out.lpData));
		}
	}
	*state->orig.out.lpcbData = *state->tmp.out.lpcbData;
	*state->orig.out.TotalSize = *state->tmp.out.TotalSize;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_EnumValue_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct dcerpc_clusapi_EnumValue_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_EnumValue_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_EnumValue(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle _hKey /* [in]  */,
				  uint32_t _dwIndex /* [in]  */,
				  const char **_lpValueName /* [out] [charset(UTF16),ref] */,
				  enum winreg_Type *_lpType /* [out] [ref] */,
				  uint8_t *_lpData /* [out] [ref,size_is(*lpcbData)] */,
				  uint32_t *_lpcbData /* [in,out] [ref] */,
				  uint32_t *_TotalSize /* [out] [ref] */,
				  WERROR *_rpc_status /* [out] [ref] */,
				  WERROR *result)
{
	struct clusapi_EnumValue r;
	NTSTATUS status;

	/* In parameters */
	r.in.hKey = _hKey;
	r.in.dwIndex = _dwIndex;
	r.in.lpcbData = _lpcbData;

	/* Out parameters */
	r.out.lpValueName = _lpValueName;
	r.out.lpType = _lpType;
	r.out.lpData = _lpData;
	r.out.lpcbData = _lpcbData;
	r.out.TotalSize = _TotalSize;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_EnumValue_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_lpValueName = *r.out.lpValueName;
	*_lpType = *r.out.lpType;
	{
		size_t _copy_len_lpData;
		if ((*r.out.lpcbData) > (*r.in.lpcbData)) {
			return NT_STATUS_INVALID_NETWORK_RESPONSE;
		}
		_copy_len_lpData = *r.out.lpcbData;
		if (_lpData != r.out.lpData) {
			memcpy(_lpData, r.out.lpData, _copy_len_lpData * sizeof(*_lpData));
		}
	}
	*_lpcbData = *r.out.lpcbData;
	*_TotalSize = *r.out.TotalSize;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_CloseKey_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CloseKey_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CloseKey_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_CloseKey *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CloseKey_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CloseKey_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CLOSEKEY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CloseKey_r_done, req);

	return req;
}

static void dcerpc_clusapi_CloseKey_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CloseKey_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CloseKey_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_CloseKey_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CloseKey_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_CloseKey *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CLOSEKEY, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_CloseKey_state {
	struct clusapi_CloseKey orig;
	struct clusapi_CloseKey tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CloseKey_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CloseKey_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						struct policy_handle *_pKey /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CloseKey_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CloseKey_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pKey = _pKey;

	/* Out parameters */
	state->orig.out.pKey = _pKey;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_CloseKey_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_CloseKey_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CloseKey_done, req);
	return req;
}

static void dcerpc_clusapi_CloseKey_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_CloseKey_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CloseKey_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_CloseKey_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pKey = *state->tmp.out.pKey;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CloseKey_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct dcerpc_clusapi_CloseKey_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CloseKey_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CloseKey(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *_pKey /* [in,out] [ref] */,
				 WERROR *result)
{
	struct clusapi_CloseKey r;
	NTSTATUS status;

	/* In parameters */
	r.in.pKey = _pKey;

	/* Out parameters */
	r.out.pKey = _pKey;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_CloseKey_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pKey = *r.out.pKey;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_QueryInfoKey_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_QueryInfoKey_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_QueryInfoKey_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_QueryInfoKey *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_QueryInfoKey_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_QueryInfoKey_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_QUERYINFOKEY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_QueryInfoKey_r_done, req);

	return req;
}

static void dcerpc_clusapi_QueryInfoKey_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_QueryInfoKey_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_QueryInfoKey_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_QueryInfoKey_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_QueryInfoKey_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_QueryInfoKey *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_QUERYINFOKEY, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_QueryInfoKey_state {
	struct clusapi_QueryInfoKey orig;
	struct clusapi_QueryInfoKey tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_QueryInfoKey_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_QueryInfoKey_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle _hKey /* [in]  */,
						    uint32_t *_lpcSubKeys /* [out] [ref] */,
						    uint32_t *_lpcbMaxSubKeyLen /* [out] [ref] */,
						    uint32_t *_lpcValues /* [out] [ref] */,
						    uint32_t *_lpcbMaxValueNameLen /* [out] [ref] */,
						    uint32_t *_lpcbMaxValueLen /* [out] [ref] */,
						    uint32_t *_lpcbSecurityDescriptor /* [out] [ref] */,
						    NTTIME *_lpftLastWriteTime /* [out] [ref] */,
						    WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_QueryInfoKey_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_QueryInfoKey_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hKey = _hKey;

	/* Out parameters */
	state->orig.out.lpcSubKeys = _lpcSubKeys;
	state->orig.out.lpcbMaxSubKeyLen = _lpcbMaxSubKeyLen;
	state->orig.out.lpcValues = _lpcValues;
	state->orig.out.lpcbMaxValueNameLen = _lpcbMaxValueNameLen;
	state->orig.out.lpcbMaxValueLen = _lpcbMaxValueLen;
	state->orig.out.lpcbSecurityDescriptor = _lpcbSecurityDescriptor;
	state->orig.out.lpftLastWriteTime = _lpftLastWriteTime;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_QueryInfoKey_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_QueryInfoKey_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_QueryInfoKey_done, req);
	return req;
}

static void dcerpc_clusapi_QueryInfoKey_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_QueryInfoKey_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_QueryInfoKey_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_QueryInfoKey_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.lpcSubKeys = *state->tmp.out.lpcSubKeys;
	*state->orig.out.lpcbMaxSubKeyLen = *state->tmp.out.lpcbMaxSubKeyLen;
	*state->orig.out.lpcValues = *state->tmp.out.lpcValues;
	*state->orig.out.lpcbMaxValueNameLen = *state->tmp.out.lpcbMaxValueNameLen;
	*state->orig.out.lpcbMaxValueLen = *state->tmp.out.lpcbMaxValueLen;
	*state->orig.out.lpcbSecurityDescriptor = *state->tmp.out.lpcbSecurityDescriptor;
	*state->orig.out.lpftLastWriteTime = *state->tmp.out.lpftLastWriteTime;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_QueryInfoKey_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_clusapi_QueryInfoKey_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_QueryInfoKey_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_QueryInfoKey(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle _hKey /* [in]  */,
				     uint32_t *_lpcSubKeys /* [out] [ref] */,
				     uint32_t *_lpcbMaxSubKeyLen /* [out] [ref] */,
				     uint32_t *_lpcValues /* [out] [ref] */,
				     uint32_t *_lpcbMaxValueNameLen /* [out] [ref] */,
				     uint32_t *_lpcbMaxValueLen /* [out] [ref] */,
				     uint32_t *_lpcbSecurityDescriptor /* [out] [ref] */,
				     NTTIME *_lpftLastWriteTime /* [out] [ref] */,
				     WERROR *_rpc_status /* [out] [ref] */,
				     WERROR *result)
{
	struct clusapi_QueryInfoKey r;
	NTSTATUS status;

	/* In parameters */
	r.in.hKey = _hKey;

	/* Out parameters */
	r.out.lpcSubKeys = _lpcSubKeys;
	r.out.lpcbMaxSubKeyLen = _lpcbMaxSubKeyLen;
	r.out.lpcValues = _lpcValues;
	r.out.lpcbMaxValueNameLen = _lpcbMaxValueNameLen;
	r.out.lpcbMaxValueLen = _lpcbMaxValueLen;
	r.out.lpcbSecurityDescriptor = _lpcbSecurityDescriptor;
	r.out.lpftLastWriteTime = _lpftLastWriteTime;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_QueryInfoKey_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_lpcSubKeys = *r.out.lpcSubKeys;
	*_lpcbMaxSubKeyLen = *r.out.lpcbMaxSubKeyLen;
	*_lpcValues = *r.out.lpcValues;
	*_lpcbMaxValueNameLen = *r.out.lpcbMaxValueNameLen;
	*_lpcbMaxValueLen = *r.out.lpcbMaxValueLen;
	*_lpcbSecurityDescriptor = *r.out.lpcbSecurityDescriptor;
	*_lpftLastWriteTime = *r.out.lpftLastWriteTime;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_SetKeySecurity_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_SetKeySecurity_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_SetKeySecurity_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_SetKeySecurity *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_SetKeySecurity_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_SetKeySecurity_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_SETKEYSECURITY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_SetKeySecurity_r_done, req);

	return req;
}

static void dcerpc_clusapi_SetKeySecurity_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_SetKeySecurity_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_SetKeySecurity_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_SetKeySecurity_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_SetKeySecurity_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_SetKeySecurity *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_SETKEYSECURITY, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_SetKeySecurity_state {
	struct clusapi_SetKeySecurity orig;
	struct clusapi_SetKeySecurity tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_SetKeySecurity_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_SetKeySecurity_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle _hKey /* [in]  */,
						      uint32_t _SecurityInformation /* [in]  */,
						      struct RPC_SECURITY_DESCRIPTOR *_pRpcSecurityDescriptor /* [in] [ref] */,
						      WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_SetKeySecurity_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_SetKeySecurity_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hKey = _hKey;
	state->orig.in.SecurityInformation = _SecurityInformation;
	state->orig.in.pRpcSecurityDescriptor = _pRpcSecurityDescriptor;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_SetKeySecurity_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_SetKeySecurity_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_SetKeySecurity_done, req);
	return req;
}

static void dcerpc_clusapi_SetKeySecurity_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_SetKeySecurity_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_SetKeySecurity_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_SetKeySecurity_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_SetKeySecurity_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_clusapi_SetKeySecurity_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_SetKeySecurity_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_SetKeySecurity(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle _hKey /* [in]  */,
				       uint32_t _SecurityInformation /* [in]  */,
				       struct RPC_SECURITY_DESCRIPTOR *_pRpcSecurityDescriptor /* [in] [ref] */,
				       WERROR *_rpc_status /* [out] [ref] */,
				       WERROR *result)
{
	struct clusapi_SetKeySecurity r;
	NTSTATUS status;

	/* In parameters */
	r.in.hKey = _hKey;
	r.in.SecurityInformation = _SecurityInformation;
	r.in.pRpcSecurityDescriptor = _pRpcSecurityDescriptor;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_SetKeySecurity_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_GetKeySecurity_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetKeySecurity_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetKeySecurity_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_GetKeySecurity *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetKeySecurity_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetKeySecurity_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETKEYSECURITY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetKeySecurity_r_done, req);

	return req;
}

static void dcerpc_clusapi_GetKeySecurity_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetKeySecurity_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_GetKeySecurity_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_GetKeySecurity_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetKeySecurity_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_GetKeySecurity *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETKEYSECURITY, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_GetKeySecurity_state {
	struct clusapi_GetKeySecurity orig;
	struct clusapi_GetKeySecurity tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetKeySecurity_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetKeySecurity_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle _hKey /* [in]  */,
						      uint32_t _SecurityInformation /* [in]  */,
						      struct RPC_SECURITY_DESCRIPTOR *_pRpcSecurityDescriptor /* [in,out] [ref] */,
						      WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetKeySecurity_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetKeySecurity_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hKey = _hKey;
	state->orig.in.SecurityInformation = _SecurityInformation;
	state->orig.in.pRpcSecurityDescriptor = _pRpcSecurityDescriptor;

	/* Out parameters */
	state->orig.out.pRpcSecurityDescriptor = _pRpcSecurityDescriptor;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_GetKeySecurity_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_GetKeySecurity_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetKeySecurity_done, req);
	return req;
}

static void dcerpc_clusapi_GetKeySecurity_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_GetKeySecurity_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetKeySecurity_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_GetKeySecurity_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pRpcSecurityDescriptor = *state->tmp.out.pRpcSecurityDescriptor;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetKeySecurity_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_clusapi_GetKeySecurity_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetKeySecurity_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetKeySecurity(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle _hKey /* [in]  */,
				       uint32_t _SecurityInformation /* [in]  */,
				       struct RPC_SECURITY_DESCRIPTOR *_pRpcSecurityDescriptor /* [in,out] [ref] */,
				       WERROR *_rpc_status /* [out] [ref] */,
				       WERROR *result)
{
	struct clusapi_GetKeySecurity r;
	NTSTATUS status;

	/* In parameters */
	r.in.hKey = _hKey;
	r.in.SecurityInformation = _SecurityInformation;
	r.in.pRpcSecurityDescriptor = _pRpcSecurityDescriptor;

	/* Out parameters */
	r.out.pRpcSecurityDescriptor = _pRpcSecurityDescriptor;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_GetKeySecurity_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pRpcSecurityDescriptor = *r.out.pRpcSecurityDescriptor;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_OpenGroup_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OpenGroup_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OpenGroup_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_OpenGroup *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OpenGroup_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OpenGroup_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OPENGROUP, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OpenGroup_r_done, req);

	return req;
}

static void dcerpc_clusapi_OpenGroup_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OpenGroup_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OpenGroup_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_OpenGroup_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OpenGroup_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_OpenGroup *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OPENGROUP, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_OpenGroup_state {
	struct clusapi_OpenGroup orig;
	struct clusapi_OpenGroup tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OpenGroup_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OpenGroup_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 const char *_lpszGroupName /* [in] [charset(UTF16),ref] */,
						 WERROR *_Status /* [out] [ref] */,
						 WERROR *_rpc_status /* [out] [ref] */,
						 struct policy_handle *_hGroup /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OpenGroup_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OpenGroup_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.lpszGroupName = _lpszGroupName;

	/* Out parameters */
	state->orig.out.Status = _Status;
	state->orig.out.rpc_status = _rpc_status;
	state->orig.out.hGroup = _hGroup;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_OpenGroup_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_OpenGroup_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OpenGroup_done, req);
	return req;
}

static void dcerpc_clusapi_OpenGroup_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_OpenGroup_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OpenGroup_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_OpenGroup_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.Status = *state->tmp.out.Status;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;
	*state->orig.out.hGroup = *state->tmp.out.hGroup;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OpenGroup_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OpenGroup_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OpenGroup_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OpenGroup(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  const char *_lpszGroupName /* [in] [charset(UTF16),ref] */,
				  WERROR *_Status /* [out] [ref] */,
				  WERROR *_rpc_status /* [out] [ref] */,
				  struct policy_handle *_hGroup /* [out] [ref] */)
{
	struct clusapi_OpenGroup r;
	NTSTATUS status;

	/* In parameters */
	r.in.lpszGroupName = _lpszGroupName;

	/* Out parameters */
	r.out.Status = _Status;
	r.out.rpc_status = _rpc_status;
	r.out.hGroup = _hGroup;

	status = dcerpc_clusapi_OpenGroup_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_Status = *r.out.Status;
	*_rpc_status = *r.out.rpc_status;
	*_hGroup = *r.out.hGroup;

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_CreateGroup_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateGroup_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateGroup_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_CreateGroup *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateGroup_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateGroup_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATEGROUP, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateGroup_r_done, req);

	return req;
}

static void dcerpc_clusapi_CreateGroup_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateGroup_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CreateGroup_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_CreateGroup_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateGroup_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_CreateGroup *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATEGROUP, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_CreateGroup_state {
	struct clusapi_CreateGroup orig;
	struct clusapi_CreateGroup tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateGroup_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateGroup_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   const char *_lpszGroupName /* [in] [charset(UTF16),ref] */,
						   WERROR *_Status /* [out] [ref] */,
						   WERROR *_rpc_status /* [out] [ref] */,
						   struct policy_handle *_hGroup /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateGroup_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateGroup_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.lpszGroupName = _lpszGroupName;

	/* Out parameters */
	state->orig.out.Status = _Status;
	state->orig.out.rpc_status = _rpc_status;
	state->orig.out.hGroup = _hGroup;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_CreateGroup_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_CreateGroup_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateGroup_done, req);
	return req;
}

static void dcerpc_clusapi_CreateGroup_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_CreateGroup_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateGroup_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_CreateGroup_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.Status = *state->tmp.out.Status;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;
	*state->orig.out.hGroup = *state->tmp.out.hGroup;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateGroup_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CreateGroup_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateGroup_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateGroup(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    const char *_lpszGroupName /* [in] [charset(UTF16),ref] */,
				    WERROR *_Status /* [out] [ref] */,
				    WERROR *_rpc_status /* [out] [ref] */,
				    struct policy_handle *_hGroup /* [out] [ref] */)
{
	struct clusapi_CreateGroup r;
	NTSTATUS status;

	/* In parameters */
	r.in.lpszGroupName = _lpszGroupName;

	/* Out parameters */
	r.out.Status = _Status;
	r.out.rpc_status = _rpc_status;
	r.out.hGroup = _hGroup;

	status = dcerpc_clusapi_CreateGroup_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_Status = *r.out.Status;
	*_rpc_status = *r.out.rpc_status;
	*_hGroup = *r.out.hGroup;

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_DeleteGroup_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_DeleteGroup_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_DeleteGroup_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_DeleteGroup *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_DeleteGroup_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_DeleteGroup_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_DELETEGROUP, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_DeleteGroup_r_done, req);

	return req;
}

static void dcerpc_clusapi_DeleteGroup_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_DeleteGroup_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_DeleteGroup_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_DeleteGroup_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_DeleteGroup_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_DeleteGroup *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_DELETEGROUP, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_DeleteGroup_state {
	struct clusapi_DeleteGroup orig;
	struct clusapi_DeleteGroup tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_DeleteGroup_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_DeleteGroup_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   struct policy_handle _Group /* [in]  */,
						   uint8_t _force /* [in]  */,
						   WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_DeleteGroup_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_DeleteGroup_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.Group = _Group;
	state->orig.in.force = _force;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_DeleteGroup_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_DeleteGroup_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_DeleteGroup_done, req);
	return req;
}

static void dcerpc_clusapi_DeleteGroup_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_DeleteGroup_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_DeleteGroup_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_DeleteGroup_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_DeleteGroup_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result)
{
	struct dcerpc_clusapi_DeleteGroup_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_DeleteGroup_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_DeleteGroup(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle _Group /* [in]  */,
				    uint8_t _force /* [in]  */,
				    WERROR *_rpc_status /* [out] [ref] */,
				    WERROR *result)
{
	struct clusapi_DeleteGroup r;
	NTSTATUS status;

	/* In parameters */
	r.in.Group = _Group;
	r.in.force = _force;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_DeleteGroup_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_CloseGroup_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CloseGroup_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CloseGroup_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_CloseGroup *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CloseGroup_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CloseGroup_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CLOSEGROUP, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CloseGroup_r_done, req);

	return req;
}

static void dcerpc_clusapi_CloseGroup_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CloseGroup_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CloseGroup_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_CloseGroup_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CloseGroup_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_CloseGroup *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CLOSEGROUP, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_CloseGroup_state {
	struct clusapi_CloseGroup orig;
	struct clusapi_CloseGroup tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CloseGroup_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CloseGroup_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  struct policy_handle *_Group /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CloseGroup_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CloseGroup_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.Group = _Group;

	/* Out parameters */
	state->orig.out.Group = _Group;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_CloseGroup_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_CloseGroup_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CloseGroup_done, req);
	return req;
}

static void dcerpc_clusapi_CloseGroup_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_CloseGroup_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CloseGroup_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_CloseGroup_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.Group = *state->tmp.out.Group;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CloseGroup_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct dcerpc_clusapi_CloseGroup_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CloseGroup_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CloseGroup(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle *_Group /* [in,out] [ref] */,
				   WERROR *result)
{
	struct clusapi_CloseGroup r;
	NTSTATUS status;

	/* In parameters */
	r.in.Group = _Group;

	/* Out parameters */
	r.out.Group = _Group;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_CloseGroup_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_Group = *r.out.Group;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_GetGroupState_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetGroupState_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetGroupState_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_GetGroupState *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetGroupState_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetGroupState_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETGROUPSTATE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetGroupState_r_done, req);

	return req;
}

static void dcerpc_clusapi_GetGroupState_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetGroupState_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_GetGroupState_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_GetGroupState_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetGroupState_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_GetGroupState *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETGROUPSTATE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_GetGroupState_state {
	struct clusapi_GetGroupState orig;
	struct clusapi_GetGroupState tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetGroupState_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetGroupState_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle _hGroup /* [in]  */,
						     enum clusapi_ClusterGroupState *_State /* [out] [ref] */,
						     const char **_NodeName /* [out] [charset(UTF16),ref] */,
						     WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetGroupState_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetGroupState_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hGroup = _hGroup;

	/* Out parameters */
	state->orig.out.State = _State;
	state->orig.out.NodeName = _NodeName;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_GetGroupState_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_GetGroupState_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetGroupState_done, req);
	return req;
}

static void dcerpc_clusapi_GetGroupState_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_GetGroupState_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetGroupState_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_GetGroupState_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.State = *state->tmp.out.State;
	*state->orig.out.NodeName = *state->tmp.out.NodeName;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetGroupState_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_clusapi_GetGroupState_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetGroupState_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetGroupState(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle _hGroup /* [in]  */,
				      enum clusapi_ClusterGroupState *_State /* [out] [ref] */,
				      const char **_NodeName /* [out] [charset(UTF16),ref] */,
				      WERROR *_rpc_status /* [out] [ref] */,
				      WERROR *result)
{
	struct clusapi_GetGroupState r;
	NTSTATUS status;

	/* In parameters */
	r.in.hGroup = _hGroup;

	/* Out parameters */
	r.out.State = _State;
	r.out.NodeName = _NodeName;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_GetGroupState_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_State = *r.out.State;
	*_NodeName = *r.out.NodeName;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_SetGroupName_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_SetGroupName_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_SetGroupName_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_SetGroupName *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_SetGroupName_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_SetGroupName_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_SETGROUPNAME, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_SetGroupName_r_done, req);

	return req;
}

static void dcerpc_clusapi_SetGroupName_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_SetGroupName_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_SetGroupName_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_SetGroupName_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_SetGroupName_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_SetGroupName *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_SETGROUPNAME, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_SetGroupName_state {
	struct clusapi_SetGroupName orig;
	struct clusapi_SetGroupName tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_SetGroupName_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_SetGroupName_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle _hGroup /* [in]  */,
						    const char *_lpszGroupName /* [in] [charset(UTF16),ref] */,
						    WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_SetGroupName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_SetGroupName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hGroup = _hGroup;
	state->orig.in.lpszGroupName = _lpszGroupName;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_SetGroupName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_SetGroupName_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_SetGroupName_done, req);
	return req;
}

static void dcerpc_clusapi_SetGroupName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_SetGroupName_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_SetGroupName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_SetGroupName_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_SetGroupName_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_clusapi_SetGroupName_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_SetGroupName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_SetGroupName(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle _hGroup /* [in]  */,
				     const char *_lpszGroupName /* [in] [charset(UTF16),ref] */,
				     WERROR *_rpc_status /* [out] [ref] */,
				     WERROR *result)
{
	struct clusapi_SetGroupName r;
	NTSTATUS status;

	/* In parameters */
	r.in.hGroup = _hGroup;
	r.in.lpszGroupName = _lpszGroupName;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_SetGroupName_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_GetGroupId_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetGroupId_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetGroupId_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_GetGroupId *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetGroupId_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetGroupId_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETGROUPID, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetGroupId_r_done, req);

	return req;
}

static void dcerpc_clusapi_GetGroupId_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetGroupId_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_GetGroupId_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_GetGroupId_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetGroupId_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_GetGroupId *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETGROUPID, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_GetGroupId_state {
	struct clusapi_GetGroupId orig;
	struct clusapi_GetGroupId tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetGroupId_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetGroupId_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  struct policy_handle _hGroup /* [in]  */,
						  const char **_pGuid /* [out] [charset(UTF16),ref] */,
						  WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetGroupId_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetGroupId_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hGroup = _hGroup;

	/* Out parameters */
	state->orig.out.pGuid = _pGuid;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_GetGroupId_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_GetGroupId_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetGroupId_done, req);
	return req;
}

static void dcerpc_clusapi_GetGroupId_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_GetGroupId_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetGroupId_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_GetGroupId_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pGuid = *state->tmp.out.pGuid;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetGroupId_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct dcerpc_clusapi_GetGroupId_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetGroupId_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetGroupId(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle _hGroup /* [in]  */,
				   const char **_pGuid /* [out] [charset(UTF16),ref] */,
				   WERROR *_rpc_status /* [out] [ref] */,
				   WERROR *result)
{
	struct clusapi_GetGroupId r;
	NTSTATUS status;

	/* In parameters */
	r.in.hGroup = _hGroup;

	/* Out parameters */
	r.out.pGuid = _pGuid;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_GetGroupId_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pGuid = *r.out.pGuid;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_GetNodeId_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetNodeId_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetNodeId_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_GetNodeId *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetNodeId_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetNodeId_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETNODEID, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetNodeId_r_done, req);

	return req;
}

static void dcerpc_clusapi_GetNodeId_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetNodeId_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_GetNodeId_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_GetNodeId_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetNodeId_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_GetNodeId *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETNODEID, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_GetNodeId_state {
	struct clusapi_GetNodeId orig;
	struct clusapi_GetNodeId tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetNodeId_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetNodeId_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 struct policy_handle _hNode /* [in]  */,
						 const char **_pGuid /* [out] [charset(UTF16),ref] */,
						 WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetNodeId_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetNodeId_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNode = _hNode;

	/* Out parameters */
	state->orig.out.pGuid = _pGuid;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_GetNodeId_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_GetNodeId_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetNodeId_done, req);
	return req;
}

static void dcerpc_clusapi_GetNodeId_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_GetNodeId_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetNodeId_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_GetNodeId_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pGuid = *state->tmp.out.pGuid;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetNodeId_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct dcerpc_clusapi_GetNodeId_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetNodeId_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetNodeId(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle _hNode /* [in]  */,
				  const char **_pGuid /* [out] [charset(UTF16),ref] */,
				  WERROR *_rpc_status /* [out] [ref] */,
				  WERROR *result)
{
	struct clusapi_GetNodeId r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNode = _hNode;

	/* Out parameters */
	r.out.pGuid = _pGuid;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_GetNodeId_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pGuid = *r.out.pGuid;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_OnlineGroup_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OnlineGroup_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OnlineGroup_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_OnlineGroup *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OnlineGroup_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OnlineGroup_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ONLINEGROUP, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OnlineGroup_r_done, req);

	return req;
}

static void dcerpc_clusapi_OnlineGroup_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OnlineGroup_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OnlineGroup_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_OnlineGroup_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OnlineGroup_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_OnlineGroup *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ONLINEGROUP, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_OnlineGroup_state {
	struct clusapi_OnlineGroup orig;
	struct clusapi_OnlineGroup tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OnlineGroup_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OnlineGroup_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   struct policy_handle _hGroup /* [in]  */,
						   WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OnlineGroup_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OnlineGroup_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hGroup = _hGroup;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_OnlineGroup_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_OnlineGroup_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OnlineGroup_done, req);
	return req;
}

static void dcerpc_clusapi_OnlineGroup_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_OnlineGroup_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OnlineGroup_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_OnlineGroup_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OnlineGroup_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result)
{
	struct dcerpc_clusapi_OnlineGroup_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OnlineGroup_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OnlineGroup(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle _hGroup /* [in]  */,
				    WERROR *_rpc_status /* [out] [ref] */,
				    WERROR *result)
{
	struct clusapi_OnlineGroup r;
	NTSTATUS status;

	/* In parameters */
	r.in.hGroup = _hGroup;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_OnlineGroup_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_OfflineGroup_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OfflineGroup_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OfflineGroup_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_OfflineGroup *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OfflineGroup_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OfflineGroup_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OFFLINEGROUP, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OfflineGroup_r_done, req);

	return req;
}

static void dcerpc_clusapi_OfflineGroup_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OfflineGroup_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OfflineGroup_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_OfflineGroup_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OfflineGroup_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_OfflineGroup *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OFFLINEGROUP, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_OfflineGroup_state {
	struct clusapi_OfflineGroup orig;
	struct clusapi_OfflineGroup tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OfflineGroup_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OfflineGroup_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle _hGroup /* [in]  */,
						    WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OfflineGroup_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OfflineGroup_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hGroup = _hGroup;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_OfflineGroup_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_OfflineGroup_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OfflineGroup_done, req);
	return req;
}

static void dcerpc_clusapi_OfflineGroup_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_OfflineGroup_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OfflineGroup_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_OfflineGroup_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OfflineGroup_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_clusapi_OfflineGroup_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OfflineGroup_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OfflineGroup(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle _hGroup /* [in]  */,
				     WERROR *_rpc_status /* [out] [ref] */,
				     WERROR *result)
{
	struct clusapi_OfflineGroup r;
	NTSTATUS status;

	/* In parameters */
	r.in.hGroup = _hGroup;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_OfflineGroup_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_MoveGroup_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_MoveGroup_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_MoveGroup_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_MoveGroup *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_MoveGroup_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_MoveGroup_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_MOVEGROUP, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_MoveGroup_r_done, req);

	return req;
}

static void dcerpc_clusapi_MoveGroup_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_MoveGroup_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_MoveGroup_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_MoveGroup_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_MoveGroup_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_MoveGroup *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_MOVEGROUP, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_MoveGroup_state {
	struct clusapi_MoveGroup orig;
	struct clusapi_MoveGroup tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_MoveGroup_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_MoveGroup_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 struct policy_handle _hGroup /* [in]  */,
						 WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_MoveGroup_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_MoveGroup_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hGroup = _hGroup;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_MoveGroup_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_MoveGroup_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_MoveGroup_done, req);
	return req;
}

static void dcerpc_clusapi_MoveGroup_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_MoveGroup_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_MoveGroup_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_MoveGroup_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_MoveGroup_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct dcerpc_clusapi_MoveGroup_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_MoveGroup_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_MoveGroup(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle _hGroup /* [in]  */,
				  WERROR *_rpc_status /* [out] [ref] */,
				  WERROR *result)
{
	struct clusapi_MoveGroup r;
	NTSTATUS status;

	/* In parameters */
	r.in.hGroup = _hGroup;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_MoveGroup_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_MoveGroupToNode_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_MoveGroupToNode_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_MoveGroupToNode_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_MoveGroupToNode *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_MoveGroupToNode_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_MoveGroupToNode_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_MOVEGROUPTONODE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_MoveGroupToNode_r_done, req);

	return req;
}

static void dcerpc_clusapi_MoveGroupToNode_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_MoveGroupToNode_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_MoveGroupToNode_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_MoveGroupToNode_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_MoveGroupToNode_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_MoveGroupToNode *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_MOVEGROUPTONODE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_MoveGroupToNode_state {
	struct clusapi_MoveGroupToNode orig;
	struct clusapi_MoveGroupToNode tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_MoveGroupToNode_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_MoveGroupToNode_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       struct policy_handle _hGroup /* [in]  */,
						       struct policy_handle _hNode /* [in]  */,
						       WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_MoveGroupToNode_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_MoveGroupToNode_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hGroup = _hGroup;
	state->orig.in.hNode = _hNode;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_MoveGroupToNode_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_MoveGroupToNode_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_MoveGroupToNode_done, req);
	return req;
}

static void dcerpc_clusapi_MoveGroupToNode_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_MoveGroupToNode_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_MoveGroupToNode_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_MoveGroupToNode_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_MoveGroupToNode_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct dcerpc_clusapi_MoveGroupToNode_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_MoveGroupToNode_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_MoveGroupToNode(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					struct policy_handle _hGroup /* [in]  */,
					struct policy_handle _hNode /* [in]  */,
					WERROR *_rpc_status /* [out] [ref] */,
					WERROR *result)
{
	struct clusapi_MoveGroupToNode r;
	NTSTATUS status;

	/* In parameters */
	r.in.hGroup = _hGroup;
	r.in.hNode = _hNode;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_MoveGroupToNode_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_CreateGroupResourceEnum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateGroupResourceEnum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateGroupResourceEnum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_CreateGroupResourceEnum *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateGroupResourceEnum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateGroupResourceEnum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATEGROUPRESOURCEENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateGroupResourceEnum_r_done, req);

	return req;
}

static void dcerpc_clusapi_CreateGroupResourceEnum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateGroupResourceEnum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CreateGroupResourceEnum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_CreateGroupResourceEnum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateGroupResourceEnum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_CreateGroupResourceEnum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATEGROUPRESOURCEENUM, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_CreateGroupResourceEnum_state {
	struct clusapi_CreateGroupResourceEnum orig;
	struct clusapi_CreateGroupResourceEnum tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateGroupResourceEnum_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateGroupResourceEnum_send(TALLOC_CTX *mem_ctx,
							       struct tevent_context *ev,
							       struct dcerpc_binding_handle *h,
							       struct policy_handle _hGroup /* [in]  */,
							       uint32_t _dwType /* [in]  */,
							       struct ENUM_LIST **_ReturnEnum /* [out] [ref] */,
							       WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateGroupResourceEnum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateGroupResourceEnum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hGroup = _hGroup;
	state->orig.in.dwType = _dwType;

	/* Out parameters */
	state->orig.out.ReturnEnum = _ReturnEnum;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_CreateGroupResourceEnum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_CreateGroupResourceEnum_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateGroupResourceEnum_done, req);
	return req;
}

static void dcerpc_clusapi_CreateGroupResourceEnum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_CreateGroupResourceEnum_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateGroupResourceEnum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_CreateGroupResourceEnum_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ReturnEnum = *state->tmp.out.ReturnEnum;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateGroupResourceEnum_recv(struct tevent_req *req,
						     TALLOC_CTX *mem_ctx,
						     WERROR *result)
{
	struct dcerpc_clusapi_CreateGroupResourceEnum_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateGroupResourceEnum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateGroupResourceEnum(struct dcerpc_binding_handle *h,
						TALLOC_CTX *mem_ctx,
						struct policy_handle _hGroup /* [in]  */,
						uint32_t _dwType /* [in]  */,
						struct ENUM_LIST **_ReturnEnum /* [out] [ref] */,
						WERROR *_rpc_status /* [out] [ref] */,
						WERROR *result)
{
	struct clusapi_CreateGroupResourceEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.hGroup = _hGroup;
	r.in.dwType = _dwType;

	/* Out parameters */
	r.out.ReturnEnum = _ReturnEnum;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_CreateGroupResourceEnum_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ReturnEnum = *r.out.ReturnEnum;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_SetGroupNodeList_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_SetGroupNodeList_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_SetGroupNodeList_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_SetGroupNodeList *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_SetGroupNodeList_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_SetGroupNodeList_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_SETGROUPNODELIST, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_SetGroupNodeList_r_done, req);

	return req;
}

static void dcerpc_clusapi_SetGroupNodeList_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_SetGroupNodeList_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_SetGroupNodeList_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_SetGroupNodeList_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_SetGroupNodeList_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_SetGroupNodeList *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_SETGROUPNODELIST, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_SetGroupNodeList_state {
	struct clusapi_SetGroupNodeList orig;
	struct clusapi_SetGroupNodeList tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_SetGroupNodeList_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_SetGroupNodeList_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle _hGroup /* [in]  */,
							uint16_t *_multiSzNodeList /* [in] [size_is(cchListSize),unique] */,
							uint32_t _cchListSize /* [in]  */,
							WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_SetGroupNodeList_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_SetGroupNodeList_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hGroup = _hGroup;
	state->orig.in.multiSzNodeList = _multiSzNodeList;
	state->orig.in.cchListSize = _cchListSize;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_SetGroupNodeList_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_SetGroupNodeList_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_SetGroupNodeList_done, req);
	return req;
}

static void dcerpc_clusapi_SetGroupNodeList_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_SetGroupNodeList_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_SetGroupNodeList_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_SetGroupNodeList_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_SetGroupNodeList_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_clusapi_SetGroupNodeList_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_SetGroupNodeList_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_SetGroupNodeList(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle _hGroup /* [in]  */,
					 uint16_t *_multiSzNodeList /* [in] [size_is(cchListSize),unique] */,
					 uint32_t _cchListSize /* [in]  */,
					 WERROR *_rpc_status /* [out] [ref] */,
					 WERROR *result)
{
	struct clusapi_SetGroupNodeList r;
	NTSTATUS status;

	/* In parameters */
	r.in.hGroup = _hGroup;
	r.in.multiSzNodeList = _multiSzNodeList;
	r.in.cchListSize = _cchListSize;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_SetGroupNodeList_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_CreateNotify_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateNotify_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateNotify_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_CreateNotify *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateNotify_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateNotify_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATENOTIFY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateNotify_r_done, req);

	return req;
}

static void dcerpc_clusapi_CreateNotify_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateNotify_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CreateNotify_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_CreateNotify_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateNotify_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_CreateNotify *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATENOTIFY, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_CreateNotify_state {
	struct clusapi_CreateNotify orig;
	struct clusapi_CreateNotify tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateNotify_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateNotify_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    WERROR *_Status /* [out] [ref] */,
						    WERROR *_rpc_status /* [out] [ref] */,
						    struct policy_handle *_hNotify /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateNotify_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateNotify_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */
	state->orig.out.Status = _Status;
	state->orig.out.rpc_status = _rpc_status;
	state->orig.out.hNotify = _hNotify;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_CreateNotify_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_CreateNotify_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateNotify_done, req);
	return req;
}

static void dcerpc_clusapi_CreateNotify_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_CreateNotify_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateNotify_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_CreateNotify_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.Status = *state->tmp.out.Status;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;
	*state->orig.out.hNotify = *state->tmp.out.hNotify;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateNotify_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CreateNotify_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateNotify_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateNotify(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     WERROR *_Status /* [out] [ref] */,
				     WERROR *_rpc_status /* [out] [ref] */,
				     struct policy_handle *_hNotify /* [out] [ref] */)
{
	struct clusapi_CreateNotify r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */
	r.out.Status = _Status;
	r.out.rpc_status = _rpc_status;
	r.out.hNotify = _hNotify;

	status = dcerpc_clusapi_CreateNotify_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_Status = *r.out.Status;
	*_rpc_status = *r.out.rpc_status;
	*_hNotify = *r.out.hNotify;

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_CloseNotify_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CloseNotify_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CloseNotify_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_CloseNotify *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CloseNotify_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CloseNotify_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CLOSENOTIFY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CloseNotify_r_done, req);

	return req;
}

static void dcerpc_clusapi_CloseNotify_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CloseNotify_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CloseNotify_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_CloseNotify_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CloseNotify_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_CloseNotify *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CLOSENOTIFY, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_CloseNotify_state {
	struct clusapi_CloseNotify orig;
	struct clusapi_CloseNotify tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CloseNotify_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CloseNotify_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   struct policy_handle *_Notify /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CloseNotify_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CloseNotify_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.Notify = _Notify;

	/* Out parameters */
	state->orig.out.Notify = _Notify;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_CloseNotify_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_CloseNotify_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CloseNotify_done, req);
	return req;
}

static void dcerpc_clusapi_CloseNotify_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_CloseNotify_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CloseNotify_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_CloseNotify_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.Notify = *state->tmp.out.Notify;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CloseNotify_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result)
{
	struct dcerpc_clusapi_CloseNotify_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CloseNotify_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CloseNotify(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *_Notify /* [in,out] [ref] */,
				    WERROR *result)
{
	struct clusapi_CloseNotify r;
	NTSTATUS status;

	/* In parameters */
	r.in.Notify = _Notify;

	/* Out parameters */
	r.out.Notify = _Notify;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_CloseNotify_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_Notify = *r.out.Notify;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_AddNotifyCluster_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_AddNotifyCluster_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_AddNotifyCluster_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_AddNotifyCluster *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_AddNotifyCluster_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_AddNotifyCluster_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ADDNOTIFYCLUSTER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_AddNotifyCluster_r_done, req);

	return req;
}

static void dcerpc_clusapi_AddNotifyCluster_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_AddNotifyCluster_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_AddNotifyCluster_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_AddNotifyCluster_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_AddNotifyCluster_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_AddNotifyCluster *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ADDNOTIFYCLUSTER, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_AddNotifyCluster_state {
	struct clusapi_AddNotifyCluster orig;
	struct clusapi_AddNotifyCluster tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_AddNotifyCluster_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_AddNotifyCluster_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle _hNotify /* [in]  */,
							struct policy_handle _hCluster /* [in]  */,
							uint32_t _dwFilter /* [in]  */,
							uint32_t _dwNotifyKey /* [in]  */,
							WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_AddNotifyCluster_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_AddNotifyCluster_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNotify = _hNotify;
	state->orig.in.hCluster = _hCluster;
	state->orig.in.dwFilter = _dwFilter;
	state->orig.in.dwNotifyKey = _dwNotifyKey;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_AddNotifyCluster_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_AddNotifyCluster_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_AddNotifyCluster_done, req);
	return req;
}

static void dcerpc_clusapi_AddNotifyCluster_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_AddNotifyCluster_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_AddNotifyCluster_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_AddNotifyCluster_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_AddNotifyCluster_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_clusapi_AddNotifyCluster_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_AddNotifyCluster_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_AddNotifyCluster(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle _hNotify /* [in]  */,
					 struct policy_handle _hCluster /* [in]  */,
					 uint32_t _dwFilter /* [in]  */,
					 uint32_t _dwNotifyKey /* [in]  */,
					 WERROR *_rpc_status /* [out] [ref] */,
					 WERROR *result)
{
	struct clusapi_AddNotifyCluster r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNotify = _hNotify;
	r.in.hCluster = _hCluster;
	r.in.dwFilter = _dwFilter;
	r.in.dwNotifyKey = _dwNotifyKey;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_AddNotifyCluster_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_AddNotifyNode_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_AddNotifyNode_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_AddNotifyNode_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_AddNotifyNode *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_AddNotifyNode_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_AddNotifyNode_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ADDNOTIFYNODE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_AddNotifyNode_r_done, req);

	return req;
}

static void dcerpc_clusapi_AddNotifyNode_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_AddNotifyNode_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_AddNotifyNode_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_AddNotifyNode_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_AddNotifyNode_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_AddNotifyNode *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ADDNOTIFYNODE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_AddNotifyNode_state {
	struct clusapi_AddNotifyNode orig;
	struct clusapi_AddNotifyNode tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_AddNotifyNode_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_AddNotifyNode_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle _hNotify /* [in]  */,
						     struct policy_handle _hNode /* [in]  */,
						     uint32_t _dwFilter /* [in]  */,
						     uint32_t _dwNotifyKey /* [in]  */,
						     uint32_t *_dwStateSequence /* [out] [ref] */,
						     WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_AddNotifyNode_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_AddNotifyNode_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNotify = _hNotify;
	state->orig.in.hNode = _hNode;
	state->orig.in.dwFilter = _dwFilter;
	state->orig.in.dwNotifyKey = _dwNotifyKey;

	/* Out parameters */
	state->orig.out.dwStateSequence = _dwStateSequence;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_AddNotifyNode_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_AddNotifyNode_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_AddNotifyNode_done, req);
	return req;
}

static void dcerpc_clusapi_AddNotifyNode_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_AddNotifyNode_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_AddNotifyNode_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_AddNotifyNode_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.dwStateSequence = *state->tmp.out.dwStateSequence;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_AddNotifyNode_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_clusapi_AddNotifyNode_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_AddNotifyNode_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_AddNotifyNode(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle _hNotify /* [in]  */,
				      struct policy_handle _hNode /* [in]  */,
				      uint32_t _dwFilter /* [in]  */,
				      uint32_t _dwNotifyKey /* [in]  */,
				      uint32_t *_dwStateSequence /* [out] [ref] */,
				      WERROR *_rpc_status /* [out] [ref] */,
				      WERROR *result)
{
	struct clusapi_AddNotifyNode r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNotify = _hNotify;
	r.in.hNode = _hNode;
	r.in.dwFilter = _dwFilter;
	r.in.dwNotifyKey = _dwNotifyKey;

	/* Out parameters */
	r.out.dwStateSequence = _dwStateSequence;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_AddNotifyNode_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_dwStateSequence = *r.out.dwStateSequence;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_AddNotifyGroup_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_AddNotifyGroup_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_AddNotifyGroup_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_AddNotifyGroup *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_AddNotifyGroup_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_AddNotifyGroup_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ADDNOTIFYGROUP, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_AddNotifyGroup_r_done, req);

	return req;
}

static void dcerpc_clusapi_AddNotifyGroup_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_AddNotifyGroup_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_AddNotifyGroup_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_AddNotifyGroup_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_AddNotifyGroup_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_AddNotifyGroup *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ADDNOTIFYGROUP, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_AddNotifyGroup_state {
	struct clusapi_AddNotifyGroup orig;
	struct clusapi_AddNotifyGroup tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_AddNotifyGroup_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_AddNotifyGroup_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle _hNotify /* [in]  */,
						      struct policy_handle _hGroup /* [in]  */,
						      uint32_t _dwFilter /* [in]  */,
						      uint32_t _dwNotifyKey /* [in]  */,
						      uint32_t *_dwStateSequence /* [out] [ref] */,
						      WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_AddNotifyGroup_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_AddNotifyGroup_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNotify = _hNotify;
	state->orig.in.hGroup = _hGroup;
	state->orig.in.dwFilter = _dwFilter;
	state->orig.in.dwNotifyKey = _dwNotifyKey;

	/* Out parameters */
	state->orig.out.dwStateSequence = _dwStateSequence;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_AddNotifyGroup_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_AddNotifyGroup_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_AddNotifyGroup_done, req);
	return req;
}

static void dcerpc_clusapi_AddNotifyGroup_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_AddNotifyGroup_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_AddNotifyGroup_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_AddNotifyGroup_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.dwStateSequence = *state->tmp.out.dwStateSequence;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_AddNotifyGroup_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_clusapi_AddNotifyGroup_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_AddNotifyGroup_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_AddNotifyGroup(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle _hNotify /* [in]  */,
				       struct policy_handle _hGroup /* [in]  */,
				       uint32_t _dwFilter /* [in]  */,
				       uint32_t _dwNotifyKey /* [in]  */,
				       uint32_t *_dwStateSequence /* [out] [ref] */,
				       WERROR *_rpc_status /* [out] [ref] */,
				       WERROR *result)
{
	struct clusapi_AddNotifyGroup r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNotify = _hNotify;
	r.in.hGroup = _hGroup;
	r.in.dwFilter = _dwFilter;
	r.in.dwNotifyKey = _dwNotifyKey;

	/* Out parameters */
	r.out.dwStateSequence = _dwStateSequence;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_AddNotifyGroup_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_dwStateSequence = *r.out.dwStateSequence;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_AddNotifyResource_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_AddNotifyResource_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_AddNotifyResource_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_AddNotifyResource *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_AddNotifyResource_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_AddNotifyResource_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ADDNOTIFYRESOURCE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_AddNotifyResource_r_done, req);

	return req;
}

static void dcerpc_clusapi_AddNotifyResource_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_AddNotifyResource_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_AddNotifyResource_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_AddNotifyResource_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_AddNotifyResource_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_AddNotifyResource *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ADDNOTIFYRESOURCE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_AddNotifyResource_state {
	struct clusapi_AddNotifyResource orig;
	struct clusapi_AddNotifyResource tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_AddNotifyResource_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_AddNotifyResource_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct policy_handle _hNotify /* [in]  */,
							 struct policy_handle _hResource /* [in]  */,
							 uint32_t _dwFilter /* [in]  */,
							 uint32_t _dwNotifyKey /* [in]  */,
							 uint32_t *_dwStateSequence /* [out] [ref] */,
							 WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_AddNotifyResource_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_AddNotifyResource_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNotify = _hNotify;
	state->orig.in.hResource = _hResource;
	state->orig.in.dwFilter = _dwFilter;
	state->orig.in.dwNotifyKey = _dwNotifyKey;

	/* Out parameters */
	state->orig.out.dwStateSequence = _dwStateSequence;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_AddNotifyResource_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_AddNotifyResource_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_AddNotifyResource_done, req);
	return req;
}

static void dcerpc_clusapi_AddNotifyResource_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_AddNotifyResource_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_AddNotifyResource_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_AddNotifyResource_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.dwStateSequence = *state->tmp.out.dwStateSequence;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_AddNotifyResource_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_clusapi_AddNotifyResource_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_AddNotifyResource_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_AddNotifyResource(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle _hNotify /* [in]  */,
					  struct policy_handle _hResource /* [in]  */,
					  uint32_t _dwFilter /* [in]  */,
					  uint32_t _dwNotifyKey /* [in]  */,
					  uint32_t *_dwStateSequence /* [out] [ref] */,
					  WERROR *_rpc_status /* [out] [ref] */,
					  WERROR *result)
{
	struct clusapi_AddNotifyResource r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNotify = _hNotify;
	r.in.hResource = _hResource;
	r.in.dwFilter = _dwFilter;
	r.in.dwNotifyKey = _dwNotifyKey;

	/* Out parameters */
	r.out.dwStateSequence = _dwStateSequence;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_AddNotifyResource_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_dwStateSequence = *r.out.dwStateSequence;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_AddNotifyKey_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_AddNotifyKey_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_AddNotifyKey_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_AddNotifyKey *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_AddNotifyKey_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_AddNotifyKey_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ADDNOTIFYKEY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_AddNotifyKey_r_done, req);

	return req;
}

static void dcerpc_clusapi_AddNotifyKey_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_AddNotifyKey_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_AddNotifyKey_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_AddNotifyKey_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_AddNotifyKey_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_AddNotifyKey *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ADDNOTIFYKEY, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_AddNotifyKey_state {
	struct clusapi_AddNotifyKey orig;
	struct clusapi_AddNotifyKey tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_AddNotifyKey_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_AddNotifyKey_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle _hNotify /* [in]  */,
						    struct policy_handle _hKey /* [in]  */,
						    uint32_t _dwNotifyKey /* [in]  */,
						    uint32_t _Filter /* [in]  */,
						    uint8_t _WatchSubTree /* [in]  */,
						    WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_AddNotifyKey_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_AddNotifyKey_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNotify = _hNotify;
	state->orig.in.hKey = _hKey;
	state->orig.in.dwNotifyKey = _dwNotifyKey;
	state->orig.in.Filter = _Filter;
	state->orig.in.WatchSubTree = _WatchSubTree;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_AddNotifyKey_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_AddNotifyKey_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_AddNotifyKey_done, req);
	return req;
}

static void dcerpc_clusapi_AddNotifyKey_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_AddNotifyKey_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_AddNotifyKey_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_AddNotifyKey_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_AddNotifyKey_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_clusapi_AddNotifyKey_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_AddNotifyKey_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_AddNotifyKey(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle _hNotify /* [in]  */,
				     struct policy_handle _hKey /* [in]  */,
				     uint32_t _dwNotifyKey /* [in]  */,
				     uint32_t _Filter /* [in]  */,
				     uint8_t _WatchSubTree /* [in]  */,
				     WERROR *_rpc_status /* [out] [ref] */,
				     WERROR *result)
{
	struct clusapi_AddNotifyKey r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNotify = _hNotify;
	r.in.hKey = _hKey;
	r.in.dwNotifyKey = _dwNotifyKey;
	r.in.Filter = _Filter;
	r.in.WatchSubTree = _WatchSubTree;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_AddNotifyKey_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_ReAddNotifyNode_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_ReAddNotifyNode_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_ReAddNotifyNode_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_ReAddNotifyNode *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_ReAddNotifyNode_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_ReAddNotifyNode_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_READDNOTIFYNODE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_ReAddNotifyNode_r_done, req);

	return req;
}

static void dcerpc_clusapi_ReAddNotifyNode_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_ReAddNotifyNode_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_ReAddNotifyNode_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_ReAddNotifyNode_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_ReAddNotifyNode_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_ReAddNotifyNode *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_READDNOTIFYNODE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_ReAddNotifyNode_state {
	struct clusapi_ReAddNotifyNode orig;
	struct clusapi_ReAddNotifyNode tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_ReAddNotifyNode_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_ReAddNotifyNode_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       struct policy_handle _hNotify /* [in]  */,
						       struct policy_handle _hNode /* [in]  */,
						       uint32_t _dwFilter /* [in]  */,
						       uint32_t _dwNotifyKey /* [in]  */,
						       uint32_t _StateSequence /* [in]  */,
						       WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_ReAddNotifyNode_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_ReAddNotifyNode_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNotify = _hNotify;
	state->orig.in.hNode = _hNode;
	state->orig.in.dwFilter = _dwFilter;
	state->orig.in.dwNotifyKey = _dwNotifyKey;
	state->orig.in.StateSequence = _StateSequence;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_ReAddNotifyNode_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_ReAddNotifyNode_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_ReAddNotifyNode_done, req);
	return req;
}

static void dcerpc_clusapi_ReAddNotifyNode_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_ReAddNotifyNode_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_ReAddNotifyNode_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_ReAddNotifyNode_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_ReAddNotifyNode_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct dcerpc_clusapi_ReAddNotifyNode_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_ReAddNotifyNode_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_ReAddNotifyNode(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					struct policy_handle _hNotify /* [in]  */,
					struct policy_handle _hNode /* [in]  */,
					uint32_t _dwFilter /* [in]  */,
					uint32_t _dwNotifyKey /* [in]  */,
					uint32_t _StateSequence /* [in]  */,
					WERROR *_rpc_status /* [out] [ref] */,
					WERROR *result)
{
	struct clusapi_ReAddNotifyNode r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNotify = _hNotify;
	r.in.hNode = _hNode;
	r.in.dwFilter = _dwFilter;
	r.in.dwNotifyKey = _dwNotifyKey;
	r.in.StateSequence = _StateSequence;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_ReAddNotifyNode_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_ReAddNotifyGroup_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_ReAddNotifyGroup_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_ReAddNotifyGroup_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_ReAddNotifyGroup *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_ReAddNotifyGroup_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_ReAddNotifyGroup_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_READDNOTIFYGROUP, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_ReAddNotifyGroup_r_done, req);

	return req;
}

static void dcerpc_clusapi_ReAddNotifyGroup_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_ReAddNotifyGroup_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_ReAddNotifyGroup_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_ReAddNotifyGroup_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_ReAddNotifyGroup_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_ReAddNotifyGroup *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_READDNOTIFYGROUP, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_ReAddNotifyGroup_state {
	struct clusapi_ReAddNotifyGroup orig;
	struct clusapi_ReAddNotifyGroup tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_ReAddNotifyGroup_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_ReAddNotifyGroup_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle _hNotify /* [in]  */,
							struct policy_handle _hGroup /* [in]  */,
							uint32_t _dwFilter /* [in]  */,
							uint32_t _dwNotifyKey /* [in]  */,
							uint32_t _StateSequence /* [in]  */,
							WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_ReAddNotifyGroup_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_ReAddNotifyGroup_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNotify = _hNotify;
	state->orig.in.hGroup = _hGroup;
	state->orig.in.dwFilter = _dwFilter;
	state->orig.in.dwNotifyKey = _dwNotifyKey;
	state->orig.in.StateSequence = _StateSequence;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_ReAddNotifyGroup_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_ReAddNotifyGroup_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_ReAddNotifyGroup_done, req);
	return req;
}

static void dcerpc_clusapi_ReAddNotifyGroup_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_ReAddNotifyGroup_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_ReAddNotifyGroup_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_ReAddNotifyGroup_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_ReAddNotifyGroup_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_clusapi_ReAddNotifyGroup_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_ReAddNotifyGroup_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_ReAddNotifyGroup(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle _hNotify /* [in]  */,
					 struct policy_handle _hGroup /* [in]  */,
					 uint32_t _dwFilter /* [in]  */,
					 uint32_t _dwNotifyKey /* [in]  */,
					 uint32_t _StateSequence /* [in]  */,
					 WERROR *_rpc_status /* [out] [ref] */,
					 WERROR *result)
{
	struct clusapi_ReAddNotifyGroup r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNotify = _hNotify;
	r.in.hGroup = _hGroup;
	r.in.dwFilter = _dwFilter;
	r.in.dwNotifyKey = _dwNotifyKey;
	r.in.StateSequence = _StateSequence;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_ReAddNotifyGroup_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_ReAddNotifyResource_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_ReAddNotifyResource_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_ReAddNotifyResource_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_ReAddNotifyResource *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_ReAddNotifyResource_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_ReAddNotifyResource_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_READDNOTIFYRESOURCE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_ReAddNotifyResource_r_done, req);

	return req;
}

static void dcerpc_clusapi_ReAddNotifyResource_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_ReAddNotifyResource_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_ReAddNotifyResource_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_ReAddNotifyResource_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_ReAddNotifyResource_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_ReAddNotifyResource *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_READDNOTIFYRESOURCE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_ReAddNotifyResource_state {
	struct clusapi_ReAddNotifyResource orig;
	struct clusapi_ReAddNotifyResource tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_ReAddNotifyResource_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_ReAddNotifyResource_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   struct policy_handle _hNotify /* [in]  */,
							   struct policy_handle _hResource /* [in]  */,
							   uint32_t _dwFilter /* [in]  */,
							   uint32_t _dwNotifyKey /* [in]  */,
							   uint32_t _StateSequence /* [in]  */,
							   WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_ReAddNotifyResource_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_ReAddNotifyResource_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNotify = _hNotify;
	state->orig.in.hResource = _hResource;
	state->orig.in.dwFilter = _dwFilter;
	state->orig.in.dwNotifyKey = _dwNotifyKey;
	state->orig.in.StateSequence = _StateSequence;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_ReAddNotifyResource_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_ReAddNotifyResource_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_ReAddNotifyResource_done, req);
	return req;
}

static void dcerpc_clusapi_ReAddNotifyResource_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_ReAddNotifyResource_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_ReAddNotifyResource_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_ReAddNotifyResource_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_ReAddNotifyResource_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result)
{
	struct dcerpc_clusapi_ReAddNotifyResource_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_ReAddNotifyResource_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_ReAddNotifyResource(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle _hNotify /* [in]  */,
					    struct policy_handle _hResource /* [in]  */,
					    uint32_t _dwFilter /* [in]  */,
					    uint32_t _dwNotifyKey /* [in]  */,
					    uint32_t _StateSequence /* [in]  */,
					    WERROR *_rpc_status /* [out] [ref] */,
					    WERROR *result)
{
	struct clusapi_ReAddNotifyResource r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNotify = _hNotify;
	r.in.hResource = _hResource;
	r.in.dwFilter = _dwFilter;
	r.in.dwNotifyKey = _dwNotifyKey;
	r.in.StateSequence = _StateSequence;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_ReAddNotifyResource_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_GetNotify_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetNotify_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetNotify_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_GetNotify *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetNotify_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetNotify_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETNOTIFY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetNotify_r_done, req);

	return req;
}

static void dcerpc_clusapi_GetNotify_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetNotify_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_GetNotify_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_GetNotify_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetNotify_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_GetNotify *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETNOTIFY, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_GetNotify_state {
	struct clusapi_GetNotify orig;
	struct clusapi_GetNotify tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetNotify_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetNotify_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 struct policy_handle _hNotify /* [in]  */,
						 uint32_t *_dwNotifyKey /* [out] [ref] */,
						 uint32_t *_dwFilter /* [out] [ref] */,
						 uint32_t *_dwStateSequence /* [out] [ref] */,
						 const char **_Name /* [out] [charset(UTF16),ref] */,
						 WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetNotify_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetNotify_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNotify = _hNotify;

	/* Out parameters */
	state->orig.out.dwNotifyKey = _dwNotifyKey;
	state->orig.out.dwFilter = _dwFilter;
	state->orig.out.dwStateSequence = _dwStateSequence;
	state->orig.out.Name = _Name;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_GetNotify_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_GetNotify_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetNotify_done, req);
	return req;
}

static void dcerpc_clusapi_GetNotify_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_GetNotify_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetNotify_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_GetNotify_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.dwNotifyKey = *state->tmp.out.dwNotifyKey;
	*state->orig.out.dwFilter = *state->tmp.out.dwFilter;
	*state->orig.out.dwStateSequence = *state->tmp.out.dwStateSequence;
	*state->orig.out.Name = *state->tmp.out.Name;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetNotify_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct dcerpc_clusapi_GetNotify_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetNotify_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetNotify(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle _hNotify /* [in]  */,
				  uint32_t *_dwNotifyKey /* [out] [ref] */,
				  uint32_t *_dwFilter /* [out] [ref] */,
				  uint32_t *_dwStateSequence /* [out] [ref] */,
				  const char **_Name /* [out] [charset(UTF16),ref] */,
				  WERROR *_rpc_status /* [out] [ref] */,
				  WERROR *result)
{
	struct clusapi_GetNotify r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNotify = _hNotify;

	/* Out parameters */
	r.out.dwNotifyKey = _dwNotifyKey;
	r.out.dwFilter = _dwFilter;
	r.out.dwStateSequence = _dwStateSequence;
	r.out.Name = _Name;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_GetNotify_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_dwNotifyKey = *r.out.dwNotifyKey;
	*_dwFilter = *r.out.dwFilter;
	*_dwStateSequence = *r.out.dwStateSequence;
	*_Name = *r.out.Name;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_OpenNode_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OpenNode_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OpenNode_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_OpenNode *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OpenNode_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OpenNode_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OPENNODE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OpenNode_r_done, req);

	return req;
}

static void dcerpc_clusapi_OpenNode_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OpenNode_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OpenNode_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_OpenNode_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OpenNode_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_OpenNode *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OPENNODE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_OpenNode_state {
	struct clusapi_OpenNode orig;
	struct clusapi_OpenNode tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OpenNode_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OpenNode_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						const char *_lpszNodeName /* [in] [charset(UTF16),ref] */,
						WERROR *_Status /* [out] [ref] */,
						WERROR *_rpc_status /* [out] [ref] */,
						struct policy_handle *_hNode /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OpenNode_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OpenNode_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.lpszNodeName = _lpszNodeName;

	/* Out parameters */
	state->orig.out.Status = _Status;
	state->orig.out.rpc_status = _rpc_status;
	state->orig.out.hNode = _hNode;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_OpenNode_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_OpenNode_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OpenNode_done, req);
	return req;
}

static void dcerpc_clusapi_OpenNode_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_OpenNode_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OpenNode_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_OpenNode_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.Status = *state->tmp.out.Status;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;
	*state->orig.out.hNode = *state->tmp.out.hNode;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OpenNode_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OpenNode_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OpenNode_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OpenNode(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 const char *_lpszNodeName /* [in] [charset(UTF16),ref] */,
				 WERROR *_Status /* [out] [ref] */,
				 WERROR *_rpc_status /* [out] [ref] */,
				 struct policy_handle *_hNode /* [out] [ref] */)
{
	struct clusapi_OpenNode r;
	NTSTATUS status;

	/* In parameters */
	r.in.lpszNodeName = _lpszNodeName;

	/* Out parameters */
	r.out.Status = _Status;
	r.out.rpc_status = _rpc_status;
	r.out.hNode = _hNode;

	status = dcerpc_clusapi_OpenNode_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_Status = *r.out.Status;
	*_rpc_status = *r.out.rpc_status;
	*_hNode = *r.out.hNode;

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_CloseNode_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CloseNode_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CloseNode_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_CloseNode *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CloseNode_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CloseNode_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CLOSENODE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CloseNode_r_done, req);

	return req;
}

static void dcerpc_clusapi_CloseNode_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CloseNode_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CloseNode_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_CloseNode_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CloseNode_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_CloseNode *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CLOSENODE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_CloseNode_state {
	struct clusapi_CloseNode orig;
	struct clusapi_CloseNode tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CloseNode_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CloseNode_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 struct policy_handle *_Node /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CloseNode_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CloseNode_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.Node = _Node;

	/* Out parameters */
	state->orig.out.Node = _Node;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_CloseNode_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_CloseNode_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CloseNode_done, req);
	return req;
}

static void dcerpc_clusapi_CloseNode_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_CloseNode_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CloseNode_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_CloseNode_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.Node = *state->tmp.out.Node;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CloseNode_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct dcerpc_clusapi_CloseNode_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CloseNode_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CloseNode(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *_Node /* [in,out] [ref] */,
				  WERROR *result)
{
	struct clusapi_CloseNode r;
	NTSTATUS status;

	/* In parameters */
	r.in.Node = _Node;

	/* Out parameters */
	r.out.Node = _Node;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_CloseNode_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_Node = *r.out.Node;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_GetNodeState_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetNodeState_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetNodeState_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_GetNodeState *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetNodeState_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetNodeState_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETNODESTATE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetNodeState_r_done, req);

	return req;
}

static void dcerpc_clusapi_GetNodeState_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetNodeState_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_GetNodeState_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_GetNodeState_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetNodeState_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_GetNodeState *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETNODESTATE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_GetNodeState_state {
	struct clusapi_GetNodeState orig;
	struct clusapi_GetNodeState tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetNodeState_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetNodeState_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle _hNode /* [in]  */,
						    enum clusapi_ClusterNodeState *_State /* [out] [ref] */,
						    WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetNodeState_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetNodeState_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNode = _hNode;

	/* Out parameters */
	state->orig.out.State = _State;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_GetNodeState_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_GetNodeState_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetNodeState_done, req);
	return req;
}

static void dcerpc_clusapi_GetNodeState_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_GetNodeState_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetNodeState_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_GetNodeState_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.State = *state->tmp.out.State;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetNodeState_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_clusapi_GetNodeState_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetNodeState_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetNodeState(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle _hNode /* [in]  */,
				     enum clusapi_ClusterNodeState *_State /* [out] [ref] */,
				     WERROR *_rpc_status /* [out] [ref] */,
				     WERROR *result)
{
	struct clusapi_GetNodeState r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNode = _hNode;

	/* Out parameters */
	r.out.State = _State;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_GetNodeState_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_State = *r.out.State;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_PauseNode_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_PauseNode_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_PauseNode_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_PauseNode *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_PauseNode_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_PauseNode_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_PAUSENODE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_PauseNode_r_done, req);

	return req;
}

static void dcerpc_clusapi_PauseNode_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_PauseNode_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_PauseNode_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_PauseNode_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_PauseNode_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_PauseNode *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_PAUSENODE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_PauseNode_state {
	struct clusapi_PauseNode orig;
	struct clusapi_PauseNode tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_PauseNode_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_PauseNode_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 struct policy_handle _hNode /* [in]  */,
						 WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_PauseNode_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_PauseNode_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNode = _hNode;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_PauseNode_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_PauseNode_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_PauseNode_done, req);
	return req;
}

static void dcerpc_clusapi_PauseNode_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_PauseNode_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_PauseNode_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_PauseNode_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_PauseNode_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct dcerpc_clusapi_PauseNode_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_PauseNode_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_PauseNode(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle _hNode /* [in]  */,
				  WERROR *_rpc_status /* [out] [ref] */,
				  WERROR *result)
{
	struct clusapi_PauseNode r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNode = _hNode;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_PauseNode_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_ResumeNode_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_ResumeNode_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_ResumeNode_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_ResumeNode *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_ResumeNode_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_ResumeNode_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_RESUMENODE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_ResumeNode_r_done, req);

	return req;
}

static void dcerpc_clusapi_ResumeNode_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_ResumeNode_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_ResumeNode_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_ResumeNode_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_ResumeNode_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_ResumeNode *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_RESUMENODE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_ResumeNode_state {
	struct clusapi_ResumeNode orig;
	struct clusapi_ResumeNode tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_ResumeNode_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_ResumeNode_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  struct policy_handle _hNode /* [in]  */,
						  WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_ResumeNode_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_ResumeNode_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNode = _hNode;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_ResumeNode_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_ResumeNode_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_ResumeNode_done, req);
	return req;
}

static void dcerpc_clusapi_ResumeNode_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_ResumeNode_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_ResumeNode_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_ResumeNode_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_ResumeNode_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct dcerpc_clusapi_ResumeNode_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_ResumeNode_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_ResumeNode(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle _hNode /* [in]  */,
				   WERROR *_rpc_status /* [out] [ref] */,
				   WERROR *result)
{
	struct clusapi_ResumeNode r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNode = _hNode;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_ResumeNode_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_EvictNode_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_EvictNode_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_EvictNode_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_EvictNode *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_EvictNode_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_EvictNode_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_EVICTNODE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_EvictNode_r_done, req);

	return req;
}

static void dcerpc_clusapi_EvictNode_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_EvictNode_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_EvictNode_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_EvictNode_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_EvictNode_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_EvictNode *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_EVICTNODE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_EvictNode_state {
	struct clusapi_EvictNode orig;
	struct clusapi_EvictNode tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_EvictNode_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_EvictNode_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 struct policy_handle _hNode /* [in]  */,
						 WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_EvictNode_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_EvictNode_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNode = _hNode;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_EvictNode_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_EvictNode_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_EvictNode_done, req);
	return req;
}

static void dcerpc_clusapi_EvictNode_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_EvictNode_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_EvictNode_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_EvictNode_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_EvictNode_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct dcerpc_clusapi_EvictNode_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_EvictNode_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_EvictNode(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle _hNode /* [in]  */,
				  WERROR *_rpc_status /* [out] [ref] */,
				  WERROR *result)
{
	struct clusapi_EvictNode r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNode = _hNode;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_EvictNode_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_NodeResourceControl_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_NodeResourceControl_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_NodeResourceControl_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_NodeResourceControl *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_NodeResourceControl_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_NodeResourceControl_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_NODERESOURCECONTROL, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_NodeResourceControl_r_done, req);

	return req;
}

static void dcerpc_clusapi_NodeResourceControl_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_NodeResourceControl_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_NodeResourceControl_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_NodeResourceControl_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_NodeResourceControl_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_NodeResourceControl *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_NODERESOURCECONTROL, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_NodeResourceControl_state {
	struct clusapi_NodeResourceControl orig;
	struct clusapi_NodeResourceControl tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_NodeResourceControl_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_NodeResourceControl_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   struct policy_handle _hResource /* [in]  */,
							   struct policy_handle _hNode /* [in]  */,
							   uint32_t _dwControlCode /* [in]  */,
							   uint8_t *_lpInBuffer /* [in] [size_is(nInBufferSize),unique] */,
							   uint32_t _nInBufferSize /* [in]  */,
							   uint8_t *_lpOutBuffer /* [out] [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */,
							   uint32_t _nOutBufferSize /* [in]  */,
							   uint32_t *_lpBytesReturned /* [out] [ref] */,
							   uint32_t *_lpcbRequired /* [out] [ref] */,
							   WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_NodeResourceControl_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_NodeResourceControl_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hResource = _hResource;
	state->orig.in.hNode = _hNode;
	state->orig.in.dwControlCode = _dwControlCode;
	state->orig.in.lpInBuffer = _lpInBuffer;
	state->orig.in.nInBufferSize = _nInBufferSize;
	state->orig.in.nOutBufferSize = _nOutBufferSize;

	/* Out parameters */
	state->orig.out.lpOutBuffer = _lpOutBuffer;
	state->orig.out.lpBytesReturned = _lpBytesReturned;
	state->orig.out.lpcbRequired = _lpcbRequired;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_NodeResourceControl_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_NodeResourceControl_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_NodeResourceControl_done, req);
	return req;
}

static void dcerpc_clusapi_NodeResourceControl_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_NodeResourceControl_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_NodeResourceControl_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_NodeResourceControl_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_lpOutBuffer;
		if ((*state->tmp.out.lpBytesReturned) > (state->tmp.in.nOutBufferSize)) {
			tevent_req_nterror(req, NT_STATUS_INVALID_NETWORK_RESPONSE);
			return;
		}
		_copy_len_lpOutBuffer = *state->tmp.out.lpBytesReturned;
		if (state->orig.out.lpOutBuffer != state->tmp.out.lpOutBuffer) {
			memcpy(state->orig.out.lpOutBuffer, state->tmp.out.lpOutBuffer, _copy_len_lpOutBuffer * sizeof(*state->orig.out.lpOutBuffer));
		}
	}
	*state->orig.out.lpBytesReturned = *state->tmp.out.lpBytesReturned;
	*state->orig.out.lpcbRequired = *state->tmp.out.lpcbRequired;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_NodeResourceControl_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result)
{
	struct dcerpc_clusapi_NodeResourceControl_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_NodeResourceControl_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_NodeResourceControl(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle _hResource /* [in]  */,
					    struct policy_handle _hNode /* [in]  */,
					    uint32_t _dwControlCode /* [in]  */,
					    uint8_t *_lpInBuffer /* [in] [size_is(nInBufferSize),unique] */,
					    uint32_t _nInBufferSize /* [in]  */,
					    uint8_t *_lpOutBuffer /* [out] [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */,
					    uint32_t _nOutBufferSize /* [in]  */,
					    uint32_t *_lpBytesReturned /* [out] [ref] */,
					    uint32_t *_lpcbRequired /* [out] [ref] */,
					    WERROR *_rpc_status /* [out] [ref] */,
					    WERROR *result)
{
	struct clusapi_NodeResourceControl r;
	NTSTATUS status;

	/* In parameters */
	r.in.hResource = _hResource;
	r.in.hNode = _hNode;
	r.in.dwControlCode = _dwControlCode;
	r.in.lpInBuffer = _lpInBuffer;
	r.in.nInBufferSize = _nInBufferSize;
	r.in.nOutBufferSize = _nOutBufferSize;

	/* Out parameters */
	r.out.lpOutBuffer = _lpOutBuffer;
	r.out.lpBytesReturned = _lpBytesReturned;
	r.out.lpcbRequired = _lpcbRequired;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_NodeResourceControl_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_lpOutBuffer;
		if ((*r.out.lpBytesReturned) > (r.in.nOutBufferSize)) {
			return NT_STATUS_INVALID_NETWORK_RESPONSE;
		}
		_copy_len_lpOutBuffer = *r.out.lpBytesReturned;
		if (_lpOutBuffer != r.out.lpOutBuffer) {
			memcpy(_lpOutBuffer, r.out.lpOutBuffer, _copy_len_lpOutBuffer * sizeof(*_lpOutBuffer));
		}
	}
	*_lpBytesReturned = *r.out.lpBytesReturned;
	*_lpcbRequired = *r.out.lpcbRequired;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_ResourceControl_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_ResourceControl_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_ResourceControl_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_ResourceControl *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_ResourceControl_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_ResourceControl_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_RESOURCECONTROL, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_ResourceControl_r_done, req);

	return req;
}

static void dcerpc_clusapi_ResourceControl_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_ResourceControl_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_ResourceControl_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_ResourceControl_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_ResourceControl_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_ResourceControl *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_RESOURCECONTROL, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_ResourceControl_state {
	struct clusapi_ResourceControl orig;
	struct clusapi_ResourceControl tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_ResourceControl_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_ResourceControl_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       struct policy_handle _hResource /* [in]  */,
						       enum clusapi_ResourceControlCode _dwControlCode /* [in]  */,
						       uint8_t *_lpInBuffer /* [in] [size_is(nInBufferSize),unique] */,
						       uint32_t _nInBufferSize /* [in]  */,
						       uint8_t *_lpOutBuffer /* [out] [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */,
						       uint32_t _nOutBufferSize /* [in]  */,
						       uint32_t *_lpBytesReturned /* [out] [ref] */,
						       uint32_t *_lpcbRequired /* [out] [ref] */,
						       WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_ResourceControl_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_ResourceControl_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hResource = _hResource;
	state->orig.in.dwControlCode = _dwControlCode;
	state->orig.in.lpInBuffer = _lpInBuffer;
	state->orig.in.nInBufferSize = _nInBufferSize;
	state->orig.in.nOutBufferSize = _nOutBufferSize;

	/* Out parameters */
	state->orig.out.lpOutBuffer = _lpOutBuffer;
	state->orig.out.lpBytesReturned = _lpBytesReturned;
	state->orig.out.lpcbRequired = _lpcbRequired;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_ResourceControl_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_ResourceControl_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_ResourceControl_done, req);
	return req;
}

static void dcerpc_clusapi_ResourceControl_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_ResourceControl_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_ResourceControl_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_ResourceControl_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_lpOutBuffer;
		if ((*state->tmp.out.lpBytesReturned) > (state->tmp.in.nOutBufferSize)) {
			tevent_req_nterror(req, NT_STATUS_INVALID_NETWORK_RESPONSE);
			return;
		}
		_copy_len_lpOutBuffer = *state->tmp.out.lpBytesReturned;
		if (state->orig.out.lpOutBuffer != state->tmp.out.lpOutBuffer) {
			memcpy(state->orig.out.lpOutBuffer, state->tmp.out.lpOutBuffer, _copy_len_lpOutBuffer * sizeof(*state->orig.out.lpOutBuffer));
		}
	}
	*state->orig.out.lpBytesReturned = *state->tmp.out.lpBytesReturned;
	*state->orig.out.lpcbRequired = *state->tmp.out.lpcbRequired;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_ResourceControl_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct dcerpc_clusapi_ResourceControl_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_ResourceControl_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_ResourceControl(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					struct policy_handle _hResource /* [in]  */,
					enum clusapi_ResourceControlCode _dwControlCode /* [in]  */,
					uint8_t *_lpInBuffer /* [in] [size_is(nInBufferSize),unique] */,
					uint32_t _nInBufferSize /* [in]  */,
					uint8_t *_lpOutBuffer /* [out] [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */,
					uint32_t _nOutBufferSize /* [in]  */,
					uint32_t *_lpBytesReturned /* [out] [ref] */,
					uint32_t *_lpcbRequired /* [out] [ref] */,
					WERROR *_rpc_status /* [out] [ref] */,
					WERROR *result)
{
	struct clusapi_ResourceControl r;
	NTSTATUS status;

	/* In parameters */
	r.in.hResource = _hResource;
	r.in.dwControlCode = _dwControlCode;
	r.in.lpInBuffer = _lpInBuffer;
	r.in.nInBufferSize = _nInBufferSize;
	r.in.nOutBufferSize = _nOutBufferSize;

	/* Out parameters */
	r.out.lpOutBuffer = _lpOutBuffer;
	r.out.lpBytesReturned = _lpBytesReturned;
	r.out.lpcbRequired = _lpcbRequired;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_ResourceControl_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_lpOutBuffer;
		if ((*r.out.lpBytesReturned) > (r.in.nOutBufferSize)) {
			return NT_STATUS_INVALID_NETWORK_RESPONSE;
		}
		_copy_len_lpOutBuffer = *r.out.lpBytesReturned;
		if (_lpOutBuffer != r.out.lpOutBuffer) {
			memcpy(_lpOutBuffer, r.out.lpOutBuffer, _copy_len_lpOutBuffer * sizeof(*_lpOutBuffer));
		}
	}
	*_lpBytesReturned = *r.out.lpBytesReturned;
	*_lpcbRequired = *r.out.lpcbRequired;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_NodeResourceTypeControl_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_NodeResourceTypeControl_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_NodeResourceTypeControl_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_NodeResourceTypeControl *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_NodeResourceTypeControl_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_NodeResourceTypeControl_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_NODERESOURCETYPECONTROL, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_NodeResourceTypeControl_r_done, req);

	return req;
}

static void dcerpc_clusapi_NodeResourceTypeControl_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_NodeResourceTypeControl_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_NodeResourceTypeControl_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_NodeResourceTypeControl_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_NodeResourceTypeControl_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_NodeResourceTypeControl *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_NODERESOURCETYPECONTROL, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_NodeResourceTypeControl_state {
	struct clusapi_NodeResourceTypeControl orig;
	struct clusapi_NodeResourceTypeControl tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_NodeResourceTypeControl_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_NodeResourceTypeControl_send(TALLOC_CTX *mem_ctx,
							       struct tevent_context *ev,
							       struct dcerpc_binding_handle *h,
							       struct policy_handle _hCluster /* [in]  */,
							       const char *_lpszResourceTypeName /* [in] [charset(UTF16),ref] */,
							       struct policy_handle _hNode /* [in]  */,
							       uint32_t _dwControlCode /* [in]  */,
							       uint8_t *_lpInBuffer /* [in] [size_is(nInBufferSize),unique] */,
							       uint32_t _nInBufferSize /* [in]  */,
							       uint8_t *_lpOutBuffer /* [out] [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */,
							       uint32_t _nOutBufferSize /* [in]  */,
							       uint32_t *_lpBytesReturned /* [out] [ref] */,
							       uint32_t *_lpcbRequired /* [out] [ref] */,
							       WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_NodeResourceTypeControl_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_NodeResourceTypeControl_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hCluster = _hCluster;
	state->orig.in.lpszResourceTypeName = _lpszResourceTypeName;
	state->orig.in.hNode = _hNode;
	state->orig.in.dwControlCode = _dwControlCode;
	state->orig.in.lpInBuffer = _lpInBuffer;
	state->orig.in.nInBufferSize = _nInBufferSize;
	state->orig.in.nOutBufferSize = _nOutBufferSize;

	/* Out parameters */
	state->orig.out.lpOutBuffer = _lpOutBuffer;
	state->orig.out.lpBytesReturned = _lpBytesReturned;
	state->orig.out.lpcbRequired = _lpcbRequired;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_NodeResourceTypeControl_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_NodeResourceTypeControl_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_NodeResourceTypeControl_done, req);
	return req;
}

static void dcerpc_clusapi_NodeResourceTypeControl_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_NodeResourceTypeControl_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_NodeResourceTypeControl_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_NodeResourceTypeControl_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_lpOutBuffer;
		if ((*state->tmp.out.lpBytesReturned) > (state->tmp.in.nOutBufferSize)) {
			tevent_req_nterror(req, NT_STATUS_INVALID_NETWORK_RESPONSE);
			return;
		}
		_copy_len_lpOutBuffer = *state->tmp.out.lpBytesReturned;
		if (state->orig.out.lpOutBuffer != state->tmp.out.lpOutBuffer) {
			memcpy(state->orig.out.lpOutBuffer, state->tmp.out.lpOutBuffer, _copy_len_lpOutBuffer * sizeof(*state->orig.out.lpOutBuffer));
		}
	}
	*state->orig.out.lpBytesReturned = *state->tmp.out.lpBytesReturned;
	*state->orig.out.lpcbRequired = *state->tmp.out.lpcbRequired;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_NodeResourceTypeControl_recv(struct tevent_req *req,
						     TALLOC_CTX *mem_ctx,
						     WERROR *result)
{
	struct dcerpc_clusapi_NodeResourceTypeControl_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_NodeResourceTypeControl_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_NodeResourceTypeControl(struct dcerpc_binding_handle *h,
						TALLOC_CTX *mem_ctx,
						struct policy_handle _hCluster /* [in]  */,
						const char *_lpszResourceTypeName /* [in] [charset(UTF16),ref] */,
						struct policy_handle _hNode /* [in]  */,
						uint32_t _dwControlCode /* [in]  */,
						uint8_t *_lpInBuffer /* [in] [size_is(nInBufferSize),unique] */,
						uint32_t _nInBufferSize /* [in]  */,
						uint8_t *_lpOutBuffer /* [out] [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */,
						uint32_t _nOutBufferSize /* [in]  */,
						uint32_t *_lpBytesReturned /* [out] [ref] */,
						uint32_t *_lpcbRequired /* [out] [ref] */,
						WERROR *_rpc_status /* [out] [ref] */,
						WERROR *result)
{
	struct clusapi_NodeResourceTypeControl r;
	NTSTATUS status;

	/* In parameters */
	r.in.hCluster = _hCluster;
	r.in.lpszResourceTypeName = _lpszResourceTypeName;
	r.in.hNode = _hNode;
	r.in.dwControlCode = _dwControlCode;
	r.in.lpInBuffer = _lpInBuffer;
	r.in.nInBufferSize = _nInBufferSize;
	r.in.nOutBufferSize = _nOutBufferSize;

	/* Out parameters */
	r.out.lpOutBuffer = _lpOutBuffer;
	r.out.lpBytesReturned = _lpBytesReturned;
	r.out.lpcbRequired = _lpcbRequired;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_NodeResourceTypeControl_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_lpOutBuffer;
		if ((*r.out.lpBytesReturned) > (r.in.nOutBufferSize)) {
			return NT_STATUS_INVALID_NETWORK_RESPONSE;
		}
		_copy_len_lpOutBuffer = *r.out.lpBytesReturned;
		if (_lpOutBuffer != r.out.lpOutBuffer) {
			memcpy(_lpOutBuffer, r.out.lpOutBuffer, _copy_len_lpOutBuffer * sizeof(*_lpOutBuffer));
		}
	}
	*_lpBytesReturned = *r.out.lpBytesReturned;
	*_lpcbRequired = *r.out.lpcbRequired;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_ResourceTypeControl_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_ResourceTypeControl_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_ResourceTypeControl_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_ResourceTypeControl *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_ResourceTypeControl_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_ResourceTypeControl_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_RESOURCETYPECONTROL, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_ResourceTypeControl_r_done, req);

	return req;
}

static void dcerpc_clusapi_ResourceTypeControl_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_ResourceTypeControl_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_ResourceTypeControl_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_ResourceTypeControl_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_ResourceTypeControl_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_ResourceTypeControl *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_RESOURCETYPECONTROL, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_ResourceTypeControl_state {
	struct clusapi_ResourceTypeControl orig;
	struct clusapi_ResourceTypeControl tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_ResourceTypeControl_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_ResourceTypeControl_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   struct policy_handle _hCluster /* [in]  */,
							   const char *_lpszResourceTypeName /* [in] [charset(UTF16),ref] */,
							   enum clusapi_ResourceTypeControlCode _dwControlCode /* [in]  */,
							   uint8_t *_lpInBuffer /* [in] [size_is(nInBufferSize),unique] */,
							   uint32_t _nInBufferSize /* [in]  */,
							   uint8_t *_lpOutBuffer /* [out] [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */,
							   uint32_t _nOutBufferSize /* [in]  */,
							   uint32_t *_lpBytesReturned /* [out] [ref] */,
							   uint32_t *_lpcbRequired /* [out] [ref] */,
							   WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_ResourceTypeControl_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_ResourceTypeControl_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hCluster = _hCluster;
	state->orig.in.lpszResourceTypeName = _lpszResourceTypeName;
	state->orig.in.dwControlCode = _dwControlCode;
	state->orig.in.lpInBuffer = _lpInBuffer;
	state->orig.in.nInBufferSize = _nInBufferSize;
	state->orig.in.nOutBufferSize = _nOutBufferSize;

	/* Out parameters */
	state->orig.out.lpOutBuffer = _lpOutBuffer;
	state->orig.out.lpBytesReturned = _lpBytesReturned;
	state->orig.out.lpcbRequired = _lpcbRequired;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_ResourceTypeControl_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_ResourceTypeControl_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_ResourceTypeControl_done, req);
	return req;
}

static void dcerpc_clusapi_ResourceTypeControl_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_ResourceTypeControl_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_ResourceTypeControl_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_ResourceTypeControl_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_lpOutBuffer;
		if ((*state->tmp.out.lpBytesReturned) > (state->tmp.in.nOutBufferSize)) {
			tevent_req_nterror(req, NT_STATUS_INVALID_NETWORK_RESPONSE);
			return;
		}
		_copy_len_lpOutBuffer = *state->tmp.out.lpBytesReturned;
		if (state->orig.out.lpOutBuffer != state->tmp.out.lpOutBuffer) {
			memcpy(state->orig.out.lpOutBuffer, state->tmp.out.lpOutBuffer, _copy_len_lpOutBuffer * sizeof(*state->orig.out.lpOutBuffer));
		}
	}
	*state->orig.out.lpBytesReturned = *state->tmp.out.lpBytesReturned;
	*state->orig.out.lpcbRequired = *state->tmp.out.lpcbRequired;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_ResourceTypeControl_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result)
{
	struct dcerpc_clusapi_ResourceTypeControl_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_ResourceTypeControl_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_ResourceTypeControl(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle _hCluster /* [in]  */,
					    const char *_lpszResourceTypeName /* [in] [charset(UTF16),ref] */,
					    enum clusapi_ResourceTypeControlCode _dwControlCode /* [in]  */,
					    uint8_t *_lpInBuffer /* [in] [size_is(nInBufferSize),unique] */,
					    uint32_t _nInBufferSize /* [in]  */,
					    uint8_t *_lpOutBuffer /* [out] [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */,
					    uint32_t _nOutBufferSize /* [in]  */,
					    uint32_t *_lpBytesReturned /* [out] [ref] */,
					    uint32_t *_lpcbRequired /* [out] [ref] */,
					    WERROR *_rpc_status /* [out] [ref] */,
					    WERROR *result)
{
	struct clusapi_ResourceTypeControl r;
	NTSTATUS status;

	/* In parameters */
	r.in.hCluster = _hCluster;
	r.in.lpszResourceTypeName = _lpszResourceTypeName;
	r.in.dwControlCode = _dwControlCode;
	r.in.lpInBuffer = _lpInBuffer;
	r.in.nInBufferSize = _nInBufferSize;
	r.in.nOutBufferSize = _nOutBufferSize;

	/* Out parameters */
	r.out.lpOutBuffer = _lpOutBuffer;
	r.out.lpBytesReturned = _lpBytesReturned;
	r.out.lpcbRequired = _lpcbRequired;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_ResourceTypeControl_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_lpOutBuffer;
		if ((*r.out.lpBytesReturned) > (r.in.nOutBufferSize)) {
			return NT_STATUS_INVALID_NETWORK_RESPONSE;
		}
		_copy_len_lpOutBuffer = *r.out.lpBytesReturned;
		if (_lpOutBuffer != r.out.lpOutBuffer) {
			memcpy(_lpOutBuffer, r.out.lpOutBuffer, _copy_len_lpOutBuffer * sizeof(*_lpOutBuffer));
		}
	}
	*_lpBytesReturned = *r.out.lpBytesReturned;
	*_lpcbRequired = *r.out.lpcbRequired;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_NodeGroupControl_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_NodeGroupControl_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_NodeGroupControl_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_NodeGroupControl *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_NodeGroupControl_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_NodeGroupControl_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_NODEGROUPCONTROL, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_NodeGroupControl_r_done, req);

	return req;
}

static void dcerpc_clusapi_NodeGroupControl_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_NodeGroupControl_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_NodeGroupControl_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_NodeGroupControl_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_NodeGroupControl_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_NodeGroupControl *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_NODEGROUPCONTROL, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_NodeGroupControl_state {
	struct clusapi_NodeGroupControl orig;
	struct clusapi_NodeGroupControl tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_NodeGroupControl_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_NodeGroupControl_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle _hGroup /* [in]  */,
							struct policy_handle _hNode /* [in]  */,
							uint32_t _dwControlCode /* [in]  */,
							uint8_t *_lpInBuffer /* [in] [size_is(nInBufferSize),unique] */,
							uint32_t _nInBufferSize /* [in]  */,
							uint8_t *_lpOutBuffer /* [out] [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */,
							uint32_t _nOutBufferSize /* [in]  */,
							uint32_t *_lpBytesReturned /* [out] [ref] */,
							uint32_t *_lpcbRequired /* [out] [ref] */,
							WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_NodeGroupControl_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_NodeGroupControl_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hGroup = _hGroup;
	state->orig.in.hNode = _hNode;
	state->orig.in.dwControlCode = _dwControlCode;
	state->orig.in.lpInBuffer = _lpInBuffer;
	state->orig.in.nInBufferSize = _nInBufferSize;
	state->orig.in.nOutBufferSize = _nOutBufferSize;

	/* Out parameters */
	state->orig.out.lpOutBuffer = _lpOutBuffer;
	state->orig.out.lpBytesReturned = _lpBytesReturned;
	state->orig.out.lpcbRequired = _lpcbRequired;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_NodeGroupControl_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_NodeGroupControl_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_NodeGroupControl_done, req);
	return req;
}

static void dcerpc_clusapi_NodeGroupControl_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_NodeGroupControl_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_NodeGroupControl_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_NodeGroupControl_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_lpOutBuffer;
		if ((*state->tmp.out.lpBytesReturned) > (state->tmp.in.nOutBufferSize)) {
			tevent_req_nterror(req, NT_STATUS_INVALID_NETWORK_RESPONSE);
			return;
		}
		_copy_len_lpOutBuffer = *state->tmp.out.lpBytesReturned;
		if (state->orig.out.lpOutBuffer != state->tmp.out.lpOutBuffer) {
			memcpy(state->orig.out.lpOutBuffer, state->tmp.out.lpOutBuffer, _copy_len_lpOutBuffer * sizeof(*state->orig.out.lpOutBuffer));
		}
	}
	*state->orig.out.lpBytesReturned = *state->tmp.out.lpBytesReturned;
	*state->orig.out.lpcbRequired = *state->tmp.out.lpcbRequired;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_NodeGroupControl_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_clusapi_NodeGroupControl_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_NodeGroupControl_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_NodeGroupControl(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle _hGroup /* [in]  */,
					 struct policy_handle _hNode /* [in]  */,
					 uint32_t _dwControlCode /* [in]  */,
					 uint8_t *_lpInBuffer /* [in] [size_is(nInBufferSize),unique] */,
					 uint32_t _nInBufferSize /* [in]  */,
					 uint8_t *_lpOutBuffer /* [out] [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */,
					 uint32_t _nOutBufferSize /* [in]  */,
					 uint32_t *_lpBytesReturned /* [out] [ref] */,
					 uint32_t *_lpcbRequired /* [out] [ref] */,
					 WERROR *_rpc_status /* [out] [ref] */,
					 WERROR *result)
{
	struct clusapi_NodeGroupControl r;
	NTSTATUS status;

	/* In parameters */
	r.in.hGroup = _hGroup;
	r.in.hNode = _hNode;
	r.in.dwControlCode = _dwControlCode;
	r.in.lpInBuffer = _lpInBuffer;
	r.in.nInBufferSize = _nInBufferSize;
	r.in.nOutBufferSize = _nOutBufferSize;

	/* Out parameters */
	r.out.lpOutBuffer = _lpOutBuffer;
	r.out.lpBytesReturned = _lpBytesReturned;
	r.out.lpcbRequired = _lpcbRequired;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_NodeGroupControl_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_lpOutBuffer;
		if ((*r.out.lpBytesReturned) > (r.in.nOutBufferSize)) {
			return NT_STATUS_INVALID_NETWORK_RESPONSE;
		}
		_copy_len_lpOutBuffer = *r.out.lpBytesReturned;
		if (_lpOutBuffer != r.out.lpOutBuffer) {
			memcpy(_lpOutBuffer, r.out.lpOutBuffer, _copy_len_lpOutBuffer * sizeof(*_lpOutBuffer));
		}
	}
	*_lpBytesReturned = *r.out.lpBytesReturned;
	*_lpcbRequired = *r.out.lpcbRequired;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_GroupControl_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GroupControl_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GroupControl_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_GroupControl *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GroupControl_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GroupControl_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GROUPCONTROL, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GroupControl_r_done, req);

	return req;
}

static void dcerpc_clusapi_GroupControl_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GroupControl_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_GroupControl_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_GroupControl_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GroupControl_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_GroupControl *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GROUPCONTROL, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_GroupControl_state {
	struct clusapi_GroupControl orig;
	struct clusapi_GroupControl tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GroupControl_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GroupControl_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle _hGroup /* [in]  */,
						    enum clusapi_GroupControlCode _dwControlCode /* [in]  */,
						    uint8_t *_lpInBuffer /* [in] [size_is(nInBufferSize),unique] */,
						    uint32_t _nInBufferSize /* [in]  */,
						    uint8_t *_lpOutBuffer /* [out] [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */,
						    uint32_t _nOutBufferSize /* [in]  */,
						    uint32_t *_lpBytesReturned /* [out] [ref] */,
						    uint32_t *_lpcbRequired /* [out] [ref] */,
						    WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GroupControl_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GroupControl_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hGroup = _hGroup;
	state->orig.in.dwControlCode = _dwControlCode;
	state->orig.in.lpInBuffer = _lpInBuffer;
	state->orig.in.nInBufferSize = _nInBufferSize;
	state->orig.in.nOutBufferSize = _nOutBufferSize;

	/* Out parameters */
	state->orig.out.lpOutBuffer = _lpOutBuffer;
	state->orig.out.lpBytesReturned = _lpBytesReturned;
	state->orig.out.lpcbRequired = _lpcbRequired;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_GroupControl_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_GroupControl_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GroupControl_done, req);
	return req;
}

static void dcerpc_clusapi_GroupControl_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_GroupControl_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GroupControl_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_GroupControl_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_lpOutBuffer;
		if ((*state->tmp.out.lpBytesReturned) > (state->tmp.in.nOutBufferSize)) {
			tevent_req_nterror(req, NT_STATUS_INVALID_NETWORK_RESPONSE);
			return;
		}
		_copy_len_lpOutBuffer = *state->tmp.out.lpBytesReturned;
		if (state->orig.out.lpOutBuffer != state->tmp.out.lpOutBuffer) {
			memcpy(state->orig.out.lpOutBuffer, state->tmp.out.lpOutBuffer, _copy_len_lpOutBuffer * sizeof(*state->orig.out.lpOutBuffer));
		}
	}
	*state->orig.out.lpBytesReturned = *state->tmp.out.lpBytesReturned;
	*state->orig.out.lpcbRequired = *state->tmp.out.lpcbRequired;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GroupControl_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_clusapi_GroupControl_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GroupControl_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GroupControl(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle _hGroup /* [in]  */,
				     enum clusapi_GroupControlCode _dwControlCode /* [in]  */,
				     uint8_t *_lpInBuffer /* [in] [size_is(nInBufferSize),unique] */,
				     uint32_t _nInBufferSize /* [in]  */,
				     uint8_t *_lpOutBuffer /* [out] [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */,
				     uint32_t _nOutBufferSize /* [in]  */,
				     uint32_t *_lpBytesReturned /* [out] [ref] */,
				     uint32_t *_lpcbRequired /* [out] [ref] */,
				     WERROR *_rpc_status /* [out] [ref] */,
				     WERROR *result)
{
	struct clusapi_GroupControl r;
	NTSTATUS status;

	/* In parameters */
	r.in.hGroup = _hGroup;
	r.in.dwControlCode = _dwControlCode;
	r.in.lpInBuffer = _lpInBuffer;
	r.in.nInBufferSize = _nInBufferSize;
	r.in.nOutBufferSize = _nOutBufferSize;

	/* Out parameters */
	r.out.lpOutBuffer = _lpOutBuffer;
	r.out.lpBytesReturned = _lpBytesReturned;
	r.out.lpcbRequired = _lpcbRequired;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_GroupControl_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_lpOutBuffer;
		if ((*r.out.lpBytesReturned) > (r.in.nOutBufferSize)) {
			return NT_STATUS_INVALID_NETWORK_RESPONSE;
		}
		_copy_len_lpOutBuffer = *r.out.lpBytesReturned;
		if (_lpOutBuffer != r.out.lpOutBuffer) {
			memcpy(_lpOutBuffer, r.out.lpOutBuffer, _copy_len_lpOutBuffer * sizeof(*_lpOutBuffer));
		}
	}
	*_lpBytesReturned = *r.out.lpBytesReturned;
	*_lpcbRequired = *r.out.lpcbRequired;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_NodeNodeControl_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_NodeNodeControl_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_NodeNodeControl_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_NodeNodeControl *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_NodeNodeControl_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_NodeNodeControl_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_NODENODECONTROL, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_NodeNodeControl_r_done, req);

	return req;
}

static void dcerpc_clusapi_NodeNodeControl_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_NodeNodeControl_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_NodeNodeControl_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_NodeNodeControl_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_NodeNodeControl_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_NodeNodeControl *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_NODENODECONTROL, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_NodeNodeControl_state {
	struct clusapi_NodeNodeControl orig;
	struct clusapi_NodeNodeControl tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_NodeNodeControl_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_NodeNodeControl_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       struct policy_handle _hNode /* [in]  */,
						       struct policy_handle _hHostNode /* [in]  */,
						       uint32_t _dwControlCode /* [in]  */,
						       uint8_t *_lpInBuffer /* [in] [size_is(nInBufferSize),unique] */,
						       uint32_t _nInBufferSize /* [in]  */,
						       uint8_t *_lpOutBuffer /* [out] [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */,
						       uint32_t _nOutBufferSize /* [in]  */,
						       uint32_t *_lpBytesReturned /* [out] [ref] */,
						       uint32_t *_lpcbRequired /* [out] [ref] */,
						       WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_NodeNodeControl_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_NodeNodeControl_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNode = _hNode;
	state->orig.in.hHostNode = _hHostNode;
	state->orig.in.dwControlCode = _dwControlCode;
	state->orig.in.lpInBuffer = _lpInBuffer;
	state->orig.in.nInBufferSize = _nInBufferSize;
	state->orig.in.nOutBufferSize = _nOutBufferSize;

	/* Out parameters */
	state->orig.out.lpOutBuffer = _lpOutBuffer;
	state->orig.out.lpBytesReturned = _lpBytesReturned;
	state->orig.out.lpcbRequired = _lpcbRequired;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_NodeNodeControl_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_NodeNodeControl_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_NodeNodeControl_done, req);
	return req;
}

static void dcerpc_clusapi_NodeNodeControl_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_NodeNodeControl_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_NodeNodeControl_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_NodeNodeControl_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_lpOutBuffer;
		if ((*state->tmp.out.lpBytesReturned) > (state->tmp.in.nOutBufferSize)) {
			tevent_req_nterror(req, NT_STATUS_INVALID_NETWORK_RESPONSE);
			return;
		}
		_copy_len_lpOutBuffer = *state->tmp.out.lpBytesReturned;
		if (state->orig.out.lpOutBuffer != state->tmp.out.lpOutBuffer) {
			memcpy(state->orig.out.lpOutBuffer, state->tmp.out.lpOutBuffer, _copy_len_lpOutBuffer * sizeof(*state->orig.out.lpOutBuffer));
		}
	}
	*state->orig.out.lpBytesReturned = *state->tmp.out.lpBytesReturned;
	*state->orig.out.lpcbRequired = *state->tmp.out.lpcbRequired;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_NodeNodeControl_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct dcerpc_clusapi_NodeNodeControl_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_NodeNodeControl_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_NodeNodeControl(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					struct policy_handle _hNode /* [in]  */,
					struct policy_handle _hHostNode /* [in]  */,
					uint32_t _dwControlCode /* [in]  */,
					uint8_t *_lpInBuffer /* [in] [size_is(nInBufferSize),unique] */,
					uint32_t _nInBufferSize /* [in]  */,
					uint8_t *_lpOutBuffer /* [out] [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */,
					uint32_t _nOutBufferSize /* [in]  */,
					uint32_t *_lpBytesReturned /* [out] [ref] */,
					uint32_t *_lpcbRequired /* [out] [ref] */,
					WERROR *_rpc_status /* [out] [ref] */,
					WERROR *result)
{
	struct clusapi_NodeNodeControl r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNode = _hNode;
	r.in.hHostNode = _hHostNode;
	r.in.dwControlCode = _dwControlCode;
	r.in.lpInBuffer = _lpInBuffer;
	r.in.nInBufferSize = _nInBufferSize;
	r.in.nOutBufferSize = _nOutBufferSize;

	/* Out parameters */
	r.out.lpOutBuffer = _lpOutBuffer;
	r.out.lpBytesReturned = _lpBytesReturned;
	r.out.lpcbRequired = _lpcbRequired;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_NodeNodeControl_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_lpOutBuffer;
		if ((*r.out.lpBytesReturned) > (r.in.nOutBufferSize)) {
			return NT_STATUS_INVALID_NETWORK_RESPONSE;
		}
		_copy_len_lpOutBuffer = *r.out.lpBytesReturned;
		if (_lpOutBuffer != r.out.lpOutBuffer) {
			memcpy(_lpOutBuffer, r.out.lpOutBuffer, _copy_len_lpOutBuffer * sizeof(*_lpOutBuffer));
		}
	}
	*_lpBytesReturned = *r.out.lpBytesReturned;
	*_lpcbRequired = *r.out.lpcbRequired;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_NodeControl_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_NodeControl_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_NodeControl_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_NodeControl *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_NodeControl_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_NodeControl_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_NODECONTROL, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_NodeControl_r_done, req);

	return req;
}

static void dcerpc_clusapi_NodeControl_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_NodeControl_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_NodeControl_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_NodeControl_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_NodeControl_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_NodeControl *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_NODECONTROL, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_NodeControl_state {
	struct clusapi_NodeControl orig;
	struct clusapi_NodeControl tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_NodeControl_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_NodeControl_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   struct policy_handle _hNode /* [in]  */,
						   enum clusapi_NodeControlCode _dwControlCode /* [in]  */,
						   uint8_t *_lpInBuffer /* [in] [size_is(nInBufferSize),unique] */,
						   uint32_t _nInBufferSize /* [in]  */,
						   uint8_t *_lpOutBuffer /* [out] [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */,
						   uint32_t _nOutBufferSize /* [in]  */,
						   uint32_t *_lpBytesReturned /* [out] [ref] */,
						   uint32_t *_lpcbRequired /* [out] [ref] */,
						   WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_NodeControl_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_NodeControl_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNode = _hNode;
	state->orig.in.dwControlCode = _dwControlCode;
	state->orig.in.lpInBuffer = _lpInBuffer;
	state->orig.in.nInBufferSize = _nInBufferSize;
	state->orig.in.nOutBufferSize = _nOutBufferSize;

	/* Out parameters */
	state->orig.out.lpOutBuffer = _lpOutBuffer;
	state->orig.out.lpBytesReturned = _lpBytesReturned;
	state->orig.out.lpcbRequired = _lpcbRequired;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_NodeControl_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_NodeControl_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_NodeControl_done, req);
	return req;
}

static void dcerpc_clusapi_NodeControl_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_NodeControl_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_NodeControl_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_NodeControl_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_lpOutBuffer;
		if ((*state->tmp.out.lpBytesReturned) > (state->tmp.in.nOutBufferSize)) {
			tevent_req_nterror(req, NT_STATUS_INVALID_NETWORK_RESPONSE);
			return;
		}
		_copy_len_lpOutBuffer = *state->tmp.out.lpBytesReturned;
		if (state->orig.out.lpOutBuffer != state->tmp.out.lpOutBuffer) {
			memcpy(state->orig.out.lpOutBuffer, state->tmp.out.lpOutBuffer, _copy_len_lpOutBuffer * sizeof(*state->orig.out.lpOutBuffer));
		}
	}
	*state->orig.out.lpBytesReturned = *state->tmp.out.lpBytesReturned;
	*state->orig.out.lpcbRequired = *state->tmp.out.lpcbRequired;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_NodeControl_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result)
{
	struct dcerpc_clusapi_NodeControl_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_NodeControl_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_NodeControl(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle _hNode /* [in]  */,
				    enum clusapi_NodeControlCode _dwControlCode /* [in]  */,
				    uint8_t *_lpInBuffer /* [in] [size_is(nInBufferSize),unique] */,
				    uint32_t _nInBufferSize /* [in]  */,
				    uint8_t *_lpOutBuffer /* [out] [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */,
				    uint32_t _nOutBufferSize /* [in]  */,
				    uint32_t *_lpBytesReturned /* [out] [ref] */,
				    uint32_t *_lpcbRequired /* [out] [ref] */,
				    WERROR *_rpc_status /* [out] [ref] */,
				    WERROR *result)
{
	struct clusapi_NodeControl r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNode = _hNode;
	r.in.dwControlCode = _dwControlCode;
	r.in.lpInBuffer = _lpInBuffer;
	r.in.nInBufferSize = _nInBufferSize;
	r.in.nOutBufferSize = _nOutBufferSize;

	/* Out parameters */
	r.out.lpOutBuffer = _lpOutBuffer;
	r.out.lpBytesReturned = _lpBytesReturned;
	r.out.lpcbRequired = _lpcbRequired;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_NodeControl_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_lpOutBuffer;
		if ((*r.out.lpBytesReturned) > (r.in.nOutBufferSize)) {
			return NT_STATUS_INVALID_NETWORK_RESPONSE;
		}
		_copy_len_lpOutBuffer = *r.out.lpBytesReturned;
		if (_lpOutBuffer != r.out.lpOutBuffer) {
			memcpy(_lpOutBuffer, r.out.lpOutBuffer, _copy_len_lpOutBuffer * sizeof(*_lpOutBuffer));
		}
	}
	*_lpBytesReturned = *r.out.lpBytesReturned;
	*_lpcbRequired = *r.out.lpcbRequired;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_Opnum80NotUsedOnWire_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum80NotUsedOnWire_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum80NotUsedOnWire_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct Opnum80NotUsedOnWire *r)
{
	struct tevent_req *req;
	struct dcerpc_Opnum80NotUsedOnWire_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum80NotUsedOnWire_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_OPNUM80NOTUSEDONWIRE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum80NotUsedOnWire_r_done, req);

	return req;
}

static void dcerpc_Opnum80NotUsedOnWire_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum80NotUsedOnWire_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Opnum80NotUsedOnWire_r_state *state =
		tevent_req_data(req,
		struct dcerpc_Opnum80NotUsedOnWire_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum80NotUsedOnWire_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct Opnum80NotUsedOnWire *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_OPNUM80NOTUSEDONWIRE, mem_ctx, r);

	return status;
}

struct dcerpc_Opnum80NotUsedOnWire_state {
	struct Opnum80NotUsedOnWire orig;
	struct Opnum80NotUsedOnWire tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum80NotUsedOnWire_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum80NotUsedOnWire_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h)
{
	struct tevent_req *req;
	struct dcerpc_Opnum80NotUsedOnWire_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum80NotUsedOnWire_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_Opnum80NotUsedOnWire_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum80NotUsedOnWire_done, req);
	return req;
}

static void dcerpc_Opnum80NotUsedOnWire_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_Opnum80NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum80NotUsedOnWire_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_Opnum80NotUsedOnWire_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum80NotUsedOnWire_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_Opnum80NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum80NotUsedOnWire_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum80NotUsedOnWire(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct Opnum80NotUsedOnWire r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_Opnum80NotUsedOnWire_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_OpenNetwork_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OpenNetwork_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OpenNetwork_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_OpenNetwork *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OpenNetwork_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OpenNetwork_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OPENNETWORK, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OpenNetwork_r_done, req);

	return req;
}

static void dcerpc_clusapi_OpenNetwork_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OpenNetwork_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OpenNetwork_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_OpenNetwork_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OpenNetwork_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_OpenNetwork *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OPENNETWORK, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_OpenNetwork_state {
	struct clusapi_OpenNetwork orig;
	struct clusapi_OpenNetwork tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OpenNetwork_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OpenNetwork_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   const char *_lpszNetworkName /* [in] [charset(UTF16),ref] */,
						   WERROR *_Status /* [out] [ref] */,
						   WERROR *_rpc_status /* [out] [ref] */,
						   struct policy_handle *_hNetwork /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OpenNetwork_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OpenNetwork_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.lpszNetworkName = _lpszNetworkName;

	/* Out parameters */
	state->orig.out.Status = _Status;
	state->orig.out.rpc_status = _rpc_status;
	state->orig.out.hNetwork = _hNetwork;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_OpenNetwork_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_OpenNetwork_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OpenNetwork_done, req);
	return req;
}

static void dcerpc_clusapi_OpenNetwork_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_OpenNetwork_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OpenNetwork_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_OpenNetwork_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.Status = *state->tmp.out.Status;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;
	*state->orig.out.hNetwork = *state->tmp.out.hNetwork;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OpenNetwork_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OpenNetwork_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OpenNetwork_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OpenNetwork(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    const char *_lpszNetworkName /* [in] [charset(UTF16),ref] */,
				    WERROR *_Status /* [out] [ref] */,
				    WERROR *_rpc_status /* [out] [ref] */,
				    struct policy_handle *_hNetwork /* [out] [ref] */)
{
	struct clusapi_OpenNetwork r;
	NTSTATUS status;

	/* In parameters */
	r.in.lpszNetworkName = _lpszNetworkName;

	/* Out parameters */
	r.out.Status = _Status;
	r.out.rpc_status = _rpc_status;
	r.out.hNetwork = _hNetwork;

	status = dcerpc_clusapi_OpenNetwork_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_Status = *r.out.Status;
	*_rpc_status = *r.out.rpc_status;
	*_hNetwork = *r.out.hNetwork;

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_CloseNetwork_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CloseNetwork_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CloseNetwork_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_CloseNetwork *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CloseNetwork_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CloseNetwork_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CLOSENETWORK, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CloseNetwork_r_done, req);

	return req;
}

static void dcerpc_clusapi_CloseNetwork_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CloseNetwork_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CloseNetwork_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_CloseNetwork_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CloseNetwork_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_CloseNetwork *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CLOSENETWORK, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_CloseNetwork_state {
	struct clusapi_CloseNetwork orig;
	struct clusapi_CloseNetwork tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CloseNetwork_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CloseNetwork_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle *_Network /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CloseNetwork_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CloseNetwork_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.Network = _Network;

	/* Out parameters */
	state->orig.out.Network = _Network;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_CloseNetwork_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_CloseNetwork_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CloseNetwork_done, req);
	return req;
}

static void dcerpc_clusapi_CloseNetwork_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_CloseNetwork_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CloseNetwork_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_CloseNetwork_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.Network = *state->tmp.out.Network;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CloseNetwork_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_clusapi_CloseNetwork_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CloseNetwork_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CloseNetwork(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *_Network /* [in,out] [ref] */,
				     WERROR *result)
{
	struct clusapi_CloseNetwork r;
	NTSTATUS status;

	/* In parameters */
	r.in.Network = _Network;

	/* Out parameters */
	r.out.Network = _Network;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_CloseNetwork_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_Network = *r.out.Network;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_GetNetworkState_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetNetworkState_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetNetworkState_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_GetNetworkState *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetNetworkState_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetNetworkState_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETNETWORKSTATE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetNetworkState_r_done, req);

	return req;
}

static void dcerpc_clusapi_GetNetworkState_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetNetworkState_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_GetNetworkState_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_GetNetworkState_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetNetworkState_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_GetNetworkState *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETNETWORKSTATE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_GetNetworkState_state {
	struct clusapi_GetNetworkState orig;
	struct clusapi_GetNetworkState tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetNetworkState_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetNetworkState_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       struct policy_handle _hNetwork /* [in]  */,
						       enum clusapi_ClusterNetworkState *_State /* [out] [ref] */,
						       WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetNetworkState_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetNetworkState_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNetwork = _hNetwork;

	/* Out parameters */
	state->orig.out.State = _State;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_GetNetworkState_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_GetNetworkState_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetNetworkState_done, req);
	return req;
}

static void dcerpc_clusapi_GetNetworkState_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_GetNetworkState_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetNetworkState_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_GetNetworkState_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.State = *state->tmp.out.State;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetNetworkState_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct dcerpc_clusapi_GetNetworkState_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetNetworkState_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetNetworkState(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					struct policy_handle _hNetwork /* [in]  */,
					enum clusapi_ClusterNetworkState *_State /* [out] [ref] */,
					WERROR *_rpc_status /* [out] [ref] */,
					WERROR *result)
{
	struct clusapi_GetNetworkState r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNetwork = _hNetwork;

	/* Out parameters */
	r.out.State = _State;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_GetNetworkState_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_State = *r.out.State;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_SetNetworkName_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_SetNetworkName_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_SetNetworkName_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_SetNetworkName *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_SetNetworkName_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_SetNetworkName_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_SETNETWORKNAME, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_SetNetworkName_r_done, req);

	return req;
}

static void dcerpc_clusapi_SetNetworkName_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_SetNetworkName_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_SetNetworkName_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_SetNetworkName_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_SetNetworkName_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_SetNetworkName *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_SETNETWORKNAME, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_SetNetworkName_state {
	struct clusapi_SetNetworkName orig;
	struct clusapi_SetNetworkName tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_SetNetworkName_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_SetNetworkName_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle _hNetwork /* [in]  */,
						      const char *_lpszNetworkName /* [in] [charset(UTF16),ref] */,
						      WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_SetNetworkName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_SetNetworkName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNetwork = _hNetwork;
	state->orig.in.lpszNetworkName = _lpszNetworkName;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_SetNetworkName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_SetNetworkName_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_SetNetworkName_done, req);
	return req;
}

static void dcerpc_clusapi_SetNetworkName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_SetNetworkName_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_SetNetworkName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_SetNetworkName_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_SetNetworkName_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_clusapi_SetNetworkName_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_SetNetworkName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_SetNetworkName(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle _hNetwork /* [in]  */,
				       const char *_lpszNetworkName /* [in] [charset(UTF16),ref] */,
				       WERROR *_rpc_status /* [out] [ref] */,
				       WERROR *result)
{
	struct clusapi_SetNetworkName r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNetwork = _hNetwork;
	r.in.lpszNetworkName = _lpszNetworkName;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_SetNetworkName_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_CreateNetworkEnum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateNetworkEnum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateNetworkEnum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_CreateNetworkEnum *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateNetworkEnum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateNetworkEnum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATENETWORKENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateNetworkEnum_r_done, req);

	return req;
}

static void dcerpc_clusapi_CreateNetworkEnum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateNetworkEnum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CreateNetworkEnum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_CreateNetworkEnum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateNetworkEnum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_CreateNetworkEnum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATENETWORKENUM, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_CreateNetworkEnum_state {
	struct clusapi_CreateNetworkEnum orig;
	struct clusapi_CreateNetworkEnum tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateNetworkEnum_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateNetworkEnum_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct policy_handle _hNetwork /* [in]  */,
							 uint32_t _dwType /* [in]  */,
							 struct ENUM_LIST **_ReturnEnum /* [out] [ref] */,
							 WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateNetworkEnum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateNetworkEnum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNetwork = _hNetwork;
	state->orig.in.dwType = _dwType;

	/* Out parameters */
	state->orig.out.ReturnEnum = _ReturnEnum;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_CreateNetworkEnum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_CreateNetworkEnum_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateNetworkEnum_done, req);
	return req;
}

static void dcerpc_clusapi_CreateNetworkEnum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_CreateNetworkEnum_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateNetworkEnum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_CreateNetworkEnum_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ReturnEnum = *state->tmp.out.ReturnEnum;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateNetworkEnum_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_clusapi_CreateNetworkEnum_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateNetworkEnum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateNetworkEnum(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle _hNetwork /* [in]  */,
					  uint32_t _dwType /* [in]  */,
					  struct ENUM_LIST **_ReturnEnum /* [out] [ref] */,
					  WERROR *_rpc_status /* [out] [ref] */,
					  WERROR *result)
{
	struct clusapi_CreateNetworkEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNetwork = _hNetwork;
	r.in.dwType = _dwType;

	/* Out parameters */
	r.out.ReturnEnum = _ReturnEnum;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_CreateNetworkEnum_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ReturnEnum = *r.out.ReturnEnum;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_GetNetworkId_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetNetworkId_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetNetworkId_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_GetNetworkId *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetNetworkId_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetNetworkId_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETNETWORKID, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetNetworkId_r_done, req);

	return req;
}

static void dcerpc_clusapi_GetNetworkId_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetNetworkId_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_GetNetworkId_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_GetNetworkId_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetNetworkId_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_GetNetworkId *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETNETWORKID, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_GetNetworkId_state {
	struct clusapi_GetNetworkId orig;
	struct clusapi_GetNetworkId tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetNetworkId_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetNetworkId_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle _hNetwork /* [in]  */,
						    const char **_pGuid /* [out] [charset(UTF16),ref] */,
						    WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetNetworkId_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetNetworkId_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNetwork = _hNetwork;

	/* Out parameters */
	state->orig.out.pGuid = _pGuid;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_GetNetworkId_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_GetNetworkId_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetNetworkId_done, req);
	return req;
}

static void dcerpc_clusapi_GetNetworkId_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_GetNetworkId_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetNetworkId_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_GetNetworkId_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pGuid = *state->tmp.out.pGuid;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetNetworkId_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_clusapi_GetNetworkId_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetNetworkId_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetNetworkId(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle _hNetwork /* [in]  */,
				     const char **_pGuid /* [out] [charset(UTF16),ref] */,
				     WERROR *_rpc_status /* [out] [ref] */,
				     WERROR *result)
{
	struct clusapi_GetNetworkId r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNetwork = _hNetwork;

	/* Out parameters */
	r.out.pGuid = _pGuid;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_GetNetworkId_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pGuid = *r.out.pGuid;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_SetNetworkPriorityOrder_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_SetNetworkPriorityOrder_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_SetNetworkPriorityOrder_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_SetNetworkPriorityOrder *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_SetNetworkPriorityOrder_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_SetNetworkPriorityOrder_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_SETNETWORKPRIORITYORDER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_SetNetworkPriorityOrder_r_done, req);

	return req;
}

static void dcerpc_clusapi_SetNetworkPriorityOrder_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_SetNetworkPriorityOrder_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_SetNetworkPriorityOrder_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_SetNetworkPriorityOrder_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_SetNetworkPriorityOrder_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_SetNetworkPriorityOrder *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_SETNETWORKPRIORITYORDER, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_SetNetworkPriorityOrder_state {
	struct clusapi_SetNetworkPriorityOrder orig;
	struct clusapi_SetNetworkPriorityOrder tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_SetNetworkPriorityOrder_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_SetNetworkPriorityOrder_send(TALLOC_CTX *mem_ctx,
							       struct tevent_context *ev,
							       struct dcerpc_binding_handle *h,
							       uint32_t _NetworkCount /* [in] [range(0,1000)] */,
							       const char *_NetworkIdList /* [in] [charset(UTF16),size_is(NetworkCount)] */,
							       WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_SetNetworkPriorityOrder_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_SetNetworkPriorityOrder_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.NetworkCount = _NetworkCount;
	state->orig.in.NetworkIdList = _NetworkIdList;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_SetNetworkPriorityOrder_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_SetNetworkPriorityOrder_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_SetNetworkPriorityOrder_done, req);
	return req;
}

static void dcerpc_clusapi_SetNetworkPriorityOrder_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_SetNetworkPriorityOrder_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_SetNetworkPriorityOrder_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_SetNetworkPriorityOrder_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_SetNetworkPriorityOrder_recv(struct tevent_req *req,
						     TALLOC_CTX *mem_ctx,
						     WERROR *result)
{
	struct dcerpc_clusapi_SetNetworkPriorityOrder_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_SetNetworkPriorityOrder_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_SetNetworkPriorityOrder(struct dcerpc_binding_handle *h,
						TALLOC_CTX *mem_ctx,
						uint32_t _NetworkCount /* [in] [range(0,1000)] */,
						const char *_NetworkIdList /* [in] [charset(UTF16),size_is(NetworkCount)] */,
						WERROR *_rpc_status /* [out] [ref] */,
						WERROR *result)
{
	struct clusapi_SetNetworkPriorityOrder r;
	NTSTATUS status;

	/* In parameters */
	r.in.NetworkCount = _NetworkCount;
	r.in.NetworkIdList = _NetworkIdList;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_SetNetworkPriorityOrder_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_NodeNetworkControl_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_NodeNetworkControl_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_NodeNetworkControl_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_NodeNetworkControl *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_NodeNetworkControl_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_NodeNetworkControl_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_NODENETWORKCONTROL, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_NodeNetworkControl_r_done, req);

	return req;
}

static void dcerpc_clusapi_NodeNetworkControl_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_NodeNetworkControl_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_NodeNetworkControl_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_NodeNetworkControl_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_NodeNetworkControl_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_NodeNetworkControl *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_NODENETWORKCONTROL, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_NodeNetworkControl_state {
	struct clusapi_NodeNetworkControl orig;
	struct clusapi_NodeNetworkControl tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_NodeNetworkControl_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_NodeNetworkControl_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle _hNetwork /* [in]  */,
							  struct policy_handle _hNode /* [in]  */,
							  uint32_t _dwControlCode /* [in]  */,
							  uint8_t *_lpInBuffer /* [in] [size_is(nInBufferSize),unique] */,
							  uint32_t _nInBufferSize /* [in]  */,
							  uint8_t *_lpOutBuffer /* [out] [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */,
							  uint32_t _nOutBufferSize /* [in]  */,
							  uint32_t *_lpBytesReturned /* [out] [ref] */,
							  uint32_t *_lpcbRequired /* [out] [ref] */,
							  WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_NodeNetworkControl_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_NodeNetworkControl_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNetwork = _hNetwork;
	state->orig.in.hNode = _hNode;
	state->orig.in.dwControlCode = _dwControlCode;
	state->orig.in.lpInBuffer = _lpInBuffer;
	state->orig.in.nInBufferSize = _nInBufferSize;
	state->orig.in.nOutBufferSize = _nOutBufferSize;

	/* Out parameters */
	state->orig.out.lpOutBuffer = _lpOutBuffer;
	state->orig.out.lpBytesReturned = _lpBytesReturned;
	state->orig.out.lpcbRequired = _lpcbRequired;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_NodeNetworkControl_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_NodeNetworkControl_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_NodeNetworkControl_done, req);
	return req;
}

static void dcerpc_clusapi_NodeNetworkControl_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_NodeNetworkControl_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_NodeNetworkControl_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_NodeNetworkControl_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_lpOutBuffer;
		if ((*state->tmp.out.lpBytesReturned) > (state->tmp.in.nOutBufferSize)) {
			tevent_req_nterror(req, NT_STATUS_INVALID_NETWORK_RESPONSE);
			return;
		}
		_copy_len_lpOutBuffer = *state->tmp.out.lpBytesReturned;
		if (state->orig.out.lpOutBuffer != state->tmp.out.lpOutBuffer) {
			memcpy(state->orig.out.lpOutBuffer, state->tmp.out.lpOutBuffer, _copy_len_lpOutBuffer * sizeof(*state->orig.out.lpOutBuffer));
		}
	}
	*state->orig.out.lpBytesReturned = *state->tmp.out.lpBytesReturned;
	*state->orig.out.lpcbRequired = *state->tmp.out.lpcbRequired;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_NodeNetworkControl_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_clusapi_NodeNetworkControl_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_NodeNetworkControl_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_NodeNetworkControl(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle _hNetwork /* [in]  */,
					   struct policy_handle _hNode /* [in]  */,
					   uint32_t _dwControlCode /* [in]  */,
					   uint8_t *_lpInBuffer /* [in] [size_is(nInBufferSize),unique] */,
					   uint32_t _nInBufferSize /* [in]  */,
					   uint8_t *_lpOutBuffer /* [out] [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */,
					   uint32_t _nOutBufferSize /* [in]  */,
					   uint32_t *_lpBytesReturned /* [out] [ref] */,
					   uint32_t *_lpcbRequired /* [out] [ref] */,
					   WERROR *_rpc_status /* [out] [ref] */,
					   WERROR *result)
{
	struct clusapi_NodeNetworkControl r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNetwork = _hNetwork;
	r.in.hNode = _hNode;
	r.in.dwControlCode = _dwControlCode;
	r.in.lpInBuffer = _lpInBuffer;
	r.in.nInBufferSize = _nInBufferSize;
	r.in.nOutBufferSize = _nOutBufferSize;

	/* Out parameters */
	r.out.lpOutBuffer = _lpOutBuffer;
	r.out.lpBytesReturned = _lpBytesReturned;
	r.out.lpcbRequired = _lpcbRequired;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_NodeNetworkControl_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_lpOutBuffer;
		if ((*r.out.lpBytesReturned) > (r.in.nOutBufferSize)) {
			return NT_STATUS_INVALID_NETWORK_RESPONSE;
		}
		_copy_len_lpOutBuffer = *r.out.lpBytesReturned;
		if (_lpOutBuffer != r.out.lpOutBuffer) {
			memcpy(_lpOutBuffer, r.out.lpOutBuffer, _copy_len_lpOutBuffer * sizeof(*_lpOutBuffer));
		}
	}
	*_lpBytesReturned = *r.out.lpBytesReturned;
	*_lpcbRequired = *r.out.lpcbRequired;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_NetworkControl_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_NetworkControl_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_NetworkControl_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_NetworkControl *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_NetworkControl_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_NetworkControl_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_NETWORKCONTROL, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_NetworkControl_r_done, req);

	return req;
}

static void dcerpc_clusapi_NetworkControl_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_NetworkControl_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_NetworkControl_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_NetworkControl_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_NetworkControl_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_NetworkControl *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_NETWORKCONTROL, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_NetworkControl_state {
	struct clusapi_NetworkControl orig;
	struct clusapi_NetworkControl tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_NetworkControl_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_NetworkControl_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle _hNetwork /* [in]  */,
						      uint32_t _dwControlCode /* [in]  */,
						      uint8_t *_lpInBuffer /* [in] [size_is(nInBufferSize),unique] */,
						      uint32_t _nInBufferSize /* [in]  */,
						      uint8_t *_lpOutBuffer /* [out] [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */,
						      uint32_t _nOutBufferSize /* [in]  */,
						      uint32_t *_lpBytesReturned /* [out] [ref] */,
						      uint32_t *_lpcbRequired /* [out] [ref] */,
						      WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_NetworkControl_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_NetworkControl_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNetwork = _hNetwork;
	state->orig.in.dwControlCode = _dwControlCode;
	state->orig.in.lpInBuffer = _lpInBuffer;
	state->orig.in.nInBufferSize = _nInBufferSize;
	state->orig.in.nOutBufferSize = _nOutBufferSize;

	/* Out parameters */
	state->orig.out.lpOutBuffer = _lpOutBuffer;
	state->orig.out.lpBytesReturned = _lpBytesReturned;
	state->orig.out.lpcbRequired = _lpcbRequired;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_NetworkControl_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_NetworkControl_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_NetworkControl_done, req);
	return req;
}

static void dcerpc_clusapi_NetworkControl_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_NetworkControl_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_NetworkControl_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_NetworkControl_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_lpOutBuffer;
		if ((*state->tmp.out.lpBytesReturned) > (state->tmp.in.nOutBufferSize)) {
			tevent_req_nterror(req, NT_STATUS_INVALID_NETWORK_RESPONSE);
			return;
		}
		_copy_len_lpOutBuffer = *state->tmp.out.lpBytesReturned;
		if (state->orig.out.lpOutBuffer != state->tmp.out.lpOutBuffer) {
			memcpy(state->orig.out.lpOutBuffer, state->tmp.out.lpOutBuffer, _copy_len_lpOutBuffer * sizeof(*state->orig.out.lpOutBuffer));
		}
	}
	*state->orig.out.lpBytesReturned = *state->tmp.out.lpBytesReturned;
	*state->orig.out.lpcbRequired = *state->tmp.out.lpcbRequired;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_NetworkControl_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_clusapi_NetworkControl_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_NetworkControl_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_NetworkControl(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle _hNetwork /* [in]  */,
				       uint32_t _dwControlCode /* [in]  */,
				       uint8_t *_lpInBuffer /* [in] [size_is(nInBufferSize),unique] */,
				       uint32_t _nInBufferSize /* [in]  */,
				       uint8_t *_lpOutBuffer /* [out] [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */,
				       uint32_t _nOutBufferSize /* [in]  */,
				       uint32_t *_lpBytesReturned /* [out] [ref] */,
				       uint32_t *_lpcbRequired /* [out] [ref] */,
				       WERROR *_rpc_status /* [out] [ref] */,
				       WERROR *result)
{
	struct clusapi_NetworkControl r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNetwork = _hNetwork;
	r.in.dwControlCode = _dwControlCode;
	r.in.lpInBuffer = _lpInBuffer;
	r.in.nInBufferSize = _nInBufferSize;
	r.in.nOutBufferSize = _nOutBufferSize;

	/* Out parameters */
	r.out.lpOutBuffer = _lpOutBuffer;
	r.out.lpBytesReturned = _lpBytesReturned;
	r.out.lpcbRequired = _lpcbRequired;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_NetworkControl_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_lpOutBuffer;
		if ((*r.out.lpBytesReturned) > (r.in.nOutBufferSize)) {
			return NT_STATUS_INVALID_NETWORK_RESPONSE;
		}
		_copy_len_lpOutBuffer = *r.out.lpBytesReturned;
		if (_lpOutBuffer != r.out.lpOutBuffer) {
			memcpy(_lpOutBuffer, r.out.lpOutBuffer, _copy_len_lpOutBuffer * sizeof(*_lpOutBuffer));
		}
	}
	*_lpBytesReturned = *r.out.lpBytesReturned;
	*_lpcbRequired = *r.out.lpcbRequired;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_AddNotifyNetwork_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_AddNotifyNetwork_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_AddNotifyNetwork_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_AddNotifyNetwork *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_AddNotifyNetwork_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_AddNotifyNetwork_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ADDNOTIFYNETWORK, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_AddNotifyNetwork_r_done, req);

	return req;
}

static void dcerpc_clusapi_AddNotifyNetwork_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_AddNotifyNetwork_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_AddNotifyNetwork_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_AddNotifyNetwork_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_AddNotifyNetwork_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_AddNotifyNetwork *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ADDNOTIFYNETWORK, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_AddNotifyNetwork_state {
	struct clusapi_AddNotifyNetwork orig;
	struct clusapi_AddNotifyNetwork tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_AddNotifyNetwork_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_AddNotifyNetwork_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle _hNotify /* [in]  */,
							struct policy_handle _hNetwork /* [in]  */,
							uint32_t _dwFilter /* [in]  */,
							uint32_t _dwNotifyKey /* [in]  */,
							uint32_t *_dwStateSequence /* [out] [ref] */,
							WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_AddNotifyNetwork_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_AddNotifyNetwork_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNotify = _hNotify;
	state->orig.in.hNetwork = _hNetwork;
	state->orig.in.dwFilter = _dwFilter;
	state->orig.in.dwNotifyKey = _dwNotifyKey;

	/* Out parameters */
	state->orig.out.dwStateSequence = _dwStateSequence;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_AddNotifyNetwork_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_AddNotifyNetwork_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_AddNotifyNetwork_done, req);
	return req;
}

static void dcerpc_clusapi_AddNotifyNetwork_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_AddNotifyNetwork_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_AddNotifyNetwork_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_AddNotifyNetwork_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.dwStateSequence = *state->tmp.out.dwStateSequence;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_AddNotifyNetwork_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_clusapi_AddNotifyNetwork_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_AddNotifyNetwork_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_AddNotifyNetwork(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle _hNotify /* [in]  */,
					 struct policy_handle _hNetwork /* [in]  */,
					 uint32_t _dwFilter /* [in]  */,
					 uint32_t _dwNotifyKey /* [in]  */,
					 uint32_t *_dwStateSequence /* [out] [ref] */,
					 WERROR *_rpc_status /* [out] [ref] */,
					 WERROR *result)
{
	struct clusapi_AddNotifyNetwork r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNotify = _hNotify;
	r.in.hNetwork = _hNetwork;
	r.in.dwFilter = _dwFilter;
	r.in.dwNotifyKey = _dwNotifyKey;

	/* Out parameters */
	r.out.dwStateSequence = _dwStateSequence;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_AddNotifyNetwork_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_dwStateSequence = *r.out.dwStateSequence;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_ReAddNotifyNetwork_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_ReAddNotifyNetwork_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_ReAddNotifyNetwork_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_ReAddNotifyNetwork *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_ReAddNotifyNetwork_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_ReAddNotifyNetwork_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_READDNOTIFYNETWORK, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_ReAddNotifyNetwork_r_done, req);

	return req;
}

static void dcerpc_clusapi_ReAddNotifyNetwork_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_ReAddNotifyNetwork_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_ReAddNotifyNetwork_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_ReAddNotifyNetwork_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_ReAddNotifyNetwork_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_ReAddNotifyNetwork *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_READDNOTIFYNETWORK, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_ReAddNotifyNetwork_state {
	struct clusapi_ReAddNotifyNetwork orig;
	struct clusapi_ReAddNotifyNetwork tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_ReAddNotifyNetwork_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_ReAddNotifyNetwork_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle _hNotify /* [in]  */,
							  struct policy_handle _hNetwork /* [in]  */,
							  uint32_t _dwFilter /* [in]  */,
							  uint32_t _dwNotifyKey /* [in]  */,
							  uint32_t _StateSequence /* [in]  */,
							  WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_ReAddNotifyNetwork_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_ReAddNotifyNetwork_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNotify = _hNotify;
	state->orig.in.hNetwork = _hNetwork;
	state->orig.in.dwFilter = _dwFilter;
	state->orig.in.dwNotifyKey = _dwNotifyKey;
	state->orig.in.StateSequence = _StateSequence;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_ReAddNotifyNetwork_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_ReAddNotifyNetwork_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_ReAddNotifyNetwork_done, req);
	return req;
}

static void dcerpc_clusapi_ReAddNotifyNetwork_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_ReAddNotifyNetwork_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_ReAddNotifyNetwork_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_ReAddNotifyNetwork_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_ReAddNotifyNetwork_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_clusapi_ReAddNotifyNetwork_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_ReAddNotifyNetwork_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_ReAddNotifyNetwork(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle _hNotify /* [in]  */,
					   struct policy_handle _hNetwork /* [in]  */,
					   uint32_t _dwFilter /* [in]  */,
					   uint32_t _dwNotifyKey /* [in]  */,
					   uint32_t _StateSequence /* [in]  */,
					   WERROR *_rpc_status /* [out] [ref] */,
					   WERROR *result)
{
	struct clusapi_ReAddNotifyNetwork r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNotify = _hNotify;
	r.in.hNetwork = _hNetwork;
	r.in.dwFilter = _dwFilter;
	r.in.dwNotifyKey = _dwNotifyKey;
	r.in.StateSequence = _StateSequence;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_ReAddNotifyNetwork_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_OpenNetInterface_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OpenNetInterface_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OpenNetInterface_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_OpenNetInterface *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OpenNetInterface_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OpenNetInterface_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OPENNETINTERFACE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OpenNetInterface_r_done, req);

	return req;
}

static void dcerpc_clusapi_OpenNetInterface_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OpenNetInterface_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OpenNetInterface_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_OpenNetInterface_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OpenNetInterface_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_OpenNetInterface *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OPENNETINTERFACE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_OpenNetInterface_state {
	struct clusapi_OpenNetInterface orig;
	struct clusapi_OpenNetInterface tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OpenNetInterface_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OpenNetInterface_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							const char *_lpszNetInterfaceName /* [in] [charset(UTF16),ref] */,
							WERROR *_Status /* [out] [ref] */,
							WERROR *_rpc_status /* [out] [ref] */,
							struct policy_handle *_hNetInterface /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OpenNetInterface_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OpenNetInterface_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.lpszNetInterfaceName = _lpszNetInterfaceName;

	/* Out parameters */
	state->orig.out.Status = _Status;
	state->orig.out.rpc_status = _rpc_status;
	state->orig.out.hNetInterface = _hNetInterface;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_OpenNetInterface_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_OpenNetInterface_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OpenNetInterface_done, req);
	return req;
}

static void dcerpc_clusapi_OpenNetInterface_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_OpenNetInterface_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OpenNetInterface_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_OpenNetInterface_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.Status = *state->tmp.out.Status;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;
	*state->orig.out.hNetInterface = *state->tmp.out.hNetInterface;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OpenNetInterface_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OpenNetInterface_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OpenNetInterface_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OpenNetInterface(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 const char *_lpszNetInterfaceName /* [in] [charset(UTF16),ref] */,
					 WERROR *_Status /* [out] [ref] */,
					 WERROR *_rpc_status /* [out] [ref] */,
					 struct policy_handle *_hNetInterface /* [out] [ref] */)
{
	struct clusapi_OpenNetInterface r;
	NTSTATUS status;

	/* In parameters */
	r.in.lpszNetInterfaceName = _lpszNetInterfaceName;

	/* Out parameters */
	r.out.Status = _Status;
	r.out.rpc_status = _rpc_status;
	r.out.hNetInterface = _hNetInterface;

	status = dcerpc_clusapi_OpenNetInterface_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_Status = *r.out.Status;
	*_rpc_status = *r.out.rpc_status;
	*_hNetInterface = *r.out.hNetInterface;

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_CloseNetInterface_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CloseNetInterface_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CloseNetInterface_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_CloseNetInterface *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CloseNetInterface_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CloseNetInterface_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CLOSENETINTERFACE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CloseNetInterface_r_done, req);

	return req;
}

static void dcerpc_clusapi_CloseNetInterface_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CloseNetInterface_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CloseNetInterface_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_CloseNetInterface_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CloseNetInterface_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_CloseNetInterface *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CLOSENETINTERFACE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_CloseNetInterface_state {
	struct clusapi_CloseNetInterface orig;
	struct clusapi_CloseNetInterface tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CloseNetInterface_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CloseNetInterface_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct policy_handle *_NetInterface /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CloseNetInterface_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CloseNetInterface_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.NetInterface = _NetInterface;

	/* Out parameters */
	state->orig.out.NetInterface = _NetInterface;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_CloseNetInterface_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_CloseNetInterface_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CloseNetInterface_done, req);
	return req;
}

static void dcerpc_clusapi_CloseNetInterface_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_CloseNetInterface_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CloseNetInterface_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_CloseNetInterface_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.NetInterface = *state->tmp.out.NetInterface;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CloseNetInterface_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_clusapi_CloseNetInterface_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CloseNetInterface_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CloseNetInterface(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *_NetInterface /* [in,out] [ref] */,
					  WERROR *result)
{
	struct clusapi_CloseNetInterface r;
	NTSTATUS status;

	/* In parameters */
	r.in.NetInterface = _NetInterface;

	/* Out parameters */
	r.out.NetInterface = _NetInterface;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_CloseNetInterface_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_NetInterface = *r.out.NetInterface;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_GetNetInterfaceState_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetNetInterfaceState_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetNetInterfaceState_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_GetNetInterfaceState *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetNetInterfaceState_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetNetInterfaceState_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETNETINTERFACESTATE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetNetInterfaceState_r_done, req);

	return req;
}

static void dcerpc_clusapi_GetNetInterfaceState_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetNetInterfaceState_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_GetNetInterfaceState_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_GetNetInterfaceState_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetNetInterfaceState_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_GetNetInterfaceState *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETNETINTERFACESTATE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_GetNetInterfaceState_state {
	struct clusapi_GetNetInterfaceState orig;
	struct clusapi_GetNetInterfaceState tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetNetInterfaceState_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetNetInterfaceState_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct dcerpc_binding_handle *h,
							    struct policy_handle _hNetInterface /* [in]  */,
							    enum clusapi_ClusterNetInterfaceState *_State /* [out] [ref] */,
							    WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetNetInterfaceState_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetNetInterfaceState_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNetInterface = _hNetInterface;

	/* Out parameters */
	state->orig.out.State = _State;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_GetNetInterfaceState_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_GetNetInterfaceState_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetNetInterfaceState_done, req);
	return req;
}

static void dcerpc_clusapi_GetNetInterfaceState_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_GetNetInterfaceState_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetNetInterfaceState_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_GetNetInterfaceState_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.State = *state->tmp.out.State;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetNetInterfaceState_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  WERROR *result)
{
	struct dcerpc_clusapi_GetNetInterfaceState_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetNetInterfaceState_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetNetInterfaceState(struct dcerpc_binding_handle *h,
					     TALLOC_CTX *mem_ctx,
					     struct policy_handle _hNetInterface /* [in]  */,
					     enum clusapi_ClusterNetInterfaceState *_State /* [out] [ref] */,
					     WERROR *_rpc_status /* [out] [ref] */,
					     WERROR *result)
{
	struct clusapi_GetNetInterfaceState r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNetInterface = _hNetInterface;

	/* Out parameters */
	r.out.State = _State;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_GetNetInterfaceState_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_State = *r.out.State;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_GetNetInterface_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetNetInterface_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetNetInterface_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_GetNetInterface *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetNetInterface_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetNetInterface_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETNETINTERFACE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetNetInterface_r_done, req);

	return req;
}

static void dcerpc_clusapi_GetNetInterface_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetNetInterface_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_GetNetInterface_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_GetNetInterface_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetNetInterface_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_GetNetInterface *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETNETINTERFACE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_GetNetInterface_state {
	struct clusapi_GetNetInterface orig;
	struct clusapi_GetNetInterface tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetNetInterface_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetNetInterface_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       const char *_lpszNodeName /* [in] [charset(UTF16),ref] */,
						       const char *_lpszNetworkName /* [in] [charset(UTF16),ref] */,
						       const char **_lppszInterfaceName /* [out] [charset(UTF16),ref] */,
						       WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetNetInterface_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetNetInterface_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.lpszNodeName = _lpszNodeName;
	state->orig.in.lpszNetworkName = _lpszNetworkName;

	/* Out parameters */
	state->orig.out.lppszInterfaceName = _lppszInterfaceName;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_GetNetInterface_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_GetNetInterface_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetNetInterface_done, req);
	return req;
}

static void dcerpc_clusapi_GetNetInterface_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_GetNetInterface_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetNetInterface_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_GetNetInterface_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.lppszInterfaceName = *state->tmp.out.lppszInterfaceName;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetNetInterface_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct dcerpc_clusapi_GetNetInterface_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetNetInterface_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetNetInterface(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					const char *_lpszNodeName /* [in] [charset(UTF16),ref] */,
					const char *_lpszNetworkName /* [in] [charset(UTF16),ref] */,
					const char **_lppszInterfaceName /* [out] [charset(UTF16),ref] */,
					WERROR *_rpc_status /* [out] [ref] */,
					WERROR *result)
{
	struct clusapi_GetNetInterface r;
	NTSTATUS status;

	/* In parameters */
	r.in.lpszNodeName = _lpszNodeName;
	r.in.lpszNetworkName = _lpszNetworkName;

	/* Out parameters */
	r.out.lppszInterfaceName = _lppszInterfaceName;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_GetNetInterface_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_lppszInterfaceName = *r.out.lppszInterfaceName;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_GetNetInterfaceId_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetNetInterfaceId_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetNetInterfaceId_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_GetNetInterfaceId *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetNetInterfaceId_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetNetInterfaceId_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETNETINTERFACEID, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetNetInterfaceId_r_done, req);

	return req;
}

static void dcerpc_clusapi_GetNetInterfaceId_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetNetInterfaceId_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_GetNetInterfaceId_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_GetNetInterfaceId_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetNetInterfaceId_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_GetNetInterfaceId *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETNETINTERFACEID, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_GetNetInterfaceId_state {
	struct clusapi_GetNetInterfaceId orig;
	struct clusapi_GetNetInterfaceId tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetNetInterfaceId_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetNetInterfaceId_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct policy_handle _hNetInterface /* [in]  */,
							 const char **_pGuid /* [out] [charset(UTF16),ref] */,
							 WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetNetInterfaceId_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetNetInterfaceId_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNetInterface = _hNetInterface;

	/* Out parameters */
	state->orig.out.pGuid = _pGuid;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_GetNetInterfaceId_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_GetNetInterfaceId_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetNetInterfaceId_done, req);
	return req;
}

static void dcerpc_clusapi_GetNetInterfaceId_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_GetNetInterfaceId_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetNetInterfaceId_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_GetNetInterfaceId_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pGuid = *state->tmp.out.pGuid;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetNetInterfaceId_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_clusapi_GetNetInterfaceId_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetNetInterfaceId_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetNetInterfaceId(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle _hNetInterface /* [in]  */,
					  const char **_pGuid /* [out] [charset(UTF16),ref] */,
					  WERROR *_rpc_status /* [out] [ref] */,
					  WERROR *result)
{
	struct clusapi_GetNetInterfaceId r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNetInterface = _hNetInterface;

	/* Out parameters */
	r.out.pGuid = _pGuid;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_GetNetInterfaceId_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pGuid = *r.out.pGuid;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_NodeNetInterfaceControl_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_NodeNetInterfaceControl_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_NodeNetInterfaceControl_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_NodeNetInterfaceControl *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_NodeNetInterfaceControl_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_NodeNetInterfaceControl_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_NODENETINTERFACECONTROL, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_NodeNetInterfaceControl_r_done, req);

	return req;
}

static void dcerpc_clusapi_NodeNetInterfaceControl_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_NodeNetInterfaceControl_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_NodeNetInterfaceControl_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_NodeNetInterfaceControl_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_NodeNetInterfaceControl_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_NodeNetInterfaceControl *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_NODENETINTERFACECONTROL, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_NodeNetInterfaceControl_state {
	struct clusapi_NodeNetInterfaceControl orig;
	struct clusapi_NodeNetInterfaceControl tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_NodeNetInterfaceControl_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_NodeNetInterfaceControl_send(TALLOC_CTX *mem_ctx,
							       struct tevent_context *ev,
							       struct dcerpc_binding_handle *h,
							       struct policy_handle _hNetInterface /* [in]  */,
							       struct policy_handle _hNode /* [in]  */,
							       uint32_t _dwControlCode /* [in]  */,
							       uint8_t *_lpInBuffer /* [in] [size_is(nInBufferSize),unique] */,
							       uint32_t _nInBufferSize /* [in]  */,
							       uint8_t *_lpOutBuffer /* [out] [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */,
							       uint32_t _nOutBufferSize /* [in]  */,
							       uint32_t *_lpBytesReturned /* [out] [ref] */,
							       uint32_t *_lpcbRequired /* [out] [ref] */,
							       WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_NodeNetInterfaceControl_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_NodeNetInterfaceControl_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNetInterface = _hNetInterface;
	state->orig.in.hNode = _hNode;
	state->orig.in.dwControlCode = _dwControlCode;
	state->orig.in.lpInBuffer = _lpInBuffer;
	state->orig.in.nInBufferSize = _nInBufferSize;
	state->orig.in.nOutBufferSize = _nOutBufferSize;

	/* Out parameters */
	state->orig.out.lpOutBuffer = _lpOutBuffer;
	state->orig.out.lpBytesReturned = _lpBytesReturned;
	state->orig.out.lpcbRequired = _lpcbRequired;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_NodeNetInterfaceControl_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_NodeNetInterfaceControl_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_NodeNetInterfaceControl_done, req);
	return req;
}

static void dcerpc_clusapi_NodeNetInterfaceControl_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_NodeNetInterfaceControl_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_NodeNetInterfaceControl_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_NodeNetInterfaceControl_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_lpOutBuffer;
		if ((*state->tmp.out.lpBytesReturned) > (state->tmp.in.nOutBufferSize)) {
			tevent_req_nterror(req, NT_STATUS_INVALID_NETWORK_RESPONSE);
			return;
		}
		_copy_len_lpOutBuffer = *state->tmp.out.lpBytesReturned;
		if (state->orig.out.lpOutBuffer != state->tmp.out.lpOutBuffer) {
			memcpy(state->orig.out.lpOutBuffer, state->tmp.out.lpOutBuffer, _copy_len_lpOutBuffer * sizeof(*state->orig.out.lpOutBuffer));
		}
	}
	*state->orig.out.lpBytesReturned = *state->tmp.out.lpBytesReturned;
	*state->orig.out.lpcbRequired = *state->tmp.out.lpcbRequired;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_NodeNetInterfaceControl_recv(struct tevent_req *req,
						     TALLOC_CTX *mem_ctx,
						     WERROR *result)
{
	struct dcerpc_clusapi_NodeNetInterfaceControl_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_NodeNetInterfaceControl_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_NodeNetInterfaceControl(struct dcerpc_binding_handle *h,
						TALLOC_CTX *mem_ctx,
						struct policy_handle _hNetInterface /* [in]  */,
						struct policy_handle _hNode /* [in]  */,
						uint32_t _dwControlCode /* [in]  */,
						uint8_t *_lpInBuffer /* [in] [size_is(nInBufferSize),unique] */,
						uint32_t _nInBufferSize /* [in]  */,
						uint8_t *_lpOutBuffer /* [out] [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */,
						uint32_t _nOutBufferSize /* [in]  */,
						uint32_t *_lpBytesReturned /* [out] [ref] */,
						uint32_t *_lpcbRequired /* [out] [ref] */,
						WERROR *_rpc_status /* [out] [ref] */,
						WERROR *result)
{
	struct clusapi_NodeNetInterfaceControl r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNetInterface = _hNetInterface;
	r.in.hNode = _hNode;
	r.in.dwControlCode = _dwControlCode;
	r.in.lpInBuffer = _lpInBuffer;
	r.in.nInBufferSize = _nInBufferSize;
	r.in.nOutBufferSize = _nOutBufferSize;

	/* Out parameters */
	r.out.lpOutBuffer = _lpOutBuffer;
	r.out.lpBytesReturned = _lpBytesReturned;
	r.out.lpcbRequired = _lpcbRequired;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_NodeNetInterfaceControl_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_lpOutBuffer;
		if ((*r.out.lpBytesReturned) > (r.in.nOutBufferSize)) {
			return NT_STATUS_INVALID_NETWORK_RESPONSE;
		}
		_copy_len_lpOutBuffer = *r.out.lpBytesReturned;
		if (_lpOutBuffer != r.out.lpOutBuffer) {
			memcpy(_lpOutBuffer, r.out.lpOutBuffer, _copy_len_lpOutBuffer * sizeof(*_lpOutBuffer));
		}
	}
	*_lpBytesReturned = *r.out.lpBytesReturned;
	*_lpcbRequired = *r.out.lpcbRequired;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_NetInterfaceControl_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_NetInterfaceControl_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_NetInterfaceControl_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_NetInterfaceControl *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_NetInterfaceControl_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_NetInterfaceControl_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_NETINTERFACECONTROL, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_NetInterfaceControl_r_done, req);

	return req;
}

static void dcerpc_clusapi_NetInterfaceControl_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_NetInterfaceControl_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_NetInterfaceControl_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_NetInterfaceControl_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_NetInterfaceControl_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_NetInterfaceControl *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_NETINTERFACECONTROL, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_NetInterfaceControl_state {
	struct clusapi_NetInterfaceControl orig;
	struct clusapi_NetInterfaceControl tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_NetInterfaceControl_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_NetInterfaceControl_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   struct policy_handle _hNetInterface /* [in]  */,
							   uint32_t _dwControlCode /* [in]  */,
							   uint8_t *_lpInBuffer /* [in] [size_is(nInBufferSize),unique] */,
							   uint32_t _nInBufferSize /* [in]  */,
							   uint8_t *_lpOutBuffer /* [out] [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */,
							   uint32_t _nOutBufferSize /* [in]  */,
							   uint32_t *_lpBytesReturned /* [out] [ref] */,
							   uint32_t *_lpcbRequired /* [out] [ref] */,
							   WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_NetInterfaceControl_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_NetInterfaceControl_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNetInterface = _hNetInterface;
	state->orig.in.dwControlCode = _dwControlCode;
	state->orig.in.lpInBuffer = _lpInBuffer;
	state->orig.in.nInBufferSize = _nInBufferSize;
	state->orig.in.nOutBufferSize = _nOutBufferSize;

	/* Out parameters */
	state->orig.out.lpOutBuffer = _lpOutBuffer;
	state->orig.out.lpBytesReturned = _lpBytesReturned;
	state->orig.out.lpcbRequired = _lpcbRequired;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_NetInterfaceControl_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_NetInterfaceControl_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_NetInterfaceControl_done, req);
	return req;
}

static void dcerpc_clusapi_NetInterfaceControl_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_NetInterfaceControl_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_NetInterfaceControl_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_NetInterfaceControl_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_lpOutBuffer;
		if ((*state->tmp.out.lpBytesReturned) > (state->tmp.in.nOutBufferSize)) {
			tevent_req_nterror(req, NT_STATUS_INVALID_NETWORK_RESPONSE);
			return;
		}
		_copy_len_lpOutBuffer = *state->tmp.out.lpBytesReturned;
		if (state->orig.out.lpOutBuffer != state->tmp.out.lpOutBuffer) {
			memcpy(state->orig.out.lpOutBuffer, state->tmp.out.lpOutBuffer, _copy_len_lpOutBuffer * sizeof(*state->orig.out.lpOutBuffer));
		}
	}
	*state->orig.out.lpBytesReturned = *state->tmp.out.lpBytesReturned;
	*state->orig.out.lpcbRequired = *state->tmp.out.lpcbRequired;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_NetInterfaceControl_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result)
{
	struct dcerpc_clusapi_NetInterfaceControl_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_NetInterfaceControl_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_NetInterfaceControl(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle _hNetInterface /* [in]  */,
					    uint32_t _dwControlCode /* [in]  */,
					    uint8_t *_lpInBuffer /* [in] [size_is(nInBufferSize),unique] */,
					    uint32_t _nInBufferSize /* [in]  */,
					    uint8_t *_lpOutBuffer /* [out] [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */,
					    uint32_t _nOutBufferSize /* [in]  */,
					    uint32_t *_lpBytesReturned /* [out] [ref] */,
					    uint32_t *_lpcbRequired /* [out] [ref] */,
					    WERROR *_rpc_status /* [out] [ref] */,
					    WERROR *result)
{
	struct clusapi_NetInterfaceControl r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNetInterface = _hNetInterface;
	r.in.dwControlCode = _dwControlCode;
	r.in.lpInBuffer = _lpInBuffer;
	r.in.nInBufferSize = _nInBufferSize;
	r.in.nOutBufferSize = _nOutBufferSize;

	/* Out parameters */
	r.out.lpOutBuffer = _lpOutBuffer;
	r.out.lpBytesReturned = _lpBytesReturned;
	r.out.lpcbRequired = _lpcbRequired;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_NetInterfaceControl_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_lpOutBuffer;
		if ((*r.out.lpBytesReturned) > (r.in.nOutBufferSize)) {
			return NT_STATUS_INVALID_NETWORK_RESPONSE;
		}
		_copy_len_lpOutBuffer = *r.out.lpBytesReturned;
		if (_lpOutBuffer != r.out.lpOutBuffer) {
			memcpy(_lpOutBuffer, r.out.lpOutBuffer, _copy_len_lpOutBuffer * sizeof(*_lpOutBuffer));
		}
	}
	*_lpBytesReturned = *r.out.lpBytesReturned;
	*_lpcbRequired = *r.out.lpcbRequired;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_AddNotifyNetInterface_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_AddNotifyNetInterface_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_AddNotifyNetInterface_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_AddNotifyNetInterface *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_AddNotifyNetInterface_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_AddNotifyNetInterface_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ADDNOTIFYNETINTERFACE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_AddNotifyNetInterface_r_done, req);

	return req;
}

static void dcerpc_clusapi_AddNotifyNetInterface_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_AddNotifyNetInterface_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_AddNotifyNetInterface_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_AddNotifyNetInterface_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_AddNotifyNetInterface_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_AddNotifyNetInterface *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ADDNOTIFYNETINTERFACE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_AddNotifyNetInterface_state {
	struct clusapi_AddNotifyNetInterface orig;
	struct clusapi_AddNotifyNetInterface tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_AddNotifyNetInterface_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_AddNotifyNetInterface_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct dcerpc_binding_handle *h,
							     struct policy_handle _hNotify /* [in]  */,
							     struct policy_handle _hNetInterface /* [in]  */,
							     uint32_t _dwFilter /* [in]  */,
							     uint32_t _dwNotifyKey /* [in]  */,
							     uint32_t *_dwStateSequence /* [out] [ref] */,
							     WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_AddNotifyNetInterface_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_AddNotifyNetInterface_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNotify = _hNotify;
	state->orig.in.hNetInterface = _hNetInterface;
	state->orig.in.dwFilter = _dwFilter;
	state->orig.in.dwNotifyKey = _dwNotifyKey;

	/* Out parameters */
	state->orig.out.dwStateSequence = _dwStateSequence;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_AddNotifyNetInterface_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_AddNotifyNetInterface_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_AddNotifyNetInterface_done, req);
	return req;
}

static void dcerpc_clusapi_AddNotifyNetInterface_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_AddNotifyNetInterface_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_AddNotifyNetInterface_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_AddNotifyNetInterface_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.dwStateSequence = *state->tmp.out.dwStateSequence;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_AddNotifyNetInterface_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result)
{
	struct dcerpc_clusapi_AddNotifyNetInterface_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_AddNotifyNetInterface_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_AddNotifyNetInterface(struct dcerpc_binding_handle *h,
					      TALLOC_CTX *mem_ctx,
					      struct policy_handle _hNotify /* [in]  */,
					      struct policy_handle _hNetInterface /* [in]  */,
					      uint32_t _dwFilter /* [in]  */,
					      uint32_t _dwNotifyKey /* [in]  */,
					      uint32_t *_dwStateSequence /* [out] [ref] */,
					      WERROR *_rpc_status /* [out] [ref] */,
					      WERROR *result)
{
	struct clusapi_AddNotifyNetInterface r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNotify = _hNotify;
	r.in.hNetInterface = _hNetInterface;
	r.in.dwFilter = _dwFilter;
	r.in.dwNotifyKey = _dwNotifyKey;

	/* Out parameters */
	r.out.dwStateSequence = _dwStateSequence;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_AddNotifyNetInterface_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_dwStateSequence = *r.out.dwStateSequence;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_ReAddNotifyNetInterface_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_ReAddNotifyNetInterface_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_ReAddNotifyNetInterface_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_ReAddNotifyNetInterface *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_ReAddNotifyNetInterface_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_ReAddNotifyNetInterface_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_READDNOTIFYNETINTERFACE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_ReAddNotifyNetInterface_r_done, req);

	return req;
}

static void dcerpc_clusapi_ReAddNotifyNetInterface_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_ReAddNotifyNetInterface_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_ReAddNotifyNetInterface_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_ReAddNotifyNetInterface_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_ReAddNotifyNetInterface_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_ReAddNotifyNetInterface *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_READDNOTIFYNETINTERFACE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_ReAddNotifyNetInterface_state {
	struct clusapi_ReAddNotifyNetInterface orig;
	struct clusapi_ReAddNotifyNetInterface tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_ReAddNotifyNetInterface_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_ReAddNotifyNetInterface_send(TALLOC_CTX *mem_ctx,
							       struct tevent_context *ev,
							       struct dcerpc_binding_handle *h,
							       struct policy_handle _hNotify /* [in]  */,
							       struct policy_handle _hNetInterface /* [in]  */,
							       uint32_t _dwFilter /* [in]  */,
							       uint32_t _dwNotifyKey /* [in]  */,
							       uint32_t _StateSequence /* [in]  */,
							       WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_ReAddNotifyNetInterface_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_ReAddNotifyNetInterface_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNotify = _hNotify;
	state->orig.in.hNetInterface = _hNetInterface;
	state->orig.in.dwFilter = _dwFilter;
	state->orig.in.dwNotifyKey = _dwNotifyKey;
	state->orig.in.StateSequence = _StateSequence;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_ReAddNotifyNetInterface_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_ReAddNotifyNetInterface_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_ReAddNotifyNetInterface_done, req);
	return req;
}

static void dcerpc_clusapi_ReAddNotifyNetInterface_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_ReAddNotifyNetInterface_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_ReAddNotifyNetInterface_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_ReAddNotifyNetInterface_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_ReAddNotifyNetInterface_recv(struct tevent_req *req,
						     TALLOC_CTX *mem_ctx,
						     WERROR *result)
{
	struct dcerpc_clusapi_ReAddNotifyNetInterface_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_ReAddNotifyNetInterface_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_ReAddNotifyNetInterface(struct dcerpc_binding_handle *h,
						TALLOC_CTX *mem_ctx,
						struct policy_handle _hNotify /* [in]  */,
						struct policy_handle _hNetInterface /* [in]  */,
						uint32_t _dwFilter /* [in]  */,
						uint32_t _dwNotifyKey /* [in]  */,
						uint32_t _StateSequence /* [in]  */,
						WERROR *_rpc_status /* [out] [ref] */,
						WERROR *result)
{
	struct clusapi_ReAddNotifyNetInterface r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNotify = _hNotify;
	r.in.hNetInterface = _hNetInterface;
	r.in.dwFilter = _dwFilter;
	r.in.dwNotifyKey = _dwNotifyKey;
	r.in.StateSequence = _StateSequence;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_ReAddNotifyNetInterface_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_CreateNodeEnum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateNodeEnum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateNodeEnum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_CreateNodeEnum *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateNodeEnum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateNodeEnum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATENODEENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateNodeEnum_r_done, req);

	return req;
}

static void dcerpc_clusapi_CreateNodeEnum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateNodeEnum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CreateNodeEnum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_CreateNodeEnum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateNodeEnum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_CreateNodeEnum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATENODEENUM, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_CreateNodeEnum_state {
	struct clusapi_CreateNodeEnum orig;
	struct clusapi_CreateNodeEnum tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateNodeEnum_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateNodeEnum_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle _hNode /* [in]  */,
						      uint32_t _dwType /* [in]  */,
						      struct ENUM_LIST **_ReturnEnum /* [out] [ref] */,
						      WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateNodeEnum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateNodeEnum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNode = _hNode;
	state->orig.in.dwType = _dwType;

	/* Out parameters */
	state->orig.out.ReturnEnum = _ReturnEnum;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_CreateNodeEnum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_CreateNodeEnum_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateNodeEnum_done, req);
	return req;
}

static void dcerpc_clusapi_CreateNodeEnum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_CreateNodeEnum_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateNodeEnum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_CreateNodeEnum_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ReturnEnum = *state->tmp.out.ReturnEnum;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateNodeEnum_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_clusapi_CreateNodeEnum_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateNodeEnum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateNodeEnum(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle _hNode /* [in]  */,
				       uint32_t _dwType /* [in]  */,
				       struct ENUM_LIST **_ReturnEnum /* [out] [ref] */,
				       WERROR *_rpc_status /* [out] [ref] */,
				       WERROR *result)
{
	struct clusapi_CreateNodeEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNode = _hNode;
	r.in.dwType = _dwType;

	/* Out parameters */
	r.out.ReturnEnum = _ReturnEnum;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_CreateNodeEnum_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ReturnEnum = *r.out.ReturnEnum;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_GetClusterVersion2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetClusterVersion2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetClusterVersion2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_GetClusterVersion2 *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetClusterVersion2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetClusterVersion2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETCLUSTERVERSION2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetClusterVersion2_r_done, req);

	return req;
}

static void dcerpc_clusapi_GetClusterVersion2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetClusterVersion2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_GetClusterVersion2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_GetClusterVersion2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetClusterVersion2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_GetClusterVersion2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETCLUSTERVERSION2, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_GetClusterVersion2_state {
	struct clusapi_GetClusterVersion2 orig;
	struct clusapi_GetClusterVersion2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetClusterVersion2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetClusterVersion2_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  uint16_t *_lpwMajorVersion /* [out] [ref] */,
							  uint16_t *_lpwMinorVersion /* [out] [ref] */,
							  uint16_t *_lpwBuildNumber /* [out] [ref] */,
							  const char **_lpszVendorId /* [out] [charset(UTF16),ref] */,
							  const char **_lpszCSDVersion /* [out] [charset(UTF16),ref] */,
							  struct CLUSTER_OPERATIONAL_VERSION_INFO **_ppClusterOpVerInfo /* [out] [ref] */,
							  WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetClusterVersion2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetClusterVersion2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */
	state->orig.out.lpwMajorVersion = _lpwMajorVersion;
	state->orig.out.lpwMinorVersion = _lpwMinorVersion;
	state->orig.out.lpwBuildNumber = _lpwBuildNumber;
	state->orig.out.lpszVendorId = _lpszVendorId;
	state->orig.out.lpszCSDVersion = _lpszCSDVersion;
	state->orig.out.ppClusterOpVerInfo = _ppClusterOpVerInfo;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_GetClusterVersion2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_GetClusterVersion2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetClusterVersion2_done, req);
	return req;
}

static void dcerpc_clusapi_GetClusterVersion2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_GetClusterVersion2_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetClusterVersion2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_GetClusterVersion2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.lpwMajorVersion = *state->tmp.out.lpwMajorVersion;
	*state->orig.out.lpwMinorVersion = *state->tmp.out.lpwMinorVersion;
	*state->orig.out.lpwBuildNumber = *state->tmp.out.lpwBuildNumber;
	*state->orig.out.lpszVendorId = *state->tmp.out.lpszVendorId;
	*state->orig.out.lpszCSDVersion = *state->tmp.out.lpszCSDVersion;
	*state->orig.out.ppClusterOpVerInfo = *state->tmp.out.ppClusterOpVerInfo;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetClusterVersion2_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_clusapi_GetClusterVersion2_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetClusterVersion2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetClusterVersion2(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   uint16_t *_lpwMajorVersion /* [out] [ref] */,
					   uint16_t *_lpwMinorVersion /* [out] [ref] */,
					   uint16_t *_lpwBuildNumber /* [out] [ref] */,
					   const char **_lpszVendorId /* [out] [charset(UTF16),ref] */,
					   const char **_lpszCSDVersion /* [out] [charset(UTF16),ref] */,
					   struct CLUSTER_OPERATIONAL_VERSION_INFO **_ppClusterOpVerInfo /* [out] [ref] */,
					   WERROR *_rpc_status /* [out] [ref] */,
					   WERROR *result)
{
	struct clusapi_GetClusterVersion2 r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */
	r.out.lpwMajorVersion = _lpwMajorVersion;
	r.out.lpwMinorVersion = _lpwMinorVersion;
	r.out.lpwBuildNumber = _lpwBuildNumber;
	r.out.lpszVendorId = _lpszVendorId;
	r.out.lpszCSDVersion = _lpszCSDVersion;
	r.out.ppClusterOpVerInfo = _ppClusterOpVerInfo;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_GetClusterVersion2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_lpwMajorVersion = *r.out.lpwMajorVersion;
	*_lpwMinorVersion = *r.out.lpwMinorVersion;
	*_lpwBuildNumber = *r.out.lpwBuildNumber;
	*_lpszVendorId = *r.out.lpszVendorId;
	*_lpszCSDVersion = *r.out.lpszCSDVersion;
	*_ppClusterOpVerInfo = *r.out.ppClusterOpVerInfo;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_CreateResTypeEnum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateResTypeEnum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateResTypeEnum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_CreateResTypeEnum *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateResTypeEnum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateResTypeEnum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATERESTYPEENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateResTypeEnum_r_done, req);

	return req;
}

static void dcerpc_clusapi_CreateResTypeEnum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateResTypeEnum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CreateResTypeEnum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_CreateResTypeEnum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateResTypeEnum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_CreateResTypeEnum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATERESTYPEENUM, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_CreateResTypeEnum_state {
	struct clusapi_CreateResTypeEnum orig;
	struct clusapi_CreateResTypeEnum tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateResTypeEnum_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateResTypeEnum_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 const char *_lpszTypeName /* [in] [charset(UTF16),ref] */,
							 uint32_t _dwType /* [in]  */,
							 struct ENUM_LIST **_ReturnEnum /* [out] [ref] */,
							 WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateResTypeEnum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateResTypeEnum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.lpszTypeName = _lpszTypeName;
	state->orig.in.dwType = _dwType;

	/* Out parameters */
	state->orig.out.ReturnEnum = _ReturnEnum;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_CreateResTypeEnum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_CreateResTypeEnum_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateResTypeEnum_done, req);
	return req;
}

static void dcerpc_clusapi_CreateResTypeEnum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_CreateResTypeEnum_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateResTypeEnum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_CreateResTypeEnum_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ReturnEnum = *state->tmp.out.ReturnEnum;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateResTypeEnum_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_clusapi_CreateResTypeEnum_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateResTypeEnum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateResTypeEnum(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  const char *_lpszTypeName /* [in] [charset(UTF16),ref] */,
					  uint32_t _dwType /* [in]  */,
					  struct ENUM_LIST **_ReturnEnum /* [out] [ref] */,
					  WERROR *_rpc_status /* [out] [ref] */,
					  WERROR *result)
{
	struct clusapi_CreateResTypeEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.lpszTypeName = _lpszTypeName;
	r.in.dwType = _dwType;

	/* Out parameters */
	r.out.ReturnEnum = _ReturnEnum;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_CreateResTypeEnum_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ReturnEnum = *r.out.ReturnEnum;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_BackupClusterDatabase_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_BackupClusterDatabase_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_BackupClusterDatabase_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_BackupClusterDatabase *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_BackupClusterDatabase_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_BackupClusterDatabase_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_BACKUPCLUSTERDATABASE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_BackupClusterDatabase_r_done, req);

	return req;
}

static void dcerpc_clusapi_BackupClusterDatabase_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_BackupClusterDatabase_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_BackupClusterDatabase_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_BackupClusterDatabase_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_BackupClusterDatabase_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_BackupClusterDatabase *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_BACKUPCLUSTERDATABASE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_BackupClusterDatabase_state {
	struct clusapi_BackupClusterDatabase orig;
	struct clusapi_BackupClusterDatabase tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_BackupClusterDatabase_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_BackupClusterDatabase_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct dcerpc_binding_handle *h,
							     const char *_lpszPathName /* [in] [charset(UTF16),ref] */,
							     WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_BackupClusterDatabase_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_BackupClusterDatabase_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.lpszPathName = _lpszPathName;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_BackupClusterDatabase_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_BackupClusterDatabase_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_BackupClusterDatabase_done, req);
	return req;
}

static void dcerpc_clusapi_BackupClusterDatabase_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_BackupClusterDatabase_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_BackupClusterDatabase_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_BackupClusterDatabase_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_BackupClusterDatabase_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result)
{
	struct dcerpc_clusapi_BackupClusterDatabase_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_BackupClusterDatabase_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_BackupClusterDatabase(struct dcerpc_binding_handle *h,
					      TALLOC_CTX *mem_ctx,
					      const char *_lpszPathName /* [in] [charset(UTF16),ref] */,
					      WERROR *_rpc_status /* [out] [ref] */,
					      WERROR *result)
{
	struct clusapi_BackupClusterDatabase r;
	NTSTATUS status;

	/* In parameters */
	r.in.lpszPathName = _lpszPathName;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_BackupClusterDatabase_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_NodeClusterControl_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_NodeClusterControl_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_NodeClusterControl_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_NodeClusterControl *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_NodeClusterControl_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_NodeClusterControl_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_NODECLUSTERCONTROL, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_NodeClusterControl_r_done, req);

	return req;
}

static void dcerpc_clusapi_NodeClusterControl_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_NodeClusterControl_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_NodeClusterControl_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_NodeClusterControl_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_NodeClusterControl_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_NodeClusterControl *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_NODECLUSTERCONTROL, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_NodeClusterControl_state {
	struct clusapi_NodeClusterControl orig;
	struct clusapi_NodeClusterControl tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_NodeClusterControl_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_NodeClusterControl_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle _hCluster /* [in]  */,
							  struct policy_handle _hHostNode /* [in]  */,
							  uint32_t _dwControlCode /* [in]  */,
							  uint8_t *_lpInBuffer /* [in] [size_is(nInBufferSize),unique] */,
							  uint32_t _nInBufferSize /* [in]  */,
							  uint8_t *_lpOutBuffer /* [out] [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */,
							  uint32_t _nOutBufferSize /* [in]  */,
							  uint32_t *_lpBytesReturned /* [out] [ref] */,
							  uint32_t *_lpcbRequired /* [out] [ref] */,
							  WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_NodeClusterControl_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_NodeClusterControl_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hCluster = _hCluster;
	state->orig.in.hHostNode = _hHostNode;
	state->orig.in.dwControlCode = _dwControlCode;
	state->orig.in.lpInBuffer = _lpInBuffer;
	state->orig.in.nInBufferSize = _nInBufferSize;
	state->orig.in.nOutBufferSize = _nOutBufferSize;

	/* Out parameters */
	state->orig.out.lpOutBuffer = _lpOutBuffer;
	state->orig.out.lpBytesReturned = _lpBytesReturned;
	state->orig.out.lpcbRequired = _lpcbRequired;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_NodeClusterControl_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_NodeClusterControl_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_NodeClusterControl_done, req);
	return req;
}

static void dcerpc_clusapi_NodeClusterControl_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_NodeClusterControl_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_NodeClusterControl_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_NodeClusterControl_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_lpOutBuffer;
		if ((*state->tmp.out.lpBytesReturned) > (state->tmp.in.nOutBufferSize)) {
			tevent_req_nterror(req, NT_STATUS_INVALID_NETWORK_RESPONSE);
			return;
		}
		_copy_len_lpOutBuffer = *state->tmp.out.lpBytesReturned;
		if (state->orig.out.lpOutBuffer != state->tmp.out.lpOutBuffer) {
			memcpy(state->orig.out.lpOutBuffer, state->tmp.out.lpOutBuffer, _copy_len_lpOutBuffer * sizeof(*state->orig.out.lpOutBuffer));
		}
	}
	*state->orig.out.lpBytesReturned = *state->tmp.out.lpBytesReturned;
	*state->orig.out.lpcbRequired = *state->tmp.out.lpcbRequired;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_NodeClusterControl_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_clusapi_NodeClusterControl_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_NodeClusterControl_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_NodeClusterControl(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle _hCluster /* [in]  */,
					   struct policy_handle _hHostNode /* [in]  */,
					   uint32_t _dwControlCode /* [in]  */,
					   uint8_t *_lpInBuffer /* [in] [size_is(nInBufferSize),unique] */,
					   uint32_t _nInBufferSize /* [in]  */,
					   uint8_t *_lpOutBuffer /* [out] [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */,
					   uint32_t _nOutBufferSize /* [in]  */,
					   uint32_t *_lpBytesReturned /* [out] [ref] */,
					   uint32_t *_lpcbRequired /* [out] [ref] */,
					   WERROR *_rpc_status /* [out] [ref] */,
					   WERROR *result)
{
	struct clusapi_NodeClusterControl r;
	NTSTATUS status;

	/* In parameters */
	r.in.hCluster = _hCluster;
	r.in.hHostNode = _hHostNode;
	r.in.dwControlCode = _dwControlCode;
	r.in.lpInBuffer = _lpInBuffer;
	r.in.nInBufferSize = _nInBufferSize;
	r.in.nOutBufferSize = _nOutBufferSize;

	/* Out parameters */
	r.out.lpOutBuffer = _lpOutBuffer;
	r.out.lpBytesReturned = _lpBytesReturned;
	r.out.lpcbRequired = _lpcbRequired;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_NodeClusterControl_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_lpOutBuffer;
		if ((*r.out.lpBytesReturned) > (r.in.nOutBufferSize)) {
			return NT_STATUS_INVALID_NETWORK_RESPONSE;
		}
		_copy_len_lpOutBuffer = *r.out.lpBytesReturned;
		if (_lpOutBuffer != r.out.lpOutBuffer) {
			memcpy(_lpOutBuffer, r.out.lpOutBuffer, _copy_len_lpOutBuffer * sizeof(*_lpOutBuffer));
		}
	}
	*_lpBytesReturned = *r.out.lpBytesReturned;
	*_lpcbRequired = *r.out.lpcbRequired;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_ClusterControl_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_ClusterControl_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_ClusterControl_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_ClusterControl *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_ClusterControl_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_ClusterControl_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CLUSTERCONTROL, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_ClusterControl_r_done, req);

	return req;
}

static void dcerpc_clusapi_ClusterControl_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_ClusterControl_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_ClusterControl_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_ClusterControl_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_ClusterControl_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_ClusterControl *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CLUSTERCONTROL, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_ClusterControl_state {
	struct clusapi_ClusterControl orig;
	struct clusapi_ClusterControl tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_ClusterControl_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_ClusterControl_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle _hCluster /* [in]  */,
						      enum clusapi_ClusterControlCode _dwControlCode /* [in]  */,
						      uint8_t *_lpInBuffer /* [in] [size_is(nInBufferSize),unique] */,
						      uint32_t _nInBufferSize /* [in]  */,
						      uint8_t *_lpOutBuffer /* [out] [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */,
						      uint32_t _nOutBufferSize /* [in]  */,
						      uint32_t *_lpBytesReturned /* [out] [ref] */,
						      uint32_t *_lpcbRequired /* [out] [ref] */,
						      WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_ClusterControl_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_ClusterControl_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hCluster = _hCluster;
	state->orig.in.dwControlCode = _dwControlCode;
	state->orig.in.lpInBuffer = _lpInBuffer;
	state->orig.in.nInBufferSize = _nInBufferSize;
	state->orig.in.nOutBufferSize = _nOutBufferSize;

	/* Out parameters */
	state->orig.out.lpOutBuffer = _lpOutBuffer;
	state->orig.out.lpBytesReturned = _lpBytesReturned;
	state->orig.out.lpcbRequired = _lpcbRequired;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_ClusterControl_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_ClusterControl_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_ClusterControl_done, req);
	return req;
}

static void dcerpc_clusapi_ClusterControl_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_ClusterControl_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_ClusterControl_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_ClusterControl_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_lpOutBuffer;
		if ((*state->tmp.out.lpBytesReturned) > (state->tmp.in.nOutBufferSize)) {
			tevent_req_nterror(req, NT_STATUS_INVALID_NETWORK_RESPONSE);
			return;
		}
		_copy_len_lpOutBuffer = *state->tmp.out.lpBytesReturned;
		if (state->orig.out.lpOutBuffer != state->tmp.out.lpOutBuffer) {
			memcpy(state->orig.out.lpOutBuffer, state->tmp.out.lpOutBuffer, _copy_len_lpOutBuffer * sizeof(*state->orig.out.lpOutBuffer));
		}
	}
	*state->orig.out.lpBytesReturned = *state->tmp.out.lpBytesReturned;
	*state->orig.out.lpcbRequired = *state->tmp.out.lpcbRequired;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_ClusterControl_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_clusapi_ClusterControl_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_ClusterControl_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_ClusterControl(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle _hCluster /* [in]  */,
				       enum clusapi_ClusterControlCode _dwControlCode /* [in]  */,
				       uint8_t *_lpInBuffer /* [in] [size_is(nInBufferSize),unique] */,
				       uint32_t _nInBufferSize /* [in]  */,
				       uint8_t *_lpOutBuffer /* [out] [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */,
				       uint32_t _nOutBufferSize /* [in]  */,
				       uint32_t *_lpBytesReturned /* [out] [ref] */,
				       uint32_t *_lpcbRequired /* [out] [ref] */,
				       WERROR *_rpc_status /* [out] [ref] */,
				       WERROR *result)
{
	struct clusapi_ClusterControl r;
	NTSTATUS status;

	/* In parameters */
	r.in.hCluster = _hCluster;
	r.in.dwControlCode = _dwControlCode;
	r.in.lpInBuffer = _lpInBuffer;
	r.in.nInBufferSize = _nInBufferSize;
	r.in.nOutBufferSize = _nOutBufferSize;

	/* Out parameters */
	r.out.lpOutBuffer = _lpOutBuffer;
	r.out.lpBytesReturned = _lpBytesReturned;
	r.out.lpcbRequired = _lpcbRequired;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_ClusterControl_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_lpOutBuffer;
		if ((*r.out.lpBytesReturned) > (r.in.nOutBufferSize)) {
			return NT_STATUS_INVALID_NETWORK_RESPONSE;
		}
		_copy_len_lpOutBuffer = *r.out.lpBytesReturned;
		if (_lpOutBuffer != r.out.lpOutBuffer) {
			memcpy(_lpOutBuffer, r.out.lpOutBuffer, _copy_len_lpOutBuffer * sizeof(*_lpOutBuffer));
		}
	}
	*_lpBytesReturned = *r.out.lpBytesReturned;
	*_lpcbRequired = *r.out.lpcbRequired;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_UnblockGetNotifyCall_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_UnblockGetNotifyCall_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_UnblockGetNotifyCall_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_UnblockGetNotifyCall *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_UnblockGetNotifyCall_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_UnblockGetNotifyCall_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_UNBLOCKGETNOTIFYCALL, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_UnblockGetNotifyCall_r_done, req);

	return req;
}

static void dcerpc_clusapi_UnblockGetNotifyCall_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_UnblockGetNotifyCall_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_UnblockGetNotifyCall_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_UnblockGetNotifyCall_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_UnblockGetNotifyCall_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_UnblockGetNotifyCall *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_UNBLOCKGETNOTIFYCALL, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_UnblockGetNotifyCall_state {
	struct clusapi_UnblockGetNotifyCall orig;
	struct clusapi_UnblockGetNotifyCall tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_UnblockGetNotifyCall_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_UnblockGetNotifyCall_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct dcerpc_binding_handle *h,
							    struct policy_handle _hNotify /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_UnblockGetNotifyCall_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_UnblockGetNotifyCall_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNotify = _hNotify;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_UnblockGetNotifyCall_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_UnblockGetNotifyCall_done, req);
	return req;
}

static void dcerpc_clusapi_UnblockGetNotifyCall_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_UnblockGetNotifyCall_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_UnblockGetNotifyCall_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_UnblockGetNotifyCall_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_UnblockGetNotifyCall_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  WERROR *result)
{
	struct dcerpc_clusapi_UnblockGetNotifyCall_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_UnblockGetNotifyCall_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_UnblockGetNotifyCall(struct dcerpc_binding_handle *h,
					     TALLOC_CTX *mem_ctx,
					     struct policy_handle _hNotify /* [in]  */,
					     WERROR *result)
{
	struct clusapi_UnblockGetNotifyCall r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNotify = _hNotify;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_UnblockGetNotifyCall_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_SetServiceAccountPassword_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_SetServiceAccountPassword_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_SetServiceAccountPassword_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_SetServiceAccountPassword *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_SetServiceAccountPassword_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_SetServiceAccountPassword_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_SETSERVICEACCOUNTPASSWORD, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_SetServiceAccountPassword_r_done, req);

	return req;
}

static void dcerpc_clusapi_SetServiceAccountPassword_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_SetServiceAccountPassword_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_SetServiceAccountPassword_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_SetServiceAccountPassword_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_SetServiceAccountPassword_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_SetServiceAccountPassword *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_SETSERVICEACCOUNTPASSWORD, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_SetServiceAccountPassword_state {
	struct clusapi_SetServiceAccountPassword orig;
	struct clusapi_SetServiceAccountPassword tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_SetServiceAccountPassword_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_SetServiceAccountPassword_send(TALLOC_CTX *mem_ctx,
								 struct tevent_context *ev,
								 struct dcerpc_binding_handle *h,
								 const char *_lpszNewPassword /* [in] [charset(UTF16),ref] */,
								 enum IDL_CLUSTER_SET_PASSWORD_FLAGS _dwFlags /* [in]  */,
								 struct IDL_CLUSTER_SET_PASSWORD_STATUS *_ReturnStatusBufferPtr /* [out] [length_is(*SizeReturned),size_is(ReturnStatusBufferSize)] */,
								 uint32_t _ReturnStatusBufferSize /* [in] [range(0,(64*1024))] */,
								 uint32_t *_SizeReturned /* [out] [ref] */,
								 uint32_t *_ExpectedBufferSize /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_SetServiceAccountPassword_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_SetServiceAccountPassword_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.lpszNewPassword = _lpszNewPassword;
	state->orig.in.dwFlags = _dwFlags;
	state->orig.in.ReturnStatusBufferSize = _ReturnStatusBufferSize;

	/* Out parameters */
	state->orig.out.ReturnStatusBufferPtr = _ReturnStatusBufferPtr;
	state->orig.out.SizeReturned = _SizeReturned;
	state->orig.out.ExpectedBufferSize = _ExpectedBufferSize;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_SetServiceAccountPassword_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_SetServiceAccountPassword_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_SetServiceAccountPassword_done, req);
	return req;
}

static void dcerpc_clusapi_SetServiceAccountPassword_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_SetServiceAccountPassword_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_SetServiceAccountPassword_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_SetServiceAccountPassword_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_ReturnStatusBufferPtr;
		if ((*state->tmp.out.SizeReturned) > (state->tmp.in.ReturnStatusBufferSize)) {
			tevent_req_nterror(req, NT_STATUS_INVALID_NETWORK_RESPONSE);
			return;
		}
		_copy_len_ReturnStatusBufferPtr = *state->tmp.out.SizeReturned;
		if (state->orig.out.ReturnStatusBufferPtr != state->tmp.out.ReturnStatusBufferPtr) {
			memcpy(state->orig.out.ReturnStatusBufferPtr, state->tmp.out.ReturnStatusBufferPtr, _copy_len_ReturnStatusBufferPtr * sizeof(*state->orig.out.ReturnStatusBufferPtr));
		}
	}
	*state->orig.out.SizeReturned = *state->tmp.out.SizeReturned;
	*state->orig.out.ExpectedBufferSize = *state->tmp.out.ExpectedBufferSize;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_SetServiceAccountPassword_recv(struct tevent_req *req,
						       TALLOC_CTX *mem_ctx,
						       WERROR *result)
{
	struct dcerpc_clusapi_SetServiceAccountPassword_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_SetServiceAccountPassword_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_SetServiceAccountPassword(struct dcerpc_binding_handle *h,
						  TALLOC_CTX *mem_ctx,
						  const char *_lpszNewPassword /* [in] [charset(UTF16),ref] */,
						  enum IDL_CLUSTER_SET_PASSWORD_FLAGS _dwFlags /* [in]  */,
						  struct IDL_CLUSTER_SET_PASSWORD_STATUS *_ReturnStatusBufferPtr /* [out] [length_is(*SizeReturned),size_is(ReturnStatusBufferSize)] */,
						  uint32_t _ReturnStatusBufferSize /* [in] [range(0,(64*1024))] */,
						  uint32_t *_SizeReturned /* [out] [ref] */,
						  uint32_t *_ExpectedBufferSize /* [out] [ref] */,
						  WERROR *result)
{
	struct clusapi_SetServiceAccountPassword r;
	NTSTATUS status;

	/* In parameters */
	r.in.lpszNewPassword = _lpszNewPassword;
	r.in.dwFlags = _dwFlags;
	r.in.ReturnStatusBufferSize = _ReturnStatusBufferSize;

	/* Out parameters */
	r.out.ReturnStatusBufferPtr = _ReturnStatusBufferPtr;
	r.out.SizeReturned = _SizeReturned;
	r.out.ExpectedBufferSize = _ExpectedBufferSize;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_SetServiceAccountPassword_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_ReturnStatusBufferPtr;
		if ((*r.out.SizeReturned) > (r.in.ReturnStatusBufferSize)) {
			return NT_STATUS_INVALID_NETWORK_RESPONSE;
		}
		_copy_len_ReturnStatusBufferPtr = *r.out.SizeReturned;
		if (_ReturnStatusBufferPtr != r.out.ReturnStatusBufferPtr) {
			memcpy(_ReturnStatusBufferPtr, r.out.ReturnStatusBufferPtr, _copy_len_ReturnStatusBufferPtr * sizeof(*_ReturnStatusBufferPtr));
		}
	}
	*_SizeReturned = *r.out.SizeReturned;
	*_ExpectedBufferSize = *r.out.ExpectedBufferSize;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_SetResourceDependencyExpression_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_SetResourceDependencyExpression_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_SetResourceDependencyExpression_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_SetResourceDependencyExpression *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_SetResourceDependencyExpression_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_SetResourceDependencyExpression_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_SETRESOURCEDEPENDENCYEXPRESSION, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_SetResourceDependencyExpression_r_done, req);

	return req;
}

static void dcerpc_clusapi_SetResourceDependencyExpression_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_SetResourceDependencyExpression_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_SetResourceDependencyExpression_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_SetResourceDependencyExpression_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_SetResourceDependencyExpression_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_SetResourceDependencyExpression *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_SETRESOURCEDEPENDENCYEXPRESSION, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_SetResourceDependencyExpression_state {
	struct clusapi_SetResourceDependencyExpression orig;
	struct clusapi_SetResourceDependencyExpression tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_SetResourceDependencyExpression_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_SetResourceDependencyExpression_send(TALLOC_CTX *mem_ctx,
								       struct tevent_context *ev,
								       struct dcerpc_binding_handle *h,
								       struct policy_handle _hResource /* [in]  */,
								       const char *_lpszDependencyExpression /* [in] [charset(UTF16),unique] */,
								       WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_SetResourceDependencyExpression_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_SetResourceDependencyExpression_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hResource = _hResource;
	state->orig.in.lpszDependencyExpression = _lpszDependencyExpression;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_SetResourceDependencyExpression_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_SetResourceDependencyExpression_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_SetResourceDependencyExpression_done, req);
	return req;
}

static void dcerpc_clusapi_SetResourceDependencyExpression_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_SetResourceDependencyExpression_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_SetResourceDependencyExpression_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_SetResourceDependencyExpression_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_SetResourceDependencyExpression_recv(struct tevent_req *req,
							     TALLOC_CTX *mem_ctx,
							     WERROR *result)
{
	struct dcerpc_clusapi_SetResourceDependencyExpression_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_SetResourceDependencyExpression_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_SetResourceDependencyExpression(struct dcerpc_binding_handle *h,
							TALLOC_CTX *mem_ctx,
							struct policy_handle _hResource /* [in]  */,
							const char *_lpszDependencyExpression /* [in] [charset(UTF16),unique] */,
							WERROR *_rpc_status /* [out] [ref] */,
							WERROR *result)
{
	struct clusapi_SetResourceDependencyExpression r;
	NTSTATUS status;

	/* In parameters */
	r.in.hResource = _hResource;
	r.in.lpszDependencyExpression = _lpszDependencyExpression;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_SetResourceDependencyExpression_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_GetResourceDependencyExpression_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetResourceDependencyExpression_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetResourceDependencyExpression_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_GetResourceDependencyExpression *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetResourceDependencyExpression_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetResourceDependencyExpression_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETRESOURCEDEPENDENCYEXPRESSION, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetResourceDependencyExpression_r_done, req);

	return req;
}

static void dcerpc_clusapi_GetResourceDependencyExpression_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetResourceDependencyExpression_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_GetResourceDependencyExpression_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_GetResourceDependencyExpression_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetResourceDependencyExpression_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_GetResourceDependencyExpression *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETRESOURCEDEPENDENCYEXPRESSION, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_GetResourceDependencyExpression_state {
	struct clusapi_GetResourceDependencyExpression orig;
	struct clusapi_GetResourceDependencyExpression tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetResourceDependencyExpression_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetResourceDependencyExpression_send(TALLOC_CTX *mem_ctx,
								       struct tevent_context *ev,
								       struct dcerpc_binding_handle *h,
								       struct policy_handle _hResource /* [in]  */,
								       const char **_lpszDependencyExpression /* [out] [charset(UTF16),ref] */,
								       WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetResourceDependencyExpression_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetResourceDependencyExpression_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hResource = _hResource;

	/* Out parameters */
	state->orig.out.lpszDependencyExpression = _lpszDependencyExpression;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_GetResourceDependencyExpression_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_GetResourceDependencyExpression_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetResourceDependencyExpression_done, req);
	return req;
}

static void dcerpc_clusapi_GetResourceDependencyExpression_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_GetResourceDependencyExpression_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetResourceDependencyExpression_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_GetResourceDependencyExpression_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.lpszDependencyExpression = *state->tmp.out.lpszDependencyExpression;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetResourceDependencyExpression_recv(struct tevent_req *req,
							     TALLOC_CTX *mem_ctx,
							     WERROR *result)
{
	struct dcerpc_clusapi_GetResourceDependencyExpression_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetResourceDependencyExpression_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetResourceDependencyExpression(struct dcerpc_binding_handle *h,
							TALLOC_CTX *mem_ctx,
							struct policy_handle _hResource /* [in]  */,
							const char **_lpszDependencyExpression /* [out] [charset(UTF16),ref] */,
							WERROR *_rpc_status /* [out] [ref] */,
							WERROR *result)
{
	struct clusapi_GetResourceDependencyExpression r;
	NTSTATUS status;

	/* In parameters */
	r.in.hResource = _hResource;

	/* Out parameters */
	r.out.lpszDependencyExpression = _lpszDependencyExpression;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_GetResourceDependencyExpression_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_lpszDependencyExpression = *r.out.lpszDependencyExpression;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_Opnum111NotUsedOnWire_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum111NotUsedOnWire_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum111NotUsedOnWire_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct Opnum111NotUsedOnWire *r)
{
	struct tevent_req *req;
	struct dcerpc_Opnum111NotUsedOnWire_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum111NotUsedOnWire_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_OPNUM111NOTUSEDONWIRE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum111NotUsedOnWire_r_done, req);

	return req;
}

static void dcerpc_Opnum111NotUsedOnWire_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum111NotUsedOnWire_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Opnum111NotUsedOnWire_r_state *state =
		tevent_req_data(req,
		struct dcerpc_Opnum111NotUsedOnWire_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum111NotUsedOnWire_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct Opnum111NotUsedOnWire *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_OPNUM111NOTUSEDONWIRE, mem_ctx, r);

	return status;
}

struct dcerpc_Opnum111NotUsedOnWire_state {
	struct Opnum111NotUsedOnWire orig;
	struct Opnum111NotUsedOnWire tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum111NotUsedOnWire_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum111NotUsedOnWire_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h)
{
	struct tevent_req *req;
	struct dcerpc_Opnum111NotUsedOnWire_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum111NotUsedOnWire_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_Opnum111NotUsedOnWire_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum111NotUsedOnWire_done, req);
	return req;
}

static void dcerpc_Opnum111NotUsedOnWire_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_Opnum111NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum111NotUsedOnWire_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_Opnum111NotUsedOnWire_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum111NotUsedOnWire_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_Opnum111NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum111NotUsedOnWire_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum111NotUsedOnWire(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct Opnum111NotUsedOnWire r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_Opnum111NotUsedOnWire_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_GetResourceNetworkName_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetResourceNetworkName_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetResourceNetworkName_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_GetResourceNetworkName *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetResourceNetworkName_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetResourceNetworkName_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETRESOURCENETWORKNAME, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetResourceNetworkName_r_done, req);

	return req;
}

static void dcerpc_clusapi_GetResourceNetworkName_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetResourceNetworkName_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_GetResourceNetworkName_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_GetResourceNetworkName_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetResourceNetworkName_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_GetResourceNetworkName *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETRESOURCENETWORKNAME, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_GetResourceNetworkName_state {
	struct clusapi_GetResourceNetworkName orig;
	struct clusapi_GetResourceNetworkName tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetResourceNetworkName_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetResourceNetworkName_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct dcerpc_binding_handle *h,
							      struct policy_handle _hResource /* [in]  */,
							      const char **_lpszName /* [out] [charset(UTF16),ref] */,
							      WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetResourceNetworkName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetResourceNetworkName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hResource = _hResource;

	/* Out parameters */
	state->orig.out.lpszName = _lpszName;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_GetResourceNetworkName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_GetResourceNetworkName_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetResourceNetworkName_done, req);
	return req;
}

static void dcerpc_clusapi_GetResourceNetworkName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_GetResourceNetworkName_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetResourceNetworkName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_GetResourceNetworkName_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.lpszName = *state->tmp.out.lpszName;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetResourceNetworkName_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    WERROR *result)
{
	struct dcerpc_clusapi_GetResourceNetworkName_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetResourceNetworkName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetResourceNetworkName(struct dcerpc_binding_handle *h,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle _hResource /* [in]  */,
					       const char **_lpszName /* [out] [charset(UTF16),ref] */,
					       WERROR *_rpc_status /* [out] [ref] */,
					       WERROR *result)
{
	struct clusapi_GetResourceNetworkName r;
	NTSTATUS status;

	/* In parameters */
	r.in.hResource = _hResource;

	/* Out parameters */
	r.out.lpszName = _lpszName;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_GetResourceNetworkName_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_lpszName = *r.out.lpszName;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_ExecuteBatch_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_ExecuteBatch_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_ExecuteBatch_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_ExecuteBatch *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_ExecuteBatch_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_ExecuteBatch_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_EXECUTEBATCH, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_ExecuteBatch_r_done, req);

	return req;
}

static void dcerpc_clusapi_ExecuteBatch_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_ExecuteBatch_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_ExecuteBatch_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_ExecuteBatch_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_ExecuteBatch_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_ExecuteBatch *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_EXECUTEBATCH, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_ExecuteBatch_state {
	struct clusapi_ExecuteBatch orig;
	struct clusapi_ExecuteBatch tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_ExecuteBatch_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_ExecuteBatch_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle _hKey /* [in]  */,
						    uint32_t _cbData /* [in]  */,
						    uint8_t *_lpData /* [in] [ref,size_is(cbData)] */,
						    int32_t *_pdwFailedCommand /* [out] [ref] */,
						    WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_ExecuteBatch_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_ExecuteBatch_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hKey = _hKey;
	state->orig.in.cbData = _cbData;
	state->orig.in.lpData = _lpData;

	/* Out parameters */
	state->orig.out.pdwFailedCommand = _pdwFailedCommand;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_ExecuteBatch_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_ExecuteBatch_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_ExecuteBatch_done, req);
	return req;
}

static void dcerpc_clusapi_ExecuteBatch_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_ExecuteBatch_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_ExecuteBatch_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_ExecuteBatch_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pdwFailedCommand = *state->tmp.out.pdwFailedCommand;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_ExecuteBatch_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_clusapi_ExecuteBatch_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_ExecuteBatch_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_ExecuteBatch(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle _hKey /* [in]  */,
				     uint32_t _cbData /* [in]  */,
				     uint8_t *_lpData /* [in] [ref,size_is(cbData)] */,
				     int32_t *_pdwFailedCommand /* [out] [ref] */,
				     WERROR *_rpc_status /* [out] [ref] */,
				     WERROR *result)
{
	struct clusapi_ExecuteBatch r;
	NTSTATUS status;

	/* In parameters */
	r.in.hKey = _hKey;
	r.in.cbData = _cbData;
	r.in.lpData = _lpData;

	/* Out parameters */
	r.out.pdwFailedCommand = _pdwFailedCommand;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_ExecuteBatch_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pdwFailedCommand = *r.out.pdwFailedCommand;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_CreateBatchPort_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateBatchPort_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateBatchPort_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_CreateBatchPort *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateBatchPort_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateBatchPort_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATEBATCHPORT, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateBatchPort_r_done, req);

	return req;
}

static void dcerpc_clusapi_CreateBatchPort_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateBatchPort_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CreateBatchPort_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_CreateBatchPort_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateBatchPort_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_CreateBatchPort *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATEBATCHPORT, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_CreateBatchPort_state {
	struct clusapi_CreateBatchPort orig;
	struct clusapi_CreateBatchPort tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateBatchPort_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateBatchPort_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       struct policy_handle _hKey /* [in]  */,
						       struct policy_handle *_phBatchPort /* [out] [ref] */,
						       WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateBatchPort_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateBatchPort_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hKey = _hKey;

	/* Out parameters */
	state->orig.out.phBatchPort = _phBatchPort;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_CreateBatchPort_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_CreateBatchPort_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateBatchPort_done, req);
	return req;
}

static void dcerpc_clusapi_CreateBatchPort_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_CreateBatchPort_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateBatchPort_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_CreateBatchPort_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.phBatchPort = *state->tmp.out.phBatchPort;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateBatchPort_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct dcerpc_clusapi_CreateBatchPort_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateBatchPort_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateBatchPort(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					struct policy_handle _hKey /* [in]  */,
					struct policy_handle *_phBatchPort /* [out] [ref] */,
					WERROR *_rpc_status /* [out] [ref] */,
					WERROR *result)
{
	struct clusapi_CreateBatchPort r;
	NTSTATUS status;

	/* In parameters */
	r.in.hKey = _hKey;

	/* Out parameters */
	r.out.phBatchPort = _phBatchPort;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_CreateBatchPort_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_phBatchPort = *r.out.phBatchPort;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_GetBatchNotification_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetBatchNotification_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetBatchNotification_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_GetBatchNotification *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetBatchNotification_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetBatchNotification_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETBATCHNOTIFICATION, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetBatchNotification_r_done, req);

	return req;
}

static void dcerpc_clusapi_GetBatchNotification_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetBatchNotification_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_GetBatchNotification_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_GetBatchNotification_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetBatchNotification_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_GetBatchNotification *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETBATCHNOTIFICATION, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_GetBatchNotification_state {
	struct clusapi_GetBatchNotification orig;
	struct clusapi_GetBatchNotification tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetBatchNotification_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetBatchNotification_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct dcerpc_binding_handle *h,
							    struct policy_handle _hBatchNotify /* [in]  */,
							    uint32_t *_cbData /* [out] [ref] */,
							    uint8_t **_lpData /* [out] [ref,size_is(,*cbData)] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetBatchNotification_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetBatchNotification_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hBatchNotify = _hBatchNotify;

	/* Out parameters */
	state->orig.out.cbData = _cbData;
	state->orig.out.lpData = _lpData;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_GetBatchNotification_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_GetBatchNotification_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetBatchNotification_done, req);
	return req;
}

static void dcerpc_clusapi_GetBatchNotification_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_GetBatchNotification_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetBatchNotification_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_GetBatchNotification_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.cbData = *state->tmp.out.cbData;
	*state->orig.out.lpData = *state->tmp.out.lpData;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetBatchNotification_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  WERROR *result)
{
	struct dcerpc_clusapi_GetBatchNotification_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetBatchNotification_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetBatchNotification(struct dcerpc_binding_handle *h,
					     TALLOC_CTX *mem_ctx,
					     struct policy_handle _hBatchNotify /* [in]  */,
					     uint32_t *_cbData /* [out] [ref] */,
					     uint8_t **_lpData /* [out] [ref,size_is(,*cbData)] */,
					     WERROR *result)
{
	struct clusapi_GetBatchNotification r;
	NTSTATUS status;

	/* In parameters */
	r.in.hBatchNotify = _hBatchNotify;

	/* Out parameters */
	r.out.cbData = _cbData;
	r.out.lpData = _lpData;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_GetBatchNotification_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_cbData = *r.out.cbData;
	*_lpData = *r.out.lpData;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_CloseBatchPort_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CloseBatchPort_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CloseBatchPort_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_CloseBatchPort *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CloseBatchPort_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CloseBatchPort_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CLOSEBATCHPORT, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CloseBatchPort_r_done, req);

	return req;
}

static void dcerpc_clusapi_CloseBatchPort_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CloseBatchPort_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CloseBatchPort_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_CloseBatchPort_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CloseBatchPort_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_CloseBatchPort *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CLOSEBATCHPORT, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_CloseBatchPort_state {
	struct clusapi_CloseBatchPort orig;
	struct clusapi_CloseBatchPort tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CloseBatchPort_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CloseBatchPort_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle *_phBatchPort /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CloseBatchPort_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CloseBatchPort_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.phBatchPort = _phBatchPort;

	/* Out parameters */
	state->orig.out.phBatchPort = _phBatchPort;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_CloseBatchPort_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_CloseBatchPort_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CloseBatchPort_done, req);
	return req;
}

static void dcerpc_clusapi_CloseBatchPort_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_CloseBatchPort_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CloseBatchPort_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_CloseBatchPort_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.phBatchPort = *state->tmp.out.phBatchPort;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CloseBatchPort_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_clusapi_CloseBatchPort_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CloseBatchPort_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CloseBatchPort(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *_phBatchPort /* [in,out] [ref] */,
				       WERROR *result)
{
	struct clusapi_CloseBatchPort r;
	NTSTATUS status;

	/* In parameters */
	r.in.phBatchPort = _phBatchPort;

	/* Out parameters */
	r.out.phBatchPort = _phBatchPort;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_CloseBatchPort_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_phBatchPort = *r.out.phBatchPort;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_OpenClusterEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OpenClusterEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OpenClusterEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_OpenClusterEx *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OpenClusterEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OpenClusterEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OPENCLUSTEREX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OpenClusterEx_r_done, req);

	return req;
}

static void dcerpc_clusapi_OpenClusterEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OpenClusterEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OpenClusterEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_OpenClusterEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OpenClusterEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_OpenClusterEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OPENCLUSTEREX, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_OpenClusterEx_state {
	struct clusapi_OpenClusterEx orig;
	struct clusapi_OpenClusterEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OpenClusterEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OpenClusterEx_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     uint32_t _dwDesiredAccess /* [in]  */,
						     uint32_t *_lpdwGrantedAccess /* [out] [ref] */,
						     WERROR *_Status /* [out] [ref] */,
						     struct policy_handle *_hCluster /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OpenClusterEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OpenClusterEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.dwDesiredAccess = _dwDesiredAccess;

	/* Out parameters */
	state->orig.out.lpdwGrantedAccess = _lpdwGrantedAccess;
	state->orig.out.Status = _Status;
	state->orig.out.hCluster = _hCluster;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_OpenClusterEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_OpenClusterEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OpenClusterEx_done, req);
	return req;
}

static void dcerpc_clusapi_OpenClusterEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_OpenClusterEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OpenClusterEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_OpenClusterEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.lpdwGrantedAccess = *state->tmp.out.lpdwGrantedAccess;
	*state->orig.out.Status = *state->tmp.out.Status;
	*state->orig.out.hCluster = *state->tmp.out.hCluster;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OpenClusterEx_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OpenClusterEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OpenClusterEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OpenClusterEx(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      uint32_t _dwDesiredAccess /* [in]  */,
				      uint32_t *_lpdwGrantedAccess /* [out] [ref] */,
				      WERROR *_Status /* [out] [ref] */,
				      struct policy_handle *_hCluster /* [out] [ref] */)
{
	struct clusapi_OpenClusterEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.dwDesiredAccess = _dwDesiredAccess;

	/* Out parameters */
	r.out.lpdwGrantedAccess = _lpdwGrantedAccess;
	r.out.Status = _Status;
	r.out.hCluster = _hCluster;

	status = dcerpc_clusapi_OpenClusterEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_lpdwGrantedAccess = *r.out.lpdwGrantedAccess;
	*_Status = *r.out.Status;
	*_hCluster = *r.out.hCluster;

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_OpenNodeEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OpenNodeEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OpenNodeEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_OpenNodeEx *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OpenNodeEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OpenNodeEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OPENNODEEX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OpenNodeEx_r_done, req);

	return req;
}

static void dcerpc_clusapi_OpenNodeEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OpenNodeEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OpenNodeEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_OpenNodeEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OpenNodeEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_OpenNodeEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OPENNODEEX, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_OpenNodeEx_state {
	struct clusapi_OpenNodeEx orig;
	struct clusapi_OpenNodeEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OpenNodeEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OpenNodeEx_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  const char *_lpszNodeName /* [in] [charset(UTF16),ref] */,
						  uint32_t _dwDesiredAccess /* [in]  */,
						  uint32_t *_lpdwGrantedAccess /* [out] [ref] */,
						  WERROR *_Status /* [out] [ref] */,
						  WERROR *_rpc_status /* [out] [ref] */,
						  struct policy_handle *_hNode /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OpenNodeEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OpenNodeEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.lpszNodeName = _lpszNodeName;
	state->orig.in.dwDesiredAccess = _dwDesiredAccess;

	/* Out parameters */
	state->orig.out.lpdwGrantedAccess = _lpdwGrantedAccess;
	state->orig.out.Status = _Status;
	state->orig.out.rpc_status = _rpc_status;
	state->orig.out.hNode = _hNode;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_OpenNodeEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_OpenNodeEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OpenNodeEx_done, req);
	return req;
}

static void dcerpc_clusapi_OpenNodeEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_OpenNodeEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OpenNodeEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_OpenNodeEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.lpdwGrantedAccess = *state->tmp.out.lpdwGrantedAccess;
	*state->orig.out.Status = *state->tmp.out.Status;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;
	*state->orig.out.hNode = *state->tmp.out.hNode;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OpenNodeEx_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OpenNodeEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OpenNodeEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OpenNodeEx(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   const char *_lpszNodeName /* [in] [charset(UTF16),ref] */,
				   uint32_t _dwDesiredAccess /* [in]  */,
				   uint32_t *_lpdwGrantedAccess /* [out] [ref] */,
				   WERROR *_Status /* [out] [ref] */,
				   WERROR *_rpc_status /* [out] [ref] */,
				   struct policy_handle *_hNode /* [out] [ref] */)
{
	struct clusapi_OpenNodeEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.lpszNodeName = _lpszNodeName;
	r.in.dwDesiredAccess = _dwDesiredAccess;

	/* Out parameters */
	r.out.lpdwGrantedAccess = _lpdwGrantedAccess;
	r.out.Status = _Status;
	r.out.rpc_status = _rpc_status;
	r.out.hNode = _hNode;

	status = dcerpc_clusapi_OpenNodeEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_lpdwGrantedAccess = *r.out.lpdwGrantedAccess;
	*_Status = *r.out.Status;
	*_rpc_status = *r.out.rpc_status;
	*_hNode = *r.out.hNode;

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_OpenGroupEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OpenGroupEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OpenGroupEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_OpenGroupEx *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OpenGroupEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OpenGroupEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OPENGROUPEX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OpenGroupEx_r_done, req);

	return req;
}

static void dcerpc_clusapi_OpenGroupEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OpenGroupEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OpenGroupEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_OpenGroupEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OpenGroupEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_OpenGroupEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OPENGROUPEX, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_OpenGroupEx_state {
	struct clusapi_OpenGroupEx orig;
	struct clusapi_OpenGroupEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OpenGroupEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OpenGroupEx_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   const char *_lpszGroupName /* [in] [charset(UTF16),ref] */,
						   uint32_t _dwDesiredAccess /* [in]  */,
						   uint32_t *_lpdwGrantedAccess /* [out] [ref] */,
						   WERROR *_Status /* [out] [ref] */,
						   WERROR *_rpc_status /* [out] [ref] */,
						   struct policy_handle *_hGroup /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OpenGroupEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OpenGroupEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.lpszGroupName = _lpszGroupName;
	state->orig.in.dwDesiredAccess = _dwDesiredAccess;

	/* Out parameters */
	state->orig.out.lpdwGrantedAccess = _lpdwGrantedAccess;
	state->orig.out.Status = _Status;
	state->orig.out.rpc_status = _rpc_status;
	state->orig.out.hGroup = _hGroup;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_OpenGroupEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_OpenGroupEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OpenGroupEx_done, req);
	return req;
}

static void dcerpc_clusapi_OpenGroupEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_OpenGroupEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OpenGroupEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_OpenGroupEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.lpdwGrantedAccess = *state->tmp.out.lpdwGrantedAccess;
	*state->orig.out.Status = *state->tmp.out.Status;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;
	*state->orig.out.hGroup = *state->tmp.out.hGroup;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OpenGroupEx_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OpenGroupEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OpenGroupEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OpenGroupEx(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    const char *_lpszGroupName /* [in] [charset(UTF16),ref] */,
				    uint32_t _dwDesiredAccess /* [in]  */,
				    uint32_t *_lpdwGrantedAccess /* [out] [ref] */,
				    WERROR *_Status /* [out] [ref] */,
				    WERROR *_rpc_status /* [out] [ref] */,
				    struct policy_handle *_hGroup /* [out] [ref] */)
{
	struct clusapi_OpenGroupEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.lpszGroupName = _lpszGroupName;
	r.in.dwDesiredAccess = _dwDesiredAccess;

	/* Out parameters */
	r.out.lpdwGrantedAccess = _lpdwGrantedAccess;
	r.out.Status = _Status;
	r.out.rpc_status = _rpc_status;
	r.out.hGroup = _hGroup;

	status = dcerpc_clusapi_OpenGroupEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_lpdwGrantedAccess = *r.out.lpdwGrantedAccess;
	*_Status = *r.out.Status;
	*_rpc_status = *r.out.rpc_status;
	*_hGroup = *r.out.hGroup;

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_OpenResourceEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OpenResourceEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OpenResourceEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_OpenResourceEx *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OpenResourceEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OpenResourceEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OPENRESOURCEEX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OpenResourceEx_r_done, req);

	return req;
}

static void dcerpc_clusapi_OpenResourceEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OpenResourceEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OpenResourceEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_OpenResourceEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OpenResourceEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_OpenResourceEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OPENRESOURCEEX, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_OpenResourceEx_state {
	struct clusapi_OpenResourceEx orig;
	struct clusapi_OpenResourceEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OpenResourceEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OpenResourceEx_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      const char *_lpszResourceName /* [in] [charset(UTF16),ref] */,
						      uint32_t _dwDesiredAccess /* [in]  */,
						      uint32_t *_lpdwGrantedAccess /* [out] [ref] */,
						      WERROR *_Status /* [out] [ref] */,
						      WERROR *_rpc_status /* [out] [ref] */,
						      struct policy_handle *_hResource /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OpenResourceEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OpenResourceEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.lpszResourceName = _lpszResourceName;
	state->orig.in.dwDesiredAccess = _dwDesiredAccess;

	/* Out parameters */
	state->orig.out.lpdwGrantedAccess = _lpdwGrantedAccess;
	state->orig.out.Status = _Status;
	state->orig.out.rpc_status = _rpc_status;
	state->orig.out.hResource = _hResource;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_OpenResourceEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_OpenResourceEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OpenResourceEx_done, req);
	return req;
}

static void dcerpc_clusapi_OpenResourceEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_OpenResourceEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OpenResourceEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_OpenResourceEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.lpdwGrantedAccess = *state->tmp.out.lpdwGrantedAccess;
	*state->orig.out.Status = *state->tmp.out.Status;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;
	*state->orig.out.hResource = *state->tmp.out.hResource;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OpenResourceEx_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OpenResourceEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OpenResourceEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OpenResourceEx(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       const char *_lpszResourceName /* [in] [charset(UTF16),ref] */,
				       uint32_t _dwDesiredAccess /* [in]  */,
				       uint32_t *_lpdwGrantedAccess /* [out] [ref] */,
				       WERROR *_Status /* [out] [ref] */,
				       WERROR *_rpc_status /* [out] [ref] */,
				       struct policy_handle *_hResource /* [out] [ref] */)
{
	struct clusapi_OpenResourceEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.lpszResourceName = _lpszResourceName;
	r.in.dwDesiredAccess = _dwDesiredAccess;

	/* Out parameters */
	r.out.lpdwGrantedAccess = _lpdwGrantedAccess;
	r.out.Status = _Status;
	r.out.rpc_status = _rpc_status;
	r.out.hResource = _hResource;

	status = dcerpc_clusapi_OpenResourceEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_lpdwGrantedAccess = *r.out.lpdwGrantedAccess;
	*_Status = *r.out.Status;
	*_rpc_status = *r.out.rpc_status;
	*_hResource = *r.out.hResource;

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_OpenNetworkEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OpenNetworkEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OpenNetworkEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_OpenNetworkEx *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OpenNetworkEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OpenNetworkEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OPENNETWORKEX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OpenNetworkEx_r_done, req);

	return req;
}

static void dcerpc_clusapi_OpenNetworkEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OpenNetworkEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OpenNetworkEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_OpenNetworkEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OpenNetworkEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_OpenNetworkEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OPENNETWORKEX, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_OpenNetworkEx_state {
	struct clusapi_OpenNetworkEx orig;
	struct clusapi_OpenNetworkEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OpenNetworkEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OpenNetworkEx_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     const char *_lpszNetworkName /* [in] [charset(UTF16),ref] */,
						     uint32_t _dwDesiredAccess /* [in]  */,
						     uint32_t *_lpdwGrantedAccess /* [out] [ref] */,
						     WERROR *_Status /* [out] [ref] */,
						     WERROR *_rpc_status /* [out] [ref] */,
						     struct policy_handle *_hNetwork /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OpenNetworkEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OpenNetworkEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.lpszNetworkName = _lpszNetworkName;
	state->orig.in.dwDesiredAccess = _dwDesiredAccess;

	/* Out parameters */
	state->orig.out.lpdwGrantedAccess = _lpdwGrantedAccess;
	state->orig.out.Status = _Status;
	state->orig.out.rpc_status = _rpc_status;
	state->orig.out.hNetwork = _hNetwork;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_OpenNetworkEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_OpenNetworkEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OpenNetworkEx_done, req);
	return req;
}

static void dcerpc_clusapi_OpenNetworkEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_OpenNetworkEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OpenNetworkEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_OpenNetworkEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.lpdwGrantedAccess = *state->tmp.out.lpdwGrantedAccess;
	*state->orig.out.Status = *state->tmp.out.Status;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;
	*state->orig.out.hNetwork = *state->tmp.out.hNetwork;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OpenNetworkEx_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OpenNetworkEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OpenNetworkEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OpenNetworkEx(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      const char *_lpszNetworkName /* [in] [charset(UTF16),ref] */,
				      uint32_t _dwDesiredAccess /* [in]  */,
				      uint32_t *_lpdwGrantedAccess /* [out] [ref] */,
				      WERROR *_Status /* [out] [ref] */,
				      WERROR *_rpc_status /* [out] [ref] */,
				      struct policy_handle *_hNetwork /* [out] [ref] */)
{
	struct clusapi_OpenNetworkEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.lpszNetworkName = _lpszNetworkName;
	r.in.dwDesiredAccess = _dwDesiredAccess;

	/* Out parameters */
	r.out.lpdwGrantedAccess = _lpdwGrantedAccess;
	r.out.Status = _Status;
	r.out.rpc_status = _rpc_status;
	r.out.hNetwork = _hNetwork;

	status = dcerpc_clusapi_OpenNetworkEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_lpdwGrantedAccess = *r.out.lpdwGrantedAccess;
	*_Status = *r.out.Status;
	*_rpc_status = *r.out.rpc_status;
	*_hNetwork = *r.out.hNetwork;

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_OpenNetInterfaceEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OpenNetInterfaceEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OpenNetInterfaceEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_OpenNetInterfaceEx *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OpenNetInterfaceEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OpenNetInterfaceEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OPENNETINTERFACEEX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OpenNetInterfaceEx_r_done, req);

	return req;
}

static void dcerpc_clusapi_OpenNetInterfaceEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OpenNetInterfaceEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OpenNetInterfaceEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_OpenNetInterfaceEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OpenNetInterfaceEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_OpenNetInterfaceEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OPENNETINTERFACEEX, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_OpenNetInterfaceEx_state {
	struct clusapi_OpenNetInterfaceEx orig;
	struct clusapi_OpenNetInterfaceEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OpenNetInterfaceEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OpenNetInterfaceEx_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  const char *_lpszNetInterfaceName /* [in] [charset(UTF16),ref] */,
							  uint32_t _dwDesiredAccess /* [in]  */,
							  uint32_t *_lpdwGrantedAccess /* [out] [ref] */,
							  WERROR *_Status /* [out] [ref] */,
							  WERROR *_rpc_status /* [out] [ref] */,
							  struct policy_handle *_hNetInterface /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OpenNetInterfaceEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OpenNetInterfaceEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.lpszNetInterfaceName = _lpszNetInterfaceName;
	state->orig.in.dwDesiredAccess = _dwDesiredAccess;

	/* Out parameters */
	state->orig.out.lpdwGrantedAccess = _lpdwGrantedAccess;
	state->orig.out.Status = _Status;
	state->orig.out.rpc_status = _rpc_status;
	state->orig.out.hNetInterface = _hNetInterface;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_OpenNetInterfaceEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_OpenNetInterfaceEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OpenNetInterfaceEx_done, req);
	return req;
}

static void dcerpc_clusapi_OpenNetInterfaceEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_OpenNetInterfaceEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OpenNetInterfaceEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_OpenNetInterfaceEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.lpdwGrantedAccess = *state->tmp.out.lpdwGrantedAccess;
	*state->orig.out.Status = *state->tmp.out.Status;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;
	*state->orig.out.hNetInterface = *state->tmp.out.hNetInterface;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OpenNetInterfaceEx_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OpenNetInterfaceEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OpenNetInterfaceEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OpenNetInterfaceEx(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   const char *_lpszNetInterfaceName /* [in] [charset(UTF16),ref] */,
					   uint32_t _dwDesiredAccess /* [in]  */,
					   uint32_t *_lpdwGrantedAccess /* [out] [ref] */,
					   WERROR *_Status /* [out] [ref] */,
					   WERROR *_rpc_status /* [out] [ref] */,
					   struct policy_handle *_hNetInterface /* [out] [ref] */)
{
	struct clusapi_OpenNetInterfaceEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.lpszNetInterfaceName = _lpszNetInterfaceName;
	r.in.dwDesiredAccess = _dwDesiredAccess;

	/* Out parameters */
	r.out.lpdwGrantedAccess = _lpdwGrantedAccess;
	r.out.Status = _Status;
	r.out.rpc_status = _rpc_status;
	r.out.hNetInterface = _hNetInterface;

	status = dcerpc_clusapi_OpenNetInterfaceEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_lpdwGrantedAccess = *r.out.lpdwGrantedAccess;
	*_Status = *r.out.Status;
	*_rpc_status = *r.out.rpc_status;
	*_hNetInterface = *r.out.hNetInterface;

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_ChangeCsvState_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_ChangeCsvState_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_ChangeCsvState_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_ChangeCsvState *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_ChangeCsvState_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_ChangeCsvState_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CHANGECSVSTATE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_ChangeCsvState_r_done, req);

	return req;
}

static void dcerpc_clusapi_ChangeCsvState_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_ChangeCsvState_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_ChangeCsvState_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_ChangeCsvState_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_ChangeCsvState_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_ChangeCsvState *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CHANGECSVSTATE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_ChangeCsvState_state {
	struct clusapi_ChangeCsvState orig;
	struct clusapi_ChangeCsvState tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_ChangeCsvState_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_ChangeCsvState_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle _hResource /* [in]  */,
						      uint32_t _dwState /* [in]  */,
						      WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_ChangeCsvState_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_ChangeCsvState_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hResource = _hResource;
	state->orig.in.dwState = _dwState;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_ChangeCsvState_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_ChangeCsvState_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_ChangeCsvState_done, req);
	return req;
}

static void dcerpc_clusapi_ChangeCsvState_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_ChangeCsvState_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_ChangeCsvState_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_ChangeCsvState_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_ChangeCsvState_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_clusapi_ChangeCsvState_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_ChangeCsvState_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_ChangeCsvState(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle _hResource /* [in]  */,
				       uint32_t _dwState /* [in]  */,
				       WERROR *_rpc_status /* [out] [ref] */,
				       WERROR *result)
{
	struct clusapi_ChangeCsvState r;
	NTSTATUS status;

	/* In parameters */
	r.in.hResource = _hResource;
	r.in.dwState = _dwState;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_ChangeCsvState_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_CreateNodeEnumEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateNodeEnumEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateNodeEnumEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_CreateNodeEnumEx *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateNodeEnumEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateNodeEnumEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATENODEENUMEX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateNodeEnumEx_r_done, req);

	return req;
}

static void dcerpc_clusapi_CreateNodeEnumEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateNodeEnumEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CreateNodeEnumEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_CreateNodeEnumEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateNodeEnumEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_CreateNodeEnumEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATENODEENUMEX, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_CreateNodeEnumEx_state {
	struct clusapi_CreateNodeEnumEx orig;
	struct clusapi_CreateNodeEnumEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateNodeEnumEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateNodeEnumEx_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle _hNode /* [in]  */,
							uint32_t _dwType /* [in]  */,
							uint32_t _dwOptions /* [in]  */,
							struct ENUM_LIST **_ReturnIdEnum /* [out] [ref] */,
							struct ENUM_LIST **_ReturnNameEnum /* [out] [ref] */,
							WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateNodeEnumEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateNodeEnumEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNode = _hNode;
	state->orig.in.dwType = _dwType;
	state->orig.in.dwOptions = _dwOptions;

	/* Out parameters */
	state->orig.out.ReturnIdEnum = _ReturnIdEnum;
	state->orig.out.ReturnNameEnum = _ReturnNameEnum;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_CreateNodeEnumEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_CreateNodeEnumEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateNodeEnumEx_done, req);
	return req;
}

static void dcerpc_clusapi_CreateNodeEnumEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_CreateNodeEnumEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateNodeEnumEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_CreateNodeEnumEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ReturnIdEnum = *state->tmp.out.ReturnIdEnum;
	*state->orig.out.ReturnNameEnum = *state->tmp.out.ReturnNameEnum;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateNodeEnumEx_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_clusapi_CreateNodeEnumEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateNodeEnumEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateNodeEnumEx(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle _hNode /* [in]  */,
					 uint32_t _dwType /* [in]  */,
					 uint32_t _dwOptions /* [in]  */,
					 struct ENUM_LIST **_ReturnIdEnum /* [out] [ref] */,
					 struct ENUM_LIST **_ReturnNameEnum /* [out] [ref] */,
					 WERROR *_rpc_status /* [out] [ref] */,
					 WERROR *result)
{
	struct clusapi_CreateNodeEnumEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNode = _hNode;
	r.in.dwType = _dwType;
	r.in.dwOptions = _dwOptions;

	/* Out parameters */
	r.out.ReturnIdEnum = _ReturnIdEnum;
	r.out.ReturnNameEnum = _ReturnNameEnum;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_CreateNodeEnumEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ReturnIdEnum = *r.out.ReturnIdEnum;
	*_ReturnNameEnum = *r.out.ReturnNameEnum;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_CreateEnumEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateEnumEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateEnumEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_CreateEnumEx *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateEnumEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateEnumEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATEENUMEX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateEnumEx_r_done, req);

	return req;
}

static void dcerpc_clusapi_CreateEnumEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateEnumEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CreateEnumEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_CreateEnumEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateEnumEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_CreateEnumEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATEENUMEX, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_CreateEnumEx_state {
	struct clusapi_CreateEnumEx orig;
	struct clusapi_CreateEnumEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateEnumEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateEnumEx_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle _hCluster /* [in]  */,
						    uint32_t _dwType /* [in]  */,
						    uint32_t _dwOptions /* [in]  */,
						    struct ENUM_LIST **_ReturnIdEnum /* [out] [ref] */,
						    struct ENUM_LIST **_ReturnNameEnum /* [out] [ref] */,
						    WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateEnumEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateEnumEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hCluster = _hCluster;
	state->orig.in.dwType = _dwType;
	state->orig.in.dwOptions = _dwOptions;

	/* Out parameters */
	state->orig.out.ReturnIdEnum = _ReturnIdEnum;
	state->orig.out.ReturnNameEnum = _ReturnNameEnum;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_CreateEnumEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_CreateEnumEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateEnumEx_done, req);
	return req;
}

static void dcerpc_clusapi_CreateEnumEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_CreateEnumEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateEnumEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_CreateEnumEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ReturnIdEnum = *state->tmp.out.ReturnIdEnum;
	*state->orig.out.ReturnNameEnum = *state->tmp.out.ReturnNameEnum;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateEnumEx_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_clusapi_CreateEnumEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateEnumEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateEnumEx(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle _hCluster /* [in]  */,
				     uint32_t _dwType /* [in]  */,
				     uint32_t _dwOptions /* [in]  */,
				     struct ENUM_LIST **_ReturnIdEnum /* [out] [ref] */,
				     struct ENUM_LIST **_ReturnNameEnum /* [out] [ref] */,
				     WERROR *_rpc_status /* [out] [ref] */,
				     WERROR *result)
{
	struct clusapi_CreateEnumEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.hCluster = _hCluster;
	r.in.dwType = _dwType;
	r.in.dwOptions = _dwOptions;

	/* Out parameters */
	r.out.ReturnIdEnum = _ReturnIdEnum;
	r.out.ReturnNameEnum = _ReturnNameEnum;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_CreateEnumEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ReturnIdEnum = *r.out.ReturnIdEnum;
	*_ReturnNameEnum = *r.out.ReturnNameEnum;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_PauseNodeEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_PauseNodeEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_PauseNodeEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_PauseNodeEx *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_PauseNodeEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_PauseNodeEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_PAUSENODEEX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_PauseNodeEx_r_done, req);

	return req;
}

static void dcerpc_clusapi_PauseNodeEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_PauseNodeEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_PauseNodeEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_PauseNodeEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_PauseNodeEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_PauseNodeEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_PAUSENODEEX, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_PauseNodeEx_state {
	struct clusapi_PauseNodeEx orig;
	struct clusapi_PauseNodeEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_PauseNodeEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_PauseNodeEx_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   struct policy_handle _hNode /* [in]  */,
						   uint8_t _bDrainNode /* [in]  */,
						   uint32_t _dwPauseFlags /* [in]  */,
						   WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_PauseNodeEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_PauseNodeEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNode = _hNode;
	state->orig.in.bDrainNode = _bDrainNode;
	state->orig.in.dwPauseFlags = _dwPauseFlags;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_PauseNodeEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_PauseNodeEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_PauseNodeEx_done, req);
	return req;
}

static void dcerpc_clusapi_PauseNodeEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_PauseNodeEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_PauseNodeEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_PauseNodeEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_PauseNodeEx_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result)
{
	struct dcerpc_clusapi_PauseNodeEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_PauseNodeEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_PauseNodeEx(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle _hNode /* [in]  */,
				    uint8_t _bDrainNode /* [in]  */,
				    uint32_t _dwPauseFlags /* [in]  */,
				    WERROR *_rpc_status /* [out] [ref] */,
				    WERROR *result)
{
	struct clusapi_PauseNodeEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNode = _hNode;
	r.in.bDrainNode = _bDrainNode;
	r.in.dwPauseFlags = _dwPauseFlags;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_PauseNodeEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_PauseNodeWithDrainTarget_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_PauseNodeWithDrainTarget_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_PauseNodeWithDrainTarget_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_PauseNodeWithDrainTarget *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_PauseNodeWithDrainTarget_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_PauseNodeWithDrainTarget_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_PAUSENODEWITHDRAINTARGET, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_PauseNodeWithDrainTarget_r_done, req);

	return req;
}

static void dcerpc_clusapi_PauseNodeWithDrainTarget_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_PauseNodeWithDrainTarget_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_PauseNodeWithDrainTarget_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_PauseNodeWithDrainTarget_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_PauseNodeWithDrainTarget_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_PauseNodeWithDrainTarget *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_PAUSENODEWITHDRAINTARGET, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_PauseNodeWithDrainTarget_state {
	struct clusapi_PauseNodeWithDrainTarget orig;
	struct clusapi_PauseNodeWithDrainTarget tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_PauseNodeWithDrainTarget_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_PauseNodeWithDrainTarget_send(TALLOC_CTX *mem_ctx,
								struct tevent_context *ev,
								struct dcerpc_binding_handle *h,
								struct policy_handle _hNode /* [in]  */,
								uint32_t _dwPauseFlags /* [in]  */,
								struct policy_handle _hNodeDrainTarget /* [in]  */,
								WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_PauseNodeWithDrainTarget_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_PauseNodeWithDrainTarget_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNode = _hNode;
	state->orig.in.dwPauseFlags = _dwPauseFlags;
	state->orig.in.hNodeDrainTarget = _hNodeDrainTarget;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_PauseNodeWithDrainTarget_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_PauseNodeWithDrainTarget_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_PauseNodeWithDrainTarget_done, req);
	return req;
}

static void dcerpc_clusapi_PauseNodeWithDrainTarget_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_PauseNodeWithDrainTarget_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_PauseNodeWithDrainTarget_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_PauseNodeWithDrainTarget_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_PauseNodeWithDrainTarget_recv(struct tevent_req *req,
						      TALLOC_CTX *mem_ctx,
						      WERROR *result)
{
	struct dcerpc_clusapi_PauseNodeWithDrainTarget_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_PauseNodeWithDrainTarget_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_PauseNodeWithDrainTarget(struct dcerpc_binding_handle *h,
						 TALLOC_CTX *mem_ctx,
						 struct policy_handle _hNode /* [in]  */,
						 uint32_t _dwPauseFlags /* [in]  */,
						 struct policy_handle _hNodeDrainTarget /* [in]  */,
						 WERROR *_rpc_status /* [out] [ref] */,
						 WERROR *result)
{
	struct clusapi_PauseNodeWithDrainTarget r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNode = _hNode;
	r.in.dwPauseFlags = _dwPauseFlags;
	r.in.hNodeDrainTarget = _hNodeDrainTarget;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_PauseNodeWithDrainTarget_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_ResumeNodeEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_ResumeNodeEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_ResumeNodeEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_ResumeNodeEx *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_ResumeNodeEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_ResumeNodeEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_RESUMENODEEX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_ResumeNodeEx_r_done, req);

	return req;
}

static void dcerpc_clusapi_ResumeNodeEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_ResumeNodeEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_ResumeNodeEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_ResumeNodeEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_ResumeNodeEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_ResumeNodeEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_RESUMENODEEX, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_ResumeNodeEx_state {
	struct clusapi_ResumeNodeEx orig;
	struct clusapi_ResumeNodeEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_ResumeNodeEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_ResumeNodeEx_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle _hNode /* [in]  */,
						    uint32_t _dwResumeFailbackType /* [in]  */,
						    uint32_t _dwResumeFlagsReserved /* [in]  */,
						    WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_ResumeNodeEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_ResumeNodeEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNode = _hNode;
	state->orig.in.dwResumeFailbackType = _dwResumeFailbackType;
	state->orig.in.dwResumeFlagsReserved = _dwResumeFlagsReserved;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_ResumeNodeEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_ResumeNodeEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_ResumeNodeEx_done, req);
	return req;
}

static void dcerpc_clusapi_ResumeNodeEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_ResumeNodeEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_ResumeNodeEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_ResumeNodeEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_ResumeNodeEx_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_clusapi_ResumeNodeEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_ResumeNodeEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_ResumeNodeEx(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle _hNode /* [in]  */,
				     uint32_t _dwResumeFailbackType /* [in]  */,
				     uint32_t _dwResumeFlagsReserved /* [in]  */,
				     WERROR *_rpc_status /* [out] [ref] */,
				     WERROR *result)
{
	struct clusapi_ResumeNodeEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNode = _hNode;
	r.in.dwResumeFailbackType = _dwResumeFailbackType;
	r.in.dwResumeFlagsReserved = _dwResumeFlagsReserved;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_ResumeNodeEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_CreateGroupEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateGroupEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateGroupEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_CreateGroupEx *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateGroupEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateGroupEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATEGROUPEX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateGroupEx_r_done, req);

	return req;
}

static void dcerpc_clusapi_CreateGroupEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateGroupEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CreateGroupEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_CreateGroupEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateGroupEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_CreateGroupEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATEGROUPEX, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_CreateGroupEx_state {
	struct clusapi_CreateGroupEx orig;
	struct clusapi_CreateGroupEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateGroupEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateGroupEx_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     const char *_lpszGroupName /* [in] [charset(UTF16),ref] */,
						     struct CLUSTER_CREATE_GROUP_INFO_RPC *_pGroupInfo /* [in] [unique] */,
						     WERROR *_Status /* [out] [ref] */,
						     WERROR *_rpc_status /* [out] [ref] */,
						     struct policy_handle *_hGroup /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateGroupEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateGroupEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.lpszGroupName = _lpszGroupName;
	state->orig.in.pGroupInfo = _pGroupInfo;

	/* Out parameters */
	state->orig.out.Status = _Status;
	state->orig.out.rpc_status = _rpc_status;
	state->orig.out.hGroup = _hGroup;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_CreateGroupEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_CreateGroupEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateGroupEx_done, req);
	return req;
}

static void dcerpc_clusapi_CreateGroupEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_CreateGroupEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateGroupEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_CreateGroupEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.Status = *state->tmp.out.Status;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;
	*state->orig.out.hGroup = *state->tmp.out.hGroup;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateGroupEx_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CreateGroupEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateGroupEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateGroupEx(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      const char *_lpszGroupName /* [in] [charset(UTF16),ref] */,
				      struct CLUSTER_CREATE_GROUP_INFO_RPC *_pGroupInfo /* [in] [unique] */,
				      WERROR *_Status /* [out] [ref] */,
				      WERROR *_rpc_status /* [out] [ref] */,
				      struct policy_handle *_hGroup /* [out] [ref] */)
{
	struct clusapi_CreateGroupEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.lpszGroupName = _lpszGroupName;
	r.in.pGroupInfo = _pGroupInfo;

	/* Out parameters */
	r.out.Status = _Status;
	r.out.rpc_status = _rpc_status;
	r.out.hGroup = _hGroup;

	status = dcerpc_clusapi_CreateGroupEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_Status = *r.out.Status;
	*_rpc_status = *r.out.rpc_status;
	*_hGroup = *r.out.hGroup;

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_OnlineGroupEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OnlineGroupEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OnlineGroupEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_OnlineGroupEx *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OnlineGroupEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OnlineGroupEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ONLINEGROUPEX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OnlineGroupEx_r_done, req);

	return req;
}

static void dcerpc_clusapi_OnlineGroupEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OnlineGroupEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OnlineGroupEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_OnlineGroupEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OnlineGroupEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_OnlineGroupEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ONLINEGROUPEX, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_OnlineGroupEx_state {
	struct clusapi_OnlineGroupEx orig;
	struct clusapi_OnlineGroupEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OnlineGroupEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OnlineGroupEx_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle _hGroup /* [in]  */,
						     uint32_t _dwOnlineFlags /* [in]  */,
						     uint8_t *_lpInBuffer /* [in] [ref,size_is(cbInBufferSize)] */,
						     uint32_t _cbInBufferSize /* [in]  */,
						     WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OnlineGroupEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OnlineGroupEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hGroup = _hGroup;
	state->orig.in.dwOnlineFlags = _dwOnlineFlags;
	state->orig.in.lpInBuffer = _lpInBuffer;
	state->orig.in.cbInBufferSize = _cbInBufferSize;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_OnlineGroupEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_OnlineGroupEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OnlineGroupEx_done, req);
	return req;
}

static void dcerpc_clusapi_OnlineGroupEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_OnlineGroupEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OnlineGroupEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_OnlineGroupEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OnlineGroupEx_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_clusapi_OnlineGroupEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OnlineGroupEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OnlineGroupEx(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle _hGroup /* [in]  */,
				      uint32_t _dwOnlineFlags /* [in]  */,
				      uint8_t *_lpInBuffer /* [in] [ref,size_is(cbInBufferSize)] */,
				      uint32_t _cbInBufferSize /* [in]  */,
				      WERROR *_rpc_status /* [out] [ref] */,
				      WERROR *result)
{
	struct clusapi_OnlineGroupEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.hGroup = _hGroup;
	r.in.dwOnlineFlags = _dwOnlineFlags;
	r.in.lpInBuffer = _lpInBuffer;
	r.in.cbInBufferSize = _cbInBufferSize;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_OnlineGroupEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_OfflineGroupEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OfflineGroupEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OfflineGroupEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_OfflineGroupEx *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OfflineGroupEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OfflineGroupEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OFFLINEGROUPEX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OfflineGroupEx_r_done, req);

	return req;
}

static void dcerpc_clusapi_OfflineGroupEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OfflineGroupEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OfflineGroupEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_OfflineGroupEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OfflineGroupEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_OfflineGroupEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OFFLINEGROUPEX, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_OfflineGroupEx_state {
	struct clusapi_OfflineGroupEx orig;
	struct clusapi_OfflineGroupEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OfflineGroupEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OfflineGroupEx_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle _hGroup /* [in]  */,
						      uint32_t _dwOfflineFlags /* [in]  */,
						      uint8_t *_lpInBuffer /* [in] [ref,size_is(cbInBufferSize)] */,
						      uint32_t _cbInBufferSize /* [in]  */,
						      WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OfflineGroupEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OfflineGroupEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hGroup = _hGroup;
	state->orig.in.dwOfflineFlags = _dwOfflineFlags;
	state->orig.in.lpInBuffer = _lpInBuffer;
	state->orig.in.cbInBufferSize = _cbInBufferSize;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_OfflineGroupEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_OfflineGroupEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OfflineGroupEx_done, req);
	return req;
}

static void dcerpc_clusapi_OfflineGroupEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_OfflineGroupEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OfflineGroupEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_OfflineGroupEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OfflineGroupEx_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_clusapi_OfflineGroupEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OfflineGroupEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OfflineGroupEx(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle _hGroup /* [in]  */,
				       uint32_t _dwOfflineFlags /* [in]  */,
				       uint8_t *_lpInBuffer /* [in] [ref,size_is(cbInBufferSize)] */,
				       uint32_t _cbInBufferSize /* [in]  */,
				       WERROR *_rpc_status /* [out] [ref] */,
				       WERROR *result)
{
	struct clusapi_OfflineGroupEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.hGroup = _hGroup;
	r.in.dwOfflineFlags = _dwOfflineFlags;
	r.in.lpInBuffer = _lpInBuffer;
	r.in.cbInBufferSize = _cbInBufferSize;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_OfflineGroupEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_MoveGroupEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_MoveGroupEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_MoveGroupEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_MoveGroupEx *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_MoveGroupEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_MoveGroupEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_MOVEGROUPEX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_MoveGroupEx_r_done, req);

	return req;
}

static void dcerpc_clusapi_MoveGroupEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_MoveGroupEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_MoveGroupEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_MoveGroupEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_MoveGroupEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_MoveGroupEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_MOVEGROUPEX, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_MoveGroupEx_state {
	struct clusapi_MoveGroupEx orig;
	struct clusapi_MoveGroupEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_MoveGroupEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_MoveGroupEx_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   struct policy_handle _hGroup /* [in]  */,
						   uint32_t _dwMoveFlags /* [in]  */,
						   uint8_t *_lpInBuffer /* [in] [ref,size_is(cbInBufferSize)] */,
						   uint32_t _cbInBufferSize /* [in]  */,
						   WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_MoveGroupEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_MoveGroupEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hGroup = _hGroup;
	state->orig.in.dwMoveFlags = _dwMoveFlags;
	state->orig.in.lpInBuffer = _lpInBuffer;
	state->orig.in.cbInBufferSize = _cbInBufferSize;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_MoveGroupEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_MoveGroupEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_MoveGroupEx_done, req);
	return req;
}

static void dcerpc_clusapi_MoveGroupEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_MoveGroupEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_MoveGroupEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_MoveGroupEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_MoveGroupEx_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result)
{
	struct dcerpc_clusapi_MoveGroupEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_MoveGroupEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_MoveGroupEx(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle _hGroup /* [in]  */,
				    uint32_t _dwMoveFlags /* [in]  */,
				    uint8_t *_lpInBuffer /* [in] [ref,size_is(cbInBufferSize)] */,
				    uint32_t _cbInBufferSize /* [in]  */,
				    WERROR *_rpc_status /* [out] [ref] */,
				    WERROR *result)
{
	struct clusapi_MoveGroupEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.hGroup = _hGroup;
	r.in.dwMoveFlags = _dwMoveFlags;
	r.in.lpInBuffer = _lpInBuffer;
	r.in.cbInBufferSize = _cbInBufferSize;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_MoveGroupEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_MoveGroupToNodeEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_MoveGroupToNodeEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_MoveGroupToNodeEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_MoveGroupToNodeEx *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_MoveGroupToNodeEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_MoveGroupToNodeEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_MOVEGROUPTONODEEX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_MoveGroupToNodeEx_r_done, req);

	return req;
}

static void dcerpc_clusapi_MoveGroupToNodeEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_MoveGroupToNodeEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_MoveGroupToNodeEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_MoveGroupToNodeEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_MoveGroupToNodeEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_MoveGroupToNodeEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_MOVEGROUPTONODEEX, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_MoveGroupToNodeEx_state {
	struct clusapi_MoveGroupToNodeEx orig;
	struct clusapi_MoveGroupToNodeEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_MoveGroupToNodeEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_MoveGroupToNodeEx_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct policy_handle _hGroup /* [in]  */,
							 struct policy_handle _hNode /* [in]  */,
							 uint32_t _dwMoveFlags /* [in]  */,
							 uint8_t *_lpInBuffer /* [in] [ref,size_is(cbInBufferSize)] */,
							 uint32_t _cbInBufferSize /* [in]  */,
							 WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_MoveGroupToNodeEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_MoveGroupToNodeEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hGroup = _hGroup;
	state->orig.in.hNode = _hNode;
	state->orig.in.dwMoveFlags = _dwMoveFlags;
	state->orig.in.lpInBuffer = _lpInBuffer;
	state->orig.in.cbInBufferSize = _cbInBufferSize;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_MoveGroupToNodeEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_MoveGroupToNodeEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_MoveGroupToNodeEx_done, req);
	return req;
}

static void dcerpc_clusapi_MoveGroupToNodeEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_MoveGroupToNodeEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_MoveGroupToNodeEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_MoveGroupToNodeEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_MoveGroupToNodeEx_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_clusapi_MoveGroupToNodeEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_MoveGroupToNodeEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_MoveGroupToNodeEx(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle _hGroup /* [in]  */,
					  struct policy_handle _hNode /* [in]  */,
					  uint32_t _dwMoveFlags /* [in]  */,
					  uint8_t *_lpInBuffer /* [in] [ref,size_is(cbInBufferSize)] */,
					  uint32_t _cbInBufferSize /* [in]  */,
					  WERROR *_rpc_status /* [out] [ref] */,
					  WERROR *result)
{
	struct clusapi_MoveGroupToNodeEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.hGroup = _hGroup;
	r.in.hNode = _hNode;
	r.in.dwMoveFlags = _dwMoveFlags;
	r.in.lpInBuffer = _lpInBuffer;
	r.in.cbInBufferSize = _cbInBufferSize;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_MoveGroupToNodeEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_CancelClusterGroupOperation_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CancelClusterGroupOperation_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CancelClusterGroupOperation_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_CancelClusterGroupOperation *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CancelClusterGroupOperation_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CancelClusterGroupOperation_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CANCELCLUSTERGROUPOPERATION, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CancelClusterGroupOperation_r_done, req);

	return req;
}

static void dcerpc_clusapi_CancelClusterGroupOperation_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CancelClusterGroupOperation_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CancelClusterGroupOperation_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_CancelClusterGroupOperation_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CancelClusterGroupOperation_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_CancelClusterGroupOperation *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CANCELCLUSTERGROUPOPERATION, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_CancelClusterGroupOperation_state {
	struct clusapi_CancelClusterGroupOperation orig;
	struct clusapi_CancelClusterGroupOperation tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CancelClusterGroupOperation_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CancelClusterGroupOperation_send(TALLOC_CTX *mem_ctx,
								   struct tevent_context *ev,
								   struct dcerpc_binding_handle *h,
								   struct policy_handle _hGroup /* [in]  */,
								   uint32_t _dwCancelFlags /* [in]  */,
								   WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CancelClusterGroupOperation_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CancelClusterGroupOperation_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hGroup = _hGroup;
	state->orig.in.dwCancelFlags = _dwCancelFlags;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_CancelClusterGroupOperation_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_CancelClusterGroupOperation_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CancelClusterGroupOperation_done, req);
	return req;
}

static void dcerpc_clusapi_CancelClusterGroupOperation_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_CancelClusterGroupOperation_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CancelClusterGroupOperation_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_CancelClusterGroupOperation_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CancelClusterGroupOperation_recv(struct tevent_req *req,
							 TALLOC_CTX *mem_ctx,
							 WERROR *result)
{
	struct dcerpc_clusapi_CancelClusterGroupOperation_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CancelClusterGroupOperation_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CancelClusterGroupOperation(struct dcerpc_binding_handle *h,
						    TALLOC_CTX *mem_ctx,
						    struct policy_handle _hGroup /* [in]  */,
						    uint32_t _dwCancelFlags /* [in]  */,
						    WERROR *_rpc_status /* [out] [ref] */,
						    WERROR *result)
{
	struct clusapi_CancelClusterGroupOperation r;
	NTSTATUS status;

	/* In parameters */
	r.in.hGroup = _hGroup;
	r.in.dwCancelFlags = _dwCancelFlags;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_CancelClusterGroupOperation_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_OnlineResourceEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OnlineResourceEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OnlineResourceEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_OnlineResourceEx *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OnlineResourceEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OnlineResourceEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ONLINERESOURCEEX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OnlineResourceEx_r_done, req);

	return req;
}

static void dcerpc_clusapi_OnlineResourceEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OnlineResourceEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OnlineResourceEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_OnlineResourceEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OnlineResourceEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_OnlineResourceEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ONLINERESOURCEEX, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_OnlineResourceEx_state {
	struct clusapi_OnlineResourceEx orig;
	struct clusapi_OnlineResourceEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OnlineResourceEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OnlineResourceEx_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle _hResource /* [in]  */,
							uint32_t _dwOnlineFlags /* [in]  */,
							uint8_t *_lpInBuffer /* [in] [ref,size_is(cbInBufferSize)] */,
							uint32_t _cbInBufferSize /* [in]  */,
							WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OnlineResourceEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OnlineResourceEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hResource = _hResource;
	state->orig.in.dwOnlineFlags = _dwOnlineFlags;
	state->orig.in.lpInBuffer = _lpInBuffer;
	state->orig.in.cbInBufferSize = _cbInBufferSize;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_OnlineResourceEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_OnlineResourceEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OnlineResourceEx_done, req);
	return req;
}

static void dcerpc_clusapi_OnlineResourceEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_OnlineResourceEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OnlineResourceEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_OnlineResourceEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OnlineResourceEx_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_clusapi_OnlineResourceEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OnlineResourceEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OnlineResourceEx(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle _hResource /* [in]  */,
					 uint32_t _dwOnlineFlags /* [in]  */,
					 uint8_t *_lpInBuffer /* [in] [ref,size_is(cbInBufferSize)] */,
					 uint32_t _cbInBufferSize /* [in]  */,
					 WERROR *_rpc_status /* [out] [ref] */,
					 WERROR *result)
{
	struct clusapi_OnlineResourceEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.hResource = _hResource;
	r.in.dwOnlineFlags = _dwOnlineFlags;
	r.in.lpInBuffer = _lpInBuffer;
	r.in.cbInBufferSize = _cbInBufferSize;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_OnlineResourceEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_OfflineResourceEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OfflineResourceEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OfflineResourceEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_OfflineResourceEx *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OfflineResourceEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OfflineResourceEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OFFLINERESOURCEEX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OfflineResourceEx_r_done, req);

	return req;
}

static void dcerpc_clusapi_OfflineResourceEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OfflineResourceEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_OfflineResourceEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_OfflineResourceEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OfflineResourceEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_OfflineResourceEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_OFFLINERESOURCEEX, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_OfflineResourceEx_state {
	struct clusapi_OfflineResourceEx orig;
	struct clusapi_OfflineResourceEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_OfflineResourceEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_OfflineResourceEx_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct policy_handle _hResource /* [in]  */,
							 uint32_t _dwOfflineFlags /* [in]  */,
							 uint8_t *_lpInBuffer /* [in] [ref,size_is(cbInBufferSize)] */,
							 uint32_t _cbInBufferSize /* [in]  */,
							 WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_OfflineResourceEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_OfflineResourceEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hResource = _hResource;
	state->orig.in.dwOfflineFlags = _dwOfflineFlags;
	state->orig.in.lpInBuffer = _lpInBuffer;
	state->orig.in.cbInBufferSize = _cbInBufferSize;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_OfflineResourceEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_OfflineResourceEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_OfflineResourceEx_done, req);
	return req;
}

static void dcerpc_clusapi_OfflineResourceEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_OfflineResourceEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OfflineResourceEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_OfflineResourceEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_OfflineResourceEx_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_clusapi_OfflineResourceEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_OfflineResourceEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_OfflineResourceEx(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle _hResource /* [in]  */,
					  uint32_t _dwOfflineFlags /* [in]  */,
					  uint8_t *_lpInBuffer /* [in] [ref,size_is(cbInBufferSize)] */,
					  uint32_t _cbInBufferSize /* [in]  */,
					  WERROR *_rpc_status /* [out] [ref] */,
					  WERROR *result)
{
	struct clusapi_OfflineResourceEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.hResource = _hResource;
	r.in.dwOfflineFlags = _dwOfflineFlags;
	r.in.lpInBuffer = _lpInBuffer;
	r.in.cbInBufferSize = _cbInBufferSize;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_OfflineResourceEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_CreateNotifyV2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateNotifyV2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateNotifyV2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_CreateNotifyV2 *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateNotifyV2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateNotifyV2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATENOTIFYV2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateNotifyV2_r_done, req);

	return req;
}

static void dcerpc_clusapi_CreateNotifyV2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateNotifyV2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CreateNotifyV2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_CreateNotifyV2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateNotifyV2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_CreateNotifyV2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATENOTIFYV2, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_CreateNotifyV2_state {
	struct clusapi_CreateNotifyV2 orig;
	struct clusapi_CreateNotifyV2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateNotifyV2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateNotifyV2_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      WERROR *_rpc_error /* [out] [ref] */,
						      WERROR *_rpc_status /* [out] [ref] */,
						      struct policy_handle *_hNotify /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateNotifyV2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateNotifyV2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */
	state->orig.out.rpc_error = _rpc_error;
	state->orig.out.rpc_status = _rpc_status;
	state->orig.out.hNotify = _hNotify;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_CreateNotifyV2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_CreateNotifyV2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateNotifyV2_done, req);
	return req;
}

static void dcerpc_clusapi_CreateNotifyV2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_CreateNotifyV2_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateNotifyV2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_CreateNotifyV2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_error = *state->tmp.out.rpc_error;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;
	*state->orig.out.hNotify = *state->tmp.out.hNotify;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateNotifyV2_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CreateNotifyV2_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateNotifyV2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateNotifyV2(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       WERROR *_rpc_error /* [out] [ref] */,
				       WERROR *_rpc_status /* [out] [ref] */,
				       struct policy_handle *_hNotify /* [out] [ref] */)
{
	struct clusapi_CreateNotifyV2 r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */
	r.out.rpc_error = _rpc_error;
	r.out.rpc_status = _rpc_status;
	r.out.hNotify = _hNotify;

	status = dcerpc_clusapi_CreateNotifyV2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_error = *r.out.rpc_error;
	*_rpc_status = *r.out.rpc_status;
	*_hNotify = *r.out.hNotify;

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_AddNotifyV2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_AddNotifyV2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_AddNotifyV2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_AddNotifyV2 *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_AddNotifyV2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_AddNotifyV2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ADDNOTIFYV2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_AddNotifyV2_r_done, req);

	return req;
}

static void dcerpc_clusapi_AddNotifyV2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_AddNotifyV2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_AddNotifyV2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_AddNotifyV2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_AddNotifyV2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_AddNotifyV2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ADDNOTIFYV2, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_AddNotifyV2_state {
	struct clusapi_AddNotifyV2 orig;
	struct clusapi_AddNotifyV2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_AddNotifyV2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_AddNotifyV2_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   struct policy_handle _hNotify /* [in]  */,
						   struct policy_handle _hObject /* [in]  */,
						   struct NOTIFY_FILTER_AND_TYPE_RPC _filter /* [in]  */,
						   uint32_t _dwNotifyKey /* [in]  */,
						   uint32_t _dwVersion /* [in]  */,
						   uint8_t _isTargetedAtObject /* [in]  */,
						   WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_AddNotifyV2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_AddNotifyV2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNotify = _hNotify;
	state->orig.in.hObject = _hObject;
	state->orig.in.filter = _filter;
	state->orig.in.dwNotifyKey = _dwNotifyKey;
	state->orig.in.dwVersion = _dwVersion;
	state->orig.in.isTargetedAtObject = _isTargetedAtObject;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_AddNotifyV2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_AddNotifyV2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_AddNotifyV2_done, req);
	return req;
}

static void dcerpc_clusapi_AddNotifyV2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_AddNotifyV2_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_AddNotifyV2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_AddNotifyV2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_AddNotifyV2_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result)
{
	struct dcerpc_clusapi_AddNotifyV2_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_AddNotifyV2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_AddNotifyV2(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle _hNotify /* [in]  */,
				    struct policy_handle _hObject /* [in]  */,
				    struct NOTIFY_FILTER_AND_TYPE_RPC _filter /* [in]  */,
				    uint32_t _dwNotifyKey /* [in]  */,
				    uint32_t _dwVersion /* [in]  */,
				    uint8_t _isTargetedAtObject /* [in]  */,
				    WERROR *_rpc_status /* [out] [ref] */,
				    WERROR *result)
{
	struct clusapi_AddNotifyV2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNotify = _hNotify;
	r.in.hObject = _hObject;
	r.in.filter = _filter;
	r.in.dwNotifyKey = _dwNotifyKey;
	r.in.dwVersion = _dwVersion;
	r.in.isTargetedAtObject = _isTargetedAtObject;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_AddNotifyV2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_GetNotifyV2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetNotifyV2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetNotifyV2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_GetNotifyV2 *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetNotifyV2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetNotifyV2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETNOTIFYV2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetNotifyV2_r_done, req);

	return req;
}

static void dcerpc_clusapi_GetNotifyV2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetNotifyV2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_GetNotifyV2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_GetNotifyV2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetNotifyV2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_GetNotifyV2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETNOTIFYV2, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_GetNotifyV2_state {
	struct clusapi_GetNotifyV2 orig;
	struct clusapi_GetNotifyV2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetNotifyV2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetNotifyV2_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   struct policy_handle _hNotify /* [in]  */,
						   struct NOTIFICATION_RPC **_Notifications /* [out] [ref,size_is(,*dwNumNotifications)] */,
						   uint32_t *_dwNumNotifications /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetNotifyV2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetNotifyV2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNotify = _hNotify;

	/* Out parameters */
	state->orig.out.Notifications = _Notifications;
	state->orig.out.dwNumNotifications = _dwNumNotifications;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_GetNotifyV2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_GetNotifyV2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetNotifyV2_done, req);
	return req;
}

static void dcerpc_clusapi_GetNotifyV2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_GetNotifyV2_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetNotifyV2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_GetNotifyV2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.Notifications = *state->tmp.out.Notifications;
	*state->orig.out.dwNumNotifications = *state->tmp.out.dwNumNotifications;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetNotifyV2_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result)
{
	struct dcerpc_clusapi_GetNotifyV2_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetNotifyV2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetNotifyV2(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle _hNotify /* [in]  */,
				    struct NOTIFICATION_RPC **_Notifications /* [out] [ref,size_is(,*dwNumNotifications)] */,
				    uint32_t *_dwNumNotifications /* [out] [ref] */,
				    WERROR *result)
{
	struct clusapi_GetNotifyV2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNotify = _hNotify;

	/* Out parameters */
	r.out.Notifications = _Notifications;
	r.out.dwNumNotifications = _dwNumNotifications;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_GetNotifyV2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_Notifications = *r.out.Notifications;
	*_dwNumNotifications = *r.out.dwNumNotifications;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_QueryAllValues_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_QueryAllValues_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_QueryAllValues_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_QueryAllValues *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_QueryAllValues_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_QueryAllValues_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_QUERYALLVALUES, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_QueryAllValues_r_done, req);

	return req;
}

static void dcerpc_clusapi_QueryAllValues_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_QueryAllValues_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_QueryAllValues_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_QueryAllValues_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_QueryAllValues_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_QueryAllValues *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_QUERYALLVALUES, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_QueryAllValues_state {
	struct clusapi_QueryAllValues orig;
	struct clusapi_QueryAllValues tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_QueryAllValues_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_QueryAllValues_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle _hKey /* [in]  */,
						      uint32_t *_pcbData /* [out] [ref] */,
						      uint8_t **_ppData /* [out] [ref,size_is(1,*pcbData)] */,
						      WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_QueryAllValues_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_QueryAllValues_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hKey = _hKey;

	/* Out parameters */
	state->orig.out.pcbData = _pcbData;
	state->orig.out.ppData = _ppData;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_QueryAllValues_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_QueryAllValues_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_QueryAllValues_done, req);
	return req;
}

static void dcerpc_clusapi_QueryAllValues_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_QueryAllValues_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_QueryAllValues_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_QueryAllValues_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pcbData = *state->tmp.out.pcbData;
	{
		size_t _copy_len_ppData;
		_copy_len_ppData = 1;
		if (state->orig.out.ppData != state->tmp.out.ppData) {
			memcpy(state->orig.out.ppData, state->tmp.out.ppData, _copy_len_ppData * sizeof(*state->orig.out.ppData));
		}
	}
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_QueryAllValues_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_clusapi_QueryAllValues_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_QueryAllValues_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_QueryAllValues(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle _hKey /* [in]  */,
				       uint32_t *_pcbData /* [out] [ref] */,
				       uint8_t **_ppData /* [out] [ref,size_is(1,*pcbData)] */,
				       WERROR *_rpc_status /* [out] [ref] */,
				       WERROR *result)
{
	struct clusapi_QueryAllValues r;
	NTSTATUS status;

	/* In parameters */
	r.in.hKey = _hKey;

	/* Out parameters */
	r.out.pcbData = _pcbData;
	r.out.ppData = _ppData;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_QueryAllValues_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pcbData = *r.out.pcbData;
	{
		size_t _copy_len_ppData;
		_copy_len_ppData = 1;
		if (_ppData != r.out.ppData) {
			memcpy(_ppData, r.out.ppData, _copy_len_ppData * sizeof(*_ppData));
		}
	}
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_StmFindDisk_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_StmFindDisk_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_StmFindDisk_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_StmFindDisk *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_StmFindDisk_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_StmFindDisk_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_STMFINDDISK, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_StmFindDisk_r_done, req);

	return req;
}

static void dcerpc_clusapi_StmFindDisk_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_StmFindDisk_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_StmFindDisk_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_StmFindDisk_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_StmFindDisk_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_StmFindDisk *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_STMFINDDISK, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_StmFindDisk_state {
	struct clusapi_StmFindDisk orig;
	struct clusapi_StmFindDisk tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_StmFindDisk_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_StmFindDisk_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   struct policy_handle _hCluster /* [in]  */,
						   uint32_t _dwFlags /* [in]  */,
						   struct CLUSTER_DISKID *_pDiskId /* [in,out] [unique] */,
						   uint8_t *_pUniqueId /* [in] [size_is(uniqueIdSize),unique] */,
						   uint32_t _uniqueIdSize /* [in]  */,
						   const char **_ppszDeviceName /* [out] [charset(UTF16),ref] */,
						   WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_StmFindDisk_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_StmFindDisk_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hCluster = _hCluster;
	state->orig.in.dwFlags = _dwFlags;
	state->orig.in.pDiskId = _pDiskId;
	state->orig.in.pUniqueId = _pUniqueId;
	state->orig.in.uniqueIdSize = _uniqueIdSize;

	/* Out parameters */
	state->orig.out.pDiskId = _pDiskId;
	state->orig.out.ppszDeviceName = _ppszDeviceName;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_StmFindDisk_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_StmFindDisk_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_StmFindDisk_done, req);
	return req;
}

static void dcerpc_clusapi_StmFindDisk_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_StmFindDisk_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_StmFindDisk_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_StmFindDisk_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.pDiskId && state->tmp.out.pDiskId) {
		*state->orig.out.pDiskId = *state->tmp.out.pDiskId;
	}
	*state->orig.out.ppszDeviceName = *state->tmp.out.ppszDeviceName;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_StmFindDisk_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result)
{
	struct dcerpc_clusapi_StmFindDisk_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_StmFindDisk_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_StmFindDisk(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle _hCluster /* [in]  */,
				    uint32_t _dwFlags /* [in]  */,
				    struct CLUSTER_DISKID *_pDiskId /* [in,out] [unique] */,
				    uint8_t *_pUniqueId /* [in] [size_is(uniqueIdSize),unique] */,
				    uint32_t _uniqueIdSize /* [in]  */,
				    const char **_ppszDeviceName /* [out] [charset(UTF16),ref] */,
				    WERROR *_rpc_status /* [out] [ref] */,
				    WERROR *result)
{
	struct clusapi_StmFindDisk r;
	NTSTATUS status;

	/* In parameters */
	r.in.hCluster = _hCluster;
	r.in.dwFlags = _dwFlags;
	r.in.pDiskId = _pDiskId;
	r.in.pUniqueId = _pUniqueId;
	r.in.uniqueIdSize = _uniqueIdSize;

	/* Out parameters */
	r.out.pDiskId = _pDiskId;
	r.out.ppszDeviceName = _ppszDeviceName;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_StmFindDisk_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_pDiskId && r.out.pDiskId) {
		*_pDiskId = *r.out.pDiskId;
	}
	*_ppszDeviceName = *r.out.ppszDeviceName;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_ClusterMrr_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_ClusterMrr_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_ClusterMrr_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_ClusterMrr *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_ClusterMrr_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_ClusterMrr_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CLUSTERMRR, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_ClusterMrr_r_done, req);

	return req;
}

static void dcerpc_clusapi_ClusterMrr_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_ClusterMrr_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_ClusterMrr_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_ClusterMrr_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_ClusterMrr_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_ClusterMrr *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CLUSTERMRR, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_ClusterMrr_state {
	struct clusapi_ClusterMrr orig;
	struct clusapi_ClusterMrr tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_ClusterMrr_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_ClusterMrr_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  struct policy_handle _hCluster /* [in]  */,
						  uint8_t _fExcludeSelf /* [in]  */,
						  uint64_t _nodeSet /* [in]  */,
						  uint32_t _dwTimeout /* [in]  */,
						  uint32_t _dwComponent /* [in]  */,
						  uint32_t _dwControlCode /* [in]  */,
						  uint32_t _inSize /* [in]  */,
						  uint8_t *_pInData /* [in] [size_is(inSize),unique] */,
						  struct CLUSTER_MRR_RESPONSE **_ppInfo /* [out] [ref,size_is(1,1)] */,
						  WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_ClusterMrr_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_ClusterMrr_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hCluster = _hCluster;
	state->orig.in.fExcludeSelf = _fExcludeSelf;
	state->orig.in.nodeSet = _nodeSet;
	state->orig.in.dwTimeout = _dwTimeout;
	state->orig.in.dwComponent = _dwComponent;
	state->orig.in.dwControlCode = _dwControlCode;
	state->orig.in.inSize = _inSize;
	state->orig.in.pInData = _pInData;

	/* Out parameters */
	state->orig.out.ppInfo = _ppInfo;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_ClusterMrr_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_ClusterMrr_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_ClusterMrr_done, req);
	return req;
}

static void dcerpc_clusapi_ClusterMrr_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_ClusterMrr_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_ClusterMrr_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_ClusterMrr_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_ppInfo;
		_copy_len_ppInfo = 1;
		if (state->orig.out.ppInfo != state->tmp.out.ppInfo) {
			memcpy(state->orig.out.ppInfo, state->tmp.out.ppInfo, _copy_len_ppInfo * sizeof(*state->orig.out.ppInfo));
		}
	}
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_ClusterMrr_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct dcerpc_clusapi_ClusterMrr_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_ClusterMrr_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_ClusterMrr(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle _hCluster /* [in]  */,
				   uint8_t _fExcludeSelf /* [in]  */,
				   uint64_t _nodeSet /* [in]  */,
				   uint32_t _dwTimeout /* [in]  */,
				   uint32_t _dwComponent /* [in]  */,
				   uint32_t _dwControlCode /* [in]  */,
				   uint32_t _inSize /* [in]  */,
				   uint8_t *_pInData /* [in] [size_is(inSize),unique] */,
				   struct CLUSTER_MRR_RESPONSE **_ppInfo /* [out] [ref,size_is(1,1)] */,
				   WERROR *_rpc_status /* [out] [ref] */,
				   WERROR *result)
{
	struct clusapi_ClusterMrr r;
	NTSTATUS status;

	/* In parameters */
	r.in.hCluster = _hCluster;
	r.in.fExcludeSelf = _fExcludeSelf;
	r.in.nodeSet = _nodeSet;
	r.in.dwTimeout = _dwTimeout;
	r.in.dwComponent = _dwComponent;
	r.in.dwControlCode = _dwControlCode;
	r.in.inSize = _inSize;
	r.in.pInData = _pInData;

	/* Out parameters */
	r.out.ppInfo = _ppInfo;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_ClusterMrr_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_ppInfo;
		_copy_len_ppInfo = 1;
		if (_ppInfo != r.out.ppInfo) {
			memcpy(_ppInfo, r.out.ppInfo, _copy_len_ppInfo * sizeof(*_ppInfo));
		}
	}
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_CreateGroupEnum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateGroupEnum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateGroupEnum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_CreateGroupEnum *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateGroupEnum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateGroupEnum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATEGROUPENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateGroupEnum_r_done, req);

	return req;
}

static void dcerpc_clusapi_CreateGroupEnum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateGroupEnum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CreateGroupEnum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_CreateGroupEnum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateGroupEnum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_CreateGroupEnum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATEGROUPENUM, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_CreateGroupEnum_state {
	struct clusapi_CreateGroupEnum orig;
	struct clusapi_CreateGroupEnum tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateGroupEnum_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateGroupEnum_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       struct policy_handle _hCluster /* [in]  */,
						       uint8_t *_pProperties /* [in] [size_is(cbProperties),unique] */,
						       uint32_t _cbProperties /* [in]  */,
						       uint8_t *_pRoProperties /* [in] [size_is(cbRoProperties),unique] */,
						       uint32_t _cbRoProperties /* [in]  */,
						       struct GROUP_ENUM_LIST **_ppResultList /* [out] [ref] */,
						       WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateGroupEnum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateGroupEnum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hCluster = _hCluster;
	state->orig.in.pProperties = _pProperties;
	state->orig.in.cbProperties = _cbProperties;
	state->orig.in.pRoProperties = _pRoProperties;
	state->orig.in.cbRoProperties = _cbRoProperties;

	/* Out parameters */
	state->orig.out.ppResultList = _ppResultList;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_CreateGroupEnum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_CreateGroupEnum_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateGroupEnum_done, req);
	return req;
}

static void dcerpc_clusapi_CreateGroupEnum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_CreateGroupEnum_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateGroupEnum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_CreateGroupEnum_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ppResultList = *state->tmp.out.ppResultList;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateGroupEnum_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct dcerpc_clusapi_CreateGroupEnum_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateGroupEnum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateGroupEnum(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					struct policy_handle _hCluster /* [in]  */,
					uint8_t *_pProperties /* [in] [size_is(cbProperties),unique] */,
					uint32_t _cbProperties /* [in]  */,
					uint8_t *_pRoProperties /* [in] [size_is(cbRoProperties),unique] */,
					uint32_t _cbRoProperties /* [in]  */,
					struct GROUP_ENUM_LIST **_ppResultList /* [out] [ref] */,
					WERROR *_rpc_status /* [out] [ref] */,
					WERROR *result)
{
	struct clusapi_CreateGroupEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.hCluster = _hCluster;
	r.in.pProperties = _pProperties;
	r.in.cbProperties = _cbProperties;
	r.in.pRoProperties = _pRoProperties;
	r.in.cbRoProperties = _cbRoProperties;

	/* Out parameters */
	r.out.ppResultList = _ppResultList;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_CreateGroupEnum_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ppResultList = *r.out.ppResultList;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_CreateResourceEnum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateResourceEnum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateResourceEnum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_CreateResourceEnum *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateResourceEnum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateResourceEnum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATERESOURCEENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateResourceEnum_r_done, req);

	return req;
}

static void dcerpc_clusapi_CreateResourceEnum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateResourceEnum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_CreateResourceEnum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_CreateResourceEnum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateResourceEnum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_CreateResourceEnum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATERESOURCEENUM, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_CreateResourceEnum_state {
	struct clusapi_CreateResourceEnum orig;
	struct clusapi_CreateResourceEnum tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateResourceEnum_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateResourceEnum_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle _hCluster /* [in]  */,
							  uint8_t *_pProperties /* [in] [size_is(cbProperties),unique] */,
							  uint32_t _cbProperties /* [in]  */,
							  uint8_t *_pRoProperties /* [in] [size_is(cbRoProperties),unique] */,
							  uint32_t _cbRoProperties /* [in]  */,
							  struct RESOURCE_ENUM_LIST **_ppResultList /* [out] [ref] */,
							  WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateResourceEnum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateResourceEnum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hCluster = _hCluster;
	state->orig.in.pProperties = _pProperties;
	state->orig.in.cbProperties = _cbProperties;
	state->orig.in.pRoProperties = _pRoProperties;
	state->orig.in.cbRoProperties = _cbRoProperties;

	/* Out parameters */
	state->orig.out.ppResultList = _ppResultList;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_CreateResourceEnum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_CreateResourceEnum_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_CreateResourceEnum_done, req);
	return req;
}

static void dcerpc_clusapi_CreateResourceEnum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_CreateResourceEnum_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateResourceEnum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_CreateResourceEnum_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ppResultList = *state->tmp.out.ppResultList;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_CreateResourceEnum_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_clusapi_CreateResourceEnum_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_CreateResourceEnum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_CreateResourceEnum(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle _hCluster /* [in]  */,
					   uint8_t *_pProperties /* [in] [size_is(cbProperties),unique] */,
					   uint32_t _cbProperties /* [in]  */,
					   uint8_t *_pRoProperties /* [in] [size_is(cbRoProperties),unique] */,
					   uint32_t _cbRoProperties /* [in]  */,
					   struct RESOURCE_ENUM_LIST **_ppResultList /* [out] [ref] */,
					   WERROR *_rpc_status /* [out] [ref] */,
					   WERROR *result)
{
	struct clusapi_CreateResourceEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.hCluster = _hCluster;
	r.in.pProperties = _pProperties;
	r.in.cbProperties = _cbProperties;
	r.in.pRoProperties = _pRoProperties;
	r.in.cbRoProperties = _cbRoProperties;

	/* Out parameters */
	r.out.ppResultList = _ppResultList;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_CreateResourceEnum_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ppResultList = *r.out.ppResultList;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_ExecuteReadBatch_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_ExecuteReadBatch_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_ExecuteReadBatch_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_ExecuteReadBatch *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_ExecuteReadBatch_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_ExecuteReadBatch_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_EXECUTEREADBATCH, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_ExecuteReadBatch_r_done, req);

	return req;
}

static void dcerpc_clusapi_ExecuteReadBatch_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_ExecuteReadBatch_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_ExecuteReadBatch_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_ExecuteReadBatch_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_ExecuteReadBatch_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_ExecuteReadBatch *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_EXECUTEREADBATCH, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_ExecuteReadBatch_state {
	struct clusapi_ExecuteReadBatch orig;
	struct clusapi_ExecuteReadBatch tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_ExecuteReadBatch_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_ExecuteReadBatch_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle _hKey /* [in]  */,
							uint32_t _cbInData /* [in]  */,
							uint8_t *_lpInData /* [in] [ref,size_is(cbInData)] */,
							uint32_t *_cbOutData /* [out] [ref] */,
							uint8_t **_lpOutData /* [out] [ref,size_is(,*cbOutData)] */,
							WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_ExecuteReadBatch_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_ExecuteReadBatch_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hKey = _hKey;
	state->orig.in.cbInData = _cbInData;
	state->orig.in.lpInData = _lpInData;

	/* Out parameters */
	state->orig.out.cbOutData = _cbOutData;
	state->orig.out.lpOutData = _lpOutData;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_ExecuteReadBatch_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_ExecuteReadBatch_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_ExecuteReadBatch_done, req);
	return req;
}

static void dcerpc_clusapi_ExecuteReadBatch_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_ExecuteReadBatch_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_ExecuteReadBatch_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_ExecuteReadBatch_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.cbOutData = *state->tmp.out.cbOutData;
	*state->orig.out.lpOutData = *state->tmp.out.lpOutData;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_ExecuteReadBatch_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_clusapi_ExecuteReadBatch_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_ExecuteReadBatch_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_ExecuteReadBatch(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle _hKey /* [in]  */,
					 uint32_t _cbInData /* [in]  */,
					 uint8_t *_lpInData /* [in] [ref,size_is(cbInData)] */,
					 uint32_t *_cbOutData /* [out] [ref] */,
					 uint8_t **_lpOutData /* [out] [ref,size_is(,*cbOutData)] */,
					 WERROR *_rpc_status /* [out] [ref] */,
					 WERROR *result)
{
	struct clusapi_ExecuteReadBatch r;
	NTSTATUS status;

	/* In parameters */
	r.in.hKey = _hKey;
	r.in.cbInData = _cbInData;
	r.in.lpInData = _lpInData;

	/* Out parameters */
	r.out.cbOutData = _cbOutData;
	r.out.lpOutData = _lpOutData;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_ExecuteReadBatch_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_cbOutData = *r.out.cbOutData;
	*_lpOutData = *r.out.lpOutData;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_RestartResource_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_RestartResource_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_RestartResource_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_RestartResource *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_RestartResource_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_RestartResource_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_RESTARTRESOURCE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_RestartResource_r_done, req);

	return req;
}

static void dcerpc_clusapi_RestartResource_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_RestartResource_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_RestartResource_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_RestartResource_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_RestartResource_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_RestartResource *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_RESTARTRESOURCE, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_RestartResource_state {
	struct clusapi_RestartResource orig;
	struct clusapi_RestartResource tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_RestartResource_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_RestartResource_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       struct policy_handle _hResource /* [in]  */,
						       uint32_t _dwFlags /* [in]  */,
						       WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_RestartResource_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_RestartResource_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hResource = _hResource;
	state->orig.in.dwFlags = _dwFlags;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_RestartResource_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_RestartResource_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_RestartResource_done, req);
	return req;
}

static void dcerpc_clusapi_RestartResource_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_RestartResource_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_RestartResource_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_RestartResource_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_RestartResource_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct dcerpc_clusapi_RestartResource_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_RestartResource_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_RestartResource(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					struct policy_handle _hResource /* [in]  */,
					uint32_t _dwFlags /* [in]  */,
					WERROR *_rpc_status /* [out] [ref] */,
					WERROR *result)
{
	struct clusapi_RestartResource r;
	NTSTATUS status;

	/* In parameters */
	r.in.hResource = _hResource;
	r.in.dwFlags = _dwFlags;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_RestartResource_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_GetNotifyAsync_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetNotifyAsync_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetNotifyAsync_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_GetNotifyAsync *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetNotifyAsync_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetNotifyAsync_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETNOTIFYASYNC, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetNotifyAsync_r_done, req);

	return req;
}

static void dcerpc_clusapi_GetNotifyAsync_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetNotifyAsync_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_GetNotifyAsync_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_GetNotifyAsync_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetNotifyAsync_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_GetNotifyAsync *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_GETNOTIFYASYNC, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_GetNotifyAsync_state {
	struct clusapi_GetNotifyAsync orig;
	struct clusapi_GetNotifyAsync tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_GetNotifyAsync_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_GetNotifyAsync_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle _hNotify /* [in]  */,
						      struct NOTIFICATION_DATA_ASYNC_RPC **_Notifications /* [out] [ref,size_is(,*dwNumNotifications)] */,
						      uint32_t *_dwNumNotifications /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_GetNotifyAsync_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_GetNotifyAsync_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNotify = _hNotify;

	/* Out parameters */
	state->orig.out.Notifications = _Notifications;
	state->orig.out.dwNumNotifications = _dwNumNotifications;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_GetNotifyAsync_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_GetNotifyAsync_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_GetNotifyAsync_done, req);
	return req;
}

static void dcerpc_clusapi_GetNotifyAsync_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_GetNotifyAsync_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetNotifyAsync_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_GetNotifyAsync_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.Notifications = *state->tmp.out.Notifications;
	*state->orig.out.dwNumNotifications = *state->tmp.out.dwNumNotifications;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_GetNotifyAsync_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_clusapi_GetNotifyAsync_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_GetNotifyAsync_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_GetNotifyAsync(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle _hNotify /* [in]  */,
				       struct NOTIFICATION_DATA_ASYNC_RPC **_Notifications /* [out] [ref,size_is(,*dwNumNotifications)] */,
				       uint32_t *_dwNumNotifications /* [out] [ref] */,
				       WERROR *result)
{
	struct clusapi_GetNotifyAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNotify = _hNotify;

	/* Out parameters */
	r.out.Notifications = _Notifications;
	r.out.dwNumNotifications = _dwNumNotifications;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_GetNotifyAsync_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_Notifications = *r.out.Notifications;
	*_dwNumNotifications = *r.out.dwNumNotifications;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_Opnum148NotUsedOnWire_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum148NotUsedOnWire_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum148NotUsedOnWire_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct Opnum148NotUsedOnWire *r)
{
	struct tevent_req *req;
	struct dcerpc_Opnum148NotUsedOnWire_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum148NotUsedOnWire_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_OPNUM148NOTUSEDONWIRE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum148NotUsedOnWire_r_done, req);

	return req;
}

static void dcerpc_Opnum148NotUsedOnWire_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum148NotUsedOnWire_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Opnum148NotUsedOnWire_r_state *state =
		tevent_req_data(req,
		struct dcerpc_Opnum148NotUsedOnWire_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum148NotUsedOnWire_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct Opnum148NotUsedOnWire *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_OPNUM148NOTUSEDONWIRE, mem_ctx, r);

	return status;
}

struct dcerpc_Opnum148NotUsedOnWire_state {
	struct Opnum148NotUsedOnWire orig;
	struct Opnum148NotUsedOnWire tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum148NotUsedOnWire_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum148NotUsedOnWire_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h)
{
	struct tevent_req *req;
	struct dcerpc_Opnum148NotUsedOnWire_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum148NotUsedOnWire_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_Opnum148NotUsedOnWire_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum148NotUsedOnWire_done, req);
	return req;
}

static void dcerpc_Opnum148NotUsedOnWire_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_Opnum148NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum148NotUsedOnWire_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_Opnum148NotUsedOnWire_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum148NotUsedOnWire_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_Opnum148NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum148NotUsedOnWire_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum148NotUsedOnWire(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct Opnum148NotUsedOnWire r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_Opnum148NotUsedOnWire_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_Opnum149otUsedOnWire_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum149otUsedOnWire_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum149otUsedOnWire_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct Opnum149otUsedOnWire *r)
{
	struct tevent_req *req;
	struct dcerpc_Opnum149otUsedOnWire_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum149otUsedOnWire_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_OPNUM149OTUSEDONWIRE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum149otUsedOnWire_r_done, req);

	return req;
}

static void dcerpc_Opnum149otUsedOnWire_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum149otUsedOnWire_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Opnum149otUsedOnWire_r_state *state =
		tevent_req_data(req,
		struct dcerpc_Opnum149otUsedOnWire_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum149otUsedOnWire_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct Opnum149otUsedOnWire *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_OPNUM149OTUSEDONWIRE, mem_ctx, r);

	return status;
}

struct dcerpc_Opnum149otUsedOnWire_state {
	struct Opnum149otUsedOnWire orig;
	struct Opnum149otUsedOnWire tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum149otUsedOnWire_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum149otUsedOnWire_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h)
{
	struct tevent_req *req;
	struct dcerpc_Opnum149otUsedOnWire_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum149otUsedOnWire_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_Opnum149otUsedOnWire_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum149otUsedOnWire_done, req);
	return req;
}

static void dcerpc_Opnum149otUsedOnWire_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_Opnum149otUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum149otUsedOnWire_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_Opnum149otUsedOnWire_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum149otUsedOnWire_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_Opnum149otUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum149otUsedOnWire_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum149otUsedOnWire(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct Opnum149otUsedOnWire r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_Opnum149otUsedOnWire_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_Opnum150NotUsedOnWire_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum150NotUsedOnWire_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum150NotUsedOnWire_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct Opnum150NotUsedOnWire *r)
{
	struct tevent_req *req;
	struct dcerpc_Opnum150NotUsedOnWire_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum150NotUsedOnWire_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_OPNUM150NOTUSEDONWIRE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum150NotUsedOnWire_r_done, req);

	return req;
}

static void dcerpc_Opnum150NotUsedOnWire_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum150NotUsedOnWire_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Opnum150NotUsedOnWire_r_state *state =
		tevent_req_data(req,
		struct dcerpc_Opnum150NotUsedOnWire_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum150NotUsedOnWire_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct Opnum150NotUsedOnWire *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_OPNUM150NOTUSEDONWIRE, mem_ctx, r);

	return status;
}

struct dcerpc_Opnum150NotUsedOnWire_state {
	struct Opnum150NotUsedOnWire orig;
	struct Opnum150NotUsedOnWire tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum150NotUsedOnWire_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum150NotUsedOnWire_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h)
{
	struct tevent_req *req;
	struct dcerpc_Opnum150NotUsedOnWire_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum150NotUsedOnWire_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_Opnum150NotUsedOnWire_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum150NotUsedOnWire_done, req);
	return req;
}

static void dcerpc_Opnum150NotUsedOnWire_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_Opnum150NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum150NotUsedOnWire_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_Opnum150NotUsedOnWire_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum150NotUsedOnWire_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_Opnum150NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum150NotUsedOnWire_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum150NotUsedOnWire(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct Opnum150NotUsedOnWire r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_Opnum150NotUsedOnWire_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_Opnum151NotUsedOnWire_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum151NotUsedOnWire_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum151NotUsedOnWire_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct Opnum151NotUsedOnWire *r)
{
	struct tevent_req *req;
	struct dcerpc_Opnum151NotUsedOnWire_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum151NotUsedOnWire_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_OPNUM151NOTUSEDONWIRE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum151NotUsedOnWire_r_done, req);

	return req;
}

static void dcerpc_Opnum151NotUsedOnWire_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum151NotUsedOnWire_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Opnum151NotUsedOnWire_r_state *state =
		tevent_req_data(req,
		struct dcerpc_Opnum151NotUsedOnWire_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum151NotUsedOnWire_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct Opnum151NotUsedOnWire *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_OPNUM151NOTUSEDONWIRE, mem_ctx, r);

	return status;
}

struct dcerpc_Opnum151NotUsedOnWire_state {
	struct Opnum151NotUsedOnWire orig;
	struct Opnum151NotUsedOnWire tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum151NotUsedOnWire_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum151NotUsedOnWire_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h)
{
	struct tevent_req *req;
	struct dcerpc_Opnum151NotUsedOnWire_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum151NotUsedOnWire_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_Opnum151NotUsedOnWire_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum151NotUsedOnWire_done, req);
	return req;
}

static void dcerpc_Opnum151NotUsedOnWire_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_Opnum151NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum151NotUsedOnWire_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_Opnum151NotUsedOnWire_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum151NotUsedOnWire_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_Opnum151NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum151NotUsedOnWire_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum151NotUsedOnWire(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct Opnum151NotUsedOnWire r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_Opnum151NotUsedOnWire_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_Opnum152NotUsedOnWire_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum152NotUsedOnWire_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum152NotUsedOnWire_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct Opnum152NotUsedOnWire *r)
{
	struct tevent_req *req;
	struct dcerpc_Opnum152NotUsedOnWire_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum152NotUsedOnWire_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_OPNUM152NOTUSEDONWIRE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum152NotUsedOnWire_r_done, req);

	return req;
}

static void dcerpc_Opnum152NotUsedOnWire_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum152NotUsedOnWire_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Opnum152NotUsedOnWire_r_state *state =
		tevent_req_data(req,
		struct dcerpc_Opnum152NotUsedOnWire_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum152NotUsedOnWire_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct Opnum152NotUsedOnWire *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_OPNUM152NOTUSEDONWIRE, mem_ctx, r);

	return status;
}

struct dcerpc_Opnum152NotUsedOnWire_state {
	struct Opnum152NotUsedOnWire orig;
	struct Opnum152NotUsedOnWire tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum152NotUsedOnWire_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum152NotUsedOnWire_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h)
{
	struct tevent_req *req;
	struct dcerpc_Opnum152NotUsedOnWire_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum152NotUsedOnWire_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_Opnum152NotUsedOnWire_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum152NotUsedOnWire_done, req);
	return req;
}

static void dcerpc_Opnum152NotUsedOnWire_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_Opnum152NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum152NotUsedOnWire_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_Opnum152NotUsedOnWire_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum152NotUsedOnWire_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_Opnum152NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum152NotUsedOnWire_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum152NotUsedOnWire(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct Opnum152NotUsedOnWire r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_Opnum152NotUsedOnWire_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_Opnum153NotUsedOnWire_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum153NotUsedOnWire_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum153NotUsedOnWire_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct Opnum153NotUsedOnWire *r)
{
	struct tevent_req *req;
	struct dcerpc_Opnum153NotUsedOnWire_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum153NotUsedOnWire_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_OPNUM153NOTUSEDONWIRE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum153NotUsedOnWire_r_done, req);

	return req;
}

static void dcerpc_Opnum153NotUsedOnWire_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum153NotUsedOnWire_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Opnum153NotUsedOnWire_r_state *state =
		tevent_req_data(req,
		struct dcerpc_Opnum153NotUsedOnWire_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum153NotUsedOnWire_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct Opnum153NotUsedOnWire *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_OPNUM153NOTUSEDONWIRE, mem_ctx, r);

	return status;
}

struct dcerpc_Opnum153NotUsedOnWire_state {
	struct Opnum153NotUsedOnWire orig;
	struct Opnum153NotUsedOnWire tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum153NotUsedOnWire_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum153NotUsedOnWire_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h)
{
	struct tevent_req *req;
	struct dcerpc_Opnum153NotUsedOnWire_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum153NotUsedOnWire_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_Opnum153NotUsedOnWire_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum153NotUsedOnWire_done, req);
	return req;
}

static void dcerpc_Opnum153NotUsedOnWire_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_Opnum153NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum153NotUsedOnWire_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_Opnum153NotUsedOnWire_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum153NotUsedOnWire_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_Opnum153NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum153NotUsedOnWire_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum153NotUsedOnWire(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct Opnum153NotUsedOnWire r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_Opnum153NotUsedOnWire_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_Opnum154NotUsedOnWire_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum154NotUsedOnWire_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum154NotUsedOnWire_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct Opnum154NotUsedOnWire *r)
{
	struct tevent_req *req;
	struct dcerpc_Opnum154NotUsedOnWire_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum154NotUsedOnWire_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_OPNUM154NOTUSEDONWIRE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum154NotUsedOnWire_r_done, req);

	return req;
}

static void dcerpc_Opnum154NotUsedOnWire_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum154NotUsedOnWire_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Opnum154NotUsedOnWire_r_state *state =
		tevent_req_data(req,
		struct dcerpc_Opnum154NotUsedOnWire_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum154NotUsedOnWire_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct Opnum154NotUsedOnWire *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_OPNUM154NOTUSEDONWIRE, mem_ctx, r);

	return status;
}

struct dcerpc_Opnum154NotUsedOnWire_state {
	struct Opnum154NotUsedOnWire orig;
	struct Opnum154NotUsedOnWire tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum154NotUsedOnWire_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum154NotUsedOnWire_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h)
{
	struct tevent_req *req;
	struct dcerpc_Opnum154NotUsedOnWire_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum154NotUsedOnWire_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_Opnum154NotUsedOnWire_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum154NotUsedOnWire_done, req);
	return req;
}

static void dcerpc_Opnum154NotUsedOnWire_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_Opnum154NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum154NotUsedOnWire_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_Opnum154NotUsedOnWire_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum154NotUsedOnWire_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_Opnum154NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum154NotUsedOnWire_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum154NotUsedOnWire(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct Opnum154NotUsedOnWire r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_Opnum154NotUsedOnWire_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_AddNotifyResourceTypeV2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_AddNotifyResourceTypeV2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_AddNotifyResourceTypeV2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_AddNotifyResourceTypeV2 *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_AddNotifyResourceTypeV2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_AddNotifyResourceTypeV2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ADDNOTIFYRESOURCETYPEV2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_AddNotifyResourceTypeV2_r_done, req);

	return req;
}

static void dcerpc_clusapi_AddNotifyResourceTypeV2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_AddNotifyResourceTypeV2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_AddNotifyResourceTypeV2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_AddNotifyResourceTypeV2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_AddNotifyResourceTypeV2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_AddNotifyResourceTypeV2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_ADDNOTIFYRESOURCETYPEV2, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_AddNotifyResourceTypeV2_state {
	struct clusapi_AddNotifyResourceTypeV2 orig;
	struct clusapi_AddNotifyResourceTypeV2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_AddNotifyResourceTypeV2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_AddNotifyResourceTypeV2_send(TALLOC_CTX *mem_ctx,
							       struct tevent_context *ev,
							       struct dcerpc_binding_handle *h,
							       struct policy_handle _hNotify /* [in]  */,
							       uint64_t _filter /* [in]  */,
							       uint32_t _dwNotifyKey /* [in]  */,
							       const char *_resTypeName /* [in] [charset(UTF16),ref] */,
							       uint32_t _dwVersion /* [in]  */,
							       WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_AddNotifyResourceTypeV2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_AddNotifyResourceTypeV2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNotify = _hNotify;
	state->orig.in.filter = _filter;
	state->orig.in.dwNotifyKey = _dwNotifyKey;
	state->orig.in.resTypeName = _resTypeName;
	state->orig.in.dwVersion = _dwVersion;

	/* Out parameters */
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_AddNotifyResourceTypeV2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_AddNotifyResourceTypeV2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_AddNotifyResourceTypeV2_done, req);
	return req;
}

static void dcerpc_clusapi_AddNotifyResourceTypeV2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_AddNotifyResourceTypeV2_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_AddNotifyResourceTypeV2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_AddNotifyResourceTypeV2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_AddNotifyResourceTypeV2_recv(struct tevent_req *req,
						     TALLOC_CTX *mem_ctx,
						     WERROR *result)
{
	struct dcerpc_clusapi_AddNotifyResourceTypeV2_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_AddNotifyResourceTypeV2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_AddNotifyResourceTypeV2(struct dcerpc_binding_handle *h,
						TALLOC_CTX *mem_ctx,
						struct policy_handle _hNotify /* [in]  */,
						uint64_t _filter /* [in]  */,
						uint32_t _dwNotifyKey /* [in]  */,
						const char *_resTypeName /* [in] [charset(UTF16),ref] */,
						uint32_t _dwVersion /* [in]  */,
						WERROR *_rpc_status /* [out] [ref] */,
						WERROR *result)
{
	struct clusapi_AddNotifyResourceTypeV2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNotify = _hNotify;
	r.in.filter = _filter;
	r.in.dwNotifyKey = _dwNotifyKey;
	r.in.resTypeName = _resTypeName;
	r.in.dwVersion = _dwVersion;

	/* Out parameters */
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_AddNotifyResourceTypeV2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_Opnum156NotUsedOnWire_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum156NotUsedOnWire_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum156NotUsedOnWire_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct Opnum156NotUsedOnWire *r)
{
	struct tevent_req *req;
	struct dcerpc_Opnum156NotUsedOnWire_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum156NotUsedOnWire_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_OPNUM156NOTUSEDONWIRE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum156NotUsedOnWire_r_done, req);

	return req;
}

static void dcerpc_Opnum156NotUsedOnWire_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum156NotUsedOnWire_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Opnum156NotUsedOnWire_r_state *state =
		tevent_req_data(req,
		struct dcerpc_Opnum156NotUsedOnWire_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum156NotUsedOnWire_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct Opnum156NotUsedOnWire *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_OPNUM156NOTUSEDONWIRE, mem_ctx, r);

	return status;
}

struct dcerpc_Opnum156NotUsedOnWire_state {
	struct Opnum156NotUsedOnWire orig;
	struct Opnum156NotUsedOnWire tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum156NotUsedOnWire_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum156NotUsedOnWire_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h)
{
	struct tevent_req *req;
	struct dcerpc_Opnum156NotUsedOnWire_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum156NotUsedOnWire_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_Opnum156NotUsedOnWire_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum156NotUsedOnWire_done, req);
	return req;
}

static void dcerpc_Opnum156NotUsedOnWire_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_Opnum156NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum156NotUsedOnWire_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_Opnum156NotUsedOnWire_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum156NotUsedOnWire_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_Opnum156NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum156NotUsedOnWire_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum156NotUsedOnWire(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct Opnum156NotUsedOnWire r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_Opnum156NotUsedOnWire_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_ExecuteReadBatchEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_ExecuteReadBatchEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_ExecuteReadBatchEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_ExecuteReadBatchEx *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_ExecuteReadBatchEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_ExecuteReadBatchEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_EXECUTEREADBATCHEX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_ExecuteReadBatchEx_r_done, req);

	return req;
}

static void dcerpc_clusapi_ExecuteReadBatchEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_ExecuteReadBatchEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_clusapi_ExecuteReadBatchEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_clusapi_ExecuteReadBatchEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_ExecuteReadBatchEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct clusapi_ExecuteReadBatchEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_EXECUTEREADBATCHEX, mem_ctx, r);

	return status;
}

struct dcerpc_clusapi_ExecuteReadBatchEx_state {
	struct clusapi_ExecuteReadBatchEx orig;
	struct clusapi_ExecuteReadBatchEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_ExecuteReadBatchEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_ExecuteReadBatchEx_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle _hKey /* [in]  */,
							  uint32_t _cbInData /* [in]  */,
							  uint8_t *_lpInData /* [in] [ref,size_is(cbInData)] */,
							  uint32_t _flags /* [in]  */,
							  uint32_t *_cbOutData /* [out] [ref] */,
							  uint8_t **_lpOutData /* [out] [ref,size_is(,*cbOutData)] */,
							  WERROR *_rpc_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_ExecuteReadBatchEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_ExecuteReadBatchEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hKey = _hKey;
	state->orig.in.cbInData = _cbInData;
	state->orig.in.lpInData = _lpInData;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.cbOutData = _cbOutData;
	state->orig.out.lpOutData = _lpOutData;
	state->orig.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_clusapi_ExecuteReadBatchEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_clusapi_ExecuteReadBatchEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_clusapi_ExecuteReadBatchEx_done, req);
	return req;
}

static void dcerpc_clusapi_ExecuteReadBatchEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_clusapi_ExecuteReadBatchEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_ExecuteReadBatchEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_clusapi_ExecuteReadBatchEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.cbOutData = *state->tmp.out.cbOutData;
	*state->orig.out.lpOutData = *state->tmp.out.lpOutData;
	*state->orig.out.rpc_status = *state->tmp.out.rpc_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_clusapi_ExecuteReadBatchEx_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_clusapi_ExecuteReadBatchEx_state *state = tevent_req_data(
		req, struct dcerpc_clusapi_ExecuteReadBatchEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_clusapi_ExecuteReadBatchEx(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle _hKey /* [in]  */,
					   uint32_t _cbInData /* [in]  */,
					   uint8_t *_lpInData /* [in] [ref,size_is(cbInData)] */,
					   uint32_t _flags /* [in]  */,
					   uint32_t *_cbOutData /* [out] [ref] */,
					   uint8_t **_lpOutData /* [out] [ref,size_is(,*cbOutData)] */,
					   WERROR *_rpc_status /* [out] [ref] */,
					   WERROR *result)
{
	struct clusapi_ExecuteReadBatchEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.hKey = _hKey;
	r.in.cbInData = _cbInData;
	r.in.lpInData = _lpInData;
	r.in.flags = _flags;

	/* Out parameters */
	r.out.cbOutData = _cbOutData;
	r.out.lpOutData = _lpOutData;
	r.out.rpc_status = _rpc_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_clusapi_ExecuteReadBatchEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_cbOutData = *r.out.cbOutData;
	*_lpOutData = *r.out.lpOutData;
	*_rpc_status = *r.out.rpc_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_Opnum158NotUsedOnWire_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum158NotUsedOnWire_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum158NotUsedOnWire_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct Opnum158NotUsedOnWire *r)
{
	struct tevent_req *req;
	struct dcerpc_Opnum158NotUsedOnWire_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum158NotUsedOnWire_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_OPNUM158NOTUSEDONWIRE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum158NotUsedOnWire_r_done, req);

	return req;
}

static void dcerpc_Opnum158NotUsedOnWire_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum158NotUsedOnWire_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Opnum158NotUsedOnWire_r_state *state =
		tevent_req_data(req,
		struct dcerpc_Opnum158NotUsedOnWire_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum158NotUsedOnWire_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct Opnum158NotUsedOnWire *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_OPNUM158NOTUSEDONWIRE, mem_ctx, r);

	return status;
}

struct dcerpc_Opnum158NotUsedOnWire_state {
	struct Opnum158NotUsedOnWire orig;
	struct Opnum158NotUsedOnWire tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum158NotUsedOnWire_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum158NotUsedOnWire_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h)
{
	struct tevent_req *req;
	struct dcerpc_Opnum158NotUsedOnWire_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum158NotUsedOnWire_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_Opnum158NotUsedOnWire_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum158NotUsedOnWire_done, req);
	return req;
}

static void dcerpc_Opnum158NotUsedOnWire_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_Opnum158NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum158NotUsedOnWire_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_Opnum158NotUsedOnWire_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum158NotUsedOnWire_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_Opnum158NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum158NotUsedOnWire_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum158NotUsedOnWire(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct Opnum158NotUsedOnWire r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_Opnum158NotUsedOnWire_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_Opnum159NotUsedOnWire_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum159NotUsedOnWire_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum159NotUsedOnWire_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct Opnum159NotUsedOnWire *r)
{
	struct tevent_req *req;
	struct dcerpc_Opnum159NotUsedOnWire_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum159NotUsedOnWire_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_OPNUM159NOTUSEDONWIRE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum159NotUsedOnWire_r_done, req);

	return req;
}

static void dcerpc_Opnum159NotUsedOnWire_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum159NotUsedOnWire_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Opnum159NotUsedOnWire_r_state *state =
		tevent_req_data(req,
		struct dcerpc_Opnum159NotUsedOnWire_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum159NotUsedOnWire_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct Opnum159NotUsedOnWire *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_OPNUM159NOTUSEDONWIRE, mem_ctx, r);

	return status;
}

struct dcerpc_Opnum159NotUsedOnWire_state {
	struct Opnum159NotUsedOnWire orig;
	struct Opnum159NotUsedOnWire tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum159NotUsedOnWire_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum159NotUsedOnWire_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h)
{
	struct tevent_req *req;
	struct dcerpc_Opnum159NotUsedOnWire_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum159NotUsedOnWire_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_Opnum159NotUsedOnWire_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum159NotUsedOnWire_done, req);
	return req;
}

static void dcerpc_Opnum159NotUsedOnWire_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_Opnum159NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum159NotUsedOnWire_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_Opnum159NotUsedOnWire_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum159NotUsedOnWire_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_Opnum159NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum159NotUsedOnWire_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum159NotUsedOnWire(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct Opnum159NotUsedOnWire r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_Opnum159NotUsedOnWire_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_Opnum160NotUsedOnWire_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum160NotUsedOnWire_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum160NotUsedOnWire_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct Opnum160NotUsedOnWire *r)
{
	struct tevent_req *req;
	struct dcerpc_Opnum160NotUsedOnWire_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum160NotUsedOnWire_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_OPNUM160NOTUSEDONWIRE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum160NotUsedOnWire_r_done, req);

	return req;
}

static void dcerpc_Opnum160NotUsedOnWire_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum160NotUsedOnWire_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Opnum160NotUsedOnWire_r_state *state =
		tevent_req_data(req,
		struct dcerpc_Opnum160NotUsedOnWire_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum160NotUsedOnWire_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct Opnum160NotUsedOnWire *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_OPNUM160NOTUSEDONWIRE, mem_ctx, r);

	return status;
}

struct dcerpc_Opnum160NotUsedOnWire_state {
	struct Opnum160NotUsedOnWire orig;
	struct Opnum160NotUsedOnWire tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum160NotUsedOnWire_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum160NotUsedOnWire_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h)
{
	struct tevent_req *req;
	struct dcerpc_Opnum160NotUsedOnWire_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum160NotUsedOnWire_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_Opnum160NotUsedOnWire_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum160NotUsedOnWire_done, req);
	return req;
}

static void dcerpc_Opnum160NotUsedOnWire_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_Opnum160NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum160NotUsedOnWire_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_Opnum160NotUsedOnWire_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum160NotUsedOnWire_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_Opnum160NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum160NotUsedOnWire_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum160NotUsedOnWire(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct Opnum160NotUsedOnWire r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_Opnum160NotUsedOnWire_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_Opnum161NotUsedOnWire_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum161NotUsedOnWire_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum161NotUsedOnWire_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct Opnum161NotUsedOnWire *r)
{
	struct tevent_req *req;
	struct dcerpc_Opnum161NotUsedOnWire_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum161NotUsedOnWire_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_OPNUM161NOTUSEDONWIRE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum161NotUsedOnWire_r_done, req);

	return req;
}

static void dcerpc_Opnum161NotUsedOnWire_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum161NotUsedOnWire_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Opnum161NotUsedOnWire_r_state *state =
		tevent_req_data(req,
		struct dcerpc_Opnum161NotUsedOnWire_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum161NotUsedOnWire_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct Opnum161NotUsedOnWire *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_OPNUM161NOTUSEDONWIRE, mem_ctx, r);

	return status;
}

struct dcerpc_Opnum161NotUsedOnWire_state {
	struct Opnum161NotUsedOnWire orig;
	struct Opnum161NotUsedOnWire tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum161NotUsedOnWire_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum161NotUsedOnWire_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h)
{
	struct tevent_req *req;
	struct dcerpc_Opnum161NotUsedOnWire_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum161NotUsedOnWire_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_Opnum161NotUsedOnWire_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum161NotUsedOnWire_done, req);
	return req;
}

static void dcerpc_Opnum161NotUsedOnWire_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_Opnum161NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum161NotUsedOnWire_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_Opnum161NotUsedOnWire_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum161NotUsedOnWire_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_Opnum161NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum161NotUsedOnWire_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum161NotUsedOnWire(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct Opnum161NotUsedOnWire r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_Opnum161NotUsedOnWire_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_Opnum162NotUsedOnWire_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum162NotUsedOnWire_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum162NotUsedOnWire_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct Opnum162NotUsedOnWire *r)
{
	struct tevent_req *req;
	struct dcerpc_Opnum162NotUsedOnWire_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum162NotUsedOnWire_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_OPNUM162NOTUSEDONWIRE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum162NotUsedOnWire_r_done, req);

	return req;
}

static void dcerpc_Opnum162NotUsedOnWire_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum162NotUsedOnWire_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Opnum162NotUsedOnWire_r_state *state =
		tevent_req_data(req,
		struct dcerpc_Opnum162NotUsedOnWire_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum162NotUsedOnWire_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct Opnum162NotUsedOnWire *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_clusapi,
			NDR_OPNUM162NOTUSEDONWIRE, mem_ctx, r);

	return status;
}

struct dcerpc_Opnum162NotUsedOnWire_state {
	struct Opnum162NotUsedOnWire orig;
	struct Opnum162NotUsedOnWire tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum162NotUsedOnWire_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum162NotUsedOnWire_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h)
{
	struct tevent_req *req;
	struct dcerpc_Opnum162NotUsedOnWire_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum162NotUsedOnWire_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_Opnum162NotUsedOnWire_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum162NotUsedOnWire_done, req);
	return req;
}

static void dcerpc_Opnum162NotUsedOnWire_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_Opnum162NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum162NotUsedOnWire_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_Opnum162NotUsedOnWire_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum162NotUsedOnWire_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_Opnum162NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum162NotUsedOnWire_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum162NotUsedOnWire(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct Opnum162NotUsedOnWire r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_Opnum162NotUsedOnWire_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_clusapi_CreateGroupSet_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_clusapi_CreateGroupSet_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_clusapi_CreateGroupSet_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct clusapi_CreateGroupSet *r)
{
	struct tevent_req *req;
	struct dcerpc_clusapi_CreateGroupSet_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_clusapi_CreateGroupSet_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_clusapi,
			NDR_CLUSAPI_CREATEGROUPSET, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq,