// MIT License
//
// Copyright (c) 2023-2025 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

/**
 * @file regex.hpp
 * @brief A lightweight regex engine for ROCm profiling tools.
 *
 * @note This file was generated by an AI.
 *
 * Namespace: rocprofiler::common::regex
 *
 * Implemented APIs:
 *   bool        regex_match(std::string_view text, std::string_view pattern)
 *   bool        regex_search(std::string_view text, std::string_view pattern)
 *   bool        regex_search(std::string_view text, std::string_view pattern,
 *                            size_t& begin, size_t& end)
 *   std::string regex_replace(std::string_view text, std::string_view pattern,
 *                             std::string_view replacement)
 *
 * Supported regex syntax:
 *   Literals/escapes (\n \t \\), ., ^, $, (), |,
 *   character classes [..], ranges, [^..], \d \D \w \W \s \S,
 *   quantifiers *, +, ?, {m}, {m,}, {m,n} with lazy forms (*? +? ?? {m,n}?).
 *
 * Replacement tokens in regex_replace:
 *   $0 or $& : whole match
 *   $1..$99  : capture groups
 *   $`       : prefix (text before the match)
 *   $'       : suffix (text after the match)
 */

#pragma once
#include <string>
#include <string_view>

namespace rocprofiler
{
namespace common
{
namespace regex
{
// Public API
bool
regex_match(std::string_view text, std::string_view pattern);
bool
regex_search(std::string_view text, std::string_view pattern);
bool
regex_search(std::string_view text, std::string_view pattern, size_t& begin, size_t& end);
std::string
regex_replace(std::string_view text, std::string_view pattern, std::string_view replacement);

}  // namespace regex
}  // namespace common
}  // namespace rocprofiler
