/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.10.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/translation.h>



PyDoc_STRVAR(doc_wxTranslationsLoader_LoadCatalog, "LoadCatalog(domain, lang) -> MsgCatalog\n"
"\n"
"Called to load requested catalog.");

extern "C" {static PyObject *meth_wxTranslationsLoader_LoadCatalog(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTranslationsLoader_LoadCatalog(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const ::wxString* domain;
        int domainState = 0;
        const ::wxString* lang;
        int langState = 0;
        ::wxTranslationsLoader *sipCpp;

        static const char *sipKwdList[] = {
            sipName_domain,
            sipName_lang,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxTranslationsLoader, &sipCpp, sipType_wxString, &domain, &domainState, sipType_wxString, &lang, &langState))
        {
            ::wxMsgCatalog*sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_TranslationsLoader, sipName_LoadCatalog);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadCatalog(*domain, *lang);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(domain), sipType_wxString, domainState);
            sipReleaseType(const_cast<::wxString *>(lang), sipType_wxString, langState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxMsgCatalog, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TranslationsLoader, sipName_LoadCatalog, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTranslationsLoader_GetAvailableTranslations, "GetAvailableTranslations(domain) -> List[str]\n"
"\n"
"Implements wxTranslations::GetAvailableTranslations().");

extern "C" {static PyObject *meth_wxTranslationsLoader_GetAvailableTranslations(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTranslationsLoader_GetAvailableTranslations(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const ::wxString* domain;
        int domainState = 0;
        const ::wxTranslationsLoader *sipCpp;

        static const char *sipKwdList[] = {
            sipName_domain,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxTranslationsLoader, &sipCpp, sipType_wxString, &domain, &domainState))
        {
            ::wxArrayString*sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_TranslationsLoader, sipName_GetAvailableTranslations);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxArrayString(sipCpp->GetAvailableTranslations(*domain));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(domain), sipType_wxString, domainState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxArrayString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TranslationsLoader, sipName_GetAvailableTranslations, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxTranslationsLoader(void *, int);}
static void release_wxTranslationsLoader(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<::wxTranslationsLoader *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxTranslationsLoader(sipSimpleWrapper *);}
static void dealloc_wxTranslationsLoader(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxTranslationsLoader(sipGetAddress(sipSelf), 0);
    }
}


static PyMethodDef methods_wxTranslationsLoader[] = {
    {sipName_GetAvailableTranslations, SIP_MLMETH_CAST(meth_wxTranslationsLoader_GetAvailableTranslations), METH_VARARGS|METH_KEYWORDS, doc_wxTranslationsLoader_GetAvailableTranslations},
    {sipName_LoadCatalog, SIP_MLMETH_CAST(meth_wxTranslationsLoader_LoadCatalog), METH_VARARGS|METH_KEYWORDS, doc_wxTranslationsLoader_LoadCatalog}
};

PyDoc_STRVAR(doc_wxTranslationsLoader, "TranslationsLoader() -> None\n"
"\n"
"Abstraction of translations discovery and loading.");


sipClassTypeDef sipTypeDef__core_wxTranslationsLoader = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_ABSTRACT|SIP_TYPE_CLASS,
        sipNameNr_wxTranslationsLoader,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_TranslationsLoader,
        {0, 0, 1},
        2, methods_wxTranslationsLoader,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxTranslationsLoader,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxTranslationsLoader,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxTranslationsLoader,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    0,
};
