// Copyright © 2023-2025 Advanced Micro Devices, Inc.
// SPDX-License-Identifier: MIT

#include "../shim.attn_fwd.h"
#include <aotriton/_internal/triton_kernel.h>
#include <aotriton/_internal/kernel_cluster.h>
#include <aotriton/cpp_tune.h>
#include <string_view>
#ifndef NDEBUG
#include <iostream>
#endif

#define CURRENT_ENTRY_PUBLIC Autotune_attn_fwd__A6__F324

#define ARRAY_SIZE(array)  (sizeof(array) / sizeof(array[0]))

namespace { // Anonymous namespace

using namespace std::literals::string_view_literals;

#if AOTRITON_BUILD_FOR_TUNING
// PSels and Copts in JSON String
static const char* kernel_psels[] = {
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw"
};
static const char* kernel_copts[] = {
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw"
};
#endif

struct PerfFields {
  int16_t BLOCK_M;
    int16_t BLOCK_N;
    int8_t  PERSISTENT_TYPE;
    int8_t  GRID_CU_MULTIP;
    bool    PRE_LOAD_V;
};

static PerfFields image_perf_list [] = {
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false }
};

// u8R generates char8_t which is poorly supported almost everywhere.
constexpr pstring_view PACKAGE_PATH
#if defined(_WIN32)
{ LR"xyzw(amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_192_F_T_0_0___gfx120x)xyzw" };
#else
{ R"xyzw(amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_192_F_T_0_0___gfx120x)xyzw" };
#endif
constexpr std::string_view FUNC_NAME { R"xyzw(＊bf16@16_192_F_T_0_0)xyzw" };
constexpr std::string_view ARCH_NAME { R"xyzw(gfx1201)xyzw" };

// Checksum can be confirmed with `echo -n '<string>' | b2sum -l 64`
// For example:
//   $ echo -n 'amd-gfx110x/flash/attn_fwd/FONLY__^bf16@16,128,False,False,0,0___gfx1100__P__32_32_0_2_False__CO__wave3_warp2_stg1-Gpu-gfx1100' | b2sum -l 64
//   c4b51ee645d79580  -
static AOTRITON_NS::TritonKernelCompactMeta meta_list[] = {
    { 0xd065f46fu, 0x3bc008cdu, 302, 83 }, // d065f46f3bc008cd = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_192_F_T_0_0___gfx120x__P__0_2_16_16_False__CO__wave1_warp2_stg1--Arch_gfx1201
    { 0x4a1297c1u, 0xe5a221f8u, 302, 202 }, // 4a1297c1e5a221f8 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_192_F_T_0_0___gfx120x__P__0_2_16_16_False__CO__wave1_warp4_stg1--Arch_gfx1201
    { 0x8364bf0du, 0x5ccb06eeu, 302, 16 }, // 8364bf0d5ccb06ee = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_192_F_T_0_0___gfx120x__P__0_2_16_16_False__CO__wave2_warp2_stg1--Arch_gfx1201
    { 0xe3726bf5u, 0xa1c47e65u, 302, 116 }, // e3726bf5a1c47e65 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_192_F_T_0_0___gfx120x__P__0_2_16_16_False__CO__wave2_warp4_stg1--Arch_gfx1201
    { 0x3ebe5b95u, 0x8a99e7e0u, 302, 33 }, // 3ebe5b958a99e7e0 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_192_F_T_0_0___gfx120x__P__0_2_16_16_False__CO__wave3_warp2_stg1--Arch_gfx1201
    { 0xb59caf94u, 0x8ce3e01cu, 302, 167 }, // b59caf948ce3e01c = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_192_F_T_0_0___gfx120x__P__0_2_16_16_False__CO__wave3_warp4_stg1--Arch_gfx1201
    { 0xf215e664u, 0xce0ea611u, 302, 50 }, // f215e664ce0ea611 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_192_F_T_0_0___gfx120x__P__0_2_16_16_False__CO__wave4_warp2_stg1--Arch_gfx1201
    { 0x5718b480u, 0x0ce048feu, 302, 133 }, // 5718b4800ce048fe = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_192_F_T_0_0___gfx120x__P__0_2_16_16_False__CO__wave4_warp4_stg1--Arch_gfx1201
    { 0xa8f30e36u, 0xda194ea8u, 0, 83 }, // a8f30e36da194ea8 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_192_F_T_0_0___gfx120x__P__0_2_32_16_False__CO__wave1_warp2_stg1--Arch_gfx1201
    { 0x0ed8efb4u, 0xf7de480du, 0, 16 }, // 0ed8efb4f7de480d = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_192_F_T_0_0___gfx120x__P__0_2_32_16_False__CO__wave2_warp2_stg1--Arch_gfx1201
    { 0x9445bee2u, 0xc1bb69dbu, 0, 116 }, // 9445bee2c1bb69db = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_192_F_T_0_0___gfx120x__P__0_2_32_16_False__CO__wave2_warp4_stg1--Arch_gfx1201
    { 0x94790818u, 0x1bb370c7u, 0, 33 }, // 947908181bb370c7 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_192_F_T_0_0___gfx120x__P__0_2_32_16_False__CO__wave3_warp2_stg1--Arch_gfx1201
    { 0x79212108u, 0xd80628e9u, 0, 167 }, // 79212108d80628e9 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_192_F_T_0_0___gfx120x__P__0_2_32_16_False__CO__wave3_warp4_stg1--Arch_gfx1201
    { 0x3339afccu, 0x84afa176u, 0, 50 }, // 3339afcc84afa176 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_192_F_T_0_0___gfx120x__P__0_2_32_16_False__CO__wave4_warp2_stg1--Arch_gfx1201
    { 0x40d69494u, 0x21c1ceaau, 318, 202 }, // 40d6949421c1ceaa = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_192_F_T_0_0___gfx120x__P__0_2_32_32_False__CO__wave1_warp4_stg1--Arch_gfx1201
    { 0x372ea3bcu, 0x827727c1u, 318, 116 }, // 372ea3bc827727c1 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_192_F_T_0_0___gfx120x__P__0_2_32_32_False__CO__wave2_warp4_stg1--Arch_gfx1201
    { 0x62a6f86au, 0xbd809ff6u, 318, 167 }, // 62a6f86abd809ff6 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_192_F_T_0_0___gfx120x__P__0_2_32_32_False__CO__wave3_warp4_stg1--Arch_gfx1201
    { 0xc45471e1u, 0x25e04901u, 318, 133 }, // c45471e125e04901 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_192_F_T_0_0___gfx120x__P__0_2_32_32_False__CO__wave4_warp4_stg1--Arch_gfx1201
    { 0x4fe94dd1u, 0x3a523eabu, 67, 133 }, // 4fe94dd13a523eab = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_192_F_T_0_0___gfx120x__P__0_2_64_32_False__CO__wave4_warp4_stg1--Arch_gfx1201
};

static constexpr int kTotalNumKernels = ARRAY_SIZE(meta_list);

using AOTRITON_NS::v3::flash::autotune::attn_fwd_packed_string;

static AOTRITON_NS::TritonKernelCluster<kTotalNumKernels>
kernel_cluster(meta_list,
               attn_fwd_packed_string);

static int8_t lut[1][10][10] =
{
// GPU gfx1201_mod0
{{10,12, 1, 5, 7,12, 7, 7, 5, 3},
 { 4, 2, 2, 6, 4, 2, 6,17,17,17},
 { 6, 0, 4, 4,13, 1,11, 9,18,18},
 { 4, 6, 4, 6, 0,15,16,14,14,16},
 { 2, 2, 4, 0, 0, 8, 9,18,16,15},
 { 2, 0, 0, 4, 8,11,18,18,18,18},
 { 6, 6, 0, 6, 9, 8,14,16,15,15},
 { 0, 4, 0, 4,11,14, 8,18,18,18},
 { 4, 0, 0, 0,11, 9,18,18,18,18},
 { 4, 4, 2, 2, 8,11,18,18,18,18}}
// End of GPU gfx1201_mod0
}
;

}; // End of anonymous namespace

namespace AOTRITON_NS::v3::flash::autotune {

// using AOTRITON_NS::v2::flash::AttnFwdContext;

void CURRENT_ENTRY_PUBLIC(AttnFwdContext& context, int mod_number) {
#if AOTRITON_BUILD_FOR_TUNING
    int preferred_index = context._has_preferred_kernel;
    context._total_number_of_kernels = kTotalNumKernels;
#ifndef NDEBUG
    std::cerr << "Autotune_attn_fwd__A6__F324 "
              << "kTotalNumKernels = " << kTotalNumKernels << " "
              << "_has_preferred_kernel = " << preferred_index << " "
              << std::endl;
#endif
    if (preferred_index != -1) {
        if (preferred_index >= kTotalNumKernels)
            return ;
        context.kernel_on_device = kernel_cluster.get(preferred_index);
        context.pp_args_index = 3;
        context.package_path = PACKAGE_PATH;
        context.func_name = FUNC_NAME;
        context.arch_name = ARCH_NAME;
        context._preferred_kernel_psels = kernel_psels[preferred_index];
        context._preferred_kernel_copts = kernel_copts[preferred_index];
        const auto& perf = image_perf_list[preferred_index];
        context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
        return ;
    }
#endif
    auto kernel_index = attn_fwd__lut_lambda__0(*context.params, mod_number, lut);
    if (kernel_index < 0) {
      return ;
    }
    context.kernel_on_device = kernel_cluster.get(kernel_index);
    context.pp_args_index = 3;
    context.package_path = PACKAGE_PATH;
    context.func_name = FUNC_NAME;
    context.arch_name = ARCH_NAME;
#ifndef NDEBUG
    std::cerr << __FILE__ << " kernel_index = " << int(kernel_index) << std::endl;
#endif
    const auto& perf = image_perf_list[kernel_index];
    context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
}

#undef CURRENT_ENTRY_PUBLIC
}

// Human-readable Signature 
// Q = "*bf16:16"
// B = 0
// A = 0
// Sm_scale = "fp32"
// L = "*fp32:16"
// Q_descale = 0
// stride_bz = 0
// stride_az = 0
// Num_head_q = "i32"
// cu_seqlens_q = "*i32:16"
// BLOCK_DMODEL = 192
// Head_dim = 192
// PADDED_HEAD = False
// ENABLE_DROPOUT = True
// dropout_p = "fp32"
// philox_seed_ptr = "*u64"
// philox_offset1 = "*u64"
// philox_offset2 = "u64"
// RETURN_ENCODED_SOFTMAX = False
// encoded_softmax = 0
// CAUSAL_TYPE = 0
// Window_left = 0
// BIAS_TYPE = 0
// USE_ALIBI = False
// INT8 = False
// persistent_atomic_counter = 0
// Num_CU = "i32"

// SELECT * FROM FLASH$attn_fwd WHERE gpu IN ('gfx1201_mod0') AND inputs$Q_dtype = 'torch.bfloat16' AND inputs$BLOCK_DMODEL = 192 AND inputs$PADDED_HEAD = False AND inputs$ENABLE_DROPOUT = True AND inputs$CAUSAL_TYPE = 0 AND inputs$BIAS_TYPE = 0

// vim: set fileencoding=utf-8

