/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.14.0
 *
 * Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtGui.h"

#line 48 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtGui/qtextlayout.sip"
#include <qtextlayout.h>
#line 29 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQTextLayout.cpp"

#line 27 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 33 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQTextLayout.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtGui/qfont.sip"
#include <qfont.h>
#line 36 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQTextLayout.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtGui/qpaintdevice.sip"
#include <qpaintdevice.h>
#line 39 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQTextLayout.cpp"
#line 118 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtGui/qtextobject.sip"
#include <qtextobject.h>
#line 42 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQTextLayout.cpp"
#line 28 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qpycore_qvector.sip"
#include <qvector.h>
#line 45 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQTextLayout.cpp"
#line 48 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtGui/qtextlayout.sip"
#include <qtextlayout.h>
#line 70 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtGui/qtextlayout.sip"
#include <qtextlayout.h>
#line 50 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQTextLayout.cpp"
#line 38 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 53 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQTextLayout.cpp"
#line 28 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtGui/qglyphrun.sip"
#include <qglyphrun.h>
#line 56 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQTextLayout.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 59 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQTextLayout.cpp"
#line 164 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qrect.sip"
#include <qrect.h>
#line 62 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQTextLayout.cpp"
#line 98 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qpoint.sip"
#include <qpoint.h>
#line 65 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQTextLayout.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtGui/qpainter.sip"
#include <qpainter.h>
#line 68 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQTextLayout.cpp"
#line 132 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtGui/qtextlayout.sip"
#include <qtextlayout.h>
#line 71 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQTextLayout.cpp"
#line 38 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 74 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQTextLayout.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtGui/qtextoption.sip"
#include <qtextoption.h>
#line 77 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQTextLayout.cpp"


PyDoc_STRVAR(doc_QTextLayout_setFont, "setFont(self, f: QFont)");

extern "C" {static PyObject *meth_QTextLayout_setFont(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_setFont(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont* a0;
        ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QTextLayout, &sipCpp, sipType_QFont, &a0))
        {
            sipCpp->setFont(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_setFont, doc_QTextLayout_setFont);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_font, "font(self) -> QFont");

extern "C" {static PyObject *meth_QTextLayout_font(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_font(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QTextLayout, &sipCpp))
        {
            ::QFont*sipRes;

            sipRes = new ::QFont(sipCpp->font());

            return sipConvertFromNewType(sipRes, sipType_QFont, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_font, doc_QTextLayout_font);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_setText, "setText(self, string: Optional[str])");

extern "C" {static PyObject *meth_QTextLayout_setText(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_setText(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QTextLayout, &sipCpp, sipType_QString, &a0, &a0State))
        {
            sipCpp->setText(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_setText, doc_QTextLayout_setText);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_text, "text(self) -> str");

extern "C" {static PyObject *meth_QTextLayout_text(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_text(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QTextLayout, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->text());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_text, doc_QTextLayout_text);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_setTextOption, "setTextOption(self, option: QTextOption)");

extern "C" {static PyObject *meth_QTextLayout_setTextOption(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_setTextOption(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QTextOption* a0;
        ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QTextLayout, &sipCpp, sipType_QTextOption, &a0))
        {
            sipCpp->setTextOption(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_setTextOption, doc_QTextLayout_setTextOption);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_textOption, "textOption(self) -> QTextOption");

extern "C" {static PyObject *meth_QTextLayout_textOption(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_textOption(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QTextLayout, &sipCpp))
        {
            ::QTextOption*sipRes;

            sipRes = new ::QTextOption(sipCpp->textOption());

            return sipConvertFromNewType(sipRes, sipType_QTextOption, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_textOption, doc_QTextLayout_textOption);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_setPreeditArea, "setPreeditArea(self, position: int, text: Optional[str])");

extern "C" {static PyObject *meth_QTextLayout_setPreeditArea(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_setPreeditArea(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QString* a1;
        int a1State = 0;
        ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BiJ1", &sipSelf, sipType_QTextLayout, &sipCpp, &a0, sipType_QString, &a1, &a1State))
        {
            sipCpp->setPreeditArea(a0, *a1);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_setPreeditArea, doc_QTextLayout_setPreeditArea);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_preeditAreaPosition, "preeditAreaPosition(self) -> int");

extern "C" {static PyObject *meth_QTextLayout_preeditAreaPosition(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_preeditAreaPosition(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QTextLayout, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->preeditAreaPosition();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_preeditAreaPosition, doc_QTextLayout_preeditAreaPosition);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_preeditAreaText, "preeditAreaText(self) -> str");

extern "C" {static PyObject *meth_QTextLayout_preeditAreaText(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_preeditAreaText(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QTextLayout, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->preeditAreaText());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_preeditAreaText, doc_QTextLayout_preeditAreaText);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_setAdditionalFormats, "setAdditionalFormats(self, overrides: Iterable[QTextLayout.FormatRange])");

extern "C" {static PyObject *meth_QTextLayout_setAdditionalFormats(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_setAdditionalFormats(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const QList< ::QTextLayout::FormatRange>* a0;
        int a0State = 0;
        ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QTextLayout, &sipCpp, sipType_QList_0100QTextLayout_FormatRange, &a0, &a0State))
        {
            sipCpp->setAdditionalFormats(*a0);
            sipReleaseType(const_cast<QList< ::QTextLayout::FormatRange> *>(a0), sipType_QList_0100QTextLayout_FormatRange, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_setAdditionalFormats, doc_QTextLayout_setAdditionalFormats);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_additionalFormats, "additionalFormats(self) -> list[QTextLayout.FormatRange]");

extern "C" {static PyObject *meth_QTextLayout_additionalFormats(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_additionalFormats(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QTextLayout, &sipCpp))
        {
            QList< ::QTextLayout::FormatRange>*sipRes;

            sipRes = new QList< ::QTextLayout::FormatRange>(sipCpp->additionalFormats());

            return sipConvertFromNewType(sipRes, sipType_QList_0100QTextLayout_FormatRange, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_additionalFormats, doc_QTextLayout_additionalFormats);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_clearAdditionalFormats, "clearAdditionalFormats(self)");

extern "C" {static PyObject *meth_QTextLayout_clearAdditionalFormats(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_clearAdditionalFormats(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QTextLayout, &sipCpp))
        {
            sipCpp->clearAdditionalFormats();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_clearAdditionalFormats, doc_QTextLayout_clearAdditionalFormats);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_setCacheEnabled, "setCacheEnabled(self, enable: bool)");

extern "C" {static PyObject *meth_QTextLayout_setCacheEnabled(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_setCacheEnabled(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bb", &sipSelf, sipType_QTextLayout, &sipCpp, &a0))
        {
            sipCpp->setCacheEnabled(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_setCacheEnabled, doc_QTextLayout_setCacheEnabled);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_cacheEnabled, "cacheEnabled(self) -> bool");

extern "C" {static PyObject *meth_QTextLayout_cacheEnabled(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_cacheEnabled(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QTextLayout, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->cacheEnabled();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_cacheEnabled, doc_QTextLayout_cacheEnabled);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_beginLayout, "beginLayout(self)");

extern "C" {static PyObject *meth_QTextLayout_beginLayout(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_beginLayout(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QTextLayout, &sipCpp))
        {
            sipCpp->beginLayout();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_beginLayout, doc_QTextLayout_beginLayout);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_endLayout, "endLayout(self)");

extern "C" {static PyObject *meth_QTextLayout_endLayout(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_endLayout(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QTextLayout, &sipCpp))
        {
            sipCpp->endLayout();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_endLayout, doc_QTextLayout_endLayout);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_createLine, "createLine(self) -> QTextLine");

extern "C" {static PyObject *meth_QTextLayout_createLine(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_createLine(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QTextLayout, &sipCpp))
        {
            ::QTextLine*sipRes;

            sipRes = new ::QTextLine(sipCpp->createLine());

            return sipConvertFromNewType(sipRes, sipType_QTextLine, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_createLine, doc_QTextLayout_createLine);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_lineCount, "lineCount(self) -> int");

extern "C" {static PyObject *meth_QTextLayout_lineCount(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_lineCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QTextLayout, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->lineCount();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_lineCount, doc_QTextLayout_lineCount);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_lineAt, "lineAt(self, i: int) -> QTextLine");

extern "C" {static PyObject *meth_QTextLayout_lineAt(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_lineAt(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QTextLayout, &sipCpp, &a0))
        {
            ::QTextLine*sipRes;

            sipRes = new ::QTextLine(sipCpp->lineAt(a0));

            return sipConvertFromNewType(sipRes, sipType_QTextLine, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_lineAt, doc_QTextLayout_lineAt);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_lineForTextPosition, "lineForTextPosition(self, pos: int) -> QTextLine");

extern "C" {static PyObject *meth_QTextLayout_lineForTextPosition(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_lineForTextPosition(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QTextLayout, &sipCpp, &a0))
        {
            ::QTextLine*sipRes;

            sipRes = new ::QTextLine(sipCpp->lineForTextPosition(a0));

            return sipConvertFromNewType(sipRes, sipType_QTextLine, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_lineForTextPosition, doc_QTextLayout_lineForTextPosition);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_isValidCursorPosition, "isValidCursorPosition(self, pos: int) -> bool");

extern "C" {static PyObject *meth_QTextLayout_isValidCursorPosition(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_isValidCursorPosition(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QTextLayout, &sipCpp, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->isValidCursorPosition(a0);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_isValidCursorPosition, doc_QTextLayout_isValidCursorPosition);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_nextCursorPosition, "nextCursorPosition(self, oldPos: int, mode: QTextLayout.CursorMode = QTextLayout.SkipCharacters) -> int");

extern "C" {static PyObject *meth_QTextLayout_nextCursorPosition(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_nextCursorPosition(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        ::QTextLayout::CursorMode a1 = QTextLayout::SkipCharacters;
        const ::QTextLayout *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_mode,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi|E", &sipSelf, sipType_QTextLayout, &sipCpp, &a0, sipType_QTextLayout_CursorMode, &a1))
        {
            int sipRes;

            sipRes = sipCpp->nextCursorPosition(a0, a1);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_nextCursorPosition, doc_QTextLayout_nextCursorPosition);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_previousCursorPosition, "previousCursorPosition(self, oldPos: int, mode: QTextLayout.CursorMode = QTextLayout.SkipCharacters) -> int");

extern "C" {static PyObject *meth_QTextLayout_previousCursorPosition(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_previousCursorPosition(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        ::QTextLayout::CursorMode a1 = QTextLayout::SkipCharacters;
        const ::QTextLayout *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_mode,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi|E", &sipSelf, sipType_QTextLayout, &sipCpp, &a0, sipType_QTextLayout_CursorMode, &a1))
        {
            int sipRes;

            sipRes = sipCpp->previousCursorPosition(a0, a1);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_previousCursorPosition, doc_QTextLayout_previousCursorPosition);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_draw, "draw(self, p: Optional[QPainter], pos: Union[QPointF, QPoint], selections: Iterable[QTextLayout.FormatRange] = [], clip: QRectF = QRectF())");

extern "C" {static PyObject *meth_QTextLayout_draw(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_draw(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QPainter* a0;
        const ::QPointF* a1;
        int a1State = 0;
        const QVector< ::QTextLayout::FormatRange>& a2def = QVector<QTextLayout::FormatRange>();
        const QVector< ::QTextLayout::FormatRange>* a2 = &a2def;
        int a2State = 0;
        const ::QRectF& a3def = QRectF();
        const ::QRectF* a3 = &a3def;
        const ::QTextLayout *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_selections,
            sipName_clip,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J1|J1J9", &sipSelf, sipType_QTextLayout, &sipCpp, sipType_QPainter, &a0, sipType_QPointF, &a1, &a1State, sipType_QVector_0100QTextLayout_FormatRange, &a2, &a2State, sipType_QRectF, &a3))
        {
            sipCpp->draw(a0, *a1, *a2, *a3);
            sipReleaseType(const_cast< ::QPointF *>(a1), sipType_QPointF, a1State);
            sipReleaseType(const_cast<QVector< ::QTextLayout::FormatRange> *>(a2), sipType_QVector_0100QTextLayout_FormatRange, a2State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_draw, doc_QTextLayout_draw);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_drawCursor, "drawCursor(self, p: Optional[QPainter], pos: Union[QPointF, QPoint], cursorPosition: int)\n"
"drawCursor(self, p: Optional[QPainter], pos: Union[QPointF, QPoint], cursorPosition: int, width: int)");

extern "C" {static PyObject *meth_QTextLayout_drawCursor(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_drawCursor(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QPainter* a0;
        const ::QPointF* a1;
        int a1State = 0;
        int a2;
        const ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ8J1i", &sipSelf, sipType_QTextLayout, &sipCpp, sipType_QPainter, &a0, sipType_QPointF, &a1, &a1State, &a2))
        {
            sipCpp->drawCursor(a0, *a1, a2);
            sipReleaseType(const_cast< ::QPointF *>(a1), sipType_QPointF, a1State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        ::QPainter* a0;
        const ::QPointF* a1;
        int a1State = 0;
        int a2;
        int a3;
        const ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ8J1ii", &sipSelf, sipType_QTextLayout, &sipCpp, sipType_QPainter, &a0, sipType_QPointF, &a1, &a1State, &a2, &a3))
        {
            sipCpp->drawCursor(a0, *a1, a2, a3);
            sipReleaseType(const_cast< ::QPointF *>(a1), sipType_QPointF, a1State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_drawCursor, doc_QTextLayout_drawCursor);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_position, "position(self) -> QPointF");

extern "C" {static PyObject *meth_QTextLayout_position(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_position(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QTextLayout, &sipCpp))
        {
            ::QPointF*sipRes;

            sipRes = new ::QPointF(sipCpp->position());

            return sipConvertFromNewType(sipRes, sipType_QPointF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_position, doc_QTextLayout_position);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_setPosition, "setPosition(self, p: Union[QPointF, QPoint])");

extern "C" {static PyObject *meth_QTextLayout_setPosition(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_setPosition(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPointF* a0;
        int a0State = 0;
        ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QTextLayout, &sipCpp, sipType_QPointF, &a0, &a0State))
        {
            sipCpp->setPosition(*a0);
            sipReleaseType(const_cast< ::QPointF *>(a0), sipType_QPointF, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_setPosition, doc_QTextLayout_setPosition);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_boundingRect, "boundingRect(self) -> QRectF");

extern "C" {static PyObject *meth_QTextLayout_boundingRect(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_boundingRect(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QTextLayout, &sipCpp))
        {
            ::QRectF*sipRes;

            sipRes = new ::QRectF(sipCpp->boundingRect());

            return sipConvertFromNewType(sipRes, sipType_QRectF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_boundingRect, doc_QTextLayout_boundingRect);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_minimumWidth, "minimumWidth(self) -> float");

extern "C" {static PyObject *meth_QTextLayout_minimumWidth(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_minimumWidth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QTextLayout, &sipCpp))
        {
            ::qreal sipRes;

            sipRes = sipCpp->minimumWidth();

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_minimumWidth, doc_QTextLayout_minimumWidth);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_maximumWidth, "maximumWidth(self) -> float");

extern "C" {static PyObject *meth_QTextLayout_maximumWidth(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_maximumWidth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QTextLayout, &sipCpp))
        {
            ::qreal sipRes;

            sipRes = sipCpp->maximumWidth();

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_maximumWidth, doc_QTextLayout_maximumWidth);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_clearLayout, "clearLayout(self)");

extern "C" {static PyObject *meth_QTextLayout_clearLayout(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_clearLayout(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QTextLayout, &sipCpp))
        {
            sipCpp->clearLayout();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_clearLayout, doc_QTextLayout_clearLayout);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_setCursorMoveStyle, "setCursorMoveStyle(self, style: Qt.CursorMoveStyle)");

extern "C" {static PyObject *meth_QTextLayout_setCursorMoveStyle(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_setCursorMoveStyle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::Qt::CursorMoveStyle a0;
        ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QTextLayout, &sipCpp, sipType_Qt_CursorMoveStyle, &a0))
        {
            sipCpp->setCursorMoveStyle(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_setCursorMoveStyle, doc_QTextLayout_setCursorMoveStyle);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_cursorMoveStyle, "cursorMoveStyle(self) -> Qt.CursorMoveStyle");

extern "C" {static PyObject *meth_QTextLayout_cursorMoveStyle(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_cursorMoveStyle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QTextLayout, &sipCpp))
        {
            ::Qt::CursorMoveStyle sipRes;

            sipRes = sipCpp->cursorMoveStyle();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_Qt_CursorMoveStyle);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_cursorMoveStyle, doc_QTextLayout_cursorMoveStyle);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_leftCursorPosition, "leftCursorPosition(self, oldPos: int) -> int");

extern "C" {static PyObject *meth_QTextLayout_leftCursorPosition(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_leftCursorPosition(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QTextLayout, &sipCpp, &a0))
        {
            int sipRes;

            sipRes = sipCpp->leftCursorPosition(a0);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_leftCursorPosition, doc_QTextLayout_leftCursorPosition);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_rightCursorPosition, "rightCursorPosition(self, oldPos: int) -> int");

extern "C" {static PyObject *meth_QTextLayout_rightCursorPosition(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_rightCursorPosition(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QTextLayout, &sipCpp, &a0))
        {
            int sipRes;

            sipRes = sipCpp->rightCursorPosition(a0);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_rightCursorPosition, doc_QTextLayout_rightCursorPosition);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_glyphRuns, "glyphRuns(self, from_: int = -1, length: int = -1) -> list[QGlyphRun]");

extern "C" {static PyObject *meth_QTextLayout_glyphRuns(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_glyphRuns(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0 = -1;
        int a1 = -1;
        const ::QTextLayout *sipCpp;

        static const char *sipKwdList[] = {
            sipName_from,
            sipName_length,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|ii", &sipSelf, sipType_QTextLayout, &sipCpp, &a0, &a1))
        {
            QList< ::QGlyphRun>*sipRes;

            sipRes = new QList< ::QGlyphRun>(sipCpp->glyphRuns(a0, a1));

            return sipConvertFromNewType(sipRes, sipType_QList_0100QGlyphRun, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_glyphRuns, doc_QTextLayout_glyphRuns);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_setFormats, "setFormats(self, overrides: Iterable[QTextLayout.FormatRange])");

extern "C" {static PyObject *meth_QTextLayout_setFormats(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_setFormats(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const QVector< ::QTextLayout::FormatRange>* a0;
        int a0State = 0;
        ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QTextLayout, &sipCpp, sipType_QVector_0100QTextLayout_FormatRange, &a0, &a0State))
        {
            sipCpp->setFormats(*a0);
            sipReleaseType(const_cast<QVector< ::QTextLayout::FormatRange> *>(a0), sipType_QVector_0100QTextLayout_FormatRange, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_setFormats, doc_QTextLayout_setFormats);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_formats, "formats(self) -> list[QTextLayout.FormatRange]");

extern "C" {static PyObject *meth_QTextLayout_formats(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_formats(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QTextLayout, &sipCpp))
        {
            QVector< ::QTextLayout::FormatRange>*sipRes;

            sipRes = new QVector< ::QTextLayout::FormatRange>(sipCpp->formats());

            return sipConvertFromNewType(sipRes, sipType_QVector_0100QTextLayout_FormatRange, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_formats, doc_QTextLayout_formats);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTextLayout_clearFormats, "clearFormats(self)");

extern "C" {static PyObject *meth_QTextLayout_clearFormats(PyObject *, PyObject *);}
static PyObject *meth_QTextLayout_clearFormats(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QTextLayout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QTextLayout, &sipCpp))
        {
            sipCpp->clearFormats();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QTextLayout, sipName_clearFormats, doc_QTextLayout_clearFormats);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QTextLayout(void *, int);}
static void release_QTextLayout(void *sipCppV, int)
{
    delete reinterpret_cast< ::QTextLayout *>(sipCppV);
}


extern "C" {static void *array_QTextLayout(Py_ssize_t);}
static void *array_QTextLayout(Py_ssize_t sipNrElem)
{
    return new ::QTextLayout[sipNrElem];
}


extern "C" {static void array_delete_QTextLayout(void *);}
static void array_delete_QTextLayout(void *sipCpp)
{
    delete[] reinterpret_cast< ::QTextLayout *>(sipCpp);
}


extern "C" {static void dealloc_QTextLayout(sipSimpleWrapper *);}
static void dealloc_QTextLayout(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QTextLayout(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QTextLayout(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QTextLayout(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QTextLayout *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QTextLayout();

            return sipCpp;
        }
    }

    {
        const ::QString* a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J1", sipType_QString, &a0, &a0State))
        {
            sipCpp = new ::QTextLayout(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipCpp;
        }
    }

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QFont* a1;
        ::QPaintDevice* a2 = 0;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_paintDevice,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1J9|J8", sipType_QString, &a0, &a0State, sipType_QFont, &a1, sipType_QPaintDevice, &a2))
        {
            sipCpp = new ::QTextLayout(*a0, *a1, a2);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipCpp;
        }
    }

    {
        const ::QTextBlock* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QTextBlock, &a0))
        {
            sipCpp = new ::QTextLayout(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QTextLayout[] = {
    {sipName_additionalFormats, meth_QTextLayout_additionalFormats, METH_VARARGS, doc_QTextLayout_additionalFormats},
    {sipName_beginLayout, meth_QTextLayout_beginLayout, METH_VARARGS, doc_QTextLayout_beginLayout},
    {sipName_boundingRect, meth_QTextLayout_boundingRect, METH_VARARGS, doc_QTextLayout_boundingRect},
    {sipName_cacheEnabled, meth_QTextLayout_cacheEnabled, METH_VARARGS, doc_QTextLayout_cacheEnabled},
    {sipName_clearAdditionalFormats, meth_QTextLayout_clearAdditionalFormats, METH_VARARGS, doc_QTextLayout_clearAdditionalFormats},
    {sipName_clearFormats, meth_QTextLayout_clearFormats, METH_VARARGS, doc_QTextLayout_clearFormats},
    {sipName_clearLayout, meth_QTextLayout_clearLayout, METH_VARARGS, doc_QTextLayout_clearLayout},
    {sipName_createLine, meth_QTextLayout_createLine, METH_VARARGS, doc_QTextLayout_createLine},
    {sipName_cursorMoveStyle, meth_QTextLayout_cursorMoveStyle, METH_VARARGS, doc_QTextLayout_cursorMoveStyle},
    {sipName_draw, SIP_MLMETH_CAST(meth_QTextLayout_draw), METH_VARARGS|METH_KEYWORDS, doc_QTextLayout_draw},
    {sipName_drawCursor, meth_QTextLayout_drawCursor, METH_VARARGS, doc_QTextLayout_drawCursor},
    {sipName_endLayout, meth_QTextLayout_endLayout, METH_VARARGS, doc_QTextLayout_endLayout},
    {sipName_font, meth_QTextLayout_font, METH_VARARGS, doc_QTextLayout_font},
    {sipName_formats, meth_QTextLayout_formats, METH_VARARGS, doc_QTextLayout_formats},
    {sipName_glyphRuns, SIP_MLMETH_CAST(meth_QTextLayout_glyphRuns), METH_VARARGS|METH_KEYWORDS, doc_QTextLayout_glyphRuns},
    {sipName_isValidCursorPosition, meth_QTextLayout_isValidCursorPosition, METH_VARARGS, doc_QTextLayout_isValidCursorPosition},
    {sipName_leftCursorPosition, meth_QTextLayout_leftCursorPosition, METH_VARARGS, doc_QTextLayout_leftCursorPosition},
    {sipName_lineAt, meth_QTextLayout_lineAt, METH_VARARGS, doc_QTextLayout_lineAt},
    {sipName_lineCount, meth_QTextLayout_lineCount, METH_VARARGS, doc_QTextLayout_lineCount},
    {sipName_lineForTextPosition, meth_QTextLayout_lineForTextPosition, METH_VARARGS, doc_QTextLayout_lineForTextPosition},
    {sipName_maximumWidth, meth_QTextLayout_maximumWidth, METH_VARARGS, doc_QTextLayout_maximumWidth},
    {sipName_minimumWidth, meth_QTextLayout_minimumWidth, METH_VARARGS, doc_QTextLayout_minimumWidth},
    {sipName_nextCursorPosition, SIP_MLMETH_CAST(meth_QTextLayout_nextCursorPosition), METH_VARARGS|METH_KEYWORDS, doc_QTextLayout_nextCursorPosition},
    {sipName_position, meth_QTextLayout_position, METH_VARARGS, doc_QTextLayout_position},
    {sipName_preeditAreaPosition, meth_QTextLayout_preeditAreaPosition, METH_VARARGS, doc_QTextLayout_preeditAreaPosition},
    {sipName_preeditAreaText, meth_QTextLayout_preeditAreaText, METH_VARARGS, doc_QTextLayout_preeditAreaText},
    {sipName_previousCursorPosition, SIP_MLMETH_CAST(meth_QTextLayout_previousCursorPosition), METH_VARARGS|METH_KEYWORDS, doc_QTextLayout_previousCursorPosition},
    {sipName_rightCursorPosition, meth_QTextLayout_rightCursorPosition, METH_VARARGS, doc_QTextLayout_rightCursorPosition},
    {sipName_setAdditionalFormats, meth_QTextLayout_setAdditionalFormats, METH_VARARGS, doc_QTextLayout_setAdditionalFormats},
    {sipName_setCacheEnabled, meth_QTextLayout_setCacheEnabled, METH_VARARGS, doc_QTextLayout_setCacheEnabled},
    {sipName_setCursorMoveStyle, meth_QTextLayout_setCursorMoveStyle, METH_VARARGS, doc_QTextLayout_setCursorMoveStyle},
    {sipName_setFont, meth_QTextLayout_setFont, METH_VARARGS, doc_QTextLayout_setFont},
    {sipName_setFormats, meth_QTextLayout_setFormats, METH_VARARGS, doc_QTextLayout_setFormats},
    {sipName_setPosition, meth_QTextLayout_setPosition, METH_VARARGS, doc_QTextLayout_setPosition},
    {sipName_setPreeditArea, meth_QTextLayout_setPreeditArea, METH_VARARGS, doc_QTextLayout_setPreeditArea},
    {sipName_setText, meth_QTextLayout_setText, METH_VARARGS, doc_QTextLayout_setText},
    {sipName_setTextOption, meth_QTextLayout_setTextOption, METH_VARARGS, doc_QTextLayout_setTextOption},
    {sipName_text, meth_QTextLayout_text, METH_VARARGS, doc_QTextLayout_text},
    {sipName_textOption, meth_QTextLayout_textOption, METH_VARARGS, doc_QTextLayout_textOption}
};

static sipEnumMemberDef enummembers_QTextLayout[] = {
    {sipName_SkipCharacters, static_cast<int>(::QTextLayout::SkipCharacters), 334},
    {sipName_SkipWords, static_cast<int>(::QTextLayout::SkipWords), 334},
};

PyDoc_STRVAR(doc_QTextLayout, "\1QTextLayout()\n"
"QTextLayout(text: Optional[str])\n"
"QTextLayout(text: Optional[str], font: QFont, paintDevice: Optional[QPaintDevice] = None)\n"
"QTextLayout(b: QTextBlock)");


static pyqt5ClassPluginDef plugin_QTextLayout = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtGui_QTextLayout = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QTextLayout,
        SIP_NULLPTR,
        &plugin_QTextLayout,
    },
    {
        sipNameNr_QTextLayout,
        {0, 0, 1},
        39, methods_QTextLayout,
        2, enummembers_QTextLayout,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QTextLayout,
    -1,
    sipNameNr_sip_simplewrapper,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QTextLayout,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QTextLayout,
    SIP_NULLPTR,
    array_QTextLayout,
    SIP_NULLPTR,
    release_QTextLayout,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QTextLayout,
    sizeof (::QTextLayout),
};
