/* WindowControl.c generated by valac 0.56.17, the Vala compiler
 * generated from WindowControl.vala, do not modify */

/**/
/*  Copyright (C) 2011-2012 Robert Dyer, Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank-internal.h"
#include <glib.h>
#include <libwnck/libwnck.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <libbamf/libbamf.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <cairo-gobject.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLANK_WINDOW_CONTROL_0_PROPERTY,
	PLANK_WINDOW_CONTROL_NUM_PROPERTIES
};
static GParamSpec* plank_window_control_properties[PLANK_WINDOW_CONTROL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _Block1Data {
	int _ref_count_;
	guint32 event_time;
};

static gpointer plank_window_control_parent_class = NULL;
static guint plank_window_control_delayed_focus_timer_id;
static guint plank_window_control_delayed_focus_timer_id = 0U;
static WnckWindow* plank_window_control_delayed_focus_window;
static WnckWindow* plank_window_control_delayed_focus_window = NULL;

static PlankWindowControl* plank_window_control_new (void);
static PlankWindowControl* plank_window_control_construct (GType object_type);
static void plank_window_control_window_manager_changed (WnckScreen* screen);
static void _plank_window_control_window_manager_changed_wnck_screen_window_manager_changed (WnckScreen* _sender,
                                                                                      gpointer self);
static void plank_window_control_handle_window_closed (WnckWindow* window);
static void _plank_window_control_handle_window_closed_wnck_screen_window_closed (WnckScreen* _sender,
                                                                           WnckWindow* window,
                                                                           gpointer self);
static void plank_window_control_center_and_focus_window (WnckWindow* w,
                                                   guint32 event_time);
static void plank_window_control_focus_window_by_xid (guint32 xid,
                                               guint32 event_time);
static gint plank_window_control_find_active_xid_index (GArray* xids);
static void plank_window_control_intelligent_focus_off_viewport_window (WnckWindow* targetWindow,
                                                                 GList* additional_windows,
                                                                 guint32 event_time);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean plank_window_control_windows_share_viewport (WnckWindow* first,
                                                      WnckWindow* second);
static gboolean __lambda4_ (Block1Data* _data1_);
static gboolean ___lambda4__gsource_func (gpointer self);
static void plank_window_control_finalize (GObject * obj);
static GType plank_window_control_get_type_once (void);

static GType
plank_struts_get_type_once (void)
{
	static const GEnumValue values[] = {{PLANK_STRUTS_LEFT, "PLANK_STRUTS_LEFT", "left"}, {PLANK_STRUTS_RIGHT, "PLANK_STRUTS_RIGHT", "right"}, {PLANK_STRUTS_TOP, "PLANK_STRUTS_TOP", "top"}, {PLANK_STRUTS_BOTTOM, "PLANK_STRUTS_BOTTOM", "bottom"}, {PLANK_STRUTS_LEFT_START, "PLANK_STRUTS_LEFT_START", "left-start"}, {PLANK_STRUTS_LEFT_END, "PLANK_STRUTS_LEFT_END", "left-end"}, {PLANK_STRUTS_RIGHT_START, "PLANK_STRUTS_RIGHT_START", "right-start"}, {PLANK_STRUTS_RIGHT_END, "PLANK_STRUTS_RIGHT_END", "right-end"}, {PLANK_STRUTS_TOP_START, "PLANK_STRUTS_TOP_START", "top-start"}, {PLANK_STRUTS_TOP_END, "PLANK_STRUTS_TOP_END", "top-end"}, {PLANK_STRUTS_BOTTOM_START, "PLANK_STRUTS_BOTTOM_START", "bottom-start"}, {PLANK_STRUTS_BOTTOM_END, "PLANK_STRUTS_BOTTOM_END", "bottom-end"}, {PLANK_STRUTS_N_VALUES, "PLANK_STRUTS_N_VALUES", "n-values"}, {0, NULL, NULL}};
	GType plank_struts_type_id;
	plank_struts_type_id = g_enum_register_static ("PlankStruts", values);
	return plank_struts_type_id;
}

GType
plank_struts_get_type (void)
{
	static volatile gsize plank_struts_type_id__once = 0;
	if (g_once_init_enter (&plank_struts_type_id__once)) {
		GType plank_struts_type_id;
		plank_struts_type_id = plank_struts_get_type_once ();
		g_once_init_leave (&plank_struts_type_id__once, plank_struts_type_id);
	}
	return plank_struts_type_id__once;
}

static PlankWindowControl*
plank_window_control_construct (GType object_type)
{
	PlankWindowControl * self = NULL;
	self = (PlankWindowControl*) g_object_new (object_type, NULL);
	return self;
}

static PlankWindowControl*
plank_window_control_new (void)
{
	return plank_window_control_construct (PLANK_TYPE_WINDOW_CONTROL);
}

static void
_plank_window_control_window_manager_changed_wnck_screen_window_manager_changed (WnckScreen* _sender,
                                                                                 gpointer self)
{
	plank_window_control_window_manager_changed (_sender);
}

static void
_plank_window_control_handle_window_closed_wnck_screen_window_closed (WnckScreen* _sender,
                                                                      WnckWindow* window,
                                                                      gpointer self)
{
	plank_window_control_handle_window_closed (window);
}

void
plank_window_control_initialize (void)
{
	WnckScreen* screen = NULL;
	WnckScreen* _tmp0_;
	WnckScreen* _tmp1_;
	WnckScreen* _tmp2_;
	WnckScreen* _tmp3_;
	WnckScreen* _tmp4_;
	const gchar* _tmp5_;
	_tmp0_ = wnck_screen_get_default ();
	screen = _tmp0_;
	wnck_set_client_type (WNCK_CLIENT_TYPE_PAGER);
	gdk_error_trap_push ();
	_tmp1_ = screen;
	wnck_screen_force_update (_tmp1_);
	if (gdk_error_trap_pop () != 0) {
		g_critical ("WindowControl.vala:63: Wnck.Screen.force_update() caused a XError");
	}
	_tmp2_ = screen;
	g_signal_connect_after (_tmp2_, "window-manager-changed", (GCallback) _plank_window_control_window_manager_changed_wnck_screen_window_manager_changed, NULL);
	_tmp3_ = screen;
	g_signal_connect_after (_tmp3_, "window-closed", (GCallback) _plank_window_control_handle_window_closed_wnck_screen_window_closed, NULL);
	_tmp4_ = screen;
	_tmp5_ = wnck_screen_get_window_manager_name (_tmp4_);
	g_message ("WindowControl.vala:68: Window-manager: %s", _tmp5_);
}

static void
plank_window_control_window_manager_changed (WnckScreen* screen)
{
	const gchar* _tmp0_;
	g_return_if_fail (screen != NULL);
	gdk_error_trap_push ();
	wnck_screen_force_update (screen);
	if (gdk_error_trap_pop () != 0) {
		g_critical ("WindowControl.vala:77: Wnck.Screen.force_update() caused a XError");
	}
	_tmp0_ = wnck_screen_get_window_manager_name (screen);
	g_warning ("WindowControl.vala:79: Window-manager changed: %s", _tmp0_);
}

static void
plank_window_control_handle_window_closed (WnckWindow* window)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (window != NULL);
	if (plank_window_control_delayed_focus_timer_id > 0U) {
		WnckWindow* _tmp1_;
		_tmp1_ = plank_window_control_delayed_focus_window;
		_tmp0_ = _tmp1_ == window;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_source_remove (plank_window_control_delayed_focus_timer_id);
		plank_window_control_delayed_focus_timer_id = 0U;
		_g_object_unref0 (plank_window_control_delayed_focus_window);
		plank_window_control_delayed_focus_window = NULL;
	}
}

GdkPixbuf*
plank_window_control_get_app_icon (BamfApplication* app)
{
	GdkPixbuf* pbuf = NULL;
	GArray* xids = NULL;
	GArray* _tmp0_;
	GArray* _tmp1_;
	GdkPixbuf* _tmp17_;
	GdkPixbuf* result;
	g_return_val_if_fail (app != NULL, NULL);
	pbuf = NULL;
	wnck_screen_get_default ();
	_tmp0_ = bamf_application_get_xids (app);
	xids = _tmp0_;
	_tmp1_ = xids;
	g_warn_if_fail (_tmp1_ != NULL);
	gdk_error_trap_push ();
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				GArray* _tmp6_;
				WnckWindow* window = NULL;
				GArray* _tmp9_;
				WnckWindow* _tmp10_;
				WnckWindow* _tmp11_;
				WnckWindow* _tmp12_;
				GdkPixbuf* _tmp13_;
				WnckWindow* _tmp14_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp6_ = xids;
				if (_tmp6_ != NULL) {
					GArray* _tmp7_;
					_tmp7_ = xids;
					_tmp5_ = ((guint) i) < _tmp7_->len;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					GdkPixbuf* _tmp8_;
					_tmp8_ = pbuf;
					_tmp4_ = _tmp8_ == NULL;
				} else {
					_tmp4_ = FALSE;
				}
				if (!_tmp4_) {
					break;
				}
				_tmp9_ = xids;
				_tmp10_ = wnck_window_get ((gulong) g_array_index (_tmp9_, guint32, (guint) i));
				window = _tmp10_;
				_tmp11_ = window;
				if (_tmp11_ == NULL) {
					continue;
				}
				_tmp12_ = window;
				_tmp13_ = wnck_window_get_icon (_tmp12_);
				pbuf = _tmp13_;
				_tmp14_ = window;
				if (wnck_window_get_icon_is_fallback (_tmp14_)) {
					pbuf = NULL;
				}
				break;
			}
		}
	}
	if (gdk_error_trap_pop () != 0) {
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp15_ = bamf_view_get_name ((BamfView*) app);
		_tmp16_ = _tmp15_;
		g_critical ("WindowControl.vala:115: get_app_icon() for '%s' caused a XError", _tmp16_);
		_g_free0 (_tmp16_);
	}
	_tmp17_ = pbuf;
	result = _tmp17_;
	_g_array_unref0 (xids);
	return result;
}

GdkPixbuf*
plank_window_control_get_window_icon (BamfWindow* window)
{
	WnckWindow* w = NULL;
	WnckWindow* _tmp0_;
	GdkPixbuf* pbuf = NULL;
	WnckWindow* _tmp1_;
	WnckWindow* _tmp2_;
	WnckWindow* _tmp3_;
	GdkPixbuf* _tmp4_;
	WnckWindow* _tmp5_;
	GdkPixbuf* _tmp8_;
	GdkPixbuf* result;
	g_return_val_if_fail (window != NULL, NULL);
	_tmp0_ = wnck_window_get ((gulong) bamf_window_get_xid (window));
	w = _tmp0_;
	pbuf = NULL;
	_tmp1_ = w;
	g_warn_if_fail (_tmp1_ != NULL);
	_tmp2_ = w;
	if (_tmp2_ == NULL) {
		result = NULL;
		return result;
	}
	gdk_error_trap_push ();
	_tmp3_ = w;
	_tmp4_ = wnck_window_get_icon (_tmp3_);
	pbuf = _tmp4_;
	_tmp5_ = w;
	if (wnck_window_get_icon_is_fallback (_tmp5_)) {
		pbuf = NULL;
	}
	if (gdk_error_trap_pop () != 0) {
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = bamf_view_get_name ((BamfView*) window);
		_tmp7_ = _tmp6_;
		g_critical ("WindowControl.vala:137: get_window_icon() for '%s' caused a XError", _tmp7_);
		_g_free0 (_tmp7_);
	}
	_tmp8_ = pbuf;
	result = _tmp8_;
	return result;
}

gboolean
plank_window_control_has_maximized_window (BamfApplication* app)
{
	GArray* xids = NULL;
	GArray* _tmp0_;
	GArray* _tmp1_;
	gboolean result;
	g_return_val_if_fail (app != NULL, FALSE);
	wnck_screen_get_default ();
	_tmp0_ = bamf_application_get_xids (app);
	xids = _tmp0_;
	_tmp1_ = xids;
	g_warn_if_fail (_tmp1_ != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_ = FALSE;
				GArray* _tmp5_;
				WnckWindow* window = NULL;
				GArray* _tmp7_;
				WnckWindow* _tmp8_;
				gboolean _tmp9_ = FALSE;
				WnckWindow* _tmp10_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = xids;
				if (_tmp5_ != NULL) {
					GArray* _tmp6_;
					_tmp6_ = xids;
					_tmp4_ = ((guint) i) < _tmp6_->len;
				} else {
					_tmp4_ = FALSE;
				}
				if (!_tmp4_) {
					break;
				}
				_tmp7_ = xids;
				_tmp8_ = wnck_window_get ((gulong) g_array_index (_tmp7_, guint32, (guint) i));
				window = _tmp8_;
				_tmp10_ = window;
				if (_tmp10_ != NULL) {
					WnckWindow* _tmp11_;
					_tmp11_ = window;
					_tmp9_ = wnck_window_is_maximized (_tmp11_);
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					result = TRUE;
					_g_array_unref0 (xids);
					return result;
				}
			}
		}
	}
	result = FALSE;
	_g_array_unref0 (xids);
	return result;
}

gboolean
plank_window_control_has_minimized_window (BamfApplication* app)
{
	GArray* xids = NULL;
	GArray* _tmp0_;
	GArray* _tmp1_;
	gboolean result;
	g_return_val_if_fail (app != NULL, FALSE);
	wnck_screen_get_default ();
	_tmp0_ = bamf_application_get_xids (app);
	xids = _tmp0_;
	_tmp1_ = xids;
	g_warn_if_fail (_tmp1_ != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_ = FALSE;
				GArray* _tmp5_;
				WnckWindow* window = NULL;
				GArray* _tmp7_;
				WnckWindow* _tmp8_;
				gboolean _tmp9_ = FALSE;
				WnckWindow* _tmp10_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = xids;
				if (_tmp5_ != NULL) {
					GArray* _tmp6_;
					_tmp6_ = xids;
					_tmp4_ = ((guint) i) < _tmp6_->len;
				} else {
					_tmp4_ = FALSE;
				}
				if (!_tmp4_) {
					break;
				}
				_tmp7_ = xids;
				_tmp8_ = wnck_window_get ((gulong) g_array_index (_tmp7_, guint32, (guint) i));
				window = _tmp8_;
				_tmp10_ = window;
				if (_tmp10_ != NULL) {
					WnckWindow* _tmp11_;
					_tmp11_ = window;
					_tmp9_ = wnck_window_is_minimized (_tmp11_);
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					result = TRUE;
					_g_array_unref0 (xids);
					return result;
				}
			}
		}
	}
	result = FALSE;
	_g_array_unref0 (xids);
	return result;
}

gboolean
plank_window_control_has_window_on_workspace (BamfApplication* app,
                                              WnckWorkspace* workspace)
{
	GArray* xids = NULL;
	GArray* _tmp0_;
	GArray* _tmp1_;
	gboolean is_virtual = FALSE;
	gboolean result;
	g_return_val_if_fail (app != NULL, FALSE);
	g_return_val_if_fail (workspace != NULL, FALSE);
	wnck_screen_get_default ();
	_tmp0_ = bamf_application_get_xids (app);
	xids = _tmp0_;
	_tmp1_ = xids;
	g_warn_if_fail (_tmp1_ != NULL);
	is_virtual = wnck_workspace_is_virtual (workspace);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_ = FALSE;
				GArray* _tmp5_;
				WnckWindow* window = NULL;
				GArray* _tmp7_;
				WnckWindow* _tmp8_;
				gboolean _tmp9_ = FALSE;
				WnckWindow* _tmp10_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = xids;
				if (_tmp5_ != NULL) {
					GArray* _tmp6_;
					_tmp6_ = xids;
					_tmp4_ = ((guint) i) < _tmp6_->len;
				} else {
					_tmp4_ = FALSE;
				}
				if (!_tmp4_) {
					break;
				}
				_tmp7_ = xids;
				_tmp8_ = wnck_window_get ((gulong) g_array_index (_tmp7_, guint32, (guint) i));
				window = _tmp8_;
				_tmp10_ = window;
				if (_tmp10_ == NULL) {
					_tmp9_ = TRUE;
				} else {
					WnckWindow* _tmp11_;
					_tmp11_ = window;
					_tmp9_ = wnck_window_is_skip_tasklist (_tmp11_);
				}
				if (_tmp9_) {
					continue;
				}
				if (!is_virtual) {
					WnckWindow* _tmp12_;
					_tmp12_ = window;
					if (wnck_window_is_on_workspace (_tmp12_, workspace)) {
						result = TRUE;
						_g_array_unref0 (xids);
						return result;
					}
				} else {
					WnckWindow* _tmp13_;
					_tmp13_ = window;
					if (wnck_window_is_in_viewport (_tmp13_, workspace)) {
						result = TRUE;
						_g_array_unref0 (xids);
						return result;
					}
				}
			}
		}
	}
	result = FALSE;
	_g_array_unref0 (xids);
	return result;
}

void
plank_window_control_update_icon_regions (BamfApplication* app,
                                          GdkRectangle* rect)
{
	GArray* xids = NULL;
	GArray* _tmp0_;
	GArray* _tmp1_;
	g_return_if_fail (app != NULL);
	g_return_if_fail (rect != NULL);
	wnck_screen_get_default ();
	_tmp0_ = bamf_application_get_xids (app);
	xids = _tmp0_;
	_tmp1_ = xids;
	g_warn_if_fail (_tmp1_ != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_ = FALSE;
				GArray* _tmp5_;
				WnckWindow* window = NULL;
				GArray* _tmp7_;
				WnckWindow* _tmp8_;
				WnckWindow* _tmp9_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = xids;
				if (_tmp5_ != NULL) {
					GArray* _tmp6_;
					_tmp6_ = xids;
					_tmp4_ = ((guint) i) < _tmp6_->len;
				} else {
					_tmp4_ = FALSE;
				}
				if (!_tmp4_) {
					break;
				}
				_tmp7_ = xids;
				_tmp8_ = wnck_window_get ((gulong) g_array_index (_tmp7_, guint32, (guint) i));
				window = _tmp8_;
				_tmp9_ = window;
				if (_tmp9_ != NULL) {
					WnckWindow* _tmp10_;
					GdkRectangle _tmp11_;
					GdkRectangle _tmp12_;
					GdkRectangle _tmp13_;
					GdkRectangle _tmp14_;
					_tmp10_ = window;
					_tmp11_ = *rect;
					_tmp12_ = *rect;
					_tmp13_ = *rect;
					_tmp14_ = *rect;
					wnck_window_set_icon_geometry (_tmp10_, _tmp11_.x, _tmp12_.y, _tmp13_.width, _tmp14_.height);
				}
			}
		}
	}
	_g_array_unref0 (xids);
}

void
plank_window_control_close_all (BamfApplication* app,
                                guint32 event_time)
{
	GArray* xids = NULL;
	GArray* _tmp0_;
	GArray* _tmp1_;
	g_return_if_fail (app != NULL);
	wnck_screen_get_default ();
	_tmp0_ = bamf_application_get_xids (app);
	xids = _tmp0_;
	_tmp1_ = xids;
	g_warn_if_fail (_tmp1_ != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_ = FALSE;
				GArray* _tmp5_;
				WnckWindow* window = NULL;
				GArray* _tmp7_;
				WnckWindow* _tmp8_;
				gboolean _tmp9_ = FALSE;
				WnckWindow* _tmp10_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = xids;
				if (_tmp5_ != NULL) {
					GArray* _tmp6_;
					_tmp6_ = xids;
					_tmp4_ = ((guint) i) < _tmp6_->len;
				} else {
					_tmp4_ = FALSE;
				}
				if (!_tmp4_) {
					break;
				}
				_tmp7_ = xids;
				_tmp8_ = wnck_window_get ((gulong) g_array_index (_tmp7_, guint32, (guint) i));
				window = _tmp8_;
				_tmp10_ = window;
				if (_tmp10_ != NULL) {
					WnckWindow* _tmp11_;
					_tmp11_ = window;
					_tmp9_ = !wnck_window_is_skip_tasklist (_tmp11_);
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					WnckWindow* _tmp12_;
					_tmp12_ = window;
					wnck_window_close (_tmp12_, event_time);
				}
			}
		}
	}
	_g_array_unref0 (xids);
}

void
plank_window_control_focus_window (BamfWindow* window,
                                   guint32 event_time)
{
	WnckWindow* w = NULL;
	WnckWindow* _tmp0_;
	WnckWindow* _tmp1_;
	WnckWindow* _tmp2_;
	WnckWindow* _tmp3_;
	g_return_if_fail (window != NULL);
	wnck_screen_get_default ();
	_tmp0_ = wnck_window_get ((gulong) bamf_window_get_xid (window));
	w = _tmp0_;
	_tmp1_ = w;
	g_warn_if_fail (_tmp1_ != NULL);
	_tmp2_ = w;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = w;
	plank_window_control_center_and_focus_window (_tmp3_, event_time);
}

static void
plank_window_control_focus_window_by_xid (guint32 xid,
                                          guint32 event_time)
{
	WnckWindow* w = NULL;
	WnckWindow* _tmp0_;
	WnckWindow* _tmp1_;
	WnckWindow* _tmp2_;
	WnckWindow* _tmp3_;
	wnck_screen_get_default ();
	_tmp0_ = wnck_window_get ((gulong) xid);
	w = _tmp0_;
	_tmp1_ = w;
	g_warn_if_fail (_tmp1_ != NULL);
	_tmp2_ = w;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = w;
	plank_window_control_center_and_focus_window (_tmp3_, event_time);
}

static gint
plank_window_control_find_active_xid_index (GArray* xids)
{
	gint i = 0;
	gint result;
	i = 0;
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp2_ = FALSE;
			WnckWindow* window = NULL;
			WnckWindow* _tmp3_;
			gboolean _tmp4_ = FALSE;
			WnckWindow* _tmp5_;
			if (!_tmp0_) {
				gint _tmp1_;
				_tmp1_ = i;
				i = _tmp1_ + 1;
			}
			_tmp0_ = FALSE;
			if (xids != NULL) {
				_tmp2_ = ((guint) i) < xids->len;
			} else {
				_tmp2_ = FALSE;
			}
			if (!_tmp2_) {
				break;
			}
			_tmp3_ = wnck_window_get ((gulong) g_array_index (xids, guint32, (guint) i));
			window = _tmp3_;
			_tmp5_ = window;
			if (_tmp5_ != NULL) {
				WnckWindow* _tmp6_;
				_tmp6_ = window;
				_tmp4_ = wnck_window_is_active (_tmp6_);
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				break;
			}
		}
	}
	result = i;
	return result;
}

void
plank_window_control_focus_previous (BamfApplication* app,
                                     guint32 event_time)
{
	GArray* xids = NULL;
	GArray* _tmp0_;
	GArray* _tmp1_;
	GArray* _tmp2_;
	gint i = 0;
	GArray* _tmp3_;
	gint _tmp4_ = 0;
	GArray* _tmp5_;
	GArray* _tmp7_;
	g_return_if_fail (app != NULL);
	wnck_screen_get_default ();
	_tmp0_ = bamf_application_get_xids (app);
	xids = _tmp0_;
	_tmp1_ = xids;
	g_warn_if_fail (_tmp1_ != NULL);
	_tmp2_ = xids;
	if (_tmp2_ == NULL) {
		_g_array_unref0 (xids);
		return;
	}
	_tmp3_ = xids;
	i = plank_window_control_find_active_xid_index (_tmp3_);
	_tmp5_ = xids;
	if (((guint) i) < _tmp5_->len) {
		_tmp4_ = i - 1;
	} else {
		_tmp4_ = 0;
	}
	i = _tmp4_;
	if (i < 0) {
		GArray* _tmp6_;
		_tmp6_ = xids;
		i = ((gint) _tmp6_->len) - 1;
	}
	_tmp7_ = xids;
	plank_window_control_focus_window_by_xid (g_array_index (_tmp7_, guint32, (guint) i), event_time);
	_g_array_unref0 (xids);
}

void
plank_window_control_focus_next (BamfApplication* app,
                                 guint32 event_time)
{
	GArray* xids = NULL;
	GArray* _tmp0_;
	GArray* _tmp1_;
	GArray* _tmp2_;
	gint i = 0;
	GArray* _tmp3_;
	gint _tmp4_ = 0;
	GArray* _tmp5_;
	GArray* _tmp6_;
	GArray* _tmp7_;
	g_return_if_fail (app != NULL);
	wnck_screen_get_default ();
	_tmp0_ = bamf_application_get_xids (app);
	xids = _tmp0_;
	_tmp1_ = xids;
	g_warn_if_fail (_tmp1_ != NULL);
	_tmp2_ = xids;
	if (_tmp2_ == NULL) {
		_g_array_unref0 (xids);
		return;
	}
	_tmp3_ = xids;
	i = plank_window_control_find_active_xid_index (_tmp3_);
	_tmp5_ = xids;
	if (((guint) i) < _tmp5_->len) {
		_tmp4_ = i + 1;
	} else {
		_tmp4_ = 0;
	}
	i = _tmp4_;
	_tmp6_ = xids;
	if (((guint) i) == _tmp6_->len) {
		i = 0;
	}
	_tmp7_ = xids;
	plank_window_control_focus_window_by_xid (g_array_index (_tmp7_, guint32, (guint) i), event_time);
	_g_array_unref0 (xids);
}

void
plank_window_control_minimize (BamfApplication* app)
{
	GList* _tmp0_;
	g_return_if_fail (app != NULL);
	_tmp0_ = plank_window_control_get_ordered_window_stack (app);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp0_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			WnckWindow* window = NULL;
			window = (WnckWindow*) window_it->data;
			{
				WnckWorkspace* active_workspace = NULL;
				WnckWindow* _tmp1_;
				WnckScreen* _tmp2_;
				WnckWorkspace* _tmp3_;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				WnckWindow* _tmp6_;
				_tmp1_ = window;
				_tmp2_ = wnck_window_get_screen (_tmp1_);
				_tmp3_ = wnck_screen_get_active_workspace (_tmp2_);
				active_workspace = _tmp3_;
				_tmp6_ = window;
				if (!wnck_window_is_minimized (_tmp6_)) {
					WnckWorkspace* _tmp7_;
					_tmp7_ = active_workspace;
					_tmp5_ = _tmp7_ != NULL;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					WnckWindow* _tmp8_;
					WnckWorkspace* _tmp9_;
					_tmp8_ = window;
					_tmp9_ = active_workspace;
					_tmp4_ = wnck_window_is_in_viewport (_tmp8_, _tmp9_);
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					WnckWindow* _tmp10_;
					_tmp10_ = window;
					wnck_window_minimize (_tmp10_);
					g_usleep ((gulong) PLANK_WINDOW_CONTROL_WINDOW_GROUP_DELAY);
				}
			}
		}
		(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
	}
}

void
plank_window_control_restore (BamfApplication* app,
                              guint32 event_time)
{
	GList* stack = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (app != NULL);
	_tmp0_ = plank_window_control_get_ordered_window_stack (app);
	stack = _tmp0_;
	stack = g_list_reverse (stack);
	_tmp1_ = stack;
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp1_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			WnckWindow* window = NULL;
			window = (WnckWindow*) window_it->data;
			{
				WnckWorkspace* active_workspace = NULL;
				WnckWindow* _tmp2_;
				WnckScreen* _tmp3_;
				WnckWorkspace* _tmp4_;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				WnckWindow* _tmp7_;
				_tmp2_ = window;
				_tmp3_ = wnck_window_get_screen (_tmp2_);
				_tmp4_ = wnck_screen_get_active_workspace (_tmp3_);
				active_workspace = _tmp4_;
				_tmp7_ = window;
				if (wnck_window_is_minimized (_tmp7_)) {
					WnckWorkspace* _tmp8_;
					_tmp8_ = active_workspace;
					_tmp6_ = _tmp8_ != NULL;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					WnckWindow* _tmp9_;
					WnckWorkspace* _tmp10_;
					_tmp9_ = window;
					_tmp10_ = active_workspace;
					_tmp5_ = wnck_window_is_in_viewport (_tmp9_, _tmp10_);
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					WnckWindow* _tmp11_;
					_tmp11_ = window;
					wnck_window_unminimize (_tmp11_, event_time);
					g_usleep ((gulong) PLANK_WINDOW_CONTROL_WINDOW_GROUP_DELAY);
				}
			}
		}
	}
	(stack == NULL) ? NULL : (stack = (g_list_free (stack), NULL));
}

void
plank_window_control_maximize (BamfApplication* app)
{
	GList* _tmp0_;
	g_return_if_fail (app != NULL);
	_tmp0_ = plank_window_control_get_ordered_window_stack (app);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp0_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			WnckWindow* window = NULL;
			window = (WnckWindow*) window_it->data;
			{
				WnckWindow* _tmp1_;
				_tmp1_ = window;
				if (!wnck_window_is_maximized (_tmp1_)) {
					WnckWindow* _tmp2_;
					_tmp2_ = window;
					wnck_window_maximize (_tmp2_);
				}
			}
		}
		(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
	}
}

void
plank_window_control_unmaximize (BamfApplication* app)
{
	GList* _tmp0_;
	g_return_if_fail (app != NULL);
	_tmp0_ = plank_window_control_get_ordered_window_stack (app);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp0_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			WnckWindow* window = NULL;
			window = (WnckWindow*) window_it->data;
			{
				WnckWindow* _tmp1_;
				_tmp1_ = window;
				if (wnck_window_is_maximized (_tmp1_)) {
					WnckWindow* _tmp2_;
					_tmp2_ = window;
					wnck_window_unmaximize (_tmp2_);
				}
			}
		}
		(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
	}
}

GList*
plank_window_control_get_ordered_window_stack (BamfApplication* app)
{
	GList* windows = NULL;
	GArray* xids = NULL;
	GArray* _tmp0_;
	GArray* _tmp1_;
	GArray* _tmp2_;
	GList* stack = NULL;
	WnckScreen* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	GList* result;
	g_return_val_if_fail (app != NULL, NULL);
	windows = NULL;
	wnck_screen_get_default ();
	_tmp0_ = bamf_application_get_xids (app);
	xids = _tmp0_;
	_tmp1_ = xids;
	g_warn_if_fail (_tmp1_ != NULL);
	_tmp2_ = xids;
	if (_tmp2_ == NULL) {
		result = windows;
		_g_array_unref0 (xids);
		return result;
	}
	_tmp3_ = wnck_screen_get_default ();
	_tmp4_ = wnck_screen_get_windows_stacked (_tmp3_);
	stack = _tmp4_;
	_tmp5_ = stack;
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp5_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			WnckWindow* window = NULL;
			window = (WnckWindow*) window_it->data;
			{
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							GArray* _tmp8_;
							GArray* _tmp9_;
							WnckWindow* _tmp10_;
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = j;
								j = _tmp7_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp8_ = xids;
							if (!(((guint) j) < _tmp8_->len)) {
								break;
							}
							_tmp9_ = xids;
							_tmp10_ = window;
							if (((gulong) g_array_index (_tmp9_, guint32, (guint) j)) == wnck_window_get_xid (_tmp10_)) {
								WnckWindow* _tmp11_;
								_tmp11_ = window;
								windows = g_list_append (windows, _tmp11_);
							}
						}
					}
				}
			}
		}
	}
	result = windows;
	_g_array_unref0 (xids);
	return result;
}

void
plank_window_control_smart_focus (BamfApplication* app,
                                  guint32 event_time)
{
	GList* windows = NULL;
	GList* _tmp0_;
	gboolean not_in_viewport = FALSE;
	gboolean urgent = FALSE;
	GList* _tmp1_;
	gboolean _tmp12_ = FALSE;
	GList* _tmp19_;
	GList* _tmp35_;
	GList* _tmp56_;
	GList* _tmp68_;
	gconstpointer _tmp69_;
	GList* _tmp70_;
	g_return_if_fail (app != NULL);
	_tmp0_ = plank_window_control_get_ordered_window_stack (app);
	windows = _tmp0_;
	not_in_viewport = TRUE;
	urgent = FALSE;
	_tmp1_ = windows;
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp1_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			WnckWindow* window = NULL;
			window = (WnckWindow*) window_it->data;
			{
				WnckWorkspace* active_workspace = NULL;
				WnckWindow* _tmp2_;
				WnckScreen* _tmp3_;
				WnckWorkspace* _tmp4_;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				WnckWindow* _tmp7_;
				WnckWindow* _tmp11_;
				_tmp2_ = window;
				_tmp3_ = wnck_window_get_screen (_tmp2_);
				_tmp4_ = wnck_screen_get_active_workspace (_tmp3_);
				active_workspace = _tmp4_;
				_tmp7_ = window;
				if (!wnck_window_is_skip_tasklist (_tmp7_)) {
					WnckWorkspace* _tmp8_;
					_tmp8_ = active_workspace;
					_tmp6_ = _tmp8_ != NULL;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					WnckWindow* _tmp9_;
					WnckWorkspace* _tmp10_;
					_tmp9_ = window;
					_tmp10_ = active_workspace;
					_tmp5_ = wnck_window_is_in_viewport (_tmp9_, _tmp10_);
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					not_in_viewport = FALSE;
				}
				_tmp11_ = window;
				if (wnck_window_needs_attention (_tmp11_)) {
					urgent = TRUE;
				}
			}
		}
	}
	if (not_in_viewport) {
		_tmp12_ = TRUE;
	} else {
		_tmp12_ = urgent;
	}
	if (_tmp12_) {
		GList* _tmp13_;
		_tmp13_ = windows;
		{
			GList* window_collection = NULL;
			GList* window_it = NULL;
			window_collection = _tmp13_;
			for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
				WnckWindow* window = NULL;
				window = (WnckWindow*) window_it->data;
				{
					gboolean _tmp14_ = FALSE;
					WnckWindow* _tmp16_;
					if (urgent) {
						WnckWindow* _tmp15_;
						_tmp15_ = window;
						_tmp14_ = !wnck_window_needs_attention (_tmp15_);
					} else {
						_tmp14_ = FALSE;
					}
					if (_tmp14_) {
						continue;
					}
					_tmp16_ = window;
					if (!wnck_window_is_skip_tasklist (_tmp16_)) {
						WnckWindow* _tmp17_;
						GList* _tmp18_;
						_tmp17_ = window;
						_tmp18_ = windows;
						plank_window_control_intelligent_focus_off_viewport_window (_tmp17_, _tmp18_, event_time);
						(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
						return;
					}
				}
			}
		}
	}
	_tmp19_ = windows;
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp19_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			WnckWindow* window = NULL;
			window = (WnckWindow*) window_it->data;
			{
				WnckWorkspace* active_workspace = NULL;
				WnckWindow* _tmp20_;
				WnckScreen* _tmp21_;
				WnckWorkspace* _tmp22_;
				gboolean _tmp23_ = FALSE;
				gboolean _tmp24_ = FALSE;
				WnckWindow* _tmp25_;
				_tmp20_ = window;
				_tmp21_ = wnck_window_get_screen (_tmp20_);
				_tmp22_ = wnck_screen_get_active_workspace (_tmp21_);
				active_workspace = _tmp22_;
				_tmp25_ = window;
				if (wnck_window_is_minimized (_tmp25_)) {
					WnckWorkspace* _tmp26_;
					_tmp26_ = active_workspace;
					_tmp24_ = _tmp26_ != NULL;
				} else {
					_tmp24_ = FALSE;
				}
				if (_tmp24_) {
					WnckWindow* _tmp27_;
					WnckWorkspace* _tmp28_;
					_tmp27_ = window;
					_tmp28_ = active_workspace;
					_tmp23_ = wnck_window_is_in_viewport (_tmp27_, _tmp28_);
				} else {
					_tmp23_ = FALSE;
				}
				if (_tmp23_) {
					GList* _tmp29_;
					_tmp29_ = windows;
					{
						GList* w_collection = NULL;
						GList* w_it = NULL;
						w_collection = _tmp29_;
						for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
							WnckWindow* w = NULL;
							w = (WnckWindow*) w_it->data;
							{
								gboolean _tmp30_ = FALSE;
								WnckWindow* _tmp31_;
								_tmp31_ = w;
								if (wnck_window_is_minimized (_tmp31_)) {
									WnckWindow* _tmp32_;
									WnckWorkspace* _tmp33_;
									_tmp32_ = w;
									_tmp33_ = active_workspace;
									_tmp30_ = wnck_window_is_in_viewport (_tmp32_, _tmp33_);
								} else {
									_tmp30_ = FALSE;
								}
								if (_tmp30_) {
									WnckWindow* _tmp34_;
									_tmp34_ = w;
									wnck_window_unminimize (_tmp34_, event_time);
									g_usleep ((gulong) PLANK_WINDOW_CONTROL_WINDOW_GROUP_DELAY);
								}
							}
						}
					}
					(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
					return;
				}
			}
		}
	}
	_tmp35_ = windows;
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp35_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			WnckWindow* window = NULL;
			window = (WnckWindow*) window_it->data;
			{
				WnckWorkspace* active_workspace = NULL;
				WnckWindow* _tmp36_;
				WnckScreen* _tmp37_;
				WnckWorkspace* _tmp38_;
				gboolean _tmp39_ = FALSE;
				gboolean _tmp40_ = FALSE;
				gboolean _tmp41_ = FALSE;
				WnckWindow* _tmp42_;
				_tmp36_ = window;
				_tmp37_ = wnck_window_get_screen (_tmp36_);
				_tmp38_ = wnck_screen_get_active_workspace (_tmp37_);
				active_workspace = _tmp38_;
				_tmp42_ = window;
				if (wnck_window_is_active (_tmp42_)) {
					WnckWorkspace* _tmp43_;
					_tmp43_ = active_workspace;
					_tmp41_ = _tmp43_ != NULL;
				} else {
					_tmp41_ = FALSE;
				}
				if (_tmp41_) {
					WnckWindow* _tmp44_;
					WnckWorkspace* _tmp45_;
					_tmp44_ = window;
					_tmp45_ = active_workspace;
					_tmp40_ = wnck_window_is_in_viewport (_tmp44_, _tmp45_);
				} else {
					_tmp40_ = FALSE;
				}
				if (_tmp40_) {
					_tmp39_ = TRUE;
				} else {
					WnckWindow* _tmp46_;
					WnckWindow* _tmp47_;
					WnckScreen* _tmp48_;
					WnckWindow* _tmp49_;
					_tmp46_ = window;
					_tmp47_ = window;
					_tmp48_ = wnck_window_get_screen (_tmp47_);
					_tmp49_ = wnck_screen_get_active_window (_tmp48_);
					_tmp39_ = _tmp46_ == _tmp49_;
				}
				if (_tmp39_) {
					GList* _tmp50_;
					_tmp50_ = windows;
					{
						GList* w_collection = NULL;
						GList* w_it = NULL;
						w_collection = _tmp50_;
						for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
							WnckWindow* w = NULL;
							w = (WnckWindow*) w_it->data;
							{
								gboolean _tmp51_ = FALSE;
								WnckWindow* _tmp52_;
								_tmp52_ = w;
								if (!wnck_window_is_minimized (_tmp52_)) {
									WnckWindow* _tmp53_;
									WnckWorkspace* _tmp54_;
									_tmp53_ = w;
									_tmp54_ = active_workspace;
									_tmp51_ = wnck_window_is_in_viewport (_tmp53_, _tmp54_);
								} else {
									_tmp51_ = FALSE;
								}
								if (_tmp51_) {
									WnckWindow* _tmp55_;
									_tmp55_ = w;
									wnck_window_minimize (_tmp55_);
									g_usleep ((gulong) PLANK_WINDOW_CONTROL_WINDOW_GROUP_DELAY);
								}
							}
						}
					}
					(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
					return;
				}
			}
		}
	}
	_tmp56_ = windows;
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp56_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			WnckWindow* window = NULL;
			window = (WnckWindow*) window_it->data;
			{
				WnckWorkspace* active_workspace = NULL;
				WnckWindow* _tmp57_;
				WnckScreen* _tmp58_;
				WnckWorkspace* _tmp59_;
				gboolean _tmp60_ = FALSE;
				WnckWorkspace* _tmp61_;
				_tmp57_ = window;
				_tmp58_ = wnck_window_get_screen (_tmp57_);
				_tmp59_ = wnck_screen_get_active_workspace (_tmp58_);
				active_workspace = _tmp59_;
				_tmp61_ = active_workspace;
				if (_tmp61_ != NULL) {
					WnckWindow* _tmp62_;
					WnckWorkspace* _tmp63_;
					_tmp62_ = window;
					_tmp63_ = active_workspace;
					_tmp60_ = wnck_window_is_in_viewport (_tmp62_, _tmp63_);
				} else {
					_tmp60_ = FALSE;
				}
				if (_tmp60_) {
					GList* _tmp64_;
					_tmp64_ = windows;
					{
						GList* w_collection = NULL;
						GList* w_it = NULL;
						w_collection = _tmp64_;
						for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
							WnckWindow* w = NULL;
							w = (WnckWindow*) w_it->data;
							{
								WnckWindow* _tmp65_;
								WnckWorkspace* _tmp66_;
								_tmp65_ = w;
								_tmp66_ = active_workspace;
								if (wnck_window_is_in_viewport (_tmp65_, _tmp66_)) {
									WnckWindow* _tmp67_;
									_tmp67_ = w;
									plank_window_control_center_and_focus_window (_tmp67_, event_time);
									g_usleep ((gulong) PLANK_WINDOW_CONTROL_WINDOW_GROUP_DELAY);
								}
							}
						}
					}
					(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
					return;
				}
			}
		}
	}
	_tmp68_ = windows;
	_tmp69_ = g_list_nth_data (_tmp68_, (guint) 0);
	_tmp70_ = windows;
	plank_window_control_intelligent_focus_off_viewport_window ((WnckWindow*) _tmp69_, _tmp70_, event_time);
	(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		g_slice_free (Block1Data, _data1_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
__lambda4_ (Block1Data* _data1_)
{
	WnckWindow* _tmp0_;
	gboolean result;
	plank_window_control_delayed_focus_timer_id = 0U;
	_tmp0_ = plank_window_control_delayed_focus_window;
	wnck_window_activate (_tmp0_, _data1_->event_time);
	_g_object_unref0 (plank_window_control_delayed_focus_window);
	plank_window_control_delayed_focus_window = NULL;
	result = FALSE;
	return result;
}

static gboolean
___lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda4_ (self);
	return result;
}

static void
plank_window_control_intelligent_focus_off_viewport_window (WnckWindow* targetWindow,
                                                            GList* additional_windows,
                                                            guint32 event_time)
{
	Block1Data* _data1_;
	WnckWindow* _tmp5_;
	g_return_if_fail (targetWindow != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->event_time = event_time;
	additional_windows = g_list_reverse (additional_windows);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = additional_windows;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			WnckWindow* window = NULL;
			window = (WnckWindow*) window_it->data;
			{
				WnckWindow* _tmp0_;
				gboolean _tmp1_ = FALSE;
				WnckWindow* _tmp2_;
				_tmp0_ = window;
				if (_tmp0_ == targetWindow) {
					continue;
				}
				_tmp2_ = window;
				if (!wnck_window_is_minimized (_tmp2_)) {
					WnckWindow* _tmp3_;
					_tmp3_ = window;
					_tmp1_ = plank_window_control_windows_share_viewport (targetWindow, _tmp3_);
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					WnckWindow* _tmp4_;
					_tmp4_ = window;
					plank_window_control_center_and_focus_window (_tmp4_, _data1_->event_time);
					g_usleep ((gulong) PLANK_WINDOW_CONTROL_WINDOW_GROUP_DELAY);
				}
			}
		}
	}
	plank_window_control_center_and_focus_window (targetWindow, _data1_->event_time);
	if (g_list_length (additional_windows) <= ((guint) 1)) {
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	if (plank_window_control_delayed_focus_timer_id > 0U) {
		g_source_remove (plank_window_control_delayed_focus_timer_id);
	}
	_tmp5_ = _g_object_ref0 (targetWindow);
	_g_object_unref0 (plank_window_control_delayed_focus_window);
	plank_window_control_delayed_focus_window = _tmp5_;
	plank_window_control_delayed_focus_timer_id = gdk_threads_add_timeout (PLANK_WINDOW_CONTROL_VIEWPORT_CHANGE_DELAY, ___lambda4__gsource_func, _data1_);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static gboolean
plank_window_control_windows_share_viewport (WnckWindow* first,
                                             WnckWindow* second)
{
	gboolean _tmp0_ = FALSE;
	WnckWorkspace* wksp = NULL;
	WnckWorkspace* _tmp1_;
	WnckWorkspace* _tmp2_;
	WnckWorkspace* _tmp4_;
	GdkRectangle firstGeo = {0};
	GdkRectangle _tmp5_ = {0};
	GdkRectangle secondGeo = {0};
	GdkRectangle _tmp6_ = {0};
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	WnckWorkspace* _tmp15_;
	WnckWorkspace* _tmp16_;
	WnckWorkspace* _tmp17_;
	WnckWorkspace* _tmp18_;
	gint viewportWidth = 0;
	WnckScreen* _tmp19_;
	gint viewportHeight = 0;
	WnckScreen* _tmp20_;
	gint firstViewportX = 0;
	GdkRectangle _tmp21_;
	GdkRectangle _tmp22_;
	gint firstViewportY = 0;
	GdkRectangle _tmp23_;
	GdkRectangle _tmp24_;
	GdkRectangle viewpRect = {0};
	GdkRectangle _tmp25_ = {0};
	GdkRectangle _tmp26_;
	gboolean result;
	if (first == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = second == NULL;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = wnck_window_get_workspace (first);
	wksp = _tmp1_;
	_tmp2_ = wksp;
	if (_tmp2_ == NULL) {
		WnckWorkspace* _tmp3_;
		_tmp3_ = wnck_window_get_workspace (second);
		wksp = _tmp3_;
	}
	_tmp4_ = wksp;
	if (_tmp4_ == NULL) {
		result = FALSE;
		return result;
	}
	firstGeo = _tmp5_;
	secondGeo = _tmp6_;
	wnck_window_get_geometry (first, &_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_);
	firstGeo.x = _tmp7_;
	firstGeo.y = _tmp8_;
	firstGeo.width = _tmp9_;
	firstGeo.height = _tmp10_;
	wnck_window_get_geometry (second, &_tmp11_, &_tmp12_, &_tmp13_, &_tmp14_);
	secondGeo.x = _tmp11_;
	secondGeo.y = _tmp12_;
	secondGeo.width = _tmp13_;
	secondGeo.height = _tmp14_;
	_tmp15_ = wksp;
	firstGeo.x = firstGeo.x + wnck_workspace_get_viewport_x (_tmp15_);
	_tmp16_ = wksp;
	firstGeo.y = firstGeo.y + wnck_workspace_get_viewport_y (_tmp16_);
	_tmp17_ = wksp;
	secondGeo.x = secondGeo.x + wnck_workspace_get_viewport_x (_tmp17_);
	_tmp18_ = wksp;
	secondGeo.y = secondGeo.y + wnck_workspace_get_viewport_y (_tmp18_);
	_tmp19_ = wnck_window_get_screen (first);
	viewportWidth = wnck_screen_get_width (_tmp19_);
	_tmp20_ = wnck_window_get_screen (first);
	viewportHeight = wnck_screen_get_height (_tmp20_);
	_tmp21_ = firstGeo;
	_tmp22_ = firstGeo;
	firstViewportX = ((_tmp21_.x + (_tmp22_.width / 2)) / viewportWidth) * viewportWidth;
	_tmp23_ = firstGeo;
	_tmp24_ = firstGeo;
	firstViewportY = ((_tmp23_.y + (_tmp24_.height / 2)) / viewportHeight) * viewportHeight;
	_tmp25_.x = firstViewportX;
	_tmp25_.y = firstViewportY;
	_tmp25_.width = viewportWidth;
	_tmp25_.height = viewportHeight;
	viewpRect = _tmp25_;
	_tmp26_ = secondGeo;
	result = gdk_rectangle_intersect (&viewpRect, &_tmp26_, NULL);
	return result;
}

static void
plank_window_control_center_and_focus_window (WnckWindow* w,
                                              guint32 event_time)
{
	WnckWorkspace* workspace = NULL;
	WnckWorkspace* _tmp0_;
	gboolean _tmp1_ = FALSE;
	WnckWorkspace* _tmp2_;
	g_return_if_fail (w != NULL);
	_tmp0_ = wnck_window_get_workspace (w);
	workspace = _tmp0_;
	_tmp2_ = workspace;
	if (_tmp2_ != NULL) {
		WnckWorkspace* _tmp3_;
		WnckScreen* _tmp4_;
		WnckWorkspace* _tmp5_;
		_tmp3_ = workspace;
		_tmp4_ = wnck_window_get_screen (w);
		_tmp5_ = wnck_screen_get_active_workspace (_tmp4_);
		_tmp1_ = _tmp3_ != _tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		WnckWorkspace* _tmp6_;
		_tmp6_ = workspace;
		wnck_workspace_activate (_tmp6_, event_time);
	}
	if (wnck_window_is_minimized (w)) {
		wnck_window_unminimize (w, event_time);
	}
	wnck_window_activate_transient (w, event_time);
}

void
plank_window_control_get_easy_geometry (WnckWindow* w,
                                        GdkRectangle* result)
{
	GdkRectangle geo = {0};
	GdkRectangle _tmp0_ = {0};
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	g_return_if_fail (w != NULL);
	geo = _tmp0_;
	wnck_window_get_geometry (w, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_);
	geo.x = _tmp1_;
	geo.y = _tmp2_;
	geo.width = _tmp3_;
	geo.height = _tmp4_;
	*result = geo;
	return;
}

static void
plank_window_control_class_init (PlankWindowControlClass * klass,
                                 gpointer klass_data)
{
	plank_window_control_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = plank_window_control_finalize;
}

static void
plank_window_control_instance_init (PlankWindowControl * self,
                                    gpointer klass)
{
}

static void
plank_window_control_finalize (GObject * obj)
{
	PlankWindowControl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_WINDOW_CONTROL, PlankWindowControl);
	G_OBJECT_CLASS (plank_window_control_parent_class)->finalize (obj);
}

static GType
plank_window_control_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankWindowControlClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_window_control_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankWindowControl), 0, (GInstanceInitFunc) plank_window_control_instance_init, NULL };
	GType plank_window_control_type_id;
	plank_window_control_type_id = g_type_register_static (G_TYPE_OBJECT, "PlankWindowControl", &g_define_type_info, 0);
	return plank_window_control_type_id;
}

GType
plank_window_control_get_type (void)
{
	static volatile gsize plank_window_control_type_id__once = 0;
	if (g_once_init_enter (&plank_window_control_type_id__once)) {
		GType plank_window_control_type_id;
		plank_window_control_type_id = plank_window_control_get_type_once ();
		g_once_init_leave (&plank_window_control_type_id__once, plank_window_control_type_id);
	}
	return plank_window_control_type_id__once;
}

