/* PositionManager.c generated by valac 0.56.17, the Vala compiler
 * generated from PositionManager.vala, do not modify */

/**/
/*  Copyright (C) 2012 Robert Dyer, Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <glib.h>
#include <gdk/gdk.h>
#include <gee.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-gobject.h>
#include "plank-internal.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLANK_POSITION_MANAGER_0_PROPERTY,
	PLANK_POSITION_MANAGER_CONTROLLER_PROPERTY,
	PLANK_POSITION_MANAGER_SCREEN_IS_COMPOSITED_PROPERTY,
	PLANK_POSITION_MANAGER_LINE_WIDTH_PROPERTY,
	PLANK_POSITION_MANAGER_ICON_SIZE_PROPERTY,
	PLANK_POSITION_MANAGER_ZOOM_ICON_SIZE_PROPERTY,
	PLANK_POSITION_MANAGER_POSITION_PROPERTY,
	PLANK_POSITION_MANAGER_ALIGNMENT_PROPERTY,
	PLANK_POSITION_MANAGER_ITEMS_ALIGNMENT_PROPERTY,
	PLANK_POSITION_MANAGER_OFFSET_PROPERTY,
	PLANK_POSITION_MANAGER_INDICATOR_SIZE_PROPERTY,
	PLANK_POSITION_MANAGER_ICON_SHADOW_SIZE_PROPERTY,
	PLANK_POSITION_MANAGER_GLOW_SIZE_PROPERTY,
	PLANK_POSITION_MANAGER_HORIZ_PADDING_PROPERTY,
	PLANK_POSITION_MANAGER_TOP_PADDING_PROPERTY,
	PLANK_POSITION_MANAGER_BOTTOM_PADDING_PROPERTY,
	PLANK_POSITION_MANAGER_ITEM_PADDING_PROPERTY,
	PLANK_POSITION_MANAGER_URGENT_BOUNCE_HEIGHT_PROPERTY,
	PLANK_POSITION_MANAGER_LAUNCH_BOUNCE_HEIGHT_PROPERTY,
	PLANK_POSITION_MANAGER_MAX_ITEM_COUNT_PROPERTY,
	PLANK_POSITION_MANAGER_NUM_PROPERTIES
};
static GParamSpec* plank_position_manager_properties[PLANK_POSITION_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _plank_dock_item_draw_value_unref0(var) ((var == NULL) ? NULL : (var = (plank_dock_item_draw_value_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PlankPositionManagerPrivate {
	PlankDockController* _controller;
	gboolean _screen_is_composited;
	GdkRectangle static_dock_region;
	GeeHashMap* draw_values;
	GdkRectangle monitor_geo;
	gint window_scale_factor;
	gint _LineWidth;
	gint _IconSize;
	gint _ZoomIconSize;
	GtkPositionType _Position;
	GtkAlign _Alignment;
	GtkAlign _ItemsAlignment;
	gint _Offset;
	gint _IndicatorSize;
	gint _IconShadowSize;
	gint _GlowSize;
	gint _HorizPadding;
	gint _TopPadding;
	gint _BottomPadding;
	gint _ItemPadding;
	gint _UrgentBounceHeight;
	gint _LaunchBounceHeight;
	gint items_width;
	gint items_offset;
	gint top_offset;
	gint bottom_offset;
	gint extra_hide_offset;
	gint win_x;
	gint win_y;
	gint VisibleDockHeight;
	gint DockHeight;
	gint DockBackgroundHeight;
	gint VisibleDockWidth;
	gint DockWidth;
	gint DockBackgroundWidth;
	gdouble ZoomPercent;
	GdkRectangle background_rect;
	gint _MaxItemCount;
	gint _MaxIconSize;
};

static gint PlankPositionManager_private_offset;
static gpointer plank_position_manager_parent_class = NULL;

static PlankDockController* plank_position_manager_get_controller (PlankPositionManager* self);
static void plank_position_manager_screen_changed (PlankPositionManager* self,
                                            GdkScreen* screen);
static void _plank_position_manager_screen_changed_gdk_screen_monitors_changed (GdkScreen* _sender,
                                                                         gpointer self);
static void _plank_position_manager_screen_changed_gdk_screen_size_changed (GdkScreen* _sender,
                                                                     gpointer self);
static void plank_position_manager_screen_composited_changed (PlankPositionManager* self,
                                                       GdkScreen* screen);
static void _plank_position_manager_screen_composited_changed_gdk_screen_composited_changed (GdkScreen* _sender,
                                                                                      gpointer self);
static void plank_position_manager_prefs_changed (PlankPositionManager* self,
                                           GObject* prefs,
                                           GParamSpec* prop);
static void _plank_position_manager_prefs_changed_g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static gint plank_position_manager_find_monitor_number (GdkScreen* screen,
                                                 const gchar* plug_name);
static void plank_position_manager_set_screen_is_composited (PlankPositionManager* self,
                                                      gboolean value);
static void plank_position_manager_prefs_monitor_changed (PlankPositionManager* self);
static void plank_position_manager_prefs_zoom_changed (PlankPositionManager* self);
static void plank_position_manager_update_dimensions (PlankPositionManager* self);
static void plank_position_manager_update_caches (PlankPositionManager* self,
                                           PlankDockTheme* theme);
static void plank_position_manager_update_max_icon_size (PlankPositionManager* self,
                                                  PlankDockTheme* theme);
static void plank_position_manager_set_Position (PlankPositionManager* self,
                                          GtkPositionType value);
static void plank_position_manager_set_Alignment (PlankPositionManager* self,
                                           GtkAlign value);
static void plank_position_manager_set_ItemsAlignment (PlankPositionManager* self,
                                                GtkAlign value);
static void plank_position_manager_set_Offset (PlankPositionManager* self,
                                        gint value);
static gint plank_position_manager_get_MaxIconSize (PlankPositionManager* self);
static void plank_position_manager_set_IconSize (PlankPositionManager* self,
                                          gint value);
static void plank_position_manager_set_ZoomIconSize (PlankPositionManager* self,
                                              gint value);
static void plank_position_manager_set_IconShadowSize (PlankPositionManager* self,
                                                gint value);
static void plank_position_manager_set_IndicatorSize (PlankPositionManager* self,
                                               gint value);
static void plank_position_manager_set_GlowSize (PlankPositionManager* self,
                                          gint value);
static void plank_position_manager_set_HorizPadding (PlankPositionManager* self,
                                              gint value);
static void plank_position_manager_set_TopPadding (PlankPositionManager* self,
                                            gint value);
static void plank_position_manager_set_BottomPadding (PlankPositionManager* self,
                                               gint value);
static void plank_position_manager_set_ItemPadding (PlankPositionManager* self,
                                             gint value);
static void plank_position_manager_set_UrgentBounceHeight (PlankPositionManager* self,
                                                    gint value);
static void plank_position_manager_set_LaunchBounceHeight (PlankPositionManager* self,
                                                    gint value);
static void plank_position_manager_set_LineWidth (PlankPositionManager* self,
                                           gint value);
static void plank_position_manager_set_MaxIconSize (PlankPositionManager* self,
                                             gint value);
static void plank_position_manager_set_MaxItemCount (PlankPositionManager* self,
                                              gint value);
static void plank_position_manager_update_background_region (PlankPositionManager* self,
                                                      PlankDockItemDrawValue* val_first,
                                                      PlankDockItemDrawValue* val_last);
static gboolean __lambda29_ (PlankPositionManager* self,
                      PlankDockElement* i,
                      PlankDockItemDrawValue* val);
static void plank_position_manager_get_item_draw_region (PlankPositionManager* self,
                                                  PlankDockItemDrawValue* val,
                                                  GdkRectangle* result);
static void plank_position_manager_get_item_hover_region (PlankPositionManager* self,
                                                   PlankDockItemDrawValue* val,
                                                   GdkRectangle* result);
static void plank_position_manager_get_item_background_region (PlankPositionManager* self,
                                                        PlankDockItemDrawValue* val,
                                                        GdkRectangle* result);
static gboolean ___lambda29__gee_forall_map_func (gconstpointer k,
                                           gconstpointer v,
                                           gpointer self);
static GObject * plank_position_manager_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void plank_position_manager_finalize (GObject * obj);
static GType plank_position_manager_get_type_once (void);
static void _vala_plank_position_manager_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_plank_position_manager_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
plank_position_manager_get_instance_private (PlankPositionManager* self)
{
	return G_STRUCT_MEMBER_P (self, PlankPositionManager_private_offset);
}

static void
_plank_position_manager_screen_changed_gdk_screen_monitors_changed (GdkScreen* _sender,
                                                                    gpointer self)
{
	plank_position_manager_screen_changed ((PlankPositionManager*) self, _sender);
}

static void
_plank_position_manager_screen_changed_gdk_screen_size_changed (GdkScreen* _sender,
                                                                gpointer self)
{
	plank_position_manager_screen_changed ((PlankPositionManager*) self, _sender);
}

static void
_plank_position_manager_screen_composited_changed_gdk_screen_composited_changed (GdkScreen* _sender,
                                                                                 gpointer self)
{
	plank_position_manager_screen_composited_changed ((PlankPositionManager*) self, _sender);
}

static void
_plank_position_manager_prefs_changed_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	plank_position_manager_prefs_changed ((PlankPositionManager*) self, _sender, pspec);
}

/**
 * Creates a new position manager.
 *
 * @param controller the dock controller to manage positions for
 */
PlankPositionManager*
plank_position_manager_construct (GType object_type,
                                  PlankDockController* controller)
{
	PlankPositionManager * self = NULL;
	g_return_val_if_fail (controller != NULL, NULL);
	self = (PlankPositionManager*) g_object_new (object_type, "controller", controller, NULL);
	return self;
}

PlankPositionManager*
plank_position_manager_new (PlankDockController* controller)
{
	return plank_position_manager_construct (PLANK_TYPE_POSITION_MANAGER, controller);
}

/**
 * Initializes the position manager.
 */
void
plank_position_manager_initialize (PlankPositionManager* self)
{
	PlankDockController* _tmp0_;
	PlankDockWindow* _tmp1_;
	PlankDockWindow* _tmp2_;
	GdkScreen* screen = NULL;
	PlankDockController* _tmp3_;
	PlankDockWindow* _tmp4_;
	PlankDockWindow* _tmp5_;
	GdkScreen* _tmp6_;
	PlankDockController* _tmp7_;
	PlankDockPreferences* _tmp8_;
	PlankDockPreferences* _tmp9_;
	PlankDockController* _tmp10_;
	PlankDockPreferences* _tmp11_;
	PlankDockPreferences* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GdkRectangle _tmp15_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_window (_tmp0_);
	_tmp2_ = _tmp1_;
	_vala_return_if_fail (_tmp2_ != NULL, "controller.window != null");
	_tmp3_ = self->priv->_controller;
	_tmp4_ = plank_dock_controller_get_window (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = gtk_window_get_screen ((GtkWindow*) _tmp5_);
	screen = _tmp6_;
	_tmp7_ = self->priv->_controller;
	_tmp8_ = plank_dock_controller_get_prefs (_tmp7_);
	_tmp9_ = _tmp8_;
	g_signal_connect_object ((GObject*) _tmp9_, "notify", (GCallback) _plank_position_manager_prefs_changed_g_object_notify, self, 0);
	g_signal_connect_object (screen, "monitors-changed", (GCallback) _plank_position_manager_screen_changed_gdk_screen_monitors_changed, self, 0);
	g_signal_connect_object (screen, "size-changed", (GCallback) _plank_position_manager_screen_changed_gdk_screen_size_changed, self, 0);
	g_signal_connect_object (screen, "composited-changed", (GCallback) _plank_position_manager_screen_composited_changed_gdk_screen_composited_changed, self, 0);
	_tmp10_ = self->priv->_controller;
	_tmp11_ = plank_dock_controller_get_prefs (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = plank_dock_preferences_get_Monitor (_tmp12_);
	_tmp14_ = _tmp13_;
	gdk_screen_get_monitor_geometry (screen, plank_position_manager_find_monitor_number (screen, _tmp14_), &_tmp15_);
	self->priv->monitor_geo = _tmp15_;
	plank_position_manager_set_screen_is_composited (self, gdk_screen_is_composited (screen));
}

static void
plank_position_manager_prefs_changed (PlankPositionManager* self,
                                      GObject* prefs,
                                      GParamSpec* prop)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prefs != NULL);
	g_return_if_fail (prop != NULL);
	_tmp0_ = prop->name;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("Monitor")))) {
		switch (0) {
			default:
			{
				plank_position_manager_prefs_monitor_changed (self);
				break;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("ZoomPercent")))) || (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("ZoomEnabled"))))) {
		switch (0) {
			default:
			{
				plank_position_manager_prefs_zoom_changed (self);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
}

gchar**
plank_position_manager_get_monitor_plug_names (GdkScreen* screen,
                                               gint* result_length1)
{
	gint n_monitors = 0;
	gchar** _result_ = NULL;
	gchar** _tmp0_;
	gint _result__length1;
	gint __result__size_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar** result;
	g_return_val_if_fail (screen != NULL, NULL);
	n_monitors = gdk_screen_get_n_monitors (screen);
	_tmp0_ = g_new0 (gchar*, n_monitors + 1);
	_result_ = _tmp0_;
	_result__length1 = n_monitors;
	__result__size_ = _result__length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gchar* _tmp3_ = NULL;
				gchar* _tmp4_;
				gchar** _tmp6_;
				gint _tmp6__length1;
				gchar* _tmp7_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < n_monitors)) {
					break;
				}
				_tmp4_ = gdk_screen_get_monitor_plug_name (screen, i);
				_tmp3_ = _tmp4_;
				if (_tmp3_ == NULL) {
					gchar* _tmp5_;
					_tmp5_ = g_strdup_printf ("PLUG_MONITOR_%i", i);
					_g_free0 (_tmp3_);
					_tmp3_ = _tmp5_;
				}
				_tmp6_ = _result_;
				_tmp6__length1 = _result__length1;
				_tmp7_ = _tmp3_;
				_tmp3_ = NULL;
				_g_free0 (_tmp6_[i]);
				_tmp6_[i] = _tmp7_;
				_g_free0 (_tmp3_);
			}
		}
	}
	_tmp8_ = _result_;
	_tmp8__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp8__length1;
	}
	result = _tmp8_;
	return result;
}

static gint
plank_position_manager_find_monitor_number (GdkScreen* screen,
                                            const gchar* plug_name)
{
	gint n_monitors = 0;
	gint result;
	g_return_val_if_fail (screen != NULL, 0);
	g_return_val_if_fail (plug_name != NULL, 0);
	if (g_strcmp0 (plug_name, "") == 0) {
		result = gdk_screen_get_primary_monitor (screen);
		return result;
	}
	n_monitors = gdk_screen_get_n_monitors (screen);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gchar* _tmp2_ = NULL;
				gchar* _tmp3_;
				gchar* name = NULL;
				gchar* _tmp5_;
				const gchar* _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < n_monitors)) {
					break;
				}
				_tmp3_ = gdk_screen_get_monitor_plug_name (screen, i);
				_tmp2_ = _tmp3_;
				if (_tmp2_ == NULL) {
					gchar* _tmp4_;
					_tmp4_ = g_strdup_printf ("PLUG_MONITOR_%i", i);
					_g_free0 (_tmp2_);
					_tmp2_ = _tmp4_;
				}
				_tmp5_ = _tmp2_;
				_tmp2_ = NULL;
				name = _tmp5_;
				_tmp6_ = name;
				if (g_strcmp0 (plug_name, _tmp6_) == 0) {
					result = i;
					_g_free0 (name);
					_g_free0 (_tmp2_);
					return result;
				}
				_g_free0 (name);
				_g_free0 (_tmp2_);
			}
		}
	}
	result = gdk_screen_get_primary_monitor (screen);
	return result;
}

static void
plank_position_manager_prefs_monitor_changed (PlankPositionManager* self)
{
	PlankDockController* _tmp0_;
	PlankDockWindow* _tmp1_;
	PlankDockWindow* _tmp2_;
	GdkScreen* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_window (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_window_get_screen ((GtkWindow*) _tmp2_);
	plank_position_manager_screen_changed (self, _tmp3_);
}

static void
plank_position_manager_screen_changed (PlankPositionManager* self,
                                       GdkScreen* screen)
{
	GdkRectangle old_monitor_geo = {0};
	GdkRectangle _tmp0_;
	PlankDockController* _tmp1_;
	PlankDockPreferences* _tmp2_;
	PlankDockPreferences* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GdkRectangle _tmp6_ = {0};
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	GdkRectangle _tmp10_;
	GdkRectangle _tmp11_;
	GdkRectangle _tmp18_;
	GdkRectangle _tmp19_;
	GdkRectangle _tmp20_;
	GdkRectangle _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (screen != NULL);
	_tmp0_ = self->priv->monitor_geo;
	old_monitor_geo = _tmp0_;
	_tmp1_ = self->priv->_controller;
	_tmp2_ = plank_dock_controller_get_prefs (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = plank_dock_preferences_get_Monitor (_tmp3_);
	_tmp5_ = _tmp4_;
	gdk_screen_get_monitor_geometry (screen, plank_position_manager_find_monitor_number (screen, _tmp5_), &_tmp6_);
	self->priv->monitor_geo = _tmp6_;
	_tmp10_ = old_monitor_geo;
	_tmp11_ = self->priv->monitor_geo;
	if (_tmp10_.x == _tmp11_.x) {
		GdkRectangle _tmp12_;
		GdkRectangle _tmp13_;
		_tmp12_ = old_monitor_geo;
		_tmp13_ = self->priv->monitor_geo;
		_tmp9_ = _tmp12_.y == _tmp13_.y;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		GdkRectangle _tmp14_;
		GdkRectangle _tmp15_;
		_tmp14_ = old_monitor_geo;
		_tmp15_ = self->priv->monitor_geo;
		_tmp8_ = _tmp14_.width == _tmp15_.width;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		GdkRectangle _tmp16_;
		GdkRectangle _tmp17_;
		_tmp16_ = old_monitor_geo;
		_tmp17_ = self->priv->monitor_geo;
		_tmp7_ = _tmp16_.height == _tmp17_.height;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		return;
	}
	_tmp18_ = self->priv->monitor_geo;
	_tmp19_ = self->priv->monitor_geo;
	_tmp20_ = self->priv->monitor_geo;
	_tmp21_ = self->priv->monitor_geo;
	plank_logger_verbose ("PositionManager.monitor_geo_changed (%i,%i-%ix%i)", _tmp18_.x, _tmp19_.y, _tmp20_.width, _tmp21_.height, NULL);
	g_object_freeze_notify ((GObject*) self);
	plank_position_manager_update_dimensions (self);
	plank_position_manager_update_regions (self);
	g_object_thaw_notify ((GObject*) self);
}

static void
plank_position_manager_screen_composited_changed (PlankPositionManager* self,
                                                  GdkScreen* screen)
{
	PlankDockController* _tmp0_;
	PlankDockRenderer* _tmp1_;
	PlankDockRenderer* _tmp2_;
	PlankDockTheme* _tmp3_;
	PlankDockTheme* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (screen != NULL);
	g_object_freeze_notify ((GObject*) self);
	plank_position_manager_set_screen_is_composited (self, gdk_screen_is_composited (screen));
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_renderer (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = plank_dock_renderer_get_theme (_tmp2_);
	_tmp4_ = _tmp3_;
	plank_position_manager_update (self, _tmp4_);
	g_object_thaw_notify ((GObject*) self);
}

/**
 * Updates all internal caches.
 *
 * @param theme the current dock theme
 */
void
plank_position_manager_update (PlankPositionManager* self,
                               PlankDockTheme* theme)
{
	PlankDockController* _tmp0_;
	PlankDockWindow* _tmp1_;
	PlankDockWindow* _tmp2_;
	GdkScreen* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (theme != NULL);
	plank_logger_verbose ("PositionManager.update ()", NULL);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_window (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_window_get_screen ((GtkWindow*) _tmp2_);
	plank_position_manager_set_screen_is_composited (self, gdk_screen_is_composited (_tmp3_));
	g_object_freeze_notify ((GObject*) self);
	plank_position_manager_update_caches (self, theme);
	plank_position_manager_update_max_icon_size (self, theme);
	plank_position_manager_update_dimensions (self);
	plank_position_manager_update_regions (self);
	g_object_thaw_notify ((GObject*) self);
}

static void
plank_position_manager_update_caches (PlankPositionManager* self,
                                      PlankDockTheme* theme)
{
	PlankDockPreferences* prefs = NULL;
	PlankDockController* _tmp0_;
	PlankDockPreferences* _tmp1_;
	PlankDockPreferences* _tmp2_;
	PlankDockPreferences* _tmp3_;
	GtkPositionType _tmp4_;
	GtkPositionType _tmp5_;
	PlankDockPreferences* _tmp6_;
	GtkAlign _tmp7_;
	GtkAlign _tmp8_;
	PlankDockPreferences* _tmp9_;
	GtkAlign _tmp10_;
	GtkAlign _tmp11_;
	PlankDockPreferences* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp21_;
	PlankDockPreferences* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gdouble _tmp25_ = 0.0;
	gboolean _tmp26_;
	gint _tmp30_ = 0;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_;
	gdouble scaled_icon_size = 0.0;
	gint _tmp38_;
	gdouble _tmp39_;
	gdouble _tmp40_;
	gdouble _tmp41_;
	gdouble _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	gdouble _tmp45_;
	gdouble _tmp46_;
	gdouble _tmp47_;
	gdouble _tmp48_;
	gdouble _tmp49_;
	gdouble _tmp50_;
	gdouble _tmp51_;
	gdouble _tmp52_;
	gdouble _tmp53_;
	gdouble _tmp54_;
	gint _tmp55_;
	gdouble _tmp56_;
	gdouble _tmp57_;
	gint _tmp58_;
	gint _tmp59_;
	gint _tmp60_;
	gboolean _tmp61_;
	gint _tmp64_ = 0;
	gint _tmp65_;
	gint _tmp67_;
	gint _tmp68_;
	gint _tmp69_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (theme != NULL);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_prefs (_tmp0_);
	_tmp2_ = _tmp1_;
	prefs = _tmp2_;
	_tmp3_ = prefs;
	_tmp4_ = plank_dock_preferences_get_Position (_tmp3_);
	_tmp5_ = _tmp4_;
	plank_position_manager_set_Position (self, _tmp5_);
	_tmp6_ = prefs;
	_tmp7_ = plank_dock_preferences_get_Alignment (_tmp6_);
	_tmp8_ = _tmp7_;
	plank_position_manager_set_Alignment (self, _tmp8_);
	_tmp9_ = prefs;
	_tmp10_ = plank_dock_preferences_get_ItemsAlignment (_tmp9_);
	_tmp11_ = _tmp10_;
	plank_position_manager_set_ItemsAlignment (self, _tmp11_);
	_tmp12_ = prefs;
	_tmp13_ = plank_dock_preferences_get_Offset (_tmp12_);
	_tmp14_ = _tmp13_;
	plank_position_manager_set_Offset (self, _tmp14_);
	if (gtk_widget_get_default_direction () == GTK_TEXT_DIR_RTL) {
		if (plank_position_manager_is_horizontal_dock (self)) {
			GtkAlign _tmp15_;
			GtkAlign _tmp17_;
			gint _tmp19_;
			_tmp15_ = self->priv->_Alignment;
			if (_tmp15_ == GTK_ALIGN_START) {
				plank_position_manager_set_Alignment (self, GTK_ALIGN_END);
			} else {
				GtkAlign _tmp16_;
				_tmp16_ = self->priv->_Alignment;
				if (_tmp16_ == GTK_ALIGN_END) {
					plank_position_manager_set_Alignment (self, GTK_ALIGN_START);
				}
			}
			_tmp17_ = self->priv->_ItemsAlignment;
			if (_tmp17_ == GTK_ALIGN_START) {
				plank_position_manager_set_ItemsAlignment (self, GTK_ALIGN_END);
			} else {
				GtkAlign _tmp18_;
				_tmp18_ = self->priv->_ItemsAlignment;
				if (_tmp18_ == GTK_ALIGN_END) {
					plank_position_manager_set_ItemsAlignment (self, GTK_ALIGN_START);
				}
			}
			_tmp19_ = self->priv->_Offset;
			plank_position_manager_set_Offset (self, -_tmp19_);
		} else {
			GtkPositionType _tmp20_;
			_tmp20_ = self->priv->_Position;
			if (_tmp20_ == GTK_POS_RIGHT) {
				plank_position_manager_set_Position (self, GTK_POS_LEFT);
			} else {
				plank_position_manager_set_Position (self, GTK_POS_RIGHT);
			}
		}
	}
	_tmp21_ = self->priv->_MaxIconSize;
	_tmp22_ = prefs;
	_tmp23_ = plank_dock_preferences_get_IconSize (_tmp22_);
	_tmp24_ = _tmp23_;
	plank_position_manager_set_IconSize (self, MIN (_tmp21_, _tmp24_));
	_tmp26_ = self->priv->_screen_is_composited;
	if (_tmp26_) {
		PlankDockPreferences* _tmp27_;
		guint _tmp28_;
		guint _tmp29_;
		_tmp27_ = prefs;
		_tmp28_ = plank_dock_preferences_get_ZoomPercent (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp25_ = _tmp29_ / 100.0;
	} else {
		_tmp25_ = 1.0;
	}
	self->priv->ZoomPercent = _tmp25_;
	_tmp32_ = self->priv->_screen_is_composited;
	if (_tmp32_) {
		PlankDockPreferences* _tmp33_;
		gboolean _tmp34_;
		gboolean _tmp35_;
		_tmp33_ = prefs;
		_tmp34_ = plank_dock_preferences_get_ZoomEnabled (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp31_ = _tmp35_;
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		gint _tmp36_;
		_tmp36_ = self->priv->_IconSize;
		_tmp30_ = (gint) round (_tmp36_ * self->priv->ZoomPercent);
	} else {
		gint _tmp37_;
		_tmp37_ = self->priv->_IconSize;
		_tmp30_ = _tmp37_;
	}
	plank_position_manager_set_ZoomIconSize (self, _tmp30_);
	_tmp38_ = self->priv->_IconSize;
	scaled_icon_size = _tmp38_ / 10.0;
	_tmp39_ = plank_dock_theme_get_IconShadowSize (theme);
	_tmp40_ = _tmp39_;
	plank_position_manager_set_IconShadowSize (self, (gint) ceil (_tmp40_ * scaled_icon_size));
	_tmp41_ = plank_dock_theme_get_IndicatorSize (theme);
	_tmp42_ = _tmp41_;
	plank_position_manager_set_IndicatorSize (self, (gint) (_tmp42_ * scaled_icon_size));
	_tmp43_ = plank_dock_theme_get_GlowSize (theme);
	_tmp44_ = _tmp43_;
	plank_position_manager_set_GlowSize (self, (gint) (_tmp44_ * scaled_icon_size));
	_tmp45_ = plank_dock_theme_get_HorizPadding (theme);
	_tmp46_ = _tmp45_;
	plank_position_manager_set_HorizPadding (self, (gint) (_tmp46_ * scaled_icon_size));
	_tmp47_ = plank_dock_theme_get_TopPadding (theme);
	_tmp48_ = _tmp47_;
	plank_position_manager_set_TopPadding (self, (gint) (_tmp48_ * scaled_icon_size));
	_tmp49_ = plank_dock_theme_get_BottomPadding (theme);
	_tmp50_ = _tmp49_;
	plank_position_manager_set_BottomPadding (self, (gint) (_tmp50_ * scaled_icon_size));
	_tmp51_ = plank_dock_theme_get_ItemPadding (theme);
	_tmp52_ = _tmp51_;
	plank_position_manager_set_ItemPadding (self, (gint) (_tmp52_ * scaled_icon_size));
	_tmp53_ = plank_dock_theme_get_UrgentBounceHeight (theme);
	_tmp54_ = _tmp53_;
	_tmp55_ = self->priv->_IconSize;
	plank_position_manager_set_UrgentBounceHeight (self, (gint) (_tmp54_ * _tmp55_));
	_tmp56_ = plank_dock_theme_get_LaunchBounceHeight (theme);
	_tmp57_ = _tmp56_;
	_tmp58_ = self->priv->_IconSize;
	plank_position_manager_set_LaunchBounceHeight (self, (gint) (_tmp57_ * _tmp58_));
	_tmp59_ = plank_theme_get_LineWidth ((PlankTheme*) theme);
	_tmp60_ = _tmp59_;
	plank_position_manager_set_LineWidth (self, _tmp60_);
	_tmp61_ = self->priv->_screen_is_composited;
	if (!_tmp61_) {
		gint _tmp62_;
		gint _tmp63_;
		_tmp62_ = self->priv->_HorizPadding;
		if (_tmp62_ < 0) {
			plank_position_manager_set_HorizPadding (self, (gint) scaled_icon_size);
		}
		_tmp63_ = self->priv->_TopPadding;
		if (_tmp63_ < 0) {
			plank_position_manager_set_TopPadding (self, (gint) scaled_icon_size);
		}
	}
	_tmp65_ = self->priv->_HorizPadding;
	if (_tmp65_ > 0) {
		gint _tmp66_;
		_tmp66_ = self->priv->_HorizPadding;
		_tmp64_ = _tmp66_;
	} else {
		_tmp64_ = 0;
	}
	_tmp67_ = self->priv->_LineWidth;
	self->priv->items_offset = (gint) ((2 * _tmp67_) + _tmp64_);
	_tmp68_ = self->priv->_TopPadding;
	self->priv->top_offset = plank_theme_get_top_offset ((PlankTheme*) theme) + _tmp68_;
	_tmp69_ = self->priv->_BottomPadding;
	self->priv->bottom_offset = plank_theme_get_bottom_offset ((PlankTheme*) theme) + _tmp69_;
	if (self->priv->top_offset < 0) {
		gint _tmp70_;
		_tmp70_ = self->priv->_IconShadowSize;
		self->priv->extra_hide_offset = _tmp70_;
	} else {
		gint _tmp71_;
		_tmp71_ = self->priv->_IconShadowSize;
		if (self->priv->top_offset < _tmp71_) {
			gint _tmp72_;
			_tmp72_ = self->priv->_IconShadowSize;
			self->priv->extra_hide_offset = _tmp72_ - self->priv->top_offset;
		} else {
			self->priv->extra_hide_offset = 0;
		}
	}
}

static void
plank_position_manager_prefs_zoom_changed (PlankPositionManager* self)
{
	PlankDockPreferences* prefs = NULL;
	PlankDockController* _tmp0_;
	PlankDockPreferences* _tmp1_;
	PlankDockPreferences* _tmp2_;
	gdouble _tmp3_ = 0.0;
	gboolean _tmp4_;
	gint _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_prefs (_tmp0_);
	_tmp2_ = _tmp1_;
	prefs = _tmp2_;
	_tmp4_ = self->priv->_screen_is_composited;
	if (_tmp4_) {
		PlankDockPreferences* _tmp5_;
		guint _tmp6_;
		guint _tmp7_;
		_tmp5_ = prefs;
		_tmp6_ = plank_dock_preferences_get_ZoomPercent (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_ / 100.0;
	} else {
		_tmp3_ = 1.0;
	}
	self->priv->ZoomPercent = _tmp3_;
	_tmp10_ = self->priv->_screen_is_composited;
	if (_tmp10_) {
		PlankDockPreferences* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		_tmp11_ = prefs;
		_tmp12_ = plank_dock_preferences_get_ZoomEnabled (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp9_ = _tmp13_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gint _tmp14_;
		_tmp14_ = self->priv->_IconSize;
		_tmp8_ = (gint) round (_tmp14_ * self->priv->ZoomPercent);
	} else {
		gint _tmp15_;
		_tmp15_ = self->priv->_IconSize;
		_tmp8_ = _tmp15_;
	}
	plank_position_manager_set_ZoomIconSize (self, _tmp8_);
}

/**
 * Find an appropriate MaxIconSize
 */
static void
plank_position_manager_update_max_icon_size (PlankPositionManager* self,
                                             PlankDockTheme* theme)
{
	PlankDockPreferences* prefs = NULL;
	PlankDockController* _tmp0_;
	PlankDockPreferences* _tmp1_;
	PlankDockPreferences* _tmp2_;
	gint item_count = 0;
	PlankDockController* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint width = 0;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_ = 0;
	gint max_width = 0;
	gint step_size = 0;
	gboolean _tmp15_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (theme != NULL);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_prefs (_tmp0_);
	_tmp2_ = _tmp1_;
	prefs = _tmp2_;
	_tmp3_ = self->priv->_controller;
	_tmp4_ = plank_dock_controller_get_VisibleItems (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
	_tmp7_ = _tmp6_;
	item_count = _tmp7_;
	_tmp8_ = self->priv->_ItemPadding;
	_tmp9_ = self->priv->_IconSize;
	_tmp10_ = self->priv->_HorizPadding;
	_tmp11_ = self->priv->_LineWidth;
	width = ((item_count * (_tmp8_ + _tmp9_)) + (2 * _tmp10_)) + (4 * _tmp11_);
	if (plank_position_manager_is_horizontal_dock (self)) {
		GdkRectangle _tmp13_;
		_tmp13_ = self->priv->monitor_geo;
		_tmp12_ = _tmp13_.width;
	} else {
		GdkRectangle _tmp14_;
		_tmp14_ = self->priv->monitor_geo;
		_tmp12_ = _tmp14_.height;
	}
	max_width = _tmp12_;
	step_size = MAX (1, (gint) (fabs ((gdouble) (width - max_width)) / item_count));
	if (width > max_width) {
		gint _tmp16_;
		_tmp16_ = self->priv->_MaxIconSize;
		_tmp15_ = _tmp16_ > PLANK_DOCK_PREFERENCES_MIN_ICON_SIZE;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		gint _tmp17_;
		_tmp17_ = self->priv->_MaxIconSize;
		plank_position_manager_set_MaxIconSize (self, _tmp17_ - step_size);
	} else {
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		if (width < max_width) {
			gint _tmp20_;
			PlankDockPreferences* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			_tmp20_ = self->priv->_MaxIconSize;
			_tmp21_ = prefs;
			_tmp22_ = plank_dock_preferences_get_IconSize (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp19_ = _tmp20_ < _tmp23_;
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			_tmp18_ = step_size > 1;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			gint _tmp24_;
			_tmp24_ = self->priv->_MaxIconSize;
			plank_position_manager_set_MaxIconSize (self, _tmp24_ + step_size);
		} else {
			gint _tmp25_;
			gint _tmp26_;
			_tmp25_ = self->priv->_MaxIconSize;
			plank_position_manager_set_MaxIconSize (self, MAX (PLANK_DOCK_PREFERENCES_MIN_ICON_SIZE, MIN (PLANK_DOCK_PREFERENCES_MAX_ICON_SIZE, ((gint) (_tmp25_ / 2.0)) * 2)));
			_tmp26_ = self->priv->_MaxIconSize;
			plank_logger_verbose ("PositionManager.MaxIconSize = %i", _tmp26_, NULL);
			plank_position_manager_update_caches (self, theme);
			return;
		}
	}
	plank_position_manager_update_caches (self, theme);
	plank_position_manager_update_max_icon_size (self, theme);
}

static void
plank_position_manager_update_dimensions (PlankPositionManager* self)
{
	gint height = 0;
	gint _tmp0_;
	gint background_height = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_;
	gint dock_height = 0;
	gint width = 0;
	GtkAlign _tmp4_;
	gint background_width = 0;
	gint _tmp16_;
	g_return_if_fail (self != NULL);
	plank_logger_verbose ("PositionManager.update_dimensions ()", NULL);
	_tmp0_ = self->priv->_IconSize;
	height = (_tmp0_ + self->priv->top_offset) + self->priv->bottom_offset;
	background_height = MAX (0, height);
	if (self->priv->top_offset < 0) {
		height -= self->priv->top_offset;
	}
	_tmp2_ = self->priv->_screen_is_composited;
	if (_tmp2_) {
		gint _tmp3_;
		_tmp3_ = self->priv->_UrgentBounceHeight;
		_tmp1_ = _tmp3_;
	} else {
		_tmp1_ = 0;
	}
	dock_height = height + _tmp1_;
	width = 0;
	_tmp4_ = self->priv->_Alignment;
	switch (_tmp4_) {
		default:
		case GTK_ALIGN_START:
		case GTK_ALIGN_END:
		case GTK_ALIGN_CENTER:
		{
			PlankDockController* _tmp5_;
			GeeArrayList* _tmp6_;
			GeeArrayList* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			_tmp5_ = self->priv->_controller;
			_tmp6_ = plank_dock_controller_get_VisibleItems (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = self->priv->_ItemPadding;
			_tmp11_ = self->priv->_IconSize;
			_tmp12_ = self->priv->_HorizPadding;
			_tmp13_ = self->priv->_LineWidth;
			width = ((_tmp9_ * (_tmp10_ + _tmp11_)) + (2 * _tmp12_)) + (4 * _tmp13_);
			break;
		}
		case GTK_ALIGN_FILL:
		{
			if (plank_position_manager_is_horizontal_dock (self)) {
				GdkRectangle _tmp14_;
				_tmp14_ = self->priv->monitor_geo;
				width = _tmp14_.width;
			} else {
				GdkRectangle _tmp15_;
				_tmp15_ = self->priv->monitor_geo;
				width = _tmp15_.height;
			}
			break;
		}
	}
	background_width = MAX (0, width);
	_tmp16_ = self->priv->_HorizPadding;
	if (_tmp16_ < 0) {
		gint _tmp17_;
		_tmp17_ = self->priv->_HorizPadding;
		width -= 2 * _tmp17_;
	}
	if (plank_position_manager_is_horizontal_dock (self)) {
		GdkRectangle _tmp18_;
		gint _tmp19_ = 0;
		gboolean _tmp20_;
		GdkRectangle _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		_tmp18_ = self->priv->monitor_geo;
		width = MIN (_tmp18_.width, width);
		self->priv->VisibleDockHeight = height;
		self->priv->VisibleDockWidth = width;
		self->priv->DockHeight = dock_height;
		_tmp20_ = self->priv->_screen_is_composited;
		if (_tmp20_) {
			GdkRectangle _tmp21_;
			_tmp21_ = self->priv->monitor_geo;
			_tmp19_ = _tmp21_.width;
		} else {
			_tmp19_ = width;
		}
		self->priv->DockWidth = _tmp19_;
		self->priv->DockBackgroundHeight = background_height;
		self->priv->DockBackgroundWidth = background_width;
		_tmp22_ = self->priv->monitor_geo;
		_tmp23_ = self->priv->_HorizPadding;
		_tmp24_ = self->priv->_LineWidth;
		_tmp25_ = self->priv->_ItemPadding;
		_tmp26_ = self->priv->_IconSize;
		plank_position_manager_set_MaxItemCount (self, (gint) floor (((gdouble) ((_tmp22_.width - (2 * _tmp23_)) + (4 * _tmp24_))) / (_tmp25_ + _tmp26_)));
	} else {
		GdkRectangle _tmp27_;
		gint _tmp28_ = 0;
		gboolean _tmp29_;
		GdkRectangle _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		_tmp27_ = self->priv->monitor_geo;
		width = MIN (_tmp27_.height, width);
		self->priv->VisibleDockHeight = width;
		self->priv->VisibleDockWidth = height;
		_tmp29_ = self->priv->_screen_is_composited;
		if (_tmp29_) {
			GdkRectangle _tmp30_;
			_tmp30_ = self->priv->monitor_geo;
			_tmp28_ = _tmp30_.height;
		} else {
			_tmp28_ = width;
		}
		self->priv->DockHeight = _tmp28_;
		self->priv->DockWidth = dock_height;
		self->priv->DockBackgroundHeight = background_width;
		self->priv->DockBackgroundWidth = background_height;
		_tmp31_ = self->priv->monitor_geo;
		_tmp32_ = self->priv->_HorizPadding;
		_tmp33_ = self->priv->_LineWidth;
		_tmp34_ = self->priv->_ItemPadding;
		_tmp35_ = self->priv->_IconSize;
		plank_position_manager_set_MaxItemCount (self, (gint) floor (((gdouble) ((_tmp31_.height - (2 * _tmp32_)) + (4 * _tmp33_))) / (_tmp34_ + _tmp35_)));
	}
}

/**
 * Return whether or not a dock is a horizontal dock.
 *
 * @return true if the dock's position indicates it is horizontal
 */
gboolean
plank_position_manager_is_horizontal_dock (PlankPositionManager* self)
{
	gboolean _tmp0_ = FALSE;
	GtkPositionType _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_Position;
	if (_tmp1_ == GTK_POS_TOP) {
		_tmp0_ = TRUE;
	} else {
		GtkPositionType _tmp2_;
		_tmp2_ = self->priv->_Position;
		_tmp0_ = _tmp2_ == GTK_POS_BOTTOM;
	}
	result = _tmp0_;
	return result;
}

/**
 * Returns the cursor region for the dock.
 * This is the region that the cursor can interact with the dock.
 *
 * @return the cursor region for the dock
 */
void
plank_position_manager_get_cursor_region (PlankPositionManager* self,
                                          GdkRectangle* result)
{
	GdkRectangle cursor_region = {0};
	GdkRectangle _tmp0_;
	gdouble progress = 0.0;
	PlankDockController* _tmp1_;
	PlankDockRenderer* _tmp2_;
	PlankDockRenderer* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	PlankDockController* _tmp6_;
	PlankDockWindow* _tmp7_;
	PlankDockWindow* _tmp8_;
	GdkWindow* _tmp9_;
	PlankDockController* _tmp10_;
	PlankDockPreferences* _tmp11_;
	PlankDockPreferences* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	GtkPositionType _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->static_dock_region;
	cursor_region = _tmp0_;
	_tmp1_ = self->priv->_controller;
	_tmp2_ = plank_dock_controller_get_renderer (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = plank_dock_renderer_get_hide_progress (_tmp3_);
	_tmp5_ = _tmp4_;
	progress = 1.0 - _tmp5_;
	_tmp6_ = self->priv->_controller;
	_tmp7_ = plank_dock_controller_get_window (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = gtk_widget_get_window ((GtkWidget*) _tmp8_);
	self->priv->window_scale_factor = gdk_window_get_scale_factor (_tmp9_);
	_tmp10_ = self->priv->_controller;
	_tmp11_ = plank_dock_controller_get_prefs (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = plank_dock_preferences_get_ZoomEnabled (_tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_) {
		PlankDockItem* hovered_item = NULL;
		PlankDockController* _tmp15_;
		PlankDockWindow* _tmp16_;
		PlankDockWindow* _tmp17_;
		PlankDockItem* _tmp18_;
		PlankDockItem* _tmp19_;
		PlankDockItem* _tmp20_;
		_tmp15_ = self->priv->_controller;
		_tmp16_ = plank_dock_controller_get_window (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = plank_dock_window_get_HoveredItem (_tmp17_);
		_tmp19_ = _tmp18_;
		hovered_item = _tmp19_;
		_tmp20_ = hovered_item;
		if (_tmp20_ != NULL) {
			GdkRectangle hover_region = {0};
			PlankDockItem* _tmp21_;
			GdkRectangle _tmp22_ = {0};
			GdkRectangle _tmp23_;
			GdkRectangle _tmp24_ = {0};
			_tmp21_ = hovered_item;
			plank_position_manager_get_hover_region_for_element (self, (PlankDockElement*) _tmp21_, &_tmp22_);
			hover_region = _tmp22_;
			_tmp23_ = hover_region;
			gdk_rectangle_union (&cursor_region, &_tmp23_, &_tmp24_);
			cursor_region = _tmp24_;
		}
	}
	_tmp25_ = self->priv->_Position;
	switch (_tmp25_) {
		default:
		case GTK_POS_BOTTOM:
		{
			GdkRectangle _tmp26_;
			GdkRectangle _tmp27_;
			_tmp26_ = cursor_region;
			cursor_region.height = MAX (1 * self->priv->window_scale_factor, (gint) (progress * _tmp26_.height));
			_tmp27_ = cursor_region;
			cursor_region.y = (self->priv->DockHeight - _tmp27_.height) + (self->priv->window_scale_factor - 1);
			break;
		}
		case GTK_POS_TOP:
		{
			GdkRectangle _tmp28_;
			_tmp28_ = cursor_region;
			cursor_region.height = MAX (1 * self->priv->window_scale_factor, (gint) (progress * _tmp28_.height));
			cursor_region.y = 0;
			break;
		}
		case GTK_POS_LEFT:
		{
			GdkRectangle _tmp29_;
			_tmp29_ = cursor_region;
			cursor_region.width = MAX (1 * self->priv->window_scale_factor, (gint) (progress * _tmp29_.width));
			cursor_region.x = 0;
			break;
		}
		case GTK_POS_RIGHT:
		{
			GdkRectangle _tmp30_;
			GdkRectangle _tmp31_;
			_tmp30_ = cursor_region;
			cursor_region.width = MAX (1 * self->priv->window_scale_factor, (gint) (progress * _tmp30_.width));
			_tmp31_ = cursor_region;
			cursor_region.x = (self->priv->DockWidth - _tmp31_.width) + (self->priv->window_scale_factor - 1);
			break;
		}
	}
	*result = cursor_region;
	return;
}

/**
 * Returns the static dock region for the dock.
 * This is the region that the dock occupies when not hidden.
 *
 * @return the static dock region for the dock
 */
void
plank_position_manager_get_static_dock_region (PlankPositionManager* self,
                                               GdkRectangle* result)
{
	GdkRectangle dock_region = {0};
	GdkRectangle _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->static_dock_region;
	dock_region = _tmp0_;
	dock_region.x = dock_region.x + self->priv->win_x;
	dock_region.y = dock_region.y + self->priv->win_y;
	_tmp2_ = self->priv->_screen_is_composited;
	if (!_tmp2_) {
		PlankDockController* _tmp3_;
		PlankHideManager* _tmp4_;
		PlankHideManager* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp3_ = self->priv->_controller;
		_tmp4_ = plank_dock_controller_get_hide_manager (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = plank_hide_manager_get_Hidden (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = _tmp7_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GtkPositionType _tmp8_;
		_tmp8_ = self->priv->_Position;
		switch (_tmp8_) {
			default:
			case GTK_POS_BOTTOM:
			{
				dock_region.y = dock_region.y - (self->priv->DockHeight - 1);
				break;
			}
			case GTK_POS_TOP:
			{
				dock_region.y = dock_region.y + (self->priv->DockHeight - 1);
				break;
			}
			case GTK_POS_LEFT:
			{
				dock_region.x = dock_region.x + (self->priv->DockWidth - 1);
				break;
			}
			case GTK_POS_RIGHT:
			{
				dock_region.x = dock_region.x - (self->priv->DockWidth - 1);
				break;
			}
		}
	}
	*result = dock_region;
	return;
}

/**
 * Call when any cached region needs updating.
 */
void
plank_position_manager_update_regions (PlankPositionManager* self)
{
	GdkRectangle old_region = {0};
	GdkRectangle _tmp0_;
	PlankDockController* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint xoffset = 0;
	GdkRectangle _tmp8_;
	gint yoffset = 0;
	GdkRectangle _tmp9_;
	gboolean _tmp10_;
	GtkPositionType _tmp21_;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_;
	g_return_if_fail (self != NULL);
	plank_logger_verbose ("PositionManager.update_regions ()", NULL);
	_tmp0_ = self->priv->static_dock_region;
	old_region = _tmp0_;
	_tmp1_ = self->priv->_controller;
	_tmp2_ = plank_dock_controller_get_VisibleItems (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->_ItemPadding;
	_tmp7_ = self->priv->_IconSize;
	self->priv->items_width = _tmp5_ * (_tmp6_ + _tmp7_);
	self->priv->static_dock_region.width = self->priv->VisibleDockWidth;
	self->priv->static_dock_region.height = self->priv->VisibleDockHeight;
	_tmp8_ = self->priv->static_dock_region;
	xoffset = (self->priv->DockWidth - _tmp8_.width) / 2;
	_tmp9_ = self->priv->static_dock_region;
	yoffset = (self->priv->DockHeight - _tmp9_.height) / 2;
	_tmp10_ = self->priv->_screen_is_composited;
	if (_tmp10_) {
		gint offset = 0;
		gint _tmp11_;
		GtkAlign _tmp12_;
		_tmp11_ = self->priv->_Offset;
		offset = _tmp11_;
		xoffset = (gint) ((1 + (offset / 100.0)) * xoffset);
		yoffset = (gint) ((1 + (offset / 100.0)) * yoffset);
		_tmp12_ = self->priv->_Alignment;
		switch (_tmp12_) {
			default:
			case GTK_ALIGN_CENTER:
			case GTK_ALIGN_FILL:
			{
				break;
			}
			case GTK_ALIGN_START:
			{
				if (plank_position_manager_is_horizontal_dock (self)) {
					GdkRectangle _tmp13_;
					GdkRectangle _tmp14_;
					xoffset = 0;
					_tmp13_ = self->priv->monitor_geo;
					_tmp14_ = self->priv->static_dock_region;
					yoffset = _tmp13_.height - _tmp14_.height;
				} else {
					GdkRectangle _tmp15_;
					GdkRectangle _tmp16_;
					_tmp15_ = self->priv->monitor_geo;
					_tmp16_ = self->priv->static_dock_region;
					xoffset = _tmp15_.width - _tmp16_.width;
					yoffset = 0;
				}
				break;
			}
			case GTK_ALIGN_END:
			{
				if (plank_position_manager_is_horizontal_dock (self)) {
					GdkRectangle _tmp17_;
					GdkRectangle _tmp18_;
					_tmp17_ = self->priv->monitor_geo;
					_tmp18_ = self->priv->static_dock_region;
					xoffset = _tmp17_.width - _tmp18_.width;
					yoffset = 0;
				} else {
					GdkRectangle _tmp19_;
					GdkRectangle _tmp20_;
					xoffset = 0;
					_tmp19_ = self->priv->monitor_geo;
					_tmp20_ = self->priv->static_dock_region;
					yoffset = _tmp19_.height - _tmp20_.height;
				}
				break;
			}
		}
	}
	_tmp21_ = self->priv->_Position;
	switch (_tmp21_) {
		default:
		case GTK_POS_BOTTOM:
		{
			GdkRectangle _tmp22_;
			self->priv->static_dock_region.x = xoffset;
			_tmp22_ = self->priv->static_dock_region;
			self->priv->static_dock_region.y = self->priv->DockHeight - _tmp22_.height;
			break;
		}
		case GTK_POS_TOP:
		{
			self->priv->static_dock_region.x = xoffset;
			self->priv->static_dock_region.y = 0;
			break;
		}
		case GTK_POS_LEFT:
		{
			self->priv->static_dock_region.y = yoffset;
			self->priv->static_dock_region.x = 0;
			break;
		}
		case GTK_POS_RIGHT:
		{
			GdkRectangle _tmp23_;
			self->priv->static_dock_region.y = yoffset;
			_tmp23_ = self->priv->static_dock_region;
			self->priv->static_dock_region.x = self->priv->DockWidth - _tmp23_.width;
			break;
		}
	}
	plank_position_manager_update_dock_position (self);
	_tmp28_ = self->priv->_screen_is_composited;
	if (!_tmp28_) {
		_tmp27_ = TRUE;
	} else {
		GdkRectangle _tmp29_;
		GdkRectangle _tmp30_;
		_tmp29_ = old_region;
		_tmp30_ = self->priv->static_dock_region;
		_tmp27_ = _tmp29_.x != _tmp30_.x;
	}
	if (_tmp27_) {
		_tmp26_ = TRUE;
	} else {
		GdkRectangle _tmp31_;
		GdkRectangle _tmp32_;
		_tmp31_ = old_region;
		_tmp32_ = self->priv->static_dock_region;
		_tmp26_ = _tmp31_.y != _tmp32_.y;
	}
	if (_tmp26_) {
		_tmp25_ = TRUE;
	} else {
		GdkRectangle _tmp33_;
		GdkRectangle _tmp34_;
		_tmp33_ = old_region;
		_tmp34_ = self->priv->static_dock_region;
		_tmp25_ = _tmp33_.width != _tmp34_.width;
	}
	if (_tmp25_) {
		_tmp24_ = TRUE;
	} else {
		GdkRectangle _tmp35_;
		GdkRectangle _tmp36_;
		_tmp35_ = old_region;
		_tmp36_ = self->priv->static_dock_region;
		_tmp24_ = _tmp35_.height != _tmp36_.height;
	}
	if (_tmp24_) {
		PlankDockController* _tmp37_;
		PlankDockWindow* _tmp38_;
		PlankDockWindow* _tmp39_;
		PlankDockController* _tmp40_;
		PlankHideManager* _tmp41_;
		PlankHideManager* _tmp42_;
		gboolean _tmp43_;
		_tmp37_ = self->priv->_controller;
		_tmp38_ = plank_dock_controller_get_window (_tmp37_);
		_tmp39_ = _tmp38_;
		plank_dock_window_update_size_and_position (_tmp39_);
		_tmp40_ = self->priv->_controller;
		_tmp41_ = plank_dock_controller_get_hide_manager (_tmp40_);
		_tmp42_ = _tmp41_;
		plank_hide_manager_update_barrier (_tmp42_);
		_tmp43_ = self->priv->_screen_is_composited;
		if (_tmp43_) {
			PlankDockController* _tmp44_;
			PlankDockRenderer* _tmp45_;
			PlankDockRenderer* _tmp46_;
			_tmp44_ = self->priv->_controller;
			_tmp45_ = plank_dock_controller_get_renderer (_tmp44_);
			_tmp46_ = _tmp45_;
			plank_renderer_animated_draw ((PlankRenderer*) _tmp46_);
		}
	} else {
		PlankDockController* _tmp47_;
		PlankDockRenderer* _tmp48_;
		PlankDockRenderer* _tmp49_;
		_tmp47_ = self->priv->_controller;
		_tmp48_ = plank_dock_controller_get_renderer (_tmp47_);
		_tmp49_ = _tmp48_;
		plank_renderer_animated_draw ((PlankRenderer*) _tmp49_);
	}
}

/**
 * The draw-value for a dock item.
 *
 * @param item the dock item to find the drawvalue for
 * @return the region for the dock item
 */
PlankDockItemDrawValue*
plank_position_manager_get_draw_value_for_item (PlankPositionManager* self,
                                                PlankDockItem* item)
{
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	PlankDockItemDrawValue* draw_value = NULL;
	GeeHashMap* _tmp6_;
	gpointer _tmp7_;
	PlankDockItemDrawValue* _tmp8_;
	PlankDockItemDrawValue* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = self->priv->draw_values;
	_tmp1_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		PlankDockController* _tmp3_;
		GeeArrayList* _tmp4_;
		GeeArrayList* _tmp5_;
		g_debug ("PositionManager.vala:675: Without draw_values there is trouble ahead");
		_tmp3_ = self->priv->_controller;
		_tmp4_ = plank_dock_controller_get_VisibleItems (_tmp3_);
		_tmp5_ = _tmp4_;
		plank_position_manager_update_draw_values (self, _tmp5_, NULL, NULL, NULL, NULL);
	}
	_tmp6_ = self->priv->draw_values;
	_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp6_, (PlankDockElement*) item);
	draw_value = (PlankDockItemDrawValue*) _tmp7_;
	_tmp8_ = draw_value;
	if (_tmp8_ == NULL) {
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		PlankDockItemDrawValue* _tmp11_;
		_tmp9_ = plank_dock_element_get_Text ((PlankDockElement*) item);
		_tmp10_ = _tmp9_;
		g_warning ("PositionManager.vala:681: Without a draw_value there is trouble ahead " \
"for '%s'", _tmp10_);
		_tmp11_ = plank_dock_item_draw_value_new ();
		_plank_dock_item_draw_value_unref0 (draw_value);
		draw_value = _tmp11_;
	}
	result = draw_value;
	return result;
}

/**
 * Update and recalculated all internal draw-values using the given methodes for custom manipulations.
 *
 * @param items the ordered list of all current item which are suppose to be shown on the dock
 * @param func a function which adjusts the draw-value per item
 * @param post_func a function which post-processes all draw-values
 */
static gboolean
__lambda29_ (PlankPositionManager* self,
             PlankDockElement* i,
             PlankDockItemDrawValue* val)
{
	GdkRectangle _tmp0_ = {0};
	GdkRectangle _tmp1_ = {0};
	GdkRectangle _tmp2_ = {0};
	gboolean result;
	g_return_val_if_fail (i != NULL, FALSE);
	g_return_val_if_fail (val != NULL, FALSE);
	plank_position_manager_get_item_draw_region (self, val, &_tmp0_);
	val->draw_region = _tmp0_;
	plank_position_manager_get_item_hover_region (self, val, &_tmp1_);
	val->hover_region = _tmp1_;
	plank_position_manager_get_item_background_region (self, val, &_tmp2_);
	val->background_region = _tmp2_;
	result = TRUE;
	return result;
}

static gboolean
___lambda29__gee_forall_map_func (gconstpointer k,
                                  gconstpointer v,
                                  gpointer self)
{
	gboolean result;
	result = __lambda29_ ((PlankPositionManager*) self, (PlankDockElement*) k, (PlankDockItemDrawValue*) v);
	return result;
}

void
plank_position_manager_update_draw_values (PlankPositionManager* self,
                                           GeeArrayList* items,
                                           PlankDrawValueFunc func,
                                           gpointer func_target,
                                           PlankDrawValuesFunc post_func,
                                           gpointer post_func_target)
{
	PlankDockPreferences* prefs = NULL;
	PlankDockController* _tmp0_;
	PlankDockPreferences* _tmp1_;
	PlankDockPreferences* _tmp2_;
	PlankDockRenderer* renderer = NULL;
	PlankDockController* _tmp3_;
	PlankDockRenderer* _tmp4_;
	PlankDockRenderer* _tmp5_;
	GeeHashMap* _tmp6_;
	gint width = 0;
	gint height = 0;
	gint icon_size = 0;
	gint _tmp7_;
	GdkPoint cursor = {0};
	PlankDockRenderer* _tmp8_;
	GdkPoint _tmp9_ = {0};
	GdkPoint _tmp10_;
	GtkPositionType _tmp11_;
	gdouble _tmp16_ = 0.0;
	gdouble center_y = 0.0;
	gdouble center_x = 0.0;
	gint _tmp19_;
	GtkAlign _tmp20_;
	PlankPointD center = {0};
	PlankPointD _tmp32_ = {0};
	gboolean _tmp33_ = FALSE;
	PlankDockController* _tmp34_;
	PlankDragManager* _tmp35_;
	PlankDragManager* _tmp36_;
	gboolean _tmp37_;
	gboolean _tmp38_;
	gboolean expand_for_drop = FALSE;
	gboolean zoom_enabled = FALSE;
	PlankDockPreferences* _tmp42_;
	gboolean _tmp43_;
	gboolean _tmp44_;
	gdouble _tmp45_ = 0.0;
	gboolean _tmp46_ = FALSE;
	gdouble zoom_in_progress = 0.0;
	gdouble _tmp50_ = 0.0;
	gdouble zoom_in_percent = 0.0;
	gdouble zoom_icon_size = 0.0;
	gint _tmp51_;
	GeeHashMap* _tmp110_;
	gpointer _tmp111_;
	gpointer _tmp112_;
	PlankDockItemDrawValue* _tmp113_;
	GeeHashMap* _tmp114_;
	gpointer _tmp115_;
	gpointer _tmp116_;
	PlankDockItemDrawValue* _tmp117_;
	GeeHashMap* _tmp118_;
	GeeMapIterator* _tmp119_;
	GeeMapIterator* _tmp120_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (items != NULL);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_prefs (_tmp0_);
	_tmp2_ = _tmp1_;
	prefs = _tmp2_;
	_tmp3_ = self->priv->_controller;
	_tmp4_ = plank_dock_controller_get_renderer (_tmp3_);
	_tmp5_ = _tmp4_;
	renderer = _tmp5_;
	_tmp6_ = self->priv->draw_values;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp6_);
	width = self->priv->DockWidth;
	height = self->priv->DockHeight;
	_tmp7_ = self->priv->_IconSize;
	icon_size = _tmp7_;
	_tmp8_ = renderer;
	plank_dock_renderer_get_local_cursor (_tmp8_, &_tmp9_);
	_tmp10_ = _tmp9_;
	cursor = _tmp10_;
	_tmp11_ = self->priv->_Position;
	switch (_tmp11_) {
		case GTK_POS_RIGHT:
		{
			GdkPoint _tmp12_;
			_tmp12_ = cursor;
			cursor.x = width - _tmp12_.x;
			break;
		}
		case GTK_POS_BOTTOM:
		{
			GdkPoint _tmp13_;
			_tmp13_ = cursor;
			cursor.y = height - _tmp13_.y;
			break;
		}
		default:
		{
			break;
		}
	}
	if (!plank_position_manager_is_horizontal_dock (self)) {
		gint tmp = 0;
		GdkPoint _tmp14_;
		GdkPoint _tmp15_;
		_tmp14_ = cursor;
		tmp = _tmp14_.y;
		_tmp15_ = cursor;
		cursor.y = _tmp15_.x;
		cursor.x = tmp;
		tmp = width;
		width = height;
		height = tmp;
	}
	if (plank_position_manager_is_horizontal_dock (self)) {
		GdkRectangle _tmp17_;
		_tmp17_ = self->priv->static_dock_region;
		_tmp16_ = _tmp17_.height / 2.0;
	} else {
		GdkRectangle _tmp18_;
		_tmp18_ = self->priv->static_dock_region;
		_tmp16_ = _tmp18_.width / 2.0;
	}
	center_y = _tmp16_;
	_tmp19_ = self->priv->_ItemPadding;
	center_x = ((icon_size + _tmp19_) / 2.0) + self->priv->items_offset;
	_tmp20_ = self->priv->_Alignment;
	if (_tmp20_ == GTK_ALIGN_FILL) {
		GtkAlign _tmp21_;
		_tmp21_ = self->priv->_ItemsAlignment;
		switch (_tmp21_) {
			default:
			case GTK_ALIGN_FILL:
			case GTK_ALIGN_CENTER:
			{
				if (plank_position_manager_is_horizontal_dock (self)) {
					GdkRectangle _tmp22_;
					GdkRectangle _tmp23_;
					_tmp22_ = self->priv->static_dock_region;
					_tmp23_ = self->priv->static_dock_region;
					center_x += (gdouble) (_tmp22_.x + (((_tmp23_.width - (2 * self->priv->items_offset)) - self->priv->items_width) / 2));
				} else {
					GdkRectangle _tmp24_;
					GdkRectangle _tmp25_;
					_tmp24_ = self->priv->static_dock_region;
					_tmp25_ = self->priv->static_dock_region;
					center_x += (gdouble) (_tmp24_.y + (((_tmp25_.height - (2 * self->priv->items_offset)) - self->priv->items_width) / 2));
				}
				break;
			}
			case GTK_ALIGN_START:
			{
				break;
			}
			case GTK_ALIGN_END:
			{
				if (plank_position_manager_is_horizontal_dock (self)) {
					GdkRectangle _tmp26_;
					GdkRectangle _tmp27_;
					_tmp26_ = self->priv->static_dock_region;
					_tmp27_ = self->priv->static_dock_region;
					center_x += (gdouble) (_tmp26_.x + ((_tmp27_.width - (2 * self->priv->items_offset)) - self->priv->items_width));
				} else {
					GdkRectangle _tmp28_;
					GdkRectangle _tmp29_;
					_tmp28_ = self->priv->static_dock_region;
					_tmp29_ = self->priv->static_dock_region;
					center_x += (gdouble) (_tmp28_.y + ((_tmp29_.height - (2 * self->priv->items_offset)) - self->priv->items_width));
				}
				break;
			}
		}
	} else {
		if (plank_position_manager_is_horizontal_dock (self)) {
			GdkRectangle _tmp30_;
			_tmp30_ = self->priv->static_dock_region;
			center_x += (gdouble) _tmp30_.x;
		} else {
			GdkRectangle _tmp31_;
			_tmp31_ = self->priv->static_dock_region;
			center_x += (gdouble) _tmp31_.y;
		}
	}
	_tmp32_.x = floor (center_x);
	_tmp32_.y = floor (center_y);
	center = _tmp32_;
	_tmp34_ = self->priv->_controller;
	_tmp35_ = plank_dock_controller_get_drag_manager (_tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = plank_drag_manager_get_ExternalDragActive (_tmp36_);
	_tmp38_ = _tmp37_;
	if (_tmp38_) {
		PlankDockPreferences* _tmp39_;
		gboolean _tmp40_;
		gboolean _tmp41_;
		_tmp39_ = prefs;
		_tmp40_ = plank_dock_preferences_get_LockItems (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp33_ = !_tmp41_;
	} else {
		_tmp33_ = FALSE;
	}
	expand_for_drop = _tmp33_;
	_tmp42_ = prefs;
	_tmp43_ = plank_dock_preferences_get_ZoomEnabled (_tmp42_);
	_tmp44_ = _tmp43_;
	zoom_enabled = _tmp44_;
	if (zoom_enabled) {
		_tmp46_ = TRUE;
	} else {
		_tmp46_ = expand_for_drop;
	}
	if (_tmp46_) {
		PlankDockRenderer* _tmp47_;
		gdouble _tmp48_;
		gdouble _tmp49_;
		_tmp47_ = renderer;
		_tmp48_ = plank_dock_renderer_get_zoom_in_progress (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp45_ = _tmp49_;
	} else {
		_tmp45_ = 0.0;
	}
	zoom_in_progress = _tmp45_;
	if (zoom_enabled) {
		_tmp50_ = 1.0 + ((self->priv->ZoomPercent - 1.0) * zoom_in_progress);
	} else {
		_tmp50_ = 1.0;
	}
	zoom_in_percent = _tmp50_;
	_tmp51_ = self->priv->_ZoomIconSize;
	zoom_icon_size = (gdouble) _tmp51_;
	{
		GeeArrayList* _item_list = NULL;
		gint _item_size = 0;
		GeeArrayList* _tmp52_;
		gint _tmp53_;
		gint _tmp54_;
		gint _item_index = 0;
		_item_list = items;
		_tmp52_ = _item_list;
		_tmp53_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp52_);
		_tmp54_ = _tmp53_;
		_item_size = _tmp54_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp55_;
			gint _tmp56_;
			PlankDockItem* item = NULL;
			GeeArrayList* _tmp57_;
			gpointer _tmp58_;
			PlankDockItemDrawValue* val = NULL;
			PlankDockItemDrawValue* _tmp59_;
			PlankDockItemDrawValue* _tmp60_;
			PlankDockItemDrawValue* _tmp61_;
			PlankDockItemDrawValue* _tmp62_;
			PlankDockItemDrawValue* _tmp63_;
			PlankDockItemDrawValue* _tmp64_;
			PlankDockItemDrawValue* _tmp65_;
			PlankPointD _tmp66_;
			gdouble cursor_position = 0.0;
			GdkPoint _tmp67_;
			gdouble center_position = 0.0;
			PlankPointD _tmp68_;
			gdouble offset = 0.0;
			gdouble offset_percent = 0.0;
			gdouble zoom = 0.0;
			gdouble zoomed_center_height = 0.0;
			PlankDockItemDrawValue* _tmp69_;
			PlankPointD _tmp70_ = {0};
			PlankDockItemDrawValue* _tmp71_;
			PlankDockItemDrawValue* _tmp72_;
			GtkPositionType _tmp85_;
			PlankDockItemDrawValue* _tmp98_;
			GtkPositionType _tmp99_;
			GeeHashMap* _tmp102_;
			PlankDockItem* _tmp103_;
			PlankDockItemDrawValue* _tmp104_;
			PlankDockItem* _tmp105_;
			gint64 _tmp106_;
			gint64 _tmp107_;
			_item_index = _item_index + 1;
			_tmp55_ = _item_index;
			_tmp56_ = _item_size;
			if (!(_tmp55_ < _tmp56_)) {
				break;
			}
			_tmp57_ = _item_list;
			_tmp58_ = gee_abstract_list_get ((GeeAbstractList*) _tmp57_, _item_index);
			item = (PlankDockItem*) _tmp58_;
			_tmp59_ = plank_dock_item_draw_value_new ();
			val = _tmp59_;
			_tmp60_ = val;
			_tmp60_->opacity = 1.0;
			_tmp61_ = val;
			_tmp61_->darken = 0.0;
			_tmp62_ = val;
			_tmp62_->lighten = 0.0;
			_tmp63_ = val;
			_tmp63_->show_indicator = TRUE;
			_tmp64_ = val;
			_tmp64_->zoom = 1.0;
			_tmp65_ = val;
			_tmp66_ = center;
			_tmp65_->static_center = _tmp66_;
			_tmp67_ = cursor;
			cursor_position = (gdouble) _tmp67_.x;
			_tmp68_ = center;
			center_position = _tmp68_.x;
			offset = MIN (fabs (cursor_position - center_position), zoom_icon_size);
			if (expand_for_drop) {
				offset += (offset * zoom_icon_size) / icon_size;
				offset_percent = MIN (1.0, offset / (2.0 * zoom_icon_size));
			} else {
				offset_percent = offset / zoom_icon_size;
			}
			if (offset_percent > 0.99) {
				offset_percent = 1.0;
			}
			if (expand_for_drop) {
				offset *= zoom_in_progress / 2.0;
			} else {
				offset *= zoom_in_percent - 1.0;
			}
			offset *= 1.0 - (offset_percent / 3.0);
			if (cursor_position > center_position) {
				center_position -= offset;
			} else {
				center_position += offset;
			}
			zoom = 1.0 - pow (offset_percent, (gdouble) 2);
			zoom = 1.0 + (zoom * (zoom_in_percent - 1.0));
			zoomed_center_height = (icon_size * zoom) / 2.0;
			if (zoom == 1.0) {
				center_position = round (center_position);
			}
			_tmp69_ = val;
			_tmp70_.x = center_position;
			_tmp70_.y = zoomed_center_height;
			_tmp69_->center = _tmp70_;
			_tmp71_ = val;
			_tmp71_->zoom = zoom;
			_tmp72_ = val;
			_tmp72_->icon_size = round (zoom * icon_size);
			if (!plank_position_manager_is_horizontal_dock (self)) {
				gdouble tmp = 0.0;
				PlankDockItemDrawValue* _tmp73_;
				PlankPointD _tmp74_;
				PlankDockItemDrawValue* _tmp75_;
				PlankDockItemDrawValue* _tmp76_;
				PlankPointD _tmp77_;
				PlankDockItemDrawValue* _tmp78_;
				PlankDockItemDrawValue* _tmp79_;
				PlankPointD _tmp80_;
				PlankDockItemDrawValue* _tmp81_;
				PlankDockItemDrawValue* _tmp82_;
				PlankPointD _tmp83_;
				PlankDockItemDrawValue* _tmp84_;
				_tmp73_ = val;
				_tmp74_ = _tmp73_->center;
				tmp = _tmp74_.y;
				_tmp75_ = val;
				_tmp76_ = val;
				_tmp77_ = _tmp76_->center;
				_tmp75_->center.y = _tmp77_.x;
				_tmp78_ = val;
				_tmp78_->center.x = tmp;
				_tmp79_ = val;
				_tmp80_ = _tmp79_->static_center;
				tmp = _tmp80_.y;
				_tmp81_ = val;
				_tmp82_ = val;
				_tmp83_ = _tmp82_->static_center;
				_tmp81_->static_center.y = _tmp83_.x;
				_tmp84_ = val;
				_tmp84_->static_center.x = tmp;
			}
			_tmp85_ = self->priv->_Position;
			switch (_tmp85_) {
				case GTK_POS_RIGHT:
				{
					PlankDockItemDrawValue* _tmp86_;
					PlankDockItemDrawValue* _tmp87_;
					PlankPointD _tmp88_;
					PlankDockItemDrawValue* _tmp89_;
					PlankDockItemDrawValue* _tmp90_;
					PlankPointD _tmp91_;
					_tmp86_ = val;
					_tmp87_ = val;
					_tmp88_ = _tmp87_->center;
					_tmp86_->center.x = height - _tmp88_.x;
					_tmp89_ = val;
					_tmp90_ = val;
					_tmp91_ = _tmp90_->static_center;
					_tmp89_->static_center.x = height - _tmp91_.x;
					break;
				}
				case GTK_POS_BOTTOM:
				{
					PlankDockItemDrawValue* _tmp92_;
					PlankDockItemDrawValue* _tmp93_;
					PlankPointD _tmp94_;
					PlankDockItemDrawValue* _tmp95_;
					PlankDockItemDrawValue* _tmp96_;
					PlankPointD _tmp97_;
					_tmp92_ = val;
					_tmp93_ = val;
					_tmp94_ = _tmp93_->center;
					_tmp92_->center.y = height - _tmp94_.y;
					_tmp95_ = val;
					_tmp96_ = val;
					_tmp97_ = _tmp96_->static_center;
					_tmp95_->static_center.y = height - _tmp97_.y;
					break;
				}
				default:
				{
					break;
				}
			}
			_tmp98_ = val;
			_tmp99_ = self->priv->_Position;
			plank_dock_item_draw_value_move_in (_tmp98_, _tmp99_, (gdouble) self->priv->bottom_offset);
			if (func != NULL) {
				PlankDockItem* _tmp100_;
				PlankDockItemDrawValue* _tmp101_;
				_tmp100_ = item;
				_tmp101_ = val;
				func (_tmp100_, _tmp101_, func_target);
			}
			_tmp102_ = self->priv->draw_values;
			_tmp103_ = item;
			_tmp104_ = val;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp102_, (PlankDockElement*) _tmp103_, _tmp104_);
			_tmp105_ = item;
			_tmp106_ = plank_dock_element_get_RemoveTime ((PlankDockElement*) _tmp105_);
			_tmp107_ = _tmp106_;
			if (_tmp107_ == ((gint64) 0)) {
				gint _tmp108_;
				_tmp108_ = self->priv->_ItemPadding;
				center.x = center.x + (icon_size + _tmp108_);
			}
			_plank_dock_item_draw_value_unref0 (val);
		}
	}
	if (post_func != NULL) {
		GeeHashMap* _tmp109_;
		_tmp109_ = self->priv->draw_values;
		post_func (_tmp109_, post_func_target);
	}
	_tmp110_ = self->priv->draw_values;
	_tmp111_ = gee_list_first ((GeeList*) items);
	_tmp112_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp110_, (PlankDockElement*) ((PlankDockItem*) _tmp111_));
	_tmp113_ = (PlankDockItemDrawValue*) _tmp112_;
	_tmp114_ = self->priv->draw_values;
	_tmp115_ = gee_list_last ((GeeList*) items);
	_tmp116_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp114_, (PlankDockElement*) ((PlankDockItem*) _tmp115_));
	_tmp117_ = (PlankDockItemDrawValue*) _tmp116_;
	plank_position_manager_update_background_region (self, _tmp113_, _tmp117_);
	_plank_dock_item_draw_value_unref0 (_tmp117_);
	_plank_dock_item_draw_value_unref0 (_tmp113_);
	_tmp118_ = self->priv->draw_values;
	_tmp119_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp118_);
	_tmp120_ = _tmp119_;
	gee_map_iterator_foreach (_tmp120_, ___lambda29__gee_forall_map_func, self);
	_g_object_unref0 (_tmp120_);
}

/**
 * The region for drawing a dock item.
 *
 * @param val the item's DockItemDrawValue
 * @return the region for the dock item
 */
static void
plank_position_manager_get_item_draw_region (PlankPositionManager* self,
                                             PlankDockItemDrawValue* val,
                                             GdkRectangle* result)
{
	gdouble width = 0.0;
	gdouble height = 0.0;
	PlankPointD _tmp0_;
	PlankPointD _tmp1_;
	GdkRectangle _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (val != NULL);
	width = val->icon_size;
	height = val->icon_size;
	_tmp0_ = val->center;
	_tmp1_ = val->center;
	_tmp2_.x = (gint) round (_tmp0_.x - (width / 2.0));
	_tmp2_.y = (gint) round (_tmp1_.y - (height / 2.0));
	_tmp2_.width = (gint) width;
	_tmp2_.height = (gint) height;
	*result = _tmp2_;
	return;
}

/**
 * The intersecting region of a dock item's hover region and the background.
 *
 * @param val the item's DockItemDrawValue
 * @return the region for the dock item
 */
static void
plank_position_manager_get_item_background_region (PlankPositionManager* self,
                                                   PlankDockItemDrawValue* val,
                                                   GdkRectangle* result)
{
	GdkRectangle rect = {0};
	GdkRectangle hover_region = {0};
	GdkRectangle _tmp0_;
	GtkPositionType _tmp1_;
	GdkRectangle _tmp16_;
	GdkRectangle _tmp17_ = {0};
	gboolean _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = val->hover_region;
	hover_region = _tmp0_;
	_tmp1_ = self->priv->_Position;
	switch (_tmp1_) {
		default:
		case GTK_POS_BOTTOM:
		{
			GdkRectangle _tmp2_;
			GdkRectangle _tmp3_;
			GdkRectangle _tmp4_;
			_tmp2_ = self->priv->background_rect;
			_tmp3_ = self->priv->background_rect;
			_tmp4_ = hover_region;
			hover_region.height = abs ((_tmp2_.y + _tmp3_.height) - _tmp4_.y);
			break;
		}
		case GTK_POS_TOP:
		{
			GdkRectangle _tmp5_;
			GdkRectangle _tmp6_;
			GdkRectangle _tmp7_;
			GdkRectangle _tmp8_;
			_tmp5_ = self->priv->background_rect;
			hover_region.y = _tmp5_.y;
			_tmp6_ = hover_region;
			_tmp7_ = self->priv->background_rect;
			_tmp8_ = self->priv->background_rect;
			hover_region.height = abs ((_tmp6_.y - _tmp7_.y) + _tmp8_.height);
			break;
		}
		case GTK_POS_LEFT:
		{
			GdkRectangle _tmp9_;
			GdkRectangle _tmp10_;
			GdkRectangle _tmp11_;
			GdkRectangle _tmp12_;
			_tmp9_ = self->priv->background_rect;
			hover_region.x = _tmp9_.x;
			_tmp10_ = hover_region;
			_tmp11_ = self->priv->background_rect;
			_tmp12_ = self->priv->background_rect;
			hover_region.width = abs ((_tmp10_.x - _tmp11_.x) + _tmp12_.width);
			break;
		}
		case GTK_POS_RIGHT:
		{
			GdkRectangle _tmp13_;
			GdkRectangle _tmp14_;
			GdkRectangle _tmp15_;
			_tmp13_ = self->priv->background_rect;
			_tmp14_ = self->priv->background_rect;
			_tmp15_ = hover_region;
			hover_region.width = abs ((_tmp13_.x + _tmp14_.width) - _tmp15_.x);
			break;
		}
	}
	_tmp16_ = self->priv->background_rect;
	_tmp18_ = gdk_rectangle_intersect (&hover_region, &_tmp16_, &_tmp17_);
	rect = _tmp17_;
	if (!_tmp18_) {
		GdkRectangle _tmp19_ = {0};
		*result = _tmp19_;
		return;
	}
	*result = rect;
	return;
}

/**
 * The cursor region for interacting with a dock element.
 *
 * @param val the item's DockItemDrawValue
 * @return the region for the dock item
 */
static void
plank_position_manager_get_item_hover_region (PlankPositionManager* self,
                                              PlankDockItemDrawValue* val,
                                              GdkRectangle* result)
{
	GdkRectangle rect = {0};
	gint item_padding = 0;
	gint _tmp0_;
	gint _tmp1_ = 0;
	gint top_padding = 0;
	gint bottom_padding = 0;
	gdouble width = 0.0;
	gdouble height = 0.0;
	GtkPositionType _tmp2_;
	PlankPointD _tmp3_;
	PlankPointD _tmp4_;
	GdkRectangle _tmp5_ = {0};
	GtkPositionType _tmp6_;
	GdkRectangle background_region = {0};
	GdkRectangle _tmp7_ = {0};
	GdkRectangle _tmp8_ = {0};
	gboolean _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = self->priv->_ItemPadding;
	item_padding = _tmp0_;
	if (self->priv->top_offset < 0) {
		_tmp1_ = 0;
	} else {
		_tmp1_ = self->priv->top_offset;
	}
	top_padding = _tmp1_;
	bottom_padding = self->priv->bottom_offset;
	width = val->icon_size;
	height = val->icon_size;
	_tmp2_ = self->priv->_Position;
	switch (_tmp2_) {
		default:
		case GTK_POS_BOTTOM:
		{
			width += (gdouble) item_padding;
			break;
		}
		case GTK_POS_TOP:
		{
			width += (gdouble) item_padding;
			break;
		}
		case GTK_POS_LEFT:
		{
			height += (gdouble) item_padding;
			break;
		}
		case GTK_POS_RIGHT:
		{
			height += (gdouble) item_padding;
			break;
		}
	}
	_tmp3_ = val->center;
	_tmp4_ = val->center;
	_tmp5_.x = (gint) round (_tmp3_.x - (width / 2.0));
	_tmp5_.y = (gint) round (_tmp4_.y - (height / 2.0));
	_tmp5_.width = (gint) width;
	_tmp5_.height = (gint) height;
	rect = _tmp5_;
	_tmp6_ = self->priv->_Position;
	switch (_tmp6_) {
		default:
		case GTK_POS_BOTTOM:
		{
			rect.y = rect.y - top_padding;
			rect.height = rect.height + (bottom_padding + top_padding);
			break;
		}
		case GTK_POS_TOP:
		{
			rect.y = rect.y - bottom_padding;
			rect.height = rect.height + (bottom_padding + top_padding);
			break;
		}
		case GTK_POS_LEFT:
		{
			rect.x = rect.x - bottom_padding;
			rect.width = rect.width + (bottom_padding + top_padding);
			break;
		}
		case GTK_POS_RIGHT:
		{
			rect.x = rect.x - top_padding;
			rect.width = rect.width + (bottom_padding + top_padding);
			break;
		}
	}
	plank_position_manager_get_background_region (self, &_tmp7_);
	_tmp9_ = gdk_rectangle_intersect (&rect, &_tmp7_, &_tmp8_);
	background_region = _tmp8_;
	if (_tmp9_) {
		GdkRectangle _tmp10_ = {0};
		GdkRectangle _tmp11_ = {0};
		plank_position_manager_get_item_draw_region (self, val, &_tmp10_);
		gdk_rectangle_union (&background_region, &_tmp10_, &_tmp11_);
		rect = _tmp11_;
	}
	*result = rect;
	return;
}

/**
 * The cursor region for interacting with a dock element.
 *
 * @param element the dock element to find a region for
 * @return the region for the dock item
 */
void
plank_position_manager_get_hover_region_for_element (PlankPositionManager* self,
                                                     PlankDockElement* element,
                                                     GdkRectangle* result)
{
	PlankDockItem* item = NULL;
	PlankDockItem* _tmp0_;
	PlankDockContainer* container = NULL;
	PlankDockContainer* _tmp6_;
	GeeArrayList* items = NULL;
	PlankDockContainer* _tmp8_;
	GeeArrayList* _tmp9_;
	GeeArrayList* _tmp10_;
	GeeArrayList* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	GdkRectangle first_rect = {0};
	GeeArrayList* _tmp15_;
	gpointer _tmp16_;
	PlankDockElement* _tmp17_;
	GdkRectangle _tmp18_ = {0};
	GdkRectangle _tmp19_;
	GeeArrayList* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	GdkRectangle last_rect = {0};
	GeeArrayList* _tmp23_;
	gpointer _tmp24_;
	PlankDockElement* _tmp25_;
	GdkRectangle _tmp26_ = {0};
	GdkRectangle _tmp27_;
	GdkRectangle _result_ = {0};
	GdkRectangle _tmp28_;
	GdkRectangle _tmp29_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	item = PLANK_IS_DOCK_ITEM (element) ? ((PlankDockItem*) element) : NULL;
	_tmp0_ = item;
	if (_tmp0_ != NULL) {
		PlankDockItem* _tmp1_;
		PlankDockItemDrawValue* _tmp2_;
		PlankDockItemDrawValue* _tmp3_;
		GdkRectangle _tmp4_;
		GdkRectangle _tmp5_;
		_tmp1_ = item;
		_tmp2_ = plank_position_manager_get_draw_value_for_item (self, _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_->hover_region;
		_tmp5_ = _tmp4_;
		_plank_dock_item_draw_value_unref0 (_tmp3_);
		*result = _tmp5_;
		return;
	}
	container = PLANK_IS_DOCK_CONTAINER (element) ? ((PlankDockContainer*) element) : NULL;
	_tmp6_ = container;
	if (_tmp6_ == NULL) {
		GdkRectangle _tmp7_ = {0};
		*result = _tmp7_;
		return;
	}
	_tmp8_ = container;
	_tmp9_ = plank_dock_container_get_VisibleElements (_tmp8_);
	_tmp10_ = _tmp9_;
	items = _tmp10_;
	_tmp11_ = items;
	_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_ == 0) {
		GdkRectangle _tmp14_ = {0};
		*result = _tmp14_;
		return;
	}
	_tmp15_ = items;
	_tmp16_ = gee_list_first ((GeeList*) _tmp15_);
	_tmp17_ = (PlankDockElement*) _tmp16_;
	plank_position_manager_get_hover_region_for_element (self, _tmp17_, &_tmp18_);
	_tmp19_ = _tmp18_;
	_g_object_unref0 (_tmp17_);
	first_rect = _tmp19_;
	_tmp20_ = items;
	_tmp21_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp20_);
	_tmp22_ = _tmp21_;
	if (_tmp22_ == 1) {
		*result = first_rect;
		return;
	}
	_tmp23_ = items;
	_tmp24_ = gee_list_last ((GeeList*) _tmp23_);
	_tmp25_ = (PlankDockElement*) _tmp24_;
	plank_position_manager_get_hover_region_for_element (self, _tmp25_, &_tmp26_);
	_tmp27_ = _tmp26_;
	_g_object_unref0 (_tmp25_);
	last_rect = _tmp27_;
	_tmp28_ = last_rect;
	gdk_rectangle_union (&first_rect, &_tmp28_, &_tmp29_);
	_result_ = _tmp29_;
	*result = _result_;
	return;
}

/**
 * Get the item which is the nearest at the given coordinates. If a container is given
 * the result will be restricted to its children.
 *
 * @param x the x position
 * @param y the y position
 * @param container a container or NULL 
 */
PlankDockItem*
plank_position_manager_get_nearest_item_at (PlankPositionManager* self,
                                            gint x,
                                            gint y,
                                            PlankDockContainer* container)
{
	PlankDockItem* _result_ = NULL;
	gdouble square_distance = 0.0;
	GeeMapIterator* draw_values_it = NULL;
	GeeHashMap* _tmp0_;
	GeeMapIterator* _tmp1_;
	PlankDockItem* _tmp21_;
	PlankDockItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = NULL;
	square_distance = DBL_MAX;
	_tmp0_ = self->priv->draw_values;
	_tmp1_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp0_);
	draw_values_it = _tmp1_;
	while (TRUE) {
		GeeMapIterator* _tmp2_;
		PlankDockItemDrawValue* val = NULL;
		GeeMapIterator* _tmp3_;
		gpointer _tmp4_;
		PlankPointD center = {0};
		PlankDockItemDrawValue* _tmp5_;
		PlankPointD _tmp6_;
		gdouble new_square_distance = 0.0;
		PlankPointD _tmp7_;
		PlankPointD _tmp8_;
		PlankPointD _tmp9_;
		PlankPointD _tmp10_;
		_tmp2_ = draw_values_it;
		if (!gee_map_iterator_next (_tmp2_)) {
			break;
		}
		_tmp3_ = draw_values_it;
		_tmp4_ = gee_map_iterator_get_value (_tmp3_);
		val = (PlankDockItemDrawValue*) _tmp4_;
		_tmp5_ = val;
		_tmp6_ = _tmp5_->static_center;
		center = _tmp6_;
		_tmp7_ = center;
		_tmp8_ = center;
		_tmp9_ = center;
		_tmp10_ = center;
		new_square_distance = ((x - _tmp7_.x) * (x - _tmp8_.x)) + ((y - _tmp9_.y) * (y - _tmp10_.y));
		if (square_distance > new_square_distance) {
			PlankDockItem* item = NULL;
			GeeMapIterator* _tmp11_;
			gpointer _tmp12_;
			PlankDockElement* _tmp13_;
			PlankDockItem* _tmp14_;
			PlankDockItem* _tmp15_;
			gboolean _tmp16_ = FALSE;
			_tmp11_ = draw_values_it;
			_tmp12_ = gee_map_iterator_get_key (_tmp11_);
			_tmp13_ = (PlankDockElement*) _tmp12_;
			_tmp14_ = PLANK_IS_DOCK_ITEM (_tmp13_) ? ((PlankDockItem*) _tmp13_) : NULL;
			if (_tmp14_ == NULL) {
				_g_object_unref0 (_tmp13_);
			}
			item = _tmp14_;
			_tmp15_ = item;
			if (_tmp15_ == NULL) {
				_g_object_unref0 (item);
				_plank_dock_item_draw_value_unref0 (val);
				continue;
			}
			if (container == NULL) {
				_tmp16_ = TRUE;
			} else {
				PlankDockItem* _tmp17_;
				PlankDockContainer* _tmp18_;
				PlankDockContainer* _tmp19_;
				_tmp17_ = item;
				_tmp18_ = plank_dock_element_get_Container ((PlankDockElement*) _tmp17_);
				_tmp19_ = _tmp18_;
				_tmp16_ = _tmp19_ == container;
			}
			if (_tmp16_) {
				PlankDockItem* _tmp20_;
				square_distance = new_square_distance;
				_tmp20_ = item;
				_result_ = _tmp20_;
			}
			_g_object_unref0 (item);
		}
		_plank_dock_item_draw_value_unref0 (val);
	}
	_tmp21_ = _result_;
	result = _tmp21_;
	_g_object_unref0 (draw_values_it);
	return result;
}

/**
 * Get the item which is the appropriate target for a drag'n'drop action.
 * The returned item may not hovered and is meant to be used as target
 * for e.g. DockContainer.add/move_to functions.
 * If a container is given the result will be restricted to its children.
 *
 * @param container a container or NULL 
 */
PlankDockItem*
plank_position_manager_get_current_target_item (PlankPositionManager* self,
                                                PlankDockContainer* container)
{
	PlankDockRenderer* renderer = NULL;
	PlankDockController* _tmp0_;
	PlankDockRenderer* _tmp1_;
	PlankDockRenderer* _tmp2_;
	GdkPoint cursor = {0};
	GdkPoint _tmp3_ = {0};
	GdkPoint _tmp4_;
	gint offset = 0;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GdkPoint _tmp9_;
	GdkPoint _tmp10_;
	PlankDockItem* _tmp11_;
	PlankDockItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_renderer (_tmp0_);
	_tmp2_ = _tmp1_;
	renderer = _tmp2_;
	plank_dock_renderer_get_local_cursor (renderer, &_tmp3_);
	_tmp4_ = _tmp3_;
	cursor = _tmp4_;
	_tmp5_ = plank_dock_renderer_get_zoom_in_progress (renderer);
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->_ZoomIconSize;
	_tmp8_ = self->priv->_ItemPadding;
	offset = (gint) (((_tmp6_ * _tmp7_) + _tmp8_) / 2.0);
	_tmp9_ = cursor;
	_tmp10_ = cursor;
	_tmp11_ = plank_position_manager_get_nearest_item_at (self, _tmp9_.x + offset, _tmp10_.y + offset, container);
	result = _tmp11_;
	return result;
}

/**
 * Get's the x and y position to display a menu for a dock item.
 *
 * @param hovered the item that is hovered
 * @param requisition the menu's requisition
 * @param x the resulting x position
 * @param y the resulting y position
 */
void
plank_position_manager_get_menu_position (PlankPositionManager* self,
                                          PlankDockItem* hovered,
                                          GtkRequisition* requisition,
                                          gint* x,
                                          gint* y)
{
	gint _vala_x = 0;
	gint _vala_y = 0;
	GdkRectangle rect = {0};
	GdkRectangle _tmp0_ = {0};
	gint offset = 0;
	GtkPositionType _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (hovered != NULL);
	g_return_if_fail (requisition != NULL);
	plank_position_manager_get_hover_region_for_element (self, (PlankDockElement*) hovered, &_tmp0_);
	rect = _tmp0_;
	offset = 10;
	_tmp1_ = self->priv->_Position;
	switch (_tmp1_) {
		default:
		case GTK_POS_BOTTOM:
		{
			GdkRectangle _tmp2_;
			GdkRectangle _tmp3_;
			GtkRequisition _tmp4_;
			GdkRectangle _tmp5_;
			GtkRequisition _tmp6_;
			_tmp2_ = rect;
			_tmp3_ = rect;
			_tmp4_ = *requisition;
			_vala_x = (self->priv->win_x + _tmp2_.x) + ((_tmp3_.width - _tmp4_.width) / 2);
			_tmp5_ = rect;
			_tmp6_ = *requisition;
			_vala_y = ((self->priv->win_y + _tmp5_.y) - _tmp6_.height) - offset;
			break;
		}
		case GTK_POS_TOP:
		{
			GdkRectangle _tmp7_;
			GdkRectangle _tmp8_;
			GtkRequisition _tmp9_;
			GdkRectangle _tmp10_;
			_tmp7_ = rect;
			_tmp8_ = rect;
			_tmp9_ = *requisition;
			_vala_x = (self->priv->win_x + _tmp7_.x) + ((_tmp8_.width - _tmp9_.width) / 2);
			_tmp10_ = rect;
			_vala_y = (self->priv->win_y + _tmp10_.height) + offset;
			break;
		}
		case GTK_POS_LEFT:
		{
			GdkRectangle _tmp11_;
			GdkRectangle _tmp12_;
			GtkRequisition _tmp13_;
			GdkRectangle _tmp14_;
			GdkRectangle _tmp15_;
			_tmp11_ = rect;
			_tmp12_ = rect;
			_tmp13_ = *requisition;
			_vala_y = (self->priv->win_y + _tmp11_.y) + ((_tmp12_.height - _tmp13_.height) / 2);
			_tmp14_ = rect;
			_tmp15_ = rect;
			_vala_x = ((self->priv->win_x + _tmp14_.x) + _tmp15_.width) + offset;
			break;
		}
		case GTK_POS_RIGHT:
		{
			GdkRectangle _tmp16_;
			GdkRectangle _tmp17_;
			GtkRequisition _tmp18_;
			GdkRectangle _tmp19_;
			GtkRequisition _tmp20_;
			_tmp16_ = rect;
			_tmp17_ = rect;
			_tmp18_ = *requisition;
			_vala_y = (self->priv->win_y + _tmp16_.y) + ((_tmp17_.height - _tmp18_.height) / 2);
			_tmp19_ = rect;
			_tmp20_ = *requisition;
			_vala_x = ((self->priv->win_x + _tmp19_.x) - _tmp20_.width) - offset;
			break;
		}
	}
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
}

/**
 * Get's the x and y position to display a hover window for a dock item.
 *
 * @param hovered the item that is hovered
 * @param x the resulting x position
 * @param y the resulting y position
 */
void
plank_position_manager_get_hover_position (PlankPositionManager* self,
                                           PlankDockItem* hovered,
                                           gint* x,
                                           gint* y)
{
	gint _vala_x = 0;
	gint _vala_y = 0;
	PlankPointD center = {0};
	PlankDockItemDrawValue* _tmp0_;
	PlankDockItemDrawValue* _tmp1_;
	PlankPointD _tmp2_;
	PlankPointD _tmp3_;
	gdouble offset = 0.0;
	gint _tmp4_;
	gint _tmp5_;
	GtkPositionType _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (hovered != NULL);
	_tmp0_ = plank_position_manager_get_draw_value_for_item (self, hovered);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->static_center;
	_tmp3_ = _tmp2_;
	_plank_dock_item_draw_value_unref0 (_tmp1_);
	center = _tmp3_;
	_tmp4_ = self->priv->_ZoomIconSize;
	_tmp5_ = self->priv->_IconSize;
	offset = _tmp4_ - (_tmp5_ / 2.0);
	_tmp6_ = self->priv->_Position;
	switch (_tmp6_) {
		default:
		case GTK_POS_BOTTOM:
		{
			PlankPointD _tmp7_;
			PlankPointD _tmp8_;
			_tmp7_ = center;
			_vala_x = (gint) round (_tmp7_.x + self->priv->win_x);
			_tmp8_ = center;
			_vala_y = (gint) round ((_tmp8_.y + self->priv->win_y) - offset);
			break;
		}
		case GTK_POS_TOP:
		{
			PlankPointD _tmp9_;
			PlankPointD _tmp10_;
			_tmp9_ = center;
			_vala_x = (gint) round (_tmp9_.x + self->priv->win_x);
			_tmp10_ = center;
			_vala_y = (gint) round ((_tmp10_.y + self->priv->win_y) + offset);
			break;
		}
		case GTK_POS_LEFT:
		{
			PlankPointD _tmp11_;
			PlankPointD _tmp12_;
			_tmp11_ = center;
			_vala_x = (gint) round ((_tmp11_.x + self->priv->win_x) + offset);
			_tmp12_ = center;
			_vala_y = (gint) round (_tmp12_.y + self->priv->win_y);
			break;
		}
		case GTK_POS_RIGHT:
		{
			PlankPointD _tmp13_;
			PlankPointD _tmp14_;
			_tmp13_ = center;
			_vala_x = (gint) round ((_tmp13_.x + self->priv->win_x) - offset);
			_tmp14_ = center;
			_vala_y = (gint) round (_tmp14_.y + self->priv->win_y);
			break;
		}
	}
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
}

/**
 * Get's the x and y position to display a hover window for the given coordinates.
 *
 * @param x the resulting x position
 * @param y the resulting y position
 */
void
plank_position_manager_get_hover_position_at (PlankPositionManager* self,
                                              gint* x,
                                              gint* y)
{
	PlankPointD center = {0};
	PlankDockController* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	gpointer _tmp3_;
	PlankDockItemDrawValue* _tmp4_;
	PlankDockItemDrawValue* _tmp5_;
	PlankPointD _tmp6_;
	PlankPointD _tmp7_;
	gdouble offset = 0.0;
	gint _tmp8_;
	gint _tmp9_;
	GtkPositionType _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_VisibleItems (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_list_first ((GeeList*) _tmp2_);
	_tmp4_ = plank_position_manager_get_draw_value_for_item (self, (PlankDockItem*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_->static_center;
	_tmp7_ = _tmp6_;
	_plank_dock_item_draw_value_unref0 (_tmp5_);
	center = _tmp7_;
	_tmp8_ = self->priv->_ZoomIconSize;
	_tmp9_ = self->priv->_IconSize;
	offset = _tmp8_ - (_tmp9_ / 2.0);
	_tmp10_ = self->priv->_Position;
	switch (_tmp10_) {
		default:
		case GTK_POS_BOTTOM:
		{
			PlankPointD _tmp11_;
			_tmp11_ = center;
			*y = (gint) round ((_tmp11_.y + self->priv->win_y) - offset);
			break;
		}
		case GTK_POS_TOP:
		{
			PlankPointD _tmp12_;
			_tmp12_ = center;
			*y = (gint) round ((_tmp12_.y + self->priv->win_y) + offset);
			break;
		}
		case GTK_POS_LEFT:
		{
			PlankPointD _tmp13_;
			_tmp13_ = center;
			*x = (gint) round ((_tmp13_.x + self->priv->win_x) + offset);
			break;
		}
		case GTK_POS_RIGHT:
		{
			PlankPointD _tmp14_;
			_tmp14_ = center;
			*x = (gint) round ((_tmp14_.x + self->priv->win_x) - offset);
			break;
		}
	}
}

/**
 * Get's the x and y position to display the urgent-glow for a dock item.
 *
 * @param item the item to show urgent-glow for
 * @param x the resulting x position
 * @param y the resulting y position
 */
void
plank_position_manager_get_urgent_glow_position (PlankPositionManager* self,
                                                 PlankDockItem* item,
                                                 gint* x,
                                                 gint* y)
{
	gint _vala_x = 0;
	gint _vala_y = 0;
	GdkRectangle rect = {0};
	GdkRectangle _tmp0_ = {0};
	gint glow_size = 0;
	gint _tmp1_;
	GtkPositionType _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	plank_position_manager_get_hover_region_for_element (self, (PlankDockElement*) item, &_tmp0_);
	rect = _tmp0_;
	_tmp1_ = self->priv->_GlowSize;
	glow_size = _tmp1_;
	_tmp2_ = self->priv->_Position;
	switch (_tmp2_) {
		default:
		case GTK_POS_BOTTOM:
		{
			GdkRectangle _tmp3_;
			GdkRectangle _tmp4_;
			_tmp3_ = rect;
			_tmp4_ = rect;
			_vala_x = _tmp3_.x + ((_tmp4_.width - glow_size) / 2);
			_vala_y = self->priv->DockHeight - (glow_size / 2);
			break;
		}
		case GTK_POS_TOP:
		{
			GdkRectangle _tmp5_;
			GdkRectangle _tmp6_;
			_tmp5_ = rect;
			_tmp6_ = rect;
			_vala_x = _tmp5_.x + ((_tmp6_.width - glow_size) / 2);
			_vala_y = (-glow_size) / 2;
			break;
		}
		case GTK_POS_LEFT:
		{
			GdkRectangle _tmp7_;
			GdkRectangle _tmp8_;
			_tmp7_ = rect;
			_tmp8_ = rect;
			_vala_y = _tmp7_.y + ((_tmp8_.height - glow_size) / 2);
			_vala_x = (-glow_size) / 2;
			break;
		}
		case GTK_POS_RIGHT:
		{
			GdkRectangle _tmp9_;
			GdkRectangle _tmp10_;
			_tmp9_ = rect;
			_tmp10_ = rect;
			_vala_y = _tmp9_.y + ((_tmp10_.height - glow_size) / 2);
			_vala_x = self->priv->DockWidth - (glow_size / 2);
			break;
		}
	}
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
}

/**
 * Caches the x and y position of the dock window.
 */
void
plank_position_manager_update_dock_position (PlankPositionManager* self)
{
	gint xoffset = 0;
	gint yoffset = 0;
	gboolean _tmp0_;
	GtkPositionType _tmp13_;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_;
	g_return_if_fail (self != NULL);
	xoffset = 0;
	yoffset = 0;
	_tmp0_ = self->priv->_screen_is_composited;
	if (!_tmp0_) {
		gint offset = 0;
		gint _tmp1_;
		GdkRectangle _tmp2_;
		GdkRectangle _tmp3_;
		GtkAlign _tmp4_;
		_tmp1_ = self->priv->_Offset;
		offset = _tmp1_;
		_tmp2_ = self->priv->monitor_geo;
		xoffset = (gint) (((1 + (offset / 100.0)) * (_tmp2_.width - self->priv->DockWidth)) / 2);
		_tmp3_ = self->priv->monitor_geo;
		yoffset = (gint) (((1 + (offset / 100.0)) * (_tmp3_.height - self->priv->DockHeight)) / 2);
		_tmp4_ = self->priv->_Alignment;
		switch (_tmp4_) {
			default:
			case GTK_ALIGN_CENTER:
			case GTK_ALIGN_FILL:
			{
				break;
			}
			case GTK_ALIGN_START:
			{
				if (plank_position_manager_is_horizontal_dock (self)) {
					GdkRectangle _tmp5_;
					GdkRectangle _tmp6_;
					xoffset = 0;
					_tmp5_ = self->priv->monitor_geo;
					_tmp6_ = self->priv->static_dock_region;
					yoffset = _tmp5_.height - _tmp6_.height;
				} else {
					GdkRectangle _tmp7_;
					GdkRectangle _tmp8_;
					_tmp7_ = self->priv->monitor_geo;
					_tmp8_ = self->priv->static_dock_region;
					xoffset = _tmp7_.width - _tmp8_.width;
					yoffset = 0;
				}
				break;
			}
			case GTK_ALIGN_END:
			{
				if (plank_position_manager_is_horizontal_dock (self)) {
					GdkRectangle _tmp9_;
					GdkRectangle _tmp10_;
					_tmp9_ = self->priv->monitor_geo;
					_tmp10_ = self->priv->static_dock_region;
					xoffset = _tmp9_.width - _tmp10_.width;
					yoffset = 0;
				} else {
					GdkRectangle _tmp11_;
					GdkRectangle _tmp12_;
					xoffset = 0;
					_tmp11_ = self->priv->monitor_geo;
					_tmp12_ = self->priv->static_dock_region;
					yoffset = _tmp11_.height - _tmp12_.height;
				}
				break;
			}
		}
	}
	_tmp13_ = self->priv->_Position;
	switch (_tmp13_) {
		default:
		case GTK_POS_BOTTOM:
		{
			GdkRectangle _tmp14_;
			GdkRectangle _tmp15_;
			GdkRectangle _tmp16_;
			_tmp14_ = self->priv->monitor_geo;
			self->priv->win_x = _tmp14_.x + xoffset;
			_tmp15_ = self->priv->monitor_geo;
			_tmp16_ = self->priv->monitor_geo;
			self->priv->win_y = (_tmp15_.y + _tmp16_.height) - self->priv->DockHeight;
			break;
		}
		case GTK_POS_TOP:
		{
			GdkRectangle _tmp17_;
			GdkRectangle _tmp18_;
			_tmp17_ = self->priv->monitor_geo;
			self->priv->win_x = _tmp17_.x + xoffset;
			_tmp18_ = self->priv->monitor_geo;
			self->priv->win_y = _tmp18_.y;
			break;
		}
		case GTK_POS_LEFT:
		{
			GdkRectangle _tmp19_;
			GdkRectangle _tmp20_;
			_tmp19_ = self->priv->monitor_geo;
			self->priv->win_y = _tmp19_.y + yoffset;
			_tmp20_ = self->priv->monitor_geo;
			self->priv->win_x = _tmp20_.x;
			break;
		}
		case GTK_POS_RIGHT:
		{
			GdkRectangle _tmp21_;
			GdkRectangle _tmp22_;
			GdkRectangle _tmp23_;
			_tmp21_ = self->priv->monitor_geo;
			self->priv->win_y = _tmp21_.y + yoffset;
			_tmp22_ = self->priv->monitor_geo;
			_tmp23_ = self->priv->monitor_geo;
			self->priv->win_x = (_tmp22_.x + _tmp23_.width) - self->priv->DockWidth;
			break;
		}
	}
	_tmp25_ = self->priv->_screen_is_composited;
	if (!_tmp25_) {
		PlankDockController* _tmp26_;
		PlankHideManager* _tmp27_;
		PlankHideManager* _tmp28_;
		gboolean _tmp29_;
		gboolean _tmp30_;
		_tmp26_ = self->priv->_controller;
		_tmp27_ = plank_dock_controller_get_hide_manager (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = plank_hide_manager_get_Hidden (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp24_ = _tmp30_;
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		GtkPositionType _tmp31_;
		_tmp31_ = self->priv->_Position;
		switch (_tmp31_) {
			default:
			case GTK_POS_BOTTOM:
			{
				self->priv->win_y = self->priv->win_y + (self->priv->DockHeight - 1);
				break;
			}
			case GTK_POS_TOP:
			{
				self->priv->win_y = self->priv->win_y - (self->priv->DockHeight - 1);
				break;
			}
			case GTK_POS_LEFT:
			{
				self->priv->win_x = self->priv->win_x - (self->priv->DockWidth - 1);
				break;
			}
			case GTK_POS_RIGHT:
			{
				self->priv->win_x = self->priv->win_x + (self->priv->DockWidth - 1);
				break;
			}
		}
	}
}

/**
 * Get's the x and y position to display the main dock buffer.
 *
 * @param x the resulting x position
 * @param y the resulting y position
 */
void
plank_position_manager_get_dock_draw_position (PlankPositionManager* self,
                                               gint* x,
                                               gint* y)
{
	gint _vala_x = 0;
	gint _vala_y = 0;
	gboolean _tmp0_;
	gdouble progress = 0.0;
	PlankDockController* _tmp1_;
	PlankDockRenderer* _tmp2_;
	PlankDockRenderer* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	GtkPositionType _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_screen_is_composited;
	if (!_tmp0_) {
		_vala_x = 0;
		_vala_y = 0;
		if (x) {
			*x = _vala_x;
		}
		if (y) {
			*y = _vala_y;
		}
		return;
	}
	_tmp1_ = self->priv->_controller;
	_tmp2_ = plank_dock_controller_get_renderer (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = plank_dock_renderer_get_hide_progress (_tmp3_);
	_tmp5_ = _tmp4_;
	progress = _tmp5_;
	_tmp6_ = self->priv->_Position;
	switch (_tmp6_) {
		default:
		case GTK_POS_BOTTOM:
		{
			_vala_x = 0;
			_vala_y = (gint) ((self->priv->VisibleDockHeight + self->priv->extra_hide_offset) * progress);
			break;
		}
		case GTK_POS_TOP:
		{
			_vala_x = 0;
			_vala_y = (gint) ((-(self->priv->VisibleDockHeight + self->priv->extra_hide_offset)) * progress);
			break;
		}
		case GTK_POS_LEFT:
		{
			_vala_x = (gint) ((-(self->priv->VisibleDockWidth + self->priv->extra_hide_offset)) * progress);
			_vala_y = 0;
			break;
		}
		case GTK_POS_RIGHT:
		{
			_vala_x = (gint) ((self->priv->VisibleDockWidth + self->priv->extra_hide_offset) * progress);
			_vala_y = 0;
			break;
		}
	}
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
}

/**
 * Get's the region to display the dock window at.
 *
 * @return the region for the dock window
 */
void
plank_position_manager_get_dock_window_region (PlankPositionManager* self,
                                               GdkRectangle* result)
{
	GdkRectangle _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_.x = self->priv->win_x;
	_tmp0_.y = self->priv->win_y;
	_tmp0_.width = self->priv->DockWidth;
	_tmp0_.height = self->priv->DockHeight;
	*result = _tmp0_;
	return;
}

/**
 * Get's the padding between background and icons of the dock.
 *
 * @param x the horizontal padding
 * @param y the vertical padding
 */
void
plank_position_manager_get_background_padding (PlankPositionManager* self,
                                               gint* x,
                                               gint* y)
{
	gint _vala_x = 0;
	gint _vala_y = 0;
	GtkPositionType _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_Position;
	switch (_tmp0_) {
		default:
		case GTK_POS_BOTTOM:
		{
			_vala_x = 0;
			_vala_y = (self->priv->VisibleDockHeight - self->priv->DockBackgroundHeight) + self->priv->extra_hide_offset;
			break;
		}
		case GTK_POS_TOP:
		{
			_vala_x = 0;
			_vala_y = -((self->priv->VisibleDockHeight - self->priv->DockBackgroundHeight) + self->priv->extra_hide_offset);
			break;
		}
		case GTK_POS_LEFT:
		{
			_vala_x = -((self->priv->VisibleDockWidth - self->priv->DockBackgroundWidth) + self->priv->extra_hide_offset);
			_vala_y = 0;
			break;
		}
		case GTK_POS_RIGHT:
		{
			_vala_x = (self->priv->VisibleDockWidth - self->priv->DockBackgroundWidth) + self->priv->extra_hide_offset;
			_vala_y = 0;
			break;
		}
	}
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
}

/**
 * Get's the region for background of the dock.
 *
 * @return the region for the dock background
 */
void
plank_position_manager_get_background_region (PlankPositionManager* self,
                                              GdkRectangle* result)
{
	GdkRectangle _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->background_rect;
	*result = _tmp0_;
	return;
}

static void
plank_position_manager_update_background_region (PlankPositionManager* self,
                                                 PlankDockItemDrawValue* val_first,
                                                 PlankDockItemDrawValue* val_last)
{
	gint x = 0;
	gint y = 0;
	gint width = 0;
	gint height = 0;
	gboolean _tmp0_;
	GtkAlign _tmp3_;
	PlankPointD center_first = {0};
	PlankPointD _tmp6_;
	PlankPointD center_last = {0};
	PlankPointD _tmp7_;
	gint padding = 0;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gdouble padding_first = 0.0;
	gdouble padding_last = 0.0;
	GtkPositionType _tmp11_;
	GdkRectangle _tmp24_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (val_first != NULL);
	g_return_if_fail (val_last != NULL);
	x = 0;
	y = 0;
	width = 0;
	height = 0;
	_tmp0_ = self->priv->_screen_is_composited;
	if (_tmp0_) {
		GdkRectangle _tmp1_;
		GdkRectangle _tmp2_;
		_tmp1_ = self->priv->static_dock_region;
		x = _tmp1_.x;
		_tmp2_ = self->priv->static_dock_region;
		y = _tmp2_.y;
		width = self->priv->VisibleDockWidth;
		height = self->priv->VisibleDockHeight;
	} else {
		width = self->priv->DockWidth;
		height = self->priv->DockHeight;
	}
	_tmp3_ = self->priv->_Alignment;
	if (_tmp3_ == GTK_ALIGN_FILL) {
		GtkPositionType _tmp4_;
		GdkRectangle _tmp5_ = {0};
		_tmp4_ = self->priv->_Position;
		switch (_tmp4_) {
			default:
			case GTK_POS_BOTTOM:
			{
				x += (width - self->priv->DockBackgroundWidth) / 2;
				y += height - self->priv->DockBackgroundHeight;
				break;
			}
			case GTK_POS_TOP:
			{
				x += (width - self->priv->DockBackgroundWidth) / 2;
				y = 0;
				break;
			}
			case GTK_POS_LEFT:
			{
				x = 0;
				y += (height - self->priv->DockBackgroundHeight) / 2;
				break;
			}
			case GTK_POS_RIGHT:
			{
				x += width - self->priv->DockBackgroundWidth;
				y += (height - self->priv->DockBackgroundHeight) / 2;
				break;
			}
		}
		_tmp5_.x = x;
		_tmp5_.y = y;
		_tmp5_.width = self->priv->DockBackgroundWidth;
		_tmp5_.height = self->priv->DockBackgroundHeight;
		self->priv->background_rect = _tmp5_;
		return;
	}
	_tmp6_ = val_first->center;
	center_first = _tmp6_;
	_tmp7_ = val_last->center;
	center_last = _tmp7_;
	_tmp8_ = self->priv->_ItemPadding;
	_tmp9_ = self->priv->_HorizPadding;
	_tmp10_ = self->priv->_LineWidth;
	padding = (_tmp8_ + (2 * _tmp9_)) + (4 * _tmp10_);
	padding_first = (val_first->icon_size + padding) / 2.0;
	padding_last = (val_last->icon_size + padding) / 2.0;
	_tmp11_ = self->priv->_Position;
	switch (_tmp11_) {
		default:
		case GTK_POS_BOTTOM:
		{
			PlankPointD _tmp12_;
			PlankPointD _tmp13_;
			PlankPointD _tmp14_;
			_tmp12_ = center_first;
			x = (gint) round (_tmp12_.x - padding_first);
			y += height - self->priv->DockBackgroundHeight;
			_tmp13_ = center_last;
			_tmp14_ = center_first;
			width = (gint) round (((_tmp13_.x - _tmp14_.x) + padding_first) + padding_last);
			height = self->priv->DockBackgroundHeight;
			break;
		}
		case GTK_POS_TOP:
		{
			PlankPointD _tmp15_;
			PlankPointD _tmp16_;
			PlankPointD _tmp17_;
			_tmp15_ = center_first;
			x = (gint) round (_tmp15_.x - padding_first);
			y = 0;
			_tmp16_ = center_last;
			_tmp17_ = center_first;
			width = (gint) round (((_tmp16_.x - _tmp17_.x) + padding_first) + padding_last);
			height = self->priv->DockBackgroundHeight;
			break;
		}
		case GTK_POS_LEFT:
		{
			PlankPointD _tmp18_;
			PlankPointD _tmp19_;
			PlankPointD _tmp20_;
			x = 0;
			_tmp18_ = center_first;
			y = (gint) round (_tmp18_.y - padding_first);
			width = self->priv->DockBackgroundWidth;
			_tmp19_ = center_last;
			_tmp20_ = center_first;
			height = (gint) round (((_tmp19_.y - _tmp20_.y) + padding_first) + padding_last);
			break;
		}
		case GTK_POS_RIGHT:
		{
			PlankPointD _tmp21_;
			PlankPointD _tmp22_;
			PlankPointD _tmp23_;
			x += width - self->priv->DockBackgroundWidth;
			_tmp21_ = center_first;
			y = (gint) round (_tmp21_.y - padding_first);
			width = self->priv->DockBackgroundWidth;
			_tmp22_ = center_last;
			_tmp23_ = center_first;
			height = (gint) round (((_tmp22_.y - _tmp23_.y) + padding_first) + padding_last);
			break;
		}
	}
	_tmp24_.x = x;
	_tmp24_.y = y;
	_tmp24_.width = width;
	_tmp24_.height = height;
	self->priv->background_rect = _tmp24_;
}

/**
 * Get the item's icon geometry for the dock.
 *
 * @param item an application-dockitem of the dock
 * @param for_hidden whether the geometry should apply for a hidden dock
 * @return icon geometry for the given application-dockitem
 */
void
plank_position_manager_get_icon_geometry (PlankPositionManager* self,
                                          PlankApplicationDockItem* item,
                                          gboolean for_hidden,
                                          GdkRectangle* result)
{
	GdkRectangle region = {0};
	GdkRectangle _tmp0_ = {0};
	gint x = 0;
	gint y = 0;
	GtkPositionType _tmp1_;
	GdkRectangle _tmp10_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	plank_position_manager_get_hover_region_for_element (self, (PlankDockElement*) item, &_tmp0_);
	region = _tmp0_;
	if (!for_hidden) {
		region.x = region.x + self->priv->win_x;
		region.y = region.y + self->priv->win_y;
		*result = region;
		return;
	}
	x = self->priv->win_x;
	y = self->priv->win_y;
	_tmp1_ = self->priv->_Position;
	switch (_tmp1_) {
		default:
		case GTK_POS_BOTTOM:
		{
			GdkRectangle _tmp2_;
			GdkRectangle _tmp3_;
			_tmp2_ = region;
			_tmp3_ = region;
			x += _tmp2_.x + (_tmp3_.width / 2);
			y += self->priv->DockHeight;
			break;
		}
		case GTK_POS_TOP:
		{
			GdkRectangle _tmp4_;
			GdkRectangle _tmp5_;
			_tmp4_ = region;
			_tmp5_ = region;
			x += _tmp4_.x + (_tmp5_.width / 2);
			y += 0;
			break;
		}
		case GTK_POS_LEFT:
		{
			GdkRectangle _tmp6_;
			GdkRectangle _tmp7_;
			x += 0;
			_tmp6_ = region;
			_tmp7_ = region;
			y += _tmp6_.y + (_tmp7_.height / 2);
			break;
		}
		case GTK_POS_RIGHT:
		{
			GdkRectangle _tmp8_;
			GdkRectangle _tmp9_;
			x += self->priv->DockWidth;
			_tmp8_ = region;
			_tmp9_ = region;
			y += _tmp8_.y + (_tmp9_.height / 2);
			break;
		}
	}
	_tmp10_.x = x;
	_tmp10_.y = y;
	_tmp10_.width = 0;
	_tmp10_.height = 0;
	*result = _tmp10_;
	return;
}

/**
 * Computes the struts for the dock.
 *
 * @param struts the array to contain the struts
 */
void
plank_position_manager_get_struts (PlankPositionManager* self,
                                   gulong** struts,
                                   gint* struts_length1)
{
	PlankDockController* _tmp0_;
	PlankDockWindow* _tmp1_;
	PlankDockWindow* _tmp2_;
	GdkWindow* _tmp3_;
	GtkPositionType _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_window (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_widget_get_window ((GtkWidget*) _tmp2_);
	self->priv->window_scale_factor = gdk_window_get_scale_factor (_tmp3_);
	_tmp4_ = self->priv->_Position;
	switch (_tmp4_) {
		default:
		case GTK_POS_BOTTOM:
		{
			PlankDockController* _tmp5_;
			PlankDockWindow* _tmp6_;
			PlankDockWindow* _tmp7_;
			GdkScreen* _tmp8_;
			GdkRectangle _tmp9_;
			GdkRectangle _tmp10_;
			GdkRectangle _tmp11_;
			GdkRectangle _tmp12_;
			GdkRectangle _tmp13_;
			_tmp5_ = self->priv->_controller;
			_tmp6_ = plank_dock_controller_get_window (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = gtk_window_get_screen ((GtkWindow*) _tmp7_);
			_tmp9_ = self->priv->monitor_geo;
			_tmp10_ = self->priv->monitor_geo;
			(*struts)[PLANK_STRUTS_BOTTOM] = (gulong) ((((self->priv->VisibleDockHeight + gdk_screen_get_height (_tmp8_)) - _tmp9_.y) - _tmp10_.height) * self->priv->window_scale_factor);
			_tmp11_ = self->priv->monitor_geo;
			(*struts)[PLANK_STRUTS_BOTTOM_START] = (gulong) (_tmp11_.x * self->priv->window_scale_factor);
			_tmp12_ = self->priv->monitor_geo;
			_tmp13_ = self->priv->monitor_geo;
			(*struts)[PLANK_STRUTS_BOTTOM_END] = (gulong) (((_tmp12_.x + _tmp13_.width) * self->priv->window_scale_factor) - 1);
			break;
		}
		case GTK_POS_TOP:
		{
			GdkRectangle _tmp14_;
			GdkRectangle _tmp15_;
			GdkRectangle _tmp16_;
			GdkRectangle _tmp17_;
			_tmp14_ = self->priv->monitor_geo;
			(*struts)[PLANK_STRUTS_TOP] = (gulong) ((_tmp14_.y + self->priv->VisibleDockHeight) * self->priv->window_scale_factor);
			_tmp15_ = self->priv->monitor_geo;
			(*struts)[PLANK_STRUTS_TOP_START] = (gulong) (_tmp15_.x * self->priv->window_scale_factor);
			_tmp16_ = self->priv->monitor_geo;
			_tmp17_ = self->priv->monitor_geo;
			(*struts)[PLANK_STRUTS_TOP_END] = (gulong) (((_tmp16_.x + _tmp17_.width) * self->priv->window_scale_factor) - 1);
			break;
		}
		case GTK_POS_LEFT:
		{
			GdkRectangle _tmp18_;
			GdkRectangle _tmp19_;
			GdkRectangle _tmp20_;
			GdkRectangle _tmp21_;
			_tmp18_ = self->priv->monitor_geo;
			(*struts)[PLANK_STRUTS_LEFT] = (gulong) ((_tmp18_.x + self->priv->VisibleDockWidth) * self->priv->window_scale_factor);
			_tmp19_ = self->priv->monitor_geo;
			(*struts)[PLANK_STRUTS_LEFT_START] = (gulong) (_tmp19_.y * self->priv->window_scale_factor);
			_tmp20_ = self->priv->monitor_geo;
			_tmp21_ = self->priv->monitor_geo;
			(*struts)[PLANK_STRUTS_LEFT_END] = (gulong) (((_tmp20_.y + _tmp21_.height) * self->priv->window_scale_factor) - 1);
			break;
		}
		case GTK_POS_RIGHT:
		{
			PlankDockController* _tmp22_;
			PlankDockWindow* _tmp23_;
			PlankDockWindow* _tmp24_;
			GdkScreen* _tmp25_;
			GdkRectangle _tmp26_;
			GdkRectangle _tmp27_;
			GdkRectangle _tmp28_;
			GdkRectangle _tmp29_;
			GdkRectangle _tmp30_;
			_tmp22_ = self->priv->_controller;
			_tmp23_ = plank_dock_controller_get_window (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = gtk_window_get_screen ((GtkWindow*) _tmp24_);
			_tmp26_ = self->priv->monitor_geo;
			_tmp27_ = self->priv->monitor_geo;
			(*struts)[PLANK_STRUTS_RIGHT] = (gulong) ((((self->priv->VisibleDockWidth + gdk_screen_get_width (_tmp25_)) - _tmp26_.x) - _tmp27_.width) * self->priv->window_scale_factor);
			_tmp28_ = self->priv->monitor_geo;
			(*struts)[PLANK_STRUTS_RIGHT_START] = (gulong) (_tmp28_.y * self->priv->window_scale_factor);
			_tmp29_ = self->priv->monitor_geo;
			_tmp30_ = self->priv->monitor_geo;
			(*struts)[PLANK_STRUTS_RIGHT_END] = (gulong) (((_tmp29_.y + _tmp30_.height) * self->priv->window_scale_factor) - 1);
			break;
		}
	}
}

void
plank_position_manager_get_barrier (PlankPositionManager* self,
                                    GdkRectangle* result)
{
	GdkRectangle barrier = {0};
	GdkRectangle _tmp0_ = {0};
	GtkPositionType _tmp1_;
	gboolean _tmp16_ = FALSE;
	GdkRectangle _tmp17_;
	g_return_if_fail (self != NULL);
	barrier = _tmp0_;
	_tmp1_ = self->priv->_Position;
	switch (_tmp1_) {
		default:
		case GTK_POS_BOTTOM:
		{
			GdkRectangle _tmp2_;
			GdkRectangle _tmp3_;
			GdkRectangle _tmp4_;
			GdkRectangle _tmp5_;
			_tmp2_ = self->priv->monitor_geo;
			_tmp3_ = self->priv->monitor_geo;
			barrier.x = _tmp2_.x + ((_tmp3_.width - self->priv->VisibleDockWidth) / 2);
			_tmp4_ = self->priv->monitor_geo;
			_tmp5_ = self->priv->monitor_geo;
			barrier.y = _tmp4_.y + _tmp5_.height;
			barrier.width = self->priv->VisibleDockWidth;
			barrier.height = 0;
			break;
		}
		case GTK_POS_TOP:
		{
			GdkRectangle _tmp6_;
			GdkRectangle _tmp7_;
			GdkRectangle _tmp8_;
			_tmp6_ = self->priv->monitor_geo;
			_tmp7_ = self->priv->monitor_geo;
			barrier.x = _tmp6_.x + ((_tmp7_.width - self->priv->VisibleDockWidth) / 2);
			_tmp8_ = self->priv->monitor_geo;
			barrier.y = _tmp8_.y;
			barrier.width = self->priv->VisibleDockWidth;
			barrier.height = 0;
			break;
		}
		case GTK_POS_LEFT:
		{
			GdkRectangle _tmp9_;
			GdkRectangle _tmp10_;
			GdkRectangle _tmp11_;
			_tmp9_ = self->priv->monitor_geo;
			barrier.x = _tmp9_.x;
			_tmp10_ = self->priv->monitor_geo;
			_tmp11_ = self->priv->monitor_geo;
			barrier.y = _tmp10_.y + ((_tmp11_.height - self->priv->VisibleDockHeight) / 2);
			barrier.width = 0;
			barrier.height = self->priv->VisibleDockHeight;
			break;
		}
		case GTK_POS_RIGHT:
		{
			GdkRectangle _tmp12_;
			GdkRectangle _tmp13_;
			GdkRectangle _tmp14_;
			GdkRectangle _tmp15_;
			_tmp12_ = self->priv->monitor_geo;
			_tmp13_ = self->priv->monitor_geo;
			barrier.x = _tmp12_.x + _tmp13_.width;
			_tmp14_ = self->priv->monitor_geo;
			_tmp15_ = self->priv->monitor_geo;
			barrier.y = _tmp14_.y + ((_tmp15_.height - self->priv->VisibleDockHeight) / 2);
			barrier.width = 0;
			barrier.height = self->priv->VisibleDockHeight;
			break;
		}
	}
	_tmp17_ = barrier;
	if (_tmp17_.width > 0) {
		_tmp16_ = TRUE;
	} else {
		GdkRectangle _tmp18_;
		_tmp18_ = barrier;
		_tmp16_ = _tmp18_.height > 0;
	}
	g_warn_if_fail (_tmp16_);
	*result = barrier;
	return;
}

static PlankDockController*
plank_position_manager_get_controller (PlankPositionManager* self)
{
	PlankDockController* result;
	PlankDockController* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_controller;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
plank_position_manager_set_controller (PlankPositionManager* self,
                                       PlankDockController* value)
{
	PlankDockController* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_position_manager_get_controller (self);
	if (old_value != value) {
		PlankDockController* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_controller);
		self->priv->_controller = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_position_manager_properties[PLANK_POSITION_MANAGER_CONTROLLER_PROPERTY]);
	}
}

gboolean
plank_position_manager_get_screen_is_composited (PlankPositionManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_screen_is_composited;
	return result;
}

static void
plank_position_manager_set_screen_is_composited (PlankPositionManager* self,
                                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_position_manager_get_screen_is_composited (self);
	if (old_value != value) {
		self->priv->_screen_is_composited = value;
		g_object_notify_by_pspec ((GObject *) self, plank_position_manager_properties[PLANK_POSITION_MANAGER_SCREEN_IS_COMPOSITED_PROPERTY]);
	}
}

gint
plank_position_manager_get_LineWidth (PlankPositionManager* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_LineWidth;
	return result;
}

static void
plank_position_manager_set_LineWidth (PlankPositionManager* self,
                                      gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_position_manager_get_LineWidth (self);
	if (old_value != value) {
		self->priv->_LineWidth = value;
		g_object_notify_by_pspec ((GObject *) self, plank_position_manager_properties[PLANK_POSITION_MANAGER_LINE_WIDTH_PROPERTY]);
	}
}

gint
plank_position_manager_get_IconSize (PlankPositionManager* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_IconSize;
	return result;
}

static void
plank_position_manager_set_IconSize (PlankPositionManager* self,
                                     gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_position_manager_get_IconSize (self);
	if (old_value != value) {
		self->priv->_IconSize = value;
		g_object_notify_by_pspec ((GObject *) self, plank_position_manager_properties[PLANK_POSITION_MANAGER_ICON_SIZE_PROPERTY]);
	}
}

gint
plank_position_manager_get_ZoomIconSize (PlankPositionManager* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_ZoomIconSize;
	return result;
}

static void
plank_position_manager_set_ZoomIconSize (PlankPositionManager* self,
                                         gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_position_manager_get_ZoomIconSize (self);
	if (old_value != value) {
		self->priv->_ZoomIconSize = value;
		g_object_notify_by_pspec ((GObject *) self, plank_position_manager_properties[PLANK_POSITION_MANAGER_ZOOM_ICON_SIZE_PROPERTY]);
	}
}

GtkPositionType
plank_position_manager_get_Position (PlankPositionManager* self)
{
	GtkPositionType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_Position;
	return result;
}

static void
plank_position_manager_set_Position (PlankPositionManager* self,
                                     GtkPositionType value)
{
	GtkPositionType old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_position_manager_get_Position (self);
	if (old_value != value) {
		self->priv->_Position = value;
		g_object_notify_by_pspec ((GObject *) self, plank_position_manager_properties[PLANK_POSITION_MANAGER_POSITION_PROPERTY]);
	}
}

GtkAlign
plank_position_manager_get_Alignment (PlankPositionManager* self)
{
	GtkAlign result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_Alignment;
	return result;
}

static void
plank_position_manager_set_Alignment (PlankPositionManager* self,
                                      GtkAlign value)
{
	GtkAlign old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_position_manager_get_Alignment (self);
	if (old_value != value) {
		self->priv->_Alignment = value;
		g_object_notify_by_pspec ((GObject *) self, plank_position_manager_properties[PLANK_POSITION_MANAGER_ALIGNMENT_PROPERTY]);
	}
}

GtkAlign
plank_position_manager_get_ItemsAlignment (PlankPositionManager* self)
{
	GtkAlign result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_ItemsAlignment;
	return result;
}

static void
plank_position_manager_set_ItemsAlignment (PlankPositionManager* self,
                                           GtkAlign value)
{
	GtkAlign old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_position_manager_get_ItemsAlignment (self);
	if (old_value != value) {
		self->priv->_ItemsAlignment = value;
		g_object_notify_by_pspec ((GObject *) self, plank_position_manager_properties[PLANK_POSITION_MANAGER_ITEMS_ALIGNMENT_PROPERTY]);
	}
}

gint
plank_position_manager_get_Offset (PlankPositionManager* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_Offset;
	return result;
}

static void
plank_position_manager_set_Offset (PlankPositionManager* self,
                                   gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_position_manager_get_Offset (self);
	if (old_value != value) {
		self->priv->_Offset = value;
		g_object_notify_by_pspec ((GObject *) self, plank_position_manager_properties[PLANK_POSITION_MANAGER_OFFSET_PROPERTY]);
	}
}

gint
plank_position_manager_get_IndicatorSize (PlankPositionManager* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_IndicatorSize;
	return result;
}

static void
plank_position_manager_set_IndicatorSize (PlankPositionManager* self,
                                          gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_position_manager_get_IndicatorSize (self);
	if (old_value != value) {
		self->priv->_IndicatorSize = value;
		g_object_notify_by_pspec ((GObject *) self, plank_position_manager_properties[PLANK_POSITION_MANAGER_INDICATOR_SIZE_PROPERTY]);
	}
}

gint
plank_position_manager_get_IconShadowSize (PlankPositionManager* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_IconShadowSize;
	return result;
}

static void
plank_position_manager_set_IconShadowSize (PlankPositionManager* self,
                                           gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_position_manager_get_IconShadowSize (self);
	if (old_value != value) {
		self->priv->_IconShadowSize = value;
		g_object_notify_by_pspec ((GObject *) self, plank_position_manager_properties[PLANK_POSITION_MANAGER_ICON_SHADOW_SIZE_PROPERTY]);
	}
}

gint
plank_position_manager_get_GlowSize (PlankPositionManager* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_GlowSize;
	return result;
}

static void
plank_position_manager_set_GlowSize (PlankPositionManager* self,
                                     gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_position_manager_get_GlowSize (self);
	if (old_value != value) {
		self->priv->_GlowSize = value;
		g_object_notify_by_pspec ((GObject *) self, plank_position_manager_properties[PLANK_POSITION_MANAGER_GLOW_SIZE_PROPERTY]);
	}
}

gint
plank_position_manager_get_HorizPadding (PlankPositionManager* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_HorizPadding;
	return result;
}

static void
plank_position_manager_set_HorizPadding (PlankPositionManager* self,
                                         gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_position_manager_get_HorizPadding (self);
	if (old_value != value) {
		self->priv->_HorizPadding = value;
		g_object_notify_by_pspec ((GObject *) self, plank_position_manager_properties[PLANK_POSITION_MANAGER_HORIZ_PADDING_PROPERTY]);
	}
}

gint
plank_position_manager_get_TopPadding (PlankPositionManager* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_TopPadding;
	return result;
}

static void
plank_position_manager_set_TopPadding (PlankPositionManager* self,
                                       gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_position_manager_get_TopPadding (self);
	if (old_value != value) {
		self->priv->_TopPadding = value;
		g_object_notify_by_pspec ((GObject *) self, plank_position_manager_properties[PLANK_POSITION_MANAGER_TOP_PADDING_PROPERTY]);
	}
}

gint
plank_position_manager_get_BottomPadding (PlankPositionManager* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_BottomPadding;
	return result;
}

static void
plank_position_manager_set_BottomPadding (PlankPositionManager* self,
                                          gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_position_manager_get_BottomPadding (self);
	if (old_value != value) {
		self->priv->_BottomPadding = value;
		g_object_notify_by_pspec ((GObject *) self, plank_position_manager_properties[PLANK_POSITION_MANAGER_BOTTOM_PADDING_PROPERTY]);
	}
}

gint
plank_position_manager_get_ItemPadding (PlankPositionManager* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_ItemPadding;
	return result;
}

static void
plank_position_manager_set_ItemPadding (PlankPositionManager* self,
                                        gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_position_manager_get_ItemPadding (self);
	if (old_value != value) {
		self->priv->_ItemPadding = value;
		g_object_notify_by_pspec ((GObject *) self, plank_position_manager_properties[PLANK_POSITION_MANAGER_ITEM_PADDING_PROPERTY]);
	}
}

gint
plank_position_manager_get_UrgentBounceHeight (PlankPositionManager* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_UrgentBounceHeight;
	return result;
}

static void
plank_position_manager_set_UrgentBounceHeight (PlankPositionManager* self,
                                               gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_position_manager_get_UrgentBounceHeight (self);
	if (old_value != value) {
		self->priv->_UrgentBounceHeight = value;
		g_object_notify_by_pspec ((GObject *) self, plank_position_manager_properties[PLANK_POSITION_MANAGER_URGENT_BOUNCE_HEIGHT_PROPERTY]);
	}
}

gint
plank_position_manager_get_LaunchBounceHeight (PlankPositionManager* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_LaunchBounceHeight;
	return result;
}

static void
plank_position_manager_set_LaunchBounceHeight (PlankPositionManager* self,
                                               gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_position_manager_get_LaunchBounceHeight (self);
	if (old_value != value) {
		self->priv->_LaunchBounceHeight = value;
		g_object_notify_by_pspec ((GObject *) self, plank_position_manager_properties[PLANK_POSITION_MANAGER_LAUNCH_BOUNCE_HEIGHT_PROPERTY]);
	}
}

gint
plank_position_manager_get_MaxItemCount (PlankPositionManager* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_MaxItemCount;
	return result;
}

static void
plank_position_manager_set_MaxItemCount (PlankPositionManager* self,
                                         gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_position_manager_get_MaxItemCount (self);
	if (old_value != value) {
		self->priv->_MaxItemCount = value;
		g_object_notify_by_pspec ((GObject *) self, plank_position_manager_properties[PLANK_POSITION_MANAGER_MAX_ITEM_COUNT_PROPERTY]);
	}
}

static gint
plank_position_manager_get_MaxIconSize (PlankPositionManager* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_MaxIconSize;
	return result;
}

static void
plank_position_manager_set_MaxIconSize (PlankPositionManager* self,
                                        gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_MaxIconSize = value;
}

static GObject *
plank_position_manager_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PlankPositionManager * self;
	GdkRectangle _tmp0_ = {0};
	GeeHashMap* _tmp1_;
	parent_class = G_OBJECT_CLASS (plank_position_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_POSITION_MANAGER, PlankPositionManager);
	self->priv->static_dock_region = _tmp0_;
	_tmp1_ = gee_hash_map_new (PLANK_TYPE_DOCK_ELEMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, PLANK_TYPE_DOCK_ITEM_DRAW_VALUE, (GBoxedCopyFunc) plank_dock_item_draw_value_ref, (GDestroyNotify) plank_dock_item_draw_value_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->draw_values);
	self->priv->draw_values = _tmp1_;
	return obj;
}

static void
plank_position_manager_class_init (PlankPositionManagerClass * klass,
                                   gpointer klass_data)
{
	plank_position_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankPositionManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_plank_position_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_plank_position_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = plank_position_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = plank_position_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_POSITION_MANAGER_CONTROLLER_PROPERTY, plank_position_manager_properties[PLANK_POSITION_MANAGER_CONTROLLER_PROPERTY] = g_param_spec_object ("controller", "controller", "controller", PLANK_TYPE_DOCK_CONTROLLER, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_POSITION_MANAGER_SCREEN_IS_COMPOSITED_PROPERTY, plank_position_manager_properties[PLANK_POSITION_MANAGER_SCREEN_IS_COMPOSITED_PROPERTY] = g_param_spec_boolean ("screen-is-composited", "screen-is-composited", "screen-is-composited", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Theme-based line-width.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_POSITION_MANAGER_LINE_WIDTH_PROPERTY, plank_position_manager_properties[PLANK_POSITION_MANAGER_LINE_WIDTH_PROPERTY] = g_param_spec_int ("LineWidth", "LineWidth", "LineWidth", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Cached current icon size for the dock.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_POSITION_MANAGER_ICON_SIZE_PROPERTY, plank_position_manager_properties[PLANK_POSITION_MANAGER_ICON_SIZE_PROPERTY] = g_param_spec_int ("IconSize", "IconSize", "IconSize", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Cached current icon size for the dock.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_POSITION_MANAGER_ZOOM_ICON_SIZE_PROPERTY, plank_position_manager_properties[PLANK_POSITION_MANAGER_ZOOM_ICON_SIZE_PROPERTY] = g_param_spec_int ("ZoomIconSize", "ZoomIconSize", "ZoomIconSize", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Cached position of the dock.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_POSITION_MANAGER_POSITION_PROPERTY, plank_position_manager_properties[PLANK_POSITION_MANAGER_POSITION_PROPERTY] = g_param_spec_enum ("Position", "Position", "Position", gtk_position_type_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Cached alignment of the dock.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_POSITION_MANAGER_ALIGNMENT_PROPERTY, plank_position_manager_properties[PLANK_POSITION_MANAGER_ALIGNMENT_PROPERTY] = g_param_spec_enum ("Alignment", "Alignment", "Alignment", gtk_align_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Cached alignment of the items.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_POSITION_MANAGER_ITEMS_ALIGNMENT_PROPERTY, plank_position_manager_properties[PLANK_POSITION_MANAGER_ITEMS_ALIGNMENT_PROPERTY] = g_param_spec_enum ("ItemsAlignment", "ItemsAlignment", "ItemsAlignment", gtk_align_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Cached offset of the dock.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_POSITION_MANAGER_OFFSET_PROPERTY, plank_position_manager_properties[PLANK_POSITION_MANAGER_OFFSET_PROPERTY] = g_param_spec_int ("Offset", "Offset", "Offset", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Theme-based indicator size, scaled by icon size.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_POSITION_MANAGER_INDICATOR_SIZE_PROPERTY, plank_position_manager_properties[PLANK_POSITION_MANAGER_INDICATOR_SIZE_PROPERTY] = g_param_spec_int ("IndicatorSize", "IndicatorSize", "IndicatorSize", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Theme-based icon-shadow size, scaled by icon size.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_POSITION_MANAGER_ICON_SHADOW_SIZE_PROPERTY, plank_position_manager_properties[PLANK_POSITION_MANAGER_ICON_SHADOW_SIZE_PROPERTY] = g_param_spec_int ("IconShadowSize", "IconShadowSize", "IconShadowSize", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Theme-based urgent glow size, scaled by icon size.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_POSITION_MANAGER_GLOW_SIZE_PROPERTY, plank_position_manager_properties[PLANK_POSITION_MANAGER_GLOW_SIZE_PROPERTY] = g_param_spec_int ("GlowSize", "GlowSize", "GlowSize", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Theme-based horizontal padding, scaled by icon size.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_POSITION_MANAGER_HORIZ_PADDING_PROPERTY, plank_position_manager_properties[PLANK_POSITION_MANAGER_HORIZ_PADDING_PROPERTY] = g_param_spec_int ("HorizPadding", "HorizPadding", "HorizPadding", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Theme-based top padding, scaled by icon size.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_POSITION_MANAGER_TOP_PADDING_PROPERTY, plank_position_manager_properties[PLANK_POSITION_MANAGER_TOP_PADDING_PROPERTY] = g_param_spec_int ("TopPadding", "TopPadding", "TopPadding", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Theme-based bottom padding, scaled by icon size.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_POSITION_MANAGER_BOTTOM_PADDING_PROPERTY, plank_position_manager_properties[PLANK_POSITION_MANAGER_BOTTOM_PADDING_PROPERTY] = g_param_spec_int ("BottomPadding", "BottomPadding", "BottomPadding", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Theme-based item padding, scaled by icon size.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_POSITION_MANAGER_ITEM_PADDING_PROPERTY, plank_position_manager_properties[PLANK_POSITION_MANAGER_ITEM_PADDING_PROPERTY] = g_param_spec_int ("ItemPadding", "ItemPadding", "ItemPadding", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Theme-based urgent-bounce height, scaled by icon size.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_POSITION_MANAGER_URGENT_BOUNCE_HEIGHT_PROPERTY, plank_position_manager_properties[PLANK_POSITION_MANAGER_URGENT_BOUNCE_HEIGHT_PROPERTY] = g_param_spec_int ("UrgentBounceHeight", "UrgentBounceHeight", "UrgentBounceHeight", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Theme-based launch-bounce height, scaled by icon size.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_POSITION_MANAGER_LAUNCH_BOUNCE_HEIGHT_PROPERTY, plank_position_manager_properties[PLANK_POSITION_MANAGER_LAUNCH_BOUNCE_HEIGHT_PROPERTY] = g_param_spec_int ("LaunchBounceHeight", "LaunchBounceHeight", "LaunchBounceHeight", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * The maximum item count which fit the dock in its maximum
	 * size with the current theme and icon-size.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_POSITION_MANAGER_MAX_ITEM_COUNT_PROPERTY, plank_position_manager_properties[PLANK_POSITION_MANAGER_MAX_ITEM_COUNT_PROPERTY] = g_param_spec_int ("MaxItemCount", "MaxItemCount", "MaxItemCount", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
plank_position_manager_instance_init (PlankPositionManager * self,
                                      gpointer klass)
{
	self->priv = plank_position_manager_get_instance_private (self);
	self->priv->window_scale_factor = 1;
	self->priv->_MaxIconSize = PLANK_DOCK_PREFERENCES_MAX_ICON_SIZE;
}

static void
plank_position_manager_finalize (GObject * obj)
{
	PlankPositionManager * self;
	GdkScreen* screen = NULL;
	PlankDockController* _tmp0_;
	PlankDockWindow* _tmp1_;
	PlankDockWindow* _tmp2_;
	GdkScreen* _tmp3_;
	GdkScreen* _tmp4_;
	guint _tmp5_;
	GdkScreen* _tmp6_;
	guint _tmp7_;
	GdkScreen* _tmp8_;
	guint _tmp9_;
	PlankDockController* _tmp10_;
	PlankDockPreferences* _tmp11_;
	PlankDockPreferences* _tmp12_;
	guint _tmp13_;
	GeeHashMap* _tmp14_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_POSITION_MANAGER, PlankPositionManager);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_window (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_window_get_screen ((GtkWindow*) _tmp2_);
	screen = _tmp3_;
	_tmp4_ = screen;
	g_signal_parse_name ("monitors-changed", gdk_screen_get_type (), &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _plank_position_manager_screen_changed_gdk_screen_monitors_changed, self);
	_tmp6_ = screen;
	g_signal_parse_name ("size-changed", gdk_screen_get_type (), &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _plank_position_manager_screen_changed_gdk_screen_size_changed, self);
	_tmp8_ = screen;
	g_signal_parse_name ("composited-changed", gdk_screen_get_type (), &_tmp9_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _plank_position_manager_screen_composited_changed_gdk_screen_composited_changed, self);
	_tmp10_ = self->priv->_controller;
	_tmp11_ = plank_dock_controller_get_prefs (_tmp10_);
	_tmp12_ = _tmp11_;
	g_signal_parse_name ("notify", G_TYPE_OBJECT, &_tmp13_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp12_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, 0, NULL, (GCallback) _plank_position_manager_prefs_changed_g_object_notify, self);
	_tmp14_ = self->priv->draw_values;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp14_);
	_g_object_unref0 (self->priv->_controller);
	_g_object_unref0 (self->priv->draw_values);
	G_OBJECT_CLASS (plank_position_manager_parent_class)->finalize (obj);
}

/**
 * Handles computing any size/position information for the dock.
 */
static GType
plank_position_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankPositionManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_position_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankPositionManager), 0, (GInstanceInitFunc) plank_position_manager_instance_init, NULL };
	GType plank_position_manager_type_id;
	plank_position_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "PlankPositionManager", &g_define_type_info, 0);
	PlankPositionManager_private_offset = g_type_add_instance_private (plank_position_manager_type_id, sizeof (PlankPositionManagerPrivate));
	return plank_position_manager_type_id;
}

GType
plank_position_manager_get_type (void)
{
	static volatile gsize plank_position_manager_type_id__once = 0;
	if (g_once_init_enter (&plank_position_manager_type_id__once)) {
		GType plank_position_manager_type_id;
		plank_position_manager_type_id = plank_position_manager_get_type_once ();
		g_once_init_leave (&plank_position_manager_type_id__once, plank_position_manager_type_id);
	}
	return plank_position_manager_type_id__once;
}

static void
_vala_plank_position_manager_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	PlankPositionManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_POSITION_MANAGER, PlankPositionManager);
	switch (property_id) {
		case PLANK_POSITION_MANAGER_CONTROLLER_PROPERTY:
		g_value_set_object (value, plank_position_manager_get_controller (self));
		break;
		case PLANK_POSITION_MANAGER_SCREEN_IS_COMPOSITED_PROPERTY:
		g_value_set_boolean (value, plank_position_manager_get_screen_is_composited (self));
		break;
		case PLANK_POSITION_MANAGER_LINE_WIDTH_PROPERTY:
		g_value_set_int (value, plank_position_manager_get_LineWidth (self));
		break;
		case PLANK_POSITION_MANAGER_ICON_SIZE_PROPERTY:
		g_value_set_int (value, plank_position_manager_get_IconSize (self));
		break;
		case PLANK_POSITION_MANAGER_ZOOM_ICON_SIZE_PROPERTY:
		g_value_set_int (value, plank_position_manager_get_ZoomIconSize (self));
		break;
		case PLANK_POSITION_MANAGER_POSITION_PROPERTY:
		g_value_set_enum (value, plank_position_manager_get_Position (self));
		break;
		case PLANK_POSITION_MANAGER_ALIGNMENT_PROPERTY:
		g_value_set_enum (value, plank_position_manager_get_Alignment (self));
		break;
		case PLANK_POSITION_MANAGER_ITEMS_ALIGNMENT_PROPERTY:
		g_value_set_enum (value, plank_position_manager_get_ItemsAlignment (self));
		break;
		case PLANK_POSITION_MANAGER_OFFSET_PROPERTY:
		g_value_set_int (value, plank_position_manager_get_Offset (self));
		break;
		case PLANK_POSITION_MANAGER_INDICATOR_SIZE_PROPERTY:
		g_value_set_int (value, plank_position_manager_get_IndicatorSize (self));
		break;
		case PLANK_POSITION_MANAGER_ICON_SHADOW_SIZE_PROPERTY:
		g_value_set_int (value, plank_position_manager_get_IconShadowSize (self));
		break;
		case PLANK_POSITION_MANAGER_GLOW_SIZE_PROPERTY:
		g_value_set_int (value, plank_position_manager_get_GlowSize (self));
		break;
		case PLANK_POSITION_MANAGER_HORIZ_PADDING_PROPERTY:
		g_value_set_int (value, plank_position_manager_get_HorizPadding (self));
		break;
		case PLANK_POSITION_MANAGER_TOP_PADDING_PROPERTY:
		g_value_set_int (value, plank_position_manager_get_TopPadding (self));
		break;
		case PLANK_POSITION_MANAGER_BOTTOM_PADDING_PROPERTY:
		g_value_set_int (value, plank_position_manager_get_BottomPadding (self));
		break;
		case PLANK_POSITION_MANAGER_ITEM_PADDING_PROPERTY:
		g_value_set_int (value, plank_position_manager_get_ItemPadding (self));
		break;
		case PLANK_POSITION_MANAGER_URGENT_BOUNCE_HEIGHT_PROPERTY:
		g_value_set_int (value, plank_position_manager_get_UrgentBounceHeight (self));
		break;
		case PLANK_POSITION_MANAGER_LAUNCH_BOUNCE_HEIGHT_PROPERTY:
		g_value_set_int (value, plank_position_manager_get_LaunchBounceHeight (self));
		break;
		case PLANK_POSITION_MANAGER_MAX_ITEM_COUNT_PROPERTY:
		g_value_set_int (value, plank_position_manager_get_MaxItemCount (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_plank_position_manager_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	PlankPositionManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_POSITION_MANAGER, PlankPositionManager);
	switch (property_id) {
		case PLANK_POSITION_MANAGER_CONTROLLER_PROPERTY:
		plank_position_manager_set_controller (self, g_value_get_object (value));
		break;
		case PLANK_POSITION_MANAGER_SCREEN_IS_COMPOSITED_PROPERTY:
		plank_position_manager_set_screen_is_composited (self, g_value_get_boolean (value));
		break;
		case PLANK_POSITION_MANAGER_LINE_WIDTH_PROPERTY:
		plank_position_manager_set_LineWidth (self, g_value_get_int (value));
		break;
		case PLANK_POSITION_MANAGER_ICON_SIZE_PROPERTY:
		plank_position_manager_set_IconSize (self, g_value_get_int (value));
		break;
		case PLANK_POSITION_MANAGER_ZOOM_ICON_SIZE_PROPERTY:
		plank_position_manager_set_ZoomIconSize (self, g_value_get_int (value));
		break;
		case PLANK_POSITION_MANAGER_POSITION_PROPERTY:
		plank_position_manager_set_Position (self, g_value_get_enum (value));
		break;
		case PLANK_POSITION_MANAGER_ALIGNMENT_PROPERTY:
		plank_position_manager_set_Alignment (self, g_value_get_enum (value));
		break;
		case PLANK_POSITION_MANAGER_ITEMS_ALIGNMENT_PROPERTY:
		plank_position_manager_set_ItemsAlignment (self, g_value_get_enum (value));
		break;
		case PLANK_POSITION_MANAGER_OFFSET_PROPERTY:
		plank_position_manager_set_Offset (self, g_value_get_int (value));
		break;
		case PLANK_POSITION_MANAGER_INDICATOR_SIZE_PROPERTY:
		plank_position_manager_set_IndicatorSize (self, g_value_get_int (value));
		break;
		case PLANK_POSITION_MANAGER_ICON_SHADOW_SIZE_PROPERTY:
		plank_position_manager_set_IconShadowSize (self, g_value_get_int (value));
		break;
		case PLANK_POSITION_MANAGER_GLOW_SIZE_PROPERTY:
		plank_position_manager_set_GlowSize (self, g_value_get_int (value));
		break;
		case PLANK_POSITION_MANAGER_HORIZ_PADDING_PROPERTY:
		plank_position_manager_set_HorizPadding (self, g_value_get_int (value));
		break;
		case PLANK_POSITION_MANAGER_TOP_PADDING_PROPERTY:
		plank_position_manager_set_TopPadding (self, g_value_get_int (value));
		break;
		case PLANK_POSITION_MANAGER_BOTTOM_PADDING_PROPERTY:
		plank_position_manager_set_BottomPadding (self, g_value_get_int (value));
		break;
		case PLANK_POSITION_MANAGER_ITEM_PADDING_PROPERTY:
		plank_position_manager_set_ItemPadding (self, g_value_get_int (value));
		break;
		case PLANK_POSITION_MANAGER_URGENT_BOUNCE_HEIGHT_PROPERTY:
		plank_position_manager_set_UrgentBounceHeight (self, g_value_get_int (value));
		break;
		case PLANK_POSITION_MANAGER_LAUNCH_BOUNCE_HEIGHT_PROPERTY:
		plank_position_manager_set_LaunchBounceHeight (self, g_value_get_int (value));
		break;
		case PLANK_POSITION_MANAGER_MAX_ITEM_COUNT_PROPERTY:
		plank_position_manager_set_MaxItemCount (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

