/* DockElement.c generated by valac 0.56.17, the Vala compiler
 * generated from DockElement.vala, do not modify */

/**/
/*  Copyright (C) 2011-2012 Robert Dyer, Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <gee.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLANK_DOCK_ELEMENT_0_PROPERTY,
	PLANK_DOCK_ELEMENT_CONTAINER_PROPERTY,
	PLANK_DOCK_ELEMENT_TEXT_PROPERTY,
	PLANK_DOCK_ELEMENT_IS_ATTACHED_PROPERTY,
	PLANK_DOCK_ELEMENT_IS_VISIBLE_PROPERTY,
	PLANK_DOCK_ELEMENT_BUTTON_PROPERTY,
	PLANK_DOCK_ELEMENT_CLICKED_ANIMATION_PROPERTY,
	PLANK_DOCK_ELEMENT_HOVERED_ANIMATION_PROPERTY,
	PLANK_DOCK_ELEMENT_SCROLLED_ANIMATION_PROPERTY,
	PLANK_DOCK_ELEMENT_ADD_TIME_PROPERTY,
	PLANK_DOCK_ELEMENT_REMOVE_TIME_PROPERTY,
	PLANK_DOCK_ELEMENT_LAST_CLICKED_PROPERTY,
	PLANK_DOCK_ELEMENT_LAST_HOVERED_PROPERTY,
	PLANK_DOCK_ELEMENT_LAST_SCROLLED_PROPERTY,
	PLANK_DOCK_ELEMENT_LAST_URGENT_PROPERTY,
	PLANK_DOCK_ELEMENT_LAST_ACTIVE_PROPERTY,
	PLANK_DOCK_ELEMENT_LAST_MOVE_PROPERTY,
	PLANK_DOCK_ELEMENT_LAST_VALID_PROPERTY,
	PLANK_DOCK_ELEMENT_NUM_PROPERTIES
};
static GParamSpec* plank_dock_element_properties[PLANK_DOCK_ELEMENT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	PLANK_DOCK_ELEMENT_NEEDS_REDRAW_SIGNAL,
	PLANK_DOCK_ELEMENT_NUM_SIGNALS
};
static guint plank_dock_element_signals[PLANK_DOCK_ELEMENT_NUM_SIGNALS] = {0};

struct _PlankDockElementPrivate {
	PlankDockContainer* _Container;
	gchar* _Text;
	gboolean _IsAttached;
	gboolean _IsVisible;
	PlankPopupButton _Button;
	PlankAnimationType _ClickedAnimation;
	PlankAnimationType _HoveredAnimation;
	PlankAnimationType _ScrolledAnimation;
	gint64 _AddTime;
	gint64 _RemoveTime;
	gint64 _LastClicked;
	gint64 _LastHovered;
	gint64 _LastScrolled;
	gint64 _LastUrgent;
	gint64 _LastActive;
	gint64 _LastMove;
	gint64 _LastValid;
};

static gint PlankDockElement_private_offset;
static gpointer plank_dock_element_parent_class = NULL;

static PlankAnimationType plank_dock_element_real_on_clicked (PlankDockElement* self,
                                                       PlankPopupButton button,
                                                       GdkModifierType mod,
                                                       guint32 event_time);
static PlankAnimationType plank_dock_element_real_on_hovered (PlankDockElement* self);
static PlankAnimationType plank_dock_element_real_on_scrolled (PlankDockElement* self,
                                                        GdkScrollDirection direction,
                                                        GdkModifierType mod,
                                                        guint32 event_time);
static GeeArrayList* plank_dock_element_real_get_menu_items (PlankDockElement* self);
static gchar* plank_dock_element_real_get_drop_text (PlankDockElement* self);
static gboolean plank_dock_element_real_can_be_removed (PlankDockElement* self);
static gboolean plank_dock_element_real_can_accept_drop (PlankDockElement* self,
                                                  GeeArrayList* uris);
static gboolean plank_dock_element_real_accept_drop (PlankDockElement* self,
                                              GeeArrayList* uris);
static gchar* plank_dock_element_real_unique_id (PlankDockElement* self);
static void plank_dock_element_real_reset_buffers (PlankDockElement* self);
static GtkMenuItem* plank_dock_element_create_menu_item_iternal (const gchar* title,
                                                          GdkPixbuf* pixbuf,
                                                          gboolean force_show_icon,
                                                          gboolean mnemonics);
static void plank_dock_element_finalize (GObject * obj);
static GType plank_dock_element_get_type_once (void);
static void _vala_plank_dock_element_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_plank_dock_element_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);

static inline gpointer
plank_dock_element_get_instance_private (PlankDockElement* self)
{
	return G_STRUCT_MEMBER_P (self, PlankDockElement_private_offset);
}

/**
 * Called when an item is clicked on.
 *
 * @param button the button clicked
 * @param mod the modifiers
 * @param event_time the timestamp of the event triggering this action
 */
void
plank_dock_element_clicked (PlankDockElement* self,
                            PlankPopupButton button,
                            GdkModifierType mod,
                            guint32 event_time)
{
	g_return_if_fail (self != NULL);
	plank_dock_element_set_ClickedAnimation (self, plank_dock_element_on_clicked (self, button, mod, event_time));
	plank_dock_element_set_LastClicked (self, g_get_monotonic_time ());
}

/**
 * Called when an item is clicked on.
 *
 * @param button the button clicked
 * @param mod the modifiers
 * @param event_time the timestamp of the event triggering this action
 * @return which type of animation to trigger
 */
static PlankAnimationType
plank_dock_element_real_on_clicked (PlankDockElement* self,
                                    PlankPopupButton button,
                                    GdkModifierType mod,
                                    guint32 event_time)
{
	PlankAnimationType result;
	result = PLANK_ANIMATION_TYPE_NONE;
	return result;
}

PlankAnimationType
plank_dock_element_on_clicked (PlankDockElement* self,
                               PlankPopupButton button,
                               GdkModifierType mod,
                               guint32 event_time)
{
	PlankDockElementClass* _klass_;
	g_return_val_if_fail (self != NULL, 0);
	_klass_ = PLANK_DOCK_ELEMENT_GET_CLASS (self);
	if (_klass_->on_clicked) {
		return _klass_->on_clicked (self, button, mod, event_time);
	}
	return 0;
}

/**
 * Called when an item gets hovered.
 */
void
plank_dock_element_hovered (PlankDockElement* self)
{
	g_return_if_fail (self != NULL);
	plank_dock_element_set_HoveredAnimation (self, plank_dock_element_on_hovered (self));
	plank_dock_element_set_LastHovered (self, g_get_monotonic_time ());
}

/**
 * Called when an item gets hovered.
 *
 * @return which type of animation to trigger
 */
static PlankAnimationType
plank_dock_element_real_on_hovered (PlankDockElement* self)
{
	PlankAnimationType result;
	result = PLANK_ANIMATION_TYPE_LIGHTEN;
	return result;
}

PlankAnimationType
plank_dock_element_on_hovered (PlankDockElement* self)
{
	PlankDockElementClass* _klass_;
	g_return_val_if_fail (self != NULL, 0);
	_klass_ = PLANK_DOCK_ELEMENT_GET_CLASS (self);
	if (_klass_->on_hovered) {
		return _klass_->on_hovered (self);
	}
	return 0;
}

/**
 * Called when an item is scrolled over.
 *
 * @param direction the scroll direction
 * @param mod the modifiers
 * @param event_time the timestamp of the event triggering this action
 */
void
plank_dock_element_scrolled (PlankDockElement* self,
                             GdkScrollDirection direction,
                             GdkModifierType mod,
                             guint32 event_time)
{
	g_return_if_fail (self != NULL);
	plank_dock_element_set_ScrolledAnimation (self, plank_dock_element_on_scrolled (self, direction, mod, event_time));
}

/**
 * Called when an item is scrolled over.
 *
 * @param direction the scroll direction
 * @param mod the modifiers
 * @param event_time the timestamp of the event triggering this action
 * @return which type of animation to trigger
 */
static PlankAnimationType
plank_dock_element_real_on_scrolled (PlankDockElement* self,
                                     GdkScrollDirection direction,
                                     GdkModifierType mod,
                                     guint32 event_time)
{
	PlankAnimationType result;
	plank_dock_element_set_LastScrolled (self, g_get_monotonic_time ());
	result = PLANK_ANIMATION_TYPE_NONE;
	return result;
}

PlankAnimationType
plank_dock_element_on_scrolled (PlankDockElement* self,
                                GdkScrollDirection direction,
                                GdkModifierType mod,
                                guint32 event_time)
{
	PlankDockElementClass* _klass_;
	g_return_val_if_fail (self != NULL, 0);
	_klass_ = PLANK_DOCK_ELEMENT_GET_CLASS (self);
	if (_klass_->on_scrolled) {
		return _klass_->on_scrolled (self, direction, mod, event_time);
	}
	return 0;
}

/**
 * Get the dock which this element is part of
 *
 * @return the dock-controller of this element, or null
 */
PlankDockController*
plank_dock_element_get_dock (PlankDockElement* self)
{
	PlankDockContainer* container = NULL;
	PlankDockContainer* _tmp0_;
	PlankDockController* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_Container;
	container = _tmp0_;
	while (TRUE) {
		PlankDockContainer* _tmp1_;
		PlankDockContainer* _tmp2_;
		PlankDockContainer* _tmp4_;
		PlankDockContainer* _tmp5_;
		_tmp1_ = container;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = container;
		if (PLANK_IS_DOCK_CONTROLLER (_tmp2_)) {
			PlankDockContainer* _tmp3_;
			_tmp3_ = container;
			result = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, PLANK_TYPE_DOCK_CONTROLLER, PlankDockController);
			return result;
		}
		_tmp4_ = container;
		_tmp5_ = ((PlankDockElement*) _tmp4_)->priv->_Container;
		container = _tmp5_;
	}
	result = NULL;
	return result;
}

/**
 * Returns a list of the item's menu items.
 *
 * @return the item's menu items
 */
static GeeArrayList*
plank_dock_element_real_get_menu_items (PlankDockElement* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* result;
	_tmp0_ = gee_array_list_new (gtk_menu_item_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	result = _tmp0_;
	return result;
}

GeeArrayList*
plank_dock_element_get_menu_items (PlankDockElement* self)
{
	PlankDockElementClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = PLANK_DOCK_ELEMENT_GET_CLASS (self);
	if (_klass_->get_menu_items) {
		return _klass_->get_menu_items (self);
	}
	return NULL;
}

/**
 * The item's text for drop actions.
 *
 * @return the item's drop-text
 */
static gchar*
plank_dock_element_real_get_drop_text (PlankDockElement* self)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup ("");
	result = _tmp0_;
	return result;
}

gchar*
plank_dock_element_get_drop_text (PlankDockElement* self)
{
	PlankDockElementClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = PLANK_DOCK_ELEMENT_GET_CLASS (self);
	if (_klass_->get_drop_text) {
		return _klass_->get_drop_text (self);
	}
	return NULL;
}

/**
 * Returns if this item can be removed from the dock.
 *
 * @return if this item can be removed from the dock
 */
static gboolean
plank_dock_element_real_can_be_removed (PlankDockElement* self)
{
	gboolean result;
	result = TRUE;
	return result;
}

gboolean
plank_dock_element_can_be_removed (PlankDockElement* self)
{
	PlankDockElementClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PLANK_DOCK_ELEMENT_GET_CLASS (self);
	if (_klass_->can_be_removed) {
		return _klass_->can_be_removed (self);
	}
	return FALSE;
}

/**
 * Returns if the item accepts a drop of the given URIs.
 *
 * @param uris the URIs to check
 * @return if the item accepts a drop of the given URIs
 */
static gboolean
plank_dock_element_real_can_accept_drop (PlankDockElement* self,
                                         GeeArrayList* uris)
{
	gboolean result;
	g_return_val_if_fail (uris != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
plank_dock_element_can_accept_drop (PlankDockElement* self,
                                    GeeArrayList* uris)
{
	PlankDockElementClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PLANK_DOCK_ELEMENT_GET_CLASS (self);
	if (_klass_->can_accept_drop) {
		return _klass_->can_accept_drop (self, uris);
	}
	return FALSE;
}

/**
 * Accepts a drop of the given URIs.
 *
 * @param uris the URIs to accept
 * @return if the item accepted a drop of the given URIs
 */
static gboolean
plank_dock_element_real_accept_drop (PlankDockElement* self,
                                     GeeArrayList* uris)
{
	gboolean result;
	g_return_val_if_fail (uris != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
plank_dock_element_accept_drop (PlankDockElement* self,
                                GeeArrayList* uris)
{
	PlankDockElementClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PLANK_DOCK_ELEMENT_GET_CLASS (self);
	if (_klass_->accept_drop) {
		return _klass_->accept_drop (self, uris);
	}
	return FALSE;
}

/**
 * Returns a unique ID for this dock item.
 *
 * @return a unique ID for this dock element
 */
static gchar*
plank_dock_element_real_unique_id (PlankDockElement* self)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup_printf ("dockelement%p", self);
	result = _tmp0_;
	return result;
}

gchar*
plank_dock_element_unique_id (PlankDockElement* self)
{
	PlankDockElementClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = PLANK_DOCK_ELEMENT_GET_CLASS (self);
	if (_klass_->unique_id) {
		return _klass_->unique_id (self);
	}
	return NULL;
}

/**
 * Returns a unique URI for this dock element.
 *
 * @return a unique URI for this dock element
 */
gchar*
plank_dock_element_as_uri (PlankDockElement* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = plank_dock_element_unique_id (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("plank://%s", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

/**
 * Resets the buffers for this element.
 */
static void
plank_dock_element_real_reset_buffers (PlankDockElement* self)
{
	g_critical ("Type `%s' does not implement abstract method `plank_dock_element_reset_buffers'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
plank_dock_element_reset_buffers (PlankDockElement* self)
{
	PlankDockElementClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PLANK_DOCK_ELEMENT_GET_CLASS (self);
	if (_klass_->reset_buffers) {
		_klass_->reset_buffers (self);
	}
}

/**
 * Creates a new menu item with mnemonics enabled.
 *
 * @param title the title of the menu item
 * @param icon the icon of the menu item
 * @param force_show_icon whether to force showing the icon
 * @return the new menu item
 */
GtkMenuItem*
plank_dock_element_create_menu_item (const gchar* title,
                                     const gchar* icon,
                                     gboolean force_show_icon)
{
	gboolean _tmp0_ = FALSE;
	gint width = 0;
	gint height = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GdkPixbuf* _tmp4_;
	GtkMenuItem* _tmp5_;
	GtkMenuItem* result;
	g_return_val_if_fail (title != NULL, NULL);
	if (icon == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (icon, "") == 0;
	}
	if (_tmp0_) {
		GtkMenuItem* _tmp1_;
		_tmp1_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (title);
		g_object_ref_sink (_tmp1_);
		result = _tmp1_;
		return result;
	}
	gtk_icon_size_lookup (GTK_ICON_SIZE_MENU, &_tmp2_, &_tmp3_);
	width = _tmp2_;
	height = _tmp3_;
	_tmp4_ = plank_drawing_service_load_icon (icon, width, height);
	_tmp5_ = plank_dock_element_create_menu_item_iternal (title, _tmp4_, force_show_icon, TRUE);
	result = _tmp5_;
	return result;
}

/**
 * Creates a new menu item with mnemonics enabled.
 *
 * @param title the title of the menu item
 * @param pixbuf the icon of the menu item
 * @param force_show_icon whether to force showing the icon
 * @return the new menu item
 */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GtkMenuItem*
plank_dock_element_create_menu_item_with_pixbuf (const gchar* title,
                                                 GdkPixbuf* pixbuf,
                                                 gboolean force_show_icon)
{
	gint width = 0;
	gint height = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_;
	gint _tmp4_;
	GdkPixbuf* _tmp8_;
	GtkMenuItem* _tmp9_;
	GtkMenuItem* result;
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (pixbuf != NULL, NULL);
	gtk_icon_size_lookup (GTK_ICON_SIZE_MENU, &_tmp0_, &_tmp1_);
	width = _tmp0_;
	height = _tmp1_;
	_tmp3_ = gdk_pixbuf_get_width (pixbuf);
	_tmp4_ = _tmp3_;
	if (width != _tmp4_) {
		_tmp2_ = TRUE;
	} else {
		gint _tmp5_;
		gint _tmp6_;
		_tmp5_ = gdk_pixbuf_get_height (pixbuf);
		_tmp6_ = _tmp5_;
		_tmp2_ = height != _tmp6_;
	}
	if (_tmp2_) {
		GdkPixbuf* _tmp7_;
		_tmp7_ = plank_drawing_service_ar_scale (pixbuf, width, height);
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp7_;
	}
	_tmp8_ = _g_object_ref0 (pixbuf);
	_tmp9_ = plank_dock_element_create_menu_item_iternal (title, _tmp8_, force_show_icon, TRUE);
	result = _tmp9_;
	_g_object_unref0 (pixbuf);
	return result;
}

/**
 * Creates a new menu item with mnemonics disabled.
 *
 * @param title the title of the menu item
 * @param icon the icon of the menu item
 * @param force_show_icon whether to force showing the icon
 * @return the new menu item
 */
GtkMenuItem*
plank_dock_element_create_literal_menu_item (const gchar* title,
                                             const gchar* icon,
                                             gboolean force_show_icon)
{
	gboolean _tmp0_ = FALSE;
	gint width = 0;
	gint height = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GdkPixbuf* _tmp4_;
	GtkMenuItem* _tmp5_;
	GtkMenuItem* result;
	g_return_val_if_fail (title != NULL, NULL);
	if (icon == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (icon, "") == 0;
	}
	if (_tmp0_) {
		GtkMenuItem* _tmp1_;
		_tmp1_ = (GtkMenuItem*) gtk_menu_item_new_with_label (title);
		g_object_ref_sink (_tmp1_);
		result = _tmp1_;
		return result;
	}
	gtk_icon_size_lookup (GTK_ICON_SIZE_MENU, &_tmp2_, &_tmp3_);
	width = _tmp2_;
	height = _tmp3_;
	_tmp4_ = plank_drawing_service_load_icon (icon, width, height);
	_tmp5_ = plank_dock_element_create_menu_item_iternal (title, _tmp4_, force_show_icon, FALSE);
	result = _tmp5_;
	return result;
}

/**
 * Creates a new menu item with mnemonics disabled.
 *
 * @param title the title of the menu item
 * @param pixbuf the icon of the menu item
 * @param force_show_icon whether to force showing the icon
 * @return the new menu item
 */
GtkMenuItem*
plank_dock_element_create_literal_menu_item_with_pixbuf (const gchar* title,
                                                         GdkPixbuf* pixbuf,
                                                         gboolean force_show_icon)
{
	gint width = 0;
	gint height = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_;
	gint _tmp4_;
	GdkPixbuf* _tmp8_;
	GtkMenuItem* _tmp9_;
	GtkMenuItem* result;
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (pixbuf != NULL, NULL);
	gtk_icon_size_lookup (GTK_ICON_SIZE_MENU, &_tmp0_, &_tmp1_);
	width = _tmp0_;
	height = _tmp1_;
	_tmp3_ = gdk_pixbuf_get_width (pixbuf);
	_tmp4_ = _tmp3_;
	if (width != _tmp4_) {
		_tmp2_ = TRUE;
	} else {
		gint _tmp5_;
		gint _tmp6_;
		_tmp5_ = gdk_pixbuf_get_height (pixbuf);
		_tmp6_ = _tmp5_;
		_tmp2_ = height != _tmp6_;
	}
	if (_tmp2_) {
		GdkPixbuf* _tmp7_;
		_tmp7_ = plank_drawing_service_ar_scale (pixbuf, width, height);
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp7_;
	}
	_tmp8_ = _g_object_ref0 (pixbuf);
	_tmp9_ = plank_dock_element_create_menu_item_iternal (title, _tmp8_, force_show_icon, FALSE);
	result = _tmp9_;
	_g_object_unref0 (pixbuf);
	return result;
}

static GtkMenuItem*
plank_dock_element_create_menu_item_iternal (const gchar* title,
                                             GdkPixbuf* pixbuf,
                                             gboolean force_show_icon,
                                             gboolean mnemonics)
{
	GtkImageMenuItem* _tmp0_ = NULL;
	GtkImageMenuItem* item = NULL;
	GtkImageMenuItem* _tmp3_;
	GtkImageMenuItem* _tmp4_;
	GtkImage* _tmp5_;
	GtkImage* _tmp6_;
	GtkMenuItem* result;
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (pixbuf != NULL, NULL);
	if (mnemonics) {
		GtkImageMenuItem* _tmp1_;
		_tmp1_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_mnemonic (title);
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		GtkImageMenuItem* _tmp2_;
		_tmp2_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_label (title);
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = _g_object_ref0 (_tmp0_);
	item = _tmp3_;
	_tmp4_ = item;
	_tmp5_ = (GtkImage*) gtk_image_new_from_pixbuf (pixbuf);
	g_object_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	gtk_image_menu_item_set_image (_tmp4_, (GtkWidget*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	if (force_show_icon) {
		GtkImageMenuItem* _tmp7_;
		_tmp7_ = item;
		gtk_image_menu_item_set_always_show_image (_tmp7_, TRUE);
	}
	result = (GtkMenuItem*) item;
	_g_object_unref0 (_tmp0_);
	_g_object_unref0 (pixbuf);
	return result;
}

PlankDockElement*
plank_dock_element_construct (GType object_type)
{
	PlankDockElement * self = NULL;
	self = (PlankDockElement*) g_object_new (object_type, NULL);
	return self;
}

PlankDockContainer*
plank_dock_element_get_Container (PlankDockElement* self)
{
	PlankDockContainer* result;
	PlankDockContainer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_Container;
	result = _tmp0_;
	return result;
}

void
plank_dock_element_set_Container (PlankDockElement* self,
                                  PlankDockContainer* value)
{
	PlankDockContainer* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_element_get_Container (self);
	if (old_value != value) {
		PlankDockContainer* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_Container);
		self->priv->_Container = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_element_properties[PLANK_DOCK_ELEMENT_CONTAINER_PROPERTY]);
	}
}

const gchar*
plank_dock_element_get_Text (PlankDockElement* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_Text;
	result = _tmp0_;
	return result;
}

void
plank_dock_element_set_Text (PlankDockElement* self,
                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_element_get_Text (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_Text);
		self->priv->_Text = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_element_properties[PLANK_DOCK_ELEMENT_TEXT_PROPERTY]);
	}
}

gboolean
plank_dock_element_get_IsAttached (PlankDockElement* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_IsAttached;
	return result;
}

void
plank_dock_element_set_IsAttached (PlankDockElement* self,
                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_element_get_IsAttached (self);
	if (old_value != value) {
		self->priv->_IsAttached = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_element_properties[PLANK_DOCK_ELEMENT_IS_ATTACHED_PROPERTY]);
	}
}

gboolean
plank_dock_element_get_IsVisible (PlankDockElement* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_IsVisible;
	return result;
}

void
plank_dock_element_set_IsVisible (PlankDockElement* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_element_get_IsVisible (self);
	if (old_value != value) {
		self->priv->_IsVisible = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_element_properties[PLANK_DOCK_ELEMENT_IS_VISIBLE_PROPERTY]);
	}
}

PlankPopupButton
plank_dock_element_get_Button (PlankDockElement* self)
{
	PlankPopupButton result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_Button;
	return result;
}

void
plank_dock_element_set_Button (PlankDockElement* self,
                               PlankPopupButton value)
{
	PlankPopupButton old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_element_get_Button (self);
	if (old_value != value) {
		self->priv->_Button = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_element_properties[PLANK_DOCK_ELEMENT_BUTTON_PROPERTY]);
	}
}

PlankAnimationType
plank_dock_element_get_ClickedAnimation (PlankDockElement* self)
{
	PlankAnimationType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_ClickedAnimation;
	return result;
}

void
plank_dock_element_set_ClickedAnimation (PlankDockElement* self,
                                         PlankAnimationType value)
{
	PlankAnimationType old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_element_get_ClickedAnimation (self);
	if (old_value != value) {
		self->priv->_ClickedAnimation = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_element_properties[PLANK_DOCK_ELEMENT_CLICKED_ANIMATION_PROPERTY]);
	}
}

PlankAnimationType
plank_dock_element_get_HoveredAnimation (PlankDockElement* self)
{
	PlankAnimationType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_HoveredAnimation;
	return result;
}

void
plank_dock_element_set_HoveredAnimation (PlankDockElement* self,
                                         PlankAnimationType value)
{
	PlankAnimationType old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_element_get_HoveredAnimation (self);
	if (old_value != value) {
		self->priv->_HoveredAnimation = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_element_properties[PLANK_DOCK_ELEMENT_HOVERED_ANIMATION_PROPERTY]);
	}
}

PlankAnimationType
plank_dock_element_get_ScrolledAnimation (PlankDockElement* self)
{
	PlankAnimationType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_ScrolledAnimation;
	return result;
}

void
plank_dock_element_set_ScrolledAnimation (PlankDockElement* self,
                                          PlankAnimationType value)
{
	PlankAnimationType old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_element_get_ScrolledAnimation (self);
	if (old_value != value) {
		self->priv->_ScrolledAnimation = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_element_properties[PLANK_DOCK_ELEMENT_SCROLLED_ANIMATION_PROPERTY]);
	}
}

gint64
plank_dock_element_get_AddTime (PlankDockElement* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_AddTime;
	return result;
}

void
plank_dock_element_set_AddTime (PlankDockElement* self,
                                gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_element_get_AddTime (self);
	if (old_value != value) {
		self->priv->_AddTime = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_element_properties[PLANK_DOCK_ELEMENT_ADD_TIME_PROPERTY]);
	}
}

gint64
plank_dock_element_get_RemoveTime (PlankDockElement* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_RemoveTime;
	return result;
}

void
plank_dock_element_set_RemoveTime (PlankDockElement* self,
                                   gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_element_get_RemoveTime (self);
	if (old_value != value) {
		self->priv->_RemoveTime = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_element_properties[PLANK_DOCK_ELEMENT_REMOVE_TIME_PROPERTY]);
	}
}

gint64
plank_dock_element_get_LastClicked (PlankDockElement* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_LastClicked;
	return result;
}

void
plank_dock_element_set_LastClicked (PlankDockElement* self,
                                    gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_element_get_LastClicked (self);
	if (old_value != value) {
		self->priv->_LastClicked = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_element_properties[PLANK_DOCK_ELEMENT_LAST_CLICKED_PROPERTY]);
	}
}

gint64
plank_dock_element_get_LastHovered (PlankDockElement* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_LastHovered;
	return result;
}

void
plank_dock_element_set_LastHovered (PlankDockElement* self,
                                    gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_element_get_LastHovered (self);
	if (old_value != value) {
		self->priv->_LastHovered = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_element_properties[PLANK_DOCK_ELEMENT_LAST_HOVERED_PROPERTY]);
	}
}

gint64
plank_dock_element_get_LastScrolled (PlankDockElement* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_LastScrolled;
	return result;
}

void
plank_dock_element_set_LastScrolled (PlankDockElement* self,
                                     gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_element_get_LastScrolled (self);
	if (old_value != value) {
		self->priv->_LastScrolled = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_element_properties[PLANK_DOCK_ELEMENT_LAST_SCROLLED_PROPERTY]);
	}
}

gint64
plank_dock_element_get_LastUrgent (PlankDockElement* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_LastUrgent;
	return result;
}

void
plank_dock_element_set_LastUrgent (PlankDockElement* self,
                                   gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_element_get_LastUrgent (self);
	if (old_value != value) {
		self->priv->_LastUrgent = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_element_properties[PLANK_DOCK_ELEMENT_LAST_URGENT_PROPERTY]);
	}
}

gint64
plank_dock_element_get_LastActive (PlankDockElement* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_LastActive;
	return result;
}

void
plank_dock_element_set_LastActive (PlankDockElement* self,
                                   gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_element_get_LastActive (self);
	if (old_value != value) {
		self->priv->_LastActive = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_element_properties[PLANK_DOCK_ELEMENT_LAST_ACTIVE_PROPERTY]);
	}
}

gint64
plank_dock_element_get_LastMove (PlankDockElement* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_LastMove;
	return result;
}

void
plank_dock_element_set_LastMove (PlankDockElement* self,
                                 gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_element_get_LastMove (self);
	if (old_value != value) {
		self->priv->_LastMove = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_element_properties[PLANK_DOCK_ELEMENT_LAST_MOVE_PROPERTY]);
	}
}

gint64
plank_dock_element_get_LastValid (PlankDockElement* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_LastValid;
	return result;
}

void
plank_dock_element_set_LastValid (PlankDockElement* self,
                                  gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_element_get_LastValid (self);
	if (old_value != value) {
		self->priv->_LastValid = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_element_properties[PLANK_DOCK_ELEMENT_LAST_VALID_PROPERTY]);
	}
}

static void
plank_dock_element_class_init (PlankDockElementClass * klass,
                               gpointer klass_data)
{
	plank_dock_element_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankDockElement_private_offset);
	((PlankDockElementClass *) klass)->on_clicked = (PlankAnimationType (*) (PlankDockElement*, PlankPopupButton, GdkModifierType, guint32)) plank_dock_element_real_on_clicked;
	((PlankDockElementClass *) klass)->on_hovered = (PlankAnimationType (*) (PlankDockElement*)) plank_dock_element_real_on_hovered;
	((PlankDockElementClass *) klass)->on_scrolled = (PlankAnimationType (*) (PlankDockElement*, GdkScrollDirection, GdkModifierType, guint32)) plank_dock_element_real_on_scrolled;
	((PlankDockElementClass *) klass)->get_menu_items = (GeeArrayList* (*) (PlankDockElement*)) plank_dock_element_real_get_menu_items;
	((PlankDockElementClass *) klass)->get_drop_text = (gchar* (*) (PlankDockElement*)) plank_dock_element_real_get_drop_text;
	((PlankDockElementClass *) klass)->can_be_removed = (gboolean (*) (PlankDockElement*)) plank_dock_element_real_can_be_removed;
	((PlankDockElementClass *) klass)->can_accept_drop = (gboolean (*) (PlankDockElement*, GeeArrayList*)) plank_dock_element_real_can_accept_drop;
	((PlankDockElementClass *) klass)->accept_drop = (gboolean (*) (PlankDockElement*, GeeArrayList*)) plank_dock_element_real_accept_drop;
	((PlankDockElementClass *) klass)->unique_id = (gchar* (*) (PlankDockElement*)) plank_dock_element_real_unique_id;
	((PlankDockElementClass *) klass)->reset_buffers = (void (*) (PlankDockElement*)) plank_dock_element_real_reset_buffers;
	G_OBJECT_CLASS (klass)->get_property = _vala_plank_dock_element_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_plank_dock_element_set_property;
	G_OBJECT_CLASS (klass)->finalize = plank_dock_element_finalize;
	/**
	 * The dock element's container which it is added too (if any).
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_ELEMENT_CONTAINER_PROPERTY, plank_dock_element_properties[PLANK_DOCK_ELEMENT_CONTAINER_PROPERTY] = g_param_spec_object ("Container", "Container", "Container", PLANK_TYPE_DOCK_CONTAINER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The dock item's text.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_ELEMENT_TEXT_PROPERTY, plank_dock_element_properties[PLANK_DOCK_ELEMENT_TEXT_PROPERTY] = g_param_spec_string ("Text", "Text", "Text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * Whether the item is currently hidden on the dock.
	 * If TRUE it will be drawn and does consume space.
	 * If FALSE it will not be drawn and does not consume space.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_ELEMENT_IS_ATTACHED_PROPERTY, plank_dock_element_properties[PLANK_DOCK_ELEMENT_IS_ATTACHED_PROPERTY] = g_param_spec_boolean ("IsAttached", "IsAttached", "IsAttached", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * Whether the item is currently visible on the dock.
	 * If TRUE it will be drawn and does consume space.
	 * If FALSE it will not be drawn and does consume space.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_ELEMENT_IS_VISIBLE_PROPERTY, plank_dock_element_properties[PLANK_DOCK_ELEMENT_IS_VISIBLE_PROPERTY] = g_param_spec_boolean ("IsVisible", "IsVisible", "IsVisible", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The buttons this item shows popup menus for.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_ELEMENT_BUTTON_PROPERTY, plank_dock_element_properties[PLANK_DOCK_ELEMENT_BUTTON_PROPERTY] = g_param_spec_flags ("Button", "Button", "Button", PLANK_TYPE_POPUP_BUTTON, PLANK_POPUP_BUTTON_RIGHT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The animation to show for the item's last click event.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_ELEMENT_CLICKED_ANIMATION_PROPERTY, plank_dock_element_properties[PLANK_DOCK_ELEMENT_CLICKED_ANIMATION_PROPERTY] = g_param_spec_enum ("ClickedAnimation", "ClickedAnimation", "ClickedAnimation", PLANK_TYPE_ANIMATION_TYPE, PLANK_ANIMATION_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The animation to show for the item's last hover event.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_ELEMENT_HOVERED_ANIMATION_PROPERTY, plank_dock_element_properties[PLANK_DOCK_ELEMENT_HOVERED_ANIMATION_PROPERTY] = g_param_spec_enum ("HoveredAnimation", "HoveredAnimation", "HoveredAnimation", PLANK_TYPE_ANIMATION_TYPE, PLANK_ANIMATION_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The animation to show for the item's last scroll event.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_ELEMENT_SCROLLED_ANIMATION_PROPERTY, plank_dock_element_properties[PLANK_DOCK_ELEMENT_SCROLLED_ANIMATION_PROPERTY] = g_param_spec_enum ("ScrolledAnimation", "ScrolledAnimation", "ScrolledAnimation", PLANK_TYPE_ANIMATION_TYPE, PLANK_ANIMATION_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The time the item was added to the dock.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_ELEMENT_ADD_TIME_PROPERTY, plank_dock_element_properties[PLANK_DOCK_ELEMENT_ADD_TIME_PROPERTY] = g_param_spec_int64 ("AddTime", "AddTime", "AddTime", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The time the item was removed from the dock.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_ELEMENT_REMOVE_TIME_PROPERTY, plank_dock_element_properties[PLANK_DOCK_ELEMENT_REMOVE_TIME_PROPERTY] = g_param_spec_int64 ("RemoveTime", "RemoveTime", "RemoveTime", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The last time the item was clicked.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_ELEMENT_LAST_CLICKED_PROPERTY, plank_dock_element_properties[PLANK_DOCK_ELEMENT_LAST_CLICKED_PROPERTY] = g_param_spec_int64 ("LastClicked", "LastClicked", "LastClicked", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The last time the item was hovered.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_ELEMENT_LAST_HOVERED_PROPERTY, plank_dock_element_properties[PLANK_DOCK_ELEMENT_LAST_HOVERED_PROPERTY] = g_param_spec_int64 ("LastHovered", "LastHovered", "LastHovered", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The last time the item was scrolled.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_ELEMENT_LAST_SCROLLED_PROPERTY, plank_dock_element_properties[PLANK_DOCK_ELEMENT_LAST_SCROLLED_PROPERTY] = g_param_spec_int64 ("LastScrolled", "LastScrolled", "LastScrolled", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The last time the item changed its urgent status.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_ELEMENT_LAST_URGENT_PROPERTY, plank_dock_element_properties[PLANK_DOCK_ELEMENT_LAST_URGENT_PROPERTY] = g_param_spec_int64 ("LastUrgent", "LastUrgent", "LastUrgent", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The last time the item changed its active status.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_ELEMENT_LAST_ACTIVE_PROPERTY, plank_dock_element_properties[PLANK_DOCK_ELEMENT_LAST_ACTIVE_PROPERTY] = g_param_spec_int64 ("LastActive", "LastActive", "LastActive", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The last time the item changed its position.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_ELEMENT_LAST_MOVE_PROPERTY, plank_dock_element_properties[PLANK_DOCK_ELEMENT_LAST_MOVE_PROPERTY] = g_param_spec_int64 ("LastMove", "LastMove", "LastMove", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The last time the item was valid.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_ELEMENT_LAST_VALID_PROPERTY, plank_dock_element_properties[PLANK_DOCK_ELEMENT_LAST_VALID_PROPERTY] = g_param_spec_int64 ("LastValid", "LastValid", "LastValid", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * Signal fired when the dock element needs redrawn.
	 */
	plank_dock_element_signals[PLANK_DOCK_ELEMENT_NEEDS_REDRAW_SIGNAL] = g_signal_new ("needs-redraw", PLANK_TYPE_DOCK_ELEMENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
plank_dock_element_instance_init (PlankDockElement * self,
                                  gpointer klass)
{
	gchar* _tmp0_;
	self->priv = plank_dock_element_get_instance_private (self);
	self->priv->_Container = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->_Text = _tmp0_;
	self->priv->_IsAttached = TRUE;
	self->priv->_IsVisible = TRUE;
	self->priv->_Button = PLANK_POPUP_BUTTON_RIGHT;
	self->priv->_ClickedAnimation = PLANK_ANIMATION_TYPE_NONE;
	self->priv->_HoveredAnimation = PLANK_ANIMATION_TYPE_NONE;
	self->priv->_ScrolledAnimation = PLANK_ANIMATION_TYPE_NONE;
}

static void
plank_dock_element_finalize (GObject * obj)
{
	PlankDockElement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_DOCK_ELEMENT, PlankDockElement);
	_g_object_unref0 (self->priv->_Container);
	_g_free0 (self->priv->_Text);
	G_OBJECT_CLASS (plank_dock_element_parent_class)->finalize (obj);
}

/**
 * The base class for all dock elements.
 */
static GType
plank_dock_element_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankDockElementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_dock_element_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankDockElement), 0, (GInstanceInitFunc) plank_dock_element_instance_init, NULL };
	GType plank_dock_element_type_id;
	plank_dock_element_type_id = g_type_register_static (G_TYPE_OBJECT, "PlankDockElement", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	PlankDockElement_private_offset = g_type_add_instance_private (plank_dock_element_type_id, sizeof (PlankDockElementPrivate));
	return plank_dock_element_type_id;
}

GType
plank_dock_element_get_type (void)
{
	static volatile gsize plank_dock_element_type_id__once = 0;
	if (g_once_init_enter (&plank_dock_element_type_id__once)) {
		GType plank_dock_element_type_id;
		plank_dock_element_type_id = plank_dock_element_get_type_once ();
		g_once_init_leave (&plank_dock_element_type_id__once, plank_dock_element_type_id);
	}
	return plank_dock_element_type_id__once;
}

static void
_vala_plank_dock_element_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	PlankDockElement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_DOCK_ELEMENT, PlankDockElement);
	switch (property_id) {
		case PLANK_DOCK_ELEMENT_CONTAINER_PROPERTY:
		g_value_set_object (value, plank_dock_element_get_Container (self));
		break;
		case PLANK_DOCK_ELEMENT_TEXT_PROPERTY:
		g_value_set_string (value, plank_dock_element_get_Text (self));
		break;
		case PLANK_DOCK_ELEMENT_IS_ATTACHED_PROPERTY:
		g_value_set_boolean (value, plank_dock_element_get_IsAttached (self));
		break;
		case PLANK_DOCK_ELEMENT_IS_VISIBLE_PROPERTY:
		g_value_set_boolean (value, plank_dock_element_get_IsVisible (self));
		break;
		case PLANK_DOCK_ELEMENT_BUTTON_PROPERTY:
		g_value_set_flags (value, plank_dock_element_get_Button (self));
		break;
		case PLANK_DOCK_ELEMENT_CLICKED_ANIMATION_PROPERTY:
		g_value_set_enum (value, plank_dock_element_get_ClickedAnimation (self));
		break;
		case PLANK_DOCK_ELEMENT_HOVERED_ANIMATION_PROPERTY:
		g_value_set_enum (value, plank_dock_element_get_HoveredAnimation (self));
		break;
		case PLANK_DOCK_ELEMENT_SCROLLED_ANIMATION_PROPERTY:
		g_value_set_enum (value, plank_dock_element_get_ScrolledAnimation (self));
		break;
		case PLANK_DOCK_ELEMENT_ADD_TIME_PROPERTY:
		g_value_set_int64 (value, plank_dock_element_get_AddTime (self));
		break;
		case PLANK_DOCK_ELEMENT_REMOVE_TIME_PROPERTY:
		g_value_set_int64 (value, plank_dock_element_get_RemoveTime (self));
		break;
		case PLANK_DOCK_ELEMENT_LAST_CLICKED_PROPERTY:
		g_value_set_int64 (value, plank_dock_element_get_LastClicked (self));
		break;
		case PLANK_DOCK_ELEMENT_LAST_HOVERED_PROPERTY:
		g_value_set_int64 (value, plank_dock_element_get_LastHovered (self));
		break;
		case PLANK_DOCK_ELEMENT_LAST_SCROLLED_PROPERTY:
		g_value_set_int64 (value, plank_dock_element_get_LastScrolled (self));
		break;
		case PLANK_DOCK_ELEMENT_LAST_URGENT_PROPERTY:
		g_value_set_int64 (value, plank_dock_element_get_LastUrgent (self));
		break;
		case PLANK_DOCK_ELEMENT_LAST_ACTIVE_PROPERTY:
		g_value_set_int64 (value, plank_dock_element_get_LastActive (self));
		break;
		case PLANK_DOCK_ELEMENT_LAST_MOVE_PROPERTY:
		g_value_set_int64 (value, plank_dock_element_get_LastMove (self));
		break;
		case PLANK_DOCK_ELEMENT_LAST_VALID_PROPERTY:
		g_value_set_int64 (value, plank_dock_element_get_LastValid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_plank_dock_element_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	PlankDockElement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_DOCK_ELEMENT, PlankDockElement);
	switch (property_id) {
		case PLANK_DOCK_ELEMENT_CONTAINER_PROPERTY:
		plank_dock_element_set_Container (self, g_value_get_object (value));
		break;
		case PLANK_DOCK_ELEMENT_TEXT_PROPERTY:
		plank_dock_element_set_Text (self, g_value_get_string (value));
		break;
		case PLANK_DOCK_ELEMENT_IS_ATTACHED_PROPERTY:
		plank_dock_element_set_IsAttached (self, g_value_get_boolean (value));
		break;
		case PLANK_DOCK_ELEMENT_IS_VISIBLE_PROPERTY:
		plank_dock_element_set_IsVisible (self, g_value_get_boolean (value));
		break;
		case PLANK_DOCK_ELEMENT_BUTTON_PROPERTY:
		plank_dock_element_set_Button (self, g_value_get_flags (value));
		break;
		case PLANK_DOCK_ELEMENT_CLICKED_ANIMATION_PROPERTY:
		plank_dock_element_set_ClickedAnimation (self, g_value_get_enum (value));
		break;
		case PLANK_DOCK_ELEMENT_HOVERED_ANIMATION_PROPERTY:
		plank_dock_element_set_HoveredAnimation (self, g_value_get_enum (value));
		break;
		case PLANK_DOCK_ELEMENT_SCROLLED_ANIMATION_PROPERTY:
		plank_dock_element_set_ScrolledAnimation (self, g_value_get_enum (value));
		break;
		case PLANK_DOCK_ELEMENT_ADD_TIME_PROPERTY:
		plank_dock_element_set_AddTime (self, g_value_get_int64 (value));
		break;
		case PLANK_DOCK_ELEMENT_REMOVE_TIME_PROPERTY:
		plank_dock_element_set_RemoveTime (self, g_value_get_int64 (value));
		break;
		case PLANK_DOCK_ELEMENT_LAST_CLICKED_PROPERTY:
		plank_dock_element_set_LastClicked (self, g_value_get_int64 (value));
		break;
		case PLANK_DOCK_ELEMENT_LAST_HOVERED_PROPERTY:
		plank_dock_element_set_LastHovered (self, g_value_get_int64 (value));
		break;
		case PLANK_DOCK_ELEMENT_LAST_SCROLLED_PROPERTY:
		plank_dock_element_set_LastScrolled (self, g_value_get_int64 (value));
		break;
		case PLANK_DOCK_ELEMENT_LAST_URGENT_PROPERTY:
		plank_dock_element_set_LastUrgent (self, g_value_get_int64 (value));
		break;
		case PLANK_DOCK_ELEMENT_LAST_ACTIVE_PROPERTY:
		plank_dock_element_set_LastActive (self, g_value_get_int64 (value));
		break;
		case PLANK_DOCK_ELEMENT_LAST_MOVE_PROPERTY:
		plank_dock_element_set_LastMove (self, g_value_get_int64 (value));
		break;
		case PLANK_DOCK_ELEMENT_LAST_VALID_PROPERTY:
		plank_dock_element_set_LastValid (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

