/* ClockDockItem.c generated by valac 0.56.17, the Vala compiler
 * generated from ClockDockItem.vala, do not modify */

/**/
/*  Copyright (C) 2011 Robert Dyer*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <plank.h>
#include <glib-object.h>
#include <pango/pango.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <cairo-gobject.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <pango/pangocairo.h>
#include <glib/gi18n-lib.h>

#define DOCKY_G_RESOURCE_PATH "/net/launchpad/plank/docklets/clock"
#define DOCKY_CLOCK_DOCK_ITEM_THEME_BASE_URI "resource://" DOCKY_G_RESOURCE_PATH "/themes/"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define DOCKY_TYPE_CLOCK_DOCK_ITEM (docky_clock_dock_item_get_type ())
#define DOCKY_CLOCK_DOCK_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DOCKY_TYPE_CLOCK_DOCK_ITEM, DockyClockDockItem))
#define DOCKY_CLOCK_DOCK_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DOCKY_TYPE_CLOCK_DOCK_ITEM, DockyClockDockItemClass))
#define DOCKY_IS_CLOCK_DOCK_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DOCKY_TYPE_CLOCK_DOCK_ITEM))
#define DOCKY_IS_CLOCK_DOCK_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DOCKY_TYPE_CLOCK_DOCK_ITEM))
#define DOCKY_CLOCK_DOCK_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DOCKY_TYPE_CLOCK_DOCK_ITEM, DockyClockDockItemClass))

typedef struct _DockyClockDockItem DockyClockDockItem;
typedef struct _DockyClockDockItemClass DockyClockDockItemClass;
typedef struct _DockyClockDockItemPrivate DockyClockDockItemPrivate;
enum  {
	DOCKY_CLOCK_DOCK_ITEM_0_PROPERTY,
	DOCKY_CLOCK_DOCK_ITEM_NUM_PROPERTIES
};
static GParamSpec* docky_clock_dock_item_properties[DOCKY_CLOCK_DOCK_ITEM_NUM_PROPERTIES];

#define DOCKY_TYPE_CLOCK_PREFERENCES (docky_clock_preferences_get_type ())
#define DOCKY_CLOCK_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DOCKY_TYPE_CLOCK_PREFERENCES, DockyClockPreferences))
#define DOCKY_CLOCK_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DOCKY_TYPE_CLOCK_PREFERENCES, DockyClockPreferencesClass))
#define DOCKY_IS_CLOCK_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DOCKY_TYPE_CLOCK_PREFERENCES))
#define DOCKY_IS_CLOCK_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DOCKY_TYPE_CLOCK_PREFERENCES))
#define DOCKY_CLOCK_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DOCKY_TYPE_CLOCK_PREFERENCES, DockyClockPreferencesClass))

typedef struct _DockyClockPreferences DockyClockPreferences;
typedef struct _DockyClockPreferencesClass DockyClockPreferencesClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))

struct _DockyClockDockItem {
	PlankDockletItem parent_instance;
	DockyClockDockItemPrivate * priv;
};

struct _DockyClockDockItemClass {
	PlankDockletItemClass parent_class;
};

struct _DockyClockDockItemPrivate {
	PangoLayout* layout;
	guint timer_id;
	gint minute;
	gchar* current_theme;
};

struct _Block1Data {
	int _ref_count_;
	DockyClockDockItem* self;
	DockyClockPreferences* prefs;
};

static gint DockyClockDockItem_private_offset;
static gpointer docky_clock_dock_item_parent_class = NULL;

VALA_EXTERN GType docky_clock_dock_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DockyClockDockItem, g_object_unref)
VALA_EXTERN GType docky_clock_preferences_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DockyClockPreferences, g_object_unref)
static void docky_clock_dock_item_handle_prefs_changed (DockyClockDockItem* self);
static void _docky_clock_dock_item_handle_prefs_changed_g_object_notify (GObject* _sender,
                                                                  GParamSpec* pspec,
                                                                  gpointer self);
VALA_EXTERN DockyClockDockItem* docky_clock_dock_item_new_with_dockitem_file (GFile* file);
VALA_EXTERN DockyClockDockItem* docky_clock_dock_item_construct_with_dockitem_file (GType object_type,
                                                                        GFile* file);
VALA_EXTERN DockyClockPreferences* docky_clock_preferences_new_with_file (GFile* file);
VALA_EXTERN DockyClockPreferences* docky_clock_preferences_construct_with_file (GType object_type,
                                                                    GFile* file);
static gboolean docky_clock_dock_item_update_timer (DockyClockDockItem* self);
VALA_EXTERN gboolean docky_clock_preferences_get_ShowMilitary (DockyClockPreferences* self);
static void docky_clock_dock_item_real_draw_icon (PlankDockItem* base,
                                           PlankSurface* surface);
VALA_EXTERN gboolean docky_clock_preferences_get_ShowDigital (DockyClockPreferences* self);
static void docky_clock_dock_item_render_digital_clock (DockyClockDockItem* self,
                                                 PlankSurface* surface,
                                                 GDateTime* now,
                                                 gint size);
static void docky_clock_dock_item_render_analog_clock (DockyClockDockItem* self,
                                                cairo_t* cr,
                                                GDateTime* now,
                                                gint size);
static void docky_clock_dock_item_render_file_onto_context (DockyClockDockItem* self,
                                                     cairo_t* cr,
                                                     const gchar* uri,
                                                     gint size);
VALA_EXTERN gboolean docky_clock_preferences_get_ShowDate (DockyClockPreferences* self);
static GeeArrayList* docky_clock_dock_item_real_get_menu_items (PlankDockElement* base);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda4_ (Block1Data* _data1_);
VALA_EXTERN void docky_clock_preferences_set_ShowDigital (DockyClockPreferences* self,
                                              gboolean value);
static void ___lambda4__gtk_menu_item_activate (GtkMenuItem* _sender,
                                         gpointer self);
static void __lambda5_ (Block1Data* _data1_);
VALA_EXTERN void docky_clock_preferences_set_ShowMilitary (DockyClockPreferences* self,
                                               gboolean value);
static void ___lambda5__gtk_menu_item_activate (GtkMenuItem* _sender,
                                         gpointer self);
static void __lambda6_ (Block1Data* _data1_);
VALA_EXTERN void docky_clock_preferences_set_ShowDate (DockyClockPreferences* self,
                                           gboolean value);
static void ___lambda6__gtk_menu_item_activate (GtkMenuItem* _sender,
                                         gpointer self);
VALA_EXTERN DockyClockDockItem* docky_clock_dock_item_new (void);
VALA_EXTERN DockyClockDockItem* docky_clock_dock_item_construct (GType object_type);
static GObject * docky_clock_dock_item_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static PangoFontDescription* _vala_PangoFontDescription_copy (PangoFontDescription* self);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static void docky_clock_dock_item_finalize (GObject * obj);
static GType docky_clock_dock_item_get_type_once (void);

static inline gpointer
docky_clock_dock_item_get_instance_private (DockyClockDockItem* self)
{
	return G_STRUCT_MEMBER_P (self, DockyClockDockItem_private_offset);
}

static void
_docky_clock_dock_item_handle_prefs_changed_g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self)
{
	docky_clock_dock_item_handle_prefs_changed ((DockyClockDockItem*) self);
}

/**
 * {@inheritDoc}
 */
DockyClockDockItem*
docky_clock_dock_item_construct_with_dockitem_file (GType object_type,
                                                    GFile* file)
{
	DockyClockDockItem * self = NULL;
	DockyClockPreferences* _tmp0_;
	DockyClockPreferences* _tmp1_;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = docky_clock_preferences_new_with_file (file);
	_tmp1_ = _tmp0_;
	self = (DockyClockDockItem*) g_object_new (object_type, "Prefs", _tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

DockyClockDockItem*
docky_clock_dock_item_new_with_dockitem_file (GFile* file)
{
	return docky_clock_dock_item_construct_with_dockitem_file (DOCKY_TYPE_CLOCK_DOCK_ITEM, file);
}

static gboolean
docky_clock_dock_item_update_timer (DockyClockDockItem* self)
{
	GDateTime* now = NULL;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_date_time_new_now_local ();
	now = _tmp0_;
	_tmp1_ = now;
	if (self->priv->minute != g_date_time_get_minute (_tmp1_)) {
		GDateTime* _tmp2_;
		plank_dock_item_reset_icon_buffer ((PlankDockItem*) self);
		_tmp2_ = now;
		self->priv->minute = g_date_time_get_minute (_tmp2_);
	}
	result = TRUE;
	_g_date_time_unref0 (now);
	return result;
}

static void
docky_clock_dock_item_handle_prefs_changed (DockyClockDockItem* self)
{
	DockyClockPreferences* prefs = NULL;
	PlankDockItemPreferences* _tmp0_;
	PlankDockItemPreferences* _tmp1_;
	const gchar* _tmp2_ = NULL;
	DockyClockPreferences* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = plank_dock_item_get_Prefs ((PlankDockItem*) self);
	_tmp1_ = _tmp0_;
	prefs = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, DOCKY_TYPE_CLOCK_PREFERENCES, DockyClockPreferences);
	_tmp3_ = prefs;
	_tmp4_ = docky_clock_preferences_get_ShowMilitary (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		_tmp2_ = DOCKY_CLOCK_DOCK_ITEM_THEME_BASE_URI "Default24";
	} else {
		_tmp2_ = DOCKY_CLOCK_DOCK_ITEM_THEME_BASE_URI "Default";
	}
	_tmp6_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->current_theme);
	self->priv->current_theme = _tmp6_;
	plank_dock_item_reset_icon_buffer ((PlankDockItem*) self);
}

static void
docky_clock_dock_item_real_draw_icon (PlankDockItem* base,
                                      PlankSurface* surface)
{
	DockyClockDockItem * self;
	DockyClockPreferences* prefs = NULL;
	PlankDockItemPreferences* _tmp0_;
	PlankDockItemPreferences* _tmp1_;
	GDateTime* now = NULL;
	GDateTime* _tmp2_;
	DockyClockPreferences* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gint size = 0;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	DockyClockPreferences* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	self = (DockyClockDockItem*) base;
	g_return_if_fail (surface != NULL);
	_tmp0_ = plank_dock_item_get_Prefs ((PlankDockItem*) self);
	_tmp1_ = _tmp0_;
	prefs = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, DOCKY_TYPE_CLOCK_PREFERENCES, DockyClockPreferences);
	_tmp2_ = g_date_time_new_now_local ();
	now = _tmp2_;
	_tmp3_ = prefs;
	_tmp4_ = docky_clock_preferences_get_ShowMilitary (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		GDateTime* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = now;
		_tmp7_ = g_date_time_format (_tmp6_, "%a, %b %d %H:%M");
		_tmp8_ = _tmp7_;
		plank_dock_element_set_Text ((PlankDockElement*) self, _tmp8_);
		_g_free0 (_tmp8_);
	} else {
		GDateTime* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp9_ = now;
		_tmp10_ = g_date_time_format (_tmp9_, "%a, %b %d %I:%M %p");
		_tmp11_ = _tmp10_;
		plank_dock_element_set_Text ((PlankDockElement*) self, _tmp11_);
		_g_free0 (_tmp11_);
	}
	_tmp12_ = plank_surface_get_Width (surface);
	_tmp13_ = _tmp12_;
	_tmp14_ = plank_surface_get_Height (surface);
	_tmp15_ = _tmp14_;
	size = MAX (_tmp13_, _tmp15_);
	_tmp16_ = prefs;
	_tmp17_ = docky_clock_preferences_get_ShowDigital (_tmp16_);
	_tmp18_ = _tmp17_;
	if (_tmp18_) {
		GDateTime* _tmp19_;
		_tmp19_ = now;
		docky_clock_dock_item_render_digital_clock (self, surface, _tmp19_, size);
	} else {
		cairo_t* _tmp20_;
		cairo_t* _tmp21_;
		GDateTime* _tmp22_;
		_tmp20_ = plank_surface_get_Context (surface);
		_tmp21_ = _tmp20_;
		_tmp22_ = now;
		docky_clock_dock_item_render_analog_clock (self, _tmp21_, _tmp22_, size);
	}
	_g_date_time_unref0 (now);
}

static void
docky_clock_dock_item_render_file_onto_context (DockyClockDockItem* self,
                                                cairo_t* cr,
                                                const gchar* uri,
                                                gint size)
{
	GdkPixbuf* pbuf = NULL;
	GdkPixbuf* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = plank_drawing_service_load_icon (uri, size, size);
	pbuf = _tmp0_;
	gdk_cairo_set_source_pixbuf (cr, pbuf, (gdouble) 0, (gdouble) 0);
	cairo_paint (cr);
	_g_object_unref0 (pbuf);
}

static gchar*
string_chug (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchug (_result_);
	result = _result_;
	return result;
}

static void
docky_clock_dock_item_render_digital_clock (DockyClockDockItem* self,
                                            PlankSurface* surface,
                                            GDateTime* now,
                                            gint size)
{
	DockyClockPreferences* prefs = NULL;
	PlankDockItemPreferences* _tmp0_;
	PlankDockItemPreferences* _tmp1_;
	cairo_t* cr = NULL;
	cairo_t* _tmp2_;
	cairo_t* _tmp3_;
	gint timeSize = 0;
	gint _tmp4_;
	gint _tmp5_;
	gint dateSize = 0;
	gint _tmp6_;
	gint _tmp7_;
	gint ampmSize = 0;
	gint _tmp8_;
	gint _tmp9_;
	gint spacing = 0;
	gint center = 0;
	gint _tmp10_;
	gint _tmp11_;
	PangoLayout* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	PangoLayout* _tmp15_;
	PangoFontDescription* _tmp16_;
	DockyClockPreferences* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	PangoRectangle ink_rect = {0};
	PangoRectangle logical_rect = {0};
	PangoLayout* _tmp28_;
	PangoRectangle _tmp29_ = {0};
	PangoRectangle _tmp30_ = {0};
	gint _tmp31_ = 0;
	DockyClockPreferences* _tmp32_;
	gboolean _tmp33_;
	gboolean _tmp34_;
	gint timeYOffset = 0;
	gint timeXOffset = 0;
	gint _tmp35_;
	gint _tmp36_;
	PangoRectangle _tmp37_;
	DockyClockPreferences* _tmp38_;
	gboolean _tmp39_;
	gboolean _tmp40_;
	cairo_t* _tmp43_;
	PangoLayout* _tmp44_;
	cairo_t* _tmp45_;
	cairo_t* _tmp46_;
	cairo_t* _tmp47_;
	cairo_t* _tmp48_;
	cairo_t* _tmp49_;
	DockyClockPreferences* _tmp50_;
	gboolean _tmp51_;
	gboolean _tmp52_;
	DockyClockPreferences* _tmp74_;
	gboolean _tmp75_;
	gboolean _tmp76_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (surface != NULL);
	g_return_if_fail (now != NULL);
	_tmp0_ = plank_dock_item_get_Prefs ((PlankDockItem*) self);
	_tmp1_ = _tmp0_;
	prefs = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, DOCKY_TYPE_CLOCK_PREFERENCES, DockyClockPreferences);
	_tmp2_ = plank_surface_get_Context (surface);
	_tmp3_ = _tmp2_;
	cr = _tmp3_;
	_tmp4_ = plank_surface_get_Height (surface);
	_tmp5_ = _tmp4_;
	timeSize = _tmp5_ / 4;
	_tmp6_ = plank_surface_get_Height (surface);
	_tmp7_ = _tmp6_;
	dateSize = _tmp7_ / 5;
	_tmp8_ = plank_surface_get_Height (surface);
	_tmp9_ = _tmp8_;
	ampmSize = _tmp9_ / 5;
	spacing = timeSize / 2;
	_tmp10_ = plank_surface_get_Height (surface);
	_tmp11_ = _tmp10_;
	center = _tmp11_ / 2;
	_tmp12_ = self->priv->layout;
	_tmp13_ = plank_surface_get_Width (surface);
	_tmp14_ = _tmp13_;
	pango_layout_set_width (_tmp12_, (gint) (_tmp14_ * PANGO_SCALE));
	_tmp15_ = self->priv->layout;
	_tmp16_ = pango_layout_get_font_description (_tmp15_);
	pango_font_description_set_absolute_size (_tmp16_, (gdouble) ((gint) (timeSize * PANGO_SCALE)));
	_tmp17_ = prefs;
	_tmp18_ = docky_clock_preferences_get_ShowMilitary (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_) {
		PangoLayout* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp20_ = self->priv->layout;
		_tmp21_ = g_date_time_format (now, "%H:%M");
		_tmp22_ = _tmp21_;
		pango_layout_set_text (_tmp20_, _tmp22_, -1);
		_g_free0 (_tmp22_);
	} else {
		PangoLayout* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		_tmp23_ = self->priv->layout;
		_tmp24_ = g_date_time_format (now, "%l:%M");
		_tmp25_ = _tmp24_;
		_tmp26_ = string_chug (_tmp25_);
		_tmp27_ = _tmp26_;
		pango_layout_set_text (_tmp23_, _tmp27_, -1);
		_g_free0 (_tmp27_);
		_g_free0 (_tmp25_);
	}
	_tmp28_ = self->priv->layout;
	pango_layout_get_pixel_extents (_tmp28_, &_tmp29_, &_tmp30_);
	ink_rect = _tmp29_;
	logical_rect = _tmp30_;
	_tmp32_ = prefs;
	_tmp33_ = docky_clock_preferences_get_ShowMilitary (_tmp32_);
	_tmp34_ = _tmp33_;
	if (_tmp34_) {
		_tmp31_ = timeSize;
	} else {
		_tmp31_ = timeSize / 2;
	}
	timeYOffset = _tmp31_;
	_tmp35_ = plank_surface_get_Width (surface);
	_tmp36_ = _tmp35_;
	_tmp37_ = ink_rect;
	timeXOffset = (_tmp36_ - _tmp37_.width) / 2;
	_tmp38_ = prefs;
	_tmp39_ = docky_clock_preferences_get_ShowDate (_tmp38_);
	_tmp40_ = _tmp39_;
	if (_tmp40_) {
		cairo_t* _tmp41_;
		_tmp41_ = cr;
		cairo_move_to (_tmp41_, (gdouble) timeXOffset, (gdouble) timeYOffset);
	} else {
		cairo_t* _tmp42_;
		_tmp42_ = cr;
		cairo_move_to (_tmp42_, (gdouble) timeXOffset, (gdouble) (timeYOffset + (timeSize / 2)));
	}
	_tmp43_ = cr;
	_tmp44_ = self->priv->layout;
	pango_cairo_layout_path (_tmp43_, _tmp44_);
	_tmp45_ = cr;
	cairo_set_line_width (_tmp45_, (gdouble) 3);
	_tmp46_ = cr;
	cairo_set_source_rgba (_tmp46_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.5);
	_tmp47_ = cr;
	cairo_stroke_preserve (_tmp47_);
	_tmp48_ = cr;
	cairo_set_source_rgba (_tmp48_, (gdouble) 1, (gdouble) 1, (gdouble) 1, 0.8);
	_tmp49_ = cr;
	cairo_fill (_tmp49_);
	_tmp50_ = prefs;
	_tmp51_ = docky_clock_preferences_get_ShowDate (_tmp50_);
	_tmp52_ = _tmp51_;
	if (_tmp52_) {
		PangoLayout* _tmp53_;
		PangoFontDescription* _tmp54_;
		PangoLayout* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		PangoLayout* _tmp58_;
		PangoRectangle _tmp59_ = {0};
		PangoRectangle _tmp60_ = {0};
		cairo_t* _tmp61_;
		gint _tmp62_;
		gint _tmp63_;
		PangoRectangle _tmp64_;
		gint _tmp65_;
		gint _tmp66_;
		cairo_t* _tmp67_;
		PangoLayout* _tmp68_;
		cairo_t* _tmp69_;
		cairo_t* _tmp70_;
		cairo_t* _tmp71_;
		cairo_t* _tmp72_;
		cairo_t* _tmp73_;
		_tmp53_ = self->priv->layout;
		_tmp54_ = pango_layout_get_font_description (_tmp53_);
		pango_font_description_set_absolute_size (_tmp54_, (gdouble) ((gint) (dateSize * PANGO_SCALE)));
		_tmp55_ = self->priv->layout;
		_tmp56_ = g_date_time_format (now, "%b %d");
		_tmp57_ = _tmp56_;
		pango_layout_set_text (_tmp55_, _tmp57_, -1);
		_g_free0 (_tmp57_);
		_tmp58_ = self->priv->layout;
		pango_layout_get_pixel_extents (_tmp58_, &_tmp59_, &_tmp60_);
		ink_rect = _tmp59_;
		logical_rect = _tmp60_;
		_tmp61_ = cr;
		_tmp62_ = plank_surface_get_Width (surface);
		_tmp63_ = _tmp62_;
		_tmp64_ = ink_rect;
		_tmp65_ = plank_surface_get_Height (surface);
		_tmp66_ = _tmp65_;
		cairo_move_to (_tmp61_, (gdouble) ((_tmp63_ - _tmp64_.width) / 2), (gdouble) ((_tmp66_ - spacing) - dateSize));
		_tmp67_ = cr;
		_tmp68_ = self->priv->layout;
		pango_cairo_layout_path (_tmp67_, _tmp68_);
		_tmp69_ = cr;
		cairo_set_line_width (_tmp69_, 2.5);
		_tmp70_ = cr;
		cairo_set_source_rgba (_tmp70_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.5);
		_tmp71_ = cr;
		cairo_stroke_preserve (_tmp71_);
		_tmp72_ = cr;
		cairo_set_source_rgba (_tmp72_, (gdouble) 1, (gdouble) 1, (gdouble) 1, 0.8);
		_tmp73_ = cr;
		cairo_fill (_tmp73_);
	}
	_tmp74_ = prefs;
	_tmp75_ = docky_clock_preferences_get_ShowMilitary (_tmp74_);
	_tmp76_ = _tmp75_;
	if (!_tmp76_) {
		PangoLayout* _tmp77_;
		PangoFontDescription* _tmp78_;
		gint _tmp79_ = 0;
		DockyClockPreferences* _tmp80_;
		gboolean _tmp81_;
		gboolean _tmp82_;
		gint yOffset = 0;
		PangoLayout* _tmp85_;
		PangoLayout* _tmp86_;
		PangoRectangle _tmp87_ = {0};
		PangoRectangle _tmp88_ = {0};
		cairo_t* _tmp89_;
		PangoRectangle _tmp90_;
		cairo_t* _tmp91_;
		PangoLayout* _tmp92_;
		cairo_t* _tmp93_;
		cairo_t* _tmp96_;
		cairo_t* _tmp99_;
		PangoLayout* _tmp100_;
		PangoLayout* _tmp101_;
		PangoRectangle _tmp102_ = {0};
		PangoRectangle _tmp103_ = {0};
		cairo_t* _tmp104_;
		PangoRectangle _tmp105_;
		cairo_t* _tmp106_;
		PangoLayout* _tmp107_;
		cairo_t* _tmp108_;
		cairo_t* _tmp111_;
		cairo_t* _tmp114_;
		_tmp77_ = self->priv->layout;
		_tmp78_ = pango_layout_get_font_description (_tmp77_);
		pango_font_description_set_absolute_size (_tmp78_, (gdouble) ((gint) (ampmSize * PANGO_SCALE)));
		_tmp80_ = prefs;
		_tmp81_ = docky_clock_preferences_get_ShowDate (_tmp80_);
		_tmp82_ = _tmp81_;
		if (_tmp82_) {
			_tmp79_ = center - spacing;
		} else {
			gint _tmp83_;
			gint _tmp84_;
			_tmp83_ = plank_surface_get_Height (surface);
			_tmp84_ = _tmp83_;
			_tmp79_ = (_tmp84_ - spacing) - ampmSize;
		}
		yOffset = _tmp79_;
		_tmp85_ = self->priv->layout;
		pango_layout_set_text (_tmp85_, "am", -1);
		_tmp86_ = self->priv->layout;
		pango_layout_get_pixel_extents (_tmp86_, &_tmp87_, &_tmp88_);
		ink_rect = _tmp87_;
		logical_rect = _tmp88_;
		_tmp89_ = cr;
		_tmp90_ = ink_rect;
		cairo_move_to (_tmp89_, (gdouble) ((center - _tmp90_.width) / 2), (gdouble) yOffset);
		_tmp91_ = cr;
		_tmp92_ = self->priv->layout;
		pango_cairo_layout_path (_tmp91_, _tmp92_);
		_tmp93_ = cr;
		cairo_set_line_width (_tmp93_, (gdouble) 2);
		if (g_date_time_get_hour (now) < 12) {
			cairo_t* _tmp94_;
			_tmp94_ = cr;
			cairo_set_source_rgba (_tmp94_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.5);
		} else {
			cairo_t* _tmp95_;
			_tmp95_ = cr;
			cairo_set_source_rgba (_tmp95_, (gdouble) 1, (gdouble) 1, (gdouble) 1, 0.4);
		}
		_tmp96_ = cr;
		cairo_stroke_preserve (_tmp96_);
		if (g_date_time_get_hour (now) < 12) {
			cairo_t* _tmp97_;
			_tmp97_ = cr;
			cairo_set_source_rgba (_tmp97_, (gdouble) 1, (gdouble) 1, (gdouble) 1, 0.8);
		} else {
			cairo_t* _tmp98_;
			_tmp98_ = cr;
			cairo_set_source_rgba (_tmp98_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.5);
		}
		_tmp99_ = cr;
		cairo_fill (_tmp99_);
		_tmp100_ = self->priv->layout;
		pango_layout_set_text (_tmp100_, "pm", -1);
		_tmp101_ = self->priv->layout;
		pango_layout_get_pixel_extents (_tmp101_, &_tmp102_, &_tmp103_);
		ink_rect = _tmp102_;
		logical_rect = _tmp103_;
		_tmp104_ = cr;
		_tmp105_ = ink_rect;
		cairo_move_to (_tmp104_, (gdouble) (center + ((center - _tmp105_.width) / 2)), (gdouble) yOffset);
		_tmp106_ = cr;
		_tmp107_ = self->priv->layout;
		pango_cairo_layout_path (_tmp106_, _tmp107_);
		_tmp108_ = cr;
		cairo_set_line_width (_tmp108_, (gdouble) 2);
		if (g_date_time_get_hour (now) < 12) {
			cairo_t* _tmp109_;
			_tmp109_ = cr;
			cairo_set_source_rgba (_tmp109_, (gdouble) 1, (gdouble) 1, (gdouble) 1, 0.4);
		} else {
			cairo_t* _tmp110_;
			_tmp110_ = cr;
			cairo_set_source_rgba (_tmp110_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.5);
		}
		_tmp111_ = cr;
		cairo_stroke_preserve (_tmp111_);
		if (g_date_time_get_hour (now) < 12) {
			cairo_t* _tmp112_;
			_tmp112_ = cr;
			cairo_set_source_rgba (_tmp112_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.5);
		} else {
			cairo_t* _tmp113_;
			_tmp113_ = cr;
			cairo_set_source_rgba (_tmp113_, (gdouble) 1, (gdouble) 1, (gdouble) 1, 0.8);
		}
		_tmp114_ = cr;
		cairo_fill (_tmp114_);
	}
}

static void
docky_clock_dock_item_render_analog_clock (DockyClockDockItem* self,
                                           cairo_t* cr,
                                           GDateTime* now,
                                           gint size)
{
	gint center = 0;
	gint radius = 0;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gdouble minuteRotation = 0.0;
	gint _tmp12_ = 0;
	const gchar* _tmp13_;
	gint total_hours = 0;
	gdouble hourRotation = 0.0;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (now != NULL);
	center = size / 2;
	radius = center;
	_tmp0_ = self->priv->current_theme;
	_tmp1_ = g_strconcat (_tmp0_, "/clock-drop-shadow.svg", NULL);
	_tmp2_ = _tmp1_;
	docky_clock_dock_item_render_file_onto_context (self, cr, _tmp2_, radius * 2);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->current_theme;
	_tmp4_ = g_strconcat (_tmp3_, "/clock-face-shadow.svg", NULL);
	_tmp5_ = _tmp4_;
	docky_clock_dock_item_render_file_onto_context (self, cr, _tmp5_, radius * 2);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->current_theme;
	_tmp7_ = g_strconcat (_tmp6_, "/clock-face.svg", NULL);
	_tmp8_ = _tmp7_;
	docky_clock_dock_item_render_file_onto_context (self, cr, _tmp8_, radius * 2);
	_g_free0 (_tmp8_);
	_tmp9_ = self->priv->current_theme;
	_tmp10_ = g_strconcat (_tmp9_, "/clock-marks.svg", NULL);
	_tmp11_ = _tmp10_;
	docky_clock_dock_item_render_file_onto_context (self, cr, _tmp11_, radius * 2);
	_g_free0 (_tmp11_);
	cairo_translate (cr, (gdouble) center, (gdouble) center);
	cairo_set_source_rgba (cr, 0.15, 0.15, 0.15, (gdouble) 1);
	cairo_set_line_width (cr, MAX (1.0, size / 48.0));
	cairo_set_line_cap (cr, CAIRO_LINE_CAP_ROUND);
	minuteRotation = G_PI * ((g_date_time_get_minute (now) / 30.0) + 1.0);
	cairo_rotate (cr, minuteRotation);
	cairo_move_to (cr, (gdouble) 0, radius - (radius * 0.35));
	cairo_line_to (cr, (gdouble) 0, 0 - (radius * 0.15));
	cairo_stroke (cr);
	cairo_rotate (cr, 0 - minuteRotation);
	cairo_set_source_rgba (cr, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	_tmp13_ = self->priv->current_theme;
	if (g_str_has_suffix (_tmp13_, "24")) {
		_tmp12_ = 24;
	} else {
		_tmp12_ = 12;
	}
	total_hours = _tmp12_;
	hourRotation = G_PI * ((((g_date_time_get_hour (now) % total_hours) / (total_hours / 2.0)) + (g_date_time_get_minute (now) / (30.0 * total_hours))) + 1.0);
	cairo_rotate (cr, hourRotation);
	cairo_move_to (cr, (gdouble) 0, radius - (radius * 0.5));
	cairo_line_to (cr, (gdouble) 0, 0 - (radius * 0.15));
	cairo_stroke (cr);
	cairo_rotate (cr, 0 - hourRotation);
	cairo_translate (cr, (gdouble) (0 - center), (gdouble) (0 - center));
	_tmp14_ = self->priv->current_theme;
	_tmp15_ = g_strconcat (_tmp14_, "/clock-glass.svg", NULL);
	_tmp16_ = _tmp15_;
	docky_clock_dock_item_render_file_onto_context (self, cr, _tmp16_, radius * 2);
	_g_free0 (_tmp16_);
	_tmp17_ = self->priv->current_theme;
	_tmp18_ = g_strconcat (_tmp17_, "/clock-frame.svg", NULL);
	_tmp19_ = _tmp18_;
	docky_clock_dock_item_render_file_onto_context (self, cr, _tmp19_, radius * 2);
	_g_free0 (_tmp19_);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		DockyClockDockItem* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda4_ (Block1Data* _data1_)
{
	DockyClockDockItem* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data1_->self;
	_tmp0_ = docky_clock_preferences_get_ShowDigital (_data1_->prefs);
	_tmp1_ = _tmp0_;
	docky_clock_preferences_set_ShowDigital (_data1_->prefs, !_tmp1_);
}

static void
___lambda4__gtk_menu_item_activate (GtkMenuItem* _sender,
                                    gpointer self)
{
	__lambda4_ (self);
}

static void
__lambda5_ (Block1Data* _data1_)
{
	DockyClockDockItem* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data1_->self;
	_tmp0_ = docky_clock_preferences_get_ShowMilitary (_data1_->prefs);
	_tmp1_ = _tmp0_;
	docky_clock_preferences_set_ShowMilitary (_data1_->prefs, !_tmp1_);
}

static void
___lambda5__gtk_menu_item_activate (GtkMenuItem* _sender,
                                    gpointer self)
{
	__lambda5_ (self);
}

static void
__lambda6_ (Block1Data* _data1_)
{
	DockyClockDockItem* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data1_->self;
	_tmp0_ = docky_clock_preferences_get_ShowDate (_data1_->prefs);
	_tmp1_ = _tmp0_;
	docky_clock_preferences_set_ShowDate (_data1_->prefs, !_tmp1_);
}

static void
___lambda6__gtk_menu_item_activate (GtkMenuItem* _sender,
                                    gpointer self)
{
	__lambda6_ (self);
}

static GeeArrayList*
docky_clock_dock_item_real_get_menu_items (PlankDockElement* base)
{
	DockyClockDockItem * self;
	Block1Data* _data1_;
	PlankDockItemPreferences* _tmp0_;
	PlankDockItemPreferences* _tmp1_;
	GeeArrayList* items = NULL;
	GeeArrayList* _tmp2_;
	GtkCheckMenuItem* checked_item = NULL;
	GtkCheckMenuItem* _tmp3_;
	GtkCheckMenuItem* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GtkCheckMenuItem* _tmp7_;
	GtkCheckMenuItem* _tmp8_;
	GtkCheckMenuItem* _tmp9_;
	GtkCheckMenuItem* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	GtkCheckMenuItem* _tmp13_;
	GtkCheckMenuItem* _tmp14_;
	GtkCheckMenuItem* _tmp15_;
	GtkCheckMenuItem* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	GtkCheckMenuItem* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	GtkCheckMenuItem* _tmp22_;
	GtkCheckMenuItem* _tmp23_;
	GeeArrayList* result;
	self = (DockyClockDockItem*) base;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = plank_dock_item_get_Prefs ((PlankDockItem*) self);
	_tmp1_ = _tmp0_;
	_data1_->prefs = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, DOCKY_TYPE_CLOCK_PREFERENCES, DockyClockPreferences);
	_tmp2_ = gee_array_list_new (gtk_menu_item_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	items = _tmp2_;
	_tmp3_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_mnemonic (_ ("Di_gital Clock"));
	g_object_ref_sink (_tmp3_);
	checked_item = _tmp3_;
	_tmp4_ = checked_item;
	_tmp5_ = docky_clock_preferences_get_ShowDigital (_data1_->prefs);
	_tmp6_ = _tmp5_;
	gtk_check_menu_item_set_active (_tmp4_, _tmp6_);
	_tmp7_ = checked_item;
	g_signal_connect_data ((GtkMenuItem*) _tmp7_, "activate", (GCallback) ___lambda4__gtk_menu_item_activate, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp8_ = checked_item;
	gee_abstract_collection_add ((GeeAbstractCollection*) items, (GtkMenuItem*) _tmp8_);
	_tmp9_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_mnemonic (_ ("24-Hour _Clock"));
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (checked_item);
	checked_item = _tmp9_;
	_tmp10_ = checked_item;
	_tmp11_ = docky_clock_preferences_get_ShowMilitary (_data1_->prefs);
	_tmp12_ = _tmp11_;
	gtk_check_menu_item_set_active (_tmp10_, _tmp12_);
	_tmp13_ = checked_item;
	g_signal_connect_data ((GtkMenuItem*) _tmp13_, "activate", (GCallback) ___lambda5__gtk_menu_item_activate, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp14_ = checked_item;
	gee_abstract_collection_add ((GeeAbstractCollection*) items, (GtkMenuItem*) _tmp14_);
	_tmp15_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_mnemonic (_ ("Show _Date"));
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (checked_item);
	checked_item = _tmp15_;
	_tmp16_ = checked_item;
	_tmp17_ = docky_clock_preferences_get_ShowDate (_data1_->prefs);
	_tmp18_ = _tmp17_;
	gtk_check_menu_item_set_active (_tmp16_, _tmp18_);
	_tmp19_ = checked_item;
	_tmp20_ = docky_clock_preferences_get_ShowDigital (_data1_->prefs);
	_tmp21_ = _tmp20_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp19_, _tmp21_);
	_tmp22_ = checked_item;
	g_signal_connect_data ((GtkMenuItem*) _tmp22_, "activate", (GCallback) ___lambda6__gtk_menu_item_activate, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp23_ = checked_item;
	gee_abstract_collection_add ((GeeAbstractCollection*) items, (GtkMenuItem*) _tmp23_);
	result = items;
	_g_object_unref0 (checked_item);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

DockyClockDockItem*
docky_clock_dock_item_construct (GType object_type)
{
	DockyClockDockItem * self = NULL;
	self = (DockyClockDockItem*) plank_docklet_item_construct (object_type);
	return self;
}

DockyClockDockItem*
docky_clock_dock_item_new (void)
{
	return docky_clock_dock_item_construct (DOCKY_TYPE_CLOCK_DOCK_ITEM);
}

static PangoFontDescription*
_vala_PangoFontDescription_copy (PangoFontDescription* self)
{
	return g_boxed_copy (pango_font_description_get_type (), self);
}

static gpointer
__vala_PangoFontDescription_copy0 (gpointer self)
{
	return self ? _vala_PangoFontDescription_copy (self) : NULL;
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static GObject *
docky_clock_dock_item_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DockyClockDockItem * self;
	PangoContext* _tmp0_;
	PangoContext* _tmp1_;
	PangoLayout* _tmp2_;
	PangoFontDescription* font_description = NULL;
	GtkStyle* _tmp3_;
	GtkStyle* _tmp4_;
	PangoFontDescription* _tmp5_;
	PangoFontDescription* _tmp6_;
	PangoFontDescription* _tmp7_;
	PangoFontDescription* _tmp8_;
	PangoLayout* _tmp9_;
	PangoFontDescription* _tmp10_;
	PangoLayout* _tmp11_;
	DockyClockPreferences* prefs = NULL;
	PlankDockItemPreferences* _tmp12_;
	PlankDockItemPreferences* _tmp13_;
	DockyClockPreferences* _tmp14_;
	DockyClockPreferences* _tmp15_;
	DockyClockPreferences* _tmp16_;
	const gchar* _tmp17_ = NULL;
	DockyClockPreferences* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	gchar* _tmp21_;
	parent_class = G_OBJECT_CLASS (docky_clock_dock_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DOCKY_TYPE_CLOCK_DOCK_ITEM, DockyClockDockItem);
	_tmp0_ = gdk_pango_context_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = pango_layout_new (_tmp1_);
	_g_object_unref0 (self->priv->layout);
	self->priv->layout = _tmp2_;
	_g_object_unref0 (_tmp1_);
	_tmp3_ = gtk_style_new ();
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_->font_desc;
	_tmp6_ = __vala_PangoFontDescription_copy0 (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp4_);
	font_description = _tmp7_;
	_tmp8_ = font_description;
	pango_font_description_set_weight (_tmp8_, PANGO_WEIGHT_BOLD);
	_tmp9_ = self->priv->layout;
	_tmp10_ = font_description;
	pango_layout_set_font_description (_tmp9_, _tmp10_);
	_tmp11_ = self->priv->layout;
	pango_layout_set_ellipsize (_tmp11_, PANGO_ELLIPSIZE_NONE);
	plank_dock_item_set_Icon ((PlankDockItem*) self, "clock");
	plank_dock_element_set_Text ((PlankDockElement*) self, "time");
	_tmp12_ = plank_dock_item_get_Prefs ((PlankDockItem*) self);
	_tmp13_ = _tmp12_;
	prefs = G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, DOCKY_TYPE_CLOCK_PREFERENCES, DockyClockPreferences);
	_tmp14_ = prefs;
	g_signal_connect_object ((GObject*) _tmp14_, "notify::ShowMilitary", (GCallback) _docky_clock_dock_item_handle_prefs_changed_g_object_notify, self, 0);
	_tmp15_ = prefs;
	g_signal_connect_object ((GObject*) _tmp15_, "notify::ShowDate", (GCallback) _docky_clock_dock_item_handle_prefs_changed_g_object_notify, self, 0);
	_tmp16_ = prefs;
	g_signal_connect_object ((GObject*) _tmp16_, "notify::ShowDigital", (GCallback) _docky_clock_dock_item_handle_prefs_changed_g_object_notify, self, 0);
	self->priv->timer_id = gdk_threads_add_timeout ((guint) 1000, (GSourceFunc) docky_clock_dock_item_update_timer, self);
	_tmp18_ = prefs;
	_tmp19_ = docky_clock_preferences_get_ShowMilitary (_tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_) {
		_tmp17_ = DOCKY_CLOCK_DOCK_ITEM_THEME_BASE_URI "Default24";
	} else {
		_tmp17_ = DOCKY_CLOCK_DOCK_ITEM_THEME_BASE_URI "Default";
	}
	_tmp21_ = g_strdup (_tmp17_);
	_g_free0 (self->priv->current_theme);
	self->priv->current_theme = _tmp21_;
	__vala_PangoFontDescription_free0 (font_description);
	return obj;
}

static void
docky_clock_dock_item_class_init (DockyClockDockItemClass * klass,
                                  gpointer klass_data)
{
	docky_clock_dock_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DockyClockDockItem_private_offset);
	((PlankDockItemClass *) klass)->draw_icon = (void (*) (PlankDockItem*, PlankSurface*)) docky_clock_dock_item_real_draw_icon;
	((PlankDockElementClass *) klass)->get_menu_items = (GeeArrayList* (*) (PlankDockElement*)) docky_clock_dock_item_real_get_menu_items;
	G_OBJECT_CLASS (klass)->constructor = docky_clock_dock_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = docky_clock_dock_item_finalize;
}

static void
docky_clock_dock_item_instance_init (DockyClockDockItem * self,
                                     gpointer klass)
{
	self->priv = docky_clock_dock_item_get_instance_private (self);
	self->priv->timer_id = 0U;
}

static void
docky_clock_dock_item_finalize (GObject * obj)
{
	DockyClockDockItem * self;
	DockyClockPreferences* prefs = NULL;
	PlankDockItemPreferences* _tmp0_;
	PlankDockItemPreferences* _tmp1_;
	DockyClockPreferences* _tmp2_;
	guint _tmp3_;
	GQuark _tmp4_;
	DockyClockPreferences* _tmp5_;
	guint _tmp6_;
	GQuark _tmp7_;
	DockyClockPreferences* _tmp8_;
	guint _tmp9_;
	GQuark _tmp10_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DOCKY_TYPE_CLOCK_DOCK_ITEM, DockyClockDockItem);
	if (self->priv->timer_id > 0U) {
		g_source_remove (self->priv->timer_id);
	}
	_tmp0_ = plank_dock_item_get_Prefs ((PlankDockItem*) self);
	_tmp1_ = _tmp0_;
	prefs = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, DOCKY_TYPE_CLOCK_PREFERENCES, DockyClockPreferences);
	_tmp2_ = prefs;
	g_signal_parse_name ("notify::ShowMilitary", G_TYPE_OBJECT, &_tmp3_, &_tmp4_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, _tmp4_, NULL, (GCallback) _docky_clock_dock_item_handle_prefs_changed_g_object_notify, self);
	_tmp5_ = prefs;
	g_signal_parse_name ("notify::ShowDate", G_TYPE_OBJECT, &_tmp6_, &_tmp7_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, _tmp7_, NULL, (GCallback) _docky_clock_dock_item_handle_prefs_changed_g_object_notify, self);
	_tmp8_ = prefs;
	g_signal_parse_name ("notify::ShowDigital", G_TYPE_OBJECT, &_tmp9_, &_tmp10_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, _tmp10_, NULL, (GCallback) _docky_clock_dock_item_handle_prefs_changed_g_object_notify, self);
	_g_object_unref0 (self->priv->layout);
	_g_free0 (self->priv->current_theme);
	G_OBJECT_CLASS (docky_clock_dock_item_parent_class)->finalize (obj);
}

static GType
docky_clock_dock_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DockyClockDockItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) docky_clock_dock_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DockyClockDockItem), 0, (GInstanceInitFunc) docky_clock_dock_item_instance_init, NULL };
	GType docky_clock_dock_item_type_id;
	docky_clock_dock_item_type_id = g_type_register_static (PLANK_TYPE_DOCKLET_ITEM, "DockyClockDockItem", &g_define_type_info, 0);
	DockyClockDockItem_private_offset = g_type_add_instance_private (docky_clock_dock_item_type_id, sizeof (DockyClockDockItemPrivate));
	return docky_clock_dock_item_type_id;
}

GType
docky_clock_dock_item_get_type (void)
{
	static volatile gsize docky_clock_dock_item_type_id__once = 0;
	if (g_once_init_enter (&docky_clock_dock_item_type_id__once)) {
		GType docky_clock_dock_item_type_id;
		docky_clock_dock_item_type_id = docky_clock_dock_item_get_type_once ();
		g_once_init_leave (&docky_clock_dock_item_type_id__once, docky_clock_dock_item_type_id);
	}
	return docky_clock_dock_item_type_id__once;
}

