/* cache.c generated by valac 0.56.17, the Vala compiler
 * generated from cache.vala, do not modify */

#include <glib-object.h>
#include <gee.h>
#include <glib.h>
#include <cairo-gobject.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PDFPC_RENDERER_TYPE_CACHE (pdfpc_renderer_cache_get_type ())
#define PDFPC_RENDERER_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_RENDERER_TYPE_CACHE, pdfpcRendererCache))
#define PDFPC_RENDERER_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_RENDERER_TYPE_CACHE, pdfpcRendererCacheClass))
#define PDFPC_RENDERER_IS_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_RENDERER_TYPE_CACHE))
#define PDFPC_RENDERER_IS_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_RENDERER_TYPE_CACHE))
#define PDFPC_RENDERER_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_RENDERER_TYPE_CACHE, pdfpcRendererCacheClass))

typedef struct _pdfpcRendererCache pdfpcRendererCache;
typedef struct _pdfpcRendererCacheClass pdfpcRendererCacheClass;
typedef struct _pdfpcRendererCachePrivate pdfpcRendererCachePrivate;

#define PDFPC_RENDERER_TYPE_CACHED_PAGE_PROPS (pdfpc_renderer_cached_page_props_get_type ())
#define PDFPC_RENDERER_CACHED_PAGE_PROPS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_RENDERER_TYPE_CACHED_PAGE_PROPS, pdfpcRendererCachedPageProps))
#define PDFPC_RENDERER_CACHED_PAGE_PROPS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_RENDERER_TYPE_CACHED_PAGE_PROPS, pdfpcRendererCachedPagePropsClass))
#define PDFPC_RENDERER_IS_CACHED_PAGE_PROPS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_RENDERER_TYPE_CACHED_PAGE_PROPS))
#define PDFPC_RENDERER_IS_CACHED_PAGE_PROPS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_RENDERER_TYPE_CACHED_PAGE_PROPS))
#define PDFPC_RENDERER_CACHED_PAGE_PROPS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_RENDERER_TYPE_CACHED_PAGE_PROPS, pdfpcRendererCachedPagePropsClass))

typedef struct _pdfpcRendererCachedPageProps pdfpcRendererCachedPageProps;
typedef struct _pdfpcRendererCachedPagePropsClass pdfpcRendererCachedPagePropsClass;

#define PDFPC_RENDERER_TYPE_CACHED_PAGE (pdfpc_renderer_cached_page_get_type ())
#define PDFPC_RENDERER_CACHED_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_RENDERER_TYPE_CACHED_PAGE, pdfpcRendererCachedPage))
#define PDFPC_RENDERER_CACHED_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_RENDERER_TYPE_CACHED_PAGE, pdfpcRendererCachedPageClass))
#define PDFPC_RENDERER_IS_CACHED_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_RENDERER_TYPE_CACHED_PAGE))
#define PDFPC_RENDERER_IS_CACHED_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_RENDERER_TYPE_CACHED_PAGE))
#define PDFPC_RENDERER_CACHED_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_RENDERER_TYPE_CACHED_PAGE, pdfpcRendererCachedPageClass))

typedef struct _pdfpcRendererCachedPage pdfpcRendererCachedPage;
typedef struct _pdfpcRendererCachedPageClass pdfpcRendererCachedPageClass;
enum  {
	PDFPC_RENDERER_CACHE_0_PROPERTY,
	PDFPC_RENDERER_CACHE_NUM_PROPERTIES
};
static GParamSpec* pdfpc_renderer_cache_properties[PDFPC_RENDERER_CACHE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _pdfpc_renderer_cached_page_unref0(var) ((var == NULL) ? NULL : (var = (pdfpc_renderer_cached_page_unref (var), NULL)))
typedef struct _pdfpcRendererCachedPagePrivate pdfpcRendererCachedPagePrivate;
typedef struct _pdfpcRendererCachedPagePropsPrivate pdfpcRendererCachedPagePropsPrivate;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
enum  {
	PDFPC_RENDERER_CACHED_PAGE_PROPS_0_PROPERTY,
	PDFPC_RENDERER_CACHED_PAGE_PROPS_NUM_PROPERTIES
};
static GParamSpec* pdfpc_renderer_cached_page_props_properties[PDFPC_RENDERER_CACHED_PAGE_PROPS_NUM_PROPERTIES];
typedef struct _pdfpcRendererParamSpecCachedPage pdfpcRendererParamSpecCachedPage;

struct _pdfpcRendererCache {
	GObject parent_instance;
	pdfpcRendererCachePrivate * priv;
	GeeHashMap* storage;
	guint timeout_id;
};

struct _pdfpcRendererCacheClass {
	GObjectClass parent_class;
};

struct _pdfpcRendererCachedPage {
	GTypeInstance parent_instance;
	volatile int ref_count;
	pdfpcRendererCachedPagePrivate * priv;
	cairo_surface_t* surface;
	guint8* png_data;
	gint png_data_length1;
	gboolean permanent;
	gint64 atime;
};

struct _pdfpcRendererCachedPageClass {
	GTypeClass parent_class;
	void (*finalize) (pdfpcRendererCachedPage *self);
};

struct _pdfpcRendererCachedPageProps {
	GObject parent_instance;
	pdfpcRendererCachedPagePropsPrivate * priv;
	guint index;
	guint width;
	guint height;
	gboolean notes_area;
};

struct _pdfpcRendererCachedPagePropsClass {
	GObjectClass parent_class;
};

struct _pdfpcRendererParamSpecCachedPage {
	GParamSpec parent_instance;
};

static gpointer pdfpc_renderer_cache_parent_class = NULL;
VALA_EXTERN gint pdfpc_options_cache_expiration;
VALA_EXTERN gint pdfpc_options_cache_clean_period;
VALA_EXTERN gint pdfpc_options_cache_max_usize;
VALA_EXTERN gboolean pdfpc_options_cache_debug;
static gpointer pdfpc_renderer_cached_page_props_parent_class = NULL;
static GeeHashableIface * pdfpc_renderer_cached_page_props_gee_hashable_parent_iface = NULL;
static gpointer pdfpc_renderer_cached_page_parent_class = NULL;

VALA_EXTERN GType pdfpc_renderer_cache_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (pdfpcRendererCache, g_object_unref)
VALA_EXTERN GType pdfpc_renderer_cached_page_props_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (pdfpcRendererCachedPageProps, g_object_unref)
VALA_EXTERN gpointer pdfpc_renderer_cached_page_ref (gpointer instance);
VALA_EXTERN void pdfpc_renderer_cached_page_unref (gpointer instance);
VALA_EXTERN GParamSpec* pdfpc_renderer_param_spec_cached_page (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags);
VALA_EXTERN void pdfpc_renderer_value_set_cached_page (GValue* value,
                                           gpointer v_object);
VALA_EXTERN void pdfpc_renderer_value_take_cached_page (GValue* value,
                                            gpointer v_object);
VALA_EXTERN gpointer pdfpc_renderer_value_get_cached_page (const GValue* value);
VALA_EXTERN GType pdfpc_renderer_cached_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (pdfpcRendererCachedPage, pdfpc_renderer_cached_page_unref)
VALA_EXTERN pdfpcRendererCache* pdfpc_renderer_cache_new (void);
VALA_EXTERN pdfpcRendererCache* pdfpc_renderer_cache_construct (GType object_type);
VALA_EXTERN gboolean pdfpc_renderer_cache_clean_cache (pdfpcRendererCache* self);
static gboolean _pdfpc_renderer_cache_clean_cache_gsource_func (gpointer self);
VALA_EXTERN void pdfpc_renderer_cache_store (pdfpcRendererCache* self,
                                 pdfpcRendererCachedPageProps* props,
                                 cairo_surface_t* surface,
                                 gboolean permanent);
VALA_EXTERN pdfpcRendererCachedPage* pdfpc_renderer_cached_page_new (void);
VALA_EXTERN pdfpcRendererCachedPage* pdfpc_renderer_cached_page_construct (GType object_type);
VALA_EXTERN cairo_surface_t* pdfpc_renderer_cache_retrieve (pdfpcRendererCache* self,
                                                pdfpcRendererCachedPageProps* props);
VALA_EXTERN void pdfpc_renderer_cache_invalidate (pdfpcRendererCache* self);
static void pdfpc_renderer_cache_finalize (GObject * obj);
static GType pdfpc_renderer_cache_get_type_once (void);
VALA_EXTERN pdfpcRendererCachedPageProps* pdfpc_renderer_cached_page_props_new (guint index,
                                                                    guint width,
                                                                    guint height,
                                                                    gboolean notes_area);
VALA_EXTERN pdfpcRendererCachedPageProps* pdfpc_renderer_cached_page_props_construct (GType object_type,
                                                                          guint index,
                                                                          guint width,
                                                                          guint height,
                                                                          gboolean notes_area);
static guint pdfpc_renderer_cached_page_props_real_hash (GeeHashable* base);
static gboolean pdfpc_renderer_cached_page_props_real_equal_to (GeeHashable* base,
                                                         pdfpcRendererCachedPageProps* other);
static void pdfpc_renderer_cached_page_props_finalize (GObject * obj);
static GType pdfpc_renderer_cached_page_props_get_type_once (void);
static void pdfpc_renderer_cached_page_finalize (pdfpcRendererCachedPage * obj);
static GType pdfpc_renderer_cached_page_get_type_once (void);

/**
         * Initialize the cache store and launch a periodic cleaning
         */
static gboolean
_pdfpc_renderer_cache_clean_cache_gsource_func (gpointer self)
{
	gboolean result;
	result = pdfpc_renderer_cache_clean_cache ((pdfpcRendererCache*) self);
	return result;
}

pdfpcRendererCache*
pdfpc_renderer_cache_construct (GType object_type)
{
	pdfpcRendererCache * self = NULL;
	GeeHashMap* _tmp0_;
	self = (pdfpcRendererCache*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_map_new (PDFPC_RENDERER_TYPE_CACHED_PAGE_PROPS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, PDFPC_RENDERER_TYPE_CACHED_PAGE, (GBoxedCopyFunc) pdfpc_renderer_cached_page_ref, (GDestroyNotify) pdfpc_renderer_cached_page_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->storage);
	self->storage = _tmp0_;
	if (pdfpc_options_cache_expiration > 0) {
		self->timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (1000 * pdfpc_options_cache_clean_period), _pdfpc_renderer_cache_clean_cache_gsource_func, g_object_ref (self), g_object_unref);
	}
	return self;
}

pdfpcRendererCache*
pdfpc_renderer_cache_new (void)
{
	return pdfpc_renderer_cache_construct (PDFPC_RENDERER_TYPE_CACHE);
}

/**
         * Store a surface in the cache using the (index, width, height) tuple
         * as identifier; also keep the time it took to render
         */
static gpointer
_cairo_surface_reference0 (gpointer self)
{
	return self ? cairo_surface_reference (self) : NULL;
}

void
pdfpc_renderer_cache_store (pdfpcRendererCache* self,
                            pdfpcRendererCachedPageProps* props,
                            cairo_surface_t* surface,
                            gboolean permanent)
{
	pdfpcRendererCachedPage* page = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	pdfpcRendererCachedPage* _tmp2_;
	pdfpcRendererCachedPage* _tmp4_;
	pdfpcRendererCachedPage* _tmp5_;
	guint size = 0U;
	GeeHashMap* _tmp22_;
	pdfpcRendererCachedPage* _tmp23_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (props != NULL);
	g_return_if_fail (surface != NULL);
	_tmp0_ = self->storage;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, props);
	page = (pdfpcRendererCachedPage*) _tmp1_;
	_tmp2_ = page;
	if (_tmp2_ == NULL) {
		pdfpcRendererCachedPage* _tmp3_;
		_tmp3_ = pdfpc_renderer_cached_page_new ();
		_pdfpc_renderer_cached_page_unref0 (page);
		page = _tmp3_;
	}
	_tmp4_ = page;
	_tmp4_->permanent = permanent;
	_tmp5_ = page;
	_tmp5_->atime = g_get_monotonic_time ();
	size = (3 * props->width) * props->height;
	if ((size / 1024) > ((guint) pdfpc_options_cache_max_usize)) {
		GdkPixbuf* pixbuf = NULL;
		GdkPixbuf* _tmp6_;
		_tmp6_ = gdk_pixbuf_get_from_surface (surface, 0, 0, cairo_image_surface_get_width (surface), cairo_image_surface_get_height (surface));
		pixbuf = _tmp6_;
		{
			GdkPixbuf* _tmp7_;
			pdfpcRendererCachedPage* _tmp8_;
			guint8* _tmp9_ = NULL;
			gsize _tmp10_ = 0;
			pdfpcRendererCachedPage* _tmp11_;
			_tmp7_ = pixbuf;
			_tmp8_ = page;
			gdk_pixbuf_save_to_buffer (_tmp7_, &_tmp9_, &_tmp10_, "png", &_inner_error0_, "compression", "1", NULL, NULL);
			_tmp8_->png_data = (g_free (_tmp8_->png_data), NULL);
			_tmp8_->png_data = _tmp9_;
			_tmp8_->png_data_length1 = _tmp10_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp11_ = page;
			_cairo_surface_destroy0 (_tmp11_->surface);
			_tmp11_->surface = NULL;
			if (pdfpc_options_cache_debug) {
				pdfpcRendererCachedPage* _tmp12_;
				guint8* _tmp13_;
				gint _tmp13__length1;
				_tmp12_ = page;
				_tmp13_ = _tmp12_->png_data;
				_tmp13__length1 = _tmp12_->png_data_length1;
				g_printerr ("Compression ratio of [%u] (%ux%u) = %g\n", props->index, props->width, props->height, ((gdouble) size) / _tmp13__length1);
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp14_;
			const gchar* _tmp15_;
			pdfpcRendererCachedPage* _tmp16_;
			cairo_surface_t* _tmp17_;
			pdfpcRendererCachedPage* _tmp18_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp14_ = e;
			_tmp15_ = _tmp14_->message;
			g_printerr ("PNG generation failed for slide %u: %s\n", props->index, _tmp15_);
			_tmp16_ = page;
			_tmp17_ = _cairo_surface_reference0 (surface);
			_cairo_surface_destroy0 (_tmp16_->surface);
			_tmp16_->surface = _tmp17_;
			_tmp18_ = page;
			_tmp18_->png_data = (g_free (_tmp18_->png_data), NULL);
			_tmp18_->png_data = NULL;
			_tmp18_->png_data_length1 = 0;
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (pixbuf);
			_pdfpc_renderer_cached_page_unref0 (page);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_object_unref0 (pixbuf);
	} else {
		pdfpcRendererCachedPage* _tmp19_;
		cairo_surface_t* _tmp20_;
		pdfpcRendererCachedPage* _tmp21_;
		_tmp19_ = page;
		_tmp20_ = _cairo_surface_reference0 (surface);
		_cairo_surface_destroy0 (_tmp19_->surface);
		_tmp19_->surface = _tmp20_;
		_tmp21_ = page;
		_tmp21_->png_data = (g_free (_tmp21_->png_data), NULL);
		_tmp21_->png_data = NULL;
		_tmp21_->png_data_length1 = 0;
	}
	_tmp22_ = self->storage;
	_tmp23_ = page;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp22_, props, _tmp23_);
	_pdfpc_renderer_cached_page_unref0 (page);
}

/**
         * Retrieve a stored surface from the cache.
         *
         * If no item with the given (index, width, height) tuple is available,
         * null is returned
         */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

cairo_surface_t*
pdfpc_renderer_cache_retrieve (pdfpcRendererCache* self,
                               pdfpcRendererCachedPageProps* props)
{
	pdfpcRendererCachedPage* page = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	pdfpcRendererCachedPage* _tmp2_;
	GError* _inner_error0_ = NULL;
	cairo_surface_t* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (props != NULL, NULL);
	_tmp0_ = self->storage;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, props);
	page = (pdfpcRendererCachedPage*) _tmp1_;
	_tmp2_ = page;
	if (_tmp2_ != NULL) {
		pdfpcRendererCachedPage* _tmp3_;
		pdfpcRendererCachedPage* _tmp4_;
		cairo_surface_t* _tmp5_;
		_tmp3_ = page;
		_tmp3_->atime = g_get_monotonic_time ();
		_tmp4_ = page;
		_tmp5_ = _tmp4_->surface;
		if (_tmp5_ != NULL) {
			pdfpcRendererCachedPage* _tmp6_;
			cairo_surface_t* _tmp7_;
			cairo_surface_t* _tmp8_;
			_tmp6_ = page;
			_tmp7_ = _tmp6_->surface;
			_tmp8_ = _cairo_surface_reference0 (_tmp7_);
			result = _tmp8_;
			_pdfpc_renderer_cached_page_unref0 (page);
			return result;
		} else {
			GdkPixbufLoader* loader = NULL;
			GdkPixbufLoader* _tmp9_;
			GdkPixbuf* pixbuf = NULL;
			GdkPixbufLoader* _tmp16_;
			GdkPixbuf* _tmp17_;
			GdkPixbuf* _tmp18_;
			cairo_surface_t* surface = NULL;
			GdkPixbuf* _tmp19_;
			GdkPixbuf* _tmp20_;
			cairo_surface_t* _tmp21_;
			cairo_t* cr = NULL;
			cairo_surface_t* _tmp22_;
			cairo_t* _tmp23_;
			cairo_t* _tmp24_;
			GdkPixbuf* _tmp25_;
			cairo_t* _tmp26_;
			GdkPixbuf* _tmp27_;
			GdkPixbuf* _tmp28_;
			cairo_t* _tmp29_;
			_tmp9_ = gdk_pixbuf_loader_new ();
			loader = _tmp9_;
			{
				GdkPixbufLoader* _tmp10_;
				pdfpcRendererCachedPage* _tmp11_;
				guint8* _tmp12_;
				gint _tmp12__length1;
				GdkPixbufLoader* _tmp13_;
				_tmp10_ = loader;
				_tmp11_ = page;
				_tmp12_ = _tmp11_->png_data;
				_tmp12__length1 = _tmp11_->png_data_length1;
				gdk_pixbuf_loader_write (_tmp10_, _tmp12_, (gsize) _tmp12__length1, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp13_ = loader;
				gdk_pixbuf_loader_close (_tmp13_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp14_;
				const gchar* _tmp15_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp14_ = e;
				_tmp15_ = _tmp14_->message;
				g_printerr ("PNG loader failed for slide %u: %s\n", props->index, _tmp15_);
				result = NULL;
				_g_error_free0 (e);
				_g_object_unref0 (loader);
				_pdfpc_renderer_cached_page_unref0 (page);
				return result;
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (loader);
				_pdfpc_renderer_cached_page_unref0 (page);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp16_ = loader;
			_tmp17_ = gdk_pixbuf_loader_get_pixbuf (_tmp16_);
			_tmp18_ = _g_object_ref0 (_tmp17_);
			pixbuf = _tmp18_;
			_tmp19_ = pixbuf;
			_tmp20_ = pixbuf;
			_tmp21_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, gdk_pixbuf_get_width (_tmp19_), gdk_pixbuf_get_height (_tmp20_));
			surface = _tmp21_;
			_tmp22_ = surface;
			_tmp23_ = cairo_create (_tmp22_);
			cr = _tmp23_;
			_tmp24_ = cr;
			_tmp25_ = pixbuf;
			gdk_cairo_set_source_pixbuf (_tmp24_, _tmp25_, (gdouble) 0, (gdouble) 0);
			_tmp26_ = cr;
			_tmp27_ = pixbuf;
			_tmp28_ = pixbuf;
			cairo_rectangle (_tmp26_, (gdouble) 0, (gdouble) 0, (gdouble) gdk_pixbuf_get_width (_tmp27_), (gdouble) gdk_pixbuf_get_height (_tmp28_));
			_tmp29_ = cr;
			cairo_fill (_tmp29_);
			result = surface;
			_cairo_destroy0 (cr);
			_g_object_unref0 (pixbuf);
			_g_object_unref0 (loader);
			_pdfpc_renderer_cached_page_unref0 (page);
			return result;
		}
	} else {
		result = NULL;
		_pdfpc_renderer_cached_page_unref0 (page);
		return result;
	}
}

/**
         * Invalidate the whole cache (if the document is reloaded/changed)
         */
void
pdfpc_renderer_cache_invalidate (pdfpcRendererCache* self)
{
	GeeHashMap* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->storage;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp0_);
}

/**
         * Evict expired cached slides
         */
gboolean
pdfpc_renderer_cache_clean_cache (pdfpcRendererCache* self)
{
	gint64 current_time = 0LL;
	GeeMapIterator* it = NULL;
	GeeHashMap* _tmp0_;
	GeeMapIterator* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	current_time = g_get_monotonic_time ();
	_tmp0_ = self->storage;
	_tmp1_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp0_);
	it = _tmp1_;
	while (TRUE) {
		GeeMapIterator* _tmp2_;
		GeeMapIterator* _tmp3_;
		pdfpcRendererCachedPage* cpage = NULL;
		GeeMapIterator* _tmp4_;
		gpointer _tmp5_;
		gboolean _tmp6_ = FALSE;
		pdfpcRendererCachedPage* _tmp7_;
		_tmp2_ = it;
		if (!gee_map_iterator_has_next (_tmp2_)) {
			break;
		}
		_tmp3_ = it;
		gee_map_iterator_next (_tmp3_);
		_tmp4_ = it;
		_tmp5_ = gee_map_iterator_get_value (_tmp4_);
		cpage = (pdfpcRendererCachedPage*) _tmp5_;
		_tmp7_ = cpage;
		if (((current_time - _tmp7_->atime) / 1000000L) > ((gint64) pdfpc_options_cache_expiration)) {
			pdfpcRendererCachedPage* _tmp8_;
			_tmp8_ = cpage;
			_tmp6_ = !_tmp8_->permanent;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			GeeMapIterator* _tmp15_;
			if (pdfpc_options_cache_debug) {
				pdfpcRendererCachedPageProps* props = NULL;
				GeeMapIterator* _tmp9_;
				gpointer _tmp10_;
				FILE* _tmp11_;
				pdfpcRendererCachedPageProps* _tmp12_;
				pdfpcRendererCachedPageProps* _tmp13_;
				pdfpcRendererCachedPageProps* _tmp14_;
				_tmp9_ = it;
				_tmp10_ = gee_map_iterator_get_key (_tmp9_);
				props = (pdfpcRendererCachedPageProps*) _tmp10_;
				_tmp11_ = stdout;
				_tmp12_ = props;
				_tmp13_ = props;
				_tmp14_ = props;
				fprintf (_tmp11_, "Expired cache of [%u] %ux%u\n", _tmp12_->index, _tmp13_->width, _tmp14_->height);
				_g_object_unref0 (props);
			}
			_tmp15_ = it;
			gee_map_iterator_unset (_tmp15_);
		}
		_pdfpc_renderer_cached_page_unref0 (cpage);
	}
	result = G_SOURCE_CONTINUE;
	_g_object_unref0 (it);
	return result;
}

static void
pdfpc_renderer_cache_class_init (pdfpcRendererCacheClass * klass,
                                 gpointer klass_data)
{
	pdfpc_renderer_cache_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = pdfpc_renderer_cache_finalize;
}

static void
pdfpc_renderer_cache_instance_init (pdfpcRendererCache * self,
                                    gpointer klass)
{
	self->storage = NULL;
	self->timeout_id = (guint) 0;
}

static void
pdfpc_renderer_cache_finalize (GObject * obj)
{
	pdfpcRendererCache * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PDFPC_RENDERER_TYPE_CACHE, pdfpcRendererCache);
	_g_object_unref0 (self->storage);
	G_OBJECT_CLASS (pdfpc_renderer_cache_parent_class)->finalize (obj);
}

/**
     * Cache store
     */
static GType
pdfpc_renderer_cache_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (pdfpcRendererCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pdfpc_renderer_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (pdfpcRendererCache), 0, (GInstanceInitFunc) pdfpc_renderer_cache_instance_init, NULL };
	GType pdfpc_renderer_cache_type_id;
	pdfpc_renderer_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "pdfpcRendererCache", &g_define_type_info, 0);
	return pdfpc_renderer_cache_type_id;
}

GType
pdfpc_renderer_cache_get_type (void)
{
	static volatile gsize pdfpc_renderer_cache_type_id__once = 0;
	if (g_once_init_enter (&pdfpc_renderer_cache_type_id__once)) {
		GType pdfpc_renderer_cache_type_id;
		pdfpc_renderer_cache_type_id = pdfpc_renderer_cache_get_type_once ();
		g_once_init_leave (&pdfpc_renderer_cache_type_id__once, pdfpc_renderer_cache_type_id);
	}
	return pdfpc_renderer_cache_type_id__once;
}

pdfpcRendererCachedPageProps*
pdfpc_renderer_cached_page_props_construct (GType object_type,
                                            guint index,
                                            guint width,
                                            guint height,
                                            gboolean notes_area)
{
	pdfpcRendererCachedPageProps * self = NULL;
	self = (pdfpcRendererCachedPageProps*) g_object_new (object_type, NULL);
	self->index = index;
	self->width = width;
	self->height = height;
	self->notes_area = notes_area;
	return self;
}

pdfpcRendererCachedPageProps*
pdfpc_renderer_cached_page_props_new (guint index,
                                      guint width,
                                      guint height,
                                      gboolean notes_area)
{
	return pdfpc_renderer_cached_page_props_construct (PDFPC_RENDERER_TYPE_CACHED_PAGE_PROPS, index, width, height, notes_area);
}

static guint
pdfpc_renderer_cached_page_props_real_hash (GeeHashable* base)
{
	pdfpcRendererCachedPageProps * self;
	guint result;
	self = (pdfpcRendererCachedPageProps*) base;
	result = self->index + (1000 * ((self->width % 13) + (self->height % 17)));
	return result;
}

static gboolean
pdfpc_renderer_cached_page_props_real_equal_to (GeeHashable* base,
                                                pdfpcRendererCachedPageProps* other)
{
	pdfpcRendererCachedPageProps * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	self = (pdfpcRendererCachedPageProps*) base;
	g_return_val_if_fail (other != NULL, FALSE);
	if (self->index == other->index) {
		_tmp2_ = self->width == other->width;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = self->height == other->height;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = self->notes_area == other->notes_area;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
pdfpc_renderer_cached_page_props_class_init (pdfpcRendererCachedPagePropsClass * klass,
                                             gpointer klass_data)
{
	pdfpc_renderer_cached_page_props_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = pdfpc_renderer_cached_page_props_finalize;
}

static void
pdfpc_renderer_cached_page_props_gee_hashable_interface_init (GeeHashableIface * iface,
                                                              gpointer iface_data)
{
	pdfpc_renderer_cached_page_props_gee_hashable_parent_iface = g_type_interface_peek_parent (iface);
	iface->hash = (guint (*) (GeeHashable*)) pdfpc_renderer_cached_page_props_real_hash;
	iface->equal_to = (gboolean (*) (GeeHashable*, gconstpointer)) pdfpc_renderer_cached_page_props_real_equal_to;
}

static void
pdfpc_renderer_cached_page_props_instance_init (pdfpcRendererCachedPageProps * self,
                                                gpointer klass)
{
}

static void
pdfpc_renderer_cached_page_props_finalize (GObject * obj)
{
	pdfpcRendererCachedPageProps * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PDFPC_RENDERER_TYPE_CACHED_PAGE_PROPS, pdfpcRendererCachedPageProps);
	G_OBJECT_CLASS (pdfpc_renderer_cached_page_props_parent_class)->finalize (obj);
}

static GType
pdfpc_renderer_cached_page_props_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (pdfpcRendererCachedPagePropsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pdfpc_renderer_cached_page_props_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (pdfpcRendererCachedPageProps), 0, (GInstanceInitFunc) pdfpc_renderer_cached_page_props_instance_init, NULL };
	static const GInterfaceInfo gee_hashable_info = { (GInterfaceInitFunc) pdfpc_renderer_cached_page_props_gee_hashable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType pdfpc_renderer_cached_page_props_type_id;
	pdfpc_renderer_cached_page_props_type_id = g_type_register_static (G_TYPE_OBJECT, "pdfpcRendererCachedPageProps", &g_define_type_info, 0);
	g_type_add_interface_static (pdfpc_renderer_cached_page_props_type_id, GEE_TYPE_HASHABLE, &gee_hashable_info);
	return pdfpc_renderer_cached_page_props_type_id;
}

GType
pdfpc_renderer_cached_page_props_get_type (void)
{
	static volatile gsize pdfpc_renderer_cached_page_props_type_id__once = 0;
	if (g_once_init_enter (&pdfpc_renderer_cached_page_props_type_id__once)) {
		GType pdfpc_renderer_cached_page_props_type_id;
		pdfpc_renderer_cached_page_props_type_id = pdfpc_renderer_cached_page_props_get_type_once ();
		g_once_init_leave (&pdfpc_renderer_cached_page_props_type_id__once, pdfpc_renderer_cached_page_props_type_id);
	}
	return pdfpc_renderer_cached_page_props_type_id__once;
}

pdfpcRendererCachedPage*
pdfpc_renderer_cached_page_construct (GType object_type)
{
	pdfpcRendererCachedPage* self = NULL;
	self = (pdfpcRendererCachedPage*) g_type_create_instance (object_type);
	return self;
}

pdfpcRendererCachedPage*
pdfpc_renderer_cached_page_new (void)
{
	return pdfpc_renderer_cached_page_construct (PDFPC_RENDERER_TYPE_CACHED_PAGE);
}

static void
pdfpc_renderer_value_cached_page_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
pdfpc_renderer_value_cached_page_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		pdfpc_renderer_cached_page_unref (value->data[0].v_pointer);
	}
}

static void
pdfpc_renderer_value_cached_page_copy_value (const GValue* src_value,
                                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = pdfpc_renderer_cached_page_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
pdfpc_renderer_value_cached_page_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
pdfpc_renderer_value_cached_page_collect_value (GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		pdfpcRendererCachedPage * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = pdfpc_renderer_cached_page_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
pdfpc_renderer_value_cached_page_lcopy_value (const GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	pdfpcRendererCachedPage ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = pdfpc_renderer_cached_page_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
pdfpc_renderer_param_spec_cached_page (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags)
{
	pdfpcRendererParamSpecCachedPage* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PDFPC_RENDERER_TYPE_CACHED_PAGE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
pdfpc_renderer_value_get_cached_page (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PDFPC_RENDERER_TYPE_CACHED_PAGE), NULL);
	return value->data[0].v_pointer;
}

void
pdfpc_renderer_value_set_cached_page (GValue* value,
                                      gpointer v_object)
{
	pdfpcRendererCachedPage * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PDFPC_RENDERER_TYPE_CACHED_PAGE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PDFPC_RENDERER_TYPE_CACHED_PAGE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		pdfpc_renderer_cached_page_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pdfpc_renderer_cached_page_unref (old);
	}
}

void
pdfpc_renderer_value_take_cached_page (GValue* value,
                                       gpointer v_object)
{
	pdfpcRendererCachedPage * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PDFPC_RENDERER_TYPE_CACHED_PAGE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PDFPC_RENDERER_TYPE_CACHED_PAGE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pdfpc_renderer_cached_page_unref (old);
	}
}

static void
pdfpc_renderer_cached_page_class_init (pdfpcRendererCachedPageClass * klass,
                                       gpointer klass_data)
{
	pdfpc_renderer_cached_page_parent_class = g_type_class_peek_parent (klass);
	((pdfpcRendererCachedPageClass *) klass)->finalize = pdfpc_renderer_cached_page_finalize;
}

static void
pdfpc_renderer_cached_page_instance_init (pdfpcRendererCachedPage * self,
                                          gpointer klass)
{
	self->surface = NULL;
	self->png_data = NULL;
	self->png_data_length1 = 0;
	self->permanent = FALSE;
	self->atime = (gint64) 0;
	self->ref_count = 1;
}

static void
pdfpc_renderer_cached_page_finalize (pdfpcRendererCachedPage * obj)
{
	pdfpcRendererCachedPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PDFPC_RENDERER_TYPE_CACHED_PAGE, pdfpcRendererCachedPage);
	g_signal_handlers_destroy (self);
	_cairo_surface_destroy0 (self->surface);
	self->png_data = (g_free (self->png_data), NULL);
}

static GType
pdfpc_renderer_cached_page_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { pdfpc_renderer_value_cached_page_init, pdfpc_renderer_value_cached_page_free_value, pdfpc_renderer_value_cached_page_copy_value, pdfpc_renderer_value_cached_page_peek_pointer, "p", pdfpc_renderer_value_cached_page_collect_value, "p", pdfpc_renderer_value_cached_page_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (pdfpcRendererCachedPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pdfpc_renderer_cached_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (pdfpcRendererCachedPage), 0, (GInstanceInitFunc) pdfpc_renderer_cached_page_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType pdfpc_renderer_cached_page_type_id;
	pdfpc_renderer_cached_page_type_id = g_type_register_fundamental (g_type_fundamental_next (), "pdfpcRendererCachedPage", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return pdfpc_renderer_cached_page_type_id;
}

GType
pdfpc_renderer_cached_page_get_type (void)
{
	static volatile gsize pdfpc_renderer_cached_page_type_id__once = 0;
	if (g_once_init_enter (&pdfpc_renderer_cached_page_type_id__once)) {
		GType pdfpc_renderer_cached_page_type_id;
		pdfpc_renderer_cached_page_type_id = pdfpc_renderer_cached_page_get_type_once ();
		g_once_init_leave (&pdfpc_renderer_cached_page_type_id__once, pdfpc_renderer_cached_page_type_id);
	}
	return pdfpc_renderer_cached_page_type_id__once;
}

gpointer
pdfpc_renderer_cached_page_ref (gpointer instance)
{
	pdfpcRendererCachedPage * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
pdfpc_renderer_cached_page_unref (gpointer instance)
{
	pdfpcRendererCachedPage * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PDFPC_RENDERER_CACHED_PAGE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

