// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                           avtPLOT3DOptions.C                              //
// ************************************************************************* //

#include <avtPLOT3DOptions.h>

#include <DBOptionsAttributes.h>

#include <string>
#include <vector>
using std::vector;
using std::string;


// ****************************************************************************
//  Function: GetPLOT3DReadOptions
//
//  Purpose:
//      Creates the options for PLOT3D readers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require read options, no modifications are 
//      necessary.
//
//  Programmer: biagas2 -- generated by xml2avt
//  Creation:   Tue Aug 19 20:12:37 PST 2014
//
//  Modifications:
//    Kathleen Biagas, Thu Aug 27 12:50:44 PDT 2015
//    Changed order.  Added 'Fortran binary stream' File Format option (which
//    indicates non-record based fortran binary files).  Added options for
//    Gas constants R and Gamma, used in function calculations.
//
// ****************************************************************************

DBOptionsAttributes *
GetPLOT3DReadOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;

    rv->SetEnum("File Format", 1);
    vector<string> ff;
    ff.push_back("ASCII");
    ff.push_back("C Binary");
    ff.push_back("Fortran binary");
    ff.push_back("Fortran binary stream");
    rv->SetEnumStrings("File Format", ff);

    rv->SetString("Solution (Q) File Name", "");
    rv->SetBool("Solution Time field accurate", true);

    rv->SetBool("3D", true);
    rv->SetBool("Multi Grid", false);
    rv->SetBool("Big Endian", true);
    rv->SetBool("Double Precision", false);
    rv->SetBool("IBlanking", false);

    rv->SetDouble("Gas constant R", 1.0);
    rv->SetDouble("Gas constant Gamma", 1.4);
    return rv;
}


// ****************************************************************************
//  Function: GetPLOT3DWriteOptions
//
//  Purpose:
//      Creates the options for PLOT3D writers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require write options, no modifications are 
//      necessary.
//
//  Programmer: biagas2 -- generated by xml2avt
//  Creation:   Tue Aug 19 20:12:37 PST 2014
//
// ****************************************************************************

DBOptionsAttributes *
GetPLOT3DWriteOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    return rv;
}
