/* Composer.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Composer.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2017-2023 elementary, Inc. (https://elementary.io)
 *
 * Authored by: David Hewitt <davidmhewitt@gmail.com>
 */

#include <handy.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <camel/camel.h>
#include <webkit2/webkit2.h>
#include <gtk/gtk.h>
#include <granite.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <libedataserver/libedataserver.h>
#include <glib/gstdio.h>
#include <time.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>

#define MAIL_COMPOSER_ACTION_GROUP_PREFIX "win"
#define MAIL_COMPOSER_ACTION_PREFIX MAIL_COMPOSER_ACTION_GROUP_PREFIX "."
#define MAIL_COMPOSER_ACTION_ADD_ATTACHMENT "add-attachment"
#define MAIL_COMPOSER_ACTION_INSERT_IMAGE "insert-image"
#define MAIL_COMPOSER_ACTION_INSERT_SIGNATURE "insert-signature"
#define MAIL_COMPOSER_ACTION_DISCARD "discard"
#define MAIL_COMPOSER_ACTION_SEND "send"
#define MAIL_COMPOSER_ATTACHMENT_DISPOSITION_ATTACHMENT "attachment"
#define MAIL_COMPOSER_ATTACHMENT_DISPOSITION_INLINE "inline"
#define MAIL_APPLICATION_ACTION_GROUP_PREFIX "app"
#define MAIL_APPLICATION_ACTION_PREFIX MAIL_APPLICATION_ACTION_GROUP_PREFIX "."
#define MAIL_APPLICATION_ACTION_MANAGE_SIGNATURES "manage-signatures"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAIL_TYPE_COMPOSER (mail_composer_get_type ())
#define MAIL_COMPOSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_COMPOSER, MailComposer))
#define MAIL_COMPOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_COMPOSER, MailComposerClass))
#define MAIL_IS_COMPOSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_COMPOSER))
#define MAIL_IS_COMPOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_COMPOSER))
#define MAIL_COMPOSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_COMPOSER, MailComposerClass))

typedef struct _MailComposer MailComposer;
typedef struct _MailComposerClass MailComposerClass;
typedef struct _MailComposerPrivate MailComposerPrivate;

#define MAIL_TYPE_WEB_VIEW (mail_web_view_get_type ())
#define MAIL_WEB_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_WEB_VIEW, MailWebView))
#define MAIL_WEB_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_WEB_VIEW, MailWebViewClass))
#define MAIL_IS_WEB_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_WEB_VIEW))
#define MAIL_IS_WEB_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_WEB_VIEW))
#define MAIL_WEB_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_WEB_VIEW, MailWebViewClass))

typedef struct _MailWebView MailWebView;
typedef struct _MailWebViewClass MailWebViewClass;
enum  {
	MAIL_COMPOSER_0_PROPERTY,
	MAIL_COMPOSER_HAS_RECIPIENTS_PROPERTY,
	MAIL_COMPOSER_TO_PROPERTY,
	MAIL_COMPOSER_MAILTO_QUERY_PROPERTY,
	MAIL_COMPOSER_NUM_PROPERTIES
};
static GParamSpec* mail_composer_properties[MAIL_COMPOSER_NUM_PROPERTIES];
typedef enum  {
	MAIL_COMPOSER_TYPE_REPLY,
	MAIL_COMPOSER_TYPE_REPLY_ALL,
	MAIL_COMPOSER_TYPE_FORWARD,
	MAIL_COMPOSER_TYPE_DRAFT
} MailComposerType;

#define MAIL_COMPOSER_TYPE_TYPE (mail_composer_type_get_type ())
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define MAIL_COMPOSER_TYPE_ATTACHMENT (mail_composer_attachment_get_type ())
#define MAIL_COMPOSER_ATTACHMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_COMPOSER_TYPE_ATTACHMENT, MailComposerAttachment))
#define MAIL_COMPOSER_ATTACHMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_COMPOSER_TYPE_ATTACHMENT, MailComposerAttachmentClass))
#define MAIL_COMPOSER_IS_ATTACHMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_COMPOSER_TYPE_ATTACHMENT))
#define MAIL_COMPOSER_IS_ATTACHMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_COMPOSER_TYPE_ATTACHMENT))
#define MAIL_COMPOSER_ATTACHMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_COMPOSER_TYPE_ATTACHMENT, MailComposerAttachmentClass))

typedef struct _MailComposerAttachment MailComposerAttachment;
typedef struct _MailComposerAttachmentClass MailComposerAttachmentClass;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;

#define MAIL_BACKEND_TYPE_SESSION (mail_backend_session_get_type ())
#define MAIL_BACKEND_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_BACKEND_TYPE_SESSION, MailBackendSession))
#define MAIL_BACKEND_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_BACKEND_TYPE_SESSION, MailBackendSessionClass))
#define MAIL_BACKEND_IS_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_BACKEND_TYPE_SESSION))
#define MAIL_BACKEND_IS_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_BACKEND_TYPE_SESSION))
#define MAIL_BACKEND_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_BACKEND_TYPE_SESSION, MailBackendSessionClass))

typedef struct _MailBackendSession MailBackendSession;
typedef struct _MailBackendSessionClass MailBackendSessionClass;
typedef struct _Block9Data Block9Data;
typedef gboolean (*MailUtilsAcceptAddress) (const gchar* address, gpointer user_data);
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _MailComposerGetAttachmentsData MailComposerGetAttachmentsData;
typedef struct _Block10Data Block10Data;
typedef struct _Block11Data Block11Data;
typedef struct _Block12Data Block12Data;
typedef struct _Block13Data Block13Data;
typedef struct _Block14Data Block14Data;
typedef struct _MailComposerSendMessageData MailComposerSendMessageData;

#define MAIL_TYPE_CONTACT_MANAGER (mail_contact_manager_get_type ())
#define MAIL_CONTACT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_CONTACT_MANAGER, MailContactManager))
#define MAIL_CONTACT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_CONTACT_MANAGER, MailContactManagerClass))
#define MAIL_IS_CONTACT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_CONTACT_MANAGER))
#define MAIL_IS_CONTACT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_CONTACT_MANAGER))
#define MAIL_CONTACT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_CONTACT_MANAGER, MailContactManagerClass))

typedef struct _MailContactManager MailContactManager;
typedef struct _MailContactManagerClass MailContactManagerClass;
typedef struct _MailComposerRememberRecipientsData MailComposerRememberRecipientsData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block15Data Block15Data;
typedef struct _Block16Data Block16Data;
typedef struct _MailComposerSaveDraftData MailComposerSaveDraftData;
typedef struct _MailComposerAttachmentPrivate MailComposerAttachmentPrivate;
enum  {
	MAIL_COMPOSER_ATTACHMENT_0_PROPERTY,
	MAIL_COMPOSER_ATTACHMENT_FILE_PROPERTY,
	MAIL_COMPOSER_ATTACHMENT_DISPOSITION_PROPERTY,
	MAIL_COMPOSER_ATTACHMENT_CID_PROPERTY,
	MAIL_COMPOSER_ATTACHMENT_URI_PROPERTY,
	MAIL_COMPOSER_ATTACHMENT_NUM_PROPERTIES
};
static GParamSpec* mail_composer_attachment_properties[MAIL_COMPOSER_ATTACHMENT_NUM_PROPERTIES];

#define MAIL_COMPOSER_TYPE_ENTRY_GRID (mail_composer_entry_grid_get_type ())
#define MAIL_COMPOSER_ENTRY_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_COMPOSER_TYPE_ENTRY_GRID, MailComposerEntryGrid))
#define MAIL_COMPOSER_ENTRY_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_COMPOSER_TYPE_ENTRY_GRID, MailComposerEntryGridClass))
#define MAIL_COMPOSER_IS_ENTRY_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_COMPOSER_TYPE_ENTRY_GRID))
#define MAIL_COMPOSER_IS_ENTRY_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_COMPOSER_TYPE_ENTRY_GRID))
#define MAIL_COMPOSER_ENTRY_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_COMPOSER_TYPE_ENTRY_GRID, MailComposerEntryGridClass))

typedef struct _MailComposerEntryGrid MailComposerEntryGrid;
typedef struct _MailComposerEntryGridClass MailComposerEntryGridClass;
typedef struct _MailComposerEntryGridPrivate MailComposerEntryGridPrivate;
enum  {
	MAIL_COMPOSER_ENTRY_GRID_0_PROPERTY,
	MAIL_COMPOSER_ENTRY_GRID_NUM_PROPERTIES
};
static GParamSpec* mail_composer_entry_grid_properties[MAIL_COMPOSER_ENTRY_GRID_NUM_PROPERTIES];
typedef struct _Block17Data Block17Data;

#define MAIL_TYPE_MAIN_WINDOW (mail_main_window_get_type ())
#define MAIL_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_MAIN_WINDOW, MailMainWindow))
#define MAIL_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_MAIN_WINDOW, MailMainWindowClass))
#define MAIL_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_MAIN_WINDOW))
#define MAIL_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_MAIN_WINDOW))
#define MAIL_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_MAIN_WINDOW, MailMainWindowClass))

typedef struct _MailMainWindow MailMainWindow;
typedef struct _MailMainWindowClass MailMainWindowClass;
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))

#define TYPE_EDITOR_TOOLBAR (editor_toolbar_get_type ())
#define EDITOR_TOOLBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EDITOR_TOOLBAR, EditorToolbar))
#define EDITOR_TOOLBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EDITOR_TOOLBAR, EditorToolbarClass))
#define IS_EDITOR_TOOLBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EDITOR_TOOLBAR))
#define IS_EDITOR_TOOLBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EDITOR_TOOLBAR))
#define EDITOR_TOOLBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EDITOR_TOOLBAR, EditorToolbarClass))

typedef struct _EditorToolbar EditorToolbar;
typedef struct _EditorToolbarClass EditorToolbarClass;
enum  {
	MAIL_COMPOSER_FINISHED_SIGNAL,
	MAIL_COMPOSER_NUM_SIGNALS
};
static guint mail_composer_signals[MAIL_COMPOSER_NUM_SIGNALS] = {0};

struct _MailComposer {
	HdyApplicationWindow parent_instance;
	MailComposerPrivate * priv;
};

struct _MailComposerClass {
	HdyApplicationWindowClass parent_class;
};

struct _MailComposerPrivate {
	gboolean _has_recipients;
	gchar* _to;
	gchar* _mailto_query;
	gboolean discard_draft;
	CamelMessageInfo* ancestor_message_info;
	MailWebView* web_view;
	GtkEntry* to_val;
	GtkEntry* cc_val;
	GtkEntry* bcc_val;
	GtkFlowBox* attachment_box;
	GtkRevealer* cc_revealer;
	GtkRevealer* bcc_revealer;
	GtkToggleButton* cc_button;
	GraniteWidgetsOverlayBar* message_url_overlay;
	GtkComboBoxText* from_combo;
	GtkEntry* subject_val;
};

struct _Block4Data {
	int _ref_count_;
	MailComposer* self;
	GtkFileChooserNative* filechooser;
};

struct _Block5Data {
	int _ref_count_;
	Block4Data * _data4_;
	MailComposerAttachment* attachment;
	gulong handler;
};

struct _Block6Data {
	int _ref_count_;
	Block4Data * _data4_;
	GraniteMessageDialog* error_dialog;
};

struct _Block7Data {
	int _ref_count_;
	MailComposer* self;
	gboolean found;
};

struct _Block8Data {
	int _ref_count_;
	Block7Data * _data7_;
	const gchar* address;
};

struct _Block9Data {
	int _ref_count_;
	Block7Data * _data7_;
	gchar* identity_address;
};

struct _MailComposerGetAttachmentsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailComposer* self;
	CamelDataWrapper* message_content;
	GFile* tmp_dir;
	CamelMultipart* content;
	guint i;
	gboolean _tmp0_;
	guint _tmp1_;
	CamelMultipart* _tmp2_;
	CamelMimePart* part;
	CamelMultipart* _tmp3_;
	CamelMimePart* _tmp4_;
	CamelContentType* field;
	CamelMimePart* _tmp5_;
	CamelContentType* _tmp6_;
	CamelMimePart* _tmp7_;
	CamelContentDisposition* _tmp8_;
	CamelMimePart* _tmp9_;
	CamelContentType* _tmp10_;
	GFile* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GFile* _tmp14_;
	GFile* file;
	GFile* _tmp15_;
	CamelMimePart* _tmp16_;
	const gchar* _tmp17_;
	GFile* _tmp18_;
	GFile* _tmp19_;
	GFileOutputStream* output_stream;
	GFile* _tmp20_;
	GFileOutputStream* _tmp21_;
	CamelMimePart* _tmp22_;
	CamelDataWrapper* _tmp23_;
	CamelDataWrapper* _tmp24_;
	GFileOutputStream* _tmp25_;
	GtkFlowBox* _tmp26_;
	GFile* _tmp27_;
	MailComposerAttachment* _tmp28_;
	MailComposerAttachment* _tmp29_;
	GtkFlowBox* _tmp30_;
	GError* e;
	GError* _tmp31_;
	const gchar* _tmp32_;
	CamelContentType* _tmp33_;
	const gchar* _tmp34_;
	CamelMimePart* _tmp35_;
	CamelDataWrapper* _tmp36_;
	CamelDataWrapper* _tmp37_;
	GError* _inner_error0_;
};

struct _Block10Data {
	int _ref_count_;
	MailComposer* self;
	GraniteMessageDialog* discard_dialog;
};

struct _Block11Data {
	int _ref_count_;
	MailComposer* self;
	gpointer _async_data_;
};

struct _Block12Data {
	int _ref_count_;
	Block11Data * _data11_;
	GraniteMessageDialog* no_subject_dialog;
};

struct _Block13Data {
	int _ref_count_;
	Block11Data * _data11_;
	GraniteMessageDialog* warning_dialog;
};

struct _Block14Data {
	int _ref_count_;
	Block11Data * _data11_;
	GraniteMessageDialog* error_dialog;
};

struct _MailComposerSendMessageData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailComposer* self;
	Block11Data* _data11_;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	Block12Data* _data12_;
	GraniteMessageDialog* _tmp3_;
	GraniteMessageDialog* _tmp4_;
	GraniteMessageDialog* _tmp5_;
	GraniteMessageDialog* _tmp6_;
	GtkWidget* send_anyway;
	GraniteMessageDialog* _tmp7_;
	GtkWidget* _tmp8_;
	GtkWidget* _tmp9_;
	GtkWidget* _tmp10_;
	GtkStyleContext* _tmp11_;
	GraniteMessageDialog* _tmp12_;
	GraniteMessageDialog* _tmp13_;
	MailBackendSession* session;
	MailBackendSession* _tmp14_;
	gchar* body_html;
	MailWebView* _tmp15_;
	gchar* _tmp16_;
	CamelMimeMessage* message;
	CamelMimeMessage* _tmp17_;
	CamelInternetAddress* sender;
	GtkComboBoxText* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	CamelInternetAddress* _tmp21_;
	CamelInternetAddress* _tmp22_;
	CamelInternetAddress* recipients;
	GtkEntry* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	GtkEntry* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	GtkEntry* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	CamelInternetAddress* _tmp32_;
	gboolean sent_message_saved;
	Block13Data* _data13_;
	GThemedIcon* _tmp33_;
	GThemedIcon* _tmp34_;
	GThemedIcon* _tmp35_;
	GraniteMessageDialog* _tmp36_;
	GraniteMessageDialog* _tmp37_;
	GraniteMessageDialog* _tmp38_;
	GraniteMessageDialog* _tmp39_;
	GError* e;
	Block14Data* _data14_;
	GThemedIcon* _tmp40_;
	GThemedIcon* _tmp41_;
	GThemedIcon* _tmp42_;
	GraniteMessageDialog* _tmp43_;
	GraniteMessageDialog* _tmp44_;
	GraniteMessageDialog* _tmp45_;
	GError* _tmp46_;
	const gchar* _tmp47_;
	GraniteMessageDialog* _tmp48_;
	GraniteMessageDialog* _tmp49_;
	GError* _inner_error1_;
	GError* _inner_error0_;
};

struct _MailComposerRememberRecipientsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailComposer* self;
	CamelInternetAddress* recipients;
	MailContactManager* contact_manager;
	MailContactManager* _tmp0_;
	MailContactManager* _tmp1_;
	gint i;
	gboolean _tmp2_;
	gint _tmp3_;
	gchar* name;
	gchar* address;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	MailContactManager* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
};

struct _Block15Data {
	int _ref_count_;
	MailComposer* self;
	MailBackendSession* session;
};

struct _Block16Data {
	int _ref_count_;
	MailComposer* self;
	GraniteMessageDialog* error_dialog;
};

struct _MailComposerSaveDraftData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailComposer* self;
	gboolean result;
	gboolean _tmp0_;
	MailWebView* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gchar* body_html;
	MailWebView* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	MailBackendSession* session;
	MailBackendSession* _tmp7_;
	CamelMimeMessage* message;
	const gchar* _tmp8_;
	CamelMimeMessage* _tmp9_;
	CamelInternetAddress* sender;
	CamelMimeMessage* _tmp10_;
	GtkComboBoxText* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	CamelInternetAddress* _tmp14_;
	CamelInternetAddress* _tmp15_;
	CamelInternetAddress* recipients;
	CamelMimeMessage* _tmp16_;
	GtkEntry* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	GtkEntry* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	GtkEntry* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	CamelInternetAddress* _tmp26_;
	MailBackendSession* _tmp27_;
	CamelMimeMessage* _tmp28_;
	CamelInternetAddress* _tmp29_;
	CamelInternetAddress* _tmp30_;
	CamelMessageInfo* _tmp31_;
	GError* e;
	Block16Data* _data16_;
	GThemedIcon* _tmp32_;
	GThemedIcon* _tmp33_;
	GThemedIcon* _tmp34_;
	GraniteMessageDialog* _tmp35_;
	GraniteMessageDialog* _tmp36_;
	GraniteMessageDialog* _tmp37_;
	GError* _tmp38_;
	const gchar* _tmp39_;
	GraniteMessageDialog* _tmp40_;
	GraniteMessageDialog* _tmp41_;
	GError* _inner_error0_;
};

struct _MailComposerAttachment {
	GtkFlowBoxChild parent_instance;
	MailComposerAttachmentPrivate * priv;
};

struct _MailComposerAttachmentClass {
	GtkFlowBoxChildClass parent_class;
};

struct _MailComposerAttachmentPrivate {
	GFile* _file;
	gchar* _disposition;
	gchar* _cid;
	gchar* _uri;
	GFileInfo* info;
};

struct _MailComposerEntryGrid {
	GtkGrid parent_instance;
	MailComposerEntryGridPrivate * priv;
};

struct _MailComposerEntryGridClass {
	GtkGridClass parent_class;
};

struct _Block17Data {
	int _ref_count_;
	MailComposer* self;
	GtkToggleButton* bcc_button;
	MailComposerEntryGrid* to_grid;
	GMenu* signature_menu;
};

static gint MailComposer_private_offset;
static gpointer mail_composer_parent_class = NULL;
static gint MailComposerAttachment_private_offset;
static gpointer mail_composer_attachment_parent_class = NULL;
static gpointer mail_composer_entry_grid_parent_class = NULL;

VALA_EXTERN GType mail_composer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailComposer, g_object_unref)
VALA_EXTERN GType mail_web_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailWebView, g_object_unref)
VALA_EXTERN GType mail_composer_type_get_type (void) G_GNUC_CONST ;
static void mail_composer_on_add_attachment (MailComposer* self);
static void _mail_composer_on_add_attachment_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void mail_composer_on_insert_image (MailComposer* self);
static void _mail_composer_on_insert_image_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void mail_composer_on_insert_signature (MailComposer* self,
                                        GAction* action,
                                        GVariant* parameter);
static void _mail_composer_on_insert_signature_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self);
static void mail_composer_on_discard (MailComposer* self);
static void _mail_composer_on_discard_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void mail_composer_on_send (MailComposer* self);
static void _mail_composer_on_send_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self);
VALA_EXTERN MailComposer* mail_composer_new (const gchar* to,
                                 const gchar* mailto_query);
VALA_EXTERN MailComposer* mail_composer_construct (GType object_type,
                                       const gchar* to,
                                       const gchar* mailto_query);
VALA_EXTERN MailComposer* mail_composer_new_with_quote (MailComposerType type,
                                            CamelMessageInfo* info,
                                            CamelMimeMessage* message,
                                            const gchar* content);
VALA_EXTERN MailComposer* mail_composer_construct_with_quote (GType object_type,
                                                  MailComposerType type,
                                                  CamelMessageInfo* info,
                                                  CamelMimeMessage* message,
                                                  const gchar* content);
VALA_EXTERN void mail_composer_quote_content (MailComposer* self,
                                  MailComposerType type,
                                  CamelMessageInfo* info,
                                  CamelMimeMessage* message,
                                  const gchar* content_to_quote);
static void mail_composer_on_sanitize_recipient_entry (MailComposer* self,
                                                GtkEntry* entry);
static MailComposerAttachment* mail_composer_attachment_new (GFile* file,
                                                      const gchar* disposition);
static MailComposerAttachment* mail_composer_attachment_construct (GType object_type,
                                                            GFile* file,
                                                            const gchar* disposition);
static GType mail_composer_attachment_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailComposerAttachment, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static inline void _g_slist_free__g_object_unref0_ (GSList* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda87_ (Block4Data* _data4_,
                  gint response);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
VALA_EXTERN void mail_web_view_add_internal_resource (MailWebView* self,
                                          const gchar* uri,
                                          GInputStream* data);
static const gchar* mail_composer_attachment_get_uri (MailComposerAttachment* self);
VALA_EXTERN void mail_web_view_execute_editor_command (MailWebView* self,
                                           const gchar* command,
                                           const gchar* argument);
static void ____lambda88_ (Block5Data* _data5_,
                    const gchar* uri);
static void _____lambda88__mail_web_view_image_removed (MailWebView* _sender,
                                                 const gchar* uri,
                                                 gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void ____lambda89_ (Block6Data* _data6_);
static void _____lambda89__gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self);
static void ___lambda87__gtk_native_dialog_response (GtkNativeDialog* _sender,
                                              gint response_id,
                                              gpointer self);
static void mail_composer_on_mouse_target_changed (MailComposer* self,
                                            WebKitWebView* web_view,
                                            WebKitHitTestResult* hit_test,
                                            guint mods);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static gboolean _____lambda98_ (Block8Data* _data8_,
                         GtkTreeModel* model,
                         GtkTreePath* path,
                         GtkTreeIter* iter);
static gboolean ______lambda98__gtk_tree_model_foreach_func (GtkTreeModel* model,
                                                      GtkTreePath* path,
                                                      GtkTreeIter* iter,
                                                      gpointer self);
VALA_EXTERN GType mail_backend_session_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailBackendSession, g_object_unref)
VALA_EXTERN MailBackendSession* mail_backend_session_get_default (void);
VALA_EXTERN ESource* mail_backend_session_ref_source (MailBackendSession* self,
                                          const gchar* source_uid);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static gboolean ________lambda99_ (Block9Data* _data9_,
                            GtkTreeModel* model,
                            GtkTreePath* path,
                            GtkTreeIter* iter);
static gboolean _________lambda99__gtk_tree_model_foreach_func (GtkTreeModel* model,
                                                         GtkTreePath* path,
                                                         GtkTreeIter* iter,
                                                         gpointer self);
VALA_EXTERN void mail_web_view_set_content_of_element (MailWebView* self,
                                           const gchar* element,
                                           const gchar* content);
VALA_EXTERN gchar* mail_utils_get_reply_addresses (const gchar* raw_addresses,
                                       MailUtilsAcceptAddress should_add,
                                       gpointer should_add_target);
static gboolean ______lambda100_ (MailComposer* self,
                           const gchar* address);
static gboolean _______lambda100__mail_utils_accept_address (const gchar* address,
                                                      gpointer self);
static gboolean _______lambda101_ (MailComposer* self,
                            const gchar* address);
static gboolean ________lambda101__mail_utils_accept_address (const gchar* address,
                                                       gpointer self);
VALA_EXTERN gchar* mail_utils_escape_html_tags (const gchar* input);
static void mail_composer_get_attachments (MailComposer* self,
                                    CamelDataWrapper* message_content,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
static void mail_composer_get_attachments_finish (MailComposer* self,
                                           GAsyncResult* _res_);
static void mail_composer_get_attachments_data_free (gpointer _data);
static gboolean mail_composer_get_attachments_co (MailComposerGetAttachmentsData* _data_);
static void mail_composer_get_attachments_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void __lambda91_ (Block10Data* _data10_,
                  gint response);
static void ___lambda91__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
static void mail_composer_send_message (MailComposer* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
static void mail_composer_send_message_finish (MailComposer* self,
                                        GAsyncResult* _res_);
static void mail_composer_send_message_data_free (gpointer _data);
static gboolean mail_composer_send_message_co (MailComposerSendMessageData* _data_);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static void ___lambda92_ (Block12Data* _data12_,
                   gint response);
static void ____lambda92__gtk_dialog_response (GtkDialog* _sender,
                                        gint response_id,
                                        gpointer self);
VALA_EXTERN void mail_web_view_get_body_html (MailWebView* self,
                                  gboolean clean_for_sending,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
VALA_EXTERN gchar* mail_web_view_get_body_html_finish (MailWebView* self,
                                           GAsyncResult* _res_);
static void mail_composer_send_message_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
static CamelMimeMessage* mail_composer_build_message (MailComposer* self,
                                               const gchar* body_html);
static CamelInternetAddress* mail_composer_build_sender (MailComposer* self,
                                                  CamelMimeMessage* message,
                                                  const gchar* from);
static CamelInternetAddress* mail_composer_build_recipients (MailComposer* self,
                                                      CamelMimeMessage* message,
                                                      const gchar* to,
                                                      const gchar* cc,
                                                      const gchar* bcc);
static void mail_composer_remember_recipients (MailComposer* self,
                                        CamelInternetAddress* recipients,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static void mail_composer_remember_recipients_finish (MailComposer* self,
                                               GAsyncResult* _res_);
VALA_EXTERN void mail_backend_session_send_email (MailBackendSession* self,
                                      CamelMimeMessage* message,
                                      CamelInternetAddress* from,
                                      CamelAddress* recipients,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
VALA_EXTERN gboolean mail_backend_session_send_email_finish (MailBackendSession* self,
                                                 GAsyncResult* _res_,
                                                 GError** error);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static void ____lambda96_ (Block13Data* _data13_);
static void _____lambda96__gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
static void ___lambda97_ (Block14Data* _data14_);
static void ____lambda97__gtk_dialog_response (GtkDialog* _sender,
                                        gint response_id,
                                        gpointer self);
static CamelMimePart* mail_composer_attachment_get_mime_part (MailComposerAttachment* self);
static void mail_composer_remember_recipients_data_free (gpointer _data);
static gboolean mail_composer_remember_recipients_co (MailComposerRememberRecipientsData* _data_);
VALA_EXTERN GType mail_contact_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailContactManager, g_object_unref)
VALA_EXTERN MailContactManager* mail_contact_manager_get_default (void);
VALA_EXTERN void mail_contact_manager_remember_mail_address (MailContactManager* self,
                                                 const gchar* address,
                                                 const gchar* name,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
VALA_EXTERN void mail_contact_manager_remember_mail_address_finish (MailContactManager* self,
                                                        GAsyncResult* _res_);
static void mail_composer_remember_recipients_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void mail_composer_load_from_combobox (MailComposer* self);
VALA_EXTERN GeeArrayList* mail_backend_session_get_own_addresses (MailBackendSession* self);
static void mail_composer_populate_signature_menu (MailComposer* self,
                                            GMenu* menu);
static GVariant* _variant_new1 (const gchar* value);
VALA_EXTERN GList* mail_backend_session_get_all_signature_sources (MailBackendSession* self);
static GVariant* _variant_new2 (const gchar* value);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
VALA_EXTERN void mail_backend_session_get_signature_for_uid (MailBackendSession* self,
                                                 const gchar* uid,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
VALA_EXTERN gchar* mail_backend_session_get_signature_for_uid_finish (MailBackendSession* self,
                                                          GAsyncResult* _res_);
static void __lambda90_ (Block15Data* _data15_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda90__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void mail_composer_set_default_signature_for_sender (MailComposer* self);
VALA_EXTERN gchar* mail_backend_session_get_signature_uid_for_sender (MailBackendSession* self,
                                                          const gchar* sender);
static GVariant* _variant_new3 (gchar* value);
static void mail_composer_save_draft_data_free (gpointer _data);
VALA_EXTERN void mail_composer_save_draft (MailComposer* self,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
VALA_EXTERN gboolean mail_composer_save_draft_finish (MailComposer* self,
                                          GAsyncResult* _res_);
static gboolean mail_composer_save_draft_co (MailComposerSaveDraftData* _data_);
VALA_EXTERN gboolean mail_web_view_get_body_html_changed (MailWebView* self);
static void mail_composer_save_draft_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_);
VALA_EXTERN void mail_backend_session_save_draft (MailBackendSession* self,
                                      CamelMimeMessage* message,
                                      CamelInternetAddress* from,
                                      CamelAddress* recipients,
                                      CamelMessageInfo* ancestor_message_info,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
VALA_EXTERN void mail_backend_session_save_draft_finish (MailBackendSession* self,
                                             GAsyncResult* _res_,
                                             GError** error);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static void ____lambda102_ (Block16Data* _data16_);
static void _____lambda102__gtk_dialog_response (GtkDialog* _sender,
                                          gint response_id,
                                          gpointer self);
VALA_EXTERN gboolean mail_composer_get_has_recipients (MailComposer* self);
VALA_EXTERN void mail_composer_set_has_recipients (MailComposer* self,
                                       gboolean value);
VALA_EXTERN const gchar* mail_composer_get_to (MailComposer* self);
static void mail_composer_set_to (MailComposer* self,
                           const gchar* value);
VALA_EXTERN const gchar* mail_composer_get_mailto_query (MailComposer* self);
static void mail_composer_set_mailto_query (MailComposer* self,
                                     const gchar* value);
static GFile* mail_composer_attachment_get_file (MailComposerAttachment* self);
static const gchar* mail_composer_attachment_get_cid (MailComposerAttachment* self);
static const gchar* mail_composer_attachment_get_disposition (MailComposerAttachment* self);
static void mail_composer_attachment_set_file (MailComposerAttachment* self,
                                        GFile* value);
static void mail_composer_attachment_set_disposition (MailComposerAttachment* self,
                                               const gchar* value);
static void mail_composer_attachment_set_cid (MailComposerAttachment* self,
                                       const gchar* value);
static void mail_composer_attachment_set_uri (MailComposerAttachment* self,
                                       const gchar* value);
static GObject * mail_composer_attachment_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static void _mail_composer_attachment___lambda86_ (MailComposerAttachment* self);
static void __mail_composer_attachment___lambda86__gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self);
static void mail_composer_attachment_finalize (GObject * obj);
static GType mail_composer_attachment_get_type_once (void);
static void _vala_mail_composer_attachment_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_mail_composer_attachment_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static GType mail_composer_entry_grid_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailComposerEntryGrid, g_object_unref)
static MailComposerEntryGrid* mail_composer_entry_grid_new (void);
static MailComposerEntryGrid* mail_composer_entry_grid_construct (GType object_type);
static GType mail_composer_entry_grid_get_type_once (void);
static GObject * mail_composer_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
VALA_EXTERN GType mail_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailMainWindow, g_object_unref)
static void _mail_composer___lambda103_ (MailComposer* self);
static void __mail_composer___lambda103__gtk_editable_changed (GtkEditable* _sender,
                                                        gpointer self);
VALA_EXTERN MailWebView* mail_web_view_new (void);
VALA_EXTERN MailWebView* mail_web_view_construct (GType object_type);
VALA_EXTERN void mail_web_view_load_html (MailWebView* self,
                              const gchar* body);
static void _mail_composer_on_mouse_target_changed_webkit_web_view_mouse_target_changed (WebKitWebView* _sender,
                                                                                  WebKitHitTestResult* hit_test_result,
                                                                                  guint modifiers,
                                                                                  gpointer self);
VALA_EXTERN GType editor_toolbar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EditorToolbar, g_object_unref)
VALA_EXTERN EditorToolbar* editor_toolbar_new (MailWebView* web_view);
VALA_EXTERN EditorToolbar* editor_toolbar_construct (GType object_type,
                                         MailWebView* web_view);
static gboolean _mail_composer___lambda112_ (MailComposer* self);
static void __lambda113_ (MailComposer* self,
                   GObject* obj,
                   GAsyncResult* res);
static void ___lambda113__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static gboolean __mail_composer___lambda112__gtk_widget_delete_event (GtkWidget* _sender,
                                                               GdkEventAny* event,
                                                               gpointer self);
VALA_EXTERN void mail_contact_manager_setup_entry (MailContactManager* self,
                                       GtkEntry* entry);
static void _mail_composer___lambda114_ (MailComposer* self);
static void __mail_composer___lambda114__gtk_combo_box_changed (GtkComboBox* _sender,
                                                         gpointer self);
static void _mail_composer___lambda115_ (MailComposer* self);
static void __mail_composer___lambda115__gtk_button_clicked (GtkButton* _sender,
                                                      gpointer self);
static void _mail_composer___lambda116_ (MailComposer* self);
static void __mail_composer___lambda116__gtk_editable_changed (GtkEditable* _sender,
                                                        gpointer self);
static void _mail_composer___lambda117_ (Block17Data* _data17_);
static void __mail_composer___lambda117__gtk_button_clicked (GtkButton* _sender,
                                                      gpointer self);
static void _mail_composer___lambda118_ (Block17Data* _data17_);
static void __mail_composer___lambda118__gtk_editable_changed (GtkEditable* _sender,
                                                        gpointer self);
static void _mail_composer___lambda119_ (MailComposer* self);
static void __mail_composer___lambda119__gtk_combo_box_changed (GtkComboBox* _sender,
                                                         gpointer self);
static void _mail_composer___lambda120_ (MailComposer* self);
static void __mail_composer___lambda120__gtk_editable_changed (GtkEditable* _sender,
                                                        gpointer self);
static void _mail_composer___lambda121_ (Block17Data* _data17_);
static void __mail_composer___lambda121__gtk_style_context_changed (GtkStyleContext* _sender,
                                                             gpointer self);
static void _mail_composer___lambda122_ (Block17Data* _data17_);
static void __mail_composer___lambda122__mail_backend_session_signature_changed (MailBackendSession* _sender,
                                                                          gpointer self);
static void mail_composer_finalize (GObject * obj);
static GType mail_composer_get_type_once (void);
static void _vala_mail_composer_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_mail_composer_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GActionEntry MAIL_COMPOSER_ACTION_ENTRIES[5] = {{MAIL_COMPOSER_ACTION_ADD_ATTACHMENT, _mail_composer_on_add_attachment_gsimple_action_activate_callback}, {MAIL_COMPOSER_ACTION_INSERT_IMAGE, _mail_composer_on_insert_image_gsimple_action_activate_callback}, {MAIL_COMPOSER_ACTION_INSERT_SIGNATURE, _mail_composer_on_insert_signature_gsimple_action_activate_callback, "s"}, {MAIL_COMPOSER_ACTION_DISCARD, _mail_composer_on_discard_gsimple_action_activate_callback}, {MAIL_COMPOSER_ACTION_SEND, _mail_composer_on_send_gsimple_action_activate_callback}};

static inline gpointer
mail_composer_get_instance_private (MailComposer* self)
{
	return G_STRUCT_MEMBER_P (self, MailComposer_private_offset);
}

static GType
mail_composer_type_get_type_once (void)
{
	static const GEnumValue values[] = {{MAIL_COMPOSER_TYPE_REPLY, "MAIL_COMPOSER_TYPE_REPLY", "reply"}, {MAIL_COMPOSER_TYPE_REPLY_ALL, "MAIL_COMPOSER_TYPE_REPLY_ALL", "reply-all"}, {MAIL_COMPOSER_TYPE_FORWARD, "MAIL_COMPOSER_TYPE_FORWARD", "forward"}, {MAIL_COMPOSER_TYPE_DRAFT, "MAIL_COMPOSER_TYPE_DRAFT", "draft"}, {0, NULL, NULL}};
	GType mail_composer_type_type_id;
	mail_composer_type_type_id = g_enum_register_static ("MailComposerType", values);
	return mail_composer_type_type_id;
}

GType
mail_composer_type_get_type (void)
{
	static volatile gsize mail_composer_type_type_id__once = 0;
	if (g_once_init_enter (&mail_composer_type_type_id__once)) {
		GType mail_composer_type_type_id;
		mail_composer_type_type_id = mail_composer_type_get_type_once ();
		g_once_init_leave (&mail_composer_type_type_id__once, mail_composer_type_type_id);
	}
	return mail_composer_type_type_id__once;
}

static void
_mail_composer_on_add_attachment_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	mail_composer_on_add_attachment ((MailComposer*) self);
}

static void
_mail_composer_on_insert_image_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	mail_composer_on_insert_image ((MailComposer*) self);
}

static void
_mail_composer_on_insert_signature_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	mail_composer_on_insert_signature ((MailComposer*) self, action, parameter);
}

static void
_mail_composer_on_discard_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	mail_composer_on_discard ((MailComposer*) self);
}

static void
_mail_composer_on_send_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self)
{
	mail_composer_on_send ((MailComposer*) self);
}

MailComposer*
mail_composer_construct (GType object_type,
                         const gchar* to,
                         const gchar* mailto_query)
{
	MailComposer * self = NULL;
	self = (MailComposer*) g_object_new (object_type, "to", to, "mailto-query", mailto_query, NULL);
	return self;
}

MailComposer*
mail_composer_new (const gchar* to,
                   const gchar* mailto_query)
{
	return mail_composer_construct (MAIL_TYPE_COMPOSER, to, mailto_query);
}

MailComposer*
mail_composer_construct_with_quote (GType object_type,
                                    MailComposerType type,
                                    CamelMessageInfo* info,
                                    CamelMimeMessage* message,
                                    const gchar* content)
{
	MailComposer * self = NULL;
	g_return_val_if_fail (info != NULL, NULL);
	g_return_val_if_fail (message != NULL, NULL);
	self = (MailComposer*) g_object_new (object_type, "has-recipients", TRUE, NULL);
	mail_composer_quote_content (self, type, info, message, content);
	return self;
}

MailComposer*
mail_composer_new_with_quote (MailComposerType type,
                              CamelMessageInfo* info,
                              CamelMimeMessage* message,
                              const gchar* content)
{
	return mail_composer_construct_with_quote (MAIL_TYPE_COMPOSER, type, info, message, content);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
mail_composer_on_sanitize_recipient_entry (MailComposer* self,
                                           GtkEntry* entry)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = gtk_entry_get_text (entry);
	_tmp1_ = _tmp0_;
	if (g_strcmp0 (_tmp1_, "") == 0) {
		return;
	}
	_tmp2_ = gtk_entry_get_text (entry);
	_tmp3_ = _tmp2_;
	if (string_contains (_tmp3_, "\n")) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp4_ = gtk_entry_get_text (entry);
		_tmp5_ = _tmp4_;
		_tmp6_ = string_replace (_tmp5_, "\n", ", ");
		_tmp7_ = _tmp6_;
		gtk_entry_set_text (entry, _tmp7_);
		_g_free0 (_tmp7_);
	}
	_tmp8_ = gtk_entry_get_text (entry);
	_tmp9_ = _tmp8_;
	if (string_contains (_tmp9_, "\r")) {
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp10_ = gtk_entry_get_text (entry);
		_tmp11_ = _tmp10_;
		_tmp12_ = string_replace (_tmp11_, "\r", ", ");
		_tmp13_ = _tmp12_;
		gtk_entry_set_text (entry, _tmp13_);
		_g_free0 (_tmp13_);
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_slist_free__g_object_unref0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
mail_composer_on_add_attachment (MailComposer* self)
{
	GtkFileChooserNative* filechooser = NULL;
	GtkWidget* _tmp0_;
	GtkFileChooserNative* _tmp1_;
	GtkFileChooserNative* _tmp2_;
	GtkFileChooserNative* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp1_ = gtk_file_chooser_native_new (_ ("Choose a file"), G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_window_get_type (), GtkWindow), GTK_FILE_CHOOSER_ACTION_OPEN, _ ("Attach"), _ ("Cancel"));
	filechooser = _tmp1_;
	_tmp2_ = filechooser;
	if (gtk_native_dialog_run ((GtkNativeDialog*) _tmp2_) == ((gint) GTK_RESPONSE_ACCEPT)) {
		GtkFileChooserNative* _tmp3_;
		GtkFileChooserNative* _tmp4_;
		GSList* _tmp5_;
		GtkFlowBox* _tmp10_;
		_tmp3_ = filechooser;
		gtk_native_dialog_hide ((GtkNativeDialog*) _tmp3_);
		_tmp4_ = filechooser;
		_tmp5_ = gtk_file_chooser_get_files ((GtkFileChooser*) _tmp4_);
		{
			GSList* file_collection = NULL;
			GSList* file_it = NULL;
			file_collection = _tmp5_;
			for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
				GFile* file = NULL;
				file = (GFile*) file_it->data;
				{
					GtkFlowBox* _tmp6_;
					GFile* _tmp7_;
					MailComposerAttachment* _tmp8_;
					MailComposerAttachment* _tmp9_;
					_tmp6_ = self->priv->attachment_box;
					_tmp7_ = file;
					_tmp8_ = mail_composer_attachment_new (_tmp7_, MAIL_COMPOSER_ATTACHMENT_DISPOSITION_ATTACHMENT);
					g_object_ref_sink (_tmp8_);
					_tmp9_ = _tmp8_;
					gtk_container_add ((GtkContainer*) _tmp6_, (GtkWidget*) _tmp9_);
					_g_object_unref0 (_tmp9_);
				}
			}
			(file_collection == NULL) ? NULL : (file_collection = (_g_slist_free__g_object_unref0_ (file_collection), NULL));
		}
		_tmp10_ = self->priv->attachment_box;
		gtk_widget_show_all ((GtkWidget*) _tmp10_);
	}
	_tmp11_ = filechooser;
	gtk_native_dialog_destroy ((GtkNativeDialog*) _tmp11_);
	_g_object_unref0 (filechooser);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		MailComposer* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->filechooser);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		MailComposer* self;
		self = _data5_->_data4_->self;
		_g_object_unref0 (_data5_->attachment);
		block4_data_unref (_data5_->_data4_);
		_data5_->_data4_ = NULL;
		g_slice_free (Block5Data, _data5_);
	}
}

static void
____lambda88_ (Block5Data* _data5_,
               const gchar* uri)
{
	Block4Data* _data4_;
	MailComposer* self;
	MailComposerAttachment* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	_data4_ = _data5_->_data4_;
	self = _data4_->self;
	g_return_if_fail (uri != NULL);
	_tmp0_ = _data5_->attachment;
	_tmp1_ = mail_composer_attachment_get_uri (_tmp0_);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (uri, _tmp2_) == 0) {
		MailComposerAttachment* _tmp3_;
		MailWebView* _tmp4_;
		_tmp3_ = _data5_->attachment;
		gtk_widget_destroy ((GtkWidget*) _tmp3_);
		_tmp4_ = self->priv->web_view;
		g_signal_handler_disconnect ((GObject*) _tmp4_, _data5_->handler);
	}
}

static void
_____lambda88__mail_web_view_image_removed (MailWebView* _sender,
                                            const gchar* uri,
                                            gpointer self)
{
	____lambda88_ (self, uri);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		MailComposer* self;
		self = _data6_->_data4_->self;
		_g_object_unref0 (_data6_->error_dialog);
		block4_data_unref (_data6_->_data4_);
		_data6_->_data4_ = NULL;
		g_slice_free (Block6Data, _data6_);
	}
}

static void
____lambda89_ (Block6Data* _data6_)
{
	Block4Data* _data4_;
	MailComposer* self;
	GraniteMessageDialog* _tmp0_;
	_data4_ = _data6_->_data4_;
	self = _data4_->self;
	_tmp0_ = _data6_->error_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}

static void
_____lambda89__gtk_dialog_response (GtkDialog* _sender,
                                    gint response_id,
                                    gpointer self)
{
	____lambda89_ (self);
}

static void
__lambda87_ (Block4Data* _data4_,
             gint response)
{
	MailComposer* self;
	GError* _inner_error0_ = NULL;
	self = _data4_->self;
	if (response == ((gint) GTK_RESPONSE_ACCEPT)) {
		GFile* file = NULL;
		GFile* _tmp0_;
		_tmp0_ = gtk_file_chooser_get_file ((GtkFileChooser*) _data4_->filechooser);
		file = _tmp0_;
		{
			Block5Data* _data5_;
			GFileInputStream* inpustream = NULL;
			GFile* _tmp1_;
			GFileInputStream* _tmp2_;
			GFile* _tmp3_;
			MailComposerAttachment* _tmp4_;
			GtkFlowBox* _tmp5_;
			MailComposerAttachment* _tmp6_;
			MailWebView* _tmp7_;
			MailComposerAttachment* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			GFileInputStream* _tmp11_;
			MailWebView* _tmp12_;
			MailComposerAttachment* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			MailWebView* _tmp16_;
			gulong _tmp17_;
			_data5_ = g_slice_new0 (Block5Data);
			_data5_->_ref_count_ = 1;
			_data5_->_data4_ = block4_data_ref (_data4_);
			_tmp1_ = file;
			_tmp2_ = g_file_read (_tmp1_, NULL, &_inner_error0_);
			inpustream = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				block5_data_unref (_data5_);
				_data5_ = NULL;
				goto __catch0_g_error;
			}
			_tmp3_ = file;
			_tmp4_ = mail_composer_attachment_new (_tmp3_, MAIL_COMPOSER_ATTACHMENT_DISPOSITION_INLINE);
			g_object_ref_sink (_tmp4_);
			_data5_->attachment = _tmp4_;
			_tmp5_ = self->priv->attachment_box;
			_tmp6_ = _data5_->attachment;
			gtk_container_add ((GtkContainer*) _tmp5_, (GtkWidget*) _tmp6_);
			_tmp7_ = self->priv->web_view;
			_tmp8_ = _data5_->attachment;
			_tmp9_ = mail_composer_attachment_get_uri (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = inpustream;
			mail_web_view_add_internal_resource (_tmp7_, _tmp10_, (GInputStream*) _tmp11_);
			_tmp12_ = self->priv->web_view;
			_tmp13_ = _data5_->attachment;
			_tmp14_ = mail_composer_attachment_get_uri (_tmp13_);
			_tmp15_ = _tmp14_;
			mail_web_view_execute_editor_command (_tmp12_, "insertImage", _tmp15_);
			_data5_->handler = (gulong) 0;
			_tmp16_ = self->priv->web_view;
			_tmp17_ = g_signal_connect_data (_tmp16_, "image-removed", (GCallback) _____lambda88__mail_web_view_image_removed, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
			_data5_->handler = _tmp17_;
			_g_object_unref0 (inpustream);
			block5_data_unref (_data5_);
			_data5_ = NULL;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			Block6Data* _data6_;
			GThemedIcon* _tmp18_;
			GThemedIcon* _tmp19_;
			GThemedIcon* _tmp20_;
			GraniteMessageDialog* _tmp21_ = NULL;
			GraniteMessageDialog* _tmp22_;
			GraniteMessageDialog* _tmp23_;
			GError* _tmp24_;
			const gchar* _tmp25_;
			GraniteMessageDialog* _tmp26_;
			GraniteMessageDialog* _tmp27_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_data6_ = g_slice_new0 (Block6Data);
			_data6_->_ref_count_ = 1;
			_data6_->_data4_ = block4_data_ref (_data4_);
			_tmp18_ = (GThemedIcon*) g_themed_icon_new ("insert-image");
			_tmp19_ = _tmp18_;
			_tmp20_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
			_tmp21_ = granite_message_dialog_new (_ ("Unable to insert image"), _ ("There was an unexpected error while trying to insert the image."), (GIcon*) _tmp19_, GTK_BUTTONS_CLOSE);
			granite_message_dialog_set_badge_icon (_tmp21_, (GIcon*) _tmp20_);
			_g_object_unref0 (_tmp20_);
			g_object_ref_sink (_tmp21_);
			_tmp22_ = _tmp21_;
			_g_object_unref0 (_tmp19_);
			_data6_->error_dialog = _tmp22_;
			_tmp23_ = _data6_->error_dialog;
			_tmp24_ = e;
			_tmp25_ = _tmp24_->message;
			granite_message_dialog_show_error_details (_tmp23_, _tmp25_);
			_tmp26_ = _data6_->error_dialog;
			gtk_window_present ((GtkWindow*) _tmp26_);
			_tmp27_ = _data6_->error_dialog;
			g_signal_connect_data ((GtkDialog*) _tmp27_, "response", (GCallback) _____lambda89__gtk_dialog_response, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
			_g_error_free0 (e);
			block6_data_unref (_data6_);
			_data6_ = NULL;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_object_unref0 (file);
	}
	gtk_native_dialog_destroy ((GtkNativeDialog*) _data4_->filechooser);
}

static void
___lambda87__gtk_native_dialog_response (GtkNativeDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	__lambda87_ (self, response_id);
}

static void
mail_composer_on_insert_image (MailComposer* self)
{
	Block4Data* _data4_;
	GtkFileFilter* image_filter = NULL;
	GtkFileFilter* _tmp0_;
	GtkWidget* _tmp1_;
	GtkFileFilter* _tmp2_;
	GtkFileChooserNative* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp0_);
	image_filter = _tmp0_;
	gtk_file_filter_set_name (image_filter, _ ("Images"));
	gtk_file_filter_add_mime_type (image_filter, "image/*");
	_tmp1_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp2_ = _g_object_ref0 (image_filter);
	_tmp3_ = gtk_file_chooser_native_new (_ ("Choose an image"), G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow), GTK_FILE_CHOOSER_ACTION_OPEN, _ ("Insert"), _ ("Cancel"));
	gtk_file_chooser_set_filter ((GtkFileChooser*) _tmp3_, _tmp2_);
	_g_object_unref0 (_tmp2_);
	gtk_file_chooser_set_select_multiple ((GtkFileChooser*) _tmp3_, FALSE);
	_data4_->filechooser = _tmp3_;
	g_signal_connect_data ((GtkNativeDialog*) _data4_->filechooser, "response", (GCallback) ___lambda87__gtk_native_dialog_response, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	gtk_native_dialog_show ((GtkNativeDialog*) _data4_->filechooser);
	_g_object_unref0 (image_filter);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
mail_composer_on_mouse_target_changed (MailComposer* self,
                                       WebKitWebView* web_view,
                                       WebKitHitTestResult* hit_test,
                                       guint mods)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (web_view != NULL);
	g_return_if_fail (hit_test != NULL);
	if (webkit_hit_test_result_context_is_link (hit_test)) {
		gchar* url = NULL;
		const gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_ = NULL;
		const gchar* _tmp3_;
		gchar* hover_url = NULL;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp0_ = webkit_hit_test_result_get_link_uri (hit_test);
		_tmp1_ = g_strdup (_tmp0_);
		url = _tmp1_;
		_tmp3_ = url;
		if (_tmp3_ != NULL) {
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = url;
			_tmp5_ = g_uri_unescape_string (_tmp4_, NULL);
			_g_free0 (_tmp2_);
			_tmp2_ = _tmp5_;
		} else {
			_g_free0 (_tmp2_);
			_tmp2_ = NULL;
		}
		_tmp6_ = g_strdup (_tmp2_);
		hover_url = _tmp6_;
		_tmp7_ = hover_url;
		if (_tmp7_ == NULL) {
			GraniteWidgetsOverlayBar* _tmp8_;
			_tmp8_ = self->priv->message_url_overlay;
			gtk_widget_hide ((GtkWidget*) _tmp8_);
		} else {
			GraniteWidgetsOverlayBar* _tmp9_;
			const gchar* _tmp10_;
			GraniteWidgetsOverlayBar* _tmp11_;
			GraniteWidgetsOverlayBar* _tmp12_;
			_tmp9_ = self->priv->message_url_overlay;
			_tmp10_ = hover_url;
			granite_widgets_overlay_bar_set_label (_tmp9_, _tmp10_);
			_tmp11_ = self->priv->message_url_overlay;
			gtk_widget_set_no_show_all ((GtkWidget*) _tmp11_, FALSE);
			_tmp12_ = self->priv->message_url_overlay;
			gtk_widget_show_all ((GtkWidget*) _tmp12_);
		}
		_g_free0 (hover_url);
		_g_free0 (_tmp2_);
		_g_free0 (url);
	} else {
		GraniteWidgetsOverlayBar* _tmp13_;
		_tmp13_ = self->priv->message_url_overlay;
		gtk_widget_hide ((GtkWidget*) _tmp13_);
	}
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		MailComposer* self;
		self = _data7_->self;
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		MailComposer* self;
		self = _data8_->_data7_->self;
		block7_data_unref (_data8_->_data7_);
		_data8_->_data7_ = NULL;
		g_slice_free (Block8Data, _data8_);
	}
}

static gboolean
_____lambda98_ (Block8Data* _data8_,
                GtkTreeModel* model,
                GtkTreePath* path,
                GtkTreeIter* iter)
{
	Block7Data* _data7_;
	MailComposer* self;
	GValue value = {0};
	GtkTreeIter _tmp0_;
	GValue _tmp1_ = {0};
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean result;
	_data7_ = _data8_->_data7_;
	self = _data7_->self;
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	gtk_tree_model_get_value (model, &_tmp0_, 0, &_tmp1_);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	value = _tmp1_;
	_tmp2_ = g_value_get_string (&value);
	_tmp3_ = _data8_->address;
	if (g_strcmp0 (_tmp2_, _tmp3_) == 0) {
		GtkComboBoxText* _tmp4_;
		GtkTreeIter _tmp5_;
		_tmp4_ = self->priv->from_combo;
		_tmp5_ = *iter;
		gtk_combo_box_set_active_iter ((GtkComboBox*) _tmp4_, &_tmp5_);
		_data7_->found = TRUE;
		result = TRUE;
		G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
		return result;
	}
	result = FALSE;
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	return result;
}

static gboolean
______lambda98__gtk_tree_model_foreach_func (GtkTreeModel* model,
                                             GtkTreePath* path,
                                             GtkTreeIter* iter,
                                             gpointer self)
{
	gboolean result;
	result = _____lambda98_ (self, model, path, iter);
	return result;
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		MailComposer* self;
		self = _data9_->_data7_->self;
		_g_free0 (_data9_->identity_address);
		block7_data_unref (_data9_->_data7_);
		_data9_->_data7_ = NULL;
		g_slice_free (Block9Data, _data9_);
	}
}

static gboolean
________lambda99_ (Block9Data* _data9_,
                   GtkTreeModel* model,
                   GtkTreePath* path,
                   GtkTreeIter* iter)
{
	Block7Data* _data7_;
	MailComposer* self;
	GValue value = {0};
	GtkTreeIter _tmp0_;
	GValue _tmp1_ = {0};
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean result;
	_data7_ = _data9_->_data7_;
	self = _data7_->self;
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	gtk_tree_model_get_value (model, &_tmp0_, 0, &_tmp1_);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	value = _tmp1_;
	_tmp2_ = g_value_get_string (&value);
	_tmp3_ = _data9_->identity_address;
	if (g_strcmp0 (_tmp2_, _tmp3_) == 0) {
		GtkComboBoxText* _tmp4_;
		GtkTreeIter _tmp5_;
		_tmp4_ = self->priv->from_combo;
		_tmp5_ = *iter;
		gtk_combo_box_set_active_iter ((GtkComboBox*) _tmp4_, &_tmp5_);
		result = TRUE;
		G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
		return result;
	}
	result = FALSE;
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	return result;
}

static gboolean
_________lambda99__gtk_tree_model_foreach_func (GtkTreeModel* model,
                                                GtkTreePath* path,
                                                GtkTreeIter* iter,
                                                gpointer self)
{
	gboolean result;
	result = ________lambda99_ (self, model, path, iter);
	return result;
}

static gboolean
______lambda100_ (MailComposer* self,
                  const gchar* address)
{
	gboolean result;
	g_return_val_if_fail (address != NULL, FALSE);
	result = TRUE;
	return result;
}

static gboolean
_______lambda100__mail_utils_accept_address (const gchar* address,
                                             gpointer self)
{
	gboolean result;
	result = ______lambda100_ ((MailComposer*) self, address);
	return result;
}

static gboolean
_______lambda101_ (MailComposer* self,
                   const gchar* address)
{
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (address != NULL, FALSE);
	_tmp0_ = self->priv->to_val;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = _tmp1_;
	if (string_contains (_tmp2_, address)) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static gboolean
________lambda101__mail_utils_accept_address (const gchar* address,
                                              gpointer self)
{
	gboolean result;
	result = _______lambda101_ ((MailComposer*) self, address);
	return result;
}

void
mail_composer_quote_content (MailComposer* self,
                             MailComposerType type,
                             CamelMessageInfo* info,
                             CamelMimeMessage* message,
                             const gchar* content_to_quote)
{
	const gchar* _tmp0_;
	GtkComboBoxText* _tmp16_;
	GtkTreeModel* _tmp17_;
	GtkTreeModel* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = camel_mime_message_get_subject (message);
	if (_tmp0_ != NULL) {
		GtkEntry* _tmp1_;
		const gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = self->priv->subject_val;
		_tmp2_ = camel_mime_message_get_subject (message);
		gtk_entry_set_text (_tmp1_, _tmp2_);
		if (type == MAIL_COMPOSER_TYPE_REPLY) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = type == MAIL_COMPOSER_TYPE_REPLY_ALL;
		}
		if (_tmp3_) {
			GtkEntry* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			gboolean _tmp9_;
			_tmp4_ = self->priv->subject_val;
			_tmp5_ = gtk_entry_get_text (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_utf8_strup (_tmp6_, (gssize) -1);
			_tmp8_ = _tmp7_;
			_tmp9_ = !string_contains (_tmp8_, "RE: ");
			_g_free0 (_tmp8_);
			if (_tmp9_) {
				GtkEntry* _tmp10_;
				GtkEntry* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp10_ = self->priv->subject_val;
				_tmp11_ = self->priv->subject_val;
				_tmp12_ = gtk_entry_get_text (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = g_strdup_printf ("Re: %s", _tmp13_);
				_tmp15_ = _tmp14_;
				gtk_entry_set_text (_tmp10_, _tmp15_);
				_g_free0 (_tmp15_);
			}
		}
	}
	_tmp16_ = self->priv->from_combo;
	_tmp17_ = gtk_combo_box_get_model ((GtkComboBox*) _tmp16_);
	_tmp18_ = _tmp17_;
	if (gtk_tree_model_iter_n_children (_tmp18_, NULL) > 1) {
		Block7Data* _data7_;
		_data7_ = g_slice_new0 (Block7Data);
		_data7_->_ref_count_ = 1;
		_data7_->self = g_object_ref (self);
		_data7_->found = FALSE;
		if (type != MAIL_COMPOSER_TYPE_DRAFT) {
			Block8Data* _data8_;
			CamelInternetAddress* recipients = NULL;
			CamelInternetAddress* _tmp19_;
			CamelInternetAddress* to_recipients = NULL;
			CamelInternetAddress* _tmp20_;
			CamelInternetAddress* _tmp21_;
			CamelInternetAddress* cc_recipients = NULL;
			CamelInternetAddress* _tmp24_;
			CamelInternetAddress* _tmp25_;
			CamelInternetAddress* bcc_recipients = NULL;
			CamelInternetAddress* _tmp28_;
			CamelInternetAddress* _tmp29_;
			gint i = 0;
			_data8_ = g_slice_new0 (Block8Data);
			_data8_->_ref_count_ = 1;
			_data8_->_data7_ = block7_data_ref (_data7_);
			_tmp19_ = camel_internet_address_new ();
			recipients = _tmp19_;
			_tmp20_ = camel_mime_message_get_recipients (message, CAMEL_RECIPIENT_TYPE_TO);
			to_recipients = _tmp20_;
			_tmp21_ = to_recipients;
			if (_tmp21_ != NULL) {
				CamelInternetAddress* _tmp22_;
				CamelInternetAddress* _tmp23_;
				_tmp22_ = recipients;
				_tmp23_ = to_recipients;
				camel_address_cat ((CamelAddress*) _tmp22_, (CamelAddress*) _tmp23_);
			}
			_tmp24_ = camel_mime_message_get_recipients (message, CAMEL_RECIPIENT_TYPE_CC);
			cc_recipients = _tmp24_;
			_tmp25_ = cc_recipients;
			if (_tmp25_ != NULL) {
				CamelInternetAddress* _tmp26_;
				CamelInternetAddress* _tmp27_;
				_tmp26_ = recipients;
				_tmp27_ = cc_recipients;
				camel_address_cat ((CamelAddress*) _tmp26_, (CamelAddress*) _tmp27_);
			}
			_tmp28_ = camel_mime_message_get_recipients (message, CAMEL_RECIPIENT_TYPE_BCC);
			bcc_recipients = _tmp28_;
			_tmp29_ = bcc_recipients;
			if (_tmp29_ != NULL) {
				CamelInternetAddress* _tmp30_;
				CamelInternetAddress* _tmp31_;
				_tmp30_ = recipients;
				_tmp31_ = bcc_recipients;
				camel_address_cat ((CamelAddress*) _tmp30_, (CamelAddress*) _tmp31_);
			}
			i = 0;
			while (TRUE) {
				gboolean _tmp32_ = FALSE;
				CamelInternetAddress* _tmp33_;
				const gchar* _tmp34_ = NULL;
				gboolean _tmp35_;
				gint _tmp36_;
				GtkComboBoxText* _tmp37_;
				GtkTreeModel* _tmp38_;
				GtkTreeModel* _tmp39_;
				_tmp33_ = recipients;
				_tmp35_ = camel_internet_address_get (_tmp33_, i, NULL, &_tmp34_);
				_data8_->address = _tmp34_;
				if (_tmp35_) {
					_tmp32_ = !_data7_->found;
				} else {
					_tmp32_ = FALSE;
				}
				if (!_tmp32_) {
					break;
				}
				_tmp36_ = i;
				i = _tmp36_ + 1;
				_tmp37_ = self->priv->from_combo;
				_tmp38_ = gtk_combo_box_get_model ((GtkComboBox*) _tmp37_);
				_tmp39_ = _tmp38_;
				gtk_tree_model_foreach (_tmp39_, ______lambda98__gtk_tree_model_foreach_func, _data8_);
			}
			_g_object_unref0 (recipients);
			block8_data_unref (_data8_);
			_data8_ = NULL;
		}
		if (!_data7_->found) {
			MailBackendSession* session = NULL;
			MailBackendSession* _tmp40_;
			const gchar* account_source_uid = NULL;
			const gchar* _tmp41_;
			ESource* account_source = NULL;
			MailBackendSession* _tmp42_;
			const gchar* _tmp43_;
			ESource* _tmp44_;
			gboolean _tmp45_ = FALSE;
			ESource* _tmp46_;
			_tmp40_ = mail_backend_session_get_default ();
			session = _tmp40_;
			_tmp41_ = camel_mime_message_get_source (message);
			account_source_uid = _tmp41_;
			_tmp42_ = session;
			_tmp43_ = account_source_uid;
			_tmp44_ = mail_backend_session_ref_source (_tmp42_, _tmp43_);
			account_source = _tmp44_;
			_tmp46_ = account_source;
			if (_tmp46_ != NULL) {
				ESource* _tmp47_;
				_tmp47_ = account_source;
				_tmp45_ = e_source_has_extension (_tmp47_, E_SOURCE_EXTENSION_MAIL_ACCOUNT);
			} else {
				_tmp45_ = FALSE;
			}
			if (_tmp45_) {
				ESourceMailAccount* account_extension = NULL;
				ESource* _tmp48_;
				ESourceExtension* _tmp49_;
				gchar* identity_uid = NULL;
				ESourceMailAccount* _tmp50_;
				const gchar* _tmp51_;
				const gchar* _tmp52_;
				gchar* _tmp53_;
				gboolean _tmp54_ = FALSE;
				const gchar* _tmp55_;
				_tmp48_ = account_source;
				_tmp49_ = e_source_get_extension (_tmp48_, E_SOURCE_EXTENSION_MAIL_ACCOUNT);
				account_extension = G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, e_source_mail_account_get_type (), ESourceMailAccount);
				_tmp50_ = account_extension;
				_tmp51_ = e_source_mail_account_get_identity_uid (_tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = g_strdup (_tmp52_);
				identity_uid = _tmp53_;
				_tmp55_ = identity_uid;
				if (_tmp55_ != NULL) {
					const gchar* _tmp56_;
					_tmp56_ = identity_uid;
					_tmp54_ = g_strcmp0 (_tmp56_, "") != 0;
				} else {
					_tmp54_ = FALSE;
				}
				if (_tmp54_) {
					ESource* identity_source = NULL;
					MailBackendSession* _tmp57_;
					const gchar* _tmp58_;
					ESource* _tmp59_;
					gboolean _tmp60_ = FALSE;
					ESource* _tmp61_;
					_tmp57_ = session;
					_tmp58_ = identity_uid;
					_tmp59_ = mail_backend_session_ref_source (_tmp57_, _tmp58_);
					identity_source = _tmp59_;
					_tmp61_ = identity_source;
					if (_tmp61_ != NULL) {
						ESource* _tmp62_;
						_tmp62_ = identity_source;
						_tmp60_ = e_source_has_extension (_tmp62_, E_SOURCE_EXTENSION_MAIL_IDENTITY);
					} else {
						_tmp60_ = FALSE;
					}
					if (_tmp60_) {
						Block9Data* _data9_;
						ESourceMailIdentity* identity_extension = NULL;
						ESource* _tmp63_;
						ESourceExtension* _tmp64_;
						ESourceMailIdentity* _tmp65_;
						const gchar* _tmp66_;
						gchar* _tmp67_;
						const gchar* _tmp68_;
						_data9_ = g_slice_new0 (Block9Data);
						_data9_->_ref_count_ = 1;
						_data9_->_data7_ = block7_data_ref (_data7_);
						_tmp63_ = identity_source;
						_tmp64_ = e_source_get_extension (_tmp63_, E_SOURCE_EXTENSION_MAIL_IDENTITY);
						identity_extension = G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, e_source_mail_identity_get_type (), ESourceMailIdentity);
						_tmp65_ = identity_extension;
						_tmp66_ = e_source_mail_identity_get_address (_tmp65_);
						_tmp67_ = g_strdup (_tmp66_);
						_data9_->identity_address = _tmp67_;
						_tmp68_ = _data9_->identity_address;
						if (g_strcmp0 (_tmp68_, "") != 0) {
							GtkComboBoxText* _tmp69_;
							GtkTreeModel* _tmp70_;
							GtkTreeModel* _tmp71_;
							_tmp69_ = self->priv->from_combo;
							_tmp70_ = gtk_combo_box_get_model ((GtkComboBox*) _tmp69_);
							_tmp71_ = _tmp70_;
							gtk_tree_model_foreach (_tmp71_, _________lambda99__gtk_tree_model_foreach_func, _data9_);
						}
						block9_data_unref (_data9_);
						_data9_ = NULL;
					}
					_g_object_unref0 (identity_source);
				}
				_g_free0 (identity_uid);
			}
			_g_object_unref0 (account_source);
		}
		block7_data_unref (_data7_);
		_data7_ = NULL;
	}
	if (content_to_quote != NULL) {
		if (type == MAIL_COMPOSER_TYPE_DRAFT) {
			CamelMessageInfo* _tmp72_;
			CamelInternetAddress* to = NULL;
			CamelInternetAddress* _tmp75_;
			CamelInternetAddress* _tmp76_;
			CamelInternetAddress* cc = NULL;
			CamelInternetAddress* _tmp81_;
			CamelInternetAddress* _tmp82_;
			CamelInternetAddress* bcc = NULL;
			CamelInternetAddress* _tmp93_;
			CamelInternetAddress* _tmp94_;
			_tmp72_ = _g_object_ref0 (info);
			_g_object_unref0 (self->priv->ancestor_message_info);
			self->priv->ancestor_message_info = _tmp72_;
			if (string_contains (content_to_quote, "elementary-message-body")) {
				MailWebView* _tmp73_;
				_tmp73_ = self->priv->web_view;
				mail_web_view_set_content_of_element (_tmp73_, "body", content_to_quote);
			} else {
				MailWebView* _tmp74_;
				_tmp74_ = self->priv->web_view;
				mail_web_view_set_content_of_element (_tmp74_, "#elementary-message-body", content_to_quote);
			}
			_tmp75_ = camel_mime_message_get_recipients (message, CAMEL_RECIPIENT_TYPE_TO);
			to = _tmp75_;
			_tmp76_ = to;
			if (_tmp76_ != NULL) {
				GtkEntry* _tmp77_;
				CamelInternetAddress* _tmp78_;
				gchar* _tmp79_;
				gchar* _tmp80_;
				_tmp77_ = self->priv->to_val;
				_tmp78_ = to;
				_tmp79_ = camel_address_format ((CamelAddress*) _tmp78_);
				_tmp80_ = _tmp79_;
				gtk_entry_set_text (_tmp77_, _tmp80_);
				_g_free0 (_tmp80_);
			}
			_tmp81_ = camel_mime_message_get_recipients (message, CAMEL_RECIPIENT_TYPE_CC);
			cc = _tmp81_;
			_tmp82_ = cc;
			if (_tmp82_ != NULL) {
				GtkEntry* _tmp83_;
				CamelInternetAddress* _tmp84_;
				gchar* _tmp85_;
				gchar* _tmp86_;
				GtkEntry* _tmp87_;
				const gchar* _tmp88_;
				const gchar* _tmp89_;
				gint _tmp90_;
				gint _tmp91_;
				_tmp83_ = self->priv->cc_val;
				_tmp84_ = cc;
				_tmp85_ = camel_address_format ((CamelAddress*) _tmp84_);
				_tmp86_ = _tmp85_;
				gtk_entry_set_text (_tmp83_, _tmp86_);
				_g_free0 (_tmp86_);
				_tmp87_ = self->priv->cc_val;
				_tmp88_ = gtk_entry_get_text (_tmp87_);
				_tmp89_ = _tmp88_;
				_tmp90_ = strlen (_tmp89_);
				_tmp91_ = _tmp90_;
				if (_tmp91_ > 0) {
					GtkRevealer* _tmp92_;
					_tmp92_ = self->priv->cc_revealer;
					gtk_revealer_set_reveal_child (_tmp92_, TRUE);
				}
			}
			_tmp93_ = camel_mime_message_get_recipients (message, CAMEL_RECIPIENT_TYPE_BCC);
			bcc = _tmp93_;
			_tmp94_ = bcc;
			if (_tmp94_ != NULL) {
				GtkEntry* _tmp95_;
				CamelInternetAddress* _tmp96_;
				gchar* _tmp97_;
				gchar* _tmp98_;
				GtkEntry* _tmp99_;
				const gchar* _tmp100_;
				const gchar* _tmp101_;
				gint _tmp102_;
				gint _tmp103_;
				_tmp95_ = self->priv->bcc_val;
				_tmp96_ = bcc;
				_tmp97_ = camel_address_format ((CamelAddress*) _tmp96_);
				_tmp98_ = _tmp97_;
				gtk_entry_set_text (_tmp95_, _tmp98_);
				_g_free0 (_tmp98_);
				_tmp99_ = self->priv->bcc_val;
				_tmp100_ = gtk_entry_get_text (_tmp99_);
				_tmp101_ = _tmp100_;
				_tmp102_ = strlen (_tmp101_);
				_tmp103_ = _tmp102_;
				if (_tmp103_ > 0) {
					GtkRevealer* _tmp104_;
					_tmp104_ = self->priv->bcc_revealer;
					gtk_revealer_set_reveal_child (_tmp104_, TRUE);
				}
			}
		} else {
			gchar* message_content = NULL;
			gchar* _tmp105_;
			gchar* date_format = NULL;
			gchar* _tmp106_;
			gboolean _tmp107_ = FALSE;
			MailWebView* _tmp227_;
			const gchar* _tmp228_;
			_tmp105_ = g_strdup ("");
			message_content = _tmp105_;
			_tmp106_ = g_strdup (_ ("%a, %b %-e, %Y at %-l:%M %p"));
			date_format = _tmp106_;
			if (type == MAIL_COMPOSER_TYPE_REPLY) {
				_tmp107_ = TRUE;
			} else {
				_tmp107_ = type == MAIL_COMPOSER_TYPE_REPLY_ALL;
			}
			if (_tmp107_) {
				CamelInternetAddress* reply_to = NULL;
				CamelInternetAddress* _tmp108_;
				CamelInternetAddress* _tmp109_;
				CamelInternetAddress* _tmp110_;
				gchar* when = NULL;
				gint64 _tmp144_;
				gint64 _tmp145_;
				GDateTime* _tmp146_;
				GDateTime* _tmp147_;
				const gchar* _tmp148_;
				gchar* _tmp149_;
				gchar* _tmp150_;
				gchar* who = NULL;
				CamelInternetAddress* _tmp151_;
				gchar* _tmp152_;
				gchar* _tmp153_;
				gchar* _tmp154_;
				gchar* _tmp155_;
				const gchar* _tmp156_;
				const gchar* _tmp157_;
				const gchar* _tmp158_;
				gchar* _tmp159_;
				gchar* _tmp160_;
				gchar* _tmp161_;
				const gchar* _tmp162_;
				gchar* _tmp163_;
				const gchar* _tmp164_;
				gchar* _tmp165_;
				gchar* _tmp166_;
				gchar* _tmp167_;
				_tmp108_ = camel_mime_message_get_reply_to (message);
				_tmp109_ = _g_object_ref0 (_tmp108_);
				reply_to = _tmp109_;
				_tmp110_ = reply_to;
				if (_tmp110_ != NULL) {
					GtkEntry* _tmp111_;
					CamelInternetAddress* _tmp112_;
					gchar* _tmp113_;
					gchar* _tmp114_;
					_tmp111_ = self->priv->to_val;
					_tmp112_ = reply_to;
					_tmp113_ = camel_address_format ((CamelAddress*) _tmp112_);
					_tmp114_ = _tmp113_;
					gtk_entry_set_text (_tmp111_, _tmp114_);
					_g_free0 (_tmp114_);
				} else {
					GtkEntry* _tmp115_;
					CamelInternetAddress* _tmp116_;
					gchar* _tmp117_;
					gchar* _tmp118_;
					_tmp115_ = self->priv->to_val;
					_tmp116_ = camel_mime_message_get_from (message);
					_tmp117_ = camel_address_format ((CamelAddress*) _tmp116_);
					_tmp118_ = _tmp117_;
					gtk_entry_set_text (_tmp115_, _tmp118_);
					_g_free0 (_tmp118_);
				}
				if (type == MAIL_COMPOSER_TYPE_REPLY_ALL) {
					gchar* to_addresses = NULL;
					const gchar* _tmp119_;
					const gchar* _tmp120_;
					gchar* _tmp121_;
					GtkEntry* _tmp122_;
					GtkEntry* _tmp123_;
					const gchar* _tmp124_;
					const gchar* _tmp125_;
					const gchar* _tmp126_;
					gchar* _tmp127_;
					gchar* _tmp128_;
					gchar* _tmp129_;
					gchar* _tmp130_;
					const gchar* _tmp131_;
					const gchar* _tmp132_;
					_tmp119_ = camel_message_info_get_to (info);
					_tmp120_ = _tmp119_;
					_tmp121_ = mail_utils_get_reply_addresses (_tmp120_, _______lambda100__mail_utils_accept_address, self);
					to_addresses = _tmp121_;
					_tmp122_ = self->priv->to_val;
					_tmp123_ = self->priv->to_val;
					_tmp124_ = gtk_entry_get_text (_tmp123_);
					_tmp125_ = _tmp124_;
					_tmp126_ = to_addresses;
					_tmp127_ = g_strdup_printf (", %s", _tmp126_);
					_tmp128_ = _tmp127_;
					_tmp129_ = g_strconcat (_tmp125_, _tmp128_, NULL);
					_tmp130_ = _tmp129_;
					gtk_entry_set_text (_tmp123_, _tmp130_);
					_g_free0 (_tmp130_);
					_g_free0 (_tmp128_);
					_tmp131_ = camel_message_info_get_cc (info);
					_tmp132_ = _tmp131_;
					if (_tmp132_ != NULL) {
						GtkEntry* _tmp133_;
						const gchar* _tmp134_;
						const gchar* _tmp135_;
						gchar* _tmp136_;
						gchar* _tmp137_;
						GtkEntry* _tmp138_;
						const gchar* _tmp139_;
						const gchar* _tmp140_;
						gint _tmp141_;
						gint _tmp142_;
						_tmp133_ = self->priv->cc_val;
						_tmp134_ = camel_message_info_get_cc (info);
						_tmp135_ = _tmp134_;
						_tmp136_ = mail_utils_get_reply_addresses (_tmp135_, ________lambda101__mail_utils_accept_address, self);
						_tmp137_ = _tmp136_;
						gtk_entry_set_text (_tmp133_, _tmp137_);
						_g_free0 (_tmp137_);
						_tmp138_ = self->priv->cc_val;
						_tmp139_ = gtk_entry_get_text (_tmp138_);
						_tmp140_ = _tmp139_;
						_tmp141_ = strlen (_tmp140_);
						_tmp142_ = _tmp141_;
						if (_tmp142_ > 0) {
							GtkRevealer* _tmp143_;
							_tmp143_ = self->priv->cc_revealer;
							gtk_revealer_set_reveal_child (_tmp143_, TRUE);
						}
					}
					_g_free0 (to_addresses);
				}
				_tmp144_ = camel_message_info_get_date_received (info);
				_tmp145_ = _tmp144_;
				_tmp146_ = g_date_time_new_from_unix_utc (_tmp145_);
				_tmp147_ = _tmp146_;
				_tmp148_ = date_format;
				_tmp149_ = g_date_time_format (_tmp147_, _tmp148_);
				_tmp150_ = _tmp149_;
				_g_date_time_unref0 (_tmp147_);
				when = _tmp150_;
				_tmp151_ = camel_mime_message_get_from (message);
				_tmp152_ = camel_address_format ((CamelAddress*) _tmp151_);
				_tmp153_ = _tmp152_;
				_tmp154_ = mail_utils_escape_html_tags (_tmp153_);
				_tmp155_ = _tmp154_;
				_g_free0 (_tmp153_);
				who = _tmp155_;
				_tmp156_ = message_content;
				_tmp157_ = when;
				_tmp158_ = who;
				_tmp159_ = g_strdup_printf (_ ("On %1$s, %2$s wrote:"), _tmp157_, _tmp158_);
				_tmp160_ = _tmp159_;
				_tmp161_ = g_strconcat (_tmp156_, _tmp160_, NULL);
				_g_free0 (message_content);
				message_content = _tmp161_;
				_g_free0 (_tmp160_);
				_tmp162_ = message_content;
				_tmp163_ = g_strconcat (_tmp162_, "<br/>", NULL);
				_g_free0 (message_content);
				message_content = _tmp163_;
				_tmp164_ = message_content;
				_tmp165_ = g_strdup_printf ("<blockquote type=\"cite\">%s</blockquote>", content_to_quote);
				_tmp166_ = _tmp165_;
				_tmp167_ = g_strconcat (_tmp164_, _tmp166_, NULL);
				_g_free0 (message_content);
				message_content = _tmp167_;
				_g_free0 (_tmp166_);
				_g_free0 (who);
				_g_free0 (when);
				_g_object_unref0 (reply_to);
			} else {
				if (type == MAIL_COMPOSER_TYPE_FORWARD) {
					const gchar* _tmp168_;
					gchar* _tmp169_;
					const gchar* _tmp170_;
					gchar* _tmp171_;
					const gchar* _tmp172_;
					CamelInternetAddress* _tmp173_;
					gchar* _tmp174_;
					gchar* _tmp175_;
					gchar* _tmp176_;
					gchar* _tmp177_;
					gchar* _tmp178_;
					gchar* _tmp179_;
					gchar* _tmp180_;
					const gchar* _tmp181_;
					const gchar* _tmp182_;
					const gchar* _tmp183_;
					gchar* _tmp184_;
					gchar* _tmp185_;
					gchar* _tmp186_;
					gchar* _tmp187_;
					gchar* _tmp188_;
					const gchar* _tmp189_;
					gint64 _tmp190_;
					gint64 _tmp191_;
					GDateTime* _tmp192_;
					GDateTime* _tmp193_;
					const gchar* _tmp194_;
					gchar* _tmp195_;
					gchar* _tmp196_;
					gchar* _tmp197_;
					gchar* _tmp198_;
					gchar* _tmp199_;
					const gchar* _tmp200_;
					const gchar* _tmp201_;
					const gchar* _tmp202_;
					gchar* _tmp203_;
					gchar* _tmp204_;
					gchar* _tmp205_;
					gchar* _tmp206_;
					gchar* _tmp207_;
					gboolean _tmp208_ = FALSE;
					const gchar* _tmp209_;
					const gchar* _tmp210_;
					const gchar* _tmp221_;
					gchar* _tmp222_;
					const gchar* _tmp223_;
					gchar* _tmp224_;
					_tmp168_ = message_content;
					_tmp169_ = g_strconcat (_tmp168_, _ ("---------- Forwarded message ----------"), NULL);
					_g_free0 (message_content);
					message_content = _tmp169_;
					_tmp170_ = message_content;
					_tmp171_ = g_strconcat (_tmp170_, "<br/><br/>", NULL);
					_g_free0 (message_content);
					message_content = _tmp171_;
					_tmp172_ = message_content;
					_tmp173_ = camel_mime_message_get_from (message);
					_tmp174_ = camel_address_format ((CamelAddress*) _tmp173_);
					_tmp175_ = _tmp174_;
					_tmp176_ = mail_utils_escape_html_tags (_tmp175_);
					_tmp177_ = _tmp176_;
					_tmp178_ = g_strdup_printf (_ ("From: %s<br/>"), _tmp177_);
					_tmp179_ = _tmp178_;
					_tmp180_ = g_strconcat (_tmp172_, _tmp179_, NULL);
					_g_free0 (message_content);
					message_content = _tmp180_;
					_g_free0 (_tmp179_);
					_g_free0 (_tmp177_);
					_g_free0 (_tmp175_);
					_tmp181_ = message_content;
					_tmp182_ = camel_message_info_get_subject (info);
					_tmp183_ = _tmp182_;
					_tmp184_ = mail_utils_escape_html_tags (_tmp183_);
					_tmp185_ = _tmp184_;
					_tmp186_ = g_strdup_printf (_ ("Subject: %s<br/>"), _tmp185_);
					_tmp187_ = _tmp186_;
					_tmp188_ = g_strconcat (_tmp181_, _tmp187_, NULL);
					_g_free0 (message_content);
					message_content = _tmp188_;
					_g_free0 (_tmp187_);
					_g_free0 (_tmp185_);
					_tmp189_ = message_content;
					_tmp190_ = camel_message_info_get_date_received (info);
					_tmp191_ = _tmp190_;
					_tmp192_ = g_date_time_new_from_unix_utc (_tmp191_);
					_tmp193_ = _tmp192_;
					_tmp194_ = date_format;
					_tmp195_ = g_date_time_format (_tmp193_, _tmp194_);
					_tmp196_ = _tmp195_;
					_tmp197_ = g_strdup_printf (_ ("Date: %s<br/>"), _tmp196_);
					_tmp198_ = _tmp197_;
					_tmp199_ = g_strconcat (_tmp189_, _tmp198_, NULL);
					_g_free0 (message_content);
					message_content = _tmp199_;
					_g_free0 (_tmp198_);
					_g_free0 (_tmp196_);
					_g_date_time_unref0 (_tmp193_);
					_tmp200_ = message_content;
					_tmp201_ = camel_message_info_get_to (info);
					_tmp202_ = _tmp201_;
					_tmp203_ = mail_utils_escape_html_tags (_tmp202_);
					_tmp204_ = _tmp203_;
					_tmp205_ = g_strdup_printf (_ ("To: %s<br/>"), _tmp204_);
					_tmp206_ = _tmp205_;
					_tmp207_ = g_strconcat (_tmp200_, _tmp206_, NULL);
					_g_free0 (message_content);
					message_content = _tmp207_;
					_g_free0 (_tmp206_);
					_g_free0 (_tmp204_);
					_tmp209_ = camel_message_info_get_cc (info);
					_tmp210_ = _tmp209_;
					if (_tmp210_ != NULL) {
						const gchar* _tmp211_;
						const gchar* _tmp212_;
						_tmp211_ = camel_message_info_get_cc (info);
						_tmp212_ = _tmp211_;
						_tmp208_ = g_strcmp0 (_tmp212_, "") != 0;
					} else {
						_tmp208_ = FALSE;
					}
					if (_tmp208_) {
						const gchar* _tmp213_;
						const gchar* _tmp214_;
						const gchar* _tmp215_;
						gchar* _tmp216_;
						gchar* _tmp217_;
						gchar* _tmp218_;
						gchar* _tmp219_;
						gchar* _tmp220_;
						_tmp213_ = message_content;
						_tmp214_ = camel_message_info_get_cc (info);
						_tmp215_ = _tmp214_;
						_tmp216_ = mail_utils_escape_html_tags (_tmp215_);
						_tmp217_ = _tmp216_;
						_tmp218_ = g_strdup_printf (_ ("Cc: %s<br/>"), _tmp217_);
						_tmp219_ = _tmp218_;
						_tmp220_ = g_strconcat (_tmp213_, _tmp219_, NULL);
						_g_free0 (message_content);
						message_content = _tmp220_;
						_g_free0 (_tmp219_);
						_g_free0 (_tmp217_);
					}
					_tmp221_ = message_content;
					_tmp222_ = g_strconcat (_tmp221_, "<br/><br/>", NULL);
					_g_free0 (message_content);
					message_content = _tmp222_;
					_tmp223_ = message_content;
					_tmp224_ = g_strconcat (_tmp223_, content_to_quote, NULL);
					_g_free0 (message_content);
					message_content = _tmp224_;
					if (camel_mime_message_has_attachment (message)) {
						CamelDataWrapper* _tmp225_;
						CamelDataWrapper* _tmp226_;
						_tmp225_ = camel_medium_get_content ((CamelMedium*) message);
						_tmp226_ = _tmp225_;
						mail_composer_get_attachments (self, _tmp226_, NULL, NULL);
					}
				}
			}
			_tmp227_ = self->priv->web_view;
			_tmp228_ = message_content;
			mail_web_view_set_content_of_element (_tmp227_, "#elementary-message-quote", _tmp228_);
			_g_free0 (date_format);
			_g_free0 (message_content);
		}
	}
}

static void
mail_composer_get_attachments_data_free (gpointer _data)
{
	MailComposerGetAttachmentsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->message_content);
	_g_object_unref0 (_data_->self);
	g_slice_free (MailComposerGetAttachmentsData, _data_);
}

static void
mail_composer_get_attachments (MailComposer* self,
                               CamelDataWrapper* message_content,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	MailComposerGetAttachmentsData* _data_;
	MailComposer* _tmp0_;
	CamelDataWrapper* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message_content != NULL);
	_data_ = g_slice_new0 (MailComposerGetAttachmentsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_composer_get_attachments_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (message_content);
	_g_object_unref0 (_data_->message_content);
	_data_->message_content = _tmp1_;
	mail_composer_get_attachments_co (_data_);
}

static void
mail_composer_get_attachments_finish (MailComposer* self,
                                      GAsyncResult* _res_)
{
	MailComposerGetAttachmentsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
mail_composer_get_attachments_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	MailComposerGetAttachmentsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_composer_get_attachments_co (_data_);
}

static gboolean
mail_composer_get_attachments_co (MailComposerGetAttachmentsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->message_content, camel_multipart_get_type ())) {
		_data_->tmp_dir = NULL;
		_data_->content = G_TYPE_CHECK_INSTANCE_CAST (_data_->message_content, camel_multipart_get_type (), CamelMultipart);
		{
			_data_->i = (guint) 0;
			{
				_data_->_tmp0_ = TRUE;
				while (TRUE) {
					if (!_data_->_tmp0_) {
						_data_->_tmp1_ = _data_->i;
						_data_->i = _data_->_tmp1_ + 1;
					}
					_data_->_tmp0_ = FALSE;
					_data_->_tmp2_ = _data_->content;
					if (!(_data_->i < camel_multipart_get_number (_data_->_tmp2_))) {
						break;
					}
					_data_->_tmp3_ = _data_->content;
					_data_->_tmp4_ = camel_multipart_get_part (_data_->_tmp3_, _data_->i);
					_data_->part = _data_->_tmp4_;
					_data_->_tmp5_ = _data_->part;
					_data_->_tmp6_ = camel_data_wrapper_get_mime_type_field ((CamelDataWrapper*) _data_->_tmp5_);
					_data_->field = _data_->_tmp6_;
					_data_->_tmp7_ = _data_->part;
					_data_->_tmp8_ = camel_mime_part_get_content_disposition (_data_->_tmp7_);
					_data_->_tmp9_ = _data_->part;
					_data_->_tmp10_ = camel_mime_part_get_content_type (_data_->_tmp9_);
					if (camel_content_disposition_is_attachment (_data_->_tmp8_, _data_->_tmp10_)) {
						{
							_data_->_tmp11_ = _data_->tmp_dir;
							if (_data_->_tmp11_ == NULL) {
								_data_->_tmp13_ = g_dir_make_tmp (".XXXXXX", &_data_->_inner_error0_);
								_data_->_tmp12_ = _data_->_tmp13_;
								if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
									goto __catch0_g_error;
								}
								_data_->_tmp14_ = g_file_new_for_path (_data_->_tmp12_);
								_g_object_unref0 (_data_->tmp_dir);
								_data_->tmp_dir = _data_->_tmp14_;
								_g_free0 (_data_->_tmp12_);
							}
							_data_->_tmp15_ = _data_->tmp_dir;
							_data_->_tmp16_ = _data_->part;
							_data_->_tmp17_ = camel_mime_part_get_filename (_data_->_tmp16_);
							_data_->_tmp18_ = g_file_get_child (_data_->_tmp15_, _data_->_tmp17_);
							_data_->file = _data_->_tmp18_;
							_data_->_tmp19_ = _data_->file;
							if (!g_file_query_exists (_data_->_tmp19_, NULL)) {
								_data_->_tmp20_ = _data_->file;
								_data_->_state_ = 1;
								g_file_create_async (_data_->_tmp20_, G_FILE_CREATE_NONE, G_PRIORITY_DEFAULT, NULL, mail_composer_get_attachments_ready, _data_);
								return FALSE;
								_state_1:
								_data_->_tmp21_ = g_file_create_finish (_data_->_tmp20_, _data_->_res_, &_data_->_inner_error0_);
								_data_->output_stream = _data_->_tmp21_;
								if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
									_g_object_unref0 (_data_->file);
									goto __catch0_g_error;
								}
								_data_->_tmp22_ = _data_->part;
								_data_->_tmp23_ = camel_medium_get_content ((CamelMedium*) _data_->_tmp22_);
								_data_->_tmp24_ = _data_->_tmp23_;
								_data_->_tmp25_ = _data_->output_stream;
								_data_->_state_ = 2;
								camel_data_wrapper_decode_to_output_stream (_data_->_tmp24_, (GOutputStream*) _data_->_tmp25_, G_PRIORITY_DEFAULT, NULL, mail_composer_get_attachments_ready, _data_);
								return FALSE;
								_state_2:
								camel_data_wrapper_decode_to_output_stream_finish (_data_->_tmp24_, _data_->_res_, &_data_->_inner_error0_);
								if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
									_g_object_unref0 (_data_->output_stream);
									_g_object_unref0 (_data_->file);
									goto __catch0_g_error;
								}
								_g_object_unref0 (_data_->output_stream);
							}
							_data_->_tmp26_ = _data_->self->priv->attachment_box;
							_data_->_tmp27_ = _data_->file;
							_data_->_tmp28_ = mail_composer_attachment_new (_data_->_tmp27_, MAIL_COMPOSER_ATTACHMENT_DISPOSITION_ATTACHMENT);
							g_object_ref_sink (_data_->_tmp28_);
							_data_->_tmp29_ = _data_->_tmp28_;
							gtk_container_add ((GtkContainer*) _data_->_tmp26_, (GtkWidget*) _data_->_tmp29_);
							_g_object_unref0 (_data_->_tmp29_);
							_data_->_tmp30_ = _data_->self->priv->attachment_box;
							gtk_widget_show_all ((GtkWidget*) _data_->_tmp30_);
							_g_object_unref0 (_data_->file);
						}
						goto __finally0;
						__catch0_g_error:
						{
							_data_->e = _data_->_inner_error0_;
							_data_->_inner_error0_ = NULL;
							_data_->_tmp31_ = _data_->e;
							_data_->_tmp32_ = _data_->_tmp31_->message;
							g_critical ("Composer.vala:746: %s", _data_->_tmp32_);
							_g_error_free0 (_data_->e);
						}
						__finally0:
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
							_g_object_unref0 (_data_->tmp_dir);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
							g_clear_error (&_data_->_inner_error0_);
							g_object_unref (_data_->_async_result);
							return FALSE;
						}
					} else {
						_data_->_tmp33_ = _data_->field;
						_data_->_tmp34_ = _data_->_tmp33_->type;
						if (g_strcmp0 (_data_->_tmp34_, "multipart") == 0) {
							_data_->_tmp35_ = _data_->part;
							_data_->_tmp36_ = camel_medium_get_content ((CamelMedium*) _data_->_tmp35_);
							_data_->_tmp37_ = _data_->_tmp36_;
							_data_->_state_ = 3;
							mail_composer_get_attachments (_data_->self, _data_->_tmp37_, mail_composer_get_attachments_ready, _data_);
							return FALSE;
							_state_3:
							mail_composer_get_attachments_finish (_data_->self, _data_->_res_);
						}
					}
				}
			}
		}
		_g_object_unref0 (_data_->tmp_dir);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		MailComposer* self;
		self = _data10_->self;
		_g_object_unref0 (_data10_->discard_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static void
__lambda91_ (Block10Data* _data10_,
             gint response)
{
	MailComposer* self;
	self = _data10_->self;
	if (response == ((gint) GTK_RESPONSE_ACCEPT)) {
		self->priv->discard_draft = TRUE;
		g_signal_emit (self, mail_composer_signals[MAIL_COMPOSER_FINISHED_SIGNAL], 0);
		gtk_window_close ((GtkWindow*) self);
	}
	gtk_widget_destroy ((GtkWidget*) _data10_->discard_dialog);
}

static void
___lambda91__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda91_ (self, response_id);
}

static void
mail_composer_on_discard (MailComposer* self)
{
	Block10Data* _data10_;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	GThemedIcon* _tmp2_;
	GtkWindow* _tmp3_;
	GraniteMessageDialog* _tmp4_ = NULL;
	GraniteMessageDialog* _tmp5_;
	GtkWidget* discard_anyway = NULL;
	GtkWidget* _tmp6_;
	GtkWidget* _tmp7_;
	GtkStyleContext* _tmp8_;
	g_return_if_fail (self != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("mail-drafts");
	_tmp1_ = _tmp0_;
	_tmp2_ = (GThemedIcon*) g_themed_icon_new ("edit-delete");
	_tmp3_ = _g_object_ref0 ((GtkWindow*) self);
	_tmp4_ = granite_message_dialog_new (_ ("Permanently delete this draft?"), _ ("You cannot undo this action, nor recover your draft once it has been d" \
"eleted."), (GIcon*) _tmp1_, GTK_BUTTONS_NONE);
	granite_message_dialog_set_badge_icon (_tmp4_, (GIcon*) _tmp2_);
	_g_object_unref0 (_tmp2_);
	gtk_window_set_transient_for ((GtkWindow*) _tmp4_, _tmp3_);
	_g_object_unref0 (_tmp3_);
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp1_);
	_data10_->discard_dialog = _tmp5_;
	gtk_dialog_add_button ((GtkDialog*) _data10_->discard_dialog, _ ("Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_tmp6_ = gtk_dialog_add_button ((GtkDialog*) _data10_->discard_dialog, _ ("Delete Draft"), (gint) GTK_RESPONSE_ACCEPT);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	discard_anyway = _tmp7_;
	_tmp8_ = gtk_widget_get_style_context (discard_anyway);
	gtk_style_context_add_class (_tmp8_, GTK_STYLE_CLASS_DESTRUCTIVE_ACTION);
	gtk_window_present ((GtkWindow*) _data10_->discard_dialog);
	g_signal_connect_data ((GtkDialog*) _data10_->discard_dialog, "response", (GCallback) ___lambda91__gtk_dialog_response, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	_g_object_unref0 (discard_anyway);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}

static void
mail_composer_on_send (MailComposer* self)
{
	g_return_if_fail (self != NULL);
	mail_composer_send_message (self, NULL, NULL);
}

static void
mail_composer_send_message_data_free (gpointer _data)
{
	MailComposerSendMessageData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MailComposerSendMessageData, _data_);
}

static void
mail_composer_send_message (MailComposer* self,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	MailComposerSendMessageData* _data_;
	MailComposer* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (MailComposerSendMessageData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_composer_send_message_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	mail_composer_send_message_co (_data_);
}

static void
mail_composer_send_message_finish (MailComposer* self,
                                   GAsyncResult* _res_)
{
	MailComposerSendMessageData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		MailComposer* self;
		self = _data11_->self;
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		MailComposer* self;
		self = _data12_->_data11_->self;
		_g_object_unref0 (_data12_->no_subject_dialog);
		block11_data_unref (_data12_->_data11_);
		_data12_->_data11_ = NULL;
		g_slice_free (Block12Data, _data12_);
	}
}

static void
___lambda92_ (Block12Data* _data12_,
              gint response)
{
	Block11Data* _data11_;
	MailComposer* self;
	GraniteMessageDialog* _tmp0_;
	_data11_ = _data12_->_data11_;
	self = _data11_->self;
	_tmp0_ = _data12_->no_subject_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
	if (response == ((gint) GTK_RESPONSE_CANCEL)) {
		gtk_widget_set_sensitive ((GtkWidget*) self, TRUE);
		return;
	}
	mail_composer_send_message_co (_data11_->_async_data_);
}

static void
____lambda92__gtk_dialog_response (GtkDialog* _sender,
                                   gint response_id,
                                   gpointer self)
{
	___lambda92_ (self, response_id);
}

static void
mail_composer_send_message_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	MailComposerSendMessageData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_composer_send_message_co (_data_);
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		MailComposer* self;
		self = _data13_->_data11_->self;
		_g_object_unref0 (_data13_->warning_dialog);
		block11_data_unref (_data13_->_data11_);
		_data13_->_data11_ = NULL;
		g_slice_free (Block13Data, _data13_);
	}
}

static void
____lambda96_ (Block13Data* _data13_)
{
	Block11Data* _data11_;
	MailComposer* self;
	GraniteMessageDialog* _tmp0_;
	_data11_ = _data13_->_data11_;
	self = _data11_->self;
	_tmp0_ = _data13_->warning_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}

static void
_____lambda96__gtk_dialog_response (GtkDialog* _sender,
                                    gint response_id,
                                    gpointer self)
{
	____lambda96_ (self);
}

static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}

static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		MailComposer* self;
		self = _data14_->_data11_->self;
		_g_object_unref0 (_data14_->error_dialog);
		block11_data_unref (_data14_->_data11_);
		_data14_->_data11_ = NULL;
		g_slice_free (Block14Data, _data14_);
	}
}

static void
___lambda97_ (Block14Data* _data14_)
{
	Block11Data* _data11_;
	MailComposer* self;
	GraniteMessageDialog* _tmp0_;
	_data11_ = _data14_->_data11_;
	self = _data11_->self;
	_tmp0_ = _data14_->error_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}

static void
____lambda97__gtk_dialog_response (GtkDialog* _sender,
                                   gint response_id,
                                   gpointer self)
{
	___lambda97_ (self);
}

static gboolean
mail_composer_send_message_co (MailComposerSendMessageData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data11_ = g_slice_new0 (Block11Data);
	_data_->_data11_->_ref_count_ = 1;
	_data_->_data11_->self = g_object_ref (_data_->self);
	_data_->_data11_->_async_data_ = _data_;
	gtk_widget_set_sensitive ((GtkWidget*) _data_->self, FALSE);
	_data_->_tmp0_ = _data_->self->priv->subject_val;
	_data_->_tmp1_ = gtk_entry_get_text (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	if (g_strcmp0 (_data_->_tmp2_, "") == 0) {
		_data_->_data12_ = g_slice_new0 (Block12Data);
		_data_->_data12_->_ref_count_ = 1;
		_data_->_data12_->_data11_ = block11_data_ref (_data_->_data11_);
		_data_->_tmp3_ = granite_message_dialog_new_with_image_from_icon_name (_ ("Send without subject?"), _ ("This message has an empty subject field. The recipient may be unable t" \
"o infer its scope or importance."), "mail-send", GTK_BUTTONS_NONE);
		g_object_ref_sink (_data_->_tmp3_);
		_data_->_data12_->no_subject_dialog = _data_->_tmp3_;
		_data_->_tmp4_ = _data_->_data12_->no_subject_dialog;
		gtk_window_set_modal ((GtkWindow*) _data_->_tmp4_, TRUE);
		_data_->_tmp5_ = _data_->_data12_->no_subject_dialog;
		gtk_window_set_transient_for ((GtkWindow*) _data_->_tmp5_, (GtkWindow*) _data_->self);
		_data_->_tmp6_ = _data_->_data12_->no_subject_dialog;
		gtk_dialog_add_button ((GtkDialog*) _data_->_tmp6_, _ ("Don't Send"), (gint) GTK_RESPONSE_CANCEL);
		_data_->_tmp7_ = _data_->_data12_->no_subject_dialog;
		_data_->_tmp8_ = gtk_dialog_add_button ((GtkDialog*) _data_->_tmp7_, _ ("Send Anyway"), (gint) GTK_RESPONSE_ACCEPT);
		_data_->_tmp9_ = _g_object_ref0 (_data_->_tmp8_);
		_data_->send_anyway = _data_->_tmp9_;
		_data_->_tmp10_ = _data_->send_anyway;
		_data_->_tmp11_ = gtk_widget_get_style_context (_data_->_tmp10_);
		gtk_style_context_add_class (_data_->_tmp11_, GTK_STYLE_CLASS_DESTRUCTIVE_ACTION);
		_data_->_tmp12_ = _data_->_data12_->no_subject_dialog;
		gtk_window_present ((GtkWindow*) _data_->_tmp12_);
		_data_->_tmp13_ = _data_->_data12_->no_subject_dialog;
		g_signal_connect_data ((GtkDialog*) _data_->_tmp13_, "response", (GCallback) ____lambda92__gtk_dialog_response, block12_data_ref (_data_->_data12_), (GClosureNotify) block12_data_unref, 0);
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		_g_object_unref0 (_data_->send_anyway);
		block12_data_unref (_data_->_data12_);
		_data_->_data12_ = NULL;
	}
	_data_->_tmp14_ = mail_backend_session_get_default ();
	_data_->session = _data_->_tmp14_;
	_data_->_tmp15_ = _data_->self->priv->web_view;
	_data_->_state_ = 2;
	mail_web_view_get_body_html (_data_->_tmp15_, TRUE, mail_composer_send_message_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp16_ = mail_web_view_get_body_html_finish (_data_->_tmp15_, _data_->_res_);
	_data_->body_html = _data_->_tmp16_;
	_data_->_tmp17_ = mail_composer_build_message (_data_->self, _data_->body_html);
	_data_->message = _data_->_tmp17_;
	_data_->_tmp18_ = _data_->self->priv->from_combo;
	_data_->_tmp19_ = gtk_combo_box_text_get_active_text (_data_->_tmp18_);
	_data_->_tmp20_ = _data_->_tmp19_;
	_data_->_tmp21_ = mail_composer_build_sender (_data_->self, _data_->message, _data_->_tmp20_);
	_data_->_tmp22_ = _data_->_tmp21_;
	_g_free0 (_data_->_tmp20_);
	_data_->sender = _data_->_tmp22_;
	_data_->_tmp23_ = _data_->self->priv->to_val;
	_data_->_tmp24_ = gtk_entry_get_text (_data_->_tmp23_);
	_data_->_tmp25_ = _data_->_tmp24_;
	_data_->_tmp26_ = _data_->self->priv->cc_val;
	_data_->_tmp27_ = gtk_entry_get_text (_data_->_tmp26_);
	_data_->_tmp28_ = _data_->_tmp27_;
	_data_->_tmp29_ = _data_->self->priv->bcc_val;
	_data_->_tmp30_ = gtk_entry_get_text (_data_->_tmp29_);
	_data_->_tmp31_ = _data_->_tmp30_;
	_data_->_tmp32_ = mail_composer_build_recipients (_data_->self, _data_->message, _data_->_tmp25_, _data_->_tmp28_, _data_->_tmp31_);
	_data_->recipients = _data_->_tmp32_;
	mail_composer_remember_recipients (_data_->self, _data_->recipients, NULL, NULL);
	{
		_data_->_state_ = 3;
		mail_backend_session_send_email (_data_->session, _data_->message, _data_->sender, (CamelAddress*) _data_->recipients, mail_composer_send_message_ready, _data_);
		return FALSE;
		_state_3:
		_data_->sent_message_saved = mail_backend_session_send_email_finish (_data_->session, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (!_data_->sent_message_saved) {
			_data_->_data13_ = g_slice_new0 (Block13Data);
			_data_->_data13_->_ref_count_ = 1;
			_data_->_data13_->_data11_ = block11_data_ref (_data_->_data11_);
			_data_->_tmp33_ = (GThemedIcon*) g_themed_icon_new ("mail-send");
			_data_->_tmp34_ = _data_->_tmp33_;
			_data_->_tmp35_ = (GThemedIcon*) g_themed_icon_new ("dialog-warning");
			_data_->_tmp36_ = NULL;
			_data_->_tmp36_ = granite_message_dialog_new (_ ("Sent message was not saved"), _ ("The message was sent, however a copy was not saved to the Sent message" \
" folder."), (GIcon*) _data_->_tmp34_, GTK_BUTTONS_CLOSE);
			granite_message_dialog_set_badge_icon (_data_->_tmp36_, (GIcon*) _data_->_tmp35_);
			_g_object_unref0 (_data_->_tmp35_);
			g_object_ref_sink (_data_->_tmp36_);
			_data_->_tmp37_ = _data_->_tmp36_;
			_g_object_unref0 (_data_->_tmp34_);
			_data_->_data13_->warning_dialog = _data_->_tmp37_;
			_data_->_tmp38_ = _data_->_data13_->warning_dialog;
			gtk_window_present ((GtkWindow*) _data_->_tmp38_);
			_data_->_tmp39_ = _data_->_data13_->warning_dialog;
			g_signal_connect_data ((GtkDialog*) _data_->_tmp39_, "response", (GCallback) _____lambda96__gtk_dialog_response, block13_data_ref (_data_->_data13_), (GClosureNotify) block13_data_unref, 0);
			block13_data_unref (_data_->_data13_);
			_data_->_data13_ = NULL;
		}
		_data_->self->priv->discard_draft = TRUE;
		g_signal_emit (_data_->self, mail_composer_signals[MAIL_COMPOSER_FINISHED_SIGNAL], 0);
		gtk_window_close ((GtkWindow*) _data_->self);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_data14_ = g_slice_new0 (Block14Data);
		_data_->_data14_->_ref_count_ = 1;
		_data_->_data14_->_data11_ = block11_data_ref (_data_->_data11_);
		_data_->_tmp40_ = (GThemedIcon*) g_themed_icon_new ("mail-send");
		_data_->_tmp41_ = _data_->_tmp40_;
		_data_->_tmp42_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
		_data_->_tmp43_ = NULL;
		_data_->_tmp43_ = granite_message_dialog_new (_ ("Unable to send message"), _ ("There was an unexpected error while sending your message."), (GIcon*) _data_->_tmp41_, GTK_BUTTONS_CLOSE);
		granite_message_dialog_set_badge_icon (_data_->_tmp43_, (GIcon*) _data_->_tmp42_);
		_g_object_unref0 (_data_->_tmp42_);
		g_object_ref_sink (_data_->_tmp43_);
		_data_->_tmp44_ = _data_->_tmp43_;
		_g_object_unref0 (_data_->_tmp41_);
		_data_->_data14_->error_dialog = _data_->_tmp44_;
		_data_->_tmp45_ = _data_->_data14_->error_dialog;
		_data_->_tmp46_ = _data_->e;
		_data_->_tmp47_ = _data_->_tmp46_->message;
		granite_message_dialog_show_error_details (_data_->_tmp45_, _data_->_tmp47_);
		_data_->_tmp48_ = _data_->_data14_->error_dialog;
		gtk_window_present ((GtkWindow*) _data_->_tmp48_);
		_data_->_tmp49_ = _data_->_data14_->error_dialog;
		g_signal_connect_data ((GtkDialog*) _data_->_tmp49_, "response", (GCallback) ____lambda97__gtk_dialog_response, block14_data_ref (_data_->_data14_), (GClosureNotify) block14_data_unref, 0);
		_g_error_free0 (_data_->e);
		block14_data_unref (_data_->_data14_);
		_data_->_data14_ = NULL;
	}
	__finally0:
	{
		gtk_widget_set_sensitive ((GtkWidget*) _data_->self, TRUE);
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->recipients);
		_g_object_unref0 (_data_->sender);
		_g_object_unref0 (_data_->message);
		_g_free0 (_data_->body_html);
		block11_data_unref (_data_->_data11_);
		_data_->_data11_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->recipients);
	_g_object_unref0 (_data_->sender);
	_g_object_unref0 (_data_->message);
	_g_free0 (_data_->body_html);
	block11_data_unref (_data_->_data11_);
	_data_->_data11_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static CamelInternetAddress*
mail_composer_build_sender (MailComposer* self,
                            CamelMimeMessage* message,
                            const gchar* from)
{
	CamelInternetAddress* sender = NULL;
	CamelInternetAddress* _tmp0_;
	CamelInternetAddress* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (message != NULL, NULL);
	g_return_val_if_fail (from != NULL, NULL);
	_tmp0_ = camel_internet_address_new ();
	sender = _tmp0_;
	camel_address_unformat ((CamelAddress*) sender, from);
	camel_mime_message_set_from (message, sender);
	result = sender;
	return result;
}

static CamelInternetAddress*
mail_composer_build_recipients (MailComposer* self,
                                CamelMimeMessage* message,
                                const gchar* to,
                                const gchar* cc,
                                const gchar* bcc)
{
	CamelInternetAddress* to_addresses = NULL;
	CamelInternetAddress* _tmp0_;
	CamelInternetAddress* cc_addresses = NULL;
	CamelInternetAddress* _tmp1_;
	CamelInternetAddress* bcc_addresses = NULL;
	CamelInternetAddress* _tmp2_;
	CamelInternetAddress* recipients = NULL;
	CamelInternetAddress* _tmp3_;
	CamelInternetAddress* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (message != NULL, NULL);
	g_return_val_if_fail (to != NULL, NULL);
	g_return_val_if_fail (cc != NULL, NULL);
	g_return_val_if_fail (bcc != NULL, NULL);
	_tmp0_ = camel_internet_address_new ();
	to_addresses = _tmp0_;
	camel_address_unformat ((CamelAddress*) to_addresses, to);
	camel_mime_message_set_recipients (message, CAMEL_RECIPIENT_TYPE_TO, to_addresses);
	_tmp1_ = camel_internet_address_new ();
	cc_addresses = _tmp1_;
	camel_address_unformat ((CamelAddress*) cc_addresses, cc);
	camel_mime_message_set_recipients (message, CAMEL_RECIPIENT_TYPE_CC, cc_addresses);
	_tmp2_ = camel_internet_address_new ();
	bcc_addresses = _tmp2_;
	camel_address_unformat ((CamelAddress*) bcc_addresses, bcc);
	camel_mime_message_set_recipients (message, CAMEL_RECIPIENT_TYPE_BCC, bcc_addresses);
	_tmp3_ = camel_internet_address_new ();
	recipients = _tmp3_;
	camel_address_cat ((CamelAddress*) recipients, (CamelAddress*) to_addresses);
	camel_address_cat ((CamelAddress*) recipients, (CamelAddress*) cc_addresses);
	camel_address_cat ((CamelAddress*) recipients, (CamelAddress*) bcc_addresses);
	result = recipients;
	_g_object_unref0 (bcc_addresses);
	_g_object_unref0 (cc_addresses);
	_g_object_unref0 (to_addresses);
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static CamelMimeMessage*
mail_composer_build_message (MailComposer* self,
                             const gchar* body_html)
{
	CamelStreamMem* stream_mem = NULL;
	guint8* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_ = 0;
	guint8* _tmp2_;
	gint _tmp2__length1;
	CamelStreamMem* _tmp3_;
	CamelStreamFilter* stream_filter = NULL;
	CamelStreamMem* _tmp4_;
	CamelStreamFilter* _tmp5_;
	CamelDataWrapper* html = NULL;
	CamelDataWrapper* _tmp6_;
	CamelMimePart* part = NULL;
	CamelMimePart* _tmp12_;
	CamelMimePart* _tmp13_;
	CamelDataWrapper* _tmp14_;
	CamelMimePart* _tmp15_;
	CamelMultipart* body = NULL;
	CamelMultipart* _tmp16_;
	CamelMultipart* _tmp17_;
	CamelMultipart* _tmp18_;
	CamelMultipart* _tmp19_;
	CamelMimePart* _tmp20_;
	GtkFlowBox* _tmp21_;
	GList* _tmp22_;
	GList* _tmp23_;
	gboolean _tmp24_;
	CamelMimeMessage* message = NULL;
	CamelMimeMessage* _tmp33_;
	GtkEntry* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	CamelMultipart* _tmp37_;
	GError* _inner_error0_ = NULL;
	CamelMimeMessage* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (body_html != NULL, NULL);
	_tmp0_ = string_get_data (body_html, &_tmp1_);
	_tmp0__length1 = _tmp1_;
	_tmp2_ = _tmp0_;
	_tmp2__length1 = _tmp0__length1;
	_tmp3_ = (CamelStreamMem*) camel_stream_mem_new_with_buffer (_tmp2_, _tmp2__length1);
	stream_mem = _tmp3_;
	_tmp4_ = stream_mem;
	_tmp5_ = (CamelStreamFilter*) camel_stream_filter_new ((CamelStream*) _tmp4_);
	stream_filter = _tmp5_;
	_tmp6_ = camel_data_wrapper_new ();
	html = _tmp6_;
	{
		CamelDataWrapper* _tmp7_;
		CamelStreamFilter* _tmp8_;
		CamelDataWrapper* _tmp9_;
		_tmp7_ = html;
		_tmp8_ = stream_filter;
		camel_data_wrapper_construct_from_stream_sync (_tmp7_, (CamelStream*) _tmp8_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp9_ = html;
		camel_data_wrapper_set_mime_type (_tmp9_, "text/html; charset=utf-8");
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_warning ("Composer.vala:902: Error constructing html from stream: %s", _tmp11_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (html);
		_g_object_unref0 (stream_filter);
		_g_object_unref0 (stream_mem);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp12_ = camel_mime_part_new ();
	part = _tmp12_;
	_tmp13_ = part;
	_tmp14_ = html;
	camel_medium_set_content ((CamelMedium*) _tmp13_, _tmp14_);
	_tmp15_ = part;
	camel_mime_part_set_encoding (_tmp15_, CAMEL_TRANSFER_ENCODING_QUOTEDPRINTABLE);
	_tmp16_ = camel_multipart_new ();
	body = _tmp16_;
	_tmp17_ = body;
	camel_data_wrapper_set_mime_type ((CamelDataWrapper*) _tmp17_, "multipart/alternative");
	_tmp18_ = body;
	camel_multipart_set_boundary (_tmp18_, NULL);
	_tmp19_ = body;
	_tmp20_ = part;
	camel_multipart_add_part (_tmp19_, _tmp20_);
	_tmp21_ = self->priv->attachment_box;
	_tmp22_ = gtk_container_get_children ((GtkContainer*) _tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_list_length (_tmp23_) > ((guint) 0);
	(_tmp23_ == NULL) ? NULL : (_tmp23_ = (g_list_free (_tmp23_), NULL));
	if (_tmp24_) {
		GtkFlowBox* _tmp25_;
		GList* _tmp26_;
		_tmp25_ = self->priv->attachment_box;
		_tmp26_ = gtk_container_get_children ((GtkContainer*) _tmp25_);
		{
			GList* attachment_collection = NULL;
			GList* attachment_it = NULL;
			attachment_collection = _tmp26_;
			for (attachment_it = attachment_collection; attachment_it != NULL; attachment_it = attachment_it->next) {
				GtkWidget* attachment = NULL;
				attachment = (GtkWidget*) attachment_it->data;
				{
					GtkWidget* _tmp27_;
					MailComposerAttachment* attachment_obj = NULL;
					GtkWidget* _tmp28_;
					CamelMultipart* _tmp29_;
					MailComposerAttachment* _tmp30_;
					CamelMimePart* _tmp31_;
					CamelMimePart* _tmp32_;
					_tmp27_ = attachment;
					if (!MAIL_COMPOSER_IS_ATTACHMENT (_tmp27_)) {
						continue;
					}
					_tmp28_ = attachment;
					attachment_obj = G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, MAIL_COMPOSER_TYPE_ATTACHMENT, MailComposerAttachment);
					_tmp29_ = body;
					_tmp30_ = attachment_obj;
					_tmp31_ = mail_composer_attachment_get_mime_part (_tmp30_);
					_tmp32_ = _tmp31_;
					camel_multipart_add_part (_tmp29_, _tmp32_);
					_g_object_unref0 (_tmp32_);
				}
			}
			(attachment_collection == NULL) ? NULL : (attachment_collection = (g_list_free (attachment_collection), NULL));
		}
	}
	_tmp33_ = camel_mime_message_new ();
	message = _tmp33_;
	_tmp34_ = self->priv->subject_val;
	_tmp35_ = gtk_entry_get_text (_tmp34_);
	_tmp36_ = _tmp35_;
	camel_mime_message_set_subject (message, _tmp36_);
	camel_mime_message_set_date (message, (time_t) CAMEL_MESSAGE_DATE_CURRENT, 0);
	_tmp37_ = body;
	camel_medium_set_content ((CamelMedium*) message, (CamelDataWrapper*) _tmp37_);
	result = message;
	_g_object_unref0 (body);
	_g_object_unref0 (part);
	_g_object_unref0 (html);
	_g_object_unref0 (stream_filter);
	_g_object_unref0 (stream_mem);
	return result;
}

static void
mail_composer_remember_recipients_data_free (gpointer _data)
{
	MailComposerRememberRecipientsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->recipients);
	_g_object_unref0 (_data_->self);
	g_slice_free (MailComposerRememberRecipientsData, _data_);
}

static void
mail_composer_remember_recipients (MailComposer* self,
                                   CamelInternetAddress* recipients,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	MailComposerRememberRecipientsData* _data_;
	MailComposer* _tmp0_;
	CamelInternetAddress* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (recipients != NULL);
	_data_ = g_slice_new0 (MailComposerRememberRecipientsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_composer_remember_recipients_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (recipients);
	_g_object_unref0 (_data_->recipients);
	_data_->recipients = _tmp1_;
	mail_composer_remember_recipients_co (_data_);
}

static void
mail_composer_remember_recipients_finish (MailComposer* self,
                                          GAsyncResult* _res_)
{
	MailComposerRememberRecipientsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
mail_composer_remember_recipients_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	MailComposerRememberRecipientsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_composer_remember_recipients_co (_data_);
}

static gboolean
mail_composer_remember_recipients_co (MailComposerRememberRecipientsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = mail_contact_manager_get_default ();
	_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
	_data_->contact_manager = _data_->_tmp1_;
	{
		_data_->i = 0;
		{
			_data_->_tmp2_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp2_) {
					_data_->_tmp3_ = _data_->i;
					_data_->i = _data_->_tmp3_ + 1;
				}
				_data_->_tmp2_ = FALSE;
				if (!(_data_->i < camel_address_length ((CamelAddress*) _data_->recipients))) {
					break;
				}
				_data_->_tmp4_ = NULL;
				_data_->_tmp5_ = NULL;
				camel_internet_address_get (_data_->recipients, _data_->i, &_data_->_tmp4_, &_data_->_tmp5_);
				_g_free0 (_data_->name);
				_data_->_tmp6_ = g_strdup (_data_->_tmp4_);
				_data_->name = _data_->_tmp6_;
				_g_free0 (_data_->address);
				_data_->_tmp7_ = g_strdup (_data_->_tmp5_);
				_data_->address = _data_->_tmp7_;
				_data_->_tmp8_ = _data_->contact_manager;
				_data_->_tmp9_ = _data_->address;
				_data_->_tmp10_ = _data_->name;
				_data_->_state_ = 1;
				mail_contact_manager_remember_mail_address (_data_->_tmp8_, _data_->_tmp9_, _data_->_tmp10_, mail_composer_remember_recipients_ready, _data_);
				return FALSE;
				_state_1:
				mail_contact_manager_remember_mail_address_finish (_data_->_tmp8_, _data_->_res_);
				_g_free0 (_data_->address);
				_g_free0 (_data_->name);
			}
		}
	}
	_g_object_unref0 (_data_->contact_manager);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
mail_composer_load_from_combobox (MailComposer* self)
{
	MailBackendSession* session = NULL;
	MailBackendSession* _tmp0_;
	GtkComboBoxText* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = mail_backend_session_get_default ();
	session = _tmp0_;
	{
		GeeArrayList* _address_list = NULL;
		MailBackendSession* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _address_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _address_index = 0;
		_tmp1_ = session;
		_tmp2_ = mail_backend_session_get_own_addresses (_tmp1_);
		_address_list = _tmp2_;
		_tmp3_ = _address_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_address_size = _tmp5_;
		_address_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gchar* address = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			GtkComboBoxText* _tmp10_;
			const gchar* _tmp11_;
			_address_index = _address_index + 1;
			_tmp6_ = _address_index;
			_tmp7_ = _address_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _address_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _address_index);
			address = (gchar*) _tmp9_;
			_tmp10_ = self->priv->from_combo;
			_tmp11_ = address;
			gtk_combo_box_text_append_text (_tmp10_, _tmp11_);
			_g_free0 (address);
		}
		_g_object_unref0 (_address_list);
	}
	_tmp12_ = self->priv->from_combo;
	gtk_combo_box_set_active ((GtkComboBox*) _tmp12_, 0);
}

static GVariant*
_variant_new1 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new2 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
mail_composer_populate_signature_menu (MailComposer* self,
                                       GMenu* menu)
{
	GMenu* manage_section = NULL;
	GMenu* _tmp0_;
	GMenuItem* manage_item = NULL;
	GMenuItem* _tmp1_;
	GMenu* _tmp2_;
	GMenuItem* _tmp3_;
	GMenu* selection_section = NULL;
	GMenu* _tmp4_;
	GMenu* _tmp5_;
	GVariant* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	MailBackendSession* session = NULL;
	MailBackendSession* _tmp9_;
	MailBackendSession* _tmp10_;
	GList* _tmp11_;
	GMenu* _tmp23_;
	GMenu* _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	_tmp0_ = g_menu_new ();
	manage_section = _tmp0_;
	_tmp1_ = g_menu_item_new (_ ("Edit Signatures…"), MAIL_APPLICATION_ACTION_PREFIX MAIL_APPLICATION_ACTION_MANAGE_SIGNATURES);
	manage_item = _tmp1_;
	_tmp2_ = manage_section;
	_tmp3_ = manage_item;
	g_menu_append_item (_tmp2_, _tmp3_);
	_tmp4_ = g_menu_new ();
	selection_section = _tmp4_;
	_tmp5_ = selection_section;
	_tmp6_ = _variant_new1 ("none");
	_tmp7_ = g_action_print_detailed_name (MAIL_COMPOSER_ACTION_PREFIX MAIL_COMPOSER_ACTION_INSERT_SIGNATURE, _tmp6_);
	_tmp8_ = _tmp7_;
	g_menu_append (_tmp5_, _ ("None"), _tmp8_);
	_g_free0 (_tmp8_);
	_g_variant_unref0 (_tmp6_);
	_tmp9_ = mail_backend_session_get_default ();
	session = _tmp9_;
	_tmp10_ = session;
	_tmp11_ = mail_backend_session_get_all_signature_sources (_tmp10_);
	{
		GList* signature_source_collection = NULL;
		GList* signature_source_it = NULL;
		signature_source_collection = _tmp11_;
		for (signature_source_it = signature_source_collection; signature_source_it != NULL; signature_source_it = signature_source_it->next) {
			ESource* _tmp12_;
			ESource* signature_source = NULL;
			_tmp12_ = _g_object_ref0 ((ESource*) signature_source_it->data);
			signature_source = _tmp12_;
			{
				GMenu* _tmp13_;
				ESource* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				ESource* _tmp17_;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				GVariant* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				_tmp13_ = selection_section;
				_tmp14_ = signature_source;
				_tmp15_ = e_source_get_display_name (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = signature_source;
				_tmp18_ = e_source_get_uid (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = _variant_new2 (_tmp19_);
				_tmp21_ = g_action_print_detailed_name (MAIL_COMPOSER_ACTION_PREFIX MAIL_COMPOSER_ACTION_INSERT_SIGNATURE, _tmp20_);
				_tmp22_ = _tmp21_;
				g_menu_append (_tmp13_, _tmp16_, _tmp22_);
				_g_free0 (_tmp22_);
				_g_variant_unref0 (_tmp20_);
				_g_object_unref0 (signature_source);
			}
		}
		(signature_source_collection == NULL) ? NULL : (signature_source_collection = (_g_list_free__g_object_unref0_ (signature_source_collection), NULL));
	}
	g_menu_remove_all (menu);
	_tmp23_ = manage_section;
	g_menu_append_section (menu, NULL, (GMenuModel*) _tmp23_);
	_tmp24_ = selection_section;
	g_menu_append_section (menu, NULL, (GMenuModel*) _tmp24_);
	_g_object_unref0 (selection_section);
	_g_object_unref0 (manage_item);
	_g_object_unref0 (manage_section);
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		MailComposer* self;
		self = _data15_->self;
		_g_object_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}

static void
__lambda90_ (Block15Data* _data15_,
             GObject* obj,
             GAsyncResult* res)
{
	MailComposer* self;
	gchar* signature = NULL;
	MailBackendSession* _tmp0_;
	gchar* _tmp1_;
	MailWebView* _tmp2_;
	self = _data15_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = _data15_->session;
	_tmp1_ = mail_backend_session_get_signature_for_uid_finish (_tmp0_, res);
	signature = _tmp1_;
	_tmp2_ = self->priv->web_view;
	mail_web_view_set_content_of_element (_tmp2_, "#elementary-message-signature", signature);
	_g_free0 (signature);
}

static void
___lambda90__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda90_ (self, source_object, res);
	block15_data_unref (self);
}

static void
mail_composer_on_insert_signature (MailComposer* self,
                                   GAction* action,
                                   GVariant* parameter)
{
	Block15Data* _data15_;
	const gchar* signature_uid = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	MailBackendSession* _tmp3_;
	MailBackendSession* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = g_object_ref (self);
	_tmp0_ = g_variant_get_string (parameter, NULL);
	signature_uid = _tmp0_;
	_tmp1_ = signature_uid;
	if (g_strcmp0 (_tmp1_, "none") == 0) {
		MailWebView* _tmp2_;
		_tmp2_ = self->priv->web_view;
		mail_web_view_set_content_of_element (_tmp2_, "#elementary-message-signature", "");
		block15_data_unref (_data15_);
		_data15_ = NULL;
		return;
	}
	_tmp3_ = mail_backend_session_get_default ();
	_data15_->session = _tmp3_;
	_tmp4_ = _data15_->session;
	_tmp5_ = signature_uid;
	mail_backend_session_get_signature_for_uid (_tmp4_, _tmp5_, ___lambda90__gasync_ready_callback, block15_data_ref (_data15_));
	block15_data_unref (_data15_);
	_data15_ = NULL;
}

static GVariant*
_variant_new3 (gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
mail_composer_set_default_signature_for_sender (MailComposer* self)
{
	gchar* sender = NULL;
	GtkComboBoxText* _tmp0_;
	gchar* _tmp1_;
	MailBackendSession* session = NULL;
	MailBackendSession* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GVariant* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->from_combo;
	_tmp1_ = gtk_combo_box_text_get_active_text (_tmp0_);
	sender = _tmp1_;
	_tmp2_ = mail_backend_session_get_default ();
	session = _tmp2_;
	_tmp3_ = mail_backend_session_get_signature_uid_for_sender (session, sender);
	_tmp4_ = _tmp3_;
	_tmp5_ = _variant_new3 (_tmp4_);
	g_action_group_activate_action ((GActionGroup*) self, MAIL_COMPOSER_ACTION_INSERT_SIGNATURE, _tmp5_);
	_g_variant_unref0 (_tmp5_);
	_g_free0 (_tmp4_);
	_g_free0 (sender);
}

static void
mail_composer_save_draft_data_free (gpointer _data)
{
	MailComposerSaveDraftData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MailComposerSaveDraftData, _data_);
}

void
mail_composer_save_draft (MailComposer* self,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	MailComposerSaveDraftData* _data_;
	MailComposer* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (MailComposerSaveDraftData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_composer_save_draft_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	mail_composer_save_draft_co (_data_);
}

gboolean
mail_composer_save_draft_finish (MailComposer* self,
                                 GAsyncResult* _res_)
{
	gboolean result;
	MailComposerSaveDraftData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
mail_composer_save_draft_ready (GObject* source_object,
                                GAsyncResult* _res_,
                                gpointer _user_data_)
{
	MailComposerSaveDraftData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_composer_save_draft_co (_data_);
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		MailComposer* self;
		self = _data16_->self;
		_g_object_unref0 (_data16_->error_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}

static void
____lambda102_ (Block16Data* _data16_)
{
	MailComposer* self;
	GraniteMessageDialog* _tmp0_;
	self = _data16_->self;
	_tmp0_ = _data16_->error_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}

static void
_____lambda102__gtk_dialog_response (GtkDialog* _sender,
                                     gint response_id,
                                     gpointer self)
{
	____lambda102_ (self);
}

static gboolean
mail_composer_save_draft_co (MailComposerSaveDraftData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->self->priv->discard_draft) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp1_ = _data_->self->priv->web_view;
		_data_->_tmp2_ = mail_web_view_get_body_html_changed (_data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp0_ = !_data_->_tmp3_;
	}
	if (_data_->_tmp0_) {
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->self->priv->web_view;
	_data_->_state_ = 1;
	mail_web_view_get_body_html (_data_->_tmp4_, FALSE, mail_composer_save_draft_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp5_ = mail_web_view_get_body_html_finish (_data_->_tmp4_, _data_->_res_);
	_data_->body_html = _data_->_tmp5_;
	_data_->_tmp6_ = _data_->body_html;
	if (_data_->_tmp6_ != NULL) {
		_data_->_tmp7_ = mail_backend_session_get_default ();
		_data_->session = _data_->_tmp7_;
		_data_->_tmp8_ = _data_->body_html;
		_data_->_tmp9_ = mail_composer_build_message (_data_->self, _data_->_tmp8_);
		_data_->message = _data_->_tmp9_;
		_data_->_tmp10_ = _data_->message;
		_data_->_tmp11_ = _data_->self->priv->from_combo;
		_data_->_tmp12_ = gtk_combo_box_text_get_active_text (_data_->_tmp11_);
		_data_->_tmp13_ = _data_->_tmp12_;
		_data_->_tmp14_ = mail_composer_build_sender (_data_->self, _data_->_tmp10_, _data_->_tmp13_);
		_data_->_tmp15_ = _data_->_tmp14_;
		_g_free0 (_data_->_tmp13_);
		_data_->sender = _data_->_tmp15_;
		_data_->_tmp16_ = _data_->message;
		_data_->_tmp17_ = _data_->self->priv->to_val;
		_data_->_tmp18_ = gtk_entry_get_text (_data_->_tmp17_);
		_data_->_tmp19_ = _data_->_tmp18_;
		_data_->_tmp20_ = _data_->self->priv->cc_val;
		_data_->_tmp21_ = gtk_entry_get_text (_data_->_tmp20_);
		_data_->_tmp22_ = _data_->_tmp21_;
		_data_->_tmp23_ = _data_->self->priv->bcc_val;
		_data_->_tmp24_ = gtk_entry_get_text (_data_->_tmp23_);
		_data_->_tmp25_ = _data_->_tmp24_;
		_data_->_tmp26_ = mail_composer_build_recipients (_data_->self, _data_->_tmp16_, _data_->_tmp19_, _data_->_tmp22_, _data_->_tmp25_);
		_data_->recipients = _data_->_tmp26_;
		{
			_data_->_tmp27_ = _data_->session;
			_data_->_tmp28_ = _data_->message;
			_data_->_tmp29_ = _data_->sender;
			_data_->_tmp30_ = _data_->recipients;
			_data_->_tmp31_ = _data_->self->priv->ancestor_message_info;
			_data_->_state_ = 2;
			mail_backend_session_save_draft (_data_->_tmp27_, _data_->_tmp28_, _data_->_tmp29_, (CamelAddress*) _data_->_tmp30_, _data_->_tmp31_, mail_composer_save_draft_ready, _data_);
			return FALSE;
			_state_2:
			mail_backend_session_save_draft_finish (_data_->_tmp27_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_data16_ = g_slice_new0 (Block16Data);
			_data_->_data16_->_ref_count_ = 1;
			_data_->_data16_->self = g_object_ref (_data_->self);
			_data_->_tmp32_ = (GThemedIcon*) g_themed_icon_new ("mail-drafts");
			_data_->_tmp33_ = _data_->_tmp32_;
			_data_->_tmp34_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
			_data_->_tmp35_ = NULL;
			_data_->_tmp35_ = granite_message_dialog_new (_ ("Unable to save draft"), _ ("There was an unexpected error while saving your draft."), (GIcon*) _data_->_tmp33_, GTK_BUTTONS_CLOSE);
			granite_message_dialog_set_badge_icon (_data_->_tmp35_, (GIcon*) _data_->_tmp34_);
			_g_object_unref0 (_data_->_tmp34_);
			g_object_ref_sink (_data_->_tmp35_);
			_data_->_tmp36_ = _data_->_tmp35_;
			_g_object_unref0 (_data_->_tmp33_);
			_data_->_data16_->error_dialog = _data_->_tmp36_;
			_data_->_tmp37_ = _data_->_data16_->error_dialog;
			_data_->_tmp38_ = _data_->e;
			_data_->_tmp39_ = _data_->_tmp38_->message;
			granite_message_dialog_show_error_details (_data_->_tmp37_, _data_->_tmp39_);
			_data_->_tmp40_ = _data_->_data16_->error_dialog;
			gtk_window_present ((GtkWindow*) _data_->_tmp40_);
			_data_->_tmp41_ = _data_->_data16_->error_dialog;
			g_signal_connect_data ((GtkDialog*) _data_->_tmp41_, "response", (GCallback) _____lambda102__gtk_dialog_response, block16_data_ref (_data_->_data16_), (GClosureNotify) block16_data_unref, 0);
			_data_->result = TRUE;
			_g_error_free0 (_data_->e);
			block16_data_unref (_data_->_data16_);
			_data_->_data16_ = NULL;
			_g_object_unref0 (_data_->recipients);
			_g_object_unref0 (_data_->sender);
			_g_object_unref0 (_data_->message);
			_g_free0 (_data_->body_html);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->recipients);
			_g_object_unref0 (_data_->sender);
			_g_object_unref0 (_data_->message);
			_g_free0 (_data_->body_html);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->recipients);
		_g_object_unref0 (_data_->sender);
		_g_object_unref0 (_data_->message);
	}
	_data_->result = FALSE;
	_g_free0 (_data_->body_html);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gboolean
mail_composer_get_has_recipients (MailComposer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_recipients;
	return result;
}

void
mail_composer_set_has_recipients (MailComposer* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_composer_get_has_recipients (self);
	if (old_value != value) {
		self->priv->_has_recipients = value;
		g_object_notify_by_pspec ((GObject *) self, mail_composer_properties[MAIL_COMPOSER_HAS_RECIPIENTS_PROPERTY]);
	}
}

const gchar*
mail_composer_get_to (MailComposer* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_to;
	result = _tmp0_;
	return result;
}

static void
mail_composer_set_to (MailComposer* self,
                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_composer_get_to (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_to);
		self->priv->_to = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_composer_properties[MAIL_COMPOSER_TO_PROPERTY]);
	}
}

const gchar*
mail_composer_get_mailto_query (MailComposer* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mailto_query;
	result = _tmp0_;
	return result;
}

static void
mail_composer_set_mailto_query (MailComposer* self,
                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_composer_get_mailto_query (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_mailto_query);
		self->priv->_mailto_query = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_composer_properties[MAIL_COMPOSER_MAILTO_QUERY_PROPERTY]);
	}
}

static inline gpointer
mail_composer_attachment_get_instance_private (MailComposerAttachment* self)
{
	return G_STRUCT_MEMBER_P (self, MailComposerAttachment_private_offset);
}

static MailComposerAttachment*
mail_composer_attachment_construct (GType object_type,
                                    GFile* file,
                                    const gchar* disposition)
{
	MailComposerAttachment * self = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (disposition != NULL, NULL);
	self = (MailComposerAttachment*) g_object_new (object_type, "file", file, "disposition", disposition, NULL);
	return self;
}

static MailComposerAttachment*
mail_composer_attachment_new (GFile* file,
                              const gchar* disposition)
{
	return mail_composer_attachment_construct (MAIL_COMPOSER_TYPE_ATTACHMENT, file, disposition);
}

static CamelMimePart*
mail_composer_attachment_get_mime_part (MailComposerAttachment* self)
{
	GFileInfo* _tmp0_;
	const gchar* content_type = NULL;
	GFileInfo* _tmp1_;
	const gchar* _tmp2_;
	gchar* mime_type = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	CamelDataWrapper* wrapper = NULL;
	CamelDataWrapper* _tmp5_;
	CamelDataWrapper* _tmp12_;
	const gchar* _tmp13_;
	CamelMimePart* mimepart = NULL;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	CamelDataWrapper* _tmp18_;
	CamelDataWrapper* _tmp19_;
	CamelMimePart* _tmp20_ = NULL;
	CamelMimePart* _tmp21_;
	GFileInfo* _tmp22_;
	const gchar* _tmp23_;
	CamelMimePart* _tmp24_;
	CamelContentType* _tmp25_;
	GError* _inner_error0_ = NULL;
	CamelMimePart* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->info;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->info;
	_tmp2_ = g_file_info_get_content_type (_tmp1_);
	content_type = _tmp2_;
	_tmp3_ = content_type;
	_tmp4_ = g_content_type_get_mime_type (_tmp3_);
	mime_type = _tmp4_;
	_tmp5_ = camel_data_wrapper_new ();
	wrapper = _tmp5_;
	{
		GFileInputStream* _tmp6_ = NULL;
		GFile* _tmp7_;
		GFileInputStream* _tmp8_;
		CamelDataWrapper* _tmp9_;
		_tmp7_ = self->priv->_file;
		_tmp8_ = g_file_read (_tmp7_, NULL, &_inner_error0_);
		_tmp6_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp9_ = wrapper;
		camel_data_wrapper_construct_from_input_stream_sync (_tmp9_, (GInputStream*) _tmp6_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp6_);
			goto __catch0_g_error;
		}
		_g_object_unref0 (_tmp6_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_warning ("Composer.vala:1085: Error constructing wrapper for attachment: %s", _tmp11_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (wrapper);
		_g_free0 (mime_type);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (wrapper);
		_g_free0 (mime_type);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp12_ = wrapper;
	_tmp13_ = mime_type;
	camel_data_wrapper_set_mime_type (_tmp12_, _tmp13_);
	_tmp14_ = self->priv->_cid;
	_tmp15_ = g_strdup (_tmp14_);
	_tmp16_ = self->priv->_disposition;
	_tmp17_ = g_strdup (_tmp16_);
	_tmp18_ = wrapper;
	_tmp19_ = _g_object_ref0 (_tmp18_);
	_tmp20_ = camel_mime_part_new ();
	camel_mime_part_set_content_id (_tmp20_, _tmp15_);
	_g_free0 (_tmp15_);
	camel_mime_part_set_disposition (_tmp20_, _tmp17_);
	_g_free0 (_tmp17_);
	camel_medium_set_content ((CamelMedium*) _tmp20_, _tmp19_);
	_g_object_unref0 (_tmp19_);
	mimepart = _tmp20_;
	_tmp21_ = mimepart;
	_tmp22_ = self->priv->info;
	_tmp23_ = g_file_info_get_display_name (_tmp22_);
	camel_mime_part_set_filename (_tmp21_, _tmp23_);
	_tmp24_ = mimepart;
	_tmp25_ = camel_mime_part_get_content_type (_tmp24_);
	if (camel_content_type_is (_tmp25_, "text", "*")) {
		CamelStreamNull* stream = NULL;
		CamelStreamNull* _tmp26_;
		CamelStreamFilter* filtered_stream = NULL;
		CamelStreamNull* _tmp27_;
		CamelStreamFilter* _tmp28_;
		CamelMimeFilterBestenc* filter = NULL;
		CamelMimeFilterBestenc* _tmp29_;
		CamelStreamFilter* _tmp30_;
		CamelMimeFilterBestenc* _tmp31_;
		_tmp26_ = (CamelStreamNull*) camel_stream_null_new ();
		stream = _tmp26_;
		_tmp27_ = stream;
		_tmp28_ = (CamelStreamFilter*) camel_stream_filter_new ((CamelStream*) _tmp27_);
		filtered_stream = _tmp28_;
		_tmp29_ = (CamelMimeFilterBestenc*) camel_mime_filter_bestenc_new ((guint) CAMEL_BESTENC_GET_ENCODING);
		filter = _tmp29_;
		_tmp30_ = filtered_stream;
		_tmp31_ = filter;
		camel_stream_filter_add (_tmp30_, (CamelMimeFilter*) _tmp31_);
		{
			CamelDataWrapper* _tmp32_;
			CamelStreamFilter* _tmp33_;
			CamelTransferEncoding encoding = 0;
			CamelMimeFilterBestenc* _tmp34_;
			CamelMimePart* _tmp35_;
			_tmp32_ = wrapper;
			_tmp33_ = filtered_stream;
			camel_data_wrapper_decode_to_stream_sync (_tmp32_, (CamelStream*) _tmp33_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp34_ = filter;
			encoding = camel_mime_filter_bestenc_get_best_encoding (_tmp34_, CAMEL_BESTENC_8BIT);
			_tmp35_ = mimepart;
			camel_mime_part_set_encoding (_tmp35_, encoding);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp36_;
			const gchar* _tmp37_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp36_ = e;
			_tmp37_ = _tmp36_->message;
			g_warning ("Composer.vala:1112: Unable to determine best encoding for attachment: " \
"%s", _tmp37_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (filter);
			_g_object_unref0 (filtered_stream);
			_g_object_unref0 (stream);
			_g_object_unref0 (mimepart);
			_g_object_unref0 (wrapper);
			_g_free0 (mime_type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_object_unref0 (filter);
		_g_object_unref0 (filtered_stream);
		_g_object_unref0 (stream);
	} else {
		CamelMimePart* _tmp38_;
		_tmp38_ = mimepart;
		camel_mime_part_set_encoding (_tmp38_, CAMEL_TRANSFER_ENCODING_BASE64);
	}
	result = mimepart;
	_g_object_unref0 (wrapper);
	_g_free0 (mime_type);
	return result;
}

static GFile*
mail_composer_attachment_get_file (MailComposerAttachment* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file;
	result = _tmp0_;
	return result;
}

static void
mail_composer_attachment_set_file (MailComposerAttachment* self,
                                   GFile* value)
{
	GFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_composer_attachment_get_file (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_file);
		self->priv->_file = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_composer_attachment_properties[MAIL_COMPOSER_ATTACHMENT_FILE_PROPERTY]);
	}
}

static const gchar*
mail_composer_attachment_get_disposition (MailComposerAttachment* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_disposition;
	result = _tmp0_;
	return result;
}

static void
mail_composer_attachment_set_disposition (MailComposerAttachment* self,
                                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_composer_attachment_get_disposition (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_disposition);
		self->priv->_disposition = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_composer_attachment_properties[MAIL_COMPOSER_ATTACHMENT_DISPOSITION_PROPERTY]);
	}
}

static const gchar*
mail_composer_attachment_get_cid (MailComposerAttachment* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_cid;
	result = _tmp0_;
	return result;
}

static void
mail_composer_attachment_set_cid (MailComposerAttachment* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_composer_attachment_get_cid (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_cid);
		self->priv->_cid = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_composer_attachment_properties[MAIL_COMPOSER_ATTACHMENT_CID_PROPERTY]);
	}
}

static const gchar*
mail_composer_attachment_get_uri (MailComposerAttachment* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uri;
	result = _tmp0_;
	return result;
}

static void
mail_composer_attachment_set_uri (MailComposerAttachment* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_composer_attachment_get_uri (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uri);
		self->priv->_uri = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_composer_attachment_properties[MAIL_COMPOSER_ATTACHMENT_URI_PROPERTY]);
	}
}

static void
_mail_composer_attachment___lambda86_ (MailComposerAttachment* self)
{
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
__mail_composer_attachment___lambda86__gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self)
{
	_mail_composer_attachment___lambda86_ ((MailComposerAttachment*) self);
}

static GObject *
mail_composer_attachment_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MailComposerAttachment * self;
	static const char QUERY_STRING[] = G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE "," G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME "," G_FILE_ATTRIBUTE_STANDARD_ICON "," G_FILE_ATTRIBUTE_STANDARD_SIZE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkImage* image = NULL;
	GFileInfo* _tmp11_;
	GIcon* _tmp12_;
	GIcon* _tmp13_;
	GtkImage* _tmp14_ = NULL;
	GtkLabel* name_label = NULL;
	GFileInfo* _tmp15_;
	const gchar* _tmp16_;
	GtkLabel* _tmp17_ = NULL;
	GtkLabel* size_label = NULL;
	GFileInfo* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GtkLabel* _tmp23_;
	GtkLabel* _tmp24_;
	GtkLabel* _tmp25_;
	GtkStyleContext* _tmp26_;
	GtkButton* remove_button = NULL;
	GtkButton* _tmp27_;
	GtkStyleContext* remove_button_context = NULL;
	GtkButton* _tmp28_;
	GtkStyleContext* _tmp29_;
	GtkStyleContext* _tmp30_;
	GtkStyleContext* _tmp31_;
	GtkBox* box = NULL;
	GtkBox* _tmp32_ = NULL;
	GtkBox* _tmp33_;
	GtkImage* _tmp34_;
	GtkBox* _tmp35_;
	GtkLabel* _tmp36_;
	GtkBox* _tmp37_;
	GtkLabel* _tmp38_;
	GtkBox* _tmp39_;
	GtkButton* _tmp40_;
	const gchar* _tmp41_;
	GtkBox* _tmp42_;
	GtkButton* _tmp43_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (mail_composer_attachment_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_COMPOSER_TYPE_ATTACHMENT, MailComposerAttachment);
	_tmp0_ = g_uuid_string_random ();
	_tmp1_ = _tmp0_;
	mail_composer_attachment_set_cid (self, _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->_cid;
	_tmp3_ = g_strdup_printf ("cid:%s", _tmp2_);
	_tmp4_ = _tmp3_;
	mail_composer_attachment_set_uri (self, _tmp4_);
	_g_free0 (_tmp4_);
	{
		GFileInfo* _tmp5_ = NULL;
		GFile* _tmp6_;
		GFileInfo* _tmp7_;
		GFileInfo* _tmp8_;
		_tmp6_ = self->priv->_file;
		_tmp7_ = g_file_query_info (_tmp6_, QUERY_STRING, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		_tmp5_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp8_ = _tmp5_;
		_tmp5_ = NULL;
		_g_object_unref0 (self->priv->info);
		self->priv->info = _tmp8_;
		_g_object_unref0 (_tmp5_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("Composer.vala:1025: Error querying attachment file attributes: %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp11_ = self->priv->info;
	_tmp12_ = g_file_info_get_icon (_tmp11_);
	_tmp13_ = _g_object_ref0 (_tmp12_);
	_tmp14_ = (GtkImage*) gtk_image_new ();
	g_object_set (_tmp14_, "gicon", _tmp13_, NULL);
	_g_object_unref0 (_tmp13_);
	gtk_image_set_pixel_size (_tmp14_, 24);
	g_object_ref_sink (_tmp14_);
	image = _tmp14_;
	_tmp15_ = self->priv->info;
	_tmp16_ = g_file_info_get_display_name (_tmp15_);
	_tmp17_ = (GtkLabel*) gtk_label_new (_tmp16_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp17_, TRUE);
	gtk_label_set_xalign (_tmp17_, (gfloat) 0);
	g_object_ref_sink (_tmp17_);
	name_label = _tmp17_;
	_tmp18_ = self->priv->info;
	_tmp19_ = g_format_size_full ((guint64) g_file_info_get_size (_tmp18_), G_FORMAT_SIZE_DEFAULT);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strdup_printf ("(%s)", _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = (GtkLabel*) gtk_label_new (_tmp22_);
	g_object_ref_sink (_tmp23_);
	_tmp24_ = _tmp23_;
	_g_free0 (_tmp22_);
	_g_free0 (_tmp20_);
	size_label = _tmp24_;
	_tmp25_ = size_label;
	_tmp26_ = gtk_widget_get_style_context ((GtkWidget*) _tmp25_);
	gtk_style_context_add_class (_tmp26_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp27_ = (GtkButton*) gtk_button_new_from_icon_name ("process-stop-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp27_);
	remove_button = _tmp27_;
	_tmp28_ = remove_button;
	_tmp29_ = gtk_widget_get_style_context ((GtkWidget*) _tmp28_);
	remove_button_context = _tmp29_;
	_tmp30_ = remove_button_context;
	gtk_style_context_add_class (_tmp30_, GTK_STYLE_CLASS_FLAT);
	_tmp31_ = remove_button_context;
	gtk_style_context_add_class (_tmp31_, GTK_STYLE_CLASS_DESTRUCTIVE_ACTION);
	_tmp32_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 3);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp32_, 3);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp32_, 3);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp32_, 3);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp32_, 3);
	g_object_ref_sink (_tmp32_);
	box = _tmp32_;
	_tmp33_ = box;
	_tmp34_ = image;
	gtk_container_add ((GtkContainer*) _tmp33_, (GtkWidget*) _tmp34_);
	_tmp35_ = box;
	_tmp36_ = name_label;
	gtk_container_add ((GtkContainer*) _tmp35_, (GtkWidget*) _tmp36_);
	_tmp37_ = box;
	_tmp38_ = size_label;
	gtk_container_add ((GtkContainer*) _tmp37_, (GtkWidget*) _tmp38_);
	_tmp39_ = box;
	_tmp40_ = remove_button;
	gtk_container_add ((GtkContainer*) _tmp39_, (GtkWidget*) _tmp40_);
	_tmp41_ = self->priv->_disposition;
	if (g_strcmp0 (_tmp41_, MAIL_COMPOSER_ATTACHMENT_DISPOSITION_INLINE) == 0) {
		gtk_widget_set_no_show_all ((GtkWidget*) self, TRUE);
	}
	gtk_widget_set_margin_top ((GtkWidget*) self, 3);
	gtk_widget_set_margin_bottom ((GtkWidget*) self, 3);
	gtk_widget_set_margin_start ((GtkWidget*) self, 3);
	gtk_widget_set_margin_end ((GtkWidget*) self, 3);
	_tmp42_ = box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp42_);
	_tmp43_ = remove_button;
	g_signal_connect_object (_tmp43_, "clicked", (GCallback) __mail_composer_attachment___lambda86__gtk_button_clicked, self, 0);
	_g_object_unref0 (box);
	_g_object_unref0 (remove_button);
	_g_object_unref0 (size_label);
	_g_object_unref0 (name_label);
	_g_object_unref0 (image);
	return obj;
}

static void
mail_composer_attachment_class_init (MailComposerAttachmentClass * klass,
                                     gpointer klass_data)
{
	mail_composer_attachment_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MailComposerAttachment_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_mail_composer_attachment_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_mail_composer_attachment_set_property;
	G_OBJECT_CLASS (klass)->constructor = mail_composer_attachment_constructor;
	G_OBJECT_CLASS (klass)->finalize = mail_composer_attachment_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_COMPOSER_ATTACHMENT_FILE_PROPERTY, mail_composer_attachment_properties[MAIL_COMPOSER_ATTACHMENT_FILE_PROPERTY] = g_param_spec_object ("file", "file", "file", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_COMPOSER_ATTACHMENT_DISPOSITION_PROPERTY, mail_composer_attachment_properties[MAIL_COMPOSER_ATTACHMENT_DISPOSITION_PROPERTY] = g_param_spec_string ("disposition", "disposition", "disposition", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_COMPOSER_ATTACHMENT_CID_PROPERTY, mail_composer_attachment_properties[MAIL_COMPOSER_ATTACHMENT_CID_PROPERTY] = g_param_spec_string ("cid", "cid", "cid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_COMPOSER_ATTACHMENT_URI_PROPERTY, mail_composer_attachment_properties[MAIL_COMPOSER_ATTACHMENT_URI_PROPERTY] = g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
mail_composer_attachment_instance_init (MailComposerAttachment * self,
                                        gpointer klass)
{
	self->priv = mail_composer_attachment_get_instance_private (self);
}

static void
mail_composer_attachment_finalize (GObject * obj)
{
	MailComposerAttachment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_COMPOSER_TYPE_ATTACHMENT, MailComposerAttachment);
	_g_object_unref0 (self->priv->_file);
	_g_free0 (self->priv->_disposition);
	_g_free0 (self->priv->_cid);
	_g_free0 (self->priv->_uri);
	_g_object_unref0 (self->priv->info);
	G_OBJECT_CLASS (mail_composer_attachment_parent_class)->finalize (obj);
}

static GType
mail_composer_attachment_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MailComposerAttachmentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mail_composer_attachment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MailComposerAttachment), 0, (GInstanceInitFunc) mail_composer_attachment_instance_init, NULL };
	GType mail_composer_attachment_type_id;
	mail_composer_attachment_type_id = g_type_register_static (gtk_flow_box_child_get_type (), "MailComposerAttachment", &g_define_type_info, 0);
	MailComposerAttachment_private_offset = g_type_add_instance_private (mail_composer_attachment_type_id, sizeof (MailComposerAttachmentPrivate));
	return mail_composer_attachment_type_id;
}

static GType
mail_composer_attachment_get_type (void)
{
	static volatile gsize mail_composer_attachment_type_id__once = 0;
	if (g_once_init_enter (&mail_composer_attachment_type_id__once)) {
		GType mail_composer_attachment_type_id;
		mail_composer_attachment_type_id = mail_composer_attachment_get_type_once ();
		g_once_init_leave (&mail_composer_attachment_type_id__once, mail_composer_attachment_type_id);
	}
	return mail_composer_attachment_type_id__once;
}

static void
_vala_mail_composer_attachment_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	MailComposerAttachment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_COMPOSER_TYPE_ATTACHMENT, MailComposerAttachment);
	switch (property_id) {
		case MAIL_COMPOSER_ATTACHMENT_FILE_PROPERTY:
		g_value_set_object (value, mail_composer_attachment_get_file (self));
		break;
		case MAIL_COMPOSER_ATTACHMENT_DISPOSITION_PROPERTY:
		g_value_set_string (value, mail_composer_attachment_get_disposition (self));
		break;
		case MAIL_COMPOSER_ATTACHMENT_CID_PROPERTY:
		g_value_set_string (value, mail_composer_attachment_get_cid (self));
		break;
		case MAIL_COMPOSER_ATTACHMENT_URI_PROPERTY:
		g_value_set_string (value, mail_composer_attachment_get_uri (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_mail_composer_attachment_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	MailComposerAttachment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_COMPOSER_TYPE_ATTACHMENT, MailComposerAttachment);
	switch (property_id) {
		case MAIL_COMPOSER_ATTACHMENT_FILE_PROPERTY:
		mail_composer_attachment_set_file (self, g_value_get_object (value));
		break;
		case MAIL_COMPOSER_ATTACHMENT_DISPOSITION_PROPERTY:
		mail_composer_attachment_set_disposition (self, g_value_get_string (value));
		break;
		case MAIL_COMPOSER_ATTACHMENT_CID_PROPERTY:
		mail_composer_attachment_set_cid (self, g_value_get_string (value));
		break;
		case MAIL_COMPOSER_ATTACHMENT_URI_PROPERTY:
		mail_composer_attachment_set_uri (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static MailComposerEntryGrid*
mail_composer_entry_grid_construct (GType object_type)
{
	MailComposerEntryGrid * self = NULL;
	self = (MailComposerEntryGrid*) g_object_new (object_type, NULL);
	return self;
}

static MailComposerEntryGrid*
mail_composer_entry_grid_new (void)
{
	return mail_composer_entry_grid_construct (MAIL_COMPOSER_TYPE_ENTRY_GRID);
}

static void
mail_composer_entry_grid_class_init (MailComposerEntryGridClass * klass,
                                     gpointer klass_data)
{
	mail_composer_entry_grid_parent_class = g_type_class_peek_parent (klass);
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), GTK_STYLE_CLASS_ENTRY);
}

static void
mail_composer_entry_grid_instance_init (MailComposerEntryGrid * self,
                                        gpointer klass)
{
}

static GType
mail_composer_entry_grid_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MailComposerEntryGridClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mail_composer_entry_grid_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MailComposerEntryGrid), 0, (GInstanceInitFunc) mail_composer_entry_grid_instance_init, NULL };
	GType mail_composer_entry_grid_type_id;
	mail_composer_entry_grid_type_id = g_type_register_static (gtk_grid_get_type (), "MailComposerEntryGrid", &g_define_type_info, 0);
	return mail_composer_entry_grid_type_id;
}

static GType
mail_composer_entry_grid_get_type (void)
{
	static volatile gsize mail_composer_entry_grid_type_id__once = 0;
	if (g_once_init_enter (&mail_composer_entry_grid_type_id__once)) {
		GType mail_composer_entry_grid_type_id;
		mail_composer_entry_grid_type_id = mail_composer_entry_grid_get_type_once ();
		g_once_init_leave (&mail_composer_entry_grid_type_id__once, mail_composer_entry_grid_type_id);
	}
	return mail_composer_entry_grid_type_id__once;
}

static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}

static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		MailComposer* self;
		self = _data17_->self;
		_g_object_unref0 (_data17_->signature_menu);
		_g_object_unref0 (_data17_->to_grid);
		_g_object_unref0 (_data17_->bcc_button);
		_g_object_unref0 (self);
		g_slice_free (Block17Data, _data17_);
	}
}

static void
_mail_composer___lambda103_ (MailComposer* self)
{
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	_tmp0_ = self->priv->subject_val;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = _tmp1_;
	gtk_window_set_title ((GtkWindow*) self, _tmp2_);
}

static void
__mail_composer___lambda103__gtk_editable_changed (GtkEditable* _sender,
                                                   gpointer self)
{
	_mail_composer___lambda103_ ((MailComposer*) self);
}

static void
_mail_composer_on_mouse_target_changed_webkit_web_view_mouse_target_changed (WebKitWebView* _sender,
                                                                             WebKitHitTestResult* hit_test_result,
                                                                             guint modifiers,
                                                                             gpointer self)
{
	mail_composer_on_mouse_target_changed ((MailComposer*) self, _sender, hit_test_result, modifiers);
}

static void
__lambda113_ (MailComposer* self,
              GObject* obj,
              GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	if (!mail_composer_save_draft_finish (self, res)) {
		g_signal_emit (self, mail_composer_signals[MAIL_COMPOSER_FINISHED_SIGNAL], 0);
		gtk_widget_destroy ((GtkWidget*) self);
	}
}

static void
___lambda113__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda113_ ((MailComposer*) self, source_object, res);
	g_object_unref (self);
}

static gboolean
_mail_composer___lambda112_ (MailComposer* self)
{
	gboolean result;
	mail_composer_save_draft (self, ___lambda113__gasync_ready_callback, g_object_ref (self));
	result = TRUE;
	return result;
}

static gboolean
__mail_composer___lambda112__gtk_widget_delete_event (GtkWidget* _sender,
                                                      GdkEventAny* event,
                                                      gpointer self)
{
	gboolean result;
	result = _mail_composer___lambda112_ ((MailComposer*) self);
	return result;
}

static void
_mail_composer___lambda114_ (MailComposer* self)
{
	mail_composer_set_default_signature_for_sender (self);
}

static void
__mail_composer___lambda114__gtk_combo_box_changed (GtkComboBox* _sender,
                                                    gpointer self)
{
	_mail_composer___lambda114_ ((MailComposer*) self);
}

static void
_mail_composer___lambda115_ (MailComposer* self)
{
	GtkRevealer* _tmp0_;
	GtkToggleButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	_tmp0_ = self->priv->cc_revealer;
	_tmp1_ = self->priv->cc_button;
	_tmp2_ = gtk_toggle_button_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_revealer_set_reveal_child (_tmp0_, _tmp3_);
}

static void
__mail_composer___lambda115__gtk_button_clicked (GtkButton* _sender,
                                                 gpointer self)
{
	_mail_composer___lambda115_ ((MailComposer*) self);
}

static void
_mail_composer___lambda116_ (MailComposer* self)
{
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	_tmp0_ = self->priv->cc_val;
	mail_composer_on_sanitize_recipient_entry (self, _tmp0_);
	_tmp1_ = self->priv->cc_val;
	_tmp2_ = gtk_entry_get_text (_tmp1_);
	_tmp3_ = _tmp2_;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		GtkToggleButton* _tmp4_;
		_tmp4_ = self->priv->cc_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, TRUE);
	} else {
		GtkToggleButton* _tmp5_;
		_tmp5_ = self->priv->cc_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, FALSE);
	}
}

static void
__mail_composer___lambda116__gtk_editable_changed (GtkEditable* _sender,
                                                   gpointer self)
{
	_mail_composer___lambda116_ ((MailComposer*) self);
}

static void
_mail_composer___lambda117_ (Block17Data* _data17_)
{
	MailComposer* self;
	GtkRevealer* _tmp0_;
	GtkToggleButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = _data17_->self;
	_tmp0_ = self->priv->bcc_revealer;
	_tmp1_ = _data17_->bcc_button;
	_tmp2_ = gtk_toggle_button_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_revealer_set_reveal_child (_tmp0_, _tmp3_);
}

static void
__mail_composer___lambda117__gtk_button_clicked (GtkButton* _sender,
                                                 gpointer self)
{
	_mail_composer___lambda117_ (self);
}

static void
_mail_composer___lambda118_ (Block17Data* _data17_)
{
	MailComposer* self;
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	self = _data17_->self;
	_tmp0_ = self->priv->bcc_val;
	mail_composer_on_sanitize_recipient_entry (self, _tmp0_);
	_tmp1_ = self->priv->bcc_val;
	_tmp2_ = gtk_entry_get_text (_tmp1_);
	_tmp3_ = _tmp2_;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		GtkToggleButton* _tmp4_;
		_tmp4_ = _data17_->bcc_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, TRUE);
	} else {
		GtkToggleButton* _tmp5_;
		_tmp5_ = _data17_->bcc_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, FALSE);
	}
}

static void
__mail_composer___lambda118__gtk_editable_changed (GtkEditable* _sender,
                                                   gpointer self)
{
	_mail_composer___lambda118_ (self);
}

static void
_mail_composer___lambda119_ (MailComposer* self)
{
}

static void
__mail_composer___lambda119__gtk_combo_box_changed (GtkComboBox* _sender,
                                                    gpointer self)
{
	_mail_composer___lambda119_ ((MailComposer*) self);
}

static void
_mail_composer___lambda120_ (MailComposer* self)
{
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	_tmp0_ = self->priv->to_val;
	mail_composer_on_sanitize_recipient_entry (self, _tmp0_);
	_tmp1_ = self->priv->to_val;
	_tmp2_ = gtk_entry_get_text (_tmp1_);
	_tmp3_ = _tmp2_;
	mail_composer_set_has_recipients (self, g_strcmp0 (_tmp3_, "") != 0);
}

static void
__mail_composer___lambda120__gtk_editable_changed (GtkEditable* _sender,
                                                   gpointer self)
{
	_mail_composer___lambda120_ ((MailComposer*) self);
}

static void
_mail_composer___lambda121_ (Block17Data* _data17_)
{
	MailComposer* self;
	GtkStyleContext* to_grid_style_context = NULL;
	MailComposerEntryGrid* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStateFlags state = 0U;
	GtkStyleContext* _tmp2_;
	GtkEntry* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GtkStyleContext* _tmp6_;
	self = _data17_->self;
	_tmp0_ = _data17_->to_grid;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) _tmp0_);
	to_grid_style_context = _tmp1_;
	_tmp2_ = to_grid_style_context;
	state = gtk_style_context_get_state (_tmp2_);
	_tmp3_ = self->priv->to_val;
	g_object_get ((GtkWidget*) _tmp3_, "has-focus", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		state |= GTK_STATE_FLAG_FOCUSED;
	} else {
		state ^= GTK_STATE_FLAG_FOCUSED;
	}
	_tmp6_ = to_grid_style_context;
	gtk_style_context_set_state (_tmp6_, state);
}

static void
__mail_composer___lambda121__gtk_style_context_changed (GtkStyleContext* _sender,
                                                        gpointer self)
{
	_mail_composer___lambda121_ (self);
}

static void
_mail_composer___lambda122_ (Block17Data* _data17_)
{
	MailComposer* self;
	GMenu* _tmp0_;
	self = _data17_->self;
	_tmp0_ = _data17_->signature_menu;
	mail_composer_populate_signature_menu (self, _tmp0_);
}

static void
__mail_composer___lambda122__mail_backend_session_signature_changed (MailBackendSession* _sender,
                                                                     gpointer self)
{
	_mail_composer___lambda122_ (self);
}

static GObject *
mail_composer_constructor (GType type,
                           guint n_construct_properties,
                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MailComposer * self;
	Block17Data* _data17_;
	GApplication* _tmp0_;
	GtkApplication* _tmp1_;
	GtkApplication* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	GtkApplication* _tmp7_;
	GtkApplication* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	GtkApplication* _tmp12_;
	GtkApplication* _tmp13_;
	GList* _tmp14_;
	HdyHeaderBar* headerbar = NULL;
	HdyHeaderBar* _tmp17_ = NULL;
	HdyHeaderBar* _tmp18_;
	GtkStyleContext* _tmp19_;
	HdyHeaderBar* _tmp20_;
	GtkStyleContext* _tmp21_;
	GtkLabel* from_label = NULL;
	GtkLabel* _tmp22_ = NULL;
	GtkLabel* _tmp23_;
	GtkStyleContext* _tmp24_;
	GtkComboBoxText* _tmp25_ = NULL;
	GtkBox* from_box = NULL;
	GtkBox* _tmp26_ = NULL;
	GtkBox* _tmp27_;
	GtkLabel* _tmp28_;
	GtkBox* _tmp29_;
	GtkComboBoxText* _tmp30_;
	GtkRevealer* from_revealer = NULL;
	GtkBox* _tmp31_;
	GtkWidget* _tmp32_;
	GtkRevealer* _tmp33_ = NULL;
	GtkLabel* to_label = NULL;
	GtkLabel* _tmp34_ = NULL;
	GtkLabel* _tmp35_;
	GtkStyleContext* _tmp36_;
	GtkLabel* subject_label = NULL;
	GtkLabel* _tmp37_ = NULL;
	GtkLabel* _tmp38_;
	GtkStyleContext* _tmp39_;
	GtkEntry* _tmp40_ = NULL;
	GtkToggleButton* _tmp41_;
	GtkToggleButton* _tmp42_;
	MailComposerEntryGrid* _tmp43_;
	MailComposerEntryGrid* _tmp44_;
	GtkEntry* _tmp45_;
	MailComposerEntryGrid* _tmp46_;
	GtkToggleButton* _tmp47_;
	MailComposerEntryGrid* _tmp48_;
	GtkToggleButton* _tmp49_;
	GtkLabel* cc_label = NULL;
	GtkLabel* _tmp50_ = NULL;
	GtkLabel* _tmp51_;
	GtkStyleContext* _tmp52_;
	GtkEntry* _tmp53_ = NULL;
	GtkBox* cc_box = NULL;
	GtkBox* _tmp54_ = NULL;
	GtkBox* _tmp55_;
	GtkLabel* _tmp56_;
	GtkBox* _tmp57_;
	GtkEntry* _tmp58_;
	GtkRevealer* _tmp59_;
	GtkRevealer* _tmp60_;
	GtkBox* _tmp61_;
	GtkLabel* bcc_label = NULL;
	GtkLabel* _tmp62_ = NULL;
	GtkLabel* _tmp63_;
	GtkStyleContext* _tmp64_;
	GtkEntry* _tmp65_ = NULL;
	GtkBox* bcc_box = NULL;
	GtkBox* _tmp66_ = NULL;
	GtkBox* _tmp67_;
	GtkLabel* _tmp68_;
	GtkBox* _tmp69_;
	GtkEntry* _tmp70_;
	GtkRevealer* _tmp71_;
	GtkRevealer* _tmp72_;
	GtkBox* _tmp73_;
	GtkEntry* _tmp74_ = NULL;
	GtkEntry* _tmp75_;
	GtkSizeGroup* size_group = NULL;
	GtkSizeGroup* _tmp76_;
	GtkSizeGroup* _tmp77_;
	GtkLabel* _tmp78_;
	GtkSizeGroup* _tmp79_;
	GtkLabel* _tmp80_;
	GtkSizeGroup* _tmp81_;
	GtkLabel* _tmp82_;
	GtkSizeGroup* _tmp83_;
	GtkLabel* _tmp84_;
	GtkSizeGroup* _tmp85_;
	GtkLabel* _tmp86_;
	GtkGrid* recipient_grid = NULL;
	GtkGrid* _tmp87_ = NULL;
	GtkGrid* _tmp88_;
	GtkRevealer* _tmp89_;
	GtkGrid* _tmp90_;
	GtkLabel* _tmp91_;
	GtkGrid* _tmp92_;
	MailComposerEntryGrid* _tmp93_;
	GtkGrid* _tmp94_;
	GtkRevealer* _tmp95_;
	GtkGrid* _tmp96_;
	GtkRevealer* _tmp97_;
	GtkGrid* _tmp98_;
	GtkLabel* _tmp99_;
	GtkGrid* _tmp100_;
	GtkEntry* _tmp101_;
	GtkButton* image = NULL;
	gchar* _tmp102_;
	gchar* _tmp103_;
	GtkButton* _tmp104_ = NULL;
	MailWebView* _tmp105_;
	MailWebView* _tmp113_;
	EditorToolbar* editor_toolbar = NULL;
	MailWebView* _tmp114_;
	EditorToolbar* _tmp115_;
	EditorToolbar* _tmp116_;
	GtkButton* _tmp117_;
	GtkFlowBox* _tmp118_ = NULL;
	GtkFlowBox* _tmp119_;
	GtkStyleContext* _tmp120_;
	GtkButton* discard = NULL;
	gchar* _tmp121_;
	GtkApplication* _tmp122_;
	GtkApplication* _tmp123_;
	gchar** _tmp124_;
	gchar** _tmp125_;
	gchar** _tmp126_;
	gint _tmp126__length1;
	gchar* _tmp127_;
	GtkButton* _tmp128_ = NULL;
	GtkButton* _tmp129_;
	GtkButton* attach = NULL;
	gchar* _tmp130_;
	GtkApplication* _tmp131_;
	GtkApplication* _tmp132_;
	gchar** _tmp133_;
	gchar** _tmp134_;
	gchar** _tmp135_;
	gint _tmp135__length1;
	gchar* _tmp136_;
	GtkButton* _tmp137_ = NULL;
	GtkButton* _tmp138_;
	GMenu* _tmp139_;
	GtkMenuButton* signature_button = NULL;
	GtkImage* _tmp140_;
	GMenu* _tmp141_;
	GMenuModel* _tmp142_;
	gchar* _tmp143_;
	GtkMenuButton* _tmp144_ = NULL;
	GtkButton* send = NULL;
	gchar* _tmp145_;
	gchar* _tmp146_;
	GtkApplication* _tmp147_;
	GtkApplication* _tmp148_;
	gchar** _tmp149_;
	gchar** _tmp150_;
	gchar** _tmp151_;
	gint _tmp151__length1;
	gchar* _tmp152_;
	GtkButton* _tmp153_ = NULL;
	GtkButton* _tmp154_;
	GtkButton* _tmp155_;
	GtkStyleContext* _tmp156_;
	GtkActionBar* action_bar = NULL;
	GtkActionBar* _tmp157_ = NULL;
	GtkActionBar* _tmp158_;
	GtkStyleContext* _tmp159_;
	GtkActionBar* _tmp160_;
	GtkButton* _tmp161_;
	GtkActionBar* _tmp162_;
	GtkButton* _tmp163_;
	GtkActionBar* _tmp164_;
	GtkMenuButton* _tmp165_;
	GtkActionBar* _tmp166_;
	GtkButton* _tmp167_;
	GtkOverlay* view_overlay = NULL;
	GtkOverlay* _tmp168_;
	GtkOverlay* _tmp169_;
	MailWebView* _tmp170_;
	GtkOverlay* _tmp171_;
	GraniteWidgetsOverlayBar* _tmp172_;
	GraniteWidgetsOverlayBar* _tmp173_;
	GtkBox* main_box = NULL;
	GtkBox* _tmp174_;
	GtkBox* _tmp175_;
	HdyHeaderBar* _tmp176_;
	GtkBox* _tmp177_;
	GtkGrid* _tmp178_;
	GtkBox* _tmp179_;
	EditorToolbar* _tmp180_;
	GtkBox* _tmp181_;
	GtkSeparator* _tmp182_;
	GtkSeparator* _tmp183_;
	GtkBox* _tmp184_;
	GtkOverlay* _tmp185_;
	GtkBox* _tmp186_;
	GtkFlowBox* _tmp187_;
	GtkBox* _tmp188_;
	GtkActionBar* _tmp189_;
	GtkBox* _tmp190_;
	MailContactManager* contact_manager = NULL;
	MailContactManager* _tmp191_;
	MailContactManager* _tmp192_;
	MailContactManager* _tmp193_;
	GtkEntry* _tmp194_;
	MailContactManager* _tmp195_;
	GtkEntry* _tmp196_;
	MailContactManager* _tmp197_;
	GtkEntry* _tmp198_;
	GtkComboBoxText* _tmp199_;
	GtkRevealer* _tmp200_;
	GtkComboBoxText* _tmp201_;
	GtkTreeModel* _tmp202_;
	GtkTreeModel* _tmp203_;
	GtkButton* _tmp204_;
	HdyHeaderBar* _tmp205_;
	GtkToggleButton* _tmp206_;
	GtkEntry* _tmp207_;
	GtkToggleButton* _tmp208_;
	GtkEntry* _tmp209_;
	GtkComboBoxText* _tmp210_;
	GtkEntry* _tmp211_;
	GtkEntry* _tmp212_;
	GtkStyleContext* _tmp213_;
	const gchar* _tmp214_;
	MailBackendSession* session = NULL;
	MailBackendSession* _tmp217_;
	MailBackendSession* _tmp218_;
	GMenu* _tmp219_;
	const gchar* _tmp220_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (mail_composer_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_COMPOSER, MailComposer);
	_data17_ = g_slice_new0 (Block17Data);
	_data17_->_ref_count_ = 1;
	_data17_->self = g_object_ref (self);
	g_action_map_add_action_entries ((GActionMap*) self, MAIL_COMPOSER_ACTION_ENTRIES, (gint) G_N_ELEMENTS (MAIL_COMPOSER_ACTION_ENTRIES), self);
	_tmp0_ = g_application_get_default ();
	gtk_window_set_application ((GtkWindow*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_application_get_type (), GtkApplication));
	_tmp1_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup ("<Alt>I");
	_tmp4_ = g_strdup ("<Shift><Control>A");
	_tmp5_ = g_new0 (gchar*, 2 + 1);
	_tmp5_[0] = _tmp3_;
	_tmp5_[1] = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 2;
	gtk_application_set_accels_for_action (_tmp2_, MAIL_COMPOSER_ACTION_PREFIX MAIL_COMPOSER_ACTION_ADD_ATTACHMENT, _tmp6_);
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
	_tmp7_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup ("<Control>Return");
	_tmp10_ = g_new0 (gchar*, 1 + 1);
	_tmp10_[0] = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 1;
	gtk_application_set_accels_for_action (_tmp8_, MAIL_COMPOSER_ACTION_PREFIX MAIL_COMPOSER_ACTION_SEND, _tmp11_);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	_tmp12_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = gtk_application_get_windows (_tmp13_);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp14_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			GtkWindow* window = NULL;
			window = (GtkWindow*) window_it->data;
			{
				GtkWindow* _tmp15_;
				_tmp15_ = window;
				if (MAIL_IS_MAIN_WINDOW (_tmp15_)) {
					GtkWindow* _tmp16_;
					_tmp16_ = window;
					gtk_window_set_transient_for ((GtkWindow*) self, _tmp16_);
					break;
				}
			}
		}
	}
	_tmp17_ = (HdyHeaderBar*) hdy_header_bar_new ();
	hdy_header_bar_set_has_subtitle (_tmp17_, FALSE);
	hdy_header_bar_set_show_close_button (_tmp17_, TRUE);
	g_object_ref_sink (_tmp17_);
	headerbar = _tmp17_;
	_tmp18_ = headerbar;
	_tmp19_ = gtk_widget_get_style_context ((GtkWidget*) _tmp18_);
	gtk_style_context_add_class (_tmp19_, GTK_STYLE_CLASS_FLAT);
	_tmp20_ = headerbar;
	_tmp21_ = gtk_widget_get_style_context ((GtkWidget*) _tmp20_);
	gtk_style_context_add_class (_tmp21_, "default-decoration");
	_tmp22_ = (GtkLabel*) gtk_label_new (_ ("From:"));
	gtk_label_set_xalign (_tmp22_, (gfloat) 1);
	g_object_ref_sink (_tmp22_);
	from_label = _tmp22_;
	_tmp23_ = from_label;
	_tmp24_ = gtk_widget_get_style_context ((GtkWidget*) _tmp23_);
	gtk_style_context_add_class (_tmp24_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp25_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp25_, TRUE);
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (self->priv->from_combo);
	self->priv->from_combo = _tmp25_;
	_tmp26_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp26_, 6);
	g_object_ref_sink (_tmp26_);
	from_box = _tmp26_;
	_tmp27_ = from_box;
	_tmp28_ = from_label;
	gtk_container_add ((GtkContainer*) _tmp27_, (GtkWidget*) _tmp28_);
	_tmp29_ = from_box;
	_tmp30_ = self->priv->from_combo;
	gtk_container_add ((GtkContainer*) _tmp29_, (GtkWidget*) _tmp30_);
	_tmp31_ = from_box;
	_tmp32_ = _g_object_ref0 ((GtkWidget*) _tmp31_);
	_tmp33_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_set ((GtkContainer*) _tmp33_, "child", _tmp32_, NULL);
	_g_object_unref0 (_tmp32_);
	g_object_ref_sink (_tmp33_);
	from_revealer = _tmp33_;
	_tmp34_ = (GtkLabel*) gtk_label_new (_ ("To:"));
	gtk_label_set_xalign (_tmp34_, (gfloat) 1);
	g_object_ref_sink (_tmp34_);
	to_label = _tmp34_;
	_tmp35_ = to_label;
	_tmp36_ = gtk_widget_get_style_context ((GtkWidget*) _tmp35_);
	gtk_style_context_add_class (_tmp36_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp37_ = (GtkLabel*) gtk_label_new (_ ("Subject:"));
	gtk_label_set_xalign (_tmp37_, (gfloat) 1);
	g_object_ref_sink (_tmp37_);
	subject_label = _tmp37_;
	_tmp38_ = subject_label;
	_tmp39_ = gtk_widget_get_style_context ((GtkWidget*) _tmp38_);
	gtk_style_context_add_class (_tmp39_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp40_ = (GtkEntry*) gtk_entry_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp40_, TRUE);
	g_object_ref_sink (_tmp40_);
	_g_object_unref0 (self->priv->to_val);
	self->priv->to_val = _tmp40_;
	_tmp41_ = (GtkToggleButton*) gtk_toggle_button_new_with_label (_ ("Cc"));
	g_object_ref_sink (_tmp41_);
	_g_object_unref0 (self->priv->cc_button);
	self->priv->cc_button = _tmp41_;
	_tmp42_ = (GtkToggleButton*) gtk_toggle_button_new_with_label (_ ("Bcc"));
	g_object_ref_sink (_tmp42_);
	_data17_->bcc_button = _tmp42_;
	_tmp43_ = mail_composer_entry_grid_new ();
	g_object_ref_sink (_tmp43_);
	_data17_->to_grid = _tmp43_;
	_tmp44_ = _data17_->to_grid;
	_tmp45_ = self->priv->to_val;
	gtk_container_add ((GtkContainer*) _tmp44_, (GtkWidget*) _tmp45_);
	_tmp46_ = _data17_->to_grid;
	_tmp47_ = self->priv->cc_button;
	gtk_container_add ((GtkContainer*) _tmp46_, (GtkWidget*) _tmp47_);
	_tmp48_ = _data17_->to_grid;
	_tmp49_ = _data17_->bcc_button;
	gtk_container_add ((GtkContainer*) _tmp48_, (GtkWidget*) _tmp49_);
	_tmp50_ = (GtkLabel*) gtk_label_new (_ ("Cc:"));
	gtk_label_set_xalign (_tmp50_, (gfloat) 1);
	g_object_ref_sink (_tmp50_);
	cc_label = _tmp50_;
	_tmp51_ = cc_label;
	_tmp52_ = gtk_widget_get_style_context ((GtkWidget*) _tmp51_);
	gtk_style_context_add_class (_tmp52_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp53_ = (GtkEntry*) gtk_entry_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp53_, TRUE);
	g_object_ref_sink (_tmp53_);
	_g_object_unref0 (self->priv->cc_val);
	self->priv->cc_val = _tmp53_;
	_tmp54_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp54_, 6);
	g_object_ref_sink (_tmp54_);
	cc_box = _tmp54_;
	_tmp55_ = cc_box;
	_tmp56_ = cc_label;
	gtk_container_add ((GtkContainer*) _tmp55_, (GtkWidget*) _tmp56_);
	_tmp57_ = cc_box;
	_tmp58_ = self->priv->cc_val;
	gtk_container_add ((GtkContainer*) _tmp57_, (GtkWidget*) _tmp58_);
	_tmp59_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp59_);
	_g_object_unref0 (self->priv->cc_revealer);
	self->priv->cc_revealer = _tmp59_;
	_tmp60_ = self->priv->cc_revealer;
	_tmp61_ = cc_box;
	gtk_container_add ((GtkContainer*) _tmp60_, (GtkWidget*) _tmp61_);
	_tmp62_ = (GtkLabel*) gtk_label_new (_ ("Bcc:"));
	gtk_label_set_xalign (_tmp62_, (gfloat) 1);
	g_object_ref_sink (_tmp62_);
	bcc_label = _tmp62_;
	_tmp63_ = bcc_label;
	_tmp64_ = gtk_widget_get_style_context ((GtkWidget*) _tmp63_);
	gtk_style_context_add_class (_tmp64_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp65_ = (GtkEntry*) gtk_entry_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp65_, TRUE);
	g_object_ref_sink (_tmp65_);
	_g_object_unref0 (self->priv->bcc_val);
	self->priv->bcc_val = _tmp65_;
	_tmp66_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp66_, 6);
	g_object_ref_sink (_tmp66_);
	bcc_box = _tmp66_;
	_tmp67_ = bcc_box;
	_tmp68_ = bcc_label;
	gtk_container_add ((GtkContainer*) _tmp67_, (GtkWidget*) _tmp68_);
	_tmp69_ = bcc_box;
	_tmp70_ = self->priv->bcc_val;
	gtk_container_add ((GtkContainer*) _tmp69_, (GtkWidget*) _tmp70_);
	_tmp71_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp71_);
	_g_object_unref0 (self->priv->bcc_revealer);
	self->priv->bcc_revealer = _tmp71_;
	_tmp72_ = self->priv->bcc_revealer;
	_tmp73_ = bcc_box;
	gtk_container_add ((GtkContainer*) _tmp72_, (GtkWidget*) _tmp73_);
	_tmp74_ = (GtkEntry*) gtk_entry_new ();
	gtk_widget_set_margin_top ((GtkWidget*) _tmp74_, 6);
	g_object_ref_sink (_tmp74_);
	_g_object_unref0 (self->priv->subject_val);
	self->priv->subject_val = _tmp74_;
	_tmp75_ = self->priv->subject_val;
	g_signal_connect_object ((GtkEditable*) _tmp75_, "changed", (GCallback) __mail_composer___lambda103__gtk_editable_changed, self, 0);
	_tmp76_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	size_group = _tmp76_;
	_tmp77_ = size_group;
	_tmp78_ = from_label;
	gtk_size_group_add_widget (_tmp77_, (GtkWidget*) _tmp78_);
	_tmp79_ = size_group;
	_tmp80_ = to_label;
	gtk_size_group_add_widget (_tmp79_, (GtkWidget*) _tmp80_);
	_tmp81_ = size_group;
	_tmp82_ = cc_label;
	gtk_size_group_add_widget (_tmp81_, (GtkWidget*) _tmp82_);
	_tmp83_ = size_group;
	_tmp84_ = bcc_label;
	gtk_size_group_add_widget (_tmp83_, (GtkWidget*) _tmp84_);
	_tmp85_ = size_group;
	_tmp86_ = subject_label;
	gtk_size_group_add_widget (_tmp85_, (GtkWidget*) _tmp86_);
	_tmp87_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp87_, 6);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp87_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp87_, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp87_, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp87_, 6);
	g_object_ref_sink (_tmp87_);
	recipient_grid = _tmp87_;
	_tmp88_ = recipient_grid;
	_tmp89_ = from_revealer;
	gtk_grid_attach (_tmp88_, (GtkWidget*) _tmp89_, 0, 0, 2, 1);
	_tmp90_ = recipient_grid;
	_tmp91_ = to_label;
	gtk_grid_attach (_tmp90_, (GtkWidget*) _tmp91_, 0, 1, 1, 1);
	_tmp92_ = recipient_grid;
	_tmp93_ = _data17_->to_grid;
	gtk_grid_attach (_tmp92_, (GtkWidget*) _tmp93_, 1, 1, 1, 1);
	_tmp94_ = recipient_grid;
	_tmp95_ = self->priv->cc_revealer;
	gtk_grid_attach (_tmp94_, (GtkWidget*) _tmp95_, 0, 2, 2, 1);
	_tmp96_ = recipient_grid;
	_tmp97_ = self->priv->bcc_revealer;
	gtk_grid_attach (_tmp96_, (GtkWidget*) _tmp97_, 0, 3, 2, 1);
	_tmp98_ = recipient_grid;
	_tmp99_ = subject_label;
	gtk_grid_attach (_tmp98_, (GtkWidget*) _tmp99_, 0, 4, 1, 1);
	_tmp100_ = recipient_grid;
	_tmp101_ = self->priv->subject_val;
	gtk_grid_attach (_tmp100_, (GtkWidget*) _tmp101_, 1, 4, 1, 1);
	_tmp102_ = g_strdup (MAIL_COMPOSER_ACTION_PREFIX MAIL_COMPOSER_ACTION_INSERT_IMAGE);
	_tmp103_ = g_strdup (_ ("Insert Image"));
	_tmp104_ = (GtkButton*) gtk_button_new_from_icon_name ("insert-image-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp104_, _tmp102_);
	_g_free0 (_tmp102_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp104_, _tmp103_);
	_g_free0 (_tmp103_);
	g_object_ref_sink (_tmp104_);
	image = _tmp104_;
	_tmp105_ = mail_web_view_new ();
	g_object_ref_sink (_tmp105_);
	_g_object_unref0 (self->priv->web_view);
	self->priv->web_view = _tmp105_;
	{
		GBytes* template = NULL;
		GBytes* _tmp106_;
		MailWebView* _tmp107_;
		GBytes* _tmp108_;
		gsize _tmp109_ = 0;
		guint8* _tmp110_;
		_tmp106_ = g_resources_lookup_data ("/io/elementary/mail/blank-message-template.html", G_RESOURCE_LOOKUP_FLAGS_NONE, &_inner_error0_);
		template = _tmp106_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp107_ = self->priv->web_view;
		_tmp108_ = template;
		_tmp110_ = g_bytes_get_data (_tmp108_, &_tmp109_);
		mail_web_view_load_html (_tmp107_, (const gchar*) _tmp110_);
		_g_bytes_unref0 (template);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp111_;
		const gchar* _tmp112_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp111_ = e;
		_tmp112_ = _tmp111_->message;
		g_warning ("Composer.vala:206: Failed to load blank message template: %s", _tmp112_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (image);
		_g_object_unref0 (recipient_grid);
		_g_object_unref0 (size_group);
		_g_object_unref0 (bcc_box);
		_g_object_unref0 (bcc_label);
		_g_object_unref0 (cc_box);
		_g_object_unref0 (cc_label);
		_g_object_unref0 (subject_label);
		_g_object_unref0 (to_label);
		_g_object_unref0 (from_revealer);
		_g_object_unref0 (from_box);
		_g_object_unref0 (from_label);
		_g_object_unref0 (headerbar);
		block17_data_unref (_data17_);
		_data17_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp113_ = self->priv->web_view;
	g_signal_connect_object ((WebKitWebView*) _tmp113_, "mouse-target-changed", (GCallback) _mail_composer_on_mouse_target_changed_webkit_web_view_mouse_target_changed, self, 0);
	_tmp114_ = self->priv->web_view;
	_tmp115_ = editor_toolbar_new (_tmp114_);
	g_object_ref_sink (_tmp115_);
	editor_toolbar = _tmp115_;
	_tmp116_ = editor_toolbar;
	_tmp117_ = image;
	gtk_container_add ((GtkContainer*) _tmp116_, (GtkWidget*) _tmp117_);
	_tmp118_ = (GtkFlowBox*) gtk_flow_box_new ();
	gtk_flow_box_set_homogeneous (_tmp118_, TRUE);
	gtk_flow_box_set_selection_mode (_tmp118_, GTK_SELECTION_NONE);
	g_object_ref_sink (_tmp118_);
	_g_object_unref0 (self->priv->attachment_box);
	self->priv->attachment_box = _tmp118_;
	_tmp119_ = self->priv->attachment_box;
	_tmp120_ = gtk_widget_get_style_context ((GtkWidget*) _tmp119_);
	gtk_style_context_add_class (_tmp120_, GTK_STYLE_CLASS_VIEW);
	_tmp121_ = g_strdup (MAIL_COMPOSER_ACTION_PREFIX MAIL_COMPOSER_ACTION_DISCARD);
	_tmp122_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp123_ = _tmp122_;
	_tmp125_ = _tmp124_ = gtk_application_get_accels_for_action (_tmp123_, MAIL_COMPOSER_ACTION_PREFIX MAIL_COMPOSER_ACTION_DISCARD);
	_tmp126_ = _tmp125_;
	_tmp126__length1 = _vala_array_length (_tmp124_);
	_tmp127_ = granite_markup_accel_tooltip (_tmp126_, (gint) _vala_array_length (_tmp124_), _ ("Delete draft"));
	_tmp128_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-delete-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp128_, _tmp121_);
	_g_free0 (_tmp121_);
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp128_, _tmp127_);
	_g_free0 (_tmp127_);
	g_object_ref_sink (_tmp128_);
	_tmp129_ = _tmp128_;
	_tmp126_ = (_vala_array_free (_tmp126_, _tmp126__length1, (GDestroyNotify) g_free), NULL);
	discard = _tmp129_;
	_tmp130_ = g_strdup (MAIL_COMPOSER_ACTION_PREFIX MAIL_COMPOSER_ACTION_ADD_ATTACHMENT);
	_tmp131_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp132_ = _tmp131_;
	_tmp134_ = _tmp133_ = gtk_application_get_accels_for_action (_tmp132_, MAIL_COMPOSER_ACTION_PREFIX MAIL_COMPOSER_ACTION_ADD_ATTACHMENT);
	_tmp135_ = _tmp134_;
	_tmp135__length1 = _vala_array_length (_tmp133_);
	_tmp136_ = granite_markup_accel_tooltip (_tmp135_, (gint) _vala_array_length (_tmp133_), _ ("Attach file"));
	_tmp137_ = (GtkButton*) gtk_button_new_from_icon_name ("mail-attachment-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp137_, _tmp130_);
	_g_free0 (_tmp130_);
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp137_, _tmp136_);
	_g_free0 (_tmp136_);
	g_object_ref_sink (_tmp137_);
	_tmp138_ = _tmp137_;
	_tmp135_ = (_vala_array_free (_tmp135_, _tmp135__length1, (GDestroyNotify) g_free), NULL);
	attach = _tmp138_;
	_tmp139_ = g_menu_new ();
	_data17_->signature_menu = _tmp139_;
	_tmp140_ = (GtkImage*) gtk_image_new_from_icon_name ("document-edit-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp140_);
	_tmp141_ = _data17_->signature_menu;
	_tmp142_ = _g_object_ref0 ((GMenuModel*) _tmp141_);
	_tmp143_ = g_strdup (_ ("Insert Signature…"));
	_tmp144_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_button_set_image ((GtkButton*) _tmp144_, (GtkWidget*) _tmp140_);
	_g_object_unref0 (_tmp140_);
	gtk_menu_button_set_menu_model (_tmp144_, _tmp142_);
	_g_object_unref0 (_tmp142_);
	gtk_menu_button_set_use_popover (_tmp144_, FALSE);
	gtk_menu_button_set_direction (_tmp144_, GTK_ARROW_UP);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp144_, _tmp143_);
	_g_free0 (_tmp143_);
	g_object_ref_sink (_tmp144_);
	signature_button = _tmp144_;
	_tmp145_ = g_strdup (MAIL_COMPOSER_ACTION_PREFIX MAIL_COMPOSER_ACTION_SEND);
	_tmp146_ = g_strdup (_ ("Send"));
	_tmp147_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp148_ = _tmp147_;
	_tmp150_ = _tmp149_ = gtk_application_get_accels_for_action (_tmp148_, MAIL_COMPOSER_ACTION_PREFIX MAIL_COMPOSER_ACTION_SEND);
	_tmp151_ = _tmp150_;
	_tmp151__length1 = _vala_array_length (_tmp149_);
	_tmp152_ = granite_markup_accel_tooltip (_tmp151_, (gint) _vala_array_length (_tmp149_), NULL);
	_tmp153_ = (GtkButton*) gtk_button_new_from_icon_name ("mail-send-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp153_, _tmp145_);
	_g_free0 (_tmp145_);
	gtk_button_set_always_show_image (_tmp153_, TRUE);
	gtk_button_set_label (_tmp153_, _tmp146_);
	_g_free0 (_tmp146_);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp153_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp153_, 0);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp153_, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp153_, 6);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp153_, FALSE);
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp153_, _tmp152_);
	_g_free0 (_tmp152_);
	g_object_ref_sink (_tmp153_);
	_tmp154_ = _tmp153_;
	_tmp151_ = (_vala_array_free (_tmp151_, _tmp151__length1, (GDestroyNotify) g_free), NULL);
	send = _tmp154_;
	_tmp155_ = send;
	_tmp156_ = gtk_widget_get_style_context ((GtkWidget*) _tmp155_);
	gtk_style_context_add_class (_tmp156_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp157_ = (GtkActionBar*) gtk_action_bar_new ();
	gtk_widget_set_margin_top ((GtkWidget*) _tmp157_, 1);
	g_object_ref_sink (_tmp157_);
	action_bar = _tmp157_;
	_tmp158_ = action_bar;
	_tmp159_ = gtk_widget_get_style_context ((GtkWidget*) _tmp158_);
	gtk_style_context_add_class (_tmp159_, GTK_STYLE_CLASS_FLAT);
	_tmp160_ = action_bar;
	_tmp161_ = discard;
	gtk_action_bar_pack_start (_tmp160_, (GtkWidget*) _tmp161_);
	_tmp162_ = action_bar;
	_tmp163_ = attach;
	gtk_action_bar_pack_start (_tmp162_, (GtkWidget*) _tmp163_);
	_tmp164_ = action_bar;
	_tmp165_ = signature_button;
	gtk_action_bar_pack_start (_tmp164_, (GtkWidget*) _tmp165_);
	_tmp166_ = action_bar;
	_tmp167_ = send;
	gtk_action_bar_pack_end (_tmp166_, (GtkWidget*) _tmp167_);
	_tmp168_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp168_);
	view_overlay = _tmp168_;
	_tmp169_ = view_overlay;
	_tmp170_ = self->priv->web_view;
	gtk_container_add ((GtkContainer*) _tmp169_, (GtkWidget*) _tmp170_);
	_tmp171_ = view_overlay;
	_tmp172_ = granite_widgets_overlay_bar_new (_tmp171_);
	g_object_ref_sink (_tmp172_);
	_g_object_unref0 (self->priv->message_url_overlay);
	self->priv->message_url_overlay = _tmp172_;
	_tmp173_ = self->priv->message_url_overlay;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp173_, TRUE);
	_tmp174_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp174_);
	main_box = _tmp174_;
	_tmp175_ = main_box;
	_tmp176_ = headerbar;
	gtk_container_add ((GtkContainer*) _tmp175_, (GtkWidget*) _tmp176_);
	_tmp177_ = main_box;
	_tmp178_ = recipient_grid;
	gtk_container_add ((GtkContainer*) _tmp177_, (GtkWidget*) _tmp178_);
	_tmp179_ = main_box;
	_tmp180_ = editor_toolbar;
	gtk_container_add ((GtkContainer*) _tmp179_, (GtkWidget*) _tmp180_);
	_tmp181_ = main_box;
	_tmp182_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp182_);
	_tmp183_ = _tmp182_;
	gtk_container_add ((GtkContainer*) _tmp181_, (GtkWidget*) _tmp183_);
	_g_object_unref0 (_tmp183_);
	_tmp184_ = main_box;
	_tmp185_ = view_overlay;
	gtk_container_add ((GtkContainer*) _tmp184_, (GtkWidget*) _tmp185_);
	_tmp186_ = main_box;
	_tmp187_ = self->priv->attachment_box;
	gtk_container_add ((GtkContainer*) _tmp186_, (GtkWidget*) _tmp187_);
	_tmp188_ = main_box;
	_tmp189_ = action_bar;
	gtk_container_add ((GtkContainer*) _tmp188_, (GtkWidget*) _tmp189_);
	g_object_set ((GtkWindow*) self, "default-height", 500, NULL);
	g_object_set ((GtkWindow*) self, "default-width", 680, NULL);
	gtk_window_set_title ((GtkWindow*) self, _ ("New Message"));
	_tmp190_ = main_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp190_);
	gtk_widget_show_all ((GtkWidget*) self);
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) __mail_composer___lambda112__gtk_widget_delete_event, self, 0);
	_tmp191_ = mail_contact_manager_get_default ();
	_tmp192_ = _g_object_ref0 (_tmp191_);
	contact_manager = _tmp192_;
	_tmp193_ = contact_manager;
	_tmp194_ = self->priv->to_val;
	mail_contact_manager_setup_entry (_tmp193_, _tmp194_);
	_tmp195_ = contact_manager;
	_tmp196_ = self->priv->cc_val;
	mail_contact_manager_setup_entry (_tmp195_, _tmp196_);
	_tmp197_ = contact_manager;
	_tmp198_ = self->priv->bcc_val;
	mail_contact_manager_setup_entry (_tmp197_, _tmp198_);
	_tmp199_ = self->priv->from_combo;
	g_signal_connect_object ((GtkComboBox*) _tmp199_, "changed", (GCallback) __mail_composer___lambda114__gtk_combo_box_changed, self, 0);
	mail_composer_load_from_combobox (self);
	_tmp200_ = from_revealer;
	_tmp201_ = self->priv->from_combo;
	_tmp202_ = gtk_combo_box_get_model ((GtkComboBox*) _tmp201_);
	_tmp203_ = _tmp202_;
	gtk_revealer_set_reveal_child (_tmp200_, gtk_tree_model_iter_n_children (_tmp203_, NULL) > 1);
	_tmp204_ = send;
	g_object_bind_property_with_closures ((GObject*) self, "has-recipients", (GObject*) _tmp204_, "sensitive", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp205_ = headerbar;
	g_object_bind_property_with_closures ((GObject*) self, "title", (GObject*) _tmp205_, "title", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp206_ = self->priv->cc_button;
	g_signal_connect_object ((GtkButton*) _tmp206_, "clicked", (GCallback) __mail_composer___lambda115__gtk_button_clicked, self, 0);
	_tmp207_ = self->priv->cc_val;
	g_signal_connect_object ((GtkEditable*) _tmp207_, "changed", (GCallback) __mail_composer___lambda116__gtk_editable_changed, self, 0);
	_tmp208_ = _data17_->bcc_button;
	g_signal_connect_data ((GtkButton*) _tmp208_, "clicked", (GCallback) __mail_composer___lambda117__gtk_button_clicked, block17_data_ref (_data17_), (GClosureNotify) block17_data_unref, 0);
	_tmp209_ = self->priv->bcc_val;
	g_signal_connect_data ((GtkEditable*) _tmp209_, "changed", (GCallback) __mail_composer___lambda118__gtk_editable_changed, block17_data_ref (_data17_), (GClosureNotify) block17_data_unref, 0);
	_tmp210_ = self->priv->from_combo;
	g_signal_connect_object ((GtkComboBox*) _tmp210_, "changed", (GCallback) __mail_composer___lambda119__gtk_combo_box_changed, self, 0);
	_tmp211_ = self->priv->to_val;
	g_signal_connect_object ((GtkEditable*) _tmp211_, "changed", (GCallback) __mail_composer___lambda120__gtk_editable_changed, self, 0);
	_tmp212_ = self->priv->to_val;
	_tmp213_ = gtk_widget_get_style_context ((GtkWidget*) _tmp212_);
	g_signal_connect_data (_tmp213_, "changed", (GCallback) __mail_composer___lambda121__gtk_style_context_changed, block17_data_ref (_data17_), (GClosureNotify) block17_data_unref, 0);
	_tmp214_ = self->priv->_to;
	if (_tmp214_ != NULL) {
		GtkEntry* _tmp215_;
		const gchar* _tmp216_;
		_tmp215_ = self->priv->to_val;
		_tmp216_ = self->priv->_to;
		gtk_entry_set_text (_tmp215_, _tmp216_);
	}
	_tmp217_ = mail_backend_session_get_default ();
	session = _tmp217_;
	_tmp218_ = session;
	g_signal_connect_data (_tmp218_, "signature-changed", (GCallback) __mail_composer___lambda122__mail_backend_session_signature_changed, block17_data_ref (_data17_), (GClosureNotify) block17_data_unref, 0);
	_tmp219_ = _data17_->signature_menu;
	mail_composer_populate_signature_menu (self, _tmp219_);
	_tmp220_ = self->priv->_mailto_query;
	if (_tmp220_ != NULL) {
		GeeHashMultiMap* _result_ = NULL;
		GeeHashMultiMap* _tmp221_;
		gchar** params = NULL;
		const gchar* _tmp222_;
		gchar** _tmp223_;
		gchar** _tmp224_;
		gint params_length1;
		gint _params_size_;
		gchar** _tmp225_;
		gint _tmp225__length1;
		GeeHashMultiMap* _tmp239_;
		GeeHashMultiMap* _tmp249_;
		GeeHashMultiMap* _tmp259_;
		GeeHashMultiMap* _tmp268_;
		GeeHashMultiMap* _tmp279_;
		_tmp221_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_result_ = _tmp221_;
		_tmp222_ = self->priv->_mailto_query;
		_tmp224_ = _tmp223_ = g_strsplit (_tmp222_, "&", 0);
		params = _tmp224_;
		params_length1 = _vala_array_length (_tmp223_);
		_params_size_ = params_length1;
		_tmp225_ = params;
		_tmp225__length1 = params_length1;
		{
			gchar** param_collection = NULL;
			gint param_collection_length1 = 0;
			gint _param_collection_size_ = 0;
			gint param_it = 0;
			param_collection = _tmp225_;
			param_collection_length1 = _tmp225__length1;
			for (param_it = 0; param_it < param_collection_length1; param_it = param_it + 1) {
				const gchar* param = NULL;
				param = param_collection[param_it];
				{
					gchar** terms = NULL;
					const gchar* _tmp226_;
					gchar** _tmp227_;
					gchar** _tmp228_;
					gint terms_length1;
					gint _terms_size_;
					gchar** _tmp229_;
					gint _tmp229__length1;
					_tmp226_ = param;
					_tmp228_ = _tmp227_ = g_strsplit (_tmp226_, "=", 0);
					terms = _tmp228_;
					terms_length1 = _vala_array_length (_tmp227_);
					_terms_size_ = terms_length1;
					_tmp229_ = terms;
					_tmp229__length1 = terms_length1;
					if (_tmp229__length1 == 2) {
						GeeHashMultiMap* _tmp230_;
						gchar** _tmp231_;
						gint _tmp231__length1;
						const gchar* _tmp232_;
						gchar* _tmp233_;
						gchar* _tmp234_;
						gchar** _tmp235_;
						gint _tmp235__length1;
						const gchar* _tmp236_;
						gchar* _tmp237_;
						gchar* _tmp238_;
						_tmp230_ = _result_;
						_tmp231_ = terms;
						_tmp231__length1 = terms_length1;
						_tmp232_ = _tmp231_[0];
						_tmp233_ = g_utf8_strdown (_tmp232_, (gssize) -1);
						_tmp234_ = _tmp233_;
						_tmp235_ = terms;
						_tmp235__length1 = terms_length1;
						_tmp236_ = _tmp235_[1];
						_tmp237_ = g_uri_unescape_string (_tmp236_, NULL);
						_tmp238_ = _tmp237_;
						gee_multi_map_set ((GeeMultiMap*) _tmp230_, _tmp234_, _tmp238_);
						_g_free0 (_tmp238_);
						_g_free0 (_tmp234_);
					} else {
						g_critical ("Composer.vala:384: Invalid mailto URL");
					}
					terms = (_vala_array_free (terms, terms_length1, (GDestroyNotify) g_free), NULL);
				}
			}
		}
		_tmp239_ = _result_;
		if (gee_multi_map_contains ((GeeMultiMap*) _tmp239_, "bcc")) {
			GtkToggleButton* _tmp240_;
			GtkEntry* _tmp241_;
			GeeHashMultiMap* _tmp242_;
			GeeCollection* _tmp243_;
			GeeCollection* _tmp244_;
			gint _tmp245_ = 0;
			gpointer* _tmp246_;
			gchar** _tmp247_;
			gint _tmp247__length1;
			const gchar* _tmp248_;
			_tmp240_ = _data17_->bcc_button;
			gtk_button_clicked ((GtkButton*) _tmp240_);
			_tmp241_ = self->priv->bcc_val;
			_tmp242_ = _result_;
			_tmp243_ = gee_multi_map_get ((GeeMultiMap*) _tmp242_, "bcc");
			_tmp244_ = _tmp243_;
			_tmp246_ = gee_collection_to_array (_tmp244_, &_tmp245_);
			_tmp247_ = _tmp246_;
			_tmp247__length1 = _tmp245_;
			_tmp248_ = _tmp247_[0];
			gtk_entry_set_text (_tmp241_, _tmp248_);
			_tmp247_ = (_vala_array_free (_tmp247_, _tmp247__length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_tmp244_);
		}
		_tmp249_ = _result_;
		if (gee_multi_map_contains ((GeeMultiMap*) _tmp249_, "cc")) {
			GtkToggleButton* _tmp250_;
			GtkEntry* _tmp251_;
			GeeHashMultiMap* _tmp252_;
			GeeCollection* _tmp253_;
			GeeCollection* _tmp254_;
			gint _tmp255_ = 0;
			gpointer* _tmp256_;
			gchar** _tmp257_;
			gint _tmp257__length1;
			const gchar* _tmp258_;
			_tmp250_ = self->priv->cc_button;
			gtk_button_clicked ((GtkButton*) _tmp250_);
			_tmp251_ = self->priv->cc_val;
			_tmp252_ = _result_;
			_tmp253_ = gee_multi_map_get ((GeeMultiMap*) _tmp252_, "cc");
			_tmp254_ = _tmp253_;
			_tmp256_ = gee_collection_to_array (_tmp254_, &_tmp255_);
			_tmp257_ = _tmp256_;
			_tmp257__length1 = _tmp255_;
			_tmp258_ = _tmp257_[0];
			gtk_entry_set_text (_tmp251_, _tmp258_);
			_tmp257_ = (_vala_array_free (_tmp257_, _tmp257__length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_tmp254_);
		}
		_tmp259_ = _result_;
		if (gee_multi_map_contains ((GeeMultiMap*) _tmp259_, "subject")) {
			GtkEntry* _tmp260_;
			GeeHashMultiMap* _tmp261_;
			GeeCollection* _tmp262_;
			GeeCollection* _tmp263_;
			gint _tmp264_ = 0;
			gpointer* _tmp265_;
			gchar** _tmp266_;
			gint _tmp266__length1;
			const gchar* _tmp267_;
			_tmp260_ = self->priv->subject_val;
			_tmp261_ = _result_;
			_tmp262_ = gee_multi_map_get ((GeeMultiMap*) _tmp261_, "subject");
			_tmp263_ = _tmp262_;
			_tmp265_ = gee_collection_to_array (_tmp263_, &_tmp264_);
			_tmp266_ = _tmp265_;
			_tmp266__length1 = _tmp264_;
			_tmp267_ = _tmp266_[0];
			gtk_entry_set_text (_tmp260_, _tmp267_);
			_tmp266_ = (_vala_array_free (_tmp266_, _tmp266__length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_tmp263_);
		}
		_tmp268_ = _result_;
		if (gee_multi_map_contains ((GeeMultiMap*) _tmp268_, "body")) {
			CamelMimeFilterToHTMLFlags flags = 0U;
			MailWebView* _tmp269_;
			GeeHashMultiMap* _tmp270_;
			GeeCollection* _tmp271_;
			GeeCollection* _tmp272_;
			gint _tmp273_ = 0;
			gpointer* _tmp274_;
			gchar** _tmp275_;
			gint _tmp275__length1;
			const gchar* _tmp276_;
			gchar* _tmp277_;
			gchar* _tmp278_;
			flags = ((CAMEL_MIME_FILTER_TOHTML_CONVERT_ADDRESSES | CAMEL_MIME_FILTER_TOHTML_CONVERT_NL) | CAMEL_MIME_FILTER_TOHTML_CONVERT_SPACES) | CAMEL_MIME_FILTER_TOHTML_CONVERT_URLS;
			_tmp269_ = self->priv->web_view;
			_tmp270_ = _result_;
			_tmp271_ = gee_multi_map_get ((GeeMultiMap*) _tmp270_, "body");
			_tmp272_ = _tmp271_;
			_tmp274_ = gee_collection_to_array (_tmp272_, &_tmp273_);
			_tmp275_ = _tmp274_;
			_tmp275__length1 = _tmp273_;
			_tmp276_ = _tmp275_[0];
			_tmp277_ = camel_text_to_html (_tmp276_, flags, (guint32) 0);
			_tmp278_ = _tmp277_;
			mail_web_view_set_content_of_element (_tmp269_, "#elementary-message-body", _tmp278_);
			_g_free0 (_tmp278_);
			_tmp275_ = (_vala_array_free (_tmp275_, _tmp275__length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_tmp272_);
		}
		_tmp279_ = _result_;
		if (gee_multi_map_contains ((GeeMultiMap*) _tmp279_, "attachment")) {
			GtkFlowBox* _tmp299_;
			{
				GeeIterator* _path_it = NULL;
				GeeHashMultiMap* _tmp280_;
				GeeCollection* _tmp281_;
				GeeCollection* _tmp282_;
				GeeIterator* _tmp283_;
				GeeIterator* _tmp284_;
				_tmp280_ = _result_;
				_tmp281_ = gee_multi_map_get ((GeeMultiMap*) _tmp280_, "attachment");
				_tmp282_ = _tmp281_;
				_tmp283_ = gee_iterable_iterator ((GeeIterable*) _tmp282_);
				_tmp284_ = _tmp283_;
				_g_object_unref0 (_tmp282_);
				_path_it = _tmp284_;
				while (TRUE) {
					GeeIterator* _tmp285_;
					gchar* path = NULL;
					GeeIterator* _tmp286_;
					gpointer _tmp287_;
					GFile* _tmp288_ = NULL;
					const gchar* _tmp289_;
					GFile* file = NULL;
					GFile* _tmp294_;
					GtkFlowBox* _tmp295_;
					GFile* _tmp296_;
					MailComposerAttachment* _tmp297_;
					MailComposerAttachment* _tmp298_;
					_tmp285_ = _path_it;
					if (!gee_iterator_next (_tmp285_)) {
						break;
					}
					_tmp286_ = _path_it;
					_tmp287_ = gee_iterator_get (_tmp286_);
					path = (gchar*) _tmp287_;
					_tmp289_ = path;
					if (g_str_has_prefix (_tmp289_, "file://")) {
						const gchar* _tmp290_;
						GFile* _tmp291_;
						_tmp290_ = path;
						_tmp291_ = g_file_new_for_uri (_tmp290_);
						_g_object_unref0 (_tmp288_);
						_tmp288_ = _tmp291_;
					} else {
						const gchar* _tmp292_;
						GFile* _tmp293_;
						_tmp292_ = path;
						_tmp293_ = g_file_new_for_path (_tmp292_);
						_g_object_unref0 (_tmp288_);
						_tmp288_ = _tmp293_;
					}
					_tmp294_ = _g_object_ref0 (_tmp288_);
					file = _tmp294_;
					_tmp295_ = self->priv->attachment_box;
					_tmp296_ = file;
					_tmp297_ = mail_composer_attachment_new (_tmp296_, MAIL_COMPOSER_ATTACHMENT_DISPOSITION_ATTACHMENT);
					g_object_ref_sink (_tmp297_);
					_tmp298_ = _tmp297_;
					gtk_container_add ((GtkContainer*) _tmp295_, (GtkWidget*) _tmp298_);
					_g_object_unref0 (_tmp298_);
					_g_object_unref0 (file);
					_g_object_unref0 (_tmp288_);
					_g_free0 (path);
				}
				_g_object_unref0 (_path_it);
			}
			_tmp299_ = self->priv->attachment_box;
			gtk_widget_show_all ((GtkWidget*) _tmp299_);
		}
		params = (_vala_array_free (params, params_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (_result_);
	}
	_g_object_unref0 (contact_manager);
	_g_object_unref0 (main_box);
	_g_object_unref0 (view_overlay);
	_g_object_unref0 (action_bar);
	_g_object_unref0 (send);
	_g_object_unref0 (signature_button);
	_g_object_unref0 (attach);
	_g_object_unref0 (discard);
	_g_object_unref0 (editor_toolbar);
	_g_object_unref0 (image);
	_g_object_unref0 (recipient_grid);
	_g_object_unref0 (size_group);
	_g_object_unref0 (bcc_box);
	_g_object_unref0 (bcc_label);
	_g_object_unref0 (cc_box);
	_g_object_unref0 (cc_label);
	_g_object_unref0 (subject_label);
	_g_object_unref0 (to_label);
	_g_object_unref0 (from_revealer);
	_g_object_unref0 (from_box);
	_g_object_unref0 (from_label);
	_g_object_unref0 (headerbar);
	block17_data_unref (_data17_);
	_data17_ = NULL;
	return obj;
}

static void
mail_composer_class_init (MailComposerClass * klass,
                          gpointer klass_data)
{
	mail_composer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MailComposer_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_mail_composer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_mail_composer_set_property;
	G_OBJECT_CLASS (klass)->constructor = mail_composer_constructor;
	G_OBJECT_CLASS (klass)->finalize = mail_composer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_COMPOSER_HAS_RECIPIENTS_PROPERTY, mail_composer_properties[MAIL_COMPOSER_HAS_RECIPIENTS_PROPERTY] = g_param_spec_boolean ("has-recipients", "has-recipients", "has-recipients", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_COMPOSER_TO_PROPERTY, mail_composer_properties[MAIL_COMPOSER_TO_PROPERTY] = g_param_spec_string ("to", "to", "to", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_COMPOSER_MAILTO_QUERY_PROPERTY, mail_composer_properties[MAIL_COMPOSER_MAILTO_QUERY_PROPERTY] = g_param_spec_string ("mailto-query", "mailto-query", "mailto-query", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	mail_composer_signals[MAIL_COMPOSER_FINISHED_SIGNAL] = g_signal_new ("finished", MAIL_TYPE_COMPOSER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
mail_composer_instance_init (MailComposer * self,
                             gpointer klass)
{
	self->priv = mail_composer_get_instance_private (self);
	self->priv->discard_draft = FALSE;
	self->priv->ancestor_message_info = NULL;
}

static void
mail_composer_finalize (GObject * obj)
{
	MailComposer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_COMPOSER, MailComposer);
	_g_free0 (self->priv->_to);
	_g_free0 (self->priv->_mailto_query);
	_g_object_unref0 (self->priv->ancestor_message_info);
	_g_object_unref0 (self->priv->web_view);
	_g_object_unref0 (self->priv->to_val);
	_g_object_unref0 (self->priv->cc_val);
	_g_object_unref0 (self->priv->bcc_val);
	_g_object_unref0 (self->priv->attachment_box);
	_g_object_unref0 (self->priv->cc_revealer);
	_g_object_unref0 (self->priv->bcc_revealer);
	_g_object_unref0 (self->priv->cc_button);
	_g_object_unref0 (self->priv->message_url_overlay);
	_g_object_unref0 (self->priv->from_combo);
	_g_object_unref0 (self->priv->subject_val);
	G_OBJECT_CLASS (mail_composer_parent_class)->finalize (obj);
}

static GType
mail_composer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MailComposerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mail_composer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MailComposer), 0, (GInstanceInitFunc) mail_composer_instance_init, NULL };
	GType mail_composer_type_id;
	mail_composer_type_id = g_type_register_static (hdy_application_window_get_type (), "MailComposer", &g_define_type_info, 0);
	MailComposer_private_offset = g_type_add_instance_private (mail_composer_type_id, sizeof (MailComposerPrivate));
	return mail_composer_type_id;
}

GType
mail_composer_get_type (void)
{
	static volatile gsize mail_composer_type_id__once = 0;
	if (g_once_init_enter (&mail_composer_type_id__once)) {
		GType mail_composer_type_id;
		mail_composer_type_id = mail_composer_get_type_once ();
		g_once_init_leave (&mail_composer_type_id__once, mail_composer_type_id);
	}
	return mail_composer_type_id__once;
}

static void
_vala_mail_composer_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	MailComposer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_TYPE_COMPOSER, MailComposer);
	switch (property_id) {
		case MAIL_COMPOSER_HAS_RECIPIENTS_PROPERTY:
		g_value_set_boolean (value, mail_composer_get_has_recipients (self));
		break;
		case MAIL_COMPOSER_TO_PROPERTY:
		g_value_set_string (value, mail_composer_get_to (self));
		break;
		case MAIL_COMPOSER_MAILTO_QUERY_PROPERTY:
		g_value_set_string (value, mail_composer_get_mailto_query (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_mail_composer_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	MailComposer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_TYPE_COMPOSER, MailComposer);
	switch (property_id) {
		case MAIL_COMPOSER_HAS_RECIPIENTS_PROPERTY:
		mail_composer_set_has_recipients (self, g_value_get_boolean (value));
		break;
		case MAIL_COMPOSER_TO_PROPERTY:
		mail_composer_set_to (self, g_value_get_string (value));
		break;
		case MAIL_COMPOSER_MAILTO_QUERY_PROPERTY:
		mail_composer_set_mailto_query (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

