/*****************************************************************************
 * Copyright (c) 2014-2026 OpenRCT2 developers
 *
 * For a complete list of all authors, please refer to contributors.md
 * Interested in contributing? Visit https://github.com/OpenRCT2/OpenRCT2
 *
 * OpenRCT2 is licensed under the GNU General Public License version 3.
 *****************************************************************************/

#include "VehiclePaint.h"

#include "../../Game.h"
#include "../../GameState.h"
#include "../../SpriteIds.h"
#include "../../core/Speed.hpp"
#include "../../drawing/Drawing.h"
#include "../../drawing/LightFX.h"
#include "../../entity/EntityRegistry.h"
#include "../../entity/Yaw.hpp"
#include "../../interface/Viewport.h"
#include "../../ride/CarEntry.h"
#include "../../ride/RideData.h"
#include "../../ride/Track.h"
#include "../../ride/Vehicle.h"
#include "../Paint.h"

#include <iterator>

using namespace OpenRCT2;
using namespace OpenRCT2::Drawing;
using namespace OpenRCT2::Entity::Yaw;

#pragma region VehicleBoundboxes

// 0x0098E52C:
const VehicleBoundBox VehicleBoundboxes[16][224] = {
    {
        // 0x0099123C:
        { -5, -2, -22, 10, 4, 14 },   { -3, -3, -22, 6, 6, 14 },    { -3, -3, -22, 6, 6, 14 },    { -3, -3, -22, 6, 6, 14 },
        { -2, -5, -22, 4, 10, 14 },   { -3, -3, -22, 6, 6, 14 },    { -3, -3, -22, 6, 6, 14 },    { -3, -3, -22, 6, 6, 14 },
        { -5, -2, -22, 10, 4, 14 },   { -3, -3, -22, 6, 6, 14 },    { -3, -3, -22, 6, 6, 14 },    { -3, -3, -22, 6, 6, 14 },
        { -2, -5, -22, 4, 10, 14 },   { -3, -3, -22, 6, 6, 14 },    { -3, -3, -22, 6, 6, 14 },    { -3, -3, -22, 6, 6, 14 },
        { -5, -2, -22, 10, 4, 14 },   { -3, -3, -22, 6, 6, 14 },    { -3, -3, -22, 6, 6, 14 },    { -3, -3, -22, 6, 6, 14 },
        { -2, -5, -22, 4, 10, 14 },   { -3, -3, -22, 6, 6, 14 },    { -3, -3, -22, 6, 6, 14 },    { -3, -3, -22, 6, 6, 14 },
        { -5, -2, -22, 10, 4, 14 },   { -3, -3, -22, 6, 6, 14 },    { -3, -3, -22, 6, 6, 14 },    { -3, -3, -22, 6, 6, 14 },
        { -2, -5, -22, 4, 10, 14 },   { -3, -3, -22, 6, 6, 14 },    { -3, -3, -22, 6, 6, 14 },    { -3, -3, -22, 6, 6, 14 },
        { -10, -6, -22, 16, 12, 14 }, { -8, -8, -22, 16, 16, 14 },  { -6, -11, -27, 3, 16, 19 },  { -8, -8, -22, 16, 16, 14 },
        { -11, -6, -27, 16, 5, 19 },  { -8, -8, -22, 16, 16, 14 },  { -6, -10, -22, 12, 16, 14 }, { -8, -8, -22, 16, 16, 14 },
        { -10, -6, -22, 16, 12, 14 }, { -6, -6, -22, 12, 12, 14 },  { -6, -6, -22, 12, 12, 14 },  { -6, -6, -22, 12, 12, 14 },
        { -3, -10, -33, 3, 16, 27 },  { -6, -6, -22, 12, 12, 14 },  { -6, -6, -22, 12, 12, 14 },  { -6, -6, -22, 12, 12, 14 },
        { -13, -6, -33, 16, 5, 24 },  { -6, -6, -22, 12, 12, 14 },  { -6, -6, -22, 12, 12, 14 },  { -6, -6, -22, 12, 12, 14 },
        { -6, -10, -22, 12, 16, 14 }, { -6, -6, -22, 12, 12, 14 },  { -6, -6, -22, 12, 12, 14 },  { -6, -6, -22, 12, 12, 14 },
        { -10, -6, -33, 20, 12, 24 }, { -2, -3, -33, 3, 10, 29 },   { -13, -6, -33, 20, 5, 24 },  { -6, -10, -22, 12, 20, 14 },
        { -10, -6, -43, 5, 12, 34 },  { -10, -6, -43, 5, 12, 34 },  { -10, -6, -43, 5, 12, 34 },  { -10, -6, -43, 5, 12, 34 },
        { -2, 4, -33, 3, 10, 29 },    { -2, 4, -33, 3, 10, 29 },    { -2, 4, -33, 3, 10, 29 },    { -2, 4, -33, 3, 10, 29 },
        { -13, -6, -33, 20, 5, 24 },  { -13, -6, -33, 20, 5, 24 },  { -13, -6, -33, 20, 5, 24 },  { -13, -6, -33, 20, 5, 24 },
        { -6, -15, -22, 12, 10, 14 }, { -6, -15, -22, 12, 10, 14 }, { -6, -15, -22, 12, 10, 14 }, { -6, -15, -22, 12, 10, 14 },
        { -10, -6, -33, 4, 12, 24 },  { -2, 4, -10, 3, 10, 24 },    { -3, -6, -33, 10, 5, 24 },   { -6, -15, -10, 12, 10, 14 },
        { -10, -6, -22, 3, 12, 14 },  { -6, 0, -10, 3, 10, 24 },    { -3, -6, -22, 10, 5, 14 },   { -6, -15, -10, 12, 10, 14 },
        { -10, -6, -38, 20, 12, 7 },  { -6, 0, -5, 12, 10, 7 },     { 0, -6, -28, 10, 12, 7 },    { -6, -15, -5, 12, 10, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, 0, 5, 12, 10, 7 },      { 0, -6, 5, 10, 12, 7 },      { -6, -10, 5, 12, 10, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },    { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },    { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },
        { -8, -8, -22, 16, 16, 14 },  { -8, -8, -22, 16, 16, 14 },  { -8, -8, -22, 16, 16, 14 },  { -8, -8, -22, 16, 16, 14 },
        { -8, -8, -22, 16, 16, 14 },  { -8, -8, -22, 16, 16, 14 },  { -8, -8, -22, 16, 16, 14 },  { -8, -8, -22, 16, 16, 14 },
        { -8, -6, 11, 16, 12, 4 },    { -8, -6, 11, 16, 12, 4 },    { -8, -8, 11, 16, 16, 4 },    { -6, -8, 11, 12, 16, 4 },
        { -6, -8, 11, 12, 16, 4 },    { -6, -8, -22, 12, 16, 14 },  { -8, -8, -22, 16, 16, 14 },  { -8, -6, -22, 16, 12, 14 },
        { -8, -6, -22, 16, 12, 14 },  { -8, -6, -22, 16, 12, 14 },  { -8, -8, -22, 16, 16, 14 },  { -6, -8, -22, 12, 16, 14 },
        { -6, -8, -22, 12, 16, 14 },  { -6, -8, -22, 12, 16, 14 },  { -8, -8, -22, 16, 16, 14 },  { -8, -6, -22, 16, 12, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 }, { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 },
        { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },  { -6, -10, -22, 12, 20, 14 },
        { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },  { -6, -10, -22, 12, 20, 14 },
        { -10, -6, -22, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -22, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 }, { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -22, 12, 20, 14 }, { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -22, 12, 20, 14 }, { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -22, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -22, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 }, { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 },
        { -10, -6, -22, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 },
        { -10, -6, -22, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, -22, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, -22, 12, 20, 14 },
        { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 }, { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 },
        { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 }, { -10, -6, -22, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 }, { -10, -6, -22, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -22, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -22, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
    },
    {
        // 0x0099027C:
        { -8, -6, -28, 16, 12, 14 },  { -8, -6, -28, 16, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -8, -28, 12, 16, 14 },
        { -6, -8, -28, 12, 16, 14 },  { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -6, -28, 16, 12, 14 },
        { -8, -6, -28, 16, 12, 14 },  { -8, -6, -28, 16, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -8, -28, 12, 16, 14 },
        { -6, -8, -28, 12, 16, 14 },  { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -6, -28, 16, 12, 14 },
        { -6, -6, -28, 12, 12, 14 },  { -9, -6, -28, 18, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -9, -28, 12, 18, 14 },
        { -6, -6, -28, 12, 12, 14 },  { -6, -9, -28, 12, 18, 14 },  { -8, -8, -28, 16, 16, 14 },  { -9, -6, -28, 18, 12, 14 },
        { -6, -6, -28, 12, 12, 14 },  { -9, -6, -28, 18, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -9, -28, 12, 18, 14 },
        { -6, -6, -28, 12, 12, 14 },  { -6, -9, -28, 12, 18, 14 },  { -8, -8, -28, 16, 16, 14 },  { -9, -6, -28, 18, 12, 14 },
        { -10, -6, -28, 16, 12, 14 }, { -8, -8, -28, 16, 16, 14 },  { -6, -11, -33, 3, 16, 19 },  { -8, -8, -28, 16, 16, 14 },
        { -11, -6, -33, 16, 5, 19 },  { -8, -8, -28, 16, 16, 14 },  { -6, -10, -28, 12, 16, 14 }, { -8, -8, -28, 16, 16, 14 },
        { -10, -6, -28, 16, 12, 14 }, { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },
        { -3, -10, -39, 3, 16, 27 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },
        { -10, -6, -39, 16, 3, 27 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },
        { -6, -10, -28, 12, 16, 14 }, { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -2, -3, -39, 3, 10, 29 },   { -3, -2, -39, 10, 3, 29 },   { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -49, 5, 12, 34 },  { -10, -6, -49, 5, 12, 34 },  { -10, -6, -49, 5, 12, 34 },  { -10, -6, -49, 5, 12, 34 },
        { -2, 4, -39, 3, 10, 29 },    { -2, 4, -39, 3, 10, 29 },    { -2, 4, -39, 3, 10, 29 },    { -2, 4, -39, 3, 10, 29 },
        { -13, -6, -39, 20, 5, 24 },  { -13, -6, -39, 20, 5, 24 },  { -13, -6, -39, 20, 5, 24 },  { -13, -6, -39, 20, 5, 24 },
        { -6, -15, -28, 12, 10, 14 }, { -6, -15, -28, 12, 10, 14 }, { -6, -15, -28, 12, 10, 14 }, { -6, -15, -28, 12, 10, 14 },
        { -10, -6, -39, 4, 12, 24 },  { -2, 4, -10, 3, 10, 24 },    { -3, -6, -39, 10, 5, 24 },   { -6, -15, -10, 12, 10, 14 },
        { -10, -6, -28, 3, 12, 14 },  { -6, 0, -10, 3, 10, 24 },    { -3, -6, -28, 10, 5, 14 },   { -6, -15, -10, 12, 10, 14 },
        { -10, -6, -44, 20, 12, 7 },  { -6, 0, -5, 12, 10, 7 },     { 0, -6, -34, 10, 12, 7 },    { -6, -15, -5, 12, 10, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, 0, 5, 12, 10, 7 },      { 0, -6, 5, 10, 12, 7 },      { -6, -10, 5, 12, 10, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },    { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },    { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },
        { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },
        { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },
        { -8, -6, 11, 16, 12, 4 },    { -8, -6, 11, 16, 12, 4 },    { -8, -8, 11, 16, 16, 4 },    { -6, -8, 11, 12, 16, 4 },
        { -6, -8, 11, 12, 16, 4 },    { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -6, -28, 16, 12, 14 },
        { -8, -6, -28, 16, 12, 14 },  { -8, -6, -28, 16, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -8, -28, 12, 16, 14 },
        { -6, -8, -28, 12, 16, 14 },  { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -6, -28, 16, 12, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
    },
    {
        // 0x009907BC:
        { -8, -6, -23, 16, 12, 14 },  { -8, -6, -23, 16, 12, 14 },  { -8, -8, -23, 16, 16, 14 },  { -6, -8, -23, 12, 16, 14 },
        { -6, -8, -23, 12, 16, 14 },  { -6, -8, -23, 12, 16, 14 },  { -8, -8, -23, 16, 16, 14 },  { -8, -6, -23, 16, 12, 14 },
        { -8, -6, -23, 16, 12, 14 },  { -8, -6, -23, 16, 12, 14 },  { -8, -8, -23, 16, 16, 14 },  { -6, -8, -23, 12, 16, 14 },
        { -6, -8, -23, 12, 16, 14 },  { -6, -8, -23, 12, 16, 14 },  { -8, -8, -23, 16, 16, 14 },  { -8, -6, -23, 16, 12, 14 },
        { -6, -6, -23, 12, 12, 14 },  { -9, -6, -23, 18, 12, 14 },  { -8, -8, -23, 16, 16, 14 },  { -6, -9, -23, 12, 18, 14 },
        { -6, -6, -23, 12, 12, 14 },  { -6, -9, -23, 12, 18, 14 },  { -8, -8, -23, 16, 16, 14 },  { -9, -6, -23, 18, 12, 14 },
        { -6, -6, -23, 12, 12, 14 },  { -9, -6, -23, 18, 12, 14 },  { -8, -8, -23, 16, 16, 14 },  { -6, -9, -23, 12, 18, 14 },
        { -6, -6, -23, 12, 12, 14 },  { -6, -9, -23, 12, 18, 14 },  { -8, -8, -23, 16, 16, 14 },  { -9, -6, -23, 18, 12, 14 },
        { -10, -6, -23, 16, 12, 14 }, { -8, -8, -23, 16, 16, 14 },  { -6, -11, -28, 3, 16, 19 },  { -8, -8, -23, 16, 16, 14 },
        { -11, -6, -28, 16, 5, 19 },  { -8, -8, -23, 16, 16, 14 },  { -6, -10, -23, 12, 16, 14 }, { -8, -8, -23, 16, 16, 14 },
        { -10, -6, -23, 16, 12, 14 }, { -6, -6, -23, 12, 12, 14 },  { -6, -6, -23, 12, 12, 14 },  { -6, -6, -23, 12, 12, 14 },
        { -3, -10, -34, 3, 16, 27 },  { -6, -6, -23, 12, 12, 14 },  { -6, -6, -23, 12, 12, 14 },  { -6, -6, -23, 12, 12, 14 },
        { -13, -6, -34, 16, 5, 24 },  { -6, -6, -23, 12, 12, 14 },  { -6, -6, -23, 12, 12, 14 },  { -6, -6, -23, 12, 12, 14 },
        { -6, -10, -23, 12, 16, 14 }, { -6, -6, -23, 12, 12, 14 },  { -6, -6, -23, 12, 12, 14 },  { -6, -6, -23, 12, 12, 14 },
        { -10, -6, -34, 20, 12, 24 }, { -2, -3, -34, 3, 10, 29 },   { -13, -6, -34, 20, 5, 24 },  { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -44, 5, 12, 34 },  { -10, -6, -44, 5, 12, 34 },  { -10, -6, -44, 5, 12, 34 },  { -10, -6, -44, 5, 12, 34 },
        { -2, 4, -34, 3, 10, 29 },    { -2, 4, -34, 3, 10, 29 },    { -2, 4, -34, 3, 10, 29 },    { -2, 4, -34, 3, 10, 29 },
        { -13, -6, -34, 20, 5, 24 },  { -13, -6, -34, 20, 5, 24 },  { -13, -6, -34, 20, 5, 24 },  { -13, -6, -34, 20, 5, 24 },
        { -6, -15, -23, 12, 10, 14 }, { -6, -15, -23, 12, 10, 14 }, { -6, -15, -23, 12, 10, 14 }, { -6, -15, -23, 12, 10, 14 },
        { -10, -6, -34, 4, 12, 24 },  { -2, 4, -10, 3, 10, 24 },    { -3, -6, -34, 10, 5, 24 },   { -6, -15, -10, 12, 10, 14 },
        { -10, -6, -23, 3, 12, 14 },  { -6, 0, -10, 3, 10, 24 },    { -3, -6, -23, 10, 5, 14 },   { -6, -15, -10, 12, 10, 14 },
        { -10, -6, -39, 20, 12, 7 },  { -6, 0, -5, 12, 10, 7 },     { 0, -6, -29, 10, 12, 7 },    { -6, -15, -5, 12, 10, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, 0, 5, 12, 10, 7 },      { 0, -6, 5, 10, 12, 7 },      { -6, -10, 5, 12, 10, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },    { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },    { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },
        { -8, -8, -23, 16, 16, 14 },  { -8, -8, -23, 16, 16, 14 },  { -8, -8, -23, 16, 16, 14 },  { -8, -8, -23, 16, 16, 14 },
        { -8, -8, -23, 16, 16, 14 },  { -8, -8, -23, 16, 16, 14 },  { -8, -8, -23, 16, 16, 14 },  { -8, -8, -23, 16, 16, 14 },
        { -8, -6, 11, 16, 12, 4 },    { -8, -6, 11, 16, 12, 4 },    { -8, -8, 11, 16, 16, 4 },    { -6, -8, 11, 12, 16, 4 },
        { -6, -8, 11, 12, 16, 4 },    { -6, -8, -23, 12, 16, 14 },  { -8, -8, -23, 16, 16, 14 },  { -8, -6, -23, 16, 12, 14 },
        { -8, -6, -23, 16, 12, 14 },  { -8, -6, -23, 16, 12, 14 },  { -8, -8, -23, 16, 16, 14 },  { -6, -8, -23, 12, 16, 14 },
        { -6, -8, -23, 12, 16, 14 },  { -6, -8, -23, 12, 16, 14 },  { -8, -8, -23, 16, 16, 14 },  { -8, -6, -23, 16, 12, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },  { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },  { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -23, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -23, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -23, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -23, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
    },
    {
        // 0x009921FC:
        { -19, -6, -28, 38, 12, 14 }, { -11, -6, -28, 22, 12, 14 }, { -11, -11, -28, 22, 22, 14 }, { -6, -11, -28, 12, 22, 14 },
        { -6, -19, -28, 12, 38, 14 }, { -6, -11, -28, 12, 22, 14 }, { -11, -11, -28, 22, 22, 14 }, { -11, -6, -28, 22, 12, 14 },
        { -19, -6, -28, 38, 12, 14 }, { -11, -6, -28, 22, 12, 14 }, { -11, -11, -28, 22, 22, 14 }, { -6, -11, -28, 12, 22, 14 },
        { -6, -19, -28, 12, 38, 14 }, { -6, -11, -28, 12, 22, 14 }, { -11, -11, -28, 22, 22, 14 }, { -11, -6, -28, 22, 12, 14 },
        { -15, -6, -28, 18, 12, 14 }, { -9, -6, -28, 18, 12, 14 },  { -8, -8, -28, 16, 16, 14 },   { -6, -9, -28, 12, 18, 14 },
        { -6, -6, -28, 12, 28, 14 },  { -6, -9, -28, 12, 18, 14 },  { -8, -8, -28, 16, 16, 14 },   { -9, -6, -28, 18, 12, 14 },
        { -6, -6, -28, 28, 12, 14 },  { -9, -6, -28, 18, 12, 14 },  { -8, -8, -28, 16, 16, 14 },   { -6, -9, -28, 12, 18, 14 },
        { -6, -15, -28, 12, 18, 14 }, { -6, -9, -28, 12, 18, 14 },  { -8, -8, -28, 16, 16, 14 },   { -9, -6, -28, 18, 12, 14 },
        { -10, -6, -28, 16, 12, 14 }, { -8, -8, -28, 16, 16, 14 },  { -6, -11, -33, 3, 16, 19 },   { -8, -8, -28, 16, 16, 14 },
        { -11, -6, -33, 16, 5, 19 },  { -8, -8, -28, 16, 16, 14 },  { -6, -10, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },
        { -10, -6, -28, 16, 12, 14 }, { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },   { -6, -6, -28, 12, 12, 14 },
        { -3, -10, -39, 3, 16, 27 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },   { -6, -6, -28, 12, 12, 14 },
        { -13, -6, -39, 16, 5, 24 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },   { -6, -6, -28, 12, 12, 14 },
        { -6, -10, -28, 12, 16, 14 }, { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },   { -6, -6, -28, 12, 12, 14 },
        { -10, -6, -39, 20, 12, 24 }, { -2, -3, -39, 3, 10, 29 },   { -13, -6, -39, 20, 5, 24 },   { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -49, 5, 12, 34 },  { -10, -6, -49, 5, 12, 34 },  { -10, -6, -49, 5, 12, 34 },   { -10, -6, -49, 5, 12, 34 },
        { -2, 4, -39, 3, 10, 29 },    { -2, 4, -39, 3, 10, 29 },    { -2, 4, -39, 3, 10, 29 },     { -2, 4, -39, 3, 10, 29 },
        { -13, -6, -39, 20, 5, 24 },  { -13, -6, -39, 20, 5, 24 },  { -13, -6, -39, 20, 5, 24 },   { -13, -6, -39, 20, 5, 24 },
        { -6, -15, -28, 12, 10, 14 }, { -6, -15, -28, 12, 10, 14 }, { -6, -15, -28, 12, 10, 14 },  { -6, -15, -28, 12, 10, 14 },
        { -10, -6, -39, 4, 12, 24 },  { -2, 4, -10, 3, 10, 24 },    { -3, -6, -39, 10, 5, 24 },    { -6, -15, -10, 12, 10, 14 },
        { -10, -6, -28, 3, 12, 14 },  { -6, 0, -10, 3, 10, 24 },    { -3, -6, -28, 10, 5, 14 },    { -6, -15, -10, 12, 10, 14 },
        { -10, -6, -44, 20, 12, 7 },  { -6, 0, -5, 12, 10, 7 },     { 0, -6, -34, 10, 12, 7 },     { -6, -15, -5, 12, 10, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, 0, 5, 12, 10, 7 },      { 0, -6, 5, 10, 12, 7 },       { -6, -10, 5, 12, 10, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },    { -10, -6, 5, 20, 12, 7 },     { -6, -10, 5, 12, 20, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },    { -10, -6, 5, 20, 12, 7 },     { -6, -10, 5, 12, 20, 7 },
        { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },   { -8, -8, -28, 16, 16, 14 },
        { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },   { -8, -8, -28, 16, 16, 14 },
        { -8, -6, 11, 16, 12, 4 },    { -8, -6, 11, 16, 12, 4 },    { -8, -8, 11, 16, 16, 4 },     { -6, -8, 11, 12, 16, 4 },
        { -6, -8, 11, 12, 16, 4 },    { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },   { -8, -6, -28, 16, 12, 14 },
        { -8, -6, -28, 16, 12, 14 },  { -8, -6, -28, 16, 12, 14 },  { -8, -8, -28, 16, 16, 14 },   { -6, -8, -28, 12, 16, 14 },
        { -6, -8, -28, 12, 16, 14 },  { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },   { -8, -6, -28, 16, 12, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },   { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },   { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },   { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },   { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },   { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },   { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },   { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },   { -6, -10, 11, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },   { -6, -10, 11, 12, 20, 14 },
    },
    {
        // 0x00991CBC:
        { -24, -6, -28, 32, 12, 14 }, { -11, -6, -28, 22, 12, 14 }, { -11, -11, -28, 22, 22, 14 }, { -6, -11, -28, 12, 22, 14 },
        { -6, -11, -28, 12, 32, 14 }, { -6, -11, -28, 12, 22, 14 }, { -11, -11, -28, 22, 22, 14 }, { -11, -6, -28, 22, 12, 14 },
        { -11, -6, -28, 32, 12, 14 }, { -11, -6, -28, 22, 12, 14 }, { -11, -11, -28, 22, 22, 14 }, { -6, -11, -28, 12, 22, 14 },
        { -6, -24, -28, 12, 32, 14 }, { -6, -11, -28, 12, 22, 14 }, { -11, -11, -28, 22, 22, 14 }, { -11, -6, -28, 22, 12, 14 },
        { -15, -6, -28, 18, 12, 14 }, { -9, -6, -28, 18, 12, 14 },  { -8, -8, -28, 16, 16, 14 },   { -6, -9, -28, 12, 18, 14 },
        { -6, -6, -28, 12, 28, 14 },  { -6, -9, -28, 12, 18, 14 },  { -8, -8, -28, 16, 16, 14 },   { -9, -6, -28, 18, 12, 14 },
        { -6, -6, -28, 28, 12, 14 },  { -9, -6, -28, 18, 12, 14 },  { -8, -8, -28, 16, 16, 14 },   { -6, -9, -28, 12, 18, 14 },
        { -6, -15, -28, 12, 18, 14 }, { -6, -9, -28, 12, 18, 14 },  { -8, -8, -28, 16, 16, 14 },   { -9, -6, -28, 18, 12, 14 },
        { -10, -6, -28, 16, 12, 14 }, { -8, -8, -28, 16, 16, 14 },  { -6, -11, -33, 3, 16, 19 },   { -8, -8, -28, 16, 16, 14 },
        { -11, -6, -33, 16, 5, 19 },  { -8, -8, -28, 16, 16, 14 },  { -6, -10, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },
        { -10, -6, -28, 16, 12, 14 }, { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },   { -6, -6, -28, 12, 12, 14 },
        { -3, -10, -39, 3, 16, 27 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },   { -6, -6, -28, 12, 12, 14 },
        { -13, -6, -39, 16, 5, 24 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },   { -6, -6, -28, 12, 12, 14 },
        { -6, -10, -28, 12, 16, 14 }, { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },   { -6, -6, -28, 12, 12, 14 },
        { -10, -6, -39, 20, 12, 24 }, { -2, -3, -39, 3, 10, 29 },   { -13, -6, -39, 20, 5, 24 },   { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -49, 5, 12, 34 },  { -10, -6, -49, 5, 12, 34 },  { -10, -6, -49, 5, 12, 34 },   { -10, -6, -49, 5, 12, 34 },
        { -2, 4, -39, 3, 10, 29 },    { -2, 4, -39, 3, 10, 29 },    { -2, 4, -39, 3, 10, 29 },     { -2, 4, -39, 3, 10, 29 },
        { -13, -6, -39, 20, 5, 24 },  { -13, -6, -39, 20, 5, 24 },  { -13, -6, -39, 20, 5, 24 },   { -13, -6, -39, 20, 5, 24 },
        { -6, -15, -28, 12, 10, 14 }, { -6, -15, -28, 12, 10, 14 }, { -6, -15, -28, 12, 10, 14 },  { -6, -15, -28, 12, 10, 14 },
        { -10, -6, -39, 4, 12, 24 },  { -2, 4, -10, 3, 10, 24 },    { -3, -6, -39, 10, 5, 24 },    { -6, -15, -10, 12, 10, 14 },
        { -10, -6, -28, 3, 12, 14 },  { -6, 0, -10, 3, 10, 24 },    { -3, -6, -28, 10, 5, 14 },    { -6, -15, -10, 12, 10, 14 },
        { -10, -6, -44, 20, 12, 7 },  { -6, 0, -5, 12, 10, 7 },     { 0, -6, -34, 10, 12, 7 },     { -6, -15, -5, 12, 10, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, 0, 5, 12, 10, 7 },      { 0, -6, 5, 10, 12, 7 },       { -6, -10, 5, 12, 10, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },    { -10, -6, 5, 20, 12, 7 },     { -6, -10, 5, 12, 20, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },    { -10, -6, 5, 20, 12, 7 },     { -6, -10, 5, 12, 20, 7 },
        { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },   { -8, -8, -28, 16, 16, 14 },
        { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },   { -8, -8, -28, 16, 16, 14 },
        { -8, -6, 11, 16, 12, 4 },    { -8, -6, 11, 16, 12, 4 },    { -8, -8, 11, 16, 16, 4 },     { -6, -8, 11, 12, 16, 4 },
        { -6, -8, 11, 12, 16, 4 },    { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },   { -8, -6, -28, 16, 12, 14 },
        { -8, -6, -28, 16, 12, 14 },  { -8, -6, -28, 16, 12, 14 },  { -8, -8, -28, 16, 16, 14 },   { -6, -8, -28, 12, 16, 14 },
        { -6, -8, -28, 12, 16, 14 },  { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },   { -8, -6, -28, 16, 12, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },   { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },   { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },   { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },   { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },   { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },   { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },   { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },   { -6, -10, 11, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },   { -6, -10, 11, 12, 20, 14 },
    },
    {
        // 0x0098F52C
        { -14, -6, 1, 28, 12, 14 },   { -12, -6, 1, 24, 12, 14 },   { -10, -10, 1, 20, 20, 14 },  { -6, -12, 1, 12, 24, 14 },
        { -6, -14, 1, 12, 28, 14 },   { -6, -12, 1, 12, 24, 14 },   { -10, -10, 1, 20, 20, 14 },  { -12, -6, 1, 24, 12, 14 },
        { -14, -6, 1, 28, 12, 14 },   { -12, -6, 1, 24, 12, 14 },   { -10, -10, 1, 20, 20, 14 },  { -6, -12, 1, 12, 24, 14 },
        { -6, -14, 1, 12, 28, 14 },   { -6, -12, 1, 12, 24, 14 },   { -10, -10, 1, 20, 20, 14 },  { -12, -6, 1, 24, 12, 14 },
        { -13, -6, 1, 26, 12, 14 },   { -11, -6, 1, 22, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -11, 1, 12, 22, 14 },
        { -6, -13, 3, 12, 26, 14 },   { -6, -11, 1, 12, 22, 14 },   { -8, -8, 1, 16, 16, 14 },    { -11, -6, 1, 22, 12, 14 },
        { -13, -6, 3, 26, 12, 14 },   { -11, -6, 1, 22, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -11, 1, 12, 22, 14 },
        { -6, -13, 1, 12, 26, 14 },   { -6, -11, 1, 12, 22, 14 },   { -8, -8, 1, 16, 16, 14 },    { -11, -6, 1, 22, 12, 14 },
        { -14, -6, 1, 28, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -14, 1, 12, 28, 14 },   { -8, -8, 1, 16, 16, 14 },
        { -18, -6, 1, 28, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -14, 1, 12, 28, 14 },   { 0, 0, 1, 8, 8, 14 },
        { -3, -6, 5, 6, 12, 7 },      { -8, -6, 1, 16, 12, 7 },     { -8, -8, 1, 16, 16, 7 },     { -6, -8, 1, 12, 16, 7 },
        { -6, -8, 5, 12, 6, 7 },      { -6, -8, 1, 12, 16, 7 },     { -8, -8, 1, 16, 16, 7 },     { -8, -6, 1, 16, 12, 7 },
        { -8, -6, 5, 6, 12, 7 },      { -8, -6, 1, 16, 12, 7 },     { -8, -8, 1, 16, 16, 7 },     { -6, -8, 1, 12, 16, 7 },
        { -6, -3, 5, 12, 6, 7 },      { -6, -8, 1, 12, 16, 7 },     { -8, -8, 1, 16, 16, 7 },     { -8, -6, 1, 16, 12, 7 },
        { 0, -6, 5, 3, 12, 5 },       { -6, -13, 5, 3, 12, 5 },     { -13, -6, 5, 12, 5, 5 },     { -6, 0, 5, 12, 3, 5 },
        { 0, -6, -8, 10, 12, 15 },    { 0, -6, -8, 10, 12, 15 },    { 0, -6, -8, 10, 12, 15 },    { -6, -12, -8, 12, 10, 15 },
        { -6, -12, -8, 12, 10, 15 },  { -6, -12, -8, 12, 10, 15 },  { -6, -12, -8, 12, 10, 15 },  { -6, -12, -8, 12, 10, 15 },
        { -12, -6, -8, 10, 12, 15 },  { -12, -6, -8, 10, 12, 15 },  { -12, -6, -8, 10, 12, 15 },  { -6, 0, -8, 12, 10, 15 },
        { -6, 0, -8, 12, 10, 15 },    { -6, 0, -8, 12, 10, 15 },    { -6, 0, -8, 12, 10, 15 },    { -6, 0, -8, 12, 10, 15 },
        { -3, -6, -4, 6, 12, 5 },     { -6, -13, -4, 3, 20, 5 },    { -13, -6, -4, 6, 5, 5 },     { -6, -3, -4, 12, 20, 5 },
        { -3, -6, 1, 6, 12, 6 },      { -6, -13, -10, 3, 6, 6 },    { -13, -6, -10, 6, 5, 6 },    { -6, -3, 1, 12, 6, 6 },
        { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },  { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },
        { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },  { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },
        { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },  { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },
        { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },  { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },
        { -10, -10, 1, 20, 20, 14 },  { -10, -10, 1, 20, 20, 14 },  { -10, -10, 1, 20, 20, 14 },  { -10, -10, 1, 20, 20, 14 },
        { -8, -8, 1, 16, 16, 14 },    { -32, -32, 24, 4, 4, 14 },   { -8, -8, 1, 16, 16, 14 },    { 8, 8, 1, 8, 8, 14 },
        { -14, -6, 1, 28, 12, 14 },   { -12, -6, 1, 24, 12, 14 },   { -10, -10, 1, 20, 20, 14 },  { -6, -12, 1, 12, 24, 14 },
        { -6, -14, 1, 12, 28, 14 },   { -6, -12, 1, 12, 24, 14 },   { -10, -10, 1, 20, 20, 14 },  { -12, -6, 1, 24, 12, 14 },
        { -14, -6, 1, 28, 12, 14 },   { -12, -6, 1, 24, 12, 14 },   { -10, -10, 1, 20, 20, 14 },  { -6, -12, 1, 12, 24, 14 },
        { -6, -14, 1, 12, 28, 14 },   { -6, -12, 1, 12, 24, 14 },   { -10, -10, 1, 20, 20, 14 },  { -12, -6, 1, 24, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
    },
    {
        // 0x0098EFEC:
        { -10, -6, 1, 20, 12, 14 },   { -9, -6, 1, 18, 12, 14 },    { -8, -8, 1, 16, 16, 14 },    { -6, -9, 1, 12, 18, 14 },
        { -6, -10, 1, 12, 20, 14 },   { -6, -9, 1, 12, 18, 14 },    { -8, -8, 1, 16, 16, 14 },    { -9, -6, 1, 18, 12, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -9, -6, 1, 18, 12, 14 },    { -8, -8, 1, 16, 16, 14 },    { -6, -9, 1, 12, 18, 14 },
        { -6, -10, 1, 12, 20, 14 },   { -6, -9, 1, 12, 18, 14 },    { -8, -8, 1, 16, 16, 14 },    { -9, -6, 1, 18, 12, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -8, -6, 1, 16, 12, 14 },    { -8, -8, 1, 16, 16, 14 },    { -6, -8, 1, 12, 16, 14 },
        { -6, -10, 2, 12, 20, 14 },   { -6, -8, 1, 12, 16, 14 },    { -8, -8, 1, 16, 16, 14 },    { -8, -6, 1, 16, 12, 14 },
        { -10, -6, 2, 20, 12, 14 },   { -8, -6, 1, 16, 12, 14 },    { -8, -8, 1, 16, 16, 14 },    { -6, -8, 1, 12, 16, 14 },
        { -6, -10, 1, 12, 20, 14 },   { -6, -8, 1, 12, 16, 14 },    { -8, -8, 1, 16, 16, 14 },    { -8, -6, 1, 16, 12, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -10, 1, 12, 20, 14 },   { -8, -8, 1, 16, 16, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -10, 1, 12, 20, 14 },   { 0, 0, 1, 8, 8, 14 },
        { -3, -6, 5, 6, 12, 7 },      { -8, -6, 1, 16, 12, 7 },     { -8, -8, 1, 16, 16, 7 },     { -6, -8, 1, 12, 16, 7 },
        { -6, -8, 5, 12, 6, 7 },      { -6, -8, 1, 12, 16, 7 },     { -8, -8, 1, 16, 16, 7 },     { -8, -6, 1, 16, 12, 7 },
        { -8, -6, 5, 6, 12, 7 },      { -8, -6, 1, 16, 12, 7 },     { -8, -8, 1, 16, 16, 7 },     { -6, -8, 1, 12, 16, 7 },
        { -6, -3, 5, 12, 6, 7 },      { -6, -8, 1, 12, 16, 7 },     { -8, -8, 1, 16, 16, 7 },     { -8, -6, 1, 16, 12, 7 },
        { 0, -6, 5, 3, 12, 5 },       { -6, -13, 5, 3, 12, 5 },     { -13, -6, 5, 12, 5, 5 },     { -6, 0, 5, 12, 3, 5 },
        { 0, -6, -8, 10, 12, 15 },    { 0, -6, -8, 10, 12, 15 },    { 0, -6, -8, 10, 12, 15 },    { -6, -12, -8, 12, 10, 15 },
        { -6, -12, -8, 12, 10, 15 },  { -6, -12, -8, 12, 10, 15 },  { -6, -12, -8, 12, 10, 15 },  { -6, -12, -8, 12, 10, 15 },
        { -12, -6, -8, 10, 12, 15 },  { -12, -6, -8, 10, 12, 15 },  { -12, -6, -8, 10, 12, 15 },  { -6, 0, -8, 12, 10, 15 },
        { -6, 0, -8, 12, 10, 15 },    { -6, 0, -8, 12, 10, 15 },    { -6, 0, -8, 12, 10, 15 },    { -6, 0, -8, 12, 10, 15 },
        { -3, -6, -4, 6, 12, 5 },     { -6, -13, -4, 3, 20, 5 },    { -13, -6, -4, 6, 5, 5 },     { -6, -3, -4, 12, 20, 5 },
        { -3, -6, 1, 6, 12, 6 },      { -6, -13, -10, 3, 6, 6 },    { -13, -6, -10, 6, 5, 6 },    { -6, -3, 1, 12, 6, 6 },
        { -10, -6, -15, 20, 12, 7 },  { -6, -10, -15, 12, 20, 7 },  { -10, -6, -15, 20, 12, 7 },  { -6, -10, -15, 12, 20, 7 },
        { -10, -6, -15, 20, 12, 7 },  { -6, -10, -15, 12, 20, 7 },  { -10, -6, -15, 20, 12, 7 },  { -6, -10, -15, 12, 20, 7 },
        { -10, -6, -15, 20, 12, 7 },  { -6, -10, -15, 12, 20, 7 },  { -10, -6, -15, 20, 12, 7 },  { -6, -10, -15, 12, 20, 7 },
        { -10, -6, -15, 20, 12, 7 },  { -6, -10, -15, 12, 20, 7 },  { -10, -6, -15, 20, 12, 7 },  { -6, -10, -15, 12, 20, 7 },
        { -8, -8, 1, 16, 16, 14 },    { -8, -8, 1, 16, 16, 14 },    { -8, -8, 1, 16, 16, 14 },    { -8, -8, 1, 16, 16, 14 },
        { -8, -8, 1, 16, 16, 14 },    { -32, -32, 24, 4, 4, 14 },   { -8, -8, 1, 16, 16, 14 },    { 8, 8, 1, 8, 8, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -9, -6, 1, 18, 12, 14 },    { -8, -8, 1, 16, 16, 14 },    { -6, -9, 1, 12, 18, 14 },
        { -6, -10, 1, 12, 20, 14 },   { -6, -9, 1, 12, 18, 14 },    { -8, -8, 1, 16, 16, 14 },    { -9, -6, 1, 18, 12, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -9, -6, 1, 18, 12, 14 },    { -8, -8, 1, 16, 16, 14 },    { -6, -9, 1, 12, 18, 14 },
        { -6, -10, 1, 12, 20, 14 },   { -6, -9, 1, 12, 18, 14 },    { -8, -8, 1, 16, 16, 14 },    { -9, -6, 1, 18, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
    },
    {
        // 0x0098EAAC:
        { -8, -6, 1, 16, 12, 14 },    { -7, -6, 1, 14, 12, 14 },    { -6, -6, 1, 12, 12, 14 },    { -6, -7, 1, 12, 14, 14 },
        { -6, -8, 1, 12, 16, 14 },    { -6, -7, 1, 12, 14, 14 },    { -6, -6, 1, 12, 12, 14 },    { -7, -6, 1, 14, 12, 14 },
        { -8, -6, 1, 16, 12, 14 },    { -7, -6, 1, 14, 12, 14 },    { -6, -6, 1, 12, 12, 14 },    { -6, -7, 1, 12, 14, 14 },
        { -6, -8, 1, 12, 16, 14 },    { -6, -7, 1, 12, 14, 14 },    { -6, -6, 1, 12, 12, 14 },    { -7, -6, 1, 14, 12, 14 },
        { -8, -6, 1, 16, 12, 14 },    { -7, -6, 1, 14, 12, 14 },    { -8, -8, 1, 16, 16, 14 },    { -6, -7, 1, 12, 14, 14 },
        { -6, -8, 2, 12, 16, 14 },    { -6, -7, 1, 12, 14, 14 },    { -8, -8, 1, 16, 16, 14 },    { -7, -6, 1, 14, 12, 14 },
        { -8, -6, 2, 16, 12, 14 },    { -7, -6, 1, 14, 12, 14 },    { -8, -8, 1, 16, 16, 14 },    { -6, -7, 1, 12, 14, 14 },
        { -6, -8, 1, 12, 16, 14 },    { -6, -7, 1, 12, 14, 14 },    { -8, -8, 1, 16, 16, 14 },    { -7, -6, 1, 14, 12, 14 },
        { -8, -6, 1, 16, 12, 14 },    { -8, -8, 1, 16, 16, 14 },    { -6, -8, 1, 12, 16, 14 },    { -8, -8, 1, 16, 16, 14 },
        { -8, -6, 1, 16, 12, 14 },    { -8, -8, 1, 16, 16, 14 },    { -6, -8, 1, 12, 16, 14 },    { 0, 0, 1, 8, 8, 14 },
        { -3, -6, 5, 6, 12, 7 },      { -8, -6, 1, 16, 12, 7 },     { -8, -8, 1, 16, 16, 7 },     { -6, -8, 1, 12, 16, 7 },
        { -6, -8, 5, 12, 6, 7 },      { -6, -8, 1, 12, 16, 7 },     { -8, -8, 1, 16, 16, 7 },     { -8, -6, 1, 16, 12, 7 },
        { -8, -6, 5, 6, 12, 7 },      { -8, -6, 1, 16, 12, 7 },     { -8, -8, 1, 16, 16, 7 },     { -6, -8, 1, 12, 16, 7 },
        { -6, -3, 5, 12, 6, 7 },      { -6, -8, 1, 12, 16, 7 },     { -8, -8, 1, 16, 16, 7 },     { -8, -6, 1, 16, 12, 7 },
        { 0, -6, 5, 3, 12, 5 },       { -6, -13, 5, 3, 12, 5 },     { -13, -6, 5, 12, 5, 5 },     { -6, 0, 5, 12, 3, 5 },
        { 0, -6, -8, 10, 12, 15 },    { 0, -6, -8, 10, 12, 15 },    { 0, -6, -8, 10, 12, 15 },    { -6, -12, -8, 6, 6, 15 },
        { -12, -12, -8, 6, 6, 15 },   { -12, -12, -8, 6, 6, 15 },   { -12, -12, -8, 6, 6, 15 },   { -12, -12, -8, 6, 6, 15 },
        { -12, -12, -8, 6, 6, 15 },   { -12, -6, -8, 6, 6, 15 },    { -12, -6, -8, 10, 12, 15 },  { -6, 0, -8, 12, 10, 15 },
        { -6, 0, -8, 12, 10, 15 },    { -6, 0, -8, 12, 10, 15 },    { -6, 0, -8, 12, 10, 15 },    { -6, 0, -8, 12, 10, 15 },
        { -3, -6, -4, 6, 12, 5 },     { -6, -13, -4, 3, 20, 5 },    { -13, -6, -4, 6, 5, 5 },     { -6, -3, -4, 12, 20, 5 },
        { -3, -6, 1, 6, 12, 6 },      { -6, -13, -10, 3, 6, 6 },    { -13, -6, -10, 6, 5, 6 },    { -6, -3, 1, 12, 6, 6 },
        { -10, -6, -15, 20, 12, 7 },  { -6, -10, -15, 12, 20, 7 },  { -10, -6, -15, 20, 12, 7 },  { -6, -10, -15, 12, 20, 7 },
        { -10, -6, -15, 20, 12, 7 },  { -6, -10, -15, 12, 20, 7 },  { -10, -6, -15, 20, 12, 7 },  { -6, -10, -15, 12, 20, 7 },
        { -10, -6, -15, 20, 12, 7 },  { -6, -10, -15, 12, 20, 7 },  { -10, -6, -15, 20, 12, 7 },  { -6, -10, -15, 12, 20, 7 },
        { -10, -6, -15, 20, 12, 7 },  { -6, -10, -15, 12, 20, 7 },  { -10, -6, -15, 20, 12, 7 },  { -6, -10, -15, 12, 20, 7 },
        { -8, -8, 1, 16, 16, 14 },    { -8, -8, 1, 16, 16, 14 },    { -8, -8, 1, 16, 16, 14 },    { -8, -8, 1, 16, 16, 14 },
        { -8, -8, 1, 16, 16, 14 },    { -32, -32, 24, 4, 4, 14 },   { -8, -8, 1, 16, 16, 14 },    { 8, 8, 1, 8, 8, 14 },
        { -8, -6, 1, 16, 12, 14 },    { -7, -6, 1, 14, 12, 14 },    { -6, -6, 1, 12, 12, 14 },    { -6, -7, 1, 12, 14, 14 },
        { -6, -8, 1, 12, 16, 14 },    { -6, -7, 1, 12, 14, 14 },    { -6, -6, 1, 12, 12, 14 },    { -7, -6, 1, 14, 12, 14 },
        { -8, -6, 1, 16, 12, 14 },    { -7, -6, 1, 14, 12, 14 },    { -6, -6, 1, 12, 12, 14 },    { -6, -7, 1, 12, 14, 14 },
        { -6, -8, 1, 12, 16, 14 },    { -6, -7, 1, 12, 14, 14 },    { -6, -6, 1, 12, 12, 14 },    { -7, -6, 1, 14, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
    },
    {
        // 0x0098E56C:
        { -3, -6, 1, 6, 12, 14 },     { -3, -5, 1, 6, 10, 14 },     { -5, -5, 1, 10, 10, 14 },    { -5, -3, 1, 10, 6, 14 },
        { -6, -3, 1, 12, 6, 14 },     { -5, -3, 1, 10, 6, 14 },     { -5, -5, 1, 10, 10, 14 },    { -3, -5, 1, 6, 10, 14 },
        { -3, -6, 1, 6, 12, 14 },     { -3, -5, 1, 6, 10, 14 },     { -5, -5, 1, 10, 10, 14 },    { -5, -3, 1, 10, 6, 14 },
        { -6, -3, 1, 12, 6, 14 },     { -5, -3, 1, 10, 6, 14 },     { -5, -5, 1, 10, 10, 14 },    { -3, -5, 1, 6, 10, 14 },
        { -3, -6, 1, 6, 12, 14 },     { -3, -6, 1, 6, 12, 14 },     { -8, -8, 1, 16, 16, 14 },    { -6, -3, 1, 12, 6, 14 },
        { -6, -3, 2, 12, 6, 14 },     { -6, -3, 1, 12, 6, 14 },     { -8, -8, 1, 16, 16, 14 },    { -3, -6, 1, 6, 12, 14 },
        { -3, -6, 2, 6, 12, 14 },     { -3, -6, 1, 6, 12, 14 },     { -8, -8, 1, 16, 16, 14 },    { -6, -3, 1, 12, 6, 14 },
        { -6, -3, 1, 12, 6, 14 },     { -6, -3, 1, 12, 6, 14 },     { -8, -8, 1, 16, 16, 14 },    { -3, -6, 1, 6, 12, 14 },
        { -3, -6, 1, 6, 12, 7 },      { -8, -8, 1, 16, 16, 7 },     { -6, -3, 1, 12, 6, 7 },      { -8, -8, 1, 16, 16, 7 },
        { -3, -6, 1, 6, 12, 7 },      { -8, -8, 1, 16, 16, 7 },     { -6, -3, 1, 12, 6, 7 },      { 0, 0, 1, 8, 8, 7 },
        { -3, -6, 5, 6, 12, 7 },      { -8, -6, 1, 16, 12, 7 },     { -8, -8, 1, 16, 16, 7 },     { -6, -8, 1, 12, 16, 7 },
        { -6, -3, 5, 12, 6, 7 },      { -6, -8, 1, 12, 16, 7 },     { -8, -8, 1, 16, 16, 7 },     { -8, -6, 1, 16, 12, 7 },
        { -3, -6, 5, 6, 12, 7 },      { -8, -6, 1, 16, 12, 7 },     { -8, -8, 1, 16, 16, 7 },     { -6, -8, 1, 12, 16, 7 },
        { -6, -3, 5, 12, 6, 7 },      { -6, -8, 1, 12, 16, 7 },     { -8, -8, 1, 16, 16, 7 },     { -8, -6, 1, 16, 12, 7 },
        { 0, -6, 5, 3, 12, 5 },       { -6, -13, 5, 3, 12, 5 },     { -13, -6, 5, 12, 5, 5 },     { -6, 0, 5, 12, 3, 5 },
        { 0, -6, -4, 10, 12, 7 },     { 0, -6, -4, 10, 12, 7 },     { 0, -6, -4, 10, 12, 7 },     { -6, -12, -4, 12, 10, 7 },
        { -6, -12, -4, 12, 10, 7 },   { -6, -12, -4, 12, 10, 7 },   { -6, -12, -4, 12, 10, 7 },   { -6, -12, -4, 12, 10, 7 },
        { -12, -6, -4, 10, 12, 7 },   { -12, -6, -4, 10, 12, 7 },   { -12, -6, -4, 10, 12, 7 },   { -6, 0, -4, 12, 10, 7 },
        { -6, 0, -4, 12, 10, 7 },     { -6, 0, -4, 12, 10, 7 },     { -6, 0, -4, 12, 10, 7 },     { -6, 0, -4, 12, 10, 7 },
        { -3, -6, -4, 6, 12, 5 },     { -6, -13, -4, 3, 20, 5 },    { -13, -6, -4, 6, 5, 5 },     { -6, -3, -4, 12, 20, 5 },
        { -3, -6, 1, 6, 12, 6 },      { -6, -13, -10, 3, 6, 6 },    { -13, -6, -10, 6, 5, 6 },    { -6, -3, 1, 12, 6, 6 },
        { -3, -6, -15, 6, 12, 6 },    { -6, -3, -15, 12, 6, 6 },    { -3, -6, -15, 6, 12, 6 },    { -6, -3, -15, 12, 6, 6 },
        { -3, -6, -15, 6, 12, 6 },    { -6, -3, -15, 12, 6, 6 },    { -3, -6, -15, 6, 12, 6 },    { -6, -3, -15, 12, 6, 6 },
        { -3, -6, -15, 6, 12, 6 },    { -6, -3, -15, 12, 6, 6 },    { -3, -6, -15, 6, 12, 6 },    { -6, -3, -15, 12, 6, 6 },
        { -3, -6, -15, 6, 12, 6 },    { -6, -3, -15, 12, 6, 6 },    { -3, -6, -15, 6, 12, 6 },    { -6, -3, -15, 12, 6, 6 },
        { -8, -8, 1, 16, 16, 14 },    { -8, -8, 1, 16, 16, 14 },    { -8, -8, 1, 16, 16, 14 },    { -8, -8, 1, 16, 16, 14 },
        { -8, -8, 1, 16, 16, 14 },    { -32, -32, 24, 4, 4, 14 },   { -8, -8, 1, 16, 16, 14 },    { 8, 8, 1, 8, 8, 14 },
        { -3, -6, 1, 6, 12, 14 },     { -3, -5, 1, 6, 10, 14 },     { -5, -5, 1, 10, 10, 14 },    { -5, -3, 1, 10, 6, 14 },
        { -6, -3, 1, 12, 6, 14 },     { -5, -3, 1, 10, 6, 14 },     { -5, -5, 1, 10, 10, 14 },    { -3, -5, 1, 6, 10, 14 },
        { -3, -6, 1, 6, 12, 14 },     { -3, -5, 1, 6, 10, 14 },     { -5, -5, 1, 10, 10, 14 },    { -5, -3, 1, 10, 6, 14 },
        { -6, -3, 1, 12, 6, 14 },     { -5, -3, 1, 10, 6, 14 },     { -5, -5, 1, 10, 10, 14 },    { -3, -5, 1, 6, 10, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
    },
    {
        // 0x00990CFC:
        { -12, -6, 1, 24, 12, 14 },   { -11, -6, 1, 22, 12, 14 },   { -10, -10, 1, 20, 20, 14 },  { -6, -11, 1, 12, 22, 14 },
        { -6, -12, 1, 12, 24, 14 },   { -6, -11, 1, 12, 22, 14 },   { -10, -10, 1, 20, 20, 14 },  { -11, -6, 1, 22, 12, 14 },
        { -12, -6, 1, 24, 12, 14 },   { -11, -6, 1, 22, 12, 14 },   { -10, -10, 1, 20, 20, 14 },  { -6, -11, 1, 12, 22, 14 },
        { -6, -12, 1, 12, 24, 14 },   { -6, -11, 1, 12, 22, 14 },   { -10, -10, 1, 20, 20, 14 },  { -11, -6, 1, 22, 12, 14 },
        { -11, -6, 1, 22, 12, 14 },   { -11, -6, 1, 22, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -11, 1, 12, 22, 14 },
        { -6, -11, 3, 12, 22, 14 },   { -6, -11, 1, 12, 22, 14 },   { -8, -8, 1, 16, 16, 14 },    { -11, -6, 1, 22, 12, 14 },
        { -11, -6, 3, 22, 12, 14 },   { -11, -6, 1, 22, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -11, 1, 12, 22, 14 },
        { -6, -11, 1, 12, 22, 14 },   { -6, -11, 1, 12, 22, 14 },   { -8, -8, 1, 16, 16, 14 },    { -11, -6, 1, 22, 12, 14 },
        { -12, -6, 1, 24, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -12, 1, 12, 24, 14 },   { -8, -8, 1, 16, 16, 14 },
        { -18, -6, 1, 24, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -14, 1, 12, 24, 14 },   { 0, 0, 1, 8, 8, 14 },
        { -12, -6, 5, 24, 12, 14 },   { -11, -6, 1, 22, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -11, 1, 12, 22, 14 },
        { -6, -12, 5, 12, 24, 14 },   { -6, -11, 1, 12, 22, 14 },   { -8, -8, 1, 16, 16, 14 },    { -11, -6, 1, 22, 12, 14 },
        { -18, -6, 5, 24, 12, 14 },   { -11, -6, 1, 22, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -11, 1, 12, 22, 14 },
        { -6, -14, 5, 12, 24, 14 },   { -6, -11, 1, 12, 22, 14 },   { -8, -8, 1, 16, 16, 14 },    { -11, -6, 1, 22, 12, 14 },
        { 0, -6, -10, 14, 12, 24 },   { -6, -17, -10, 3, 14, 24 },  { -17, -6, -10, 14, 5, 24 },  { -6, 0, -10, 12, 14, 24 },
        { 0, -6, -7, 10, 12, 14 },    { 0, -6, -7, 10, 12, 14 },    { 0, -6, -7, 10, 12, 14 },    { 0, -6, -7, 10, 12, 14 },
        { -6, -12, -7, 12, 10, 14 },  { -6, -12, -7, 12, 10, 14 },  { -6, -12, -7, 12, 10, 14 },  { -6, -12, -7, 12, 10, 14 },
        { -12, -6, -7, 10, 12, 14 },  { -12, -6, -7, 10, 12, 14 },  { -12, -6, -7, 10, 12, 14 },  { -12, -6, -7, 10, 12, 14 },
        { -6, 0, -7, 12, 10, 14 },    { -6, 0, -7, 12, 10, 14 },    { -6, 0, -7, 12, 10, 14 },    { -6, 0, -7, 12, 10, 14 },
        { 0, -6, -10, 14, 12, 14 },   { -6, -17, -10, 3, 14, 14 },  { -17, -6, -10, 14, 5, 14 },  { -6, 0, -10, 12, 14, 14 },
        { 0, -6, -10, 14, 12, 14 },   { -6, -17, -10, 3, 14, 14 },  { -17, -6, -10, 14, 5, 14 },  { -6, 0, -10, 12, 14, 14 },
        { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },  { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },
        { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },  { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },
        { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },  { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },
        { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },  { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },
        { -10, -10, 1, 20, 20, 14 },  { -10, -10, 1, 20, 20, 14 },  { -10, -10, 1, 20, 20, 14 },  { -10, -10, 1, 20, 20, 14 },
        { -8, -8, 1, 16, 16, 14 },    { -8, -8, 1, 16, 16, 14 },    { -8, -8, 1, 16, 16, 14 },    { 8, 8, 1, 8, 8, 14 },
        { -12, -6, 1, 24, 12, 14 },   { -11, -6, 1, 22, 12, 14 },   { -10, -10, 1, 20, 20, 14 },  { -6, -11, 1, 12, 22, 14 },
        { -6, -12, 1, 12, 24, 14 },   { -6, -11, 1, 12, 22, 14 },   { -10, -10, 1, 20, 20, 14 },  { -11, -6, 1, 22, 12, 14 },
        { -12, -6, 1, 24, 12, 14 },   { -11, -6, 1, 22, 12, 14 },   { -10, -10, 1, 20, 20, 14 },  { -6, -11, 1, 12, 22, 14 },
        { -6, -12, 1, 12, 24, 14 },   { -6, -11, 1, 12, 22, 14 },   { -10, -10, 1, 20, 20, 14 },  { -11, -6, 1, 22, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
    },
    {
        // 0x0098FA6C:
        { -18, -6, 1, 36, 12, 11 },   { -17, -6, 1, 34, 12, 11 },   { -15, -15, 1, 30, 30, 11 },  { -6, -17, 1, 12, 34, 11 },
        { -6, -18, 1, 12, 36, 11 },   { -6, -17, 1, 12, 34, 11 },   { -15, -15, 1, 30, 30, 11 },  { -17, -6, 1, 34, 12, 11 },
        { -18, -6, 1, 36, 12, 11 },   { -17, -6, 1, 34, 12, 11 },   { -15, -15, 1, 30, 30, 11 },  { -6, -17, 1, 12, 34, 11 },
        { -6, -18, 1, 12, 36, 11 },   { -6, -17, 1, 12, 34, 11 },   { -15, -15, 1, 30, 30, 11 },  { -17, -6, 1, 34, 12, 11 },
        { -14, -6, 1, 28, 12, 14 },   { -11, -6, 1, 22, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -11, 1, 12, 22, 14 },
        { -6, -14, 3, 12, 28, 14 },   { -6, -11, 1, 12, 22, 14 },   { -8, -8, 1, 16, 16, 14 },    { -11, -6, 1, 22, 12, 14 },
        { -14, -6, 3, 28, 12, 14 },   { -11, -6, 1, 22, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -11, 1, 12, 22, 14 },
        { -6, -14, 1, 12, 28, 14 },   { -6, -11, 1, 12, 22, 14 },   { -8, -8, 1, 16, 16, 14 },    { -11, -6, 1, 22, 12, 14 },
        { -14, -6, 1, 28, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -14, 1, 12, 28, 14 },   { -8, -8, 1, 16, 16, 14 },
        { -14, -6, 1, 28, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -14, 1, 12, 28, 14 },   { 0, 0, 1, 8, 8, 14 },
        { -3, -6, 5, 6, 12, 7 },      { -8, -6, 1, 16, 12, 7 },     { -8, -8, 1, 16, 16, 7 },     { -6, -8, 1, 12, 16, 7 },
        { -6, -8, 5, 12, 6, 7 },      { -6, -8, 1, 12, 16, 7 },     { -8, -8, 1, 16, 16, 7 },     { -8, -6, 1, 16, 12, 7 },
        { -8, -6, 5, 6, 12, 7 },      { -8, -6, 1, 16, 12, 7 },     { -8, -8, 1, 16, 16, 7 },     { -6, -8, 1, 12, 16, 7 },
        { -6, -3, 5, 12, 6, 7 },      { -6, -8, 1, 12, 16, 7 },     { -8, -8, 1, 16, 16, 7 },     { -8, -6, 1, 16, 12, 7 },
        { 0, -6, 5, 3, 12, 5 },       { -6, -13, 5, 3, 12, 5 },     { -13, -6, 5, 12, 5, 5 },     { -6, 0, 5, 12, 3, 5 },
        { 0, -6, -8, 10, 12, 15 },    { 0, -6, -8, 10, 12, 15 },    { 0, -6, -8, 10, 12, 15 },    { -6, -12, -8, 12, 10, 15 },
        { -6, -12, -8, 12, 10, 15 },  { -6, -12, -8, 12, 10, 15 },  { -6, -12, -8, 12, 10, 15 },  { -6, -12, -8, 12, 10, 15 },
        { -12, -6, -8, 10, 12, 15 },  { -12, -6, -8, 10, 12, 15 },  { -12, -6, -8, 10, 12, 15 },  { -6, 0, -8, 12, 10, 15 },
        { -6, 0, -8, 12, 10, 15 },    { -6, 0, -8, 12, 10, 15 },    { -6, 0, -8, 12, 10, 15 },    { -6, 0, -8, 12, 10, 15 },
        { -3, -6, -4, 6, 12, 5 },     { -6, -13, -4, 3, 20, 5 },    { -13, -6, -4, 6, 5, 5 },     { -6, -3, -4, 12, 20, 5 },
        { -3, -6, 1, 6, 12, 6 },      { -6, -13, -10, 3, 6, 6 },    { -13, -6, -10, 6, 5, 6 },    { -6, -3, 1, 12, 6, 6 },
        { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },  { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },
        { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },  { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },
        { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },  { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },
        { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },  { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },
        { -10, -10, 1, 20, 20, 14 },  { -10, -10, 1, 20, 20, 14 },  { -10, -10, 1, 20, 20, 14 },  { -10, -10, 1, 20, 20, 14 },
        { -8, -8, 1, 16, 16, 14 },    { -32, -32, 24, 4, 4, 14 },   { -8, -8, 1, 16, 16, 14 },    { 8, 8, 1, 8, 8, 14 },
        { -14, -6, 1, 28, 12, 14 },   { -12, -6, 1, 24, 12, 14 },   { -10, -10, 1, 20, 20, 14 },  { -6, -12, 1, 12, 24, 14 },
        { -6, -14, 1, 12, 28, 14 },   { -6, -12, 1, 12, 24, 14 },   { -10, -10, 1, 20, 20, 14 },  { -12, -6, 1, 24, 12, 14 },
        { -14, -6, 1, 28, 12, 14 },   { -12, -6, 1, 24, 12, 14 },   { -10, -10, 1, 20, 20, 14 },  { -6, -12, 1, 12, 24, 14 },
        { -6, -14, 1, 12, 28, 14 },   { -6, -12, 1, 12, 24, 14 },   { -10, -10, 1, 20, 20, 14 },  { -12, -6, 1, 24, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
    },
    {
        // 0x0099177C:
        { -16, -6, 1, 32, 12, 8 },    { -5, -5, 1, 10, 10, 8 },     { -4, -4, 1, 8, 8, 8 },       { -5, -5, 1, 10, 10, 8 },
        { -6, -16, 1, 12, 32, 8 },    { -5, -5, 1, 10, 10, 8 },     { -4, -4, 1, 8, 8, 8 },       { -5, -5, 1, 10, 10, 8 },
        { -16, -6, 1, 32, 12, 8 },    { -5, -5, 1, 10, 10, 8 },     { -4, -4, 1, 8, 8, 8 },       { -5, -5, 1, 10, 10, 8 },
        { -6, -16, 1, 12, 32, 8 },    { -5, -5, 1, 10, 10, 8 },     { -4, -4, 1, 8, 8, 8 },       { -5, -5, 1, 10, 10, 8 },
        { -13, -6, 1, 26, 12, 14 },   { -11, -6, 1, 22, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -11, 1, 12, 22, 14 },
        { -6, -13, 3, 12, 26, 14 },   { -6, -11, 1, 12, 22, 14 },   { -8, -8, 1, 16, 16, 14 },    { -11, -6, 1, 22, 12, 14 },
        { -13, -6, 3, 26, 12, 14 },   { -11, -6, 1, 22, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -11, 1, 12, 22, 14 },
        { -6, -13, 1, 12, 26, 14 },   { -6, -11, 1, 12, 22, 14 },   { -8, -8, 1, 16, 16, 14 },    { -11, -6, 1, 22, 12, 14 },
        { -14, -6, 1, 28, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -14, 1, 12, 28, 14 },   { -8, -8, 1, 16, 16, 14 },
        { -18, -6, 1, 28, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -14, 1, 12, 28, 14 },   { 0, 0, 1, 8, 8, 14 },
        { -14, -6, 5, 28, 12, 14 },   { -11, -6, 1, 22, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -11, 1, 12, 22, 14 },
        { -6, -14, 5, 12, 28, 14 },   { -6, -11, 1, 12, 22, 14 },   { -8, -8, 1, 16, 16, 14 },    { -11, -6, 1, 22, 12, 14 },
        { -18, -6, 5, 28, 12, 14 },   { -11, -6, 1, 22, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -11, 1, 12, 22, 14 },
        { -6, -14, 5, 12, 28, 14 },   { -6, -11, 1, 12, 22, 14 },   { -8, -8, 1, 16, 16, 14 },    { -11, -6, 1, 22, 12, 14 },
        { -14, -6, -10, 28, 12, 24 }, { -6, -17, -10, 3, 28, 24 },  { -17, -6, -10, 28, 5, 24 },  { -6, -14, -10, 12, 28, 24 },
        { 0, -6, -7, 10, 12, 14 },    { 0, -6, -7, 10, 12, 14 },    { 0, -6, -7, 10, 12, 14 },    { 0, -6, -7, 10, 12, 14 },
        { -6, -12, -7, 12, 10, 14 },  { -6, -12, -7, 12, 10, 14 },  { -6, -12, -7, 12, 10, 14 },  { -6, -12, -7, 12, 10, 14 },
        { -12, -6, -7, 10, 12, 14 },  { -12, -6, -7, 10, 12, 14 },  { -12, -6, -7, 10, 12, 14 },  { -12, -6, -7, 10, 12, 14 },
        { -6, 0, -7, 12, 10, 14 },    { -6, 0, -7, 12, 10, 14 },    { -6, 0, -7, 12, 10, 14 },    { -6, 0, -7, 12, 10, 14 },
        { -14, -6, -10, 28, 12, 24 }, { -6, -17, -10, 3, 28, 24 },  { -17, -6, -10, 28, 5, 24 },  { -6, -14, -10, 12, 28, 24 },
        { -14, -6, 1, 28, 12, 14 },   { -6, -17, -10, 3, 28, 24 },  { -17, -6, -10, 28, 5, 24 },  { -6, -14, 1, 12, 28, 14 },
        { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },  { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },
        { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },  { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },
        { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },  { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },
        { -16, -6, 1, 32, 12, 8 },    { -6, -16, 1, 12, 32, 8 },    { -16, -6, 1, 32, 12, 8 },    { -6, -16, 1, 12, 32, 8 },
        { -10, -10, 1, 20, 20, 14 },  { -10, -10, 1, 20, 20, 14 },  { -10, -10, 1, 20, 20, 14 },  { -10, -10, 1, 20, 20, 14 },
        { -8, -8, 1, 16, 16, 14 },    { -8, -8, 1, 16, 16, 14 },    { -8, -8, 1, 16, 16, 14 },    { 8, 8, 1, 8, 8, 14 },
        { -16, -6, 1, 32, 12, 8 },    { -5, -5, 1, 10, 10, 8 },     { -4, -4, 1, 8, 8, 8 },       { -5, -5, 1, 10, 10, 8 },
        { -6, -16, 1, 12, 32, 8 },    { -5, -5, 1, 10, 10, 8 },     { -4, -4, 1, 8, 8, 8 },       { -5, -5, 1, 10, 10, 8 },
        { -16, -6, 1, 32, 12, 8 },    { -5, -5, 1, 10, 10, 8 },     { -4, -4, 1, 8, 8, 8 },       { -5, -5, 1, 10, 10, 8 },
        { -6, -16, 1, 12, 32, 8 },    { -5, -5, 1, 10, 10, 8 },     { -4, -4, 1, 8, 8, 8 },       { -5, -5, 1, 10, 10, 8 },
        { -16, -6, 1, 32, 12, 8 },    { -6, -16, 1, 12, 32, 8 },    { -16, -6, 1, 32, 12, 8 },    { -6, -16, 1, 12, 32, 8 },
        { -16, -6, 1, 32, 12, 8 },    { -6, -16, 1, 12, 32, 8 },    { -16, -6, 1, 32, 12, 8 },    { -6, -16, 1, 12, 32, 8 },
        { -16, -6, 1, 32, 12, 8 },    { -6, -16, 1, 12, 32, 8 },    { -16, -6, 1, 32, 12, 8 },    { -6, -16, 1, 12, 32, 8 },
        { -16, -6, 1, 32, 12, 8 },    { -6, -16, 1, 12, 32, 8 },    { -16, -6, 1, 32, 12, 8 },    { -6, -16, 1, 12, 32, 8 },
        { -16, -6, 1, 32, 12, 8 },    { -6, -16, 1, 12, 32, 8 },    { -16, -6, 1, 32, 12, 8 },    { -6, -16, 1, 12, 32, 8 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
    },
    {
        // 0x009900FC:
        { -16, -6, 1, 32, 12, 14 },   { -12, -6, 1, 24, 12, 14 },   { -10, -10, 1, 20, 20, 14 },  { -6, -12, 1, 12, 24, 14 },
        { -6, -16, 1, 12, 32, 14 },   { -6, -12, 1, 12, 24, 14 },   { -10, -10, 1, 20, 20, 14 },  { -12, -6, 1, 24, 12, 14 },
        { -16, -6, 1, 32, 12, 14 },   { -12, -6, 1, 24, 12, 14 },   { -10, -10, 1, 20, 20, 14 },  { -6, -12, 1, 12, 24, 14 },
        { -6, -16, 1, 12, 32, 14 },   { -6, -12, 1, 12, 24, 14 },   { -10, -10, 1, 20, 20, 14 },  { -12, -6, 1, 24, 12, 14 },
        { -14, -6, 5, 28, 12, 9 },    { -11, -6, 1, 22, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -11, 1, 12, 22, 14 },
        { -6, -14, 5, 12, 28, 9 },    { -6, -11, 1, 12, 22, 14 },   { -8, -8, 1, 16, 16, 14 },    { -11, -6, 1, 22, 12, 14 },
        { -14, -6, 5, 28, 12, 9 },    { -11, -6, 1, 22, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -11, 1, 12, 22, 14 },
        { -6, -14, 5, 12, 28, 9 },    { -6, -11, 1, 12, 22, 14 },   { -8, -8, 1, 16, 16, 14 },    { -11, -6, 1, 22, 12, 14 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -8, -6, -28, 16, 12, 14 },  { -8, -6, -28, 16, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -8, -28, 12, 16, 14 },
        { -6, -8, -28, 12, 16, 14 },  { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -6, -28, 16, 12, 14 },
        { -8, -6, -28, 16, 12, 14 },  { -8, -6, -28, 16, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -8, -28, 12, 16, 14 },
        { -6, -8, -28, 12, 16, 14 },  { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -6, -28, 16, 12, 14 },
        { -6, -6, -28, 12, 12, 14 },  { -9, -6, -28, 18, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -9, -28, 12, 18, 14 },
        { -6, -6, -28, 12, 12, 14 },  { -6, -9, -28, 12, 18, 14 },  { -8, -8, -28, 16, 16, 14 },  { -9, -6, -28, 18, 12, 14 },
        { -6, -6, -28, 12, 12, 14 },  { -9, -6, -28, 18, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -9, -28, 12, 18, 14 },
        { -6, -6, -28, 12, 12, 14 },  { -6, -9, -28, 12, 18, 14 },  { -8, -8, -28, 16, 16, 14 },  { -9, -6, -28, 18, 12, 14 },
        { -10, -6, -28, 16, 12, 14 }, { -8, -8, -28, 16, 16, 14 },  { -6, -11, -33, 3, 16, 19 },  { -8, -8, -28, 16, 16, 14 },
        { -11, -6, -33, 16, 5, 19 },  { -8, -8, -28, 16, 16, 14 },  { -6, -10, -28, 12, 16, 14 }, { -8, -8, -28, 16, 16, 14 },
        { -10, -6, -28, 16, 12, 14 }, { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },
        { -3, -10, -39, 3, 16, 27 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },
        { -10, -6, -39, 16, 3, 27 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },
        { -6, -10, -28, 12, 16, 14 }, { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -2, -3, -39, 3, 10, 29 },   { -3, -2, -39, 10, 3, 29 },   { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -49, 5, 12, 34 },  { -10, -6, -49, 5, 12, 34 },  { -10, -6, -49, 5, 12, 34 },  { -10, -6, -49, 5, 12, 34 },
        { -2, 4, -39, 3, 10, 29 },    { -2, 4, -39, 3, 10, 29 },    { -2, 4, -39, 3, 10, 29 },    { -2, 4, -39, 3, 10, 29 },
        { -13, -6, -39, 20, 5, 24 },  { -13, -6, -39, 20, 5, 24 },  { -13, -6, -39, 20, 5, 24 },  { -13, -6, -39, 20, 5, 24 },
        { -6, -15, -28, 12, 10, 14 }, { -6, -15, -28, 12, 10, 14 }, { -6, -15, -28, 12, 10, 14 }, { -6, -15, -28, 12, 10, 14 },
        { -10, -6, -39, 4, 12, 24 },  { -2, 4, -10, 3, 10, 24 },    { -3, -6, -39, 10, 5, 24 },   { -6, -15, -10, 12, 10, 14 },
        { -10, -6, -28, 3, 12, 14 },  { -6, 0, -10, 3, 10, 24 },    { -3, -6, -28, 10, 5, 14 },   { -6, -15, -10, 12, 10, 14 },
        { -10, -6, -44, 20, 12, 7 },  { -6, 0, -5, 12, 10, 7 },     { 0, -6, -34, 10, 12, 7 },    { -6, -15, -5, 12, 10, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, 0, 5, 12, 10, 7 },      { 0, -6, 5, 10, 12, 7 },      { -6, -10, 5, 12, 10, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },    { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },    { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },
        { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },
        { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },
        { -8, -6, 11, 16, 12, 4 },    { -8, -6, 11, 16, 12, 4 },    { -8, -8, 11, 16, 16, 4 },    { -6, -8, 11, 12, 16, 4 },
        { -6, -8, 11, 12, 16, 4 },    { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -6, -28, 16, 12, 14 },
        { -8, -6, -28, 16, 12, 14 },  { -8, -6, -28, 16, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -8, -28, 12, 16, 14 },
        { -6, -8, -28, 12, 16, 14 },  { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -6, -28, 16, 12, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
    },
    {
        // 0x009901BC:
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -8, -6, -28, 16, 12, 14 },  { -8, -6, -28, 16, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -8, -28, 12, 16, 14 },
        { -6, -8, -28, 12, 16, 14 },  { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -6, -28, 16, 12, 14 },
        { -8, -6, -28, 16, 12, 14 },  { -8, -6, -28, 16, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -8, -28, 12, 16, 14 },
        { -6, -8, -28, 12, 16, 14 },  { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -6, -28, 16, 12, 14 },
        { -6, -6, -28, 12, 12, 14 },  { -9, -6, -28, 18, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -9, -28, 12, 18, 14 },
        { -6, -6, -28, 12, 12, 14 },  { -6, -9, -28, 12, 18, 14 },  { -8, -8, -28, 16, 16, 14 },  { -9, -6, -28, 18, 12, 14 },
        { -6, -6, -28, 12, 12, 14 },  { -9, -6, -28, 18, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -9, -28, 12, 18, 14 },
        { -6, -6, -28, 12, 12, 14 },  { -6, -9, -28, 12, 18, 14 },  { -8, -8, -28, 16, 16, 14 },  { -9, -6, -28, 18, 12, 14 },
        { -10, -6, -28, 16, 12, 14 }, { -8, -8, -28, 16, 16, 14 },  { -6, -11, -33, 3, 16, 19 },  { -8, -8, -28, 16, 16, 14 },
        { -11, -6, -33, 16, 5, 19 },  { -8, -8, -28, 16, 16, 14 },  { -6, -10, -28, 12, 16, 14 }, { -8, -8, -28, 16, 16, 14 },
        { -10, -6, -28, 16, 12, 14 }, { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },
        { -3, -10, -39, 3, 16, 27 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },
        { -10, -6, -39, 16, 3, 27 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },
        { -6, -10, -28, 12, 16, 14 }, { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -2, -3, -39, 3, 10, 29 },   { -3, -2, -39, 10, 3, 29 },   { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -49, 5, 12, 34 },  { -10, -6, -49, 5, 12, 34 },  { -10, -6, -49, 5, 12, 34 },  { -10, -6, -49, 5, 12, 34 },
        { -2, 4, -39, 3, 10, 29 },    { -2, 4, -39, 3, 10, 29 },    { -2, 4, -39, 3, 10, 29 },    { -2, 4, -39, 3, 10, 29 },
        { -13, -6, -39, 20, 5, 24 },  { -13, -6, -39, 20, 5, 24 },  { -13, -6, -39, 20, 5, 24 },  { -13, -6, -39, 20, 5, 24 },
        { -6, -15, -28, 12, 10, 14 }, { -6, -15, -28, 12, 10, 14 }, { -6, -15, -28, 12, 10, 14 }, { -6, -15, -28, 12, 10, 14 },
        { -10, -6, -39, 4, 12, 24 },  { -2, 4, -10, 3, 10, 24 },    { -3, -6, -39, 10, 5, 24 },   { -6, -15, -10, 12, 10, 14 },
        { -10, -6, -28, 3, 12, 14 },  { -6, 0, -10, 3, 10, 24 },    { -3, -6, -28, 10, 5, 14 },   { -6, -15, -10, 12, 10, 14 },
        { -10, -6, -44, 20, 12, 7 },  { -6, 0, -5, 12, 10, 7 },     { 0, -6, -34, 10, 12, 7 },    { -6, -15, -5, 12, 10, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, 0, 5, 12, 10, 7 },      { 0, -6, 5, 10, 12, 7 },      { -6, -10, 5, 12, 10, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },    { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },    { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },
        { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },
        { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },
        { -8, -6, 11, 16, 12, 4 },    { -8, -6, 11, 16, 12, 4 },    { -8, -8, 11, 16, 16, 4 },    { -6, -8, 11, 12, 16, 4 },
        { -6, -8, 11, 12, 16, 4 },    { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -6, -28, 16, 12, 14 },
        { -8, -6, -28, 16, 12, 14 },  { -8, -6, -28, 16, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -8, -28, 12, 16, 14 },
        { -6, -8, -28, 12, 16, 14 },  { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -6, -28, 16, 12, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
    },
    {
        // 0x0098FFAC:
        { -3, -6, -1, 6, 12, 1 },     { -3, -5, -1, 6, 10, 1 },     { -5, -5, -1, 10, 10, 1 },    { -5, -3, -1, 10, 6, 1 },
        { -6, -3, -1, 12, 6, 1 },     { -5, -3, -1, 10, 6, 1 },     { -5, -5, -1, 10, 10, 1 },    { -3, -5, -1, 6, 10, 1 },
        { -3, -6, -1, 6, 12, 1 },     { -3, -5, -1, 6, 10, 1 },     { -5, -5, -1, 10, 10, 1 },    { -5, -3, -1, 10, 6, 1 },
        { -6, -3, -1, 12, 6, 1 },     { -5, -3, -1, 10, 6, 1 },     { -5, -5, -1, 10, 10, 1 },    { -3, -5, -1, 6, 10, 1 },
        { -3, -6, -8, 6, 12, 1 },     { -3, -6, -1, 6, 12, 1 },     { -8, -8, -1, 16, 16, 1 },    { -6, -3, -1, 12, 6, 1 },
        { -6, -3, 0, 12, 6, 1 },      { -6, -3, -1, 12, 6, 1 },     { -8, -8, -1, 16, 16, 1 },    { -3, -6, -1, 6, 12, 1 },
        { -3, -6, 0, 6, 12, 1 },      { -3, -6, -1, 6, 12, 1 },     { -8, -8, -1, 16, 16, 1 },    { -6, -3, -1, 12, 6, 1 },
        { -6, -3, -8, 12, 6, 1 },     { -6, -3, -1, 12, 6, 1 },     { -8, -8, -1, 16, 16, 1 },    { -3, -6, -1, 6, 12, 1 },
        { -3, -6, -10, 6, 12, 1 },    { -8, -8, -2, 16, 16, 1 },    { -6, -3, -2, 12, 6, 1 },     { -8, -8, -2, 16, 16, 1 },
        { -3, -6, -2, 6, 12, 1 },     { -8, -8, -2, 16, 16, 1 },    { -6, -3, -10, 12, 6, 1 },    { 0, 0, -2, 8, 8, 1 },
        { -3, -6, -12, 6, 12, 1 },    { -8, -6, -6, 16, 12, 1 },    { -8, -8, -6, 16, 16, 1 },    { -6, -8, -6, 12, 16, 1 },
        { -6, -3, -2, 12, 6, 1 },     { -6, -8, -6, 12, 16, 1 },    { -8, -8, -6, 16, 16, 1 },    { -8, -6, -6, 16, 12, 1 },
        { -3, -6, -2, 6, 12, 1 },     { -8, -6, -6, 16, 12, 1 },    { -8, -8, -6, 16, 16, 1 },    { -6, -8, -6, 12, 16, 1 },
        { -6, -3, -12, 12, 6, 1 },    { -6, -8, -6, 12, 16, 1 },    { -8, -8, -6, 16, 16, 1 },    { -8, -6, -6, 16, 12, 1 },
        { -16, -6, 1, 32, 12, 14 },   { -12, -6, 1, 24, 12, 14 },   { -10, -10, 1, 20, 20, 14 },  { -6, -12, 1, 12, 24, 14 },
        { -6, -16, 1, 12, 32, 14 },   { -6, -12, 1, 12, 24, 14 },   { -10, -10, 1, 20, 20, 14 },  { -12, -6, 1, 24, 12, 14 },
        { -16, -6, 1, 32, 12, 14 },   { -12, -6, 1, 24, 12, 14 },   { -10, -10, 1, 20, 20, 14 },  { -6, -12, 1, 12, 24, 14 },
        { -6, -16, 1, 12, 32, 14 },   { -6, -12, 1, 12, 24, 14 },   { -10, -10, 1, 20, 20, 14 },  { -12, -6, 1, 24, 12, 14 },
        { -14, -6, 5, 28, 12, 9 },    { -11, -6, 1, 22, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -11, 1, 12, 22, 14 },
        { -6, -14, 5, 12, 28, 9 },    { -6, -11, 1, 12, 22, 14 },   { -8, -8, 1, 16, 16, 14 },    { -11, -6, 1, 22, 12, 14 },
        { -14, -6, 5, 28, 12, 9 },    { -11, -6, 1, 22, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -11, 1, 12, 22, 14 },
        { -6, -14, 5, 12, 28, 9 },    { -6, -11, 1, 12, 22, 14 },   { -8, -8, 1, 16, 16, 14 },    { -11, -6, 1, 22, 12, 14 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -8, -6, -28, 16, 12, 14 },  { -8, -6, -28, 16, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -8, -28, 12, 16, 14 },
        { -6, -8, -28, 12, 16, 14 },  { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -6, -28, 16, 12, 14 },
        { -8, -6, -28, 16, 12, 14 },  { -8, -6, -28, 16, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -8, -28, 12, 16, 14 },
        { -6, -8, -28, 12, 16, 14 },  { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -6, -28, 16, 12, 14 },
        { -6, -6, -28, 12, 12, 14 },  { -9, -6, -28, 18, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -9, -28, 12, 18, 14 },
        { -6, -6, -28, 12, 12, 14 },  { -6, -9, -28, 12, 18, 14 },  { -8, -8, -28, 16, 16, 14 },  { -9, -6, -28, 18, 12, 14 },
        { -6, -6, -28, 12, 12, 14 },  { -9, -6, -28, 18, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -9, -28, 12, 18, 14 },
        { -6, -6, -28, 12, 12, 14 },  { -6, -9, -28, 12, 18, 14 },  { -8, -8, -28, 16, 16, 14 },  { -9, -6, -28, 18, 12, 14 },
        { -10, -6, -28, 16, 12, 14 }, { -8, -8, -28, 16, 16, 14 },  { -6, -11, -33, 3, 16, 19 },  { -8, -8, -28, 16, 16, 14 },
        { -11, -6, -33, 16, 5, 19 },  { -8, -8, -28, 16, 16, 14 },  { -6, -10, -28, 12, 16, 14 }, { -8, -8, -28, 16, 16, 14 },
        { -10, -6, -28, 16, 12, 14 }, { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },
        { -3, -10, -39, 3, 16, 27 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },
        { -10, -6, -39, 16, 3, 27 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },
        { -6, -10, -28, 12, 16, 14 }, { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -2, -3, -39, 3, 10, 29 },   { -3, -2, -39, 10, 3, 29 },   { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -49, 5, 12, 34 },  { -10, -6, -49, 5, 12, 34 },  { -10, -6, -49, 5, 12, 34 },  { -10, -6, -49, 5, 12, 34 },
        { -2, 4, -39, 3, 10, 29 },    { -2, 4, -39, 3, 10, 29 },    { -2, 4, -39, 3, 10, 29 },    { -2, 4, -39, 3, 10, 29 },
        { -13, -6, -39, 20, 5, 24 },  { -13, -6, -39, 20, 5, 24 },  { -13, -6, -39, 20, 5, 24 },  { -13, -6, -39, 20, 5, 24 },
        { -6, -15, -28, 12, 10, 14 }, { -6, -15, -28, 12, 10, 14 }, { -6, -15, -28, 12, 10, 14 }, { -6, -15, -28, 12, 10, 14 },
        { -10, -6, -39, 4, 12, 24 },  { -2, 4, -10, 3, 10, 24 },    { -3, -6, -39, 10, 5, 24 },   { -6, -15, -10, 12, 10, 14 },
        { -10, -6, -28, 3, 12, 14 },  { -6, 0, -10, 3, 10, 24 },    { -3, -6, -28, 10, 5, 14 },   { -6, -15, -10, 12, 10, 14 },
        { -10, -6, -44, 20, 12, 7 },  { -6, 0, -5, 12, 10, 7 },     { 0, -6, -34, 10, 12, 7 },    { -6, -15, -5, 12, 10, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, 0, 5, 12, 10, 7 },      { 0, -6, 5, 10, 12, 7 },      { -6, -10, 5, 12, 10, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },    { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },    { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },
        { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },
    },
    {
        // 0x0099273C:
        { -6, -6, 0, 12, 12, 31 },
        { -6, -6, 0, 12, 12, 31 },
        { -6, -6, 0, 12, 12, 31 },
        { -6, -6, 0, 12, 12, 31 },
        { -6, -6, 0, 12, 12, 31 },
        { -6, -6, 0, 12, 12, 31 },
        { -6, -6, 0, 12, 12, 31 },
        { -6, -6, 0, 12, 12, 31 },
        { -6, -6, 0, 12, 12, 31 },
        { -6, -6, 0, 12, 12, 31 },
        { -6, -6, 0, 12, 12, 31 },
        { -6, -6, 0, 12, 12, 31 },
        { -6, -6, 0, 12, 12, 31 },
        { -6, -6, 0, 12, 12, 31 },
        { -6, -6, 0, 12, 12, 31 },
        { -6, -6, 0, 12, 12, 31 },
    }
};

// Opposite Pitch values for reversed cars
const VehiclePitch PitchInvertTable[] = {
    VehiclePitch::flat,

    VehiclePitch::down12,
    VehiclePitch::down25,
    VehiclePitch::down42,
    VehiclePitch::down60,

    VehiclePitch::up12,
    VehiclePitch::up25,
    VehiclePitch::up42,
    VehiclePitch::up60,

    VehiclePitch::down75,
    VehiclePitch::down90,
    VehiclePitch::down105,
    VehiclePitch::down120,
    VehiclePitch::down135,
    VehiclePitch::down150,
    VehiclePitch::down165,

    VehiclePitch::inverted,

    VehiclePitch::up75,
    VehiclePitch::up90,
    VehiclePitch::up105,
    VehiclePitch::up120,
    VehiclePitch::up135,
    VehiclePitch::up150,
    VehiclePitch::up165,

    VehiclePitch::corkscrewDownLeft0,
    VehiclePitch::corkscrewDownLeft1,
    VehiclePitch::corkscrewDownLeft2,
    VehiclePitch::corkscrewDownLeft3,
    VehiclePitch::corkscrewDownLeft4,

    VehiclePitch::corkscrewUpRight0,
    VehiclePitch::corkscrewUpRight1,
    VehiclePitch::corkscrewUpRight2,
    VehiclePitch::corkscrewUpRight3,
    VehiclePitch::corkscrewUpRight4,

    VehiclePitch::corkscrewDownRight0,
    VehiclePitch::corkscrewDownRight1,
    VehiclePitch::corkscrewDownRight2,
    VehiclePitch::corkscrewDownRight3,
    VehiclePitch::corkscrewDownRight4,

    VehiclePitch::corkscrewUpLeft0,
    VehiclePitch::corkscrewUpLeft1,
    VehiclePitch::corkscrewUpLeft2,
    VehiclePitch::corkscrewUpLeft3,
    VehiclePitch::corkscrewUpLeft4,

    VehiclePitch::flat, // helixes
    VehiclePitch::flat,
    VehiclePitch::flat,
    VehiclePitch::flat,
    VehiclePitch::flat,
    VehiclePitch::flat,

    VehiclePitch::down8,
    VehiclePitch::down16,
    VehiclePitch::down50,

    VehiclePitch::up8,
    VehiclePitch::up16,
    VehiclePitch::up50,

    VehiclePitch::up25,
    VehiclePitch::up42,
    VehiclePitch::up60,

    VehiclePitch::curvedLiftHillDown,
    VehiclePitch::curvedLiftHillUp,
};
static_assert(std::size(PitchInvertTable) == EnumValue(VehiclePitch::pitchCount));

// Opposite Roll values for reversed cars
const VehicleRoll RollInvertTable[] = {
    VehicleRoll::unbanked,
    VehicleRoll::right22,
    VehicleRoll::right45,
    VehicleRoll::left22,
    VehicleRoll::left45,
    VehicleRoll::right67,
    VehicleRoll::right90,
    VehicleRoll::right112,
    VehicleRoll::right135,
    VehicleRoll::right157,
    VehicleRoll::left67,
    VehicleRoll::left90,
    VehicleRoll::left112,
    VehicleRoll::left135,
    VehicleRoll::left157,
    VehicleRoll::uninvertingUnbanked,
    VehicleRoll::uninvertingRight22,
    VehicleRoll::uninvertingRight45,
    VehicleRoll::uninvertingLeft22,
    VehicleRoll::uninvertingLeft45,
};
static_assert(std::size(RollInvertTable) == EnumValue(VehicleRoll::rollCount));

constexpr uint32_t kBoundBoxIndexUndefined = std::numeric_limits<uint32_t>::max();
constexpr uint32_t kBoundBoxIndexFlat = 0;
constexpr uint32_t kBoundBoxIndex25 = 16;
constexpr uint32_t kBoundBoxIndex42 = 32;
constexpr uint32_t kBoundBoxIndex60 = 40;
constexpr uint32_t kBoundBoxIndex75 = 56;
constexpr uint32_t kBoundBoxIndex90 = 60;
constexpr uint32_t kBoundBoxIndex105 = 76;
constexpr uint32_t kBoundBoxIndex120 = 80;
constexpr uint32_t kBoundBoxIndex135 = 84;
constexpr uint32_t kBoundBoxIndex150 = 88;
constexpr uint32_t kBoundBoxIndex165 = 92;
constexpr uint32_t kBoundBoxIndexInverted = 96;
constexpr uint32_t kBoundBoxIndex16 = 100;
constexpr uint32_t kBoundBoxIndex50 = 104;
constexpr uint32_t kBoundBoxIndexFlatBanked45 = 108;
constexpr uint32_t kBoundBoxIndexFlatBanked67 = 124;
constexpr uint32_t kBoundBoxIndexFlatBanked90 = 128;
constexpr uint32_t kBoundBoxIndexFlatBanked112 = 132;
constexpr uint32_t kBoundBoxIndexFlatBanked135 = 136;
constexpr uint32_t kBoundBoxIndexFlatBanked157 = 140;
constexpr uint32_t kBoundBoxIndexCorkscrew = 144;

#pragma endregion

#pragma region VehiclePaintUtil

static void PaintVehicleRiders(
    PaintSession& session, const Vehicle* vehicle, const CarEntry* carEntry, uint32_t baseImageId, const int32_t z,
    const VehicleBoundBox& bb)
{
    baseImageId += carEntry->NumCarImages;
    for (auto i = 0; i < 8; i++)
    {
        if (vehicle->num_peeps > (i * 2) && carEntry->no_seating_rows > i)
        {
            auto offsetImageId = baseImageId;
            if (i == 0 && carEntry->flags.has(CarEntryFlag::hasRiderAnimation))
            {
                offsetImageId += (carEntry->NumCarImages * vehicle->animation_frame);
            }

            auto peepColour0 = vehicle->peep_tshirt_colours[i * 2];
            auto peepColour1 = vehicle->peep_tshirt_colours[(i * 2) + 1];
            auto imageId = ImageId(offsetImageId, peepColour0, peepColour1);
            if (vehicle->IsGhost())
            {
                imageId = ImageId(offsetImageId).WithRemap(FilterPaletteID::paletteGhost);
            }

            PaintAddImageAsChild(
                session, imageId, { 0, 0, z },
                { { bb.offset_x, bb.offset_y, bb.offset_z + z }, { bb.length_x, bb.length_y, bb.length_z } });
            baseImageId += carEntry->NumCarImages;
        }
    }
}

// 6D5214
static void vehicle_sprite_paint(
    PaintSession& session, const Vehicle* vehicle, int32_t spriteIndex, const VehicleBoundBox& bb, const int32_t z,
    const CarEntry* carEntry)
{
    if (carEntry->draw_order >= std::size(VehicleBoundboxes))
    {
        return;
    }

    auto baseImageId = static_cast<uint32_t>(spriteIndex);
    if (carEntry->flags.has(CarEntryFlag::hasSpinningCombinedWithNonSpinning))
    {
        baseImageId += carEntry->spinningNumFrames * vehicle->spin_sprite / 256;
    }
    if (carEntry->flags.has(CarEntryFlag::hasVehicleAnimation))
    {
        baseImageId += vehicle->animation_frame;
    }

    auto imageId = ImageId(baseImageId, vehicle->colours.Body, vehicle->colours.Trim, vehicle->colours.Tertiary);
    if (vehicle->IsGhost())
    {
        imageId = ImageId(baseImageId).WithRemap(FilterPaletteID::paletteGhost);
    }
    PaintAddImageAsParent(
        session, imageId, { 0, 0, z },
        { { bb.offset_x, bb.offset_y, bb.offset_z + z }, { bb.length_x, bb.length_y, bb.length_z } });

    auto& rt = session.rt;
    if (rt.zoom_level < ZoomLevel{ 2 } && vehicle->num_peeps > 0 && carEntry->no_seating_rows > 0)
    {
        PaintVehicleRiders(session, vehicle, carEntry, baseImageId, z, bb);
    }
    VehicleVisualSplashEffect(session, z, vehicle, carEntry);
}

// 6D520E
static void VehicleSpritePaintWithSwinging(
    PaintSession& session, const Vehicle* vehicle, int32_t spriteIndex, int32_t boundingBoxIndex, const int32_t z,
    const CarEntry* carEntry)
{
    vehicle_sprite_paint(
        session, vehicle, spriteIndex + vehicle->SwingSprite, VehicleBoundboxes[carEntry->draw_order][boundingBoxIndex], z,
        carEntry);
}

static void VehicleSpritePaintRestraints(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    auto restraintFrame = ((vehicle->restraints_position - 64) / 64);
    const auto spriteIndex = carEntry->SpriteOffset(SpriteGroupType::RestraintAnimation, imageDirection, restraintFrame);
    vehicle_sprite_paint(session, vehicle, spriteIndex, VehicleBoundboxes[carEntry->draw_order][boundingBoxIndex], z, carEntry);
}

// Returns the opposite of the bank angle for reversed cars, normal bank angle otherwise
static VehicleRoll GetPaintBankRotation(const Vehicle* vehicle)
{
    return (vehicle->HasFlag(VehicleFlags::CarIsReversed)) ? RollInvertTable[EnumValue(vehicle->roll)] : vehicle->roll;
}

#pragma endregion

#pragma region FlatSlope

// 6D51DE
static void VehiclePitchFlatUnbanked(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    // Restraint animations are only drawn for vehicles that are in a cardinal direction (north, east, south, west)
    if (vehicle->restraints_position >= 64 && carEntry->GroupEnabled(SpriteGroupType::RestraintAnimation)
        && (imageDirection & 7) == 0)
    {
        VehicleSpritePaintRestraints(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
        return;
    }
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    const auto spriteIndex = carEntry->SpriteOffset(SpriteGroupType::SlopeFlat, imageDirection, 0);
    VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
}

// 6D4EE7
static void VehiclePitchFlatBankedLeft22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    if (carEntry->GroupEnabled(SpriteGroupType::FlatBanked22))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::FlatBanked22, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatUnbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4F34
static void VehiclePitchFlatBankedLeft45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlatBanked45;
    if (carEntry->GroupEnabled(SpriteGroupType::FlatBanked45))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::FlatBanked45, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatUnbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4F0C
static void VehiclePitchFlatBankedRight22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    if (carEntry->GroupEnabled(SpriteGroupType::FlatBanked22))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::FlatBanked22, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatUnbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4F5C
static void VehiclePitchFlatBankedRight45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo16(imageDirection) ^ 8) + kBoundBoxIndexFlatBanked45;
    if (carEntry->GroupEnabled(SpriteGroupType::FlatBanked45))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::FlatBanked45, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatUnbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4F84
static void VehiclePitchFlatBankedLeft67(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        carEntry--;
    }
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo4(imageDirection) + kBoundBoxIndexFlatBanked67;
    if (carEntry->GroupEnabled(SpriteGroupType::FlatBanked67))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::FlatBanked67, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4FE4
static void VehiclePitchFlatBankedLeft90(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        carEntry--;
    }
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo4(imageDirection) + kBoundBoxIndexFlatBanked90;
    if (carEntry->GroupEnabled(SpriteGroupType::FlatBanked90))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::FlatBanked90, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D5055
static void VehiclePitchFlatBankedLeft112(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        carEntry--;
    }
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo4(imageDirection) + kBoundBoxIndexFlatBanked112;
    if (carEntry->GroupEnabled(SpriteGroupType::InlineTwists))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::InlineTwists, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D50C6
static void VehiclePitchFlatBankedLeft135(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        carEntry--;
    }
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo4(imageDirection) + kBoundBoxIndexFlatBanked135;
    if (carEntry->GroupEnabled(SpriteGroupType::InlineTwists))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::InlineTwists, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D5137
static void VehiclePitchFlatBankedLeft157(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        carEntry--;
    }
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo4(imageDirection) + kBoundBoxIndexFlatBanked157;
    if (carEntry->GroupEnabled(SpriteGroupType::InlineTwists))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::InlineTwists, imageDirection, 4);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4FB1
static void VehiclePitchFlatBankedRight67(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        carEntry--;
    }
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo4(imageDirection) ^ 2) + kBoundBoxIndexFlatBanked67;
    if (carEntry->GroupEnabled(SpriteGroupType::FlatBanked67))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::FlatBanked67, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedRight45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D501B
static void VehiclePitchFlatBankedRight90(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        carEntry--;
    }
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo4(imageDirection) ^ 2) + kBoundBoxIndexFlatBanked90;
    if (carEntry->GroupEnabled(SpriteGroupType::FlatBanked90))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::FlatBanked90, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedRight45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D508C
static void VehiclePitchFlatBankedRight112(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        carEntry--;
    }
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo4(imageDirection) ^ 2) + kBoundBoxIndexFlatBanked112;
    if (carEntry->GroupEnabled(SpriteGroupType::InlineTwists))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::InlineTwists, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedRight45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D50FD
static void VehiclePitchFlatBankedRight135(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        carEntry--;
    }
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo4(imageDirection) ^ 2) + kBoundBoxIndexFlatBanked135;
    if (carEntry->GroupEnabled(SpriteGroupType::InlineTwists))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::InlineTwists, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedRight45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D516E
static void VehiclePitchFlatBankedRight157(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        carEntry--;
    }
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo4(imageDirection) ^ 2) + kBoundBoxIndexFlatBanked157;
    if (carEntry->GroupEnabled(SpriteGroupType::InlineTwists))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::InlineTwists, imageDirection, 5);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4EE4
static void VehiclePitchUninvertedFlatBankedLeft22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    carEntry--;
    VehiclePitchFlatBankedLeft22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
}

// 6D4F31
static void VehiclePitchUninvertedFlatBankedLeft45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    carEntry--;
    VehiclePitchFlatBankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
}

// 6D4F09
static void VehiclePitchUninvertedFlatBankedRight22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    carEntry--;
    VehiclePitchFlatBankedRight22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
}

// 6D4F59
static void VehiclePitchUninvertedFlatBankedRight45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    carEntry--;
    VehiclePitchFlatBankedRight45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
}

// 6D51D7
static void VehiclePitchFlat(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    // 0x009A3DE4:
    switch (GetPaintBankRotation(vehicle))
    {
        case VehicleRoll::unbanked:
            VehiclePitchFlatUnbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left22:
            VehiclePitchFlatBankedLeft22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left45:
            VehiclePitchFlatBankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right22:
            VehiclePitchFlatBankedRight22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right45:
            VehiclePitchFlatBankedRight45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left67:
            VehiclePitchFlatBankedLeft67(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left90:
            VehiclePitchFlatBankedLeft90(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left112:
            VehiclePitchFlatBankedLeft112(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left135:
            VehiclePitchFlatBankedLeft135(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left157:
            VehiclePitchFlatBankedLeft157(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right67:
            VehiclePitchFlatBankedRight67(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right90:
            VehiclePitchFlatBankedRight90(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right112:
            VehiclePitchFlatBankedRight112(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right135:
            VehiclePitchFlatBankedRight135(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right157:
            VehiclePitchFlatBankedRight157(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::uninvertingUnbanked:
            VehiclePitchFlatUnbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::uninvertingLeft22:
            VehiclePitchUninvertedFlatBankedLeft22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::uninvertingLeft45:
            VehiclePitchUninvertedFlatBankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::uninvertingRight22:
            VehiclePitchUninvertedFlatBankedRight22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::uninvertingRight45:
            VehiclePitchUninvertedFlatBankedRight45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        default:
            VehiclePitchFlatUnbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

#pragma endregion

#pragma region GentleSlopesUp

#pragma region SlopeUp12

// 6D4614
static void VehiclePitchUp12Unbanked(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes12))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes12, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlat(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4662
static void VehiclePitchUp12BankedLeft22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes12Banked22))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes12Banked22, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp12Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D46DB
static void VehiclePitchUp12BankedLeft45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes12Banked45))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes12Banked45, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp12BankedLeft22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D467D
static void VehiclePitchUp12BankedRight22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes12Banked22))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes12Banked22, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp12Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D46FD
static void VehiclePitchUp12BankedRight45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes12Banked45))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes12Banked45, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp12BankedRight22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D460D
static void VehiclePitchUp12(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    // 0x009A3C04:
    switch (GetPaintBankRotation(vehicle))
    {
        case VehicleRoll::unbanked:
            VehiclePitchUp12Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left22:
            VehiclePitchUp12BankedLeft22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left45:
            VehiclePitchUp12BankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right22:
            VehiclePitchUp12BankedRight22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right45:
            VehiclePitchUp12BankedRight45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::uninvertingUnbanked:
            VehiclePitchUp12Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::uninvertingLeft22:
            VehiclePitchUp12BankedLeft22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::uninvertingLeft45:
            VehiclePitchUp12BankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::uninvertingRight22:
            VehiclePitchUp12BankedRight22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::uninvertingRight45:
            VehiclePitchUp12BankedRight45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        default:
            VehiclePitchUp12Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

#pragma endregion

#pragma region SlopeUp25

// 6D4791
static void VehiclePitchUp25Unbanked(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo16(imageDirection)) + kBoundBoxIndex25;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes25, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlat(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4833
static void VehiclePitchUp25BankedLeft22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndex25;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25Banked22))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes25Banked22, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp25Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D48D6
static void VehiclePitchUp25BankedLeft45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    if (boundingBoxIndex == kBoundBoxIndexUndefined)
    {
        boundingBoxIndex = YawTo16(imageDirection);
        if (carEntry->draw_order < 5)
            boundingBoxIndex += kBoundBoxIndexFlatBanked45;
        else
            boundingBoxIndex += kBoundBoxIndex25;
    }
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25Banked45))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes25Banked45, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp25Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4858
static void VehiclePitchUp25BankedRight22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndex25;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25Banked22))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes25Banked22, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp25Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4910
static void VehiclePitchUp25BankedRight45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    if (boundingBoxIndex == kBoundBoxIndexUndefined)
    {
        boundingBoxIndex = YawTo16(imageDirection);
        if (carEntry->draw_order < 5)
            boundingBoxIndex = (boundingBoxIndex ^ 8) + kBoundBoxIndexFlatBanked45;
        else
            boundingBoxIndex += kBoundBoxIndex25;
    }
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25Banked45))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes25Banked45, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp25Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp25BankedLeft67(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo4(imageDirection) + kBoundBoxIndexFlatBanked67;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25Banked67))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes25Banked67, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp25BankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp25BankedLeft90(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo4(imageDirection) + kBoundBoxIndexFlatBanked90;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25Banked90))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes25Banked90, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedLeft90(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp25BankedLeft112(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo4(imageDirection) + kBoundBoxIndexFlatBanked112;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25InlineTwists))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes25InlineTwists, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedLeft112(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp25BankedLeft135(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo4(imageDirection) + kBoundBoxIndexFlatBanked135;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25InlineTwists))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes25InlineTwists, imageDirection, 4);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedLeft135(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp25BankedLeft157(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo4(imageDirection) + kBoundBoxIndexFlatBanked157;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25InlineTwists))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes25InlineTwists, imageDirection, 8);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedLeft157(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp25BankedRight67(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo4(imageDirection) ^ 2) + kBoundBoxIndexFlatBanked67;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25Banked67))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes25Banked67, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp25BankedRight45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp25BankedRight90(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo4(imageDirection) ^ 2) + kBoundBoxIndexFlatBanked90;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25Banked90))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes25Banked90, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedRight90(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp25BankedRight112(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo4(imageDirection) ^ 2) + kBoundBoxIndexFlatBanked112;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25InlineTwists))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes25InlineTwists, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedRight112(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp25BankedRight135(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo4(imageDirection) ^ 2) + kBoundBoxIndexFlatBanked135;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25InlineTwists))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes25InlineTwists, imageDirection, 5);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedRight135(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp25BankedRight157(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo4(imageDirection) ^ 2) + kBoundBoxIndexFlatBanked157;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25InlineTwists))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes25InlineTwists, imageDirection, 9);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedRight157(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D476C
static void VehiclePitchUp25(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    // 0x009A3CA4:
    switch (GetPaintBankRotation(vehicle))
    {
        case VehicleRoll::unbanked:
            VehiclePitchUp25Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left22:
            VehiclePitchUp25BankedLeft22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left45:
            VehiclePitchUp25BankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right22:
            VehiclePitchUp25BankedRight22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right45:
            VehiclePitchUp25BankedRight45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left67:
            VehiclePitchUp25BankedLeft67(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left90:
            VehiclePitchUp25BankedLeft90(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left112:
            VehiclePitchUp25BankedLeft112(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left135:
            VehiclePitchUp25BankedLeft135(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left157:
            VehiclePitchUp25BankedLeft157(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right67:
            VehiclePitchUp25BankedRight67(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right90:
            VehiclePitchUp25BankedRight90(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right112:
            VehiclePitchUp25BankedRight112(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right135:
            VehiclePitchUp25BankedRight135(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right157:
            VehiclePitchUp25BankedRight157(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::uninvertingUnbanked:
            VehiclePitchUp25Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::uninvertingLeft22:
            VehiclePitchUp25BankedLeft22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::uninvertingLeft45:
            VehiclePitchUp25BankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::uninvertingRight22:
            VehiclePitchUp25BankedRight22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::uninvertingRight45:
            VehiclePitchUp25BankedRight45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        default:
            VehiclePitchUp25Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

#pragma endregion

#pragma endregion

#pragma region SteepSlopesUp

// 6D49DC
static void VehiclePitchUp42Unbanked(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo8(imageDirection)) + kBoundBoxIndex42;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes42, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp25(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp42BankedLeft22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo8(imageDirection)) + kBoundBoxIndex42;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42Banked22))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes42Banked22, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp42Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp42BankedLeft45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo8(imageDirection)) + kBoundBoxIndex42;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42Banked45))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes42Banked45, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp42Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp42BankedRight22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo8(imageDirection)) + kBoundBoxIndex42;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42Banked22))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes42Banked22, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp42Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp42BankedRight45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo8(imageDirection)) + kBoundBoxIndex42;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42Banked45))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes42Banked45, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp42Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp42BankedLeft67(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo8(imageDirection)) + kBoundBoxIndex42;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42Banked67))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes42Banked67, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp25BankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp42BankedLeft90(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo8(imageDirection)) + kBoundBoxIndex42;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42Banked90))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes42Banked90, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedLeft90(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp42BankedRight67(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo8(imageDirection)) + kBoundBoxIndex42;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42Banked67))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes42Banked67, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp25BankedRight45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp42BankedRight90(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo8(imageDirection)) + kBoundBoxIndex42;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42Banked90))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes42Banked90, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedRight90(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp42BankedLeft135(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    constexpr uint32_t corkscrewFrame = 13;
    const int32_t modifiedImageDirection = (imageDirection + 8) % 32;
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined
        ? boundingBoxIndex
        : YawTo4(modifiedImageDirection) + corkscrewFrame * kNumOrthogonalDirections + kBoundBoxIndexCorkscrew;
    if (carEntry->GroupEnabled(SpriteGroupType::Corkscrews))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Corkscrews, modifiedImageDirection, corkscrewFrame);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp42Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp42BankedRight135(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    constexpr uint32_t corkscrewFrame = 3;
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined
        ? boundingBoxIndex
        : YawTo4(imageDirection) + corkscrewFrame * kNumOrthogonalDirections + kBoundBoxIndexCorkscrew;
    if (carEntry->GroupEnabled(SpriteGroupType::Corkscrews))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Corkscrews, imageDirection, corkscrewFrame);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp42Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D49DC
static void VehiclePitchUp42(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    switch (GetPaintBankRotation(vehicle))
    {
        case VehicleRoll::unbanked:
            VehiclePitchUp42Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left22:
            VehiclePitchUp42BankedLeft22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left45:
            VehiclePitchUp42BankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right22:
            VehiclePitchUp42BankedRight22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right45:
            VehiclePitchUp42BankedRight45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left67:
            VehiclePitchUp42BankedLeft67(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left90:
            VehiclePitchUp42BankedLeft90(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left135:
            VehiclePitchUp42BankedLeft135(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right67:
            VehiclePitchUp42BankedRight67(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right90:
            VehiclePitchUp42BankedRight90(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right135:
            VehiclePitchUp42BankedRight135(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        default:
            VehiclePitchUp42Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4A31
static void VehiclePitchUp60Unbanked(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo16(imageDirection)) + kBoundBoxIndex60;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes60))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes60, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp25(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp60BankedLeft22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo16(imageDirection)) + kBoundBoxIndex60;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes60Banked22))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes60Banked22, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp60Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp60BankedRight22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo16(imageDirection)) + kBoundBoxIndex60;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes60Banked22))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes60Banked22, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp60Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp60(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    switch (GetPaintBankRotation(vehicle))
    {
        case VehicleRoll::unbanked:
            VehiclePitchUp60Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left22:
            VehiclePitchUp60BankedLeft22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right22:
            VehiclePitchUp60BankedRight22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        default:
            VehiclePitchUp60Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

#pragma endregion

#pragma region GentleSlopesDown

#pragma region SlopeDown12

// 6D463D
static void VehiclePitchDown12Unbanked(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes12))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes12, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlat(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D469B
static void VehiclePitchDown12BankedLeft22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes12Banked22))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes12Banked22, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown12Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4722
static void VehiclePitchDown12BankedLeft45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes12Banked45))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes12Banked45, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown12BankedLeft22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D46B9
static void VehiclePitchDown12BankedRight22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes12Banked22))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes12Banked22, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown12Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4747
static void VehiclePitchDown12BankedRight45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes12Banked45))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes12Banked45, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown12BankedRight22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4636
static void VehiclePitchDown12(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    // 0x009A3C54:
    switch (GetPaintBankRotation(vehicle))
    {
        case VehicleRoll::unbanked:
            VehiclePitchDown12Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left22:
            VehiclePitchDown12BankedLeft22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left45:
            VehiclePitchDown12BankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right22:
            VehiclePitchDown12BankedRight22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right45:
            VehiclePitchDown12BankedRight45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left67:
            VehiclePitchDown12Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left90:
            VehiclePitchDown12Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left112:
            VehiclePitchDown12Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left135:
            VehiclePitchDown12Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left157:
            VehiclePitchDown12Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right67:
            VehiclePitchDown12Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right90:
            VehiclePitchDown12Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right112:
            VehiclePitchDown12Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right135:
            VehiclePitchDown12Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right157:
            VehiclePitchDown12Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::uninvertingUnbanked:
            VehiclePitchDown12Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::uninvertingLeft22:
            VehiclePitchDown12BankedLeft22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::uninvertingLeft45:
            VehiclePitchDown12BankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::uninvertingRight22:
            VehiclePitchDown12BankedRight22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::uninvertingRight45:
            VehiclePitchDown12BankedRight45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        default:
            VehiclePitchDown12Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}
#pragma endregion

#pragma region Down25

#pragma endregion

#pragma region SlopeDown25

// 6D47E4
static void VehiclePitchDown25Unbanked(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : ((YawTo16(imageDirection)) ^ 8) + kBoundBoxIndex25;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes25, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlat(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4880
static void VehiclePitchDown25BankedLeft22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : ((YawTo16(imageDirection)) ^ 8) + kBoundBoxIndex25;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25Banked22))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes25Banked22, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown25Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4953
static void VehiclePitchDown25BankedLeft45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    if (boundingBoxIndex == kBoundBoxIndexUndefined)
    {
        boundingBoxIndex = YawTo16(imageDirection);
        if (carEntry->draw_order < 5)
            boundingBoxIndex += kBoundBoxIndexFlatBanked45;
        else
            boundingBoxIndex = (boundingBoxIndex ^ 8) + kBoundBoxIndex25;
    }
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25Banked45))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes25Banked45, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown25Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D48AB
static void VehiclePitchDown25BankedRight22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : ((YawTo16(imageDirection)) ^ 8) + kBoundBoxIndex25;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25Banked22))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes25Banked22, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown25Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4996
static void VehiclePitchDown25BankedRight45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    if (boundingBoxIndex == kBoundBoxIndexUndefined)
    {
        boundingBoxIndex = YawTo16(imageDirection);
        if (carEntry->draw_order < 5)
            boundingBoxIndex = (boundingBoxIndex ^ 8) + kBoundBoxIndexFlatBanked45;
        else
            boundingBoxIndex = (boundingBoxIndex ^ 8) + kBoundBoxIndex25;
    }
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25Banked45))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes25Banked45, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown25Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown25BankedLeft67(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo4(imageDirection) + kBoundBoxIndexFlatBanked67;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25Banked67))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes25Banked67, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown25BankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown25BankedLeft90(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo4(imageDirection) + kBoundBoxIndexFlatBanked90;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25Banked90))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes25Banked90, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedLeft90(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown25BankedLeft112(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo4(imageDirection) + kBoundBoxIndexFlatBanked112;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25InlineTwists))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes25InlineTwists, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedLeft112(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown25BankedLeft135(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo4(imageDirection) + kBoundBoxIndexFlatBanked135;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25InlineTwists))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes25InlineTwists, imageDirection, 6);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedLeft135(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown25BankedLeft157(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo4(imageDirection) + kBoundBoxIndexFlatBanked157;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25InlineTwists))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes25InlineTwists, imageDirection, 10);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedLeft157(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown25BankedRight67(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo4(imageDirection) ^ 2) + kBoundBoxIndexFlatBanked67;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25Banked67))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes25Banked67, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown25BankedRight45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown25BankedRight90(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo4(imageDirection) ^ 2) + kBoundBoxIndexFlatBanked90;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25Banked90))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes25Banked90, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedRight90(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown25BankedRight112(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo4(imageDirection) ^ 2) + kBoundBoxIndexFlatBanked112;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25InlineTwists))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes25InlineTwists, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedRight112(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown25BankedRight135(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo4(imageDirection) ^ 2) + kBoundBoxIndexFlatBanked135;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25InlineTwists))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes25InlineTwists, imageDirection, 7);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedRight135(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown25BankedRight157(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo4(imageDirection) ^ 2) + kBoundBoxIndexFlatBanked157;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25InlineTwists))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes25InlineTwists, imageDirection, 11);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedRight157(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D47DD
static void VehiclePitchDown25(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    // 0x009A3CF4:
    switch (GetPaintBankRotation(vehicle))
    {
        case VehicleRoll::unbanked:
            VehiclePitchDown25Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left22:
            VehiclePitchDown25BankedLeft22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left45:
            VehiclePitchDown25BankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right22:
            VehiclePitchDown25BankedRight22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right45:
            VehiclePitchDown25BankedRight45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left67:
            VehiclePitchDown25BankedLeft67(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left90:
            VehiclePitchDown25BankedLeft90(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left112:
            VehiclePitchDown25BankedLeft112(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left135:
            VehiclePitchDown25BankedLeft135(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left157:
            VehiclePitchDown25BankedLeft157(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right67:
            VehiclePitchDown25BankedRight67(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right90:
            VehiclePitchDown25BankedRight90(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right112:
            VehiclePitchDown25BankedRight112(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right135:
            VehiclePitchDown25BankedRight135(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right157:
            VehiclePitchDown25BankedRight157(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::uninvertingUnbanked:
            VehiclePitchDown25Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::uninvertingLeft22:
            VehiclePitchDown25BankedLeft22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::uninvertingLeft45:
            VehiclePitchDown25BankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::uninvertingRight22:
            VehiclePitchDown25BankedRight22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::uninvertingRight45:
            VehiclePitchDown25BankedRight45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        default:
            VehiclePitchDown25Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

#pragma endregion

#pragma endregion

#pragma region SteepSlopesDown

// 6D4A05
static void VehiclePitchDown42Unbanked(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : ((YawTo8(imageDirection)) ^ 4) + kBoundBoxIndex42;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes42, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown25(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown42BankedLeft22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo8(imageDirection)) + kBoundBoxIndex42;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42Banked22))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes42Banked22, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown42Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown42BankedLeft45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo8(imageDirection)) + kBoundBoxIndex42;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42Banked45))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes42Banked45, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown42Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown42BankedRight22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo8(imageDirection)) + kBoundBoxIndex42;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42Banked22))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes42Banked22, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown42Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown42BankedRight45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo8(imageDirection)) + kBoundBoxIndex42;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42Banked45))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes42Banked45, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown42Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown42BankedLeft67(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo8(imageDirection)) + kBoundBoxIndex42;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42Banked67))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes42Banked67, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown25BankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown42BankedLeft90(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo8(imageDirection)) + kBoundBoxIndex42;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42Banked90))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes42Banked90, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedLeft90(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown42BankedRight67(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo8(imageDirection)) + kBoundBoxIndex42;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42Banked67))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes42Banked67, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown25BankedRight45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown42BankedRight90(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo8(imageDirection)) + kBoundBoxIndex42;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42Banked90))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes42Banked90, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedRight90(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown42BankedLeft135(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    constexpr uint32_t corkscrewFrame = 8;
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined
        ? boundingBoxIndex
        : YawTo4(imageDirection) + corkscrewFrame * kNumOrthogonalDirections + kBoundBoxIndexCorkscrew;
    if (carEntry->GroupEnabled(SpriteGroupType::Corkscrews))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Corkscrews, imageDirection, corkscrewFrame);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown42Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown42BankedRight135(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    constexpr uint32_t corkscrewFrame = 18;
    const int32_t modifiedImageDirection = (imageDirection + 8) % 32;
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined
        ? boundingBoxIndex
        : YawTo4(modifiedImageDirection) + corkscrewFrame * kNumOrthogonalDirections + kBoundBoxIndexCorkscrew;
    if (carEntry->GroupEnabled(SpriteGroupType::Corkscrews))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Corkscrews, modifiedImageDirection, corkscrewFrame);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown42Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown42(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    switch (GetPaintBankRotation(vehicle))
    {
        case VehicleRoll::unbanked:
            VehiclePitchDown42Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left22:
            VehiclePitchDown42BankedLeft22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left45:
            VehiclePitchDown42BankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right22:
            VehiclePitchDown42BankedRight22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right45:
            VehiclePitchDown42BankedRight45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left67:
            VehiclePitchDown42BankedLeft67(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left90:
            VehiclePitchDown42BankedLeft90(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left135:
            VehiclePitchDown42BankedLeft135(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right67:
            VehiclePitchDown42BankedRight67(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right90:
            VehiclePitchDown42BankedRight90(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right135:
            VehiclePitchDown42BankedRight135(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        default:
            VehiclePitchDown42Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4A59
static void VehiclePitchDown60Unbanked(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : ((YawTo16(imageDirection)) ^ 8) + kBoundBoxIndex60;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes60))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes60, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown25(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown60BankedLeft22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo16(imageDirection)) + kBoundBoxIndex60;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes60Banked22))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes60Banked22, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown60Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown60BankedRight22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo16(imageDirection)) + kBoundBoxIndex60;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes60Banked22))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes60Banked22, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown60Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown60(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    switch (GetPaintBankRotation(vehicle))
    {
        case VehicleRoll::unbanked:
            VehiclePitchDown60Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left22:
            VehiclePitchDown60BankedLeft22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right22:
            VehiclePitchDown60BankedRight22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        default:
            VehiclePitchDown60Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

#pragma endregion

#pragma region VerticalSlopesUp

// 6D4A81
static void VehiclePitchUp75(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo4(imageDirection)) + kBoundBoxIndex75;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes75))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes75, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp60(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4AE8
static void VehiclePitchUp90(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo16(imageDirection)) + kBoundBoxIndex90;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes90))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes90, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp60(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

#pragma endregion

#pragma region LoopSlopesUp

// 6D4B57
static void VehiclePitchUp105(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo4(imageDirection)) + kBoundBoxIndex105;
    if (carEntry->GroupEnabled(SpriteGroupType::SlopesLoop))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::SlopesLoop, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp60(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4BB7
static void VehiclePitchUp120(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo4(imageDirection)) + kBoundBoxIndex120;
    if (carEntry->GroupEnabled(SpriteGroupType::SlopesLoop))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::SlopesLoop, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp60(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4C17
static void VehiclePitchUp135(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo4(imageDirection)) + kBoundBoxIndex135;
    if (carEntry->GroupEnabled(SpriteGroupType::SlopesLoop))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::SlopesLoop, imageDirection, 4);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp60(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4C77
static void VehiclePitchUp150(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo4(imageDirection)) + kBoundBoxIndex150;
    if (carEntry->GroupEnabled(SpriteGroupType::SlopesLoop))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::SlopesLoop, imageDirection, 6);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp60(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4CD7
static void VehiclePitchUp165(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo4(imageDirection)) + kBoundBoxIndex165;
    if (carEntry->GroupEnabled(SpriteGroupType::SlopesLoop))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::SlopesLoop, imageDirection, 8);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp60(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

#pragma endregion

#pragma region InvertedSlope

// 6D4D37
static void VehiclePitchInverted(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo4(imageDirection)) + kBoundBoxIndexInverted;
    if (carEntry->GroupEnabled(SpriteGroupType::SlopeInverted))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::SlopeInverted, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp60(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

#pragma endregion

#pragma region VerticalSlopesDown

// 6D4AA3
static void VehiclePitchDown75(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        if (vehicle->GetTrackType() != TrackElemType::down90ToDown60
            && (vehicle->GetTrackType()) != TrackElemType::down60ToDown90)
        {
            carEntry--;
        }
    }
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : ((YawTo4(imageDirection)) ^ 2) + kBoundBoxIndex75;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes75))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes75, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown60(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4B0D
static void VehiclePitchDown90(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        if (vehicle->GetTrackType() != TrackElemType::down90 && (vehicle->GetTrackType()) != TrackElemType::down90ToDown60
            && (vehicle->GetTrackType()) != TrackElemType::down60ToDown90)
        {
            carEntry--;
        }
    }
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : ((YawTo16(imageDirection)) ^ 8) + kBoundBoxIndex90;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes90))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes90, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown60(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

#pragma endregion

#pragma region LoopSlopesDown

// 6D4B80
static void VehiclePitchDown105(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        carEntry--;
    }
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : ((YawTo4(imageDirection)) ^ 2) + kBoundBoxIndex105;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes90))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::SlopesLoop, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown60(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4BE0
static void VehiclePitchDown120(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        carEntry--;
    }
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : ((YawTo4(imageDirection)) ^ 2) + kBoundBoxIndex120;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes90))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::SlopesLoop, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown60(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4C40
static void VehiclePitchDown135(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        carEntry--;
    }
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : ((YawTo4(imageDirection)) ^ 2) + kBoundBoxIndex135;
    if (carEntry->GroupEnabled(SpriteGroupType::SlopesLoop))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::SlopesLoop, imageDirection, 5);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown60(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4CA0
static void VehiclePitchDown150(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        carEntry--;
    }
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : ((YawTo4(imageDirection)) ^ 2) + kBoundBoxIndex150;
    if (carEntry->GroupEnabled(SpriteGroupType::SlopesLoop))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::SlopesLoop, imageDirection, 7);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown60(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4D00
static void VehiclePitchDown165(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        carEntry--;
    }
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : ((YawTo4(imageDirection)) ^ 2) + kBoundBoxIndex165;
    if (carEntry->GroupEnabled(SpriteGroupType::SlopesLoop))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::SlopesLoop, imageDirection, 9);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown60(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

#pragma endregion

#pragma region CorkscrewSlopes

// 6D51A5
template<int32_t corkscrewFrame>
void VehiclePitchCorkscrew(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        carEntry--;
    }
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined
        ? boundingBoxIndex
        : (YawTo4(imageDirection)) + corkscrewFrame * kNumOrthogonalDirections + kBoundBoxIndexCorkscrew;
    if (carEntry->GroupEnabled(SpriteGroupType::Corkscrews))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Corkscrews, imageDirection, corkscrewFrame);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatUnbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

#pragma endregion

#pragma region DiagonalSlopesUp

#pragma region SlopeUp8

// 6D4D67
static void VehiclePitchUp8Unbanked(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes8))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes8, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlat(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4DB5
static void VehiclePitchUp8BankedLeft22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes8Banked22))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes8Banked22, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp8Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4DD3
static void VehiclePitchUp8BankedRight22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes8Banked22))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes8Banked22, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp8Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp8BankedLeft45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes8Banked45))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes8Banked45, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp8BankedRight45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes8Banked45))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes8Banked45, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedRight45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4D60
static void VehiclePitchUp8(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    // 0x009A3D44:
    switch (GetPaintBankRotation(vehicle))
    {
        case VehicleRoll::unbanked:
            VehiclePitchUp8Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left22:
        case VehicleRoll::uninvertingLeft22:
            VehiclePitchUp8BankedLeft22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right22:
        case VehicleRoll::uninvertingRight22:
            VehiclePitchUp8BankedRight22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left45:
            VehiclePitchUp8BankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right45:
            VehiclePitchUp8BankedRight45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        default:
            VehiclePitchUp8Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
    }
}

#pragma endregion

#pragma region SlopeUp16

// 6D4E3A
static void VehiclePitchUp16Unbanked(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo4(imageDirection) + kBoundBoxIndex16;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes16))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes16, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlat(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp16BankedLeft22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes16Banked22))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes16Banked22, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp25BankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp16BankedRight22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes16Banked22))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes16Banked22, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp25BankedRight45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp16BankedLeft45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes16Banked45))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes16Banked45, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp16BankedLeft22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp16BankedRight45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes16Banked45))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes16Banked45, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp16BankedRight22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp16(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    switch (GetPaintBankRotation(vehicle))
    {
        case VehicleRoll::unbanked:
            VehiclePitchUp16Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left22:
            VehiclePitchUp16BankedLeft22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right22:
            VehiclePitchUp16BankedRight22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left45:
            VehiclePitchUp16BankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right45:
            VehiclePitchUp16BankedRight45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        default:
            VehiclePitchUp16Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
    }
}

#pragma endregion

#pragma region SlopeUp50

// 6D4E8F
static void VehiclePitchUp50Unbanked(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo4(imageDirection) + kBoundBoxIndex50;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes50))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes50, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlat(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp50BankedLeft45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo16(imageDirection)) + kBoundBoxIndex60;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes50Banked45))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes50Banked45, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp50Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp50BankedRight45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo16(imageDirection)) + kBoundBoxIndex60;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes50Banked45))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes50Banked45, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp50Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp50BankedLeft67(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo16(imageDirection)) + kBoundBoxIndex60;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes50Banked67))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes50Banked67, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp25BankedLeft45(session, vehicle, (imageDirection + 2) % 32, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp50BankedRight67(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo16(imageDirection)) + kBoundBoxIndex60;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes50Banked67))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes50Banked67, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchUp25BankedRight45(session, vehicle, (imageDirection - 2) % 32, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp50BankedLeft90(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo16(imageDirection)) + kBoundBoxIndex60;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes50Banked90))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes50Banked90, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchCorkscrew<12>(session, vehicle, (imageDirection + 8) % 32, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp50BankedRight90(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo16(imageDirection)) + kBoundBoxIndex60;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes50Banked90))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes50Banked90, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchCorkscrew<2>(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchUp50(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    switch (GetPaintBankRotation(vehicle))
    {
        case VehicleRoll::unbanked:
            VehiclePitchUp50Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left45:
            VehiclePitchUp50BankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right45:
            VehiclePitchUp50BankedRight45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left67:
            VehiclePitchUp50BankedLeft67(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left90:
            VehiclePitchUp50BankedLeft90(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right67:
            VehiclePitchUp50BankedRight67(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right90:
            VehiclePitchUp50BankedRight90(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        default:
            VehiclePitchUp50Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

#pragma endregion

#pragma endregion

#pragma region DiagonalSlopesDown

#pragma region SlopeDown8

// 6D4D90
static void VehiclePitchDown8Unbanked(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes8))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes8, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlat(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4DF4
static void VehiclePitchDown8BankedLeft22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes8Banked22))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes8Banked22, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlat(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4E15
static void VehiclePitchDown8BankedRight22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes8Banked22))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes8Banked22, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlat(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown8BankedLeft45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes8Banked45))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes8Banked45, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown8BankedRight45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes8Banked45))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes8Banked45, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedRight45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

// 6D4D89
static void VehiclePitchDown8(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    // 0x009A3D94:
    switch (GetPaintBankRotation(vehicle))
    {
        case VehicleRoll::unbanked:
            VehiclePitchDown8Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left22:
        case VehicleRoll::uninvertingLeft22:
            VehiclePitchDown8BankedLeft22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right22:
        case VehicleRoll::uninvertingRight22:
            VehiclePitchDown8BankedRight22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left45:
            VehiclePitchDown8BankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right45:
            VehiclePitchDown8BankedRight45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        default:
            VehiclePitchDown8Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
    }
}

#pragma endregion

#pragma region SlopeDown16

// 6D4E63
static void VehiclePitchDown16Unbanked(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : ((YawTo4(imageDirection)) ^ 2) + kBoundBoxIndex16;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes16))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes16, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlat(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown16BankedLeft22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes16Banked22))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes16Banked22, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown25BankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown16BankedRight22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes16Banked22))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes16Banked22, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown25BankedRight45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown16BankedLeft45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes16Banked45))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes16Banked45, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown16BankedLeft22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown16BankedRight45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes16Banked45))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes16Banked45, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown16BankedRight22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown16(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    switch (GetPaintBankRotation(vehicle))
    {
        case VehicleRoll::unbanked:
            VehiclePitchDown16Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left22:
            VehiclePitchDown16BankedLeft22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right22:
            VehiclePitchDown16BankedRight22(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left45:
            VehiclePitchDown16BankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right45:
            VehiclePitchDown16BankedRight45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        default:
            VehiclePitchDown16Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
    }
}

#pragma endregion

#pragma region SlopeDown50

// 6D4EB8
static void VehiclePitchDown50Unbanked(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : ((YawTo4(imageDirection)) ^ 2) + kBoundBoxIndex50;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes50))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes50, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlat(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown50BankedLeft45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo16(imageDirection)) + kBoundBoxIndex60;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes50Banked45))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes50Banked45, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown50Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown50BankedRight45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo16(imageDirection)) + kBoundBoxIndex60;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes50Banked45))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes50Banked45, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown50Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown50BankedLeft67(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo16(imageDirection)) + kBoundBoxIndex60;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes50Banked67))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes50Banked67, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown25BankedLeft45(session, vehicle, (imageDirection - 2) % 32, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown50BankedRight67(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo16(imageDirection)) + kBoundBoxIndex60;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes50Banked67))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes50Banked67, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchDown25BankedRight45(session, vehicle, (imageDirection + 2) % 32, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown50BankedLeft90(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo16(imageDirection)) + kBoundBoxIndex60;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes50Banked90))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes50Banked90, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchCorkscrew<7>(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown50BankedRight90(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : (YawTo16(imageDirection)) + kBoundBoxIndex60;
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes50Banked90))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::Slopes50Banked90, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchCorkscrew<17>(session, vehicle, (imageDirection + 8) % 32, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchDown50(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    switch (GetPaintBankRotation(vehicle))
    {
        case VehicleRoll::unbanked:
            VehiclePitchDown50Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left45:
            VehiclePitchDown50BankedLeft45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right45:
            VehiclePitchDown50BankedRight45(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left67:
            VehiclePitchDown50BankedLeft67(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::left90:
            VehiclePitchDown50BankedLeft90(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right67:
            VehiclePitchDown50BankedRight67(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        case VehicleRoll::right90:
            VehiclePitchDown50BankedRight90(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
            break;
        default:
            VehiclePitchDown60Unbanked(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

#pragma endregion

#pragma endregion

#pragma region InvertingSlopesDown

// 6D47DA
static void VehiclePitchInvertingDown25(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    carEntry--;
    VehiclePitchDown25(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
}

// 6D4A02
static void VehiclePitchInvertingDown42(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    carEntry--;
    VehiclePitchDown42(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
}

// 6D4A56
static void VehiclePitchInvertingDown60(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    carEntry--;
    VehiclePitchDown60(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
}

#pragma endregion

#pragma region SpiralLiftSlopes

// 6D4773
static void VehiclePitchSpiralLiftUp(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    if (carEntry->GroupEnabled(SpriteGroupType::CurvedLiftHillUp))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::CurvedLiftHillUp, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlat(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

static void VehiclePitchSpiralLiftDown(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, const int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex)
{
    boundingBoxIndex = boundingBoxIndex != kBoundBoxIndexUndefined ? boundingBoxIndex
                                                                   : YawTo16(imageDirection) + kBoundBoxIndexFlat;
    if (carEntry->GroupEnabled(SpriteGroupType::CurvedLiftHillDown))
    {
        const int32_t spriteIndex = carEntry->SpriteOffset(SpriteGroupType::CurvedLiftHillDown, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteIndex, boundingBoxIndex, z, carEntry);
    }
    else
    {
        VehiclePitchFlat(session, vehicle, imageDirection, z, carEntry, boundingBoxIndex);
    }
}

#pragma endregion

// 0x009A3B14:
using vehicle_sprite_func = void (*)(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry,
    uint32_t boundingBoxIndex);

// clang-format off
static constexpr vehicle_sprite_func PaintFunctionsByPitch[] = {
    VehiclePitchFlat,
    VehiclePitchUp12,
    VehiclePitchUp25,
    VehiclePitchUp42,
    VehiclePitchUp60,
    VehiclePitchDown12,
    VehiclePitchDown25,
    VehiclePitchDown42,
    VehiclePitchDown60,
    VehiclePitchUp75,
    VehiclePitchUp90,
    VehiclePitchUp105,
    VehiclePitchUp120,
    VehiclePitchUp135,
    VehiclePitchUp150,
    VehiclePitchUp165,
    VehiclePitchInverted,
    VehiclePitchDown75,
    VehiclePitchDown90,
    VehiclePitchDown105,
    VehiclePitchDown120,
    VehiclePitchDown135,
    VehiclePitchDown150,
    VehiclePitchDown165,
    VehiclePitchCorkscrew<0>,
    VehiclePitchCorkscrew<1>,
    VehiclePitchCorkscrew<2>,
    VehiclePitchCorkscrew<3>,
    VehiclePitchCorkscrew<4>,
    VehiclePitchCorkscrew<5>,
    VehiclePitchCorkscrew<6>,
    VehiclePitchCorkscrew<7>,
    VehiclePitchCorkscrew<8>,
    VehiclePitchCorkscrew<9>,
    VehiclePitchCorkscrew<10>,
    VehiclePitchCorkscrew<11>,
    VehiclePitchCorkscrew<12>,
    VehiclePitchCorkscrew<13>,
    VehiclePitchCorkscrew<14>,
    VehiclePitchCorkscrew<15>,
    VehiclePitchCorkscrew<16>,
    VehiclePitchCorkscrew<17>,
    VehiclePitchCorkscrew<18>,
    VehiclePitchCorkscrew<19>,
    VehiclePitchFlat, // Half Helix Up Large
    VehiclePitchFlat, // Half Helix Up Small
    VehiclePitchFlat, // Half Helix Down Large
    VehiclePitchFlat, // Half Helix Down Small
    VehiclePitchFlat, // Quarter Helix Up
    VehiclePitchFlat, // Quarter Helix Down
    VehiclePitchUp8,
    VehiclePitchUp16,
    VehiclePitchUp50,
    VehiclePitchDown8,
    VehiclePitchDown16,
    VehiclePitchDown50,
    VehiclePitchInvertingDown25,
    VehiclePitchInvertingDown42,
    VehiclePitchInvertingDown60,
    VehiclePitchSpiralLiftUp,
    VehiclePitchSpiralLiftDown,
};
// clang-format on

static_assert(std::size(PaintFunctionsByPitch) == EnumValue(VehiclePitch::pitchCount));

#pragma region SplashEffects

/**
 *
 *  rct2: 0x006D5600
 */
static void vehicle_visual_splash1_effect(PaintSession& session, const int32_t z, const Vehicle* vehicle)
{
    if (vehicle->GetTrackType() != TrackElemType::watersplash)
    {
        return;
    }
    if (vehicle->track_progress < 48)
    {
        return;
    }
    if (vehicle->track_progress >= 112)
    {
        return;
    }
    if (vehicle->TrainHead()->velocity <= 5.0_mph)
    {
        return;
    }
    int32_t image_id = SPR_SPLASH_EFFECT_1_NE_0 + ((((vehicle->Orientation / 8) + session.CurrentRotation) & 3) * 8)
        + ((getGameState().currentTicks / 2) & 7);
    PaintAddImageAsChild(session, ImageId(image_id), { 0, 0, z }, { { 0, 0, z }, { 0, 0, 0 } });
}

/**
 *
 *  rct2: 0x006D5696
 */
static void vehicle_visual_splash2_effect(PaintSession& session, const int32_t z, const Vehicle* vehicle)
{
    if (vehicle->Orientation & 7)
    {
        return;
    }
    if (vehicle->pitch != VehiclePitch::flat)
    {
        return;
    }
    if (vehicle->velocity <= 5.0_mph)
    {
        return;
    }
    int32_t image_id = SPR_SPLASH_EFFECT_3_NE_0 + ((((vehicle->Orientation / 8) + session.CurrentRotation) & 3) * 8)
        + ((getGameState().currentTicks / 2) & 7);
    PaintAddImageAsChild(session, ImageId(image_id), { 0, 0, z }, { { 0, 0, z }, { 0, 0, 0 } });
}

/**
 *
 *  rct2: 0x006D57EE
 */
static void vehicle_visual_splash3_effect(PaintSession& session, const int32_t z, const Vehicle* vehicle)
{
    if (vehicle->Orientation & 7)
    {
        return;
    }
    if (vehicle->pitch != VehiclePitch::flat)
    {
        return;
    }
    if (vehicle->velocity <= 5.0_mph)
    {
        return;
    }
    int32_t image_id = SPR_SPLASH_EFFECT_1_NE_0 + ((((vehicle->Orientation / 8) + session.CurrentRotation) & 3) * 8)
        + ((getGameState().currentTicks / 2) & 7);
    PaintAddImageAsChild(session, ImageId(image_id), { 0, 0, z }, { { 0, 0, z }, { 0, 0, 0 } });
}

/**
 *
 *  rct2: 0x006D5783
 */
static void vehicle_visual_splash4_effect(PaintSession& session, const int32_t z, const Vehicle* vehicle)
{
    Vehicle* vehicle2 = getGameState().entities.GetEntity<Vehicle>(vehicle->prev_vehicle_on_ride);
    if (vehicle2 == nullptr)
    {
        return;
    }
    if (vehicle2->velocity <= 5.0_mph)
    {
        return;
    }
    if (vehicle->Orientation & 7)
    {
        return;
    }
    if (vehicle->pitch != VehiclePitch::flat)
    {
        return;
    }
    int32_t image_id = SPR_SPLASH_EFFECT_5_NE_0 + ((((vehicle->Orientation / 8) + session.CurrentRotation) & 3) * 8)
        + ((getGameState().currentTicks / 2) & 7);
    PaintAddImageAsChild(session, ImageId(image_id), { 0, 0, z }, { { 0, 0, z }, { 1, 1, 0 } });
}

/**
 *
 *  rct2: 0x006D5701
 */
static void vehicle_visual_splash5_effect(PaintSession& session, const int32_t z, const Vehicle* vehicle)
{
    Vehicle* vehicle2 = getGameState().entities.GetEntity<Vehicle>(vehicle->prev_vehicle_on_ride);
    if (vehicle2 == nullptr)
    {
        return;
    }
    if (vehicle2->velocity <= 5.0_mph)
    {
        return;
    }
    if (vehicle->Orientation & 7)
    {
        return;
    }
    if (vehicle->pitch != VehiclePitch::flat)
    {
        return;
    }
    if (!vehicle->IsOnCoveredTrack())
    {
        return;
    }
    int32_t image_id = SPR_SPLASH_EFFECT_5_NE_0 + ((((vehicle->Orientation / 8) + session.CurrentRotation) & 3) * 8)
        + ((getGameState().currentTicks / 2) & 7);
    PaintAddImageAsChild(session, ImageId(image_id), { 0, 0, z }, { { 0, 0, z }, { 1, 1, 0 } });
}

void VehicleVisualSplashEffect(PaintSession& session, const int32_t z, const Vehicle* vehicle, const CarEntry* carEntry)
{
    switch (carEntry->effect_visual)
    {
        case VEHICLE_VISUAL_SPLASH1_EFFECT:
            vehicle_visual_splash1_effect(session, z, vehicle);
            break;
        case VEHICLE_VISUAL_SPLASH2_EFFECT:
            vehicle_visual_splash2_effect(session, z, vehicle);
            break;
        case VEHICLE_VISUAL_SPLASH3_EFFECT:
            vehicle_visual_splash3_effect(session, z, vehicle);
            break;
        case VEHICLE_VISUAL_SPLASH4_EFFECT:
            vehicle_visual_splash4_effect(session, z, vehicle);
            break;
        case VEHICLE_VISUAL_SPLASH5_EFFECT:
            vehicle_visual_splash5_effect(session, z, vehicle);
            break;
    }
}

#pragma endregion

/**
 *
 *  rct2: 0x006D45F8
 */
void VehicleVisualDefault(
    PaintSession& session, int32_t imageDirection, const int32_t z, const Vehicle* vehicle, const CarEntry* carEntry)
{
    if (vehicle->pitch < VehiclePitch::pitchCount)
    {
        if (vehicle->HasFlag(VehicleFlags::CarIsReversed))
        {
            auto imagePitch = PitchInvertTable[EnumValue(vehicle->pitch)];
            auto imageYaw = (imageDirection + (kBaseRotation / 2)) & (kBaseRotation - 1);
            PaintFunctionsByPitch[EnumValue(imagePitch)](session, vehicle, imageYaw, z, carEntry, kBoundBoxIndexUndefined);
        }
        else
        {
            PaintFunctionsByPitch[EnumValue(vehicle->pitch)](
                session, vehicle, imageDirection, z, carEntry, kBoundBoxIndexUndefined);
        }
    }
}

void Vehicle::Paint(PaintSession& session, int32_t imageDirection) const
{
    const CarEntry* carEntry;

    if (HasFlag(VehicleFlags::Crashed))
    {
        PaintAddImageAsParent(
            session, ImageId(SPR_WATER_PARTICLES_DENSE_0 + animation_frame), { 0, 0, z }, { { 0, 0, z + 2 }, { 1, 1, 0 } });
        return;
    }

    int32_t zOffset = 0;
    if (IsCableLift())
    {
        carEntry = &kCableLiftVehicle;
    }
    else
    {
        auto rideEntry = GetRideEntry();
        if (rideEntry == nullptr)
        {
            return;
        }

        auto carEntryIndex = vehicle_type;
        if (HasFlag(VehicleFlags::CarIsInverted))
        {
            carEntryIndex++;
            zOffset += 16;
        }

        if (carEntryIndex >= std::size(rideEntry->Cars))
        {
            return;
        }
        carEntry = &rideEntry->Cars[carEntryIndex];
    }

    switch (carEntry->PaintStyle)
    {
        case VEHICLE_VISUAL_DEFAULT:
            VehicleVisualDefault(session, imageDirection, z + zOffset, this, carEntry);
            break;
        case VEHICLE_VISUAL_LAUNCHED_FREEFALL:
            VehicleVisualLaunchedFreefall(session, x, imageDirection, y, z + zOffset, this, carEntry);
            break;
        case VEHICLE_VISUAL_OBSERVATION_TOWER:
            VehicleVisualObservationTower(session, x, imageDirection, y, z + zOffset, this, carEntry);
            break;
        case VEHICLE_VISUAL_RIVER_RAPIDS:
            VehicleVisualRiverRapids(session, x, imageDirection, y, z + zOffset, this, carEntry);
            break;
        case VEHICLE_VISUAL_MINI_GOLF_PLAYER:
            VehicleVisualMiniGolfPlayer(session, x, imageDirection, y, z + zOffset, this);
            break;
        case VEHICLE_VISUAL_MINI_GOLF_BALL:
            VehicleVisualMiniGolfBall(session, x, imageDirection, y, z + zOffset, this);
            break;
        case VEHICLE_VISUAL_REVERSER:
            VehicleVisualReverser(session, x, imageDirection, y, z + zOffset, this, carEntry);
            break;
        case VEHICLE_VISUAL_SPLASH_BOATS_OR_WATER_COASTER:
            VehicleVisualSplashBoatsOrWaterCoaster(session, x, imageDirection, y, z + zOffset, this, carEntry);
            break;
        case VEHICLE_VISUAL_ROTO_DROP:
            VehicleVisualRotoDrop(session, x, imageDirection, y, z + zOffset, this, carEntry);
            break;
        case VEHICLE_VISUAL_VIRGINIA_REEL:
            VehicleVisualVirginiaReel(session, x, imageDirection, y, z + zOffset, this, carEntry);
            break;
        case VEHICLE_VISUAL_SUBMARINE:
            VehicleVisualSubmarine(session, x, imageDirection, y, z + zOffset, this, carEntry);
            break;
    }
}
