use crate::{
    full_text_parser::{config::ConfigError, error::FullTextParserError},
    images::ImageDownloadError,
};
use thiserror::Error;

#[derive(Error, Debug)]
pub enum ScraperError {
    #[error("Configerror {0}")]
    Config(#[from] ConfigError),
    #[error("ImageDownloadError {0}")]
    Image(#[from] ImageDownloadError),
    #[error("FullTextParserError {0}")]
    Scrap(#[from] FullTextParserError),
}
