/* ExportOrgMode.c generated by valac 0.56.18, the Vala compiler
 * generated from ExportOrgMode.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <libxml/tree.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_EXPORT (export_get_type ())
#define EXPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT, Export))
#define EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT, ExportClass))
#define IS_EXPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT))
#define IS_EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT))
#define EXPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT, ExportClass))

typedef struct _Export Export;
typedef struct _ExportClass ExportClass;
typedef struct _ExportPrivate ExportPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_EXPORT_ORG_MODE (export_org_mode_get_type ())
#define EXPORT_ORG_MODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT_ORG_MODE, ExportOrgMode))
#define EXPORT_ORG_MODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT_ORG_MODE, ExportOrgModeClass))
#define IS_EXPORT_ORG_MODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT_ORG_MODE))
#define IS_EXPORT_ORG_MODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT_ORG_MODE))
#define EXPORT_ORG_MODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT_ORG_MODE, ExportOrgModeClass))

typedef struct _ExportOrgMode ExportOrgMode;
typedef struct _ExportOrgModeClass ExportOrgModeClass;
typedef struct _ExportOrgModePrivate ExportOrgModePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;

#define TYPE_CANVAS_TEXT (canvas_text_get_type ())
#define CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS_TEXT, CanvasText))
#define CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS_TEXT, CanvasTextClass))
#define IS_CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS_TEXT))
#define IS_CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS_TEXT))
#define CANVAS_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS_TEXT, CanvasTextClass))

typedef struct _CanvasText CanvasText;
typedef struct _CanvasTextClass CanvasTextClass;

#define TYPE_FORMATTED_TEXT (formatted_text_get_type ())
#define FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FORMATTED_TEXT, FormattedText))
#define FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FORMATTED_TEXT, FormattedTextClass))
#define IS_FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FORMATTED_TEXT))
#define IS_FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FORMATTED_TEXT))
#define FORMATTED_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FORMATTED_TEXT, FormattedTextClass))

typedef struct _FormattedText FormattedText;
typedef struct _FormattedTextClass FormattedTextClass;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _Export {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ExportPrivate * priv;
};

struct _ExportClass {
	GTypeClass parent_class;
	void (*finalize) (Export *self);
	gboolean (*export) (Export* self, const gchar* fname, DrawArea* da);
	gboolean (*import) (Export* self, const gchar* fname, DrawArea* da);
	void (*add_settings) (Export* self, GtkGrid* grid);
	void (*save_settings) (Export* self, xmlNode* node);
	void (*load_settings) (Export* self, xmlNode* node);
};

struct _ExportOrgMode {
	Export parent_instance;
	ExportOrgModePrivate * priv;
};

struct _ExportOrgModeClass {
	ExportClass parent_class;
};

static gpointer export_org_mode_parent_class = NULL;

VALA_EXTERN gpointer export_ref (gpointer instance);
VALA_EXTERN void export_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_export (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_export (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_export (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_export (const GValue* value);
VALA_EXTERN GType export_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Export, export_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType export_org_mode_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ExportOrgMode, export_unref)
VALA_EXTERN void export_add_settings (Export* self,
                          GtkGrid* grid);
VALA_EXTERN void export_save_settings (Export* self,
                           xmlNode* node);
VALA_EXTERN void export_load_settings (Export* self,
                           xmlNode* node);
VALA_EXTERN gboolean export_export (Export* self,
                        const gchar* fname,
                        DrawArea* da);
VALA_EXTERN ExportOrgMode* export_org_mode_new (void);
VALA_EXTERN ExportOrgMode* export_org_mode_construct (GType object_type);
VALA_EXTERN Export* export_new (const gchar* name,
                    const gchar* label,
                    gchar** extensions,
                    gint extensions_length1,
                    gboolean exportable,
                    gboolean importable,
                    gboolean dir);
VALA_EXTERN Export* export_construct (GType object_type,
                          const gchar* name,
                          const gchar* label,
                          gchar** extensions,
                          gint extensions_length1,
                          gboolean exportable,
                          gboolean importable,
                          gboolean dir);
static void export_org_mode_real_add_settings (Export* base,
                                        GtkGrid* grid);
VALA_EXTERN void export_add_setting_bool (Export* self,
                              const gchar* name,
                              GtkGrid* grid,
                              const gchar* label,
                              const gchar* help,
                              gboolean dflt);
static void export_org_mode_real_save_settings (Export* base,
                                         xmlNode* node);
VALA_EXTERN gboolean export_get_bool (Export* self,
                          const gchar* name);
static void export_org_mode_real_load_settings (Export* base,
                                         xmlNode* node);
VALA_EXTERN void export_set_bool (Export* self,
                      const gchar* name,
                      gboolean value);
static gboolean export_org_mode_real_export (Export* base,
                                      const gchar* fname,
                                      DrawArea* da);
static void export_org_mode_export_top_nodes (ExportOrgMode* self,
                                       GFileOutputStream* os,
                                       DrawArea* da);
static gchar* export_org_mode_sprefix (ExportOrgMode* self);
static gchar* export_org_mode_wrap (ExportOrgMode* self,
                             const gchar* prefix);
static gchar* export_org_mode_linestart (ExportOrgMode* self,
                                  const gchar* prefix);
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN GArray* draw_area_get_nodes (DrawArea* self);
VALA_EXTERN GType canvas_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CanvasText, g_object_unref)
VALA_EXTERN CanvasText* node_get_name (Node* self);
VALA_EXTERN gpointer formatted_text_ref (gpointer instance);
VALA_EXTERN void formatted_text_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_formatted_text (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_formatted_text (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_formatted_text (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_formatted_text (const GValue* value);
VALA_EXTERN GType formatted_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedText, formatted_text_unref)
VALA_EXTERN FormattedText* canvas_text_get_text (CanvasText* self);
VALA_EXTERN const gchar* formatted_text_get_text (FormattedText* self);
VALA_EXTERN const gchar* node_get_note (Node* self);
VALA_EXTERN GArray* node_children (Node* self);
static void export_org_mode_export_node (ExportOrgMode* self,
                                  GFileOutputStream* os,
                                  Node* node,
                                  const gchar* prefix);
VALA_EXTERN gboolean node_is_in_sequence (Node* self);
VALA_EXTERN gint node_index (Node* self);
VALA_EXTERN gboolean node_is_task (Node* self);
VALA_EXTERN gboolean node_is_task_done (Node* self);
static GType export_org_mode_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

ExportOrgMode*
export_org_mode_construct (GType object_type)
{
	ExportOrgMode* self = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	_tmp0_ = g_strdup (".org");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	self = (ExportOrgMode*) export_construct (object_type, "org-mode", _ ("Org-Mode"), _tmp2_, (gint) 1, TRUE, FALSE, FALSE);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	return self;
}

ExportOrgMode*
export_org_mode_new (void)
{
	return export_org_mode_construct (TYPE_EXPORT_ORG_MODE);
}

static void
export_org_mode_real_add_settings (Export* base,
                                   GtkGrid* grid)
{
	ExportOrgMode * self;
	self = (ExportOrgMode*) base;
	g_return_if_fail (grid != NULL);
	export_add_setting_bool ((Export*) self, "indent-mode", grid, _ ("Indent Mode"), _ ("Export using indentation spaces"), TRUE);
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static void
export_org_mode_real_save_settings (Export* base,
                                    xmlNode* node)
{
	ExportOrgMode * self;
	gboolean value = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (ExportOrgMode*) base;
	value = export_get_bool ((Export*) self, "indent-mode");
	_tmp0_ = bool_to_string (value);
	_tmp1_ = _tmp0_;
	xmlSetProp (node, (xmlChar*) "indent-mode", (xmlChar*) _tmp1_);
	_g_free0 (_tmp1_);
}

static gboolean
bool_parse (const gchar* str)
{
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	if (g_strcmp0 (str, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
export_org_mode_real_load_settings (Export* base,
                                    xmlNode* node)
{
	ExportOrgMode * self;
	gchar* q = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	self = (ExportOrgMode*) base;
	_tmp0_ = (gchar*) xmlGetProp (node, (xmlChar*) "indent-mode");
	q = _tmp0_;
	_tmp1_ = q;
	if (_tmp1_ != NULL) {
		gboolean value = FALSE;
		const gchar* _tmp2_;
		_tmp2_ = q;
		value = bool_parse (_tmp2_);
		export_set_bool ((Export*) self, "indent-mode", value);
	}
	_g_free0 (q);
}

static gboolean
export_org_mode_real_export (Export* base,
                             const gchar* fname,
                             DrawArea* da)
{
	ExportOrgMode * self;
	GFile* file = NULL;
	GFile* _tmp0_;
	gboolean retval = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (ExportOrgMode*) base;
	g_return_val_if_fail (fname != NULL, FALSE);
	g_return_val_if_fail (da != NULL, FALSE);
	_tmp0_ = g_file_new_for_path (fname);
	file = _tmp0_;
	retval = TRUE;
	{
		GFileOutputStream* os = NULL;
		GFileOutputStream* _tmp1_;
		_tmp1_ = g_file_replace (file, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
		os = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		export_org_mode_export_top_nodes (self, os, da);
		_g_object_unref0 (os);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		retval = FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp2_;
	}
	result = retval;
	_g_object_unref0 (file);
	return result;
}

static gchar*
export_org_mode_sprefix (ExportOrgMode* self)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (export_get_bool ((Export*) self, "indent-mode")) {
		_tmp0_ = "  ";
	} else {
		_tmp0_ = "*";
	}
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
export_org_mode_wrap (ExportOrgMode* self,
                      const gchar* prefix)
{
	gchar* _tmp0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prefix != NULL, NULL);
	if (export_get_bool ((Export*) self, "indent-mode")) {
		gchar* _tmp1_;
		_tmp1_ = g_strconcat (prefix, " ", NULL);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	result = _tmp0_;
	return result;
}

static gchar*
export_org_mode_linestart (ExportOrgMode* self,
                           const gchar* prefix)
{
	gchar* _tmp0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prefix != NULL, NULL);
	if (export_get_bool ((Export*) self, "indent-mode")) {
		gchar* _tmp1_;
		_tmp1_ = g_strconcat (prefix, "  ", NULL);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	result = _tmp0_;
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
export_org_mode_export_top_nodes (ExportOrgMode* self,
                                  GFileOutputStream* os,
                                  DrawArea* da)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (os != NULL);
	g_return_if_fail (da != NULL);
	{
		GArray* nodes = NULL;
		GArray* _tmp0_;
		_tmp0_ = draw_area_get_nodes (da);
		nodes = _tmp0_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					GArray* _tmp3_;
					gchar* title = NULL;
					GArray* _tmp4_;
					Node* _tmp5_;
					CanvasText* _tmp6_;
					CanvasText* _tmp7_;
					FormattedText* _tmp8_;
					FormattedText* _tmp9_;
					const gchar* _tmp10_;
					const gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					const gchar* _tmp16_;
					guint8* _tmp17_;
					gint _tmp17__length1;
					gint _tmp18_ = 0;
					guint8* _tmp19_;
					gint _tmp19__length1;
					GArray* _tmp20_;
					Node* _tmp21_;
					const gchar* _tmp22_;
					const gchar* _tmp23_;
					GArray* children = NULL;
					GArray* _tmp40_;
					Node* _tmp41_;
					GArray* _tmp42_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp3_ = nodes;
					if (!(((guint) i) < _tmp3_->len)) {
						break;
					}
					_tmp4_ = nodes;
					_tmp5_ = g_array_index (_tmp4_, Node*, (guint) i);
					_tmp6_ = node_get_name (_tmp5_);
					_tmp7_ = _tmp6_;
					_tmp8_ = canvas_text_get_text (_tmp7_);
					_tmp9_ = _tmp8_;
					_tmp10_ = formatted_text_get_text (_tmp9_);
					_tmp11_ = _tmp10_;
					_tmp12_ = g_strconcat ("* ", _tmp11_, NULL);
					_tmp13_ = _tmp12_;
					_tmp14_ = g_strconcat (_tmp13_, "\n\n", NULL);
					_tmp15_ = _tmp14_;
					_g_free0 (_tmp13_);
					title = _tmp15_;
					_tmp16_ = title;
					_tmp17_ = string_get_data (_tmp16_, &_tmp18_);
					_tmp17__length1 = _tmp18_;
					_tmp19_ = _tmp17_;
					_tmp19__length1 = _tmp17__length1;
					g_output_stream_write ((GOutputStream*) os, _tmp19_, (gsize) _tmp19__length1, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (title);
						_g_array_unref0 (nodes);
						goto __catch0_g_error;
					}
					_tmp20_ = nodes;
					_tmp21_ = g_array_index (_tmp20_, Node*, (guint) i);
					_tmp22_ = node_get_note (_tmp21_);
					_tmp23_ = _tmp22_;
					if (g_strcmp0 (_tmp23_, "") != 0) {
						gchar* note = NULL;
						gchar* _tmp24_;
						gchar* _tmp25_;
						gchar* _tmp26_;
						gchar* _tmp27_;
						GArray* _tmp28_;
						Node* _tmp29_;
						const gchar* _tmp30_;
						const gchar* _tmp31_;
						gchar* _tmp32_;
						gchar* _tmp33_;
						gchar* _tmp34_;
						gchar* _tmp35_;
						const gchar* _tmp36_;
						guint8* _tmp37_;
						gint _tmp37__length1;
						gint _tmp38_ = 0;
						guint8* _tmp39_;
						gint _tmp39__length1;
						_tmp24_ = export_org_mode_linestart (self, "");
						_tmp25_ = _tmp24_;
						_tmp26_ = g_strconcat ("\n", _tmp25_, NULL);
						_tmp27_ = _tmp26_;
						_tmp28_ = nodes;
						_tmp29_ = g_array_index (_tmp28_, Node*, (guint) i);
						_tmp30_ = node_get_note (_tmp29_);
						_tmp31_ = _tmp30_;
						_tmp32_ = string_replace (_tmp31_, "\n", "\n  ");
						_tmp33_ = _tmp32_;
						_tmp34_ = g_strconcat (_tmp27_, _tmp33_, NULL);
						_tmp35_ = _tmp34_;
						_g_free0 (_tmp33_);
						_g_free0 (_tmp27_);
						_g_free0 (_tmp25_);
						note = _tmp35_;
						_tmp36_ = note;
						_tmp37_ = string_get_data (_tmp36_, &_tmp38_);
						_tmp37__length1 = _tmp38_;
						_tmp39_ = _tmp37_;
						_tmp39__length1 = _tmp37__length1;
						g_output_stream_write ((GOutputStream*) os, _tmp39_, (gsize) _tmp39__length1, NULL, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_free0 (note);
							_g_free0 (title);
							_g_array_unref0 (nodes);
							goto __catch0_g_error;
						}
						_g_free0 (note);
					}
					_tmp40_ = nodes;
					_tmp41_ = g_array_index (_tmp40_, Node*, (guint) i);
					_tmp42_ = node_children (_tmp41_);
					children = _tmp42_;
					{
						gint j = 0;
						j = 0;
						{
							gboolean _tmp43_ = FALSE;
							_tmp43_ = TRUE;
							while (TRUE) {
								GArray* _tmp45_;
								GArray* _tmp46_;
								Node* _tmp47_;
								gchar* _tmp48_;
								gchar* _tmp49_;
								if (!_tmp43_) {
									gint _tmp44_;
									_tmp44_ = j;
									j = _tmp44_ + 1;
								}
								_tmp43_ = FALSE;
								_tmp45_ = children;
								if (!(((guint) j) < _tmp45_->len)) {
									break;
								}
								_tmp46_ = children;
								_tmp47_ = g_array_index (_tmp46_, Node*, (guint) j);
								_tmp48_ = export_org_mode_sprefix (self);
								_tmp49_ = _tmp48_;
								export_org_mode_export_node (self, os, _tmp47_, _tmp49_);
								_g_free0 (_tmp49_);
							}
						}
					}
					_g_array_unref0 (children);
					_g_free0 (title);
				}
			}
		}
		_g_array_unref0 (nodes);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
export_org_mode_export_node (ExportOrgMode* self,
                             GFileOutputStream* os,
                             Node* node,
                             const gchar* prefix)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (os != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (prefix != NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* title = NULL;
		gchar* _tmp3_;
		const gchar* _tmp8_;
		CanvasText* _tmp9_;
		CanvasText* _tmp10_;
		FormattedText* _tmp11_;
		FormattedText* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		const gchar* _tmp22_;
		guint8* _tmp23_;
		gint _tmp23__length1;
		gint _tmp24_ = 0;
		guint8* _tmp25_;
		gint _tmp25__length1;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		guint8* _tmp48_;
		gint _tmp48__length1;
		gint _tmp49_ = 0;
		guint8* _tmp50_;
		gint _tmp50__length1;
		GArray* children = NULL;
		GArray* _tmp51_;
		if (node_is_in_sequence (node)) {
			gchar* _tmp1_;
			_tmp1_ = g_strdup_printf ("%d. ", node_index (node) + 1);
			_g_free0 (_tmp0_);
			_tmp0_ = _tmp1_;
		} else {
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("* ");
			_g_free0 (_tmp0_);
			_tmp0_ = _tmp2_;
		}
		_tmp3_ = g_strconcat (prefix, _tmp0_, NULL);
		title = _tmp3_;
		if (node_is_task (node)) {
			if (node_is_task_done (node)) {
				const gchar* _tmp4_;
				gchar* _tmp5_;
				_tmp4_ = title;
				_tmp5_ = g_strconcat (_tmp4_, "[x] ", NULL);
				_g_free0 (title);
				title = _tmp5_;
			} else {
				const gchar* _tmp6_;
				gchar* _tmp7_;
				_tmp6_ = title;
				_tmp7_ = g_strconcat (_tmp6_, "[ ] ", NULL);
				_g_free0 (title);
				title = _tmp7_;
			}
		}
		_tmp8_ = title;
		_tmp9_ = node_get_name (node);
		_tmp10_ = _tmp9_;
		_tmp11_ = canvas_text_get_text (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = formatted_text_get_text (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = export_org_mode_wrap (self, prefix);
		_tmp16_ = _tmp15_;
		_tmp17_ = string_replace (_tmp14_, "\n", _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strconcat (_tmp18_, "\n", NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strconcat (_tmp8_, _tmp20_, NULL);
		_g_free0 (title);
		title = _tmp21_;
		_g_free0 (_tmp20_);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp16_);
		_tmp22_ = title;
		_tmp23_ = string_get_data (_tmp22_, &_tmp24_);
		_tmp23__length1 = _tmp24_;
		_tmp25_ = _tmp23_;
		_tmp25__length1 = _tmp23__length1;
		g_output_stream_write ((GOutputStream*) os, _tmp25_, (gsize) _tmp25__length1, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (title);
			_g_free0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp26_ = node_get_note (node);
		_tmp27_ = _tmp26_;
		if (g_strcmp0 (_tmp27_, "") != 0) {
			gchar* note = NULL;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			const gchar* _tmp32_;
			const gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			const gchar* _tmp44_;
			guint8* _tmp45_;
			gint _tmp45__length1;
			gint _tmp46_ = 0;
			guint8* _tmp47_;
			gint _tmp47__length1;
			_tmp28_ = export_org_mode_linestart (self, prefix);
			_tmp29_ = _tmp28_;
			_tmp30_ = g_strconcat ("\n", _tmp29_, NULL);
			_tmp31_ = _tmp30_;
			_tmp32_ = node_get_note (node);
			_tmp33_ = _tmp32_;
			_tmp34_ = export_org_mode_linestart (self, prefix);
			_tmp35_ = _tmp34_;
			_tmp36_ = g_strconcat ("\n", _tmp35_, NULL);
			_tmp37_ = _tmp36_;
			_tmp38_ = string_replace (_tmp33_, "\n", _tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = g_strconcat (_tmp31_, _tmp39_, NULL);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strconcat (_tmp41_, "\n", NULL);
			_tmp43_ = _tmp42_;
			_g_free0 (_tmp41_);
			_g_free0 (_tmp39_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp35_);
			_g_free0 (_tmp31_);
			_g_free0 (_tmp29_);
			note = _tmp43_;
			_tmp44_ = note;
			_tmp45_ = string_get_data (_tmp44_, &_tmp46_);
			_tmp45__length1 = _tmp46_;
			_tmp47_ = _tmp45_;
			_tmp47__length1 = _tmp45__length1;
			g_output_stream_write ((GOutputStream*) os, _tmp47_, (gsize) _tmp47__length1, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (note);
				_g_free0 (title);
				_g_free0 (_tmp0_);
				goto __catch0_g_error;
			}
			_g_free0 (note);
		}
		_tmp48_ = string_get_data ("\n", &_tmp49_);
		_tmp48__length1 = _tmp49_;
		_tmp50_ = _tmp48_;
		_tmp50__length1 = _tmp48__length1;
		g_output_stream_write ((GOutputStream*) os, _tmp50_, (gsize) _tmp50__length1, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (title);
			_g_free0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp51_ = node_children (node);
		children = _tmp51_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp52_ = FALSE;
				_tmp52_ = TRUE;
				while (TRUE) {
					GArray* _tmp54_;
					GArray* _tmp55_;
					Node* _tmp56_;
					gchar* _tmp57_;
					gchar* _tmp58_;
					gchar* _tmp59_;
					gchar* _tmp60_;
					if (!_tmp52_) {
						gint _tmp53_;
						_tmp53_ = i;
						i = _tmp53_ + 1;
					}
					_tmp52_ = FALSE;
					_tmp54_ = children;
					if (!(((guint) i) < _tmp54_->len)) {
						break;
					}
					_tmp55_ = children;
					_tmp56_ = g_array_index (_tmp55_, Node*, (guint) i);
					_tmp57_ = export_org_mode_sprefix (self);
					_tmp58_ = _tmp57_;
					_tmp59_ = g_strconcat (prefix, _tmp58_, NULL);
					_tmp60_ = _tmp59_;
					export_org_mode_export_node (self, os, _tmp56_, _tmp60_);
					_g_free0 (_tmp60_);
					_g_free0 (_tmp58_);
				}
			}
		}
		_g_array_unref0 (children);
		_g_free0 (title);
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
export_org_mode_class_init (ExportOrgModeClass * klass,
                            gpointer klass_data)
{
	export_org_mode_parent_class = g_type_class_peek_parent (klass);
	((ExportClass *) klass)->add_settings = (void (*) (Export*, GtkGrid*)) export_org_mode_real_add_settings;
	((ExportClass *) klass)->save_settings = (void (*) (Export*, xmlNode*)) export_org_mode_real_save_settings;
	((ExportClass *) klass)->load_settings = (void (*) (Export*, xmlNode*)) export_org_mode_real_load_settings;
	((ExportClass *) klass)->export = (gboolean (*) (Export*, const gchar*, DrawArea*)) export_org_mode_real_export;
}

static void
export_org_mode_instance_init (ExportOrgMode * self,
                               gpointer klass)
{
}

static GType
export_org_mode_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ExportOrgModeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) export_org_mode_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExportOrgMode), 0, (GInstanceInitFunc) export_org_mode_instance_init, NULL };
	GType export_org_mode_type_id;
	export_org_mode_type_id = g_type_register_static (TYPE_EXPORT, "ExportOrgMode", &g_define_type_info, 0);
	return export_org_mode_type_id;
}

GType
export_org_mode_get_type (void)
{
	static volatile gsize export_org_mode_type_id__once = 0;
	if (g_once_init_enter (&export_org_mode_type_id__once)) {
		GType export_org_mode_type_id;
		export_org_mode_type_id = export_org_mode_get_type_once ();
		g_once_init_leave (&export_org_mode_type_id__once, export_org_mode_type_id);
	}
	return export_org_mode_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

