/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Skeleton implementation for Bison GLR parsers in C

   Copyright (C) 2002-2015, 2018-2021 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C GLR parser skeleton written by Paul Hilfinger.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "glr.c"

/* Pure parsers.  */
#define YYPURE 0




/* Substitute the variable and function names.  */
#define yyparse SQLyyparse
#define yylex   SQLyylex
#define yyerror SQLyyerror
#define yydebug SQLyydebug
#define yylval  SQLyylval
#define yychar  SQLyychar
#define yynerrs SQLyynerrs

/* First part of user prologue.  */

/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#include <vector>
#include <string.h>

#include <connectivity/sqlnode.hxx>
#include <connectivity/sqlparse.hxx>
#include <connectivity/sqlbison_exports.hxx>
#include <connectivity/sqlscan.hxx>
#include <connectivity/internalnode.hxx>
#include <com/sun/star/lang/Locale.hpp>
#include <com/sun/star/sdbc/DataType.hpp>
#include <com/sun/star/util/Date.hpp>
#include <com/sun/star/util/DateTime.hpp>
#include <com/sun/star/util/Time.hpp>
#include <com/sun/star/util/XNumberFormatter.hpp>
#include <com/sun/star/util/XNumberFormatsSupplier.hpp>
#include <com/sun/star/util/XNumberFormats.hpp>
#include <com/sun/star/util/NumberFormat.hpp>
#include <com/sun/star/util/XNumberFormatTypes.hpp>
#include <com/sun/star/beans/XPropertySet.hpp>
#include <com/sun/star/i18n/KParseType.hpp>
#include <com/sun/star/i18n/KParseTokens.hpp>

#include <osl/diagnose.h>
#include "connectivity/dbconversion.hxx"
#include <rtl/ustrbuf.hxx>
#include <sal/log.hxx>

#if defined _MSC_VER
#pragma warning(push)
#pragma warning(disable: 4324) // structure was padded due to alignment specifier
#pragma warning(disable: 4065) // switch statement contains 'default' but no 'case' labels
#pragma warning(disable: 4702) // unreachable code
#endif

#ifdef __GNUC__
# pragma GCC diagnostic ignored "-Wwrite-strings"
# pragma GCC diagnostic ignored "-Wunused-function"
#endif

inline connectivity::OSQLInternalNode* newNode(const char* pNewValue,
        const connectivity::SQLNodeType eNodeType,
        const sal_uInt32 nNodeID = 0);

inline connectivity::OSQLInternalNode* newNode(const OString& _newValue,
        const connectivity::SQLNodeType eNodeType,
        const sal_uInt32 nNodeID = 0);

inline connectivity::OSQLInternalNode* newNode(const OUString& _newValue,
        const connectivity::SQLNodeType eNodeType,
        const sal_uInt32 nNodeID = 0);


// yyi is the internal number of the rule that is currently being reduced
// This can be mapped to external rule number via the yyrmap.
#if defined YYBISON && YYBISON >= 30800
#define SQL_NEW_RULE 			newNode("", SQLNodeType::Rule, yyr1[yyrule])
#define SQL_NEW_LISTRULE 		newNode("", SQLNodeType::ListRule, yyr1[yyrule])
#define SQL_NEW_COMMALISTRULE   newNode("", SQLNodeType::CommaListRule, yyr1[yyrule])
#else
#define SQL_NEW_RULE 			newNode("", SQLNodeType::Rule, yyr1[yyn])
#define SQL_NEW_LISTRULE 		newNode("", SQLNodeType::ListRule, yyr1[yyn])
#define SQL_NEW_COMMALISTRULE   newNode("", SQLNodeType::CommaListRule, yyr1[yyn])
#endif


extern connectivity::OSQLParser* xxx_pGLOBAL_SQLPARSER;

#define YYERROR_VERBOSE

#define SQLyyerror(s)						\
{											\
	xxx_pGLOBAL_SQLPARSER->error(s);		\
}

using namespace connectivity;
#define SQLyylex xxx_pGLOBAL_SQLPARSER->SQLlex


# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "sqlbison.hxx"

/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_3_ = 3,                         /* '('  */
  YYSYMBOL_4_ = 4,                         /* ')'  */
  YYSYMBOL_5_ = 5,                         /* ','  */
  YYSYMBOL_6_ = 6,                         /* ':'  */
  YYSYMBOL_7_ = 7,                         /* ';'  */
  YYSYMBOL_8_ = 8,                         /* '?'  */
  YYSYMBOL_9_ = 9,                         /* '['  */
  YYSYMBOL_10_ = 10,                       /* ']'  */
  YYSYMBOL_11_ = 11,                       /* '{'  */
  YYSYMBOL_12_ = 12,                       /* '}'  */
  YYSYMBOL_13_ = 13,                       /* '.'  */
  YYSYMBOL_14_K_ = 14,                     /* 'K'  */
  YYSYMBOL_15_M_ = 15,                     /* 'M'  */
  YYSYMBOL_16_G_ = 16,                     /* 'G'  */
  YYSYMBOL_17_T_ = 17,                     /* 'T'  */
  YYSYMBOL_18_P_ = 18,                     /* 'P'  */
  YYSYMBOL_SQL_TOKEN_STRING = 19,          /* SQL_TOKEN_STRING  */
  YYSYMBOL_SQL_TOKEN_ACCESS_DATE = 20,     /* SQL_TOKEN_ACCESS_DATE  */
  YYSYMBOL_SQL_TOKEN_INT = 21,             /* SQL_TOKEN_INT  */
  YYSYMBOL_SQL_TOKEN_REAL_NUM = 22,        /* SQL_TOKEN_REAL_NUM  */
  YYSYMBOL_SQL_TOKEN_INTNUM = 23,          /* SQL_TOKEN_INTNUM  */
  YYSYMBOL_SQL_TOKEN_APPROXNUM = 24,       /* SQL_TOKEN_APPROXNUM  */
  YYSYMBOL_SQL_TOKEN_NOT = 25,             /* SQL_TOKEN_NOT  */
  YYSYMBOL_SQL_TOKEN_NAME = 26,            /* SQL_TOKEN_NAME  */
  YYSYMBOL_SQL_TOKEN_UMINUS = 27,          /* SQL_TOKEN_UMINUS  */
  YYSYMBOL_SQL_TOKEN_ALL = 28,             /* SQL_TOKEN_ALL  */
  YYSYMBOL_SQL_TOKEN_ALTER = 29,           /* SQL_TOKEN_ALTER  */
  YYSYMBOL_SQL_TOKEN_AMMSC = 30,           /* SQL_TOKEN_AMMSC  */
  YYSYMBOL_SQL_TOKEN_ANY = 31,             /* SQL_TOKEN_ANY  */
  YYSYMBOL_SQL_TOKEN_AS = 32,              /* SQL_TOKEN_AS  */
  YYSYMBOL_SQL_TOKEN_ASC = 33,             /* SQL_TOKEN_ASC  */
  YYSYMBOL_SQL_TOKEN_AT = 34,              /* SQL_TOKEN_AT  */
  YYSYMBOL_SQL_TOKEN_AUTHORIZATION = 35,   /* SQL_TOKEN_AUTHORIZATION  */
  YYSYMBOL_SQL_TOKEN_AVG = 36,             /* SQL_TOKEN_AVG  */
  YYSYMBOL_SQL_TOKEN_BETWEEN = 37,         /* SQL_TOKEN_BETWEEN  */
  YYSYMBOL_SQL_TOKEN_BIT = 38,             /* SQL_TOKEN_BIT  */
  YYSYMBOL_SQL_TOKEN_BOTH = 39,            /* SQL_TOKEN_BOTH  */
  YYSYMBOL_SQL_TOKEN_BY = 40,              /* SQL_TOKEN_BY  */
  YYSYMBOL_SQL_TOKEN_CAST = 41,            /* SQL_TOKEN_CAST  */
  YYSYMBOL_SQL_TOKEN_CHARACTER = 42,       /* SQL_TOKEN_CHARACTER  */
  YYSYMBOL_SQL_TOKEN_CHECK = 43,           /* SQL_TOKEN_CHECK  */
  YYSYMBOL_SQL_TOKEN_COLLATE = 44,         /* SQL_TOKEN_COLLATE  */
  YYSYMBOL_SQL_TOKEN_COMMIT = 45,          /* SQL_TOKEN_COMMIT  */
  YYSYMBOL_SQL_TOKEN_CONTINUE = 46,        /* SQL_TOKEN_CONTINUE  */
  YYSYMBOL_SQL_TOKEN_CONVERT = 47,         /* SQL_TOKEN_CONVERT  */
  YYSYMBOL_SQL_TOKEN_COUNT = 48,           /* SQL_TOKEN_COUNT  */
  YYSYMBOL_SQL_TOKEN_CREATE = 49,          /* SQL_TOKEN_CREATE  */
  YYSYMBOL_SQL_TOKEN_CROSS = 50,           /* SQL_TOKEN_CROSS  */
  YYSYMBOL_SQL_TOKEN_CURRENT = 51,         /* SQL_TOKEN_CURRENT  */
  YYSYMBOL_SQL_TOKEN_CURSOR = 52,          /* SQL_TOKEN_CURSOR  */
  YYSYMBOL_SQL_TOKEN_DATE = 53,            /* SQL_TOKEN_DATE  */
  YYSYMBOL_SQL_TOKEN_DATEVALUE = 54,       /* SQL_TOKEN_DATEVALUE  */
  YYSYMBOL_SQL_TOKEN_DAY = 55,             /* SQL_TOKEN_DAY  */
  YYSYMBOL_SQL_TOKEN_DEC = 56,             /* SQL_TOKEN_DEC  */
  YYSYMBOL_SQL_TOKEN_DECIMAL = 57,         /* SQL_TOKEN_DECIMAL  */
  YYSYMBOL_SQL_TOKEN_DECLARE = 58,         /* SQL_TOKEN_DECLARE  */
  YYSYMBOL_SQL_TOKEN_DEFAULT = 59,         /* SQL_TOKEN_DEFAULT  */
  YYSYMBOL_SQL_TOKEN_DELETE = 60,          /* SQL_TOKEN_DELETE  */
  YYSYMBOL_SQL_TOKEN_DESC = 61,            /* SQL_TOKEN_DESC  */
  YYSYMBOL_SQL_TOKEN_DISTINCT = 62,        /* SQL_TOKEN_DISTINCT  */
  YYSYMBOL_SQL_TOKEN_DOUBLE = 63,          /* SQL_TOKEN_DOUBLE  */
  YYSYMBOL_SQL_TOKEN_DROP = 64,            /* SQL_TOKEN_DROP  */
  YYSYMBOL_SQL_TOKEN_ESCAPE = 65,          /* SQL_TOKEN_ESCAPE  */
  YYSYMBOL_SQL_TOKEN_EXCEPT = 66,          /* SQL_TOKEN_EXCEPT  */
  YYSYMBOL_SQL_TOKEN_EXISTS = 67,          /* SQL_TOKEN_EXISTS  */
  YYSYMBOL_SQL_TOKEN_FALSE = 68,           /* SQL_TOKEN_FALSE  */
  YYSYMBOL_SQL_TOKEN_FETCH = 69,           /* SQL_TOKEN_FETCH  */
  YYSYMBOL_SQL_TOKEN_FLOAT = 70,           /* SQL_TOKEN_FLOAT  */
  YYSYMBOL_SQL_TOKEN_FOR = 71,             /* SQL_TOKEN_FOR  */
  YYSYMBOL_SQL_TOKEN_FOREIGN = 72,         /* SQL_TOKEN_FOREIGN  */
  YYSYMBOL_SQL_TOKEN_FOUND = 73,           /* SQL_TOKEN_FOUND  */
  YYSYMBOL_SQL_TOKEN_FROM = 74,            /* SQL_TOKEN_FROM  */
  YYSYMBOL_SQL_TOKEN_FULL = 75,            /* SQL_TOKEN_FULL  */
  YYSYMBOL_SQL_TOKEN_GRANT = 76,           /* SQL_TOKEN_GRANT  */
  YYSYMBOL_SQL_TOKEN_GROUP = 77,           /* SQL_TOKEN_GROUP  */
  YYSYMBOL_SQL_TOKEN_HAVING = 78,          /* SQL_TOKEN_HAVING  */
  YYSYMBOL_SQL_TOKEN_IN = 79,              /* SQL_TOKEN_IN  */
  YYSYMBOL_SQL_TOKEN_INDICATOR = 80,       /* SQL_TOKEN_INDICATOR  */
  YYSYMBOL_SQL_TOKEN_INNER = 81,           /* SQL_TOKEN_INNER  */
  YYSYMBOL_SQL_TOKEN_INTEGER = 82,         /* SQL_TOKEN_INTEGER  */
  YYSYMBOL_SQL_TOKEN_INTO = 83,            /* SQL_TOKEN_INTO  */
  YYSYMBOL_SQL_TOKEN_IS = 84,              /* SQL_TOKEN_IS  */
  YYSYMBOL_SQL_TOKEN_INTERSECT = 85,       /* SQL_TOKEN_INTERSECT  */
  YYSYMBOL_SQL_TOKEN_JOIN = 86,            /* SQL_TOKEN_JOIN  */
  YYSYMBOL_SQL_TOKEN_KEY = 87,             /* SQL_TOKEN_KEY  */
  YYSYMBOL_SQL_TOKEN_LEADING = 88,         /* SQL_TOKEN_LEADING  */
  YYSYMBOL_SQL_TOKEN_LIKE = 89,            /* SQL_TOKEN_LIKE  */
  YYSYMBOL_SQL_TOKEN_LOCAL = 90,           /* SQL_TOKEN_LOCAL  */
  YYSYMBOL_SQL_TOKEN_LOWER = 91,           /* SQL_TOKEN_LOWER  */
  YYSYMBOL_SQL_TOKEN_MAX = 92,             /* SQL_TOKEN_MAX  */
  YYSYMBOL_SQL_TOKEN_MIN = 93,             /* SQL_TOKEN_MIN  */
  YYSYMBOL_SQL_TOKEN_NATURAL = 94,         /* SQL_TOKEN_NATURAL  */
  YYSYMBOL_SQL_TOKEN_NCHAR = 95,           /* SQL_TOKEN_NCHAR  */
  YYSYMBOL_SQL_TOKEN_NULL = 96,            /* SQL_TOKEN_NULL  */
  YYSYMBOL_SQL_TOKEN_NUMERIC = 97,         /* SQL_TOKEN_NUMERIC  */
  YYSYMBOL_SQL_TOKEN_OCTET_LENGTH = 98,    /* SQL_TOKEN_OCTET_LENGTH  */
  YYSYMBOL_SQL_TOKEN_OF = 99,              /* SQL_TOKEN_OF  */
  YYSYMBOL_SQL_TOKEN_ON = 100,             /* SQL_TOKEN_ON  */
  YYSYMBOL_SQL_TOKEN_OPTION = 101,         /* SQL_TOKEN_OPTION  */
  YYSYMBOL_SQL_TOKEN_ORDER = 102,          /* SQL_TOKEN_ORDER  */
  YYSYMBOL_SQL_TOKEN_OUTER = 103,          /* SQL_TOKEN_OUTER  */
  YYSYMBOL_SQL_TOKEN_PRECISION = 104,      /* SQL_TOKEN_PRECISION  */
  YYSYMBOL_SQL_TOKEN_PRIMARY = 105,        /* SQL_TOKEN_PRIMARY  */
  YYSYMBOL_SQL_TOKEN_PRIVILEGES = 106,     /* SQL_TOKEN_PRIVILEGES  */
  YYSYMBOL_SQL_TOKEN_PROCEDURE = 107,      /* SQL_TOKEN_PROCEDURE  */
  YYSYMBOL_SQL_TOKEN_PUBLIC = 108,         /* SQL_TOKEN_PUBLIC  */
  YYSYMBOL_SQL_TOKEN_REAL = 109,           /* SQL_TOKEN_REAL  */
  YYSYMBOL_SQL_TOKEN_REFERENCES = 110,     /* SQL_TOKEN_REFERENCES  */
  YYSYMBOL_SQL_TOKEN_ROLLBACK = 111,       /* SQL_TOKEN_ROLLBACK  */
  YYSYMBOL_SQL_TOKEN_SCHEMA = 112,         /* SQL_TOKEN_SCHEMA  */
  YYSYMBOL_SQL_TOKEN_SELECT = 113,         /* SQL_TOKEN_SELECT  */
  YYSYMBOL_SQL_TOKEN_SET = 114,            /* SQL_TOKEN_SET  */
  YYSYMBOL_SQL_TOKEN_SIZE = 115,           /* SQL_TOKEN_SIZE  */
  YYSYMBOL_SQL_TOKEN_SMALLINT = 116,       /* SQL_TOKEN_SMALLINT  */
  YYSYMBOL_SQL_TOKEN_SOME = 117,           /* SQL_TOKEN_SOME  */
  YYSYMBOL_SQL_TOKEN_SQLCODE = 118,        /* SQL_TOKEN_SQLCODE  */
  YYSYMBOL_SQL_TOKEN_SQLERROR = 119,       /* SQL_TOKEN_SQLERROR  */
  YYSYMBOL_SQL_TOKEN_SUM = 120,            /* SQL_TOKEN_SUM  */
  YYSYMBOL_SQL_TOKEN_TABLE = 121,          /* SQL_TOKEN_TABLE  */
  YYSYMBOL_SQL_TOKEN_TIME = 122,           /* SQL_TOKEN_TIME  */
  YYSYMBOL_SQL_TOKEN_TIMESTAMP = 123,      /* SQL_TOKEN_TIMESTAMP  */
  YYSYMBOL_SQL_TOKEN_TIMEZONE_HOUR = 124,  /* SQL_TOKEN_TIMEZONE_HOUR  */
  YYSYMBOL_SQL_TOKEN_TIMEZONE_MINUTE = 125, /* SQL_TOKEN_TIMEZONE_MINUTE  */
  YYSYMBOL_SQL_TOKEN_TO = 126,             /* SQL_TOKEN_TO  */
  YYSYMBOL_SQL_TOKEN_TRAILING = 127,       /* SQL_TOKEN_TRAILING  */
  YYSYMBOL_SQL_TOKEN_TRANSLATE = 128,      /* SQL_TOKEN_TRANSLATE  */
  YYSYMBOL_SQL_TOKEN_TRIM = 129,           /* SQL_TOKEN_TRIM  */
  YYSYMBOL_SQL_TOKEN_TRUE = 130,           /* SQL_TOKEN_TRUE  */
  YYSYMBOL_SQL_TOKEN_UNION = 131,          /* SQL_TOKEN_UNION  */
  YYSYMBOL_SQL_TOKEN_UNIQUE = 132,         /* SQL_TOKEN_UNIQUE  */
  YYSYMBOL_SQL_TOKEN_UNKNOWN = 133,        /* SQL_TOKEN_UNKNOWN  */
  YYSYMBOL_SQL_TOKEN_UPDATE = 134,         /* SQL_TOKEN_UPDATE  */
  YYSYMBOL_SQL_TOKEN_UPPER = 135,          /* SQL_TOKEN_UPPER  */
  YYSYMBOL_SQL_TOKEN_USAGE = 136,          /* SQL_TOKEN_USAGE  */
  YYSYMBOL_SQL_TOKEN_USER = 137,           /* SQL_TOKEN_USER  */
  YYSYMBOL_SQL_TOKEN_USING = 138,          /* SQL_TOKEN_USING  */
  YYSYMBOL_SQL_TOKEN_VALUES = 139,         /* SQL_TOKEN_VALUES  */
  YYSYMBOL_SQL_TOKEN_VIEW = 140,           /* SQL_TOKEN_VIEW  */
  YYSYMBOL_SQL_TOKEN_WHERE = 141,          /* SQL_TOKEN_WHERE  */
  YYSYMBOL_SQL_TOKEN_WITH = 142,           /* SQL_TOKEN_WITH  */
  YYSYMBOL_SQL_TOKEN_WORK = 143,           /* SQL_TOKEN_WORK  */
  YYSYMBOL_SQL_TOKEN_ZONE = 144,           /* SQL_TOKEN_ZONE  */
  YYSYMBOL_SQL_TOKEN_CALL = 145,           /* SQL_TOKEN_CALL  */
  YYSYMBOL_SQL_TOKEN_D = 146,              /* SQL_TOKEN_D  */
  YYSYMBOL_SQL_TOKEN_FN = 147,             /* SQL_TOKEN_FN  */
  YYSYMBOL_SQL_TOKEN_T = 148,              /* SQL_TOKEN_T  */
  YYSYMBOL_SQL_TOKEN_TS = 149,             /* SQL_TOKEN_TS  */
  YYSYMBOL_SQL_TOKEN_OJ = 150,             /* SQL_TOKEN_OJ  */
  YYSYMBOL_SQL_TOKEN_ASCII = 151,          /* SQL_TOKEN_ASCII  */
  YYSYMBOL_SQL_TOKEN_BIT_LENGTH = 152,     /* SQL_TOKEN_BIT_LENGTH  */
  YYSYMBOL_SQL_TOKEN_CHAR = 153,           /* SQL_TOKEN_CHAR  */
  YYSYMBOL_SQL_TOKEN_CHAR_LENGTH = 154,    /* SQL_TOKEN_CHAR_LENGTH  */
  YYSYMBOL_SQL_TOKEN_SQL_TOKEN_INTNUM = 155, /* SQL_TOKEN_SQL_TOKEN_INTNUM  */
  YYSYMBOL_SQL_TOKEN_CONCAT = 156,         /* SQL_TOKEN_CONCAT  */
  YYSYMBOL_SQL_TOKEN_DIFFERENCE = 157,     /* SQL_TOKEN_DIFFERENCE  */
  YYSYMBOL_SQL_TOKEN_INSERT = 158,         /* SQL_TOKEN_INSERT  */
  YYSYMBOL_SQL_TOKEN_LCASE = 159,          /* SQL_TOKEN_LCASE  */
  YYSYMBOL_SQL_TOKEN_LEFT = 160,           /* SQL_TOKEN_LEFT  */
  YYSYMBOL_SQL_TOKEN_LENGTH = 161,         /* SQL_TOKEN_LENGTH  */
  YYSYMBOL_SQL_TOKEN_LOCATE = 162,         /* SQL_TOKEN_LOCATE  */
  YYSYMBOL_SQL_TOKEN_LOCATE_2 = 163,       /* SQL_TOKEN_LOCATE_2  */
  YYSYMBOL_SQL_TOKEN_LTRIM = 164,          /* SQL_TOKEN_LTRIM  */
  YYSYMBOL_SQL_TOKEN_POSITION = 165,       /* SQL_TOKEN_POSITION  */
  YYSYMBOL_SQL_TOKEN_REPEAT = 166,         /* SQL_TOKEN_REPEAT  */
  YYSYMBOL_SQL_TOKEN_REPLACE = 167,        /* SQL_TOKEN_REPLACE  */
  YYSYMBOL_SQL_TOKEN_RIGHT = 168,          /* SQL_TOKEN_RIGHT  */
  YYSYMBOL_SQL_TOKEN_RTRIM = 169,          /* SQL_TOKEN_RTRIM  */
  YYSYMBOL_SQL_TOKEN_SOUNDEX = 170,        /* SQL_TOKEN_SOUNDEX  */
  YYSYMBOL_SQL_TOKEN_SPACE = 171,          /* SQL_TOKEN_SPACE  */
  YYSYMBOL_SQL_TOKEN_SUBSTRING = 172,      /* SQL_TOKEN_SUBSTRING  */
  YYSYMBOL_SQL_TOKEN_UCASE = 173,          /* SQL_TOKEN_UCASE  */
  YYSYMBOL_SQL_TOKEN_CURRENT_DATE = 174,   /* SQL_TOKEN_CURRENT_DATE  */
  YYSYMBOL_SQL_TOKEN_CURRENT_TIME = 175,   /* SQL_TOKEN_CURRENT_TIME  */
  YYSYMBOL_SQL_TOKEN_CURRENT_TIMESTAMP = 176, /* SQL_TOKEN_CURRENT_TIMESTAMP  */
  YYSYMBOL_SQL_TOKEN_CURDATE = 177,        /* SQL_TOKEN_CURDATE  */
  YYSYMBOL_SQL_TOKEN_CURTIME = 178,        /* SQL_TOKEN_CURTIME  */
  YYSYMBOL_SQL_TOKEN_DAYNAME = 179,        /* SQL_TOKEN_DAYNAME  */
  YYSYMBOL_SQL_TOKEN_DAYOFMONTH = 180,     /* SQL_TOKEN_DAYOFMONTH  */
  YYSYMBOL_SQL_TOKEN_DAYOFWEEK = 181,      /* SQL_TOKEN_DAYOFWEEK  */
  YYSYMBOL_SQL_TOKEN_DAYOFYEAR = 182,      /* SQL_TOKEN_DAYOFYEAR  */
  YYSYMBOL_SQL_TOKEN_EXTRACT = 183,        /* SQL_TOKEN_EXTRACT  */
  YYSYMBOL_SQL_TOKEN_HOUR = 184,           /* SQL_TOKEN_HOUR  */
  YYSYMBOL_SQL_TOKEN_MILLISECOND = 185,    /* SQL_TOKEN_MILLISECOND  */
  YYSYMBOL_SQL_TOKEN_MINUTE = 186,         /* SQL_TOKEN_MINUTE  */
  YYSYMBOL_SQL_TOKEN_MONTH = 187,          /* SQL_TOKEN_MONTH  */
  YYSYMBOL_SQL_TOKEN_MONTHNAME = 188,      /* SQL_TOKEN_MONTHNAME  */
  YYSYMBOL_SQL_TOKEN_NOW = 189,            /* SQL_TOKEN_NOW  */
  YYSYMBOL_SQL_TOKEN_QUARTER = 190,        /* SQL_TOKEN_QUARTER  */
  YYSYMBOL_SQL_TOKEN_DATEDIFF = 191,       /* SQL_TOKEN_DATEDIFF  */
  YYSYMBOL_SQL_TOKEN_SECOND = 192,         /* SQL_TOKEN_SECOND  */
  YYSYMBOL_SQL_TOKEN_TIMESTAMPADD = 193,   /* SQL_TOKEN_TIMESTAMPADD  */
  YYSYMBOL_SQL_TOKEN_TIMESTAMPDIFF = 194,  /* SQL_TOKEN_TIMESTAMPDIFF  */
  YYSYMBOL_SQL_TOKEN_TIMEVALUE = 195,      /* SQL_TOKEN_TIMEVALUE  */
  YYSYMBOL_SQL_TOKEN_WEEK = 196,           /* SQL_TOKEN_WEEK  */
  YYSYMBOL_SQL_TOKEN_WEEKDAY = 197,        /* SQL_TOKEN_WEEKDAY  */
  YYSYMBOL_SQL_TOKEN_YEAR = 198,           /* SQL_TOKEN_YEAR  */
  YYSYMBOL_SQL_TOKEN_YEARDAY = 199,        /* SQL_TOKEN_YEARDAY  */
  YYSYMBOL_SQL_TOKEN_DATEADD = 200,        /* SQL_TOKEN_DATEADD  */
  YYSYMBOL_SQL_TOKEN_ABS = 201,            /* SQL_TOKEN_ABS  */
  YYSYMBOL_SQL_TOKEN_ACOS = 202,           /* SQL_TOKEN_ACOS  */
  YYSYMBOL_SQL_TOKEN_ASIN = 203,           /* SQL_TOKEN_ASIN  */
  YYSYMBOL_SQL_TOKEN_ATAN = 204,           /* SQL_TOKEN_ATAN  */
  YYSYMBOL_SQL_TOKEN_ATAN2 = 205,          /* SQL_TOKEN_ATAN2  */
  YYSYMBOL_SQL_TOKEN_CEILING = 206,        /* SQL_TOKEN_CEILING  */
  YYSYMBOL_SQL_TOKEN_COS = 207,            /* SQL_TOKEN_COS  */
  YYSYMBOL_SQL_TOKEN_COT = 208,            /* SQL_TOKEN_COT  */
  YYSYMBOL_SQL_TOKEN_DEGREES = 209,        /* SQL_TOKEN_DEGREES  */
  YYSYMBOL_SQL_TOKEN_EXP = 210,            /* SQL_TOKEN_EXP  */
  YYSYMBOL_SQL_TOKEN_FLOOR = 211,          /* SQL_TOKEN_FLOOR  */
  YYSYMBOL_SQL_TOKEN_LOGF = 212,           /* SQL_TOKEN_LOGF  */
  YYSYMBOL_SQL_TOKEN_LOG = 213,            /* SQL_TOKEN_LOG  */
  YYSYMBOL_SQL_TOKEN_LN = 214,             /* SQL_TOKEN_LN  */
  YYSYMBOL_SQL_TOKEN_LOG10 = 215,          /* SQL_TOKEN_LOG10  */
  YYSYMBOL_SQL_TOKEN_MOD = 216,            /* SQL_TOKEN_MOD  */
  YYSYMBOL_SQL_TOKEN_PI = 217,             /* SQL_TOKEN_PI  */
  YYSYMBOL_SQL_TOKEN_POWER = 218,          /* SQL_TOKEN_POWER  */
  YYSYMBOL_SQL_TOKEN_RADIANS = 219,        /* SQL_TOKEN_RADIANS  */
  YYSYMBOL_SQL_TOKEN_RAND = 220,           /* SQL_TOKEN_RAND  */
  YYSYMBOL_SQL_TOKEN_ROUNDMAGIC = 221,     /* SQL_TOKEN_ROUNDMAGIC  */
  YYSYMBOL_SQL_TOKEN_ROUND = 222,          /* SQL_TOKEN_ROUND  */
  YYSYMBOL_SQL_TOKEN_SIGN = 223,           /* SQL_TOKEN_SIGN  */
  YYSYMBOL_SQL_TOKEN_SIN = 224,            /* SQL_TOKEN_SIN  */
  YYSYMBOL_SQL_TOKEN_SQRT = 225,           /* SQL_TOKEN_SQRT  */
  YYSYMBOL_SQL_TOKEN_TAN = 226,            /* SQL_TOKEN_TAN  */
  YYSYMBOL_SQL_TOKEN_TRUNCATE = 227,       /* SQL_TOKEN_TRUNCATE  */
  YYSYMBOL_SQL_TOKEN_EVERY = 228,          /* SQL_TOKEN_EVERY  */
  YYSYMBOL_SQL_TOKEN_INTERSECTION = 229,   /* SQL_TOKEN_INTERSECTION  */
  YYSYMBOL_SQL_TOKEN_FUSION = 230,         /* SQL_TOKEN_FUSION  */
  YYSYMBOL_SQL_TOKEN_COLLECT = 231,        /* SQL_TOKEN_COLLECT  */
  YYSYMBOL_SQL_TOKEN_VAR_POP = 232,        /* SQL_TOKEN_VAR_POP  */
  YYSYMBOL_SQL_TOKEN_VAR_SAMP = 233,       /* SQL_TOKEN_VAR_SAMP  */
  YYSYMBOL_SQL_TOKEN_STDDEV_SAMP = 234,    /* SQL_TOKEN_STDDEV_SAMP  */
  YYSYMBOL_SQL_TOKEN_STDDEV_POP = 235,     /* SQL_TOKEN_STDDEV_POP  */
  YYSYMBOL_SQL_TOKEN_RANK = 236,           /* SQL_TOKEN_RANK  */
  YYSYMBOL_SQL_TOKEN_DENSE_RANK = 237,     /* SQL_TOKEN_DENSE_RANK  */
  YYSYMBOL_SQL_TOKEN_PERCENT_RANK = 238,   /* SQL_TOKEN_PERCENT_RANK  */
  YYSYMBOL_SQL_TOKEN_CUME_DIST = 239,      /* SQL_TOKEN_CUME_DIST  */
  YYSYMBOL_SQL_TOKEN_PERCENTILE_CONT = 240, /* SQL_TOKEN_PERCENTILE_CONT  */
  YYSYMBOL_SQL_TOKEN_PERCENTILE_DISC = 241, /* SQL_TOKEN_PERCENTILE_DISC  */
  YYSYMBOL_SQL_TOKEN_WITHIN = 242,         /* SQL_TOKEN_WITHIN  */
  YYSYMBOL_SQL_TOKEN_ARRAY_AGG = 243,      /* SQL_TOKEN_ARRAY_AGG  */
  YYSYMBOL_SQL_TOKEN_CASE = 244,           /* SQL_TOKEN_CASE  */
  YYSYMBOL_SQL_TOKEN_THEN = 245,           /* SQL_TOKEN_THEN  */
  YYSYMBOL_SQL_TOKEN_END = 246,            /* SQL_TOKEN_END  */
  YYSYMBOL_SQL_TOKEN_NULLIF = 247,         /* SQL_TOKEN_NULLIF  */
  YYSYMBOL_SQL_TOKEN_COALESCE = 248,       /* SQL_TOKEN_COALESCE  */
  YYSYMBOL_SQL_TOKEN_WHEN = 249,           /* SQL_TOKEN_WHEN  */
  YYSYMBOL_SQL_TOKEN_ELSE = 250,           /* SQL_TOKEN_ELSE  */
  YYSYMBOL_SQL_TOKEN_BEFORE = 251,         /* SQL_TOKEN_BEFORE  */
  YYSYMBOL_SQL_TOKEN_AFTER = 252,          /* SQL_TOKEN_AFTER  */
  YYSYMBOL_SQL_TOKEN_INSTEAD = 253,        /* SQL_TOKEN_INSTEAD  */
  YYSYMBOL_SQL_TOKEN_EACH = 254,           /* SQL_TOKEN_EACH  */
  YYSYMBOL_SQL_TOKEN_REFERENCING = 255,    /* SQL_TOKEN_REFERENCING  */
  YYSYMBOL_SQL_TOKEN_BEGIN = 256,          /* SQL_TOKEN_BEGIN  */
  YYSYMBOL_SQL_TOKEN_ATOMIC = 257,         /* SQL_TOKEN_ATOMIC  */
  YYSYMBOL_SQL_TOKEN_TRIGGER = 258,        /* SQL_TOKEN_TRIGGER  */
  YYSYMBOL_SQL_TOKEN_ROW = 259,            /* SQL_TOKEN_ROW  */
  YYSYMBOL_SQL_TOKEN_STATEMENT = 260,      /* SQL_TOKEN_STATEMENT  */
  YYSYMBOL_SQL_TOKEN_NEW = 261,            /* SQL_TOKEN_NEW  */
  YYSYMBOL_SQL_TOKEN_OLD = 262,            /* SQL_TOKEN_OLD  */
  YYSYMBOL_SQL_TOKEN_VALUE = 263,          /* SQL_TOKEN_VALUE  */
  YYSYMBOL_SQL_TOKEN_CURRENT_CATALOG = 264, /* SQL_TOKEN_CURRENT_CATALOG  */
  YYSYMBOL_SQL_TOKEN_CURRENT_DEFAULT_TRANSFORM_GROUP = 265, /* SQL_TOKEN_CURRENT_DEFAULT_TRANSFORM_GROUP  */
  YYSYMBOL_SQL_TOKEN_CURRENT_PATH = 266,   /* SQL_TOKEN_CURRENT_PATH  */
  YYSYMBOL_SQL_TOKEN_CURRENT_ROLE = 267,   /* SQL_TOKEN_CURRENT_ROLE  */
  YYSYMBOL_SQL_TOKEN_CURRENT_SCHEMA = 268, /* SQL_TOKEN_CURRENT_SCHEMA  */
  YYSYMBOL_SQL_TOKEN_CURRENT_USER = 269,   /* SQL_TOKEN_CURRENT_USER  */
  YYSYMBOL_SQL_TOKEN_SESSION_USER = 270,   /* SQL_TOKEN_SESSION_USER  */
  YYSYMBOL_SQL_TOKEN_SYSTEM_USER = 271,    /* SQL_TOKEN_SYSTEM_USER  */
  YYSYMBOL_SQL_TOKEN_VARCHAR = 272,        /* SQL_TOKEN_VARCHAR  */
  YYSYMBOL_SQL_TOKEN_VARBINARY = 273,      /* SQL_TOKEN_VARBINARY  */
  YYSYMBOL_SQL_TOKEN_VARYING = 274,        /* SQL_TOKEN_VARYING  */
  YYSYMBOL_SQL_TOKEN_OBJECT = 275,         /* SQL_TOKEN_OBJECT  */
  YYSYMBOL_SQL_TOKEN_NCLOB = 276,          /* SQL_TOKEN_NCLOB  */
  YYSYMBOL_SQL_TOKEN_NATIONAL = 277,       /* SQL_TOKEN_NATIONAL  */
  YYSYMBOL_SQL_TOKEN_LARGE = 278,          /* SQL_TOKEN_LARGE  */
  YYSYMBOL_SQL_TOKEN_CLOB = 279,           /* SQL_TOKEN_CLOB  */
  YYSYMBOL_SQL_TOKEN_BLOB = 280,           /* SQL_TOKEN_BLOB  */
  YYSYMBOL_SQL_TOKEN_BIGINT = 281,         /* SQL_TOKEN_BIGINT  */
  YYSYMBOL_SQL_TOKEN_BINARY = 282,         /* SQL_TOKEN_BINARY  */
  YYSYMBOL_SQL_TOKEN_WITHOUT = 283,        /* SQL_TOKEN_WITHOUT  */
  YYSYMBOL_SQL_TOKEN_BOOLEAN = 284,        /* SQL_TOKEN_BOOLEAN  */
  YYSYMBOL_SQL_TOKEN_INTERVAL = 285,       /* SQL_TOKEN_INTERVAL  */
  YYSYMBOL_SQL_TOKEN_OVER = 286,           /* SQL_TOKEN_OVER  */
  YYSYMBOL_SQL_TOKEN_ROW_NUMBER = 287,     /* SQL_TOKEN_ROW_NUMBER  */
  YYSYMBOL_SQL_TOKEN_NTILE = 288,          /* SQL_TOKEN_NTILE  */
  YYSYMBOL_SQL_TOKEN_LEAD = 289,           /* SQL_TOKEN_LEAD  */
  YYSYMBOL_SQL_TOKEN_LAG = 290,            /* SQL_TOKEN_LAG  */
  YYSYMBOL_SQL_TOKEN_RESPECT = 291,        /* SQL_TOKEN_RESPECT  */
  YYSYMBOL_SQL_TOKEN_IGNORE = 292,         /* SQL_TOKEN_IGNORE  */
  YYSYMBOL_SQL_TOKEN_NULLS = 293,          /* SQL_TOKEN_NULLS  */
  YYSYMBOL_SQL_TOKEN_FIRST_VALUE = 294,    /* SQL_TOKEN_FIRST_VALUE  */
  YYSYMBOL_SQL_TOKEN_LAST_VALUE = 295,     /* SQL_TOKEN_LAST_VALUE  */
  YYSYMBOL_SQL_TOKEN_NTH_VALUE = 296,      /* SQL_TOKEN_NTH_VALUE  */
  YYSYMBOL_SQL_TOKEN_FIRST = 297,          /* SQL_TOKEN_FIRST  */
  YYSYMBOL_SQL_TOKEN_LAST = 298,           /* SQL_TOKEN_LAST  */
  YYSYMBOL_SQL_TOKEN_EXCLUDE = 299,        /* SQL_TOKEN_EXCLUDE  */
  YYSYMBOL_SQL_TOKEN_OTHERS = 300,         /* SQL_TOKEN_OTHERS  */
  YYSYMBOL_SQL_TOKEN_TIES = 301,           /* SQL_TOKEN_TIES  */
  YYSYMBOL_SQL_TOKEN_FOLLOWING = 302,      /* SQL_TOKEN_FOLLOWING  */
  YYSYMBOL_SQL_TOKEN_UNBOUNDED = 303,      /* SQL_TOKEN_UNBOUNDED  */
  YYSYMBOL_SQL_TOKEN_PRECEDING = 304,      /* SQL_TOKEN_PRECEDING  */
  YYSYMBOL_SQL_TOKEN_RANGE = 305,          /* SQL_TOKEN_RANGE  */
  YYSYMBOL_SQL_TOKEN_ROWS = 306,           /* SQL_TOKEN_ROWS  */
  YYSYMBOL_SQL_TOKEN_PARTITION = 307,      /* SQL_TOKEN_PARTITION  */
  YYSYMBOL_SQL_TOKEN_WINDOW = 308,         /* SQL_TOKEN_WINDOW  */
  YYSYMBOL_SQL_TOKEN_NO = 309,             /* SQL_TOKEN_NO  */
  YYSYMBOL_SQL_TOKEN_LIMIT = 310,          /* SQL_TOKEN_LIMIT  */
  YYSYMBOL_SQL_TOKEN_OFFSET = 311,         /* SQL_TOKEN_OFFSET  */
  YYSYMBOL_SQL_TOKEN_NEXT = 312,           /* SQL_TOKEN_NEXT  */
  YYSYMBOL_SQL_TOKEN_ONLY = 313,           /* SQL_TOKEN_ONLY  */
  YYSYMBOL_SQL_TOKEN_OR = 314,             /* SQL_TOKEN_OR  */
  YYSYMBOL_SQL_TOKEN_AND = 315,            /* SQL_TOKEN_AND  */
  YYSYMBOL_SQL_LESSEQ = 316,               /* SQL_LESSEQ  */
  YYSYMBOL_SQL_GREATEQ = 317,              /* SQL_GREATEQ  */
  YYSYMBOL_SQL_NOTEQUAL = 318,             /* SQL_NOTEQUAL  */
  YYSYMBOL_SQL_LESS = 319,                 /* SQL_LESS  */
  YYSYMBOL_SQL_GREAT = 320,                /* SQL_GREAT  */
  YYSYMBOL_SQL_EQUAL = 321,                /* SQL_EQUAL  */
  YYSYMBOL_322_ = 322,                     /* '+'  */
  YYSYMBOL_323_ = 323,                     /* '-'  */
  YYSYMBOL_SQL_CONCAT = 324,               /* SQL_CONCAT  */
  YYSYMBOL_325_ = 325,                     /* '*'  */
  YYSYMBOL_326_ = 326,                     /* '/'  */
  YYSYMBOL_327_ = 327,                     /* '='  */
  YYSYMBOL_SQL_TOKEN_INVALIDSYMBOL = 328,  /* SQL_TOKEN_INVALIDSYMBOL  */
  YYSYMBOL_YYACCEPT = 329,                 /* $accept  */
  YYSYMBOL_sql_single_statement = 330,     /* sql_single_statement  */
  YYSYMBOL_sql = 331,                      /* sql  */
  YYSYMBOL_schema_element = 332,           /* schema_element  */
  YYSYMBOL_base_table_def = 333,           /* base_table_def  */
  YYSYMBOL_base_table_element_commalist = 334, /* base_table_element_commalist  */
  YYSYMBOL_base_table_element = 335,       /* base_table_element  */
  YYSYMBOL_column_def = 336,               /* column_def  */
  YYSYMBOL_column_def_opt_list = 337,      /* column_def_opt_list  */
  YYSYMBOL_nil_fkt = 338,                  /* nil_fkt  */
  YYSYMBOL_unique_spec = 339,              /* unique_spec  */
  YYSYMBOL_column_def_opt = 340,           /* column_def_opt  */
  YYSYMBOL_table_constraint_def = 341,     /* table_constraint_def  */
  YYSYMBOL_op_column_commalist = 342,      /* op_column_commalist  */
  YYSYMBOL_column_commalist = 343,         /* column_commalist  */
  YYSYMBOL_view_def = 344,                 /* view_def  */
  YYSYMBOL_opt_with_check_option = 345,    /* opt_with_check_option  */
  YYSYMBOL_opt_column_commalist = 346,     /* opt_column_commalist  */
  YYSYMBOL_privilege_def = 347,            /* privilege_def  */
  YYSYMBOL_opt_with_grant_option = 348,    /* opt_with_grant_option  */
  YYSYMBOL_privileges = 349,               /* privileges  */
  YYSYMBOL_operation_commalist = 350,      /* operation_commalist  */
  YYSYMBOL_operation = 351,                /* operation  */
  YYSYMBOL_grantee_commalist = 352,        /* grantee_commalist  */
  YYSYMBOL_grantee = 353,                  /* grantee  */
  YYSYMBOL_opt_order_by_clause = 354,      /* opt_order_by_clause  */
  YYSYMBOL_ordering_spec_commalist = 355,  /* ordering_spec_commalist  */
  YYSYMBOL_ordering_spec = 356,            /* ordering_spec  */
  YYSYMBOL_opt_asc_desc = 357,             /* opt_asc_desc  */
  YYSYMBOL_sql_not = 358,                  /* sql_not  */
  YYSYMBOL_manipulative_statement = 359,   /* manipulative_statement  */
  YYSYMBOL_union_statement = 360,          /* union_statement  */
  YYSYMBOL_commit_statement = 361,         /* commit_statement  */
  YYSYMBOL_delete_statement_searched = 362, /* delete_statement_searched  */
  YYSYMBOL_fetch_statement = 363,          /* fetch_statement  */
  YYSYMBOL_insert_statement = 364,         /* insert_statement  */
  YYSYMBOL_values_or_query_spec = 365,     /* values_or_query_spec  */
  YYSYMBOL_table_value_const_list = 366,   /* table_value_const_list  */
  YYSYMBOL_row_value_constructor = 367,    /* row_value_constructor  */
  YYSYMBOL_row_value_constructor_elem = 368, /* row_value_constructor_elem  */
  YYSYMBOL_rollback_statement = 369,       /* rollback_statement  */
  YYSYMBOL_select_statement_into = 370,    /* select_statement_into  */
  YYSYMBOL_opt_all_distinct = 371,         /* opt_all_distinct  */
  YYSYMBOL_assignment_commalist = 372,     /* assignment_commalist  */
  YYSYMBOL_assignment = 373,               /* assignment  */
  YYSYMBOL_update_source = 374,            /* update_source  */
  YYSYMBOL_update_statement_searched = 375, /* update_statement_searched  */
  YYSYMBOL_target_commalist = 376,         /* target_commalist  */
  YYSYMBOL_target = 377,                   /* target  */
  YYSYMBOL_opt_where_clause = 378,         /* opt_where_clause  */
  YYSYMBOL_query_term = 379,               /* query_term  */
  YYSYMBOL_select_statement = 380,         /* select_statement  */
  YYSYMBOL_selection = 381,                /* selection  */
  YYSYMBOL_opt_result_offset_clause = 382, /* opt_result_offset_clause  */
  YYSYMBOL_result_offset_clause = 383,     /* result_offset_clause  */
  YYSYMBOL_opt_fetch_first_row_count = 384, /* opt_fetch_first_row_count  */
  YYSYMBOL_first_or_next = 385,            /* first_or_next  */
  YYSYMBOL_row_or_rows = 386,              /* row_or_rows  */
  YYSYMBOL_opt_fetch_first_clause = 387,   /* opt_fetch_first_clause  */
  YYSYMBOL_fetch_first_clause = 388,       /* fetch_first_clause  */
  YYSYMBOL_offset_row_count = 389,         /* offset_row_count  */
  YYSYMBOL_fetch_first_row_count = 390,    /* fetch_first_row_count  */
  YYSYMBOL_opt_limit_offset_clause = 391,  /* opt_limit_offset_clause  */
  YYSYMBOL_opt_offset = 392,               /* opt_offset  */
  YYSYMBOL_limit_offset_clause = 393,      /* limit_offset_clause  */
  YYSYMBOL_table_exp = 394,                /* table_exp  */
  YYSYMBOL_from_clause = 395,              /* from_clause  */
  YYSYMBOL_table_ref_commalist = 396,      /* table_ref_commalist  */
  YYSYMBOL_opt_as = 397,                   /* opt_as  */
  YYSYMBOL_opt_row = 398,                  /* opt_row  */
  YYSYMBOL_table_primary_as_range_column = 399, /* table_primary_as_range_column  */
  YYSYMBOL_table_ref = 400,                /* table_ref  */
  YYSYMBOL_where_clause = 401,             /* where_clause  */
  YYSYMBOL_opt_group_by_clause = 402,      /* opt_group_by_clause  */
  YYSYMBOL_column_ref_commalist = 403,     /* column_ref_commalist  */
  YYSYMBOL_opt_having_clause = 404,        /* opt_having_clause  */
  YYSYMBOL_boolean_primary = 405,          /* boolean_primary  */
  YYSYMBOL_parenthesized_boolean_value_expression = 406, /* parenthesized_boolean_value_expression  */
  YYSYMBOL_boolean_factor = 407,           /* boolean_factor  */
  YYSYMBOL_boolean_term = 408,             /* boolean_term  */
  YYSYMBOL_search_condition = 409,         /* search_condition  */
  YYSYMBOL_predicate = 410,                /* predicate  */
  YYSYMBOL_comparison_predicate_part_2 = 411, /* comparison_predicate_part_2  */
  YYSYMBOL_comparison_predicate = 412,     /* comparison_predicate  */
  YYSYMBOL_comparison = 413,               /* comparison  */
  YYSYMBOL_between_predicate_part_2 = 414, /* between_predicate_part_2  */
  YYSYMBOL_between_predicate = 415,        /* between_predicate  */
  YYSYMBOL_character_like_predicate_part_2 = 416, /* character_like_predicate_part_2  */
  YYSYMBOL_other_like_predicate_part_2 = 417, /* other_like_predicate_part_2  */
  YYSYMBOL_like_predicate = 418,           /* like_predicate  */
  YYSYMBOL_opt_escape = 419,               /* opt_escape  */
  YYSYMBOL_null_predicate_part_2 = 420,    /* null_predicate_part_2  */
  YYSYMBOL_test_for_null = 421,            /* test_for_null  */
  YYSYMBOL_in_predicate_value = 422,       /* in_predicate_value  */
  YYSYMBOL_in_predicate_part_2 = 423,      /* in_predicate_part_2  */
  YYSYMBOL_in_predicate = 424,             /* in_predicate  */
  YYSYMBOL_quantified_comparison_predicate_part_2 = 425, /* quantified_comparison_predicate_part_2  */
  YYSYMBOL_all_or_any_predicate = 426,     /* all_or_any_predicate  */
  YYSYMBOL_any_all_some = 427,             /* any_all_some  */
  YYSYMBOL_existence_test = 428,           /* existence_test  */
  YYSYMBOL_unique_test = 429,              /* unique_test  */
  YYSYMBOL_subquery = 430,                 /* subquery  */
  YYSYMBOL_scalar_exp_commalist = 431,     /* scalar_exp_commalist  */
  YYSYMBOL_select_sublist = 432,           /* select_sublist  */
  YYSYMBOL_parameter_ref = 433,            /* parameter_ref  */
  YYSYMBOL_literal = 434,                  /* literal  */
  YYSYMBOL_as_clause = 435,                /* as_clause  */
  YYSYMBOL_position_exp = 436,             /* position_exp  */
  YYSYMBOL_num_value_fct = 437,            /* num_value_fct  */
  YYSYMBOL_char_length_exp = 438,          /* char_length_exp  */
  YYSYMBOL_octet_length_exp = 439,         /* octet_length_exp  */
  YYSYMBOL_bit_length_exp = 440,           /* bit_length_exp  */
  YYSYMBOL_length_exp = 441,               /* length_exp  */
  YYSYMBOL_datetime_field = 442,           /* datetime_field  */
  YYSYMBOL_extract_field = 443,            /* extract_field  */
  YYSYMBOL_time_zone_field = 444,          /* time_zone_field  */
  YYSYMBOL_extract_exp = 445,              /* extract_exp  */
  YYSYMBOL_unsigned_value_spec = 446,      /* unsigned_value_spec  */
  YYSYMBOL_general_value_spec = 447,       /* general_value_spec  */
  YYSYMBOL_set_fct_spec = 448,             /* set_fct_spec  */
  YYSYMBOL_function_name0 = 449,           /* function_name0  */
  YYSYMBOL_function_name1 = 450,           /* function_name1  */
  YYSYMBOL_function_name2 = 451,           /* function_name2  */
  YYSYMBOL_function_name12 = 452,          /* function_name12  */
  YYSYMBOL_function_name23 = 453,          /* function_name23  */
  YYSYMBOL_function_name3 = 454,           /* function_name3  */
  YYSYMBOL_function_name = 455,            /* function_name  */
  YYSYMBOL_string_function_1Argument = 456, /* string_function_1Argument  */
  YYSYMBOL_string_function_2Argument = 457, /* string_function_2Argument  */
  YYSYMBOL_string_function_3Argument = 458, /* string_function_3Argument  */
  YYSYMBOL_string_function_4Argument = 459, /* string_function_4Argument  */
  YYSYMBOL_string_function = 460,          /* string_function  */
  YYSYMBOL_date_function_0Argument = 461,  /* date_function_0Argument  */
  YYSYMBOL_date_function_1Argument = 462,  /* date_function_1Argument  */
  YYSYMBOL_date_function = 463,            /* date_function  */
  YYSYMBOL_numeric_function_0Argument = 464, /* numeric_function_0Argument  */
  YYSYMBOL_numeric_function_1Argument = 465, /* numeric_function_1Argument  */
  YYSYMBOL_numeric_function_2Argument = 466, /* numeric_function_2Argument  */
  YYSYMBOL_numeric_function = 467,         /* numeric_function  */
  YYSYMBOL_window_function = 468,          /* window_function  */
  YYSYMBOL_window_function_type = 469,     /* window_function_type  */
  YYSYMBOL_ntile_function = 470,           /* ntile_function  */
  YYSYMBOL_dynamic_parameter_specification = 471, /* dynamic_parameter_specification  */
  YYSYMBOL_simple_value_specification = 472, /* simple_value_specification  */
  YYSYMBOL_number_of_tiles = 473,          /* number_of_tiles  */
  YYSYMBOL_opt_lead_or_lag_function = 474, /* opt_lead_or_lag_function  */
  YYSYMBOL_opt_null_treatment = 475,       /* opt_null_treatment  */
  YYSYMBOL_lead_or_lag_function = 476,     /* lead_or_lag_function  */
  YYSYMBOL_lead_or_lag = 477,              /* lead_or_lag  */
  YYSYMBOL_lead_or_lag_extent = 478,       /* lead_or_lag_extent  */
  YYSYMBOL_offset = 479,                   /* offset  */
  YYSYMBOL_default_expression = 480,       /* default_expression  */
  YYSYMBOL_null_treatment = 481,           /* null_treatment  */
  YYSYMBOL_first_or_last_value_function = 482, /* first_or_last_value_function  */
  YYSYMBOL_first_or_last_value = 483,      /* first_or_last_value  */
  YYSYMBOL_opt_from_first_or_last = 484,   /* opt_from_first_or_last  */
  YYSYMBOL_nth_value_function = 485,       /* nth_value_function  */
  YYSYMBOL_nth_row = 486,                  /* nth_row  */
  YYSYMBOL_from_first_or_last = 487,       /* from_first_or_last  */
  YYSYMBOL_window_name = 488,              /* window_name  */
  YYSYMBOL_window_name_or_specification = 489, /* window_name_or_specification  */
  YYSYMBOL_in_line_window_specification = 490, /* in_line_window_specification  */
  YYSYMBOL_opt_window_clause = 491,        /* opt_window_clause  */
  YYSYMBOL_window_clause = 492,            /* window_clause  */
  YYSYMBOL_window_definition_list = 493,   /* window_definition_list  */
  YYSYMBOL_window_definition = 494,        /* window_definition  */
  YYSYMBOL_new_window_name = 495,          /* new_window_name  */
  YYSYMBOL_window_specification = 496,     /* window_specification  */
  YYSYMBOL_opt_existing_window_name = 497, /* opt_existing_window_name  */
  YYSYMBOL_opt_window_partition_clause = 498, /* opt_window_partition_clause  */
  YYSYMBOL_opt_window_frame_clause = 499,  /* opt_window_frame_clause  */
  YYSYMBOL_existing_window_name = 500,     /* existing_window_name  */
  YYSYMBOL_window_partition_clause = 501,  /* window_partition_clause  */
  YYSYMBOL_window_partition_column_reference_list = 502, /* window_partition_column_reference_list  */
  YYSYMBOL_window_partition_column_reference = 503, /* window_partition_column_reference  */
  YYSYMBOL_opt_window_frame_exclusion = 504, /* opt_window_frame_exclusion  */
  YYSYMBOL_window_frame_clause = 505,      /* window_frame_clause  */
  YYSYMBOL_window_frame_units = 506,       /* window_frame_units  */
  YYSYMBOL_window_frame_extent = 507,      /* window_frame_extent  */
  YYSYMBOL_window_frame_start = 508,       /* window_frame_start  */
  YYSYMBOL_window_frame_preceding = 509,   /* window_frame_preceding  */
  YYSYMBOL_window_frame_between = 510,     /* window_frame_between  */
  YYSYMBOL_window_frame_bound_1 = 511,     /* window_frame_bound_1  */
  YYSYMBOL_window_frame_bound_2 = 512,     /* window_frame_bound_2  */
  YYSYMBOL_window_frame_bound = 513,       /* window_frame_bound  */
  YYSYMBOL_window_frame_following = 514,   /* window_frame_following  */
  YYSYMBOL_window_frame_exclusion = 515,   /* window_frame_exclusion  */
  YYSYMBOL_op_parameter = 516,             /* op_parameter  */
  YYSYMBOL_odbc_call_spec = 517,           /* odbc_call_spec  */
  YYSYMBOL_op_odbc_call_parameter = 518,   /* op_odbc_call_parameter  */
  YYSYMBOL_odbc_parameter_commalist = 519, /* odbc_parameter_commalist  */
  YYSYMBOL_odbc_parameter = 520,           /* odbc_parameter  */
  YYSYMBOL_odbc_fct_spec = 521,            /* odbc_fct_spec  */
  YYSYMBOL_odbc_fct_type = 522,            /* odbc_fct_type  */
  YYSYMBOL_general_set_fct = 523,          /* general_set_fct  */
  YYSYMBOL_set_fct_type = 524,             /* set_fct_type  */
  YYSYMBOL_ordered_set_function = 525,     /* ordered_set_function  */
  YYSYMBOL_hypothetical_set_function = 526, /* hypothetical_set_function  */
  YYSYMBOL_within_group_specification = 527, /* within_group_specification  */
  YYSYMBOL_hypothetical_set_function_value_expression_list = 528, /* hypothetical_set_function_value_expression_list  */
  YYSYMBOL_inverse_distribution_function = 529, /* inverse_distribution_function  */
  YYSYMBOL_inverse_distribution_function_argument = 530, /* inverse_distribution_function_argument  */
  YYSYMBOL_inverse_distribution_function_type = 531, /* inverse_distribution_function_type  */
  YYSYMBOL_array_aggregate_function = 532, /* array_aggregate_function  */
  YYSYMBOL_rank_function_type = 533,       /* rank_function_type  */
  YYSYMBOL_outer_join_type = 534,          /* outer_join_type  */
  YYSYMBOL_join_condition = 535,           /* join_condition  */
  YYSYMBOL_join_spec = 536,                /* join_spec  */
  YYSYMBOL_join_type = 537,                /* join_type  */
  YYSYMBOL_cross_union = 538,              /* cross_union  */
  YYSYMBOL_qualified_join = 539,           /* qualified_join  */
  YYSYMBOL_joined_table = 540,             /* joined_table  */
  YYSYMBOL_named_columns_join = 541,       /* named_columns_join  */
  YYSYMBOL_simple_table = 542,             /* simple_table  */
  YYSYMBOL_non_join_query_primary = 543,   /* non_join_query_primary  */
  YYSYMBOL_non_join_query_term = 544,      /* non_join_query_term  */
  YYSYMBOL_query_primary = 545,            /* query_primary  */
  YYSYMBOL_non_join_query_exp = 546,       /* non_join_query_exp  */
  YYSYMBOL_all = 547,                      /* all  */
  YYSYMBOL_query_exp = 548,                /* query_exp  */
  YYSYMBOL_scalar_subquery = 549,          /* scalar_subquery  */
  YYSYMBOL_cast_operand = 550,             /* cast_operand  */
  YYSYMBOL_cast_target = 551,              /* cast_target  */
  YYSYMBOL_cast_spec = 552,                /* cast_spec  */
  YYSYMBOL_value_exp_primary = 553,        /* value_exp_primary  */
  YYSYMBOL_num_primary = 554,              /* num_primary  */
  YYSYMBOL_factor = 555,                   /* factor  */
  YYSYMBOL_term = 556,                     /* term  */
  YYSYMBOL_num_value_exp = 557,            /* num_value_exp  */
  YYSYMBOL_datetime_primary = 558,         /* datetime_primary  */
  YYSYMBOL_datetime_value_fct = 559,       /* datetime_value_fct  */
  YYSYMBOL_time_zone = 560,                /* time_zone  */
  YYSYMBOL_time_zone_specifier = 561,      /* time_zone_specifier  */
  YYSYMBOL_datetime_factor = 562,          /* datetime_factor  */
  YYSYMBOL_datetime_term = 563,            /* datetime_term  */
  YYSYMBOL_datetime_value_exp = 564,       /* datetime_value_exp  */
  YYSYMBOL_non_second_datetime_field = 565, /* non_second_datetime_field  */
  YYSYMBOL_datetime_unit = 566,            /* datetime_unit  */
  YYSYMBOL_start_field = 567,              /* start_field  */
  YYSYMBOL_end_field = 568,                /* end_field  */
  YYSYMBOL_single_datetime_field = 569,    /* single_datetime_field  */
  YYSYMBOL_interval_qualifier = 570,       /* interval_qualifier  */
  YYSYMBOL_function_arg_commalist2 = 571,  /* function_arg_commalist2  */
  YYSYMBOL_function_arg_commalist3 = 572,  /* function_arg_commalist3  */
  YYSYMBOL_function_arg_commalist4 = 573,  /* function_arg_commalist4  */
  YYSYMBOL_value_exp_commalist = 574,      /* value_exp_commalist  */
  YYSYMBOL_function_arg = 575,             /* function_arg  */
  YYSYMBOL_function_args_commalist = 576,  /* function_args_commalist  */
  YYSYMBOL_value_exp = 577,                /* value_exp  */
  YYSYMBOL_string_value_exp = 578,         /* string_value_exp  */
  YYSYMBOL_char_value_exp = 579,           /* char_value_exp  */
  YYSYMBOL_concatenation = 580,            /* concatenation  */
  YYSYMBOL_char_primary = 581,             /* char_primary  */
  YYSYMBOL_collate_clause = 582,           /* collate_clause  */
  YYSYMBOL_char_factor = 583,              /* char_factor  */
  YYSYMBOL_string_value_fct = 584,         /* string_value_fct  */
  YYSYMBOL_bit_value_fct = 585,            /* bit_value_fct  */
  YYSYMBOL_bit_substring_fct = 586,        /* bit_substring_fct  */
  YYSYMBOL_bit_value_exp = 587,            /* bit_value_exp  */
  YYSYMBOL_bit_factor = 588,               /* bit_factor  */
  YYSYMBOL_bit_primary = 589,              /* bit_primary  */
  YYSYMBOL_char_value_fct = 590,           /* char_value_fct  */
  YYSYMBOL_for_length = 591,               /* for_length  */
  YYSYMBOL_char_substring_fct = 592,       /* char_substring_fct  */
  YYSYMBOL_upper_lower = 593,              /* upper_lower  */
  YYSYMBOL_fold = 594,                     /* fold  */
  YYSYMBOL_form_conversion = 595,          /* form_conversion  */
  YYSYMBOL_char_translation = 596,         /* char_translation  */
  YYSYMBOL_trim_fct = 597,                 /* trim_fct  */
  YYSYMBOL_trim_operands = 598,            /* trim_operands  */
  YYSYMBOL_trim_spec = 599,                /* trim_spec  */
  YYSYMBOL_derived_column = 600,           /* derived_column  */
  YYSYMBOL_table_node = 601,               /* table_node  */
  YYSYMBOL_catalog_name = 602,             /* catalog_name  */
  YYSYMBOL_schema_name = 603,              /* schema_name  */
  YYSYMBOL_table_name = 604,               /* table_name  */
  YYSYMBOL_column_ref = 605,               /* column_ref  */
  YYSYMBOL_column_val = 606,               /* column_val  */
  YYSYMBOL_data_type = 607,                /* data_type  */
  YYSYMBOL_opt_char_set_spec = 608,        /* opt_char_set_spec  */
  YYSYMBOL_opt_collate_clause = 609,       /* opt_collate_clause  */
  YYSYMBOL_predefined_type = 610,          /* predefined_type  */
  YYSYMBOL_character_string_type = 611,    /* character_string_type  */
  YYSYMBOL_opt_paren_precision = 612,      /* opt_paren_precision  */
  YYSYMBOL_paren_char_length = 613,        /* paren_char_length  */
  YYSYMBOL_opt_paren_char_large_length = 614, /* opt_paren_char_large_length  */
  YYSYMBOL_paren_character_large_object_length = 615, /* paren_character_large_object_length  */
  YYSYMBOL_large_object_length = 616,      /* large_object_length  */
  YYSYMBOL_opt_multiplier = 617,           /* opt_multiplier  */
  YYSYMBOL_character_large_object_type = 618, /* character_large_object_type  */
  YYSYMBOL_national_character_string_type = 619, /* national_character_string_type  */
  YYSYMBOL_national_character_large_object_type = 620, /* national_character_large_object_type  */
  YYSYMBOL_binary_string_type = 621,       /* binary_string_type  */
  YYSYMBOL_binary_large_object_string_type = 622, /* binary_large_object_string_type  */
  YYSYMBOL_numeric_type = 623,             /* numeric_type  */
  YYSYMBOL_opt_paren_precision_scale = 624, /* opt_paren_precision_scale  */
  YYSYMBOL_exact_numeric_type = 625,       /* exact_numeric_type  */
  YYSYMBOL_approximate_numeric_type = 626, /* approximate_numeric_type  */
  YYSYMBOL_boolean_type = 627,             /* boolean_type  */
  YYSYMBOL_datetime_type = 628,            /* datetime_type  */
  YYSYMBOL_opt_with_or_without_time_zone = 629, /* opt_with_or_without_time_zone  */
  YYSYMBOL_interval_type = 630,            /* interval_type  */
  YYSYMBOL_column = 631,                   /* column  */
  YYSYMBOL_case_expression = 632,          /* case_expression  */
  YYSYMBOL_case_abbreviation = 633,        /* case_abbreviation  */
  YYSYMBOL_case_specification = 634,       /* case_specification  */
  YYSYMBOL_simple_case = 635,              /* simple_case  */
  YYSYMBOL_searched_case = 636,            /* searched_case  */
  YYSYMBOL_simple_when_clause_list = 637,  /* simple_when_clause_list  */
  YYSYMBOL_simple_when_clause = 638,       /* simple_when_clause  */
  YYSYMBOL_when_operand_list = 639,        /* when_operand_list  */
  YYSYMBOL_when_operand = 640,             /* when_operand  */
  YYSYMBOL_searched_when_clause_list = 641, /* searched_when_clause_list  */
  YYSYMBOL_searched_when_clause = 642,     /* searched_when_clause  */
  YYSYMBOL_else_clause = 643,              /* else_clause  */
  YYSYMBOL_result = 644,                   /* result  */
  YYSYMBOL_result_expression = 645,        /* result_expression  */
  YYSYMBOL_case_operand = 646,             /* case_operand  */
  YYSYMBOL_cursor = 647,                   /* cursor  */
  YYSYMBOL_parameter = 648,                /* parameter  */
  YYSYMBOL_range_variable = 649,           /* range_variable  */
  YYSYMBOL_user = 650,                     /* user  */
  YYSYMBOL_trigger_definition = 651,       /* trigger_definition  */
  YYSYMBOL_op_referencing = 652,           /* op_referencing  */
  YYSYMBOL_trigger_action_time = 653,      /* trigger_action_time  */
  YYSYMBOL_trigger_event = 654,            /* trigger_event  */
  YYSYMBOL_op_trigger_columnlist = 655,    /* op_trigger_columnlist  */
  YYSYMBOL_trigger_column_list = 656,      /* trigger_column_list  */
  YYSYMBOL_triggered_action = 657,         /* triggered_action  */
  YYSYMBOL_op_triggered_action_for = 658,  /* op_triggered_action_for  */
  YYSYMBOL_trigger_for = 659,              /* trigger_for  */
  YYSYMBOL_triggered_when_clause = 660,    /* triggered_when_clause  */
  YYSYMBOL_triggered_SQL_statement = 661,  /* triggered_SQL_statement  */
  YYSYMBOL_SQL_procedure_statement_list = 662, /* SQL_procedure_statement_list  */
  YYSYMBOL_SQL_procedure_statement = 663,  /* SQL_procedure_statement  */
  YYSYMBOL_transition_table_or_variable_list = 664, /* transition_table_or_variable_list  */
  YYSYMBOL_transition_table_or_variable = 665, /* transition_table_or_variable  */
  YYSYMBOL_old_transition_table_name = 666, /* old_transition_table_name  */
  YYSYMBOL_new_transition_table_name = 667, /* new_transition_table_name  */
  YYSYMBOL_transition_table_name = 668,    /* transition_table_name  */
  YYSYMBOL_old_transition_variable_name = 669, /* old_transition_variable_name  */
  YYSYMBOL_new_transition_variable_name = 670, /* new_transition_variable_name  */
  YYSYMBOL_trigger_name = 671              /* trigger_name  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;


/* Default (constant) value used for initialization for null
   right-hand sides.  Unlike the standard yacc.c template, here we set
   the default value of $$ to a zeroed-out value.  Since the default
   value is undefined, this behavior is technically correct.  */
static YYSTYPE yyval_default;



#include <stddef.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif
#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YYFREE
# define YYFREE free
#endif
#ifndef YYMALLOC
# define YYMALLOC malloc
#endif
#ifndef YYREALLOC
# define YYREALLOC realloc
#endif

#ifdef __cplusplus
  typedef bool yybool;
# define yytrue true
# define yyfalse false
#else
  /* When we move to stdbool, get rid of the various casts to yybool.  */
  typedef signed char yybool;
# define yytrue 1
# define yyfalse 0
#endif

#ifndef YYSETJMP
# include <setjmp.h>
# define YYJMP_BUF jmp_buf
# define YYSETJMP(Env) setjmp (Env)
/* Pacify Clang and ICC.  */
# define YYLONGJMP(Env, Val)                    \
 do {                                           \
   longjmp (Env, Val);                          \
   YY_ASSERT (0);                               \
 } while (yyfalse)
#endif

#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* The _Noreturn keyword of C11.  */
#ifndef _Noreturn
# if (defined __cplusplus \
      && ((201103 <= __cplusplus && !(__GNUC__ == 4 && __GNUC_MINOR__ == 7)) \
          || (defined _MSC_VER && 1900 <= _MSC_VER)))
#  define _Noreturn [[noreturn]]
# elif ((!defined __cplusplus || defined __clang__) \
        && (201112 <= (defined __STDC_VERSION__ ? __STDC_VERSION__ : 0) \
            || (!defined __STRICT_ANSI__ \
                && (4 < __GNUC__ + (7 <= __GNUC_MINOR__) \
                    || (defined __apple_build_version__ \
                        ? 6000000 <= __apple_build_version__ \
                        : 3 < __clang_major__ + (5 <= __clang_minor__))))))
   /* _Noreturn works as-is.  */
# elif (2 < __GNUC__ + (8 <= __GNUC_MINOR__) || defined __clang__ \
        || 0x5110 <= __SUNPRO_C)
#  define _Noreturn __attribute__ ((__noreturn__))
# elif 1200 <= (defined _MSC_VER ? _MSC_VER : 0)
#  define _Noreturn __declspec (noreturn)
# else
#  define _Noreturn
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  373
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   8909

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  329
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  343
/* YYNRULES -- Number of rules.  */
#define YYNRULES  799
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  1321
/* YYMAXRHS -- Maximum number of symbols on right-hand side of rule.  */
#define YYMAXRHS 10
/* YYMAXLEFT -- Maximum number of symbols to the left of a handle
   accessed by $0, $-1, etc., in any rule.  */
#define YYMAXLEFT 0

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   562

/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       3,     4,   325,   322,     5,   323,    13,   326,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     6,     7,
       2,   327,     2,     8,     2,     2,     2,     2,     2,     2,
       2,    16,     2,     2,     2,    14,     2,    15,     2,     2,
      18,     2,     2,     2,    17,     2,     2,     2,     2,     2,
       2,     9,     2,    10,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    11,     2,    12,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,   108,   109,   110,
     111,   112,   113,   114,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,   157,   158,   159,   160,
     161,   162,   163,   164,   165,   166,   167,   168,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   180,
     181,   182,   183,   184,   185,   186,   187,   188,   189,   190,
     191,   192,   193,   194,   195,   196,   197,   198,   199,   200,
     201,   202,   203,   204,   205,   206,   207,   208,   209,   210,
     211,   212,   213,   214,   215,   216,   217,   218,   219,   220,
     221,   222,   223,   224,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   324,   328
};

#if YYDEBUG
/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   272,   272,   274,   282,   283,   341,   342,   343,   344,
     348,   359,   362,   368,   369,   373,   382,   383,   389,   392,
     393,   401,   405,   406,   410,   414,   418,   424,   425,   431,
     435,   445,   451,   460,   472,   480,   481,   489,   492,   498,
     510,   511,   519,   520,   528,   541,   542,   550,   554,   558,
     561,   567,   568,   572,   573,   577,   581,   586,   589,   595,
     596,   602,   603,   611,   614,   625,   630,   637,   638,   639,
     656,   657,   663,   665,   666,   667,   668,   669,   671,   672,
     673,   683,   684,   694,   713,   722,   731,   740,   750,   753,
     768,   779,   780,   785,   794,   805,   806,   807,   826,   829,
     835,   842,   843,   846,   856,   859,   865,   869,   870,   876,
     884,   895,   900,   903,   904,   907,   916,   917,   920,   921,
     924,   925,   928,   929,   932,   943,   946,   950,   951,   954,
     955,   963,   972,   988,   996,   999,  1005,  1006,  1009,  1010,
    1013,  1014,  1023,  1029,  1036,  1037,  1045,  1054,  1061,  1062,
    1070,  1073,  1076,  1079,  1085,  1086,  1094,  1095,  1102,  1149,
    1158,  1159,  1167,  1168,  1177,  1178,  1187,  1188,  1189,  1190,
    1191,  1192,  1193,  1194,  1197,  1204,  1211,  1236,  1237,  1238,
    1239,  1240,  1241,  1242,  1250,  1258,  1296,  1302,  1305,  1315,
    1325,  1331,  1337,  1359,  1384,  1385,  1389,  1400,  1407,  1416,
    1422,  1438,  1442,  1450,  1459,  1465,  1481,  1490,  1496,  1513,
    1514,  1515,  1519,  1525,  1531,  1540,  1545,  1560,  1565,  1597,
    1598,  1599,  1600,  1601,  1603,  1615,  1627,  1639,  1655,  1656,
    1662,  1665,  1675,  1685,  1686,  1687,  1690,  1698,  1709,  1719,
    1729,  1734,  1739,  1746,  1751,  1758,  1759,  1760,  1763,  1768,
    1775,  1787,  1788,  1791,  1792,  1793,  1794,  1795,  1796,  1797,
    1798,  1799,  1800,  1801,  1802,  1803,  1804,  1807,  1808,  1815,
    1822,  1829,  1837,  1845,  1853,  1861,  1869,  1882,  1897,  1898,
    1901,  1902,  1903,  1906,  1907,  1910,  1911,  1912,  1913,  1916,
    1917,  1920,  1923,  1924,  1925,  1926,  1929,  1930,  1931,  1932,
    1933,  1934,  1935,  1939,  1940,  1941,  1944,  1947,  1951,  1952,
    1953,  1954,  1955,  1958,  1959,  1960,  1963,  1964,  1965,  1966,
    1967,  1968,  1969,  1970,  1971,  1972,  1973,  1974,  1975,  1976,
    1980,  1981,  1982,  1985,  1988,  1989,  1990,  1991,  1992,  1993,
    1994,  1995,  1996,  1997,  1998,  1999,  2000,  2001,  2002,  2003,
    2004,  2005,  2008,  2009,  2010,  2013,  2014,  2018,  2027,  2034,
    2041,  2042,  2043,  2044,  2045,  2048,  2058,  2061,  2064,  2065,
    2068,  2069,  2075,  2085,  2086,  2090,  2102,  2103,  2106,  2109,
    2112,  2115,  2116,  2119,  2130,  2131,  2134,  2135,  2138,  2152,
    2153,  2156,  2162,  2170,  2173,  2174,  2177,  2180,  2181,  2184,
    2192,  2195,  2200,  2209,  2212,  2229,  2230,  2233,  2234,  2237,
    2238,  2241,  2244,  2253,  2256,  2261,  2269,  2270,  2273,  2282,
    2283,  2286,  2287,  2290,  2296,  2297,  2305,  2313,  2323,  2326,
    2329,  2330,  2336,  2339,  2347,  2354,  2360,  2366,  2375,  2376,
    2384,  2395,  2396,  2406,  2409,  2416,  2417,  2418,  2422,  2428,
    2437,  2438,  2439,  2443,  2452,  2460,  2469,  2470,  2473,  2474,
    2475,  2476,  2477,  2478,  2479,  2480,  2481,  2482,  2483,  2484,
    2485,  2486,  2490,  2491,  2494,  2503,  2517,  2520,  2531,  2535,
    2545,  2548,  2549,  2553,  2565,  2566,  2567,  2568,  2571,  2576,
    2581,  2588,  2596,  2597,  2600,  2601,  2606,  2607,  2615,  2627,
    2636,  2645,  2648,  2651,  2661,  2662,  2666,  2667,  2676,  2677,
    2687,  2690,  2691,  2699,  2709,  2710,  2713,  2716,  2719,  2722,
    2723,  2726,  2738,  2739,  2740,  2741,  2742,  2743,  2744,  2751,
    2755,  2756,  2759,  2760,  2766,  2775,  2776,  2783,  2793,  2794,
    2801,  2815,  2822,  2827,  2832,  2839,  2847,  2861,  2866,  2874,
    2900,  2961,  2962,  2963,  2964,  2965,  2966,  2967,  2968,  2969,
    2973,  2974,  2975,  2976,  2977,  2978,  2979,  2980,  2984,  2992,
    2993,  3002,  3008,  3017,  3024,  3028,  3034,  3043,  3053,  3056,
    3060,  3072,  3073,  3080,  3088,  3097,  3100,  3104,  3114,  3124,
    3125,  3126,  3133,  3141,  3142,  3145,  3152,  3162,  3163,  3166,
    3174,  3175,  3183,  3184,  3187,  3194,  3207,  3231,  3238,  3251,
    3252,  3253,  3258,  3263,  3270,  3271,  3279,  3290,  3300,  3301,
    3304,  3314,  3324,  3336,  3348,  3358,  3366,  3373,  3380,  3386,
    3390,  3391,  3392,  3396,  3405,  3406,  3407,  3410,  3417,  3426,
    3436,  3442,  3451,  3457,  3464,  3474,  3498,  3501,  3508,  3511,
    3512,  3521,  3522,  3525,  3532,  3538,  3539,  3540,  3541,  3542,
    3545,  3551,  3557,  3564,  3571,  3577,  3580,  3581,  3584,  3593,
    3594,  3597,  3607,  3615,  3616,  3621,  3626,  3631,  3636,  3643,
    3651,  3659,  3667,  3674,  3681,  3687,  3695,  3703,  3710,  3713,
    3722,  3730,  3738,  3744,  3751,  3757,  3760,  3768,  3776,  3777,
    3780,  3781,  3788,  3799,  3805,  3811,  3817,  3818,  3819,  3820,
    3823,  3831,  3832,  3833,  3834,  3842,  3845,  3846,  3853,  3862,
    3863,  3870,  3879,  3889,  3890,  3896,  3902,  3910,  3911,  3914,
    3922,  3930,  3940,  3941,  3944,  3955,  3965,  3970,  3977,  3987,
    3990,  3995,  3996,  3997,  3998,  3999,  4000,  4003,  4008,  4015,
    4025,  4026,  4034,  4037,  4040,  4043,  4056,  4060,  4063,  4078,
    4079,  4086,  4091,  4105,  4108,  4123,  4126,  4134,  4135,  4136,
    4144,  4145,  4146,  4154,  4157,  4165,  4168,  4177,  4180,  4189,
    4190,  4193,  4196,  4204,  4205,  4216,  4221,  4228,  4232,  4237,
    4245,  4253,  4261,  4269,  4279,  4282,  4285,  4288,  4291,  4294
};
#endif

#define YYPACT_NINF (-1184)
#define YYTABLE_NINF (-747)

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
    2427,  1464,   121, -1184,   190,   448, -1184, -1184, -1184, -1184,
   -1184, -1184,  2748,   487, -1184, -1184,   169,   -30,   223,   237,
      13, -1184, -1184, -1184,   205,   256, -1184,   242,   453,   262,
   -1184, -1184, -1184, -1184,   292,   175,    96, -1184, -1184,   335,
     425, -1184,   256,   405, -1184, -1184, -1184,   433, -1184,   439,
     479, -1184, -1184,   369, -1184, -1184, -1184, -1184, -1184, -1184,
     488, -1184, -1184, -1184, -1184, -1184, -1184,   498, -1184, -1184,
   -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184,   530, -1184,
   -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184,
   -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184,
   -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184,
   -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184,
   -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184,
   -1184, -1184, -1184, -1184,   543,  4941,   546,   549, -1184, -1184,
   -1184, -1184, -1184, -1184, -1184, -1184, -1184,   572,   580, -1184,
   -1184, -1184, -1184,   605, -1184, -1184, -1184, -1184, -1184, -1184,
    8186,  8186,   497,   515, -1184, -1184, -1184, -1184,   459, -1184,
     490, -1184, -1184, -1184, -1184,   167,   158, -1184, -1184, -1184,
   -1184, -1184, -1184,   295,   304, -1184, -1184,  5246, -1184, -1184,
   -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184,
   -1184, -1184,   569, -1184, -1184, -1184, -1184, -1184, -1184, -1184,
   -1184, -1184, -1184,   621,   630,   647,   652,   666,   668,   683,
   -1184, -1184, -1184,   687, -1184, -1184, -1184, -1184, -1184, -1184,
   -1184, -1184, -1184,   357, -1184, -1184,   690, -1184,   698, -1184,
     381,   701, -1184, -1184, -1184,   704, -1184,   706, -1184, -1184,
   -1184, -1184, -1184,   -25,  -197,   641, -1184, -1184, -1184, -1184,
     372, -1184,   391, -1184,   674, -1184, -1184, -1184, -1184, -1184,
   -1184,   713, -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184,
   -1184, -1184, -1184, -1184, -1184,  1464,   721,   723, -1184,   646,
     436,    47, -1184, -1184,   680, -1184,   157,    15, -1184,   757,
     450, -1184,  8666, -1184, -1184,   594,   764,   766,   772,  3069,
     379, -1184, -1184, -1184,   762,     3,  7598, -1184,  7598,   109,
     405,   405,   768,   405,   151, -1184, -1184,   700,   703, -1184,
     818, -1184,   818, -1184,   818,   731,   824, -1184,   418,  7598,
   -1184, -1184, -1184,  1169,  7598,  4647, -1184,   216,   709, -1184,
   -1184, -1184,  7598,  7598,  7598,   405,  7598,  7598,  4353,  7598,
    5540,  3390, -1184,   222, -1184,   593,  7598,  7598,   840,   776,
    7598, -1184, -1184, -1184, -1184,  6128,   843,  7598,   825,  5246,
   -1184, -1184, -1184, -1184, -1184, -1184,  3390,  3390, -1184,   852,
     854, -1184, -1184,   256, -1184, -1184, -1184, -1184,   860,  7598,
    7598,  6422,  6422,  7598,  5834,  7598,   117,  7598,  7598,    96,
    7892,  6716,  7892,  7892,  7892,  7892,   780, -1184,  7598,   470,
     405, -1184,  7598,   869,  6128, -1184,   825, -1184, -1184,   825,
     825, -1184, -1184, -1184, -1184, -1184, -1184,   874,   405, -1184,
   -1184, -1184,  3069,    96, -1184,    52,   872,   875, -1184, -1184,
   -1184, -1184, -1184, -1184,   870,   372,   899,   773,   902,  7598,
     904,   818, -1184,   429,   771,   151,   628, -1184,    70, -1184,
   -1184, -1184,   405,   406,   839, -1184, -1184,    17, -1184,   224,
     911, -1184,    84, -1184,   372,   779, -1184,  7598, -1184, -1184,
     -15,   914,  7010,   893,   896,    70,    20,    21,    22,   920,
     201,    -2,   642,   -10,   850, -1184, -1184,   851, -1184, -1184,
     853, -1184,   855,   858,   930,   871, -1184,   880, -1184, -1184,
     885, -1184, -1184,   372,   -33,  5540,    23,  -138,  7598, -1184,
     697,  3390,   694, -1184,   593,   649,   372,   654,    28, -1184,
     569, -1184, -1184,   942, -1184,    73,   637,  5540, -1184, -1184,
     122,    19, -1184,   849, -1184, -1184,   295, -1184, -1184,   959,
     494, -1184, -1184,   960,   966,   967,   969, -1184,   971,   972,
     973,   975,   976,   977, -1184,   658,   672,   979,   980, -1184,
     693,   984,   985,   958, -1184, -1184, -1184, -1184, -1184,   986,
     372,    34,  7598,   988,   233, -1184,   110,   116, -1184, -1184,
     -25,   -25, -1184, -1184, -1184, -1184, -1184,    35, -1184,   555,
   -1184,   151,   151,   151,  7598,   990,  1169,   963,    10,   833,
     833,   405, -1184,   992,    79,   965, -1184, -1184,   900,    55,
    3390, -1184, -1184,    32,   993, -1184, -1184, -1184, -1184,   610,
   -1184,   876, -1184, -1184, -1184,   133,   628, -1184,   771,  7598,
      70, -1184, -1184,   405,   372,  7598, -1184,  7598,    -8,   991,
   -1184,   991, -1184, -1184,    78, -1184,   682, -1184, -1184, -1184,
     151, -1184,  7598,  7598,  7598, -1184,  7598,  7598,  7598,   968,
    1001,  7598,   372, -1184, -1184,    85, -1184,  5246,    80,    81,
     106,   185,   194, -1184,   760, -1184, -1184, -1184, -1184, -1184,
     776,  6128,   707,   944,  7598, -1184, -1184, -1184, -1184,  7598,
     262,  7598,  7598, -1184,  7598,  7598, -1184,  7598,  7598, -1184,
   -1184,  7598, -1184, -1184,  7598, -1184,   705, -1184,   987,  1003,
     337,  1007,   777,   777,  7598, -1184, -1184,  6128, -1184, -1184,
     646, -1184,   646,   776, -1184,   939,  1005,  1008, -1184, -1184,
      30, -1184,  1019,  1019,   919,  1021, -1184,   146,  1019, -1184,
   -1184,  1022,  1022,   176,  1022,  1022,  1023,    62,  1023,  1023,
   -1184,   177, -1184,   640,  1024, -1184, -1184, -1184,   994, -1184,
     674, -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184,
    1025,  1026, -1184,  1029,   940,   947, -1184,   634, -1184, -1184,
    1030, -1184,   878,   849, -1184, -1184,   936, -1184,   937,   304,
     628, -1184,    70,    61,   509,   888,  1034,   790,   120, -1184,
   -1184, -1184,   120,   130,   964, -1184, -1184,  1036,   372,   372,
    7598,  1016,    70, -1184,  7304,    32,   372,   372,    36,   -13,
     102,    48,  3711, -1184, -1184,  -114,  4032,  7598, -1184, -1184,
   -1184,  1040, -1184, -1184,  1037,   733,   277,   983,   253,   372,
   -1184,  1053, -1184, -1184,  1054,  1055,  1027,   961, -1184, -1184,
    1056,   337,   775,   778, -1184, -1184, -1184,   989, -1184, -1184,
     729, -1184,   569,   737, -1184, -1184,    92,    92,  1039,  1022,
     789, -1184, -1184,  1042, -1184, -1184, -1184,  1046,  1022,   795,
   -1184, -1184,   -62,   -62,  1022,   798, -1184, -1184, -1184,  1051,
   -1184, -1184,   195,    45, -1184, -1184,  1022,   800, -1184, -1184,
   -1184, -1184, -1184,  1019, -1184, -1184,  1022,   950, -1184, -1184,
   -1184,   970,   674, -1184, -1184, -1184, -1184,  3390,  1074, -1184,
   -1184,    79,    70, -1184,   938,    70, -1184,  1016, -1184, -1184,
   -1184, -1184,    97, -1184, -1184,   509,   449,  1075,   133,   133,
     995, -1184, -1184,   137, -1184, -1184,   982,   996, -1184,  1052,
    1080,  1060, -1184, -1184,  1048,  1011, -1184,   372, -1184, -1184,
   -1184, -1184,   372, -1184,  7598,  1086,  1087, -1184,  1088, -1184,
     141,    95,   468, -1184,  6128, -1184, -1184, -1184, -1184, -1184,
   -1184,  1020,  1084,  7598,  7598,  7598,  7598,    91,   438,  7598,
   -1184, -1184, -1184,  1094,   777, -1184,   776, -1184, -1184,  1095,
   -1184,  1023,   743,  1096, -1184,  1023,   981,   997, -1184, -1184,
   -1184,  1023,   744,  1097,  1022,   823, -1184,  1022, -1184, -1184,
    1023, -1184,   978,   664,  1076, -1184,    87,    70, -1184,   759,
     525,  1064, -1184,  1103, -1184,   856,    61,  1044, -1184, -1184,
    1104,   790,   133,  1035, -1184,   133, -1184,    70, -1184,  1080,
    8435,  3390,   814,   372, -1184, -1184,  3711, -1184, -1184, -1184,
   -1184,  7598, -1184,   471,   337, -1184, -1184,   372, -1184, -1184,
    1118,   263,  1119, -1184,   674, -1184, -1184,  1121, -1184,   486,
   -1184,   372,   961, -1184, -1184, -1184, -1184, -1184,  1105, -1184,
   -1184,   998,   999, -1184, -1184, -1184, -1184, -1184, -1184, -1184,
   -1184, -1184,  1023, -1184, -1184,  1022, -1184, -1184, -1184, -1184,
     769, -1184,  1031,  1126,   118,   405, -1184, -1184,  1032,   519,
    1059, -1184,  1033, -1184,   793,   133,   570,   782, -1184,  1127,
   -1184, -1184,   304,   958,   961, -1184, -1184, -1184, -1184, -1184,
    7598,    91, -1184, -1184,   784,   877,   827,   831,   838, -1184,
   -1184, -1184,  1134,  1135, -1184, -1184, -1184, -1184,  1038, -1184,
    3390, -1184, -1184, -1184,   569, -1184,  1137, -1184,   -28,   -18,
     519, -1184,   887, -1184,   895, -1184,   797,  3390,  1142, -1184,
   -1184, -1184, -1184,  8435, -1184,  1141, -1184,  1115,   842, -1184,
   -1184,   161,   298, -1184,   834, -1184, -1184, -1184, -1184, -1184,
     140, -1184, -1184, -1184, -1184,   405,    90,    70,  1124, -1184,
    1124,  1124,  1124, -1184,   542,  1150,  1785,   304,    70, -1184,
   -1184,   958,  1158,  1143,   857, -1184, -1184, -1184,   784,   905,
   -1184, -1184,   865,  1164, -1184,   812,  1144,  1147,  1144,  1148,
   -1184, -1184, -1184,  3390, -1184,   912, -1184, -1184, -1184,   815,
   -1184, -1184,   868,   946,  1107, -1184, -1184, -1184, -1184, -1184,
      70, -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184,
   -1184,    93,  2427, -1184,  1159, -1184,  -151,   569,  -127, -1184,
   -1184,   829, -1184,  1176, -1184, -1184, -1184, -1184, -1184, -1184,
   -1184,   946, -1184,  2106,  -151, -1184,   569, -1184, -1184,   873,
   -1184
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int16 yydefact[] =
{
      70,    70,     0,   757,     0,   438,   597,   223,   219,   220,
     221,   222,    70,   723,   463,   458,     0,     0,     0,     0,
       0,   329,   327,    92,     0,     0,   256,     0,     0,    70,
     619,   459,   460,   255,     0,     0,    95,   464,   461,     0,
       0,   257,     0,     0,   618,   254,   297,     0,   308,   725,
       0,   309,   310,   307,   298,   304,   296,   289,   311,   299,
     724,   303,   306,   305,   300,   312,   301,     0,   302,   542,
     543,   544,   313,   314,   320,   317,   316,   318,   726,   323,
     324,   319,   321,   315,   322,   290,   325,   330,   331,   328,
     286,   326,   332,   334,   335,   336,   337,   352,   338,   339,
     340,   341,   347,   342,   287,   288,   349,   348,   353,   333,
     354,   350,   355,   351,   285,   343,   344,   345,   346,   356,
     462,   471,   470,   469,   468,   467,   466,   465,   484,   485,
     486,   487,   481,   482,     0,     0,     0,     0,   258,   259,
     260,   261,   262,   263,   264,   265,   266,     0,     0,   376,
     377,   384,   385,     0,   181,   182,   178,   177,   180,   179,
       0,     0,     0,     2,     5,     6,     7,     8,     0,     4,
      79,    72,    73,    74,    75,    70,   158,    76,    77,    78,
      81,   160,   162,   164,   762,   156,   166,     0,   187,   167,
     192,   193,   173,   200,   171,   205,   172,   208,   168,   169,
     170,   517,   252,   233,   531,   240,   241,   242,   235,   234,
     522,   251,   524,     0,     0,     0,     0,     0,     0,     0,
     280,   283,   291,     0,   292,   278,   281,   293,   279,   282,
     284,   294,   527,     0,   361,   362,     0,   363,     0,   364,
     267,     0,   456,   472,   473,     0,   457,     0,   525,   529,
     530,   532,   535,   538,   589,   547,   541,   549,   550,   591,
      91,   590,   592,   594,   600,   593,   598,   603,   604,   602,
     609,     0,   610,   611,   612,   613,   523,   641,   526,   727,
     728,   732,   733,   253,     9,    70,     0,     0,   505,     0,
      81,     0,   506,   508,   511,   516,     0,    91,   756,     0,
       0,   450,     0,   451,   452,     0,     0,     0,     0,    70,
       0,    71,   307,   161,     0,     0,     0,    83,     0,    95,
       0,     0,     0,     0,     0,   212,   755,     0,     0,    53,
      42,    51,    42,    56,    42,     0,    48,    49,   184,     0,
      93,    96,    97,     0,     0,     0,   213,   640,     0,   636,
     635,   634,     0,     0,     0,     0,     0,   608,     0,     0,
       0,    70,   754,   750,   747,     0,     0,     0,     0,     0,
       0,   534,   533,     1,     3,     0,     0,     0,   514,     0,
     186,   190,   191,   199,   204,   207,    70,    70,   210,   209,
     211,   176,    90,     0,   224,   225,   226,   227,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    95,
       0,     0,     0,     0,     0,     0,     0,   548,     0,     0,
       0,   601,     0,   516,     0,   763,   514,   157,   214,   514,
     514,   528,   758,   439,   295,   449,   267,     0,     0,    80,
     268,   448,    70,    95,   504,     0,     0,   723,   725,   724,
     726,   647,   642,   646,     0,   518,     0,   590,     0,     0,
       0,    42,   799,     0,   107,     0,     0,    47,     0,    55,
      54,    52,     0,     0,     0,   197,   198,     0,   111,     0,
     112,   215,   228,   217,     0,   590,   630,     0,   631,   632,
     629,     0,     0,     0,     0,     0,     0,     0,     0,    42,
       0,   578,     0,   578,     0,   606,   607,   327,   248,   249,
     323,   559,   324,   319,   244,   286,   555,   326,   552,   246,
       0,   245,   243,   247,    61,     0,     0,     0,     0,   748,
       0,    70,   750,   736,     0,     0,   578,     0,   578,   359,
     367,   369,   368,     0,   366,     0,     0,     0,   203,   201,
     194,   194,   515,     0,   175,   163,   165,   206,   270,     0,
     753,   581,   752,     0,     0,   327,   323,   567,   324,   319,
     325,   286,   326,     0,   585,     0,     0,     0,     0,   269,
       0,     0,     0,   405,   393,   394,   357,   395,   396,   370,
     378,     0,     0,     0,   480,   358,     0,   478,   536,   537,
     539,   540,   546,   545,   596,   595,   599,     0,   507,     0,
      88,     0,     0,     0,     0,   441,     0,     0,     0,     0,
       0,     0,   454,     0,     0,     0,   767,   768,     0,     0,
      70,    84,   108,     0,    85,   104,   106,   218,   723,     0,
      38,     0,    50,   183,   238,     0,     0,   110,   107,     0,
       0,   633,   230,     0,   628,     0,   624,     0,     0,     0,
     638,   640,   637,   639,   107,    98,     0,   239,   236,   237,
       0,   232,     0,     0,     0,   617,     0,     0,     0,     0,
       0,     0,   753,   751,   735,    90,   742,     0,   187,   192,
     200,   205,     0,   739,     0,   737,   729,   731,   730,   365,
       0,     0,     0,     0,     0,   189,   188,    82,   271,     0,
      70,     0,     0,   272,     0,     0,   276,     0,     0,   277,
     273,     0,   275,   274,     0,   411,   407,   406,     0,     0,
     373,     0,   476,   476,     0,   620,    87,     0,   510,   509,
     513,   109,   512,   445,   440,     0,     0,   723,   643,   708,
     666,   716,   700,   700,   713,   711,   707,   666,   700,   712,
     706,   666,   666,   666,     0,     0,   669,     0,   669,   669,
     709,   666,   715,     0,     0,   519,   520,   648,   649,   665,
     651,   688,   655,   695,   656,   698,   699,   657,   658,   659,
       0,     0,   455,     0,     0,     0,    19,     0,    11,    13,
       0,    14,     0,     0,   769,   771,   773,   770,     0,   147,
       0,    43,     0,     0,     0,     0,   133,   134,   759,   501,
     502,   144,   140,     0,   148,   216,   229,     0,   627,   626,
       0,     0,     0,   103,     0,    86,   579,   580,     0,   614,
     590,     0,    70,   483,   749,   174,    70,     0,   734,   390,
     389,     0,   185,   202,     0,   195,   584,   184,     0,   582,
     575,     0,   586,   587,     0,     0,     0,    61,   408,   379,
     371,   373,     0,     0,   383,   374,   453,     0,   479,   474,
       0,    89,   446,     0,   443,   447,     0,     0,     0,     0,
       0,   660,   667,     0,   705,   704,   714,     0,     0,     0,
     684,   703,   719,   719,     0,     0,   661,   664,   694,     0,
     691,   670,   666,   666,   681,   697,     0,     0,   692,   556,
     557,   558,   553,   700,   554,   551,   666,     0,   574,   722,
     521,     0,   651,   652,   654,   622,   621,    70,     0,    20,
      10,     0,     0,    16,    40,     0,   772,     0,   105,    37,
     761,    59,    45,    57,    60,     0,   494,   144,     0,     0,
       0,   490,   495,   494,   488,   489,   496,     0,   137,     0,
      35,     0,   142,    94,     0,   154,   623,   625,   640,    99,
     102,   100,   101,   231,     0,     0,     0,   250,    62,    63,
      67,    67,     0,   741,     0,   743,   745,   746,   744,   740,
     738,   386,     0,     0,     0,     0,     0,     0,   409,     0,
     375,   381,   382,     0,   476,   442,   445,   645,   644,     0,
     662,   669,     0,     0,   687,   669,     0,     0,   717,   718,
     663,   669,   673,     0,     0,     0,   682,     0,   683,   693,
     669,   572,   571,     0,     0,   653,     0,     0,    12,     0,
      15,     0,    39,   775,   774,   765,     0,     0,    44,   146,
     144,   135,     0,     0,   497,     0,   760,     0,   143,    35,
       0,    70,   397,   615,   616,   605,    70,    68,    69,    66,
      65,     0,   174,     0,   373,   387,   196,   583,   588,   576,
       0,   723,   412,   414,   651,   420,   419,     0,   410,     0,
     372,   380,    61,   475,   444,   668,   679,   701,     0,   710,
     690,     0,     0,   680,   674,   675,   676,   677,   678,   672,
     671,   685,   669,   686,   696,   666,   569,   573,   650,    34,
       0,    31,     0,    27,     0,     0,    22,    17,     0,     0,
     777,    58,     0,   145,   498,     0,   494,     0,   141,   149,
     151,   150,   155,     0,    61,   398,    64,   391,   392,   388,
       0,     0,   415,   404,     0,     0,     0,     0,   416,   421,
     424,   422,     0,     0,   720,   721,   689,   570,     0,    21,
      70,    24,    25,    26,    23,    18,    29,    41,   138,   138,
     766,   788,     0,   764,   781,    46,   499,    70,     0,   492,
     500,   493,    36,     0,   403,   399,   401,     0,   127,   577,
     413,     0,     0,   430,     0,   428,   432,   425,   423,   426,
       0,   418,   417,   477,   702,     0,     0,     0,   136,   139,
     136,   136,   136,   789,     0,     0,    70,   491,     0,   153,
     152,     0,     0,     0,   113,   128,   431,   433,     0,     0,
     435,   436,     0,    32,    28,     0,     0,     0,     0,     0,
     779,   780,   778,    70,   782,     0,   787,   776,   783,     0,
     400,   402,   129,     0,   122,   114,   427,   429,   434,   437,
       0,    30,   796,   793,   795,   798,   791,   792,   794,   797,
     790,     0,    70,   503,     0,   131,     0,   125,     0,   132,
     123,     0,   159,     0,   785,   130,   120,   121,   115,   118,
     119,   116,    33,    70,     0,   117,   126,   784,   786,     0,
     124
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -1184, -1184,    88, -1184, -1184, -1184,   243, -1184, -1184, -1184,
     144, -1184, -1184,   127,  -885, -1184, -1184,  -233, -1184, -1184,
   -1184, -1184,   714, -1184,   143,  -830, -1184,   125,   206,   -16,
   -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184,  -172,  -125,
   -1184, -1184,  -200, -1184,   370, -1184, -1184,   557,   394,  -516,
     254,     0,   590, -1184, -1184, -1184, -1184,  -107, -1184, -1184,
   -1184, -1184, -1184, -1184, -1184,   385, -1184, -1184,  -805,    24,
   -1184,  -627, -1184, -1184, -1184, -1184,  1197, -1184,   826,   828,
       1,  -763, -1184, -1184,  -155,  -147, -1184,  -144,  1043, -1184,
     660,  -141, -1184, -1184,  -140, -1184,  1045, -1184, -1184, -1184,
   -1184,   -19, -1184,   565, -1184,  -364, -1184, -1184, -1184, -1184,
   -1184, -1184, -1184, -1184, -1184, -1184, -1184,  -987, -1184,  -298,
   -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184,
   -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184,
   -1184, -1184,   521,   522, -1184, -1184,  -795, -1184, -1184, -1184,
   -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184,  -325,
   -1184, -1184, -1184, -1184, -1184,   -22, -1184,   -17, -1184, -1184,
   -1184, -1184, -1184, -1184,    65, -1184, -1184, -1184, -1184,   128,
   -1184, -1184, -1184, -1184,   -20, -1184, -1184, -1184, -1184, -1184,
   -1184,   213, -1184, -1184,  -295, -1184, -1184, -1184,  -711, -1184,
   -1184, -1184, -1184, -1184,  -293, -1184, -1184, -1184,   267, -1184,
   -1184,  -685, -1184, -1184,   620,   269, -1184,  -277,   115,  -393,
   -1184,   915,   612, -1184,   861,   732,   482,   483,   830, -1184,
     100, -1184, -1184, -1184, -1184, -1184,  -712, -1184, -1184, -1184,
   -1184, -1184, -1184, -1184, -1184,  -313,  -332,   202,    11,  -302,
   -1184, -1184, -1184,  1002,   816, -1184, -1184, -1184, -1184, -1184,
   -1184, -1184,   399, -1184, -1184, -1184, -1184, -1184, -1184, -1184,
   -1184, -1184,   -40, -1184,   407,  -483,  -925,  -553,   440, -1184,
    -862, -1184, -1184,  -716,  -297,  -719, -1184, -1184, -1184, -1184,
   -1184, -1184, -1184, -1184, -1184,  -658, -1184, -1184, -1184, -1184,
     338, -1184,  -301, -1184, -1184, -1184, -1184, -1184, -1184,   710,
   -1184,   397,   881,  -271,   715,  -454, -1184, -1184, -1184,  -306,
   -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184, -1184,
   -1184, -1184, -1184, -1184, -1183, -1184,    58, -1184, -1184,    -9,
   -1184, -1184, -1184
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,   162,  1266,   164,   165,   797,   798,   799,  1050,  1183,
     800,  1137,   801,  1068,   639,   166,  1052,   469,   167,  1058,
     335,   336,   337,   952,   953,   680,   988,   989,  1079,   168,
     169,   170,   171,   172,   173,   174,   288,   609,   175,   176,
     177,   178,   343,   664,   665,   981,   179,   634,   635,   631,
     289,   444,   479,  1274,  1275,  1314,  1311,  1308,  1299,  1300,
    1296,  1315,  1244,  1295,  1245,   647,   648,   816,   969,  1230,
     972,   956,   632,   975,  1149,  1072,   181,  1264,   182,   183,
     184,   185,   686,   186,   187,   188,   189,   190,   191,   192,
     705,   193,   194,   548,   195,   196,   197,   198,   393,   199,
     200,   201,   480,   481,   636,   202,   651,   203,   204,   205,
     206,   207,   208,   519,   520,   521,   209,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   219,   220,   221,   222,
     223,   224,   225,   226,   227,   228,   229,   230,   231,   232,
     233,   234,   541,   542,   543,   729,   874,   235,   236,   589,
     870,  1100,   875,   237,   238,  1084,   239,   851,  1085,  1204,
     586,   587,  1154,  1155,  1205,  1206,  1207,   588,   726,   867,
    1097,   727,   868,  1092,  1093,  1221,  1098,  1099,  1168,  1213,
    1170,  1171,  1214,  1276,  1215,  1216,  1222,   305,   306,   744,
     883,   884,   307,   308,   240,   241,   242,   243,   878,   596,
     244,   593,   245,   246,   247,   966,  1199,  1200,   967,   819,
     820,   821,  1201,   292,   293,   294,   739,   295,   553,   296,
     248,   454,   774,   249,   250,   251,   252,   253,   254,   255,
     256,   417,   603,   257,   258,   259,   522,   573,   927,  1127,
     928,   929,   563,   577,   581,   597,   574,   575,   260,   261,
     262,   263,   264,   933,   265,   266,   267,   268,   504,   505,
     506,   269,   985,   270,   271,   272,   273,   274,   275,   491,
     492,   483,   822,   349,   350,   351,   276,   452,   776,   932,
     934,   777,   778,   891,   892,   910,   911,  1033,  1119,   779,
     780,   781,   782,   783,   784,   894,   785,   786,   787,   788,
    1028,   789,   277,   278,   279,   280,   281,   282,   532,   533,
     692,   693,   363,   364,   530,   561,   562,   365,   327,   283,
     970,   954,   284,  1140,   629,   808,   946,  1054,  1193,  1194,
    1262,  1236,  1267,  1303,  1268,  1190,  1191,  1287,  1283,  1284,
    1290,  1286,   463
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     180,   290,   291,   348,   435,   540,   325,   436,   423,   437,
     362,   663,   297,   338,   453,   391,   457,   971,   817,   431,
     379,   644,   879,   346,   667,   668,   669,   431,   380,   447,
     703,   381,   698,   888,   383,   384,   747,  1008,   730,   735,
     983,   900,   485,   500,   502,   902,   903,   906,   888,   914,
     915,   427,   987,   535,   537,   918,   427,  1049,   984,   655,
    1053,   926,   392,   544,   676,   748,   830,   559,   564,   679,
    1045,   578,   633,   582,   683,   551,  1010,   674,   700,   991,
    1026,   585,  1094,   832,   704,  -743,  -745,   950,   163,   287,
    -741,  1129,   529,  1228,  1254,   895,   638,  1302,   429,   470,
     901,   471,  1056,  1231,   912,   638,  -614,   681,  1306,  1304,
     638,  -746,  1167,   317,   733,   805,   650,  1091,   638,   459,
     583,   672,   793,   673,   341,   414,   415,   623,  1077,   957,
    1318,  -174,   824,   703,   320,   810,   814,   341,     7,     8,
       9,    10,    11,   584,   815,  1151,  -136,   298,   833,   888,
     734,   794,   968,   321,   465,  1307,  1078,   448,   342,   347,
     637,   428,  1130,   430,   448,   423,   -90,   640,   449,   951,
    1309,   342,   316,   984,  1077,   449,   387,  1212,   -90,   888,
     888,   652,  1147,   -90,   795,  1310,   450,   704,   423,   806,
    -744,  1249,   311,   450,   666,   -90,  1036,  1038,   888,   846,
    -176,  -176,  1078,   546,   645,   671,   672,   554,   673,   592,
    1042,   796,   961,   807,  1181,   913,   299,  1250,   962,   630,
     -90,  1027,   493,   429,   448,   -90,   318,   844,   625,   494,
     -90,  1229,  1162,   448,   702,   449,  1094,   -90,   448,  1057,
     319,  1229,   -90,   616,   449,   448,   448,   -90,   423,   449,
     392,    29,   610,   450,   392,  1182,   449,   449,   725,   324,
     731,  1212,   450,   529,   443,  1041,   670,   450,   326,   314,
     957,   322,  1172,  1060,   450,   450,   315,   835,  1240,   323,
     460,   461,   672,   464,   673,   290,   291,   311,   430,  1159,
     286,   418,    69,    70,    71,   339,   297,   964,   645,   392,
     412,   413,  1106,  1103,   889,   965,  1110,   646,   890,   418,
     445,   418,  1113,   991,   418,   499,   418,   453,   340,  1037,
     297,  1124,   418,   802,  1208,  -187,  -192,   455,   451,   455,
    -158,  1126,  1061,  1017,  1018,   451,   540,   710,   344,   418,
     637,   418,  1255,  -590,   418,   418,   418,   418,   663,   826,
     477,  -200,   418,  1269,   482,   484,   490,   549,   418,   418,
     418,   387,   527,   496,   497,   498,   387,   501,   503,   523,
     524,   526,   418,   287,   557,   840,   687,   536,   538,   882,
     606,   545,   860,   861,   688,   862,   863,   689,   484,   864,
     690,   691,   865,  1000,   544,  1301,   856,   418,   615,  -158,
    -158,   387,   855,  1176,   387,   712,   685,   387,   418,  1177,
     560,   560,   560,   560,   560,   560,   560,   451,   590,   591,
     898,   880,   536,  1256,   899,  1257,  1258,  1259,   345,   604,
    -205,   347,   641,   607,   458,  1144,   352,   885,  1146,   847,
     -81,  1251,   353,   445,  -530,  -530,  -530,  -530,  -530,  1252,
     904,   916,   355,   297,   905,   917,   300,   -90,   -90,   -90,
     -90,   -90,   -90,  1246,  1055,  1218,   329,   907,   908,  1034,
     560,   361,   528,  1035,   -90,   -90,   -90,   -90,   -90,   -90,
     474,   328,   354,   154,   155,   156,   157,   158,   159,     6,
    -295,   356,     2,   314,     3,     4,   375,   373,   654,   960,
     315,   357,  -504,   658,   637,   375,     7,     8,     9,    10,
      11,   949,   955,   329,   475,   845,   330,    18,  1196,   331,
     815,  -504,   374,  1164,   961,   301,   302,   303,   304,   852,
     962,   666,   527,   358,   709,   347,   526,  1165,   376,   682,
     332,   611,   333,   963,   612,   613,   359,   376,   377,   366,
    1132,   476,   367,   707,    26,   414,   415,  1081,   536,   736,
     737,    30,   392,   330,   334,   881,   331,   -81,  1133,   154,
     155,   156,   157,   158,   159,   368,   392,   418,   710,   775,
     775,   791,    33,   369,  1134,   453,   453,   332,   394,   333,
     395,   396,  1020,   397,   301,   302,   303,   304,    39,    40,
    1247,  1024,  1219,   560,   576,    44,   580,  1030,   370,   964,
     386,   334,   392,   827,   811,   812,    41,   965,   387,  1039,
     960,   378,   443,    45,   398,   536,   818,   482,   872,   873,
     795,   809,   711,   399,     2,  1135,     3,     4,   940,   941,
     802,   640,    67,   406,   640,   961,   675,   672,   286,   673,
     400,   962,   882,   696,   672,   401,   673,   796,   697,   672,
     482,   673,   716,   717,   963,   718,   828,  -360,   829,   402,
    1197,   403,  1088,  1089,  1090,   416,   719,   717,   423,   718,
     626,   627,   628,   836,   837,   838,   404,   839,   484,   841,
     405,   994,   682,   407,   857,   919,   418,   722,   717,   995,
     718,   408,   996,  1003,   409,   997,   998,   410,  1198,   411,
     885,   853,   672,   419,   673,   484,   422,   990,   420,   919,
     536,   993,   858,   859,   424,   560,   560,   425,   560,   560,
     964,   426,   560,  1014,   672,   560,   673,  1121,   965,   438,
    1123,  1015,  1016,  1095,  1096,   536,   640,  1107,  1108,   138,
     139,   140,   141,   142,   143,   144,   145,   146,  1114,  1115,
    1116,  1117,  1118,  1131,   812,  -109,   640,   432,  1157,  1158,
    1184,   433,  1150,  1178,   812,   436,   439,   437,   440,   551,
    1188,  1189,     2,   466,     3,     4,  1202,   812,   446,  1166,
       2,   441,     3,     4,   462,   818,     7,     8,     9,    10,
      11,  1260,  1261,   944,     7,     8,     9,    10,    11,   467,
     154,   155,   156,   157,   158,   159,  1281,   812,   418,  1293,
     812,   468,  1082,   495,   920,   511,   921,   922,  1209,   473,
     992,   472,   923,  1312,   812,  1165,   924,   516,   925,   518,
     960,   977,   531,   960,   539,   982,   547,   960,   920,   511,
     921,   922,    26,   552,   749,  -209,  1125,  -211,   682,   347,
     924,   516,   925,   518,   558,   961,   740,   742,   961,   392,
     602,   962,   961,   608,   962,   750,  -494,   614,   962,  -494,
      33,   741,   741,  -494,   963,   617,   751,   963,   618,   752,
     753,   963,   371,   372,   598,   599,   754,   600,   601,   749,
     660,   662,   619,   755,   620,  1239,   622,   624,   436,  1297,
     437,   621,   630,   643,    41,   756,   649,   653,   656,   659,
     750,    45,   661,   468,   677,  -556,   640,  -557,   757,  -558,
     758,   751,  -553,  -325,   752,   753,   818,   640,  1046,   818,
     818,   754,   759,   684,   528,  -554,   699,  1316,   755,   760,
     964,   990,   701,   964,  -551,   761,   762,   964,   965,   678,
     756,   965,   443,   708,   713,   965,     7,     8,     9,    10,
      11,   714,  -563,   757,  -564,   758,  -565,  -561,  -566,   640,
    -562,  -560,   715,   720,   584,   721,   763,   759,   723,   746,
     724,   728,   732,   743,   760,  1073,   792,   803,   810,   804,
     761,   762,   813,   834,   831,   843,   848,   871,   842,   854,
     869,   876,   866,   645,  1087,   560,   560,   560,   886,   877,
    1101,   887,   893,   896,   897,   888,   909,   938,   930,   935,
     936,   763,   937,   942,   939,   945,   931,   947,   958,   959,
     976,   974,   978,   818,  1001,   474,   818,   138,   139,   140,
     141,   142,   143,   144,   145,   146,  1002,  -590,  1004,  1005,
    1006,  1009,  1019,   679,  1021,  1022,  1013,  1007,  1011,  1023,
    1025,  1012,  1152,  1031,  1032,  1040,  1043,  1047,  1066,  1059,
    1051,  1062,  1065,  1067,  1044,  1064,  1069,  1211,  1070,  1071,
    1074,  1075,   484,  1076,  1083,  1186,  1086,  1102,  1122,  1105,
    1109,  1120,  1128,  1111,  -568,   764,   765,  1138,   812,   766,
     767,  1139,   768,   769,   770,   771,  1143,   772,   773,  1112,
    1142,  1145,  1153,  1160,  1161,  1163,   818,  1179,  1173,  1180,
    1192,  1218,  1203,  1187,  1195,  1219,  1217,  1220,  1223,  1224,
    1227,  1234,  1174,  1175,  1235,  1238,  1241,  1242,  1225,  1248,
     764,   765,  1243,  1263,   766,   767,   968,   768,   769,   770,
     771,   583,   772,   773,  1278,  1279,  1272,  1280,  1273,  1292,
    1282,   560,   360,  1285,  1289,     2,  1298,     3,     4,  1294,
     310,  1226,  1305,  1313,  1048,  1253,  1320,   642,     6,     7,
       8,     9,    10,    11,  1136,    13,  1148,  1080,  1237,  1141,
      14,  1156,   979,   823,   948,    15,   745,  1319,   973,   313,
      16,   706,   555,  1232,   825,   556,    18,    19,   382,  1270,
     385,   849,   850,    21,    22,  1271,  1210,  1169,  1277,  1104,
    1063,   738,   790,   456,  1185,   605,   180,    26,   550,   986,
     594,  1029,   943,   999,   695,     0,   534,   694,  1233,  1288,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      30,    31,    32,     0,  1291,    33,   421,    34,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    37,     0,     0,    38,
       0,     0,   180,     0,     0,     0,     0,    39,    40,    41,
       0,     0,     0,     0,    44,     0,    45,     0,     0,     0,
       0,     0,     0,   180,     0,     0,     0,     0,     0,     0,
      46,    47,    48,    49,    50,    51,    52,   312,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,     0,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,     0,    91,     0,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,   127,   128,   129,   130,   131,   132,
     133,     0,   134,   135,     0,     0,   136,   137,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   138,   139,   140,   141,   142,   143,   144,   145,
     146,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   147,   148,   149,   150,
       0,     0,     0,   151,   152,   153,     0,   285,     0,     0,
       2,     0,     3,     4,     0,     5,     0,     0,     0,     0,
       0,     0,     0,     6,     7,     8,     9,    10,    11,    12,
      13,   160,   161,     0,   478,    14,     0,     0,     0,     0,
      15,     0,     0,     0,     0,    16,     0,     0,     0,    17,
       0,    18,    19,    20,     0,     0,     0,     0,    21,    22,
       0,     0,     0,    23,    24,     0,     0,     0,     0,     0,
       0,    25,    26,    27,     0,     0,     0,     0,     0,     0,
      28,     0,     0,     0,     0,     0,     0,     0,    29,     0,
       0,     0,     0,     0,     0,    30,    31,    32,     0,     0,
      33,     0,    34,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    35,     0,    36,     0,     0,
       0,    37,     0,     0,    38,     0,     0,     0,     0,     0,
       0,     0,    39,    40,    41,     0,    42,     0,    43,    44,
       0,    45,     0,   286,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,     0,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,     0,    91,     0,    92,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,   127,
     128,   129,   130,   131,   132,   133,     0,   134,   135,     0,
       0,   136,   137,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   138,   139,   140,
     141,   142,   143,   144,   145,   146,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   147,   148,   149,   150,     0,     0,     0,   151,   152,
     153,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     154,   155,   156,   157,   158,   159,   160,   161,     1,     0,
       0,     2,     0,     3,     4,     0,     5,     0,     0,     0,
       0,     0,     0,     0,     6,     7,     8,     9,    10,    11,
      12,    13,     0,     0,     0,     0,    14,     0,     0,     0,
       0,    15,     0,     0,     0,     0,    16,     0,     0,     0,
      17,     0,    18,    19,    20,     0,     0,     0,     0,    21,
      22,     0,     0,     0,    23,    24,     0,     0,     0,     0,
       0,     0,    25,    26,    27,     0,     0,     0,     0,     0,
       0,    28,     0,     0,     0,     0,     0,     0,     0,    29,
       0,     0,     0,     0,     0,     0,    30,    31,    32,     0,
       0,    33,     0,    34,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    35,     0,    36,     0,
       0,     0,    37,     0,     0,    38,     0,     0,     0,     0,
       0,     0,     0,    39,    40,    41,     0,    42,     0,    43,
      44,     0,    45,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
       0,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,     0,    91,     0,    92,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
     107,   108,   109,   110,   111,   112,   113,   114,   115,   116,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
     127,   128,   129,   130,   131,   132,   133,     0,   134,   135,
       0,     0,   136,   137,     0,     0,     0,     0,     0,     0,
       0,  1265,     0,     0,     0,     0,     0,     0,   138,   139,
     140,   141,   142,   143,   144,   145,   146,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   147,   148,   149,   150,     0,     0,     0,   151,
     152,   153,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   154,   155,   156,   157,   158,   159,   160,   161,     1,
       0,     0,     2,     0,     3,     4,     0,     5,     0,     0,
       0,     0,     0,     0,     0,     6,     7,     8,     9,    10,
      11,    12,    13,     0,     0,     0,     0,    14,     0,     0,
       0,     0,    15,     0,     0,     0,     0,    16,     0,     0,
       0,    17,     0,    18,    19,    20,     0,     0,     0,     0,
      21,    22,     0,     0,     0,    23,    24,     0,     0,     0,
       0,     0,     0,    25,    26,    27,     0,     0,     0,     0,
       0,     0,    28,     0,     0,     0,     0,     0,     0,     0,
      29,     0,     0,     0,     0,     0,     0,    30,    31,    32,
       0,     0,    33,     0,    34,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,     0,    36,
       0,     0,     0,    37,     0,     0,    38,     0,     0,     0,
       0,     0,     0,     0,    39,    40,    41,     0,    42,     0,
      43,    44,     0,    45,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,     0,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,     0,    91,     0,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,     0,   134,
     135,     0,  1317,   136,   137,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   138,
     139,   140,   141,   142,   143,   144,   145,   146,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   147,   148,   149,   150,     0,     0,     0,
     151,   152,   153,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   154,   155,   156,   157,   158,   159,   160,   161,
       1,     0,     0,     2,     0,     3,     4,     0,     5,     0,
       0,     0,     0,     0,     0,     0,     6,     7,     8,     9,
      10,    11,    12,    13,     0,     0,     0,     0,    14,     0,
       0,     0,     0,    15,     0,     0,     0,     0,    16,     0,
       0,     0,    17,     0,    18,    19,    20,     0,     0,     0,
       0,    21,    22,     0,     0,     0,    23,    24,     0,     0,
       0,     0,     0,     0,    25,    26,    27,     0,     0,     0,
       0,     0,     0,    28,     0,     0,     0,     0,     0,     0,
       0,    29,     0,     0,     0,     0,     0,     0,    30,    31,
      32,     0,     0,    33,     0,    34,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    35,     0,
      36,     0,     0,     0,    37,     0,     0,    38,     0,     0,
       0,     0,     0,     0,     0,    39,    40,    41,     0,    42,
       0,    43,    44,     0,    45,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,     0,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,     0,    91,     0,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,     0,
     134,   135,     0,     0,   136,   137,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     138,   139,   140,   141,   142,   143,   144,   145,   146,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   147,   148,   149,   150,     0,     0,
       0,   151,   152,   153,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   154,   155,   156,   157,   158,   159,   160,
     161,   309,     0,     0,     2,     0,     3,     4,     0,   310,
       0,     0,     0,     0,     0,     0,     0,     6,     7,     8,
       9,    10,    11,   311,    13,     0,     0,     0,     0,    14,
       0,     0,     0,     0,    15,   -70,     0,     0,     0,    16,
       0,     0,     0,     0,     0,    18,    19,     0,     0,     0,
       0,     0,    21,    22,     0,     0,     0,    23,     0,     0,
       0,     0,     0,     0,     0,    25,    26,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   -70,     0,     0,
       0,     0,    29,     0,     0,     0,     0,   -70,     0,    30,
      31,    32,     0,     0,    33,     0,    34,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    37,     0,     0,    38,     0,
       0,     0,     0,     0,     0,     0,    39,    40,    41,     0,
      42,     0,     0,    44,     0,    45,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    46,
      47,    48,    49,    50,    51,    52,   312,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,     0,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,     0,    91,     0,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
       0,   134,   135,     0,     0,   136,   137,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   138,   139,   140,   141,   142,   143,   144,   145,   146,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   147,   148,   149,   150,     0,
       0,     0,   151,   152,   153,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   154,   155,   156,   157,   158,   159,
     160,   161,   442,     0,     0,     2,     0,     3,     4,     0,
     310,     0,     0,     0,     0,     0,     0,     0,     6,     7,
       8,     9,    10,    11,    12,    13,     0,     0,     0,     0,
      14,     0,     0,     0,     0,    15,     0,     0,     0,     0,
      16,     0,     0,     0,     0,     0,    18,    19,     0,     0,
       0,     0,     0,    21,    22,     0,     0,     0,    23,     0,
       0,     0,     0,     0,     0,     0,    25,    26,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    29,     0,     0,     0,     0,     0,     0,
      30,    31,    32,     0,     0,    33,     0,    34,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   443,     0,     0,     0,    37,     0,     0,    38,
       0,     0,     0,     0,     0,     0,     0,    39,    40,    41,
       0,    42,     0,     0,    44,     0,    45,     0,   286,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      46,    47,    48,    49,    50,    51,    52,   312,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,     0,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,     0,    91,     0,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,   127,   128,   129,   130,   131,   132,
     133,     0,   134,   135,     0,     0,   136,   137,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   138,   139,   140,   141,   142,   143,   144,   145,
     146,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   147,   148,   149,   150,
       0,     0,     0,   151,   152,   153,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   154,   155,   156,   157,   158,
     159,   160,   161,   309,     0,     0,     2,     0,     3,     4,
       0,   310,     0,     0,     0,     0,     0,     0,     0,     6,
       7,     8,     9,    10,    11,    12,    13,     0,     0,     0,
       0,    14,     0,     0,     0,     0,    15,     0,     0,     0,
       0,    16,     0,     0,     0,     0,     0,    18,    19,     0,
       0,     0,     0,     0,    21,    22,     0,     0,     0,    23,
       0,     0,     0,     0,     0,     0,     0,    25,    26,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    29,     0,     0,     0,     0,     0,
       0,    30,    31,    32,     0,     0,    33,     0,    34,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    37,     0,     0,
      38,     0,     0,     0,     0,     0,     0,     0,    39,    40,
      41,     0,    42,     0,     0,    44,     0,    45,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    46,    47,    48,    49,    50,    51,    52,   312,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,     0,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,     0,    91,     0,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,   127,   128,   129,   130,   131,
     132,   133,     0,   134,   135,     0,     0,   136,   137,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   138,   139,   140,   141,   142,   143,   144,
     145,   146,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   147,   148,   149,
     150,     0,     0,     0,   151,   152,   153,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   154,   155,   156,   157,
     158,   159,   160,   161,   360,     0,     0,     2,     0,     3,
       4,     0,   310,     0,     0,     0,     0,     0,     0,     0,
       6,     7,     8,     9,    10,    11,   311,    13,     0,     0,
       0,     0,    14,     0,     0,     0,     0,    15,     0,     0,
       0,     0,    16,     0,     0,     0,     0,     0,    18,    19,
       0,     0,     0,     0,     0,    21,    22,     0,     0,     0,
      23,     0,     0,     0,     0,     0,     0,     0,    25,    26,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    29,     0,     0,     0,     0,
       0,     0,    30,    31,    32,     0,     0,    33,     0,    34,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    37,     0,
       0,    38,     0,     0,     0,     0,     0,     0,     0,    39,
      40,    41,     0,    42,     0,     0,    44,     0,    45,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    46,    47,    48,    49,    50,    51,    52,   312,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,     0,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,     0,    91,
       0,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,   108,   109,   110,
     111,   112,   113,   114,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,     0,   134,   135,     0,     0,   136,   137,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   138,   139,   140,   141,   142,   143,
     144,   145,   146,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   147,   148,
     149,   150,     0,     0,     0,   151,   152,   153,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   154,   155,   156,
     157,   158,   159,   160,   161,   360,     0,     0,     2,     0,
       3,     4,     0,   310,     0,     0,     0,     0,     0,     0,
       0,     6,     7,     8,     9,    10,    11,   311,    13,     0,
       0,     0,     0,    14,     0,     0,     0,     0,    15,     0,
       0,     0,     0,    16,     0,     0,     0,     0,     0,    18,
      19,     0,     0,     0,     0,     0,    21,    22,     0,     0,
       0,    23,     0,     0,     0,     0,     0,     0,     0,     0,
      26,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    29,     0,     0,     0,
       0,     0,     0,    30,    31,    32,     0,     0,    33,     0,
      34,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    37,
       0,     0,    38,     0,     0,     0,     0,     0,     0,     0,
      39,    40,    41,     0,     0,     0,     0,    44,     0,    45,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    46,    47,    48,    49,    50,    51,    52,
     312,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,     0,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,     0,
      91,     0,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,     0,   134,   135,     0,     0,   136,
     137,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   138,   139,   140,   141,   142,
     143,   144,   145,   146,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   147,
     148,   149,   150,     0,     0,     0,   151,   152,   153,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   154,   155,
     156,   157,   158,   159,   160,   161,   360,     0,     0,     2,
       0,     3,     4,     0,   310,     0,     0,     0,     0,     0,
       0,     0,     6,     7,     8,     9,    10,    11,     0,    13,
       0,     0,     0,     0,    14,     0,     0,     0,     0,    15,
       0,     0,     0,     0,    16,     0,     0,     0,     0,     0,
      18,    19,     0,     0,     0,     0,     0,    21,   507,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    26,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    30,    31,    32,     0,     0,    33,
       0,    34,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      37,     0,     0,    38,     0,     0,     0,   508,   509,     0,
       0,    39,    40,    41,     0,     0,     0,     0,    44,     0,
      45,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    46,    47,    48,    49,    50,    51,
      52,   312,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,   510,   511,   512,
     513,    82,    83,    84,    85,   514,    87,    88,    89,   515,
     516,   517,   518,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,     0,   134,   135,     0,     0,
     136,   137,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   138,   139,   140,   141,
     142,   143,   144,   145,   146,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     147,   148,   149,   150,     0,     0,     0,   151,   152,   153,
     360,     0,     0,     2,     0,     3,     4,     0,   310,     0,
       0,     0,     0,     0,     0,     0,     6,     7,     8,     9,
      10,    11,     0,    13,     0,   160,   161,     0,    14,     0,
       0,     0,     0,    15,     0,     0,   486,     0,    16,     0,
       0,     0,     0,     0,    18,    19,     0,     0,     0,     0,
       0,    21,    22,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    26,     0,     0,     0,     0,
       0,   487,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   488,     0,     0,    30,    31,
      32,     0,     0,    33,     0,    34,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    37,     0,     0,    38,     0,     0,
       0,     0,     0,     0,   489,    39,    40,    41,     0,     0,
       0,     0,    44,     0,    45,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    46,    47,
      48,    49,    50,    51,    52,   312,    54,    55,    56,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,     0,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,     0,    91,     0,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,     0,
     134,   135,     0,     0,   136,   137,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     138,   139,   140,   141,   142,   143,   144,   145,   146,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   147,   148,   149,   150,     0,     0,
       0,   151,   152,   153,   360,     0,     0,     2,     0,     3,
       4,     0,   310,     0,     0,     0,     0,     0,     0,     0,
       6,     7,     8,     9,    10,    11,     0,    13,     0,   160,
     161,     0,    14,     0,     0,     0,     0,    15,     0,     0,
       0,     0,    16,     0,     0,     0,     0,     0,    18,    19,
       0,     0,     0,     0,     0,    21,    22,     0,     0,     0,
      23,     0,     0,     0,     0,     0,     0,     0,     0,    26,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,    31,    32,     0,     0,    33,     0,    34,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    37,     0,
       0,    38,     0,     0,     0,     0,     0,     0,     0,    39,
      40,    41,     0,     0,     0,     0,    44,     0,    45,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    46,    47,    48,    49,    50,    51,    52,   312,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,     0,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,     0,    91,
       0,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,   108,   109,   110,
     111,   112,   113,   114,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,     0,   134,   135,     0,     0,   136,   137,
     361,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   138,   139,   140,   141,   142,   143,
     144,   145,   146,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   147,   148,
     149,   150,     0,     0,     0,   151,   152,   153,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   360,
       0,     0,     2,     0,     3,     4,     0,   310,     0,     0,
       0,     0,     0,   160,   161,     6,     7,     8,     9,    10,
      11,     0,    13,     0,   388,     0,     0,   389,     0,     0,
       0,     0,    15,     0,     0,     0,     0,    16,     0,     0,
       0,     0,     0,    18,    19,     0,     0,     0,     0,     0,
      21,    22,     0,     0,     0,    23,     0,     0,     0,     0,
       0,     0,     0,     0,    26,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,    31,    32,
       0,     0,    33,     0,    34,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   390,     0,     0,    38,     0,     0,     0,
       0,     0,     0,     0,    39,    40,    41,     0,     0,     0,
       0,    44,     0,    45,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    46,    47,    48,
      49,    50,    51,    52,   312,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,     0,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,     0,    91,     0,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,     0,   134,
     135,     0,     0,   136,   137,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   138,
     139,   140,   141,   142,   143,   144,   145,   146,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   147,   148,   149,   150,     0,     0,     0,
     151,   152,   153,   525,     0,     0,     2,     0,     3,     4,
       0,   310,     0,     0,     0,     0,     0,     0,     0,     6,
       7,     8,     9,    10,    11,     0,    13,     0,   160,   161,
       0,    14,     0,     0,     0,     0,    15,     0,     0,     0,
       0,    16,     0,     0,     0,     0,     0,    18,    19,     0,
       0,     0,     0,     0,    21,    22,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    26,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    30,    31,    32,     0,     0,    33,     0,    34,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   443,     0,     0,     0,    37,     0,     0,
      38,     0,     0,     0,     0,     0,     0,     0,    39,    40,
      41,     0,     0,     0,     0,    44,     0,    45,     0,   286,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    46,    47,    48,    49,    50,    51,    52,   312,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,     0,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,     0,    91,     0,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,   127,   128,   129,   130,   131,
     132,   133,     0,   134,   135,     0,     0,   136,   137,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   138,   139,   140,   141,   142,   143,   144,
     145,   146,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   147,   148,   149,
     150,     0,     0,     0,   151,   152,   153,   360,   579,     0,
       2,     0,     3,     4,     0,   310,     0,     0,     0,     0,
       0,     0,     0,     6,     7,     8,     9,    10,    11,     0,
      13,     0,   160,   161,     0,    14,     0,     0,     0,     0,
      15,     0,     0,     0,     0,    16,     0,     0,     0,     0,
       0,    18,    19,     0,     0,     0,     0,     0,    21,   565,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    26,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    30,    31,    32,     0,     0,
      33,     0,    34,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    37,     0,     0,    38,     0,     0,     0,     0,     0,
       0,     0,    39,    40,    41,     0,     0,     0,     0,    44,
       0,    45,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    46,    47,    48,    49,    50,
      51,    52,   312,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,   566,   567,
     568,   569,    82,    83,    84,    85,   570,    87,    88,    89,
     571,     0,   572,     0,    92,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,   127,
     128,   129,   130,   131,   132,   133,     0,   134,   135,     0,
       0,   136,   137,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   138,   139,   140,
     141,   142,   143,   144,   145,   146,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   147,   148,   149,   150,     0,     0,     0,   151,   152,
     153,   360,     0,     0,     2,     0,     3,     4,     0,   310,
       0,     0,     0,     0,     0,     0,     0,     6,     7,     8,
       9,    10,    11,     0,    13,     0,   160,   161,     0,    14,
       0,     0,     0,     0,    15,     0,     0,     0,     0,    16,
       0,     0,     0,     0,     0,    18,    19,     0,     0,     0,
       0,     0,    21,    22,     0,     0,     0,    23,     0,     0,
       0,     0,     0,     0,     0,     0,    26,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    30,
      31,    32,     0,     0,    33,     0,    34,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    37,     0,     0,    38,     0,
       0,     0,     0,     0,     0,     0,    39,    40,    41,     0,
       0,     0,     0,    44,     0,    45,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    46,
      47,    48,    49,    50,    51,    52,   312,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,     0,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,     0,    91,     0,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
       0,   134,   135,     0,     0,   136,   137,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   138,   139,   140,   141,   142,   143,   144,   145,   146,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   147,   148,   149,   150,     0,
       0,     0,   151,   152,   153,   360,     0,     0,     2,     0,
       3,     4,     0,   310,     0,     0,     0,     0,     0,     0,
       0,     6,     7,     8,     9,    10,    11,     0,    13,     0,
     160,   161,     0,    14,     0,     0,     0,     0,    15,     0,
       0,     0,     0,    16,     0,     0,     0,     0,     0,    18,
      19,     0,     0,     0,     0,     0,    21,   565,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      26,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    30,    31,    32,     0,     0,    33,     0,
      34,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    37,
       0,     0,    38,     0,     0,     0,     0,     0,     0,     0,
      39,    40,    41,     0,     0,     0,     0,    44,     0,    45,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    46,    47,    48,    49,    50,    51,    52,
     312,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,   566,   567,   568,   569,
      82,    83,    84,    85,   570,    87,    88,    89,   571,     0,
     572,     0,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,     0,   134,   135,     0,     0,   136,
     137,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   138,   139,   140,   141,   142,
     143,   144,   145,   146,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   147,
     148,   149,   150,     0,     0,     0,   151,   152,   153,   360,
     595,     0,     2,     0,     3,     4,     0,   310,     0,     0,
       0,     0,     0,     0,     0,     6,     7,     8,     9,    10,
      11,     0,    13,     0,   160,   161,     0,    14,     0,     0,
       0,     0,    15,     0,     0,     0,     0,    16,     0,     0,
       0,     0,     0,    18,    19,     0,     0,     0,     0,     0,
      21,    22,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    26,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,    31,    32,
       0,     0,    33,     0,    34,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    37,     0,     0,    38,     0,     0,     0,
       0,     0,     0,     0,    39,    40,    41,     0,     0,     0,
       0,    44,     0,    45,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    46,    47,    48,
      49,    50,    51,    52,   312,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,     0,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,     0,    91,     0,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,     0,   134,
     135,     0,     0,   136,   137,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   138,
     139,   140,   141,   142,   143,   144,   145,   146,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   147,   148,   149,   150,     0,     0,     0,
     151,   152,   153,   360,     0,     0,     2,     0,     3,     4,
       0,   310,     0,     0,     0,     0,     0,     0,     0,     6,
       7,     8,     9,    10,    11,     0,    13,     0,   160,   161,
       0,    14,     0,     0,     0,     0,    15,     0,     0,     0,
       0,    16,     0,     0,     0,     0,     0,    18,    19,     0,
       0,     0,     0,     0,    21,    22,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    26,     0,
       0,     0,     0,     0,   657,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    30,    31,    32,     0,     0,    33,     0,    34,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    37,     0,     0,
      38,     0,     0,     0,     0,     0,     0,     0,    39,    40,
      41,     0,     0,     0,     0,    44,     0,    45,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    46,    47,    48,    49,    50,    51,    52,   312,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,     0,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,     0,    91,     0,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,   127,   128,   129,   130,   131,
     132,   133,     0,   134,   135,     0,     0,   136,   137,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   138,   139,   140,   141,   142,   143,   144,
     145,   146,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   147,   148,   149,
     150,     0,     0,     0,   151,   152,   153,   360,     0,     0,
       2,     0,     3,     4,     0,   310,     0,     0,     0,     0,
       0,     0,     0,     6,     7,     8,     9,    10,    11,     0,
      13,     0,   160,   161,     0,    14,     0,     0,     0,     0,
      15,     0,     0,     0,     0,    16,     0,     0,     0,     0,
       0,    18,    19,     0,     0,     0,     0,     0,    21,    22,
       0,     0,     0,   980,     0,     0,     0,     0,     0,     0,
       0,     0,    26,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    30,    31,    32,     0,     0,
      33,     0,    34,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    37,     0,     0,    38,     0,     0,     0,     0,     0,
       0,     0,    39,    40,    41,     0,     0,     0,     0,    44,
       0,    45,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    46,    47,    48,    49,    50,
      51,    52,   312,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,     0,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,     0,    91,     0,    92,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,   127,
     128,   129,   130,   131,   132,   133,     0,   134,   135,     0,
       0,   136,   137,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   138,   139,   140,
     141,   142,   143,   144,   145,   146,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   147,   148,   149,   150,     0,     0,     0,   151,   152,
     153,   360,     0,     0,     2,     0,     3,     4,     0,   310,
       0,     0,     0,     0,     0,     0,     0,     6,     7,     8,
       9,    10,    11,     0,    13,     0,   160,   161,     0,    14,
       0,     0,     0,     0,    15,     0,     0,     0,     0,    16,
       0,     0,     0,     0,     0,    18,    19,     0,     0,     0,
       0,     0,    21,    22,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    26,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    30,
      31,    32,     0,     0,    33,     0,    34,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    37,     0,     0,    38,     0,
       0,     0,     0,     0,     0,     0,    39,    40,    41,     0,
       0,     0,     0,    44,     0,    45,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    46,
      47,    48,    49,    50,    51,    52,   312,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,     0,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,     0,    91,     0,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
       0,   134,   135,     0,     0,   136,   137,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   138,   139,   140,   141,   142,   143,   144,   145,   146,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   147,   148,   149,   150,     0,
       0,     0,   151,   152,   153,   360,     0,     0,     2,     0,
       3,     4,     0,   310,     0,     0,     0,     0,     0,     0,
       0,     0,     7,     8,     9,    10,    11,     0,    13,     0,
     160,   161,     0,    14,     0,     0,     0,     0,    15,     0,
       0,     0,     0,    16,     0,     0,     0,     0,     0,     0,
      19,     0,     0,     0,     0,     0,    21,    22,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      26,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    31,    32,     0,     0,    33,     0,
      34,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    37,
       0,     0,    38,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,     0,     0,     0,     0,     0,     0,    45,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    46,    47,    48,    49,    50,    51,    52,
     312,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,     0,    68,     0,     0,     0,    72,
      73,    74,    75,    76,    77,    78,    79,     0,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,     0,
      91,     0,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,     0,   134,   135,     0,     0,   136,
     137,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   138,   139,   140,   141,   142,
     143,   144,   145,   146,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   147,
     148,   149,   150,     0,     0,     0,   151,   152,   153,   360,
       0,     0,     2,     0,     3,     4,     0,   310,     0,     0,
       0,     0,     0,     0,     0,     0,     7,     8,     9,    10,
      11,     0,    13,     0,   160,   161,     0,    14,     0,     0,
       0,     0,    15,     0,     0,     0,     0,    16,     0,     0,
       0,     0,     0,     0,    19,     0,     0,     0,     0,     0,
      21,    22,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    26,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    31,    32,
       0,     0,    33,     0,    34,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    37,     0,     0,    38,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,     0,     0,     0,
       0,     0,     0,    45,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    46,    47,    48,
      49,    50,    51,    52,   312,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,     0,    68,
       0,     0,     0,    72,    73,    74,    75,    76,    77,    78,
      79,     0,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,     0,    91,     0,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,     0,   134,
     135,     0,     0,   136,   137,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   310,     0,     0,   138,
     139,   140,   141,   142,   143,   144,   145,   146,     0,     0,
       0,    13,     0,     0,     0,     0,    14,     0,     0,     0,
       0,    15,     0,   147,   148,   149,   150,     0,     0,     0,
     151,   152,   153,    19,     0,     0,     0,     0,     0,    21,
      22,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    31,    32,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    37,     0,     0,    38,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    46,     0,    48,   448,
       0,    51,    52,   312,    54,    55,    56,    57,    58,    59,
     449,    61,    62,    63,    64,    65,    66,     0,    68,     0,
       0,     0,    72,    73,    74,    75,    76,    77,   450,    79,
       0,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,     0,    91,     0,    92,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
     107,   108,   109,   110,   111,   112,   113,   114,   115,   116,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
     127,   128,   129,   130,   131,   132,   133,   310,   134,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   434,     0,     0,     0,     0,    14,     0,     0,
       0,     0,    15,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    19,     0,     0,     0,     0,     0,
      21,    22,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    31,    32,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    37,     0,     0,    38,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    46,     0,    48,
       0,     0,    51,    52,   312,    54,    55,    56,    57,    58,
      59,     0,    61,    62,    63,    64,    65,    66,     0,    68,
       0,     0,     0,    72,    73,    74,    75,    76,    77,     0,
      79,     0,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,     0,    91,     0,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,     0,   134
};

static const yytype_int16 yycheck[] =
{
       0,     1,     1,    43,   302,   369,    25,   302,   285,   302,
     135,   494,     1,    29,   315,   187,   318,   822,   645,     4,
     175,     4,   733,    42,     4,     4,     4,     4,   175,    26,
      11,   175,     4,     3,   175,   175,    26,   867,     4,     4,
       4,   757,   344,   356,   357,   761,   762,   763,     3,   768,
     769,     4,     4,   366,   367,   771,     4,   942,    71,    74,
     945,   773,   187,   369,    74,   618,    74,   399,   400,   102,
     932,   403,   465,   405,   528,   377,   871,    79,     5,   842,
     142,   406,  1007,     5,    65,     5,     5,    26,     0,     1,
       5,     4,   363,   121,     4,   753,    26,     4,    66,   332,
     758,   334,     5,   121,    42,    26,     4,   245,   259,  1292,
      26,     5,  1099,   143,     4,    60,    32,    26,    26,   319,
       3,     5,    43,     7,    28,   322,   323,   459,    33,   814,
    1313,   245,   648,    11,   121,     5,     3,    28,    20,    21,
      22,    23,    24,    26,    11,  1070,    26,    26,   664,     3,
      40,    72,    32,   140,     3,   306,    61,   154,    62,    26,
     466,     4,  1047,   131,   154,   442,    25,   468,   165,   108,
     297,    62,     3,    71,    33,   165,   314,  1164,    37,     3,
       3,   482,  1067,    25,   105,   312,   183,    65,   465,   134,
       5,    51,    25,   183,   495,    37,   912,   913,     3,     5,
     314,   315,    61,   375,    74,     4,     5,   379,     7,   409,
     926,   132,    75,   158,    96,   153,    26,    77,    81,   141,
      79,   283,     6,    66,   154,    84,     3,   681,   461,    13,
      89,   259,  1094,   154,   547,   165,  1161,    79,   154,   142,
       3,   259,    84,   443,   165,   154,   154,    89,   525,   165,
     375,    84,   424,   183,   379,   137,   165,   165,   583,     3,
     592,  1248,   183,   534,   113,   923,   499,   183,    26,     6,
     955,   258,  1102,   958,   183,   183,    13,   670,  1203,    74,
     320,   321,     5,   323,     7,   285,   285,    25,   131,  1084,
     139,   324,   174,   175,   176,     3,   285,   160,    74,   424,
     325,   326,  1021,  1014,   274,   168,  1025,    83,   278,   324,
     309,   324,  1031,  1076,   324,   355,   324,   618,   143,   274,
     309,  1040,   324,   624,  1154,   245,   245,   316,   325,   318,
     245,  1043,   959,   886,   887,   325,   700,    84,     3,   324,
     646,   324,  1227,   324,   324,   324,   324,   324,   831,   650,
     339,   245,   324,  1238,   343,   344,   345,   376,   324,   324,
     324,   314,   361,   352,   353,   354,   314,   356,   357,   358,
     359,   360,   324,   285,   393,   677,   531,   366,   367,   743,
     420,   370,   714,   715,   531,   717,   718,   531,   377,   721,
     531,   531,   724,   847,   700,  1280,   709,   324,   438,   314,
     315,   314,   704,  1122,   314,   560,   531,   314,   324,  1125,
     399,   400,   401,   402,   403,   404,   405,   325,   407,   408,
     274,   734,   411,  1228,   278,  1230,  1231,  1232,     3,   418,
     245,    26,   472,   422,   325,  1062,     3,   743,  1065,   245,
       4,   301,     3,   442,   322,   323,   324,   325,   326,   309,
     274,   274,    83,   442,   278,   278,     8,   316,   317,   318,
     319,   320,   321,   302,   947,   304,    60,   764,   765,   274,
     459,   249,   250,   278,   316,   317,   318,   319,   320,   321,
      62,    28,     3,   316,   317,   318,   319,   320,   321,    19,
       3,     3,     6,     6,     8,     9,    37,     0,   487,    50,
      13,     3,    66,   492,   810,    37,    20,    21,    22,    23,
      24,   812,     3,    60,    96,   687,   110,    47,  1145,   113,
      11,    85,     7,    37,    75,   146,   147,   148,   149,   701,
      81,   832,   531,     3,    40,    26,   525,    51,    79,   528,
     134,   426,   136,    94,   429,   430,     3,    79,    89,     3,
      25,   133,     3,   553,    68,   322,   323,    89,   547,     4,
       5,    91,   687,   110,   158,   737,   113,   131,    43,   316,
     317,   318,   319,   320,   321,     3,   701,   324,    84,   619,
     620,   621,    96,     3,    59,   886,   887,   134,    19,   136,
      21,    22,   889,    24,   146,   147,   148,   149,   128,   129,
     302,   898,   304,   592,   402,   135,   404,   904,     3,   160,
     315,   158,   737,   653,     4,     5,   130,   168,   314,   916,
      50,   131,   113,   137,     3,   614,   645,   616,   291,   292,
     105,   630,   138,     3,     6,   110,     8,     9,     4,     5,
     941,   942,   172,   286,   945,    75,     4,     5,   139,     7,
       3,    81,  1016,     4,     5,     3,     7,   132,     4,     5,
     649,     7,     4,     5,    94,     7,   655,   286,   657,     3,
     100,     3,  1004,  1005,  1006,    34,     4,     5,   955,     7,
     251,   252,   253,   672,   673,   674,     3,   676,   677,   678,
       3,   846,   681,     3,   710,    55,   324,     4,     5,   846,
       7,     3,   846,   858,     3,   846,   846,     3,   138,     3,
    1016,     4,     5,   322,     7,   704,     3,   842,    44,    55,
     709,   846,   711,   712,     3,   714,   715,     4,   717,   718,
     160,    85,   721,     4,     5,   724,     7,  1034,   168,   145,
    1037,     4,     5,   305,   306,   734,  1047,     4,     5,   263,
     264,   265,   266,   267,   268,   269,   270,   271,    14,    15,
      16,    17,    18,     4,     5,    85,  1067,    10,   297,   298,
    1134,   321,  1070,     4,     5,  1070,    12,  1070,    12,  1081,
     261,   262,     6,    83,     8,     9,     4,     5,    26,   303,
       6,    19,     8,     9,    26,   814,    20,    21,    22,    23,
      24,   259,   260,   803,    20,    21,    22,    23,    24,   106,
     316,   317,   318,   319,   320,   321,     4,     5,   324,     4,
       5,     3,   994,   114,   184,   185,   186,   187,  1160,     5,
     846,   100,   192,     4,     5,    51,   196,   197,   198,   199,
      50,   830,   249,    50,     4,   834,     3,    50,   184,   185,
     186,   187,    68,    28,    21,     3,   192,     3,   847,    26,
     196,   197,   198,   199,     4,    75,   612,   613,    75,   994,
      90,    81,    75,     4,    81,    42,    86,     3,    81,    86,
      96,   612,   613,    86,    94,    13,    53,    94,    13,    56,
      57,    94,   160,   161,   412,   413,    63,   414,   415,    21,
     493,   494,    32,    70,     5,  1203,     4,     3,  1203,  1273,
    1203,   138,   141,    74,   130,    82,     5,   138,     4,    26,
      42,   137,    26,     3,    74,    74,  1227,    74,    95,    74,
      97,    53,    74,     3,    56,    57,   955,  1238,   937,   958,
     959,    63,   109,   246,   250,    74,     4,  1311,    70,   116,
     160,  1076,   315,   160,    74,   122,   123,   160,   168,    74,
      82,   168,   113,     4,     4,   168,    20,    21,    22,    23,
      24,     5,     5,    95,     5,    97,     5,     5,     5,  1280,
       5,     5,     5,     4,    26,     5,   153,   109,     4,    26,
       5,     5,     4,     3,   116,   984,     4,    32,     5,    99,
     122,   123,   126,   321,    13,     4,   246,     4,    40,    65,
      23,     4,   307,    74,  1003,  1004,  1005,  1006,    13,   242,
    1009,    13,     3,   104,     3,     3,     3,    87,     4,     4,
       4,   153,     3,     3,    87,    99,    42,   100,   150,     5,
       4,    77,    26,  1062,     4,    62,  1065,   263,   264,   265,
     266,   267,   268,   269,   270,   271,    19,   324,     5,     5,
       5,     5,    23,   102,   275,    23,    77,    40,   293,    23,
     275,   293,  1071,   275,    23,   275,   126,     3,    26,     4,
     142,    86,    86,     3,   114,   103,    26,   303,    40,    78,
       4,     4,  1081,     5,    74,  1135,    12,     3,   275,     4,
       4,     4,    26,   122,   126,   272,   273,    43,     5,   276,
     277,   255,   279,   280,   281,   282,    12,   284,   285,   122,
      76,    86,   308,     5,     5,     4,  1145,    96,    23,     3,
      71,   304,     5,   101,   101,   304,   259,   299,     4,     4,
       3,   254,   144,   144,   249,     3,     5,    32,   110,   315,
     272,   273,   310,     3,   276,   277,    32,   279,   280,   281,
     282,     3,   284,   285,   259,   300,    23,     3,   311,   257,
      26,  1160,     3,    26,    26,     6,    69,     8,     9,   311,
      11,  1180,    23,     7,   941,  1225,   313,   473,    19,    20,
      21,    22,    23,    24,  1050,    26,  1069,   991,  1197,  1056,
      31,  1076,   832,   646,   810,    36,   616,  1314,   823,    12,
      41,   551,   386,  1189,   649,   387,    47,    48,   175,  1241,
     175,   700,   700,    54,    55,  1242,  1161,  1099,  1248,  1016,
     963,   611,   620,   318,  1134,   419,  1236,    68,   377,   840,
     410,   903,   802,   846,   534,    -1,   365,   532,  1190,  1258,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    92,    93,    -1,  1263,    96,   264,    98,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   117,    -1,    -1,   120,
      -1,    -1,  1292,    -1,    -1,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,    -1,   135,    -1,   137,    -1,    -1,    -1,
      -1,    -1,    -1,  1313,    -1,    -1,    -1,    -1,    -1,    -1,
     151,   152,   153,   154,   155,   156,   157,   158,   159,   160,
     161,   162,   163,   164,   165,   166,   167,   168,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   180,
     181,   182,   183,   184,    -1,   186,   187,   188,   189,   190,
     191,   192,   193,   194,   195,   196,    -1,   198,    -1,   200,
     201,   202,   203,   204,   205,   206,   207,   208,   209,   210,
     211,   212,   213,   214,   215,   216,   217,   218,   219,   220,
     221,   222,   223,   224,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,    -1,   243,   244,    -1,    -1,   247,   248,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   263,   264,   265,   266,   267,   268,   269,   270,
     271,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   287,   288,   289,   290,
      -1,    -1,    -1,   294,   295,   296,    -1,     3,    -1,    -1,
       6,    -1,     8,     9,    -1,    11,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    19,    20,    21,    22,    23,    24,    25,
      26,   322,   323,    -1,   325,    31,    -1,    -1,    -1,    -1,
      36,    -1,    -1,    -1,    -1,    41,    -1,    -1,    -1,    45,
      -1,    47,    48,    49,    -1,    -1,    -1,    -1,    54,    55,
      -1,    -1,    -1,    59,    60,    -1,    -1,    -1,    -1,    -1,
      -1,    67,    68,    69,    -1,    -1,    -1,    -1,    -1,    -1,
      76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    84,    -1,
      -1,    -1,    -1,    -1,    -1,    91,    92,    93,    -1,    -1,
      96,    -1,    98,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   111,    -1,   113,    -1,    -1,
      -1,   117,    -1,    -1,   120,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   128,   129,   130,    -1,   132,    -1,   134,   135,
      -1,   137,    -1,   139,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   151,   152,   153,   154,   155,
     156,   157,   158,   159,   160,   161,   162,   163,   164,   165,
     166,   167,   168,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   180,   181,   182,   183,   184,    -1,
     186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
     196,    -1,   198,    -1,   200,   201,   202,   203,   204,   205,
     206,   207,   208,   209,   210,   211,   212,   213,   214,   215,
     216,   217,   218,   219,   220,   221,   222,   223,   224,   225,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
     236,   237,   238,   239,   240,   241,    -1,   243,   244,    -1,
      -1,   247,   248,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   263,   264,   265,
     266,   267,   268,   269,   270,   271,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   287,   288,   289,   290,    -1,    -1,    -1,   294,   295,
     296,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     316,   317,   318,   319,   320,   321,   322,   323,     3,    -1,
      -1,     6,    -1,     8,     9,    -1,    11,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    19,    20,    21,    22,    23,    24,
      25,    26,    -1,    -1,    -1,    -1,    31,    -1,    -1,    -1,
      -1,    36,    -1,    -1,    -1,    -1,    41,    -1,    -1,    -1,
      45,    -1,    47,    48,    49,    -1,    -1,    -1,    -1,    54,
      55,    -1,    -1,    -1,    59,    60,    -1,    -1,    -1,    -1,
      -1,    -1,    67,    68,    69,    -1,    -1,    -1,    -1,    -1,
      -1,    76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    84,
      -1,    -1,    -1,    -1,    -1,    -1,    91,    92,    93,    -1,
      -1,    96,    -1,    98,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   111,    -1,   113,    -1,
      -1,    -1,   117,    -1,    -1,   120,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   128,   129,   130,    -1,   132,    -1,   134,
     135,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
      -1,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,    -1,   198,    -1,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,    -1,   243,   244,
      -1,    -1,   247,   248,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   256,    -1,    -1,    -1,    -1,    -1,    -1,   263,   264,
     265,   266,   267,   268,   269,   270,   271,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   287,   288,   289,   290,    -1,    -1,    -1,   294,
     295,   296,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   316,   317,   318,   319,   320,   321,   322,   323,     3,
      -1,    -1,     6,    -1,     8,     9,    -1,    11,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    19,    20,    21,    22,    23,
      24,    25,    26,    -1,    -1,    -1,    -1,    31,    -1,    -1,
      -1,    -1,    36,    -1,    -1,    -1,    -1,    41,    -1,    -1,
      -1,    45,    -1,    47,    48,    49,    -1,    -1,    -1,    -1,
      54,    55,    -1,    -1,    -1,    59,    60,    -1,    -1,    -1,
      -1,    -1,    -1,    67,    68,    69,    -1,    -1,    -1,    -1,
      -1,    -1,    76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      84,    -1,    -1,    -1,    -1,    -1,    -1,    91,    92,    93,
      -1,    -1,    96,    -1,    98,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   111,    -1,   113,
      -1,    -1,    -1,   117,    -1,    -1,   120,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   128,   129,   130,    -1,   132,    -1,
     134,   135,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   151,   152,   153,
     154,   155,   156,   157,   158,   159,   160,   161,   162,   163,
     164,   165,   166,   167,   168,   169,   170,   171,   172,   173,
     174,   175,   176,   177,   178,   179,   180,   181,   182,   183,
     184,    -1,   186,   187,   188,   189,   190,   191,   192,   193,
     194,   195,   196,    -1,   198,    -1,   200,   201,   202,   203,
     204,   205,   206,   207,   208,   209,   210,   211,   212,   213,
     214,   215,   216,   217,   218,   219,   220,   221,   222,   223,
     224,   225,   226,   227,   228,   229,   230,   231,   232,   233,
     234,   235,   236,   237,   238,   239,   240,   241,    -1,   243,
     244,    -1,   246,   247,   248,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   263,
     264,   265,   266,   267,   268,   269,   270,   271,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   287,   288,   289,   290,    -1,    -1,    -1,
     294,   295,   296,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
       3,    -1,    -1,     6,    -1,     8,     9,    -1,    11,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    19,    20,    21,    22,
      23,    24,    25,    26,    -1,    -1,    -1,    -1,    31,    -1,
      -1,    -1,    -1,    36,    -1,    -1,    -1,    -1,    41,    -1,
      -1,    -1,    45,    -1,    47,    48,    49,    -1,    -1,    -1,
      -1,    54,    55,    -1,    -1,    -1,    59,    60,    -1,    -1,
      -1,    -1,    -1,    -1,    67,    68,    69,    -1,    -1,    -1,
      -1,    -1,    -1,    76,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    84,    -1,    -1,    -1,    -1,    -1,    -1,    91,    92,
      93,    -1,    -1,    96,    -1,    98,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   111,    -1,
     113,    -1,    -1,    -1,   117,    -1,    -1,   120,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   128,   129,   130,    -1,   132,
      -1,   134,   135,    -1,   137,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   151,   152,
     153,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   167,   168,   169,   170,   171,   172,
     173,   174,   175,   176,   177,   178,   179,   180,   181,   182,
     183,   184,    -1,   186,   187,   188,   189,   190,   191,   192,
     193,   194,   195,   196,    -1,   198,    -1,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   209,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   219,   220,   221,   222,
     223,   224,   225,   226,   227,   228,   229,   230,   231,   232,
     233,   234,   235,   236,   237,   238,   239,   240,   241,    -1,
     243,   244,    -1,    -1,   247,   248,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     263,   264,   265,   266,   267,   268,   269,   270,   271,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   287,   288,   289,   290,    -1,    -1,
      -1,   294,   295,   296,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   316,   317,   318,   319,   320,   321,   322,
     323,     3,    -1,    -1,     6,    -1,     8,     9,    -1,    11,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    19,    20,    21,
      22,    23,    24,    25,    26,    -1,    -1,    -1,    -1,    31,
      -1,    -1,    -1,    -1,    36,    37,    -1,    -1,    -1,    41,
      -1,    -1,    -1,    -1,    -1,    47,    48,    -1,    -1,    -1,
      -1,    -1,    54,    55,    -1,    -1,    -1,    59,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    67,    68,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,    -1,    -1,
      -1,    -1,    84,    -1,    -1,    -1,    -1,    89,    -1,    91,
      92,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   117,    -1,    -1,   120,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   128,   129,   130,    -1,
     132,    -1,    -1,   135,    -1,   137,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   151,
     152,   153,   154,   155,   156,   157,   158,   159,   160,   161,
     162,   163,   164,   165,   166,   167,   168,   169,   170,   171,
     172,   173,   174,   175,   176,   177,   178,   179,   180,   181,
     182,   183,   184,    -1,   186,   187,   188,   189,   190,   191,
     192,   193,   194,   195,   196,    -1,   198,    -1,   200,   201,
     202,   203,   204,   205,   206,   207,   208,   209,   210,   211,
     212,   213,   214,   215,   216,   217,   218,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
      -1,   243,   244,    -1,    -1,   247,   248,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   263,   264,   265,   266,   267,   268,   269,   270,   271,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   287,   288,   289,   290,    -1,
      -1,    -1,   294,   295,   296,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   316,   317,   318,   319,   320,   321,
     322,   323,     3,    -1,    -1,     6,    -1,     8,     9,    -1,
      11,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    19,    20,
      21,    22,    23,    24,    25,    26,    -1,    -1,    -1,    -1,
      31,    -1,    -1,    -1,    -1,    36,    -1,    -1,    -1,    -1,
      41,    -1,    -1,    -1,    -1,    -1,    47,    48,    -1,    -1,
      -1,    -1,    -1,    54,    55,    -1,    -1,    -1,    59,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    67,    68,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    84,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    92,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   113,    -1,    -1,    -1,   117,    -1,    -1,   120,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   128,   129,   130,
      -1,   132,    -1,    -1,   135,    -1,   137,    -1,   139,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     151,   152,   153,   154,   155,   156,   157,   158,   159,   160,
     161,   162,   163,   164,   165,   166,   167,   168,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   180,
     181,   182,   183,   184,    -1,   186,   187,   188,   189,   190,
     191,   192,   193,   194,   195,   196,    -1,   198,    -1,   200,
     201,   202,   203,   204,   205,   206,   207,   208,   209,   210,
     211,   212,   213,   214,   215,   216,   217,   218,   219,   220,
     221,   222,   223,   224,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,    -1,   243,   244,    -1,    -1,   247,   248,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   263,   264,   265,   266,   267,   268,   269,   270,
     271,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   287,   288,   289,   290,
      -1,    -1,    -1,   294,   295,   296,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   316,   317,   318,   319,   320,
     321,   322,   323,     3,    -1,    -1,     6,    -1,     8,     9,
      -1,    11,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    19,
      20,    21,    22,    23,    24,    25,    26,    -1,    -1,    -1,
      -1,    31,    -1,    -1,    -1,    -1,    36,    -1,    -1,    -1,
      -1,    41,    -1,    -1,    -1,    -1,    -1,    47,    48,    -1,
      -1,    -1,    -1,    -1,    54,    55,    -1,    -1,    -1,    59,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    84,    -1,    -1,    -1,    -1,    -1,
      -1,    91,    92,    93,    -1,    -1,    96,    -1,    98,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   117,    -1,    -1,
     120,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   128,   129,
     130,    -1,   132,    -1,    -1,   135,    -1,   137,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   151,   152,   153,   154,   155,   156,   157,   158,   159,
     160,   161,   162,   163,   164,   165,   166,   167,   168,   169,
     170,   171,   172,   173,   174,   175,   176,   177,   178,   179,
     180,   181,   182,   183,   184,    -1,   186,   187,   188,   189,
     190,   191,   192,   193,   194,   195,   196,    -1,   198,    -1,
     200,   201,   202,   203,   204,   205,   206,   207,   208,   209,
     210,   211,   212,   213,   214,   215,   216,   217,   218,   219,
     220,   221,   222,   223,   224,   225,   226,   227,   228,   229,
     230,   231,   232,   233,   234,   235,   236,   237,   238,   239,
     240,   241,    -1,   243,   244,    -1,    -1,   247,   248,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   263,   264,   265,   266,   267,   268,   269,
     270,   271,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   287,   288,   289,
     290,    -1,    -1,    -1,   294,   295,   296,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   316,   317,   318,   319,
     320,   321,   322,   323,     3,    -1,    -1,     6,    -1,     8,
       9,    -1,    11,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      19,    20,    21,    22,    23,    24,    25,    26,    -1,    -1,
      -1,    -1,    31,    -1,    -1,    -1,    -1,    36,    -1,    -1,
      -1,    -1,    41,    -1,    -1,    -1,    -1,    -1,    47,    48,
      -1,    -1,    -1,    -1,    -1,    54,    55,    -1,    -1,    -1,
      59,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    67,    68,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    84,    -1,    -1,    -1,    -1,
      -1,    -1,    91,    92,    93,    -1,    -1,    96,    -1,    98,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   117,    -1,
      -1,   120,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   128,
     129,   130,    -1,   132,    -1,    -1,   135,    -1,   137,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   151,   152,   153,   154,   155,   156,   157,   158,
     159,   160,   161,   162,   163,   164,   165,   166,   167,   168,
     169,   170,   171,   172,   173,   174,   175,   176,   177,   178,
     179,   180,   181,   182,   183,   184,    -1,   186,   187,   188,
     189,   190,   191,   192,   193,   194,   195,   196,    -1,   198,
      -1,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     209,   210,   211,   212,   213,   214,   215,   216,   217,   218,
     219,   220,   221,   222,   223,   224,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,   236,   237,   238,
     239,   240,   241,    -1,   243,   244,    -1,    -1,   247,   248,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   263,   264,   265,   266,   267,   268,
     269,   270,   271,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   287,   288,
     289,   290,    -1,    -1,    -1,   294,   295,   296,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,     3,    -1,    -1,     6,    -1,
       8,     9,    -1,    11,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    19,    20,    21,    22,    23,    24,    25,    26,    -1,
      -1,    -1,    -1,    31,    -1,    -1,    -1,    -1,    36,    -1,
      -1,    -1,    -1,    41,    -1,    -1,    -1,    -1,    -1,    47,
      48,    -1,    -1,    -1,    -1,    -1,    54,    55,    -1,    -1,
      -1,    59,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    84,    -1,    -1,    -1,
      -1,    -1,    -1,    91,    92,    93,    -1,    -1,    96,    -1,
      98,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   117,
      -1,    -1,   120,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,    -1,   135,    -1,   137,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   151,   152,   153,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   167,
     168,   169,   170,   171,   172,   173,   174,   175,   176,   177,
     178,   179,   180,   181,   182,   183,   184,    -1,   186,   187,
     188,   189,   190,   191,   192,   193,   194,   195,   196,    -1,
     198,    -1,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   219,   220,   221,   222,   223,   224,   225,   226,   227,
     228,   229,   230,   231,   232,   233,   234,   235,   236,   237,
     238,   239,   240,   241,    -1,   243,   244,    -1,    -1,   247,
     248,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   263,   264,   265,   266,   267,
     268,   269,   270,   271,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   287,
     288,   289,   290,    -1,    -1,    -1,   294,   295,   296,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   316,   317,
     318,   319,   320,   321,   322,   323,     3,    -1,    -1,     6,
      -1,     8,     9,    -1,    11,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    19,    20,    21,    22,    23,    24,    -1,    26,
      -1,    -1,    -1,    -1,    31,    -1,    -1,    -1,    -1,    36,
      -1,    -1,    -1,    -1,    41,    -1,    -1,    -1,    -1,    -1,
      47,    48,    -1,    -1,    -1,    -1,    -1,    54,    55,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    91,    92,    93,    -1,    -1,    96,
      -1,    98,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     117,    -1,    -1,   120,    -1,    -1,    -1,   124,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,    -1,   135,    -1,
     137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   151,   152,   153,   154,   155,   156,
     157,   158,   159,   160,   161,   162,   163,   164,   165,   166,
     167,   168,   169,   170,   171,   172,   173,   174,   175,   176,
     177,   178,   179,   180,   181,   182,   183,   184,   185,   186,
     187,   188,   189,   190,   191,   192,   193,   194,   195,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,   206,
     207,   208,   209,   210,   211,   212,   213,   214,   215,   216,
     217,   218,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,    -1,   243,   244,    -1,    -1,
     247,   248,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   263,   264,   265,   266,
     267,   268,   269,   270,   271,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     287,   288,   289,   290,    -1,    -1,    -1,   294,   295,   296,
       3,    -1,    -1,     6,    -1,     8,     9,    -1,    11,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    19,    20,    21,    22,
      23,    24,    -1,    26,    -1,   322,   323,    -1,    31,    -1,
      -1,    -1,    -1,    36,    -1,    -1,    39,    -1,    41,    -1,
      -1,    -1,    -1,    -1,    47,    48,    -1,    -1,    -1,    -1,
      -1,    54,    55,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    68,    -1,    -1,    -1,    -1,
      -1,    74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    88,    -1,    -1,    91,    92,
      93,    -1,    -1,    96,    -1,    98,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   117,    -1,    -1,   120,    -1,    -1,
      -1,    -1,    -1,    -1,   127,   128,   129,   130,    -1,    -1,
      -1,    -1,   135,    -1,   137,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   151,   152,
     153,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   167,   168,   169,   170,   171,   172,
     173,   174,   175,   176,   177,   178,   179,   180,   181,   182,
     183,   184,    -1,   186,   187,   188,   189,   190,   191,   192,
     193,   194,   195,   196,    -1,   198,    -1,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   209,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   219,   220,   221,   222,
     223,   224,   225,   226,   227,   228,   229,   230,   231,   232,
     233,   234,   235,   236,   237,   238,   239,   240,   241,    -1,
     243,   244,    -1,    -1,   247,   248,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     263,   264,   265,   266,   267,   268,   269,   270,   271,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   287,   288,   289,   290,    -1,    -1,
      -1,   294,   295,   296,     3,    -1,    -1,     6,    -1,     8,
       9,    -1,    11,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      19,    20,    21,    22,    23,    24,    -1,    26,    -1,   322,
     323,    -1,    31,    -1,    -1,    -1,    -1,    36,    -1,    -1,
      -1,    -1,    41,    -1,    -1,    -1,    -1,    -1,    47,    48,
      -1,    -1,    -1,    -1,    -1,    54,    55,    -1,    -1,    -1,
      59,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    91,    92,    93,    -1,    -1,    96,    -1,    98,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   117,    -1,
      -1,   120,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,    -1,   135,    -1,   137,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   151,   152,   153,   154,   155,   156,   157,   158,
     159,   160,   161,   162,   163,   164,   165,   166,   167,   168,
     169,   170,   171,   172,   173,   174,   175,   176,   177,   178,
     179,   180,   181,   182,   183,   184,    -1,   186,   187,   188,
     189,   190,   191,   192,   193,   194,   195,   196,    -1,   198,
      -1,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     209,   210,   211,   212,   213,   214,   215,   216,   217,   218,
     219,   220,   221,   222,   223,   224,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,   236,   237,   238,
     239,   240,   241,    -1,   243,   244,    -1,    -1,   247,   248,
     249,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   263,   264,   265,   266,   267,   268,
     269,   270,   271,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   287,   288,
     289,   290,    -1,    -1,    -1,   294,   295,   296,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,
      -1,    -1,     6,    -1,     8,     9,    -1,    11,    -1,    -1,
      -1,    -1,    -1,   322,   323,    19,    20,    21,    22,    23,
      24,    -1,    26,    -1,    28,    -1,    -1,    31,    -1,    -1,
      -1,    -1,    36,    -1,    -1,    -1,    -1,    41,    -1,    -1,
      -1,    -1,    -1,    47,    48,    -1,    -1,    -1,    -1,    -1,
      54,    55,    -1,    -1,    -1,    59,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    91,    92,    93,
      -1,    -1,    96,    -1,    98,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   117,    -1,    -1,   120,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
      -1,   135,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   151,   152,   153,
     154,   155,   156,   157,   158,   159,   160,   161,   162,   163,
     164,   165,   166,   167,   168,   169,   170,   171,   172,   173,
     174,   175,   176,   177,   178,   179,   180,   181,   182,   183,
     184,    -1,   186,   187,   188,   189,   190,   191,   192,   193,
     194,   195,   196,    -1,   198,    -1,   200,   201,   202,   203,
     204,   205,   206,   207,   208,   209,   210,   211,   212,   213,
     214,   215,   216,   217,   218,   219,   220,   221,   222,   223,
     224,   225,   226,   227,   228,   229,   230,   231,   232,   233,
     234,   235,   236,   237,   238,   239,   240,   241,    -1,   243,
     244,    -1,    -1,   247,   248,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   263,
     264,   265,   266,   267,   268,   269,   270,   271,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   287,   288,   289,   290,    -1,    -1,    -1,
     294,   295,   296,     3,    -1,    -1,     6,    -1,     8,     9,
      -1,    11,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    19,
      20,    21,    22,    23,    24,    -1,    26,    -1,   322,   323,
      -1,    31,    -1,    -1,    -1,    -1,    36,    -1,    -1,    -1,
      -1,    41,    -1,    -1,    -1,    -1,    -1,    47,    48,    -1,
      -1,    -1,    -1,    -1,    54,    55,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    91,    92,    93,    -1,    -1,    96,    -1,    98,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   113,    -1,    -1,    -1,   117,    -1,    -1,
     120,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,    -1,   135,    -1,   137,    -1,   139,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   151,   152,   153,   154,   155,   156,   157,   158,   159,
     160,   161,   162,   163,   164,   165,   166,   167,   168,   169,
     170,   171,   172,   173,   174,   175,   176,   177,   178,   179,
     180,   181,   182,   183,   184,    -1,   186,   187,   188,   189,
     190,   191,   192,   193,   194,   195,   196,    -1,   198,    -1,
     200,   201,   202,   203,   204,   205,   206,   207,   208,   209,
     210,   211,   212,   213,   214,   215,   216,   217,   218,   219,
     220,   221,   222,   223,   224,   225,   226,   227,   228,   229,
     230,   231,   232,   233,   234,   235,   236,   237,   238,   239,
     240,   241,    -1,   243,   244,    -1,    -1,   247,   248,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   263,   264,   265,   266,   267,   268,   269,
     270,   271,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   287,   288,   289,
     290,    -1,    -1,    -1,   294,   295,   296,     3,     4,    -1,
       6,    -1,     8,     9,    -1,    11,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    19,    20,    21,    22,    23,    24,    -1,
      26,    -1,   322,   323,    -1,    31,    -1,    -1,    -1,    -1,
      36,    -1,    -1,    -1,    -1,    41,    -1,    -1,    -1,    -1,
      -1,    47,    48,    -1,    -1,    -1,    -1,    -1,    54,    55,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    91,    92,    93,    -1,    -1,
      96,    -1,    98,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   117,    -1,    -1,   120,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,    -1,   135,
      -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   151,   152,   153,   154,   155,
     156,   157,   158,   159,   160,   161,   162,   163,   164,   165,
     166,   167,   168,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   180,   181,   182,   183,   184,   185,
     186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
     196,    -1,   198,    -1,   200,   201,   202,   203,   204,   205,
     206,   207,   208,   209,   210,   211,   212,   213,   214,   215,
     216,   217,   218,   219,   220,   221,   222,   223,   224,   225,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
     236,   237,   238,   239,   240,   241,    -1,   243,   244,    -1,
      -1,   247,   248,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   263,   264,   265,
     266,   267,   268,   269,   270,   271,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   287,   288,   289,   290,    -1,    -1,    -1,   294,   295,
     296,     3,    -1,    -1,     6,    -1,     8,     9,    -1,    11,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    19,    20,    21,
      22,    23,    24,    -1,    26,    -1,   322,   323,    -1,    31,
      -1,    -1,    -1,    -1,    36,    -1,    -1,    -1,    -1,    41,
      -1,    -1,    -1,    -1,    -1,    47,    48,    -1,    -1,    -1,
      -1,    -1,    54,    55,    -1,    -1,    -1,    59,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    68,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    91,
      92,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   117,    -1,    -1,   120,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,    -1,   135,    -1,   137,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   151,
     152,   153,   154,   155,   156,   157,   158,   159,   160,   161,
     162,   163,   164,   165,   166,   167,   168,   169,   170,   171,
     172,   173,   174,   175,   176,   177,   178,   179,   180,   181,
     182,   183,   184,    -1,   186,   187,   188,   189,   190,   191,
     192,   193,   194,   195,   196,    -1,   198,    -1,   200,   201,
     202,   203,   204,   205,   206,   207,   208,   209,   210,   211,
     212,   213,   214,   215,   216,   217,   218,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
      -1,   243,   244,    -1,    -1,   247,   248,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   263,   264,   265,   266,   267,   268,   269,   270,   271,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   287,   288,   289,   290,    -1,
      -1,    -1,   294,   295,   296,     3,    -1,    -1,     6,    -1,
       8,     9,    -1,    11,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    19,    20,    21,    22,    23,    24,    -1,    26,    -1,
     322,   323,    -1,    31,    -1,    -1,    -1,    -1,    36,    -1,
      -1,    -1,    -1,    41,    -1,    -1,    -1,    -1,    -1,    47,
      48,    -1,    -1,    -1,    -1,    -1,    54,    55,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    91,    92,    93,    -1,    -1,    96,    -1,
      98,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   117,
      -1,    -1,   120,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,    -1,   135,    -1,   137,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   151,   152,   153,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   167,
     168,   169,   170,   171,   172,   173,   174,   175,   176,   177,
     178,   179,   180,   181,   182,   183,   184,   185,   186,   187,
     188,   189,   190,   191,   192,   193,   194,   195,   196,    -1,
     198,    -1,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   219,   220,   221,   222,   223,   224,   225,   226,   227,
     228,   229,   230,   231,   232,   233,   234,   235,   236,   237,
     238,   239,   240,   241,    -1,   243,   244,    -1,    -1,   247,
     248,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   263,   264,   265,   266,   267,
     268,   269,   270,   271,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   287,
     288,   289,   290,    -1,    -1,    -1,   294,   295,   296,     3,
       4,    -1,     6,    -1,     8,     9,    -1,    11,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    19,    20,    21,    22,    23,
      24,    -1,    26,    -1,   322,   323,    -1,    31,    -1,    -1,
      -1,    -1,    36,    -1,    -1,    -1,    -1,    41,    -1,    -1,
      -1,    -1,    -1,    47,    48,    -1,    -1,    -1,    -1,    -1,
      54,    55,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    91,    92,    93,
      -1,    -1,    96,    -1,    98,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   117,    -1,    -1,   120,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
      -1,   135,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   151,   152,   153,
     154,   155,   156,   157,   158,   159,   160,   161,   162,   163,
     164,   165,   166,   167,   168,   169,   170,   171,   172,   173,
     174,   175,   176,   177,   178,   179,   180,   181,   182,   183,
     184,    -1,   186,   187,   188,   189,   190,   191,   192,   193,
     194,   195,   196,    -1,   198,    -1,   200,   201,   202,   203,
     204,   205,   206,   207,   208,   209,   210,   211,   212,   213,
     214,   215,   216,   217,   218,   219,   220,   221,   222,   223,
     224,   225,   226,   227,   228,   229,   230,   231,   232,   233,
     234,   235,   236,   237,   238,   239,   240,   241,    -1,   243,
     244,    -1,    -1,   247,   248,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   263,
     264,   265,   266,   267,   268,   269,   270,   271,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   287,   288,   289,   290,    -1,    -1,    -1,
     294,   295,   296,     3,    -1,    -1,     6,    -1,     8,     9,
      -1,    11,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    19,
      20,    21,    22,    23,    24,    -1,    26,    -1,   322,   323,
      -1,    31,    -1,    -1,    -1,    -1,    36,    -1,    -1,    -1,
      -1,    41,    -1,    -1,    -1,    -1,    -1,    47,    48,    -1,
      -1,    -1,    -1,    -1,    54,    55,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    -1,
      -1,    -1,    -1,    -1,    74,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    91,    92,    93,    -1,    -1,    96,    -1,    98,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   117,    -1,    -1,
     120,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,    -1,   135,    -1,   137,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   151,   152,   153,   154,   155,   156,   157,   158,   159,
     160,   161,   162,   163,   164,   165,   166,   167,   168,   169,
     170,   171,   172,   173,   174,   175,   176,   177,   178,   179,
     180,   181,   182,   183,   184,    -1,   186,   187,   188,   189,
     190,   191,   192,   193,   194,   195,   196,    -1,   198,    -1,
     200,   201,   202,   203,   204,   205,   206,   207,   208,   209,
     210,   211,   212,   213,   214,   215,   216,   217,   218,   219,
     220,   221,   222,   223,   224,   225,   226,   227,   228,   229,
     230,   231,   232,   233,   234,   235,   236,   237,   238,   239,
     240,   241,    -1,   243,   244,    -1,    -1,   247,   248,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   263,   264,   265,   266,   267,   268,   269,
     270,   271,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   287,   288,   289,
     290,    -1,    -1,    -1,   294,   295,   296,     3,    -1,    -1,
       6,    -1,     8,     9,    -1,    11,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    19,    20,    21,    22,    23,    24,    -1,
      26,    -1,   322,   323,    -1,    31,    -1,    -1,    -1,    -1,
      36,    -1,    -1,    -1,    -1,    41,    -1,    -1,    -1,    -1,
      -1,    47,    48,    -1,    -1,    -1,    -1,    -1,    54,    55,
      -1,    -1,    -1,    59,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    91,    92,    93,    -1,    -1,
      96,    -1,    98,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   117,    -1,    -1,   120,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,    -1,   135,
      -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   151,   152,   153,   154,   155,
     156,   157,   158,   159,   160,   161,   162,   163,   164,   165,
     166,   167,   168,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   180,   181,   182,   183,   184,    -1,
     186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
     196,    -1,   198,    -1,   200,   201,   202,   203,   204,   205,
     206,   207,   208,   209,   210,   211,   212,   213,   214,   215,
     216,   217,   218,   219,   220,   221,   222,   223,   224,   225,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
     236,   237,   238,   239,   240,   241,    -1,   243,   244,    -1,
      -1,   247,   248,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   263,   264,   265,
     266,   267,   268,   269,   270,   271,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   287,   288,   289,   290,    -1,    -1,    -1,   294,   295,
     296,     3,    -1,    -1,     6,    -1,     8,     9,    -1,    11,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    19,    20,    21,
      22,    23,    24,    -1,    26,    -1,   322,   323,    -1,    31,
      -1,    -1,    -1,    -1,    36,    -1,    -1,    -1,    -1,    41,
      -1,    -1,    -1,    -1,    -1,    47,    48,    -1,    -1,    -1,
      -1,    -1,    54,    55,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    68,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    91,
      92,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   117,    -1,    -1,   120,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,    -1,   135,    -1,   137,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   151,
     152,   153,   154,   155,   156,   157,   158,   159,   160,   161,
     162,   163,   164,   165,   166,   167,   168,   169,   170,   171,
     172,   173,   174,   175,   176,   177,   178,   179,   180,   181,
     182,   183,   184,    -1,   186,   187,   188,   189,   190,   191,
     192,   193,   194,   195,   196,    -1,   198,    -1,   200,   201,
     202,   203,   204,   205,   206,   207,   208,   209,   210,   211,
     212,   213,   214,   215,   216,   217,   218,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
      -1,   243,   244,    -1,    -1,   247,   248,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   263,   264,   265,   266,   267,   268,   269,   270,   271,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   287,   288,   289,   290,    -1,
      -1,    -1,   294,   295,   296,     3,    -1,    -1,     6,    -1,
       8,     9,    -1,    11,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    20,    21,    22,    23,    24,    -1,    26,    -1,
     322,   323,    -1,    31,    -1,    -1,    -1,    -1,    36,    -1,
      -1,    -1,    -1,    41,    -1,    -1,    -1,    -1,    -1,    -1,
      48,    -1,    -1,    -1,    -1,    -1,    54,    55,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    92,    93,    -1,    -1,    96,    -1,
      98,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   117,
      -1,    -1,   120,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   130,    -1,    -1,    -1,    -1,    -1,    -1,   137,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   151,   152,   153,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   167,
     168,   169,   170,   171,    -1,   173,    -1,    -1,    -1,   177,
     178,   179,   180,   181,   182,   183,   184,    -1,   186,   187,
     188,   189,   190,   191,   192,   193,   194,   195,   196,    -1,
     198,    -1,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   219,   220,   221,   222,   223,   224,   225,   226,   227,
     228,   229,   230,   231,   232,   233,   234,   235,   236,   237,
     238,   239,   240,   241,    -1,   243,   244,    -1,    -1,   247,
     248,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   263,   264,   265,   266,   267,
     268,   269,   270,   271,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   287,
     288,   289,   290,    -1,    -1,    -1,   294,   295,   296,     3,
      -1,    -1,     6,    -1,     8,     9,    -1,    11,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    20,    21,    22,    23,
      24,    -1,    26,    -1,   322,   323,    -1,    31,    -1,    -1,
      -1,    -1,    36,    -1,    -1,    -1,    -1,    41,    -1,    -1,
      -1,    -1,    -1,    -1,    48,    -1,    -1,    -1,    -1,    -1,
      54,    55,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    92,    93,
      -1,    -1,    96,    -1,    98,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   117,    -1,    -1,   120,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   130,    -1,    -1,    -1,
      -1,    -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   151,   152,   153,
     154,   155,   156,   157,   158,   159,   160,   161,   162,   163,
     164,   165,   166,   167,   168,   169,   170,   171,    -1,   173,
      -1,    -1,    -1,   177,   178,   179,   180,   181,   182,   183,
     184,    -1,   186,   187,   188,   189,   190,   191,   192,   193,
     194,   195,   196,    -1,   198,    -1,   200,   201,   202,   203,
     204,   205,   206,   207,   208,   209,   210,   211,   212,   213,
     214,   215,   216,   217,   218,   219,   220,   221,   222,   223,
     224,   225,   226,   227,   228,   229,   230,   231,   232,   233,
     234,   235,   236,   237,   238,   239,   240,   241,    -1,   243,
     244,    -1,    -1,   247,   248,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    11,    -1,    -1,   263,
     264,   265,   266,   267,   268,   269,   270,   271,    -1,    -1,
      -1,    26,    -1,    -1,    -1,    -1,    31,    -1,    -1,    -1,
      -1,    36,    -1,   287,   288,   289,   290,    -1,    -1,    -1,
     294,   295,   296,    48,    -1,    -1,    -1,    -1,    -1,    54,
      55,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    92,    93,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   117,    -1,    -1,   120,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   151,    -1,   153,   154,
      -1,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,    -1,   173,    -1,
      -1,    -1,   177,   178,   179,   180,   181,   182,   183,   184,
      -1,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,    -1,   198,    -1,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,    11,   243,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    26,    -1,    -1,    -1,    -1,    31,    -1,    -1,
      -1,    -1,    36,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    48,    -1,    -1,    -1,    -1,    -1,
      54,    55,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    92,    93,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   117,    -1,    -1,   120,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,   157,   158,   159,   160,   161,   162,   163,
     164,    -1,   166,   167,   168,   169,   170,   171,    -1,   173,
      -1,    -1,    -1,   177,   178,   179,   180,   181,   182,    -1,
     184,    -1,   186,   187,   188,   189,   190,   191,   192,   193,
     194,   195,   196,    -1,   198,    -1,   200,   201,   202,   203,
     204,   205,   206,   207,   208,   209,   210,   211,   212,   213,
     214,   215,   216,   217,   218,   219,   220,   221,   222,   223,
     224,   225,   226,   227,   228,   229,   230,   231,   232,   233,
     234,   235,   236,   237,   238,   239,   240,   241,    -1,   243
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int16 yystos[] =
{
       0,     3,     6,     8,     9,    11,    19,    20,    21,    22,
      23,    24,    25,    26,    31,    36,    41,    45,    47,    48,
      49,    54,    55,    59,    60,    67,    68,    69,    76,    84,
      91,    92,    93,    96,    98,   111,   113,   117,   120,   128,
     129,   130,   132,   134,   135,   137,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
     196,   198,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   219,   220,   221,   222,   223,   224,   225,   226,   227,
     228,   229,   230,   231,   232,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   243,   244,   247,   248,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   287,   288,   289,
     290,   294,   295,   296,   316,   317,   318,   319,   320,   321,
     322,   323,   330,   331,   332,   333,   344,   347,   358,   359,
     360,   361,   362,   363,   364,   367,   368,   369,   370,   375,
     380,   405,   407,   408,   409,   410,   412,   413,   414,   415,
     416,   417,   418,   420,   421,   423,   424,   425,   426,   428,
     429,   430,   434,   436,   437,   438,   439,   440,   441,   445,
     446,   447,   448,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
     466,   467,   468,   469,   470,   476,   477,   482,   483,   485,
     523,   524,   525,   526,   529,   531,   532,   533,   549,   552,
     553,   554,   555,   556,   557,   558,   559,   562,   563,   564,
     577,   578,   579,   580,   581,   583,   584,   585,   586,   590,
     592,   593,   594,   595,   596,   597,   605,   631,   632,   633,
     634,   635,   636,   648,   651,     3,   139,   331,   365,   379,
     380,   409,   542,   543,   544,   546,   548,   577,    26,    26,
       8,   146,   147,   148,   149,   516,   517,   521,   522,     3,
      11,    25,   158,   405,     6,    13,     3,   143,     3,     3,
     121,   140,   258,    74,     3,   430,    26,   647,    28,    60,
     110,   113,   134,   136,   158,   349,   350,   351,   358,     3,
     143,    28,    62,   371,     3,     3,   430,    26,   601,   602,
     603,   604,     3,     3,     3,    83,     3,     3,     3,     3,
       3,   249,   368,   641,   642,   646,     3,     3,     3,     3,
       3,   554,   554,     0,     7,    37,    79,    89,   131,   413,
     414,   416,   417,   420,   423,   425,   315,   314,    28,    31,
     117,   367,   368,   427,    19,    21,    22,    24,     3,     3,
       3,     3,     3,     3,     3,     3,   286,     3,     3,     3,
       3,     3,   325,   326,   322,   323,    34,   560,   324,   322,
      44,   582,     3,   546,     3,     4,    85,     4,     4,    66,
     131,     4,    10,   321,    26,   448,   523,   533,   145,    12,
      12,    19,     3,   113,   380,   409,    26,    26,   154,   165,
     183,   325,   606,   631,   550,   577,   550,   578,   325,   371,
     601,   601,    26,   671,   601,     3,    83,   106,     3,   346,
     346,   346,   100,     5,    62,    96,   133,   577,   325,   381,
     431,   432,   577,   600,   577,   578,    39,    74,    88,   127,
     577,   598,   599,     6,    13,   114,   577,   577,   577,   601,
     574,   577,   574,   577,   587,   588,   589,    55,   124,   125,
     184,   185,   186,   187,   192,   196,   197,   198,   199,   442,
     443,   444,   565,   577,   577,     3,   577,   409,   250,   642,
     643,   249,   637,   638,   641,   574,   577,   574,   577,     4,
     434,   471,   472,   473,   648,   577,   367,     3,   422,   430,
     553,   578,    28,   547,   367,   407,   408,   430,     4,   575,
     577,   644,   645,   571,   575,    55,   184,   185,   186,   187,
     192,   196,   198,   566,   575,   576,   576,   572,   575,     4,
     576,   573,   575,     3,    26,   488,   489,   490,   496,   478,
     577,   577,   371,   530,   557,     4,   528,   574,   555,   555,
     556,   556,    90,   561,   577,   583,   601,   577,     4,   366,
     367,   547,   547,   547,     3,   601,   371,    13,    13,    32,
       5,   138,     4,   575,     3,   346,   251,   252,   253,   653,
     141,   378,   401,   548,   376,   377,   433,   648,    26,   343,
     631,   601,   351,    74,     4,    74,    83,   394,   395,     5,
      32,   435,   631,   138,   577,    74,     4,    74,   577,    26,
     603,    26,   603,   604,   372,   373,   631,     4,     4,     4,
     346,     4,     5,     7,    79,     4,    74,    74,    74,   102,
     354,   245,   577,   644,   246,   368,   411,   413,   414,   416,
     420,   423,   639,   640,   643,   638,     4,     4,     4,     4,
       5,   315,   574,    11,    65,   419,   419,   380,     4,    40,
      84,   138,   413,     4,     5,     5,     4,     5,     7,     4,
       4,     5,     4,     4,     5,   488,   497,   500,     5,   474,
       4,   575,     4,     4,    40,     4,     4,     5,   543,   545,
     379,   544,   379,     3,   518,   381,    26,    26,   606,    21,
      42,    53,    56,    57,    63,    70,    82,    95,    97,   109,
     116,   122,   123,   153,   272,   273,   276,   277,   279,   280,
     281,   282,   284,   285,   551,   601,   607,   610,   611,   618,
     619,   620,   621,   622,   623,   625,   626,   627,   628,   630,
     551,   601,     4,    43,    72,   105,   132,   334,   335,   336,
     339,   341,   631,    32,    99,    60,   134,   158,   654,   409,
       5,     4,     5,   126,     3,    11,   396,   400,   430,   538,
     539,   540,   601,   376,   378,   432,   631,   601,   577,   577,
      74,    13,     5,   378,   321,   548,   577,   577,   577,   577,
     578,   577,    40,     4,   644,   367,     5,   245,   246,   471,
     472,   486,   367,     4,    65,   578,   574,   358,   577,   577,
     575,   575,   575,   575,   575,   575,   307,   498,   501,    23,
     479,     4,   291,   292,   475,   481,     4,   242,   527,   527,
     574,   367,   434,   519,   520,   648,    13,    13,     3,   274,
     278,   612,   613,     3,   624,   624,   104,     3,   274,   278,
     612,   624,   612,   612,   274,   278,   612,   613,   613,     3,
     614,   615,    42,   153,   614,   614,   274,   278,   612,    55,
     184,   186,   187,   192,   196,   198,   565,   567,   569,   570,
       4,    42,   608,   582,   609,     4,     4,     3,    87,    87,
       4,     5,     3,   607,   380,    99,   655,   100,   377,   631,
      26,   108,   352,   353,   650,     3,   400,   540,   150,     5,
      50,    75,    81,    94,   160,   168,   534,   537,    32,   397,
     649,   397,   399,   394,    77,   402,     4,   577,    26,   373,
      59,   374,   577,     4,    71,   591,   591,     4,   355,   356,
     368,   410,   358,   368,   413,   414,   416,   420,   423,   640,
     644,     4,    19,   413,     5,     5,     5,    40,   354,     5,
     475,   293,   293,    77,     4,     4,     5,   606,   606,    23,
     613,   275,    23,    23,   613,   275,   142,   283,   629,   629,
     613,   275,    23,   616,   274,   278,   612,   274,   612,   613,
     275,   624,   612,   126,   114,   609,   409,     3,   335,   343,
     337,   142,   345,   343,   656,   604,     5,   142,   348,     4,
     540,   400,    86,   537,   103,    86,    26,     3,   342,    26,
      40,    78,   404,   577,     4,     4,     5,    33,    61,   357,
     357,    89,   367,    74,   484,   487,    12,   577,   575,   575,
     575,    26,   502,   503,   605,   305,   306,   499,   505,   506,
     480,   577,     3,   527,   520,     4,   614,     4,     5,     4,
     614,   122,   122,   614,    14,    15,    16,    17,    18,   617,
       4,   613,   275,   613,   614,   192,   565,   568,    26,     4,
     343,     4,    25,    43,    59,   110,   339,   340,    43,   255,
     652,   353,    76,    12,   400,    86,   400,   343,   342,   403,
     448,   605,   409,   308,   491,   492,   356,   297,   298,   475,
       5,     5,   609,     4,    37,    51,   303,   446,   507,   508,
     509,   510,   354,    23,   144,   144,   614,   612,     4,    96,
       3,    96,   137,   338,   434,   559,   601,   101,   261,   262,
     664,   665,    71,   657,   658,   101,   400,   100,   138,   535,
     536,   541,     4,     5,   488,   493,   494,   495,   354,   575,
     503,   303,   446,   508,   511,   513,   514,   259,   304,   304,
     299,   504,   515,     4,     4,   110,   409,     3,   121,   259,
     398,   121,   398,   665,   254,   249,   660,   409,     3,   448,
     605,     5,    32,   310,   391,   393,   302,   302,   315,    51,
      77,   301,   309,   601,     4,   343,   397,   397,   397,   397,
     259,   260,   659,     3,   406,   256,   331,   661,   663,   343,
     494,   496,    23,   311,   382,   383,   512,   513,   259,   300,
       3,     4,    26,   667,   668,    26,   670,   666,   668,    26,
     669,   409,   257,     4,   311,   392,   389,   434,    69,   387,
     388,   343,     4,   662,   663,    23,   259,   306,   386,   297,
     312,   385,     4,     7,   384,   390,   434,   246,   663,   386,
     313
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int16 yyr1[] =
{
       0,   329,   330,   330,   331,   331,   332,   332,   332,   332,
     333,   334,   334,   335,   335,   336,   337,   337,   338,   339,
     339,   340,   340,   340,   340,   340,   340,   340,   340,   340,
     340,   341,   341,   341,   341,   342,   342,   343,   343,   344,
     345,   345,   346,   346,   347,   348,   348,   349,   349,   350,
     350,   351,   351,   351,   351,   351,   351,   352,   352,   353,
     353,   354,   354,   355,   355,   356,   356,   357,   357,   357,
     358,   358,   359,   359,   359,   359,   359,   359,   359,   359,
     359,   360,   360,   361,   362,   363,   364,   365,   366,   366,
     367,   368,   368,   369,   370,   371,   371,   371,   372,   372,
     373,   374,   374,   375,   376,   376,   377,   378,   378,   379,
     380,   381,   381,   382,   382,   383,   384,   384,   385,   385,
     386,   386,   387,   387,   388,   389,   390,   391,   391,   392,
     392,   393,   394,   395,   396,   396,   397,   397,   398,   398,
     399,   399,   400,   400,   400,   400,   400,   401,   402,   402,
     403,   403,   403,   403,   404,   404,   405,   405,   405,   406,
     407,   407,   408,   408,   409,   409,   410,   410,   410,   410,
     410,   410,   410,   410,   411,   412,   412,   413,   413,   413,
     413,   413,   413,   413,   413,   414,   415,   415,   416,   417,
     418,   418,   418,   418,   419,   419,   419,   420,   420,   421,
     421,   422,   422,   423,   424,   424,   425,   426,   426,   427,
     427,   427,   428,   429,   430,   431,   431,   432,   433,   434,
     434,   434,   434,   434,   434,   434,   434,   434,   435,   435,
     435,   436,   436,   437,   437,   437,   438,   438,   439,   440,
     441,   441,   441,   442,   442,   443,   443,   443,   444,   444,
     445,   446,   446,   447,   447,   447,   447,   447,   447,   447,
     447,   447,   447,   447,   447,   447,   447,   448,   448,   448,
     448,   448,   448,   448,   448,   448,   448,   448,   449,   449,
     450,   450,   450,   451,   451,   452,   452,   452,   452,   453,
     453,   454,   455,   455,   455,   455,   456,   456,   456,   456,
     456,   456,   456,   457,   457,   457,   458,   459,   460,   460,
     460,   460,   460,   461,   461,   461,   462,   462,   462,   462,
     462,   462,   462,   462,   462,   462,   462,   462,   462,   462,
     463,   463,   463,   464,   465,   465,   465,   465,   465,   465,
     465,   465,   465,   465,   465,   465,   465,   465,   465,   465,
     465,   465,   466,   466,   466,   467,   467,   468,   469,   469,
     469,   469,   469,   469,   469,   470,   471,   472,   473,   473,
     474,   474,   474,   475,   475,   476,   477,   477,   478,   479,
     480,   481,   481,   482,   483,   483,   484,   484,   485,   486,
     486,   487,   487,   488,   489,   489,   490,   491,   491,   492,
     493,   493,   494,   495,   496,   497,   497,   498,   498,   499,
     499,   500,   501,   502,   502,   503,   504,   504,   505,   506,
     506,   507,   507,   508,   508,   508,   509,   510,   511,   512,
     513,   513,   513,   514,   515,   515,   515,   515,   516,   516,
     517,   518,   518,   519,   519,   520,   520,   520,   521,   521,
     522,   522,   522,   523,   523,   523,   523,   523,   524,   524,
     524,   524,   524,   524,   524,   524,   524,   524,   524,   524,
     524,   524,   525,   525,   526,   526,   527,   527,   528,   529,
     530,   531,   531,   532,   533,   533,   533,   533,   534,   534,
     534,   535,   536,   536,   537,   537,   537,   537,   538,   539,
     539,   539,   540,   541,   542,   542,   543,   543,   544,   544,
     545,   546,   546,   546,   547,   547,   548,   549,   550,   551,
     551,   552,   553,   553,   553,   553,   553,   553,   553,   553,
     554,   554,   555,   555,   555,   556,   556,   556,   557,   557,
     557,   558,   559,   559,   559,   560,   561,   562,   562,   563,
     564,   565,   565,   565,   565,   565,   565,   565,   565,   565,
     566,   566,   566,   566,   566,   566,   566,   566,   567,   568,
     568,   569,   569,   570,   570,   571,   572,   573,   574,   574,
     574,   575,   575,   575,   575,   576,   576,   576,   576,   577,
     577,   577,   578,   579,   579,   580,   580,   581,   581,   582,
     583,   583,   584,   584,   585,   586,   587,   588,   589,   590,
     590,   590,   590,   590,   591,   591,   592,   592,   593,   593,
     594,   595,   595,   596,   597,   598,   598,   598,   598,   598,
     599,   599,   599,   600,   601,   601,   601,   602,   602,   603,
     604,   605,   605,   605,   605,   605,   606,   606,   607,   608,
     608,   609,   609,   610,   610,   610,   610,   610,   610,   610,
     611,   611,   611,   611,   611,   611,   612,   612,   613,   614,
     614,   615,   616,   617,   617,   617,   617,   617,   617,   618,
     618,   618,   619,   619,   619,   619,   619,   619,   619,   620,
     620,   620,   621,   621,   621,   621,   622,   622,   623,   623,
     624,   624,   624,   625,   625,   625,   625,   625,   625,   625,
     626,   626,   626,   626,   626,   627,   628,   628,   628,   629,
     629,   629,   630,   631,   631,   631,   631,   632,   632,   633,
     633,   633,   634,   634,   635,   636,   637,   637,   638,   639,
     639,   640,   640,   640,   640,   640,   640,   641,   641,   642,
     643,   643,   644,   645,   646,   647,   648,   648,   648,   649,
     649,   650,   331,   331,   651,   652,   652,   653,   653,   653,
     654,   654,   654,   655,   655,   656,   657,   658,   658,   659,
     659,   660,   660,   661,   661,   662,   662,   663,   664,   664,
     665,   665,   665,   665,   666,   667,   668,   669,   670,   671
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       6,     1,     3,     1,     1,     3,     0,     2,     1,     1,
       2,     2,     1,     2,     2,     2,     2,     1,     4,     2,
       5,     4,     7,    10,     4,     0,     3,     3,     1,     7,
       0,     3,     0,     3,     7,     0,     3,     2,     1,     1,
       3,     1,     2,     1,     2,     2,     1,     1,     3,     1,
       1,     0,     3,     1,     3,     2,     2,     0,     1,     1,
       0,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     1,     4,     2,     4,     4,     5,     4,     1,     3,
       1,     1,     1,     2,     6,     0,     1,     1,     1,     3,
       3,     1,     1,     5,     1,     3,     1,     0,     1,     1,
       4,     1,     1,     0,     1,     3,     0,     1,     1,     1,
       1,     1,     0,     1,     5,     1,     1,     0,     1,     0,
       2,     3,     9,     2,     1,     3,     0,     1,     0,     1,
       0,     3,     2,     3,     1,     4,     3,     2,     0,     3,
       1,     1,     3,     3,     0,     2,     1,     3,     1,     3,
       1,     2,     1,     3,     1,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     3,     2,     1,     1,     1,
       1,     1,     1,     4,     2,     5,     2,     1,     4,     4,
       2,     2,     1,     1,     0,     2,     4,     3,     3,     2,
       1,     1,     3,     3,     2,     1,     3,     2,     1,     1,
       1,     1,     2,     2,     3,     1,     3,     1,     1,     1,
       1,     1,     1,     1,     2,     2,     2,     2,     0,     2,
       1,     6,     4,     1,     1,     1,     4,     4,     4,     4,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       6,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     3,     3,
       3,     4,     4,     4,     4,     4,     4,     4,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     3,     3,     3,
       1,     1,     1,     1,     1,     4,     1,     1,     1,     1,
       0,     2,     4,     0,     1,     6,     1,     1,     1,     1,
       1,     2,     2,     5,     1,     1,     0,     1,     8,     1,
       1,     2,     2,     1,     1,     1,     1,     0,     1,     2,
       3,     1,     3,     1,     6,     0,     1,     0,     1,     0,
       1,     1,     3,     3,     1,     2,     0,     1,     3,     1,
       1,     1,     1,     2,     1,     2,     2,     4,     1,     1,
       1,     2,     1,     2,     3,     2,     2,     3,     0,     2,
       4,     0,     3,     1,     3,     0,     1,     1,     2,     2,
       1,     1,     1,     5,     4,     5,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     5,     7,     0,     5,     1,     5,
       1,     1,     1,     5,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     1,     0,     1,     1,     2,     4,     5,
       5,     1,     1,     4,     1,     1,     1,     3,     1,     4,
       1,     1,     4,     4,     0,     1,     1,     1,     1,     1,
       1,     6,     1,     1,     1,     1,     1,     1,     3,     1,
       1,     1,     1,     2,     2,     1,     3,     3,     1,     3,
       3,     1,     1,     1,     1,     2,     1,     1,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     1,
       2,     2,     2,     3,     1,     3,     5,     7,     1,     3,
       3,     1,     3,     5,     3,     1,     3,     3,     5,     1,
       1,     1,     1,     1,     1,     3,     3,     1,     1,     2,
       1,     2,     1,     1,     1,     7,     1,     1,     0,     1,
       1,     1,     1,     1,     0,     2,     7,     4,     1,     1,
       4,     6,     6,     6,     4,     4,     3,     3,     2,     1,
       1,     1,     1,     2,     1,     1,     1,     3,     3,     3,
       1,     1,     3,     5,     7,     7,     1,     1,     1,     0,
       3,     0,     1,     3,     2,     1,     1,     1,     1,     1,
       2,     2,     3,     3,     2,     1,     0,     1,     3,     0,
       1,     3,     2,     0,     1,     1,     1,     1,     1,     4,
       4,     2,     3,     3,     2,     4,     4,     3,     1,     5,
       4,     2,     2,     3,     2,     1,     4,     2,     1,     1,
       0,     3,     5,     2,     2,     2,     1,     1,     1,     1,
       4,     1,     1,     1,     2,     1,     1,     3,     3,     0,
       3,     3,     2,     1,     1,     1,     1,     1,     1,     4,
       4,     4,     1,     1,     5,     4,     1,     2,     4,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     2,     4,
       0,     2,     1,     1,     1,     1,     2,     1,     3,     0,
       2,     1,     1,     3,     9,     0,     2,     1,     1,     2,
       1,     1,     2,     0,     2,     1,     3,     0,     3,     1,
       1,     0,     2,     1,     5,     1,     3,     1,     1,     2,
       4,     4,     4,     4,     1,     1,     1,     1,     1,     1
};


/* YYDPREC[RULE-NUM] -- Dynamic precedence of rule #RULE-NUM (0 if none).  */
static const yytype_int8 yydprec[] =
{
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       2,     1,     0,     0,     0,     0,     1,     0,     0,     0,
       0,     2,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     1,     0,     0,     0,     2,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0
};

/* YYMERGER[RULE-NUM] -- Index of merging function for rule #RULE-NUM.  */
static const yytype_int8 yymerger[] =
{
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0
};

/* YYIMMEDIATE[RULE-NUM] -- True iff rule #RULE-NUM is not to be deferred, as
   in the case of predicates.  */
static const yybool yyimmediate[] =
{
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0
};

/* YYCONFLP[YYPACT[STATE-NUM]] -- Pointer into YYCONFL of start of
   list of conflicting reductions corresponding to action entry for
   state STATE-NUM in yytable.  0 means no conflicts.  The list in
   yyconfl is terminated by a rule number of 0.  */
static const yytype_int8 yyconflp[] =
{
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    17,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    29,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    15,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     7,     0,     0,     0,     0,
       0,    41,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    43,     0,    45,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    33,    35,     0,     0,     0,
      31,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    37,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      39,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      11,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    19,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    13,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     9,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    21,     0,    23,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    25,    47,     0,     0,     0,    51,    49,
       0,     0,     0,    53,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    27,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    55,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     1,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     3,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     5,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0
};

/* YYCONFL[I] -- lists of conflicting rule numbers, each terminated by
   0, pointed into by YYCONFLP.  */
static const short yyconfl[] =
{
       0,    71,     0,    71,     0,    71,     0,   589,     0,   592,
       0,   504,     0,   504,     0,   762,     0,    91,     0,   184,
       0,   463,     0,   464,     0,   516,     0,    42,     0,   578,
       0,   741,     0,   743,     0,   745,     0,   746,     0,   744,
       0,   176,     0,   584,     0,   584,     0,   498,     0,   498,
       0,   499,     0,   499,     0,   129,     0
};



YYSTYPE yylval;

int yynerrs;
int yychar;

enum { YYENOMEM = -2 };

typedef enum { yyok, yyaccept, yyabort, yyerr, yynomem } YYRESULTTAG;

#define YYCHK(YYE)                              \
  do {                                          \
    YYRESULTTAG yychk_flag = YYE;               \
    if (yychk_flag != yyok)                     \
      return yychk_flag;                        \
  } while (0)

/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYMAXDEPTH * sizeof (GLRStackItem)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif

/* Minimum number of free items on the stack allowed after an
   allocation.  This is to allow allocation and initialization
   to be completed by functions that call yyexpandGLRStack before the
   stack is expanded, thus insuring that all necessary pointers get
   properly redirected to new data.  */
#define YYHEADROOM 2

#ifndef YYSTACKEXPANDABLE
#  define YYSTACKEXPANDABLE 1
#endif

#if YYSTACKEXPANDABLE
# define YY_RESERVE_GLRSTACK(Yystack)                   \
  do {                                                  \
    if (Yystack->yyspaceLeft < YYHEADROOM)              \
      yyexpandGLRStack (Yystack);                       \
  } while (0)
#else
# define YY_RESERVE_GLRSTACK(Yystack)                   \
  do {                                                  \
    if (Yystack->yyspaceLeft < YYHEADROOM)              \
      yyMemoryExhausted (Yystack);                      \
  } while (0)
#endif

/** State numbers. */
typedef int yy_state_t;

/** Rule numbers. */
typedef int yyRuleNum;

/** Item references. */
typedef short yyItemNum;

typedef struct yyGLRState yyGLRState;
typedef struct yyGLRStateSet yyGLRStateSet;
typedef struct yySemanticOption yySemanticOption;
typedef union yyGLRStackItem yyGLRStackItem;
typedef struct yyGLRStack yyGLRStack;

struct yyGLRState
{
  /** Type tag: always true.  */
  yybool yyisState;
  /** Type tag for yysemantics.  If true, yyval applies, otherwise
   *  yyfirstVal applies.  */
  yybool yyresolved;
  /** Number of corresponding LALR(1) machine state.  */
  yy_state_t yylrState;
  /** Preceding state in this stack */
  yyGLRState* yypred;
  /** Source position of the last token produced by my symbol */
  YYPTRDIFF_T yyposn;
  union {
    /** First in a chain of alternative reductions producing the
     *  nonterminal corresponding to this state, threaded through
     *  yynext.  */
    yySemanticOption* yyfirstVal;
    /** Semantic value for this state.  */
    YYSTYPE yyval;
  } yysemantics;
};

struct yyGLRStateSet
{
  yyGLRState** yystates;
  /** During nondeterministic operation, yylookaheadNeeds tracks which
   *  stacks have actually needed the current lookahead.  During deterministic
   *  operation, yylookaheadNeeds[0] is not maintained since it would merely
   *  duplicate yychar != YYEMPTY.  */
  yybool* yylookaheadNeeds;
  YYPTRDIFF_T yysize;
  YYPTRDIFF_T yycapacity;
};

struct yySemanticOption
{
  /** Type tag: always false.  */
  yybool yyisState;
  /** Rule number for this reduction */
  yyRuleNum yyrule;
  /** The last RHS state in the list of states to be reduced.  */
  yyGLRState* yystate;
  /** The lookahead for this reduction.  */
  int yyrawchar;
  YYSTYPE yyval;
  /** Next sibling in chain of options.  To facilitate merging,
   *  options are chained in decreasing order by address.  */
  yySemanticOption* yynext;
};

/** Type of the items in the GLR stack.  The yyisState field
 *  indicates which item of the union is valid.  */
union yyGLRStackItem {
  yyGLRState yystate;
  yySemanticOption yyoption;
};

struct yyGLRStack {
  int yyerrState;


  YYJMP_BUF yyexception_buffer;
  yyGLRStackItem* yyitems;
  yyGLRStackItem* yynextFree;
  YYPTRDIFF_T yyspaceLeft;
  yyGLRState* yysplitPoint;
  yyGLRState* yylastDeleted;
  yyGLRStateSet yytops;
};

#if YYSTACKEXPANDABLE
static void yyexpandGLRStack (yyGLRStack* yystackp);
#endif

_Noreturn static void
yyFail (yyGLRStack* yystackp, const char* yymsg)
{
  if (yymsg != YY_NULLPTR)
    yyerror (yymsg);
  YYLONGJMP (yystackp->yyexception_buffer, 1);
}

_Noreturn static void
yyMemoryExhausted (yyGLRStack* yystackp)
{
  YYLONGJMP (yystackp->yyexception_buffer, 2);
}

/** Accessing symbol of state YYSTATE.  */
static inline yysymbol_kind_t
yy_accessing_symbol (yy_state_t yystate)
{
  return YY_CAST (yysymbol_kind_t, yystos[yystate]);
}

#if YYDEBUG || 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "'('", "')'", "','",
  "':'", "';'", "'?'", "'['", "']'", "'{'", "'}'", "'.'", "'K'", "'M'",
  "'G'", "'T'", "'P'", "SQL_TOKEN_STRING", "SQL_TOKEN_ACCESS_DATE",
  "SQL_TOKEN_INT", "SQL_TOKEN_REAL_NUM", "SQL_TOKEN_INTNUM",
  "SQL_TOKEN_APPROXNUM", "SQL_TOKEN_NOT", "SQL_TOKEN_NAME",
  "SQL_TOKEN_UMINUS", "SQL_TOKEN_ALL", "SQL_TOKEN_ALTER",
  "SQL_TOKEN_AMMSC", "SQL_TOKEN_ANY", "SQL_TOKEN_AS", "SQL_TOKEN_ASC",
  "SQL_TOKEN_AT", "SQL_TOKEN_AUTHORIZATION", "SQL_TOKEN_AVG",
  "SQL_TOKEN_BETWEEN", "SQL_TOKEN_BIT", "SQL_TOKEN_BOTH", "SQL_TOKEN_BY",
  "SQL_TOKEN_CAST", "SQL_TOKEN_CHARACTER", "SQL_TOKEN_CHECK",
  "SQL_TOKEN_COLLATE", "SQL_TOKEN_COMMIT", "SQL_TOKEN_CONTINUE",
  "SQL_TOKEN_CONVERT", "SQL_TOKEN_COUNT", "SQL_TOKEN_CREATE",
  "SQL_TOKEN_CROSS", "SQL_TOKEN_CURRENT", "SQL_TOKEN_CURSOR",
  "SQL_TOKEN_DATE", "SQL_TOKEN_DATEVALUE", "SQL_TOKEN_DAY",
  "SQL_TOKEN_DEC", "SQL_TOKEN_DECIMAL", "SQL_TOKEN_DECLARE",
  "SQL_TOKEN_DEFAULT", "SQL_TOKEN_DELETE", "SQL_TOKEN_DESC",
  "SQL_TOKEN_DISTINCT", "SQL_TOKEN_DOUBLE", "SQL_TOKEN_DROP",
  "SQL_TOKEN_ESCAPE", "SQL_TOKEN_EXCEPT", "SQL_TOKEN_EXISTS",
  "SQL_TOKEN_FALSE", "SQL_TOKEN_FETCH", "SQL_TOKEN_FLOAT", "SQL_TOKEN_FOR",
  "SQL_TOKEN_FOREIGN", "SQL_TOKEN_FOUND", "SQL_TOKEN_FROM",
  "SQL_TOKEN_FULL", "SQL_TOKEN_GRANT", "SQL_TOKEN_GROUP",
  "SQL_TOKEN_HAVING", "SQL_TOKEN_IN", "SQL_TOKEN_INDICATOR",
  "SQL_TOKEN_INNER", "SQL_TOKEN_INTEGER", "SQL_TOKEN_INTO", "SQL_TOKEN_IS",
  "SQL_TOKEN_INTERSECT", "SQL_TOKEN_JOIN", "SQL_TOKEN_KEY",
  "SQL_TOKEN_LEADING", "SQL_TOKEN_LIKE", "SQL_TOKEN_LOCAL",
  "SQL_TOKEN_LOWER", "SQL_TOKEN_MAX", "SQL_TOKEN_MIN", "SQL_TOKEN_NATURAL",
  "SQL_TOKEN_NCHAR", "SQL_TOKEN_NULL", "SQL_TOKEN_NUMERIC",
  "SQL_TOKEN_OCTET_LENGTH", "SQL_TOKEN_OF", "SQL_TOKEN_ON",
  "SQL_TOKEN_OPTION", "SQL_TOKEN_ORDER", "SQL_TOKEN_OUTER",
  "SQL_TOKEN_PRECISION", "SQL_TOKEN_PRIMARY", "SQL_TOKEN_PRIVILEGES",
  "SQL_TOKEN_PROCEDURE", "SQL_TOKEN_PUBLIC", "SQL_TOKEN_REAL",
  "SQL_TOKEN_REFERENCES", "SQL_TOKEN_ROLLBACK", "SQL_TOKEN_SCHEMA",
  "SQL_TOKEN_SELECT", "SQL_TOKEN_SET", "SQL_TOKEN_SIZE",
  "SQL_TOKEN_SMALLINT", "SQL_TOKEN_SOME", "SQL_TOKEN_SQLCODE",
  "SQL_TOKEN_SQLERROR", "SQL_TOKEN_SUM", "SQL_TOKEN_TABLE",
  "SQL_TOKEN_TIME", "SQL_TOKEN_TIMESTAMP", "SQL_TOKEN_TIMEZONE_HOUR",
  "SQL_TOKEN_TIMEZONE_MINUTE", "SQL_TOKEN_TO", "SQL_TOKEN_TRAILING",
  "SQL_TOKEN_TRANSLATE", "SQL_TOKEN_TRIM", "SQL_TOKEN_TRUE",
  "SQL_TOKEN_UNION", "SQL_TOKEN_UNIQUE", "SQL_TOKEN_UNKNOWN",
  "SQL_TOKEN_UPDATE", "SQL_TOKEN_UPPER", "SQL_TOKEN_USAGE",
  "SQL_TOKEN_USER", "SQL_TOKEN_USING", "SQL_TOKEN_VALUES",
  "SQL_TOKEN_VIEW", "SQL_TOKEN_WHERE", "SQL_TOKEN_WITH", "SQL_TOKEN_WORK",
  "SQL_TOKEN_ZONE", "SQL_TOKEN_CALL", "SQL_TOKEN_D", "SQL_TOKEN_FN",
  "SQL_TOKEN_T", "SQL_TOKEN_TS", "SQL_TOKEN_OJ", "SQL_TOKEN_ASCII",
  "SQL_TOKEN_BIT_LENGTH", "SQL_TOKEN_CHAR", "SQL_TOKEN_CHAR_LENGTH",
  "SQL_TOKEN_SQL_TOKEN_INTNUM", "SQL_TOKEN_CONCAT", "SQL_TOKEN_DIFFERENCE",
  "SQL_TOKEN_INSERT", "SQL_TOKEN_LCASE", "SQL_TOKEN_LEFT",
  "SQL_TOKEN_LENGTH", "SQL_TOKEN_LOCATE", "SQL_TOKEN_LOCATE_2",
  "SQL_TOKEN_LTRIM", "SQL_TOKEN_POSITION", "SQL_TOKEN_REPEAT",
  "SQL_TOKEN_REPLACE", "SQL_TOKEN_RIGHT", "SQL_TOKEN_RTRIM",
  "SQL_TOKEN_SOUNDEX", "SQL_TOKEN_SPACE", "SQL_TOKEN_SUBSTRING",
  "SQL_TOKEN_UCASE", "SQL_TOKEN_CURRENT_DATE", "SQL_TOKEN_CURRENT_TIME",
  "SQL_TOKEN_CURRENT_TIMESTAMP", "SQL_TOKEN_CURDATE", "SQL_TOKEN_CURTIME",
  "SQL_TOKEN_DAYNAME", "SQL_TOKEN_DAYOFMONTH", "SQL_TOKEN_DAYOFWEEK",
  "SQL_TOKEN_DAYOFYEAR", "SQL_TOKEN_EXTRACT", "SQL_TOKEN_HOUR",
  "SQL_TOKEN_MILLISECOND", "SQL_TOKEN_MINUTE", "SQL_TOKEN_MONTH",
  "SQL_TOKEN_MONTHNAME", "SQL_TOKEN_NOW", "SQL_TOKEN_QUARTER",
  "SQL_TOKEN_DATEDIFF", "SQL_TOKEN_SECOND", "SQL_TOKEN_TIMESTAMPADD",
  "SQL_TOKEN_TIMESTAMPDIFF", "SQL_TOKEN_TIMEVALUE", "SQL_TOKEN_WEEK",
  "SQL_TOKEN_WEEKDAY", "SQL_TOKEN_YEAR", "SQL_TOKEN_YEARDAY",
  "SQL_TOKEN_DATEADD", "SQL_TOKEN_ABS", "SQL_TOKEN_ACOS", "SQL_TOKEN_ASIN",
  "SQL_TOKEN_ATAN", "SQL_TOKEN_ATAN2", "SQL_TOKEN_CEILING",
  "SQL_TOKEN_COS", "SQL_TOKEN_COT", "SQL_TOKEN_DEGREES", "SQL_TOKEN_EXP",
  "SQL_TOKEN_FLOOR", "SQL_TOKEN_LOGF", "SQL_TOKEN_LOG", "SQL_TOKEN_LN",
  "SQL_TOKEN_LOG10", "SQL_TOKEN_MOD", "SQL_TOKEN_PI", "SQL_TOKEN_POWER",
  "SQL_TOKEN_RADIANS", "SQL_TOKEN_RAND", "SQL_TOKEN_ROUNDMAGIC",
  "SQL_TOKEN_ROUND", "SQL_TOKEN_SIGN", "SQL_TOKEN_SIN", "SQL_TOKEN_SQRT",
  "SQL_TOKEN_TAN", "SQL_TOKEN_TRUNCATE", "SQL_TOKEN_EVERY",
  "SQL_TOKEN_INTERSECTION", "SQL_TOKEN_FUSION", "SQL_TOKEN_COLLECT",
  "SQL_TOKEN_VAR_POP", "SQL_TOKEN_VAR_SAMP", "SQL_TOKEN_STDDEV_SAMP",
  "SQL_TOKEN_STDDEV_POP", "SQL_TOKEN_RANK", "SQL_TOKEN_DENSE_RANK",
  "SQL_TOKEN_PERCENT_RANK", "SQL_TOKEN_CUME_DIST",
  "SQL_TOKEN_PERCENTILE_CONT", "SQL_TOKEN_PERCENTILE_DISC",
  "SQL_TOKEN_WITHIN", "SQL_TOKEN_ARRAY_AGG", "SQL_TOKEN_CASE",
  "SQL_TOKEN_THEN", "SQL_TOKEN_END", "SQL_TOKEN_NULLIF",
  "SQL_TOKEN_COALESCE", "SQL_TOKEN_WHEN", "SQL_TOKEN_ELSE",
  "SQL_TOKEN_BEFORE", "SQL_TOKEN_AFTER", "SQL_TOKEN_INSTEAD",
  "SQL_TOKEN_EACH", "SQL_TOKEN_REFERENCING", "SQL_TOKEN_BEGIN",
  "SQL_TOKEN_ATOMIC", "SQL_TOKEN_TRIGGER", "SQL_TOKEN_ROW",
  "SQL_TOKEN_STATEMENT", "SQL_TOKEN_NEW", "SQL_TOKEN_OLD",
  "SQL_TOKEN_VALUE", "SQL_TOKEN_CURRENT_CATALOG",
  "SQL_TOKEN_CURRENT_DEFAULT_TRANSFORM_GROUP", "SQL_TOKEN_CURRENT_PATH",
  "SQL_TOKEN_CURRENT_ROLE", "SQL_TOKEN_CURRENT_SCHEMA",
  "SQL_TOKEN_CURRENT_USER", "SQL_TOKEN_SESSION_USER",
  "SQL_TOKEN_SYSTEM_USER", "SQL_TOKEN_VARCHAR", "SQL_TOKEN_VARBINARY",
  "SQL_TOKEN_VARYING", "SQL_TOKEN_OBJECT", "SQL_TOKEN_NCLOB",
  "SQL_TOKEN_NATIONAL", "SQL_TOKEN_LARGE", "SQL_TOKEN_CLOB",
  "SQL_TOKEN_BLOB", "SQL_TOKEN_BIGINT", "SQL_TOKEN_BINARY",
  "SQL_TOKEN_WITHOUT", "SQL_TOKEN_BOOLEAN", "SQL_TOKEN_INTERVAL",
  "SQL_TOKEN_OVER", "SQL_TOKEN_ROW_NUMBER", "SQL_TOKEN_NTILE",
  "SQL_TOKEN_LEAD", "SQL_TOKEN_LAG", "SQL_TOKEN_RESPECT",
  "SQL_TOKEN_IGNORE", "SQL_TOKEN_NULLS", "SQL_TOKEN_FIRST_VALUE",
  "SQL_TOKEN_LAST_VALUE", "SQL_TOKEN_NTH_VALUE", "SQL_TOKEN_FIRST",
  "SQL_TOKEN_LAST", "SQL_TOKEN_EXCLUDE", "SQL_TOKEN_OTHERS",
  "SQL_TOKEN_TIES", "SQL_TOKEN_FOLLOWING", "SQL_TOKEN_UNBOUNDED",
  "SQL_TOKEN_PRECEDING", "SQL_TOKEN_RANGE", "SQL_TOKEN_ROWS",
  "SQL_TOKEN_PARTITION", "SQL_TOKEN_WINDOW", "SQL_TOKEN_NO",
  "SQL_TOKEN_LIMIT", "SQL_TOKEN_OFFSET", "SQL_TOKEN_NEXT",
  "SQL_TOKEN_ONLY", "SQL_TOKEN_OR", "SQL_TOKEN_AND", "SQL_LESSEQ",
  "SQL_GREATEQ", "SQL_NOTEQUAL", "SQL_LESS", "SQL_GREAT", "SQL_EQUAL",
  "'+'", "'-'", "SQL_CONCAT", "'*'", "'/'", "'='",
  "SQL_TOKEN_INVALIDSYMBOL", "$accept", "sql_single_statement", "sql",
  "schema_element", "base_table_def", "base_table_element_commalist",
  "base_table_element", "column_def", "column_def_opt_list", "nil_fkt",
  "unique_spec", "column_def_opt", "table_constraint_def",
  "op_column_commalist", "column_commalist", "view_def",
  "opt_with_check_option", "opt_column_commalist", "privilege_def",
  "opt_with_grant_option", "privileges", "operation_commalist",
  "operation", "grantee_commalist", "grantee", "opt_order_by_clause",
  "ordering_spec_commalist", "ordering_spec", "opt_asc_desc", "sql_not",
  "manipulative_statement", "union_statement", "commit_statement",
  "delete_statement_searched", "fetch_statement", "insert_statement",
  "values_or_query_spec", "table_value_const_list",
  "row_value_constructor", "row_value_constructor_elem",
  "rollback_statement", "select_statement_into", "opt_all_distinct",
  "assignment_commalist", "assignment", "update_source",
  "update_statement_searched", "target_commalist", "target",
  "opt_where_clause", "query_term", "select_statement", "selection",
  "opt_result_offset_clause", "result_offset_clause",
  "opt_fetch_first_row_count", "first_or_next", "row_or_rows",
  "opt_fetch_first_clause", "fetch_first_clause", "offset_row_count",
  "fetch_first_row_count", "opt_limit_offset_clause", "opt_offset",
  "limit_offset_clause", "table_exp", "from_clause", "table_ref_commalist",
  "opt_as", "opt_row", "table_primary_as_range_column", "table_ref",
  "where_clause", "opt_group_by_clause", "column_ref_commalist",
  "opt_having_clause", "boolean_primary",
  "parenthesized_boolean_value_expression", "boolean_factor",
  "boolean_term", "search_condition", "predicate",
  "comparison_predicate_part_2", "comparison_predicate", "comparison",
  "between_predicate_part_2", "between_predicate",
  "character_like_predicate_part_2", "other_like_predicate_part_2",
  "like_predicate", "opt_escape", "null_predicate_part_2", "test_for_null",
  "in_predicate_value", "in_predicate_part_2", "in_predicate",
  "quantified_comparison_predicate_part_2", "all_or_any_predicate",
  "any_all_some", "existence_test", "unique_test", "subquery",
  "scalar_exp_commalist", "select_sublist", "parameter_ref", "literal",
  "as_clause", "position_exp", "num_value_fct", "char_length_exp",
  "octet_length_exp", "bit_length_exp", "length_exp", "datetime_field",
  "extract_field", "time_zone_field", "extract_exp", "unsigned_value_spec",
  "general_value_spec", "set_fct_spec", "function_name0", "function_name1",
  "function_name2", "function_name12", "function_name23", "function_name3",
  "function_name", "string_function_1Argument",
  "string_function_2Argument", "string_function_3Argument",
  "string_function_4Argument", "string_function",
  "date_function_0Argument", "date_function_1Argument", "date_function",
  "numeric_function_0Argument", "numeric_function_1Argument",
  "numeric_function_2Argument", "numeric_function", "window_function",
  "window_function_type", "ntile_function",
  "dynamic_parameter_specification", "simple_value_specification",
  "number_of_tiles", "opt_lead_or_lag_function", "opt_null_treatment",
  "lead_or_lag_function", "lead_or_lag", "lead_or_lag_extent", "offset",
  "default_expression", "null_treatment", "first_or_last_value_function",
  "first_or_last_value", "opt_from_first_or_last", "nth_value_function",
  "nth_row", "from_first_or_last", "window_name",
  "window_name_or_specification", "in_line_window_specification",
  "opt_window_clause", "window_clause", "window_definition_list",
  "window_definition", "new_window_name", "window_specification",
  "opt_existing_window_name", "opt_window_partition_clause",
  "opt_window_frame_clause", "existing_window_name",
  "window_partition_clause", "window_partition_column_reference_list",
  "window_partition_column_reference", "opt_window_frame_exclusion",
  "window_frame_clause", "window_frame_units", "window_frame_extent",
  "window_frame_start", "window_frame_preceding", "window_frame_between",
  "window_frame_bound_1", "window_frame_bound_2", "window_frame_bound",
  "window_frame_following", "window_frame_exclusion", "op_parameter",
  "odbc_call_spec", "op_odbc_call_parameter", "odbc_parameter_commalist",
  "odbc_parameter", "odbc_fct_spec", "odbc_fct_type", "general_set_fct",
  "set_fct_type", "ordered_set_function", "hypothetical_set_function",
  "within_group_specification",
  "hypothetical_set_function_value_expression_list",
  "inverse_distribution_function",
  "inverse_distribution_function_argument",
  "inverse_distribution_function_type", "array_aggregate_function",
  "rank_function_type", "outer_join_type", "join_condition", "join_spec",
  "join_type", "cross_union", "qualified_join", "joined_table",
  "named_columns_join", "simple_table", "non_join_query_primary",
  "non_join_query_term", "query_primary", "non_join_query_exp", "all",
  "query_exp", "scalar_subquery", "cast_operand", "cast_target",
  "cast_spec", "value_exp_primary", "num_primary", "factor", "term",
  "num_value_exp", "datetime_primary", "datetime_value_fct", "time_zone",
  "time_zone_specifier", "datetime_factor", "datetime_term",
  "datetime_value_exp", "non_second_datetime_field", "datetime_unit",
  "start_field", "end_field", "single_datetime_field",
  "interval_qualifier", "function_arg_commalist2",
  "function_arg_commalist3", "function_arg_commalist4",
  "value_exp_commalist", "function_arg", "function_args_commalist",
  "value_exp", "string_value_exp", "char_value_exp", "concatenation",
  "char_primary", "collate_clause", "char_factor", "string_value_fct",
  "bit_value_fct", "bit_substring_fct", "bit_value_exp", "bit_factor",
  "bit_primary", "char_value_fct", "for_length", "char_substring_fct",
  "upper_lower", "fold", "form_conversion", "char_translation", "trim_fct",
  "trim_operands", "trim_spec", "derived_column", "table_node",
  "catalog_name", "schema_name", "table_name", "column_ref", "column_val",
  "data_type", "opt_char_set_spec", "opt_collate_clause",
  "predefined_type", "character_string_type", "opt_paren_precision",
  "paren_char_length", "opt_paren_char_large_length",
  "paren_character_large_object_length", "large_object_length",
  "opt_multiplier", "character_large_object_type",
  "national_character_string_type", "national_character_large_object_type",
  "binary_string_type", "binary_large_object_string_type", "numeric_type",
  "opt_paren_precision_scale", "exact_numeric_type",
  "approximate_numeric_type", "boolean_type", "datetime_type",
  "opt_with_or_without_time_zone", "interval_type", "column",
  "case_expression", "case_abbreviation", "case_specification",
  "simple_case", "searched_case", "simple_when_clause_list",
  "simple_when_clause", "when_operand_list", "when_operand",
  "searched_when_clause_list", "searched_when_clause", "else_clause",
  "result", "result_expression", "case_operand", "cursor", "parameter",
  "range_variable", "user", "trigger_definition", "op_referencing",
  "trigger_action_time", "trigger_event", "op_trigger_columnlist",
  "trigger_column_list", "triggered_action", "op_triggered_action_for",
  "trigger_for", "triggered_when_clause", "triggered_SQL_statement",
  "SQL_procedure_statement_list", "SQL_procedure_statement",
  "transition_table_or_variable_list", "transition_table_or_variable",
  "old_transition_table_name", "new_transition_table_name",
  "transition_table_name", "old_transition_variable_name",
  "new_transition_variable_name", "trigger_name", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

/** Left-hand-side symbol for rule #YYRULE.  */
static inline yysymbol_kind_t
yylhsNonterm (yyRuleNum yyrule)
{
  return YY_CAST (yysymbol_kind_t, yyr1[yyrule]);
}

#if YYDEBUG

# ifndef YYFPRINTF
#  define YYFPRINTF fprintf
# endif

# define YY_FPRINTF                             \
  YY_IGNORE_USELESS_CAST_BEGIN YY_FPRINTF_

# define YY_FPRINTF_(Args)                      \
  do {                                          \
    YYFPRINTF Args;                             \
    YY_IGNORE_USELESS_CAST_END                  \
  } while (0)

# define YY_DPRINTF                             \
  YY_IGNORE_USELESS_CAST_BEGIN YY_DPRINTF_

# define YY_DPRINTF_(Args)                      \
  do {                                          \
    if (yydebug)                                \
      YYFPRINTF Args;                           \
    YY_IGNORE_USELESS_CAST_END                  \
  } while (0)





/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                  \
  do {                                                                  \
    if (yydebug)                                                        \
      {                                                                 \
        YY_FPRINTF ((stderr, "%s ", Title));                            \
        yy_symbol_print (stderr, Kind, Value);        \
        YY_FPRINTF ((stderr, "\n"));                                    \
      }                                                                 \
  } while (0)

static inline void
yy_reduce_print (yybool yynormal, yyGLRStackItem* yyvsp, YYPTRDIFF_T yyk,
                 yyRuleNum yyrule);

# define YY_REDUCE_PRINT(Args)          \
  do {                                  \
    if (yydebug)                        \
      yy_reduce_print Args;             \
  } while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;

static void yypstack (yyGLRStack* yystackp, YYPTRDIFF_T yyk)
  YY_ATTRIBUTE_UNUSED;
static void yypdumpstack (yyGLRStack* yystackp)
  YY_ATTRIBUTE_UNUSED;

#else /* !YYDEBUG */

# define YY_DPRINTF(Args) do {} while (yyfalse)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_REDUCE_PRINT(Args)

#endif /* !YYDEBUG */



/** Fill in YYVSP[YYLOW1 .. YYLOW0-1] from the chain of states starting
 *  at YYVSP[YYLOW0].yystate.yypred.  Leaves YYVSP[YYLOW1].yystate.yypred
 *  containing the pointer to the next state in the chain.  */
static void yyfillin (yyGLRStackItem *, int, int) YY_ATTRIBUTE_UNUSED;
static void
yyfillin (yyGLRStackItem *yyvsp, int yylow0, int yylow1)
{
  int i;
  yyGLRState *s = yyvsp[yylow0].yystate.yypred;
  for (i = yylow0-1; i >= yylow1; i -= 1)
    {
#if YYDEBUG
      yyvsp[i].yystate.yylrState = s->yylrState;
#endif
      yyvsp[i].yystate.yyresolved = s->yyresolved;
      if (s->yyresolved)
        yyvsp[i].yystate.yysemantics.yyval = s->yysemantics.yyval;
      else
        /* The effect of using yyval or yyloc (in an immediate rule) is
         * undefined.  */
        yyvsp[i].yystate.yysemantics.yyfirstVal = YY_NULLPTR;
      s = yyvsp[i].yystate.yypred = s->yypred;
    }
}


/** If yychar is empty, fetch the next token.  */
static inline yysymbol_kind_t
yygetToken (int *yycharp)
{
  yysymbol_kind_t yytoken;
  if (*yycharp == YYEMPTY)
    {
      YY_DPRINTF ((stderr, "Reading a token\n"));
      *yycharp = yylex ();
    }
  if (*yycharp <= YYEOF)
    {
      *yycharp = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YY_DPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (*yycharp);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }
  return yytoken;
}

/* Do nothing if YYNORMAL or if *YYLOW <= YYLOW1.  Otherwise, fill in
 * YYVSP[YYLOW1 .. *YYLOW-1] as in yyfillin and set *YYLOW = YYLOW1.
 * For convenience, always return YYLOW1.  */
static inline int yyfill (yyGLRStackItem *, int *, int, yybool)
     YY_ATTRIBUTE_UNUSED;
static inline int
yyfill (yyGLRStackItem *yyvsp, int *yylow, int yylow1, yybool yynormal)
{
  if (!yynormal && yylow1 < *yylow)
    {
      yyfillin (yyvsp, *yylow, yylow1);
      *yylow = yylow1;
    }
  return yylow1;
}

/** Perform user action for rule number YYN, with RHS length YYRHSLEN,
 *  and top stack item YYVSP.  YYLVALP points to place to put semantic
 *  value ($$), and yylocp points to place for location information
 *  (@$).  Returns yyok for normal return, yyaccept for YYACCEPT,
 *  yyerr for YYERROR, yyabort for YYABORT, yynomem for YYNOMEM.  */
static YYRESULTTAG
yyuserAction (yyRuleNum yyrule, int yyrhslen, yyGLRStackItem* yyvsp,
              yyGLRStack* yystackp, YYPTRDIFF_T yyk,
              YYSTYPE* yyvalp)
{
  const yybool yynormal YY_ATTRIBUTE_UNUSED = yystackp->yysplitPoint == YY_NULLPTR;
  int yylow = 1;
  YY_USE (yyvalp);
  YY_USE (yyk);
  YY_USE (yyrhslen);
# undef yyerrok
# define yyerrok (yystackp->yyerrState = 0)
# undef YYACCEPT
# define YYACCEPT return yyaccept
# undef YYABORT
# define YYABORT return yyabort
# undef YYNOMEM
# define YYNOMEM return yynomem
# undef YYERROR
# define YYERROR return yyerrok, yyerr
# undef YYRECOVERING
# define YYRECOVERING() (yystackp->yyerrState != 0)
# undef yyclearin
# define yyclearin (yychar = YYEMPTY)
# undef YYFILL
# define YYFILL(N) yyfill (yyvsp, &yylow, (N), yynormal)
# undef YYBACKUP
# define YYBACKUP(Token, Value)                                              \
  return yyerror (YY_("syntax error: cannot back up")),     \
         yyerrok, yyerr

  if (yyrhslen == 0)
    *yyvalp = yyval_default;
  else
    *yyvalp = yyvsp[YYFILL (1-yyrhslen)].yystate.yysemantics.yyval;
  /* If yyk == -1, we are running a deferred action on a temporary
     stack.  In that case, YY_REDUCE_PRINT must not play with YYFILL,
     so pretend the stack is "normal". */
  YY_REDUCE_PRINT ((yynormal || yyk == -1, yyvsp, yyk, yyrule));
  switch (yyrule)
    {
  case 2: /* sql_single_statement: sql  */
                { xxx_pGLOBAL_SQLPARSER->setParseTree( (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode) ); }
    break;

  case 3: /* sql_single_statement: sql ';'  */
                { xxx_pGLOBAL_SQLPARSER->setParseTree( (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode) ); }
    break;

  case 5: /* sql: schema_element  */
           {
                ((*yyvalp).pParseNode) = SQL_NEW_RULE;
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
	   }
    break;

  case 10: /* base_table_def: SQL_TOKEN_CREATE SQL_TOKEN_TABLE table_node '(' base_table_element_commalist ')'  */
                {((*yyvalp).pParseNode) = SQL_NEW_RULE;
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-5)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));}
    break;

  case 11: /* base_table_element_commalist: base_table_element  */
                {((*yyvalp).pParseNode) = SQL_NEW_COMMALISTRULE;
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 12: /* base_table_element_commalist: base_table_element_commalist ',' base_table_element  */
                {(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode);}
    break;

  case 15: /* column_def: column data_type column_def_opt_list  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
			}
    break;

  case 16: /* column_def_opt_list: %empty  */
                                            {((*yyvalp).pParseNode) = SQL_NEW_LISTRULE;}
    break;

  case 17: /* column_def_opt_list: column_def_opt_list column_def_opt  */
                        {(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode);}
    break;

  case 20: /* unique_spec: SQL_TOKEN_PRIMARY SQL_TOKEN_KEY  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 21: /* column_def_opt: SQL_TOKEN_NOT SQL_TOKEN_NULL  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 23: /* column_def_opt: SQL_TOKEN_DEFAULT literal  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 24: /* column_def_opt: SQL_TOKEN_DEFAULT SQL_TOKEN_NULL  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 25: /* column_def_opt: SQL_TOKEN_DEFAULT SQL_TOKEN_USER  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 26: /* column_def_opt: SQL_TOKEN_DEFAULT nil_fkt  */
                        {
				((*yyvalp).pParseNode) = SQL_NEW_RULE;
				((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
				((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
			}
    break;

  case 28: /* column_def_opt: SQL_TOKEN_CHECK '(' search_condition ')'  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));}
    break;

  case 29: /* column_def_opt: SQL_TOKEN_REFERENCES table_node  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 30: /* column_def_opt: SQL_TOKEN_REFERENCES table_node '(' column_commalist ')'  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));}
    break;

  case 31: /* table_constraint_def: unique_spec '(' column_commalist ')'  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));}
    break;

  case 32: /* table_constraint_def: SQL_TOKEN_FOREIGN SQL_TOKEN_KEY '(' column_commalist ')' SQL_TOKEN_REFERENCES table_node  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-6)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-5)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 33: /* table_constraint_def: SQL_TOKEN_FOREIGN SQL_TOKEN_KEY '(' column_commalist ')' SQL_TOKEN_REFERENCES table_node '(' column_commalist ')'  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-9)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-8)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-6)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));}
    break;

  case 34: /* table_constraint_def: SQL_TOKEN_CHECK '(' search_condition ')'  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));}
    break;

  case 35: /* op_column_commalist: %empty  */
                    {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 36: /* op_column_commalist: '(' column_commalist ')'  */
                {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 37: /* column_commalist: column_commalist ',' column  */
                        {(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode);}
    break;

  case 38: /* column_commalist: column  */
                        {((*yyvalp).pParseNode) = SQL_NEW_COMMALISTRULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 39: /* view_def: SQL_TOKEN_CREATE SQL_TOKEN_VIEW table_node opt_column_commalist SQL_TOKEN_AS select_statement opt_with_check_option  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-6)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-5)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 40: /* opt_with_check_option: %empty  */
                                    {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 41: /* opt_with_check_option: SQL_TOKEN_WITH SQL_TOKEN_CHECK SQL_TOKEN_OPTION  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 42: /* opt_column_commalist: %empty  */
                                    {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 43: /* opt_column_commalist: '(' column_commalist ')'  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));}
    break;

  case 44: /* privilege_def: SQL_TOKEN_GRANT privileges SQL_TOKEN_ON table_node SQL_TOKEN_TO grantee_commalist opt_with_grant_option  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-6)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-5)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 45: /* opt_with_grant_option: %empty  */
                                    {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 46: /* opt_with_grant_option: SQL_TOKEN_WITH SQL_TOKEN_GRANT SQL_TOKEN_OPTION  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 47: /* privileges: SQL_TOKEN_ALL SQL_TOKEN_PRIVILEGES  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 49: /* operation_commalist: operation  */
                        {((*yyvalp).pParseNode) = SQL_NEW_COMMALISTRULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 50: /* operation_commalist: operation_commalist ',' operation  */
                        {(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode);}
    break;

  case 52: /* operation: SQL_TOKEN_INSERT opt_column_commalist  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 54: /* operation: SQL_TOKEN_UPDATE opt_column_commalist  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 55: /* operation: SQL_TOKEN_REFERENCES opt_column_commalist  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 57: /* grantee_commalist: grantee  */
                        {((*yyvalp).pParseNode) = SQL_NEW_COMMALISTRULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 58: /* grantee_commalist: grantee_commalist ',' grantee  */
                        {(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode);}
    break;

  case 61: /* opt_order_by_clause: %empty  */
                                    {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 62: /* opt_order_by_clause: SQL_TOKEN_ORDER SQL_TOKEN_BY ordering_spec_commalist  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 63: /* ordering_spec_commalist: ordering_spec  */
                        {((*yyvalp).pParseNode) = SQL_NEW_COMMALISTRULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 64: /* ordering_spec_commalist: ordering_spec_commalist ',' ordering_spec  */
                        {(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode);}
    break;

  case 65: /* ordering_spec: predicate opt_asc_desc  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 66: /* ordering_spec: row_value_constructor_elem opt_asc_desc  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 67: /* opt_asc_desc: %empty  */
                {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 70: /* sql_not: %empty  */
        {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 80: /* manipulative_statement: '{' odbc_call_spec '}'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append(newNode("{", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("}", SQLNodeType::Punctuation));
		}
    break;

  case 82: /* union_statement: union_statement SQL_TOKEN_UNION all select_statement  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 83: /* commit_statement: SQL_TOKEN_COMMIT SQL_TOKEN_WORK  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 84: /* delete_statement_searched: SQL_TOKEN_DELETE SQL_TOKEN_FROM table_node opt_where_clause  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 85: /* fetch_statement: SQL_TOKEN_FETCH cursor SQL_TOKEN_INTO target_commalist  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 86: /* insert_statement: SQL_TOKEN_INSERT SQL_TOKEN_INTO table_node opt_column_commalist query_exp  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 87: /* values_or_query_spec: SQL_TOKEN_VALUES '(' table_value_const_list ')'  */
                {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 88: /* table_value_const_list: row_value_constructor  */
                        {((*yyvalp).pParseNode) = SQL_NEW_COMMALISTRULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 89: /* table_value_const_list: table_value_const_list ',' row_value_constructor  */
                        {(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode);}
    break;

  case 93: /* rollback_statement: SQL_TOKEN_ROLLBACK SQL_TOKEN_WORK  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 94: /* select_statement_into: SQL_TOKEN_SELECT opt_all_distinct selection SQL_TOKEN_INTO target_commalist table_exp  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-5)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode)); }
    break;

  case 95: /* opt_all_distinct: %empty  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 98: /* assignment_commalist: assignment  */
                        {((*yyvalp).pParseNode) = SQL_NEW_COMMALISTRULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 99: /* assignment_commalist: assignment_commalist ',' assignment  */
                        {(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode);}
    break;

  case 100: /* assignment: column SQL_EQUAL update_source  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 103: /* update_statement_searched: SQL_TOKEN_UPDATE table_node SQL_TOKEN_SET assignment_commalist opt_where_clause  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 104: /* target_commalist: target  */
                        {((*yyvalp).pParseNode) = SQL_NEW_COMMALISTRULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 105: /* target_commalist: target_commalist ',' target  */
                        {(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode);}
    break;

  case 107: /* opt_where_clause: %empty  */
                                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 109: /* query_term: non_join_query_term  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 110: /* select_statement: SQL_TOKEN_SELECT opt_all_distinct selection table_exp  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 111: /* selection: '*'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append(newNode("*", SQLNodeType::Punctuation));
		}
    break;

  case 113: /* opt_result_offset_clause: %empty  */
                            {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 115: /* result_offset_clause: SQL_TOKEN_OFFSET offset_row_count row_or_rows  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
	}
    break;

  case 116: /* opt_fetch_first_row_count: %empty  */
                            {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 122: /* opt_fetch_first_clause: %empty  */
                            {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 124: /* fetch_first_clause: SQL_TOKEN_FETCH first_or_next opt_fetch_first_row_count row_or_rows SQL_TOKEN_ONLY  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
	}
    break;

  case 127: /* opt_limit_offset_clause: %empty  */
                            {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 129: /* opt_offset: %empty  */
                            {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 130: /* opt_offset: SQL_TOKEN_OFFSET SQL_TOKEN_INTNUM  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
	}
    break;

  case 131: /* limit_offset_clause: SQL_TOKEN_LIMIT SQL_TOKEN_INTNUM opt_offset  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
	}
    break;

  case 132: /* table_exp: from_clause opt_where_clause opt_group_by_clause opt_having_clause opt_window_clause opt_order_by_clause opt_limit_offset_clause opt_result_offset_clause opt_fetch_first_clause  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-8)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-7)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-6)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-5)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 133: /* from_clause: SQL_TOKEN_FROM table_ref_commalist  */
                        { ((*yyvalp).pParseNode) = SQL_NEW_RULE;
			  ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			  ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode)); }
    break;

  case 134: /* table_ref_commalist: table_ref  */
                        { ((*yyvalp).pParseNode) = SQL_NEW_COMMALISTRULE;
			  ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode)); }
    break;

  case 135: /* table_ref_commalist: table_ref_commalist ',' table_ref  */
                        { (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
			  ((*yyvalp).pParseNode) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode); }
    break;

  case 136: /* opt_as: %empty  */
                            {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 138: /* opt_row: %empty  */
                            {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 140: /* table_primary_as_range_column: %empty  */
        {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 141: /* table_primary_as_range_column: opt_as SQL_TOKEN_NAME op_column_commalist  */
                {
		    ((*yyvalp).pParseNode) = SQL_NEW_RULE;
		    ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
		    ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
		    ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 142: /* table_ref: table_node table_primary_as_range_column  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 143: /* table_ref: subquery range_variable op_column_commalist  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 145: /* table_ref: '{' SQL_TOKEN_OJ joined_table '}'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append(newNode("{", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("}", SQLNodeType::Punctuation));
		}
    break;

  case 146: /* table_ref: '(' joined_table ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 147: /* where_clause: SQL_TOKEN_WHERE search_condition  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 148: /* opt_group_by_clause: %empty  */
                                 {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 149: /* opt_group_by_clause: SQL_TOKEN_GROUP SQL_TOKEN_BY column_ref_commalist  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 150: /* column_ref_commalist: column_ref  */
                        {((*yyvalp).pParseNode) = SQL_NEW_COMMALISTRULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 151: /* column_ref_commalist: set_fct_spec  */
                {((*yyvalp).pParseNode) = SQL_NEW_COMMALISTRULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 152: /* column_ref_commalist: column_ref_commalist ',' column_ref  */
                        {(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode);}
    break;

  case 153: /* column_ref_commalist: column_ref_commalist ',' set_fct_spec  */
                        {(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode);}
    break;

  case 154: /* opt_having_clause: %empty  */
                                            {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 155: /* opt_having_clause: SQL_TOKEN_HAVING search_condition  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 157: /* boolean_primary: '(' search_condition ')'  */
                { // boolean_primary: rule 2
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 158: /* boolean_primary: row_value_constructor_elem  */
                {
                    if(xxx_pGLOBAL_SQLPARSER->inPredicateCheck())// boolean_primary: rule 3
                    {
                        ((*yyvalp).pParseNode) = SQL_NEW_RULE;
                        sal_Int16 nErg = 0;
                        if ( SQL_ISTOKEN( (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode), NULL))
                        {
                            OSQLParseNode* pColumnRef = newNode("", SQLNodeType::Rule,OSQLParser::RuleID(OSQLParseNode::column_ref));
                            pColumnRef->append(newNode(xxx_pGLOBAL_SQLPARSER->getFieldName(),SQLNodeType::Name));
                            OSQLParseNode* pTFN = new OSQLInternalNode("", SQLNodeType::Rule,OSQLParser::RuleID(OSQLParseNode::test_for_null));
                            pTFN->append(pColumnRef);

                            OSQLParseNode* pNPP2 = new OSQLInternalNode("", SQLNodeType::Rule, OSQLParser::RuleID(OSQLParseNode::null_predicate_part_2));
                            pNPP2->append(new OSQLInternalNode("", SQLNodeType::Keyword, SQL_TOKEN_IS));
                            pNPP2->append(new OSQLInternalNode("", SQLNodeType::Rule, OSQLParser::RuleID(OSQLParseNode::sql_not)));
                            pNPP2->append(new OSQLInternalNode("", SQLNodeType::Keyword, SQL_TOKEN_NULL));
                            pTFN->append(pNPP2);

                            ((*yyvalp).pParseNode)->append(pTFN);

                            nErg = 1;
                        }
                        else
                        {
                            nErg = xxx_pGLOBAL_SQLPARSER->buildComparisonRule(((*yyvalp).pParseNode),(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
                        }
                        if(nErg == 1)
                        {
                            OSQLParseNode* pTemp = ((*yyvalp).pParseNode);
                            ((*yyvalp).pParseNode) = pTemp->removeAt((sal_uInt32)0);
                            delete pTemp;
                        }
                        else
                        {
                            delete ((*yyvalp).pParseNode);
                            if(nErg)
                                YYERROR;
                            else
                                YYABORT;
                        }
                    }
                    else
                        YYERROR;
                }
    break;

  case 159: /* parenthesized_boolean_value_expression: '(' search_condition ')'  */
        { // boolean_primary: rule 2
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
		((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
	}
    break;

  case 161: /* boolean_factor: SQL_TOKEN_NOT boolean_primary  */
                { // boolean_factor: rule 1
		    ((*yyvalp).pParseNode) = SQL_NEW_RULE;
		    ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
		    ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 163: /* boolean_term: boolean_term SQL_TOKEN_AND boolean_factor  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE; // boolean_term: rule 1
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 165: /* search_condition: search_condition SQL_TOKEN_OR boolean_term  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE; // search_condition
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 174: /* comparison_predicate_part_2: comparison row_value_constructor  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE; // comparison_predicate: rule 1
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 175: /* comparison_predicate: row_value_constructor comparison row_value_constructor  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE; // comparison_predicate: rule 1
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 176: /* comparison_predicate: comparison row_value_constructor  */
                {
			if(xxx_pGLOBAL_SQLPARSER->inPredicateCheck()) // comparison_predicate: rule 2
			{
				((*yyvalp).pParseNode) = SQL_NEW_RULE;
				sal_Int16 nErg = xxx_pGLOBAL_SQLPARSER->buildPredicateRule(((*yyvalp).pParseNode),(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode),(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
				if(nErg == 1)
				{
					OSQLParseNode* pTemp = ((*yyvalp).pParseNode);
					((*yyvalp).pParseNode) = pTemp->removeAt((sal_uInt32)0);
					delete pTemp;
				}
				else
				{
					delete ((*yyvalp).pParseNode);
					YYABORT;
				}
			}
			else
			{
				YYERROR;
			}
		}
    break;

  case 183: /* comparison: SQL_TOKEN_IS sql_not SQL_TOKEN_DISTINCT SQL_TOKEN_FROM  */
                {
		  ((*yyvalp).pParseNode) = SQL_NEW_RULE;
		  ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
		  ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
		  ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
		  ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 184: /* comparison: SQL_TOKEN_IS sql_not  */
                {
		  ((*yyvalp).pParseNode) = SQL_NEW_RULE;
		  ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
		  ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 185: /* between_predicate_part_2: sql_not SQL_TOKEN_BETWEEN row_value_constructor SQL_TOKEN_AND row_value_constructor  */
                {
			if (xxx_pGLOBAL_SQLPARSER->inPredicateCheck()) // between_predicate: rule 2
			{
				((*yyvalp).pParseNode) = SQL_NEW_RULE;

				sal_Int16 nErg = xxx_pGLOBAL_SQLPARSER->buildPredicateRule(((*yyvalp).pParseNode),(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode),(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode),(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
				if(nErg == 1)
				{
					OSQLParseNode* pTemp = ((*yyvalp).pParseNode);
					((*yyvalp).pParseNode) = pTemp->removeAt((sal_uInt32)0);
					OSQLParseNode* pColumnRef = ((*yyvalp).pParseNode)->removeAt((sal_uInt32)0);
					((*yyvalp).pParseNode)->insert(0,(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
					OSQLParseNode* pBetween_predicate = new OSQLInternalNode("", SQLNodeType::Rule,OSQLParser::RuleID(OSQLParseNode::between_predicate));
					pBetween_predicate->append(pColumnRef);
					pBetween_predicate->append(((*yyvalp).pParseNode));
					((*yyvalp).pParseNode) = pBetween_predicate;

					delete pTemp;
					delete (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode);
				}
				else
				{
					delete ((*yyvalp).pParseNode);
					YYABORT;
				}
			}
			else
			{
				((*yyvalp).pParseNode) = SQL_NEW_RULE; // between_predicate: rule 1
				((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
				((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
				((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
				((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
				((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
			}
		}
    break;

  case 186: /* between_predicate: row_value_constructor between_predicate_part_2  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE; // between_predicate: rule 1
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 188: /* character_like_predicate_part_2: sql_not SQL_TOKEN_LIKE string_value_exp opt_escape  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE; // like_predicate: rule 1
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 189: /* other_like_predicate_part_2: sql_not SQL_TOKEN_LIKE value_exp_primary opt_escape  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE; // like_predicate: rule 1
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 190: /* like_predicate: row_value_constructor character_like_predicate_part_2  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE; // like_predicate: rule 1
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 191: /* like_predicate: row_value_constructor other_like_predicate_part_2  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;  // like_predicate: rule 3
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 192: /* like_predicate: character_like_predicate_part_2  */
                {
			if (xxx_pGLOBAL_SQLPARSER->inPredicateCheck())  // like_predicate: rule 5
			{
				OSQLParseNode* pColumnRef = newNode("", SQLNodeType::Rule,OSQLParser::RuleID(OSQLParseNode::column_ref));
				pColumnRef->append(newNode(xxx_pGLOBAL_SQLPARSER->getFieldName(),SQLNodeType::Name));

				((*yyvalp).pParseNode) = SQL_NEW_RULE;
				((*yyvalp).pParseNode)->append(pColumnRef);
				((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
				OSQLParseNode* p2nd = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode)->removeAt(2);
				OSQLParseNode* p3rd = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode)->removeAt(2);
				if ( !xxx_pGLOBAL_SQLPARSER->buildLikeRule((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode),p2nd,p3rd) )
				{
					delete ((*yyvalp).pParseNode);
					YYABORT;
				}
				(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode)->append(p3rd);
			}
			else
				YYERROR;
		}
    break;

  case 193: /* like_predicate: other_like_predicate_part_2  */
                {
			if (xxx_pGLOBAL_SQLPARSER->inPredicateCheck()) // like_predicate: rule 6
			{
				OSQLParseNode* pColumnRef = newNode("", SQLNodeType::Rule,OSQLParser::RuleID(OSQLParseNode::column_ref));
				pColumnRef->append(newNode(xxx_pGLOBAL_SQLPARSER->getFieldName(),SQLNodeType::Name));

				((*yyvalp).pParseNode) = SQL_NEW_RULE;
				((*yyvalp).pParseNode)->append(pColumnRef);
				((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
				OSQLParseNode* p2nd = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode)->removeAt(2);
				OSQLParseNode* p3rd = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode)->removeAt(2);
				if ( !xxx_pGLOBAL_SQLPARSER->buildLikeRule((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode),p2nd,p3rd) )
				{
					delete ((*yyvalp).pParseNode);
					YYABORT;
				}
				(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode)->append(p3rd);
			}
			else
				YYERROR;
		}
    break;

  case 194: /* opt_escape: %empty  */
                                            {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 195: /* opt_escape: SQL_TOKEN_ESCAPE string_value_exp  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 196: /* opt_escape: '{' SQL_TOKEN_ESCAPE SQL_TOKEN_STRING '}'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append(newNode("{", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("}", SQLNodeType::Punctuation));
		}
    break;

  case 197: /* null_predicate_part_2: SQL_TOKEN_IS sql_not SQL_TOKEN_NULL  */
          {
		((*yyvalp).pParseNode) = SQL_NEW_RULE; // test_for_null: rule 1
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
	  }
    break;

  case 198: /* null_predicate_part_2: SQL_TOKEN_IS sql_not SQL_TOKEN_UNKNOWN  */
          {
		((*yyvalp).pParseNode) = SQL_NEW_RULE; // test_for_null: rule 1
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
	  }
    break;

  case 199: /* test_for_null: row_value_constructor null_predicate_part_2  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE; // test_for_null: rule 1
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 200: /* test_for_null: null_predicate_part_2  */
                {
			if (xxx_pGLOBAL_SQLPARSER->inPredicateCheck())// test_for_null: rule 2
			{
				OSQLParseNode* pColumnRef = newNode("", SQLNodeType::Rule,OSQLParser::RuleID(OSQLParseNode::column_ref));
				pColumnRef->append(newNode(xxx_pGLOBAL_SQLPARSER->getFieldName(),SQLNodeType::Name));

				((*yyvalp).pParseNode) = SQL_NEW_RULE;
				((*yyvalp).pParseNode)->append(pColumnRef);
				((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
			}
			else
				YYERROR;
		}
    break;

  case 201: /* in_predicate_value: subquery  */
                {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 202: /* in_predicate_value: '(' value_exp_commalist ')'  */
                {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 203: /* in_predicate_part_2: sql_not SQL_TOKEN_IN in_predicate_value  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;// in_predicate: rule 1
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
	}
    break;

  case 204: /* in_predicate: row_value_constructor in_predicate_part_2  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;// in_predicate: rule 1
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 205: /* in_predicate: in_predicate_part_2  */
                {
			if ( xxx_pGLOBAL_SQLPARSER->inPredicateCheck() )// in_predicate: rule 2
			{
				OSQLParseNode* pColumnRef = newNode("", SQLNodeType::Rule,OSQLParser::RuleID(OSQLParseNode::column_ref));
				pColumnRef->append(newNode(xxx_pGLOBAL_SQLPARSER->getFieldName(),SQLNodeType::Name));

				((*yyvalp).pParseNode) = SQL_NEW_RULE;
				((*yyvalp).pParseNode)->append(pColumnRef);
				((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
			}
			else
				YYERROR;
		}
    break;

  case 206: /* quantified_comparison_predicate_part_2: comparison any_all_some subquery  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
	}
    break;

  case 207: /* all_or_any_predicate: row_value_constructor quantified_comparison_predicate_part_2  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 208: /* all_or_any_predicate: quantified_comparison_predicate_part_2  */
                {
			if(xxx_pGLOBAL_SQLPARSER->inPredicateCheck())
			{
				OSQLParseNode* pColumnRef = newNode("", SQLNodeType::Rule,OSQLParser::RuleID(OSQLParseNode::column_ref));
				pColumnRef->append(newNode(xxx_pGLOBAL_SQLPARSER->getFieldName(),SQLNodeType::Name));

				((*yyvalp).pParseNode) = SQL_NEW_RULE;
				((*yyvalp).pParseNode)->append(pColumnRef);
				((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
			}
			else
				YYERROR;
		}
    break;

  case 212: /* existence_test: SQL_TOKEN_EXISTS subquery  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 213: /* unique_test: SQL_TOKEN_UNIQUE subquery  */
                {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 214: /* subquery: '(' query_exp ')'  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));}
    break;

  case 215: /* scalar_exp_commalist: select_sublist  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_COMMALISTRULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 216: /* scalar_exp_commalist: scalar_exp_commalist ',' select_sublist  */
                {
			(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode);
		}
    break;

  case 224: /* literal: literal SQL_TOKEN_STRING  */
                {
			if (xxx_pGLOBAL_SQLPARSER->inPredicateCheck())
			{
				((*yyvalp).pParseNode) = SQL_NEW_RULE;
				((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
				((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
				OSQLParser::reduceLiteral(((*yyvalp).pParseNode), true);
			}
			else
				YYERROR;
		}
    break;

  case 225: /* literal: literal SQL_TOKEN_INT  */
                {
			if (xxx_pGLOBAL_SQLPARSER->inPredicateCheck())
			{
				((*yyvalp).pParseNode) = SQL_NEW_RULE;
				((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
				((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
				OSQLParser::reduceLiteral(((*yyvalp).pParseNode), true);
			}
			else
				YYERROR;
		}
    break;

  case 226: /* literal: literal SQL_TOKEN_REAL_NUM  */
                {
			if (xxx_pGLOBAL_SQLPARSER->inPredicateCheck())
			{
				((*yyvalp).pParseNode) = SQL_NEW_RULE;
				((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
				((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
				OSQLParser::reduceLiteral(((*yyvalp).pParseNode), true);
			}
			else
				YYERROR;
		}
    break;

  case 227: /* literal: literal SQL_TOKEN_APPROXNUM  */
                {
			if (xxx_pGLOBAL_SQLPARSER->inPredicateCheck())
			{
				((*yyvalp).pParseNode) = SQL_NEW_RULE;
				((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
				((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
				OSQLParser::reduceLiteral(((*yyvalp).pParseNode), true);
			}
			else
				YYERROR;
		}
    break;

  case 228: /* as_clause: %empty  */
                            {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 229: /* as_clause: SQL_TOKEN_AS column  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 231: /* position_exp: SQL_TOKEN_POSITION '(' value_exp SQL_TOKEN_IN value_exp ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-5)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 232: /* position_exp: SQL_TOKEN_POSITION '(' value_exp_commalist ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 236: /* char_length_exp: SQL_TOKEN_CHAR_LENGTH '(' value_exp ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 237: /* char_length_exp: SQL_TOKEN_SQL_TOKEN_INTNUM '(' value_exp ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 238: /* octet_length_exp: SQL_TOKEN_OCTET_LENGTH '(' value_exp ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 239: /* bit_length_exp: SQL_TOKEN_BIT_LENGTH '(' value_exp ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 240: /* length_exp: char_length_exp  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 241: /* length_exp: octet_length_exp  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 242: /* length_exp: bit_length_exp  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 243: /* datetime_field: non_second_datetime_field  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 244: /* datetime_field: SQL_TOKEN_SECOND  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 248: /* time_zone_field: SQL_TOKEN_TIMEZONE_HOUR  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 249: /* time_zone_field: SQL_TOKEN_TIMEZONE_MINUTE  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 250: /* extract_exp: SQL_TOKEN_EXTRACT '(' extract_field SQL_TOKEN_FROM value_exp ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-5)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 268: /* set_fct_spec: '{' odbc_fct_spec '}'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append(newNode("{", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("}", SQLNodeType::Punctuation));
		}
    break;

  case 269: /* set_fct_spec: function_name '(' ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 270: /* set_fct_spec: function_name0 '(' ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 271: /* set_fct_spec: function_name1 '(' function_arg ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 272: /* set_fct_spec: function_name2 '(' function_arg_commalist2 ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 273: /* set_fct_spec: function_name3 '(' function_arg_commalist3 ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 274: /* set_fct_spec: string_function_4Argument '(' function_arg_commalist4 ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 275: /* set_fct_spec: function_name '(' function_args_commalist ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 276: /* set_fct_spec: function_name12 '(' function_args_commalist ')'  */
                {
			if ( (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode)->count() == 1 || (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode)->count() == 2 )
			{
				((*yyvalp).pParseNode) = SQL_NEW_RULE;
				((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
				((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
				((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
				((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
			}
			else
				YYERROR;
		}
    break;

  case 277: /* set_fct_spec: function_name23 '(' function_args_commalist ')'  */
                {
			if ( (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode)->count() == 2 || (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode)->count() == 3)
			{
				((*yyvalp).pParseNode) = SQL_NEW_RULE;
				((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
				((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
				((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
				((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
			}
			else
				YYERROR;
		}
    break;

  case 357: /* window_function: window_function_type SQL_TOKEN_OVER window_name_or_specification  */
        {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
	}
    break;

  case 358: /* window_function_type: rank_function_type '(' ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 359: /* window_function_type: SQL_TOKEN_ROW_NUMBER '(' ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 365: /* ntile_function: SQL_TOKEN_NTILE '(' number_of_tiles ')'  */
        {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
	}
    break;

  case 370: /* opt_lead_or_lag_function: %empty  */
                         {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 371: /* opt_lead_or_lag_function: ',' offset  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append(newNode(",", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 372: /* opt_lead_or_lag_function: ',' offset ',' default_expression  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append(newNode(",", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(",", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 373: /* opt_null_treatment: %empty  */
                                 {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 375: /* lead_or_lag_function: lead_or_lag '(' lead_or_lag_extent opt_lead_or_lag_function ')' opt_null_treatment  */
        {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-5)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
	}
    break;

  case 383: /* first_or_last_value_function: first_or_last_value '(' value_exp ')' opt_null_treatment  */
        {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
	}
    break;

  case 386: /* opt_from_first_or_last: %empty  */
                                 {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 388: /* nth_value_function: SQL_TOKEN_NTH_VALUE '(' value_exp ',' nth_row ')' opt_from_first_or_last opt_null_treatment  */
        {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-7)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-5)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(",", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
	}
    break;

  case 391: /* from_first_or_last: SQL_TOKEN_FROM SQL_TOKEN_FIRST  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 392: /* from_first_or_last: SQL_TOKEN_FROM SQL_TOKEN_LAST  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 397: /* opt_window_clause: %empty  */
                                 {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 399: /* window_clause: SQL_TOKEN_WINDOW window_definition_list  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
	}
    break;

  case 400: /* window_definition_list: window_definition_list ',' window_definition  */
                        {(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode);}
    break;

  case 401: /* window_definition_list: window_definition  */
                        {((*yyvalp).pParseNode) = SQL_NEW_COMMALISTRULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 402: /* window_definition: new_window_name SQL_TOKEN_AS window_specification  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
	}
    break;

  case 404: /* window_specification: '(' opt_existing_window_name opt_window_partition_clause opt_order_by_clause opt_window_frame_clause ')'  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
		((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
	}
    break;

  case 405: /* opt_existing_window_name: %empty  */
                                 {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 407: /* opt_window_partition_clause: %empty  */
                         {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 409: /* opt_window_frame_clause: %empty  */
                         {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 412: /* window_partition_clause: SQL_TOKEN_PARTITION SQL_TOKEN_BY window_partition_column_reference_list  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
	}
    break;

  case 413: /* window_partition_column_reference_list: window_partition_column_reference_list ',' window_partition_column_reference  */
                        {(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode);}
    break;

  case 414: /* window_partition_column_reference_list: window_partition_column_reference  */
                        {((*yyvalp).pParseNode) = SQL_NEW_COMMALISTRULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 415: /* window_partition_column_reference: column_ref opt_collate_clause  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
	}
    break;

  case 416: /* opt_window_frame_exclusion: %empty  */
                         {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 418: /* window_frame_clause: window_frame_units window_frame_extent opt_window_frame_exclusion  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
	}
    break;

  case 423: /* window_frame_start: SQL_TOKEN_UNBOUNDED SQL_TOKEN_PRECEDING  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 425: /* window_frame_start: SQL_TOKEN_CURRENT SQL_TOKEN_ROW  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 426: /* window_frame_preceding: unsigned_value_spec SQL_TOKEN_PRECEDING  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
	}
    break;

  case 427: /* window_frame_between: SQL_TOKEN_BETWEEN window_frame_bound_1 SQL_TOKEN_AND window_frame_bound_2  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
	}
    break;

  case 431: /* window_frame_bound: SQL_TOKEN_UNBOUNDED SQL_TOKEN_FOLLOWING  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
	}
    break;

  case 433: /* window_frame_following: unsigned_value_spec SQL_TOKEN_FOLLOWING  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
	}
    break;

  case 434: /* window_frame_exclusion: SQL_TOKEN_EXCLUDE SQL_TOKEN_CURRENT SQL_TOKEN_ROW  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 435: /* window_frame_exclusion: SQL_TOKEN_EXCLUDE SQL_TOKEN_GROUP  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 436: /* window_frame_exclusion: SQL_TOKEN_EXCLUDE SQL_TOKEN_TIES  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 437: /* window_frame_exclusion: SQL_TOKEN_EXCLUDE SQL_TOKEN_NO SQL_TOKEN_OTHERS  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 438: /* op_parameter: %empty  */
                {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 439: /* op_parameter: '?' SQL_EQUAL  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append(newNode("?", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 440: /* odbc_call_spec: op_parameter SQL_TOKEN_CALL table_node op_odbc_call_parameter  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 441: /* op_odbc_call_parameter: %empty  */
                {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 442: /* op_odbc_call_parameter: '(' odbc_parameter_commalist ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 443: /* odbc_parameter_commalist: odbc_parameter  */
                {((*yyvalp).pParseNode) = SQL_NEW_COMMALISTRULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 444: /* odbc_parameter_commalist: odbc_parameter_commalist ',' odbc_parameter  */
                {
			(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode);
		}
    break;

  case 445: /* odbc_parameter: %empty  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 448: /* odbc_fct_spec: odbc_fct_type SQL_TOKEN_STRING  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 449: /* odbc_fct_spec: SQL_TOKEN_FN set_fct_spec  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 453: /* general_set_fct: set_fct_type '(' opt_all_distinct function_arg ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 454: /* general_set_fct: SQL_TOKEN_COUNT '(' '*' ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append(newNode("*", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 455: /* general_set_fct: SQL_TOKEN_COUNT '(' opt_all_distinct function_arg ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 474: /* hypothetical_set_function: rank_function_type '(' hypothetical_set_function_value_expression_list ')' within_group_specification  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 475: /* hypothetical_set_function: rank_function_type '(' hypothetical_set_function_value_expression_list SQL_TOKEN_BY value_exp_commalist ')' within_group_specification  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-6)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
	}
    break;

  case 476: /* within_group_specification: %empty  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
	}
    break;

  case 477: /* within_group_specification: SQL_TOKEN_WITHIN SQL_TOKEN_GROUP '(' opt_order_by_clause ')'  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
	}
    break;

  case 479: /* inverse_distribution_function: inverse_distribution_function_type '(' inverse_distribution_function_argument ')' within_group_specification  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
	}
    break;

  case 483: /* array_aggregate_function: SQL_TOKEN_ARRAY_AGG '(' value_exp opt_order_by_clause ')'  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
	}
    break;

  case 488: /* outer_join_type: SQL_TOKEN_LEFT  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 489: /* outer_join_type: SQL_TOKEN_RIGHT  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 490: /* outer_join_type: SQL_TOKEN_FULL  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 491: /* join_condition: SQL_TOKEN_ON search_condition  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 494: /* join_type: %empty  */
                                {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 495: /* join_type: SQL_TOKEN_INNER  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 497: /* join_type: outer_join_type SQL_TOKEN_OUTER  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 498: /* cross_union: table_ref SQL_TOKEN_CROSS SQL_TOKEN_JOIN table_ref  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 499: /* qualified_join: table_ref SQL_TOKEN_NATURAL join_type SQL_TOKEN_JOIN table_ref  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 500: /* qualified_join: table_ref join_type SQL_TOKEN_JOIN table_ref join_spec  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 503: /* named_columns_join: SQL_TOKEN_USING '(' column_commalist ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 507: /* non_join_query_primary: '(' non_join_query_exp ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 509: /* non_join_query_term: query_term SQL_TOKEN_INTERSECT all query_primary  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 512: /* non_join_query_exp: query_exp SQL_TOKEN_UNION all query_term  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 513: /* non_join_query_exp: query_exp SQL_TOKEN_EXCEPT all query_term  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 514: /* all: %empty  */
                   {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 521: /* cast_spec: SQL_TOKEN_CAST '(' cast_operand SQL_TOKEN_AS cast_target ')'  */
          {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-5)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 528: /* value_exp_primary: '(' value_exp ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 533: /* factor: '-' num_primary  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append(newNode("-", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 534: /* factor: '+' num_primary  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append(newNode("+", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 536: /* term: term '*' factor  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("*", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 537: /* term: term '/' factor  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("/", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 539: /* num_value_exp: num_value_exp '+' term  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("+", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 540: /* num_value_exp: num_value_exp '-' term  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("-", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 541: /* datetime_primary: datetime_value_fct  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 542: /* datetime_value_fct: SQL_TOKEN_CURRENT_DATE  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 543: /* datetime_value_fct: SQL_TOKEN_CURRENT_TIME  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 544: /* datetime_value_fct: SQL_TOKEN_CURRENT_TIMESTAMP  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 545: /* time_zone: SQL_TOKEN_AT time_zone_specifier  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 546: /* time_zone_specifier: SQL_TOKEN_LOCAL  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 547: /* datetime_factor: datetime_primary  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 548: /* datetime_factor: datetime_primary time_zone  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 549: /* datetime_term: datetime_factor  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 550: /* datetime_value_exp: datetime_term  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 568: /* start_field: non_second_datetime_field opt_paren_precision  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 570: /* end_field: SQL_TOKEN_SECOND opt_paren_precision  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 571: /* single_datetime_field: non_second_datetime_field opt_paren_precision  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 572: /* single_datetime_field: SQL_TOKEN_SECOND opt_paren_precision_scale  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 573: /* interval_qualifier: start_field SQL_TOKEN_TO end_field  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 575: /* function_arg_commalist2: function_arg ',' function_arg  */
                        {((*yyvalp).pParseNode) = SQL_NEW_COMMALISTRULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 576: /* function_arg_commalist3: function_arg ',' function_arg ',' function_arg  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_COMMALISTRULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 577: /* function_arg_commalist4: function_arg ',' function_arg ',' function_arg ',' function_arg  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_COMMALISTRULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-6)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 578: /* value_exp_commalist: value_exp  */
                        {((*yyvalp).pParseNode) = SQL_NEW_COMMALISTRULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 579: /* value_exp_commalist: value_exp_commalist ',' value_exp  */
                        {(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode);}
    break;

  case 580: /* value_exp_commalist: value_exp_commalist ';' value_exp  */
                {
			if (xxx_pGLOBAL_SQLPARSER->inPredicateCheck())
			{
				(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
				((*yyvalp).pParseNode) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode);
			}
			else
				YYERROR;
		}
    break;

  case 582: /* function_arg: value_exp comparison value_exp  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 583: /* function_arg: value_exp SQL_TOKEN_USING value_exp comparison value_exp  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 584: /* function_arg: value_exp SQL_TOKEN_BY value_exp_commalist  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 585: /* function_args_commalist: function_arg  */
                        {((*yyvalp).pParseNode) = SQL_NEW_COMMALISTRULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 586: /* function_args_commalist: function_args_commalist ',' function_arg  */
                        {(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode);}
    break;

  case 587: /* function_args_commalist: function_args_commalist ';' function_arg  */
                {
			if (xxx_pGLOBAL_SQLPARSER->inPredicateCheck())
			{
				(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
				((*yyvalp).pParseNode) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode);
			}
			else
				YYERROR;
		}
    break;

  case 588: /* function_args_commalist: datetime_unit ',' function_arg ',' function_arg  */
        {
            ((*yyvalp).pParseNode) = SQL_NEW_COMMALISTRULE;
            ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
            ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
            ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
        }
    break;

  case 591: /* value_exp: datetime_value_exp  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 595: /* concatenation: char_value_exp '+' char_factor  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("+", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 596: /* concatenation: value_exp SQL_CONCAT value_exp  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 599: /* collate_clause: SQL_TOKEN_COLLATE table_node  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 601: /* char_factor: char_primary collate_clause  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 604: /* bit_value_fct: bit_substring_fct  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 605: /* bit_substring_fct: SQL_TOKEN_SUBSTRING '(' bit_value_exp SQL_TOKEN_FROM string_value_exp for_length ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-6)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 606: /* bit_value_exp: bit_factor  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 607: /* bit_factor: bit_primary  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 608: /* bit_primary: %empty  */
        {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 611: /* char_value_fct: form_conversion  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 612: /* char_value_fct: char_translation  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 613: /* char_value_fct: trim_fct  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 614: /* for_length: %empty  */
                {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 615: /* for_length: SQL_TOKEN_FOR value_exp  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 616: /* char_substring_fct: SQL_TOKEN_SUBSTRING '(' value_exp SQL_TOKEN_FROM value_exp for_length ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-6)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 617: /* char_substring_fct: SQL_TOKEN_SUBSTRING '(' value_exp_commalist ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 620: /* fold: upper_lower '(' value_exp ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 621: /* form_conversion: SQL_TOKEN_CONVERT '(' string_value_exp SQL_TOKEN_USING table_node ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-5)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 622: /* form_conversion: SQL_TOKEN_CONVERT '(' cast_operand ',' cast_target ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-5)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(",", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 623: /* char_translation: SQL_TOKEN_TRANSLATE '(' string_value_exp SQL_TOKEN_USING table_node ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-5)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 624: /* trim_fct: SQL_TOKEN_TRIM '(' trim_operands ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 625: /* trim_operands: trim_spec value_exp SQL_TOKEN_FROM value_exp  */
        {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 626: /* trim_operands: trim_spec SQL_TOKEN_FROM value_exp  */
        {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 627: /* trim_operands: value_exp SQL_TOKEN_FROM value_exp  */
        {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 628: /* trim_operands: SQL_TOKEN_FROM value_exp  */
            {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 633: /* derived_column: value_exp as_clause  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 637: /* catalog_name: SQL_TOKEN_NAME '.' schema_name  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(".", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 638: /* catalog_name: SQL_TOKEN_NAME ':' schema_name  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(":", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 639: /* schema_name: SQL_TOKEN_NAME '.' table_name  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(".", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 640: /* table_name: SQL_TOKEN_NAME  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 641: /* column_ref: column  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 642: /* column_ref: SQL_TOKEN_NAME '.' column_val  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(".", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
			}
    break;

  case 643: /* column_ref: SQL_TOKEN_NAME '.' SQL_TOKEN_NAME '.' column_val  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(".", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(".", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 644: /* column_ref: SQL_TOKEN_NAME '.' SQL_TOKEN_NAME '.' SQL_TOKEN_NAME '.' column_val  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-6)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(".", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(".", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(".", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
			}
    break;

  case 645: /* column_ref: SQL_TOKEN_NAME ':' SQL_TOKEN_NAME '.' SQL_TOKEN_NAME '.' column_val  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-6)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(":", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(".", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(".", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
			}
    break;

  case 646: /* column_val: column  */
                {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 647: /* column_val: '*'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append(newNode("*", SQLNodeType::Punctuation));
		}
    break;

  case 649: /* opt_char_set_spec: %empty  */
        {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 650: /* opt_char_set_spec: SQL_TOKEN_CHARACTER SQL_TOKEN_SET SQL_TOKEN_NAME  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 651: /* opt_collate_clause: %empty  */
        {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 653: /* predefined_type: character_string_type opt_char_set_spec opt_collate_clause  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 654: /* predefined_type: national_character_string_type opt_collate_clause  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 660: /* character_string_type: SQL_TOKEN_CHARACTER opt_paren_precision  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 661: /* character_string_type: SQL_TOKEN_CHAR opt_paren_precision  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 662: /* character_string_type: SQL_TOKEN_CHARACTER SQL_TOKEN_VARYING paren_char_length  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 663: /* character_string_type: SQL_TOKEN_CHAR SQL_TOKEN_VARYING paren_char_length  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 664: /* character_string_type: SQL_TOKEN_VARCHAR paren_char_length  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 666: /* opt_paren_precision: %empty  */
                {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 668: /* paren_char_length: '(' SQL_TOKEN_INTNUM ')'  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
		((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
	}
    break;

  case 669: /* opt_paren_char_large_length: %empty  */
                {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 671: /* paren_character_large_object_length: '(' large_object_length ')'  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
		((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
	}
    break;

  case 672: /* large_object_length: SQL_TOKEN_INTNUM opt_multiplier  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
	}
    break;

  case 673: /* opt_multiplier: %empty  */
        {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 674: /* opt_multiplier: 'K'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append(newNode("K", SQLNodeType::Punctuation));
		}
    break;

  case 675: /* opt_multiplier: 'M'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append(newNode("M", SQLNodeType::Punctuation));
		}
    break;

  case 676: /* opt_multiplier: 'G'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append(newNode("G", SQLNodeType::Punctuation));
		}
    break;

  case 677: /* opt_multiplier: 'T'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append(newNode("T", SQLNodeType::Punctuation));
		}
    break;

  case 678: /* opt_multiplier: 'P'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append(newNode("P", SQLNodeType::Punctuation));
		}
    break;

  case 679: /* character_large_object_type: SQL_TOKEN_CHARACTER SQL_TOKEN_LARGE SQL_TOKEN_OBJECT opt_paren_char_large_length  */
        {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 680: /* character_large_object_type: SQL_TOKEN_CHAR SQL_TOKEN_LARGE SQL_TOKEN_OBJECT opt_paren_char_large_length  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 681: /* character_large_object_type: SQL_TOKEN_CLOB opt_paren_char_large_length  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 682: /* national_character_string_type: SQL_TOKEN_NATIONAL SQL_TOKEN_CHARACTER opt_paren_precision  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 683: /* national_character_string_type: SQL_TOKEN_NATIONAL SQL_TOKEN_CHAR opt_paren_precision  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 684: /* national_character_string_type: SQL_TOKEN_NCHAR opt_paren_precision  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 685: /* national_character_string_type: SQL_TOKEN_NATIONAL SQL_TOKEN_CHARACTER SQL_TOKEN_VARYING paren_char_length  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 686: /* national_character_string_type: SQL_TOKEN_NATIONAL SQL_TOKEN_CHAR SQL_TOKEN_VARYING paren_char_length  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 687: /* national_character_string_type: SQL_TOKEN_NCHAR SQL_TOKEN_VARYING paren_char_length  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 689: /* national_character_large_object_type: SQL_TOKEN_NATIONAL SQL_TOKEN_CHARACTER SQL_TOKEN_LARGE SQL_TOKEN_OBJECT opt_paren_char_large_length  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 690: /* national_character_large_object_type: SQL_TOKEN_NCHAR SQL_TOKEN_LARGE SQL_TOKEN_OBJECT opt_paren_char_large_length  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 691: /* national_character_large_object_type: SQL_TOKEN_NCLOB opt_paren_char_large_length  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 692: /* binary_string_type: SQL_TOKEN_BINARY opt_paren_precision  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 693: /* binary_string_type: SQL_TOKEN_BINARY SQL_TOKEN_VARYING paren_char_length  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 694: /* binary_string_type: SQL_TOKEN_VARBINARY paren_char_length  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 696: /* binary_large_object_string_type: SQL_TOKEN_BINARY SQL_TOKEN_LARGE SQL_TOKEN_OBJECT opt_paren_char_large_length  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 697: /* binary_large_object_string_type: SQL_TOKEN_BLOB opt_paren_char_large_length  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 700: /* opt_paren_precision_scale: %empty  */
        {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 701: /* opt_paren_precision_scale: '(' SQL_TOKEN_INTNUM ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 702: /* opt_paren_precision_scale: '(' SQL_TOKEN_INTNUM ',' SQL_TOKEN_INTNUM ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(",", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 703: /* exact_numeric_type: SQL_TOKEN_NUMERIC opt_paren_precision_scale  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 704: /* exact_numeric_type: SQL_TOKEN_DECIMAL opt_paren_precision_scale  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 705: /* exact_numeric_type: SQL_TOKEN_DEC opt_paren_precision_scale  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 710: /* approximate_numeric_type: SQL_TOKEN_FLOAT '(' SQL_TOKEN_INTNUM ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 714: /* approximate_numeric_type: SQL_TOKEN_DOUBLE SQL_TOKEN_PRECISION  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 717: /* datetime_type: SQL_TOKEN_TIME opt_paren_precision opt_with_or_without_time_zone  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 718: /* datetime_type: SQL_TOKEN_TIMESTAMP opt_paren_precision opt_with_or_without_time_zone  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 719: /* opt_with_or_without_time_zone: %empty  */
                {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 720: /* opt_with_or_without_time_zone: SQL_TOKEN_WITH SQL_TOKEN_TIME SQL_TOKEN_ZONE  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 721: /* opt_with_or_without_time_zone: SQL_TOKEN_WITHOUT SQL_TOKEN_TIME SQL_TOKEN_ZONE  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 722: /* interval_type: SQL_TOKEN_INTERVAL interval_qualifier  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
	}
    break;

  case 724: /* column: SQL_TOKEN_POSITION  */
                {
			sal_uInt32 nNod = ((*yyvalp).pParseNode)->getRuleID();
			delete ((*yyvalp).pParseNode);
			((*yyvalp).pParseNode) = newNode(OSQLParser::TokenIDToStr(nNod), SQLNodeType::Name);
		}
    break;

  case 725: /* column: SQL_TOKEN_CHAR_LENGTH  */
                {
			sal_uInt32 nNod = ((*yyvalp).pParseNode)->getRuleID();
			delete ((*yyvalp).pParseNode);
			((*yyvalp).pParseNode) = newNode(OSQLParser::TokenIDToStr(nNod), SQLNodeType::Name);
		}
    break;

  case 726: /* column: SQL_TOKEN_EXTRACT  */
                {
			sal_uInt32 nNod = ((*yyvalp).pParseNode)->getRuleID();
			delete ((*yyvalp).pParseNode);
			((*yyvalp).pParseNode) = newNode(OSQLParser::TokenIDToStr(nNod), SQLNodeType::Name);
		}
    break;

  case 729: /* case_abbreviation: SQL_TOKEN_NULLIF '(' value_exp_commalist ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 730: /* case_abbreviation: SQL_TOKEN_COALESCE '(' value_exp ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 731: /* case_abbreviation: SQL_TOKEN_COALESCE '(' value_exp_commalist ')'  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("(", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
		}
    break;

  case 734: /* simple_case: SQL_TOKEN_CASE case_operand simple_when_clause_list else_clause SQL_TOKEN_END  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 735: /* searched_case: SQL_TOKEN_CASE searched_when_clause_list else_clause SQL_TOKEN_END  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 736: /* simple_when_clause_list: simple_when_clause  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_LISTRULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 737: /* simple_when_clause_list: searched_when_clause_list simple_when_clause  */
                {
			(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode);
		}
    break;

  case 738: /* simple_when_clause: SQL_TOKEN_WHEN when_operand_list SQL_TOKEN_THEN result  */
        {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 739: /* when_operand_list: when_operand  */
                {((*yyvalp).pParseNode) = SQL_NEW_COMMALISTRULE;
		((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 740: /* when_operand_list: when_operand_list ',' when_operand  */
                {(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		((*yyvalp).pParseNode) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode);}
    break;

  case 747: /* searched_when_clause_list: searched_when_clause  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_LISTRULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 748: /* searched_when_clause_list: searched_when_clause_list searched_when_clause  */
                {
			(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode);
		}
    break;

  case 749: /* searched_when_clause: SQL_TOKEN_WHEN search_condition SQL_TOKEN_THEN result  */
        {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 750: /* else_clause: %empty  */
                {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 751: /* else_clause: SQL_TOKEN_ELSE result  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 755: /* cursor: SQL_TOKEN_NAME  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 756: /* parameter: ':' SQL_TOKEN_NAME  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append(newNode(":", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));}
    break;

  case 757: /* parameter: '?'  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE; // test
			((*yyvalp).pParseNode)->append(newNode("?", SQLNodeType::Punctuation));}
    break;

  case 758: /* parameter: '[' SQL_TOKEN_NAME ']'  */
                        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
			((*yyvalp).pParseNode)->append(newNode("[", SQLNodeType::Punctuation));
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode)->append(newNode("]", SQLNodeType::Punctuation));}
    break;

  case 759: /* range_variable: %empty  */
        {((*yyvalp).pParseNode) = SQL_NEW_RULE;}
    break;

  case 760: /* range_variable: opt_as SQL_TOKEN_NAME  */
        {((*yyvalp).pParseNode) = SQL_NEW_RULE;
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
        }
    break;

  case 762: /* sql: search_condition  */
                {
			if (xxx_pGLOBAL_SQLPARSER->inPredicateCheck()) // sql: rule 1
			{
				((*yyvalp).pParseNode) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode);
				if ( SQL_ISRULE(((*yyvalp).pParseNode),search_condition) )
				{
					((*yyvalp).pParseNode)->insert(0,newNode("(", SQLNodeType::Punctuation));
					((*yyvalp).pParseNode)->append(newNode(")", SQLNodeType::Punctuation));
				}
			}
			else
				YYERROR;
		}
    break;

  case 764: /* trigger_definition: SQL_TOKEN_CREATE SQL_TOKEN_TRIGGER trigger_name trigger_action_time trigger_event SQL_TOKEN_ON table_name op_referencing triggered_action  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-8)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-7)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-6)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-5)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
    }
    break;

  case 765: /* op_referencing: %empty  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
	}
    break;

  case 766: /* op_referencing: SQL_TOKEN_REFERENCING transition_table_or_variable_list  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
    }
    break;

  case 769: /* trigger_action_time: SQL_TOKEN_INSTEAD SQL_TOKEN_OF  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
    }
    break;

  case 772: /* trigger_event: SQL_TOKEN_UPDATE op_trigger_columnlist  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
    }
    break;

  case 773: /* op_trigger_columnlist: %empty  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
	}
    break;

  case 774: /* op_trigger_columnlist: SQL_TOKEN_OF trigger_column_list  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
    }
    break;

  case 776: /* triggered_action: op_triggered_action_for triggered_when_clause triggered_SQL_statement  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
    }
    break;

  case 777: /* op_triggered_action_for: %empty  */
                {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
		}
    break;

  case 778: /* op_triggered_action_for: SQL_TOKEN_FOR SQL_TOKEN_EACH trigger_for  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
    }
    break;

  case 781: /* triggered_when_clause: %empty  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
	}
    break;

  case 782: /* triggered_when_clause: SQL_TOKEN_WHEN parenthesized_boolean_value_expression  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
    }
    break;

  case 784: /* triggered_SQL_statement: SQL_TOKEN_BEGIN SQL_TOKEN_ATOMIC SQL_procedure_statement_list ';' SQL_TOKEN_END  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-4)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append(newNode(";", SQLNodeType::Punctuation));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
    }
    break;

  case 785: /* SQL_procedure_statement_list: SQL_procedure_statement  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_LISTRULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 786: /* SQL_procedure_statement_list: SQL_procedure_statement_list ';' SQL_procedure_statement  */
                {
			(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode);
		}
    break;

  case 788: /* transition_table_or_variable_list: transition_table_or_variable  */
                {
			((*yyvalp).pParseNode) = SQL_NEW_LISTRULE;
			((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
		}
    break;

  case 789: /* transition_table_or_variable_list: transition_table_or_variable_list transition_table_or_variable  */
                {
			(YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
			((*yyvalp).pParseNode) = (YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode);
		}
    break;

  case 790: /* transition_table_or_variable: SQL_TOKEN_OLD opt_row opt_as old_transition_variable_name  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
    }
    break;

  case 791: /* transition_table_or_variable: SQL_TOKEN_NEW opt_row opt_as new_transition_variable_name  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
    }
    break;

  case 792: /* transition_table_or_variable: SQL_TOKEN_OLD SQL_TOKEN_TABLE opt_as old_transition_table_name  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
    }
    break;

  case 793: /* transition_table_or_variable: SQL_TOKEN_NEW SQL_TOKEN_TABLE opt_as new_transition_table_name  */
        {
		((*yyvalp).pParseNode) = SQL_NEW_RULE;
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-3)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-2)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (-1)].yystate.yysemantics.yyval.pParseNode));
        ((*yyvalp).pParseNode)->append((YY_CAST (yyGLRStackItem const *, yyvsp)[YYFILL (0)].yystate.yysemantics.yyval.pParseNode));
    }
    break;



      default: break;
    }
  YY_SYMBOL_PRINT ("-> $$ =", yylhsNonterm (yyrule), yyvalp, yylocp);

  return yyok;
# undef yyerrok
# undef YYABORT
# undef YYACCEPT
# undef YYNOMEM
# undef YYERROR
# undef YYBACKUP
# undef yyclearin
# undef YYRECOVERING
}


static void
yyuserMerge (int yyn, YYSTYPE* yy0, YYSTYPE* yy1)
{
  YY_USE (yy0);
  YY_USE (yy1);

  switch (yyn)
    {

      default: break;
    }
}

                              /* Bison grammar-table manipulation.  */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}

/** Number of symbols composing the right hand side of rule #RULE.  */
static inline int
yyrhsLength (yyRuleNum yyrule)
{
  return yyr2[yyrule];
}

static void
yydestroyGLRState (char const *yymsg, yyGLRState *yys)
{
  if (yys->yyresolved)
    yydestruct (yymsg, yy_accessing_symbol (yys->yylrState),
                &yys->yysemantics.yyval);
  else
    {
#if YYDEBUG
      if (yydebug)
        {
          if (yys->yysemantics.yyfirstVal)
            YY_FPRINTF ((stderr, "%s unresolved", yymsg));
          else
            YY_FPRINTF ((stderr, "%s incomplete", yymsg));
          YY_SYMBOL_PRINT ("", yy_accessing_symbol (yys->yylrState), YY_NULLPTR, &yys->yyloc);
        }
#endif

      if (yys->yysemantics.yyfirstVal)
        {
          yySemanticOption *yyoption = yys->yysemantics.yyfirstVal;
          yyGLRState *yyrh;
          int yyn;
          for (yyrh = yyoption->yystate, yyn = yyrhsLength (yyoption->yyrule);
               yyn > 0;
               yyrh = yyrh->yypred, yyn -= 1)
            yydestroyGLRState (yymsg, yyrh);
        }
    }
}

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

/** True iff LR state YYSTATE has only a default reduction (regardless
 *  of token).  */
static inline yybool
yyisDefaultedState (yy_state_t yystate)
{
  return yypact_value_is_default (yypact[yystate]);
}

/** The default reduction for YYSTATE, assuming it has one.  */
static inline yyRuleNum
yydefaultAction (yy_state_t yystate)
{
  return yydefact[yystate];
}

#define yytable_value_is_error(Yyn) \
  0

/** The action to take in YYSTATE on seeing YYTOKEN.
 *  Result R means
 *    R < 0:  Reduce on rule -R.
 *    R = 0:  Error.
 *    R > 0:  Shift to state R.
 *  Set *YYCONFLICTS to a pointer into yyconfl to a 0-terminated list
 *  of conflicting reductions.
 */
static inline int
yygetLRActions (yy_state_t yystate, yysymbol_kind_t yytoken, const short** yyconflicts)
{
  int yyindex = yypact[yystate] + yytoken;
  if (yytoken == YYSYMBOL_YYerror)
    {
      // This is the error token.
      *yyconflicts = yyconfl;
      return 0;
    }
  else if (yyisDefaultedState (yystate)
           || yyindex < 0 || YYLAST < yyindex || yycheck[yyindex] != yytoken)
    {
      *yyconflicts = yyconfl;
      return -yydefact[yystate];
    }
  else if (! yytable_value_is_error (yytable[yyindex]))
    {
      *yyconflicts = yyconfl + yyconflp[yyindex];
      return yytable[yyindex];
    }
  else
    {
      *yyconflicts = yyconfl + yyconflp[yyindex];
      return 0;
    }
}

/** Compute post-reduction state.
 * \param yystate   the current state
 * \param yysym     the nonterminal to push on the stack
 */
static inline yy_state_t
yyLRgotoState (yy_state_t yystate, yysymbol_kind_t yysym)
{
  int yyr = yypgoto[yysym - YYNTOKENS] + yystate;
  if (0 <= yyr && yyr <= YYLAST && yycheck[yyr] == yystate)
    return yytable[yyr];
  else
    return yydefgoto[yysym - YYNTOKENS];
}

static inline yybool
yyisShiftAction (int yyaction)
{
  return 0 < yyaction;
}

static inline yybool
yyisErrorAction (int yyaction)
{
  return yyaction == 0;
}

                                /* GLRStates */

/** Return a fresh GLRStackItem in YYSTACKP.  The item is an LR state
 *  if YYISSTATE, and otherwise a semantic option.  Callers should call
 *  YY_RESERVE_GLRSTACK afterwards to make sure there is sufficient
 *  headroom.  */

static inline yyGLRStackItem*
yynewGLRStackItem (yyGLRStack* yystackp, yybool yyisState)
{
  yyGLRStackItem* yynewItem = yystackp->yynextFree;
  yystackp->yyspaceLeft -= 1;
  yystackp->yynextFree += 1;
  yynewItem->yystate.yyisState = yyisState;
  return yynewItem;
}

/** Add a new semantic action that will execute the action for rule
 *  YYRULE on the semantic values in YYRHS to the list of
 *  alternative actions for YYSTATE.  Assumes that YYRHS comes from
 *  stack #YYK of *YYSTACKP. */
static void
yyaddDeferredAction (yyGLRStack* yystackp, YYPTRDIFF_T yyk, yyGLRState* yystate,
                     yyGLRState* yyrhs, yyRuleNum yyrule)
{
  yySemanticOption* yynewOption =
    &yynewGLRStackItem (yystackp, yyfalse)->yyoption;
  YY_ASSERT (!yynewOption->yyisState);
  yynewOption->yystate = yyrhs;
  yynewOption->yyrule = yyrule;
  if (yystackp->yytops.yylookaheadNeeds[yyk])
    {
      yynewOption->yyrawchar = yychar;
      yynewOption->yyval = yylval;
    }
  else
    yynewOption->yyrawchar = YYEMPTY;
  yynewOption->yynext = yystate->yysemantics.yyfirstVal;
  yystate->yysemantics.yyfirstVal = yynewOption;

  YY_RESERVE_GLRSTACK (yystackp);
}

                                /* GLRStacks */

/** Initialize YYSET to a singleton set containing an empty stack.  */
static yybool
yyinitStateSet (yyGLRStateSet* yyset)
{
  yyset->yysize = 1;
  yyset->yycapacity = 16;
  yyset->yystates
    = YY_CAST (yyGLRState**,
               YYMALLOC (YY_CAST (YYSIZE_T, yyset->yycapacity)
                         * sizeof yyset->yystates[0]));
  if (! yyset->yystates)
    return yyfalse;
  yyset->yystates[0] = YY_NULLPTR;
  yyset->yylookaheadNeeds
    = YY_CAST (yybool*,
               YYMALLOC (YY_CAST (YYSIZE_T, yyset->yycapacity)
                         * sizeof yyset->yylookaheadNeeds[0]));
  if (! yyset->yylookaheadNeeds)
    {
      YYFREE (yyset->yystates);
      return yyfalse;
    }
  memset (yyset->yylookaheadNeeds,
          0,
          YY_CAST (YYSIZE_T, yyset->yycapacity) * sizeof yyset->yylookaheadNeeds[0]);
  return yytrue;
}

static void yyfreeStateSet (yyGLRStateSet* yyset)
{
  YYFREE (yyset->yystates);
  YYFREE (yyset->yylookaheadNeeds);
}

/** Initialize *YYSTACKP to a single empty stack, with total maximum
 *  capacity for all stacks of YYSIZE.  */
static yybool
yyinitGLRStack (yyGLRStack* yystackp, YYPTRDIFF_T yysize)
{
  yystackp->yyerrState = 0;
  yynerrs = 0;
  yystackp->yyspaceLeft = yysize;
  yystackp->yyitems
    = YY_CAST (yyGLRStackItem*,
               YYMALLOC (YY_CAST (YYSIZE_T, yysize)
                         * sizeof yystackp->yynextFree[0]));
  if (!yystackp->yyitems)
    return yyfalse;
  yystackp->yynextFree = yystackp->yyitems;
  yystackp->yysplitPoint = YY_NULLPTR;
  yystackp->yylastDeleted = YY_NULLPTR;
  return yyinitStateSet (&yystackp->yytops);
}


#if YYSTACKEXPANDABLE
# define YYRELOC(YYFROMITEMS, YYTOITEMS, YYX, YYTYPE)                   \
  &((YYTOITEMS)                                                         \
    - ((YYFROMITEMS) - YY_REINTERPRET_CAST (yyGLRStackItem*, (YYX))))->YYTYPE

/** If *YYSTACKP is expandable, extend it.  WARNING: Pointers into the
    stack from outside should be considered invalid after this call.
    We always expand when there are 1 or fewer items left AFTER an
    allocation, so that we can avoid having external pointers exist
    across an allocation.  */
static void
yyexpandGLRStack (yyGLRStack* yystackp)
{
  yyGLRStackItem* yynewItems;
  yyGLRStackItem* yyp0, *yyp1;
  YYPTRDIFF_T yynewSize;
  YYPTRDIFF_T yyn;
  YYPTRDIFF_T yysize = yystackp->yynextFree - yystackp->yyitems;
  if (YYMAXDEPTH - YYHEADROOM < yysize)
    yyMemoryExhausted (yystackp);
  yynewSize = 2*yysize;
  if (YYMAXDEPTH < yynewSize)
    yynewSize = YYMAXDEPTH;
  yynewItems
    = YY_CAST (yyGLRStackItem*,
               YYMALLOC (YY_CAST (YYSIZE_T, yynewSize)
                         * sizeof yynewItems[0]));
  if (! yynewItems)
    yyMemoryExhausted (yystackp);
  for (yyp0 = yystackp->yyitems, yyp1 = yynewItems, yyn = yysize;
       0 < yyn;
       yyn -= 1, yyp0 += 1, yyp1 += 1)
    {
      *yyp1 = *yyp0;
      if (*YY_REINTERPRET_CAST (yybool *, yyp0))
        {
          yyGLRState* yys0 = &yyp0->yystate;
          yyGLRState* yys1 = &yyp1->yystate;
          if (yys0->yypred != YY_NULLPTR)
            yys1->yypred =
              YYRELOC (yyp0, yyp1, yys0->yypred, yystate);
          if (! yys0->yyresolved && yys0->yysemantics.yyfirstVal != YY_NULLPTR)
            yys1->yysemantics.yyfirstVal =
              YYRELOC (yyp0, yyp1, yys0->yysemantics.yyfirstVal, yyoption);
        }
      else
        {
          yySemanticOption* yyv0 = &yyp0->yyoption;
          yySemanticOption* yyv1 = &yyp1->yyoption;
          if (yyv0->yystate != YY_NULLPTR)
            yyv1->yystate = YYRELOC (yyp0, yyp1, yyv0->yystate, yystate);
          if (yyv0->yynext != YY_NULLPTR)
            yyv1->yynext = YYRELOC (yyp0, yyp1, yyv0->yynext, yyoption);
        }
    }
  if (yystackp->yysplitPoint != YY_NULLPTR)
    yystackp->yysplitPoint = YYRELOC (yystackp->yyitems, yynewItems,
                                      yystackp->yysplitPoint, yystate);

  for (yyn = 0; yyn < yystackp->yytops.yysize; yyn += 1)
    if (yystackp->yytops.yystates[yyn] != YY_NULLPTR)
      yystackp->yytops.yystates[yyn] =
        YYRELOC (yystackp->yyitems, yynewItems,
                 yystackp->yytops.yystates[yyn], yystate);
  YYFREE (yystackp->yyitems);
  yystackp->yyitems = yynewItems;
  yystackp->yynextFree = yynewItems + yysize;
  yystackp->yyspaceLeft = yynewSize - yysize;
}
#endif

static void
yyfreeGLRStack (yyGLRStack* yystackp)
{
  YYFREE (yystackp->yyitems);
  yyfreeStateSet (&yystackp->yytops);
}

/** Assuming that YYS is a GLRState somewhere on *YYSTACKP, update the
 *  splitpoint of *YYSTACKP, if needed, so that it is at least as deep as
 *  YYS.  */
static inline void
yyupdateSplit (yyGLRStack* yystackp, yyGLRState* yys)
{
  if (yystackp->yysplitPoint != YY_NULLPTR && yystackp->yysplitPoint > yys)
    yystackp->yysplitPoint = yys;
}

/** Invalidate stack #YYK in *YYSTACKP.  */
static inline void
yymarkStackDeleted (yyGLRStack* yystackp, YYPTRDIFF_T yyk)
{
  if (yystackp->yytops.yystates[yyk] != YY_NULLPTR)
    yystackp->yylastDeleted = yystackp->yytops.yystates[yyk];
  yystackp->yytops.yystates[yyk] = YY_NULLPTR;
}

/** Undelete the last stack in *YYSTACKP that was marked as deleted.  Can
    only be done once after a deletion, and only when all other stacks have
    been deleted.  */
static void
yyundeleteLastStack (yyGLRStack* yystackp)
{
  if (yystackp->yylastDeleted == YY_NULLPTR || yystackp->yytops.yysize != 0)
    return;
  yystackp->yytops.yystates[0] = yystackp->yylastDeleted;
  yystackp->yytops.yysize = 1;
  YY_DPRINTF ((stderr, "Restoring last deleted stack as stack #0.\n"));
  yystackp->yylastDeleted = YY_NULLPTR;
}

static inline void
yyremoveDeletes (yyGLRStack* yystackp)
{
  YYPTRDIFF_T yyi, yyj;
  yyi = yyj = 0;
  while (yyj < yystackp->yytops.yysize)
    {
      if (yystackp->yytops.yystates[yyi] == YY_NULLPTR)
        {
          if (yyi == yyj)
            YY_DPRINTF ((stderr, "Removing dead stacks.\n"));
          yystackp->yytops.yysize -= 1;
        }
      else
        {
          yystackp->yytops.yystates[yyj] = yystackp->yytops.yystates[yyi];
          /* In the current implementation, it's unnecessary to copy
             yystackp->yytops.yylookaheadNeeds[yyi] since, after
             yyremoveDeletes returns, the parser immediately either enters
             deterministic operation or shifts a token.  However, it doesn't
             hurt, and the code might evolve to need it.  */
          yystackp->yytops.yylookaheadNeeds[yyj] =
            yystackp->yytops.yylookaheadNeeds[yyi];
          if (yyj != yyi)
            YY_DPRINTF ((stderr, "Rename stack %ld -> %ld.\n",
                        YY_CAST (long, yyi), YY_CAST (long, yyj)));
          yyj += 1;
        }
      yyi += 1;
    }
}

/** Shift to a new state on stack #YYK of *YYSTACKP, corresponding to LR
 * state YYLRSTATE, at input position YYPOSN, with (resolved) semantic
 * value *YYVALP and source location *YYLOCP.  */
static inline void
yyglrShift (yyGLRStack* yystackp, YYPTRDIFF_T yyk, yy_state_t yylrState,
            YYPTRDIFF_T yyposn,
            YYSTYPE* yyvalp)
{
  yyGLRState* yynewState = &yynewGLRStackItem (yystackp, yytrue)->yystate;

  yynewState->yylrState = yylrState;
  yynewState->yyposn = yyposn;
  yynewState->yyresolved = yytrue;
  yynewState->yypred = yystackp->yytops.yystates[yyk];
  yynewState->yysemantics.yyval = *yyvalp;
  yystackp->yytops.yystates[yyk] = yynewState;

  YY_RESERVE_GLRSTACK (yystackp);
}

/** Shift stack #YYK of *YYSTACKP, to a new state corresponding to LR
 *  state YYLRSTATE, at input position YYPOSN, with the (unresolved)
 *  semantic value of YYRHS under the action for YYRULE.  */
static inline void
yyglrShiftDefer (yyGLRStack* yystackp, YYPTRDIFF_T yyk, yy_state_t yylrState,
                 YYPTRDIFF_T yyposn, yyGLRState* yyrhs, yyRuleNum yyrule)
{
  yyGLRState* yynewState = &yynewGLRStackItem (yystackp, yytrue)->yystate;
  YY_ASSERT (yynewState->yyisState);

  yynewState->yylrState = yylrState;
  yynewState->yyposn = yyposn;
  yynewState->yyresolved = yyfalse;
  yynewState->yypred = yystackp->yytops.yystates[yyk];
  yynewState->yysemantics.yyfirstVal = YY_NULLPTR;
  yystackp->yytops.yystates[yyk] = yynewState;

  /* Invokes YY_RESERVE_GLRSTACK.  */
  yyaddDeferredAction (yystackp, yyk, yynewState, yyrhs, yyrule);
}

#if YYDEBUG

/*----------------------------------------------------------------------.
| Report that stack #YYK of *YYSTACKP is going to be reduced by YYRULE. |
`----------------------------------------------------------------------*/

static inline void
yy_reduce_print (yybool yynormal, yyGLRStackItem* yyvsp, YYPTRDIFF_T yyk,
                 yyRuleNum yyrule)
{
  int yynrhs = yyrhsLength (yyrule);
  int yyi;
  YY_FPRINTF ((stderr, "Reducing stack %ld by rule %d (line %d):\n",
               YY_CAST (long, yyk), yyrule - 1, yyrline[yyrule]));
  if (! yynormal)
    yyfillin (yyvsp, 1, -yynrhs);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YY_FPRINTF ((stderr, "   $%d = ", yyi + 1));
      yy_symbol_print (stderr,
                       yy_accessing_symbol (yyvsp[yyi - yynrhs + 1].yystate.yylrState),
                       &yyvsp[yyi - yynrhs + 1].yystate.yysemantics.yyval                       );
      if (!yyvsp[yyi - yynrhs + 1].yystate.yyresolved)
        YY_FPRINTF ((stderr, " (unresolved)"));
      YY_FPRINTF ((stderr, "\n"));
    }
}
#endif

/** Pop the symbols consumed by reduction #YYRULE from the top of stack
 *  #YYK of *YYSTACKP, and perform the appropriate semantic action on their
 *  semantic values.  Assumes that all ambiguities in semantic values
 *  have been previously resolved.  Set *YYVALP to the resulting value,
 *  and *YYLOCP to the computed location (if any).  Return value is as
 *  for userAction.  */
static inline YYRESULTTAG
yydoAction (yyGLRStack* yystackp, YYPTRDIFF_T yyk, yyRuleNum yyrule,
            YYSTYPE* yyvalp)
{
  int yynrhs = yyrhsLength (yyrule);

  if (yystackp->yysplitPoint == YY_NULLPTR)
    {
      /* Standard special case: single stack.  */
      yyGLRStackItem* yyrhs
        = YY_REINTERPRET_CAST (yyGLRStackItem*, yystackp->yytops.yystates[yyk]);
      YY_ASSERT (yyk == 0);
      yystackp->yynextFree -= yynrhs;
      yystackp->yyspaceLeft += yynrhs;
      yystackp->yytops.yystates[0] = & yystackp->yynextFree[-1].yystate;
      return yyuserAction (yyrule, yynrhs, yyrhs, yystackp, yyk,
                           yyvalp);
    }
  else
    {
      yyGLRStackItem yyrhsVals[YYMAXRHS + YYMAXLEFT + 1];
      yyGLRState* yys = yyrhsVals[YYMAXRHS + YYMAXLEFT].yystate.yypred
        = yystackp->yytops.yystates[yyk];
      int yyi;
      for (yyi = 0; yyi < yynrhs; yyi += 1)
        {
          yys = yys->yypred;
          YY_ASSERT (yys);
        }
      yyupdateSplit (yystackp, yys);
      yystackp->yytops.yystates[yyk] = yys;
      return yyuserAction (yyrule, yynrhs, yyrhsVals + YYMAXRHS + YYMAXLEFT - 1,
                           yystackp, yyk, yyvalp);
    }
}

/** Pop items off stack #YYK of *YYSTACKP according to grammar rule YYRULE,
 *  and push back on the resulting nonterminal symbol.  Perform the
 *  semantic action associated with YYRULE and store its value with the
 *  newly pushed state, if YYFORCEEVAL or if *YYSTACKP is currently
 *  unambiguous.  Otherwise, store the deferred semantic action with
 *  the new state.  If the new state would have an identical input
 *  position, LR state, and predecessor to an existing state on the stack,
 *  it is identified with that existing state, eliminating stack #YYK from
 *  *YYSTACKP.  In this case, the semantic value is
 *  added to the options for the existing state's semantic value.
 */
static inline YYRESULTTAG
yyglrReduce (yyGLRStack* yystackp, YYPTRDIFF_T yyk, yyRuleNum yyrule,
             yybool yyforceEval)
{
  YYPTRDIFF_T yyposn = yystackp->yytops.yystates[yyk]->yyposn;

  if (yyforceEval || yystackp->yysplitPoint == YY_NULLPTR)
    {
      YYSTYPE yyval;

      YYRESULTTAG yyflag = yydoAction (yystackp, yyk, yyrule, &yyval);
      if (yyflag == yyerr && yystackp->yysplitPoint != YY_NULLPTR)
        YY_DPRINTF ((stderr,
                     "Parse on stack %ld rejected by rule %d (line %d).\n",
                     YY_CAST (long, yyk), yyrule - 1, yyrline[yyrule]));
      if (yyflag != yyok)
        return yyflag;
      yyglrShift (yystackp, yyk,
                  yyLRgotoState (yystackp->yytops.yystates[yyk]->yylrState,
                                 yylhsNonterm (yyrule)),
                  yyposn, &yyval);
    }
  else
    {
      YYPTRDIFF_T yyi;
      int yyn;
      yyGLRState* yys, *yys0 = yystackp->yytops.yystates[yyk];
      yy_state_t yynewLRState;

      for (yys = yystackp->yytops.yystates[yyk], yyn = yyrhsLength (yyrule);
           0 < yyn; yyn -= 1)
        {
          yys = yys->yypred;
          YY_ASSERT (yys);
        }
      yyupdateSplit (yystackp, yys);
      yynewLRState = yyLRgotoState (yys->yylrState, yylhsNonterm (yyrule));
      YY_DPRINTF ((stderr,
                   "Reduced stack %ld by rule %d (line %d); action deferred.  "
                   "Now in state %d.\n",
                   YY_CAST (long, yyk), yyrule - 1, yyrline[yyrule],
                   yynewLRState));
      for (yyi = 0; yyi < yystackp->yytops.yysize; yyi += 1)
        if (yyi != yyk && yystackp->yytops.yystates[yyi] != YY_NULLPTR)
          {
            yyGLRState *yysplit = yystackp->yysplitPoint;
            yyGLRState *yyp = yystackp->yytops.yystates[yyi];
            while (yyp != yys && yyp != yysplit && yyp->yyposn >= yyposn)
              {
                if (yyp->yylrState == yynewLRState && yyp->yypred == yys)
                  {
                    yyaddDeferredAction (yystackp, yyk, yyp, yys0, yyrule);
                    yymarkStackDeleted (yystackp, yyk);
                    YY_DPRINTF ((stderr, "Merging stack %ld into stack %ld.\n",
                                 YY_CAST (long, yyk), YY_CAST (long, yyi)));
                    return yyok;
                  }
                yyp = yyp->yypred;
              }
          }
      yystackp->yytops.yystates[yyk] = yys;
      yyglrShiftDefer (yystackp, yyk, yynewLRState, yyposn, yys0, yyrule);
    }
  return yyok;
}

static YYPTRDIFF_T
yysplitStack (yyGLRStack* yystackp, YYPTRDIFF_T yyk)
{
  if (yystackp->yysplitPoint == YY_NULLPTR)
    {
      YY_ASSERT (yyk == 0);
      yystackp->yysplitPoint = yystackp->yytops.yystates[yyk];
    }
  if (yystackp->yytops.yycapacity <= yystackp->yytops.yysize)
    {
      YYPTRDIFF_T state_size = YYSIZEOF (yystackp->yytops.yystates[0]);
      YYPTRDIFF_T half_max_capacity = YYSIZE_MAXIMUM / 2 / state_size;
      if (half_max_capacity < yystackp->yytops.yycapacity)
        yyMemoryExhausted (yystackp);
      yystackp->yytops.yycapacity *= 2;

      {
        yyGLRState** yynewStates
          = YY_CAST (yyGLRState**,
                     YYREALLOC (yystackp->yytops.yystates,
                                (YY_CAST (YYSIZE_T, yystackp->yytops.yycapacity)
                                 * sizeof yynewStates[0])));
        if (yynewStates == YY_NULLPTR)
          yyMemoryExhausted (yystackp);
        yystackp->yytops.yystates = yynewStates;
      }

      {
        yybool* yynewLookaheadNeeds
          = YY_CAST (yybool*,
                     YYREALLOC (yystackp->yytops.yylookaheadNeeds,
                                (YY_CAST (YYSIZE_T, yystackp->yytops.yycapacity)
                                 * sizeof yynewLookaheadNeeds[0])));
        if (yynewLookaheadNeeds == YY_NULLPTR)
          yyMemoryExhausted (yystackp);
        yystackp->yytops.yylookaheadNeeds = yynewLookaheadNeeds;
      }
    }
  yystackp->yytops.yystates[yystackp->yytops.yysize]
    = yystackp->yytops.yystates[yyk];
  yystackp->yytops.yylookaheadNeeds[yystackp->yytops.yysize]
    = yystackp->yytops.yylookaheadNeeds[yyk];
  yystackp->yytops.yysize += 1;
  return yystackp->yytops.yysize - 1;
}

/** True iff YYY0 and YYY1 represent identical options at the top level.
 *  That is, they represent the same rule applied to RHS symbols
 *  that produce the same terminal symbols.  */
static yybool
yyidenticalOptions (yySemanticOption* yyy0, yySemanticOption* yyy1)
{
  if (yyy0->yyrule == yyy1->yyrule)
    {
      yyGLRState *yys0, *yys1;
      int yyn;
      for (yys0 = yyy0->yystate, yys1 = yyy1->yystate,
           yyn = yyrhsLength (yyy0->yyrule);
           yyn > 0;
           yys0 = yys0->yypred, yys1 = yys1->yypred, yyn -= 1)
        if (yys0->yyposn != yys1->yyposn)
          return yyfalse;
      return yytrue;
    }
  else
    return yyfalse;
}

/** Assuming identicalOptions (YYY0,YYY1), destructively merge the
 *  alternative semantic values for the RHS-symbols of YYY1 and YYY0.  */
static void
yymergeOptionSets (yySemanticOption* yyy0, yySemanticOption* yyy1)
{
  yyGLRState *yys0, *yys1;
  int yyn;
  for (yys0 = yyy0->yystate, yys1 = yyy1->yystate,
       yyn = yyrhsLength (yyy0->yyrule);
       0 < yyn;
       yys0 = yys0->yypred, yys1 = yys1->yypred, yyn -= 1)
    {
      if (yys0 == yys1)
        break;
      else if (yys0->yyresolved)
        {
          yys1->yyresolved = yytrue;
          yys1->yysemantics.yyval = yys0->yysemantics.yyval;
        }
      else if (yys1->yyresolved)
        {
          yys0->yyresolved = yytrue;
          yys0->yysemantics.yyval = yys1->yysemantics.yyval;
        }
      else
        {
          yySemanticOption** yyz0p = &yys0->yysemantics.yyfirstVal;
          yySemanticOption* yyz1 = yys1->yysemantics.yyfirstVal;
          while (yytrue)
            {
              if (yyz1 == *yyz0p || yyz1 == YY_NULLPTR)
                break;
              else if (*yyz0p == YY_NULLPTR)
                {
                  *yyz0p = yyz1;
                  break;
                }
              else if (*yyz0p < yyz1)
                {
                  yySemanticOption* yyz = *yyz0p;
                  *yyz0p = yyz1;
                  yyz1 = yyz1->yynext;
                  (*yyz0p)->yynext = yyz;
                }
              yyz0p = &(*yyz0p)->yynext;
            }
          yys1->yysemantics.yyfirstVal = yys0->yysemantics.yyfirstVal;
        }
    }
}

/** Y0 and Y1 represent two possible actions to take in a given
 *  parsing state; return 0 if no combination is possible,
 *  1 if user-mergeable, 2 if Y0 is preferred, 3 if Y1 is preferred.  */
static int
yypreference (yySemanticOption* y0, yySemanticOption* y1)
{
  yyRuleNum r0 = y0->yyrule, r1 = y1->yyrule;
  int p0 = yydprec[r0], p1 = yydprec[r1];

  if (p0 == p1)
    {
      if (yymerger[r0] == 0 || yymerger[r0] != yymerger[r1])
        return 0;
      else
        return 1;
    }
  if (p0 == 0 || p1 == 0)
    return 0;
  if (p0 < p1)
    return 3;
  if (p1 < p0)
    return 2;
  return 0;
}

static YYRESULTTAG
yyresolveValue (yyGLRState* yys, yyGLRStack* yystackp);


/** Resolve the previous YYN states starting at and including state YYS
 *  on *YYSTACKP. If result != yyok, some states may have been left
 *  unresolved possibly with empty semantic option chains.  Regardless
 *  of whether result = yyok, each state has been left with consistent
 *  data so that yydestroyGLRState can be invoked if necessary.  */
static YYRESULTTAG
yyresolveStates (yyGLRState* yys, int yyn,
                 yyGLRStack* yystackp)
{
  if (0 < yyn)
    {
      YY_ASSERT (yys->yypred);
      YYCHK (yyresolveStates (yys->yypred, yyn-1, yystackp));
      if (! yys->yyresolved)
        YYCHK (yyresolveValue (yys, yystackp));
    }
  return yyok;
}

/** Resolve the states for the RHS of YYOPT on *YYSTACKP, perform its
 *  user action, and return the semantic value and location in *YYVALP
 *  and *YYLOCP.  Regardless of whether result = yyok, all RHS states
 *  have been destroyed (assuming the user action destroys all RHS
 *  semantic values if invoked).  */
static YYRESULTTAG
yyresolveAction (yySemanticOption* yyopt, yyGLRStack* yystackp,
                 YYSTYPE* yyvalp)
{
  yyGLRStackItem yyrhsVals[YYMAXRHS + YYMAXLEFT + 1];
  int yynrhs = yyrhsLength (yyopt->yyrule);
  YYRESULTTAG yyflag =
    yyresolveStates (yyopt->yystate, yynrhs, yystackp);
  if (yyflag != yyok)
    {
      yyGLRState *yys;
      for (yys = yyopt->yystate; yynrhs > 0; yys = yys->yypred, yynrhs -= 1)
        yydestroyGLRState ("Cleanup: popping", yys);
      return yyflag;
    }

  yyrhsVals[YYMAXRHS + YYMAXLEFT].yystate.yypred = yyopt->yystate;
  {
    int yychar_current = yychar;
    YYSTYPE yylval_current = yylval;
    yychar = yyopt->yyrawchar;
    yylval = yyopt->yyval;
    yyflag = yyuserAction (yyopt->yyrule, yynrhs,
                           yyrhsVals + YYMAXRHS + YYMAXLEFT - 1,
                           yystackp, -1, yyvalp);
    yychar = yychar_current;
    yylval = yylval_current;
  }
  return yyflag;
}

#if YYDEBUG
static void
yyreportTree (yySemanticOption* yyx, int yyindent)
{
  int yynrhs = yyrhsLength (yyx->yyrule);
  int yyi;
  yyGLRState* yys;
  yyGLRState* yystates[1 + YYMAXRHS];
  yyGLRState yyleftmost_state;

  for (yyi = yynrhs, yys = yyx->yystate; 0 < yyi; yyi -= 1, yys = yys->yypred)
    yystates[yyi] = yys;
  if (yys == YY_NULLPTR)
    {
      yyleftmost_state.yyposn = 0;
      yystates[0] = &yyleftmost_state;
    }
  else
    yystates[0] = yys;

  if (yyx->yystate->yyposn < yys->yyposn + 1)
    YY_FPRINTF ((stderr, "%*s%s -> <Rule %d, empty>\n",
                 yyindent, "", yysymbol_name (yylhsNonterm (yyx->yyrule)),
                 yyx->yyrule - 1));
  else
    YY_FPRINTF ((stderr, "%*s%s -> <Rule %d, tokens %ld .. %ld>\n",
                 yyindent, "", yysymbol_name (yylhsNonterm (yyx->yyrule)),
                 yyx->yyrule - 1, YY_CAST (long, yys->yyposn + 1),
                 YY_CAST (long, yyx->yystate->yyposn)));
  for (yyi = 1; yyi <= yynrhs; yyi += 1)
    {
      if (yystates[yyi]->yyresolved)
        {
          if (yystates[yyi-1]->yyposn+1 > yystates[yyi]->yyposn)
            YY_FPRINTF ((stderr, "%*s%s <empty>\n", yyindent+2, "",
                         yysymbol_name (yy_accessing_symbol (yystates[yyi]->yylrState))));
          else
            YY_FPRINTF ((stderr, "%*s%s <tokens %ld .. %ld>\n", yyindent+2, "",
                         yysymbol_name (yy_accessing_symbol (yystates[yyi]->yylrState)),
                         YY_CAST (long, yystates[yyi-1]->yyposn + 1),
                         YY_CAST (long, yystates[yyi]->yyposn)));
        }
      else
        yyreportTree (yystates[yyi]->yysemantics.yyfirstVal, yyindent+2);
    }
}
#endif

static YYRESULTTAG
yyreportAmbiguity (yySemanticOption* yyx0,
                   yySemanticOption* yyx1)
{
  YY_USE (yyx0);
  YY_USE (yyx1);

#if YYDEBUG
  YY_FPRINTF ((stderr, "Ambiguity detected.\n"));
  YY_FPRINTF ((stderr, "Option 1,\n"));
  yyreportTree (yyx0, 2);
  YY_FPRINTF ((stderr, "\nOption 2,\n"));
  yyreportTree (yyx1, 2);
  YY_FPRINTF ((stderr, "\n"));
#endif

  yyerror (YY_("syntax is ambiguous"));
  return yyabort;
}

/** Resolve the ambiguity represented in state YYS in *YYSTACKP,
 *  perform the indicated actions, and set the semantic value of YYS.
 *  If result != yyok, the chain of semantic options in YYS has been
 *  cleared instead or it has been left unmodified except that
 *  redundant options may have been removed.  Regardless of whether
 *  result = yyok, YYS has been left with consistent data so that
 *  yydestroyGLRState can be invoked if necessary.  */
static YYRESULTTAG
yyresolveValue (yyGLRState* yys, yyGLRStack* yystackp)
{
  yySemanticOption* yyoptionList = yys->yysemantics.yyfirstVal;
  yySemanticOption* yybest = yyoptionList;
  yySemanticOption** yypp;
  yybool yymerge = yyfalse;
  YYSTYPE yyval;
  YYRESULTTAG yyflag;

  for (yypp = &yyoptionList->yynext; *yypp != YY_NULLPTR; )
    {
      yySemanticOption* yyp = *yypp;

      if (yyidenticalOptions (yybest, yyp))
        {
          yymergeOptionSets (yybest, yyp);
          *yypp = yyp->yynext;
        }
      else
        {
          switch (yypreference (yybest, yyp))
            {
            case 0:
              return yyreportAmbiguity (yybest, yyp);
              break;
            case 1:
              yymerge = yytrue;
              break;
            case 2:
              break;
            case 3:
              yybest = yyp;
              yymerge = yyfalse;
              break;
            default:
              /* This cannot happen so it is not worth a YY_ASSERT (yyfalse),
                 but some compilers complain if the default case is
                 omitted.  */
              break;
            }
          yypp = &yyp->yynext;
        }
    }

  if (yymerge)
    {
      yySemanticOption* yyp;
      int yyprec = yydprec[yybest->yyrule];
      yyflag = yyresolveAction (yybest, yystackp, &yyval);
      if (yyflag == yyok)
        for (yyp = yybest->yynext; yyp != YY_NULLPTR; yyp = yyp->yynext)
          {
            if (yyprec == yydprec[yyp->yyrule])
              {
                YYSTYPE yyval_other;
                yyflag = yyresolveAction (yyp, yystackp, &yyval_other);
                if (yyflag != yyok)
                  {
                    yydestruct ("Cleanup: discarding incompletely merged value for",
                                yy_accessing_symbol (yys->yylrState),
                                &yyval);
                    break;
                  }
                yyuserMerge (yymerger[yyp->yyrule], &yyval, &yyval_other);
              }
          }
    }
  else
    yyflag = yyresolveAction (yybest, yystackp, &yyval);

  if (yyflag == yyok)
    {
      yys->yyresolved = yytrue;
      yys->yysemantics.yyval = yyval;
    }
  else
    yys->yysemantics.yyfirstVal = YY_NULLPTR;
  return yyflag;
}

static YYRESULTTAG
yyresolveStack (yyGLRStack* yystackp)
{
  if (yystackp->yysplitPoint != YY_NULLPTR)
    {
      yyGLRState* yys;
      int yyn;

      for (yyn = 0, yys = yystackp->yytops.yystates[0];
           yys != yystackp->yysplitPoint;
           yys = yys->yypred, yyn += 1)
        continue;
      YYCHK (yyresolveStates (yystackp->yytops.yystates[0], yyn, yystackp
                             ));
    }
  return yyok;
}

/** Called when returning to deterministic operation to clean up the extra
 * stacks. */
static void
yycompressStack (yyGLRStack* yystackp)
{
  /* yyr is the state after the split point.  */
  yyGLRState *yyr;

  if (yystackp->yytops.yysize != 1 || yystackp->yysplitPoint == YY_NULLPTR)
    return;

  {
    yyGLRState *yyp, *yyq;
    for (yyp = yystackp->yytops.yystates[0], yyq = yyp->yypred, yyr = YY_NULLPTR;
         yyp != yystackp->yysplitPoint;
         yyr = yyp, yyp = yyq, yyq = yyp->yypred)
      yyp->yypred = yyr;
  }

  yystackp->yyspaceLeft += yystackp->yynextFree - yystackp->yyitems;
  yystackp->yynextFree = YY_REINTERPRET_CAST (yyGLRStackItem*, yystackp->yysplitPoint) + 1;
  yystackp->yyspaceLeft -= yystackp->yynextFree - yystackp->yyitems;
  yystackp->yysplitPoint = YY_NULLPTR;
  yystackp->yylastDeleted = YY_NULLPTR;

  while (yyr != YY_NULLPTR)
    {
      yystackp->yynextFree->yystate = *yyr;
      yyr = yyr->yypred;
      yystackp->yynextFree->yystate.yypred = &yystackp->yynextFree[-1].yystate;
      yystackp->yytops.yystates[0] = &yystackp->yynextFree->yystate;
      yystackp->yynextFree += 1;
      yystackp->yyspaceLeft -= 1;
    }
}

static YYRESULTTAG
yyprocessOneStack (yyGLRStack* yystackp, YYPTRDIFF_T yyk,
                   YYPTRDIFF_T yyposn)
{
  while (yystackp->yytops.yystates[yyk] != YY_NULLPTR)
    {
      yy_state_t yystate = yystackp->yytops.yystates[yyk]->yylrState;
      YY_DPRINTF ((stderr, "Stack %ld Entering state %d\n",
                   YY_CAST (long, yyk), yystate));

      YY_ASSERT (yystate != YYFINAL);

      if (yyisDefaultedState (yystate))
        {
          YYRESULTTAG yyflag;
          yyRuleNum yyrule = yydefaultAction (yystate);
          if (yyrule == 0)
            {
              YY_DPRINTF ((stderr, "Stack %ld dies.\n", YY_CAST (long, yyk)));
              yymarkStackDeleted (yystackp, yyk);
              return yyok;
            }
          yyflag = yyglrReduce (yystackp, yyk, yyrule, yyimmediate[yyrule]);
          if (yyflag == yyerr)
            {
              YY_DPRINTF ((stderr,
                           "Stack %ld dies "
                           "(predicate failure or explicit user error).\n",
                           YY_CAST (long, yyk)));
              yymarkStackDeleted (yystackp, yyk);
              return yyok;
            }
          if (yyflag != yyok)
            return yyflag;
        }
      else
        {
          yysymbol_kind_t yytoken = yygetToken (&yychar);
          const short* yyconflicts;
          const int yyaction = yygetLRActions (yystate, yytoken, &yyconflicts);
          yystackp->yytops.yylookaheadNeeds[yyk] = yytrue;

          for (/* nothing */; *yyconflicts; yyconflicts += 1)
            {
              YYRESULTTAG yyflag;
              YYPTRDIFF_T yynewStack = yysplitStack (yystackp, yyk);
              YY_DPRINTF ((stderr, "Splitting off stack %ld from %ld.\n",
                           YY_CAST (long, yynewStack), YY_CAST (long, yyk)));
              yyflag = yyglrReduce (yystackp, yynewStack,
                                    *yyconflicts,
                                    yyimmediate[*yyconflicts]);
              if (yyflag == yyok)
                YYCHK (yyprocessOneStack (yystackp, yynewStack,
                                          yyposn));
              else if (yyflag == yyerr)
                {
                  YY_DPRINTF ((stderr, "Stack %ld dies.\n", YY_CAST (long, yynewStack)));
                  yymarkStackDeleted (yystackp, yynewStack);
                }
              else
                return yyflag;
            }

          if (yyisShiftAction (yyaction))
            break;
          else if (yyisErrorAction (yyaction))
            {
              YY_DPRINTF ((stderr, "Stack %ld dies.\n", YY_CAST (long, yyk)));
              yymarkStackDeleted (yystackp, yyk);
              break;
            }
          else
            {
              YYRESULTTAG yyflag = yyglrReduce (yystackp, yyk, -yyaction,
                                                yyimmediate[-yyaction]);
              if (yyflag == yyerr)
                {
                  YY_DPRINTF ((stderr,
                               "Stack %ld dies "
                               "(predicate failure or explicit user error).\n",
                               YY_CAST (long, yyk)));
                  yymarkStackDeleted (yystackp, yyk);
                  break;
                }
              else if (yyflag != yyok)
                return yyflag;
            }
        }
    }
  return yyok;
}






static void
yyreportSyntaxError (yyGLRStack* yystackp)
{
  if (yystackp->yyerrState != 0)
    return;
  yyerror (YY_("syntax error"));
  yynerrs += 1;
}

/* Recover from a syntax error on *YYSTACKP, assuming that *YYSTACKP->YYTOKENP,
   yylval, and yylloc are the syntactic category, semantic value, and location
   of the lookahead.  */
static void
yyrecoverSyntaxError (yyGLRStack* yystackp)
{
  if (yystackp->yyerrState == 3)
    /* We just shifted the error token and (perhaps) took some
       reductions.  Skip tokens until we can proceed.  */
    while (yytrue)
      {
        yysymbol_kind_t yytoken;
        int yyj;
        if (yychar == YYEOF)
          yyFail (yystackp, YY_NULLPTR);
        if (yychar != YYEMPTY)
          {
            yytoken = YYTRANSLATE (yychar);
            yydestruct ("Error: discarding",
                        yytoken, &yylval);
            yychar = YYEMPTY;
          }
        yytoken = yygetToken (&yychar);
        yyj = yypact[yystackp->yytops.yystates[0]->yylrState];
        if (yypact_value_is_default (yyj))
          return;
        yyj += yytoken;
        if (yyj < 0 || YYLAST < yyj || yycheck[yyj] != yytoken)
          {
            if (yydefact[yystackp->yytops.yystates[0]->yylrState] != 0)
              return;
          }
        else if (! yytable_value_is_error (yytable[yyj]))
          return;
      }

  /* Reduce to one stack.  */
  {
    YYPTRDIFF_T yyk;
    for (yyk = 0; yyk < yystackp->yytops.yysize; yyk += 1)
      if (yystackp->yytops.yystates[yyk] != YY_NULLPTR)
        break;
    if (yyk >= yystackp->yytops.yysize)
      yyFail (yystackp, YY_NULLPTR);
    for (yyk += 1; yyk < yystackp->yytops.yysize; yyk += 1)
      yymarkStackDeleted (yystackp, yyk);
    yyremoveDeletes (yystackp);
    yycompressStack (yystackp);
  }

  /* Pop stack until we find a state that shifts the error token.  */
  yystackp->yyerrState = 3;
  while (yystackp->yytops.yystates[0] != YY_NULLPTR)
    {
      yyGLRState *yys = yystackp->yytops.yystates[0];
      int yyj = yypact[yys->yylrState];
      if (! yypact_value_is_default (yyj))
        {
          yyj += YYSYMBOL_YYerror;
          if (0 <= yyj && yyj <= YYLAST && yycheck[yyj] == YYSYMBOL_YYerror
              && yyisShiftAction (yytable[yyj]))
            {
              /* Shift the error token.  */
              int yyaction = yytable[yyj];
              YY_SYMBOL_PRINT ("Shifting", yy_accessing_symbol (yyaction),
                               &yylval, &yyerrloc);
              yyglrShift (yystackp, 0, yyaction,
                          yys->yyposn, &yylval);
              yys = yystackp->yytops.yystates[0];
              break;
            }
        }
      if (yys->yypred != YY_NULLPTR)
        yydestroyGLRState ("Error: popping", yys);
      yystackp->yytops.yystates[0] = yys->yypred;
      yystackp->yynextFree -= 1;
      yystackp->yyspaceLeft += 1;
    }
  if (yystackp->yytops.yystates[0] == YY_NULLPTR)
    yyFail (yystackp, YY_NULLPTR);
}

#define YYCHK1(YYE)                             \
  do {                                          \
    switch (YYE) {                              \
    case yyok:     break;                       \
    case yyabort:  goto yyabortlab;             \
    case yyaccept: goto yyacceptlab;            \
    case yyerr:    goto yyuser_error;           \
    case yynomem:  goto yyexhaustedlab;         \
    default:       goto yybuglab;               \
    }                                           \
  } while (0)

/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
  int yyresult;
  yyGLRStack yystack;
  yyGLRStack* const yystackp = &yystack;
  YYPTRDIFF_T yyposn;

  YY_DPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY;
  yylval = yyval_default;

  if (! yyinitGLRStack (yystackp, YYINITDEPTH))
    goto yyexhaustedlab;
  switch (YYSETJMP (yystack.yyexception_buffer))
    {
    case 0: break;
    case 1: goto yyabortlab;
    case 2: goto yyexhaustedlab;
    default: goto yybuglab;
    }
  yyglrShift (&yystack, 0, 0, 0, &yylval);
  yyposn = 0;

  while (yytrue)
    {
      /* For efficiency, we have two loops, the first of which is
         specialized to deterministic operation (single stack, no
         potential ambiguity).  */
      /* Standard mode. */
      while (yytrue)
        {
          yy_state_t yystate = yystack.yytops.yystates[0]->yylrState;
          YY_DPRINTF ((stderr, "Entering state %d\n", yystate));
          if (yystate == YYFINAL)
            goto yyacceptlab;
          if (yyisDefaultedState (yystate))
            {
              yyRuleNum yyrule = yydefaultAction (yystate);
              if (yyrule == 0)
                {
                  yyreportSyntaxError (&yystack);
                  goto yyuser_error;
                }
              YYCHK1 (yyglrReduce (&yystack, 0, yyrule, yytrue));
            }
          else
            {
              yysymbol_kind_t yytoken = yygetToken (&yychar);
              const short* yyconflicts;
              int yyaction = yygetLRActions (yystate, yytoken, &yyconflicts);
              if (*yyconflicts)
                /* Enter nondeterministic mode.  */
                break;
              if (yyisShiftAction (yyaction))
                {
                  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
                  yychar = YYEMPTY;
                  yyposn += 1;
                  yyglrShift (&yystack, 0, yyaction, yyposn, &yylval);
                  if (0 < yystack.yyerrState)
                    yystack.yyerrState -= 1;
                }
              else if (yyisErrorAction (yyaction))
                {
                  /* Issue an error message unless the scanner already
                     did. */
                  if (yychar != YYerror)
                    yyreportSyntaxError (&yystack);
                  goto yyuser_error;
                }
              else
                YYCHK1 (yyglrReduce (&yystack, 0, -yyaction, yytrue));
            }
        }

      /* Nondeterministic mode. */
      while (yytrue)
        {
          yysymbol_kind_t yytoken_to_shift;
          YYPTRDIFF_T yys;

          for (yys = 0; yys < yystack.yytops.yysize; yys += 1)
            yystackp->yytops.yylookaheadNeeds[yys] = yychar != YYEMPTY;

          /* yyprocessOneStack returns one of three things:

              - An error flag.  If the caller is yyprocessOneStack, it
                immediately returns as well.  When the caller is finally
                yyparse, it jumps to an error label via YYCHK1.

              - yyok, but yyprocessOneStack has invoked yymarkStackDeleted
                (&yystack, yys), which sets the top state of yys to NULL.  Thus,
                yyparse's following invocation of yyremoveDeletes will remove
                the stack.

              - yyok, when ready to shift a token.

             Except in the first case, yyparse will invoke yyremoveDeletes and
             then shift the next token onto all remaining stacks.  This
             synchronization of the shift (that is, after all preceding
             reductions on all stacks) helps prevent double destructor calls
             on yylval in the event of memory exhaustion.  */

          for (yys = 0; yys < yystack.yytops.yysize; yys += 1)
            YYCHK1 (yyprocessOneStack (&yystack, yys, yyposn));
          yyremoveDeletes (&yystack);
          if (yystack.yytops.yysize == 0)
            {
              yyundeleteLastStack (&yystack);
              if (yystack.yytops.yysize == 0)
                yyFail (&yystack, YY_("syntax error"));
              YYCHK1 (yyresolveStack (&yystack));
              YY_DPRINTF ((stderr, "Returning to deterministic operation.\n"));
              yyreportSyntaxError (&yystack);
              goto yyuser_error;
            }

          /* If any yyglrShift call fails, it will fail after shifting.  Thus,
             a copy of yylval will already be on stack 0 in the event of a
             failure in the following loop.  Thus, yychar is set to YYEMPTY
             before the loop to make sure the user destructor for yylval isn't
             called twice.  */
          yytoken_to_shift = YYTRANSLATE (yychar);
          yychar = YYEMPTY;
          yyposn += 1;
          for (yys = 0; yys < yystack.yytops.yysize; yys += 1)
            {
              yy_state_t yystate = yystack.yytops.yystates[yys]->yylrState;
              const short* yyconflicts;
              int yyaction = yygetLRActions (yystate, yytoken_to_shift,
                              &yyconflicts);
              /* Note that yyconflicts were handled by yyprocessOneStack.  */
              YY_DPRINTF ((stderr, "On stack %ld, ", YY_CAST (long, yys)));
              YY_SYMBOL_PRINT ("shifting", yytoken_to_shift, &yylval, &yylloc);
              yyglrShift (&yystack, yys, yyaction, yyposn,
                          &yylval);
              YY_DPRINTF ((stderr, "Stack %ld now in state %d\n",
                           YY_CAST (long, yys),
                           yystack.yytops.yystates[yys]->yylrState));
            }

          if (yystack.yytops.yysize == 1)
            {
              YYCHK1 (yyresolveStack (&yystack));
              YY_DPRINTF ((stderr, "Returning to deterministic operation.\n"));
              yycompressStack (&yystack);
              break;
            }
        }
      continue;
    yyuser_error:
      yyrecoverSyntaxError (&yystack);
      yyposn = yystack.yytops.yystates[0]->yyposn;
    }

 yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;

 yybuglab:
  YY_ASSERT (yyfalse);
  goto yyabortlab;

 yyabortlab:
  yyresult = 1;
  goto yyreturnlab;

 yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;

 yyreturnlab:
  if (yychar != YYEMPTY)
    yydestruct ("Cleanup: discarding lookahead",
                YYTRANSLATE (yychar), &yylval);

  /* If the stack is well-formed, pop the stack until it is empty,
     destroying its entries as we go.  But free the stack regardless
     of whether it is well-formed.  */
  if (yystack.yyitems)
    {
      yyGLRState** yystates = yystack.yytops.yystates;
      if (yystates)
        {
          YYPTRDIFF_T yysize = yystack.yytops.yysize;
          YYPTRDIFF_T yyk;
          for (yyk = 0; yyk < yysize; yyk += 1)
            if (yystates[yyk])
              {
                while (yystates[yyk])
                  {
                    yyGLRState *yys = yystates[yyk];
                    if (yys->yypred != YY_NULLPTR)
                      yydestroyGLRState ("Cleanup: popping", yys);
                    yystates[yyk] = yys->yypred;
                    yystack.yynextFree -= 1;
                    yystack.yyspaceLeft += 1;
                  }
                break;
              }
        }
      yyfreeGLRStack (&yystack);
    }

  return yyresult;
}

/* DEBUGGING ONLY */
#if YYDEBUG
/* Print *YYS and its predecessors. */
static void
yy_yypstack (yyGLRState* yys)
{
  if (yys->yypred)
    {
      yy_yypstack (yys->yypred);
      YY_FPRINTF ((stderr, " -> "));
    }
  YY_FPRINTF ((stderr, "%d@%ld", yys->yylrState, YY_CAST (long, yys->yyposn)));
}

/* Print YYS (possibly NULL) and its predecessors. */
static void
yypstates (yyGLRState* yys)
{
  if (yys == YY_NULLPTR)
    YY_FPRINTF ((stderr, "<null>"));
  else
    yy_yypstack (yys);
  YY_FPRINTF ((stderr, "\n"));
}

/* Print the stack #YYK.  */
static void
yypstack (yyGLRStack* yystackp, YYPTRDIFF_T yyk)
{
  yypstates (yystackp->yytops.yystates[yyk]);
}

/* Print all the stacks.  */
static void
yypdumpstack (yyGLRStack* yystackp)
{
#define YYINDEX(YYX)                                                    \
  YY_CAST (long,                                                        \
           ((YYX)                                                       \
            ? YY_REINTERPRET_CAST (yyGLRStackItem*, (YYX)) - yystackp->yyitems \
            : -1))

  yyGLRStackItem* yyp;
  for (yyp = yystackp->yyitems; yyp < yystackp->yynextFree; yyp += 1)
    {
      YY_FPRINTF ((stderr, "%3ld. ",
                   YY_CAST (long, yyp - yystackp->yyitems)));
      if (*YY_REINTERPRET_CAST (yybool *, yyp))
        {
          YY_ASSERT (yyp->yystate.yyisState);
          YY_ASSERT (yyp->yyoption.yyisState);
          YY_FPRINTF ((stderr, "Res: %d, LR State: %d, posn: %ld, pred: %ld",
                       yyp->yystate.yyresolved, yyp->yystate.yylrState,
                       YY_CAST (long, yyp->yystate.yyposn),
                       YYINDEX (yyp->yystate.yypred)));
          if (! yyp->yystate.yyresolved)
            YY_FPRINTF ((stderr, ", firstVal: %ld",
                         YYINDEX (yyp->yystate.yysemantics.yyfirstVal)));
        }
      else
        {
          YY_ASSERT (!yyp->yystate.yyisState);
          YY_ASSERT (!yyp->yyoption.yyisState);
          YY_FPRINTF ((stderr, "Option. rule: %d, state: %ld, next: %ld",
                       yyp->yyoption.yyrule - 1,
                       YYINDEX (yyp->yyoption.yystate),
                       YYINDEX (yyp->yyoption.yynext)));
        }
      YY_FPRINTF ((stderr, "\n"));
    }

  YY_FPRINTF ((stderr, "Tops:"));
  {
    YYPTRDIFF_T yyi;
    for (yyi = 0; yyi < yystackp->yytops.yysize; yyi += 1)
      YY_FPRINTF ((stderr, "%ld: %ld; ", YY_CAST (long, yyi),
                   YYINDEX (yystackp->yytops.yystates[yyi])));
    YY_FPRINTF ((stderr, "\n"));
  }
#undef YYINDEX
}
#endif

#undef yylval
#undef yychar
#undef yynerrs

/* Substitute the variable and function names.  */
#define yyparse SQLyyparse
#define yylex   SQLyylex
#define yyerror SQLyyerror
#define yylval  SQLyylval
#define yychar  SQLyychar
#define yydebug SQLyydebug
#define yynerrs SQLyynerrs




#if defined _MSC_VER
#pragma warning(pop)
#endif

using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::i18n;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::util;
using namespace ::osl;
using namespace ::dbtools;

connectivity::OSQLParser* xxx_pGLOBAL_SQLPARSER;

connectivity::OSQLInternalNode* newNode(const char* pNewValue,
        const connectivity::SQLNodeType eNodeType,
        const sal_uInt32 nNodeID)
{
    return new connectivity::OSQLInternalNode(pNewValue, eNodeType, nNodeID);
}

connectivity::OSQLInternalNode* newNode(const OString& _newValue,
        const connectivity::SQLNodeType eNodeType,
        const sal_uInt32 nNodeID)
{
    return new connectivity::OSQLInternalNode(_newValue, eNodeType, nNodeID);
}

connectivity::OSQLInternalNode* newNode(const OUString& _newValue,
        const connectivity::SQLNodeType eNodeType,
        const sal_uInt32 nNodeID)
{
    return new connectivity::OSQLInternalNode(_newValue, eNodeType, nNodeID);
}

OParseContext::OParseContext()
{
}


OParseContext::~OParseContext()
{
}


OUString OParseContext::getErrorMessage(ErrorCode _eCode) const
{
    OUString aMsg;
    switch (_eCode)
    {
        case ErrorCode::General:              aMsg = "Syntax error in SQL expression"; break;
        case ErrorCode::ValueNoLike:          aMsg = "The value #1 can not be used with LIKE."; break;
        case ErrorCode::FieldNoLike:          aMsg = "LIKE can not be used with this field."; break;
        case ErrorCode::InvalidCompare:       aMsg = "The entered criterion can not be compared with this field."; break;
        case ErrorCode::InvalidIntCompare:    aMsg = "The field can not be compared with a number."; break;
        case ErrorCode::InvalidDateCompare:   aMsg = "The field can not be compared with a date."; break;
        case ErrorCode::InvalidRealCompare:   aMsg = "The field can not be compared with a floating point number."; break;
        case ErrorCode::InvalidTableNosuch:   aMsg = "The database does not contain a table named \"#\"."; break;
        case ErrorCode::InvalidTableOrQuery:  aMsg = "The database does contain neither a table nor a query named \"#\"."; break;
        case ErrorCode::InvalidColumn:        aMsg = "The column \"#1\" is unknown in the table \"#2\"."; break;
        case ErrorCode::InvalidTableExist:    aMsg = "The database already contains a table or view with name \"#\"."; break;
        case ErrorCode::InvalidQueryExist:    aMsg = "The database already contains a query with name \"#\"."; break;
        default:
            OSL_FAIL( "OParseContext::getErrorMessage: unknown error code!" );
            break;
    }
    return aMsg;
}


OString OParseContext::getIntlKeywordAscii(InternationalKeyCode _eKey) const
{
	OString aKeyword;
	switch (_eKey)
	{
		case InternationalKeyCode::Like:		aKeyword = "LIKE"; break;
		case InternationalKeyCode::Not:		aKeyword = "NOT"; break;
		case InternationalKeyCode::Null:		aKeyword = "NULL"; break;
		case InternationalKeyCode::True:		aKeyword = "True"; break;
		case InternationalKeyCode::False:		aKeyword = "False"; break;
		case InternationalKeyCode::Is:		aKeyword = "IS"; break;
		case InternationalKeyCode::Between:	aKeyword = "BETWEEN"; break;
		case InternationalKeyCode::Or:		aKeyword = "OR"; break;
		case InternationalKeyCode::And:		aKeyword = "AND"; break;
		case InternationalKeyCode::Avg:		aKeyword = "AVG"; break;
		case InternationalKeyCode::Count:		aKeyword = "COUNT"; break;
		case InternationalKeyCode::Max:		aKeyword = "MAX"; break;
		case InternationalKeyCode::Min:		aKeyword = "MIN"; break;
		case InternationalKeyCode::Sum:		aKeyword = "SUM"; break;
        case InternationalKeyCode::Every:     aKeyword = "EVERY"; break;
        case InternationalKeyCode::Any:       aKeyword = "ANY"; break;
        case InternationalKeyCode::Some:      aKeyword = "SOME"; break;
        case InternationalKeyCode::StdDevPop: aKeyword = "STDDEV_POP"; break;
        case InternationalKeyCode::StdDevSamp: aKeyword = "STDDEV_SAMP"; break;
        case InternationalKeyCode::VarSamp:  aKeyword = "VAR_SAMP"; break;
        case InternationalKeyCode::VarPop:   aKeyword = "VAR_POP"; break;
        case InternationalKeyCode::Collect:   aKeyword = "COLLECT"; break;
        case InternationalKeyCode::Fusion:    aKeyword = "FUSION"; break;
        case InternationalKeyCode::Intersection:aKeyword = "INTERSECTION"; break;
        case InternationalKeyCode::None:      break;
        default:
            OSL_FAIL( "OParseContext::getIntlKeywordAscii: unknown key!" );
            break;
	}
	return aKeyword;
}


IParseContext::InternationalKeyCode OParseContext::getIntlKeyCode(const OString& rToken) const
{
    static IParseContext::InternationalKeyCode const Intl_TokenID[] =
	{
		InternationalKeyCode::Like, InternationalKeyCode::Not, InternationalKeyCode::Null, InternationalKeyCode::True,
		InternationalKeyCode::False, InternationalKeyCode::Is, InternationalKeyCode::Between, InternationalKeyCode::Or,
		InternationalKeyCode::And, InternationalKeyCode::Avg, InternationalKeyCode::Count, InternationalKeyCode::Max,
		InternationalKeyCode::Min, InternationalKeyCode::Sum, InternationalKeyCode::Every,InternationalKeyCode::Any,InternationalKeyCode::Some,
        InternationalKeyCode::StdDevPop,InternationalKeyCode::StdDevSamp,InternationalKeyCode::VarSamp,
        InternationalKeyCode::VarPop,InternationalKeyCode::Collect,InternationalKeyCode::Fusion,InternationalKeyCode::Intersection
	};

    auto const token = std::find_if(std::cbegin(Intl_TokenID), std::cend(Intl_TokenID)
                                    , [&rToken, this](IParseContext::InternationalKeyCode const & tokenID)
                                      { return rToken.equalsIgnoreAsciiCase(getIntlKeywordAscii(tokenID)); });

    if (std::cend(Intl_TokenID) != token)
        return *token;

    return InternationalKeyCode::None;
}


static Locale& impl_getLocaleInstance( )
{
	static Locale s_aLocale( "en", "US", "" );
	return s_aLocale;
}


Locale OParseContext::getPreferredLocale( ) const
{
	return getDefaultLocale();
}


const Locale& OParseContext::getDefaultLocale()
{
	return impl_getLocaleInstance();
}

// The (unfortunately global) yylval for the handing over of
// values from the Scanner to the Parser. The global variable
// is only used for a short term, the Parser reads the variable
// immediately after the call of the Scanner into a same named own
// member variable.


OUString ConvertLikeToken(const OSQLParseNode* pTokenNode, const OSQLParseNode* pEscapeNode, bool bInternational)
{
	OUStringBuffer aMatchStr(0);
	if (pTokenNode->isToken())
	{
		sal_Unicode cEscape = 0;
		if (pEscapeNode->count())
			cEscape = pEscapeNode->getChild(1)->getTokenValue().toChar();

		// Change place holder
		aMatchStr = pTokenNode->getTokenValue();
		const sal_Int32 nLen = aMatchStr.getLength();
		OUStringBuffer sSearch,sReplace;
		if ( bInternational )
		{
		    sSearch.append("%_");
		    sReplace.append("*?");
		}
		else
		{
		    sSearch.append("*?");
		    sReplace.append("%_");
		}

		bool wasEscape = false;
		for (sal_Int32 i = 0; i < nLen; i++)
		{
			const sal_Unicode c = aMatchStr[i];
			// SQL standard requires the escape to be followed
			// by a meta-character ('%', '_' or itself), else error
			// We are more lenient here and let it escape anything.
			// Especially since some databases (e.g. Microsoft SQL Server)
			// have more meta-characters than the standard, such as e.g. '[' and ']'
			if (wasEscape)
			{
				wasEscape=false;
				continue;
			}
			if (c == cEscape)
			{
				wasEscape=true;
				continue;
			}
			int match = -1;
			if (c == sSearch[0])
				match=0;
			else if (c == sSearch[1])
				match=1;

			if (match != -1)
			{
				aMatchStr[i] = sReplace[match];
			}
		}
	}
	return aMatchStr.makeStringAndClear();
}

sal_uInt32			    OSQLParser::s_nRuleIDs[OSQLParseNode::rule_count + 1];
OSQLParser::RuleIDMap   OSQLParser::s_aReverseRuleIDLookup;
OParseContext		    OSQLParser::s_aDefaultContext;

sal_Int32			OSQLParser::s_nRefCount	= 0;
//	::osl::Mutex		OSQLParser::s_aMutex;
OSQLScanner*		OSQLParser::s_pScanner = nullptr;
OSQLParseNodesGarbageCollector*		OSQLParser::s_pGarbageCollector = nullptr;

void setParser(OSQLParser* _pParser)
{
	xxx_pGLOBAL_SQLPARSER = _pParser;
}

void OSQLParser::setParseTree(OSQLParseNode* pNewParseTree)
{
	m_pParseTree.reset(pNewParseTree);
}


/** Delete all comments in a query.

    See also getComment()/concatComment() implementation for
    OQueryController::translateStatement().
 */
static OUString delComment( const OUString& rQuery )
{
    // First a quick search if there is any "--" or "//" or "/*", if not then the whole
    // copying loop is pointless.
    if (rQuery.indexOf("--") < 0 && rQuery.indexOf("//") < 0 &&
            rQuery.indexOf("/*") < 0)
        return rQuery;

    const sal_Unicode* pCopy = rQuery.getStr();
    sal_Int32 nQueryLen = rQuery.getLength();
    bool bIsText1  = false;     // "text"
    bool bIsText2  = false;     // 'text'
    bool bComment2 = false;     // /* comment */
    bool bComment  = false;     // -- or // comment
    OUStringBuffer aBuf(nQueryLen);
    for (sal_Int32 i=0; i < nQueryLen; ++i)
    {
        if (bComment2)
        {
            if ((i+1) < nQueryLen)
            {
                if (pCopy[i]=='*' && pCopy[i+1]=='/')
                {
                    bComment2 = false;
                    ++i;
                }
            }
            else
            {
                // comment can't close anymore, actually an error, but...
            }
            continue;
        }
        if (pCopy[i] == '\n')
            bComment = false;
        else if (!bComment)
        {
            if (pCopy[i] == '\"' && !bIsText2)
                bIsText1 = !bIsText1;
            else if (pCopy[i] == '\'' && !bIsText1)
                bIsText2 = !bIsText2;
            if (!bIsText1 && !bIsText2 && (i+1) < nQueryLen)
            {
                if ((pCopy[i]=='-' && pCopy[i+1]=='-') || (pCopy[i]=='/' && pCopy[i+1]=='/'))
                    bComment = true;
                else if ((pCopy[i]=='/' && pCopy[i+1]=='*'))
                    bComment2 = true;
            }
        }
        if (!bComment && !bComment2)
            aBuf.append( &pCopy[i], 1);
    }
    return aBuf.makeStringAndClear();
}

std::unique_ptr<OSQLParseNode> OSQLParser::parseTree(OUString& rErrorMessage,
                                     const OUString& rStatement,
                                     bool bInternational)
{


	// Guard the parsing
	std::unique_lock aGuard(getMutex());
	// must be reset
	setParser(this);

	// delete comments before parsing
	OUString sTemp = delComment(rStatement);

	// defines how to scan
	s_pScanner->SetRule(OSQLScanner::GetSQLRule()); // initial
	s_pScanner->prepareScan(sTemp, m_pContext, bInternational);

	SQLyylval.pParseNode = nullptr;
	//	SQLyypvt = NULL;
	m_pParseTree = nullptr;
	m_sErrorMessage = "";

    // start parsing
	if (SQLyyparse() != 0)
	{
		// only set the error message, if it's not already set
		if (m_sErrorMessage.isEmpty())
			m_sErrorMessage = s_pScanner->getErrorMessage();
		if (m_sErrorMessage.isEmpty())
			m_sErrorMessage = m_pContext->getErrorMessage(IParseContext::ErrorCode::General);

		rErrorMessage = m_sErrorMessage;

		// clear the garbage collector
		(*s_pGarbageCollector)->clearAndDelete();
		// coverity[leaked_storage : FALSE] - because the garbage collector deleted it
		m_pParseTree.release();
		return nullptr;
	}
	else
	{
		(*s_pGarbageCollector)->clear();

        // return result:
        // to work around a bug in MKS YACC return the member m_pParseTree
        // instead of Sdbyyval.pParseNode

        SAL_WARN_IF(!m_pParseTree, "connectivity.parse",
            "OSQLParser: Parser did not create ParseTree");
		return std::move(m_pParseTree);
	}
}

OString OSQLParser::TokenIDToStr(sal_uInt32 nTokenID, const IParseContext* pContext)
{
	OString aStr;
	if (pContext)
	{
		IParseContext::InternationalKeyCode eKeyCode = IParseContext::InternationalKeyCode::None;
		switch( nTokenID )
		{
			case SQL_TOKEN_LIKE: eKeyCode = IParseContext::InternationalKeyCode::Like; break;
			case SQL_TOKEN_NOT: eKeyCode = IParseContext::InternationalKeyCode::Not; break;
			case SQL_TOKEN_NULL: eKeyCode = IParseContext::InternationalKeyCode::Null; break;
			case SQL_TOKEN_TRUE: eKeyCode = IParseContext::InternationalKeyCode::True; break;
			case SQL_TOKEN_FALSE: eKeyCode = IParseContext::InternationalKeyCode::False; break;
			case SQL_TOKEN_IS: eKeyCode = IParseContext::InternationalKeyCode::Is; break;
			case SQL_TOKEN_BETWEEN: eKeyCode = IParseContext::InternationalKeyCode::Between; break;
			case SQL_TOKEN_OR: eKeyCode = IParseContext::InternationalKeyCode::Or; break;
			case SQL_TOKEN_AND: eKeyCode = IParseContext::InternationalKeyCode::And; break;
			case SQL_TOKEN_AVG: eKeyCode = IParseContext::InternationalKeyCode::Avg; break;
			case SQL_TOKEN_COUNT: eKeyCode = IParseContext::InternationalKeyCode::Count; break;
			case SQL_TOKEN_MAX: eKeyCode = IParseContext::InternationalKeyCode::Max; break;
			case SQL_TOKEN_MIN: eKeyCode = IParseContext::InternationalKeyCode::Min; break;
			case SQL_TOKEN_SUM: eKeyCode = IParseContext::InternationalKeyCode::Sum; break;
		}
		if ( eKeyCode != IParseContext::InternationalKeyCode::None )
		    aStr = pContext->getIntlKeywordAscii(eKeyCode);
	}

	if (aStr.isEmpty())
	{
		// coverity[unsigned_compare : SUPPRESS] - YYTRANSLATE is out of our control
		aStr = yytname[YYTRANSLATE(nTokenID)];
		if(aStr.startsWith("SQL_TOKEN_"))
			aStr = aStr.copy(10);
		switch( nTokenID )
		{
			case SQL_TOKEN_OJ:
			case SQL_TOKEN_TS:
			case SQL_TOKEN_T:
			case SQL_TOKEN_D:
				aStr = aStr.toAsciiLowerCase();
		}
	}
	return aStr;
}

#if OSL_DEBUG_LEVEL > 0
OUString OSQLParser::RuleIDToStr(sal_uInt32 nRuleID)
{
    OSL_ENSURE(nRuleID < std::size(yytname), "OSQLParser::RuleIDToStr: Invalid nRuleId!");
	return OUString::createFromAscii(yytname[nRuleID]);
}
#endif


sal_uInt32 OSQLParser::StrToRuleID(const OString & rValue)
{
	// Search for the given name in yytname and return the index
	// (or UNKNOWN_RULE, if not found)
    static sal_uInt32 const nLen = std::size(yytname)-1;
    for (sal_uInt32 i = YYTRANSLATE(SQL_TOKEN_INVALIDSYMBOL); i < nLen; ++i)
	{
		if (rValue == yytname[i])
			return i;
	}

	// Not found
	return OSQLParseNode::UNKNOWN_RULE;
}


OSQLParseNode::Rule OSQLParser::RuleIDToRule( sal_uInt32 _nRule )
{
    OSQLParser::RuleIDMap::const_iterator i (s_aReverseRuleIDLookup.find(_nRule));
    if (i == s_aReverseRuleIDLookup.end())
    {
        SAL_INFO("connectivity.parse",
		 "connectivity::OSQLParser::RuleIDToRule cannot reverse-lookup rule. "
		 "Reverse mapping incomplete? "
		 "_nRule='" << _nRule << "' "
		 "yytname[_nRule]='" << yytname[_nRule] << "'");
        return OSQLParseNode::UNKNOWN_RULE;
    }
    else
        return i->second;
}


sal_uInt32 OSQLParser::RuleID(OSQLParseNode::Rule eRule)
{
	return s_nRuleIDs[(sal_uInt16)eRule];
}

sal_Int16 OSQLParser::buildNode(OSQLParseNode*& pAppend,OSQLParseNode* pCompare,OSQLParseNode* pLiteral,OSQLParseNode* pLiteral2)
{
	OSQLParseNode* pColumnRef = new OSQLInternalNode("", SQLNodeType::Rule,OSQLParser::RuleID(OSQLParseNode::column_ref));
	pColumnRef->append(new OSQLInternalNode(m_sFieldName,SQLNodeType::Name));
	OSQLParseNode* pComp = nullptr;
	if ( SQL_ISTOKEN( pCompare, BETWEEN) && pLiteral2 )
		pComp = new OSQLInternalNode("", SQLNodeType::Rule,OSQLParser::RuleID(OSQLParseNode::between_predicate_part_2));
	else
		pComp = new OSQLInternalNode("", SQLNodeType::Rule,OSQLParser::RuleID(OSQLParseNode::comparison_predicate));

	pComp->append(pColumnRef);
	pComp->append(pCompare);
	pComp->append(pLiteral);
	if ( pLiteral2 )
	{
		pComp->append(new OSQLInternalNode("", SQLNodeType::Keyword,SQL_TOKEN_AND));
		pComp->append(pLiteral2);
	}
	pAppend->append(pComp);
	return 1;
}

sal_Int16 OSQLParser::buildStringNodes(OSQLParseNode*& pLiteral)
{
	if(!pLiteral)
		return 1;

	if(SQL_ISRULE(pLiteral,set_fct_spec) || SQL_ISRULE(pLiteral,general_set_fct) || SQL_ISRULE(pLiteral,column_ref)
		|| SQL_ISRULE(pLiteral,subquery))
		return 1; // here I have a function that I can't transform into a string

	if(pLiteral->getNodeType() == SQLNodeType::IntNum || pLiteral->getNodeType() == SQLNodeType::ApproxNum || pLiteral->getNodeType() == SQLNodeType::AccessDate)
	{
		OSQLParseNode* pParent = pLiteral->getParent();

		OSQLParseNode* pNewNode = new OSQLInternalNode(pLiteral->getTokenValue(), SQLNodeType::String);
		pParent->replaceAndDelete(pLiteral, pNewNode);
		pLiteral = nullptr;
		return 1;
	}

	for(size_t i=0;i<pLiteral->count();++i)
	{
		OSQLParseNode* pChild = pLiteral->getChild(i);
		buildStringNodes(pChild);
	}
	if(SQL_ISRULE(pLiteral,term) || SQL_ISRULE(pLiteral,value_exp_primary))
	{
		m_sErrorMessage = m_pContext->getErrorMessage(IParseContext::ErrorCode::InvalidCompare);
		return 0;
	}
	return 1;
}

sal_Int16 OSQLParser::buildComparisonRule(OSQLParseNode*& pAppend,OSQLParseNode* pLiteral)
{
    OSQLParseNode* pComp = new OSQLInternalNode("=", SQLNodeType::Equal);
    return buildPredicateRule(pAppend,pLiteral,pComp);
}



void OSQLParser::reduceLiteral(OSQLParseNode*& pLiteral, bool bAppendBlank)
{
	OSL_ENSURE(pLiteral->isRule(), "This is no Rule");
	OSL_ENSURE(pLiteral->count() == 2, "OSQLParser::ReduceLiteral() Invalid count");
	OSQLParseNode* pTemp = pLiteral;
	OUStringBuffer aValue(pLiteral->getChild(0)->getTokenValue());
	if (bAppendBlank)
	{
		aValue.append(" ");
	}

	aValue.append(pLiteral->getChild(1)->getTokenValue());

	pLiteral = new OSQLInternalNode(aValue.makeStringAndClear(),SQLNodeType::String);
	delete pTemp;
}


void OSQLParser::error(const char *fmt)
{
	if(m_sErrorMessage.isEmpty())
	{
		OUString sStr(fmt,strlen(fmt),RTL_TEXTENCODING_UTF8);
		OUString sSQL_TOKEN("SQL_TOKEN_");

		sal_Int32 nPos1 = sStr.indexOf(sSQL_TOKEN);
		if(nPos1 != -1)
		{
			OUString sFirst  = sStr.copy(0,nPos1);
			sal_Int32 nPos2 = sStr.indexOf(sSQL_TOKEN,nPos1+1);
			if(nPos2 != -1)
			{
				sFirst += sStr.subView(nPos1+sSQL_TOKEN.getLength(),nPos2-nPos1-sSQL_TOKEN.getLength());
				sFirst  += sStr.subView(nPos2+sSQL_TOKEN.getLength());
			}
			else
				sFirst += sStr.subView(nPos1+sSQL_TOKEN.getLength());

			m_sErrorMessage = sFirst;
		}
		else
			m_sErrorMessage = sStr;

		OUString aError = s_pScanner->getErrorMessage();
		if(!aError.isEmpty())
		{
			m_sErrorMessage += ", ";
			m_sErrorMessage += aError;
		}
	}
}

int OSQLParser::SQLlex()
{
	return OSQLScanner::SQLlex();
}
