/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1


/* Substitute the variable and function names.  */
#define yyparse         libodraw_cue_scanner_parse
#define yylex           libodraw_cue_scanner_lex
#define yyerror         libodraw_cue_scanner_error
#define yydebug         libodraw_cue_scanner_debug
#define yynerrs         libodraw_cue_scanner_nerrs
#define yylval          libodraw_cue_scanner_lval
#define yychar          libodraw_cue_scanner_char

/* First part of user prologue.  */

/*
 * CUE parser functions
 *
 * Copyright (C) 2010-2024, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#include <common.h>
#include <narrow_string.h>
#include <types.h>

#if defined( HAVE_STDLIB_H ) || defined( WINAPI )
#include <stdlib.h>
#endif

#include "libodraw_definitions.h"
#include "libodraw_handle.h"
#include "libodraw_libcerror.h"
#include "libodraw_libcnotify.h"
#include "libodraw_types.h"

#define YYMALLOC	libodraw_cue_scanner_alloc
#define YYREALLOC	libodraw_cue_scanner_realloc
#define YYFREE		libodraw_cue_scanner_free

#define YYLEX_PARAM	NULL
#define YYPARSE_PARAM	parser_state

#if defined( HAVE_DEBUG_OUTPUT )
#define libodraw_cue_parser_rule_print( string ) \
	if( libcnotify_verbose != 0 ) libcnotify_printf( "libodraw_cue_parser: rule: %s\n", string )
#else
#define libodraw_cue_parser_rule_print( string )
#endif

#if !defined( CD_SECS )
/* seconds per minute */
#define CD_SECS			60
#endif

#if !defined( CD_FRAMES )
/* frames per second */
#define CD_FRAMES		75
#endif



# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Use api.header.include to #include this header
   instead of duplicating it here.  */
#ifndef YY_LIBODRAW_CUE_SCANNER_LIBODRAW_CUE_PARSER_H_INCLUDED
# define YY_LIBODRAW_CUE_SCANNER_LIBODRAW_CUE_PARSER_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int libodraw_cue_scanner_debug;
#endif

/* Token kinds.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    YYEMPTY = -2,
    YYEOF = 0,                     /* "end of file"  */
    YYerror = 256,                 /* error  */
    YYUNDEF = 257,                 /* "invalid token"  */
    CUE_END_OF_LINE = 258,         /* CUE_END_OF_LINE  */
    CUE_SEMI_COLON = 259,          /* CUE_SEMI_COLON  */
    CUE_2DIGIT = 260,              /* CUE_2DIGIT  */
    CUE_CATALOG_NUMBER = 261,      /* CUE_CATALOG_NUMBER  */
    CUE_ISRC_CODE = 262,           /* CUE_ISRC_CODE  */
    CUE_KEYWORD_STRING = 263,      /* CUE_KEYWORD_STRING  */
    CUE_MSF = 264,                 /* CUE_MSF  */
    CUE_STRING = 265,              /* CUE_STRING  */
    CUE_CATALOG = 266,             /* CUE_CATALOG  */
    CUE_CD_DA = 267,               /* CUE_CD_DA  */
    CUE_CD_ROM = 268,              /* CUE_CD_ROM  */
    CUE_CD_ROM_XA = 269,           /* CUE_CD_ROM_XA  */
    CUE_CD_TEXT = 270,             /* CUE_CD_TEXT  */
    CUE_CDTEXTFILE = 271,          /* CUE_CDTEXTFILE  */
    CUE_COPY = 272,                /* CUE_COPY  */
    CUE_DATAFILE = 273,            /* CUE_DATAFILE  */
    CUE_FLAGS = 274,               /* CUE_FLAGS  */
    CUE_FOUR_CHANNEL_AUDIO = 275,  /* CUE_FOUR_CHANNEL_AUDIO  */
    CUE_FILE = 276,                /* CUE_FILE  */
    CUE_INDEX = 277,               /* CUE_INDEX  */
    CUE_ISRC = 278,                /* CUE_ISRC  */
    CUE_NO_COPY = 279,             /* CUE_NO_COPY  */
    CUE_NO_PRE_EMPHASIS = 280,     /* CUE_NO_PRE_EMPHASIS  */
    CUE_POSTGAP = 281,             /* CUE_POSTGAP  */
    CUE_PRE_EMPHASIS = 282,        /* CUE_PRE_EMPHASIS  */
    CUE_PREGAP = 283,              /* CUE_PREGAP  */
    CUE_REMARK = 284,              /* CUE_REMARK  */
    CUE_TRACK = 285,               /* CUE_TRACK  */
    CUE_TWO_CHANNEL_AUDIO = 286,   /* CUE_TWO_CHANNEL_AUDIO  */
    CUE_CDTEXT_ARRANGER = 287,     /* CUE_CDTEXT_ARRANGER  */
    CUE_CDTEXT_COMPOSER = 288,     /* CUE_CDTEXT_COMPOSER  */
    CUE_CDTEXT_DISC_ID = 289,      /* CUE_CDTEXT_DISC_ID  */
    CUE_CDTEXT_GENRE = 290,        /* CUE_CDTEXT_GENRE  */
    CUE_CDTEXT_MESSAGE = 291,      /* CUE_CDTEXT_MESSAGE  */
    CUE_CDTEXT_PERFORMER = 292,    /* CUE_CDTEXT_PERFORMER  */
    CUE_CDTEXT_SIZE_INFO = 293,    /* CUE_CDTEXT_SIZE_INFO  */
    CUE_CDTEXT_SONGWRITER = 294,   /* CUE_CDTEXT_SONGWRITER  */
    CUE_CDTEXT_TITLE = 295,        /* CUE_CDTEXT_TITLE  */
    CUE_CDTEXT_TOC_INFO1 = 296,    /* CUE_CDTEXT_TOC_INFO1  */
    CUE_CDTEXT_TOC_INFO2 = 297,    /* CUE_CDTEXT_TOC_INFO2  */
    CUE_CDTEXT_UPC_EAN = 298,      /* CUE_CDTEXT_UPC_EAN  */
    CUE_REMARK_LEAD_OUT = 299,     /* CUE_REMARK_LEAD_OUT  */
    CUE_REMARK_ORIGINAL_MEDIA_TYPE = 300, /* CUE_REMARK_ORIGINAL_MEDIA_TYPE  */
    CUE_REMARK_RUN_OUT = 301,      /* CUE_REMARK_RUN_OUT  */
    CUE_REMARK_SESSION = 302,      /* CUE_REMARK_SESSION  */
    CUE_UNDEFINED = 303            /* CUE_UNDEFINED  */
  };
  typedef enum yytokentype yytoken_kind_t;
#endif
/* Token kinds.  */
#define YYEMPTY -2
#define YYEOF 0
#define YYerror 256
#define YYUNDEF 257
#define CUE_END_OF_LINE 258
#define CUE_SEMI_COLON 259
#define CUE_2DIGIT 260
#define CUE_CATALOG_NUMBER 261
#define CUE_ISRC_CODE 262
#define CUE_KEYWORD_STRING 263
#define CUE_MSF 264
#define CUE_STRING 265
#define CUE_CATALOG 266
#define CUE_CD_DA 267
#define CUE_CD_ROM 268
#define CUE_CD_ROM_XA 269
#define CUE_CD_TEXT 270
#define CUE_CDTEXTFILE 271
#define CUE_COPY 272
#define CUE_DATAFILE 273
#define CUE_FLAGS 274
#define CUE_FOUR_CHANNEL_AUDIO 275
#define CUE_FILE 276
#define CUE_INDEX 277
#define CUE_ISRC 278
#define CUE_NO_COPY 279
#define CUE_NO_PRE_EMPHASIS 280
#define CUE_POSTGAP 281
#define CUE_PRE_EMPHASIS 282
#define CUE_PREGAP 283
#define CUE_REMARK 284
#define CUE_TRACK 285
#define CUE_TWO_CHANNEL_AUDIO 286
#define CUE_CDTEXT_ARRANGER 287
#define CUE_CDTEXT_COMPOSER 288
#define CUE_CDTEXT_DISC_ID 289
#define CUE_CDTEXT_GENRE 290
#define CUE_CDTEXT_MESSAGE 291
#define CUE_CDTEXT_PERFORMER 292
#define CUE_CDTEXT_SIZE_INFO 293
#define CUE_CDTEXT_SONGWRITER 294
#define CUE_CDTEXT_TITLE 295
#define CUE_CDTEXT_TOC_INFO1 296
#define CUE_CDTEXT_TOC_INFO2 297
#define CUE_CDTEXT_UPC_EAN 298
#define CUE_REMARK_LEAD_OUT 299
#define CUE_REMARK_ORIGINAL_MEDIA_TYPE 300
#define CUE_REMARK_RUN_OUT 301
#define CUE_REMARK_SESSION 302
#define CUE_UNDEFINED 303

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
union YYSTYPE
{

        /* The numeric value
         */
        uint32_t numeric_value;

        /* The string value
         */
	struct cue_string_value
	{
		/* The string data
		 */
	        const char *data;

		/* The string length
		 */
		size_t length;

	} string_value;


};
typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif


extern YYSTYPE libodraw_cue_scanner_lval;


int libodraw_cue_scanner_parse (void *parser_state);


#endif /* !YY_LIBODRAW_CUE_SCANNER_LIBODRAW_CUE_PARSER_H_INCLUDED  */
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_CUE_END_OF_LINE = 3,            /* CUE_END_OF_LINE  */
  YYSYMBOL_CUE_SEMI_COLON = 4,             /* CUE_SEMI_COLON  */
  YYSYMBOL_CUE_2DIGIT = 5,                 /* CUE_2DIGIT  */
  YYSYMBOL_CUE_CATALOG_NUMBER = 6,         /* CUE_CATALOG_NUMBER  */
  YYSYMBOL_CUE_ISRC_CODE = 7,              /* CUE_ISRC_CODE  */
  YYSYMBOL_CUE_KEYWORD_STRING = 8,         /* CUE_KEYWORD_STRING  */
  YYSYMBOL_CUE_MSF = 9,                    /* CUE_MSF  */
  YYSYMBOL_CUE_STRING = 10,                /* CUE_STRING  */
  YYSYMBOL_CUE_CATALOG = 11,               /* CUE_CATALOG  */
  YYSYMBOL_CUE_CD_DA = 12,                 /* CUE_CD_DA  */
  YYSYMBOL_CUE_CD_ROM = 13,                /* CUE_CD_ROM  */
  YYSYMBOL_CUE_CD_ROM_XA = 14,             /* CUE_CD_ROM_XA  */
  YYSYMBOL_CUE_CD_TEXT = 15,               /* CUE_CD_TEXT  */
  YYSYMBOL_CUE_CDTEXTFILE = 16,            /* CUE_CDTEXTFILE  */
  YYSYMBOL_CUE_COPY = 17,                  /* CUE_COPY  */
  YYSYMBOL_CUE_DATAFILE = 18,              /* CUE_DATAFILE  */
  YYSYMBOL_CUE_FLAGS = 19,                 /* CUE_FLAGS  */
  YYSYMBOL_CUE_FOUR_CHANNEL_AUDIO = 20,    /* CUE_FOUR_CHANNEL_AUDIO  */
  YYSYMBOL_CUE_FILE = 21,                  /* CUE_FILE  */
  YYSYMBOL_CUE_INDEX = 22,                 /* CUE_INDEX  */
  YYSYMBOL_CUE_ISRC = 23,                  /* CUE_ISRC  */
  YYSYMBOL_CUE_NO_COPY = 24,               /* CUE_NO_COPY  */
  YYSYMBOL_CUE_NO_PRE_EMPHASIS = 25,       /* CUE_NO_PRE_EMPHASIS  */
  YYSYMBOL_CUE_POSTGAP = 26,               /* CUE_POSTGAP  */
  YYSYMBOL_CUE_PRE_EMPHASIS = 27,          /* CUE_PRE_EMPHASIS  */
  YYSYMBOL_CUE_PREGAP = 28,                /* CUE_PREGAP  */
  YYSYMBOL_CUE_REMARK = 29,                /* CUE_REMARK  */
  YYSYMBOL_CUE_TRACK = 30,                 /* CUE_TRACK  */
  YYSYMBOL_CUE_TWO_CHANNEL_AUDIO = 31,     /* CUE_TWO_CHANNEL_AUDIO  */
  YYSYMBOL_CUE_CDTEXT_ARRANGER = 32,       /* CUE_CDTEXT_ARRANGER  */
  YYSYMBOL_CUE_CDTEXT_COMPOSER = 33,       /* CUE_CDTEXT_COMPOSER  */
  YYSYMBOL_CUE_CDTEXT_DISC_ID = 34,        /* CUE_CDTEXT_DISC_ID  */
  YYSYMBOL_CUE_CDTEXT_GENRE = 35,          /* CUE_CDTEXT_GENRE  */
  YYSYMBOL_CUE_CDTEXT_MESSAGE = 36,        /* CUE_CDTEXT_MESSAGE  */
  YYSYMBOL_CUE_CDTEXT_PERFORMER = 37,      /* CUE_CDTEXT_PERFORMER  */
  YYSYMBOL_CUE_CDTEXT_SIZE_INFO = 38,      /* CUE_CDTEXT_SIZE_INFO  */
  YYSYMBOL_CUE_CDTEXT_SONGWRITER = 39,     /* CUE_CDTEXT_SONGWRITER  */
  YYSYMBOL_CUE_CDTEXT_TITLE = 40,          /* CUE_CDTEXT_TITLE  */
  YYSYMBOL_CUE_CDTEXT_TOC_INFO1 = 41,      /* CUE_CDTEXT_TOC_INFO1  */
  YYSYMBOL_CUE_CDTEXT_TOC_INFO2 = 42,      /* CUE_CDTEXT_TOC_INFO2  */
  YYSYMBOL_CUE_CDTEXT_UPC_EAN = 43,        /* CUE_CDTEXT_UPC_EAN  */
  YYSYMBOL_CUE_REMARK_LEAD_OUT = 44,       /* CUE_REMARK_LEAD_OUT  */
  YYSYMBOL_CUE_REMARK_ORIGINAL_MEDIA_TYPE = 45, /* CUE_REMARK_ORIGINAL_MEDIA_TYPE  */
  YYSYMBOL_CUE_REMARK_RUN_OUT = 46,        /* CUE_REMARK_RUN_OUT  */
  YYSYMBOL_CUE_REMARK_SESSION = 47,        /* CUE_REMARK_SESSION  */
  YYSYMBOL_CUE_UNDEFINED = 48,             /* CUE_UNDEFINED  */
  YYSYMBOL_YYACCEPT = 49,                  /* $accept  */
  YYSYMBOL_cue_main = 50,                  /* cue_main  */
  YYSYMBOL_cue_header_item = 51,           /* cue_header_item  */
  YYSYMBOL_cue_session_type = 52,          /* cue_session_type  */
  YYSYMBOL_cue_main_items = 53,            /* cue_main_items  */
  YYSYMBOL_cue_main_item = 54,             /* cue_main_item  */
  YYSYMBOL_cue_main_tracks = 55,           /* cue_main_tracks  */
  YYSYMBOL_cue_main_track = 56,            /* cue_main_track  */
  YYSYMBOL_cue_main_track_preceding_items = 57, /* cue_main_track_preceding_items  */
  YYSYMBOL_cue_main_track_preceding_item = 58, /* cue_main_track_preceding_item  */
  YYSYMBOL_cue_main_track_leading_items = 59, /* cue_main_track_leading_items  */
  YYSYMBOL_cue_main_track_leading_item = 60, /* cue_main_track_leading_item  */
  YYSYMBOL_cue_main_track_index_items = 61, /* cue_main_track_index_items  */
  YYSYMBOL_cue_main_track_index_item = 62, /* cue_main_track_index_item  */
  YYSYMBOL_cue_main_track_trailing_items = 63, /* cue_main_track_trailing_items  */
  YYSYMBOL_cue_main_track_trailing_item = 64, /* cue_main_track_trailing_item  */
  YYSYMBOL_cue_catalog = 65,               /* cue_catalog  */
  YYSYMBOL_cue_cdtext = 66,                /* cue_cdtext  */
  YYSYMBOL_cue_cdtext_type = 67,           /* cue_cdtext_type  */
  YYSYMBOL_cue_cd_da = 68,                 /* cue_cd_da  */
  YYSYMBOL_cue_cd_rom = 69,                /* cue_cd_rom  */
  YYSYMBOL_cue_cd_rom_xa = 70,             /* cue_cd_rom_xa  */
  YYSYMBOL_cue_cdtextfile = 71,            /* cue_cdtextfile  */
  YYSYMBOL_cue_file = 72,                  /* cue_file  */
  YYSYMBOL_cue_flags = 73,                 /* cue_flags  */
  YYSYMBOL_cue_flags_types = 74,           /* cue_flags_types  */
  YYSYMBOL_cue_index = 75,                 /* cue_index  */
  YYSYMBOL_cue_copy = 76,                  /* cue_copy  */
  YYSYMBOL_cue_datafile = 77,              /* cue_datafile  */
  YYSYMBOL_cue_four_channel_audio = 78,    /* cue_four_channel_audio  */
  YYSYMBOL_cue_isrc = 79,                  /* cue_isrc  */
  YYSYMBOL_cue_no_copy = 80,               /* cue_no_copy  */
  YYSYMBOL_cue_no_pre_emphasis = 81,       /* cue_no_pre_emphasis  */
  YYSYMBOL_cue_postgap = 82,               /* cue_postgap  */
  YYSYMBOL_cue_pre_emphasis = 83,          /* cue_pre_emphasis  */
  YYSYMBOL_cue_pregap = 84,                /* cue_pregap  */
  YYSYMBOL_cue_two_channel_audio = 85,     /* cue_two_channel_audio  */
  YYSYMBOL_cue_remark_item = 86,           /* cue_remark_item  */
  YYSYMBOL_cue_lead_out = 87,              /* cue_lead_out  */
  YYSYMBOL_cue_original_media_type = 88,   /* cue_original_media_type  */
  YYSYMBOL_cue_remark = 89,                /* cue_remark  */
  YYSYMBOL_cue_remark_start = 90,          /* cue_remark_start  */
  YYSYMBOL_cue_run_out = 91,               /* cue_run_out  */
  YYSYMBOL_cue_session = 92,               /* cue_session  */
  YYSYMBOL_cue_track = 93,                 /* cue_track  */
  YYSYMBOL_cue_empty_line = 94             /* cue_empty_line  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;


/* Second part of user prologue.  */


typedef struct libodraw_cue_parser_state libodraw_cue_parser_state_t;

struct libodraw_cue_parser_state
{
	/* The file
	 */
	libodraw_handle_t *handle;

	/* The error
	 */
	libcerror_error_t **error;

	/* The previous file index
	 */
	int previous_file_index;

	/* The current file index
	 */
	int current_file_index;

	/* The file type
	 */
	uint8_t file_type;

	/* Value to indicate a new file command was issued
	 */
	uint8_t new_file;

	/* The previous file sector
	 */
	uint64_t previous_file_sector;

	/* The file sector
	 */
	uint64_t file_sector;

	/* The previous session start sector
	 */
	uint64_t previous_session_start_sector;

	/* The previous lead-out start sector
	 */
	uint64_t previous_lead_out_start_sector;

	/* The previous track start sector
	 */
	uint64_t previous_track_start_sector;

	/* The current start sector
	 */
	uint64_t current_start_sector;

	/* The session number of sectors
	 */
	uint64_t session_number_of_sectors;

	/* The lead-out number of sectors
	 */
	uint64_t lead_out_number_of_sectors;

	/* The track number of sectors
	 */
	uint64_t track_number_of_sectors;

	/* The previous track type
	 */
	uint8_t previous_track_type;

	/* The current track type
	 */
	uint8_t current_track_type;

	/* The previous session
	 */
	int previous_session;

	/* The current session
	 */
	int current_session;

	/* The previous lead-out
	 */
	int previous_lead_out;

	/* The current lead-out
	 */
	int current_lead_out;

	/* The previous track
	 */
	int previous_track;

	/* The current track
	 */
	int current_track;

	/* The previous index
	 */
	int previous_index;

	/* The current index
	 */
	int current_index;
};

typedef size_t yy_size_t;
typedef struct yy_buffer_state* YY_BUFFER_STATE;

extern \
int libodraw_cue_scanner_suppress_error;

extern \
int libodraw_cue_scanner_lex_destroy(
     void );

extern \
void *libodraw_cue_scanner_alloc(
       yy_size_t size );

extern \
void *libodraw_cue_scanner_realloc(
       void *buffer,
       yy_size_t size );

extern \
void libodraw_cue_scanner_free(
      void *buffer );

extern \
int libodraw_cue_scanner_lex(
     void *user_data );

extern \
void libodraw_cue_scanner_error(
      void *parser_state,
      const char *error_string );

extern \
YY_BUFFER_STATE libodraw_cue_scanner__scan_buffer(
                 char *buffer,
                 yy_size_t buffer_size );

extern \
void libodraw_cue_scanner__delete_buffer(
      YY_BUFFER_STATE buffer_state );

extern \
size_t libodraw_cue_scanner_buffer_offset;

static char *libodraw_cue_parser_function = "libodraw_cue_parser";

int libodraw_cue_parser_parse_number(
     const char *token,
     size_t token_size,
     int *number,
     libcerror_error_t **error );

int libodraw_cue_parser_parse_msf(
     const char *token,
     size_t token_size,
     uint64_t *lba,
     libcerror_error_t **error );

int libodraw_cue_parser_parse_track_type(
     const char *token,
     size_t token_size,
     uint8_t *track_type,
     libcerror_error_t **error );

int libodraw_cue_parser_parse_buffer(
     libodraw_handle_t *handle,
     const uint8_t *buffer,
     size_t buffer_size,
     libcerror_error_t **error );




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_uint8 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  6
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   260

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  49
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  46
/* YYNRULES -- Number of rules.  */
#define YYNRULES  96
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  152

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   303


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   343,   343,   344,   348,   349,   353,   354,   355,   356,
     360,   361,   366,   367,   368,   369,   373,   374,   378,   382,
     383,   387,   388,   389,   393,   394,   398,   399,   400,   401,
     402,   403,   407,   408,   412,   413,   414,   418,   419,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     438,   446,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   470,   478,   486,   494,   502,   599,
     607,   608,   612,   808,   816,   897,   905,   913,   921,   929,
     937,   945,   953,   961,   962,   963,   964,   965,   969,  1010,
    1018,  1028,  1038,  1078,  1116,  1152,  1209
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "CUE_END_OF_LINE",
  "CUE_SEMI_COLON", "CUE_2DIGIT", "CUE_CATALOG_NUMBER", "CUE_ISRC_CODE",
  "CUE_KEYWORD_STRING", "CUE_MSF", "CUE_STRING", "CUE_CATALOG",
  "CUE_CD_DA", "CUE_CD_ROM", "CUE_CD_ROM_XA", "CUE_CD_TEXT",
  "CUE_CDTEXTFILE", "CUE_COPY", "CUE_DATAFILE", "CUE_FLAGS",
  "CUE_FOUR_CHANNEL_AUDIO", "CUE_FILE", "CUE_INDEX", "CUE_ISRC",
  "CUE_NO_COPY", "CUE_NO_PRE_EMPHASIS", "CUE_POSTGAP", "CUE_PRE_EMPHASIS",
  "CUE_PREGAP", "CUE_REMARK", "CUE_TRACK", "CUE_TWO_CHANNEL_AUDIO",
  "CUE_CDTEXT_ARRANGER", "CUE_CDTEXT_COMPOSER", "CUE_CDTEXT_DISC_ID",
  "CUE_CDTEXT_GENRE", "CUE_CDTEXT_MESSAGE", "CUE_CDTEXT_PERFORMER",
  "CUE_CDTEXT_SIZE_INFO", "CUE_CDTEXT_SONGWRITER", "CUE_CDTEXT_TITLE",
  "CUE_CDTEXT_TOC_INFO1", "CUE_CDTEXT_TOC_INFO2", "CUE_CDTEXT_UPC_EAN",
  "CUE_REMARK_LEAD_OUT", "CUE_REMARK_ORIGINAL_MEDIA_TYPE",
  "CUE_REMARK_RUN_OUT", "CUE_REMARK_SESSION", "CUE_UNDEFINED", "$accept",
  "cue_main", "cue_header_item", "cue_session_type", "cue_main_items",
  "cue_main_item", "cue_main_tracks", "cue_main_track",
  "cue_main_track_preceding_items", "cue_main_track_preceding_item",
  "cue_main_track_leading_items", "cue_main_track_leading_item",
  "cue_main_track_index_items", "cue_main_track_index_item",
  "cue_main_track_trailing_items", "cue_main_track_trailing_item",
  "cue_catalog", "cue_cdtext", "cue_cdtext_type", "cue_cd_da",
  "cue_cd_rom", "cue_cd_rom_xa", "cue_cdtextfile", "cue_file", "cue_flags",
  "cue_flags_types", "cue_index", "cue_copy", "cue_datafile",
  "cue_four_channel_audio", "cue_isrc", "cue_no_copy",
  "cue_no_pre_emphasis", "cue_postgap", "cue_pre_emphasis", "cue_pregap",
  "cue_two_channel_audio", "cue_remark_item", "cue_lead_out",
  "cue_original_media_type", "cue_remark", "cue_remark_start",
  "cue_run_out", "cue_session", "cue_track", "cue_empty_line", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-79)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-20)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
      -4,     3,    10,    96,   -79,    18,   -79,   -79,    20,    27,
      28,    29,   -79,   -79,   -79,   -79,   -79,   -79,   -79,   -79,
     -79,   -79,   -79,   -79,   -79,     4,    30,    31,    36,   186,
      34,   186,   -79,    38,   -79,   -79,   -79,   -79,   -79,   -79,
     -79,   -79,    50,   -79,   -79,   -79,   -79,   -79,   -79,   -79,
      53,    58,    59,    60,    61,    -1,    55,   186,   -79,    63,
      64,   -79,   -79,   -79,   -79,   -79,   -79,    -1,    42,   213,
     -79,   -79,   -79,    66,    -1,   -79,   -79,   -79,     0,   141,
     -79,    76,   -79,    73,    97,    93,    95,    94,    13,   141,
     -79,   -79,   -79,   -79,   -79,   -79,   -79,   101,   -79,    93,
     102,   103,   104,   106,    51,    13,   -79,   -79,   -79,   -79,
     -79,   -79,   -79,   -79,   -79,   105,   110,   107,   112,   113,
     115,   111,   116,   118,   -79,    51,   -79,   -79,   -79,   -79,
     -79,   -79,   -79,   -79,   -79,   -79,   -79,   -79,   119,   -79,
     114,   -79,   -79,   -79,   121,   -79,   -79,   -79,   -79,   123,
     -79,   -79
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int8 yydefact[] =
{
       4,     0,     0,     6,     5,     0,     1,    96,     0,     0,
       0,     0,    91,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,     0,     0,     0,     0,    10,
       0,    10,    13,     0,     7,     8,     9,    12,    14,    83,
      84,    85,     0,    86,    87,    15,    50,    64,    65,    66,
       0,     0,     0,     0,     0,    16,     0,    10,    11,     0,
       0,    67,    88,    89,    92,    93,     2,    16,     0,    19,
      21,    22,    23,     0,    16,    51,    90,    17,     0,    24,
      20,     0,     3,     0,     0,    70,     0,     0,    32,    24,
      26,    27,    28,    29,    30,    31,    68,     0,    94,    70,
       0,     0,     0,     0,    37,    32,    34,    35,    36,    25,
      95,    71,    69,    76,    81,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    18,    37,    39,    40,    41,    42,
      43,    44,    45,    46,    47,    48,    49,    33,     0,    73,
       0,    75,    77,    78,     0,    80,    82,    38,    72,     0,
      79,    74
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int8 yypgoto[] =
{
     -79,   -79,   -79,   -79,   -25,   -79,   -49,   -79,    77,   -79,
      56,   -79,    22,   -79,    23,   -79,   -79,   -78,   -79,   -79,
     -79,   -79,   -79,   117,   -79,    52,   -79,   -79,   -79,   -79,
     -79,   -79,   -79,   -79,   -79,   -79,   -79,   -55,   -79,   -79,
     -79,   -79,   -79,   -79,   -79,   -52
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_uint8 yydefgoto[] =
{
       0,     2,     3,    29,    30,    31,    66,    67,    68,    69,
      88,    89,   104,   105,   124,   125,     4,    32,    33,    34,
      35,    36,    37,    70,    91,   100,   106,   127,   128,   129,
      92,   130,   131,   132,   133,    93,   134,    38,    39,    40,
      41,    42,    43,    44,    79,    45
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      71,    90,     7,    72,    55,    83,    58,     1,    84,     5,
       6,    90,    71,    51,    71,    72,     7,    72,    77,    71,
      56,    46,    72,    47,    94,    82,   126,    95,    12,   -19,
      48,    49,    74,   107,    94,   103,   108,    95,    52,    50,
      53,    54,    12,    25,    26,    27,    28,   126,    59,   135,
     107,    60,   136,   108,     7,    56,    61,    25,    26,    27,
      28,    62,    63,    64,    65,    73,    75,    76,   116,   117,
     135,   118,    78,   136,    81,   119,   120,   121,   122,    96,
      12,    97,   123,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,     7,
      98,    99,   101,   102,   110,   112,   113,   114,     8,     9,
      10,   115,    11,   139,   138,   141,   142,   140,   143,   145,
     144,   146,   148,   149,   150,    12,   151,   137,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,     7,   109,    80,    57,   147,     0,
       0,   111,     0,     0,     0,     0,     0,     0,     0,     0,
      85,     0,     0,     0,    86,     0,     0,     0,     0,    87,
      12,     0,     0,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,     7,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    11,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    12,     7,     0,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    56,     0,     0,     0,     0,     0,
       0,     0,    12,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    25,    26,    27,
      28
};

static const yytype_int8 yycheck[] =
{
      55,    79,     3,    55,    29,     5,    31,    11,     8,     6,
       0,    89,    67,     9,    69,    67,     3,    69,    67,    74,
      21,     3,    74,     3,    79,    74,   104,    79,    29,    30,
       3,     3,    57,    88,    89,    22,    88,    89,     8,    10,
       9,     5,    29,    44,    45,    46,    47,   125,    10,   104,
     105,     1,   104,   105,     3,    21,     3,    44,    45,    46,
      47,     3,     3,     3,     3,    10,     3,     3,    17,    18,
     125,    20,    30,   125,     8,    24,    25,    26,    27,     3,
      29,     8,    31,    32,    33,    34,    35,    36,    37,    38,
      39,    40,    41,    42,    43,    44,    45,    46,    47,     3,
       3,     8,     7,     9,     3,     3,     3,     3,    12,    13,
      14,     5,    16,     3,     9,     3,     3,    10,     3,     3,
       9,     3,     3,     9,     3,    29,     3,   105,    32,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    42,    43,
      44,    45,    46,    47,     3,    89,    69,    30,   125,    -1,
      -1,    99,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      19,    -1,    -1,    -1,    23,    -1,    -1,    -1,    -1,    28,
      29,    -1,    -1,    32,    33,    34,    35,    36,    37,    38,
      39,    40,    41,    42,    43,    44,    45,    46,    47,     3,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    16,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    29,     3,    -1,    32,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    42,    43,
      44,    45,    46,    47,    21,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    44,    45,    46,
      47
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int8 yystos[] =
{
       0,    11,    50,    51,    65,     6,     0,     3,    12,    13,
      14,    16,    29,    32,    33,    34,    35,    36,    37,    38,
      39,    40,    41,    42,    43,    44,    45,    46,    47,    52,
      53,    54,    66,    67,    68,    69,    70,    71,    86,    87,
      88,    89,    90,    91,    92,    94,     3,     3,     3,     3,
      10,     9,     8,     9,     5,    53,    21,    72,    53,    10,
       1,     3,     3,     3,     3,     3,    55,    56,    57,    58,
      72,    86,    94,    10,    53,     3,     3,    55,    30,    93,
      57,     8,    55,     5,     8,    19,    23,    28,    59,    60,
      66,    73,    79,    84,    86,    94,     3,     8,     3,     8,
      74,     7,     9,    22,    61,    62,    75,    86,    94,    59,
       3,    74,     3,     3,     3,     5,    17,    18,    20,    24,
      25,    26,    27,    31,    63,    64,    66,    76,    77,    78,
      80,    81,    82,    83,    85,    86,    94,    61,     9,     3,
      10,     3,     3,     3,     9,     3,     3,    63,     3,     9,
       3,     3
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr1[] =
{
       0,    49,    50,    50,    51,    51,    52,    52,    52,    52,
      53,    53,    54,    54,    54,    54,    55,    55,    56,    57,
      57,    58,    58,    58,    59,    59,    60,    60,    60,    60,
      60,    60,    61,    61,    62,    62,    62,    63,    63,    64,
      64,    64,    64,    64,    64,    64,    64,    64,    64,    64,
      65,    66,    67,    67,    67,    67,    67,    67,    67,    67,
      67,    67,    67,    67,    68,    69,    70,    71,    72,    73,
      74,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    86,    86,    86,    86,    87,    88,
      89,    90,    91,    92,    93,    93,    94
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     4,     5,     0,     1,     0,     1,     1,     1,
       0,     2,     1,     1,     1,     1,     0,     2,     5,     0,
       2,     1,     1,     1,     0,     2,     1,     1,     1,     1,
       1,     1,     0,     2,     1,     1,     1,     0,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     2,     2,     3,     4,     3,
       0,     2,     4,     2,     4,     2,     3,     2,     2,     3,
       2,     3,     2,     1,     1,     1,     1,     1,     3,     3,
       3,     1,     3,     3,     3,     4,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (parser_state, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, parser_state); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, void *parser_state)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (parser_state);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, void *parser_state)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep, parser_state);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule, void *parser_state)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)], parser_state);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule, parser_state); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, void *parser_state)
{
  YY_USE (yyvaluep);
  YY_USE (parser_state);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void *parser_state)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (NULL);
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 50: /* cue_catalog: CUE_CATALOG CUE_CATALOG_NUMBER CUE_END_OF_LINE  */
        {
		libodraw_cue_parser_rule_print(
		 "cue_catalog" );
	}
    break;

  case 51: /* cue_cdtext: cue_cdtext_type CUE_STRING CUE_END_OF_LINE  */
        {
		libodraw_cue_parser_rule_print(
		 "cue_cdtext" );
	}
    break;

  case 64: /* cue_cd_da: CUE_CD_DA CUE_END_OF_LINE  */
        {
		libodraw_cue_parser_rule_print(
		 "cue_cd_da" );
	}
    break;

  case 65: /* cue_cd_rom: CUE_CD_ROM CUE_END_OF_LINE  */
        {
		libodraw_cue_parser_rule_print(
		 "cue_cd_rom" );
	}
    break;

  case 66: /* cue_cd_rom_xa: CUE_CD_ROM_XA CUE_END_OF_LINE  */
        {
		libodraw_cue_parser_rule_print(
		 "cue_cd_rom_xa" );
	}
    break;

  case 67: /* cue_cdtextfile: CUE_CDTEXTFILE CUE_STRING CUE_END_OF_LINE  */
        {
		libodraw_cue_parser_rule_print(
		 "cue_cdtextfile" );
	}
    break;

  case 68: /* cue_file: CUE_FILE CUE_STRING CUE_KEYWORD_STRING CUE_END_OF_LINE  */
        {
		libodraw_cue_parser_rule_print(
		 "cue_file" );

		if( (yyvsp[-2].string_value).data == NULL )
		{
			libcerror_error_set(
			 ( (libodraw_cue_parser_state_t *) parser_state )->error,
			 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
			 LIBCERROR_ARGUMENT_ERROR_INVALID_VALUE,
			 "%s: invalid filename.",
			 libodraw_cue_parser_function );

			YYABORT;
		}
		if( (yyvsp[-1].string_value).data == NULL )
		{
			libcerror_error_set(
			 ( (libodraw_cue_parser_state_t *) parser_state )->error,
			 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
			 LIBCERROR_ARGUMENT_ERROR_INVALID_VALUE,
			 "%s: invalid file type.",
			 libodraw_cue_parser_function );

			YYABORT;
		}
		( (libodraw_cue_parser_state_t *) parser_state )->file_type = LIBODRAW_FILE_TYPE_UNKNOWN;

		if( (yyvsp[-1].string_value).length == 3 )
		{
			if( narrow_string_compare(
			     (yyvsp[-1].string_value).data,
			     "MP3",
			     3 ) == 0 )
			{
				( (libodraw_cue_parser_state_t *) parser_state )->file_type = LIBODRAW_FILE_TYPE_AUDIO_MPEG1_LAYER3;
			}
		}
		else if( (yyvsp[-1].string_value).length == 4 )
		{
			if( narrow_string_compare(
			     (yyvsp[-1].string_value).data,
			     "AIFF",
			     4 ) == 0 )
			{
				( (libodraw_cue_parser_state_t *) parser_state )->file_type = LIBODRAW_FILE_TYPE_AUDIO_AIFF;
			}
			else if( narrow_string_compare(
			          (yyvsp[-1].string_value).data,
			          "WAVE",
			          4 ) == 0 )
			{
				( (libodraw_cue_parser_state_t *) parser_state )->file_type = LIBODRAW_FILE_TYPE_AUDIO_WAVE;
			}
		}
		else if( (yyvsp[-1].string_value).length == 6 )
		{
			if( narrow_string_compare(
			     (yyvsp[-1].string_value).data,
			     "BINARY",
			     6 ) == 0 )
			{
				( (libodraw_cue_parser_state_t *) parser_state )->file_type = LIBODRAW_FILE_TYPE_BINARY_LITTLE_ENDIAN;
			}
		}
		else if( (yyvsp[-1].string_value).length == 8 )
		{
			if( narrow_string_compare(
			     (yyvsp[-1].string_value).data,
			     "MOTOROLA",
			     8 ) == 0 )
			{
				( (libodraw_cue_parser_state_t *) parser_state )->file_type = LIBODRAW_FILE_TYPE_BINARY_BIG_ENDIAN;
			}
		}
		if( libodraw_handle_append_data_file(
		     ( (libodraw_cue_parser_state_t *) parser_state )->handle,
		     (yyvsp[-2].string_value).data,
		     (yyvsp[-2].string_value).length,
		     ( (libodraw_cue_parser_state_t *) parser_state )->file_type,
		     ( (libodraw_cue_parser_state_t *) parser_state )->error ) != 1 )
		{
			libcerror_error_set(
			 ( (libodraw_cue_parser_state_t *) parser_state )->error,
			 LIBCERROR_ERROR_DOMAIN_RUNTIME,
			 LIBCERROR_RUNTIME_ERROR_APPEND_FAILED,
			 "%s: unable to append data file.",
			 libodraw_cue_parser_function );

			YYABORT;
		}
		( (libodraw_cue_parser_state_t *) parser_state )->current_file_index += 1;
	}
    break;

  case 69: /* cue_flags: CUE_FLAGS cue_flags_types CUE_END_OF_LINE  */
        {
		libodraw_cue_parser_rule_print(
		 "cue_flags" );
	}
    break;

  case 72: /* cue_index: CUE_INDEX CUE_2DIGIT CUE_MSF CUE_END_OF_LINE  */
        {
		libodraw_cue_parser_rule_print(
		 "cue_index" );

		( (libodraw_cue_parser_state_t *) parser_state )->previous_index = ( (libodraw_cue_parser_state_t *) parser_state )->current_index;

		if( libodraw_cue_parser_parse_number(
		     (yyvsp[-2].string_value).data,
		     (yyvsp[-2].string_value).length,
		     &( ( (libodraw_cue_parser_state_t *) parser_state )->current_index ),
		     ( (libodraw_cue_parser_state_t *) parser_state )->error ) != 1 )
		{
			libcerror_error_set(
			 ( (libodraw_cue_parser_state_t *) parser_state )->error,
			 LIBCERROR_ERROR_DOMAIN_RUNTIME,
			 LIBCERROR_RUNTIME_ERROR_SET_FAILED,
			 "%s: unable to parse index number.",
			 libodraw_cue_parser_function );

			YYABORT;
		}
		if( ( ( (libodraw_cue_parser_state_t *) parser_state )->current_index != 0 )
		 && ( ( (libodraw_cue_parser_state_t *) parser_state )->current_index != ( ( (libodraw_cue_parser_state_t *) parser_state )->previous_index + 1 ) ) )
		{
			libcerror_error_set(
			 ( (libodraw_cue_parser_state_t *) parser_state )->error,
			 LIBCERROR_ERROR_DOMAIN_RUNTIME,
			 LIBCERROR_RUNTIME_ERROR_UNSUPPORTED_VALUE,
			 "%s: unsupported index number - values are not sequential.",
			 libodraw_cue_parser_function );

			YYABORT;
		}
		if( libodraw_cue_parser_parse_msf(
		     (yyvsp[-1].string_value).data,
		     (yyvsp[-1].string_value).length,
		     &( ( (libodraw_cue_parser_state_t *) parser_state )->current_start_sector ),
		     ( (libodraw_cue_parser_state_t *) parser_state )->error ) != 1 )
		{
			libcerror_error_set(
			 ( (libodraw_cue_parser_state_t *) parser_state )->error,
			 LIBCERROR_ERROR_DOMAIN_RUNTIME,
			 LIBCERROR_RUNTIME_ERROR_SET_FAILED,
			 "%s: unable to parse index MSF.",
			 libodraw_cue_parser_function );

			YYABORT;
		}
		/* The MSF can be relative to the start of the file
		 */
		if( ( (libodraw_cue_parser_state_t *) parser_state )->current_start_sector != 0 )
		{
			if( ( ( (libodraw_cue_parser_state_t *) parser_state )->current_index == 0 )
			 || ( ( (libodraw_cue_parser_state_t *) parser_state )->current_index == 1 ) )
			{
				if( ( ( (libodraw_cue_parser_state_t *) parser_state )->session_number_of_sectors == 0 )
				 || ( ( (libodraw_cue_parser_state_t *) parser_state )->previous_track_type == LIBODRAW_TRACK_TYPE_AUDIO ) )
				{
					if( ( (libodraw_cue_parser_state_t *) parser_state )->current_start_sector < ( (libodraw_cue_parser_state_t *) parser_state )->previous_session_start_sector )
					{
						libcerror_error_set(
						 ( (libodraw_cue_parser_state_t *) parser_state )->error,
						 LIBCERROR_ERROR_DOMAIN_RUNTIME,
						 LIBCERROR_RUNTIME_ERROR_VALUE_OUT_OF_BOUNDS,
						 "%s: invalid session start sector value precedes previous.",
						 libodraw_cue_parser_function );

						YYABORT;
					}
					( (libodraw_cue_parser_state_t *) parser_state )->session_number_of_sectors = ( (libodraw_cue_parser_state_t *) parser_state )->current_start_sector
					                                                                            - ( (libodraw_cue_parser_state_t *) parser_state )->previous_session_start_sector;
				}
				if( ( ( (libodraw_cue_parser_state_t *) parser_state )->lead_out_number_of_sectors == 0 )
				 || ( ( (libodraw_cue_parser_state_t *) parser_state )->previous_track_type == LIBODRAW_TRACK_TYPE_AUDIO ) )
				{
					if( ( (libodraw_cue_parser_state_t *) parser_state )->current_start_sector < ( (libodraw_cue_parser_state_t *) parser_state )->previous_lead_out_start_sector )
					{
						libcerror_error_set(
						 ( (libodraw_cue_parser_state_t *) parser_state )->error,
						 LIBCERROR_ERROR_DOMAIN_RUNTIME,
						 LIBCERROR_RUNTIME_ERROR_VALUE_OUT_OF_BOUNDS,
						 "%s: invalid lead-out start sector value precedes previous.",
						 libodraw_cue_parser_function );

						YYABORT;
					}
					( (libodraw_cue_parser_state_t *) parser_state )->lead_out_number_of_sectors = ( (libodraw_cue_parser_state_t *) parser_state )->current_start_sector
					                                                                             - ( (libodraw_cue_parser_state_t *) parser_state )->previous_lead_out_start_sector;
				}
			}
			if( ( (libodraw_cue_parser_state_t *) parser_state )->current_index == 1 )
			{
				if( ( (libodraw_cue_parser_state_t *) parser_state )->track_number_of_sectors == 0 )
				{
					if( ( (libodraw_cue_parser_state_t *) parser_state )->current_start_sector < ( (libodraw_cue_parser_state_t *) parser_state )->previous_track_start_sector )
					{
						libcerror_error_set(
						 ( (libodraw_cue_parser_state_t *) parser_state )->error,
						 LIBCERROR_ERROR_DOMAIN_RUNTIME,
						 LIBCERROR_RUNTIME_ERROR_VALUE_OUT_OF_BOUNDS,
						 "%s: invalid track start sector value precedes previous.",
						 libodraw_cue_parser_function );

						YYABORT;
					}
					( (libodraw_cue_parser_state_t *) parser_state )->track_number_of_sectors = ( (libodraw_cue_parser_state_t *) parser_state )->current_start_sector
					                                                                          - ( (libodraw_cue_parser_state_t *) parser_state )->previous_track_start_sector;
				}
			}
		}
		if( ( (libodraw_cue_parser_state_t *) parser_state )->current_index == 1 )
		{
			if( ( (libodraw_cue_parser_state_t *) parser_state )->current_session > 1 )
			{
				if( libodraw_handle_append_session(
				     ( (libodraw_cue_parser_state_t *) parser_state )->handle,
				     ( (libodraw_cue_parser_state_t *) parser_state )->previous_session_start_sector,
				     ( (libodraw_cue_parser_state_t *) parser_state )->session_number_of_sectors,
				     ( (libodraw_cue_parser_state_t *) parser_state )->error ) != 1 )
				{
					libcerror_error_set(
					 ( (libodraw_cue_parser_state_t *) parser_state )->error,
					 LIBCERROR_ERROR_DOMAIN_RUNTIME,
					 LIBCERROR_RUNTIME_ERROR_APPEND_FAILED,
					 "%s: unable to append session.",
					 libodraw_cue_parser_function );

					YYABORT;
				}
				( (libodraw_cue_parser_state_t *) parser_state )->previous_session_start_sector = ( (libodraw_cue_parser_state_t *) parser_state )->current_start_sector;
				( (libodraw_cue_parser_state_t *) parser_state )->session_number_of_sectors     = 0;
			}
			if( ( (libodraw_cue_parser_state_t *) parser_state )->current_lead_out > ( (libodraw_cue_parser_state_t *) parser_state )->previous_lead_out )
			{
				if( libodraw_handle_append_lead_out(
				     ( (libodraw_cue_parser_state_t *) parser_state )->handle,
				     ( (libodraw_cue_parser_state_t *) parser_state )->previous_lead_out_start_sector,
				     ( (libodraw_cue_parser_state_t *) parser_state )->lead_out_number_of_sectors,
				     ( (libodraw_cue_parser_state_t *) parser_state )->error ) != 1 )
				{
					libcerror_error_set(
					 ( (libodraw_cue_parser_state_t *) parser_state )->error,
					 LIBCERROR_ERROR_DOMAIN_RUNTIME,
					 LIBCERROR_RUNTIME_ERROR_APPEND_FAILED,
					 "%s: unable to append lead-out.",
					 libodraw_cue_parser_function );

					YYABORT;
				}
				( (libodraw_cue_parser_state_t *) parser_state )->previous_lead_out          = ( (libodraw_cue_parser_state_t *) parser_state )->current_lead_out;
				( (libodraw_cue_parser_state_t *) parser_state )->lead_out_number_of_sectors = 0;
			}
			if( ( (libodraw_cue_parser_state_t *) parser_state )->current_track > 1 )
			{
				if( ( (libodraw_cue_parser_state_t *) parser_state )->previous_file_index < 0 )
				{
					( (libodraw_cue_parser_state_t *) parser_state )->file_sector = ( (libodraw_cue_parser_state_t *) parser_state )->previous_track_start_sector;

					( (libodraw_cue_parser_state_t *) parser_state )->previous_file_index += 1;
				}
				( (libodraw_cue_parser_state_t *) parser_state )->previous_file_sector = ( (libodraw_cue_parser_state_t *) parser_state )->previous_track_start_sector
				                                                                       - ( (libodraw_cue_parser_state_t *) parser_state )->file_sector;

				if( libodraw_handle_append_track(
				     ( (libodraw_cue_parser_state_t *) parser_state )->handle,
				     ( (libodraw_cue_parser_state_t *) parser_state )->previous_track_start_sector,
				     ( (libodraw_cue_parser_state_t *) parser_state )->track_number_of_sectors,
				     ( (libodraw_cue_parser_state_t *) parser_state )->previous_track_type,
				     ( (libodraw_cue_parser_state_t *) parser_state )->previous_file_index,
				     ( (libodraw_cue_parser_state_t *) parser_state )->previous_file_sector,
				     ( (libodraw_cue_parser_state_t *) parser_state )->error ) != 1 )
				{
					libcerror_error_set(
					 ( (libodraw_cue_parser_state_t *) parser_state )->error,
					 LIBCERROR_ERROR_DOMAIN_RUNTIME,
					 LIBCERROR_RUNTIME_ERROR_APPEND_FAILED,
					 "%s: unable to append track.",
					 libodraw_cue_parser_function );

					YYABORT;
				}
				if( ( (libodraw_cue_parser_state_t *) parser_state )->previous_file_index < ( (libodraw_cue_parser_state_t *) parser_state )->current_file_index )
				{
					( (libodraw_cue_parser_state_t *) parser_state )->file_sector = ( (libodraw_cue_parser_state_t *) parser_state )->current_start_sector;

					( (libodraw_cue_parser_state_t *) parser_state )->previous_file_index += 1;
				}
				( (libodraw_cue_parser_state_t *) parser_state )->previous_track_start_sector = ( (libodraw_cue_parser_state_t *) parser_state )->current_start_sector;
				( (libodraw_cue_parser_state_t *) parser_state )->track_number_of_sectors     = 0;
			}
		}
	}
    break;

  case 73: /* cue_copy: CUE_COPY CUE_END_OF_LINE  */
        {
		libodraw_cue_parser_rule_print(
		 "cue_copy" );
	}
    break;

  case 74: /* cue_datafile: CUE_DATAFILE CUE_STRING CUE_MSF CUE_END_OF_LINE  */
        {
		libodraw_cue_parser_rule_print(
		 "cue_datafile" );

		if( (yyvsp[-2].string_value).data == NULL )
		{
			libcerror_error_set(
			 ( (libodraw_cue_parser_state_t *) parser_state )->error,
			 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
			 LIBCERROR_ARGUMENT_ERROR_INVALID_VALUE,
			 "%s: invalid filename.",
			 libodraw_cue_parser_function );

			YYABORT;
		}
		if( libodraw_cue_parser_parse_msf(
		     (yyvsp[-1].string_value).data,
		     (yyvsp[-1].string_value).length,
		     &( ( (libodraw_cue_parser_state_t *) parser_state )->track_number_of_sectors ),
		     ( (libodraw_cue_parser_state_t *) parser_state )->error ) != 1 )
		{
			libcerror_error_set(
			 ( (libodraw_cue_parser_state_t *) parser_state )->error,
			 LIBCERROR_ERROR_DOMAIN_RUNTIME,
			 LIBCERROR_RUNTIME_ERROR_SET_FAILED,
			 "%s: unable to parse datafile MSF.",
			 libodraw_cue_parser_function );

			YYABORT;
		}
		( (libodraw_cue_parser_state_t *) parser_state )->file_type = LIBODRAW_FILE_TYPE_BINARY_LITTLE_ENDIAN;

		if( libodraw_handle_append_data_file(
		     ( (libodraw_cue_parser_state_t *) parser_state )->handle,
		     (yyvsp[-2].string_value).data,
		     (yyvsp[-2].string_value).length,
		     ( (libodraw_cue_parser_state_t *) parser_state )->file_type,
		     ( (libodraw_cue_parser_state_t *) parser_state )->error ) != 1 )
		{
			libcerror_error_set(
			 ( (libodraw_cue_parser_state_t *) parser_state )->error,
			 LIBCERROR_ERROR_DOMAIN_RUNTIME,
			 LIBCERROR_RUNTIME_ERROR_APPEND_FAILED,
			 "%s: unable to append data file.",
			 libodraw_cue_parser_function );

			YYABORT;
		}
		if( ( (libodraw_cue_parser_state_t *) parser_state )->previous_file_index < 0 )
		{
			( (libodraw_cue_parser_state_t *) parser_state )->file_sector = ( (libodraw_cue_parser_state_t *) parser_state )->previous_track_start_sector;

			( (libodraw_cue_parser_state_t *) parser_state )->previous_file_index += 1;
		}
		( (libodraw_cue_parser_state_t *) parser_state )->previous_file_sector = ( (libodraw_cue_parser_state_t *) parser_state )->previous_track_start_sector
		                                                                       - ( (libodraw_cue_parser_state_t *) parser_state )->file_sector;

		if( libodraw_handle_append_track(
		     ( (libodraw_cue_parser_state_t *) parser_state )->handle,
		     ( (libodraw_cue_parser_state_t *) parser_state )->previous_track_start_sector,
		     ( (libodraw_cue_parser_state_t *) parser_state )->track_number_of_sectors,
		     ( (libodraw_cue_parser_state_t *) parser_state )->current_track_type,
		     ( (libodraw_cue_parser_state_t *) parser_state )->previous_file_index,
		     ( (libodraw_cue_parser_state_t *) parser_state )->previous_file_sector,
		     ( (libodraw_cue_parser_state_t *) parser_state )->error ) != 1 )
		{
			libcerror_error_set(
			 ( (libodraw_cue_parser_state_t *) parser_state )->error,
			 LIBCERROR_ERROR_DOMAIN_RUNTIME,
			 LIBCERROR_RUNTIME_ERROR_APPEND_FAILED,
			 "%s: unable to append track.",
			 libodraw_cue_parser_function );

			YYABORT;
		}
		( (libodraw_cue_parser_state_t *) parser_state )->current_file_index += 1;
	}
    break;

  case 75: /* cue_four_channel_audio: CUE_FOUR_CHANNEL_AUDIO CUE_END_OF_LINE  */
        {
		libodraw_cue_parser_rule_print(
		 "cue_four_channel_audio" );
	}
    break;

  case 76: /* cue_isrc: CUE_ISRC CUE_ISRC_CODE CUE_END_OF_LINE  */
        {
		libodraw_cue_parser_rule_print(
		 "cue_isrc" );
	}
    break;

  case 77: /* cue_no_copy: CUE_NO_COPY CUE_END_OF_LINE  */
        {
		libodraw_cue_parser_rule_print(
		 "cue_no_copy" );
	}
    break;

  case 78: /* cue_no_pre_emphasis: CUE_NO_PRE_EMPHASIS CUE_END_OF_LINE  */
        {
		libodraw_cue_parser_rule_print(
		 "cue_no_pre_emphasis" );
	}
    break;

  case 79: /* cue_postgap: CUE_POSTGAP CUE_MSF CUE_END_OF_LINE  */
        {
		libodraw_cue_parser_rule_print(
		 "cue_postgap" );
	}
    break;

  case 80: /* cue_pre_emphasis: CUE_PRE_EMPHASIS CUE_END_OF_LINE  */
        {
		libodraw_cue_parser_rule_print(
		 "cue_pre_emphasis" );
	}
    break;

  case 81: /* cue_pregap: CUE_PREGAP CUE_MSF CUE_END_OF_LINE  */
        {
		libodraw_cue_parser_rule_print(
		 "cue_pregap" );
	}
    break;

  case 82: /* cue_two_channel_audio: CUE_TWO_CHANNEL_AUDIO CUE_END_OF_LINE  */
        {
		libodraw_cue_parser_rule_print(
		 "cue_two_channel_audio" );
	}
    break;

  case 88: /* cue_lead_out: CUE_REMARK_LEAD_OUT CUE_MSF CUE_END_OF_LINE  */
        {
		libodraw_cue_parser_rule_print(
		 "cue_lead_out" );

		if( libodraw_cue_parser_parse_msf(
		     (yyvsp[-1].string_value).data,
		     (yyvsp[-1].string_value).length,
		     &( ( (libodraw_cue_parser_state_t *) parser_state )->previous_lead_out_start_sector ),
		     ( (libodraw_cue_parser_state_t *) parser_state )->error ) != 1 )
		{
			libcerror_error_set(
			 ( (libodraw_cue_parser_state_t *) parser_state )->error,
			 LIBCERROR_ERROR_DOMAIN_RUNTIME,
			 LIBCERROR_RUNTIME_ERROR_SET_FAILED,
			 "%s: unable to parse lead-out MSF.",
			 libodraw_cue_parser_function );

			YYABORT;
		}
		if( ( (libodraw_cue_parser_state_t *) parser_state )->track_number_of_sectors == 0 )
		{
			if( ( (libodraw_cue_parser_state_t *) parser_state )->previous_lead_out_start_sector < ( (libodraw_cue_parser_state_t *) parser_state )->previous_track_start_sector )
			{
				libcerror_error_set(
				 ( (libodraw_cue_parser_state_t *) parser_state )->error,
				 LIBCERROR_ERROR_DOMAIN_RUNTIME,
				 LIBCERROR_RUNTIME_ERROR_VALUE_OUT_OF_BOUNDS,
				 "%s: invalid lead-out start sector value precedes previous track start sector.",
				 libodraw_cue_parser_function );

				YYABORT;
			}
			( (libodraw_cue_parser_state_t *) parser_state )->track_number_of_sectors = ( (libodraw_cue_parser_state_t *) parser_state )->previous_lead_out_start_sector
			                                                                          - ( (libodraw_cue_parser_state_t *) parser_state )->previous_track_start_sector;
		}
		( (libodraw_cue_parser_state_t *) parser_state )->current_lead_out += 1;
	}
    break;

  case 89: /* cue_original_media_type: CUE_REMARK_ORIGINAL_MEDIA_TYPE CUE_KEYWORD_STRING CUE_END_OF_LINE  */
        {
		libodraw_cue_parser_rule_print(
		 "cue_original_media_type" );
	}
    break;

  case 90: /* cue_remark: cue_remark_start error CUE_END_OF_LINE  */
        {
		libodraw_cue_parser_rule_print(
		 "cue_remark" );

		libodraw_cue_scanner_suppress_error = 0;
	}
    break;

  case 91: /* cue_remark_start: CUE_REMARK  */
        {
		/* The build-in rule error will gobble up all the tokens until the end-of-line
		 * because these are no syntax errors suppress the error output
		 */
		libodraw_cue_scanner_suppress_error = 1;
	}
    break;

  case 92: /* cue_run_out: CUE_REMARK_RUN_OUT CUE_MSF CUE_END_OF_LINE  */
        {
		libodraw_cue_parser_rule_print(
		 "cue_run_out" );

		if( libodraw_cue_parser_parse_msf(
		     (yyvsp[-1].string_value).data,
		     (yyvsp[-1].string_value).length,
		     &( ( (libodraw_cue_parser_state_t *) parser_state )->current_start_sector ),
		     ( (libodraw_cue_parser_state_t *) parser_state )->error ) != 1 )
		{
			libcerror_error_set(
			 ( (libodraw_cue_parser_state_t *) parser_state )->error,
			 LIBCERROR_ERROR_DOMAIN_RUNTIME,
			 LIBCERROR_RUNTIME_ERROR_SET_FAILED,
			 "%s: unable to parse run-out MSF.",
			 libodraw_cue_parser_function );

			YYABORT;
		}
		if( ( (libodraw_cue_parser_state_t *) parser_state )->track_number_of_sectors == 0 )
		{
			if( ( (libodraw_cue_parser_state_t *) parser_state )->current_start_sector < ( (libodraw_cue_parser_state_t *) parser_state )->previous_track_start_sector )
			{
				libcerror_error_set(
				 ( (libodraw_cue_parser_state_t *) parser_state )->error,
				 LIBCERROR_ERROR_DOMAIN_RUNTIME,
				 LIBCERROR_RUNTIME_ERROR_VALUE_OUT_OF_BOUNDS,
				 "%s: invalid track start sector value precedes previous.",
				 libodraw_cue_parser_function );

				YYABORT;
			}
			( (libodraw_cue_parser_state_t *) parser_state )->track_number_of_sectors = ( (libodraw_cue_parser_state_t *) parser_state )->current_start_sector
									                          - ( (libodraw_cue_parser_state_t *) parser_state )->previous_track_start_sector;
		}
	}
    break;

  case 93: /* cue_session: CUE_REMARK_SESSION CUE_2DIGIT CUE_END_OF_LINE  */
        {
		libodraw_cue_parser_rule_print(
		 "cue_session" );

		( (libodraw_cue_parser_state_t *) parser_state )->previous_session = ( (libodraw_cue_parser_state_t *) parser_state )->current_session;

		if( libodraw_cue_parser_parse_number(
		     (yyvsp[-1].string_value).data,
		     (yyvsp[-1].string_value).length,
		     &( ( (libodraw_cue_parser_state_t *) parser_state )->current_session ),
		     ( (libodraw_cue_parser_state_t *) parser_state )->error ) != 1 )
		{
			libcerror_error_set(
			 ( (libodraw_cue_parser_state_t *) parser_state )->error,
			 LIBCERROR_ERROR_DOMAIN_RUNTIME,
			 LIBCERROR_RUNTIME_ERROR_SET_FAILED,
			 "%s: unable to parse session number.",
			 libodraw_cue_parser_function );

			YYABORT;
		}
		if( ( ( (libodraw_cue_parser_state_t *) parser_state )->current_session != 0 )
		 && ( ( (libodraw_cue_parser_state_t *) parser_state )->current_session != ( ( (libodraw_cue_parser_state_t *) parser_state )->previous_session + 1 ) ) )
		{
			libcerror_error_set(
			 ( (libodraw_cue_parser_state_t *) parser_state )->error,
			 LIBCERROR_ERROR_DOMAIN_RUNTIME,
			 LIBCERROR_RUNTIME_ERROR_UNSUPPORTED_VALUE,
			 "%s: unsupported session number - values are not sequential.",
			 libodraw_cue_parser_function );

			YYABORT;
		}
	}
    break;

  case 94: /* cue_track: CUE_TRACK CUE_KEYWORD_STRING CUE_END_OF_LINE  */
        {
		libodraw_cue_parser_rule_print(
		 "cue_track" );

		if( ( (libodraw_cue_parser_state_t *) parser_state )->current_track != 0 )
		{
			libcerror_error_set(
			 ( (libodraw_cue_parser_state_t *) parser_state )->error,
			 LIBCERROR_ERROR_DOMAIN_RUNTIME,
			 LIBCERROR_RUNTIME_ERROR_UNSUPPORTED_VALUE,
			 "%s: unsupported track number - only single track supported.",
			 libodraw_cue_parser_function );

			YYABORT;
		}
		( (libodraw_cue_parser_state_t *) parser_state )->previous_track_type = ( (libodraw_cue_parser_state_t *) parser_state )->current_track_type;

		if( libodraw_cue_parser_parse_track_type(
		     (yyvsp[-1].string_value).data,
		     (yyvsp[-1].string_value).length,
		     &( ( (libodraw_cue_parser_state_t *) parser_state )->current_track_type ),
		     ( (libodraw_cue_parser_state_t *) parser_state )->error ) != 1 )
		{
			libcerror_error_set(
			 ( (libodraw_cue_parser_state_t *) parser_state )->error,
			 LIBCERROR_ERROR_DOMAIN_RUNTIME,
			 LIBCERROR_RUNTIME_ERROR_SET_FAILED,
			 "%s: unable to parse track type.",
			 libodraw_cue_parser_function );

			YYABORT;
		}
		( (libodraw_cue_parser_state_t *) parser_state )->previous_index = 0;
		( (libodraw_cue_parser_state_t *) parser_state )->current_index  = 0;
	}
    break;

  case 95: /* cue_track: CUE_TRACK CUE_2DIGIT CUE_KEYWORD_STRING CUE_END_OF_LINE  */
        {
		libodraw_cue_parser_rule_print(
		 "cue_track" );

		( (libodraw_cue_parser_state_t *) parser_state )->previous_track = ( (libodraw_cue_parser_state_t *) parser_state )->current_track;

		if( libodraw_cue_parser_parse_number(
		     (yyvsp[-2].string_value).data,
		     (yyvsp[-2].string_value).length,
		     &( ( (libodraw_cue_parser_state_t *) parser_state )->current_track ),
		     ( (libodraw_cue_parser_state_t *) parser_state )->error ) != 1 )
		{
			libcerror_error_set(
			 ( (libodraw_cue_parser_state_t *) parser_state )->error,
			 LIBCERROR_ERROR_DOMAIN_RUNTIME,
			 LIBCERROR_RUNTIME_ERROR_SET_FAILED,
			 "%s: unable to parse track number.",
			 libodraw_cue_parser_function );

			YYABORT;
		}
		if( ( ( (libodraw_cue_parser_state_t *) parser_state )->current_track != 0 )
		 && ( ( (libodraw_cue_parser_state_t *) parser_state )->current_track != ( ( (libodraw_cue_parser_state_t *) parser_state )->previous_track + 1 ) ) )
		{
			libcerror_error_set(
			 ( (libodraw_cue_parser_state_t *) parser_state )->error,
			 LIBCERROR_ERROR_DOMAIN_RUNTIME,
			 LIBCERROR_RUNTIME_ERROR_UNSUPPORTED_VALUE,
			 "%s: unsupported track number - values are not sequential.",
			 libodraw_cue_parser_function );

			YYABORT;
		}
		( (libodraw_cue_parser_state_t *) parser_state )->previous_track_type = ( (libodraw_cue_parser_state_t *) parser_state )->current_track_type;

		if( libodraw_cue_parser_parse_track_type(
		     (yyvsp[-1].string_value).data,
		     (yyvsp[-1].string_value).length,
		     &( ( (libodraw_cue_parser_state_t *) parser_state )->current_track_type ),
		     ( (libodraw_cue_parser_state_t *) parser_state )->error ) != 1 )
		{
			libcerror_error_set(
			 ( (libodraw_cue_parser_state_t *) parser_state )->error,
			 LIBCERROR_ERROR_DOMAIN_RUNTIME,
			 LIBCERROR_RUNTIME_ERROR_SET_FAILED,
			 "%s: unable to parse track type.",
			 libodraw_cue_parser_function );

			YYABORT;
		}
		( (libodraw_cue_parser_state_t *) parser_state )->previous_index = 0;
		( (libodraw_cue_parser_state_t *) parser_state )->current_index  = 0;
	}
    break;



      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (parser_state, YY_("syntax error"));
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, parser_state);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, parser_state);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (parser_state, YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, parser_state);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, parser_state);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}



/* Parses a number
 * Returns 1 if successful or -1 on error
 */
int libodraw_cue_parser_parse_number(
     const char *token,
     size_t token_size,
     int *number,
     libcerror_error_t **error )
{
	static char *function = "libodraw_cue_parser_parse_number";
	int safe_number       = 0;

	if( token == NULL )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_INVALID_VALUE,
		 "%s: invalid token.",
		 function );

		return( -1 );
	}
	if( ( token_size < 1 )
	 || ( token_size > 2 ) )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_RUNTIME,
		 LIBCERROR_RUNTIME_ERROR_VALUE_OUT_OF_BOUNDS,
		 "%s: invalid token size value out of bounds.",
		 function );

		return( -1 );
	}
	if( number == NULL )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_INVALID_VALUE,
		 "%s: invalid number.",
		 function );

		return( -1 );
	}
	if( ( token[ 0 ] < '0' )
	 || ( token[ 0 ] > '9' ) )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_UNSUPPORTED_VALUE,
		 "%s: unsupported first digit of number token.",
		 function );

		return( -1 );
	}
	safe_number = token[ 0 ] - '0';

	if( token_size == 2 )
	{
		safe_number *= 10;

		if( ( token[ 1 ] < '0' )
		 || ( token[ 1 ] > '9' ) )
		{
			libcerror_error_set(
			 error,
			 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
			 LIBCERROR_ARGUMENT_ERROR_UNSUPPORTED_VALUE,
			 "%s: unsupported second digit of number token.",
			 function );

			return( -1 );
		}
		safe_number += token[ 1 ] - '0';
	}
	*number = safe_number;

	return( 1 );
}

/* Parses a MFS (minutes:seconds:frames) value and converts it into a logical block address (LBA)
 * Returns 1 if successful or -1 on error
 */
int libodraw_cue_parser_parse_msf(
     const char *token,
     size_t token_size,
     uint64_t *lba,
     libcerror_error_t **error )
{
	static char *function = "libodraw_cue_parser_parse_msf";
	uint64_t safe_lba     = 0;

	if( token == NULL )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_INVALID_VALUE,
		 "%s: invalid token.",
		 function );

		return( -1 );
	}
	if( token_size != 8 )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_RUNTIME,
		 LIBCERROR_RUNTIME_ERROR_VALUE_OUT_OF_BOUNDS,
		 "%s: invalid token size value out of bounds.",
		 function );

		return( -1 );
	}
	if( lba == NULL )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_INVALID_VALUE,
		 "%s: invalid LBA.",
		 function );

		return( -1 );
	}
	if( ( token[ 0 ] < '0' )
	 || ( token[ 0 ] > '9' )
	 || ( token[ 1 ] < '0' )
	 || ( token[ 1 ] > '9' )
	 || ( token[ 2 ] != ':' )
	 || ( token[ 3 ] < '0' )
	 || ( token[ 3 ] > '9' )
	 || ( token[ 4 ] < '0' )
	 || ( token[ 4 ] > '9' )
	 || ( token[ 5 ] != ':' )
	 || ( token[ 6 ] < '0' )
	 || ( token[ 6 ] > '9' )
	 || ( token[ 7 ] < '0' )
	 || ( token[ 7 ] > '9' ) )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_UNSUPPORTED_VALUE,
		 "%s: unsupported MSF token.",
		 function );

		return( -1 );
	}
	/* Note that the MSF are relative, so there is no need for the MSF offset correction
	 */
        safe_lba  = ( ( token[ 0 ] - '0' ) * 10 ) + ( token[ 1 ] - '0' ); \
        safe_lba *= CD_SECS; \
        safe_lba += ( ( token[ 3 ] - '0' ) * 10 ) + ( token[ 4 ] - '0' ); \
        safe_lba *= CD_FRAMES; \
        safe_lba += ( ( token[ 6 ] - '0' ) * 10 ) + ( token[ 7 ] - '0' );

	*lba = safe_lba;

	return( 1 );
}

/* Parses a track type
 * Returns 1 if successful or -1 on error
 */
int libodraw_cue_parser_parse_track_type(
     const char *token,
     size_t token_size,
     uint8_t *track_type,
     libcerror_error_t **error )
{
	static char *function = "libodraw_cue_parser_parse_track_type";

	if( token == NULL )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_INVALID_VALUE,
		 "%s: invalid token.",
		 function );

		return( -1 );
	}
	if( token_size < 1 )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_RUNTIME,
		 LIBCERROR_RUNTIME_ERROR_VALUE_OUT_OF_BOUNDS,
		 "%s: invalid token size value out of bounds.",
		 function );

		return( -1 );
	}
	if( track_type == NULL )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_INVALID_VALUE,
		 "%s: invalid track type.",
		 function );

		return( -1 );
	}
	*track_type = LIBODRAW_TRACK_TYPE_UNKNOWN;

	if( token_size == 3 )
	{
		if( narrow_string_compare(
		     token,
		     "CDG",
		     3 ) == 0 )
		{
			*track_type = LIBODRAW_TRACK_TYPE_CDG;
		}
	}
	else if( token_size == 5 )
	{
		if( narrow_string_compare(
		     token,
		     "AUDIO",
		     5 ) == 0 )
		{
			*track_type = LIBODRAW_TRACK_TYPE_AUDIO;
		}
	}
	else if( token_size == 8 )
	{
		if( narrow_string_compare(
		     token,
		     "CDI",
		     3 ) == 0 )
		{
			if( token[ 3 ] == '/' )
			{
				if( narrow_string_compare(
				     &( token[ 4 ] ),
				     "2336",
				     4 ) == 0 )
				{
					 *track_type = LIBODRAW_TRACK_TYPE_CDI_2336;
				}
				else if( narrow_string_compare(
					  &( token[ 4 ] ),
					  "2352",
					  4 ) == 0 )
				{
					 *track_type = LIBODRAW_TRACK_TYPE_CDI_2352;
				}
			}
		}
	}
	else if( token_size == 9 )
	{
		if( narrow_string_compare(
		     token,
		     "MODE1_RAW",
		     9 ) == 0 )
		{
			*track_type = LIBODRAW_TRACK_TYPE_MODE1_2352;
		}
		else if( narrow_string_compare(
		          token,
		          "MODE2_RAW",
		          9 ) == 0 )
		{
			*track_type = LIBODRAW_TRACK_TYPE_MODE2_2352;
		}
	}
	else if( token_size == 10 )
	{
		if( narrow_string_compare(
		     token,
		     "MODE",
		     4 ) == 0 )
		{
			if( token[ 5 ] == '/' )
			{
				if( token[ 4 ] == '1' )
				{
					if( narrow_string_compare(
					     &( token[ 6 ] ),
					     "2048",
					     4 ) == 0 )
					{
						 *track_type = LIBODRAW_TRACK_TYPE_MODE1_2048;
					}
					else if( narrow_string_compare(
						  &( token[ 6 ] ),
						  "2352",
						  4 ) == 0 )
					{
						 *track_type = LIBODRAW_TRACK_TYPE_MODE1_2352;
					}
				}
				else if( token[ 4 ] == '2' )
				{
					if( narrow_string_compare(
					     &( token[ 6 ] ),
					     "2048",
					     4 ) == 0 )
					{
						 *track_type = LIBODRAW_TRACK_TYPE_MODE2_2048;
					}
					else if( narrow_string_compare(
						  &( token[ 6 ] ),
						  "2324",
						  4 ) == 0 )
					{
						 *track_type = LIBODRAW_TRACK_TYPE_MODE2_2324;
					}
					else if( narrow_string_compare(
						  &( token[ 6 ] ),
						  "2336",
						  4 ) == 0 )
					{
						 *track_type = LIBODRAW_TRACK_TYPE_MODE2_2336;
					}
					else if( narrow_string_compare(
						  &( token[ 6 ] ),
						  "2352",
						  4 ) == 0 )
					{
						 *track_type = LIBODRAW_TRACK_TYPE_MODE2_2352;
					}
				}
			}
		}
	}
	return( 1 );
}

/* Parses a CUE file
 * Returns 1 if successful or -1 on error
 */
int libodraw_cue_parser_parse_buffer(
     libodraw_handle_t *handle,
     const uint8_t *buffer,
     size_t buffer_size,
     libcerror_error_t **error )
{
	libodraw_cue_parser_state_t parser_state;
	
	static char *function        = "libodraw_cue_parser_parse_buffer";
	YY_BUFFER_STATE buffer_state = NULL;
	size_t buffer_offset         = 0;
	int result                   = -1;

	if( buffer == NULL )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_INVALID_VALUE,
		 "%s: invalid buffer.",
		 function );

		return( -1 );
	}
	if( buffer_size >= 3 )
	{
		if( ( buffer[ 0 ] == 0x0ef )
		 && ( buffer[ 1 ] == 0x0bb )
		 && ( buffer[ 2 ] == 0x0bf ) )
		{
			buffer_offset = 3;
		}
	}
	buffer_state = libodraw_cue_scanner__scan_buffer(
	                (char *) &( buffer[ buffer_offset ] ),
	                buffer_size - buffer_offset );

	libodraw_cue_scanner_buffer_offset = (size_t) buffer_offset;

	if( buffer_state != NULL )
	{
		parser_state.handle                         = handle;
		parser_state.error                          = error;
		parser_state.previous_file_index            = -1;
		parser_state.current_file_index             = -1;
		parser_state.file_type                      = 0;
		parser_state.previous_file_sector           = 0;
		parser_state.file_sector                    = 0;
		parser_state.previous_session_start_sector  = 0;
		parser_state.previous_lead_out_start_sector = 0;
		parser_state.previous_track_start_sector    = 0;
		parser_state.current_start_sector           = 0;
		parser_state.session_number_of_sectors      = 0;
		parser_state.lead_out_number_of_sectors     = 0;
		parser_state.track_number_of_sectors        = 0;
		parser_state.previous_track_type            = 0;
		parser_state.current_track_type             = 0;
		parser_state.previous_session               = 0;
		parser_state.current_session                = 0;
		parser_state.previous_lead_out              = 0;
		parser_state.current_lead_out               = 0;
		parser_state.previous_track                 = 0;
		parser_state.current_track                  = 0;
		parser_state.previous_index                 = 0;
		parser_state.current_index                  = 0;

		if( libodraw_cue_scanner_parse(
		     &parser_state ) == 0 )
		{
			result = 1;
		}
		libodraw_cue_scanner__delete_buffer(
		 buffer_state );

		if( parser_state.current_session > 0 )
		{
			if( libodraw_handle_append_session(
			     parser_state.handle,
			     parser_state.previous_session_start_sector,
			     0,
			     parser_state.error ) != 1 )
			{
				libcerror_error_set(
				 parser_state.error,
				 LIBCERROR_ERROR_DOMAIN_RUNTIME,
				 LIBCERROR_RUNTIME_ERROR_APPEND_FAILED,
				 "%s: unable to append session.",
				 function );

				result = -1;
			}
		}
		if( parser_state.current_lead_out > parser_state.previous_lead_out )
		{
			if( libodraw_handle_append_lead_out(
			     parser_state.handle,
			     parser_state.previous_lead_out_start_sector,
			     0,
			     parser_state.error ) != 1 )
			{
				libcerror_error_set(
				 parser_state.error,
				 LIBCERROR_ERROR_DOMAIN_RUNTIME,
				 LIBCERROR_RUNTIME_ERROR_APPEND_FAILED,
				 "%s: unable to append lead-out.",
				 function );

				result = -1;
			}
		}
		if( parser_state.current_track > 0 )
		{
			if( parser_state.previous_file_index < 0 )
			{
				parser_state.file_sector = parser_state.previous_track_start_sector;

				parser_state.previous_file_index += 1;
			}
			parser_state.previous_file_sector = parser_state.previous_track_start_sector
			                                  - parser_state.file_sector;

			if( libodraw_handle_append_track(
			     parser_state.handle,
			     parser_state.previous_track_start_sector,
			     0,
			     parser_state.current_track_type,
			     parser_state.current_file_index,
			     parser_state.previous_file_sector,
			     parser_state.error ) != 1 )
			{
				libcerror_error_set(
				 parser_state.error,
				 LIBCERROR_ERROR_DOMAIN_RUNTIME,
				 LIBCERROR_RUNTIME_ERROR_APPEND_FAILED,
				 "%s: unable to append track.",
				 function );

				result = -1;
			}
		}
	}
	libodraw_cue_scanner_lex_destroy();

	return( result );
}

