
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "ksqueezedtextlabel_wrapper.h"

// Wrappers providing overrides
#include "kurllabel_wrapper.h"
#include "kxyselector_wrapper.h"

// Argument includes
#include <QString>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qrect.h>
#include <qsize.h>
#include <qstyleoption.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KSqueezedTextLabel_Type = nullptr;
static PyTypeObject *Sbk_KSqueezedTextLabel_TypeF(void)
{
    return _Sbk_KSqueezedTextLabel_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KSqueezedTextLabelWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KSqueezedTextLabelWrapper::KSqueezedTextLabelWrapper(::QWidget * parent) : KSqueezedTextLabel(parent)
{
}

KSqueezedTextLabelWrapper::KSqueezedTextLabelWrapper(const ::QString & text, ::QWidget * parent) : KSqueezedTextLabel(text, parent)
{
}

void KSqueezedTextLabelWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KSqueezedTextLabel", funcName, gil, pyOverride, event);
}

void KSqueezedTextLabelWrapper::changeEvent(::QEvent * arg__1)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::changeEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KSqueezedTextLabel", funcName, gil, pyOverride, arg__1);
}

void KSqueezedTextLabelWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KSqueezedTextLabel", funcName, gil, pyOverride, event);
}

void KSqueezedTextLabelWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KSqueezedTextLabel", funcName, gil, pyOverride, event);
}

void KSqueezedTextLabelWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KSqueezedTextLabel", funcName, gil, pyOverride, signal);
}

void KSqueezedTextLabelWrapper::contextMenuEvent(::QContextMenuEvent * arg__1)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::KSqueezedTextLabel::contextMenuEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KSqueezedTextLabel", funcName, gil, pyOverride, arg__1);
}

void KSqueezedTextLabelWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KSqueezedTextLabel", funcName, gil, pyOverride, event);
}

int KSqueezedTextLabelWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KSqueezedTextLabel", funcName, gil, pyOverride);
}

void KSqueezedTextLabelWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KSqueezedTextLabel", funcName, gil, pyOverride, signal);
}

void KSqueezedTextLabelWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KSqueezedTextLabel", funcName, gil, pyOverride, event);
}

void KSqueezedTextLabelWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KSqueezedTextLabel", funcName, gil, pyOverride, event);
}

void KSqueezedTextLabelWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KSqueezedTextLabel", funcName, gil, pyOverride, event);
}

void KSqueezedTextLabelWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KSqueezedTextLabel", funcName, gil, pyOverride, event);
}

void KSqueezedTextLabelWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KSqueezedTextLabel", funcName, gil, pyOverride, event);
}

bool KSqueezedTextLabelWrapper::event(::QEvent * e)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::event(e);
    }
    return KXYSelectorWrapper::sbk_o_event("KSqueezedTextLabel", funcName, gil, pyOverride, e);
}

bool KSqueezedTextLabelWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KSqueezedTextLabel", funcName, gil, pyOverride, watched, event);
}

void KSqueezedTextLabelWrapper::focusInEvent(::QFocusEvent * ev)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::focusInEvent(ev);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KSqueezedTextLabel", funcName, gil, pyOverride, ev);
}

bool KSqueezedTextLabelWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KSqueezedTextLabel", funcName, gil, pyOverride, next);
}

void KSqueezedTextLabelWrapper::focusOutEvent(::QFocusEvent * ev)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::focusOutEvent(ev);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KSqueezedTextLabel", funcName, gil, pyOverride, ev);
}

bool KSqueezedTextLabelWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KSqueezedTextLabel", funcName, gil, pyOverride);
}

int KSqueezedTextLabelWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KSqueezedTextLabel", funcName, gil, pyOverride, arg__1);
}

void KSqueezedTextLabelWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KSqueezedTextLabel", funcName, gil, pyOverride, event);
}

void KSqueezedTextLabelWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KSqueezedTextLabel", funcName, gil, pyOverride, painter);
}

void KSqueezedTextLabelWrapper::initStyleOption(::QStyleOptionFrame * option) const
{
    static const char *funcName = "initStyleOption";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QFrame::initStyleOption(option);
    }
    KUrlLabelWrapper::sbk_o_initStyleOption("KSqueezedTextLabel", funcName, gil, pyOverride, option);
}

void KSqueezedTextLabelWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KSqueezedTextLabel", funcName, gil, pyOverride, event);
}

::QVariant KSqueezedTextLabelWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KSqueezedTextLabel", funcName, gil, pyOverride, arg__1);
}

void KSqueezedTextLabelWrapper::keyPressEvent(::QKeyEvent * ev)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::keyPressEvent(ev);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KSqueezedTextLabel", funcName, gil, pyOverride, ev);
}

void KSqueezedTextLabelWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KSqueezedTextLabel", funcName, gil, pyOverride, event);
}

void KSqueezedTextLabelWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KSqueezedTextLabel", funcName, gil, pyOverride, event);
}

int KSqueezedTextLabelWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KSqueezedTextLabel", funcName, gil, pyOverride, arg__1);
}

::QSize KSqueezedTextLabelWrapper::minimumSizeHint() const
{
    static const char *funcName = "minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::KSqueezedTextLabel::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KSqueezedTextLabel", funcName, gil, pyOverride);
}

void KSqueezedTextLabelWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KSqueezedTextLabel", funcName, gil, pyOverride, event);
}

void KSqueezedTextLabelWrapper::mouseMoveEvent(::QMouseEvent * ev)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::mouseMoveEvent(ev);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KSqueezedTextLabel", funcName, gil, pyOverride, ev);
}

void KSqueezedTextLabelWrapper::mousePressEvent(::QMouseEvent * ev)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::mousePressEvent(ev);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KSqueezedTextLabel", funcName, gil, pyOverride, ev);
}

void KSqueezedTextLabelWrapper::mouseReleaseEvent(::QMouseEvent * arg__1)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::KSqueezedTextLabel::mouseReleaseEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KSqueezedTextLabel", funcName, gil, pyOverride, arg__1);
}

void KSqueezedTextLabelWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KSqueezedTextLabel", funcName, gil, pyOverride, event);
}

bool KSqueezedTextLabelWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KSqueezedTextLabel", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * KSqueezedTextLabelWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KSqueezedTextLabel", funcName, gil, pyOverride);
}

void KSqueezedTextLabelWrapper::paintEvent(::QPaintEvent * arg__1)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::paintEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KSqueezedTextLabel", funcName, gil, pyOverride, arg__1);
}

::QPaintDevice * KSqueezedTextLabelWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KSqueezedTextLabel", funcName, gil, pyOverride, offset);
}

void KSqueezedTextLabelWrapper::resizeEvent(::QResizeEvent * arg__1)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::KSqueezedTextLabel::resizeEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KSqueezedTextLabel", funcName, gil, pyOverride, arg__1);
}

void KSqueezedTextLabelWrapper::setAlignment(::QFlags<Qt::AlignmentFlag> arg__1)
{
    static const char *funcName = "setAlignment";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::KSqueezedTextLabel::setAlignment(arg__1);
    }
    sbk_o_setAlignment("KSqueezedTextLabel", funcName, gil, pyOverride, arg__1);
}

void KSqueezedTextLabelWrapper::sbk_o_setAlignment(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QFlags<Qt::AlignmentFlag> arg__1)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_AlignmentFlag_IDX])))->flagsConverter, &arg__1)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_AlignmentFlag_IDX])))->flagsConverter, &arg__1)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KSqueezedTextLabelWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KSqueezedTextLabel", funcName, gil, pyOverride, visible);
}

::QPainter * KSqueezedTextLabelWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KSqueezedTextLabel", funcName, gil, pyOverride);
}

void KSqueezedTextLabelWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KSqueezedTextLabel", funcName, gil, pyOverride, event);
}

::QSize KSqueezedTextLabelWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::KSqueezedTextLabel::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KSqueezedTextLabel", funcName, gil, pyOverride);
}

void KSqueezedTextLabelWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KSqueezedTextLabel", funcName, gil, pyOverride, event);
}

void KSqueezedTextLabelWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KSqueezedTextLabel", funcName, gil, pyOverride, event);
}

void KSqueezedTextLabelWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSqueezedTextLabel_TypeF(), gil, funcName, m_PyMethodCache[48], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KSqueezedTextLabel", funcName, gil, pyOverride, event);
}

const QMetaObject *KSqueezedTextLabelWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KSqueezedTextLabel::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KSqueezedTextLabelWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KSqueezedTextLabel::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KSqueezedTextLabelWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KSqueezedTextLabelWrapper *>(this));
    }
    return KSqueezedTextLabel::qt_metacast(_clname);
}

KSqueezedTextLabelWrapper::~KSqueezedTextLabelWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KSqueezedTextLabel_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KSqueezedTextLabel_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KSqueezedTextLabel >()))
        return -1;

    KSqueezedTextLabelWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OO:KSqueezedTextLabel", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KSqueezedTextLabel::KSqueezedTextLabel(QWidget*=)
    // 1: KSqueezedTextLabel::KSqueezedTextLabel(QString,QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // KSqueezedTextLabel(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KSqueezedTextLabel(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // KSqueezedTextLabel(QString,QWidget*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1])))) {
            overloadId = 1; // KSqueezedTextLabel(QString,QWidget*)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KSqueezedTextLabel(QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWidget *cppArg0 = nullptr;
            if (pythonToCpp[0])
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KSqueezedTextLabel(QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KSqueezedTextLabelWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KSqueezedTextLabelWrapper(cppArg0);
                }

            }
            break;
        }
        case 1: // KSqueezedTextLabel(const QString &text, QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 1}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QWidget *cppArg1 = nullptr;
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KSqueezedTextLabel(QString,QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KSqueezedTextLabelWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KSqueezedTextLabelWrapper(cppArg0, cppArg1);
                }

            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KSqueezedTextLabel >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KSqueezedTextLabelFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSqueezedTextLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // clear()
        cppSelf->clear();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KSqueezedTextLabelFunc_contentsRect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSqueezedTextLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // contentsRect()const
        QRect cppResult = const_cast<const ::KSqueezedTextLabel *>(cppSelf)->contentsRect();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QRect_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSqueezedTextLabelFunc_contextMenuEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSqueezedTextLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::contextMenuEvent(QContextMenuEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QContextMenuEvent_IDX]), (pyArg)))) {
        overloadId = 0; // contextMenuEvent(QContextMenuEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "contextMenuEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QContextMenuEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // contextMenuEvent(QContextMenuEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KSqueezedTextLabel::contextMenuEvent(cppArg0)
                : cppSelf->contextMenuEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KSqueezedTextLabelFunc_fullText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSqueezedTextLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // fullText()const
        QString cppResult = const_cast<const ::KSqueezedTextLabel *>(cppSelf)->fullText();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSqueezedTextLabelFunc_isSqueezed(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSqueezedTextLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isSqueezed()const
        bool cppResult = const_cast<const ::KSqueezedTextLabel *>(cppSelf)->isSqueezed();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSqueezedTextLabelFunc_minimumSizeHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSqueezedTextLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // minimumSizeHint()const
        QSize cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const ::KSqueezedTextLabel *>(cppSelf)->::KSqueezedTextLabel::minimumSizeHint()
            : const_cast<const ::KSqueezedTextLabel *>(cppSelf)->minimumSizeHint();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSqueezedTextLabelFunc_mouseReleaseEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSqueezedTextLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::mouseReleaseEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QMouseEvent_IDX]), (pyArg)))) {
        overloadId = 0; // mouseReleaseEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "mouseReleaseEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // mouseReleaseEvent(QMouseEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KSqueezedTextLabel::mouseReleaseEvent(cppArg0)
                : cppSelf->mouseReleaseEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KSqueezedTextLabelFunc_resizeEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSqueezedTextLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::resizeEvent(QResizeEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QResizeEvent_IDX]), (pyArg)))) {
        overloadId = 0; // resizeEvent(QResizeEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "resizeEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QResizeEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // resizeEvent(QResizeEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KSqueezedTextLabel::resizeEvent(cppArg0)
                : cppSelf->resizeEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KSqueezedTextLabelFunc_setAlignment(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSqueezedTextLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KSqueezedTextLabel::setAlignment(QFlags<Qt::AlignmentFlag>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_AlignmentFlag_IDX])))->flagsConverter, (pyArg)))) {
        overloadId = 0; // setAlignment(QFlags<Qt::AlignmentFlag>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setAlignment", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX]);

    // Call function/method
    {
        ::QFlags<Qt::AlignmentFlag> cppArg0 = QFlags<Qt::AlignmentFlag>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setAlignment(QFlags<Qt::AlignmentFlag>)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KSqueezedTextLabel::setAlignment(cppArg0)
                : cppSelf->setAlignment(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KSqueezedTextLabelFunc_setIndent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSqueezedTextLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLabel::setIndent(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setIndent(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setIndent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setIndent(int)
            cppSelf->setIndent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KSqueezedTextLabelFunc_setMargin(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSqueezedTextLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLabel::setMargin(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setMargin(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setMargin", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setMargin(int)
            cppSelf->setMargin(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KSqueezedTextLabelFunc_setText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSqueezedTextLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLabel::setText(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setText(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setText", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setText(QString)
            cppSelf->setText(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KSqueezedTextLabelFunc_setTextElideMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSqueezedTextLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KSqueezedTextLabel::setTextElideMode(Qt::TextElideMode)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_TextElideMode_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setTextElideMode(Qt::TextElideMode)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setTextElideMode", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX]);

    // Call function/method
    {
        ::Qt::TextElideMode cppArg0{Qt::ElideLeft};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTextElideMode(Qt::TextElideMode)
            cppSelf->setTextElideMode(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KSqueezedTextLabelFunc_sizeHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSqueezedTextLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // sizeHint()const
        QSize cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const ::KSqueezedTextLabel *>(cppSelf)->::KSqueezedTextLabel::sizeHint()
            : const_cast<const ::KSqueezedTextLabel *>(cppSelf)->sizeHint();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSqueezedTextLabelFunc_squeezeTextToLabel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSqueezedTextLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // squeezeTextToLabel()
        cppSelf->squeezeTextToLabel();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KSqueezedTextLabelFunc_textElideMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSqueezedTextLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // textElideMode()const
        Qt::TextElideMode cppResult = const_cast<const ::KSqueezedTextLabel *>(cppSelf)->textElideMode();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_TextElideMode_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KSqueezedTextLabel_PropertyStrings[] = {
    "indent::",
    "margin::",
    "textElideMode::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KSqueezedTextLabel_methods[] = {
    {"clear", reinterpret_cast<PyCFunction>(Sbk_KSqueezedTextLabelFunc_clear), METH_NOARGS, nullptr},
    {"contentsRect", reinterpret_cast<PyCFunction>(Sbk_KSqueezedTextLabelFunc_contentsRect), METH_NOARGS, nullptr},
    {"contextMenuEvent", reinterpret_cast<PyCFunction>(Sbk_KSqueezedTextLabelFunc_contextMenuEvent), METH_O, nullptr},
    {"fullText", reinterpret_cast<PyCFunction>(Sbk_KSqueezedTextLabelFunc_fullText), METH_NOARGS, nullptr},
    {"isSqueezed", reinterpret_cast<PyCFunction>(Sbk_KSqueezedTextLabelFunc_isSqueezed), METH_NOARGS, nullptr},
    {"minimumSizeHint", reinterpret_cast<PyCFunction>(Sbk_KSqueezedTextLabelFunc_minimumSizeHint), METH_NOARGS, nullptr},
    {"mouseReleaseEvent", reinterpret_cast<PyCFunction>(Sbk_KSqueezedTextLabelFunc_mouseReleaseEvent), METH_O, nullptr},
    {"resizeEvent", reinterpret_cast<PyCFunction>(Sbk_KSqueezedTextLabelFunc_resizeEvent), METH_O, nullptr},
    {"setAlignment", reinterpret_cast<PyCFunction>(Sbk_KSqueezedTextLabelFunc_setAlignment), METH_O, nullptr},
    {"setIndent", reinterpret_cast<PyCFunction>(Sbk_KSqueezedTextLabelFunc_setIndent), METH_O, nullptr},
    {"setMargin", reinterpret_cast<PyCFunction>(Sbk_KSqueezedTextLabelFunc_setMargin), METH_O, nullptr},
    {"setText", reinterpret_cast<PyCFunction>(Sbk_KSqueezedTextLabelFunc_setText), METH_O, nullptr},
    {"setTextElideMode", reinterpret_cast<PyCFunction>(Sbk_KSqueezedTextLabelFunc_setTextElideMode), METH_O, nullptr},
    {"sizeHint", reinterpret_cast<PyCFunction>(Sbk_KSqueezedTextLabelFunc_sizeHint), METH_NOARGS, nullptr},
    {"squeezeTextToLabel", reinterpret_cast<PyCFunction>(Sbk_KSqueezedTextLabelFunc_squeezeTextToLabel), METH_NOARGS, nullptr},
    {"textElideMode", reinterpret_cast<PyCFunction>(Sbk_KSqueezedTextLabelFunc_textElideMode), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KSqueezedTextLabel_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KSqueezedTextLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KSqueezedTextLabelWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KSqueezedTextLabel_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KSqueezedTextLabel_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KSqueezedTextLabelSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KSqueezedTextLabel *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QLabel_IDX]))
        return static_cast< ::QLabel *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QFrame_IDX]))
        return static_cast< ::QFrame *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KSqueezedTextLabel_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KSqueezedTextLabel_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KSqueezedTextLabel_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KSqueezedTextLabel_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KSqueezedTextLabel_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KSqueezedTextLabel_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KSqueezedTextLabel_spec = {
    "1:KWidgetsAddons.KSqueezedTextLabel",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KSqueezedTextLabel_slots
};

} //extern "C"

static void *Sbk_KSqueezedTextLabel_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KSqueezedTextLabel *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KSqueezedTextLabel *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KSqueezedTextLabel *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KSqueezedTextLabel_PythonToCpp_KSqueezedTextLabel_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KSqueezedTextLabel_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KSqueezedTextLabel_PythonToCpp_KSqueezedTextLabel_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KSqueezedTextLabel_TypeF()))
        return KSqueezedTextLabel_PythonToCpp_KSqueezedTextLabel_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KSqueezedTextLabel_PTR_CppToPython_KSqueezedTextLabel(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KSqueezedTextLabel *>(const_cast<void *>(cppIn)), Sbk_KSqueezedTextLabel_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KSqueezedTextLabel_SignatureStrings[] = {
    "1:KWidgetsAddons.KSqueezedTextLabel(self,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,textElideMode:PySide6.QtCore.Qt.TextElideMode=None,indent:int=None,margin:int=None)",
    "0:KWidgetsAddons.KSqueezedTextLabel(self,text:QString,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,textElideMode:PySide6.QtCore.Qt.TextElideMode=None,indent:int=None,margin:int=None)",
    "KWidgetsAddons.KSqueezedTextLabel.clear(self)",
    "KWidgetsAddons.KSqueezedTextLabel.contentsRect(self)->PySide6.QtCore.QRect",
    "KWidgetsAddons.KSqueezedTextLabel.contextMenuEvent(self,arg__1:PySide6.QtGui.QContextMenuEvent)",
    "KWidgetsAddons.KSqueezedTextLabel.fullText(self)->QString",
    "KWidgetsAddons.KSqueezedTextLabel.isSqueezed(self)->bool",
    "KWidgetsAddons.KSqueezedTextLabel.minimumSizeHint(self)->PySide6.QtCore.QSize",
    "KWidgetsAddons.KSqueezedTextLabel.mouseReleaseEvent(self,arg__1:PySide6.QtGui.QMouseEvent)",
    "KWidgetsAddons.KSqueezedTextLabel.resizeEvent(self,arg__1:PySide6.QtGui.QResizeEvent)",
    "KWidgetsAddons.KSqueezedTextLabel.setAlignment(self,arg__1:PySide6.QtCore.Qt.AlignmentFlag)",
    "KWidgetsAddons.KSqueezedTextLabel.setIndent(self,indent:int)",
    "KWidgetsAddons.KSqueezedTextLabel.setMargin(self,margin:int)",
    "KWidgetsAddons.KSqueezedTextLabel.setText(self,text:QString)",
    "KWidgetsAddons.KSqueezedTextLabel.setTextElideMode(self,mode:PySide6.QtCore.Qt.TextElideMode)",
    "KWidgetsAddons.KSqueezedTextLabel.sizeHint(self)->PySide6.QtCore.QSize",
    "KWidgetsAddons.KSqueezedTextLabel.squeezeTextToLabel(self)",
    "KWidgetsAddons.KSqueezedTextLabel.textElideMode(self)->PySide6.QtCore.Qt.TextElideMode",
    nullptr}; // Sentinel
#else
static constexpr size_t KSqueezedTextLabel_SignatureByteSize = 356;
static constexpr uint8_t KSqueezedTextLabel_SignatureBytes[356] = {
    0x78, 0xda, 0xcd, 0x54, 0xcb, 0x4e, 0xc3, 0x30, 0x10, 0xbc, 0xf7, 0x4b, 0x00, 0x85, 0x88, 0x5e,
    0x38, 0x44, 0x2a, 0x52, 0x55, 0x95, 0x87, 0x4a, 0x80, 0x34, 0x95, 0x38, 0x56, 0x69, 0xbd, 0x8d,
    0x2c, 0x39, 0xeb, 0x62, 0x3b, 0xd0, 0xf6, 0xeb, 0xb1, 0xeb, 0xe6, 0x41, 0xa1, 0xca, 0x22, 0x71,
    0xe0, 0x94, 0x78, 0xbd, 0x33, 0x9e, 0x59, 0xef, 0xba, 0x1f, 0x4d, 0x5e, 0x39, 0xcb, 0xc1, 0xe8,
    0x21, 0x63, 0x12, 0x75, 0x38, 0x49, 0xdf, 0x4a, 0x80, 0x1d, 0xb0, 0x19, 0x6c, 0xcc, 0x63, 0xb6,
    0x00, 0x71, 0xa6, 0x41, 0xac, 0x82, 0x75, 0xa6, 0x00, 0x4d, 0xf4, 0xb2, 0x4d, 0x39, 0x83, 0xeb,
    0x30, 0x31, 0x07, 0x58, 0x98, 0xf8, 0x9f, 0x01, 0x96, 0x42, 0xac, 0x8d, 0x0a, 0x2e, 0xa2, 0x09,
    0x6c, 0x3f, 0xa4, 0x62, 0xcf, 0x28, 0xb6, 0x83, 0x27, 0x89, 0x10, 0x18, 0x4b, 0x35, 0x16, 0x16,
    0x17, 0x4b, 0x06, 0x2d, 0x8a, 0x91, 0x54, 0x60, 0x3f, 0xe1, 0xac, 0xbd, 0xef, 0x21, 0x1c, 0x99,
    0x3b, 0x8e, 0xa3, 0xf1, 0xeb, 0x22, 0x53, 0x39, 0xc7, 0x7a, 0x7d, 0xde, 0xbb, 0xa2, 0x0a, 0x77,
    0x87, 0x47, 0x49, 0x6a, 0x14, 0xc7, 0xfc, 0xdf, 0xb9, 0xe8, 0xf4, 0x10, 0x2e, 0x05, 0x64, 0x6a,
    0xef, 0x84, 0x94, 0x2d, 0xd1, 0xd8, 0x13, 0xf5, 0x14, 0x96, 0xc6, 0x83, 0x2e, 0x6f, 0x8e, 0x95,
    0xba, 0x3d, 0x2a, 0xd5, 0xc6, 0xc4, 0x80, 0xe5, 0xf8, 0xdd, 0x72, 0xfa, 0x6a, 0x5a, 0x03, 0xf3,
    0x79, 0xbf, 0xe5, 0xfe, 0xae, 0xe4, 0x61, 0x32, 0x3a, 0xca, 0xa5, 0x48, 0x5d, 0xd9, 0x4a, 0xbb,
    0x55, 0x25, 0xf3, 0x70, 0x45, 0x04, 0x24, 0xd7, 0x55, 0xac, 0xc2, 0x2e, 0xa4, 0x14, 0x04, 0x60,
    0xc1, 0x91, 0x17, 0x65, 0x91, 0xf2, 0x1d, 0xdc, 0x73, 0x3c, 0x59, 0x20, 0xb7, 0x4f, 0x61, 0x93,
    0xa5, 0x86, 0x29, 0xd8, 0xfb, 0xd1, 0xd0, 0x59, 0xa1, 0xd8, 0x25, 0x93, 0x6b, 0xa3, 0x40, 0x5b,
    0x0d, 0x9d, 0xa4, 0xd3, 0x26, 0x8d, 0xc2, 0xaa, 0xc1, 0x0c, 0x05, 0xcf, 0xb1, 0x38, 0x4d, 0x5b,
    0xf5, 0x72, 0x9d, 0x77, 0x2b, 0xb2, 0x9c, 0xc8, 0xfd, 0xb0, 0x6f, 0x76, 0x4f, 0xdc, 0x34, 0x3e,
    0x11, 0x1c, 0xef, 0x27, 0xc3, 0x83, 0x9b, 0x29, 0x21, 0x82, 0xeb, 0x36, 0xfa, 0x32, 0xec, 0xbf,
    0x00, 0xd7, 0x63, 0x7b, 0x10, 0x40, 0x18, 0x70, 0x12, 0xfb, 0xdf, 0x34, 0x9a, 0xf6, 0x11, 0x17,
    0x98, 0xc9, 0xe6, 0x65, 0xa3, 0x28, 0x30, 0xdf, 0xcc, 0xfd, 0x20, 0xe3, 0xc8, 0x59, 0xef, 0x13,
    0x71, 0x14, 0x3e, 0x13
};
#endif

PyTypeObject *init_KSqueezedTextLabel(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX].type;

    Shiboken::AutoDecRef Sbk_KSqueezedTextLabel_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QLabel_IDX]))));

    _Sbk_KSqueezedTextLabel_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KSqueezedTextLabel",
        "KSqueezedTextLabel*",
        &Sbk_KSqueezedTextLabel_spec,
        &Shiboken::callCppDestructor< KSqueezedTextLabel >,
        Sbk_KSqueezedTextLabel_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_KSqueezedTextLabel_Type; // references _Sbk_KSqueezedTextLabel_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KSqueezedTextLabel_SignatureStrings);
#else
    InitSignatureBytes(pyType, KSqueezedTextLabel_SignatureBytes, KSqueezedTextLabel_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KSqueezedTextLabel_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KSqueezedTextLabel_PythonToCpp_KSqueezedTextLabel_PTR,
        is_KSqueezedTextLabel_PythonToCpp_KSqueezedTextLabel_PTR_Convertible,
        KSqueezedTextLabel_PTR_CppToPython_KSqueezedTextLabel);

    Shiboken::Conversions::registerConverterName(converter, "KSqueezedTextLabel");
    Shiboken::Conversions::registerConverterName(converter, "KSqueezedTextLabel*");
    Shiboken::Conversions::registerConverterName(converter, "KSqueezedTextLabel&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KSqueezedTextLabel).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KSqueezedTextLabelWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KSqueezedTextLabel_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KSqueezedTextLabel_TypeF(), &Sbk_KSqueezedTextLabelSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KSqueezedTextLabel_TypeF(), &Sbk_KSqueezedTextLabel_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KSqueezedTextLabel::staticMetaObject, sizeof(KSqueezedTextLabelWrapper));

    return pyType;
}
