
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kjobwidgets_python.h"

// main header
#include "kdialogjobuidelegate_wrapper.h"

// Wrappers providing overrides
#include "knotificationjobuidelegate_wrapper.h"

// Argument includes
#include <QString>
#include <kjob.h>
#include <qobject.h>
#include <qobjectdefs.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KDialogJobUiDelegate_Type = nullptr;
static PyTypeObject *Sbk_KDialogJobUiDelegate_TypeF(void)
{
    return _Sbk_KDialogJobUiDelegate_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KDialogJobUiDelegateWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KDialogJobUiDelegateWrapper::KDialogJobUiDelegateWrapper()
{
}

KDialogJobUiDelegateWrapper::KDialogJobUiDelegateWrapper(::QFlags<KJobUiDelegate::Flag> flags, ::QWidget * window) : KDialogJobUiDelegate(flags, window)
{
}

void KDialogJobUiDelegateWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDialogJobUiDelegate_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_childEvent("KDialogJobUiDelegate", funcName, gil, pyOverride, event);
}

void KDialogJobUiDelegateWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDialogJobUiDelegate_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_connectNotify("KDialogJobUiDelegate", funcName, gil, pyOverride, signal);
}

void KDialogJobUiDelegateWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDialogJobUiDelegate_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_customEvent("KDialogJobUiDelegate", funcName, gil, pyOverride, event);
}

void KDialogJobUiDelegateWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDialogJobUiDelegate_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_connectNotify("KDialogJobUiDelegate", funcName, gil, pyOverride, signal);
}

bool KDialogJobUiDelegateWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDialogJobUiDelegate_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return KNotificationJobUiDelegateWrapper::sbk_o_event("KDialogJobUiDelegate", funcName, gil, pyOverride, event);
}

bool KDialogJobUiDelegateWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDialogJobUiDelegate_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KNotificationJobUiDelegateWrapper::sbk_o_eventFilter("KDialogJobUiDelegate", funcName, gil, pyOverride, watched, event);
}

bool KDialogJobUiDelegateWrapper::setJob(::KJob * job)
{
    static const char *funcName = "setJob";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDialogJobUiDelegate_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::KDialogJobUiDelegate::setJob(job);
    }
    return KNotificationJobUiDelegateWrapper::sbk_o_setJob("KDialogJobUiDelegate", funcName, gil, pyOverride, job);
}

void KDialogJobUiDelegateWrapper::setWindow(::QWidget * window)
{
    static const char *funcName = "setWindow";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDialogJobUiDelegate_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::KDialogJobUiDelegate::setWindow(window);
    }
    sbk_o_setWindow("KDialogJobUiDelegate", funcName, gil, pyOverride, window);
}

void KDialogJobUiDelegateWrapper::sbk_o_setWindow(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QWidget * window)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), window)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), window)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KDialogJobUiDelegateWrapper::showErrorMessage()
{
    static const char *funcName = "showErrorMessage";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDialogJobUiDelegate_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::KDialogJobUiDelegate::showErrorMessage();
    }
    KNotificationJobUiDelegateWrapper::sbk_o_showErrorMessage("KDialogJobUiDelegate", funcName, gil, pyOverride);
}

void KDialogJobUiDelegateWrapper::slotWarning(::KJob * job, const ::QString & message)
{
    static const char *funcName = "slotWarning";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDialogJobUiDelegate_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::KDialogJobUiDelegate::slotWarning(job, message);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_slotWarning("KDialogJobUiDelegate", funcName, gil, pyOverride, job, message);
}

void KDialogJobUiDelegateWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDialogJobUiDelegate_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_timerEvent("KDialogJobUiDelegate", funcName, gil, pyOverride, event);
}

const QMetaObject *KDialogJobUiDelegateWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KDialogJobUiDelegate::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KDialogJobUiDelegateWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KDialogJobUiDelegate::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KDialogJobUiDelegateWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KDialogJobUiDelegateWrapper *>(this));
    }
    return KDialogJobUiDelegate::qt_metacast(_clname);
}

KDialogJobUiDelegateWrapper::~KDialogJobUiDelegateWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KDialogJobUiDelegate_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KDialogJobUiDelegate_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KDialogJobUiDelegate >()))
        return -1;

    KDialogJobUiDelegateWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    if (numArgs == 1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKJobWidgetsTypeStructs[SBK_KDialogJobUiDelegate_IDX]);

    if (PyArg_UnpackTuple(args, "KDialogJobUiDelegate", 0, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KDialogJobUiDelegate::KDialogJobUiDelegate()
    // 1: KDialogJobUiDelegate::KDialogJobUiDelegate(QFlags<KJobUiDelegate::Flag>,QWidget*)
    if (numArgs == 0) {
        overloadId = 0; // KDialogJobUiDelegate()
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_QFlags_KJobUiDelegate_Flag_IDX])))->flagsConverter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1])))) {
        overloadId = 1; // KDialogJobUiDelegate(QFlags<KJobUiDelegate::Flag>,QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKJobWidgetsTypeStructs[SBK_KDialogJobUiDelegate_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKJobWidgetsTypeStructs[SBK_KDialogJobUiDelegate_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KDialogJobUiDelegate()
        {

            // KDialogJobUiDelegate()
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KDialogJobUiDelegateWrapper();
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KDialogJobUiDelegateWrapper();
            }

            break;
        }
        case 1: // KDialogJobUiDelegate(QFlags<KJobUiDelegate::Flag> flags, QWidget *window)
        {
            ::QFlags<KJobUiDelegate::Flag> cppArg0 = QFlags<KJobUiDelegate::Flag>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QWidget *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KDialogJobUiDelegate(QFlags<KJobUiDelegate::Flag>,QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KDialogJobUiDelegateWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KDialogJobUiDelegateWrapper(cppArg0, cppArg1);
                }

            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KDialogJobUiDelegate >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKJobWidgetsTypeStructs[SBK_KDialogJobUiDelegate_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKJobWidgetsTypeStructs[SBK_KDialogJobUiDelegate_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KDialogJobUiDelegateFunc_setJob(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDialogJobUiDelegate *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KDialogJobUiDelegate_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJobUiDelegate::setJob(KJob*)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // setJob(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setJob", errInfo, SbkKJobWidgetsTypeStructs[SBK_KDialogJobUiDelegate_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setJob(KJob*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KDialogJobUiDelegate::setJob(cppArg0)
                : cppSelf->setJob(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDialogJobUiDelegateFunc_setWindow(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDialogJobUiDelegate *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KDialogJobUiDelegate_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDialogJobUiDelegate::setWindow(QWidget*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArg)))) {
        overloadId = 0; // setWindow(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setWindow", errInfo, SbkKJobWidgetsTypeStructs[SBK_KDialogJobUiDelegate_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setWindow(QWidget*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KDialogJobUiDelegate::setWindow(cppArg0)
                : cppSelf->setWindow(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDialogJobUiDelegateFunc_showErrorMessage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDialogJobUiDelegate *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KDialogJobUiDelegate_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // showErrorMessage()
        Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::KDialogJobUiDelegate::showErrorMessage()
            : cppSelf->showErrorMessage();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDialogJobUiDelegateFunc_slotWarning(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDialogJobUiDelegate *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KDialogJobUiDelegate_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "slotWarning", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJobUiDelegate::slotWarning(KJob*,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // slotWarning(KJob*,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "slotWarning", errInfo, SbkKJobWidgetsTypeStructs[SBK_KDialogJobUiDelegate_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // slotWarning(KJob*,QString)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KDialogJobUiDelegate::slotWarning(cppArg0, cppArg1)
                : cppSelf->slotWarning(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDialogJobUiDelegateFunc_updateUserTimestamp(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDialogJobUiDelegate *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KDialogJobUiDelegate_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDialogJobUiDelegate::updateUserTimestamp(ulong)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), (pyArg)))) {
        overloadId = 0; // updateUserTimestamp(ulong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "updateUserTimestamp", errInfo, SbkKJobWidgetsTypeStructs[SBK_KDialogJobUiDelegate_IDX]);

    // Call function/method
    {
        unsigned long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // updateUserTimestamp(ulong)
            cppSelf->updateUserTimestamp(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDialogJobUiDelegateFunc_userTimestamp(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDialogJobUiDelegate *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KDialogJobUiDelegate_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // userTimestamp()const
        unsigned long cppResult = const_cast<const ::KDialogJobUiDelegate *>(cppSelf)->userTimestamp();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDialogJobUiDelegateFunc_window(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDialogJobUiDelegate *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KDialogJobUiDelegate_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // window()const
        QWidget * cppResult = const_cast<const ::KDialogJobUiDelegate *>(cppSelf)->window();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KDialogJobUiDelegate_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KDialogJobUiDelegate_methods[] = {
    {"setJob", reinterpret_cast<PyCFunction>(Sbk_KDialogJobUiDelegateFunc_setJob), METH_O, nullptr},
    {"setWindow", reinterpret_cast<PyCFunction>(Sbk_KDialogJobUiDelegateFunc_setWindow), METH_O, nullptr},
    {"showErrorMessage", reinterpret_cast<PyCFunction>(Sbk_KDialogJobUiDelegateFunc_showErrorMessage), METH_NOARGS, nullptr},
    {"slotWarning", reinterpret_cast<PyCFunction>(Sbk_KDialogJobUiDelegateFunc_slotWarning), METH_VARARGS, nullptr},
    {"updateUserTimestamp", reinterpret_cast<PyCFunction>(Sbk_KDialogJobUiDelegateFunc_updateUserTimestamp), METH_O, nullptr},
    {"userTimestamp", reinterpret_cast<PyCFunction>(Sbk_KDialogJobUiDelegateFunc_userTimestamp), METH_NOARGS, nullptr},
    {"window", reinterpret_cast<PyCFunction>(Sbk_KDialogJobUiDelegateFunc_window), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KDialogJobUiDelegate_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KDialogJobUiDelegate *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KDialogJobUiDelegate_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KDialogJobUiDelegateWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KDialogJobUiDelegate_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KDialogJobUiDelegate_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KDialogJobUiDelegate_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KDialogJobUiDelegate_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KDialogJobUiDelegate_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KDialogJobUiDelegate_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KDialogJobUiDelegate_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KDialogJobUiDelegate_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KDialogJobUiDelegate_spec = {
    "1:KJobWidgets.KDialogJobUiDelegate",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KDialogJobUiDelegate_slots
};

} //extern "C"

static void *Sbk_KDialogJobUiDelegate_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KDialogJobUiDelegate *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KDialogJobUiDelegate_PythonToCpp_KDialogJobUiDelegate_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KDialogJobUiDelegate_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KDialogJobUiDelegate_PythonToCpp_KDialogJobUiDelegate_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KDialogJobUiDelegate_TypeF()))
        return KDialogJobUiDelegate_PythonToCpp_KDialogJobUiDelegate_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KDialogJobUiDelegate_PTR_CppToPython_KDialogJobUiDelegate(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KDialogJobUiDelegate *>(const_cast<void *>(cppIn)), Sbk_KDialogJobUiDelegate_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KDialogJobUiDelegate_SignatureStrings[] = {
    "1:KJobWidgets.KDialogJobUiDelegate(self)",
    "0:KJobWidgets.KDialogJobUiDelegate(self,flags:KCoreAddons.KJobUiDelegate.Flag,window:PySide6.QtWidgets.QWidget)",
    "KJobWidgets.KDialogJobUiDelegate.setJob(self,job:KCoreAddons.KJob)->bool",
    "KJobWidgets.KDialogJobUiDelegate.setWindow(self,window:PySide6.QtWidgets.QWidget)",
    "KJobWidgets.KDialogJobUiDelegate.showErrorMessage(self)",
    "KJobWidgets.KDialogJobUiDelegate.slotWarning(self,job:KCoreAddons.KJob,message:QString)",
    "KJobWidgets.KDialogJobUiDelegate.updateUserTimestamp(self,time:unsigned long)",
    "KJobWidgets.KDialogJobUiDelegate.userTimestamp(self)->unsigned long",
    "KJobWidgets.KDialogJobUiDelegate.window(self)->PySide6.QtWidgets.QWidget",
    nullptr}; // Sentinel
#else
static constexpr size_t KDialogJobUiDelegate_SignatureByteSize = 218;
static constexpr uint8_t KDialogJobUiDelegate_SignatureBytes[218] = {
    0x78, 0xda, 0xad, 0x90, 0x3f, 0x0b, 0xc2, 0x30, 0x10, 0xc5, 0xf7, 0x7e, 0x0a, 0x47, 0x0b, 0xb5,
    0xe8, 0xe2, 0x90, 0x41, 0x10, 0xff, 0x0c, 0x16, 0xc1, 0x52, 0xa5, 0x73, 0x4a, 0xce, 0x18, 0x49,
    0x73, 0x25, 0x49, 0x29, 0x7e, 0x7b, 0x0f, 0x43, 0x11, 0x11, 0x69, 0x07, 0xa7, 0x24, 0xc7, 0x7b,
    0xbf, 0x77, 0x79, 0x0b, 0x96, 0x1d, 0xb0, 0x2a, 0x95, 0x90, 0xe0, 0x5d, 0x9a, 0x6d, 0x15, 0xd7,
    0x28, 0x69, 0x72, 0x51, 0x5b, 0xd0, 0x20, 0xb9, 0x87, 0xa9, 0x03, 0x7d, 0x8d, 0xa3, 0xf9, 0x38,
    0x61, 0x72, 0xd5, 0x5c, 0x3a, 0x96, 0x6d, 0xd0, 0xc2, 0x5a, 0x08, 0x34, 0xa4, 0xfd, 0x50, 0xa5,
    0x7b, 0x12, 0x24, 0x9d, 0x32, 0x02, 0x3b, 0x76, 0x7a, 0x14, 0x4a, 0xc0, 0x32, 0xcd, 0x7d, 0x0f,
    0xce, 0xc3, 0x25, 0x8e, 0x86, 0xd2, 0x52, 0x07, 0x9e, 0x06, 0x21, 0xf4, 0x8e, 0xd5, 0x57, 0x64,
    0x3c, 0x5b, 0x55, 0x88, 0x7a, 0x14, 0xa8, 0x7c, 0xad, 0x13, 0x58, 0xff, 0x58, 0xed, 0x86, 0xdd,
    0xce, 0x5a, 0xb4, 0x47, 0x70, 0x8e, 0xcb, 0xbe, 0xc2, 0x61, 0x9f, 0x46, 0x5f, 0x72, 0x6b, 0x94,
    0x91, 0xbf, 0xff, 0x95, 0xd4, 0x01, 0xca, 0xf2, 0xc2, 0x5b, 0x52, 0x8e, 0xe0, 0xb6, 0x8d, 0xa0,
    0xe3, 0xe2, 0xc0, 0x9e, 0x15, 0xb9, 0x3d, 0xaf, 0x9b, 0xc0, 0xf7, 0xf4, 0x64, 0xad, 0x71, 0x4a,
    0x1a, 0x10, 0x13, 0x8d, 0xe3, 0x68, 0x5f, 0x1c, 0xaa, 0xfa, 0x03, 0x32, 0xcc, 0xe8, 0xde, 0x85,
    0x93, 0xf9, 0x67, 0xd7, 0xd1, 0x13, 0xa7, 0xd0, 0xf4, 0xba
};
#endif

PyTypeObject *init_KDialogJobUiDelegate(PyObject *module)
{
    if (SbkKJobWidgetsTypeStructs[SBK_KDialogJobUiDelegate_IDX].type != nullptr)
        return SbkKJobWidgetsTypeStructs[SBK_KDialogJobUiDelegate_IDX].type;

    Shiboken::AutoDecRef Sbk_KDialogJobUiDelegate_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJobUiDelegate_IDX]))));

    _Sbk_KDialogJobUiDelegate_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KDialogJobUiDelegate",
        "KDialogJobUiDelegate*",
        &Sbk_KDialogJobUiDelegate_spec,
        &Shiboken::callCppDestructor< KDialogJobUiDelegate >,
        Sbk_KDialogJobUiDelegate_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KDialogJobUiDelegate_Type; // references _Sbk_KDialogJobUiDelegate_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KDialogJobUiDelegate_SignatureStrings);
#else
    InitSignatureBytes(pyType, KDialogJobUiDelegate_SignatureBytes, KDialogJobUiDelegate_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KDialogJobUiDelegate_PropertyStrings);
    SbkKJobWidgetsTypeStructs[SBK_KDialogJobUiDelegate_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KDialogJobUiDelegate_PythonToCpp_KDialogJobUiDelegate_PTR,
        is_KDialogJobUiDelegate_PythonToCpp_KDialogJobUiDelegate_PTR_Convertible,
        KDialogJobUiDelegate_PTR_CppToPython_KDialogJobUiDelegate);

    Shiboken::Conversions::registerConverterName(converter, "KDialogJobUiDelegate");
    Shiboken::Conversions::registerConverterName(converter, "KDialogJobUiDelegate*");
    Shiboken::Conversions::registerConverterName(converter, "KDialogJobUiDelegate&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KDialogJobUiDelegate).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KDialogJobUiDelegateWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KDialogJobUiDelegate_TypeF(), &Sbk_KDialogJobUiDelegate_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KDialogJobUiDelegate::staticMetaObject, sizeof(KDialogJobUiDelegateWrapper));

    return pyType;
}
