/* Autogenerated file, DO NOT EDIT manually! generated by perf-metricset-codegen.py
 *
 * Copyright (c) 2018 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#include <stddef.h>
#include <stdint.h>
#include <stdlib.h>
#include <stdbool.h>
#include <assert.h>

#include "i915_drm.h"

#include "i915_perf_metrics_hsw.h"
#include "i915_perf_equations.h"
#include "i915_perf_registers_hsw.h"

static bool hsw_render_basic_LlcAccesses_availability(const struct intel_perf *perf) {
    if (true &&
        perf->devinfo.query_mode) {
        return true;
    }
    return false;
}
static bool hsw_render_basic_LlcGpuThroughput_availability(const struct intel_perf *perf) {
    if (true &&
        perf->devinfo.query_mode) {
        return true;
    }
    return false;
}
static bool hsw_render_basic_LlcHits_availability(const struct intel_perf *perf) {
    if (true &&
        perf->devinfo.query_mode) {
        return true;
    }
    return false;
}
static bool hsw_render_basic_Sampler0Bottleneck_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x1) {
        return true;
    }
    return false;
}
static bool hsw_render_basic_Sampler0Busy_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x1) {
        return true;
    }
    return false;
}
static bool hsw_render_basic_Sampler0Texels_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x1) {
        return true;
    }
    return false;
}
static bool hsw_render_basic_Sampler1Bottleneck_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x2) {
        return true;
    }
    return false;
}
static bool hsw_render_basic_Sampler1Busy_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x2) {
        return true;
    }
    return false;
}
static bool hsw_render_basic_Sampler1Texels_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x2) {
        return true;
    }
    return false;
}

static void
hsw_add_render_basic_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics Basic set";
    metric_set->symbol_name = "RenderBasic";
    metric_set->hw_config_guid = "a490e9d2-55b3-4db0-8dab-53011032c5f3";
    metric_set->counters = calloc(70, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A45_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->a_offset = 1;
    metric_set->b_offset = metric_set->a_offset + 45;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    hsw_render_basic_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "Alpha Test Fails",
                .symbol_name = "AlphaTestFails",
                .desc = "The total number of pixels dropped on post-FS alpha test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__render_basic__alpha_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = hsw__render_basic__avg_gpu_core_frequency__read,
                .max_uint64 = hsw__render_basic__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Duration",
                .symbol_name = "CsDuration",
                .desc = "Total Compute Shader GPU duration.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_US,
                .read_uint64 = hsw__render_basic__cs_duration__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "CS EU Active",
                .symbol_name = "CsEuActive",
                .desc = "The percentage of time in which compute shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__render_basic__cs_eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "CS AVG Active per Thread",
                .symbol_name = "CsEuActivePerThread",
                .desc = "The average number of cycles per hardware thread run in which compute shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__render_basic__cs_eu_active_per_thread__read,
                .max_uint64 = percentage_max_callback_uint64,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "CS EU Stall",
                .symbol_name = "CsEuStall",
                .desc = "The percentage of time in which compute shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__render_basic__cs_eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "CS AVG Stall per Thread",
                .symbol_name = "CsEuStallPerThread",
                .desc = "The average number of cycles per hardware thread run in which compute shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__render_basic__cs_eu_stall_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = hsw__render_basic__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "TES Duration",
                .symbol_name = "DsDuration",
                .desc = "Total Evaluation Shader GPU duration.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_US,
                .read_uint64 = hsw__render_basic__ds_duration__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Evaluation Shader",
            },

            {
                .name = "TES EU Active",
                .symbol_name = "DsEuActive",
                .desc = "The percentage of time in which evaluation shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__render_basic__ds_eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Evaluation Shader",
            },

            {
                .name = "TES AVG Active per Thread",
                .symbol_name = "DsEuActivePerThread",
                .desc = "The average number of cycles per hardware thread run in which evaluation shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__render_basic__ds_eu_active_per_thread__read,
                .max_uint64 = percentage_max_callback_uint64,
                .group = "EU Array/Evaluation Shader",
            },

            {
                .name = "TES EU Stall",
                .symbol_name = "DsEuStall",
                .desc = "The percentage of time in which evaluation shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__render_basic__ds_eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Evaluation Shader",
            },

            {
                .name = "TES AVG Stall per Thread",
                .symbol_name = "DsEuStallPerThread",
                .desc = "The average number of cycles per hardware thread run in which evaluation shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__render_basic__ds_eu_stall_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Evaluation Shader",
            },

            {
                .name = "TES Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of evaluation shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = hsw__render_basic__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Evaluation Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__render_basic__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__render_basic__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Idle",
                .symbol_name = "EuIdle",
                .desc = "The percentage of time in which the Execution Units were idle.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__render_basic__eu_idle__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__render_basic__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has being processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__render_basic__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__render_basic__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = hsw__render_basic__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Duration",
                .symbol_name = "GsDuration",
                .desc = "Total Geometry Shader GPU duration.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_US,
                .read_uint64 = hsw__render_basic__gs_duration__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GS EU Active",
                .symbol_name = "GsEuActive",
                .desc = "The percentage of time in which geometry shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__render_basic__gs_eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GS AVG Active per Thread",
                .symbol_name = "GsEuActivePerThread",
                .desc = "The average number of cycles per hardware thread run in which geometry shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__render_basic__gs_eu_active_per_thread__read,
                .max_uint64 = percentage_max_callback_uint64,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GS EU Stall",
                .symbol_name = "GsEuStall",
                .desc = "The percentage of time in which geometry shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__render_basic__gs_eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GS AVG Stall per Thread",
                .symbol_name = "GsEuStallPerThread",
                .desc = "The average number of cycles per hardware thread run in which geometry shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__render_basic__gs_eu_stall_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = hsw__render_basic__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GTI Depth Throughput",
                .symbol_name = "GtiDepthThroughput",
                .desc = "The total number of GPU memory bytes transferred between depth caches and GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = hsw__render_basic__gti_depth_throughput__read,
                .max_uint64 = hsw__render_basic__gti_depth_throughput__max,
                .group = "GTI/Depth Cache",
            },

            {
                .name = "GTI L3 Throughput",
                .symbol_name = "GtiL3Throughput",
                .desc = "The total number of GPU memory bytes transferred between L3 caches and GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = hsw__render_basic__gti_l3_throughput__read,
                .max_uint64 = hsw__render_basic__gti_l3_throughput__max,
                .group = "GTI/L3",
            },

            {
                .name = "GTI RCC Throughput",
                .symbol_name = "GtiRccThroughput",
                .desc = "The total number of GPU memory bytes transferred between render color caches and GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = hsw__render_basic__gti_rcc_throughput__read,
                .max_uint64 = hsw__render_basic__gti_rcc_throughput__max,
                .group = "GTI/Color Cache",
            },

            {
                .name = "GTI Read Throughput",
                .symbol_name = "GtiReadThroughput",
                .desc = "The total number of GPU memory bytes read from GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = hsw__render_basic__gti_read_throughput__read,
                .max_uint64 = hsw__render_basic__gti_read_throughput__max,
                .group = "GTI",
            },

            {
                .name = "GTI Fixed Pipe Throughput",
                .symbol_name = "GtiVfThroughput",
                .desc = "The total number of GPU memory bytes transferred between 3D Pipeline (Command Dispatch, Input Assembly and Stream Output) and GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = hsw__render_basic__gti_vf_throughput__read,
                .max_uint64 = hsw__render_basic__gti_vf_throughput__max,
                .group = "GTI/3D Pipe",
            },

            {
                .name = "GTI Write Throughput",
                .symbol_name = "GtiWriteThroughput",
                .desc = "The total number of GPU memory bytes written to GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = hsw__render_basic__gti_write_throughput__read,
                .max_uint64 = hsw__render_basic__gti_write_throughput__max,
                .group = "GTI",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__render_basic__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "TCS Duration",
                .symbol_name = "HsDuration",
                .desc = "Total Control Shader GPU duration.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_US,
                .read_uint64 = hsw__render_basic__hs_duration__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Control Shader",
            },

            {
                .name = "TCS EU Active",
                .symbol_name = "HsEuActive",
                .desc = "The percentage of time in which control shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__render_basic__hs_eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Control Shader",
            },

            {
                .name = "TCS AVG Active per Thread",
                .symbol_name = "HsEuActivePerThread",
                .desc = "The average number of cycles per hardware thread run in which control shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__render_basic__hs_eu_active_per_thread__read,
                .max_uint64 = percentage_max_callback_uint64,
                .group = "EU Array/Control Shader",
            },

            {
                .name = "TCS EU Stall",
                .symbol_name = "HsEuStall",
                .desc = "The percentage of time in which control shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__render_basic__hs_eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Control Shader",
            },

            {
                .name = "TCS AVG Stall per Thread",
                .symbol_name = "HsEuStallPerThread",
                .desc = "The average number of cycles per hardware thread run in which control shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__render_basic__hs_eu_stall_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Control Shader",
            },

            {
                .name = "TCS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of control shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = hsw__render_basic__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Control Shader",
            },

            {
                .name = "L3 Sampler Throughput",
                .symbol_name = "L3SamplerThroughput",
                .desc = "The total number of GPU memory bytes transferred between samplers and L3 caches.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = hsw__render_basic__l3_sampler_throughput__read,
                .max_uint64 = hsw__render_basic__l3_sampler_throughput__max,
                .group = "L3/Sampler",
            },

            {
                .name = "LLC GPU Accesses",
                .symbol_name = "LlcAccesses",
                .desc = "The total number of LLC cache lookups done from the GPU (64b reads, 32B writes).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__render_basic__llc_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "LLC",
                .availability = hsw_render_basic_LlcAccesses_availability,
            },

            {
                .name = "LLC GPU Throughput",
                .symbol_name = "LlcGpuThroughput",
                .desc = "The total number of GPU memory bytes transferred between GPU and LLC.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = hsw__render_basic__llc_gpu_throughput__read,
                .max_uint64 = hsw__render_basic__llc_gpu_throughput__max,
                .group = "LLC",
                .availability = hsw_render_basic_LlcGpuThroughput_availability,
            },

            {
                .name = "LLC GPU Hits",
                .symbol_name = "LlcHits",
                .desc = "The total number of successful LLC cache lookups done from the GPU.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__render_basic__llc_hits__read,
                .max_uint64 = NULL /* undefined */,
                .group = "LLC",
                .availability = hsw_render_basic_LlcHits_availability,
            },

            {
                .name = "Late Depth Test Fails",
                .symbol_name = "PostPsDepthTestFails",
                .desc = "The total number of pixels dropped on post-FS depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__render_basic__post_ps_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Late Stencil Test Fails",
                .symbol_name = "PostPsStencilTestFails",
                .desc = "The total number of pixels dropped on post-FS stencil test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__render_basic__post_ps_stencil_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Duration",
                .symbol_name = "PsDuration",
                .desc = "Total Fragment Shader GPU duration.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_US,
                .read_uint64 = hsw__render_basic__ps_duration__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "FS EU Active",
                .symbol_name = "PsEuActive",
                .desc = "The percentage of time in which fragment shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__render_basic__ps_eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "FS AVG Active per Thread",
                .symbol_name = "PsEuActivePerThread",
                .desc = "The average number of cycles per hardware thread run in which fragment shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__render_basic__ps_eu_active_per_thread__read,
                .max_uint64 = percentage_max_callback_uint64,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "FS EU Stall",
                .symbol_name = "PsEuStall",
                .desc = "The percentage of time in which fragment shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__render_basic__ps_eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "FS AVG Stall per Thread",
                .symbol_name = "PsEuStallPerThread",
                .desc = "The average number of cycles per hardware thread run in which fragment shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__render_basic__ps_eu_stall_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = hsw__render_basic__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Sampler 0 Bottleneck",
                .symbol_name = "Sampler0Bottleneck",
                .desc = "The percentage of time in which sampler 0 was bottlenecks.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__render_basic__sampler0_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = hsw_render_basic_Sampler0Bottleneck_availability,
            },

            {
                .name = "Sampler 0 Busy",
                .symbol_name = "Sampler0Busy",
                .desc = "The percentage of time in which sampler 0 was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__render_basic__sampler0_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = hsw_render_basic_Sampler0Busy_availability,
            },

            {
                .name = "Sampler 0 Texels LOD0",
                .symbol_name = "Sampler0Texels",
                .desc = "The total number of texels lookups in LOD0 in sampler 0 unit.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = hsw__render_basic__sampler0_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler",
                .availability = hsw_render_basic_Sampler0Texels_availability,
            },

            {
                .name = "Sampler 1 Bottleneck",
                .symbol_name = "Sampler1Bottleneck",
                .desc = "The percentage of time in which sampler 1 was bottlenecks.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__render_basic__sampler1_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = hsw_render_basic_Sampler1Bottleneck_availability,
            },

            {
                .name = "Sampler 1 Busy",
                .symbol_name = "Sampler1Busy",
                .desc = "The percentage of time in which sampler 1 was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__render_basic__sampler1_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = hsw_render_basic_Sampler1Busy_availability,
            },

            {
                .name = "Sampler 1 Texels LOD0",
                .symbol_name = "Sampler1Texels",
                .desc = "The total number of texels lookups in LOD0 in sampler 1 unit.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = hsw__render_basic__sampler1_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler",
                .availability = hsw_render_basic_Sampler1Texels_availability,
            },

            {
                .name = "Sampler Bottleneck",
                .symbol_name = "SamplerBottleneck",
                .desc = "The percentage of time in which samplers were bottlenecks.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__render_basic__sampler_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
            },

            {
                .name = "Sampler Texels LOD0",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels lookups in LOD0 in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = hsw__render_basic__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler",
            },

            {
                .name = "Samplers Busy",
                .symbol_name = "SamplersBusy",
                .desc = "The percentage of time in which samplers were busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__render_basic__samplers_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__render_basic__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__render_basic__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__render_basic__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "VS Duration",
                .symbol_name = "VsDuration",
                .desc = "Total Vertex Shader GPU duration.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_US,
                .read_uint64 = hsw__render_basic__vs_duration__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS EU Active",
                .symbol_name = "VsEuActive",
                .desc = "The percentage of time in which vertex shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__render_basic__vs_eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS AVG Active per Thread",
                .symbol_name = "VsEuActivePerThread",
                .desc = "The average number of cycles per hardware thread run in which vertex shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__render_basic__vs_eu_active_per_thread__read,
                .max_uint64 = percentage_max_callback_uint64,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS EU Stall",
                .symbol_name = "VsEuStall",
                .desc = "The percentage of time in which vertex shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__render_basic__vs_eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS AVG Stall per Thread",
                .symbol_name = "VsEuStallPerThread",
                .desc = "The average number of cycles per hardware thread run in which vertex shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__render_basic__vs_eu_stall_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = hsw__render_basic__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 70);
}

static bool hsw_compute_basic_LlcAccesses_availability(const struct intel_perf *perf) {
    if (true &&
        perf->devinfo.query_mode) {
        return true;
    }
    return false;
}
static bool hsw_compute_basic_LlcHits_availability(const struct intel_perf *perf) {
    if (true &&
        perf->devinfo.query_mode) {
        return true;
    }
    return false;
}

static void
hsw_add_compute_basic_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Compute Metrics Basic set";
    metric_set->symbol_name = "ComputeBasic";
    metric_set->hw_config_guid = "b344c8cb-a291-4cbf-aa9c-b40213bfc96f";
    metric_set->counters = calloc(52, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A45_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->a_offset = 1;
    metric_set->b_offset = metric_set->a_offset + 45;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    hsw_compute_basic_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "Alpha Test Fails",
                .symbol_name = "AlphaTestFails",
                .desc = "The total number of pixels dropped on post-FS alpha test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__compute_basic__alpha_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = hsw__compute_basic__avg_gpu_core_frequency__read,
                .max_uint64 = hsw__compute_basic__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS EU Active",
                .symbol_name = "CsEuActive",
                .desc = "The percentage of time in which compute shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__compute_basic__cs_eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "CS AVG Active per Thread",
                .symbol_name = "CsEuActivePerThread",
                .desc = "The average number of cycles per hardware thread run in which compute shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__compute_basic__cs_eu_active_per_thread__read,
                .max_uint64 = percentage_max_callback_uint64,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "CS EU Stall",
                .symbol_name = "CsEuStall",
                .desc = "The percentage of time in which compute shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__compute_basic__cs_eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "CS AVG Stall per Thread",
                .symbol_name = "CsEuStallPerThread",
                .desc = "The average number of cycles per hardware thread run in which compute shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__compute_basic__cs_eu_stall_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = hsw__compute_basic__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "TES EU Active",
                .symbol_name = "DsEuActive",
                .desc = "The percentage of time in which evaluation shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__compute_basic__ds_eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Evaluation Shader",
            },

            {
                .name = "TES AVG Active per Thread",
                .symbol_name = "DsEuActivePerThread",
                .desc = "The average number of cycles per hardware thread run in which evaluation shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__compute_basic__ds_eu_active_per_thread__read,
                .max_uint64 = percentage_max_callback_uint64,
                .group = "EU Array/Evaluation Shader",
            },

            {
                .name = "TES EU Stall",
                .symbol_name = "DsEuStall",
                .desc = "The percentage of time in which evaluation shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__compute_basic__ds_eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Evaluation Shader",
            },

            {
                .name = "TES AVG Stall per Thread",
                .symbol_name = "DsEuStallPerThread",
                .desc = "The average number of cycles per hardware thread run in which evaluation shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__compute_basic__ds_eu_stall_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Evaluation Shader",
            },

            {
                .name = "TES Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of evaluation shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = hsw__compute_basic__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Evaluation Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__compute_basic__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__compute_basic__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__compute_basic__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has being processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__compute_basic__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__compute_basic__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = hsw__compute_basic__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS EU Active",
                .symbol_name = "GsEuActive",
                .desc = "The percentage of time in which geometry shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__compute_basic__gs_eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GS AVG Active per Thread",
                .symbol_name = "GsEuActivePerThread",
                .desc = "The average number of cycles per hardware thread run in which geometry shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__compute_basic__gs_eu_active_per_thread__read,
                .max_uint64 = percentage_max_callback_uint64,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GS EU Stall",
                .symbol_name = "GsEuStall",
                .desc = "The percentage of time in which geometry shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__compute_basic__gs_eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GS AVG Stall per Thread",
                .symbol_name = "GsEuStallPerThread",
                .desc = "The average number of cycles per hardware thread run in which geometry shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__compute_basic__gs_eu_stall_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = hsw__compute_basic__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__compute_basic__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "TCS EU Active",
                .symbol_name = "HsEuActive",
                .desc = "The percentage of time in which control shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__compute_basic__hs_eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Control Shader",
            },

            {
                .name = "TCS AVG Active per Thread",
                .symbol_name = "HsEuActivePerThread",
                .desc = "The average number of cycles per hardware thread run in which control shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__compute_basic__hs_eu_active_per_thread__read,
                .max_uint64 = percentage_max_callback_uint64,
                .group = "EU Array/Control Shader",
            },

            {
                .name = "TCS EU Stall",
                .symbol_name = "HsEuStall",
                .desc = "The percentage of time in which control shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__compute_basic__hs_eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Control Shader",
            },

            {
                .name = "TCS AVG Stall per Thread",
                .symbol_name = "HsEuStallPerThread",
                .desc = "The average number of cycles per hardware thread run in which control shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__compute_basic__hs_eu_stall_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Control Shader",
            },

            {
                .name = "TCS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of control shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = hsw__compute_basic__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Control Shader",
            },

            {
                .name = "LLC GPU Accesses",
                .symbol_name = "LlcAccesses",
                .desc = "The total number of LLC cache lookups done from the GPU (64b reads, 32B writes).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__compute_basic__llc_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "LLC",
                .availability = hsw_compute_basic_LlcAccesses_availability,
            },

            {
                .name = "LLC GPU Hits",
                .symbol_name = "LlcHits",
                .desc = "The total number of successful LLC cache lookups done from the GPU.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__compute_basic__llc_hits__read,
                .max_uint64 = NULL /* undefined */,
                .group = "LLC",
                .availability = hsw_compute_basic_LlcHits_availability,
            },

            {
                .name = "Late Depth Test Fails",
                .symbol_name = "PostPsDepthTestFails",
                .desc = "The total number of pixels dropped on post-FS depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__compute_basic__post_ps_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Late Stencil Test Fails",
                .symbol_name = "PostPsStencilTestFails",
                .desc = "The total number of pixels dropped on post-FS stencil test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__compute_basic__post_ps_stencil_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS EU Active",
                .symbol_name = "PsEuActive",
                .desc = "The percentage of time in which fragment shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__compute_basic__ps_eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "FS AVG Active per Thread",
                .symbol_name = "PsEuActivePerThread",
                .desc = "The average number of cycles per hardware thread run in which fragment shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__compute_basic__ps_eu_active_per_thread__read,
                .max_uint64 = percentage_max_callback_uint64,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "FS EU Stall",
                .symbol_name = "PsEuStall",
                .desc = "The percentage of time in which fragment shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__compute_basic__ps_eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "FS AVG Stall per Thread",
                .symbol_name = "PsEuStallPerThread",
                .desc = "The average number of cycles per hardware thread run in which fragment shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__compute_basic__ps_eu_stall_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = hsw__compute_basic__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__compute_basic__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__compute_basic__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = hsw__compute_basic__slm_bytes_read__read,
                .max_uint64 = hsw__compute_basic__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of byten written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = hsw__compute_basic__slm_bytes_written__read,
                .max_uint64 = hsw__compute_basic__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "Typed Atomics",
                .symbol_name = "TypedAtomics",
                .desc = "The total number of typed atomics.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__compute_basic__typed_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "Typed Bytes Read",
                .symbol_name = "TypedBytesRead",
                .desc = "The total number of typed memory bytes read via Data Port.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = hsw__compute_basic__typed_bytes_read__read,
                .max_uint64 = hsw__compute_basic__typed_bytes_read__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Typed Bytes Written",
                .symbol_name = "TypedBytesWritten",
                .desc = "The total number of untyped memory bytes written via Data Port.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = hsw__compute_basic__typed_bytes_written__read,
                .max_uint64 = hsw__compute_basic__typed_bytes_written__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Untyped Bytes Read",
                .symbol_name = "UntypedBytesRead",
                .desc = "The total number of typed memory bytes read via Data Port.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = hsw__compute_basic__untyped_bytes_read__read,
                .max_uint64 = hsw__compute_basic__untyped_bytes_read__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Untyped Writes",
                .symbol_name = "UntypedBytesWritten",
                .desc = "The total number of untyped memory bytes written via Data Port.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = hsw__compute_basic__untyped_bytes_written__read,
                .max_uint64 = hsw__compute_basic__untyped_bytes_written__max,
                .group = "L3/Data Port",
            },

            {
                .name = "VS EU Active",
                .symbol_name = "VsEuActive",
                .desc = "The percentage of time in which vertex shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__compute_basic__vs_eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS AVG Active per Thread",
                .symbol_name = "VsEuActivePerThread",
                .desc = "The average number of cycles per hardware thread run in which vertex shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__compute_basic__vs_eu_active_per_thread__read,
                .max_uint64 = percentage_max_callback_uint64,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS EU Stall",
                .symbol_name = "VsEuStall",
                .desc = "The percentage of time in which vertex shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__compute_basic__vs_eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS AVG Stall per Thread",
                .symbol_name = "VsEuStallPerThread",
                .desc = "The average number of cycles per hardware thread run in which vertex shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__compute_basic__vs_eu_stall_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = hsw__compute_basic__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 52);
}

static bool hsw_compute_extended_LlcAccesses_availability(const struct intel_perf *perf) {
    if (true &&
        perf->devinfo.query_mode) {
        return true;
    }
    return false;
}
static bool hsw_compute_extended_LlcHits_availability(const struct intel_perf *perf) {
    if (true &&
        perf->devinfo.query_mode) {
        return true;
    }
    return false;
}

static void
hsw_add_compute_extended_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Compute Metrics Extended set";
    metric_set->symbol_name = "ComputeExtended";
    metric_set->hw_config_guid = "480f9795-cf6a-4204-a9e3-cd7015515f8d";
    metric_set->counters = calloc(22, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A45_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->a_offset = 1;
    metric_set->b_offset = metric_set->a_offset + 45;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    hsw_compute_extended_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = hsw__compute_extended__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "EuTypedAtomics0",
                .symbol_name = "EuTypedAtomics0",
                .desc = "The subslice 0 EU Typed Atomics subslice 0.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__compute_extended__eu_typed_atomics0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "EuTypedReads0",
                .symbol_name = "EuTypedReads0",
                .desc = "The subslice 0 EU Typed Reads subslice 0.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__compute_extended__eu_typed_reads0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "EuTypedWrites0",
                .symbol_name = "EuTypedWrites0",
                .desc = "The subslice 0 EU Typed Writes subslice 0.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__compute_extended__eu_typed_writes0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "EuUntypedAtomics0",
                .symbol_name = "EuUntypedAtomics0",
                .desc = "The subslice 0 EU Untyped Atomics subslice 0.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__compute_extended__eu_untyped_atomics0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "EuUntypedReads0",
                .symbol_name = "EuUntypedReads0",
                .desc = "The subslice 0 EU Untyped Reads subslice 0.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__compute_extended__eu_untyped_reads0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "EuUntypedWrites0",
                .symbol_name = "EuUntypedWrites0",
                .desc = "The subslice 0 EU Untyped Writes subslice 0.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__compute_extended__eu_untyped_writes0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "EuUrbAtomics0",
                .symbol_name = "EuUrbAtomics0",
                .desc = "The subslice 0 EU URB Atomics subslice 0.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__compute_extended__eu_urb_atomics0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__compute_extended__gpu_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = hsw__compute_extended__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "LLC GPU Accesses",
                .symbol_name = "LlcAccesses",
                .desc = "The total number of LLC cache lookups done from the GPU (64b reads, 32B writes).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__compute_extended__llc_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "LLC",
                .availability = hsw_compute_extended_LlcAccesses_availability,
            },

            {
                .name = "LLC GPU Hits",
                .symbol_name = "LlcHits",
                .desc = "The total number of successful LLC cache lookups done from the GPU.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__compute_extended__llc_hits__read,
                .max_uint64 = NULL /* undefined */,
                .group = "LLC",
                .availability = hsw_compute_extended_LlcHits_availability,
            },

            {
                .name = "Typed Atomics 0",
                .symbol_name = "TypedAtomics0",
                .desc = "The subslice 0 typed atomics.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__compute_extended__typed_atomics0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "TypedAtomicsPerCacheLine",
                .symbol_name = "TypedAtomicsPerCacheLine",
                .desc = "The ratio of EU typed atomics requests to L3 cache line writes.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EU_SENDS_TO_L3_CACHE_LINES,
                .read_float = hsw__compute_extended__typed_atomics_per_cache_line__read,
                .max_float = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "Typed Reads 0",
                .symbol_name = "TypedReads0",
                .desc = "The subslice 0 typed reads.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__compute_extended__typed_reads0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "TypedReadsPerCacheLine",
                .symbol_name = "TypedReadsPerCacheLine",
                .desc = "The ratio of EU typed read requests to L3 cache line reads.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EU_SENDS_TO_L3_CACHE_LINES,
                .read_float = hsw__compute_extended__typed_reads_per_cache_line__read,
                .max_float = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "Typed Writes 0",
                .symbol_name = "TypedWrites0",
                .desc = "The subslice 0 typed writes.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__compute_extended__typed_writes0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "TypedWritesPerCacheLine",
                .symbol_name = "TypedWritesPerCacheLine",
                .desc = "The ratio of EU typed write requests to L3 cache line writes.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EU_SENDS_TO_L3_CACHE_LINES,
                .read_float = hsw__compute_extended__typed_writes_per_cache_line__read,
                .max_float = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "Untyped Reads 0",
                .symbol_name = "UntypedReads0",
                .desc = "The subslice 0 untyped reads (including SLM reads).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__compute_extended__untyped_reads0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "UntypedReadsPerCacheLine",
                .symbol_name = "UntypedReadsPerCacheLine",
                .desc = "The ratio of EU untyped read requests to L3 cache line reads.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EU_SENDS_TO_L3_CACHE_LINES,
                .read_float = hsw__compute_extended__untyped_reads_per_cache_line__read,
                .max_float = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "Untyped Writes 0",
                .symbol_name = "UntypedWrites0",
                .desc = "The subslice 0 untyped writes (including SLM writes).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__compute_extended__untyped_writes0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "UntypedWritesPerCacheLine",
                .symbol_name = "UntypedWritesPerCacheLine",
                .desc = "The ratio of EU untyped write requests to L3 cache line writes.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EU_SENDS_TO_L3_CACHE_LINES,
                .read_float = hsw__compute_extended__untyped_writes_per_cache_line__read,
                .max_float = NULL /* undefined */,
                .group = "L3/Data Port",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 22);
}

static bool hsw_memory_reads_LlcAccesses_availability(const struct intel_perf *perf) {
    if (true &&
        perf->devinfo.query_mode) {
        return true;
    }
    return false;
}
static bool hsw_memory_reads_LlcHits_availability(const struct intel_perf *perf) {
    if (true &&
        perf->devinfo.query_mode) {
        return true;
    }
    return false;
}

static void
hsw_add_memory_reads_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Memory Reads Distribution set";
    metric_set->symbol_name = "MemoryReads";
    metric_set->hw_config_guid = "399d3001-97d6-4240-b065-4fb843138e17";
    metric_set->counters = calloc(56, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A45_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->a_offset = 1;
    metric_set->b_offset = metric_set->a_offset + 45;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    hsw_memory_reads_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "Alpha Test Fails",
                .symbol_name = "AlphaTestFails",
                .desc = "The total number of pixels dropped on post-FS alpha test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__memory_reads__alpha_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = hsw__memory_reads__avg_gpu_core_frequency__read,
                .max_uint64 = hsw__memory_reads__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS EU Active",
                .symbol_name = "CsEuActive",
                .desc = "The percentage of time in which compute shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__memory_reads__cs_eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "CS AVG Active per Thread",
                .symbol_name = "CsEuActivePerThread",
                .desc = "The average number of cycles per hardware thread run in which compute shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__memory_reads__cs_eu_active_per_thread__read,
                .max_uint64 = percentage_max_callback_uint64,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "CS EU Stall",
                .symbol_name = "CsEuStall",
                .desc = "The percentage of time in which compute shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__memory_reads__cs_eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "CS AVG Stall per Thread",
                .symbol_name = "CsEuStallPerThread",
                .desc = "The average number of cycles per hardware thread run in which compute shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__memory_reads__cs_eu_stall_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = hsw__memory_reads__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "TES EU Active",
                .symbol_name = "DsEuActive",
                .desc = "The percentage of time in which evaluation shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__memory_reads__ds_eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Evaluation Shader",
            },

            {
                .name = "TES AVG Active per Thread",
                .symbol_name = "DsEuActivePerThread",
                .desc = "The average number of cycles per hardware thread run in which evaluation shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__memory_reads__ds_eu_active_per_thread__read,
                .max_uint64 = percentage_max_callback_uint64,
                .group = "EU Array/Evaluation Shader",
            },

            {
                .name = "TES EU Stall",
                .symbol_name = "DsEuStall",
                .desc = "The percentage of time in which evaluation shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__memory_reads__ds_eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Evaluation Shader",
            },

            {
                .name = "TES AVG Stall per Thread",
                .symbol_name = "DsEuStallPerThread",
                .desc = "The average number of cycles per hardware thread run in which evaluation shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__memory_reads__ds_eu_stall_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Evaluation Shader",
            },

            {
                .name = "TES Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of evaluation shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = hsw__memory_reads__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Evaluation Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__memory_reads__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__memory_reads__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__memory_reads__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has being processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__memory_reads__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__memory_reads__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = hsw__memory_reads__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS EU Active",
                .symbol_name = "GsEuActive",
                .desc = "The percentage of time in which geometry shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__memory_reads__gs_eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GS AVG Active per Thread",
                .symbol_name = "GsEuActivePerThread",
                .desc = "The average number of cycles per hardware thread run in which geometry shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__memory_reads__gs_eu_active_per_thread__read,
                .max_uint64 = percentage_max_callback_uint64,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GS EU Stall",
                .symbol_name = "GsEuStall",
                .desc = "The percentage of time in which geometry shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__memory_reads__gs_eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GS AVG Stall per Thread",
                .symbol_name = "GsEuStallPerThread",
                .desc = "The average number of cycles per hardware thread run in which geometry shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__memory_reads__gs_eu_stall_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = hsw__memory_reads__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GtiCmdStreamerMemoryReads",
                .symbol_name = "GtiCmdStreamerMemoryReads",
                .desc = "The total number of GTI memory reads from Command Streamer.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__memory_reads__gti_cmd_streamer_memory_reads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/3D Pipe/Command Streamer",
            },

            {
                .name = "GtiHiDepthMemoryReads",
                .symbol_name = "GtiHiDepthMemoryReads",
                .desc = "The total number of GTI memory reads from Hierarchical Depth Cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__memory_reads__gti_hi_depth_memory_reads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/Depth Cache",
            },

            {
                .name = "GtiL3Reads",
                .symbol_name = "GtiL3Reads",
                .desc = "The total number of GTI memory reads from L3 (L3 misses).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__memory_reads__gti_l3_reads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI",
            },

            {
                .name = "GtiMemoryReads",
                .symbol_name = "GtiMemoryReads",
                .desc = "The total number of GTI memory reads (64B each).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__memory_reads__gti_memory_reads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI",
            },

            {
                .name = "GtiMscMemoryReads",
                .symbol_name = "GtiMscMemoryReads",
                .desc = "The total number of GTI memory reads from Multisampling Color Cache (Multisampling Color Cache misses).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__memory_reads__gti_msc_memory_reads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/Color Cache",
            },

            {
                .name = "GtiRccMemoryReads",
                .symbol_name = "GtiRccMemoryReads",
                .desc = "The total number of GTI memory reads from Render Color Cache (Render Color Cache misses).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__memory_reads__gti_rcc_memory_reads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/Color Cache",
            },

            {
                .name = "GtiRczMemoryReads",
                .symbol_name = "GtiRczMemoryReads",
                .desc = "The total number of GTI memory reads from Render Depth Cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__memory_reads__gti_rcz_memory_reads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/Depth Cache",
            },

            {
                .name = "GtiRsMemoryReads",
                .symbol_name = "GtiRsMemoryReads",
                .desc = "The total number of GTI memory reads from Resource Streamer.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__memory_reads__gti_rs_memory_reads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/3D Pipe/Resource Streamer",
            },

            {
                .name = "GtiStcMemoryReads",
                .symbol_name = "GtiStcMemoryReads",
                .desc = "The total number of GTI memory reads from Stencil Cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__memory_reads__gti_stc_memory_reads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/Depth Cache",
            },

            {
                .name = "GtiVfMemoryReads",
                .symbol_name = "GtiVfMemoryReads",
                .desc = "The total number of GTI memory reads from Vertex Fetch.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__memory_reads__gti_vf_memory_reads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/3D Pipe/Vertex Fetch",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__memory_reads__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "TCS EU Active",
                .symbol_name = "HsEuActive",
                .desc = "The percentage of time in which control shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__memory_reads__hs_eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Control Shader",
            },

            {
                .name = "TCS AVG Active per Thread",
                .symbol_name = "HsEuActivePerThread",
                .desc = "The average number of cycles per hardware thread run in which control shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__memory_reads__hs_eu_active_per_thread__read,
                .max_uint64 = percentage_max_callback_uint64,
                .group = "EU Array/Control Shader",
            },

            {
                .name = "TCS EU Stall",
                .symbol_name = "HsEuStall",
                .desc = "The percentage of time in which control shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__memory_reads__hs_eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Control Shader",
            },

            {
                .name = "TCS AVG Stall per Thread",
                .symbol_name = "HsEuStallPerThread",
                .desc = "The average number of cycles per hardware thread run in which control shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__memory_reads__hs_eu_stall_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Control Shader",
            },

            {
                .name = "TCS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of control shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = hsw__memory_reads__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Control Shader",
            },

            {
                .name = "LLC GPU Accesses",
                .symbol_name = "LlcAccesses",
                .desc = "The total number of LLC cache lookups done from the GPU (64b reads, 32B writes).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__memory_reads__llc_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "LLC",
                .availability = hsw_memory_reads_LlcAccesses_availability,
            },

            {
                .name = "LLC GPU Hits",
                .symbol_name = "LlcHits",
                .desc = "The total number of successful LLC cache lookups done from the GPU.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__memory_reads__llc_hits__read,
                .max_uint64 = NULL /* undefined */,
                .group = "LLC",
                .availability = hsw_memory_reads_LlcHits_availability,
            },

            {
                .name = "LLC GPU Read Accesses",
                .symbol_name = "LlcReadAccesses",
                .desc = "The total number of LLC cache lookups for reads done from the GPU.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__memory_reads__llc_read_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "LLC",
            },

            {
                .name = "Late Depth Test Fails",
                .symbol_name = "PostPsDepthTestFails",
                .desc = "The total number of pixels dropped on post-FS depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__memory_reads__post_ps_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Late Stencil Test Fails",
                .symbol_name = "PostPsStencilTestFails",
                .desc = "The total number of pixels dropped on post-FS stencil test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__memory_reads__post_ps_stencil_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS EU Active",
                .symbol_name = "PsEuActive",
                .desc = "The percentage of time in which fragment shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__memory_reads__ps_eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "FS AVG Active per Thread",
                .symbol_name = "PsEuActivePerThread",
                .desc = "The average number of cycles per hardware thread run in which fragment shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__memory_reads__ps_eu_active_per_thread__read,
                .max_uint64 = percentage_max_callback_uint64,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "FS EU Stall",
                .symbol_name = "PsEuStall",
                .desc = "The percentage of time in which fragment shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__memory_reads__ps_eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "FS AVG Stall per Thread",
                .symbol_name = "PsEuStallPerThread",
                .desc = "The average number of cycles per hardware thread run in which fragment shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__memory_reads__ps_eu_stall_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = hsw__memory_reads__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__memory_reads__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__memory_reads__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "VS EU Active",
                .symbol_name = "VsEuActive",
                .desc = "The percentage of time in which vertex shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__memory_reads__vs_eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS AVG Active per Thread",
                .symbol_name = "VsEuActivePerThread",
                .desc = "The average number of cycles per hardware thread run in which vertex shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__memory_reads__vs_eu_active_per_thread__read,
                .max_uint64 = percentage_max_callback_uint64,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS EU Stall",
                .symbol_name = "VsEuStall",
                .desc = "The percentage of time in which vertex shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__memory_reads__vs_eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS AVG Stall per Thread",
                .symbol_name = "VsEuStallPerThread",
                .desc = "The average number of cycles per hardware thread run in which vertex shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__memory_reads__vs_eu_stall_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = hsw__memory_reads__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 56);
}

static bool hsw_memory_writes_LlcAccesses_availability(const struct intel_perf *perf) {
    if (true &&
        perf->devinfo.query_mode) {
        return true;
    }
    return false;
}
static bool hsw_memory_writes_LlcGpuThroughput_availability(const struct intel_perf *perf) {
    if (true &&
        perf->devinfo.query_mode) {
        return true;
    }
    return false;
}
static bool hsw_memory_writes_LlcHits_availability(const struct intel_perf *perf) {
    if (true &&
        perf->devinfo.query_mode) {
        return true;
    }
    return false;
}

static void
hsw_add_memory_writes_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Memory Writes Distribution set";
    metric_set->symbol_name = "MemoryWrites";
    metric_set->hw_config_guid = "f3c1ff4b-d0da-4ffa-8780-2c6b98f3f2d5";
    metric_set->counters = calloc(56, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A45_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->a_offset = 1;
    metric_set->b_offset = metric_set->a_offset + 45;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    hsw_memory_writes_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "Alpha Test Fails",
                .symbol_name = "AlphaTestFails",
                .desc = "The total number of pixels dropped on post-FS alpha test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__memory_writes__alpha_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = hsw__memory_writes__avg_gpu_core_frequency__read,
                .max_uint64 = hsw__memory_writes__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS EU Active",
                .symbol_name = "CsEuActive",
                .desc = "The percentage of time in which compute shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__memory_writes__cs_eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "CS AVG Active per Thread",
                .symbol_name = "CsEuActivePerThread",
                .desc = "The average number of cycles per hardware thread run in which compute shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__memory_writes__cs_eu_active_per_thread__read,
                .max_uint64 = percentage_max_callback_uint64,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "CS EU Stall",
                .symbol_name = "CsEuStall",
                .desc = "The percentage of time in which compute shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__memory_writes__cs_eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "CS AVG Stall per Thread",
                .symbol_name = "CsEuStallPerThread",
                .desc = "The average number of cycles per hardware thread run in which compute shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__memory_writes__cs_eu_stall_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = hsw__memory_writes__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "TES EU Active",
                .symbol_name = "DsEuActive",
                .desc = "The percentage of time in which evaluation shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__memory_writes__ds_eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Evaluation Shader",
            },

            {
                .name = "TES AVG Active per Thread",
                .symbol_name = "DsEuActivePerThread",
                .desc = "The average number of cycles per hardware thread run in which evaluation shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__memory_writes__ds_eu_active_per_thread__read,
                .max_uint64 = percentage_max_callback_uint64,
                .group = "EU Array/Evaluation Shader",
            },

            {
                .name = "TES EU Stall",
                .symbol_name = "DsEuStall",
                .desc = "The percentage of time in which evaluation shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__memory_writes__ds_eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Evaluation Shader",
            },

            {
                .name = "TES AVG Stall per Thread",
                .symbol_name = "DsEuStallPerThread",
                .desc = "The average number of cycles per hardware thread run in which evaluation shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__memory_writes__ds_eu_stall_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Evaluation Shader",
            },

            {
                .name = "TES Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of evaluation shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = hsw__memory_writes__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Evaluation Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__memory_writes__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__memory_writes__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__memory_writes__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has being processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__memory_writes__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__memory_writes__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = hsw__memory_writes__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS EU Active",
                .symbol_name = "GsEuActive",
                .desc = "The percentage of time in which geometry shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__memory_writes__gs_eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GS AVG Active per Thread",
                .symbol_name = "GsEuActivePerThread",
                .desc = "The average number of cycles per hardware thread run in which geometry shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__memory_writes__gs_eu_active_per_thread__read,
                .max_uint64 = percentage_max_callback_uint64,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GS EU Stall",
                .symbol_name = "GsEuStall",
                .desc = "The percentage of time in which geometry shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__memory_writes__gs_eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GS AVG Stall per Thread",
                .symbol_name = "GsEuStallPerThread",
                .desc = "The average number of cycles per hardware thread run in which geometry shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__memory_writes__gs_eu_stall_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = hsw__memory_writes__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GtiCmdStreamerMemoryWrites",
                .symbol_name = "GtiCmdStreamerMemoryWrites",
                .desc = "The total number of GTI memory writes from Command Streamer.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__memory_writes__gti_cmd_streamer_memory_writes__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/3D Pipe/Command Streamer",
            },

            {
                .name = "GtiHizMemoryWrites",
                .symbol_name = "GtiHizMemoryWrites",
                .desc = "The total number of GTI memory writes from Hierarchical Depth Cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__memory_writes__gti_hiz_memory_writes__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/Depth Cache",
            },

            {
                .name = "GtiL3Writes",
                .symbol_name = "GtiL3Writes",
                .desc = "The total number of GTI memory writes from L3 (L3 invalidations).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__memory_writes__gti_l3_writes__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
            },

            {
                .name = "GtiMemoryWrites",
                .symbol_name = "GtiMemoryWrites",
                .desc = "The total number of GTI memory writes (64B each).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__memory_writes__gti_memory_writes__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI",
            },

            {
                .name = "GtiMscMemoryWrites",
                .symbol_name = "GtiMscMemoryWrites",
                .desc = "The total number of GTI memory writes from Multisampling Color Cache (Multisampling Color Cache invalidations).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__memory_writes__gti_msc_memory_writes__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/Color Cache",
            },

            {
                .name = "GtiRccMemoryWrites",
                .symbol_name = "GtiRccMemoryWrites",
                .desc = "The total number of GTI memory writes from Render Color Cache (Render Color Cache invalidations).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__memory_writes__gti_rcc_memory_writes__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/Color Cache",
            },

            {
                .name = "GtiRczMemoryWrites",
                .symbol_name = "GtiRczMemoryWrites",
                .desc = "The total number of GTI memory writes from Render Depth Cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__memory_writes__gti_rcz_memory_writes__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/Depth Cache",
            },

            {
                .name = "GtiSoMemoryWrites",
                .symbol_name = "GtiSoMemoryWrites",
                .desc = "The total number of GTI memory writes from Stream Output.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__memory_writes__gti_so_memory_writes__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/3D Pipe/Stream Output",
            },

            {
                .name = "GtiStcMemoryWrites",
                .symbol_name = "GtiStcMemoryWrites",
                .desc = "The total number of GTI memory writes from Stencil Cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__memory_writes__gti_stc_memory_writes__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/Depth Cache",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__memory_writes__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "TCS EU Active",
                .symbol_name = "HsEuActive",
                .desc = "The percentage of time in which control shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__memory_writes__hs_eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Control Shader",
            },

            {
                .name = "TCS AVG Active per Thread",
                .symbol_name = "HsEuActivePerThread",
                .desc = "The average number of cycles per hardware thread run in which control shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__memory_writes__hs_eu_active_per_thread__read,
                .max_uint64 = percentage_max_callback_uint64,
                .group = "EU Array/Control Shader",
            },

            {
                .name = "TCS EU Stall",
                .symbol_name = "HsEuStall",
                .desc = "The percentage of time in which control shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__memory_writes__hs_eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Control Shader",
            },

            {
                .name = "TCS AVG Stall per Thread",
                .symbol_name = "HsEuStallPerThread",
                .desc = "The average number of cycles per hardware thread run in which control shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__memory_writes__hs_eu_stall_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Control Shader",
            },

            {
                .name = "TCS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of control shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = hsw__memory_writes__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Control Shader",
            },

            {
                .name = "LLC GPU Accesses",
                .symbol_name = "LlcAccesses",
                .desc = "The total number of LLC cache lookups done from the GPU (64b reads, 32B writes).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__memory_writes__llc_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "LLC",
                .availability = hsw_memory_writes_LlcAccesses_availability,
            },

            {
                .name = "LLC GPU Throughput",
                .symbol_name = "LlcGpuThroughput",
                .desc = "The total number of GPU memory bytes transferred between GPU and LLC.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = hsw__memory_writes__llc_gpu_throughput__read,
                .max_uint64 = hsw__memory_writes__llc_gpu_throughput__max,
                .group = "LLC",
                .availability = hsw_memory_writes_LlcGpuThroughput_availability,
            },

            {
                .name = "LLC GPU Hits",
                .symbol_name = "LlcHits",
                .desc = "The total number of successful LLC cache lookups done from the GPU.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__memory_writes__llc_hits__read,
                .max_uint64 = NULL /* undefined */,
                .group = "LLC",
                .availability = hsw_memory_writes_LlcHits_availability,
            },

            {
                .name = "LLC GPU Write Accesses",
                .symbol_name = "LlcWrAccesses",
                .desc = "The total number of LLC cache lookups for write done from the GPU (32B writes).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__memory_writes__llc_wr_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "LLC",
            },

            {
                .name = "Late Depth Test Fails",
                .symbol_name = "PostPsDepthTestFails",
                .desc = "The total number of pixels dropped on post-FS depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__memory_writes__post_ps_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Late Stencil Test Fails",
                .symbol_name = "PostPsStencilTestFails",
                .desc = "The total number of pixels dropped on post-FS stencil test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__memory_writes__post_ps_stencil_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS EU Active",
                .symbol_name = "PsEuActive",
                .desc = "The percentage of time in which fragment shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__memory_writes__ps_eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "FS AVG Active per Thread",
                .symbol_name = "PsEuActivePerThread",
                .desc = "The average number of cycles per hardware thread run in which fragment shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__memory_writes__ps_eu_active_per_thread__read,
                .max_uint64 = percentage_max_callback_uint64,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "FS EU Stall",
                .symbol_name = "PsEuStall",
                .desc = "The percentage of time in which fragment shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__memory_writes__ps_eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "FS AVG Stall per Thread",
                .symbol_name = "PsEuStallPerThread",
                .desc = "The average number of cycles per hardware thread run in which fragment shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__memory_writes__ps_eu_stall_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = hsw__memory_writes__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__memory_writes__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__memory_writes__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "VS EU Active",
                .symbol_name = "VsEuActive",
                .desc = "The percentage of time in which vertex shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__memory_writes__vs_eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS AVG Active per Thread",
                .symbol_name = "VsEuActivePerThread",
                .desc = "The average number of cycles per hardware thread run in which vertex shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__memory_writes__vs_eu_active_per_thread__read,
                .max_uint64 = percentage_max_callback_uint64,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS EU Stall",
                .symbol_name = "VsEuStall",
                .desc = "The percentage of time in which vertex shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__memory_writes__vs_eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS AVG Stall per Thread",
                .symbol_name = "VsEuStallPerThread",
                .desc = "The average number of cycles per hardware thread run in which vertex shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__memory_writes__vs_eu_stall_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = hsw__memory_writes__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 56);
}

static bool hsw_sampler_balance_LlcAccesses_availability(const struct intel_perf *perf) {
    if (true &&
        perf->devinfo.query_mode) {
        return true;
    }
    return false;
}
static bool hsw_sampler_balance_LlcHits_availability(const struct intel_perf *perf) {
    if (true &&
        perf->devinfo.query_mode) {
        return true;
    }
    return false;
}
static bool hsw_sampler_balance_Sampler0L2CacheMisses_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x1) {
        return true;
    }
    return false;
}
static bool hsw_sampler_balance_Sampler1L2CacheMisses_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x2) {
        return true;
    }
    return false;
}
static bool hsw_sampler_balance_Sampler2L2CacheMisses_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x4) {
        return true;
    }
    return false;
}
static bool hsw_sampler_balance_Sampler3L2CacheMisses_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 0x8) {
        return true;
    }
    return false;
}

static void
hsw_add_sampler_balance_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set SamplerBalance";
    metric_set->symbol_name = "SamplerBalance";
    metric_set->hw_config_guid = "e111cda4-19c3-41ee-b326-f99ac44ebf78";
    metric_set->counters = calloc(57, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A45_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->a_offset = 1;
    metric_set->b_offset = metric_set->a_offset + 45;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    hsw_sampler_balance_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "Alpha Test Fails",
                .symbol_name = "AlphaTestFails",
                .desc = "The total number of pixels dropped on post-FS alpha test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__sampler_balance__alpha_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = hsw__sampler_balance__avg_gpu_core_frequency__read,
                .max_uint64 = hsw__sampler_balance__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Duration",
                .symbol_name = "CsDuration",
                .desc = "Total Compute Shader GPU duration.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_US,
                .read_uint64 = hsw__sampler_balance__cs_duration__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "CS EU Active",
                .symbol_name = "CsEuActive",
                .desc = "The percentage of time in which compute shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__sampler_balance__cs_eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "CS AVG Active per Thread",
                .symbol_name = "CsEuActivePerThread",
                .desc = "The average number of cycles per hardware thread run in which compute shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__sampler_balance__cs_eu_active_per_thread__read,
                .max_uint64 = percentage_max_callback_uint64,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "CS EU Stall",
                .symbol_name = "CsEuStall",
                .desc = "The percentage of time in which compute shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__sampler_balance__cs_eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "CS AVG Stall per Thread",
                .symbol_name = "CsEuStallPerThread",
                .desc = "The average number of cycles per hardware thread run in which compute shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__sampler_balance__cs_eu_stall_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = hsw__sampler_balance__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "TES Duration",
                .symbol_name = "DsDuration",
                .desc = "Total Evaluation Shader GPU duration.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_US,
                .read_uint64 = hsw__sampler_balance__ds_duration__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Evaluation Shader",
            },

            {
                .name = "TES EU Active",
                .symbol_name = "DsEuActive",
                .desc = "The percentage of time in which evaluation shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__sampler_balance__ds_eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Evaluation Shader",
            },

            {
                .name = "TES AVG Active per Thread",
                .symbol_name = "DsEuActivePerThread",
                .desc = "The average number of cycles per hardware thread run in which evaluation shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__sampler_balance__ds_eu_active_per_thread__read,
                .max_uint64 = percentage_max_callback_uint64,
                .group = "EU Array/Evaluation Shader",
            },

            {
                .name = "TES EU Stall",
                .symbol_name = "DsEuStall",
                .desc = "The percentage of time in which evaluation shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__sampler_balance__ds_eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Evaluation Shader",
            },

            {
                .name = "TES AVG Stall per Thread",
                .symbol_name = "DsEuStallPerThread",
                .desc = "The average number of cycles per hardware thread run in which evaluation shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__sampler_balance__ds_eu_stall_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Evaluation Shader",
            },

            {
                .name = "TES Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of evaluation shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = hsw__sampler_balance__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Evaluation Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__sampler_balance__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__sampler_balance__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Idle",
                .symbol_name = "EuIdle",
                .desc = "The percentage of time in which the Execution Units were idle.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__sampler_balance__eu_idle__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__sampler_balance__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has being processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__sampler_balance__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__sampler_balance__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = hsw__sampler_balance__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Duration",
                .symbol_name = "GsDuration",
                .desc = "Total Geometry Shader GPU duration.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_US,
                .read_uint64 = hsw__sampler_balance__gs_duration__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GS EU Active",
                .symbol_name = "GsEuActive",
                .desc = "The percentage of time in which geometry shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__sampler_balance__gs_eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GS AVG Active per Thread",
                .symbol_name = "GsEuActivePerThread",
                .desc = "The average number of cycles per hardware thread run in which geometry shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__sampler_balance__gs_eu_active_per_thread__read,
                .max_uint64 = percentage_max_callback_uint64,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GS EU Stall",
                .symbol_name = "GsEuStall",
                .desc = "The percentage of time in which geometry shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__sampler_balance__gs_eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GS AVG Stall per Thread",
                .symbol_name = "GsEuStallPerThread",
                .desc = "The average number of cycles per hardware thread run in which geometry shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__sampler_balance__gs_eu_stall_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = hsw__sampler_balance__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__sampler_balance__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "TCS Duration",
                .symbol_name = "HsDuration",
                .desc = "Total Control Shader GPU duration.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_US,
                .read_uint64 = hsw__sampler_balance__hs_duration__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Control Shader",
            },

            {
                .name = "TCS EU Active",
                .symbol_name = "HsEuActive",
                .desc = "The percentage of time in which control shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__sampler_balance__hs_eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Control Shader",
            },

            {
                .name = "TCS AVG Active per Thread",
                .symbol_name = "HsEuActivePerThread",
                .desc = "The average number of cycles per hardware thread run in which control shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__sampler_balance__hs_eu_active_per_thread__read,
                .max_uint64 = percentage_max_callback_uint64,
                .group = "EU Array/Control Shader",
            },

            {
                .name = "TCS EU Stall",
                .symbol_name = "HsEuStall",
                .desc = "The percentage of time in which control shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__sampler_balance__hs_eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Control Shader",
            },

            {
                .name = "TCS AVG Stall per Thread",
                .symbol_name = "HsEuStallPerThread",
                .desc = "The average number of cycles per hardware thread run in which control shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__sampler_balance__hs_eu_stall_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Control Shader",
            },

            {
                .name = "TCS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of control shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = hsw__sampler_balance__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Control Shader",
            },

            {
                .name = "LLC GPU Accesses",
                .symbol_name = "LlcAccesses",
                .desc = "The total number of LLC cache lookups done from the GPU (64b reads, 32B writes).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__sampler_balance__llc_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "LLC",
                .availability = hsw_sampler_balance_LlcAccesses_availability,
            },

            {
                .name = "LLC GPU Hits",
                .symbol_name = "LlcHits",
                .desc = "The total number of successful LLC cache lookups done from the GPU.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__sampler_balance__llc_hits__read,
                .max_uint64 = NULL /* undefined */,
                .group = "LLC",
                .availability = hsw_sampler_balance_LlcHits_availability,
            },

            {
                .name = "Late Depth Test Fails",
                .symbol_name = "PostPsDepthTestFails",
                .desc = "The total number of pixels dropped on post-FS depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__sampler_balance__post_ps_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Late Stencil Test Fails",
                .symbol_name = "PostPsStencilTestFails",
                .desc = "The total number of pixels dropped on post-FS stencil test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__sampler_balance__post_ps_stencil_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Duration",
                .symbol_name = "PsDuration",
                .desc = "Total Fragment Shader GPU duration.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_US,
                .read_uint64 = hsw__sampler_balance__ps_duration__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "FS EU Active",
                .symbol_name = "PsEuActive",
                .desc = "The percentage of time in which fragment shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__sampler_balance__ps_eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "FS AVG Active per Thread",
                .symbol_name = "PsEuActivePerThread",
                .desc = "The average number of cycles per hardware thread run in which fragment shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__sampler_balance__ps_eu_active_per_thread__read,
                .max_uint64 = percentage_max_callback_uint64,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "FS EU Stall",
                .symbol_name = "PsEuStall",
                .desc = "The percentage of time in which fragment shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__sampler_balance__ps_eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "FS AVG Stall per Thread",
                .symbol_name = "PsEuStallPerThread",
                .desc = "The average number of cycles per hardware thread run in which fragment shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__sampler_balance__ps_eu_stall_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = hsw__sampler_balance__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Sampler L2 cache misses (ss0)",
                .symbol_name = "Sampler0L2CacheMisses",
                .desc = "Number of sampler L2 cache misses (ss0)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__sampler_balance__sampler0_l2_cache_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
                .availability = hsw_sampler_balance_Sampler0L2CacheMisses_availability,
            },

            {
                .name = "Sampler L2 cache misses (ss1)",
                .symbol_name = "Sampler1L2CacheMisses",
                .desc = "Number of sampler L2 cache misses (ss1)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__sampler_balance__sampler1_l2_cache_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
                .availability = hsw_sampler_balance_Sampler1L2CacheMisses_availability,
            },

            {
                .name = "Sampler L2 cache misses (ss2)",
                .symbol_name = "Sampler2L2CacheMisses",
                .desc = "Number of sampler L2 cache misses (ss2)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__sampler_balance__sampler2_l2_cache_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
                .availability = hsw_sampler_balance_Sampler2L2CacheMisses_availability,
            },

            {
                .name = "Sampler L2 cache misses (ss3)",
                .symbol_name = "Sampler3L2CacheMisses",
                .desc = "Number of sampler L2 cache misses (ss3)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__sampler_balance__sampler3_l2_cache_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
                .availability = hsw_sampler_balance_Sampler3L2CacheMisses_availability,
            },

            {
                .name = "Sampler L2 cache misses",
                .symbol_name = "SamplerL2CacheMisses",
                .desc = "Number of sampler L2 cache misses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = hsw__sampler_balance__sampler_l2_cache_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__sampler_balance__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = hsw__sampler_balance__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "VS Duration",
                .symbol_name = "VsDuration",
                .desc = "Total Vertex Shader GPU duration.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_US,
                .read_uint64 = hsw__sampler_balance__vs_duration__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS EU Active",
                .symbol_name = "VsEuActive",
                .desc = "The percentage of time in which vertex shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__sampler_balance__vs_eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS AVG Active per Thread",
                .symbol_name = "VsEuActivePerThread",
                .desc = "The average number of cycles per hardware thread run in which vertex shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__sampler_balance__vs_eu_active_per_thread__read,
                .max_uint64 = percentage_max_callback_uint64,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS EU Stall",
                .symbol_name = "VsEuStall",
                .desc = "The percentage of time in which vertex shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = hsw__sampler_balance__vs_eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS AVG Stall per Thread",
                .symbol_name = "VsEuStallPerThread",
                .desc = "The average number of cycles per hardware thread run in which vertex shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = hsw__sampler_balance__vs_eu_stall_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = hsw__sampler_balance__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 57);
}

void
intel_perf_load_metrics_hsw(struct intel_perf *perf)
{
    hsw_add_render_basic_metric_set(perf);
    hsw_add_compute_basic_metric_set(perf);
    hsw_add_compute_extended_metric_set(perf);
    hsw_add_memory_reads_metric_set(perf);
    hsw_add_memory_writes_metric_set(perf);
    hsw_add_sampler_balance_metric_set(perf);
}
