#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 924
#define LARGE_STATE_COUNT 234
#define SYMBOL_COUNT 268
#define ALIAS_COUNT 0
#define TOKEN_COUNT 143
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 35
#define MAX_ALIAS_SEQUENCE_LENGTH 14
#define PRODUCTION_ID_COUNT 89

enum ts_symbol_identifiers {
  sym_export = 1,
  anon_sym_LBRACE = 2,
  anon_sym_COMMA = 3,
  anon_sym_RBRACE = 4,
  anon_sym_import = 5,
  anon_sym_from = 6,
  anon_sym_SEMI = 7,
  anon_sym_as = 8,
  anon_sym_COLON_EQ = 9,
  anon_sym_component = 10,
  anon_sym_inherits = 11,
  anon_sym_LT = 12,
  anon_sym_GT = 13,
  anon_sym_return = 14,
  anon_sym_property = 15,
  anon_sym_COLON = 16,
  anon_sym_LT_EQ_GT = 17,
  anon_sym_global = 18,
  anon_sym_struct = 19,
  anon_sym_enum = 20,
  anon_sym_in = 21,
  anon_sym_out = 22,
  anon_sym_transitions = 23,
  anon_sym_LBRACK = 24,
  anon_sym_RBRACK = 25,
  anon_sym_states = 26,
  anon_sym_when = 27,
  anon_sym_animate = 28,
  anon_sym_delay = 29,
  anon_sym_duration = 30,
  anon_sym_iteration_DASHcount = 31,
  anon_sym_direction = 32,
  anon_sym_easing = 33,
  anon_sym_if = 34,
  anon_sym_else = 35,
  anon_sym_for = 36,
  anon_sym_LPAREN = 37,
  anon_sym_RPAREN = 38,
  anon_sym_ATtr = 39,
  anon_sym_EQ_GT = 40,
  anon_sym_PIPE = 41,
  anon_sym_PERCENT = 42,
  anon_sym_DOT = 43,
  sym_logical_and = 44,
  sym_logical_or = 45,
  anon_sym_QMARK = 46,
  anon_sym_callback = 47,
  anon_sym_DASH_GT = 48,
  anon_sym_pure = 49,
  anon_sym_public = 50,
  anon_sym_private = 51,
  anon_sym_function = 52,
  anon_sym_changed = 53,
  anon_sym_ATimage_DASHurl = 54,
  anon_sym_nine_DASHslice = 55,
  anon_sym_BANG = 56,
  anon_sym_DASH = 57,
  anon_sym_PLUS = 58,
  anon_sym_STAR = 59,
  anon_sym_SLASH = 60,
  anon_sym_GT_EQ = 61,
  anon_sym_LT_EQ = 62,
  anon_sym_EQ_EQ = 63,
  anon_sym_BANG_EQ = 64,
  anon_sym_EQ = 65,
  anon_sym_PLUS_EQ = 66,
  anon_sym_DASH_EQ = 67,
  anon_sym_STAR_EQ = 68,
  anon_sym_SLASH_EQ = 69,
  anon_sym_DQUOTE = 70,
  sym__unescaped_string_fragment = 71,
  anon_sym_BSLASH = 72,
  aux_sym_escape_sequence_token1 = 73,
  anon_sym_n = 74,
  anon_sym_in_DASHout = 75,
  sym__identifier = 76,
  anon_sym_int = 77,
  anon_sym_float = 78,
  anon_sym_bool = 79,
  anon_sym_string = 80,
  anon_sym_color = 81,
  anon_sym_brush = 82,
  anon_sym_physical_DASHlength = 83,
  anon_sym_length = 84,
  anon_sym_angle = 85,
  anon_sym_percent = 86,
  anon_sym_image = 87,
  anon_sym_relative_DASHfont_DASHsize = 88,
  anon_sym_linear = 89,
  anon_sym_ease_DASHin_DASHquad = 90,
  anon_sym_ease_DASHout_DASHquad = 91,
  anon_sym_ease_DASHin_DASHout_DASHquad = 92,
  anon_sym_ease = 93,
  anon_sym_ease_DASHin = 94,
  anon_sym_ease_DASHout = 95,
  anon_sym_ease_DASHin_DASHout = 96,
  anon_sym_ease_DASHin_DASHquart = 97,
  anon_sym_ease_DASHout_DASHquart = 98,
  anon_sym_ease_DASHin_DASHout_DASHquart = 99,
  anon_sym_ease_DASHin_DASHquint = 100,
  anon_sym_ease_DASHout_DASHquint = 101,
  anon_sym_ease_DASHin_DASHout_DASHquint = 102,
  anon_sym_ease_DASHin_DASHexpo = 103,
  anon_sym_ease_DASHout_DASHexpo = 104,
  anon_sym_ease_DASHin_DASHout_DASHexpo = 105,
  anon_sym_ease_DASHin_DASHsine = 106,
  anon_sym_ease_DASHout_DASHsine = 107,
  anon_sym_ease_DASHin_DASHout_DASHsine = 108,
  anon_sym_ease_DASHin_DASHback = 109,
  anon_sym_ease_DASHout_DASHback = 110,
  anon_sym_ease_DASHin_DASHout_DASHback = 111,
  anon_sym_ease_DASHin_DASHcirc = 112,
  anon_sym_ease_DASHout_DASHcirc = 113,
  anon_sym_ease_DASHin_DASHout_DASHcirc = 114,
  anon_sym_ease_DASHin_DASHelastic = 115,
  anon_sym_ease_DASHout_DASHelastic = 116,
  anon_sym_ease_DASHin_DASHout_DASHelastic = 117,
  anon_sym_ease_DASHin_DASHbounce = 118,
  anon_sym_ease_DASHout_DASHbounce = 119,
  anon_sym_ease_DASHin_DASHout_DASHbounce = 120,
  anon_sym_cubic_DASHbezier = 121,
  sym_children_identifier = 122,
  anon_sym_ATlinear_DASHgradient = 123,
  anon_sym_ATlinear_gradient = 124,
  anon_sym_ATradial_DASHgradient = 125,
  anon_sym_ATradial_gradient = 126,
  anon_sym_circle = 127,
  anon_sym_parent = 128,
  anon_sym_root = 129,
  anon_sym_self = 130,
  sym__int_number = 131,
  sym__float_number = 132,
  anon_sym_true = 133,
  anon_sym_false = 134,
  sym_color_value = 135,
  anon_sym_phx = 136,
  aux_sym_length_value_token1 = 137,
  aux_sym_duration_value_token1 = 138,
  aux_sym_angle_value_token1 = 139,
  anon_sym_PERCENT2 = 140,
  anon_sym_rem = 141,
  sym_comment = 142,
  sym_sourcefile = 143,
  sym__definition = 144,
  sym__local_type = 145,
  sym__exported_type = 146,
  sym_import_statement = 147,
  sym_export_type = 148,
  sym_import_type = 149,
  sym_component = 150,
  sym_component_definition = 151,
  sym__property_type = 152,
  sym_imperative_block = 153,
  sym__imperative_block_statement = 154,
  sym__binding = 155,
  sym_property = 156,
  sym_binding_alias = 157,
  sym_binding = 158,
  sym_global_block = 159,
  sym_global_definition = 160,
  sym_struct_block = 161,
  sym_struct_definition = 162,
  sym_enum_block = 163,
  sym_enum_definition = 164,
  sym_anon_struct_block = 165,
  sym_block = 166,
  sym__block_statement = 167,
  sym_property_assignment = 168,
  sym_in_out_transition = 169,
  sym_transitions_definition = 170,
  sym_states_definition = 171,
  sym_animate_statement = 172,
  sym_animate_option_identifier = 173,
  sym_animate_option = 174,
  sym_animate_body = 175,
  sym_if_expr = 176,
  sym_if_statement = 177,
  sym_for_loop = 178,
  sym_for_range = 179,
  sym_type_list = 180,
  sym_type = 181,
  sym__assignment_setup = 182,
  sym__assignment_value_block = 183,
  sym_assignment_block = 184,
  sym_assignment_expr = 185,
  sym_expression = 186,
  sym_parens_op = 187,
  sym_index_op = 188,
  sym_tr = 189,
  sym_member_access = 190,
  sym_unary_expression = 191,
  sym_binary_expression = 192,
  sym__add_binary_expression = 193,
  sym__comparison_binary_expression = 194,
  sym__logic_binary_expression = 195,
  sym__mult_binary_expression = 196,
  sym_ternary_expression = 197,
  sym_callback = 198,
  sym_purity = 199,
  sym_function_visibility = 200,
  sym_function_definition = 201,
  sym_callback_alias = 202,
  sym_callback_event = 203,
  sym_changed_callback = 204,
  sym_function_call = 205,
  sym_gradient_call = 206,
  sym_gradient_color = 207,
  sym_image_call = 208,
  sym_typed_identifier = 209,
  sym__function_signature = 210,
  sym__callback_signature = 211,
  sym_argument = 212,
  sym_arguments = 213,
  sym_unary_prec_operator = 214,
  sym_add_prec_operator = 215,
  sym_mult_prec_operator = 216,
  sym_comparison_operator = 217,
  sym_assignment_prec_operator = 218,
  sym__string = 219,
  sym_escape_sequence = 220,
  sym_property_visibility = 221,
  sym_simple_identifier = 222,
  sym_simple_indexed_identifier = 223,
  sym_builtin_type_identifier = 224,
  sym_easing_kind_identifier = 225,
  sym_user_type_identifier = 226,
  sym__type_identifier = 227,
  sym_value_list = 228,
  sym_value = 229,
  sym_linear_gradient_identifier = 230,
  sym_radial_gradient_identifier = 231,
  sym_radial_gradient_kind = 232,
  sym_reference_identifier = 233,
  sym__number = 234,
  sym_int_value = 235,
  sym_float_value = 236,
  sym_bool_value = 237,
  sym_string_value = 238,
  sym_physical_length_value = 239,
  sym_length_value = 240,
  sym_duration_value = 241,
  sym_angle_value = 242,
  sym_percent_value = 243,
  sym_relative_font_size_value = 244,
  sym__basic_value = 245,
  aux_sym_sourcefile_repeat1 = 246,
  aux_sym__exported_type_repeat1 = 247,
  aux_sym_import_statement_repeat1 = 248,
  aux_sym_imperative_block_repeat1 = 249,
  aux_sym_global_block_repeat1 = 250,
  aux_sym_struct_block_repeat1 = 251,
  aux_sym_enum_block_repeat1 = 252,
  aux_sym_anon_struct_block_repeat1 = 253,
  aux_sym_block_repeat1 = 254,
  aux_sym_in_out_transition_repeat1 = 255,
  aux_sym_transitions_definition_repeat1 = 256,
  aux_sym_states_definition_repeat1 = 257,
  aux_sym_states_definition_repeat2 = 258,
  aux_sym_animate_body_repeat1 = 259,
  aux_sym_type_list_repeat1 = 260,
  aux_sym_tr_repeat1 = 261,
  aux_sym_function_definition_repeat1 = 262,
  aux_sym_gradient_call_repeat1 = 263,
  aux_sym_image_call_repeat1 = 264,
  aux_sym__function_signature_repeat1 = 265,
  aux_sym_arguments_repeat1 = 266,
  aux_sym__string_repeat1 = 267,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_export] = "export",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_import] = "import",
  [anon_sym_from] = "from",
  [anon_sym_SEMI] = ";",
  [anon_sym_as] = "as",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_component] = "component",
  [anon_sym_inherits] = "inherits",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_return] = "return",
  [anon_sym_property] = "property",
  [anon_sym_COLON] = ":",
  [anon_sym_LT_EQ_GT] = "<=>",
  [anon_sym_global] = "global",
  [anon_sym_struct] = "struct",
  [anon_sym_enum] = "enum",
  [anon_sym_in] = "in",
  [anon_sym_out] = "out",
  [anon_sym_transitions] = "transitions",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_states] = "states",
  [anon_sym_when] = "when",
  [anon_sym_animate] = "animate",
  [anon_sym_delay] = "delay",
  [anon_sym_duration] = "duration",
  [anon_sym_iteration_DASHcount] = "iteration-count",
  [anon_sym_direction] = "direction",
  [anon_sym_easing] = "easing",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_for] = "for",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_ATtr] = "@tr",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_PIPE] = "|",
  [anon_sym_PERCENT] = "%",
  [anon_sym_DOT] = ".",
  [sym_logical_and] = "logical_and",
  [sym_logical_or] = "logical_or",
  [anon_sym_QMARK] = "\?",
  [anon_sym_callback] = "callback",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_pure] = "pure",
  [anon_sym_public] = "public",
  [anon_sym_private] = "private",
  [anon_sym_function] = "function",
  [anon_sym_changed] = "changed",
  [anon_sym_ATimage_DASHurl] = "@image-url",
  [anon_sym_nine_DASHslice] = "nine-slice",
  [anon_sym_BANG] = "!",
  [anon_sym_DASH] = "-",
  [anon_sym_PLUS] = "+",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_EQ] = "=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_DQUOTE] = "\"",
  [sym__unescaped_string_fragment] = "_unescaped_string_fragment",
  [anon_sym_BSLASH] = "\\",
  [aux_sym_escape_sequence_token1] = "escape_sequence_token1",
  [anon_sym_n] = "n",
  [anon_sym_in_DASHout] = "in-out",
  [sym__identifier] = "_identifier",
  [anon_sym_int] = "int",
  [anon_sym_float] = "float",
  [anon_sym_bool] = "bool",
  [anon_sym_string] = "string",
  [anon_sym_color] = "color",
  [anon_sym_brush] = "brush",
  [anon_sym_physical_DASHlength] = "physical-length",
  [anon_sym_length] = "length",
  [anon_sym_angle] = "angle",
  [anon_sym_percent] = "percent",
  [anon_sym_image] = "image",
  [anon_sym_relative_DASHfont_DASHsize] = "relative-font-size",
  [anon_sym_linear] = "linear",
  [anon_sym_ease_DASHin_DASHquad] = "ease-in-quad",
  [anon_sym_ease_DASHout_DASHquad] = "ease-out-quad",
  [anon_sym_ease_DASHin_DASHout_DASHquad] = "ease-in-out-quad",
  [anon_sym_ease] = "ease",
  [anon_sym_ease_DASHin] = "ease-in",
  [anon_sym_ease_DASHout] = "ease-out",
  [anon_sym_ease_DASHin_DASHout] = "ease-in-out",
  [anon_sym_ease_DASHin_DASHquart] = "ease-in-quart",
  [anon_sym_ease_DASHout_DASHquart] = "ease-out-quart",
  [anon_sym_ease_DASHin_DASHout_DASHquart] = "ease-in-out-quart",
  [anon_sym_ease_DASHin_DASHquint] = "ease-in-quint",
  [anon_sym_ease_DASHout_DASHquint] = "ease-out-quint",
  [anon_sym_ease_DASHin_DASHout_DASHquint] = "ease-in-out-quint",
  [anon_sym_ease_DASHin_DASHexpo] = "ease-in-expo",
  [anon_sym_ease_DASHout_DASHexpo] = "ease-out-expo",
  [anon_sym_ease_DASHin_DASHout_DASHexpo] = "ease-in-out-expo",
  [anon_sym_ease_DASHin_DASHsine] = "ease-in-sine",
  [anon_sym_ease_DASHout_DASHsine] = "ease-out-sine",
  [anon_sym_ease_DASHin_DASHout_DASHsine] = "ease-in-out-sine",
  [anon_sym_ease_DASHin_DASHback] = "ease-in-back",
  [anon_sym_ease_DASHout_DASHback] = "ease-out-back",
  [anon_sym_ease_DASHin_DASHout_DASHback] = "ease-in-out-back",
  [anon_sym_ease_DASHin_DASHcirc] = "ease-in-circ",
  [anon_sym_ease_DASHout_DASHcirc] = "ease-out-circ",
  [anon_sym_ease_DASHin_DASHout_DASHcirc] = "ease-in-out-circ",
  [anon_sym_ease_DASHin_DASHelastic] = "ease-in-elastic",
  [anon_sym_ease_DASHout_DASHelastic] = "ease-out-elastic",
  [anon_sym_ease_DASHin_DASHout_DASHelastic] = "ease-in-out-elastic",
  [anon_sym_ease_DASHin_DASHbounce] = "ease-in-bounce",
  [anon_sym_ease_DASHout_DASHbounce] = "ease-out-bounce",
  [anon_sym_ease_DASHin_DASHout_DASHbounce] = "ease-in-out-bounce",
  [anon_sym_cubic_DASHbezier] = "cubic-bezier",
  [sym_children_identifier] = "children_identifier",
  [anon_sym_ATlinear_DASHgradient] = "@linear-gradient",
  [anon_sym_ATlinear_gradient] = "@linear_gradient",
  [anon_sym_ATradial_DASHgradient] = "@radial-gradient",
  [anon_sym_ATradial_gradient] = "@radial_gradient",
  [anon_sym_circle] = "circle",
  [anon_sym_parent] = "parent",
  [anon_sym_root] = "root",
  [anon_sym_self] = "self",
  [sym__int_number] = "_int_number",
  [sym__float_number] = "_float_number",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [sym_color_value] = "color_value",
  [anon_sym_phx] = "phx",
  [aux_sym_length_value_token1] = "length_value_token1",
  [aux_sym_duration_value_token1] = "duration_value_token1",
  [aux_sym_angle_value_token1] = "angle_value_token1",
  [anon_sym_PERCENT2] = "%",
  [anon_sym_rem] = "rem",
  [sym_comment] = "comment",
  [sym_sourcefile] = "sourcefile",
  [sym__definition] = "_definition",
  [sym__local_type] = "_local_type",
  [sym__exported_type] = "_exported_type",
  [sym_import_statement] = "import_statement",
  [sym_export_type] = "export_type",
  [sym_import_type] = "import_type",
  [sym_component] = "component",
  [sym_component_definition] = "component_definition",
  [sym__property_type] = "_property_type",
  [sym_imperative_block] = "imperative_block",
  [sym__imperative_block_statement] = "_imperative_block_statement",
  [sym__binding] = "_binding",
  [sym_property] = "property",
  [sym_binding_alias] = "binding_alias",
  [sym_binding] = "binding",
  [sym_global_block] = "global_block",
  [sym_global_definition] = "global_definition",
  [sym_struct_block] = "struct_block",
  [sym_struct_definition] = "struct_definition",
  [sym_enum_block] = "enum_block",
  [sym_enum_definition] = "enum_definition",
  [sym_anon_struct_block] = "anon_struct_block",
  [sym_block] = "block",
  [sym__block_statement] = "_block_statement",
  [sym_property_assignment] = "property_assignment",
  [sym_in_out_transition] = "in_out_transition",
  [sym_transitions_definition] = "transitions_definition",
  [sym_states_definition] = "states_definition",
  [sym_animate_statement] = "animate_statement",
  [sym_animate_option_identifier] = "animate_option_identifier",
  [sym_animate_option] = "animate_option",
  [sym_animate_body] = "animate_body",
  [sym_if_expr] = "if_expr",
  [sym_if_statement] = "if_statement",
  [sym_for_loop] = "for_loop",
  [sym_for_range] = "for_range",
  [sym_type_list] = "type_list",
  [sym_type] = "type",
  [sym__assignment_setup] = "_assignment_setup",
  [sym__assignment_value_block] = "_assignment_value_block",
  [sym_assignment_block] = "assignment_block",
  [sym_assignment_expr] = "assignment_expr",
  [sym_expression] = "expression",
  [sym_parens_op] = "parens_op",
  [sym_index_op] = "index_op",
  [sym_tr] = "tr",
  [sym_member_access] = "member_access",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym__add_binary_expression] = "_add_binary_expression",
  [sym__comparison_binary_expression] = "_comparison_binary_expression",
  [sym__logic_binary_expression] = "_logic_binary_expression",
  [sym__mult_binary_expression] = "_mult_binary_expression",
  [sym_ternary_expression] = "ternary_expression",
  [sym_callback] = "callback",
  [sym_purity] = "purity",
  [sym_function_visibility] = "function_visibility",
  [sym_function_definition] = "function_definition",
  [sym_callback_alias] = "callback_alias",
  [sym_callback_event] = "callback_event",
  [sym_changed_callback] = "changed_callback",
  [sym_function_call] = "function_call",
  [sym_gradient_call] = "gradient_call",
  [sym_gradient_color] = "gradient_color",
  [sym_image_call] = "image_call",
  [sym_typed_identifier] = "typed_identifier",
  [sym__function_signature] = "_function_signature",
  [sym__callback_signature] = "_callback_signature",
  [sym_argument] = "argument",
  [sym_arguments] = "arguments",
  [sym_unary_prec_operator] = "unary_prec_operator",
  [sym_add_prec_operator] = "add_prec_operator",
  [sym_mult_prec_operator] = "mult_prec_operator",
  [sym_comparison_operator] = "comparison_operator",
  [sym_assignment_prec_operator] = "assignment_prec_operator",
  [sym__string] = "_string",
  [sym_escape_sequence] = "escape_sequence",
  [sym_property_visibility] = "property_visibility",
  [sym_simple_identifier] = "simple_identifier",
  [sym_simple_indexed_identifier] = "simple_indexed_identifier",
  [sym_builtin_type_identifier] = "builtin_type_identifier",
  [sym_easing_kind_identifier] = "easing_kind_identifier",
  [sym_user_type_identifier] = "user_type_identifier",
  [sym__type_identifier] = "_type_identifier",
  [sym_value_list] = "value_list",
  [sym_value] = "value",
  [sym_linear_gradient_identifier] = "linear_gradient_identifier",
  [sym_radial_gradient_identifier] = "radial_gradient_identifier",
  [sym_radial_gradient_kind] = "radial_gradient_kind",
  [sym_reference_identifier] = "reference_identifier",
  [sym__number] = "_number",
  [sym_int_value] = "int_value",
  [sym_float_value] = "float_value",
  [sym_bool_value] = "bool_value",
  [sym_string_value] = "string_value",
  [sym_physical_length_value] = "physical_length_value",
  [sym_length_value] = "length_value",
  [sym_duration_value] = "duration_value",
  [sym_angle_value] = "angle_value",
  [sym_percent_value] = "percent_value",
  [sym_relative_font_size_value] = "relative_font_size_value",
  [sym__basic_value] = "_basic_value",
  [aux_sym_sourcefile_repeat1] = "sourcefile_repeat1",
  [aux_sym__exported_type_repeat1] = "_exported_type_repeat1",
  [aux_sym_import_statement_repeat1] = "import_statement_repeat1",
  [aux_sym_imperative_block_repeat1] = "imperative_block_repeat1",
  [aux_sym_global_block_repeat1] = "global_block_repeat1",
  [aux_sym_struct_block_repeat1] = "struct_block_repeat1",
  [aux_sym_enum_block_repeat1] = "enum_block_repeat1",
  [aux_sym_anon_struct_block_repeat1] = "anon_struct_block_repeat1",
  [aux_sym_block_repeat1] = "block_repeat1",
  [aux_sym_in_out_transition_repeat1] = "in_out_transition_repeat1",
  [aux_sym_transitions_definition_repeat1] = "transitions_definition_repeat1",
  [aux_sym_states_definition_repeat1] = "states_definition_repeat1",
  [aux_sym_states_definition_repeat2] = "states_definition_repeat2",
  [aux_sym_animate_body_repeat1] = "animate_body_repeat1",
  [aux_sym_type_list_repeat1] = "type_list_repeat1",
  [aux_sym_tr_repeat1] = "tr_repeat1",
  [aux_sym_function_definition_repeat1] = "function_definition_repeat1",
  [aux_sym_gradient_call_repeat1] = "gradient_call_repeat1",
  [aux_sym_image_call_repeat1] = "image_call_repeat1",
  [aux_sym__function_signature_repeat1] = "_function_signature_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [aux_sym__string_repeat1] = "_string_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_export] = sym_export,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_component] = anon_sym_component,
  [anon_sym_inherits] = anon_sym_inherits,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_property] = anon_sym_property,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_LT_EQ_GT] = anon_sym_LT_EQ_GT,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_out] = anon_sym_out,
  [anon_sym_transitions] = anon_sym_transitions,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_states] = anon_sym_states,
  [anon_sym_when] = anon_sym_when,
  [anon_sym_animate] = anon_sym_animate,
  [anon_sym_delay] = anon_sym_delay,
  [anon_sym_duration] = anon_sym_duration,
  [anon_sym_iteration_DASHcount] = anon_sym_iteration_DASHcount,
  [anon_sym_direction] = anon_sym_direction,
  [anon_sym_easing] = anon_sym_easing,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_ATtr] = anon_sym_ATtr,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_DOT] = anon_sym_DOT,
  [sym_logical_and] = sym_logical_and,
  [sym_logical_or] = sym_logical_or,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_callback] = anon_sym_callback,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_pure] = anon_sym_pure,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_changed] = anon_sym_changed,
  [anon_sym_ATimage_DASHurl] = anon_sym_ATimage_DASHurl,
  [anon_sym_nine_DASHslice] = anon_sym_nine_DASHslice,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [sym__unescaped_string_fragment] = sym__unescaped_string_fragment,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [aux_sym_escape_sequence_token1] = aux_sym_escape_sequence_token1,
  [anon_sym_n] = anon_sym_n,
  [anon_sym_in_DASHout] = anon_sym_in_DASHout,
  [sym__identifier] = sym__identifier,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_float] = anon_sym_float,
  [anon_sym_bool] = anon_sym_bool,
  [anon_sym_string] = anon_sym_string,
  [anon_sym_color] = anon_sym_color,
  [anon_sym_brush] = anon_sym_brush,
  [anon_sym_physical_DASHlength] = anon_sym_physical_DASHlength,
  [anon_sym_length] = anon_sym_length,
  [anon_sym_angle] = anon_sym_angle,
  [anon_sym_percent] = anon_sym_percent,
  [anon_sym_image] = anon_sym_image,
  [anon_sym_relative_DASHfont_DASHsize] = anon_sym_relative_DASHfont_DASHsize,
  [anon_sym_linear] = anon_sym_linear,
  [anon_sym_ease_DASHin_DASHquad] = anon_sym_ease_DASHin_DASHquad,
  [anon_sym_ease_DASHout_DASHquad] = anon_sym_ease_DASHout_DASHquad,
  [anon_sym_ease_DASHin_DASHout_DASHquad] = anon_sym_ease_DASHin_DASHout_DASHquad,
  [anon_sym_ease] = anon_sym_ease,
  [anon_sym_ease_DASHin] = anon_sym_ease_DASHin,
  [anon_sym_ease_DASHout] = anon_sym_ease_DASHout,
  [anon_sym_ease_DASHin_DASHout] = anon_sym_ease_DASHin_DASHout,
  [anon_sym_ease_DASHin_DASHquart] = anon_sym_ease_DASHin_DASHquart,
  [anon_sym_ease_DASHout_DASHquart] = anon_sym_ease_DASHout_DASHquart,
  [anon_sym_ease_DASHin_DASHout_DASHquart] = anon_sym_ease_DASHin_DASHout_DASHquart,
  [anon_sym_ease_DASHin_DASHquint] = anon_sym_ease_DASHin_DASHquint,
  [anon_sym_ease_DASHout_DASHquint] = anon_sym_ease_DASHout_DASHquint,
  [anon_sym_ease_DASHin_DASHout_DASHquint] = anon_sym_ease_DASHin_DASHout_DASHquint,
  [anon_sym_ease_DASHin_DASHexpo] = anon_sym_ease_DASHin_DASHexpo,
  [anon_sym_ease_DASHout_DASHexpo] = anon_sym_ease_DASHout_DASHexpo,
  [anon_sym_ease_DASHin_DASHout_DASHexpo] = anon_sym_ease_DASHin_DASHout_DASHexpo,
  [anon_sym_ease_DASHin_DASHsine] = anon_sym_ease_DASHin_DASHsine,
  [anon_sym_ease_DASHout_DASHsine] = anon_sym_ease_DASHout_DASHsine,
  [anon_sym_ease_DASHin_DASHout_DASHsine] = anon_sym_ease_DASHin_DASHout_DASHsine,
  [anon_sym_ease_DASHin_DASHback] = anon_sym_ease_DASHin_DASHback,
  [anon_sym_ease_DASHout_DASHback] = anon_sym_ease_DASHout_DASHback,
  [anon_sym_ease_DASHin_DASHout_DASHback] = anon_sym_ease_DASHin_DASHout_DASHback,
  [anon_sym_ease_DASHin_DASHcirc] = anon_sym_ease_DASHin_DASHcirc,
  [anon_sym_ease_DASHout_DASHcirc] = anon_sym_ease_DASHout_DASHcirc,
  [anon_sym_ease_DASHin_DASHout_DASHcirc] = anon_sym_ease_DASHin_DASHout_DASHcirc,
  [anon_sym_ease_DASHin_DASHelastic] = anon_sym_ease_DASHin_DASHelastic,
  [anon_sym_ease_DASHout_DASHelastic] = anon_sym_ease_DASHout_DASHelastic,
  [anon_sym_ease_DASHin_DASHout_DASHelastic] = anon_sym_ease_DASHin_DASHout_DASHelastic,
  [anon_sym_ease_DASHin_DASHbounce] = anon_sym_ease_DASHin_DASHbounce,
  [anon_sym_ease_DASHout_DASHbounce] = anon_sym_ease_DASHout_DASHbounce,
  [anon_sym_ease_DASHin_DASHout_DASHbounce] = anon_sym_ease_DASHin_DASHout_DASHbounce,
  [anon_sym_cubic_DASHbezier] = anon_sym_cubic_DASHbezier,
  [sym_children_identifier] = sym_children_identifier,
  [anon_sym_ATlinear_DASHgradient] = anon_sym_ATlinear_DASHgradient,
  [anon_sym_ATlinear_gradient] = anon_sym_ATlinear_gradient,
  [anon_sym_ATradial_DASHgradient] = anon_sym_ATradial_DASHgradient,
  [anon_sym_ATradial_gradient] = anon_sym_ATradial_gradient,
  [anon_sym_circle] = anon_sym_circle,
  [anon_sym_parent] = anon_sym_parent,
  [anon_sym_root] = anon_sym_root,
  [anon_sym_self] = anon_sym_self,
  [sym__int_number] = sym__int_number,
  [sym__float_number] = sym__float_number,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [sym_color_value] = sym_color_value,
  [anon_sym_phx] = anon_sym_phx,
  [aux_sym_length_value_token1] = aux_sym_length_value_token1,
  [aux_sym_duration_value_token1] = aux_sym_duration_value_token1,
  [aux_sym_angle_value_token1] = aux_sym_angle_value_token1,
  [anon_sym_PERCENT2] = anon_sym_PERCENT,
  [anon_sym_rem] = anon_sym_rem,
  [sym_comment] = sym_comment,
  [sym_sourcefile] = sym_sourcefile,
  [sym__definition] = sym__definition,
  [sym__local_type] = sym__local_type,
  [sym__exported_type] = sym__exported_type,
  [sym_import_statement] = sym_import_statement,
  [sym_export_type] = sym_export_type,
  [sym_import_type] = sym_import_type,
  [sym_component] = sym_component,
  [sym_component_definition] = sym_component_definition,
  [sym__property_type] = sym__property_type,
  [sym_imperative_block] = sym_imperative_block,
  [sym__imperative_block_statement] = sym__imperative_block_statement,
  [sym__binding] = sym__binding,
  [sym_property] = sym_property,
  [sym_binding_alias] = sym_binding_alias,
  [sym_binding] = sym_binding,
  [sym_global_block] = sym_global_block,
  [sym_global_definition] = sym_global_definition,
  [sym_struct_block] = sym_struct_block,
  [sym_struct_definition] = sym_struct_definition,
  [sym_enum_block] = sym_enum_block,
  [sym_enum_definition] = sym_enum_definition,
  [sym_anon_struct_block] = sym_anon_struct_block,
  [sym_block] = sym_block,
  [sym__block_statement] = sym__block_statement,
  [sym_property_assignment] = sym_property_assignment,
  [sym_in_out_transition] = sym_in_out_transition,
  [sym_transitions_definition] = sym_transitions_definition,
  [sym_states_definition] = sym_states_definition,
  [sym_animate_statement] = sym_animate_statement,
  [sym_animate_option_identifier] = sym_animate_option_identifier,
  [sym_animate_option] = sym_animate_option,
  [sym_animate_body] = sym_animate_body,
  [sym_if_expr] = sym_if_expr,
  [sym_if_statement] = sym_if_statement,
  [sym_for_loop] = sym_for_loop,
  [sym_for_range] = sym_for_range,
  [sym_type_list] = sym_type_list,
  [sym_type] = sym_type,
  [sym__assignment_setup] = sym__assignment_setup,
  [sym__assignment_value_block] = sym__assignment_value_block,
  [sym_assignment_block] = sym_assignment_block,
  [sym_assignment_expr] = sym_assignment_expr,
  [sym_expression] = sym_expression,
  [sym_parens_op] = sym_parens_op,
  [sym_index_op] = sym_index_op,
  [sym_tr] = sym_tr,
  [sym_member_access] = sym_member_access,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym__add_binary_expression] = sym__add_binary_expression,
  [sym__comparison_binary_expression] = sym__comparison_binary_expression,
  [sym__logic_binary_expression] = sym__logic_binary_expression,
  [sym__mult_binary_expression] = sym__mult_binary_expression,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_callback] = sym_callback,
  [sym_purity] = sym_purity,
  [sym_function_visibility] = sym_function_visibility,
  [sym_function_definition] = sym_function_definition,
  [sym_callback_alias] = sym_callback_alias,
  [sym_callback_event] = sym_callback_event,
  [sym_changed_callback] = sym_changed_callback,
  [sym_function_call] = sym_function_call,
  [sym_gradient_call] = sym_gradient_call,
  [sym_gradient_color] = sym_gradient_color,
  [sym_image_call] = sym_image_call,
  [sym_typed_identifier] = sym_typed_identifier,
  [sym__function_signature] = sym__function_signature,
  [sym__callback_signature] = sym__callback_signature,
  [sym_argument] = sym_argument,
  [sym_arguments] = sym_arguments,
  [sym_unary_prec_operator] = sym_unary_prec_operator,
  [sym_add_prec_operator] = sym_add_prec_operator,
  [sym_mult_prec_operator] = sym_mult_prec_operator,
  [sym_comparison_operator] = sym_comparison_operator,
  [sym_assignment_prec_operator] = sym_assignment_prec_operator,
  [sym__string] = sym__string,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_property_visibility] = sym_property_visibility,
  [sym_simple_identifier] = sym_simple_identifier,
  [sym_simple_indexed_identifier] = sym_simple_indexed_identifier,
  [sym_builtin_type_identifier] = sym_builtin_type_identifier,
  [sym_easing_kind_identifier] = sym_easing_kind_identifier,
  [sym_user_type_identifier] = sym_user_type_identifier,
  [sym__type_identifier] = sym__type_identifier,
  [sym_value_list] = sym_value_list,
  [sym_value] = sym_value,
  [sym_linear_gradient_identifier] = sym_linear_gradient_identifier,
  [sym_radial_gradient_identifier] = sym_radial_gradient_identifier,
  [sym_radial_gradient_kind] = sym_radial_gradient_kind,
  [sym_reference_identifier] = sym_reference_identifier,
  [sym__number] = sym__number,
  [sym_int_value] = sym_int_value,
  [sym_float_value] = sym_float_value,
  [sym_bool_value] = sym_bool_value,
  [sym_string_value] = sym_string_value,
  [sym_physical_length_value] = sym_physical_length_value,
  [sym_length_value] = sym_length_value,
  [sym_duration_value] = sym_duration_value,
  [sym_angle_value] = sym_angle_value,
  [sym_percent_value] = sym_percent_value,
  [sym_relative_font_size_value] = sym_relative_font_size_value,
  [sym__basic_value] = sym__basic_value,
  [aux_sym_sourcefile_repeat1] = aux_sym_sourcefile_repeat1,
  [aux_sym__exported_type_repeat1] = aux_sym__exported_type_repeat1,
  [aux_sym_import_statement_repeat1] = aux_sym_import_statement_repeat1,
  [aux_sym_imperative_block_repeat1] = aux_sym_imperative_block_repeat1,
  [aux_sym_global_block_repeat1] = aux_sym_global_block_repeat1,
  [aux_sym_struct_block_repeat1] = aux_sym_struct_block_repeat1,
  [aux_sym_enum_block_repeat1] = aux_sym_enum_block_repeat1,
  [aux_sym_anon_struct_block_repeat1] = aux_sym_anon_struct_block_repeat1,
  [aux_sym_block_repeat1] = aux_sym_block_repeat1,
  [aux_sym_in_out_transition_repeat1] = aux_sym_in_out_transition_repeat1,
  [aux_sym_transitions_definition_repeat1] = aux_sym_transitions_definition_repeat1,
  [aux_sym_states_definition_repeat1] = aux_sym_states_definition_repeat1,
  [aux_sym_states_definition_repeat2] = aux_sym_states_definition_repeat2,
  [aux_sym_animate_body_repeat1] = aux_sym_animate_body_repeat1,
  [aux_sym_type_list_repeat1] = aux_sym_type_list_repeat1,
  [aux_sym_tr_repeat1] = aux_sym_tr_repeat1,
  [aux_sym_function_definition_repeat1] = aux_sym_function_definition_repeat1,
  [aux_sym_gradient_call_repeat1] = aux_sym_gradient_call_repeat1,
  [aux_sym_image_call_repeat1] = aux_sym_image_call_repeat1,
  [aux_sym__function_signature_repeat1] = aux_sym__function_signature_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [aux_sym__string_repeat1] = aux_sym__string_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_export] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_component] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inherits] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_property] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_out] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_transitions] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_states] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_when] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_animate] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delay] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_duration] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iteration_DASHcount] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_direction] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_easing] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATtr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [sym_logical_and] = {
    .visible = true,
    .named = true,
  },
  [sym_logical_or] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_callback] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pure] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_changed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATimage_DASHurl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nine_DASHslice] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym__unescaped_string_fragment] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_escape_sequence_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_n] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in_DASHout] = {
    .visible = true,
    .named = false,
  },
  [sym__identifier] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bool] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_color] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_brush] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_physical_DASHlength] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_length] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_angle] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_percent] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_image] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_relative_DASHfont_DASHsize] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_linear] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHquad] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHout_DASHquad] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHout_DASHquad] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHout] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHout] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHquart] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHout_DASHquart] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHout_DASHquart] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHquint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHout_DASHquint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHout_DASHquint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHexpo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHout_DASHexpo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHout_DASHexpo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHsine] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHout_DASHsine] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHout_DASHsine] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHback] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHout_DASHback] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHout_DASHback] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHcirc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHout_DASHcirc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHout_DASHcirc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHelastic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHout_DASHelastic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHout_DASHelastic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHbounce] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHout_DASHbounce] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHout_DASHbounce] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cubic_DASHbezier] = {
    .visible = true,
    .named = false,
  },
  [sym_children_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATlinear_DASHgradient] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATlinear_gradient] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATradial_DASHgradient] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATradial_gradient] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_circle] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_parent] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_root] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_self] = {
    .visible = true,
    .named = false,
  },
  [sym__int_number] = {
    .visible = false,
    .named = true,
  },
  [sym__float_number] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [sym_color_value] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_phx] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_length_value_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_duration_value_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_angle_value_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_PERCENT2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rem] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_sourcefile] = {
    .visible = true,
    .named = true,
  },
  [sym__definition] = {
    .visible = false,
    .named = true,
  },
  [sym__local_type] = {
    .visible = false,
    .named = true,
  },
  [sym__exported_type] = {
    .visible = false,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_export_type] = {
    .visible = true,
    .named = true,
  },
  [sym_import_type] = {
    .visible = true,
    .named = true,
  },
  [sym_component] = {
    .visible = true,
    .named = true,
  },
  [sym_component_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__property_type] = {
    .visible = false,
    .named = true,
  },
  [sym_imperative_block] = {
    .visible = true,
    .named = true,
  },
  [sym__imperative_block_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__binding] = {
    .visible = false,
    .named = true,
  },
  [sym_property] = {
    .visible = true,
    .named = true,
  },
  [sym_binding_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_global_block] = {
    .visible = true,
    .named = true,
  },
  [sym_global_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_block] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_block] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_anon_struct_block] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym__block_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_property_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_in_out_transition] = {
    .visible = true,
    .named = true,
  },
  [sym_transitions_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_states_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_animate_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_animate_option_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_animate_option] = {
    .visible = true,
    .named = true,
  },
  [sym_animate_body] = {
    .visible = true,
    .named = true,
  },
  [sym_if_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_loop] = {
    .visible = true,
    .named = true,
  },
  [sym_for_range] = {
    .visible = true,
    .named = true,
  },
  [sym_type_list] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym__assignment_setup] = {
    .visible = false,
    .named = true,
  },
  [sym__assignment_value_block] = {
    .visible = false,
    .named = true,
  },
  [sym_assignment_block] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parens_op] = {
    .visible = true,
    .named = true,
  },
  [sym_index_op] = {
    .visible = true,
    .named = true,
  },
  [sym_tr] = {
    .visible = true,
    .named = true,
  },
  [sym_member_access] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__add_binary_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__comparison_binary_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__logic_binary_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__mult_binary_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_callback] = {
    .visible = true,
    .named = true,
  },
  [sym_purity] = {
    .visible = true,
    .named = true,
  },
  [sym_function_visibility] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_callback_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_callback_event] = {
    .visible = true,
    .named = true,
  },
  [sym_changed_callback] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym_gradient_call] = {
    .visible = true,
    .named = true,
  },
  [sym_gradient_color] = {
    .visible = true,
    .named = true,
  },
  [sym_image_call] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__function_signature] = {
    .visible = false,
    .named = true,
  },
  [sym__callback_signature] = {
    .visible = false,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_prec_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_add_prec_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_mult_prec_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_comparison_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_prec_operator] = {
    .visible = true,
    .named = true,
  },
  [sym__string] = {
    .visible = false,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_property_visibility] = {
    .visible = true,
    .named = true,
  },
  [sym_simple_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_simple_indexed_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_builtin_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_easing_kind_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_user_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__type_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_value_list] = {
    .visible = true,
    .named = true,
  },
  [sym_value] = {
    .visible = true,
    .named = true,
  },
  [sym_linear_gradient_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_radial_gradient_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_radial_gradient_kind] = {
    .visible = true,
    .named = true,
  },
  [sym_reference_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__number] = {
    .visible = false,
    .named = true,
  },
  [sym_int_value] = {
    .visible = true,
    .named = true,
  },
  [sym_float_value] = {
    .visible = true,
    .named = true,
  },
  [sym_bool_value] = {
    .visible = true,
    .named = true,
  },
  [sym_string_value] = {
    .visible = true,
    .named = true,
  },
  [sym_physical_length_value] = {
    .visible = true,
    .named = true,
  },
  [sym_length_value] = {
    .visible = true,
    .named = true,
  },
  [sym_duration_value] = {
    .visible = true,
    .named = true,
  },
  [sym_angle_value] = {
    .visible = true,
    .named = true,
  },
  [sym_percent_value] = {
    .visible = true,
    .named = true,
  },
  [sym_relative_font_size_value] = {
    .visible = true,
    .named = true,
  },
  [sym__basic_value] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_sourcefile_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__exported_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_imperative_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_global_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_anon_struct_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_in_out_transition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_transitions_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_states_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_states_definition_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_animate_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gradient_call_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_image_call_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__function_signature_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__string_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_action = 1,
  field_alias = 2,
  field_angle = 3,
  field_arguments = 4,
  field_base = 5,
  field_base_type = 6,
  field_binding = 7,
  field_binding_op = 8,
  field_colors = 9,
  field_condition = 10,
  field_context = 11,
  field_export_name = 12,
  field_expression = 13,
  field_id = 14,
  field_identifier = 15,
  field_image = 16,
  field_import_name = 17,
  field_index = 18,
  field_index_var = 19,
  field_left = 20,
  field_local_name = 21,
  field_member = 22,
  field_message = 23,
  field_name = 24,
  field_op = 25,
  field_option = 26,
  field_percent = 27,
  field_pipe = 28,
  field_property = 29,
  field_range = 30,
  field_return_type = 31,
  field_right = 32,
  field_type = 33,
  field_value = 34,
  field_visibility = 35,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_action] = "action",
  [field_alias] = "alias",
  [field_angle] = "angle",
  [field_arguments] = "arguments",
  [field_base] = "base",
  [field_base_type] = "base_type",
  [field_binding] = "binding",
  [field_binding_op] = "binding_op",
  [field_colors] = "colors",
  [field_condition] = "condition",
  [field_context] = "context",
  [field_export_name] = "export_name",
  [field_expression] = "expression",
  [field_id] = "id",
  [field_identifier] = "identifier",
  [field_image] = "image",
  [field_import_name] = "import_name",
  [field_index] = "index",
  [field_index_var] = "index_var",
  [field_left] = "left",
  [field_local_name] = "local_name",
  [field_member] = "member",
  [field_message] = "message",
  [field_name] = "name",
  [field_op] = "op",
  [field_option] = "option",
  [field_percent] = "percent",
  [field_pipe] = "pipe",
  [field_property] = "property",
  [field_range] = "range",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_type] = "type",
  [field_value] = "value",
  [field_visibility] = "visibility",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 1},
  [5] = {.index = 4, .length = 2},
  [6] = {.index = 6, .length = 2},
  [7] = {.index = 8, .length = 2},
  [8] = {.index = 10, .length = 3},
  [9] = {.index = 13, .length = 1},
  [10] = {.index = 14, .length = 2},
  [11] = {.index = 16, .length = 1},
  [12] = {.index = 17, .length = 2},
  [13] = {.index = 19, .length = 2},
  [14] = {.index = 21, .length = 2},
  [15] = {.index = 23, .length = 2},
  [16] = {.index = 25, .length = 2},
  [17] = {.index = 27, .length = 2},
  [18] = {.index = 29, .length = 1},
  [19] = {.index = 30, .length = 2},
  [20] = {.index = 32, .length = 3},
  [21] = {.index = 35, .length = 1},
  [22] = {.index = 36, .length = 2},
  [23] = {.index = 38, .length = 1},
  [24] = {.index = 39, .length = 1},
  [25] = {.index = 40, .length = 2},
  [26] = {.index = 42, .length = 2},
  [27] = {.index = 44, .length = 1},
  [28] = {.index = 45, .length = 2},
  [29] = {.index = 47, .length = 3},
  [30] = {.index = 50, .length = 2},
  [31] = {.index = 52, .length = 2},
  [32] = {.index = 54, .length = 1},
  [33] = {.index = 55, .length = 2},
  [34] = {.index = 57, .length = 2},
  [35] = {.index = 59, .length = 1},
  [36] = {.index = 60, .length = 4},
  [37] = {.index = 64, .length = 2},
  [38] = {.index = 66, .length = 2},
  [39] = {.index = 68, .length = 1},
  [40] = {.index = 69, .length = 2},
  [41] = {.index = 71, .length = 3},
  [42] = {.index = 74, .length = 3},
  [43] = {.index = 77, .length = 2},
  [44] = {.index = 79, .length = 2},
  [45] = {.index = 81, .length = 3},
  [46] = {.index = 84, .length = 3},
  [47] = {.index = 87, .length = 4},
  [48] = {.index = 91, .length = 4},
  [49] = {.index = 95, .length = 3},
  [50] = {.index = 98, .length = 2},
  [51] = {.index = 100, .length = 3},
  [52] = {.index = 103, .length = 2},
  [53] = {.index = 105, .length = 2},
  [54] = {.index = 107, .length = 3},
  [55] = {.index = 110, .length = 2},
  [56] = {.index = 112, .length = 2},
  [57] = {.index = 114, .length = 2},
  [58] = {.index = 116, .length = 2},
  [59] = {.index = 118, .length = 2},
  [60] = {.index = 120, .length = 5},
  [61] = {.index = 125, .length = 3},
  [62] = {.index = 128, .length = 3},
  [63] = {.index = 131, .length = 3},
  [64] = {.index = 134, .length = 2},
  [65] = {.index = 136, .length = 3},
  [66] = {.index = 139, .length = 3},
  [67] = {.index = 142, .length = 4},
  [68] = {.index = 146, .length = 4},
  [69] = {.index = 150, .length = 5},
  [70] = {.index = 155, .length = 5},
  [71] = {.index = 160, .length = 3},
  [72] = {.index = 163, .length = 6},
  [73] = {.index = 169, .length = 6},
  [74] = {.index = 175, .length = 6},
  [75] = {.index = 181, .length = 7},
  [76] = {.index = 188, .length = 7},
  [77] = {.index = 195, .length = 7},
  [78] = {.index = 202, .length = 7},
  [79] = {.index = 209, .length = 7},
  [80] = {.index = 216, .length = 5},
  [81] = {.index = 221, .length = 5},
  [82] = {.index = 226, .length = 8},
  [83] = {.index = 234, .length = 8},
  [84] = {.index = 242, .length = 6},
  [85] = {.index = 248, .length = 7},
  [86] = {.index = 255, .length = 7},
  [87] = {.index = 262, .length = 8},
  [88] = {.index = 270, .length = 9},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_local_name, 0},
  [1] =
    {field_import_name, 0},
  [2] =
    {field_name, 1},
  [3] =
    {field_value, 0},
  [4] =
    {field_base_type, 2},
    {field_name, 0},
  [6] =
    {field_export_name, 2},
    {field_local_name, 0},
  [8] =
    {field_import_name, 0},
    {field_local_name, 2},
  [10] =
    {field_left, 0, .inherited = true},
    {field_op, 0, .inherited = true},
    {field_right, 0, .inherited = true},
  [13] =
    {field_name, 0},
  [14] =
    {field_arguments, 1},
    {field_name, 0},
  [16] =
    {field_type, 0},
  [17] =
    {field_base_type, 3},
    {field_name, 1},
  [19] =
    {field_left, 1},
    {field_op, 0},
  [21] =
    {field_action, 2},
    {field_name, 0},
  [23] =
    {field_property, 0},
    {field_value, 2},
  [25] =
    {field_name, 1},
    {field_name, 2, .inherited = true},
  [27] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [29] =
    {field_left, 1},
  [30] =
    {field_base, 0},
    {field_member, 2},
  [32] =
    {field_left, 0},
    {field_op, 1},
    {field_right, 2},
  [35] =
    {field_type, 1},
  [36] =
    {field_name, 2},
    {field_type, 1, .inherited = true},
  [38] =
    {field_name, 2, .inherited = true},
  [39] =
    {field_condition, 1},
  [40] =
    {field_arguments, 2, .inherited = true},
    {field_name, 1},
  [42] =
    {field_action, 3},
    {field_name, 1},
  [44] =
    {field_name, 2},
  [45] =
    {field_id, 0},
    {field_type, 2},
  [47] =
    {field_property, 0},
    {field_value, 2},
    {field_value, 3},
  [50] =
    {field_alias, 2},
    {field_name, 0},
  [52] =
    {field_name, 1},
    {field_type, 3},
  [54] =
    {field_message, 2},
  [55] =
    {field_image, 2},
    {field_name, 0},
  [57] =
    {field_index, 2},
    {field_left, 0},
  [59] =
    {field_binding, 0},
  [60] =
    {field_binding, 4, .inherited = true},
    {field_binding_op, 3},
    {field_name, 2},
    {field_type, 1, .inherited = true},
  [64] =
    {field_alias, 3},
    {field_name, 1},
  [66] =
    {field_index_var, 2},
    {field_name, 0},
  [68] =
    {field_arguments, 1},
  [69] =
    {field_name, 1},
    {field_return_type, 3},
  [71] =
    {field_name, 0, .inherited = true},
    {field_op, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [74] =
    {field_name, 0, .inherited = true},
    {field_op, 0, .inherited = true},
    {field_value, 1},
  [77] =
    {field_name, 0},
    {field_op, 1},
  [79] =
    {field_arguments, 3, .inherited = true},
    {field_name, 2},
  [81] =
    {field_name, 3},
    {field_type, 2, .inherited = true},
    {field_visibility, 0},
  [84] =
    {field_alias, 3},
    {field_name, 1},
    {field_visibility, 0},
  [87] =
    {field_name, 1},
    {field_name, 4, .inherited = true},
    {field_type, 3},
    {field_type, 4, .inherited = true},
  [91] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [95] =
    {field_condition, 0},
    {field_left, 2},
    {field_right, 4},
  [98] =
    {field_binding, 0},
    {field_binding, 1},
  [100] =
    {field_binding_op, 3},
    {field_name, 2},
    {field_type, 1, .inherited = true},
  [103] =
    {field_identifier, 1},
    {field_range, 3},
  [105] =
    {field_arguments, 1},
    {field_arguments, 2},
  [107] =
    {field_arguments, 2, .inherited = true},
    {field_name, 1},
    {field_return_type, 4},
  [110] =
    {field_value, 0},
    {field_value, 1},
  [112] =
    {field_binding, 2, .inherited = true},
    {field_name, 0},
  [114] =
    {field_name, 0},
    {field_type, 2},
  [116] =
    {field_alias, 4},
    {field_name, 2},
  [118] =
    {field_name, 2},
    {field_return_type, 4},
  [120] =
    {field_binding, 5, .inherited = true},
    {field_binding_op, 4},
    {field_name, 3},
    {field_type, 2, .inherited = true},
    {field_visibility, 0},
  [125] =
    {field_alias, 4},
    {field_name, 2},
    {field_visibility, 0},
  [128] =
    {field_arguments, 3},
    {field_arguments, 4},
    {field_message, 2},
  [131] =
    {field_context, 2},
    {field_context, 3},
    {field_message, 4},
  [134] =
    {field_expression, 2},
    {field_option, 0},
  [136] =
    {field_arguments, 1},
    {field_arguments, 2},
    {field_arguments, 3},
  [139] =
    {field_arguments, 3, .inherited = true},
    {field_name, 2},
    {field_return_type, 5},
  [142] =
    {field_binding_op, 4},
    {field_name, 3},
    {field_type, 2, .inherited = true},
    {field_visibility, 0},
  [146] =
    {field_arguments, 3},
    {field_arguments, 4},
    {field_arguments, 5},
    {field_message, 2},
  [150] =
    {field_arguments, 3},
    {field_arguments, 4},
    {field_arguments, 5},
    {field_arguments, 6},
    {field_message, 2},
  [155] =
    {field_arguments, 5},
    {field_arguments, 6},
    {field_context, 2},
    {field_context, 3},
    {field_message, 4},
  [160] =
    {field_message, 2},
    {field_percent, 6},
    {field_pipe, 4},
  [163] =
    {field_angle, 2},
    {field_arguments, 3},
    {field_colors, 4},
    {field_colors, 5},
    {field_colors, 6},
    {field_name, 0},
  [169] =
    {field_arguments, 3},
    {field_colors, 4},
    {field_colors, 5},
    {field_colors, 6},
    {field_name, 0},
    {field_type, 2},
  [175] =
    {field_arguments, 5},
    {field_arguments, 6},
    {field_arguments, 7},
    {field_context, 2},
    {field_context, 3},
    {field_message, 4},
  [181] =
    {field_angle, 2},
    {field_arguments, 3},
    {field_arguments, 7},
    {field_colors, 4},
    {field_colors, 5},
    {field_colors, 6},
    {field_name, 0},
  [188] =
    {field_angle, 2},
    {field_arguments, 3},
    {field_colors, 4},
    {field_colors, 5},
    {field_colors, 6},
    {field_colors, 7},
    {field_name, 0},
  [195] =
    {field_arguments, 3},
    {field_arguments, 7},
    {field_colors, 4},
    {field_colors, 5},
    {field_colors, 6},
    {field_name, 0},
    {field_type, 2},
  [202] =
    {field_arguments, 3},
    {field_colors, 4},
    {field_colors, 5},
    {field_colors, 6},
    {field_colors, 7},
    {field_name, 0},
    {field_type, 2},
  [209] =
    {field_arguments, 5},
    {field_arguments, 6},
    {field_arguments, 7},
    {field_arguments, 8},
    {field_context, 2},
    {field_context, 3},
    {field_message, 4},
  [216] =
    {field_context, 2},
    {field_context, 3},
    {field_message, 4},
    {field_percent, 8},
    {field_pipe, 6},
  [221] =
    {field_arguments, 7},
    {field_arguments, 8},
    {field_message, 2},
    {field_percent, 6},
    {field_pipe, 4},
  [226] =
    {field_angle, 2},
    {field_arguments, 3},
    {field_arguments, 8},
    {field_colors, 4},
    {field_colors, 5},
    {field_colors, 6},
    {field_colors, 7},
    {field_name, 0},
  [234] =
    {field_arguments, 3},
    {field_arguments, 8},
    {field_colors, 4},
    {field_colors, 5},
    {field_colors, 6},
    {field_colors, 7},
    {field_name, 0},
    {field_type, 2},
  [242] =
    {field_arguments, 7},
    {field_arguments, 8},
    {field_arguments, 9},
    {field_message, 2},
    {field_percent, 6},
    {field_pipe, 4},
  [248] =
    {field_arguments, 9},
    {field_arguments, 10},
    {field_context, 2},
    {field_context, 3},
    {field_message, 4},
    {field_percent, 8},
    {field_pipe, 6},
  [255] =
    {field_arguments, 7},
    {field_arguments, 8},
    {field_arguments, 9},
    {field_arguments, 10},
    {field_message, 2},
    {field_percent, 6},
    {field_pipe, 4},
  [262] =
    {field_arguments, 9},
    {field_arguments, 10},
    {field_arguments, 11},
    {field_context, 2},
    {field_context, 3},
    {field_message, 4},
    {field_percent, 8},
    {field_pipe, 6},
  [270] =
    {field_arguments, 9},
    {field_arguments, 10},
    {field_arguments, 11},
    {field_arguments, 12},
    {field_context, 2},
    {field_context, 3},
    {field_message, 4},
    {field_percent, 8},
    {field_pipe, 6},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 2,
  [5] = 2,
  [6] = 2,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 9,
  [11] = 9,
  [12] = 7,
  [13] = 9,
  [14] = 7,
  [15] = 7,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 22,
  [24] = 21,
  [25] = 20,
  [26] = 19,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 32,
  [34] = 29,
  [35] = 35,
  [36] = 36,
  [37] = 27,
  [38] = 38,
  [39] = 28,
  [40] = 35,
  [41] = 41,
  [42] = 42,
  [43] = 41,
  [44] = 44,
  [45] = 42,
  [46] = 46,
  [47] = 47,
  [48] = 36,
  [49] = 46,
  [50] = 47,
  [51] = 29,
  [52] = 30,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 53,
  [62] = 55,
  [63] = 63,
  [64] = 64,
  [65] = 63,
  [66] = 66,
  [67] = 67,
  [68] = 54,
  [69] = 56,
  [70] = 59,
  [71] = 66,
  [72] = 72,
  [73] = 57,
  [74] = 58,
  [75] = 72,
  [76] = 67,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 79,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 86,
  [106] = 88,
  [107] = 91,
  [108] = 92,
  [109] = 95,
  [110] = 110,
  [111] = 104,
  [112] = 86,
  [113] = 79,
  [114] = 88,
  [115] = 91,
  [116] = 92,
  [117] = 95,
  [118] = 110,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 110,
  [127] = 104,
  [128] = 128,
  [129] = 100,
  [130] = 122,
  [131] = 83,
  [132] = 132,
  [133] = 89,
  [134] = 96,
  [135] = 97,
  [136] = 101,
  [137] = 103,
  [138] = 119,
  [139] = 124,
  [140] = 125,
  [141] = 81,
  [142] = 84,
  [143] = 85,
  [144] = 93,
  [145] = 94,
  [146] = 99,
  [147] = 89,
  [148] = 132,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 202,
  [203] = 203,
  [204] = 204,
  [205] = 205,
  [206] = 206,
  [207] = 207,
  [208] = 208,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 219,
  [220] = 220,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 230,
  [231] = 230,
  [232] = 230,
  [233] = 228,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 241,
  [244] = 244,
  [245] = 242,
  [246] = 246,
  [247] = 235,
  [248] = 237,
  [249] = 238,
  [250] = 236,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 239,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 263,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 267,
  [268] = 267,
  [269] = 267,
  [270] = 270,
  [271] = 271,
  [272] = 272,
  [273] = 270,
  [274] = 270,
  [275] = 270,
  [276] = 271,
  [277] = 228,
  [278] = 228,
  [279] = 166,
  [280] = 150,
  [281] = 149,
  [282] = 154,
  [283] = 176,
  [284] = 163,
  [285] = 160,
  [286] = 157,
  [287] = 173,
  [288] = 165,
  [289] = 172,
  [290] = 156,
  [291] = 158,
  [292] = 159,
  [293] = 152,
  [294] = 164,
  [295] = 153,
  [296] = 155,
  [297] = 162,
  [298] = 161,
  [299] = 200,
  [300] = 204,
  [301] = 206,
  [302] = 207,
  [303] = 208,
  [304] = 209,
  [305] = 210,
  [306] = 174,
  [307] = 175,
  [308] = 177,
  [309] = 178,
  [310] = 179,
  [311] = 180,
  [312] = 181,
  [313] = 182,
  [314] = 183,
  [315] = 184,
  [316] = 185,
  [317] = 186,
  [318] = 187,
  [319] = 188,
  [320] = 189,
  [321] = 190,
  [322] = 191,
  [323] = 192,
  [324] = 212,
  [325] = 193,
  [326] = 194,
  [327] = 214,
  [328] = 167,
  [329] = 195,
  [330] = 196,
  [331] = 197,
  [332] = 198,
  [333] = 199,
  [334] = 215,
  [335] = 225,
  [336] = 205,
  [337] = 216,
  [338] = 217,
  [339] = 218,
  [340] = 219,
  [341] = 220,
  [342] = 221,
  [343] = 228,
  [344] = 222,
  [345] = 223,
  [346] = 224,
  [347] = 168,
  [348] = 169,
  [349] = 170,
  [350] = 171,
  [351] = 202,
  [352] = 203,
  [353] = 201,
  [354] = 354,
  [355] = 355,
  [356] = 150,
  [357] = 149,
  [358] = 358,
  [359] = 359,
  [360] = 360,
  [361] = 361,
  [362] = 362,
  [363] = 363,
  [364] = 364,
  [365] = 365,
  [366] = 366,
  [367] = 367,
  [368] = 368,
  [369] = 369,
  [370] = 370,
  [371] = 366,
  [372] = 372,
  [373] = 373,
  [374] = 365,
  [375] = 364,
  [376] = 376,
  [377] = 370,
  [378] = 378,
  [379] = 154,
  [380] = 380,
  [381] = 159,
  [382] = 157,
  [383] = 163,
  [384] = 160,
  [385] = 165,
  [386] = 158,
  [387] = 387,
  [388] = 387,
  [389] = 156,
  [390] = 390,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 394,
  [395] = 395,
  [396] = 391,
  [397] = 392,
  [398] = 395,
  [399] = 399,
  [400] = 394,
  [401] = 393,
  [402] = 402,
  [403] = 402,
  [404] = 404,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 380,
  [409] = 227,
  [410] = 410,
  [411] = 411,
  [412] = 410,
  [413] = 405,
  [414] = 411,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 425,
  [426] = 426,
  [427] = 416,
  [428] = 418,
  [429] = 419,
  [430] = 424,
  [431] = 431,
  [432] = 432,
  [433] = 433,
  [434] = 434,
  [435] = 423,
  [436] = 436,
  [437] = 425,
  [438] = 418,
  [439] = 439,
  [440] = 440,
  [441] = 246,
  [442] = 439,
  [443] = 432,
  [444] = 229,
  [445] = 445,
  [446] = 446,
  [447] = 235,
  [448] = 448,
  [449] = 426,
  [450] = 420,
  [451] = 433,
  [452] = 439,
  [453] = 453,
  [454] = 454,
  [455] = 455,
  [456] = 456,
  [457] = 457,
  [458] = 458,
  [459] = 459,
  [460] = 460,
  [461] = 461,
  [462] = 462,
  [463] = 463,
  [464] = 464,
  [465] = 465,
  [466] = 466,
  [467] = 467,
  [468] = 468,
  [469] = 469,
  [470] = 470,
  [471] = 471,
  [472] = 472,
  [473] = 251,
  [474] = 474,
  [475] = 255,
  [476] = 476,
  [477] = 477,
  [478] = 478,
  [479] = 479,
  [480] = 238,
  [481] = 481,
  [482] = 236,
  [483] = 483,
  [484] = 484,
  [485] = 485,
  [486] = 486,
  [487] = 487,
  [488] = 488,
  [489] = 472,
  [490] = 490,
  [491] = 491,
  [492] = 481,
  [493] = 493,
  [494] = 454,
  [495] = 495,
  [496] = 496,
  [497] = 497,
  [498] = 463,
  [499] = 499,
  [500] = 500,
  [501] = 501,
  [502] = 502,
  [503] = 503,
  [504] = 504,
  [505] = 505,
  [506] = 506,
  [507] = 507,
  [508] = 508,
  [509] = 509,
  [510] = 510,
  [511] = 511,
  [512] = 512,
  [513] = 513,
  [514] = 514,
  [515] = 515,
  [516] = 516,
  [517] = 517,
  [518] = 235,
  [519] = 246,
  [520] = 501,
  [521] = 484,
  [522] = 487,
  [523] = 453,
  [524] = 502,
  [525] = 476,
  [526] = 500,
  [527] = 455,
  [528] = 478,
  [529] = 251,
  [530] = 479,
  [531] = 462,
  [532] = 470,
  [533] = 486,
  [534] = 488,
  [535] = 490,
  [536] = 469,
  [537] = 497,
  [538] = 499,
  [539] = 466,
  [540] = 474,
  [541] = 255,
  [542] = 460,
  [543] = 509,
  [544] = 236,
  [545] = 506,
  [546] = 508,
  [547] = 461,
  [548] = 496,
  [549] = 549,
  [550] = 550,
  [551] = 551,
  [552] = 550,
  [553] = 551,
  [554] = 554,
  [555] = 555,
  [556] = 556,
  [557] = 557,
  [558] = 558,
  [559] = 238,
  [560] = 560,
  [561] = 561,
  [562] = 562,
  [563] = 563,
  [564] = 564,
  [565] = 565,
  [566] = 566,
  [567] = 567,
  [568] = 568,
  [569] = 569,
  [570] = 570,
  [571] = 571,
  [572] = 572,
  [573] = 573,
  [574] = 505,
  [575] = 575,
  [576] = 576,
  [577] = 577,
  [578] = 578,
  [579] = 579,
  [580] = 580,
  [581] = 581,
  [582] = 582,
  [583] = 583,
  [584] = 584,
  [585] = 582,
  [586] = 584,
  [587] = 587,
  [588] = 588,
  [589] = 589,
  [590] = 587,
  [591] = 591,
  [592] = 592,
  [593] = 593,
  [594] = 594,
  [595] = 595,
  [596] = 596,
  [597] = 597,
  [598] = 598,
  [599] = 599,
  [600] = 588,
  [601] = 601,
  [602] = 593,
  [603] = 603,
  [604] = 604,
  [605] = 603,
  [606] = 606,
  [607] = 606,
  [608] = 608,
  [609] = 609,
  [610] = 610,
  [611] = 611,
  [612] = 612,
  [613] = 613,
  [614] = 604,
  [615] = 615,
  [616] = 610,
  [617] = 617,
  [618] = 618,
  [619] = 619,
  [620] = 620,
  [621] = 621,
  [622] = 622,
  [623] = 623,
  [624] = 624,
  [625] = 621,
  [626] = 626,
  [627] = 627,
  [628] = 628,
  [629] = 629,
  [630] = 630,
  [631] = 631,
  [632] = 632,
  [633] = 633,
  [634] = 634,
  [635] = 634,
  [636] = 636,
  [637] = 637,
  [638] = 638,
  [639] = 639,
  [640] = 640,
  [641] = 641,
  [642] = 622,
  [643] = 643,
  [644] = 631,
  [645] = 645,
  [646] = 646,
  [647] = 647,
  [648] = 648,
  [649] = 649,
  [650] = 633,
  [651] = 649,
  [652] = 652,
  [653] = 643,
  [654] = 654,
  [655] = 655,
  [656] = 656,
  [657] = 657,
  [658] = 658,
  [659] = 659,
  [660] = 660,
  [661] = 661,
  [662] = 662,
  [663] = 663,
  [664] = 664,
  [665] = 665,
  [666] = 666,
  [667] = 667,
  [668] = 663,
  [669] = 669,
  [670] = 670,
  [671] = 256,
  [672] = 672,
  [673] = 664,
  [674] = 666,
  [675] = 675,
  [676] = 676,
  [677] = 258,
  [678] = 678,
  [679] = 679,
  [680] = 680,
  [681] = 681,
  [682] = 682,
  [683] = 683,
  [684] = 684,
  [685] = 685,
  [686] = 686,
  [687] = 687,
  [688] = 688,
  [689] = 689,
  [690] = 690,
  [691] = 691,
  [692] = 692,
  [693] = 687,
  [694] = 694,
  [695] = 695,
  [696] = 696,
  [697] = 697,
  [698] = 698,
  [699] = 699,
  [700] = 672,
  [701] = 701,
  [702] = 680,
  [703] = 703,
  [704] = 678,
  [705] = 705,
  [706] = 667,
  [707] = 707,
  [708] = 708,
  [709] = 682,
  [710] = 701,
  [711] = 711,
  [712] = 665,
  [713] = 713,
  [714] = 714,
  [715] = 715,
  [716] = 676,
  [717] = 717,
  [718] = 718,
  [719] = 719,
  [720] = 719,
  [721] = 721,
  [722] = 722,
  [723] = 723,
  [724] = 656,
  [725] = 725,
  [726] = 690,
  [727] = 727,
  [728] = 728,
  [729] = 685,
  [730] = 730,
  [731] = 731,
  [732] = 732,
  [733] = 733,
  [734] = 659,
  [735] = 257,
  [736] = 661,
  [737] = 737,
  [738] = 733,
  [739] = 713,
  [740] = 740,
  [741] = 660,
  [742] = 717,
  [743] = 662,
  [744] = 744,
  [745] = 745,
  [746] = 740,
  [747] = 692,
  [748] = 748,
  [749] = 749,
  [750] = 688,
  [751] = 751,
  [752] = 691,
  [753] = 753,
  [754] = 754,
  [755] = 755,
  [756] = 756,
  [757] = 757,
  [758] = 758,
  [759] = 759,
  [760] = 760,
  [761] = 761,
  [762] = 762,
  [763] = 467,
  [764] = 764,
  [765] = 765,
  [766] = 766,
  [767] = 767,
  [768] = 768,
  [769] = 769,
  [770] = 770,
  [771] = 771,
  [772] = 772,
  [773] = 757,
  [774] = 774,
  [775] = 775,
  [776] = 776,
  [777] = 491,
  [778] = 778,
  [779] = 779,
  [780] = 774,
  [781] = 781,
  [782] = 782,
  [783] = 783,
  [784] = 771,
  [785] = 785,
  [786] = 782,
  [787] = 787,
  [788] = 788,
  [789] = 789,
  [790] = 790,
  [791] = 772,
  [792] = 792,
  [793] = 793,
  [794] = 794,
  [795] = 795,
  [796] = 796,
  [797] = 797,
  [798] = 798,
  [799] = 799,
  [800] = 800,
  [801] = 801,
  [802] = 802,
  [803] = 803,
  [804] = 804,
  [805] = 754,
  [806] = 806,
  [807] = 807,
  [808] = 808,
  [809] = 766,
  [810] = 755,
  [811] = 811,
  [812] = 808,
  [813] = 759,
  [814] = 814,
  [815] = 797,
  [816] = 816,
  [817] = 817,
  [818] = 818,
  [819] = 819,
  [820] = 785,
  [821] = 821,
  [822] = 822,
  [823] = 787,
  [824] = 824,
  [825] = 754,
  [826] = 826,
  [827] = 827,
  [828] = 828,
  [829] = 829,
  [830] = 830,
  [831] = 831,
  [832] = 832,
  [833] = 458,
  [834] = 778,
  [835] = 835,
  [836] = 836,
  [837] = 837,
  [838] = 838,
  [839] = 839,
  [840] = 840,
  [841] = 841,
  [842] = 842,
  [843] = 843,
  [844] = 844,
  [845] = 845,
  [846] = 846,
  [847] = 847,
  [848] = 848,
  [849] = 849,
  [850] = 850,
  [851] = 851,
  [852] = 852,
  [853] = 853,
  [854] = 854,
  [855] = 855,
  [856] = 856,
  [857] = 856,
  [858] = 858,
  [859] = 859,
  [860] = 860,
  [861] = 861,
  [862] = 862,
  [863] = 863,
  [864] = 855,
  [865] = 865,
  [866] = 866,
  [867] = 867,
  [868] = 868,
  [869] = 869,
  [870] = 870,
  [871] = 871,
  [872] = 872,
  [873] = 848,
  [874] = 874,
  [875] = 875,
  [876] = 876,
  [877] = 877,
  [878] = 854,
  [879] = 879,
  [880] = 880,
  [881] = 881,
  [882] = 837,
  [883] = 883,
  [884] = 865,
  [885] = 842,
  [886] = 886,
  [887] = 887,
  [888] = 888,
  [889] = 889,
  [890] = 890,
  [891] = 891,
  [892] = 892,
  [893] = 893,
  [894] = 894,
  [895] = 895,
  [896] = 883,
  [897] = 897,
  [898] = 840,
  [899] = 852,
  [900] = 853,
  [901] = 901,
  [902] = 890,
  [903] = 871,
  [904] = 850,
  [905] = 905,
  [906] = 891,
  [907] = 892,
  [908] = 901,
  [909] = 909,
  [910] = 863,
  [911] = 911,
  [912] = 909,
  [913] = 866,
  [914] = 914,
  [915] = 915,
  [916] = 916,
  [917] = 874,
  [918] = 876,
  [919] = 869,
  [920] = 920,
  [921] = 845,
  [922] = 846,
  [923] = 889,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(445);
      ADVANCE_MAP(
        '!', 531,
        '"', 552,
        '#', 441,
        '%', 1013,
        '&', 18,
        '(', 503,
        ')', 504,
        '*', 538,
        '+', 536,
        ',', 449,
        '-', 534,
        '.', 511,
        '/', 540,
        ':', 470,
        ';', 454,
        '<', 461,
        '=', 547,
        '>', 464,
        '?', 514,
        '@', 101,
        '[', 484,
        '\\', 559,
        ']', 485,
        'a', 264,
        'b', 306,
        'c', 43,
        'd', 126,
        'e', 45,
        'f', 51,
        'g', 241,
        'i', 172,
        'l', 147,
        'm', 258,
        'n', 561,
        'o', 413,
        'p', 60,
        'r', 47,
        's', 1008,
        't', 333,
        'u', 437,
        'w', 193,
        '{', 448,
        '|', 508,
        '}', 450,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(443);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(995);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '!', 531,
        '"', 552,
        '#', 441,
        '%', 1013,
        '&', 18,
        '(', 503,
        ')', 504,
        '*', 538,
        '+', 536,
        ',', 449,
        '-', 533,
        '.', 511,
        '/', 540,
        ':', 469,
        ';', 454,
        '<', 462,
        '=', 547,
        '>', 464,
        '?', 514,
        '@', 195,
        '[', 484,
        'c', 872,
        'e', 568,
        'f', 575,
        'i', 666,
        'l', 698,
        'p', 579,
        'r', 654,
        's', 652,
        't', 806,
        '{', 448,
        '|', 438,
        '}', 450,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(995);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '!', 531,
        '"', 552,
        '#', 441,
        '%', 1013,
        '&', 18,
        '(', 503,
        '*', 538,
        '+', 536,
        '-', 533,
        '.', 511,
        '/', 540,
        ':', 469,
        ';', 454,
        '<', 462,
        '=', 546,
        '>', 464,
        '?', 514,
        '@', 195,
        '[', 484,
        'c', 728,
        'd', 641,
        'e', 568,
        'f', 575,
        'g', 808,
        'i', 664,
        'l', 698,
        'm', 727,
        'p', 578,
        'r', 570,
        's', 1009,
        't', 805,
        '{', 448,
        '|', 438,
        '}', 450,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(995);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '!', 531,
        '"', 552,
        '#', 441,
        '&', 18,
        '(', 503,
        ')', 504,
        '*', 538,
        '+', 536,
        ',', 449,
        '-', 533,
        '.', 511,
        '/', 540,
        ':', 469,
        ';', 454,
        '<', 462,
        '=', 547,
        '>', 464,
        '?', 514,
        '@', 195,
        '[', 484,
        'c', 872,
        'e', 568,
        'f', 575,
        'i', 666,
        'l', 698,
        'p', 579,
        'r', 654,
        's', 652,
        't', 806,
        '{', 448,
        '|', 438,
        '}', 450,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(995);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '!', 531,
        '"', 552,
        '#', 441,
        '&', 18,
        '(', 503,
        '*', 538,
        '+', 536,
        '-', 533,
        '.', 511,
        '/', 540,
        ':', 469,
        ';', 454,
        '<', 462,
        '=', 546,
        '>', 464,
        '?', 514,
        '@', 195,
        '[', 484,
        'c', 872,
        'e', 568,
        'f', 575,
        'i', 666,
        'l', 698,
        'p', 579,
        'r', 654,
        's', 652,
        't', 806,
        '{', 448,
        '|', 438,
        '}', 450,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(995);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        '!', 531,
        '"', 552,
        '#', 441,
        '&', 18,
        '(', 503,
        '*', 537,
        '+', 535,
        '-', 532,
        '.', 511,
        '/', 539,
        ':', 469,
        ';', 454,
        '<', 462,
        '=', 38,
        '>', 464,
        '?', 514,
        '@', 195,
        '[', 484,
        'c', 872,
        'e', 568,
        'f', 575,
        'i', 738,
        'l', 698,
        'o', 881,
        'p', 579,
        'r', 775,
        's', 652,
        't', 806,
        '{', 448,
        '|', 438,
        '}', 450,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(5);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(995);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        '!', 36,
        '%', 1013,
        '&', 18,
        ')', 504,
        '*', 538,
        '+', 536,
        ',', 449,
        '-', 533,
        '.', 510,
        '/', 540,
        ':', 469,
        ';', 454,
        '<', 462,
        '=', 546,
        '>', 464,
        '?', 514,
        '[', 484,
        ']', 485,
        'c', 257,
        'd', 152,
        'g', 354,
        'i', 265,
        'm', 258,
        'p', 191,
        'r', 48,
        's', 1007,
        't', 417,
        '{', 448,
        '|', 438,
        '}', 450,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(10);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        '!', 36,
        '%', 1013,
        '&', 18,
        ')', 504,
        '*', 537,
        '+', 535,
        ',', 449,
        '-', 532,
        '.', 511,
        '/', 539,
        '<', 462,
        '=', 38,
        '>', 464,
        '?', 514,
        '[', 484,
        'c', 257,
        'd', 152,
        'g', 354,
        'i', 265,
        'm', 258,
        'p', 191,
        'r', 48,
        's', 1007,
        't', 417,
        '|', 438,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(11);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(995);
      END_STATE();
    case 8:
      ADVANCE_MAP(
        '!', 36,
        '%', 509,
        '&', 18,
        ')', 504,
        '*', 538,
        '+', 536,
        ',', 449,
        '-', 533,
        '.', 510,
        '/', 540,
        ':', 469,
        ';', 454,
        '<', 462,
        '=', 547,
        '>', 464,
        '?', 514,
        '[', 484,
        ']', 485,
        'a', 745,
        'b', 780,
        'c', 784,
        'd', 880,
        'e', 595,
        'f', 716,
        'i', 730,
        'l', 658,
        'p', 661,
        'r', 655,
        's', 861,
        '{', 448,
        '|', 508,
        '}', 450,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(8);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        '!', 36,
        '&', 18,
        '(', 503,
        ')', 504,
        '*', 538,
        '+', 536,
        ',', 449,
        '-', 534,
        '.', 510,
        '/', 540,
        ':', 469,
        ';', 454,
        '<', 461,
        '=', 547,
        '>', 464,
        '?', 514,
        '[', 484,
        ']', 485,
        'i', 266,
        'n', 220,
        'o', 413,
        'w', 193,
        '{', 448,
        '|', 438,
        '}', 450,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(9);
      END_STATE();
    case 10:
      ADVANCE_MAP(
        '!', 36,
        '&', 18,
        ')', 504,
        '*', 538,
        '+', 536,
        ',', 449,
        '-', 533,
        '.', 510,
        '/', 540,
        ':', 469,
        ';', 454,
        '<', 462,
        '=', 546,
        '>', 464,
        '?', 514,
        '[', 484,
        ']', 485,
        '{', 448,
        '|', 438,
        '}', 450,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(10);
      END_STATE();
    case 11:
      ADVANCE_MAP(
        '!', 36,
        '&', 18,
        ')', 504,
        '*', 537,
        '+', 535,
        ',', 449,
        '-', 532,
        '.', 511,
        '/', 539,
        '<', 462,
        '=', 38,
        '>', 464,
        '?', 514,
        '[', 484,
        '|', 438,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(11);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(995);
      END_STATE();
    case 12:
      ADVANCE_MAP(
        '!', 36,
        '&', 18,
        '*', 537,
        '+', 535,
        ',', 449,
        '-', 532,
        '.', 510,
        '/', 539,
        ';', 454,
        '<', 462,
        '=', 38,
        '>', 464,
        '?', 514,
        '@', 100,
        '[', 484,
        'a', 752,
        'c', 580,
        'f', 781,
        'i', 665,
        'o', 881,
        'p', 802,
        's', 858,
        't', 815,
        '|', 438,
        '}', 450,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(12);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 13:
      ADVANCE_MAP(
        '!', 36,
        '&', 18,
        '*', 537,
        '+', 535,
        '-', 532,
        '.', 510,
        '/', 539,
        ':', 469,
        '<', 462,
        '=', 38,
        '>', 464,
        '?', 514,
        '[', 484,
        ']', 485,
        'i', 266,
        'o', 413,
        '|', 438,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(13);
      END_STATE();
    case 14:
      ADVANCE_MAP(
        '!', 36,
        '&', 18,
        '*', 537,
        '+', 535,
        '-', 532,
        '.', 510,
        '/', 539,
        ';', 454,
        '<', 462,
        '=', 38,
        '>', 464,
        '?', 514,
        '[', 484,
        'c', 581,
        'f', 878,
        'i', 740,
        'o', 881,
        'p', 802,
        '|', 438,
        '}', 450,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(14);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 15:
      ADVANCE_MAP(
        '!', 530,
        '"', 552,
        '#', 441,
        '(', 503,
        ')', 504,
        '+', 535,
        ',', 449,
        '-', 532,
        '.', 440,
        '/', 21,
        ':', 470,
        ';', 454,
        '<', 39,
        '=', 41,
        '@', 195,
        '[', 484,
        ']', 485,
        'c', 872,
        'e', 568,
        'f', 575,
        'l', 698,
        'p', 579,
        'r', 775,
        's', 652,
        't', 806,
        '{', 448,
        '|', 507,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(995);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 16:
      ADVANCE_MAP(
        '!', 530,
        '"', 552,
        '#', 441,
        '(', 503,
        '+', 535,
        '-', 532,
        '.', 440,
        '/', 21,
        ';', 454,
        '@', 195,
        '[', 484,
        'c', 872,
        'e', 567,
        'f', 575,
        'i', 666,
        'l', 698,
        'p', 579,
        'r', 654,
        's', 652,
        't', 806,
        '{', 448,
        '}', 450,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(16);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(995);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 17:
      if (lookahead == '"') ADVANCE(552);
      if (lookahead == '/') ADVANCE(553);
      if (lookahead == '\\') ADVANCE(559);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(556);
      if (lookahead != 0) ADVANCE(558);
      END_STATE();
    case 18:
      if (lookahead == '&') ADVANCE(512);
      END_STATE();
    case 19:
      ADVANCE_MAP(
        '(', 503,
        ')', 504,
        ',', 449,
        '-', 40,
        '/', 21,
        ':', 37,
        ';', 454,
        '<', 39,
        '>', 463,
        ']', 485,
        'a', 362,
        'i', 299,
        '{', 448,
        '}', 450,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(19);
      END_STATE();
    case 20:
      if (lookahead == ')') ADVANCE(504);
      if (lookahead == ',') ADVANCE(449);
      if (lookahead == '/') ADVANCE(21);
      if (lookahead == '<') ADVANCE(460);
      if (lookahead == ']') ADVANCE(485);
      if (lookahead == '}') ADVANCE(450);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(20);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 21:
      if (lookahead == '*') ADVANCE(23);
      if (lookahead == '/') ADVANCE(1017);
      END_STATE();
    case 22:
      if (lookahead == '*') ADVANCE(22);
      if (lookahead == '/') ADVANCE(1016);
      if (lookahead != 0) ADVANCE(23);
      END_STATE();
    case 23:
      if (lookahead == '*') ADVANCE(22);
      if (lookahead != 0) ADVANCE(23);
      END_STATE();
    case 24:
      if (lookahead == ',') ADVANCE(449);
      if (lookahead == '/') ADVANCE(21);
      if (lookahead == 'a') ADVANCE(752);
      if (lookahead == '}') ADVANCE(450);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(24);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 25:
      if (lookahead == '-') ADVANCE(174);
      END_STATE();
    case 26:
      if (lookahead == '-') ADVANCE(88);
      END_STATE();
    case 27:
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '_') ADVANCE(185);
      END_STATE();
    case 28:
      if (lookahead == '-') ADVANCE(373);
      END_STATE();
    case 29:
      if (lookahead == '-') ADVANCE(105);
      END_STATE();
    case 30:
      if (lookahead == '-') ADVANCE(421);
      END_STATE();
    case 31:
      if (lookahead == '-') ADVANCE(370);
      END_STATE();
    case 32:
      if (lookahead == '-') ADVANCE(247);
      END_STATE();
    case 33:
      if (lookahead == '-') ADVANCE(186);
      if (lookahead == '_') ADVANCE(187);
      END_STATE();
    case 34:
      if (lookahead == '/') ADVANCE(21);
      if (lookahead == 'f') ADVANCE(878);
      if (lookahead == 'p') ADVANCE(802);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(34);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 35:
      if (lookahead == '/') ADVANCE(21);
      if (lookahead == 'p') ADVANCE(813);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(35);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 36:
      if (lookahead == '=') ADVANCE(545);
      END_STATE();
    case 37:
      if (lookahead == '=') ADVANCE(456);
      END_STATE();
    case 38:
      if (lookahead == '=') ADVANCE(544);
      END_STATE();
    case 39:
      if (lookahead == '=') ADVANCE(42);
      END_STATE();
    case 40:
      if (lookahead == '>') ADVANCE(517);
      END_STATE();
    case 41:
      if (lookahead == '>') ADVANCE(506);
      END_STATE();
    case 42:
      if (lookahead == '>') ADVANCE(471);
      END_STATE();
    case 43:
      if (lookahead == 'a') ADVANCE(243);
      if (lookahead == 'h') ADVANCE(57);
      if (lookahead == 'i') ADVANCE(335);
      if (lookahead == 'm') ADVANCE(1005);
      if (lookahead == 'o') ADVANCE(242);
      if (lookahead == 'u') ADVANCE(84);
      END_STATE();
    case 44:
      if (lookahead == 'a') ADVANCE(243);
      if (lookahead == 'h') ADVANCE(57);
      if (lookahead == 'i') ADVANCE(335);
      if (lookahead == 'o') ADVANCE(242);
      if (lookahead == 'u') ADVANCE(84);
      END_STATE();
    case 45:
      if (lookahead == 'a') ADVANCE(365);
      if (lookahead == 'l') ADVANCE(367);
      if (lookahead == 'n') ADVANCE(415);
      if (lookahead == 'x') ADVANCE(331);
      END_STATE();
    case 46:
      if (lookahead == 'a') ADVANCE(115);
      END_STATE();
    case 47:
      if (lookahead == 'a') ADVANCE(115);
      if (lookahead == 'e') ADVANCE(250);
      if (lookahead == 'o') ADVANCE(311);
      END_STATE();
    case 48:
      if (lookahead == 'a') ADVANCE(115);
      if (lookahead == 'e') ADVANCE(259);
      END_STATE();
    case 49:
      if (lookahead == 'a') ADVANCE(180);
      if (lookahead == 'p') ADVANCE(319);
      END_STATE();
    case 50:
      if (lookahead == 'a') ADVANCE(117);
      if (lookahead == 'i') ADVANCE(286);
      END_STATE();
    case 51:
      if (lookahead == 'a') ADVANCE(249);
      if (lookahead == 'l') ADVANCE(313);
      if (lookahead == 'o') ADVANCE(336);
      if (lookahead == 'r') ADVANCE(312);
      if (lookahead == 'u') ADVANCE(275);
      END_STATE();
    case 52:
      if (lookahead == 'a') ADVANCE(120);
      END_STATE();
    case 53:
      if (lookahead == 'a') ADVANCE(432);
      END_STATE();
    case 54:
      if (lookahead == 'a') ADVANCE(118);
      if (lookahead == 'i') ADVANCE(289);
      END_STATE();
    case 55:
      if (lookahead == 'a') ADVANCE(400);
      END_STATE();
    case 56:
      if (lookahead == 'a') ADVANCE(119);
      if (lookahead == 'i') ADVANCE(298);
      END_STATE();
    case 57:
      if (lookahead == 'a') ADVANCE(302);
      END_STATE();
    case 58:
      if (lookahead == 'a') ADVANCE(378);
      END_STATE();
    case 59:
      if (lookahead == 'a') ADVANCE(278);
      if (lookahead == 'u') ADVANCE(131);
      END_STATE();
    case 60:
      if (lookahead == 'a') ADVANCE(355);
      if (lookahead == 'e') ADVANCE(341);
      if (lookahead == 'h') ADVANCE(431);
      if (lookahead == 'r') ADVANCE(196);
      if (lookahead == 'u') ADVANCE(86);
      if (lookahead == 't' ||
          lookahead == 'x') ADVANCE(1005);
      END_STATE();
    case 61:
      if (lookahead == 'a') ADVANCE(355);
      if (lookahead == 'e') ADVANCE(341);
      if (lookahead == 'h') ADVANCE(434);
      if (lookahead == 'r') ADVANCE(196);
      if (lookahead == 'u') ADVANCE(86);
      END_STATE();
    case 62:
      if (lookahead == 'a') ADVANCE(404);
      END_STATE();
    case 63:
      if (lookahead == 'a') ADVANCE(371);
      END_STATE();
    case 64:
      if (lookahead == 'a') ADVANCE(93);
      END_STATE();
    case 65:
      if (lookahead == 'a') ADVANCE(102);
      if (lookahead == 'o') ADVANCE(422);
      END_STATE();
    case 66:
      if (lookahead == 'a') ADVANCE(235);
      END_STATE();
    case 67:
      if (lookahead == 'a') ADVANCE(103);
      if (lookahead == 'o') ADVANCE(424);
      END_STATE();
    case 68:
      if (lookahead == 'a') ADVANCE(256);
      END_STATE();
    case 69:
      if (lookahead == 'a') ADVANCE(238);
      END_STATE();
    case 70:
      if (lookahead == 'a') ADVANCE(338);
      END_STATE();
    case 71:
      if (lookahead == 'a') ADVANCE(104);
      if (lookahead == 'o') ADVANCE(426);
      END_STATE();
    case 72:
      if (lookahead == 'a') ADVANCE(339);
      END_STATE();
    case 73:
      if (lookahead == 'a') ADVANCE(181);
      END_STATE();
    case 74:
      if (lookahead == 'a') ADVANCE(121);
      END_STATE();
    case 75:
      if (lookahead == 'a') ADVANCE(401);
      END_STATE();
    case 76:
      if (lookahead == 'a') ADVANCE(405);
      END_STATE();
    case 77:
      if (lookahead == 'a') ADVANCE(374);
      END_STATE();
    case 78:
      if (lookahead == 'a') ADVANCE(123);
      END_STATE();
    case 79:
      if (lookahead == 'a') ADVANCE(375);
      END_STATE();
    case 80:
      if (lookahead == 'a') ADVANCE(124);
      END_STATE();
    case 81:
      if (lookahead == 'a') ADVANCE(411);
      END_STATE();
    case 82:
      if (lookahead == 'a') ADVANCE(125);
      END_STATE();
    case 83:
      if (lookahead == 'b') ADVANCE(65);
      if (lookahead == 'c') ADVANCE(207);
      if (lookahead == 'e') ADVANCE(245);
      if (lookahead == 'o') ADVANCE(420);
      if (lookahead == 'q') ADVANCE(414);
      if (lookahead == 's') ADVANCE(211);
      END_STATE();
    case 84:
      if (lookahead == 'b') ADVANCE(199);
      END_STATE();
    case 85:
      if (lookahead == 'b') ADVANCE(66);
      END_STATE();
    case 86:
      if (lookahead == 'b') ADVANCE(252);
      if (lookahead == 'r') ADVANCE(130);
      END_STATE();
    case 87:
      if (lookahead == 'b') ADVANCE(64);
      END_STATE();
    case 88:
      if (lookahead == 'b') ADVANCE(138);
      END_STATE();
    case 89:
      if (lookahead == 'b') ADVANCE(67);
      if (lookahead == 'c') ADVANCE(208);
      if (lookahead == 'e') ADVANCE(254);
      if (lookahead == 'q') ADVANCE(423);
      if (lookahead == 's') ADVANCE(215);
      END_STATE();
    case 90:
      if (lookahead == 'b') ADVANCE(71);
      if (lookahead == 'c') ADVANCE(209);
      if (lookahead == 'e') ADVANCE(255);
      if (lookahead == 'q') ADVANCE(425);
      if (lookahead == 's') ADVANCE(217);
      END_STATE();
    case 91:
      if (lookahead == 'c') ADVANCE(26);
      END_STATE();
    case 92:
      if (lookahead == 'c') ADVANCE(520);
      END_STATE();
    case 93:
      if (lookahead == 'c') ADVANCE(229);
      END_STATE();
    case 94:
      if (lookahead == 'c') ADVANCE(963);
      END_STATE();
    case 95:
      if (lookahead == 'c') ADVANCE(965);
      END_STATE();
    case 96:
      if (lookahead == 'c') ADVANCE(969);
      END_STATE();
    case 97:
      if (lookahead == 'c') ADVANCE(967);
      END_STATE();
    case 98:
      if (lookahead == 'c') ADVANCE(971);
      END_STATE();
    case 99:
      if (lookahead == 'c') ADVANCE(973);
      END_STATE();
    case 100:
      if (lookahead == 'c') ADVANCE(192);
      END_STATE();
    case 101:
      if (lookahead == 'c') ADVANCE(192);
      if (lookahead == 'i') ADVANCE(262);
      if (lookahead == 'l') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(52);
      if (lookahead == 't') ADVANCE(334);
      END_STATE();
    case 102:
      if (lookahead == 'c') ADVANCE(230);
      END_STATE();
    case 103:
      if (lookahead == 'c') ADVANCE(231);
      END_STATE();
    case 104:
      if (lookahead == 'c') ADVANCE(232);
      END_STATE();
    case 105:
      if (lookahead == 'c') ADVANCE(315);
      END_STATE();
    case 106:
      if (lookahead == 'c') ADVANCE(141);
      END_STATE();
    case 107:
      if (lookahead == 'c') ADVANCE(142);
      END_STATE();
    case 108:
      if (lookahead == 'c') ADVANCE(144);
      END_STATE();
    case 109:
      if (lookahead == 'c') ADVANCE(146);
      END_STATE();
    case 110:
      if (lookahead == 'c') ADVANCE(246);
      END_STATE();
    case 111:
      if (lookahead == 'c') ADVANCE(162);
      END_STATE();
    case 112:
      if (lookahead == 'c') ADVANCE(69);
      END_STATE();
    case 113:
      if (lookahead == 'c') ADVANCE(409);
      END_STATE();
    case 114:
      if (lookahead == 'c') ADVANCE(410);
      END_STATE();
    case 115:
      if (lookahead == 'd') ADVANCE(1011);
      END_STATE();
    case 116:
      if (lookahead == 'd') ADVANCE(526);
      END_STATE();
    case 117:
      if (lookahead == 'd') ADVANCE(919);
      if (lookahead == 'r') ADVANCE(386);
      END_STATE();
    case 118:
      if (lookahead == 'd') ADVANCE(921);
      if (lookahead == 'r') ADVANCE(388);
      END_STATE();
    case 119:
      if (lookahead == 'd') ADVANCE(923);
      if (lookahead == 'r') ADVANCE(395);
      END_STATE();
    case 120:
      if (lookahead == 'd') ADVANCE(213);
      END_STATE();
    case 121:
      if (lookahead == 'd') ADVANCE(222);
      END_STATE();
    case 122:
      if (lookahead == 'd') ADVANCE(356);
      END_STATE();
    case 123:
      if (lookahead == 'd') ADVANCE(224);
      END_STATE();
    case 124:
      if (lookahead == 'd') ADVANCE(225);
      END_STATE();
    case 125:
      if (lookahead == 'd') ADVANCE(226);
      END_STATE();
    case 126:
      if (lookahead == 'e') ADVANCE(176);
      if (lookahead == 'i') ADVANCE(342);
      if (lookahead == 'u') ADVANCE(343);
      END_STATE();
    case 127:
      if (lookahead == 'e') ADVANCE(251);
      if (lookahead == 'o') ADVANCE(311);
      END_STATE();
    case 128:
      if (lookahead == 'e') ADVANCE(926);
      if (lookahead == 'i') ADVANCE(277);
      END_STATE();
    case 129:
      if (lookahead == 'e') ADVANCE(499);
      END_STATE();
    case 130:
      if (lookahead == 'e') ADVANCE(518);
      END_STATE();
    case 131:
      if (lookahead == 'e') ADVANCE(998);
      END_STATE();
    case 132:
      if (lookahead == 'e') ADVANCE(909);
      END_STATE();
    case 133:
      if (lookahead == 'e') ADVANCE(1000);
      END_STATE();
    case 134:
      if (lookahead == 'e') ADVANCE(913);
      END_STATE();
    case 135:
      if (lookahead == 'e') ADVANCE(988);
      END_STATE();
    case 136:
      if (lookahead == 'e') ADVANCE(488);
      END_STATE();
    case 137:
      if (lookahead == 'e') ADVANCE(522);
      END_STATE();
    case 138:
      if (lookahead == 'e') ADVANCE(435);
      END_STATE();
    case 139:
      if (lookahead == 'e') ADVANCE(951);
      END_STATE();
    case 140:
      if (lookahead == 'e') ADVANCE(953);
      END_STATE();
    case 141:
      if (lookahead == 'e') ADVANCE(975);
      END_STATE();
    case 142:
      if (lookahead == 'e') ADVANCE(977);
      END_STATE();
    case 143:
      if (lookahead == 'e') ADVANCE(955);
      END_STATE();
    case 144:
      if (lookahead == 'e') ADVANCE(979);
      END_STATE();
    case 145:
      if (lookahead == 'e') ADVANCE(915);
      END_STATE();
    case 146:
      if (lookahead == 'e') ADVANCE(529);
      END_STATE();
    case 147:
      if (lookahead == 'e') ADVANCE(276);
      if (lookahead == 'i') ADVANCE(281);
      END_STATE();
    case 148:
      if (lookahead == 'e') ADVANCE(30);
      END_STATE();
    case 149:
      if (lookahead == 'e') ADVANCE(233);
      END_STATE();
    case 150:
      if (lookahead == 'e') ADVANCE(116);
      END_STATE();
    case 151:
      if (lookahead == 'e') ADVANCE(25);
      END_STATE();
    case 152:
      if (lookahead == 'e') ADVANCE(175);
      END_STATE();
    case 153:
      if (lookahead == 'e') ADVANCE(268);
      END_STATE();
    case 154:
      if (lookahead == 'e') ADVANCE(28);
      END_STATE();
    case 155:
      if (lookahead == 'e') ADVANCE(282);
      END_STATE();
    case 156:
      if (lookahead == 'e') ADVANCE(70);
      END_STATE();
    case 157:
      if (lookahead == 'e') ADVANCE(239);
      if (lookahead == 'i') ADVANCE(342);
      if (lookahead == 'u') ADVANCE(343);
      END_STATE();
    case 158:
      if (lookahead == 'e') ADVANCE(273);
      END_STATE();
    case 159:
      if (lookahead == 'e') ADVANCE(349);
      END_STATE();
    case 160:
      if (lookahead == 'e') ADVANCE(340);
      END_STATE();
    case 161:
      if (lookahead == 'e') ADVANCE(350);
      END_STATE();
    case 162:
      if (lookahead == 'e') ADVANCE(283);
      END_STATE();
    case 163:
      if (lookahead == 'e') ADVANCE(72);
      END_STATE();
    case 164:
      if (lookahead == 'e') ADVANCE(285);
      END_STATE();
    case 165:
      if (lookahead == 'e') ADVANCE(292);
      END_STATE();
    case 166:
      if (lookahead == 'e') ADVANCE(294);
      END_STATE();
    case 167:
      if (lookahead == 'e') ADVANCE(295);
      END_STATE();
    case 168:
      if (lookahead == 'e') ADVANCE(296);
      END_STATE();
    case 169:
      if (lookahead == 'e') ADVANCE(300);
      END_STATE();
    case 170:
      if (lookahead == 'e') ADVANCE(114);
      END_STATE();
    case 171:
      if (lookahead == 'e') ADVANCE(358);
      END_STATE();
    case 172:
      if (lookahead == 'f') ADVANCE(497);
      if (lookahead == 'm') ADVANCE(49);
      if (lookahead == 'n') ADVANCE(477);
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 173:
      if (lookahead == 'f') ADVANCE(993);
      END_STATE();
    case 174:
      if (lookahead == 'f') ADVANCE(325);
      END_STATE();
    case 175:
      if (lookahead == 'g') ADVANCE(1011);
      END_STATE();
    case 176:
      if (lookahead == 'g') ADVANCE(1011);
      if (lookahead == 'l') ADVANCE(53);
      END_STATE();
    case 177:
      if (lookahead == 'g') ADVANCE(495);
      END_STATE();
    case 178:
      if (lookahead == 'g') ADVANCE(244);
      if (lookahead == 'i') ADVANCE(263);
      END_STATE();
    case 179:
      if (lookahead == 'g') ADVANCE(398);
      END_STATE();
    case 180:
      if (lookahead == 'g') ADVANCE(134);
      END_STATE();
    case 181:
      if (lookahead == 'g') ADVANCE(148);
      END_STATE();
    case 182:
      if (lookahead == 'g') ADVANCE(150);
      END_STATE();
    case 183:
      if (lookahead == 'g') ADVANCE(357);
      END_STATE();
    case 184:
      if (lookahead == 'g') ADVANCE(399);
      END_STATE();
    case 185:
      if (lookahead == 'g') ADVANCE(359);
      END_STATE();
    case 186:
      if (lookahead == 'g') ADVANCE(360);
      END_STATE();
    case 187:
      if (lookahead == 'g') ADVANCE(361);
      END_STATE();
    case 188:
      if (lookahead == 'h') ADVANCE(903);
      END_STATE();
    case 189:
      if (lookahead == 'h') ADVANCE(907);
      END_STATE();
    case 190:
      if (lookahead == 'h') ADVANCE(905);
      END_STATE();
    case 191:
      if (lookahead == 'h') ADVANCE(430);
      if (lookahead == 't' ||
          lookahead == 'x') ADVANCE(1005);
      END_STATE();
    case 192:
      if (lookahead == 'h') ADVANCE(202);
      END_STATE();
    case 193:
      if (lookahead == 'h') ADVANCE(153);
      END_STATE();
    case 194:
      if (lookahead == 'h') ADVANCE(161);
      END_STATE();
    case 195:
      if (lookahead == 'i') ADVANCE(262);
      if (lookahead == 'l') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(52);
      if (lookahead == 't') ADVANCE(334);
      END_STATE();
    case 196:
      if (lookahead == 'i') ADVANCE(429);
      if (lookahead == 'o') ADVANCE(330);
      END_STATE();
    case 197:
      if (lookahead == 'i') ADVANCE(428);
      END_STATE();
    case 198:
      if (lookahead == 'i') ADVANCE(436);
      END_STATE();
    case 199:
      if (lookahead == 'i') ADVANCE(91);
      END_STATE();
    case 200:
      if (lookahead == 'i') ADVANCE(112);
      END_STATE();
    case 201:
      if (lookahead == 'i') ADVANCE(92);
      END_STATE();
    case 202:
      if (lookahead == 'i') ADVANCE(237);
      END_STATE();
    case 203:
      if (lookahead == 'i') ADVANCE(270);
      if (lookahead == 'o') ADVANCE(418);
      END_STATE();
    case 204:
      if (lookahead == 'i') ADVANCE(96);
      END_STATE();
    case 205:
      if (lookahead == 'i') ADVANCE(98);
      END_STATE();
    case 206:
      if (lookahead == 'i') ADVANCE(99);
      END_STATE();
    case 207:
      if (lookahead == 'i') ADVANCE(348);
      END_STATE();
    case 208:
      if (lookahead == 'i') ADVANCE(351);
      END_STATE();
    case 209:
      if (lookahead == 'i') ADVANCE(353);
      END_STATE();
    case 210:
      if (lookahead == 'i') ADVANCE(403);
      END_STATE();
    case 211:
      if (lookahead == 'i') ADVANCE(288);
      END_STATE();
    case 212:
      if (lookahead == 'i') ADVANCE(320);
      END_STATE();
    case 213:
      if (lookahead == 'i') ADVANCE(68);
      END_STATE();
    case 214:
      if (lookahead == 'i') ADVANCE(160);
      END_STATE();
    case 215:
      if (lookahead == 'i') ADVANCE(290);
      END_STATE();
    case 216:
      if (lookahead == 'i') ADVANCE(321);
      END_STATE();
    case 217:
      if (lookahead == 'i') ADVANCE(293);
      END_STATE();
    case 218:
      if (lookahead == 'i') ADVANCE(322);
      END_STATE();
    case 219:
      if (lookahead == 'i') ADVANCE(109);
      END_STATE();
    case 220:
      if (lookahead == 'i') ADVANCE(297);
      END_STATE();
    case 221:
      if (lookahead == 'i') ADVANCE(323);
      END_STATE();
    case 222:
      if (lookahead == 'i') ADVANCE(165);
      END_STATE();
    case 223:
      if (lookahead == 'i') ADVANCE(324);
      END_STATE();
    case 224:
      if (lookahead == 'i') ADVANCE(166);
      END_STATE();
    case 225:
      if (lookahead == 'i') ADVANCE(167);
      END_STATE();
    case 226:
      if (lookahead == 'i') ADVANCE(168);
      END_STATE();
    case 227:
      if (lookahead == 'i') ADVANCE(305);
      END_STATE();
    case 228:
      if (lookahead == 'i') ADVANCE(412);
      END_STATE();
    case 229:
      if (lookahead == 'k') ADVANCE(515);
      END_STATE();
    case 230:
      if (lookahead == 'k') ADVANCE(957);
      END_STATE();
    case 231:
      if (lookahead == 'k') ADVANCE(959);
      END_STATE();
    case 232:
      if (lookahead == 'k') ADVANCE(961);
      END_STATE();
    case 233:
      if (lookahead == 'l') ADVANCE(173);
      END_STATE();
    case 234:
      if (lookahead == 'l') ADVANCE(898);
      END_STATE();
    case 235:
      if (lookahead == 'l') ADVANCE(472);
      END_STATE();
    case 236:
      if (lookahead == 'l') ADVANCE(528);
      END_STATE();
    case 237:
      if (lookahead == 'l') ADVANCE(122);
      END_STATE();
    case 238:
      if (lookahead == 'l') ADVANCE(32);
      END_STATE();
    case 239:
      if (lookahead == 'l') ADVANCE(53);
      END_STATE();
    case 240:
      if (lookahead == 'l') ADVANCE(310);
      END_STATE();
    case 241:
      if (lookahead == 'l') ADVANCE(310);
      if (lookahead == 'r') ADVANCE(46);
      END_STATE();
    case 242:
      if (lookahead == 'l') ADVANCE(317);
      if (lookahead == 'm') ADVANCE(326);
      END_STATE();
    case 243:
      if (lookahead == 'l') ADVANCE(248);
      END_STATE();
    case 244:
      if (lookahead == 'l') ADVANCE(132);
      END_STATE();
    case 245:
      if (lookahead == 'l') ADVANCE(63);
      if (lookahead == 'x') ADVANCE(327);
      END_STATE();
    case 246:
      if (lookahead == 'l') ADVANCE(135);
      END_STATE();
    case 247:
      if (lookahead == 'l') ADVANCE(169);
      END_STATE();
    case 248:
      if (lookahead == 'l') ADVANCE(87);
      END_STATE();
    case 249:
      if (lookahead == 'l') ADVANCE(369);
      END_STATE();
    case 250:
      if (lookahead == 'l') ADVANCE(75);
      if (lookahead == 'm') ADVANCE(1014);
      if (lookahead == 't') ADVANCE(419);
      END_STATE();
    case 251:
      if (lookahead == 'l') ADVANCE(75);
      if (lookahead == 't') ADVANCE(419);
      END_STATE();
    case 252:
      if (lookahead == 'l') ADVANCE(201);
      END_STATE();
    case 253:
      if (lookahead == 'l') ADVANCE(219);
      END_STATE();
    case 254:
      if (lookahead == 'l') ADVANCE(77);
      if (lookahead == 'x') ADVANCE(328);
      END_STATE();
    case 255:
      if (lookahead == 'l') ADVANCE(79);
      if (lookahead == 'x') ADVANCE(329);
      END_STATE();
    case 256:
      if (lookahead == 'l') ADVANCE(33);
      END_STATE();
    case 257:
      if (lookahead == 'm') ADVANCE(1005);
      END_STATE();
    case 258:
      if (lookahead == 'm') ADVANCE(1005);
      if (lookahead == 's') ADVANCE(1007);
      END_STATE();
    case 259:
      if (lookahead == 'm') ADVANCE(1014);
      END_STATE();
    case 260:
      if (lookahead == 'm') ADVANCE(475);
      END_STATE();
    case 261:
      if (lookahead == 'm') ADVANCE(453);
      END_STATE();
    case 262:
      if (lookahead == 'm') ADVANCE(73);
      END_STATE();
    case 263:
      if (lookahead == 'm') ADVANCE(62);
      END_STATE();
    case 264:
      if (lookahead == 'n') ADVANCE(178);
      if (lookahead == 's') ADVANCE(455);
      END_STATE();
    case 265:
      if (lookahead == 'n') ADVANCE(1005);
      END_STATE();
    case 266:
      if (lookahead == 'n') ADVANCE(477);
      END_STATE();
    case 267:
      if (lookahead == 'n') ADVANCE(1011);
      END_STATE();
    case 268:
      if (lookahead == 'n') ADVANCE(487);
      END_STATE();
    case 269:
      if (lookahead == 'n') ADVANCE(465);
      END_STATE();
    case 270:
      if (lookahead == 'n') ADVANCE(927);
      END_STATE();
    case 271:
      if (lookahead == 'n') ADVANCE(491);
      END_STATE();
    case 272:
      if (lookahead == 'n') ADVANCE(524);
      END_STATE();
    case 273:
      if (lookahead == 'n') ADVANCE(983);
      END_STATE();
    case 274:
      if (lookahead == 'n') ADVANCE(494);
      END_STATE();
    case 275:
      if (lookahead == 'n') ADVANCE(113);
      END_STATE();
    case 276:
      if (lookahead == 'n') ADVANCE(179);
      END_STATE();
    case 277:
      if (lookahead == 'n') ADVANCE(177);
      END_STATE();
    case 278:
      if (lookahead == 'n') ADVANCE(368);
      END_STATE();
    case 279:
      if (lookahead == 'n') ADVANCE(29);
      END_STATE();
    case 280:
      if (lookahead == 'n') ADVANCE(363);
      END_STATE();
    case 281:
      if (lookahead == 'n') ADVANCE(156);
      END_STATE();
    case 282:
      if (lookahead == 'n') ADVANCE(381);
      END_STATE();
    case 283:
      if (lookahead == 'n') ADVANCE(382);
      END_STATE();
    case 284:
      if (lookahead == 'n') ADVANCE(106);
      END_STATE();
    case 285:
      if (lookahead == 'n') ADVANCE(384);
      END_STATE();
    case 286:
      if (lookahead == 'n') ADVANCE(387);
      END_STATE();
    case 287:
      if (lookahead == 'n') ADVANCE(402);
      END_STATE();
    case 288:
      if (lookahead == 'n') ADVANCE(139);
      END_STATE();
    case 289:
      if (lookahead == 'n') ADVANCE(389);
      END_STATE();
    case 290:
      if (lookahead == 'n') ADVANCE(140);
      END_STATE();
    case 291:
      if (lookahead == 'n') ADVANCE(390);
      END_STATE();
    case 292:
      if (lookahead == 'n') ADVANCE(391);
      END_STATE();
    case 293:
      if (lookahead == 'n') ADVANCE(143);
      END_STATE();
    case 294:
      if (lookahead == 'n') ADVANCE(392);
      END_STATE();
    case 295:
      if (lookahead == 'n') ADVANCE(393);
      END_STATE();
    case 296:
      if (lookahead == 'n') ADVANCE(394);
      END_STATE();
    case 297:
      if (lookahead == 'n') ADVANCE(154);
      END_STATE();
    case 298:
      if (lookahead == 'n') ADVANCE(396);
      END_STATE();
    case 299:
      if (lookahead == 'n') ADVANCE(194);
      END_STATE();
    case 300:
      if (lookahead == 'n') ADVANCE(184);
      END_STATE();
    case 301:
      if (lookahead == 'n') ADVANCE(107);
      END_STATE();
    case 302:
      if (lookahead == 'n') ADVANCE(182);
      END_STATE();
    case 303:
      if (lookahead == 'n') ADVANCE(108);
      END_STATE();
    case 304:
      if (lookahead == 'n') ADVANCE(164);
      END_STATE();
    case 305:
      if (lookahead == 'n') ADVANCE(163);
      END_STATE();
    case 306:
      if (lookahead == 'o') ADVANCE(314);
      if (lookahead == 'r') ADVANCE(416);
      END_STATE();
    case 307:
      if (lookahead == 'o') ADVANCE(945);
      END_STATE();
    case 308:
      if (lookahead == 'o') ADVANCE(947);
      END_STATE();
    case 309:
      if (lookahead == 'o') ADVANCE(949);
      END_STATE();
    case 310:
      if (lookahead == 'o') ADVANCE(85);
      END_STATE();
    case 311:
      if (lookahead == 'o') ADVANCE(377);
      END_STATE();
    case 312:
      if (lookahead == 'o') ADVANCE(261);
      END_STATE();
    case 313:
      if (lookahead == 'o') ADVANCE(58);
      END_STATE();
    case 314:
      if (lookahead == 'o') ADVANCE(234);
      END_STATE();
    case 315:
      if (lookahead == 'o') ADVANCE(427);
      END_STATE();
    case 316:
      if (lookahead == 'o') ADVANCE(304);
      END_STATE();
    case 317:
      if (lookahead == 'o') ADVANCE(337);
      END_STATE();
    case 318:
      if (lookahead == 'o') ADVANCE(345);
      END_STATE();
    case 319:
      if (lookahead == 'o') ADVANCE(346);
      END_STATE();
    case 320:
      if (lookahead == 'o') ADVANCE(271);
      END_STATE();
    case 321:
      if (lookahead == 'o') ADVANCE(272);
      END_STATE();
    case 322:
      if (lookahead == 'o') ADVANCE(274);
      END_STATE();
    case 323:
      if (lookahead == 'o') ADVANCE(279);
      END_STATE();
    case 324:
      if (lookahead == 'o') ADVANCE(280);
      END_STATE();
    case 325:
      if (lookahead == 'o') ADVANCE(287);
      END_STATE();
    case 326:
      if (lookahead == 'p') ADVANCE(316);
      END_STATE();
    case 327:
      if (lookahead == 'p') ADVANCE(307);
      END_STATE();
    case 328:
      if (lookahead == 'p') ADVANCE(308);
      END_STATE();
    case 329:
      if (lookahead == 'p') ADVANCE(309);
      END_STATE();
    case 330:
      if (lookahead == 'p') ADVANCE(159);
      END_STATE();
    case 331:
      if (lookahead == 'p') ADVANCE(318);
      END_STATE();
    case 332:
      if (lookahead == 'r') ADVANCE(59);
      END_STATE();
    case 333:
      if (lookahead == 'r') ADVANCE(59);
      if (lookahead == 'u') ADVANCE(344);
      END_STATE();
    case 334:
      if (lookahead == 'r') ADVANCE(505);
      END_STATE();
    case 335:
      if (lookahead == 'r') ADVANCE(110);
      END_STATE();
    case 336:
      if (lookahead == 'r') ADVANCE(501);
      END_STATE();
    case 337:
      if (lookahead == 'r') ADVANCE(901);
      END_STATE();
    case 338:
      if (lookahead == 'r') ADVANCE(917);
      END_STATE();
    case 339:
      if (lookahead == 'r') ADVANCE(27);
      END_STATE();
    case 340:
      if (lookahead == 'r') ADVANCE(981);
      END_STATE();
    case 341:
      if (lookahead == 'r') ADVANCE(111);
      END_STATE();
    case 342:
      if (lookahead == 'r') ADVANCE(170);
      END_STATE();
    case 343:
      if (lookahead == 'r') ADVANCE(55);
      END_STATE();
    case 344:
      if (lookahead == 'r') ADVANCE(267);
      END_STATE();
    case 345:
      if (lookahead == 'r') ADVANCE(379);
      END_STATE();
    case 346:
      if (lookahead == 'r') ADVANCE(380);
      END_STATE();
    case 347:
      if (lookahead == 'r') ADVANCE(269);
      END_STATE();
    case 348:
      if (lookahead == 'r') ADVANCE(94);
      END_STATE();
    case 349:
      if (lookahead == 'r') ADVANCE(397);
      END_STATE();
    case 350:
      if (lookahead == 'r') ADVANCE(210);
      END_STATE();
    case 351:
      if (lookahead == 'r') ADVANCE(95);
      END_STATE();
    case 352:
      if (lookahead == 'r') ADVANCE(236);
      END_STATE();
    case 353:
      if (lookahead == 'r') ADVANCE(97);
      END_STATE();
    case 354:
      if (lookahead == 'r') ADVANCE(46);
      END_STATE();
    case 355:
      if (lookahead == 'r') ADVANCE(155);
      END_STATE();
    case 356:
      if (lookahead == 'r') ADVANCE(158);
      END_STATE();
    case 357:
      if (lookahead == 'r') ADVANCE(74);
      END_STATE();
    case 358:
      if (lookahead == 'r') ADVANCE(81);
      END_STATE();
    case 359:
      if (lookahead == 'r') ADVANCE(78);
      END_STATE();
    case 360:
      if (lookahead == 'r') ADVANCE(80);
      END_STATE();
    case 361:
      if (lookahead == 'r') ADVANCE(82);
      END_STATE();
    case 362:
      if (lookahead == 's') ADVANCE(455);
      END_STATE();
    case 363:
      if (lookahead == 's') ADVANCE(482);
      END_STATE();
    case 364:
      if (lookahead == 's') ADVANCE(459);
      END_STATE();
    case 365:
      if (lookahead == 's') ADVANCE(128);
      END_STATE();
    case 366:
      if (lookahead == 's') ADVANCE(188);
      END_STATE();
    case 367:
      if (lookahead == 's') ADVANCE(129);
      END_STATE();
    case 368:
      if (lookahead == 's') ADVANCE(228);
      END_STATE();
    case 369:
      if (lookahead == 's') ADVANCE(133);
      END_STATE();
    case 370:
      if (lookahead == 's') ADVANCE(198);
      END_STATE();
    case 371:
      if (lookahead == 's') ADVANCE(406);
      END_STATE();
    case 372:
      if (lookahead == 's') ADVANCE(200);
      END_STATE();
    case 373:
      if (lookahead == 's') ADVANCE(253);
      END_STATE();
    case 374:
      if (lookahead == 's') ADVANCE(407);
      END_STATE();
    case 375:
      if (lookahead == 's') ADVANCE(408);
      END_STATE();
    case 376:
      if (lookahead == 't') ADVANCE(480);
      END_STATE();
    case 377:
      if (lookahead == 't') ADVANCE(991);
      END_STATE();
    case 378:
      if (lookahead == 't') ADVANCE(896);
      END_STATE();
    case 379:
      if (lookahead == 't') ADVANCE(446);
      END_STATE();
    case 380:
      if (lookahead == 't') ADVANCE(451);
      END_STATE();
    case 381:
      if (lookahead == 't') ADVANCE(989);
      END_STATE();
    case 382:
      if (lookahead == 't') ADVANCE(911);
      END_STATE();
    case 383:
      if (lookahead == 't') ADVANCE(929);
      END_STATE();
    case 384:
      if (lookahead == 't') ADVANCE(457);
      END_STATE();
    case 385:
      if (lookahead == 't') ADVANCE(931);
      END_STATE();
    case 386:
      if (lookahead == 't') ADVANCE(933);
      END_STATE();
    case 387:
      if (lookahead == 't') ADVANCE(939);
      END_STATE();
    case 388:
      if (lookahead == 't') ADVANCE(935);
      END_STATE();
    case 389:
      if (lookahead == 't') ADVANCE(941);
      END_STATE();
    case 390:
      if (lookahead == 't') ADVANCE(493);
      END_STATE();
    case 391:
      if (lookahead == 't') ADVANCE(984);
      END_STATE();
    case 392:
      if (lookahead == 't') ADVANCE(985);
      END_STATE();
    case 393:
      if (lookahead == 't') ADVANCE(986);
      END_STATE();
    case 394:
      if (lookahead == 't') ADVANCE(987);
      END_STATE();
    case 395:
      if (lookahead == 't') ADVANCE(937);
      END_STATE();
    case 396:
      if (lookahead == 't') ADVANCE(943);
      END_STATE();
    case 397:
      if (lookahead == 't') ADVANCE(433);
      END_STATE();
    case 398:
      if (lookahead == 't') ADVANCE(189);
      END_STATE();
    case 399:
      if (lookahead == 't') ADVANCE(190);
      END_STATE();
    case 400:
      if (lookahead == 't') ADVANCE(212);
      END_STATE();
    case 401:
      if (lookahead == 't') ADVANCE(197);
      END_STATE();
    case 402:
      if (lookahead == 't') ADVANCE(31);
      END_STATE();
    case 403:
      if (lookahead == 't') ADVANCE(364);
      END_STATE();
    case 404:
      if (lookahead == 't') ADVANCE(136);
      END_STATE();
    case 405:
      if (lookahead == 't') ADVANCE(137);
      END_STATE();
    case 406:
      if (lookahead == 't') ADVANCE(204);
      END_STATE();
    case 407:
      if (lookahead == 't') ADVANCE(205);
      END_STATE();
    case 408:
      if (lookahead == 't') ADVANCE(206);
      END_STATE();
    case 409:
      if (lookahead == 't') ADVANCE(216);
      END_STATE();
    case 410:
      if (lookahead == 't') ADVANCE(218);
      END_STATE();
    case 411:
      if (lookahead == 't') ADVANCE(221);
      END_STATE();
    case 412:
      if (lookahead == 't') ADVANCE(223);
      END_STATE();
    case 413:
      if (lookahead == 'u') ADVANCE(376);
      END_STATE();
    case 414:
      if (lookahead == 'u') ADVANCE(50);
      END_STATE();
    case 415:
      if (lookahead == 'u') ADVANCE(260);
      END_STATE();
    case 416:
      if (lookahead == 'u') ADVANCE(366);
      END_STATE();
    case 417:
      if (lookahead == 'u') ADVANCE(344);
      END_STATE();
    case 418:
      if (lookahead == 'u') ADVANCE(383);
      END_STATE();
    case 419:
      if (lookahead == 'u') ADVANCE(347);
      END_STATE();
    case 420:
      if (lookahead == 'u') ADVANCE(385);
      END_STATE();
    case 421:
      if (lookahead == 'u') ADVANCE(352);
      END_STATE();
    case 422:
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 423:
      if (lookahead == 'u') ADVANCE(54);
      END_STATE();
    case 424:
      if (lookahead == 'u') ADVANCE(301);
      END_STATE();
    case 425:
      if (lookahead == 'u') ADVANCE(56);
      END_STATE();
    case 426:
      if (lookahead == 'u') ADVANCE(303);
      END_STATE();
    case 427:
      if (lookahead == 'u') ADVANCE(291);
      END_STATE();
    case 428:
      if (lookahead == 'v') ADVANCE(151);
      END_STATE();
    case 429:
      if (lookahead == 'v') ADVANCE(76);
      END_STATE();
    case 430:
      if (lookahead == 'x') ADVANCE(1003);
      END_STATE();
    case 431:
      if (lookahead == 'x') ADVANCE(1003);
      if (lookahead == 'y') ADVANCE(372);
      END_STATE();
    case 432:
      if (lookahead == 'y') ADVANCE(490);
      END_STATE();
    case 433:
      if (lookahead == 'y') ADVANCE(467);
      END_STATE();
    case 434:
      if (lookahead == 'y') ADVANCE(372);
      END_STATE();
    case 435:
      if (lookahead == 'z') ADVANCE(214);
      END_STATE();
    case 436:
      if (lookahead == 'z') ADVANCE(145);
      END_STATE();
    case 437:
      if (lookahead == '{') ADVANCE(442);
      END_STATE();
    case 438:
      if (lookahead == '|') ADVANCE(513);
      END_STATE();
    case 439:
      if (lookahead == '}') ADVANCE(560);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(439);
      END_STATE();
    case 440:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(997);
      END_STATE();
    case 441:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(1002);
      END_STATE();
    case 442:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(439);
      END_STATE();
    case 443:
      if (eof) ADVANCE(445);
      ADVANCE_MAP(
        '!', 531,
        '"', 552,
        '#', 441,
        '%', 509,
        '&', 18,
        '(', 503,
        ')', 504,
        '*', 538,
        '+', 536,
        ',', 449,
        '-', 534,
        '.', 511,
        '/', 540,
        ':', 470,
        ';', 454,
        '<', 461,
        '=', 547,
        '>', 464,
        '?', 514,
        '@', 101,
        '[', 484,
        '\\', 559,
        ']', 485,
        'a', 264,
        'b', 306,
        'c', 44,
        'd', 157,
        'e', 45,
        'f', 51,
        'g', 240,
        'i', 172,
        'l', 147,
        'n', 561,
        'o', 413,
        'p', 61,
        'r', 127,
        's', 149,
        't', 332,
        'u', 437,
        'w', 193,
        '{', 448,
        '|', 508,
        '}', 450,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(443);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(995);
      END_STATE();
    case 444:
      if (eof) ADVANCE(445);
      ADVANCE_MAP(
        '!', 36,
        '%', 509,
        '&', 18,
        '(', 503,
        ')', 504,
        '*', 538,
        '+', 536,
        ',', 449,
        '-', 533,
        '.', 510,
        '/', 540,
        ':', 469,
        ';', 454,
        '<', 462,
        '=', 547,
        '>', 464,
        '?', 514,
        '[', 484,
        ']', 485,
        'c', 788,
        'e', 734,
        'g', 711,
        'i', 731,
        's', 832,
        '{', 448,
        '|', 438,
        '}', 450,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(444);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(996);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(sym_export);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(sym_export);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(anon_sym_import);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 457:
      ACCEPT_TOKEN(anon_sym_component);
      END_STATE();
    case 458:
      ACCEPT_TOKEN(anon_sym_component);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 459:
      ACCEPT_TOKEN(anon_sym_inherits);
      END_STATE();
    case 460:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 461:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(543);
      END_STATE();
    case 462:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(542);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 464:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(541);
      END_STATE();
    case 465:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 466:
      ACCEPT_TOKEN(anon_sym_return);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 467:
      ACCEPT_TOKEN(anon_sym_property);
      END_STATE();
    case 468:
      ACCEPT_TOKEN(anon_sym_property);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 470:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(456);
      END_STATE();
    case 471:
      ACCEPT_TOKEN(anon_sym_LT_EQ_GT);
      END_STATE();
    case 472:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 473:
      ACCEPT_TOKEN(anon_sym_global);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 474:
      ACCEPT_TOKEN(anon_sym_struct);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 475:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 476:
      ACCEPT_TOKEN(anon_sym_enum);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 477:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 478:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == '-') ADVANCE(785);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 479:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 480:
      ACCEPT_TOKEN(anon_sym_out);
      END_STATE();
    case 481:
      ACCEPT_TOKEN(anon_sym_out);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 482:
      ACCEPT_TOKEN(anon_sym_transitions);
      END_STATE();
    case 483:
      ACCEPT_TOKEN(anon_sym_transitions);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 484:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 485:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 486:
      ACCEPT_TOKEN(anon_sym_states);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 487:
      ACCEPT_TOKEN(anon_sym_when);
      END_STATE();
    case 488:
      ACCEPT_TOKEN(anon_sym_animate);
      END_STATE();
    case 489:
      ACCEPT_TOKEN(anon_sym_animate);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 490:
      ACCEPT_TOKEN(anon_sym_delay);
      END_STATE();
    case 491:
      ACCEPT_TOKEN(anon_sym_duration);
      END_STATE();
    case 492:
      ACCEPT_TOKEN(anon_sym_duration);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 493:
      ACCEPT_TOKEN(anon_sym_iteration_DASHcount);
      END_STATE();
    case 494:
      ACCEPT_TOKEN(anon_sym_direction);
      END_STATE();
    case 495:
      ACCEPT_TOKEN(anon_sym_easing);
      END_STATE();
    case 496:
      ACCEPT_TOKEN(anon_sym_easing);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 497:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 498:
      ACCEPT_TOKEN(anon_sym_if);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 499:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 500:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 501:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 502:
      ACCEPT_TOKEN(anon_sym_for);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 503:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 504:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 505:
      ACCEPT_TOKEN(anon_sym_ATtr);
      END_STATE();
    case 506:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 507:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 508:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(513);
      END_STATE();
    case 509:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 510:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 511:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(997);
      END_STATE();
    case 512:
      ACCEPT_TOKEN(sym_logical_and);
      END_STATE();
    case 513:
      ACCEPT_TOKEN(sym_logical_or);
      END_STATE();
    case 514:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 515:
      ACCEPT_TOKEN(anon_sym_callback);
      END_STATE();
    case 516:
      ACCEPT_TOKEN(anon_sym_callback);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 517:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 518:
      ACCEPT_TOKEN(anon_sym_pure);
      END_STATE();
    case 519:
      ACCEPT_TOKEN(anon_sym_pure);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 520:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 521:
      ACCEPT_TOKEN(anon_sym_public);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 522:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 523:
      ACCEPT_TOKEN(anon_sym_private);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 524:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 525:
      ACCEPT_TOKEN(anon_sym_function);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 526:
      ACCEPT_TOKEN(anon_sym_changed);
      END_STATE();
    case 527:
      ACCEPT_TOKEN(anon_sym_changed);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 528:
      ACCEPT_TOKEN(anon_sym_ATimage_DASHurl);
      END_STATE();
    case 529:
      ACCEPT_TOKEN(anon_sym_nine_DASHslice);
      END_STATE();
    case 530:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 531:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(545);
      END_STATE();
    case 532:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 533:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(549);
      END_STATE();
    case 534:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(549);
      if (lookahead == '>') ADVANCE(517);
      END_STATE();
    case 535:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 536:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(548);
      END_STATE();
    case 537:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 538:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(550);
      END_STATE();
    case 539:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(23);
      if (lookahead == '/') ADVANCE(1017);
      END_STATE();
    case 540:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(23);
      if (lookahead == '/') ADVANCE(1017);
      if (lookahead == '=') ADVANCE(551);
      END_STATE();
    case 541:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 542:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 543:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      if (lookahead == '>') ADVANCE(471);
      END_STATE();
    case 544:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 545:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 546:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(544);
      END_STATE();
    case 547:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(544);
      if (lookahead == '>') ADVANCE(506);
      END_STATE();
    case 548:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 549:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 550:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 551:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 552:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 553:
      ACCEPT_TOKEN(sym__unescaped_string_fragment);
      if (lookahead == '*') ADVANCE(555);
      if (lookahead == '/') ADVANCE(557);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(558);
      END_STATE();
    case 554:
      ACCEPT_TOKEN(sym__unescaped_string_fragment);
      if (lookahead == '*') ADVANCE(554);
      if (lookahead == '/') ADVANCE(558);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(555);
      END_STATE();
    case 555:
      ACCEPT_TOKEN(sym__unescaped_string_fragment);
      if (lookahead == '*') ADVANCE(554);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(555);
      END_STATE();
    case 556:
      ACCEPT_TOKEN(sym__unescaped_string_fragment);
      if (lookahead == '/') ADVANCE(553);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(556);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(558);
      END_STATE();
    case 557:
      ACCEPT_TOKEN(sym__unescaped_string_fragment);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(558);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(557);
      END_STATE();
    case 558:
      ACCEPT_TOKEN(sym__unescaped_string_fragment);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(558);
      END_STATE();
    case 559:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      END_STATE();
    case 560:
      ACCEPT_TOKEN(aux_sym_escape_sequence_token1);
      END_STATE();
    case 561:
      ACCEPT_TOKEN(anon_sym_n);
      END_STATE();
    case 562:
      ACCEPT_TOKEN(anon_sym_in_DASHout);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 563:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == '-') ADVANCE(603);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 564:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == '-') ADVANCE(668);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 565:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == '-') ADVANCE(721);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 566:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == '-') ADVANCE(827);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 567:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(822);
      if (lookahead == 'l') ADVANCE(828);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 568:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(822);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 569:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(626);
      if (lookahead == 'i') ADVANCE(757);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 570:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(629);
      if (lookahead == 'e') ADVANCE(729);
      if (lookahead == 'o') ADVANCE(776);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 571:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(629);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 572:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(709);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 573:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(826);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 574:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(627);
      if (lookahead == 'i') ADVANCE(759);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 575:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(720);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 576:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(608);
      if (lookahead == 'o') ADVANCE(874);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 577:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(628);
      if (lookahead == 'i') ADVANCE(760);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 578:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(818);
      if (lookahead == 'h') ADVANCE(889);
      if (lookahead == 't' ||
          lookahead == 'x') ADVANCE(1006);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 579:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(818);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 580:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(715);
      if (lookahead == 'h') ADVANCE(585);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 581:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(715);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 582:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(616);
      if (lookahead == 'o') ADVANCE(885);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 583:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(796);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 584:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(617);
      if (lookahead == 'o') ADVANCE(886);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 585:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(743);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 586:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(713);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 587:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(744);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 588:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(619);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 589:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(862);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 590:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(863);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 591:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(864);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 592:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(851);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 593:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(860);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 594:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(674);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 595:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(825);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 596:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(829);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 597:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(830);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 598:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(868);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 599:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'b') ADVANCE(572);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 600:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'b') ADVANCE(576);
      if (lookahead == 'c') ADVANCE(686);
      if (lookahead == 'e') ADVANCE(714);
      if (lookahead == 'o') ADVANCE(879);
      if (lookahead == 'q') ADVANCE(870);
      if (lookahead == 's') ADVANCE(700);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 601:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'b') ADVANCE(681);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 602:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'b') ADVANCE(722);
      if (lookahead == 'r') ADVANCE(643);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 603:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'b') ADVANCE(634);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 604:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'b') ADVANCE(588);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 605:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'b') ADVANCE(582);
      if (lookahead == 'c') ADVANCE(689);
      if (lookahead == 'e') ADVANCE(724);
      if (lookahead == 'q') ADVANCE(883);
      if (lookahead == 's') ADVANCE(702);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 606:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'b') ADVANCE(584);
      if (lookahead == 'c') ADVANCE(690);
      if (lookahead == 'e') ADVANCE(725);
      if (lookahead == 'q') ADVANCE(884);
      if (lookahead == 's') ADVANCE(703);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 607:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(563);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 608:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(705);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 609:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(964);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 610:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(966);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 611:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(970);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 612:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(968);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 613:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(972);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 614:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(974);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 615:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(521);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 616:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(706);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 617:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(707);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 618:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(835);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 619:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(708);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 620:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(637);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 621:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(638);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 622:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(640);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 623:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(859);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 624:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(586);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 625:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(663);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 626:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'd') ADVANCE(920);
      if (lookahead == 'r') ADVANCE(841);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 627:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'd') ADVANCE(922);
      if (lookahead == 'r') ADVANCE(843);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 628:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'd') ADVANCE(924);
      if (lookahead == 'r') ADVANCE(845);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 629:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'd') ADVANCE(1012);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 630:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'd') ADVANCE(527);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 631:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(925);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 632:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(999);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 633:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(1001);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 634:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(892);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 635:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(952);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 636:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(954);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 637:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(976);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 638:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(978);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 639:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(956);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 640:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(980);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 641:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(669);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 642:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(500);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 643:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(519);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 644:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(489);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 645:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(523);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 646:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(910);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 647:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(914);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 648:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(916);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 649:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(748);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 650:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(630);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 651:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(564);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 652:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(712);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 653:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(819);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 654:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(856);
      if (lookahead == 'o') ADVANCE(776);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 655:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(723);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 656:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(797);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 657:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(814);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 658:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(747);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 659:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(754);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 660:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(583);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 661:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(812);
      if (lookahead == 'h') ADVANCE(891);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 662:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(764);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 663:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(761);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 664:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'f') ADVANCE(498);
      if (lookahead == 'n') ADVANCE(1006);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 665:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'f') ADVANCE(498);
      if (lookahead == 'n') ADVANCE(478);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 666:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'f') ADVANCE(498);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 667:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'f') ADVANCE(994);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 668:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'f') ADVANCE(787);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 669:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'g') ADVANCE(1012);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 670:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'g') ADVANCE(496);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 671:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'g') ADVANCE(900);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 672:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'g') ADVANCE(718);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 673:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'g') ADVANCE(650);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 674:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'g') ADVANCE(647);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 675:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'g') ADVANCE(853);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 676:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'g') ADVANCE(854);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 677:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'h') ADVANCE(904);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 678:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'h') ADVANCE(908);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 679:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'h') ADVANCE(906);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 680:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(888);
      if (lookahead == 'o') ADVANCE(795);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 681:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(607);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 682:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(893);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 683:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(887);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 684:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(732);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 685:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(737);
      if (lookahead == 'o') ADVANCE(877);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 686:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(807);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 687:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(611);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 688:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(656);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 689:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(809);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 690:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(811);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 691:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(613);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 692:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(778);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 693:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(614);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 694:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(615);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 695:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(624);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 696:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(750);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 697:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(753);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 698:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(746);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 699:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(779);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 700:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(755);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 701:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(783);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 702:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(756);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 703:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(758);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 704:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(867);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 705:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'k') ADVANCE(958);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 706:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'k') ADVANCE(960);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 707:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'k') ADVANCE(962);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 708:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'k') ADVANCE(516);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 709:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(473);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 710:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(899);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 711:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(767);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 712:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(667);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 713:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(565);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 714:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(573);
      if (lookahead == 'x') ADVANCE(792);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 715:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(719);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 716:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(786);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 717:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(782);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 718:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(646);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 719:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(604);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 720:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(823);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 721:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(662);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 722:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(694);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 723:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(593);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 724:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(596);
      if (lookahead == 'x') ADVANCE(793);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 725:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(597);
      if (lookahead == 'x') ADVANCE(794);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 726:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'm') ADVANCE(476);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 727:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'm') ADVANCE(1006);
      if (lookahead == 's') ADVANCE(1010);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 728:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'm') ADVANCE(1006);
      if (lookahead == 'u') ADVANCE(601);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 729:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'm') ADVANCE(1015);
      if (lookahead == 't') ADVANCE(873);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 730:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'm') ADVANCE(594);
      if (lookahead == 'n') ADVANCE(850);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 731:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'm') ADVANCE(790);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 732:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'm') ADVANCE(590);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 733:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'm') ADVANCE(791);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 734:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(871);
      if (lookahead == 'x') ADVANCE(789);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 735:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(649);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 736:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(466);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 737:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(928);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 738:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(479);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 739:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(1012);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 740:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(478);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 741:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(525);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 742:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(492);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 743:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(673);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 744:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(824);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 745:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(672);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 746:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(660);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 747:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(675);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 748:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(836);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 749:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(820);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 750:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(670);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 751:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(620);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 752:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(684);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 753:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(671);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 754:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(838);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 755:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(635);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 756:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(636);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 757:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(842);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 758:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(639);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 759:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(844);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 760:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(846);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 761:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(852);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 762:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(855);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 763:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(623);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 764:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(676);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 765:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(621);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 766:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(622);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 767:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(599);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 768:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(735);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 769:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(946);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 770:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(948);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 771:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(950);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 772:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(795);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 773:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(800);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 774:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(803);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 775:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(776);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 776:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(837);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 777:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(710);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 778:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(741);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 779:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(749);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 780:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(777);
      if (lookahead == 'r') ADVANCE(876);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 781:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(798);
      if (lookahead == 'u') ADVANCE(763);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 782:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(799);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 783:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(742);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 784:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(717);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 785:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(882);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 786:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(592);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 787:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(762);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 788:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(733);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 789:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'p') ADVANCE(773);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 790:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'p') ADVANCE(774);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 791:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'p') ADVANCE(768);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 792:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'p') ADVANCE(769);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 793:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'p') ADVANCE(770);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 794:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'p') ADVANCE(771);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 795:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'p') ADVANCE(657);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 796:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(918);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 797:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(982);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 798:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(502);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 799:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(902);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 800:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(833);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 801:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(869);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 802:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(680);
      if (lookahead == 'u') ADVANCE(602);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 803:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(834);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 804:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(736);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 805:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(875);
      if (lookahead == 'u') ADVANCE(810);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 806:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(875);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 807:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(609);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 808:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(571);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 809:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(610);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 810:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(739);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 811:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(612);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 812:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(625);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 813:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(772);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 814:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(849);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 815:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(587);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 816:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(697);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 817:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(598);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 818:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(659);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 819:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 's') ADVANCE(486);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 820:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 's') ADVANCE(483);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 821:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 's') ADVANCE(677);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 822:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 's') ADVANCE(631);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 823:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 's') ADVANCE(633);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 824:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 's') ADVANCE(704);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 825:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 's') ADVANCE(696);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 826:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 's') ADVANCE(857);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 827:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 's') ADVANCE(682);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 828:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 's') ADVANCE(642);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 829:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 's') ADVANCE(865);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 830:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 's') ADVANCE(866);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 831:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 's') ADVANCE(695);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 832:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(801);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 833:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(447);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 834:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(452);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 835:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(474);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 836:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(458);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 837:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(992);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 838:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(990);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 839:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(930);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 840:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(932);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 841:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(934);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 842:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(940);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 843:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(936);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 844:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(942);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 845:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(938);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 846:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(944);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 847:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(481);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 848:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(562);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 849:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(890);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 850:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(895);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 851:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(897);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 852:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(912);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 853:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(678);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 854:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(679);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 855:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(566);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 856:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(873);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 857:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(687);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 858:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(589);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 859:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(692);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 860:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(683);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 861:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(816);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 862:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(653);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 863:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(644);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 864:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(645);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 865:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(691);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 866:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(693);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 867:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(699);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 868:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(701);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 869:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(618);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 870:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(569);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 871:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(726);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 872:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(601);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 873:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(804);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 874:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(751);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 875:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(632);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 876:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(821);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 877:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(839);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 878:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(763);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 879:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(840);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 880:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(817);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 881:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(847);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 882:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(848);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 883:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(574);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 884:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(577);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 885:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(765);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 886:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(766);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 887:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'v') ADVANCE(651);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 888:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'v') ADVANCE(591);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 889:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'x') ADVANCE(1004);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 890:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'y') ADVANCE(468);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 891:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'y') ADVANCE(831);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 892:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'z') ADVANCE(688);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(894);
      END_STATE();
    case 893:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'z') ADVANCE(648);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(894);
      END_STATE();
    case 894:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 895:
      ACCEPT_TOKEN(anon_sym_int);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 896:
      ACCEPT_TOKEN(anon_sym_float);
      END_STATE();
    case 897:
      ACCEPT_TOKEN(anon_sym_float);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 898:
      ACCEPT_TOKEN(anon_sym_bool);
      END_STATE();
    case 899:
      ACCEPT_TOKEN(anon_sym_bool);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 900:
      ACCEPT_TOKEN(anon_sym_string);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 901:
      ACCEPT_TOKEN(anon_sym_color);
      END_STATE();
    case 902:
      ACCEPT_TOKEN(anon_sym_color);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 903:
      ACCEPT_TOKEN(anon_sym_brush);
      END_STATE();
    case 904:
      ACCEPT_TOKEN(anon_sym_brush);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 905:
      ACCEPT_TOKEN(anon_sym_physical_DASHlength);
      END_STATE();
    case 906:
      ACCEPT_TOKEN(anon_sym_physical_DASHlength);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 907:
      ACCEPT_TOKEN(anon_sym_length);
      END_STATE();
    case 908:
      ACCEPT_TOKEN(anon_sym_length);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 909:
      ACCEPT_TOKEN(anon_sym_angle);
      END_STATE();
    case 910:
      ACCEPT_TOKEN(anon_sym_angle);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 911:
      ACCEPT_TOKEN(anon_sym_percent);
      END_STATE();
    case 912:
      ACCEPT_TOKEN(anon_sym_percent);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 913:
      ACCEPT_TOKEN(anon_sym_image);
      END_STATE();
    case 914:
      ACCEPT_TOKEN(anon_sym_image);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 915:
      ACCEPT_TOKEN(anon_sym_relative_DASHfont_DASHsize);
      END_STATE();
    case 916:
      ACCEPT_TOKEN(anon_sym_relative_DASHfont_DASHsize);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 917:
      ACCEPT_TOKEN(anon_sym_linear);
      END_STATE();
    case 918:
      ACCEPT_TOKEN(anon_sym_linear);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 919:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHquad);
      END_STATE();
    case 920:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHquad);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 921:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHquad);
      END_STATE();
    case 922:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHquad);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 923:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHquad);
      END_STATE();
    case 924:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHquad);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 925:
      ACCEPT_TOKEN(anon_sym_ease);
      if (lookahead == '-') ADVANCE(685);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 926:
      ACCEPT_TOKEN(anon_sym_ease);
      if (lookahead == '-') ADVANCE(203);
      END_STATE();
    case 927:
      ACCEPT_TOKEN(anon_sym_ease_DASHin);
      if (lookahead == '-') ADVANCE(83);
      END_STATE();
    case 928:
      ACCEPT_TOKEN(anon_sym_ease_DASHin);
      if (lookahead == '-') ADVANCE(600);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 929:
      ACCEPT_TOKEN(anon_sym_ease_DASHout);
      if (lookahead == '-') ADVANCE(89);
      END_STATE();
    case 930:
      ACCEPT_TOKEN(anon_sym_ease_DASHout);
      if (lookahead == '-') ADVANCE(605);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 931:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout);
      if (lookahead == '-') ADVANCE(90);
      END_STATE();
    case 932:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout);
      if (lookahead == '-') ADVANCE(606);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 933:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHquart);
      END_STATE();
    case 934:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHquart);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 935:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHquart);
      END_STATE();
    case 936:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHquart);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 937:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHquart);
      END_STATE();
    case 938:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHquart);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 939:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHquint);
      END_STATE();
    case 940:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHquint);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 941:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHquint);
      END_STATE();
    case 942:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHquint);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 943:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHquint);
      END_STATE();
    case 944:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHquint);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 945:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHexpo);
      END_STATE();
    case 946:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHexpo);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 947:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHexpo);
      END_STATE();
    case 948:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHexpo);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 949:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHexpo);
      END_STATE();
    case 950:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHexpo);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 951:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHsine);
      END_STATE();
    case 952:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHsine);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 953:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHsine);
      END_STATE();
    case 954:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHsine);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 955:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHsine);
      END_STATE();
    case 956:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHsine);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 957:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHback);
      END_STATE();
    case 958:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHback);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 959:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHback);
      END_STATE();
    case 960:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHback);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 961:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHback);
      END_STATE();
    case 962:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHback);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 963:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHcirc);
      END_STATE();
    case 964:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHcirc);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 965:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHcirc);
      END_STATE();
    case 966:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHcirc);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 967:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHcirc);
      END_STATE();
    case 968:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHcirc);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 969:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHelastic);
      END_STATE();
    case 970:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHelastic);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 971:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHelastic);
      END_STATE();
    case 972:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHelastic);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 973:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHelastic);
      END_STATE();
    case 974:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHelastic);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 975:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHbounce);
      END_STATE();
    case 976:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHbounce);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 977:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHbounce);
      END_STATE();
    case 978:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHbounce);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 979:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHbounce);
      END_STATE();
    case 980:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHbounce);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 981:
      ACCEPT_TOKEN(anon_sym_cubic_DASHbezier);
      END_STATE();
    case 982:
      ACCEPT_TOKEN(anon_sym_cubic_DASHbezier);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 983:
      ACCEPT_TOKEN(sym_children_identifier);
      END_STATE();
    case 984:
      ACCEPT_TOKEN(anon_sym_ATlinear_DASHgradient);
      END_STATE();
    case 985:
      ACCEPT_TOKEN(anon_sym_ATlinear_gradient);
      END_STATE();
    case 986:
      ACCEPT_TOKEN(anon_sym_ATradial_DASHgradient);
      END_STATE();
    case 987:
      ACCEPT_TOKEN(anon_sym_ATradial_gradient);
      END_STATE();
    case 988:
      ACCEPT_TOKEN(anon_sym_circle);
      END_STATE();
    case 989:
      ACCEPT_TOKEN(anon_sym_parent);
      END_STATE();
    case 990:
      ACCEPT_TOKEN(anon_sym_parent);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 991:
      ACCEPT_TOKEN(anon_sym_root);
      END_STATE();
    case 992:
      ACCEPT_TOKEN(anon_sym_root);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 993:
      ACCEPT_TOKEN(anon_sym_self);
      END_STATE();
    case 994:
      ACCEPT_TOKEN(anon_sym_self);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 995:
      ACCEPT_TOKEN(sym__int_number);
      if (lookahead == '.') ADVANCE(997);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(995);
      END_STATE();
    case 996:
      ACCEPT_TOKEN(sym__int_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(996);
      END_STATE();
    case 997:
      ACCEPT_TOKEN(sym__float_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(997);
      END_STATE();
    case 998:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 999:
      ACCEPT_TOKEN(anon_sym_true);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 1000:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 1001:
      ACCEPT_TOKEN(anon_sym_false);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 1002:
      ACCEPT_TOKEN(sym_color_value);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(1002);
      END_STATE();
    case 1003:
      ACCEPT_TOKEN(anon_sym_phx);
      END_STATE();
    case 1004:
      ACCEPT_TOKEN(anon_sym_phx);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 1005:
      ACCEPT_TOKEN(aux_sym_length_value_token1);
      END_STATE();
    case 1006:
      ACCEPT_TOKEN(aux_sym_length_value_token1);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 1007:
      ACCEPT_TOKEN(aux_sym_duration_value_token1);
      END_STATE();
    case 1008:
      ACCEPT_TOKEN(aux_sym_duration_value_token1);
      if (lookahead == 'e') ADVANCE(233);
      END_STATE();
    case 1009:
      ACCEPT_TOKEN(aux_sym_duration_value_token1);
      if (lookahead == 'e') ADVANCE(712);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 1010:
      ACCEPT_TOKEN(aux_sym_duration_value_token1);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 1011:
      ACCEPT_TOKEN(aux_sym_angle_value_token1);
      END_STATE();
    case 1012:
      ACCEPT_TOKEN(aux_sym_angle_value_token1);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 1013:
      ACCEPT_TOKEN(anon_sym_PERCENT2);
      END_STATE();
    case 1014:
      ACCEPT_TOKEN(anon_sym_rem);
      END_STATE();
    case 1015:
      ACCEPT_TOKEN(anon_sym_rem);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 1016:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 1017:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(1017);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 444},
  [2] = {.lex_state = 1},
  [3] = {.lex_state = 1},
  [4] = {.lex_state = 1},
  [5] = {.lex_state = 1},
  [6] = {.lex_state = 1},
  [7] = {.lex_state = 1},
  [8] = {.lex_state = 1},
  [9] = {.lex_state = 1},
  [10] = {.lex_state = 1},
  [11] = {.lex_state = 1},
  [12] = {.lex_state = 1},
  [13] = {.lex_state = 1},
  [14] = {.lex_state = 1},
  [15] = {.lex_state = 1},
  [16] = {.lex_state = 5},
  [17] = {.lex_state = 5},
  [18] = {.lex_state = 5},
  [19] = {.lex_state = 15},
  [20] = {.lex_state = 15},
  [21] = {.lex_state = 15},
  [22] = {.lex_state = 15},
  [23] = {.lex_state = 15},
  [24] = {.lex_state = 15},
  [25] = {.lex_state = 15},
  [26] = {.lex_state = 15},
  [27] = {.lex_state = 15},
  [28] = {.lex_state = 15},
  [29] = {.lex_state = 15},
  [30] = {.lex_state = 15},
  [31] = {.lex_state = 15},
  [32] = {.lex_state = 15},
  [33] = {.lex_state = 15},
  [34] = {.lex_state = 15},
  [35] = {.lex_state = 15},
  [36] = {.lex_state = 15},
  [37] = {.lex_state = 15},
  [38] = {.lex_state = 15},
  [39] = {.lex_state = 15},
  [40] = {.lex_state = 15},
  [41] = {.lex_state = 15},
  [42] = {.lex_state = 15},
  [43] = {.lex_state = 15},
  [44] = {.lex_state = 15},
  [45] = {.lex_state = 15},
  [46] = {.lex_state = 15},
  [47] = {.lex_state = 15},
  [48] = {.lex_state = 15},
  [49] = {.lex_state = 15},
  [50] = {.lex_state = 15},
  [51] = {.lex_state = 15},
  [52] = {.lex_state = 15},
  [53] = {.lex_state = 15},
  [54] = {.lex_state = 15},
  [55] = {.lex_state = 15},
  [56] = {.lex_state = 15},
  [57] = {.lex_state = 15},
  [58] = {.lex_state = 15},
  [59] = {.lex_state = 15},
  [60] = {.lex_state = 15},
  [61] = {.lex_state = 15},
  [62] = {.lex_state = 15},
  [63] = {.lex_state = 15},
  [64] = {.lex_state = 15},
  [65] = {.lex_state = 15},
  [66] = {.lex_state = 15},
  [67] = {.lex_state = 15},
  [68] = {.lex_state = 15},
  [69] = {.lex_state = 15},
  [70] = {.lex_state = 15},
  [71] = {.lex_state = 15},
  [72] = {.lex_state = 15},
  [73] = {.lex_state = 15},
  [74] = {.lex_state = 15},
  [75] = {.lex_state = 15},
  [76] = {.lex_state = 15},
  [77] = {.lex_state = 15},
  [78] = {.lex_state = 15},
  [79] = {.lex_state = 15},
  [80] = {.lex_state = 15},
  [81] = {.lex_state = 15},
  [82] = {.lex_state = 15},
  [83] = {.lex_state = 15},
  [84] = {.lex_state = 15},
  [85] = {.lex_state = 15},
  [86] = {.lex_state = 15},
  [87] = {.lex_state = 15},
  [88] = {.lex_state = 15},
  [89] = {.lex_state = 15},
  [90] = {.lex_state = 15},
  [91] = {.lex_state = 15},
  [92] = {.lex_state = 15},
  [93] = {.lex_state = 15},
  [94] = {.lex_state = 15},
  [95] = {.lex_state = 15},
  [96] = {.lex_state = 15},
  [97] = {.lex_state = 15},
  [98] = {.lex_state = 15},
  [99] = {.lex_state = 15},
  [100] = {.lex_state = 15},
  [101] = {.lex_state = 15},
  [102] = {.lex_state = 15},
  [103] = {.lex_state = 15},
  [104] = {.lex_state = 15},
  [105] = {.lex_state = 15},
  [106] = {.lex_state = 15},
  [107] = {.lex_state = 15},
  [108] = {.lex_state = 15},
  [109] = {.lex_state = 15},
  [110] = {.lex_state = 15},
  [111] = {.lex_state = 15},
  [112] = {.lex_state = 15},
  [113] = {.lex_state = 15},
  [114] = {.lex_state = 15},
  [115] = {.lex_state = 15},
  [116] = {.lex_state = 15},
  [117] = {.lex_state = 15},
  [118] = {.lex_state = 15},
  [119] = {.lex_state = 15},
  [120] = {.lex_state = 15},
  [121] = {.lex_state = 15},
  [122] = {.lex_state = 15},
  [123] = {.lex_state = 15},
  [124] = {.lex_state = 15},
  [125] = {.lex_state = 15},
  [126] = {.lex_state = 15},
  [127] = {.lex_state = 15},
  [128] = {.lex_state = 15},
  [129] = {.lex_state = 15},
  [130] = {.lex_state = 15},
  [131] = {.lex_state = 15},
  [132] = {.lex_state = 15},
  [133] = {.lex_state = 15},
  [134] = {.lex_state = 15},
  [135] = {.lex_state = 15},
  [136] = {.lex_state = 15},
  [137] = {.lex_state = 15},
  [138] = {.lex_state = 15},
  [139] = {.lex_state = 15},
  [140] = {.lex_state = 15},
  [141] = {.lex_state = 15},
  [142] = {.lex_state = 15},
  [143] = {.lex_state = 15},
  [144] = {.lex_state = 15},
  [145] = {.lex_state = 15},
  [146] = {.lex_state = 15},
  [147] = {.lex_state = 15},
  [148] = {.lex_state = 15},
  [149] = {.lex_state = 2},
  [150] = {.lex_state = 2},
  [151] = {.lex_state = 1},
  [152] = {.lex_state = 1},
  [153] = {.lex_state = 1},
  [154] = {.lex_state = 1},
  [155] = {.lex_state = 1},
  [156] = {.lex_state = 1},
  [157] = {.lex_state = 1},
  [158] = {.lex_state = 1},
  [159] = {.lex_state = 1},
  [160] = {.lex_state = 1},
  [161] = {.lex_state = 1},
  [162] = {.lex_state = 1},
  [163] = {.lex_state = 1},
  [164] = {.lex_state = 1},
  [165] = {.lex_state = 1},
  [166] = {.lex_state = 1},
  [167] = {.lex_state = 1},
  [168] = {.lex_state = 1},
  [169] = {.lex_state = 1},
  [170] = {.lex_state = 1},
  [171] = {.lex_state = 1},
  [172] = {.lex_state = 1},
  [173] = {.lex_state = 1},
  [174] = {.lex_state = 1},
  [175] = {.lex_state = 1},
  [176] = {.lex_state = 1},
  [177] = {.lex_state = 1},
  [178] = {.lex_state = 1},
  [179] = {.lex_state = 1},
  [180] = {.lex_state = 1},
  [181] = {.lex_state = 1},
  [182] = {.lex_state = 1},
  [183] = {.lex_state = 1},
  [184] = {.lex_state = 1},
  [185] = {.lex_state = 1},
  [186] = {.lex_state = 1},
  [187] = {.lex_state = 1},
  [188] = {.lex_state = 1},
  [189] = {.lex_state = 1},
  [190] = {.lex_state = 1},
  [191] = {.lex_state = 1},
  [192] = {.lex_state = 1},
  [193] = {.lex_state = 1},
  [194] = {.lex_state = 1},
  [195] = {.lex_state = 1},
  [196] = {.lex_state = 1},
  [197] = {.lex_state = 1},
  [198] = {.lex_state = 1},
  [199] = {.lex_state = 1},
  [200] = {.lex_state = 1},
  [201] = {.lex_state = 1},
  [202] = {.lex_state = 1},
  [203] = {.lex_state = 1},
  [204] = {.lex_state = 1},
  [205] = {.lex_state = 1},
  [206] = {.lex_state = 1},
  [207] = {.lex_state = 1},
  [208] = {.lex_state = 1},
  [209] = {.lex_state = 1},
  [210] = {.lex_state = 1},
  [211] = {.lex_state = 1},
  [212] = {.lex_state = 1},
  [213] = {.lex_state = 1},
  [214] = {.lex_state = 1},
  [215] = {.lex_state = 1},
  [216] = {.lex_state = 1},
  [217] = {.lex_state = 1},
  [218] = {.lex_state = 1},
  [219] = {.lex_state = 1},
  [220] = {.lex_state = 1},
  [221] = {.lex_state = 1},
  [222] = {.lex_state = 1},
  [223] = {.lex_state = 1},
  [224] = {.lex_state = 1},
  [225] = {.lex_state = 1},
  [226] = {.lex_state = 1},
  [227] = {.lex_state = 1},
  [228] = {.lex_state = 1},
  [229] = {.lex_state = 5},
  [230] = {.lex_state = 5},
  [231] = {.lex_state = 5},
  [232] = {.lex_state = 1},
  [233] = {.lex_state = 1},
  [234] = {.lex_state = 16},
  [235] = {.lex_state = 16},
  [236] = {.lex_state = 16},
  [237] = {.lex_state = 5},
  [238] = {.lex_state = 1},
  [239] = {.lex_state = 1},
  [240] = {.lex_state = 1},
  [241] = {.lex_state = 1},
  [242] = {.lex_state = 1},
  [243] = {.lex_state = 5},
  [244] = {.lex_state = 1},
  [245] = {.lex_state = 5},
  [246] = {.lex_state = 1},
  [247] = {.lex_state = 1},
  [248] = {.lex_state = 1},
  [249] = {.lex_state = 5},
  [250] = {.lex_state = 1},
  [251] = {.lex_state = 1},
  [252] = {.lex_state = 5},
  [253] = {.lex_state = 1},
  [254] = {.lex_state = 5},
  [255] = {.lex_state = 1},
  [256] = {.lex_state = 5},
  [257] = {.lex_state = 5},
  [258] = {.lex_state = 5},
  [259] = {.lex_state = 1},
  [260] = {.lex_state = 1},
  [261] = {.lex_state = 15},
  [262] = {.lex_state = 15},
  [263] = {.lex_state = 15},
  [264] = {.lex_state = 15},
  [265] = {.lex_state = 15},
  [266] = {.lex_state = 15},
  [267] = {.lex_state = 12},
  [268] = {.lex_state = 12},
  [269] = {.lex_state = 12},
  [270] = {.lex_state = 12},
  [271] = {.lex_state = 12},
  [272] = {.lex_state = 12},
  [273] = {.lex_state = 12},
  [274] = {.lex_state = 12},
  [275] = {.lex_state = 12},
  [276] = {.lex_state = 12},
  [277] = {.lex_state = 12},
  [278] = {.lex_state = 12},
  [279] = {.lex_state = 9},
  [280] = {.lex_state = 6},
  [281] = {.lex_state = 6},
  [282] = {.lex_state = 444},
  [283] = {.lex_state = 8},
  [284] = {.lex_state = 444},
  [285] = {.lex_state = 444},
  [286] = {.lex_state = 444},
  [287] = {.lex_state = 8},
  [288] = {.lex_state = 444},
  [289] = {.lex_state = 8},
  [290] = {.lex_state = 444},
  [291] = {.lex_state = 444},
  [292] = {.lex_state = 444},
  [293] = {.lex_state = 444},
  [294] = {.lex_state = 444},
  [295] = {.lex_state = 444},
  [296] = {.lex_state = 444},
  [297] = {.lex_state = 444},
  [298] = {.lex_state = 444},
  [299] = {.lex_state = 444},
  [300] = {.lex_state = 444},
  [301] = {.lex_state = 444},
  [302] = {.lex_state = 444},
  [303] = {.lex_state = 444},
  [304] = {.lex_state = 444},
  [305] = {.lex_state = 444},
  [306] = {.lex_state = 444},
  [307] = {.lex_state = 444},
  [308] = {.lex_state = 444},
  [309] = {.lex_state = 444},
  [310] = {.lex_state = 444},
  [311] = {.lex_state = 444},
  [312] = {.lex_state = 444},
  [313] = {.lex_state = 444},
  [314] = {.lex_state = 444},
  [315] = {.lex_state = 444},
  [316] = {.lex_state = 444},
  [317] = {.lex_state = 444},
  [318] = {.lex_state = 444},
  [319] = {.lex_state = 444},
  [320] = {.lex_state = 444},
  [321] = {.lex_state = 444},
  [322] = {.lex_state = 444},
  [323] = {.lex_state = 444},
  [324] = {.lex_state = 444},
  [325] = {.lex_state = 444},
  [326] = {.lex_state = 444},
  [327] = {.lex_state = 444},
  [328] = {.lex_state = 444},
  [329] = {.lex_state = 444},
  [330] = {.lex_state = 444},
  [331] = {.lex_state = 444},
  [332] = {.lex_state = 444},
  [333] = {.lex_state = 444},
  [334] = {.lex_state = 444},
  [335] = {.lex_state = 444},
  [336] = {.lex_state = 444},
  [337] = {.lex_state = 444},
  [338] = {.lex_state = 444},
  [339] = {.lex_state = 444},
  [340] = {.lex_state = 444},
  [341] = {.lex_state = 444},
  [342] = {.lex_state = 444},
  [343] = {.lex_state = 14},
  [344] = {.lex_state = 444},
  [345] = {.lex_state = 444},
  [346] = {.lex_state = 444},
  [347] = {.lex_state = 444},
  [348] = {.lex_state = 444},
  [349] = {.lex_state = 444},
  [350] = {.lex_state = 444},
  [351] = {.lex_state = 444},
  [352] = {.lex_state = 444},
  [353] = {.lex_state = 444},
  [354] = {.lex_state = 444},
  [355] = {.lex_state = 8},
  [356] = {.lex_state = 7},
  [357] = {.lex_state = 7},
  [358] = {.lex_state = 8},
  [359] = {.lex_state = 8},
  [360] = {.lex_state = 8},
  [361] = {.lex_state = 8},
  [362] = {.lex_state = 8},
  [363] = {.lex_state = 8},
  [364] = {.lex_state = 8},
  [365] = {.lex_state = 8},
  [366] = {.lex_state = 8},
  [367] = {.lex_state = 14},
  [368] = {.lex_state = 8},
  [369] = {.lex_state = 14},
  [370] = {.lex_state = 8},
  [371] = {.lex_state = 8},
  [372] = {.lex_state = 8},
  [373] = {.lex_state = 14},
  [374] = {.lex_state = 8},
  [375] = {.lex_state = 8},
  [376] = {.lex_state = 8},
  [377] = {.lex_state = 8},
  [378] = {.lex_state = 8},
  [379] = {.lex_state = 1},
  [380] = {.lex_state = 1},
  [381] = {.lex_state = 1},
  [382] = {.lex_state = 1},
  [383] = {.lex_state = 1},
  [384] = {.lex_state = 1},
  [385] = {.lex_state = 1},
  [386] = {.lex_state = 1},
  [387] = {.lex_state = 444},
  [388] = {.lex_state = 444},
  [389] = {.lex_state = 1},
  [390] = {.lex_state = 444},
  [391] = {.lex_state = 444},
  [392] = {.lex_state = 444},
  [393] = {.lex_state = 444},
  [394] = {.lex_state = 444},
  [395] = {.lex_state = 444},
  [396] = {.lex_state = 444},
  [397] = {.lex_state = 444},
  [398] = {.lex_state = 444},
  [399] = {.lex_state = 444},
  [400] = {.lex_state = 444},
  [401] = {.lex_state = 444},
  [402] = {.lex_state = 444},
  [403] = {.lex_state = 444},
  [404] = {.lex_state = 444},
  [405] = {.lex_state = 444},
  [406] = {.lex_state = 444},
  [407] = {.lex_state = 8},
  [408] = {.lex_state = 444},
  [409] = {.lex_state = 444},
  [410] = {.lex_state = 444},
  [411] = {.lex_state = 444},
  [412] = {.lex_state = 444},
  [413] = {.lex_state = 444},
  [414] = {.lex_state = 444},
  [415] = {.lex_state = 444},
  [416] = {.lex_state = 444},
  [417] = {.lex_state = 444},
  [418] = {.lex_state = 444},
  [419] = {.lex_state = 444},
  [420] = {.lex_state = 444},
  [421] = {.lex_state = 444},
  [422] = {.lex_state = 444},
  [423] = {.lex_state = 444},
  [424] = {.lex_state = 444},
  [425] = {.lex_state = 444},
  [426] = {.lex_state = 444},
  [427] = {.lex_state = 444},
  [428] = {.lex_state = 444},
  [429] = {.lex_state = 444},
  [430] = {.lex_state = 444},
  [431] = {.lex_state = 8},
  [432] = {.lex_state = 444},
  [433] = {.lex_state = 444},
  [434] = {.lex_state = 444},
  [435] = {.lex_state = 444},
  [436] = {.lex_state = 12},
  [437] = {.lex_state = 444},
  [438] = {.lex_state = 444},
  [439] = {.lex_state = 444},
  [440] = {.lex_state = 444},
  [441] = {.lex_state = 12},
  [442] = {.lex_state = 444},
  [443] = {.lex_state = 444},
  [444] = {.lex_state = 13},
  [445] = {.lex_state = 444},
  [446] = {.lex_state = 444},
  [447] = {.lex_state = 12},
  [448] = {.lex_state = 444},
  [449] = {.lex_state = 444},
  [450] = {.lex_state = 444},
  [451] = {.lex_state = 444},
  [452] = {.lex_state = 444},
  [453] = {.lex_state = 12},
  [454] = {.lex_state = 8},
  [455] = {.lex_state = 12},
  [456] = {.lex_state = 12},
  [457] = {.lex_state = 12},
  [458] = {.lex_state = 12},
  [459] = {.lex_state = 12},
  [460] = {.lex_state = 12},
  [461] = {.lex_state = 12},
  [462] = {.lex_state = 12},
  [463] = {.lex_state = 8},
  [464] = {.lex_state = 12},
  [465] = {.lex_state = 12},
  [466] = {.lex_state = 12},
  [467] = {.lex_state = 12},
  [468] = {.lex_state = 12},
  [469] = {.lex_state = 12},
  [470] = {.lex_state = 12},
  [471] = {.lex_state = 12},
  [472] = {.lex_state = 8},
  [473] = {.lex_state = 12},
  [474] = {.lex_state = 12},
  [475] = {.lex_state = 12},
  [476] = {.lex_state = 12},
  [477] = {.lex_state = 8},
  [478] = {.lex_state = 12},
  [479] = {.lex_state = 12},
  [480] = {.lex_state = 12},
  [481] = {.lex_state = 8},
  [482] = {.lex_state = 12},
  [483] = {.lex_state = 12},
  [484] = {.lex_state = 12},
  [485] = {.lex_state = 12},
  [486] = {.lex_state = 12},
  [487] = {.lex_state = 12},
  [488] = {.lex_state = 12},
  [489] = {.lex_state = 8},
  [490] = {.lex_state = 12},
  [491] = {.lex_state = 12},
  [492] = {.lex_state = 8},
  [493] = {.lex_state = 12},
  [494] = {.lex_state = 8},
  [495] = {.lex_state = 12},
  [496] = {.lex_state = 12},
  [497] = {.lex_state = 12},
  [498] = {.lex_state = 8},
  [499] = {.lex_state = 12},
  [500] = {.lex_state = 12},
  [501] = {.lex_state = 12},
  [502] = {.lex_state = 12},
  [503] = {.lex_state = 444},
  [504] = {.lex_state = 444},
  [505] = {.lex_state = 12},
  [506] = {.lex_state = 12},
  [507] = {.lex_state = 12},
  [508] = {.lex_state = 12},
  [509] = {.lex_state = 12},
  [510] = {.lex_state = 444},
  [511] = {.lex_state = 444},
  [512] = {.lex_state = 444},
  [513] = {.lex_state = 444},
  [514] = {.lex_state = 444},
  [515] = {.lex_state = 444},
  [516] = {.lex_state = 444},
  [517] = {.lex_state = 444},
  [518] = {.lex_state = 14},
  [519] = {.lex_state = 14},
  [520] = {.lex_state = 14},
  [521] = {.lex_state = 14},
  [522] = {.lex_state = 14},
  [523] = {.lex_state = 14},
  [524] = {.lex_state = 14},
  [525] = {.lex_state = 14},
  [526] = {.lex_state = 14},
  [527] = {.lex_state = 14},
  [528] = {.lex_state = 14},
  [529] = {.lex_state = 14},
  [530] = {.lex_state = 14},
  [531] = {.lex_state = 14},
  [532] = {.lex_state = 14},
  [533] = {.lex_state = 14},
  [534] = {.lex_state = 14},
  [535] = {.lex_state = 14},
  [536] = {.lex_state = 14},
  [537] = {.lex_state = 14},
  [538] = {.lex_state = 14},
  [539] = {.lex_state = 14},
  [540] = {.lex_state = 14},
  [541] = {.lex_state = 14},
  [542] = {.lex_state = 14},
  [543] = {.lex_state = 14},
  [544] = {.lex_state = 14},
  [545] = {.lex_state = 14},
  [546] = {.lex_state = 14},
  [547] = {.lex_state = 14},
  [548] = {.lex_state = 14},
  [549] = {.lex_state = 19},
  [550] = {.lex_state = 0},
  [551] = {.lex_state = 0},
  [552] = {.lex_state = 0},
  [553] = {.lex_state = 0},
  [554] = {.lex_state = 0},
  [555] = {.lex_state = 444},
  [556] = {.lex_state = 444},
  [557] = {.lex_state = 444},
  [558] = {.lex_state = 444},
  [559] = {.lex_state = 444},
  [560] = {.lex_state = 444},
  [561] = {.lex_state = 444},
  [562] = {.lex_state = 444},
  [563] = {.lex_state = 444},
  [564] = {.lex_state = 444},
  [565] = {.lex_state = 444},
  [566] = {.lex_state = 444},
  [567] = {.lex_state = 444},
  [568] = {.lex_state = 444},
  [569] = {.lex_state = 444},
  [570] = {.lex_state = 444},
  [571] = {.lex_state = 444},
  [572] = {.lex_state = 444},
  [573] = {.lex_state = 444},
  [574] = {.lex_state = 444},
  [575] = {.lex_state = 444},
  [576] = {.lex_state = 444},
  [577] = {.lex_state = 444},
  [578] = {.lex_state = 444},
  [579] = {.lex_state = 444},
  [580] = {.lex_state = 0},
  [581] = {.lex_state = 444},
  [582] = {.lex_state = 24},
  [583] = {.lex_state = 0},
  [584] = {.lex_state = 0},
  [585] = {.lex_state = 24},
  [586] = {.lex_state = 0},
  [587] = {.lex_state = 0},
  [588] = {.lex_state = 15},
  [589] = {.lex_state = 0},
  [590] = {.lex_state = 0},
  [591] = {.lex_state = 15},
  [592] = {.lex_state = 0},
  [593] = {.lex_state = 6},
  [594] = {.lex_state = 0},
  [595] = {.lex_state = 34},
  [596] = {.lex_state = 0},
  [597] = {.lex_state = 0},
  [598] = {.lex_state = 0},
  [599] = {.lex_state = 0},
  [600] = {.lex_state = 15},
  [601] = {.lex_state = 15},
  [602] = {.lex_state = 6},
  [603] = {.lex_state = 17},
  [604] = {.lex_state = 19},
  [605] = {.lex_state = 17},
  [606] = {.lex_state = 17},
  [607] = {.lex_state = 17},
  [608] = {.lex_state = 9},
  [609] = {.lex_state = 19},
  [610] = {.lex_state = 19},
  [611] = {.lex_state = 0},
  [612] = {.lex_state = 0},
  [613] = {.lex_state = 19},
  [614] = {.lex_state = 19},
  [615] = {.lex_state = 9},
  [616] = {.lex_state = 19},
  [617] = {.lex_state = 0},
  [618] = {.lex_state = 17},
  [619] = {.lex_state = 9},
  [620] = {.lex_state = 0},
  [621] = {.lex_state = 15},
  [622] = {.lex_state = 20},
  [623] = {.lex_state = 20},
  [624] = {.lex_state = 20},
  [625] = {.lex_state = 15},
  [626] = {.lex_state = 20},
  [627] = {.lex_state = 0},
  [628] = {.lex_state = 0},
  [629] = {.lex_state = 20},
  [630] = {.lex_state = 20},
  [631] = {.lex_state = 0},
  [632] = {.lex_state = 20},
  [633] = {.lex_state = 0},
  [634] = {.lex_state = 0},
  [635] = {.lex_state = 0},
  [636] = {.lex_state = 0},
  [637] = {.lex_state = 20},
  [638] = {.lex_state = 0},
  [639] = {.lex_state = 19},
  [640] = {.lex_state = 20},
  [641] = {.lex_state = 15},
  [642] = {.lex_state = 20},
  [643] = {.lex_state = 20},
  [644] = {.lex_state = 0},
  [645] = {.lex_state = 20},
  [646] = {.lex_state = 0},
  [647] = {.lex_state = 20},
  [648] = {.lex_state = 0},
  [649] = {.lex_state = 20},
  [650] = {.lex_state = 0},
  [651] = {.lex_state = 20},
  [652] = {.lex_state = 20},
  [653] = {.lex_state = 20},
  [654] = {.lex_state = 19},
  [655] = {.lex_state = 0},
  [656] = {.lex_state = 19},
  [657] = {.lex_state = 0},
  [658] = {.lex_state = 20},
  [659] = {.lex_state = 20},
  [660] = {.lex_state = 0},
  [661] = {.lex_state = 444},
  [662] = {.lex_state = 15},
  [663] = {.lex_state = 0},
  [664] = {.lex_state = 0},
  [665] = {.lex_state = 20},
  [666] = {.lex_state = 0},
  [667] = {.lex_state = 0},
  [668] = {.lex_state = 0},
  [669] = {.lex_state = 0},
  [670] = {.lex_state = 0},
  [671] = {.lex_state = 9},
  [672] = {.lex_state = 15},
  [673] = {.lex_state = 0},
  [674] = {.lex_state = 0},
  [675] = {.lex_state = 0},
  [676] = {.lex_state = 0},
  [677] = {.lex_state = 9},
  [678] = {.lex_state = 0},
  [679] = {.lex_state = 0},
  [680] = {.lex_state = 0},
  [681] = {.lex_state = 0},
  [682] = {.lex_state = 0},
  [683] = {.lex_state = 0},
  [684] = {.lex_state = 19},
  [685] = {.lex_state = 0},
  [686] = {.lex_state = 0},
  [687] = {.lex_state = 0},
  [688] = {.lex_state = 0},
  [689] = {.lex_state = 0},
  [690] = {.lex_state = 0},
  [691] = {.lex_state = 0},
  [692] = {.lex_state = 0},
  [693] = {.lex_state = 0},
  [694] = {.lex_state = 0},
  [695] = {.lex_state = 20},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 0},
  [698] = {.lex_state = 0},
  [699] = {.lex_state = 0},
  [700] = {.lex_state = 15},
  [701] = {.lex_state = 0},
  [702] = {.lex_state = 0},
  [703] = {.lex_state = 0},
  [704] = {.lex_state = 0},
  [705] = {.lex_state = 0},
  [706] = {.lex_state = 0},
  [707] = {.lex_state = 0},
  [708] = {.lex_state = 0},
  [709] = {.lex_state = 0},
  [710] = {.lex_state = 0},
  [711] = {.lex_state = 0},
  [712] = {.lex_state = 20},
  [713] = {.lex_state = 15},
  [714] = {.lex_state = 0},
  [715] = {.lex_state = 0},
  [716] = {.lex_state = 0},
  [717] = {.lex_state = 19},
  [718] = {.lex_state = 20},
  [719] = {.lex_state = 0},
  [720] = {.lex_state = 0},
  [721] = {.lex_state = 0},
  [722] = {.lex_state = 17},
  [723] = {.lex_state = 20},
  [724] = {.lex_state = 19},
  [725] = {.lex_state = 0},
  [726] = {.lex_state = 0},
  [727] = {.lex_state = 17},
  [728] = {.lex_state = 0},
  [729] = {.lex_state = 0},
  [730] = {.lex_state = 20},
  [731] = {.lex_state = 0},
  [732] = {.lex_state = 0},
  [733] = {.lex_state = 444},
  [734] = {.lex_state = 20},
  [735] = {.lex_state = 9},
  [736] = {.lex_state = 444},
  [737] = {.lex_state = 20},
  [738] = {.lex_state = 444},
  [739] = {.lex_state = 15},
  [740] = {.lex_state = 35},
  [741] = {.lex_state = 0},
  [742] = {.lex_state = 19},
  [743] = {.lex_state = 15},
  [744] = {.lex_state = 0},
  [745] = {.lex_state = 444},
  [746] = {.lex_state = 35},
  [747] = {.lex_state = 0},
  [748] = {.lex_state = 20},
  [749] = {.lex_state = 0},
  [750] = {.lex_state = 0},
  [751] = {.lex_state = 0},
  [752] = {.lex_state = 0},
  [753] = {.lex_state = 20},
  [754] = {.lex_state = 0},
  [755] = {.lex_state = 20},
  [756] = {.lex_state = 19},
  [757] = {.lex_state = 19},
  [758] = {.lex_state = 19},
  [759] = {.lex_state = 20},
  [760] = {.lex_state = 20},
  [761] = {.lex_state = 0},
  [762] = {.lex_state = 19},
  [763] = {.lex_state = 0},
  [764] = {.lex_state = 0},
  [765] = {.lex_state = 20},
  [766] = {.lex_state = 0},
  [767] = {.lex_state = 20},
  [768] = {.lex_state = 20},
  [769] = {.lex_state = 19},
  [770] = {.lex_state = 20},
  [771] = {.lex_state = 0},
  [772] = {.lex_state = 19},
  [773] = {.lex_state = 19},
  [774] = {.lex_state = 0},
  [775] = {.lex_state = 0},
  [776] = {.lex_state = 0},
  [777] = {.lex_state = 0},
  [778] = {.lex_state = 0},
  [779] = {.lex_state = 0},
  [780] = {.lex_state = 0},
  [781] = {.lex_state = 19},
  [782] = {.lex_state = 0},
  [783] = {.lex_state = 0},
  [784] = {.lex_state = 0},
  [785] = {.lex_state = 20},
  [786] = {.lex_state = 0},
  [787] = {.lex_state = 0},
  [788] = {.lex_state = 20},
  [789] = {.lex_state = 0},
  [790] = {.lex_state = 0},
  [791] = {.lex_state = 19},
  [792] = {.lex_state = 20},
  [793] = {.lex_state = 0},
  [794] = {.lex_state = 20},
  [795] = {.lex_state = 0},
  [796] = {.lex_state = 0},
  [797] = {.lex_state = 0},
  [798] = {.lex_state = 20},
  [799] = {.lex_state = 20},
  [800] = {.lex_state = 0},
  [801] = {.lex_state = 0},
  [802] = {.lex_state = 20},
  [803] = {.lex_state = 20},
  [804] = {.lex_state = 35},
  [805] = {.lex_state = 0},
  [806] = {.lex_state = 20},
  [807] = {.lex_state = 19},
  [808] = {.lex_state = 20},
  [809] = {.lex_state = 0},
  [810] = {.lex_state = 20},
  [811] = {.lex_state = 0},
  [812] = {.lex_state = 20},
  [813] = {.lex_state = 20},
  [814] = {.lex_state = 20},
  [815] = {.lex_state = 0},
  [816] = {.lex_state = 19},
  [817] = {.lex_state = 0},
  [818] = {.lex_state = 9},
  [819] = {.lex_state = 0},
  [820] = {.lex_state = 20},
  [821] = {.lex_state = 20},
  [822] = {.lex_state = 0},
  [823] = {.lex_state = 0},
  [824] = {.lex_state = 20},
  [825] = {.lex_state = 0},
  [826] = {.lex_state = 20},
  [827] = {.lex_state = 20},
  [828] = {.lex_state = 20},
  [829] = {.lex_state = 0},
  [830] = {.lex_state = 0},
  [831] = {.lex_state = 19},
  [832] = {.lex_state = 0},
  [833] = {.lex_state = 0},
  [834] = {.lex_state = 0},
  [835] = {.lex_state = 0},
  [836] = {.lex_state = 0},
  [837] = {.lex_state = 0},
  [838] = {.lex_state = 0},
  [839] = {.lex_state = 0},
  [840] = {.lex_state = 0},
  [841] = {.lex_state = 0},
  [842] = {.lex_state = 0},
  [843] = {.lex_state = 0},
  [844] = {.lex_state = 0},
  [845] = {.lex_state = 0},
  [846] = {.lex_state = 0},
  [847] = {.lex_state = 0},
  [848] = {.lex_state = 0},
  [849] = {.lex_state = 0},
  [850] = {.lex_state = 15},
  [851] = {.lex_state = 0},
  [852] = {.lex_state = 0},
  [853] = {.lex_state = 15},
  [854] = {.lex_state = 0},
  [855] = {.lex_state = 0},
  [856] = {.lex_state = 0},
  [857] = {.lex_state = 0},
  [858] = {.lex_state = 0},
  [859] = {.lex_state = 0},
  [860] = {.lex_state = 0},
  [861] = {.lex_state = 0},
  [862] = {.lex_state = 0},
  [863] = {.lex_state = 444},
  [864] = {.lex_state = 0},
  [865] = {.lex_state = 0},
  [866] = {.lex_state = 9},
  [867] = {.lex_state = 0},
  [868] = {.lex_state = 0},
  [869] = {.lex_state = 0},
  [870] = {.lex_state = 9},
  [871] = {.lex_state = 0},
  [872] = {.lex_state = 0},
  [873] = {.lex_state = 0},
  [874] = {.lex_state = 0},
  [875] = {.lex_state = 0},
  [876] = {.lex_state = 0},
  [877] = {.lex_state = 0},
  [878] = {.lex_state = 0},
  [879] = {.lex_state = 0},
  [880] = {.lex_state = 0},
  [881] = {.lex_state = 20},
  [882] = {.lex_state = 0},
  [883] = {.lex_state = 0},
  [884] = {.lex_state = 0},
  [885] = {.lex_state = 0},
  [886] = {.lex_state = 0},
  [887] = {.lex_state = 0},
  [888] = {.lex_state = 0},
  [889] = {.lex_state = 0},
  [890] = {.lex_state = 15},
  [891] = {.lex_state = 444},
  [892] = {.lex_state = 0},
  [893] = {.lex_state = 0},
  [894] = {.lex_state = 9},
  [895] = {.lex_state = 0},
  [896] = {.lex_state = 0},
  [897] = {.lex_state = 0},
  [898] = {.lex_state = 0},
  [899] = {.lex_state = 0},
  [900] = {.lex_state = 15},
  [901] = {.lex_state = 0},
  [902] = {.lex_state = 15},
  [903] = {.lex_state = 0},
  [904] = {.lex_state = 15},
  [905] = {.lex_state = 1},
  [906] = {.lex_state = 444},
  [907] = {.lex_state = 0},
  [908] = {.lex_state = 0},
  [909] = {.lex_state = 0},
  [910] = {.lex_state = 444},
  [911] = {.lex_state = 0},
  [912] = {.lex_state = 0},
  [913] = {.lex_state = 9},
  [914] = {.lex_state = 0},
  [915] = {.lex_state = 0},
  [916] = {.lex_state = 0},
  [917] = {.lex_state = 0},
  [918] = {.lex_state = 0},
  [919] = {.lex_state = 0},
  [920] = {.lex_state = 0},
  [921] = {.lex_state = 0},
  [922] = {.lex_state = 0},
  [923] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_export] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_component] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_property] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_LT_EQ_GT] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_out] = ACTIONS(1),
    [anon_sym_transitions] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_when] = ACTIONS(1),
    [anon_sym_animate] = ACTIONS(1),
    [anon_sym_delay] = ACTIONS(1),
    [anon_sym_duration] = ACTIONS(1),
    [anon_sym_iteration_DASHcount] = ACTIONS(1),
    [anon_sym_direction] = ACTIONS(1),
    [anon_sym_easing] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_ATtr] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [sym_logical_and] = ACTIONS(1),
    [sym_logical_or] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_callback] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_pure] = ACTIONS(1),
    [anon_sym_public] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_changed] = ACTIONS(1),
    [anon_sym_ATimage_DASHurl] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_BSLASH] = ACTIONS(1),
    [aux_sym_escape_sequence_token1] = ACTIONS(1),
    [anon_sym_n] = ACTIONS(1),
    [anon_sym_float] = ACTIONS(1),
    [anon_sym_bool] = ACTIONS(1),
    [anon_sym_color] = ACTIONS(1),
    [anon_sym_brush] = ACTIONS(1),
    [anon_sym_physical_DASHlength] = ACTIONS(1),
    [anon_sym_length] = ACTIONS(1),
    [anon_sym_angle] = ACTIONS(1),
    [anon_sym_percent] = ACTIONS(1),
    [anon_sym_image] = ACTIONS(1),
    [anon_sym_relative_DASHfont_DASHsize] = ACTIONS(1),
    [anon_sym_linear] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(1),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(1),
    [anon_sym_ease] = ACTIONS(1),
    [anon_sym_ease_DASHin] = ACTIONS(1),
    [anon_sym_ease_DASHout] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(1),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(1),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(1),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(1),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(1),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(1),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(1),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(1),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(1),
    [anon_sym_cubic_DASHbezier] = ACTIONS(1),
    [sym_children_identifier] = ACTIONS(1),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(1),
    [anon_sym_ATlinear_gradient] = ACTIONS(1),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(1),
    [anon_sym_ATradial_gradient] = ACTIONS(1),
    [anon_sym_circle] = ACTIONS(1),
    [anon_sym_parent] = ACTIONS(1),
    [anon_sym_root] = ACTIONS(1),
    [anon_sym_self] = ACTIONS(1),
    [sym__int_number] = ACTIONS(1),
    [sym__float_number] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [sym_color_value] = ACTIONS(1),
    [anon_sym_phx] = ACTIONS(1),
    [aux_sym_length_value_token1] = ACTIONS(1),
    [aux_sym_duration_value_token1] = ACTIONS(1),
    [aux_sym_angle_value_token1] = ACTIONS(1),
    [anon_sym_PERCENT2] = ACTIONS(1),
    [anon_sym_rem] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_sourcefile] = STATE(862),
    [sym__definition] = STATE(504),
    [sym__local_type] = STATE(504),
    [sym__exported_type] = STATE(504),
    [sym_import_statement] = STATE(504),
    [sym_component_definition] = STATE(504),
    [sym_global_definition] = STATE(504),
    [sym_struct_definition] = STATE(504),
    [sym_enum_definition] = STATE(504),
    [sym_user_type_identifier] = STATE(886),
    [aux_sym_sourcefile_repeat1] = STATE(504),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_export] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_component] = ACTIONS(11),
    [anon_sym_global] = ACTIONS(13),
    [anon_sym_struct] = ACTIONS(15),
    [anon_sym_enum] = ACTIONS(17),
    [sym__identifier] = ACTIONS(19),
    [sym_comment] = ACTIONS(3),
  },
  [2] = {
    [sym__imperative_block_statement] = STATE(7),
    [sym_binding] = STATE(7),
    [sym_anon_struct_block] = STATE(205),
    [sym_if_expr] = STATE(244),
    [sym__assignment_setup] = STATE(29),
    [sym_assignment_block] = STATE(244),
    [sym_assignment_expr] = STATE(244),
    [sym_expression] = STATE(151),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_callback_event] = STATE(7),
    [sym_function_call] = STATE(226),
    [sym_gradient_call] = STATE(206),
    [sym_image_call] = STATE(206),
    [sym_unary_prec_operator] = STATE(104),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(213),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [aux_sym_imperative_block_repeat1] = STATE(7),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_COMMA] = ACTIONS(23),
    [anon_sym_RBRACE] = ACTIONS(25),
    [anon_sym_return] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [3] = {
    [sym__imperative_block_statement] = STATE(7),
    [sym_binding] = STATE(7),
    [sym_anon_struct_block] = STATE(205),
    [sym_if_expr] = STATE(244),
    [sym__assignment_setup] = STATE(29),
    [sym_assignment_block] = STATE(244),
    [sym_assignment_expr] = STATE(244),
    [sym_expression] = STATE(151),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_callback_event] = STATE(7),
    [sym_function_call] = STATE(226),
    [sym_gradient_call] = STATE(206),
    [sym_image_call] = STATE(206),
    [sym_unary_prec_operator] = STATE(104),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(213),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [aux_sym_imperative_block_repeat1] = STATE(7),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_COMMA] = ACTIONS(23),
    [anon_sym_RBRACE] = ACTIONS(63),
    [anon_sym_return] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [4] = {
    [sym__imperative_block_statement] = STATE(14),
    [sym_binding] = STATE(14),
    [sym_anon_struct_block] = STATE(205),
    [sym_if_expr] = STATE(244),
    [sym__assignment_setup] = STATE(29),
    [sym_assignment_block] = STATE(244),
    [sym_assignment_expr] = STATE(244),
    [sym_expression] = STATE(151),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_callback_event] = STATE(14),
    [sym_function_call] = STATE(226),
    [sym_gradient_call] = STATE(206),
    [sym_image_call] = STATE(206),
    [sym_unary_prec_operator] = STATE(104),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(213),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [aux_sym_imperative_block_repeat1] = STATE(14),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_COMMA] = ACTIONS(23),
    [anon_sym_RBRACE] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [5] = {
    [sym__imperative_block_statement] = STATE(15),
    [sym_binding] = STATE(15),
    [sym_anon_struct_block] = STATE(205),
    [sym_if_expr] = STATE(244),
    [sym__assignment_setup] = STATE(29),
    [sym_assignment_block] = STATE(244),
    [sym_assignment_expr] = STATE(244),
    [sym_expression] = STATE(151),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_callback_event] = STATE(15),
    [sym_function_call] = STATE(226),
    [sym_gradient_call] = STATE(206),
    [sym_image_call] = STATE(206),
    [sym_unary_prec_operator] = STATE(104),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(213),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [aux_sym_imperative_block_repeat1] = STATE(15),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_COMMA] = ACTIONS(23),
    [anon_sym_RBRACE] = ACTIONS(67),
    [anon_sym_return] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [6] = {
    [sym__imperative_block_statement] = STATE(15),
    [sym_binding] = STATE(15),
    [sym_anon_struct_block] = STATE(205),
    [sym_if_expr] = STATE(244),
    [sym__assignment_setup] = STATE(29),
    [sym_assignment_block] = STATE(244),
    [sym_assignment_expr] = STATE(244),
    [sym_expression] = STATE(151),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_callback_event] = STATE(15),
    [sym_function_call] = STATE(226),
    [sym_gradient_call] = STATE(206),
    [sym_image_call] = STATE(206),
    [sym_unary_prec_operator] = STATE(104),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(213),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [aux_sym_imperative_block_repeat1] = STATE(15),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_COMMA] = ACTIONS(23),
    [anon_sym_RBRACE] = ACTIONS(69),
    [anon_sym_return] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [7] = {
    [sym__imperative_block_statement] = STATE(8),
    [sym_binding] = STATE(8),
    [sym_anon_struct_block] = STATE(205),
    [sym_if_expr] = STATE(244),
    [sym__assignment_setup] = STATE(29),
    [sym_assignment_block] = STATE(244),
    [sym_assignment_expr] = STATE(244),
    [sym_expression] = STATE(151),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_callback_event] = STATE(8),
    [sym_function_call] = STATE(226),
    [sym_gradient_call] = STATE(206),
    [sym_image_call] = STATE(206),
    [sym_unary_prec_operator] = STATE(104),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(211),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [aux_sym_imperative_block_repeat1] = STATE(8),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_RBRACE] = ACTIONS(71),
    [anon_sym_return] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [8] = {
    [sym__imperative_block_statement] = STATE(8),
    [sym_binding] = STATE(8),
    [sym_anon_struct_block] = STATE(205),
    [sym_if_expr] = STATE(244),
    [sym__assignment_setup] = STATE(29),
    [sym_assignment_block] = STATE(244),
    [sym_assignment_expr] = STATE(244),
    [sym_expression] = STATE(151),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_callback_event] = STATE(8),
    [sym_function_call] = STATE(226),
    [sym_gradient_call] = STATE(206),
    [sym_image_call] = STATE(206),
    [sym_unary_prec_operator] = STATE(104),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(211),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [aux_sym_imperative_block_repeat1] = STATE(8),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_RBRACE] = ACTIONS(76),
    [anon_sym_return] = ACTIONS(78),
    [anon_sym_LBRACK] = ACTIONS(81),
    [anon_sym_if] = ACTIONS(84),
    [anon_sym_LPAREN] = ACTIONS(87),
    [anon_sym_ATtr] = ACTIONS(90),
    [anon_sym_ATimage_DASHurl] = ACTIONS(93),
    [anon_sym_BANG] = ACTIONS(96),
    [anon_sym_DASH] = ACTIONS(96),
    [anon_sym_PLUS] = ACTIONS(96),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym__identifier] = ACTIONS(102),
    [anon_sym_linear] = ACTIONS(105),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(105),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(105),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(105),
    [anon_sym_ease] = ACTIONS(105),
    [anon_sym_ease_DASHin] = ACTIONS(105),
    [anon_sym_ease_DASHout] = ACTIONS(105),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(105),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(105),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(105),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(105),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(105),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(105),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(105),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(105),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(105),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(105),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(105),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(105),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(105),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(105),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(105),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(105),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(105),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(105),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(105),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(105),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(105),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(105),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(105),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(105),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(105),
    [anon_sym_cubic_DASHbezier] = ACTIONS(108),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(111),
    [anon_sym_ATlinear_gradient] = ACTIONS(111),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(114),
    [anon_sym_ATradial_gradient] = ACTIONS(114),
    [anon_sym_parent] = ACTIONS(117),
    [anon_sym_root] = ACTIONS(117),
    [anon_sym_self] = ACTIONS(117),
    [sym__int_number] = ACTIONS(120),
    [sym__float_number] = ACTIONS(123),
    [anon_sym_true] = ACTIONS(126),
    [anon_sym_false] = ACTIONS(126),
    [sym_color_value] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
  },
  [9] = {
    [sym__imperative_block_statement] = STATE(7),
    [sym_binding] = STATE(7),
    [sym_anon_struct_block] = STATE(205),
    [sym_if_expr] = STATE(244),
    [sym__assignment_setup] = STATE(29),
    [sym_assignment_block] = STATE(244),
    [sym_assignment_expr] = STATE(244),
    [sym_expression] = STATE(151),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_callback_event] = STATE(7),
    [sym_function_call] = STATE(226),
    [sym_gradient_call] = STATE(206),
    [sym_image_call] = STATE(206),
    [sym_unary_prec_operator] = STATE(104),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(211),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [aux_sym_imperative_block_repeat1] = STATE(7),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_RBRACE] = ACTIONS(132),
    [anon_sym_return] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [10] = {
    [sym__imperative_block_statement] = STATE(14),
    [sym_binding] = STATE(14),
    [sym_anon_struct_block] = STATE(205),
    [sym_if_expr] = STATE(244),
    [sym__assignment_setup] = STATE(29),
    [sym_assignment_block] = STATE(244),
    [sym_assignment_expr] = STATE(244),
    [sym_expression] = STATE(151),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_callback_event] = STATE(14),
    [sym_function_call] = STATE(226),
    [sym_gradient_call] = STATE(206),
    [sym_image_call] = STATE(206),
    [sym_unary_prec_operator] = STATE(104),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(211),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [aux_sym_imperative_block_repeat1] = STATE(14),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_RBRACE] = ACTIONS(134),
    [anon_sym_return] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [11] = {
    [sym__imperative_block_statement] = STATE(15),
    [sym_binding] = STATE(15),
    [sym_anon_struct_block] = STATE(205),
    [sym_if_expr] = STATE(244),
    [sym__assignment_setup] = STATE(29),
    [sym_assignment_block] = STATE(244),
    [sym_assignment_expr] = STATE(244),
    [sym_expression] = STATE(151),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_callback_event] = STATE(15),
    [sym_function_call] = STATE(226),
    [sym_gradient_call] = STATE(206),
    [sym_image_call] = STATE(206),
    [sym_unary_prec_operator] = STATE(104),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(211),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [aux_sym_imperative_block_repeat1] = STATE(15),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_RBRACE] = ACTIONS(136),
    [anon_sym_return] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [12] = {
    [sym__imperative_block_statement] = STATE(8),
    [sym_binding] = STATE(8),
    [sym_anon_struct_block] = STATE(205),
    [sym_if_expr] = STATE(244),
    [sym__assignment_setup] = STATE(29),
    [sym_assignment_block] = STATE(244),
    [sym_assignment_expr] = STATE(244),
    [sym_expression] = STATE(151),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_callback_event] = STATE(8),
    [sym_function_call] = STATE(226),
    [sym_gradient_call] = STATE(206),
    [sym_image_call] = STATE(206),
    [sym_unary_prec_operator] = STATE(104),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(211),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [aux_sym_imperative_block_repeat1] = STATE(8),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_RBRACE] = ACTIONS(138),
    [anon_sym_return] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [13] = {
    [sym__imperative_block_statement] = STATE(12),
    [sym_binding] = STATE(12),
    [sym_anon_struct_block] = STATE(205),
    [sym_if_expr] = STATE(244),
    [sym__assignment_setup] = STATE(29),
    [sym_assignment_block] = STATE(244),
    [sym_assignment_expr] = STATE(244),
    [sym_expression] = STATE(151),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_callback_event] = STATE(12),
    [sym_function_call] = STATE(226),
    [sym_gradient_call] = STATE(206),
    [sym_image_call] = STATE(206),
    [sym_unary_prec_operator] = STATE(104),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(211),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [aux_sym_imperative_block_repeat1] = STATE(12),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_RBRACE] = ACTIONS(140),
    [anon_sym_return] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [14] = {
    [sym__imperative_block_statement] = STATE(8),
    [sym_binding] = STATE(8),
    [sym_anon_struct_block] = STATE(205),
    [sym_if_expr] = STATE(244),
    [sym__assignment_setup] = STATE(29),
    [sym_assignment_block] = STATE(244),
    [sym_assignment_expr] = STATE(244),
    [sym_expression] = STATE(151),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_callback_event] = STATE(8),
    [sym_function_call] = STATE(226),
    [sym_gradient_call] = STATE(206),
    [sym_image_call] = STATE(206),
    [sym_unary_prec_operator] = STATE(104),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(211),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [aux_sym_imperative_block_repeat1] = STATE(8),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_RBRACE] = ACTIONS(142),
    [anon_sym_return] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [15] = {
    [sym__imperative_block_statement] = STATE(8),
    [sym_binding] = STATE(8),
    [sym_anon_struct_block] = STATE(205),
    [sym_if_expr] = STATE(244),
    [sym__assignment_setup] = STATE(29),
    [sym_assignment_block] = STATE(244),
    [sym_assignment_expr] = STATE(244),
    [sym_expression] = STATE(151),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_callback_event] = STATE(8),
    [sym_function_call] = STATE(226),
    [sym_gradient_call] = STATE(206),
    [sym_image_call] = STATE(206),
    [sym_unary_prec_operator] = STATE(104),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(211),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [aux_sym_imperative_block_repeat1] = STATE(8),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_RBRACE] = ACTIONS(144),
    [anon_sym_return] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [16] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_in_out_transition] = STATE(17),
    [sym__assignment_setup] = STATE(34),
    [sym_assignment_block] = STATE(17),
    [sym_assignment_expr] = STATE(775),
    [sym_expression] = STATE(354),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [aux_sym_states_definition_repeat1] = STATE(17),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_RBRACE] = ACTIONS(148),
    [anon_sym_in] = ACTIONS(150),
    [anon_sym_out] = ACTIONS(150),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [17] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_in_out_transition] = STATE(18),
    [sym__assignment_setup] = STATE(34),
    [sym_assignment_block] = STATE(18),
    [sym_assignment_expr] = STATE(793),
    [sym_expression] = STATE(354),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [aux_sym_states_definition_repeat1] = STATE(18),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_RBRACE] = ACTIONS(178),
    [anon_sym_in] = ACTIONS(150),
    [anon_sym_out] = ACTIONS(150),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [18] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_in_out_transition] = STATE(18),
    [sym__assignment_setup] = STATE(51),
    [sym_assignment_block] = STATE(18),
    [sym_assignment_expr] = STATE(838),
    [sym_expression] = STATE(354),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [aux_sym_states_definition_repeat1] = STATE(18),
    [anon_sym_LBRACE] = ACTIONS(180),
    [anon_sym_RBRACE] = ACTIONS(183),
    [anon_sym_in] = ACTIONS(185),
    [anon_sym_out] = ACTIONS(185),
    [anon_sym_LBRACK] = ACTIONS(188),
    [anon_sym_LPAREN] = ACTIONS(191),
    [anon_sym_ATtr] = ACTIONS(194),
    [anon_sym_ATimage_DASHurl] = ACTIONS(197),
    [anon_sym_BANG] = ACTIONS(200),
    [anon_sym_DASH] = ACTIONS(200),
    [anon_sym_PLUS] = ACTIONS(200),
    [anon_sym_DQUOTE] = ACTIONS(203),
    [sym__identifier] = ACTIONS(206),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(209),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(209),
    [anon_sym_ease] = ACTIONS(209),
    [anon_sym_ease_DASHin] = ACTIONS(209),
    [anon_sym_ease_DASHout] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(209),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(209),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(209),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(209),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(209),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(209),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(209),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(209),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(209),
    [anon_sym_cubic_DASHbezier] = ACTIONS(212),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(215),
    [anon_sym_ATlinear_gradient] = ACTIONS(215),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(218),
    [anon_sym_ATradial_gradient] = ACTIONS(218),
    [anon_sym_parent] = ACTIONS(221),
    [anon_sym_root] = ACTIONS(221),
    [anon_sym_self] = ACTIONS(221),
    [sym__int_number] = ACTIONS(224),
    [sym__float_number] = ACTIONS(227),
    [anon_sym_true] = ACTIONS(230),
    [anon_sym_false] = ACTIONS(230),
    [sym_color_value] = ACTIONS(233),
    [sym_comment] = ACTIONS(3),
  },
  [19] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(380),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_gradient_color] = STATE(835),
    [sym_image_call] = STATE(206),
    [sym_argument] = STATE(597),
    [sym_unary_prec_operator] = STATE(111),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_RPAREN] = ACTIONS(236),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [20] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(380),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_gradient_color] = STATE(835),
    [sym_image_call] = STATE(206),
    [sym_argument] = STATE(597),
    [sym_unary_prec_operator] = STATE(111),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_RPAREN] = ACTIONS(242),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [21] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(380),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_gradient_color] = STATE(835),
    [sym_image_call] = STATE(206),
    [sym_argument] = STATE(597),
    [sym_unary_prec_operator] = STATE(111),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_RPAREN] = ACTIONS(244),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [22] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(380),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_gradient_color] = STATE(835),
    [sym_image_call] = STATE(206),
    [sym_argument] = STATE(597),
    [sym_unary_prec_operator] = STATE(111),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_RPAREN] = ACTIONS(246),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [23] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(380),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_gradient_color] = STATE(835),
    [sym_image_call] = STATE(206),
    [sym_argument] = STATE(597),
    [sym_unary_prec_operator] = STATE(111),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_RPAREN] = ACTIONS(248),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [24] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(380),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_gradient_color] = STATE(835),
    [sym_image_call] = STATE(206),
    [sym_argument] = STATE(597),
    [sym_unary_prec_operator] = STATE(111),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_RPAREN] = ACTIONS(250),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [25] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(380),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_gradient_color] = STATE(835),
    [sym_image_call] = STATE(206),
    [sym_argument] = STATE(597),
    [sym_unary_prec_operator] = STATE(111),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_RPAREN] = ACTIONS(252),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [26] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(380),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_gradient_color] = STATE(835),
    [sym_image_call] = STATE(206),
    [sym_argument] = STATE(597),
    [sym_unary_prec_operator] = STATE(111),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_RPAREN] = ACTIONS(254),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [27] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(380),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_gradient_color] = STATE(909),
    [sym_image_call] = STATE(206),
    [sym_argument] = STATE(597),
    [sym_unary_prec_operator] = STATE(111),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [28] = {
    [sym_imperative_block] = STATE(441),
    [sym__binding] = STATE(484),
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(442),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(256),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [29] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_block] = STATE(241),
    [sym__assignment_value_block] = STATE(242),
    [sym_expression] = STATE(227),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_image_call] = STATE(206),
    [sym_unary_prec_operator] = STATE(104),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(258),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [30] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(408),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_argument] = STATE(783),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(260),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [31] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(380),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_gradient_color] = STATE(835),
    [sym_image_call] = STATE(206),
    [sym_argument] = STATE(597),
    [sym_unary_prec_operator] = STATE(111),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [32] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(380),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_gradient_color] = STATE(901),
    [sym_image_call] = STATE(206),
    [sym_argument] = STATE(597),
    [sym_unary_prec_operator] = STATE(111),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [33] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(380),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_gradient_color] = STATE(908),
    [sym_image_call] = STATE(206),
    [sym_argument] = STATE(597),
    [sym_unary_prec_operator] = STATE(111),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [34] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_block] = STATE(243),
    [sym__assignment_value_block] = STATE(245),
    [sym_expression] = STATE(409),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(262),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [35] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(394),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_COMMA] = ACTIONS(264),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_RBRACK] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [36] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(408),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_argument] = STATE(663),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(268),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [37] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(380),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_gradient_color] = STATE(912),
    [sym_image_call] = STATE(206),
    [sym_argument] = STATE(597),
    [sym_unary_prec_operator] = STATE(111),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [38] = {
    [sym_imperative_block] = STATE(246),
    [sym__binding] = STATE(253),
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(439),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(270),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [39] = {
    [sym_imperative_block] = STATE(519),
    [sym__binding] = STATE(521),
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(452),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(272),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [40] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(400),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_COMMA] = ACTIONS(274),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_RBRACK] = ACTIONS(276),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [41] = {
    [sym_imperative_block] = STATE(519),
    [sym__binding] = STATE(534),
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(452),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(272),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [42] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(408),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_argument] = STATE(783),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(278),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [43] = {
    [sym_imperative_block] = STATE(441),
    [sym__binding] = STATE(488),
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(442),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(256),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [44] = {
    [sym_imperative_block] = STATE(246),
    [sym__binding] = STATE(253),
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(390),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [45] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(408),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_argument] = STATE(783),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(282),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [46] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(380),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_gradient_color] = STATE(664),
    [sym_image_call] = STATE(206),
    [sym_argument] = STATE(597),
    [sym_unary_prec_operator] = STATE(111),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [47] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(380),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_gradient_color] = STATE(666),
    [sym_image_call] = STATE(206),
    [sym_argument] = STATE(597),
    [sym_unary_prec_operator] = STATE(111),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [48] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(408),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_argument] = STATE(668),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(284),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [49] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(380),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_gradient_color] = STATE(673),
    [sym_image_call] = STATE(206),
    [sym_argument] = STATE(597),
    [sym_unary_prec_operator] = STATE(111),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [50] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(380),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_gradient_color] = STATE(674),
    [sym_image_call] = STATE(206),
    [sym_argument] = STATE(597),
    [sym_unary_prec_operator] = STATE(111),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [51] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_block] = STATE(243),
    [sym__assignment_value_block] = STATE(245),
    [sym_expression] = STATE(409),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(286),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [52] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(408),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_argument] = STATE(783),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(288),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [53] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(399),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_RBRACK] = ACTIONS(290),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [54] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(399),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(292),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [55] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(399),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(294),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [56] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(399),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(296),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [57] = {
    [sym_imperative_block] = STATE(436),
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(387),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [58] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(399),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(300),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [59] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(399),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(302),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [60] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(448),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_SEMI] = ACTIONS(304),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [61] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(399),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_RBRACK] = ACTIONS(306),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [62] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(399),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(308),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [63] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(399),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(310),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [64] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(408),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_argument] = STATE(783),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [65] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(399),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(312),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [66] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(399),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(314),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [67] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(399),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(316),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [68] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(399),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(318),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [69] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(399),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(320),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [70] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(399),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(322),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [71] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(399),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(324),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [72] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(399),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_RBRACK] = ACTIONS(326),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [73] = {
    [sym_imperative_block] = STATE(436),
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(388),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [74] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(399),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(328),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [75] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(399),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_RBRACK] = ACTIONS(330),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [76] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(399),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(332),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [77] = {
    [sym_imperative_block] = STATE(436),
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(440),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(256),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [78] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_for_range] = STATE(916),
    [sym_expression] = STATE(421),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(510),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [79] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(157),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_image_call] = STATE(206),
    [sym_unary_prec_operator] = STATE(104),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [80] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(415),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [81] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(423),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [82] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(399),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [83] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(449),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [84] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(392),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [85] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(405),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [86] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(290),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [87] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(286),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [88] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(291),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [89] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(418),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [90] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(406),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [91] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(292),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [92] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(285),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [93] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(411),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [94] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(393),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [95] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(284),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [96] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(419),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [97] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(420),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [98] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(422),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [99] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(403),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [100] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(410),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [101] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(424),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [102] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(417),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [103] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(398),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [104] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(154),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_image_call] = STATE(206),
    [sym_unary_prec_operator] = STATE(104),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [105] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(156),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_image_call] = STATE(206),
    [sym_unary_prec_operator] = STATE(104),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [106] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(158),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_image_call] = STATE(206),
    [sym_unary_prec_operator] = STATE(104),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [107] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(159),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_image_call] = STATE(206),
    [sym_unary_prec_operator] = STATE(104),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [108] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(160),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_image_call] = STATE(206),
    [sym_unary_prec_operator] = STATE(104),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [109] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(163),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_image_call] = STATE(206),
    [sym_unary_prec_operator] = STATE(104),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [110] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(165),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_image_call] = STATE(206),
    [sym_unary_prec_operator] = STATE(104),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [111] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(379),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_image_call] = STATE(206),
    [sym_unary_prec_operator] = STATE(111),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [112] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(389),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_image_call] = STATE(206),
    [sym_unary_prec_operator] = STATE(111),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [113] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(382),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_image_call] = STATE(206),
    [sym_unary_prec_operator] = STATE(111),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [114] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(386),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_image_call] = STATE(206),
    [sym_unary_prec_operator] = STATE(111),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [115] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(381),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_image_call] = STATE(206),
    [sym_unary_prec_operator] = STATE(111),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [116] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(384),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_image_call] = STATE(206),
    [sym_unary_prec_operator] = STATE(111),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [117] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(383),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_image_call] = STATE(206),
    [sym_unary_prec_operator] = STATE(111),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [118] = {
    [sym_anon_struct_block] = STATE(205),
    [sym_expression] = STATE(385),
    [sym_parens_op] = STATE(206),
    [sym_index_op] = STATE(206),
    [sym_tr] = STATE(206),
    [sym_member_access] = STATE(206),
    [sym_unary_expression] = STATE(206),
    [sym_binary_expression] = STATE(206),
    [sym__add_binary_expression] = STATE(207),
    [sym__comparison_binary_expression] = STATE(208),
    [sym__logic_binary_expression] = STATE(209),
    [sym__mult_binary_expression] = STATE(210),
    [sym_ternary_expression] = STATE(206),
    [sym_function_call] = STATE(206),
    [sym_gradient_call] = STATE(206),
    [sym_image_call] = STATE(206),
    [sym_unary_prec_operator] = STATE(111),
    [sym__string] = STATE(172),
    [sym_simple_identifier] = STATE(152),
    [sym_easing_kind_identifier] = STATE(205),
    [sym_value_list] = STATE(205),
    [sym_value] = STATE(206),
    [sym_linear_gradient_identifier] = STATE(921),
    [sym_radial_gradient_identifier] = STATE(922),
    [sym_reference_identifier] = STATE(206),
    [sym__number] = STATE(602),
    [sym_int_value] = STATE(205),
    [sym_float_value] = STATE(205),
    [sym_bool_value] = STATE(205),
    [sym_string_value] = STATE(205),
    [sym_physical_length_value] = STATE(205),
    [sym_length_value] = STATE(205),
    [sym_duration_value] = STATE(205),
    [sym_angle_value] = STATE(205),
    [sym_percent_value] = STATE(205),
    [sym_relative_font_size_value] = STATE(205),
    [sym__basic_value] = STATE(205),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [119] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(443),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [120] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(445),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [121] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(404),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [122] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(437),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [123] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(446),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [124] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(451),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [125] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(391),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [126] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(288),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [127] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(282),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [128] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(434),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [129] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(412),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [130] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(425),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [131] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(426),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [132] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(427),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [133] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(428),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [134] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(429),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [135] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(450),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [136] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(430),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [137] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(395),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [138] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(432),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [139] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(433),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [140] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(396),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [141] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(435),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [142] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(397),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [143] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(413),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [144] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(414),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [145] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(401),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [146] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(402),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [147] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(438),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [148] = {
    [sym_anon_struct_block] = STATE(336),
    [sym_expression] = STATE(416),
    [sym_parens_op] = STATE(301),
    [sym_index_op] = STATE(301),
    [sym_tr] = STATE(301),
    [sym_member_access] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym__add_binary_expression] = STATE(302),
    [sym__comparison_binary_expression] = STATE(303),
    [sym__logic_binary_expression] = STATE(304),
    [sym__mult_binary_expression] = STATE(305),
    [sym_ternary_expression] = STATE(301),
    [sym_function_call] = STATE(301),
    [sym_gradient_call] = STATE(301),
    [sym_image_call] = STATE(301),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(289),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(336),
    [sym_value_list] = STATE(336),
    [sym_value] = STATE(301),
    [sym_linear_gradient_identifier] = STATE(845),
    [sym_radial_gradient_identifier] = STATE(846),
    [sym_reference_identifier] = STATE(301),
    [sym__number] = STATE(593),
    [sym_int_value] = STATE(336),
    [sym_float_value] = STATE(336),
    [sym_bool_value] = STATE(336),
    [sym_string_value] = STATE(336),
    [sym_physical_length_value] = STATE(336),
    [sym_length_value] = STATE(336),
    [sym_duration_value] = STATE(336),
    [sym_angle_value] = STATE(336),
    [sym_percent_value] = STATE(336),
    [sym_relative_font_size_value] = STATE(336),
    [sym__basic_value] = STATE(336),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [149] = {
    [anon_sym_LBRACE] = ACTIONS(338),
    [anon_sym_RBRACE] = ACTIONS(338),
    [anon_sym_SEMI] = ACTIONS(338),
    [anon_sym_LT] = ACTIONS(340),
    [anon_sym_GT] = ACTIONS(340),
    [anon_sym_return] = ACTIONS(340),
    [anon_sym_COLON] = ACTIONS(338),
    [anon_sym_LBRACK] = ACTIONS(338),
    [anon_sym_if] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(338),
    [anon_sym_ATtr] = ACTIONS(338),
    [anon_sym_DOT] = ACTIONS(340),
    [sym_logical_and] = ACTIONS(338),
    [sym_logical_or] = ACTIONS(338),
    [anon_sym_QMARK] = ACTIONS(338),
    [anon_sym_ATimage_DASHurl] = ACTIONS(338),
    [anon_sym_BANG] = ACTIONS(340),
    [anon_sym_DASH] = ACTIONS(340),
    [anon_sym_PLUS] = ACTIONS(340),
    [anon_sym_STAR] = ACTIONS(340),
    [anon_sym_SLASH] = ACTIONS(340),
    [anon_sym_GT_EQ] = ACTIONS(338),
    [anon_sym_LT_EQ] = ACTIONS(338),
    [anon_sym_EQ_EQ] = ACTIONS(338),
    [anon_sym_BANG_EQ] = ACTIONS(338),
    [anon_sym_EQ] = ACTIONS(340),
    [anon_sym_PLUS_EQ] = ACTIONS(338),
    [anon_sym_DASH_EQ] = ACTIONS(338),
    [anon_sym_STAR_EQ] = ACTIONS(338),
    [anon_sym_SLASH_EQ] = ACTIONS(338),
    [anon_sym_DQUOTE] = ACTIONS(338),
    [sym__identifier] = ACTIONS(340),
    [anon_sym_linear] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(340),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(340),
    [anon_sym_ease] = ACTIONS(340),
    [anon_sym_ease_DASHin] = ACTIONS(340),
    [anon_sym_ease_DASHout] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(340),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(340),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(340),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(340),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(340),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(340),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(340),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(340),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(340),
    [anon_sym_cubic_DASHbezier] = ACTIONS(340),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(338),
    [anon_sym_ATlinear_gradient] = ACTIONS(338),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(338),
    [anon_sym_ATradial_gradient] = ACTIONS(338),
    [anon_sym_parent] = ACTIONS(340),
    [anon_sym_root] = ACTIONS(340),
    [anon_sym_self] = ACTIONS(340),
    [sym__int_number] = ACTIONS(340),
    [sym__float_number] = ACTIONS(338),
    [anon_sym_true] = ACTIONS(340),
    [anon_sym_false] = ACTIONS(340),
    [sym_color_value] = ACTIONS(338),
    [anon_sym_phx] = ACTIONS(342),
    [aux_sym_length_value_token1] = ACTIONS(342),
    [aux_sym_duration_value_token1] = ACTIONS(342),
    [aux_sym_angle_value_token1] = ACTIONS(342),
    [anon_sym_PERCENT2] = ACTIONS(344),
    [anon_sym_rem] = ACTIONS(342),
    [sym_comment] = ACTIONS(3),
  },
  [150] = {
    [anon_sym_LBRACE] = ACTIONS(346),
    [anon_sym_RBRACE] = ACTIONS(346),
    [anon_sym_SEMI] = ACTIONS(346),
    [anon_sym_LT] = ACTIONS(348),
    [anon_sym_GT] = ACTIONS(348),
    [anon_sym_return] = ACTIONS(348),
    [anon_sym_COLON] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(346),
    [anon_sym_if] = ACTIONS(348),
    [anon_sym_LPAREN] = ACTIONS(346),
    [anon_sym_ATtr] = ACTIONS(346),
    [anon_sym_DOT] = ACTIONS(348),
    [sym_logical_and] = ACTIONS(346),
    [sym_logical_or] = ACTIONS(346),
    [anon_sym_QMARK] = ACTIONS(346),
    [anon_sym_ATimage_DASHurl] = ACTIONS(346),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_DASH] = ACTIONS(348),
    [anon_sym_PLUS] = ACTIONS(348),
    [anon_sym_STAR] = ACTIONS(348),
    [anon_sym_SLASH] = ACTIONS(348),
    [anon_sym_GT_EQ] = ACTIONS(346),
    [anon_sym_LT_EQ] = ACTIONS(346),
    [anon_sym_EQ_EQ] = ACTIONS(346),
    [anon_sym_BANG_EQ] = ACTIONS(346),
    [anon_sym_EQ] = ACTIONS(348),
    [anon_sym_PLUS_EQ] = ACTIONS(346),
    [anon_sym_DASH_EQ] = ACTIONS(346),
    [anon_sym_STAR_EQ] = ACTIONS(346),
    [anon_sym_SLASH_EQ] = ACTIONS(346),
    [anon_sym_DQUOTE] = ACTIONS(346),
    [sym__identifier] = ACTIONS(348),
    [anon_sym_linear] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(348),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(348),
    [anon_sym_ease] = ACTIONS(348),
    [anon_sym_ease_DASHin] = ACTIONS(348),
    [anon_sym_ease_DASHout] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(348),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(348),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(348),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(348),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(348),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(348),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(348),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(348),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(348),
    [anon_sym_cubic_DASHbezier] = ACTIONS(348),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(346),
    [anon_sym_ATlinear_gradient] = ACTIONS(346),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(346),
    [anon_sym_ATradial_gradient] = ACTIONS(346),
    [anon_sym_parent] = ACTIONS(348),
    [anon_sym_root] = ACTIONS(348),
    [anon_sym_self] = ACTIONS(348),
    [sym__int_number] = ACTIONS(348),
    [sym__float_number] = ACTIONS(346),
    [anon_sym_true] = ACTIONS(348),
    [anon_sym_false] = ACTIONS(348),
    [sym_color_value] = ACTIONS(346),
    [anon_sym_phx] = ACTIONS(342),
    [aux_sym_length_value_token1] = ACTIONS(342),
    [aux_sym_duration_value_token1] = ACTIONS(342),
    [aux_sym_angle_value_token1] = ACTIONS(342),
    [anon_sym_PERCENT2] = ACTIONS(344),
    [anon_sym_rem] = ACTIONS(342),
    [sym_comment] = ACTIONS(3),
  },
  [151] = {
    [sym_add_prec_operator] = STATE(107),
    [sym_mult_prec_operator] = STATE(108),
    [sym_comparison_operator] = STATE(109),
    [sym_assignment_prec_operator] = STATE(265),
    [anon_sym_LBRACE] = ACTIONS(350),
    [anon_sym_RBRACE] = ACTIONS(350),
    [anon_sym_SEMI] = ACTIONS(304),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_GT] = ACTIONS(352),
    [anon_sym_return] = ACTIONS(354),
    [anon_sym_COLON] = ACTIONS(356),
    [anon_sym_LBRACK] = ACTIONS(358),
    [anon_sym_if] = ACTIONS(354),
    [anon_sym_LPAREN] = ACTIONS(350),
    [anon_sym_ATtr] = ACTIONS(350),
    [anon_sym_DOT] = ACTIONS(360),
    [sym_logical_and] = ACTIONS(362),
    [sym_logical_or] = ACTIONS(364),
    [anon_sym_QMARK] = ACTIONS(366),
    [anon_sym_ATimage_DASHurl] = ACTIONS(350),
    [anon_sym_BANG] = ACTIONS(354),
    [anon_sym_DASH] = ACTIONS(368),
    [anon_sym_PLUS] = ACTIONS(368),
    [anon_sym_STAR] = ACTIONS(370),
    [anon_sym_SLASH] = ACTIONS(370),
    [anon_sym_GT_EQ] = ACTIONS(372),
    [anon_sym_LT_EQ] = ACTIONS(372),
    [anon_sym_EQ_EQ] = ACTIONS(372),
    [anon_sym_BANG_EQ] = ACTIONS(372),
    [anon_sym_EQ] = ACTIONS(374),
    [anon_sym_PLUS_EQ] = ACTIONS(356),
    [anon_sym_DASH_EQ] = ACTIONS(356),
    [anon_sym_STAR_EQ] = ACTIONS(356),
    [anon_sym_SLASH_EQ] = ACTIONS(356),
    [anon_sym_DQUOTE] = ACTIONS(350),
    [sym__identifier] = ACTIONS(354),
    [anon_sym_linear] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(354),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(354),
    [anon_sym_ease] = ACTIONS(354),
    [anon_sym_ease_DASHin] = ACTIONS(354),
    [anon_sym_ease_DASHout] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(354),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(354),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(354),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(354),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(354),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(354),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(354),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(354),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(354),
    [anon_sym_cubic_DASHbezier] = ACTIONS(354),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(350),
    [anon_sym_ATlinear_gradient] = ACTIONS(350),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(350),
    [anon_sym_ATradial_gradient] = ACTIONS(350),
    [anon_sym_parent] = ACTIONS(354),
    [anon_sym_root] = ACTIONS(354),
    [anon_sym_self] = ACTIONS(354),
    [sym__int_number] = ACTIONS(354),
    [sym__float_number] = ACTIONS(350),
    [anon_sym_true] = ACTIONS(354),
    [anon_sym_false] = ACTIONS(354),
    [sym_color_value] = ACTIONS(350),
    [sym_comment] = ACTIONS(3),
  },
  [152] = {
    [sym_arguments] = STATE(153),
    [anon_sym_LBRACE] = ACTIONS(376),
    [anon_sym_COMMA] = ACTIONS(376),
    [anon_sym_RBRACE] = ACTIONS(376),
    [anon_sym_SEMI] = ACTIONS(376),
    [anon_sym_LT] = ACTIONS(378),
    [anon_sym_GT] = ACTIONS(378),
    [anon_sym_return] = ACTIONS(378),
    [anon_sym_COLON] = ACTIONS(376),
    [anon_sym_LBRACK] = ACTIONS(376),
    [anon_sym_if] = ACTIONS(378),
    [anon_sym_LPAREN] = ACTIONS(380),
    [anon_sym_RPAREN] = ACTIONS(376),
    [anon_sym_ATtr] = ACTIONS(376),
    [anon_sym_DOT] = ACTIONS(378),
    [sym_logical_and] = ACTIONS(376),
    [sym_logical_or] = ACTIONS(376),
    [anon_sym_QMARK] = ACTIONS(376),
    [anon_sym_ATimage_DASHurl] = ACTIONS(376),
    [anon_sym_BANG] = ACTIONS(378),
    [anon_sym_DASH] = ACTIONS(378),
    [anon_sym_PLUS] = ACTIONS(378),
    [anon_sym_STAR] = ACTIONS(378),
    [anon_sym_SLASH] = ACTIONS(378),
    [anon_sym_GT_EQ] = ACTIONS(376),
    [anon_sym_LT_EQ] = ACTIONS(376),
    [anon_sym_EQ_EQ] = ACTIONS(376),
    [anon_sym_BANG_EQ] = ACTIONS(376),
    [anon_sym_EQ] = ACTIONS(378),
    [anon_sym_PLUS_EQ] = ACTIONS(376),
    [anon_sym_DASH_EQ] = ACTIONS(376),
    [anon_sym_STAR_EQ] = ACTIONS(376),
    [anon_sym_SLASH_EQ] = ACTIONS(376),
    [anon_sym_DQUOTE] = ACTIONS(376),
    [sym__identifier] = ACTIONS(378),
    [anon_sym_linear] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(378),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(378),
    [anon_sym_ease] = ACTIONS(378),
    [anon_sym_ease_DASHin] = ACTIONS(378),
    [anon_sym_ease_DASHout] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(378),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(378),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(378),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(378),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(378),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(378),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(378),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(378),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(378),
    [anon_sym_cubic_DASHbezier] = ACTIONS(378),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(376),
    [anon_sym_ATlinear_gradient] = ACTIONS(376),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(376),
    [anon_sym_ATradial_gradient] = ACTIONS(376),
    [anon_sym_parent] = ACTIONS(378),
    [anon_sym_root] = ACTIONS(378),
    [anon_sym_self] = ACTIONS(378),
    [sym__int_number] = ACTIONS(378),
    [sym__float_number] = ACTIONS(376),
    [anon_sym_true] = ACTIONS(378),
    [anon_sym_false] = ACTIONS(378),
    [sym_color_value] = ACTIONS(376),
    [sym_comment] = ACTIONS(3),
  },
  [153] = {
    [anon_sym_LBRACE] = ACTIONS(382),
    [anon_sym_COMMA] = ACTIONS(382),
    [anon_sym_RBRACE] = ACTIONS(382),
    [anon_sym_SEMI] = ACTIONS(382),
    [anon_sym_LT] = ACTIONS(384),
    [anon_sym_GT] = ACTIONS(384),
    [anon_sym_return] = ACTIONS(384),
    [anon_sym_COLON] = ACTIONS(382),
    [anon_sym_LBRACK] = ACTIONS(382),
    [anon_sym_if] = ACTIONS(384),
    [anon_sym_LPAREN] = ACTIONS(382),
    [anon_sym_RPAREN] = ACTIONS(382),
    [anon_sym_ATtr] = ACTIONS(382),
    [anon_sym_EQ_GT] = ACTIONS(382),
    [anon_sym_DOT] = ACTIONS(384),
    [sym_logical_and] = ACTIONS(382),
    [sym_logical_or] = ACTIONS(382),
    [anon_sym_QMARK] = ACTIONS(382),
    [anon_sym_ATimage_DASHurl] = ACTIONS(382),
    [anon_sym_BANG] = ACTIONS(384),
    [anon_sym_DASH] = ACTIONS(384),
    [anon_sym_PLUS] = ACTIONS(384),
    [anon_sym_STAR] = ACTIONS(384),
    [anon_sym_SLASH] = ACTIONS(384),
    [anon_sym_GT_EQ] = ACTIONS(382),
    [anon_sym_LT_EQ] = ACTIONS(382),
    [anon_sym_EQ_EQ] = ACTIONS(382),
    [anon_sym_BANG_EQ] = ACTIONS(382),
    [anon_sym_EQ] = ACTIONS(384),
    [anon_sym_PLUS_EQ] = ACTIONS(382),
    [anon_sym_DASH_EQ] = ACTIONS(382),
    [anon_sym_STAR_EQ] = ACTIONS(382),
    [anon_sym_SLASH_EQ] = ACTIONS(382),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [sym__identifier] = ACTIONS(384),
    [anon_sym_linear] = ACTIONS(384),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(384),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(384),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(384),
    [anon_sym_ease] = ACTIONS(384),
    [anon_sym_ease_DASHin] = ACTIONS(384),
    [anon_sym_ease_DASHout] = ACTIONS(384),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(384),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(384),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(384),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(384),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(384),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(384),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(384),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(384),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(384),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(384),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(384),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(384),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(384),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(384),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(384),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(384),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(384),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(384),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(384),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(384),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(384),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(384),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(384),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(384),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(384),
    [anon_sym_cubic_DASHbezier] = ACTIONS(384),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(382),
    [anon_sym_ATlinear_gradient] = ACTIONS(382),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(382),
    [anon_sym_ATradial_gradient] = ACTIONS(382),
    [anon_sym_parent] = ACTIONS(384),
    [anon_sym_root] = ACTIONS(384),
    [anon_sym_self] = ACTIONS(384),
    [sym__int_number] = ACTIONS(384),
    [sym__float_number] = ACTIONS(382),
    [anon_sym_true] = ACTIONS(384),
    [anon_sym_false] = ACTIONS(384),
    [sym_color_value] = ACTIONS(382),
    [sym_comment] = ACTIONS(3),
  },
  [154] = {
    [sym_add_prec_operator] = STATE(107),
    [sym_mult_prec_operator] = STATE(108),
    [sym_comparison_operator] = STATE(109),
    [anon_sym_LBRACE] = ACTIONS(386),
    [anon_sym_RBRACE] = ACTIONS(386),
    [anon_sym_SEMI] = ACTIONS(386),
    [anon_sym_LT] = ACTIONS(388),
    [anon_sym_GT] = ACTIONS(388),
    [anon_sym_return] = ACTIONS(388),
    [anon_sym_COLON] = ACTIONS(386),
    [anon_sym_LBRACK] = ACTIONS(358),
    [anon_sym_if] = ACTIONS(388),
    [anon_sym_LPAREN] = ACTIONS(386),
    [anon_sym_ATtr] = ACTIONS(386),
    [anon_sym_DOT] = ACTIONS(360),
    [sym_logical_and] = ACTIONS(386),
    [sym_logical_or] = ACTIONS(386),
    [anon_sym_QMARK] = ACTIONS(386),
    [anon_sym_ATimage_DASHurl] = ACTIONS(386),
    [anon_sym_BANG] = ACTIONS(388),
    [anon_sym_DASH] = ACTIONS(388),
    [anon_sym_PLUS] = ACTIONS(388),
    [anon_sym_STAR] = ACTIONS(388),
    [anon_sym_SLASH] = ACTIONS(388),
    [anon_sym_GT_EQ] = ACTIONS(386),
    [anon_sym_LT_EQ] = ACTIONS(386),
    [anon_sym_EQ_EQ] = ACTIONS(386),
    [anon_sym_BANG_EQ] = ACTIONS(386),
    [anon_sym_EQ] = ACTIONS(388),
    [anon_sym_PLUS_EQ] = ACTIONS(386),
    [anon_sym_DASH_EQ] = ACTIONS(386),
    [anon_sym_STAR_EQ] = ACTIONS(386),
    [anon_sym_SLASH_EQ] = ACTIONS(386),
    [anon_sym_DQUOTE] = ACTIONS(386),
    [sym__identifier] = ACTIONS(388),
    [anon_sym_linear] = ACTIONS(388),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(388),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(388),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(388),
    [anon_sym_ease] = ACTIONS(388),
    [anon_sym_ease_DASHin] = ACTIONS(388),
    [anon_sym_ease_DASHout] = ACTIONS(388),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(388),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(388),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(388),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(388),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(388),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(388),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(388),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(388),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(388),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(388),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(388),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(388),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(388),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(388),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(388),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(388),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(388),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(388),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(388),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(388),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(388),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(388),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(388),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(388),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(388),
    [anon_sym_cubic_DASHbezier] = ACTIONS(388),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(386),
    [anon_sym_ATlinear_gradient] = ACTIONS(386),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(386),
    [anon_sym_ATradial_gradient] = ACTIONS(386),
    [anon_sym_parent] = ACTIONS(388),
    [anon_sym_root] = ACTIONS(388),
    [anon_sym_self] = ACTIONS(388),
    [sym__int_number] = ACTIONS(388),
    [sym__float_number] = ACTIONS(386),
    [anon_sym_true] = ACTIONS(388),
    [anon_sym_false] = ACTIONS(388),
    [sym_color_value] = ACTIONS(386),
    [sym_comment] = ACTIONS(3),
  },
  [155] = {
    [anon_sym_LBRACE] = ACTIONS(390),
    [anon_sym_COMMA] = ACTIONS(390),
    [anon_sym_RBRACE] = ACTIONS(390),
    [anon_sym_SEMI] = ACTIONS(390),
    [anon_sym_LT] = ACTIONS(392),
    [anon_sym_GT] = ACTIONS(392),
    [anon_sym_return] = ACTIONS(392),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_LBRACK] = ACTIONS(390),
    [anon_sym_if] = ACTIONS(392),
    [anon_sym_LPAREN] = ACTIONS(390),
    [anon_sym_RPAREN] = ACTIONS(390),
    [anon_sym_ATtr] = ACTIONS(390),
    [anon_sym_EQ_GT] = ACTIONS(390),
    [anon_sym_DOT] = ACTIONS(392),
    [sym_logical_and] = ACTIONS(390),
    [sym_logical_or] = ACTIONS(390),
    [anon_sym_QMARK] = ACTIONS(390),
    [anon_sym_ATimage_DASHurl] = ACTIONS(390),
    [anon_sym_BANG] = ACTIONS(392),
    [anon_sym_DASH] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(392),
    [anon_sym_SLASH] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(390),
    [anon_sym_LT_EQ] = ACTIONS(390),
    [anon_sym_EQ_EQ] = ACTIONS(390),
    [anon_sym_BANG_EQ] = ACTIONS(390),
    [anon_sym_EQ] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(390),
    [anon_sym_DASH_EQ] = ACTIONS(390),
    [anon_sym_STAR_EQ] = ACTIONS(390),
    [anon_sym_SLASH_EQ] = ACTIONS(390),
    [anon_sym_DQUOTE] = ACTIONS(390),
    [sym__identifier] = ACTIONS(392),
    [anon_sym_linear] = ACTIONS(392),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(392),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(392),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(392),
    [anon_sym_ease] = ACTIONS(392),
    [anon_sym_ease_DASHin] = ACTIONS(392),
    [anon_sym_ease_DASHout] = ACTIONS(392),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(392),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(392),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(392),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(392),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(392),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(392),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(392),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(392),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(392),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(392),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(392),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(392),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(392),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(392),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(392),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(392),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(392),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(392),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(392),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(392),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(392),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(392),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(392),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(392),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(392),
    [anon_sym_cubic_DASHbezier] = ACTIONS(392),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(390),
    [anon_sym_ATlinear_gradient] = ACTIONS(390),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(390),
    [anon_sym_ATradial_gradient] = ACTIONS(390),
    [anon_sym_parent] = ACTIONS(392),
    [anon_sym_root] = ACTIONS(392),
    [anon_sym_self] = ACTIONS(392),
    [sym__int_number] = ACTIONS(392),
    [sym__float_number] = ACTIONS(390),
    [anon_sym_true] = ACTIONS(392),
    [anon_sym_false] = ACTIONS(392),
    [sym_color_value] = ACTIONS(390),
    [sym_comment] = ACTIONS(3),
  },
  [156] = {
    [sym_add_prec_operator] = STATE(107),
    [sym_mult_prec_operator] = STATE(108),
    [sym_comparison_operator] = STATE(109),
    [anon_sym_LBRACE] = ACTIONS(394),
    [anon_sym_RBRACE] = ACTIONS(394),
    [anon_sym_SEMI] = ACTIONS(394),
    [anon_sym_LT] = ACTIONS(396),
    [anon_sym_GT] = ACTIONS(396),
    [anon_sym_return] = ACTIONS(396),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_LBRACK] = ACTIONS(358),
    [anon_sym_if] = ACTIONS(396),
    [anon_sym_LPAREN] = ACTIONS(394),
    [anon_sym_ATtr] = ACTIONS(394),
    [anon_sym_DOT] = ACTIONS(396),
    [sym_logical_and] = ACTIONS(394),
    [sym_logical_or] = ACTIONS(394),
    [anon_sym_QMARK] = ACTIONS(394),
    [anon_sym_ATimage_DASHurl] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(396),
    [anon_sym_DASH] = ACTIONS(396),
    [anon_sym_PLUS] = ACTIONS(396),
    [anon_sym_STAR] = ACTIONS(396),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_GT_EQ] = ACTIONS(394),
    [anon_sym_LT_EQ] = ACTIONS(394),
    [anon_sym_EQ_EQ] = ACTIONS(394),
    [anon_sym_BANG_EQ] = ACTIONS(394),
    [anon_sym_EQ] = ACTIONS(396),
    [anon_sym_PLUS_EQ] = ACTIONS(394),
    [anon_sym_DASH_EQ] = ACTIONS(394),
    [anon_sym_STAR_EQ] = ACTIONS(394),
    [anon_sym_SLASH_EQ] = ACTIONS(394),
    [anon_sym_DQUOTE] = ACTIONS(394),
    [sym__identifier] = ACTIONS(396),
    [anon_sym_linear] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(396),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(396),
    [anon_sym_ease] = ACTIONS(396),
    [anon_sym_ease_DASHin] = ACTIONS(396),
    [anon_sym_ease_DASHout] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(396),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(396),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(396),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(396),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(396),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(396),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(396),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(396),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(396),
    [anon_sym_cubic_DASHbezier] = ACTIONS(396),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(394),
    [anon_sym_ATlinear_gradient] = ACTIONS(394),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(394),
    [anon_sym_ATradial_gradient] = ACTIONS(394),
    [anon_sym_parent] = ACTIONS(396),
    [anon_sym_root] = ACTIONS(396),
    [anon_sym_self] = ACTIONS(396),
    [sym__int_number] = ACTIONS(396),
    [sym__float_number] = ACTIONS(394),
    [anon_sym_true] = ACTIONS(396),
    [anon_sym_false] = ACTIONS(396),
    [sym_color_value] = ACTIONS(394),
    [sym_comment] = ACTIONS(3),
  },
  [157] = {
    [sym_add_prec_operator] = STATE(107),
    [sym_mult_prec_operator] = STATE(108),
    [sym_comparison_operator] = STATE(109),
    [anon_sym_LBRACE] = ACTIONS(398),
    [anon_sym_RBRACE] = ACTIONS(398),
    [anon_sym_SEMI] = ACTIONS(398),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_GT] = ACTIONS(352),
    [anon_sym_return] = ACTIONS(400),
    [anon_sym_COLON] = ACTIONS(398),
    [anon_sym_LBRACK] = ACTIONS(358),
    [anon_sym_if] = ACTIONS(400),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym_ATtr] = ACTIONS(398),
    [anon_sym_DOT] = ACTIONS(360),
    [sym_logical_and] = ACTIONS(398),
    [sym_logical_or] = ACTIONS(398),
    [anon_sym_QMARK] = ACTIONS(398),
    [anon_sym_ATimage_DASHurl] = ACTIONS(398),
    [anon_sym_BANG] = ACTIONS(400),
    [anon_sym_DASH] = ACTIONS(368),
    [anon_sym_PLUS] = ACTIONS(368),
    [anon_sym_STAR] = ACTIONS(370),
    [anon_sym_SLASH] = ACTIONS(370),
    [anon_sym_GT_EQ] = ACTIONS(372),
    [anon_sym_LT_EQ] = ACTIONS(372),
    [anon_sym_EQ_EQ] = ACTIONS(372),
    [anon_sym_BANG_EQ] = ACTIONS(372),
    [anon_sym_EQ] = ACTIONS(400),
    [anon_sym_PLUS_EQ] = ACTIONS(398),
    [anon_sym_DASH_EQ] = ACTIONS(398),
    [anon_sym_STAR_EQ] = ACTIONS(398),
    [anon_sym_SLASH_EQ] = ACTIONS(398),
    [anon_sym_DQUOTE] = ACTIONS(398),
    [sym__identifier] = ACTIONS(400),
    [anon_sym_linear] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(400),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(400),
    [anon_sym_ease] = ACTIONS(400),
    [anon_sym_ease_DASHin] = ACTIONS(400),
    [anon_sym_ease_DASHout] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(400),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(400),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(400),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(400),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(400),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(400),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(400),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(400),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(400),
    [anon_sym_cubic_DASHbezier] = ACTIONS(400),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(398),
    [anon_sym_ATlinear_gradient] = ACTIONS(398),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(398),
    [anon_sym_ATradial_gradient] = ACTIONS(398),
    [anon_sym_parent] = ACTIONS(400),
    [anon_sym_root] = ACTIONS(400),
    [anon_sym_self] = ACTIONS(400),
    [sym__int_number] = ACTIONS(400),
    [sym__float_number] = ACTIONS(398),
    [anon_sym_true] = ACTIONS(400),
    [anon_sym_false] = ACTIONS(400),
    [sym_color_value] = ACTIONS(398),
    [sym_comment] = ACTIONS(3),
  },
  [158] = {
    [sym_add_prec_operator] = STATE(107),
    [sym_mult_prec_operator] = STATE(108),
    [sym_comparison_operator] = STATE(109),
    [anon_sym_LBRACE] = ACTIONS(398),
    [anon_sym_RBRACE] = ACTIONS(398),
    [anon_sym_SEMI] = ACTIONS(398),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_GT] = ACTIONS(352),
    [anon_sym_return] = ACTIONS(400),
    [anon_sym_COLON] = ACTIONS(398),
    [anon_sym_LBRACK] = ACTIONS(358),
    [anon_sym_if] = ACTIONS(400),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym_ATtr] = ACTIONS(398),
    [anon_sym_DOT] = ACTIONS(360),
    [sym_logical_and] = ACTIONS(362),
    [sym_logical_or] = ACTIONS(398),
    [anon_sym_QMARK] = ACTIONS(398),
    [anon_sym_ATimage_DASHurl] = ACTIONS(398),
    [anon_sym_BANG] = ACTIONS(400),
    [anon_sym_DASH] = ACTIONS(368),
    [anon_sym_PLUS] = ACTIONS(368),
    [anon_sym_STAR] = ACTIONS(370),
    [anon_sym_SLASH] = ACTIONS(370),
    [anon_sym_GT_EQ] = ACTIONS(372),
    [anon_sym_LT_EQ] = ACTIONS(372),
    [anon_sym_EQ_EQ] = ACTIONS(372),
    [anon_sym_BANG_EQ] = ACTIONS(372),
    [anon_sym_EQ] = ACTIONS(400),
    [anon_sym_PLUS_EQ] = ACTIONS(398),
    [anon_sym_DASH_EQ] = ACTIONS(398),
    [anon_sym_STAR_EQ] = ACTIONS(398),
    [anon_sym_SLASH_EQ] = ACTIONS(398),
    [anon_sym_DQUOTE] = ACTIONS(398),
    [sym__identifier] = ACTIONS(400),
    [anon_sym_linear] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(400),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(400),
    [anon_sym_ease] = ACTIONS(400),
    [anon_sym_ease_DASHin] = ACTIONS(400),
    [anon_sym_ease_DASHout] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(400),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(400),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(400),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(400),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(400),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(400),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(400),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(400),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(400),
    [anon_sym_cubic_DASHbezier] = ACTIONS(400),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(398),
    [anon_sym_ATlinear_gradient] = ACTIONS(398),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(398),
    [anon_sym_ATradial_gradient] = ACTIONS(398),
    [anon_sym_parent] = ACTIONS(400),
    [anon_sym_root] = ACTIONS(400),
    [anon_sym_self] = ACTIONS(400),
    [sym__int_number] = ACTIONS(400),
    [sym__float_number] = ACTIONS(398),
    [anon_sym_true] = ACTIONS(400),
    [anon_sym_false] = ACTIONS(400),
    [sym_color_value] = ACTIONS(398),
    [sym_comment] = ACTIONS(3),
  },
  [159] = {
    [sym_add_prec_operator] = STATE(107),
    [sym_mult_prec_operator] = STATE(108),
    [sym_comparison_operator] = STATE(109),
    [anon_sym_LBRACE] = ACTIONS(402),
    [anon_sym_RBRACE] = ACTIONS(402),
    [anon_sym_SEMI] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(404),
    [anon_sym_GT] = ACTIONS(404),
    [anon_sym_return] = ACTIONS(404),
    [anon_sym_COLON] = ACTIONS(402),
    [anon_sym_LBRACK] = ACTIONS(358),
    [anon_sym_if] = ACTIONS(404),
    [anon_sym_LPAREN] = ACTIONS(402),
    [anon_sym_ATtr] = ACTIONS(402),
    [anon_sym_DOT] = ACTIONS(360),
    [sym_logical_and] = ACTIONS(402),
    [sym_logical_or] = ACTIONS(402),
    [anon_sym_QMARK] = ACTIONS(402),
    [anon_sym_ATimage_DASHurl] = ACTIONS(402),
    [anon_sym_BANG] = ACTIONS(404),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_PLUS] = ACTIONS(404),
    [anon_sym_STAR] = ACTIONS(370),
    [anon_sym_SLASH] = ACTIONS(370),
    [anon_sym_GT_EQ] = ACTIONS(402),
    [anon_sym_LT_EQ] = ACTIONS(402),
    [anon_sym_EQ_EQ] = ACTIONS(402),
    [anon_sym_BANG_EQ] = ACTIONS(402),
    [anon_sym_EQ] = ACTIONS(404),
    [anon_sym_PLUS_EQ] = ACTIONS(402),
    [anon_sym_DASH_EQ] = ACTIONS(402),
    [anon_sym_STAR_EQ] = ACTIONS(402),
    [anon_sym_SLASH_EQ] = ACTIONS(402),
    [anon_sym_DQUOTE] = ACTIONS(402),
    [sym__identifier] = ACTIONS(404),
    [anon_sym_linear] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(404),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(404),
    [anon_sym_ease] = ACTIONS(404),
    [anon_sym_ease_DASHin] = ACTIONS(404),
    [anon_sym_ease_DASHout] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(404),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(404),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(404),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(404),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(404),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(404),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(404),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(404),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(404),
    [anon_sym_cubic_DASHbezier] = ACTIONS(404),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(402),
    [anon_sym_ATlinear_gradient] = ACTIONS(402),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(402),
    [anon_sym_ATradial_gradient] = ACTIONS(402),
    [anon_sym_parent] = ACTIONS(404),
    [anon_sym_root] = ACTIONS(404),
    [anon_sym_self] = ACTIONS(404),
    [sym__int_number] = ACTIONS(404),
    [sym__float_number] = ACTIONS(402),
    [anon_sym_true] = ACTIONS(404),
    [anon_sym_false] = ACTIONS(404),
    [sym_color_value] = ACTIONS(402),
    [sym_comment] = ACTIONS(3),
  },
  [160] = {
    [sym_add_prec_operator] = STATE(107),
    [sym_mult_prec_operator] = STATE(108),
    [sym_comparison_operator] = STATE(109),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_RBRACE] = ACTIONS(406),
    [anon_sym_SEMI] = ACTIONS(406),
    [anon_sym_LT] = ACTIONS(408),
    [anon_sym_GT] = ACTIONS(408),
    [anon_sym_return] = ACTIONS(408),
    [anon_sym_COLON] = ACTIONS(406),
    [anon_sym_LBRACK] = ACTIONS(358),
    [anon_sym_if] = ACTIONS(408),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_ATtr] = ACTIONS(406),
    [anon_sym_DOT] = ACTIONS(360),
    [sym_logical_and] = ACTIONS(406),
    [sym_logical_or] = ACTIONS(406),
    [anon_sym_QMARK] = ACTIONS(406),
    [anon_sym_ATimage_DASHurl] = ACTIONS(406),
    [anon_sym_BANG] = ACTIONS(408),
    [anon_sym_DASH] = ACTIONS(408),
    [anon_sym_PLUS] = ACTIONS(408),
    [anon_sym_STAR] = ACTIONS(408),
    [anon_sym_SLASH] = ACTIONS(408),
    [anon_sym_GT_EQ] = ACTIONS(406),
    [anon_sym_LT_EQ] = ACTIONS(406),
    [anon_sym_EQ_EQ] = ACTIONS(406),
    [anon_sym_BANG_EQ] = ACTIONS(406),
    [anon_sym_EQ] = ACTIONS(408),
    [anon_sym_PLUS_EQ] = ACTIONS(406),
    [anon_sym_DASH_EQ] = ACTIONS(406),
    [anon_sym_STAR_EQ] = ACTIONS(406),
    [anon_sym_SLASH_EQ] = ACTIONS(406),
    [anon_sym_DQUOTE] = ACTIONS(406),
    [sym__identifier] = ACTIONS(408),
    [anon_sym_linear] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(408),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(408),
    [anon_sym_ease] = ACTIONS(408),
    [anon_sym_ease_DASHin] = ACTIONS(408),
    [anon_sym_ease_DASHout] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(408),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(408),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(408),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(408),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(408),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(408),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(408),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(408),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(408),
    [anon_sym_cubic_DASHbezier] = ACTIONS(408),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(406),
    [anon_sym_ATlinear_gradient] = ACTIONS(406),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(406),
    [anon_sym_ATradial_gradient] = ACTIONS(406),
    [anon_sym_parent] = ACTIONS(408),
    [anon_sym_root] = ACTIONS(408),
    [anon_sym_self] = ACTIONS(408),
    [sym__int_number] = ACTIONS(408),
    [sym__float_number] = ACTIONS(406),
    [anon_sym_true] = ACTIONS(408),
    [anon_sym_false] = ACTIONS(408),
    [sym_color_value] = ACTIONS(406),
    [sym_comment] = ACTIONS(3),
  },
  [161] = {
    [anon_sym_LBRACE] = ACTIONS(410),
    [anon_sym_COMMA] = ACTIONS(410),
    [anon_sym_RBRACE] = ACTIONS(410),
    [anon_sym_SEMI] = ACTIONS(410),
    [anon_sym_LT] = ACTIONS(412),
    [anon_sym_GT] = ACTIONS(412),
    [anon_sym_return] = ACTIONS(412),
    [anon_sym_COLON] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(410),
    [anon_sym_if] = ACTIONS(412),
    [anon_sym_LPAREN] = ACTIONS(410),
    [anon_sym_RPAREN] = ACTIONS(410),
    [anon_sym_ATtr] = ACTIONS(410),
    [anon_sym_EQ_GT] = ACTIONS(410),
    [anon_sym_DOT] = ACTIONS(412),
    [sym_logical_and] = ACTIONS(410),
    [sym_logical_or] = ACTIONS(410),
    [anon_sym_QMARK] = ACTIONS(410),
    [anon_sym_ATimage_DASHurl] = ACTIONS(410),
    [anon_sym_BANG] = ACTIONS(412),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_STAR] = ACTIONS(412),
    [anon_sym_SLASH] = ACTIONS(412),
    [anon_sym_GT_EQ] = ACTIONS(410),
    [anon_sym_LT_EQ] = ACTIONS(410),
    [anon_sym_EQ_EQ] = ACTIONS(410),
    [anon_sym_BANG_EQ] = ACTIONS(410),
    [anon_sym_EQ] = ACTIONS(412),
    [anon_sym_PLUS_EQ] = ACTIONS(410),
    [anon_sym_DASH_EQ] = ACTIONS(410),
    [anon_sym_STAR_EQ] = ACTIONS(410),
    [anon_sym_SLASH_EQ] = ACTIONS(410),
    [anon_sym_DQUOTE] = ACTIONS(410),
    [sym__identifier] = ACTIONS(412),
    [anon_sym_linear] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(412),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(412),
    [anon_sym_ease] = ACTIONS(412),
    [anon_sym_ease_DASHin] = ACTIONS(412),
    [anon_sym_ease_DASHout] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(412),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(412),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(412),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(412),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(412),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(412),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(412),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(412),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(412),
    [anon_sym_cubic_DASHbezier] = ACTIONS(412),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(410),
    [anon_sym_ATlinear_gradient] = ACTIONS(410),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(410),
    [anon_sym_ATradial_gradient] = ACTIONS(410),
    [anon_sym_parent] = ACTIONS(412),
    [anon_sym_root] = ACTIONS(412),
    [anon_sym_self] = ACTIONS(412),
    [sym__int_number] = ACTIONS(412),
    [sym__float_number] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [sym_color_value] = ACTIONS(410),
    [sym_comment] = ACTIONS(3),
  },
  [162] = {
    [anon_sym_LBRACE] = ACTIONS(414),
    [anon_sym_COMMA] = ACTIONS(414),
    [anon_sym_RBRACE] = ACTIONS(414),
    [anon_sym_SEMI] = ACTIONS(414),
    [anon_sym_LT] = ACTIONS(416),
    [anon_sym_GT] = ACTIONS(416),
    [anon_sym_return] = ACTIONS(416),
    [anon_sym_COLON] = ACTIONS(414),
    [anon_sym_LBRACK] = ACTIONS(414),
    [anon_sym_if] = ACTIONS(416),
    [anon_sym_LPAREN] = ACTIONS(414),
    [anon_sym_RPAREN] = ACTIONS(414),
    [anon_sym_ATtr] = ACTIONS(414),
    [anon_sym_EQ_GT] = ACTIONS(414),
    [anon_sym_DOT] = ACTIONS(416),
    [sym_logical_and] = ACTIONS(414),
    [sym_logical_or] = ACTIONS(414),
    [anon_sym_QMARK] = ACTIONS(414),
    [anon_sym_ATimage_DASHurl] = ACTIONS(414),
    [anon_sym_BANG] = ACTIONS(416),
    [anon_sym_DASH] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(416),
    [anon_sym_STAR] = ACTIONS(416),
    [anon_sym_SLASH] = ACTIONS(416),
    [anon_sym_GT_EQ] = ACTIONS(414),
    [anon_sym_LT_EQ] = ACTIONS(414),
    [anon_sym_EQ_EQ] = ACTIONS(414),
    [anon_sym_BANG_EQ] = ACTIONS(414),
    [anon_sym_EQ] = ACTIONS(416),
    [anon_sym_PLUS_EQ] = ACTIONS(414),
    [anon_sym_DASH_EQ] = ACTIONS(414),
    [anon_sym_STAR_EQ] = ACTIONS(414),
    [anon_sym_SLASH_EQ] = ACTIONS(414),
    [anon_sym_DQUOTE] = ACTIONS(414),
    [sym__identifier] = ACTIONS(416),
    [anon_sym_linear] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(416),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(416),
    [anon_sym_ease] = ACTIONS(416),
    [anon_sym_ease_DASHin] = ACTIONS(416),
    [anon_sym_ease_DASHout] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(416),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(416),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(416),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(416),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(416),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(416),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(416),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(416),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(416),
    [anon_sym_cubic_DASHbezier] = ACTIONS(416),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(414),
    [anon_sym_ATlinear_gradient] = ACTIONS(414),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(414),
    [anon_sym_ATradial_gradient] = ACTIONS(414),
    [anon_sym_parent] = ACTIONS(416),
    [anon_sym_root] = ACTIONS(416),
    [anon_sym_self] = ACTIONS(416),
    [sym__int_number] = ACTIONS(416),
    [sym__float_number] = ACTIONS(414),
    [anon_sym_true] = ACTIONS(416),
    [anon_sym_false] = ACTIONS(416),
    [sym_color_value] = ACTIONS(414),
    [sym_comment] = ACTIONS(3),
  },
  [163] = {
    [sym_add_prec_operator] = STATE(107),
    [sym_mult_prec_operator] = STATE(108),
    [sym_comparison_operator] = STATE(109),
    [anon_sym_LBRACE] = ACTIONS(418),
    [anon_sym_RBRACE] = ACTIONS(418),
    [anon_sym_SEMI] = ACTIONS(418),
    [anon_sym_LT] = ACTIONS(420),
    [anon_sym_GT] = ACTIONS(420),
    [anon_sym_return] = ACTIONS(420),
    [anon_sym_COLON] = ACTIONS(418),
    [anon_sym_LBRACK] = ACTIONS(358),
    [anon_sym_if] = ACTIONS(420),
    [anon_sym_LPAREN] = ACTIONS(418),
    [anon_sym_ATtr] = ACTIONS(418),
    [anon_sym_DOT] = ACTIONS(360),
    [sym_logical_and] = ACTIONS(418),
    [sym_logical_or] = ACTIONS(418),
    [anon_sym_QMARK] = ACTIONS(418),
    [anon_sym_ATimage_DASHurl] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_DASH] = ACTIONS(368),
    [anon_sym_PLUS] = ACTIONS(368),
    [anon_sym_STAR] = ACTIONS(370),
    [anon_sym_SLASH] = ACTIONS(370),
    [anon_sym_GT_EQ] = ACTIONS(418),
    [anon_sym_LT_EQ] = ACTIONS(418),
    [anon_sym_EQ_EQ] = ACTIONS(418),
    [anon_sym_BANG_EQ] = ACTIONS(418),
    [anon_sym_EQ] = ACTIONS(420),
    [anon_sym_PLUS_EQ] = ACTIONS(418),
    [anon_sym_DASH_EQ] = ACTIONS(418),
    [anon_sym_STAR_EQ] = ACTIONS(418),
    [anon_sym_SLASH_EQ] = ACTIONS(418),
    [anon_sym_DQUOTE] = ACTIONS(418),
    [sym__identifier] = ACTIONS(420),
    [anon_sym_linear] = ACTIONS(420),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(420),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(420),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(420),
    [anon_sym_ease] = ACTIONS(420),
    [anon_sym_ease_DASHin] = ACTIONS(420),
    [anon_sym_ease_DASHout] = ACTIONS(420),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(420),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(420),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(420),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(420),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(420),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(420),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(420),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(420),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(420),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(420),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(420),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(420),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(420),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(420),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(420),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(420),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(420),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(420),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(420),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(420),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(420),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(420),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(420),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(420),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(420),
    [anon_sym_cubic_DASHbezier] = ACTIONS(420),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(418),
    [anon_sym_ATlinear_gradient] = ACTIONS(418),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(418),
    [anon_sym_ATradial_gradient] = ACTIONS(418),
    [anon_sym_parent] = ACTIONS(420),
    [anon_sym_root] = ACTIONS(420),
    [anon_sym_self] = ACTIONS(420),
    [sym__int_number] = ACTIONS(420),
    [sym__float_number] = ACTIONS(418),
    [anon_sym_true] = ACTIONS(420),
    [anon_sym_false] = ACTIONS(420),
    [sym_color_value] = ACTIONS(418),
    [sym_comment] = ACTIONS(3),
  },
  [164] = {
    [anon_sym_LBRACE] = ACTIONS(422),
    [anon_sym_COMMA] = ACTIONS(422),
    [anon_sym_RBRACE] = ACTIONS(422),
    [anon_sym_SEMI] = ACTIONS(422),
    [anon_sym_LT] = ACTIONS(424),
    [anon_sym_GT] = ACTIONS(424),
    [anon_sym_return] = ACTIONS(424),
    [anon_sym_COLON] = ACTIONS(422),
    [anon_sym_LBRACK] = ACTIONS(422),
    [anon_sym_if] = ACTIONS(424),
    [anon_sym_LPAREN] = ACTIONS(422),
    [anon_sym_RPAREN] = ACTIONS(422),
    [anon_sym_ATtr] = ACTIONS(422),
    [anon_sym_EQ_GT] = ACTIONS(422),
    [anon_sym_DOT] = ACTIONS(424),
    [sym_logical_and] = ACTIONS(422),
    [sym_logical_or] = ACTIONS(422),
    [anon_sym_QMARK] = ACTIONS(422),
    [anon_sym_ATimage_DASHurl] = ACTIONS(422),
    [anon_sym_BANG] = ACTIONS(424),
    [anon_sym_DASH] = ACTIONS(424),
    [anon_sym_PLUS] = ACTIONS(424),
    [anon_sym_STAR] = ACTIONS(424),
    [anon_sym_SLASH] = ACTIONS(424),
    [anon_sym_GT_EQ] = ACTIONS(422),
    [anon_sym_LT_EQ] = ACTIONS(422),
    [anon_sym_EQ_EQ] = ACTIONS(422),
    [anon_sym_BANG_EQ] = ACTIONS(422),
    [anon_sym_EQ] = ACTIONS(424),
    [anon_sym_PLUS_EQ] = ACTIONS(422),
    [anon_sym_DASH_EQ] = ACTIONS(422),
    [anon_sym_STAR_EQ] = ACTIONS(422),
    [anon_sym_SLASH_EQ] = ACTIONS(422),
    [anon_sym_DQUOTE] = ACTIONS(422),
    [sym__identifier] = ACTIONS(424),
    [anon_sym_linear] = ACTIONS(424),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(424),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(424),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(424),
    [anon_sym_ease] = ACTIONS(424),
    [anon_sym_ease_DASHin] = ACTIONS(424),
    [anon_sym_ease_DASHout] = ACTIONS(424),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(424),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(424),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(424),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(424),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(424),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(424),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(424),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(424),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(424),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(424),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(424),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(424),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(424),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(424),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(424),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(424),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(424),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(424),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(424),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(424),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(424),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(424),
    [anon_sym_ease_DASHin_DASHbo