#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 196
#define LARGE_STATE_COUNT 9
#define SYMBOL_COUNT 40
#define ALIAS_COUNT 0
#define TOKEN_COUNT 30
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 13
#define PRODUCTION_ID_COUNT 27

enum ts_symbol_identifiers {
  anon_sym_LBRACE_LBRACE = 1,
  anon_sym_RBRACE_RBRACE = 2,
  anon_sym_LBRACE = 3,
  anon_sym_COLON = 4,
  anon_sym_POUND = 5,
  anon_sym_0 = 6,
  anon_sym_DOT = 7,
  anon_sym_STAR = 8,
  anon_sym_RBRACE = 9,
  aux_sym_fill_token1 = 10,
  anon_sym_LT = 11,
  anon_sym_CARET = 12,
  anon_sym_GT = 13,
  anon_sym_PLUS = 14,
  anon_sym_DASH = 15,
  anon_sym_QMARK = 16,
  anon_sym_x_QMARK = 17,
  anon_sym_X_QMARK = 18,
  anon_sym_o = 19,
  anon_sym_x = 20,
  anon_sym_X = 21,
  anon_sym_p = 22,
  anon_sym_b = 23,
  anon_sym_e = 24,
  anon_sym_E = 25,
  anon_sym_DOLLAR = 26,
  sym_text = 27,
  sym_integer = 28,
  sym_identifier = 29,
  sym_format_string = 30,
  sym_format = 31,
  sym_fill = 32,
  sym_align = 33,
  sym_sign = 34,
  sym_type = 35,
  sym_count = 36,
  sym_parameter = 37,
  sym_argument = 38,
  aux_sym_format_string_repeat1 = 39,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_LBRACE_LBRACE] = "escaped",
  [anon_sym_RBRACE_RBRACE] = "escaped",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COLON] = "colon",
  [anon_sym_POUND] = "#",
  [anon_sym_0] = "0",
  [anon_sym_DOT] = "number",
  [anon_sym_STAR] = "number",
  [anon_sym_RBRACE] = "}",
  [aux_sym_fill_token1] = "fill_token1",
  [anon_sym_LT] = "<",
  [anon_sym_CARET] = "^",
  [anon_sym_GT] = ">",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_QMARK] = "\?",
  [anon_sym_x_QMARK] = "x\?",
  [anon_sym_X_QMARK] = "X\?",
  [anon_sym_o] = "o",
  [anon_sym_x] = "x",
  [anon_sym_X] = "X",
  [anon_sym_p] = "p",
  [anon_sym_b] = "b",
  [anon_sym_e] = "e",
  [anon_sym_E] = "E",
  [anon_sym_DOLLAR] = "$",
  [sym_text] = "text",
  [sym_integer] = "integer",
  [sym_identifier] = "identifier",
  [sym_format_string] = "format_string",
  [sym_format] = "format",
  [sym_fill] = "fill",
  [sym_align] = "align",
  [sym_sign] = "sign",
  [sym_type] = "type",
  [sym_count] = "width",
  [sym_parameter] = "parameter",
  [sym_argument] = "argument",
  [aux_sym_format_string_repeat1] = "format_string_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_LBRACE_LBRACE] = anon_sym_LBRACE_LBRACE,
  [anon_sym_RBRACE_RBRACE] = anon_sym_LBRACE_LBRACE,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_0] = anon_sym_0,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_STAR] = anon_sym_DOT,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [aux_sym_fill_token1] = aux_sym_fill_token1,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_x_QMARK] = anon_sym_x_QMARK,
  [anon_sym_X_QMARK] = anon_sym_X_QMARK,
  [anon_sym_o] = anon_sym_o,
  [anon_sym_x] = anon_sym_x,
  [anon_sym_X] = anon_sym_X,
  [anon_sym_p] = anon_sym_p,
  [anon_sym_b] = anon_sym_b,
  [anon_sym_e] = anon_sym_e,
  [anon_sym_E] = anon_sym_E,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [sym_text] = sym_text,
  [sym_integer] = sym_integer,
  [sym_identifier] = sym_identifier,
  [sym_format_string] = sym_format_string,
  [sym_format] = sym_format,
  [sym_fill] = sym_fill,
  [sym_align] = sym_align,
  [sym_sign] = sym_sign,
  [sym_type] = sym_type,
  [sym_count] = sym_count,
  [sym_parameter] = sym_parameter,
  [sym_argument] = sym_argument,
  [aux_sym_format_string_repeat1] = aux_sym_format_string_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LBRACE_LBRACE] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_RBRACE_RBRACE] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_0] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_fill_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_x_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_X_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_o] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_x] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_X] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_p] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_b] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_e] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_E] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [sym_text] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_format_string] = {
    .visible = true,
    .named = true,
  },
  [sym_format] = {
    .visible = true,
    .named = true,
  },
  [sym_fill] = {
    .visible = true,
    .named = true,
  },
  [sym_align] = {
    .visible = true,
    .named = true,
  },
  [sym_sign] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_count] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_format_string_repeat1] = {
    .visible = false,
    .named = false,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = anon_sym_DOT,
  },
  [2] = {
    [2] = anon_sym_DOT,
  },
  [3] = {
    [3] = anon_sym_DOT,
  },
  [4] = {
    [2] = anon_sym_DOT,
    [3] = anon_sym_DOT,
  },
  [5] = {
    [3] = anon_sym_DOT,
    [4] = anon_sym_DOT,
  },
  [6] = {
    [2] = anon_sym_DOT,
    [3] = anon_sym_DOT,
    [4] = anon_sym_DOT,
  },
  [7] = {
    [4] = anon_sym_DOT,
  },
  [8] = {
    [3] = anon_sym_DOT,
    [4] = anon_sym_DOT,
    [5] = anon_sym_DOT,
  },
  [9] = {
    [4] = anon_sym_DOT,
    [5] = anon_sym_DOT,
  },
  [10] = {
    [2] = anon_sym_DOT,
    [4] = anon_sym_DOT,
    [5] = anon_sym_DOT,
  },
  [11] = {
    [5] = anon_sym_DOT,
  },
  [12] = {
    [3] = anon_sym_DOT,
    [5] = anon_sym_DOT,
    [6] = anon_sym_DOT,
  },
  [13] = {
    [5] = anon_sym_DOT,
    [6] = anon_sym_DOT,
  },
  [14] = {
    [4] = anon_sym_DOT,
    [5] = anon_sym_DOT,
    [6] = anon_sym_DOT,
  },
  [15] = {
    [6] = anon_sym_DOT,
  },
  [16] = {
    [5] = anon_sym_DOT,
    [6] = anon_sym_DOT,
    [7] = anon_sym_DOT,
  },
  [17] = {
    [6] = anon_sym_DOT,
    [7] = anon_sym_DOT,
  },
  [18] = {
    [4] = anon_sym_DOT,
    [6] = anon_sym_DOT,
    [7] = anon_sym_DOT,
  },
  [19] = {
    [7] = anon_sym_DOT,
  },
  [20] = {
    [5] = anon_sym_DOT,
    [7] = anon_sym_DOT,
    [8] = anon_sym_DOT,
  },
  [21] = {
    [6] = anon_sym_DOT,
    [7] = anon_sym_DOT,
    [8] = anon_sym_DOT,
  },
  [22] = {
    [7] = anon_sym_DOT,
    [8] = anon_sym_DOT,
  },
  [23] = {
    [6] = anon_sym_DOT,
    [8] = anon_sym_DOT,
    [9] = anon_sym_DOT,
  },
  [24] = {
    [7] = anon_sym_DOT,
    [8] = anon_sym_DOT,
    [9] = anon_sym_DOT,
  },
  [25] = {
    [8] = anon_sym_DOT,
    [9] = anon_sym_DOT,
  },
  [26] = {
    [7] = anon_sym_DOT,
    [9] = anon_sym_DOT,
    [10] = anon_sym_DOT,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_count, 2,
    sym_count,
    anon_sym_DOT,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(7);
      ADVANCE_MAP(
        '#', 12,
        '$', 37,
        '*', 15,
        '+', 25,
        '-', 26,
        '.', 14,
        '0', 13,
        ':', 11,
        '<', 22,
        '>', 24,
        '?', 27,
        'E', 36,
        'X', 32,
        '^', 23,
        'b', 34,
        'e', 35,
        'o', 30,
        'p', 33,
        'x', 31,
        '{', 10,
        '}', 17,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(40);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(41);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '#', 12,
        '$', 37,
        '+', 25,
        '-', 26,
        '.', 14,
        '0', 13,
        ':', 11,
        '?', 27,
        'E', 36,
        'X', 32,
        'b', 34,
        'e', 35,
        'o', 30,
        'p', 33,
        'x', 31,
        '}', 16,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(1);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(40);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(41);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '#', 12,
        '+', 25,
        '-', 26,
        '.', 14,
        '0', 13,
        '<', 22,
        '>', 24,
        '?', 27,
        'E', 36,
        'X', 32,
        '^', 23,
        'b', 34,
        'e', 35,
        'o', 30,
        'p', 33,
        'x', 31,
        '}', 16,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(19);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(20);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(21);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '.', 14,
        '<', 22,
        '>', 24,
        '?', 27,
        'E', 36,
        'X', 32,
        '^', 23,
        'b', 34,
        'e', 35,
        'o', 30,
        'p', 33,
        'x', 31,
        '}', 16,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(40);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(41);
      END_STATE();
    case 4:
      if (lookahead == ':') ADVANCE(11);
      if (lookahead == '}') ADVANCE(16);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(40);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(41);
      END_STATE();
    case 5:
      if (lookahead == '}') ADVANCE(9);
      END_STATE();
    case 6:
      if (eof) ADVANCE(7);
      if (lookahead == '*') ADVANCE(15);
      if (lookahead == '{') ADVANCE(10);
      if (lookahead == '}') ADVANCE(5);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(6);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(40);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(41);
      END_STATE();
    case 7:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 8:
      ACCEPT_TOKEN(anon_sym_LBRACE_LBRACE);
      END_STATE();
    case 9:
      ACCEPT_TOKEN(anon_sym_RBRACE_RBRACE);
      END_STATE();
    case 10:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead == '{') ADVANCE(8);
      END_STATE();
    case 11:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 12:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 13:
      ACCEPT_TOKEN(anon_sym_0);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(40);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 15:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      if (lookahead == '}') ADVANCE(9);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(aux_sym_fill_token1);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(aux_sym_fill_token1);
      ADVANCE_MAP(
        '#', 12,
        '+', 25,
        '-', 26,
        '.', 14,
        '<', 22,
        '>', 24,
        '?', 27,
        'E', 36,
        'X', 32,
        '^', 23,
        'b', 34,
        'e', 35,
        'o', 30,
        'p', 33,
        'x', 31,
        '}', 16,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(19);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(20);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(21);
      if (lookahead != 0 &&
          (lookahead < '0' || '9' < lookahead)) ADVANCE(18);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(aux_sym_fill_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(40);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(aux_sym_fill_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(41);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_x_QMARK);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_X_QMARK);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_o);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(41);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_x);
      if (lookahead == '?') ADVANCE(28);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(41);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_X);
      if (lookahead == '?') ADVANCE(29);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(41);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_p);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(41);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_b);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(41);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_e);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(41);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_E);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(41);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(sym_text);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(38);
      if (lookahead != 0 &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(39);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(sym_text);
      if (lookahead != 0 &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(39);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(sym_integer);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(40);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(41);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 38},
  [2] = {.lex_state = 2},
  [3] = {.lex_state = 2},
  [4] = {.lex_state = 1},
  [5] = {.lex_state = 1},
  [6] = {.lex_state = 1},
  [7] = {.lex_state = 3},
  [8] = {.lex_state = 3},
  [9] = {.lex_state = 1},
  [10] = {.lex_state = 1},
  [11] = {.lex_state = 1},
  [12] = {.lex_state = 1},
  [13] = {.lex_state = 1},
  [14] = {.lex_state = 1},
  [15] = {.lex_state = 1},
  [16] = {.lex_state = 1},
  [17] = {.lex_state = 1},
  [18] = {.lex_state = 1},
  [19] = {.lex_state = 3},
  [20] = {.lex_state = 3},
  [21] = {.lex_state = 3},
  [22] = {.lex_state = 3},
  [23] = {.lex_state = 3},
  [24] = {.lex_state = 1},
  [25] = {.lex_state = 1},
  [26] = {.lex_state = 1},
  [27] = {.lex_state = 1},
  [28] = {.lex_state = 1},
  [29] = {.lex_state = 1},
  [30] = {.lex_state = 1},
  [31] = {.lex_state = 1},
  [32] = {.lex_state = 1},
  [33] = {.lex_state = 1},
  [34] = {.lex_state = 1},
  [35] = {.lex_state = 1},
  [36] = {.lex_state = 1},
  [37] = {.lex_state = 1},
  [38] = {.lex_state = 1},
  [39] = {.lex_state = 1},
  [40] = {.lex_state = 1},
  [41] = {.lex_state = 1},
  [42] = {.lex_state = 1},
  [43] = {.lex_state = 1},
  [44] = {.lex_state = 1},
  [45] = {.lex_state = 1},
  [46] = {.lex_state = 1},
  [47] = {.lex_state = 1},
  [48] = {.lex_state = 1},
  [49] = {.lex_state = 1},
  [50] = {.lex_state = 1},
  [51] = {.lex_state = 1},
  [52] = {.lex_state = 1},
  [53] = {.lex_state = 1},
  [54] = {.lex_state = 1},
  [55] = {.lex_state = 1},
  [56] = {.lex_state = 1},
  [57] = {.lex_state = 1},
  [58] = {.lex_state = 1},
  [59] = {.lex_state = 6},
  [60] = {.lex_state = 6},
  [61] = {.lex_state = 6},
  [62] = {.lex_state = 6},
  [63] = {.lex_state = 6},
  [64] = {.lex_state = 6},
  [65] = {.lex_state = 6},
  [66] = {.lex_state = 6},
  [67] = {.lex_state = 6},
  [68] = {.lex_state = 6},
  [69] = {.lex_state = 6},
  [70] = {.lex_state = 6},
  [71] = {.lex_state = 6},
  [72] = {.lex_state = 6},
  [73] = {.lex_state = 6},
  [74] = {.lex_state = 6},
  [75] = {.lex_state = 6},
  [76] = {.lex_state = 6},
  [77] = {.lex_state = 6},
  [78] = {.lex_state = 6},
  [79] = {.lex_state = 6},
  [80] = {.lex_state = 6},
  [81] = {.lex_state = 4},
  [82] = {.lex_state = 0},
  [83] = {.lex_state = 0},
  [84] = {.lex_state = 6},
  [85] = {.lex_state = 1},
  [86] = {.lex_state = 0},
  [87] = {.lex_state = 1},
  [88] = {.lex_state = 1},
  [89] = {.lex_state = 38},
  [90] = {.lex_state = 1},
  [91] = {.lex_state = 38},
  [92] = {.lex_state = 38},
  [93] = {.lex_state = 38},
  [94] = {.lex_state = 1},
  [95] = {.lex_state = 38},
  [96] = {.lex_state = 38},
  [97] = {.lex_state = 1},
  [98] = {.lex_state = 38},
  [99] = {.lex_state = 38},
  [100] = {.lex_state = 1},
  [101] = {.lex_state = 1},
  [102] = {.lex_state = 38},
  [103] = {.lex_state = 38},
  [104] = {.lex_state = 1},
  [105] = {.lex_state = 1},
  [106] = {.lex_state = 38},
  [107] = {.lex_state = 38},
  [108] = {.lex_state = 1},
  [109] = {.lex_state = 1},
  [110] = {.lex_state = 1},
  [111] = {.lex_state = 38},
  [112] = {.lex_state = 38},
  [113] = {.lex_state = 38},
  [114] = {.lex_state = 38},
  [115] = {.lex_state = 1},
  [116] = {.lex_state = 38},
  [117] = {.lex_state = 38},
  [118] = {.lex_state = 38},
  [119] = {.lex_state = 38},
  [120] = {.lex_state = 1},
  [121] = {.lex_state = 1},
  [122] = {.lex_state = 38},
  [123] = {.lex_state = 1},
  [124] = {.lex_state = 38},
  [125] = {.lex_state = 38},
  [126] = {.lex_state = 38},
  [127] = {.lex_state = 1},
  [128] = {.lex_state = 1},
  [129] = {.lex_state = 38},
  [130] = {.lex_state = 1},
  [131] = {.lex_state = 38},
  [132] = {.lex_state = 1},
  [133] = {.lex_state = 38},
  [134] = {.lex_state = 38},
  [135] = {.lex_state = 1},
  [136] = {.lex_state = 1},
  [137] = {.lex_state = 38},
  [138] = {.lex_state = 38},
  [139] = {.lex_state = 38},
  [140] = {.lex_state = 1},
  [141] = {.lex_state = 38},
  [142] = {.lex_state = 38},
  [143] = {.lex_state = 38},
  [144] = {.lex_state = 38},
  [145] = {.lex_state = 1},
  [146] = {.lex_state = 38},
  [147] = {.lex_state = 38},
  [148] = {.lex_state = 1},
  [149] = {.lex_state = 38},
  [150] = {.lex_state = 38},
  [151] = {.lex_state = 1},
  [152] = {.lex_state = 1},
  [153] = {.lex_state = 38},
  [154] = {.lex_state = 38},
  [155] = {.lex_state = 1},
  [156] = {.lex_state = 38},
  [157] = {.lex_state = 1},
  [158] = {.lex_state = 0},
  [159] = {.lex_state = 1},
  [160] = {.lex_state = 1},
  [161] = {.lex_state = 38},
  [162] = {.lex_state = 38},
  [163] = {.lex_state = 1},
  [164] = {.lex_state = 38},
  [165] = {.lex_state = 38},
  [166] = {.lex_state = 38},
  [167] = {.lex_state = 1},
  [168] = {.lex_state = 38},
  [169] = {.lex_state = 38},
  [170] = {.lex_state = 38},
  [171] = {.lex_state = 1},
  [172] = {.lex_state = 1},
  [173] = {.lex_state = 38},
  [174] = {.lex_state = 0},
  [175] = {.lex_state = 1},
  [176] = {.lex_state = 38},
  [177] = {.lex_state = 38},
  [178] = {.lex_state = 38},
  [179] = {.lex_state = 38},
  [180] = {.lex_state = 38},
  [181] = {.lex_state = 1},
  [182] = {.lex_state = 38},
  [183] = {.lex_state = 38},
  [184] = {.lex_state = 1},
  [185] = {.lex_state = 38},
  [186] = {.lex_state = 38},
  [187] = {.lex_state = 38},
  [188] = {.lex_state = 1},
  [189] = {.lex_state = 38},
  [190] = {.lex_state = 38},
  [191] = {.lex_state = 38},
  [192] = {.lex_state = 1},
  [193] = {.lex_state = 38},
  [194] = {.lex_state = 38},
  [195] = {.lex_state = 1},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE_RBRACE] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_0] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_x_QMARK] = ACTIONS(1),
    [anon_sym_X_QMARK] = ACTIONS(1),
    [anon_sym_o] = ACTIONS(1),
    [anon_sym_x] = ACTIONS(1),
    [anon_sym_X] = ACTIONS(1),
    [anon_sym_p] = ACTIONS(1),
    [anon_sym_b] = ACTIONS(1),
    [anon_sym_e] = ACTIONS(1),
    [anon_sym_E] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
  },
  [1] = {
    [sym_format_string] = STATE(158),
    [sym_text] = ACTIONS(3),
  },
  [2] = {
    [sym_fill] = STATE(83),
    [sym_align] = STATE(5),
    [sym_sign] = STATE(11),
    [sym_type] = STATE(110),
    [sym_count] = STATE(30),
    [sym_parameter] = STATE(40),
    [sym_argument] = STATE(174),
    [anon_sym_POUND] = ACTIONS(5),
    [anon_sym_0] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(9),
    [anon_sym_RBRACE] = ACTIONS(11),
    [aux_sym_fill_token1] = ACTIONS(13),
    [anon_sym_LT] = ACTIONS(15),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_GT] = ACTIONS(15),
    [anon_sym_PLUS] = ACTIONS(17),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_QMARK] = ACTIONS(19),
    [anon_sym_x_QMARK] = ACTIONS(19),
    [anon_sym_X_QMARK] = ACTIONS(19),
    [anon_sym_o] = ACTIONS(19),
    [anon_sym_x] = ACTIONS(19),
    [anon_sym_X] = ACTIONS(19),
    [anon_sym_p] = ACTIONS(19),
    [anon_sym_b] = ACTIONS(19),
    [anon_sym_e] = ACTIONS(19),
    [anon_sym_E] = ACTIONS(19),
    [sym_integer] = ACTIONS(21),
    [sym_identifier] = ACTIONS(23),
  },
  [3] = {
    [sym_fill] = STATE(82),
    [sym_align] = STATE(6),
    [sym_sign] = STATE(9),
    [sym_type] = STATE(108),
    [sym_count] = STATE(26),
    [sym_parameter] = STATE(40),
    [sym_argument] = STATE(174),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_0] = ACTIONS(27),
    [anon_sym_DOT] = ACTIONS(29),
    [anon_sym_RBRACE] = ACTIONS(31),
    [aux_sym_fill_token1] = ACTIONS(13),
    [anon_sym_LT] = ACTIONS(15),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_GT] = ACTIONS(15),
    [anon_sym_PLUS] = ACTIONS(17),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_QMARK] = ACTIONS(19),
    [anon_sym_x_QMARK] = ACTIONS(19),
    [anon_sym_X_QMARK] = ACTIONS(19),
    [anon_sym_o] = ACTIONS(19),
    [anon_sym_x] = ACTIONS(19),
    [anon_sym_X] = ACTIONS(19),
    [anon_sym_p] = ACTIONS(19),
    [anon_sym_b] = ACTIONS(19),
    [anon_sym_e] = ACTIONS(19),
    [anon_sym_E] = ACTIONS(19),
    [sym_integer] = ACTIONS(21),
    [sym_identifier] = ACTIONS(23),
  },
  [4] = {
    [sym_sign] = STATE(12),
    [sym_type] = STATE(155),
    [sym_count] = STATE(33),
    [sym_parameter] = STATE(40),
    [sym_argument] = STATE(174),
    [anon_sym_POUND] = ACTIONS(33),
    [anon_sym_0] = ACTIONS(35),
    [anon_sym_DOT] = ACTIONS(37),
    [anon_sym_RBRACE] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(43),
    [anon_sym_x_QMARK] = ACTIONS(43),
    [anon_sym_X_QMARK] = ACTIONS(43),
    [anon_sym_o] = ACTIONS(19),
    [anon_sym_x] = ACTIONS(19),
    [anon_sym_X] = ACTIONS(19),
    [anon_sym_p] = ACTIONS(19),
    [anon_sym_b] = ACTIONS(19),
    [anon_sym_e] = ACTIONS(19),
    [anon_sym_E] = ACTIONS(19),
    [sym_integer] = ACTIONS(21),
    [sym_identifier] = ACTIONS(23),
  },
  [5] = {
    [sym_sign] = STATE(9),
    [sym_type] = STATE(108),
    [sym_count] = STATE(26),
    [sym_parameter] = STATE(40),
    [sym_argument] = STATE(174),
    [anon_sym_POUND] = ACTIONS(45),
    [anon_sym_0] = ACTIONS(47),
    [anon_sym_DOT] = ACTIONS(49),
    [anon_sym_RBRACE] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(43),
    [anon_sym_x_QMARK] = ACTIONS(43),
    [anon_sym_X_QMARK] = ACTIONS(43),
    [anon_sym_o] = ACTIONS(19),
    [anon_sym_x] = ACTIONS(19),
    [anon_sym_X] = ACTIONS(19),
    [anon_sym_p] = ACTIONS(19),
    [anon_sym_b] = ACTIONS(19),
    [anon_sym_e] = ACTIONS(19),
    [anon_sym_E] = ACTIONS(19),
    [sym_integer] = ACTIONS(21),
    [sym_identifier] = ACTIONS(23),
  },
  [6] = {
    [sym_sign] = STATE(10),
    [sym_type] = STATE(159),
    [sym_count] = STATE(29),
    [sym_parameter] = STATE(40),
    [sym_argument] = STATE(174),
    [anon_sym_POUND] = ACTIONS(53),
    [anon_sym_0] = ACTIONS(55),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_RBRACE] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(43),
    [anon_sym_x_QMARK] = ACTIONS(43),
    [anon_sym_X_QMARK] = ACTIONS(43),
    [anon_sym_o] = ACTIONS(19),
    [anon_sym_x] = ACTIONS(19),
    [anon_sym_X] = ACTIONS(19),
    [anon_sym_p] = ACTIONS(19),
    [anon_sym_b] = ACTIONS(19),
    [anon_sym_e] = ACTIONS(19),
    [anon_sym_E] = ACTIONS(19),
    [sym_integer] = ACTIONS(21),
    [sym_identifier] = ACTIONS(23),
  },
  [7] = {
    [sym_type] = STATE(130),
    [sym_count] = STATE(27),
    [sym_parameter] = STATE(40),
    [sym_argument] = STATE(174),
    [anon_sym_DOT] = ACTIONS(61),
    [anon_sym_RBRACE] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_GT] = ACTIONS(65),
    [anon_sym_QMARK] = ACTIONS(43),
    [anon_sym_x_QMARK] = ACTIONS(43),
    [anon_sym_X_QMARK] = ACTIONS(43),
    [anon_sym_o] = ACTIONS(19),
    [anon_sym_x] = ACTIONS(19),
    [anon_sym_X] = ACTIONS(19),
    [anon_sym_p] = ACTIONS(19),
    [anon_sym_b] = ACTIONS(19),
    [anon_sym_e] = ACTIONS(19),
    [anon_sym_E] = ACTIONS(19),
    [sym_integer] = ACTIONS(67),
    [sym_identifier] = ACTIONS(23),
  },
  [8] = {
    [sym_type] = STATE(151),
    [sym_count] = STATE(28),
    [sym_parameter] = STATE(40),
    [sym_argument] = STATE(174),
    [anon_sym_DOT] = ACTIONS(69),
    [anon_sym_RBRACE] = ACTIONS(71),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_GT] = ACTIONS(65),
    [anon_sym_QMARK] = ACTIONS(43),
    [anon_sym_x_QMARK] = ACTIONS(43),
    [anon_sym_X_QMARK] = ACTIONS(43),
    [anon_sym_o] = ACTIONS(19),
    [anon_sym_x] = ACTIONS(19),
    [anon_sym_X] = ACTIONS(19),
    [anon_sym_p] = ACTIONS(19),
    [anon_sym_b] = ACTIONS(19),
    [anon_sym_e] = ACTIONS(19),
    [anon_sym_E] = ACTIONS(19),
    [sym_integer] = ACTIONS(67),
    [sym_identifier] = ACTIONS(23),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 12,
    ACTIONS(21), 1,
      sym_integer,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(53), 1,
      anon_sym_POUND,
    ACTIONS(55), 1,
      anon_sym_0,
    ACTIONS(57), 1,
      anon_sym_DOT,
    ACTIONS(59), 1,
      anon_sym_RBRACE,
    STATE(29), 1,
      sym_count,
    STATE(40), 1,
      sym_parameter,
    STATE(159), 1,
      sym_type,
    STATE(174), 1,
      sym_argument,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 7,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
  [45] = 12,
    ACTIONS(21), 1,
      sym_integer,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(33), 1,
      anon_sym_POUND,
    ACTIONS(35), 1,
      anon_sym_0,
    ACTIONS(37), 1,
      anon_sym_DOT,
    ACTIONS(39), 1,
      anon_sym_RBRACE,
    STATE(33), 1,
      sym_count,
    STATE(40), 1,
      sym_parameter,
    STATE(155), 1,
      sym_type,
    STATE(174), 1,
      sym_argument,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 7,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
  [90] = 12,
    ACTIONS(21), 1,
      sym_integer,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(47), 1,
      anon_sym_0,
    ACTIONS(49), 1,
      anon_sym_DOT,
    ACTIONS(51), 1,
      anon_sym_RBRACE,
    STATE(26), 1,
      sym_count,
    STATE(40), 1,
      sym_parameter,
    STATE(108), 1,
      sym_type,
    STATE(174), 1,
      sym_argument,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 7,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
  [135] = 12,
    ACTIONS(21), 1,
      sym_integer,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_0,
    ACTIONS(77), 1,
      anon_sym_DOT,
    ACTIONS(79), 1,
      anon_sym_RBRACE,
    STATE(35), 1,
      sym_count,
    STATE(40), 1,
      sym_parameter,
    STATE(105), 1,
      sym_type,
    STATE(174), 1,
      sym_argument,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 7,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
  [180] = 11,
    ACTIONS(21), 1,
      sym_integer,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_0,
    ACTIONS(37), 1,
      anon_sym_DOT,
    ACTIONS(39), 1,
      anon_sym_RBRACE,
    STATE(33), 1,
      sym_count,
    STATE(40), 1,
      sym_parameter,
    STATE(155), 1,
      sym_type,
    STATE(174), 1,
      sym_argument,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 7,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
  [222] = 11,
    ACTIONS(21), 1,
      sym_integer,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(55), 1,
      anon_sym_0,
    ACTIONS(57), 1,
      anon_sym_DOT,
    ACTIONS(59), 1,
      anon_sym_RBRACE,
    STATE(29), 1,
      sym_count,
    STATE(40), 1,
      sym_parameter,
    STATE(159), 1,
      sym_type,
    STATE(174), 1,
      sym_argument,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 7,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
  [264] = 11,
    ACTIONS(21), 1,
      sym_integer,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(47), 1,
      anon_sym_0,
    ACTIONS(49), 1,
      anon_sym_DOT,
    ACTIONS(51), 1,
      anon_sym_RBRACE,
    STATE(26), 1,
      sym_count,
    STATE(40), 1,
      sym_parameter,
    STATE(108), 1,
      sym_type,
    STATE(174), 1,
      sym_argument,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 7,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
  [306] = 11,
    ACTIONS(21), 1,
      sym_integer,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_0,
    ACTIONS(83), 1,
      anon_sym_DOT,
    ACTIONS(85), 1,
      anon_sym_RBRACE,
    STATE(36), 1,
      sym_count,
    STATE(40), 1,
      sym_parameter,
    STATE(135), 1,
      sym_type,
    STATE(174), 1,
      sym_argument,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 7,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
  [348] = 11,
    ACTIONS(21), 1,
      sym_integer,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(75), 1,
      anon_sym_0,
    ACTIONS(77), 1,
      anon_sym_DOT,
    ACTIONS(79), 1,
      anon_sym_RBRACE,
    STATE(35), 1,
      sym_count,
    STATE(40), 1,
      sym_parameter,
    STATE(105), 1,
      sym_type,
    STATE(174), 1,
      sym_argument,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 7,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
  [390] = 2,
    ACTIONS(87), 8,
      anon_sym_POUND,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(89), 10,
      anon_sym_0,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_integer,
      sym_identifier,
  [413] = 10,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(61), 1,
      anon_sym_DOT,
    ACTIONS(63), 1,
      anon_sym_RBRACE,
    ACTIONS(67), 1,
      sym_integer,
    STATE(27), 1,
      sym_count,
    STATE(40), 1,
      sym_parameter,
    STATE(130), 1,
      sym_type,
    STATE(174), 1,
      sym_argument,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 7,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
  [452] = 10,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(67), 1,
      sym_integer,
    ACTIONS(91), 1,
      anon_sym_DOT,
    ACTIONS(93), 1,
      anon_sym_RBRACE,
    STATE(32), 1,
      sym_count,
    STATE(40), 1,
      sym_parameter,
    STATE(172), 1,
      sym_type,
    STATE(174), 1,
      sym_argument,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 7,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
  [491] = 10,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(67), 1,
      sym_integer,
    ACTIONS(95), 1,
      anon_sym_DOT,
    ACTIONS(97), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      sym_count,
    STATE(40), 1,
      sym_parameter,
    STATE(132), 1,
      sym_type,
    STATE(174), 1,
      sym_argument,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 7,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
  [530] = 10,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(67), 1,
      sym_integer,
    ACTIONS(99), 1,
      anon_sym_DOT,
    ACTIONS(101), 1,
      anon_sym_RBRACE,
    STATE(31), 1,
      sym_count,
    STATE(40), 1,
      sym_parameter,
    STATE(100), 1,
      sym_type,
    STATE(174), 1,
      sym_argument,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 7,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
  [569] = 10,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(67), 1,
      sym_integer,
    ACTIONS(103), 1,
      anon_sym_DOT,
    ACTIONS(105), 1,
      anon_sym_RBRACE,
    STATE(37), 1,
      sym_count,
    STATE(40), 1,
      sym_parameter,
    STATE(157), 1,
      sym_type,
    STATE(174), 1,
      sym_argument,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 7,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
  [608] = 2,
    ACTIONS(107), 6,
      anon_sym_POUND,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(109), 10,
      anon_sym_0,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_integer,
      sym_identifier,
  [629] = 3,
    ACTIONS(115), 1,
      anon_sym_DOLLAR,
    ACTIONS(111), 5,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(113), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [650] = 5,
    ACTIONS(57), 1,
      anon_sym_DOT,
    ACTIONS(59), 1,
      anon_sym_RBRACE,
    STATE(159), 1,
      sym_type,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [675] = 5,
    ACTIONS(117), 1,
      anon_sym_DOT,
    ACTIONS(119), 1,
      anon_sym_RBRACE,
    STATE(120), 1,
      sym_type,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [700] = 5,
    ACTIONS(121), 1,
      anon_sym_DOT,
    ACTIONS(123), 1,
      anon_sym_RBRACE,
    STATE(90), 1,
      sym_type,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [725] = 5,
    ACTIONS(37), 1,
      anon_sym_DOT,
    ACTIONS(39), 1,
      anon_sym_RBRACE,
    STATE(155), 1,
      sym_type,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [750] = 5,
    ACTIONS(49), 1,
      anon_sym_DOT,
    ACTIONS(51), 1,
      anon_sym_RBRACE,
    STATE(108), 1,
      sym_type,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [775] = 5,
    ACTIONS(125), 1,
      anon_sym_DOT,
    ACTIONS(127), 1,
      anon_sym_RBRACE,
    STATE(121), 1,
      sym_type,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [800] = 5,
    ACTIONS(129), 1,
      anon_sym_DOT,
    ACTIONS(131), 1,
      anon_sym_RBRACE,
    STATE(109), 1,
      sym_type,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [825] = 5,
    ACTIONS(77), 1,
      anon_sym_DOT,
    ACTIONS(79), 1,
      anon_sym_RBRACE,
    STATE(105), 1,
      sym_type,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [850] = 5,
    ACTIONS(133), 1,
      anon_sym_DOT,
    ACTIONS(135), 1,
      anon_sym_RBRACE,
    STATE(152), 1,
      sym_type,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [875] = 5,
    ACTIONS(83), 1,
      anon_sym_DOT,
    ACTIONS(85), 1,
      anon_sym_RBRACE,
    STATE(135), 1,
      sym_type,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [900] = 5,
    ACTIONS(137), 1,
      anon_sym_DOT,
    ACTIONS(139), 1,
      anon_sym_RBRACE,
    STATE(160), 1,
      sym_type,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [925] = 5,
    ACTIONS(141), 1,
      anon_sym_DOT,
    ACTIONS(143), 1,
      anon_sym_RBRACE,
    STATE(175), 1,
      sym_type,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [950] = 4,
    ACTIONS(145), 1,
      anon_sym_RBRACE,
    STATE(94), 1,
      sym_type,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [972] = 4,
    ACTIONS(147), 1,
      anon_sym_RBRACE,
    STATE(192), 1,
      sym_type,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [994] = 2,
    ACTIONS(149), 5,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(151), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [1012] = 4,
    ACTIONS(153), 1,
      anon_sym_RBRACE,
    STATE(145), 1,
      sym_type,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [1034] = 4,
    ACTIONS(155), 1,
      anon_sym_RBRACE,
    STATE(97), 1,
      sym_type,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [1056] = 4,
    ACTIONS(157), 1,
      anon_sym_RBRACE,
    STATE(101), 1,
      sym_type,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [1078] = 4,
    ACTIONS(159), 1,
      anon_sym_RBRACE,
    STATE(115), 1,
      sym_type,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [1100] = 4,
    ACTIONS(161), 1,
      anon_sym_RBRACE,
    STATE(123), 1,
      sym_type,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [1122] = 4,
    ACTIONS(163), 1,
      anon_sym_RBRACE,
    STATE(127), 1,
      sym_type,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [1144] = 2,
    ACTIONS(165), 5,
      anon_sym_DOT,
      anon_sym_RBRACE,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(167), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [1162] = 4,
    ACTIONS(169), 1,
      anon_sym_RBRACE,
    STATE(140), 1,
      sym_type,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [1184] = 4,
    ACTIONS(171), 1,
      anon_sym_RBRACE,
    STATE(195), 1,
      sym_type,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [1206] = 4,
    ACTIONS(173), 1,
      anon_sym_RBRACE,
    STATE(148), 1,
      sym_type,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [1228] = 4,
    ACTIONS(175), 1,
      anon_sym_RBRACE,
    STATE(128), 1,
      sym_type,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [1250] = 4,
    ACTIONS(177), 1,
      anon_sym_RBRACE,
    STATE(163), 1,
      sym_type,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [1272] = 4,
    ACTIONS(179), 1,
      anon_sym_RBRACE,
    STATE(167), 1,
      sym_type,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [1294] = 4,
    ACTIONS(181), 1,
      anon_sym_RBRACE,
    STATE(171), 1,
      sym_type,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [1316] = 4,
    ACTIONS(183), 1,
      anon_sym_RBRACE,
    STATE(181), 1,
      sym_type,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [1338] = 4,
    ACTIONS(185), 1,
      anon_sym_RBRACE,
    STATE(184), 1,
      sym_type,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [1360] = 4,
    ACTIONS(187), 1,
      anon_sym_RBRACE,
    STATE(188), 1,
      sym_type,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [1382] = 4,
    ACTIONS(189), 1,
      anon_sym_RBRACE,
    STATE(136), 1,
      sym_type,
    ACTIONS(43), 3,
      anon_sym_QMARK,
      anon_sym_x_QMARK,
      anon_sym_X_QMARK,
    ACTIONS(19), 8,
      anon_sym_o,
      anon_sym_x,
      anon_sym_X,
      anon_sym_p,
      anon_sym_b,
      anon_sym_e,
      anon_sym_E,
      sym_identifier,
  [1404] = 6,
    ACTIONS(67), 1,
      sym_integer,
    ACTIONS(191), 1,
      anon_sym_STAR,
    ACTIONS(193), 1,
      sym_identifier,
    STATE(40), 1,
      sym_parameter,
    STATE(50), 1,
      sym_count,
    STATE(174), 1,
      sym_argument,
  [1423] = 6,
    ACTIONS(67), 1,
      sym_integer,
    ACTIONS(193), 1,
      sym_identifier,
    ACTIONS(195), 1,
      anon_sym_STAR,
    STATE(40), 1,
      sym_parameter,
    STATE(42), 1,
      sym_count,
    STATE(174), 1,
      sym_argument,
  [1442] = 6,
    ACTIONS(67), 1,
      sym_integer,
    ACTIONS(193), 1,
      sym_identifier,
    ACTIONS(197), 1,
      anon_sym_STAR,
    STATE(40), 1,
      sym_parameter,
    STATE(49), 1,
      sym_count,
    STATE(174), 1,
      sym_argument,
  [1461] = 6,
    ACTIONS(67), 1,
      sym_integer,
    ACTIONS(193), 1,
      sym_identifier,
    ACTIONS(199), 1,
      anon_sym_STAR,
    STATE(40), 1,
      sym_parameter,
    STATE(44), 1,
      sym_count,
    STATE(174), 1,
      sym_argument,
  [1480] = 5,
    ACTIONS(201), 1,
      ts_builtin_sym_end,
    ACTIONS(205), 1,
      anon_sym_LBRACE,
    STATE(72), 1,
      aux_sym_format_string_repeat1,
    STATE(179), 1,
      sym_format,
    ACTIONS(203), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_RBRACE_RBRACE,
  [1497] = 6,
    ACTIONS(67), 1,
      sym_integer,
    ACTIONS(193), 1,
      sym_identifier,
    ACTIONS(207), 1,
      anon_sym_STAR,
    STATE(40), 1,
      sym_parameter,
    STATE(53), 1,
      sym_count,
    STATE(174), 1,
      sym_argument,
  [1516] = 5,
    ACTIONS(209), 1,
      ts_builtin_sym_end,
    ACTIONS(214), 1,
      anon_sym_LBRACE,
    STATE(65), 1,
      aux_sym_format_string_repeat1,
    STATE(179), 1,
      sym_format,
    ACTIONS(211), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_RBRACE_RBRACE,
  [1533] = 6,
    ACTIONS(67), 1,
      sym_integer,
    ACTIONS(193), 1,
      sym_identifier,
    ACTIONS(217), 1,
      anon_sym_STAR,
    STATE(40), 1,
      sym_parameter,
    STATE(52), 1,
      sym_count,
    STATE(174), 1,
      sym_argument,
  [1552] = 6,
    ACTIONS(67), 1,
      sym_integer,
    ACTIONS(193), 1,
      sym_identifier,
    ACTIONS(219), 1,
      anon_sym_STAR,
    STATE(40), 1,
      sym_parameter,
    STATE(43), 1,
      sym_count,
    STATE(174), 1,
      sym_argument,
  [1571] = 6,
    ACTIONS(67), 1,
      sym_integer,
    ACTIONS(193), 1,
      sym_identifier,
    ACTIONS(221), 1,
      anon_sym_STAR,
    STATE(40), 1,
      sym_parameter,
    STATE(45), 1,
      sym_count,
    STATE(174), 1,
      sym_argument,
  [1590] = 6,
    ACTIONS(67), 1,
      sym_integer,
    ACTIONS(193), 1,
      sym_identifier,
    ACTIONS(223), 1,
      anon_sym_STAR,
    STATE(40), 1,
      sym_parameter,
    STATE(58), 1,
      sym_count,
    STATE(174), 1,
      sym_argument,
  [1609] = 6,
    ACTIONS(67), 1,
      sym_integer,
    ACTIONS(193), 1,
      sym_identifier,
    ACTIONS(225), 1,
      anon_sym_STAR,
    STATE(40), 1,
      sym_parameter,
    STATE(41), 1,
      sym_count,
    STATE(174), 1,
      sym_argument,
  [1628] = 6,
    ACTIONS(67), 1,
      sym_integer,
    ACTIONS(193), 1,
      sym_identifier,
    ACTIONS(227), 1,
      anon_sym_STAR,
    STATE(40), 1,
      sym_parameter,
    STATE(54), 1,
      sym_count,
    STATE(174), 1,
      sym_argument,
  [1647] = 5,
    ACTIONS(205), 1,
      anon_sym_LBRACE,
    ACTIONS(229), 1,
      ts_builtin_sym_end,
    STATE(65), 1,
      aux_sym_format_string_repeat1,
    STATE(179), 1,
      sym_format,
    ACTIONS(203), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_RBRACE_RBRACE,
  [1664] = 6,
    ACTIONS(67), 1,
      sym_integer,
    ACTIONS(193), 1,
      sym_identifier,
    ACTIONS(231), 1,
      anon_sym_STAR,
    STATE(40), 1,
      sym_parameter,
    STATE(51), 1,
      sym_count,
    STATE(174), 1,
      sym_argument,
  [1683] = 6,
    ACTIONS(67), 1,
      sym_integer,
    ACTIONS(193), 1,
      sym_identifier,
    ACTIONS(233), 1,
      anon_sym_STAR,
    STATE(40), 1,
      sym_parameter,
    STATE(46), 1,
      sym_count,
    STATE(174), 1,
      sym_argument,
  [1702] = 6,
    ACTIONS(67), 1,
      sym_integer,
    ACTIONS(193), 1,
      sym_identifier,
    ACTIONS(235), 1,
      anon_sym_STAR,
    STATE(38), 1,
      sym_count,
    STATE(40), 1,
      sym_parameter,
    STATE(174), 1,
      sym_argument,
  [1721] = 6,
    ACTIONS(67), 1,
      sym_integer,
    ACTIONS(193), 1,
      sym_identifier,
    ACTIONS(237), 1,
      anon_sym_STAR,
    STATE(40), 1,
      sym_parameter,
    STATE(55), 1,
      sym_count,
    STATE(174), 1,
      sym_argument,
  [1740] = 6,
    ACTIONS(67), 1,
      sym_integer,
    ACTIONS(193), 1,
      sym_identifier,
    ACTIONS(239), 1,
      anon_sym_STAR,
    STATE(39), 1,
      sym_count,
    STATE(40), 1,
      sym_parameter,
    STATE(174), 1,
      sym_argument,
  [1759] = 6,
    ACTIONS(67), 1,
      sym_integer,
    ACTIONS(193), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_STAR,
    STATE(40), 1,
      sym_parameter,
    STATE(56), 1,
      sym_count,
    STATE(174), 1,
      sym_argument,
  [1778] = 6,
    ACTIONS(67), 1,
      sym_integer,
    ACTIONS(193), 1,
      sym_identifier,
    ACTIONS(243), 1,
      anon_sym_STAR,
    STATE(40), 1,
      sym_parameter,
    STATE(57), 1,
      sym_count,
    STATE(174), 1,
      sym_argument,
  [1797] = 6,
    ACTIONS(67), 1,
      sym_integer,
    ACTIONS(193), 1,
      sym_identifier,
    ACTIONS(245), 1,
      anon_sym_STAR,
    STATE(40), 1,
      sym_parameter,
    STATE(48), 1,
      sym_count,
    STATE(174), 1,
      sym_argument,
  [1816] = 4,
    ACTIONS(247), 1,
      anon_sym_COLON,
    ACTIONS(249), 1,
      anon_sym_RBRACE,
    STATE(88), 1,
      sym_argument,
    ACTIONS(193), 2,
      sym_integer,
      sym_identifier,
  [1830] = 2,
    STATE(4), 1,
      sym_align,
    ACTIONS(251), 3,
      anon_sym_LT,
      anon_sym_CARET,
      anon_sym_GT,
  [1839] = 2,
    STATE(6), 1,
      sym_align,
    ACTIONS(251), 3,
      anon_sym_LT,
      anon_sym_CARET,
      anon_sym_GT,
  [1848] = 2,
    ACTIONS(253), 1,
      anon_sym_LBRACE,
    ACTIONS(209), 3,
      ts_builtin_sym_end,
      anon_sym_LBRACE_LBRACE,
      anon_sym_RBRACE_RBRACE,
  [1857] = 1,
    ACTIONS(115), 3,
      anon_sym_COLON,
      anon_sym_RBRACE,
      anon_sym_DOLLAR,
  [1863] = 1,
    ACTIONS(65), 3,
      anon_sym_LT,
      anon_sym_CARET,
      anon_sym_GT,
  [1869] = 2,
    ACTIONS(115), 1,
      anon_sym_DOLLAR,
    ACTIONS(255), 1,
      anon_sym_RBRACE,
  [1876] = 2,
    ACTIONS(257), 1,
      anon_sym_COLON,
    ACTIONS(259), 1,
      anon_sym_RBRACE,
  [1883] = 1,
    ACTIONS(261), 1,
      sym_text,
  [1887] = 1,
    ACTIONS(263), 1,
      anon_sym_RBRACE,
  [1891] = 1,
    ACTIONS(265), 1,
      sym_text,
  [1895] = 1,
    ACTIONS(267), 1,
      sym_text,
  [1899] = 1,
    ACTIONS(269), 1,
      sym_text,
  [1903] = 1,
    ACTIONS(271), 1,
      anon_sym_RBRACE,
  [1907] = 1,
    ACTIONS(273), 1,
      sym_text,
  [1911] = 1,
    ACTIONS(275), 1,
      sym_text,
  [1915] = 1,
    ACTIONS(277), 1,
      anon_sym_RBRACE,
  [1919] = 1,
    ACTIONS(279), 1,
      sym_text,
  [1923] = 1,
    ACTIONS(281), 1,
      sym_text,
  [1927] = 1,
    ACTIONS(127), 1,
      anon_sym_RBRACE,
  [1931] = 1,
    ACTIONS(283), 1,
      anon_sym_RBRACE,
  [1935] = 1,
    ACTIONS(285), 1,
      sym_text,
  [1939] = 1,
    ACTIONS(287), 1,
      sym_text,
  [1943] = 1,
    ACTIONS(255), 1,
      anon_sym_RBRACE,
  [1947] = 1,
    ACTIONS(85), 1,
      anon_sym_RBRACE,
  [1951] = 1,
    ACTIONS(289), 1,
      sym_text,
  [1955] = 1,
    ACTIONS(291), 1,
      sym_text,
  [1959] = 1,
    ACTIONS(59), 1,
      anon_sym_RBRACE,
  [1963] = 1,
    ACTIONS(293), 1,
      anon_sym_RBRACE,
  [1967] = 1,
    ACTIONS(51), 1,
      anon_sym_RBRACE,
  [1971] = 1,
    ACTIONS(295), 1,
      sym_text,
  [1975] = 1,
    ACTIONS(297), 1,
      sym_text,
  [1979] = 1,
    ACTIONS(299), 1,
      sym_text,
  [1983] = 1,
    ACTIONS(301), 1,
      sym_text,
  [1987] = 1,
    ACTIONS(303), 1,
      anon_sym_RBRACE,
  [1991] = 1,
    ACTIONS(305), 1,
      sym_text,
  [1995] = 1,
    ACTIONS(307), 1,
      sym_text,
  [1999] = 1,
    ACTIONS(309), 1,
      sym_text,
  [2003] = 1,
    ACTIONS(311), 1,
      sym_text,
  [2007] = 1,
    ACTIONS(313), 1,
      anon_sym_RBRACE,
  [2011] = 1,
    ACTIONS(315), 1,
      anon_sym_RBRACE,
  [2015] = 1,
    ACTIONS(317), 1,
      sym_text,
  [2019] = 1,
    ACTIONS(319), 1,
      anon_sym_RBRACE,
  [2023] = 1,
    ACTIONS(321), 1,
      sym_text,
  [2027] = 1,
    ACTIONS(323), 1,
      sym_text,
  [2031] = 1,
    ACTIONS(325), 1,
      sym_text,
  [2035] = 1,
    ACTIONS(327), 1,
      anon_sym_RBRACE,
  [2039] = 1,
    ACTIONS(329), 1,
      anon_sym_RBRACE,
  [2043] = 1,
    ACTIONS(331), 1,
      sym_text,
  [2047] = 1,
    ACTIONS(119), 1,
      anon_sym_RBRACE,
  [2051] = 1,
    ACTIONS(333), 1,
      sym_text,
  [2055] = 1,
    ACTIONS(135), 1,
      anon_sym_RBRACE,
  [2059] = 1,
    ACTIONS(335), 1,
      sym_text,
  [2063] = 1,
    ACTIONS(337), 1,
      sym_text,
  [2067] = 1,
    ACTIONS(139), 1,
      anon_sym_RBRACE,
  [2071] = 1,
    ACTIONS(339), 1,
      anon_sym_RBRACE,
  [2075] = 1,
    ACTIONS(341), 1,
      sym_text,
  [2079] = 1,
    ACTIONS(343), 1,
      sym_text,
  [2083] = 1,
    ACTIONS(345), 1,
      sym_text,
  [2087] = 1,
    ACTIONS(347), 1,
      anon_sym_RBRACE,
  [2091] = 1,
    ACTIONS(349), 1,
      sym_text,
  [2095] = 1,
    ACTIONS(351), 1,
      sym_text,
  [2099] = 1,
    ACTIONS(353), 1,
      sym_text,
  [2103] = 1,
    ACTIONS(355), 1,
      sym_text,
  [2107] = 1,
    ACTIONS(357), 1,
      anon_sym_RBRACE,
  [2111] = 1,
    ACTIONS(359), 1,
      sym_text,
  [2115] = 1,
    ACTIONS(361), 1,
      sym_text,
  [2119] = 1,
    ACTIONS(363), 1,
      anon_sym_RBRACE,
  [2123] = 1,
    ACTIONS(365), 1,
      sym_text,
  [2127] = 1,
    ACTIONS(367), 1,
      sym_text,
  [2131] = 1,
    ACTIONS(123), 1,
      anon_sym_RBRACE,
  [2135] = 1,
    ACTIONS(369), 1,
      anon_sym_RBRACE,
  [2139] = 1,
    ACTIONS(371), 1,
      sym_text,
  [2143] = 1,
    ACTIONS(373), 1,
      sym_text,
  [2147] = 1,
    ACTIONS(79), 1,
      anon_sym_RBRACE,
  [2151] = 1,
    ACTIONS(375), 1,
      sym_text,
  [2155] = 1,
    ACTIONS(143), 1,
      anon_sym_RBRACE,
  [2159] = 1,
    ACTIONS(377), 1,
      ts_builtin_sym_end,
  [2163] = 1,
    ACTIONS(39), 1,
      anon_sym_RBRACE,
  [2167] = 1,
    ACTIONS(379), 1,
      anon_sym_RBRACE,
  [2171] = 1,
    ACTIONS(381), 1,
      sym_text,
  [2175] = 1,
    ACTIONS(383), 1,
      sym_text,
  [2179] = 1,
    ACTIONS(385), 1,
      anon_sym_RBRACE,
  [2183] = 1,
    ACTIONS(387), 1,
      sym_text,
  [2187] = 1,
    ACTIONS(389), 1,
      sym_text,
  [2191] = 1,
    ACTIONS(391), 1,
      sym_text,
  [2195] = 1,
    ACTIONS(393), 1,
      anon_sym_RBRACE,
  [2199] = 1,
    ACTIONS(395), 1,
      sym_text,
  [2203] = 1,
    ACTIONS(397), 1,
      sym_text,
  [2207] = 1,
    ACTIONS(399), 1,
      sym_text,
  [2211] = 1,
    ACTIONS(401), 1,
      anon_sym_RBRACE,
  [2215] = 1,
    ACTIONS(131), 1,
      anon_sym_RBRACE,
  [2219] = 1,
    ACTIONS(403), 1,
      sym_text,
  [2223] = 1,
    ACTIONS(405), 1,
      anon_sym_DOLLAR,
  [2227] = 1,
    ACTIONS(407), 1,
      anon_sym_RBRACE,
  [2231] = 1,
    ACTIONS(409), 1,
      sym_text,
  [2235] = 1,
    ACTIONS(411), 1,
      sym_text,
  [2239] = 1,
    ACTIONS(413), 1,
      sym_text,
  [2243] = 1,
    ACTIONS(415), 1,
      sym_text,
  [2247] = 1,
    ACTIONS(417), 1,
      sym_text,
  [2251] = 1,
    ACTIONS(419), 1,
      anon_sym_RBRACE,
  [2255] = 1,
    ACTIONS(421), 1,
      sym_text,
  [2259] = 1,
    ACTIONS(423), 1,
      sym_text,
  [2263] = 1,
    ACTIONS(425), 1,
      anon_sym_RBRACE,
  [2267] = 1,
    ACTIONS(427), 1,
      sym_text,
  [2271] = 1,
    ACTIONS(429), 1,
      sym_text,
  [2275] = 1,
    ACTIONS(431), 1,
      sym_text,
  [2279] = 1,
    ACTIONS(433), 1,
      anon_sym_RBRACE,
  [2283] = 1,
    ACTIONS(435), 1,
      sym_text,
  [2287] = 1,
    ACTIONS(437), 1,
      sym_text,
  [2291] = 1,
    ACTIONS(439), 1,
      sym_text,
  [2295] = 1,
    ACTIONS(441), 1,
      anon_sym_RBRACE,
  [2299] = 1,
    ACTIONS(443), 1,
      sym_text,
  [2303] = 1,
    ACTIONS(445), 1,
      sym_text,
  [2307] = 1,
    ACTIONS(447), 1,
      anon_sym_RBRACE,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(9)] = 0,
  [SMALL_STATE(10)] = 45,
  [SMALL_STATE(11)] = 90,
  [SMALL_STATE(12)] = 135,
  [SMALL_STATE(13)] = 180,
  [SMALL_STATE(14)] = 222,
  [SMALL_STATE(15)] = 264,
  [SMALL_STATE(16)] = 306,
  [SMALL_STATE(17)] = 348,
  [SMALL_STATE(18)] = 390,
  [SMALL_STATE(19)] = 413,
  [SMALL_STATE(20)] = 452,
  [SMALL_STATE(21)] = 491,
  [SMALL_STATE(22)] = 530,
  [SMALL_STATE(23)] = 569,
  [SMALL_STATE(24)] = 608,
  [SMALL_STATE(25)] = 629,
  [SMALL_STATE(26)] = 650,
  [SMALL_STATE(27)] = 675,
  [SMALL_STATE(28)] = 700,
  [SMALL_STATE(29)] = 725,
  [SMALL_STATE(30)] = 750,
  [SMALL_STATE(31)] = 775,
  [SMALL_STATE(32)] = 800,
  [SMALL_STATE(33)] = 825,
  [SMALL_STATE(34)] = 850,
  [SMALL_STATE(35)] = 875,
  [SMALL_STATE(36)] = 900,
  [SMALL_STATE(37)] = 925,
  [SMALL_STATE(38)] = 950,
  [SMALL_STATE(39)] = 972,
  [SMALL_STATE(40)] = 994,
  [SMALL_STATE(41)] = 1012,
  [SMALL_STATE(42)] = 1034,
  [SMALL_STATE(43)] = 1056,
  [SMALL_STATE(44)] = 1078,
  [SMALL_STATE(45)] = 1100,
  [SMALL_STATE(46)] = 1122,
  [SMALL_STATE(47)] = 1144,
  [SMALL_STATE(48)] = 1162,
  [SMALL_STATE(49)] = 1184,
  [SMALL_STATE(50)] = 1206,
  [SMALL_STATE(51)] = 1228,
  [SMALL_STATE(52)] = 1250,
  [SMALL_STATE(53)] = 1272,
  [SMALL_STATE(54)] = 1294,
  [SMALL_STATE(55)] = 1316,
  [SMALL_STATE(56)] = 1338,
  [SMALL_STATE(57)] = 1360,
  [SMALL_STATE(58)] = 1382,
  [SMALL_STATE(59)] = 1404,
  [SMALL_STATE(60)] = 1423,
  [SMALL_STATE(61)] = 1442,
  [SMALL_STATE(62)] = 1461,
  [SMALL_STATE(63)] = 1480,
  [SMALL_STATE(64)] = 1497,
  [SMALL_STATE(65)] = 1516,
  [SMALL_STATE(66)] = 1533,
  [SMALL_STATE(67)] = 1552,
  [SMALL_STATE(68)] = 1571,
  [SMALL_STATE(69)] = 1590,
  [SMALL_STATE(70)] = 1609,
  [SMALL_STATE(71)] = 1628,
  [SMALL_STATE(72)] = 1647,
  [SMALL_STATE(73)] = 1664,
  [SMALL_STATE(74)] = 1683,
  [SMALL_STATE(75)] = 1702,
  [SMALL_STATE(76)] = 1721,
  [SMALL_STATE(77)] = 1740,
  [SMALL_STATE(78)] = 1759,
  [SMALL_STATE(79)] = 1778,
  [SMALL_STATE(80)] = 1797,
  [SMALL_STATE(81)] = 1816,
  [SMALL_STATE(82)] = 1830,
  [SMALL_STATE(83)] = 1839,
  [SMALL_STATE(84)] = 1848,
  [SMALL_STATE(85)] = 1857,
  [SMALL_STATE(86)] = 1863,
  [SMALL_STATE(87)] = 1869,
  [SMALL_STATE(88)] = 1876,
  [SMALL_STATE(89)] = 1883,
  [SMALL_STATE(90)] = 1887,
  [SMALL_STATE(91)] = 1891,
  [SMALL_STATE(92)] = 1895,
  [SMALL_STATE(93)] = 1899,
  [SMALL_STATE(94)] = 1903,
  [SMALL_STATE(95)] = 1907,
  [SMALL_STATE(96)] = 1911,
  [SMALL_STATE(97)] = 1915,
  [SMALL_STATE(98)] = 1919,
  [SMALL_STATE(99)] = 1923,
  [SMALL_STATE(100)] = 1927,
  [SMALL_STATE(101)] = 1931,
  [SMALL_STATE(102)] = 1935,
  [SMALL_STATE(103)] = 1939,
  [SMALL_STATE(104)] = 1943,
  [SMALL_STATE(105)] = 1947,
  [SMALL_STATE(106)] = 1951,
  [SMALL_STATE(107)] = 1955,
  [SMALL_STATE(108)] = 1959,
  [SMALL_STATE(109)] = 1963,
  [SMALL_STATE(110)] = 1967,
  [SMALL_STATE(111)] = 1971,
  [SMALL_STATE(112)] = 1975,
  [SMALL_STATE(113)] = 1979,
  [SMALL_STATE(114)] = 1983,
  [SMALL_STATE(115)] = 1987,
  [SMALL_STATE(116)] = 1991,
  [SMALL_STATE(117)] = 1995,
  [SMALL_STATE(118)] = 1999,
  [SMALL_STATE(119)] = 2003,
  [SMALL_STATE(120)] = 2007,
  [SMALL_STATE(121)] = 2011,
  [SMALL_STATE(122)] = 2015,
  [SMALL_STATE(123)] = 2019,
  [SMALL_STATE(124)] = 2023,
  [SMALL_STATE(125)] = 2027,
  [SMALL_STATE(126)] = 2031,
  [SMALL_STATE(127)] = 2035,
  [SMALL_STATE(128)] = 2039,
  [SMALL_STATE(129)] = 2043,
  [SMALL_STATE(130)] = 2047,
  [SMALL_STATE(131)] = 2051,
  [SMALL_STATE(132)] = 2055,
  [SMALL_STATE(133)] = 2059,
  [SMALL_STATE(134)] = 2063,
  [SMALL_STATE(135)] = 2067,
  [SMALL_STATE(136)] = 2071,
  [SMALL_STATE(137)] = 2075,
  [SMALL_STATE(138)] = 2079,
  [SMALL_STATE(139)] = 2083,
  [SMALL_STATE(140)] = 2087,
  [SMALL_STATE(141)] = 2091,
  [SMALL_STATE(142)] = 2095,
  [SMALL_STATE(143)] = 2099,
  [SMALL_STATE(144)] = 2103,
  [SMALL_STATE(145)] = 2107,
  [SMALL_STATE(146)] = 2111,
  [SMALL_STATE(147)] = 2115,
  [SMALL_STATE(148)] = 2119,
  [SMALL_STATE(149)] = 2123,
  [SMALL_STATE(150)] = 2127,
  [SMALL_STATE(151)] = 2131,
  [SMALL_STATE(152)] = 2135,
  [SMALL_STATE(153)] = 2139,
  [SMALL_STATE(154)] = 2143,
  [SMALL_STATE(155)] = 2147,
  [SMALL_STATE(156)] = 2151,
  [SMALL_STATE(157)] = 2155,
  [SMALL_STATE(158)] = 2159,
  [SMALL_STATE(159)] = 2163,
  [SMALL_STATE(160)] = 2167,
  [SMALL_STATE(161)] = 2171,
  [SMALL_STATE(162)] = 2175,
  [SMALL_STATE(163)] = 2179,
  [SMALL_STATE(164)] = 2183,
  [SMALL_STATE(165)] = 2187,
  [SMALL_STATE(166)] = 2191,
  [SMALL_STATE(167)] = 2195,
  [SMALL_STATE(168)] = 2199,
  [SMALL_STATE(169)] = 2203,
  [SMALL_STATE(170)] = 2207,
  [SMALL_STATE(171)] = 2211,
  [SMALL_STATE(172)] = 2215,
  [SMALL_STATE(173)] = 2219,
  [SMALL_STATE(174)] = 2223,
  [SMALL_STATE(175)] = 2227,
  [SMALL_STATE(176)] = 2231,
  [SMALL_STATE(177)] = 2235,
  [SMALL_STATE(178)] = 2239,
  [SMALL_STATE(179)] = 2243,
  [SMALL_STATE(180)] = 2247,
  [SMALL_STATE(181)] = 2251,
  [SMALL_STATE(182)] = 2255,
  [SMALL_STATE(183)] = 2259,
  [SMALL_STATE(184)] = 2263,
  [SMALL_STATE(185)] = 2267,
  [SMALL_STATE(186)] = 2271,
  [SMALL_STATE(187)] = 2275,
  [SMALL_STATE(188)] = 2279,
  [SMALL_STATE(189)] = 2283,
  [SMALL_STATE(190)] = 2287,
  [SMALL_STATE(191)] = 2291,
  [SMALL_STATE(192)] = 2295,
  [SMALL_STATE(193)] = 2299,
  [SMALL_STATE(194)] = 2303,
  [SMALL_STATE(195)] = 2307,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [5] = {.entry = {.count = 1, .reusable = false}}, SHIFT(15),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(8),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(67),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(111),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(86),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(18),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(24),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(104),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(25),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(87),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(14),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(7),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(73),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(106),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(22),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(19),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(20),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [65] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fill, 1, 0, 0),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [75] = {.entry = {.count = 1, .reusable = false}}, SHIFT(21),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [79] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [81] = {.entry = {.count = 1, .reusable = false}}, SHIFT(23),
  [83] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [85] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [87] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_align, 1, 0, 0),
  [89] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_align, 1, 0, 0),
  [91] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [93] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [95] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [97] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [99] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [107] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sign, 1, 0, 0),
  [109] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sign, 1, 0, 0),
  [111] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_count, 1, 0, 1),
  [113] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_count, 1, 0, 1),
  [115] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument, 1, 0, 0),
  [117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [149] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_count, 1, 0, 0),
  [151] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_count, 1, 0, 0),
  [153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [165] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter, 2, 0, 0),
  [167] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameter, 2, 0, 0),
  [169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [201] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format_string, 1, 0, 0),
  [203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [205] = {.entry = {.count = 1, .reusable = false}}, SHIFT(81),
  [207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [209] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_format_string_repeat1, 2, 0, 0),
  [211] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_format_string_repeat1, 2, 0, 0), SHIFT_REPEAT(179),
  [214] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_format_string_repeat1, 2, 0, 0), SHIFT_REPEAT(81),
  [217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [219] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [229] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format_string, 2, 0, 0),
  [231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [243] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [253] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_format_string_repeat1, 2, 0, 0),
  [255] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type, 1, 0, 0),
  [257] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [261] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 11, 0, 21),
  [263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [265] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 7, 0, 3),
  [267] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 7, 0, 5),
  [269] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 7, 0, 9),
  [271] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [273] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 7, 0, 6),
  [275] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 7, 0, 10),
  [277] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [279] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 5, 0, 4),
  [281] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 7, 0, 11),
  [283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [285] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 2, 0, 0),
  [287] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 7, 0, 0),
  [289] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 4, 0, 0),
  [291] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 7, 0, 7),
  [293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [295] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 3, 0, 0),
  [297] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 6, 0, 3),
  [299] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 8, 0, 8),
  [301] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 8, 0, 12),
  [303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [305] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 8, 0, 9),
  [307] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 8, 0, 10),
  [309] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 5, 0, 3),
  [311] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 8, 0, 11),
  [313] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [315] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [317] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 8, 0, 13),
  [319] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [321] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 6, 0, 5),
  [323] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 8, 0, 0),
  [325] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 8, 0, 14),
  [327] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [329] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [331] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 8, 0, 7),
  [333] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 8, 0, 15),
  [335] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 6, 0, 0),
  [337] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 6, 0, 6),
  [339] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [341] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 4, 0, 2),
  [343] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 9, 0, 12),
  [345] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 9, 0, 16),
  [347] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [349] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 6, 0, 2),
  [351] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 9, 0, 11),
  [353] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 9, 0, 13),
  [355] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 9, 0, 17),
  [357] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [359] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 9, 0, 14),
  [361] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 9, 0, 18),
  [363] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [365] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 6, 0, 4),
  [367] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 9, 0, 15),
  [369] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [371] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 5, 0, 0),
  [373] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 9, 0, 0),
  [375] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 9, 0, 19),
  [377] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [379] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [381] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 10, 0, 16),
  [383] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 10, 0, 20),
  [385] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [387] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 10, 0, 17),
  [389] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 10, 0, 18),
  [391] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 10, 0, 21),
  [393] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [395] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 6, 0, 7),
  [397] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 10, 0, 15),
  [399] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 10, 0, 22),
  [401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [403] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 10, 0, 19),
  [405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [407] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [409] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 5, 0, 2),
  [411] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 10, 0, 0),
  [413] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 11, 0, 20),
  [415] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [417] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 11, 0, 23),
  [419] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [421] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 11, 0, 22),
  [423] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 11, 0, 24),
  [425] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [427] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 7, 0, 8),
  [429] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 11, 0, 19),
  [431] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 11, 0, 25),
  [433] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [435] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 12, 0, 23),
  [437] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 12, 0, 24),
  [439] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 12, 0, 26),
  [441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [443] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 12, 0, 25),
  [445] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_format, 13, 0, 26),
  [447] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_rust_format_args(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
