#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 1062
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 153
#define ALIAS_COUNT 4
#define TOKEN_COUNT 81
#define EXTERNAL_TOKEN_COUNT 3
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 14

enum {
  anon_sym_doctype = 1,
  anon_sym_html = 2,
  anon_sym_strict = 3,
  anon_sym_xml = 4,
  anon_sym_transitional = 5,
  anon_sym_frameset = 6,
  anon_sym_1_DOT1 = 7,
  anon_sym_basic = 8,
  anon_sym_mobile = 9,
  anon_sym_plist = 10,
  anon_sym_PIPE = 11,
  anon_sym_include = 12,
  aux_sym_include_token1 = 13,
  anon_sym_while = 14,
  aux_sym__each_js_token1 = 15,
  anon_sym_COMMA = 16,
  anon_sym_else = 17,
  anon_sym_each = 18,
  anon_sym_for = 19,
  anon_sym_in = 20,
  anon_sym_PLUS = 21,
  anon_sym_LPAREN = 22,
  anon_sym_RPAREN = 23,
  anon_sym_mixin = 24,
  aux_sym_mixin_attributes_token1 = 25,
  anon_sym_block = 26,
  anon_sym_append = 27,
  anon_sym_prepend = 28,
  anon_sym_extends = 29,
  anon_sym_COLON = 30,
  sym_filter_name = 31,
  aux_sym_filter_content_token1 = 32,
  aux_sym_filter_content_token2 = 33,
  anon_sym_unless = 34,
  anon_sym_if = 35,
  anon_sym_elseif = 36,
  anon_sym_case = 37,
  anon_sym_when = 38,
  aux_sym__when_keyword_token1 = 39,
  anon_sym_default = 40,
  anon_sym_BANG_EQ = 41,
  anon_sym_EQ = 42,
  anon_sym_script_DOT = 43,
  anon_sym_SLASH = 44,
  anon_sym_ = 45,
  anon_sym_DOT = 46,
  aux_sym__ternary_attribute_value_token1 = 47,
  aux_sym__variable_attribute_value_token1 = 48,
  aux_sym__object_attribute_value_token1 = 49,
  aux_sym__template_attribute_value_token1 = 50,
  aux_sym__array_attribute_value_token1 = 51,
  aux_sym__attribute_token1 = 52,
  anon_sym_SLASH_SLASH = 53,
  anon_sym_SLASH_SLASH_DASH = 54,
  sym_tag_name = 55,
  sym_class = 56,
  sym_id = 57,
  aux_sym_angular_attribute_name_token1 = 58,
  aux_sym_angular_attribute_name_token2 = 59,
  aux_sym_angular_attribute_name_token3 = 60,
  aux_sym_angular_attribute_name_token4 = 61,
  sym_attribute_name = 62,
  anon_sym_SQUOTE = 63,
  aux_sym_quoted_javascript_token1 = 64,
  anon_sym_DQUOTE = 65,
  aux_sym_quoted_javascript_token2 = 66,
  aux_sym_content_token1 = 67,
  anon_sym_POUND = 68,
  anon_sym_LBRACE = 69,
  anon_sym_POUND_LBRACE = 70,
  anon_sym_RBRACE = 71,
  anon_sym_LBRACE_LBRACE = 72,
  anon_sym_RBRACE_RBRACE = 73,
  sym__delimited_javascript = 74,
  sym__un_delimited_javascript_line = 75,
  anon_sym_DASH = 76,
  aux_sym_unbuffered_code_token1 = 77,
  sym__newline = 78,
  sym__indent = 79,
  sym__dedent = 80,
  sym_source_file = 81,
  sym_doctype = 82,
  sym_pipe = 83,
  sym_include = 84,
  sym_while = 85,
  sym__each_js = 86,
  sym_iteration_variable = 87,
  sym_iteration_iterator = 88,
  sym__each_else = 89,
  sym_each = 90,
  sym_mixin_use = 91,
  sym_mixin_definition = 92,
  sym_mixin_attributes = 93,
  sym__block_content = 94,
  sym_block_definition = 95,
  sym_block_append = 96,
  sym_block_prepend = 97,
  sym_extends = 98,
  sym_filter = 99,
  sym_filter_content = 100,
  sym_conditional = 101,
  sym_case = 102,
  sym__when_content = 103,
  sym__dummy_tag = 104,
  sym__when_keyword = 105,
  sym_when = 106,
  sym_unescaped_buffered_code = 107,
  sym_buffered_code = 108,
  sym_script_block = 109,
  sym_tag = 110,
  sym__content_after_dot = 111,
  sym_attributes = 112,
  sym_attribute = 113,
  sym__ternary_attribute_value = 114,
  sym__string_attribute_value = 115,
  sym__variable_attribute_value = 116,
  sym__object_attribute_value = 117,
  sym__template_attribute_value = 118,
  sym__array_attribute_value = 119,
  sym__pug_attributes = 120,
  sym__attribute = 121,
  sym__angular_attribute = 122,
  sym_children = 123,
  sym__children_choice = 124,
  sym_comment = 125,
  sym__comment = 126,
  sym__comment_not_first_line = 127,
  sym_angular_attribute_name = 128,
  sym_quoted_javascript = 129,
  sym_quoted_attribute_value = 130,
  sym_content = 131,
  sym__comment_content = 132,
  aux_sym__content_or_javascript = 133,
  sym__un_delimited_javascript = 134,
  aux_sym__un_delimited_javascript_multiline = 135,
  sym__single_line_buf_code = 136,
  sym__multi_line_buf_code = 137,
  sym_unbuffered_code = 138,
  aux_sym_source_file_repeat1 = 139,
  aux_sym_mixin_use_repeat1 = 140,
  aux_sym_mixin_attributes_repeat1 = 141,
  aux_sym_filter_content_repeat1 = 142,
  aux_sym_case_repeat1 = 143,
  aux_sym_script_block_repeat1 = 144,
  aux_sym_tag_repeat1 = 145,
  aux_sym__content_after_dot_repeat1 = 146,
  aux_sym_attributes_repeat1 = 147,
  aux_sym__attribute_repeat1 = 148,
  aux_sym_children_repeat1 = 149,
  aux_sym__comment_repeat1 = 150,
  aux_sym_content_repeat1 = 151,
  aux_sym__single_line_buf_code_repeat1 = 152,
  alias_sym_attribute_value = 153,
  alias_sym_block_name = 154,
  alias_sym_filename = 155,
  alias_sym_mixin_name = 156,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_doctype] = "doctype",
  [anon_sym_html] = "doctype_name",
  [anon_sym_strict] = "doctype_name",
  [anon_sym_xml] = "doctype_name",
  [anon_sym_transitional] = "doctype_name",
  [anon_sym_frameset] = "doctype_name",
  [anon_sym_1_DOT1] = "doctype_name",
  [anon_sym_basic] = "doctype_name",
  [anon_sym_mobile] = "doctype_name",
  [anon_sym_plist] = "doctype_name",
  [anon_sym_PIPE] = "|",
  [anon_sym_include] = "keyword",
  [aux_sym_include_token1] = "include_token1",
  [anon_sym_while] = "keyword",
  [aux_sym__each_js_token1] = "javascript",
  [anon_sym_COMMA] = ",",
  [anon_sym_else] = "keyword",
  [anon_sym_each] = "keyword",
  [anon_sym_for] = "keyword",
  [anon_sym_in] = "keyword",
  [anon_sym_PLUS] = "+",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_mixin] = "keyword",
  [aux_sym_mixin_attributes_token1] = "attribute_name",
  [anon_sym_block] = "keyword",
  [anon_sym_append] = "keyword",
  [anon_sym_prepend] = "keyword",
  [anon_sym_extends] = "keyword",
  [anon_sym_COLON] = ":",
  [sym_filter_name] = "filter_name",
  [aux_sym_filter_content_token1] = "filter_content_token1",
  [aux_sym_filter_content_token2] = "filter_content_token2",
  [anon_sym_unless] = "keyword",
  [anon_sym_if] = "keyword",
  [anon_sym_elseif] = "keyword",
  [anon_sym_case] = "keyword",
  [anon_sym_when] = "keyword",
  [aux_sym__when_keyword_token1] = "javascript",
  [anon_sym_default] = "keyword",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_EQ] = "=",
  [anon_sym_script_DOT] = "script.",
  [anon_sym_SLASH] = "self_close_slash",
  [anon_sym_] = " ",
  [anon_sym_DOT] = ".",
  [aux_sym__ternary_attribute_value_token1] = "javascript",
  [aux_sym__variable_attribute_value_token1] = "javascript",
  [aux_sym__object_attribute_value_token1] = "javascript",
  [aux_sym__template_attribute_value_token1] = "javascript",
  [aux_sym__array_attribute_value_token1] = "javascript",
  [aux_sym__attribute_token1] = "attribute_modifier",
  [anon_sym_SLASH_SLASH] = "//",
  [anon_sym_SLASH_SLASH_DASH] = "//-",
  [sym_tag_name] = "tag_name",
  [sym_class] = "class",
  [sym_id] = "id",
  [aux_sym_angular_attribute_name_token1] = "angular_attribute_name_token1",
  [aux_sym_angular_attribute_name_token2] = "angular_attribute_name_token2",
  [aux_sym_angular_attribute_name_token3] = "angular_attribute_name_token3",
  [aux_sym_angular_attribute_name_token4] = "angular_attribute_name_token4",
  [sym_attribute_name] = "attribute_name",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_quoted_javascript_token1] = "javascript",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_quoted_javascript_token2] = "javascript",
  [aux_sym_content_token1] = "content_token1",
  [anon_sym_POUND] = "#",
  [anon_sym_LBRACE] = "{",
  [anon_sym_POUND_LBRACE] = "#{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_LBRACE_LBRACE] = "{{",
  [anon_sym_RBRACE_RBRACE] = "}}",
  [sym__delimited_javascript] = "javascript",
  [sym__un_delimited_javascript_line] = "_un_delimited_javascript_line",
  [anon_sym_DASH] = "-",
  [aux_sym_unbuffered_code_token1] = "unbuffered_code_token1",
  [sym__newline] = "_newline",
  [sym__indent] = "_indent",
  [sym__dedent] = "_dedent",
  [sym_source_file] = "source_file",
  [sym_doctype] = "doctype",
  [sym_pipe] = "pipe",
  [sym_include] = "include",
  [sym_while] = "while",
  [sym__each_js] = "_each_js",
  [sym_iteration_variable] = "iteration_variable",
  [sym_iteration_iterator] = "iteration_iterator",
  [sym__each_else] = "else",
  [sym_each] = "each",
  [sym_mixin_use] = "mixin_use",
  [sym_mixin_definition] = "mixin_definition",
  [sym_mixin_attributes] = "mixin_attributes",
  [sym__block_content] = "_block_content",
  [sym_block_definition] = "block_definition",
  [sym_block_append] = "block_append",
  [sym_block_prepend] = "block_prepend",
  [sym_extends] = "extends",
  [sym_filter] = "filter",
  [sym_filter_content] = "content",
  [sym_conditional] = "conditional",
  [sym_case] = "case",
  [sym__when_content] = "_when_content",
  [sym__dummy_tag] = "children",
  [sym__when_keyword] = "_when_keyword",
  [sym_when] = "when",
  [sym_unescaped_buffered_code] = "unescaped_buffered_code",
  [sym_buffered_code] = "buffered_code",
  [sym_script_block] = "script_block",
  [sym_tag] = "tag",
  [sym__content_after_dot] = "_content_after_dot",
  [sym_attributes] = "attributes",
  [sym_attribute] = "attribute",
  [sym__ternary_attribute_value] = "_ternary_attribute_value",
  [sym__string_attribute_value] = "_string_attribute_value",
  [sym__variable_attribute_value] = "_variable_attribute_value",
  [sym__object_attribute_value] = "_object_attribute_value",
  [sym__template_attribute_value] = "_template_attribute_value",
  [sym__array_attribute_value] = "_array_attribute_value",
  [sym__pug_attributes] = "_pug_attributes",
  [sym__attribute] = "_attribute",
  [sym__angular_attribute] = "_angular_attribute",
  [sym_children] = "children",
  [sym__children_choice] = "_children_choice",
  [sym_comment] = "comment",
  [sym__comment] = "_comment",
  [sym__comment_not_first_line] = "_comment_not_first_line",
  [sym_angular_attribute_name] = "attribute_name",
  [sym_quoted_javascript] = "quoted_javascript",
  [sym_quoted_attribute_value] = "quoted_attribute_value",
  [sym_content] = "content",
  [sym__comment_content] = "_comment_content",
  [aux_sym__content_or_javascript] = "_content_or_javascript",
  [sym__un_delimited_javascript] = "javascript",
  [aux_sym__un_delimited_javascript_multiline] = "_un_delimited_javascript_multiline",
  [sym__single_line_buf_code] = "_single_line_buf_code",
  [sym__multi_line_buf_code] = "_multi_line_buf_code",
  [sym_unbuffered_code] = "unbuffered_code",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_mixin_use_repeat1] = "mixin_use_repeat1",
  [aux_sym_mixin_attributes_repeat1] = "mixin_attributes_repeat1",
  [aux_sym_filter_content_repeat1] = "filter_content_repeat1",
  [aux_sym_case_repeat1] = "case_repeat1",
  [aux_sym_script_block_repeat1] = "script_block_repeat1",
  [aux_sym_tag_repeat1] = "tag_repeat1",
  [aux_sym__content_after_dot_repeat1] = "_content_after_dot_repeat1",
  [aux_sym_attributes_repeat1] = "attributes_repeat1",
  [aux_sym__attribute_repeat1] = "_attribute_repeat1",
  [aux_sym_children_repeat1] = "children_repeat1",
  [aux_sym__comment_repeat1] = "_comment_repeat1",
  [aux_sym_content_repeat1] = "content_repeat1",
  [aux_sym__single_line_buf_code_repeat1] = "_single_line_buf_code_repeat1",
  [alias_sym_attribute_value] = "attribute_value",
  [alias_sym_block_name] = "block_name",
  [alias_sym_filename] = "filename",
  [alias_sym_mixin_name] = "mixin_name",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_doctype] = anon_sym_doctype,
  [anon_sym_html] = anon_sym_html,
  [anon_sym_strict] = anon_sym_html,
  [anon_sym_xml] = anon_sym_html,
  [anon_sym_transitional] = anon_sym_html,
  [anon_sym_frameset] = anon_sym_html,
  [anon_sym_1_DOT1] = anon_sym_html,
  [anon_sym_basic] = anon_sym_html,
  [anon_sym_mobile] = anon_sym_html,
  [anon_sym_plist] = anon_sym_html,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_include] = anon_sym_include,
  [aux_sym_include_token1] = aux_sym_include_token1,
  [anon_sym_while] = anon_sym_include,
  [aux_sym__each_js_token1] = aux_sym__each_js_token1,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_else] = anon_sym_include,
  [anon_sym_each] = anon_sym_include,
  [anon_sym_for] = anon_sym_include,
  [anon_sym_in] = anon_sym_include,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_mixin] = anon_sym_include,
  [aux_sym_mixin_attributes_token1] = sym_attribute_name,
  [anon_sym_block] = anon_sym_include,
  [anon_sym_append] = anon_sym_include,
  [anon_sym_prepend] = anon_sym_include,
  [anon_sym_extends] = anon_sym_include,
  [anon_sym_COLON] = anon_sym_COLON,
  [sym_filter_name] = sym_filter_name,
  [aux_sym_filter_content_token1] = aux_sym_filter_content_token1,
  [aux_sym_filter_content_token2] = aux_sym_filter_content_token2,
  [anon_sym_unless] = anon_sym_include,
  [anon_sym_if] = anon_sym_include,
  [anon_sym_elseif] = anon_sym_include,
  [anon_sym_case] = anon_sym_include,
  [anon_sym_when] = anon_sym_include,
  [aux_sym__when_keyword_token1] = aux_sym__each_js_token1,
  [anon_sym_default] = anon_sym_include,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_script_DOT] = anon_sym_script_DOT,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_] = anon_sym_,
  [anon_sym_DOT] = anon_sym_DOT,
  [aux_sym__ternary_attribute_value_token1] = aux_sym__each_js_token1,
  [aux_sym__variable_attribute_value_token1] = aux_sym__each_js_token1,
  [aux_sym__object_attribute_value_token1] = aux_sym__each_js_token1,
  [aux_sym__template_attribute_value_token1] = aux_sym__each_js_token1,
  [aux_sym__array_attribute_value_token1] = aux_sym__each_js_token1,
  [aux_sym__attribute_token1] = aux_sym__attribute_token1,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [anon_sym_SLASH_SLASH_DASH] = anon_sym_SLASH_SLASH_DASH,
  [sym_tag_name] = sym_tag_name,
  [sym_class] = sym_class,
  [sym_id] = sym_id,
  [aux_sym_angular_attribute_name_token1] = aux_sym_angular_attribute_name_token1,
  [aux_sym_angular_attribute_name_token2] = aux_sym_angular_attribute_name_token2,
  [aux_sym_angular_attribute_name_token3] = aux_sym_angular_attribute_name_token3,
  [aux_sym_angular_attribute_name_token4] = aux_sym_angular_attribute_name_token4,
  [sym_attribute_name] = sym_attribute_name,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_quoted_javascript_token1] = aux_sym__each_js_token1,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_quoted_javascript_token2] = aux_sym__each_js_token1,
  [aux_sym_content_token1] = aux_sym_content_token1,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_POUND_LBRACE] = anon_sym_POUND_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_LBRACE_LBRACE] = anon_sym_LBRACE_LBRACE,
  [anon_sym_RBRACE_RBRACE] = anon_sym_RBRACE_RBRACE,
  [sym__delimited_javascript] = aux_sym__each_js_token1,
  [sym__un_delimited_javascript_line] = sym__un_delimited_javascript_line,
  [anon_sym_DASH] = anon_sym_DASH,
  [aux_sym_unbuffered_code_token1] = aux_sym_unbuffered_code_token1,
  [sym__newline] = sym__newline,
  [sym__indent] = sym__indent,
  [sym__dedent] = sym__dedent,
  [sym_source_file] = sym_source_file,
  [sym_doctype] = sym_doctype,
  [sym_pipe] = sym_pipe,
  [sym_include] = sym_include,
  [sym_while] = sym_while,
  [sym__each_js] = sym__each_js,
  [sym_iteration_variable] = sym_iteration_variable,
  [sym_iteration_iterator] = sym_iteration_iterator,
  [sym__each_else] = sym__each_else,
  [sym_each] = sym_each,
  [sym_mixin_use] = sym_mixin_use,
  [sym_mixin_definition] = sym_mixin_definition,
  [sym_mixin_attributes] = sym_mixin_attributes,
  [sym__block_content] = sym__block_content,
  [sym_block_definition] = sym_block_definition,
  [sym_block_append] = sym_block_append,
  [sym_block_prepend] = sym_block_prepend,
  [sym_extends] = sym_extends,
  [sym_filter] = sym_filter,
  [sym_filter_content] = sym_content,
  [sym_conditional] = sym_conditional,
  [sym_case] = sym_case,
  [sym__when_content] = sym__when_content,
  [sym__dummy_tag] = sym_children,
  [sym__when_keyword] = sym__when_keyword,
  [sym_when] = sym_when,
  [sym_unescaped_buffered_code] = sym_unescaped_buffered_code,
  [sym_buffered_code] = sym_buffered_code,
  [sym_script_block] = sym_script_block,
  [sym_tag] = sym_tag,
  [sym__content_after_dot] = sym__content_after_dot,
  [sym_attributes] = sym_attributes,
  [sym_attribute] = sym_attribute,
  [sym__ternary_attribute_value] = sym__ternary_attribute_value,
  [sym__string_attribute_value] = sym__string_attribute_value,
  [sym__variable_attribute_value] = sym__variable_attribute_value,
  [sym__object_attribute_value] = sym__object_attribute_value,
  [sym__template_attribute_value] = sym__template_attribute_value,
  [sym__array_attribute_value] = sym__array_attribute_value,
  [sym__pug_attributes] = sym__pug_attributes,
  [sym__attribute] = sym__attribute,
  [sym__angular_attribute] = sym__angular_attribute,
  [sym_children] = sym_children,
  [sym__children_choice] = sym__children_choice,
  [sym_comment] = sym_comment,
  [sym__comment] = sym__comment,
  [sym__comment_not_first_line] = sym__comment_not_first_line,
  [sym_angular_attribute_name] = sym_attribute_name,
  [sym_quoted_javascript] = sym_quoted_javascript,
  [sym_quoted_attribute_value] = sym_quoted_attribute_value,
  [sym_content] = sym_content,
  [sym__comment_content] = sym__comment_content,
  [aux_sym__content_or_javascript] = aux_sym__content_or_javascript,
  [sym__un_delimited_javascript] = aux_sym__each_js_token1,
  [aux_sym__un_delimited_javascript_multiline] = aux_sym__un_delimited_javascript_multiline,
  [sym__single_line_buf_code] = sym__single_line_buf_code,
  [sym__multi_line_buf_code] = sym__multi_line_buf_code,
  [sym_unbuffered_code] = sym_unbuffered_code,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_mixin_use_repeat1] = aux_sym_mixin_use_repeat1,
  [aux_sym_mixin_attributes_repeat1] = aux_sym_mixin_attributes_repeat1,
  [aux_sym_filter_content_repeat1] = aux_sym_filter_content_repeat1,
  [aux_sym_case_repeat1] = aux_sym_case_repeat1,
  [aux_sym_script_block_repeat1] = aux_sym_script_block_repeat1,
  [aux_sym_tag_repeat1] = aux_sym_tag_repeat1,
  [aux_sym__content_after_dot_repeat1] = aux_sym__content_after_dot_repeat1,
  [aux_sym_attributes_repeat1] = aux_sym_attributes_repeat1,
  [aux_sym__attribute_repeat1] = aux_sym__attribute_repeat1,
  [aux_sym_children_repeat1] = aux_sym_children_repeat1,
  [aux_sym__comment_repeat1] = aux_sym__comment_repeat1,
  [aux_sym_content_repeat1] = aux_sym_content_repeat1,
  [aux_sym__single_line_buf_code_repeat1] = aux_sym__single_line_buf_code_repeat1,
  [alias_sym_attribute_value] = alias_sym_attribute_value,
  [alias_sym_block_name] = alias_sym_block_name,
  [alias_sym_filename] = alias_sym_filename,
  [alias_sym_mixin_name] = alias_sym_mixin_name,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_doctype] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_html] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_strict] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_xml] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_transitional] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_frameset] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_1_DOT1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_basic] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_mobile] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_plist] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_include] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_include_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__each_js_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_each] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mixin] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_mixin_attributes_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_block] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_append] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_prepend] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_filter_name] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_filter_content_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_filter_content_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_unless] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_elseif] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_when] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__when_keyword_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_script_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__ternary_attribute_value_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__variable_attribute_value_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__object_attribute_value_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__template_attribute_value_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__array_attribute_value_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__attribute_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [sym_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym_class] = {
    .visible = true,
    .named = true,
  },
  [sym_id] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_angular_attribute_name_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_angular_attribute_name_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_angular_attribute_name_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_angular_attribute_name_token4] = {
    .visible = false,
    .named = false,
  },
  [sym_attribute_name] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_quoted_javascript_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_quoted_javascript_token2] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_content_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [sym__delimited_javascript] = {
    .visible = true,
    .named = true,
  },
  [sym__un_delimited_javascript_line] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_unbuffered_code_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__newline] = {
    .visible = false,
    .named = true,
  },
  [sym__indent] = {
    .visible = false,
    .named = true,
  },
  [sym__dedent] = {
    .visible = false,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_doctype] = {
    .visible = true,
    .named = true,
  },
  [sym_pipe] = {
    .visible = true,
    .named = true,
  },
  [sym_include] = {
    .visible = true,
    .named = true,
  },
  [sym_while] = {
    .visible = true,
    .named = true,
  },
  [sym__each_js] = {
    .visible = false,
    .named = true,
  },
  [sym_iteration_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_iteration_iterator] = {
    .visible = true,
    .named = true,
  },
  [sym__each_else] = {
    .visible = true,
    .named = true,
  },
  [sym_each] = {
    .visible = true,
    .named = true,
  },
  [sym_mixin_use] = {
    .visible = true,
    .named = true,
  },
  [sym_mixin_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_mixin_attributes] = {
    .visible = true,
    .named = true,
  },
  [sym__block_content] = {
    .visible = false,
    .named = true,
  },
  [sym_block_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_block_append] = {
    .visible = true,
    .named = true,
  },
  [sym_block_prepend] = {
    .visible = true,
    .named = true,
  },
  [sym_extends] = {
    .visible = true,
    .named = true,
  },
  [sym_filter] = {
    .visible = true,
    .named = true,
  },
  [sym_filter_content] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional] = {
    .visible = true,
    .named = true,
  },
  [sym_case] = {
    .visible = true,
    .named = true,
  },
  [sym__when_content] = {
    .visible = false,
    .named = true,
  },
  [sym__dummy_tag] = {
    .visible = true,
    .named = true,
  },
  [sym__when_keyword] = {
    .visible = false,
    .named = true,
  },
  [sym_when] = {
    .visible = true,
    .named = true,
  },
  [sym_unescaped_buffered_code] = {
    .visible = true,
    .named = true,
  },
  [sym_buffered_code] = {
    .visible = true,
    .named = true,
  },
  [sym_script_block] = {
    .visible = true,
    .named = true,
  },
  [sym_tag] = {
    .visible = true,
    .named = true,
  },
  [sym__content_after_dot] = {
    .visible = false,
    .named = true,
  },
  [sym_attributes] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym__ternary_attribute_value] = {
    .visible = false,
    .named = true,
  },
  [sym__string_attribute_value] = {
    .visible = false,
    .named = true,
  },
  [sym__variable_attribute_value] = {
    .visible = false,
    .named = true,
  },
  [sym__object_attribute_value] = {
    .visible = false,
    .named = true,
  },
  [sym__template_attribute_value] = {
    .visible = false,
    .named = true,
  },
  [sym__array_attribute_value] = {
    .visible = false,
    .named = true,
  },
  [sym__pug_attributes] = {
    .visible = false,
    .named = true,
  },
  [sym__attribute] = {
    .visible = false,
    .named = true,
  },
  [sym__angular_attribute] = {
    .visible = false,
    .named = true,
  },
  [sym_children] = {
    .visible = true,
    .named = true,
  },
  [sym__children_choice] = {
    .visible = false,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__comment] = {
    .visible = false,
    .named = true,
  },
  [sym__comment_not_first_line] = {
    .visible = false,
    .named = true,
  },
  [sym_angular_attribute_name] = {
    .visible = true,
    .named = true,
  },
  [sym_quoted_javascript] = {
    .visible = true,
    .named = true,
  },
  [sym_quoted_attribute_value] = {
    .visible = true,
    .named = true,
  },
  [sym_content] = {
    .visible = true,
    .named = true,
  },
  [sym__comment_content] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__content_or_javascript] = {
    .visible = false,
    .named = false,
  },
  [sym__un_delimited_javascript] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__un_delimited_javascript_multiline] = {
    .visible = false,
    .named = false,
  },
  [sym__single_line_buf_code] = {
    .visible = false,
    .named = true,
  },
  [sym__multi_line_buf_code] = {
    .visible = false,
    .named = true,
  },
  [sym_unbuffered_code] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_mixin_use_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_mixin_attributes_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_filter_content_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_script_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tag_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__content_after_dot_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attributes_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__attribute_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_children_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__comment_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_content_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__single_line_buf_code_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_attribute_value] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_block_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_filename] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_mixin_name] = {
    .visible = true,
    .named = true,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [1] = alias_sym_filename,
  },
  [2] = {
    [0] = aux_sym__each_js_token1,
  },
  [3] = {
    [1] = alias_sym_mixin_name,
  },
  [4] = {
    [0] = alias_sym_block_name,
  },
  [5] = {
    [2] = alias_sym_filename,
  },
  [6] = {
    [0] = sym_attribute,
  },
  [7] = {
    [1] = alias_sym_mixin_name,
    [3] = sym_attribute,
  },
  [8] = {
    [1] = aux_sym__each_js_token1,
  },
  [9] = {
    [3] = aux_sym__each_js_token1,
  },
  [10] = {
    [1] = alias_sym_attribute_value,
  },
  [11] = {
    [1] = alias_sym_mixin_name,
    [4] = sym_attribute,
  },
  [12] = {
    [3] = sym_children,
  },
  [13] = {
    [5] = sym_children,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__pug_attributes, 2,
    sym__pug_attributes,
    sym_attribute,
  aux_sym__un_delimited_javascript_multiline, 2,
    aux_sym__un_delimited_javascript_multiline,
    aux_sym__each_js_token1,
  aux_sym_script_block_repeat1, 2,
    aux_sym_script_block_repeat1,
    aux_sym__each_js_token1,
  aux_sym__content_after_dot_repeat1, 2,
    aux_sym__content_after_dot_repeat1,
    sym_children,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 2,
  [5] = 2,
  [6] = 3,
  [7] = 2,
  [8] = 8,
  [9] = 3,
  [10] = 2,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 14,
  [17] = 12,
  [18] = 13,
  [19] = 15,
  [20] = 12,
  [21] = 2,
  [22] = 13,
  [23] = 15,
  [24] = 12,
  [25] = 13,
  [26] = 15,
  [27] = 12,
  [28] = 14,
  [29] = 12,
  [30] = 14,
  [31] = 13,
  [32] = 15,
  [33] = 14,
  [34] = 13,
  [35] = 15,
  [36] = 14,
  [37] = 3,
  [38] = 13,
  [39] = 12,
  [40] = 2,
  [41] = 15,
  [42] = 14,
  [43] = 43,
  [44] = 43,
  [45] = 43,
  [46] = 43,
  [47] = 43,
  [48] = 43,
  [49] = 43,
  [50] = 50,
  [51] = 50,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 50,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 50,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 55,
  [69] = 63,
  [70] = 70,
  [71] = 60,
  [72] = 61,
  [73] = 52,
  [74] = 66,
  [75] = 57,
  [76] = 76,
  [77] = 65,
  [78] = 78,
  [79] = 67,
  [80] = 53,
  [81] = 81,
  [82] = 82,
  [83] = 59,
  [84] = 84,
  [85] = 54,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 62,
  [92] = 78,
  [93] = 54,
  [94] = 94,
  [95] = 60,
  [96] = 66,
  [97] = 97,
  [98] = 63,
  [99] = 99,
  [100] = 100,
  [101] = 61,
  [102] = 53,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 65,
  [107] = 107,
  [108] = 108,
  [109] = 67,
  [110] = 54,
  [111] = 111,
  [112] = 57,
  [113] = 52,
  [114] = 114,
  [115] = 56,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 59,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 50,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 62,
  [152] = 104,
  [153] = 105,
  [154] = 62,
  [155] = 63,
  [156] = 114,
  [157] = 86,
  [158] = 66,
  [159] = 61,
  [160] = 87,
  [161] = 99,
  [162] = 100,
  [163] = 88,
  [164] = 121,
  [165] = 78,
  [166] = 76,
  [167] = 81,
  [168] = 103,
  [169] = 108,
  [170] = 89,
  [171] = 70,
  [172] = 107,
  [173] = 127,
  [174] = 67,
  [175] = 56,
  [176] = 116,
  [177] = 135,
  [178] = 120,
  [179] = 60,
  [180] = 84,
  [181] = 56,
  [182] = 57,
  [183] = 55,
  [184] = 65,
  [185] = 59,
  [186] = 82,
  [187] = 90,
  [188] = 82,
  [189] = 78,
  [190] = 118,
  [191] = 114,
  [192] = 67,
  [193] = 86,
  [194] = 111,
  [195] = 123,
  [196] = 88,
  [197] = 150,
  [198] = 107,
  [199] = 121,
  [200] = 146,
  [201] = 76,
  [202] = 149,
  [203] = 70,
  [204] = 147,
  [205] = 76,
  [206] = 148,
  [207] = 61,
  [208] = 145,
  [209] = 144,
  [210] = 66,
  [211] = 137,
  [212] = 136,
  [213] = 81,
  [214] = 70,
  [215] = 127,
  [216] = 78,
  [217] = 60,
  [218] = 134,
  [219] = 143,
  [220] = 220,
  [221] = 63,
  [222] = 142,
  [223] = 141,
  [224] = 140,
  [225] = 139,
  [226] = 119,
  [227] = 117,
  [228] = 135,
  [229] = 82,
  [230] = 108,
  [231] = 103,
  [232] = 105,
  [233] = 86,
  [234] = 133,
  [235] = 132,
  [236] = 131,
  [237] = 130,
  [238] = 129,
  [239] = 128,
  [240] = 126,
  [241] = 125,
  [242] = 124,
  [243] = 54,
  [244] = 84,
  [245] = 104,
  [246] = 78,
  [247] = 97,
  [248] = 87,
  [249] = 57,
  [250] = 59,
  [251] = 99,
  [252] = 94,
  [253] = 65,
  [254] = 100,
  [255] = 124,
  [256] = 149,
  [257] = 60,
  [258] = 150,
  [259] = 123,
  [260] = 148,
  [261] = 61,
  [262] = 111,
  [263] = 145,
  [264] = 84,
  [265] = 265,
  [266] = 105,
  [267] = 144,
  [268] = 144,
  [269] = 143,
  [270] = 142,
  [271] = 141,
  [272] = 140,
  [273] = 139,
  [274] = 107,
  [275] = 114,
  [276] = 133,
  [277] = 132,
  [278] = 131,
  [279] = 130,
  [280] = 129,
  [281] = 128,
  [282] = 126,
  [283] = 129,
  [284] = 125,
  [285] = 81,
  [286] = 118,
  [287] = 88,
  [288] = 56,
  [289] = 118,
  [290] = 62,
  [291] = 135,
  [292] = 63,
  [293] = 147,
  [294] = 66,
  [295] = 104,
  [296] = 121,
  [297] = 137,
  [298] = 127,
  [299] = 134,
  [300] = 107,
  [301] = 90,
  [302] = 94,
  [303] = 89,
  [304] = 108,
  [305] = 100,
  [306] = 107,
  [307] = 103,
  [308] = 116,
  [309] = 120,
  [310] = 97,
  [311] = 59,
  [312] = 99,
  [313] = 67,
  [314] = 117,
  [315] = 119,
  [316] = 57,
  [317] = 65,
  [318] = 87,
  [319] = 136,
  [320] = 146,
  [321] = 87,
  [322] = 141,
  [323] = 121,
  [324] = 150,
  [325] = 88,
  [326] = 82,
  [327] = 84,
  [328] = 81,
  [329] = 329,
  [330] = 330,
  [331] = 331,
  [332] = 149,
  [333] = 124,
  [334] = 97,
  [335] = 99,
  [336] = 125,
  [337] = 100,
  [338] = 126,
  [339] = 137,
  [340] = 136,
  [341] = 94,
  [342] = 148,
  [343] = 90,
  [344] = 344,
  [345] = 345,
  [346] = 104,
  [347] = 147,
  [348] = 105,
  [349] = 349,
  [350] = 145,
  [351] = 128,
  [352] = 123,
  [353] = 130,
  [354] = 134,
  [355] = 131,
  [356] = 132,
  [357] = 133,
  [358] = 103,
  [359] = 78,
  [360] = 108,
  [361] = 111,
  [362] = 127,
  [363] = 146,
  [364] = 119,
  [365] = 117,
  [366] = 143,
  [367] = 142,
  [368] = 368,
  [369] = 76,
  [370] = 70,
  [371] = 114,
  [372] = 135,
  [373] = 86,
  [374] = 140,
  [375] = 139,
  [376] = 124,
  [377] = 139,
  [378] = 150,
  [379] = 114,
  [380] = 88,
  [381] = 149,
  [382] = 121,
  [383] = 127,
  [384] = 135,
  [385] = 108,
  [386] = 103,
  [387] = 148,
  [388] = 145,
  [389] = 144,
  [390] = 111,
  [391] = 118,
  [392] = 104,
  [393] = 100,
  [394] = 146,
  [395] = 134,
  [396] = 99,
  [397] = 147,
  [398] = 143,
  [399] = 137,
  [400] = 87,
  [401] = 136,
  [402] = 142,
  [403] = 141,
  [404] = 140,
  [405] = 107,
  [406] = 105,
  [407] = 119,
  [408] = 117,
  [409] = 90,
  [410] = 94,
  [411] = 97,
  [412] = 133,
  [413] = 132,
  [414] = 131,
  [415] = 130,
  [416] = 129,
  [417] = 128,
  [418] = 126,
  [419] = 125,
  [420] = 123,
  [421] = 421,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 425,
  [426] = 425,
  [427] = 424,
  [428] = 428,
  [429] = 424,
  [430] = 425,
  [431] = 425,
  [432] = 425,
  [433] = 424,
  [434] = 424,
  [435] = 435,
  [436] = 424,
  [437] = 424,
  [438] = 425,
  [439] = 425,
  [440] = 440,
  [441] = 441,
  [442] = 441,
  [443] = 443,
  [444] = 441,
  [445] = 443,
  [446] = 441,
  [447] = 443,
  [448] = 443,
  [449] = 443,
  [450] = 441,
  [451] = 443,
  [452] = 443,
  [453] = 441,
  [454] = 441,
  [455] = 455,
  [456] = 456,
  [457] = 457,
  [458] = 456,
  [459] = 456,
  [460] = 457,
  [461] = 457,
  [462] = 456,
  [463] = 456,
  [464] = 456,
  [465] = 457,
  [466] = 457,
  [467] = 457,
  [468] = 457,
  [469] = 456,
  [470] = 470,
  [471] = 471,
  [472] = 472,
  [473] = 471,
  [474] = 472,
  [475] = 475,
  [476] = 470,
  [477] = 471,
  [478] = 478,
  [479] = 475,
  [480] = 475,
  [481] = 475,
  [482] = 482,
  [483] = 483,
  [484] = 482,
  [485] = 472,
  [486] = 470,
  [487] = 478,
  [488] = 471,
  [489] = 478,
  [490] = 471,
  [491] = 472,
  [492] = 482,
  [493] = 472,
  [494] = 475,
  [495] = 472,
  [496] = 470,
  [497] = 470,
  [498] = 470,
  [499] = 478,
  [500] = 471,
  [501] = 482,
  [502] = 471,
  [503] = 475,
  [504] = 482,
  [505] = 482,
  [506] = 475,
  [507] = 478,
  [508] = 472,
  [509] = 482,
  [510] = 470,
  [511] = 511,
  [512] = 512,
  [513] = 511,
  [514] = 512,
  [515] = 512,
  [516] = 511,
  [517] = 512,
  [518] = 512,
  [519] = 512,
  [520] = 511,
  [521] = 512,
  [522] = 511,
  [523] = 511,
  [524] = 511,
  [525] = 50,
  [526] = 61,
  [527] = 527,
  [528] = 528,
  [529] = 528,
  [530] = 530,
  [531] = 530,
  [532] = 532,
  [533] = 527,
  [534] = 532,
  [535] = 527,
  [536] = 532,
  [537] = 528,
  [538] = 532,
  [539] = 70,
  [540] = 76,
  [541] = 527,
  [542] = 528,
  [543] = 60,
  [544] = 544,
  [545] = 544,
  [546] = 546,
  [547] = 544,
  [548] = 66,
  [549] = 530,
  [550] = 528,
  [551] = 544,
  [552] = 530,
  [553] = 527,
  [554] = 86,
  [555] = 63,
  [556] = 532,
  [557] = 557,
  [558] = 558,
  [559] = 544,
  [560] = 560,
  [561] = 532,
  [562] = 558,
  [563] = 528,
  [564] = 546,
  [565] = 546,
  [566] = 566,
  [567] = 546,
  [568] = 528,
  [569] = 527,
  [570] = 57,
  [571] = 558,
  [572] = 546,
  [573] = 65,
  [574] = 558,
  [575] = 558,
  [576] = 530,
  [577] = 544,
  [578] = 544,
  [579] = 59,
  [580] = 528,
  [581] = 581,
  [582] = 67,
  [583] = 530,
  [584] = 527,
  [585] = 530,
  [586] = 532,
  [587] = 587,
  [588] = 588,
  [589] = 54,
  [590] = 590,
  [591] = 591,
  [592] = 592,
  [593] = 593,
  [594] = 593,
  [595] = 587,
  [596] = 592,
  [597] = 591,
  [598] = 587,
  [599] = 590,
  [600] = 590,
  [601] = 587,
  [602] = 592,
  [603] = 591,
  [604] = 591,
  [605] = 593,
  [606] = 590,
  [607] = 587,
  [608] = 591,
  [609] = 592,
  [610] = 587,
  [611] = 593,
  [612] = 592,
  [613] = 613,
  [614] = 593,
  [615] = 591,
  [616] = 616,
  [617] = 592,
  [618] = 593,
  [619] = 591,
  [620] = 593,
  [621] = 587,
  [622] = 78,
  [623] = 590,
  [624] = 592,
  [625] = 625,
  [626] = 590,
  [627] = 590,
  [628] = 592,
  [629] = 629,
  [630] = 630,
  [631] = 631,
  [632] = 121,
  [633] = 633,
  [634] = 107,
  [635] = 635,
  [636] = 635,
  [637] = 114,
  [638] = 99,
  [639] = 104,
  [640] = 640,
  [641] = 641,
  [642] = 630,
  [643] = 88,
  [644] = 105,
  [645] = 645,
  [646] = 635,
  [647] = 647,
  [648] = 87,
  [649] = 127,
  [650] = 103,
  [651] = 108,
  [652] = 100,
  [653] = 135,
  [654] = 630,
  [655] = 655,
  [656] = 656,
  [657] = 657,
  [658] = 656,
  [659] = 659,
  [660] = 657,
  [661] = 661,
  [662] = 662,
  [663] = 661,
  [664] = 655,
  [665] = 665,
  [666] = 662,
  [667] = 667,
  [668] = 668,
  [669] = 659,
  [670] = 656,
  [671] = 659,
  [672] = 665,
  [673] = 665,
  [674] = 667,
  [675] = 655,
  [676] = 661,
  [677] = 657,
  [678] = 667,
  [679] = 655,
  [680] = 662,
  [681] = 668,
  [682] = 668,
  [683] = 656,
  [684] = 668,
  [685] = 70,
  [686] = 662,
  [687] = 659,
  [688] = 667,
  [689] = 662,
  [690] = 690,
  [691] = 668,
  [692] = 76,
  [693] = 655,
  [694] = 86,
  [695] = 656,
  [696] = 696,
  [697] = 659,
  [698] = 659,
  [699] = 665,
  [700] = 665,
  [701] = 701,
  [702] = 668,
  [703] = 703,
  [704] = 704,
  [705] = 705,
  [706] = 667,
  [707] = 707,
  [708] = 655,
  [709] = 668,
  [710] = 655,
  [711] = 656,
  [712] = 661,
  [713] = 661,
  [714] = 657,
  [715] = 657,
  [716] = 656,
  [717] = 659,
  [718] = 718,
  [719] = 719,
  [720] = 720,
  [721] = 720,
  [722] = 719,
  [723] = 720,
  [724] = 720,
  [725] = 725,
  [726] = 726,
  [727] = 727,
  [728] = 728,
  [729] = 729,
  [730] = 730,
  [731] = 731,
  [732] = 732,
  [733] = 733,
  [734] = 734,
  [735] = 735,
  [736] = 736,
  [737] = 737,
  [738] = 738,
  [739] = 739,
  [740] = 740,
  [741] = 741,
  [742] = 742,
  [743] = 735,
  [744] = 744,
  [745] = 736,
  [746] = 737,
  [747] = 718,
  [748] = 739,
  [749] = 738,
  [750] = 750,
  [751] = 729,
  [752] = 728,
  [753] = 735,
  [754] = 736,
  [755] = 737,
  [756] = 738,
  [757] = 741,
  [758] = 741,
  [759] = 735,
  [760] = 718,
  [761] = 739,
  [762] = 736,
  [763] = 737,
  [764] = 720,
  [765] = 738,
  [766] = 719,
  [767] = 767,
  [768] = 768,
  [769] = 738,
  [770] = 735,
  [771] = 771,
  [772] = 730,
  [773] = 729,
  [774] = 730,
  [775] = 728,
  [776] = 719,
  [777] = 719,
  [778] = 768,
  [779] = 768,
  [780] = 726,
  [781] = 726,
  [782] = 739,
  [783] = 728,
  [784] = 719,
  [785] = 730,
  [786] = 718,
  [787] = 787,
  [788] = 768,
  [789] = 726,
  [790] = 736,
  [791] = 737,
  [792] = 728,
  [793] = 719,
  [794] = 741,
  [795] = 730,
  [796] = 796,
  [797] = 768,
  [798] = 768,
  [799] = 728,
  [800] = 718,
  [801] = 739,
  [802] = 741,
  [803] = 739,
  [804] = 718,
  [805] = 739,
  [806] = 806,
  [807] = 730,
  [808] = 726,
  [809] = 718,
  [810] = 768,
  [811] = 811,
  [812] = 812,
  [813] = 813,
  [814] = 814,
  [815] = 815,
  [816] = 816,
  [817] = 817,
  [818] = 818,
  [819] = 813,
  [820] = 820,
  [821] = 818,
  [822] = 817,
  [823] = 816,
  [824] = 815,
  [825] = 825,
  [826] = 813,
  [827] = 820,
  [828] = 814,
  [829] = 815,
  [830] = 830,
  [831] = 812,
  [832] = 813,
  [833] = 820,
  [834] = 815,
  [835] = 816,
  [836] = 836,
  [837] = 813,
  [838] = 838,
  [839] = 817,
  [840] = 818,
  [841] = 820,
  [842] = 838,
  [843] = 843,
  [844] = 844,
  [845] = 818,
  [846] = 843,
  [847] = 847,
  [848] = 817,
  [849] = 849,
  [850] = 816,
  [851] = 843,
  [852] = 725,
  [853] = 853,
  [854] = 825,
  [855] = 812,
  [856] = 856,
  [857] = 857,
  [858] = 830,
  [859] = 859,
  [860] = 815,
  [861] = 861,
  [862] = 830,
  [863] = 863,
  [864] = 812,
  [865] = 825,
  [866] = 866,
  [867] = 830,
  [868] = 816,
  [869] = 817,
  [870] = 814,
  [871] = 818,
  [872] = 872,
  [873] = 843,
  [874] = 814,
  [875] = 838,
  [876] = 876,
  [877] = 877,
  [878] = 812,
  [879] = 879,
  [880] = 825,
  [881] = 727,
  [882] = 882,
  [883] = 876,
  [884] = 877,
  [885] = 838,
  [886] = 740,
  [887] = 830,
  [888] = 820,
  [889] = 889,
  [890] = 838,
  [891] = 814,
  [892] = 892,
  [893] = 825,
  [894] = 843,
  [895] = 895,
  [896] = 896,
  [897] = 897,
  [898] = 898,
  [899] = 899,
  [900] = 900,
  [901] = 896,
  [902] = 902,
  [903] = 903,
  [904] = 904,
  [905] = 905,
  [906] = 906,
  [907] = 907,
  [908] = 908,
  [909] = 909,
  [910] = 910,
  [911] = 898,
  [912] = 912,
  [913] = 910,
  [914] = 914,
  [915] = 915,
  [916] = 119,
  [917] = 917,
  [918] = 918,
  [919] = 895,
  [920] = 920,
  [921] = 912,
  [922] = 899,
  [923] = 896,
  [924] = 924,
  [925] = 904,
  [926] = 905,
  [927] = 927,
  [928] = 928,
  [929] = 929,
  [930] = 930,
  [931] = 912,
  [932] = 910,
  [933] = 914,
  [934] = 915,
  [935] = 918,
  [936] = 936,
  [937] = 898,
  [938] = 938,
  [939] = 899,
  [940] = 896,
  [941] = 941,
  [942] = 917,
  [943] = 895,
  [944] = 944,
  [945] = 945,
  [946] = 946,
  [947] = 928,
  [948] = 912,
  [949] = 917,
  [950] = 910,
  [951] = 914,
  [952] = 915,
  [953] = 918,
  [954] = 918,
  [955] = 938,
  [956] = 936,
  [957] = 957,
  [958] = 899,
  [959] = 896,
  [960] = 920,
  [961] = 961,
  [962] = 920,
  [963] = 963,
  [964] = 917,
  [965] = 965,
  [966] = 928,
  [967] = 912,
  [968] = 936,
  [969] = 910,
  [970] = 914,
  [971] = 915,
  [972] = 972,
  [973] = 918,
  [974] = 974,
  [975] = 946,
  [976] = 976,
  [977] = 899,
  [978] = 978,
  [979] = 979,
  [980] = 980,
  [981] = 981,
  [982] = 938,
  [983] = 898,
  [984] = 984,
  [985] = 928,
  [986] = 936,
  [987] = 918,
  [988] = 898,
  [989] = 989,
  [990] = 990,
  [991] = 928,
  [992] = 992,
  [993] = 938,
  [994] = 898,
  [995] = 117,
  [996] = 137,
  [997] = 147,
  [998] = 920,
  [999] = 146,
  [1000] = 1000,
  [1001] = 136,
  [1002] = 915,
  [1003] = 1003,
  [1004] = 1000,
  [1005] = 992,
  [1006] = 984,
  [1007] = 1007,
  [1008] = 897,
  [1009] = 957,
  [1010] = 914,
  [1011] = 1011,
  [1012] = 1000,
  [1013] = 992,
  [1014] = 984,
  [1015] = 946,
  [1016] = 897,
  [1017] = 957,
  [1018] = 920,
  [1019] = 917,
  [1020] = 992,
  [1021] = 984,
  [1022] = 936,
  [1023] = 897,
  [1024] = 957,
  [1025] = 946,
  [1026] = 938,
  [1027] = 992,
  [1028] = 984,
  [1029] = 898,
  [1030] = 897,
  [1031] = 957,
  [1032] = 897,
  [1033] = 957,
  [1034] = 897,
  [1035] = 957,
  [1036] = 929,
  [1037] = 924,
  [1038] = 1007,
  [1039] = 980,
  [1040] = 908,
  [1041] = 929,
  [1042] = 924,
  [1043] = 1007,
  [1044] = 980,
  [1045] = 908,
  [1046] = 924,
  [1047] = 1007,
  [1048] = 980,
  [1049] = 908,
  [1050] = 924,
  [1051] = 1007,
  [1052] = 980,
  [1053] = 908,
  [1054] = 980,
  [1055] = 908,
  [1056] = 980,
  [1057] = 908,
  [1058] = 936,
  [1059] = 946,
  [1060] = 917,
  [1061] = 898,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(278);
      if (lookahead == '!') ADVANCE(127);
      if (lookahead == '"') ADVANCE(1004);
      if (lookahead == '#') ADVANCE(1010);
      if (lookahead == '\'') ADVANCE(1000);
      if (lookahead == '(') ADVANCE(317);
      if (lookahead == ')') ADVANCE(319);
      if (lookahead == '*') ADVANCE(255);
      if (lookahead == '+') ADVANCE(315);
      if (lookahead == ',') ADVANCE(304);
      if (lookahead == '-') ADVANCE(1031);
      if (lookahead == '.') ADVANCE(374);
      if (lookahead == '/') ADVANCE(371);
      if (lookahead == '1') ADVANCE(123);
      if (lookahead == ':') ADVANCE(338);
      if (lookahead == '=') ADVANCE(366);
      if (lookahead == '[') ADVANCE(105);
      if (lookahead == '`') ADVANCE(135);
      if (lookahead == 'a') ADVANCE(214);
      if (lookahead == 'b') ADVANCE(144);
      if (lookahead == 'c') ADVANCE(149);
      if (lookahead == 'd') ADVANCE(162);
      if (lookahead == 'e') ADVANCE(150);
      if (lookahead == 'f') ADVANCE(211);
      if (lookahead == 'h') ADVANCE(239);
      if (lookahead == 'i') ADVANCE(176);
      if (lookahead == 'm') ADVANCE(181);
      if (lookahead == 'p') ADVANCE(192);
      if (lookahead == 's') ADVANCE(157);
      if (lookahead == 't') ADVANCE(220);
      if (lookahead == 'u') ADVANCE(203);
      if (lookahead == 'w') ADVANCE(179);
      if (lookahead == 'x') ADVANCE(200);
      if (lookahead == '{') ADVANCE(1011);
      if (lookahead == '|') ADVANCE(291);
      if (lookahead == '}') ADVANCE(1013);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(141);
      if (lookahead == ']') ADVANCE(834);
      if (lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '[') ADVANCE(61);
      if (lookahead != 0) ADVANCE(68);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(141);
      if (lookahead == ']') ADVANCE(838);
      if (lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '[') ADVANCE(92);
      if (lookahead != 0) ADVANCE(97);
      END_STATE();
    case 3:
      if (lookahead == '\n') ADVANCE(141);
      if (lookahead == ']') ADVANCE(841);
      if (lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '[') ADVANCE(138);
      if (lookahead != 0) ADVANCE(137);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(141);
      if (lookahead == ']') ADVANCE(835);
      if (lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '[') ADVANCE(64);
      if (lookahead != 0) ADVANCE(74);
      END_STATE();
    case 5:
      if (lookahead == '\n') ADVANCE(141);
      if (lookahead == ']') ADVANCE(836);
      if (lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '[') ADVANCE(81);
      if (lookahead != 0) ADVANCE(75);
      END_STATE();
    case 6:
      if (lookahead == '\n') ADVANCE(141);
      if (lookahead == ']') ADVANCE(839);
      if (lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '[') ADVANCE(102);
      if (lookahead != 0) ADVANCE(100);
      END_STATE();
    case 7:
      if (lookahead == '\n') ADVANCE(141);
      if (lookahead == ']') ADVANCE(837);
      if (lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '[') ADVANCE(82);
      if (lookahead != 0) ADVANCE(79);
      END_STATE();
    case 8:
      if (lookahead == '\n') SKIP(8)
      if (lookahead == '!') ADVANCE(1024);
      if (lookahead == '#') ADVANCE(1029);
      if (lookahead == '-') ADVANCE(1032);
      if (lookahead == '.') ADVANCE(1028);
      if (lookahead == '/') ADVANCE(1023);
      if (lookahead == ':') ADVANCE(339);
      if (lookahead == '=') ADVANCE(367);
      if (lookahead == 'a') ADVANCE(967);
      if (lookahead == 'b') ADVANCE(953);
      if (lookahead == 'c') ADVANCE(919);
      if (lookahead == 'd') ADVANCE(931);
      if (lookahead == 'e') ADVANCE(921);
      if (lookahead == 'f') ADVANCE(964);
      if (lookahead == 'i') ADVANCE(943);
      if (lookahead == 'p') ADVANCE(972);
      if (lookahead == 's') ADVANCE(926);
      if (lookahead == 'u') ADVANCE(961);
      if (lookahead == 'w') ADVANCE(945);
      if (lookahead == '|') ADVANCE(292);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(1020);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0) ADVANCE(1030);
      END_STATE();
    case 9:
      if (lookahead == '\n') ADVANCE(118);
      if (lookahead == ',') ADVANCE(45);
      if (lookahead == '}') ADVANCE(814);
      if (lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '[' ||
          lookahead == ']') ADVANCE(61);
      if (lookahead != 0) ADVANCE(71);
      END_STATE();
    case 10:
      if (lookahead == '\n') ADVANCE(118);
      if (lookahead == ',') ADVANCE(46);
      if (lookahead == '}') ADVANCE(818);
      if (lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '[' ||
          lookahead == ']') ADVANCE(92);
      if (lookahead != 0) ADVANCE(99);
      END_STATE();
    case 11:
      if (lookahead == '\n') ADVANCE(118);
      if (lookahead == ',') ADVANCE(47);
      if (lookahead == '}') ADVANCE(822);
      if (lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '[' ||
          lookahead == ']') ADVANCE(138);
      if (lookahead != 0) ADVANCE(121);
      END_STATE();
    case 12:
      if (lookahead == '\n') ADVANCE(118);
      if (lookahead == ',') ADVANCE(48);
      if (lookahead == '}') ADVANCE(815);
      if (lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '[' ||
          lookahead == ']') ADVANCE(64);
      if (lookahead != 0) ADVANCE(77);
      END_STATE();
    case 13:
      if (lookahead == '\n') ADVANCE(118);
      if (lookahead == ',') ADVANCE(49);
      if (lookahead == '}') ADVANCE(816);
      if (lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '[' ||
          lookahead == ']') ADVANCE(81);
      if (lookahead != 0) ADVANCE(78);
      END_STATE();
    case 14:
      if (lookahead == '\n') ADVANCE(118);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '}') ADVANCE(819);
      if (lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '[' ||
          lookahead == ']') ADVANCE(102);
      if (lookahead != 0) ADVANCE(101);
      END_STATE();
    case 15:
      if (lookahead == '\n') ADVANCE(118);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '}') ADVANCE(817);
      if (lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '[' ||
          lookahead == ']') ADVANCE(82);
      if (lookahead != 0) ADVANCE(80);
      END_STATE();
    case 16:
      if (lookahead == '\n') ADVANCE(130);
      if (lookahead == '?') ADVANCE(136);
      if (lookahead != 0) ADVANCE(133);
      END_STATE();
    case 17:
      if (lookahead == '\n') ADVANCE(130);
      if (lookahead == '?') ADVANCE(60);
      if (lookahead != 0) ADVANCE(62);
      END_STATE();
    case 18:
      if (lookahead == '\n') ADVANCE(130);
      if (lookahead == '?') ADVANCE(91);
      if (lookahead != 0) ADVANCE(93);
      END_STATE();
    case 19:
      if (lookahead == '\n') ADVANCE(130);
      if (lookahead == '?') ADVANCE(85);
      if (lookahead != 0) ADVANCE(66);
      END_STATE();
    case 20:
      if (lookahead == '\n') ADVANCE(130);
      if (lookahead == '?') ADVANCE(86);
      if (lookahead != 0) ADVANCE(67);
      END_STATE();
    case 21:
      if (lookahead == '\n') ADVANCE(130);
      if (lookahead == '?') ADVANCE(104);
      if (lookahead != 0) ADVANCE(96);
      END_STATE();
    case 22:
      if (lookahead == '\n') ADVANCE(130);
      if (lookahead == '?') ADVANCE(87);
      if (lookahead != 0) ADVANCE(73);
      END_STATE();
    case 23:
      if (lookahead == '\n') ADVANCE(130);
      if (lookahead == '?') ADVANCE(139);
      if (lookahead != 0) ADVANCE(134);
      END_STATE();
    case 24:
      if (lookahead == '\n') ADVANCE(110);
      if (lookahead == ')') ADVANCE(812);
      if (lookahead != 0) ADVANCE(115);
      END_STATE();
    case 25:
      if (lookahead == '\n') ADVANCE(110);
      if (lookahead == ')') ADVANCE(780);
      if (lookahead != 0) ADVANCE(65);
      END_STATE();
    case 26:
      if (lookahead == '\n') ADVANCE(110);
      if (lookahead == ')') ADVANCE(790);
      if (lookahead != 0) ADVANCE(95);
      END_STATE();
    case 27:
      if (lookahead == '\n') ADVANCE(110);
      if (lookahead == ')') ADVANCE(782);
      if (lookahead != 0) ADVANCE(70);
      END_STATE();
    case 28:
      if (lookahead == '\n') ADVANCE(110);
      if (lookahead == ')') ADVANCE(792);
      if (lookahead != 0) ADVANCE(98);
      END_STATE();
    case 29:
      if (lookahead == '\n') ADVANCE(110);
      if (lookahead == ')') ADVANCE(783);
      if (lookahead != 0) ADVANCE(72);
      END_STATE();
    case 30:
      if (lookahead == '\n') ADVANCE(110);
      if (lookahead == ')') ADVANCE(786);
      if (lookahead != 0) ADVANCE(76);
      END_STATE();
    case 31:
      if (lookahead == '\n') ADVANCE(110);
      if (lookahead == ')') ADVANCE(813);
      if (lookahead != 0) ADVANCE(117);
      END_STATE();
    case 32:
      if (lookahead == '\n') ADVANCE(110);
      if (lookahead == ')') ADVANCE(788);
      if (lookahead != 0) ADVANCE(83);
      END_STATE();
    case 33:
      if (lookahead == '\n') ADVANCE(110);
      if (lookahead == ')') ADVANCE(794);
      if (lookahead != 0) ADVANCE(103);
      END_STATE();
    case 34:
      if (lookahead == '\n') ADVANCE(110);
      if (lookahead == ')') ADVANCE(789);
      if (lookahead != 0) ADVANCE(84);
      END_STATE();
    case 35:
      if (lookahead == '\n') ADVANCE(111);
      if (lookahead == ')') ADVANCE(810);
      if (lookahead == '?') ADVANCE(114);
      if (lookahead != 0) ADVANCE(113);
      END_STATE();
    case 36:
      if (lookahead == '\n') SKIP(36)
      if (lookahead == '#') ADVANCE(1010);
      if (lookahead == '{') ADVANCE(1011);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(1008);
      if (lookahead != 0) ADVANCE(1009);
      END_STATE();
    case 37:
      if (lookahead == '\n') SKIP(37)
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(298);
      if (lookahead != 0) ADVANCE(299);
      END_STATE();
    case 38:
      if (lookahead == '\n') SKIP(38)
      if (lookahead == ':') ADVANCE(340);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(295);
      if (lookahead != 0) ADVANCE(299);
      END_STATE();
    case 39:
      if (lookahead == '\n') SKIP(39)
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(359);
      if (lookahead != 0 &&
          lookahead != ':') ADVANCE(360);
      END_STATE();
    case 40:
      if (lookahead == '\n') SKIP(40)
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(1016);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(1017);
      END_STATE();
    case 41:
      if (lookahead == '\n') SKIP(41)
      if (lookahead == '!') ADVANCE(1024);
      if (lookahead == '#') ADVANCE(1029);
      if (lookahead == '-') ADVANCE(1032);
      if (lookahead == '.') ADVANCE(1028);
      if (lookahead == '/') ADVANCE(1023);
      if (lookahead == ':') ADVANCE(339);
      if (lookahead == '=') ADVANCE(367);
      if (lookahead == 'a') ADVANCE(967);
      if (lookahead == 'b') ADVANCE(953);
      if (lookahead == 'c') ADVANCE(919);
      if (lookahead == 'd') ADVANCE(965);
      if (lookahead == 'e') ADVANCE(921);
      if (lookahead == 'f') ADVANCE(964);
      if (lookahead == 'i') ADVANCE(943);
      if (lookahead == 'p') ADVANCE(972);
      if (lookahead == 's') ADVANCE(926);
      if (lookahead == 'u') ADVANCE(961);
      if (lookahead == 'w') ADVANCE(947);
      if (lookahead == '|') ADVANCE(292);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(1021);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0) ADVANCE(1030);
      END_STATE();
    case 42:
      if (lookahead == '\n') SKIP(42)
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(1027);
      if (lookahead != 0) ADVANCE(1030);
      END_STATE();
    case 43:
      if (lookahead == ' ') ADVANCE(118);
      if (lookahead == ',') ADVANCE(43);
      if (lookahead == '}') ADVANCE(820);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(118);
      END_STATE();
    case 44:
      if (lookahead == ' ') ADVANCE(119);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '?') ADVANCE(120);
      if (lookahead == '}') ADVANCE(821);
      if (lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '[' ||
          lookahead == ']') ADVANCE(130);
      if (lookahead != 0) ADVANCE(119);
      END_STATE();
    case 45:
      if (lookahead == ' ') ADVANCE(71);
      if (lookahead == '"') ADVANCE(762);
      if (lookahead == ',') ADVANCE(45);
      if (lookahead == '\\') ADVANCE(9);
      if (lookahead == '}') ADVANCE(814);
      if (lookahead == '(' ||
          lookahead == ')' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(61);
      if (lookahead != 0) ADVANCE(71);
      END_STATE();
    case 46:
      if (lookahead == ' ') ADVANCE(99);
      if (lookahead == '\'') ADVANCE(762);
      if (lookahead == ',') ADVANCE(46);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '}') ADVANCE(818);
      if (lookahead == '(' ||
          lookahead == ')' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(92);
      if (lookahead != 0) ADVANCE(99);
      END_STATE();
    case 47:
      if (lookahead == ' ') ADVANCE(121);
      if (lookahead == ',') ADVANCE(47);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == '`') ADVANCE(762);
      if (lookahead == '}') ADVANCE(822);
      if (lookahead == '(' ||
          lookahead == ')' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(138);
      if (lookahead != 0) ADVANCE(121);
      END_STATE();
    case 48:
      if (lookahead == ' ') ADVANCE(77);
      if (lookahead == '"') ADVANCE(749);
      if (lookahead == '\'') ADVANCE(726);
      if (lookahead == ',') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(12);
      if (lookahead == '}') ADVANCE(815);
      if (lookahead == '(' ||
          lookahead == ')' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(64);
      if (lookahead != 0) ADVANCE(77);
      END_STATE();
    case 49:
      if (lookahead == ' ') ADVANCE(78);
      if (lookahead == '"') ADVANCE(763);
      if (lookahead == ',') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '`') ADVANCE(726);
      if (lookahead == '}') ADVANCE(816);
      if (lookahead == '(' ||
          lookahead == ')' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(81);
      if (lookahead != 0) ADVANCE(78);
      END_STATE();
    case 50:
      if (lookahead == ' ') ADVANCE(101);
      if (lookahead == '\'') ADVANCE(763);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == '`') ADVANCE(749);
      if (lookahead == '}') ADVANCE(819);
      if (lookahead == '(' ||
          lookahead == ')' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(102);
      if (lookahead != 0) ADVANCE(101);
      END_STATE();
    case 51:
      if (lookahead == ' ') ADVANCE(80);
      if (lookahead == '"') ADVANCE(751);
      if (lookahead == '\'') ADVANCE(731);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '\\') ADVANCE(15);
      if (lookahead == '`') ADVANCE(730);
      if (lookahead == '}') ADVANCE(817);
      if (lookahead == '(' ||
          lookahead == ')' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(82);
      if (lookahead != 0) ADVANCE(80);
      END_STATE();
    case 52:
      if (lookahead == ' ') ADVANCE(372);
      if (lookahead == '!') ADVANCE(127);
      if (lookahead == '#') ADVANCE(253);
      if (lookahead == '(') ADVANCE(317);
      if (lookahead == ')') ADVANCE(319);
      if (lookahead == ',') ADVANCE(304);
      if (lookahead == '.') ADVANCE(374);
      if (lookahead == '/') ADVANCE(370);
      if (lookahead == ':') ADVANCE(338);
      if (lookahead == '=') ADVANCE(366);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r') SKIP(52)
      END_STATE();
    case 53:
      if (lookahead == ' ') ADVANCE(372);
      if (lookahead == '!') ADVANCE(127);
      if (lookahead == ')') ADVANCE(319);
      if (lookahead == ',') ADVANCE(304);
      if (lookahead == '.') ADVANCE(373);
      if (lookahead == '/') ADVANCE(370);
      if (lookahead == ':') ADVANCE(338);
      if (lookahead == '=') ADVANCE(366);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r') SKIP(53)
      END_STATE();
    case 54:
      if (lookahead == ' ') ADVANCE(54);
      if (lookahead == '"') ADVANCE(1005);
      if (lookahead == '\'') ADVANCE(1001);
      if (lookahead == ')') ADVANCE(321);
      if (lookahead == '?') ADVANCE(808);
      if (lookahead == '[') ADVANCE(798);
      if (lookahead == '`') ADVANCE(802);
      if (lookahead == '{') ADVANCE(777);
      if (lookahead == '(' ||
          lookahead == ',') ADVANCE(131);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r') ADVANCE(779);
      if (lookahead != 0) ADVANCE(801);
      END_STATE();
    case 55:
      if (lookahead == ' ') ADVANCE(54);
      if (lookahead == '"') ADVANCE(1005);
      if (lookahead == '\'') ADVANCE(1001);
      if (lookahead == ')') ADVANCE(321);
      if (lookahead == '?') ADVANCE(800);
      if (lookahead == '[') ADVANCE(798);
      if (lookahead == '`') ADVANCE(802);
      if (lookahead == '{') ADVANCE(777);
      if (lookahead == '(' ||
          lookahead == ',') ADVANCE(131);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r') ADVANCE(779);
      if (lookahead != 0) ADVANCE(801);
      END_STATE();
    case 56:
      if (lookahead == '!') ADVANCE(127);
      if (lookahead == '#') ADVANCE(253);
      if (lookahead == '-') ADVANCE(1031);
      if (lookahead == '.') ADVANCE(374);
      if (lookahead == '/') ADVANCE(125);
      if (lookahead == ':') ADVANCE(338);
      if (lookahead == '=') ADVANCE(366);
      if (lookahead == 'a') ADVANCE(896);
      if (lookahead == 'b') ADVANCE(886);
      if (lookahead == 'c') ADVANCE(848);
      if (lookahead == 'd') ADVANCE(894);
      if (lookahead == 'e') ADVANCE(850);
      if (lookahead == 'f') ADVANCE(893);
      if (lookahead == 'i') ADVANCE(872);
      if (lookahead == 'p') ADVANCE(901);
      if (lookahead == 's') ADVANCE(855);
      if (lookahead == 'u') ADVANCE(890);
      if (lookahead == 'w') ADVANCE(876);
      if (lookahead == '|') ADVANCE(291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(56)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 57:
      if (lookahead == '!') ADVANCE(127);
      if (lookahead == '#') ADVANCE(253);
      if (lookahead == '-') ADVANCE(1031);
      if (lookahead == '.') ADVANCE(252);
      if (lookahead == '/') ADVANCE(125);
      if (lookahead == ':') ADVANCE(338);
      if (lookahead == '=') ADVANCE(366);
      if (lookahead == 'a') ADVANCE(896);
      if (lookahead == 'b') ADVANCE(886);
      if (lookahead == 'c') ADVANCE(848);
      if (lookahead == 'd') ADVANCE(865);
      if (lookahead == 'e') ADVANCE(850);
      if (lookahead == 'f') ADVANCE(893);
      if (lookahead == 'i') ADVANCE(872);
      if (lookahead == 'p') ADVANCE(901);
      if (lookahead == 's') ADVANCE(855);
      if (lookahead == 'u') ADVANCE(890);
      if (lookahead == 'w') ADVANCE(875);
      if (lookahead == '|') ADVANCE(291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(57)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 58:
      if (lookahead == '"') ADVANCE(1004);
      if (lookahead == '\'') ADVANCE(1000);
      if (lookahead == ')') ADVANCE(320);
      if (lookahead == '[') ADVANCE(141);
      if (lookahead == '`') ADVANCE(135);
      if (lookahead == '{') ADVANCE(118);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(55);
      if (lookahead != 0) ADVANCE(129);
      END_STATE();
    case 59:
      if (lookahead == '"') ADVANCE(1004);
      if (lookahead == '\\') ADVANCE(266);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(1006);
      if (lookahead != 0) ADVANCE(1007);
      END_STATE();
    case 60:
      if (lookahead == '"') ADVANCE(540);
      if (lookahead == '\\') ADVANCE(377);
      if (lookahead == ')' ||
          lookahead == '?') ADVANCE(61);
      if (lookahead != 0) ADVANCE(613);
      END_STATE();
    case 61:
      if (lookahead == '"') ADVANCE(375);
      if (lookahead == '\\') ADVANCE(260);
      if (lookahead != 0) ADVANCE(61);
      END_STATE();
    case 62:
      if (lookahead == '"') ADVANCE(764);
      if (lookahead == '?') ADVANCE(60);
      if (lookahead == '\\') ADVANCE(17);
      if (lookahead != 0) ADVANCE(62);
      END_STATE();
    case 63:
      if (lookahead == '"') ADVANCE(766);
      if (lookahead == '\\') ADVANCE(262);
      if (lookahead == '`') ADVANCE(824);
      if (lookahead != 0) ADVANCE(63);
      END_STATE();
    case 64:
      if (lookahead == '"') ADVANCE(742);
      if (lookahead == '\'') ADVANCE(717);
      if (lookahead == '\\') ADVANCE(264);
      if (lookahead != 0) ADVANCE(64);
      END_STATE();
    case 65:
      if (lookahead == '"') ADVANCE(759);
      if (lookahead == ')') ADVANCE(780);
      if (lookahead == '\\') ADVANCE(25);
      if (lookahead != 0) ADVANCE(65);
      END_STATE();
    case 66:
      if (lookahead == '"') ADVANCE(743);
      if (lookahead == '\'') ADVANCE(718);
      if (lookahead == '?') ADVANCE(85);
      if (lookahead == '\\') ADVANCE(19);
      if (lookahead != 0) ADVANCE(66);
      END_STATE();
    case 67:
      if (lookahead == '"') ADVANCE(765);
      if (lookahead == '?') ADVANCE(86);
      if (lookahead == '\\') ADVANCE(20);
      if (lookahead == '`') ADVANCE(718);
      if (lookahead != 0) ADVANCE(67);
      END_STATE();
    case 68:
      if (lookahead == '"') ADVANCE(771);
      if (lookahead == '\\') ADVANCE(1);
      if (lookahead == ']') ADVANCE(834);
      if (lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '[') ADVANCE(61);
      if (lookahead != 0) ADVANCE(68);
      END_STATE();
    case 69:
      if (lookahead == '"') ADVANCE(744);
      if (lookahead == '\'') ADVANCE(719);
      if (lookahead == '\\') ADVANCE(265);
      if (lookahead == '`') ADVANCE(825);
      if (lookahead != 0) ADVANCE(69);
      END_STATE();
    case 70:
      if (lookahead == '"') ADVANCE(760);
      if (lookahead == ')') ADVANCE(782);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == '`') ADVANCE(826);
      if (lookahead != 0) ADVANCE(70);
      END_STATE();
    case 71:
      if (lookahead == '"') ADVANCE(762);
      if (lookahead == ',') ADVANCE(45);
      if (lookahead == '\\') ADVANCE(9);
      if (lookahead == '}') ADVANCE(814);
      if (lookahead == '(' ||
          lookahead == ')' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(61);
      if (lookahead != 0) ADVANCE(71);
      END_STATE();
    case 72:
      if (lookahead == '"') ADVANCE(745);
      if (lookahead == '\'') ADVANCE(721);
      if (lookahead == ')') ADVANCE(783);
      if (lookahead == '\\') ADVANCE(29);
      if (lookahead != 0) ADVANCE(72);
      END_STATE();
    case 73:
      if (lookahead == '"') ADVANCE(746);
      if (lookahead == '\'') ADVANCE(723);
      if (lookahead == '?') ADVANCE(87);
      if (lookahead == '\\') ADVANCE(22);
      if (lookahead == '`') ADVANCE(722);
      if (lookahead != 0) ADVANCE(73);
      END_STATE();
    case 74:
      if (lookahead == '"') ADVANCE(747);
      if (lookahead == '\'') ADVANCE(724);
      if (lookahead == '\\') ADVANCE(4);
      if (lookahead == ']') ADVANCE(835);
      if (lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '[') ADVANCE(64);
      if (lookahead != 0) ADVANCE(74);
      END_STATE();
    case 75:
      if (lookahead == '"') ADVANCE(768);
      if (lookahead == '\\') ADVANCE(5);
      if (lookahead == ']') ADVANCE(836);
      if (lookahead == '`') ADVANCE(724);
      if (lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '[') ADVANCE(81);
      if (lookahead != 0) ADVANCE(75);
      END_STATE();
    case 76:
      if (lookahead == '"') ADVANCE(748);
      if (lookahead == '\'') ADVANCE(725);
      if (lookahead == ')') ADVANCE(786);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == '`') ADVANCE(827);
      if (lookahead != 0) ADVANCE(76);
      END_STATE();
    case 77:
      if (lookahead == '"') ADVANCE(749);
      if (lookahead == '\'') ADVANCE(726);
      if (lookahead == ',') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(12);
      if (lookahead == '}') ADVANCE(815);
      if (lookahead == '(' ||
          lookahead == ')' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(64);
      if (lookahead != 0) ADVANCE(77);
      END_STATE();
    case 78:
      if (lookahead == '"') ADVANCE(763);
      if (lookahead == ',') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '`') ADVANCE(726);
      if (lookahead == '}') ADVANCE(816);
      if (lookahead == '(' ||
          lookahead == ')' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(81);
      if (lookahead != 0) ADVANCE(78);
      END_STATE();
    case 79:
      if (lookahead == '"') ADVANCE(750);
      if (lookahead == '\'') ADVANCE(729);
      if (lookahead == '\\') ADVANCE(7);
      if (lookahead == ']') ADVANCE(837);
      if (lookahead == '`') ADVANCE(728);
      if (lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '[') ADVANCE(82);
      if (lookahead != 0) ADVANCE(79);
      END_STATE();
    case 80:
      if (lookahead == '"') ADVANCE(751);
      if (lookahead == '\'') ADVANCE(731);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '\\') ADVANCE(15);
      if (lookahead == '`') ADVANCE(730);
      if (lookahead == '}') ADVANCE(817);
      if (lookahead == '(' ||
          lookahead == ')' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(82);
      if (lookahead != 0) ADVANCE(80);
      END_STATE();
    case 81:
      if (lookahead == '"') ADVANCE(769);
      if (lookahead == '\\') ADVANCE(269);
      if (lookahead == '`') ADVANCE(717);
      if (lookahead != 0) ADVANCE(81);
      END_STATE();
    case 82:
      if (lookahead == '"') ADVANCE(754);
      if (lookahead == '\'') ADVANCE(736);
      if (lookahead == '\\') ADVANCE(271);
      if (lookahead == '`') ADVANCE(720);
      if (lookahead != 0) ADVANCE(82);
      END_STATE();
    case 83:
      if (lookahead == '"') ADVANCE(761);
      if (lookahead == ')') ADVANCE(788);
      if (lookahead == '\\') ADVANCE(32);
      if (lookahead == '`') ADVANCE(721);
      if (lookahead != 0) ADVANCE(83);
      END_STATE();
    case 84:
      if (lookahead == '"') ADVANCE(755);
      if (lookahead == '\'') ADVANCE(737);
      if (lookahead == ')') ADVANCE(789);
      if (lookahead == '\\') ADVANCE(34);
      if (lookahead == '`') ADVANCE(727);
      if (lookahead != 0) ADVANCE(84);
      END_STATE();
    case 85:
      if (lookahead == '"') ADVANCE(619);
      if (lookahead == '\'') ADVANCE(613);
      if (lookahead == '\\') ADVANCE(382);
      if (lookahead == ')' ||
          lookahead == '?') ADVANCE(64);
      if (lookahead != 0) ADVANCE(666);
      END_STATE();
    case 86:
      if (lookahead == '"') ADVANCE(627);
      if (lookahead == '\\') ADVANCE(383);
      if (lookahead == '`') ADVANCE(613);
      if (lookahead == ')' ||
          lookahead == '?') ADVANCE(81);
      if (lookahead != 0) ADVANCE(670);
      END_STATE();
    case 87:
      if (lookahead == '"') ADVANCE(672);
      if (lookahead == '\'') ADVANCE(670);
      if (lookahead == '\\') ADVANCE(386);
      if (lookahead == '`') ADVANCE(666);
      if (lookahead == ')' ||
          lookahead == '?') ADVANCE(82);
      if (lookahead != 0) ADVANCE(699);
      END_STATE();
    case 88:
      if (lookahead == '#') ADVANCE(253);
      if (lookahead == '.') ADVANCE(252);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(88)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 89:
      if (lookahead == '#') ADVANCE(254);
      if (lookahead == '(') ADVANCE(257);
      if (lookahead == ')') ADVANCE(319);
      if (lookahead == '*') ADVANCE(255);
      if (lookahead == '[') ADVANCE(106);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(89)
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(999);
      END_STATE();
    case 90:
      if (lookahead == '\'') ADVANCE(1000);
      if (lookahead == '\\') ADVANCE(267);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(1002);
      if (lookahead != 0) ADVANCE(1003);
      END_STATE();
    case 91:
      if (lookahead == '\'') ADVANCE(540);
      if (lookahead == '\\') ADVANCE(378);
      if (lookahead == ')' ||
          lookahead == '?') ADVANCE(92);
      if (lookahead != 0) ADVANCE(619);
      END_STATE();
    case 92:
      if (lookahead == '\'') ADVANCE(375);
      if (lookahead == '\\') ADVANCE(261);
      if (lookahead != 0) ADVANCE(92);
      END_STATE();
    case 93:
      if (lookahead == '\'') ADVANCE(764);
      if (lookahead == '?') ADVANCE(91);
      if (lookahead == '\\') ADVANCE(18);
      if (lookahead != 0) ADVANCE(93);
      END_STATE();
    case 94:
      if (lookahead == '\'') ADVANCE(766);
      if (lookahead == '\\') ADVANCE(263);
      if (lookahead == '`') ADVANCE(828);
      if (lookahead != 0) ADVANCE(94);
      END_STATE();
    case 95:
      if (lookahead == '\'') ADVANCE(759);
      if (lookahead == ')') ADVANCE(790);
      if (lookahead == '\\') ADVANCE(26);
      if (lookahead != 0) ADVANCE(95);
      END_STATE();
    case 96:
      if (lookahead == '\'') ADVANCE(765);
      if (lookahead == '?') ADVANCE(104);
      if (lookahead == '\\') ADVANCE(21);
      if (lookahead == '`') ADVANCE(743);
      if (lookahead != 0) ADVANCE(96);
      END_STATE();
    case 97:
      if (lookahead == '\'') ADVANCE(771);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == ']') ADVANCE(838);
      if (lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '[') ADVANCE(92);
      if (lookahead != 0) ADVANCE(97);
      END_STATE();
    case 98:
      if (lookahead == '\'') ADVANCE(760);
      if (lookahead == ')') ADVANCE(792);
      if (lookahead == '\\') ADVANCE(28);
      if (lookahead == '`') ADVANCE(829);
      if (lookahead != 0) ADVANCE(98);
      END_STATE();
    case 99:
      if (lookahead == '\'') ADVANCE(762);
      if (lookahead == ',') ADVANCE(46);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '}') ADVANCE(818);
      if (lookahead == '(' ||
          lookahead == ')' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(92);
      if (lookahead != 0) ADVANCE(99);
      END_STATE();
    case 100:
      if (lookahead == '\'') ADVANCE(768);
      if (lookahead == '\\') ADVANCE(6);
      if (lookahead == ']') ADVANCE(839);
      if (lookahead == '`') ADVANCE(747);
      if (lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '[') ADVANCE(102);
      if (lookahead != 0) ADVANCE(100);
      END_STATE();
    case 101:
      if (lookahead == '\'') ADVANCE(763);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == '`') ADVANCE(749);
      if (lookahead == '}') ADVANCE(819);
      if (lookahead == '(' ||
          lookahead == ')' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(102);
      if (lookahead != 0) ADVANCE(101);
      END_STATE();
    case 102:
      if (lookahead == '\'') ADVANCE(769);
      if (lookahead == '\\') ADVANCE(270);
      if (lookahead == '`') ADVANCE(742);
      if (lookahead != 0) ADVANCE(102);
      END_STATE();
    case 103:
      if (lookahead == '\'') ADVANCE(761);
      if (lookahead == ')') ADVANCE(794);
      if (lookahead == '\\') ADVANCE(33);
      if (lookahead == '`') ADVANCE(745);
      if (lookahead != 0) ADVANCE(103);
      END_STATE();
    case 104:
      if (lookahead == '\'') ADVANCE(627);
      if (lookahead == '\\') ADVANCE(384);
      if (lookahead == '`') ADVANCE(619);
      if (lookahead == ')' ||
          lookahead == '?') ADVANCE(102);
      if (lookahead != 0) ADVANCE(672);
      END_STATE();
    case 105:
      if (lookahead == '(') ADVANCE(256);
      if (lookahead == ']') ADVANCE(833);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(140);
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != '[') ADVANCE(141);
      END_STATE();
    case 106:
      if (lookahead == '(') ADVANCE(256);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(143);
      END_STATE();
    case 107:
      if (lookahead == ')') ADVANCE(319);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(107)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 108:
      if (lookahead == ')') ADVANCE(142);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(108);
      END_STATE();
    case 109:
      if (lookahead == ')') ADVANCE(773);
      if (lookahead == '?') ADVANCE(110);
      if (lookahead != 0) ADVANCE(543);
      END_STATE();
    case 110:
      if (lookahead == ')') ADVANCE(773);
      if (lookahead != 0) ADVANCE(110);
      END_STATE();
    case 111:
      if (lookahead == ')') ADVANCE(809);
      if (lookahead == '?') ADVANCE(109);
      if (lookahead != 0) ADVANCE(111);
      END_STATE();
    case 112:
      if (lookahead == ')') ADVANCE(809);
      if (lookahead == '?') ADVANCE(803);
      if (lookahead == ' ' ||
          lookahead == '(' ||
          lookahead == ',') ADVANCE(111);
      if (lookahead != 0) ADVANCE(799);
      END_STATE();
    case 113:
      if (lookahead == ')') ADVANCE(810);
      if (lookahead == '?') ADVANCE(114);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == '`') ADVANCE(831);
      if (lookahead != 0) ADVANCE(113);
      END_STATE();
    case 114:
      if (lookahead == ')') ADVANCE(812);
      if (lookahead == '?') ADVANCE(115);
      if (lookahead == '\\') ADVANCE(387);
      if (lookahead == '`') ADVANCE(543);
      if (lookahead != 0) ADVANCE(548);
      END_STATE();
    case 115:
      if (lookahead == ')') ADVANCE(812);
      if (lookahead == '\\') ADVANCE(24);
      if (lookahead == '`') ADVANCE(830);
      if (lookahead != 0) ADVANCE(115);
      END_STATE();
    case 116:
      if (lookahead == ')') ADVANCE(996);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 117:
      if (lookahead == ')') ADVANCE(813);
      if (lookahead == '\\') ADVANCE(31);
      if (lookahead == '`') ADVANCE(759);
      if (lookahead != 0) ADVANCE(117);
      END_STATE();
    case 118:
      if (lookahead == ',') ADVANCE(43);
      if (lookahead == '}') ADVANCE(820);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(118);
      END_STATE();
    case 119:
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '?') ADVANCE(120);
      if (lookahead == '}') ADVANCE(821);
      if (lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '[' ||
          lookahead == ']') ADVANCE(130);
      if (lookahead != 0) ADVANCE(119);
      END_STATE();
    case 120:
      if (lookahead == ',') ADVANCE(549);
      if (lookahead == '?') ADVANCE(118);
      if (lookahead == '}') ADVANCE(549);
      if (lookahead == '(' ||
          lookahead == '[' ||
          lookahead == ']') ADVANCE(540);
      if (lookahead != 0 &&
          lookahead != ')') ADVANCE(549);
      END_STATE();
    case 121:
      if (lookahead == ',') ADVANCE(47);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == '`') ADVANCE(762);
      if (lookahead == '}') ADVANCE(822);
      if (lookahead == '(' ||
          lookahead == ')' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(138);
      if (lookahead != 0) ADVANCE(121);
      END_STATE();
    case 122:
      if (lookahead == '-') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 123:
      if (lookahead == '.') ADVANCE(126);
      END_STATE();
    case 124:
      if (lookahead == '.') ADVANCE(368);
      END_STATE();
    case 125:
      if (lookahead == '/') ADVANCE(843);
      END_STATE();
    case 126:
      if (lookahead == '1') ADVANCE(287);
      END_STATE();
    case 127:
      if (lookahead == '=') ADVANCE(364);
      END_STATE();
    case 128:
      if (lookahead == '?') ADVANCE(141);
      if (lookahead == ']') ADVANCE(540);
      if (lookahead == '(' ||
          lookahead == '[') ADVANCE(540);
      if (lookahead != 0 &&
          lookahead != ')') ADVANCE(546);
      END_STATE();
    case 129:
      if (lookahead == '?') ADVANCE(797);
      if (lookahead == ' ' ||
          lookahead == '(' ||
          lookahead == ')' ||
          lookahead == ',') ADVANCE(130);
      if (lookahead != 0) ADVANCE(801);
      END_STATE();
    case 130:
      if (lookahead == '?') ADVANCE(258);
      if (lookahead != 0) ADVANCE(130);
      END_STATE();
    case 131:
      if (lookahead == '?') ADVANCE(804);
      if (lookahead == ' ' ||
          lookahead == '(' ||
          lookahead == ')' ||
          lookahead == ',') ADVANCE(130);
      if (lookahead != 0) ADVANCE(801);
      END_STATE();
    case 132:
      if (lookahead == '?') ADVANCE(128);
      if (lookahead == ']') ADVANCE(840);
      if (lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '[') ADVANCE(130);
      if (lookahead != 0) ADVANCE(132);
      END_STATE();
    case 133:
      if (lookahead == '?') ADVANCE(136);
      if (lookahead == '\\') ADVANCE(16);
      if (lookahead == '`') ADVANCE(832);
      if (lookahead != 0) ADVANCE(133);
      END_STATE();
    case 134:
      if (lookahead == '?') ADVANCE(139);
      if (lookahead == '\\') ADVANCE(23);
      if (lookahead == '`') ADVANCE(764);
      if (lookahead != 0) ADVANCE(134);
      END_STATE();
    case 135:
      if (lookahead == '\\') ADVANCE(259);
      if (lookahead == '`') ADVANCE(823);
      if (lookahead != 0) ADVANCE(135);
      END_STATE();
    case 136:
      if (lookahead == '\\') ADVANCE(376);
      if (lookahead == '`') ADVANCE(540);
      if (lookahead == ')' ||
          lookahead == '?') ADVANCE(135);
      if (lookahead != 0) ADVANCE(595);
      END_STATE();
    case 137:
      if (lookahead == '\\') ADVANCE(3);
      if (lookahead == ']') ADVANCE(841);
      if (lookahead == '`') ADVANCE(771);
      if (lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '[') ADVANCE(138);
      if (lookahead != 0) ADVANCE(137);
      END_STATE();
    case 138:
      if (lookahead == '\\') ADVANCE(268);
      if (lookahead == '`') ADVANCE(375);
      if (lookahead != 0) ADVANCE(138);
      END_STATE();
    case 139:
      if (lookahead == '\\') ADVANCE(379);
      if (lookahead == '`') ADVANCE(540);
      if (lookahead == ')' ||
          lookahead == '?') ADVANCE(138);
      if (lookahead != 0) ADVANCE(627);
      END_STATE();
    case 140:
      if (lookahead == ']') ADVANCE(833);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(140);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != '[') ADVANCE(141);
      END_STATE();
    case 141:
      if (lookahead == ']') ADVANCE(833);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != '[') ADVANCE(141);
      END_STATE();
    case 142:
      if (lookahead == ']') ADVANCE(997);
      END_STATE();
    case 143:
      if (lookahead == ']') ADVANCE(995);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(143);
      END_STATE();
    case 144:
      if (lookahead == 'a') ADVANCE(225);
      if (lookahead == 'l') ADVANCE(212);
      END_STATE();
    case 145:
      if (lookahead == 'a') ADVANCE(241);
      END_STATE();
    case 146:
      if (lookahead == 'a') ADVANCE(896);
      if (lookahead == 'p') ADVANCE(901);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(146)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 147:
      if (lookahead == 'a') ADVANCE(210);
      END_STATE();
    case 148:
      if (lookahead == 'a') ADVANCE(202);
      END_STATE();
    case 149:
      if (lookahead == 'a') ADVANCE(226);
      END_STATE();
    case 150:
      if (lookahead == 'a') ADVANCE(155);
      if (lookahead == 'l') ADVANCE(228);
      if (lookahead == 'x') ADVANCE(240);
      END_STATE();
    case 151:
      if (lookahead == 'a') ADVANCE(195);
      END_STATE();
    case 152:
      if (lookahead == 'b') ADVANCE(190);
      END_STATE();
    case 153:
      if (lookahead == 'c') ADVANCE(191);
      END_STATE();
    case 154:
      if (lookahead == 'c') ADVANCE(288);
      END_STATE();
    case 155:
      if (lookahead == 'c') ADVANCE(180);
      END_STATE();
    case 156:
      if (lookahead == 'c') ADVANCE(232);
      END_STATE();
    case 157:
      if (lookahead == 'c') ADVANCE(221);
      if (lookahead == 't') ADVANCE(222);
      END_STATE();
    case 158:
      if (lookahead == 'c') ADVANCE(234);
      END_STATE();
    case 159:
      if (lookahead == 'd') ADVANCE(329);
      END_STATE();
    case 160:
      if (lookahead == 'd') ADVANCE(332);
      END_STATE();
    case 161:
      if (lookahead == 'd') ADVANCE(224);
      END_STATE();
    case 162:
      if (lookahead == 'e') ADVANCE(178);
      if (lookahead == 'o') ADVANCE(156);
      END_STATE();
    case 163:
      if (lookahead == 'e') ADVANCE(353);
      END_STATE();
    case 164:
      if (lookahead == 'e') ADVANCE(306);
      END_STATE();
    case 165:
      if (lookahead == 'e') ADVANCE(300);
      END_STATE();
    case 166:
      if (lookahead == 'e') ADVANCE(289);
      END_STATE();
    case 167:
      if (lookahead == 'e') ADVANCE(279);
      END_STATE();
    case 168:
      if (lookahead == 'e') ADVANCE(204);
      if (lookahead == 'i') ADVANCE(198);
      END_STATE();
    case 169:
      if (lookahead == 'e') ADVANCE(205);
      END_STATE();
    case 170:
      if (lookahead == 'e') ADVANCE(229);
      END_STATE();
    case 171:
      if (lookahead == 'e') ADVANCE(207);
      END_STATE();
    case 172:
      if (lookahead == 'e') ADVANCE(208);
      END_STATE();
    case 173:
      if (lookahead == 'e') ADVANCE(236);
      END_STATE();
    case 174:
      if (lookahead == 'e') ADVANCE(231);
      END_STATE();
    case 175:
      if (lookahead == 'e') ADVANCE(218);
      END_STATE();
    case 176:
      if (lookahead == 'f') ADVANCE(348);
      if (lookahead == 'n') ADVANCE(314);
      END_STATE();
    case 177:
      if (lookahead == 'f') ADVANCE(351);
      END_STATE();
    case 178:
      if (lookahead == 'f') ADVANCE(145);
      END_STATE();
    case 179:
      if (lookahead == 'h') ADVANCE(168);
      END_STATE();
    case 180:
      if (lookahead == 'h') ADVANCE(308);
      END_STATE();
    case 181:
      if (lookahead == 'i') ADVANCE(242);
      if (lookahead == 'o') ADVANCE(152);
      END_STATE();
    case 182:
      if (lookahead == 'i') ADVANCE(213);
      END_STATE();
    case 183:
      if (lookahead == 'i') ADVANCE(177);
      END_STATE();
    case 184:
      if (lookahead == 'i') ADVANCE(216);
      END_STATE();
    case 185:
      if (lookahead == 'i') ADVANCE(227);
      END_STATE();
    case 186:
      if (lookahead == 'i') ADVANCE(154);
      END_STATE();
    case 187:
      if (lookahead == 'i') ADVANCE(206);
      END_STATE();
    case 188:
      if (lookahead == 'i') ADVANCE(238);
      END_STATE();
    case 189:
      if (lookahead == 'i') ADVANCE(158);
      END_STATE();
    case 190:
      if (lookahead == 'i') ADVANCE(199);
      END_STATE();
    case 191:
      if (lookahead == 'k') ADVANCE(326);
      END_STATE();
    case 192:
      if (lookahead == 'l') ADVANCE(185);
      if (lookahead == 'r') ADVANCE(175);
      END_STATE();
    case 193:
      if (lookahead == 'l') ADVANCE(284);
      END_STATE();
    case 194:
      if (lookahead == 'l') ADVANCE(282);
      END_STATE();
    case 195:
      if (lookahead == 'l') ADVANCE(285);
      END_STATE();
    case 196:
      if (lookahead == 'l') ADVANCE(170);
      END_STATE();
    case 197:
      if (lookahead == 'l') ADVANCE(235);
      END_STATE();
    case 198:
      if (lookahead == 'l') ADVANCE(165);
      END_STATE();
    case 199:
      if (lookahead == 'l') ADVANCE(166);
      END_STATE();
    case 200:
      if (lookahead == 'm') ADVANCE(193);
      END_STATE();
    case 201:
      if (lookahead == 'm') ADVANCE(194);
      END_STATE();
    case 202:
      if (lookahead == 'm') ADVANCE(174);
      END_STATE();
    case 203:
      if (lookahead == 'n') ADVANCE(196);
      END_STATE();
    case 204:
      if (lookahead == 'n') ADVANCE(356);
      END_STATE();
    case 205:
      if (lookahead == 'n') ADVANCE(159);
      END_STATE();
    case 206:
      if (lookahead == 'n') ADVANCE(322);
      END_STATE();
    case 207:
      if (lookahead == 'n') ADVANCE(161);
      END_STATE();
    case 208:
      if (lookahead == 'n') ADVANCE(160);
      END_STATE();
    case 209:
      if (lookahead == 'n') ADVANCE(151);
      END_STATE();
    case 210:
      if (lookahead == 'n') ADVANCE(230);
      END_STATE();
    case 211:
      if (lookahead == 'o') ADVANCE(219);
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 212:
      if (lookahead == 'o') ADVANCE(153);
      END_STATE();
    case 213:
      if (lookahead == 'o') ADVANCE(209);
      END_STATE();
    case 214:
      if (lookahead == 'p') ADVANCE(215);
      END_STATE();
    case 215:
      if (lookahead == 'p') ADVANCE(169);
      END_STATE();
    case 216:
      if (lookahead == 'p') ADVANCE(237);
      END_STATE();
    case 217:
      if (lookahead == 'p') ADVANCE(167);
      END_STATE();
    case 218:
      if (lookahead == 'p') ADVANCE(172);
      END_STATE();
    case 219:
      if (lookahead == 'r') ADVANCE(311);
      END_STATE();
    case 220:
      if (lookahead == 'r') ADVANCE(147);
      END_STATE();
    case 221:
      if (lookahead == 'r') ADVANCE(184);
      END_STATE();
    case 222:
      if (lookahead == 'r') ADVANCE(189);
      END_STATE();
    case 223:
      if (lookahead == 's') ADVANCE(345);
      END_STATE();
    case 224:
      if (lookahead == 's') ADVANCE(335);
      END_STATE();
    case 225:
      if (lookahead == 's') ADVANCE(186);
      END_STATE();
    case 226:
      if (lookahead == 's') ADVANCE(163);
      END_STATE();
    case 227:
      if (lookahead == 's') ADVANCE(233);
      END_STATE();
    case 228:
      if (lookahead == 's') ADVANCE(164);
      END_STATE();
    case 229:
      if (lookahead == 's') ADVANCE(223);
      END_STATE();
    case 230:
      if (lookahead == 's') ADVANCE(188);
      END_STATE();
    case 231:
      if (lookahead == 's') ADVANCE(173);
      END_STATE();
    case 232:
      if (lookahead == 't') ADVANCE(243);
      END_STATE();
    case 233:
      if (lookahead == 't') ADVANCE(290);
      END_STATE();
    case 234:
      if (lookahead == 't') ADVANCE(283);
      END_STATE();
    case 235:
      if (lookahead == 't') ADVANCE(361);
      END_STATE();
    case 236:
      if (lookahead == 't') ADVANCE(286);
      END_STATE();
    case 237:
      if (lookahead == 't') ADVANCE(124);
      END_STATE();
    case 238:
      if (lookahead == 't') ADVANCE(182);
      END_STATE();
    case 239:
      if (lookahead == 't') ADVANCE(201);
      END_STATE();
    case 240:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 241:
      if (lookahead == 'u') ADVANCE(197);
      END_STATE();
    case 242:
      if (lookahead == 'x') ADVANCE(187);
      END_STATE();
    case 243:
      if (lookahead == 'y') ADVANCE(217);
      END_STATE();
    case 244:
      if (lookahead == '}') ADVANCE(1015);
      END_STATE();
    case 245:
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(342);
      if (lookahead == '!') ADVANCE(127);
      if (lookahead == '#') ADVANCE(253);
      if (lookahead == '(') ADVANCE(317);
      if (lookahead == '-') ADVANCE(1031);
      if (lookahead == '.') ADVANCE(252);
      if (lookahead == '/') ADVANCE(125);
      if (lookahead == ':') ADVANCE(338);
      if (lookahead == '=') ADVANCE(366);
      if (lookahead == 'a') ADVANCE(896);
      if (lookahead == 'b') ADVANCE(886);
      if (lookahead == 'c') ADVANCE(848);
      if (lookahead == 'd') ADVANCE(894);
      if (lookahead == 'e') ADVANCE(850);
      if (lookahead == 'f') ADVANCE(893);
      if (lookahead == 'i') ADVANCE(872);
      if (lookahead == 'p') ADVANCE(901);
      if (lookahead == 's') ADVANCE(855);
      if (lookahead == 'u') ADVANCE(890);
      if (lookahead == 'w') ADVANCE(876);
      if (lookahead == '|') ADVANCE(291);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(245)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 246:
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(342);
      if (lookahead == '!') ADVANCE(127);
      if (lookahead == '#') ADVANCE(253);
      if (lookahead == '(') ADVANCE(317);
      if (lookahead == '-') ADVANCE(1031);
      if (lookahead == '.') ADVANCE(252);
      if (lookahead == '/') ADVANCE(125);
      if (lookahead == ':') ADVANCE(338);
      if (lookahead == '=') ADVANCE(366);
      if (lookahead == 'a') ADVANCE(896);
      if (lookahead == 'b') ADVANCE(886);
      if (lookahead == 'c') ADVANCE(848);
      if (lookahead == 'd') ADVANCE(865);
      if (lookahead == 'e') ADVANCE(850);
      if (lookahead == 'f') ADVANCE(893);
      if (lookahead == 'i') ADVANCE(872);
      if (lookahead == 'p') ADVANCE(901);
      if (lookahead == 's') ADVANCE(855);
      if (lookahead == 'u') ADVANCE(890);
      if (lookahead == 'w') ADVANCE(875);
      if (lookahead == '|') ADVANCE(291);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(246)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 247:
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(296);
      if (lookahead == '\n') SKIP(247)
      if (lookahead == '\r') ADVANCE(296);
      if (lookahead == '(') ADVANCE(318);
      if (lookahead == ':') ADVANCE(340);
      if (lookahead != 0) ADVANCE(299);
      END_STATE();
    case 248:
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(297);
      if (lookahead == '\n') SKIP(248)
      if (lookahead == '\r') ADVANCE(297);
      if (lookahead == ':') ADVANCE(340);
      if (lookahead != 0) ADVANCE(299);
      END_STATE();
    case 249:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(249)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(303);
      END_STATE();
    case 250:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(250)
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(842);
      END_STATE();
    case 251:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(251)
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(341);
      END_STATE();
    case 252:
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(252);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(991);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(989);
      END_STATE();
    case 253:
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(993);
      END_STATE();
    case 254:
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(999);
      END_STATE();
    case 255:
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(998);
      END_STATE();
    case 256:
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(108);
      END_STATE();
    case 257:
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 258:
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != '?') ADVANCE(540);
      END_STATE();
    case 259:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(135);
      END_STATE();
    case 260:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(61);
      END_STATE();
    case 261:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(92);
      END_STATE();
    case 262:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(63);
      END_STATE();
    case 263:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(94);
      END_STATE();
    case 264:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(64);
      END_STATE();
    case 265:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(69);
      END_STATE();
    case 266:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1007);
      END_STATE();
    case 267:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1003);
      END_STATE();
    case 268:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(138);
      END_STATE();
    case 269:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(81);
      END_STATE();
    case 270:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(102);
      END_STATE();
    case 271:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(82);
      END_STATE();
    case 272:
      if (eof) ADVANCE(278);
      if (lookahead == '\n') SKIP(272)
      if (lookahead == '!') ADVANCE(1024);
      if (lookahead == '#') ADVANCE(1029);
      if (lookahead == '+') ADVANCE(316);
      if (lookahead == '-') ADVANCE(1032);
      if (lookahead == '.') ADVANCE(1028);
      if (lookahead == '/') ADVANCE(1023);
      if (lookahead == ':') ADVANCE(339);
      if (lookahead == '=') ADVANCE(367);
      if (lookahead == 'a') ADVANCE(967);
      if (lookahead == 'b') ADVANCE(953);
      if (lookahead == 'c') ADVANCE(919);
      if (lookahead == 'd') ADVANCE(931);
      if (lookahead == 'e') ADVANCE(921);
      if (lookahead == 'f') ADVANCE(964);
      if (lookahead == 'i') ADVANCE(943);
      if (lookahead == 'm') ADVANCE(948);
      if (lookahead == 'p') ADVANCE(972);
      if (lookahead == 's') ADVANCE(926);
      if (lookahead == 'u') ADVANCE(961);
      if (lookahead == 'w') ADVANCE(945);
      if (lookahead == '|') ADVANCE(292);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(1018);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0) ADVANCE(1030);
      END_STATE();
    case 273:
      if (eof) ADVANCE(278);
      if (lookahead == '\n') SKIP(273)
      if (lookahead == '!') ADVANCE(1024);
      if (lookahead == '#') ADVANCE(1029);
      if (lookahead == '+') ADVANCE(316);
      if (lookahead == '-') ADVANCE(1032);
      if (lookahead == '.') ADVANCE(1028);
      if (lookahead == '/') ADVANCE(1023);
      if (lookahead == ':') ADVANCE(339);
      if (lookahead == '=') ADVANCE(367);
      if (lookahead == 'a') ADVANCE(967);
      if (lookahead == 'b') ADVANCE(953);
      if (lookahead == 'c') ADVANCE(919);
      if (lookahead == 'd') ADVANCE(965);
      if (lookahead == 'e') ADVANCE(921);
      if (lookahead == 'f') ADVANCE(964);
      if (lookahead == 'i') ADVANCE(943);
      if (lookahead == 'm') ADVANCE(948);
      if (lookahead == 'p') ADVANCE(972);
      if (lookahead == 's') ADVANCE(926);
      if (lookahead == 'u') ADVANCE(961);
      if (lookahead == 'w') ADVANCE(947);
      if (lookahead == '|') ADVANCE(292);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(1019);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0) ADVANCE(1030);
      END_STATE();
    case 274:
      if (eof) ADVANCE(278);
      if (lookahead == '!') ADVANCE(127);
      if (lookahead == '#') ADVANCE(253);
      if (lookahead == '(') ADVANCE(317);
      if (lookahead == '+') ADVANCE(315);
      if (lookahead == '-') ADVANCE(1031);
      if (lookahead == '.') ADVANCE(252);
      if (lookahead == '/') ADVANCE(125);
      if (lookahead == ':') ADVANCE(338);
      if (lookahead == '=') ADVANCE(366);
      if (lookahead == 'a') ADVANCE(896);
      if (lookahead == 'b') ADVANCE(886);
      if (lookahead == 'c') ADVANCE(848);
      if (lookahead == 'd') ADVANCE(894);
      if (lookahead == 'e') ADVANCE(850);
      if (lookahead == 'f') ADVANCE(893);
      if (lookahead == 'i') ADVANCE(872);
      if (lookahead == 'm') ADVANCE(877);
      if (lookahead == 'p') ADVANCE(901);
      if (lookahead == 's') ADVANCE(855);
      if (lookahead == 'u') ADVANCE(890);
      if (lookahead == 'w') ADVANCE(876);
      if (lookahead == '|') ADVANCE(291);
      if (lookahead == '}') ADVANCE(244);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(274)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 275:
      if (eof) ADVANCE(278);
      if (lookahead == '!') ADVANCE(127);
      if (lookahead == '#') ADVANCE(253);
      if (lookahead == '+') ADVANCE(315);
      if (lookahead == '-') ADVANCE(1031);
      if (lookahead == '.') ADVANCE(252);
      if (lookahead == '/') ADVANCE(125);
      if (lookahead == ':') ADVANCE(338);
      if (lookahead == '=') ADVANCE(366);
      if (lookahead == 'a') ADVANCE(896);
      if (lookahead == 'b') ADVANCE(886);
      if (lookahead == 'c') ADVANCE(848);
      if (lookahead == 'd') ADVANCE(865);
      if (lookahead == 'e') ADVANCE(850);
      if (lookahead == 'f') ADVANCE(893);
      if (lookahead == 'i') ADVANCE(872);
      if (lookahead == 'm') ADVANCE(877);
      if (lookahead == 'p') ADVANCE(901);
      if (lookahead == 's') ADVANCE(855);
      if (lookahead == 'u') ADVANCE(890);
      if (lookahead == 'w') ADVANCE(875);
      if (lookahead == '|') ADVANCE(291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(275)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 276:
      if (eof) ADVANCE(278);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(342);
      if (lookahead == '!') ADVANCE(127);
      if (lookahead == '#') ADVANCE(253);
      if (lookahead == '(') ADVANCE(317);
      if (lookahead == '+') ADVANCE(315);
      if (lookahead == '-') ADVANCE(1031);
      if (lookahead == '.') ADVANCE(252);
      if (lookahead == '/') ADVANCE(125);
      if (lookahead == ':') ADVANCE(338);
      if (lookahead == '=') ADVANCE(366);
      if (lookahead == 'a') ADVANCE(896);
      if (lookahead == 'b') ADVANCE(886);
      if (lookahead == 'c') ADVANCE(848);
      if (lookahead == 'd') ADVANCE(894);
      if (lookahead == 'e') ADVANCE(850);
      if (lookahead == 'f') ADVANCE(893);
      if (lookahead == 'i') ADVANCE(872);
      if (lookahead == 'm') ADVANCE(877);
      if (lookahead == 'p') ADVANCE(901);
      if (lookahead == 's') ADVANCE(855);
      if (lookahead == 'u') ADVANCE(890);
      if (lookahead == 'w') ADVANCE(876);
      if (lookahead == '|') ADVANCE(291);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(276)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 277:
      if (eof) ADVANCE(278);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(342);
      if (lookahead == '!') ADVANCE(127);
      if (lookahead == '#') ADVANCE(253);
      if (lookahead == '(') ADVANCE(317);
      if (lookahead == '+') ADVANCE(315);
      if (lookahead == '-') ADVANCE(1031);
      if (lookahead == '.') ADVANCE(252);
      if (lookahead == '/') ADVANCE(125);
      if (lookahead == ':') ADVANCE(338);
      if (lookahead == '=') ADVANCE(366);
      if (lookahead == 'a') ADVANCE(896);
      if (lookahead == 'b') ADVANCE(886);
      if (lookahead == 'c') ADVANCE(848);
      if (lookahead == 'd') ADVANCE(865);
      if (lookahead == 'e') ADVANCE(850);
      if (lookahead == 'f') ADVANCE(893);
      if (lookahead == 'i') ADVANCE(872);
      if (lookahead == 'm') ADVANCE(877);
      if (lookahead == 'p') ADVANCE(901);
      if (lookahead == 's') ADVANCE(855);
      if (lookahead == 'u') ADVANCE(890);
      if (lookahead == 'w') ADVANCE(875);
      if (lookahead == '|') ADVANCE(291);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(277)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_doctype);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_doctype);
      if (lookahead == '-') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_doctype);
      if (lookahead == '-') ADVANCE(1022);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_html);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_strict);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_xml);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_transitional);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_frameset);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_1_DOT1);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_basic);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_mobile);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_plist);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_include);
      if (lookahead == '-') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_include);
      if (lookahead == '-') ADVANCE(1022);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(aux_sym_include_token1);
      if (lookahead == ':') ADVANCE(340);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(295);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(299);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(aux_sym_include_token1);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(296);
      if (lookahead == '\r') ADVANCE(296);
      if (lookahead == '(') ADVANCE(318);
      if (lookahead == ':') ADVANCE(340);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(299);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(aux_sym_include_token1);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(297);
      if (lookahead == '\r') ADVANCE(297);
      if (lookahead == ':') ADVANCE(340);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(299);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(aux_sym_include_token1);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(298);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(299);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(aux_sym_include_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(299);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_while);
      if (lookahead == '-') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_while);
      if (lookahead == '-') ADVANCE(1022);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(aux_sym__each_js_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(303);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == ' ') ADVANCE(1026);
      if (lookahead == '-') ADVANCE(1022);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == ' ') ADVANCE(183);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == ' ') ADVANCE(183);
      if (lookahead == '-') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_each);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(anon_sym_each);
      if (lookahead == '-') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(anon_sym_each);
      if (lookahead == '-') ADVANCE(1022);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(anon_sym_for);
      if (lookahead == '-') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(anon_sym_for);
      if (lookahead == '-') ADVANCE(1022);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(299);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      if (lookahead == '?') ADVANCE(797);
      if (lookahead == ' ' ||
          lookahead == '(' ||
          lookahead == ')' ||
          lookahead == ',') ADVANCE(130);
      if (lookahead != 0) ADVANCE(801);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      if (lookahead == '?') ADVANCE(804);
      if (lookahead == ' ' ||
          lookahead == '(' ||
          lookahead == ')' ||
          lookahead == ',') ADVANCE(130);
      if (lookahead != 0) ADVANCE(801);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(anon_sym_mixin);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(anon_sym_mixin);
      if (lookahead == '-') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(anon_sym_mixin);
      if (lookahead == '-') ADVANCE(1022);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(aux_sym_mixin_attributes_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(anon_sym_block);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(anon_sym_block);
      if (lookahead == '-') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(anon_sym_block);
      if (lookahead == '-') ADVANCE(1022);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(anon_sym_append);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(anon_sym_append);
      if (lookahead == '-') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(anon_sym_append);
      if (lookahead == '-') ADVANCE(1022);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(anon_sym_prepend);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(anon_sym_prepend);
      if (lookahead == '-') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(anon_sym_prepend);
      if (lookahead == '-') ADVANCE(1022);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(anon_sym_extends);
      if (lookahead == '-') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(anon_sym_extends);
      if (lookahead == '-') ADVANCE(1022);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(299);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym_filter_name);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(341);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(aux_sym_filter_content_token1);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(342);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(aux_sym_filter_content_token2);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(343);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(344);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(aux_sym_filter_content_token2);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(344);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(anon_sym_unless);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(anon_sym_unless);
      if (lookahead == '-') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(anon_sym_unless);
      if (lookahead == '-') ADVANCE(1022);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(anon_sym_if);
      if (lookahead == '-') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(anon_sym_if);
      if (lookahead == '-') ADVANCE(1022);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(anon_sym_elseif);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(anon_sym_elseif);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(anon_sym_case);
      if (lookahead == '-') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(anon_sym_case);
      if (lookahead == '-') ADVANCE(1022);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(anon_sym_when);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(anon_sym_when);
      if (lookahead == '-') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(anon_sym_when);
      if (lookahead == '-') ADVANCE(1022);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(aux_sym__when_keyword_token1);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(359);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != ':') ADVANCE(360);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(aux_sym__when_keyword_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != ':') ADVANCE(360);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(anon_sym_default);
      if (lookahead == '-') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(anon_sym_default);
      if (lookahead == '-') ADVANCE(1022);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(anon_sym_script_DOT);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(anon_sym_script_DOT);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(843);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(anon_sym_);
      if (lookahead == ' ') ADVANCE(372);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(252);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(991);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(989);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(540);
      if (lookahead == ' ') ADVANCE(595);
      if (lookahead == '"') ADVANCE(660);
      if (lookahead == '\'') ADVANCE(662);
      if (lookahead == ')') ADVANCE(135);
      if (lookahead == '?') ADVANCE(767);
      if (lookahead == '`') ADVANCE(627);
      if (lookahead != 0) ADVANCE(595);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(540);
      if (lookahead == ' ') ADVANCE(613);
      if (lookahead == '"') ADVANCE(613);
      if (lookahead == '\'') ADVANCE(666);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == '?') ADVANCE(709);
      if (lookahead == '`') ADVANCE(670);
      if (lookahead != 0) ADVANCE(613);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(540);
      if (lookahead == ' ') ADVANCE(619);
      if (lookahead == '"') ADVANCE(666);
      if (lookahead == '\'') ADVANCE(619);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == '?') ADVANCE(738);
      if (lookahead == '`') ADVANCE(672);
      if (lookahead != 0) ADVANCE(619);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(540);
      if (lookahead == ' ') ADVANCE(627);
      if (lookahead == '"') ADVANCE(670);
      if (lookahead == '\'') ADVANCE(672);
      if (lookahead == ')') ADVANCE(138);
      if (lookahead == '?') ADVANCE(770);
      if (lookahead == '`') ADVANCE(627);
      if (lookahead != 0) ADVANCE(627);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(540);
      if (lookahead == ' ') ADVANCE(660);
      if (lookahead == '"') ADVANCE(660);
      if (lookahead == '\'') ADVANCE(695);
      if (lookahead == ')') ADVANCE(63);
      if (lookahead == '?') ADVANCE(712);
      if (lookahead == '`') ADVANCE(670);
      if (lookahead != 0) ADVANCE(660);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(540);
      if (lookahead == ' ') ADVANCE(662);
      if (lookahead == '"') ADVANCE(695);
      if (lookahead == '\'') ADVANCE(662);
      if (lookahead == ')') ADVANCE(94);
      if (lookahead == '?') ADVANCE(741);
      if (lookahead == '`') ADVANCE(672);
      if (lookahead != 0) ADVANCE(662);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(540);
      if (lookahead == ' ') ADVANCE(666);
      if (lookahead == '"') ADVANCE(666);
      if (lookahead == '\'') ADVANCE(666);
      if (lookahead == ')') ADVANCE(64);
      if (lookahead == '?') ADVANCE(713);
      if (lookahead == '`') ADVANCE(699);
      if (lookahead != 0) ADVANCE(666);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(540);
      if (lookahead == ' ') ADVANCE(670);
      if (lookahead == '"') ADVANCE(670);
      if (lookahead == '\'') ADVANCE(699);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == '?') ADVANCE(733);
      if (lookahead == '`') ADVANCE(670);
      if (lookahead != 0) ADVANCE(670);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(540);
      if (lookahead == ' ') ADVANCE(672);
      if (lookahead == '"') ADVANCE(699);
      if (lookahead == '\'') ADVANCE(672);
      if (lookahead == ')') ADVANCE(102);
      if (lookahead == '?') ADVANCE(753);
      if (lookahead == '`') ADVANCE(672);
      if (lookahead != 0) ADVANCE(672);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(540);
      if (lookahead == ' ') ADVANCE(695);
      if (lookahead == '"') ADVANCE(695);
      if (lookahead == '\'') ADVANCE(695);
      if (lookahead == ')') ADVANCE(69);
      if (lookahead == '?') ADVANCE(716);
      if (lookahead == '`') ADVANCE(699);
      if (lookahead != 0) ADVANCE(695);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(540);
      if (lookahead == ' ') ADVANCE(699);
      if (lookahead == '"') ADVANCE(699);
      if (lookahead == '\'') ADVANCE(699);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == '?') ADVANCE(735);
      if (lookahead == '`') ADVANCE(699);
      if (lookahead != 0) ADVANCE(699);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(543);
      if (lookahead == ' ') ADVANCE(548);
      if (lookahead == '"') ADVANCE(657);
      if (lookahead == '\'') ADVANCE(658);
      if (lookahead == ')') ADVANCE(812);
      if (lookahead == '?') ADVANCE(553);
      if (lookahead == '`') ADVANCE(706);
      if (lookahead != 0) ADVANCE(548);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(543);
      if (lookahead == ' ') ADVANCE(635);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '\'') ADVANCE(676);
      if (lookahead == ')') ADVANCE(780);
      if (lookahead == '?') ADVANCE(556);
      if (lookahead == '`') ADVANCE(678);
      if (lookahead != 0) ADVANCE(635);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(543);
      if (lookahead == ' ') ADVANCE(641);
      if (lookahead == '"') ADVANCE(676);
      if (lookahead == '\'') ADVANCE(641);
      if (lookahead == ')') ADVANCE(790);
      if (lookahead == '?') ADVANCE(558);
      if (lookahead == '`') ADVANCE(682);
      if (lookahead != 0) ADVANCE(641);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(543);
      if (lookahead == ' ') ADVANCE(657);
      if (lookahead == '"') ADVANCE(657);
      if (lookahead == '\'') ADVANCE(693);
      if (lookahead == ')') ADVANCE(782);
      if (lookahead == '?') ADVANCE(566);
      if (lookahead == '`') ADVANCE(678);
      if (lookahead != 0) ADVANCE(657);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(543);
      if (lookahead == ' ') ADVANCE(658);
      if (lookahead == '"') ADVANCE(693);
      if (lookahead == '\'') ADVANCE(658);
      if (lookahead == ')') ADVANCE(792);
      if (lookahead == '?') ADVANCE(567);
      if (lookahead == '`') ADVANCE(682);
      if (lookahead != 0) ADVANCE(658);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(543);
      if (lookahead == ' ') ADVANCE(676);
      if (lookahead == '"') ADVANCE(676);
      if (lookahead == '\'') ADVANCE(676);
      if (lookahead == ')') ADVANCE(783);
      if (lookahead == '?') ADVANCE(574);
      if (lookahead == '`') ADVANCE(702);
      if (lookahead != 0) ADVANCE(676);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(543);
      if (lookahead == ' ') ADVANCE(678);
      if (lookahead == '"') ADVANCE(678);
      if (lookahead == '\'') ADVANCE(702);
      if (lookahead == ')') ADVANCE(788);
      if (lookahead == '?') ADVANCE(603);
      if (lookahead == '`') ADVANCE(678);
      if (lookahead != 0) ADVANCE(678);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(543);
      if (lookahead == ' ') ADVANCE(682);
      if (lookahead == '"') ADVANCE(702);
      if (lookahead == '\'') ADVANCE(682);
      if (lookahead == ')') ADVANCE(794);
      if (lookahead == '?') ADVANCE(605);
      if (lookahead == '`') ADVANCE(682);
      if (lookahead != 0) ADVANCE(682);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(543);
      if (lookahead == ' ') ADVANCE(693);
      if (lookahead == '"') ADVANCE(693);
      if (lookahead == '\'') ADVANCE(693);
      if (lookahead == ')') ADVANCE(786);
      if (lookahead == '?') ADVANCE(582);
      if (lookahead == '`') ADVANCE(702);
      if (lookahead != 0) ADVANCE(693);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(543);
      if (lookahead == ' ') ADVANCE(702);
      if (lookahead == '"') ADVANCE(702);
      if (lookahead == '\'') ADVANCE(702);
      if (lookahead == ')') ADVANCE(789);
      if (lookahead == '?') ADVANCE(607);
      if (lookahead == '`') ADVANCE(702);
      if (lookahead != 0) ADVANCE(702);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(543);
      if (lookahead == ' ') ADVANCE(706);
      if (lookahead == '"') ADVANCE(678);
      if (lookahead == '\'') ADVANCE(682);
      if (lookahead == ')') ADVANCE(813);
      if (lookahead == '?') ADVANCE(599);
      if (lookahead == '`') ADVANCE(706);
      if (lookahead != 0) ADVANCE(706);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(539);
      if (lookahead == ' ') ADVANCE(595);
      if (lookahead == '"') ADVANCE(659);
      if (lookahead == '\'') ADVANCE(661);
      if (lookahead == '(') ADVANCE(548);
      if (lookahead == ')') ADVANCE(135);
      if (lookahead == ',') ADVANCE(595);
      if (lookahead == '?') ADVANCE(757);
      if (lookahead == '`') ADVANCE(626);
      if (lookahead != 0) ADVANCE(594);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(539);
      if (lookahead == ' ') ADVANCE(613);
      if (lookahead == '"') ADVANCE(612);
      if (lookahead == '\'') ADVANCE(665);
      if (lookahead == '(') ADVANCE(635);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == ',') ADVANCE(613);
      if (lookahead == '?') ADVANCE(710);
      if (lookahead == '`') ADVANCE(669);
      if (lookahead != 0) ADVANCE(612);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(539);
      if (lookahead == ' ') ADVANCE(619);
      if (lookahead == '"') ADVANCE(665);
      if (lookahead == '\'') ADVANCE(618);
      if (lookahead == '(') ADVANCE(641);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == ',') ADVANCE(619);
      if (lookahead == '?') ADVANCE(739);
      if (lookahead == '`') ADVANCE(671);
      if (lookahead != 0) ADVANCE(618);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(539);
      if (lookahead == ' ') ADVANCE(627);
      if (lookahead == '"') ADVANCE(669);
      if (lookahead == '\'') ADVANCE(671);
      if (lookahead == '(') ADVANCE(706);
      if (lookahead == ')') ADVANCE(138);
      if (lookahead == ',') ADVANCE(627);
      if (lookahead == '?') ADVANCE(758);
      if (lookahead == '`') ADVANCE(626);
      if (lookahead != 0) ADVANCE(626);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(539);
      if (lookahead == ' ') ADVANCE(660);
      if (lookahead == '"') ADVANCE(659);
      if (lookahead == '\'') ADVANCE(694);
      if (lookahead == '(') ADVANCE(657);
      if (lookahead == ')') ADVANCE(63);
      if (lookahead == ',') ADVANCE(660);
      if (lookahead == '?') ADVANCE(711);
      if (lookahead == '`') ADVANCE(669);
      if (lookahead != 0) ADVANCE(659);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(539);
      if (lookahead == ' ') ADVANCE(662);
      if (lookahead == '"') ADVANCE(694);
      if (lookahead == '\'') ADVANCE(661);
      if (lookahead == '(') ADVANCE(658);
      if (lookahead == ')') ADVANCE(94);
      if (lookahead == ',') ADVANCE(662);
      if (lookahead == '?') ADVANCE(740);
      if (lookahead == '`') ADVANCE(671);
      if (lookahead != 0) ADVANCE(661);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(539);
      if (lookahead == ' ') ADVANCE(666);
      if (lookahead == '"') ADVANCE(665);
      if (lookahead == '\'') ADVANCE(665);
      if (lookahead == '(') ADVANCE(676);
      if (lookahead == ')') ADVANCE(64);
      if (lookahead == ',') ADVANCE(666);
      if (lookahead == '?') ADVANCE(714);
      if (lookahead == '`') ADVANCE(698);
      if (lookahead != 0) ADVANCE(665);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(539);
      if (lookahead == ' ') ADVANCE(670);
      if (lookahead == '"') ADVANCE(669);
      if (lookahead == '\'') ADVANCE(698);
      if (lookahead == '(') ADVANCE(678);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == ',') ADVANCE(670);
      if (lookahead == '?') ADVANCE(732);
      if (lookahead == '`') ADVANCE(669);
      if (lookahead != 0) ADVANCE(669);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(539);
      if (lookahead == ' ') ADVANCE(672);
      if (lookahead == '"') ADVANCE(698);
      if (lookahead == '\'') ADVANCE(671);
      if (lookahead == '(') ADVANCE(682);
      if (lookahead == ')') ADVANCE(102);
      if (lookahead == ',') ADVANCE(672);
      if (lookahead == '?') ADVANCE(752);
      if (lookahead == '`') ADVANCE(671);
      if (lookahead != 0) ADVANCE(671);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(539);
      if (lookahead == ' ') ADVANCE(695);
      if (lookahead == '"') ADVANCE(694);
      if (lookahead == '\'') ADVANCE(694);
      if (lookahead == '(') ADVANCE(693);
      if (lookahead == ')') ADVANCE(69);
      if (lookahead == ',') ADVANCE(695);
      if (lookahead == '?') ADVANCE(715);
      if (lookahead == '`') ADVANCE(698);
      if (lookahead != 0) ADVANCE(694);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(539);
      if (lookahead == ' ') ADVANCE(699);
      if (lookahead == '"') ADVANCE(698);
      if (lookahead == '\'') ADVANCE(698);
      if (lookahead == '(') ADVANCE(702);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == ',') ADVANCE(699);
      if (lookahead == '?') ADVANCE(734);
      if (lookahead == '`') ADVANCE(698);
      if (lookahead != 0) ADVANCE(698);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(608);
      if (lookahead == ' ') ADVANCE(652);
      if (lookahead == '"') ADVANCE(651);
      if (lookahead == '\'') ADVANCE(687);
      if (lookahead == '(') ADVANCE(648);
      if (lookahead == ')') ADVANCE(62);
      if (lookahead == ',') ADVANCE(652);
      if (lookahead == '?') ADVANCE(611);
      if (lookahead == '`') ADVANCE(689);
      if (lookahead != 0) ADVANCE(651);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(608);
      if (lookahead == ' ') ADVANCE(654);
      if (lookahead == '"') ADVANCE(687);
      if (lookahead == '\'') ADVANCE(653);
      if (lookahead == '(') ADVANCE(649);
      if (lookahead == ')') ADVANCE(93);
      if (lookahead == ',') ADVANCE(654);
      if (lookahead == '?') ADVANCE(621);
      if (lookahead == '`') ADVANCE(691);
      if (lookahead != 0) ADVANCE(653);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(608);
      if (lookahead == ' ') ADVANCE(656);
      if (lookahead == '"') ADVANCE(689);
      if (lookahead == '\'') ADVANCE(691);
      if (lookahead == '(') ADVANCE(650);
      if (lookahead == ')') ADVANCE(134);
      if (lookahead == ',') ADVANCE(656);
      if (lookahead == '?') ADVANCE(628);
      if (lookahead == '`') ADVANCE(655);
      if (lookahead != 0) ADVANCE(655);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(608);
      if (lookahead == ' ') ADVANCE(688);
      if (lookahead == '"') ADVANCE(687);
      if (lookahead == '\'') ADVANCE(687);
      if (lookahead == '(') ADVANCE(684);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == ',') ADVANCE(688);
      if (lookahead == '?') ADVANCE(663);
      if (lookahead == '`') ADVANCE(704);
      if (lookahead != 0) ADVANCE(687);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(608);
      if (lookahead == ' ') ADVANCE(690);
      if (lookahead == '"') ADVANCE(689);
      if (lookahead == '\'') ADVANCE(704);
      if (lookahead == '(') ADVANCE(685);
      if (lookahead == ')') ADVANCE(67);
      if (lookahead == ',') ADVANCE(690);
      if (lookahead == '?') ADVANCE(667);
      if (lookahead == '`') ADVANCE(689);
      if (lookahead != 0) ADVANCE(689);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(608);
      if (lookahead == ' ') ADVANCE(692);
      if (lookahead == '"') ADVANCE(704);
      if (lookahead == '\'') ADVANCE(691);
      if (lookahead == '(') ADVANCE(686);
      if (lookahead == ')') ADVANCE(96);
      if (lookahead == ',') ADVANCE(692);
      if (lookahead == '?') ADVANCE(673);
      if (lookahead == '`') ADVANCE(691);
      if (lookahead != 0) ADVANCE(691);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(608);
      if (lookahead == ' ') ADVANCE(705);
      if (lookahead == '"') ADVANCE(704);
      if (lookahead == '\'') ADVANCE(704);
      if (lookahead == '(') ADVANCE(703);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == ',') ADVANCE(705);
      if (lookahead == '?') ADVANCE(696);
      if (lookahead == '`') ADVANCE(704);
      if (lookahead != 0) ADVANCE(704);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(546);
      if (lookahead == ' ') ADVANCE(551);
      if (lookahead == '"') ADVANCE(551);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == '?') ADVANCE(560);
      if (lookahead == ']') ADVANCE(613);
      if (lookahead == '`') ADVANCE(630);
      if (lookahead == '(' ||
          lookahead == '[') ADVANCE(613);
      if (lookahead != 0) ADVANCE(551);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(546);
      if (lookahead == ' ') ADVANCE(596);
      if (lookahead == '"') ADVANCE(622);
      if (lookahead == '\'') ADVANCE(596);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == '?') ADVANCE(562);
      if (lookahead == ']') ADVANCE(619);
      if (lookahead == '`') ADVANCE(637);
      if (lookahead == '(' ||
          lookahead == '[') ADVANCE(619);
      if (lookahead != 0) ADVANCE(596);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(546);
      if (lookahead == ' ') ADVANCE(614);
      if (lookahead == '"') ADVANCE(630);
      if (lookahead == '\'') ADVANCE(637);
      if (lookahead == ')') ADVANCE(138);
      if (lookahead == '?') ADVANCE(565);
      if (lookahead == ']') ADVANCE(627);
      if (lookahead == '`') ADVANCE(614);
      if (lookahead == '(' ||
          lookahead == '[') ADVANCE(627);
      if (lookahead != 0) ADVANCE(614);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(546);
      if (lookahead == ' ') ADVANCE(622);
      if (lookahead == '"') ADVANCE(622);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == ')') ADVANCE(64);
      if (lookahead == '?') ADVANCE(576);
      if (lookahead == ']') ADVANCE(666);
      if (lookahead == '`') ADVANCE(644);
      if (lookahead == '(' ||
          lookahead == '[') ADVANCE(666);
      if (lookahead != 0) ADVANCE(622);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(546);
      if (lookahead == ' ') ADVANCE(630);
      if (lookahead == '"') ADVANCE(630);
      if (lookahead == '\'') ADVANCE(644);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == '?') ADVANCE(578);
      if (lookahead == ']') ADVANCE(670);
      if (lookahead == '`') ADVANCE(630);
      if (lookahead == '(' ||
          lookahead == '[') ADVANCE(670);
      if (lookahead != 0) ADVANCE(630);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(546);
      if (lookahead == ' ') ADVANCE(637);
      if (lookahead == '"') ADVANCE(644);
      if (lookahead == '\'') ADVANCE(637);
      if (lookahead == ')') ADVANCE(102);
      if (lookahead == '?') ADVANCE(580);
      if (lookahead == ']') ADVANCE(672);
      if (lookahead == '`') ADVANCE(637);
      if (lookahead == '(' ||
          lookahead == '[') ADVANCE(672);
      if (lookahead != 0) ADVANCE(637);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(546);
      if (lookahead == ' ') ADVANCE(644);
      if (lookahead == '"') ADVANCE(644);
      if (lookahead == '\'') ADVANCE(644);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == '?') ADVANCE(589);
      if (lookahead == ']') ADVANCE(699);
      if (lookahead == '`') ADVANCE(644);
      if (lookahead == '(' ||
          lookahead == '[') ADVANCE(699);
      if (lookahead != 0) ADVANCE(644);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(547);
      if (lookahead == ' ') ADVANCE(551);
      if (lookahead == '"') ADVANCE(552);
      if (lookahead == '\'') ADVANCE(623);
      if (lookahead == '(') ADVANCE(635);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == ',') ADVANCE(551);
      if (lookahead == '?') ADVANCE(561);
      if (lookahead == '[') ADVANCE(612);
      if (lookahead == ']') ADVANCE(612);
      if (lookahead == '`') ADVANCE(631);
      if (lookahead != 0) ADVANCE(552);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(547);
      if (lookahead == ' ') ADVANCE(596);
      if (lookahead == '"') ADVANCE(623);
      if (lookahead == '\'') ADVANCE(597);
      if (lookahead == '(') ADVANCE(641);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == ',') ADVANCE(596);
      if (lookahead == '?') ADVANCE(563);
      if (lookahead == '[') ADVANCE(618);
      if (lookahead == ']') ADVANCE(618);
      if (lookahead == '`') ADVANCE(638);
      if (lookahead != 0) ADVANCE(597);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(547);
      if (lookahead == ' ') ADVANCE(614);
      if (lookahead == '"') ADVANCE(631);
      if (lookahead == '\'') ADVANCE(638);
      if (lookahead == '(') ADVANCE(706);
      if (lookahead == ')') ADVANCE(138);
      if (lookahead == ',') ADVANCE(614);
      if (lookahead == '?') ADVANCE(564);
      if (lookahead == '[') ADVANCE(626);
      if (lookahead == ']') ADVANCE(626);
      if (lookahead == '`') ADVANCE(615);
      if (lookahead != 0) ADVANCE(615);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(547);
      if (lookahead == ' ') ADVANCE(622);
      if (lookahead == '"') ADVANCE(623);
      if (lookahead == '\'') ADVANCE(623);
      if (lookahead == '(') ADVANCE(676);
      if (lookahead == ')') ADVANCE(64);
      if (lookahead == ',') ADVANCE(622);
      if (lookahead == '?') ADVANCE(577);
      if (lookahead == '[') ADVANCE(665);
      if (lookahead == ']') ADVANCE(665);
      if (lookahead == '`') ADVANCE(645);
      if (lookahead != 0) ADVANCE(623);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(547);
      if (lookahead == ' ') ADVANCE(630);
      if (lookahead == '"') ADVANCE(631);
      if (lookahead == '\'') ADVANCE(645);
      if (lookahead == '(') ADVANCE(678);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == ',') ADVANCE(630);
      if (lookahead == '?') ADVANCE(579);
      if (lookahead == '[') ADVANCE(669);
      if (lookahead == ']') ADVANCE(669);
      if (lookahead == '`') ADVANCE(631);
      if (lookahead != 0) ADVANCE(631);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(547);
      if (lookahead == ' ') ADVANCE(637);
      if (lookahead == '"') ADVANCE(645);
      if (lookahead == '\'') ADVANCE(638);
      if (lookahead == '(') ADVANCE(682);
      if (lookahead == ')') ADVANCE(102);
      if (lookahead == ',') ADVANCE(637);
      if (lookahead == '?') ADVANCE(581);
      if (lookahead == '[') ADVANCE(671);
      if (lookahead == ']') ADVANCE(671);
      if (lookahead == '`') ADVANCE(638);
      if (lookahead != 0) ADVANCE(638);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(547);
      if (lookahead == ' ') ADVANCE(644);
      if (lookahead == '"') ADVANCE(645);
      if (lookahead == '\'') ADVANCE(645);
      if (lookahead == '(') ADVANCE(702);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == ',') ADVANCE(644);
      if (lookahead == '?') ADVANCE(590);
      if (lookahead == '[') ADVANCE(698);
      if (lookahead == ']') ADVANCE(698);
      if (lookahead == '`') ADVANCE(645);
      if (lookahead != 0) ADVANCE(645);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(549);
      if (lookahead == ' ') ADVANCE(554);
      if (lookahead == '"') ADVANCE(554);
      if (lookahead == '\'') ADVANCE(624);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == ',') ADVANCE(554);
      if (lookahead == '?') ADVANCE(568);
      if (lookahead == '`') ADVANCE(632);
      if (lookahead == '}') ADVANCE(554);
      if (lookahead == '(' ||
          lookahead == '[' ||
          lookahead == ']') ADVANCE(613);
      if (lookahead != 0) ADVANCE(554);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(549);
      if (lookahead == ' ') ADVANCE(600);
      if (lookahead == '"') ADVANCE(624);
      if (lookahead == '\'') ADVANCE(600);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == ',') ADVANCE(600);
      if (lookahead == '?') ADVANCE(570);
      if (lookahead == '`') ADVANCE(639);
      if (lookahead == '}') ADVANCE(600);
      if (lookahead == '(' ||
          lookahead == '[' ||
          lookahead == ']') ADVANCE(619);
      if (lookahead != 0) ADVANCE(600);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(549);
      if (lookahead == ' ') ADVANCE(616);
      if (lookahead == '"') ADVANCE(632);
      if (lookahead == '\'') ADVANCE(639);
      if (lookahead == ')') ADVANCE(138);
      if (lookahead == ',') ADVANCE(616);
      if (lookahead == '?') ADVANCE(573);
      if (lookahead == '`') ADVANCE(616);
      if (lookahead == '}') ADVANCE(616);
      if (lookahead == '(' ||
          lookahead == '[' ||
          lookahead == ']') ADVANCE(627);
      if (lookahead != 0) ADVANCE(616);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(549);
      if (lookahead == ' ') ADVANCE(624);
      if (lookahead == '"') ADVANCE(624);
      if (lookahead == '\'') ADVANCE(624);
      if (lookahead == ')') ADVANCE(64);
      if (lookahead == ',') ADVANCE(624);
      if (lookahead == '?') ADVANCE(583);
      if (lookahead == '`') ADVANCE(646);
      if (lookahead == '}') ADVANCE(624);
      if (lookahead == '(' ||
          lookahead == '[' ||
          lookahead == ']') ADVANCE(666);
      if (lookahead != 0) ADVANCE(624);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(549);
      if (lookahead == ' ') ADVANCE(632);
      if (lookahead == '"') ADVANCE(632);
      if (lookahead == '\'') ADVANCE(646);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == ',') ADVANCE(632);
      if (lookahead == '?') ADVANCE(585);
      if (lookahead == '`') ADVANCE(632);
      if (lookahead == '}') ADVANCE(632);
      if (lookahead == '(' ||
          lookahead == '[' ||
          lookahead == ']') ADVANCE(670);
      if (lookahead != 0) ADVANCE(632);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(549);
      if (lookahead == ' ') ADVANCE(639);
      if (lookahead == '"') ADVANCE(646);
      if (lookahead == '\'') ADVANCE(639);
      if (lookahead == ')') ADVANCE(102);
      if (lookahead == ',') ADVANCE(639);
      if (lookahead == '?') ADVANCE(587);
      if (lookahead == '`') ADVANCE(639);
      if (lookahead == '}') ADVANCE(639);
      if (lookahead == '(' ||
          lookahead == '[' ||
          lookahead == ']') ADVANCE(672);
      if (lookahead != 0) ADVANCE(639);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(549);
      if (lookahead == ' ') ADVANCE(646);
      if (lookahead == '"') ADVANCE(646);
      if (lookahead == '\'') ADVANCE(646);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == ',') ADVANCE(646);
      if (lookahead == '?') ADVANCE(591);
      if (lookahead == '`') ADVANCE(646);
      if (lookahead == '}') ADVANCE(646);
      if (lookahead == '(' ||
          lookahead == '[' ||
          lookahead == ']') ADVANCE(699);
      if (lookahead != 0) ADVANCE(646);
      END_STATE();
    case 437:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(550);
      if (lookahead == ' ') ADVANCE(554);
      if (lookahead == '"') ADVANCE(555);
      if (lookahead == '\'') ADVANCE(625);
      if (lookahead == '(') ADVANCE(635);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == ',') ADVANCE(554);
      if (lookahead == '?') ADVANCE(569);
      if (lookahead == '`') ADVANCE(633);
      if (lookahead == '}') ADVANCE(555);
      if (lookahead == '[' ||
          lookahead == ']') ADVANCE(612);
      if (lookahead != 0) ADVANCE(555);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(550);
      if (lookahead == ' ') ADVANCE(600);
      if (lookahead == '"') ADVANCE(625);
      if (lookahead == '\'') ADVANCE(601);
      if (lookahead == '(') ADVANCE(641);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == ',') ADVANCE(600);
      if (lookahead == '?') ADVANCE(571);
      if (lookahead == '`') ADVANCE(640);
      if (lookahead == '}') ADVANCE(601);
      if (lookahead == '[' ||
          lookahead == ']') ADVANCE(618);
      if (lookahead != 0) ADVANCE(601);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(550);
      if (lookahead == ' ') ADVANCE(616);
      if (lookahead == '"') ADVANCE(633);
      if (lookahead == '\'') ADVANCE(640);
      if (lookahead == '(') ADVANCE(706);
      if (lookahead == ')') ADVANCE(138);
      if (lookahead == ',') ADVANCE(616);
      if (lookahead == '?') ADVANCE(572);
      if (lookahead == '`') ADVANCE(617);
      if (lookahead == '}') ADVANCE(617);
      if (lookahead == '[' ||
          lookahead == ']') ADVANCE(626);
      if (lookahead != 0) ADVANCE(617);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(550);
      if (lookahead == ' ') ADVANCE(624);
      if (lookahead == '"') ADVANCE(625);
      if (lookahead == '\'') ADVANCE(625);
      if (lookahead == '(') ADVANCE(676);
      if (lookahead == ')') ADVANCE(64);
      if (lookahead == ',') ADVANCE(624);
      if (lookahead == '?') ADVANCE(584);
      if (lookahead == '`') ADVANCE(647);
      if (lookahead == '}') ADVANCE(625);
      if (lookahead == '[' ||
          lookahead == ']') ADVANCE(665);
      if (lookahead != 0) ADVANCE(625);
      END_STATE();
    case 441:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(550);
      if (lookahead == ' ') ADVANCE(632);
      if (lookahead == '"') ADVANCE(633);
      if (lookahead == '\'') ADVANCE(647);
      if (lookahead == '(') ADVANCE(678);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == ',') ADVANCE(632);
      if (lookahead == '?') ADVANCE(586);
      if (lookahead == '`') ADVANCE(633);
      if (lookahead == '}') ADVANCE(633);
      if (lookahead == '[' ||
          lookahead == ']') ADVANCE(669);
      if (lookahead != 0) ADVANCE(633);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(550);
      if (lookahead == ' ') ADVANCE(639);
      if (lookahead == '"') ADVANCE(647);
      if (lookahead == '\'') ADVANCE(640);
      if (lookahead == '(') ADVANCE(682);
      if (lookahead == ')') ADVANCE(102);
      if (lookahead == ',') ADVANCE(639);
      if (lookahead == '?') ADVANCE(588);
      if (lookahead == '`') ADVANCE(640);
      if (lookahead == '}') ADVANCE(640);
      if (lookahead == '[' ||
          lookahead == ']') ADVANCE(671);
      if (lookahead != 0) ADVANCE(640);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(550);
      if (lookahead == ' ') ADVANCE(646);
      if (lookahead == '"') ADVANCE(647);
      if (lookahead == '\'') ADVANCE(647);
      if (lookahead == '(') ADVANCE(702);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == ',') ADVANCE(646);
      if (lookahead == '?') ADVANCE(592);
      if (lookahead == '`') ADVANCE(647);
      if (lookahead == '}') ADVANCE(647);
      if (lookahead == '[' ||
          lookahead == ']') ADVANCE(698);
      if (lookahead != 0) ADVANCE(647);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(772);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(135);
      if (lookahead != 0) ADVANCE(767);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(772);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(61);
      if (lookahead != 0) ADVANCE(709);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(772);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(92);
      if (lookahead != 0) ADVANCE(738);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(772);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(63);
      if (lookahead != 0) ADVANCE(712);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(772);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(94);
      if (lookahead != 0) ADVANCE(741);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(772);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(64);
      if (lookahead != 0) ADVANCE(713);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(772);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(69);
      if (lookahead != 0) ADVANCE(716);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(772);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(138);
      if (lookahead != 0) ADVANCE(770);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(772);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(81);
      if (lookahead != 0) ADVANCE(733);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(772);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(102);
      if (lookahead != 0) ADVANCE(753);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(772);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(82);
      if (lookahead != 0) ADVANCE(735);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(538);
      if (lookahead == ' ') ADVANCE(115);
      if (lookahead == ')') ADVANCE(812);
      if (lookahead != 0) ADVANCE(553);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(538);
      if (lookahead == ' ') ADVANCE(65);
      if (lookahead == ')') ADVANCE(780);
      if (lookahead != 0) ADVANCE(556);
      END_STATE();
    case 457:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(538);
      if (lookahead == ' ') ADVANCE(95);
      if (lookahead == ')') ADVANCE(790);
      if (lookahead != 0) ADVANCE(558);
      END_STATE();
    case 458:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(538);
      if (lookahead == ' ') ADVANCE(70);
      if (lookahead == ')') ADVANCE(782);
      if (lookahead != 0) ADVANCE(566);
      END_STATE();
    case 459:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(538);
      if (lookahead == ' ') ADVANCE(98);
      if (lookahead == ')') ADVANCE(792);
      if (lookahead != 0) ADVANCE(567);
      END_STATE();
    case 460:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(538);
      if (lookahead == ' ') ADVANCE(72);
      if (lookahead == ')') ADVANCE(783);
      if (lookahead != 0) ADVANCE(574);
      END_STATE();
    case 461:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(538);
      if (lookahead == ' ') ADVANCE(76);
      if (lookahead == ')') ADVANCE(786);
      if (lookahead != 0) ADVANCE(582);
      END_STATE();
    case 462:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(538);
      if (lookahead == ' ') ADVANCE(117);
      if (lookahead == ')') ADVANCE(813);
      if (lookahead != 0) ADVANCE(599);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(538);
      if (lookahead == ' ') ADVANCE(83);
      if (lookahead == ')') ADVANCE(788);
      if (lookahead != 0) ADVANCE(603);
      END_STATE();
    case 464:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(538);
      if (lookahead == ' ') ADVANCE(103);
      if (lookahead == ')') ADVANCE(794);
      if (lookahead != 0) ADVANCE(605);
      END_STATE();
    case 465:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(538);
      if (lookahead == ' ') ADVANCE(84);
      if (lookahead == ')') ADVANCE(789);
      if (lookahead != 0) ADVANCE(607);
      END_STATE();
    case 466:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(756);
      if (lookahead == '(') ADVANCE(553);
      if (lookahead == ',') ADVANCE(767);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(135);
      if (lookahead != 0) ADVANCE(757);
      END_STATE();
    case 467:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(756);
      if (lookahead == '(') ADVANCE(556);
      if (lookahead == ',') ADVANCE(709);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(61);
      if (lookahead != 0) ADVANCE(710);
      END_STATE();
    case 468:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(756);
      if (lookahead == '(') ADVANCE(558);
      if (lookahead == ',') ADVANCE(738);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(92);
      if (lookahead != 0) ADVANCE(739);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(756);
      if (lookahead == '(') ADVANCE(566);
      if (lookahead == ',') ADVANCE(712);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(63);
      if (lookahead != 0) ADVANCE(711);
      END_STATE();
    case 470:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(756);
      if (lookahead == '(') ADVANCE(567);
      if (lookahead == ',') ADVANCE(741);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(94);
      if (lookahead != 0) ADVANCE(740);
      END_STATE();
    case 471:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(756);
      if (lookahead == '(') ADVANCE(574);
      if (lookahead == ',') ADVANCE(713);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(64);
      if (lookahead != 0) ADVANCE(714);
      END_STATE();
    case 472:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(756);
      if (lookahead == '(') ADVANCE(582);
      if (lookahead == ',') ADVANCE(716);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(69);
      if (lookahead != 0) ADVANCE(715);
      END_STATE();
    case 473:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(756);
      if (lookahead == '(') ADVANCE(599);
      if (lookahead == ',') ADVANCE(770);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(138);
      if (lookahead != 0) ADVANCE(758);
      END_STATE();
    case 474:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(756);
      if (lookahead == '(') ADVANCE(603);
      if (lookahead == ',') ADVANCE(733);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(81);
      if (lookahead != 0) ADVANCE(732);
      END_STATE();
    case 475:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(756);
      if (lookahead == '(') ADVANCE(605);
      if (lookahead == ',') ADVANCE(753);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(102);
      if (lookahead != 0) ADVANCE(752);
      END_STATE();
    case 476:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(756);
      if (lookahead == '(') ADVANCE(607);
      if (lookahead == ',') ADVANCE(735);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(82);
      if (lookahead != 0) ADVANCE(734);
      END_STATE();
    case 477:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(534);
      if (lookahead == ' ') ADVANCE(68);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == ']') ADVANCE(709);
      if (lookahead == '(' ||
          lookahead == '[') ADVANCE(709);
      if (lookahead != 0) ADVANCE(560);
      END_STATE();
    case 478:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(534);
      if (lookahead == ' ') ADVANCE(97);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == ']') ADVANCE(738);
      if (lookahead == '(' ||
          lookahead == '[') ADVANCE(738);
      if (lookahead != 0) ADVANCE(562);
      END_STATE();
    case 479:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(534);
      if (lookahead == ' ') ADVANCE(137);
      if (lookahead == ')') ADVANCE(138);
      if (lookahead == ']') ADVANCE(770);
      if (lookahead == '(' ||
          lookahead == '[') ADVANCE(770);
      if (lookahead != 0) ADVANCE(565);
      END_STATE();
    case 480:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(534);
      if (lookahead == ' ') ADVANCE(74);
      if (lookahead == ')') ADVANCE(64);
      if (lookahead == ']') ADVANCE(713);
      if (lookahead == '(' ||
          lookahead == '[') ADVANCE(713);
      if (lookahead != 0) ADVANCE(576);
      END_STATE();
    case 481:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(534);
      if (lookahead == ' ') ADVANCE(75);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == ']') ADVANCE(733);
      if (lookahead == '(' ||
          lookahead == '[') ADVANCE(733);
      if (lookahead != 0) ADVANCE(578);
      END_STATE();
    case 482:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(534);
      if (lookahead == ' ') ADVANCE(100);
      if (lookahead == ')') ADVANCE(102);
      if (lookahead == ']') ADVANCE(753);
      if (lookahead == '(' ||
          lookahead == '[') ADVANCE(753);
      if (lookahead != 0) ADVANCE(580);
      END_STATE();
    case 483:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(534);
      if (lookahead == ' ') ADVANCE(79);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == ']') ADVANCE(735);
      if (lookahead == '(' ||
          lookahead == '[') ADVANCE(735);
      if (lookahead != 0) ADVANCE(589);
      END_STATE();
    case 484:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(533);
      if (lookahead == ' ') ADVANCE(68);
      if (lookahead == '(') ADVANCE(556);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == ',') ADVANCE(560);
      if (lookahead == '[') ADVANCE(710);
      if (lookahead == ']') ADVANCE(710);
      if (lookahead != 0) ADVANCE(561);
      END_STATE();
    case 485:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(533);
      if (lookahead == ' ') ADVANCE(97);
      if (lookahead == '(') ADVANCE(558);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == ',') ADVANCE(562);
      if (lookahead == '[') ADVANCE(739);
      if (lookahead == ']') ADVANCE(739);
      if (lookahead != 0) ADVANCE(563);
      END_STATE();
    case 486:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(533);
      if (lookahead == ' ') ADVANCE(137);
      if (lookahead == '(') ADVANCE(599);
      if (lookahead == ')') ADVANCE(138);
      if (lookahead == ',') ADVANCE(565);
      if (lookahead == '[') ADVANCE(758);
      if (lookahead == ']') ADVANCE(758);
      if (lookahead != 0) ADVANCE(564);
      END_STATE();
    case 487:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(533);
      if (lookahead == ' ') ADVANCE(74);
      if (lookahead == '(') ADVANCE(574);
      if (lookahead == ')') ADVANCE(64);
      if (lookahead == ',') ADVANCE(576);
      if (lookahead == '[') ADVANCE(714);
      if (lookahead == ']') ADVANCE(714);
      if (lookahead != 0) ADVANCE(577);
      END_STATE();
    case 488:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(533);
      if (lookahead == ' ') ADVANCE(75);
      if (lookahead == '(') ADVANCE(603);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == ',') ADVANCE(578);
      if (lookahead == '[') ADVANCE(732);
      if (lookahead == ']') ADVANCE(732);
      if (lookahead != 0) ADVANCE(579);
      END_STATE();
    case 489:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(533);
      if (lookahead == ' ') ADVANCE(100);
      if (lookahead == '(') ADVANCE(605);
      if (lookahead == ')') ADVANCE(102);
      if (lookahead == ',') ADVANCE(580);
      if (lookahead == '[') ADVANCE(752);
      if (lookahead == ']') ADVANCE(752);
      if (lookahead != 0) ADVANCE(581);
      END_STATE();
    case 490:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(533);
      if (lookahead == ' ') ADVANCE(79);
      if (lookahead == '(') ADVANCE(607);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == ',') ADVANCE(589);
      if (lookahead == '[') ADVANCE(734);
      if (lookahead == ']') ADVANCE(734);
      if (lookahead != 0) ADVANCE(590);
      END_STATE();
    case 491:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(536);
      if (lookahead == ' ') ADVANCE(71);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == ',') ADVANCE(568);
      if (lookahead == '}') ADVANCE(568);
      if (lookahead == '(' ||
          lookahead == '[' ||
          lookahead == ']') ADVANCE(709);
      if (lookahead != 0) ADVANCE(568);
      END_STATE();
    case 492:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(536);
      if (lookahead == ' ') ADVANCE(99);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == ',') ADVANCE(570);
      if (lookahead == '}') ADVANCE(570);
      if (lookahead == '(' ||
          lookahead == '[' ||
          lookahead == ']') ADVANCE(738);
      if (lookahead != 0) ADVANCE(570);
      END_STATE();
    case 493:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(536);
      if (lookahead == ' ') ADVANCE(121);
      if (lookahead == ')') ADVANCE(138);
      if (lookahead == ',') ADVANCE(573);
      if (lookahead == '}') ADVANCE(573);
      if (lookahead == '(' ||
          lookahead == '[' ||
          lookahead == ']') ADVANCE(770);
      if (lookahead != 0) ADVANCE(573);
      END_STATE();
    case 494:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(536);
      if (lookahead == ' ') ADVANCE(77);
      if (lookahead == ')') ADVANCE(64);
      if (lookahead == ',') ADVANCE(583);
      if (lookahead == '}') ADVANCE(583);
      if (lookahead == '(' ||
          lookahead == '[' ||
          lookahead == ']') ADVANCE(713);
      if (lookahead != 0) ADVANCE(583);
      END_STATE();
    case 495:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(536);
      if (lookahead == ' ') ADVANCE(78);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == ',') ADVANCE(585);
      if (lookahead == '}') ADVANCE(585);
      if (lookahead == '(' ||
          lookahead == '[' ||
          lookahead == ']') ADVANCE(733);
      if (lookahead != 0) ADVANCE(585);
      END_STATE();
    case 496:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(536);
      if (lookahead == ' ') ADVANCE(101);
      if (lookahead == ')') ADVANCE(102);
      if (lookahead == ',') ADVANCE(587);
      if (lookahead == '}') ADVANCE(587);
      if (lookahead == '(' ||
          lookahead == '[' ||
          lookahead == ']') ADVANCE(753);
      if (lookahead != 0) ADVANCE(587);
      END_STATE();
    case 497:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(536);
      if (lookahead == ' ') ADVANCE(80);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == ',') ADVANCE(591);
      if (lookahead == '}') ADVANCE(591);
      if (lookahead == '(' ||
          lookahead == '[' ||
          lookahead == ']') ADVANCE(735);
      if (lookahead != 0) ADVANCE(591);
      END_STATE();
    case 498:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(535);
      if (lookahead == ' ') ADVANCE(71);
      if (lookahead == '(') ADVANCE(556);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == ',') ADVANCE(568);
      if (lookahead == '}') ADVANCE(569);
      if (lookahead == '[' ||
          lookahead == ']') ADVANCE(710);
      if (lookahead != 0) ADVANCE(569);
      END_STATE();
    case 499:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(535);
      if (lookahead == ' ') ADVANCE(99);
      if (lookahead == '(') ADVANCE(558);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == ',') ADVANCE(570);
      if (lookahead == '}') ADVANCE(571);
      if (lookahead == '[' ||
          lookahead == ']') ADVANCE(739);
      if (lookahead != 0) ADVANCE(571);
      END_STATE();
    case 500:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(535);
      if (lookahead == ' ') ADVANCE(121);
      if (lookahead == '(') ADVANCE(599);
      if (lookahead == ')') ADVANCE(138);
      if (lookahead == ',') ADVANCE(573);
      if (lookahead == '}') ADVANCE(572);
      if (lookahead == '[' ||
          lookahead == ']') ADVANCE(758);
      if (lookahead != 0) ADVANCE(572);
      END_STATE();
    case 501:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(535);
      if (lookahead == ' ') ADVANCE(77);
      if (lookahead == '(') ADVANCE(574);
      if (lookahead == ')') ADVANCE(64);
      if (lookahead == ',') ADVANCE(583);
      if (lookahead == '}') ADVANCE(584);
      if (lookahead == '[' ||
          lookahead == ']') ADVANCE(714);
      if (lookahead != 0) ADVANCE(584);
      END_STATE();
    case 502:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(535);
      if (lookahead == ' ') ADVANCE(78);
      if (lookahead == '(') ADVANCE(603);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == ',') ADVANCE(585);
      if (lookahead == '}') ADVANCE(586);
      if (lookahead == '[' ||
          lookahead == ']') ADVANCE(732);
      if (lookahead != 0) ADVANCE(586);
      END_STATE();
    case 503:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(535);
      if (lookahead == ' ') ADVANCE(101);
      if (lookahead == '(') ADVANCE(605);
      if (lookahead == ')') ADVANCE(102);
      if (lookahead == ',') ADVANCE(587);
      if (lookahead == '}') ADVANCE(588);
      if (lookahead == '[' ||
          lookahead == ']') ADVANCE(752);
      if (lookahead != 0) ADVANCE(588);
      END_STATE();
    case 504:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(535);
      if (lookahead == ' ') ADVANCE(80);
      if (lookahead == '(') ADVANCE(607);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == ',') ADVANCE(591);
      if (lookahead == '}') ADVANCE(592);
      if (lookahead == '[' ||
          lookahead == ']') ADVANCE(734);
      if (lookahead != 0) ADVANCE(592);
      END_STATE();
    case 505:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(537);
      if (lookahead == ' ') ADVANCE(65);
      if (lookahead == '(') ADVANCE(556);
      if (lookahead == ')') ADVANCE(780);
      if (lookahead == ',') ADVANCE(556);
      if (lookahead != 0) ADVANCE(557);
      END_STATE();
    case 506:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(537);
      if (lookahead == ' ') ADVANCE(95);
      if (lookahead == '(') ADVANCE(558);
      if (lookahead == ')') ADVANCE(790);
      if (lookahead == ',') ADVANCE(558);
      if (lookahead != 0) ADVANCE(559);
      END_STATE();
    case 507:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(537);
      if (lookahead == ' ') ADVANCE(72);
      if (lookahead == '(') ADVANCE(574);
      if (lookahead == ')') ADVANCE(783);
      if (lookahead == ',') ADVANCE(574);
      if (lookahead != 0) ADVANCE(575);
      END_STATE();
    case 508:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(537);
      if (lookahead == ' ') ADVANCE(117);
      if (lookahead == '(') ADVANCE(599);
      if (lookahead == ')') ADVANCE(813);
      if (lookahead == ',') ADVANCE(599);
      if (lookahead != 0) ADVANCE(598);
      END_STATE();
    case 509:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(537);
      if (lookahead == ' ') ADVANCE(83);
      if (lookahead == '(') ADVANCE(603);
      if (lookahead == ')') ADVANCE(788);
      if (lookahead == ',') ADVANCE(603);
      if (lookahead != 0) ADVANCE(602);
      END_STATE();
    case 510:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(537);
      if (lookahead == ' ') ADVANCE(103);
      if (lookahead == '(') ADVANCE(605);
      if (lookahead == ')') ADVANCE(794);
      if (lookahead == ',') ADVANCE(605);
      if (lookahead != 0) ADVANCE(604);
      END_STATE();
    case 511:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(537);
      if (lookahead == ' ') ADVANCE(84);
      if (lookahead == '(') ADVANCE(607);
      if (lookahead == ')') ADVANCE(789);
      if (lookahead == ',') ADVANCE(607);
      if (lookahead != 0) ADVANCE(606);
      END_STATE();
    case 512:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(593);
      if (lookahead == ' ') ADVANCE(648);
      if (lookahead == '"') ADVANCE(648);
      if (lookahead == '\'') ADVANCE(684);
      if (lookahead == ')') ADVANCE(781);
      if (lookahead == '?') ADVANCE(634);
      if (lookahead == '`') ADVANCE(685);
      if (lookahead != 0) ADVANCE(648);
      END_STATE();
    case 513:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(593);
      if (lookahead == ' ') ADVANCE(649);
      if (lookahead == '"') ADVANCE(684);
      if (lookahead == '\'') ADVANCE(649);
      if (lookahead == ')') ADVANCE(791);
      if (lookahead == '?') ADVANCE(643);
      if (lookahead == '`') ADVANCE(686);
      if (lookahead != 0) ADVANCE(649);
      END_STATE();
    case 514:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(593);
      if (lookahead == ' ') ADVANCE(650);
      if (lookahead == '"') ADVANCE(685);
      if (lookahead == '\'') ADVANCE(686);
      if (lookahead == ')') ADVANCE(811);
      if (lookahead == '?') ADVANCE(708);
      if (lookahead == '`') ADVANCE(650);
      if (lookahead != 0) ADVANCE(650);
      END_STATE();
    case 515:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(593);
      if (lookahead == ' ') ADVANCE(684);
      if (lookahead == '"') ADVANCE(684);
      if (lookahead == '\'') ADVANCE(684);
      if (lookahead == ')') ADVANCE(784);
      if (lookahead == '?') ADVANCE(675);
      if (lookahead == '`') ADVANCE(703);
      if (lookahead != 0) ADVANCE(684);
      END_STATE();
    case 516:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(593);
      if (lookahead == ' ') ADVANCE(685);
      if (lookahead == '"') ADVANCE(685);
      if (lookahead == '\'') ADVANCE(703);
      if (lookahead == ')') ADVANCE(785);
      if (lookahead == '?') ADVANCE(680);
      if (lookahead == '`') ADVANCE(685);
      if (lookahead != 0) ADVANCE(685);
      END_STATE();
    case 517:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(593);
      if (lookahead == ' ') ADVANCE(686);
      if (lookahead == '"') ADVANCE(703);
      if (lookahead == '\'') ADVANCE(686);
      if (lookahead == ')') ADVANCE(793);
      if (lookahead == '?') ADVANCE(683);
      if (lookahead == '`') ADVANCE(686);
      if (lookahead != 0) ADVANCE(686);
      END_STATE();
    case 518:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(593);
      if (lookahead == ' ') ADVANCE(703);
      if (lookahead == '"') ADVANCE(703);
      if (lookahead == '\'') ADVANCE(703);
      if (lookahead == ')') ADVANCE(787);
      if (lookahead == '?') ADVANCE(700);
      if (lookahead == '`') ADVANCE(703);
      if (lookahead != 0) ADVANCE(703);
      END_STATE();
    case 519:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(544);
      if (lookahead == ' ') ADVANCE(635);
      if (lookahead == '"') ADVANCE(636);
      if (lookahead == '\'') ADVANCE(677);
      if (lookahead == '(') ADVANCE(635);
      if (lookahead == ')') ADVANCE(780);
      if (lookahead == ',') ADVANCE(635);
      if (lookahead == '?') ADVANCE(557);
      if (lookahead == '`') ADVANCE(679);
      if (lookahead != 0) ADVANCE(636);
      END_STATE();
    case 520:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(544);
      if (lookahead == ' ') ADVANCE(641);
      if (lookahead == '"') ADVANCE(677);
      if (lookahead == '\'') ADVANCE(642);
      if (lookahead == '(') ADVANCE(641);
      if (lookahead == ')') ADVANCE(790);
      if (lookahead == ',') ADVANCE(641);
      if (lookahead == '?') ADVANCE(559);
      if (lookahead == '`') ADVANCE(681);
      if (lookahead != 0) ADVANCE(642);
      END_STATE();
    case 521:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(544);
      if (lookahead == ' ') ADVANCE(676);
      if (lookahead == '"') ADVANCE(677);
      if (lookahead == '\'') ADVANCE(677);
      if (lookahead == '(') ADVANCE(676);
      if (lookahead == ')') ADVANCE(783);
      if (lookahead == ',') ADVANCE(676);
      if (lookahead == '?') ADVANCE(575);
      if (lookahead == '`') ADVANCE(701);
      if (lookahead != 0) ADVANCE(677);
      END_STATE();
    case 522:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(544);
      if (lookahead == ' ') ADVANCE(678);
      if (lookahead == '"') ADVANCE(679);
      if (lookahead == '\'') ADVANCE(701);
      if (lookahead == '(') ADVANCE(678);
      if (lookahead == ')') ADVANCE(788);
      if (lookahead == ',') ADVANCE(678);
      if (lookahead == '?') ADVANCE(602);
      if (lookahead == '`') ADVANCE(679);
      if (lookahead != 0) ADVANCE(679);
      END_STATE();
    case 523:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(544);
      if (lookahead == ' ') ADVANCE(682);
      if (lookahead == '"') ADVANCE(701);
      if (lookahead == '\'') ADVANCE(681);
      if (lookahead == '(') ADVANCE(682);
      if (lookahead == ')') ADVANCE(794);
      if (lookahead == ',') ADVANCE(682);
      if (lookahead == '?') ADVANCE(604);
      if (lookahead == '`') ADVANCE(681);
      if (lookahead != 0) ADVANCE(681);
      END_STATE();
    case 524:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(544);
      if (lookahead == ' ') ADVANCE(702);
      if (lookahead == '"') ADVANCE(701);
      if (lookahead == '\'') ADVANCE(701);
      if (lookahead == '(') ADVANCE(702);
      if (lookahead == ')') ADVANCE(789);
      if (lookahead == ',') ADVANCE(702);
      if (lookahead == '?') ADVANCE(606);
      if (lookahead == '`') ADVANCE(701);
      if (lookahead != 0) ADVANCE(701);
      END_STATE();
    case 525:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(544);
      if (lookahead == ' ') ADVANCE(706);
      if (lookahead == '"') ADVANCE(679);
      if (lookahead == '\'') ADVANCE(681);
      if (lookahead == '(') ADVANCE(706);
      if (lookahead == ')') ADVANCE(813);
      if (lookahead == ',') ADVANCE(706);
      if (lookahead == '?') ADVANCE(598);
      if (lookahead == '`') ADVANCE(707);
      if (lookahead != 0) ADVANCE(707);
      END_STATE();
    case 526:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(609);
      if (lookahead == ' ') ADVANCE(652);
      if (lookahead == '"') ADVANCE(652);
      if (lookahead == '\'') ADVANCE(688);
      if (lookahead == ')') ADVANCE(62);
      if (lookahead == '?') ADVANCE(610);
      if (lookahead == '`') ADVANCE(690);
      if (lookahead != 0) ADVANCE(652);
      END_STATE();
    case 527:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(609);
      if (lookahead == ' ') ADVANCE(654);
      if (lookahead == '"') ADVANCE(688);
      if (lookahead == '\'') ADVANCE(654);
      if (lookahead == ')') ADVANCE(93);
      if (lookahead == '?') ADVANCE(620);
      if (lookahead == '`') ADVANCE(692);
      if (lookahead != 0) ADVANCE(654);
      END_STATE();
    case 528:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(609);
      if (lookahead == ' ') ADVANCE(656);
      if (lookahead == '"') ADVANCE(690);
      if (lookahead == '\'') ADVANCE(692);
      if (lookahead == ')') ADVANCE(134);
      if (lookahead == '?') ADVANCE(629);
      if (lookahead == '`') ADVANCE(656);
      if (lookahead != 0) ADVANCE(656);
      END_STATE();
    case 529:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(609);
      if (lookahead == ' ') ADVANCE(688);
      if (lookahead == '"') ADVANCE(688);
      if (lookahead == '\'') ADVANCE(688);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == '?') ADVANCE(664);
      if (lookahead == '`') ADVANCE(705);
      if (lookahead != 0) ADVANCE(688);
      END_STATE();
    case 530:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(609);
      if (lookahead == ' ') ADVANCE(690);
      if (lookahead == '"') ADVANCE(690);
      if (lookahead == '\'') ADVANCE(705);
      if (lookahead == ')') ADVANCE(67);
      if (lookahead == '?') ADVANCE(668);
      if (lookahead == '`') ADVANCE(690);
      if (lookahead != 0) ADVANCE(690);
      END_STATE();
    case 531:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(609);
      if (lookahead == ' ') ADVANCE(692);
      if (lookahead == '"') ADVANCE(705);
      if (lookahead == '\'') ADVANCE(692);
      if (lookahead == ')') ADVANCE(96);
      if (lookahead == '?') ADVANCE(674);
      if (lookahead == '`') ADVANCE(692);
      if (lookahead != 0) ADVANCE(692);
      END_STATE();
    case 532:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(609);
      if (lookahead == ' ') ADVANCE(705);
      if (lookahead == '"') ADVANCE(705);
      if (lookahead == '\'') ADVANCE(705);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == '?') ADVANCE(697);
      if (lookahead == '`') ADVANCE(705);
      if (lookahead != 0) ADVANCE(705);
      END_STATE();
    case 533:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(141);
      if (lookahead == '(') ADVANCE(538);
      if (lookahead == ',') ADVANCE(534);
      if (lookahead == '[') ADVANCE(756);
      if (lookahead == ']') ADVANCE(756);
      if (lookahead != 0 &&
          lookahead != ')') ADVANCE(533);
      END_STATE();
    case 534:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(141);
      if (lookahead == ']') ADVANCE(772);
      if (lookahead == '(' ||
          lookahead == '[') ADVANCE(772);
      if (lookahead != 0 &&
          lookahead != ')') ADVANCE(534);
      END_STATE();
    case 535:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(118);
      if (lookahead == '(') ADVANCE(538);
      if (lookahead == ',') ADVANCE(536);
      if (lookahead == '}') ADVANCE(535);
      if (lookahead == '[' ||
          lookahead == ']') ADVANCE(756);
      if (lookahead != 0 &&
          lookahead != ')') ADVANCE(535);
      END_STATE();
    case 536:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(118);
      if (lookahead == ',') ADVANCE(536);
      if (lookahead == '}') ADVANCE(536);
      if (lookahead == '(' ||
          lookahead == '[' ||
          lookahead == ']') ADVANCE(772);
      if (lookahead != 0 &&
          lookahead != ')') ADVANCE(536);
      END_STATE();
    case 537:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(110);
      if (lookahead == '(') ADVANCE(538);
      if (lookahead == ')') ADVANCE(773);
      if (lookahead == ',') ADVANCE(538);
      if (lookahead != 0) ADVANCE(537);
      END_STATE();
    case 538:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(110);
      if (lookahead == ')') ADVANCE(773);
      if (lookahead != 0) ADVANCE(538);
      END_STATE();
    case 539:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(540);
      if (lookahead == '"') ADVANCE(612);
      if (lookahead == '\'') ADVANCE(618);
      if (lookahead == '(') ADVANCE(543);
      if (lookahead == ',') ADVANCE(540);
      if (lookahead == '?') ADVANCE(756);
      if (lookahead == '`') ADVANCE(626);
      if (lookahead != 0 &&
          lookahead != ')') ADVANCE(539);
      END_STATE();
    case 540:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(540);
      if (lookahead == '"') ADVANCE(613);
      if (lookahead == '\'') ADVANCE(619);
      if (lookahead == '?') ADVANCE(772);
      if (lookahead == '`') ADVANCE(627);
      if (lookahead != 0 &&
          lookahead != ')') ADVANCE(540);
      END_STATE();
    case 541:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(540);
      if (lookahead == '(') ADVANCE(543);
      if (lookahead == ',') ADVANCE(540);
      if (lookahead == '?') ADVANCE(756);
      if (lookahead != 0 &&
          lookahead != ')') ADVANCE(539);
      END_STATE();
    case 542:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(540);
      if (lookahead == '?') ADVANCE(772);
      if (lookahead != 0 &&
          lookahead != ')') ADVANCE(540);
      END_STATE();
    case 543:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(543);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '\'') ADVANCE(641);
      if (lookahead == ')') ADVANCE(773);
      if (lookahead == '?') ADVANCE(538);
      if (lookahead == '`') ADVANCE(706);
      if (lookahead != 0) ADVANCE(543);
      END_STATE();
    case 544:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(543);
      if (lookahead == '"') ADVANCE(636);
      if (lookahead == '\'') ADVANCE(642);
      if (lookahead == '(') ADVANCE(543);
      if (lookahead == ')') ADVANCE(773);
      if (lookahead == ',') ADVANCE(543);
      if (lookahead == '?') ADVANCE(537);
      if (lookahead == '`') ADVANCE(707);
      if (lookahead != 0) ADVANCE(544);
      END_STATE();
    case 545:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(543);
      if (lookahead == ')') ADVANCE(773);
      if (lookahead == '?') ADVANCE(538);
      if (lookahead != 0) ADVANCE(543);
      END_STATE();
    case 546:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(546);
      if (lookahead == '"') ADVANCE(551);
      if (lookahead == '\'') ADVANCE(596);
      if (lookahead == '?') ADVANCE(534);
      if (lookahead == ']') ADVANCE(540);
      if (lookahead == '`') ADVANCE(614);
      if (lookahead == '(' ||
          lookahead == '[') ADVANCE(540);
      if (lookahead != 0 &&
          lookahead != ')') ADVANCE(546);
      END_STATE();
    case 547:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(546);
      if (lookahead == '"') ADVANCE(552);
      if (lookahead == '\'') ADVANCE(597);
      if (lookahead == '(') ADVANCE(543);
      if (lookahead == ',') ADVANCE(546);
      if (lookahead == '?') ADVANCE(533);
      if (lookahead == '[') ADVANCE(539);
      if (lookahead == ']') ADVANCE(539);
      if (lookahead == '`') ADVANCE(615);
      if (lookahead != 0 &&
          lookahead != ')') ADVANCE(547);
      END_STATE();
    case 548:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(548);
      if (lookahead == '"') ADVANCE(657);
      if (lookahead == '\'') ADVANCE(658);
      if (lookahead == ')') ADVANCE(812);
      if (lookahead == '?') ADVANCE(553);
      if (lookahead == '\\') ADVANCE(387);
      if (lookahead == '`') ADVANCE(706);
      if (lookahead != 0) ADVANCE(548);
      END_STATE();
    case 549:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(549);
      if (lookahead == '"') ADVANCE(554);
      if (lookahead == '\'') ADVANCE(600);
      if (lookahead == ',') ADVANCE(549);
      if (lookahead == '?') ADVANCE(536);
      if (lookahead == '`') ADVANCE(616);
      if (lookahead == '}') ADVANCE(549);
      if (lookahead == '(' ||
          lookahead == '[' ||
          lookahead == ']') ADVANCE(540);
      if (lookahead != 0 &&
          lookahead != ')') ADVANCE(549);
      END_STATE();
    case 550:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(549);
      if (lookahead == '"') ADVANCE(555);
      if (lookahead == '\'') ADVANCE(601);
      if (lookahead == '(') ADVANCE(543);
      if (lookahead == ',') ADVANCE(549);
      if (lookahead == '?') ADVANCE(535);
      if (lookahead == '`') ADVANCE(617);
      if (lookahead == '}') ADVANCE(550);
      if (lookahead == '[' ||
          lookahead == ']') ADVANCE(539);
      if (lookahead != 0 &&
          lookahead != ')') ADVANCE(550);
      END_STATE();
    case 551:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(551);
      if (lookahead == '"') ADVANCE(551);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == '?') ADVANCE(560);
      if (lookahead == '\\') ADVANCE(416);
      if (lookahead == ']') ADVANCE(613);
      if (lookahead == '`') ADVANCE(630);
      if (lookahead == '(' ||
          lookahead == '[') ADVANCE(613);
      if (lookahead != 0) ADVANCE(551);
      END_STATE();
    case 552:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(551);
      if (lookahead == '"') ADVANCE(552);
      if (lookahead == '\'') ADVANCE(623);
      if (lookahead == '(') ADVANCE(635);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == ',') ADVANCE(551);
      if (lookahead == '?') ADVANCE(561);
      if (lookahead == '[') ADVANCE(612);
      if (lookahead == '\\') ADVANCE(423);
      if (lookahead == ']') ADVANCE(612);
      if (lookahead == '`') ADVANCE(631);
      if (lookahead != 0) ADVANCE(552);
      END_STATE();
    case 553:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(115);
      if (lookahead == ')') ADVANCE(812);
      if (lookahead == '\\') ADVANCE(455);
      if (lookahead == '`') ADVANCE(538);
      if (lookahead != 0) ADVANCE(553);
      END_STATE();
    case 554:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(554);
      if (lookahead == '"') ADVANCE(554);
      if (lookahead == '\'') ADVANCE(624);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == ',') ADVANCE(554);
      if (lookahead == '?') ADVANCE(568);
      if (lookahead == '\\') ADVANCE(430);
      if (lookahead == '`') ADVANCE(632);
      if (lookahead == '}') ADVANCE(554);
      if (lookahead == '(' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(613);
      if (lookahead != 0) ADVANCE(554);
      END_STATE();
    case 555:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(554);
      if (lookahead == '"') ADVANCE(555);
      if (lookahead == '\'') ADVANCE(625);
      if (lookahead == '(') ADVANCE(635);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == ',') ADVANCE(554);
      if (lookahead == '?') ADVANCE(569);
      if (lookahead == '\\') ADVANCE(437);
      if (lookahead == '`') ADVANCE(633);
      if (lookahead == '}') ADVANCE(555);
      if (('[' <= lookahead && lookahead <= ']')) ADVANCE(612);
      if (lookahead != 0) ADVANCE(555);
      END_STATE();
    case 556:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(65);
      if (lookahead == '"') ADVANCE(538);
      if (lookahead == ')') ADVANCE(780);
      if (lookahead == '\\') ADVANCE(456);
      if (lookahead != 0) ADVANCE(556);
      END_STATE();
    case 557:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(65);
      if (lookahead == '"') ADVANCE(537);
      if (lookahead == '(') ADVANCE(556);
      if (lookahead == ')') ADVANCE(780);
      if (lookahead == ',') ADVANCE(556);
      if (lookahead == '\\') ADVANCE(505);
      if (lookahead != 0) ADVANCE(557);
      END_STATE();
    case 558:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(95);
      if (lookahead == '\'') ADVANCE(538);
      if (lookahead == ')') ADVANCE(790);
      if (lookahead == '\\') ADVANCE(457);
      if (lookahead != 0) ADVANCE(558);
      END_STATE();
    case 559:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(95);
      if (lookahead == '\'') ADVANCE(537);
      if (lookahead == '(') ADVANCE(558);
      if (lookahead == ')') ADVANCE(790);
      if (lookahead == ',') ADVANCE(558);
      if (lookahead == '\\') ADVANCE(506);
      if (lookahead != 0) ADVANCE(559);
      END_STATE();
    case 560:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(68);
      if (lookahead == '"') ADVANCE(534);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == '\\') ADVANCE(477);
      if (lookahead == ']') ADVANCE(709);
      if (lookahead == '(' ||
          lookahead == '[') ADVANCE(709);
      if (lookahead != 0) ADVANCE(560);
      END_STATE();
    case 561:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(68);
      if (lookahead == '"') ADVANCE(533);
      if (lookahead == '(') ADVANCE(556);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == ',') ADVANCE(560);
      if (lookahead == '[') ADVANCE(710);
      if (lookahead == '\\') ADVANCE(484);
      if (lookahead == ']') ADVANCE(710);
      if (lookahead != 0) ADVANCE(561);
      END_STATE();
    case 562:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(97);
      if (lookahead == '\'') ADVANCE(534);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == '\\') ADVANCE(478);
      if (lookahead == ']') ADVANCE(738);
      if (lookahead == '(' ||
          lookahead == '[') ADVANCE(738);
      if (lookahead != 0) ADVANCE(562);
      END_STATE();
    case 563:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(97);
      if (lookahead == '\'') ADVANCE(533);
      if (lookahead == '(') ADVANCE(558);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == ',') ADVANCE(562);
      if (lookahead == '[') ADVANCE(739);
      if (lookahead == '\\') ADVANCE(485);
      if (lookahead == ']') ADVANCE(739);
      if (lookahead != 0) ADVANCE(563);
      END_STATE();
    case 564:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(137);
      if (lookahead == '(') ADVANCE(599);
      if (lookahead == ')') ADVANCE(138);
      if (lookahead == ',') ADVANCE(565);
      if (lookahead == '[') ADVANCE(758);
      if (lookahead == '\\') ADVANCE(486);
      if (lookahead == ']') ADVANCE(758);
      if (lookahead == '`') ADVANCE(533);
      if (lookahead != 0) ADVANCE(564);
      END_STATE();
    case 565:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(137);
      if (lookahead == ')') ADVANCE(138);
      if (lookahead == '\\') ADVANCE(479);
      if (lookahead == ']') ADVANCE(770);
      if (lookahead == '`') ADVANCE(534);
      if (lookahead == '(' ||
          lookahead == '[') ADVANCE(770);
      if (lookahead != 0) ADVANCE(565);
      END_STATE();
    case 566:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(70);
      if (lookahead == '"') ADVANCE(553);
      if (lookahead == ')') ADVANCE(782);
      if (lookahead == '\\') ADVANCE(458);
      if (lookahead == '`') ADVANCE(556);
      if (lookahead != 0) ADVANCE(566);
      END_STATE();
    case 567:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(98);
      if (lookahead == '\'') ADVANCE(553);
      if (lookahead == ')') ADVANCE(792);
      if (lookahead == '\\') ADVANCE(459);
      if (lookahead == '`') ADVANCE(558);
      if (lookahead != 0) ADVANCE(567);
      END_STATE();
    case 568:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(71);
      if (lookahead == '"') ADVANCE(536);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == ',') ADVANCE(568);
      if (lookahead == '\\') ADVANCE(491);
      if (lookahead == '}') ADVANCE(568);
      if (lookahead == '(' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(709);
      if (lookahead != 0) ADVANCE(568);
      END_STATE();
    case 569:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(71);
      if (lookahead == '"') ADVANCE(535);
      if (lookahead == '(') ADVANCE(556);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == ',') ADVANCE(568);
      if (lookahead == '\\') ADVANCE(498);
      if (lookahead == '}') ADVANCE(569);
      if (('[' <= lookahead && lookahead <= ']')) ADVANCE(710);
      if (lookahead != 0) ADVANCE(569);
      END_STATE();
    case 570:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(99);
      if (lookahead == '\'') ADVANCE(536);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == ',') ADVANCE(570);
      if (lookahead == '\\') ADVANCE(492);
      if (lookahead == '}') ADVANCE(570);
      if (lookahead == '(' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(738);
      if (lookahead != 0) ADVANCE(570);
      END_STATE();
    case 571:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(99);
      if (lookahead == '\'') ADVANCE(535);
      if (lookahead == '(') ADVANCE(558);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == ',') ADVANCE(570);
      if (lookahead == '\\') ADVANCE(499);
      if (lookahead == '}') ADVANCE(571);
      if (('[' <= lookahead && lookahead <= ']')) ADVANCE(739);
      if (lookahead != 0) ADVANCE(571);
      END_STATE();
    case 572:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(121);
      if (lookahead == '(') ADVANCE(599);
      if (lookahead == ')') ADVANCE(138);
      if (lookahead == ',') ADVANCE(573);
      if (lookahead == '\\') ADVANCE(500);
      if (lookahead == '`') ADVANCE(535);
      if (lookahead == '}') ADVANCE(572);
      if (('[' <= lookahead && lookahead <= ']')) ADVANCE(758);
      if (lookahead != 0) ADVANCE(572);
      END_STATE();
    case 573:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(121);
      if (lookahead == ')') ADVANCE(138);
      if (lookahead == ',') ADVANCE(573);
      if (lookahead == '\\') ADVANCE(493);
      if (lookahead == '`') ADVANCE(536);
      if (lookahead == '}') ADVANCE(573);
      if (lookahead == '(' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(770);
      if (lookahead != 0) ADVANCE(573);
      END_STATE();
    case 574:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(72);
      if (lookahead == '"') ADVANCE(558);
      if (lookahead == '\'') ADVANCE(556);
      if (lookahead == ')') ADVANCE(783);
      if (lookahead == '\\') ADVANCE(460);
      if (lookahead != 0) ADVANCE(574);
      END_STATE();
    case 575:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(72);
      if (lookahead == '"') ADVANCE(559);
      if (lookahead == '\'') ADVANCE(557);
      if (lookahead == '(') ADVANCE(574);
      if (lookahead == ')') ADVANCE(783);
      if (lookahead == ',') ADVANCE(574);
      if (lookahead == '\\') ADVANCE(507);
      if (lookahead != 0) ADVANCE(575);
      END_STATE();
    case 576:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(74);
      if (lookahead == '"') ADVANCE(562);
      if (lookahead == '\'') ADVANCE(560);
      if (lookahead == ')') ADVANCE(64);
      if (lookahead == '\\') ADVANCE(480);
      if (lookahead == ']') ADVANCE(713);
      if (lookahead == '(' ||
          lookahead == '[') ADVANCE(713);
      if (lookahead != 0) ADVANCE(576);
      END_STATE();
    case 577:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(74);
      if (lookahead == '"') ADVANCE(563);
      if (lookahead == '\'') ADVANCE(561);
      if (lookahead == '(') ADVANCE(574);
      if (lookahead == ')') ADVANCE(64);
      if (lookahead == ',') ADVANCE(576);
      if (lookahead == '[') ADVANCE(714);
      if (lookahead == '\\') ADVANCE(487);
      if (lookahead == ']') ADVANCE(714);
      if (lookahead != 0) ADVANCE(577);
      END_STATE();
    case 578:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(75);
      if (lookahead == '"') ADVANCE(565);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(481);
      if (lookahead == ']') ADVANCE(733);
      if (lookahead == '`') ADVANCE(560);
      if (lookahead == '(' ||
          lookahead == '[') ADVANCE(733);
      if (lookahead != 0) ADVANCE(578);
      END_STATE();
    case 579:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(75);
      if (lookahead == '"') ADVANCE(564);
      if (lookahead == '(') ADVANCE(603);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == ',') ADVANCE(578);
      if (lookahead == '[') ADVANCE(732);
      if (lookahead == '\\') ADVANCE(488);
      if (lookahead == ']') ADVANCE(732);
      if (lookahead == '`') ADVANCE(561);
      if (lookahead != 0) ADVANCE(579);
      END_STATE();
    case 580:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(100);
      if (lookahead == '\'') ADVANCE(565);
      if (lookahead == ')') ADVANCE(102);
      if (lookahead == '\\') ADVANCE(482);
      if (lookahead == ']') ADVANCE(753);
      if (lookahead == '`') ADVANCE(562);
      if (lookahead == '(' ||
          lookahead == '[') ADVANCE(753);
      if (lookahead != 0) ADVANCE(580);
      END_STATE();
    case 581:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(100);
      if (lookahead == '\'') ADVANCE(564);
      if (lookahead == '(') ADVANCE(605);
      if (lookahead == ')') ADVANCE(102);
      if (lookahead == ',') ADVANCE(580);
      if (lookahead == '[') ADVANCE(752);
      if (lookahead == '\\') ADVANCE(489);
      if (lookahead == ']') ADVANCE(752);
      if (lookahead == '`') ADVANCE(563);
      if (lookahead != 0) ADVANCE(581);
      END_STATE();
    case 582:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(76);
      if (lookahead == '"') ADVANCE(567);
      if (lookahead == '\'') ADVANCE(566);
      if (lookahead == ')') ADVANCE(786);
      if (lookahead == '\\') ADVANCE(461);
      if (lookahead == '`') ADVANCE(574);
      if (lookahead != 0) ADVANCE(582);
      END_STATE();
    case 583:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(77);
      if (lookahead == '"') ADVANCE(570);
      if (lookahead == '\'') ADVANCE(568);
      if (lookahead == ')') ADVANCE(64);
      if (lookahead == ',') ADVANCE(583);
      if (lookahead == '\\') ADVANCE(494);
      if (lookahead == '}') ADVANCE(583);
      if (lookahead == '(' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(713);
      if (lookahead != 0) ADVANCE(583);
      END_STATE();
    case 584:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(77);
      if (lookahead == '"') ADVANCE(571);
      if (lookahead == '\'') ADVANCE(569);
      if (lookahead == '(') ADVANCE(574);
      if (lookahead == ')') ADVANCE(64);
      if (lookahead == ',') ADVANCE(583);
      if (lookahead == '\\') ADVANCE(501);
      if (lookahead == '}') ADVANCE(584);
      if (('[' <= lookahead && lookahead <= ']')) ADVANCE(714);
      if (lookahead != 0) ADVANCE(584);
      END_STATE();
    case 585:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(78);
      if (lookahead == '"') ADVANCE(573);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == ',') ADVANCE(585);
      if (lookahead == '\\') ADVANCE(495);
      if (lookahead == '`') ADVANCE(568);
      if (lookahead == '}') ADVANCE(585);
      if (lookahead == '(' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(733);
      if (lookahead != 0) ADVANCE(585);
      END_STATE();
    case 586:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(78);
      if (lookahead == '"') ADVANCE(572);
      if (lookahead == '(') ADVANCE(603);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == ',') ADVANCE(585);
      if (lookahead == '\\') ADVANCE(502);
      if (lookahead == '`') ADVANCE(569);
      if (lookahead == '}') ADVANCE(586);
      if (('[' <= lookahead && lookahead <= ']')) ADVANCE(732);
      if (lookahead != 0) ADVANCE(586);
      END_STATE();
    case 587:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(101);
      if (lookahead == '\'') ADVANCE(573);
      if (lookahead == ')') ADVANCE(102);
      if (lookahead == ',') ADVANCE(587);
      if (lookahead == '\\') ADVANCE(496);
      if (lookahead == '`') ADVANCE(570);
      if (lookahead == '}') ADVANCE(587);
      if (lookahead == '(' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(753);
      if (lookahead != 0) ADVANCE(587);
      END_STATE();
    case 588:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(101);
      if (lookahead == '\'') ADVANCE(572);
      if (lookahead == '(') ADVANCE(605);
      if (lookahead == ')') ADVANCE(102);
      if (lookahead == ',') ADVANCE(587);
      if (lookahead == '\\') ADVANCE(503);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == '}') ADVANCE(588);
      if (('[' <= lookahead && lookahead <= ']')) ADVANCE(752);
      if (lookahead != 0) ADVANCE(588);
      END_STATE();
    case 589:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(79);
      if (lookahead == '"') ADVANCE(580);
      if (lookahead == '\'') ADVANCE(578);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == '\\') ADVANCE(483);
      if (lookahead == ']') ADVANCE(735);
      if (lookahead == '`') ADVANCE(576);
      if (lookahead == '(' ||
          lookahead == '[') ADVANCE(735);
      if (lookahead != 0) ADVANCE(589);
      END_STATE();
    case 590:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(79);
      if (lookahead == '"') ADVANCE(581);
      if (lookahead == '\'') ADVANCE(579);
      if (lookahead == '(') ADVANCE(607);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == ',') ADVANCE(589);
      if (lookahead == '[') ADVANCE(734);
      if (lookahead == '\\') ADVANCE(490);
      if (lookahead == ']') ADVANCE(734);
      if (lookahead == '`') ADVANCE(577);
      if (lookahead != 0) ADVANCE(590);
      END_STATE();
    case 591:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(80);
      if (lookahead == '"') ADVANCE(587);
      if (lookahead == '\'') ADVANCE(585);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == ',') ADVANCE(591);
      if (lookahead == '\\') ADVANCE(497);
      if (lookahead == '`') ADVANCE(583);
      if (lookahead == '}') ADVANCE(591);
      if (lookahead == '(' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(735);
      if (lookahead != 0) ADVANCE(591);
      END_STATE();
    case 592:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(80);
      if (lookahead == '"') ADVANCE(588);
      if (lookahead == '\'') ADVANCE(586);
      if (lookahead == '(') ADVANCE(607);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == ',') ADVANCE(591);
      if (lookahead == '\\') ADVANCE(504);
      if (lookahead == '`') ADVANCE(584);
      if (lookahead == '}') ADVANCE(592);
      if (('[' <= lookahead && lookahead <= ']')) ADVANCE(734);
      if (lookahead != 0) ADVANCE(592);
      END_STATE();
    case 593:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(593);
      if (lookahead == '"') ADVANCE(648);
      if (lookahead == '\'') ADVANCE(649);
      if (lookahead == ')') ADVANCE(809);
      if (lookahead == '?') ADVANCE(545);
      if (lookahead == '`') ADVANCE(650);
      if (lookahead != 0) ADVANCE(593);
      END_STATE();
    case 594:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(595);
      if (lookahead == '"') ADVANCE(659);
      if (lookahead == '\'') ADVANCE(661);
      if (lookahead == '(') ADVANCE(548);
      if (lookahead == ')') ADVANCE(135);
      if (lookahead == ',') ADVANCE(595);
      if (lookahead == '?') ADVANCE(757);
      if (lookahead == '\\') ADVANCE(398);
      if (lookahead == '`') ADVANCE(626);
      if (lookahead != 0) ADVANCE(594);
      END_STATE();
    case 595:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(595);
      if (lookahead == '"') ADVANCE(660);
      if (lookahead == '\'') ADVANCE(662);
      if (lookahead == ')') ADVANCE(135);
      if (lookahead == '?') ADVANCE(767);
      if (lookahead == '\\') ADVANCE(376);
      if (lookahead == '`') ADVANCE(627);
      if (lookahead != 0) ADVANCE(595);
      END_STATE();
    case 596:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(596);
      if (lookahead == '"') ADVANCE(622);
      if (lookahead == '\'') ADVANCE(596);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == '?') ADVANCE(562);
      if (lookahead == '\\') ADVANCE(417);
      if (lookahead == ']') ADVANCE(619);
      if (lookahead == '`') ADVANCE(637);
      if (lookahead == '(' ||
          lookahead == '[') ADVANCE(619);
      if (lookahead != 0) ADVANCE(596);
      END_STATE();
    case 597:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(596);
      if (lookahead == '"') ADVANCE(623);
      if (lookahead == '\'') ADVANCE(597);
      if (lookahead == '(') ADVANCE(641);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == ',') ADVANCE(596);
      if (lookahead == '?') ADVANCE(563);
      if (lookahead == '[') ADVANCE(618);
      if (lookahead == '\\') ADVANCE(424);
      if (lookahead == ']') ADVANCE(618);
      if (lookahead == '`') ADVANCE(638);
      if (lookahead != 0) ADVANCE(597);
      END_STATE();
    case 598:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(117);
      if (lookahead == '(') ADVANCE(599);
      if (lookahead == ')') ADVANCE(813);
      if (lookahead == ',') ADVANCE(599);
      if (lookahead == '\\') ADVANCE(508);
      if (lookahead == '`') ADVANCE(537);
      if (lookahead != 0) ADVANCE(598);
      END_STATE();
    case 599:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(117);
      if (lookahead == ')') ADVANCE(813);
      if (lookahead == '\\') ADVANCE(462);
      if (lookahead == '`') ADVANCE(538);
      if (lookahead != 0) ADVANCE(599);
      END_STATE();
    case 600:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(600);
      if (lookahead == '"') ADVANCE(624);
      if (lookahead == '\'') ADVANCE(600);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == ',') ADVANCE(600);
      if (lookahead == '?') ADVANCE(570);
      if (lookahead == '\\') ADVANCE(431);
      if (lookahead == '`') ADVANCE(639);
      if (lookahead == '}') ADVANCE(600);
      if (lookahead == '(' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(619);
      if (lookahead != 0) ADVANCE(600);
      END_STATE();
    case 601:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(600);
      if (lookahead == '"') ADVANCE(625);
      if (lookahead == '\'') ADVANCE(601);
      if (lookahead == '(') ADVANCE(641);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == ',') ADVANCE(600);
      if (lookahead == '?') ADVANCE(571);
      if (lookahead == '\\') ADVANCE(438);
      if (lookahead == '`') ADVANCE(640);
      if (lookahead == '}') ADVANCE(601);
      if (('[' <= lookahead && lookahead <= ']')) ADVANCE(618);
      if (lookahead != 0) ADVANCE(601);
      END_STATE();
    case 602:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(83);
      if (lookahead == '"') ADVANCE(598);
      if (lookahead == '(') ADVANCE(603);
      if (lookahead == ')') ADVANCE(788);
      if (lookahead == ',') ADVANCE(603);
      if (lookahead == '\\') ADVANCE(509);
      if (lookahead == '`') ADVANCE(557);
      if (lookahead != 0) ADVANCE(602);
      END_STATE();
    case 603:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(83);
      if (lookahead == '"') ADVANCE(599);
      if (lookahead == ')') ADVANCE(788);
      if (lookahead == '\\') ADVANCE(463);
      if (lookahead == '`') ADVANCE(556);
      if (lookahead != 0) ADVANCE(603);
      END_STATE();
    case 604:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(103);
      if (lookahead == '\'') ADVANCE(598);
      if (lookahead == '(') ADVANCE(605);
      if (lookahead == ')') ADVANCE(794);
      if (lookahead == ',') ADVANCE(605);
      if (lookahead == '\\') ADVANCE(510);
      if (lookahead == '`') ADVANCE(559);
      if (lookahead != 0) ADVANCE(604);
      END_STATE();
    case 605:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(103);
      if (lookahead == '\'') ADVANCE(599);
      if (lookahead == ')') ADVANCE(794);
      if (lookahead == '\\') ADVANCE(464);
      if (lookahead == '`') ADVANCE(558);
      if (lookahead != 0) ADVANCE(605);
      END_STATE();
    case 606:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(84);
      if (lookahead == '"') ADVANCE(604);
      if (lookahead == '\'') ADVANCE(602);
      if (lookahead == '(') ADVANCE(607);
      if (lookahead == ')') ADVANCE(789);
      if (lookahead == ',') ADVANCE(607);
      if (lookahead == '\\') ADVANCE(511);
      if (lookahead == '`') ADVANCE(575);
      if (lookahead != 0) ADVANCE(606);
      END_STATE();
    case 607:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(84);
      if (lookahead == '"') ADVANCE(605);
      if (lookahead == '\'') ADVANCE(603);
      if (lookahead == ')') ADVANCE(789);
      if (lookahead == '\\') ADVANCE(465);
      if (lookahead == '`') ADVANCE(574);
      if (lookahead != 0) ADVANCE(607);
      END_STATE();
    case 608:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(609);
      if (lookahead == '"') ADVANCE(651);
      if (lookahead == '\'') ADVANCE(653);
      if (lookahead == '(') ADVANCE(593);
      if (lookahead == ')') ADVANCE(130);
      if (lookahead == ',') ADVANCE(609);
      if (lookahead == '?') ADVANCE(541);
      if (lookahead == '`') ADVANCE(655);
      if (lookahead != 0) ADVANCE(608);
      END_STATE();
    case 609:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(609);
      if (lookahead == '"') ADVANCE(652);
      if (lookahead == '\'') ADVANCE(654);
      if (lookahead == ')') ADVANCE(130);
      if (lookahead == '?') ADVANCE(542);
      if (lookahead == '`') ADVANCE(656);
      if (lookahead != 0) ADVANCE(609);
      END_STATE();
    case 610:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(613);
      if (lookahead == '"') ADVANCE(540);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == '?') ADVANCE(709);
      if (lookahead == '\\') ADVANCE(377);
      if (lookahead != 0) ADVANCE(613);
      END_STATE();
    case 611:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(613);
      if (lookahead == '"') ADVANCE(539);
      if (lookahead == '(') ADVANCE(635);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == ',') ADVANCE(613);
      if (lookahead == '?') ADVANCE(710);
      if (lookahead == '\\') ADVANCE(399);
      if (lookahead != 0) ADVANCE(612);
      END_STATE();
    case 612:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(613);
      if (lookahead == '"') ADVANCE(612);
      if (lookahead == '\'') ADVANCE(665);
      if (lookahead == '(') ADVANCE(635);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == ',') ADVANCE(613);
      if (lookahead == '?') ADVANCE(710);
      if (lookahead == '\\') ADVANCE(399);
      if (lookahead == '`') ADVANCE(669);
      if (lookahead != 0) ADVANCE(612);
      END_STATE();
    case 613:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(613);
      if (lookahead == '"') ADVANCE(613);
      if (lookahead == '\'') ADVANCE(666);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == '?') ADVANCE(709);
      if (lookahead == '\\') ADVANCE(377);
      if (lookahead == '`') ADVANCE(670);
      if (lookahead != 0) ADVANCE(613);
      END_STATE();
    case 614:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(614);
      if (lookahead == '"') ADVANCE(630);
      if (lookahead == '\'') ADVANCE(637);
      if (lookahead == ')') ADVANCE(138);
      if (lookahead == '?') ADVANCE(565);
      if (lookahead == '\\') ADVANCE(418);
      if (lookahead == ']') ADVANCE(627);
      if (lookahead == '`') ADVANCE(614);
      if (lookahead == '(' ||
          lookahead == '[') ADVANCE(627);
      if (lookahead != 0) ADVANCE(614);
      END_STATE();
    case 615:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(614);
      if (lookahead == '"') ADVANCE(631);
      if (lookahead == '\'') ADVANCE(638);
      if (lookahead == '(') ADVANCE(706);
      if (lookahead == ')') ADVANCE(138);
      if (lookahead == ',') ADVANCE(614);
      if (lookahead == '?') ADVANCE(564);
      if (lookahead == '[') ADVANCE(626);
      if (lookahead == '\\') ADVANCE(425);
      if (lookahead == ']') ADVANCE(626);
      if (lookahead == '`') ADVANCE(615);
      if (lookahead != 0) ADVANCE(615);
      END_STATE();
    case 616:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(616);
      if (lookahead == '"') ADVANCE(632);
      if (lookahead == '\'') ADVANCE(639);
      if (lookahead == ')') ADVANCE(138);
      if (lookahead == ',') ADVANCE(616);
      if (lookahead == '?') ADVANCE(573);
      if (lookahead == '\\') ADVANCE(432);
      if (lookahead == '`') ADVANCE(616);
      if (lookahead == '}') ADVANCE(616);
      if (lookahead == '(' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(627);
      if (lookahead != 0) ADVANCE(616);
      END_STATE();
    case 617:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(616);
      if (lookahead == '"') ADVANCE(633);
      if (lookahead == '\'') ADVANCE(640);
      if (lookahead == '(') ADVANCE(706);
      if (lookahead == ')') ADVANCE(138);
      if (lookahead == ',') ADVANCE(616);
      if (lookahead == '?') ADVANCE(572);
      if (lookahead == '\\') ADVANCE(439);
      if (lookahead == '`') ADVANCE(617);
      if (lookahead == '}') ADVANCE(617);
      if (('[' <= lookahead && lookahead <= ']')) ADVANCE(626);
      if (lookahead != 0) ADVANCE(617);
      END_STATE();
    case 618:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(619);
      if (lookahead == '"') ADVANCE(665);
      if (lookahead == '\'') ADVANCE(618);
      if (lookahead == '(') ADVANCE(641);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == ',') ADVANCE(619);
      if (lookahead == '?') ADVANCE(739);
      if (lookahead == '\\') ADVANCE(400);
      if (lookahead == '`') ADVANCE(671);
      if (lookahead != 0) ADVANCE(618);
      END_STATE();
    case 619:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(619);
      if (lookahead == '"') ADVANCE(666);
      if (lookahead == '\'') ADVANCE(619);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == '?') ADVANCE(738);
      if (lookahead == '\\') ADVANCE(378);
      if (lookahead == '`') ADVANCE(672);
      if (lookahead != 0) ADVANCE(619);
      END_STATE();
    case 620:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(619);
      if (lookahead == '\'') ADVANCE(540);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == '?') ADVANCE(738);
      if (lookahead == '\\') ADVANCE(378);
      if (lookahead != 0) ADVANCE(619);
      END_STATE();
    case 621:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(619);
      if (lookahead == '\'') ADVANCE(539);
      if (lookahead == '(') ADVANCE(641);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == ',') ADVANCE(619);
      if (lookahead == '?') ADVANCE(739);
      if (lookahead == '\\') ADVANCE(400);
      if (lookahead != 0) ADVANCE(618);
      END_STATE();
    case 622:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(622);
      if (lookahead == '"') ADVANCE(622);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == ')') ADVANCE(64);
      if (lookahead == '?') ADVANCE(576);
      if (lookahead == '\\') ADVANCE(419);
      if (lookahead == ']') ADVANCE(666);
      if (lookahead == '`') ADVANCE(644);
      if (lookahead == '(' ||
          lookahead == '[') ADVANCE(666);
      if (lookahead != 0) ADVANCE(622);
      END_STATE();
    case 623:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(622);
      if (lookahead == '"') ADVANCE(623);
      if (lookahead == '\'') ADVANCE(623);
      if (lookahead == '(') ADVANCE(676);
      if (lookahead == ')') ADVANCE(64);
      if (lookahead == ',') ADVANCE(622);
      if (lookahead == '?') ADVANCE(577);
      if (lookahead == '[') ADVANCE(665);
      if (lookahead == '\\') ADVANCE(426);
      if (lookahead == ']') ADVANCE(665);
      if (lookahead == '`') ADVANCE(645);
      if (lookahead != 0) ADVANCE(623);
      END_STATE();
    case 624:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(624);
      if (lookahead == '"') ADVANCE(624);
      if (lookahead == '\'') ADVANCE(624);
      if (lookahead == ')') ADVANCE(64);
      if (lookahead == ',') ADVANCE(624);
      if (lookahead == '?') ADVANCE(583);
      if (lookahead == '\\') ADVANCE(433);
      if (lookahead == '`') ADVANCE(646);
      if (lookahead == '}') ADVANCE(624);
      if (lookahead == '(' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(666);
      if (lookahead != 0) ADVANCE(624);
      END_STATE();
    case 625:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(624);
      if (lookahead == '"') ADVANCE(625);
      if (lookahead == '\'') ADVANCE(625);
      if (lookahead == '(') ADVANCE(676);
      if (lookahead == ')') ADVANCE(64);
      if (lookahead == ',') ADVANCE(624);
      if (lookahead == '?') ADVANCE(584);
      if (lookahead == '\\') ADVANCE(440);
      if (lookahead == '`') ADVANCE(647);
      if (lookahead == '}') ADVANCE(625);
      if (('[' <= lookahead && lookahead <= ']')) ADVANCE(665);
      if (lookahead != 0) ADVANCE(625);
      END_STATE();
    case 626:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(627);
      if (lookahead == '"') ADVANCE(669);
      if (lookahead == '\'') ADVANCE(671);
      if (lookahead == '(') ADVANCE(706);
      if (lookahead == ')') ADVANCE(138);
      if (lookahead == ',') ADVANCE(627);
      if (lookahead == '?') ADVANCE(758);
      if (lookahead == '\\') ADVANCE(401);
      if (lookahead == '`') ADVANCE(626);
      if (lookahead != 0) ADVANCE(626);
      END_STATE();
    case 627:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(627);
      if (lookahead == '"') ADVANCE(670);
      if (lookahead == '\'') ADVANCE(672);
      if (lookahead == ')') ADVANCE(138);
      if (lookahead == '?') ADVANCE(770);
      if (lookahead == '\\') ADVANCE(379);
      if (lookahead == '`') ADVANCE(627);
      if (lookahead != 0) ADVANCE(627);
      END_STATE();
    case 628:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(627);
      if (lookahead == '(') ADVANCE(706);
      if (lookahead == ')') ADVANCE(138);
      if (lookahead == ',') ADVANCE(627);
      if (lookahead == '?') ADVANCE(758);
      if (lookahead == '\\') ADVANCE(401);
      if (lookahead == '`') ADVANCE(539);
      if (lookahead != 0) ADVANCE(626);
      END_STATE();
    case 629:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(627);
      if (lookahead == ')') ADVANCE(138);
      if (lookahead == '?') ADVANCE(770);
      if (lookahead == '\\') ADVANCE(379);
      if (lookahead == '`') ADVANCE(540);
      if (lookahead != 0) ADVANCE(627);
      END_STATE();
    case 630:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(630);
      if (lookahead == '"') ADVANCE(630);
      if (lookahead == '\'') ADVANCE(644);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == '?') ADVANCE(578);
      if (lookahead == '\\') ADVANCE(420);
      if (lookahead == ']') ADVANCE(670);
      if (lookahead == '`') ADVANCE(630);
      if (lookahead == '(' ||
          lookahead == '[') ADVANCE(670);
      if (lookahead != 0) ADVANCE(630);
      END_STATE();
    case 631:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(630);
      if (lookahead == '"') ADVANCE(631);
      if (lookahead == '\'') ADVANCE(645);
      if (lookahead == '(') ADVANCE(678);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == ',') ADVANCE(630);
      if (lookahead == '?') ADVANCE(579);
      if (lookahead == '[') ADVANCE(669);
      if (lookahead == '\\') ADVANCE(427);
      if (lookahead == ']') ADVANCE(669);
      if (lookahead == '`') ADVANCE(631);
      if (lookahead != 0) ADVANCE(631);
      END_STATE();
    case 632:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(632);
      if (lookahead == '"') ADVANCE(632);
      if (lookahead == '\'') ADVANCE(646);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == ',') ADVANCE(632);
      if (lookahead == '?') ADVANCE(585);
      if (lookahead == '\\') ADVANCE(434);
      if (lookahead == '`') ADVANCE(632);
      if (lookahead == '}') ADVANCE(632);
      if (lookahead == '(' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(670);
      if (lookahead != 0) ADVANCE(632);
      END_STATE();
    case 633:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(632);
      if (lookahead == '"') ADVANCE(633);
      if (lookahead == '\'') ADVANCE(647);
      if (lookahead == '(') ADVANCE(678);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == ',') ADVANCE(632);
      if (lookahead == '?') ADVANCE(586);
      if (lookahead == '\\') ADVANCE(441);
      if (lookahead == '`') ADVANCE(633);
      if (lookahead == '}') ADVANCE(633);
      if (('[' <= lookahead && lookahead <= ']')) ADVANCE(669);
      if (lookahead != 0) ADVANCE(633);
      END_STATE();
    case 634:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(635);
      if (lookahead == '"') ADVANCE(543);
      if (lookahead == ')') ADVANCE(780);
      if (lookahead == '?') ADVANCE(556);
      if (lookahead == '\\') ADVANCE(388);
      if (lookahead != 0) ADVANCE(635);
      END_STATE();
    case 635:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(635);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '\'') ADVANCE(676);
      if (lookahead == ')') ADVANCE(780);
      if (lookahead == '?') ADVANCE(556);
      if (lookahead == '\\') ADVANCE(388);
      if (lookahead == '`') ADVANCE(678);
      if (lookahead != 0) ADVANCE(635);
      END_STATE();
    case 636:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(635);
      if (lookahead == '"') ADVANCE(636);
      if (lookahead == '\'') ADVANCE(677);
      if (lookahead == '(') ADVANCE(635);
      if (lookahead == ')') ADVANCE(780);
      if (lookahead == ',') ADVANCE(635);
      if (lookahead == '?') ADVANCE(557);
      if (lookahead == '\\') ADVANCE(519);
      if (lookahead == '`') ADVANCE(679);
      if (lookahead != 0) ADVANCE(636);
      END_STATE();
    case 637:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(637);
      if (lookahead == '"') ADVANCE(644);
      if (lookahead == '\'') ADVANCE(637);
      if (lookahead == ')') ADVANCE(102);
      if (lookahead == '?') ADVANCE(580);
      if (lookahead == '\\') ADVANCE(421);
      if (lookahead == ']') ADVANCE(672);
      if (lookahead == '`') ADVANCE(637);
      if (lookahead == '(' ||
          lookahead == '[') ADVANCE(672);
      if (lookahead != 0) ADVANCE(637);
      END_STATE();
    case 638:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(637);
      if (lookahead == '"') ADVANCE(645);
      if (lookahead == '\'') ADVANCE(638);
      if (lookahead == '(') ADVANCE(682);
      if (lookahead == ')') ADVANCE(102);
      if (lookahead == ',') ADVANCE(637);
      if (lookahead == '?') ADVANCE(581);
      if (lookahead == '[') ADVANCE(671);
      if (lookahead == '\\') ADVANCE(428);
      if (lookahead == ']') ADVANCE(671);
      if (lookahead == '`') ADVANCE(638);
      if (lookahead != 0) ADVANCE(638);
      END_STATE();
    case 639:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(639);
      if (lookahead == '"') ADVANCE(646);
      if (lookahead == '\'') ADVANCE(639);
      if (lookahead == ')') ADVANCE(102);
      if (lookahead == ',') ADVANCE(639);
      if (lookahead == '?') ADVANCE(587);
      if (lookahead == '\\') ADVANCE(435);
      if (lookahead == '`') ADVANCE(639);
      if (lookahead == '}') ADVANCE(639);
      if (lookahead == '(' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(672);
      if (lookahead != 0) ADVANCE(639);
      END_STATE();
    case 640:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(639);
      if (lookahead == '"') ADVANCE(647);
      if (lookahead == '\'') ADVANCE(640);
      if (lookahead == '(') ADVANCE(682);
      if (lookahead == ')') ADVANCE(102);
      if (lookahead == ',') ADVANCE(639);
      if (lookahead == '?') ADVANCE(588);
      if (lookahead == '\\') ADVANCE(442);
      if (lookahead == '`') ADVANCE(640);
      if (lookahead == '}') ADVANCE(640);
      if (('[' <= lookahead && lookahead <= ']')) ADVANCE(671);
      if (lookahead != 0) ADVANCE(640);
      END_STATE();
    case 641:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(641);
      if (lookahead == '"') ADVANCE(676);
      if (lookahead == '\'') ADVANCE(641);
      if (lookahead == ')') ADVANCE(790);
      if (lookahead == '?') ADVANCE(558);
      if (lookahead == '\\') ADVANCE(389);
      if (lookahead == '`') ADVANCE(682);
      if (lookahead != 0) ADVANCE(641);
      END_STATE();
    case 642:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(641);
      if (lookahead == '"') ADVANCE(677);
      if (lookahead == '\'') ADVANCE(642);
      if (lookahead == '(') ADVANCE(641);
      if (lookahead == ')') ADVANCE(790);
      if (lookahead == ',') ADVANCE(641);
      if (lookahead == '?') ADVANCE(559);
      if (lookahead == '\\') ADVANCE(520);
      if (lookahead == '`') ADVANCE(681);
      if (lookahead != 0) ADVANCE(642);
      END_STATE();
    case 643:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(641);
      if (lookahead == '\'') ADVANCE(543);
      if (lookahead == ')') ADVANCE(790);
      if (lookahead == '?') ADVANCE(558);
      if (lookahead == '\\') ADVANCE(389);
      if (lookahead != 0) ADVANCE(641);
      END_STATE();
    case 644:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(644);
      if (lookahead == '"') ADVANCE(644);
      if (lookahead == '\'') ADVANCE(644);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == '?') ADVANCE(589);
      if (lookahead == '\\') ADVANCE(422);
      if (lookahead == ']') ADVANCE(699);
      if (lookahead == '`') ADVANCE(644);
      if (lookahead == '(' ||
          lookahead == '[') ADVANCE(699);
      if (lookahead != 0) ADVANCE(644);
      END_STATE();
    case 645:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(644);
      if (lookahead == '"') ADVANCE(645);
      if (lookahead == '\'') ADVANCE(645);
      if (lookahead == '(') ADVANCE(702);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == ',') ADVANCE(644);
      if (lookahead == '?') ADVANCE(590);
      if (lookahead == '[') ADVANCE(698);
      if (lookahead == '\\') ADVANCE(429);
      if (lookahead == ']') ADVANCE(698);
      if (lookahead == '`') ADVANCE(645);
      if (lookahead != 0) ADVANCE(645);
      END_STATE();
    case 646:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(646);
      if (lookahead == '"') ADVANCE(646);
      if (lookahead == '\'') ADVANCE(646);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == ',') ADVANCE(646);
      if (lookahead == '?') ADVANCE(591);
      if (lookahead == '\\') ADVANCE(436);
      if (lookahead == '`') ADVANCE(646);
      if (lookahead == '}') ADVANCE(646);
      if (lookahead == '(' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(699);
      if (lookahead != 0) ADVANCE(646);
      END_STATE();
    case 647:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(646);
      if (lookahead == '"') ADVANCE(647);
      if (lookahead == '\'') ADVANCE(647);
      if (lookahead == '(') ADVANCE(702);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == ',') ADVANCE(646);
      if (lookahead == '?') ADVANCE(592);
      if (lookahead == '\\') ADVANCE(443);
      if (lookahead == '`') ADVANCE(647);
      if (lookahead == '}') ADVANCE(647);
      if (('[' <= lookahead && lookahead <= ']')) ADVANCE(698);
      if (lookahead != 0) ADVANCE(647);
      END_STATE();
    case 648:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(648);
      if (lookahead == '"') ADVANCE(648);
      if (lookahead == '\'') ADVANCE(684);
      if (lookahead == ')') ADVANCE(781);
      if (lookahead == '?') ADVANCE(634);
      if (lookahead == '\\') ADVANCE(512);
      if (lookahead == '`') ADVANCE(685);
      if (lookahead != 0) ADVANCE(648);
      END_STATE();
    case 649:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(649);
      if (lookahead == '"') ADVANCE(684);
      if (lookahead == '\'') ADVANCE(649);
      if (lookahead == ')') ADVANCE(791);
      if (lookahead == '?') ADVANCE(643);
      if (lookahead == '\\') ADVANCE(513);
      if (lookahead == '`') ADVANCE(686);
      if (lookahead != 0) ADVANCE(649);
      END_STATE();
    case 650:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(650);
      if (lookahead == '"') ADVANCE(685);
      if (lookahead == '\'') ADVANCE(686);
      if (lookahead == ')') ADVANCE(811);
      if (lookahead == '?') ADVANCE(708);
      if (lookahead == '\\') ADVANCE(514);
      if (lookahead == '`') ADVANCE(650);
      if (lookahead != 0) ADVANCE(650);
      END_STATE();
    case 651:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(652);
      if (lookahead == '"') ADVANCE(651);
      if (lookahead == '\'') ADVANCE(687);
      if (lookahead == '(') ADVANCE(648);
      if (lookahead == ')') ADVANCE(62);
      if (lookahead == ',') ADVANCE(652);
      if (lookahead == '?') ADVANCE(611);
      if (lookahead == '\\') ADVANCE(409);
      if (lookahead == '`') ADVANCE(689);
      if (lookahead != 0) ADVANCE(651);
      END_STATE();
    case 652:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(652);
      if (lookahead == '"') ADVANCE(652);
      if (lookahead == '\'') ADVANCE(688);
      if (lookahead == ')') ADVANCE(62);
      if (lookahead == '?') ADVANCE(610);
      if (lookahead == '\\') ADVANCE(526);
      if (lookahead == '`') ADVANCE(690);
      if (lookahead != 0) ADVANCE(652);
      END_STATE();
    case 653:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(654);
      if (lookahead == '"') ADVANCE(687);
      if (lookahead == '\'') ADVANCE(653);
      if (lookahead == '(') ADVANCE(649);
      if (lookahead == ')') ADVANCE(93);
      if (lookahead == ',') ADVANCE(654);
      if (lookahead == '?') ADVANCE(621);
      if (lookahead == '\\') ADVANCE(410);
      if (lookahead == '`') ADVANCE(691);
      if (lookahead != 0) ADVANCE(653);
      END_STATE();
    case 654:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(654);
      if (lookahead == '"') ADVANCE(688);
      if (lookahead == '\'') ADVANCE(654);
      if (lookahead == ')') ADVANCE(93);
      if (lookahead == '?') ADVANCE(620);
      if (lookahead == '\\') ADVANCE(527);
      if (lookahead == '`') ADVANCE(692);
      if (lookahead != 0) ADVANCE(654);
      END_STATE();
    case 655:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(656);
      if (lookahead == '"') ADVANCE(689);
      if (lookahead == '\'') ADVANCE(691);
      if (lookahead == '(') ADVANCE(650);
      if (lookahead == ')') ADVANCE(134);
      if (lookahead == ',') ADVANCE(656);
      if (lookahead == '?') ADVANCE(628);
      if (lookahead == '\\') ADVANCE(411);
      if (lookahead == '`') ADVANCE(655);
      if (lookahead != 0) ADVANCE(655);
      END_STATE();
    case 656:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(656);
      if (lookahead == '"') ADVANCE(690);
      if (lookahead == '\'') ADVANCE(692);
      if (lookahead == ')') ADVANCE(134);
      if (lookahead == '?') ADVANCE(629);
      if (lookahead == '\\') ADVANCE(528);
      if (lookahead == '`') ADVANCE(656);
      if (lookahead != 0) ADVANCE(656);
      END_STATE();
    case 657:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(657);
      if (lookahead == '"') ADVANCE(657);
      if (lookahead == '\'') ADVANCE(693);
      if (lookahead == ')') ADVANCE(782);
      if (lookahead == '?') ADVANCE(566);
      if (lookahead == '\\') ADVANCE(390);
      if (lookahead == '`') ADVANCE(678);
      if (lookahead != 0) ADVANCE(657);
      END_STATE();
    case 658:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(658);
      if (lookahead == '"') ADVANCE(693);
      if (lookahead == '\'') ADVANCE(658);
      if (lookahead == ')') ADVANCE(792);
      if (lookahead == '?') ADVANCE(567);
      if (lookahead == '\\') ADVANCE(391);
      if (lookahead == '`') ADVANCE(682);
      if (lookahead != 0) ADVANCE(658);
      END_STATE();
    case 659:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(660);
      if (lookahead == '"') ADVANCE(659);
      if (lookahead == '\'') ADVANCE(694);
      if (lookahead == '(') ADVANCE(657);
      if (lookahead == ')') ADVANCE(63);
      if (lookahead == ',') ADVANCE(660);
      if (lookahead == '?') ADVANCE(711);
      if (lookahead == '\\') ADVANCE(402);
      if (lookahead == '`') ADVANCE(669);
      if (lookahead != 0) ADVANCE(659);
      END_STATE();
    case 660:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(660);
      if (lookahead == '"') ADVANCE(660);
      if (lookahead == '\'') ADVANCE(695);
      if (lookahead == ')') ADVANCE(63);
      if (lookahead == '?') ADVANCE(712);
      if (lookahead == '\\') ADVANCE(380);
      if (lookahead == '`') ADVANCE(670);
      if (lookahead != 0) ADVANCE(660);
      END_STATE();
    case 661:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(662);
      if (lookahead == '"') ADVANCE(694);
      if (lookahead == '\'') ADVANCE(661);
      if (lookahead == '(') ADVANCE(658);
      if (lookahead == ')') ADVANCE(94);
      if (lookahead == ',') ADVANCE(662);
      if (lookahead == '?') ADVANCE(740);
      if (lookahead == '\\') ADVANCE(403);
      if (lookahead == '`') ADVANCE(671);
      if (lookahead != 0) ADVANCE(661);
      END_STATE();
    case 662:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(662);
      if (lookahead == '"') ADVANCE(695);
      if (lookahead == '\'') ADVANCE(662);
      if (lookahead == ')') ADVANCE(94);
      if (lookahead == '?') ADVANCE(741);
      if (lookahead == '\\') ADVANCE(381);
      if (lookahead == '`') ADVANCE(672);
      if (lookahead != 0) ADVANCE(662);
      END_STATE();
    case 663:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(666);
      if (lookahead == '"') ADVANCE(618);
      if (lookahead == '\'') ADVANCE(612);
      if (lookahead == '(') ADVANCE(676);
      if (lookahead == ')') ADVANCE(64);
      if (lookahead == ',') ADVANCE(666);
      if (lookahead == '?') ADVANCE(714);
      if (lookahead == '\\') ADVANCE(404);
      if (lookahead != 0) ADVANCE(665);
      END_STATE();
    case 664:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(666);
      if (lookahead == '"') ADVANCE(619);
      if (lookahead == '\'') ADVANCE(613);
      if (lookahead == ')') ADVANCE(64);
      if (lookahead == '?') ADVANCE(713);
      if (lookahead == '\\') ADVANCE(382);
      if (lookahead != 0) ADVANCE(666);
      END_STATE();
    case 665:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(666);
      if (lookahead == '"') ADVANCE(665);
      if (lookahead == '\'') ADVANCE(665);
      if (lookahead == '(') ADVANCE(676);
      if (lookahead == ')') ADVANCE(64);
      if (lookahead == ',') ADVANCE(666);
      if (lookahead == '?') ADVANCE(714);
      if (lookahead == '\\') ADVANCE(404);
      if (lookahead == '`') ADVANCE(698);
      if (lookahead != 0) ADVANCE(665);
      END_STATE();
    case 666:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(666);
      if (lookahead == '"') ADVANCE(666);
      if (lookahead == '\'') ADVANCE(666);
      if (lookahead == ')') ADVANCE(64);
      if (lookahead == '?') ADVANCE(713);
      if (lookahead == '\\') ADVANCE(382);
      if (lookahead == '`') ADVANCE(699);
      if (lookahead != 0) ADVANCE(666);
      END_STATE();
    case 667:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(670);
      if (lookahead == '"') ADVANCE(626);
      if (lookahead == '(') ADVANCE(678);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == ',') ADVANCE(670);
      if (lookahead == '?') ADVANCE(732);
      if (lookahead == '\\') ADVANCE(405);
      if (lookahead == '`') ADVANCE(612);
      if (lookahead != 0) ADVANCE(669);
      END_STATE();
    case 668:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(670);
      if (lookahead == '"') ADVANCE(627);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == '?') ADVANCE(733);
      if (lookahead == '\\') ADVANCE(383);
      if (lookahead == '`') ADVANCE(613);
      if (lookahead != 0) ADVANCE(670);
      END_STATE();
    case 669:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(670);
      if (lookahead == '"') ADVANCE(669);
      if (lookahead == '\'') ADVANCE(698);
      if (lookahead == '(') ADVANCE(678);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == ',') ADVANCE(670);
      if (lookahead == '?') ADVANCE(732);
      if (lookahead == '\\') ADVANCE(405);
      if (lookahead == '`') ADVANCE(669);
      if (lookahead != 0) ADVANCE(669);
      END_STATE();
    case 670:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(670);
      if (lookahead == '"') ADVANCE(670);
      if (lookahead == '\'') ADVANCE(699);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == '?') ADVANCE(733);
      if (lookahead == '\\') ADVANCE(383);
      if (lookahead == '`') ADVANCE(670);
      if (lookahead != 0) ADVANCE(670);
      END_STATE();
    case 671:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(672);
      if (lookahead == '"') ADVANCE(698);
      if (lookahead == '\'') ADVANCE(671);
      if (lookahead == '(') ADVANCE(682);
      if (lookahead == ')') ADVANCE(102);
      if (lookahead == ',') ADVANCE(672);
      if (lookahead == '?') ADVANCE(752);
      if (lookahead == '\\') ADVANCE(406);
      if (lookahead == '`') ADVANCE(671);
      if (lookahead != 0) ADVANCE(671);
      END_STATE();
    case 672:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(672);
      if (lookahead == '"') ADVANCE(699);
      if (lookahead == '\'') ADVANCE(672);
      if (lookahead == ')') ADVANCE(102);
      if (lookahead == '?') ADVANCE(753);
      if (lookahead == '\\') ADVANCE(384);
      if (lookahead == '`') ADVANCE(672);
      if (lookahead != 0) ADVANCE(672);
      END_STATE();
    case 673:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(672);
      if (lookahead == '\'') ADVANCE(626);
      if (lookahead == '(') ADVANCE(682);
      if (lookahead == ')') ADVANCE(102);
      if (lookahead == ',') ADVANCE(672);
      if (lookahead == '?') ADVANCE(752);
      if (lookahead == '\\') ADVANCE(406);
      if (lookahead == '`') ADVANCE(618);
      if (lookahead != 0) ADVANCE(671);
      END_STATE();
    case 674:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(672);
      if (lookahead == '\'') ADVANCE(627);
      if (lookahead == ')') ADVANCE(102);
      if (lookahead == '?') ADVANCE(753);
      if (lookahead == '\\') ADVANCE(384);
      if (lookahead == '`') ADVANCE(619);
      if (lookahead != 0) ADVANCE(672);
      END_STATE();
    case 675:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(676);
      if (lookahead == '"') ADVANCE(641);
      if (lookahead == '\'') ADVANCE(635);
      if (lookahead == ')') ADVANCE(783);
      if (lookahead == '?') ADVANCE(574);
      if (lookahead == '\\') ADVANCE(392);
      if (lookahead != 0) ADVANCE(676);
      END_STATE();
    case 676:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(676);
      if (lookahead == '"') ADVANCE(676);
      if (lookahead == '\'') ADVANCE(676);
      if (lookahead == ')') ADVANCE(783);
      if (lookahead == '?') ADVANCE(574);
      if (lookahead == '\\') ADVANCE(392);
      if (lookahead == '`') ADVANCE(702);
      if (lookahead != 0) ADVANCE(676);
      END_STATE();
    case 677:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(676);
      if (lookahead == '"') ADVANCE(677);
      if (lookahead == '\'') ADVANCE(677);
      if (lookahead == '(') ADVANCE(676);
      if (lookahead == ')') ADVANCE(783);
      if (lookahead == ',') ADVANCE(676);
      if (lookahead == '?') ADVANCE(575);
      if (lookahead == '\\') ADVANCE(521);
      if (lookahead == '`') ADVANCE(701);
      if (lookahead != 0) ADVANCE(677);
      END_STATE();
    case 678:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(678);
      if (lookahead == '"') ADVANCE(678);
      if (lookahead == '\'') ADVANCE(702);
      if (lookahead == ')') ADVANCE(788);
      if (lookahead == '?') ADVANCE(603);
      if (lookahead == '\\') ADVANCE(393);
      if (lookahead == '`') ADVANCE(678);
      if (lookahead != 0) ADVANCE(678);
      END_STATE();
    case 679:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(678);
      if (lookahead == '"') ADVANCE(679);
      if (lookahead == '\'') ADVANCE(701);
      if (lookahead == '(') ADVANCE(678);
      if (lookahead == ')') ADVANCE(788);
      if (lookahead == ',') ADVANCE(678);
      if (lookahead == '?') ADVANCE(602);
      if (lookahead == '\\') ADVANCE(522);
      if (lookahead == '`') ADVANCE(679);
      if (lookahead != 0) ADVANCE(679);
      END_STATE();
    case 680:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(678);
      if (lookahead == '"') ADVANCE(706);
      if (lookahead == ')') ADVANCE(788);
      if (lookahead == '?') ADVANCE(603);
      if (lookahead == '\\') ADVANCE(393);
      if (lookahead == '`') ADVANCE(635);
      if (lookahead != 0) ADVANCE(678);
      END_STATE();
    case 681:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(682);
      if (lookahead == '"') ADVANCE(701);
      if (lookahead == '\'') ADVANCE(681);
      if (lookahead == '(') ADVANCE(682);
      if (lookahead == ')') ADVANCE(794);
      if (lookahead == ',') ADVANCE(682);
      if (lookahead == '?') ADVANCE(604);
      if (lookahead == '\\') ADVANCE(523);
      if (lookahead == '`') ADVANCE(681);
      if (lookahead != 0) ADVANCE(681);
      END_STATE();
    case 682:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(682);
      if (lookahead == '"') ADVANCE(702);
      if (lookahead == '\'') ADVANCE(682);
      if (lookahead == ')') ADVANCE(794);
      if (lookahead == '?') ADVANCE(605);
      if (lookahead == '\\') ADVANCE(394);
      if (lookahead == '`') ADVANCE(682);
      if (lookahead != 0) ADVANCE(682);
      END_STATE();
    case 683:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(682);
      if (lookahead == '\'') ADVANCE(706);
      if (lookahead == ')') ADVANCE(794);
      if (lookahead == '?') ADVANCE(605);
      if (lookahead == '\\') ADVANCE(394);
      if (lookahead == '`') ADVANCE(641);
      if (lookahead != 0) ADVANCE(682);
      END_STATE();
    case 684:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(684);
      if (lookahead == '"') ADVANCE(684);
      if (lookahead == '\'') ADVANCE(684);
      if (lookahead == ')') ADVANCE(784);
      if (lookahead == '?') ADVANCE(675);
      if (lookahead == '\\') ADVANCE(515);
      if (lookahead == '`') ADVANCE(703);
      if (lookahead != 0) ADVANCE(684);
      END_STATE();
    case 685:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(685);
      if (lookahead == '"') ADVANCE(685);
      if (lookahead == '\'') ADVANCE(703);
      if (lookahead == ')') ADVANCE(785);
      if (lookahead == '?') ADVANCE(680);
      if (lookahead == '\\') ADVANCE(516);
      if (lookahead == '`') ADVANCE(685);
      if (lookahead != 0) ADVANCE(685);
      END_STATE();
    case 686:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(686);
      if (lookahead == '"') ADVANCE(703);
      if (lookahead == '\'') ADVANCE(686);
      if (lookahead == ')') ADVANCE(793);
      if (lookahead == '?') ADVANCE(683);
      if (lookahead == '\\') ADVANCE(517);
      if (lookahead == '`') ADVANCE(686);
      if (lookahead != 0) ADVANCE(686);
      END_STATE();
    case 687:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(688);
      if (lookahead == '"') ADVANCE(687);
      if (lookahead == '\'') ADVANCE(687);
      if (lookahead == '(') ADVANCE(684);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == ',') ADVANCE(688);
      if (lookahead == '?') ADVANCE(663);
      if (lookahead == '\\') ADVANCE(412);
      if (lookahead == '`') ADVANCE(704);
      if (lookahead != 0) ADVANCE(687);
      END_STATE();
    case 688:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(688);
      if (lookahead == '"') ADVANCE(688);
      if (lookahead == '\'') ADVANCE(688);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == '?') ADVANCE(664);
      if (lookahead == '\\') ADVANCE(529);
      if (lookahead == '`') ADVANCE(705);
      if (lookahead != 0) ADVANCE(688);
      END_STATE();
    case 689:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(690);
      if (lookahead == '"') ADVANCE(689);
      if (lookahead == '\'') ADVANCE(704);
      if (lookahead == '(') ADVANCE(685);
      if (lookahead == ')') ADVANCE(67);
      if (lookahead == ',') ADVANCE(690);
      if (lookahead == '?') ADVANCE(667);
      if (lookahead == '\\') ADVANCE(413);
      if (lookahead == '`') ADVANCE(689);
      if (lookahead != 0) ADVANCE(689);
      END_STATE();
    case 690:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(690);
      if (lookahead == '"') ADVANCE(690);
      if (lookahead == '\'') ADVANCE(705);
      if (lookahead == ')') ADVANCE(67);
      if (lookahead == '?') ADVANCE(668);
      if (lookahead == '\\') ADVANCE(530);
      if (lookahead == '`') ADVANCE(690);
      if (lookahead != 0) ADVANCE(690);
      END_STATE();
    case 691:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(692);
      if (lookahead == '"') ADVANCE(704);
      if (lookahead == '\'') ADVANCE(691);
      if (lookahead == '(') ADVANCE(686);
      if (lookahead == ')') ADVANCE(96);
      if (lookahead == ',') ADVANCE(692);
      if (lookahead == '?') ADVANCE(673);
      if (lookahead == '\\') ADVANCE(414);
      if (lookahead == '`') ADVANCE(691);
      if (lookahead != 0) ADVANCE(691);
      END_STATE();
    case 692:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(692);
      if (lookahead == '"') ADVANCE(705);
      if (lookahead == '\'') ADVANCE(692);
      if (lookahead == ')') ADVANCE(96);
      if (lookahead == '?') ADVANCE(674);
      if (lookahead == '\\') ADVANCE(531);
      if (lookahead == '`') ADVANCE(692);
      if (lookahead != 0) ADVANCE(692);
      END_STATE();
    case 693:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(693);
      if (lookahead == '"') ADVANCE(693);
      if (lookahead == '\'') ADVANCE(693);
      if (lookahead == ')') ADVANCE(786);
      if (lookahead == '?') ADVANCE(582);
      if (lookahead == '\\') ADVANCE(395);
      if (lookahead == '`') ADVANCE(702);
      if (lookahead != 0) ADVANCE(693);
      END_STATE();
    case 694:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(695);
      if (lookahead == '"') ADVANCE(694);
      if (lookahead == '\'') ADVANCE(694);
      if (lookahead == '(') ADVANCE(693);
      if (lookahead == ')') ADVANCE(69);
      if (lookahead == ',') ADVANCE(695);
      if (lookahead == '?') ADVANCE(715);
      if (lookahead == '\\') ADVANCE(407);
      if (lookahead == '`') ADVANCE(698);
      if (lookahead != 0) ADVANCE(694);
      END_STATE();
    case 695:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(695);
      if (lookahead == '"') ADVANCE(695);
      if (lookahead == '\'') ADVANCE(695);
      if (lookahead == ')') ADVANCE(69);
      if (lookahead == '?') ADVANCE(716);
      if (lookahead == '\\') ADVANCE(385);
      if (lookahead == '`') ADVANCE(699);
      if (lookahead != 0) ADVANCE(695);
      END_STATE();
    case 696:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(699);
      if (lookahead == '"') ADVANCE(671);
      if (lookahead == '\'') ADVANCE(669);
      if (lookahead == '(') ADVANCE(702);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == ',') ADVANCE(699);
      if (lookahead == '?') ADVANCE(734);
      if (lookahead == '\\') ADVANCE(408);
      if (lookahead == '`') ADVANCE(665);
      if (lookahead != 0) ADVANCE(698);
      END_STATE();
    case 697:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(699);
      if (lookahead == '"') ADVANCE(672);
      if (lookahead == '\'') ADVANCE(670);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == '?') ADVANCE(735);
      if (lookahead == '\\') ADVANCE(386);
      if (lookahead == '`') ADVANCE(666);
      if (lookahead != 0) ADVANCE(699);
      END_STATE();
    case 698:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(699);
      if (lookahead == '"') ADVANCE(698);
      if (lookahead == '\'') ADVANCE(698);
      if (lookahead == '(') ADVANCE(702);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == ',') ADVANCE(699);
      if (lookahead == '?') ADVANCE(734);
      if (lookahead == '\\') ADVANCE(408);
      if (lookahead == '`') ADVANCE(698);
      if (lookahead != 0) ADVANCE(698);
      END_STATE();
    case 699:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(699);
      if (lookahead == '"') ADVANCE(699);
      if (lookahead == '\'') ADVANCE(699);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == '?') ADVANCE(735);
      if (lookahead == '\\') ADVANCE(386);
      if (lookahead == '`') ADVANCE(699);
      if (lookahead != 0) ADVANCE(699);
      END_STATE();
    case 700:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(702);
      if (lookahead == '"') ADVANCE(682);
      if (lookahead == '\'') ADVANCE(678);
      if (lookahead == ')') ADVANCE(789);
      if (lookahead == '?') ADVANCE(607);
      if (lookahead == '\\') ADVANCE(396);
      if (lookahead == '`') ADVANCE(676);
      if (lookahead != 0) ADVANCE(702);
      END_STATE();
    case 701:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(702);
      if (lookahead == '"') ADVANCE(701);
      if (lookahead == '\'') ADVANCE(701);
      if (lookahead == '(') ADVANCE(702);
      if (lookahead == ')') ADVANCE(789);
      if (lookahead == ',') ADVANCE(702);
      if (lookahead == '?') ADVANCE(606);
      if (lookahead == '\\') ADVANCE(524);
      if (lookahead == '`') ADVANCE(701);
      if (lookahead != 0) ADVANCE(701);
      END_STATE();
    case 702:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(702);
      if (lookahead == '"') ADVANCE(702);
      if (lookahead == '\'') ADVANCE(702);
      if (lookahead == ')') ADVANCE(789);
      if (lookahead == '?') ADVANCE(607);
      if (lookahead == '\\') ADVANCE(396);
      if (lookahead == '`') ADVANCE(702);
      if (lookahead != 0) ADVANCE(702);
      END_STATE();
    case 703:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(703);
      if (lookahead == '"') ADVANCE(703);
      if (lookahead == '\'') ADVANCE(703);
      if (lookahead == ')') ADVANCE(787);
      if (lookahead == '?') ADVANCE(700);
      if (lookahead == '\\') ADVANCE(518);
      if (lookahead == '`') ADVANCE(703);
      if (lookahead != 0) ADVANCE(703);
      END_STATE();
    case 704:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(705);
      if (lookahead == '"') ADVANCE(704);
      if (lookahead == '\'') ADVANCE(704);
      if (lookahead == '(') ADVANCE(703);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == ',') ADVANCE(705);
      if (lookahead == '?') ADVANCE(696);
      if (lookahead == '\\') ADVANCE(415);
      if (lookahead == '`') ADVANCE(704);
      if (lookahead != 0) ADVANCE(704);
      END_STATE();
    case 705:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(705);
      if (lookahead == '"') ADVANCE(705);
      if (lookahead == '\'') ADVANCE(705);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == '?') ADVANCE(697);
      if (lookahead == '\\') ADVANCE(532);
      if (lookahead == '`') ADVANCE(705);
      if (lookahead != 0) ADVANCE(705);
      END_STATE();
    case 706:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(706);
      if (lookahead == '"') ADVANCE(678);
      if (lookahead == '\'') ADVANCE(682);
      if (lookahead == ')') ADVANCE(813);
      if (lookahead == '?') ADVANCE(599);
      if (lookahead == '\\') ADVANCE(397);
      if (lookahead == '`') ADVANCE(706);
      if (lookahead != 0) ADVANCE(706);
      END_STATE();
    case 707:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(706);
      if (lookahead == '"') ADVANCE(679);
      if (lookahead == '\'') ADVANCE(681);
      if (lookahead == '(') ADVANCE(706);
      if (lookahead == ')') ADVANCE(813);
      if (lookahead == ',') ADVANCE(706);
      if (lookahead == '?') ADVANCE(598);
      if (lookahead == '\\') ADVANCE(525);
      if (lookahead == '`') ADVANCE(707);
      if (lookahead != 0) ADVANCE(707);
      END_STATE();
    case 708:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(706);
      if (lookahead == ')') ADVANCE(813);
      if (lookahead == '?') ADVANCE(599);
      if (lookahead == '\\') ADVANCE(397);
      if (lookahead == '`') ADVANCE(543);
      if (lookahead != 0) ADVANCE(706);
      END_STATE();
    case 709:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '"') ADVANCE(772);
      if (lookahead == '\\') ADVANCE(445);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(61);
      if (lookahead != 0) ADVANCE(709);
      END_STATE();
    case 710:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '"') ADVANCE(756);
      if (lookahead == '(') ADVANCE(556);
      if (lookahead == ',') ADVANCE(709);
      if (lookahead == '\\') ADVANCE(467);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(61);
      if (lookahead != 0) ADVANCE(710);
      END_STATE();
    case 711:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '"') ADVANCE(757);
      if (lookahead == '(') ADVANCE(566);
      if (lookahead == ',') ADVANCE(712);
      if (lookahead == '\\') ADVANCE(469);
      if (lookahead == '`') ADVANCE(710);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(63);
      if (lookahead != 0) ADVANCE(711);
      END_STATE();
    case 712:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '"') ADVANCE(767);
      if (lookahead == '\\') ADVANCE(447);
      if (lookahead == '`') ADVANCE(709);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(63);
      if (lookahead != 0) ADVANCE(712);
      END_STATE();
    case 713:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '"') ADVANCE(738);
      if (lookahead == '\'') ADVANCE(709);
      if (lookahead == '\\') ADVANCE(449);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(64);
      if (lookahead != 0) ADVANCE(713);
      END_STATE();
    case 714:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '"') ADVANCE(739);
      if (lookahead == '\'') ADVANCE(710);
      if (lookahead == '(') ADVANCE(574);
      if (lookahead == ',') ADVANCE(713);
      if (lookahead == '\\') ADVANCE(471);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(64);
      if (lookahead != 0) ADVANCE(714);
      END_STATE();
    case 715:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '"') ADVANCE(740);
      if (lookahead == '\'') ADVANCE(711);
      if (lookahead == '(') ADVANCE(582);
      if (lookahead == ',') ADVANCE(716);
      if (lookahead == '\\') ADVANCE(472);
      if (lookahead == '`') ADVANCE(714);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(69);
      if (lookahead != 0) ADVANCE(715);
      END_STATE();
    case 716:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '"') ADVANCE(741);
      if (lookahead == '\'') ADVANCE(712);
      if (lookahead == '\\') ADVANCE(450);
      if (lookahead == '`') ADVANCE(713);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(69);
      if (lookahead != 0) ADVANCE(716);
      END_STATE();
    case 717:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '"') ADVANCE(375);
      if (lookahead == '\\') ADVANCE(260);
      if (lookahead != 0) ADVANCE(61);
      END_STATE();
    case 718:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '"') ADVANCE(764);
      if (lookahead == '?') ADVANCE(60);
      if (lookahead == '\\') ADVANCE(17);
      if (lookahead != 0) ADVANCE(62);
      END_STATE();
    case 719:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '"') ADVANCE(766);
      if (lookahead == '\\') ADVANCE(262);
      if (lookahead == '`') ADVANCE(824);
      if (lookahead != 0) ADVANCE(63);
      END_STATE();
    case 720:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '"') ADVANCE(742);
      if (lookahead == '\'') ADVANCE(717);
      if (lookahead == '\\') ADVANCE(264);
      if (lookahead != 0) ADVANCE(64);
      END_STATE();
    case 721:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '"') ADVANCE(759);
      if (lookahead == ')') ADVANCE(780);
      if (lookahead == '\\') ADVANCE(25);
      if (lookahead != 0) ADVANCE(65);
      END_STATE();
    case 722:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '"') ADVANCE(743);
      if (lookahead == '\'') ADVANCE(718);
      if (lookahead == '?') ADVANCE(85);
      if (lookahead == '\\') ADVANCE(19);
      if (lookahead != 0) ADVANCE(66);
      END_STATE();
    case 723:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '"') ADVANCE(765);
      if (lookahead == '?') ADVANCE(86);
      if (lookahead == '\\') ADVANCE(20);
      if (lookahead == '`') ADVANCE(718);
      if (lookahead != 0) ADVANCE(67);
      END_STATE();
    case 724:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '"') ADVANCE(771);
      if (lookahead == '\\') ADVANCE(1);
      if (lookahead == ']') ADVANCE(834);
      if (lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '[') ADVANCE(61);
      if (lookahead != 0) ADVANCE(68);
      END_STATE();
    case 725:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '"') ADVANCE(760);
      if (lookahead == ')') ADVANCE(782);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == '`') ADVANCE(826);
      if (lookahead != 0) ADVANCE(70);
      END_STATE();
    case 726:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '"') ADVANCE(762);
      if (lookahead == ',') ADVANCE(45);
      if (lookahead == '\\') ADVANCE(9);
      if (lookahead == '}') ADVANCE(814);
      if (lookahead == '(' ||
          lookahead == ')' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(61);
      if (lookahead != 0) ADVANCE(71);
      END_STATE();
    case 727:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '"') ADVANCE(745);
      if (lookahead == '\'') ADVANCE(721);
      if (lookahead == ')') ADVANCE(783);
      if (lookahead == '\\') ADVANCE(29);
      if (lookahead != 0) ADVANCE(72);
      END_STATE();
    case 728:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '"') ADVANCE(747);
      if (lookahead == '\'') ADVANCE(724);
      if (lookahead == '\\') ADVANCE(4);
      if (lookahead == ']') ADVANCE(835);
      if (lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '[') ADVANCE(64);
      if (lookahead != 0) ADVANCE(74);
      END_STATE();
    case 729:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '"') ADVANCE(768);
      if (lookahead == '\\') ADVANCE(5);
      if (lookahead == ']') ADVANCE(836);
      if (lookahead == '`') ADVANCE(724);
      if (lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '[') ADVANCE(81);
      if (lookahead != 0) ADVANCE(75);
      END_STATE();
    case 730:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '"') ADVANCE(749);
      if (lookahead == '\'') ADVANCE(726);
      if (lookahead == ',') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(12);
      if (lookahead == '}') ADVANCE(815);
      if (lookahead == '(' ||
          lookahead == ')' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(64);
      if (lookahead != 0) ADVANCE(77);
      END_STATE();
    case 731:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '"') ADVANCE(763);
      if (lookahead == ',') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '`') ADVANCE(726);
      if (lookahead == '}') ADVANCE(816);
      if (lookahead == '(' ||
          lookahead == ')' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(81);
      if (lookahead != 0) ADVANCE(78);
      END_STATE();
    case 732:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '"') ADVANCE(758);
      if (lookahead == '(') ADVANCE(603);
      if (lookahead == ',') ADVANCE(733);
      if (lookahead == '\\') ADVANCE(474);
      if (lookahead == '`') ADVANCE(710);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(81);
      if (lookahead != 0) ADVANCE(732);
      END_STATE();
    case 733:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '"') ADVANCE(770);
      if (lookahead == '\\') ADVANCE(452);
      if (lookahead == '`') ADVANCE(709);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(81);
      if (lookahead != 0) ADVANCE(733);
      END_STATE();
    case 734:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '"') ADVANCE(752);
      if (lookahead == '\'') ADVANCE(732);
      if (lookahead == '(') ADVANCE(607);
      if (lookahead == ',') ADVANCE(735);
      if (lookahead == '\\') ADVANCE(476);
      if (lookahead == '`') ADVANCE(714);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(82);
      if (lookahead != 0) ADVANCE(734);
      END_STATE();
    case 735:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '"') ADVANCE(753);
      if (lookahead == '\'') ADVANCE(733);
      if (lookahead == '\\') ADVANCE(454);
      if (lookahead == '`') ADVANCE(713);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(82);
      if (lookahead != 0) ADVANCE(735);
      END_STATE();
    case 736:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '"') ADVANCE(769);
      if (lookahead == '\\') ADVANCE(269);
      if (lookahead == '`') ADVANCE(717);
      if (lookahead != 0) ADVANCE(81);
      END_STATE();
    case 737:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '"') ADVANCE(761);
      if (lookahead == ')') ADVANCE(788);
      if (lookahead == '\\') ADVANCE(32);
      if (lookahead == '`') ADVANCE(721);
      if (lookahead != 0) ADVANCE(83);
      END_STATE();
    case 738:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\'') ADVANCE(772);
      if (lookahead == '\\') ADVANCE(446);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(92);
      if (lookahead != 0) ADVANCE(738);
      END_STATE();
    case 739:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\'') ADVANCE(756);
      if (lookahead == '(') ADVANCE(558);
      if (lookahead == ',') ADVANCE(738);
      if (lookahead == '\\') ADVANCE(468);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(92);
      if (lookahead != 0) ADVANCE(739);
      END_STATE();
    case 740:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\'') ADVANCE(757);
      if (lookahead == '(') ADVANCE(567);
      if (lookahead == ',') ADVANCE(741);
      if (lookahead == '\\') ADVANCE(470);
      if (lookahead == '`') ADVANCE(739);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(94);
      if (lookahead != 0) ADVANCE(740);
      END_STATE();
    case 741:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\'') ADVANCE(767);
      if (lookahead == '\\') ADVANCE(448);
      if (lookahead == '`') ADVANCE(738);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(94);
      if (lookahead != 0) ADVANCE(741);
      END_STATE();
    case 742:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\'') ADVANCE(375);
      if (lookahead == '\\') ADVANCE(261);
      if (lookahead != 0) ADVANCE(92);
      END_STATE();
    case 743:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\'') ADVANCE(764);
      if (lookahead == '?') ADVANCE(91);
      if (lookahead == '\\') ADVANCE(18);
      if (lookahead != 0) ADVANCE(93);
      END_STATE();
    case 744:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\'') ADVANCE(766);
      if (lookahead == '\\') ADVANCE(263);
      if (lookahead == '`') ADVANCE(828);
      if (lookahead != 0) ADVANCE(94);
      END_STATE();
    case 745:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\'') ADVANCE(759);
      if (lookahead == ')') ADVANCE(790);
      if (lookahead == '\\') ADVANCE(26);
      if (lookahead != 0) ADVANCE(95);
      END_STATE();
    case 746:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\'') ADVANCE(765);
      if (lookahead == '?') ADVANCE(104);
      if (lookahead == '\\') ADVANCE(21);
      if (lookahead == '`') ADVANCE(743);
      if (lookahead != 0) ADVANCE(96);
      END_STATE();
    case 747:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\'') ADVANCE(771);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == ']') ADVANCE(838);
      if (lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '[') ADVANCE(92);
      if (lookahead != 0) ADVANCE(97);
      END_STATE();
    case 748:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\'') ADVANCE(760);
      if (lookahead == ')') ADVANCE(792);
      if (lookahead == '\\') ADVANCE(28);
      if (lookahead == '`') ADVANCE(829);
      if (lookahead != 0) ADVANCE(98);
      END_STATE();
    case 749:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\'') ADVANCE(762);
      if (lookahead == ',') ADVANCE(46);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '}') ADVANCE(818);
      if (lookahead == '(' ||
          lookahead == ')' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(92);
      if (lookahead != 0) ADVANCE(99);
      END_STATE();
    case 750:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\'') ADVANCE(768);
      if (lookahead == '\\') ADVANCE(6);
      if (lookahead == ']') ADVANCE(839);
      if (lookahead == '`') ADVANCE(747);
      if (lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '[') ADVANCE(102);
      if (lookahead != 0) ADVANCE(100);
      END_STATE();
    case 751:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\'') ADVANCE(763);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == '`') ADVANCE(749);
      if (lookahead == '}') ADVANCE(819);
      if (lookahead == '(' ||
          lookahead == ')' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(102);
      if (lookahead != 0) ADVANCE(101);
      END_STATE();
    case 752:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\'') ADVANCE(758);
      if (lookahead == '(') ADVANCE(605);
      if (lookahead == ',') ADVANCE(753);
      if (lookahead == '\\') ADVANCE(475);
      if (lookahead == '`') ADVANCE(739);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(102);
      if (lookahead != 0) ADVANCE(752);
      END_STATE();
    case 753:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\'') ADVANCE(770);
      if (lookahead == '\\') ADVANCE(453);
      if (lookahead == '`') ADVANCE(738);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(102);
      if (lookahead != 0) ADVANCE(753);
      END_STATE();
    case 754:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\'') ADVANCE(769);
      if (lookahead == '\\') ADVANCE(270);
      if (lookahead == '`') ADVANCE(742);
      if (lookahead != 0) ADVANCE(102);
      END_STATE();
    case 755:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\'') ADVANCE(761);
      if (lookahead == ')') ADVANCE(794);
      if (lookahead == '\\') ADVANCE(33);
      if (lookahead == '`') ADVANCE(745);
      if (lookahead != 0) ADVANCE(103);
      END_STATE();
    case 756:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '(') ADVANCE(538);
      if (lookahead == ',') ADVANCE(772);
      if (lookahead != 0 &&
          lookahead != ' ' &&
          lookahead != ')') ADVANCE(756);
      END_STATE();
    case 757:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '(') ADVANCE(553);
      if (lookahead == ',') ADVANCE(767);
      if (lookahead == '\\') ADVANCE(466);
      if (lookahead == '`') ADVANCE(756);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(135);
      if (lookahead != 0) ADVANCE(757);
      END_STATE();
    case 758:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '(') ADVANCE(599);
      if (lookahead == ',') ADVANCE(770);
      if (lookahead == '\\') ADVANCE(473);
      if (lookahead == '`') ADVANCE(756);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(138);
      if (lookahead != 0) ADVANCE(758);
      END_STATE();
    case 759:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ')') ADVANCE(773);
      if (lookahead != 0) ADVANCE(110);
      END_STATE();
    case 760:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ')') ADVANCE(812);
      if (lookahead == '\\') ADVANCE(24);
      if (lookahead == '`') ADVANCE(830);
      if (lookahead != 0) ADVANCE(115);
      END_STATE();
    case 761:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ')') ADVANCE(813);
      if (lookahead == '\\') ADVANCE(31);
      if (lookahead == '`') ADVANCE(759);
      if (lookahead != 0) ADVANCE(117);
      END_STATE();
    case 762:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ',') ADVANCE(43);
      if (lookahead == '}') ADVANCE(820);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(118);
      END_STATE();
    case 763:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ',') ADVANCE(47);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == '`') ADVANCE(762);
      if (lookahead == '}') ADVANCE(822);
      if (lookahead == '(' ||
          lookahead == ')' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(138);
      if (lookahead != 0) ADVANCE(121);
      END_STATE();
    case 764:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '?') ADVANCE(258);
      if (lookahead != 0) ADVANCE(130);
      END_STATE();
    case 765:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '?') ADVANCE(139);
      if (lookahead == '\\') ADVANCE(23);
      if (lookahead == '`') ADVANCE(764);
      if (lookahead != 0) ADVANCE(134);
      END_STATE();
    case 766:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\\') ADVANCE(259);
      if (lookahead == '`') ADVANCE(823);
      if (lookahead != 0) ADVANCE(135);
      END_STATE();
    case 767:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\\') ADVANCE(444);
      if (lookahead == '`') ADVANCE(772);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(135);
      if (lookahead != 0) ADVANCE(767);
      END_STATE();
    case 768:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\\') ADVANCE(3);
      if (lookahead == ']') ADVANCE(841);
      if (lookahead == '`') ADVANCE(771);
      if (lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '[') ADVANCE(138);
      if (lookahead != 0) ADVANCE(137);
      END_STATE();
    case 769:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\\') ADVANCE(268);
      if (lookahead == '`') ADVANCE(375);
      if (lookahead != 0) ADVANCE(138);
      END_STATE();
    case 770:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == '\\') ADVANCE(451);
      if (lookahead == '`') ADVANCE(772);
      if (lookahead == ' ' ||
          lookahead == ')') ADVANCE(138);
      if (lookahead != 0) ADVANCE(770);
      END_STATE();
    case 771:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead == ']') ADVANCE(833);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != '[') ADVANCE(141);
      END_STATE();
    case 772:
      ACCEPT_TOKEN(aux_sym__ternary_attribute_value_token1);
      if (lookahead != 0 &&
          lookahead != ' ' &&
          lookahead != ')') ADVANCE(772);
      END_STATE();
    case 773:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      END_STATE();
    case 774:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(797);
      if (lookahead == '(') ADVANCE(115);
      if (lookahead == ' ' ||
          lookahead == ')' ||
          lookahead == ',') ADVANCE(135);
      if (lookahead != 0) ADVANCE(807);
      END_STATE();
    case 775:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '\n') ADVANCE(801);
      if (lookahead == '(') ADVANCE(113);
      if (lookahead == '?') ADVANCE(806);
      if (lookahead == ' ' ||
          lookahead == ')' ||
          lookahead == ',') ADVANCE(133);
      if (lookahead != 0) ADVANCE(802);
      END_STATE();
    case 776:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(118);
      if (lookahead == '(') ADVANCE(110);
      if (lookahead == ',') ADVANCE(43);
      if (lookahead == '}') ADVANCE(776);
      if (lookahead == '[' ||
          lookahead == ']') ADVANCE(797);
      if (lookahead != 0 &&
          lookahead != ')') ADVANCE(776);
      END_STATE();
    case 777:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(119);
      if (lookahead == '(') ADVANCE(111);
      if (lookahead == ')') ADVANCE(130);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '?') ADVANCE(778);
      if (lookahead == '}') ADVANCE(777);
      if (lookahead == '[' ||
          lookahead == ']') ADVANCE(801);
      if (lookahead != 0) ADVANCE(777);
      END_STATE();
    case 778:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(549);
      if (lookahead == '(') ADVANCE(543);
      if (lookahead == ',') ADVANCE(549);
      if (lookahead == '?') ADVANCE(776);
      if (lookahead == '}') ADVANCE(550);
      if (lookahead == '[' ||
          lookahead == ']') ADVANCE(539);
      if (lookahead != 0 &&
          lookahead != ')') ADVANCE(550);
      END_STATE();
    case 779:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == ' ') ADVANCE(54);
      if (lookahead == '"') ADVANCE(1005);
      if (lookahead == '\'') ADVANCE(1001);
      if (lookahead == '(') ADVANCE(112);
      if (lookahead == ')') ADVANCE(321);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '?') ADVANCE(808);
      if (lookahead == '[') ADVANCE(798);
      if (lookahead == '`') ADVANCE(802);
      if (lookahead == '{') ADVANCE(777);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r') ADVANCE(779);
      if (lookahead != 0) ADVANCE(801);
      END_STATE();
    case 780:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '"') ADVANCE(375);
      if (lookahead == '\\') ADVANCE(260);
      if (lookahead != 0) ADVANCE(61);
      END_STATE();
    case 781:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '"') ADVANCE(764);
      if (lookahead == '?') ADVANCE(60);
      if (lookahead == '\\') ADVANCE(17);
      if (lookahead != 0) ADVANCE(62);
      END_STATE();
    case 782:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '"') ADVANCE(766);
      if (lookahead == '\\') ADVANCE(262);
      if (lookahead == '`') ADVANCE(824);
      if (lookahead != 0) ADVANCE(63);
      END_STATE();
    case 783:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '"') ADVANCE(742);
      if (lookahead == '\'') ADVANCE(717);
      if (lookahead == '\\') ADVANCE(264);
      if (lookahead != 0) ADVANCE(64);
      END_STATE();
    case 784:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '"') ADVANCE(743);
      if (lookahead == '\'') ADVANCE(718);
      if (lookahead == '?') ADVANCE(85);
      if (lookahead == '\\') ADVANCE(19);
      if (lookahead != 0) ADVANCE(66);
      END_STATE();
    case 785:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '"') ADVANCE(765);
      if (lookahead == '?') ADVANCE(86);
      if (lookahead == '\\') ADVANCE(20);
      if (lookahead == '`') ADVANCE(718);
      if (lookahead != 0) ADVANCE(67);
      END_STATE();
    case 786:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '"') ADVANCE(744);
      if (lookahead == '\'') ADVANCE(719);
      if (lookahead == '\\') ADVANCE(265);
      if (lookahead == '`') ADVANCE(825);
      if (lookahead != 0) ADVANCE(69);
      END_STATE();
    case 787:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '"') ADVANCE(746);
      if (lookahead == '\'') ADVANCE(723);
      if (lookahead == '?') ADVANCE(87);
      if (lookahead == '\\') ADVANCE(22);
      if (lookahead == '`') ADVANCE(722);
      if (lookahead != 0) ADVANCE(73);
      END_STATE();
    case 788:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '"') ADVANCE(769);
      if (lookahead == '\\') ADVANCE(269);
      if (lookahead == '`') ADVANCE(717);
      if (lookahead != 0) ADVANCE(81);
      END_STATE();
    case 789:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '"') ADVANCE(754);
      if (lookahead == '\'') ADVANCE(736);
      if (lookahead == '\\') ADVANCE(271);
      if (lookahead == '`') ADVANCE(720);
      if (lookahead != 0) ADVANCE(82);
      END_STATE();
    case 790:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '\'') ADVANCE(375);
      if (lookahead == '\\') ADVANCE(261);
      if (lookahead != 0) ADVANCE(92);
      END_STATE();
    case 791:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '\'') ADVANCE(764);
      if (lookahead == '?') ADVANCE(91);
      if (lookahead == '\\') ADVANCE(18);
      if (lookahead != 0) ADVANCE(93);
      END_STATE();
    case 792:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '\'') ADVANCE(766);
      if (lookahead == '\\') ADVANCE(263);
      if (lookahead == '`') ADVANCE(828);
      if (lookahead != 0) ADVANCE(94);
      END_STATE();
    case 793:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '\'') ADVANCE(765);
      if (lookahead == '?') ADVANCE(104);
      if (lookahead == '\\') ADVANCE(21);
      if (lookahead == '`') ADVANCE(743);
      if (lookahead != 0) ADVANCE(96);
      END_STATE();
    case 794:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '\'') ADVANCE(769);
      if (lookahead == '\\') ADVANCE(270);
      if (lookahead == '`') ADVANCE(742);
      if (lookahead != 0) ADVANCE(102);
      END_STATE();
    case 795:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '(') ADVANCE(110);
      if (lookahead == ')') ADVANCE(773);
      if (lookahead == ' ' ||
          lookahead == ',') ADVANCE(110);
      if (lookahead != 0) ADVANCE(795);
      END_STATE();
    case 796:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '(') ADVANCE(110);
      if (lookahead == '[') ADVANCE(797);
      if (lookahead == ']') ADVANCE(797);
      if (lookahead == ' ' ||
          lookahead == ',') ADVANCE(141);
      if (lookahead != 0 &&
          lookahead != ')') ADVANCE(796);
      END_STATE();
    case 797:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '(') ADVANCE(110);
      if (lookahead != 0 &&
          lookahead != ' ' &&
          lookahead != ')' &&
          lookahead != ',') ADVANCE(797);
      END_STATE();
    case 798:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '(') ADVANCE(111);
      if (lookahead == ')') ADVANCE(130);
      if (lookahead == '?') ADVANCE(805);
      if (lookahead == '[') ADVANCE(801);
      if (lookahead == ']') ADVANCE(801);
      if (lookahead == ' ' ||
          lookahead == ',') ADVANCE(132);
      if (lookahead != 0) ADVANCE(798);
      END_STATE();
    case 799:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '(') ADVANCE(111);
      if (lookahead == ')') ADVANCE(809);
      if (lookahead == '?') ADVANCE(803);
      if (lookahead == ' ' ||
          lookahead == ',') ADVANCE(111);
      if (lookahead != 0) ADVANCE(799);
      END_STATE();
    case 800:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '(') ADVANCE(111);
      if (lookahead == '?') ADVANCE(797);
      if (lookahead == ' ' ||
          lookahead == ')' ||
          lookahead == ',') ADVANCE(130);
      if (lookahead != 0) ADVANCE(801);
      END_STATE();
    case 801:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '(') ADVANCE(111);
      if (lookahead == '?') ADVANCE(804);
      if (lookahead == ' ' ||
          lookahead == ')' ||
          lookahead == ',') ADVANCE(130);
      if (lookahead != 0) ADVANCE(801);
      END_STATE();
    case 802:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '(') ADVANCE(113);
      if (lookahead == '?') ADVANCE(806);
      if (lookahead == '\\') ADVANCE(775);
      if (lookahead == '`') ADVANCE(801);
      if (lookahead == ' ' ||
          lookahead == ')' ||
          lookahead == ',') ADVANCE(133);
      if (lookahead != 0) ADVANCE(802);
      END_STATE();
    case 803:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '(') ADVANCE(543);
      if (lookahead == ')') ADVANCE(773);
      if (lookahead == '?') ADVANCE(795);
      if (lookahead == ' ' ||
          lookahead == ',') ADVANCE(543);
      if (lookahead != 0) ADVANCE(544);
      END_STATE();
    case 804:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '(') ADVANCE(543);
      if (lookahead == '?') ADVANCE(797);
      if (lookahead == ' ' ||
          lookahead == ',') ADVANCE(540);
      if (lookahead != 0 &&
          lookahead != ')') ADVANCE(539);
      END_STATE();
    case 805:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '(') ADVANCE(543);
      if (lookahead == '?') ADVANCE(796);
      if (lookahead == '[') ADVANCE(539);
      if (lookahead == ']') ADVANCE(539);
      if (lookahead == ' ' ||
          lookahead == ',') ADVANCE(546);
      if (lookahead != 0 &&
          lookahead != ')') ADVANCE(547);
      END_STATE();
    case 806:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '(') ADVANCE(548);
      if (lookahead == ')') ADVANCE(135);
      if (lookahead == '?') ADVANCE(807);
      if (lookahead == '\\') ADVANCE(398);
      if (lookahead == '`') ADVANCE(539);
      if (lookahead == ' ' ||
          lookahead == ',') ADVANCE(595);
      if (lookahead != 0) ADVANCE(594);
      END_STATE();
    case 807:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '(') ADVANCE(115);
      if (lookahead == '\\') ADVANCE(774);
      if (lookahead == '`') ADVANCE(797);
      if (lookahead == ' ' ||
          lookahead == ')' ||
          lookahead == ',') ADVANCE(135);
      if (lookahead != 0) ADVANCE(807);
      END_STATE();
    case 808:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '(') ADVANCE(593);
      if (lookahead == ')') ADVANCE(130);
      if (lookahead == '?') ADVANCE(797);
      if (lookahead == ' ' ||
          lookahead == ',') ADVANCE(609);
      if (lookahead != 0) ADVANCE(608);
      END_STATE();
    case 809:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '?') ADVANCE(258);
      if (lookahead != 0) ADVANCE(130);
      END_STATE();
    case 810:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '?') ADVANCE(136);
      if (lookahead == '\\') ADVANCE(16);
      if (lookahead == '`') ADVANCE(832);
      if (lookahead != 0) ADVANCE(133);
      END_STATE();
    case 811:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '?') ADVANCE(139);
      if (lookahead == '\\') ADVANCE(23);
      if (lookahead == '`') ADVANCE(764);
      if (lookahead != 0) ADVANCE(134);
      END_STATE();
    case 812:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '\\') ADVANCE(259);
      if (lookahead == '`') ADVANCE(823);
      if (lookahead != 0) ADVANCE(135);
      END_STATE();
    case 813:
      ACCEPT_TOKEN(aux_sym__variable_attribute_value_token1);
      if (lookahead == '\\') ADVANCE(268);
      if (lookahead == '`') ADVANCE(375);
      if (lookahead != 0) ADVANCE(138);
      END_STATE();
    case 814:
      ACCEPT_TOKEN(aux_sym__object_attribute_value_token1);
      if (lookahead == '"') ADVANCE(762);
      if (lookahead == ',') ADVANCE(45);
      if (lookahead == '\\') ADVANCE(9);
      if (lookahead == '}') ADVANCE(814);
      if (lookahead == '(' ||
          lookahead == ')' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(61);
      if (lookahead != 0) ADVANCE(71);
      END_STATE();
    case 815:
      ACCEPT_TOKEN(aux_sym__object_attribute_value_token1);
      if (lookahead == '"') ADVANCE(749);
      if (lookahead == '\'') ADVANCE(726);
      if (lookahead == ',') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(12);
      if (lookahead == '}') ADVANCE(815);
      if (lookahead == '(' ||
          lookahead == ')' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(64);
      if (lookahead != 0) ADVANCE(77);
      END_STATE();
    case 816:
      ACCEPT_TOKEN(aux_sym__object_attribute_value_token1);
      if (lookahead == '"') ADVANCE(763);
      if (lookahead == ',') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '`') ADVANCE(726);
      if (lookahead == '}') ADVANCE(816);
      if (lookahead == '(' ||
          lookahead == ')' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(81);
      if (lookahead != 0) ADVANCE(78);
      END_STATE();
    case 817:
      ACCEPT_TOKEN(aux_sym__object_attribute_value_token1);
      if (lookahead == '"') ADVANCE(751);
      if (lookahead == '\'') ADVANCE(731);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '\\') ADVANCE(15);
      if (lookahead == '`') ADVANCE(730);
      if (lookahead == '}') ADVANCE(817);
      if (lookahead == '(' ||
          lookahead == ')' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(82);
      if (lookahead != 0) ADVANCE(80);
      END_STATE();
    case 818:
      ACCEPT_TOKEN(aux_sym__object_attribute_value_token1);
      if (lookahead == '\'') ADVANCE(762);
      if (lookahead == ',') ADVANCE(46);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '}') ADVANCE(818);
      if (lookahead == '(' ||
          lookahead == ')' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(92);
      if (lookahead != 0) ADVANCE(99);
      END_STATE();
    case 819:
      ACCEPT_TOKEN(aux_sym__object_attribute_value_token1);
      if (lookahead == '\'') ADVANCE(763);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == '`') ADVANCE(749);
      if (lookahead == '}') ADVANCE(819);
      if (lookahead == '(' ||
          lookahead == ')' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(102);
      if (lookahead != 0) ADVANCE(101);
      END_STATE();
    case 820:
      ACCEPT_TOKEN(aux_sym__object_attribute_value_token1);
      if (lookahead == ',') ADVANCE(43);
      if (lookahead == '}') ADVANCE(820);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(118);
      END_STATE();
    case 821:
      ACCEPT_TOKEN(aux_sym__object_attribute_value_token1);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '?') ADVANCE(120);
      if (lookahead == '}') ADVANCE(821);
      if (lookahead == '(' ||
          lookahead == ')' ||
          lookahead == '[' ||
          lookahead == ']') ADVANCE(130);
      if (lookahead != 0) ADVANCE(119);
      END_STATE();
    case 822:
      ACCEPT_TOKEN(aux_sym__object_attribute_value_token1);
      if (lookahead == ',') ADVANCE(47);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == '`') ADVANCE(762);
      if (lookahead == '}') ADVANCE(822);
      if (lookahead == '(' ||
          lookahead == ')' ||
          ('[' <= lookahead && lookahead <= ']')) ADVANCE(138);
      if (lookahead != 0) ADVANCE(121);
      END_STATE();
    case 823:
      ACCEPT_TOKEN(aux_sym__template_attribute_value_token1);
      END_STATE();
    case 824:
      ACCEPT_TOKEN(aux_sym__template_attribute_value_token1);
      if (lookahead == '"') ADVANCE(375);
      if (lookahead == '\\') ADVANCE(260);
      if (lookahead != 0) ADVANCE(61);
      END_STATE();
    case 825:
      ACCEPT_TOKEN(aux_sym__template_attribute_value_token1);
      if (lookahead == '"') ADVANCE(742);
      if (lookahead == '\'') ADVANCE(717);
      if (lookahead == '\\') ADVANCE(264);
      if (lookahead != 0) ADVANCE(64);
      END_STATE();
    case 826:
      ACCEPT_TOKEN(aux_sym__template_attribute_value_token1);
      if (lookahead == '"') ADVANCE(759);
      if (lookahead == ')') ADVANCE(780);
      if (lookahead == '\\') ADVANCE(25);
      if (lookahead != 0) ADVANCE(65);
      END_STATE();
    case 827:
      ACCEPT_TOKEN(aux_sym__template_attribute_value_token1);
      if (lookahead == '"') ADVANCE(745);
      if (lookahead == '\'') ADVANCE(721);
      if (lookahead == ')') ADVANCE(783);
      if (lookahead == '\\') ADVANCE(29);
      if (lookahead != 0) ADVANCE(72);
      END_STATE();
    case 828:
      ACCEPT_TOKEN(aux_sym__template_attribute_value_token1);
      if (lookahead == '\'') ADVANCE(375);
      if (lookahead == '\\') ADVANCE(261);
      if (lookahead != 0) ADVANCE(92);
      END_STATE();
    case 829:
      ACCEPT_TOKEN(aux_sym__template_attribute_value_token1);
      if (lookahead == '\'') ADVANCE(759);
      if (lookahead == ')') ADVANCE(790);
      if (lookahead == '\\') ADVANCE(26);
      if (lookahead != 0) ADVANCE(95);
      END_STATE();
    case 830:
      ACCEPT_TOKEN(aux_sym__template_attribute_value_token1);
      if (lookahead == ')') ADVANCE(773);
      if (lookahead != 0) ADVANCE(110);
      END_STATE();
    case 831:
      ACCEPT_TOKEN(aux_sym__template_attribute_value_token1);
      if (lookahead == ')') ADVANCE(809);
      if (lookahead == '?') ADVANCE(109);
      if (lookahead != 0) ADVANCE(111);
      END_STATE();
    case 832:
      ACCEPT_TOKEN(aux_sym__template_attribute_value_token1);
      if (lookahead == '?') ADVANCE(258);
      if (lookahead != 0) ADVANCE(130);
      END_STATE();
    case 833:
      ACCEPT_TOKEN(aux_sym__array_attribute_value_token1);
      END_STATE();
    case 834:
      ACCEPT_TOKEN(aux_sym__array_attribute_value_token1);
      if (lookahead == '"') ADVANCE(375);
      if (lookahead == '\\') ADVANCE(260);
      if (lookahead != 0) ADVANCE(61);
      END_STATE();
    case 835:
      ACCEPT_TOKEN(aux_sym__array_attribute_value_token1);
      if (lookahead == '"') ADVANCE(742);
      if (lookahead == '\'') ADVANCE(717);
      if (lookahead == '\\') ADVANCE(264);
      if (lookahead != 0) ADVANCE(64);
      END_STATE();
    case 836:
      ACCEPT_TOKEN(aux_sym__array_attribute_value_token1);
      if (lookahead == '"') ADVANCE(769);
      if (lookahead == '\\') ADVANCE(269);
      if (lookahead == '`') ADVANCE(717);
      if (lookahead != 0) ADVANCE(81);
      END_STATE();
    case 837:
      ACCEPT_TOKEN(aux_sym__array_attribute_value_token1);
      if (lookahead == '"') ADVANCE(754);
      if (lookahead == '\'') ADVANCE(736);
      if (lookahead == '\\') ADVANCE(271);
      if (lookahead == '`') ADVANCE(720);
      if (lookahead != 0) ADVANCE(82);
      END_STATE();
    case 838:
      ACCEPT_TOKEN(aux_sym__array_attribute_value_token1);
      if (lookahead == '\'') ADVANCE(375);
      if (lookahead == '\\') ADVANCE(261);
      if (lookahead != 0) ADVANCE(92);
      END_STATE();
    case 839:
      ACCEPT_TOKEN(aux_sym__array_attribute_value_token1);
      if (lookahead == '\'') ADVANCE(769);
      if (lookahead == '\\') ADVANCE(270);
      if (lookahead == '`') ADVANCE(742);
      if (lookahead != 0) ADVANCE(102);
      END_STATE();
    case 840:
      ACCEPT_TOKEN(aux_sym__array_attribute_value_token1);
      if (lookahead == '?') ADVANCE(258);
      if (lookahead != 0) ADVANCE(130);
      END_STATE();
    case 841:
      ACCEPT_TOKEN(aux_sym__array_attribute_value_token1);
      if (lookahead == '\\') ADVANCE(268);
      if (lookahead == '`') ADVANCE(375);
      if (lookahead != 0) ADVANCE(138);
      END_STATE();
    case 842:
      ACCEPT_TOKEN(aux_sym__attribute_token1);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(842);
      END_STATE();
    case 843:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead == '-') ADVANCE(845);
      END_STATE();
    case 844:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead == '-') ADVANCE(846);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 845:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH_DASH);
      END_STATE();
    case 846:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH_DASH);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 847:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == '.') ADVANCE(368);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 848:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'a') ADVANCE(907);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 849:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'a') ADVANCE(914);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 850:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'a') ADVANCE(852);
      if (lookahead == 'l') ADVANCE(908);
      if (lookahead == 'x') ADVANCE(912);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 851:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'c') ADVANCE(881);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 852:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'c') ADVANCE(874);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 853:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'c') ADVANCE(909);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 854:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'c') ADVANCE(882);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 855:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'c') ADVANCE(903);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 856:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'd') ADVANCE(330);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 857:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'd') ADVANCE(333);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 858:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'd') ADVANCE(905);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 859:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'd') ADVANCE(864);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 860:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'e') ADVANCE(354);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 861:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'e') ADVANCE(307);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 862:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'e') ADVANCE(301);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 863:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'e') ADVANCE(280);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 864:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'e') ADVANCE(293);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 865:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'e') ADVANCE(873);
      if (lookahead == 'o') ADVANCE(853);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 866:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'e') ADVANCE(887);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 867:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'e') ADVANCE(906);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 868:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'e') ADVANCE(891);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 869:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'e') ADVANCE(892);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 870:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'e') ADVANCE(889);
      if (lookahead == 'i') ADVANCE(885);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 871:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'e') ADVANCE(899);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 872:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'f') ADVANCE(349);
      if (lookahead == 'n') ADVANCE(854);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 873:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'f') ADVANCE(849);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 874:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'h') ADVANCE(309);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 875:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'h') ADVANCE(870);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 876:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'h') ADVANCE(880);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 877:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'i') ADVANCE(915);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 878:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'i') ADVANCE(898);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 879:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'i') ADVANCE(888);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 880:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'i') ADVANCE(885);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 881:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'k') ADVANCE(327);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 882:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'l') ADVANCE(913);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 883:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'l') ADVANCE(911);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 884:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'l') ADVANCE(867);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 885:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'l') ADVANCE(862);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 886:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'l') ADVANCE(895);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 887:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'n') ADVANCE(856);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 888:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'n') ADVANCE(323);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 889:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'n') ADVANCE(357);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 890:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'n') ADVANCE(884);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 891:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'n') ADVANCE(858);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 892:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'n') ADVANCE(857);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 893:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'o') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 894:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'o') ADVANCE(853);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 895:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'o') ADVANCE(851);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 896:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'p') ADVANCE(897);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 897:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'p') ADVANCE(866);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 898:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'p') ADVANCE(910);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 899:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'p') ADVANCE(869);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 900:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'p') ADVANCE(863);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 901:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'r') ADVANCE(871);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 902:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'r') ADVANCE(312);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 903:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'r') ADVANCE(878);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 904:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 's') ADVANCE(346);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 905:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 's') ADVANCE(336);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 906:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 's') ADVANCE(904);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 907:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 's') ADVANCE(860);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 908:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 's') ADVANCE(861);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 909:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 't') ADVANCE(916);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 910:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 't') ADVANCE(847);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 911:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 't') ADVANCE(362);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 912:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 't') ADVANCE(868);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 913:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'u') ADVANCE(859);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 914:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'u') ADVANCE(883);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 915:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'x') ADVANCE(879);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 916:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == 'y') ADVANCE(900);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 917:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(917);
      END_STATE();
    case 918:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == '.') ADVANCE(369);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 919:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'a') ADVANCE(978);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 920:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'a') ADVANCE(985);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 921:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'a') ADVANCE(923);
      if (lookahead == 'l') ADVANCE(979);
      if (lookahead == 'x') ADVANCE(983);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 922:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'c') ADVANCE(952);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 923:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'c') ADVANCE(946);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 924:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'c') ADVANCE(980);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 925:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'c') ADVANCE(954);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 926:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'c') ADVANCE(974);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 927:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'd') ADVANCE(331);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 928:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'd') ADVANCE(334);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 929:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'd') ADVANCE(976);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 930:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'd') ADVANCE(936);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 931:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'e') ADVANCE(944);
      if (lookahead == 'o') ADVANCE(924);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 932:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'e') ADVANCE(355);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 933:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'e') ADVANCE(305);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 934:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'e') ADVANCE(302);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 935:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'e') ADVANCE(281);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 936:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'e') ADVANCE(294);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 937:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'e') ADVANCE(958);
      if (lookahead == 'i') ADVANCE(957);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 938:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'e') ADVANCE(977);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 939:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'e') ADVANCE(959);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 940:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'e') ADVANCE(962);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 941:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'e') ADVANCE(963);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 942:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'e') ADVANCE(971);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 943:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'f') ADVANCE(350);
      if (lookahead == 'n') ADVANCE(925);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 944:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'f') ADVANCE(920);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 945:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'h') ADVANCE(937);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 946:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'h') ADVANCE(310);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 947:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'h') ADVANCE(951);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 948:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'i') ADVANCE(986);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 949:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'i') ADVANCE(969);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 950:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'i') ADVANCE(960);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 951:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'i') ADVANCE(957);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 952:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'k') ADVANCE(328);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 953:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'l') ADVANCE(966);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 954:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'l') ADVANCE(984);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 955:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'l') ADVANCE(982);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 956:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'l') ADVANCE(938);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 957:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'l') ADVANCE(934);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 958:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'n') ADVANCE(358);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 959:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'n') ADVANCE(927);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 960:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'n') ADVANCE(324);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 961:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'n') ADVANCE(956);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 962:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'n') ADVANCE(929);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 963:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'n') ADVANCE(928);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 964:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'o') ADVANCE(973);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 965:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'o') ADVANCE(924);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 966:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'o') ADVANCE(922);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 967:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'p') ADVANCE(968);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 968:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'p') ADVANCE(939);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 969:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'p') ADVANCE(981);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 970:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'p') ADVANCE(935);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 971:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'p') ADVANCE(941);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 972:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'r') ADVANCE(942);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 973:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'r') ADVANCE(313);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 974:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'r') ADVANCE(949);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 975:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 's') ADVANCE(347);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 976:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 's') ADVANCE(337);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 977:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 's') ADVANCE(975);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 978:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 's') ADVANCE(932);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 979:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 's') ADVANCE(933);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 980:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 't') ADVANCE(987);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 981:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 't') ADVANCE(918);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 982:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 't') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 983:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 't') ADVANCE(940);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 984:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'u') ADVANCE(930);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 985:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'u') ADVANCE(955);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 986:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'x') ADVANCE(950);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 987:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (lookahead == 'y') ADVANCE(970);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 988:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-') ADVANCE(1022);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 989:
      ACCEPT_TOKEN(sym_class);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(989);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(991);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(989);
      END_STATE();
    case 990:
      ACCEPT_TOKEN(sym_class);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(990);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(992);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(990);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 991:
      ACCEPT_TOKEN(sym_class);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(991);
      END_STATE();
    case 992:
      ACCEPT_TOKEN(sym_class);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(992);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 993:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(993);
      END_STATE();
    case 994:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(994);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 995:
      ACCEPT_TOKEN(aux_sym_angular_attribute_name_token1);
      END_STATE();
    case 996:
      ACCEPT_TOKEN(aux_sym_angular_attribute_name_token2);
      END_STATE();
    case 997:
      ACCEPT_TOKEN(aux_sym_angular_attribute_name_token3);
      END_STATE();
    case 998:
      ACCEPT_TOKEN(aux_sym_angular_attribute_name_token4);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(998);
      END_STATE();
    case 999:
      ACCEPT_TOKEN(sym_attribute_name);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(999);
      END_STATE();
    case 1000:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 1001:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      if (lookahead == '(') ADVANCE(111);
      if (lookahead == '?') ADVANCE(804);
      if (lookahead == ' ' ||
          lookahead == ')' ||
          lookahead == ',') ADVANCE(130);
      if (lookahead != 0) ADVANCE(801);
      END_STATE();
    case 1002:
      ACCEPT_TOKEN(aux_sym_quoted_javascript_token1);
      if (lookahead == '\\') ADVANCE(267);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(1003);
      END_STATE();
    case 1003:
      ACCEPT_TOKEN(aux_sym_quoted_javascript_token1);
      if (lookahead == '\\') ADVANCE(267);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(1003);
      END_STATE();
    case 1004:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 1005:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      if (lookahead == '(') ADVANCE(111);
      if (lookahead == '?') ADVANCE(804);
      if (lookahead == ' ' ||
          lookahead == ')' ||
          lookahead == ',') ADVANCE(130);
      if (lookahead != 0) ADVANCE(801);
      END_STATE();
    case 1006:
      ACCEPT_TOKEN(aux_sym_quoted_javascript_token2);
      if (lookahead == '\\') ADVANCE(266);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(1006);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(1007);
      END_STATE();
    case 1007:
      ACCEPT_TOKEN(aux_sym_quoted_javascript_token2);
      if (lookahead == '\\') ADVANCE(266);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(1007);
      END_STATE();
    case 1008:
      ACCEPT_TOKEN(aux_sym_content_token1);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(1008);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '#' &&
          lookahead != '{') ADVANCE(1009);
      END_STATE();
    case 1009:
      ACCEPT_TOKEN(aux_sym_content_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '#' &&
          lookahead != '{') ADVANCE(1009);
      END_STATE();
    case 1010:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '{') ADVANCE(1012);
      END_STATE();
    case 1011:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead == '{') ADVANCE(1014);
      END_STATE();
    case 1012:
      ACCEPT_TOKEN(anon_sym_POUND_LBRACE);
      END_STATE();
    case 1013:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 1014:
      ACCEPT_TOKEN(anon_sym_LBRACE_LBRACE);
      END_STATE();
    case 1015:
      ACCEPT_TOKEN(anon_sym_RBRACE_RBRACE);
      END_STATE();
    case 1016:
      ACCEPT_TOKEN(sym__delimited_javascript);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(1016);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '}') ADVANCE(1017);
      END_STATE();
    case 1017:
      ACCEPT_TOKEN(sym__delimited_javascript);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '}') ADVANCE(1017);
      END_STATE();
    case 1018:
      ACCEPT_TOKEN(sym__un_delimited_javascript_line);
      if (lookahead == '!') ADVANCE(1024);
      if (lookahead == '#') ADVANCE(1029);
      if (lookahead == '+') ADVANCE(316);
      if (lookahead == '-') ADVANCE(1032);
      if (lookahead == '.') ADVANCE(1028);
      if (lookahead == '/') ADVANCE(1023);
      if (lookahead == ':') ADVANCE(339);
      if (lookahead == '=') ADVANCE(367);
      if (lookahead == 'a') ADVANCE(967);
      if (lookahead == 'b') ADVANCE(953);
      if (lookahead == 'c') ADVANCE(919);
      if (lookahead == 'd') ADVANCE(931);
      if (lookahead == 'e') ADVANCE(921);
      if (lookahead == 'f') ADVANCE(964);
      if (lookahead == 'i') ADVANCE(943);
      if (lookahead == 'm') ADVANCE(948);
      if (lookahead == 'p') ADVANCE(972);
      if (lookahead == 's') ADVANCE(926);
      if (lookahead == 'u') ADVANCE(961);
      if (lookahead == 'w') ADVANCE(945);
      if (lookahead == '|') ADVANCE(292);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(1018);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 1019:
      ACCEPT_TOKEN(sym__un_delimited_javascript_line);
      if (lookahead == '!') ADVANCE(1024);
      if (lookahead == '#') ADVANCE(1029);
      if (lookahead == '+') ADVANCE(316);
      if (lookahead == '-') ADVANCE(1032);
      if (lookahead == '.') ADVANCE(1028);
      if (lookahead == '/') ADVANCE(1023);
      if (lookahead == ':') ADVANCE(339);
      if (lookahead == '=') ADVANCE(367);
      if (lookahead == 'a') ADVANCE(967);
      if (lookahead == 'b') ADVANCE(953);
      if (lookahead == 'c') ADVANCE(919);
      if (lookahead == 'd') ADVANCE(965);
      if (lookahead == 'e') ADVANCE(921);
      if (lookahead == 'f') ADVANCE(964);
      if (lookahead == 'i') ADVANCE(943);
      if (lookahead == 'm') ADVANCE(948);
      if (lookahead == 'p') ADVANCE(972);
      if (lookahead == 's') ADVANCE(926);
      if (lookahead == 'u') ADVANCE(961);
      if (lookahead == 'w') ADVANCE(947);
      if (lookahead == '|') ADVANCE(292);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(1019);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 1020:
      ACCEPT_TOKEN(sym__un_delimited_javascript_line);
      if (lookahead == '!') ADVANCE(1024);
      if (lookahead == '#') ADVANCE(1029);
      if (lookahead == '-') ADVANCE(1032);
      if (lookahead == '.') ADVANCE(1028);
      if (lookahead == '/') ADVANCE(1023);
      if (lookahead == ':') ADVANCE(339);
      if (lookahead == '=') ADVANCE(367);
      if (lookahead == 'a') ADVANCE(967);
      if (lookahead == 'b') ADVANCE(953);
      if (lookahead == 'c') ADVANCE(919);
      if (lookahead == 'd') ADVANCE(931);
      if (lookahead == 'e') ADVANCE(921);
      if (lookahead == 'f') ADVANCE(964);
      if (lookahead == 'i') ADVANCE(943);
      if (lookahead == 'p') ADVANCE(972);
      if (lookahead == 's') ADVANCE(926);
      if (lookahead == 'u') ADVANCE(961);
      if (lookahead == 'w') ADVANCE(945);
      if (lookahead == '|') ADVANCE(292);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(1020);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 1021:
      ACCEPT_TOKEN(sym__un_delimited_javascript_line);
      if (lookahead == '!') ADVANCE(1024);
      if (lookahead == '#') ADVANCE(1029);
      if (lookahead == '-') ADVANCE(1032);
      if (lookahead == '.') ADVANCE(1028);
      if (lookahead == '/') ADVANCE(1023);
      if (lookahead == ':') ADVANCE(339);
      if (lookahead == '=') ADVANCE(367);
      if (lookahead == 'a') ADVANCE(967);
      if (lookahead == 'b') ADVANCE(953);
      if (lookahead == 'c') ADVANCE(919);
      if (lookahead == 'd') ADVANCE(965);
      if (lookahead == 'e') ADVANCE(921);
      if (lookahead == 'f') ADVANCE(964);
      if (lookahead == 'i') ADVANCE(943);
      if (lookahead == 'p') ADVANCE(972);
      if (lookahead == 's') ADVANCE(926);
      if (lookahead == 'u') ADVANCE(961);
      if (lookahead == 'w') ADVANCE(947);
      if (lookahead == '|') ADVANCE(292);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(1021);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 1022:
      ACCEPT_TOKEN(sym__un_delimited_javascript_line);
      if (lookahead == '-') ADVANCE(1022);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 1023:
      ACCEPT_TOKEN(sym__un_delimited_javascript_line);
      if (lookahead == '/') ADVANCE(844);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 1024:
      ACCEPT_TOKEN(sym__un_delimited_javascript_line);
      if (lookahead == '=') ADVANCE(365);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 1025:
      ACCEPT_TOKEN(sym__un_delimited_javascript_line);
      if (lookahead == 'f') ADVANCE(352);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 1026:
      ACCEPT_TOKEN(sym__un_delimited_javascript_line);
      if (lookahead == 'i') ADVANCE(1025);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 1027:
      ACCEPT_TOKEN(sym__un_delimited_javascript_line);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(1027);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 1028:
      ACCEPT_TOKEN(sym__un_delimited_javascript_line);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(1028);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(992);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(990);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 1029:
      ACCEPT_TOKEN(sym__un_delimited_javascript_line);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(994);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 1030:
      ACCEPT_TOKEN(sym__un_delimited_javascript_line);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 1031:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 1032:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1030);
      END_STATE();
    case 1033:
      ACCEPT_TOKEN(aux_sym_unbuffered_code_token1);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(1033);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 274},
  [2] = {.lex_state = 275, .external_lex_state = 2},
  [3] = {.lex_state = 275, .external_lex_state = 2},
  [4] = {.lex_state = 275, .external_lex_state = 2},
  [5] = {.lex_state = 274, .external_lex_state = 2},
  [6] = {.lex_state = 274, .external_lex_state = 2},
  [7] = {.lex_state = 274, .external_lex_state = 2},
  [8] = {.lex_state = 274},
  [9] = {.lex_state = 57, .external_lex_state = 2},
  [10] = {.lex_state = 57, .external_lex_state = 2},
  [11] = {.lex_state = 274},
  [12] = {.lex_state = 56, .external_lex_state = 3},
  [13] = {.lex_state = 56, .external_lex_state = 3},
  [14] = {.lex_state = 56, .external_lex_state = 3},
  [15] = {.lex_state = 56, .external_lex_state = 3},
  [16] = {.lex_state = 56, .external_lex_state = 3},
  [17] = {.lex_state = 56, .external_lex_state = 3},
  [18] = {.lex_state = 56, .external_lex_state = 3},
  [19] = {.lex_state = 56, .external_lex_state = 3},
  [20] = {.lex_state = 56, .external_lex_state = 3},
  [21] = {.lex_state = 56, .external_lex_state = 2},
  [22] = {.lex_state = 56, .external_lex_state = 3},
  [23] = {.lex_state = 56, .external_lex_state = 3},
  [24] = {.lex_state = 56, .external_lex_state = 3},
  [25] = {.lex_state = 56, .external_lex_state = 3},
  [26] = {.lex_state = 56, .external_lex_state = 3},
  [27] = {.lex_state = 56, .external_lex_state = 3},
  [28] = {.lex_state = 56, .external_lex_state = 3},
  [29] = {.lex_state = 56, .external_lex_state = 3},
  [30] = {.lex_state = 56, .external_lex_state = 3},
  [31] = {.lex_state = 56, .external_lex_state = 3},
  [32] = {.lex_state = 56, .external_lex_state = 3},
  [33] = {.lex_state = 56, .external_lex_state = 3},
  [34] = {.lex_state = 56, .external_lex_state = 3},
  [35] = {.lex_state = 56, .external_lex_state = 3},
  [36] = {.lex_state = 56, .external_lex_state = 3},
  [37] = {.lex_state = 56, .external_lex_state = 2},
  [38] = {.lex_state = 56, .external_lex_state = 3},
  [39] = {.lex_state = 56, .external_lex_state = 3},
  [40] = {.lex_state = 56, .external_lex_state = 2},
  [41] = {.lex_state = 56, .external_lex_state = 3},
  [42] = {.lex_state = 56, .external_lex_state = 3},
  [43] = {.lex_state = 56, .external_lex_state = 3},
  [44] = {.lex_state = 56, .external_lex_state = 3},
  [45] = {.lex_state = 56, .external_lex_state = 3},
  [46] = {.lex_state = 56, .external_lex_state = 3},
  [47] = {.lex_state = 56, .external_lex_state = 3},
  [48] = {.lex_state = 56, .external_lex_state = 3},
  [49] = {.lex_state = 56, .external_lex_state = 3},
  [50] = {.lex_state = 277, .external_lex_state = 2},
  [51] = {.lex_state = 276, .external_lex_state = 2},
  [52] = {.lex_state = 275, .external_lex_state = 2},
  [53] = {.lex_state = 275, .external_lex_state = 2},
  [54] = {.lex_state = 277, .external_lex_state = 2},
  [55] = {.lex_state = 275, .external_lex_state = 1},
  [56] = {.lex_state = 272, .external_lex_state = 2},
  [57] = {.lex_state = 275, .external_lex_state = 1},
  [58] = {.lex_state = 246, .external_lex_state = 2},
  [59] = {.lex_state = 275, .external_lex_state = 1},
  [60] = {.lex_state = 275, .external_lex_state = 1},
  [61] = {.lex_state = 275, .external_lex_state = 1},
  [62] = {.lex_state = 272, .external_lex_state = 2},
  [63] = {.lex_state = 275, .external_lex_state = 1},
  [64] = {.lex_state = 276, .external_lex_state = 3},
  [65] = {.lex_state = 275, .external_lex_state = 1},
  [66] = {.lex_state = 275, .external_lex_state = 1},
  [67] = {.lex_state = 275, .external_lex_state = 1},
  [68] = {.lex_state = 275, .external_lex_state = 4},
  [69] = {.lex_state = 275, .external_lex_state = 4},
  [70] = {.lex_state = 277, .external_lex_state = 2},
  [71] = {.lex_state = 275, .external_lex_state = 4},
  [72] = {.lex_state = 275, .external_lex_state = 4},
  [73] = {.lex_state = 275},
  [74] = {.lex_state = 275, .external_lex_state = 4},
  [75] = {.lex_state = 275, .external_lex_state = 4},
  [76] = {.lex_state = 277, .external_lex_state = 2},
  [77] = {.lex_state = 275, .external_lex_state = 4},
  [78] = {.lex_state = 275, .external_lex_state = 1},
  [79] = {.lex_state = 275, .external_lex_state = 4},
  [80] = {.lex_state = 275},
  [81] = {.lex_state = 275, .external_lex_state = 2},
  [82] = {.lex_state = 272, .external_lex_state = 2},
  [83] = {.lex_state = 275, .external_lex_state = 4},
  [84] = {.lex_state = 275, .external_lex_state = 1},
  [85] = {.lex_state = 276, .external_lex_state = 2},
  [86] = {.lex_state = 277, .external_lex_state = 2},
  [87] = {.lex_state = 275, .external_lex_state = 2},
  [88] = {.lex_state = 275, .external_lex_state = 2},
  [89] = {.lex_state = 275, .external_lex_state = 2},
  [90] = {.lex_state = 275, .external_lex_state = 2},
  [91] = {.lex_state = 273, .external_lex_state = 2},
  [92] = {.lex_state = 275, .external_lex_state = 4},
  [93] = {.lex_state = 246, .external_lex_state = 2},
  [94] = {.lex_state = 275, .external_lex_state = 2},
  [95] = {.lex_state = 274, .external_lex_state = 1},
  [96] = {.lex_state = 274, .external_lex_state = 1},
  [97] = {.lex_state = 275, .external_lex_state = 2},
  [98] = {.lex_state = 274, .external_lex_state = 1},
  [99] = {.lex_state = 275, .external_lex_state = 2},
  [100] = {.lex_state = 275, .external_lex_state = 2},
  [101] = {.lex_state = 274, .external_lex_state = 1},
  [102] = {.lex_state = 57, .external_lex_state = 2},
  [103] = {.lex_state = 275, .external_lex_state = 2},
  [104] = {.lex_state = 275, .external_lex_state = 2},
  [105] = {.lex_state = 275, .external_lex_state = 2},
  [106] = {.lex_state = 274, .external_lex_state = 1},
  [107] = {.lex_state = 275, .external_lex_state = 2},
  [108] = {.lex_state = 275, .external_lex_state = 2},
  [109] = {.lex_state = 274, .external_lex_state = 1},
  [110] = {.lex_state = 276, .external_lex_state = 3},
  [111] = {.lex_state = 275, .external_lex_state = 2},
  [112] = {.lex_state = 274, .external_lex_state = 1},
  [113] = {.lex_state = 57, .external_lex_state = 2},
  [114] = {.lex_state = 275, .external_lex_state = 2},
  [115] = {.lex_state = 273, .external_lex_state = 2},
  [116] = {.lex_state = 275, .external_lex_state = 2},
  [117] = {.lex_state = 275, .external_lex_state = 2},
  [118] = {.lex_state = 275, .external_lex_state = 2},
  [119] = {.lex_state = 275, .external_lex_state = 2},
  [120] = {.lex_state = 275, .external_lex_state = 2},
  [121] = {.lex_state = 275, .external_lex_state = 2},
  [122] = {.lex_state = 274, .external_lex_state = 1},
  [123] = {.lex_state = 275, .external_lex_state = 2},
  [124] = {.lex_state = 275, .external_lex_state = 2},
  [125] = {.lex_state = 275, .external_lex_state = 2},
  [126] = {.lex_state = 275, .external_lex_state = 2},
  [127] = {.lex_state = 275, .external_lex_state = 2},
  [128] = {.lex_state = 275, .external_lex_state = 2},
  [129] = {.lex_state = 275, .external_lex_state = 2},
  [130] = {.lex_state = 275, .external_lex_state = 2},
  [131] = {.lex_state = 275, .external_lex_state = 2},
  [132] = {.lex_state = 275, .external_lex_state = 2},
  [133] = {.lex_state = 275, .external_lex_state = 2},
  [134] = {.lex_state = 275, .external_lex_state = 2},
  [135] = {.lex_state = 275, .external_lex_state = 2},
  [136] = {.lex_state = 275, .external_lex_state = 2},
  [137] = {.lex_state = 275, .external_lex_state = 2},
  [138] = {.lex_state = 245, .external_lex_state = 2},
  [139] = {.lex_state = 275, .external_lex_state = 2},
  [140] = {.lex_state = 275, .external_lex_state = 2},
  [141] = {.lex_state = 275, .external_lex_state = 2},
  [142] = {.lex_state = 275, .external_lex_state = 2},
  [143] = {.lex_state = 275, .external_lex_state = 2},
  [144] = {.lex_state = 275, .external_lex_state = 2},
  [145] = {.lex_state = 275, .external_lex_state = 2},
  [146] = {.lex_state = 275, .external_lex_state = 2},
  [147] = {.lex_state = 275, .external_lex_state = 2},
  [148] = {.lex_state = 275, .external_lex_state = 2},
  [149] = {.lex_state = 275, .external_lex_state = 2},
  [150] = {.lex_state = 275, .external_lex_state = 2},
  [151] = {.lex_state = 8, .external_lex_state = 2},
  [152] = {.lex_state = 275, .external_lex_state = 5},
  [153] = {.lex_state = 275, .external_lex_state = 5},
  [154] = {.lex_state = 273, .external_lex_state = 5},
  [155] = {.lex_state = 57, .external_lex_state = 1},
  [156] = {.lex_state = 275, .external_lex_state = 5},
  [157] = {.lex_state = 276, .external_lex_state = 2},
  [158] = {.lex_state = 57, .external_lex_state = 1},
  [159] = {.lex_state = 57, .external_lex_state = 1},
  [160] = {.lex_state = 275, .external_lex_state = 5},
  [161] = {.lex_state = 275, .external_lex_state = 5},
  [162] = {.lex_state = 275, .external_lex_state = 5},
  [163] = {.lex_state = 275, .external_lex_state = 5},
  [164] = {.lex_state = 275, .external_lex_state = 5},
  [165] = {.lex_state = 274, .external_lex_state = 1},
  [166] = {.lex_state = 276, .external_lex_state = 2},
  [167] = {.lex_state = 274, .external_lex_state = 2},
  [168] = {.lex_state = 275, .external_lex_state = 5},
  [169] = {.lex_state = 275, .external_lex_state = 5},
  [170] = {.lex_state = 275, .external_lex_state = 5},
  [171] = {.lex_state = 276, .external_lex_state = 2},
  [172] = {.lex_state = 275, .external_lex_state = 5},
  [173] = {.lex_state = 275, .external_lex_state = 5},
  [174] = {.lex_state = 57, .external_lex_state = 1},
  [175] = {.lex_state = 273, .external_lex_state = 5},
  [176] = {.lex_state = 275, .external_lex_state = 5},
  [177] = {.lex_state = 275, .external_lex_state = 5},
  [178] = {.lex_state = 275, .external_lex_state = 5},
  [179] = {.lex_state = 57, .external_lex_state = 1},
  [180] = {.lex_state = 274, .external_lex_state = 1},
  [181] = {.lex_state = 8, .external_lex_state = 2},
  [182] = {.lex_state = 57, .external_lex_state = 1},
  [183] = {.lex_state = 57, .external_lex_state = 1},
  [184] = {.lex_state = 57, .external_lex_state = 1},
  [185] = {.lex_state = 57, .external_lex_state = 1},
  [186] = {.lex_state = 273, .external_lex_state = 2},
  [187] = {.lex_state = 274, .external_lex_state = 2},
  [188] = {.lex_state = 273, .external_lex_state = 5},
  [189] = {.lex_state = 57, .external_lex_state = 1},
  [190] = {.lex_state = 274, .external_lex_state = 2},
  [191] = {.lex_state = 274, .external_lex_state = 2},
  [192] = {.lex_state = 274, .external_lex_state = 6},
  [193] = {.lex_state = 276, .external_lex_state = 3},
  [194] = {.lex_state = 274, .external_lex_state = 2},
  [195] = {.lex_state = 274, .external_lex_state = 2},
  [196] = {.lex_state = 274, .external_lex_state = 2},
  [197] = {.lex_state = 274, .external_lex_state = 2},
  [198] = {.lex_state = 274, .external_lex_state = 2},
  [199] = {.lex_state = 274, .external_lex_state = 2},
  [200] = {.lex_state = 274, .external_lex_state = 2},
  [201] = {.lex_state = 276, .external_lex_state = 3},
  [202] = {.lex_state = 274, .external_lex_state = 2},
  [203] = {.lex_state = 246, .external_lex_state = 2},
  [204] = {.lex_state = 274, .external_lex_state = 2},
  [205] = {.lex_state = 246, .external_lex_state = 2},
  [206] = {.lex_state = 274, .external_lex_state = 2},
  [207] = {.lex_state = 274, .external_lex_state = 6},
  [208] = {.lex_state = 274, .external_lex_state = 2},
  [209] = {.lex_state = 274, .external_lex_state = 2},
  [210] = {.lex_state = 274, .external_lex_state = 6},
  [211] = {.lex_state = 274, .external_lex_state = 2},
  [212] = {.lex_state = 274, .external_lex_state = 2},
  [213] = {.lex_state = 57, .external_lex_state = 2},
  [214] = {.lex_state = 276, .external_lex_state = 3},
  [215] = {.lex_state = 274, .external_lex_state = 2},
  [216] = {.lex_state = 274, .external_lex_state = 4},
  [217] = {.lex_state = 274, .external_lex_state = 6},
  [218] = {.lex_state = 274, .external_lex_state = 2},
  [219] = {.lex_state = 274, .external_lex_state = 2},
  [220] = {.lex_state = 275},
  [221] = {.lex_state = 274, .external_lex_state = 6},
  [222] = {.lex_state = 274, .external_lex_state = 2},
  [223] = {.lex_state = 274, .external_lex_state = 2},
  [224] = {.lex_state = 274, .external_lex_state = 2},
  [225] = {.lex_state = 274, .external_lex_state = 2},
  [226] = {.lex_state = 274, .external_lex_state = 2},
  [227] = {.lex_state = 274, .external_lex_state = 2},
  [228] = {.lex_state = 274, .external_lex_state = 2},
  [229] = {.lex_state = 8, .external_lex_state = 2},
  [230] = {.lex_state = 274, .external_lex_state = 2},
  [231] = {.lex_state = 274, .external_lex_state = 2},
  [232] = {.lex_state = 274, .external_lex_state = 2},
  [233] = {.lex_state = 246, .external_lex_state = 2},
  [234] = {.lex_state = 274, .external_lex_state = 2},
  [235] = {.lex_state = 274, .external_lex_state = 2},
  [236] = {.lex_state = 274, .external_lex_state = 2},
  [237] = {.lex_state = 274, .external_lex_state = 2},
  [238] = {.lex_state = 274, .external_lex_state = 2},
  [239] = {.lex_state = 274, .external_lex_state = 2},
  [240] = {.lex_state = 274, .external_lex_state = 2},
  [241] = {.lex_state = 274, .external_lex_state = 2},
  [242] = {.lex_state = 274, .external_lex_state = 2},
  [243] = {.lex_state = 245, .external_lex_state = 2},
  [244] = {.lex_state = 57, .external_lex_state = 1},
  [245] = {.lex_state = 274, .external_lex_state = 2},
  [246] = {.lex_state = 274, .external_lex_state = 4},
  [247] = {.lex_state = 274, .external_lex_state = 2},
  [248] = {.lex_state = 274, .external_lex_state = 2},
  [249] = {.lex_state = 274, .external_lex_state = 6},
  [250] = {.lex_state = 274, .external_lex_state = 6},
  [251] = {.lex_state = 274, .external_lex_state = 2},
  [252] = {.lex_state = 274, .external_lex_state = 2},
  [253] = {.lex_state = 274, .external_lex_state = 6},
  [254] = {.lex_state = 274, .external_lex_state = 2},
  [255] = {.lex_state = 57, .external_lex_state = 2},
  [256] = {.lex_state = 57, .external_lex_state = 2},
  [257] = {.lex_state = 56, .external_lex_state = 1},
  [258] = {.lex_state = 57, .external_lex_state = 2},
  [259] = {.lex_state = 57, .external_lex_state = 2},
  [260] = {.lex_state = 57, .external_lex_state = 2},
  [261] = {.lex_state = 56, .external_lex_state = 1},
  [262] = {.lex_state = 57, .external_lex_state = 2},
  [263] = {.lex_state = 57, .external_lex_state = 2},
  [264] = {.lex_state = 274, .external_lex_state = 6},
  [265] = {.lex_state = 274},
  [266] = {.lex_state = 57, .external_lex_state = 2},
  [267] = {.lex_state = 57, .external_lex_state = 2},
  [268] = {.lex_state = 274, .external_lex_state = 5},
  [269] = {.lex_state = 57, .external_lex_state = 2},
  [270] = {.lex_state = 57, .external_lex_state = 2},
  [271] = {.lex_state = 57, .external_lex_state = 2},
  [272] = {.lex_state = 57, .external_lex_state = 2},
  [273] = {.lex_state = 57, .external_lex_state = 2},
  [274] = {.lex_state = 274, .external_lex_state = 5},
  [275] = {.lex_state = 57, .external_lex_state = 2},
  [276] = {.lex_state = 57, .external_lex_state = 2},
  [277] = {.lex_state = 57, .external_lex_state = 2},
  [278] = {.lex_state = 57, .external_lex_state = 2},
  [279] = {.lex_state = 57, .external_lex_state = 2},
  [280] = {.lex_state = 57, .external_lex_state = 2},
  [281] = {.lex_state = 57, .external_lex_state = 2},
  [282] = {.lex_state = 57, .external_lex_state = 2},
  [283] = {.lex_state = 274, .external_lex_state = 3},
  [284] = {.lex_state = 57, .external_lex_state = 2},
  [285] = {.lex_state = 274},
  [286] = {.lex_state = 274, .external_lex_state = 5},
  [287] = {.lex_state = 57, .external_lex_state = 2},
  [288] = {.lex_state = 41, .external_lex_state = 2},
  [289] = {.lex_state = 57, .external_lex_state = 2},
  [290] = {.lex_state = 41, .external_lex_state = 2},
  [291] = {.lex_state = 57, .external_lex_state = 2},
  [292] = {.lex_state = 56, .external_lex_state = 1},
  [293] = {.lex_state = 57, .external_lex_state = 2},
  [294] = {.lex_state = 56, .external_lex_state = 1},
  [295] = {.lex_state = 57, .external_lex_state = 2},
  [296] = {.lex_state = 57, .external_lex_state = 2},
  [297] = {.lex_state = 57, .external_lex_state = 2},
  [298] = {.lex_state = 57, .external_lex_state = 2},
  [299] = {.lex_state = 57, .external_lex_state = 2},
  [300] = {.lex_state = 57, .external_lex_state = 2},
  [301] = {.lex_state = 57, .external_lex_state = 2},
  [302] = {.lex_state = 57, .external_lex_state = 2},
  [303] = {.lex_state = 57, .external_lex_state = 2},
  [304] = {.lex_state = 57, .external_lex_state = 2},
  [305] = {.lex_state = 57, .external_lex_state = 2},
  [306] = {.lex_state = 274, .external_lex_state = 5},
  [307] = {.lex_state = 57, .external_lex_state = 2},
  [308] = {.lex_state = 57, .external_lex_state = 2},
  [309] = {.lex_state = 57, .external_lex_state = 2},
  [310] = {.lex_state = 57, .external_lex_state = 2},
  [311] = {.lex_state = 56, .external_lex_state = 1},
  [312] = {.lex_state = 57, .external_lex_state = 2},
  [313] = {.lex_state = 56, .external_lex_state = 1},
  [314] = {.lex_state = 57, .external_lex_state = 2},
  [315] = {.lex_state = 57, .external_lex_state = 2},
  [316] = {.lex_state = 56, .external_lex_state = 1},
  [317] = {.lex_state = 56, .external_lex_state = 1},
  [318] = {.lex_state = 57, .external_lex_state = 2},
  [319] = {.lex_state = 57, .external_lex_state = 2},
  [320] = {.lex_state = 57, .external_lex_state = 2},
  [321] = {.lex_state = 274},
  [322] = {.lex_state = 274},
  [323] = {.lex_state = 274},
  [324] = {.lex_state = 274},
  [325] = {.lex_state = 274},
  [326] = {.lex_state = 41, .external_lex_state = 2},
  [327] = {.lex_state = 56, .external_lex_state = 1},
  [328] = {.lex_state = 56, .external_lex_state = 2},
  [329] = {.lex_state = 274},
  [330] = {.lex_state = 274},
  [331] = {.lex_state = 274},
  [332] = {.lex_state = 274},
  [333] = {.lex_state = 274},
  [334] = {.lex_state = 274},
  [335] = {.lex_state = 274},
  [336] = {.lex_state = 274},
  [337] = {.lex_state = 274},
  [338] = {.lex_state = 274},
  [339] = {.lex_state = 274},
  [340] = {.lex_state = 274},
  [341] = {.lex_state = 274},
  [342] = {.lex_state = 274},
  [343] = {.lex_state = 274},
  [344] = {.lex_state = 274},
  [345] = {.lex_state = 274},
  [346] = {.lex_state = 274},
  [347] = {.lex_state = 274},
  [348] = {.lex_state = 274},
  [349] = {.lex_state = 274},
  [350] = {.lex_state = 274},
  [351] = {.lex_state = 274},
  [352] = {.lex_state = 274},
  [353] = {.lex_state = 274},
  [354] = {.lex_state = 274},
  [355] = {.lex_state = 274},
  [356] = {.lex_state = 274},
  [357] = {.lex_state = 274},
  [358] = {.lex_state = 274},
  [359] = {.lex_state = 56, .external_lex_state = 1},
  [360] = {.lex_state = 274},
  [361] = {.lex_state = 274},
  [362] = {.lex_state = 274},
  [363] = {.lex_state = 274},
  [364] = {.lex_state = 274},
  [365] = {.lex_state = 274},
  [366] = {.lex_state = 274},
  [367] = {.lex_state = 274},
  [368] = {.lex_state = 274},
  [369] = {.lex_state = 245, .external_lex_state = 2},
  [370] = {.lex_state = 245, .external_lex_state = 2},
  [371] = {.lex_state = 274},
  [372] = {.lex_state = 274},
  [373] = {.lex_state = 245, .external_lex_state = 2},
  [374] = {.lex_state = 274},
  [375] = {.lex_state = 274},
  [376] = {.lex_state = 56, .external_lex_state = 2},
  [377] = {.lex_state = 56, .external_lex_state = 2},
  [378] = {.lex_state = 56, .external_lex_state = 2},
  [379] = {.lex_state = 56, .external_lex_state = 2},
  [380] = {.lex_state = 56, .external_lex_state = 2},
  [381] = {.lex_state = 56, .external_lex_state = 2},
  [382] = {.lex_state = 56, .external_lex_state = 2},
  [383] = {.lex_state = 56, .external_lex_state = 2},
  [384] = {.lex_state = 56, .external_lex_state = 2},
  [385] = {.lex_state = 56, .external_lex_state = 2},
  [386] = {.lex_state = 56, .external_lex_state = 2},
  [387] = {.lex_state = 56, .external_lex_state = 2},
  [388] = {.lex_state = 56, .external_lex_state = 2},
  [389] = {.lex_state = 56, .external_lex_state = 2},
  [390] = {.lex_state = 56, .external_lex_state = 2},
  [391] = {.lex_state = 56, .external_lex_state = 2},
  [392] = {.lex_state = 56, .external_lex_state = 2},
  [393] = {.lex_state = 56, .external_lex_state = 2},
  [394] = {.lex_state = 56, .external_lex_state = 2},
  [395] = {.lex_state = 56, .external_lex_state = 2},
  [396] = {.lex_state = 56, .external_lex_state = 2},
  [397] = {.lex_state = 56, .external_lex_state = 2},
  [398] = {.lex_state = 56, .external_lex_state = 2},
  [399] = {.lex_state = 56, .external_lex_state = 2},
  [400] = {.lex_state = 56, .external_lex_state = 2},
  [401] = {.lex_state = 56, .external_lex_state = 2},
  [402] = {.lex_state = 56, .external_lex_state = 2},
  [403] = {.lex_state = 56, .external_lex_state = 2},
  [404] = {.lex_state = 56, .external_lex_state = 2},
  [405] = {.lex_state = 56, .external_lex_state = 2},
  [406] = {.lex_state = 56, .external_lex_state = 2},
  [407] = {.lex_state = 56, .external_lex_state = 2},
  [408] = {.lex_state = 56, .external_lex_state = 2},
  [409] = {.lex_state = 56, .external_lex_state = 2},
  [410] = {.lex_state = 56, .external_lex_state = 2},
  [411] = {.lex_state = 56, .external_lex_state = 2},
  [412] = {.lex_state = 56, .external_lex_state = 2},
  [413] = {.lex_state = 56, .external_lex_state = 2},
  [414] = {.lex_state = 56, .external_lex_state = 2},
  [415] = {.lex_state = 56, .external_lex_state = 2},
  [416] = {.lex_state = 56, .external_lex_state = 2},
  [417] = {.lex_state = 56, .external_lex_state = 2},
  [418] = {.lex_state = 56, .external_lex_state = 2},
  [419] = {.lex_state = 56, .external_lex_state = 2},
  [420] = {.lex_state = 56, .external_lex_state = 2},
  [421] = {.lex_state = 58},
  [422] = {.lex_state = 58},
  [423] = {.lex_state = 58},
  [424] = {.lex_state = 52, .external_lex_state = 3},
  [425] = {.lex_state = 52, .external_lex_state = 3},
  [426] = {.lex_state = 52, .external_lex_state = 3},
  [427] = {.lex_state = 52, .external_lex_state = 3},
  [428] = {.lex_state = 58},
  [429] = {.lex_state = 52, .external_lex_state = 3},
  [430] = {.lex_state = 52, .external_lex_state = 3},
  [431] = {.lex_state = 52, .external_lex_state = 3},
  [432] = {.lex_state = 52, .external_lex_state = 3},
  [433] = {.lex_state = 52, .external_lex_state = 3},
  [434] = {.lex_state = 52, .external_lex_state = 3},
  [435] = {.lex_state = 58},
  [436] = {.lex_state = 52, .external_lex_state = 3},
  [437] = {.lex_state = 52, .external_lex_state = 3},
  [438] = {.lex_state = 52, .external_lex_state = 3},
  [439] = {.lex_state = 52, .external_lex_state = 3},
  [440] = {.lex_state = 52, .external_lex_state = 3},
  [441] = {.lex_state = 89},
  [442] = {.lex_state = 89},
  [443] = {.lex_state = 89},
  [444] = {.lex_state = 89},
  [445] = {.lex_state = 89},
  [446] = {.lex_state = 89},
  [447] = {.lex_state = 89},
  [448] = {.lex_state = 89},
  [449] = {.lex_state = 89},
  [450] = {.lex_state = 89},
  [451] = {.lex_state = 89},
  [452] = {.lex_state = 89},
  [453] = {.lex_state = 89},
  [454] = {.lex_state = 89},
  [455] = {.lex_state = 89},
  [456] = {.lex_state = 53, .external_lex_state = 3},
  [457] = {.lex_state = 53, .external_lex_state = 3},
  [458] = {.lex_state = 53, .external_lex_state = 3},
  [459] = {.lex_state = 53, .external_lex_state = 3},
  [460] = {.lex_state = 53, .external_lex_state = 3},
  [461] = {.lex_state = 53, .external_lex_state = 3},
  [462] = {.lex_state = 53, .external_lex_state = 3},
  [463] = {.lex_state = 53, .external_lex_state = 3},
  [464] = {.lex_state = 53, .external_lex_state = 3},
  [465] = {.lex_state = 53, .external_lex_state = 3},
  [466] = {.lex_state = 53, .external_lex_state = 3},
  [467] = {.lex_state = 53, .external_lex_state = 3},
  [468] = {.lex_state = 53, .external_lex_state = 3},
  [469] = {.lex_state = 53, .external_lex_state = 3},
  [470] = {.lex_state = 53, .external_lex_state = 3},
  [471] = {.lex_state = 36, .external_lex_state = 2},
  [472] = {.lex_state = 53, .external_lex_state = 3},
  [473] = {.lex_state = 36, .external_lex_state = 2},
  [474] = {.lex_state = 53, .external_lex_state = 3},
  [475] = {.lex_state = 36, .external_lex_state = 2},
  [476] = {.lex_state = 53, .external_lex_state = 3},
  [477] = {.lex_state = 36, .external_lex_state = 2},
  [478] = {.lex_state = 0},
  [479] = {.lex_state = 36, .external_lex_state = 2},
  [480] = {.lex_state = 36, .external_lex_state = 2},
  [481] = {.lex_state = 36, .external_lex_state = 2},
  [482] = {.lex_state = 53, .external_lex_state = 3},
  [483] = {.lex_state = 36, .external_lex_state = 2},
  [484] = {.lex_state = 53, .external_lex_state = 3},
  [485] = {.lex_state = 53, .external_lex_state = 3},
  [486] = {.lex_state = 53, .external_lex_state = 3},
  [487] = {.lex_state = 0},
  [488] = {.lex_state = 36, .external_lex_state = 2},
  [489] = {.lex_state = 0},
  [490] = {.lex_state = 36, .external_lex_state = 2},
  [491] = {.lex_state = 53, .external_lex_state = 3},
  [492] = {.lex_state = 53, .external_lex_state = 3},
  [493] = {.lex_state = 53, .external_lex_state = 3},
  [494] = {.lex_state = 36, .external_lex_state = 2},
  [495] = {.lex_state = 53, .external_lex_state = 3},
  [496] = {.lex_state = 53, .external_lex_state = 3},
  [497] = {.lex_state = 53, .external_lex_state = 3},
  [498] = {.lex_state = 53, .external_lex_state = 3},
  [499] = {.lex_state = 0},
  [500] = {.lex_state = 36, .external_lex_state = 2},
  [501] = {.lex_state = 53, .external_lex_state = 3},
  [502] = {.lex_state = 36, .external_lex_state = 2},
  [503] = {.lex_state = 36, .external_lex_state = 2},
  [504] = {.lex_state = 53, .external_lex_state = 3},
  [505] = {.lex_state = 53, .external_lex_state = 3},
  [506] = {.lex_state = 36, .external_lex_state = 2},
  [507] = {.lex_state = 0},
  [508] = {.lex_state = 53, .external_lex_state = 3},
  [509] = {.lex_state = 53, .external_lex_state = 3},
  [510] = {.lex_state = 53, .external_lex_state = 3},
  [511] = {.lex_state = 36, .external_lex_state = 3},
  [512] = {.lex_state = 36, .external_lex_state = 3},
  [513] = {.lex_state = 36, .external_lex_state = 3},
  [514] = {.lex_state = 36, .external_lex_state = 3},
  [515] = {.lex_state = 36, .external_lex_state = 3},
  [516] = {.lex_state = 36, .external_lex_state = 3},
  [517] = {.lex_state = 36, .external_lex_state = 3},
  [518] = {.lex_state = 36, .external_lex_state = 3},
  [519] = {.lex_state = 36, .external_lex_state = 3},
  [520] = {.lex_state = 36, .external_lex_state = 3},
  [521] = {.lex_state = 36, .external_lex_state = 3},
  [522] = {.lex_state = 36, .external_lex_state = 3},
  [523] = {.lex_state = 36, .external_lex_state = 3},
  [524] = {.lex_state = 36, .external_lex_state = 3},
  [525] = {.lex_state = 247, .external_lex_state = 3},
  [526] = {.lex_state = 88, .external_lex_state = 1},
  [527] = {.lex_state = 36, .external_lex_state = 3},
  [528] = {.lex_state = 88, .external_lex_state = 2},
  [529] = {.lex_state = 88, .external_lex_state = 2},
  [530] = {.lex_state = 36, .external_lex_state = 3},
  [531] = {.lex_state = 36, .external_lex_state = 3},
  [532] = {.lex_state = 36, .external_lex_state = 3},
  [533] = {.lex_state = 36, .external_lex_state = 3},
  [534] = {.lex_state = 36, .external_lex_state = 3},
  [535] = {.lex_state = 36, .external_lex_state = 3},
  [536] = {.lex_state = 36, .external_lex_state = 3},
  [537] = {.lex_state = 88, .external_lex_state = 2},
  [538] = {.lex_state = 36, .external_lex_state = 3},
  [539] = {.lex_state = 53, .external_lex_state = 3},
  [540] = {.lex_state = 53, .external_lex_state = 3},
  [541] = {.lex_state = 36, .external_lex_state = 3},
  [542] = {.lex_state = 88, .external_lex_state = 2},
  [543] = {.lex_state = 88, .external_lex_state = 1},
  [544] = {.lex_state = 36, .external_lex_state = 3},
  [545] = {.lex_state = 36, .external_lex_state = 3},
  [546] = {.lex_state = 36, .external_lex_state = 3},
  [547] = {.lex_state = 36, .external_lex_state = 3},
  [548] = {.lex_state = 88, .external_lex_state = 1},
  [549] = {.lex_state = 36, .external_lex_state = 3},
  [550] = {.lex_state = 88, .external_lex_state = 2},
  [551] = {.lex_state = 36, .external_lex_state = 3},
  [552] = {.lex_state = 36, .external_lex_state = 3},
  [553] = {.lex_state = 36, .external_lex_state = 3},
  [554] = {.lex_state = 53, .external_lex_state = 3},
  [555] = {.lex_state = 88, .external_lex_state = 1},
  [556] = {.lex_state = 36, .external_lex_state = 3},
  [557] = {.lex_state = 36, .external_lex_state = 3},
  [558] = {.lex_state = 36, .external_lex_state = 3},
  [559] = {.lex_state = 36, .external_lex_state = 3},
  [560] = {.lex_state = 58},
  [561] = {.lex_state = 36, .external_lex_state = 3},
  [562] = {.lex_state = 36, .external_lex_state = 3},
  [563] = {.lex_state = 88, .external_lex_state = 2},
  [564] = {.lex_state = 36, .external_lex_state = 3},
  [565] = {.lex_state = 36, .external_lex_state = 3},
  [566] = {.lex_state = 36, .external_lex_state = 3},
  [567] = {.lex_state = 36, .external_lex_state = 3},
  [568] = {.lex_state = 88, .external_lex_state = 2},
  [569] = {.lex_state = 36, .external_lex_state = 3},
  [570] = {.lex_state = 88, .external_lex_state = 1},
  [571] = {.lex_state = 36, .external_lex_state = 3},
  [572] = {.lex_state = 36, .external_lex_state = 3},
  [573] = {.lex_state = 88, .external_lex_state = 1},
  [574] = {.lex_state = 36, .external_lex_state = 3},
  [575] = {.lex_state = 36, .external_lex_state = 3},
  [576] = {.lex_state = 36, .external_lex_state = 3},
  [577] = {.lex_state = 36, .external_lex_state = 3},
  [578] = {.lex_state = 36, .external_lex_state = 3},
  [579] = {.lex_state = 88, .external_lex_state = 1},
  [580] = {.lex_state = 88, .external_lex_state = 2},
  [581] = {.lex_state = 88, .external_lex_state = 2},
  [582] = {.lex_state = 88, .external_lex_state = 1},
  [583] = {.lex_state = 36, .external_lex_state = 3},
  [584] = {.lex_state = 36, .external_lex_state = 3},
  [585] = {.lex_state = 36, .external_lex_state = 3},
  [586] = {.lex_state = 36, .external_lex_state = 3},
  [587] = {.lex_state = 36},
  [588] = {.lex_state = 53},
  [589] = {.lex_state = 248, .external_lex_state = 3},
  [590] = {.lex_state = 36},
  [591] = {.lex_state = 36},
  [592] = {.lex_state = 88, .external_lex_state = 3},
  [593] = {.lex_state = 36},
  [594] = {.lex_state = 36},
  [595] = {.lex_state = 36},
  [596] = {.lex_state = 88, .external_lex_state = 3},
  [597] = {.lex_state = 36},
  [598] = {.lex_state = 36},
  [599] = {.lex_state = 36},
  [600] = {.lex_state = 36},
  [601] = {.lex_state = 36},
  [602] = {.lex_state = 88, .external_lex_state = 3},
  [603] = {.lex_state = 36},
  [604] = {.lex_state = 36},
  [605] = {.lex_state = 36},
  [606] = {.lex_state = 36},
  [607] = {.lex_state = 36},
  [608] = {.lex_state = 36},
  [609] = {.lex_state = 88, .external_lex_state = 3},
  [610] = {.lex_state = 36},
  [611] = {.lex_state = 36},
  [612] = {.lex_state = 88, .external_lex_state = 3},
  [613] = {.lex_state = 53},
  [614] = {.lex_state = 36},
  [615] = {.lex_state = 36},
  [616] = {.lex_state = 89},
  [617] = {.lex_state = 88, .external_lex_state = 3},
  [618] = {.lex_state = 36},
  [619] = {.lex_state = 36},
  [620] = {.lex_state = 36},
  [621] = {.lex_state = 36},
  [622] = {.lex_state = 88, .external_lex_state = 1},
  [623] = {.lex_state = 36},
  [624] = {.lex_state = 88, .external_lex_state = 3},
  [625] = {.lex_state = 36, .external_lex_state = 3},
  [626] = {.lex_state = 36},
  [627] = {.lex_state = 36},
  [628] = {.lex_state = 88, .external_lex_state = 3},
  [629] = {.lex_state = 53},
  [630] = {.lex_state = 0},
  [631] = {.lex_state = 36, .external_lex_state = 2},
  [632] = {.lex_state = 88, .external_lex_state = 2},
  [633] = {.lex_state = 53},
  [634] = {.lex_state = 88, .external_lex_state = 2},
  [635] = {.lex_state = 88},
  [636] = {.lex_state = 88},
  [637] = {.lex_state = 88, .external_lex_state = 2},
  [638] = {.lex_state = 88, .external_lex_state = 2},
  [639] = {.lex_state = 88, .external_lex_state = 2},
  [640] = {.lex_state = 36, .external_lex_state = 3},
  [641] = {.lex_state = 36, .external_lex_state = 3},
  [642] = {.lex_state = 0},
  [643] = {.lex_state = 88, .external_lex_state = 2},
  [644] = {.lex_state = 88, .external_lex_state = 2},
  [645] = {.lex_state = 36, .external_lex_state = 2},
  [646] = {.lex_state = 88},
  [647] = {.lex_state = 36, .external_lex_state = 3},
  [648] = {.lex_state = 88, .external_lex_state = 2},
  [649] = {.lex_state = 88, .external_lex_state = 2},
  [650] = {.lex_state = 88, .external_lex_state = 2},
  [651] = {.lex_state = 88, .external_lex_state = 2},
  [652] = {.lex_state = 88, .external_lex_state = 2},
  [653] = {.lex_state = 88, .external_lex_state = 2},
  [654] = {.lex_state = 0},
  [655] = {.lex_state = 88},
  [656] = {.lex_state = 88},
  [657] = {.lex_state = 343, .external_lex_state = 5},
  [658] = {.lex_state = 88},
  [659] = {.lex_state = 88},
  [660] = {.lex_state = 343, .external_lex_state = 5},
  [661] = {.lex_state = 37, .external_lex_state = 2},
  [662] = {.lex_state = 146},
  [663] = {.lex_state = 37, .external_lex_state = 2},
  [664] = {.lex_state = 88},
  [665] = {.lex_state = 343, .external_lex_state = 5},
  [666] = {.lex_state = 146},
  [667] = {.lex_state = 42, .external_lex_state = 3},
  [668] = {.lex_state = 88},
  [669] = {.lex_state = 88},
  [670] = {.lex_state = 88},
  [671] = {.lex_state = 88},
  [672] = {.lex_state = 343, .external_lex_state = 5},
  [673] = {.lex_state = 343, .external_lex_state = 5},
  [674] = {.lex_state = 42, .external_lex_state = 3},
  [675] = {.lex_state = 88},
  [676] = {.lex_state = 37, .external_lex_state = 2},
  [677] = {.lex_state = 343, .external_lex_state = 5},
  [678] = {.lex_state = 42, .external_lex_state = 3},
  [679] = {.lex_state = 88},
  [680] = {.lex_state = 146},
  [681] = {.lex_state = 88},
  [682] = {.lex_state = 88},
  [683] = {.lex_state = 88},
  [684] = {.lex_state = 88},
  [685] = {.lex_state = 248, .external_lex_state = 3},
  [686] = {.lex_state = 146},
  [687] = {.lex_state = 88},
  [688] = {.lex_state = 42, .external_lex_state = 3},
  [689] = {.lex_state = 146},
  [690] = {.lex_state = 36, .external_lex_state = 3},
  [691] = {.lex_state = 88},
  [692] = {.lex_state = 248, .external_lex_state = 3},
  [693] = {.lex_state = 88},
  [694] = {.lex_state = 248, .external_lex_state = 3},
  [695] = {.lex_state = 88},
  [696] = {.lex_state = 52},
  [697] = {.lex_state = 88},
  [698] = {.lex_state = 88},
  [699] = {.lex_state = 343, .external_lex_state = 5},
  [700] = {.lex_state = 343, .external_lex_state = 5},
  [701] = {.lex_state = 52},
  [702] = {.lex_state = 88},
  [703] = {.lex_state = 343, .external_lex_state = 5},
  [704] = {.lex_state = 37, .external_lex_state = 2},
  [705] = {.lex_state = 36, .external_lex_state = 3},
  [706] = {.lex_state = 42, .external_lex_state = 3},
  [707] = {.lex_state = 36, .external_lex_state = 3},
  [708] = {.lex_state = 88},
  [709] = {.lex_state = 88},
  [710] = {.lex_state = 88},
  [711] = {.lex_state = 88},
  [712] = {.lex_state = 37, .external_lex_state = 2},
  [713] = {.lex_state = 37, .external_lex_state = 2},
  [714] = {.lex_state = 343, .external_lex_state = 5},
  [715] = {.lex_state = 343, .external_lex_state = 5},
  [716] = {.lex_state = 88},
  [717] = {.lex_state = 88},
  [718] = {.lex_state = 42},
  [719] = {.lex_state = 52},
  [720] = {.lex_state = 249},
  [721] = {.lex_state = 249},
  [722] = {.lex_state = 52},
  [723] = {.lex_state = 249},
  [724] = {.lex_state = 249},
  [725] = {.lex_state = 52},
  [726] = {.lex_state = 42},
  [727] = {.lex_state = 52},
  [728] = {.lex_state = 343, .external_lex_state = 5},
  [729] = {.lex_state = 0, .external_lex_state = 3},
  [730] = {.lex_state = 343, .external_lex_state = 5},
  [731] = {.lex_state = 52},
  [732] = {.lex_state = 52},
  [733] = {.lex_state = 52},
  [734] = {.lex_state = 343, .external_lex_state = 5},
  [735] = {.lex_state = 343},
  [736] = {.lex_state = 343},
  [737] = {.lex_state = 37, .external_lex_state = 3},
  [738] = {.lex_state = 343, .external_lex_state = 3},
  [739] = {.lex_state = 42},
  [740] = {.lex_state = 52},
  [741] = {.lex_state = 38},
  [742] = {.lex_state = 52},
  [743] = {.lex_state = 343},
  [744] = {.lex_state = 52},
  [745] = {.lex_state = 343},
  [746] = {.lex_state = 37, .external_lex_state = 3},
  [747] = {.lex_state = 42},
  [748] = {.lex_state = 42},
  [749] = {.lex_state = 343, .external_lex_state = 3},
  [750] = {.lex_state = 37, .external_lex_state = 2},
  [751] = {.lex_state = 0, .external_lex_state = 3},
  [752] = {.lex_state = 343, .external_lex_state = 5},
  [753] = {.lex_state = 343},
  [754] = {.lex_state = 343},
  [755] = {.lex_state = 37, .external_lex_state = 3},
  [756] = {.lex_state = 343, .external_lex_state = 3},
  [757] = {.lex_state = 38},
  [758] = {.lex_state = 38},
  [759] = {.lex_state = 343},
  [760] = {.lex_state = 42},
  [761] = {.lex_state = 42},
  [762] = {.lex_state = 343},
  [763] = {.lex_state = 37, .external_lex_state = 3},
  [764] = {.lex_state = 249},
  [765] = {.lex_state = 343, .external_lex_state = 3},
  [766] = {.lex_state = 52},
  [767] = {.lex_state = 0},
  [768] = {.lex_state = 52},
  [769] = {.lex_state = 343, .external_lex_state = 3},
  [770] = {.lex_state = 343},
  [771] = {.lex_state = 37, .external_lex_state = 2},
  [772] = {.lex_state = 343, .external_lex_state = 5},
  [773] = {.lex_state = 0, .external_lex_state = 3},
  [774] = {.lex_state = 343, .external_lex_state = 5},
  [775] = {.lex_state = 343, .external_lex_state = 5},
  [776] = {.lex_state = 52},
  [777] = {.lex_state = 52},
  [778] = {.lex_state = 52},
  [779] = {.lex_state = 52},
  [780] = {.lex_state = 42},
  [781] = {.lex_state = 42},
  [782] = {.lex_state = 42},
  [783] = {.lex_state = 343, .external_lex_state = 5},
  [784] = {.lex_state = 52},
  [785] = {.lex_state = 343, .external_lex_state = 5},
  [786] = {.lex_state = 42},
  [787] = {.lex_state = 52},
  [788] = {.lex_state = 52},
  [789] = {.lex_state = 42},
  [790] = {.lex_state = 343},
  [791] = {.lex_state = 37, .external_lex_state = 3},
  [792] = {.lex_state = 343, .external_lex_state = 5},
  [793] = {.lex_state = 52},
  [794] = {.lex_state = 38},
  [795] = {.lex_state = 343, .external_lex_state = 5},
  [796] = {.lex_state = 107},
  [797] = {.lex_state = 52},
  [798] = {.lex_state = 52},
  [799] = {.lex_state = 343, .external_lex_state = 5},
  [800] = {.lex_state = 42},
  [801] = {.lex_state = 42},
  [802] = {.lex_state = 38},
  [803] = {.lex_state = 42},
  [804] = {.lex_state = 42},
  [805] = {.lex_state = 42},
  [806] = {.lex_state = 0, .external_lex_state = 3},
  [807] = {.lex_state = 343, .external_lex_state = 5},
  [808] = {.lex_state = 42},
  [809] = {.lex_state = 42},
  [810] = {.lex_state = 52},
  [811] = {.lex_state = 107},
  [812] = {.lex_state = 88},
  [813] = {.lex_state = 42},
  [814] = {.lex_state = 0, .external_lex_state = 6},
  [815] = {.lex_state = 37},
  [816] = {.lex_state = 0, .external_lex_state = 6},
  [817] = {.lex_state = 88},
  [818] = {.lex_state = 88},
  [819] = {.lex_state = 42},
  [820] = {.lex_state = 37},
  [821] = {.lex_state = 88},
  [822] = {.lex_state = 88},
  [823] = {.lex_state = 0, .external_lex_state = 6},
  [824] = {.lex_state = 37},
  [825] = {.lex_state = 0, .external_lex_state = 6},
  [826] = {.lex_state = 42},
  [827] = {.lex_state = 37},
  [828] = {.lex_state = 0, .external_lex_state = 6},
  [829] = {.lex_state = 37},
  [830] = {.lex_state = 88},
  [831] = {.lex_state = 88},
  [832] = {.lex_state = 42},
  [833] = {.lex_state = 37},
  [834] = {.lex_state = 37},
  [835] = {.lex_state = 0, .external_lex_state = 6},
  [836] = {.lex_state = 0},
  [837] = {.lex_state = 42},
  [838] = {.lex_state = 0, .external_lex_state = 6},
  [839] = {.lex_state = 88},
  [840] = {.lex_state = 88},
  [841] = {.lex_state = 37},
  [842] = {.lex_state = 0, .external_lex_state = 6},
  [843] = {.lex_state = 0, .external_lex_state = 6},
  [844] = {.lex_state = 0},
  [845] = {.lex_state = 88},
  [846] = {.lex_state = 0, .external_lex_state = 6},
  [847] = {.lex_state = 0, .external_lex_state = 3},
  [848] = {.lex_state = 88},
  [849] = {.lex_state = 343, .external_lex_state = 5},
  [850] = {.lex_state = 0, .external_lex_state = 6},
  [851] = {.lex_state = 0, .external_lex_state = 6},
  [852] = {.lex_state = 0},
  [853] = {.lex_state = 52},
  [854] = {.lex_state = 0, .external_lex_state = 6},
  [855] = {.lex_state = 88},
  [856] = {.lex_state = 59},
  [857] = {.lex_state = 90},
  [858] = {.lex_state = 88},
  [859] = {.lex_state = 249},
  [860] = {.lex_state = 37},
  [861] = {.lex_state = 0, .external_lex_state = 6},
  [862] = {.lex_state = 88},
  [863] = {.lex_state = 343, .external_lex_state = 5},
  [864] = {.lex_state = 88},
  [865] = {.lex_state = 0, .external_lex_state = 6},
  [866] = {.lex_state = 0, .external_lex_state = 6},
  [867] = {.lex_state = 88},
  [868] = {.lex_state = 0, .external_lex_state = 6},
  [869] = {.lex_state = 88},
  [870] = {.lex_state = 0, .external_lex_state = 6},
  [871] = {.lex_state = 88},
  [872] = {.lex_state = 107},
  [873] = {.lex_state = 0, .external_lex_state = 6},
  [874] = {.lex_state = 0, .external_lex_state = 6},
  [875] = {.lex_state = 0, .external_lex_state = 6},
  [876] = {.lex_state = 90},
  [877] = {.lex_state = 59},
  [878] = {.lex_state = 88},
  [879] = {.lex_state = 0},
  [880] = {.lex_state = 0, .external_lex_state = 6},
  [881] = {.lex_state = 0},
  [882] = {.lex_state = 0},
  [883] = {.lex_state = 90},
  [884] = {.lex_state = 59},
  [885] = {.lex_state = 0, .external_lex_state = 6},
  [886] = {.lex_state = 0},
  [887] = {.lex_state = 88},
  [888] = {.lex_state = 37},
  [889] = {.lex_state = 0},
  [890] = {.lex_state = 0, .external_lex_state = 6},
  [891] = {.lex_state = 0, .external_lex_state = 6},
  [892] = {.lex_state = 0, .external_lex_state = 6},
  [893] = {.lex_state = 0, .external_lex_state = 6},
  [894] = {.lex_state = 0, .external_lex_state = 6},
  [895] = {.lex_state = 0, .external_lex_state = 6},
  [896] = {.lex_state = 0, .external_lex_state = 3},
  [897] = {.lex_state = 0, .external_lex_state = 6},
  [898] = {.lex_state = 0, .external_lex_state = 3},
  [899] = {.lex_state = 0, .external_lex_state = 6},
  [900] = {.lex_state = 0},
  [901] = {.lex_state = 0, .external_lex_state = 3},
  [902] = {.lex_state = 0, .external_lex_state = 3},
  [903] = {.lex_state = 0, .external_lex_state = 3},
  [904] = {.lex_state = 0},
  [905] = {.lex_state = 0},
  [906] = {.lex_state = 0, .external_lex_state = 3},
  [907] = {.lex_state = 0, .external_lex_state = 3},
  [908] = {.lex_state = 0, .external_lex_state = 3},
  [909] = {.lex_state = 250},
  [910] = {.lex_state = 1033},
  [911] = {.lex_state = 0, .external_lex_state = 3},
  [912] = {.lex_state = 0, .external_lex_state = 3},
  [913] = {.lex_state = 1033},
  [914] = {.lex_state = 0, .external_lex_state = 3},
  [915] = {.lex_state = 0, .external_lex_state = 3},
  [916] = {.lex_state = 37},
  [917] = {.lex_state = 343},
  [918] = {.lex_state = 0, .external_lex_state = 6},
  [919] = {.lex_state = 0, .external_lex_state = 6},
  [920] = {.lex_state = 37},
  [921] = {.lex_state = 0, .external_lex_state = 3},
  [922] = {.lex_state = 0, .external_lex_state = 6},
  [923] = {.lex_state = 0, .external_lex_state = 3},
  [924] = {.lex_state = 0, .external_lex_state = 3},
  [925] = {.lex_state = 0},
  [926] = {.lex_state = 0},
  [927] = {.lex_state = 107},
  [928] = {.lex_state = 0, .external_lex_state = 3},
  [929] = {.lex_state = 42},
  [930] = {.lex_state = 0, .external_lex_state = 3},
  [931] = {.lex_state = 0, .external_lex_state = 3},
  [932] = {.lex_state = 1033},
  [933] = {.lex_state = 0, .external_lex_state = 3},
  [934] = {.lex_state = 0, .external_lex_state = 3},
  [935] = {.lex_state = 0, .external_lex_state = 6},
  [936] = {.lex_state = 251},
  [937] = {.lex_state = 0, .external_lex_state = 3},
  [938] = {.lex_state = 0, .external_lex_state = 3},
  [939] = {.lex_state = 0, .external_lex_state = 6},
  [940] = {.lex_state = 0, .external_lex_state = 3},
  [941] = {.lex_state = 0, .external_lex_state = 3},
  [942] = {.lex_state = 343},
  [943] = {.lex_state = 0, .external_lex_state = 6},
  [944] = {.lex_state = 39},
  [945] = {.lex_state = 40},
  [946] = {.lex_state = 37},
  [947] = {.lex_state = 0, .external_lex_state = 3},
  [948] = {.lex_state = 0, .external_lex_state = 3},
  [949] = {.lex_state = 343},
  [950] = {.lex_state = 1033},
  [951] = {.lex_state = 0, .external_lex_state = 3},
  [952] = {.lex_state = 0, .external_lex_state = 3},
  [953] = {.lex_state = 0, .external_lex_state = 6},
  [954] = {.lex_state = 0, .external_lex_state = 6},
  [955] = {.lex_state = 0, .external_lex_state = 3},
  [956] = {.lex_state = 251},
  [957] = {.lex_state = 0, .external_lex_state = 6},
  [958] = {.lex_state = 0, .external_lex_state = 6},
  [959] = {.lex_state = 0, .external_lex_state = 3},
  [960] = {.lex_state = 37},
  [961] = {.lex_state = 0},
  [962] = {.lex_state = 37},
  [963] = {.lex_state = 88},
  [964] = {.lex_state = 343},
  [965] = {.lex_state = 88},
  [966] = {.lex_state = 0, .external_lex_state = 3},
  [967] = {.lex_state = 0, .external_lex_state = 3},
  [968] = {.lex_state = 251},
  [969] = {.lex_state = 1033},
  [970] = {.lex_state = 0, .external_lex_state = 3},
  [971] = {.lex_state = 0, .external_lex_state = 3},
  [972] = {.lex_state = 274},
  [973] = {.lex_state = 0, .external_lex_state = 6},
  [974] = {.lex_state = 0},
  [975] = {.lex_state = 37},
  [976] = {.lex_state = 0},
  [977] = {.lex_state = 0, .external_lex_state = 6},
  [978] = {.lex_state = 40},
  [979] = {.lex_state = 0, .external_lex_state = 3},
  [980] = {.lex_state = 0, .external_lex_state = 3},
  [981] = {.lex_state = 0},
  [982] = {.lex_state = 0, .external_lex_state = 3},
  [983] = {.lex_state = 0, .external_lex_state = 3},
  [984] = {.lex_state = 0, .external_lex_state = 6},
  [985] = {.lex_state = 0, .external_lex_state = 3},
  [986] = {.lex_state = 251},
  [987] = {.lex_state = 0, .external_lex_state = 6},
  [988] = {.lex_state = 0, .external_lex_state = 3},
  [989] = {.lex_state = 0},
  [990] = {.lex_state = 0},
  [991] = {.lex_state = 0, .external_lex_state = 3},
  [992] = {.lex_state = 0, .external_lex_state = 6},
  [993] = {.lex_state = 0, .external_lex_state = 3},
  [994] = {.lex_state = 0, .external_lex_state = 3},
  [995] = {.lex_state = 37},
  [996] = {.lex_state = 37},
  [997] = {.lex_state = 37},
  [998] = {.lex_state = 37},
  [999] = {.lex_state = 37},
  [1000] = {.lex_state = 0, .external_lex_state = 3},
  [1001] = {.lex_state = 37},
  [1002] = {.lex_state = 0, .external_lex_state = 3},
  [1003] = {.lex_state = 0, .external_lex_state = 3},
  [1004] = {.lex_state = 0, .external_lex_state = 3},
  [1005] = {.lex_state = 0, .external_lex_state = 6},
  [1006] = {.lex_state = 0, .external_lex_state = 6},
  [1007] = {.lex_state = 0},
  [1008] = {.lex_state = 0, .external_lex_state = 6},
  [1009] = {.lex_state = 0, .external_lex_state = 6},
  [1010] = {.lex_state = 0, .external_lex_state = 3},
  [1011] = {.lex_state = 0, .external_lex_state = 3},
  [1012] = {.lex_state = 0, .external_lex_state = 3},
  [1013] = {.lex_state = 0, .external_lex_state = 6},
  [1014] = {.lex_state = 0, .external_lex_state = 6},
  [1015] = {.lex_state = 37},
  [1016] = {.lex_state = 0, .external_lex_state = 6},
  [1017] = {.lex_state = 0, .external_lex_state = 6},
  [1018] = {.lex_state = 37},
  [1019] = {.lex_state = 343},
  [1020] = {.lex_state = 0, .external_lex_state = 6},
  [1021] = {.lex_state = 0, .external_lex_state = 6},
  [1022] = {.lex_state = 251},
  [1023] = {.lex_state = 0, .external_lex_state = 6},
  [1024] = {.lex_state = 0, .external_lex_state = 6},
  [1025] = {.lex_state = 37},
  [1026] = {.lex_state = 0, .external_lex_state = 3},
  [1027] = {.lex_state = 0, .external_lex_state = 6},
  [1028] = {.lex_state = 0, .external_lex_state = 6},
  [1029] = {.lex_state = 0, .external_lex_state = 3},
  [1030] = {.lex_state = 0, .external_lex_state = 6},
  [1031] = {.lex_state = 0, .external_lex_state = 6},
  [1032] = {.lex_state = 0, .external_lex_state = 6},
  [1033] = {.lex_state = 0, .external_lex_state = 6},
  [1034] = {.lex_state = 0, .external_lex_state = 6},
  [1035] = {.lex_state = 0, .external_lex_state = 6},
  [1036] = {.lex_state = 42},
  [1037] = {.lex_state = 0, .external_lex_state = 3},
  [1038] = {.lex_state = 0},
  [1039] = {.lex_state = 0, .external_lex_state = 3},
  [1040] = {.lex_state = 0, .external_lex_state = 3},
  [1041] = {.lex_state = 42},
  [1042] = {.lex_state = 0, .external_lex_state = 3},
  [1043] = {.lex_state = 0},
  [1044] = {.lex_state = 0, .external_lex_state = 3},
  [1045] = {.lex_state = 0, .external_lex_state = 3},
  [1046] = {.lex_state = 0, .external_lex_state = 3},
  [1047] = {.lex_state = 0},
  [1048] = {.lex_state = 0, .external_lex_state = 3},
  [1049] = {.lex_state = 0, .external_lex_state = 3},
  [1050] = {.lex_state = 0, .external_lex_state = 3},
  [1051] = {.lex_state = 0},
  [1052] = {.lex_state = 0, .external_lex_state = 3},
  [1053] = {.lex_state = 0, .external_lex_state = 3},
  [1054] = {.lex_state = 0, .external_lex_state = 3},
  [1055] = {.lex_state = 0, .external_lex_state = 3},
  [1056] = {.lex_state = 0, .external_lex_state = 3},
  [1057] = {.lex_state = 0, .external_lex_state = 3},
  [1058] = {.lex_state = 251},
  [1059] = {.lex_state = 37},
  [1060] = {.lex_state = 343},
  [1061] = {.lex_state = 0, .external_lex_state = 3},
};

enum {
  ts_external_token__newline = 0,
  ts_external_token__indent = 1,
  ts_external_token__dedent = 2,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__newline] = sym__newline,
  [ts_external_token__indent] = sym__indent,
  [ts_external_token__dedent] = sym__dedent,
};

static const bool ts_external_scanner_states[7][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__newline] = true,
    [ts_external_token__indent] = true,
    [ts_external_token__dedent] = true,
  },
  [2] = {
    [ts_external_token__newline] = true,
    [ts_external_token__dedent] = true,
  },
  [3] = {
    [ts_external_token__newline] = true,
  },
  [4] = {
    [ts_external_token__indent] = true,
    [ts_external_token__dedent] = true,
  },
  [5] = {
    [ts_external_token__dedent] = true,
  },
  [6] = {
    [ts_external_token__indent] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_doctype] = ACTIONS(1),
    [anon_sym_html] = ACTIONS(1),
    [anon_sym_strict] = ACTIONS(1),
    [anon_sym_xml] = ACTIONS(1),
    [anon_sym_transitional] = ACTIONS(1),
    [anon_sym_frameset] = ACTIONS(1),
    [anon_sym_1_DOT1] = ACTIONS(1),
    [anon_sym_basic] = ACTIONS(1),
    [anon_sym_mobile] = ACTIONS(1),
    [anon_sym_plist] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_each] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_mixin] = ACTIONS(1),
    [anon_sym_block] = ACTIONS(1),
    [anon_sym_append] = ACTIONS(1),
    [anon_sym_prepend] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_unless] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_elseif] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_when] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_script_DOT] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [aux_sym__template_attribute_value_token1] = ACTIONS(1),
    [aux_sym__array_attribute_value_token1] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_SLASH_SLASH_DASH] = ACTIONS(1),
    [sym_class] = ACTIONS(1),
    [aux_sym_angular_attribute_name_token1] = ACTIONS(1),
    [aux_sym_angular_attribute_name_token3] = ACTIONS(1),
    [aux_sym_angular_attribute_name_token4] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_POUND_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [sym__newline] = ACTIONS(1),
    [sym__indent] = ACTIONS(1),
    [sym__dedent] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(961),
    [sym_doctype] = STATE(11),
    [sym_pipe] = STATE(11),
    [sym_include] = STATE(11),
    [sym_while] = STATE(11),
    [sym_each] = STATE(11),
    [sym_mixin_use] = STATE(11),
    [sym_mixin_definition] = STATE(11),
    [sym_block_definition] = STATE(11),
    [sym_block_append] = STATE(11),
    [sym_block_prepend] = STATE(11),
    [sym_extends] = STATE(11),
    [sym_filter] = STATE(11),
    [sym_conditional] = STATE(11),
    [sym_case] = STATE(11),
    [sym_unescaped_buffered_code] = STATE(11),
    [sym_buffered_code] = STATE(11),
    [sym_script_block] = STATE(11),
    [sym_tag] = STATE(11),
    [sym_comment] = STATE(11),
    [sym__comment] = STATE(333),
    [sym__comment_not_first_line] = STATE(333),
    [sym_unbuffered_code] = STATE(11),
    [aux_sym_source_file_repeat1] = STATE(11),
    [ts_builtin_sym_end] = ACTIONS(3),
    [anon_sym_doctype] = ACTIONS(5),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_include] = ACTIONS(9),
    [anon_sym_while] = ACTIONS(11),
    [anon_sym_else] = ACTIONS(13),
    [anon_sym_each] = ACTIONS(15),
    [anon_sym_for] = ACTIONS(15),
    [anon_sym_PLUS] = ACTIONS(17),
    [anon_sym_mixin] = ACTIONS(19),
    [anon_sym_block] = ACTIONS(21),
    [anon_sym_append] = ACTIONS(23),
    [anon_sym_prepend] = ACTIONS(25),
    [anon_sym_extends] = ACTIONS(27),
    [anon_sym_COLON] = ACTIONS(29),
    [anon_sym_unless] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_elseif] = ACTIONS(33),
    [anon_sym_case] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(37),
    [anon_sym_EQ] = ACTIONS(39),
    [anon_sym_script_DOT] = ACTIONS(41),
    [anon_sym_SLASH_SLASH] = ACTIONS(43),
    [anon_sym_SLASH_SLASH_DASH] = ACTIONS(45),
    [sym_tag_name] = ACTIONS(47),
    [sym_class] = ACTIONS(49),
    [sym_id] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 28,
    ACTIONS(55), 1,
      anon_sym_doctype,
    ACTIONS(57), 1,
      anon_sym_PIPE,
    ACTIONS(59), 1,
      anon_sym_include,
    ACTIONS(61), 1,
      anon_sym_while,
    ACTIONS(63), 1,
      anon_sym_else,
    ACTIONS(69), 1,
      anon_sym_block,
    ACTIONS(71), 1,
      anon_sym_append,
    ACTIONS(73), 1,
      anon_sym_prepend,
    ACTIONS(75), 1,
      anon_sym_extends,
    ACTIONS(77), 1,
      anon_sym_COLON,
    ACTIONS(81), 1,
      anon_sym_elseif,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_BANG_EQ,
    ACTIONS(87), 1,
      anon_sym_EQ,
    ACTIONS(89), 1,
      anon_sym_script_DOT,
    ACTIONS(91), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(93), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(95), 1,
      sym_tag_name,
    ACTIONS(99), 1,
      anon_sym_DASH,
    ACTIONS(101), 1,
      sym__newline,
    ACTIONS(103), 1,
      sym__dedent,
    ACTIONS(53), 2,
      ts_builtin_sym_end,
      anon_sym_PLUS,
    ACTIONS(65), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(79), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(97), 2,
      sym_class,
      sym_id,
    STATE(124), 2,
      sym__comment,
      sym__comment_not_first_line,
    ACTIONS(67), 3,
      anon_sym_mixin,
      anon_sym_when,
      anon_sym_default,
    STATE(3), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [111] = 27,
    ACTIONS(107), 1,
      anon_sym_doctype,
    ACTIONS(110), 1,
      anon_sym_PIPE,
    ACTIONS(113), 1,
      anon_sym_include,
    ACTIONS(116), 1,
      anon_sym_while,
    ACTIONS(119), 1,
      anon_sym_else,
    ACTIONS(127), 1,
      anon_sym_block,
    ACTIONS(130), 1,
      anon_sym_append,
    ACTIONS(133), 1,
      anon_sym_prepend,
    ACTIONS(136), 1,
      anon_sym_extends,
    ACTIONS(139), 1,
      anon_sym_COLON,
    ACTIONS(145), 1,
      anon_sym_elseif,
    ACTIONS(148), 1,
      anon_sym_case,
    ACTIONS(151), 1,
      anon_sym_BANG_EQ,
    ACTIONS(154), 1,
      anon_sym_EQ,
    ACTIONS(157), 1,
      anon_sym_script_DOT,
    ACTIONS(160), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(163), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(166), 1,
      sym_tag_name,
    ACTIONS(172), 1,
      anon_sym_DASH,
    ACTIONS(175), 1,
      sym__newline,
    ACTIONS(122), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(142), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(169), 2,
      sym_class,
      sym_id,
    STATE(124), 2,
      sym__comment,
      sym__comment_not_first_line,
    ACTIONS(105), 3,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PLUS,
    ACTIONS(125), 3,
      anon_sym_mixin,
      anon_sym_when,
      anon_sym_default,
    STATE(3), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [220] = 28,
    ACTIONS(55), 1,
      anon_sym_doctype,
    ACTIONS(57), 1,
      anon_sym_PIPE,
    ACTIONS(59), 1,
      anon_sym_include,
    ACTIONS(61), 1,
      anon_sym_while,
    ACTIONS(63), 1,
      anon_sym_else,
    ACTIONS(69), 1,
      anon_sym_block,
    ACTIONS(71), 1,
      anon_sym_append,
    ACTIONS(73), 1,
      anon_sym_prepend,
    ACTIONS(75), 1,
      anon_sym_extends,
    ACTIONS(77), 1,
      anon_sym_COLON,
    ACTIONS(81), 1,
      anon_sym_elseif,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_BANG_EQ,
    ACTIONS(87), 1,
      anon_sym_EQ,
    ACTIONS(89), 1,
      anon_sym_script_DOT,
    ACTIONS(91), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(93), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(95), 1,
      sym_tag_name,
    ACTIONS(99), 1,
      anon_sym_DASH,
    ACTIONS(101), 1,
      sym__newline,
    ACTIONS(178), 1,
      sym__dedent,
    ACTIONS(53), 2,
      ts_builtin_sym_end,
      anon_sym_PLUS,
    ACTIONS(65), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(79), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(97), 2,
      sym_class,
      sym_id,
    STATE(124), 2,
      sym__comment,
      sym__comment_not_first_line,
    ACTIONS(67), 3,
      anon_sym_mixin,
      anon_sym_when,
      anon_sym_default,
    STATE(3), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [331] = 28,
    ACTIONS(67), 1,
      anon_sym_mixin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(180), 1,
      anon_sym_doctype,
    ACTIONS(182), 1,
      anon_sym_PIPE,
    ACTIONS(184), 1,
      anon_sym_include,
    ACTIONS(186), 1,
      anon_sym_while,
    ACTIONS(188), 1,
      anon_sym_else,
    ACTIONS(192), 1,
      anon_sym_block,
    ACTIONS(194), 1,
      anon_sym_append,
    ACTIONS(196), 1,
      anon_sym_prepend,
    ACTIONS(198), 1,
      anon_sym_extends,
    ACTIONS(200), 1,
      anon_sym_COLON,
    ACTIONS(204), 1,
      anon_sym_elseif,
    ACTIONS(206), 1,
      anon_sym_BANG_EQ,
    ACTIONS(208), 1,
      anon_sym_EQ,
    ACTIONS(210), 1,
      anon_sym_script_DOT,
    ACTIONS(212), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(214), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(216), 1,
      sym_tag_name,
    ACTIONS(220), 1,
      anon_sym_DASH,
    ACTIONS(222), 1,
      sym__newline,
    ACTIONS(224), 1,
      sym__dedent,
    ACTIONS(53), 2,
      ts_builtin_sym_end,
      anon_sym_PLUS,
    ACTIONS(190), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(202), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(218), 2,
      sym_class,
      sym_id,
    STATE(242), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(6), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [440] = 27,
    ACTIONS(125), 1,
      anon_sym_mixin,
    ACTIONS(148), 1,
      anon_sym_case,
    ACTIONS(226), 1,
      anon_sym_doctype,
    ACTIONS(229), 1,
      anon_sym_PIPE,
    ACTIONS(232), 1,
      anon_sym_include,
    ACTIONS(235), 1,
      anon_sym_while,
    ACTIONS(238), 1,
      anon_sym_else,
    ACTIONS(244), 1,
      anon_sym_block,
    ACTIONS(247), 1,
      anon_sym_append,
    ACTIONS(250), 1,
      anon_sym_prepend,
    ACTIONS(253), 1,
      anon_sym_extends,
    ACTIONS(256), 1,
      anon_sym_COLON,
    ACTIONS(262), 1,
      anon_sym_elseif,
    ACTIONS(265), 1,
      anon_sym_BANG_EQ,
    ACTIONS(268), 1,
      anon_sym_EQ,
    ACTIONS(271), 1,
      anon_sym_script_DOT,
    ACTIONS(274), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(277), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(280), 1,
      sym_tag_name,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      sym__newline,
    ACTIONS(241), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(259), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(283), 2,
      sym_class,
      sym_id,
    STATE(242), 2,
      sym__comment,
      sym__comment_not_first_line,
    ACTIONS(105), 3,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PLUS,
    STATE(6), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [547] = 28,
    ACTIONS(67), 1,
      anon_sym_mixin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(180), 1,
      anon_sym_doctype,
    ACTIONS(182), 1,
      anon_sym_PIPE,
    ACTIONS(184), 1,
      anon_sym_include,
    ACTIONS(186), 1,
      anon_sym_while,
    ACTIONS(188), 1,
      anon_sym_else,
    ACTIONS(192), 1,
      anon_sym_block,
    ACTIONS(194), 1,
      anon_sym_append,
    ACTIONS(196), 1,
      anon_sym_prepend,
    ACTIONS(198), 1,
      anon_sym_extends,
    ACTIONS(200), 1,
      anon_sym_COLON,
    ACTIONS(204), 1,
      anon_sym_elseif,
    ACTIONS(206), 1,
      anon_sym_BANG_EQ,
    ACTIONS(208), 1,
      anon_sym_EQ,
    ACTIONS(210), 1,
      anon_sym_script_DOT,
    ACTIONS(212), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(214), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(216), 1,
      sym_tag_name,
    ACTIONS(220), 1,
      anon_sym_DASH,
    ACTIONS(222), 1,
      sym__newline,
    ACTIONS(292), 1,
      sym__dedent,
    ACTIONS(53), 2,
      ts_builtin_sym_end,
      anon_sym_PLUS,
    ACTIONS(190), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(202), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(218), 2,
      sym_class,
      sym_id,
    STATE(242), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(6), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [656] = 27,
    ACTIONS(294), 1,
      ts_builtin_sym_end,
    ACTIONS(296), 1,
      anon_sym_doctype,
    ACTIONS(299), 1,
      anon_sym_PIPE,
    ACTIONS(302), 1,
      anon_sym_include,
    ACTIONS(305), 1,
      anon_sym_while,
    ACTIONS(308), 1,
      anon_sym_else,
    ACTIONS(314), 1,
      anon_sym_PLUS,
    ACTIONS(317), 1,
      anon_sym_mixin,
    ACTIONS(320), 1,
      anon_sym_block,
    ACTIONS(323), 1,
      anon_sym_append,
    ACTIONS(326), 1,
      anon_sym_prepend,
    ACTIONS(329), 1,
      anon_sym_extends,
    ACTIONS(332), 1,
      anon_sym_COLON,
    ACTIONS(338), 1,
      anon_sym_elseif,
    ACTIONS(341), 1,
      anon_sym_case,
    ACTIONS(344), 1,
      anon_sym_BANG_EQ,
    ACTIONS(347), 1,
      anon_sym_EQ,
    ACTIONS(350), 1,
      anon_sym_script_DOT,
    ACTIONS(353), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(356), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(359), 1,
      sym_tag_name,
    ACTIONS(365), 1,
      anon_sym_DASH,
    ACTIONS(311), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(335), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(362), 2,
      sym_class,
      sym_id,
    STATE(333), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(8), 21,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_mixin_use,
      sym_mixin_definition,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_source_file_repeat1,
  [762] = 27,
    ACTIONS(105), 1,
      sym__dedent,
    ACTIONS(368), 1,
      anon_sym_doctype,
    ACTIONS(371), 1,
      anon_sym_PIPE,
    ACTIONS(374), 1,
      anon_sym_include,
    ACTIONS(377), 1,
      anon_sym_while,
    ACTIONS(380), 1,
      anon_sym_else,
    ACTIONS(386), 1,
      anon_sym_block,
    ACTIONS(389), 1,
      anon_sym_append,
    ACTIONS(392), 1,
      anon_sym_prepend,
    ACTIONS(395), 1,
      anon_sym_extends,
    ACTIONS(398), 1,
      anon_sym_COLON,
    ACTIONS(404), 1,
      anon_sym_elseif,
    ACTIONS(407), 1,
      anon_sym_case,
    ACTIONS(410), 1,
      anon_sym_BANG_EQ,
    ACTIONS(413), 1,
      anon_sym_EQ,
    ACTIONS(416), 1,
      anon_sym_script_DOT,
    ACTIONS(419), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(422), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(425), 1,
      sym_tag_name,
    ACTIONS(431), 1,
      anon_sym_DASH,
    ACTIONS(434), 1,
      sym__newline,
    ACTIONS(125), 2,
      anon_sym_when,
      anon_sym_default,
    ACTIONS(383), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(401), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(428), 2,
      sym_class,
      sym_id,
    STATE(255), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(9), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [868] = 27,
    ACTIONS(437), 1,
      anon_sym_doctype,
    ACTIONS(439), 1,
      anon_sym_PIPE,
    ACTIONS(441), 1,
      anon_sym_include,
    ACTIONS(443), 1,
      anon_sym_while,
    ACTIONS(445), 1,
      anon_sym_else,
    ACTIONS(449), 1,
      anon_sym_block,
    ACTIONS(451), 1,
      anon_sym_append,
    ACTIONS(453), 1,
      anon_sym_prepend,
    ACTIONS(455), 1,
      anon_sym_extends,
    ACTIONS(457), 1,
      anon_sym_COLON,
    ACTIONS(461), 1,
      anon_sym_elseif,
    ACTIONS(463), 1,
      anon_sym_case,
    ACTIONS(465), 1,
      anon_sym_BANG_EQ,
    ACTIONS(467), 1,
      anon_sym_EQ,
    ACTIONS(469), 1,
      anon_sym_script_DOT,
    ACTIONS(471), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(473), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(475), 1,
      sym_tag_name,
    ACTIONS(479), 1,
      anon_sym_DASH,
    ACTIONS(481), 1,
      sym__newline,
    ACTIONS(483), 1,
      sym__dedent,
    ACTIONS(67), 2,
      anon_sym_when,
      anon_sym_default,
    ACTIONS(447), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(459), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(477), 2,
      sym_class,
      sym_id,
    STATE(255), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(9), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [974] = 27,
    ACTIONS(5), 1,
      anon_sym_doctype,
    ACTIONS(7), 1,
      anon_sym_PIPE,
    ACTIONS(9), 1,
      anon_sym_include,
    ACTIONS(11), 1,
      anon_sym_while,
    ACTIONS(13), 1,
      anon_sym_else,
    ACTIONS(17), 1,
      anon_sym_PLUS,
    ACTIONS(19), 1,
      anon_sym_mixin,
    ACTIONS(21), 1,
      anon_sym_block,
    ACTIONS(23), 1,
      anon_sym_append,
    ACTIONS(25), 1,
      anon_sym_prepend,
    ACTIONS(27), 1,
      anon_sym_extends,
    ACTIONS(29), 1,
      anon_sym_COLON,
    ACTIONS(33), 1,
      anon_sym_elseif,
    ACTIONS(35), 1,
      anon_sym_case,
    ACTIONS(37), 1,
      anon_sym_BANG_EQ,
    ACTIONS(39), 1,
      anon_sym_EQ,
    ACTIONS(41), 1,
      anon_sym_script_DOT,
    ACTIONS(43), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(45), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(47), 1,
      sym_tag_name,
    ACTIONS(51), 1,
      anon_sym_DASH,
    ACTIONS(485), 1,
      ts_builtin_sym_end,
    ACTIONS(15), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(31), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(49), 2,
      sym_class,
      sym_id,
    STATE(333), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(8), 21,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_mixin_use,
      sym_mixin_definition,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_source_file_repeat1,
  [1080] = 26,
    ACTIONS(463), 1,
      anon_sym_case,
    ACTIONS(487), 1,
      anon_sym_doctype,
    ACTIONS(489), 1,
      anon_sym_PIPE,
    ACTIONS(491), 1,
      anon_sym_include,
    ACTIONS(493), 1,
      anon_sym_while,
    ACTIONS(495), 1,
      anon_sym_else,
    ACTIONS(499), 1,
      anon_sym_block,
    ACTIONS(501), 1,
      anon_sym_append,
    ACTIONS(503), 1,
      anon_sym_prepend,
    ACTIONS(505), 1,
      anon_sym_extends,
    ACTIONS(507), 1,
      anon_sym_COLON,
    ACTIONS(511), 1,
      anon_sym_elseif,
    ACTIONS(513), 1,
      anon_sym_BANG_EQ,
    ACTIONS(515), 1,
      anon_sym_EQ,
    ACTIONS(517), 1,
      anon_sym_script_DOT,
    ACTIONS(519), 1,
      anon_sym_DOT,
    ACTIONS(521), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(523), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(525), 1,
      sym_tag_name,
    ACTIONS(529), 1,
      anon_sym_DASH,
    ACTIONS(531), 1,
      sym__newline,
    ACTIONS(497), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(509), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(527), 2,
      sym_class,
      sym_id,
    STATE(376), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(40), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [1182] = 26,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(180), 1,
      anon_sym_doctype,
    ACTIONS(182), 1,
      anon_sym_PIPE,
    ACTIONS(184), 1,
      anon_sym_include,
    ACTIONS(186), 1,
      anon_sym_while,
    ACTIONS(188), 1,
      anon_sym_else,
    ACTIONS(192), 1,
      anon_sym_block,
    ACTIONS(194), 1,
      anon_sym_append,
    ACTIONS(196), 1,
      anon_sym_prepend,
    ACTIONS(198), 1,
      anon_sym_extends,
    ACTIONS(200), 1,
      anon_sym_COLON,
    ACTIONS(204), 1,
      anon_sym_elseif,
    ACTIONS(206), 1,
      anon_sym_BANG_EQ,
    ACTIONS(208), 1,
      anon_sym_EQ,
    ACTIONS(210), 1,
      anon_sym_script_DOT,
    ACTIONS(212), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(214), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(216), 1,
      sym_tag_name,
    ACTIONS(220), 1,
      anon_sym_DASH,
    ACTIONS(533), 1,
      anon_sym_DOT,
    ACTIONS(535), 1,
      sym__newline,
    ACTIONS(190), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(202), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(218), 2,
      sym_class,
      sym_id,
    STATE(242), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(7), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [1284] = 26,
    ACTIONS(55), 1,
      anon_sym_doctype,
    ACTIONS(57), 1,
      anon_sym_PIPE,
    ACTIONS(59), 1,
      anon_sym_include,
    ACTIONS(61), 1,
      anon_sym_while,
    ACTIONS(63), 1,
      anon_sym_else,
    ACTIONS(69), 1,
      anon_sym_block,
    ACTIONS(71), 1,
      anon_sym_append,
    ACTIONS(73), 1,
      anon_sym_prepend,
    ACTIONS(75), 1,
      anon_sym_extends,
    ACTIONS(77), 1,
      anon_sym_COLON,
    ACTIONS(81), 1,
      anon_sym_elseif,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_BANG_EQ,
    ACTIONS(87), 1,
      anon_sym_EQ,
    ACTIONS(89), 1,
      anon_sym_script_DOT,
    ACTIONS(91), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(93), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(95), 1,
      sym_tag_name,
    ACTIONS(99), 1,
      anon_sym_DASH,
    ACTIONS(537), 1,
      anon_sym_DOT,
    ACTIONS(539), 1,
      sym__newline,
    ACTIONS(65), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(79), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(97), 2,
      sym_class,
      sym_id,
    STATE(124), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(4), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [1386] = 26,
    ACTIONS(463), 1,
      anon_sym_case,
    ACTIONS(487), 1,
      anon_sym_doctype,
    ACTIONS(489), 1,
      anon_sym_PIPE,
    ACTIONS(491), 1,
      anon_sym_include,
    ACTIONS(493), 1,
      anon_sym_while,
    ACTIONS(495), 1,
      anon_sym_else,
    ACTIONS(499), 1,
      anon_sym_block,
    ACTIONS(501), 1,
      anon_sym_append,
    ACTIONS(503), 1,
      anon_sym_prepend,
    ACTIONS(505), 1,
      anon_sym_extends,
    ACTIONS(507), 1,
      anon_sym_COLON,
    ACTIONS(511), 1,
      anon_sym_elseif,
    ACTIONS(513), 1,
      anon_sym_BANG_EQ,
    ACTIONS(515), 1,
      anon_sym_EQ,
    ACTIONS(517), 1,
      anon_sym_script_DOT,
    ACTIONS(521), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(523), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(525), 1,
      sym_tag_name,
    ACTIONS(529), 1,
      anon_sym_DASH,
    ACTIONS(541), 1,
      anon_sym_DOT,
    ACTIONS(543), 1,
      sym__newline,
    ACTIONS(497), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(509), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(527), 2,
      sym_class,
      sym_id,
    STATE(376), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(21), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [1488] = 26,
    ACTIONS(55), 1,
      anon_sym_doctype,
    ACTIONS(57), 1,
      anon_sym_PIPE,
    ACTIONS(59), 1,
      anon_sym_include,
    ACTIONS(61), 1,
      anon_sym_while,
    ACTIONS(63), 1,
      anon_sym_else,
    ACTIONS(69), 1,
      anon_sym_block,
    ACTIONS(71), 1,
      anon_sym_append,
    ACTIONS(73), 1,
      anon_sym_prepend,
    ACTIONS(75), 1,
      anon_sym_extends,
    ACTIONS(77), 1,
      anon_sym_COLON,
    ACTIONS(81), 1,
      anon_sym_elseif,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_BANG_EQ,
    ACTIONS(87), 1,
      anon_sym_EQ,
    ACTIONS(89), 1,
      anon_sym_script_DOT,
    ACTIONS(91), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(93), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(95), 1,
      sym_tag_name,
    ACTIONS(99), 1,
      anon_sym_DASH,
    ACTIONS(545), 1,
      anon_sym_DOT,
    ACTIONS(547), 1,
      sym__newline,
    ACTIONS(65), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(79), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(97), 2,
      sym_class,
      sym_id,
    STATE(124), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(2), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [1590] = 26,
    ACTIONS(463), 1,
      anon_sym_case,
    ACTIONS(487), 1,
      anon_sym_doctype,
    ACTIONS(489), 1,
      anon_sym_PIPE,
    ACTIONS(491), 1,
      anon_sym_include,
    ACTIONS(493), 1,
      anon_sym_while,
    ACTIONS(495), 1,
      anon_sym_else,
    ACTIONS(499), 1,
      anon_sym_block,
    ACTIONS(501), 1,
      anon_sym_append,
    ACTIONS(503), 1,
      anon_sym_prepend,
    ACTIONS(505), 1,
      anon_sym_extends,
    ACTIONS(507), 1,
      anon_sym_COLON,
    ACTIONS(511), 1,
      anon_sym_elseif,
    ACTIONS(513), 1,
      anon_sym_BANG_EQ,
    ACTIONS(515), 1,
      anon_sym_EQ,
    ACTIONS(517), 1,
      anon_sym_script_DOT,
    ACTIONS(521), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(523), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(525), 1,
      sym_tag_name,
    ACTIONS(529), 1,
      anon_sym_DASH,
    ACTIONS(541), 1,
      anon_sym_DOT,
    ACTIONS(543), 1,
      sym__newline,
    ACTIONS(497), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(509), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(527), 2,
      sym_class,
      sym_id,
    STATE(376), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(21), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [1692] = 26,
    ACTIONS(55), 1,
      anon_sym_doctype,
    ACTIONS(57), 1,
      anon_sym_PIPE,
    ACTIONS(59), 1,
      anon_sym_include,
    ACTIONS(61), 1,
      anon_sym_while,
    ACTIONS(63), 1,
      anon_sym_else,
    ACTIONS(69), 1,
      anon_sym_block,
    ACTIONS(71), 1,
      anon_sym_append,
    ACTIONS(73), 1,
      anon_sym_prepend,
    ACTIONS(75), 1,
      anon_sym_extends,
    ACTIONS(77), 1,
      anon_sym_COLON,
    ACTIONS(81), 1,
      anon_sym_elseif,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_BANG_EQ,
    ACTIONS(87), 1,
      anon_sym_EQ,
    ACTIONS(89), 1,
      anon_sym_script_DOT,
    ACTIONS(91), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(93), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(95), 1,
      sym_tag_name,
    ACTIONS(99), 1,
      anon_sym_DASH,
    ACTIONS(537), 1,
      anon_sym_DOT,
    ACTIONS(539), 1,
      sym__newline,
    ACTIONS(65), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(79), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(97), 2,
      sym_class,
      sym_id,
    STATE(124), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(4), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [1794] = 26,
    ACTIONS(55), 1,
      anon_sym_doctype,
    ACTIONS(57), 1,
      anon_sym_PIPE,
    ACTIONS(59), 1,
      anon_sym_include,
    ACTIONS(61), 1,
      anon_sym_while,
    ACTIONS(63), 1,
      anon_sym_else,
    ACTIONS(69), 1,
      anon_sym_block,
    ACTIONS(71), 1,
      anon_sym_append,
    ACTIONS(73), 1,
      anon_sym_prepend,
    ACTIONS(75), 1,
      anon_sym_extends,
    ACTIONS(77), 1,
      anon_sym_COLON,
    ACTIONS(81), 1,
      anon_sym_elseif,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_BANG_EQ,
    ACTIONS(87), 1,
      anon_sym_EQ,
    ACTIONS(89), 1,
      anon_sym_script_DOT,
    ACTIONS(91), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(93), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(95), 1,
      sym_tag_name,
    ACTIONS(99), 1,
      anon_sym_DASH,
    ACTIONS(537), 1,
      anon_sym_DOT,
    ACTIONS(539), 1,
      sym__newline,
    ACTIONS(65), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(79), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(97), 2,
      sym_class,
      sym_id,
    STATE(124), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(4), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [1896] = 26,
    ACTIONS(55), 1,
      anon_sym_doctype,
    ACTIONS(57), 1,
      anon_sym_PIPE,
    ACTIONS(59), 1,
      anon_sym_include,
    ACTIONS(61), 1,
      anon_sym_while,
    ACTIONS(63), 1,
      anon_sym_else,
    ACTIONS(69), 1,
      anon_sym_block,
    ACTIONS(71), 1,
      anon_sym_append,
    ACTIONS(73), 1,
      anon_sym_prepend,
    ACTIONS(75), 1,
      anon_sym_extends,
    ACTIONS(77), 1,
      anon_sym_COLON,
    ACTIONS(81), 1,
      anon_sym_elseif,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_BANG_EQ,
    ACTIONS(87), 1,
      anon_sym_EQ,
    ACTIONS(89), 1,
      anon_sym_script_DOT,
    ACTIONS(91), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(93), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(95), 1,
      sym_tag_name,
    ACTIONS(99), 1,
      anon_sym_DASH,
    ACTIONS(537), 1,
      anon_sym_DOT,
    ACTIONS(539), 1,
      sym__newline,
    ACTIONS(65), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(79), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(97), 2,
      sym_class,
      sym_id,
    STATE(124), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(4), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [1998] = 26,
    ACTIONS(463), 1,
      anon_sym_case,
    ACTIONS(487), 1,
      anon_sym_doctype,
    ACTIONS(489), 1,
      anon_sym_PIPE,
    ACTIONS(491), 1,
      anon_sym_include,
    ACTIONS(493), 1,
      anon_sym_while,
    ACTIONS(495), 1,
      anon_sym_else,
    ACTIONS(499), 1,
      anon_sym_block,
    ACTIONS(501), 1,
      anon_sym_append,
    ACTIONS(503), 1,
      anon_sym_prepend,
    ACTIONS(505), 1,
      anon_sym_extends,
    ACTIONS(507), 1,
      anon_sym_COLON,
    ACTIONS(511), 1,
      anon_sym_elseif,
    ACTIONS(513), 1,
      anon_sym_BANG_EQ,
    ACTIONS(515), 1,
      anon_sym_EQ,
    ACTIONS(517), 1,
      anon_sym_script_DOT,
    ACTIONS(521), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(523), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(525), 1,
      sym_tag_name,
    ACTIONS(529), 1,
      anon_sym_DASH,
    ACTIONS(549), 1,
      sym__newline,
    ACTIONS(551), 1,
      sym__dedent,
    ACTIONS(497), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(509), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(527), 2,
      sym_class,
      sym_id,
    STATE(376), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(37), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [2100] = 26,
    ACTIONS(437), 1,
      anon_sym_doctype,
    ACTIONS(439), 1,
      anon_sym_PIPE,
    ACTIONS(441), 1,
      anon_sym_include,
    ACTIONS(443), 1,
      anon_sym_while,
    ACTIONS(445), 1,
      anon_sym_else,
    ACTIONS(449), 1,
      anon_sym_block,
    ACTIONS(451), 1,
      anon_sym_append,
    ACTIONS(453), 1,
      anon_sym_prepend,
    ACTIONS(455), 1,
      anon_sym_extends,
    ACTIONS(457), 1,
      anon_sym_COLON,
    ACTIONS(461), 1,
      anon_sym_elseif,
    ACTIONS(463), 1,
      anon_sym_case,
    ACTIONS(465), 1,
      anon_sym_BANG_EQ,
    ACTIONS(467), 1,
      anon_sym_EQ,
    ACTIONS(469), 1,
      anon_sym_script_DOT,
    ACTIONS(471), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(473), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(475), 1,
      sym_tag_name,
    ACTIONS(479), 1,
      anon_sym_DASH,
    ACTIONS(553), 1,
      anon_sym_DOT,
    ACTIONS(555), 1,
      sym__newline,
    ACTIONS(447), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(459), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(477), 2,
      sym_class,
      sym_id,
    STATE(255), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(10), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [2202] = 26,
    ACTIONS(437), 1,
      anon_sym_doctype,
    ACTIONS(439), 1,
      anon_sym_PIPE,
    ACTIONS(441), 1,
      anon_sym_include,
    ACTIONS(443), 1,
      anon_sym_while,
    ACTIONS(445), 1,
      anon_sym_else,
    ACTIONS(449), 1,
      anon_sym_block,
    ACTIONS(451), 1,
      anon_sym_append,
    ACTIONS(453), 1,
      anon_sym_prepend,
    ACTIONS(455), 1,
      anon_sym_extends,
    ACTIONS(457), 1,
      anon_sym_COLON,
    ACTIONS(461), 1,
      anon_sym_elseif,
    ACTIONS(463), 1,
      anon_sym_case,
    ACTIONS(465), 1,
      anon_sym_BANG_EQ,
    ACTIONS(467), 1,
      anon_sym_EQ,
    ACTIONS(469), 1,
      anon_sym_script_DOT,
    ACTIONS(471), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(473), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(475), 1,
      sym_tag_name,
    ACTIONS(479), 1,
      anon_sym_DASH,
    ACTIONS(553), 1,
      anon_sym_DOT,
    ACTIONS(555), 1,
      sym__newline,
    ACTIONS(447), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(459), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(477), 2,
      sym_class,
      sym_id,
    STATE(255), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(10), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [2304] = 26,
    ACTIONS(437), 1,
      anon_sym_doctype,
    ACTIONS(439), 1,
      anon_sym_PIPE,
    ACTIONS(441), 1,
      anon_sym_include,
    ACTIONS(443), 1,
      anon_sym_while,
    ACTIONS(445), 1,
      anon_sym_else,
    ACTIONS(449), 1,
      anon_sym_block,
    ACTIONS(451), 1,
      anon_sym_append,
    ACTIONS(453), 1,
      anon_sym_prepend,
    ACTIONS(455), 1,
      anon_sym_extends,
    ACTIONS(457), 1,
      anon_sym_COLON,
    ACTIONS(461), 1,
      anon_sym_elseif,
    ACTIONS(463), 1,
      anon_sym_case,
    ACTIONS(465), 1,
      anon_sym_BANG_EQ,
    ACTIONS(467), 1,
      anon_sym_EQ,
    ACTIONS(469), 1,
      anon_sym_script_DOT,
    ACTIONS(471), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(473), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(475), 1,
      sym_tag_name,
    ACTIONS(479), 1,
      anon_sym_DASH,
    ACTIONS(553), 1,
      anon_sym_DOT,
    ACTIONS(555), 1,
      sym__newline,
    ACTIONS(447), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(459), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(477), 2,
      sym_class,
      sym_id,
    STATE(255), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(10), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [2406] = 26,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(180), 1,
      anon_sym_doctype,
    ACTIONS(182), 1,
      anon_sym_PIPE,
    ACTIONS(184), 1,
      anon_sym_include,
    ACTIONS(186), 1,
      anon_sym_while,
    ACTIONS(188), 1,
      anon_sym_else,
    ACTIONS(192), 1,
      anon_sym_block,
    ACTIONS(194), 1,
      anon_sym_append,
    ACTIONS(196), 1,
      anon_sym_prepend,
    ACTIONS(198), 1,
      anon_sym_extends,
    ACTIONS(200), 1,
      anon_sym_COLON,
    ACTIONS(204), 1,
      anon_sym_elseif,
    ACTIONS(206), 1,
      anon_sym_BANG_EQ,
    ACTIONS(208), 1,
      anon_sym_EQ,
    ACTIONS(210), 1,
      anon_sym_script_DOT,
    ACTIONS(212), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(214), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(216), 1,
      sym_tag_name,
    ACTIONS(220), 1,
      anon_sym_DASH,
    ACTIONS(557), 1,
      anon_sym_DOT,
    ACTIONS(559), 1,
      sym__newline,
    ACTIONS(190), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(202), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(218), 2,
      sym_class,
      sym_id,
    STATE(242), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(5), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [2508] = 26,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(180), 1,
      anon_sym_doctype,
    ACTIONS(182), 1,
      anon_sym_PIPE,
    ACTIONS(184), 1,
      anon_sym_include,
    ACTIONS(186), 1,
      anon_sym_while,
    ACTIONS(188), 1,
      anon_sym_else,
    ACTIONS(192), 1,
      anon_sym_block,
    ACTIONS(194), 1,
      anon_sym_append,
    ACTIONS(196), 1,
      anon_sym_prepend,
    ACTIONS(198), 1,
      anon_sym_extends,
    ACTIONS(200), 1,
      anon_sym_COLON,
    ACTIONS(204), 1,
      anon_sym_elseif,
    ACTIONS(206), 1,
      anon_sym_BANG_EQ,
    ACTIONS(208), 1,
      anon_sym_EQ,
    ACTIONS(210), 1,
      anon_sym_script_DOT,
    ACTIONS(212), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(214), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(216), 1,
      sym_tag_name,
    ACTIONS(220), 1,
      anon_sym_DASH,
    ACTIONS(557), 1,
      anon_sym_DOT,
    ACTIONS(559), 1,
      sym__newline,
    ACTIONS(190), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(202), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(218), 2,
      sym_class,
      sym_id,
    STATE(242), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(5), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [2610] = 26,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(180), 1,
      anon_sym_doctype,
    ACTIONS(182), 1,
      anon_sym_PIPE,
    ACTIONS(184), 1,
      anon_sym_include,
    ACTIONS(186), 1,
      anon_sym_while,
    ACTIONS(188), 1,
      anon_sym_else,
    ACTIONS(192), 1,
      anon_sym_block,
    ACTIONS(194), 1,
      anon_sym_append,
    ACTIONS(196), 1,
      anon_sym_prepend,
    ACTIONS(198), 1,
      anon_sym_extends,
    ACTIONS(200), 1,
      anon_sym_COLON,
    ACTIONS(204), 1,
      anon_sym_elseif,
    ACTIONS(206), 1,
      anon_sym_BANG_EQ,
    ACTIONS(208), 1,
      anon_sym_EQ,
    ACTIONS(210), 1,
      anon_sym_script_DOT,
    ACTIONS(212), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(214), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(216), 1,
      sym_tag_name,
    ACTIONS(220), 1,
      anon_sym_DASH,
    ACTIONS(557), 1,
      anon_sym_DOT,
    ACTIONS(559), 1,
      sym__newline,
    ACTIONS(190), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(202), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(218), 2,
      sym_class,
      sym_id,
    STATE(242), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(5), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [2712] = 26,
    ACTIONS(463), 1,
      anon_sym_case,
    ACTIONS(487), 1,
      anon_sym_doctype,
    ACTIONS(489), 1,
      anon_sym_PIPE,
    ACTIONS(491), 1,
      anon_sym_include,
    ACTIONS(493), 1,
      anon_sym_while,
    ACTIONS(495), 1,
      anon_sym_else,
    ACTIONS(499), 1,
      anon_sym_block,
    ACTIONS(501), 1,
      anon_sym_append,
    ACTIONS(503), 1,
      anon_sym_prepend,
    ACTIONS(505), 1,
      anon_sym_extends,
    ACTIONS(507), 1,
      anon_sym_COLON,
    ACTIONS(511), 1,
      anon_sym_elseif,
    ACTIONS(513), 1,
      anon_sym_BANG_EQ,
    ACTIONS(515), 1,
      anon_sym_EQ,
    ACTIONS(517), 1,
      anon_sym_script_DOT,
    ACTIONS(519), 1,
      anon_sym_DOT,
    ACTIONS(521), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(523), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(525), 1,
      sym_tag_name,
    ACTIONS(529), 1,
      anon_sym_DASH,
    ACTIONS(531), 1,
      sym__newline,
    ACTIONS(497), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(509), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(527), 2,
      sym_class,
      sym_id,
    STATE(376), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(40), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [2814] = 26,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(180), 1,
      anon_sym_doctype,
    ACTIONS(182), 1,
      anon_sym_PIPE,
    ACTIONS(184), 1,
      anon_sym_include,
    ACTIONS(186), 1,
      anon_sym_while,
    ACTIONS(188), 1,
      anon_sym_else,
    ACTIONS(192), 1,
      anon_sym_block,
    ACTIONS(194), 1,
      anon_sym_append,
    ACTIONS(196), 1,
      anon_sym_prepend,
    ACTIONS(198), 1,
      anon_sym_extends,
    ACTIONS(200), 1,
      anon_sym_COLON,
    ACTIONS(204), 1,
      anon_sym_elseif,
    ACTIONS(206), 1,
      anon_sym_BANG_EQ,
    ACTIONS(208), 1,
      anon_sym_EQ,
    ACTIONS(210), 1,
      anon_sym_script_DOT,
    ACTIONS(212), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(214), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(216), 1,
      sym_tag_name,
    ACTIONS(220), 1,
      anon_sym_DASH,
    ACTIONS(533), 1,
      anon_sym_DOT,
    ACTIONS(535), 1,
      sym__newline,
    ACTIONS(190), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(202), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(218), 2,
      sym_class,
      sym_id,
    STATE(242), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(7), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [2916] = 26,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(180), 1,
      anon_sym_doctype,
    ACTIONS(182), 1,
      anon_sym_PIPE,
    ACTIONS(184), 1,
      anon_sym_include,
    ACTIONS(186), 1,
      anon_sym_while,
    ACTIONS(188), 1,
      anon_sym_else,
    ACTIONS(192), 1,
      anon_sym_block,
    ACTIONS(194), 1,
      anon_sym_append,
    ACTIONS(196), 1,
      anon_sym_prepend,
    ACTIONS(198), 1,
      anon_sym_extends,
    ACTIONS(200), 1,
      anon_sym_COLON,
    ACTIONS(204), 1,
      anon_sym_elseif,
    ACTIONS(206), 1,
      anon_sym_BANG_EQ,
    ACTIONS(208), 1,
      anon_sym_EQ,
    ACTIONS(210), 1,
      anon_sym_script_DOT,
    ACTIONS(212), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(214), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(216), 1,
      sym_tag_name,
    ACTIONS(220), 1,
      anon_sym_DASH,
    ACTIONS(557), 1,
      anon_sym_DOT,
    ACTIONS(559), 1,
      sym__newline,
    ACTIONS(190), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(202), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(218), 2,
      sym_class,
      sym_id,
    STATE(242), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(5), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [3018] = 26,
    ACTIONS(55), 1,
      anon_sym_doctype,
    ACTIONS(57), 1,
      anon_sym_PIPE,
    ACTIONS(59), 1,
      anon_sym_include,
    ACTIONS(61), 1,
      anon_sym_while,
    ACTIONS(63), 1,
      anon_sym_else,
    ACTIONS(69), 1,
      anon_sym_block,
    ACTIONS(71), 1,
      anon_sym_append,
    ACTIONS(73), 1,
      anon_sym_prepend,
    ACTIONS(75), 1,
      anon_sym_extends,
    ACTIONS(77), 1,
      anon_sym_COLON,
    ACTIONS(81), 1,
      anon_sym_elseif,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_BANG_EQ,
    ACTIONS(87), 1,
      anon_sym_EQ,
    ACTIONS(89), 1,
      anon_sym_script_DOT,
    ACTIONS(91), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(93), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(95), 1,
      sym_tag_name,
    ACTIONS(99), 1,
      anon_sym_DASH,
    ACTIONS(545), 1,
      anon_sym_DOT,
    ACTIONS(547), 1,
      sym__newline,
    ACTIONS(65), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(79), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(97), 2,
      sym_class,
      sym_id,
    STATE(124), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(2), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [3120] = 26,
    ACTIONS(463), 1,
      anon_sym_case,
    ACTIONS(487), 1,
      anon_sym_doctype,
    ACTIONS(489), 1,
      anon_sym_PIPE,
    ACTIONS(491), 1,
      anon_sym_include,
    ACTIONS(493), 1,
      anon_sym_while,
    ACTIONS(495), 1,
      anon_sym_else,
    ACTIONS(499), 1,
      anon_sym_block,
    ACTIONS(501), 1,
      anon_sym_append,
    ACTIONS(503), 1,
      anon_sym_prepend,
    ACTIONS(505), 1,
      anon_sym_extends,
    ACTIONS(507), 1,
      anon_sym_COLON,
    ACTIONS(511), 1,
      anon_sym_elseif,
    ACTIONS(513), 1,
      anon_sym_BANG_EQ,
    ACTIONS(515), 1,
      anon_sym_EQ,
    ACTIONS(517), 1,
      anon_sym_script_DOT,
    ACTIONS(519), 1,
      anon_sym_DOT,
    ACTIONS(521), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(523), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(525), 1,
      sym_tag_name,
    ACTIONS(529), 1,
      anon_sym_DASH,
    ACTIONS(531), 1,
      sym__newline,
    ACTIONS(497), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(509), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(527), 2,
      sym_class,
      sym_id,
    STATE(376), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(40), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [3222] = 26,
    ACTIONS(437), 1,
      anon_sym_doctype,
    ACTIONS(439), 1,
      anon_sym_PIPE,
    ACTIONS(441), 1,
      anon_sym_include,
    ACTIONS(443), 1,
      anon_sym_while,
    ACTIONS(445), 1,
      anon_sym_else,
    ACTIONS(449), 1,
      anon_sym_block,
    ACTIONS(451), 1,
      anon_sym_append,
    ACTIONS(453), 1,
      anon_sym_prepend,
    ACTIONS(455), 1,
      anon_sym_extends,
    ACTIONS(457), 1,
      anon_sym_COLON,
    ACTIONS(461), 1,
      anon_sym_elseif,
    ACTIONS(463), 1,
      anon_sym_case,
    ACTIONS(465), 1,
      anon_sym_BANG_EQ,
    ACTIONS(467), 1,
      anon_sym_EQ,
    ACTIONS(469), 1,
      anon_sym_script_DOT,
    ACTIONS(471), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(473), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(475), 1,
      sym_tag_name,
    ACTIONS(479), 1,
      anon_sym_DASH,
    ACTIONS(553), 1,
      anon_sym_DOT,
    ACTIONS(555), 1,
      sym__newline,
    ACTIONS(447), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(459), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(477), 2,
      sym_class,
      sym_id,
    STATE(255), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(10), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [3324] = 26,
    ACTIONS(463), 1,
      anon_sym_case,
    ACTIONS(487), 1,
      anon_sym_doctype,
    ACTIONS(489), 1,
      anon_sym_PIPE,
    ACTIONS(491), 1,
      anon_sym_include,
    ACTIONS(493), 1,
      anon_sym_while,
    ACTIONS(495), 1,
      anon_sym_else,
    ACTIONS(499), 1,
      anon_sym_block,
    ACTIONS(501), 1,
      anon_sym_append,
    ACTIONS(503), 1,
      anon_sym_prepend,
    ACTIONS(505), 1,
      anon_sym_extends,
    ACTIONS(507), 1,
      anon_sym_COLON,
    ACTIONS(511), 1,
      anon_sym_elseif,
    ACTIONS(513), 1,
      anon_sym_BANG_EQ,
    ACTIONS(515), 1,
      anon_sym_EQ,
    ACTIONS(517), 1,
      anon_sym_script_DOT,
    ACTIONS(521), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(523), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(525), 1,
      sym_tag_name,
    ACTIONS(529), 1,
      anon_sym_DASH,
    ACTIONS(541), 1,
      anon_sym_DOT,
    ACTIONS(543), 1,
      sym__newline,
    ACTIONS(497), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(509), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(527), 2,
      sym_class,
      sym_id,
    STATE(376), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(21), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [3426] = 26,
    ACTIONS(55), 1,
      anon_sym_doctype,
    ACTIONS(57), 1,
      anon_sym_PIPE,
    ACTIONS(59), 1,
      anon_sym_include,
    ACTIONS(61), 1,
      anon_sym_while,
    ACTIONS(63), 1,
      anon_sym_else,
    ACTIONS(69), 1,
      anon_sym_block,
    ACTIONS(71), 1,
      anon_sym_append,
    ACTIONS(73), 1,
      anon_sym_prepend,
    ACTIONS(75), 1,
      anon_sym_extends,
    ACTIONS(77), 1,
      anon_sym_COLON,
    ACTIONS(81), 1,
      anon_sym_elseif,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_BANG_EQ,
    ACTIONS(87), 1,
      anon_sym_EQ,
    ACTIONS(89), 1,
      anon_sym_script_DOT,
    ACTIONS(91), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(93), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(95), 1,
      sym_tag_name,
    ACTIONS(99), 1,
      anon_sym_DASH,
    ACTIONS(545), 1,
      anon_sym_DOT,
    ACTIONS(547), 1,
      sym__newline,
    ACTIONS(65), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(79), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(97), 2,
      sym_class,
      sym_id,
    STATE(124), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(2), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [3528] = 26,
    ACTIONS(463), 1,
      anon_sym_case,
    ACTIONS(487), 1,
      anon_sym_doctype,
    ACTIONS(489), 1,
      anon_sym_PIPE,
    ACTIONS(491), 1,
      anon_sym_include,
    ACTIONS(493), 1,
      anon_sym_while,
    ACTIONS(495), 1,
      anon_sym_else,
    ACTIONS(499), 1,
      anon_sym_block,
    ACTIONS(501), 1,
      anon_sym_append,
    ACTIONS(503), 1,
      anon_sym_prepend,
    ACTIONS(505), 1,
      anon_sym_extends,
    ACTIONS(507), 1,
      anon_sym_COLON,
    ACTIONS(511), 1,
      anon_sym_elseif,
    ACTIONS(513), 1,
      anon_sym_BANG_EQ,
    ACTIONS(515), 1,
      anon_sym_EQ,
    ACTIONS(517), 1,
      anon_sym_script_DOT,
    ACTIONS(521), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(523), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(525), 1,
      sym_tag_name,
    ACTIONS(529), 1,
      anon_sym_DASH,
    ACTIONS(541), 1,
      anon_sym_DOT,
    ACTIONS(543), 1,
      sym__newline,
    ACTIONS(497), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(509), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(527), 2,
      sym_class,
      sym_id,
    STATE(376), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(21), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [3630] = 26,
    ACTIONS(105), 1,
      sym__dedent,
    ACTIONS(407), 1,
      anon_sym_case,
    ACTIONS(561), 1,
      anon_sym_doctype,
    ACTIONS(564), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_include,
    ACTIONS(570), 1,
      anon_sym_while,
    ACTIONS(573), 1,
      anon_sym_else,
    ACTIONS(579), 1,
      anon_sym_block,
    ACTIONS(582), 1,
      anon_sym_append,
    ACTIONS(585), 1,
      anon_sym_prepend,
    ACTIONS(588), 1,
      anon_sym_extends,
    ACTIONS(591), 1,
      anon_sym_COLON,
    ACTIONS(597), 1,
      anon_sym_elseif,
    ACTIONS(600), 1,
      anon_sym_BANG_EQ,
    ACTIONS(603), 1,
      anon_sym_EQ,
    ACTIONS(606), 1,
      anon_sym_script_DOT,
    ACTIONS(609), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(612), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(615), 1,
      sym_tag_name,
    ACTIONS(621), 1,
      anon_sym_DASH,
    ACTIONS(624), 1,
      sym__newline,
    ACTIONS(576), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(594), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(618), 2,
      sym_class,
      sym_id,
    STATE(376), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(37), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [3732] = 26,
    ACTIONS(463), 1,
      anon_sym_case,
    ACTIONS(487), 1,
      anon_sym_doctype,
    ACTIONS(489), 1,
      anon_sym_PIPE,
    ACTIONS(491), 1,
      anon_sym_include,
    ACTIONS(493), 1,
      anon_sym_while,
    ACTIONS(495), 1,
      anon_sym_else,
    ACTIONS(499), 1,
      anon_sym_block,
    ACTIONS(501), 1,
      anon_sym_append,
    ACTIONS(503), 1,
      anon_sym_prepend,
    ACTIONS(505), 1,
      anon_sym_extends,
    ACTIONS(507), 1,
      anon_sym_COLON,
    ACTIONS(511), 1,
      anon_sym_elseif,
    ACTIONS(513), 1,
      anon_sym_BANG_EQ,
    ACTIONS(515), 1,
      anon_sym_EQ,
    ACTIONS(517), 1,
      anon_sym_script_DOT,
    ACTIONS(519), 1,
      anon_sym_DOT,
    ACTIONS(521), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(523), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(525), 1,
      sym_tag_name,
    ACTIONS(529), 1,
      anon_sym_DASH,
    ACTIONS(531), 1,
      sym__newline,
    ACTIONS(497), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(509), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(527), 2,
      sym_class,
      sym_id,
    STATE(376), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(40), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [3834] = 26,
    ACTIONS(55), 1,
      anon_sym_doctype,
    ACTIONS(57), 1,
      anon_sym_PIPE,
    ACTIONS(59), 1,
      anon_sym_include,
    ACTIONS(61), 1,
      anon_sym_while,
    ACTIONS(63), 1,
      anon_sym_else,
    ACTIONS(69), 1,
      anon_sym_block,
    ACTIONS(71), 1,
      anon_sym_append,
    ACTIONS(73), 1,
      anon_sym_prepend,
    ACTIONS(75), 1,
      anon_sym_extends,
    ACTIONS(77), 1,
      anon_sym_COLON,
    ACTIONS(81), 1,
      anon_sym_elseif,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_BANG_EQ,
    ACTIONS(87), 1,
      anon_sym_EQ,
    ACTIONS(89), 1,
      anon_sym_script_DOT,
    ACTIONS(91), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(93), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(95), 1,
      sym_tag_name,
    ACTIONS(99), 1,
      anon_sym_DASH,
    ACTIONS(545), 1,
      anon_sym_DOT,
    ACTIONS(547), 1,
      sym__newline,
    ACTIONS(65), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(79), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(97), 2,
      sym_class,
      sym_id,
    STATE(124), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(2), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [3936] = 26,
    ACTIONS(463), 1,
      anon_sym_case,
    ACTIONS(487), 1,
      anon_sym_doctype,
    ACTIONS(489), 1,
      anon_sym_PIPE,
    ACTIONS(491), 1,
      anon_sym_include,
    ACTIONS(493), 1,
      anon_sym_while,
    ACTIONS(495), 1,
      anon_sym_else,
    ACTIONS(499), 1,
      anon_sym_block,
    ACTIONS(501), 1,
      anon_sym_append,
    ACTIONS(503), 1,
      anon_sym_prepend,
    ACTIONS(505), 1,
      anon_sym_extends,
    ACTIONS(507), 1,
      anon_sym_COLON,
    ACTIONS(511), 1,
      anon_sym_elseif,
    ACTIONS(513), 1,
      anon_sym_BANG_EQ,
    ACTIONS(515), 1,
      anon_sym_EQ,
    ACTIONS(517), 1,
      anon_sym_script_DOT,
    ACTIONS(521), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(523), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(525), 1,
      sym_tag_name,
    ACTIONS(529), 1,
      anon_sym_DASH,
    ACTIONS(549), 1,
      sym__newline,
    ACTIONS(627), 1,
      sym__dedent,
    ACTIONS(497), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(509), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(527), 2,
      sym_class,
      sym_id,
    STATE(376), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(37), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [4038] = 26,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(180), 1,
      anon_sym_doctype,
    ACTIONS(182), 1,
      anon_sym_PIPE,
    ACTIONS(184), 1,
      anon_sym_include,
    ACTIONS(186), 1,
      anon_sym_while,
    ACTIONS(188), 1,
      anon_sym_else,
    ACTIONS(192), 1,
      anon_sym_block,
    ACTIONS(194), 1,
      anon_sym_append,
    ACTIONS(196), 1,
      anon_sym_prepend,
    ACTIONS(198), 1,
      anon_sym_extends,
    ACTIONS(200), 1,
      anon_sym_COLON,
    ACTIONS(204), 1,
      anon_sym_elseif,
    ACTIONS(206), 1,
      anon_sym_BANG_EQ,
    ACTIONS(208), 1,
      anon_sym_EQ,
    ACTIONS(210), 1,
      anon_sym_script_DOT,
    ACTIONS(212), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(214), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(216), 1,
      sym_tag_name,
    ACTIONS(220), 1,
      anon_sym_DASH,
    ACTIONS(533), 1,
      anon_sym_DOT,
    ACTIONS(535), 1,
      sym__newline,
    ACTIONS(190), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(202), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(218), 2,
      sym_class,
      sym_id,
    STATE(242), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(7), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [4140] = 26,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(180), 1,
      anon_sym_doctype,
    ACTIONS(182), 1,
      anon_sym_PIPE,
    ACTIONS(184), 1,
      anon_sym_include,
    ACTIONS(186), 1,
      anon_sym_while,
    ACTIONS(188), 1,
      anon_sym_else,
    ACTIONS(192), 1,
      anon_sym_block,
    ACTIONS(194), 1,
      anon_sym_append,
    ACTIONS(196), 1,
      anon_sym_prepend,
    ACTIONS(198), 1,
      anon_sym_extends,
    ACTIONS(200), 1,
      anon_sym_COLON,
    ACTIONS(204), 1,
      anon_sym_elseif,
    ACTIONS(206), 1,
      anon_sym_BANG_EQ,
    ACTIONS(208), 1,
      anon_sym_EQ,
    ACTIONS(210), 1,
      anon_sym_script_DOT,
    ACTIONS(212), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(214), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(216), 1,
      sym_tag_name,
    ACTIONS(220), 1,
      anon_sym_DASH,
    ACTIONS(533), 1,
      anon_sym_DOT,
    ACTIONS(535), 1,
      sym__newline,
    ACTIONS(190), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(202), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(218), 2,
      sym_class,
      sym_id,
    STATE(242), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(7), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [4242] = 25,
    ACTIONS(55), 1,
      anon_sym_doctype,
    ACTIONS(57), 1,
      anon_sym_PIPE,
    ACTIONS(59), 1,
      anon_sym_include,
    ACTIONS(61), 1,
      anon_sym_while,
    ACTIONS(63), 1,
      anon_sym_else,
    ACTIONS(69), 1,
      anon_sym_block,
    ACTIONS(71), 1,
      anon_sym_append,
    ACTIONS(73), 1,
      anon_sym_prepend,
    ACTIONS(75), 1,
      anon_sym_extends,
    ACTIONS(77), 1,
      anon_sym_COLON,
    ACTIONS(81), 1,
      anon_sym_elseif,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_BANG_EQ,
    ACTIONS(87), 1,
      anon_sym_EQ,
    ACTIONS(89), 1,
      anon_sym_script_DOT,
    ACTIONS(91), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(93), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(95), 1,
      sym_tag_name,
    ACTIONS(99), 1,
      anon_sym_DASH,
    ACTIONS(539), 1,
      sym__newline,
    ACTIONS(65), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(79), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(97), 2,
      sym_class,
      sym_id,
    STATE(124), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(4), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [4341] = 25,
    ACTIONS(463), 1,
      anon_sym_case,
    ACTIONS(487), 1,
      anon_sym_doctype,
    ACTIONS(489), 1,
      anon_sym_PIPE,
    ACTIONS(491), 1,
      anon_sym_include,
    ACTIONS(493), 1,
      anon_sym_while,
    ACTIONS(495), 1,
      anon_sym_else,
    ACTIONS(499), 1,
      anon_sym_block,
    ACTIONS(501), 1,
      anon_sym_append,
    ACTIONS(503), 1,
      anon_sym_prepend,
    ACTIONS(505), 1,
      anon_sym_extends,
    ACTIONS(507), 1,
      anon_sym_COLON,
    ACTIONS(511), 1,
      anon_sym_elseif,
    ACTIONS(513), 1,
      anon_sym_BANG_EQ,
    ACTIONS(515), 1,
      anon_sym_EQ,
    ACTIONS(517), 1,
      anon_sym_script_DOT,
    ACTIONS(521), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(523), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(525), 1,
      sym_tag_name,
    ACTIONS(529), 1,
      anon_sym_DASH,
    ACTIONS(531), 1,
      sym__newline,
    ACTIONS(497), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(509), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(527), 2,
      sym_class,
      sym_id,
    STATE(376), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(40), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [4440] = 25,
    ACTIONS(463), 1,
      anon_sym_case,
    ACTIONS(487), 1,
      anon_sym_doctype,
    ACTIONS(489), 1,
      anon_sym_PIPE,
    ACTIONS(491), 1,
      anon_sym_include,
    ACTIONS(493), 1,
      anon_sym_while,
    ACTIONS(495), 1,
      anon_sym_else,
    ACTIONS(499), 1,
      anon_sym_block,
    ACTIONS(501), 1,
      anon_sym_append,
    ACTIONS(503), 1,
      anon_sym_prepend,
    ACTIONS(505), 1,
      anon_sym_extends,
    ACTIONS(507), 1,
      anon_sym_COLON,
    ACTIONS(511), 1,
      anon_sym_elseif,
    ACTIONS(513), 1,
      anon_sym_BANG_EQ,
    ACTIONS(515), 1,
      anon_sym_EQ,
    ACTIONS(517), 1,
      anon_sym_script_DOT,
    ACTIONS(521), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(523), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(525), 1,
      sym_tag_name,
    ACTIONS(529), 1,
      anon_sym_DASH,
    ACTIONS(543), 1,
      sym__newline,
    ACTIONS(497), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(509), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(527), 2,
      sym_class,
      sym_id,
    STATE(376), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(21), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [4539] = 25,
    ACTIONS(437), 1,
      anon_sym_doctype,
    ACTIONS(439), 1,
      anon_sym_PIPE,
    ACTIONS(441), 1,
      anon_sym_include,
    ACTIONS(443), 1,
      anon_sym_while,
    ACTIONS(445), 1,
      anon_sym_else,
    ACTIONS(449), 1,
      anon_sym_block,
    ACTIONS(451), 1,
      anon_sym_append,
    ACTIONS(453), 1,
      anon_sym_prepend,
    ACTIONS(455), 1,
      anon_sym_extends,
    ACTIONS(457), 1,
      anon_sym_COLON,
    ACTIONS(461), 1,
      anon_sym_elseif,
    ACTIONS(463), 1,
      anon_sym_case,
    ACTIONS(465), 1,
      anon_sym_BANG_EQ,
    ACTIONS(467), 1,
      anon_sym_EQ,
    ACTIONS(469), 1,
      anon_sym_script_DOT,
    ACTIONS(471), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(473), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(475), 1,
      sym_tag_name,
    ACTIONS(479), 1,
      anon_sym_DASH,
    ACTIONS(555), 1,
      sym__newline,
    ACTIONS(447), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(459), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(477), 2,
      sym_class,
      sym_id,
    STATE(255), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(10), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [4638] = 25,
    ACTIONS(55), 1,
      anon_sym_doctype,
    ACTIONS(57), 1,
      anon_sym_PIPE,
    ACTIONS(59), 1,
      anon_sym_include,
    ACTIONS(61), 1,
      anon_sym_while,
    ACTIONS(63), 1,
      anon_sym_else,
    ACTIONS(69), 1,
      anon_sym_block,
    ACTIONS(71), 1,
      anon_sym_append,
    ACTIONS(73), 1,
      anon_sym_prepend,
    ACTIONS(75), 1,
      anon_sym_extends,
    ACTIONS(77), 1,
      anon_sym_COLON,
    ACTIONS(81), 1,
      anon_sym_elseif,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_BANG_EQ,
    ACTIONS(87), 1,
      anon_sym_EQ,
    ACTIONS(89), 1,
      anon_sym_script_DOT,
    ACTIONS(91), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(93), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(95), 1,
      sym_tag_name,
    ACTIONS(99), 1,
      anon_sym_DASH,
    ACTIONS(547), 1,
      sym__newline,
    ACTIONS(65), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(79), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(97), 2,
      sym_class,
      sym_id,
    STATE(124), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(2), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [4737] = 25,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(180), 1,
      anon_sym_doctype,
    ACTIONS(182), 1,
      anon_sym_PIPE,
    ACTIONS(184), 1,
      anon_sym_include,
    ACTIONS(186), 1,
      anon_sym_while,
    ACTIONS(188), 1,
      anon_sym_else,
    ACTIONS(192), 1,
      anon_sym_block,
    ACTIONS(194), 1,
      anon_sym_append,
    ACTIONS(196), 1,
      anon_sym_prepend,
    ACTIONS(198), 1,
      anon_sym_extends,
    ACTIONS(200), 1,
      anon_sym_COLON,
    ACTIONS(204), 1,
      anon_sym_elseif,
    ACTIONS(206), 1,
      anon_sym_BANG_EQ,
    ACTIONS(208), 1,
      anon_sym_EQ,
    ACTIONS(210), 1,
      anon_sym_script_DOT,
    ACTIONS(212), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(214), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(216), 1,
      sym_tag_name,
    ACTIONS(220), 1,
      anon_sym_DASH,
    ACTIONS(559), 1,
      sym__newline,
    ACTIONS(190), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(202), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(218), 2,
      sym_class,
      sym_id,
    STATE(242), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(5), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [4836] = 25,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(180), 1,
      anon_sym_doctype,
    ACTIONS(182), 1,
      anon_sym_PIPE,
    ACTIONS(184), 1,
      anon_sym_include,
    ACTIONS(186), 1,
      anon_sym_while,
    ACTIONS(188), 1,
      anon_sym_else,
    ACTIONS(192), 1,
      anon_sym_block,
    ACTIONS(194), 1,
      anon_sym_append,
    ACTIONS(196), 1,
      anon_sym_prepend,
    ACTIONS(198), 1,
      anon_sym_extends,
    ACTIONS(200), 1,
      anon_sym_COLON,
    ACTIONS(204), 1,
      anon_sym_elseif,
    ACTIONS(206), 1,
      anon_sym_BANG_EQ,
    ACTIONS(208), 1,
      anon_sym_EQ,
    ACTIONS(210), 1,
      anon_sym_script_DOT,
    ACTIONS(212), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(214), 1,
      anon_sym_SLASH_SLASH_DASH,
    ACTIONS(216), 1,
      sym_tag_name,
    ACTIONS(220), 1,
      anon_sym_DASH,
    ACTIONS(535), 1,
      sym__newline,
    ACTIONS(190), 2,
      anon_sym_each,
      anon_sym_for,
    ACTIONS(202), 2,
      anon_sym_unless,
      anon_sym_if,
    ACTIONS(218), 2,
      sym_class,
      sym_id,
    STATE(242), 2,
      sym__comment,
      sym__comment_not_first_line,
    STATE(7), 20,
      sym_doctype,
      sym_pipe,
      sym_include,
      sym_while,
      sym_each,
      sym_block_definition,
      sym_block_append,
      sym_block_prepend,
      sym_extends,
      sym_filter,
      sym_conditional,
      sym_case,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym_script_block,
      sym_tag,
      sym__children_choice,
      sym_comment,
      sym_unbuffered_code,
      aux_sym_children_repeat1,
  [4935] = 9,
    ACTIONS(633), 1,
      anon_sym_LPAREN,
    ACTIONS(635), 1,
      anon_sym_COLON,
    ACTIONS(637), 1,
      aux_sym_filter_content_token1,
    ACTIONS(639), 1,
      sym__newline,
    STATE(54), 1,
      sym_attributes,
    STATE(117), 1,
      sym_filter,
    STATE(119), 1,
      sym_filter_content,
    ACTIONS(629), 2,
      sym__dedent,
      ts_builtin_sym_end,
    ACTIONS(631), 28,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_PLUS,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [4991] = 9,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(643), 1,
      anon_sym_COLON,
    ACTIONS(645), 1,
      aux_sym_filter_content_token1,
    ACTIONS(647), 1,
      sym__newline,
    STATE(85), 1,
      sym_attributes,
    STATE(226), 1,
      sym_filter_content,
    STATE(227), 1,
      sym_filter,
    ACTIONS(629), 2,
      sym__dedent,
      ts_builtin_sym_end,
    ACTIONS(631), 26,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_PLUS,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [5045] = 6,
    ACTIONS(653), 1,
      anon_sym_when,
    ACTIONS(656), 1,
      anon_sym_default,
    STATE(773), 1,
      sym__when_keyword,
    STATE(52), 2,
      sym_when,
      aux_sym_case_repeat1,
    ACTIONS(649), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(651), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [5093] = 6,
    ACTIONS(663), 1,
      anon_sym_when,
    ACTIONS(665), 1,
      anon_sym_default,
    STATE(773), 1,
      sym__when_keyword,
    STATE(52), 2,
      sym_when,
      aux_sym_case_repeat1,
    ACTIONS(659), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(661), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [5141] = 7,
    ACTIONS(635), 1,
      anon_sym_COLON,
    ACTIONS(637), 1,
      aux_sym_filter_content_token1,
    ACTIONS(639), 1,
      sym__newline,
    STATE(117), 1,
      sym_filter,
    STATE(137), 1,
      sym_filter_content,
    ACTIONS(667), 2,
      sym__dedent,
      ts_builtin_sym_end,
    ACTIONS(669), 28,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_PLUS,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [5191] = 4,
    ACTIONS(675), 1,
      sym__indent,
    STATE(116), 1,
      sym_children,
    ACTIONS(671), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(673), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [5234] = 4,
    ACTIONS(681), 1,
      sym__un_delimited_javascript_line,
    STATE(56), 1,
      aux_sym__un_delimited_javascript_multiline,
    ACTIONS(677), 3,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
    ACTIONS(679), 29,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_PLUS,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_COLON,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [5277] = 4,
    ACTIONS(675), 1,
      sym__indent,
    STATE(100), 1,
      sym_children,
    ACTIONS(684), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(686), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [5320] = 9,
    ACTIONS(629), 1,
      sym__dedent,
    ACTIONS(688), 1,
      anon_sym_LPAREN,
    ACTIONS(690), 1,
      anon_sym_COLON,
    ACTIONS(692), 1,
      aux_sym_filter_content_token1,
    ACTIONS(694), 1,
      sym__newline,
    STATE(93), 1,
      sym_attributes,
    STATE(314), 1,
      sym_filter,
    STATE(315), 1,
      sym_filter_content,
    ACTIONS(631), 26,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [5373] = 4,
    ACTIONS(675), 1,
      sym__indent,
    STATE(87), 1,
      sym_children,
    ACTIONS(696), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(698), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [5416] = 4,
    ACTIONS(704), 1,
      sym__indent,
    STATE(105), 1,
      sym_children,
    ACTIONS(700), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(702), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [5459] = 4,
    ACTIONS(675), 1,
      sym__indent,
    STATE(114), 1,
      sym_children,
    ACTIONS(706), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(708), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [5502] = 4,
    ACTIONS(714), 1,
      sym__un_delimited_javascript_line,
    STATE(56), 1,
      aux_sym__un_delimited_javascript_multiline,
    ACTIONS(710), 3,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
    ACTIONS(712), 29,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_PLUS,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_COLON,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [5545] = 4,
    ACTIONS(716), 1,
      sym__indent,
    STATE(114), 1,
      sym_children,
    ACTIONS(706), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(708), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [5588] = 9,
    ACTIONS(629), 1,
      ts_builtin_sym_end,
    ACTIONS(718), 1,
      anon_sym_LPAREN,
    ACTIONS(720), 1,
      anon_sym_COLON,
    ACTIONS(722), 1,
      aux_sym_filter_content_token1,
    ACTIONS(724), 1,
      sym__newline,
    STATE(110), 1,
      sym_attributes,
    STATE(364), 1,
      sym_filter_content,
    STATE(365), 1,
      sym_filter,
    ACTIONS(631), 26,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_PLUS,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [5641] = 4,
    ACTIONS(730), 1,
      sym__indent,
    STATE(121), 1,
      sym_children,
    ACTIONS(726), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(728), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [5684] = 4,
    ACTIONS(675), 1,
      sym__indent,
    STATE(105), 1,
      sym_children,
    ACTIONS(700), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(702), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [5727] = 4,
    ACTIONS(736), 1,
      sym__indent,
    STATE(127), 1,
      sym_children,
    ACTIONS(732), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(734), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [5770] = 5,
    ACTIONS(738), 1,
      sym__indent,
    ACTIONS(740), 1,
      sym__dedent,
    STATE(176), 1,
      sym_children,
    ACTIONS(671), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(673), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [5814] = 4,
    ACTIONS(742), 1,
      sym__indent,
    STATE(156), 1,
      sym_children,
    ACTIONS(706), 13,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(708), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [5856] = 2,
    ACTIONS(744), 4,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      aux_sym_filter_content_token1,
    ACTIONS(746), 29,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_PLUS,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_COLON,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [5894] = 4,
    ACTIONS(748), 1,
      sym__indent,
    STATE(153), 1,
      sym_children,
    ACTIONS(700), 13,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(702), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [5936] = 4,
    ACTIONS(738), 1,
      sym__indent,
    STATE(156), 1,
      sym_children,
    ACTIONS(706), 13,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(708), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [5978] = 6,
    ACTIONS(653), 1,
      anon_sym_when,
    ACTIONS(750), 1,
      anon_sym_default,
    STATE(751), 1,
      sym__when_keyword,
    STATE(73), 2,
      sym_when,
      aux_sym_case_repeat1,
    ACTIONS(649), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(651), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [6024] = 4,
    ACTIONS(738), 1,
      sym__indent,
    STATE(153), 1,
      sym_children,
    ACTIONS(700), 13,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(702), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [6066] = 4,
    ACTIONS(738), 1,
      sym__indent,
    STATE(162), 1,
      sym_children,
    ACTIONS(684), 13,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(686), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [6108] = 2,
    ACTIONS(753), 4,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      aux_sym_filter_content_token1,
    ACTIONS(755), 29,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_PLUS,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_COLON,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [6146] = 4,
    ACTIONS(757), 1,
      sym__indent,
    STATE(164), 1,
      sym_children,
    ACTIONS(726), 13,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(728), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [6188] = 3,
    ACTIONS(763), 1,
      sym__indent,
    ACTIONS(759), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(761), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [6228] = 4,
    ACTIONS(765), 1,
      sym__indent,
    STATE(173), 1,
      sym_children,
    ACTIONS(732), 13,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(734), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [6270] = 6,
    ACTIONS(663), 1,
      anon_sym_when,
    ACTIONS(767), 1,
      anon_sym_default,
    STATE(751), 1,
      sym__when_keyword,
    STATE(73), 2,
      sym_when,
      aux_sym_case_repeat1,
    ACTIONS(659), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(661), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [6316] = 4,
    ACTIONS(773), 1,
      anon_sym_else,
    STATE(94), 1,
      sym__each_else,
    ACTIONS(769), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(771), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [6358] = 2,
    ACTIONS(775), 3,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
    ACTIONS(777), 30,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_PLUS,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_COLON,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      sym__un_delimited_javascript_line,
      anon_sym_DASH,
  [6396] = 4,
    ACTIONS(738), 1,
      sym__indent,
    STATE(160), 1,
      sym_children,
    ACTIONS(696), 13,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(698), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [6438] = 3,
    ACTIONS(783), 1,
      sym__indent,
    ACTIONS(779), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(781), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [6478] = 7,
    ACTIONS(643), 1,
      anon_sym_COLON,
    ACTIONS(645), 1,
      aux_sym_filter_content_token1,
    ACTIONS(647), 1,
      sym__newline,
    STATE(211), 1,
      sym_filter_content,
    STATE(227), 1,
      sym_filter,
    ACTIONS(667), 2,
      sym__dedent,
      ts_builtin_sym_end,
    ACTIONS(669), 26,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_PLUS,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [6526] = 2,
    ACTIONS(785), 4,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      aux_sym_filter_content_token1,
    ACTIONS(787), 29,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_PLUS,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_COLON,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [6564] = 2,
    ACTIONS(789), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(791), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [6601] = 2,
    ACTIONS(793), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(795), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [6638] = 2,
    ACTIONS(671), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(673), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [6675] = 2,
    ACTIONS(797), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(799), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [6712] = 4,
    ACTIONS(801), 1,
      sym__un_delimited_javascript_line,
    STATE(115), 1,
      aux_sym__un_delimited_javascript_multiline,
    ACTIONS(710), 3,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
    ACTIONS(712), 27,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_PLUS,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_COLON,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [6753] = 3,
    ACTIONS(803), 1,
      sym__indent,
    ACTIONS(759), 13,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(761), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [6792] = 7,
    ACTIONS(667), 1,
      sym__dedent,
    ACTIONS(690), 1,
      anon_sym_COLON,
    ACTIONS(692), 1,
      aux_sym_filter_content_token1,
    ACTIONS(694), 1,
      sym__newline,
    STATE(297), 1,
      sym_filter_content,
    STATE(314), 1,
      sym_filter,
    ACTIONS(669), 26,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [6839] = 2,
    ACTIONS(805), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(807), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [6876] = 4,
    ACTIONS(809), 1,
      sym__indent,
    STATE(232), 1,
      sym_children,
    ACTIONS(700), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(702), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [6917] = 4,
    ACTIONS(811), 1,
      sym__indent,
    STATE(232), 1,
      sym_children,
    ACTIONS(700), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(702), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [6958] = 2,
    ACTIONS(813), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(815), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [6995] = 4,
    ACTIONS(817), 1,
      sym__indent,
    STATE(191), 1,
      sym_children,
    ACTIONS(706), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(708), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [7036] = 2,
    ACTIONS(819), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(821), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [7073] = 2,
    ACTIONS(696), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(698), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [7110] = 4,
    ACTIONS(811), 1,
      sym__indent,
    STATE(191), 1,
      sym_children,
    ACTIONS(706), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(708), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [7151] = 6,
    ACTIONS(663), 1,
      anon_sym_when,
    ACTIONS(823), 1,
      anon_sym_default,
    STATE(729), 1,
      sym__when_keyword,
    STATE(113), 2,
      sym_when,
      aux_sym_case_repeat1,
    ACTIONS(659), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(661), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [7196] = 2,
    ACTIONS(825), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(827), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [7233] = 2,
    ACTIONS(829), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(831), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [7270] = 2,
    ACTIONS(684), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(686), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [7307] = 4,
    ACTIONS(833), 1,
      sym__indent,
    STATE(199), 1,
      sym_children,
    ACTIONS(726), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(728), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [7348] = 2,
    ACTIONS(835), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(837), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [7385] = 2,
    ACTIONS(839), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(841), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [7422] = 4,
    ACTIONS(843), 1,
      sym__indent,
    STATE(215), 1,
      sym_children,
    ACTIONS(732), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(734), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [7463] = 7,
    ACTIONS(667), 1,
      ts_builtin_sym_end,
    ACTIONS(720), 1,
      anon_sym_COLON,
    ACTIONS(722), 1,
      aux_sym_filter_content_token1,
    ACTIONS(724), 1,
      sym__newline,
    STATE(339), 1,
      sym_filter_content,
    STATE(365), 1,
      sym_filter,
    ACTIONS(669), 26,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_PLUS,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [7510] = 2,
    ACTIONS(845), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(847), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [7547] = 4,
    ACTIONS(811), 1,
      sym__indent,
    STATE(254), 1,
      sym_children,
    ACTIONS(684), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(686), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [7588] = 6,
    ACTIONS(653), 1,
      anon_sym_when,
    ACTIONS(849), 1,
      anon_sym_default,
    STATE(729), 1,
      sym__when_keyword,
    STATE(113), 2,
      sym_when,
      aux_sym_case_repeat1,
    ACTIONS(649), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(651), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [7633] = 2,
    ACTIONS(700), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(702), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [7670] = 4,
    ACTIONS(852), 1,
      sym__un_delimited_javascript_line,
    STATE(115), 1,
      aux_sym__un_delimited_javascript_multiline,
    ACTIONS(677), 3,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
    ACTIONS(679), 27,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_PLUS,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_COLON,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [7711] = 2,
    ACTIONS(855), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(857), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [7748] = 2,
    ACTIONS(859), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(861), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [7785] = 3,
    ACTIONS(867), 1,
      sym__dedent,
    ACTIONS(863), 13,
      sym__newline,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(865), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [7824] = 2,
    ACTIONS(667), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(669), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [7861] = 2,
    ACTIONS(869), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(871), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [7898] = 2,
    ACTIONS(706), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(708), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [7935] = 4,
    ACTIONS(811), 1,
      sym__indent,
    STATE(248), 1,
      sym_children,
    ACTIONS(696), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(698), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [7976] = 2,
    ACTIONS(873), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(875), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [8013] = 2,
    ACTIONS(877), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(879), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [8050] = 2,
    ACTIONS(881), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(883), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [8087] = 2,
    ACTIONS(885), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(887), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [8124] = 2,
    ACTIONS(726), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(728), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [8161] = 2,
    ACTIONS(889), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(891), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [8198] = 2,
    ACTIONS(893), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(895), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [8235] = 2,
    ACTIONS(897), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(899), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [8272] = 2,
    ACTIONS(901), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(903), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [8309] = 2,
    ACTIONS(905), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(907), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [8346] = 2,
    ACTIONS(909), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(911), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [8383] = 2,
    ACTIONS(913), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(915), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [8420] = 2,
    ACTIONS(732), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(734), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [8457] = 2,
    ACTIONS(917), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(919), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [8494] = 2,
    ACTIONS(921), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(923), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [8531] = 9,
    ACTIONS(629), 1,
      sym__dedent,
    ACTIONS(925), 1,
      anon_sym_LPAREN,
    ACTIONS(927), 1,
      anon_sym_COLON,
    ACTIONS(929), 1,
      aux_sym_filter_content_token1,
    ACTIONS(931), 1,
      sym__newline,
    STATE(243), 1,
      sym_attributes,
    STATE(407), 1,
      sym_filter_content,
    STATE(408), 1,
      sym_filter,
    ACTIONS(631), 24,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [8582] = 2,
    ACTIONS(933), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(935), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [8619] = 2,
    ACTIONS(937), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(939), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [8656] = 2,
    ACTIONS(941), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(943), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [8693] = 2,
    ACTIONS(945), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(947), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [8730] = 2,
    ACTIONS(949), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(951), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [8767] = 3,
    ACTIONS(957), 1,
      sym__dedent,
    ACTIONS(953), 13,
      sym__newline,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(955), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [8806] = 2,
    ACTIONS(959), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(961), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [8843] = 2,
    ACTIONS(963), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(965), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [8880] = 2,
    ACTIONS(967), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(969), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [8917] = 2,
    ACTIONS(971), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(973), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [8954] = 2,
    ACTIONS(975), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(977), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [8991] = 2,
    ACTIONS(979), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(981), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [9028] = 4,
    ACTIONS(983), 1,
      sym__un_delimited_javascript_line,
    STATE(181), 1,
      aux_sym__un_delimited_javascript_multiline,
    ACTIONS(710), 2,
      sym__newline,
      sym__dedent,
    ACTIONS(712), 27,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_COLON,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [9068] = 2,
    ACTIONS(829), 13,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(831), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [9104] = 2,
    ACTIONS(684), 13,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(686), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [9140] = 4,
    ACTIONS(985), 1,
      sym__un_delimited_javascript_line,
    STATE(175), 1,
      aux_sym__un_delimited_javascript_multiline,
    ACTIONS(710), 2,
      sym__dedent,
      ts_builtin_sym_end,
    ACTIONS(712), 27,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_PLUS,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_COLON,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [9180] = 4,
    ACTIONS(987), 1,
      sym__indent,
    STATE(275), 1,
      sym_children,
    ACTIONS(706), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(708), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [9220] = 2,
    ACTIONS(700), 13,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(702), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [9256] = 2,
    ACTIONS(785), 4,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      aux_sym_filter_content_token1,
    ACTIONS(787), 27,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_PLUS,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_COLON,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [9292] = 4,
    ACTIONS(989), 1,
      sym__indent,
    STATE(266), 1,
      sym_children,
    ACTIONS(700), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(702), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [9332] = 4,
    ACTIONS(989), 1,
      sym__indent,
    STATE(275), 1,
      sym_children,
    ACTIONS(706), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(708), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [9372] = 2,
    ACTIONS(789), 13,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(791), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [9408] = 2,
    ACTIONS(819), 13,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(821), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [9444] = 2,
    ACTIONS(696), 13,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(698), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [9480] = 2,
    ACTIONS(793), 13,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(795), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [9516] = 2,
    ACTIONS(706), 13,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(708), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [9552] = 3,
    ACTIONS(991), 1,
      sym__indent,
    ACTIONS(759), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(761), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [9590] = 2,
    ACTIONS(753), 4,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      aux_sym_filter_content_token1,
    ACTIONS(755), 27,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_PLUS,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_COLON,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [9626] = 4,
    ACTIONS(993), 1,
      anon_sym_else,
    STATE(252), 1,
      sym__each_else,
    ACTIONS(769), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(771), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [9666] = 2,
    ACTIONS(825), 13,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(827), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [9702] = 2,
    ACTIONS(839), 13,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(841), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [9738] = 3,
    ACTIONS(740), 1,
      sym__dedent,
    ACTIONS(671), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(673), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [9776] = 2,
    ACTIONS(744), 4,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      aux_sym_filter_content_token1,
    ACTIONS(746), 27,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_PLUS,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_COLON,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [9812] = 2,
    ACTIONS(835), 13,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(837), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [9848] = 2,
    ACTIONS(726), 13,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(728), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [9884] = 4,
    ACTIONS(995), 1,
      sym__indent,
    STATE(298), 1,
      sym_children,
    ACTIONS(732), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(734), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [9924] = 4,
    ACTIONS(997), 1,
      sym__un_delimited_javascript_line,
    STATE(175), 1,
      aux_sym__un_delimited_javascript_multiline,
    ACTIONS(677), 2,
      sym__dedent,
      ts_builtin_sym_end,
    ACTIONS(679), 27,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_PLUS,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_COLON,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [9964] = 2,
    ACTIONS(855), 13,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(857), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [10000] = 2,
    ACTIONS(732), 13,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(734), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [10036] = 2,
    ACTIONS(869), 13,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(871), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [10072] = 4,
    ACTIONS(1000), 1,
      sym__indent,
    STATE(266), 1,
      sym_children,
    ACTIONS(700), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(702), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [10112] = 3,
    ACTIONS(1002), 1,
      sym__indent,
    ACTIONS(779), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(781), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [10150] = 4,
    ACTIONS(1004), 1,
      sym__un_delimited_javascript_line,
    STATE(181), 1,
      aux_sym__un_delimited_javascript_multiline,
    ACTIONS(677), 2,
      sym__newline,
      sym__dedent,
    ACTIONS(679), 27,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_COLON,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [10190] = 4,
    ACTIONS(989), 1,
      sym__indent,
    STATE(305), 1,
      sym_children,
    ACTIONS(684), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(686), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [10230] = 4,
    ACTIONS(989), 1,
      sym__indent,
    STATE(308), 1,
      sym_children,
    ACTIONS(671), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(673), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [10270] = 4,
    ACTIONS(1007), 1,
      sym__indent,
    STATE(296), 1,
      sym_children,
    ACTIONS(726), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(728), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [10310] = 4,
    ACTIONS(989), 1,
      sym__indent,
    STATE(318), 1,
      sym_children,
    ACTIONS(696), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(698), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [10350] = 2,
    ACTIONS(775), 3,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
    ACTIONS(777), 28,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_PLUS,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_COLON,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      sym__un_delimited_javascript_line,
      anon_sym_DASH,
  [10386] = 2,
    ACTIONS(797), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(799), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [10421] = 2,
    ACTIONS(775), 2,
      sym__dedent,
      ts_builtin_sym_end,
    ACTIONS(777), 28,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_PLUS,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_COLON,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      sym__un_delimited_javascript_line,
      anon_sym_DASH,
  [10456] = 3,
    ACTIONS(1009), 1,
      sym__indent,
    ACTIONS(759), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(761), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [10493] = 3,
    ACTIONS(1011), 1,
      sym__dedent,
    ACTIONS(863), 13,
      sym__newline,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(865), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [10530] = 2,
    ACTIONS(700), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(702), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [10565] = 4,
    ACTIONS(1013), 1,
      sym__indent,
    STATE(362), 1,
      sym_children,
    ACTIONS(732), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(734), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [10604] = 2,
    ACTIONS(785), 3,
      sym__newline,
      ts_builtin_sym_end,
      aux_sym_filter_content_token1,
    ACTIONS(787), 27,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_PLUS,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_COLON,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [10639] = 2,
    ACTIONS(845), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(847), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [10674] = 2,
    ACTIONS(873), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(875), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [10709] = 2,
    ACTIONS(793), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(795), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [10744] = 2,
    ACTIONS(979), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(981), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [10779] = 2,
    ACTIONS(835), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(837), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [10814] = 2,
    ACTIONS(706), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(708), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [10849] = 2,
    ACTIONS(963), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(965), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [10884] = 2,
    ACTIONS(753), 3,
      sym__newline,
      ts_builtin_sym_end,
      aux_sym_filter_content_token1,
    ACTIONS(755), 27,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_PLUS,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_COLON,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [10919] = 2,
    ACTIONS(975), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(977), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [10954] = 2,
    ACTIONS(744), 3,
      sym__newline,
      sym__dedent,
      aux_sym_filter_content_token1,
    ACTIONS(746), 27,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_COLON,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [10989] = 2,
    ACTIONS(967), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(969), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [11024] = 2,
    ACTIONS(753), 3,
      sym__newline,
      sym__dedent,
      aux_sym_filter_content_token1,
    ACTIONS(755), 27,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_COLON,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [11059] = 2,
    ACTIONS(971), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(973), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [11094] = 4,
    ACTIONS(1015), 1,
      sym__indent,
    STATE(371), 1,
      sym_children,
    ACTIONS(706), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(708), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [11133] = 2,
    ACTIONS(959), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(961), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [11168] = 3,
    ACTIONS(1017), 1,
      sym__dedent,
    ACTIONS(953), 13,
      sym__newline,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(955), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [11205] = 4,
    ACTIONS(1015), 1,
      sym__indent,
    STATE(348), 1,
      sym_children,
    ACTIONS(700), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(702), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [11244] = 2,
    ACTIONS(921), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(923), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [11279] = 2,
    ACTIONS(917), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(919), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [11314] = 4,
    ACTIONS(1019), 1,
      anon_sym_else,
    STATE(302), 1,
      sym__each_else,
    ACTIONS(769), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(771), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [11353] = 2,
    ACTIONS(744), 3,
      sym__newline,
      ts_builtin_sym_end,
      aux_sym_filter_content_token1,
    ACTIONS(746), 27,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_PLUS,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_COLON,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [11388] = 2,
    ACTIONS(726), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(728), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [11423] = 3,
    ACTIONS(1021), 1,
      sym__indent,
    ACTIONS(759), 13,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(761), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [11460] = 4,
    ACTIONS(1023), 1,
      sym__indent,
    STATE(348), 1,
      sym_children,
    ACTIONS(700), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(702), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [11499] = 2,
    ACTIONS(913), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(915), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [11534] = 2,
    ACTIONS(949), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(951), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [11569] = 2,
    ACTIONS(1025), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(1027), 18,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [11604] = 4,
    ACTIONS(1029), 1,
      sym__indent,
    STATE(371), 1,
      sym_children,
    ACTIONS(706), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(708), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [11643] = 2,
    ACTIONS(945), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(947), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [11678] = 2,
    ACTIONS(941), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(943), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [11713] = 2,
    ACTIONS(937), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(939), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [11748] = 2,
    ACTIONS(933), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(935), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [11783] = 2,
    ACTIONS(667), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(669), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [11818] = 2,
    ACTIONS(859), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(861), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [11853] = 2,
    ACTIONS(732), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(734), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [11888] = 2,
    ACTIONS(775), 2,
      sym__newline,
      sym__dedent,
    ACTIONS(777), 28,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_COLON,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      sym__un_delimited_javascript_line,
      anon_sym_DASH,
  [11923] = 2,
    ACTIONS(839), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(841), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [11958] = 2,
    ACTIONS(825), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(827), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [11993] = 2,
    ACTIONS(684), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(686), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [12028] = 2,
    ACTIONS(785), 3,
      sym__newline,
      sym__dedent,
      aux_sym_filter_content_token1,
    ACTIONS(787), 27,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_COLON,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [12063] = 2,
    ACTIONS(909), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(911), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [12098] = 2,
    ACTIONS(905), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(907), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [12133] = 2,
    ACTIONS(901), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(903), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [12168] = 2,
    ACTIONS(897), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(899), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [12203] = 2,
    ACTIONS(893), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(895), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [12238] = 2,
    ACTIONS(889), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(891), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [12273] = 2,
    ACTIONS(885), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(887), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [12308] = 2,
    ACTIONS(881), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(883), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [12343] = 2,
    ACTIONS(877), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(879), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [12378] = 7,
    ACTIONS(667), 1,
      sym__dedent,
    ACTIONS(927), 1,
      anon_sym_COLON,
    ACTIONS(929), 1,
      aux_sym_filter_content_token1,
    ACTIONS(931), 1,
      sym__newline,
    STATE(399), 1,
      sym_filter_content,
    STATE(408), 1,
      sym_filter,
    ACTIONS(669), 24,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [12423] = 3,
    ACTIONS(1031), 1,
      sym__indent,
    ACTIONS(779), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(781), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [12460] = 2,
    ACTIONS(829), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(831), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [12495] = 4,
    ACTIONS(1033), 1,
      sym__indent,
    ACTIONS(1035), 1,
      sym__dedent,
    ACTIONS(759), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(761), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [12534] = 2,
    ACTIONS(813), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(815), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [12569] = 2,
    ACTIONS(789), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(791), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [12604] = 4,
    ACTIONS(1015), 1,
      sym__indent,
    STATE(337), 1,
      sym_children,
    ACTIONS(684), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(686), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [12643] = 4,
    ACTIONS(1015), 1,
      sym__indent,
    STATE(321), 1,
      sym_children,
    ACTIONS(696), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(698), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [12682] = 2,
    ACTIONS(819), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(821), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [12717] = 2,
    ACTIONS(805), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(807), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [12752] = 4,
    ACTIONS(1037), 1,
      sym__indent,
    STATE(323), 1,
      sym_children,
    ACTIONS(726), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(728), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [12791] = 2,
    ACTIONS(696), 14,
      sym__newline,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(698), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [12826] = 2,
    ACTIONS(877), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(879), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [12860] = 2,
    ACTIONS(975), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(977), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [12894] = 4,
    ACTIONS(1039), 1,
      sym__indent,
    STATE(406), 1,
      sym_children,
    ACTIONS(700), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(702), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [12932] = 2,
    ACTIONS(979), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(981), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [12966] = 2,
    ACTIONS(873), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(875), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [13000] = 2,
    ACTIONS(971), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(973), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [13034] = 4,
    ACTIONS(1041), 1,
      sym__indent,
    STATE(379), 1,
      sym_children,
    ACTIONS(706), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(708), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [13072] = 2,
    ACTIONS(845), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(847), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [13106] = 2,
    ACTIONS(959), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(961), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [13140] = 3,
    ACTIONS(1043), 1,
      sym__indent,
    ACTIONS(779), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(781), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [13176] = 3,
    ACTIONS(1049), 1,
      anon_sym_LPAREN,
    ACTIONS(1045), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(1047), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [13212] = 2,
    ACTIONS(684), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(686), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [13246] = 3,
    ACTIONS(1051), 1,
      sym__dedent,
    ACTIONS(953), 11,
      sym__newline,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(955), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [13282] = 3,
    ACTIONS(1053), 1,
      sym__dedent,
    ACTIONS(953), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(955), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [13318] = 2,
    ACTIONS(949), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(951), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [13352] = 2,
    ACTIONS(945), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(947), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [13386] = 2,
    ACTIONS(941), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(943), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [13420] = 2,
    ACTIONS(937), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(939), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [13454] = 2,
    ACTIONS(933), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(935), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [13488] = 3,
    ACTIONS(1055), 1,
      sym__dedent,
    ACTIONS(835), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(837), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [13524] = 2,
    ACTIONS(700), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(702), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [13558] = 2,
    ACTIONS(909), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(911), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [13592] = 2,
    ACTIONS(905), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(907), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [13626] = 2,
    ACTIONS(901), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(903), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [13660] = 2,
    ACTIONS(897), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(899), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [13694] = 2,
    ACTIONS(893), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(895), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [13728] = 2,
    ACTIONS(889), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(891), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [13762] = 2,
    ACTIONS(885), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(887), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [13796] = 3,
    ACTIONS(1057), 1,
      sym__newline,
    ACTIONS(893), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(895), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [13832] = 2,
    ACTIONS(881), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(883), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [13866] = 4,
    ACTIONS(1059), 1,
      anon_sym_else,
    STATE(341), 1,
      sym__each_else,
    ACTIONS(769), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(771), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [13904] = 3,
    ACTIONS(1061), 1,
      sym__dedent,
    ACTIONS(863), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(865), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [13940] = 2,
    ACTIONS(793), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(795), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [13974] = 4,
    ACTIONS(1063), 1,
      sym__un_delimited_javascript_line,
    STATE(288), 1,
      aux_sym__un_delimited_javascript_multiline,
    ACTIONS(677), 2,
      sym__newline,
      sym__dedent,
    ACTIONS(679), 25,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_COLON,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [14012] = 3,
    ACTIONS(1066), 1,
      sym__dedent,
    ACTIONS(863), 11,
      sym__newline,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(865), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [14048] = 4,
    ACTIONS(1068), 1,
      sym__un_delimited_javascript_line,
    STATE(288), 1,
      aux_sym__un_delimited_javascript_multiline,
    ACTIONS(710), 2,
      sym__newline,
      sym__dedent,
    ACTIONS(712), 25,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_COLON,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [14086] = 2,
    ACTIONS(732), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(734), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [14120] = 4,
    ACTIONS(1070), 1,
      sym__indent,
    STATE(379), 1,
      sym_children,
    ACTIONS(706), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(708), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [14158] = 2,
    ACTIONS(967), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(969), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [14192] = 4,
    ACTIONS(1041), 1,
      sym__indent,
    STATE(406), 1,
      sym_children,
    ACTIONS(700), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(702), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [14230] = 2,
    ACTIONS(829), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(831), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [14264] = 2,
    ACTIONS(706), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(708), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [14298] = 2,
    ACTIONS(921), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(923), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [14332] = 2,
    ACTIONS(726), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(728), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [14366] = 2,
    ACTIONS(913), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(915), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [14400] = 2,
    ACTIONS(835), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(837), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [14434] = 2,
    ACTIONS(797), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(799), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [14468] = 2,
    ACTIONS(805), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(807), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [14502] = 2,
    ACTIONS(671), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(673), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [14536] = 2,
    ACTIONS(839), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(841), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [14570] = 2,
    ACTIONS(696), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(698), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [14604] = 2,
    ACTIONS(835), 13,
      sym__dedent,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(837), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [14638] = 2,
    ACTIONS(825), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(827), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [14672] = 2,
    ACTIONS(855), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(857), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [14706] = 2,
    ACTIONS(869), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(871), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [14740] = 2,
    ACTIONS(813), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(815), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [14774] = 4,
    ACTIONS(1041), 1,
      sym__indent,
    STATE(400), 1,
      sym_children,
    ACTIONS(696), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(698), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [14812] = 2,
    ACTIONS(819), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(821), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [14846] = 4,
    ACTIONS(1072), 1,
      sym__indent,
    STATE(383), 1,
      sym_children,
    ACTIONS(732), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(734), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [14884] = 2,
    ACTIONS(859), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(861), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [14918] = 2,
    ACTIONS(667), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(669), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [14952] = 4,
    ACTIONS(1041), 1,
      sym__indent,
    STATE(393), 1,
      sym_children,
    ACTIONS(684), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(686), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [14990] = 4,
    ACTIONS(1074), 1,
      sym__indent,
    STATE(382), 1,
      sym_children,
    ACTIONS(726), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(728), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [15028] = 2,
    ACTIONS(789), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(791), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [15062] = 2,
    ACTIONS(917), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(919), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [15096] = 2,
    ACTIONS(963), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(965), 17,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_when,
      anon_sym_default,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [15130] = 2,
    ACTIONS(789), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(791), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [15163] = 2,
    ACTIONS(941), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(943), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [15196] = 2,
    ACTIONS(706), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(708), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [15229] = 2,
    ACTIONS(979), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(981), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [15262] = 2,
    ACTIONS(793), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(795), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [15295] = 2,
    ACTIONS(775), 2,
      sym__newline,
      sym__dedent,
    ACTIONS(777), 26,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_COLON,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      sym__un_delimited_javascript_line,
      anon_sym_DASH,
  [15328] = 3,
    ACTIONS(1076), 1,
      sym__indent,
    ACTIONS(779), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(781), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [15363] = 4,
    ACTIONS(1078), 1,
      anon_sym_else,
    STATE(410), 1,
      sym__each_else,
    ACTIONS(769), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(771), 14,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [15400] = 2,
    ACTIONS(1080), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(1082), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [15433] = 2,
    ACTIONS(1084), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(1086), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [15466] = 2,
    ACTIONS(1088), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(1090), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [15499] = 2,
    ACTIONS(975), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(977), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [15532] = 2,
    ACTIONS(877), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(879), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [15565] = 2,
    ACTIONS(813), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(815), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [15598] = 2,
    ACTIONS(819), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(821), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [15631] = 2,
    ACTIONS(881), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(883), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [15664] = 2,
    ACTIONS(696), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(698), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [15697] = 2,
    ACTIONS(885), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(887), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [15730] = 2,
    ACTIONS(921), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(923), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [15763] = 2,
    ACTIONS(917), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(919), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [15796] = 2,
    ACTIONS(805), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(807), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [15829] = 2,
    ACTIONS(971), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(973), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [15862] = 2,
    ACTIONS(797), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(799), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [15895] = 2,
    ACTIONS(1092), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(1094), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [15928] = 2,
    ACTIONS(1096), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(1098), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [15961] = 2,
    ACTIONS(829), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(831), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [15994] = 2,
    ACTIONS(967), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(969), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [16027] = 2,
    ACTIONS(684), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(686), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [16060] = 2,
    ACTIONS(1100), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(1102), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [16093] = 2,
    ACTIONS(959), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(961), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [16126] = 2,
    ACTIONS(889), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(891), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [16159] = 2,
    ACTIONS(873), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(875), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [16192] = 2,
    ACTIONS(897), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(899), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [16225] = 2,
    ACTIONS(913), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(915), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [16258] = 2,
    ACTIONS(901), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(903), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [16291] = 2,
    ACTIONS(905), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(907), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [16324] = 2,
    ACTIONS(909), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(911), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [16357] = 2,
    ACTIONS(825), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(827), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [16390] = 3,
    ACTIONS(1104), 1,
      sym__indent,
    ACTIONS(759), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(761), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [16425] = 2,
    ACTIONS(839), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(841), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [16458] = 2,
    ACTIONS(845), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(847), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [16491] = 2,
    ACTIONS(726), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(728), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [16524] = 2,
    ACTIONS(963), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(965), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [16557] = 2,
    ACTIONS(667), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(669), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [16590] = 2,
    ACTIONS(859), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(861), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [16623] = 2,
    ACTIONS(949), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(951), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [16656] = 2,
    ACTIONS(945), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(947), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [16689] = 2,
    ACTIONS(1106), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(1108), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [16722] = 2,
    ACTIONS(753), 3,
      sym__newline,
      sym__dedent,
      aux_sym_filter_content_token1,
    ACTIONS(755), 25,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_COLON,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [16755] = 2,
    ACTIONS(744), 3,
      sym__newline,
      sym__dedent,
      aux_sym_filter_content_token1,
    ACTIONS(746), 25,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_COLON,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [16788] = 2,
    ACTIONS(700), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(702), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [16821] = 2,
    ACTIONS(732), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(734), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [16854] = 2,
    ACTIONS(785), 3,
      sym__newline,
      sym__dedent,
      aux_sym_filter_content_token1,
    ACTIONS(787), 25,
      anon_sym_doctype,
      anon_sym_PIPE,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_COLON,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_case,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH,
      anon_sym_SLASH_SLASH_DASH,
      sym_tag_name,
      sym_class,
      sym_id,
      anon_sym_DASH,
  [16887] = 2,
    ACTIONS(937), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(939), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [16920] = 2,
    ACTIONS(933), 12,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(935), 16,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_mixin,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [16953] = 2,
    ACTIONS(877), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(879), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [16985] = 2,
    ACTIONS(933), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(935), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [17017] = 2,
    ACTIONS(979), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(981), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [17049] = 2,
    ACTIONS(700), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(702), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [17081] = 2,
    ACTIONS(793), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(795), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [17113] = 2,
    ACTIONS(975), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(977), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [17145] = 2,
    ACTIONS(706), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(708), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [17177] = 2,
    ACTIONS(726), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(728), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [17209] = 2,
    ACTIONS(732), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(734), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [17241] = 2,
    ACTIONS(839), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(841), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [17273] = 2,
    ACTIONS(825), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(827), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [17305] = 2,
    ACTIONS(971), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(973), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [17337] = 2,
    ACTIONS(959), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(961), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [17369] = 3,
    ACTIONS(1110), 1,
      sym__dedent,
    ACTIONS(953), 11,
      sym__newline,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(955), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [17403] = 2,
    ACTIONS(845), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(847), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [17435] = 3,
    ACTIONS(1112), 1,
      sym__dedent,
    ACTIONS(863), 11,
      sym__newline,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(865), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [17469] = 2,
    ACTIONS(829), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(831), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [17501] = 2,
    ACTIONS(696), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(698), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [17533] = 2,
    ACTIONS(963), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(965), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [17565] = 2,
    ACTIONS(913), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(915), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [17597] = 2,
    ACTIONS(819), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(821), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [17629] = 2,
    ACTIONS(967), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(969), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [17661] = 2,
    ACTIONS(949), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(951), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [17693] = 2,
    ACTIONS(921), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(923), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [17725] = 2,
    ACTIONS(789), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(791), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [17757] = 2,
    ACTIONS(917), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(919), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [17789] = 2,
    ACTIONS(945), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(947), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [17821] = 2,
    ACTIONS(941), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(943), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [17853] = 2,
    ACTIONS(937), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(939), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [17885] = 2,
    ACTIONS(835), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(837), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [17917] = 2,
    ACTIONS(684), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(686), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [17949] = 2,
    ACTIONS(667), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(669), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [17981] = 2,
    ACTIONS(859), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(861), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [18013] = 2,
    ACTIONS(797), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(799), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [18045] = 2,
    ACTIONS(805), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(807), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [18077] = 2,
    ACTIONS(813), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(815), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [18109] = 2,
    ACTIONS(909), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(911), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [18141] = 2,
    ACTIONS(905), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(907), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [18173] = 2,
    ACTIONS(901), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(903), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [18205] = 2,
    ACTIONS(897), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(899), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [18237] = 2,
    ACTIONS(893), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(895), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [18269] = 2,
    ACTIONS(889), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(891), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [18301] = 2,
    ACTIONS(885), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(887), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [18333] = 2,
    ACTIONS(881), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(883), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [18365] = 2,
    ACTIONS(873), 12,
      sym__newline,
      sym__dedent,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_elseif,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_script_DOT,
      anon_sym_SLASH_SLASH_DASH,
      sym_class,
      sym_id,
      anon_sym_DASH,
    ACTIONS(875), 15,
      anon_sym_doctype,
      anon_sym_include,
      anon_sym_while,
      anon_sym_else,
      anon_sym_each,
      anon_sym_for,
      anon_sym_block,
      anon_sym_append,
      anon_sym_prepend,
      anon_sym_extends,
      anon_sym_unless,
      anon_sym_if,
      anon_sym_case,
      anon_sym_SLASH_SLASH,
      sym_tag_name,
  [18397] = 7,
    ACTIONS(1114), 1,
      anon_sym_RPAREN,
    ACTIONS(1118), 1,
      anon_sym_SQUOTE,
    ACTIONS(1120), 1,
      anon_sym_DQUOTE,
    STATE(423), 1,
      aux_sym_mixin_use_repeat1,
    STATE(882), 1,
      sym__pug_attributes,
    ACTIONS(1116), 5,
      aux_sym__ternary_attribute_value_token1,
      aux_sym__variable_attribute_value_token1,
      aux_sym__object_attribute_value_token1,
      aux_sym__template_attribute_value_token1,
      aux_sym__array_attribute_value_token1,
    STATE(886), 7,
      sym__ternary_attribute_value,
      sym__string_attribute_value,
      sym__variable_attribute_value,
      sym__object_attribute_value,
      sym__template_attribute_value,
      sym__array_attribute_value,
      sym_quoted_attribute_value,
  [18429] = 6,
    ACTIONS(1125), 1,
      anon_sym_SQUOTE,
    ACTIONS(1128), 1,
      anon_sym_DQUOTE,
    STATE(422), 1,
      aux_sym_mixin_use_repeat1,
    STATE(976), 1,
      sym__pug_attributes,
    ACTIONS(1122), 5,
      aux_sym__ternary_attribute_value_token1,
      aux_sym__variable_attribute_value_token1,
      aux_sym__object_attribute_value_token1,
      aux_sym__template_attribute_value_token1,
      aux_sym__array_attribute_value_token1,
    STATE(886), 7,
      sym__ternary_attribute_value,
      sym__string_attribute_value,
      sym__variable_attribute_value,
      sym__object_attribute_value,
      sym__template_attribute_value,
      sym__array_attribute_value,
      sym_quoted_attribute_value,
  [18458] = 6,
    ACTIONS(1118), 1,
      anon_sym_SQUOTE,
    ACTIONS(1120), 1,
      anon_sym_DQUOTE,
    STATE(422), 1,
      aux_sym_mixin_use_repeat1,
    STATE(879), 1,
      sym__pug_attributes,
    ACTIONS(1116), 5,
      aux_sym__ternary_attribute_value_token1,
      aux_sym__variable_attribute_value_token1,
      aux_sym__object_attribute_value_token1,
      aux_sym__template_attribute_value_token1,
      aux_sym__array_attribute_value_token1,
    STATE(886), 7,
      sym__ternary_attribute_value,
      sym__string_attribute_value,
      sym__variable_attribute_value,
      sym__object_attribute_value,
      sym__template_attribute_value,
      sym__array_attribute_value,
      sym_quoted_attribute_value,
  [18487] = 12,
    ACTIONS(1131), 1,
      anon_sym_LPAREN,
    ACTIONS(1133), 1,
      anon_sym_COLON,
    ACTIONS(1135), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1137), 1,
      anon_sym_EQ,
    ACTIONS(1139), 1,
      anon_sym_SLASH,
    ACTIONS(1141), 1,
      anon_sym_,
    ACTIONS(1143), 1,
      anon_sym_DOT,
    ACTIONS(1147), 1,
      sym__newline,
    STATE(431), 1,
      aux_sym_tag_repeat1,
    STATE(459), 1,
      sym_attributes,
    ACTIONS(1145), 2,
      sym_class,
      sym_id,
    STATE(384), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [18527] = 12,
    ACTIONS(1131), 1,
      anon_sym_LPAREN,
    ACTIONS(1149), 1,
      anon_sym_COLON,
    ACTIONS(1151), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1153), 1,
      anon_sym_EQ,
    ACTIONS(1155), 1,
      anon_sym_SLASH,
    ACTIONS(1157), 1,
      anon_sym_,
    ACTIONS(1159), 1,
      anon_sym_DOT,
    ACTIONS(1163), 1,
      sym__newline,
    STATE(440), 1,
      aux_sym_tag_repeat1,
    STATE(457), 1,
      sym_attributes,
    ACTIONS(1161), 2,
      sym_class,
      sym_id,
    STATE(127), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [18567] = 12,
    ACTIONS(1131), 1,
      anon_sym_LPAREN,
    ACTIONS(1165), 1,
      anon_sym_COLON,
    ACTIONS(1167), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1169), 1,
      anon_sym_EQ,
    ACTIONS(1171), 1,
      anon_sym_SLASH,
    ACTIONS(1173), 1,
      anon_sym_,
    ACTIONS(1175), 1,
      anon_sym_DOT,
    ACTIONS(1177), 1,
      sym__newline,
    STATE(440), 1,
      aux_sym_tag_repeat1,
    STATE(466), 1,
      sym_attributes,
    ACTIONS(1161), 2,
      sym_class,
      sym_id,
    STATE(649), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [18607] = 12,
    ACTIONS(1131), 1,
      anon_sym_LPAREN,
    ACTIONS(1151), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1153), 1,
      anon_sym_EQ,
    ACTIONS(1159), 1,
      anon_sym_DOT,
    ACTIONS(1179), 1,
      anon_sym_COLON,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_,
    ACTIONS(1187), 1,
      sym__newline,
    STATE(425), 1,
      aux_sym_tag_repeat1,
    STATE(456), 1,
      sym_attributes,
    ACTIONS(1185), 2,
      sym_class,
      sym_id,
    STATE(135), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [18647] = 5,
    ACTIONS(1191), 1,
      anon_sym_SQUOTE,
    ACTIONS(1193), 1,
      anon_sym_DQUOTE,
    STATE(744), 1,
      sym__pug_attributes,
    ACTIONS(1189), 5,
      aux_sym__ternary_attribute_value_token1,
      aux_sym__variable_attribute_value_token1,
      aux_sym__object_attribute_value_token1,
      aux_sym__template_attribute_value_token1,
      aux_sym__array_attribute_value_token1,
    STATE(740), 7,
      sym__ternary_attribute_value,
      sym__string_attribute_value,
      sym__variable_attribute_value,
      sym__object_attribute_value,
      sym__template_attribute_value,
      sym__array_attribute_value,
      sym_quoted_attribute_value,
  [18673] = 12,
    ACTIONS(1131), 1,
      anon_sym_LPAREN,
    ACTIONS(1195), 1,
      anon_sym_COLON,
    ACTIONS(1197), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1199), 1,
      anon_sym_EQ,
    ACTIONS(1201), 1,
      anon_sym_SLASH,
    ACTIONS(1203), 1,
      anon_sym_,
    ACTIONS(1205), 1,
      anon_sym_DOT,
    ACTIONS(1209), 1,
      sym__newline,
    STATE(439), 1,
      aux_sym_tag_repeat1,
    STATE(469), 1,
      sym_attributes,
    ACTIONS(1207), 2,
      sym_class,
      sym_id,
    STATE(228), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [18713] = 12,
    ACTIONS(1131), 1,
      anon_sym_LPAREN,
    ACTIONS(1211), 1,
      anon_sym_COLON,
    ACTIONS(1213), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1215), 1,
      anon_sym_EQ,
    ACTIONS(1217), 1,
      anon_sym_SLASH,
    ACTIONS(1219), 1,
      anon_sym_,
    ACTIONS(1221), 1,
      anon_sym_DOT,
    ACTIONS(1223), 1,
      sym__newline,
    STATE(440), 1,
      aux_sym_tag_repeat1,
    STATE(461), 1,
      sym_attributes,
    ACTIONS(1161), 2,
      sym_class,
      sym_id,
    STATE(362), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [18753] = 12,
    ACTIONS(1131), 1,
      anon_sym_LPAREN,
    ACTIONS(1135), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1137), 1,
      anon_sym_EQ,
    ACTIONS(1143), 1,
      anon_sym_DOT,
    ACTIONS(1225), 1,
      anon_sym_COLON,
    ACTIONS(1227), 1,
      anon_sym_SLASH,
    ACTIONS(1229), 1,
      anon_sym_,
    ACTIONS(1231), 1,
      sym__newline,
    STATE(440), 1,
      aux_sym_tag_repeat1,
    STATE(460), 1,
      sym_attributes,
    ACTIONS(1161), 2,
      sym_class,
      sym_id,
    STATE(383), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [18793] = 12,
    ACTIONS(1131), 1,
      anon_sym_LPAREN,
    ACTIONS(1233), 1,
      anon_sym_COLON,
    ACTIONS(1235), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1237), 1,
      anon_sym_EQ,
    ACTIONS(1239), 1,
      anon_sym_SLASH,
    ACTIONS(1241), 1,
      anon_sym_,
    ACTIONS(1243), 1,
      anon_sym_DOT,
    ACTIONS(1245), 1,
      sym__newline,
    STATE(440), 1,
      aux_sym_tag_repeat1,
    STATE(465), 1,
      sym_attributes,
    ACTIONS(1161), 2,
      sym_class,
      sym_id,
    STATE(298), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [18833] = 12,
    ACTIONS(1131), 1,
      anon_sym_LPAREN,
    ACTIONS(1167), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1169), 1,
      anon_sym_EQ,
    ACTIONS(1175), 1,
      anon_sym_DOT,
    ACTIONS(1247), 1,
      anon_sym_COLON,
    ACTIONS(1249), 1,
      anon_sym_SLASH,
    ACTIONS(1251), 1,
      anon_sym_,
    ACTIONS(1255), 1,
      sym__newline,
    STATE(426), 1,
      aux_sym_tag_repeat1,
    STATE(462), 1,
      sym_attributes,
    ACTIONS(1253), 2,
      sym_class,
      sym_id,
    STATE(653), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [18873] = 12,
    ACTIONS(1131), 1,
      anon_sym_LPAREN,
    ACTIONS(1213), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1215), 1,
      anon_sym_EQ,
    ACTIONS(1221), 1,
      anon_sym_DOT,
    ACTIONS(1257), 1,
      anon_sym_COLON,
    ACTIONS(1259), 1,
      anon_sym_SLASH,
    ACTIONS(1261), 1,
      anon_sym_,
    ACTIONS(1265), 1,
      sym__newline,
    STATE(430), 1,
      aux_sym_tag_repeat1,
    STATE(464), 1,
      sym_attributes,
    ACTIONS(1263), 2,
      sym_class,
      sym_id,
    STATE(372), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [18913] = 5,
    ACTIONS(1191), 1,
      anon_sym_SQUOTE,
    ACTIONS(1193), 1,
      anon_sym_DQUOTE,
    STATE(733), 1,
      sym__pug_attributes,
    ACTIONS(1189), 5,
      aux_sym__ternary_attribute_value_token1,
      aux_sym__variable_attribute_value_token1,
      aux_sym__object_attribute_value_token1,
      aux_sym__template_attribute_value_token1,
      aux_sym__array_attribute_value_token1,
    STATE(740), 7,
      sym__ternary_attribute_value,
      sym__string_attribute_value,
      sym__variable_attribute_value,
      sym__object_attribute_value,
      sym__template_attribute_value,
      sym__array_attribute_value,
      sym_quoted_attribute_value,
  [18939] = 12,
    ACTIONS(1131), 1,
      anon_sym_LPAREN,
    ACTIONS(1235), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1237), 1,
      anon_sym_EQ,
    ACTIONS(1243), 1,
      anon_sym_DOT,
    ACTIONS(1267), 1,
      anon_sym_COLON,
    ACTIONS(1269), 1,
      anon_sym_SLASH,
    ACTIONS(1271), 1,
      anon_sym_,
    ACTIONS(1275), 1,
      sym__newline,
    STATE(432), 1,
      aux_sym_tag_repeat1,
    STATE(463), 1,
      sym_attributes,
    ACTIONS(1273), 2,
      sym_class,
      sym_id,
    STATE(291), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [18979] = 12,
    ACTIONS(1131), 1,
      anon_sym_LPAREN,
    ACTIONS(1277), 1,
      anon_sym_COLON,
    ACTIONS(1279), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1281), 1,
      anon_sym_EQ,
    ACTIONS(1283), 1,
      anon_sym_SLASH,
    ACTIONS(1285), 1,
      anon_sym_,
    ACTIONS(1287), 1,
      anon_sym_DOT,
    ACTIONS(1291), 1,
      sym__newline,
    STATE(438), 1,
      aux_sym_tag_repeat1,
    STATE(458), 1,
      sym_attributes,
    ACTIONS(1289), 2,
      sym_class,
      sym_id,
    STATE(177), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [19019] = 12,
    ACTIONS(1131), 1,
      anon_sym_LPAREN,
    ACTIONS(1279), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1281), 1,
      anon_sym_EQ,
    ACTIONS(1287), 1,
      anon_sym_DOT,
    ACTIONS(1293), 1,
      anon_sym_COLON,
    ACTIONS(1295), 1,
      anon_sym_SLASH,
    ACTIONS(1297), 1,
      anon_sym_,
    ACTIONS(1299), 1,
      sym__newline,
    STATE(440), 1,
      aux_sym_tag_repeat1,
    STATE(467), 1,
      sym_attributes,
    ACTIONS(1161), 2,
      sym_class,
      sym_id,
    STATE(173), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [19059] = 12,
    ACTIONS(1131), 1,
      anon_sym_LPAREN,
    ACTIONS(1197), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1199), 1,
      anon_sym_EQ,
    ACTIONS(1205), 1,
      anon_sym_DOT,
    ACTIONS(1301), 1,
      anon_sym_COLON,
    ACTIONS(1303), 1,
      anon_sym_SLASH,
    ACTIONS(1305), 1,
      anon_sym_,
    ACTIONS(1307), 1,
      sym__newline,
    STATE(440), 1,
      aux_sym_tag_repeat1,
    STATE(468), 1,
      sym_attributes,
    ACTIONS(1161), 2,
      sym_class,
      sym_id,
    STATE(215), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [19099] = 4,
    STATE(440), 1,
      aux_sym_tag_repeat1,
    ACTIONS(1311), 2,
      sym__newline,
      anon_sym_,
    ACTIONS(1313), 2,
      sym_class,
      sym_id,
    ACTIONS(1309), 6,
      anon_sym_LPAREN,
      anon_sym_COLON,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_DOT,
  [19119] = 7,
    ACTIONS(1316), 1,
      anon_sym_RPAREN,
    ACTIONS(1320), 1,
      sym_attribute_name,
    STATE(452), 1,
      aux_sym_attributes_repeat1,
    STATE(701), 1,
      sym_angular_attribute_name,
    STATE(798), 1,
      sym_attribute,
    STATE(787), 2,
      sym__attribute,
      sym__angular_attribute,
    ACTIONS(1318), 4,
      aux_sym_angular_attribute_name_token1,
      aux_sym_angular_attribute_name_token2,
      aux_sym_angular_attribute_name_token3,
      aux_sym_angular_attribute_name_token4,
  [19145] = 7,
    ACTIONS(1320), 1,
      sym_attribute_name,
    ACTIONS(1322), 1,
      anon_sym_RPAREN,
    STATE(449), 1,
      aux_sym_attributes_repeat1,
    STATE(701), 1,
      sym_angular_attribute_name,
    STATE(797), 1,
      sym_attribute,
    STATE(787), 2,
      sym__attribute,
      sym__angular_attribute,
    ACTIONS(1318), 4,
      aux_sym_angular_attribute_name_token1,
      aux_sym_angular_attribute_name_token2,
      aux_sym_angular_attribute_name_token3,
      aux_sym_angular_attribute_name_token4,
  [19171] = 7,
    ACTIONS(1320), 1,
      sym_attribute_name,
    ACTIONS(1324), 1,
      anon_sym_RPAREN,
    STATE(455), 1,
      aux_sym_attributes_repeat1,
    STATE(701), 1,
      sym_angular_attribute_name,
    STATE(722), 1,
      sym_attribute,
    STATE(787), 2,
      sym__attribute,
      sym__angular_attribute,
    ACTIONS(1318), 4,
      aux_sym_angular_attribute_name_token1,
      aux_sym_angular_attribute_name_token2,
      aux_sym_angular_attribute_name_token3,
      aux_sym_angular_attribute_name_token4,
  [19197] = 7,
    ACTIONS(1320), 1,
      sym_attribute_name,
    ACTIONS(1326), 1,
      anon_sym_RPAREN,
    STATE(445), 1,
      aux_sym_attributes_repeat1,
    STATE(701), 1,
      sym_angular_attribute_name,
    STATE(768), 1,
      sym_attribute,
    STATE(787), 2,
      sym__attribute,
      sym__angular_attribute,
    ACTIONS(1318), 4,
      aux_sym_angular_attribute_name_token1,
      aux_sym_angular_attribute_name_token2,
      aux_sym_angular_attribute_name_token3,
      aux_sym_angular_attribute_name_token4,
  [19223] = 7,
    ACTIONS(1320), 1,
      sym_attribute_name,
    ACTIONS(1328), 1,
      anon_sym_RPAREN,
    STATE(455), 1,
      aux_sym_attributes_repeat1,
    STATE(701), 1,
      sym_angular_attribute_name,
    STATE(777), 1,
      sym_attribute,
    STATE(787), 2,
      sym__attribute,
      sym__angular_attribute,
    ACTIONS(1318), 4,
      aux_sym_angular_attribute_name_token1,
      aux_sym_angular_attribute_name_token2,
      aux_sym_angular_attribute_name_token3,
      aux_sym_angular_attribute_name_token4,
  [19249] = 7,
    ACTIONS(1320), 1,
      sym_attribute_name,
    ACTIONS(1330), 1,
      anon_sym_RPAREN,
    STATE(451), 1,
      aux_sym_attributes_repeat1,
    STATE(701), 1,
      sym_angular_attribute_name,
    STATE(779), 1,
      sym_attribute,
    STATE(787), 2,
      sym__attribute,
      sym__angular_attribute,
    ACTIONS(1318), 4,
      aux_sym_angular_attribute_name_token1,
      aux_sym_angular_attribute_name_token2,
      aux_sym_angular_attribute_name_token3,
      aux_sym_angular_attribute_name_token4,
  [19275] = 7,
    ACTIONS(1320), 1,
      sym_attribute_name,
    ACTIONS(1332), 1,
      anon_sym_RPAREN,
    STATE(455), 1,
      aux_sym_attributes_repeat1,
    STATE(701), 1,
      sym_angular_attribute_name,
    STATE(719), 1,
      sym_attribute,
    STATE(787), 2,
      sym__attribute,
      sym__angular_attribute,
    ACTIONS(1318), 4,
      aux_sym_angular_attribute_name_token1,
      aux_sym_angular_attribute_name_token2,
      aux_sym_angular_attribute_name_token3,
      aux_sym_angular_attribute_name_token4,
  [19301] = 7,
    ACTIONS(1320), 1,
      sym_attribute_name,
    ACTIONS(1334), 1,
      anon_sym_RPAREN,
    STATE(455), 1,
      aux_sym_attributes_repeat1,
    STATE(701), 1,
      sym_angular_attribute_name,
    STATE(784), 1,
      sym_attribute,
    STATE(787), 2,
      sym__attribute,
      sym__angular_attribute,
    ACTIONS(1318), 4,
      aux_sym_angular_attribute_name_token1,
      aux_sym_angular_attribute_name_token2,
      aux_sym_angular_attribute_name_token3,
      aux_sym_angular_attribute_name_token4,
  [19327] = 7,
    ACTIONS(1320), 1,
      sym_attribute_name,
    ACTIONS(1336), 1,
      anon_sym_RPAREN,
    STATE(455), 1,
      aux_sym_attributes_repeat1,
    STATE(701), 1,
      sym_angular_attribute_name,
    STATE(793), 1,
      sym_attribute,
    STATE(787), 2,
      sym__attribute,
      sym__angular_attribute,
    ACTIONS(1318), 4,
      aux_sym_angular_attribute_name_token1,
      aux_sym_angular_attribute_name_token2,
      aux_sym_angular_attribute_name_token3,
      aux_sym_angular_attribute_name_token4,
  [19353] = 7,
    ACTIONS(1320), 1,
      sym_attribute_name,
    ACTIONS(1338), 1,
      anon_sym_RPAREN,
    STATE(443), 1,
      aux_sym_attributes_repeat1,
    STATE(701), 1,
      sym_angular_attribute_name,
    STATE(778), 1,
      sym_attribute,
    STATE(787), 2,
      sym__attribute,
      sym__angular_attribute,
    ACTIONS(1318), 4,
      aux_sym_angular_attribute_name_token1,
      aux_sym_angular_attribute_name_token2,
      aux_sym_angular_attribute_name_token3,
      aux_sym_angular_attribute_name_token4,
  [19379] = 7,
    ACTIONS(1320), 1,
      sym_attribute_name,
    ACTIONS(1340), 1,
      anon_sym_RPAREN,
    STATE(455), 1,
      aux_sym_attributes_repeat1,
    STATE(701), 1,
      sym_angular_attribute_name,
    STATE(776), 1,
      sym_attribute,
    STATE(787), 2,
      sym__attribute,
      sym__angular_attribute,
    ACTIONS(1318), 4,
      aux_sym_angular_attribute_name_token1,
      aux_sym_angular_attribute_name_token2,
      aux_sym_angular_attribute_name_token3,
      aux_sym_angular_attribute_name_token4,
  [19405] = 7,
    ACTIONS(1320), 1,
      sym_attribute_name,
    ACTIONS(1342), 1,
      anon_sym_RPAREN,
    STATE(455), 1,
      aux_sym_attributes_repeat1,
    STATE(701), 1,
      sym_angular_attribute_name,
    STATE(766), 1,
      sym_attribute,
    STATE(787), 2,
      sym__attribute,
      sym__angular_attribute,
    ACTIONS(1318), 4,
      aux_sym_angular_attribute_name_token1,
      aux_sym_angular_attribute_name_token2,
      aux_sym_angular_attribute_name_token3,
      aux_sym_angular_attribute_name_token4,
  [19431] = 7,
    ACTIONS(1320), 1,
      sym_attribute_name,
    ACTIONS(1344), 1,
      anon_sym_RPAREN,
    STATE(447), 1,
      aux_sym_attributes_repeat1,
    STATE(701), 1,
      sym_angular_attribute_name,
    STATE(810), 1,
      sym_attribute,
    STATE(787), 2,
      sym__attribute,
      sym__angular_attribute,
    ACTIONS(1318), 4,
      aux_sym_angular_attribute_name_token1,
      aux_sym_angular_attribute_name_token2,
      aux_sym_angular_attribute_name_token3,
      aux_sym_angular_attribute_name_token4,
  [19457] = 7,
    ACTIONS(1320), 1,
      sym_attribute_name,
    ACTIONS(1346), 1,
      anon_sym_RPAREN,
    STATE(448), 1,
      aux_sym_attributes_repeat1,
    STATE(701), 1,
      sym_angular_attribute_name,
    STATE(788), 1,
      sym_attribute,
    STATE(787), 2,
      sym__attribute,
      sym__angular_attribute,
    ACTIONS(1318), 4,
      aux_sym_angular_attribute_name_token1,
      aux_sym_angular_attribute_name_token2,
      aux_sym_angular_attribute_name_token3,
      aux_sym_angular_attribute_name_token4,
  [19483] = 7,
    ACTIONS(1348), 1,
      anon_sym_RPAREN,
    ACTIONS(1353), 1,
      sym_attribute_name,
    STATE(455), 1,
      aux_sym_attributes_repeat1,
    STATE(701), 1,
      sym_angular_attribute_name,
    STATE(853), 1,
      sym_attribute,
    STATE(787), 2,
      sym__attribute,
      sym__angular_attribute,
    ACTIONS(1350), 4,
      aux_sym_angular_attribute_name_token1,
      aux_sym_angular_attribute_name_token2,
      aux_sym_angular_attribute_name_token3,
      aux_sym_angular_attribute_name_token4,
  [19509] = 8,
    ACTIONS(1149), 1,
      anon_sym_COLON,
    ACTIONS(1151), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1153), 1,
      anon_sym_EQ,
    ACTIONS(1155), 1,
      anon_sym_SLASH,
    ACTIONS(1157), 1,
      anon_sym_,
    ACTIONS(1159), 1,
      anon_sym_DOT,
    ACTIONS(1163), 1,
      sym__newline,
    STATE(127), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [19536] = 8,
    ACTIONS(1151), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1153), 1,
      anon_sym_EQ,
    ACTIONS(1159), 1,
      anon_sym_DOT,
    ACTIONS(1356), 1,
      anon_sym_COLON,
    ACTIONS(1358), 1,
      anon_sym_SLASH,
    ACTIONS(1360), 1,
      anon_sym_,
    ACTIONS(1362), 1,
      sym__newline,
    STATE(121), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [19563] = 8,
    ACTIONS(1279), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1281), 1,
      anon_sym_EQ,
    ACTIONS(1287), 1,
      anon_sym_DOT,
    ACTIONS(1293), 1,
      anon_sym_COLON,
    ACTIONS(1295), 1,
      anon_sym_SLASH,
    ACTIONS(1297), 1,
      anon_sym_,
    ACTIONS(1299), 1,
      sym__newline,
    STATE(173), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [19590] = 8,
    ACTIONS(1135), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1137), 1,
      anon_sym_EQ,
    ACTIONS(1143), 1,
      anon_sym_DOT,
    ACTIONS(1225), 1,
      anon_sym_COLON,
    ACTIONS(1227), 1,
      anon_sym_SLASH,
    ACTIONS(1229), 1,
      anon_sym_,
    ACTIONS(1231), 1,
      sym__newline,
    STATE(383), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [19617] = 8,
    ACTIONS(1135), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1137), 1,
      anon_sym_EQ,
    ACTIONS(1143), 1,
      anon_sym_DOT,
    ACTIONS(1364), 1,
      anon_sym_COLON,
    ACTIONS(1366), 1,
      anon_sym_SLASH,
    ACTIONS(1368), 1,
      anon_sym_,
    ACTIONS(1370), 1,
      sym__newline,
    STATE(382), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [19644] = 8,
    ACTIONS(1213), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1215), 1,
      anon_sym_EQ,
    ACTIONS(1221), 1,
      anon_sym_DOT,
    ACTIONS(1372), 1,
      anon_sym_COLON,
    ACTIONS(1374), 1,
      anon_sym_SLASH,
    ACTIONS(1376), 1,
      anon_sym_,
    ACTIONS(1378), 1,
      sym__newline,
    STATE(323), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [19671] = 8,
    ACTIONS(1165), 1,
      anon_sym_COLON,
    ACTIONS(1167), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1169), 1,
      anon_sym_EQ,
    ACTIONS(1171), 1,
      anon_sym_SLASH,
    ACTIONS(1173), 1,
      anon_sym_,
    ACTIONS(1175), 1,
      anon_sym_DOT,
    ACTIONS(1177), 1,
      sym__newline,
    STATE(649), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [19698] = 8,
    ACTIONS(1233), 1,
      anon_sym_COLON,
    ACTIONS(1235), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1237), 1,
      anon_sym_EQ,
    ACTIONS(1239), 1,
      anon_sym_SLASH,
    ACTIONS(1241), 1,
      anon_sym_,
    ACTIONS(1243), 1,
      anon_sym_DOT,
    ACTIONS(1245), 1,
      sym__newline,
    STATE(298), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [19725] = 8,
    ACTIONS(1211), 1,
      anon_sym_COLON,
    ACTIONS(1213), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1215), 1,
      anon_sym_EQ,
    ACTIONS(1217), 1,
      anon_sym_SLASH,
    ACTIONS(1219), 1,
      anon_sym_,
    ACTIONS(1221), 1,
      anon_sym_DOT,
    ACTIONS(1223), 1,
      sym__newline,
    STATE(362), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [19752] = 8,
    ACTIONS(1235), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1237), 1,
      anon_sym_EQ,
    ACTIONS(1243), 1,
      anon_sym_DOT,
    ACTIONS(1380), 1,
      anon_sym_COLON,
    ACTIONS(1382), 1,
      anon_sym_SLASH,
    ACTIONS(1384), 1,
      anon_sym_,
    ACTIONS(1386), 1,
      sym__newline,
    STATE(296), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [19779] = 8,
    ACTIONS(1167), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1169), 1,
      anon_sym_EQ,
    ACTIONS(1175), 1,
      anon_sym_DOT,
    ACTIONS(1388), 1,
      anon_sym_COLON,
    ACTIONS(1390), 1,
      anon_sym_SLASH,
    ACTIONS(1392), 1,
      anon_sym_,
    ACTIONS(1394), 1,
      sym__newline,
    STATE(632), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [19806] = 8,
    ACTIONS(1279), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1281), 1,
      anon_sym_EQ,
    ACTIONS(1287), 1,
      anon_sym_DOT,
    ACTIONS(1396), 1,
      anon_sym_COLON,
    ACTIONS(1398), 1,
      anon_sym_SLASH,
    ACTIONS(1400), 1,
      anon_sym_,
    ACTIONS(1402), 1,
      sym__newline,
    STATE(164), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [19833] = 8,
    ACTIONS(1197), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1199), 1,
      anon_sym_EQ,
    ACTIONS(1205), 1,
      anon_sym_DOT,
    ACTIONS(1404), 1,
      anon_sym_COLON,
    ACTIONS(1406), 1,
      anon_sym_SLASH,
    ACTIONS(1408), 1,
      anon_sym_,
    ACTIONS(1410), 1,
      sym__newline,
    STATE(199), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [19860] = 8,
    ACTIONS(1197), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1199), 1,
      anon_sym_EQ,
    ACTIONS(1205), 1,
      anon_sym_DOT,
    ACTIONS(1301), 1,
      anon_sym_COLON,
    ACTIONS(1303), 1,
      anon_sym_SLASH,
    ACTIONS(1305), 1,
      anon_sym_,
    ACTIONS(1307), 1,
      sym__newline,
    STATE(215), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [19887] = 7,
    ACTIONS(1151), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1153), 1,
      anon_sym_EQ,
    ACTIONS(1159), 1,
      anon_sym_DOT,
    ACTIONS(1356), 1,
      anon_sym_COLON,
    ACTIONS(1360), 1,
      anon_sym_,
    ACTIONS(1362), 1,
      sym__newline,
    STATE(121), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [19911] = 8,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1418), 1,
      sym__newline,
    ACTIONS(1420), 1,
      sym__dedent,
    STATE(483), 1,
      aux_sym__content_after_dot_repeat1,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(566), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [19937] = 7,
    ACTIONS(1197), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1199), 1,
      anon_sym_EQ,
    ACTIONS(1205), 1,
      anon_sym_DOT,
    ACTIONS(1422), 1,
      anon_sym_COLON,
    ACTIONS(1424), 1,
      anon_sym_,
    ACTIONS(1426), 1,
      sym__newline,
    STATE(191), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [19961] = 8,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1418), 1,
      sym__newline,
    ACTIONS(1428), 1,
      sym__dedent,
    STATE(483), 1,
      aux_sym__content_after_dot_repeat1,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(566), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [19987] = 7,
    ACTIONS(1279), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1281), 1,
      anon_sym_EQ,
    ACTIONS(1287), 1,
      anon_sym_DOT,
    ACTIONS(1430), 1,
      anon_sym_COLON,
    ACTIONS(1432), 1,
      anon_sym_,
    ACTIONS(1434), 1,
      sym__newline,
    STATE(156), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [20011] = 8,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1418), 1,
      sym__newline,
    ACTIONS(1436), 1,
      sym__dedent,
    STATE(483), 1,
      aux_sym__content_after_dot_repeat1,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(566), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [20037] = 7,
    ACTIONS(1197), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1199), 1,
      anon_sym_EQ,
    ACTIONS(1205), 1,
      anon_sym_DOT,
    ACTIONS(1404), 1,
      anon_sym_COLON,
    ACTIONS(1408), 1,
      anon_sym_,
    ACTIONS(1410), 1,
      sym__newline,
    STATE(199), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [20061] = 8,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1418), 1,
      sym__newline,
    ACTIONS(1438), 1,
      sym__dedent,
    STATE(483), 1,
      aux_sym__content_after_dot_repeat1,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(566), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [20087] = 1,
    ACTIONS(1440), 9,
      anon_sym_html,
      anon_sym_strict,
      anon_sym_xml,
      anon_sym_transitional,
      anon_sym_frameset,
      anon_sym_1_DOT1,
      anon_sym_basic,
      anon_sym_mobile,
      anon_sym_plist,
  [20099] = 8,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1418), 1,
      sym__newline,
    ACTIONS(1442), 1,
      sym__dedent,
    STATE(483), 1,
      aux_sym__content_after_dot_repeat1,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(566), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [20125] = 8,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1418), 1,
      sym__newline,
    ACTIONS(1444), 1,
      sym__dedent,
    STATE(483), 1,
      aux_sym__content_after_dot_repeat1,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(566), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [20151] = 8,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1418), 1,
      sym__newline,
    ACTIONS(1446), 1,
      sym__dedent,
    STATE(483), 1,
      aux_sym__content_after_dot_repeat1,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(566), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [20177] = 7,
    ACTIONS(1197), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1199), 1,
      anon_sym_EQ,
    ACTIONS(1205), 1,
      anon_sym_DOT,
    ACTIONS(1301), 1,
      anon_sym_COLON,
    ACTIONS(1305), 1,
      anon_sym_,
    ACTIONS(1307), 1,
      sym__newline,
    STATE(215), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [20201] = 8,
    ACTIONS(1448), 1,
      aux_sym_content_token1,
    ACTIONS(1451), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1454), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1457), 1,
      sym__newline,
    ACTIONS(1460), 1,
      sym__dedent,
    STATE(483), 1,
      aux_sym__content_after_dot_repeat1,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(566), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [20227] = 7,
    ACTIONS(1149), 1,
      anon_sym_COLON,
    ACTIONS(1151), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1153), 1,
      anon_sym_EQ,
    ACTIONS(1157), 1,
      anon_sym_,
    ACTIONS(1159), 1,
      anon_sym_DOT,
    ACTIONS(1163), 1,
      sym__newline,
    STATE(127), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [20251] = 7,
    ACTIONS(1235), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1237), 1,
      anon_sym_EQ,
    ACTIONS(1243), 1,
      anon_sym_DOT,
    ACTIONS(1462), 1,
      anon_sym_COLON,
    ACTIONS(1464), 1,
      anon_sym_,
    ACTIONS(1466), 1,
      sym__newline,
    STATE(275), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [20275] = 7,
    ACTIONS(1167), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1169), 1,
      anon_sym_EQ,
    ACTIONS(1175), 1,
      anon_sym_DOT,
    ACTIONS(1388), 1,
      anon_sym_COLON,
    ACTIONS(1392), 1,
      anon_sym_,
    ACTIONS(1394), 1,
      sym__newline,
    STATE(632), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [20299] = 1,
    ACTIONS(1468), 9,
      anon_sym_html,
      anon_sym_strict,
      anon_sym_xml,
      anon_sym_transitional,
      anon_sym_frameset,
      anon_sym_1_DOT1,
      anon_sym_basic,
      anon_sym_mobile,
      anon_sym_plist,
  [20311] = 8,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1418), 1,
      sym__newline,
    ACTIONS(1470), 1,
      sym__dedent,
    STATE(483), 1,
      aux_sym__content_after_dot_repeat1,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(566), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [20337] = 1,
    ACTIONS(1472), 9,
      anon_sym_html,
      anon_sym_strict,
      anon_sym_xml,
      anon_sym_transitional,
      anon_sym_frameset,
      anon_sym_1_DOT1,
      anon_sym_basic,
      anon_sym_mobile,
      anon_sym_plist,
  [20349] = 8,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1418), 1,
      sym__newline,
    ACTIONS(1474), 1,
      sym__dedent,
    STATE(483), 1,
      aux_sym__content_after_dot_repeat1,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(566), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [20375] = 7,
    ACTIONS(1135), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1137), 1,
      anon_sym_EQ,
    ACTIONS(1143), 1,
      anon_sym_DOT,
    ACTIONS(1476), 1,
      anon_sym_COLON,
    ACTIONS(1478), 1,
      anon_sym_,
    ACTIONS(1480), 1,
      sym__newline,
    STATE(379), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [20399] = 7,
    ACTIONS(1165), 1,
      anon_sym_COLON,
    ACTIONS(1167), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1169), 1,
      anon_sym_EQ,
    ACTIONS(1173), 1,
      anon_sym_,
    ACTIONS(1175), 1,
      anon_sym_DOT,
    ACTIONS(1177), 1,
      sym__newline,
    STATE(649), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [20423] = 7,
    ACTIONS(1151), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1153), 1,
      anon_sym_EQ,
    ACTIONS(1159), 1,
      anon_sym_DOT,
    ACTIONS(1482), 1,
      anon_sym_COLON,
    ACTIONS(1484), 1,
      anon_sym_,
    ACTIONS(1486), 1,
      sym__newline,
    STATE(114), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [20447] = 8,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1418), 1,
      sym__newline,
    ACTIONS(1488), 1,
      sym__dedent,
    STATE(483), 1,
      aux_sym__content_after_dot_repeat1,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(566), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [20473] = 7,
    ACTIONS(1213), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1215), 1,
      anon_sym_EQ,
    ACTIONS(1221), 1,
      anon_sym_DOT,
    ACTIONS(1490), 1,
      anon_sym_COLON,
    ACTIONS(1492), 1,
      anon_sym_,
    ACTIONS(1494), 1,
      sym__newline,
    STATE(371), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [20497] = 7,
    ACTIONS(1235), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1237), 1,
      anon_sym_EQ,
    ACTIONS(1243), 1,
      anon_sym_DOT,
    ACTIONS(1380), 1,
      anon_sym_COLON,
    ACTIONS(1384), 1,
      anon_sym_,
    ACTIONS(1386), 1,
      sym__newline,
    STATE(296), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [20521] = 7,
    ACTIONS(1279), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1281), 1,
      anon_sym_EQ,
    ACTIONS(1287), 1,
      anon_sym_DOT,
    ACTIONS(1396), 1,
      anon_sym_COLON,
    ACTIONS(1400), 1,
      anon_sym_,
    ACTIONS(1402), 1,
      sym__newline,
    STATE(164), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [20545] = 7,
    ACTIONS(1213), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1215), 1,
      anon_sym_EQ,
    ACTIONS(1221), 1,
      anon_sym_DOT,
    ACTIONS(1372), 1,
      anon_sym_COLON,
    ACTIONS(1376), 1,
      anon_sym_,
    ACTIONS(1378), 1,
      sym__newline,
    STATE(323), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [20569] = 1,
    ACTIONS(1496), 9,
      anon_sym_html,
      anon_sym_strict,
      anon_sym_xml,
      anon_sym_transitional,
      anon_sym_frameset,
      anon_sym_1_DOT1,
      anon_sym_basic,
      anon_sym_mobile,
      anon_sym_plist,
  [20581] = 8,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1418), 1,
      sym__newline,
    ACTIONS(1498), 1,
      sym__dedent,
    STATE(483), 1,
      aux_sym__content_after_dot_repeat1,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(566), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [20607] = 7,
    ACTIONS(1211), 1,
      anon_sym_COLON,
    ACTIONS(1213), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1215), 1,
      anon_sym_EQ,
    ACTIONS(1219), 1,
      anon_sym_,
    ACTIONS(1221), 1,
      anon_sym_DOT,
    ACTIONS(1223), 1,
      sym__newline,
    STATE(362), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [20631] = 8,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1418), 1,
      sym__newline,
    ACTIONS(1500), 1,
      sym__dedent,
    STATE(483), 1,
      aux_sym__content_after_dot_repeat1,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(566), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [20657] = 8,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1418), 1,
      sym__newline,
    ACTIONS(1502), 1,
      sym__dedent,
    STATE(483), 1,
      aux_sym__content_after_dot_repeat1,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(566), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [20683] = 7,
    ACTIONS(1233), 1,
      anon_sym_COLON,
    ACTIONS(1235), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1237), 1,
      anon_sym_EQ,
    ACTIONS(1241), 1,
      anon_sym_,
    ACTIONS(1243), 1,
      anon_sym_DOT,
    ACTIONS(1245), 1,
      sym__newline,
    STATE(298), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [20707] = 7,
    ACTIONS(1279), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1281), 1,
      anon_sym_EQ,
    ACTIONS(1287), 1,
      anon_sym_DOT,
    ACTIONS(1293), 1,
      anon_sym_COLON,
    ACTIONS(1297), 1,
      anon_sym_,
    ACTIONS(1299), 1,
      sym__newline,
    STATE(173), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [20731] = 8,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1418), 1,
      sym__newline,
    ACTIONS(1504), 1,
      sym__dedent,
    STATE(483), 1,
      aux_sym__content_after_dot_repeat1,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(566), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [20757] = 1,
    ACTIONS(1506), 9,
      anon_sym_html,
      anon_sym_strict,
      anon_sym_xml,
      anon_sym_transitional,
      anon_sym_frameset,
      anon_sym_1_DOT1,
      anon_sym_basic,
      anon_sym_mobile,
      anon_sym_plist,
  [20769] = 7,
    ACTIONS(1167), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1169), 1,
      anon_sym_EQ,
    ACTIONS(1175), 1,
      anon_sym_DOT,
    ACTIONS(1508), 1,
      anon_sym_COLON,
    ACTIONS(1510), 1,
      anon_sym_,
    ACTIONS(1512), 1,
      sym__newline,
    STATE(637), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [20793] = 7,
    ACTIONS(1135), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1137), 1,
      anon_sym_EQ,
    ACTIONS(1143), 1,
      anon_sym_DOT,
    ACTIONS(1225), 1,
      anon_sym_COLON,
    ACTIONS(1229), 1,
      anon_sym_,
    ACTIONS(1231), 1,
      sym__newline,
    STATE(383), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [20817] = 7,
    ACTIONS(1135), 1,
      anon_sym_BANG_EQ,
    ACTIONS(1137), 1,
      anon_sym_EQ,
    ACTIONS(1143), 1,
      anon_sym_DOT,
    ACTIONS(1364), 1,
      anon_sym_COLON,
    ACTIONS(1368), 1,
      anon_sym_,
    ACTIONS(1370), 1,
      sym__newline,
    STATE(382), 3,
      sym_unescaped_buffered_code,
      sym_buffered_code,
      sym__content_after_dot,
  [20841] = 7,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1418), 1,
      sym__newline,
    STATE(481), 1,
      aux_sym__content_after_dot_repeat1,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(566), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [20864] = 7,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1418), 1,
      sym__newline,
    STATE(502), 1,
      aux_sym__content_after_dot_repeat1,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(566), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [20887] = 7,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1418), 1,
      sym__newline,
    STATE(479), 1,
      aux_sym__content_after_dot_repeat1,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(566), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [20910] = 7,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1418), 1,
      sym__newline,
    STATE(477), 1,
      aux_sym__content_after_dot_repeat1,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(566), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [20933] = 7,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1418), 1,
      sym__newline,
    STATE(490), 1,
      aux_sym__content_after_dot_repeat1,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(566), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [20956] = 7,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1418), 1,
      sym__newline,
    STATE(494), 1,
      aux_sym__content_after_dot_repeat1,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(566), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [20979] = 7,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1418), 1,
      sym__newline,
    STATE(473), 1,
      aux_sym__content_after_dot_repeat1,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(566), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21002] = 7,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1418), 1,
      sym__newline,
    STATE(500), 1,
      aux_sym__content_after_dot_repeat1,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(566), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21025] = 7,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1418), 1,
      sym__newline,
    STATE(471), 1,
      aux_sym__content_after_dot_repeat1,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(566), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21048] = 7,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1418), 1,
      sym__newline,
    STATE(475), 1,
      aux_sym__content_after_dot_repeat1,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(566), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21071] = 7,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1418), 1,
      sym__newline,
    STATE(488), 1,
      aux_sym__content_after_dot_repeat1,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(566), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21094] = 7,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1418), 1,
      sym__newline,
    STATE(506), 1,
      aux_sym__content_after_dot_repeat1,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(566), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21117] = 7,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1418), 1,
      sym__newline,
    STATE(480), 1,
      aux_sym__content_after_dot_repeat1,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(566), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21140] = 7,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1418), 1,
      sym__newline,
    STATE(503), 1,
      aux_sym__content_after_dot_repeat1,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(566), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21163] = 8,
    ACTIONS(631), 1,
      aux_sym_include_token1,
    ACTIONS(1514), 1,
      anon_sym_LPAREN,
    ACTIONS(1516), 1,
      anon_sym_COLON,
    ACTIONS(1518), 1,
      aux_sym_filter_content_token1,
    ACTIONS(1520), 1,
      sym__newline,
    STATE(589), 1,
      sym_attributes,
    STATE(916), 1,
      sym_filter_content,
    STATE(995), 1,
      sym_filter,
  [21188] = 3,
    ACTIONS(1522), 1,
      sym__indent,
    STATE(637), 1,
      sym_children,
    ACTIONS(706), 5,
      sym__newline,
      sym__dedent,
      sym_tag_name,
      sym_class,
      sym_id,
  [21202] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1524), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21222] = 4,
    ACTIONS(1528), 1,
      sym__newline,
    ACTIONS(1530), 1,
      sym__dedent,
    STATE(581), 2,
      sym_tag,
      aux_sym__single_line_buf_code_repeat1,
    ACTIONS(1526), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [21238] = 4,
    ACTIONS(1528), 1,
      sym__newline,
    ACTIONS(1532), 1,
      sym__dedent,
    STATE(581), 2,
      sym_tag,
      aux_sym__single_line_buf_code_repeat1,
    ACTIONS(1526), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [21254] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1534), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21274] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1536), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21294] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1538), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21314] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1540), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21334] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1542), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21354] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1544), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21374] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1546), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21394] = 4,
    ACTIONS(1528), 1,
      sym__newline,
    ACTIONS(1548), 1,
      sym__dedent,
    STATE(581), 2,
      sym_tag,
      aux_sym__single_line_buf_code_repeat1,
    ACTIONS(1526), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [21410] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1550), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21430] = 2,
    ACTIONS(744), 2,
      sym__newline,
      anon_sym_,
    ACTIONS(746), 5,
      anon_sym_COLON,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_DOT,
  [21442] = 2,
    ACTIONS(753), 2,
      sym__newline,
      anon_sym_,
    ACTIONS(755), 5,
      anon_sym_COLON,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_DOT,
  [21454] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1552), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21474] = 4,
    ACTIONS(1528), 1,
      sym__newline,
    ACTIONS(1554), 1,
      sym__dedent,
    STATE(581), 2,
      sym_tag,
      aux_sym__single_line_buf_code_repeat1,
    ACTIONS(1526), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [21490] = 3,
    ACTIONS(1556), 1,
      sym__indent,
    STATE(644), 1,
      sym_children,
    ACTIONS(700), 5,
      sym__newline,
      sym__dedent,
      sym_tag_name,
      sym_class,
      sym_id,
  [21504] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1558), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21524] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1560), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21544] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1562), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21564] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1564), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21584] = 3,
    ACTIONS(1522), 1,
      sym__indent,
    STATE(644), 1,
      sym_children,
    ACTIONS(700), 5,
      sym__newline,
      sym__dedent,
      sym_tag_name,
      sym_class,
      sym_id,
  [21598] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1566), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21618] = 4,
    ACTIONS(1528), 1,
      sym__newline,
    ACTIONS(1568), 1,
      sym__dedent,
    STATE(581), 2,
      sym_tag,
      aux_sym__single_line_buf_code_repeat1,
    ACTIONS(1526), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [21634] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1570), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21654] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1572), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21674] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1574), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21694] = 2,
    ACTIONS(785), 2,
      sym__newline,
      anon_sym_,
    ACTIONS(787), 5,
      anon_sym_COLON,
      anon_sym_BANG_EQ,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_DOT,
  [21706] = 3,
    ACTIONS(1576), 1,
      sym__indent,
    STATE(637), 1,
      sym_children,
    ACTIONS(706), 5,
      sym__newline,
      sym__dedent,
      sym_tag_name,
      sym_class,
      sym_id,
  [21720] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1578), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21740] = 6,
    ACTIONS(1580), 1,
      aux_sym_content_token1,
    ACTIONS(1583), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1586), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1589), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21760] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1591), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(564), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21780] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1593), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21800] = 1,
    ACTIONS(1595), 7,
      aux_sym__ternary_attribute_value_token1,
      aux_sym__variable_attribute_value_token1,
      aux_sym__object_attribute_value_token1,
      aux_sym__template_attribute_value_token1,
      aux_sym__array_attribute_value_token1,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
  [21810] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1597), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21830] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1599), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(567), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21850] = 4,
    ACTIONS(1528), 1,
      sym__newline,
    ACTIONS(1601), 1,
      sym__dedent,
    STATE(581), 2,
      sym_tag,
      aux_sym__single_line_buf_code_repeat1,
    ACTIONS(1526), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [21866] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1603), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21886] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1605), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21906] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1607), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21926] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1609), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21946] = 4,
    ACTIONS(1528), 1,
      sym__newline,
    ACTIONS(1611), 1,
      sym__dedent,
    STATE(581), 2,
      sym_tag,
      aux_sym__single_line_buf_code_repeat1,
    ACTIONS(1526), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [21962] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1613), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [21982] = 3,
    ACTIONS(1522), 1,
      sym__indent,
    STATE(652), 1,
      sym_children,
    ACTIONS(684), 5,
      sym__newline,
      sym__dedent,
      sym_tag_name,
      sym_class,
      sym_id,
  [21996] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1615), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(565), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22016] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1617), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22036] = 3,
    ACTIONS(1619), 1,
      sym__indent,
    STATE(632), 1,
      sym_children,
    ACTIONS(726), 5,
      sym__newline,
      sym__dedent,
      sym_tag_name,
      sym_class,
      sym_id,
  [22050] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1621), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(546), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22070] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1623), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(572), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22090] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1625), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22110] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1627), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22130] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1629), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22150] = 3,
    ACTIONS(1522), 1,
      sym__indent,
    STATE(648), 1,
      sym_children,
    ACTIONS(696), 5,
      sym__newline,
      sym__dedent,
      sym_tag_name,
      sym_class,
      sym_id,
  [22164] = 4,
    ACTIONS(1528), 1,
      sym__newline,
    ACTIONS(1631), 1,
      sym__dedent,
    STATE(581), 2,
      sym_tag,
      aux_sym__single_line_buf_code_repeat1,
    ACTIONS(1526), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [22180] = 4,
    ACTIONS(1636), 1,
      sym__newline,
    ACTIONS(1639), 1,
      sym__dedent,
    STATE(581), 2,
      sym_tag,
      aux_sym__single_line_buf_code_repeat1,
    ACTIONS(1633), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [22196] = 3,
    ACTIONS(1641), 1,
      sym__indent,
    STATE(649), 1,
      sym_children,
    ACTIONS(732), 5,
      sym__newline,
      sym__dedent,
      sym_tag_name,
      sym_class,
      sym_id,
  [22210] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1643), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22230] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1645), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22250] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1647), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22270] = 6,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1649), 1,
      sym__newline,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(557), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22290] = 5,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(544), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22307] = 5,
    ACTIONS(1653), 1,
      anon_sym_EQ,
    ACTIONS(1655), 1,
      anon_sym_,
    ACTIONS(1657), 1,
      anon_sym_DOT,
    STATE(629), 1,
      aux_sym__attribute_repeat1,
    ACTIONS(1651), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [22324] = 6,
    ACTIONS(669), 1,
      aux_sym_include_token1,
    ACTIONS(1516), 1,
      anon_sym_COLON,
    ACTIONS(1518), 1,
      aux_sym_filter_content_token1,
    ACTIONS(1520), 1,
      sym__newline,
    STATE(995), 1,
      sym_filter,
    STATE(996), 1,
      sym_filter_content,
  [22343] = 5,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(584), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22360] = 5,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(583), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22377] = 3,
    ACTIONS(1659), 1,
      sym__newline,
    STATE(580), 2,
      sym_tag,
      aux_sym__single_line_buf_code_repeat1,
    ACTIONS(1526), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [22390] = 5,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(536), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22407] = 5,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(538), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22424] = 5,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(577), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22441] = 3,
    ACTIONS(1661), 1,
      sym__newline,
    STATE(528), 2,
      sym_tag,
      aux_sym__single_line_buf_code_repeat1,
    ACTIONS(1526), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [22454] = 5,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(585), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22471] = 5,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(551), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22488] = 5,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(569), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22505] = 5,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(533), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22522] = 5,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(559), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22539] = 3,
    ACTIONS(1663), 1,
      sym__newline,
    STATE(568), 2,
      sym_tag,
      aux_sym__single_line_buf_code_repeat1,
    ACTIONS(1526), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [22552] = 5,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(531), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22569] = 5,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(576), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22586] = 5,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(561), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22603] = 5,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(527), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22620] = 5,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(578), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22637] = 5,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(549), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22654] = 3,
    ACTIONS(1665), 1,
      sym__newline,
    STATE(529), 2,
      sym_tag,
      aux_sym__single_line_buf_code_repeat1,
    ACTIONS(1526), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [22667] = 5,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(547), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22684] = 5,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(534), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22701] = 3,
    ACTIONS(1667), 1,
      sym__newline,
    STATE(542), 2,
      sym_tag,
      aux_sym__single_line_buf_code_repeat1,
    ACTIONS(1526), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [22714] = 5,
    ACTIONS(1657), 1,
      anon_sym_DOT,
    ACTIONS(1671), 1,
      anon_sym_EQ,
    ACTIONS(1673), 1,
      anon_sym_,
    STATE(588), 1,
      aux_sym__attribute_repeat1,
    ACTIONS(1669), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [22731] = 5,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(532), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22748] = 5,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(530), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22765] = 1,
    ACTIONS(1348), 6,
      anon_sym_RPAREN,
      aux_sym_angular_attribute_name_token1,
      aux_sym_angular_attribute_name_token2,
      aux_sym_angular_attribute_name_token3,
      aux_sym_angular_attribute_name_token4,
      sym_attribute_name,
  [22774] = 3,
    ACTIONS(1675), 1,
      sym__newline,
    STATE(563), 2,
      sym_tag,
      aux_sym__single_line_buf_code_repeat1,
    ACTIONS(1526), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [22787] = 5,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(586), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22804] = 5,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(552), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22821] = 5,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(556), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22838] = 5,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(545), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22855] = 2,
    ACTIONS(1677), 1,
      sym__indent,
    ACTIONS(759), 5,
      sym__newline,
      sym__dedent,
      sym_tag_name,
      sym_class,
      sym_id,
  [22866] = 5,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(535), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22883] = 3,
    ACTIONS(1679), 1,
      sym__newline,
    STATE(537), 2,
      sym_tag,
      aux_sym__single_line_buf_code_repeat1,
    ACTIONS(1526), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [22896] = 4,
    ACTIONS(1683), 1,
      anon_sym_POUND,
    ACTIONS(1685), 1,
      anon_sym_LBRACE,
    ACTIONS(1681), 2,
      sym__newline,
      aux_sym_content_token1,
    ACTIONS(1687), 2,
      anon_sym_POUND_LBRACE,
      anon_sym_LBRACE_LBRACE,
  [22911] = 5,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(553), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22928] = 5,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1414), 1,
      anon_sym_POUND_LBRACE,
    ACTIONS(1416), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(647), 1,
      aux_sym_content_repeat1,
    STATE(541), 2,
      sym_content,
      aux_sym__content_or_javascript,
  [22945] = 3,
    ACTIONS(1689), 1,
      sym__newline,
    STATE(550), 2,
      sym_tag,
      aux_sym__single_line_buf_code_repeat1,
    ACTIONS(1526), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [22958] = 4,
    ACTIONS(1693), 1,
      anon_sym_,
    ACTIONS(1695), 1,
      anon_sym_DOT,
    STATE(629), 1,
      aux_sym__attribute_repeat1,
    ACTIONS(1691), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_EQ,
  [22973] = 4,
    ACTIONS(1698), 1,
      anon_sym_when,
    ACTIONS(1700), 1,
      anon_sym_default,
    STATE(751), 1,
      sym__when_keyword,
    STATE(80), 2,
      sym_when,
      aux_sym_case_repeat1,
  [22987] = 2,
    ACTIONS(1702), 2,
      anon_sym_POUND_LBRACE,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1460), 3,
      sym__newline,
      sym__dedent,
      aux_sym_content_token1,
  [22997] = 1,
    ACTIONS(706), 5,
      sym__newline,
      sym__dedent,
      sym_tag_name,
      sym_class,
      sym_id,
  [23005] = 2,
    ACTIONS(1693), 1,
      anon_sym_,
    ACTIONS(1691), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_DOT,
  [23015] = 1,
    ACTIONS(835), 5,
      sym__newline,
      sym__dedent,
      sym_tag_name,
      sym_class,
      sym_id,
  [23023] = 3,
    STATE(308), 1,
      sym__dummy_tag,
    STATE(309), 1,
      sym_tag,
    ACTIONS(477), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [23035] = 3,
    STATE(176), 1,
      sym__dummy_tag,
    STATE(178), 1,
      sym_tag,
    ACTIONS(1704), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [23047] = 1,
    ACTIONS(700), 5,
      sym__newline,
      sym__dedent,
      sym_tag_name,
      sym_class,
      sym_id,
  [23055] = 1,
    ACTIONS(819), 5,
      sym__newline,
      sym__dedent,
      sym_tag_name,
      sym_class,
      sym_id,
  [23063] = 1,
    ACTIONS(829), 5,
      sym__newline,
      sym__dedent,
      sym_tag_name,
      sym_class,
      sym_id,
  [23071] = 3,
    ACTIONS(1708), 1,
      anon_sym_LBRACE,
    ACTIONS(1706), 2,
      sym__newline,
      aux_sym_content_token1,
    ACTIONS(1710), 2,
      anon_sym_POUND_LBRACE,
      anon_sym_LBRACE_LBRACE,
  [23083] = 4,
    ACTIONS(1706), 1,
      sym__newline,
    ACTIONS(1712), 1,
      aux_sym_content_token1,
    STATE(641), 1,
      aux_sym_content_repeat1,
    ACTIONS(1710), 2,
      anon_sym_POUND_LBRACE,
      anon_sym_LBRACE_LBRACE,
  [23097] = 4,
    ACTIONS(1698), 1,
      anon_sym_when,
    ACTIONS(1715), 1,
      anon_sym_default,
    STATE(773), 1,
      sym__when_keyword,
    STATE(53), 2,
      sym_when,
      aux_sym_case_repeat1,
  [23111] = 1,
    ACTIONS(793), 5,
      sym__newline,
      sym__dedent,
      sym_tag_name,
      sym_class,
      sym_id,
  [23119] = 1,
    ACTIONS(684), 5,
      sym__newline,
      sym__dedent,
      sym_tag_name,
      sym_class,
      sym_id,
  [23127] = 2,
    ACTIONS(1719), 2,
      anon_sym_POUND_LBRACE,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1717), 3,
      sym__newline,
      sym__dedent,
      aux_sym_content_token1,
  [23137] = 3,
    STATE(116), 1,
      sym__dummy_tag,
    STATE(120), 1,
      sym_tag,
    ACTIONS(97), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [23149] = 4,
    ACTIONS(1412), 1,
      aux_sym_content_token1,
    ACTIONS(1723), 1,
      sym__newline,
    STATE(641), 1,
      aux_sym_content_repeat1,
    ACTIONS(1721), 2,
      anon_sym_POUND_LBRACE,
      anon_sym_LBRACE_LBRACE,
  [23163] = 1,
    ACTIONS(789), 5,
      sym__newline,
      sym__dedent,
      sym_tag_name,
      sym_class,
      sym_id,
  [23171] = 1,
    ACTIONS(726), 5,
      sym__newline,
      sym__dedent,
      sym_tag_name,
      sym_class,
      sym_id,
  [23179] = 1,
    ACTIONS(825), 5,
      sym__newline,
      sym__dedent,
      sym_tag_name,
      sym_class,
      sym_id,
  [23187] = 1,
    ACTIONS(839), 5,
      sym__newline,
      sym__dedent,
      sym_tag_name,
      sym_class,
      sym_id,
  [23195] = 1,
    ACTIONS(696), 5,
      sym__newline,
      sym__dedent,
      sym_tag_name,
      sym_class,
      sym_id,
  [23203] = 1,
    ACTIONS(732), 5,
      sym__newline,
      sym__dedent,
      sym_tag_name,
      sym_class,
      sym_id,
  [23211] = 4,
    ACTIONS(1698), 1,
      anon_sym_when,
    ACTIONS(1725), 1,
      anon_sym_default,
    STATE(729), 1,
      sym__when_keyword,
    STATE(102), 2,
      sym_when,
      aux_sym_case_repeat1,
  [23225] = 2,
    STATE(323), 1,
      sym_tag,
    ACTIONS(49), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [23234] = 2,
    STATE(191), 1,
      sym_tag,
    ACTIONS(218), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [23243] = 4,
    ACTIONS(1727), 1,
      aux_sym_filter_content_token2,
    ACTIONS(1729), 1,
      sym__dedent,
    STATE(703), 1,
      aux_sym__comment_repeat1,
    STATE(907), 1,
      sym__comment_content,
  [23256] = 2,
    STATE(156), 1,
      sym_tag,
    ACTIONS(1704), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [23265] = 2,
    STATE(153), 1,
      sym_tag,
    ACTIONS(1704), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [23274] = 4,
    ACTIONS(1727), 1,
      aux_sym_filter_content_token2,
    ACTIONS(1731), 1,
      sym__dedent,
    STATE(703), 1,
      aux_sym__comment_repeat1,
    STATE(907), 1,
      sym__comment_content,
  [23287] = 4,
    ACTIONS(1733), 1,
      aux_sym_include_token1,
    ACTIONS(1735), 1,
      sym__newline,
    ACTIONS(1737), 1,
      sym__dedent,
    STATE(704), 1,
      aux_sym_script_block_repeat1,
  [23300] = 4,
    ACTIONS(1739), 1,
      anon_sym_append,
    ACTIONS(1741), 1,
      anon_sym_prepend,
    ACTIONS(1743), 1,
      sym_tag_name,
    STATE(353), 1,
      sym__block_content,
  [23313] = 4,
    ACTIONS(1733), 1,
      aux_sym_include_token1,
    ACTIONS(1735), 1,
      sym__newline,
    ACTIONS(1745), 1,
      sym__dedent,
    STATE(704), 1,
      aux_sym_script_block_repeat1,
  [23326] = 2,
    STATE(199), 1,
      sym_tag,
    ACTIONS(218), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [23335] = 4,
    ACTIONS(1727), 1,
      aux_sym_filter_content_token2,
    ACTIONS(1747), 1,
      sym__dedent,
    STATE(703), 1,
      aux_sym__comment_repeat1,
    STATE(907), 1,
      sym__comment_content,
  [23348] = 4,
    ACTIONS(1749), 1,
      anon_sym_append,
    ACTIONS(1751), 1,
      anon_sym_prepend,
    ACTIONS(1753), 1,
      sym_tag_name,
    STATE(279), 1,
      sym__block_content,
  [23361] = 4,
    ACTIONS(1755), 1,
      sym__un_delimited_javascript_line,
    ACTIONS(1757), 1,
      sym__newline,
    STATE(267), 1,
      sym__single_line_buf_code,
    STATE(911), 1,
      sym__un_delimited_javascript,
  [23374] = 2,
    STATE(215), 1,
      sym_tag,
    ACTIONS(218), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [23383] = 2,
    STATE(232), 1,
      sym_tag,
    ACTIONS(218), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [23392] = 2,
    STATE(114), 1,
      sym_tag,
    ACTIONS(97), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [23401] = 2,
    STATE(105), 1,
      sym_tag,
    ACTIONS(97), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [23410] = 4,
    ACTIONS(1727), 1,
      aux_sym_filter_content_token2,
    ACTIONS(1759), 1,
      sym__dedent,
    STATE(703), 1,
      aux_sym__comment_repeat1,
    STATE(907), 1,
      sym__comment_content,
  [23423] = 4,
    ACTIONS(1727), 1,
      aux_sym_filter_content_token2,
    ACTIONS(1761), 1,
      sym__dedent,
    STATE(703), 1,
      aux_sym__comment_repeat1,
    STATE(907), 1,
      sym__comment_content,
  [23436] = 4,
    ACTIONS(1755), 1,
      sym__un_delimited_javascript_line,
    ACTIONS(1763), 1,
      sym__newline,
    STATE(209), 1,
      sym__single_line_buf_code,
    STATE(988), 1,
      sym__un_delimited_javascript,
  [23449] = 2,
    STATE(164), 1,
      sym_tag,
    ACTIONS(1704), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [23458] = 4,
    ACTIONS(1733), 1,
      aux_sym_include_token1,
    ACTIONS(1735), 1,
      sym__newline,
    ACTIONS(1765), 1,
      sym__dedent,
    STATE(704), 1,
      aux_sym_script_block_repeat1,
  [23471] = 4,
    ACTIONS(1727), 1,
      aux_sym_filter_content_token2,
    ACTIONS(1767), 1,
      sym__dedent,
    STATE(703), 1,
      aux_sym__comment_repeat1,
    STATE(907), 1,
      sym__comment_content,
  [23484] = 4,
    ACTIONS(1755), 1,
      sym__un_delimited_javascript_line,
    ACTIONS(1769), 1,
      sym__newline,
    STATE(389), 1,
      sym__single_line_buf_code,
    STATE(898), 1,
      sym__un_delimited_javascript,
  [23497] = 2,
    STATE(121), 1,
      sym_tag,
    ACTIONS(97), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [23506] = 4,
    ACTIONS(1771), 1,
      anon_sym_append,
    ACTIONS(1773), 1,
      anon_sym_prepend,
    ACTIONS(1775), 1,
      sym_tag_name,
    STATE(237), 1,
      sym__block_content,
  [23519] = 2,
    STATE(127), 1,
      sym_tag,
    ACTIONS(97), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [23528] = 2,
    STATE(173), 1,
      sym_tag,
    ACTIONS(1704), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [23537] = 2,
    STATE(371), 1,
      sym_tag,
    ACTIONS(49), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [23546] = 2,
    STATE(362), 1,
      sym_tag,
    ACTIONS(49), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [23555] = 2,
    ACTIONS(744), 1,
      sym__newline,
    ACTIONS(746), 3,
      aux_sym_include_token1,
      anon_sym_COLON,
      aux_sym_filter_content_token1,
  [23564] = 4,
    ACTIONS(1777), 1,
      anon_sym_append,
    ACTIONS(1779), 1,
      anon_sym_prepend,
    ACTIONS(1781), 1,
      sym_tag_name,
    STATE(130), 1,
      sym__block_content,
  [23577] = 2,
    STATE(348), 1,
      sym_tag,
    ACTIONS(49), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [23586] = 4,
    ACTIONS(1755), 1,
      sym__un_delimited_javascript_line,
    ACTIONS(1783), 1,
      sym__newline,
    STATE(268), 1,
      sym__single_line_buf_code,
    STATE(1061), 1,
      sym__un_delimited_javascript,
  [23599] = 4,
    ACTIONS(1785), 1,
      anon_sym_append,
    ACTIONS(1787), 1,
      anon_sym_prepend,
    ACTIONS(1789), 1,
      sym_tag_name,
    STATE(415), 1,
      sym__block_content,
  [23612] = 2,
    ACTIONS(1706), 2,
      sym__newline,
      aux_sym_content_token1,
    ACTIONS(1710), 2,
      anon_sym_POUND_LBRACE,
      anon_sym_LBRACE_LBRACE,
  [23621] = 2,
    STATE(383), 1,
      sym_tag,
    ACTIONS(527), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [23630] = 2,
    ACTIONS(753), 1,
      sym__newline,
    ACTIONS(755), 3,
      aux_sym_include_token1,
      anon_sym_COLON,
      aux_sym_filter_content_token1,
  [23639] = 2,
    STATE(382), 1,
      sym_tag,
    ACTIONS(527), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [23648] = 2,
    ACTIONS(785), 1,
      sym__newline,
    ACTIONS(787), 3,
      aux_sym_include_token1,
      anon_sym_COLON,
      aux_sym_filter_content_token1,
  [23657] = 2,
    STATE(379), 1,
      sym_tag,
    ACTIONS(527), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [23666] = 2,
    ACTIONS(1793), 1,
      anon_sym_,
    ACTIONS(1791), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_EQ,
  [23675] = 2,
    STATE(644), 1,
      sym_tag,
    ACTIONS(1526), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [23684] = 2,
    STATE(406), 1,
      sym_tag,
    ACTIONS(527), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [23693] = 4,
    ACTIONS(1727), 1,
      aux_sym_filter_content_token2,
    ACTIONS(1795), 1,
      sym__dedent,
    STATE(703), 1,
      aux_sym__comment_repeat1,
    STATE(907), 1,
      sym__comment_content,
  [23706] = 4,
    ACTIONS(1727), 1,
      aux_sym_filter_content_token2,
    ACTIONS(1797), 1,
      sym__dedent,
    STATE(703), 1,
      aux_sym__comment_repeat1,
    STATE(907), 1,
      sym__comment_content,
  [23719] = 3,
    ACTIONS(1801), 1,
      anon_sym_EQ,
    ACTIONS(1803), 1,
      anon_sym_,
    ACTIONS(1799), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [23730] = 2,
    STATE(649), 1,
      sym_tag,
    ACTIONS(1526), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [23739] = 4,
    ACTIONS(1805), 1,
      aux_sym_filter_content_token2,
    ACTIONS(1808), 1,
      sym__dedent,
    STATE(703), 1,
      aux_sym__comment_repeat1,
    STATE(907), 1,
      sym__comment_content,
  [23752] = 4,
    ACTIONS(1810), 1,
      aux_sym_include_token1,
    ACTIONS(1813), 1,
      sym__newline,
    ACTIONS(1816), 1,
      sym__dedent,
    STATE(704), 1,
      aux_sym_script_block_repeat1,
  [23765] = 2,
    ACTIONS(1818), 2,
      sym__newline,
      aux_sym_content_token1,
    ACTIONS(1820), 2,
      anon_sym_POUND_LBRACE,
      anon_sym_LBRACE_LBRACE,
  [23774] = 4,
    ACTIONS(1755), 1,
      sym__un_delimited_javascript_line,
    ACTIONS(1822), 1,
      sym__newline,
    STATE(144), 1,
      sym__single_line_buf_code,
    STATE(1029), 1,
      sym__un_delimited_javascript,
  [23787] = 2,
    ACTIONS(1824), 2,
      sym__newline,
      aux_sym_content_token1,
    ACTIONS(1826), 2,
      anon_sym_POUND_LBRACE,
      anon_sym_LBRACE_LBRACE,
  [23796] = 2,
    STATE(632), 1,
      sym_tag,
    ACTIONS(1526), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [23805] = 2,
    STATE(298), 1,
      sym_tag,
    ACTIONS(477), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [23814] = 2,
    STATE(296), 1,
      sym_tag,
    ACTIONS(477), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [23823] = 2,
    STATE(275), 1,
      sym_tag,
    ACTIONS(477), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [23832] = 4,
    ACTIONS(1733), 1,
      aux_sym_include_token1,
    ACTIONS(1735), 1,
      sym__newline,
    ACTIONS(1828), 1,
      sym__dedent,
    STATE(704), 1,
      aux_sym_script_block_repeat1,
  [23845] = 4,
    ACTIONS(1733), 1,
      aux_sym_include_token1,
    ACTIONS(1735), 1,
      sym__newline,
    ACTIONS(1830), 1,
      sym__dedent,
    STATE(704), 1,
      aux_sym_script_block_repeat1,
  [23858] = 4,
    ACTIONS(1727), 1,
      aux_sym_filter_content_token2,
    ACTIONS(1832), 1,
      sym__dedent,
    STATE(703), 1,
      aux_sym__comment_repeat1,
    STATE(907), 1,
      sym__comment_content,
  [23871] = 4,
    ACTIONS(1727), 1,
      aux_sym_filter_content_token2,
    ACTIONS(1834), 1,
      sym__dedent,
    STATE(703), 1,
      aux_sym__comment_repeat1,
    STATE(907), 1,
      sym__comment_content,
  [23884] = 2,
    STATE(637), 1,
      sym_tag,
    ACTIONS(1526), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [23893] = 2,
    STATE(266), 1,
      sym_tag,
    ACTIONS(477), 3,
      sym_tag_name,
      sym_class,
      sym_id,
  [23902] = 3,
    ACTIONS(1755), 1,
      sym__un_delimited_javascript_line,
    STATE(650), 1,
      sym__single_line_buf_code,
    STATE(937), 1,
      sym__un_delimited_javascript,
  [23912] = 3,
    ACTIONS(1836), 1,
      anon_sym_COMMA,
    ACTIONS(1838), 1,
      anon_sym_RPAREN,
    ACTIONS(1840), 1,
      anon_sym_,
  [23922] = 3,
    ACTIONS(1842), 1,
      aux_sym__each_js_token1,
    STATE(836), 1,
      sym__each_js,
    STATE(1051), 1,
      sym_iteration_variable,
  [23932] = 3,
    ACTIONS(1842), 1,
      aux_sym__each_js_token1,
    STATE(836), 1,
      sym__each_js,
    STATE(1047), 1,
      sym_iteration_variable,
  [23942] = 3,
    ACTIONS(1836), 1,
      anon_sym_COMMA,
    ACTIONS(1840), 1,
      anon_sym_,
    ACTIONS(1844), 1,
      anon_sym_RPAREN,
  [23952] = 3,
    ACTIONS(1842), 1,
      aux_sym__each_js_token1,
    STATE(836), 1,
      sym__each_js,
    STATE(1043), 1,
      sym_iteration_variable,
  [23962] = 3,
    ACTIONS(1842), 1,
      aux_sym__each_js_token1,
    STATE(836), 1,
      sym__each_js,
    STATE(1038), 1,
      sym_iteration_variable,
  [23972] = 2,
    ACTIONS(1848), 1,
      anon_sym_,
    ACTIONS(1846), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [23980] = 3,
    ACTIONS(1850), 1,
      sym__un_delimited_javascript_line,
    STATE(62), 1,
      aux_sym__un_delimited_javascript_multiline,
    STATE(118), 1,
      sym__multi_line_buf_code,
  [23990] = 2,
    ACTIONS(1854), 1,
      anon_sym_,
    ACTIONS(1852), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [23998] = 3,
    ACTIONS(1856), 1,
      aux_sym_filter_content_token2,
    ACTIONS(1858), 1,
      sym__dedent,
    STATE(734), 1,
      aux_sym_filter_content_repeat1,
  [24008] = 3,
    ACTIONS(1860), 1,
      anon_sym_COLON,
    ACTIONS(1862), 1,
      sym__newline,
    STATE(303), 1,
      sym__when_content,
  [24018] = 3,
    ACTIONS(1856), 1,
      aux_sym_filter_content_token2,
    ACTIONS(1864), 1,
      sym__dedent,
    STATE(728), 1,
      aux_sym_filter_content_repeat1,
  [24028] = 2,
    ACTIONS(1868), 1,
      anon_sym_,
    ACTIONS(1866), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [24036] = 2,
    ACTIONS(1872), 1,
      anon_sym_,
    ACTIONS(1870), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [24044] = 2,
    ACTIONS(1876), 1,
      anon_sym_,
    ACTIONS(1874), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [24052] = 3,
    ACTIONS(1878), 1,
      aux_sym_filter_content_token2,
    ACTIONS(1881), 1,
      sym__dedent,
    STATE(734), 1,
      aux_sym_filter_content_repeat1,
  [24062] = 3,
    ACTIONS(1727), 1,
      aux_sym_filter_content_token2,
    STATE(673), 1,
      aux_sym__comment_repeat1,
    STATE(907), 1,
      sym__comment_content,
  [24072] = 3,
    ACTIONS(1727), 1,
      aux_sym_filter_content_token2,
    STATE(657), 1,
      aux_sym__comment_repeat1,
    STATE(907), 1,
      sym__comment_content,
  [24082] = 3,
    ACTIONS(1733), 1,
      aux_sym_include_token1,
    ACTIONS(1735), 1,
      sym__newline,
    STATE(663), 1,
      aux_sym_script_block_repeat1,
  [24092] = 3,
    ACTIONS(1883), 1,
      aux_sym_filter_content_token2,
    ACTIONS(1885), 1,
      sym__newline,
    STATE(1026), 1,
      sym__comment_content,
  [24102] = 3,
    ACTIONS(1755), 1,
      sym__un_delimited_javascript_line,
    STATE(651), 1,
      sym__single_line_buf_code,
    STATE(937), 1,
      sym__un_delimited_javascript,
  [24112] = 2,
    ACTIONS(1889), 1,
      anon_sym_,
    ACTIONS(1887), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [24120] = 3,
    ACTIONS(1516), 1,
      anon_sym_COLON,
    ACTIONS(1891), 1,
      aux_sym_include_token1,
    STATE(946), 1,
      sym_filter,
  [24130] = 2,
    ACTIONS(1895), 1,
      anon_sym_,
    ACTIONS(1893), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [24138] = 3,
    ACTIONS(1727), 1,
      aux_sym_filter_content_token2,
    STATE(672), 1,
      aux_sym__comment_repeat1,
    STATE(907), 1,
      sym__comment_content,
  [24148] = 2,
    ACTIONS(1899), 1,
      anon_sym_,
    ACTIONS(1897), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [24156] = 3,
    ACTIONS(1727), 1,
      aux_sym_filter_content_token2,
    STATE(660), 1,
      aux_sym__comment_repeat1,
    STATE(907), 1,
      sym__comment_content,
  [24166] = 3,
    ACTIONS(1733), 1,
      aux_sym_include_token1,
    ACTIONS(1735), 1,
      sym__newline,
    STATE(661), 1,
      aux_sym_script_block_repeat1,
  [24176] = 3,
    ACTIONS(1755), 1,
      sym__un_delimited_javascript_line,
    STATE(103), 1,
      sym__single_line_buf_code,
    STATE(1029), 1,
      sym__un_delimited_javascript,
  [24186] = 3,
    ACTIONS(1755), 1,
      sym__un_delimited_javascript_line,
    STATE(108), 1,
      sym__single_line_buf_code,
    STATE(1029), 1,
      sym__un_delimited_javascript,
  [24196] = 3,
    ACTIONS(1901), 1,
      aux_sym_filter_content_token2,
    ACTIONS(1903), 1,
      sym__newline,
    STATE(982), 1,
      sym__comment_content,
  [24206] = 1,
    ACTIONS(1816), 3,
      sym__newline,
      sym__dedent,
      aux_sym_include_token1,
  [24212] = 3,
    ACTIONS(1905), 1,
      anon_sym_COLON,
    ACTIONS(1907), 1,
      sym__newline,
    STATE(170), 1,
      sym__when_content,
  [24222] = 3,
    ACTIONS(1856), 1,
      aux_sym_filter_content_token2,
    ACTIONS(1909), 1,
      sym__dedent,
    STATE(734), 1,
      aux_sym_filter_content_repeat1,
  [24232] = 3,
    ACTIONS(1727), 1,
      aux_sym_filter_content_token2,
    STATE(700), 1,
      aux_sym__comment_repeat1,
    STATE(907), 1,
      sym__comment_content,
  [24242] = 3,
    ACTIONS(1727), 1,
      aux_sym_filter_content_token2,
    STATE(714), 1,
      aux_sym__comment_repeat1,
    STATE(907), 1,
      sym__comment_content,
  [24252] = 3,
    ACTIONS(1733), 1,
      aux_sym_include_token1,
    ACTIONS(1735), 1,
      sym__newline,
    STATE(713), 1,
      aux_sym_script_block_repeat1,
  [24262] = 3,
    ACTIONS(1911), 1,
      aux_sym_filter_content_token2,
    ACTIONS(1913), 1,
      sym__newline,
    STATE(993), 1,
      sym__comment_content,
  [24272] = 3,
    ACTIONS(1516), 1,
      anon_sym_COLON,
    ACTIONS(1915), 1,
      aux_sym_include_token1,
    STATE(1015), 1,
      sym_filter,
  [24282] = 3,
    ACTIONS(1516), 1,
      anon_sym_COLON,
    ACTIONS(1917), 1,
      aux_sym_include_token1,
    STATE(975), 1,
      sym_filter,
  [24292] = 3,
    ACTIONS(1727), 1,
      aux_sym_filter_content_token2,
    STATE(665), 1,
      aux_sym__comment_repeat1,
    STATE(907), 1,
      sym__comment_content,
  [24302] = 3,
    ACTIONS(1755), 1,
      sym__un_delimited_javascript_line,
    STATE(358), 1,
      sym__single_line_buf_code,
    STATE(994), 1,
      sym__un_delimited_javascript,
  [24312] = 3,
    ACTIONS(1755), 1,
      sym__un_delimited_javascript_line,
    STATE(360), 1,
      sym__single_line_buf_code,
    STATE(994), 1,
      sym__un_delimited_javascript,
  [24322] = 3,
    ACTIONS(1727), 1,
      aux_sym_filter_content_token2,
    STATE(677), 1,
      aux_sym__comment_repeat1,
    STATE(907), 1,
      sym__comment_content,
  [24332] = 3,
    ACTIONS(1733), 1,
      aux_sym_include_token1,
    ACTIONS(1735), 1,
      sym__newline,
    STATE(676), 1,
      aux_sym_script_block_repeat1,
  [24342] = 3,
    ACTIONS(1842), 1,
      aux_sym__each_js_token1,
    STATE(836), 1,
      sym__each_js,
    STATE(1007), 1,
      sym_iteration_variable,
  [24352] = 3,
    ACTIONS(1919), 1,
      aux_sym_filter_content_token2,
    ACTIONS(1921), 1,
      sym__newline,
    STATE(938), 1,
      sym__comment_content,
  [24362] = 3,
    ACTIONS(1836), 1,
      anon_sym_COMMA,
    ACTIONS(1840), 1,
      anon_sym_,
    ACTIONS(1923), 1,
      anon_sym_RPAREN,
  [24372] = 3,
    ACTIONS(1925), 1,
      anon_sym_SQUOTE,
    ACTIONS(1927), 1,
      anon_sym_DQUOTE,
    STATE(742), 1,
      sym_quoted_javascript,
  [24382] = 3,
    ACTIONS(1836), 1,
      anon_sym_COMMA,
    ACTIONS(1840), 1,
      anon_sym_,
    ACTIONS(1929), 1,
      anon_sym_RPAREN,
  [24392] = 3,
    ACTIONS(1931), 1,
      aux_sym_filter_content_token2,
    ACTIONS(1933), 1,
      sym__newline,
    STATE(955), 1,
      sym__comment_content,
  [24402] = 3,
    ACTIONS(1727), 1,
      aux_sym_filter_content_token2,
    STATE(699), 1,
      aux_sym__comment_repeat1,
    STATE(907), 1,
      sym__comment_content,
  [24412] = 1,
    ACTIONS(1935), 3,
      sym__newline,
      sym__dedent,
      aux_sym_include_token1,
  [24418] = 3,
    ACTIONS(1856), 1,
      aux_sym_filter_content_token2,
    ACTIONS(1937), 1,
      sym__dedent,
    STATE(752), 1,
      aux_sym_filter_content_repeat1,
  [24428] = 3,
    ACTIONS(1939), 1,
      anon_sym_COLON,
    ACTIONS(1941), 1,
      sym__newline,
    STATE(89), 1,
      sym__when_content,
  [24438] = 3,
    ACTIONS(1856), 1,
      aux_sym_filter_content_token2,
    ACTIONS(1943), 1,
      sym__dedent,
    STATE(783), 1,
      aux_sym_filter_content_repeat1,
  [24448] = 3,
    ACTIONS(1856), 1,
      aux_sym_filter_content_token2,
    ACTIONS(1945), 1,
      sym__dedent,
    STATE(734), 1,
      aux_sym_filter_content_repeat1,
  [24458] = 3,
    ACTIONS(1836), 1,
      anon_sym_COMMA,
    ACTIONS(1840), 1,
      anon_sym_,
    ACTIONS(1947), 1,
      anon_sym_RPAREN,
  [24468] = 3,
    ACTIONS(1836), 1,
      anon_sym_COMMA,
    ACTIONS(1840), 1,
      anon_sym_,
    ACTIONS(1949), 1,
      anon_sym_RPAREN,
  [24478] = 3,
    ACTIONS(1836), 1,
      anon_sym_COMMA,
    ACTIONS(1840), 1,
      anon_sym_,
    ACTIONS(1951), 1,
      anon_sym_RPAREN,
  [24488] = 3,
    ACTIONS(1836), 1,
      anon_sym_COMMA,
    ACTIONS(1840), 1,
      anon_sym_,
    ACTIONS(1953), 1,
      anon_sym_RPAREN,
  [24498] = 3,
    ACTIONS(1955), 1,
      sym__un_delimited_javascript_line,
    STATE(91), 1,
      aux_sym__un_delimited_javascript_multiline,
    STATE(190), 1,
      sym__multi_line_buf_code,
  [24508] = 3,
    ACTIONS(1957), 1,
      sym__un_delimited_javascript_line,
    STATE(290), 1,
      aux_sym__un_delimited_javascript_multiline,
    STATE(391), 1,
      sym__multi_line_buf_code,
  [24518] = 3,
    ACTIONS(1755), 1,
      sym__un_delimited_javascript_line,
    STATE(304), 1,
      sym__single_line_buf_code,
    STATE(911), 1,
      sym__un_delimited_javascript,
  [24528] = 3,
    ACTIONS(1856), 1,
      aux_sym_filter_content_token2,
    ACTIONS(1959), 1,
      sym__dedent,
    STATE(734), 1,
      aux_sym_filter_content_repeat1,
  [24538] = 3,
    ACTIONS(1836), 1,
      anon_sym_COMMA,
    ACTIONS(1840), 1,
      anon_sym_,
    ACTIONS(1961), 1,
      anon_sym_RPAREN,
  [24548] = 3,
    ACTIONS(1856), 1,
      aux_sym_filter_content_token2,
    ACTIONS(1963), 1,
      sym__dedent,
    STATE(775), 1,
      aux_sym_filter_content_repeat1,
  [24558] = 3,
    ACTIONS(1755), 1,
      sym__un_delimited_javascript_line,
    STATE(307), 1,
      sym__single_line_buf_code,
    STATE(911), 1,
      sym__un_delimited_javascript,
  [24568] = 2,
    ACTIONS(1967), 1,
      anon_sym_,
    ACTIONS(1965), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [24576] = 3,
    ACTIONS(1836), 1,
      anon_sym_COMMA,
    ACTIONS(1840), 1,
      anon_sym_,
    ACTIONS(1969), 1,
      anon_sym_RPAREN,
  [24586] = 3,
    ACTIONS(1971), 1,
      sym__un_delimited_javascript_line,
    STATE(154), 1,
      aux_sym__un_delimited_javascript_multiline,
    STATE(286), 1,
      sym__multi_line_buf_code,
  [24596] = 3,
    ACTIONS(1727), 1,
      aux_sym_filter_content_token2,
    STATE(715), 1,
      aux_sym__comment_repeat1,
    STATE(907), 1,
      sym__comment_content,
  [24606] = 3,
    ACTIONS(1733), 1,
      aux_sym_include_token1,
    ACTIONS(1735), 1,
      sym__newline,
    STATE(712), 1,
      aux_sym_script_block_repeat1,
  [24616] = 3,
    ACTIONS(1856), 1,
      aux_sym_filter_content_token2,
    ACTIONS(1973), 1,
      sym__dedent,
    STATE(734), 1,
      aux_sym_filter_content_repeat1,
  [24626] = 3,
    ACTIONS(1836), 1,
      anon_sym_COMMA,
    ACTIONS(1840), 1,
      anon_sym_,
    ACTIONS(1975), 1,
      anon_sym_RPAREN,
  [24636] = 3,
    ACTIONS(1516), 1,
      anon_sym_COLON,
    ACTIONS(1977), 1,
      aux_sym_include_token1,
    STATE(1059), 1,
      sym_filter,
  [24646] = 3,
    ACTIONS(1856), 1,
      aux_sym_filter_content_token2,
    ACTIONS(1979), 1,
      sym__dedent,
    STATE(792), 1,
      aux_sym_filter_content_repeat1,
  [24656] = 3,
    ACTIONS(1981), 1,
      anon_sym_RPAREN,
    ACTIONS(1983), 1,
      aux_sym_mixin_attributes_token1,
    STATE(811), 1,
      aux_sym_mixin_attributes_repeat1,
  [24666] = 3,
    ACTIONS(1836), 1,
      anon_sym_COMMA,
    ACTIONS(1840), 1,
      anon_sym_,
    ACTIONS(1985), 1,
      anon_sym_RPAREN,
  [24676] = 3,
    ACTIONS(1836), 1,
      anon_sym_COMMA,
    ACTIONS(1840), 1,
      anon_sym_,
    ACTIONS(1987), 1,
      anon_sym_RPAREN,
  [24686] = 3,
    ACTIONS(1856), 1,
      aux_sym_filter_content_token2,
    ACTIONS(1989), 1,
      sym__dedent,
    STATE(734), 1,
      aux_sym_filter_content_repeat1,
  [24696] = 3,
    ACTIONS(1755), 1,
      sym__un_delimited_javascript_line,
    STATE(168), 1,
      sym__single_line_buf_code,
    STATE(983), 1,
      sym__un_delimited_javascript,
  [24706] = 3,
    ACTIONS(1755), 1,
      sym__un_delimited_javascript_line,
    STATE(169), 1,
      sym__single_line_buf_code,
    STATE(983), 1,
      sym__un_delimited_javascript,
  [24716] = 3,
    ACTIONS(1516), 1,
      anon_sym_COLON,
    ACTIONS(1991), 1,
      aux_sym_include_token1,
    STATE(1025), 1,
      sym_filter,
  [24726] = 3,
    ACTIONS(1755), 1,
      sym__un_delimited_javascript_line,
    STATE(230), 1,
      sym__single_line_buf_code,
    STATE(988), 1,
      sym__un_delimited_javascript,
  [24736] = 3,
    ACTIONS(1755), 1,
      sym__un_delimited_javascript_line,
    STATE(231), 1,
      sym__single_line_buf_code,
    STATE(988), 1,
      sym__un_delimited_javascript,
  [24746] = 3,
    ACTIONS(1755), 1,
      sym__un_delimited_javascript_line,
    STATE(385), 1,
      sym__single_line_buf_code,
    STATE(898), 1,
      sym__un_delimited_javascript,
  [24756] = 3,
    ACTIONS(1993), 1,
      anon_sym_LPAREN,
    ACTIONS(1995), 1,
      sym__newline,
    STATE(902), 1,
      sym_mixin_attributes,
  [24766] = 3,
    ACTIONS(1856), 1,
      aux_sym_filter_content_token2,
    ACTIONS(1997), 1,
      sym__dedent,
    STATE(799), 1,
      aux_sym_filter_content_repeat1,
  [24776] = 3,
    ACTIONS(1999), 1,
      sym__un_delimited_javascript_line,
    STATE(151), 1,
      aux_sym__un_delimited_javascript_multiline,
    STATE(289), 1,
      sym__multi_line_buf_code,
  [24786] = 3,
    ACTIONS(1755), 1,
      sym__un_delimited_javascript_line,
    STATE(386), 1,
      sym__single_line_buf_code,
    STATE(898), 1,
      sym__un_delimited_javascript,
  [24796] = 3,
    ACTIONS(1836), 1,
      anon_sym_COMMA,
    ACTIONS(1840), 1,
      anon_sym_,
    ACTIONS(2001), 1,
      anon_sym_RPAREN,
  [24806] = 2,
    ACTIONS(2003), 1,
      aux_sym_mixin_attributes_token1,
    STATE(872), 1,
      aux_sym_mixin_attributes_repeat1,
  [24813] = 2,
    ACTIONS(2005), 1,
      sym_tag_name,
    STATE(131), 1,
      sym__block_content,
  [24820] = 2,
    ACTIONS(1755), 1,
      sym__un_delimited_javascript_line,
    STATE(1002), 1,
      sym__un_delimited_javascript,
  [24827] = 2,
    ACTIONS(675), 1,
      sym__indent,
    STATE(149), 1,
      sym_children,
  [24834] = 2,
    ACTIONS(2007), 1,
      aux_sym_include_token1,
    STATE(896), 1,
      sym_iteration_iterator,
  [24841] = 2,
    ACTIONS(989), 1,
      sym__indent,
    STATE(271), 1,
      sym_children,
  [24848] = 2,
    ACTIONS(2009), 1,
      sym_tag_name,
    STATE(270), 1,
      sym__block_content,
  [24855] = 2,
    ACTIONS(2009), 1,
      sym_tag_name,
    STATE(269), 1,
      sym__block_content,
  [24862] = 2,
    ACTIONS(1755), 1,
      sym__un_delimited_javascript_line,
    STATE(971), 1,
      sym__un_delimited_javascript,
  [24869] = 2,
    ACTIONS(2007), 1,
      aux_sym_include_token1,
    STATE(970), 1,
      sym_iteration_iterator,
  [24876] = 2,
    ACTIONS(2011), 1,
      sym_tag_name,
    STATE(219), 1,
      sym__block_content,
  [24883] = 2,
    ACTIONS(2011), 1,
      sym_tag_name,
    STATE(222), 1,
      sym__block_content,
  [24890] = 2,
    ACTIONS(811), 1,
      sym__indent,
    STATE(223), 1,
      sym_children,
  [24897] = 2,
    ACTIONS(2007), 1,
      aux_sym_include_token1,
    STATE(959), 1,
      sym_iteration_iterator,
  [24904] = 2,
    ACTIONS(989), 1,
      sym__indent,
    STATE(263), 1,
      sym_children,
  [24911] = 2,
    ACTIONS(1755), 1,
      sym__un_delimited_javascript_line,
    STATE(952), 1,
      sym__un_delimited_javascript,
  [24918] = 2,
    ACTIONS(2007), 1,
      aux_sym_include_token1,
    STATE(951), 1,
      sym_iteration_iterator,
  [24925] = 2,
    ACTIONS(989), 1,
      sym__indent,
    STATE(256), 1,
      sym_children,
  [24932] = 2,
    ACTIONS(2007), 1,
      aux_sym_include_token1,
    STATE(940), 1,
      sym_iteration_iterator,
  [24939] = 2,
    ACTIONS(2011), 1,
      sym_tag_name,
    STATE(235), 1,
      sym__block_content,
  [24946] = 2,
    ACTIONS(2011), 1,
      sym_tag_name,
    STATE(236), 1,
      sym__block_content,
  [24953] = 2,
    ACTIONS(1755), 1,
      sym__un_delimited_javascript_line,
    STATE(934), 1,
      sym__un_delimited_javascript,
  [24960] = 2,
    ACTIONS(2007), 1,
      aux_sym_include_token1,
    STATE(933), 1,
      sym_iteration_iterator,
  [24967] = 2,
    ACTIONS(2007), 1,
      aux_sym_include_token1,
    STATE(923), 1,
      sym_iteration_iterator,
  [24974] = 2,
    ACTIONS(1015), 1,
      sym__indent,
    STATE(322), 1,
      sym_children,
  [24981] = 2,
    ACTIONS(2013), 1,
      anon_sym_COMMA,
    ACTIONS(2015), 1,
      anon_sym_in,
  [24988] = 2,
    ACTIONS(1755), 1,
      sym__un_delimited_javascript_line,
    STATE(915), 1,
      sym__un_delimited_javascript,
  [24995] = 2,
    ACTIONS(989), 1,
      sym__indent,
    STATE(213), 1,
      sym_children,
  [25002] = 2,
    ACTIONS(2017), 1,
      sym_tag_name,
    STATE(367), 1,
      sym__block_content,
  [25009] = 2,
    ACTIONS(2017), 1,
      sym_tag_name,
    STATE(366), 1,
      sym__block_content,
  [25016] = 2,
    ACTIONS(2007), 1,
      aux_sym_include_token1,
    STATE(914), 1,
      sym_iteration_iterator,
  [25023] = 2,
    ACTIONS(675), 1,
      sym__indent,
    STATE(81), 1,
      sym_children,
  [25030] = 2,
    ACTIONS(1015), 1,
      sym__indent,
    STATE(334), 1,
      sym_children,
  [25037] = 2,
    ACTIONS(2019), 1,
      anon_sym_COMMA,
    ACTIONS(2021), 1,
      anon_sym_RPAREN,
  [25044] = 2,
    ACTIONS(2005), 1,
      sym_tag_name,
    STATE(143), 1,
      sym__block_content,
  [25051] = 2,
    ACTIONS(989), 1,
      sym__indent,
    STATE(310), 1,
      sym_children,
  [25058] = 1,
    ACTIONS(2023), 2,
      sym__newline,
      anon_sym_COLON,
  [25063] = 2,
    ACTIONS(2005), 1,
      sym_tag_name,
    STATE(142), 1,
      sym__block_content,
  [25070] = 1,
    ACTIONS(1881), 2,
      sym__dedent,
      aux_sym_filter_content_token2,
  [25075] = 2,
    ACTIONS(675), 1,
      sym__indent,
    STATE(141), 1,
      sym_children,
  [25082] = 2,
    ACTIONS(675), 1,
      sym__indent,
    STATE(97), 1,
      sym_children,
  [25089] = 1,
    ACTIONS(1848), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [25094] = 2,
    ACTIONS(1836), 1,
      anon_sym_COMMA,
    ACTIONS(1840), 1,
      anon_sym_,
  [25101] = 2,
    ACTIONS(1015), 1,
      sym__indent,
    STATE(350), 1,
      sym_children,
  [25108] = 2,
    ACTIONS(2025), 1,
      sym_tag_name,
    STATE(414), 1,
      sym__block_content,
  [25115] = 2,
    ACTIONS(2027), 1,
      anon_sym_DQUOTE,
    ACTIONS(2029), 1,
      aux_sym_quoted_javascript_token2,
  [25122] = 2,
    ACTIONS(2027), 1,
      anon_sym_SQUOTE,
    ACTIONS(2031), 1,
      aux_sym_quoted_javascript_token1,
  [25129] = 2,
    ACTIONS(2025), 1,
      sym_tag_name,
    STATE(413), 1,
      sym__block_content,
  [25136] = 2,
    ACTIONS(2033), 1,
      aux_sym__each_js_token1,
    STATE(900), 1,
      sym__each_js,
  [25143] = 2,
    ACTIONS(2007), 1,
      aux_sym_include_token1,
    STATE(901), 1,
      sym_iteration_iterator,
  [25150] = 2,
    ACTIONS(1015), 1,
      sym__indent,
    STATE(344), 1,
      sym_children,
  [25157] = 2,
    ACTIONS(2009), 1,
      sym_tag_name,
    STATE(277), 1,
      sym__block_content,
  [25164] = 1,
    ACTIONS(1808), 2,
      sym__dedent,
      aux_sym_filter_content_token2,
  [25169] = 2,
    ACTIONS(2009), 1,
      sym_tag_name,
    STATE(278), 1,
      sym__block_content,
  [25176] = 2,
    ACTIONS(811), 1,
      sym__indent,
    STATE(208), 1,
      sym_children,
  [25183] = 2,
    ACTIONS(1015), 1,
      sym__indent,
    STATE(342), 1,
      sym_children,
  [25190] = 2,
    ACTIONS(2005), 1,
      sym_tag_name,
    STATE(132), 1,
      sym__block_content,
  [25197] = 2,
    ACTIONS(1041), 1,
      sym__indent,
    STATE(403), 1,
      sym_children,
  [25204] = 2,
    ACTIONS(2025), 1,
      sym_tag_name,
    STATE(402), 1,
      sym__block_content,
  [25211] = 2,
    ACTIONS(1015), 1,
      sym__indent,
    STATE(332), 1,
      sym_children,
  [25218] = 2,
    ACTIONS(2025), 1,
      sym_tag_name,
    STATE(398), 1,
      sym__block_content,
  [25225] = 2,
    ACTIONS(2035), 1,
      aux_sym_mixin_attributes_token1,
    STATE(872), 1,
      aux_sym_mixin_attributes_repeat1,
  [25232] = 2,
    ACTIONS(1041), 1,
      sym__indent,
    STATE(411), 1,
      sym_children,
  [25239] = 2,
    ACTIONS(811), 1,
      sym__indent,
    STATE(202), 1,
      sym_children,
  [25246] = 2,
    ACTIONS(1015), 1,
      sym__indent,
    STATE(285), 1,
      sym_children,
  [25253] = 2,
    ACTIONS(2038), 1,
      anon_sym_SQUOTE,
    ACTIONS(2040), 1,
      aux_sym_quoted_javascript_token1,
  [25260] = 2,
    ACTIONS(2038), 1,
      anon_sym_DQUOTE,
    ACTIONS(2042), 1,
      aux_sym_quoted_javascript_token2,
  [25267] = 2,
    ACTIONS(2017), 1,
      sym_tag_name,
    STATE(355), 1,
      sym__block_content,
  [25274] = 2,
    ACTIONS(2044), 1,
      anon_sym_COMMA,
    ACTIONS(2046), 1,
      anon_sym_RPAREN,
  [25281] = 2,
    ACTIONS(675), 1,
      sym__indent,
    STATE(145), 1,
      sym_children,
  [25288] = 1,
    ACTIONS(1854), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [25293] = 2,
    ACTIONS(2044), 1,
      anon_sym_COMMA,
    ACTIONS(2048), 1,
      anon_sym_RPAREN,
  [25300] = 2,
    ACTIONS(2050), 1,
      anon_sym_SQUOTE,
    ACTIONS(2052), 1,
      aux_sym_quoted_javascript_token1,
  [25307] = 2,
    ACTIONS(2050), 1,
      anon_sym_DQUOTE,
    ACTIONS(2054), 1,
      aux_sym_quoted_javascript_token2,
  [25314] = 2,
    ACTIONS(1041), 1,
      sym__indent,
    STATE(328), 1,
      sym_children,
  [25321] = 1,
    ACTIONS(1889), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [25326] = 2,
    ACTIONS(2017), 1,
      sym_tag_name,
    STATE(356), 1,
      sym__block_content,
  [25333] = 2,
    ACTIONS(2007), 1,
      aux_sym_include_token1,
    STATE(1010), 1,
      sym_iteration_iterator,
  [25340] = 2,
    ACTIONS(2019), 1,
      anon_sym_COMMA,
    ACTIONS(2056), 1,
      anon_sym_RPAREN,
  [25347] = 2,
    ACTIONS(811), 1,
      sym__indent,
    STATE(167), 1,
      sym_children,
  [25354] = 2,
    ACTIONS(1041), 1,
      sym__indent,
    STATE(381), 1,
      sym_children,
  [25361] = 2,
    ACTIONS(1015), 1,
      sym__indent,
    STATE(345), 1,
      sym_children,
  [25368] = 2,
    ACTIONS(1041), 1,
      sym__indent,
    STATE(388), 1,
      sym_children,
  [25375] = 2,
    ACTIONS(811), 1,
      sym__indent,
    STATE(247), 1,
      sym_children,
  [25382] = 1,
    ACTIONS(2058), 1,
      sym__indent,
  [25386] = 1,
    ACTIONS(2060), 1,
      sym__newline,
  [25390] = 1,
    ACTIONS(2062), 1,
      sym__indent,
  [25394] = 1,
    ACTIONS(2064), 1,
      sym__newline,
  [25398] = 1,
    ACTIONS(2066), 1,
      sym__indent,
  [25402] = 1,
    ACTIONS(2068), 1,
      anon_sym_in,
  [25406] = 1,
    ACTIONS(2070), 1,
      sym__newline,
  [25410] = 1,
    ACTIONS(2072), 1,
      sym__newline,
  [25414] = 1,
    ACTIONS(2074), 1,
      sym__newline,
  [25418] = 1,
    ACTIONS(2076), 1,
      anon_sym_SQUOTE,
  [25422] = 1,
    ACTIONS(2076), 1,
      anon_sym_DQUOTE,
  [25426] = 1,
    ACTIONS(2078), 1,
      sym__newline,
  [25430] = 1,
    ACTIONS(2080), 1,
      sym__newline,
  [25434] = 1,
    ACTIONS(2082), 1,
      sym__newline,
  [25438] = 1,
    ACTIONS(2084), 1,
      aux_sym__attribute_token1,
  [25442] = 1,
    ACTIONS(2086), 1,
      aux_sym_unbuffered_code_token1,
  [25446] = 1,
    ACTIONS(2088), 1,
      sym__newline,
  [25450] = 1,
    ACTIONS(2090), 1,
      sym__newline,
  [25454] = 1,
    ACTIONS(2092), 1,
      aux_sym_unbuffered_code_token1,
  [25458] = 1,
    ACTIONS(2094), 1,
      sym__newline,
  [25462] = 1,
    ACTIONS(2096), 1,
      sym__newline,
  [25466] = 1,
    ACTIONS(667), 1,
      aux_sym_include_token1,
  [25470] = 1,
    ACTIONS(2098), 1,
      aux_sym_filter_content_token2,
  [25474] = 1,
    ACTIONS(2100), 1,
      sym__indent,
  [25478] = 1,
    ACTIONS(2102), 1,
      sym__indent,
  [25482] = 1,
    ACTIONS(2104), 1,
      aux_sym_include_token1,
  [25486] = 1,
    ACTIONS(2106), 1,
      sym__newline,
  [25490] = 1,
    ACTIONS(2108), 1,
      sym__indent,
  [25494] = 1,
    ACTIONS(2110), 1,
      sym__newline,
  [25498] = 1,
    ACTIONS(2112), 1,
      sym__newline,
  [25502] = 1,
    ACTIONS(2114), 1,
      anon_sym_SQUOTE,
  [25506] = 1,
    ACTIONS(2114), 1,
      anon_sym_DQUOTE,
  [25510] = 1,
    ACTIONS(2116), 1,
      aux_sym_mixin_attributes_token1,
  [25514] = 1,
    ACTIONS(2118), 1,
      sym__newline,
  [25518] = 1,
    ACTIONS(2120), 1,
      sym__un_delimited_javascript_line,
  [25522] = 1,
    ACTIONS(2122), 1,
      sym__newline,
  [25526] = 1,
    ACTIONS(2124), 1,
      sym__newline,
  [25530] = 1,
    ACTIONS(2126), 1,
      aux_sym_unbuffered_code_token1,
  [25534] = 1,
    ACTIONS(2128), 1,
      sym__newline,
  [25538] = 1,
    ACTIONS(2130), 1,
      sym__newline,
  [25542] = 1,
    ACTIONS(2132), 1,
      sym__indent,
  [25546] = 1,
    ACTIONS(2134), 1,
      sym_filter_name,
  [25550] = 1,
    ACTIONS(2136), 1,
      sym__newline,
  [25554] = 1,
    ACTIONS(2138), 1,
      sym__newline,
  [25558] = 1,
    ACTIONS(2140), 1,
      sym__indent,
  [25562] = 1,
    ACTIONS(2142), 1,
      sym__newline,
  [25566] = 1,
    ACTIONS(2144), 1,
      sym__newline,
  [25570] = 1,
    ACTIONS(2146), 1,
      aux_sym_filter_content_token2,
  [25574] = 1,
    ACTIONS(2148), 1,
      sym__indent,
  [25578] = 1,
    ACTIONS(2150), 1,
      aux_sym__when_keyword_token1,
  [25582] = 1,
    ACTIONS(2152), 1,
      sym__delimited_javascript,
  [25586] = 1,
    ACTIONS(2154), 1,
      aux_sym_include_token1,
  [25590] = 1,
    ACTIONS(2156), 1,
      sym__newline,
  [25594] = 1,
    ACTIONS(2158), 1,
      sym__newline,
  [25598] = 1,
    ACTIONS(2160), 1,
      aux_sym_filter_content_token2,
  [25602] = 1,
    ACTIONS(2162), 1,
      aux_sym_unbuffered_code_token1,
  [25606] = 1,
    ACTIONS(2164), 1,
      sym__newline,
  [25610] = 1,
    ACTIONS(2166), 1,
      sym__newline,
  [25614] = 1,
    ACTIONS(2168), 1,
      sym__indent,
  [25618] = 1,
    ACTIONS(2170), 1,
      sym__indent,
  [25622] = 1,
    ACTIONS(2172), 1,
      sym__newline,
  [25626] = 1,
    ACTIONS(2174), 1,
      sym_filter_name,
  [25630] = 1,
    ACTIONS(2176), 1,
      sym__indent,
  [25634] = 1,
    ACTIONS(2178), 1,
      sym__indent,
  [25638] = 1,
    ACTIONS(2180), 1,
      sym__newline,
  [25642] = 1,
    ACTIONS(2182), 1,
      aux_sym_include_token1,
  [25646] = 1,
    ACTIONS(2184), 1,
      ts_builtin_sym_end,
  [25650] = 1,
    ACTIONS(2186), 1,
      aux_sym_include_token1,
  [25654] = 1,
    ACTIONS(2188), 1,
      sym_tag_name,
  [25658] = 1,
    ACTIONS(2190), 1,
      aux_sym_filter_content_token2,
  [25662] = 1,
    ACTIONS(2192), 1,
      sym_tag_name,
  [25666] = 1,
    ACTIONS(2194), 1,
      sym__newline,
  [25670] = 1,
    ACTIONS(2196), 1,
      sym__newline,
  [25674] = 1,
    ACTIONS(2198), 1,
      sym_filter_name,
  [25678] = 1,
    ACTIONS(2200), 1,
      aux_sym_unbuffered_code_token1,
  [25682] = 1,
    ACTIONS(2202), 1,
      sym__newline,
  [25686] = 1,
    ACTIONS(2204), 1,
      sym__newline,
  [25690] = 1,
    ACTIONS(2206), 1,
      anon_sym_RBRACE_RBRACE,
  [25694] = 1,
    ACTIONS(2208), 1,
      sym__indent,
  [25698] = 1,
    ACTIONS(2206), 1,
      anon_sym_RBRACE,
  [25702] = 1,
    ACTIONS(2210), 1,
      aux_sym_include_token1,
  [25706] = 1,
    ACTIONS(2044), 1,
      anon_sym_COMMA,
  [25710] = 1,
    ACTIONS(2212), 1,
      sym__indent,
  [25714] = 1,
    ACTIONS(2214), 1,
      sym__delimited_javascript,
  [25718] = 1,
    ACTIONS(2216), 1,
      sym__newline,
  [25722] = 1,
    ACTIONS(2218), 1,
      sym__newline,
  [25726] = 1,
    ACTIONS(2019), 1,
      anon_sym_COMMA,
  [25730] = 1,
    ACTIONS(2220), 1,
      sym__newline,
  [25734] = 1,
    ACTIONS(2222), 1,
      sym__newline,
  [25738] = 1,
    ACTIONS(2224), 1,
      sym__indent,
  [25742] = 1,
    ACTIONS(2226), 1,
      sym__newline,
  [25746] = 1,
    ACTIONS(2228), 1,
      sym_filter_name,
  [25750] = 1,
    ACTIONS(2230), 1,
      sym__indent,
  [25754] = 1,
    ACTIONS(2232), 1,
      sym__newline,
  [25758] = 1,
    ACTIONS(2234), 1,
      anon_sym_SQUOTE,
  [25762] = 1,
    ACTIONS(2234), 1,
      anon_sym_DQUOTE,
  [25766] = 1,
    ACTIONS(2236), 1,
      sym__newline,
  [25770] = 1,
    ACTIONS(2238), 1,
      sym__indent,
  [25774] = 1,
    ACTIONS(2240), 1,
      sym__newline,
  [25778] = 1,
    ACTIONS(2242), 1,
      sym__newline,
  [25782] = 1,
    ACTIONS(859), 1,
      aux_sym_include_token1,
  [25786] = 1,
    ACTIONS(921), 1,
      aux_sym_include_token1,
  [25790] = 1,
    ACTIONS(967), 1,
      aux_sym_include_token1,
  [25794] = 1,
    ACTIONS(2244), 1,
      aux_sym_include_token1,
  [25798] = 1,
    ACTIONS(963), 1,
      aux_sym_include_token1,
  [25802] = 1,
    ACTIONS(2246), 1,
      sym__newline,
  [25806] = 1,
    ACTIONS(917), 1,
      aux_sym_include_token1,
  [25810] = 1,
    ACTIONS(2248), 1,
      sym__newline,
  [25814] = 1,
    ACTIONS(2250), 1,
      sym__newline,
  [25818] = 1,
    ACTIONS(2252), 1,
      sym__newline,
  [25822] = 1,
    ACTIONS(2254), 1,
      sym__indent,
  [25826] = 1,
    ACTIONS(2256), 1,
      sym__indent,
  [25830] = 1,
    ACTIONS(2258), 1,
      anon_sym_in,
  [25834] = 1,
    ACTIONS(2260), 1,
      sym__indent,
  [25838] = 1,
    ACTIONS(2262), 1,
      sym__indent,
  [25842] = 1,
    ACTIONS(2264), 1,
      sym__newline,
  [25846] = 1,
    ACTIONS(2266), 1,
      sym__newline,
  [25850] = 1,
    ACTIONS(2268), 1,
      sym__newline,
  [25854] = 1,
    ACTIONS(2270), 1,
      sym__indent,
  [25858] = 1,
    ACTIONS(2272), 1,
      sym__indent,
  [25862] = 1,
    ACTIONS(2274), 1,
      aux_sym_include_token1,
  [25866] = 1,
    ACTIONS(2276), 1,
      sym__indent,
  [25870] = 1,
    ACTIONS(2278), 1,
      sym__indent,
  [25874] = 1,
    ACTIONS(2280), 1,
      aux_sym_include_token1,
  [25878] = 1,
    ACTIONS(2282), 1,
      aux_sym_filter_content_token2,
  [25882] = 1,
    ACTIONS(2284), 1,
      sym__indent,
  [25886] = 1,
    ACTIONS(2286), 1,
      sym__indent,
  [25890] = 1,
    ACTIONS(2288), 1,
      sym_filter_name,
  [25894] = 1,
    ACTIONS(2290), 1,
      sym__indent,
  [25898] = 1,
    ACTIONS(2292), 1,
      sym__indent,
  [25902] = 1,
    ACTIONS(2294), 1,
      aux_sym_include_token1,
  [25906] = 1,
    ACTIONS(2296), 1,
      sym__newline,
  [25910] = 1,
    ACTIONS(2298), 1,
      sym__indent,
  [25914] = 1,
    ACTIONS(2300), 1,
      sym__indent,
  [25918] = 1,
    ACTIONS(2302), 1,
      sym__newline,
  [25922] = 1,
    ACTIONS(2304), 1,
      sym__indent,
  [25926] = 1,
    ACTIONS(2306), 1,
      sym__indent,
  [25930] = 1,
    ACTIONS(2308), 1,
      sym__indent,
  [25934] = 1,
    ACTIONS(2310), 1,
      sym__indent,
  [25938] = 1,
    ACTIONS(2312), 1,
      sym__indent,
  [25942] = 1,
    ACTIONS(2314), 1,
      sym__indent,
  [25946] = 1,
    ACTIONS(2316), 1,
      sym__un_delimited_javascript_line,
  [25950] = 1,
    ACTIONS(2318), 1,
      sym__newline,
  [25954] = 1,
    ACTIONS(2320), 1,
      anon_sym_in,
  [25958] = 1,
    ACTIONS(2322), 1,
      sym__newline,
  [25962] = 1,
    ACTIONS(2324), 1,
      sym__newline,
  [25966] = 1,
    ACTIONS(2326), 1,
      sym__un_delimited_javascript_line,
  [25970] = 1,
    ACTIONS(2328), 1,
      sym__newline,
  [25974] = 1,
    ACTIONS(2330), 1,
      anon_sym_in,
  [25978] = 1,
    ACTIONS(2332), 1,
      sym__newline,
  [25982] = 1,
    ACTIONS(2334), 1,
      sym__newline,
  [25986] = 1,
    ACTIONS(2336), 1,
      sym__newline,
  [25990] = 1,
    ACTIONS(2338), 1,
      anon_sym_in,
  [25994] = 1,
    ACTIONS(2340), 1,
      sym__newline,
  [25998] = 1,
    ACTIONS(2342), 1,
      sym__newline,
  [26002] = 1,
    ACTIONS(2344), 1,
      sym__newline,
  [26006] = 1,
    ACTIONS(2346), 1,
      anon_sym_in,
  [26010] = 1,
    ACTIONS(2348), 1,
      sym__newline,
  [26014] = 1,
    ACTIONS(2350), 1,
      sym__newline,
  [26018] = 1,
    ACTIONS(2352), 1,
      sym__newline,
  [26022] = 1,
    ACTIONS(2354), 1,
      sym__newline,
  [26026] = 1,
    ACTIONS(2356), 1,
      sym__newline,
  [26030] = 1,
    ACTIONS(2358), 1,
      sym__newline,
  [26034] = 1,
    ACTIONS(2360), 1,
      sym_filter_name,
  [26038] = 1,
    ACTIONS(2362), 1,
      aux_sym_include_token1,
  [26042] = 1,
    ACTIONS(2364), 1,
      aux_sym_filter_content_token2,
  [26046] = 1,
    ACTIONS(2366), 1,
      sym__newline,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 111,
  [SMALL_STATE(4)] = 220,
  [SMALL_STATE(5)] = 331,
  [SMALL_STATE(6)] = 440,
  [SMALL_STATE(7)] = 547,
  [SMALL_STATE(8)] = 656,
  [SMALL_STATE(9)] = 762,
  [SMALL_STATE(10)] = 868,
  [SMALL_STATE(11)] = 974,
  [SMALL_STATE(12)] = 1080,
  [SMALL_STATE(13)] = 1182,
  [SMALL_STATE(14)] = 1284,
  [SMALL_STATE(15)] = 1386,
  [SMALL_STATE(16)] = 1488,
  [SMALL_STATE(17)] = 1590,
  [SMALL_STATE(18)] = 1692,
  [SMALL_STATE(19)] = 1794,
  [SMALL_STATE(20)] = 1896,
  [SMALL_STATE(21)] = 1998,
  [SMALL_STATE(22)] = 2100,
  [SMALL_STATE(23)] = 2202,
  [SMALL_STATE(24)] = 2304,
  [SMALL_STATE(25)] = 2406,
  [SMALL_STATE(26)] = 2508,
  [SMALL_STATE(27)] = 2610,
  [SMALL_STATE(28)] = 2712,
  [SMALL_STATE(29)] = 2814,
  [SMALL_STATE(30)] = 2916,
  [SMALL_STATE(31)] = 3018,
  [SMALL_STATE(32)] = 3120,
  [SMALL_STATE(33)] = 3222,
  [SMALL_STATE(34)] = 3324,
  [SMALL_STATE(35)] = 3426,
  [SMALL_STATE(36)] = 3528,
  [SMALL_STATE(37)] = 3630,
  [SMALL_STATE(38)] = 3732,
  [SMALL_STATE(39)] = 3834,
  [SMALL_STATE(40)] = 3936,
  [SMALL_STATE(41)] = 4038,
  [SMALL_STATE(42)] = 4140,
  [SMALL_STATE(43)] = 4242,
  [SMALL_STATE(44)] = 4341,
  [SMALL_STATE(45)] = 4440,
  [SMALL_STATE(46)] = 4539,
  [SMALL_STATE(47)] = 4638,
  [SMALL_STATE(48)] = 4737,
  [SMALL_STATE(49)] = 4836,
  [SMALL_STATE(50)] = 4935,
  [SMALL_STATE(51)] = 4991,
  [SMALL_STATE(52)] = 5045,
  [SMALL_STATE(53)] = 5093,
  [SMALL_STATE(54)] = 5141,
  [SMALL_STATE(55)] = 5191,
  [SMALL_STATE(56)] = 5234,
  [SMALL_STATE(57)] = 5277,
  [SMALL_STATE(58)] = 5320,
  [SMALL_STATE(59)] = 5373,
  [SMALL_STATE(60)] = 5416,
  [SMALL_STATE(61)] = 5459,
  [SMALL_STATE(62)] = 5502,
  [SMALL_STATE(63)] = 5545,
  [SMALL_STATE(64)] = 5588,
  [SMALL_STATE(65)] = 5641,
  [SMALL_STATE(66)] = 5684,
  [SMALL_STATE(67)] = 5727,
  [SMALL_STATE(68)] = 5770,
  [SMALL_STATE(69)] = 5814,
  [SMALL_STATE(70)] = 5856,
  [SMALL_STATE(71)] = 5894,
  [SMALL_STATE(72)] = 5936,
  [SMALL_STATE(73)] = 5978,
  [SMALL_STATE(74)] = 6024,
  [SMALL_STATE(75)] = 6066,
  [SMALL_STATE(76)] = 6108,
  [SMALL_STATE(77)] = 6146,
  [SMALL_STATE(78)] = 6188,
  [SMALL_STATE(79)] = 6228,
  [SMALL_STATE(80)] = 6270,
  [SMALL_STATE(81)] = 6316,
  [SMALL_STATE(82)] = 6358,
  [SMALL_STATE(83)] = 6396,
  [SMALL_STATE(84)] = 6438,
  [SMALL_STATE(85)] = 6478,
  [SMALL_STATE(86)] = 6526,
  [SMALL_STATE(87)] = 6564,
  [SMALL_STATE(88)] = 6601,
  [SMALL_STATE(89)] = 6638,
  [SMALL_STATE(90)] = 6675,
  [SMALL_STATE(91)] = 6712,
  [SMALL_STATE(92)] = 6753,
  [SMALL_STATE(93)] = 6792,
  [SMALL_STATE(94)] = 6839,
  [SMALL_STATE(95)] = 6876,
  [SMALL_STATE(96)] = 6917,
  [SMALL_STATE(97)] = 6958,
  [SMALL_STATE(98)] = 6995,
  [SMALL_STATE(99)] = 7036,
  [SMALL_STATE(100)] = 7073,
  [SMALL_STATE(101)] = 7110,
  [SMALL_STATE(102)] = 7151,
  [SMALL_STATE(103)] = 7196,
  [SMALL_STATE(104)] = 7233,
  [SMALL_STATE(105)] = 7270,
  [SMALL_STATE(106)] = 7307,
  [SMALL_STATE(107)] = 7348,
  [SMALL_STATE(108)] = 7385,
  [SMALL_STATE(109)] = 7422,
  [SMALL_STATE(110)] = 7463,
  [SMALL_STATE(111)] = 7510,
  [SMALL_STATE(112)] = 7547,
  [SMALL_STATE(113)] = 7588,
  [SMALL_STATE(114)] = 7633,
  [SMALL_STATE(115)] = 7670,
  [SMALL_STATE(116)] = 7711,
  [SMALL_STATE(117)] = 7748,
  [SMALL_STATE(118)] = 7785,
  [SMALL_STATE(119)] = 7824,
  [SMALL_STATE(120)] = 7861,
  [SMALL_STATE(121)] = 7898,
  [SMALL_STATE(122)] = 7935,
  [SMALL_STATE(123)] = 7976,
  [SMALL_STATE(124)] = 8013,
  [SMALL_STATE(125)] = 8050,
  [SMALL_STATE(126)] = 8087,
  [SMALL_STATE(127)] = 8124,
  [SMALL_STATE(128)] = 8161,
  [SMALL_STATE(129)] = 8198,
  [SMALL_STATE(130)] = 8235,
  [SMALL_STATE(131)] = 8272,
  [SMALL_STATE(132)] = 8309,
  [SMALL_STATE(133)] = 8346,
  [SMALL_STATE(134)] = 8383,
  [SMALL_STATE(135)] = 8420,
  [SMALL_STATE(136)] = 8457,
  [SMALL_STATE(137)] = 8494,
  [SMALL_STATE(138)] = 8531,
  [SMALL_STATE(139)] = 8582,
  [SMALL_STATE(140)] = 8619,
  [SMALL_STATE(141)] = 8656,
  [SMALL_STATE(142)] = 8693,
  [SMALL_STATE(143)] = 8730,
  [SMALL_STATE(144)] = 8767,
  [SMALL_STATE(145)] = 8806,
  [SMALL_STATE(146)] = 8843,
  [SMALL_STATE(147)] = 8880,
  [SMALL_STATE(148)] = 8917,
  [SMALL_STATE(149)] = 8954,
  [SMALL_STATE(150)] = 8991,
  [SMALL_STATE(151)] = 9028,
  [SMALL_STATE(152)] = 9068,
  [SMALL_STATE(153)] = 9104,
  [SMALL_STATE(154)] = 9140,
  [SMALL_STATE(155)] = 9180,
  [SMALL_STATE(156)] = 9220,
  [SMALL_STATE(157)] = 9256,
  [SMALL_STATE(158)] = 9292,
  [SMALL_STATE(159)] = 9332,
  [SMALL_STATE(160)] = 9372,
  [SMALL_STATE(161)] = 9408,
  [SMALL_STATE(162)] = 9444,
  [SMALL_STATE(163)] = 9480,
  [SMALL_STATE(164)] = 9516,
  [SMALL_STATE(165)] = 9552,
  [SMALL_STATE(166)] = 9590,
  [SMALL_STATE(167)] = 9626,
  [SMALL_STATE(168)] = 9666,
  [SMALL_STATE(169)] = 9702,
  [SMALL_STATE(170)] = 9738,
  [SMALL_STATE(171)] = 9776,
  [SMALL_STATE(172)] = 9812,
  [SMALL_STATE(173)] = 9848,
  [SMALL_STATE(174)] = 9884,
  [SMALL_STATE(175)] = 9924,
  [SMALL_STATE(176)] = 9964,
  [SMALL_STATE(177)] = 10000,
  [SMALL_STATE(178)] = 10036,
  [SMALL_STATE(179)] = 10072,
  [SMALL_STATE(180)] = 10112,
  [SMALL_STATE(181)] = 10150,
  [SMALL_STATE(182)] = 10190,
  [SMALL_STATE(183)] = 10230,
  [SMALL_STATE(184)] = 10270,
  [SMALL_STATE(185)] = 10310,
  [SMALL_STATE(186)] = 10350,
  [SMALL_STATE(187)] = 10386,
  [SMALL_STATE(188)] = 10421,
  [SMALL_STATE(189)] = 10456,
  [SMALL_STATE(190)] = 10493,
  [SMALL_STATE(191)] = 10530,
  [SMALL_STATE(192)] = 10565,
  [SMALL_STATE(193)] = 10604,
  [SMALL_STATE(194)] = 10639,
  [SMALL_STATE(195)] = 10674,
  [SMALL_STATE(196)] = 10709,
  [SMALL_STATE(197)] = 10744,
  [SMALL_STATE(198)] = 10779,
  [SMALL_STATE(199)] = 10814,
  [SMALL_STATE(200)] = 10849,
  [SMALL_STATE(201)] = 10884,
  [SMALL_STATE(202)] = 10919,
  [SMALL_STATE(203)] = 10954,
  [SMALL_STATE(204)] = 10989,
  [SMALL_STATE(205)] = 11024,
  [SMALL_STATE(206)] = 11059,
  [SMALL_STATE(207)] = 11094,
  [SMALL_STATE(208)] = 11133,
  [SMALL_STATE(209)] = 11168,
  [SMALL_STATE(210)] = 11205,
  [SMALL_STATE(211)] = 11244,
  [SMALL_STATE(212)] = 11279,
  [SMALL_STATE(213)] = 11314,
  [SMALL_STATE(214)] = 11353,
  [SMALL_STATE(215)] = 11388,
  [SMALL_STATE(216)] = 11423,
  [SMALL_STATE(217)] = 11460,
  [SMALL_STATE(218)] = 11499,
  [SMALL_STATE(219)] = 11534,
  [SMALL_STATE(220)] = 11569,
  [SMALL_STATE(221)] = 11604,
  [SMALL_STATE(222)] = 11643,
  [SMALL_STATE(223)] = 11678,
  [SMALL_STATE(224)] = 11713,
  [SMALL_STATE(225)] = 11748,
  [SMALL_STATE(226)] = 11783,
  [SMALL_STATE(227)] = 11818,
  [SMALL_STATE(228)] = 11853,
  [SMALL_STATE(229)] = 11888,
  [SMALL_STATE(230)] = 11923,
  [SMALL_STATE(231)] = 11958,
  [SMALL_STATE(232)] = 11993,
  [SMALL_STATE(233)] = 12028,
  [SMALL_STATE(234)] = 12063,
  [SMALL_STATE(235)] = 12098,
  [SMALL_STATE(236)] = 12133,
  [SMALL_STATE(237)] = 12168,
  [SMALL_STATE(238)] = 12203,
  [SMALL_STATE(239)] = 12238,
  [SMALL_STATE(240)] = 12273,
  [SMALL_STATE(241)] = 12308,
  [SMALL_STATE(242)] = 12343,
  [SMALL_STATE(243)] = 12378,
  [SMALL_STATE(244)] = 12423,
  [SMALL_STATE(245)] = 12460,
  [SMALL_STATE(246)] = 12495,
  [SMALL_STATE(247)] = 12534,
  [SMALL_STATE(248)] = 12569,
  [SMALL_STATE(249)] = 12604,
  [SMALL_STATE(250)] = 12643,
  [SMALL_STATE(251)] = 12682,
  [SMALL_STATE(252)] = 12717,
  [SMALL_STATE(253)] = 12752,
  [SMALL_STATE(254)] = 12791,
  [SMALL_STATE(255)] = 12826,
  [SMALL_STATE(256)] = 12860,
  [SMALL_STATE(257)] = 12894,
  [SMALL_STATE(258)] = 12932,
  [SMALL_STATE(259)] = 12966,
  [SMALL_STATE(260)] = 13000,
  [SMALL_STATE(261)] = 13034,
  [SMALL_STATE(262)] = 13072,
  [SMALL_STATE(263)] = 13106,
  [SMALL_STATE(264)] = 13140,
  [SMALL_STATE(265)] = 13176,
  [SMALL_STATE(266)] = 13212,
  [SMALL_STATE(267)] = 13246,
  [SMALL_STATE(268)] = 13282,
  [SMALL_STATE(269)] = 13318,
  [SMALL_STATE(270)] = 13352,
  [SMALL_STATE(271)] = 13386,
  [SMALL_STATE(272)] = 13420,
  [SMALL_STATE(273)] = 13454,
  [SMALL_STATE(274)] = 13488,
  [SMALL_STATE(275)] = 13524,
  [SMALL_STATE(276)] = 13558,
  [SMALL_STATE(277)] = 13592,
  [SMALL_STATE(278)] = 13626,
  [SMALL_STATE(279)] = 13660,
  [SMALL_STATE(280)] = 13694,
  [SMALL_STATE(281)] = 13728,
  [SMALL_STATE(282)] = 13762,
  [SMALL_STATE(283)] = 13796,
  [SMALL_STATE(284)] = 13832,
  [SMALL_STATE(285)] = 13866,
  [SMALL_STATE(286)] = 13904,
  [SMALL_STATE(287)] = 13940,
  [SMALL_STATE(288)] = 13974,
  [SMALL_STATE(289)] = 14012,
  [SMALL_STATE(290)] = 14048,
  [SMALL_STATE(291)] = 14086,
  [SMALL_STATE(292)] = 14120,
  [SMALL_STATE(293)] = 14158,
  [SMALL_STATE(294)] = 14192,
  [SMALL_STATE(295)] = 14230,
  [SMALL_STATE(296)] = 14264,
  [SMALL_STATE(297)] = 14298,
  [SMALL_STATE(298)] = 14332,
  [SMALL_STATE(299)] = 14366,
  [SMALL_STATE(300)] = 14400,
  [SMALL_STATE(301)] = 14434,
  [SMALL_STATE(302)] = 14468,
  [SMALL_STATE(303)] = 14502,
  [SMALL_STATE(304)] = 14536,
  [SMALL_STATE(305)] = 14570,
  [SMALL_STATE(306)] = 14604,
  [SMALL_STATE(307)] = 14638,
  [SMALL_STATE(308)] = 14672,
  [SMALL_STATE(309)] = 14706,
  [SMALL_STATE(310)] = 14740,
  [SMALL_STATE(311)] = 14774,
  [SMALL_STATE(312)] = 14812,
  [SMALL_STATE(313)] = 14846,
  [SMALL_STATE(314)] = 14884,
  [SMALL_STATE(315)] = 14918,
  [SMALL_STATE(316)] = 14952,
  [SMALL_STATE(317)] = 14990,
  [SMALL_STATE(318)] = 15028,
  [SMALL_STATE(319)] = 15062,
  [SMALL_STATE(320)] = 15096,
  [SMALL_STATE(321)] = 15130,
  [SMALL_STATE(322)] = 15163,
  [SMALL_STATE(323)] = 15196,
  [SMALL_STATE(324)] = 15229,
  [SMALL_STATE(325)] = 15262,
  [SMALL_STATE(326)] = 15295,
  [SMALL_STATE(327)] = 15328,
  [SMALL_STATE(328)] = 15363,
  [SMALL_STATE(329)] = 15400,
  [SMALL_STATE(330)] = 15433,
  [SMALL_STATE(331)] = 15466,
  [SMALL_STATE(332)] = 15499,
  [SMALL_STATE(333)] = 15532,
  [SMALL_STATE(334)] = 15565,
  [SMALL_STATE(335)] = 15598,
  [SMALL_STATE(336)] = 15631,
  [SMALL_STATE(337)] = 15664,
  [SMALL_STATE(338)] = 15697,
  [SMALL_STATE(339)] = 15730,
  [SMALL_STATE(340)] = 15763,
  [SMALL_STATE(341)] = 15796,
  [SMALL_STATE(342)] = 15829,
  [SMALL_STATE(343)] = 15862,
  [SMALL_STATE(344)] = 15895,
  [SMALL_STATE(345)] = 15928,
  [SMALL_STATE(346)] = 15961,
  [SMALL_STATE(347)] = 15994,
  [SMALL_STATE(348)] = 16027,
  [SMALL_STATE(349)] = 16060,
  [SMALL_STATE(350)] = 16093,
  [SMALL_STATE(351)] = 16126,
  [SMALL_STATE(352)] = 16159,
  [SMALL_STATE(353)] = 16192,
  [SMALL_STATE(354)] = 16225,
  [SMALL_STATE(355)] = 16258,
  [SMALL_STATE(356)] = 16291,
  [SMALL_STATE(357)] = 16324,
  [SMALL_STATE(358)] = 16357,
  [SMALL_STATE(359)] = 16390,
  [SMALL_STATE(360)] = 16425,
  [SMALL_STATE(361)] = 16458,
  [SMALL_STATE(362)] = 16491,
  [SMALL_STATE(363)] = 16524,
  [SMALL_STATE(364)] = 16557,
  [SMALL_STATE(365)] = 16590,
  [SMALL_STATE(366)] = 16623,
  [SMALL_STATE(367)] = 16656,
  [SMALL_STATE(368)] = 16689,
  [SMALL_STATE(369)] = 16722,
  [SMALL_STATE(370)] = 16755,
  [SMALL_STATE(371)] = 16788,
  [SMALL_STATE(372)] = 16821,
  [SMALL_STATE(373)] = 16854,
  [SMALL_STATE(374)] = 16887,
  [SMALL_STATE(375)] = 16920,
  [SMALL_STATE(376)] = 16953,
  [SMALL_STATE(377)] = 16985,
  [SMALL_STATE(378)] = 17017,
  [SMALL_STATE(379)] = 17049,
  [SMALL_STATE(380)] = 17081,
  [SMALL_STATE(381)] = 17113,
  [SMALL_STATE(382)] = 17145,
  [SMALL_STATE(383)] = 17177,
  [SMALL_STATE(384)] = 17209,
  [SMALL_STATE(385)] = 17241,
  [SMALL_STATE(386)] = 17273,
  [SMALL_STATE(387)] = 17305,
  [SMALL_STATE(388)] = 17337,
  [SMALL_STATE(389)] = 17369,
  [SMALL_STATE(390)] = 17403,
  [SMALL_STATE(391)] = 17435,
  [SMALL_STATE(392)] = 17469,
  [SMALL_STATE(393)] = 17501,
  [SMALL_STATE(394)] = 17533,
  [SMALL_STATE(395)] = 17565,
  [SMALL_STATE(396)] = 17597,
  [SMALL_STATE(397)] = 17629,
  [SMALL_STATE(398)] = 17661,
  [SMALL_STATE(399)] = 17693,
  [SMALL_STATE(400)] = 17725,
  [SMALL_STATE(401)] = 17757,
  [SMALL_STATE(402)] = 17789,
  [SMALL_STATE(403)] = 17821,
  [SMALL_STATE(404)] = 17853,
  [SMALL_STATE(405)] = 17885,
  [SMALL_STATE(406)] = 17917,
  [SMALL_STATE(407)] = 17949,
  [SMALL_STATE(408)] = 17981,
  [SMALL_STATE(409)] = 18013,
  [SMALL_STATE(410)] = 18045,
  [SMALL_STATE(411)] = 18077,
  [SMALL_STATE(412)] = 18109,
  [SMALL_STATE(413)] = 18141,
  [SMALL_STATE(414)] = 18173,
  [SMALL_STATE(415)] = 18205,
  [SMALL_STATE(416)] = 18237,
  [SMALL_STATE(417)] = 18269,
  [SMALL_STATE(418)] = 18301,
  [SMALL_STATE(419)] = 18333,
  [SMALL_STATE(420)] = 18365,
  [SMALL_STATE(421)] = 18397,
  [SMALL_STATE(422)] = 18429,
  [SMALL_STATE(423)] = 18458,
  [SMALL_STATE(424)] = 18487,
  [SMALL_STATE(425)] = 18527,
  [SMALL_STATE(426)] = 18567,
  [SMALL_STATE(427)] = 18607,
  [SMALL_STATE(428)] = 18647,
  [SMALL_STATE(429)] = 18673,
  [SMALL_STATE(430)] = 18713,
  [SMALL_STATE(431)] = 18753,
  [SMALL_STATE(432)] = 18793,
  [SMALL_STATE(433)] = 18833,
  [SMALL_STATE(434)] = 18873,
  [SMALL_STATE(435)] = 18913,
  [SMALL_STATE(436)] = 18939,
  [SMALL_STATE(437)] = 18979,
  [SMALL_STATE(438)] = 19019,
  [SMALL_STATE(439)] = 19059,
  [SMALL_STATE(440)] = 19099,
  [SMALL_STATE(441)] = 19119,
  [SMALL_STATE(442)] = 19145,
  [SMALL_STATE(443)] = 19171,
  [SMALL_STATE(444)] = 19197,
  [SMALL_STATE(445)] = 19223,
  [SMALL_STATE(446)] = 19249,
  [SMALL_STATE(447)] = 19275,
  [SMALL_STATE(448)] = 19301,
  [SMALL_STATE(449)] = 19327,
  [SMALL_STATE(450)] = 19353,
  [SMALL_STATE(451)] = 19379,
  [SMALL_STATE(452)] = 19405,
  [SMALL_STATE(453)] = 19431,
  [SMALL_STATE(454)] = 19457,
  [SMALL_STATE(455)] = 19483,
  [SMALL_STATE(456)] = 19509,
  [SMALL_STATE(457)] = 19536,
  [SMALL_STATE(458)] = 19563,
  [SMALL_STATE(459)] = 19590,
  [SMALL_STATE(460)] = 19617,
  [SMALL_STATE(461)] = 19644,
  [SMALL_STATE(462)] = 19671,
  [SMALL_STATE(463)] = 19698,
  [SMALL_STATE(464)] = 19725,
  [SMALL_STATE(465)] = 19752,
  [SMALL_STATE(466)] = 19779,
  [SMALL_STATE(467)] = 19806,
  [SMALL_STATE(468)] = 19833,
  [SMALL_STATE(469)] = 19860,
  [SMALL_STATE(470)] = 19887,
  [SMALL_STATE(471)] = 19911,
  [SMALL_STATE(472)] = 19937,
  [SMALL_STATE(473)] = 19961,
  [SMALL_STATE(474)] = 19987,
  [SMALL_STATE(475)] = 20011,
  [SMALL_STATE(476)] = 20037,
  [SMALL_STATE(477)] = 20061,
  [SMALL_STATE(478)] = 20087,
  [SMALL_STATE(479)] = 20099,
  [SMALL_STATE(480)] = 20125,
  [SMALL_STATE(481)] = 20151,
  [SMALL_STATE(482)] = 20177,
  [SMALL_STATE(483)] = 20201,
  [SMALL_STATE(484)] = 20227,
  [SMALL_STATE(485)] = 20251,
  [SMALL_STATE(486)] = 20275,
  [SMALL_STATE(487)] = 20299,
  [SMALL_STATE(488)] = 20311,
  [SMALL_STATE(489)] = 20337,
  [SMALL_STATE(490)] = 20349,
  [SMALL_STATE(491)] = 20375,
  [SMALL_STATE(492)] = 20399,
  [SMALL_STATE(493)] = 20423,
  [SMALL_STATE(494)] = 20447,
  [SMALL_STATE(495)] = 20473,
  [SMALL_STATE(496)] = 20497,
  [SMALL_STATE(497)] = 20521,
  [SMALL_STATE(498)] = 20545,
  [SMALL_STATE(499)] = 20569,
  [SMALL_STATE(500)] = 20581,
  [SMALL_STATE(501)] = 20607,
  [SMALL_STATE(502)] = 20631,
  [SMALL_STATE(503)] = 20657,
  [SMALL_STATE(504)] = 20683,
  [SMALL_STATE(505)] = 20707,
  [SMALL_STATE(506)] = 20731,
  [SMALL_STATE(507)] = 20757,
  [SMALL_STATE(508)] = 20769,
  [SMALL_STATE(509)] = 20793,
  [SMALL_STATE(510)] = 20817,
  [SMALL_STATE(511)] = 20841,
  [SMALL_STATE(512)] = 20864,
  [SMALL_STATE(513)] = 20887,
  [SMALL_STATE(514)] = 20910,
  [SMALL_STATE(515)] = 20933,
  [SMALL_STATE(516)] = 20956,
  [SMALL_STATE(517)] = 20979,
  [SMALL_STATE(518)] = 21002,
  [SMALL_STATE(519)] = 21025,
  [SMALL_STATE(520)] = 21048,
  [SMALL_STATE(521)] = 21071,
  [SMALL_STATE(522)] = 21094,
  [SMALL_STATE(523)] = 21117,
  [SMALL_STATE(524)] = 21140,
  [SMALL_STATE(525)] = 21163,
  [SMALL_STATE(526)] = 21188,
  [SMALL_STATE(527)] = 21202,
  [SMALL_STATE(528)] = 21222,
  [SMALL_STATE(529)] = 21238,
  [SMALL_STATE(530)] = 21254,
  [SMALL_STATE(531)] = 21274,
  [SMALL_STATE(532)] = 21294,
  [SMALL_STATE(533)] = 21314,
  [SMALL_STATE(534)] = 21334,
  [SMALL_STATE(535)] = 21354,
  [SMALL_STATE(536)] = 21374,
  [SMALL_STATE(537)] = 21394,
  [SMALL_STATE(538)] = 21410,
  [SMALL_STATE(539)] = 21430,
  [SMALL_STATE(540)] = 21442,
  [SMALL_STATE(541)] = 21454,
  [SMALL_STATE(542)] = 21474,
  [SMALL_STATE(543)] = 21490,
  [SMALL_STATE(544)] = 21504,
  [SMALL_STATE(545)] = 21524,
  [SMALL_STATE(546)] = 21544,
  [SMALL_STATE(547)] = 21564,
  [SMALL_STATE(548)] = 21584,
  [SMALL_STATE(549)] = 21598,
  [SMALL_STATE(550)] = 21618,
  [SMALL_STATE(551)] = 21634,
  [SMALL_STATE(552)] = 21654,
  [SMALL_STATE(553)] = 21674,
  [SMALL_STATE(554)] = 21694,
  [SMALL_STATE(555)] = 21706,
  [SMALL_STATE(556)] = 21720,
  [SMALL_STATE(557)] = 21740,
  [SMALL_STATE(558)] = 21760,
  [SMALL_STATE(559)] = 21780,
  [SMALL_STATE(560)] = 21800,
  [SMALL_STATE(561)] = 21810,
  [SMALL_STATE(562)] = 21830,
  [SMALL_STATE(563)] = 21850,
  [SMALL_STATE(564)] = 21866,
  [SMALL_STATE(565)] = 21886,
  [SMALL_STATE(566)] = 21906,
  [SMALL_STATE(567)] = 21926,
  [SMALL_STATE(568)] = 21946,
  [SMALL_STATE(569)] = 21962,
  [SMALL_STATE(570)] = 21982,
  [SMALL_STATE(571)] = 21996,
  [SMALL_STATE(572)] = 22016,
  [SMALL_STATE(573)] = 22036,
  [SMALL_STATE(574)] = 22050,
  [SMALL_STATE(575)] = 22070,
  [SMALL_STATE(576)] = 22090,
  [SMALL_STATE(577)] = 22110,
  [SMALL_STATE(578)] = 22130,
  [SMALL_STATE(579)] = 22150,
  [SMALL_STATE(580)] = 22164,
  [SMALL_STATE(581)] = 22180,
  [SMALL_STATE(582)] = 22196,
  [SMALL_STATE(583)] = 22210,
  [SMALL_STATE(584)] = 22230,
  [SMALL_STATE(585)] = 22250,
  [SMALL_STATE(586)] = 22270,
  [SMALL_STATE(587)] = 22290,
  [SMALL_STATE(588)] = 22307,
  [SMALL_STATE(589)] = 22324,
  [SMALL_STATE(590)] = 22343,
  [SMALL_STATE(591)] = 22360,
  [SMALL_STATE(592)] = 22377,
  [SMALL_STATE(593)] = 22390,
  [SMALL_STATE(594)] = 22407,
  [SMALL_STATE(595)] = 22424,
  [SMALL_STATE(596)] = 22441,
  [SMALL_STATE(597)] = 22454,
  [SMALL_STATE(598)] = 22471,
  [SMALL_STATE(599)] = 22488,
  [SMALL_STATE(600)] = 22505,
  [SMALL_STATE(601)] = 22522,
  [SMALL_STATE(602)] = 22539,
  [SMALL_STATE(603)] = 22552,
  [SMALL_STATE(604)] = 22569,
  [SMALL_STATE(605)] = 22586,
  [SMALL_STATE(606)] = 22603,
  [SMALL_STATE(607)] = 22620,
  [SMALL_STATE(608)] = 22637,
  [SMALL_STATE(609)] = 22654,
  [SMALL_STATE(610)] = 22667,
  [SMALL_STATE(611)] = 22684,
  [SMALL_STATE(612)] = 22701,
  [SMALL_STATE(613)] = 22714,
  [SMALL_STATE(614)] = 22731,
  [SMALL_STATE(615)] = 22748,
  [SMALL_STATE(616)] = 22765,
  [SMALL_STATE(617)] = 22774,
  [SMALL_STATE(618)] = 22787,
  [SMALL_STATE(619)] = 22804,
  [SMALL_STATE(620)] = 22821,
  [SMALL_STATE(621)] = 22838,
  [SMALL_STATE(622)] = 22855,
  [SMALL_STATE(623)] = 22866,
  [SMALL_STATE(624)] = 22883,
  [SMALL_STATE(625)] = 22896,
  [SMALL_STATE(626)] = 22911,
  [SMALL_STATE(627)] = 22928,
  [SMALL_STATE(628)] = 22945,
  [SMALL_STATE(629)] = 22958,
  [SMALL_STATE(630)] = 22973,
  [SMALL_STATE(631)] = 22987,
  [SMALL_STATE(632)] = 22997,
  [SMALL_STATE(633)] = 23005,
  [SMALL_STATE(634)] = 23015,
  [SMALL_STATE(635)] = 23023,
  [SMALL_STATE(636)] = 23035,
  [SMALL_STATE(637)] = 23047,
  [SMALL_STATE(638)] = 23055,
  [SMALL_STATE(639)] = 23063,
  [SMALL_STATE(640)] = 23071,
  [SMALL_STATE(641)] = 23083,
  [SMALL_STATE(642)] = 23097,
  [SMALL_STATE(643)] = 23111,
  [SMALL_STATE(644)] = 23119,
  [SMALL_STATE(645)] = 23127,
  [SMALL_STATE(646)] = 23137,
  [SMALL_STATE(647)] = 23149,
  [SMALL_STATE(648)] = 23163,
  [SMALL_STATE(649)] = 23171,
  [SMALL_STATE(650)] = 23179,
  [SMALL_STATE(651)] = 23187,
  [SMALL_STATE(652)] = 23195,
  [SMALL_STATE(653)] = 23203,
  [SMALL_STATE(654)] = 23211,
  [SMALL_STATE(655)] = 23225,
  [SMALL_STATE(656)] = 23234,
  [SMALL_STATE(657)] = 23243,
  [SMALL_STATE(658)] = 23256,
  [SMALL_STATE(659)] = 23265,
  [SMALL_STATE(660)] = 23274,
  [SMALL_STATE(661)] = 23287,
  [SMALL_STATE(662)] = 23300,
  [SMALL_STATE(663)] = 23313,
  [SMALL_STATE(664)] = 23326,
  [SMALL_STATE(665)] = 23335,
  [SMALL_STATE(666)] = 23348,
  [SMALL_STATE(667)] = 23361,
  [SMALL_STATE(668)] = 23374,
  [SMALL_STATE(669)] = 23383,
  [SMALL_STATE(670)] = 23392,
  [SMALL_STATE(671)] = 23401,
  [SMALL_STATE(672)] = 23410,
  [SMALL_STATE(673)] = 23423,
  [SMALL_STATE(674)] = 23436,
  [SMALL_STATE(675)] = 23449,
  [SMALL_STATE(676)] = 23458,
  [SMALL_STATE(677)] = 23471,
  [SMALL_STATE(678)] = 23484,
  [SMALL_STATE(679)] = 23497,
  [SMALL_STATE(680)] = 23506,
  [SMALL_STATE(681)] = 23519,
  [SMALL_STATE(682)] = 23528,
  [SMALL_STATE(683)] = 23537,
  [SMALL_STATE(684)] = 23546,
  [SMALL_STATE(685)] = 23555,
  [SMALL_STATE(686)] = 23564,
  [SMALL_STATE(687)] = 23577,
  [SMALL_STATE(688)] = 23586,
  [SMALL_STATE(689)] = 23599,
  [SMALL_STATE(690)] = 23612,
  [SMALL_STATE(691)] = 23621,
  [SMALL_STATE(692)] = 23630,
  [SMALL_STATE(693)] = 23639,
  [SMALL_STATE(694)] = 23648,
  [SMALL_STATE(695)] = 23657,
  [SMALL_STATE(696)] = 23666,
  [SMALL_STATE(697)] = 23675,
  [SMALL_STATE(698)] = 23684,
  [SMALL_STATE(699)] = 23693,
  [SMALL_STATE(700)] = 23706,
  [SMALL_STATE(701)] = 23719,
  [SMALL_STATE(702)] = 23730,
  [SMALL_STATE(703)] = 23739,
  [SMALL_STATE(704)] = 23752,
  [SMALL_STATE(705)] = 23765,
  [SMALL_STATE(706)] = 23774,
  [SMALL_STATE(707)] = 23787,
  [SMALL_STATE(708)] = 23796,
  [SMALL_STATE(709)] = 23805,
  [SMALL_STATE(710)] = 23814,
  [SMALL_STATE(711)] = 23823,
  [SMALL_STATE(712)] = 23832,
  [SMALL_STATE(713)] = 23845,
  [SMALL_STATE(714)] = 23858,
  [SMALL_STATE(715)] = 23871,
  [SMALL_STATE(716)] = 23884,
  [SMALL_STATE(717)] = 23893,
  [SMALL_STATE(718)] = 23902,
  [SMALL_STATE(719)] = 23912,
  [SMALL_STATE(720)] = 23922,
  [SMALL_STATE(721)] = 23932,
  [SMALL_STATE(722)] = 23942,
  [SMALL_STATE(723)] = 23952,
  [SMALL_STATE(724)] = 23962,
  [SMALL_STATE(725)] = 23972,
  [SMALL_STATE(726)] = 23980,
  [SMALL_STATE(727)] = 23990,
  [SMALL_STATE(728)] = 23998,
  [SMALL_STATE(729)] = 24008,
  [SMALL_STATE(730)] = 24018,
  [SMALL_STATE(731)] = 24028,
  [SMALL_STATE(732)] = 24036,
  [SMALL_STATE(733)] = 24044,
  [SMALL_STATE(734)] = 24052,
  [SMALL_STATE(735)] = 24062,
  [SMALL_STATE(736)] = 24072,
  [SMALL_STATE(737)] = 24082,
  [SMALL_STATE(738)] = 24092,
  [SMALL_STATE(739)] = 24102,
  [SMALL_STATE(740)] = 24112,
  [SMALL_STATE(741)] = 24120,
  [SMALL_STATE(742)] = 24130,
  [SMALL_STATE(743)] = 24138,
  [SMALL_STATE(744)] = 24148,
  [SMALL_STATE(745)] = 24156,
  [SMALL_STATE(746)] = 24166,
  [SMALL_STATE(747)] = 24176,
  [SMALL_STATE(748)] = 24186,
  [SMALL_STATE(749)] = 24196,
  [SMALL_STATE(750)] = 24206,
  [SMALL_STATE(751)] = 24212,
  [SMALL_STATE(752)] = 24222,
  [SMALL_STATE(753)] = 24232,
  [SMALL_STATE(754)] = 24242,
  [SMALL_STATE(755)] = 24252,
  [SMALL_STATE(756)] = 24262,
  [SMALL_STATE(757)] = 24272,
  [SMALL_STATE(758)] = 24282,
  [SMALL_STATE(759)] = 24292,
  [SMALL_STATE(760)] = 24302,
  [SMALL_STATE(761)] = 24312,
  [SMALL_STATE(762)] = 24322,
  [SMALL_STATE(763)] = 24332,
  [SMALL_STATE(764)] = 24342,
  [SMALL_STATE(765)] = 24352,
  [SMALL_STATE(766)] = 24362,
  [SMALL_STATE(767)] = 24372,
  [SMALL_STATE(768)] = 24382,
  [SMALL_STATE(769)] = 24392,
  [SMALL_STATE(770)] = 24402,
  [SMALL_STATE(771)] = 24412,
  [SMALL_STATE(772)] = 24418,
  [SMALL_STATE(773)] = 24428,
  [SMALL_STATE(774)] = 24438,
  [SMALL_STATE(775)] = 24448,
  [SMALL_STATE(776)] = 24458,
  [SMALL_STATE(777)] = 24468,
  [SMALL_STATE(778)] = 24478,
  [SMALL_STATE(779)] = 24488,
  [SMALL_STATE(780)] = 24498,
  [SMALL_STATE(781)] = 24508,
  [SMALL_STATE(782)] = 24518,
  [SMALL_STATE(783)] = 24528,
  [SMALL_STATE(784)] = 24538,
  [SMALL_STATE(785)] = 24548,
  [SMALL_STATE(786)] = 24558,
  [SMALL_STATE(787)] = 24568,
  [SMALL_STATE(788)] = 24576,
  [SMALL_STATE(789)] = 24586,
  [SMALL_STATE(790)] = 24596,
  [SMALL_STATE(791)] = 24606,
  [SMALL_STATE(792)] = 24616,
  [SMALL_STATE(793)] = 24626,
  [SMALL_STATE(794)] = 24636,
  [SMALL_STATE(795)] = 24646,
  [SMALL_STATE(796)] = 24656,
  [SMALL_STATE(797)] = 24666,
  [SMALL_STATE(798)] = 24676,
  [SMALL_STATE(799)] = 24686,
  [SMALL_STATE(800)] = 24696,
  [SMALL_STATE(801)] = 24706,
  [SMALL_STATE(802)] = 24716,
  [SMALL_STATE(803)] = 24726,
  [SMALL_STATE(804)] = 24736,
  [SMALL_STATE(805)] = 24746,
  [SMALL_STATE(806)] = 24756,
  [SMALL_STATE(807)] = 24766,
  [SMALL_STATE(808)] = 24776,
  [SMALL_STATE(809)] = 24786,
  [SMALL_STATE(810)] = 24796,
  [SMALL_STATE(811)] = 24806,
  [SMALL_STATE(812)] = 24813,
  [SMALL_STATE(813)] = 24820,
  [SMALL_STATE(814)] = 24827,
  [SMALL_STATE(815)] = 24834,
  [SMALL_STATE(816)] = 24841,
  [SMALL_STATE(817)] = 24848,
  [SMALL_STATE(818)] = 24855,
  [SMALL_STATE(819)] = 24862,
  [SMALL_STATE(820)] = 24869,
  [SMALL_STATE(821)] = 24876,
  [SMALL_STATE(822)] = 24883,
  [SMALL_STATE(823)] = 24890,
  [SMALL_STATE(824)] = 24897,
  [SMALL_STATE(825)] = 24904,
  [SMALL_STATE(826)] = 24911,
  [SMALL_STATE(827)] = 24918,
  [SMALL_STATE(828)] = 24925,
  [SMALL_STATE(829)] = 24932,
  [SMALL_STATE(830)] = 24939,
  [SMALL_STATE(831)] = 24946,
  [SMALL_STATE(832)] = 24953,
  [SMALL_STATE(833)] = 24960,
  [SMALL_STATE(834)] = 24967,
  [SMALL_STATE(835)] = 24974,
  [SMALL_STATE(836)] = 24981,
  [SMALL_STATE(837)] = 24988,
  [SMALL_STATE(838)] = 24995,
  [SMALL_STATE(839)] = 25002,
  [SMALL_STATE(840)] = 25009,
  [SMALL_STATE(841)] = 25016,
  [SMALL_STATE(842)] = 25023,
  [SMALL_STATE(843)] = 25030,
  [SMALL_STATE(844)] = 25037,
  [SMALL_STATE(845)] = 25044,
  [SMALL_STATE(846)] = 25051,
  [SMALL_STATE(847)] = 25058,
  [SMALL_STATE(848)] = 25063,
  [SMALL_STATE(849)] = 25070,
  [SMALL_STATE(850)] = 25075,
  [SMALL_STATE(851)] = 25082,
  [SMALL_STATE(852)] = 25089,
  [SMALL_STATE(853)] = 25094,
  [SMALL_STATE(854)] = 25101,
  [SMALL_STATE(855)] = 25108,
  [SMALL_STATE(856)] = 25115,
  [SMALL_STATE(857)] = 25122,
  [SMALL_STATE(858)] = 25129,
  [SMALL_STATE(859)] = 25136,
  [SMALL_STATE(860)] = 25143,
  [SMALL_STATE(861)] = 25150,
  [SMALL_STATE(862)] = 25157,
  [SMALL_STATE(863)] = 25164,
  [SMALL_STATE(864)] = 25169,
  [SMALL_STATE(865)] = 25176,
  [SMALL_STATE(866)] = 25183,
  [SMALL_STATE(867)] = 25190,
  [SMALL_STATE(868)] = 25197,
  [SMALL_STATE(869)] = 25204,
  [SMALL_STATE(870)] = 25211,
  [SMALL_STATE(871)] = 25218,
  [SMALL_STATE(872)] = 25225,
  [SMALL_STATE(873)] = 25232,
  [SMALL_STATE(874)] = 25239,
  [SMALL_STATE(875)] = 25246,
  [SMALL_STATE(876)] = 25253,
  [SMALL_STATE(877)] = 25260,
  [SMALL_STATE(878)] = 25267,
  [SMALL_STATE(879)] = 25274,
  [SMALL_STATE(880)] = 25281,
  [SMALL_STATE(881)] = 25288,
  [SMALL_STATE(882)] = 25293,
  [SMALL_STATE(883)] = 25300,
  [SMALL_STATE(884)] = 25307,
  [SMALL_STATE(885)] = 25314,
  [SMALL_STATE(886)] = 25321,
  [SMALL_STATE(887)] = 25326,
  [SMALL_STATE(888)] = 25333,
  [SMALL_STATE(889)] = 25340,
  [SMALL_STATE(890)] = 25347,
  [SMALL_STATE(891)] = 25354,
  [SMALL_STATE(892)] = 25361,
  [SMALL_STATE(893)] = 25368,
  [SMALL_STATE(894)] = 25375,
  [SMALL_STATE(895)] = 25382,
  [SMALL_STATE(896)] = 25386,
  [SMALL_STATE(897)] = 25390,
  [SMALL_STATE(898)] = 25394,
  [SMALL_STATE(899)] = 25398,
  [SMALL_STATE(900)] = 25402,
  [SMALL_STATE(901)] = 25406,
  [SMALL_STATE(902)] = 25410,
  [SMALL_STATE(903)] = 25414,
  [SMALL_STATE(904)] = 25418,
  [SMALL_STATE(905)] = 25422,
  [SMALL_STATE(906)] = 25426,
  [SMALL_STATE(907)] = 25430,
  [SMALL_STATE(908)] = 25434,
  [SMALL_STATE(909)] = 25438,
  [SMALL_STATE(910)] = 25442,
  [SMALL_STATE(911)] = 25446,
  [SMALL_STATE(912)] = 25450,
  [SMALL_STATE(913)] = 25454,
  [SMALL_STATE(914)] = 25458,
  [SMALL_STATE(915)] = 25462,
  [SMALL_STATE(916)] = 25466,
  [SMALL_STATE(917)] = 25470,
  [SMALL_STATE(918)] = 25474,
  [SMALL_STATE(919)] = 25478,
  [SMALL_STATE(920)] = 25482,
  [SMALL_STATE(921)] = 25486,
  [SMALL_STATE(922)] = 25490,
  [SMALL_STATE(923)] = 25494,
  [SMALL_STATE(924)] = 25498,
  [SMALL_STATE(925)] = 25502,
  [SMALL_STATE(926)] = 25506,
  [SMALL_STATE(927)] = 25510,
  [SMALL_STATE(928)] = 25514,
  [SMALL_STATE(929)] = 25518,
  [SMALL_STATE(930)] = 25522,
  [SMALL_STATE(931)] = 25526,
  [SMALL_STATE(932)] = 25530,
  [SMALL_STATE(933)] = 25534,
  [SMALL_STATE(934)] = 25538,
  [SMALL_STATE(935)] = 25542,
  [SMALL_STATE(936)] = 25546,
  [SMALL_STATE(937)] = 25550,
  [SMALL_STATE(938)] = 25554,
  [SMALL_STATE(939)] = 25558,
  [SMALL_STATE(940)] = 25562,
  [SMALL_STATE(941)] = 25566,
  [SMALL_STATE(942)] = 25570,
  [SMALL_STATE(943)] = 25574,
  [SMALL_STATE(944)] = 25578,
  [SMALL_STATE(945)] = 25582,
  [SMALL_STATE(946)] = 25586,
  [SMALL_STATE(947)] = 25590,
  [SMALL_STATE(948)] = 25594,
  [SMALL_STATE(949)] = 25598,
  [SMALL_STATE(950)] = 25602,
  [SMALL_STATE(951)] = 25606,
  [SMALL_STATE(952)] = 25610,
  [SMALL_STATE(953)] = 25614,
  [SMALL_STATE(954)] = 25618,
  [SMALL_STATE(955)] = 25622,
  [SMALL_STATE(956)] = 25626,
  [SMALL_STATE(957)] = 25630,
  [SMALL_STATE(958)] = 25634,
  [SMALL_STATE(959)] = 25638,
  [SMALL_STATE(960)] = 25642,
  [SMALL_STATE(961)] = 25646,
  [SMALL_STATE(962)] = 25650,
  [SMALL_STATE(963)] = 25654,
  [SMALL_STATE(964)] = 25658,
  [SMALL_STATE(965)] = 25662,
  [SMALL_STATE(966)] = 25666,
  [SMALL_STATE(967)] = 25670,
  [SMALL_STATE(968)] = 25674,
  [SMALL_STATE(969)] = 25678,
  [SMALL_STATE(970)] = 25682,
  [SMALL_STATE(971)] = 25686,
  [SMALL_STATE(972)] = 25690,
  [SMALL_STATE(973)] = 25694,
  [SMALL_STATE(974)] = 25698,
  [SMALL_STATE(975)] = 25702,
  [SMALL_STATE(976)] = 25706,
  [SMALL_STATE(977)] = 25710,
  [SMALL_STATE(978)] = 25714,
  [SMALL_STATE(979)] = 25718,
  [SMALL_STATE(980)] = 25722,
  [SMALL_STATE(981)] = 25726,
  [SMALL_STATE(982)] = 25730,
  [SMALL_STATE(983)] = 25734,
  [SMALL_STATE(984)] = 25738,
  [SMALL_STATE(985)] = 25742,
  [SMALL_STATE(986)] = 25746,
  [SMALL_STATE(987)] = 25750,
  [SMALL_STATE(988)] = 25754,
  [SMALL_STATE(989)] = 25758,
  [SMALL_STATE(990)] = 25762,
  [SMALL_STATE(991)] = 25766,
  [SMALL_STATE(992)] = 25770,
  [SMALL_STATE(993)] = 25774,
  [SMALL_STATE(994)] = 25778,
  [SMALL_STATE(995)] = 25782,
  [SMALL_STATE(996)] = 25786,
  [SMALL_STATE(997)] = 25790,
  [SMALL_STATE(998)] = 25794,
  [SMALL_STATE(999)] = 25798,
  [SMALL_STATE(1000)] = 25802,
  [SMALL_STATE(1001)] = 25806,
  [SMALL_STATE(1002)] = 25810,
  [SMALL_STATE(1003)] = 25814,
  [SMALL_STATE(1004)] = 25818,
  [SMALL_STATE(1005)] = 25822,
  [SMALL_STATE(1006)] = 25826,
  [SMALL_STATE(1007)] = 25830,
  [SMALL_STATE(1008)] = 25834,
  [SMALL_STATE(1009)] = 25838,
  [SMALL_STATE(1010)] = 25842,
  [SMALL_STATE(1011)] = 25846,
  [SMALL_STATE(1012)] = 25850,
  [SMALL_STATE(1013)] = 25854,
  [SMALL_STATE(1014)] = 25858,
  [SMALL_STATE(1015)] = 25862,
  [SMALL_STATE(1016)] = 25866,
  [SMALL_STATE(1017)] = 25870,
  [SMALL_STATE(1018)] = 25874,
  [SMALL_STATE(1019)] = 25878,
  [SMALL_STATE(1020)] = 25882,
  [SMALL_STATE(1021)] = 25886,
  [SMALL_STATE(1022)] = 25890,
  [SMALL_STATE(1023)] = 25894,
  [SMALL_STATE(1024)] = 25898,
  [SMALL_STATE(1025)] = 25902,
  [SMALL_STATE(1026)] = 25906,
  [SMALL_STATE(1027)] = 25910,
  [SMALL_STATE(1028)] = 25914,
  [SMALL_STATE(1029)] = 25918,
  [SMALL_STATE(1030)] = 25922,
  [SMALL_STATE(1031)] = 25926,
  [SMALL_STATE(1032)] = 25930,
  [SMALL_STATE(1033)] = 25934,
  [SMALL_STATE(1034)] = 25938,
  [SMALL_STATE(1035)] = 25942,
  [SMALL_STATE(1036)] = 25946,
  [SMALL_STATE(1037)] = 25950,
  [SMALL_STATE(1038)] = 25954,
  [SMALL_STATE(1039)] = 25958,
  [SMALL_STATE(1040)] = 25962,
  [SMALL_STATE(1041)] = 25966,
  [SMALL_STATE(1042)] = 25970,
  [SMALL_STATE(1043)] = 25974,
  [SMALL_STATE(1044)] = 25978,
  [SMALL_STATE(1045)] = 25982,
  [SMALL_STATE(1046)] = 25986,
  [SMALL_STATE(1047)] = 25990,
  [SMALL_STATE(1048)] = 25994,
  [SMALL_STATE(1049)] = 25998,
  [SMALL_STATE(1050)] = 26002,
  [SMALL_STATE(1051)] = 26006,
  [SMALL_STATE(1052)] = 26010,
  [SMALL_STATE(1053)] = 26014,
  [SMALL_STATE(1054)] = 26018,
  [SMALL_STATE(1055)] = 26022,
  [SMALL_STATE(1056)] = 26026,
  [SMALL_STATE(1057)] = 26030,
  [SMALL_STATE(1058)] = 26034,
  [SMALL_STATE(1059)] = 26038,
  [SMALL_STATE(1060)] = 26042,
  [SMALL_STATE(1061)] = 26046,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [5] = {.entry = {.count = 1, .reusable = false}}, SHIFT(487),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(575),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(757),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(888),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(921),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(764),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(963),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(965),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(662),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(878),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(887),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(920),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1058),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(813),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(813),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(929),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(760),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(761),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(924),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(769),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(769),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(434),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(434),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(910),
  [53] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_children, 2),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(499),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(574),
  [59] = {.entry = {.count = 1, .reusable = false}}, SHIFT(758),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(833),
  [63] = {.entry = {.count = 1, .reusable = false}}, SHIFT(931),
  [65] = {.entry = {.count = 1, .reusable = false}}, SHIFT(723),
  [67] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_children, 2),
  [69] = {.entry = {.count = 1, .reusable = false}}, SHIFT(686),
  [71] = {.entry = {.count = 1, .reusable = false}}, SHIFT(812),
  [73] = {.entry = {.count = 1, .reusable = false}}, SHIFT(867),
  [75] = {.entry = {.count = 1, .reusable = false}}, SHIFT(998),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(956),
  [79] = {.entry = {.count = 1, .reusable = false}}, SHIFT(832),
  [81] = {.entry = {.count = 1, .reusable = true}}, SHIFT(832),
  [83] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1036),
  [85] = {.entry = {.count = 1, .reusable = true}}, SHIFT(747),
  [87] = {.entry = {.count = 1, .reusable = true}}, SHIFT(748),
  [89] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1042),
  [91] = {.entry = {.count = 1, .reusable = false}}, SHIFT(756),
  [93] = {.entry = {.count = 1, .reusable = true}}, SHIFT(756),
  [95] = {.entry = {.count = 1, .reusable = false}}, SHIFT(427),
  [97] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [99] = {.entry = {.count = 1, .reusable = true}}, SHIFT(932),
  [101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [105] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2),
  [107] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(499),
  [110] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(574),
  [113] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(758),
  [116] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(833),
  [119] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(931),
  [122] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(723),
  [125] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2),
  [127] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(686),
  [130] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(812),
  [133] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(867),
  [136] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(998),
  [139] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(956),
  [142] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(832),
  [145] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(832),
  [148] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(1036),
  [151] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(747),
  [154] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(748),
  [157] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(1042),
  [160] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(756),
  [163] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(756),
  [166] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(427),
  [169] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(427),
  [172] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(932),
  [175] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(3),
  [178] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [180] = {.entry = {.count = 1, .reusable = false}}, SHIFT(489),
  [182] = {.entry = {.count = 1, .reusable = true}}, SHIFT(571),
  [184] = {.entry = {.count = 1, .reusable = false}}, SHIFT(802),
  [186] = {.entry = {.count = 1, .reusable = false}}, SHIFT(841),
  [188] = {.entry = {.count = 1, .reusable = false}}, SHIFT(912),
  [190] = {.entry = {.count = 1, .reusable = false}}, SHIFT(724),
  [192] = {.entry = {.count = 1, .reusable = false}}, SHIFT(680),
  [194] = {.entry = {.count = 1, .reusable = false}}, SHIFT(831),
  [196] = {.entry = {.count = 1, .reusable = false}}, SHIFT(830),
  [198] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1018),
  [200] = {.entry = {.count = 1, .reusable = true}}, SHIFT(968),
  [202] = {.entry = {.count = 1, .reusable = false}}, SHIFT(837),
  [204] = {.entry = {.count = 1, .reusable = true}}, SHIFT(837),
  [206] = {.entry = {.count = 1, .reusable = true}}, SHIFT(804),
  [208] = {.entry = {.count = 1, .reusable = true}}, SHIFT(803),
  [210] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1037),
  [212] = {.entry = {.count = 1, .reusable = false}}, SHIFT(765),
  [214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(765),
  [216] = {.entry = {.count = 1, .reusable = false}}, SHIFT(429),
  [218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(429),
  [220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(913),
  [222] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [224] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [226] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(489),
  [229] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(571),
  [232] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(802),
  [235] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(841),
  [238] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(912),
  [241] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(724),
  [244] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(680),
  [247] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(831),
  [250] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(830),
  [253] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(1018),
  [256] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(968),
  [259] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(837),
  [262] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(837),
  [265] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(804),
  [268] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(803),
  [271] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(1037),
  [274] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(765),
  [277] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(765),
  [280] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(429),
  [283] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(429),
  [286] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(913),
  [289] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(6),
  [292] = {.entry = {.count = 1, .reusable = true}}, SHIFT(325),
  [294] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [296] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(487),
  [299] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(575),
  [302] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(757),
  [305] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(888),
  [308] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(921),
  [311] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(764),
  [314] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(963),
  [317] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(965),
  [320] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(662),
  [323] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(878),
  [326] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(887),
  [329] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(920),
  [332] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(1058),
  [335] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(813),
  [338] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(813),
  [341] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(929),
  [344] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(760),
  [347] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(761),
  [350] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(924),
  [353] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(769),
  [356] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(769),
  [359] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(434),
  [362] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(434),
  [365] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(910),
  [368] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(478),
  [371] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(558),
  [374] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(794),
  [377] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(820),
  [380] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(967),
  [383] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(720),
  [386] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(666),
  [389] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(864),
  [392] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(862),
  [395] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(962),
  [398] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(986),
  [401] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(819),
  [404] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(819),
  [407] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(1041),
  [410] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(786),
  [413] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(782),
  [416] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(1050),
  [419] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(738),
  [422] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(738),
  [425] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(436),
  [428] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(436),
  [431] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(969),
  [434] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(9),
  [437] = {.entry = {.count = 1, .reusable = false}}, SHIFT(478),
  [439] = {.entry = {.count = 1, .reusable = true}}, SHIFT(558),
  [441] = {.entry = {.count = 1, .reusable = false}}, SHIFT(794),
  [443] = {.entry = {.count = 1, .reusable = false}}, SHIFT(820),
  [445] = {.entry = {.count = 1, .reusable = false}}, SHIFT(967),
  [447] = {.entry = {.count = 1, .reusable = false}}, SHIFT(720),
  [449] = {.entry = {.count = 1, .reusable = false}}, SHIFT(666),
  [451] = {.entry = {.count = 1, .reusable = false}}, SHIFT(864),
  [453] = {.entry = {.count = 1, .reusable = false}}, SHIFT(862),
  [455] = {.entry = {.count = 1, .reusable = false}}, SHIFT(962),
  [457] = {.entry = {.count = 1, .reusable = true}}, SHIFT(986),
  [459] = {.entry = {.count = 1, .reusable = false}}, SHIFT(819),
  [461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(819),
  [463] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1041),
  [465] = {.entry = {.count = 1, .reusable = true}}, SHIFT(786),
  [467] = {.entry = {.count = 1, .reusable = true}}, SHIFT(782),
  [469] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1050),
  [471] = {.entry = {.count = 1, .reusable = false}}, SHIFT(738),
  [473] = {.entry = {.count = 1, .reusable = true}}, SHIFT(738),
  [475] = {.entry = {.count = 1, .reusable = false}}, SHIFT(436),
  [477] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [479] = {.entry = {.count = 1, .reusable = true}}, SHIFT(969),
  [481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [483] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [485] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [487] = {.entry = {.count = 1, .reusable = false}}, SHIFT(507),
  [489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(562),
  [491] = {.entry = {.count = 1, .reusable = false}}, SHIFT(741),
  [493] = {.entry = {.count = 1, .reusable = false}}, SHIFT(827),
  [495] = {.entry = {.count = 1, .reusable = false}}, SHIFT(948),
  [497] = {.entry = {.count = 1, .reusable = false}}, SHIFT(721),
  [499] = {.entry = {.count = 1, .reusable = false}}, SHIFT(689),
  [501] = {.entry = {.count = 1, .reusable = false}}, SHIFT(855),
  [503] = {.entry = {.count = 1, .reusable = false}}, SHIFT(858),
  [505] = {.entry = {.count = 1, .reusable = false}}, SHIFT(960),
  [507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(936),
  [509] = {.entry = {.count = 1, .reusable = false}}, SHIFT(826),
  [511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(826),
  [513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(809),
  [515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(805),
  [517] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1046),
  [519] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1045),
  [521] = {.entry = {.count = 1, .reusable = false}}, SHIFT(749),
  [523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(749),
  [525] = {.entry = {.count = 1, .reusable = false}}, SHIFT(424),
  [527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(424),
  [529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(950),
  [531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [533] = {.entry = {.count = 1, .reusable = false}}, SHIFT(908),
  [535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [537] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1053),
  [539] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [541] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1055),
  [543] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [545] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1049),
  [547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [551] = {.entry = {.count = 1, .reusable = true}}, SHIFT(380),
  [553] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1057),
  [555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [557] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1040),
  [559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [561] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(507),
  [564] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(562),
  [567] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(741),
  [570] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(827),
  [573] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(948),
  [576] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(721),
  [579] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(689),
  [582] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(855),
  [585] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(858),
  [588] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(960),
  [591] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(936),
  [594] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(826),
  [597] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(826),
  [600] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(809),
  [603] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(805),
  [606] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(1046),
  [609] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(749),
  [612] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(749),
  [615] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(424),
  [618] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(424),
  [621] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(950),
  [624] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_children_repeat1, 2), SHIFT_REPEAT(37),
  [627] = {.entry = {.count = 1, .reusable = true}}, SHIFT(643),
  [629] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_filter, 2),
  [631] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_filter, 2),
  [633] = {.entry = {.count = 1, .reusable = false}}, SHIFT(453),
  [635] = {.entry = {.count = 1, .reusable = false}}, SHIFT(956),
  [637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(917),
  [639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(954),
  [641] = {.entry = {.count = 1, .reusable = false}}, SHIFT(444),
  [643] = {.entry = {.count = 1, .reusable = false}}, SHIFT(968),
  [645] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1060),
  [647] = {.entry = {.count = 1, .reusable = true}}, SHIFT(935),
  [649] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_case_repeat1, 2),
  [651] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_case_repeat1, 2),
  [653] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_case_repeat1, 2), SHIFT_REPEAT(944),
  [656] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_case_repeat1, 2), SHIFT_REPEAT(773),
  [659] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case, 5, .production_id = 8),
  [661] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_case, 5, .production_id = 8),
  [663] = {.entry = {.count = 1, .reusable = false}}, SHIFT(944),
  [665] = {.entry = {.count = 1, .reusable = false}}, SHIFT(773),
  [667] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_filter, 3),
  [669] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_filter, 3),
  [671] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_when, 2),
  [673] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_when, 2),
  [675] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [677] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__un_delimited_javascript_multiline, 2),
  [679] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__un_delimited_javascript_multiline, 2),
  [681] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__un_delimited_javascript_multiline, 2), SHIFT_REPEAT(82),
  [684] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tag, 6),
  [686] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tag, 6),
  [688] = {.entry = {.count = 1, .reusable = false}}, SHIFT(446),
  [690] = {.entry = {.count = 1, .reusable = false}}, SHIFT(986),
  [692] = {.entry = {.count = 1, .reusable = true}}, SHIFT(964),
  [694] = {.entry = {.count = 1, .reusable = true}}, SHIFT(987),
  [696] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tag, 7),
  [698] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tag, 7),
  [700] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tag, 5),
  [702] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tag, 5),
  [704] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [706] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tag, 4),
  [708] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tag, 4),
  [710] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__multi_line_buf_code, 1, .production_id = 2),
  [712] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__multi_line_buf_code, 1, .production_id = 2),
  [714] = {.entry = {.count = 1, .reusable = false}}, SHIFT(82),
  [716] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [718] = {.entry = {.count = 1, .reusable = false}}, SHIFT(454),
  [720] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1058),
  [722] = {.entry = {.count = 1, .reusable = true}}, SHIFT(949),
  [724] = {.entry = {.count = 1, .reusable = true}}, SHIFT(953),
  [726] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tag, 3),
  [728] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tag, 3),
  [730] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [732] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tag, 2),
  [734] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tag, 2),
  [736] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [738] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [740] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [742] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [744] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attributes, 2),
  [746] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attributes, 2),
  [748] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [750] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_case_repeat1, 2), SHIFT_REPEAT(751),
  [753] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attributes, 3),
  [755] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attributes, 3),
  [757] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [759] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__single_line_buf_code, 2),
  [761] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__single_line_buf_code, 2),
  [763] = {.entry = {.count = 1, .reusable = true}}, SHIFT(592),
  [765] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [767] = {.entry = {.count = 1, .reusable = false}}, SHIFT(751),
  [769] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_each, 6),
  [771] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_each, 6),
  [773] = {.entry = {.count = 1, .reusable = false}}, SHIFT(947),
  [775] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__un_delimited_javascript_multiline, 1),
  [777] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__un_delimited_javascript_multiline, 1),
  [779] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__comment, 3),
  [781] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__comment, 3),
  [783] = {.entry = {.count = 1, .reusable = true}}, SHIFT(753),
  [785] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attributes, 4),
  [787] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attributes, 4),
  [789] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tag, 8),
  [791] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tag, 8),
  [793] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_children, 3),
  [795] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_children, 3),
  [797] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unbuffered_code, 6),
  [799] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unbuffered_code, 6),
  [801] = {.entry = {.count = 1, .reusable = false}}, SHIFT(186),
  [803] = {.entry = {.count = 1, .reusable = true}}, SHIFT(612),
  [805] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_each, 7),
  [807] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_each, 7),
  [809] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [811] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [813] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__each_else, 3),
  [815] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__each_else, 3),
  [817] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [819] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__content_after_dot, 7, .production_id = 13),
  [821] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__content_after_dot, 7, .production_id = 13),
  [823] = {.entry = {.count = 1, .reusable = false}}, SHIFT(729),
  [825] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unescaped_buffered_code, 2),
  [827] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unescaped_buffered_code, 2),
  [829] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__content_after_dot, 5, .production_id = 12),
  [831] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__content_after_dot, 5, .production_id = 12),
  [833] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [835] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__single_line_buf_code, 5),
  [837] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__single_line_buf_code, 5),
  [839] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_buffered_code, 2),
  [841] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_buffered_code, 2),
  [843] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [845] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__comment_not_first_line, 5),
  [847] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__comment_not_first_line, 5),
  [849] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_case_repeat1, 2), SHIFT_REPEAT(729),
  [852] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__un_delimited_javascript_multiline, 2), SHIFT_REPEAT(186),
  [855] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__when_content, 2),
  [857] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__when_content, 2),
  [859] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_filter_content, 1),
  [861] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_filter_content, 1),
  [863] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unbuffered_code, 5),
  [865] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unbuffered_code, 5),
  [867] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [869] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__dummy_tag, 1),
  [871] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__dummy_tag, 1),
  [873] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_script_block, 5, .production_id = 9),
  [875] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_script_block, 5, .production_id = 9),
  [877] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 1),
  [879] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_comment, 1),
  [881] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_doctype, 2),
  [883] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_doctype, 2),
  [885] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pipe, 2),
  [887] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pipe, 2),
  [889] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_include, 2, .production_id = 1),
  [891] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_include, 2, .production_id = 1),
  [893] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__block_content, 1, .production_id = 4),
  [895] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__block_content, 1, .production_id = 4),
  [897] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_definition, 2),
  [899] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_definition, 2),
  [901] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_append, 2),
  [903] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_append, 2),
  [905] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_prepend, 2),
  [907] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_prepend, 2),
  [909] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_extends, 2, .production_id = 1),
  [911] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_extends, 2, .production_id = 1),
  [913] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__comment, 6),
  [915] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__comment, 6),
  [917] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_filter_content, 2),
  [919] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_filter_content, 2),
  [921] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_filter, 4),
  [923] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_filter, 4),
  [925] = {.entry = {.count = 1, .reusable = false}}, SHIFT(442),
  [927] = {.entry = {.count = 1, .reusable = false}}, SHIFT(936),
  [929] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1019),
  [931] = {.entry = {.count = 1, .reusable = true}}, SHIFT(973),
  [933] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pipe, 3),
  [935] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pipe, 3),
  [937] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_include, 3, .production_id = 5),
  [939] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_include, 3, .production_id = 5),
  [941] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_conditional, 3),
  [943] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_conditional, 3),
  [945] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_append, 3),
  [947] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_append, 3),
  [949] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_prepend, 3),
  [951] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_prepend, 3),
  [953] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unbuffered_code, 3),
  [955] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unbuffered_code, 3),
  [957] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [959] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while, 4),
  [961] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while, 4),
  [963] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_filter_content, 4),
  [965] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_filter_content, 4),
  [967] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_filter_content, 3),
  [969] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_filter_content, 3),
  [971] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__block_content, 3, .production_id = 4),
  [973] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__block_content, 3, .production_id = 4),
  [975] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_conditional, 4),
  [977] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_conditional, 4),
  [979] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unbuffered_code, 4),
  [981] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unbuffered_code, 4),
  [983] = {.entry = {.count = 1, .reusable = false}}, SHIFT(229),
  [985] = {.entry = {.count = 1, .reusable = false}}, SHIFT(188),
  [987] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [989] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [991] = {.entry = {.count = 1, .reusable = true}}, SHIFT(602),
  [993] = {.entry = {.count = 1, .reusable = false}}, SHIFT(928),
  [995] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [997] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__un_delimited_javascript_multiline, 2), SHIFT_REPEAT(188),
  [1000] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [1002] = {.entry = {.count = 1, .reusable = true}}, SHIFT(759),
  [1004] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__un_delimited_javascript_multiline, 2), SHIFT_REPEAT(229),
  [