#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 705
#define LARGE_STATE_COUNT 126
#define SYMBOL_COUNT 264
#define ALIAS_COUNT 0
#define TOKEN_COUNT 138
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 10
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 12

enum ts_symbol_identifiers {
  sym_keyword = 1,
  sym_name = 2,
  sym_identifier = 3,
  sym_comment = 4,
  anon_sym_const = 5,
  anon_sym_BANG = 6,
  anon_sym_rune = 7,
  anon_sym_bool = 8,
  anon_sym_valist = 9,
  anon_sym_void = 10,
  anon_sym_opaque = 11,
  anon_sym_done = 12,
  anon_sym_never = 13,
  anon_sym_i8 = 14,
  anon_sym_i16 = 15,
  anon_sym_i32 = 16,
  anon_sym_i64 = 17,
  anon_sym_u8 = 18,
  anon_sym_u16 = 19,
  anon_sym_u32 = 20,
  anon_sym_u64 = 21,
  anon_sym_int = 22,
  anon_sym_uint = 23,
  anon_sym_size = 24,
  anon_sym_uintptr = 25,
  anon_sym_f32 = 26,
  anon_sym_f64 = 27,
  anon_sym_STAR = 28,
  anon_sym_nullable = 29,
  anon_sym_struct = 30,
  anon_sym_ATpacked = 31,
  anon_sym_LBRACE = 32,
  anon_sym_RBRACE = 33,
  anon_sym_union = 34,
  anon_sym_COMMA = 35,
  anon_sym_COLON = 36,
  anon_sym_AToffset = 37,
  anon_sym_LPAREN = 38,
  anon_sym_RPAREN = 39,
  anon_sym_PIPE = 40,
  anon_sym_LBRACK = 41,
  anon_sym_RBRACK = 42,
  anon_sym__ = 43,
  sym__string_type = 44,
  anon_sym_fn = 45,
  anon_sym_DOT_DOT_DOT = 46,
  anon_sym_EQ = 47,
  anon_sym_true = 48,
  anon_sym_false = 49,
  anon_sym_null = 50,
  sym_floating_literal = 51,
  sym_integer_literal = 52,
  anon_sym_SQUOTE = 53,
  aux_sym_rune_literal_token1 = 54,
  anon_sym_SQUOTE2 = 55,
  sym_escape_sequence = 56,
  aux_sym_string_literal_token1 = 57,
  anon_sym_DQUOTE = 58,
  aux_sym_string_literal_token2 = 59,
  anon_sym_DQUOTE2 = 60,
  anon_sym_alloc = 61,
  anon_sym_free = 62,
  anon_sym_static = 63,
  anon_sym_assert = 64,
  anon_sym_abort = 65,
  anon_sym_align = 66,
  anon_sym_len = 67,
  anon_sym_offset = 68,
  anon_sym_DOT = 69,
  anon_sym_DOT_DOT = 70,
  anon_sym_append = 71,
  anon_sym_insert = 72,
  anon_sym_delete = 73,
  anon_sym_QMARK = 74,
  anon_sym_vastart = 75,
  anon_sym_vaarg = 76,
  anon_sym_vaend = 77,
  anon_sym_PLUS = 78,
  anon_sym_DASH = 79,
  anon_sym_TILDE = 80,
  anon_sym_AMP = 81,
  anon_sym_as = 82,
  anon_sym_is = 83,
  anon_sym_SLASH = 84,
  anon_sym_PERCENT = 85,
  anon_sym_LT_LT = 86,
  anon_sym_GT_GT = 87,
  anon_sym_CARET = 88,
  anon_sym_LT = 89,
  anon_sym_GT = 90,
  anon_sym_LT_EQ = 91,
  anon_sym_GT_EQ = 92,
  anon_sym_EQ_EQ = 93,
  anon_sym_BANG_EQ = 94,
  anon_sym_AMP_AMP = 95,
  anon_sym_CARET_CARET = 96,
  anon_sym_PIPE_PIPE = 97,
  anon_sym_if = 98,
  anon_sym_else = 99,
  anon_sym_for = 100,
  anon_sym_SEMI = 101,
  anon_sym_let = 102,
  anon_sym_AMP_DOT_DOT = 103,
  anon_sym_EQ_GT = 104,
  anon_sym_switch = 105,
  anon_sym_case = 106,
  anon_sym_match = 107,
  anon_sym_PLUS_EQ = 108,
  anon_sym_DASH_EQ = 109,
  anon_sym_STAR_EQ = 110,
  anon_sym_SLASH_EQ = 111,
  anon_sym_PERCENT_EQ = 112,
  anon_sym_LT_LT_EQ = 113,
  anon_sym_GT_GT_EQ = 114,
  anon_sym_AMP_EQ = 115,
  anon_sym_PIPE_EQ = 116,
  anon_sym_CARET_EQ = 117,
  anon_sym_AMP_AMP_EQ = 118,
  anon_sym_PIPE_PIPE_EQ = 119,
  anon_sym_CARET_CARET_EQ = 120,
  anon_sym_def = 121,
  anon_sym_defer = 122,
  anon_sym_break = 123,
  anon_sym_continue = 124,
  anon_sym_return = 125,
  anon_sym_yield = 126,
  anon_sym_COMMA2 = 127,
  anon_sym_export = 128,
  anon_sym_ATthreadlocal = 129,
  anon_sym_ATsymbol = 130,
  anon_sym_type = 131,
  anon_sym_enum = 132,
  anon_sym_ATfini = 133,
  anon_sym_ATinit = 134,
  anon_sym_ATtest = 135,
  anon_sym_use = 136,
  anon_sym_COLON_COLON = 137,
  sym_sub_unit = 138,
  sym_type = 139,
  sym__storage_class = 140,
  sym__primitive_type = 141,
  sym__integer_type = 142,
  sym__floating_type = 143,
  sym_pointer_type = 144,
  sym_struct_union_type = 145,
  sym_struct_union_fields = 146,
  sym_struct_union_field = 147,
  sym_struct_fields = 148,
  sym_struct_field = 149,
  sym_offset_specifier = 150,
  sym_tuple_type = 151,
  sym_tagged_union_type = 152,
  sym_slice_array_type = 153,
  sym_function_type = 154,
  sym__prototype = 155,
  sym_parameter = 156,
  sym_alias_type = 157,
  sym_unwrapped_alias = 158,
  sym_literal = 159,
  sym_rune_literal = 160,
  sym_string_literal = 161,
  sym_array_literal = 162,
  sym_struct_literal = 163,
  sym_field_value = 164,
  sym_tuple_literal = 165,
  sym__plain_expression = 166,
  sym_nested_expression = 167,
  sym_allocation_expression = 168,
  sym_assertion_expression = 169,
  sym_call_expression = 170,
  sym_argument_list = 171,
  sym_measurement_expression = 172,
  sym_align_expression = 173,
  sym_size_expression = 174,
  sym_length_expression = 175,
  sym_offset_expression = 176,
  sym_field_access_expression = 177,
  sym_indexing_expression = 178,
  sym_slicing_expression = 179,
  sym_slice_mutation_expression = 180,
  sym_append_expression = 181,
  sym_insert_expression = 182,
  sym_delete_expression = 183,
  sym_error_propagation = 184,
  sym_postfix_expression = 185,
  sym_variadic_expression = 186,
  sym_builtin_expression = 187,
  sym_unary_expression = 188,
  sym_cast_expression = 189,
  sym_nullable_type = 190,
  sym_multiplicative_expression = 191,
  sym_additive_expression = 192,
  sym_shift_expression = 193,
  sym_and_expression = 194,
  sym_exclusive_or_expression = 195,
  sym_inclusive_or_expression = 196,
  sym_comparison_expression = 197,
  sym_equality_expression = 198,
  sym_logical_and_expression = 199,
  sym_logical_xor_expression = 200,
  sym_logical_or_expression = 201,
  sym_if_expression = 202,
  sym_conditional_branch = 203,
  sym_for_loop = 204,
  sym_for_predicate = 205,
  sym_iterable_binding = 206,
  sym_switch_expression = 207,
  sym_switch_cases = 208,
  sym_switch_case = 209,
  sym_case_options = 210,
  sym_match_expression = 211,
  sym_match_cases = 212,
  sym_match_case = 213,
  sym_assignment = 214,
  sym_assignment_op = 215,
  sym_binding_list = 216,
  sym_bindings = 217,
  sym_binding = 218,
  sym_binding_name = 219,
  sym_tuple_binding_names = 220,
  sym_tuple_binding_name = 221,
  sym_defer_expression = 222,
  sym_expression_list = 223,
  sym_compound_expression = 224,
  sym_label = 225,
  sym_control_expression = 226,
  sym_expression = 227,
  sym_declarations = 228,
  sym_declaration = 229,
  sym_global_declaration = 230,
  sym_global_bindings = 231,
  sym_global_binding = 232,
  sym_decl_attr = 233,
  sym_constant_declaration = 234,
  sym_constant_bindings = 235,
  sym_constant_binding = 236,
  sym_type_declaration = 237,
  sym_type_bindings = 238,
  sym_type_binding = 239,
  sym_enum_type = 240,
  sym_enum_values = 241,
  sym_enum_value = 242,
  sym_enum_storage = 243,
  sym_function_declaration = 244,
  sym_fndec_attrs = 245,
  sym_fndec_attr = 246,
  sym_imports = 247,
  sym_use_directive = 248,
  sym_member_list = 249,
  sym_member = 250,
  aux_sym_struct_union_fields_repeat1 = 251,
  aux_sym_struct_fields_repeat1 = 252,
  aux_sym_tuple_type_repeat1 = 253,
  aux_sym_tagged_union_type_repeat1 = 254,
  aux_sym__prototype_repeat1 = 255,
  aux_sym_string_literal_repeat1 = 256,
  aux_sym_array_literal_repeat1 = 257,
  aux_sym_struct_literal_repeat1 = 258,
  aux_sym_switch_cases_repeat1 = 259,
  aux_sym_match_cases_repeat1 = 260,
  aux_sym_declarations_repeat1 = 261,
  aux_sym_fndec_attrs_repeat1 = 262,
  aux_sym_imports_repeat1 = 263,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_keyword] = "keyword",
  [sym_name] = "name",
  [sym_identifier] = "identifier",
  [sym_comment] = "comment",
  [anon_sym_const] = "const",
  [anon_sym_BANG] = "!",
  [anon_sym_rune] = "rune",
  [anon_sym_bool] = "bool",
  [anon_sym_valist] = "valist",
  [anon_sym_void] = "void",
  [anon_sym_opaque] = "opaque",
  [anon_sym_done] = "done",
  [anon_sym_never] = "never",
  [anon_sym_i8] = "i8",
  [anon_sym_i16] = "i16",
  [anon_sym_i32] = "i32",
  [anon_sym_i64] = "i64",
  [anon_sym_u8] = "u8",
  [anon_sym_u16] = "u16",
  [anon_sym_u32] = "u32",
  [anon_sym_u64] = "u64",
  [anon_sym_int] = "int",
  [anon_sym_uint] = "uint",
  [anon_sym_size] = "size",
  [anon_sym_uintptr] = "uintptr",
  [anon_sym_f32] = "f32",
  [anon_sym_f64] = "f64",
  [anon_sym_STAR] = "*",
  [anon_sym_nullable] = "nullable",
  [anon_sym_struct] = "struct",
  [anon_sym_ATpacked] = "@packed",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_union] = "union",
  [anon_sym_COMMA] = ",",
  [anon_sym_COLON] = ":",
  [anon_sym_AToffset] = "@offset",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_PIPE] = "|",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym__] = "_",
  [sym__string_type] = "_string_type",
  [anon_sym_fn] = "fn",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_EQ] = "=",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_null] = "null",
  [sym_floating_literal] = "floating_literal",
  [sym_integer_literal] = "integer_literal",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_rune_literal_token1] = "rune_literal_token1",
  [anon_sym_SQUOTE2] = "'",
  [sym_escape_sequence] = "escape_sequence",
  [aux_sym_string_literal_token1] = "string_literal_token1",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_literal_token2] = "string_literal_token2",
  [anon_sym_DQUOTE2] = "\"",
  [anon_sym_alloc] = "alloc",
  [anon_sym_free] = "free",
  [anon_sym_static] = "static",
  [anon_sym_assert] = "assert",
  [anon_sym_abort] = "abort",
  [anon_sym_align] = "align",
  [anon_sym_len] = "len",
  [anon_sym_offset] = "offset",
  [anon_sym_DOT] = ".",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_append] = "append",
  [anon_sym_insert] = "insert",
  [anon_sym_delete] = "delete",
  [anon_sym_QMARK] = "\?",
  [anon_sym_vastart] = "vastart",
  [anon_sym_vaarg] = "vaarg",
  [anon_sym_vaend] = "vaend",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_TILDE] = "~",
  [anon_sym_AMP] = "&",
  [anon_sym_as] = "as",
  [anon_sym_is] = "is",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_CARET] = "^",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_CARET_CARET] = "^^",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_for] = "for",
  [anon_sym_SEMI] = ";",
  [anon_sym_let] = "let",
  [anon_sym_AMP_DOT_DOT] = "&..",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_switch] = "switch",
  [anon_sym_case] = "case",
  [anon_sym_match] = "match",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_AMP_AMP_EQ] = "&&=",
  [anon_sym_PIPE_PIPE_EQ] = "||=",
  [anon_sym_CARET_CARET_EQ] = "^^=",
  [anon_sym_def] = "def",
  [anon_sym_defer] = "defer",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_return] = "return",
  [anon_sym_yield] = "yield",
  [anon_sym_COMMA2] = ", ",
  [anon_sym_export] = "export",
  [anon_sym_ATthreadlocal] = "@threadlocal",
  [anon_sym_ATsymbol] = "@symbol",
  [anon_sym_type] = "type",
  [anon_sym_enum] = "enum",
  [anon_sym_ATfini] = "@fini",
  [anon_sym_ATinit] = "@init",
  [anon_sym_ATtest] = "@test",
  [anon_sym_use] = "use",
  [anon_sym_COLON_COLON] = "::",
  [sym_sub_unit] = "sub_unit",
  [sym_type] = "type",
  [sym__storage_class] = "_storage_class",
  [sym__primitive_type] = "_primitive_type",
  [sym__integer_type] = "_integer_type",
  [sym__floating_type] = "_floating_type",
  [sym_pointer_type] = "pointer_type",
  [sym_struct_union_type] = "struct_union_type",
  [sym_struct_union_fields] = "struct_union_fields",
  [sym_struct_union_field] = "struct_union_field",
  [sym_struct_fields] = "struct_fields",
  [sym_struct_field] = "struct_field",
  [sym_offset_specifier] = "offset_specifier",
  [sym_tuple_type] = "tuple_type",
  [sym_tagged_union_type] = "tagged_union_type",
  [sym_slice_array_type] = "slice_array_type",
  [sym_function_type] = "function_type",
  [sym__prototype] = "_prototype",
  [sym_parameter] = "parameter",
  [sym_alias_type] = "alias_type",
  [sym_unwrapped_alias] = "unwrapped_alias",
  [sym_literal] = "literal",
  [sym_rune_literal] = "rune_literal",
  [sym_string_literal] = "string_literal",
  [sym_array_literal] = "array_literal",
  [sym_struct_literal] = "struct_literal",
  [sym_field_value] = "field_value",
  [sym_tuple_literal] = "tuple_literal",
  [sym__plain_expression] = "_plain_expression",
  [sym_nested_expression] = "nested_expression",
  [sym_allocation_expression] = "allocation_expression",
  [sym_assertion_expression] = "assertion_expression",
  [sym_call_expression] = "call_expression",
  [sym_argument_list] = "argument_list",
  [sym_measurement_expression] = "measurement_expression",
  [sym_align_expression] = "align_expression",
  [sym_size_expression] = "size_expression",
  [sym_length_expression] = "length_expression",
  [sym_offset_expression] = "offset_expression",
  [sym_field_access_expression] = "field_access_expression",
  [sym_indexing_expression] = "indexing_expression",
  [sym_slicing_expression] = "slicing_expression",
  [sym_slice_mutation_expression] = "slice_mutation_expression",
  [sym_append_expression] = "append_expression",
  [sym_insert_expression] = "insert_expression",
  [sym_delete_expression] = "delete_expression",
  [sym_error_propagation] = "error_propagation",
  [sym_postfix_expression] = "postfix_expression",
  [sym_variadic_expression] = "variadic_expression",
  [sym_builtin_expression] = "builtin_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_cast_expression] = "cast_expression",
  [sym_nullable_type] = "nullable_type",
  [sym_multiplicative_expression] = "multiplicative_expression",
  [sym_additive_expression] = "additive_expression",
  [sym_shift_expression] = "shift_expression",
  [sym_and_expression] = "and_expression",
  [sym_exclusive_or_expression] = "exclusive_or_expression",
  [sym_inclusive_or_expression] = "inclusive_or_expression",
  [sym_comparison_expression] = "comparison_expression",
  [sym_equality_expression] = "equality_expression",
  [sym_logical_and_expression] = "logical_and_expression",
  [sym_logical_xor_expression] = "logical_xor_expression",
  [sym_logical_or_expression] = "logical_or_expression",
  [sym_if_expression] = "if_expression",
  [sym_conditional_branch] = "conditional_branch",
  [sym_for_loop] = "for_loop",
  [sym_for_predicate] = "for_predicate",
  [sym_iterable_binding] = "iterable_binding",
  [sym_switch_expression] = "switch_expression",
  [sym_switch_cases] = "switch_cases",
  [sym_switch_case] = "switch_case",
  [sym_case_options] = "case_options",
  [sym_match_expression] = "match_expression",
  [sym_match_cases] = "match_cases",
  [sym_match_case] = "match_case",
  [sym_assignment] = "assignment",
  [sym_assignment_op] = "assignment_op",
  [sym_binding_list] = "binding_list",
  [sym_bindings] = "bindings",
  [sym_binding] = "binding",
  [sym_binding_name] = "binding_name",
  [sym_tuple_binding_names] = "tuple_binding_names",
  [sym_tuple_binding_name] = "tuple_binding_name",
  [sym_defer_expression] = "defer_expression",
  [sym_expression_list] = "expression_list",
  [sym_compound_expression] = "compound_expression",
  [sym_label] = "label",
  [sym_control_expression] = "control_expression",
  [sym_expression] = "expression",
  [sym_declarations] = "declarations",
  [sym_declaration] = "declaration",
  [sym_global_declaration] = "global_declaration",
  [sym_global_bindings] = "global_bindings",
  [sym_global_binding] = "global_binding",
  [sym_decl_attr] = "decl_attr",
  [sym_constant_declaration] = "constant_declaration",
  [sym_constant_bindings] = "constant_bindings",
  [sym_constant_binding] = "constant_binding",
  [sym_type_declaration] = "type_declaration",
  [sym_type_bindings] = "type_bindings",
  [sym_type_binding] = "type_binding",
  [sym_enum_type] = "enum_type",
  [sym_enum_values] = "enum_values",
  [sym_enum_value] = "enum_value",
  [sym_enum_storage] = "enum_storage",
  [sym_function_declaration] = "function_declaration",
  [sym_fndec_attrs] = "fndec_attrs",
  [sym_fndec_attr] = "fndec_attr",
  [sym_imports] = "imports",
  [sym_use_directive] = "use_directive",
  [sym_member_list] = "member_list",
  [sym_member] = "member",
  [aux_sym_struct_union_fields_repeat1] = "struct_union_fields_repeat1",
  [aux_sym_struct_fields_repeat1] = "struct_fields_repeat1",
  [aux_sym_tuple_type_repeat1] = "tuple_type_repeat1",
  [aux_sym_tagged_union_type_repeat1] = "tagged_union_type_repeat1",
  [aux_sym__prototype_repeat1] = "_prototype_repeat1",
  [aux_sym_string_literal_repeat1] = "string_literal_repeat1",
  [aux_sym_array_literal_repeat1] = "array_literal_repeat1",
  [aux_sym_struct_literal_repeat1] = "struct_literal_repeat1",
  [aux_sym_switch_cases_repeat1] = "switch_cases_repeat1",
  [aux_sym_match_cases_repeat1] = "match_cases_repeat1",
  [aux_sym_declarations_repeat1] = "declarations_repeat1",
  [aux_sym_fndec_attrs_repeat1] = "fndec_attrs_repeat1",
  [aux_sym_imports_repeat1] = "imports_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_keyword] = sym_keyword,
  [sym_name] = sym_name,
  [sym_identifier] = sym_identifier,
  [sym_comment] = sym_comment,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_rune] = anon_sym_rune,
  [anon_sym_bool] = anon_sym_bool,
  [anon_sym_valist] = anon_sym_valist,
  [anon_sym_void] = anon_sym_void,
  [anon_sym_opaque] = anon_sym_opaque,
  [anon_sym_done] = anon_sym_done,
  [anon_sym_never] = anon_sym_never,
  [anon_sym_i8] = anon_sym_i8,
  [anon_sym_i16] = anon_sym_i16,
  [anon_sym_i32] = anon_sym_i32,
  [anon_sym_i64] = anon_sym_i64,
  [anon_sym_u8] = anon_sym_u8,
  [anon_sym_u16] = anon_sym_u16,
  [anon_sym_u32] = anon_sym_u32,
  [anon_sym_u64] = anon_sym_u64,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_uint] = anon_sym_uint,
  [anon_sym_size] = anon_sym_size,
  [anon_sym_uintptr] = anon_sym_uintptr,
  [anon_sym_f32] = anon_sym_f32,
  [anon_sym_f64] = anon_sym_f64,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_nullable] = anon_sym_nullable,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_ATpacked] = anon_sym_ATpacked,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_union] = anon_sym_union,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_AToffset] = anon_sym_AToffset,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym__] = anon_sym__,
  [sym__string_type] = sym__string_type,
  [anon_sym_fn] = anon_sym_fn,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_null] = anon_sym_null,
  [sym_floating_literal] = sym_floating_literal,
  [sym_integer_literal] = sym_integer_literal,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_rune_literal_token1] = aux_sym_rune_literal_token1,
  [anon_sym_SQUOTE2] = anon_sym_SQUOTE,
  [sym_escape_sequence] = sym_escape_sequence,
  [aux_sym_string_literal_token1] = aux_sym_string_literal_token1,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_literal_token2] = aux_sym_string_literal_token2,
  [anon_sym_DQUOTE2] = anon_sym_DQUOTE,
  [anon_sym_alloc] = anon_sym_alloc,
  [anon_sym_free] = anon_sym_free,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_abort] = anon_sym_abort,
  [anon_sym_align] = anon_sym_align,
  [anon_sym_len] = anon_sym_len,
  [anon_sym_offset] = anon_sym_offset,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_append] = anon_sym_append,
  [anon_sym_insert] = anon_sym_insert,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_vastart] = anon_sym_vastart,
  [anon_sym_vaarg] = anon_sym_vaarg,
  [anon_sym_vaend] = anon_sym_vaend,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_CARET_CARET] = anon_sym_CARET_CARET,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_AMP_DOT_DOT] = anon_sym_AMP_DOT_DOT,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_match] = anon_sym_match,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_AMP_AMP_EQ] = anon_sym_AMP_AMP_EQ,
  [anon_sym_PIPE_PIPE_EQ] = anon_sym_PIPE_PIPE_EQ,
  [anon_sym_CARET_CARET_EQ] = anon_sym_CARET_CARET_EQ,
  [anon_sym_def] = anon_sym_def,
  [anon_sym_defer] = anon_sym_defer,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_COMMA2] = anon_sym_COMMA2,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_ATthreadlocal] = anon_sym_ATthreadlocal,
  [anon_sym_ATsymbol] = anon_sym_ATsymbol,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_ATfini] = anon_sym_ATfini,
  [anon_sym_ATinit] = anon_sym_ATinit,
  [anon_sym_ATtest] = anon_sym_ATtest,
  [anon_sym_use] = anon_sym_use,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [sym_sub_unit] = sym_sub_unit,
  [sym_type] = sym_type,
  [sym__storage_class] = sym__storage_class,
  [sym__primitive_type] = sym__primitive_type,
  [sym__integer_type] = sym__integer_type,
  [sym__floating_type] = sym__floating_type,
  [sym_pointer_type] = sym_pointer_type,
  [sym_struct_union_type] = sym_struct_union_type,
  [sym_struct_union_fields] = sym_struct_union_fields,
  [sym_struct_union_field] = sym_struct_union_field,
  [sym_struct_fields] = sym_struct_fields,
  [sym_struct_field] = sym_struct_field,
  [sym_offset_specifier] = sym_offset_specifier,
  [sym_tuple_type] = sym_tuple_type,
  [sym_tagged_union_type] = sym_tagged_union_type,
  [sym_slice_array_type] = sym_slice_array_type,
  [sym_function_type] = sym_function_type,
  [sym__prototype] = sym__prototype,
  [sym_parameter] = sym_parameter,
  [sym_alias_type] = sym_alias_type,
  [sym_unwrapped_alias] = sym_unwrapped_alias,
  [sym_literal] = sym_literal,
  [sym_rune_literal] = sym_rune_literal,
  [sym_string_literal] = sym_string_literal,
  [sym_array_literal] = sym_array_literal,
  [sym_struct_literal] = sym_struct_literal,
  [sym_field_value] = sym_field_value,
  [sym_tuple_literal] = sym_tuple_literal,
  [sym__plain_expression] = sym__plain_expression,
  [sym_nested_expression] = sym_nested_expression,
  [sym_allocation_expression] = sym_allocation_expression,
  [sym_assertion_expression] = sym_assertion_expression,
  [sym_call_expression] = sym_call_expression,
  [sym_argument_list] = sym_argument_list,
  [sym_measurement_expression] = sym_measurement_expression,
  [sym_align_expression] = sym_align_expression,
  [sym_size_expression] = sym_size_expression,
  [sym_length_expression] = sym_length_expression,
  [sym_offset_expression] = sym_offset_expression,
  [sym_field_access_expression] = sym_field_access_expression,
  [sym_indexing_expression] = sym_indexing_expression,
  [sym_slicing_expression] = sym_slicing_expression,
  [sym_slice_mutation_expression] = sym_slice_mutation_expression,
  [sym_append_expression] = sym_append_expression,
  [sym_insert_expression] = sym_insert_expression,
  [sym_delete_expression] = sym_delete_expression,
  [sym_error_propagation] = sym_error_propagation,
  [sym_postfix_expression] = sym_postfix_expression,
  [sym_variadic_expression] = sym_variadic_expression,
  [sym_builtin_expression] = sym_builtin_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_cast_expression] = sym_cast_expression,
  [sym_nullable_type] = sym_nullable_type,
  [sym_multiplicative_expression] = sym_multiplicative_expression,
  [sym_additive_expression] = sym_additive_expression,
  [sym_shift_expression] = sym_shift_expression,
  [sym_and_expression] = sym_and_expression,
  [sym_exclusive_or_expression] = sym_exclusive_or_expression,
  [sym_inclusive_or_expression] = sym_inclusive_or_expression,
  [sym_comparison_expression] = sym_comparison_expression,
  [sym_equality_expression] = sym_equality_expression,
  [sym_logical_and_expression] = sym_logical_and_expression,
  [sym_logical_xor_expression] = sym_logical_xor_expression,
  [sym_logical_or_expression] = sym_logical_or_expression,
  [sym_if_expression] = sym_if_expression,
  [sym_conditional_branch] = sym_conditional_branch,
  [sym_for_loop] = sym_for_loop,
  [sym_for_predicate] = sym_for_predicate,
  [sym_iterable_binding] = sym_iterable_binding,
  [sym_switch_expression] = sym_switch_expression,
  [sym_switch_cases] = sym_switch_cases,
  [sym_switch_case] = sym_switch_case,
  [sym_case_options] = sym_case_options,
  [sym_match_expression] = sym_match_expression,
  [sym_match_cases] = sym_match_cases,
  [sym_match_case] = sym_match_case,
  [sym_assignment] = sym_assignment,
  [sym_assignment_op] = sym_assignment_op,
  [sym_binding_list] = sym_binding_list,
  [sym_bindings] = sym_bindings,
  [sym_binding] = sym_binding,
  [sym_binding_name] = sym_binding_name,
  [sym_tuple_binding_names] = sym_tuple_binding_names,
  [sym_tuple_binding_name] = sym_tuple_binding_name,
  [sym_defer_expression] = sym_defer_expression,
  [sym_expression_list] = sym_expression_list,
  [sym_compound_expression] = sym_compound_expression,
  [sym_label] = sym_label,
  [sym_control_expression] = sym_control_expression,
  [sym_expression] = sym_expression,
  [sym_declarations] = sym_declarations,
  [sym_declaration] = sym_declaration,
  [sym_global_declaration] = sym_global_declaration,
  [sym_global_bindings] = sym_global_bindings,
  [sym_global_binding] = sym_global_binding,
  [sym_decl_attr] = sym_decl_attr,
  [sym_constant_declaration] = sym_constant_declaration,
  [sym_constant_bindings] = sym_constant_bindings,
  [sym_constant_binding] = sym_constant_binding,
  [sym_type_declaration] = sym_type_declaration,
  [sym_type_bindings] = sym_type_bindings,
  [sym_type_binding] = sym_type_binding,
  [sym_enum_type] = sym_enum_type,
  [sym_enum_values] = sym_enum_values,
  [sym_enum_value] = sym_enum_value,
  [sym_enum_storage] = sym_enum_storage,
  [sym_function_declaration] = sym_function_declaration,
  [sym_fndec_attrs] = sym_fndec_attrs,
  [sym_fndec_attr] = sym_fndec_attr,
  [sym_imports] = sym_imports,
  [sym_use_directive] = sym_use_directive,
  [sym_member_list] = sym_member_list,
  [sym_member] = sym_member,
  [aux_sym_struct_union_fields_repeat1] = aux_sym_struct_union_fields_repeat1,
  [aux_sym_struct_fields_repeat1] = aux_sym_struct_fields_repeat1,
  [aux_sym_tuple_type_repeat1] = aux_sym_tuple_type_repeat1,
  [aux_sym_tagged_union_type_repeat1] = aux_sym_tagged_union_type_repeat1,
  [aux_sym__prototype_repeat1] = aux_sym__prototype_repeat1,
  [aux_sym_string_literal_repeat1] = aux_sym_string_literal_repeat1,
  [aux_sym_array_literal_repeat1] = aux_sym_array_literal_repeat1,
  [aux_sym_struct_literal_repeat1] = aux_sym_struct_literal_repeat1,
  [aux_sym_switch_cases_repeat1] = aux_sym_switch_cases_repeat1,
  [aux_sym_match_cases_repeat1] = aux_sym_match_cases_repeat1,
  [aux_sym_declarations_repeat1] = aux_sym_declarations_repeat1,
  [aux_sym_fndec_attrs_repeat1] = aux_sym_fndec_attrs_repeat1,
  [aux_sym_imports_repeat1] = aux_sym_imports_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_keyword] = {
    .visible = true,
    .named = true,
  },
  [sym_name] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rune] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bool] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_valist] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_void] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_opaque] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_done] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_never] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_i8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_i16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_i32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_i64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_size] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uintptr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_f32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_f64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nullable] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATpacked] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_union] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AToffset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [sym__string_type] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_fn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_null] = {
    .visible = true,
    .named = false,
  },
  [sym_floating_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_rune_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE2] = {
    .visible = true,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_string_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_literal_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_alloc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_free] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abort] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_align] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_len] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_offset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_append] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_insert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_vastart] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_vaarg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_vaend] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_match] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_def] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defer] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATthreadlocal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATsymbol] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATfini] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATinit] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATtest] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_use] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_sub_unit] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym__storage_class] = {
    .visible = false,
    .named = true,
  },
  [sym__primitive_type] = {
    .visible = false,
    .named = true,
  },
  [sym__integer_type] = {
    .visible = false,
    .named = true,
  },
  [sym__floating_type] = {
    .visible = false,
    .named = true,
  },
  [sym_pointer_type] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_union_type] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_union_fields] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_union_field] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_fields] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_field] = {
    .visible = true,
    .named = true,
  },
  [sym_offset_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_tagged_union_type] = {
    .visible = true,
    .named = true,
  },
  [sym_slice_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym__prototype] = {
    .visible = false,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_alias_type] = {
    .visible = true,
    .named = true,
  },
  [sym_unwrapped_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_rune_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_array_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_field_value] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__plain_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_nested_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_allocation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assertion_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_measurement_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_align_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_size_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_length_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_offset_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_field_access_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_indexing_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_slicing_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_slice_mutation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_append_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_insert_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_delete_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_error_propagation] = {
    .visible = true,
    .named = true,
  },
  [sym_postfix_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_variadic_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_builtin_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_cast_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_nullable_type] = {
    .visible = true,
    .named = true,
  },
  [sym_multiplicative_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_additive_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_shift_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_and_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_exclusive_or_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_inclusive_or_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_comparison_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_equality_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_logical_and_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_logical_xor_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_logical_or_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_if_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_branch] = {
    .visible = true,
    .named = true,
  },
  [sym_for_loop] = {
    .visible = true,
    .named = true,
  },
  [sym_for_predicate] = {
    .visible = true,
    .named = true,
  },
  [sym_iterable_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_cases] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_case] = {
    .visible = true,
    .named = true,
  },
  [sym_case_options] = {
    .visible = true,
    .named = true,
  },
  [sym_match_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_match_cases] = {
    .visible = true,
    .named = true,
  },
  [sym_match_case] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_op] = {
    .visible = true,
    .named = true,
  },
  [sym_binding_list] = {
    .visible = true,
    .named = true,
  },
  [sym_bindings] = {
    .visible = true,
    .named = true,
  },
  [sym_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_binding_name] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_binding_names] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_binding_name] = {
    .visible = true,
    .named = true,
  },
  [sym_defer_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_label] = {
    .visible = true,
    .named = true,
  },
  [sym_control_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_declarations] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_global_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_global_bindings] = {
    .visible = true,
    .named = true,
  },
  [sym_global_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_decl_attr] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_bindings] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_type_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_type_bindings] = {
    .visible = true,
    .named = true,
  },
  [sym_type_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_type] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_values] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_value] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_storage] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_fndec_attrs] = {
    .visible = true,
    .named = true,
  },
  [sym_fndec_attr] = {
    .visible = true,
    .named = true,
  },
  [sym_imports] = {
    .visible = true,
    .named = true,
  },
  [sym_use_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_member_list] = {
    .visible = true,
    .named = true,
  },
  [sym_member] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_struct_union_fields_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_fields_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tagged_union_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__prototype_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_cases_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_match_cases_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_declarations_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_fndec_attrs_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_imports_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_afterthought = 1,
  field_as_cast = 2,
  field_binding = 3,
  field_body = 4,
  field_condition = 5,
  field_is_cast = 6,
  field_name = 7,
  field_selector = 8,
  field_type = 9,
  field_type_cast = 10,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_afterthought] = "afterthought",
  [field_as_cast] = "as_cast",
  [field_binding] = "binding",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_is_cast] = "is_cast",
  [field_name] = "name",
  [field_selector] = "selector",
  [field_type] = "type",
  [field_type_cast] = "type_cast",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 2},
  [2] = {.index = 2, .length = 2},
  [3] = {.index = 4, .length = 3},
  [4] = {.index = 7, .length = 2},
  [5] = {.index = 9, .length = 3},
  [6] = {.index = 12, .length = 3},
  [7] = {.index = 15, .length = 3},
  [8] = {.index = 18, .length = 3},
  [9] = {.index = 21, .length = 2},
  [10] = {.index = 23, .length = 2},
  [11] = {.index = 25, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 1},
    {field_type, 2},
  [2] =
    {field_name, 2},
    {field_type, 3},
  [4] =
    {field_body, 4},
    {field_name, 1},
    {field_type, 2},
  [7] =
    {field_selector, 1},
    {field_selector, 2},
  [9] =
    {field_type_cast, 0},
    {field_type_cast, 1},
    {field_type_cast, 2},
  [12] =
    {field_as_cast, 0},
    {field_as_cast, 1},
    {field_as_cast, 2},
  [15] =
    {field_is_cast, 0},
    {field_is_cast, 1},
    {field_is_cast, 2},
  [18] =
    {field_body, 5},
    {field_name, 2},
    {field_type, 3},
  [21] =
    {field_afterthought, 2},
    {field_binding, 0},
  [23] =
    {field_afterthought, 2},
    {field_condition, 0},
  [25] =
    {field_afterthought, 4},
    {field_binding, 0},
    {field_condition, 2},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 3,
  [5] = 2,
  [6] = 6,
  [7] = 6,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 16,
  [18] = 15,
  [19] = 19,
  [20] = 19,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 22,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 28,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 27,
  [35] = 35,
  [36] = 36,
  [37] = 36,
  [38] = 31,
  [39] = 32,
  [40] = 35,
  [41] = 29,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 63,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 81,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 76,
  [98] = 98,
  [99] = 99,
  [100] = 88,
  [101] = 69,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 94,
  [106] = 93,
  [107] = 90,
  [108] = 108,
  [109] = 109,
  [110] = 89,
  [111] = 57,
  [112] = 86,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 85,
  [118] = 72,
  [119] = 119,
  [120] = 73,
  [121] = 74,
  [122] = 75,
  [123] = 123,
  [124] = 77,
  [125] = 79,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 163,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 167,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 202,
  [203] = 203,
  [204] = 204,
  [205] = 205,
  [206] = 206,
  [207] = 207,
  [208] = 208,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 219,
  [220] = 220,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 168,
  [237] = 237,
  [238] = 214,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 229,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 177,
  [262] = 262,
  [263] = 230,
  [264] = 264,
  [265] = 265,
  [266] = 180,
  [267] = 267,
  [268] = 216,
  [269] = 211,
  [270] = 210,
  [271] = 271,
  [272] = 209,
  [273] = 273,
  [274] = 207,
  [275] = 206,
  [276] = 276,
  [277] = 277,
  [278] = 205,
  [279] = 279,
  [280] = 204,
  [281] = 281,
  [282] = 282,
  [283] = 283,
  [284] = 202,
  [285] = 285,
  [286] = 199,
  [287] = 198,
  [288] = 288,
  [289] = 188,
  [290] = 290,
  [291] = 265,
  [292] = 175,
  [293] = 293,
  [294] = 294,
  [295] = 295,
  [296] = 296,
  [297] = 297,
  [298] = 298,
  [299] = 299,
  [300] = 300,
  [301] = 301,
  [302] = 301,
  [303] = 303,
  [304] = 304,
  [305] = 305,
  [306] = 306,
  [307] = 307,
  [308] = 308,
  [309] = 309,
  [310] = 307,
  [311] = 311,
  [312] = 312,
  [313] = 313,
  [314] = 314,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 320,
  [321] = 321,
  [322] = 317,
  [323] = 323,
  [324] = 324,
  [325] = 325,
  [326] = 326,
  [327] = 327,
  [328] = 328,
  [329] = 329,
  [330] = 330,
  [331] = 331,
  [332] = 332,
  [333] = 333,
  [334] = 334,
  [335] = 335,
  [336] = 336,
  [337] = 337,
  [338] = 338,
  [339] = 339,
  [340] = 340,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 344,
  [345] = 344,
  [346] = 346,
  [347] = 347,
  [348] = 348,
  [349] = 349,
  [350] = 350,
  [351] = 351,
  [352] = 352,
  [353] = 336,
  [354] = 354,
  [355] = 355,
  [356] = 356,
  [357] = 352,
  [358] = 358,
  [359] = 359,
  [360] = 360,
  [361] = 361,
  [362] = 362,
  [363] = 363,
  [364] = 364,
  [365] = 365,
  [366] = 366,
  [367] = 367,
  [368] = 368,
  [369] = 369,
  [370] = 370,
  [371] = 371,
  [372] = 372,
  [373] = 373,
  [374] = 374,
  [375] = 375,
  [376] = 376,
  [377] = 377,
  [378] = 378,
  [379] = 379,
  [380] = 380,
  [381] = 381,
  [382] = 382,
  [383] = 383,
  [384] = 384,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 388,
  [390] = 136,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 394,
  [395] = 395,
  [396] = 386,
  [397] = 393,
  [398] = 398,
  [399] = 133,
  [400] = 141,
  [401] = 126,
  [402] = 402,
  [403] = 403,
  [404] = 404,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 130,
  [412] = 131,
  [413] = 139,
  [414] = 414,
  [415] = 127,
  [416] = 156,
  [417] = 417,
  [418] = 418,
  [419] = 140,
  [420] = 147,
  [421] = 150,
  [422] = 142,
  [423] = 423,
  [424] = 138,
  [425] = 149,
  [426] = 426,
  [427] = 144,
  [428] = 143,
  [429] = 145,
  [430] = 154,
  [431] = 148,
  [432] = 134,
  [433] = 433,
  [434] = 135,
  [435] = 152,
  [436] = 137,
  [437] = 437,
  [438] = 438,
  [439] = 128,
  [440] = 153,
  [441] = 155,
  [442] = 442,
  [443] = 443,
  [444] = 444,
  [445] = 151,
  [446] = 446,
  [447] = 447,
  [448] = 448,
  [449] = 449,
  [450] = 450,
  [451] = 451,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 455,
  [456] = 456,
  [457] = 457,
  [458] = 458,
  [459] = 459,
  [460] = 460,
  [461] = 461,
  [462] = 462,
  [463] = 463,
  [464] = 464,
  [465] = 465,
  [466] = 466,
  [467] = 467,
  [468] = 468,
  [469] = 469,
  [470] = 470,
  [471] = 471,
  [472] = 472,
  [473] = 473,
  [474] = 455,
  [475] = 465,
  [476] = 476,
  [477] = 468,
  [478] = 478,
  [479] = 479,
  [480] = 480,
  [481] = 481,
  [482] = 482,
  [483] = 483,
  [484] = 484,
  [485] = 485,
  [486] = 486,
  [487] = 479,
  [488] = 488,
  [489] = 489,
  [490] = 490,
  [491] = 491,
  [492] = 492,
  [493] = 493,
  [494] = 494,
  [495] = 495,
  [496] = 496,
  [497] = 497,
  [498] = 498,
  [499] = 499,
  [500] = 500,
  [501] = 496,
  [502] = 502,
  [503] = 503,
  [504] = 504,
  [505] = 505,
  [506] = 481,
  [507] = 507,
  [508] = 508,
  [509] = 509,
  [510] = 510,
  [511] = 489,
  [512] = 500,
  [513] = 513,
  [514] = 514,
  [515] = 515,
  [516] = 516,
  [517] = 517,
  [518] = 518,
  [519] = 519,
  [520] = 520,
  [521] = 521,
  [522] = 522,
  [523] = 523,
  [524] = 519,
  [525] = 525,
  [526] = 526,
  [527] = 527,
  [528] = 528,
  [529] = 529,
  [530] = 530,
  [531] = 530,
  [532] = 532,
  [533] = 532,
  [534] = 534,
  [535] = 535,
  [536] = 536,
  [537] = 537,
  [538] = 538,
  [539] = 539,
  [540] = 540,
  [541] = 541,
  [542] = 542,
  [543] = 543,
  [544] = 544,
  [545] = 545,
  [546] = 546,
  [547] = 547,
  [548] = 548,
  [549] = 549,
  [550] = 550,
  [551] = 551,
  [552] = 552,
  [553] = 553,
  [554] = 554,
  [555] = 555,
  [556] = 556,
  [557] = 557,
  [558] = 558,
  [559] = 559,
  [560] = 560,
  [561] = 426,
  [562] = 562,
  [563] = 563,
  [564] = 523,
  [565] = 565,
  [566] = 566,
  [567] = 567,
  [568] = 568,
  [569] = 569,
  [570] = 570,
  [571] = 546,
  [572] = 572,
  [573] = 573,
  [574] = 574,
  [575] = 575,
  [576] = 576,
  [577] = 577,
  [578] = 578,
  [579] = 579,
  [580] = 580,
  [581] = 581,
  [582] = 582,
  [583] = 583,
  [584] = 584,
  [585] = 585,
  [586] = 586,
  [587] = 587,
  [588] = 588,
  [589] = 589,
  [590] = 590,
  [591] = 591,
  [592] = 592,
  [593] = 593,
  [594] = 594,
  [595] = 595,
  [596] = 596,
  [597] = 597,
  [598] = 598,
  [599] = 599,
  [600] = 600,
  [601] = 601,
  [602] = 602,
  [603] = 603,
  [604] = 604,
  [605] = 605,
  [606] = 606,
  [607] = 607,
  [608] = 608,
  [609] = 609,
  [610] = 610,
  [611] = 611,
  [612] = 612,
  [613] = 613,
  [614] = 614,
  [615] = 615,
  [616] = 616,
  [617] = 617,
  [618] = 618,
  [619] = 619,
  [620] = 620,
  [621] = 621,
  [622] = 622,
  [623] = 623,
  [624] = 624,
  [625] = 625,
  [626] = 626,
  [627] = 627,
  [628] = 628,
  [629] = 629,
  [630] = 630,
  [631] = 631,
  [632] = 632,
  [633] = 633,
  [634] = 634,
  [635] = 635,
  [636] = 636,
  [637] = 637,
  [638] = 638,
  [639] = 639,
  [640] = 640,
  [641] = 641,
  [642] = 642,
  [643] = 643,
  [644] = 644,
  [645] = 645,
  [646] = 646,
  [647] = 647,
  [648] = 648,
  [649] = 649,
  [650] = 650,
  [651] = 651,
  [652] = 652,
  [653] = 645,
  [654] = 654,
  [655] = 632,
  [656] = 656,
  [657] = 657,
  [658] = 658,
  [659] = 659,
  [660] = 593,
  [661] = 661,
  [662] = 662,
  [663] = 663,
  [664] = 588,
  [665] = 665,
  [666] = 666,
  [667] = 667,
  [668] = 668,
  [669] = 669,
  [670] = 670,
  [671] = 637,
  [672] = 672,
  [673] = 673,
  [674] = 674,
  [675] = 675,
  [676] = 646,
  [677] = 652,
  [678] = 678,
  [679] = 679,
  [680] = 680,
  [681] = 681,
  [682] = 682,
  [683] = 683,
  [684] = 682,
  [685] = 685,
  [686] = 686,
  [687] = 687,
  [688] = 688,
  [689] = 689,
  [690] = 690,
  [691] = 679,
  [692] = 692,
  [693] = 693,
  [694] = 633,
  [695] = 695,
  [696] = 687,
  [697] = 590,
  [698] = 698,
  [699] = 699,
  [700] = 700,
  [701] = 700,
  [702] = 702,
  [703] = 703,
  [704] = 576,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(195);
      ADVANCE_MAP(
        '!', 513,
        '"', 560,
        '%', 575,
        '&', 572,
        '\'', 552,
        '(', 524,
        ')', 525,
        '*', 515,
        '+', 567,
        ',', 520,
        '-', 569,
        '.', 561,
        '/', 574,
        '0', 539,
        ':', 522,
        ';', 588,
        '<', 579,
        '=', 532,
        '>', 580,
        '?', 565,
        '@', 84,
        '[', 527,
        '\\', 40,
        ']', 528,
        '^', 578,
        '_', 196,
        '`', 193,
        'a', 54,
        'b', 128,
        'c', 43,
        'd', 66,
        'e', 109,
        'f', 29,
        'i', 25,
        'l', 68,
        'm', 44,
        'n', 69,
        'o', 85,
        'r', 71,
        's', 94,
        't', 140,
        'u', 24,
        'v', 45,
        'y', 100,
        '{', 517,
        '|', 526,
        '}', 518,
        '~', 570,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(194);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(540);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '!', 513,
        '"', 555,
        '%', 575,
        '&', 573,
        '\'', 550,
        '(', 524,
        ')', 525,
        '*', 515,
        '+', 567,
        ',', 519,
        '-', 569,
        '.', 15,
        '/', 574,
        '0', 539,
        ':', 521,
        ';', 588,
        '<', 579,
        '=', 532,
        '>', 580,
        '[', 527,
        ']', 528,
        '^', 578,
        '_', 207,
        '`', 193,
        'a', 428,
        'b', 477,
        'c', 420,
        'd', 435,
        'e', 464,
        'f', 417,
        'i', 415,
        'l', 437,
        'm', 421,
        'n', 438,
        'o', 447,
        'r', 440,
        's', 454,
        't', 487,
        'u', 414,
        'v', 422,
        'y', 460,
        '{', 517,
        '|', 526,
        '}', 518,
        '~', 570,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(1);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(540);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '!', 513,
        '%', 575,
        '&', 573,
        '\'', 552,
        '(', 524,
        ')', 525,
        '*', 515,
        '+', 567,
        ',', 519,
        '-', 569,
        '.', 561,
        '/', 574,
        ':', 521,
        ';', 588,
        '<', 579,
        '=', 532,
        '>', 580,
        '?', 565,
        '[', 527,
        ']', 528,
        '^', 578,
        '_', 196,
        'a', 54,
        'b', 128,
        'c', 43,
        'd', 66,
        'e', 109,
        'f', 29,
        'i', 25,
        'l', 68,
        'm', 44,
        'n', 69,
        'o', 85,
        'r', 71,
        's', 94,
        't', 140,
        'u', 24,
        'v', 45,
        'y', 100,
        '{', 517,
        '|', 526,
        '}', 518,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '!', 513,
        '%', 575,
        '&', 573,
        '(', 524,
        ')', 525,
        '*', 515,
        '+', 567,
        ',', 519,
        '-', 569,
        '.', 561,
        '/', 574,
        ':', 521,
        ';', 588,
        '<', 579,
        '=', 532,
        '>', 580,
        '?', 565,
        '[', 527,
        ']', 528,
        '^', 578,
        '_', 196,
        'a', 54,
        'b', 128,
        'c', 43,
        'd', 66,
        'e', 109,
        'f', 29,
        'i', 25,
        'l', 68,
        'm', 44,
        'n', 69,
        'o', 85,
        'r', 71,
        's', 94,
        't', 140,
        'u', 24,
        'v', 45,
        'y', 100,
        '{', 517,
        '|', 526,
        '}', 518,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '!', 512,
        '"', 555,
        '&', 571,
        '\'', 550,
        '(', 524,
        ')', 525,
        '*', 514,
        '+', 566,
        ',', 519,
        '-', 568,
        '.', 562,
        '/', 20,
        '0', 539,
        ':', 521,
        '=', 39,
        '?', 565,
        '[', 527,
        ']', 528,
        '_', 207,
        '`', 193,
        'a', 428,
        'b', 477,
        'c', 420,
        'd', 435,
        'e', 464,
        'f', 417,
        'i', 415,
        'l', 437,
        'm', 421,
        'n', 438,
        'o', 447,
        'r', 440,
        's', 454,
        't', 487,
        'u', 414,
        'v', 422,
        'y', 460,
        '{', 517,
        '}', 518,
        '~', 570,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(540);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        '!', 512,
        '"', 555,
        '&', 571,
        '\'', 550,
        '(', 524,
        ')', 525,
        '*', 514,
        '+', 566,
        ',', 519,
        '-', 568,
        '.', 19,
        '/', 20,
        '0', 539,
        ':', 521,
        '=', 530,
        '@', 127,
        '[', 527,
        ']', 528,
        '_', 208,
        '`', 193,
        'a', 240,
        'b', 289,
        'c', 232,
        'd', 246,
        'e', 275,
        'f', 226,
        'i', 221,
        'l', 248,
        'm', 233,
        'n', 249,
        'o', 259,
        'r', 252,
        's', 266,
        't', 299,
        'u', 220,
        'v', 234,
        'y', 272,
        '{', 517,
        '}', 518,
        '~', 570,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(5);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(540);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        '!', 512,
        '(', 524,
        ')', 525,
        '*', 514,
        '.', 19,
        '/', 20,
        ':', 36,
        ';', 588,
        '=', 39,
        '[', 527,
        '_', 207,
        'a', 428,
        'b', 477,
        'c', 420,
        'd', 435,
        'e', 464,
        'f', 417,
        'i', 415,
        'l', 437,
        'm', 421,
        'n', 438,
        'o', 447,
        'r', 440,
        's', 454,
        't', 487,
        'u', 414,
        'v', 422,
        'y', 460,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(6);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        '!', 38,
        '%', 575,
        '&', 572,
        ')', 525,
        '*', 515,
        '+', 567,
        ',', 519,
        '-', 569,
        '.', 15,
        '/', 574,
        ':', 521,
        ';', 588,
        '<', 579,
        '=', 532,
        '>', 580,
        ']', 528,
        '^', 578,
        '_', 196,
        'a', 54,
        'b', 128,
        'c', 43,
        'd', 66,
        'e', 109,
        'f', 29,
        'i', 25,
        'l', 68,
        'm', 44,
        'n', 69,
        'o', 85,
        'r', 71,
        's', 94,
        't', 140,
        'u', 24,
        'v', 45,
        'y', 100,
        '|', 526,
        '}', 518,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(7);
      END_STATE();
    case 8:
      ADVANCE_MAP(
        '!', 38,
        '%', 575,
        '&', 573,
        ')', 525,
        '*', 515,
        '+', 567,
        ',', 520,
        '-', 569,
        '.', 15,
        '/', 574,
        ':', 521,
        ';', 588,
        '<', 579,
        '=', 532,
        '>', 580,
        ']', 528,
        '^', 578,
        '_', 196,
        'a', 54,
        'b', 128,
        'c', 43,
        'd', 66,
        'e', 109,
        'f', 29,
        'i', 25,
        'l', 68,
        'm', 44,
        'n', 69,
        'o', 85,
        'r', 71,
        's', 94,
        't', 140,
        'u', 24,
        'v', 45,
        'y', 100,
        '{', 517,
        '|', 526,
        '}', 518,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(8);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        '!', 38,
        '%', 575,
        '&', 573,
        ')', 525,
        '*', 515,
        '+', 567,
        ',', 519,
        '-', 569,
        '.', 19,
        '/', 574,
        ':', 521,
        '<', 579,
        '=', 531,
        '>', 580,
        ']', 528,
        '^', 578,
        '_', 196,
        'a', 54,
        'b', 128,
        'c', 43,
        'd', 66,
        'e', 109,
        'f', 29,
        'i', 25,
        'l', 68,
        'm', 44,
        'n', 69,
        'o', 85,
        'r', 71,
        's', 94,
        't', 140,
        'u', 24,
        'v', 45,
        'y', 100,
        '|', 526,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(9);
      END_STATE();
    case 10:
      ADVANCE_MAP(
        '!', 38,
        '%', 575,
        '&', 573,
        '*', 515,
        '+', 567,
        '-', 569,
        '.', 18,
        '/', 574,
        ':', 521,
        '<', 579,
        '=', 531,
        '>', 580,
        ']', 528,
        '^', 578,
        '_', 196,
        'a', 54,
        'b', 128,
        'c', 43,
        'd', 66,
        'e', 109,
        'f', 29,
        'i', 25,
        'l', 68,
        'm', 44,
        'n', 69,
        'o', 85,
        'r', 71,
        's', 94,
        't', 140,
        'u', 24,
        'v', 45,
        'y', 100,
        '|', 526,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(10);
      END_STATE();
    case 11:
      if (lookahead == '"') ADVANCE(560);
      if (lookahead == '/') ADVANCE(558);
      if (lookahead == '\\') ADVANCE(40);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(557);
      if (lookahead != 0) ADVANCE(559);
      END_STATE();
    case 12:
      ADVANCE_MAP(
        '&', 14,
        ')', 525,
        '.', 18,
        '/', 20,
        ':', 521,
        ';', 588,
        '=', 533,
        '@', 145,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(12);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 13:
      if (lookahead == '(') ADVANCE(524);
      if (lookahead == '/') ADVANCE(20);
      if (lookahead == '0') ADVANCE(543);
      if (lookahead == ';') ADVANCE(588);
      if (lookahead == '}') ADVANCE(518);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(13);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(545);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 14:
      if (lookahead == '.') ADVANCE(16);
      END_STATE();
    case 15:
      if (lookahead == '.') ADVANCE(564);
      END_STATE();
    case 16:
      if (lookahead == '.') ADVANCE(589);
      END_STATE();
    case 17:
      if (lookahead == '.') ADVANCE(529);
      END_STATE();
    case 18:
      if (lookahead == '.') ADVANCE(563);
      END_STATE();
    case 19:
      if (lookahead == '.') ADVANCE(17);
      END_STATE();
    case 20:
      if (lookahead == '/') ADVANCE(511);
      END_STATE();
    case 21:
      ADVANCE_MAP(
        '/', 20,
        '_', 219,
        'a', 331,
        'b', 380,
        'c', 323,
        'd', 338,
        'e', 367,
        'f', 227,
        'i', 223,
        'l', 340,
        'm', 324,
        'n', 341,
        'o', 350,
        'r', 343,
        's', 357,
        't', 390,
        'u', 222,
        'v', 325,
        'y', 363,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(21);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 22:
      if (lookahead == '/') ADVANCE(20);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(22);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 23:
      if (lookahead == '/') ADVANCE(551);
      if (lookahead == '\\') ADVANCE(40);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(551);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(551);
      END_STATE();
    case 24:
      if (lookahead == '1') ADVANCE(34);
      if (lookahead == '3') ADVANCE(26);
      if (lookahead == '6') ADVANCE(31);
      if (lookahead == '8') ADVANCE(196);
      if (lookahead == 'i') ADVANCE(124);
      if (lookahead == 'n') ADVANCE(99);
      if (lookahead == 's') ADVANCE(65);
      END_STATE();
    case 25:
      if (lookahead == '1') ADVANCE(34);
      if (lookahead == '3') ADVANCE(26);
      if (lookahead == '6') ADVANCE(31);
      if (lookahead == 'n') ADVANCE(147);
      if (lookahead == '8' ||
          lookahead == 'f' ||
          lookahead == 's') ADVANCE(196);
      END_STATE();
    case 26:
      if (lookahead == '2') ADVANCE(196);
      END_STATE();
    case 27:
      if (lookahead == '2') ADVANCE(538);
      END_STATE();
    case 28:
      if (lookahead == '2') ADVANCE(534);
      END_STATE();
    case 29:
      if (lookahead == '3') ADVANCE(26);
      if (lookahead == '6') ADVANCE(31);
      if (lookahead == 'a') ADVANCE(108);
      if (lookahead == 'n') ADVANCE(196);
      if (lookahead == 'o') ADVANCE(139);
      if (lookahead == 'r') ADVANCE(74);
      END_STATE();
    case 30:
      if (lookahead == '3') ADVANCE(28);
      if (lookahead == '6') ADVANCE(33);
      END_STATE();
    case 31:
      if (lookahead == '4') ADVANCE(196);
      END_STATE();
    case 32:
      if (lookahead == '4') ADVANCE(538);
      END_STATE();
    case 33:
      if (lookahead == '4') ADVANCE(534);
      END_STATE();
    case 34:
      if (lookahead == '6') ADVANCE(196);
      END_STATE();
    case 35:
      if (lookahead == '6') ADVANCE(538);
      END_STATE();
    case 36:
      if (lookahead == ':') ADVANCE(610);
      END_STATE();
    case 37:
      if (lookahead == ':') ADVANCE(192);
      END_STATE();
    case 38:
      if (lookahead == '=') ADVANCE(584);
      END_STATE();
    case 39:
      if (lookahead == '>') ADVANCE(590);
      END_STATE();
    case 40:
      ADVANCE_MAP(
        'U', 190,
        'u', 186,
        'x', 184,
        '"', 553,
        '\'', 553,
        '0', 553,
        '\\', 553,
        'a', 553,
        'b', 553,
        'f', 553,
        'n', 553,
        'r', 553,
        't', 553,
        'v', 553,
      );
      END_STATE();
    case 41:
      if (lookahead == '_') ADVANCE(549);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(541);
      END_STATE();
    case 42:
      if (lookahead == '`') ADVANCE(554);
      if (lookahead != 0) ADVANCE(42);
      END_STATE();
    case 43:
      if (lookahead == 'a') ADVANCE(146);
      if (lookahead == 'o') ADVANCE(122);
      END_STATE();
    case 44:
      if (lookahead == 'a') ADVANCE(159);
      END_STATE();
    case 45:
      if (lookahead == 'a') ADVANCE(52);
      if (lookahead == 'o') ADVANCE(96);
      END_STATE();
    case 46:
      if (lookahead == 'a') ADVANCE(58);
      END_STATE();
    case 47:
      if (lookahead == 'a') ADVANCE(138);
      END_STATE();
    case 48:
      if (lookahead == 'a') ADVANCE(105);
      END_STATE();
    case 49:
      if (lookahead == 'a') ADVANCE(143);
      END_STATE();
    case 50:
      if (lookahead == 'a') ADVANCE(163);
      if (lookahead == 'r') ADVANCE(218);
      END_STATE();
    case 51:
      if (lookahead == 'a') ADVANCE(64);
      END_STATE();
    case 52:
      if (lookahead == 'a') ADVANCE(141);
      if (lookahead == 'e') ADVANCE(120);
      if (lookahead == 'l') ADVANCE(104);
      if (lookahead == 's') ADVANCE(162);
      END_STATE();
    case 53:
      if (lookahead == 'a') ADVANCE(113);
      END_STATE();
    case 54:
      if (lookahead == 'b') ADVANCE(130);
      if (lookahead == 'l') ADVANCE(95);
      if (lookahead == 'p') ADVANCE(137);
      if (lookahead == 's') ADVANCE(215);
      END_STATE();
    case 55:
      if (lookahead == 'b') ADVANCE(114);
      END_STATE();
    case 56:
      if (lookahead == 'b') ADVANCE(134);
      END_STATE();
    case 57:
      if (lookahead == 'c') ADVANCE(196);
      END_STATE();
    case 58:
      if (lookahead == 'c') ADVANCE(106);
      END_STATE();
    case 59:
      if (lookahead == 'c') ADVANCE(91);
      END_STATE();
    case 60:
      if (lookahead == 'c') ADVANCE(53);
      END_STATE();
    case 61:
      if (lookahead == 'c') ADVANCE(153);
      END_STATE();
    case 62:
      if (lookahead == 'd') ADVANCE(196);
      END_STATE();
    case 63:
      if (lookahead == 'd') ADVANCE(516);
      END_STATE();
    case 64:
      if (lookahead == 'd') ADVANCE(116);
      END_STATE();
    case 65:
      if (lookahead == 'e') ADVANCE(196);
      END_STATE();
    case 66:
      if (lookahead == 'e') ADVANCE(83);
      if (lookahead == 'o') ADVANCE(123);
      END_STATE();
    case 67:
      if (lookahead == 'e') ADVANCE(139);
      END_STATE();
    case 68:
      if (lookahead == 'e') ADVANCE(175);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(167);
      if (lookahead == 'u') ADVANCE(115);
      END_STATE();
    case 70:
      if (lookahead == 'e') ADVANCE(148);
      if (lookahead == 'h') ADVANCE(144);
      END_STATE();
    case 71:
      if (lookahead == 'e') ADVANCE(160);
      if (lookahead == 'u') ADVANCE(123);
      END_STATE();
    case 72:
      if (lookahead == 'e') ADVANCE(63);
      END_STATE();
    case 73:
      if (lookahead == 'e') ADVANCE(143);
      END_STATE();
    case 74:
      if (lookahead == 'e') ADVANCE(65);
      END_STATE();
    case 75:
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 76:
      if (lookahead == 'e') ADVANCE(120);
      END_STATE();
    case 77:
      if (lookahead == 'e') ADVANCE(110);
      END_STATE();
    case 78:
      if (lookahead == 'e') ADVANCE(51);
      END_STATE();
    case 79:
      if (lookahead == 'e') ADVANCE(153);
      END_STATE();
    case 80:
      if (lookahead == 'e') ADVANCE(161);
      END_STATE();
    case 81:
      if (lookahead == 'e') ADVANCE(158);
      END_STATE();
    case 82:
      if (lookahead == 'f') ADVANCE(30);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(82);
      END_STATE();
    case 83:
      if (lookahead == 'f') ADVANCE(211);
      if (lookahead == 'l') ADVANCE(80);
      END_STATE();
    case 84:
      if (lookahead == 'f') ADVANCE(103);
      if (lookahead == 'i') ADVANCE(125);
      if (lookahead == 'o') ADVANCE(88);
      if (lookahead == 'p') ADVANCE(46);
      if (lookahead == 's') ADVANCE(168);
      if (lookahead == 't') ADVANCE(70);
      END_STATE();
    case 85:
      if (lookahead == 'f') ADVANCE(86);
      if (lookahead == 'p') ADVANCE(47);
      END_STATE();
    case 86:
      if (lookahead == 'f') ADVANCE(151);
      END_STATE();
    case 87:
      if (lookahead == 'f') ADVANCE(152);
      END_STATE();
    case 88:
      if (lookahead == 'f') ADVANCE(87);
      END_STATE();
    case 89:
      if (lookahead == 'g') ADVANCE(196);
      END_STATE();
    case 90:
      if (lookahead == 'g') ADVANCE(119);
      END_STATE();
    case 91:
      if (lookahead == 'h') ADVANCE(196);
      END_STATE();
    case 92:
      if (lookahead == 'h') ADVANCE(144);
      END_STATE();
    case 93:
      if (lookahead == 'i') ADVANCE(159);
      END_STATE();
    case 94:
      if (lookahead == 'i') ADVANCE(169);
      if (lookahead == 't') ADVANCE(50);
      if (lookahead == 'w') ADVANCE(93);
      END_STATE();
    case 95:
      if (lookahead == 'i') ADVANCE(90);
      if (lookahead == 'l') ADVANCE(131);
      END_STATE();
    case 96:
      if (lookahead == 'i') ADVANCE(62);
      END_STATE();
    case 97:
      if (lookahead == 'i') ADVANCE(607);
      END_STATE();
    case 98:
      if (lookahead == 'i') ADVANCE(57);
      END_STATE();
    case 99:
      if (lookahead == 'i') ADVANCE(133);
      END_STATE();
    case 100:
      if (lookahead == 'i') ADVANCE(77);
      END_STATE();
    case 101:
      if (lookahead == 'i') ADVANCE(156);
      END_STATE();
    case 102:
      if (lookahead == 'i') ADVANCE(121);
      END_STATE();
    case 103:
      if (lookahead == 'i') ADVANCE(126);
      END_STATE();
    case 104:
      if (lookahead == 'i') ADVANCE(149);
      END_STATE();
    case 105:
      if (lookahead == 'k') ADVANCE(196);
      END_STATE();
    case 106:
      if (lookahead == 'k') ADVANCE(72);
      END_STATE();
    case 107:
      if (lookahead == 'l') ADVANCE(196);
      END_STATE();
    case 108:
      if (lookahead == 'l') ADVANCE(146);
      END_STATE();
    case 109:
      if (lookahead == 'l') ADVANCE(146);
      if (lookahead == 'n') ADVANCE(164);
      if (lookahead == 'x') ADVANCE(135);
      END_STATE();
    case 110:
      if (lookahead == 'l') ADVANCE(62);
      END_STATE();
    case 111:
      if (lookahead == 'l') ADVANCE(210);
      END_STATE();
    case 112:
      if (lookahead == 'l') ADVANCE(606);
      END_STATE();
    case 113:
      if (lookahead == 'l') ADVANCE(605);
      END_STATE();
    case 114:
      if (lookahead == 'l') ADVANCE(65);
      END_STATE();
    case 115:
      if (lookahead == 'l') ADVANCE(111);
      END_STATE();
    case 116:
      if (lookahead == 'l') ADVANCE(132);
      END_STATE();
    case 117:
      if (lookahead == 'm') ADVANCE(196);
      END_STATE();
    case 118:
      if (lookahead == 'm') ADVANCE(56);
      END_STATE();
    case 119:
      if (lookahead == 'n') ADVANCE(196);
      END_STATE();
    case 120:
      if (lookahead == 'n') ADVANCE(62);
      END_STATE();
    case 121:
      if (lookahead == 'n') ADVANCE(165);
      END_STATE();
    case 122:
      if (lookahead == 'n') ADVANCE(150);
      END_STATE();
    case 123:
      if (lookahead == 'n') ADVANCE(65);
      END_STATE();
    case 124:
      if (lookahead == 'n') ADVANCE(155);
      END_STATE();
    case 125:
      if (lookahead == 'n') ADVANCE(101);
      END_STATE();
    case 126:
      if (lookahead == 'n') ADVANCE(97);
      END_STATE();
    case 127:
      if (lookahead == 'o') ADVANCE(88);
      END_STATE();
    case 128:
      if (lookahead == 'o') ADVANCE(129);
      if (lookahead == 'r') ADVANCE(75);
      END_STATE();
    case 129:
      if (lookahead == 'o') ADVANCE(107);
      END_STATE();
    case 130:
      if (lookahead == 'o') ADVANCE(143);
      END_STATE();
    case 131:
      if (lookahead == 'o') ADVANCE(57);
      END_STATE();
    case 132:
      if (lookahead == 'o') ADVANCE(60);
      END_STATE();
    case 133:
      if (lookahead == 'o') ADVANCE(119);
      END_STATE();
    case 134:
      if (lookahead == 'o') ADVANCE(112);
      END_STATE();
    case 135:
      if (lookahead == 'p') ADVANCE(130);
      END_STATE();
    case 136:
      if (lookahead == 'p') ADVANCE(65);
      END_STATE();
    case 137:
      if (lookahead == 'p') ADVANCE(76);
      END_STATE();
    case 138:
      if (lookahead == 'q') ADVANCE(165);
      END_STATE();
    case 139:
      if (lookahead == 'r') ADVANCE(196);
      END_STATE();
    case 140:
      if (lookahead == 'r') ADVANCE(165);
      if (lookahead == 'y') ADVANCE(136);
      END_STATE();
    case 141:
      if (lookahead == 'r') ADVANCE(89);
      END_STATE();
    case 142:
      if (lookahead == 'r') ADVANCE(119);
      END_STATE();
    case 143:
      if (lookahead == 'r') ADVANCE(153);
      END_STATE();
    case 144:
      if (lookahead == 'r') ADVANCE(78);
      END_STATE();
    case 145:
      if (lookahead == 's') ADVANCE(168);
      if (lookahead == 't') ADVANCE(92);
      END_STATE();
    case 146:
      if (lookahead == 's') ADVANCE(65);
      END_STATE();
    case 147:
      if (lookahead == 's') ADVANCE(73);
      if (lookahead == 't') ADVANCE(196);
      END_STATE();
    case 148:
      if (lookahead == 's') ADVANCE(157);
      END_STATE();
    case 149:
      if (lookahead == 's') ADVANCE(153);
      END_STATE();
    case 150:
      if (lookahead == 's') ADVANCE(153);
      if (lookahead == 't') ADVANCE(102);
      END_STATE();
    case 151:
      if (lookahead == 's') ADVANCE(79);
      END_STATE();
    case 152:
      if (lookahead == 's') ADVANCE(81);
      END_STATE();
    case 153:
      if (lookahead == 't') ADVANCE(196);
      END_STATE();
    case 154:
      if (lookahead == 't') ADVANCE(139);
      END_STATE();
    case 155:
      if (lookahead == 't') ADVANCE(214);
      END_STATE();
    case 156:
      if (lookahead == 't') ADVANCE(608);
      END_STATE();
    case 157:
      if (lookahead == 't') ADVANCE(609);
      END_STATE();
    case 158:
      if (lookahead == 't') ADVANCE(523);
      END_STATE();
    case 159:
      if (lookahead == 't') ADVANCE(59);
      END_STATE();
    case 160:
      if (lookahead == 't') ADVANCE(166);
      END_STATE();
    case 161:
      if (lookahead == 't') ADVANCE(65);
      END_STATE();
    case 162:
      if (lookahead == 't') ADVANCE(49);
      END_STATE();
    case 163:
      if (lookahead == 't') ADVANCE(98);
      END_STATE();
    case 164:
      if (lookahead == 'u') ADVANCE(117);
      END_STATE();
    case 165:
      if (lookahead == 'u') ADVANCE(65);
      END_STATE();
    case 166:
      if (lookahead == 'u') ADVANCE(142);
      END_STATE();
    case 167:
      if (lookahead == 'v') ADVANCE(67);
      END_STATE();
    case 168:
      if (lookahead == 'y') ADVANCE(118);
      END_STATE();
    case 169:
      if (lookahead == 'z') ADVANCE(65);
      END_STATE();
    case 170:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(179);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(173);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(544);
      END_STATE();
    case 171:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(180);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(537);
      END_STATE();
    case 172:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(181);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(535);
      END_STATE();
    case 173:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(173);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(548);
      END_STATE();
    case 174:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(172);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(174);
      END_STATE();
    case 175:
      if (lookahead == 'n' ||
          lookahead == 't') ADVANCE(196);
      END_STATE();
    case 176:
      if (lookahead == '0' ||
          lookahead == '1' ||
          lookahead == '_') ADVANCE(546);
      END_STATE();
    case 177:
      if (('0' <= lookahead && lookahead <= '8') ||
          lookahead == '_') ADVANCE(547);
      END_STATE();
    case 178:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(536);
      END_STATE();
    case 179:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(82);
      END_STATE();
    case 180:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(537);
      END_STATE();
    case 181:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(535);
      END_STATE();
    case 182:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(553);
      END_STATE();
    case 183:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(174);
      END_STATE();
    case 184:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(182);
      END_STATE();
    case 185:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(184);
      END_STATE();
    case 186:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(185);
      END_STATE();
    case 187:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(186);
      END_STATE();
    case 188:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(187);
      END_STATE();
    case 189:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(188);
      END_STATE();
    case 190:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(189);
      END_STATE();
    case 191:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(549);
      END_STATE();
    case 192:
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 193:
      if (lookahead != 0 &&
          lookahead != '`') ADVANCE(42);
      END_STATE();
    case 194:
      if (eof) ADVANCE(195);
      ADVANCE_MAP(
        '!', 513,
        '"', 555,
        '%', 575,
        '&', 572,
        '\'', 550,
        '(', 524,
        ')', 525,
        '*', 515,
        '+', 567,
        ',', 520,
        '-', 569,
        '.', 561,
        '/', 574,
        '0', 539,
        ':', 522,
        ';', 588,
        '<', 579,
        '=', 532,
        '>', 580,
        '?', 565,
        '@', 84,
        '[', 527,
        ']', 528,
        '^', 578,
        '_', 196,
        '`', 193,
        'a', 54,
        'b', 128,
        'c', 43,
        'd', 66,
        'e', 109,
        'f', 29,
        'i', 25,
        'l', 68,
        'm', 44,
        'n', 69,
        'o', 85,
        'r', 71,
        's', 94,
        't', 140,
        'u', 24,
        'v', 45,
        'y', 100,
        '{', 517,
        '|', 526,
        '}', 518,
        '~', 570,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(194);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(540);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_keyword);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'a') ADVANCE(429);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'a') ADVANCE(241);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(486);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(298);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'p') ADVANCE(497);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'p') ADVANCE(308);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 's') ADVANCE(439);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 's') ADVANCE(251);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'u') ADVANCE(432);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'u') ADVANCE(244);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == ':') ADVANCE(37);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == ':') ADVANCE(37);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'a') ADVANCE(332);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'a') ADVANCE(55);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'e') ADVANCE(139);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'e') ADVANCE(389);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'p') ADVANCE(400);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'p') ADVANCE(154);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 's') ADVANCE(73);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 's') ADVANCE(342);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'u') ADVANCE(335);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'u') ADVANCE(61);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(sym_keyword);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(sym_name);
      ADVANCE_MAP(
        '1', 231,
        '3', 225,
        '6', 229,
        '8', 208,
        ':', 37,
        'i', 288,
        'n', 271,
        's', 250,
      );
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym_name);
      ADVANCE_MAP(
        '1', 231,
        '3', 225,
        '6', 229,
        ':', 37,
        'n', 306,
        '8', 208,
        'f', 208,
        's', 208,
      );
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == '1') ADVANCE(230);
      if (lookahead == '3') ADVANCE(224);
      if (lookahead == '6') ADVANCE(228);
      if (lookahead == '8') ADVANCE(219);
      if (lookahead == 'i') ADVANCE(379);
      if (lookahead == 'n') ADVANCE(362);
      if (lookahead == 's') ADVANCE(337);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == '1') ADVANCE(230);
      if (lookahead == '3') ADVANCE(224);
      if (lookahead == '6') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(397);
      if (lookahead == '8' ||
          lookahead == 'f' ||
          lookahead == 's') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == '2') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == '2') ADVANCE(208);
      if (lookahead == ':') ADVANCE(37);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == '3') ADVANCE(225);
      if (lookahead == '6') ADVANCE(229);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'a') ADVANCE(276);
      if (lookahead == 'n') ADVANCE(208);
      if (lookahead == 'o') ADVANCE(298);
      if (lookahead == 'r') ADVANCE(254);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == '3') ADVANCE(224);
      if (lookahead == '6') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(368);
      if (lookahead == 'n') ADVANCE(219);
      if (lookahead == 'o') ADVANCE(389);
      if (lookahead == 'r') ADVANCE(345);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == '4') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == '4') ADVANCE(208);
      if (lookahead == ':') ADVANCE(37);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == '6') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == '6') ADVANCE(208);
      if (lookahead == ':') ADVANCE(37);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'a') ADVANCE(303);
      if (lookahead == 'o') ADVANCE(286);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'a') ADVANCE(309);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'a') ADVANCE(238);
      if (lookahead == 'o') ADVANCE(268);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'a') ADVANCE(297);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'a') ADVANCE(274);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'a') ADVANCE(302);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'a') ADVANCE(300);
      if (lookahead == 'e') ADVANCE(283);
      if (lookahead == 'l') ADVANCE(269);
      if (lookahead == 's') ADVANCE(314);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'a') ADVANCE(315);
      if (lookahead == 'r') ADVANCE(206);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'b') ADVANCE(290);
      if (lookahead == 'l') ADVANCE(267);
      if (lookahead == 'p') ADVANCE(296);
      if (lookahead == 's') ADVANCE(204);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'b') ADVANCE(280);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'c') ADVANCE(264);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'c') ADVANCE(208);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'c') ADVANCE(310);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'd') ADVANCE(208);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(260);
      if (lookahead == 'o') ADVANCE(287);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(298);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(321);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(319);
      if (lookahead == 'u') ADVANCE(281);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(208);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(302);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(312);
      if (lookahead == 'u') ADVANCE(287);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(236);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(250);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(283);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(277);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(310);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(313);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'f') ADVANCE(261);
      if (lookahead == 'p') ADVANCE(235);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'f') ADVANCE(200);
      if (lookahead == 'l') ADVANCE(258);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'f') ADVANCE(307);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'g') ADVANCE(208);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'g') ADVANCE(284);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'h') ADVANCE(208);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'i') ADVANCE(309);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'i') ADVANCE(320);
      if (lookahead == 't') ADVANCE(239);
      if (lookahead == 'w') ADVANCE(265);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'i') ADVANCE(263);
      if (lookahead == 'l') ADVANCE(291);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'i') ADVANCE(245);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'i') ADVANCE(305);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'i') ADVANCE(243);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'i') ADVANCE(293);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'i') ADVANCE(256);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'i') ADVANCE(285);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'k') ADVANCE(208);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'l') ADVANCE(303);
      if (lookahead == 'n') ADVANCE(316);
      if (lookahead == 'x') ADVANCE(294);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'l') ADVANCE(303);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'l') ADVANCE(245);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'l') ADVANCE(208);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'l') ADVANCE(198);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'l') ADVANCE(250);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'l') ADVANCE(279);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'm') ADVANCE(208);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'n') ADVANCE(245);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'n') ADVANCE(208);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'n') ADVANCE(317);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'n') ADVANCE(304);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'n') ADVANCE(250);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'n') ADVANCE(311);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'o') ADVANCE(292);
      if (lookahead == 'r') ADVANCE(253);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'o') ADVANCE(302);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'o') ADVANCE(243);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'o') ADVANCE(278);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'o') ADVANCE(284);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'p') ADVANCE(290);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'p') ADVANCE(250);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'p') ADVANCE(255);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'q') ADVANCE(317);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'r') ADVANCE(208);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'r') ADVANCE(317);
      if (lookahead == 'y') ADVANCE(295);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'r') ADVANCE(262);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'r') ADVANCE(284);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'r') ADVANCE(310);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 's') ADVANCE(250);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 's') ADVANCE(310);
      if (lookahead == 't') ADVANCE(273);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 's') ADVANCE(310);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 's') ADVANCE(251);
      if (lookahead == 't') ADVANCE(208);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 's') ADVANCE(257);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 't') ADVANCE(298);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 't') ADVANCE(242);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 't') ADVANCE(208);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 't') ADVANCE(202);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 't') ADVANCE(318);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 't') ADVANCE(250);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 't') ADVANCE(237);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 't') ADVANCE(270);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'u') ADVANCE(282);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'u') ADVANCE(250);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'u') ADVANCE(301);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'v') ADVANCE(247);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'z') ADVANCE(250);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(322);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'n' ||
          lookahead == 't') ADVANCE(208);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(37);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(322);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'a') ADVANCE(394);
      if (lookahead == 'o') ADVANCE(377);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'a') ADVANCE(401);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'a') ADVANCE(329);
      if (lookahead == 'o') ADVANCE(359);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'a') ADVANCE(388);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'a') ADVANCE(365);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'a') ADVANCE(393);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'a') ADVANCE(391);
      if (lookahead == 'e') ADVANCE(375);
      if (lookahead == 'l') ADVANCE(360);
      if (lookahead == 's') ADVANCE(405);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'a') ADVANCE(406);
      if (lookahead == 'r') ADVANCE(217);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'b') ADVANCE(381);
      if (lookahead == 'l') ADVANCE(358);
      if (lookahead == 'p') ADVANCE(387);
      if (lookahead == 's') ADVANCE(216);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'b') ADVANCE(371);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'c') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'c') ADVANCE(355);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'c') ADVANCE(399);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'd') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(351);
      if (lookahead == 'o') ADVANCE(378);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(389);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(412);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(410);
      if (lookahead == 'u') ADVANCE(372);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(393);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(403);
      if (lookahead == 'u') ADVANCE(378);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(327);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(337);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(375);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(369);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(399);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(404);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'f') ADVANCE(352);
      if (lookahead == 'p') ADVANCE(326);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'f') ADVANCE(212);
      if (lookahead == 'l') ADVANCE(349);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'f') ADVANCE(398);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'g') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'g') ADVANCE(374);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'h') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'i') ADVANCE(401);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'i') ADVANCE(411);
      if (lookahead == 't') ADVANCE(330);
      if (lookahead == 'w') ADVANCE(356);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'i') ADVANCE(354);
      if (lookahead == 'l') ADVANCE(382);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'i') ADVANCE(336);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'i') ADVANCE(396);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'i') ADVANCE(333);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'i') ADVANCE(384);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'i') ADVANCE(347);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'i') ADVANCE(376);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'k') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'l') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'l') ADVANCE(394);
      if (lookahead == 'n') ADVANCE(407);
      if (lookahead == 'x') ADVANCE(385);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'l') ADVANCE(394);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'l') ADVANCE(336);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'l') ADVANCE(209);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'l') ADVANCE(337);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'l') ADVANCE(370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'm') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'n') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'n') ADVANCE(336);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'n') ADVANCE(408);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'n') ADVANCE(395);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'n') ADVANCE(337);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'n') ADVANCE(402);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'o') ADVANCE(383);
      if (lookahead == 'r') ADVANCE(344);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'o') ADVANCE(393);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'o') ADVANCE(333);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'o') ADVANCE(366);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'o') ADVANCE(374);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'p') ADVANCE(381);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'p') ADVANCE(337);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'p') ADVANCE(346);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'q') ADVANCE(408);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'r') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'r') ADVANCE(408);
      if (lookahead == 'y') ADVANCE(386);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'r') ADVANCE(353);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'r') ADVANCE(374);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'r') ADVANCE(399);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 's') ADVANCE(337);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 's') ADVANCE(399);
      if (lookahead == 't') ADVANCE(364);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 's') ADVANCE(399);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 's') ADVANCE(342);
      if (lookahead == 't') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 's') ADVANCE(348);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 't') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 't') ADVANCE(389);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 't') ADVANCE(334);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 't') ADVANCE(213);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 't') ADVANCE(409);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 't') ADVANCE(337);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 't') ADVANCE(328);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 't') ADVANCE(361);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'u') ADVANCE(373);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'u') ADVANCE(337);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'u') ADVANCE(392);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'v') ADVANCE(339);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'z') ADVANCE(337);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(413);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'n' ||
          lookahead == 't') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(sym_name);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(413);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(sym_identifier);
      ADVANCE_MAP(
        '1', 419,
        '3', 416,
        '6', 418,
        '8', 207,
        ':', 37,
        'i', 476,
        'n', 459,
        's', 434,
      );
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(sym_identifier);
      ADVANCE_MAP(
        '1', 419,
        '3', 416,
        '6', 418,
        ':', 37,
        'n', 494,
        '8', 207,
        'f', 207,
        's', 207,
      );
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '2') ADVANCE(207);
      if (lookahead == ':') ADVANCE(37);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '3') ADVANCE(416);
      if (lookahead == '6') ADVANCE(418);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'a') ADVANCE(465);
      if (lookahead == 'n') ADVANCE(207);
      if (lookahead == 'o') ADVANCE(486);
      if (lookahead == 'r') ADVANCE(442);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '4') ADVANCE(207);
      if (lookahead == ':') ADVANCE(37);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '6') ADVANCE(207);
      if (lookahead == ':') ADVANCE(37);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'a') ADVANCE(491);
      if (lookahead == 'o') ADVANCE(474);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'a') ADVANCE(498);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'a') ADVANCE(426);
      if (lookahead == 'o') ADVANCE(456);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'a') ADVANCE(485);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'a') ADVANCE(462);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'a') ADVANCE(490);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'a') ADVANCE(488);
      if (lookahead == 'e') ADVANCE(472);
      if (lookahead == 'l') ADVANCE(457);
      if (lookahead == 's') ADVANCE(502);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'a') ADVANCE(503);
      if (lookahead == 'r') ADVANCE(205);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'b') ADVANCE(478);
      if (lookahead == 'l') ADVANCE(455);
      if (lookahead == 'p') ADVANCE(484);
      if (lookahead == 's') ADVANCE(203);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'b') ADVANCE(468);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'c') ADVANCE(207);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'c') ADVANCE(452);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'c') ADVANCE(496);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'd') ADVANCE(207);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(207);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(448);
      if (lookahead == 'o') ADVANCE(475);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(486);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 437:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(509);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(507);
      if (lookahead == 'u') ADVANCE(469);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(490);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(500);
      if (lookahead == 'u') ADVANCE(475);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 441:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(424);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(434);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(472);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(466);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(496);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(501);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'f') ADVANCE(449);
      if (lookahead == 'p') ADVANCE(423);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'f') ADVANCE(199);
      if (lookahead == 'l') ADVANCE(446);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'f') ADVANCE(495);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'g') ADVANCE(207);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'g') ADVANCE(471);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'h') ADVANCE(207);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'i') ADVANCE(498);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'i') ADVANCE(508);
      if (lookahead == 't') ADVANCE(427);
      if (lookahead == 'w') ADVANCE(453);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'i') ADVANCE(451);
      if (lookahead == 'l') ADVANCE(479);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'i') ADVANCE(433);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 457:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'i') ADVANCE(493);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 458:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'i') ADVANCE(430);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 459:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'i') ADVANCE(481);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 460:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'i') ADVANCE(444);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 461:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'i') ADVANCE(473);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 462:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'k') ADVANCE(207);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'l') ADVANCE(207);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 464:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'l') ADVANCE(491);
      if (lookahead == 'n') ADVANCE(504);
      if (lookahead == 'x') ADVANCE(482);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 465:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'l') ADVANCE(491);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 466:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'l') ADVANCE(433);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 467:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'l') ADVANCE(197);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 468:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'l') ADVANCE(434);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'l') ADVANCE(467);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 470:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'm') ADVANCE(207);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 471:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'n') ADVANCE(207);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 472:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'n') ADVANCE(433);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 473:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'n') ADVANCE(505);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 474:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'n') ADVANCE(492);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 475:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'n') ADVANCE(434);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 476:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'n') ADVANCE(499);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 477:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'o') ADVANCE(480);
      if (lookahead == 'r') ADVANCE(441);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 478:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'o') ADVANCE(490);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 479:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'o') ADVANCE(430);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 480:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'o') ADVANCE(463);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 481:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'o') ADVANCE(471);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 482:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'p') ADVANCE(478);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 483:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'p') ADVANCE(434);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 484:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'p') ADVANCE(443);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 485:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'q') ADVANCE(505);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 486:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'r') ADVANCE(207);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 487:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'r') ADVANCE(505);
      if (lookahead == 'y') ADVANCE(483);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 488:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'r') ADVANCE(450);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 489:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'r') ADVANCE(471);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 490:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'r') ADVANCE(496);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 491:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 's') ADVANCE(434);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 492:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 's') ADVANCE(496);
      if (lookahead == 't') ADVANCE(461);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 493:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 's') ADVANCE(496);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 494:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 's') ADVANCE(439);
      if (lookahead == 't') ADVANCE(207);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 495:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 's') ADVANCE(445);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 496:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 't') ADVANCE(207);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 497:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 't') ADVANCE(486);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 498:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 't') ADVANCE(431);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 499:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 't') ADVANCE(201);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 500:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 't') ADVANCE(506);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 501:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 't') ADVANCE(434);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 502:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 't') ADVANCE(425);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 503:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 't') ADVANCE(458);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 504:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'u') ADVANCE(470);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 505:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'u') ADVANCE(434);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 506:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'u') ADVANCE(489);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 507:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'v') ADVANCE(436);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 508:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'z') ADVANCE(434);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(510);
      END_STATE();
    case 509:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (lookahead == 'n' ||
          lookahead == 't') ADVANCE(207);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 510:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(37);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(510);
      END_STATE();
    case 511:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(511);
      END_STATE();
    case 512:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 513:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(584);
      END_STATE();
    case 514:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 515:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(593);
      END_STATE();
    case 516:
      ACCEPT_TOKEN(anon_sym_ATpacked);
      END_STATE();
    case 517:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 518:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 519:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 520:
      ACCEPT_TOKEN(anon_sym_COMMA);
      if (lookahead == ' ') ADVANCE(604);
      END_STATE();
    case 521:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 522:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(610);
      END_STATE();
    case 523:
      ACCEPT_TOKEN(anon_sym_AToffset);
      END_STATE();
    case 524:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 525:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 526:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(599);
      if (lookahead == '|') ADVANCE(587);
      END_STATE();
    case 527:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 528:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 529:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 530:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 531:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(583);
      END_STATE();
    case 532:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(583);
      if (lookahead == '>') ADVANCE(590);
      END_STATE();
    case 533:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(590);
      END_STATE();
    case 534:
      ACCEPT_TOKEN(sym_floating_literal);
      END_STATE();
    case 535:
      ACCEPT_TOKEN(sym_floating_literal);
      if (lookahead == 'f') ADVANCE(30);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(535);
      END_STATE();
    case 536:
      ACCEPT_TOKEN(sym_floating_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(171);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(536);
      END_STATE();
    case 537:
      ACCEPT_TOKEN(sym_floating_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(537);
      END_STATE();
    case 538:
      ACCEPT_TOKEN(sym_integer_literal);
      END_STATE();
    case 539:
      ACCEPT_TOKEN(sym_integer_literal);
      ADVANCE_MAP(
        '.', 178,
        'b', 176,
        'f', 30,
        'i', 542,
        'o', 177,
        'u', 542,
        'x', 41,
        'z', 538,
        'E', 170,
        'e', 170,
      );
      END_STATE();
    case 540:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == '.') ADVANCE(178);
      if (lookahead == 'f') ADVANCE(30);
      if (lookahead == 'i') ADVANCE(542);
      if (lookahead == 'u') ADVANCE(542);
      if (lookahead == 'z') ADVANCE(538);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(170);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(540);
      END_STATE();
    case 541:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == '.') ADVANCE(183);
      if (lookahead == '_') ADVANCE(549);
      if (lookahead == 'i') ADVANCE(542);
      if (lookahead == 'u') ADVANCE(542);
      if (lookahead == 'z') ADVANCE(538);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(172);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(541);
      END_STATE();
    case 542:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == '1') ADVANCE(35);
      if (lookahead == '3') ADVANCE(27);
      if (lookahead == '6') ADVANCE(32);
      if (lookahead == '8') ADVANCE(538);
      END_STATE();
    case 543:
      ACCEPT_TOKEN(sym_integer_literal);
      ADVANCE_MAP(
        'b', 176,
        'i', 542,
        'o', 177,
        'u', 542,
        'x', 191,
        'z', 538,
        'E', 173,
        'e', 173,
      );
      END_STATE();
    case 544:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == 'f') ADVANCE(30);
      if (lookahead == 'i') ADVANCE(542);
      if (lookahead == 'u') ADVANCE(542);
      if (lookahead == 'z') ADVANCE(538);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(544);
      END_STATE();
    case 545:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == 'i') ADVANCE(542);
      if (lookahead == 'u') ADVANCE(542);
      if (lookahead == 'z') ADVANCE(538);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(173);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(545);
      END_STATE();
    case 546:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == 'i') ADVANCE(542);
      if (lookahead == 'u') ADVANCE(542);
      if (lookahead == 'z') ADVANCE(538);
      if (lookahead == '0' ||
          lookahead == '1' ||
          lookahead == '_') ADVANCE(546);
      END_STATE();
    case 547:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == 'i') ADVANCE(542);
      if (lookahead == 'u') ADVANCE(542);
      if (lookahead == 'z') ADVANCE(538);
      if (('0' <= lookahead && lookahead <= '8') ||
          lookahead == '_') ADVANCE(547);
      END_STATE();
    case 548:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == 'i') ADVANCE(542);
      if (lookahead == 'u') ADVANCE(542);
      if (lookahead == 'z') ADVANCE(538);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(548);
      END_STATE();
    case 549:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == 'i') ADVANCE(542);
      if (lookahead == 'u') ADVANCE(542);
      if (lookahead == 'z') ADVANCE(538);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(549);
      END_STATE();
    case 550:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 551:
      ACCEPT_TOKEN(aux_sym_rune_literal_token1);
      END_STATE();
    case 552:
      ACCEPT_TOKEN(anon_sym_SQUOTE2);
      END_STATE();
    case 553:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 554:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      END_STATE();
    case 555:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 556:
      ACCEPT_TOKEN(aux_sym_string_literal_token2);
      if (lookahead == '\n') ADVANCE(559);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(556);
      END_STATE();
    case 557:
      ACCEPT_TOKEN(aux_sym_string_literal_token2);
      if (lookahead == '/') ADVANCE(558);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(557);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(559);
      END_STATE();
    case 558:
      ACCEPT_TOKEN(aux_sym_string_literal_token2);
      if (lookahead == '/') ADVANCE(556);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(559);
      END_STATE();
    case 559:
      ACCEPT_TOKEN(aux_sym_string_literal_token2);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(559);
      END_STATE();
    case 560:
      ACCEPT_TOKEN(anon_sym_DQUOTE2);
      END_STATE();
    case 561:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(564);
      END_STATE();
    case 562:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(563);
      END_STATE();
    case 563:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 564:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      if (lookahead == '.') ADVANCE(529);
      END_STATE();
    case 565:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 566:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 567:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(591);
      END_STATE();
    case 568:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 569:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(592);
      END_STATE();
    case 570:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 571:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 572:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(585);
      if (lookahead == '.') ADVANCE(16);
      if (lookahead == '=') ADVANCE(598);
      END_STATE();
    case 573:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(585);
      if (lookahead == '=') ADVANCE(598);
      END_STATE();
    case 574:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(511);
      if (lookahead == '=') ADVANCE(594);
      END_STATE();
    case 575:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(595);
      END_STATE();
    case 576:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(596);
      END_STATE();
    case 577:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(597);
      END_STATE();
    case 578:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(600);
      if (lookahead == '^') ADVANCE(586);
      END_STATE();
    case 579:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(576);
      if (lookahead == '=') ADVANCE(581);
      END_STATE();
    case 580:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(582);
      if (lookahead == '>') ADVANCE(577);
      END_STATE();
    case 581:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 582:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 583:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 584:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 585:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      if (lookahead == '=') ADVANCE(601);
      END_STATE();
    case 586:
      ACCEPT_TOKEN(anon_sym_CARET_CARET);
      if (lookahead == '=') ADVANCE(603);
      END_STATE();
    case 587:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      if (lookahead == '=') ADVANCE(602);
      END_STATE();
    case 588:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 589:
      ACCEPT_TOKEN(anon_sym_AMP_DOT_DOT);
      END_STATE();
    case 590:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 591:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 592:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 593:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 594:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 595:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 596:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 597:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 598:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 599:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 600:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 601:
      ACCEPT_TOKEN(anon_sym_AMP_AMP_EQ);
      END_STATE();
    case 602:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE_EQ);
      END_STATE();
    case 603:
      ACCEPT_TOKEN(anon_sym_CARET_CARET_EQ);
      END_STATE();
    case 604:
      ACCEPT_TOKEN(anon_sym_COMMA2);
      END_STATE();
    case 605:
      ACCEPT_TOKEN(anon_sym_ATthreadlocal);
      END_STATE();
    case 606:
      ACCEPT_TOKEN(anon_sym_ATsymbol);
      END_STATE();
    case 607:
      ACCEPT_TOKEN(anon_sym_ATfini);
      END_STATE();
    case 608:
      ACCEPT_TOKEN(anon_sym_ATinit);
      END_STATE();
    case 609:
      ACCEPT_TOKEN(anon_sym_ATtest);
      END_STATE();
    case 610:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        '_', 1,
        'a', 2,
        'b', 3,
        'c', 4,
        'd', 5,
        'e', 6,
        'f', 7,
        'i', 8,
        'l', 9,
        'm', 10,
        'n', 11,
        'o', 12,
        'r', 13,
        's', 14,
        't', 15,
        'u', 16,
        'v', 17,
        'y', 18,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      ACCEPT_TOKEN(anon_sym__);
      END_STATE();
    case 2:
      if (lookahead == 'b') ADVANCE(19);
      if (lookahead == 'l') ADVANCE(20);
      if (lookahead == 'p') ADVANCE(21);
      if (lookahead == 's') ADVANCE(22);
      END_STATE();
    case 3:
      if (lookahead == 'o') ADVANCE(23);
      if (lookahead == 'r') ADVANCE(24);
      END_STATE();
    case 4:
      if (lookahead == 'a') ADVANCE(25);
      if (lookahead == 'o') ADVANCE(26);
      END_STATE();
    case 5:
      if (lookahead == 'e') ADVANCE(27);
      if (lookahead == 'o') ADVANCE(28);
      END_STATE();
    case 6:
      if (lookahead == 'l') ADVANCE(29);
      if (lookahead == 'n') ADVANCE(30);
      if (lookahead == 'x') ADVANCE(31);
      END_STATE();
    case 7:
      if (lookahead == '3') ADVANCE(32);
      if (lookahead == '6') ADVANCE(33);
      if (lookahead == 'a') ADVANCE(34);
      if (lookahead == 'n') ADVANCE(35);
      if (lookahead == 'o') ADVANCE(36);
      if (lookahead == 'r') ADVANCE(37);
      END_STATE();
    case 8:
      if (lookahead == '1') ADVANCE(38);
      if (lookahead == '3') ADVANCE(39);
      if (lookahead == '6') ADVANCE(40);
      if (lookahead == '8') ADVANCE(41);
      if (lookahead == 'f') ADVANCE(42);
      if (lookahead == 'n') ADVANCE(43);
      if (lookahead == 's') ADVANCE(44);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(45);
      END_STATE();
    case 10:
      if (lookahead == 'a') ADVANCE(46);
      END_STATE();
    case 11:
      if (lookahead == 'e') ADVANCE(47);
      if (lookahead == 'u') ADVANCE(48);
      END_STATE();
    case 12:
      if (lookahead == 'f') ADVANCE(49);
      if (lookahead == 'p') ADVANCE(50);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(51);
      if (lookahead == 'u') ADVANCE(52);
      END_STATE();
    case 14:
      if (lookahead == 'i') ADVANCE(53);
      if (lookahead == 't') ADVANCE(54);
      if (lookahead == 'w') ADVANCE(55);
      END_STATE();
    case 15:
      if (lookahead == 'r') ADVANCE(56);
      if (lookahead == 'y') ADVANCE(57);
      END_STATE();
    case 16:
      if (lookahead == '1') ADVANCE(58);
      if (lookahead == '3') ADVANCE(59);
      if (lookahead == '6') ADVANCE(60);
      if (lookahead == '8') ADVANCE(61);
      if (lookahead == 'i') ADVANCE(62);
      if (lookahead == 'n') ADVANCE(63);
      if (lookahead == 's') ADVANCE(64);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(65);
      if (lookahead == 'o') ADVANCE(66);
      END_STATE();
    case 18:
      if (lookahead == 'i') ADVANCE(67);
      END_STATE();
    case 19:
      if (lookahead == 'o') ADVANCE(68);
      END_STATE();
    case 20:
      if (lookahead == 'i') ADVANCE(69);
      if (lookahead == 'l') ADVANCE(70);
      END_STATE();
    case 21:
      if (lookahead == 'p') ADVANCE(71);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(72);
      END_STATE();
    case 23:
      if (lookahead == 'o') ADVANCE(73);
      END_STATE();
    case 24:
      if (lookahead == 'e') ADVANCE(74);
      END_STATE();
    case 25:
      if (lookahead == 's') ADVANCE(75);
      END_STATE();
    case 26:
      if (lookahead == 'n') ADVANCE(76);
      END_STATE();
    case 27:
      if (lookahead == 'f') ADVANCE(77);
      if (lookahead == 'l') ADVANCE(78);
      END_STATE();
    case 28:
      if (lookahead == 'n') ADVANCE(79);
      END_STATE();
    case 29:
      if (lookahead == 's') ADVANCE(80);
      END_STATE();
    case 30:
      if (lookahead == 'u') ADVANCE(81);
      END_STATE();
    case 31:
      if (lookahead == 'p') ADVANCE(82);
      END_STATE();
    case 32:
      if (lookahead == '2') ADVANCE(83);
      END_STATE();
    case 33:
      if (lookahead == '4') ADVANCE(84);
      END_STATE();
    case 34:
      if (lookahead == 'l') ADVANCE(85);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_fn);
      END_STATE();
    case 36:
      if (lookahead == 'r') ADVANCE(86);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(87);
      END_STATE();
    case 38:
      if (lookahead == '6') ADVANCE(88);
      END_STATE();
    case 39:
      if (lookahead == '2') ADVANCE(89);
      END_STATE();
    case 40:
      if (lookahead == '4') ADVANCE(90);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_i8);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 43:
      if (lookahead == 's') ADVANCE(91);
      if (lookahead == 't') ADVANCE(92);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 45:
      if (lookahead == 'n') ADVANCE(93);
      if (lookahead == 't') ADVANCE(94);
      END_STATE();
    case 46:
      if (lookahead == 't') ADVANCE(95);
      END_STATE();
    case 47:
      if (lookahead == 'v') ADVANCE(96);
      END_STATE();
    case 48:
      if (lookahead == 'l') ADVANCE(97);
      END_STATE();
    case 49:
      if (lookahead == 'f') ADVANCE(98);
      END_STATE();
    case 50:
      if (lookahead == 'a') ADVANCE(99);
      END_STATE();
    case 51:
      if (lookahead == 't') ADVANCE(100);
      END_STATE();
    case 52:
      if (lookahead == 'n') ADVANCE(101);
      END_STATE();
    case 53:
      if (lookahead == 'z') ADVANCE(102);
      END_STATE();
    case 54:
      if (lookahead == 'a') ADVANCE(103);
      if (lookahead == 'r') ADVANCE(104);
      END_STATE();
    case 55:
      if (lookahead == 'i') ADVANCE(105);
      END_STATE();
    case 56:
      if (lookahead == 'u') ADVANCE(106);
      END_STATE();
    case 57:
      if (lookahead == 'p') ADVANCE(107);
      END_STATE();
    case 58:
      if (lookahead == '6') ADVANCE(108);
      END_STATE();
    case 59:
      if (lookahead == '2') ADVANCE(109);
      END_STATE();
    case 60:
      if (lookahead == '4') ADVANCE(110);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_u8);
      END_STATE();
    case 62:
      if (lookahead == 'n') ADVANCE(111);
      END_STATE();
    case 63:
      if (lookahead == 'i') ADVANCE(112);
      END_STATE();
    case 64:
      if (lookahead == 'e') ADVANCE(113);
      END_STATE();
    case 65:
      if (lookahead == 'a') ADVANCE(114);
      if (lookahead == 'e') ADVANCE(115);
      if (lookahead == 'l') ADVANCE(116);
      if (lookahead == 's') ADVANCE(117);
      END_STATE();
    case 66:
      if (lookahead == 'i') ADVANCE(118);
      END_STATE();
    case 67:
      if (lookahead == 'e') ADVANCE(119);
      END_STATE();
    case 68:
      if (lookahead == 'r') ADVANCE(120);
      END_STATE();
    case 69:
      if (lookahead == 'g') ADVANCE(121);
      END_STATE();
    case 70:
      if (lookahead == 'o') ADVANCE(122);
      END_STATE();
    case 71:
      if (lookahead == 'e') ADVANCE(123);
      END_STATE();
    case 72:
      if (lookahead == 'e') ADVANCE(124);
      END_STATE();
    case 73:
      if (lookahead == 'l') ADVANCE(125);
      END_STATE();
    case 74:
      if (lookahead == 'a') ADVANCE(126);
      END_STATE();
    case 75:
      if (lookahead == 'e') ADVANCE(127);
      END_STATE();
    case 76:
      if (lookahead == 's') ADVANCE(128);
      if (lookahead == 't') ADVANCE(129);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_def);
      if (lookahead == 'e') ADVANCE(130);
      END_STATE();
    case 78:
      if (lookahead == 'e') ADVANCE(131);
      END_STATE();
    case 79:
      if (lookahead == 'e') ADVANCE(132);
      END_STATE();
    case 80:
      if (lookahead == 'e') ADVANCE(133);
      END_STATE();
    case 81:
      if (lookahead == 'm') ADVANCE(134);
      END_STATE();
    case 82:
      if (lookahead == 'o') ADVANCE(135);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_f32);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_f64);
      END_STATE();
    case 85:
      if (lookahead == 's') ADVANCE(136);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 87:
      if (lookahead == 'e') ADVANCE(137);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_i16);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_i32);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_i64);
      END_STATE();
    case 91:
      if (lookahead == 'e') ADVANCE(138);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_int);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_len);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 95:
      if (lookahead == 'c') ADVANCE(139);
      END_STATE();
    case 96:
      if (lookahead == 'e') ADVANCE(140);
      END_STATE();
    case 97:
      if (lookahead == 'l') ADVANCE(141);
      END_STATE();
    case 98:
      if (lookahead == 's') ADVANCE(142);
      END_STATE();
    case 99:
      if (lookahead == 'q') ADVANCE(143);
      END_STATE();
    case 100:
      if (lookahead == 'u') ADVANCE(144);
      END_STATE();
    case 101:
      if (lookahead == 'e') ADVANCE(145);
      END_STATE();
    case 102:
      if (lookahead == 'e') ADVANCE(146);
      END_STATE();
    case 103:
      if (lookahead == 't') ADVANCE(147);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym__string_type);
      if (lookahead == 'u') ADVANCE(148);
      END_STATE();
    case 105:
      if (lookahead == 't') ADVANCE(149);
      END_STATE();
    case 106:
      if (lookahead == 'e') ADVANCE(150);
      END_STATE();
    case 107:
      if (lookahead == 'e') ADVANCE(151);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_u16);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_u32);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_u64);
      END_STATE();
    case 111:
      if (lookahead == 't') ADVANCE(152);
      END_STATE();
    case 112:
      if (lookahead == 'o') ADVANCE(153);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_use);
      END_STATE();
    case 114:
      if (lookahead == 'r') ADVANCE(154);
      END_STATE();
    case 115:
      if (lookahead == 'n') ADVANCE(155);
      END_STATE();
    case 116:
      if (lookahead == 'i') ADVANCE(156);
      END_STATE();
    case 117:
      if (lookahead == 't') ADVANCE(157);
      END_STATE();
    case 118:
      if (lookahead == 'd') ADVANCE(158);
      END_STATE();
    case 119:
      if (lookahead == 'l') ADVANCE(159);
      END_STATE();
    case 120:
      if (lookahead == 't') ADVANCE(160);
      END_STATE();
    case 121:
      if (lookahead == 'n') ADVANCE(161);
      END_STATE();
    case 122:
      if (lookahead == 'c') ADVANCE(162);
      END_STATE();
    case 123:
      if (lookahead == 'n') ADVANCE(163);
      END_STATE();
    case 124:
      if (lookahead == 'r') ADVANCE(164);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_bool);
      END_STATE();
    case 126:
      if (lookahead == 'k') ADVANCE(165);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 128:
      if (lookahead == 't') ADVANCE(166);
      END_STATE();
    case 129:
      if (lookahead == 'i') ADVANCE(167);
      END_STATE();
    case 130:
      if (lookahead == 'r') ADVANCE(168);
      END_STATE();
    case 131:
      if (lookahead == 't') ADVANCE(169);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_done);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 135:
      if (lookahead == 'r') ADVANCE(170);
      END_STATE();
    case 136:
      if (lookahead == 'e') ADVANCE(171);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_free);
      END_STATE();
    case 138:
      if (lookahead == 'r') ADVANCE(172);
      END_STATE();
    case 139:
      if (lookahead == 'h') ADVANCE(173);
      END_STATE();
    case 140:
      if (lookahead == 'r') ADVANCE(174);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_null);
      if (lookahead == 'a') ADVANCE(175);
      END_STATE();
    case 142:
      if (lookahead == 'e') ADVANCE(176);
      END_STATE();
    case 143:
      if (lookahead == 'u') ADVANCE(177);
      END_STATE();
    case 144:
      if (lookahead == 'r') ADVANCE(178);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_rune);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_size);
      END_STATE();
    case 147:
      if (lookahead == 'i') ADVANCE(179);
      END_STATE();
    case 148:
      if (lookahead == 'c') ADVANCE(180);
      END_STATE();
    case 149:
      if (lookahead == 'c') ADVANCE(181);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_uint);
      if (lookahead == 'p') ADVANCE(182);
      END_STATE();
    case 153:
      if (lookahead == 'n') ADVANCE(183);
      END_STATE();
    case 154:
      if (lookahead == 'g') ADVANCE(184);
      END_STATE();
    case 155:
      if (lookahead == 'd') ADVANCE(185);
      END_STATE();
    case 156:
      if (lookahead == 's') ADVANCE(186);
      END_STATE();
    case 157:
      if (lookahead == 'a') ADVANCE(187);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_void);
      END_STATE();
    case 159:
      if (lookahead == 'd') ADVANCE(188);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_abort);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_align);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_alloc);
      END_STATE();
    case 163:
      if (lookahead == 'd') ADVANCE(189);
      END_STATE();
    case 164:
      if (lookahead == 't') ADVANCE(190);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 167:
      if (lookahead == 'n') ADVANCE(191);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_defer);
      END_STATE();
    case 169:
      if (lookahead == 'e') ADVANCE(192);
      END_STATE();
    case 170:
      if (lookahead == 't') ADVANCE(193);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 172:
      if (lookahead == 't') ADVANCE(194);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_match);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_never);
      END_STATE();
    case 175:
      if (lookahead == 'b') ADVANCE(195);
      END_STATE();
    case 176:
      if (lookahead == 't') ADVANCE(196);
      END_STATE();
    case 177:
      if (lookahead == 'e') ADVANCE(197);
      END_STATE();
    case 178:
      if (lookahead == 'n') ADVANCE(198);
      END_STATE();
    case 179:
      if (lookahead == 'c') ADVANCE(199);
      END_STATE();
    case 180:
      if (lookahead == 't') ADVANCE(200);
      END_STATE();
    case 181:
      if (lookahead == 'h') ADVANCE(201);
      END_STATE();
    case 182:
      if (lookahead == 't') ADVANCE(202);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_union);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_vaarg);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_vaend);
      END_STATE();
    case 186:
      if (lookahead == 't') ADVANCE(203);
      END_STATE();
    case 187:
      if (lookahead == 'r') ADVANCE(204);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_append);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 191:
      if (lookahead == 'u') ADVANCE(205);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_delete);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_insert);
      END_STATE();
    case 195:
      if (lookahead == 'l') ADVANCE(206);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_offset);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_opaque);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 202:
      if (lookahead == 'r') ADVANCE(207);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_valist);
      END_STATE();
    case 204:
      if (lookahead == 't') ADVANCE(208);
      END_STATE();
    case 205:
      if (lookahead == 'e') ADVANCE(209);
      END_STATE();
    case 206:
      if (lookahead == 'e') ADVANCE(210);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_uintptr);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_vastart);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_nullable);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 1},
  [3] = {.lex_state = 1},
  [4] = {.lex_state = 1},
  [5] = {.lex_state = 1},
  [6] = {.lex_state = 4},
  [7] = {.lex_state = 4},
  [8] = {.lex_state = 4},
  [9] = {.lex_state = 4},
  [10] = {.lex_state = 4},
  [11] = {.lex_state = 4},
  [12] = {.lex_state = 4},
  [13] = {.lex_state = 4},
  [14] = {.lex_state = 4},
  [15] = {.lex_state = 4},
  [16] = {.lex_state = 4},
  [17] = {.lex_state = 4},
  [18] = {.lex_state = 4},
  [19] = {.lex_state = 5},
  [20] = {.lex_state = 5},
  [21] = {.lex_state = 4},
  [22] = {.lex_state = 4},
  [23] = {.lex_state = 4},
  [24] = {.lex_state = 4},
  [25] = {.lex_state = 4},
  [26] = {.lex_state = 4},
  [27] = {.lex_state = 4},
  [28] = {.lex_state = 4},
  [29] = {.lex_state = 4},
  [30] = {.lex_state = 4},
  [31] = {.lex_state = 4},
  [32] = {.lex_state = 4},
  [33] = {.lex_state = 4},
  [34] = {.lex_state = 4},
  [35] = {.lex_state = 4},
  [36] = {.lex_state = 4},
  [37] = {.lex_state = 4},
  [38] = {.lex_state = 4},
  [39] = {.lex_state = 4},
  [40] = {.lex_state = 4},
  [41] = {.lex_state = 4},
  [42] = {.lex_state = 4},
  [43] = {.lex_state = 4},
  [44] = {.lex_state = 4},
  [45] = {.lex_state = 4},
  [46] = {.lex_state = 4},
  [47] = {.lex_state = 4},
  [48] = {.lex_state = 4},
  [49] = {.lex_state = 4},
  [50] = {.lex_state = 4},
  [51] = {.lex_state = 4},
  [52] = {.lex_state = 4},
  [53] = {.lex_state = 4},
  [54] = {.lex_state = 4},
  [55] = {.lex_state = 4},
  [56] = {.lex_state = 4},
  [57] = {.lex_state = 4},
  [58] = {.lex_state = 4},
  [59] = {.lex_state = 4},
  [60] = {.lex_state = 4},
  [61] = {.lex_state = 4},
  [62] = {.lex_state = 4},
  [63] = {.lex_state = 4},
  [64] = {.lex_state = 4},
  [65] = {.lex_state = 4},
  [66] = {.lex_state = 4},
  [67] = {.lex_state = 4},
  [68] = {.lex_state = 4},
  [69] = {.lex_state = 4},
  [70] = {.lex_state = 4},
  [71] = {.lex_state = 4},
  [72] = {.lex_state = 4},
  [73] = {.lex_state = 4},
  [74] = {.lex_state = 4},
  [75] = {.lex_state = 4},
  [76] = {.lex_state = 4},
  [77] = {.lex_state = 4},
  [78] = {.lex_state = 4},
  [79] = {.lex_state = 4},
  [80] = {.lex_state = 4},
  [81] = {.lex_state = 4},
  [82] = {.lex_state = 4},
  [83] = {.lex_state = 4},
  [84] = {.lex_state = 4},
  [85] = {.lex_state = 4},
  [86] = {.lex_state = 4},
  [87] = {.lex_state = 4},
  [88] = {.lex_state = 4},
  [89] = {.lex_state = 4},
  [90] = {.lex_state = 4},
  [91] = {.lex_state = 4},
  [92] = {.lex_state = 4},
  [93] = {.lex_state = 4},
  [94] = {.lex_state = 4},
  [95] = {.lex_state = 4},
  [96] = {.lex_state = 4},
  [97] = {.lex_state = 4},
  [98] = {.lex_state = 4},
  [99] = {.lex_state = 4},
  [100] = {.lex_state = 4},
  [101] = {.lex_state = 4},
  [102] = {.lex_state = 4},
  [103] = {.lex_state = 4},
  [104] = {.lex_state = 4},
  [105] = {.lex_state = 4},
  [106] = {.lex_state = 4},
  [107] = {.lex_state = 4},
  [108] = {.lex_state = 4},
  [109] = {.lex_state = 4},
  [110] = {.lex_state = 4},
  [111] = {.lex_state = 4},
  [112] = {.lex_state = 4},
  [113] = {.lex_state = 4},
  [114] = {.lex_state = 4},
  [115] = {.lex_state = 4},
  [116] = {.lex_state = 4},
  [117] = {.lex_state = 4},
  [118] = {.lex_state = 4},
  [119] = {.lex_state = 4},
  [120] = {.lex_state = 4},
  [121] = {.lex_state = 4},
  [122] = {.lex_state = 4},
  [123] = {.lex_state = 4},
  [124] = {.lex_state = 4},
  [125] = {.lex_state = 4},
  [126] = {.lex_state = 2},
  [127] = {.lex_state = 2},
  [128] = {.lex_state = 2},
  [129] = {.lex_state = 6},
  [130] = {.lex_state = 2},
  [131] = {.lex_state = 2},
  [132] = {.lex_state = 2},
  [133] = {.lex_state = 2},
  [134] = {.lex_state = 2},
  [135] = {.lex_state = 2},
  [136] = {.lex_state = 2},
  [137] = {.lex_state = 2},
  [138] = {.lex_state = 2},
  [139] = {.lex_state = 2},
  [140] = {.lex_state = 2},
  [141] = {.lex_state = 2},
  [142] = {.lex_state = 2},
  [143] = {.lex_state = 2},
  [144] = {.lex_state = 2},
  [145] = {.lex_state = 2},
  [146] = {.lex_state = 5},
  [147] = {.lex_state = 2},
  [148] = {.lex_state = 2},
  [149] = {.lex_state = 2},
  [150] = {.lex_state = 2},
  [151] = {.lex_state = 2},
  [152] = {.lex_state = 2},
  [153] = {.lex_state = 2},
  [154] = {.lex_state = 2},
  [155] = {.lex_state = 2},
  [156] = {.lex_state = 2},
  [157] = {.lex_state = 5},
  [158] = {.lex_state = 5},
  [159] = {.lex_state = 6},
  [160] = {.lex_state = 5},
  [161] = {.lex_state = 6},
  [162] = {.lex_state = 6},
  [163] = {.lex_state = 2},
  [164] = {.lex_state = 6},
  [165] = {.lex_state = 8},
  [166] = {.lex_state = 6},
  [167] = {.lex_state = 8},
  [168] = {.lex_state = 2},
  [169] = {.lex_state = 6},
  [170] = {.lex_state = 7},
  [171] = {.lex_state = 7},
  [172] = {.lex_state = 7},
  [173] = {.lex_state = 6},
  [174] = {.lex_state = 6},
  [175] = {.lex_state = 2},
  [176] = {.lex_state = 7},
  [177] = {.lex_state = 2},
  [178] = {.lex_state = 6},
  [179] = {.lex_state = 7},
  [180] = {.lex_state = 2},
  [181] = {.lex_state = 6},
  [182] = {.lex_state = 7},
  [183] = {.lex_state = 7},
  [184] = {.lex_state = 7},
  [185] = {.lex_state = 6},
  [186] = {.lex_state = 6},
  [187] = {.lex_state = 6},
  [188] = {.lex_state = 2},
  [189] = {.lex_state = 6},
  [190] = {.lex_state = 7},
  [191] = {.lex_state = 6},
  [192] = {.lex_state = 7},
  [193] = {.lex_state = 2},
  [194] = {.lex_state = 7},
  [195] = {.lex_state = 6},
  [196] = {.lex_state = 8},
  [197] = {.lex_state = 2},
  [198] = {.lex_state = 2},
  [199] = {.lex_state = 2},
  [200] = {.lex_state = 7},
  [201] = {.lex_state = 6},
  [202] = {.lex_state = 2},
  [203] = {.lex_state = 6},
  [204] = {.lex_state = 2},
  [205] = {.lex_state = 2},
  [206] = {.lex_state = 2},
  [207] = {.lex_state = 2},
  [208] = {.lex_state = 7},
  [209] = {.lex_state = 2},
  [210] = {.lex_state = 2},
  [211] = {.lex_state = 2},
  [212] = {.lex_state = 7},
  [213] = {.lex_state = 7},
  [214] = {.lex_state = 2},
  [215] = {.lex_state = 6},
  [216] = {.lex_state = 2},
  [217] = {.lex_state = 7},
  [218] = {.lex_state = 6},
  [219] = {.lex_state = 6},
  [220] = {.lex_state = 6},
  [221] = {.lex_state = 6},
  [222] = {.lex_state = 6},
  [223] = {.lex_state = 7},
  [224] = {.lex_state = 7},
  [225] = {.lex_state = 7},
  [226] = {.lex_state = 6},
  [227] = {.lex_state = 7},
  [228] = {.lex_state = 7},
  [229] = {.lex_state = 2},
  [230] = {.lex_state = 2},
  [231] = {.lex_state = 6},
  [232] = {.lex_state = 6},
  [233] = {.lex_state = 6},
  [234] = {.lex_state = 6},
  [235] = {.lex_state = 6},
  [236] = {.lex_state = 2},
  [237] = {.lex_state = 2},
  [238] = {.lex_state = 2},
  [239] = {.lex_state = 2},
  [240] = {.lex_state = 2},
  [241] = {.lex_state = 2},
  [242] = {.lex_state = 2},
  [243] = {.lex_state = 2},
  [244] = {.lex_state = 2},
  [245] = {.lex_state = 2},
  [246] = {.lex_state = 2},
  [247] = {.lex_state = 2},
  [248] = {.lex_state = 2},
  [249] = {.lex_state = 2},
  [250] = {.lex_state = 2},
  [251] = {.lex_state = 2},
  [252] = {.lex_state = 2},
  [253] = {.lex_state = 2},
  [254] = {.lex_state = 2},
  [255] = {.lex_state = 2},
  [256] = {.lex_state = 2},
  [257] = {.lex_state = 2},
  [258] = {.lex_state = 2},
  [259] = {.lex_state = 2},
  [260] = {.lex_state = 2},
  [261] = {.lex_state = 2},
  [262] = {.lex_state = 2},
  [263] = {.lex_state = 2},
  [264] = {.lex_state = 2},
  [265] = {.lex_state = 2},
  [266] = {.lex_state = 2},
  [267] = {.lex_state = 2},
  [268] = {.lex_state = 2},
  [269] = {.lex_state = 2},
  [270] = {.lex_state = 2},
  [271] = {.lex_state = 2},
  [272] = {.lex_state = 2},
  [273] = {.lex_state = 2},
  [274] = {.lex_state = 2},
  [275] = {.lex_state = 2},
  [276] = {.lex_state = 2},
  [277] = {.lex_state = 2},
  [278] = {.lex_state = 2},
  [279] = {.lex_state = 2},
  [280] = {.lex_state = 2},
  [281] = {.lex_state = 2},
  [282] = {.lex_state = 2},
  [283] = {.lex_state = 2},
  [284] = {.lex_state = 2},
  [285] = {.lex_state = 2},
  [286] = {.lex_state = 2},
  [287] = {.lex_state = 2},
  [288] = {.lex_state = 2},
  [289] = {.lex_state = 2},
  [290] = {.lex_state = 2},
  [291] = {.lex_state = 2},
  [292] = {.lex_state = 2},
  [293] = {.lex_state = 2},
  [294] = {.lex_state = 2},
  [295] = {.lex_state = 2},
  [296] = {.lex_state = 6},
  [297] = {.lex_state = 4},
  [298] = {.lex_state = 6},
  [299] = {.lex_state = 6},
  [300] = {.lex_state = 9},
  [301] = {.lex_state = 9},
  [302] = {.lex_state = 9},
  [303] = {.lex_state = 9},
  [304] = {.lex_state = 9},
  [305] = {.lex_state = 9},
  [306] = {.lex_state = 9},
  [307] = {.lex_state = 2},
  [308] = {.lex_state = 9},
  [309] = {.lex_state = 9},
  [310] = {.lex_state = 2},
  [311] = {.lex_state = 9},
  [312] = {.lex_state = 9},
  [313] = {.lex_state = 2},
  [314] = {.lex_state = 2},
  [315] = {.lex_state = 2},
  [316] = {.lex_state = 2},
  [317] = {.lex_state = 10},
  [318] = {.lex_state = 2},
  [319] = {.lex_state = 2},
  [320] = {.lex_state = 2},
  [321] = {.lex_state = 2},
  [322] = {.lex_state = 10},
  [323] = {.lex_state = 2},
  [324] = {.lex_state = 2},
  [325] = {.lex_state = 2},
  [326] = {.lex_state = 2},
  [327] = {.lex_state = 2},
  [328] = {.lex_state = 2},
  [329] = {.lex_state = 2},
  [330] = {.lex_state = 2},
  [331] = {.lex_state = 2},
  [332] = {.lex_state = 2},
  [333] = {.lex_state = 2},
  [334] = {.lex_state = 2},
  [335] = {.lex_state = 2},
  [336] = {.lex_state = 2},
  [337] = {.lex_state = 2},
  [338] = {.lex_state = 2},
  [339] = {.lex_state = 2},
  [340] = {.lex_state = 2},
  [341] = {.lex_state = 2},
  [342] = {.lex_state = 2},
  [343] = {.lex_state = 2},
  [344] = {.lex_state = 2},
  [345] = {.lex_state = 2},
  [346] = {.lex_state = 2},
  [347] = {.lex_state = 2},
  [348] = {.lex_state = 2},
  [349] = {.lex_state = 2},
  [350] = {.lex_state = 2},
  [351] = {.lex_state = 2},
  [352] = {.lex_state = 2},
  [353] = {.lex_state = 2},
  [354] = {.lex_state = 2},
  [355] = {.lex_state = 2},
  [356] = {.lex_state = 2},
  [357] = {.lex_state = 2},
  [358] = {.lex_state = 2},
  [359] = {.lex_state = 2},
  [360] = {.lex_state = 2},
  [361] = {.lex_state = 2},
  [362] = {.lex_state = 1},
  [363] = {.lex_state = 1},
  [364] = {.lex_state = 1},
  [365] = {.lex_state = 1},
  [366] = {.lex_state = 1},
  [367] = {.lex_state = 0},
  [368] = {.lex_state = 0},
  [369] = {.lex_state = 0},
  [370] = {.lex_state = 0},
  [371] = {.lex_state = 0},
  [372] = {.lex_state = 0},
  [373] = {.lex_state = 0},
  [374] = {.lex_state = 0},
  [375] = {.lex_state = 0},
  [376] = {.lex_state = 0},
  [377] = {.lex_state = 0},
  [378] = {.lex_state = 0},
  [379] = {.lex_state = 5},
  [380] = {.lex_state = 5},
  [381] = {.lex_state = 5},
  [382] = {.lex_state = 5},
  [383] = {.lex_state = 5},
  [384] = {.lex_state = 0},
  [385] = {.lex_state = 0},
  [386] = {.lex_state = 5},
  [387] = {.lex_state = 12},
  [388] = {.lex_state = 5},
  [389] = {.lex_state = 5},
  [390] = {.lex_state = 4},
  [391] = {.lex_state = 5},
  [392] = {.lex_state = 5},
  [393] = {.lex_state = 5},
  [394] = {.lex_state = 0},
  [395] = {.lex_state = 5},
  [396] = {.lex_state = 5},
  [397] = {.lex_state = 5},
  [398] = {.lex_state = 12},
  [399] = {.lex_state = 4},
  [400] = {.lex_state = 4},
  [401] = {.lex_state = 4},
  [402] = {.lex_state = 4},
  [403] = {.lex_state = 13},
  [404] = {.lex_state = 4},
  [405] = {.lex_state = 4},
  [406] = {.lex_state = 4},
  [407] = {.lex_state = 4},
  [408] = {.lex_state = 5},
  [409] = {.lex_state = 5},
  [410] = {.lex_state = 5},
  [411] = {.lex_state = 4},
  [412] = {.lex_state = 4},
  [413] = {.lex_state = 4},
  [414] = {.lex_state = 13},
  [415] = {.lex_state = 4},
  [416] = {.lex_state = 4},
  [417] = {.lex_state = 5},
  [418] = {.lex_state = 12},
  [419] = {.lex_state = 4},
  [420] = {.lex_state = 4},
  [421] = {.lex_state = 4},
  [422] = {.lex_state = 4},
  [423] = {.lex_state = 12},
  [424] = {.lex_state = 4},
  [425] = {.lex_state = 4},
  [426] = {.lex_state = 0},
  [427] = {.lex_state = 4},
  [428] = {.lex_state = 4},
  [429] = {.lex_state = 4},
  [430] = {.lex_state = 4},
  [431] = {.lex_state = 4},
  [432] = {.lex_state = 4},
  [433] = {.lex_state = 13},
  [434] = {.lex_state = 4},
  [435] = {.lex_state = 4},
  [436] = {.lex_state = 4},
  [437] = {.lex_state = 4},
  [438] = {.lex_state = 0},
  [439] = {.lex_state = 4},
  [440] = {.lex_state = 4},
  [441] = {.lex_state = 4},
  [442] = {.lex_state = 13},
  [443] = {.lex_state = 0},
  [444] = {.lex_state = 12},
  [445] = {.lex_state = 4},
  [446] = {.lex_state = 1},
  [447] = {.lex_state = 0},
  [448] = {.lex_state = 5},
  [449] = {.lex_state = 11},
  [450] = {.lex_state = 0},
  [451] = {.lex_state = 13},
  [452] = {.lex_state = 13},
  [453] = {.lex_state = 1},
  [454] = {.lex_state = 0},
  [455] = {.lex_state = 11},
  [456] = {.lex_state = 5},
  [457] = {.lex_state = 5},
  [458] = {.lex_state = 21},
  [459] = {.lex_state = 0},
  [460] = {.lex_state = 0},
  [461] = {.lex_state = 0},
  [462] = {.lex_state = 0},
  [463] = {.lex_state = 21},
  [464] = {.lex_state = 12},
  [465] = {.lex_state = 5},
  [466] = {.lex_state = 1},
  [467] = {.lex_state = 12},
  [468] = {.lex_state = 11},
  [469] = {.lex_state = 12},
  [470] = {.lex_state = 5},
  [471] = {.lex_state = 5},
  [472] = {.lex_state = 0},
  [473] = {.lex_state = 5},
  [474] = {.lex_state = 11},
  [475] = {.lex_state = 5},
  [476] = {.lex_state = 13},
  [477] = {.lex_state = 11},
  [478] = {.lex_state = 1},
  [479] = {.lex_state = 1},
  [480] = {.lex_state = 1},
  [481] = {.lex_state = 1},
  [482] = {.lex_state = 12},
  [483] = {.lex_state = 13},
  [484] = {.lex_state = 1},
  [485] = {.lex_state = 1},
  [486] = {.lex_state = 1},
  [487] = {.lex_state = 1},
  [488] = {.lex_state = 0},
  [489] = {.lex_state = 1},
  [490] = {.lex_state = 1},
  [491] = {.lex_state = 13},
  [492] = {.lex_state = 1},
  [493] = {.lex_state = 1},
  [494] = {.lex_state = 1},
  [495] = {.lex_state = 1},
  [496] = {.lex_state = 1},
  [497] = {.lex_state = 1},
  [498] = {.lex_state = 1},
  [499] = {.lex_state = 0},
  [500] = {.lex_state = 1},
  [501] = {.lex_state = 1},
  [502] = {.lex_state = 13},
  [503] = {.lex_state = 1},
  [504] = {.lex_state = 1},
  [505] = {.lex_state = 12},
  [506] = {.lex_state = 1},
  [507] = {.lex_state = 5},
  [508] = {.lex_state = 1},
  [509] = {.lex_state = 1},
  [510] = {.lex_state = 1},
  [511] = {.lex_state = 1},
  [512] = {.lex_state = 1},
  [513] = {.lex_state = 1},
  [514] = {.lex_state = 0},
  [515] = {.lex_state = 1},
  [516] = {.lex_state = 1},
  [517] = {.lex_state = 0},
  [518] = {.lex_state = 1},
  [519] = {.lex_state = 1},
  [520] = {.lex_state = 0},
  [521] = {.lex_state = 0},
  [522] = {.lex_state = 0},
  [523] = {.lex_state = 1},
  [524] = {.lex_state = 1},
  [525] = {.lex_state = 1},
  [526] = {.lex_state = 1},
  [527] = {.lex_state = 0},
  [528] = {.lex_state = 1},
  [529] = {.lex_state = 1},
  [530] = {.lex_state = 23},
  [531] = {.lex_state = 23},
  [532] = {.lex_state = 0},
  [533] = {.lex_state = 0},
  [534] = {.lex_state = 12},
  [535] = {.lex_state = 22},
  [536] = {.lex_state = 1},
  [537] = {.lex_state = 1},
  [538] = {.lex_state = 6},
  [539] = {.lex_state = 1},
  [540] = {.lex_state = 0},
  [541] = {.lex_state = 1},
  [542] = {.lex_state = 1},
  [543] = {.lex_state = 1},
  [544] = {.lex_state = 1},
  [545] = {.lex_state = 1},
  [546] = {.lex_state = 13},
  [547] = {.lex_state = 5},
  [548] = {.lex_state = 12},
  [549] = {.lex_state = 1},
  [550] = {.lex_state = 1},
  [551] = {.lex_state = 1},
  [552] = {.lex_state = 12},
  [553] = {.lex_state = 1},
  [554] = {.lex_state = 1},
  [555] = {.lex_state = 1},
  [556] = {.lex_state = 0},
  [557] = {.lex_state = 0},
  [558] = {.lex_state = 1},
  [559] = {.lex_state = 0},
  [560] = {.lex_state = 1},
  [561] = {.lex_state = 12},
  [562] = {.lex_state = 1},
  [563] = {.lex_state = 1},
  [564] = {.lex_state = 1},
  [565] = {.lex_state = 0},
  [566] = {.lex_state = 1},
  [567] = {.lex_state = 12},
  [568] = {.lex_state = 0},
  [569] = {.lex_state = 0},
  [570] = {.lex_state = 1},
  [571] = {.lex_state = 13},
  [572] = {.lex_state = 0},
  [573] = {.lex_state = 1},
  [574] = {.lex_state = 0},
  [575] = {.lex_state = 0},
  [576] = {.lex_state = 0},
  [577] = {.lex_state = 0},
  [578] = {.lex_state = 0},
  [579] = {.lex_state = 0},
  [580] = {.lex_state = 0},
  [581] = {.lex_state = 0},
  [582] = {.lex_state = 0},
  [583] = {.lex_state = 0},
  [584] = {.lex_state = 0},
  [585] = {.lex_state = 0},
  [586] = {.lex_state = 0},
  [587] = {.lex_state = 0},
  [588] = {.lex_state = 2},
  [589] = {.lex_state = 1},
  [590] = {.lex_state = 0},
  [591] = {.lex_state = 0},
  [592] = {.lex_state = 0},
  [593] = {.lex_state = 0},
  [594] = {.lex_state = 0},
  [595] = {.lex_state = 0},
  [596] = {.lex_state = 0},
  [597] = {.lex_state = 0},
  [598] = {.lex_state = 0},
  [599] = {.lex_state = 13},
  [600] = {.lex_state = 0},
  [601] = {.lex_state = 0},
  [602] = {.lex_state = 0},
  [603] = {.lex_state = 12},
  [604] = {.lex_state = 0},
  [605] = {.lex_state = 0},
  [606] = {.lex_state = 0},
  [607] = {.lex_state = 0},
  [608] = {.lex_state = 1},
  [609] = {.lex_state = 0},
  [610] = {.lex_state = 0},
  [611] = {.lex_state = 1},
  [612] = {.lex_state = 0},
  [613] = {.lex_state = 0},
  [614] = {.lex_state = 0},
  [615] = {.lex_state = 0},
  [616] = {.lex_state = 0},
  [617] = {.lex_state = 0},
  [618] = {.lex_state = 0},
  [619] = {.lex_state = 0},
  [620] = {.lex_state = 0},
  [621] = {.lex_state = 0},
  [622] = {.lex_state = 0},
  [623] = {.lex_state = 0},
  [624] = {.lex_state = 0},
  [625] = {.lex_state = 0},
  [626] = {.lex_state = 0},
  [627] = {.lex_state = 0},
  [628] = {.lex_state = 0},
  [629] = {.lex_state = 0},
  [630] = {.lex_state = 0},
  [631] = {.lex_state = 0},
  [632] = {.lex_state = 13},
  [633] = {.lex_state = 0},
  [634] = {.lex_state = 0},
  [635] = {.lex_state = 0},
  [636] = {.lex_state = 12},
  [637] = {.lex_state = 0},
  [638] = {.lex_state = 0},
  [639] = {.lex_state = 1},
  [640] = {.lex_state = 0},
  [641] = {.lex_state = 0},
  [642] = {.lex_state = 0},
  [643] = {.lex_state = 12},
  [644] = {.lex_state = 0},
  [645] = {.lex_state = 0},
  [646] = {.lex_state = 0},
  [647] = {.lex_state = 0},
  [648] = {.lex_state = 0},
  [649] = {.lex_state = 12},
  [650] = {.lex_state = 0},
  [651] = {.lex_state = 0},
  [652] = {.lex_state = 0},
  [653] = {.lex_state = 0},
  [654] = {.lex_state = 12},
  [655] = {.lex_state = 13},
  [656] = {.lex_state = 0},
  [657] = {.lex_state = 0},
  [658] = {.lex_state = 0},
  [659] = {.lex_state = 0},
  [660] = {.lex_state = 0},
  [661] = {.lex_state = 0},
  [662] = {.lex_state = 0},
  [663] = {.lex_state = 13},
  [664] = {.lex_state = 2},
  [665] = {.lex_state = 0},
  [666] = {.lex_state = 0},
  [667] = {.lex_state = 0},
  [668] = {.lex_state = 0},
  [669] = {.lex_state = 0},
  [670] = {.lex_state = 0},
  [671] = {.lex_state = 0},
  [672] = {.lex_state = 0},
  [673] = {.lex_state = 0},
  [674] = {.lex_state = 0},
  [675] = {.lex_state = 0},
  [676] = {.lex_state = 0},
  [677] = {.lex_state = 0},
  [678] = {.lex_state = 0},
  [679] = {.lex_state = 0},
  [680] = {.lex_state = 0},
  [681] = {.lex_state = 12},
  [682] = {.lex_state = 0},
  [683] = {.lex_state = 0},
  [684] = {.lex_state = 0},
  [685] = {.lex_state = 0},
  [686] = {.lex_state = 0},
  [687] = {.lex_state = 0},
  [688] = {.lex_state = 0},
  [689] = {.lex_state = 0},
  [690] = {.lex_state = 0},
  [691] = {.lex_state = 0},
  [692] = {.lex_state = 0},
  [693] = {.lex_state = 0},
  [694] = {.lex_state = 0},
  [695] = {.lex_state = 0},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 0},
  [698] = {.lex_state = 0},
  [699] = {.lex_state = 0},
  [700] = {.lex_state = 0},
  [701] = {.lex_state = 0},
  [702] = {.lex_state = 0},
  [703] = {.lex_state = 0},
  [704] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_keyword] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_rune] = ACTIONS(1),
    [anon_sym_bool] = ACTIONS(1),
    [anon_sym_valist] = ACTIONS(1),
    [anon_sym_void] = ACTIONS(1),
    [anon_sym_opaque] = ACTIONS(1),
    [anon_sym_done] = ACTIONS(1),
    [anon_sym_never] = ACTIONS(1),
    [anon_sym_i8] = ACTIONS(1),
    [anon_sym_i16] = ACTIONS(1),
    [anon_sym_i32] = ACTIONS(1),
    [anon_sym_i64] = ACTIONS(1),
    [anon_sym_u8] = ACTIONS(1),
    [anon_sym_u16] = ACTIONS(1),
    [anon_sym_u32] = ACTIONS(1),
    [anon_sym_u64] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_uint] = ACTIONS(1),
    [anon_sym_size] = ACTIONS(1),
    [anon_sym_uintptr] = ACTIONS(1),
    [anon_sym_f32] = ACTIONS(1),
    [anon_sym_f64] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_nullable] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_ATpacked] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_union] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_AToffset] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [sym__string_type] = ACTIONS(1),
    [anon_sym_fn] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_null] = ACTIONS(1),
    [sym_floating_literal] = ACTIONS(1),
    [sym_integer_literal] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE2] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [aux_sym_string_literal_token1] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE2] = ACTIONS(1),
    [anon_sym_alloc] = ACTIONS(1),
    [anon_sym_free] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_abort] = ACTIONS(1),
    [anon_sym_align] = ACTIONS(1),
    [anon_sym_len] = ACTIONS(1),
    [anon_sym_offset] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_append] = ACTIONS(1),
    [anon_sym_insert] = ACTIONS(1),
    [anon_sym_delete] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_vastart] = ACTIONS(1),
    [anon_sym_vaarg] = ACTIONS(1),
    [anon_sym_vaend] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_CARET_CARET] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_AMP_DOT_DOT] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_match] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(1),
    [anon_sym_CARET_CARET_EQ] = ACTIONS(1),
    [anon_sym_def] = ACTIONS(1),
    [anon_sym_defer] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_COMMA2] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_ATthreadlocal] = ACTIONS(1),
    [anon_sym_ATsymbol] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_ATfini] = ACTIONS(1),
    [anon_sym_ATinit] = ACTIONS(1),
    [anon_sym_ATtest] = ACTIONS(1),
    [anon_sym_use] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
  },
  [1] = {
    [sym_sub_unit] = STATE(692),
    [sym_declarations] = STATE(690),
    [sym_declaration] = STATE(689),
    [sym_global_declaration] = STATE(688),
    [sym_decl_attr] = STATE(443),
    [sym_constant_declaration] = STATE(688),
    [sym_type_declaration] = STATE(688),
    [sym_function_declaration] = STATE(688),
    [sym_fndec_attrs] = STATE(685),
    [sym_fndec_attr] = STATE(384),
    [sym_imports] = STATE(367),
    [sym_use_directive] = STATE(372),
    [aux_sym_declarations_repeat1] = STATE(368),
    [aux_sym_fndec_attrs_repeat1] = STATE(384),
    [aux_sym_imports_repeat1] = STATE(372),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_comment] = ACTIONS(3),
    [anon_sym_const] = ACTIONS(7),
    [anon_sym_fn] = ACTIONS(9),
    [anon_sym_let] = ACTIONS(7),
    [anon_sym_def] = ACTIONS(11),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_ATsymbol] = ACTIONS(15),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_ATfini] = ACTIONS(19),
    [anon_sym_ATinit] = ACTIONS(19),
    [anon_sym_ATtest] = ACTIONS(19),
    [anon_sym_use] = ACTIONS(21),
  },
  [2] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(177),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(35),
    [anon_sym_COMMA] = ACTIONS(35),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(35),
    [anon_sym_PIPE] = ACTIONS(41),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(35),
    [anon_sym_EQ] = ACTIONS(41),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_DOT_DOT] = ACTIONS(41),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_as] = ACTIONS(41),
    [anon_sym_is] = ACTIONS(41),
    [anon_sym_SLASH] = ACTIONS(41),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_LT_LT] = ACTIONS(41),
    [anon_sym_GT_GT] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(41),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_AMP_AMP] = ACTIONS(41),
    [anon_sym_CARET_CARET] = ACTIONS(41),
    [anon_sym_PIPE_PIPE] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_else] = ACTIONS(41),
    [anon_sym_for] = ACTIONS(83),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_EQ_GT] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_PLUS_EQ] = ACTIONS(35),
    [anon_sym_DASH_EQ] = ACTIONS(35),
    [anon_sym_STAR_EQ] = ACTIONS(35),
    [anon_sym_SLASH_EQ] = ACTIONS(35),
    [anon_sym_PERCENT_EQ] = ACTIONS(35),
    [anon_sym_LT_LT_EQ] = ACTIONS(35),
    [anon_sym_GT_GT_EQ] = ACTIONS(35),
    [anon_sym_AMP_EQ] = ACTIONS(35),
    [anon_sym_PIPE_EQ] = ACTIONS(35),
    [anon_sym_CARET_EQ] = ACTIONS(35),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(35),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(35),
    [anon_sym_CARET_CARET_EQ] = ACTIONS(35),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_yield] = ACTIONS(93),
  },
  [3] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(167),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(177),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(35),
    [anon_sym_COMMA] = ACTIONS(35),
    [anon_sym_COLON] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(35),
    [anon_sym_PIPE] = ACTIONS(41),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(35),
    [anon_sym_EQ] = ACTIONS(41),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_DOT_DOT] = ACTIONS(41),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_as] = ACTIONS(41),
    [anon_sym_is] = ACTIONS(41),
    [anon_sym_SLASH] = ACTIONS(41),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_LT_LT] = ACTIONS(41),
    [anon_sym_GT_GT] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(41),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_AMP_AMP] = ACTIONS(41),
    [anon_sym_CARET_CARET] = ACTIONS(41),
    [anon_sym_PIPE_PIPE] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_else] = ACTIONS(41),
    [anon_sym_for] = ACTIONS(83),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_EQ_GT] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_PLUS_EQ] = ACTIONS(35),
    [anon_sym_DASH_EQ] = ACTIONS(35),
    [anon_sym_STAR_EQ] = ACTIONS(35),
    [anon_sym_SLASH_EQ] = ACTIONS(35),
    [anon_sym_PERCENT_EQ] = ACTIONS(35),
    [anon_sym_LT_LT_EQ] = ACTIONS(35),
    [anon_sym_GT_GT_EQ] = ACTIONS(35),
    [anon_sym_AMP_EQ] = ACTIONS(35),
    [anon_sym_PIPE_EQ] = ACTIONS(35),
    [anon_sym_CARET_EQ] = ACTIONS(35),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(35),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(35),
    [anon_sym_CARET_CARET_EQ] = ACTIONS(35),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_yield] = ACTIONS(93),
  },
  [4] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(196),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(261),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(97),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(97),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(35),
    [anon_sym_COMMA] = ACTIONS(35),
    [anon_sym_COLON] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_RPAREN] = ACTIONS(35),
    [anon_sym_PIPE] = ACTIONS(41),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(35),
    [anon_sym_EQ] = ACTIONS(41),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_DOT_DOT] = ACTIONS(41),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(97),
    [anon_sym_DASH] = ACTIONS(97),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(97),
    [anon_sym_as] = ACTIONS(41),
    [anon_sym_is] = ACTIONS(41),
    [anon_sym_SLASH] = ACTIONS(41),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_LT_LT] = ACTIONS(41),
    [anon_sym_GT_GT] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(41),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_AMP_AMP] = ACTIONS(41),
    [anon_sym_CARET_CARET] = ACTIONS(41),
    [anon_sym_PIPE_PIPE] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_EQ_GT] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_PLUS_EQ] = ACTIONS(35),
    [anon_sym_DASH_EQ] = ACTIONS(35),
    [anon_sym_STAR_EQ] = ACTIONS(35),
    [anon_sym_SLASH_EQ] = ACTIONS(35),
    [anon_sym_PERCENT_EQ] = ACTIONS(35),
    [anon_sym_LT_LT_EQ] = ACTIONS(35),
    [anon_sym_GT_GT_EQ] = ACTIONS(35),
    [anon_sym_AMP_EQ] = ACTIONS(35),
    [anon_sym_PIPE_EQ] = ACTIONS(35),
    [anon_sym_CARET_EQ] = ACTIONS(35),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(35),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(35),
    [anon_sym_CARET_CARET_EQ] = ACTIONS(35),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [5] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(261),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(97),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(97),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(35),
    [anon_sym_COMMA] = ACTIONS(35),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_RPAREN] = ACTIONS(35),
    [anon_sym_PIPE] = ACTIONS(41),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(35),
    [anon_sym_EQ] = ACTIONS(41),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_DOT_DOT] = ACTIONS(41),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(97),
    [anon_sym_DASH] = ACTIONS(97),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(97),
    [anon_sym_as] = ACTIONS(41),
    [anon_sym_is] = ACTIONS(41),
    [anon_sym_SLASH] = ACTIONS(41),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_LT_LT] = ACTIONS(41),
    [anon_sym_GT_GT] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(41),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_AMP_AMP] = ACTIONS(41),
    [anon_sym_CARET_CARET] = ACTIONS(41),
    [anon_sym_PIPE_PIPE] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_EQ_GT] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_PLUS_EQ] = ACTIONS(35),
    [anon_sym_DASH_EQ] = ACTIONS(35),
    [anon_sym_STAR_EQ] = ACTIONS(35),
    [anon_sym_SLASH_EQ] = ACTIONS(35),
    [anon_sym_PERCENT_EQ] = ACTIONS(35),
    [anon_sym_LT_LT_EQ] = ACTIONS(35),
    [anon_sym_GT_GT_EQ] = ACTIONS(35),
    [anon_sym_AMP_EQ] = ACTIONS(35),
    [anon_sym_PIPE_EQ] = ACTIONS(35),
    [anon_sym_CARET_EQ] = ACTIONS(35),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(35),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(35),
    [anon_sym_CARET_CARET_EQ] = ACTIONS(35),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [6] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_binding_list] = STATE(660),
    [sym_defer_expression] = STATE(660),
    [sym_expression_list] = STATE(527),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(336),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_const] = ACTIONS(111),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(113),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(115),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_let] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(119),
    [anon_sym_defer] = ACTIONS(121),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [7] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_binding_list] = STATE(593),
    [sym_defer_expression] = STATE(593),
    [sym_expression_list] = STATE(527),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(353),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_const] = ACTIONS(111),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(113),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(115),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_let] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(119),
    [anon_sym_defer] = ACTIONS(121),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [8] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_binding_list] = STATE(660),
    [sym_defer_expression] = STATE(660),
    [sym_expression_list] = STATE(569),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(336),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_const] = ACTIONS(111),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(115),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_let] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(119),
    [anon_sym_defer] = ACTIONS(121),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [9] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_binding_list] = STATE(660),
    [sym_defer_expression] = STATE(660),
    [sym_expression_list] = STATE(572),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(336),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_const] = ACTIONS(111),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(115),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_let] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(119),
    [anon_sym_defer] = ACTIONS(121),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [10] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_binding_list] = STATE(660),
    [sym_defer_expression] = STATE(660),
    [sym_expression_list] = STATE(540),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(336),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_const] = ACTIONS(111),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(115),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_let] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(119),
    [anon_sym_defer] = ACTIONS(121),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [11] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_binding_list] = STATE(593),
    [sym_defer_expression] = STATE(593),
    [sym_expression_list] = STATE(592),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(353),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_const] = ACTIONS(111),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(115),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_let] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(119),
    [anon_sym_defer] = ACTIONS(121),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [12] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_binding_list] = STATE(593),
    [sym_defer_expression] = STATE(593),
    [sym_expression_list] = STATE(574),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(353),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_const] = ACTIONS(111),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(115),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_let] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(119),
    [anon_sym_defer] = ACTIONS(121),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [13] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_binding_list] = STATE(660),
    [sym_defer_expression] = STATE(660),
    [sym_expression_list] = STATE(565),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(336),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_const] = ACTIONS(111),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(115),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_let] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(119),
    [anon_sym_defer] = ACTIONS(121),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [14] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_binding_list] = STATE(660),
    [sym_defer_expression] = STATE(660),
    [sym_expression_list] = STATE(568),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(336),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_const] = ACTIONS(111),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(115),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_let] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(119),
    [anon_sym_defer] = ACTIONS(121),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [15] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_for_predicate] = STATE(696),
    [sym_iterable_binding] = STATE(648),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_binding_list] = STATE(650),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(321),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_const] = ACTIONS(123),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(115),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_let] = ACTIONS(123),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(119),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [16] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_for_predicate] = STATE(676),
    [sym_iterable_binding] = STATE(648),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_binding_list] = STATE(650),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(321),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_const] = ACTIONS(123),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(115),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_let] = ACTIONS(123),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(119),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [17] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_for_predicate] = STATE(646),
    [sym_iterable_binding] = STATE(648),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_binding_list] = STATE(650),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(321),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_const] = ACTIONS(123),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(115),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_let] = ACTIONS(123),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(119),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [18] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_for_predicate] = STATE(687),
    [sym_iterable_binding] = STATE(648),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_binding_list] = STATE(650),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(321),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_const] = ACTIONS(123),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(115),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_let] = ACTIONS(123),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(119),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [19] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_tuple_binding_names] = STATE(590),
    [sym_tuple_binding_name] = STATE(589),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(310),
    [sym_name] = ACTIONS(125),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym__] = ACTIONS(125),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [20] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_tuple_binding_names] = STATE(697),
    [sym_tuple_binding_name] = STATE(589),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(310),
    [sym_name] = ACTIONS(125),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym__] = ACTIONS(125),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [21] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_case_options] = STATE(607),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(324),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_EQ_GT] = ACTIONS(127),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [22] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_argument_list] = STATE(677),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(312),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_RPAREN] = ACTIONS(129),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [23] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_argument_list] = STATE(666),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(312),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_RPAREN] = ACTIONS(131),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [24] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_case_options] = STATE(580),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(324),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_EQ_GT] = ACTIONS(133),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [25] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_argument_list] = STATE(652),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(312),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_RPAREN] = ACTIONS(135),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [26] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(359),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(137),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_RBRACK] = ACTIONS(139),
    [anon_sym__] = ACTIONS(141),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [27] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(345),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_RBRACK] = ACTIONS(143),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [28] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(300),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_RBRACK] = ACTIONS(145),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [29] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(317),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_DOT_DOT] = ACTIONS(147),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [30] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(300),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_RBRACK] = ACTIONS(149),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [31] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(352),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_RBRACK] = ACTIONS(151),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [32] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(300),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_RPAREN] = ACTIONS(153),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [33] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(292),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_RBRACK] = ACTIONS(155),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [34] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(344),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_RBRACK] = ACTIONS(157),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [35] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(301),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_RBRACK] = ACTIONS(159),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [36] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(300),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_RBRACK] = ACTIONS(161),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [37] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(300),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_RBRACK] = ACTIONS(163),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [38] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(357),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_RBRACK] = ACTIONS(165),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [39] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(300),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_RPAREN] = ACTIONS(167),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [40] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(302),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_RBRACK] = ACTIONS(169),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [41] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(322),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_DOT_DOT] = ACTIONS(171),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [42] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(325),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [43] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(315),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [44] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(197),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_for] = ACTIONS(83),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_yield] = ACTIONS(93),
  },
  [45] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(305),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [46] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(329),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [47] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(304),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [48] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(358),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [49] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(333),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [50] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(349),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [51] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(326),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [52] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(342),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [53] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(346),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [54] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(309),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [55] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(348),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [56] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(328),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [57] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(180),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_for] = ACTIONS(83),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_yield] = ACTIONS(93),
  },
  [58] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(331),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [59] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(354),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [60] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(313),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [61] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(323),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [62] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(356),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [63] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(250),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [64] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(307),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [65] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(314),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [66] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(308),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [67] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(303),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [68] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(332),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [69] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(238),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [70] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(320),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [71] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(337),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [72] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(269),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [73] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(270),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [74] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(272),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [75] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(274),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [76] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(230),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_for] = ACTIONS(83),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_yield] = ACTIONS(93),
  },
  [77] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(236),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [78] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(311),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [79] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(275),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [80] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(318),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [81] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(292),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [82] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(347),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [83] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(340),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [84] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(229),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_for] = ACTIONS(83),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_yield] = ACTIONS(93),
  },
  [85] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(278),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [86] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(280),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [87] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(316),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [88] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(268),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [89] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(284),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [90] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(286),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [91] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(175),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_for] = ACTIONS(83),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_yield] = ACTIONS(93),
  },
  [92] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(341),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [93] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(287),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [94] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(289),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [95] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(306),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [96] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(327),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [97] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(263),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [98] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(300),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [99] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(339),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [100] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(216),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_for] = ACTIONS(83),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_yield] = ACTIONS(93),
  },
  [101] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(214),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_for] = ACTIONS(83),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_yield] = ACTIONS(93),
  },
  [102] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(343),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [103] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(335),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [104] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(351),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [105] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(188),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_for] = ACTIONS(83),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_yield] = ACTIONS(93),
  },
  [106] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(198),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_for] = ACTIONS(83),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_yield] = ACTIONS(93),
  },
  [107] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(199),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_for] = ACTIONS(83),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_yield] = ACTIONS(93),
  },
  [108] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(360),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [109] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(334),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [110] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(202),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_for] = ACTIONS(83),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_yield] = ACTIONS(93),
  },
  [111] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(266),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [112] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(204),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_for] = ACTIONS(83),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_yield] = ACTIONS(93),
  },
  [113] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(319),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [114] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(338),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [115] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(330),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [116] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(350),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [117] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(205),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_for] = ACTIONS(83),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_yield] = ACTIONS(93),
  },
  [118] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(211),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_for] = ACTIONS(83),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_yield] = ACTIONS(93),
  },
  [119] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(355),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [120] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(210),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_for] = ACTIONS(83),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_yield] = ACTIONS(93),
  },
  [121] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(209),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_for] = ACTIONS(83),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_yield] = ACTIONS(93),
  },
  [122] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(207),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_for] = ACTIONS(83),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_yield] = ACTIONS(93),
  },
  [123] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(361),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(101),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(101),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(101),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(107),
    [anon_sym_yield] = ACTIONS(109),
  },
  [124] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(168),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_for] = ACTIONS(83),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_yield] = ACTIONS(93),
  },
  [125] = {
    [sym_literal] = STATE(135),
    [sym_rune_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_array_literal] = STATE(128),
    [sym_struct_literal] = STATE(128),
    [sym_tuple_literal] = STATE(128),
    [sym__plain_expression] = STATE(135),
    [sym_nested_expression] = STATE(134),
    [sym_allocation_expression] = STATE(258),
    [sym_assertion_expression] = STATE(258),
    [sym_call_expression] = STATE(134),
    [sym_measurement_expression] = STATE(258),
    [sym_align_expression] = STATE(259),
    [sym_size_expression] = STATE(259),
    [sym_length_expression] = STATE(259),
    [sym_offset_expression] = STATE(259),
    [sym_field_access_expression] = STATE(134),
    [sym_indexing_expression] = STATE(134),
    [sym_slicing_expression] = STATE(134),
    [sym_slice_mutation_expression] = STATE(258),
    [sym_append_expression] = STATE(260),
    [sym_insert_expression] = STATE(260),
    [sym_delete_expression] = STATE(260),
    [sym_error_propagation] = STATE(134),
    [sym_postfix_expression] = STATE(132),
    [sym_variadic_expression] = STATE(258),
    [sym_builtin_expression] = STATE(237),
    [sym_unary_expression] = STATE(237),
    [sym_cast_expression] = STATE(237),
    [sym_multiplicative_expression] = STATE(237),
    [sym_additive_expression] = STATE(237),
    [sym_shift_expression] = STATE(237),
    [sym_and_expression] = STATE(237),
    [sym_exclusive_or_expression] = STATE(237),
    [sym_inclusive_or_expression] = STATE(237),
    [sym_comparison_expression] = STATE(237),
    [sym_equality_expression] = STATE(237),
    [sym_logical_and_expression] = STATE(237),
    [sym_logical_xor_expression] = STATE(237),
    [sym_logical_or_expression] = STATE(237),
    [sym_if_expression] = STATE(237),
    [sym_for_loop] = STATE(237),
    [sym_switch_expression] = STATE(237),
    [sym_match_expression] = STATE(237),
    [sym_assignment] = STATE(237),
    [sym_compound_expression] = STATE(237),
    [sym_label] = STATE(614),
    [sym_control_expression] = STATE(237),
    [sym_expression] = STATE(206),
    [sym_identifier] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(27),
    [anon_sym_size] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_struct] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_COLON] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_null] = ACTIONS(27),
    [sym_floating_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [aux_sym_string_literal_token1] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_alloc] = ACTIONS(53),
    [anon_sym_free] = ACTIONS(55),
    [anon_sym_static] = ACTIONS(57),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_abort] = ACTIONS(61),
    [anon_sym_align] = ACTIONS(63),
    [anon_sym_len] = ACTIONS(65),
    [anon_sym_offset] = ACTIONS(67),
    [anon_sym_append] = ACTIONS(69),
    [anon_sym_insert] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_vastart] = ACTIONS(75),
    [anon_sym_vaarg] = ACTIONS(77),
    [anon_sym_vaend] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_for] = ACTIONS(83),
    [anon_sym_switch] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_break] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_yield] = ACTIONS(93),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(175), 1,
      anon_sym_LBRACE,
    ACTIONS(173), 19,
      anon_sym_BANG,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(177), 31,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_QMARK,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [61] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 19,
      anon_sym_BANG,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(181), 31,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_QMARK,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [119] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(183), 19,
      anon_sym_BANG,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(185), 31,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_QMARK,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [177] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(211), 1,
      anon_sym_null,
    ACTIONS(213), 1,
      anon_sym_let,
    ACTIONS(215), 1,
      anon_sym_EQ_GT,
    STATE(283), 1,
      sym_type,
    STATE(597), 1,
      sym_nullable_type,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [267] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 19,
      anon_sym_BANG,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(219), 31,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_QMARK,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [325] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 19,
      anon_sym_BANG,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(223), 31,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_QMARK,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [383] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(225), 1,
      anon_sym_BANG,
    ACTIONS(231), 1,
      anon_sym_LPAREN,
    ACTIONS(233), 1,
      anon_sym_LBRACK,
    ACTIONS(235), 1,
      anon_sym_DOT,
    ACTIONS(237), 1,
      anon_sym_QMARK,
    ACTIONS(227), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(229), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [451] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 19,
      anon_sym_BANG,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(241), 31,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_QMARK,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [509] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(243), 19,
      anon_sym_BANG,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(245), 31,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_QMARK,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [567] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(247), 19,
      anon_sym_BANG,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(249), 31,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_QMARK,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [625] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(251), 19,
      anon_sym_BANG,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(253), 31,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_QMARK,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [683] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 19,
      anon_sym_BANG,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(257), 31,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_QMARK,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [741] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(259), 19,
      anon_sym_BANG,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(261), 31,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_QMARK,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [799] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(263), 19,
      anon_sym_BANG,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(265), 31,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_QMARK,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [857] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(267), 19,
      anon_sym_BANG,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(269), 31,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_QMARK,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [915] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(271), 19,
      anon_sym_BANG,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(273), 31,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_QMARK,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [973] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(275), 19,
      anon_sym_BANG,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(277), 31,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_QMARK,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [1031] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 19,
      anon_sym_BANG,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(281), 31,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_QMARK,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [1089] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 19,
      anon_sym_BANG,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(285), 31,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_QMARK,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [1147] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 19,
      anon_sym_BANG,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(289), 31,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_QMARK,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [1205] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      sym_name,
    ACTIONS(293), 1,
      anon_sym_COMMA,
    ACTIONS(295), 1,
      anon_sym_RPAREN,
    ACTIONS(297), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(456), 1,
      sym_parameter,
    STATE(457), 1,
      sym_type,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [1295] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(299), 19,
      anon_sym_BANG,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(301), 31,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_QMARK,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [1353] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 19,
      anon_sym_BANG,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(305), 31,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_QMARK,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [1411] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(307), 19,
      anon_sym_BANG,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(309), 31,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_QMARK,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [1469] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(311), 19,
      anon_sym_BANG,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(313), 31,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_QMARK,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [1527] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(315), 19,
      anon_sym_BANG,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(317), 31,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_QMARK,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [1585] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(319), 19,
      anon_sym_BANG,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(321), 31,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_QMARK,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [1643] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(323), 19,
      anon_sym_BANG,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(325), 31,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_QMARK,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [1701] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(327), 19,
      anon_sym_BANG,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(329), 31,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_QMARK,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [1759] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(331), 19,
      anon_sym_BANG,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(333), 31,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_QMARK,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [1817] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(335), 19,
      anon_sym_BANG,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(337), 31,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_QMARK,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [1875] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      sym_name,
    ACTIONS(339), 1,
      anon_sym_RPAREN,
    ACTIONS(341), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(457), 1,
      sym_type,
    STATE(507), 1,
      sym_parameter,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [1962] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      sym_name,
    ACTIONS(343), 1,
      anon_sym_RPAREN,
    ACTIONS(345), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(457), 1,
      sym_type,
    STATE(507), 1,
      sym_parameter,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [2049] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(347), 1,
      anon_sym_enum,
    STATE(573), 2,
      sym_type,
      sym_enum_type,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [2131] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(291), 1,
      sym_name,
    STATE(457), 1,
      sym_type,
    STATE(507), 1,
      sym_parameter,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [2215] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(211), 1,
      anon_sym_null,
    STATE(281), 1,
      sym_nullable_type,
    STATE(283), 1,
      sym_type,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [2299] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(211), 1,
      anon_sym_null,
    STATE(282), 1,
      sym_nullable_type,
    STATE(283), 1,
      sym_type,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [2383] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(349), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(351), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [2438] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(353), 1,
      anon_sym_RPAREN,
    STATE(556), 1,
      sym_type,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [2519] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(349), 18,
      anon_sym_STAR,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(351), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
      anon_sym_COMMA2,
  [2574] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(355), 1,
      anon_sym_RPAREN,
    STATE(555), 1,
      sym_type,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [2655] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(359), 1,
      anon_sym_LBRACE,
    ACTIONS(363), 1,
      anon_sym_COMMA2,
    ACTIONS(357), 18,
      anon_sym_STAR,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(361), 27,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [2714] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(371), 1,
      anon_sym_PIPE,
    ACTIONS(377), 1,
      anon_sym_AMP,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(385), 1,
      anon_sym_CARET,
    STATE(118), 1,
      sym_assignment_op,
    ACTIONS(375), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(383), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(387), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(389), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(365), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(373), 5,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(367), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [2792] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(228), 1,
      sym_type,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [2870] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(391), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(393), 29,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_AMP_DOT_DOT,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [2924] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(395), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(397), 29,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_AMP_DOT_DOT,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [2978] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(401), 29,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_AMP_DOT_DOT,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [3032] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(583), 1,
      sym_type,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [3110] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(617), 1,
      sym_type,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [3188] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(118), 1,
      sym_assignment_op,
    ACTIONS(403), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(405), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [3244] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(407), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(409), 29,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_AMP_DOT_DOT,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [3298] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 1,
      anon_sym_DOT_DOT,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(371), 1,
      anon_sym_PIPE,
    ACTIONS(377), 1,
      anon_sym_AMP,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(385), 1,
      anon_sym_CARET,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(415), 1,
      anon_sym_AMP_AMP,
    ACTIONS(417), 1,
      anon_sym_CARET_CARET,
    ACTIONS(419), 1,
      anon_sym_PIPE_PIPE,
    STATE(118), 1,
      sym_assignment_op,
    ACTIONS(375), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(383), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(387), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(389), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(413), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(365), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(361), 8,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [3388] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(644), 1,
      sym_type,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [3466] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(423), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(425), 29,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_AMP_DOT_DOT,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [3520] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(371), 1,
      anon_sym_PIPE,
    ACTIONS(377), 1,
      anon_sym_AMP,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(385), 1,
      anon_sym_CARET,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(415), 1,
      anon_sym_AMP_AMP,
    ACTIONS(417), 1,
      anon_sym_CARET_CARET,
    ACTIONS(419), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(429), 1,
      anon_sym_DOT_DOT,
    STATE(118), 1,
      sym_assignment_op,
    ACTIONS(375), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(383), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(387), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(389), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(413), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(365), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(427), 8,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [3610] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(227), 1,
      sym_type,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [3688] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(431), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(433), 29,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_AMP_DOT_DOT,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [3742] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(435), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(437), 29,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_AMP_DOT_DOT,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [3796] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(439), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(441), 29,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_AMP_DOT_DOT,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [3850] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(200), 1,
      sym_type,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [3928] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(224), 1,
      sym_type,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [4006] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(194), 1,
      sym_type,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [4084] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    STATE(118), 1,
      sym_assignment_op,
    ACTIONS(443), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(445), 25,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [4146] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(480), 1,
      sym_type,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [4224] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(447), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(449), 29,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_AMP_DOT_DOT,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [4278] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(562), 1,
      sym_type,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [4356] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(453), 29,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_AMP_DOT_DOT,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [4410] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      anon_sym_COLON,
    STATE(262), 1,
      sym_label,
    ACTIONS(41), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(35), 27,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [4468] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(455), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(457), 29,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_AMP_DOT_DOT,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [4522] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(464), 1,
      sym_type,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [4600] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(359), 1,
      anon_sym_LBRACE,
    ACTIONS(459), 1,
      anon_sym_COMMA2,
    ACTIONS(357), 18,
      anon_sym_STAR,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(361), 26,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [4658] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(371), 1,
      anon_sym_PIPE,
    ACTIONS(377), 1,
      anon_sym_AMP,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(385), 1,
      anon_sym_CARET,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(415), 1,
      anon_sym_AMP_AMP,
    ACTIONS(417), 1,
      anon_sym_CARET_CARET,
    ACTIONS(419), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(463), 1,
      anon_sym_DOT_DOT,
    STATE(118), 1,
      sym_assignment_op,
    ACTIONS(375), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(383), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(387), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(389), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(413), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(365), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(461), 8,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [4748] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(377), 1,
      anon_sym_AMP,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(385), 1,
      anon_sym_CARET,
    STATE(118), 1,
      sym_assignment_op,
    ACTIONS(375), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(383), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(365), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(467), 8,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(465), 25,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [4820] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    STATE(118), 1,
      sym_assignment_op,
    ACTIONS(365), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(471), 14,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(469), 25,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [4884] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(475), 29,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_AMP_DOT_DOT,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [4938] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(190), 1,
      sym_type,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [5016] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    STATE(118), 1,
      sym_assignment_op,
    ACTIONS(375), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(383), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(365), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(479), 10,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(477), 25,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [5084] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(288), 1,
      sym_type,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [5162] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    STATE(118), 1,
      sym_assignment_op,
    ACTIONS(375), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(365), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(483), 12,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(481), 25,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [5228] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(377), 1,
      anon_sym_AMP,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    STATE(118), 1,
      sym_assignment_op,
    ACTIONS(375), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(383), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(365), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(487), 9,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(485), 25,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [5298] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(371), 1,
      anon_sym_PIPE,
    ACTIONS(377), 1,
      anon_sym_AMP,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(385), 1,
      anon_sym_CARET,
    STATE(118), 1,
      sym_assignment_op,
    ACTIONS(375), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(383), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(365), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(491), 7,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(489), 25,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [5372] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(371), 1,
      anon_sym_PIPE,
    ACTIONS(377), 1,
      anon_sym_AMP,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(385), 1,
      anon_sym_CARET,
    STATE(118), 1,
      sym_assignment_op,
    ACTIONS(375), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(383), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(387), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(389), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(413), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(365), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(495), 5,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(493), 21,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [5452] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(497), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(499), 29,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_AMP_DOT_DOT,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [5506] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(371), 1,
      anon_sym_PIPE,
    ACTIONS(377), 1,
      anon_sym_AMP,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(385), 1,
      anon_sym_CARET,
    ACTIONS(415), 1,
      anon_sym_AMP_AMP,
    STATE(118), 1,
      sym_assignment_op,
    ACTIONS(375), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(383), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(387), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(389), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(413), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(365), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(503), 4,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(501), 21,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [5588] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(371), 1,
      anon_sym_PIPE,
    ACTIONS(377), 1,
      anon_sym_AMP,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(385), 1,
      anon_sym_CARET,
    ACTIONS(415), 1,
      anon_sym_AMP_AMP,
    ACTIONS(417), 1,
      anon_sym_CARET_CARET,
    STATE(118), 1,
      sym_assignment_op,
    ACTIONS(375), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(383), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(387), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(389), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(413), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(365), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(507), 3,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PIPE_PIPE,
    ACTIONS(505), 21,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [5672] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(371), 1,
      anon_sym_PIPE,
    ACTIONS(377), 1,
      anon_sym_AMP,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(385), 1,
      anon_sym_CARET,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(415), 1,
      anon_sym_AMP_AMP,
    ACTIONS(417), 1,
      anon_sym_CARET_CARET,
    ACTIONS(419), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(511), 1,
      anon_sym_DOT_DOT,
    STATE(118), 1,
      sym_assignment_op,
    ACTIONS(375), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(383), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(387), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(389), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(413), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(365), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(509), 8,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [5762] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(513), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(515), 29,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_AMP_DOT_DOT,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [5816] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(517), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(519), 29,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_AMP_DOT_DOT,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [5870] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(371), 1,
      anon_sym_PIPE,
    ACTIONS(377), 1,
      anon_sym_AMP,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(385), 1,
      anon_sym_CARET,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(415), 1,
      anon_sym_AMP_AMP,
    ACTIONS(417), 1,
      anon_sym_CARET_CARET,
    ACTIONS(419), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(523), 1,
      anon_sym_DOT_DOT,
    STATE(118), 1,
      sym_assignment_op,
    ACTIONS(375), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(383), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(387), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(389), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(413), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(365), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(521), 8,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [5960] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(453), 1,
      sym_type,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [6038] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(371), 1,
      anon_sym_PIPE,
    ACTIONS(377), 1,
      anon_sym_AMP,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(385), 1,
      anon_sym_CARET,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(415), 1,
      anon_sym_AMP_AMP,
    ACTIONS(417), 1,
      anon_sym_CARET_CARET,
    ACTIONS(419), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(527), 1,
      anon_sym_DOT_DOT,
    STATE(118), 1,
      sym_assignment_op,
    ACTIONS(375), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(383), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(387), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(389), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(413), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(365), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(525), 8,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [6128] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(529), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(531), 29,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_AMP_DOT_DOT,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [6182] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(699), 1,
      sym_type,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [6260] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(182), 1,
      sym_type,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [6338] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(510), 1,
      sym_type,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [6416] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(470), 1,
      sym_type,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [6494] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(184), 1,
      sym_type,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [6572] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(533), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(535), 29,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_AMP_DOT_DOT,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [6626] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(539), 29,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_AMP_DOT_DOT,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [6680] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(541), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(543), 29,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_AMP_DOT_DOT,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [6734] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(686), 1,
      sym_type,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [6812] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(545), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(547), 29,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_AMP_DOT_DOT,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [6866] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(549), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(551), 29,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_AMP_DOT_DOT,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [6920] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(371), 1,
      anon_sym_PIPE,
    ACTIONS(377), 1,
      anon_sym_AMP,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(385), 1,
      anon_sym_CARET,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(415), 1,
      anon_sym_AMP_AMP,
    ACTIONS(417), 1,
      anon_sym_CARET_CARET,
    ACTIONS(419), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(555), 1,
      anon_sym_DOT_DOT,
    STATE(118), 1,
      sym_assignment_op,
    ACTIONS(375), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(383), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(387), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(389), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(413), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(365), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(553), 8,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [7010] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(371), 1,
      anon_sym_PIPE,
    ACTIONS(377), 1,
      anon_sym_AMP,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(385), 1,
      anon_sym_CARET,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(415), 1,
      anon_sym_AMP_AMP,
    ACTIONS(417), 1,
      anon_sym_CARET_CARET,
    ACTIONS(419), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(559), 1,
      anon_sym_DOT_DOT,
    STATE(118), 1,
      sym_assignment_op,
    ACTIONS(375), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(383), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(387), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(389), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(413), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(365), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(557), 8,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [7100] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(217), 1,
      sym_type,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [7178] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(606), 1,
      sym_type,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [7256] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(555), 1,
      sym_type,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [7334] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(508), 1,
      sym_type,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [7412] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_const,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(556), 1,
      sym_type,
    STATE(213), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(193), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [7490] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(373), 5,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(367), 22,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [7567] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(229), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [7620] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(523), 1,
      anon_sym_DOT_DOT,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(521), 7,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [7709] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(585), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(587), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [7762] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(589), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(591), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [7815] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(593), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(595), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [7868] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(597), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(599), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [7921] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(601), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(603), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [7974] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(605), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(607), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [8027] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(609), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(611), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [8080] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(613), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(615), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [8133] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(617), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(619), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [8186] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(621), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(623), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [8239] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(625), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(627), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [8292] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(555), 1,
      anon_sym_DOT_DOT,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(553), 7,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [8381] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(629), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(631), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [8434] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(633), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(635), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [8487] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(637), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(639), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [8540] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(643), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [8593] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(645), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(647), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [8646] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(649), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(651), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [8699] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(653), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(655), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [8752] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(657), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(659), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [8805] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(661), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(663), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [8858] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(665), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(667), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [8911] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 1,
      anon_sym_DOT_DOT,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(361), 7,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [9000] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(361), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [9053] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(559), 1,
      anon_sym_DOT_DOT,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(557), 7,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [9142] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(669), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(671), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [9195] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(677), 1,
      anon_sym_else,
    ACTIONS(673), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(675), 27,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [9250] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(429), 1,
      anon_sym_DOT_DOT,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(427), 7,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [9339] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(679), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(681), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [9392] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(527), 1,
      anon_sym_DOT_DOT,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(525), 7,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [9481] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(511), 1,
      anon_sym_DOT_DOT,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(509), 7,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [9570] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(507), 3,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PIPE_PIPE,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(505), 20,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [9653] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(683), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(685), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [9706] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(503), 4,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(501), 20,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [9787] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(687), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(689), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [9840] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(495), 5,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(493), 20,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [9919] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(491), 7,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(489), 24,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [9992] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(691), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(693), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [10045] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(695), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(697), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [10098] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(567), 1,
      anon_sym_AMP,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(487), 9,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(485), 24,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [10167] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(699), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(701), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [10220] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(483), 12,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(481), 24,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [10285] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(703), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(705), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [10338] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(707), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(709), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [10391] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(711), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [10444] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(479), 10,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(477), 24,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [10511] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(715), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(717), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [10564] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(471), 14,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(469), 24,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [10627] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(467), 8,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(465), 24,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [10698] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(719), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(721), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [10751] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(443), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(445), 24,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [10812] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(723), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(725), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [10865] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(727), 1,
      anon_sym_else,
    ACTIONS(673), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(675), 27,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [10920] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(403), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(405), 27,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [10975] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(729), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(731), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [11028] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(735), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [11081] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(737), 17,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_CARET_CARET,
      anon_sym_PIPE_PIPE,
    ACTIONS(739), 28,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_as,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_EQ_GT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [11134] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(741), 1,
      anon_sym_BANG,
    STATE(183), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(743), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [11206] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(747), 14,
      anon_sym_BANG,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_floating_literal,
      anon_sym_SQUOTE,
      aux_sym_string_literal_token1,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_AMP,
    ACTIONS(745), 30,
      sym_identifier,
      anon_sym_void,
      anon_sym_size,
      anon_sym_struct,
      anon_sym_true,
      anon_sym_false,
      anon_sym_null,
      sym_integer_literal,
      anon_sym_alloc,
      anon_sym_free,
      anon_sym_static,
      anon_sym_assert,
      anon_sym_abort,
      anon_sym_align,
      anon_sym_len,
      anon_sym_offset,
      anon_sym_append,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_vastart,
      anon_sym_vaarg,
      anon_sym_vaend,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_match,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_return,
      anon_sym_yield,
  [11258] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(183), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(743), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [11327] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(195), 1,
      anon_sym_STAR,
    ACTIONS(197), 1,
      anon_sym_nullable,
    ACTIONS(199), 1,
      anon_sym_struct,
    ACTIONS(201), 1,
      anon_sym_union,
    ACTIONS(203), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_LBRACK,
    ACTIONS(207), 1,
      anon_sym_fn,
    ACTIONS(209), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(223), 12,
      sym__storage_class,
      sym__primitive_type,
      sym__integer_type,
      sym__floating_type,
      sym_pointer_type,
      sym_struct_union_type,
      sym_tuple_type,
      sym_tagged_union_type,
      sym_slice_array_type,
      sym_function_type,
      sym_alias_type,
      sym_unwrapped_alias,
    ACTIONS(749), 22,
      anon_sym_rune,
      anon_sym_bool,
      anon_sym_valist,
      anon_sym_void,
      anon_sym_opaque,
      anon_sym_done,
      anon_sym_never,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_int,
      anon_sym_uint,
      anon_sym_size,
      anon_sym_uintptr,
      anon_sym_f32,
      anon_sym_f64,
      sym__string_type,
  [11396] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(751), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [11479] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(753), 1,
      anon_sym_COMMA,
    ACTIONS(755), 1,
      anon_sym_RBRACK,
    ACTIONS(757), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(72), 1,
      sym_assignment_op,
    STATE(475), 1,
      aux_sym_array_literal_repeat1,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [11568] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(759), 1,
      anon_sym_COMMA,
    ACTIONS(761), 1,
      anon_sym_RBRACK,
    ACTIONS(763), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(72), 1,
      sym_assignment_op,
    STATE(465), 1,
      aux_sym_array_literal_repeat1,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [11657] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(765), 1,
      anon_sym_COMMA,
    ACTIONS(767), 1,
      anon_sym_RPAREN,
    ACTIONS(769), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [11743] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(771), 1,
      anon_sym_COMMA,
    ACTIONS(773), 1,
      anon_sym_RPAREN,
    ACTIONS(775), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [11829] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(777), 1,
      anon_sym_COMMA,
    ACTIONS(779), 1,
      anon_sym_RPAREN,
    ACTIONS(781), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [11915] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(783), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [11997] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(785), 1,
      anon_sym_COMMA,
    ACTIONS(787), 1,
      anon_sym_RPAREN,
    STATE(72), 1,
      sym_assignment_op,
    STATE(489), 1,
      aux_sym_array_literal_repeat1,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [12083] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(789), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [12165] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(791), 1,
      anon_sym_COMMA,
    ACTIONS(793), 1,
      anon_sym_RPAREN,
    ACTIONS(795), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [12251] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(785), 1,
      anon_sym_COMMA,
    ACTIONS(797), 1,
      anon_sym_RPAREN,
    STATE(72), 1,
      sym_assignment_op,
    STATE(511), 1,
      aux_sym_array_literal_repeat1,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [12337] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(799), 1,
      anon_sym_COMMA,
    ACTIONS(801), 1,
      anon_sym_RPAREN,
    ACTIONS(803), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [12423] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(805), 1,
      anon_sym_COMMA,
    ACTIONS(807), 1,
      anon_sym_RPAREN,
    ACTIONS(809), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [12509] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(811), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [12590] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(813), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [12671] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(815), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [12752] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(817), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [12833] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(819), 1,
      anon_sym_RBRACK,
    ACTIONS(821), 1,
      anon_sym_DOT_DOT,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [12916] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(823), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [12997] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(825), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [13078] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(827), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [13159] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(829), 1,
      anon_sym_RPAREN,
    ACTIONS(831), 1,
      anon_sym_SEMI,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [13242] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(833), 1,
      anon_sym_RBRACK,
    ACTIONS(835), 1,
      anon_sym_DOT_DOT,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [13325] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(837), 1,
      anon_sym_RPAREN,
    ACTIONS(839), 1,
      anon_sym_SEMI,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [13408] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(841), 1,
      anon_sym_COMMA,
    ACTIONS(843), 1,
      anon_sym_EQ_GT,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [13491] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(845), 1,
      anon_sym_COMMA,
    ACTIONS(847), 1,
      anon_sym_RPAREN,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [13574] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(849), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [13655] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(851), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [13736] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(853), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [13817] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(855), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [13898] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(857), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [13979] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(859), 1,
      anon_sym_COMMA,
    ACTIONS(861), 1,
      anon_sym_RPAREN,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [14062] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(863), 1,
      anon_sym_SEMI,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [14142] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(865), 1,
      anon_sym_RPAREN,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [14222] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(867), 1,
      anon_sym_RPAREN,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,
  [14302] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_as,
    ACTIONS(381), 1,
      anon_sym_is,
    ACTIONS(411), 1,
      anon_sym_EQ,
    ACTIONS(563), 1,
      anon_sym_PIPE,
    ACTIONS(567), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_CARET,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_CARET_CARET,
    ACTIONS(583), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(869), 1,
      anon_sym_RPAREN,
    STATE(72), 1,
      sym_assignment_op,
    ACTIONS(565), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(569), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(561), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_CARET_CARET_EQ,