#include "main.h"
#include "sysdeps.h"
#include "hatari-glue.h"
#include "maccess.h"
#include "memory.h"
#include "custom.h"
#include "newcpu.h"
#include "cpu_prefetch.h"
#include "cputbl.h"
#include "debugmem.h"
#include "cpummu.h"
#define SET_ALWAYS_CFLG(x) SET_CFLG(x)
#define SET_ALWAYS_NFLG(x) SET_NFLG(x)
/* OR.B #<data>.B,Dn */
uae_u32 REGPARAM2 op_0000_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 8;  
	uae_s8 src = get_ibyte_mmu060(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.B #<data>.B,(An) */
uae_u32 REGPARAM2 op_0010_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.B #<data>.B,(An)+ */
uae_u32 REGPARAM2 op_0018_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.B #<data>.B,-(An) */
uae_u32 REGPARAM2 op_0020_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 18; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.B #<data>.B,(d16,An) */
uae_u32 REGPARAM2 op_0028_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 20; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* OR.B #<data>.B,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0030_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 20; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* OR.B #<data>.B,(xxx).W */
uae_u32 REGPARAM2 op_0038_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 1;
	CurrentInstrCycles = 20; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* OR.B #<data>.B,(xxx).L */
uae_u32 REGPARAM2 op_0039_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 1;
	CurrentInstrCycles = 24; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* ORSR.B #<data>.W */
uae_u32 REGPARAM2 op_003c_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 4;
	CurrentInstrCycles = 16; 
	MakeSR();
	uae_s16 src = get_iword_mmu060(2);
	src &= 0xFF;
	regs.sr |= src;
	MakeFromSR();
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_0040_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_iword_mmu060(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.W #<data>.W,(An) */
uae_u32 REGPARAM2 op_0050_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.W #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_0058_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	m68k_areg(regs, dstreg) += 2;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.W #<data>.W,-(An) */
uae_u32 REGPARAM2 op_0060_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_0068_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* OR.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0070_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* OR.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_0078_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 1;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* OR.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_0079_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 1;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* ORSR.W #<data>.W */
uae_u32 REGPARAM2 op_007c_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 4;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	MakeSR();
	uae_s16 src = get_iword_mmu060(2);
	if(regs.t0) check_t0_trace();
	regs.sr |= src;
	MakeFromSR();
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.L #<data>.L,Dn */
uae_u32 REGPARAM2 op_0080_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 14; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* OR.L #<data>.L,(An) */
uae_u32 REGPARAM2 op_0090_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* OR.L #<data>.L,(An)+ */
uae_u32 REGPARAM2 op_0098_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	m68k_areg(regs, dstreg) += 4;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(6);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* OR.L #<data>.L,-(An) */
uae_u32 REGPARAM2 op_00a0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 30; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(6);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* OR.L #<data>.L,(d16,An) */
uae_u32 REGPARAM2 op_00a8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(6);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* OR.L #<data>.L,(d8,An,Xn) */
uae_u32 REGPARAM2 op_00b0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 2,0   */

/* OR.L #<data>.L,(xxx).W */
uae_u32 REGPARAM2 op_00b8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 1;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(6);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* OR.L #<data>.L,(xxx).L */
uae_u32 REGPARAM2 op_00b9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 1;
	CurrentInstrCycles = 36; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(6);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(10);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 10 0,0   */

/* CHK2.B #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_00d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	CurrentInstrCycles = 8;  
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)get_byte_mmu060(dsta);
	upper = (uae_s32)(uae_s8)get_byte_mmu060(dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	m68k_incpci(4);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 0);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* CHK2.B #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_00e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	CurrentInstrCycles = 12; 
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)get_byte_mmu060(dsta);
	upper = (uae_s32)(uae_s8)get_byte_mmu060(dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 0);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CHK2.B #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_00f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	CurrentInstrCycles = 12; 
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)get_byte_mmu060(dsta);
	upper = (uae_s32)(uae_s8)get_byte_mmu060(dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 0);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

#endif
/* CHK2.B #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_00f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 81;
	CurrentInstrCycles = 12; 
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)get_byte_mmu060(dsta);
	upper = (uae_s32)(uae_s8)get_byte_mmu060(dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 0);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CHK2.B #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_00f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 81;
	CurrentInstrCycles = 16; 
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)get_byte_mmu060(dsta);
	upper = (uae_s32)(uae_s8)get_byte_mmu060(dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	m68k_incpci(8);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 0);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

#endif
/* CHK2.B #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_00fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 81;
	CurrentInstrCycles = 12; 
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)get_byte_mmu060(dsta);
	upper = (uae_s32)(uae_s8)get_byte_mmu060(dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 0);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CHK2.B #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_00fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 81;
	CurrentInstrCycles = 12; 
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	dsta = x_get_disp_ea_020(tmppc, 0);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)get_byte_mmu060(dsta);
	upper = (uae_s32)(uae_s8)get_byte_mmu060(dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 0);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

#endif
/* BTST.L Dn,Dn */
uae_u32 REGPARAM2 op_0100_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 6;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= 31;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MVPMR.W (d16,An),Dn */
uae_u32 REGPARAM2 op_0108_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 29;
	CurrentInstrCycles = 16; 
	uaecptr mempa = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_u16 val  = (get_byte_mmu060(mempa) & 0xff) << 8;
	val |= (get_byte_mmu060(mempa + 2) & 0xff);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BTST.B Dn,(An) */
uae_u32 REGPARAM2 op_0110_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 8;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* BTST.B Dn,(An)+ */
uae_u32 REGPARAM2 op_0118_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 8;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* BTST.B Dn,-(An) */
uae_u32 REGPARAM2 op_0120_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 10; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* BTST.B Dn,(d16,An) */
uae_u32 REGPARAM2 op_0128_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 dst = get_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BTST.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0130_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = get_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* BTST.B Dn,(xxx).W */
uae_u32 REGPARAM2 op_0138_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 21;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 dst = get_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BTST.B Dn,(xxx).L */
uae_u32 REGPARAM2 op_0139_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 21;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	uae_s8 dst = get_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* BTST.B Dn,(d16,PC) */
uae_u32 REGPARAM2 op_013a_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = 2;
	OpcodeFamily = 21;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_getpci() + 2;
	dsta += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 dst = get_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BTST.B Dn,(d8,PC,Xn) */
uae_u32 REGPARAM2 op_013b_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = 3;
	OpcodeFamily = 21;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	dsta = x_get_disp_ea_020(tmppc, 0);
	uae_s8 dst = get_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* BTST.B Dn,#<data>.B */
uae_u32 REGPARAM2 op_013c_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 21;
	CurrentInstrCycles = 10; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_s8 dst = get_ibyte_mmu060(2);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BCHG.L Dn,Dn */
uae_u32 REGPARAM2 op_0140_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 6;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= 31;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MVPMR.L (d16,An),Dn */
uae_u32 REGPARAM2 op_0148_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 29;
	CurrentInstrCycles = 24; 
	uaecptr mempa = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_u32 val  = (get_byte_mmu060(mempa) & 0xff) << 24;
	val |= (get_byte_mmu060(mempa + 2) & 0xff) << 16;
	val |= (get_byte_mmu060(mempa + 4) & 0xff) << 8;
	val |= (get_byte_mmu060(mempa + 6) & 0xff);
	m68k_dreg(regs, dstreg) = (val);
	m68k_incpci(4);
	return (4 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BCHG.B Dn,(An) */
uae_u32 REGPARAM2 op_0150_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* BCHG.B Dn,(An)+ */
uae_u32 REGPARAM2 op_0158_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* BCHG.B Dn,-(An) */
uae_u32 REGPARAM2 op_0160_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* BCHG.B Dn,(d16,An) */
uae_u32 REGPARAM2 op_0168_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BCHG.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0170_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	put_rmw_byte_mmu060(dsta, dst);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* BCHG.B Dn,(xxx).W */
uae_u32 REGPARAM2 op_0178_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 22;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BCHG.B Dn,(xxx).L */
uae_u32 REGPARAM2 op_0179_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 22;
	CurrentInstrCycles = 20; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* BCLR.L Dn,Dn */
uae_u32 REGPARAM2 op_0180_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 8;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= 31;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MVPRM.W Dn,(d16,An) */
uae_u32 REGPARAM2 op_0188_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 28;
	CurrentInstrCycles = 16; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr mempa = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	put_byte_mmu060(mempa, src >> 8);
	put_byte_mmu060(mempa + 2, src); 
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BCLR.B Dn,(An) */
uae_u32 REGPARAM2 op_0190_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* BCLR.B Dn,(An)+ */
uae_u32 REGPARAM2 op_0198_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* BCLR.B Dn,-(An) */
uae_u32 REGPARAM2 op_01a0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* BCLR.B Dn,(d16,An) */
uae_u32 REGPARAM2 op_01a8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BCLR.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_01b0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_rmw_byte_mmu060(dsta, dst);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* BCLR.B Dn,(xxx).W */
uae_u32 REGPARAM2 op_01b8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 23;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BCLR.B Dn,(xxx).L */
uae_u32 REGPARAM2 op_01b9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 23;
	CurrentInstrCycles = 20; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* BSET.L Dn,Dn */
uae_u32 REGPARAM2 op_01c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 6;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= 31;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MVPRM.L Dn,(d16,An) */
uae_u32 REGPARAM2 op_01c8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 28;
	CurrentInstrCycles = 24; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr mempa = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	put_byte_mmu060(mempa, src >> 24);
	put_byte_mmu060(mempa + 2, src >> 16);
	put_byte_mmu060(mempa + 4, src >> 8);
	put_byte_mmu060(mempa + 6, src); 
	m68k_incpci(4);
	return (4 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BSET.B Dn,(An) */
uae_u32 REGPARAM2 op_01d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* BSET.B Dn,(An)+ */
uae_u32 REGPARAM2 op_01d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* BSET.B Dn,-(An) */
uae_u32 REGPARAM2 op_01e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* BSET.B Dn,(d16,An) */
uae_u32 REGPARAM2 op_01e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BSET.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_01f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_rmw_byte_mmu060(dsta, dst);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* BSET.B Dn,(xxx).W */
uae_u32 REGPARAM2 op_01f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 24;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BSET.B Dn,(xxx).L */
uae_u32 REGPARAM2 op_01f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 24;
	CurrentInstrCycles = 20; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* AND.B #<data>.B,Dn */
uae_u32 REGPARAM2 op_0200_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 8;  
	uae_s8 src = get_ibyte_mmu060(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.B #<data>.B,(An) */
uae_u32 REGPARAM2 op_0210_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.B #<data>.B,(An)+ */
uae_u32 REGPARAM2 op_0218_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.B #<data>.B,-(An) */
uae_u32 REGPARAM2 op_0220_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 18; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.B #<data>.B,(d16,An) */
uae_u32 REGPARAM2 op_0228_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 20; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* AND.B #<data>.B,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0230_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 20; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* AND.B #<data>.B,(xxx).W */
uae_u32 REGPARAM2 op_0238_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 2;
	CurrentInstrCycles = 20; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* AND.B #<data>.B,(xxx).L */
uae_u32 REGPARAM2 op_0239_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 2;
	CurrentInstrCycles = 24; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* ANDSR.B #<data>.W */
uae_u32 REGPARAM2 op_023c_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 5;
	CurrentInstrCycles = 16; 
	MakeSR();
	uae_s16 src = get_iword_mmu060(2);
	src &= 0xFF;
	src |= 0xff00;
	regs.sr &= src;
	MakeFromSR();
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_0240_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_iword_mmu060(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.W #<data>.W,(An) */
uae_u32 REGPARAM2 op_0250_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.W #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_0258_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	m68k_areg(regs, dstreg) += 2;
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.W #<data>.W,-(An) */
uae_u32 REGPARAM2 op_0260_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_0268_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* AND.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0270_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* AND.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_0278_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 2;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* AND.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_0279_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 2;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* ANDSR.W #<data>.W */
uae_u32 REGPARAM2 op_027c_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 5;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	MakeSR();
	uae_s16 src = get_iword_mmu060(2);
	if(regs.t0) check_t0_trace();
	regs.sr &= src;
	MakeFromSR();
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.L #<data>.L,Dn */
uae_u32 REGPARAM2 op_0280_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 14; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* AND.L #<data>.L,(An) */
uae_u32 REGPARAM2 op_0290_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* AND.L #<data>.L,(An)+ */
uae_u32 REGPARAM2 op_0298_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	m68k_areg(regs, dstreg) += 4;
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(6);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* AND.L #<data>.L,-(An) */
uae_u32 REGPARAM2 op_02a0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 30; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(6);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* AND.L #<data>.L,(d16,An) */
uae_u32 REGPARAM2 op_02a8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(6);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* AND.L #<data>.L,(d8,An,Xn) */
uae_u32 REGPARAM2 op_02b0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 2,0   */

/* AND.L #<data>.L,(xxx).W */
uae_u32 REGPARAM2 op_02b8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 2;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(6);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* AND.L #<data>.L,(xxx).L */
uae_u32 REGPARAM2 op_02b9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 2;
	CurrentInstrCycles = 36; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(6);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(10);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 10 0,0   */

/* CHK2.W #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_02d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	CurrentInstrCycles = 8;  
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)get_word_mmu060(dsta);
	upper = (uae_s32)(uae_s16)get_word_mmu060(dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	m68k_incpci(4);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 1);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* CHK2.W #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_02e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	CurrentInstrCycles = 12; 
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)get_word_mmu060(dsta);
	upper = (uae_s32)(uae_s16)get_word_mmu060(dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 1);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CHK2.W #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_02f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	CurrentInstrCycles = 12; 
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)get_word_mmu060(dsta);
	upper = (uae_s32)(uae_s16)get_word_mmu060(dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 1);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

#endif
/* CHK2.W #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_02f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 81;
	CurrentInstrCycles = 12; 
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)get_word_mmu060(dsta);
	upper = (uae_s32)(uae_s16)get_word_mmu060(dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 1);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CHK2.W #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_02f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 81;
	CurrentInstrCycles = 16; 
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)get_word_mmu060(dsta);
	upper = (uae_s32)(uae_s16)get_word_mmu060(dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	m68k_incpci(8);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 1);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

#endif
/* CHK2.W #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_02fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 81;
	CurrentInstrCycles = 12; 
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)get_word_mmu060(dsta);
	upper = (uae_s32)(uae_s16)get_word_mmu060(dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 1);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CHK2.W #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_02fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 81;
	CurrentInstrCycles = 12; 
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	dsta = x_get_disp_ea_020(tmppc, 0);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)get_word_mmu060(dsta);
	upper = (uae_s32)(uae_s16)get_word_mmu060(dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 1);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

#endif
/* SUB.B #<data>.B,Dn */
uae_u32 REGPARAM2 op_0400_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 8;  
	uae_s8 src = get_ibyte_mmu060(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.B #<data>.B,(An) */
uae_u32 REGPARAM2 op_0410_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.B #<data>.B,(An)+ */
uae_u32 REGPARAM2 op_0418_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.B #<data>.B,-(An) */
uae_u32 REGPARAM2 op_0420_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 18; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.B #<data>.B,(d16,An) */
uae_u32 REGPARAM2 op_0428_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUB.B #<data>.B,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0430_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* SUB.B #<data>.B,(xxx).W */
uae_u32 REGPARAM2 op_0438_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUB.B #<data>.B,(xxx).L */
uae_u32 REGPARAM2 op_0439_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 7;
	CurrentInstrCycles = 24; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* SUB.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_0440_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_iword_mmu060(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.W #<data>.W,(An) */
uae_u32 REGPARAM2 op_0450_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.W #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_0458_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	m68k_areg(regs, dstreg) += 2;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.W #<data>.W,-(An) */
uae_u32 REGPARAM2 op_0460_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_0468_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUB.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0470_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* SUB.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_0478_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUB.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_0479_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 7;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* SUB.L #<data>.L,Dn */
uae_u32 REGPARAM2 op_0480_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 14; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUB.L #<data>.L,(An) */
uae_u32 REGPARAM2 op_0490_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUB.L #<data>.L,(An)+ */
uae_u32 REGPARAM2 op_0498_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	m68k_areg(regs, dstreg) += 4;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	m68k_incpci(6);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUB.L #<data>.L,-(An) */
uae_u32 REGPARAM2 op_04a0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 30; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	m68k_incpci(6);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUB.L #<data>.L,(d16,An) */
uae_u32 REGPARAM2 op_04a8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(6);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* SUB.L #<data>.L,(d8,An,Xn) */
uae_u32 REGPARAM2 op_04b0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 2,0   */

/* SUB.L #<data>.L,(xxx).W */
uae_u32 REGPARAM2 op_04b8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 7;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(6);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* SUB.L #<data>.L,(xxx).L */
uae_u32 REGPARAM2 op_04b9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 7;
	CurrentInstrCycles = 36; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(6);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	m68k_incpci(10);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 10 0,0   */

/* CHK2.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_04d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	CurrentInstrCycles = 8;  
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = get_long_mmu060(dsta); upper = get_long_mmu060(dsta + 4);
	m68k_incpci(4);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 2);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* CHK2.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_04e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	CurrentInstrCycles = 12; 
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = get_long_mmu060(dsta); upper = get_long_mmu060(dsta + 4);
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 2);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CHK2.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_04f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	CurrentInstrCycles = 12; 
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = get_long_mmu060(dsta); upper = get_long_mmu060(dsta + 4);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 2);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

#endif
/* CHK2.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_04f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 81;
	CurrentInstrCycles = 12; 
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = get_long_mmu060(dsta); upper = get_long_mmu060(dsta + 4);
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 2);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CHK2.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_04f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 81;
	CurrentInstrCycles = 16; 
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = get_long_mmu060(dsta); upper = get_long_mmu060(dsta + 4);
	m68k_incpci(8);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 2);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

#endif
/* CHK2.L #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_04fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 81;
	CurrentInstrCycles = 12; 
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = get_long_mmu060(dsta); upper = get_long_mmu060(dsta + 4);
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 2);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CHK2.L #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_04fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 81;
	CurrentInstrCycles = 12; 
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	dsta = x_get_disp_ea_020(tmppc, 0);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = get_long_mmu060(dsta); upper = get_long_mmu060(dsta + 4);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 2);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

#endif
/* ADD.B #<data>.B,Dn */
uae_u32 REGPARAM2 op_0600_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 8;  
	uae_s8 src = get_ibyte_mmu060(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* ADD.B #<data>.B,(An) */
uae_u32 REGPARAM2 op_0610_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 16; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* ADD.B #<data>.B,(An)+ */
uae_u32 REGPARAM2 op_0618_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 16; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* ADD.B #<data>.B,-(An) */
uae_u32 REGPARAM2 op_0620_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 18; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* ADD.B #<data>.B,(d16,An) */
uae_u32 REGPARAM2 op_0628_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 20; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* ADD.B #<data>.B,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0630_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 20; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* ADD.B #<data>.B,(xxx).W */
uae_u32 REGPARAM2 op_0638_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 11;
	CurrentInstrCycles = 20; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* ADD.B #<data>.B,(xxx).L */
uae_u32 REGPARAM2 op_0639_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 11;
	CurrentInstrCycles = 24; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* ADD.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_0640_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_iword_mmu060(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* ADD.W #<data>.W,(An) */
uae_u32 REGPARAM2 op_0650_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* ADD.W #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_0658_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	m68k_areg(regs, dstreg) += 2;
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* ADD.W #<data>.W,-(An) */
uae_u32 REGPARAM2 op_0660_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* ADD.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_0668_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* ADD.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0670_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* ADD.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_0678_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 11;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* ADD.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_0679_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 11;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* ADD.L #<data>.L,Dn */
uae_u32 REGPARAM2 op_0680_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 14; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* ADD.L #<data>.L,(An) */
uae_u32 REGPARAM2 op_0690_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* ADD.L #<data>.L,(An)+ */
uae_u32 REGPARAM2 op_0698_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	m68k_areg(regs, dstreg) += 4;
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	m68k_incpci(6);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* ADD.L #<data>.L,-(An) */
uae_u32 REGPARAM2 op_06a0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 30; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	m68k_incpci(6);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* ADD.L #<data>.L,(d16,An) */
uae_u32 REGPARAM2 op_06a8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(6);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* ADD.L #<data>.L,(d8,An,Xn) */
uae_u32 REGPARAM2 op_06b0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 2,0   */

/* ADD.L #<data>.L,(xxx).W */
uae_u32 REGPARAM2 op_06b8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 11;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(6);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* ADD.L #<data>.L,(xxx).L */
uae_u32 REGPARAM2 op_06b9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 11;
	CurrentInstrCycles = 36; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(6);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	m68k_incpci(10);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 10 0,0   */

/* RTM.L Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_06c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 101;
	CurrentInstrCycles = 0;  
	m68k_incpci(2);
	op_illg(opcode);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* RTM.L An */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_06c8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 101;
	CurrentInstrCycles = 0;  
	m68k_incpci(2);
	op_illg(opcode);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* CALLM.L (An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_06d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 100;
	CurrentInstrCycles = 0;  
	m68k_incpci(2);
	op_illg(opcode);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* CALLM.L (d16,An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_06e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 100;
	CurrentInstrCycles = 0;  
	m68k_incpci(2);
	op_illg(opcode);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* CALLM.L (d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_06f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 100;
	CurrentInstrCycles = 0;  
	m68k_incpci(2);
	op_illg(opcode);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* CALLM.L (xxx).W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_06f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 100;
	CurrentInstrCycles = 0;  
	m68k_incpci(2);
	op_illg(opcode);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* CALLM.L (xxx).L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_06f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 100;
	CurrentInstrCycles = 0;  
	m68k_incpci(2);
	op_illg(opcode);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* CALLM.L (d16,PC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_06fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 100;
	CurrentInstrCycles = 0;  
	m68k_incpci(2);
	op_illg(opcode);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* CALLM.L (d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_06fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 100;
	CurrentInstrCycles = 0;  
	m68k_incpci(2);
	op_illg(opcode);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* BTST.L #<data>.W,Dn */
uae_u32 REGPARAM2 op_0800_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 10; 
	uae_s16 src = get_iword_mmu060(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= 31;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BTST.B #<data>.W,(An) */
uae_u32 REGPARAM2 op_0810_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BTST.B #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_0818_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BTST.B #<data>.W,-(An) */
uae_u32 REGPARAM2 op_0820_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 14; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BTST.B #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_0828_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s8 dst = get_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* BTST.B #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0830_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = get_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* BTST.B #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_0838_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 21;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s8 dst = get_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* BTST.B #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_0839_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 21;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	uae_s8 dst = get_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(8);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* BTST.B #<data>.W,(d16,PC) */
uae_u32 REGPARAM2 op_083a_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 21;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s8 dst = get_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* BTST.B #<data>.W,(d8,PC,Xn) */
uae_u32 REGPARAM2 op_083b_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 21;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	dsta = x_get_disp_ea_020(tmppc, 0);
	uae_s8 dst = get_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* BCHG.L #<data>.W,Dn */
uae_u32 REGPARAM2 op_0840_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 10; 
	uae_s16 src = get_iword_mmu060(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= 31;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BCHG.B #<data>.W,(An) */
uae_u32 REGPARAM2 op_0850_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BCHG.B #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_0858_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BCHG.B #<data>.W,-(An) */
uae_u32 REGPARAM2 op_0860_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BCHG.B #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_0868_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* BCHG.B #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0870_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	put_rmw_byte_mmu060(dsta, dst);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* BCHG.B #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_0878_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 22;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* BCHG.B #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_0879_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 22;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* BCLR.L #<data>.W,Dn */
uae_u32 REGPARAM2 op_0880_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_iword_mmu060(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= 31;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BCLR.B #<data>.W,(An) */
uae_u32 REGPARAM2 op_0890_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BCLR.B #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_0898_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BCLR.B #<data>.W,-(An) */
uae_u32 REGPARAM2 op_08a0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BCLR.B #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_08a8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* BCLR.B #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_08b0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_rmw_byte_mmu060(dsta, dst);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* BCLR.B #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_08b8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 23;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* BCLR.B #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_08b9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 23;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* BSET.L #<data>.W,Dn */
uae_u32 REGPARAM2 op_08c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 10; 
	uae_s16 src = get_iword_mmu060(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= 31;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BSET.B #<data>.W,(An) */
uae_u32 REGPARAM2 op_08d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BSET.B #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_08d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BSET.B #<data>.W,-(An) */
uae_u32 REGPARAM2 op_08e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BSET.B #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_08e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* BSET.B #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_08f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_rmw_byte_mmu060(dsta, dst);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* BSET.B #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_08f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 24;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* BSET.B #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_08f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 24;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_rmw_byte_mmu060(dsta, dst);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* EOR.B #<data>.B,Dn */
uae_u32 REGPARAM2 op_0a00_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 8;  
	uae_s8 src = get_ibyte_mmu060(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.B #<data>.B,(An) */
uae_u32 REGPARAM2 op_0a10_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 16; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.B #<data>.B,(An)+ */
uae_u32 REGPARAM2 op_0a18_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 16; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.B #<data>.B,-(An) */
uae_u32 REGPARAM2 op_0a20_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 18; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.B #<data>.B,(d16,An) */
uae_u32 REGPARAM2 op_0a28_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 20; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* EOR.B #<data>.B,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0a30_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 20; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* EOR.B #<data>.B,(xxx).W */
uae_u32 REGPARAM2 op_0a38_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 3;
	CurrentInstrCycles = 20; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* EOR.B #<data>.B,(xxx).L */
uae_u32 REGPARAM2 op_0a39_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 3;
	CurrentInstrCycles = 24; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* EORSR.B #<data>.W */
uae_u32 REGPARAM2 op_0a3c_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 6;
	CurrentInstrCycles = 16; 
	MakeSR();
	uae_s16 src = get_iword_mmu060(2);
	src &= 0xFF;
	regs.sr ^= src;
	MakeFromSR();
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_0a40_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_iword_mmu060(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.W #<data>.W,(An) */
uae_u32 REGPARAM2 op_0a50_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.W #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_0a58_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	m68k_areg(regs, dstreg) += 2;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.W #<data>.W,-(An) */
uae_u32 REGPARAM2 op_0a60_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_0a68_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* EOR.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0a70_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* EOR.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_0a78_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 3;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* EOR.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_0a79_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 3;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* EORSR.W #<data>.W */
uae_u32 REGPARAM2 op_0a7c_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 6;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	MakeSR();
	uae_s16 src = get_iword_mmu060(2);
	if(regs.t0) check_t0_trace();
	regs.sr ^= src;
	MakeFromSR();
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.L #<data>.L,Dn */
uae_u32 REGPARAM2 op_0a80_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 14; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* EOR.L #<data>.L,(An) */
uae_u32 REGPARAM2 op_0a90_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* EOR.L #<data>.L,(An)+ */
uae_u32 REGPARAM2 op_0a98_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	m68k_areg(regs, dstreg) += 4;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(6);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* EOR.L #<data>.L,-(An) */
uae_u32 REGPARAM2 op_0aa0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 30; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(6);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* EOR.L #<data>.L,(d16,An) */
uae_u32 REGPARAM2 op_0aa8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(6);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* EOR.L #<data>.L,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0ab0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 2,0   */

/* EOR.L #<data>.L,(xxx).W */
uae_u32 REGPARAM2 op_0ab8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 3;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(6);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* EOR.L #<data>.L,(xxx).L */
uae_u32 REGPARAM2 op_0ab9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 3;
	CurrentInstrCycles = 36; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(6);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(10);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 10 0,0   */

/* CAS.B #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0ad0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_lrmw_byte_mmu060(dsta);
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_byte_mmu060(dsta, (m68k_dreg(regs, ru)));
	} else {
		put_lrmw_byte_mmu060(dsta, dst);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
	}
	m68k_incpci(4);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* CAS.B #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0ad8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_lrmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_byte_mmu060(dsta, (m68k_dreg(regs, ru)));
	} else {
		put_lrmw_byte_mmu060(dsta, dst);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
	}
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* CAS.B #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0ae0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	CurrentInstrCycles = 22; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_lrmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_byte_mmu060(dsta, (m68k_dreg(regs, ru)));
	} else {
		put_lrmw_byte_mmu060(dsta, dst);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
	}
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* CAS.B #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0ae8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s8 dst = get_lrmw_byte_mmu060(dsta);
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_byte_mmu060(dsta, (m68k_dreg(regs, ru)));
	} else {
		put_lrmw_byte_mmu060(dsta, dst);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
	}
	m68k_incpci(6);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CAS.B #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0af0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = get_lrmw_byte_mmu060(dsta);
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_byte_mmu060(dsta, (m68k_dreg(regs, ru)));
	} else {
		put_lrmw_byte_mmu060(dsta, dst);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
	}
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

#endif
/* CAS.B #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0af8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 84;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s8 dst = get_lrmw_byte_mmu060(dsta);
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_byte_mmu060(dsta, (m68k_dreg(regs, ru)));
	} else {
		put_lrmw_byte_mmu060(dsta, dst);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
	}
	m68k_incpci(6);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CAS.B #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0af9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 84;
	CurrentInstrCycles = 28; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	uae_s8 dst = get_lrmw_byte_mmu060(dsta);
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_byte_mmu060(dsta, (m68k_dreg(regs, ru)));
	} else {
		put_lrmw_byte_mmu060(dsta, dst);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
	}
	m68k_incpci(8);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

#endif
/* CMP.B #<data>.B,Dn */
uae_u32 REGPARAM2 op_0c00_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 8;  
	uae_s8 src = get_ibyte_mmu060(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.B #<data>.B,(An) */
uae_u32 REGPARAM2 op_0c10_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu060(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.B #<data>.B,(An)+ */
uae_u32 REGPARAM2 op_0c18_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.B #<data>.B,-(An) */
uae_u32 REGPARAM2 op_0c20_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 14; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.B #<data>.B,(d16,An) */
uae_u32 REGPARAM2 op_0c28_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 16; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s8 dst = get_byte_mmu060(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CMP.B #<data>.B,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0c30_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 16; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = get_byte_mmu060(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* CMP.B #<data>.B,(xxx).W */
uae_u32 REGPARAM2 op_0c38_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 25;
	CurrentInstrCycles = 16; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s8 dst = get_byte_mmu060(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CMP.B #<data>.B,(xxx).L */
uae_u32 REGPARAM2 op_0c39_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 25;
	CurrentInstrCycles = 20; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	uae_s8 dst = get_byte_mmu060(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(8);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* CMP.B #<data>.B,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0c3a_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 25;
	CurrentInstrCycles = 16; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s8 dst = get_byte_mmu060(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CMP.B #<data>.B,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0c3b_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 25;
	CurrentInstrCycles = 16; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	dsta = x_get_disp_ea_020(tmppc, 0);
	uae_s8 dst = get_byte_mmu060(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

#endif
/* CMP.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_0c40_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_iword_mmu060(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.W #<data>.W,(An) */
uae_u32 REGPARAM2 op_0c50_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = get_word_mmu060(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.W #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_0c58_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_word_mmu060(dsta);
	m68k_areg(regs, dstreg) += 2;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.W #<data>.W,-(An) */
uae_u32 REGPARAM2 op_0c60_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 14; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_word_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_0c68_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s16 dst = get_word_mmu060(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CMP.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0c70_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = get_word_mmu060(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* CMP.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_0c78_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 25;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s16 dst = get_word_mmu060(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CMP.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_0c79_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 25;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	uae_s16 dst = get_word_mmu060(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(8);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* CMP.W #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0c7a_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 25;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s16 dst = get_word_mmu060(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CMP.W #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0c7b_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 25;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	dsta = x_get_disp_ea_020(tmppc, 0);
	uae_s16 dst = get_word_mmu060(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

#endif
/* CMP.L #<data>.L,Dn */
uae_u32 REGPARAM2 op_0c80_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 14; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CMP.L #<data>.L,(An) */
uae_u32 REGPARAM2 op_0c90_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 20; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu060(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CMP.L #<data>.L,(An)+ */
uae_u32 REGPARAM2 op_0c98_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 20; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu060(dsta);
	m68k_areg(regs, dstreg) += 4;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CMP.L #<data>.L,-(An) */
uae_u32 REGPARAM2 op_0ca0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 22; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CMP.L #<data>.L,(d16,An) */
uae_u32 REGPARAM2 op_0ca8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 24; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(6);
	uae_s32 dst = get_long_mmu060(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(8);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* CMP.L #<data>.L,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0cb0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 24; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = get_long_mmu060(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 2,0   */

/* CMP.L #<data>.L,(xxx).W */
uae_u32 REGPARAM2 op_0cb8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 25;
	CurrentInstrCycles = 24; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(6);
	uae_s32 dst = get_long_mmu060(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(8);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* CMP.L #<data>.L,(xxx).L */
uae_u32 REGPARAM2 op_0cb9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 25;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(6);
	uae_s32 dst = get_long_mmu060(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(10);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 10 0,0   */

/* CMP.L #<data>.L,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0cba_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 25;
	CurrentInstrCycles = 24; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = m68k_getpci() + 6;
	dsta += (uae_s32)(uae_s16)get_iword_mmu060(6);
	uae_s32 dst = get_long_mmu060(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(8);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

#endif
/* CMP.L #<data>.L,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0cbb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 25;
	CurrentInstrCycles = 24; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	m68k_incpci(6);
	uaecptr tmppc = m68k_getpci();
	dsta = x_get_disp_ea_020(tmppc, 0);
	uae_s32 dst = get_long_mmu060(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 2,0   */

#endif
/* CAS.W #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0cd0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = get_lrmw_word_mmu060(dsta);
	if ((dsta & 1) && currprefs.int_no_unimplemented && get_cpu_model() == 68060) {
		m68k_incpci(4);
		op_unimpl (opcode);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_word_mmu060(dsta, (m68k_dreg(regs, ru)));
	} else {
		put_lrmw_word_mmu060(dsta, dst);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
	}
	m68k_incpci(4);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

#endif
/* CAS.W #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0cd8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_lrmw_word_mmu060(dsta);
	m68k_areg(regs, dstreg) += 2;
	if ((dsta & 1) && currprefs.int_no_unimplemented && get_cpu_model() == 68060) {
		cpu_restore_fixup();
		m68k_incpci(4);
		op_unimpl (opcode);
		mmufixup[0].reg = -1;
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_word_mmu060(dsta, (m68k_dreg(regs, ru)));
	} else {
		put_lrmw_word_mmu060(dsta, dst);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
	}
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

#endif
/* CAS.W #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0ce0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	CurrentInstrCycles = 22; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_lrmw_word_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	if ((dsta & 1) && currprefs.int_no_unimplemented && get_cpu_model() == 68060) {
		cpu_restore_fixup();
		m68k_incpci(4);
		op_unimpl (opcode);
		mmufixup[0].reg = -1;
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_word_mmu060(dsta, (m68k_dreg(regs, ru)));
	} else {
		put_lrmw_word_mmu060(dsta, dst);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
	}
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

#endif
/* CAS.W #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0ce8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s16 dst = get_lrmw_word_mmu060(dsta);
	if ((dsta & 1) && currprefs.int_no_unimplemented && get_cpu_model() == 68060) {
		m68k_incpci(6);
		op_unimpl (opcode);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_word_mmu060(dsta, (m68k_dreg(regs, ru)));
	} else {
		put_lrmw_word_mmu060(dsta, dst);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
	}
	m68k_incpci(6);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 12 0,0   */

#endif
/* CAS.W #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0cf0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = get_lrmw_word_mmu060(dsta);
	if ((dsta & 1) && currprefs.int_no_unimplemented && get_cpu_model() == 68060) {
		op_unimpl (opcode);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_word_mmu060(dsta, (m68k_dreg(regs, ru)));
	} else {
		put_lrmw_word_mmu060(dsta, dst);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
	}
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

#endif
/* CAS.W #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0cf8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 84;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s16 dst = get_lrmw_word_mmu060(dsta);
	if ((dsta & 1) && currprefs.int_no_unimplemented && get_cpu_model() == 68060) {
		m68k_incpci(6);
		op_unimpl (opcode);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_word_mmu060(dsta, (m68k_dreg(regs, ru)));
	} else {
		put_lrmw_word_mmu060(dsta, dst);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
	}
	m68k_incpci(6);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 12 0,0   */

#endif
/* CAS.W #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0cf9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 84;
	CurrentInstrCycles = 28; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	uae_s16 dst = get_lrmw_word_mmu060(dsta);
	if ((dsta & 1) && currprefs.int_no_unimplemented && get_cpu_model() == 68060) {
		m68k_incpci(8);
		op_unimpl (opcode);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_word_mmu060(dsta, (m68k_dreg(regs, ru)));
	} else {
		put_lrmw_word_mmu060(dsta, dst);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
	}
	m68k_incpci(8);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 16 0,0   */

#endif
/* CAS2.W #<data>.L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0cfc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 85;
	CurrentInstrCycles = 8;  
	uae_s32 extra;
	extra = get_ilong_mmu060(2);
	uae_u32 rn1 = regs.regs[(extra >> 28) & 15];
	uae_u32 rn2 = regs.regs[(extra >> 12) & 15];
	uae_u16 dst1 = get_lrmw_word_mmu060(rn1), dst2 = get_lrmw_word_mmu060(rn2);
	uae_u32 newv = ((uae_u16)(dst1)) - ((uae_u16)(m68k_dreg(regs, (extra >> 16) & 7)));
	int flgs = ((uae_s16)(m68k_dreg(regs, (extra >> 16) & 7))) < 0;
	int flgo = ((uae_s16)(dst1)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(m68k_dreg(regs, (extra >> 16) & 7))) > ((uae_u16)(dst1)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		uae_u32 newv = ((uae_u16)(dst2)) - ((uae_u16)(m68k_dreg(regs, extra & 7)));
		int flgs = ((uae_s16)(m68k_dreg(regs, extra & 7))) < 0;
		int flgo = ((uae_s16)(dst2)) < 0;
		int flgn = ((uae_s16)(newv)) < 0;
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_VFLG((flgs != flgo) && (flgn != flgo));
		SET_CFLG(((uae_u16)(m68k_dreg(regs, extra & 7))) > ((uae_u16)(dst2)));
		SET_NFLG(flgn != 0);
		if (GET_ZFLG()) {
			put_lrmw_word_mmu060(rn2, m68k_dreg(regs, (extra >> 6) & 7));
			put_lrmw_word_mmu060(rn1, m68k_dreg(regs, (extra >> 22) & 7));
		}
	}
	if (!GET_ZFLG()) {
		m68k_dreg(regs, (extra >> 16) & 7) = (m68k_dreg(regs, (extra >> 16) & 7) & ~0xffff) | (dst1 & 0xffff);
		m68k_dreg(regs, (extra >> 0) & 7) = (m68k_dreg(regs, (extra >> 0) & 7) & ~0xffff) | (dst2 & 0xffff);
	}
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* MOVES.B #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e10_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_iword_mmu060(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		dfc060_put_byte(dsta, src);
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		uae_s8 src = sfc060_get_byte(srca);
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(4);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* MOVES.B #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e18_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_iword_mmu060(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		mmufixup[0].reg = dstreg | 0x0;
		mmufixup[0].value = m68k_areg(regs, dstreg);
		m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
		dfc060_put_byte(dsta, src);
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		mmufixup[1].reg = dstreg | 0x0;
		mmufixup[1].value = m68k_areg(regs, dstreg);
		uae_s8 src = sfc060_get_byte(srca);
		m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(4);
	}
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* MOVES.B #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e20_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 18; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_iword_mmu060(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
		mmufixup[0].reg = dstreg | 0x0;
		mmufixup[0].value = m68k_areg(regs, dstreg);
		m68k_areg(regs, dstreg) = dsta;
		dfc060_put_byte(dsta, src);
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
		mmufixup[1].reg = dstreg | 0x0;
		mmufixup[1].value = m68k_areg(regs, dstreg);
		uae_s8 src = sfc060_get_byte(srca);
		m68k_areg(regs, dstreg) = srca;
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(4);
	}
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* MOVES.B #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e28_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_iword_mmu060(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
		dfc060_put_byte(dsta, src);
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
		uae_s8 src = sfc060_get_byte(srca);
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(6);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* MOVES.B #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e30_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_iword_mmu060(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		m68k_incpci(4);
		dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
		dfc060_put_byte(dsta, src);
	} else {
		uaecptr srca;
		m68k_incpci(4);
		srca = x_get_disp_ea_020(m68k_areg(regs, dstreg), 1);
		uae_s8 src = sfc060_get_byte(srca);
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,2   */

#endif
/* MOVES.B #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e38_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 103;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_iword_mmu060(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
		dfc060_put_byte(dsta, src);
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = (uae_s32)(uae_s16)get_iword_mmu060(4);
		uae_s8 src = sfc060_get_byte(srca);
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(6);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* MOVES.B #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e39_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 103;
	CurrentInstrCycles = 24; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_iword_mmu060(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = get_ilong_mmu060(4);
		dfc060_put_byte(dsta, src);
		m68k_incpci(8);
	} else {
		uaecptr srca;
		srca = get_ilong_mmu060(4);
		uae_s8 src = sfc060_get_byte(srca);
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(8);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

#endif
/* MOVES.W #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e50_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_iword_mmu060(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		dfc060_put_word(dsta, src);
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		uae_s16 src = sfc060_get_word(srca);
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(4);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* MOVES.W #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e58_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_iword_mmu060(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		mmufixup[0].reg = dstreg | 0x0;
		mmufixup[0].value = m68k_areg(regs, dstreg);
		m68k_areg(regs, dstreg) += 2;
		dfc060_put_word(dsta, src);
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		mmufixup[1].reg = dstreg | 0x0;
		mmufixup[1].value = m68k_areg(regs, dstreg);
		uae_s16 src = sfc060_get_word(srca);
		m68k_areg(regs, dstreg) += 2;
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(4);
	}
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* MOVES.W #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e60_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 18; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_iword_mmu060(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) - 2;
		mmufixup[0].reg = dstreg | 0x0;
		mmufixup[0].value = m68k_areg(regs, dstreg);
		m68k_areg(regs, dstreg) = dsta;
		dfc060_put_word(dsta, src);
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) - 2;
		mmufixup[1].reg = dstreg | 0x0;
		mmufixup[1].value = m68k_areg(regs, dstreg);
		uae_s16 src = sfc060_get_word(srca);
		m68k_areg(regs, dstreg) = srca;
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(4);
	}
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* MOVES.W #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e68_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_iword_mmu060(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
		dfc060_put_word(dsta, src);
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
		uae_s16 src = sfc060_get_word(srca);
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(6);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* MOVES.W #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e70_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_iword_mmu060(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		m68k_incpci(4);
		dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
		dfc060_put_word(dsta, src);
	} else {
		uaecptr srca;
		m68k_incpci(4);
		srca = x_get_disp_ea_020(m68k_areg(regs, dstreg), 1);
		uae_s16 src = sfc060_get_word(srca);
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,2   */

#endif
/* MOVES.W #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e78_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 103;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_iword_mmu060(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
		dfc060_put_word(dsta, src);
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = (uae_s32)(uae_s16)get_iword_mmu060(4);
		uae_s16 src = sfc060_get_word(srca);
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(6);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* MOVES.W #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e79_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 103;
	CurrentInstrCycles = 24; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_iword_mmu060(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = get_ilong_mmu060(4);
		dfc060_put_word(dsta, src);
		m68k_incpci(8);
	} else {
		uaecptr srca;
		srca = get_ilong_mmu060(4);
		uae_s16 src = sfc060_get_word(srca);
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(8);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

#endif
/* MOVES.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e90_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_iword_mmu060(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		dfc060_put_long(dsta, src);
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		uae_s32 src = sfc060_get_long(srca);
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(4);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* MOVES.L #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e98_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_iword_mmu060(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		mmufixup[0].reg = dstreg | 0x0;
		mmufixup[0].value = m68k_areg(regs, dstreg);
		m68k_areg(regs, dstreg) += 4;
		dfc060_put_long(dsta, src);
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		mmufixup[1].reg = dstreg | 0x0;
		mmufixup[1].value = m68k_areg(regs, dstreg);
		uae_s32 src = sfc060_get_long(srca);
		m68k_areg(regs, dstreg) += 4;
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(4);
	}
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* MOVES.L #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0ea0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 22; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_iword_mmu060(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) - 4;
		mmufixup[0].reg = dstreg | 0x0;
		mmufixup[0].value = m68k_areg(regs, dstreg);
		m68k_areg(regs, dstreg) = dsta;
		dfc060_put_long(dsta, src);
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) - 4;
		mmufixup[1].reg = dstreg | 0x0;
		mmufixup[1].value = m68k_areg(regs, dstreg);
		uae_s32 src = sfc060_get_long(srca);
		m68k_areg(regs, dstreg) = srca;
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(4);
	}
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* MOVES.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0ea8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 24; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_iword_mmu060(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
		dfc060_put_long(dsta, src);
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
		uae_s32 src = sfc060_get_long(srca);
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(6);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* MOVES.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0eb0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 24; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_iword_mmu060(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		m68k_incpci(4);
		dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
		dfc060_put_long(dsta, src);
	} else {
		uaecptr srca;
		m68k_incpci(4);
		srca = x_get_disp_ea_020(m68k_areg(regs, dstreg), 1);
		uae_s32 src = sfc060_get_long(srca);
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,2   */

#endif
/* MOVES.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0eb8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 103;
	CurrentInstrCycles = 24; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_iword_mmu060(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
		dfc060_put_long(dsta, src);
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = (uae_s32)(uae_s16)get_iword_mmu060(4);
		uae_s32 src = sfc060_get_long(srca);
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(6);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* MOVES.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0eb9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 103;
	CurrentInstrCycles = 28; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_iword_mmu060(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = get_ilong_mmu060(4);
		dfc060_put_long(dsta, src);
		m68k_incpci(8);
	} else {
		uaecptr srca;
		srca = get_ilong_mmu060(4);
		uae_s32 src = sfc060_get_long(srca);
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(8);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

#endif
/* CAS.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0ed0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	CurrentInstrCycles = 32; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = get_lrmw_long_mmu060(dsta);
	if ((dsta & 3) && currprefs.int_no_unimplemented && get_cpu_model() == 68060) {
		m68k_incpci(4);
		op_unimpl (opcode);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_long_mmu060(dsta, (m68k_dreg(regs, ru)));
	} else {
		put_lrmw_long_mmu060(dsta, dst);
		m68k_dreg(regs, rc) = dst;
	}
	m68k_incpci(4);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

#endif
/* CAS.L #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0ed8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	CurrentInstrCycles = 32; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_lrmw_long_mmu060(dsta);
	m68k_areg(regs, dstreg) += 4;
	if ((dsta & 3) && currprefs.int_no_unimplemented && get_cpu_model() == 68060) {
		cpu_restore_fixup();
		m68k_incpci(4);
		op_unimpl (opcode);
		mmufixup[0].reg = -1;
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_long_mmu060(dsta, (m68k_dreg(regs, ru)));
	} else {
		put_lrmw_long_mmu060(dsta, dst);
		m68k_dreg(regs, rc) = dst;
	}
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

#endif
/* CAS.L #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0ee0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	CurrentInstrCycles = 34; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_lrmw_long_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	if ((dsta & 3) && currprefs.int_no_unimplemented && get_cpu_model() == 68060) {
		cpu_restore_fixup();
		m68k_incpci(4);
		op_unimpl (opcode);
		mmufixup[0].reg = -1;
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_long_mmu060(dsta, (m68k_dreg(regs, ru)));
	} else {
		put_lrmw_long_mmu060(dsta, dst);
		m68k_dreg(regs, rc) = dst;
	}
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

#endif
/* CAS.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0ee8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	CurrentInstrCycles = 36; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s32 dst = get_lrmw_long_mmu060(dsta);
	if ((dsta & 3) && currprefs.int_no_unimplemented && get_cpu_model() == 68060) {
		m68k_incpci(6);
		op_unimpl (opcode);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_long_mmu060(dsta, (m68k_dreg(regs, ru)));
	} else {
		put_lrmw_long_mmu060(dsta, dst);
		m68k_dreg(regs, rc) = dst;
	}
	m68k_incpci(6);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 12 0,0   */

#endif
/* CAS.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0ef0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	CurrentInstrCycles = 36; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = get_lrmw_long_mmu060(dsta);
	if ((dsta & 3) && currprefs.int_no_unimplemented && get_cpu_model() == 68060) {
		op_unimpl (opcode);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_long_mmu060(dsta, (m68k_dreg(regs, ru)));
	} else {
		put_lrmw_long_mmu060(dsta, dst);
		m68k_dreg(regs, rc) = dst;
	}
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

#endif
/* CAS.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0ef8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 84;
	CurrentInstrCycles = 36; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s32 dst = get_lrmw_long_mmu060(dsta);
	if ((dsta & 3) && currprefs.int_no_unimplemented && get_cpu_model() == 68060) {
		m68k_incpci(6);
		op_unimpl (opcode);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_long_mmu060(dsta, (m68k_dreg(regs, ru)));
	} else {
		put_lrmw_long_mmu060(dsta, dst);
		m68k_dreg(regs, rc) = dst;
	}
	m68k_incpci(6);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 12 0,0   */

#endif
/* CAS.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0ef9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 84;
	CurrentInstrCycles = 40; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	uae_s32 dst = get_lrmw_long_mmu060(dsta);
	if ((dsta & 3) && currprefs.int_no_unimplemented && get_cpu_model() == 68060) {
		m68k_incpci(8);
		op_unimpl (opcode);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_long_mmu060(dsta, (m68k_dreg(regs, ru)));
	} else {
		put_lrmw_long_mmu060(dsta, dst);
		m68k_dreg(regs, rc) = dst;
	}
	m68k_incpci(8);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 16 0,0   */

#endif
/* CAS2.L #<data>.L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0efc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 85;
	CurrentInstrCycles = 8;  
	uae_s32 extra;
	extra = get_ilong_mmu060(2);
	uae_u32 rn1 = regs.regs[(extra >> 28) & 15];
	uae_u32 rn2 = regs.regs[(extra >> 12) & 15];
	uae_u32 dst1 = get_lrmw_long_mmu060(rn1), dst2 = get_lrmw_long_mmu060(rn2);
	uae_u32 newv = ((uae_u32)(dst1)) - ((uae_u32)(m68k_dreg(regs, (extra >> 16) & 7)));
	int flgs = ((uae_s32)(m68k_dreg(regs, (extra >> 16) & 7))) < 0;
	int flgo = ((uae_s32)(dst1)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(m68k_dreg(regs, (extra >> 16) & 7))) > ((uae_u32)(dst1)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		uae_u32 newv = ((uae_u32)(dst2)) - ((uae_u32)(m68k_dreg(regs, extra & 7)));
		int flgs = ((uae_s32)(m68k_dreg(regs, extra & 7))) < 0;
		int flgo = ((uae_s32)(dst2)) < 0;
		int flgn = ((uae_s32)(newv)) < 0;
		SET_ZFLG(((uae_s32)(newv)) == 0);
		SET_VFLG((flgs != flgo) && (flgn != flgo));
		SET_CFLG(((uae_u32)(m68k_dreg(regs, extra & 7))) > ((uae_u32)(dst2)));
		SET_NFLG(flgn != 0);
		if (GET_ZFLG()) {
			put_lrmw_long_mmu060(rn2, m68k_dreg(regs, (extra >> 6) & 7));
			put_lrmw_long_mmu060(rn1, m68k_dreg(regs, (extra >> 22) & 7));
		}
	}
	if (!GET_ZFLG()) {
		m68k_dreg(regs, (extra >> 16) & 7) = dst1;
		m68k_dreg(regs, (extra >> 0) & 7) = dst2;
	}
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* MOVE.B Dn,Dn */
uae_u32 REGPARAM2 op_1000_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.B (An),Dn */
uae_u32 REGPARAM2 op_1010_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.B (An)+,Dn */
uae_u32 REGPARAM2 op_1018_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.B -(An),Dn */
uae_u32 REGPARAM2 op_1020_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.B (d16,An),Dn */
uae_u32 REGPARAM2 op_1028_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_1030_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_byte_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.B (xxx).W,Dn */
uae_u32 REGPARAM2 op_1038_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (xxx).L,Dn */
uae_u32 REGPARAM2 op_1039_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.B (d16,PC),Dn */
uae_u32 REGPARAM2 op_103a_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_103b_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s8 src = get_byte_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.B #<data>.B,Dn */
uae_u32 REGPARAM2 op_103c_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uae_s8 src = get_ibyte_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B Dn,(An) */
uae_u32 REGPARAM2 op_1080_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.B (An),(An) */
uae_u32 REGPARAM2 op_1090_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.B (An)+,(An) */
uae_u32 REGPARAM2 op_1098_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.B -(An),(An) */
uae_u32 REGPARAM2 op_10a0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.B (d16,An),(An) */
uae_u32 REGPARAM2 op_10a8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (d8,An,Xn),(An) */
uae_u32 REGPARAM2 op_10b0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.B (xxx).W,(An) */
uae_u32 REGPARAM2 op_10b8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (xxx).L,(An) */
uae_u32 REGPARAM2 op_10b9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.B (d16,PC),(An) */
uae_u32 REGPARAM2 op_10ba_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (d8,PC,Xn),(An) */
uae_u32 REGPARAM2 op_10bb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.B #<data>.B,(An) */
uae_u32 REGPARAM2 op_10bc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B Dn,(An)+ */
uae_u32 REGPARAM2 op_10c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.B (An),(An)+ */
uae_u32 REGPARAM2 op_10d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.B (An)+,(An)+ */
uae_u32 REGPARAM2 op_10d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[1].reg = dstreg | 0x0;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.B -(An),(An)+ */
uae_u32 REGPARAM2 op_10e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[1].reg = dstreg | 0x0;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.B (d16,An),(An)+ */
uae_u32 REGPARAM2 op_10e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (d8,An,Xn),(An)+ */
uae_u32 REGPARAM2 op_10f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.B (xxx).W,(An)+ */
uae_u32 REGPARAM2 op_10f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (xxx).L,(An)+ */
uae_u32 REGPARAM2 op_10f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(6);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.B (d16,PC),(An)+ */
uae_u32 REGPARAM2 op_10fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (d8,PC,Xn),(An)+ */
uae_u32 REGPARAM2 op_10fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.B #<data>.B,(An)+ */
uae_u32 REGPARAM2 op_10fc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B Dn,-(An) */
uae_u32 REGPARAM2 op_1100_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 10; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.B (An),-(An) */
uae_u32 REGPARAM2 op_1110_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.B (An)+,-(An) */
uae_u32 REGPARAM2 op_1118_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[1].reg = dstreg | 0x0;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.B -(An),-(An) */
uae_u32 REGPARAM2 op_1120_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[1].reg = dstreg | 0x0;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.B (d16,An),-(An) */
uae_u32 REGPARAM2 op_1128_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (d8,An,Xn),-(An) */
uae_u32 REGPARAM2 op_1130_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.B (xxx).W,-(An) */
uae_u32 REGPARAM2 op_1138_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (xxx).L,-(An) */
uae_u32 REGPARAM2 op_1139_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(6);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.B (d16,PC),-(An) */
uae_u32 REGPARAM2 op_113a_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (d8,PC,Xn),-(An) */
uae_u32 REGPARAM2 op_113b_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.B #<data>.B,-(An) */
uae_u32 REGPARAM2 op_113c_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B Dn,(d16,An) */
uae_u32 REGPARAM2 op_1140_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (An),(d16,An) */
uae_u32 REGPARAM2 op_1150_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (An)+,(d16,An) */
uae_u32 REGPARAM2 op_1158_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B -(An),(d16,An) */
uae_u32 REGPARAM2 op_1160_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (d16,An),(d16,An) */
uae_u32 REGPARAM2 op_1168_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.B (d8,An,Xn),(d16,An) */
uae_u32 REGPARAM2 op_1170_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 4,0   */

/* MOVE.B (xxx).W,(d16,An) */
uae_u32 REGPARAM2 op_1178_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.B (xxx).L,(d16,An) */
uae_u32 REGPARAM2 op_1179_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(6);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.B (d16,PC),(d16,An) */
uae_u32 REGPARAM2 op_117a_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.B (d8,PC,Xn),(d16,An) */
uae_u32 REGPARAM2 op_117b_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 4,0   */

/* MOVE.B #<data>.B,(d16,An) */
uae_u32 REGPARAM2 op_117c_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_1180_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.B (An),(d8,An,Xn) */
uae_u32 REGPARAM2 op_1190_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.B (An)+,(d8,An,Xn) */
uae_u32 REGPARAM2 op_1198_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.B -(An),(d8,An,Xn) */
uae_u32 REGPARAM2 op_11a0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.B (d16,An),(d8,An,Xn) */
uae_u32 REGPARAM2 op_11a8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* MOVE.B (d8,An,Xn),(d8,An,Xn) */
uae_u32 REGPARAM2 op_11b0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 1);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,2   */

/* MOVE.B (xxx).W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_11b8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* MOVE.B (xxx).L,(d8,An,Xn) */
uae_u32 REGPARAM2 op_11b9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 2,0   */

/* MOVE.B (d16,PC),(d8,An,Xn) */
uae_u32 REGPARAM2 op_11ba_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* MOVE.B (d8,PC,Xn),(d8,An,Xn) */
uae_u32 REGPARAM2 op_11bb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 1);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,2   */

/* MOVE.B #<data>.B,(d8,An,Xn) */
uae_u32 REGPARAM2 op_11bc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* MOVE.B Dn,(xxx).W */
uae_u32 REGPARAM2 op_11c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (An),(xxx).W */
uae_u32 REGPARAM2 op_11d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (An)+,(xxx).W */
uae_u32 REGPARAM2 op_11d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B -(An),(xxx).W */
uae_u32 REGPARAM2 op_11e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (d16,An),(xxx).W */
uae_u32 REGPARAM2 op_11e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.B (d8,An,Xn),(xxx).W */
uae_u32 REGPARAM2 op_11f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 4,0   */

/* MOVE.B (xxx).W,(xxx).W */
uae_u32 REGPARAM2 op_11f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.B (xxx).L,(xxx).W */
uae_u32 REGPARAM2 op_11f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(6);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.B (d16,PC),(xxx).W */
uae_u32 REGPARAM2 op_11fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.B (d8,PC,Xn),(xxx).W */
uae_u32 REGPARAM2 op_11fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 4,0   */

/* MOVE.B #<data>.B,(xxx).W */
uae_u32 REGPARAM2 op_11fc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.B Dn,(xxx).L */
uae_u32 REGPARAM2 op_13c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.B (An),(xxx).L */
uae_u32 REGPARAM2 op_13d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.B (An)+,(xxx).L */
uae_u32 REGPARAM2 op_13d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(6);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.B -(An),(xxx).L */
uae_u32 REGPARAM2 op_13e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(6);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.B (d16,An),(xxx).L */
uae_u32 REGPARAM2 op_13e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.B (d8,An,Xn),(xxx).L */
uae_u32 REGPARAM2 op_13f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu060(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 6,0   */

/* MOVE.B (xxx).W,(xxx).L */
uae_u32 REGPARAM2 op_13f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.B (xxx).L,(xxx).L */
uae_u32 REGPARAM2 op_13f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu060(6);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(10);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 10 0,0   */

/* MOVE.B (d16,PC),(xxx).L */
uae_u32 REGPARAM2 op_13fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.B (d8,PC,Xn),(xxx).L */
uae_u32 REGPARAM2 op_13fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s8 src = get_byte_mmu060(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu060(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 6,0   */

/* MOVE.B #<data>.B,(xxx).L */
uae_u32 REGPARAM2 op_13fc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uae_s8 src = get_ibyte_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_mmu060(dsta, src);
	m68k_incpci(8);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.L Dn,Dn */
uae_u32 REGPARAM2 op_2000_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L An,Dn */
uae_u32 REGPARAM2 op_2008_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_areg(regs, srcreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L (An),Dn */
uae_u32 REGPARAM2 op_2010_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L (An)+,Dn */
uae_u32 REGPARAM2 op_2018_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L -(An),Dn */
uae_u32 REGPARAM2 op_2020_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L (d16,An),Dn */
uae_u32 REGPARAM2 op_2028_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_2030_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.L (xxx).W,Dn */
uae_u32 REGPARAM2 op_2038_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (xxx).L,Dn */
uae_u32 REGPARAM2 op_2039_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L (d16,PC),Dn */
uae_u32 REGPARAM2 op_203a_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_203b_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = get_long_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.L #<data>.L,Dn */
uae_u32 REGPARAM2 op_203c_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVEA.L Dn,An */
uae_u32 REGPARAM2 op_2040_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVEA.L An,An */
uae_u32 REGPARAM2 op_2048_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_areg(regs, srcreg);
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVEA.L (An),An */
uae_u32 REGPARAM2 op_2050_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVEA.L (An)+,An */
uae_u32 REGPARAM2 op_2058_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) += 4;
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVEA.L -(An),An */
uae_u32 REGPARAM2 op_2060_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVEA.L (d16,An),An */
uae_u32 REGPARAM2 op_2068_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVEA.L (d8,An,Xn),An */
uae_u32 REGPARAM2 op_2070_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, dstreg) = (src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVEA.L (xxx).W,An */
uae_u32 REGPARAM2 op_2078_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVEA.L (xxx).L,An */
uae_u32 REGPARAM2 op_2079_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVEA.L (d16,PC),An */
uae_u32 REGPARAM2 op_207a_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVEA.L (d8,PC,Xn),An */
uae_u32 REGPARAM2 op_207b_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, dstreg) = (src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVEA.L #<data>.L,An */
uae_u32 REGPARAM2 op_207c_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 12; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L Dn,(An) */
uae_u32 REGPARAM2 op_2080_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L An,(An) */
uae_u32 REGPARAM2 op_2088_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L (An),(An) */
uae_u32 REGPARAM2 op_2090_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L (An)+,(An) */
uae_u32 REGPARAM2 op_2098_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L -(An),(An) */
uae_u32 REGPARAM2 op_20a0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L (d16,An),(An) */
uae_u32 REGPARAM2 op_20a8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (d8,An,Xn),(An) */
uae_u32 REGPARAM2 op_20b0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.L (xxx).W,(An) */
uae_u32 REGPARAM2 op_20b8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (xxx).L,(An) */
uae_u32 REGPARAM2 op_20b9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L (d16,PC),(An) */
uae_u32 REGPARAM2 op_20ba_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (d8,PC,Xn),(An) */
uae_u32 REGPARAM2 op_20bb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.L #<data>.L,(An) */
uae_u32 REGPARAM2 op_20bc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L Dn,(An)+ */
uae_u32 REGPARAM2 op_20c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L An,(An)+ */
uae_u32 REGPARAM2 op_20c8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L (An),(An)+ */
uae_u32 REGPARAM2 op_20d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L (An)+,(An)+ */
uae_u32 REGPARAM2 op_20d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[1].reg = dstreg | 0x0;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L -(An),(An)+ */
uae_u32 REGPARAM2 op_20e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[1].reg = dstreg | 0x0;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L (d16,An),(An)+ */
uae_u32 REGPARAM2 op_20e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (d8,An,Xn),(An)+ */
uae_u32 REGPARAM2 op_20f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.L (xxx).W,(An)+ */
uae_u32 REGPARAM2 op_20f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (xxx).L,(An)+ */
uae_u32 REGPARAM2 op_20f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(6);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L (d16,PC),(An)+ */
uae_u32 REGPARAM2 op_20fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (d8,PC,Xn),(An)+ */
uae_u32 REGPARAM2 op_20fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.L #<data>.L,(An)+ */
uae_u32 REGPARAM2 op_20fc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(6);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L Dn,-(An) */
uae_u32 REGPARAM2 op_2100_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L An,-(An) */
uae_u32 REGPARAM2 op_2108_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L (An),-(An) */
uae_u32 REGPARAM2 op_2110_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L (An)+,-(An) */
uae_u32 REGPARAM2 op_2118_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[1].reg = dstreg | 0x0;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L -(An),-(An) */
uae_u32 REGPARAM2 op_2120_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[1].reg = dstreg | 0x0;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L (d16,An),-(An) */
uae_u32 REGPARAM2 op_2128_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (d8,An,Xn),-(An) */
uae_u32 REGPARAM2 op_2130_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.L (xxx).W,-(An) */
uae_u32 REGPARAM2 op_2138_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (xxx).L,-(An) */
uae_u32 REGPARAM2 op_2139_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 30; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(6);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L (d16,PC),-(An) */
uae_u32 REGPARAM2 op_213a_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (d8,PC,Xn),-(An) */
uae_u32 REGPARAM2 op_213b_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.L #<data>.L,-(An) */
uae_u32 REGPARAM2 op_213c_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(6);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L Dn,(d16,An) */
uae_u32 REGPARAM2 op_2140_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L An,(d16,An) */
uae_u32 REGPARAM2 op_2148_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (An),(d16,An) */
uae_u32 REGPARAM2 op_2150_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (An)+,(d16,An) */
uae_u32 REGPARAM2 op_2158_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L -(An),(d16,An) */
uae_u32 REGPARAM2 op_2160_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (d16,An),(d16,An) */
uae_u32 REGPARAM2 op_2168_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L (d8,An,Xn),(d16,An) */
uae_u32 REGPARAM2 op_2170_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 4,0   */

/* MOVE.L (xxx).W,(d16,An) */
uae_u32 REGPARAM2 op_2178_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L (xxx).L,(d16,An) */
uae_u32 REGPARAM2 op_2179_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 32; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(6);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.L (d16,PC),(d16,An) */
uae_u32 REGPARAM2 op_217a_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L (d8,PC,Xn),(d16,An) */
uae_u32 REGPARAM2 op_217b_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 4,0   */

/* MOVE.L #<data>.L,(d16,An) */
uae_u32 REGPARAM2 op_217c_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(6);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(8);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.L Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_2180_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.L An,(d8,An,Xn) */
uae_u32 REGPARAM2 op_2188_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.L (An),(d8,An,Xn) */
uae_u32 REGPARAM2 op_2190_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.L (An)+,(d8,An,Xn) */
uae_u32 REGPARAM2 op_2198_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.L -(An),(d8,An,Xn) */
uae_u32 REGPARAM2 op_21a0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.L (d16,An),(d8,An,Xn) */
uae_u32 REGPARAM2 op_21a8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* MOVE.L (d8,An,Xn),(d8,An,Xn) */
uae_u32 REGPARAM2 op_21b0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 1);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,2   */

/* MOVE.L (xxx).W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_21b8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* MOVE.L (xxx).L,(d8,An,Xn) */
uae_u32 REGPARAM2 op_21b9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 32; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 2,0   */

/* MOVE.L (d16,PC),(d8,An,Xn) */
uae_u32 REGPARAM2 op_21ba_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* MOVE.L (d8,PC,Xn),(d8,An,Xn) */
uae_u32 REGPARAM2 op_21bb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 1);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,2   */

/* MOVE.L #<data>.L,(d8,An,Xn) */
uae_u32 REGPARAM2 op_21bc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 2,0   */

/* MOVE.L Dn,(xxx).W */
uae_u32 REGPARAM2 op_21c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L An,(xxx).W */
uae_u32 REGPARAM2 op_21c8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (An),(xxx).W */
uae_u32 REGPARAM2 op_21d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (An)+,(xxx).W */
uae_u32 REGPARAM2 op_21d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L -(An),(xxx).W */
uae_u32 REGPARAM2 op_21e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (d16,An),(xxx).W */
uae_u32 REGPARAM2 op_21e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L (d8,An,Xn),(xxx).W */
uae_u32 REGPARAM2 op_21f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 4,0   */

/* MOVE.L (xxx).W,(xxx).W */
uae_u32 REGPARAM2 op_21f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L (xxx).L,(xxx).W */
uae_u32 REGPARAM2 op_21f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 32; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(6);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.L (d16,PC),(xxx).W */
uae_u32 REGPARAM2 op_21fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L (d8,PC,Xn),(xxx).W */
uae_u32 REGPARAM2 op_21fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 4,0   */

/* MOVE.L #<data>.L,(xxx).W */
uae_u32 REGPARAM2 op_21fc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(6);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(8);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.L Dn,(xxx).L */
uae_u32 REGPARAM2 op_23c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L An,(xxx).L */
uae_u32 REGPARAM2 op_23c8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L (An),(xxx).L */
uae_u32 REGPARAM2 op_23d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L (An)+,(xxx).L */
uae_u32 REGPARAM2 op_23d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(6);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L -(An),(xxx).L */
uae_u32 REGPARAM2 op_23e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 30; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(6);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L (d16,An),(xxx).L */
uae_u32 REGPARAM2 op_23e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 32; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.L (d8,An,Xn),(xxx).L */
uae_u32 REGPARAM2 op_23f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 32; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu060(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 6,0   */

/* MOVE.L (xxx).W,(xxx).L */
uae_u32 REGPARAM2 op_23f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 32; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.L (xxx).L,(xxx).L */
uae_u32 REGPARAM2 op_23f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 36; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu060(6);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(10);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 10 0,0   */

/* MOVE.L (d16,PC),(xxx).L */
uae_u32 REGPARAM2 op_23fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 32; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.L (d8,PC,Xn),(xxx).L */
uae_u32 REGPARAM2 op_23fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 32; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = get_long_mmu060(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu060(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 6,0   */

/* MOVE.L #<data>.L,(xxx).L */
uae_u32 REGPARAM2 op_23fc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(6);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_long_mmu060(dsta, src);
	m68k_incpci(10);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 10 0,0   */

/* MOVE.W Dn,Dn */
uae_u32 REGPARAM2 op_3000_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W An,Dn */
uae_u32 REGPARAM2 op_3008_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_areg(regs, srcreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W (An),Dn */
uae_u32 REGPARAM2 op_3010_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W (An)+,Dn */
uae_u32 REGPARAM2 op_3018_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W -(An),Dn */
uae_u32 REGPARAM2 op_3020_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W (d16,An),Dn */
uae_u32 REGPARAM2 op_3028_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_3030_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.W (xxx).W,Dn */
uae_u32 REGPARAM2 op_3038_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (xxx).L,Dn */
uae_u32 REGPARAM2 op_3039_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W (d16,PC),Dn */
uae_u32 REGPARAM2 op_303a_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_303b_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = get_word_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_303c_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVEA.W Dn,An */
uae_u32 REGPARAM2 op_3040_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVEA.W An,An */
uae_u32 REGPARAM2 op_3048_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_areg(regs, srcreg);
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVEA.W (An),An */
uae_u32 REGPARAM2 op_3050_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVEA.W (An)+,An */
uae_u32 REGPARAM2 op_3058_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) += 2;
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVEA.W -(An),An */
uae_u32 REGPARAM2 op_3060_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVEA.W (d16,An),An */
uae_u32 REGPARAM2 op_3068_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVEA.W (d8,An,Xn),An */
uae_u32 REGPARAM2 op_3070_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu060(srca);
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVEA.W (xxx).W,An */
uae_u32 REGPARAM2 op_3078_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVEA.W (xxx).L,An */
uae_u32 REGPARAM2 op_3079_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVEA.W (d16,PC),An */
uae_u32 REGPARAM2 op_307a_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVEA.W (d8,PC,Xn),An */
uae_u32 REGPARAM2 op_307b_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = get_word_mmu060(srca);
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVEA.W #<data>.W,An */
uae_u32 REGPARAM2 op_307c_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_iword_mmu060(2);
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W Dn,(An) */
uae_u32 REGPARAM2 op_3080_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W An,(An) */
uae_u32 REGPARAM2 op_3088_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W (An),(An) */
uae_u32 REGPARAM2 op_3090_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W (An)+,(An) */
uae_u32 REGPARAM2 op_3098_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W -(An),(An) */
uae_u32 REGPARAM2 op_30a0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W (d16,An),(An) */
uae_u32 REGPARAM2 op_30a8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (d8,An,Xn),(An) */
uae_u32 REGPARAM2 op_30b0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.W (xxx).W,(An) */
uae_u32 REGPARAM2 op_30b8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (xxx).L,(An) */
uae_u32 REGPARAM2 op_30b9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W (d16,PC),(An) */
uae_u32 REGPARAM2 op_30ba_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (d8,PC,Xn),(An) */
uae_u32 REGPARAM2 op_30bb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.W #<data>.W,(An) */
uae_u32 REGPARAM2 op_30bc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W Dn,(An)+ */
uae_u32 REGPARAM2 op_30c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W An,(An)+ */
uae_u32 REGPARAM2 op_30c8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W (An),(An)+ */
uae_u32 REGPARAM2 op_30d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W (An)+,(An)+ */
uae_u32 REGPARAM2 op_30d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[1].reg = dstreg | 0x0;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W -(An),(An)+ */
uae_u32 REGPARAM2 op_30e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[1].reg = dstreg | 0x0;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W (d16,An),(An)+ */
uae_u32 REGPARAM2 op_30e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (d8,An,Xn),(An)+ */
uae_u32 REGPARAM2 op_30f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.W (xxx).W,(An)+ */
uae_u32 REGPARAM2 op_30f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (xxx).L,(An)+ */
uae_u32 REGPARAM2 op_30f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(6);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W (d16,PC),(An)+ */
uae_u32 REGPARAM2 op_30fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (d8,PC,Xn),(An)+ */
uae_u32 REGPARAM2 op_30fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.W #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_30fc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W Dn,-(An) */
uae_u32 REGPARAM2 op_3100_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 10; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W An,-(An) */
uae_u32 REGPARAM2 op_3108_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 10; 
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W (An),-(An) */
uae_u32 REGPARAM2 op_3110_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W (An)+,-(An) */
uae_u32 REGPARAM2 op_3118_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[1].reg = dstreg | 0x0;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W -(An),-(An) */
uae_u32 REGPARAM2 op_3120_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[1].reg = dstreg | 0x0;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W (d16,An),-(An) */
uae_u32 REGPARAM2 op_3128_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (d8,An,Xn),-(An) */
uae_u32 REGPARAM2 op_3130_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.W (xxx).W,-(An) */
uae_u32 REGPARAM2 op_3138_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (xxx).L,-(An) */
uae_u32 REGPARAM2 op_3139_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(6);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W (d16,PC),-(An) */
uae_u32 REGPARAM2 op_313a_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (d8,PC,Xn),-(An) */
uae_u32 REGPARAM2 op_313b_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.W #<data>.W,-(An) */
uae_u32 REGPARAM2 op_313c_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W Dn,(d16,An) */
uae_u32 REGPARAM2 op_3140_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W An,(d16,An) */
uae_u32 REGPARAM2 op_3148_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (An),(d16,An) */
uae_u32 REGPARAM2 op_3150_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (An)+,(d16,An) */
uae_u32 REGPARAM2 op_3158_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W -(An),(d16,An) */
uae_u32 REGPARAM2 op_3160_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (d16,An),(d16,An) */
uae_u32 REGPARAM2 op_3168_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W (d8,An,Xn),(d16,An) */
uae_u32 REGPARAM2 op_3170_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 4,0   */

/* MOVE.W (xxx).W,(d16,An) */
uae_u32 REGPARAM2 op_3178_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W (xxx).L,(d16,An) */
uae_u32 REGPARAM2 op_3179_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(6);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.W (d16,PC),(d16,An) */
uae_u32 REGPARAM2 op_317a_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W (d8,PC,Xn),(d16,An) */
uae_u32 REGPARAM2 op_317b_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 4,0   */

/* MOVE.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_317c_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_3180_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.W An,(d8,An,Xn) */
uae_u32 REGPARAM2 op_3188_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.W (An),(d8,An,Xn) */
uae_u32 REGPARAM2 op_3190_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.W (An)+,(d8,An,Xn) */
uae_u32 REGPARAM2 op_3198_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.W -(An),(d8,An,Xn) */
uae_u32 REGPARAM2 op_31a0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.W (d16,An),(d8,An,Xn) */
uae_u32 REGPARAM2 op_31a8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* MOVE.W (d8,An,Xn),(d8,An,Xn) */
uae_u32 REGPARAM2 op_31b0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 1);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,2   */

/* MOVE.W (xxx).W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_31b8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* MOVE.W (xxx).L,(d8,An,Xn) */
uae_u32 REGPARAM2 op_31b9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 2,0   */

/* MOVE.W (d16,PC),(d8,An,Xn) */
uae_u32 REGPARAM2 op_31ba_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* MOVE.W (d8,PC,Xn),(d8,An,Xn) */
uae_u32 REGPARAM2 op_31bb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 1);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,2   */

/* MOVE.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_31bc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* MOVE.W Dn,(xxx).W */
uae_u32 REGPARAM2 op_31c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W An,(xxx).W */
uae_u32 REGPARAM2 op_31c8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (An),(xxx).W */
uae_u32 REGPARAM2 op_31d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (An)+,(xxx).W */
uae_u32 REGPARAM2 op_31d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W -(An),(xxx).W */
uae_u32 REGPARAM2 op_31e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (d16,An),(xxx).W */
uae_u32 REGPARAM2 op_31e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W (d8,An,Xn),(xxx).W */
uae_u32 REGPARAM2 op_31f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 4,0   */

/* MOVE.W (xxx).W,(xxx).W */
uae_u32 REGPARAM2 op_31f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W (xxx).L,(xxx).W */
uae_u32 REGPARAM2 op_31f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(6);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.W (d16,PC),(xxx).W */
uae_u32 REGPARAM2 op_31fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W (d8,PC,Xn),(xxx).W */
uae_u32 REGPARAM2 op_31fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 4,0   */

/* MOVE.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_31fc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W Dn,(xxx).L */
uae_u32 REGPARAM2 op_33c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W An,(xxx).L */
uae_u32 REGPARAM2 op_33c8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W (An),(xxx).L */
uae_u32 REGPARAM2 op_33d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W (An)+,(xxx).L */
uae_u32 REGPARAM2 op_33d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(6);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W -(An),(xxx).L */
uae_u32 REGPARAM2 op_33e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(6);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W (d16,An),(xxx).L */
uae_u32 REGPARAM2 op_33e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.W (d8,An,Xn),(xxx).L */
uae_u32 REGPARAM2 op_33f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu060(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 6,0   */

/* MOVE.W (xxx).W,(xxx).L */
uae_u32 REGPARAM2 op_33f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.W (xxx).L,(xxx).L */
uae_u32 REGPARAM2 op_33f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu060(6);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(10);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 10 0,0   */

/* MOVE.W (d16,PC),(xxx).L */
uae_u32 REGPARAM2 op_33fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.W (d8,PC,Xn),(xxx).L */
uae_u32 REGPARAM2 op_33fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = get_word_mmu060(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu060(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 6,0   */

/* MOVE.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_33fc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_word_mmu060(dsta, src);
	m68k_incpci(8);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* NEGX.B Dn */
uae_u32 REGPARAM2 op_4000_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEGX.B (An) */
uae_u32 REGPARAM2 op_4010_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_rmw_byte_mmu060(srca);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	put_rmw_byte_mmu060(srca, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEGX.B (An)+ */
uae_u32 REGPARAM2 op_4018_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_rmw_byte_mmu060(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	put_rmw_byte_mmu060(srca, newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEGX.B -(An) */
uae_u32 REGPARAM2 op_4020_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_rmw_byte_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	put_rmw_byte_mmu060(srca, newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEGX.B (d16,An) */
uae_u32 REGPARAM2 op_4028_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_rmw_byte_mmu060(srca);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	put_rmw_byte_mmu060(srca, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NEGX.B (d8,An,Xn) */
uae_u32 REGPARAM2 op_4030_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_rmw_byte_mmu060(srca);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	put_rmw_byte_mmu060(srca, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* NEGX.B (xxx).W */
uae_u32 REGPARAM2 op_4038_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 16;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_rmw_byte_mmu060(srca);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	put_rmw_byte_mmu060(srca, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NEGX.B (xxx).L */
uae_u32 REGPARAM2 op_4039_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 16;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s8 src = get_rmw_byte_mmu060(srca);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	put_rmw_byte_mmu060(srca, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* NEGX.W Dn */
uae_u32 REGPARAM2 op_4040_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEGX.W (An) */
uae_u32 REGPARAM2 op_4050_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_rmw_word_mmu060(srca);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	put_rmw_word_mmu060(srca, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEGX.W (An)+ */
uae_u32 REGPARAM2 op_4058_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_rmw_word_mmu060(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	put_rmw_word_mmu060(srca, newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEGX.W -(An) */
uae_u32 REGPARAM2 op_4060_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_rmw_word_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	put_rmw_word_mmu060(srca, newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEGX.W (d16,An) */
uae_u32 REGPARAM2 op_4068_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_rmw_word_mmu060(srca);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	put_rmw_word_mmu060(srca, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NEGX.W (d8,An,Xn) */
uae_u32 REGPARAM2 op_4070_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_rmw_word_mmu060(srca);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	put_rmw_word_mmu060(srca, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* NEGX.W (xxx).W */
uae_u32 REGPARAM2 op_4078_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 16;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_rmw_word_mmu060(srca);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	put_rmw_word_mmu060(srca, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NEGX.W (xxx).L */
uae_u32 REGPARAM2 op_4079_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 16;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s16 src = get_rmw_word_mmu060(srca);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	put_rmw_word_mmu060(srca, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* NEGX.L Dn */
uae_u32 REGPARAM2 op_4080_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 6;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	m68k_dreg(regs, srcreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEGX.L (An) */
uae_u32 REGPARAM2 op_4090_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_rmw_long_mmu060(srca);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	put_rmw_long_mmu060(srca, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEGX.L (An)+ */
uae_u32 REGPARAM2 op_4098_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_rmw_long_mmu060(srca);
	m68k_areg(regs, srcreg) += 4;
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	put_rmw_long_mmu060(srca, newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEGX.L -(An) */
uae_u32 REGPARAM2 op_40a0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_rmw_long_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	put_rmw_long_mmu060(srca, newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEGX.L (d16,An) */
uae_u32 REGPARAM2 op_40a8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_rmw_long_mmu060(srca);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	put_rmw_long_mmu060(srca, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NEGX.L (d8,An,Xn) */
uae_u32 REGPARAM2 op_40b0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_rmw_long_mmu060(srca);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	put_rmw_long_mmu060(srca, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* NEGX.L (xxx).W */
uae_u32 REGPARAM2 op_40b8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 16;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_rmw_long_mmu060(srca);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	put_rmw_long_mmu060(srca, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NEGX.L (xxx).L */
uae_u32 REGPARAM2 op_40b9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 16;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s32 src = get_rmw_long_mmu060(srca);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	put_rmw_long_mmu060(srca, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MVSR2.W Dn */
uae_u32 REGPARAM2 op_40c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 4;  
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	MakeSR();
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((regs.sr) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MVSR2.W (An) */
uae_u32 REGPARAM2 op_40d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 8;  
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	MakeSR();
	put_word_mmu060(srca, regs.sr);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MVSR2.W (An)+ */
uae_u32 REGPARAM2 op_40d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 8;  
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += 2;
	MakeSR();
	put_word_mmu060(srca, regs.sr);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MVSR2.W -(An) */
uae_u32 REGPARAM2 op_40e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 10; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	MakeSR();
	put_word_mmu060(srca, regs.sr);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MVSR2.W (d16,An) */
uae_u32 REGPARAM2 op_40e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 12; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	MakeSR();
	put_word_mmu060(srca, regs.sr);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MVSR2.W (d8,An,Xn) */
uae_u32 REGPARAM2 op_40f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 12; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	MakeSR();
	put_word_mmu060(srca, regs.sr);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MVSR2.W (xxx).W */
uae_u32 REGPARAM2 op_40f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 32;
	CurrentInstrCycles = 12; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	MakeSR();
	put_word_mmu060(srca, regs.sr);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MVSR2.W (xxx).L */
uae_u32 REGPARAM2 op_40f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 32;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	MakeSR();
	put_word_mmu060(srca, regs.sr);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CHK.L Dn,Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4100_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 10; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* CHK.L (An),Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4110_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* CHK.L (An)+,Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4118_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) += 4;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		mmufixup[0].reg = -1;
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		mmufixup[0].reg = -1;
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* CHK.L -(An),Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4120_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		mmufixup[0].reg = -1;
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		mmufixup[0].reg = -1;
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* CHK.L (d16,An),Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4128_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* CHK.L (d8,An,Xn),Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4130_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

#endif
/* CHK.L (xxx).W,Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4138_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* CHK.L (xxx).L,Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4139_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(6);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CHK.L (d16,PC),Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_413a_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* CHK.L (d8,PC,Xn),Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_413b_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

#endif
/* CHK.L #<data>.L,Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_413c_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 18; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(6);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CHK.W Dn,Dn */
uae_u32 REGPARAM2 op_4180_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 10; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 1);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CHK.W (An),Dn */
uae_u32 REGPARAM2 op_4190_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 1);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CHK.W (An)+,Dn */
uae_u32 REGPARAM2 op_4198_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		mmufixup[0].reg = -1;
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		mmufixup[0].reg = -1;
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 1);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CHK.W -(An),Dn */
uae_u32 REGPARAM2 op_41a0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		mmufixup[0].reg = -1;
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		mmufixup[0].reg = -1;
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 1);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CHK.W (d16,An),Dn */
uae_u32 REGPARAM2 op_41a8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 1);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CHK.W (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_41b0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 1);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* CHK.W (xxx).W,Dn */
uae_u32 REGPARAM2 op_41b8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 1);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CHK.W (xxx).L,Dn */
uae_u32 REGPARAM2 op_41b9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(6);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 1);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CHK.W (d16,PC),Dn */
uae_u32 REGPARAM2 op_41ba_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 1);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CHK.W (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_41bb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 1);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* CHK.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_41bc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 14; 
	uae_s16 src = get_iword_mmu060(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 1);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* LEA.L (An),An */
uae_u32 REGPARAM2 op_41d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	CurrentInstrCycles = 4;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, dstreg) = (srca);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* LEA.L (d16,An),An */
uae_u32 REGPARAM2 op_41e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	m68k_areg(regs, dstreg) = (srca);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* LEA.L (d8,An,Xn),An */
uae_u32 REGPARAM2 op_41f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	m68k_areg(regs, dstreg) = (srca);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* LEA.L (xxx).W,An */
uae_u32 REGPARAM2 op_41f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	m68k_areg(regs, dstreg) = (srca);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* LEA.L (xxx).L,An */
uae_u32 REGPARAM2 op_41f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	m68k_areg(regs, dstreg) = (srca);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* LEA.L (d16,PC),An */
uae_u32 REGPARAM2 op_41fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	m68k_areg(regs, dstreg) = (srca);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* LEA.L (d8,PC,Xn),An */
uae_u32 REGPARAM2 op_41fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	m68k_areg(regs, dstreg) = (srca);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* CLR.B Dn */
uae_u32 REGPARAM2 op_4200_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 4;  
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((0) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CLR.B (An) */
uae_u32 REGPARAM2 op_4210_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	put_byte_mmu060(srca, 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CLR.B (An)+ */
uae_u32 REGPARAM2 op_4218_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	put_byte_mmu060(srca, 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CLR.B -(An) */
uae_u32 REGPARAM2 op_4220_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	put_byte_mmu060(srca, 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CLR.B (d16,An) */
uae_u32 REGPARAM2 op_4228_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	put_byte_mmu060(srca, 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CLR.B (d8,An,Xn) */
uae_u32 REGPARAM2 op_4230_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	put_byte_mmu060(srca, 0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* CLR.B (xxx).W */
uae_u32 REGPARAM2 op_4238_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 18;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	put_byte_mmu060(srca, 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CLR.B (xxx).L */
uae_u32 REGPARAM2 op_4239_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 18;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	put_byte_mmu060(srca, 0);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CLR.W Dn */
uae_u32 REGPARAM2 op_4240_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 4;  
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((0) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CLR.W (An) */
uae_u32 REGPARAM2 op_4250_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	put_word_mmu060(srca, 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CLR.W (An)+ */
uae_u32 REGPARAM2 op_4258_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	put_word_mmu060(srca, 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CLR.W -(An) */
uae_u32 REGPARAM2 op_4260_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	put_word_mmu060(srca, 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CLR.W (d16,An) */
uae_u32 REGPARAM2 op_4268_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	put_word_mmu060(srca, 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CLR.W (d8,An,Xn) */
uae_u32 REGPARAM2 op_4270_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	put_word_mmu060(srca, 0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* CLR.W (xxx).W */
uae_u32 REGPARAM2 op_4278_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 18;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	put_word_mmu060(srca, 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CLR.W (xxx).L */
uae_u32 REGPARAM2 op_4279_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 18;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	put_word_mmu060(srca, 0);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CLR.L Dn */
uae_u32 REGPARAM2 op_4280_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 6;  
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	m68k_dreg(regs, srcreg) = (0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CLR.L (An) */
uae_u32 REGPARAM2 op_4290_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	put_long_mmu060(srca, 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CLR.L (An)+ */
uae_u32 REGPARAM2 op_4298_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	put_long_mmu060(srca, 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CLR.L -(An) */
uae_u32 REGPARAM2 op_42a0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	put_long_mmu060(srca, 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CLR.L (d16,An) */
uae_u32 REGPARAM2 op_42a8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	put_long_mmu060(srca, 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CLR.L (d8,An,Xn) */
uae_u32 REGPARAM2 op_42b0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	put_long_mmu060(srca, 0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* CLR.L (xxx).W */
uae_u32 REGPARAM2 op_42b8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 18;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	put_long_mmu060(srca, 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CLR.L (xxx).L */
uae_u32 REGPARAM2 op_42b9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 18;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	put_long_mmu060(srca, 0);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MVSR2.B Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_42c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 4;  
	MakeSR();
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((regs.sr & 0xff) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* MVSR2.B (An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_42d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	MakeSR();
	put_word_mmu060(srca, regs.sr & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* MVSR2.B (An)+ */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_42d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += 2;
	MakeSR();
	put_word_mmu060(srca, regs.sr & 0xff);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* MVSR2.B -(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_42e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	MakeSR();
	put_word_mmu060(srca, regs.sr & 0xff);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* MVSR2.B (d16,An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_42e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	MakeSR();
	put_word_mmu060(srca, regs.sr & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* MVSR2.B (d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_42f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	MakeSR();
	put_word_mmu060(srca, regs.sr & 0xff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

#endif
/* MVSR2.B (xxx).W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_42f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 32;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	MakeSR();
	put_word_mmu060(srca, regs.sr & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* MVSR2.B (xxx).L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_42f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 32;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	MakeSR();
	put_word_mmu060(srca, regs.sr & 0xff);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* NEG.B Dn */
uae_u32 REGPARAM2 op_4400_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((dst) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEG.B (An) */
uae_u32 REGPARAM2 op_4410_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_rmw_byte_mmu060(srca);
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(srca, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEG.B (An)+ */
uae_u32 REGPARAM2 op_4418_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_rmw_byte_mmu060(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(srca, dst);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEG.B -(An) */
uae_u32 REGPARAM2 op_4420_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_rmw_byte_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(srca, dst);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEG.B (d16,An) */
uae_u32 REGPARAM2 op_4428_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_rmw_byte_mmu060(srca);
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(srca, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NEG.B (d8,An,Xn) */
uae_u32 REGPARAM2 op_4430_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_rmw_byte_mmu060(srca);
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(srca, dst);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* NEG.B (xxx).W */
uae_u32 REGPARAM2 op_4438_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 15;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_rmw_byte_mmu060(srca);
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(srca, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NEG.B (xxx).L */
uae_u32 REGPARAM2 op_4439_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 15;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s8 src = get_rmw_byte_mmu060(srca);
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(srca, dst);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* NEG.W Dn */
uae_u32 REGPARAM2 op_4440_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEG.W (An) */
uae_u32 REGPARAM2 op_4450_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_rmw_word_mmu060(srca);
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(srca, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEG.W (An)+ */
uae_u32 REGPARAM2 op_4458_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_rmw_word_mmu060(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(srca, dst);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEG.W -(An) */
uae_u32 REGPARAM2 op_4460_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_rmw_word_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(srca, dst);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEG.W (d16,An) */
uae_u32 REGPARAM2 op_4468_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_rmw_word_mmu060(srca);
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(srca, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NEG.W (d8,An,Xn) */
uae_u32 REGPARAM2 op_4470_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_rmw_word_mmu060(srca);
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(srca, dst);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* NEG.W (xxx).W */
uae_u32 REGPARAM2 op_4478_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 15;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_rmw_word_mmu060(srca);
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(srca, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NEG.W (xxx).L */
uae_u32 REGPARAM2 op_4479_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 15;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s16 src = get_rmw_word_mmu060(srca);
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(srca, dst);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* NEG.L Dn */
uae_u32 REGPARAM2 op_4480_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 6;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, srcreg) = (dst);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEG.L (An) */
uae_u32 REGPARAM2 op_4490_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_rmw_long_mmu060(srca);
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(srca, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEG.L (An)+ */
uae_u32 REGPARAM2 op_4498_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_rmw_long_mmu060(srca);
	m68k_areg(regs, srcreg) += 4;
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(srca, dst);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEG.L -(An) */
uae_u32 REGPARAM2 op_44a0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_rmw_long_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(srca, dst);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEG.L (d16,An) */
uae_u32 REGPARAM2 op_44a8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_rmw_long_mmu060(srca);
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(srca, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NEG.L (d8,An,Xn) */
uae_u32 REGPARAM2 op_44b0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_rmw_long_mmu060(srca);
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(srca, dst);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* NEG.L (xxx).W */
uae_u32 REGPARAM2 op_44b8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 15;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_rmw_long_mmu060(srca);
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(srca, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NEG.L (xxx).L */
uae_u32 REGPARAM2 op_44b9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 15;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s32 src = get_rmw_long_mmu060(srca);
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(srca, dst);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MV2SR.B Dn */
uae_u32 REGPARAM2 op_44c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MV2SR.B (An) */
uae_u32 REGPARAM2 op_44d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MV2SR.B (An)+ */
uae_u32 REGPARAM2 op_44d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) += 2;
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MV2SR.B -(An) */
uae_u32 REGPARAM2 op_44e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MV2SR.B (d16,An) */
uae_u32 REGPARAM2 op_44e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MV2SR.B (d8,An,Xn) */
uae_u32 REGPARAM2 op_44f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu060(srca);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MV2SR.B (xxx).W */
uae_u32 REGPARAM2 op_44f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MV2SR.B (xxx).L */
uae_u32 REGPARAM2 op_44f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MV2SR.B (d16,PC) */
uae_u32 REGPARAM2 op_44fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MV2SR.B (d8,PC,Xn) */
uae_u32 REGPARAM2 op_44fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = get_word_mmu060(srca);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MV2SR.B #<data>.B */
uae_u32 REGPARAM2 op_44fc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_iword_mmu060(2);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NOT.B Dn */
uae_u32 REGPARAM2 op_4600_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((dst) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NOT.B (An) */
uae_u32 REGPARAM2 op_4610_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_rmw_byte_mmu060(srca);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	put_rmw_byte_mmu060(srca, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NOT.B (An)+ */
uae_u32 REGPARAM2 op_4618_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_rmw_byte_mmu060(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	put_rmw_byte_mmu060(srca, dst);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NOT.B -(An) */
uae_u32 REGPARAM2 op_4620_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_rmw_byte_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	put_rmw_byte_mmu060(srca, dst);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NOT.B (d16,An) */
uae_u32 REGPARAM2 op_4628_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_rmw_byte_mmu060(srca);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	put_rmw_byte_mmu060(srca, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NOT.B (d8,An,Xn) */
uae_u32 REGPARAM2 op_4630_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_rmw_byte_mmu060(srca);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	put_rmw_byte_mmu060(srca, dst);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* NOT.B (xxx).W */
uae_u32 REGPARAM2 op_4638_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 19;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_rmw_byte_mmu060(srca);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	put_rmw_byte_mmu060(srca, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NOT.B (xxx).L */
uae_u32 REGPARAM2 op_4639_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 19;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s8 src = get_rmw_byte_mmu060(srca);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	put_rmw_byte_mmu060(srca, dst);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* NOT.W Dn */
uae_u32 REGPARAM2 op_4640_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NOT.W (An) */
uae_u32 REGPARAM2 op_4650_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_rmw_word_mmu060(srca);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	put_rmw_word_mmu060(srca, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NOT.W (An)+ */
uae_u32 REGPARAM2 op_4658_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_rmw_word_mmu060(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	put_rmw_word_mmu060(srca, dst);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NOT.W -(An) */
uae_u32 REGPARAM2 op_4660_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_rmw_word_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	put_rmw_word_mmu060(srca, dst);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NOT.W (d16,An) */
uae_u32 REGPARAM2 op_4668_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_rmw_word_mmu060(srca);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	put_rmw_word_mmu060(srca, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NOT.W (d8,An,Xn) */
uae_u32 REGPARAM2 op_4670_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_rmw_word_mmu060(srca);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	put_rmw_word_mmu060(srca, dst);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* NOT.W (xxx).W */
uae_u32 REGPARAM2 op_4678_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 19;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_rmw_word_mmu060(srca);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	put_rmw_word_mmu060(srca, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NOT.W (xxx).L */
uae_u32 REGPARAM2 op_4679_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 19;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s16 src = get_rmw_word_mmu060(srca);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	put_rmw_word_mmu060(srca, dst);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* NOT.L Dn */
uae_u32 REGPARAM2 op_4680_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 6;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	m68k_dreg(regs, srcreg) = (dst);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NOT.L (An) */
uae_u32 REGPARAM2 op_4690_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_rmw_long_mmu060(srca);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	put_rmw_long_mmu060(srca, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NOT.L (An)+ */
uae_u32 REGPARAM2 op_4698_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_rmw_long_mmu060(srca);
	m68k_areg(regs, srcreg) += 4;
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	put_rmw_long_mmu060(srca, dst);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NOT.L -(An) */
uae_u32 REGPARAM2 op_46a0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_rmw_long_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	put_rmw_long_mmu060(srca, dst);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NOT.L (d16,An) */
uae_u32 REGPARAM2 op_46a8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_rmw_long_mmu060(srca);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	put_rmw_long_mmu060(srca, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NOT.L (d8,An,Xn) */
uae_u32 REGPARAM2 op_46b0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_rmw_long_mmu060(srca);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	put_rmw_long_mmu060(srca, dst);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* NOT.L (xxx).W */
uae_u32 REGPARAM2 op_46b8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 19;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_rmw_long_mmu060(srca);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	put_rmw_long_mmu060(srca, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NOT.L (xxx).L */
uae_u32 REGPARAM2 op_46b9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 19;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s32 src = get_rmw_long_mmu060(srca);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	put_rmw_long_mmu060(srca, dst);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MV2SR.W Dn */
uae_u32 REGPARAM2 op_46c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 12; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 src = m68k_dreg(regs, srcreg);
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	MakeFromSR_T0();
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MV2SR.W (An) */
uae_u32 REGPARAM2 op_46d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	MakeFromSR_T0();
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MV2SR.W (An)+ */
uae_u32 REGPARAM2 op_46d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) += 2;
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	MakeFromSR_T0();
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MV2SR.W -(An) */
uae_u32 REGPARAM2 op_46e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 18; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	MakeFromSR_T0();
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MV2SR.W (d16,An) */
uae_u32 REGPARAM2 op_46e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	MakeFromSR_T0();
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MV2SR.W (d8,An,Xn) */
uae_u32 REGPARAM2 op_46f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu060(srca);
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	MakeFromSR_T0();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MV2SR.W (xxx).W */
uae_u32 REGPARAM2 op_46f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	MakeFromSR_T0();
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MV2SR.W (xxx).L */
uae_u32 REGPARAM2 op_46f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	CurrentInstrCycles = 24; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	MakeFromSR_T0();
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MV2SR.W (d16,PC) */
uae_u32 REGPARAM2 op_46fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	MakeFromSR_T0();
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MV2SR.W (d8,PC,Xn) */
uae_u32 REGPARAM2 op_46fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = get_word_mmu060(srca);
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	MakeFromSR_T0();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MV2SR.W #<data>.W */
uae_u32 REGPARAM2 op_46fc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 src = get_iword_mmu060(2);
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	MakeFromSR_T0();
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NBCD.B Dn */
uae_u32 REGPARAM2 op_4800_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 17;
	CurrentInstrCycles = 6;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* LINK.L An,#<data>.L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4808_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 47;
	CurrentInstrCycles = 18; 
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 offs;
	offs = get_ilong_mmu060(2);
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr olda;
	olda = m68k_areg(regs, 7) - 4;
	mmufixup[1].reg = 7 | 0x0;
	mmufixup[1].value = m68k_areg(regs, 7);
	m68k_areg(regs, 7) = olda;
	m68k_areg(regs, srcreg) = (m68k_areg(regs, 7));
	m68k_areg(regs, 7) += offs;
	put_long_mmu060(olda, src);
	m68k_incpci(6);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* NBCD.B (An) */
uae_u32 REGPARAM2 op_4810_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 17;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_rmw_byte_mmu060(srca);
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	put_rmw_byte_mmu060(srca, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NBCD.B (An)+ */
uae_u32 REGPARAM2 op_4818_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 17;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_rmw_byte_mmu060(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	put_rmw_byte_mmu060(srca, newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NBCD.B -(An) */
uae_u32 REGPARAM2 op_4820_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 17;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_rmw_byte_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	put_rmw_byte_mmu060(srca, newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NBCD.B (d16,An) */
uae_u32 REGPARAM2 op_4828_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 17;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_rmw_byte_mmu060(srca);
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	put_rmw_byte_mmu060(srca, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NBCD.B (d8,An,Xn) */
uae_u32 REGPARAM2 op_4830_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 17;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_rmw_byte_mmu060(srca);
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	put_rmw_byte_mmu060(srca, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* NBCD.B (xxx).W */
uae_u32 REGPARAM2 op_4838_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 17;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_rmw_byte_mmu060(srca);
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	put_rmw_byte_mmu060(srca, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NBCD.B (xxx).L */
uae_u32 REGPARAM2 op_4839_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 17;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s8 src = get_rmw_byte_mmu060(srca);
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	put_rmw_byte_mmu060(srca, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SWAP.W Dn */
uae_u32 REGPARAM2 op_4840_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 34;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_u32 dst = ((src >> 16)&0xFFFF) | ((src&0xFFFF)<<16);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	m68k_dreg(regs, srcreg) = (dst);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* BKPTQ.L #<data> */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4848_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 99;
	CurrentInstrCycles = 4;  
	op_illg(opcode);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* PEA.L (An) */
uae_u32 REGPARAM2 op_4850_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 57;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	mmufixup[0].reg = 7 | 0x0;
	mmufixup[0].value = m68k_areg(regs, 7);
	m68k_areg(regs, 7) = dsta;
	put_long_mmu060(dsta, srca);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* PEA.L (d16,An) */
uae_u32 REGPARAM2 op_4868_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 57;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	mmufixup[0].reg = 7 | 0x0;
	mmufixup[0].value = m68k_areg(regs, 7);
	m68k_areg(regs, 7) = dsta;
	put_long_mmu060(dsta, srca);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* PEA.L (d8,An,Xn) */
uae_u32 REGPARAM2 op_4870_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 57;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	mmufixup[0].reg = 7 | 0x0;
	mmufixup[0].value = m68k_areg(regs, 7);
	m68k_areg(regs, 7) = dsta;
	put_long_mmu060(dsta, srca);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* PEA.L (xxx).W */
uae_u32 REGPARAM2 op_4878_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 57;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	mmufixup[0].reg = 7 | 0x0;
	mmufixup[0].value = m68k_areg(regs, 7);
	m68k_areg(regs, 7) = dsta;
	put_long_mmu060(dsta, srca);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* PEA.L (xxx).L */
uae_u32 REGPARAM2 op_4879_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 57;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	mmufixup[0].reg = 7 | 0x0;
	mmufixup[0].value = m68k_areg(regs, 7);
	m68k_areg(regs, 7) = dsta;
	put_long_mmu060(dsta, srca);
	m68k_incpci(6);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* PEA.L (d16,PC) */
uae_u32 REGPARAM2 op_487a_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 57;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	mmufixup[0].reg = 7 | 0x0;
	mmufixup[0].value = m68k_areg(regs, 7);
	m68k_areg(regs, 7) = dsta;
	put_long_mmu060(dsta, srca);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* PEA.L (d8,PC,Xn) */
uae_u32 REGPARAM2 op_487b_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 57;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	mmufixup[0].reg = 7 | 0x0;
	mmufixup[0].value = m68k_areg(regs, 7);
	m68k_areg(regs, 7) = dsta;
	put_long_mmu060(dsta, srca);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* EXT.W Dn */
uae_u32 REGPARAM2 op_4880_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 36;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_u16 dst = (uae_s16)(uae_s8)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MVMLE.W #<data>.W,(An) */
uae_u32 REGPARAM2 op_4890_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	CurrentInstrCycles = 8;  
	uae_u16 mask = get_iword_mmu060(2);
	uaecptr srca;
	srca = m68k_areg(regs, dstreg);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		put_word_mmu060(srca, m68k_dreg(regs, movem_index1[dmask]));
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		put_word_mmu060(srca, m68k_areg(regs, movem_index1[amask]));
		srca += 2;
		amask = movem_next[amask];
	}
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MVMLE.W #<data>.W,-(An) */
uae_u32 REGPARAM2 op_48a0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	CurrentInstrCycles = 8;  
	uae_u16 mask = get_iword_mmu060(2);
	uaecptr srca;
	srca = m68k_areg(regs, dstreg) - 0;
	uae_u16 amask = mask & 0xff, dmask = (mask >> 8) & 0xff;
	while (amask) {
		srca -= 2;
		int predec = movem_index2[amask] != dstreg ? 0 : 2;
		put_word_mmu060(srca, m68k_areg(regs, movem_index2[amask]) - predec);
		amask = movem_next[amask];
	}
	while (dmask) {
		srca -= 2;
		put_word_mmu060(srca, m68k_dreg(regs, movem_index2[dmask]));
		dmask = movem_next[dmask];
	}
	m68k_areg(regs, dstreg) = srca;
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MVMLE.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_48a8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	CurrentInstrCycles = 12; 
	uae_u16 mask = get_iword_mmu060(2);
	uaecptr srca;
	srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		put_word_mmu060(srca, m68k_dreg(regs, movem_index1[dmask]));
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		put_word_mmu060(srca, m68k_areg(regs, movem_index1[amask]));
		srca += 2;
		amask = movem_next[amask];
	}
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MVMLE.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_48b0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	CurrentInstrCycles = 12; 
	uae_u16 mask = get_iword_mmu060(2);
	uaecptr srca;
	m68k_incpci(4);
	srca = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		put_word_mmu060(srca, m68k_dreg(regs, movem_index1[dmask]));
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		put_word_mmu060(srca, m68k_areg(regs, movem_index1[amask]));
		srca += 2;
		amask = movem_next[amask];
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* MVMLE.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_48b8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 38;
	CurrentInstrCycles = 12; 
	uae_u16 mask = get_iword_mmu060(2);
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		put_word_mmu060(srca, m68k_dreg(regs, movem_index1[dmask]));
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		put_word_mmu060(srca, m68k_areg(regs, movem_index1[amask]));
		srca += 2;
		amask = movem_next[amask];
	}
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MVMLE.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_48b9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 38;
	CurrentInstrCycles = 16; 
	uae_u16 mask = get_iword_mmu060(2);
	uaecptr srca;
	srca = get_ilong_mmu060(4);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		put_word_mmu060(srca, m68k_dreg(regs, movem_index1[dmask]));
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		put_word_mmu060(srca, m68k_areg(regs, movem_index1[amask]));
		srca += 2;
		amask = movem_next[amask];
	}
	m68k_incpci(8);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* EXT.L Dn */
uae_u32 REGPARAM2 op_48c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 36;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_u32 dst = (uae_s32)(uae_s16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	m68k_dreg(regs, srcreg) = (dst);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MVMLE.L #<data>.W,(An) */
uae_u32 REGPARAM2 op_48d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	CurrentInstrCycles = 8;  
	uae_u16 mask = get_iword_mmu060(2);
	uaecptr srca;
	srca = m68k_areg(regs, dstreg);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		put_long_mmu060(srca, m68k_dreg(regs, movem_index1[dmask]));
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		put_long_mmu060(srca, m68k_areg(regs, movem_index1[amask]));
		srca += 4;
		amask = movem_next[amask];
	}
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MVMLE.L #<data>.W,-(An) */
uae_u32 REGPARAM2 op_48e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	CurrentInstrCycles = 8;  
	uae_u16 mask = get_iword_mmu060(2);
	uaecptr srca;
	srca = m68k_areg(regs, dstreg) - 0;
	uae_u16 amask = mask & 0xff, dmask = (mask >> 8) & 0xff;
	while (amask) {
		srca -= 4;
		int predec = movem_index2[amask] != dstreg ? 0 : 4;
		put_long_mmu060(srca, m68k_areg(regs, movem_index2[amask]) - predec);
		amask = movem_next[amask];
	}
	while (dmask) {
		srca -= 4;
		put_long_mmu060(srca, m68k_dreg(regs, movem_index2[dmask]));
		dmask = movem_next[dmask];
	}
	m68k_areg(regs, dstreg) = srca;
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MVMLE.L #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_48e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	CurrentInstrCycles = 12; 
	uae_u16 mask = get_iword_mmu060(2);
	uaecptr srca;
	srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		put_long_mmu060(srca, m68k_dreg(regs, movem_index1[dmask]));
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		put_long_mmu060(srca, m68k_areg(regs, movem_index1[amask]));
		srca += 4;
		amask = movem_next[amask];
	}
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MVMLE.L #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_48f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	CurrentInstrCycles = 12; 
	uae_u16 mask = get_iword_mmu060(2);
	uaecptr srca;
	m68k_incpci(4);
	srca = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		put_long_mmu060(srca, m68k_dreg(regs, movem_index1[dmask]));
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		put_long_mmu060(srca, m68k_areg(regs, movem_index1[amask]));
		srca += 4;
		amask = movem_next[amask];
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* MVMLE.L #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_48f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 38;
	CurrentInstrCycles = 12; 
	uae_u16 mask = get_iword_mmu060(2);
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		put_long_mmu060(srca, m68k_dreg(regs, movem_index1[dmask]));
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		put_long_mmu060(srca, m68k_areg(regs, movem_index1[amask]));
		srca += 4;
		amask = movem_next[amask];
	}
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MVMLE.L #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_48f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 38;
	CurrentInstrCycles = 16; 
	uae_u16 mask = get_iword_mmu060(2);
	uaecptr srca;
	srca = get_ilong_mmu060(4);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		put_long_mmu060(srca, m68k_dreg(regs, movem_index1[dmask]));
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		put_long_mmu060(srca, m68k_areg(regs, movem_index1[amask]));
		srca += 4;
		amask = movem_next[amask];
	}
	m68k_incpci(8);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* EXT.B Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_49c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 36;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_u32 dst = (uae_s32)(uae_s8)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	m68k_dreg(regs, srcreg) = (dst);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* TST.B Dn */
uae_u32 REGPARAM2 op_4a00_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* TST.B (An) */
uae_u32 REGPARAM2 op_4a10_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* TST.B (An)+ */
uae_u32 REGPARAM2 op_4a18_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* TST.B -(An) */
uae_u32 REGPARAM2 op_4a20_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* TST.B (d16,An) */
uae_u32 REGPARAM2 op_4a28_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* TST.B (d8,An,Xn) */
uae_u32 REGPARAM2 op_4a30_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_byte_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* TST.B (xxx).W */
uae_u32 REGPARAM2 op_4a38_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* TST.B (xxx).L */
uae_u32 REGPARAM2 op_4a39_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TST.B (d16,PC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4a3a_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TST.B (d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4a3b_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s8 src = get_byte_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

#endif
/* TST.B #<data>.B */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4a3c_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	CurrentInstrCycles = 8;  
	uae_s8 src = get_ibyte_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TST.W Dn */
uae_u32 REGPARAM2 op_4a40_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* TST.W An */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4a48_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_areg(regs, srcreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* TST.W (An) */
uae_u32 REGPARAM2 op_4a50_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* TST.W (An)+ */
uae_u32 REGPARAM2 op_4a58_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* TST.W -(An) */
uae_u32 REGPARAM2 op_4a60_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* TST.W (d16,An) */
uae_u32 REGPARAM2 op_4a68_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* TST.W (d8,An,Xn) */
uae_u32 REGPARAM2 op_4a70_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* TST.W (xxx).W */
uae_u32 REGPARAM2 op_4a78_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* TST.W (xxx).L */
uae_u32 REGPARAM2 op_4a79_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TST.W (d16,PC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4a7a_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TST.W (d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4a7b_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = get_word_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

#endif
/* TST.W #<data>.W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4a7c_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_iword_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TST.L Dn */
uae_u32 REGPARAM2 op_4a80_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* TST.L An */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4a88_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_areg(regs, srcreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* TST.L (An) */
uae_u32 REGPARAM2 op_4a90_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* TST.L (An)+ */
uae_u32 REGPARAM2 op_4a98_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* TST.L -(An) */
uae_u32 REGPARAM2 op_4aa0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* TST.L (d16,An) */
uae_u32 REGPARAM2 op_4aa8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* TST.L (d8,An,Xn) */
uae_u32 REGPARAM2 op_4ab0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* TST.L (xxx).W */
uae_u32 REGPARAM2 op_4ab8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* TST.L (xxx).L */
uae_u32 REGPARAM2 op_4ab9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TST.L (d16,PC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4aba_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TST.L (d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4abb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = get_long_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

#endif
/* TST.L #<data>.L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4abc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	CurrentInstrCycles = 12; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TAS.B Dn */
uae_u32 REGPARAM2 op_4ac0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 98;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* HALT.L  */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4ac8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 128;
	CurrentInstrCycles = 0;  
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	cpu_halt(CPU_HALT_68060_HALT);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* PULSE.L  */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4acc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 129;
	CurrentInstrCycles = 0;  
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* TAS.B (An) */
uae_u32 REGPARAM2 op_4ad0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 98;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_lrmw_byte_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	put_lrmw_byte_mmu060(srca, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* TAS.B (An)+ */
uae_u32 REGPARAM2 op_4ad8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 98;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_lrmw_byte_mmu060(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	put_lrmw_byte_mmu060(srca, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* TAS.B -(An) */
uae_u32 REGPARAM2 op_4ae0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 98;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_lrmw_byte_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	put_lrmw_byte_mmu060(srca, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* TAS.B (d16,An) */
uae_u32 REGPARAM2 op_4ae8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 98;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_lrmw_byte_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	put_lrmw_byte_mmu060(srca, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* TAS.B (d8,An,Xn) */
uae_u32 REGPARAM2 op_4af0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 98;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_lrmw_byte_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	put_lrmw_byte_mmu060(srca, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* TAS.B (xxx).W */
uae_u32 REGPARAM2 op_4af8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 98;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_lrmw_byte_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	put_lrmw_byte_mmu060(srca, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* TAS.B (xxx).L */
uae_u32 REGPARAM2 op_4af9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 98;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s8 src = get_lrmw_byte_mmu060(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	put_lrmw_byte_mmu060(srca, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MULL.L #<data>.W,Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c00_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 87;
	CurrentInstrCycles = 4;  
	uae_s16 extra = get_iword_mmu060(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(4);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* MULL.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c10_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 87;
	CurrentInstrCycles = 12; 
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu060(dsta);
	m68k_incpci(4);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* MULL.L #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c18_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 87;
	CurrentInstrCycles = 12; 
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu060(dsta);
	m68k_areg(regs, dstreg) += 4;
	m68k_incpci(4);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			cpu_restore_fixup();
		}
		if (e < 0) {
			op_unimpl(opcode);
		}
		mmufixup[0].reg = -1;
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* MULL.L #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c20_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 87;
	CurrentInstrCycles = 14; 
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	m68k_incpci(4);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			cpu_restore_fixup();
		}
		if (e < 0) {
			op_unimpl(opcode);
		}
		mmufixup[0].reg = -1;
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* MULL.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c28_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 87;
	CurrentInstrCycles = 16; 
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s32 dst = get_long_mmu060(dsta);
	m68k_incpci(6);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* MULL.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c30_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 87;
	CurrentInstrCycles = 16; 
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = get_long_mmu060(dsta);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

#endif
/* MULL.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c38_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 87;
	CurrentInstrCycles = 16; 
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s32 dst = get_long_mmu060(dsta);
	m68k_incpci(6);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* MULL.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c39_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 87;
	CurrentInstrCycles = 20; 
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	uae_s32 dst = get_long_mmu060(dsta);
	m68k_incpci(8);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

#endif
/* MULL.L #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c3a_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 87;
	CurrentInstrCycles = 16; 
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s32 dst = get_long_mmu060(dsta);
	m68k_incpci(6);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* MULL.L #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c3b_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 87;
	CurrentInstrCycles = 16; 
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	dsta = x_get_disp_ea_020(tmppc, 0);
	uae_s32 dst = get_long_mmu060(dsta);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

#endif
/* MULL.L #<data>.W,#<data>.L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c3c_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 87;
	CurrentInstrCycles = 12; 
	uae_s16 extra = get_iword_mmu060(2);
	uae_s32 dst;
	dst = get_ilong_mmu060(4);
	m68k_incpci(8);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

#endif
/* DIVL.L #<data>.W,Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c40_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 86;
	CurrentInstrCycles = 4;  
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_iword_mmu060(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(4);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* DIVL.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c50_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 86;
	CurrentInstrCycles = 12; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu060(dsta);
	m68k_incpci(4);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* DIVL.L #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c58_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 86;
	CurrentInstrCycles = 12; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu060(dsta);
	m68k_areg(regs, dstreg) += 4;
	m68k_incpci(4);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			cpu_restore_fixup();
		}
		if (e < 0) {
			op_unimpl(opcode);
		}
		mmufixup[0].reg = -1;
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* DIVL.L #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c60_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 86;
	CurrentInstrCycles = 14; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	m68k_incpci(4);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			cpu_restore_fixup();
		}
		if (e < 0) {
			op_unimpl(opcode);
		}
		mmufixup[0].reg = -1;
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* DIVL.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c68_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 86;
	CurrentInstrCycles = 16; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s32 dst = get_long_mmu060(dsta);
	m68k_incpci(6);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* DIVL.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c70_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 86;
	CurrentInstrCycles = 16; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = get_long_mmu060(dsta);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

#endif
/* DIVL.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c78_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 86;
	CurrentInstrCycles = 16; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s32 dst = get_long_mmu060(dsta);
	m68k_incpci(6);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* DIVL.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c79_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 86;
	CurrentInstrCycles = 20; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = get_ilong_mmu060(4);
	uae_s32 dst = get_long_mmu060(dsta);
	m68k_incpci(8);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

#endif
/* DIVL.L #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c7a_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 86;
	CurrentInstrCycles = 16; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_s32 dst = get_long_mmu060(dsta);
	m68k_incpci(6);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* DIVL.L #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c7b_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 86;
	CurrentInstrCycles = 16; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_iword_mmu060(2);
	uaecptr dsta;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	dsta = x_get_disp_ea_020(tmppc, 0);
	uae_s32 dst = get_long_mmu060(dsta);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

#endif
/* DIVL.L #<data>.W,#<data>.L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c7c_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 86;
	CurrentInstrCycles = 12; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_iword_mmu060(2);
	uae_s32 dst;
	dst = get_ilong_mmu060(4);
	m68k_incpci(8);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

#endif
/* MVMEL.W #<data>.W,(An) */
uae_u32 REGPARAM2 op_4c90_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 37;
	CurrentInstrCycles = 8;  
	uae_u16 mask = get_iword_mmu060(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = m68k_areg(regs, dstreg);
	uae_u32 tmp[16];
	int tmpreg[16];
	int idx = 0;
	while (dmask) {
		tmpreg[idx] = movem_index1[dmask] + 0;
		tmp[idx++] = (uae_s32)(uae_s16)get_word_mmu060(srca);
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		tmpreg[idx] = movem_index1[amask] + 8;
		tmp[idx++] = (uae_s32)(uae_s16)get_word_mmu060(srca);
		srca += 2;
		amask = movem_next[amask];
	}
	while (--idx >= 0) {
		regs.regs[tmpreg[idx]] = tmp[idx];
	}
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MVMEL.W #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_4c98_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 37;
	CurrentInstrCycles = 8;  
	uae_u16 mask = get_iword_mmu060(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = m68k_areg(regs, dstreg);
	uae_u32 tmp[16];
	int tmpreg[16];
	int idx = 0;
	while (dmask) {
		tmpreg[idx] = movem_index1[dmask] + 0;
		tmp[idx++] = (uae_s32)(uae_s16)get_word_mmu060(srca);
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		tmpreg[idx] = movem_index1[amask] + 8;
		tmp[idx++] = (uae_s32)(uae_s16)get_word_mmu060(srca);
		srca += 2;
		amask = movem_next[amask];
	}
	while (--idx >= 0) {
		regs.regs[tmpreg[idx]] = tmp[idx];
	}
	m68k_areg(regs, dstreg) = srca;
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MVMEL.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_4ca8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 37;
	CurrentInstrCycles = 12; 
	uae_u16 mask = get_iword_mmu060(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_u32 tmp[16];
	int tmpreg[16];
	int idx = 0;
	while (dmask) {
		tmpreg[idx] = movem_index1[dmask] + 0;
		tmp[idx++] = (uae_s32)(uae_s16)get_word_mmu060(srca);
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		tmpreg[idx] = movem_index1[amask] + 8;
		tmp[idx++] = (uae_s32)(uae_s16)get_word_mmu060(srca);
		srca += 2;
		amask = movem_next[amask];
	}
	while (--idx >= 0) {
		regs.regs[tmpreg[idx]] = tmp[idx];
	}
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MVMEL.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_4cb0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 37;
	CurrentInstrCycles = 12; 
	uae_u16 mask = get_iword_mmu060(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	m68k_incpci(4);
	srca = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_u32 tmp[16];
	int tmpreg[16];
	int idx = 0;
	while (dmask) {
		tmpreg[idx] = movem_index1[dmask] + 0;
		tmp[idx++] = (uae_s32)(uae_s16)get_word_mmu060(srca);
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		tmpreg[idx] = movem_index1[amask] + 8;
		tmp[idx++] = (uae_s32)(uae_s16)get_word_mmu060(srca);
		srca += 2;
		amask = movem_next[amask];
	}
	while (--idx >= 0) {
		regs.regs[tmpreg[idx]] = tmp[idx];
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* MVMEL.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_4cb8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 37;
	CurrentInstrCycles = 12; 
	uae_u16 mask = get_iword_mmu060(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_u32 tmp[16];
	int tmpreg[16];
	int idx = 0;
	while (dmask) {
		tmpreg[idx] = movem_index1[dmask] + 0;
		tmp[idx++] = (uae_s32)(uae_s16)get_word_mmu060(srca);
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		tmpreg[idx] = movem_index1[amask] + 8;
		tmp[idx++] = (uae_s32)(uae_s16)get_word_mmu060(srca);
		srca += 2;
		amask = movem_next[amask];
	}
	while (--idx >= 0) {
		regs.regs[tmpreg[idx]] = tmp[idx];
	}
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MVMEL.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_4cb9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 37;
	CurrentInstrCycles = 16; 
	uae_u16 mask = get_iword_mmu060(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = get_ilong_mmu060(4);
	uae_u32 tmp[16];
	int tmpreg[16];
	int idx = 0;
	while (dmask) {
		tmpreg[idx] = movem_index1[dmask] + 0;
		tmp[idx++] = (uae_s32)(uae_s16)get_word_mmu060(srca);
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		tmpreg[idx] = movem_index1[amask] + 8;
		tmp[idx++] = (uae_s32)(uae_s16)get_word_mmu060(srca);
		srca += 2;
		amask = movem_next[amask];
	}
	while (--idx >= 0) {
		regs.regs[tmpreg[idx]] = tmp[idx];
	}
	m68k_incpci(8);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MVMEL.W #<data>.W,(d16,PC) */
uae_u32 REGPARAM2 op_4cba_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 37;
	CurrentInstrCycles = 12; 
	uae_u16 mask = get_iword_mmu060(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = m68k_getpci() + 4;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_u32 tmp[16];
	int tmpreg[16];
	int idx = 0;
	while (dmask) {
		tmpreg[idx] = movem_index1[dmask] + 0;
		tmp[idx++] = (uae_s32)(uae_s16)get_word_mmu060(srca);
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		tmpreg[idx] = movem_index1[amask] + 8;
		tmp[idx++] = (uae_s32)(uae_s16)get_word_mmu060(srca);
		srca += 2;
		amask = movem_next[amask];
	}
	while (--idx >= 0) {
		regs.regs[tmpreg[idx]] = tmp[idx];
	}
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MVMEL.W #<data>.W,(d8,PC,Xn) */
uae_u32 REGPARAM2 op_4cbb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 37;
	CurrentInstrCycles = 12; 
	uae_u16 mask = get_iword_mmu060(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_u32 tmp[16];
	int tmpreg[16];
	int idx = 0;
	while (dmask) {
		tmpreg[idx] = movem_index1[dmask] + 0;
		tmp[idx++] = (uae_s32)(uae_s16)get_word_mmu060(srca);
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		tmpreg[idx] = movem_index1[amask] + 8;
		tmp[idx++] = (uae_s32)(uae_s16)get_word_mmu060(srca);
		srca += 2;
		amask = movem_next[amask];
	}
	while (--idx >= 0) {
		regs.regs[tmpreg[idx]] = tmp[idx];
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* MVMEL.L #<data>.W,(An) */
uae_u32 REGPARAM2 op_4cd0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 37;
	CurrentInstrCycles = 8;  
	uae_u16 mask = get_iword_mmu060(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = m68k_areg(regs, dstreg);
	uae_u32 tmp[16];
	int tmpreg[16];
	int idx = 0;
	while (dmask) {
		tmpreg[idx] = movem_index1[dmask] + 0;
		tmp[idx++] = get_long_mmu060(srca);
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		tmpreg[idx] = movem_index1[amask] + 8;
		tmp[idx++] = get_long_mmu060(srca);
		srca += 4;
		amask = movem_next[amask];
	}
	while (--idx >= 0) {
		regs.regs[tmpreg[idx]] = tmp[idx];
	}
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MVMEL.L #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_4cd8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 37;
	CurrentInstrCycles = 8;  
	uae_u16 mask = get_iword_mmu060(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = m68k_areg(regs, dstreg);
	uae_u32 tmp[16];
	int tmpreg[16];
	int idx = 0;
	while (dmask) {
		tmpreg[idx] = movem_index1[dmask] + 0;
		tmp[idx++] = get_long_mmu060(srca);
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		tmpreg[idx] = movem_index1[amask] + 8;
		tmp[idx++] = get_long_mmu060(srca);
		srca += 4;
		amask = movem_next[amask];
	}
	while (--idx >= 0) {
		regs.regs[tmpreg[idx]] = tmp[idx];
	}
	m68k_areg(regs, dstreg) = srca;
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MVMEL.L #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_4ce8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 37;
	CurrentInstrCycles = 12; 
	uae_u16 mask = get_iword_mmu060(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_u32 tmp[16];
	int tmpreg[16];
	int idx = 0;
	while (dmask) {
		tmpreg[idx] = movem_index1[dmask] + 0;
		tmp[idx++] = get_long_mmu060(srca);
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		tmpreg[idx] = movem_index1[amask] + 8;
		tmp[idx++] = get_long_mmu060(srca);
		srca += 4;
		amask = movem_next[amask];
	}
	while (--idx >= 0) {
		regs.regs[tmpreg[idx]] = tmp[idx];
	}
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MVMEL.L #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_4cf0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 37;
	CurrentInstrCycles = 12; 
	uae_u16 mask = get_iword_mmu060(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	m68k_incpci(4);
	srca = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_u32 tmp[16];
	int tmpreg[16];
	int idx = 0;
	while (dmask) {
		tmpreg[idx] = movem_index1[dmask] + 0;
		tmp[idx++] = get_long_mmu060(srca);
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		tmpreg[idx] = movem_index1[amask] + 8;
		tmp[idx++] = get_long_mmu060(srca);
		srca += 4;
		amask = movem_next[amask];
	}
	while (--idx >= 0) {
		regs.regs[tmpreg[idx]] = tmp[idx];
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* MVMEL.L #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_4cf8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 37;
	CurrentInstrCycles = 12; 
	uae_u16 mask = get_iword_mmu060(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_u32 tmp[16];
	int tmpreg[16];
	int idx = 0;
	while (dmask) {
		tmpreg[idx] = movem_index1[dmask] + 0;
		tmp[idx++] = get_long_mmu060(srca);
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		tmpreg[idx] = movem_index1[amask] + 8;
		tmp[idx++] = get_long_mmu060(srca);
		srca += 4;
		amask = movem_next[amask];
	}
	while (--idx >= 0) {
		regs.regs[tmpreg[idx]] = tmp[idx];
	}
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MVMEL.L #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_4cf9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 37;
	CurrentInstrCycles = 16; 
	uae_u16 mask = get_iword_mmu060(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = get_ilong_mmu060(4);
	uae_u32 tmp[16];
	int tmpreg[16];
	int idx = 0;
	while (dmask) {
		tmpreg[idx] = movem_index1[dmask] + 0;
		tmp[idx++] = get_long_mmu060(srca);
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		tmpreg[idx] = movem_index1[amask] + 8;
		tmp[idx++] = get_long_mmu060(srca);
		srca += 4;
		amask = movem_next[amask];
	}
	while (--idx >= 0) {
		regs.regs[tmpreg[idx]] = tmp[idx];
	}
	m68k_incpci(8);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MVMEL.L #<data>.W,(d16,PC) */
uae_u32 REGPARAM2 op_4cfa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 37;
	CurrentInstrCycles = 12; 
	uae_u16 mask = get_iword_mmu060(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = m68k_getpci() + 4;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(4);
	uae_u32 tmp[16];
	int tmpreg[16];
	int idx = 0;
	while (dmask) {
		tmpreg[idx] = movem_index1[dmask] + 0;
		tmp[idx++] = get_long_mmu060(srca);
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		tmpreg[idx] = movem_index1[amask] + 8;
		tmp[idx++] = get_long_mmu060(srca);
		srca += 4;
		amask = movem_next[amask];
	}
	while (--idx >= 0) {
		regs.regs[tmpreg[idx]] = tmp[idx];
	}
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MVMEL.L #<data>.W,(d8,PC,Xn) */
uae_u32 REGPARAM2 op_4cfb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 37;
	CurrentInstrCycles = 12; 
	uae_u16 mask = get_iword_mmu060(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_u32 tmp[16];
	int tmpreg[16];
	int idx = 0;
	while (dmask) {
		tmpreg[idx] = movem_index1[dmask] + 0;
		tmp[idx++] = get_long_mmu060(srca);
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		tmpreg[idx] = movem_index1[amask] + 8;
		tmp[idx++] = get_long_mmu060(srca);
		srca += 4;
		amask = movem_next[amask];
	}
	while (--idx >= 0) {
		regs.regs[tmpreg[idx]] = tmp[idx];
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* TRAPQ.L #<data> */
uae_u32 REGPARAM2 op_4e40_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 15);
	OpcodeFamily = 39;
	CurrentInstrCycles = 0;  
	uae_u32 src = srcreg;
	m68k_incpci(2);
	Exception_cpu(src + 32);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* LINK.W An,#<data>.W */
uae_u32 REGPARAM2 op_4e50_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 47;
	CurrentInstrCycles = 14; 
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 offs = get_iword_mmu060(2);
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr olda;
	olda = m68k_areg(regs, 7) - 4;
	mmufixup[1].reg = 7 | 0x0;
	mmufixup[1].value = m68k_areg(regs, 7);
	m68k_areg(regs, 7) = olda;
	m68k_areg(regs, srcreg) = (m68k_areg(regs, 7));
	m68k_areg(regs, 7) += offs;
	put_long_mmu060(olda, src);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* UNLK.L An */
uae_u32 REGPARAM2 op_4e58_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 48;
	CurrentInstrCycles = 0;  
	uae_s32 src = m68k_areg(regs, srcreg);
	uae_s32 old = get_long_mmu060(src);
	m68k_areg(regs, 7) = src + 4;
	m68k_areg(regs, srcreg) = old;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MVR2USP.L An */
uae_u32 REGPARAM2 op_4e60_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 40;
	CurrentInstrCycles = 4;  
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s32 src = m68k_areg(regs, srcreg);
	regs.usp = src;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MVUSP2R.L An */
uae_u32 REGPARAM2 op_4e68_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 41;
	CurrentInstrCycles = 4;  
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	m68k_areg(regs, srcreg) = (regs.usp);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* RESET.L  */
uae_u32 REGPARAM2 op_4e70_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 42;
	CurrentInstrCycles = 132;
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	bool r = cpureset();
	if (r) {
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NOP.L  */
uae_u32 REGPARAM2 op_4e71_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 43;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* STOP.L #<data>.W */
uae_u32 REGPARAM2 op_4e72_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 44;
	CurrentInstrCycles = 4;  
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	if (!regs.stopped) {
		uae_s16 src = get_iword_mmu060(2);
		regs.ir = src;
	}
	uae_u16 sr = regs.ir;
	if (!(sr & 0x2000)) {
		Exception(8);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.sr = sr;
	checkint();
	MakeFromSR_STOP();
	do_cycles_stop(4);
	m68k_setstopped(1);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}

/* RTE.L  */
uae_u32 REGPARAM2 op_4e73_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 45;
	CurrentInstrCycles = 24; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr oldpc = m68k_getpci();
	uae_u16 oldsr = regs.sr, newsr;
	uae_u32 newpc;
	for (;;) {
		uaecptr a = m68k_areg(regs, 7);
		uae_u16 sr = get_word_mmu060(a);
		uae_u32 pc = get_long_mmu060(a + 2);
		uae_u16 format = get_word_mmu060(a + 2 + 4);
		int frame = format >> 12;
		int offset = 8;
		newsr = sr; newpc = pc;
		if (frame == 0x0) {
		m68k_areg(regs, 7) += offset; break; }
		else if (frame == 0x1) {
		m68k_areg(regs, 7) += offset; }
		else if (frame == 0x2) {
		m68k_areg(regs, 7) += offset + 4; break; }
		else if (frame == 0x3) {
		m68k_areg(regs, 7) += offset + 4; break; }
		else if (frame == 0x4) {
		m68k_do_rte_mmu060 (a); m68k_areg(regs, 7) += offset + 8; break; }
		else {
			Exception_cpu(14);
			return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		regs.sr = newsr;
		oldsr = newsr;
		MakeFromSR_T0();
	}
	regs.sr = newsr;
	MakeFromSR_T0();
	if (newpc & 1) {
		regs.sr = oldsr & 0xff00;
		MakeFromSR();
		SET_ZFLG(newsr == 0);
		SET_NFLG(newsr & 0x8000);
		exception3_read_prefetch(opcode, newpc);
		return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_setpci(newpc);
	#ifdef DEBUGGER
	branch_stack_pop_rte(oldpc);
	#endif
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* RTD.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4e74_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 46;
	CurrentInstrCycles = 20; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 offs = get_iword_mmu060(2);
	uaecptr pca;
	pca = m68k_areg(regs, 7);
	mmufixup[0].reg = 7 | 0x0;
	mmufixup[0].value = m68k_areg(regs, 7);
	uae_s32 pc = get_long_mmu060(pca);
	m68k_areg(regs, 7) += 4;
	m68k_areg(regs, 7) += offs;
	if (pc & 1) {
		m68k_areg(regs, 7) -= 4 + offs;
		exception3_read_prefetch_only(opcode, pc);
		mmufixup[0].reg = -1;
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_setpci(pc);
	if(regs.t0) check_t0_trace();
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

#endif
/* RTS.L  */
uae_u32 REGPARAM2 op_4e75_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 49;
	CurrentInstrCycles = 16; 
	uaecptr oldpc = m68k_getpci();
	m68k_do_rts_mmu060();
	#ifdef DEBUGGER
	if (debugmem_trace) {
		branch_stack_pop_rts(oldpc);
	}
	#endif
	if (m68k_getpci() & 1) {
		uaecptr faultpc = m68k_getpci();
		m68k_setpci(oldpc);
		m68k_areg(regs, 7) -= 4;
		exception3_read_prefetch_only(opcode, faultpc);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if(regs.t0) check_t0_trace();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* TRAPV.L  */
uae_u32 REGPARAM2 op_4e76_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 50;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (GET_VFLG()) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* RTR.L  */
uae_u32 REGPARAM2 op_4e77_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 51;
	CurrentInstrCycles = 20; 
	uaecptr oldpc = m68k_getpci();
	MakeSR();
	uaecptr sra;
	sra = m68k_areg(regs, 7);
	mmufixup[0].reg = 7 | 0x0;
	mmufixup[0].value = m68k_areg(regs, 7);
	uae_s16 sr = get_word_mmu060(sra);
	m68k_areg(regs, 7) += 2;
	uaecptr pca;
	pca = m68k_areg(regs, 7);
	mmufixup[1].reg = 7 | 0x0;
	mmufixup[1].value = m68k_areg(regs, 7);
	uae_s32 pc = get_long_mmu060(pca);
	m68k_areg(regs, 7) += 4;
	if (pc & 1) {
		m68k_areg(regs, 7) -= 6;
		regs.sr &= 0xFF00; sr &= 0xFF;
		regs.sr |= sr;
		MakeFromSR();
		exception3_read_prefetch(opcode, pc);
		mmufixup[0].reg = -1;
		mmufixup[1].reg = -1;
		return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.sr &= 0xFF00; sr &= 0xFF;
	regs.sr |= sr;
	MakeFromSR();
	m68k_setpci(pc);
	if(regs.t0) check_t0_trace();
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* MOVEC2.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4e7a_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 82;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_iword_mmu060(2);
	int regno = (src >> 12) & 15;
	uae_u32 *regp = regs.regs + regno;
	if (!m68k_movec2(src & 0xFFF, regp)) {
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* MOVE2C.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4e7b_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 83;
	CurrentInstrCycles = 10; 
	uae_s16 src = get_iword_mmu060(2);
	int regno = (src >> 12) & 15;
	uae_u32 *regp = regs.regs + regno;
	if (!m68k_move2c(src & 0xFFF, regp)) {
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* JSR.L (An) */
uae_u32 REGPARAM2 op_4e90_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 52;
	CurrentInstrCycles = 4;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 2;
	put_long_mmu060(m68k_areg(regs, 7) - 4, nextpc);
	m68k_areg(regs, 7) -= 4;
	m68k_setpci(srca);
	if(regs.t0) check_t0_trace();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* JSR.L (d16,An) */
uae_u32 REGPARAM2 op_4ea8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 52;
	CurrentInstrCycles = 4;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 4;
	put_long_mmu060(m68k_areg(regs, 7) - 4, nextpc);
	m68k_areg(regs, 7) -= 4;
	m68k_setpci(srca);
	if(regs.t0) check_t0_trace();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* JSR.L (d8,An,Xn) */
uae_u32 REGPARAM2 op_4eb0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 52;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 0;
	put_long_mmu060(m68k_areg(regs, 7) - 4, nextpc);
	m68k_areg(regs, 7) -= 4;
	m68k_setpci(srca);
	if(regs.t0) check_t0_trace();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0 B */

/* JSR.L (xxx).W */
uae_u32 REGPARAM2 op_4eb8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 52;
	CurrentInstrCycles = 4;  
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 4;
	put_long_mmu060(m68k_areg(regs, 7) - 4, nextpc);
	m68k_areg(regs, 7) -= 4;
	m68k_setpci(srca);
	if(regs.t0) check_t0_trace();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* JSR.L (xxx).L */
uae_u32 REGPARAM2 op_4eb9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 52;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 6;
	put_long_mmu060(m68k_areg(regs, 7) - 4, nextpc);
	m68k_areg(regs, 7) -= 4;
	m68k_setpci(srca);
	if(regs.t0) check_t0_trace();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* JSR.L (d16,PC) */
uae_u32 REGPARAM2 op_4eba_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 52;
	CurrentInstrCycles = 4;  
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 4;
	put_long_mmu060(m68k_areg(regs, 7) - 4, nextpc);
	m68k_areg(regs, 7) -= 4;
	m68k_setpci(srca);
	if(regs.t0) check_t0_trace();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* JSR.L (d8,PC,Xn) */
uae_u32 REGPARAM2 op_4ebb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 52;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 0;
	put_long_mmu060(m68k_areg(regs, 7) - 4, nextpc);
	m68k_areg(regs, 7) -= 4;
	m68k_setpci(srca);
	if(regs.t0) check_t0_trace();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0 B */

/* JMP.L (An) */
uae_u32 REGPARAM2 op_4ed0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 53;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uaecptr oldpc = m68k_getpci();
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_prefetch_only(opcode, srca);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_setpci(srca);
	if(regs.t0) check_t0_trace();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* JMP.L (d16,An) */
uae_u32 REGPARAM2 op_4ee8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 53;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uaecptr oldpc = m68k_getpci();
	if (srca & 1) {
		count_cycles += 2 * CYCLE_UNIT / 2;
		m68k_incpci(2);
		exception3_read_prefetch_only(opcode, srca);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_setpci(srca);
	if(regs.t0) check_t0_trace();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* JMP.L (d8,An,Xn) */
uae_u32 REGPARAM2 op_4ef0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 53;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uaecptr oldpc = m68k_getpci();
	if (srca & 1) {
		count_cycles += 6 * CYCLE_UNIT / 2;
		m68k_incpci(2);
		exception3_read_prefetch_only(opcode, srca);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_setpci(srca);
	if(regs.t0) check_t0_trace();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0 B */

/* JMP.L (xxx).W */
uae_u32 REGPARAM2 op_4ef8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 53;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uaecptr oldpc = m68k_getpci();
	if (srca & 1) {
		count_cycles += 2 * CYCLE_UNIT / 2;
		m68k_incpci(2);
		exception3_read_prefetch_only(opcode, srca);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_setpci(srca);
	if(regs.t0) check_t0_trace();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* JMP.L (xxx).L */
uae_u32 REGPARAM2 op_4ef9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 53;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uaecptr oldpc = m68k_getpci();
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_prefetch_only(opcode, srca);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_setpci(srca);
	if(regs.t0) check_t0_trace();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* JMP.L (d16,PC) */
uae_u32 REGPARAM2 op_4efa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 53;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uaecptr oldpc = m68k_getpci();
	if (srca & 1) {
		count_cycles += 2 * CYCLE_UNIT / 2;
		m68k_incpci(2);
		exception3_read_prefetch_only(opcode, srca);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_setpci(srca);
	if(regs.t0) check_t0_trace();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* JMP.L (d8,PC,Xn) */
uae_u32 REGPARAM2 op_4efb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 53;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uaecptr oldpc = m68k_getpci();
	if (srca & 1) {
		count_cycles += 6 * CYCLE_UNIT / 2;
		m68k_incpci(2);
		exception3_read_prefetch_only(opcode, srca);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_setpci(srca);
	if(regs.t0) check_t0_trace();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0 B */

/* ADDQ.B #<data>,Dn */
uae_u32 REGPARAM2 op_5000_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 4;  
	uae_u32 src = srcreg;
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* ADDQ.B #<data>,(An) */
uae_u32 REGPARAM2 op_5010_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 12; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* ADDQ.B #<data>,(An)+ */
uae_u32 REGPARAM2 op_5018_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 12; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* ADDQ.B #<data>,-(An) */
uae_u32 REGPARAM2 op_5020_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 14; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* ADDQ.B #<data>,(d16,An) */
uae_u32 REGPARAM2 op_5028_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 16; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* ADDQ.B #<data>,(d8,An,Xn) */
uae_u32 REGPARAM2 op_5030_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 16; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* ADDQ.B #<data>,(xxx).W */
uae_u32 REGPARAM2 op_5038_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 11;
	CurrentInstrCycles = 16; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* ADDQ.B #<data>,(xxx).L */
uae_u32 REGPARAM2 op_5039_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 11;
	CurrentInstrCycles = 20; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* ADDQ.W #<data>,Dn */
uae_u32 REGPARAM2 op_5040_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 4;  
	uae_u32 src = srcreg;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* ADDAQ.W #<data>,An */
uae_u32 REGPARAM2 op_5048_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 12;
	CurrentInstrCycles = 8;  
	uae_u32 src = srcreg;
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* ADDQ.W #<data>,(An) */
uae_u32 REGPARAM2 op_5050_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 12; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* ADDQ.W #<data>,(An)+ */
uae_u32 REGPARAM2 op_5058_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 12; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	m68k_areg(regs, dstreg) += 2;
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* ADDQ.W #<data>,-(An) */
uae_u32 REGPARAM2 op_5060_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 14; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* ADDQ.W #<data>,(d16,An) */
uae_u32 REGPARAM2 op_5068_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 16; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* ADDQ.W #<data>,(d8,An,Xn) */
uae_u32 REGPARAM2 op_5070_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 16; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* ADDQ.W #<data>,(xxx).W */
uae_u32 REGPARAM2 op_5078_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 11;
	CurrentInstrCycles = 16; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* ADDQ.W #<data>,(xxx).L */
uae_u32 REGPARAM2 op_5079_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 11;
	CurrentInstrCycles = 20; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* ADDQ.L #<data>,Dn */
uae_u32 REGPARAM2 op_5080_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 6;  
	uae_u32 src = srcreg;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* ADDAQ.L #<data>,An */
uae_u32 REGPARAM2 op_5088_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 12;
	CurrentInstrCycles = 8;  
	uae_u32 src = srcreg;
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* ADDQ.L #<data>,(An) */
uae_u32 REGPARAM2 op_5090_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 20; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* ADDQ.L #<data>,(An)+ */
uae_u32 REGPARAM2 op_5098_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 20; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	m68k_areg(regs, dstreg) += 4;
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* ADDQ.L #<data>,-(An) */
uae_u32 REGPARAM2 op_50a0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 22; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* ADDQ.L #<data>,(d16,An) */
uae_u32 REGPARAM2 op_50a8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 24; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* ADDQ.L #<data>,(d8,An,Xn) */
uae_u32 REGPARAM2 op_50b0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 24; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* ADDQ.L #<data>,(xxx).W */
uae_u32 REGPARAM2 op_50b8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 11;
	CurrentInstrCycles = 24; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* ADDQ.L #<data>,(xxx).L */
uae_u32 REGPARAM2 op_50b9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 11;
	CurrentInstrCycles = 28; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* Scc.B Dn (T) */
uae_u32 REGPARAM2 op_50c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 4;  
	int val = cctrue(0) ? 0xff : 0x00;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (T) */
uae_u32 REGPARAM2 op_50c8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	CurrentInstrCycles = 14; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_iword_mmu060(2);
	uaecptr oldpc = m68k_getpci();
	if (offs & 1) {
		exception3_read_prefetch(opcode, oldpc + (uae_s32)offs + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (!cctrue(0)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if(regs.t0) check_t0_trace();
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci(oldpc + 4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* Scc.B (An) (T) */
uae_u32 REGPARAM2 op_50d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	int val = cctrue(0) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (An)+ (T) */
uae_u32 REGPARAM2 op_50d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	int val = cctrue(0) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B -(An) (T) */
uae_u32 REGPARAM2 op_50e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	int val = cctrue(0) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (d16,An) (T) */
uae_u32 REGPARAM2 op_50e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	int val = cctrue(0) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (T) */
uae_u32 REGPARAM2 op_50f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	int val = cctrue(0) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* Scc.B (xxx).W (T) */
uae_u32 REGPARAM2 op_50f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	int val = cctrue(0) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (xxx).L (T) */
uae_u32 REGPARAM2 op_50f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	int val = cctrue(0) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (T) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_50fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 8;  
	uae_s16 dummy = get_iword_mmu060(2);
	m68k_incpci(4);
	if (cctrue(0)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (T) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_50fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 12; 
	uae_s32 dummy;
	dummy = get_ilong_mmu060(2);
	m68k_incpci(6);
	if (cctrue(0)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (T) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_50fc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (cctrue(0)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* SUBQ.B #<data>,Dn */
uae_u32 REGPARAM2 op_5100_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 4;  
	uae_u32 src = srcreg;
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBQ.B #<data>,(An) */
uae_u32 REGPARAM2 op_5110_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBQ.B #<data>,(An)+ */
uae_u32 REGPARAM2 op_5118_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBQ.B #<data>,-(An) */
uae_u32 REGPARAM2 op_5120_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 14; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBQ.B #<data>,(d16,An) */
uae_u32 REGPARAM2 op_5128_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUBQ.B #<data>,(d8,An,Xn) */
uae_u32 REGPARAM2 op_5130_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* SUBQ.B #<data>,(xxx).W */
uae_u32 REGPARAM2 op_5138_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUBQ.B #<data>,(xxx).L */
uae_u32 REGPARAM2 op_5139_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUBQ.W #<data>,Dn */
uae_u32 REGPARAM2 op_5140_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 4;  
	uae_u32 src = srcreg;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBAQ.W #<data>,An */
uae_u32 REGPARAM2 op_5148_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 8;  
	uae_u32 src = srcreg;
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBQ.W #<data>,(An) */
uae_u32 REGPARAM2 op_5150_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBQ.W #<data>,(An)+ */
uae_u32 REGPARAM2 op_5158_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	m68k_areg(regs, dstreg) += 2;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBQ.W #<data>,-(An) */
uae_u32 REGPARAM2 op_5160_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 14; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBQ.W #<data>,(d16,An) */
uae_u32 REGPARAM2 op_5168_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUBQ.W #<data>,(d8,An,Xn) */
uae_u32 REGPARAM2 op_5170_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* SUBQ.W #<data>,(xxx).W */
uae_u32 REGPARAM2 op_5178_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUBQ.W #<data>,(xxx).L */
uae_u32 REGPARAM2 op_5179_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUBQ.L #<data>,Dn */
uae_u32 REGPARAM2 op_5180_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 6;  
	uae_u32 src = srcreg;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBAQ.L #<data>,An */
uae_u32 REGPARAM2 op_5188_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 8;  
	uae_u32 src = srcreg;
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBQ.L #<data>,(An) */
uae_u32 REGPARAM2 op_5190_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBQ.L #<data>,(An)+ */
uae_u32 REGPARAM2 op_5198_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	m68k_areg(regs, dstreg) += 4;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBQ.L #<data>,-(An) */
uae_u32 REGPARAM2 op_51a0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 22; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBQ.L #<data>,(d16,An) */
uae_u32 REGPARAM2 op_51a8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 24; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUBQ.L #<data>,(d8,An,Xn) */
uae_u32 REGPARAM2 op_51b0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 24; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* SUBQ.L #<data>,(xxx).W */
uae_u32 REGPARAM2 op_51b8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 7;
	CurrentInstrCycles = 24; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUBQ.L #<data>,(xxx).L */
uae_u32 REGPARAM2 op_51b9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 7;
	CurrentInstrCycles = 28; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* Scc.B Dn (F) */
uae_u32 REGPARAM2 op_51c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 4;  
	int val = cctrue(1) ? 0xff : 0x00;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (F) */
uae_u32 REGPARAM2 op_51c8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	CurrentInstrCycles = 14; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_iword_mmu060(2);
	uaecptr oldpc = m68k_getpci();
	if (offs & 1) {
		exception3_read_prefetch(opcode, oldpc + (uae_s32)offs + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (!cctrue(1)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if(regs.t0) check_t0_trace();
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci(oldpc + 4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* Scc.B (An) (F) */
uae_u32 REGPARAM2 op_51d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	int val = cctrue(1) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (An)+ (F) */
uae_u32 REGPARAM2 op_51d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	int val = cctrue(1) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B -(An) (F) */
uae_u32 REGPARAM2 op_51e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	int val = cctrue(1) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (d16,An) (F) */
uae_u32 REGPARAM2 op_51e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	int val = cctrue(1) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (F) */
uae_u32 REGPARAM2 op_51f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	int val = cctrue(1) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* Scc.B (xxx).W (F) */
uae_u32 REGPARAM2 op_51f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	int val = cctrue(1) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (xxx).L (F) */
uae_u32 REGPARAM2 op_51f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	int val = cctrue(1) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (F) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_51fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 8;  
	uae_s16 dummy = get_iword_mmu060(2);
	m68k_incpci(4);
	if (cctrue(1)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (F) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_51fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 12; 
	uae_s32 dummy;
	dummy = get_ilong_mmu060(2);
	m68k_incpci(6);
	if (cctrue(1)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (F) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_51fc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (cctrue(1)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (HI) */
uae_u32 REGPARAM2 op_52c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 4;  
	int val = cctrue(2) ? 0xff : 0x00;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (HI) */
uae_u32 REGPARAM2 op_52c8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	CurrentInstrCycles = 14; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_iword_mmu060(2);
	uaecptr oldpc = m68k_getpci();
	if (offs & 1) {
		exception3_read_prefetch(opcode, oldpc + (uae_s32)offs + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (!cctrue(2)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if(regs.t0) check_t0_trace();
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci(oldpc + 4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* Scc.B (An) (HI) */
uae_u32 REGPARAM2 op_52d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	int val = cctrue(2) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (An)+ (HI) */
uae_u32 REGPARAM2 op_52d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	int val = cctrue(2) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B -(An) (HI) */
uae_u32 REGPARAM2 op_52e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	int val = cctrue(2) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (d16,An) (HI) */
uae_u32 REGPARAM2 op_52e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	int val = cctrue(2) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (HI) */
uae_u32 REGPARAM2 op_52f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	int val = cctrue(2) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* Scc.B (xxx).W (HI) */
uae_u32 REGPARAM2 op_52f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	int val = cctrue(2) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (xxx).L (HI) */
uae_u32 REGPARAM2 op_52f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	int val = cctrue(2) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (HI) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_52fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 8;  
	uae_s16 dummy = get_iword_mmu060(2);
	m68k_incpci(4);
	if (cctrue(2)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (HI) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_52fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 12; 
	uae_s32 dummy;
	dummy = get_ilong_mmu060(2);
	m68k_incpci(6);
	if (cctrue(2)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (HI) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_52fc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (cctrue(2)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (LS) */
uae_u32 REGPARAM2 op_53c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 4;  
	int val = cctrue(3) ? 0xff : 0x00;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (LS) */
uae_u32 REGPARAM2 op_53c8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	CurrentInstrCycles = 14; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_iword_mmu060(2);
	uaecptr oldpc = m68k_getpci();
	if (offs & 1) {
		exception3_read_prefetch(opcode, oldpc + (uae_s32)offs + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (!cctrue(3)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if(regs.t0) check_t0_trace();
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci(oldpc + 4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* Scc.B (An) (LS) */
uae_u32 REGPARAM2 op_53d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	int val = cctrue(3) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (An)+ (LS) */
uae_u32 REGPARAM2 op_53d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	int val = cctrue(3) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B -(An) (LS) */
uae_u32 REGPARAM2 op_53e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	int val = cctrue(3) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (d16,An) (LS) */
uae_u32 REGPARAM2 op_53e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	int val = cctrue(3) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (LS) */
uae_u32 REGPARAM2 op_53f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	int val = cctrue(3) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* Scc.B (xxx).W (LS) */
uae_u32 REGPARAM2 op_53f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	int val = cctrue(3) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (xxx).L (LS) */
uae_u32 REGPARAM2 op_53f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	int val = cctrue(3) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (LS) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_53fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 8;  
	uae_s16 dummy = get_iword_mmu060(2);
	m68k_incpci(4);
	if (cctrue(3)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (LS) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_53fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 12; 
	uae_s32 dummy;
	dummy = get_ilong_mmu060(2);
	m68k_incpci(6);
	if (cctrue(3)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (LS) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_53fc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (cctrue(3)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (CC) */
uae_u32 REGPARAM2 op_54c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 4;  
	int val = cctrue(4) ? 0xff : 0x00;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (CC) */
uae_u32 REGPARAM2 op_54c8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	CurrentInstrCycles = 14; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_iword_mmu060(2);
	uaecptr oldpc = m68k_getpci();
	if (offs & 1) {
		exception3_read_prefetch(opcode, oldpc + (uae_s32)offs + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (!cctrue(4)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if(regs.t0) check_t0_trace();
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci(oldpc + 4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* Scc.B (An) (CC) */
uae_u32 REGPARAM2 op_54d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	int val = cctrue(4) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (An)+ (CC) */
uae_u32 REGPARAM2 op_54d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	int val = cctrue(4) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B -(An) (CC) */
uae_u32 REGPARAM2 op_54e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	int val = cctrue(4) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (d16,An) (CC) */
uae_u32 REGPARAM2 op_54e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	int val = cctrue(4) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (CC) */
uae_u32 REGPARAM2 op_54f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	int val = cctrue(4) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* Scc.B (xxx).W (CC) */
uae_u32 REGPARAM2 op_54f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	int val = cctrue(4) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (xxx).L (CC) */
uae_u32 REGPARAM2 op_54f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	int val = cctrue(4) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (CC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_54fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 8;  
	uae_s16 dummy = get_iword_mmu060(2);
	m68k_incpci(4);
	if (cctrue(4)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (CC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_54fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 12; 
	uae_s32 dummy;
	dummy = get_ilong_mmu060(2);
	m68k_incpci(6);
	if (cctrue(4)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (CC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_54fc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (cctrue(4)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (CS) */
uae_u32 REGPARAM2 op_55c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 4;  
	int val = cctrue(5) ? 0xff : 0x00;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (CS) */
uae_u32 REGPARAM2 op_55c8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	CurrentInstrCycles = 14; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_iword_mmu060(2);
	uaecptr oldpc = m68k_getpci();
	if (offs & 1) {
		exception3_read_prefetch(opcode, oldpc + (uae_s32)offs + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (!cctrue(5)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if(regs.t0) check_t0_trace();
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci(oldpc + 4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* Scc.B (An) (CS) */
uae_u32 REGPARAM2 op_55d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	int val = cctrue(5) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (An)+ (CS) */
uae_u32 REGPARAM2 op_55d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	int val = cctrue(5) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B -(An) (CS) */
uae_u32 REGPARAM2 op_55e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	int val = cctrue(5) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (d16,An) (CS) */
uae_u32 REGPARAM2 op_55e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	int val = cctrue(5) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (CS) */
uae_u32 REGPARAM2 op_55f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	int val = cctrue(5) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* Scc.B (xxx).W (CS) */
uae_u32 REGPARAM2 op_55f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	int val = cctrue(5) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (xxx).L (CS) */
uae_u32 REGPARAM2 op_55f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	int val = cctrue(5) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (CS) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_55fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 8;  
	uae_s16 dummy = get_iword_mmu060(2);
	m68k_incpci(4);
	if (cctrue(5)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (CS) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_55fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 12; 
	uae_s32 dummy;
	dummy = get_ilong_mmu060(2);
	m68k_incpci(6);
	if (cctrue(5)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (CS) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_55fc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (cctrue(5)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (NE) */
uae_u32 REGPARAM2 op_56c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 4;  
	int val = cctrue(6) ? 0xff : 0x00;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (NE) */
uae_u32 REGPARAM2 op_56c8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	CurrentInstrCycles = 14; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_iword_mmu060(2);
	uaecptr oldpc = m68k_getpci();
	if (offs & 1) {
		exception3_read_prefetch(opcode, oldpc + (uae_s32)offs + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (!cctrue(6)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if(regs.t0) check_t0_trace();
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci(oldpc + 4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* Scc.B (An) (NE) */
uae_u32 REGPARAM2 op_56d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	int val = cctrue(6) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (An)+ (NE) */
uae_u32 REGPARAM2 op_56d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	int val = cctrue(6) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B -(An) (NE) */
uae_u32 REGPARAM2 op_56e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	int val = cctrue(6) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (d16,An) (NE) */
uae_u32 REGPARAM2 op_56e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	int val = cctrue(6) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (NE) */
uae_u32 REGPARAM2 op_56f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	int val = cctrue(6) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* Scc.B (xxx).W (NE) */
uae_u32 REGPARAM2 op_56f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	int val = cctrue(6) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (xxx).L (NE) */
uae_u32 REGPARAM2 op_56f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	int val = cctrue(6) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (NE) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_56fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 8;  
	uae_s16 dummy = get_iword_mmu060(2);
	m68k_incpci(4);
	if (cctrue(6)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (NE) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_56fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 12; 
	uae_s32 dummy;
	dummy = get_ilong_mmu060(2);
	m68k_incpci(6);
	if (cctrue(6)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (NE) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_56fc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (cctrue(6)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (EQ) */
uae_u32 REGPARAM2 op_57c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 4;  
	int val = cctrue(7) ? 0xff : 0x00;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (EQ) */
uae_u32 REGPARAM2 op_57c8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	CurrentInstrCycles = 14; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_iword_mmu060(2);
	uaecptr oldpc = m68k_getpci();
	if (offs & 1) {
		exception3_read_prefetch(opcode, oldpc + (uae_s32)offs + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (!cctrue(7)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if(regs.t0) check_t0_trace();
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci(oldpc + 4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* Scc.B (An) (EQ) */
uae_u32 REGPARAM2 op_57d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	int val = cctrue(7) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (An)+ (EQ) */
uae_u32 REGPARAM2 op_57d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	int val = cctrue(7) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B -(An) (EQ) */
uae_u32 REGPARAM2 op_57e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	int val = cctrue(7) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (d16,An) (EQ) */
uae_u32 REGPARAM2 op_57e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	int val = cctrue(7) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (EQ) */
uae_u32 REGPARAM2 op_57f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	int val = cctrue(7) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* Scc.B (xxx).W (EQ) */
uae_u32 REGPARAM2 op_57f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	int val = cctrue(7) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (xxx).L (EQ) */
uae_u32 REGPARAM2 op_57f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	int val = cctrue(7) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (EQ) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_57fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 8;  
	uae_s16 dummy = get_iword_mmu060(2);
	m68k_incpci(4);
	if (cctrue(7)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (EQ) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_57fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 12; 
	uae_s32 dummy;
	dummy = get_ilong_mmu060(2);
	m68k_incpci(6);
	if (cctrue(7)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (EQ) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_57fc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (cctrue(7)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (VC) */
uae_u32 REGPARAM2 op_58c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 4;  
	int val = cctrue(8) ? 0xff : 0x00;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (VC) */
uae_u32 REGPARAM2 op_58c8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	CurrentInstrCycles = 14; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_iword_mmu060(2);
	uaecptr oldpc = m68k_getpci();
	if (offs & 1) {
		exception3_read_prefetch(opcode, oldpc + (uae_s32)offs + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (!cctrue(8)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if(regs.t0) check_t0_trace();
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci(oldpc + 4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* Scc.B (An) (VC) */
uae_u32 REGPARAM2 op_58d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	int val = cctrue(8) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (An)+ (VC) */
uae_u32 REGPARAM2 op_58d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	int val = cctrue(8) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B -(An) (VC) */
uae_u32 REGPARAM2 op_58e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	int val = cctrue(8) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (d16,An) (VC) */
uae_u32 REGPARAM2 op_58e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	int val = cctrue(8) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (VC) */
uae_u32 REGPARAM2 op_58f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	int val = cctrue(8) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* Scc.B (xxx).W (VC) */
uae_u32 REGPARAM2 op_58f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	int val = cctrue(8) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (xxx).L (VC) */
uae_u32 REGPARAM2 op_58f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	int val = cctrue(8) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (VC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_58fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 8;  
	uae_s16 dummy = get_iword_mmu060(2);
	m68k_incpci(4);
	if (cctrue(8)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (VC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_58fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 12; 
	uae_s32 dummy;
	dummy = get_ilong_mmu060(2);
	m68k_incpci(6);
	if (cctrue(8)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (VC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_58fc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (cctrue(8)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (VS) */
uae_u32 REGPARAM2 op_59c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 4;  
	int val = cctrue(9) ? 0xff : 0x00;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (VS) */
uae_u32 REGPARAM2 op_59c8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	CurrentInstrCycles = 14; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_iword_mmu060(2);
	uaecptr oldpc = m68k_getpci();
	if (offs & 1) {
		exception3_read_prefetch(opcode, oldpc + (uae_s32)offs + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (!cctrue(9)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if(regs.t0) check_t0_trace();
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci(oldpc + 4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* Scc.B (An) (VS) */
uae_u32 REGPARAM2 op_59d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	int val = cctrue(9) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (An)+ (VS) */
uae_u32 REGPARAM2 op_59d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	int val = cctrue(9) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B -(An) (VS) */
uae_u32 REGPARAM2 op_59e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	int val = cctrue(9) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (d16,An) (VS) */
uae_u32 REGPARAM2 op_59e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	int val = cctrue(9) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (VS) */
uae_u32 REGPARAM2 op_59f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	int val = cctrue(9) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* Scc.B (xxx).W (VS) */
uae_u32 REGPARAM2 op_59f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	int val = cctrue(9) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (xxx).L (VS) */
uae_u32 REGPARAM2 op_59f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	int val = cctrue(9) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (VS) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_59fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 8;  
	uae_s16 dummy = get_iword_mmu060(2);
	m68k_incpci(4);
	if (cctrue(9)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (VS) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_59fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 12; 
	uae_s32 dummy;
	dummy = get_ilong_mmu060(2);
	m68k_incpci(6);
	if (cctrue(9)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (VS) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_59fc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (cctrue(9)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (PL) */
uae_u32 REGPARAM2 op_5ac0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 4;  
	int val = cctrue(10) ? 0xff : 0x00;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (PL) */
uae_u32 REGPARAM2 op_5ac8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	CurrentInstrCycles = 14; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_iword_mmu060(2);
	uaecptr oldpc = m68k_getpci();
	if (offs & 1) {
		exception3_read_prefetch(opcode, oldpc + (uae_s32)offs + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (!cctrue(10)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if(regs.t0) check_t0_trace();
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci(oldpc + 4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* Scc.B (An) (PL) */
uae_u32 REGPARAM2 op_5ad0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	int val = cctrue(10) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (An)+ (PL) */
uae_u32 REGPARAM2 op_5ad8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	int val = cctrue(10) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B -(An) (PL) */
uae_u32 REGPARAM2 op_5ae0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	int val = cctrue(10) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (d16,An) (PL) */
uae_u32 REGPARAM2 op_5ae8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	int val = cctrue(10) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (PL) */
uae_u32 REGPARAM2 op_5af0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	int val = cctrue(10) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* Scc.B (xxx).W (PL) */
uae_u32 REGPARAM2 op_5af8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	int val = cctrue(10) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (xxx).L (PL) */
uae_u32 REGPARAM2 op_5af9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	int val = cctrue(10) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (PL) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5afa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 8;  
	uae_s16 dummy = get_iword_mmu060(2);
	m68k_incpci(4);
	if (cctrue(10)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (PL) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5afb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 12; 
	uae_s32 dummy;
	dummy = get_ilong_mmu060(2);
	m68k_incpci(6);
	if (cctrue(10)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (PL) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5afc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (cctrue(10)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (MI) */
uae_u32 REGPARAM2 op_5bc0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 4;  
	int val = cctrue(11) ? 0xff : 0x00;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (MI) */
uae_u32 REGPARAM2 op_5bc8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	CurrentInstrCycles = 14; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_iword_mmu060(2);
	uaecptr oldpc = m68k_getpci();
	if (offs & 1) {
		exception3_read_prefetch(opcode, oldpc + (uae_s32)offs + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (!cctrue(11)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if(regs.t0) check_t0_trace();
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci(oldpc + 4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* Scc.B (An) (MI) */
uae_u32 REGPARAM2 op_5bd0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	int val = cctrue(11) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (An)+ (MI) */
uae_u32 REGPARAM2 op_5bd8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	int val = cctrue(11) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B -(An) (MI) */
uae_u32 REGPARAM2 op_5be0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	int val = cctrue(11) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (d16,An) (MI) */
uae_u32 REGPARAM2 op_5be8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	int val = cctrue(11) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (MI) */
uae_u32 REGPARAM2 op_5bf0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	int val = cctrue(11) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* Scc.B (xxx).W (MI) */
uae_u32 REGPARAM2 op_5bf8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	int val = cctrue(11) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (xxx).L (MI) */
uae_u32 REGPARAM2 op_5bf9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	int val = cctrue(11) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (MI) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5bfa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 8;  
	uae_s16 dummy = get_iword_mmu060(2);
	m68k_incpci(4);
	if (cctrue(11)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (MI) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5bfb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 12; 
	uae_s32 dummy;
	dummy = get_ilong_mmu060(2);
	m68k_incpci(6);
	if (cctrue(11)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (MI) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5bfc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (cctrue(11)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (GE) */
uae_u32 REGPARAM2 op_5cc0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 4;  
	int val = cctrue(12) ? 0xff : 0x00;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (GE) */
uae_u32 REGPARAM2 op_5cc8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	CurrentInstrCycles = 14; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_iword_mmu060(2);
	uaecptr oldpc = m68k_getpci();
	if (offs & 1) {
		exception3_read_prefetch(opcode, oldpc + (uae_s32)offs + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (!cctrue(12)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if(regs.t0) check_t0_trace();
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci(oldpc + 4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* Scc.B (An) (GE) */
uae_u32 REGPARAM2 op_5cd0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	int val = cctrue(12) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (An)+ (GE) */
uae_u32 REGPARAM2 op_5cd8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	int val = cctrue(12) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B -(An) (GE) */
uae_u32 REGPARAM2 op_5ce0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	int val = cctrue(12) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (d16,An) (GE) */
uae_u32 REGPARAM2 op_5ce8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	int val = cctrue(12) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (GE) */
uae_u32 REGPARAM2 op_5cf0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	int val = cctrue(12) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* Scc.B (xxx).W (GE) */
uae_u32 REGPARAM2 op_5cf8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	int val = cctrue(12) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (xxx).L (GE) */
uae_u32 REGPARAM2 op_5cf9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	int val = cctrue(12) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (GE) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5cfa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 8;  
	uae_s16 dummy = get_iword_mmu060(2);
	m68k_incpci(4);
	if (cctrue(12)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (GE) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5cfb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 12; 
	uae_s32 dummy;
	dummy = get_ilong_mmu060(2);
	m68k_incpci(6);
	if (cctrue(12)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (GE) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5cfc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (cctrue(12)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (LT) */
uae_u32 REGPARAM2 op_5dc0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 4;  
	int val = cctrue(13) ? 0xff : 0x00;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (LT) */
uae_u32 REGPARAM2 op_5dc8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	CurrentInstrCycles = 14; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_iword_mmu060(2);
	uaecptr oldpc = m68k_getpci();
	if (offs & 1) {
		exception3_read_prefetch(opcode, oldpc + (uae_s32)offs + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (!cctrue(13)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if(regs.t0) check_t0_trace();
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci(oldpc + 4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* Scc.B (An) (LT) */
uae_u32 REGPARAM2 op_5dd0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	int val = cctrue(13) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (An)+ (LT) */
uae_u32 REGPARAM2 op_5dd8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	int val = cctrue(13) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B -(An) (LT) */
uae_u32 REGPARAM2 op_5de0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	int val = cctrue(13) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (d16,An) (LT) */
uae_u32 REGPARAM2 op_5de8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	int val = cctrue(13) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (LT) */
uae_u32 REGPARAM2 op_5df0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	int val = cctrue(13) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* Scc.B (xxx).W (LT) */
uae_u32 REGPARAM2 op_5df8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	int val = cctrue(13) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (xxx).L (LT) */
uae_u32 REGPARAM2 op_5df9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	int val = cctrue(13) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (LT) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5dfa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 8;  
	uae_s16 dummy = get_iword_mmu060(2);
	m68k_incpci(4);
	if (cctrue(13)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (LT) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5dfb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 12; 
	uae_s32 dummy;
	dummy = get_ilong_mmu060(2);
	m68k_incpci(6);
	if (cctrue(13)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (LT) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5dfc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (cctrue(13)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (GT) */
uae_u32 REGPARAM2 op_5ec0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 4;  
	int val = cctrue(14) ? 0xff : 0x00;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (GT) */
uae_u32 REGPARAM2 op_5ec8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	CurrentInstrCycles = 14; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_iword_mmu060(2);
	uaecptr oldpc = m68k_getpci();
	if (offs & 1) {
		exception3_read_prefetch(opcode, oldpc + (uae_s32)offs + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (!cctrue(14)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if(regs.t0) check_t0_trace();
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci(oldpc + 4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* Scc.B (An) (GT) */
uae_u32 REGPARAM2 op_5ed0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	int val = cctrue(14) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (An)+ (GT) */
uae_u32 REGPARAM2 op_5ed8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	int val = cctrue(14) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B -(An) (GT) */
uae_u32 REGPARAM2 op_5ee0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	int val = cctrue(14) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (d16,An) (GT) */
uae_u32 REGPARAM2 op_5ee8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	int val = cctrue(14) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (GT) */
uae_u32 REGPARAM2 op_5ef0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	int val = cctrue(14) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* Scc.B (xxx).W (GT) */
uae_u32 REGPARAM2 op_5ef8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	int val = cctrue(14) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (xxx).L (GT) */
uae_u32 REGPARAM2 op_5ef9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	int val = cctrue(14) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (GT) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5efa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 8;  
	uae_s16 dummy = get_iword_mmu060(2);
	m68k_incpci(4);
	if (cctrue(14)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (GT) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5efb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 12; 
	uae_s32 dummy;
	dummy = get_ilong_mmu060(2);
	m68k_incpci(6);
	if (cctrue(14)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (GT) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5efc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (cctrue(14)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (LE) */
uae_u32 REGPARAM2 op_5fc0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 4;  
	int val = cctrue(15) ? 0xff : 0x00;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (LE) */
uae_u32 REGPARAM2 op_5fc8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	CurrentInstrCycles = 14; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_iword_mmu060(2);
	uaecptr oldpc = m68k_getpci();
	if (offs & 1) {
		exception3_read_prefetch(opcode, oldpc + (uae_s32)offs + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (!cctrue(15)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if(regs.t0) check_t0_trace();
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci(oldpc + 4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* Scc.B (An) (LE) */
uae_u32 REGPARAM2 op_5fd0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	int val = cctrue(15) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (An)+ (LE) */
uae_u32 REGPARAM2 op_5fd8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	int val = cctrue(15) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B -(An) (LE) */
uae_u32 REGPARAM2 op_5fe0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	int val = cctrue(15) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (d16,An) (LE) */
uae_u32 REGPARAM2 op_5fe8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	int val = cctrue(15) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (LE) */
uae_u32 REGPARAM2 op_5ff0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	int val = cctrue(15) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* Scc.B (xxx).W (LE) */
uae_u32 REGPARAM2 op_5ff8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	int val = cctrue(15) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (xxx).L (LE) */
uae_u32 REGPARAM2 op_5ff9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	int val = cctrue(15) ? 0xff : 0x00;
	put_byte_mmu060(srca, val);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (LE) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5ffa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 8;  
	uae_s16 dummy = get_iword_mmu060(2);
	m68k_incpci(4);
	if (cctrue(15)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (LE) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5ffb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 12; 
	uae_s32 dummy;
	dummy = get_ilong_mmu060(2);
	m68k_incpci(6);
	if (cctrue(15)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (LE) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5ffc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (cctrue(15)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* Bcc.W #<data>.W (T) */
uae_u32 REGPARAM2 op_6000_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 16; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_iword_mmu060(2);
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(0)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* BccQ.B #<data> (T) */
uae_u32 REGPARAM2 op_6001_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	CurrentInstrCycles = 8;  
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(0)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (T) */
uae_u32 REGPARAM2 op_60ff_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 20; 
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_ilong_mmu060(2);
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(0)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* BSR.W #<data>.W */
uae_u32 REGPARAM2 op_6100_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 54;
	CurrentInstrCycles = 18; 
	uae_s32 s;
	uae_s16 src = get_iword_mmu060(2);
	s = (uae_s32)src + 2;
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 4;
	if (s & 1) {
		exception3_read_prefetch(opcode, oldpc + s);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_do_bsr_mmu060(nextpc, s);
	#ifdef DEBUGGER
	if (debugmem_trace) {
		branch_stack_push(oldpc, nextpc);
	}
	#endif
	if(regs.t0) check_t0_trace();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* BSRQ.B #<data> */
uae_u32 REGPARAM2 op_6101_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 54;
	CurrentInstrCycles = 18; 
	uae_s32 s;
	uae_u32 src = srcreg;
	s = (uae_s32)src + 2;
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 2;
	if (s & 1) {
		exception3_read_prefetch(opcode, oldpc + s);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_do_bsr_mmu060(nextpc, s);
	#ifdef DEBUGGER
	if (debugmem_trace) {
		branch_stack_push(oldpc, nextpc);
	}
	#endif
	if(regs.t0) check_t0_trace();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* BSR.L #<data>.L */
uae_u32 REGPARAM2 op_61ff_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 54;
	CurrentInstrCycles = 22; 
	uae_s32 s;
	uae_s32 src;
	src = get_ilong_mmu060(2);
	s = (uae_s32)src + 2;
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 6;
	if (s & 1) {
		exception3_read_prefetch(opcode, oldpc + s);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_do_bsr_mmu060(nextpc, s);
	#ifdef DEBUGGER
	if (debugmem_trace) {
		branch_stack_push(oldpc, nextpc);
	}
	#endif
	if(regs.t0) check_t0_trace();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (HI) */
uae_u32 REGPARAM2 op_6200_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 16; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_iword_mmu060(2);
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(2)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* BccQ.B #<data> (HI) */
uae_u32 REGPARAM2 op_6201_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	CurrentInstrCycles = 8;  
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(2)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (HI) */
uae_u32 REGPARAM2 op_62ff_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 20; 
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_ilong_mmu060(2);
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(2)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (LS) */
uae_u32 REGPARAM2 op_6300_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 16; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_iword_mmu060(2);
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(3)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* BccQ.B #<data> (LS) */
uae_u32 REGPARAM2 op_6301_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	CurrentInstrCycles = 8;  
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(3)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (LS) */
uae_u32 REGPARAM2 op_63ff_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 20; 
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_ilong_mmu060(2);
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(3)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (CC) */
uae_u32 REGPARAM2 op_6400_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 16; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_iword_mmu060(2);
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(4)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* BccQ.B #<data> (CC) */
uae_u32 REGPARAM2 op_6401_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	CurrentInstrCycles = 8;  
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(4)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (CC) */
uae_u32 REGPARAM2 op_64ff_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 20; 
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_ilong_mmu060(2);
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(4)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (CS) */
uae_u32 REGPARAM2 op_6500_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 16; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_iword_mmu060(2);
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(5)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* BccQ.B #<data> (CS) */
uae_u32 REGPARAM2 op_6501_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	CurrentInstrCycles = 8;  
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(5)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (CS) */
uae_u32 REGPARAM2 op_65ff_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 20; 
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_ilong_mmu060(2);
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(5)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (NE) */
uae_u32 REGPARAM2 op_6600_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 16; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_iword_mmu060(2);
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(6)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* BccQ.B #<data> (NE) */
uae_u32 REGPARAM2 op_6601_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	CurrentInstrCycles = 8;  
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(6)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (NE) */
uae_u32 REGPARAM2 op_66ff_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 20; 
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_ilong_mmu060(2);
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(6)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (EQ) */
uae_u32 REGPARAM2 op_6700_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 16; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_iword_mmu060(2);
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(7)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* BccQ.B #<data> (EQ) */
uae_u32 REGPARAM2 op_6701_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	CurrentInstrCycles = 8;  
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(7)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (EQ) */
uae_u32 REGPARAM2 op_67ff_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 20; 
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_ilong_mmu060(2);
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(7)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (VC) */
uae_u32 REGPARAM2 op_6800_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 16; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_iword_mmu060(2);
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(8)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* BccQ.B #<data> (VC) */
uae_u32 REGPARAM2 op_6801_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	CurrentInstrCycles = 8;  
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(8)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (VC) */
uae_u32 REGPARAM2 op_68ff_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 20; 
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_ilong_mmu060(2);
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(8)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (VS) */
uae_u32 REGPARAM2 op_6900_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 16; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_iword_mmu060(2);
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(9)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* BccQ.B #<data> (VS) */
uae_u32 REGPARAM2 op_6901_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	CurrentInstrCycles = 8;  
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(9)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (VS) */
uae_u32 REGPARAM2 op_69ff_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 20; 
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_ilong_mmu060(2);
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(9)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (PL) */
uae_u32 REGPARAM2 op_6a00_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 16; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_iword_mmu060(2);
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(10)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* BccQ.B #<data> (PL) */
uae_u32 REGPARAM2 op_6a01_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	CurrentInstrCycles = 8;  
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(10)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (PL) */
uae_u32 REGPARAM2 op_6aff_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 20; 
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_ilong_mmu060(2);
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(10)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (MI) */
uae_u32 REGPARAM2 op_6b00_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 16; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_iword_mmu060(2);
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(11)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* BccQ.B #<data> (MI) */
uae_u32 REGPARAM2 op_6b01_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	CurrentInstrCycles = 8;  
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(11)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (MI) */
uae_u32 REGPARAM2 op_6bff_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 20; 
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_ilong_mmu060(2);
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(11)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (GE) */
uae_u32 REGPARAM2 op_6c00_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 16; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_iword_mmu060(2);
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(12)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* BccQ.B #<data> (GE) */
uae_u32 REGPARAM2 op_6c01_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	CurrentInstrCycles = 8;  
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(12)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (GE) */
uae_u32 REGPARAM2 op_6cff_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 20; 
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_ilong_mmu060(2);
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(12)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (LT) */
uae_u32 REGPARAM2 op_6d00_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 16; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_iword_mmu060(2);
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(13)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* BccQ.B #<data> (LT) */
uae_u32 REGPARAM2 op_6d01_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	CurrentInstrCycles = 8;  
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(13)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (LT) */
uae_u32 REGPARAM2 op_6dff_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 20; 
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_ilong_mmu060(2);
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(13)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (GT) */
uae_u32 REGPARAM2 op_6e00_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 16; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_iword_mmu060(2);
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(14)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* BccQ.B #<data> (GT) */
uae_u32 REGPARAM2 op_6e01_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	CurrentInstrCycles = 8;  
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(14)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (GT) */
uae_u32 REGPARAM2 op_6eff_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 20; 
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_ilong_mmu060(2);
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(14)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (LE) */
uae_u32 REGPARAM2 op_6f00_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 16; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_iword_mmu060(2);
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(15)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* BccQ.B #<data> (LE) */
uae_u32 REGPARAM2 op_6f01_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	CurrentInstrCycles = 8;  
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(15)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (LE) */
uae_u32 REGPARAM2 op_6fff_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 20; 
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_ilong_mmu060(2);
	if (src & 1) {
		exception3_read_prefetch(opcode, m68k_getpci() + (uae_s32)src + 2);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (cctrue(15)) {
		m68k_incpci((uae_s32)src + 2);
		if(regs.t0) check_t0_trace();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* MOVEQ.L #<data>,Dn */
uae_u32 REGPARAM2 op_7000_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 4;  
	uae_u32 src = srcreg;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.B Dn,Dn */
uae_u32 REGPARAM2 op_8000_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.B (An),Dn */
uae_u32 REGPARAM2 op_8010_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.B (An)+,Dn */
uae_u32 REGPARAM2 op_8018_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.B -(An),Dn */
uae_u32 REGPARAM2 op_8020_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.B (d16,An),Dn */
uae_u32 REGPARAM2 op_8028_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.B (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_8030_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_byte_mmu060(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* OR.B (xxx).W,Dn */
uae_u32 REGPARAM2 op_8038_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.B (xxx).L,Dn */
uae_u32 REGPARAM2 op_8039_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* OR.B (d16,PC),Dn */
uae_u32 REGPARAM2 op_803a_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.B (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_803b_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s8 src = get_byte_mmu060(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* OR.B #<data>.B,Dn */
uae_u32 REGPARAM2 op_803c_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 8;  
	uae_s8 src = get_ibyte_mmu060(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.W Dn,Dn */
uae_u32 REGPARAM2 op_8040_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.W (An),Dn */
uae_u32 REGPARAM2 op_8050_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.W (An)+,Dn */
uae_u32 REGPARAM2 op_8058_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.W -(An),Dn */
uae_u32 REGPARAM2 op_8060_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.W (d16,An),Dn */
uae_u32 REGPARAM2 op_8068_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.W (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_8070_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* OR.W (xxx).W,Dn */
uae_u32 REGPARAM2 op_8078_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.W (xxx).L,Dn */
uae_u32 REGPARAM2 op_8079_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* OR.W (d16,PC),Dn */
uae_u32 REGPARAM2 op_807a_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.W (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_807b_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* OR.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_807c_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_iword_mmu060(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.L Dn,Dn */
uae_u32 REGPARAM2 op_8080_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 6;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.L (An),Dn */
uae_u32 REGPARAM2 op_8090_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.L (An)+,Dn */
uae_u32 REGPARAM2 op_8098_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) += 4;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.L -(An),Dn */
uae_u32 REGPARAM2 op_80a0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.L (d16,An),Dn */
uae_u32 REGPARAM2 op_80a8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.L (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_80b0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* OR.L (xxx).W,Dn */
uae_u32 REGPARAM2 op_80b8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.L (xxx).L,Dn */
uae_u32 REGPARAM2 op_80b9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* OR.L (d16,PC),Dn */
uae_u32 REGPARAM2 op_80ba_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.L (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_80bb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* OR.L #<data>.L,Dn */
uae_u32 REGPARAM2 op_80bc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 14; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* DIVU.W Dn,Dn */
uae_u32 REGPARAM2 op_80c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(2);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DIVU.W (An),Dn */
uae_u32 REGPARAM2 op_80d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(2);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DIVU.W (An)+,Dn */
uae_u32 REGPARAM2 op_80d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(2);
		Exception_cpu(5);
		mmufixup[0].reg = -1;
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DIVU.W -(An),Dn */
uae_u32 REGPARAM2 op_80e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(2);
		Exception_cpu(5);
		mmufixup[0].reg = -1;
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DIVU.W (d16,An),Dn */
uae_u32 REGPARAM2 op_80e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(4);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* DIVU.W (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_80f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(0);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* DIVU.W (xxx).W,Dn */
uae_u32 REGPARAM2 op_80f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(4);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* DIVU.W (xxx).L,Dn */
uae_u32 REGPARAM2 op_80f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(6);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* DIVU.W (d16,PC),Dn */
uae_u32 REGPARAM2 op_80fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(4);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* DIVU.W (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_80fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = get_word_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(0);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* DIVU.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_80fc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_iword_mmu060(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(4);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SBCD.B Dn,Dn */
uae_u32 REGPARAM2 op_8100_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 10;
	CurrentInstrCycles = 6;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u16 newv_lo = (dst & 0xF) - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = (dst & 0xF0) - (src & 0xF0);
	uae_u16 newv, tmp_newv;
	int bcd = 0;
	newv = tmp_newv = newv_hi + newv_lo;
if (newv_lo & 0xF0) { newv -= 6; bcd = 6; };
if ((((dst & 0xFF) - (src & 0xFF) - (GET_XFLG() ? 1 : 0)) & 0x100) > 0xFF) { newv -= 0x60; }
	SET_CFLG((((dst & 0xFF) - (src & 0xFF) - bcd - (GET_XFLG() ? 1 : 0)) & 0x300) > 0xFF);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SBCD.B -(An),-(An) */
uae_u32 REGPARAM2 op_8108_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 10;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[1].reg = dstreg | 0x0;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u16 newv_lo = (dst & 0xF) - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = (dst & 0xF0) - (src & 0xF0);
	uae_u16 newv, tmp_newv;
	int bcd = 0;
	newv = tmp_newv = newv_hi + newv_lo;
if (newv_lo & 0xF0) { newv -= 6; bcd = 6; };
if ((((dst & 0xFF) - (src & 0xFF) - (GET_XFLG() ? 1 : 0)) & 0x100) > 0xFF) { newv -= 0x60; }
	SET_CFLG((((dst & 0xFF) - (src & 0xFF) - bcd - (GET_XFLG() ? 1 : 0)) & 0x300) > 0xFF);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.B Dn,(An) */
uae_u32 REGPARAM2 op_8110_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.B Dn,(An)+ */
uae_u32 REGPARAM2 op_8118_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.B Dn,-(An) */
uae_u32 REGPARAM2 op_8120_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.B Dn,(d16,An) */
uae_u32 REGPARAM2 op_8128_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_8130_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* OR.B Dn,(xxx).W */
uae_u32 REGPARAM2 op_8138_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.B Dn,(xxx).L */
uae_u32 REGPARAM2 op_8139_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 1;
	CurrentInstrCycles = 20; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* PACK.L Dn,Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_8140_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 96;
	CurrentInstrCycles = 4;  
	uae_u16 val = m68k_dreg(regs, srcreg) + get_iword_mmu060(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & 0xffffff00) | ((val >> 4) & 0xf0) | (val & 0xf);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* PACK.L -(An),-(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_8148_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 96;
	CurrentInstrCycles = 4;  
	uae_u16 val;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) -= 2;
	val = (uae_u16)(get_word_mmu060(m68k_areg(regs, srcreg)));
	val += get_iword_mmu060(2);
	mmufixup[1].reg = dstreg | 0x0;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) -= areg_byteinc[dstreg];
	put_byte_mmu060(m68k_areg(regs, dstreg),((val >> 4) & 0xf0) | (val & 0xf));
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* OR.W Dn,(An) */
uae_u32 REGPARAM2 op_8150_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.W Dn,(An)+ */
uae_u32 REGPARAM2 op_8158_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	m68k_areg(regs, dstreg) += 2;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.W Dn,-(An) */
uae_u32 REGPARAM2 op_8160_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 14; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.W Dn,(d16,An) */
uae_u32 REGPARAM2 op_8168_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.W Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_8170_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* OR.W Dn,(xxx).W */
uae_u32 REGPARAM2 op_8178_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.W Dn,(xxx).L */
uae_u32 REGPARAM2 op_8179_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 1;
	CurrentInstrCycles = 20; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* UNPK.L Dn,Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_8180_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 97;
	CurrentInstrCycles = 4;  
	uae_u16 val = m68k_dreg(regs, srcreg);
	val = ((val << 4) & 0xf00) | (val & 0xf);
	val += get_iword_mmu060(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & 0xffff0000) | (val & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* UNPK.L -(An),-(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_8188_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 97;
	CurrentInstrCycles = 4;  
	uae_u16 val;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) -= areg_byteinc[srcreg];
	val = (uae_u16)(get_byte_mmu060(m68k_areg(regs, srcreg)) & 0xff);
	val = (((val << 4) & 0xf00) | (val & 0xf)) + get_iword_mmu060(2);
	mmufixup[1].reg = dstreg | 0x0;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) -= 2;
	put_word_mmu060(m68k_areg(regs, dstreg), val);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* OR.L Dn,(An) */
uae_u32 REGPARAM2 op_8190_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 20; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.L Dn,(An)+ */
uae_u32 REGPARAM2 op_8198_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 20; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	m68k_areg(regs, dstreg) += 4;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.L Dn,-(An) */
uae_u32 REGPARAM2 op_81a0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 22; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.L Dn,(d16,An) */
uae_u32 REGPARAM2 op_81a8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 24; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.L Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_81b0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 24; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* OR.L Dn,(xxx).W */
uae_u32 REGPARAM2 op_81b8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 1;
	CurrentInstrCycles = 24; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.L Dn,(xxx).L */
uae_u32 REGPARAM2 op_81b9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 1;
	CurrentInstrCycles = 28; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* DIVS.W Dn,Dn */
uae_u32 REGPARAM2 op_81c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(2);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DIVS.W (An),Dn */
uae_u32 REGPARAM2 op_81d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(2);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DIVS.W (An)+,Dn */
uae_u32 REGPARAM2 op_81d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(2);
		Exception_cpu(5);
		mmufixup[0].reg = -1;
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DIVS.W -(An),Dn */
uae_u32 REGPARAM2 op_81e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(2);
		Exception_cpu(5);
		mmufixup[0].reg = -1;
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DIVS.W (d16,An),Dn */
uae_u32 REGPARAM2 op_81e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(4);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* DIVS.W (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_81f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(0);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* DIVS.W (xxx).W,Dn */
uae_u32 REGPARAM2 op_81f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(4);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* DIVS.W (xxx).L,Dn */
uae_u32 REGPARAM2 op_81f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(6);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* DIVS.W (d16,PC),Dn */
uae_u32 REGPARAM2 op_81fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(4);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* DIVS.W (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_81fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = get_word_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(0);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* DIVS.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_81fc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_iword_mmu060(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(4);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.B Dn,Dn */
uae_u32 REGPARAM2 op_9000_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.B (An),Dn */
uae_u32 REGPARAM2 op_9010_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.B (An)+,Dn */
uae_u32 REGPARAM2 op_9018_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.B -(An),Dn */
uae_u32 REGPARAM2 op_9020_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.B (d16,An),Dn */
uae_u32 REGPARAM2 op_9028_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.B (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_9030_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_byte_mmu060(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* SUB.B (xxx).W,Dn */
uae_u32 REGPARAM2 op_9038_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.B (xxx).L,Dn */
uae_u32 REGPARAM2 op_9039_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUB.B (d16,PC),Dn */
uae_u32 REGPARAM2 op_903a_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.B (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_903b_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s8 src = get_byte_mmu060(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* SUB.B #<data>.B,Dn */
uae_u32 REGPARAM2 op_903c_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 8;  
	uae_s8 src = get_ibyte_mmu060(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.W Dn,Dn */
uae_u32 REGPARAM2 op_9040_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.W An,Dn */
uae_u32 REGPARAM2 op_9048_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_areg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.W (An),Dn */
uae_u32 REGPARAM2 op_9050_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.W (An)+,Dn */
uae_u32 REGPARAM2 op_9058_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.W -(An),Dn */
uae_u32 REGPARAM2 op_9060_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.W (d16,An),Dn */
uae_u32 REGPARAM2 op_9068_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.W (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_9070_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* SUB.W (xxx).W,Dn */
uae_u32 REGPARAM2 op_9078_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.W (xxx).L,Dn */
uae_u32 REGPARAM2 op_9079_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUB.W (d16,PC),Dn */
uae_u32 REGPARAM2 op_907a_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.W (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_907b_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* SUB.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_907c_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_iword_mmu060(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.L Dn,Dn */
uae_u32 REGPARAM2 op_9080_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 6;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.L An,Dn */
uae_u32 REGPARAM2 op_9088_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 6;  
	uae_s32 src = m68k_areg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.L (An),Dn */
uae_u32 REGPARAM2 op_9090_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.L (An)+,Dn */
uae_u32 REGPARAM2 op_9098_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) += 4;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.L -(An),Dn */
uae_u32 REGPARAM2 op_90a0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.L (d16,An),Dn */
uae_u32 REGPARAM2 op_90a8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.L (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_90b0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* SUB.L (xxx).W,Dn */
uae_u32 REGPARAM2 op_90b8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.L (xxx).L,Dn */
uae_u32 REGPARAM2 op_90b9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUB.L (d16,PC),Dn */
uae_u32 REGPARAM2 op_90ba_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.L (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_90bb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* SUB.L #<data>.L,Dn */
uae_u32 REGPARAM2 op_90bc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 14; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUBA.W Dn,An */
uae_u32 REGPARAM2 op_90c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBA.W An,An */
uae_u32 REGPARAM2 op_90c8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_areg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBA.W (An),An */
uae_u32 REGPARAM2 op_90d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBA.W (An)+,An */
uae_u32 REGPARAM2 op_90d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBA.W -(An),An */
uae_u32 REGPARAM2 op_90e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBA.W (d16,An),An */
uae_u32 REGPARAM2 op_90e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUBA.W (d8,An,Xn),An */
uae_u32 REGPARAM2 op_90f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu060(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* SUBA.W (xxx).W,An */
uae_u32 REGPARAM2 op_90f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUBA.W (xxx).L,An */
uae_u32 REGPARAM2 op_90f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUBA.W (d16,PC),An */
uae_u32 REGPARAM2 op_90fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUBA.W (d8,PC,Xn),An */
uae_u32 REGPARAM2 op_90fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = get_word_mmu060(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* SUBA.W #<data>.W,An */
uae_u32 REGPARAM2 op_90fc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_iword_mmu060(2);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUBX.B Dn,Dn */
uae_u32 REGPARAM2 op_9100_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 9;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = dst - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBX.B -(An),-(An) */
uae_u32 REGPARAM2 op_9108_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 9;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[1].reg = dstreg | 0x0;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = dst - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.B Dn,(An) */
uae_u32 REGPARAM2 op_9110_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.B Dn,(An)+ */
uae_u32 REGPARAM2 op_9118_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.B Dn,-(An) */
uae_u32 REGPARAM2 op_9120_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.B Dn,(d16,An) */
uae_u32 REGPARAM2 op_9128_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_9130_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* SUB.B Dn,(xxx).W */
uae_u32 REGPARAM2 op_9138_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.B Dn,(xxx).L */
uae_u32 REGPARAM2 op_9139_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUBX.W Dn,Dn */
uae_u32 REGPARAM2 op_9140_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 9;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = dst - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBX.W -(An),-(An) */
uae_u32 REGPARAM2 op_9148_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 9;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[1].reg = dstreg | 0x0;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = dst - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	put_rmw_word_mmu060(dsta, newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.W Dn,(An) */
uae_u32 REGPARAM2 op_9150_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.W Dn,(An)+ */
uae_u32 REGPARAM2 op_9158_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	m68k_areg(regs, dstreg) += 2;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.W Dn,-(An) */
uae_u32 REGPARAM2 op_9160_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 14; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.W Dn,(d16,An) */
uae_u32 REGPARAM2 op_9168_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.W Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_9170_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* SUB.W Dn,(xxx).W */
uae_u32 REGPARAM2 op_9178_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.W Dn,(xxx).L */
uae_u32 REGPARAM2 op_9179_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_word_mmu060(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUBX.L Dn,Dn */
uae_u32 REGPARAM2 op_9180_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 9;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = dst - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBX.L -(An),-(An) */
uae_u32 REGPARAM2 op_9188_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 9;
	CurrentInstrCycles = 30; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[1].reg = dstreg | 0x0;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = dst - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	put_rmw_long_mmu060(dsta, newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.L Dn,(An) */
uae_u32 REGPARAM2 op_9190_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.L Dn,(An)+ */
uae_u32 REGPARAM2 op_9198_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	m68k_areg(regs, dstreg) += 4;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.L Dn,-(An) */
uae_u32 REGPARAM2 op_91a0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 22; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.L Dn,(d16,An) */
uae_u32 REGPARAM2 op_91a8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 24; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.L Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_91b0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 24; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* SUB.L Dn,(xxx).W */
uae_u32 REGPARAM2 op_91b8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 7;
	CurrentInstrCycles = 24; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.L Dn,(xxx).L */
uae_u32 REGPARAM2 op_91b9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 7;
	CurrentInstrCycles = 28; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	put_rmw_long_mmu060(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUBA.L Dn,An */
uae_u32 REGPARAM2 op_91c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 8;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBA.L An,An */
uae_u32 REGPARAM2 op_91c8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 8;  
	uae_s32 src = m68k_areg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBA.L (An),An */
uae_u32 REGPARAM2 op_91d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBA.L (An)+,An */
uae_u32 REGPARAM2 op_91d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) += 4;
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBA.L -(An),An */
uae_u32 REGPARAM2 op_91e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBA.L (d16,An),An */
uae_u32 REGPARAM2 op_91e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUBA.L (d8,An,Xn),An */
uae_u32 REGPARAM2 op_91f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* SUBA.L (xxx).W,An */
uae_u32 REGPARAM2 op_91f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUBA.L (xxx).L,An */
uae_u32 REGPARAM2 op_91f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUBA.L (d16,PC),An */
uae_u32 REGPARAM2 op_91fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUBA.L (d8,PC,Xn),An */
uae_u32 REGPARAM2 op_91fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* SUBA.L #<data>.L,An */
uae_u32 REGPARAM2 op_91fc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 16; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CMP.B Dn,Dn */
uae_u32 REGPARAM2 op_b000_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMP.B (An),Dn */
uae_u32 REGPARAM2 op_b010_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMP.B (An)+,Dn */
uae_u32 REGPARAM2 op_b018_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMP.B -(An),Dn */
uae_u32 REGPARAM2 op_b020_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMP.B (d16,An),Dn */
uae_u32 REGPARAM2 op_b028_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.B (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_b030_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_byte_mmu060(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* CMP.B (xxx).W,Dn */
uae_u32 REGPARAM2 op_b038_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.B (xxx).L,Dn */
uae_u32 REGPARAM2 op_b039_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CMP.B (d16,PC),Dn */
uae_u32 REGPARAM2 op_b03a_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.B (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_b03b_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s8 src = get_byte_mmu060(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* CMP.B #<data>.B,Dn */
uae_u32 REGPARAM2 op_b03c_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 8;  
	uae_s8 src = get_ibyte_mmu060(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.W Dn,Dn */
uae_u32 REGPARAM2 op_b040_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMP.W An,Dn */
uae_u32 REGPARAM2 op_b048_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_areg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMP.W (An),Dn */
uae_u32 REGPARAM2 op_b050_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMP.W (An)+,Dn */
uae_u32 REGPARAM2 op_b058_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMP.W -(An),Dn */
uae_u32 REGPARAM2 op_b060_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMP.W (d16,An),Dn */
uae_u32 REGPARAM2 op_b068_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.W (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_b070_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* CMP.W (xxx).W,Dn */
uae_u32 REGPARAM2 op_b078_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.W (xxx).L,Dn */
uae_u32 REGPARAM2 op_b079_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CMP.W (d16,PC),Dn */
uae_u32 REGPARAM2 op_b07a_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.W (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_b07b_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* CMP.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_b07c_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_iword_mmu060(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.L Dn,Dn */
uae_u32 REGPARAM2 op_b080_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 6;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMP.L An,Dn */
uae_u32 REGPARAM2 op_b088_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 6;  
	uae_s32 src = m68k_areg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMP.L (An),Dn */
uae_u32 REGPARAM2 op_b090_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMP.L (An)+,Dn */
uae_u32 REGPARAM2 op_b098_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) += 4;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMP.L -(An),Dn */
uae_u32 REGPARAM2 op_b0a0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMP.L (d16,An),Dn */
uae_u32 REGPARAM2 op_b0a8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.L (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_b0b0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* CMP.L (xxx).W,Dn */
uae_u32 REGPARAM2 op_b0b8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.L (xxx).L,Dn */
uae_u32 REGPARAM2 op_b0b9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CMP.L (d16,PC),Dn */
uae_u32 REGPARAM2 op_b0ba_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.L (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_b0bb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* CMP.L #<data>.L,Dn */
uae_u32 REGPARAM2 op_b0bc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 14; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CMPA.W Dn,An */
uae_u32 REGPARAM2 op_b0c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 6;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMPA.W An,An */
uae_u32 REGPARAM2 op_b0c8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 6;  
	uae_s16 src = m68k_areg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMPA.W (An),An */
uae_u32 REGPARAM2 op_b0d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMPA.W (An)+,An */
uae_u32 REGPARAM2 op_b0d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMPA.W -(An),An */
uae_u32 REGPARAM2 op_b0e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMPA.W (d16,An),An */
uae_u32 REGPARAM2 op_b0e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMPA.W (d8,An,Xn),An */
uae_u32 REGPARAM2 op_b0f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu060(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* CMPA.W (xxx).W,An */
uae_u32 REGPARAM2 op_b0f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMPA.W (xxx).L,An */
uae_u32 REGPARAM2 op_b0f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CMPA.W (d16,PC),An */
uae_u32 REGPARAM2 op_b0fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMPA.W (d8,PC,Xn),An */
uae_u32 REGPARAM2 op_b0fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = get_word_mmu060(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* CMPA.W #<data>.W,An */
uae_u32 REGPARAM2 op_b0fc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 10; 
	uae_s16 src = get_iword_mmu060(2);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.B Dn,Dn */
uae_u32 REGPARAM2 op_b100_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMPM.B (An)+,(An)+ */
uae_u32 REGPARAM2 op_b108_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 26;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[1].reg = dstreg | 0x0;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* EOR.B Dn,(An) */
uae_u32 REGPARAM2 op_b110_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* EOR.B Dn,(An)+ */
uae_u32 REGPARAM2 op_b118_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* EOR.B Dn,-(An) */
uae_u32 REGPARAM2 op_b120_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* EOR.B Dn,(d16,An) */
uae_u32 REGPARAM2 op_b128_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_b130_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* EOR.B Dn,(xxx).W */
uae_u32 REGPARAM2 op_b138_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 3;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.B Dn,(xxx).L */
uae_u32 REGPARAM2 op_b139_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 3;
	CurrentInstrCycles = 20; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* EOR.W Dn,Dn */
uae_u32 REGPARAM2 op_b140_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMPM.W (An)+,(An)+ */
uae_u32 REGPARAM2 op_b148_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 26;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[1].reg = dstreg | 0x0;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_word_mmu060(dsta);
	m68k_areg(regs, dstreg) += 2;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* EOR.W Dn,(An) */
uae_u32 REGPARAM2 op_b150_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* EOR.W Dn,(An)+ */
uae_u32 REGPARAM2 op_b158_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	m68k_areg(regs, dstreg) += 2;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* EOR.W Dn,-(An) */
uae_u32 REGPARAM2 op_b160_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 14; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* EOR.W Dn,(d16,An) */
uae_u32 REGPARAM2 op_b168_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 16; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.W Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_b170_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 16; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* EOR.W Dn,(xxx).W */
uae_u32 REGPARAM2 op_b178_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 3;
	CurrentInstrCycles = 16; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.W Dn,(xxx).L */
uae_u32 REGPARAM2 op_b179_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 3;
	CurrentInstrCycles = 20; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* EOR.L Dn,Dn */
uae_u32 REGPARAM2 op_b180_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 6;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMPM.L (An)+,(An)+ */
uae_u32 REGPARAM2 op_b188_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 26;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[1].reg = dstreg | 0x0;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu060(dsta);
	m68k_areg(regs, dstreg) += 4;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* EOR.L Dn,(An) */
uae_u32 REGPARAM2 op_b190_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 20; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* EOR.L Dn,(An)+ */
uae_u32 REGPARAM2 op_b198_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 20; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	m68k_areg(regs, dstreg) += 4;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* EOR.L Dn,-(An) */
uae_u32 REGPARAM2 op_b1a0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 22; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* EOR.L Dn,(d16,An) */
uae_u32 REGPARAM2 op_b1a8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 24; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.L Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_b1b0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 24; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* EOR.L Dn,(xxx).W */
uae_u32 REGPARAM2 op_b1b8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 3;
	CurrentInstrCycles = 24; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.L Dn,(xxx).L */
uae_u32 REGPARAM2 op_b1b9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 3;
	CurrentInstrCycles = 28; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CMPA.L Dn,An */
uae_u32 REGPARAM2 op_b1c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 6;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMPA.L An,An */
uae_u32 REGPARAM2 op_b1c8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 6;  
	uae_s32 src = m68k_areg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMPA.L (An),An */
uae_u32 REGPARAM2 op_b1d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMPA.L (An)+,An */
uae_u32 REGPARAM2 op_b1d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) += 4;
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMPA.L -(An),An */
uae_u32 REGPARAM2 op_b1e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMPA.L (d16,An),An */
uae_u32 REGPARAM2 op_b1e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMPA.L (d8,An,Xn),An */
uae_u32 REGPARAM2 op_b1f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* CMPA.L (xxx).W,An */
uae_u32 REGPARAM2 op_b1f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMPA.L (xxx).L,An */
uae_u32 REGPARAM2 op_b1f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CMPA.L (d16,PC),An */
uae_u32 REGPARAM2 op_b1fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMPA.L (d8,PC,Xn),An */
uae_u32 REGPARAM2 op_b1fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* CMPA.L #<data>.L,An */
uae_u32 REGPARAM2 op_b1fc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 14; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* AND.B Dn,Dn */
uae_u32 REGPARAM2 op_c000_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.B (An),Dn */
uae_u32 REGPARAM2 op_c010_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.B (An)+,Dn */
uae_u32 REGPARAM2 op_c018_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.B -(An),Dn */
uae_u32 REGPARAM2 op_c020_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.B (d16,An),Dn */
uae_u32 REGPARAM2 op_c028_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.B (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_c030_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_byte_mmu060(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* AND.B (xxx).W,Dn */
uae_u32 REGPARAM2 op_c038_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.B (xxx).L,Dn */
uae_u32 REGPARAM2 op_c039_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* AND.B (d16,PC),Dn */
uae_u32 REGPARAM2 op_c03a_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 src = get_byte_mmu060(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.B (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_c03b_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s8 src = get_byte_mmu060(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* AND.B #<data>.B,Dn */
uae_u32 REGPARAM2 op_c03c_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 8;  
	uae_s8 src = get_ibyte_mmu060(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.W Dn,Dn */
uae_u32 REGPARAM2 op_c040_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.W (An),Dn */
uae_u32 REGPARAM2 op_c050_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.W (An)+,Dn */
uae_u32 REGPARAM2 op_c058_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.W -(An),Dn */
uae_u32 REGPARAM2 op_c060_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.W (d16,An),Dn */
uae_u32 REGPARAM2 op_c068_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.W (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_c070_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* AND.W (xxx).W,Dn */
uae_u32 REGPARAM2 op_c078_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.W (xxx).L,Dn */
uae_u32 REGPARAM2 op_c079_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* AND.W (d16,PC),Dn */
uae_u32 REGPARAM2 op_c07a_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.W (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_c07b_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* AND.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_c07c_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_iword_mmu060(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.L Dn,Dn */
uae_u32 REGPARAM2 op_c080_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 6;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.L (An),Dn */
uae_u32 REGPARAM2 op_c090_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.L (An)+,Dn */
uae_u32 REGPARAM2 op_c098_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) += 4;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.L -(An),Dn */
uae_u32 REGPARAM2 op_c0a0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.L (d16,An),Dn */
uae_u32 REGPARAM2 op_c0a8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.L (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_c0b0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* AND.L (xxx).W,Dn */
uae_u32 REGPARAM2 op_c0b8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.L (xxx).L,Dn */
uae_u32 REGPARAM2 op_c0b9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* AND.L (d16,PC),Dn */
uae_u32 REGPARAM2 op_c0ba_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.L (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_c0bb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = get_long_mmu060(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* AND.L #<data>.L,Dn */
uae_u32 REGPARAM2 op_c0bc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 14; 
	uae_s32 src;
	src = get_ilong_mmu060(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MULU.W Dn,Dn */
uae_u32 REGPARAM2 op_c0c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MULU.W (An),Dn */
uae_u32 REGPARAM2 op_c0d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MULU.W (An)+,Dn */
uae_u32 REGPARAM2 op_c0d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MULU.W -(An),Dn */
uae_u32 REGPARAM2 op_c0e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MULU.W (d16,An),Dn */
uae_u32 REGPARAM2 op_c0e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MULU.W (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_c0f0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MULU.W (xxx).W,Dn */
uae_u32 REGPARAM2 op_c0f8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MULU.W (xxx).L,Dn */
uae_u32 REGPARAM2 op_c0f9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_ilong_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MULU.W (d16,PC),Dn */
uae_u32 REGPARAM2 op_c0fa_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MULU.W (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_c0fb_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MULU.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_c0fc_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_iword_mmu060(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* ABCD.B Dn,Dn */
uae_u32 REGPARAM2 op_c100_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 14;
	CurrentInstrCycles = 6;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u16 newv_lo = (src & 0xF) + (dst & 0xF) + (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = (src & 0xF0) + (dst & 0xF0);
	uae_u16 newv, tmp_newv;
	int cflg;
	newv = tmp_newv = newv_hi + newv_lo;if (newv_lo > 9) { newv += 6; }
	cflg = (newv & 0x3F0) > 0x90;
	if (cflg) newv += 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* ABCD.B -(An),-(An) */
uae_u32 REGPARAM2 op_c108_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 14;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[1].reg = dstreg | 0x0;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u16 newv_lo = (src & 0xF) + (dst & 0xF) + (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = (src & 0xF0) + (dst & 0xF0);
	uae_u16 newv, tmp_newv;
	int cflg;
	newv = tmp_newv = newv_hi + newv_lo;if (newv_lo > 9) { newv += 6; }
	cflg = (newv & 0x3F0) > 0x90;
	if (cflg) newv += 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	put_rmw_byte_mmu060(dsta, newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.B Dn,(An) */
uae_u32 REGPARAM2 op_c110_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.B Dn,(An)+ */
uae_u32 REGPARAM2 op_c118_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.B Dn,-(An) */
uae_u32 REGPARAM2 op_c120_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.B Dn,(d16,An) */
uae_u32 REGPARAM2 op_c128_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_c130_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* AND.B Dn,(xxx).W */
uae_u32 REGPARAM2 op_c138_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.B Dn,(xxx).L */
uae_u32 REGPARAM2 op_c139_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 2;
	CurrentInstrCycles = 20; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	uae_s8 dst = get_rmw_byte_mmu060(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_rmw_byte_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* EXG.L Dn,Dn */
uae_u32 REGPARAM2 op_c140_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 35;
	CurrentInstrCycles = 6;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	m68k_dreg(regs, srcreg) = (dst);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* EXG.L An,An */
uae_u32 REGPARAM2 op_c148_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 35;
	CurrentInstrCycles = 6;  
	uae_s32 src = m68k_areg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	m68k_areg(regs, srcreg) = (dst);
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.W Dn,(An) */
uae_u32 REGPARAM2 op_c150_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.W Dn,(An)+ */
uae_u32 REGPARAM2 op_c158_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	m68k_areg(regs, dstreg) += 2;
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.W Dn,-(An) */
uae_u32 REGPARAM2 op_c160_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 14; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.W Dn,(d16,An) */
uae_u32 REGPARAM2 op_c168_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.W Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_c170_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* AND.W Dn,(xxx).W */
uae_u32 REGPARAM2 op_c178_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.W Dn,(xxx).L */
uae_u32 REGPARAM2 op_c179_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 2;
	CurrentInstrCycles = 20; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	uae_s16 dst = get_rmw_word_mmu060(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	put_rmw_word_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* EXG.L Dn,An */
uae_u32 REGPARAM2 op_c188_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 35;
	CurrentInstrCycles = 6;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	m68k_dreg(regs, srcreg) = (dst);
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.L Dn,(An) */
uae_u32 REGPARAM2 op_c190_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 20; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.L Dn,(An)+ */
uae_u32 REGPARAM2 op_c198_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 20; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	m68k_areg(regs, dstreg) += 4;
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.L Dn,-(An) */
uae_u32 REGPARAM2 op_c1a0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 22; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.L Dn,(d16,An) */
uae_u32 REGPARAM2 op_c1a8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 24; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.L Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_c1b0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 24; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* AND.L Dn,(xxx).W */
uae_u32 REGPARAM2 op_c1b8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 2;
	CurrentInstrCycles = 24; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.L Dn,(xxx).L */
uae_u32 REGPARAM2 op_c1b9_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 2;
	CurrentInstrCycles = 28; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu060(2);
	uae_s32 dst = get_rmw_long_mmu060(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_rmw_long_mmu060(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MULS.W Dn,Dn */
uae_u32 REGPARAM2 op_c1c0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 63;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MULS.W (An),Dn */
uae_u32 REGPARAM2 op_c1d0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 63;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MULS.W (An)+,Dn */
uae_u32 REGPARAM2 op_c1d8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 63;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MULS.W -(An),Dn */
uae_u32 REGPARAM2 op_c1e0_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 63;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x0;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu060(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MULS.W (d16,An),Dn */
uae_u32 REGPARAM2 op_c1e8_33_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 63;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu060(2);
	uae_s16 src = get_word_mmu060(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	C