{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Tracks keyboard focus.
-- 
-- The event controller offers [EventControllerFocus::enter]("GI.Gtk.Objects.EventControllerFocus#g:signal:enter")
-- and [EventControllerFocus::leave]("GI.Gtk.Objects.EventControllerFocus#g:signal:leave") signals, as well as
-- [EventControllerFocus:isFocus]("GI.Gtk.Objects.EventControllerFocus#g:attr:isFocus") and
-- [EventControllerFocus:containsFocus]("GI.Gtk.Objects.EventControllerFocus#g:attr:containsFocus") properties
-- which are updated to reflect focus changes inside the widget hierarchy
-- that is rooted at the controllers widget.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.EventControllerFocus
    ( 

-- * Exported types
    EventControllerFocus(..)                ,
    IsEventControllerFocus                  ,
    toEventControllerFocus                  ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [containsFocus]("GI.Gtk.Objects.EventControllerFocus#g:method:containsFocus"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.EventControllerFocus#g:method:isFocus"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [reset]("GI.Gtk.Objects.EventController#g:method:reset"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getCurrentEvent]("GI.Gtk.Objects.EventController#g:method:getCurrentEvent"), [getCurrentEventDevice]("GI.Gtk.Objects.EventController#g:method:getCurrentEventDevice"), [getCurrentEventState]("GI.Gtk.Objects.EventController#g:method:getCurrentEventState"), [getCurrentEventTime]("GI.Gtk.Objects.EventController#g:method:getCurrentEventTime"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getName]("GI.Gtk.Objects.EventController#g:method:getName"), [getPropagationLimit]("GI.Gtk.Objects.EventController#g:method:getPropagationLimit"), [getPropagationPhase]("GI.Gtk.Objects.EventController#g:method:getPropagationPhase"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getWidget]("GI.Gtk.Objects.EventController#g:method:getWidget").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setName]("GI.Gtk.Objects.EventController#g:method:setName"), [setPropagationLimit]("GI.Gtk.Objects.EventController#g:method:setPropagationLimit"), [setPropagationPhase]("GI.Gtk.Objects.EventController#g:method:setPropagationPhase"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setStaticName]("GI.Gtk.Objects.EventController#g:method:setStaticName").

#if defined(ENABLE_OVERLOADING)
    ResolveEventControllerFocusMethod       ,
#endif

-- ** containsFocus #method:containsFocus#

#if defined(ENABLE_OVERLOADING)
    EventControllerFocusContainsFocusMethodInfo,
#endif
    eventControllerFocusContainsFocus       ,


-- ** isFocus #method:isFocus#

#if defined(ENABLE_OVERLOADING)
    EventControllerFocusIsFocusMethodInfo   ,
#endif
    eventControllerFocusIsFocus             ,


-- ** new #method:new#

    eventControllerFocusNew                 ,




 -- * Properties


-- ** containsFocus #attr:containsFocus#
-- | 'P.True' if focus is contained in the controllers widget.
-- 
-- See [EventControllerFocus:isFocus]("GI.Gtk.Objects.EventControllerFocus#g:attr:isFocus") for whether
-- the focus is in the widget itself or inside a descendent.
-- 
-- When handling focus events, this property is updated
-- before [EventControllerFocus::enter]("GI.Gtk.Objects.EventControllerFocus#g:signal:enter") or
-- [EventControllerFocus::leave]("GI.Gtk.Objects.EventControllerFocus#g:signal:leave") are emitted.

#if defined(ENABLE_OVERLOADING)
    EventControllerFocusContainsFocusPropertyInfo,
#endif
    getEventControllerFocusContainsFocus    ,


-- ** isFocus #attr:isFocus#
-- | 'P.True' if focus is in the controllers widget itself,
-- as opposed to in a descendent widget.
-- 
-- See also [EventControllerFocus:containsFocus]("GI.Gtk.Objects.EventControllerFocus#g:attr:containsFocus").
-- 
-- When handling focus events, this property is updated
-- before [EventControllerFocus::enter]("GI.Gtk.Objects.EventControllerFocus#g:signal:enter") or
-- [EventControllerFocus::leave]("GI.Gtk.Objects.EventControllerFocus#g:signal:leave") are emitted.

#if defined(ENABLE_OVERLOADING)
    EventControllerFocusIsFocusPropertyInfo ,
#endif
    getEventControllerFocusIsFocus          ,




 -- * Signals


-- ** enter #signal:enter#

    EventControllerFocusEnterCallback       ,
#if defined(ENABLE_OVERLOADING)
    EventControllerFocusEnterSignalInfo     ,
#endif
    afterEventControllerFocusEnter          ,
    onEventControllerFocusEnter             ,


-- ** leave #signal:leave#

    EventControllerFocusLeaveCallback       ,
#if defined(ENABLE_OVERLOADING)
    EventControllerFocusLeaveSignalInfo     ,
#endif
    afterEventControllerFocusLeave          ,
    onEventControllerFocusLeave             ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController

#endif

-- | Memory-managed wrapper type.
newtype EventControllerFocus = EventControllerFocus (SP.ManagedPtr EventControllerFocus)
    deriving (Eq)

instance SP.ManagedPtrNewtype EventControllerFocus where
    toManagedPtr (EventControllerFocus p) = p

foreign import ccall "gtk_event_controller_focus_get_type"
    c_gtk_event_controller_focus_get_type :: IO B.Types.GType

instance B.Types.TypedObject EventControllerFocus where
    glibType = c_gtk_event_controller_focus_get_type

instance B.Types.GObject EventControllerFocus

-- | Type class for types which can be safely cast to t'EventControllerFocus', for instance with `toEventControllerFocus`.
class (SP.GObject o, O.IsDescendantOf EventControllerFocus o) => IsEventControllerFocus o
instance (SP.GObject o, O.IsDescendantOf EventControllerFocus o) => IsEventControllerFocus o

instance O.HasParentTypes EventControllerFocus
type instance O.ParentTypes EventControllerFocus = '[Gtk.EventController.EventController, GObject.Object.Object]

-- | Cast to t'EventControllerFocus', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toEventControllerFocus :: (MIO.MonadIO m, IsEventControllerFocus o) => o -> m EventControllerFocus
toEventControllerFocus = MIO.liftIO . B.ManagedPtr.unsafeCastTo EventControllerFocus

-- | Convert t'EventControllerFocus' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe EventControllerFocus) where
    gvalueGType_ = c_gtk_event_controller_focus_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr EventControllerFocus)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr EventControllerFocus)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject EventControllerFocus ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveEventControllerFocusMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEventControllerFocusMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveEventControllerFocusMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveEventControllerFocusMethod "containsFocus" o = EventControllerFocusContainsFocusMethodInfo
    ResolveEventControllerFocusMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveEventControllerFocusMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveEventControllerFocusMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveEventControllerFocusMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveEventControllerFocusMethod "isFocus" o = EventControllerFocusIsFocusMethodInfo
    ResolveEventControllerFocusMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveEventControllerFocusMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveEventControllerFocusMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveEventControllerFocusMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveEventControllerFocusMethod "reset" o = Gtk.EventController.EventControllerResetMethodInfo
    ResolveEventControllerFocusMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveEventControllerFocusMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveEventControllerFocusMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveEventControllerFocusMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveEventControllerFocusMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveEventControllerFocusMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveEventControllerFocusMethod "getCurrentEvent" o = Gtk.EventController.EventControllerGetCurrentEventMethodInfo
    ResolveEventControllerFocusMethod "getCurrentEventDevice" o = Gtk.EventController.EventControllerGetCurrentEventDeviceMethodInfo
    ResolveEventControllerFocusMethod "getCurrentEventState" o = Gtk.EventController.EventControllerGetCurrentEventStateMethodInfo
    ResolveEventControllerFocusMethod "getCurrentEventTime" o = Gtk.EventController.EventControllerGetCurrentEventTimeMethodInfo
    ResolveEventControllerFocusMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveEventControllerFocusMethod "getName" o = Gtk.EventController.EventControllerGetNameMethodInfo
    ResolveEventControllerFocusMethod "getPropagationLimit" o = Gtk.EventController.EventControllerGetPropagationLimitMethodInfo
    ResolveEventControllerFocusMethod "getPropagationPhase" o = Gtk.EventController.EventControllerGetPropagationPhaseMethodInfo
    ResolveEventControllerFocusMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveEventControllerFocusMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveEventControllerFocusMethod "getWidget" o = Gtk.EventController.EventControllerGetWidgetMethodInfo
    ResolveEventControllerFocusMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveEventControllerFocusMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveEventControllerFocusMethod "setName" o = Gtk.EventController.EventControllerSetNameMethodInfo
    ResolveEventControllerFocusMethod "setPropagationLimit" o = Gtk.EventController.EventControllerSetPropagationLimitMethodInfo
    ResolveEventControllerFocusMethod "setPropagationPhase" o = Gtk.EventController.EventControllerSetPropagationPhaseMethodInfo
    ResolveEventControllerFocusMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveEventControllerFocusMethod "setStaticName" o = Gtk.EventController.EventControllerSetStaticNameMethodInfo
    ResolveEventControllerFocusMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEventControllerFocusMethod t EventControllerFocus, O.OverloadedMethod info EventControllerFocus p) => OL.IsLabel t (EventControllerFocus -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEventControllerFocusMethod t EventControllerFocus, O.OverloadedMethod info EventControllerFocus p, R.HasField t EventControllerFocus p) => R.HasField t EventControllerFocus p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEventControllerFocusMethod t EventControllerFocus, O.OverloadedMethodInfo info EventControllerFocus) => OL.IsLabel t (O.MethodProxy info EventControllerFocus) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal EventControllerFocus::enter
-- | Emitted whenever the focus enters into the widget or one
-- of its descendents.
-- 
-- Note that this means you may not get an [enter](#g:signal:enter) signal
-- even though the widget becomes the focus location, in
-- certain cases (such as when the focus moves from a descendent
-- of the widget to the widget itself). If you are interested
-- in these cases, you can monitor the
-- [EventControllerFocus:isFocus]("GI.Gtk.Objects.EventControllerFocus#g:attr:isFocus")
-- property for changes.
type EventControllerFocusEnterCallback =
    IO ()

type C_EventControllerFocusEnterCallback =
    Ptr EventControllerFocus ->             -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_EventControllerFocusEnterCallback`.
foreign import ccall "wrapper"
    mk_EventControllerFocusEnterCallback :: C_EventControllerFocusEnterCallback -> IO (FunPtr C_EventControllerFocusEnterCallback)

wrap_EventControllerFocusEnterCallback :: 
    GObject a => (a -> EventControllerFocusEnterCallback) ->
    C_EventControllerFocusEnterCallback
wrap_EventControllerFocusEnterCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [enter](#signal:enter) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' eventControllerFocus #enter callback
-- @
-- 
-- 
onEventControllerFocusEnter :: (IsEventControllerFocus a, MonadIO m) => a -> ((?self :: a) => EventControllerFocusEnterCallback) -> m SignalHandlerId
onEventControllerFocusEnter obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_EventControllerFocusEnterCallback wrapped
    wrapped'' <- mk_EventControllerFocusEnterCallback wrapped'
    connectSignalFunPtr obj "enter" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [enter](#signal:enter) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' eventControllerFocus #enter callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterEventControllerFocusEnter :: (IsEventControllerFocus a, MonadIO m) => a -> ((?self :: a) => EventControllerFocusEnterCallback) -> m SignalHandlerId
afterEventControllerFocusEnter obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_EventControllerFocusEnterCallback wrapped
    wrapped'' <- mk_EventControllerFocusEnterCallback wrapped'
    connectSignalFunPtr obj "enter" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data EventControllerFocusEnterSignalInfo
instance SignalInfo EventControllerFocusEnterSignalInfo where
    type HaskellCallbackType EventControllerFocusEnterSignalInfo = EventControllerFocusEnterCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_EventControllerFocusEnterCallback cb
        cb'' <- mk_EventControllerFocusEnterCallback cb'
        connectSignalFunPtr obj "enter" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventControllerFocus::enter"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-EventControllerFocus.html#g:signal:enter"})

#endif

-- signal EventControllerFocus::leave
-- | Emitted whenever the focus leaves the widget hierarchy
-- that is rooted at the widget that the controller is attached to.
-- 
-- Note that this means you may not get a [leave](#g:signal:leave) signal
-- even though the focus moves away from the widget, in
-- certain cases (such as when the focus moves from the widget
-- to a descendent). If you are interested in these cases, you
-- can monitor the [EventControllerFocus:isFocus]("GI.Gtk.Objects.EventControllerFocus#g:attr:isFocus")
-- property for changes.
type EventControllerFocusLeaveCallback =
    IO ()

type C_EventControllerFocusLeaveCallback =
    Ptr EventControllerFocus ->             -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_EventControllerFocusLeaveCallback`.
foreign import ccall "wrapper"
    mk_EventControllerFocusLeaveCallback :: C_EventControllerFocusLeaveCallback -> IO (FunPtr C_EventControllerFocusLeaveCallback)

wrap_EventControllerFocusLeaveCallback :: 
    GObject a => (a -> EventControllerFocusLeaveCallback) ->
    C_EventControllerFocusLeaveCallback
wrap_EventControllerFocusLeaveCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [leave](#signal:leave) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' eventControllerFocus #leave callback
-- @
-- 
-- 
onEventControllerFocusLeave :: (IsEventControllerFocus a, MonadIO m) => a -> ((?self :: a) => EventControllerFocusLeaveCallback) -> m SignalHandlerId
onEventControllerFocusLeave obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_EventControllerFocusLeaveCallback wrapped
    wrapped'' <- mk_EventControllerFocusLeaveCallback wrapped'
    connectSignalFunPtr obj "leave" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [leave](#signal:leave) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' eventControllerFocus #leave callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterEventControllerFocusLeave :: (IsEventControllerFocus a, MonadIO m) => a -> ((?self :: a) => EventControllerFocusLeaveCallback) -> m SignalHandlerId
afterEventControllerFocusLeave obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_EventControllerFocusLeaveCallback wrapped
    wrapped'' <- mk_EventControllerFocusLeaveCallback wrapped'
    connectSignalFunPtr obj "leave" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data EventControllerFocusLeaveSignalInfo
instance SignalInfo EventControllerFocusLeaveSignalInfo where
    type HaskellCallbackType EventControllerFocusLeaveSignalInfo = EventControllerFocusLeaveCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_EventControllerFocusLeaveCallback cb
        cb'' <- mk_EventControllerFocusLeaveCallback cb'
        connectSignalFunPtr obj "leave" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventControllerFocus::leave"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-EventControllerFocus.html#g:signal:leave"})

#endif

-- VVV Prop "contains-focus"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@contains-focus@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventControllerFocus #containsFocus
-- @
getEventControllerFocusContainsFocus :: (MonadIO m, IsEventControllerFocus o) => o -> m Bool
getEventControllerFocusContainsFocus obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "contains-focus"

#if defined(ENABLE_OVERLOADING)
data EventControllerFocusContainsFocusPropertyInfo
instance AttrInfo EventControllerFocusContainsFocusPropertyInfo where
    type AttrAllowedOps EventControllerFocusContainsFocusPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint EventControllerFocusContainsFocusPropertyInfo = IsEventControllerFocus
    type AttrSetTypeConstraint EventControllerFocusContainsFocusPropertyInfo = (~) ()
    type AttrTransferTypeConstraint EventControllerFocusContainsFocusPropertyInfo = (~) ()
    type AttrTransferType EventControllerFocusContainsFocusPropertyInfo = ()
    type AttrGetType EventControllerFocusContainsFocusPropertyInfo = Bool
    type AttrLabel EventControllerFocusContainsFocusPropertyInfo = "contains-focus"
    type AttrOrigin EventControllerFocusContainsFocusPropertyInfo = EventControllerFocus
    attrGet = getEventControllerFocusContainsFocus
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventControllerFocus.containsFocus"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-EventControllerFocus.html#g:attr:containsFocus"
        })
#endif

-- VVV Prop "is-focus"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@is-focus@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventControllerFocus #isFocus
-- @
getEventControllerFocusIsFocus :: (MonadIO m, IsEventControllerFocus o) => o -> m Bool
getEventControllerFocusIsFocus obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "is-focus"

#if defined(ENABLE_OVERLOADING)
data EventControllerFocusIsFocusPropertyInfo
instance AttrInfo EventControllerFocusIsFocusPropertyInfo where
    type AttrAllowedOps EventControllerFocusIsFocusPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint EventControllerFocusIsFocusPropertyInfo = IsEventControllerFocus
    type AttrSetTypeConstraint EventControllerFocusIsFocusPropertyInfo = (~) ()
    type AttrTransferTypeConstraint EventControllerFocusIsFocusPropertyInfo = (~) ()
    type AttrTransferType EventControllerFocusIsFocusPropertyInfo = ()
    type AttrGetType EventControllerFocusIsFocusPropertyInfo = Bool
    type AttrLabel EventControllerFocusIsFocusPropertyInfo = "is-focus"
    type AttrOrigin EventControllerFocusIsFocusPropertyInfo = EventControllerFocus
    attrGet = getEventControllerFocusIsFocus
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventControllerFocus.isFocus"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-EventControllerFocus.html#g:attr:isFocus"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList EventControllerFocus
type instance O.AttributeList EventControllerFocus = EventControllerFocusAttributeList
type EventControllerFocusAttributeList = ('[ '("containsFocus", EventControllerFocusContainsFocusPropertyInfo), '("isFocus", EventControllerFocusIsFocusPropertyInfo), '("name", Gtk.EventController.EventControllerNamePropertyInfo), '("propagationLimit", Gtk.EventController.EventControllerPropagationLimitPropertyInfo), '("propagationPhase", Gtk.EventController.EventControllerPropagationPhasePropertyInfo), '("widget", Gtk.EventController.EventControllerWidgetPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList EventControllerFocus = EventControllerFocusSignalList
type EventControllerFocusSignalList = ('[ '("enter", EventControllerFocusEnterSignalInfo), '("leave", EventControllerFocusLeaveSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method EventControllerFocus::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gtk" , name = "EventControllerFocus" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_event_controller_focus_new" gtk_event_controller_focus_new :: 
    IO (Ptr EventControllerFocus)

-- | Creates a new event controller that will handle focus events.
eventControllerFocusNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m EventControllerFocus
    -- ^ __Returns:__ a new @GtkEventControllerFocus@
eventControllerFocusNew  = liftIO $ do
    result <- gtk_event_controller_focus_new
    checkUnexpectedReturnNULL "eventControllerFocusNew" result
    result' <- (wrapObject EventControllerFocus) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method EventControllerFocus::contains_focus
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "EventControllerFocus" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkEventControllerFocus`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_event_controller_focus_contains_focus" gtk_event_controller_focus_contains_focus :: 
    Ptr EventControllerFocus ->             -- self : TInterface (Name {namespace = "Gtk", name = "EventControllerFocus"})
    IO CInt

-- | Returns 'P.True' if focus is within /@self@/ or one of its children.
eventControllerFocusContainsFocus ::
    (B.CallStack.HasCallStack, MonadIO m, IsEventControllerFocus a) =>
    a
    -- ^ /@self@/: a @GtkEventControllerFocus@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if focus is within /@self@/ or one of its children
eventControllerFocusContainsFocus self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_event_controller_focus_contains_focus self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data EventControllerFocusContainsFocusMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsEventControllerFocus a) => O.OverloadedMethod EventControllerFocusContainsFocusMethodInfo a signature where
    overloadedMethod = eventControllerFocusContainsFocus

instance O.OverloadedMethodInfo EventControllerFocusContainsFocusMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventControllerFocus.eventControllerFocusContainsFocus",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-EventControllerFocus.html#v:eventControllerFocusContainsFocus"
        })


#endif

-- method EventControllerFocus::is_focus
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "EventControllerFocus" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkEventControllerFocus`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_event_controller_focus_is_focus" gtk_event_controller_focus_is_focus :: 
    Ptr EventControllerFocus ->             -- self : TInterface (Name {namespace = "Gtk", name = "EventControllerFocus"})
    IO CInt

-- | Returns 'P.True' if focus is within /@self@/, but not one of its children.
eventControllerFocusIsFocus ::
    (B.CallStack.HasCallStack, MonadIO m, IsEventControllerFocus a) =>
    a
    -- ^ /@self@/: a @GtkEventControllerFocus@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if focus is within /@self@/, but not one of its children
eventControllerFocusIsFocus self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_event_controller_focus_is_focus self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data EventControllerFocusIsFocusMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsEventControllerFocus a) => O.OverloadedMethod EventControllerFocusIsFocusMethodInfo a signature where
    overloadedMethod = eventControllerFocusIsFocus

instance O.OverloadedMethodInfo EventControllerFocusIsFocusMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventControllerFocus.eventControllerFocusIsFocus",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-EventControllerFocus.html#v:eventControllerFocusIsFocus"
        })


#endif


