{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @GSocketControlMessage@ is a special-purpose utility message that
-- can be sent to or received from a t'GI.Gio.Objects.Socket.Socket'. These types of
-- messages are often called ‘ancillary data’.
-- 
-- The message can represent some sort of special instruction to or
-- information from the socket or can represent a special kind of
-- transfer to the peer (for example, sending a file descriptor over
-- a UNIX socket).
-- 
-- These messages are sent with 'GI.Gio.Objects.Socket.socketSendMessage' and received
-- with 'GI.Gio.Objects.Socket.socketReceiveMessage'.
-- 
-- To extend the set of control message that can be sent, subclass this
-- class and override the @get_size@, @get_level@, @get_type@ and @serialize@
-- methods.
-- 
-- To extend the set of control messages that can be received, subclass
-- this class and implement the @deserialize@ method. Also, make sure your
-- class is registered with the [type/@gObject@/.Type] type system before calling
-- 'GI.Gio.Objects.Socket.socketReceiveMessage' to read such a message.
-- 
-- /Since: 2.22/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.SocketControlMessage
    ( 

-- * Exported types
    SocketControlMessage(..)                ,
    IsSocketControlMessage                  ,
    toSocketControlMessage                  ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [serialize]("GI.Gio.Objects.SocketControlMessage#g:method:serialize"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getLevel]("GI.Gio.Objects.SocketControlMessage#g:method:getLevel"), [getMsgType]("GI.Gio.Objects.SocketControlMessage#g:method:getMsgType"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSize]("GI.Gio.Objects.SocketControlMessage#g:method:getSize").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveSocketControlMessageMethod       ,
#endif

-- ** deserialize #method:deserialize#

    socketControlMessageDeserialize         ,


-- ** getLevel #method:getLevel#

#if defined(ENABLE_OVERLOADING)
    SocketControlMessageGetLevelMethodInfo  ,
#endif
    socketControlMessageGetLevel            ,


-- ** getMsgType #method:getMsgType#

#if defined(ENABLE_OVERLOADING)
    SocketControlMessageGetMsgTypeMethodInfo,
#endif
    socketControlMessageGetMsgType          ,


-- ** getSize #method:getSize#

#if defined(ENABLE_OVERLOADING)
    SocketControlMessageGetSizeMethodInfo   ,
#endif
    socketControlMessageGetSize             ,


-- ** serialize #method:serialize#

#if defined(ENABLE_OVERLOADING)
    SocketControlMessageSerializeMethodInfo ,
#endif
    socketControlMessageSerialize           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object

#else
import qualified GI.GObject.Objects.Object as GObject.Object

#endif

-- | Memory-managed wrapper type.
newtype SocketControlMessage = SocketControlMessage (SP.ManagedPtr SocketControlMessage)
    deriving (Eq)

instance SP.ManagedPtrNewtype SocketControlMessage where
    toManagedPtr (SocketControlMessage p) = p

foreign import ccall "g_socket_control_message_get_type"
    c_g_socket_control_message_get_type :: IO B.Types.GType

instance B.Types.TypedObject SocketControlMessage where
    glibType = c_g_socket_control_message_get_type

instance B.Types.GObject SocketControlMessage

-- | Type class for types which can be safely cast to t'SocketControlMessage', for instance with `toSocketControlMessage`.
class (SP.GObject o, O.IsDescendantOf SocketControlMessage o) => IsSocketControlMessage o
instance (SP.GObject o, O.IsDescendantOf SocketControlMessage o) => IsSocketControlMessage o

instance O.HasParentTypes SocketControlMessage
type instance O.ParentTypes SocketControlMessage = '[GObject.Object.Object]

-- | Cast to t'SocketControlMessage', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toSocketControlMessage :: (MIO.MonadIO m, IsSocketControlMessage o) => o -> m SocketControlMessage
toSocketControlMessage = MIO.liftIO . B.ManagedPtr.unsafeCastTo SocketControlMessage

-- | Convert t'SocketControlMessage' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe SocketControlMessage) where
    gvalueGType_ = c_g_socket_control_message_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr SocketControlMessage)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr SocketControlMessage)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject SocketControlMessage ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveSocketControlMessageMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSocketControlMessageMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveSocketControlMessageMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveSocketControlMessageMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveSocketControlMessageMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveSocketControlMessageMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveSocketControlMessageMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveSocketControlMessageMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveSocketControlMessageMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveSocketControlMessageMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveSocketControlMessageMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveSocketControlMessageMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveSocketControlMessageMethod "serialize" o = SocketControlMessageSerializeMethodInfo
    ResolveSocketControlMessageMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveSocketControlMessageMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveSocketControlMessageMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveSocketControlMessageMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveSocketControlMessageMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveSocketControlMessageMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveSocketControlMessageMethod "getLevel" o = SocketControlMessageGetLevelMethodInfo
    ResolveSocketControlMessageMethod "getMsgType" o = SocketControlMessageGetMsgTypeMethodInfo
    ResolveSocketControlMessageMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveSocketControlMessageMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveSocketControlMessageMethod "getSize" o = SocketControlMessageGetSizeMethodInfo
    ResolveSocketControlMessageMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveSocketControlMessageMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveSocketControlMessageMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveSocketControlMessageMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSocketControlMessageMethod t SocketControlMessage, O.OverloadedMethod info SocketControlMessage p) => OL.IsLabel t (SocketControlMessage -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSocketControlMessageMethod t SocketControlMessage, O.OverloadedMethod info SocketControlMessage p, R.HasField t SocketControlMessage p) => R.HasField t SocketControlMessage p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSocketControlMessageMethod t SocketControlMessage, O.OverloadedMethodInfo info SocketControlMessage) => OL.IsLabel t (O.MethodProxy info SocketControlMessage) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList SocketControlMessage
type instance O.AttributeList SocketControlMessage = SocketControlMessageAttributeList
type SocketControlMessageAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList SocketControlMessage = SocketControlMessageSignalList
type SocketControlMessageSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method SocketControlMessage::get_level
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "message"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "SocketControlMessage" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketControlMessage"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_control_message_get_level" g_socket_control_message_get_level :: 
    Ptr SocketControlMessage ->             -- message : TInterface (Name {namespace = "Gio", name = "SocketControlMessage"})
    IO Int32

-- | Returns the \"level\" (i.e. the originating protocol) of the control message.
-- This is often SOL_SOCKET.
-- 
-- /Since: 2.22/
socketControlMessageGetLevel ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketControlMessage a) =>
    a
    -- ^ /@message@/: a t'GI.Gio.Objects.SocketControlMessage.SocketControlMessage'
    -> m Int32
    -- ^ __Returns:__ an integer describing the level
socketControlMessageGetLevel message = liftIO $ do
    message' <- unsafeManagedPtrCastPtr message
    result <- g_socket_control_message_get_level message'
    touchManagedPtr message
    return result

#if defined(ENABLE_OVERLOADING)
data SocketControlMessageGetLevelMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsSocketControlMessage a) => O.OverloadedMethod SocketControlMessageGetLevelMethodInfo a signature where
    overloadedMethod = socketControlMessageGetLevel

instance O.OverloadedMethodInfo SocketControlMessageGetLevelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketControlMessage.socketControlMessageGetLevel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-SocketControlMessage.html#v:socketControlMessageGetLevel"
        })


#endif

-- method SocketControlMessage::get_msg_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "message"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "SocketControlMessage" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketControlMessage"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_control_message_get_msg_type" g_socket_control_message_get_msg_type :: 
    Ptr SocketControlMessage ->             -- message : TInterface (Name {namespace = "Gio", name = "SocketControlMessage"})
    IO Int32

-- | Returns the protocol specific type of the control message.
-- For instance, for UNIX fd passing this would be SCM_RIGHTS.
-- 
-- /Since: 2.22/
socketControlMessageGetMsgType ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketControlMessage a) =>
    a
    -- ^ /@message@/: a t'GI.Gio.Objects.SocketControlMessage.SocketControlMessage'
    -> m Int32
    -- ^ __Returns:__ an integer describing the type of control message
socketControlMessageGetMsgType message = liftIO $ do
    message' <- unsafeManagedPtrCastPtr message
    result <- g_socket_control_message_get_msg_type message'
    touchManagedPtr message
    return result

#if defined(ENABLE_OVERLOADING)
data SocketControlMessageGetMsgTypeMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsSocketControlMessage a) => O.OverloadedMethod SocketControlMessageGetMsgTypeMethodInfo a signature where
    overloadedMethod = socketControlMessageGetMsgType

instance O.OverloadedMethodInfo SocketControlMessageGetMsgTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketControlMessage.socketControlMessageGetMsgType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-SocketControlMessage.html#v:socketControlMessageGetMsgType"
        })


#endif

-- method SocketControlMessage::get_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "message"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "SocketControlMessage" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketControlMessage"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TSize)
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_control_message_get_size" g_socket_control_message_get_size :: 
    Ptr SocketControlMessage ->             -- message : TInterface (Name {namespace = "Gio", name = "SocketControlMessage"})
    IO FCT.CSize

-- | Returns the space required for the control message, not including
-- headers or alignment.
-- 
-- /Since: 2.22/
socketControlMessageGetSize ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketControlMessage a) =>
    a
    -- ^ /@message@/: a t'GI.Gio.Objects.SocketControlMessage.SocketControlMessage'
    -> m FCT.CSize
    -- ^ __Returns:__ The number of bytes required.
socketControlMessageGetSize message = liftIO $ do
    message' <- unsafeManagedPtrCastPtr message
    result <- g_socket_control_message_get_size message'
    touchManagedPtr message
    return result

#if defined(ENABLE_OVERLOADING)
data SocketControlMessageGetSizeMethodInfo
instance (signature ~ (m FCT.CSize), MonadIO m, IsSocketControlMessage a) => O.OverloadedMethod SocketControlMessageGetSizeMethodInfo a signature where
    overloadedMethod = socketControlMessageGetSize

instance O.OverloadedMethodInfo SocketControlMessageGetSizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketControlMessage.socketControlMessageGetSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-SocketControlMessage.html#v:socketControlMessageGetSize"
        })


#endif

-- method SocketControlMessage::serialize
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "message"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "SocketControlMessage" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketControlMessage"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A buffer to write data to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_control_message_serialize" g_socket_control_message_serialize :: 
    Ptr SocketControlMessage ->             -- message : TInterface (Name {namespace = "Gio", name = "SocketControlMessage"})
    Ptr () ->                               -- data : TBasicType TPtr
    IO ()

-- | Converts the data in the message to bytes placed in the
-- message.
-- 
-- /@data@/ is guaranteed to have enough space to fit the size
-- returned by 'GI.Gio.Objects.SocketControlMessage.socketControlMessageGetSize' on this
-- object.
-- 
-- /Since: 2.22/
socketControlMessageSerialize ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketControlMessage a) =>
    a
    -- ^ /@message@/: a t'GI.Gio.Objects.SocketControlMessage.SocketControlMessage'
    -> Ptr ()
    -- ^ /@data@/: A buffer to write data to
    -> m ()
socketControlMessageSerialize message data_ = liftIO $ do
    message' <- unsafeManagedPtrCastPtr message
    g_socket_control_message_serialize message' data_
    touchManagedPtr message
    return ()

#if defined(ENABLE_OVERLOADING)
data SocketControlMessageSerializeMethodInfo
instance (signature ~ (Ptr () -> m ()), MonadIO m, IsSocketControlMessage a) => O.OverloadedMethod SocketControlMessageSerializeMethodInfo a signature where
    overloadedMethod = socketControlMessageSerialize

instance O.OverloadedMethodInfo SocketControlMessageSerializeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketControlMessage.socketControlMessageSerialize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-SocketControlMessage.html#v:socketControlMessageSerialize"
        })


#endif

-- method SocketControlMessage::deserialize
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "level"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a socket level" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "type"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a socket control message type for the given @level"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "size"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the size of the data in bytes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TCArray False (-1) 2 (TBasicType TUInt8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "pointer to the message data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "size"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "the size of the data in bytes"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "SocketControlMessage" })
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_control_message_deserialize" g_socket_control_message_deserialize :: 
    Int32 ->                                -- level : TBasicType TInt
    Int32 ->                                -- type : TBasicType TInt
    FCT.CSize ->                            -- size : TBasicType TSize
    Ptr Word8 ->                            -- data : TCArray False (-1) 2 (TBasicType TUInt8)
    IO (Ptr SocketControlMessage)

-- | Tries to deserialize a socket control message of a given
-- /@level@/ and /@type@/. This will ask all known (to GType) subclasses
-- of t'GI.Gio.Objects.SocketControlMessage.SocketControlMessage' if they can understand this kind
-- of message and if so deserialize it into a t'GI.Gio.Objects.SocketControlMessage.SocketControlMessage'.
-- 
-- If there is no implementation for this kind of control message, 'P.Nothing'
-- will be returned.
-- 
-- /Since: 2.22/
socketControlMessageDeserialize ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@level@/: a socket level
    -> Int32
    -- ^ /@type@/: a socket control message type for the given /@level@/
    -> ByteString
    -- ^ /@data@/: pointer to the message data
    -> m (Maybe SocketControlMessage)
    -- ^ __Returns:__ the deserialized message or 'P.Nothing'
socketControlMessageDeserialize level type_ data_ = liftIO $ do
    let size = fromIntegral $ B.length data_
    data_' <- packByteString data_
    result <- g_socket_control_message_deserialize level type_ size data_'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject SocketControlMessage) result'
        return result''
    freeMem data_'
    return maybeResult

#if defined(ENABLE_OVERLOADING)
#endif


