{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The t'GI.Gdk.Structs.Geometry.Geometry' struct gives the window manager information about
-- a window’s geometry constraints. Normally you would set these on
-- the GTK+ level using @/gtk_window_set_geometry_hints()/@. @/GtkWindow/@
-- then sets the hints on the t'GI.Gdk.Objects.Window.Window' it creates.
-- 
-- 'GI.Gdk.Objects.Window.windowSetGeometryHints' expects the hints to be fully valid already
-- and simply passes them to the window manager; in contrast,
-- @/gtk_window_set_geometry_hints()/@ performs some interpretation. For example,
-- @/GtkWindow/@ will apply the hints to the geometry widget instead of the
-- toplevel window, if you set a geometry widget. Also, the
-- /@minWidth@/\//@minHeight@/\//@maxWidth@/\//@maxHeight@/ fields may be set to -1, and
-- @/GtkWindow/@ will substitute the size request of the window or geometry widget.
-- If the minimum size hint is not provided, @/GtkWindow/@ will use its requisition
-- as the minimum size. If the minimum size is provided and a geometry widget is
-- set, @/GtkWindow/@ will take the minimum size as the minimum size of the
-- geometry widget rather than the entire window. The base size is treated
-- similarly.
-- 
-- The canonical use-case for @/gtk_window_set_geometry_hints()/@ is to get a
-- terminal widget to resize properly. Here, the terminal text area should be
-- the geometry widget; @/GtkWindow/@ will then automatically set the base size to
-- the size of other widgets in the terminal window, such as the menubar and
-- scrollbar. Then, the /@widthInc@/ and /@heightInc@/ fields should be set to the
-- size of one character in the terminal. Finally, the base size should be set
-- to the size of one character. The net effect is that the minimum size of the
-- terminal will have a 1x1 character terminal area, and only terminal sizes on
-- the “character grid” will be allowed.
-- 
-- Here’s an example of how the terminal example would be implemented, assuming
-- a terminal area widget called “terminal” and a toplevel window “toplevel”:
-- 
-- 
-- === /C code/
-- >
-- >	GdkGeometry hints;
-- >
-- >	hints.base_width = terminal->char_width;
-- >        hints.base_height = terminal->char_height;
-- >        hints.min_width = terminal->char_width;
-- >        hints.min_height = terminal->char_height;
-- >        hints.width_inc = terminal->char_width;
-- >        hints.height_inc = terminal->char_height;
-- >
-- > gtk_window_set_geometry_hints (GTK_WINDOW (toplevel),
-- >                                GTK_WIDGET (terminal),
-- >                                &hints,
-- >                                GDK_HINT_RESIZE_INC |
-- >                                GDK_HINT_MIN_SIZE |
-- >                                GDK_HINT_BASE_SIZE);
-- 
-- 
-- The other useful fields are the /@minAspect@/ and /@maxAspect@/ fields; these
-- contain a width\/height ratio as a floating point number. If a geometry widget
-- is set, the aspect applies to the geometry widget rather than the entire
-- window. The most common use of these hints is probably to set /@minAspect@/ and
-- /@maxAspect@/ to the same value, thus forcing the window to keep a constant
-- aspect ratio.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.Geometry
    ( 

-- * Exported types
    Geometry(..)                            ,
    newZeroGeometry                         ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveGeometryMethod                   ,
#endif



 -- * Properties


-- ** baseHeight #attr:baseHeight#
-- | allowed window widths are /@baseHeight@/ + /@heightInc@/ * N where
--  N is any integer (-1 allowed with @/GtkWindow/@)

#if defined(ENABLE_OVERLOADING)
    geometry_baseHeight                     ,
#endif
    getGeometryBaseHeight                   ,
    setGeometryBaseHeight                   ,


-- ** baseWidth #attr:baseWidth#
-- | allowed window widths are /@baseWidth@/ + /@widthInc@/ * N where N
--  is any integer (-1 allowed with @/GtkWindow/@)

#if defined(ENABLE_OVERLOADING)
    geometry_baseWidth                      ,
#endif
    getGeometryBaseWidth                    ,
    setGeometryBaseWidth                    ,


-- ** heightInc #attr:heightInc#
-- | height resize increment

#if defined(ENABLE_OVERLOADING)
    geometry_heightInc                      ,
#endif
    getGeometryHeightInc                    ,
    setGeometryHeightInc                    ,


-- ** maxAspect #attr:maxAspect#
-- | maximum width\/height ratio

#if defined(ENABLE_OVERLOADING)
    geometry_maxAspect                      ,
#endif
    getGeometryMaxAspect                    ,
    setGeometryMaxAspect                    ,


-- ** maxHeight #attr:maxHeight#
-- | maximum height of window (or -1 to use requisition, with
--  @/GtkWindow/@ only)

#if defined(ENABLE_OVERLOADING)
    geometry_maxHeight                      ,
#endif
    getGeometryMaxHeight                    ,
    setGeometryMaxHeight                    ,


-- ** maxWidth #attr:maxWidth#
-- | maximum width of window (or -1 to use requisition, with
--  @/GtkWindow/@ only)

#if defined(ENABLE_OVERLOADING)
    geometry_maxWidth                       ,
#endif
    getGeometryMaxWidth                     ,
    setGeometryMaxWidth                     ,


-- ** minAspect #attr:minAspect#
-- | minimum width\/height ratio

#if defined(ENABLE_OVERLOADING)
    geometry_minAspect                      ,
#endif
    getGeometryMinAspect                    ,
    setGeometryMinAspect                    ,


-- ** minHeight #attr:minHeight#
-- | minimum height of window (or -1 to use requisition, with
--  @/GtkWindow/@ only)

#if defined(ENABLE_OVERLOADING)
    geometry_minHeight                      ,
#endif
    getGeometryMinHeight                    ,
    setGeometryMinHeight                    ,


-- ** minWidth #attr:minWidth#
-- | minimum width of window (or -1 to use requisition, with
--  @/GtkWindow/@ only)

#if defined(ENABLE_OVERLOADING)
    geometry_minWidth                       ,
#endif
    getGeometryMinWidth                     ,
    setGeometryMinWidth                     ,


-- ** widthInc #attr:widthInc#
-- | width resize increment

#if defined(ENABLE_OVERLOADING)
    geometry_widthInc                       ,
#endif
    getGeometryWidthInc                     ,
    setGeometryWidthInc                     ,


-- ** winGravity #attr:winGravity#
-- | window gravity, see @/gtk_window_set_gravity()/@

#if defined(ENABLE_OVERLOADING)
    geometry_winGravity                     ,
#endif
    getGeometryWinGravity                   ,
    setGeometryWinGravity                   ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums

#else
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums

#endif

-- | Memory-managed wrapper type.
newtype Geometry = Geometry (SP.ManagedPtr Geometry)
    deriving (Eq)

instance SP.ManagedPtrNewtype Geometry where
    toManagedPtr (Geometry p) = p

instance BoxedPtr Geometry where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 56 >=> B.ManagedPtr.wrapPtr Geometry)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr Geometry where
    boxedPtrCalloc = callocBytes 56


-- | Construct a t'Geometry' struct initialized to zero.
newZeroGeometry :: MonadIO m => m Geometry
newZeroGeometry = liftIO $ boxedPtrCalloc >>= wrapPtr Geometry

instance tag ~ 'AttrSet => Constructible Geometry tag where
    new _ attrs = do
        o <- newZeroGeometry
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@min_width@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' geometry #minWidth
-- @
getGeometryMinWidth :: MonadIO m => Geometry -> m Int32
getGeometryMinWidth s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Int32
    return val

-- | Set the value of the “@min_width@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' geometry [ #minWidth 'Data.GI.Base.Attributes.:=' value ]
-- @
setGeometryMinWidth :: MonadIO m => Geometry -> Int32 -> m ()
setGeometryMinWidth s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data GeometryMinWidthFieldInfo
instance AttrInfo GeometryMinWidthFieldInfo where
    type AttrBaseTypeConstraint GeometryMinWidthFieldInfo = (~) Geometry
    type AttrAllowedOps GeometryMinWidthFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint GeometryMinWidthFieldInfo = (~) Int32
    type AttrTransferTypeConstraint GeometryMinWidthFieldInfo = (~)Int32
    type AttrTransferType GeometryMinWidthFieldInfo = Int32
    type AttrGetType GeometryMinWidthFieldInfo = Int32
    type AttrLabel GeometryMinWidthFieldInfo = "min_width"
    type AttrOrigin GeometryMinWidthFieldInfo = Geometry
    attrGet = getGeometryMinWidth
    attrSet = setGeometryMinWidth
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.Geometry.minWidth"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-Geometry.html#g:attr:minWidth"
        })

geometry_minWidth :: AttrLabelProxy "minWidth"
geometry_minWidth = AttrLabelProxy

#endif


-- | Get the value of the “@min_height@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' geometry #minHeight
-- @
getGeometryMinHeight :: MonadIO m => Geometry -> m Int32
getGeometryMinHeight s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 4) :: IO Int32
    return val

-- | Set the value of the “@min_height@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' geometry [ #minHeight 'Data.GI.Base.Attributes.:=' value ]
-- @
setGeometryMinHeight :: MonadIO m => Geometry -> Int32 -> m ()
setGeometryMinHeight s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 4) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data GeometryMinHeightFieldInfo
instance AttrInfo GeometryMinHeightFieldInfo where
    type AttrBaseTypeConstraint GeometryMinHeightFieldInfo = (~) Geometry
    type AttrAllowedOps GeometryMinHeightFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint GeometryMinHeightFieldInfo = (~) Int32
    type AttrTransferTypeConstraint GeometryMinHeightFieldInfo = (~)Int32
    type AttrTransferType GeometryMinHeightFieldInfo = Int32
    type AttrGetType GeometryMinHeightFieldInfo = Int32
    type AttrLabel GeometryMinHeightFieldInfo = "min_height"
    type AttrOrigin GeometryMinHeightFieldInfo = Geometry
    attrGet = getGeometryMinHeight
    attrSet = setGeometryMinHeight
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.Geometry.minHeight"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-Geometry.html#g:attr:minHeight"
        })

geometry_minHeight :: AttrLabelProxy "minHeight"
geometry_minHeight = AttrLabelProxy

#endif


-- | Get the value of the “@max_width@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' geometry #maxWidth
-- @
getGeometryMaxWidth :: MonadIO m => Geometry -> m Int32
getGeometryMaxWidth s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO Int32
    return val

-- | Set the value of the “@max_width@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' geometry [ #maxWidth 'Data.GI.Base.Attributes.:=' value ]
-- @
setGeometryMaxWidth :: MonadIO m => Geometry -> Int32 -> m ()
setGeometryMaxWidth s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data GeometryMaxWidthFieldInfo
instance AttrInfo GeometryMaxWidthFieldInfo where
    type AttrBaseTypeConstraint GeometryMaxWidthFieldInfo = (~) Geometry
    type AttrAllowedOps GeometryMaxWidthFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint GeometryMaxWidthFieldInfo = (~) Int32
    type AttrTransferTypeConstraint GeometryMaxWidthFieldInfo = (~)Int32
    type AttrTransferType GeometryMaxWidthFieldInfo = Int32
    type AttrGetType GeometryMaxWidthFieldInfo = Int32
    type AttrLabel GeometryMaxWidthFieldInfo = "max_width"
    type AttrOrigin GeometryMaxWidthFieldInfo = Geometry
    attrGet = getGeometryMaxWidth
    attrSet = setGeometryMaxWidth
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.Geometry.maxWidth"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-Geometry.html#g:attr:maxWidth"
        })

geometry_maxWidth :: AttrLabelProxy "maxWidth"
geometry_maxWidth = AttrLabelProxy

#endif


-- | Get the value of the “@max_height@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' geometry #maxHeight
-- @
getGeometryMaxHeight :: MonadIO m => Geometry -> m Int32
getGeometryMaxHeight s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 12) :: IO Int32
    return val

-- | Set the value of the “@max_height@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' geometry [ #maxHeight 'Data.GI.Base.Attributes.:=' value ]
-- @
setGeometryMaxHeight :: MonadIO m => Geometry -> Int32 -> m ()
setGeometryMaxHeight s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 12) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data GeometryMaxHeightFieldInfo
instance AttrInfo GeometryMaxHeightFieldInfo where
    type AttrBaseTypeConstraint GeometryMaxHeightFieldInfo = (~) Geometry
    type AttrAllowedOps GeometryMaxHeightFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint GeometryMaxHeightFieldInfo = (~) Int32
    type AttrTransferTypeConstraint GeometryMaxHeightFieldInfo = (~)Int32
    type AttrTransferType GeometryMaxHeightFieldInfo = Int32
    type AttrGetType GeometryMaxHeightFieldInfo = Int32
    type AttrLabel GeometryMaxHeightFieldInfo = "max_height"
    type AttrOrigin GeometryMaxHeightFieldInfo = Geometry
    attrGet = getGeometryMaxHeight
    attrSet = setGeometryMaxHeight
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.Geometry.maxHeight"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-Geometry.html#g:attr:maxHeight"
        })

geometry_maxHeight :: AttrLabelProxy "maxHeight"
geometry_maxHeight = AttrLabelProxy

#endif


-- | Get the value of the “@base_width@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' geometry #baseWidth
-- @
getGeometryBaseWidth :: MonadIO m => Geometry -> m Int32
getGeometryBaseWidth s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Int32
    return val

-- | Set the value of the “@base_width@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' geometry [ #baseWidth 'Data.GI.Base.Attributes.:=' value ]
-- @
setGeometryBaseWidth :: MonadIO m => Geometry -> Int32 -> m ()
setGeometryBaseWidth s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data GeometryBaseWidthFieldInfo
instance AttrInfo GeometryBaseWidthFieldInfo where
    type AttrBaseTypeConstraint GeometryBaseWidthFieldInfo = (~) Geometry
    type AttrAllowedOps GeometryBaseWidthFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint GeometryBaseWidthFieldInfo = (~) Int32
    type AttrTransferTypeConstraint GeometryBaseWidthFieldInfo = (~)Int32
    type AttrTransferType GeometryBaseWidthFieldInfo = Int32
    type AttrGetType GeometryBaseWidthFieldInfo = Int32
    type AttrLabel GeometryBaseWidthFieldInfo = "base_width"
    type AttrOrigin GeometryBaseWidthFieldInfo = Geometry
    attrGet = getGeometryBaseWidth
    attrSet = setGeometryBaseWidth
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.Geometry.baseWidth"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-Geometry.html#g:attr:baseWidth"
        })

geometry_baseWidth :: AttrLabelProxy "baseWidth"
geometry_baseWidth = AttrLabelProxy

#endif


-- | Get the value of the “@base_height@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' geometry #baseHeight
-- @
getGeometryBaseHeight :: MonadIO m => Geometry -> m Int32
getGeometryBaseHeight s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 20) :: IO Int32
    return val

-- | Set the value of the “@base_height@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' geometry [ #baseHeight 'Data.GI.Base.Attributes.:=' value ]
-- @
setGeometryBaseHeight :: MonadIO m => Geometry -> Int32 -> m ()
setGeometryBaseHeight s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 20) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data GeometryBaseHeightFieldInfo
instance AttrInfo GeometryBaseHeightFieldInfo where
    type AttrBaseTypeConstraint GeometryBaseHeightFieldInfo = (~) Geometry
    type AttrAllowedOps GeometryBaseHeightFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint GeometryBaseHeightFieldInfo = (~) Int32
    type AttrTransferTypeConstraint GeometryBaseHeightFieldInfo = (~)Int32
    type AttrTransferType GeometryBaseHeightFieldInfo = Int32
    type AttrGetType GeometryBaseHeightFieldInfo = Int32
    type AttrLabel GeometryBaseHeightFieldInfo = "base_height"
    type AttrOrigin GeometryBaseHeightFieldInfo = Geometry
    attrGet = getGeometryBaseHeight
    attrSet = setGeometryBaseHeight
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.Geometry.baseHeight"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-Geometry.html#g:attr:baseHeight"
        })

geometry_baseHeight :: AttrLabelProxy "baseHeight"
geometry_baseHeight = AttrLabelProxy

#endif


-- | Get the value of the “@width_inc@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' geometry #widthInc
-- @
getGeometryWidthInc :: MonadIO m => Geometry -> m Int32
getGeometryWidthInc s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO Int32
    return val

-- | Set the value of the “@width_inc@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' geometry [ #widthInc 'Data.GI.Base.Attributes.:=' value ]
-- @
setGeometryWidthInc :: MonadIO m => Geometry -> Int32 -> m ()
setGeometryWidthInc s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data GeometryWidthIncFieldInfo
instance AttrInfo GeometryWidthIncFieldInfo where
    type AttrBaseTypeConstraint GeometryWidthIncFieldInfo = (~) Geometry
    type AttrAllowedOps GeometryWidthIncFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint GeometryWidthIncFieldInfo = (~) Int32
    type AttrTransferTypeConstraint GeometryWidthIncFieldInfo = (~)Int32
    type AttrTransferType GeometryWidthIncFieldInfo = Int32
    type AttrGetType GeometryWidthIncFieldInfo = Int32
    type AttrLabel GeometryWidthIncFieldInfo = "width_inc"
    type AttrOrigin GeometryWidthIncFieldInfo = Geometry
    attrGet = getGeometryWidthInc
    attrSet = setGeometryWidthInc
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.Geometry.widthInc"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-Geometry.html#g:attr:widthInc"
        })

geometry_widthInc :: AttrLabelProxy "widthInc"
geometry_widthInc = AttrLabelProxy

#endif


-- | Get the value of the “@height_inc@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' geometry #heightInc
-- @
getGeometryHeightInc :: MonadIO m => Geometry -> m Int32
getGeometryHeightInc s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 28) :: IO Int32
    return val

-- | Set the value of the “@height_inc@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' geometry [ #heightInc 'Data.GI.Base.Attributes.:=' value ]
-- @
setGeometryHeightInc :: MonadIO m => Geometry -> Int32 -> m ()
setGeometryHeightInc s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 28) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data GeometryHeightIncFieldInfo
instance AttrInfo GeometryHeightIncFieldInfo where
    type AttrBaseTypeConstraint GeometryHeightIncFieldInfo = (~) Geometry
    type AttrAllowedOps GeometryHeightIncFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint GeometryHeightIncFieldInfo = (~) Int32
    type AttrTransferTypeConstraint GeometryHeightIncFieldInfo = (~)Int32
    type AttrTransferType GeometryHeightIncFieldInfo = Int32
    type AttrGetType GeometryHeightIncFieldInfo = Int32
    type AttrLabel GeometryHeightIncFieldInfo = "height_inc"
    type AttrOrigin GeometryHeightIncFieldInfo = Geometry
    attrGet = getGeometryHeightInc
    attrSet = setGeometryHeightInc
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.Geometry.heightInc"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-Geometry.html#g:attr:heightInc"
        })

geometry_heightInc :: AttrLabelProxy "heightInc"
geometry_heightInc = AttrLabelProxy

#endif


-- | Get the value of the “@min_aspect@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' geometry #minAspect
-- @
getGeometryMinAspect :: MonadIO m => Geometry -> m Double
getGeometryMinAspect s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@min_aspect@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' geometry [ #minAspect 'Data.GI.Base.Attributes.:=' value ]
-- @
setGeometryMinAspect :: MonadIO m => Geometry -> Double -> m ()
setGeometryMinAspect s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 32) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data GeometryMinAspectFieldInfo
instance AttrInfo GeometryMinAspectFieldInfo where
    type AttrBaseTypeConstraint GeometryMinAspectFieldInfo = (~) Geometry
    type AttrAllowedOps GeometryMinAspectFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint GeometryMinAspectFieldInfo = (~) Double
    type AttrTransferTypeConstraint GeometryMinAspectFieldInfo = (~)Double
    type AttrTransferType GeometryMinAspectFieldInfo = Double
    type AttrGetType GeometryMinAspectFieldInfo = Double
    type AttrLabel GeometryMinAspectFieldInfo = "min_aspect"
    type AttrOrigin GeometryMinAspectFieldInfo = Geometry
    attrGet = getGeometryMinAspect
    attrSet = setGeometryMinAspect
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.Geometry.minAspect"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-Geometry.html#g:attr:minAspect"
        })

geometry_minAspect :: AttrLabelProxy "minAspect"
geometry_minAspect = AttrLabelProxy

#endif


-- | Get the value of the “@max_aspect@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' geometry #maxAspect
-- @
getGeometryMaxAspect :: MonadIO m => Geometry -> m Double
getGeometryMaxAspect s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 40) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@max_aspect@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' geometry [ #maxAspect 'Data.GI.Base.Attributes.:=' value ]
-- @
setGeometryMaxAspect :: MonadIO m => Geometry -> Double -> m ()
setGeometryMaxAspect s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 40) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data GeometryMaxAspectFieldInfo
instance AttrInfo GeometryMaxAspectFieldInfo where
    type AttrBaseTypeConstraint GeometryMaxAspectFieldInfo = (~) Geometry
    type AttrAllowedOps GeometryMaxAspectFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint GeometryMaxAspectFieldInfo = (~) Double
    type AttrTransferTypeConstraint GeometryMaxAspectFieldInfo = (~)Double
    type AttrTransferType GeometryMaxAspectFieldInfo = Double
    type AttrGetType GeometryMaxAspectFieldInfo = Double
    type AttrLabel GeometryMaxAspectFieldInfo = "max_aspect"
    type AttrOrigin GeometryMaxAspectFieldInfo = Geometry
    attrGet = getGeometryMaxAspect
    attrSet = setGeometryMaxAspect
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.Geometry.maxAspect"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-Geometry.html#g:attr:maxAspect"
        })

geometry_maxAspect :: AttrLabelProxy "maxAspect"
geometry_maxAspect = AttrLabelProxy

#endif


-- | Get the value of the “@win_gravity@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' geometry #winGravity
-- @
getGeometryWinGravity :: MonadIO m => Geometry -> m Gdk.Enums.Gravity
getGeometryWinGravity s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 48) :: IO CUInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@win_gravity@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' geometry [ #winGravity 'Data.GI.Base.Attributes.:=' value ]
-- @
setGeometryWinGravity :: MonadIO m => Geometry -> Gdk.Enums.Gravity -> m ()
setGeometryWinGravity s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 48) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data GeometryWinGravityFieldInfo
instance AttrInfo GeometryWinGravityFieldInfo where
    type AttrBaseTypeConstraint GeometryWinGravityFieldInfo = (~) Geometry
    type AttrAllowedOps GeometryWinGravityFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint GeometryWinGravityFieldInfo = (~) Gdk.Enums.Gravity
    type AttrTransferTypeConstraint GeometryWinGravityFieldInfo = (~)Gdk.Enums.Gravity
    type AttrTransferType GeometryWinGravityFieldInfo = Gdk.Enums.Gravity
    type AttrGetType GeometryWinGravityFieldInfo = Gdk.Enums.Gravity
    type AttrLabel GeometryWinGravityFieldInfo = "win_gravity"
    type AttrOrigin GeometryWinGravityFieldInfo = Geometry
    attrGet = getGeometryWinGravity
    attrSet = setGeometryWinGravity
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.Geometry.winGravity"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-Geometry.html#g:attr:winGravity"
        })

geometry_winGravity :: AttrLabelProxy "winGravity"
geometry_winGravity = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Geometry
type instance O.AttributeList Geometry = GeometryAttributeList
type GeometryAttributeList = ('[ '("minWidth", GeometryMinWidthFieldInfo), '("minHeight", GeometryMinHeightFieldInfo), '("maxWidth", GeometryMaxWidthFieldInfo), '("maxHeight", GeometryMaxHeightFieldInfo), '("baseWidth", GeometryBaseWidthFieldInfo), '("baseHeight", GeometryBaseHeightFieldInfo), '("widthInc", GeometryWidthIncFieldInfo), '("heightInc", GeometryHeightIncFieldInfo), '("minAspect", GeometryMinAspectFieldInfo), '("maxAspect", GeometryMaxAspectFieldInfo), '("winGravity", GeometryWinGravityFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveGeometryMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveGeometryMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveGeometryMethod t Geometry, O.OverloadedMethod info Geometry p) => OL.IsLabel t (Geometry -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveGeometryMethod t Geometry, O.OverloadedMethod info Geometry p, R.HasField t Geometry p) => R.HasField t Geometry p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveGeometryMethod t Geometry, O.OverloadedMethodInfo info Geometry) => OL.IsLabel t (O.MethodProxy info Geometry) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


