/* AsyncImage.c generated by valac 0.56.17, the Vala compiler
 * generated from AsyncImage.vala, do not modify */

/*
 * Copyright 2017–2019 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include "granite.h"
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GRANITE_ASYNC_IMAGE_0_PROPERTY,
	GRANITE_ASYNC_IMAGE_LOAD_ON_REALIZE_PROPERTY,
	GRANITE_ASYNC_IMAGE_AUTO_SIZE_REQUEST_PROPERTY,
	GRANITE_ASYNC_IMAGE_GICON_ASYNC_PROPERTY,
	GRANITE_ASYNC_IMAGE_SIZE_ASYNC_PROPERTY,
	GRANITE_ASYNC_IMAGE_NUM_PROPERTIES
};
static GParamSpec* granite_async_image_properties[GRANITE_ASYNC_IMAGE_NUM_PROPERTIES];

#define GRANITE_ASYNC_IMAGE_TYPE_CACHE_ENTRY (granite_async_image_cache_entry_get_type ())
#define GRANITE_ASYNC_IMAGE_CACHE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRANITE_ASYNC_IMAGE_TYPE_CACHE_ENTRY, GraniteAsyncImageCacheEntry))
#define GRANITE_ASYNC_IMAGE_CACHE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRANITE_ASYNC_IMAGE_TYPE_CACHE_ENTRY, GraniteAsyncImageCacheEntryClass))
#define GRANITE_ASYNC_IMAGE_IS_CACHE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRANITE_ASYNC_IMAGE_TYPE_CACHE_ENTRY))
#define GRANITE_ASYNC_IMAGE_IS_CACHE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRANITE_ASYNC_IMAGE_TYPE_CACHE_ENTRY))
#define GRANITE_ASYNC_IMAGE_CACHE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRANITE_ASYNC_IMAGE_TYPE_CACHE_ENTRY, GraniteAsyncImageCacheEntryClass))

typedef struct _GraniteAsyncImageCacheEntry GraniteAsyncImageCacheEntry;
typedef struct _GraniteAsyncImageCacheEntryClass GraniteAsyncImageCacheEntryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GraniteAsyncImageSetFromGiconAsyncData GraniteAsyncImageSetFromGiconAsyncData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GraniteAsyncImageSetFromIconNameAsyncData GraniteAsyncImageSetFromIconNameAsyncData;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef struct _GraniteAsyncImageSetFromFileAsyncData GraniteAsyncImageSetFromFileAsyncData;
typedef struct _GraniteAsyncImageCacheEntryPrivate GraniteAsyncImageCacheEntryPrivate;
#define _granite_async_image_cache_entry_unref0(var) ((var == NULL) ? NULL : (var = (granite_async_image_cache_entry_unref (var), NULL)))
typedef struct _GraniteAsyncImageSetFromGiconAsyncInternalData GraniteAsyncImageSetFromGiconAsyncInternalData;
typedef struct _GraniteAsyncImageUpdateData GraniteAsyncImageUpdateData;
typedef struct _GraniteAsyncImageParamSpecCacheEntry GraniteAsyncImageParamSpecCacheEntry;

struct _GraniteAsyncImagePrivate {
	gboolean _load_on_realize;
	gboolean _auto_size_request;
	GIcon* _gicon_async;
	gint _size_async;
	gint current_scale_factor;
};

struct _GraniteAsyncImageSetFromGiconAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GraniteAsyncImage* self;
	GIcon* icon;
	gint size;
	GCancellable* cancellable;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GIcon* _tmp2_;
	gint _tmp3_;
	GError* e;
	GError* _tmp4_;
	GError* _tmp5_;
	GError* _inner_error0_;
};

struct _GraniteAsyncImageSetFromIconNameAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GraniteAsyncImage* self;
	gchar* icon_name;
	GtkIconSize icon_size;
	GCancellable* cancellable;
	gint width;
	gint height;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_;
	GThemedIcon* _tmp3_;
	GThemedIcon* _tmp4_;
	GError* e;
	GError* _tmp5_;
	GError* _tmp6_;
	GError* _inner_error0_;
};

struct _GraniteAsyncImageSetFromFileAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GraniteAsyncImage* self;
	GFile* file;
	gint width;
	gint height;
	gboolean preserve_aspect_ratio;
	GCancellable* cancellable;
	gboolean _tmp0_;
	GFileInputStream* stream;
	GFileInputStream* _tmp1_;
	GdkPixbuf* pixbuf;
	GFileInputStream* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	cairo_surface_t* _tmp5_;
	cairo_surface_t* _tmp6_;
	GError* e;
	GError* _tmp7_;
	GError* _tmp8_;
	GError* _inner_error0_;
};

struct _GraniteAsyncImageCacheEntry {
	GTypeInstance parent_instance;
	volatile int ref_count;
	gchar* icon;
	cairo_surface_t* surface;
	gint size;
	gint scale_factor;
	GraniteAsyncImageCacheEntryPrivate * priv;
};

struct _GraniteAsyncImageCacheEntryClass {
	GTypeClass parent_class;
	void (*finalize) (GraniteAsyncImageCacheEntry *self);
};

struct _GraniteAsyncImageSetFromGiconAsyncInternalData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GraniteAsyncImage* self;
	GIcon* icon;
	gint size;
	GCancellable* cancellable;
	gboolean bypass_cache;
	gboolean _tmp0_;
	gchar* target_icon;
	gchar* _tmp1_;
	GeeArrayList* _entry_list;
	GeeArrayList* _tmp2_;
	gint _entry_size;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _entry_index;
	gint _tmp6_;
	gint _tmp7_;
	GraniteAsyncImageCacheEntry* entry;
	GeeArrayList* _tmp8_;
	gpointer _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	GraniteAsyncImageCacheEntry* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GraniteAsyncImageCacheEntry* _tmp15_;
	GraniteAsyncImageCacheEntry* _tmp16_;
	GraniteAsyncImageCacheEntry* _tmp17_;
	cairo_surface_t* _tmp18_;
	GFile* _tmp19_;
	GFile* _tmp20_;
	GError* e;
	GError* _tmp21_;
	GError* _tmp22_;
	GtkStyleContext* style_context;
	GtkStyleContext* _tmp23_;
	GtkStyleContext* _tmp24_;
	GtkIconTheme* theme;
	GtkStyleContext* _tmp25_;
	GdkScreen* _tmp26_;
	GtkIconTheme* _tmp27_;
	GtkIconTheme* _tmp28_;
	GtkIconLookupFlags flags;
	GtkStyleContext* _tmp29_;
	GtkIconInfo* info;
	GtkIconTheme* _tmp30_;
	GtkIconInfo* _tmp31_;
	GtkIconInfo* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	GError* _tmp37_;
	GError* _tmp38_;
	GdkPixbuf* pixbuf;
	GtkIconInfo* _tmp39_;
	GdkPixbuf* _tmp40_;
	GtkIconInfo* _tmp41_;
	GtkStyleContext* _tmp42_;
	GdkPixbuf* _tmp43_;
	GdkPixbuf* _tmp44_;
	GdkPixbuf* _tmp45_;
	GtkIconInfo* _tmp46_;
	GdkPixbuf* _tmp47_;
	GdkPixbuf* _tmp48_;
	GdkPixbuf* _tmp49_;
	cairo_surface_t* _tmp50_;
	cairo_surface_t* _tmp51_;
	GraniteAsyncImageCacheEntry* _vala1_entry;
	gchar* _tmp52_;
	gchar* _tmp53_;
	cairo_surface_t* _tmp54_;
	cairo_surface_t* _tmp55_;
	cairo_surface_t* _tmp56_;
	GraniteAsyncImageCacheEntry* _tmp57_;
	GraniteAsyncImageCacheEntry* _tmp58_;
	GeeArrayList* _tmp59_;
	GraniteAsyncImageCacheEntry* _tmp60_;
	GError* _vala1_e;
	GError* _tmp61_;
	GError* _tmp62_;
	GError* _inner_error0_;
};

struct _GraniteAsyncImageUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GraniteAsyncImage* self;
	gboolean bypass_cache;
	gboolean _tmp0_;
	GIcon* _tmp1_;
	gboolean _tmp2_;
	GIcon* _tmp3_;
	GIcon* _tmp4_;
	GIcon* _tmp5_;
	gint _tmp6_;
	GError* e;
	GError* _tmp7_;
	const gchar* _tmp8_;
	GError* _inner_error0_;
};

struct _GraniteAsyncImageParamSpecCacheEntry {
	GParamSpec parent_instance;
};

static gint GraniteAsyncImage_private_offset;
static gpointer granite_async_image_parent_class = NULL;
static GeeArrayList* granite_async_image_cache;
static GeeArrayList* granite_async_image_cache = NULL;
static gpointer granite_async_image_cache_entry_parent_class = NULL;

static gpointer granite_async_image_cache_entry_ref (gpointer instance);
static void granite_async_image_cache_entry_unref (gpointer instance);
static GParamSpec* granite_async_image_param_spec_cache_entry (const gchar* name,
                                                        const gchar* nick,
                                                        const gchar* blurb,
                                                        GType object_type,
                                                        GParamFlags flags) G_GNUC_UNUSED ;
static void granite_async_image_value_set_cache_entry (GValue* value,
                                                gpointer v_object) G_GNUC_UNUSED ;
static void granite_async_image_value_take_cache_entry (GValue* value,
                                                 gpointer v_object) G_GNUC_UNUSED ;
static gpointer granite_async_image_value_get_cache_entry (const GValue* value) G_GNUC_UNUSED ;
static GType granite_async_image_cache_entry_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gboolean granite_async_image_get_load_on_realize (GraniteAsyncImage* self);
static gboolean granite_async_image_get_auto_size_request (GraniteAsyncImage* self);
static void granite_async_image_set_gicon_async (GraniteAsyncImage* self,
                                          GIcon* value);
static void granite_async_image_set_size_async (GraniteAsyncImage* self,
                                         gint value);
static void granite_async_image_set_from_gicon_async_data_free (gpointer _data);
static gboolean granite_async_image_set_from_gicon_async_co (GraniteAsyncImageSetFromGiconAsyncData* _data_);
static void granite_async_image_set_from_gicon_async_internal (GraniteAsyncImage* self,
                                                        GIcon* icon,
                                                        gint size,
                                                        GCancellable* cancellable,
                                                        gboolean bypass_cache,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_);
static void granite_async_image_set_from_gicon_async_internal_finish (GraniteAsyncImage* self,
                                                               GAsyncResult* _res_,
                                                               GError** error);
static void granite_async_image_set_from_gicon_async_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static void granite_async_image_set_from_icon_name_async_data_free (gpointer _data);
static gboolean granite_async_image_set_from_icon_name_async_co (GraniteAsyncImageSetFromIconNameAsyncData* _data_);
static void granite_async_image_set_from_icon_name_async_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
static void granite_async_image_set_from_file_async_data_free (gpointer _data);
static gboolean granite_async_image_set_from_file_async_co (GraniteAsyncImageSetFromFileAsyncData* _data_);
static void granite_async_image_set_from_file_async_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static void granite_async_image_reset_size_request (GraniteAsyncImage* self);
static void granite_async_image_set_from_gicon_async_internal_data_free (gpointer _data);
static gboolean granite_async_image_set_from_gicon_async_internal_co (GraniteAsyncImageSetFromGiconAsyncInternalData* _data_);
static void granite_async_image_set_from_gicon_async_internal_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_);
static GraniteAsyncImageCacheEntry* granite_async_image_cache_entry_new (const gchar* icon,
                                                                  cairo_surface_t* surface,
                                                                  gint size,
                                                                  gint scale_factor);
static GraniteAsyncImageCacheEntry* granite_async_image_cache_entry_construct (GType object_type,
                                                                        const gchar* icon,
                                                                        cairo_surface_t* surface,
                                                                        gint size,
                                                                        gint scale_factor);
static void granite_async_image_update_data_free (gpointer _data);
static void granite_async_image_update (GraniteAsyncImage* self,
                                 gboolean bypass_cache,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
static void granite_async_image_update_finish (GraniteAsyncImage* self,
                                        GAsyncResult* _res_);
static gboolean granite_async_image_update_co (GraniteAsyncImageUpdateData* _data_);
static void granite_async_image_update_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
static void granite_async_image_cache_entry_finalize (GraniteAsyncImageCacheEntry * obj);
static GType granite_async_image_cache_entry_get_type_once (void);
static GObject * granite_async_image_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void _granite_async_image____lambda14_ (GraniteAsyncImage* self);
static void __granite_async_image____lambda14__gtk_widget_realize (GtkWidget* _sender,
                                                            gpointer self);
static void _granite_async_image___lambda15_ (GraniteAsyncImage* self);
static void __granite_async_image___lambda15__gtk_widget_style_updated (GtkWidget* _sender,
                                                                 gpointer self);
static void _granite_async_image___lambda16_ (GraniteAsyncImage* self);
static void __granite_async_image___lambda16__gtk_widget_direction_changed (GtkWidget* _sender,
                                                                     GtkTextDirection previous_direction,
                                                                     gpointer self);
static void _granite_async_image___lambda17_ (GraniteAsyncImage* self);
static void __granite_async_image___lambda17__g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self);
static void granite_async_image_finalize (GObject * obj);
static GType granite_async_image_get_type_once (void);
static void _vala_granite_async_image_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_granite_async_image_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

static inline gpointer
granite_async_image_get_instance_private (GraniteAsyncImage* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteAsyncImage_private_offset);
}

static gboolean
granite_async_image_get_load_on_realize (GraniteAsyncImage* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_load_on_realize;
	return result;
}

static void
granite_async_image_set_load_on_realize (GraniteAsyncImage* self,
                                         gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_async_image_get_load_on_realize (self);
	if (old_value != value) {
		self->priv->_load_on_realize = value;
		g_object_notify_by_pspec ((GObject *) self, granite_async_image_properties[GRANITE_ASYNC_IMAGE_LOAD_ON_REALIZE_PROPERTY]);
	}
}

static gboolean
granite_async_image_get_auto_size_request (GraniteAsyncImage* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_auto_size_request;
	return result;
}

static void
granite_async_image_set_auto_size_request (GraniteAsyncImage* self,
                                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_async_image_get_auto_size_request (self);
	if (old_value != value) {
		self->priv->_auto_size_request = value;
		g_object_notify_by_pspec ((GObject *) self, granite_async_image_properties[GRANITE_ASYNC_IMAGE_AUTO_SIZE_REQUEST_PROPERTY]);
	}
}

GIcon*
granite_async_image_get_gicon_async (GraniteAsyncImage* self)
{
	GIcon* result;
	GIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gicon_async;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
granite_async_image_set_gicon_async (GraniteAsyncImage* self,
                                     GIcon* value)
{
	GIcon* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_async_image_get_gicon_async (self);
	if (old_value != value) {
		GIcon* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_gicon_async);
		self->priv->_gicon_async = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_async_image_properties[GRANITE_ASYNC_IMAGE_GICON_ASYNC_PROPERTY]);
	}
}

gint
granite_async_image_get_size_async (GraniteAsyncImage* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_size_async;
	return result;
}

static void
granite_async_image_set_size_async (GraniteAsyncImage* self,
                                    gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_async_image_get_size_async (self);
	if (old_value != value) {
		self->priv->_size_async = value;
		g_object_notify_by_pspec ((GObject *) self, granite_async_image_properties[GRANITE_ASYNC_IMAGE_SIZE_ASYNC_PROPERTY]);
	}
}

/**
     * Creates a new {@link Granite.AsyncImage} that displays
     * a requested icon or file to display asynchronously.
     *
     * The ``load_on_realize`` boolean parameter specifies if the requested image should load when
     * it's about to render and show. This is useful when you don't want to have the image data
     * loaded into memory immediately after calling {@link Granite.AsyncImage.set_from_gicon_async}.
     * Internally this parameter causes the {@link Granite.AsyncImage} to connect to the {@link Gtk.Widget.realize} signal.
     *
     * ``auto_size_request`` boolean parameter specifies if AsyncImage should allocate initial
     * space when loading the image. This is useful when the image is not yet loaded and the widget
     * should act as a placeholder until the image is loaded. Calling any of the ``set_from`` methods will
     * call the {@link Gtk.Widget.set_size_request} with the passed ``size`` or ``width`` and ``height`` if you called {@link Granite.AsyncImage.set_from_file_async}.
     * When image is loaded and shown the size request is then reset to the original values.
     *
     * @param load_on_realize if ``true`` the image will be loaded when it's rendered, false to load the image immediately
     * @param auto_size_request if the widget should act as a placeholder when the image is not yet loaded
     */
GraniteAsyncImage*
granite_async_image_construct (GType object_type,
                               gboolean load_on_realize,
                               gboolean auto_size_request)
{
	GraniteAsyncImage * self = NULL;
	self = (GraniteAsyncImage*) g_object_new (object_type, "load-on-realize", load_on_realize, "auto-size-request", auto_size_request, NULL);
	return self;
}

GraniteAsyncImage*
granite_async_image_new (gboolean load_on_realize,
                         gboolean auto_size_request)
{
	return granite_async_image_construct (GRANITE_TYPE_ASYNC_IMAGE, load_on_realize, auto_size_request);
}

/**
     * Creates a new {@link Granite.AsyncImage} with the supplied
     * ``icon`` and ``size``. See {@link Granite.AsyncImage.AsyncImage} for more details.
     *
     * This is equivalent to calling {@link Granite.AsyncImage.AsyncImage} and {@link Granite.AsyncImage.set_from_gicon_async}.
     *
     * @param icon the {@link GLib.Icon} to display in the image
     * @param size the size of the icon, ``-1`` to load the default size
     * @param load_on_realize if ``true`` the image will be loaded when it's rendered, false to load the image immediately
     * @param auto_size_request if the widget should act as a placeholder when the image is not yet loaded
     */
GraniteAsyncImage*
granite_async_image_construct_from_gicon_async (GType object_type,
                                                GIcon* icon,
                                                gint size,
                                                gboolean load_on_realize,
                                                gboolean auto_size_request)
{
	GraniteAsyncImage * self = NULL;
	g_return_val_if_fail (icon != NULL, NULL);
	self = (GraniteAsyncImage*) g_object_new (object_type, "load-on-realize", load_on_realize, "auto-size-request", auto_size_request, NULL);
	granite_async_image_set_from_gicon_async (self, icon, size, NULL, NULL, NULL);
	return self;
}

GraniteAsyncImage*
granite_async_image_new_from_gicon_async (GIcon* icon,
                                          gint size,
                                          gboolean load_on_realize,
                                          gboolean auto_size_request)
{
	return granite_async_image_construct_from_gicon_async (GRANITE_TYPE_ASYNC_IMAGE, icon, size, load_on_realize, auto_size_request);
}

/**
     * Creates a new {@link Granite.AsyncImage} with the supplied
     * ``icon_name`` and {@link Gtk.IconSize}. See {@link Granite.AsyncImage.AsyncImage} for more details.
     *
     * This is equivalent to calling {@link Granite.AsyncImage.AsyncImage} and {@link Granite.AsyncImage.set_from_icon_name_async}.
     *
     * @param icon_name the icon name to display in the image
     * @param icon_size the {@link Gtk.IconSize} as the size for the image
     * @param load_on_realize if ``true`` the image will be loaded when it's rendered, false to load the image immediately
     * @param auto_size_request if the widget should act as a placeholder when the image is not yet loaded
     */
GraniteAsyncImage*
granite_async_image_construct_from_icon_name_async (GType object_type,
                                                    const gchar* icon_name,
                                                    GtkIconSize icon_size,
                                                    gboolean load_on_realize,
                                                    gboolean auto_size_request)
{
	GraniteAsyncImage * self = NULL;
	g_return_val_if_fail (icon_name != NULL, NULL);
	self = (GraniteAsyncImage*) g_object_new (object_type, "load-on-realize", load_on_realize, "auto-size-request", auto_size_request, NULL);
	granite_async_image_set_from_icon_name_async (self, icon_name, icon_size, NULL, NULL, NULL);
	return self;
}

GraniteAsyncImage*
granite_async_image_new_from_icon_name_async (const gchar* icon_name,
                                              GtkIconSize icon_size,
                                              gboolean load_on_realize,
                                              gboolean auto_size_request)
{
	return granite_async_image_construct_from_icon_name_async (GRANITE_TYPE_ASYNC_IMAGE, icon_name, icon_size, load_on_realize, auto_size_request);
}

static void
granite_async_image_set_from_gicon_async_data_free (gpointer _data)
{
	GraniteAsyncImageSetFromGiconAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->icon);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GraniteAsyncImageSetFromGiconAsyncData, _data_);
}

void
granite_async_image_set_from_gicon_async (GraniteAsyncImage* self,
                                          GIcon* icon,
                                          gint size,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	GraniteAsyncImageSetFromGiconAsyncData* _data_;
	GraniteAsyncImage* _tmp0_;
	GIcon* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon != NULL);
	_data_ = g_slice_new0 (GraniteAsyncImageSetFromGiconAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, granite_async_image_set_from_gicon_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (icon);
	_g_object_unref0 (_data_->icon);
	_data_->icon = _tmp1_;
	_data_->size = size;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	granite_async_image_set_from_gicon_async_co (_data_);
}

void
granite_async_image_set_from_gicon_finish (GraniteAsyncImage* self,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	GraniteAsyncImageSetFromGiconAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Sets the image to display an {@link GLib.Icon} with a specified size asynchronously.
     *
     * This method sets the {@link Granite.AsyncImage.gicon_async} and {@link Granite.AsyncImage.size_async} properties
     * and depending on the {@link Granite.AsyncImage.load_on_realize} setting, loads it when the image realizes or
     * loads it immediately.
     *
     * Use {@link GLib.ThemedIcon} or {@link Granite.AsyncImage.set_from_icon_name_async} to load the image
     * from an icon name.
     *
     * If the ``icon`` is a {@link GLib.FileIcon} then the image will be loaded using  the {@link Granite.AsyncImage.set_from_file_async}
     * method with the supplied size for both ``width`` and ``height`` with preserving the aspect ratio of the image.
     *
     * If the {@link Granite.AsyncImage.load_on_realize} is ``true``, the error will never be thrown in this method since
     * the loading will happen internally in the AsyncImage when the {@link Gtk.Widget.realize} signal is invoked.
     * In this case, a warning will be printed with relevant information about a fauilure.
     *
     * @param icon the {@link GLib.Icon} to display in the image
     * @param size the size of the icon, ``0`` will clear the {@link Gtk.Image.pixbuf}, ``-1`` to load the default size
     * @param cancellable the cancellable to stop loading the icon
     *
     * @throws GLib.Error when the the icon was not found or failed to load
     */
static void
granite_async_image_set_from_gicon_async_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	GraniteAsyncImageSetFromGiconAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	granite_async_image_set_from_gicon_async_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
granite_async_image_set_from_gicon_async_co (GraniteAsyncImageSetFromGiconAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	granite_async_image_set_gicon_async (_data_->self, _data_->icon);
	granite_async_image_set_size_async (_data_->self, _data_->size);
	_data_->_tmp0_ = _data_->self->priv->_auto_size_request;
	if (_data_->_tmp0_) {
		gtk_widget_set_size_request ((GtkWidget*) _data_->self, _data_->size, _data_->size);
	}
	_data_->_tmp1_ = _data_->self->priv->_load_on_realize;
	if (!_data_->_tmp1_) {
		{
			_data_->_tmp2_ = _data_->self->priv->_gicon_async;
			_data_->_tmp3_ = _data_->self->priv->_size_async;
			_data_->_state_ = 1;
			granite_async_image_set_from_gicon_async_internal (_data_->self, _data_->_tmp2_, _data_->_tmp3_, _data_->cancellable, FALSE, granite_async_image_set_from_gicon_async_ready, _data_);
			return FALSE;
			_state_1:
			granite_async_image_set_from_gicon_async_internal_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp4_ = _data_->e;
			_data_->_tmp5_ = _g_error_copy0 (_data_->_tmp4_);
			_data_->_inner_error0_ = _data_->_tmp5_;
			_g_error_free0 (_data_->e);
			goto __finally0;
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
granite_async_image_set_from_icon_name_async_data_free (gpointer _data)
{
	GraniteAsyncImageSetFromIconNameAsyncData* _data_;
	_data_ = _data;
	_g_free0 (_data_->icon_name);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GraniteAsyncImageSetFromIconNameAsyncData, _data_);
}

void
granite_async_image_set_from_icon_name_async (GraniteAsyncImage* self,
                                              const gchar* icon_name,
                                              GtkIconSize icon_size,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	GraniteAsyncImageSetFromIconNameAsyncData* _data_;
	GraniteAsyncImage* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_name != NULL);
	_data_ = g_slice_new0 (GraniteAsyncImageSetFromIconNameAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, granite_async_image_set_from_icon_name_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (icon_name);
	_g_free0 (_data_->icon_name);
	_data_->icon_name = _tmp1_;
	_data_->icon_size = icon_size;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	granite_async_image_set_from_icon_name_async_co (_data_);
}

void
granite_async_image_set_from_icon_name_finish (GraniteAsyncImage* self,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	GraniteAsyncImageSetFromIconNameAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * A wrapper for {@link Granite.AsyncImage.set_from_gicon_async} to display an icon name.
     *
     * This is a convenience method for setting an icon name with a desired {@link Gtk.IconSize}. Note that you'll not be
     * able to change the icon size afterwards with {@link Gtk.Image.pixel_size} or {@link Gtk.Image.icon_size}. You will
     * have to call one of the {@link Granite.AsyncImage} set_from_ methods to change it's size.
     *
     * See {@link Granite.AsyncImage.set_from_gicon_async} for more details.
     *
     * @param icon_name the icon name to display in the image
     * @param icon_size the {@link Gtk.IconSize} as the size for the image
     * @param cancellable the cancellable to stop loading the icon
     *
     * @throws GLib.Error when the the icon was not found or failed to load
     */
static void
granite_async_image_set_from_icon_name_async_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	GraniteAsyncImageSetFromIconNameAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	granite_async_image_set_from_icon_name_async_co (_data_);
}

static gboolean
granite_async_image_set_from_icon_name_async_co (GraniteAsyncImageSetFromIconNameAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = 0;
	_data_->_tmp1_ = 0;
	_data_->_tmp2_ = gtk_icon_size_lookup (_data_->icon_size, &_data_->_tmp0_, &_data_->_tmp1_);
	_data_->width = _data_->_tmp0_;
	_data_->height = _data_->_tmp1_;
	if (!_data_->_tmp2_) {
		g_warning ("AsyncImage.vala:233: Invalid icon size %d", (gint) _data_->icon_size);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp3_ = (GThemedIcon*) g_themed_icon_new (_data_->icon_name);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_state_ = 1;
		granite_async_image_set_from_gicon_async (_data_->self, (GIcon*) _data_->_tmp4_, MIN (_data_->width, _data_->height), _data_->cancellable, granite_async_image_set_from_icon_name_async_ready, _data_);
		return FALSE;
		_state_1:
		granite_async_image_set_from_gicon_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp4_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp5_ = _data_->e;
		_data_->_tmp6_ = _g_error_copy0 (_data_->_tmp5_);
		_data_->_inner_error0_ = _data_->_tmp6_;
		_g_error_free0 (_data_->e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
granite_async_image_set_from_file_async_data_free (gpointer _data)
{
	GraniteAsyncImageSetFromFileAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GraniteAsyncImageSetFromFileAsyncData, _data_);
}

void
granite_async_image_set_from_file_async (GraniteAsyncImage* self,
                                         GFile* file,
                                         gint width,
                                         gint height,
                                         gboolean preserve_aspect_ratio,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	GraniteAsyncImageSetFromFileAsyncData* _data_;
	GraniteAsyncImage* _tmp0_;
	GFile* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_data_ = g_slice_new0 (GraniteAsyncImageSetFromFileAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, granite_async_image_set_from_file_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp1_;
	_data_->width = width;
	_data_->height = height;
	_data_->preserve_aspect_ratio = preserve_aspect_ratio;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	granite_async_image_set_from_file_async_co (_data_);
}

void
granite_async_image_set_from_file_finish (GraniteAsyncImage* self,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	GraniteAsyncImageSetFromFileAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Sets the image to display a {@link GLib.File} with requested width and height.
     *
     * ''Note that this method is not a wrapper to the main'' {@link Granite.AsyncImage.set_from_gicon_async} ''method''. Internally, it only creates
     * a {@link Gdk.Pixbuf} with an {@link GLib.InputStream}, loads it asynchronously and sets the {@link Gtk.Image}'s surface to the result.
     *
     * This method will reset the {@link Granite.AsyncImage.gicon_async} and {@link Granite.AsyncImage.size_async} properties to their
     * default values and will not make the {@link Granite.AsyncImage} update the image when the scale factor or icon theme changes.
     *
     * For the time that the image is loaded, the size request of the AsyncImage will be set to ``width`` and ``height`` if ``auto_size_request`` is set to ``true``
     *
     * @param file the {@link GLib.File} to display in the image
     * @param width the width of the final image, ``-1`` to not constrain the width
     * @param height the height of the final image, ``-1`` to not constrain the height
     * @param preserve_aspect_ratio ``true`` to preserve the image's aspect ratio
     * @param cancellable the cancellable to stop loading the image
     *
     * @throws GLib.Error when the the file was not found or failed to load
     */
static void
granite_async_image_set_from_file_async_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	GraniteAsyncImageSetFromFileAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	granite_async_image_set_from_file_async_co (_data_);
}

static gboolean
granite_async_image_set_from_file_async_co (GraniteAsyncImageSetFromFileAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	granite_async_image_set_gicon_async (_data_->self, NULL);
	granite_async_image_set_size_async (_data_->self, -1);
	_data_->_tmp0_ = _data_->self->priv->_auto_size_request;
	if (_data_->_tmp0_) {
		gtk_widget_set_size_request ((GtkWidget*) _data_->self, _data_->width, _data_->height);
	}
	{
		_data_->_state_ = 1;
		g_file_read_async (_data_->file, G_PRIORITY_DEFAULT, NULL, granite_async_image_set_from_file_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = g_file_read_finish (_data_->file, _data_->_res_, &_data_->_inner_error0_);
		_data_->stream = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = _data_->stream;
		_data_->_state_ = 2;
		gdk_pixbuf_new_from_stream_at_scale_async ((GInputStream*) _data_->_tmp2_, _data_->width * _data_->self->priv->current_scale_factor, _data_->height * _data_->self->priv->current_scale_factor, _data_->preserve_aspect_ratio, _data_->cancellable, granite_async_image_set_from_file_async_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp3_ = (GdkPixbuf*) gdk_pixbuf_new_from_stream_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->pixbuf = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->stream);
			goto __catch0_g_error;
		}
		_data_->_tmp4_ = _data_->pixbuf;
		_data_->_tmp5_ = gdk_cairo_surface_create_from_pixbuf (_data_->_tmp4_, _data_->self->priv->current_scale_factor, NULL);
		_data_->_tmp6_ = _data_->_tmp5_;
		g_object_set ((GtkImage*) _data_->self, "surface", _data_->_tmp6_, NULL);
		_cairo_surface_destroy0 (_data_->_tmp6_);
		granite_async_image_reset_size_request (_data_->self);
		_g_object_unref0 (_data_->pixbuf);
		_g_object_unref0 (_data_->stream);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		granite_async_image_reset_size_request (_data_->self);
		_data_->_tmp7_ = _data_->e;
		_data_->_tmp8_ = _g_error_copy0 (_data_->_tmp7_);
		_data_->_inner_error0_ = _data_->_tmp8_;
		_g_error_free0 (_data_->e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
granite_async_image_set_from_gicon_async_internal_data_free (gpointer _data)
{
	GraniteAsyncImageSetFromGiconAsyncInternalData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->icon);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GraniteAsyncImageSetFromGiconAsyncInternalData, _data_);
}

static void
granite_async_image_set_from_gicon_async_internal (GraniteAsyncImage* self,
                                                   GIcon* icon,
                                                   gint size,
                                                   GCancellable* cancellable,
                                                   gboolean bypass_cache,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_)
{
	GraniteAsyncImageSetFromGiconAsyncInternalData* _data_;
	GraniteAsyncImage* _tmp0_;
	GIcon* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon != NULL);
	_data_ = g_slice_new0 (GraniteAsyncImageSetFromGiconAsyncInternalData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, granite_async_image_set_from_gicon_async_internal_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (icon);
	_g_object_unref0 (_data_->icon);
	_data_->icon = _tmp1_;
	_data_->size = size;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	_data_->bypass_cache = bypass_cache;
	granite_async_image_set_from_gicon_async_internal_co (_data_);
}

static void
granite_async_image_set_from_gicon_async_internal_finish (GraniteAsyncImage* self,
                                                          GAsyncResult* _res_,
                                                          GError** error)
{
	GraniteAsyncImageSetFromGiconAsyncInternalData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
granite_async_image_set_from_gicon_async_internal_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_)
{
	GraniteAsyncImageSetFromGiconAsyncInternalData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	granite_async_image_set_from_gicon_async_internal_co (_data_);
}

static gboolean
granite_async_image_set_from_gicon_async_internal_co (GraniteAsyncImageSetFromGiconAsyncInternalData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->self->priv->current_scale_factor = gtk_widget_get_scale_factor ((GtkWidget*) _data_->self);
	if (_data_->size == 0) {
		gtk_image_clear ((GtkImage*) _data_->self);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		if (_data_->size != -1) {
			_data_->_tmp0_ = !_data_->bypass_cache;
		} else {
			_data_->_tmp0_ = FALSE;
		}
		if (_data_->_tmp0_) {
			_data_->_tmp1_ = g_icon_to_string (_data_->icon);
			_data_->target_icon = _data_->_tmp1_;
			{
				_data_->_tmp2_ = granite_async_image_cache;
				_data_->_entry_list = _data_->_tmp2_;
				_data_->_tmp3_ = _data_->_entry_list;
				_data_->_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp3_);
				_data_->_tmp5_ = _data_->_tmp4_;
				_data_->_entry_size = _data_->_tmp5_;
				_data_->_entry_index = -1;
				while (TRUE) {
					_data_->_entry_index = _data_->_entry_index + 1;
					_data_->_tmp6_ = _data_->_entry_index;
					_data_->_tmp7_ = _data_->_entry_size;
					if (!(_data_->_tmp6_ < _data_->_tmp7_)) {
						break;
					}
					_data_->_tmp8_ = _data_->_entry_list;
					_data_->_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp8_, _data_->_entry_index);
					_data_->entry = (GraniteAsyncImageCacheEntry*) _data_->_tmp9_;
					_data_->_tmp12_ = _data_->entry;
					_data_->_tmp13_ = _data_->_tmp12_->icon;
					_data_->_tmp14_ = _data_->target_icon;
					if (g_strcmp0 (_data_->_tmp13_, _data_->_tmp14_) == 0) {
						_data_->_tmp15_ = _data_->entry;
						_data_->_tmp11_ = _data_->_tmp15_->size == _data_->size;
					} else {
						_data_->_tmp11_ = FALSE;
					}
					if (_data_->_tmp11_) {
						_data_->_tmp16_ = _data_->entry;
						_data_->_tmp10_ = _data_->_tmp16_->scale_factor == _data_->self->priv->current_scale_factor;
					} else {
						_data_->_tmp10_ = FALSE;
					}
					if (_data_->_tmp10_) {
						_data_->_tmp17_ = _data_->entry;
						_data_->_tmp18_ = _data_->_tmp17_->surface;
						g_object_set ((GtkImage*) _data_->self, "surface", _data_->_tmp18_, NULL);
						granite_async_image_reset_size_request (_data_->self);
						_granite_async_image_cache_entry_unref0 (_data_->entry);
						_g_free0 (_data_->target_icon);
						g_task_return_pointer (_data_->_async_result, _data_, NULL);
						if (_data_->_state_ != 0) {
							while (!g_task_get_completed (_data_->_async_result)) {
								g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
							}
						}
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					_granite_async_image_cache_entry_unref0 (_data_->entry);
				}
			}
			_g_free0 (_data_->target_icon);
		}
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->icon, g_file_icon_get_type ())) {
		{
			_data_->_tmp19_ = g_file_icon_get_file (G_TYPE_CHECK_INSTANCE_CAST (_data_->icon, g_file_icon_get_type (), GFileIcon));
			_data_->_tmp20_ = _data_->_tmp19_;
			_data_->_state_ = 1;
			granite_async_image_set_from_file_async (_data_->self, _data_->_tmp20_, _data_->size, _data_->size, TRUE, NULL, granite_async_image_set_from_gicon_async_internal_ready, _data_);
			return FALSE;
			_state_1:
			granite_async_image_set_from_file_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp21_ = _data_->e;
			_data_->_tmp22_ = _g_error_copy0 (_data_->_tmp21_);
			_data_->_inner_error0_ = _data_->_tmp22_;
			_g_error_free0 (_data_->e);
			goto __finally0;
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp23_ = gtk_widget_get_style_context ((GtkWidget*) _data_->self);
	_data_->_tmp24_ = _g_object_ref0 (_data_->_tmp23_);
	_data_->style_context = _data_->_tmp24_;
	_data_->_tmp25_ = _data_->style_context;
	_data_->_tmp26_ = gtk_style_context_get_screen (_data_->_tmp25_);
	_data_->_tmp27_ = gtk_icon_theme_get_for_screen (_data_->_tmp26_);
	_data_->_tmp28_ = _g_object_ref0 (_data_->_tmp27_);
	_data_->theme = _data_->_tmp28_;
	_data_->flags = GTK_ICON_LOOKUP_FORCE_SIZE | GTK_ICON_LOOKUP_USE_BUILTIN;
	_data_->_tmp29_ = _data_->style_context;
	if ((gtk_style_context_get_state (_data_->_tmp29_) & GTK_STATE_FLAG_DIR_RTL) == GTK_STATE_FLAG_DIR_RTL) {
		_data_->flags |= GTK_ICON_LOOKUP_DIR_RTL;
	} else {
		_data_->flags |= GTK_ICON_LOOKUP_DIR_LTR;
	}
	_data_->_tmp30_ = _data_->theme;
	_data_->_tmp31_ = gtk_icon_theme_lookup_by_gicon_for_scale (_data_->_tmp30_, _data_->icon, _data_->size, _data_->self->priv->current_scale_factor, _data_->flags);
	_data_->info = _data_->_tmp31_;
	_data_->_tmp32_ = _data_->info;
	if (_data_->_tmp32_ == NULL) {
		granite_async_image_reset_size_request (_data_->self);
		_data_->_tmp33_ = g_icon_to_string (_data_->icon);
		_data_->_tmp34_ = _data_->_tmp33_;
		_data_->_tmp35_ = g_strdup_printf ("Failed to lookup icon \"%s\" at size %i", _data_->_tmp34_, _data_->size);
		_data_->_tmp36_ = _data_->_tmp35_;
		_data_->_tmp37_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_NOT_FOUND, _data_->_tmp36_);
		_data_->_tmp38_ = _data_->_tmp37_;
		_g_free0 (_data_->_tmp36_);
		_g_free0 (_data_->_tmp34_);
		_data_->_inner_error0_ = _data_->_tmp38_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->info);
		_g_object_unref0 (_data_->theme);
		_g_object_unref0 (_data_->style_context);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp39_ = _data_->info;
		if (gtk_icon_info_is_symbolic (_data_->_tmp39_)) {
			_data_->_tmp41_ = _data_->info;
			_data_->_tmp42_ = _data_->style_context;
			_data_->_state_ = 2;
			gtk_icon_info_load_symbolic_for_context_async (_data_->_tmp41_, _data_->_tmp42_, _data_->cancellable, granite_async_image_set_from_gicon_async_internal_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp43_ = gtk_icon_info_load_symbolic_for_context_finish (_data_->_tmp41_, _data_->_res_, NULL, &_data_->_inner_error0_);
			_data_->_tmp40_ = _data_->_tmp43_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->pixbuf);
				goto __catch1_g_error;
			}
			_data_->_tmp44_ = _data_->_tmp40_;
			_data_->_tmp40_ = NULL;
			_g_object_unref0 (_data_->pixbuf);
			_data_->pixbuf = _data_->_tmp44_;
			_g_object_unref0 (_data_->_tmp40_);
		} else {
			_data_->_tmp46_ = _data_->info;
			_data_->_state_ = 3;
			gtk_icon_info_load_icon_async (_data_->_tmp46_, NULL, granite_async_image_set_from_gicon_async_internal_ready, _data_);
			return FALSE;
			_state_3:
			_data_->_tmp47_ = gtk_icon_info_load_icon_finish (_data_->_tmp46_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp45_ = _data_->_tmp47_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->pixbuf);
				goto __catch1_g_error;
			}
			_data_->_tmp48_ = _data_->_tmp45_;
			_data_->_tmp45_ = NULL;
			_g_object_unref0 (_data_->pixbuf);
			_data_->pixbuf = _data_->_tmp48_;
			_g_object_unref0 (_data_->_tmp45_);
		}
		_data_->_tmp49_ = _data_->pixbuf;
		_data_->_tmp50_ = gdk_cairo_surface_create_from_pixbuf (_data_->_tmp49_, _data_->self->priv->current_scale_factor, NULL);
		_data_->_tmp51_ = _data_->_tmp50_;
		g_object_set ((GtkImage*) _data_->self, "surface", _data_->_tmp51_, NULL);
		_cairo_surface_destroy0 (_data_->_tmp51_);
		granite_async_image_reset_size_request (_data_->self);
		_data_->_tmp52_ = g_icon_to_string (_data_->icon);
		_data_->_tmp53_ = _data_->_tmp52_;
		g_object_get ((GtkImage*) _data_->self, "surface", &_data_->_tmp54_, NULL);
		_data_->_tmp55_ = _data_->_tmp54_;
		_data_->_tmp56_ = _data_->_tmp55_;
		_data_->_tmp57_ = granite_async_image_cache_entry_new (_data_->_tmp53_, _data_->_tmp56_, _data_->size, _data_->self->priv->current_scale_factor);
		_data_->_tmp58_ = _data_->_tmp57_;
		_cairo_surface_destroy0 (_data_->_tmp56_);
		_g_free0 (_data_->_tmp53_);
		_data_->_vala1_entry = _data_->_tmp58_;
		_data_->_tmp59_ = granite_async_image_cache;
		_data_->_tmp60_ = _data_->_vala1_entry;
		gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp59_, _data_->_tmp60_);
		_granite_async_image_cache_entry_unref0 (_data_->_vala1_entry);
		_g_object_unref0 (_data_->pixbuf);
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		granite_async_image_reset_size_request (_data_->self);
		_data_->_tmp61_ = _data_->_vala1_e;
		_data_->_tmp62_ = _g_error_copy0 (_data_->_tmp61_);
		_data_->_inner_error0_ = _data_->_tmp62_;
		_g_error_free0 (_data_->_vala1_e);
		goto __finally1;
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->info);
		_g_object_unref0 (_data_->theme);
		_g_object_unref0 (_data_->style_context);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->info);
	_g_object_unref0 (_data_->theme);
	_g_object_unref0 (_data_->style_context);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
granite_async_image_update_data_free (gpointer _data)
{
	GraniteAsyncImageUpdateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GraniteAsyncImageUpdateData, _data_);
}

static void
granite_async_image_update (GraniteAsyncImage* self,
                            gboolean bypass_cache,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	GraniteAsyncImageUpdateData* _data_;
	GraniteAsyncImage* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GraniteAsyncImageUpdateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, granite_async_image_update_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->bypass_cache = bypass_cache;
	granite_async_image_update_co (_data_);
}

static void
granite_async_image_update_finish (GraniteAsyncImage* self,
                                   GAsyncResult* _res_)
{
	GraniteAsyncImageUpdateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
granite_async_image_update_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	GraniteAsyncImageUpdateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	granite_async_image_update_co (_data_);
}

static gboolean
granite_async_image_update_co (GraniteAsyncImageUpdateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->self->priv->_gicon_async;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp3_ = _data_->self->priv->_gicon_async;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp3_, g_themed_icon_get_type ())) {
			_data_->_tmp2_ = TRUE;
		} else {
			_data_->_tmp4_ = _data_->self->priv->_gicon_async;
			_data_->_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp4_, g_file_icon_get_type ());
		}
		_data_->_tmp0_ = _data_->_tmp2_;
	} else {
		_data_->_tmp0_ = FALSE;
	}
	if (_data_->_tmp0_) {
		{
			_data_->_tmp5_ = _data_->self->priv->_gicon_async;
			_data_->_tmp6_ = _data_->self->priv->_size_async;
			_data_->_state_ = 1;
			granite_async_image_set_from_gicon_async_internal (_data_->self, _data_->_tmp5_, _data_->_tmp6_, NULL, _data_->bypass_cache, granite_async_image_update_ready, _data_);
			return FALSE;
			_state_1:
			granite_async_image_set_from_gicon_async_internal_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp7_ = _data_->e;
			_data_->_tmp8_ = _data_->_tmp7_->message;
			g_warning ("AsyncImage.vala:370: %s", _data_->_tmp8_);
			_g_error_free0 (_data_->e);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
granite_async_image_reset_size_request (GraniteAsyncImage* self)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_auto_size_request;
	if (_tmp0_) {
		gtk_widget_set_size_request ((GtkWidget*) self, -1, -1);
	}
}

static gpointer
_cairo_surface_reference0 (gpointer self)
{
	return self ? cairo_surface_reference (self) : NULL;
}

static GraniteAsyncImageCacheEntry*
granite_async_image_cache_entry_construct (GType object_type,
                                           const gchar* icon,
                                           cairo_surface_t* surface,
                                           gint size,
                                           gint scale_factor)
{
	GraniteAsyncImageCacheEntry* self = NULL;
	gchar* _tmp0_;
	cairo_surface_t* _tmp1_;
	g_return_val_if_fail (icon != NULL, NULL);
	self = (GraniteAsyncImageCacheEntry*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (icon);
	_g_free0 (self->icon);
	self->icon = _tmp0_;
	_tmp1_ = _cairo_surface_reference0 (surface);
	_cairo_surface_destroy0 (self->surface);
	self->surface = _tmp1_;
	self->size = size;
	self->scale_factor = scale_factor;
	return self;
}

static GraniteAsyncImageCacheEntry*
granite_async_image_cache_entry_new (const gchar* icon,
                                     cairo_surface_t* surface,
                                     gint size,
                                     gint scale_factor)
{
	return granite_async_image_cache_entry_construct (GRANITE_ASYNC_IMAGE_TYPE_CACHE_ENTRY, icon, surface, size, scale_factor);
}

static void
granite_async_image_value_cache_entry_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
granite_async_image_value_cache_entry_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		granite_async_image_cache_entry_unref (value->data[0].v_pointer);
	}
}

static void
granite_async_image_value_cache_entry_copy_value (const GValue* src_value,
                                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = granite_async_image_cache_entry_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
granite_async_image_value_cache_entry_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
granite_async_image_value_cache_entry_collect_value (GValue* value,
                                                     guint n_collect_values,
                                                     GTypeCValue* collect_values,
                                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GraniteAsyncImageCacheEntry * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = granite_async_image_cache_entry_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
granite_async_image_value_cache_entry_lcopy_value (const GValue* value,
                                                   guint n_collect_values,
                                                   GTypeCValue* collect_values,
                                                   guint collect_flags)
{
	GraniteAsyncImageCacheEntry ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = granite_async_image_cache_entry_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
granite_async_image_param_spec_cache_entry (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags)
{
	GraniteAsyncImageParamSpecCacheEntry* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GRANITE_ASYNC_IMAGE_TYPE_CACHE_ENTRY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
granite_async_image_value_get_cache_entry (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRANITE_ASYNC_IMAGE_TYPE_CACHE_ENTRY), NULL);
	return value->data[0].v_pointer;
}

static void
granite_async_image_value_set_cache_entry (GValue* value,
                                           gpointer v_object)
{
	GraniteAsyncImageCacheEntry * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRANITE_ASYNC_IMAGE_TYPE_CACHE_ENTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GRANITE_ASYNC_IMAGE_TYPE_CACHE_ENTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		granite_async_image_cache_entry_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		granite_async_image_cache_entry_unref (old);
	}
}

static void
granite_async_image_value_take_cache_entry (GValue* value,
                                            gpointer v_object)
{
	GraniteAsyncImageCacheEntry * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRANITE_ASYNC_IMAGE_TYPE_CACHE_ENTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GRANITE_ASYNC_IMAGE_TYPE_CACHE_ENTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		granite_async_image_cache_entry_unref (old);
	}
}

static void
granite_async_image_cache_entry_class_init (GraniteAsyncImageCacheEntryClass * klass,
                                            gpointer klass_data)
{
	granite_async_image_cache_entry_parent_class = g_type_class_peek_parent (klass);
	((GraniteAsyncImageCacheEntryClass *) klass)->finalize = granite_async_image_cache_entry_finalize;
}

static void
granite_async_image_cache_entry_instance_init (GraniteAsyncImageCacheEntry * self,
                                               gpointer klass)
{
	self->ref_count = 1;
}

static void
granite_async_image_cache_entry_finalize (GraniteAsyncImageCacheEntry * obj)
{
	GraniteAsyncImageCacheEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_ASYNC_IMAGE_TYPE_CACHE_ENTRY, GraniteAsyncImageCacheEntry);
	g_signal_handlers_destroy (self);
	_g_free0 (self->icon);
	_cairo_surface_destroy0 (self->surface);
}

static GType
granite_async_image_cache_entry_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { granite_async_image_value_cache_entry_init, granite_async_image_value_cache_entry_free_value, granite_async_image_value_cache_entry_copy_value, granite_async_image_value_cache_entry_peek_pointer, "p", granite_async_image_value_cache_entry_collect_value, "p", granite_async_image_value_cache_entry_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GraniteAsyncImageCacheEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_async_image_cache_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteAsyncImageCacheEntry), 0, (GInstanceInitFunc) granite_async_image_cache_entry_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType granite_async_image_cache_entry_type_id;
	granite_async_image_cache_entry_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GraniteAsyncImageCacheEntry", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return granite_async_image_cache_entry_type_id;
}

static GType
granite_async_image_cache_entry_get_type (void)
{
	static volatile gsize granite_async_image_cache_entry_type_id__once = 0;
	if (g_once_init_enter (&granite_async_image_cache_entry_type_id__once)) {
		GType granite_async_image_cache_entry_type_id;
		granite_async_image_cache_entry_type_id = granite_async_image_cache_entry_get_type_once ();
		g_once_init_leave (&granite_async_image_cache_entry_type_id__once, granite_async_image_cache_entry_type_id);
	}
	return granite_async_image_cache_entry_type_id__once;
}

static gpointer
granite_async_image_cache_entry_ref (gpointer instance)
{
	GraniteAsyncImageCacheEntry * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
granite_async_image_cache_entry_unref (gpointer instance)
{
	GraniteAsyncImageCacheEntry * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GRANITE_ASYNC_IMAGE_CACHE_ENTRY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_granite_async_image____lambda14_ (GraniteAsyncImage* self)
{
	granite_async_image_update (self, FALSE, NULL, NULL);
}

static void
__granite_async_image____lambda14__gtk_widget_realize (GtkWidget* _sender,
                                                       gpointer self)
{
	_granite_async_image____lambda14_ ((GraniteAsyncImage*) self);
}

static void
_granite_async_image___lambda15_ (GraniteAsyncImage* self)
{
	if (gtk_widget_get_realized ((GtkWidget*) self)) {
		granite_async_image_update (self, TRUE, NULL, NULL);
	}
}

static void
__granite_async_image___lambda15__gtk_widget_style_updated (GtkWidget* _sender,
                                                            gpointer self)
{
	_granite_async_image___lambda15_ ((GraniteAsyncImage*) self);
}

static void
_granite_async_image___lambda16_ (GraniteAsyncImage* self)
{
	granite_async_image_update (self, TRUE, NULL, NULL);
}

static void
__granite_async_image___lambda16__gtk_widget_direction_changed (GtkWidget* _sender,
                                                                GtkTextDirection previous_direction,
                                                                gpointer self)
{
	_granite_async_image___lambda16_ ((GraniteAsyncImage*) self);
}

static void
_granite_async_image___lambda17_ (GraniteAsyncImage* self)
{
	if (gtk_widget_get_scale_factor ((GtkWidget*) self) != self->priv->current_scale_factor) {
		granite_async_image_update (self, FALSE, NULL, NULL);
	}
}

static void
__granite_async_image___lambda17__g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self)
{
	_granite_async_image___lambda17_ ((GraniteAsyncImage*) self);
}

static GObject *
granite_async_image_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraniteAsyncImage * self;
	gboolean _tmp0_;
	parent_class = G_OBJECT_CLASS (granite_async_image_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_TYPE_ASYNC_IMAGE, GraniteAsyncImage);
	_tmp0_ = self->priv->_load_on_realize;
	if (_tmp0_) {
		g_signal_connect_object ((GtkWidget*) self, "realize", (GCallback) __granite_async_image____lambda14__gtk_widget_realize, self, 0);
	}
	g_signal_connect_object ((GtkWidget*) self, "style-updated", (GCallback) __granite_async_image___lambda15__gtk_widget_style_updated, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "direction-changed", (GCallback) __granite_async_image___lambda16__gtk_widget_direction_changed, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::scale-factor", (GCallback) __granite_async_image___lambda17__g_object_notify, self, 0);
	return obj;
}

static void
granite_async_image_class_init (GraniteAsyncImageClass * klass,
                                gpointer klass_data)
{
	GeeArrayList* _tmp0_;
	granite_async_image_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraniteAsyncImage_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_async_image_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_async_image_set_property;
	G_OBJECT_CLASS (klass)->constructor = granite_async_image_constructor;
	G_OBJECT_CLASS (klass)->finalize = granite_async_image_finalize;
	/**
	     * If the image should be loaded when the image is rendered.
	     *
	     * For more details see {@link Granite.AsyncImage.AsyncImage}.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_ASYNC_IMAGE_LOAD_ON_REALIZE_PROPERTY, granite_async_image_properties[GRANITE_ASYNC_IMAGE_LOAD_ON_REALIZE_PROPERTY] = g_param_spec_boolean ("load-on-realize", "load-on-realize", "load-on-realize", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * If the widget should act as a placeholder when the image is not yet loaded.
	     *
	     * For more details see {@link Granite.AsyncImage.AsyncImage}.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_ASYNC_IMAGE_AUTO_SIZE_REQUEST_PROPERTY, granite_async_image_properties[GRANITE_ASYNC_IMAGE_AUTO_SIZE_REQUEST_PROPERTY] = g_param_spec_boolean ("auto-size-request", "auto-size-request", "auto-size-request", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * The icon that will be or is currently displayed in the image.
	     *
	     * Note that this property is by default and will be ``null`` if you didn't call the {@link Granite.AsyncImage.set_from_gicon_async} or it's wrappers.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_ASYNC_IMAGE_GICON_ASYNC_PROPERTY, granite_async_image_properties[GRANITE_ASYNC_IMAGE_GICON_ASYNC_PROPERTY] = g_param_spec_object ("gicon-async", "gicon-async", "gicon-async", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The size in pixels of the displayed {@link Granite.AsyncImage.gicon_async}.
	     *
	     * Note that this property is by default and will be ``-1`` if you didn't call the {@link Granite.AsyncImage.set_from_gicon_async} or it's wrappers.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_ASYNC_IMAGE_SIZE_ASYNC_PROPERTY, granite_async_image_properties[GRANITE_ASYNC_IMAGE_SIZE_ASYNC_PROPERTY] = g_param_spec_int ("size-async", "size-async", "size-async", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	_tmp0_ = gee_array_list_new (GRANITE_ASYNC_IMAGE_TYPE_CACHE_ENTRY, (GBoxedCopyFunc) granite_async_image_cache_entry_ref, (GDestroyNotify) granite_async_image_cache_entry_unref, NULL, NULL, NULL);
	_g_object_unref0 (granite_async_image_cache);
	granite_async_image_cache = _tmp0_;
}

static void
granite_async_image_instance_init (GraniteAsyncImage * self,
                                   gpointer klass)
{
	self->priv = granite_async_image_get_instance_private (self);
	self->priv->_gicon_async = NULL;
	self->priv->_size_async = -1;
	self->priv->current_scale_factor = 1;
}

static void
granite_async_image_finalize (GObject * obj)
{
	GraniteAsyncImage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_TYPE_ASYNC_IMAGE, GraniteAsyncImage);
	_g_object_unref0 (self->priv->_gicon_async);
	G_OBJECT_CLASS (granite_async_image_parent_class)->finalize (obj);
}

/**
 * AsyncImage is a {@link Gtk.Image} that provides a way to load
 * icons and images asynchronously without blocking the main GTK thread.
 *
 * AsyncImage can be used to improve your GTK interface's performance that
 * has a lot of images to load and populate e.g: the applications menu and
 * an icon chooser.
 *
 * Primarily the {@link Gtk.Image} loads it's surface synchronously and blocks the main GTK thread
 * which can cause significant slow downs and lagging. The AsyncImage is a wrapper for the {@link Gtk.Image}
 * and provides with two main methods: {@link Granite.AsyncImage.set_from_gicon_async} and {@link Granite.AsyncImage.set_from_file_async}.
 *
 * AsyncImage internally operates only on {@link Gdk.Pixbuf} and {@link Cairo.Surface}'s which means that you cannot read valid properties
 * from the main {@link Gtk.Image} like {@link Gtk.Image.icon_name}, {@link Gtk.Image.gicon} or {@link Gtk.Image.file}.
 * The only property which will be set is the final surface: {@link Gtk.Image.surface}.
 *
 * Even though AsyncImage sets only the {@link Gtk.Image.surface}, it automatically detects changes to the underlying {@link Gtk.Widget.scale_factor}
 * and reloads the icon to a new scale factor when it changes. If you request to set an {@link GLib.ThemedIcon} and the icon or GTK theme changes
 * the AsyncImage will also reload it to display the new icon with applied changes.
 *
 * The {@link Granite.AsyncImage.gicon_async} and {@link Granite.AsyncImage.size_async} are properties which reflect
 * the current icon and it's size which will or is currently displayed. Note that those two properties will return
 * meaningful results //''only''// when you call {@link Granite.AsyncImage.set_from_gicon_async} and it's wrappers.
 *
 * AsyncImage has also its own cache for already loaded icons. If you attempt to load the same icon at the same size
 * AsyncImage will look it up and if it's available, will set it immediately.
 *
 * If you want to detect when the image was actually loaded into the {@link Cairo.Surface} you can connect to
 * the {@link GLib.Object.notify} signal for {@link Gtk.Image.surface}.
 */
static GType
granite_async_image_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteAsyncImageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_async_image_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteAsyncImage), 0, (GInstanceInitFunc) granite_async_image_instance_init, NULL };
	GType granite_async_image_type_id;
	granite_async_image_type_id = g_type_register_static (gtk_image_get_type (), "GraniteAsyncImage", &g_define_type_info, 0);
	GraniteAsyncImage_private_offset = g_type_add_instance_private (granite_async_image_type_id, sizeof (GraniteAsyncImagePrivate));
	return granite_async_image_type_id;
}

GType
granite_async_image_get_type (void)
{
	static volatile gsize granite_async_image_type_id__once = 0;
	if (g_once_init_enter (&granite_async_image_type_id__once)) {
		GType granite_async_image_type_id;
		granite_async_image_type_id = granite_async_image_get_type_once ();
		g_once_init_leave (&granite_async_image_type_id__once, granite_async_image_type_id);
	}
	return granite_async_image_type_id__once;
}

static void
_vala_granite_async_image_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	GraniteAsyncImage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_TYPE_ASYNC_IMAGE, GraniteAsyncImage);
	switch (property_id) {
		case GRANITE_ASYNC_IMAGE_LOAD_ON_REALIZE_PROPERTY:
		g_value_set_boolean (value, granite_async_image_get_load_on_realize (self));
		break;
		case GRANITE_ASYNC_IMAGE_AUTO_SIZE_REQUEST_PROPERTY:
		g_value_set_boolean (value, granite_async_image_get_auto_size_request (self));
		break;
		case GRANITE_ASYNC_IMAGE_GICON_ASYNC_PROPERTY:
		g_value_set_object (value, granite_async_image_get_gicon_async (self));
		break;
		case GRANITE_ASYNC_IMAGE_SIZE_ASYNC_PROPERTY:
		g_value_set_int (value, granite_async_image_get_size_async (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_granite_async_image_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	GraniteAsyncImage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_TYPE_ASYNC_IMAGE, GraniteAsyncImage);
	switch (property_id) {
		case GRANITE_ASYNC_IMAGE_LOAD_ON_REALIZE_PROPERTY:
		granite_async_image_set_load_on_realize (self, g_value_get_boolean (value));
		break;
		case GRANITE_ASYNC_IMAGE_AUTO_SIZE_REQUEST_PROPERTY:
		granite_async_image_set_auto_size_request (self, g_value_get_boolean (value));
		break;
		case GRANITE_ASYNC_IMAGE_GICON_ASYNC_PROPERTY:
		granite_async_image_set_gicon_async (self, g_value_get_object (value));
		break;
		case GRANITE_ASYNC_IMAGE_SIZE_ASYNC_PROPERTY:
		granite_async_image_set_size_async (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

