/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, qtgui, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_qtgui_vector_sink_f = R"doc(A graphical sink to display multiple vector-based signals.

This is a QT-based graphical sink that plots vectors of data as-is. Each signal is plotted with a different color, and the set_title() and set_color() functions can be used to change the label and color for a given input number.


To specify units for the x- and y-axes, use the set_x_axis_units() and set_y_axis_units() functions. This does not change the x- and y-labels, which are either specified during construction, or by calling the set_x_axis_label() and set_y_axis_label() methods.

Constructor Specific Documentation:

Build a vector plotting sink.

Args:
    vlen : Vector length at input. This cannot be changed during operations.
    x_start : The x-Axis value of the first vector element
    x_step : The step with which x-Axis values increment
    x_axis_label : The X-Axis label
    y_axis_label : The Y-Axis label
    name : title for the plot
    nconnections : number of signals connected to sink
    parent : a QWidget parent object, if any)doc";


static const char* __doc_gr_qtgui_vector_sink_f_vector_sink_f_0 = R"doc()doc";


static const char* __doc_gr_qtgui_vector_sink_f_vector_sink_f_1 = R"doc()doc";


static const char* __doc_gr_qtgui_vector_sink_f_make = R"doc(A graphical sink to display multiple vector-based signals.

This is a QT-based graphical sink that plots vectors of data as-is. Each signal is plotted with a different color, and the set_title() and set_color() functions can be used to change the label and color for a given input number.


To specify units for the x- and y-axes, use the set_x_axis_units() and set_y_axis_units() functions. This does not change the x- and y-labels, which are either specified during construction, or by calling the set_x_axis_label() and set_y_axis_label() methods.

Constructor Specific Documentation:

Build a vector plotting sink.

Args:
    vlen : Vector length at input. This cannot be changed during operations.
    x_start : The x-Axis value of the first vector element
    x_step : The step with which x-Axis values increment
    x_axis_label : The X-Axis label
    y_axis_label : The Y-Axis label
    name : title for the plot
    nconnections : number of signals connected to sink
    parent : a QWidget parent object, if any)doc";


static const char* __doc_gr_qtgui_vector_sink_f_exec_ = R"doc()doc";


static const char* __doc_gr_qtgui_vector_sink_f_qwidget = R"doc()doc";


static const char* __doc_gr_qtgui_vector_sink_f_vlen = R"doc()doc";


static const char* __doc_gr_qtgui_vector_sink_f_set_vec_average = R"doc()doc";


static const char* __doc_gr_qtgui_vector_sink_f_vec_average = R"doc()doc";


static const char* __doc_gr_qtgui_vector_sink_f_set_x_axis = R"doc(Update the values on the x-Axis.)doc";


static const char* __doc_gr_qtgui_vector_sink_f_set_y_axis = R"doc()doc";


static const char* __doc_gr_qtgui_vector_sink_f_set_ref_level = R"doc(The ref level is a reference line.)doc";


static const char* __doc_gr_qtgui_vector_sink_f_set_x_axis_label = R"doc()doc";


static const char* __doc_gr_qtgui_vector_sink_f_set_y_axis_label = R"doc()doc";


static const char* __doc_gr_qtgui_vector_sink_f_set_x_axis_units = R"doc(Change the units string on the x-Axis (e.g. 'm' if x-Axis label was 'Distance').)doc";


static const char* __doc_gr_qtgui_vector_sink_f_set_y_axis_units = R"doc(Change the units string on the y-Axis (e.g. 'V' if x-Axis label was 'Amplitude').)doc";


static const char* __doc_gr_qtgui_vector_sink_f_set_update_time = R"doc()doc";


static const char* __doc_gr_qtgui_vector_sink_f_set_title = R"doc()doc";


static const char* __doc_gr_qtgui_vector_sink_f_set_line_label = R"doc()doc";


static const char* __doc_gr_qtgui_vector_sink_f_set_line_color = R"doc()doc";


static const char* __doc_gr_qtgui_vector_sink_f_set_line_width = R"doc()doc";


static const char* __doc_gr_qtgui_vector_sink_f_set_line_style = R"doc()doc";


static const char* __doc_gr_qtgui_vector_sink_f_set_line_marker = R"doc()doc";


static const char* __doc_gr_qtgui_vector_sink_f_set_line_alpha = R"doc()doc";


static const char* __doc_gr_qtgui_vector_sink_f_title = R"doc()doc";


static const char* __doc_gr_qtgui_vector_sink_f_line_label = R"doc()doc";


static const char* __doc_gr_qtgui_vector_sink_f_line_color = R"doc()doc";


static const char* __doc_gr_qtgui_vector_sink_f_line_width = R"doc()doc";


static const char* __doc_gr_qtgui_vector_sink_f_line_style = R"doc()doc";


static const char* __doc_gr_qtgui_vector_sink_f_line_marker = R"doc()doc";


static const char* __doc_gr_qtgui_vector_sink_f_line_alpha = R"doc()doc";


static const char* __doc_gr_qtgui_vector_sink_f_set_size = R"doc()doc";


static const char* __doc_gr_qtgui_vector_sink_f_enable_menu = R"doc()doc";


static const char* __doc_gr_qtgui_vector_sink_f_disable_legend = R"doc()doc";


static const char* __doc_gr_qtgui_vector_sink_f_enable_grid = R"doc()doc";


static const char* __doc_gr_qtgui_vector_sink_f_enable_autoscale = R"doc()doc";


static const char* __doc_gr_qtgui_vector_sink_f_clear_max_hold = R"doc()doc";


static const char* __doc_gr_qtgui_vector_sink_f_clear_min_hold = R"doc()doc";


static const char* __doc_gr_qtgui_vector_sink_f_reset = R"doc()doc";
