/* context.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from context.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright © 2014 Nikhar Agrawal
 * Copyright © 2015 Michael Catanzaro <mcatanzaro@gnome.org>
 *
 * This file is part of libgnome-games-support.
 *
 * libgnome-games-support is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * libgnome-games-support is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with libgnome-games-support.  If not, see <http://www.gnu.org/licenses/>.
 */
/* Remove workaround once https://gitlab.gnome.org/GNOME/vala/-/issues/1429 is fixed. */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib.h>
#include "libgnome-games-support.h"
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <errno.h>
#include <adwaita.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>

#define GAMES_SCORES_DIALOG_STYLE "\n" \
"dialog.scores columnview {\n" \
"    background: transparent;\n" \
"}\n" \
"\n" \
"dialog.scores columnview header button,\n" \
"dialog.scores columnview row cell {\n" \
"    padding-left: 12px;\n" \
"    padding-right: 12px;\n" \
"}\n"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GAMES_SCORES_CONTEXT_0_PROPERTY,
	GAMES_SCORES_CONTEXT_APP_NAME_PROPERTY,
	GAMES_SCORES_CONTEXT_CATEGORY_TYPE_PROPERTY,
	GAMES_SCORES_CONTEXT_STYLE_PROPERTY,
	GAMES_SCORES_CONTEXT_ICON_NAME_PROPERTY,
	GAMES_SCORES_CONTEXT_MAX_HIGH_SCORES_PROPERTY,
	GAMES_SCORES_CONTEXT_NUM_PROPERTIES
};
static GParamSpec* games_scores_context_properties[GAMES_SCORES_CONTEXT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _GamesScoresContextSaveScoreToFileData GamesScoresContextSaveScoreToFileData;
typedef struct _Block4Data Block4Data;

#define GAMES_SCORES_TYPE_DIALOG (games_scores_dialog_get_type ())
#define GAMES_SCORES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialog))
#define GAMES_SCORES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialogClass))
#define GAMES_SCORES_IS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_SCORES_TYPE_DIALOG))
#define GAMES_SCORES_IS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_SCORES_TYPE_DIALOG))
#define GAMES_SCORES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialogClass))

typedef struct _GamesScoresDialog GamesScoresDialog;
typedef struct _GamesScoresDialogClass GamesScoresDialogClass;
typedef struct _GamesScoresContextAddScoreData GamesScoresContextAddScoreData;
typedef struct _Block5Data Block5Data;
typedef struct _GamesScoresContextAddScoreFullData GamesScoresContextAddScoreFullData;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
typedef struct _Block6Data Block6Data;
enum  {
	GAMES_SCORES_CONTEXT_DIALOG_CLOSED_SIGNAL,
	GAMES_SCORES_CONTEXT_NUM_SIGNALS
};
static guint games_scores_context_signals[GAMES_SCORES_CONTEXT_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GamesScoresContextPrivate {
	gchar* _app_name;
	gchar* _category_type;
	GamesScoresStyle _style;
	gchar* _icon_name;
	gint _max_high_scores;
	GamesScoresCategory* current_category;
	GHashTable* scores_per_category;
	gchar* user_score_dir;
	gboolean scores_loaded;
	GamesScoresContextCategoryRequestFunc category_request;
	gpointer category_request_target;
	GDestroyNotify category_request_target_destroy_notify;
};

struct _Block2Data {
	int _ref_count_;
	GamesScoresContext* self;
	GamesScoresContextCategoryRequestFunc category_request;
	gpointer category_request_target;
};

struct _Block3Data {
	int _ref_count_;
	GPtrArray* self;
	GCompareFunc compare_func;
};

struct _GamesScoresContextSaveScoreToFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GamesScoresContext* self;
	GamesScoresScore* score;
	GamesScoresCategory* category;
	GCancellable* cancellable;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GError* _tmp3_;
	GFile* file;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	GFileOutputStream* stream;
	GFile* _tmp11_;
	GFileOutputStream* _tmp12_;
	gchar* line;
	glong _tmp13_;
	glong _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gint64 _tmp20_;
	gint64 _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	GFileOutputStream* _tmp29_;
	const gchar* _tmp30_;
	guint8* _tmp31_;
	gint _tmp31__length1;
	gint _tmp32_;
	guint8* _tmp33_;
	gint _tmp33__length1;
	GError* _inner_error0_;
};

struct _Block4Data {
	int _ref_count_;
	GamesScoresContext* self;
	gpointer _async_data_;
};

struct _GamesScoresContextAddScoreData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GamesScoresContext* self;
	glong score;
	GamesScoresCategory* category;
	GtkWindow* game_window;
	GCancellable* cancellable;
	gboolean result;
	Block4Data* _data4_;
	GamesScoresScore* the_score;
	GamesScoresScore* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	GamesScoresCategory* _tmp3_;
	GPtrArray* _tmp4_;
	GHashTable* _tmp5_;
	gconstpointer _tmp6_;
	GamesScoresScore* _tmp7_;
	GamesScoresScore* _tmp8_;
	GamesScoresCategory* _tmp9_;
	gboolean high_score_added;
	GamesScoresScore* _tmp10_;
	glong _tmp11_;
	glong _tmp12_;
	gboolean _tmp13_;
	GamesScoresDialog* dialog;
	const gchar* _tmp14_;
	GamesScoresStyle _tmp15_;
	GamesScoresScore* _tmp16_;
	GamesScoresCategory* _tmp17_;
	const gchar* _tmp18_;
	GamesScoresDialog* _tmp19_;
	GamesScoresDialog* _tmp20_;
	GamesScoresDialog* _tmp21_;
	GamesScoresScore* _tmp22_;
	GError* _inner_error0_;
};

struct _Block5Data {
	int _ref_count_;
	GamesScoresContext* self;
	gpointer _async_data_;
};

struct _GamesScoresContextAddScoreFullData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GamesScoresContext* self;
	glong score_value;
	GamesScoresCategory* category;
	gchar* extra_info;
	GtkWindow* game_window;
	GamesScoresContextNewGameFunc new_game_func;
	gpointer new_game_func_target;
	GamesScoresContextQuitAppFunc quit_app_func;
	gpointer quit_app_func_target;
	GCancellable* cancellable;
	gboolean result;
	Block5Data* _data5_;
	GamesScoresScore* score;
	GamesScoresScore* _tmp0_;
	GamesScoresScore* _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GamesScoresCategory* _tmp4_;
	GPtrArray* _tmp5_;
	GHashTable* _tmp6_;
	gconstpointer _tmp7_;
	GamesScoresScore* _tmp8_;
	GamesScoresScore* _tmp9_;
	GamesScoresCategory* _tmp10_;
	gboolean high_score_added;
	GamesScoresScore* _tmp11_;
	glong _tmp12_;
	glong _tmp13_;
	gboolean _tmp14_;
	GamesScoresDialog* dialog;
	const gchar* _tmp15_;
	GamesScoresStyle _tmp16_;
	GamesScoresScore* _tmp17_;
	GamesScoresCategory* _tmp18_;
	const gchar* _tmp19_;
	GamesScoresDialog* _tmp20_;
	GamesScoresDialog* _tmp21_;
	GamesScoresDialog* _tmp22_;
	gboolean _tmp23_;
	GamesScoresDialog* _tmp24_;
	GamesScoresScore* _tmp25_;
	GError* _inner_error0_;
};

struct _Block6Data {
	int _ref_count_;
	GamesScoresContext* self;
	GamesScoresContextCategoryRequestFunc category_request;
	gpointer category_request_target;
};

static gint GamesScoresContext_private_offset;
static gpointer games_scores_context_parent_class = NULL;

static guint _games_scores_context_scores_per_category_lambda6_ (GamesScoresCategory* a);
static guint __games_scores_context_scores_per_category_lambda6__ghash_func (gconstpointer key);
static gboolean _games_scores_context_scores_per_category_lambda7_ (GamesScoresCategory* a,
                                                             GamesScoresCategory* b);
static gboolean __games_scores_context_scores_per_category_lambda7__gequal_func (gconstpointer a,
                                                                          gconstpointer b);
static void _g_object_unref0_ (gpointer var);
static void _g_ptr_array_unref0_ (gpointer var);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static GamesScoresCategory* __lambda8_ (Block2Data* _data2_,
                                 const gchar* key);
static GamesScoresCategory* ___lambda8__games_scores_context_category_request_func (const gchar* category_key,
                                                                             gpointer self);
static void games_scores_context_load_scores_from_files (GamesScoresContext* self,
                                                  GError** error);
static void games_scores_context_real_constructed (GObject* base);
static gint __lambda9_ (GamesScoresCategory* a,
                 GamesScoresCategory* b);
static gint ___lambda9__gcompare_func (gconstpointer a,
                                gconstpointer b);
static void _vala_array_add1 (GamesScoresCategory** * array,
                       gint* length,
                       gint* size,
                       GamesScoresCategory* value);
VALA_EXTERN void games_scores_context_update_score_name (GamesScoresContext* self,
                                             GamesScoresScore* old_score,
                                             GamesScoresCategory* category,
                                             const gchar* new_name);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gint ___lambda0__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self);
VALA_EXTERN gint games_scores_score_score_greater_sorter (GamesScoresScore* a,
                                              GamesScoresScore* b);
static gint _games_scores_score_score_greater_sorter_gcompare_func (gconstpointer a,
                                                             gconstpointer b);
VALA_EXTERN gint games_scores_score_score_less_sorter (GamesScoresScore* a,
                                           GamesScoresScore* b);
static gint _games_scores_score_score_less_sorter_gcompare_func (gconstpointer a,
                                                          gconstpointer b);
static void _vala_array_add2 (GamesScoresScore** * array,
                       gint* length,
                       gint* size,
                       GamesScoresScore* value);
static gboolean games_scores_context_is_high_score (GamesScoresContext* self,
                                             glong score_value,
                                             GamesScoresCategory* category);
static void games_scores_context_save_score_to_file_data_free (gpointer _data);
static void games_scores_context_save_score_to_file (GamesScoresContext* self,
                                              GamesScoresScore* score,
                                              GamesScoresCategory* category,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static void games_scores_context_save_score_to_file_finish (GamesScoresContext* self,
                                                     GAsyncResult* _res_,
                                                     GError** error);
static gboolean games_scores_context_save_score_to_file_co (GamesScoresContextSaveScoreToFileData* _data_);
VALA_EXTERN gchar* games_scores_score_get_internal_extra_info (GamesScoresScore* self);
static void games_scores_context_save_score_to_file_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static void games_scores_context_add_score_data_free (gpointer _data);
static gboolean games_scores_context_add_score_co (GamesScoresContextAddScoreData* _data_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
VALA_EXTERN GType games_scores_dialog_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesScoresDialog* games_scores_dialog_new (GamesScoresContext* context,
                                            const gchar* category_type,
                                            GamesScoresStyle style,
                                            GamesScoresScore* new_high_score,
                                            GamesScoresCategory* current_cat,
                                            const gchar* icon_name);
VALA_EXTERN GamesScoresDialog* games_scores_dialog_construct (GType object_type,
                                                  GamesScoresContext* context,
                                                  const gchar* category_type,
                                                  GamesScoresStyle style,
                                                  GamesScoresScore* new_high_score,
                                                  GamesScoresCategory* current_cat,
                                                  const gchar* icon_name);
static void ___lambda27_ (Block4Data* _data4_);
static void ____lambda27__adw_dialog_closed (AdwDialog* _sender,
                                      gpointer self);
static void games_scores_context_add_score_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static void games_scores_context_add_score_full_data_free (gpointer _data);
static gboolean games_scores_context_add_score_full_co (GamesScoresContextAddScoreFullData* _data_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void ___lambda28_ (Block5Data* _data5_);
static void ____lambda28__adw_dialog_closed (AdwDialog* _sender,
                                      gpointer self);
VALA_EXTERN void games_scores_dialog_add_bottom_buttons (GamesScoresDialog* self,
                                             GamesScoresContextNewGameFunc new_game_func,
                                             gpointer new_game_func_target,
                                             GamesScoresContextQuitAppFunc quit_app_func,
                                             gpointer quit_app_func_target);
static void games_scores_context_add_score_full_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void games_scores_context_load_scores_from_file (GamesScoresContext* self,
                                                 GFileInfo* file_info,
                                                 GError** error);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static GamesScoresCategory* __lambda29_ (Block6Data* _data6_,
                                  const gchar* key);
static GamesScoresCategory* ___lambda29__games_scores_context_category_request_func (const gchar* category_key,
                                                                              gpointer self);
static void __lambda30_ (GamesScoresContext* self);
static void ___lambda30__adw_dialog_closed (AdwDialog* _sender,
                                     gpointer self);
static void games_scores_context_finalize (GObject * obj);
static GType games_scores_context_get_type_once (void);
static void _vala_games_scores_context_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_games_scores_context_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

/**
 * The style that a {@link Games.Scores.Score} uses.
 *
 * This tells the score dialog if it should display the scores as a time or as points.
 *
 * It also tells the score dialog if a larger or smaller score should get a higher ranking.
 *
 */
static GType
games_scores_style_get_type_once (void)
{
	static const GEnumValue values[] = {{GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER, "GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER", "points-greater-is-better"}, {GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER, "GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER", "points-less-is-better"}, {GAMES_SCORES_STYLE_TIME_GREATER_IS_BETTER, "GAMES_SCORES_STYLE_TIME_GREATER_IS_BETTER", "time-greater-is-better"}, {GAMES_SCORES_STYLE_TIME_LESS_IS_BETTER, "GAMES_SCORES_STYLE_TIME_LESS_IS_BETTER", "time-less-is-better"}, {0, NULL, NULL}};
	GType games_scores_style_type_id;
	games_scores_style_type_id = g_enum_register_static ("GamesScoresStyle", values);
	return games_scores_style_type_id;
}

GType
games_scores_style_get_type (void)
{
	static volatile gsize games_scores_style_type_id__once = 0;
	if (g_once_init_enter (&games_scores_style_type_id__once)) {
		GType games_scores_style_type_id;
		games_scores_style_type_id = games_scores_style_get_type_once ();
		g_once_init_leave (&games_scores_style_type_id__once, games_scores_style_type_id);
	}
	return games_scores_style_type_id__once;
}

static inline gpointer
games_scores_context_get_instance_private (GamesScoresContext* self)
{
	return G_STRUCT_MEMBER_P (self, GamesScoresContext_private_offset);
}

static guint
_games_scores_context_scores_per_category_lambda6_ (GamesScoresCategory* a)
{
	GHashFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	guint result;
	g_return_val_if_fail (a != NULL, 0U);
	_tmp0_ = g_str_hash;
	_tmp1_ = games_scores_category_get_key (a);
	_tmp2_ = _tmp1_;
	result = _tmp0_ (_tmp2_);
	return result;
}

static guint
__games_scores_context_scores_per_category_lambda6__ghash_func (gconstpointer key)
{
	guint result;
	result = _games_scores_context_scores_per_category_lambda6_ ((GamesScoresCategory*) key);
	return result;
}

static gboolean
_games_scores_context_scores_per_category_lambda7_ (GamesScoresCategory* a,
                                                    GamesScoresCategory* b)
{
	GEqualFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp0_ = g_str_equal;
	_tmp1_ = games_scores_category_get_key (a);
	_tmp2_ = _tmp1_;
	_tmp3_ = games_scores_category_get_key (b);
	_tmp4_ = _tmp3_;
	result = _tmp0_ (_tmp2_, _tmp4_);
	return result;
}

static gboolean
__games_scores_context_scores_per_category_lambda7__gequal_func (gconstpointer a,
                                                                 gconstpointer b)
{
	gboolean result;
	result = _games_scores_context_scores_per_category_lambda7_ ((GamesScoresCategory*) a, (GamesScoresCategory*) b);
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_g_ptr_array_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL));
}

/**
     * Creates a new Context.
     *
     * ``app_name`` is your App ID (e.g. ``org.gnome.Mines``).
     *
     * ``category_type`` describes all of the categories (e.g. "Minefield", "Level").
     *
     * ``category_request`` is a function that takes a category key and produces the user-facing name for it.
     *
     * ``style changes`` the way {@link Games.Scores.Score}s are presented.
     *
     * ``icon_name`` is the ID for your app's icon (e.g. ``org.gnome.Quadrapassel``).
     *
     * ``max_high_scores`` is the maximum size of the high score list in the score dialog (``-1`` for unlimited).
     *
     */
static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		GamesScoresContext* self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static GamesScoresCategory*
__lambda8_ (Block2Data* _data2_,
            const gchar* key)
{
	GamesScoresContext* self;
	GamesScoresCategory* _tmp0_;
	GamesScoresCategory* result;
	self = _data2_->self;
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = _data2_->category_request (key, _data2_->category_request_target);
	result = _tmp0_;
	return result;
}

static GamesScoresCategory*
___lambda8__games_scores_context_category_request_func (const gchar* category_key,
                                                        gpointer self)
{
	GamesScoresCategory* result;
	result = __lambda8_ (self, category_key);
	return result;
}

GamesScoresContext*
games_scores_context_construct (GType object_type,
                                const gchar* app_name,
                                const gchar* category_type,
                                GamesScoresContextCategoryRequestFunc category_request,
                                gpointer category_request_target,
                                GamesScoresStyle style,
                                const gchar* icon_name,
                                gint max_high_scores)
{
	GamesScoresContext * self = NULL;
	Block2Data* _data2_;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (app_name != NULL, NULL);
	g_return_val_if_fail (category_type != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->category_request = category_request;
	_data2_->category_request_target = category_request_target;
	_tmp0_ = icon_name;
	if (_tmp0_ == NULL) {
		_tmp0_ = app_name;
	}
	if (max_high_scores <= -1) {
		_tmp1_ = G_MAXINT;
	} else {
		_tmp1_ = max_high_scores;
	}
	self = (GamesScoresContext*) g_object_new (object_type, "app-name", app_name, "category-type", category_type, "style", style, "icon-name", _tmp0_, "max-high-scores", _tmp1_, NULL);
	_data2_->self = g_object_ref (self);
	(self->priv->category_request_target_destroy_notify == NULL) ? NULL : (self->priv->category_request_target_destroy_notify (self->priv->category_request_target), NULL);
	self->priv->category_request = NULL;
	self->priv->category_request_target = NULL;
	self->priv->category_request_target_destroy_notify = NULL;
	self->priv->category_request = ___lambda8__games_scores_context_category_request_func;
	self->priv->category_request_target = block2_data_ref (_data2_);
	self->priv->category_request_target_destroy_notify = block2_data_unref;
	{
		games_scores_context_load_scores_from_files (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("context.vala:172: Failed to load scores: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		block2_data_unref (_data2_);
		_data2_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	(self->priv->category_request_target_destroy_notify == NULL) ? NULL : (self->priv->category_request_target_destroy_notify (self->priv->category_request_target), NULL);
	self->priv->category_request = NULL;
	self->priv->category_request_target = NULL;
	self->priv->category_request_target_destroy_notify = NULL;
	self->priv->category_request = NULL;
	self->priv->category_request_target = NULL;
	self->priv->category_request_target_destroy_notify = NULL;
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return self;
}

GamesScoresContext*
games_scores_context_new (const gchar* app_name,
                          const gchar* category_type,
                          GamesScoresContextCategoryRequestFunc category_request,
                          gpointer category_request_target,
                          GamesScoresStyle style,
                          const gchar* icon_name,
                          gint max_high_scores)
{
	return games_scores_context_construct (GAMES_SCORES_TYPE_CONTEXT, app_name, category_type, category_request, category_request_target, style, icon_name, max_high_scores);
}

static void
games_scores_context_real_constructed (GObject* base)
{
	GamesScoresContext * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	self = (GamesScoresContext*) base;
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = self->priv->_app_name;
	_tmp2_ = g_build_filename (_tmp0_, _tmp1_, "scores", NULL, NULL);
	_g_free0 (self->priv->user_score_dir);
	self->priv->user_score_dir = _tmp2_;
}

static gint
__lambda9_ (GamesScoresCategory* a,
            GamesScoresCategory* b)
{
	gchar* key_1 = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* key_2 = NULL;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GCompareFunc _tmp6_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = games_scores_category_get_name (a);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_collate_key_for_filename (_tmp1_, (gssize) -1);
	key_1 = _tmp2_;
	_tmp3_ = games_scores_category_get_name (b);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_utf8_collate_key_for_filename (_tmp4_, (gssize) -1);
	key_2 = _tmp5_;
	_tmp6_ = ((GCompareFunc) g_strcmp0);
	result = _tmp6_ (key_1, key_2);
	_g_free0 (key_2);
	_g_free0 (key_1);
	return result;
}

static gint
___lambda9__gcompare_func (gconstpointer a,
                           gconstpointer b)
{
	gint result;
	result = __lambda9_ ((GamesScoresCategory*) a, (GamesScoresCategory*) b);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_vala_array_add1 (GamesScoresCategory** * array,
                  gint* length,
                  gint* size,
                  GamesScoresCategory* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesScoresCategory*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

GamesScoresCategory**
games_scores_context_get_categories (GamesScoresContext* self,
                                     gint* result_length1)
{
	GList* categories = NULL;
	GHashTable* _tmp0_;
	GList* _tmp1_;
	GamesScoresCategory** cat_array = NULL;
	GamesScoresCategory** _tmp2_;
	gint cat_array_length1;
	gint _cat_array_size_;
	GList* _tmp3_;
	GamesScoresCategory** _tmp6_;
	gint _tmp6__length1;
	GamesScoresCategory** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->scores_per_category;
	_tmp1_ = g_hash_table_get_keys (_tmp0_);
	categories = _tmp1_;
	categories = g_list_sort (categories, ___lambda9__gcompare_func);
	_tmp2_ = g_new0 (GamesScoresCategory*, 0 + 1);
	cat_array = _tmp2_;
	cat_array_length1 = 0;
	_cat_array_size_ = cat_array_length1;
	_tmp3_ = categories;
	{
		GList* category_collection = NULL;
		GList* category_it = NULL;
		category_collection = _tmp3_;
		for (category_it = category_collection; category_it != NULL; category_it = category_it->next) {
			GamesScoresCategory* category = NULL;
			category = (GamesScoresCategory*) category_it->data;
			{
				GamesScoresCategory* _tmp4_;
				GamesScoresCategory* _tmp5_;
				_tmp4_ = category;
				_tmp5_ = _g_object_ref0 (_tmp4_);
				_vala_array_add1 (&cat_array, &cat_array_length1, &_cat_array_size_, _tmp5_);
			}
		}
	}
	_tmp6_ = cat_array;
	_tmp6__length1 = cat_array_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	(categories == NULL) ? NULL : (categories = (g_list_free (categories), NULL));
	return result;
}

void
games_scores_context_update_score_name (GamesScoresContext* self,
                                        GamesScoresScore* old_score,
                                        GamesScoresCategory* category,
                                        const gchar* new_name)
{
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (old_score != NULL);
	g_return_if_fail (category != NULL);
	g_return_if_fail (new_name != NULL);
	_tmp0_ = self->priv->scores_per_category;
	_tmp1_ = g_hash_table_lookup (_tmp0_, category);
	{
		GPtrArray* score_collection = NULL;
		guint score_index = 0U;
		score_collection = (GPtrArray*) _tmp1_;
		for (score_index = 0; score_index < score_collection->len; score_index = score_index + 1) {
			GamesScoresScore* _tmp2_;
			GamesScoresScore* score = NULL;
			_tmp2_ = _g_object_ref0 ((GamesScoresScore*) g_ptr_array_index (score_collection, score_index));
			score = _tmp2_;
			{
				GamesScoresScore* _tmp3_;
				_tmp3_ = score;
				if (games_scores_score_equals (_tmp3_, old_score)) {
					GamesScoresScore* _tmp4_;
					_tmp4_ = score;
					games_scores_score_set_user (_tmp4_, new_name);
					_g_object_unref0 (score);
					return;
				}
				_g_object_unref0 (score);
			}
		}
	}
	g_assert_not_reached ();
}

/**
     * Get the best n scores from the given category, sorted.
     *
     */
static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		GPtrArray* self;
		self = _data3_->self;
		_g_ptr_array_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gint
__lambda0_ (Block3Data* _data3_,
            gconstpointer** a,
            gconstpointer** b)
{
	GPtrArray* self;
	gint result;
	self = _data3_->self;
	result = _data3_->compare_func ((gconstpointer**) (*a), (gconstpointer**) (*b));
	return result;
}

static gint
___lambda0__gcompare_data_func (gconstpointer a,
                                gconstpointer b,
                                gpointer self)
{
	gint result;
	result = __lambda0_ (self, a, b);
	return result;
}

static void
vala_g_ptr_array_sort (GPtrArray* self,
                       GCompareFunc compare_func)
{
	Block3Data* _data3_;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_ptr_array_ref (self);
	_data3_->compare_func = compare_func;
	g_ptr_array_sort_with_data (self, ___lambda0__gcompare_data_func, _data3_);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static gint
_games_scores_score_score_greater_sorter_gcompare_func (gconstpointer a,
                                                        gconstpointer b)
{
	gint result;
	result = games_scores_score_score_greater_sorter ((GamesScoresScore*) a, (GamesScoresScore*) b);
	return result;
}

static gint
_games_scores_score_score_less_sorter_gcompare_func (gconstpointer a,
                                                     gconstpointer b)
{
	gint result;
	result = games_scores_score_score_less_sorter ((GamesScoresScore*) a, (GamesScoresScore*) b);
	return result;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static void
_vala_array_add2 (GamesScoresScore** * array,
                  gint* length,
                  gint* size,
                  GamesScoresScore* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesScoresScore*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

GamesScoresScore**
games_scores_context_get_high_scores (GamesScoresContext* self,
                                      GamesScoresCategory* category,
                                      gint n,
                                      gint* result_length1)
{
	GamesScoresScore** _result_ = NULL;
	GamesScoresScore** _tmp0_;
	gint _result__length1;
	gint __result__size_;
	GHashTable* _tmp1_;
	GPtrArray* scores = NULL;
	GHashTable* _tmp3_;
	gconstpointer _tmp4_;
	gboolean _tmp5_ = FALSE;
	GamesScoresStyle _tmp6_;
	GamesScoresScore** _tmp25_;
	gint _tmp25__length1;
	GamesScoresScore** result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (category != NULL, NULL);
	_tmp0_ = g_new0 (GamesScoresScore*, 0 + 1);
	_result_ = _tmp0_;
	_result__length1 = 0;
	__result__size_ = _result__length1;
	_tmp1_ = self->priv->scores_per_category;
	if (!g_hash_table_contains (_tmp1_, category)) {
		GamesScoresScore** _tmp2_;
		gint _tmp2__length1;
		_tmp2_ = _result_;
		_tmp2__length1 = _result__length1;
		if (result_length1) {
			*result_length1 = _tmp2__length1;
		}
		result = _tmp2_;
		return result;
	}
	_tmp3_ = self->priv->scores_per_category;
	_tmp4_ = g_hash_table_lookup (_tmp3_, category);
	scores = (GPtrArray*) _tmp4_;
	_tmp6_ = self->priv->_style;
	if (_tmp6_ == GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER) {
		_tmp5_ = TRUE;
	} else {
		GamesScoresStyle _tmp7_;
		_tmp7_ = self->priv->_style;
		_tmp5_ = _tmp7_ == GAMES_SCORES_STYLE_TIME_GREATER_IS_BETTER;
	}
	if (_tmp5_) {
		GHashTable* _tmp8_;
		gconstpointer _tmp9_;
		_tmp8_ = self->priv->scores_per_category;
		_tmp9_ = g_hash_table_lookup (_tmp8_, category);
		vala_g_ptr_array_sort ((GPtrArray*) _tmp9_, _games_scores_score_score_greater_sorter_gcompare_func);
	} else {
		GHashTable* _tmp10_;
		gconstpointer _tmp11_;
		_tmp10_ = self->priv->scores_per_category;
		_tmp11_ = g_hash_table_lookup (_tmp10_, category);
		vala_g_ptr_array_sort ((GPtrArray*) _tmp11_, _games_scores_score_score_less_sorter_gcompare_func);
	}
	if (n <= -1) {
		gint _tmp12_;
		_tmp12_ = self->priv->_max_high_scores;
		n = _tmp12_;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp13_ = FALSE;
			_tmp13_ = TRUE;
			while (TRUE) {
				gboolean _tmp15_ = FALSE;
				GamesScoresScore* score = NULL;
				GPtrArray* _tmp19_;
				gconstpointer _tmp20_;
				GamesScoresScore* _tmp21_;
				GamesScoresScore* _tmp22_;
				GamesScoresScore* _tmp23_;
				GamesScoresScore* _tmp24_;
				if (!_tmp13_) {
					gint _tmp14_;
					_tmp14_ = i;
					i = _tmp14_ + 1;
				}
				_tmp13_ = FALSE;
				if (i < n) {
					GPtrArray* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp16_ = scores;
					_tmp17_ = vala_g_ptr_array_get_length (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp15_ = i < _tmp18_;
				} else {
					_tmp15_ = FALSE;
				}
				if (!_tmp15_) {
					break;
				}
				_tmp19_ = scores;
				_tmp20_ = g_ptr_array_index (_tmp19_, (guint) i);
				_tmp21_ = _g_object_ref0 ((GamesScoresScore*) _tmp20_);
				score = _tmp21_;
				_tmp22_ = score;
				_tmp22_->rank = (guint) (i + 1);
				_tmp23_ = score;
				_tmp24_ = _g_object_ref0 (_tmp23_);
				_vala_array_add2 (&_result_, &_result__length1, &__result__size_, _tmp24_);
				_g_object_unref0 (score);
			}
		}
	}
	_tmp25_ = _result_;
	_tmp25__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp25__length1;
	}
	result = _tmp25_;
	return result;
}

static gboolean
games_scores_context_is_high_score (GamesScoresContext* self,
                                    glong score_value,
                                    GamesScoresCategory* category)
{
	GamesScoresScore** best_scores = NULL;
	gint _tmp0_ = 0;
	GamesScoresScore** _tmp1_;
	gint best_scores_length1;
	gint _best_scores_size_;
	GamesScoresScore** _tmp2_;
	gint _tmp2__length1;
	GamesScoresScore** _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_;
	glong lowest = 0L;
	GamesScoresScore** _tmp5_;
	gint _tmp5__length1;
	gint _tmp6_;
	GamesScoresScore* _tmp7_;
	glong _tmp8_;
	glong _tmp9_;
	gboolean _tmp10_ = FALSE;
	GamesScoresStyle _tmp11_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (category != NULL, FALSE);
	_tmp1_ = games_scores_context_get_high_scores (self, category, -1, &_tmp0_);
	best_scores = _tmp1_;
	best_scores_length1 = _tmp0_;
	_best_scores_size_ = best_scores_length1;
	_tmp2_ = best_scores;
	_tmp2__length1 = best_scores_length1;
	if (_tmp2_ == NULL) {
		result = TRUE;
		best_scores = (_vala_array_free (best_scores, best_scores_length1, (GDestroyNotify) g_object_unref), NULL);
		return result;
	}
	_tmp3_ = best_scores;
	_tmp3__length1 = best_scores_length1;
	_tmp4_ = self->priv->_max_high_scores;
	if (_tmp3__length1 < _tmp4_) {
		result = TRUE;
		best_scores = (_vala_array_free (best_scores, best_scores_length1, (GDestroyNotify) g_object_unref), NULL);
		return result;
	}
	_tmp5_ = best_scores;
	_tmp5__length1 = best_scores_length1;
	_tmp6_ = self->priv->_max_high_scores;
	_tmp7_ = _tmp5_[_tmp6_ - 1];
	_tmp8_ = games_scores_score_get_score (_tmp7_);
	_tmp9_ = _tmp8_;
	lowest = _tmp9_;
	_tmp11_ = self->priv->_style;
	if (_tmp11_ == GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER) {
		_tmp10_ = TRUE;
	} else {
		GamesScoresStyle _tmp12_;
		_tmp12_ = self->priv->_style;
		_tmp10_ = _tmp12_ == GAMES_SCORES_STYLE_TIME_LESS_IS_BETTER;
	}
	if (_tmp10_) {
		result = score_value < lowest;
		best_scores = (_vala_array_free (best_scores, best_scores_length1, (GDestroyNotify) g_object_unref), NULL);
		return result;
	}
	result = score_value > lowest;
	best_scores = (_vala_array_free (best_scores, best_scores_length1, (GDestroyNotify) g_object_unref), NULL);
	return result;
}

static void
games_scores_context_save_score_to_file_data_free (gpointer _data)
{
	GamesScoresContextSaveScoreToFileData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->score);
	_g_object_unref0 (_data_->category);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesScoresContextSaveScoreToFileData, _data_);
}

static void
games_scores_context_save_score_to_file (GamesScoresContext* self,
                                         GamesScoresScore* score,
                                         GamesScoresCategory* category,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	GamesScoresContextSaveScoreToFileData* _data_;
	GamesScoresContext* _tmp0_;
	GamesScoresScore* _tmp1_;
	GamesScoresCategory* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (score != NULL);
	g_return_if_fail (category != NULL);
	_data_ = g_slice_new0 (GamesScoresContextSaveScoreToFileData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, games_scores_context_save_score_to_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (score);
	_g_object_unref0 (_data_->score);
	_data_->score = _tmp1_;
	_tmp2_ = _g_object_ref0 (category);
	_g_object_unref0 (_data_->category);
	_data_->category = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	games_scores_context_save_score_to_file_co (_data_);
}

static void
games_scores_context_save_score_to_file_finish (GamesScoresContext* self,
                                                GAsyncResult* _res_,
                                                GError** error)
{
	GamesScoresContextSaveScoreToFileData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
games_scores_context_save_score_to_file_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	GamesScoresContextSaveScoreToFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	games_scores_context_save_score_to_file_co (_data_);
}

static gboolean
games_scores_context_save_score_to_file_co (GamesScoresContextSaveScoreToFileData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->user_score_dir;
	if (g_mkdir_with_parents (_data_->_tmp0_, 0766) == -1) {
		_data_->_tmp1_ = _data_->self->priv->user_score_dir;
		_data_->_tmp2_ = g_strerror (errno);
		_data_->_tmp3_ = g_error_new (G_FILE_ERROR, G_FILE_ERROR_FAILED, "Failed to create %s: %s", _data_->_tmp1_, _data_->_tmp2_);
		_data_->_inner_error0_ = _data_->_tmp3_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->self->priv->user_score_dir;
	_data_->_tmp5_ = games_scores_category_get_key (_data_->category);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = g_build_filename (_data_->_tmp4_, _data_->_tmp6_, NULL);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = g_file_new_for_path (_data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	_g_free0 (_data_->_tmp8_);
	_data_->file = _data_->_tmp10_;
	_data_->_tmp11_ = _data_->file;
	_data_->_tmp12_ = g_file_append_to (_data_->_tmp11_, G_FILE_CREATE_NONE, NULL, &_data_->_inner_error0_);
	_data_->stream = _data_->_tmp12_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->file);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = games_scores_score_get_score (_data_->score);
	_data_->_tmp14_ = _data_->_tmp13_;
	_data_->_tmp15_ = g_strdup_printf ("%li", _data_->_tmp14_);
	_data_->_tmp16_ = _data_->_tmp15_;
	_data_->_tmp17_ = games_scores_score_get_internal_extra_info (_data_->score);
	_data_->_tmp18_ = _data_->_tmp17_;
	_data_->_tmp19_ = string_to_string (_data_->_tmp18_);
	_data_->_tmp20_ = games_scores_score_get_time (_data_->score);
	_data_->_tmp21_ = _data_->_tmp20_;
	_data_->_tmp22_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp21_);
	_data_->_tmp23_ = _data_->_tmp22_;
	_data_->_tmp24_ = games_scores_score_get_user (_data_->score);
	_data_->_tmp25_ = _data_->_tmp24_;
	_data_->_tmp26_ = string_to_string (_data_->_tmp25_);
	_data_->_tmp27_ = g_strconcat (_data_->_tmp16_, _data_->_tmp19_, " ", _data_->_tmp23_, " ", _data_->_tmp26_, "\n", NULL);
	_data_->_tmp28_ = _data_->_tmp27_;
	_g_free0 (_data_->_tmp23_);
	_g_free0 (_data_->_tmp18_);
	_g_free0 (_data_->_tmp16_);
	_data_->line = _data_->_tmp28_;
	_data_->_tmp29_ = _data_->stream;
	_data_->_tmp30_ = _data_->line;
	_data_->_tmp32_ = 0;
	_data_->_tmp31_ = string_get_data (_data_->_tmp30_, &_data_->_tmp32_);
	_data_->_tmp31__length1 = _data_->_tmp32_;
	_data_->_tmp33_ = _data_->_tmp31_;
	_data_->_tmp33__length1 = _data_->_tmp31__length1;
	_data_->_state_ = 1;
	g_output_stream_write_all_async ((GOutputStream*) _data_->_tmp29_, _data_->_tmp33_, (gsize) _data_->_tmp33__length1, G_PRIORITY_DEFAULT, _data_->cancellable, games_scores_context_save_score_to_file_ready, _data_);
	return FALSE;
	_state_1:
	g_output_stream_write_all_finish ((GOutputStream*) _data_->_tmp29_, _data_->_res_, NULL, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->line);
		_g_object_unref0 (_data_->stream);
		_g_object_unref0 (_data_->file);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_free0 (_data_->line);
	_g_object_unref0 (_data_->stream);
	_g_object_unref0 (_data_->file);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
games_scores_context_add_score_data_free (gpointer _data)
{
	GamesScoresContextAddScoreData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->category);
	_g_object_unref0 (_data_->game_window);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesScoresContextAddScoreData, _data_);
}

void
games_scores_context_add_score (GamesScoresContext* self,
                                glong score,
                                GamesScoresCategory* category,
                                GtkWindow* game_window,
                                GCancellable* cancellable,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	GamesScoresContextAddScoreData* _data_;
	GamesScoresContext* _tmp0_;
	GamesScoresCategory* _tmp1_;
	GtkWindow* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (category != NULL);
	_data_ = g_slice_new0 (GamesScoresContextAddScoreData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, games_scores_context_add_score_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->score = score;
	_tmp1_ = _g_object_ref0 (category);
	_g_object_unref0 (_data_->category);
	_data_->category = _tmp1_;
	_tmp2_ = _g_object_ref0 (game_window);
	_g_object_unref0 (_data_->game_window);
	_data_->game_window = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	games_scores_context_add_score_co (_data_);
}

gboolean
games_scores_context_add_score_finish (GamesScoresContext* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	gboolean result;
	GamesScoresContextAddScoreData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

/**
     * Returns true if a dialog was launched on attaining high score.
     *
     */
static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		GamesScoresContext* self;
		self = _data4_->self;
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
___lambda27_ (Block4Data* _data4_)
{
	GamesScoresContext* self;
	self = _data4_->self;
	games_scores_context_add_score_co (_data4_->_async_data_);
}

static void
____lambda27__adw_dialog_closed (AdwDialog* _sender,
                                 gpointer self)
{
	___lambda27_ (self);
}

static void
games_scores_context_add_score_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	GamesScoresContextAddScoreData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	games_scores_context_add_score_co (_data_);
}

static gboolean
games_scores_context_add_score_co (GamesScoresContextAddScoreData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data4_ = g_slice_new0 (Block4Data);
	_data_->_data4_->_ref_count_ = 1;
	_data_->_data4_->self = g_object_ref (_data_->self);
	_data_->_data4_->_async_data_ = _data_;
	_data_->_tmp0_ = games_scores_score_new (_data_->score, (gint64) 0, NULL);
	_data_->the_score = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->priv->scores_per_category;
	if (!g_hash_table_contains (_data_->_tmp1_, _data_->category)) {
		_data_->_tmp2_ = _data_->self->priv->scores_per_category;
		_data_->_tmp3_ = _g_object_ref0 (_data_->category);
		_data_->_tmp4_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
		g_hash_table_insert (_data_->_tmp2_, _data_->_tmp3_, _data_->_tmp4_);
	}
	_data_->_tmp5_ = _data_->self->priv->scores_per_category;
	_data_->_tmp6_ = g_hash_table_lookup (_data_->_tmp5_, _data_->category);
	_data_->_tmp7_ = _data_->the_score;
	_data_->_tmp8_ = _g_object_ref0 (_data_->_tmp7_);
	g_ptr_array_add ((GPtrArray*) _data_->_tmp6_, _data_->_tmp8_);
	_data_->_tmp9_ = _g_object_ref0 (_data_->category);
	_g_object_unref0 (_data_->self->priv->current_category);
	_data_->self->priv->current_category = _data_->_tmp9_;
	_data_->_tmp10_ = _data_->the_score;
	_data_->_tmp11_ = games_scores_score_get_score (_data_->_tmp10_);
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->high_score_added = games_scores_context_is_high_score (_data_->self, _data_->_tmp12_, _data_->category);
	if (_data_->high_score_added) {
		_data_->_tmp13_ = _data_->game_window != NULL;
	} else {
		_data_->_tmp13_ = FALSE;
	}
	if (_data_->_tmp13_) {
		_data_->_tmp14_ = _data_->self->priv->_category_type;
		_data_->_tmp15_ = _data_->self->priv->_style;
		_data_->_tmp16_ = _data_->the_score;
		_data_->_tmp17_ = _data_->self->priv->current_category;
		_data_->_tmp18_ = _data_->self->priv->_icon_name;
		_data_->_tmp19_ = games_scores_dialog_new (_data_->self, _data_->_tmp14_, _data_->_tmp15_, _data_->_tmp16_, _data_->_tmp17_, _data_->_tmp18_);
		g_object_ref_sink (_data_->_tmp19_);
		_data_->dialog = _data_->_tmp19_;
		_data_->_tmp20_ = _data_->dialog;
		g_signal_connect_data ((AdwDialog*) _data_->_tmp20_, "closed", (GCallback) ____lambda27__adw_dialog_closed, block4_data_ref (_data_->_data4_), (GClosureNotify) block4_data_unref, 0);
		_data_->_tmp21_ = _data_->dialog;
		adw_dialog_present ((AdwDialog*) _data_->_tmp21_, (GtkWidget*) _data_->game_window);
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		_g_object_unref0 (_data_->dialog);
	}
	_data_->_tmp22_ = _data_->the_score;
	_data_->_state_ = 2;
	games_scores_context_save_score_to_file (_data_->self, _data_->_tmp22_, _data_->category, _data_->cancellable, games_scores_context_add_score_ready, _data_);
	return FALSE;
	_state_2:
	games_scores_context_save_score_to_file_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->the_score);
		block4_data_unref (_data_->_data4_);
		_data_->_data4_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->high_score_added;
	_g_object_unref0 (_data_->the_score);
	block4_data_unref (_data_->_data4_);
	_data_->_data4_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
games_scores_context_add_score_full_data_free (gpointer _data)
{
	GamesScoresContextAddScoreFullData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->category);
	_g_free0 (_data_->extra_info);
	_g_object_unref0 (_data_->game_window);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesScoresContextAddScoreFullData, _data_);
}

void
games_scores_context_add_score_full (GamesScoresContext* self,
                                     glong score_value,
                                     GamesScoresCategory* category,
                                     const gchar* extra_info,
                                     GtkWindow* game_window,
                                     GamesScoresContextNewGameFunc new_game_func,
                                     gpointer new_game_func_target,
                                     GamesScoresContextQuitAppFunc quit_app_func,
                                     gpointer quit_app_func_target,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	GamesScoresContextAddScoreFullData* _data_;
	GamesScoresContext* _tmp0_;
	GamesScoresCategory* _tmp1_;
	gchar* _tmp2_;
	GtkWindow* _tmp3_;
	GCancellable* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (category != NULL);
	_data_ = g_slice_new0 (GamesScoresContextAddScoreFullData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, games_scores_context_add_score_full_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->score_value = score_value;
	_tmp1_ = _g_object_ref0 (category);
	_g_object_unref0 (_data_->category);
	_data_->category = _tmp1_;
	_tmp2_ = g_strdup (extra_info);
	_g_free0 (_data_->extra_info);
	_data_->extra_info = _tmp2_;
	_tmp3_ = _g_object_ref0 (game_window);
	_g_object_unref0 (_data_->game_window);
	_data_->game_window = _tmp3_;
	_data_->new_game_func = new_game_func;
	_data_->new_game_func_target = new_game_func_target;
	_data_->quit_app_func = quit_app_func;
	_data_->quit_app_func_target = quit_app_func_target;
	_tmp4_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	games_scores_context_add_score_full_co (_data_);
}

gboolean
games_scores_context_add_score_full_finish (GamesScoresContext* self,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	gboolean result;
	GamesScoresContextAddScoreFullData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

/**
     * Adds extra info to the score, and optionally, some buttons to the bottom of the dialog that aid the flow of a game.
     *
     * ``new_game_func`` is called when the user presses the 'New Game' button on the dialog
     *
     * ``quit_app_func`` is called when the user presses the 'Quit' button on the dialog
     *
     */
static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		GamesScoresContext* self;
		self = _data5_->self;
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
___lambda28_ (Block5Data* _data5_)
{
	GamesScoresContext* self;
	self = _data5_->self;
	games_scores_context_add_score_full_co (_data5_->_async_data_);
}

static void
____lambda28__adw_dialog_closed (AdwDialog* _sender,
                                 gpointer self)
{
	___lambda28_ (self);
}

static void
games_scores_context_add_score_full_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	GamesScoresContextAddScoreFullData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	games_scores_context_add_score_full_co (_data_);
}

static gboolean
games_scores_context_add_score_full_co (GamesScoresContextAddScoreFullData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data5_ = g_slice_new0 (Block5Data);
	_data_->_data5_->_ref_count_ = 1;
	_data_->_data5_->self = g_object_ref (_data_->self);
	_data_->_data5_->_async_data_ = _data_;
	_data_->_tmp0_ = games_scores_score_new (_data_->score_value, (gint64) 0, NULL);
	_data_->score = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->score;
	games_scores_score_set_extra_info (_data_->_tmp1_, _data_->extra_info);
	_data_->_tmp2_ = _data_->self->priv->scores_per_category;
	if (!g_hash_table_contains (_data_->_tmp2_, _data_->category)) {
		_data_->_tmp3_ = _data_->self->priv->scores_per_category;
		_data_->_tmp4_ = _g_object_ref0 (_data_->category);
		_data_->_tmp5_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
		g_hash_table_insert (_data_->_tmp3_, _data_->_tmp4_, _data_->_tmp5_);
	}
	_data_->_tmp6_ = _data_->self->priv->scores_per_category;
	_data_->_tmp7_ = g_hash_table_lookup (_data_->_tmp6_, _data_->category);
	_data_->_tmp8_ = _data_->score;
	_data_->_tmp9_ = _g_object_ref0 (_data_->_tmp8_);
	g_ptr_array_add ((GPtrArray*) _data_->_tmp7_, _data_->_tmp9_);
	_data_->_tmp10_ = _g_object_ref0 (_data_->category);
	_g_object_unref0 (_data_->self->priv->current_category);
	_data_->self->priv->current_category = _data_->_tmp10_;
	_data_->_tmp11_ = _data_->score;
	_data_->_tmp12_ = games_scores_score_get_score (_data_->_tmp11_);
	_data_->_tmp13_ = _data_->_tmp12_;
	_data_->high_score_added = games_scores_context_is_high_score (_data_->self, _data_->_tmp13_, _data_->category);
	if (_data_->high_score_added) {
		_data_->_tmp14_ = _data_->game_window != NULL;
	} else {
		_data_->_tmp14_ = FALSE;
	}
	if (_data_->_tmp14_) {
		_data_->_tmp15_ = _data_->self->priv->_category_type;
		_data_->_tmp16_ = _data_->self->priv->_style;
		_data_->_tmp17_ = _data_->score;
		_data_->_tmp18_ = _data_->self->priv->current_category;
		_data_->_tmp19_ = _data_->self->priv->_icon_name;
		_data_->_tmp20_ = games_scores_dialog_new (_data_->self, _data_->_tmp15_, _data_->_tmp16_, _data_->_tmp17_, _data_->_tmp18_, _data_->_tmp19_);
		g_object_ref_sink (_data_->_tmp20_);
		_data_->dialog = _data_->_tmp20_;
		_data_->_tmp21_ = _data_->dialog;
		g_signal_connect_data ((AdwDialog*) _data_->_tmp21_, "closed", (GCallback) ____lambda28__adw_dialog_closed, block5_data_ref (_data_->_data5_), (GClosureNotify) block5_data_unref, 0);
		_data_->_tmp22_ = _data_->dialog;
		adw_dialog_present ((AdwDialog*) _data_->_tmp22_, (GtkWidget*) _data_->game_window);
		if (_data_->new_game_func != NULL) {
			_data_->_tmp23_ = _data_->quit_app_func != NULL;
		} else {
			_data_->_tmp23_ = FALSE;
		}
		if (_data_->_tmp23_) {
			_data_->_tmp24_ = _data_->dialog;
			games_scores_dialog_add_bottom_buttons (_data_->_tmp24_, _data_->new_game_func, _data_->new_game_func_target, _data_->quit_app_func, _data_->quit_app_func_target);
		}
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		_g_object_unref0 (_data_->dialog);
	}
	_data_->_tmp25_ = _data_->score;
	_data_->_state_ = 2;
	games_scores_context_save_score_to_file (_data_->self, _data_->_tmp25_, _data_->category, _data_->cancellable, games_scores_context_add_score_full_ready, _data_);
	return FALSE;
	_state_2:
	games_scores_context_save_score_to_file_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->score);
		block5_data_unref (_data_->_data5_);
		_data_->_data5_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->high_score_added;
	_g_object_unref0 (_data_->score);
	block5_data_unref (_data_->_data5_);
	_data_->_data5_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
g_file_stream_read_line (FILE* self)
{
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	while (TRUE) {
		GString* _tmp0_;
		GString* _tmp2_;
		c = fgetc (self);
		if (!(c != EOF)) {
			break;
		}
		_tmp0_ = ret;
		if (_tmp0_ == NULL) {
			GString* _tmp1_;
			_tmp1_ = g_string_new ("");
			_g_string_free0 (ret);
			ret = _tmp1_;
		}
		if (c == ((gint) '\n')) {
			break;
		}
		_tmp2_ = ret;
		g_string_append_c ((GString*) _tmp2_, (gchar) c);
	}
	_tmp3_ = ret;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_string_free0 (ret);
		return result;
	} else {
		GString* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = ret;
		_tmp5_ = ((GString*) _tmp4_)->str;
		((GString*) _tmp4_)->str = NULL;
		result = _tmp5_;
		_g_string_free0 (ret);
		return result;
	}
}

static glong
long_parse (const gchar* str,
            guint _base)
{
	glong result;
	g_return_val_if_fail (str != NULL, 0L);
	result = strtol (str, NULL, (gint) _base);
	return result;
}

static gint64
int64_parse (const gchar* str,
             guint _base)
{
	gint64 result;
	g_return_val_if_fail (str != NULL, 0LL);
	result = g_ascii_strtoll (str, NULL, _base);
	return result;
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

static void
games_scores_context_load_scores_from_file (GamesScoresContext* self,
                                            GFileInfo* file_info,
                                            GError** error)
{
	gchar* category_key = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GamesScoresCategory* category = NULL;
	GamesScoresContextCategoryRequestFunc _tmp2_;
	gpointer _tmp2__target;
	const gchar* _tmp3_;
	GamesScoresCategory* _tmp4_;
	GamesScoresCategory* _tmp5_;
	gchar* filename = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GPtrArray* scores_of_single_category = NULL;
	GPtrArray* _tmp9_;
	FILE* stream = NULL;
	const gchar* _tmp10_;
	FILE* _tmp11_;
	gchar* line = NULL;
	GHashTable* _tmp54_;
	GamesScoresCategory* _tmp55_;
	GamesScoresCategory* _tmp56_;
	GPtrArray* _tmp57_;
	GPtrArray* _tmp58_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file_info != NULL);
	_tmp0_ = g_file_info_get_name (file_info);
	_tmp1_ = g_strdup (_tmp0_);
	category_key = _tmp1_;
	_tmp2_ = self->priv->category_request;
	_tmp2__target = self->priv->category_request_target;
	_tmp3_ = category_key;
	_tmp4_ = _tmp2_ (_tmp3_, _tmp2__target);
	category = _tmp4_;
	_tmp5_ = category;
	if (_tmp5_ == NULL) {
		_g_object_unref0 (category);
		_g_free0 (category_key);
		return;
	}
	_tmp6_ = self->priv->user_score_dir;
	_tmp7_ = category_key;
	_tmp8_ = g_build_filename (_tmp6_, _tmp7_, NULL);
	filename = _tmp8_;
	_tmp9_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	scores_of_single_category = _tmp9_;
	_tmp10_ = filename;
	_tmp11_ = g_fopen (_tmp10_, "r");
	stream = _tmp11_;
	while (TRUE) {
		FILE* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar** tokens = NULL;
		const gchar* _tmp15_;
		gchar** _tmp16_;
		gchar** _tmp17_;
		gint tokens_length1;
		gint _tokens_size_;
		gchar* user = NULL;
		gchar** _tmp18_;
		gint _tmp18__length1;
		glong score_value = 0L;
		gchar** score_tokens = NULL;
		gchar** _tmp21_;
		gint _tmp21__length1;
		const gchar* _tmp22_;
		gchar** _tmp23_;
		gchar** _tmp24_;
		gint score_tokens_length1;
		gint _score_tokens_size_;
		gchar** _tmp25_;
		gint _tmp25__length1;
		const gchar* _tmp26_;
		gint64 time = 0LL;
		gchar** _tmp27_;
		gint _tmp27__length1;
		const gchar* _tmp28_;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		gchar** _tmp38_;
		gint _tmp38__length1;
		GamesScoresScore* score = NULL;
		const gchar* _tmp44_;
		GamesScoresScore* _tmp45_;
		gchar** _tmp46_;
		gint _tmp46__length1;
		GPtrArray* _tmp51_;
		GamesScoresScore* _tmp52_;
		GamesScoresScore* _tmp53_;
		_tmp12_ = stream;
		_tmp13_ = g_file_stream_read_line (_tmp12_);
		_g_free0 (line);
		line = _tmp13_;
		_tmp14_ = line;
		if (!(_tmp14_ != NULL)) {
			break;
		}
		_tmp15_ = line;
		_tmp17_ = _tmp16_ = g_strsplit (_tmp15_, " ", 3);
		tokens = _tmp17_;
		tokens_length1 = _vala_array_length (_tmp16_);
		_tokens_size_ = tokens_length1;
		user = NULL;
		_tmp18_ = tokens;
		_tmp18__length1 = tokens_length1;
		if (_tmp18__length1 < 2) {
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp19_ = line;
			_tmp20_ = filename;
			g_warning ("context.vala:366: Failed to read malformed score %s in %s.", _tmp19_, _tmp20_);
			_g_free0 (user);
			tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
			continue;
		}
		score_value = (glong) 0;
		_tmp21_ = tokens;
		_tmp21__length1 = tokens_length1;
		_tmp22_ = _tmp21_[0];
		_tmp24_ = _tmp23_ = g_strsplit (_tmp22_, "#", 2);
		score_tokens = _tmp24_;
		score_tokens_length1 = _vala_array_length (_tmp23_);
		_score_tokens_size_ = score_tokens_length1;
		_tmp25_ = score_tokens;
		_tmp25__length1 = score_tokens_length1;
		_tmp26_ = _tmp25_[0];
		score_value = long_parse (_tmp26_, (guint) 0);
		_tmp27_ = tokens;
		_tmp27__length1 = tokens_length1;
		_tmp28_ = _tmp27_[1];
		time = int64_parse (_tmp28_, (guint) 0);
		if (score_value == ((glong) 0)) {
			gchar** _tmp31_;
			gint _tmp31__length1;
			const gchar* _tmp32_;
			_tmp31_ = score_tokens;
			_tmp31__length1 = score_tokens_length1;
			_tmp32_ = _tmp31_[0];
			_tmp30_ = g_strcmp0 (_tmp32_, "0") != 0;
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			_tmp29_ = TRUE;
		} else {
			gboolean _tmp33_ = FALSE;
			if (time == ((gint64) 0)) {
				gchar** _tmp34_;
				gint _tmp34__length1;
				const gchar* _tmp35_;
				_tmp34_ = tokens;
				_tmp34__length1 = tokens_length1;
				_tmp35_ = _tmp34_[1];
				_tmp33_ = g_strcmp0 (_tmp35_, "0") != 0;
			} else {
				_tmp33_ = FALSE;
			}
			_tmp29_ = _tmp33_;
		}
		if (_tmp29_) {
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			_tmp36_ = line;
			_tmp37_ = filename;
			g_warning ("context.vala:380: Failed to read malformed score %s in %s.", _tmp36_, _tmp37_);
			score_tokens = (_vala_array_free (score_tokens, score_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (user);
			tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
			continue;
		}
		_tmp38_ = tokens;
		_tmp38__length1 = tokens_length1;
		if (_tmp38__length1 == 3) {
			gchar** _tmp39_;
			gint _tmp39__length1;
			const gchar* _tmp40_;
			gchar* _tmp41_;
			_tmp39_ = tokens;
			_tmp39__length1 = tokens_length1;
			_tmp40_ = _tmp39_[2];
			_tmp41_ = g_strdup (_tmp40_);
			_g_free0 (user);
			user = _tmp41_;
		} else {
			const gchar* _tmp42_;
			const gchar* _tmp43_;
			_tmp42_ = line;
			_tmp43_ = filename;
			g_debug ("context.vala:387: Assuming current username for old score %s in %s.", _tmp42_, _tmp43_);
		}
		_tmp44_ = user;
		_tmp45_ = games_scores_score_new (score_value, time, _tmp44_);
		score = _tmp45_;
		_tmp46_ = score_tokens;
		_tmp46__length1 = score_tokens_length1;
		if (_tmp46__length1 == 2) {
			GamesScoresScore* _tmp47_;
			gchar** _tmp48_;
			gint _tmp48__length1;
			const gchar* _tmp49_;
			gchar* _tmp50_;
			_tmp47_ = score;
			_tmp48_ = score_tokens;
			_tmp48__length1 = score_tokens_length1;
			_tmp49_ = _tmp48_[1];
			_tmp50_ = g_strdup (_tmp49_);
			_g_free0 (_tmp47_->_extra_info);
			_tmp47_->_extra_info = _tmp50_;
		}
		_tmp51_ = scores_of_single_category;
		_tmp52_ = score;
		_tmp53_ = _g_object_ref0 (_tmp52_);
		g_ptr_array_add (_tmp51_, _tmp53_);
		_g_object_unref0 (score);
		score_tokens = (_vala_array_free (score_tokens, score_tokens_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (user);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp54_ = self->priv->scores_per_category;
	_tmp55_ = category;
	_tmp56_ = _g_object_ref0 (_tmp55_);
	_tmp57_ = scores_of_single_category;
	_tmp58_ = _g_ptr_array_ref0 (_tmp57_);
	g_hash_table_insert (_tmp54_, _tmp56_, _tmp58_);
	_g_free0 (line);
	_fclose0 (stream);
	_g_ptr_array_unref0 (scores_of_single_category);
	_g_free0 (filename);
	_g_object_unref0 (category);
	_g_free0 (category_key);
}

static void
games_scores_context_load_scores_from_files (GamesScoresContext* self,
                                             GError** error)
{
	GFile* directory = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFileEnumerator* enumerator = NULL;
	GFile* _tmp3_;
	GFileEnumerator* _tmp4_;
	GFileInfo* file_info = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (!self->priv->scores_loaded, "!scores_loaded");
	self->priv->scores_loaded = TRUE;
	_tmp0_ = self->priv->user_score_dir;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	directory = _tmp1_;
	_tmp2_ = directory;
	if (!g_file_query_exists (_tmp2_, NULL)) {
		_g_object_unref0 (directory);
		return;
	}
	_tmp3_ = directory;
	_tmp4_ = g_file_enumerate_children (_tmp3_, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error0_);
	enumerator = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (directory);
		return;
	}
	while (TRUE) {
		GFileInfo* _tmp5_ = NULL;
		GFileEnumerator* _tmp6_;
		GFileInfo* _tmp7_;
		GFileInfo* _tmp8_;
		GFileInfo* _tmp9_;
		GFileInfo* _tmp10_;
		_tmp6_ = enumerator;
		_tmp7_ = g_file_enumerator_next_file (_tmp6_, NULL, &_inner_error0_);
		_tmp5_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (file_info);
			_g_object_unref0 (enumerator);
			_g_object_unref0 (directory);
			return;
		}
		_tmp8_ = _tmp5_;
		_tmp5_ = NULL;
		_g_object_unref0 (file_info);
		file_info = _tmp8_;
		_tmp9_ = file_info;
		if (!(_tmp9_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			break;
		}
		_tmp10_ = file_info;
		games_scores_context_load_scores_from_file (self, _tmp10_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp5_);
			_g_object_unref0 (file_info);
			_g_object_unref0 (enumerator);
			_g_object_unref0 (directory);
			return;
		}
		_g_object_unref0 (_tmp5_);
	}
	_g_object_unref0 (file_info);
	_g_object_unref0 (enumerator);
	_g_object_unref0 (directory);
}

/**
     * Must be called *immediately* after construction, if constructed using
     * g_object_new.
     *
     */
static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		GamesScoresContext* self;
		self = _data6_->self;
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static GamesScoresCategory*
__lambda29_ (Block6Data* _data6_,
             const gchar* key)
{
	GamesScoresContext* self;
	GamesScoresCategory* _tmp0_;
	GamesScoresCategory* result;
	self = _data6_->self;
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = _data6_->category_request (key, _data6_->category_request_target);
	result = _tmp0_;
	return result;
}

static GamesScoresCategory*
___lambda29__games_scores_context_category_request_func (const gchar* category_key,
                                                         gpointer self)
{
	GamesScoresCategory* result;
	result = __lambda29_ (self, category_key);
	return result;
}

void
games_scores_context_load_scores (GamesScoresContext* self,
                                  GamesScoresContextCategoryRequestFunc category_request,
                                  gpointer category_request_target,
                                  GError** error)
{
	GamesScoresContextCategoryRequestFunc _tmp0_;
	gpointer _tmp0__target;
	Block6Data* _data6_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->category_request;
	_tmp0__target = self->priv->category_request_target;
	_vala_return_if_fail (_tmp0_ == NULL, "this.category_request == null");
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_data6_->category_request = category_request;
	_data6_->category_request_target = category_request_target;
	(self->priv->category_request_target_destroy_notify == NULL) ? NULL : (self->priv->category_request_target_destroy_notify (self->priv->category_request_target), NULL);
	self->priv->category_request = NULL;
	self->priv->category_request_target = NULL;
	self->priv->category_request_target_destroy_notify = NULL;
	self->priv->category_request = ___lambda29__games_scores_context_category_request_func;
	self->priv->category_request_target = block6_data_ref (_data6_);
	self->priv->category_request_target_destroy_notify = block6_data_unref;
	games_scores_context_load_scores_from_files (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		block6_data_unref (_data6_);
		_data6_ = NULL;
		return;
	}
	(self->priv->category_request_target_destroy_notify == NULL) ? NULL : (self->priv->category_request_target_destroy_notify (self->priv->category_request_target), NULL);
	self->priv->category_request = NULL;
	self->priv->category_request_target = NULL;
	self->priv->category_request_target_destroy_notify = NULL;
	self->priv->category_request = NULL;
	self->priv->category_request_target = NULL;
	self->priv->category_request_target_destroy_notify = NULL;
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

/**
     * Presents the score dialog on top of ``game_window``.
     *
     * ``selected_category`` is the score category to select by default (optional)
     *
     */
static void
__lambda30_ (GamesScoresContext* self)
{
	g_signal_emit (self, games_scores_context_signals[GAMES_SCORES_CONTEXT_DIALOG_CLOSED_SIGNAL], 0);
}

static void
___lambda30__adw_dialog_closed (AdwDialog* _sender,
                                gpointer self)
{
	__lambda30_ ((GamesScoresContext*) self);
}

void
games_scores_context_present_dialog (GamesScoresContext* self,
                                     GtkWindow* game_window,
                                     GamesScoresCategory* selected_category)
{
	gboolean _tmp0_ = FALSE;
	GamesScoresDialog* dialog = NULL;
	const gchar* _tmp3_;
	GamesScoresStyle _tmp4_;
	const gchar* _tmp5_;
	GamesScoresDialog* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game_window != NULL);
	if (selected_category == NULL) {
		_tmp0_ = TRUE;
	} else {
		GHashTable* _tmp1_;
		_tmp1_ = self->priv->scores_per_category;
		_tmp0_ = !g_hash_table_contains (_tmp1_, selected_category);
	}
	if (_tmp0_) {
		GamesScoresCategory* _tmp2_;
		_tmp2_ = self->priv->current_category;
		selected_category = _tmp2_;
	}
	_tmp3_ = self->priv->_category_type;
	_tmp4_ = self->priv->_style;
	_tmp5_ = self->priv->_icon_name;
	_tmp6_ = games_scores_dialog_new (self, _tmp3_, _tmp4_, NULL, selected_category, _tmp5_);
	g_object_ref_sink (_tmp6_);
	dialog = _tmp6_;
	g_signal_connect_object ((AdwDialog*) dialog, "closed", (GCallback) ___lambda30__adw_dialog_closed, self, 0);
	adw_dialog_present ((AdwDialog*) dialog, (GtkWidget*) game_window);
	_g_object_unref0 (dialog);
}

/**
     * Returns true if this contains {@link Games.Scores.Score}s.
     *
     */
gboolean
games_scores_context_has_scores (GamesScoresContext* self)
{
	GHashTable* _tmp0_;
	GList* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->scores_per_category;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* scores_collection = NULL;
		GList* scores_it = NULL;
		scores_collection = _tmp1_;
		for (scores_it = scores_collection; scores_it != NULL; scores_it = scores_it->next) {
			GPtrArray* scores = NULL;
			scores = (GPtrArray*) scores_it->data;
			{
				GPtrArray* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				_tmp2_ = scores;
				_tmp3_ = vala_g_ptr_array_get_length (_tmp2_);
				_tmp4_ = _tmp3_;
				if (_tmp4_ > 0) {
					result = TRUE;
					(scores_collection == NULL) ? NULL : (scores_collection = (g_list_free (scores_collection), NULL));
					return result;
				}
			}
		}
		(scores_collection == NULL) ? NULL : (scores_collection = (g_list_free (scores_collection), NULL));
	}
	result = FALSE;
	return result;
}

const gchar*
games_scores_context_get_app_name (GamesScoresContext* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_name;
	result = _tmp0_;
	return result;
}

static void
games_scores_context_set_app_name (GamesScoresContext* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = games_scores_context_get_app_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_app_name);
		self->priv->_app_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, games_scores_context_properties[GAMES_SCORES_CONTEXT_APP_NAME_PROPERTY]);
	}
}

const gchar*
games_scores_context_get_category_type (GamesScoresContext* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_category_type;
	result = _tmp0_;
	return result;
}

static void
games_scores_context_set_category_type (GamesScoresContext* self,
                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = games_scores_context_get_category_type (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_category_type);
		self->priv->_category_type = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, games_scores_context_properties[GAMES_SCORES_CONTEXT_CATEGORY_TYPE_PROPERTY]);
	}
}

GamesScoresStyle
games_scores_context_get_style (GamesScoresContext* self)
{
	GamesScoresStyle result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_style;
	return result;
}

static void
games_scores_context_set_style (GamesScoresContext* self,
                                GamesScoresStyle value)
{
	GamesScoresStyle old_value;
	g_return_if_fail (self != NULL);
	old_value = games_scores_context_get_style (self);
	if (old_value != value) {
		self->priv->_style = value;
		g_object_notify_by_pspec ((GObject *) self, games_scores_context_properties[GAMES_SCORES_CONTEXT_STYLE_PROPERTY]);
	}
}

const gchar*
games_scores_context_get_icon_name (GamesScoresContext* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_name;
	result = _tmp0_;
	return result;
}

static void
games_scores_context_set_icon_name (GamesScoresContext* self,
                                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = games_scores_context_get_icon_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon_name);
		self->priv->_icon_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, games_scores_context_properties[GAMES_SCORES_CONTEXT_ICON_NAME_PROPERTY]);
	}
}

gint
games_scores_context_get_max_high_scores (GamesScoresContext* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_max_high_scores;
	return result;
}

static void
games_scores_context_set_max_high_scores (GamesScoresContext* self,
                                          gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = games_scores_context_get_max_high_scores (self);
	if (old_value != value) {
		self->priv->_max_high_scores = value;
		g_object_notify_by_pspec ((GObject *) self, games_scores_context_properties[GAMES_SCORES_CONTEXT_MAX_HIGH_SCORES_PROPERTY]);
	}
}

static void
games_scores_context_base_init (GamesScoresContextClass * klass)
{
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkDisplay* _tmp2_;
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	if (_tmp2_ != NULL) {
		GtkCssProvider* provider = NULL;
		GtkCssProvider* _tmp3_;
		GtkCssProvider* _tmp4_;
		GdkDisplay* _tmp5_;
		GtkCssProvider* _tmp6_;
		_tmp3_ = gtk_css_provider_new ();
		provider = _tmp3_;
		_tmp4_ = provider;
		gtk_css_provider_load_from_string (_tmp4_, GAMES_SCORES_DIALOG_STYLE);
		_tmp5_ = display;
		_tmp6_ = provider;
		gtk_style_context_add_provider_for_display (_tmp5_, (GtkStyleProvider*) _tmp6_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
		_g_object_unref0 (provider);
	}
	_g_object_unref0 (display);
}

static void
games_scores_context_class_init (GamesScoresContextClass * klass,
                                 gpointer klass_data)
{
	games_scores_context_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesScoresContext_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) games_scores_context_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = _vala_games_scores_context_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_scores_context_set_property;
	G_OBJECT_CLASS (klass)->finalize = games_scores_context_finalize;
	/**
	     * An App ID (e.g. ``org.gnome.Mines``).
	     *
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SCORES_CONTEXT_APP_NAME_PROPERTY, games_scores_context_properties[GAMES_SCORES_CONTEXT_APP_NAME_PROPERTY] = g_param_spec_string ("app-name", "app-name", "app-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * Describes all of the categories (e.g. "Minefield", "Level").
	     *
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SCORES_CONTEXT_CATEGORY_TYPE_PROPERTY, games_scores_context_properties[GAMES_SCORES_CONTEXT_CATEGORY_TYPE_PROPERTY] = g_param_spec_string ("category-type", "category-type", "category-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * The {@link Games.Scores.Style} that the context should use.
	     *
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SCORES_CONTEXT_STYLE_PROPERTY, games_scores_context_properties[GAMES_SCORES_CONTEXT_STYLE_PROPERTY] = g_param_spec_enum ("style", "style", "style", GAMES_SCORES_TYPE_STYLE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * The ID for the icon that will be used in the score dialog's empty screen (e.g. ``org.gnome.Quadrapassel``).
	     *
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SCORES_CONTEXT_ICON_NAME_PROPERTY, games_scores_context_properties[GAMES_SCORES_CONTEXT_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * The maximum size of the high score list in the score dialog (``-1`` for unlimited).
	     *
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SCORES_CONTEXT_MAX_HIGH_SCORES_PROPERTY, games_scores_context_properties[GAMES_SCORES_CONTEXT_MAX_HIGH_SCORES_PROPERTY] = g_param_spec_int ("max-high-scores", "max-high-scores", "max-high-scores", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * Emitted when the score dialog is closed.
	     *
	     */
	games_scores_context_signals[GAMES_SCORES_CONTEXT_DIALOG_CLOSED_SIGNAL] = g_signal_new ("dialog-closed", GAMES_SCORES_TYPE_CONTEXT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
games_scores_context_instance_init (GamesScoresContext * self,
                                    gpointer klass)
{
	GHashTable* _tmp0_;
	self->priv = games_scores_context_get_instance_private (self);
	self->priv->current_category = NULL;
	_tmp0_ = g_hash_table_new_full (__games_scores_context_scores_per_category_lambda6__ghash_func, __games_scores_context_scores_per_category_lambda7__gequal_func, _g_object_unref0_, _g_ptr_array_unref0_);
	self->priv->scores_per_category = _tmp0_;
	self->priv->scores_loaded = FALSE;
	self->priv->category_request = NULL;
	self->priv->category_request_target = NULL;
	self->priv->category_request_target_destroy_notify = NULL;
}

static void
games_scores_context_finalize (GObject * obj)
{
	GamesScoresContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_SCORES_TYPE_CONTEXT, GamesScoresContext);
	_g_free0 (self->priv->_app_name);
	_g_free0 (self->priv->_category_type);
	_g_free0 (self->priv->_icon_name);
	_g_object_unref0 (self->priv->current_category);
	_g_hash_table_unref0 (self->priv->scores_per_category);
	_g_free0 (self->priv->user_score_dir);
	(self->priv->category_request_target_destroy_notify == NULL) ? NULL : (self->priv->category_request_target_destroy_notify (self->priv->category_request_target), NULL);
	self->priv->category_request = NULL;
	self->priv->category_request_target = NULL;
	self->priv->category_request_target_destroy_notify = NULL;
	G_OBJECT_CLASS (games_scores_context_parent_class)->finalize (obj);
}

/**
 * An object that holds information for using {@link Games.Scores.Score}s.
 *
 */
static GType
games_scores_context_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesScoresContextClass), (GBaseInitFunc) games_scores_context_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_scores_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesScoresContext), 0, (GInstanceInitFunc) games_scores_context_instance_init, NULL };
	GType games_scores_context_type_id;
	games_scores_context_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesScoresContext", &g_define_type_info, 0);
	GamesScoresContext_private_offset = g_type_add_instance_private (games_scores_context_type_id, sizeof (GamesScoresContextPrivate));
	return games_scores_context_type_id;
}

GType
games_scores_context_get_type (void)
{
	static volatile gsize games_scores_context_type_id__once = 0;
	if (g_once_init_enter (&games_scores_context_type_id__once)) {
		GType games_scores_context_type_id;
		games_scores_context_type_id = games_scores_context_get_type_once ();
		g_once_init_leave (&games_scores_context_type_id__once, games_scores_context_type_id);
	}
	return games_scores_context_type_id__once;
}

static void
_vala_games_scores_context_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GamesScoresContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_SCORES_TYPE_CONTEXT, GamesScoresContext);
	switch (property_id) {
		case GAMES_SCORES_CONTEXT_APP_NAME_PROPERTY:
		g_value_set_string (value, games_scores_context_get_app_name (self));
		break;
		case GAMES_SCORES_CONTEXT_CATEGORY_TYPE_PROPERTY:
		g_value_set_string (value, games_scores_context_get_category_type (self));
		break;
		case GAMES_SCORES_CONTEXT_STYLE_PROPERTY:
		g_value_set_enum (value, games_scores_context_get_style (self));
		break;
		case GAMES_SCORES_CONTEXT_ICON_NAME_PROPERTY:
		g_value_set_string (value, games_scores_context_get_icon_name (self));
		break;
		case GAMES_SCORES_CONTEXT_MAX_HIGH_SCORES_PROPERTY:
		g_value_set_int (value, games_scores_context_get_max_high_scores (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_games_scores_context_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GamesScoresContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_SCORES_TYPE_CONTEXT, GamesScoresContext);
	switch (property_id) {
		case GAMES_SCORES_CONTEXT_APP_NAME_PROPERTY:
		games_scores_context_set_app_name (self, g_value_get_string (value));
		break;
		case GAMES_SCORES_CONTEXT_CATEGORY_TYPE_PROPERTY:
		games_scores_context_set_category_type (self, g_value_get_string (value));
		break;
		case GAMES_SCORES_CONTEXT_STYLE_PROPERTY:
		games_scores_context_set_style (self, g_value_get_enum (value));
		break;
		case GAMES_SCORES_CONTEXT_ICON_NAME_PROPERTY:
		games_scores_context_set_icon_name (self, g_value_get_string (value));
		break;
		case GAMES_SCORES_CONTEXT_MAX_HIGH_SCORES_PROPERTY:
		games_scores_context_set_max_high_scores (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

