/* alarm-face.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from alarm-face.vala, do not modify */

/*
 * Copyright (C) 2013  Paolo Borelli <pborelli@gnome.org>
 * Copyright (C) 2020  Zander Brown <zbrown@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <adwaita.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#define CLOCKS_ALARM_DELETE_ALARM 2
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CLOCKS_TYPE_CLOCK (clocks_clock_get_type ())
#define CLOCKS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CLOCK, ClocksClock))
#define CLOCKS_IS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CLOCK))
#define CLOCKS_CLOCK_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_TYPE_CLOCK, ClocksClockIface))

typedef struct _ClocksClock ClocksClock;
typedef struct _ClocksClockIface ClocksClockIface;
typedef enum  {
	CLOCKS_PANEL_ID_WORLD,
	CLOCKS_PANEL_ID_ALARM,
	CLOCKS_PANEL_ID_STOPWATCH,
	CLOCKS_PANEL_ID_TIMER
} ClocksPanelId;

#define CLOCKS_TYPE_PANEL_ID (clocks_panel_id_get_type ())
typedef enum  {
	CLOCKS_BUTTON_MODE_NEW,
	CLOCKS_BUTTON_MODE_NONE
} ClocksButtonMode;

#define CLOCKS_TYPE_BUTTON_MODE (clocks_button_mode_get_type ())

#define CLOCKS_ALARM_TYPE_FACE (clocks_alarm_face_get_type ())
#define CLOCKS_ALARM_FACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_ALARM_TYPE_FACE, ClocksAlarmFace))
#define CLOCKS_ALARM_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_ALARM_TYPE_FACE, ClocksAlarmFaceClass))
#define CLOCKS_ALARM_IS_FACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_ALARM_TYPE_FACE))
#define CLOCKS_ALARM_IS_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_ALARM_TYPE_FACE))
#define CLOCKS_ALARM_FACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_ALARM_TYPE_FACE, ClocksAlarmFaceClass))

typedef struct _ClocksAlarmFace ClocksAlarmFace;
typedef struct _ClocksAlarmFaceClass ClocksAlarmFaceClass;
typedef struct _ClocksAlarmFacePrivate ClocksAlarmFacePrivate;

#define CLOCKS_TYPE_CONTENT_STORE (clocks_content_store_get_type ())
#define CLOCKS_CONTENT_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CONTENT_STORE, ClocksContentStore))
#define CLOCKS_CONTENT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_CONTENT_STORE, ClocksContentStoreClass))
#define CLOCKS_IS_CONTENT_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CONTENT_STORE))
#define CLOCKS_IS_CONTENT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_CONTENT_STORE))
#define CLOCKS_CONTENT_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_CONTENT_STORE, ClocksContentStoreClass))

typedef struct _ClocksContentStore ClocksContentStore;
typedef struct _ClocksContentStoreClass ClocksContentStoreClass;

#define CLOCKS_ALARM_TYPE_ITEM (clocks_alarm_item_get_type ())
#define CLOCKS_ALARM_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem))
#define CLOCKS_ALARM_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItemClass))
#define CLOCKS_ALARM_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_ALARM_TYPE_ITEM))
#define CLOCKS_ALARM_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_ALARM_TYPE_ITEM))
#define CLOCKS_ALARM_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItemClass))

typedef struct _ClocksAlarmItem ClocksAlarmItem;
typedef struct _ClocksAlarmItemClass ClocksAlarmItemClass;
enum  {
	CLOCKS_ALARM_FACE_0_PROPERTY,
	CLOCKS_ALARM_FACE_PANEL_ID_PROPERTY,
	CLOCKS_ALARM_FACE_BUTTON_MODE_PROPERTY,
	CLOCKS_ALARM_FACE_NEW_LABEL_PROPERTY,
	CLOCKS_ALARM_FACE_NUM_PROPERTIES
};
static GParamSpec* clocks_alarm_face_properties[CLOCKS_ALARM_FACE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CLOCKS_TYPE_CONTENT_ITEM (clocks_content_item_get_type ())
#define CLOCKS_CONTENT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CONTENT_ITEM, ClocksContentItem))
#define CLOCKS_IS_CONTENT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CONTENT_ITEM))
#define CLOCKS_CONTENT_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_TYPE_CONTENT_ITEM, ClocksContentItemIface))

typedef struct _ClocksContentItem ClocksContentItem;
typedef struct _ClocksContentItemIface ClocksContentItemIface;
typedef ClocksContentItem* (*ClocksContentStoreDeserializeItemFunc) (GVariant* v, gpointer user_data);
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef void (*ClocksContentStoreForeachFunc) (ClocksContentItem* item, gpointer user_data);
typedef struct _Block1Data Block1Data;

#define CLOCKS_TYPE_WINDOW (clocks_window_get_type ())
#define CLOCKS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_WINDOW, ClocksWindow))
#define CLOCKS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_WINDOW, ClocksWindowClass))
#define CLOCKS_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_WINDOW))
#define CLOCKS_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_WINDOW))
#define CLOCKS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_WINDOW, ClocksWindowClass))

typedef struct _ClocksWindow ClocksWindow;
typedef struct _ClocksWindowClass ClocksWindowClass;
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block2Data Block2Data;

#define CLOCKS_ALARM_TYPE_SETUP_DIALOG (clocks_alarm_setup_dialog_get_type ())
#define CLOCKS_ALARM_SETUP_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_ALARM_TYPE_SETUP_DIALOG, ClocksAlarmSetupDialog))
#define CLOCKS_ALARM_SETUP_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_ALARM_TYPE_SETUP_DIALOG, ClocksAlarmSetupDialogClass))
#define CLOCKS_ALARM_IS_SETUP_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_ALARM_TYPE_SETUP_DIALOG))
#define CLOCKS_ALARM_IS_SETUP_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_ALARM_TYPE_SETUP_DIALOG))
#define CLOCKS_ALARM_SETUP_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_ALARM_TYPE_SETUP_DIALOG, ClocksAlarmSetupDialogClass))

typedef struct _ClocksAlarmSetupDialog ClocksAlarmSetupDialog;
typedef struct _ClocksAlarmSetupDialogClass ClocksAlarmSetupDialogClass;
typedef struct _Block3Data Block3Data;
typedef gboolean (*ClocksContentStoreFindFunc) (ClocksContentItem* item, gpointer user_data);
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;

#define CLOCKS_ALARM_TYPE_ROW (clocks_alarm_row_get_type ())
#define CLOCKS_ALARM_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_ALARM_TYPE_ROW, ClocksAlarmRow))
#define CLOCKS_ALARM_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_ALARM_TYPE_ROW, ClocksAlarmRowClass))
#define CLOCKS_ALARM_IS_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_ALARM_TYPE_ROW))
#define CLOCKS_ALARM_IS_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_ALARM_TYPE_ROW))
#define CLOCKS_ALARM_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_ALARM_TYPE_ROW, ClocksAlarmRowClass))

typedef struct _ClocksAlarmRow ClocksAlarmRow;
typedef struct _ClocksAlarmRowClass ClocksAlarmRowClass;

#define CLOCKS_UTILS_TYPE_WALL_CLOCK (clocks_utils_wall_clock_get_type ())
#define CLOCKS_UTILS_WALL_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClock))
#define CLOCKS_UTILS_WALL_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClockClass))
#define CLOCKS_UTILS_IS_WALL_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK))
#define CLOCKS_UTILS_IS_WALL_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_UTILS_TYPE_WALL_CLOCK))
#define CLOCKS_UTILS_WALL_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClockClass))

typedef struct _ClocksUtilsWallClock ClocksUtilsWallClock;
typedef struct _ClocksUtilsWallClockClass ClocksUtilsWallClockClass;
typedef enum  {
	CLOCKS_ALARM_ITEM_STATE_READY,
	CLOCKS_ALARM_ITEM_STATE_RINGING,
	CLOCKS_ALARM_ITEM_STATE_SNOOZING,
	CLOCKS_ALARM_ITEM_STATE_MISSED
} ClocksAlarmItemState;

#define CLOCKS_ALARM_ITEM_TYPE_STATE (clocks_alarm_item_state_get_type ())
enum  {
	CLOCKS_ALARM_FACE_RING_SIGNAL,
	CLOCKS_ALARM_FACE_NUM_SIGNALS
};
static guint clocks_alarm_face_signals[CLOCKS_ALARM_FACE_NUM_SIGNALS] = {0};

struct _ClocksClockIface {
	GTypeInterface parent_iface;
	void (*activate_new) (ClocksClock* self);
	gboolean (*escape_pressed) (ClocksClock* self);
	ClocksPanelId (*get_panel_id) (ClocksClock* self);
	void (*set_panel_id) (ClocksClock* self, ClocksPanelId value);
	ClocksButtonMode (*get_button_mode) (ClocksClock* self);
	void (*set_button_mode) (ClocksClock* self, ClocksButtonMode value);
	const gchar* (*get_new_label) (ClocksClock* self);
};

struct _ClocksAlarmFace {
	AdwBin parent_instance;
	ClocksAlarmFacePrivate * priv;
};

struct _ClocksAlarmFaceClass {
	AdwBinClass parent_class;
};

struct _ClocksAlarmFacePrivate {
	ClocksPanelId _panel_id;
	ClocksButtonMode _button_mode;
	gchar* _new_label;
	ClocksContentStore* alarms;
	GtkSortListModel* sorted_alarms;
	GSettings* settings;
	GtkWidget* empty_view;
	GtkListBox* listbox;
	GtkScrolledWindow* list_view;
	GtkStack* stack;
	AdwToast* ring_time_toast;
	ClocksAlarmItem* ring_time_toast_alarm;
};

struct _ClocksContentItemIface {
	GTypeInterface parent_iface;
	void (*serialize) (ClocksContentItem* self, GVariantBuilder* builder);
	const gchar* (*get_name) (ClocksContentItem* self);
	void (*set_name) (ClocksContentItem* self, const gchar* value);
};

struct _Block1Data {
	int _ref_count_;
	ClocksAlarmFace* self;
	gulong handler_id1;
	gulong handler_id2;
	ClocksAlarmItem* alarm;
};

struct _Block2Data {
	int _ref_count_;
	ClocksAlarmFace* self;
	ClocksAlarmItem* alarm;
};

struct _Block3Data {
	int _ref_count_;
	ClocksAlarmFace* self;
	GVariant* param;
};

struct _Block4Data {
	int _ref_count_;
	ClocksAlarmFace* self;
	GVariant* param;
};

struct _Block5Data {
	int _ref_count_;
	ClocksAlarmFace* self;
	GObject* item;
};

static gint ClocksAlarmFace_private_offset;
static gpointer clocks_alarm_face_parent_class = NULL;
static ClocksClockIface * clocks_alarm_face_clocks_clock_parent_iface = NULL;

VALA_EXTERN GType clocks_panel_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType clocks_button_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType clocks_clock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksClock, g_object_unref)
VALA_EXTERN GType clocks_alarm_face_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksAlarmFace, g_object_unref)
VALA_EXTERN GType clocks_content_store_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksContentStore, g_object_unref)
VALA_EXTERN GType clocks_alarm_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksAlarmItem, g_object_unref)
static void clocks_alarm_face_connect_item (ClocksAlarmFace* self,
                                     ClocksAlarmItem* item);
static void __lambda71_ (ClocksAlarmFace* self);
static void ___lambda71__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void clocks_alarm_face_load (ClocksAlarmFace* self);
VALA_EXTERN GType clocks_content_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksContentItem, g_object_unref)
VALA_EXTERN void clocks_content_store_deserialize (ClocksContentStore* self,
                                       GVariant* variant,
                                       ClocksContentStoreDeserializeItemFunc deserialize_item,
                                       gpointer deserialize_item_target);
VALA_EXTERN ClocksContentItem* clocks_alarm_item_deserialize (GVariant* alarm_variant);
static ClocksContentItem* _clocks_alarm_item_deserialize_clocks_content_store_deserialize_item_func (GVariant* v,
                                                                                              gpointer self);
VALA_EXTERN void clocks_content_store_foreach (ClocksContentStore* self,
                                   ClocksContentStoreForeachFunc func,
                                   gpointer func_target);
static void __lambda72_ (ClocksAlarmFace* self,
                  ClocksContentItem* item);
static void ___lambda72__clocks_content_store_foreach_func (ClocksContentItem* item,
                                                     gpointer self);
static void clocks_alarm_face_save (ClocksAlarmFace* self);
VALA_EXTERN GVariant* clocks_content_store_serialize (ClocksContentStore* self);
static void clocks_alarm_face_show_ring_time_toast (ClocksAlarmFace* self,
                                             ClocksAlarmItem* alarm);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
VALA_EXTERN GDateTime* clocks_alarm_item_get_ring_time (ClocksAlarmItem* self);
VALA_EXTERN GType clocks_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksWindow, g_object_unref)
VALA_EXTERN gchar* clocks_utils_format_time_span (GTimeSpan diff);
static void __lambda73_ (Block1Data* _data1_);
static void ___lambda73__adw_toast_dismissed (AdwToast* _sender,
                                       gpointer self);
static void __lambda74_ (Block1Data* _data1_);
VALA_EXTERN gboolean clocks_alarm_item_get_active (ClocksAlarmItem* self);
static void ___lambda74__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
VALA_EXTERN void clocks_window_add_toast (ClocksWindow* self,
                              AdwToast* toast);
VALA_EXTERN void clocks_alarm_face_edit (ClocksAlarmFace* self,
                             ClocksAlarmItem* alarm);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
VALA_EXTERN GType clocks_alarm_setup_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksAlarmSetupDialog, g_object_unref)
VALA_EXTERN ClocksAlarmSetupDialog* clocks_alarm_setup_dialog_new (ClocksAlarmItem* alarm,
                                                       GListModel* all_alarms);
VALA_EXTERN ClocksAlarmSetupDialog* clocks_alarm_setup_dialog_construct (GType object_type,
                                                             ClocksAlarmItem* alarm,
                                                             GListModel* all_alarms);
static void __lambda77_ (Block2Data* _data2_,
                  ClocksAlarmSetupDialog* dialog,
                  gint response);
VALA_EXTERN void clocks_alarm_setup_dialog_apply_to_alarm (ClocksAlarmSetupDialog* self,
                                               ClocksAlarmItem* alarm);
VALA_EXTERN void clocks_alarm_item_set_active (ClocksAlarmItem* self,
                                   gboolean value);
VALA_EXTERN void clocks_content_store_delete_item (ClocksContentStore* self,
                                       ClocksContentItem* item);
static void ___lambda77__clocks_alarm_setup_dialog_response (ClocksAlarmSetupDialog* _sender,
                                                      gint response,
                                                      gpointer self);
static void clocks_alarm_face_reset_view (ClocksAlarmFace* self);
static void clocks_alarm_face_real_activate_new (ClocksClock* base);
static void __lambda78_ (ClocksAlarmFace* self,
                  ClocksAlarmSetupDialog* dialog,
                  gint response);
VALA_EXTERN ClocksAlarmItem* clocks_alarm_item_new (const gchar* id);
VALA_EXTERN ClocksAlarmItem* clocks_alarm_item_construct (GType object_type,
                                              const gchar* id);
VALA_EXTERN void clocks_content_store_add (ClocksContentStore* self,
                               ClocksContentItem* item);
static void ___lambda78__clocks_alarm_setup_dialog_response (ClocksAlarmSetupDialog* _sender,
                                                      gint response,
                                                      gpointer self);
VALA_EXTERN ClocksAlarmFace* clocks_alarm_face_new (void);
VALA_EXTERN ClocksAlarmFace* clocks_alarm_face_construct (GType object_type);
static GObject * clocks_alarm_face_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
VALA_EXTERN void clocks_clock_set_panel_id (ClocksClock* self,
                                ClocksPanelId value);
VALA_EXTERN ClocksContentStore* clocks_content_store_new (void);
VALA_EXTERN ClocksContentStore* clocks_content_store_construct (GType object_type);
static gint _clocks_alarm_face___lambda79_ (ClocksAlarmFace* self,
                                     gconstpointer a,
                                     gconstpointer b);
VALA_EXTERN gint clocks_alarm_item_compare (ClocksAlarmItem* a,
                                ClocksAlarmItem* b);
static gint __clocks_alarm_face___lambda79__gcompare_data_func (gconstpointer a,
                                                         gconstpointer b,
                                                         gpointer self);
static void _clocks_alarm_face___lambda80_ (ClocksAlarmFace* self,
                                     GSimpleAction* action,
                                     GVariant* param);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
VALA_EXTERN ClocksContentItem* clocks_content_store_find (ClocksContentStore* self,
                                              ClocksContentStoreFindFunc func,
                                              gpointer func_target);
static gboolean __lambda81_ (Block3Data* _data3_,
                      ClocksContentItem* a);
VALA_EXTERN const gchar* clocks_alarm_item_get_id (ClocksAlarmItem* self);
static gchar* _variant_get1 (GVariant* value);
static gboolean ___lambda81__clocks_content_store_find_func (ClocksContentItem* item,
                                                      gpointer self);
VALA_EXTERN void clocks_alarm_item_stop (ClocksAlarmItem* self,
                             gboolean missed);
static void __clocks_alarm_face___lambda80__g_simple_action_activate (GSimpleAction* _sender,
                                                               GVariant* parameter,
                                                               gpointer self);
static void _clocks_alarm_face___lambda82_ (ClocksAlarmFace* self,
                                     GSimpleAction* action,
                                     GVariant* param);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static gboolean __lambda83_ (Block4Data* _data4_,
                      ClocksContentItem* a);
static gchar* _variant_get2 (GVariant* value);
static gboolean ___lambda83__clocks_content_store_find_func (ClocksContentItem* item,
                                                      gpointer self);
VALA_EXTERN void clocks_alarm_item_snooze (ClocksAlarmItem* self);
static void __clocks_alarm_face___lambda82__g_simple_action_activate (GSimpleAction* _sender,
                                                               GVariant* parameter,
                                                               gpointer self);
static GtkWidget* _clocks_alarm_face___lambda84_ (ClocksAlarmFace* self,
                                           GObject* item);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
VALA_EXTERN GType clocks_alarm_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksAlarmRow, g_object_unref)
VALA_EXTERN ClocksAlarmRow* clocks_alarm_row_new (ClocksAlarmItem* alarm);
VALA_EXTERN ClocksAlarmRow* clocks_alarm_row_construct (GType object_type,
                                            ClocksAlarmItem* alarm);
static void __lambda87_ (Block5Data* _data5_);
static void ___lambda87__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda88_ (Block5Data* _data5_);
static void ___lambda88__clocks_alarm_row_remove_alarm (ClocksAlarmRow* _sender,
                                                 gpointer self);
static GtkWidget* __clocks_alarm_face___lambda84__gtk_list_box_create_widget_func (GObject* item,
                                                                            gpointer self);
static void _clocks_alarm_face___lambda89_ (ClocksAlarmFace* self,
                                     GtkListBoxRow* row);
VALA_EXTERN ClocksAlarmItem* clocks_alarm_row_get_alarm (ClocksAlarmRow* self);
static void __clocks_alarm_face___lambda89__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                 GtkListBoxRow* row,
                                                                 gpointer self);
static void _clocks_alarm_face___lambda90_ (ClocksAlarmFace* self,
                                     guint position,
                                     guint removed,
                                     guint added);
static void __clocks_alarm_face___lambda90__g_list_model_items_changed (GListModel* _sender,
                                                                 guint position,
                                                                 guint removed,
                                                                 guint added,
                                                                 gpointer self);
VALA_EXTERN GType clocks_utils_wall_clock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksUtilsWallClock, g_object_unref)
VALA_EXTERN ClocksUtilsWallClock* clocks_utils_wall_clock_get_default (void);
static void _clocks_alarm_face___lambda91_ (ClocksAlarmFace* self);
static void __lambda92_ (ClocksAlarmFace* self,
                  ClocksContentItem* i);
VALA_EXTERN gboolean clocks_alarm_item_tick (ClocksAlarmItem* self);
VALA_EXTERN GType clocks_alarm_item_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ClocksAlarmItemState clocks_alarm_item_get_state (ClocksAlarmItem* self);
static void ___lambda92__clocks_content_store_foreach_func (ClocksContentItem* item,
                                                     gpointer self);
static void __clocks_alarm_face___lambda91__clocks_utils_wall_clock_tick (ClocksUtilsWallClock* _sender,
                                                                   gpointer self);
VALA_EXTERN void clocks_clock_activate_new (ClocksClock* self);
VALA_EXTERN ClocksPanelId clocks_clock_get_panel_id (ClocksClock* self);
VALA_EXTERN ClocksButtonMode clocks_clock_get_button_mode (ClocksClock* self);
VALA_EXTERN void clocks_clock_set_button_mode (ClocksClock* self,
                                   ClocksButtonMode value);
VALA_EXTERN const gchar* clocks_clock_get_new_label (ClocksClock* self);
static void clocks_alarm_face_finalize (GObject * obj);
static GType clocks_alarm_face_get_type_once (void);
static void _vala_clocks_alarm_face_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_clocks_alarm_face_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

static inline gpointer
clocks_alarm_face_get_instance_private (ClocksAlarmFace* self)
{
	return G_STRUCT_MEMBER_P (self, ClocksAlarmFace_private_offset);
}

static void
__lambda71_ (ClocksAlarmFace* self)
{
	GtkSortListModel* _tmp0_;
	GtkSorter* _tmp1_;
	GtkSorter* _tmp2_;
	_tmp0_ = self->priv->sorted_alarms;
	_tmp1_ = gtk_sort_list_model_get_sorter (_tmp0_);
	_tmp2_ = _tmp1_;
	gtk_sorter_changed (_tmp2_, GTK_SORTER_CHANGE_DIFFERENT);
}

static void
___lambda71__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda71_ ((ClocksAlarmFace*) self);
}

static void
clocks_alarm_face_connect_item (ClocksAlarmFace* self,
                                ClocksAlarmItem* item)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	g_signal_connect_object ((GObject*) item, "notify::time", (GCallback) ___lambda71__g_object_notify, self, 0);
}

static ClocksContentItem*
_clocks_alarm_item_deserialize_clocks_content_store_deserialize_item_func (GVariant* v,
                                                                           gpointer self)
{
	ClocksContentItem* result;
	result = clocks_alarm_item_deserialize (v);
	return result;
}

static void
__lambda72_ (ClocksAlarmFace* self,
             ClocksContentItem* item)
{
	g_return_if_fail (item != NULL);
	clocks_alarm_face_connect_item (self, G_TYPE_CHECK_INSTANCE_CAST (item, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem));
}

static void
___lambda72__clocks_content_store_foreach_func (ClocksContentItem* item,
                                                gpointer self)
{
	__lambda72_ ((ClocksAlarmFace*) self, item);
}

static void
clocks_alarm_face_load (ClocksAlarmFace* self)
{
	ClocksContentStore* _tmp0_;
	GSettings* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	ClocksContentStore* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->alarms;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_value (_tmp1_, "alarms");
	_tmp3_ = _tmp2_;
	clocks_content_store_deserialize (_tmp0_, _tmp3_, _clocks_alarm_item_deserialize_clocks_content_store_deserialize_item_func, NULL);
	_g_variant_unref0 (_tmp3_);
	_tmp4_ = self->priv->alarms;
	clocks_content_store_foreach (_tmp4_, ___lambda72__clocks_content_store_foreach_func, self);
}

static void
clocks_alarm_face_save (ClocksAlarmFace* self)
{
	GSettings* _tmp0_;
	ClocksContentStore* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->alarms;
	_tmp2_ = clocks_content_store_serialize (_tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_value (_tmp0_, "alarms", _tmp3_);
	_g_variant_unref0 (_tmp3_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ClocksAlarmFace* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->alarm);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda73_ (Block1Data* _data1_)
{
	ClocksAlarmFace* self;
	ClocksAlarmItem* _tmp0_;
	AdwToast* _tmp1_;
	self = _data1_->self;
	_tmp0_ = self->priv->ring_time_toast_alarm;
	if (_data1_->alarm == _tmp0_) {
		_g_object_unref0 (self->priv->ring_time_toast_alarm);
		self->priv->ring_time_toast_alarm = NULL;
	}
	_tmp1_ = self->priv->ring_time_toast;
	g_signal_handler_disconnect ((GObject*) _tmp1_, _data1_->handler_id1);
	g_signal_handler_disconnect ((GObject*) _data1_->alarm, _data1_->handler_id2);
}

static void
___lambda73__adw_toast_dismissed (AdwToast* _sender,
                                  gpointer self)
{
	__lambda73_ (self);
}

static void
__lambda74_ (Block1Data* _data1_)
{
	ClocksAlarmFace* self;
	gboolean _tmp0_ = FALSE;
	ClocksAlarmItem* _tmp1_;
	self = _data1_->self;
	_tmp1_ = self->priv->ring_time_toast_alarm;
	if (_data1_->alarm == _tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = clocks_alarm_item_get_active (_data1_->alarm);
		_tmp3_ = _tmp2_;
		_tmp0_ = !_tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		AdwToast* _tmp4_;
		_tmp4_ = self->priv->ring_time_toast;
		adw_toast_dismiss (_tmp4_);
		_g_object_unref0 (self->priv->ring_time_toast_alarm);
		self->priv->ring_time_toast_alarm = NULL;
	}
}

static void
___lambda74__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda74_ (self);
}

static void
clocks_alarm_face_show_ring_time_toast (ClocksAlarmFace* self,
                                        ClocksAlarmItem* alarm)
{
	Block1Data* _data1_;
	ClocksAlarmItem* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	ClocksWindow* window = NULL;
	GtkRoot* _tmp3_;
	ClocksWindow* _tmp4_;
	GDateTime* now = NULL;
	GTimeZone* _tmp5_;
	GTimeZone* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	gchar* time_left_string = NULL;
	GDateTime* _tmp9_;
	GDateTime* _tmp10_;
	GDateTime* _tmp11_;
	gchar* _tmp12_;
	AdwToast* _tmp13_;
	AdwToast* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	ClocksAlarmItem* _tmp20_;
	AdwToast* _tmp21_;
	gulong _tmp22_;
	gulong _tmp23_;
	ClocksWindow* _tmp24_;
	AdwToast* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (alarm != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (alarm);
	_g_object_unref0 (_data1_->alarm);
	_data1_->alarm = _tmp0_;
	_tmp1_ = clocks_alarm_item_get_ring_time (_data1_->alarm);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	_tmp3_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, CLOCKS_TYPE_WINDOW, ClocksWindow));
	window = _tmp4_;
	_tmp5_ = g_time_zone_new_local ();
	_tmp6_ = _tmp5_;
	_tmp7_ = g_date_time_new_now (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_time_zone_unref0 (_tmp6_);
	now = _tmp8_;
	_tmp9_ = clocks_alarm_item_get_ring_time (_data1_->alarm);
	_tmp10_ = _tmp9_;
	_tmp11_ = now;
	_tmp12_ = clocks_utils_format_time_span (g_date_time_difference (_tmp10_, _tmp11_));
	time_left_string = _tmp12_;
	_tmp13_ = self->priv->ring_time_toast;
	if (_tmp13_ == NULL) {
		AdwToast* _tmp14_;
		_tmp14_ = adw_toast_new ("");
		_g_object_unref0 (self->priv->ring_time_toast);
		self->priv->ring_time_toast = _tmp14_;
	} else {
		AdwToast* _tmp15_;
		_tmp15_ = self->priv->ring_time_toast;
		adw_toast_dismiss (_tmp15_);
	}
	_tmp16_ = self->priv->ring_time_toast;
	_tmp17_ = time_left_string;
	_tmp18_ = g_strdup_printf (_ ("Alarm set for %s from now"), _tmp17_);
	_tmp19_ = _tmp18_;
	adw_toast_set_title (_tmp16_, _tmp19_);
	_g_free0 (_tmp19_);
	_tmp20_ = _g_object_ref0 (_data1_->alarm);
	_g_object_unref0 (self->priv->ring_time_toast_alarm);
	self->priv->ring_time_toast_alarm = _tmp20_;
	_data1_->handler_id1 = (gulong) 0;
	_data1_->handler_id2 = (gulong) 0;
	_tmp21_ = self->priv->ring_time_toast;
	_tmp22_ = g_signal_connect_data (_tmp21_, "dismissed", (GCallback) ___lambda73__adw_toast_dismissed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_data1_->handler_id1 = _tmp22_;
	_tmp23_ = g_signal_connect_data ((GObject*) _data1_->alarm, "notify::active", (GCallback) ___lambda74__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_data1_->handler_id2 = _tmp23_;
	_tmp24_ = window;
	_tmp25_ = self->priv->ring_time_toast;
	clocks_window_add_toast (_tmp24_, _tmp25_);
	_g_free0 (time_left_string);
	_g_date_time_unref0 (now);
	_g_object_unref0 (window);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		ClocksAlarmFace* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->alarm);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda77_ (Block2Data* _data2_,
             ClocksAlarmSetupDialog* dialog,
             gint response)
{
	ClocksAlarmFace* self;
	self = _data2_->self;
	g_return_if_fail (dialog != NULL);
	if (response == ((gint) GTK_RESPONSE_OK)) {
		clocks_alarm_setup_dialog_apply_to_alarm (G_TYPE_CHECK_INSTANCE_CAST (dialog, CLOCKS_ALARM_TYPE_SETUP_DIALOG, ClocksAlarmSetupDialog), _data2_->alarm);
		clocks_alarm_item_set_active (_data2_->alarm, TRUE);
		clocks_alarm_face_save (self);
	} else {
		if (response == CLOCKS_ALARM_DELETE_ALARM) {
			ClocksContentStore* _tmp0_;
			_tmp0_ = self->priv->alarms;
			clocks_content_store_delete_item (_tmp0_, (ClocksContentItem*) _data2_->alarm);
			clocks_alarm_face_save (self);
		}
	}
	adw_dialog_close ((AdwDialog*) dialog);
}

static void
___lambda77__clocks_alarm_setup_dialog_response (ClocksAlarmSetupDialog* _sender,
                                                 gint response,
                                                 gpointer self)
{
	__lambda77_ (self, _sender, response);
}

void
clocks_alarm_face_edit (ClocksAlarmFace* self,
                        ClocksAlarmItem* alarm)
{
	Block2Data* _data2_;
	ClocksAlarmItem* _tmp0_;
	ClocksAlarmSetupDialog* dialog = NULL;
	ClocksContentStore* _tmp1_;
	ClocksAlarmSetupDialog* _tmp2_;
	GtkRoot* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (alarm != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (alarm);
	_g_object_unref0 (_data2_->alarm);
	_data2_->alarm = _tmp0_;
	_tmp1_ = self->priv->alarms;
	_tmp2_ = clocks_alarm_setup_dialog_new (_data2_->alarm, (GListModel*) _tmp1_);
	g_object_ref_sink (_tmp2_);
	dialog = _tmp2_;
	g_signal_connect_data (dialog, "response", (GCallback) ___lambda77__clocks_alarm_setup_dialog_response, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp3_ = gtk_widget_get_root ((GtkWidget*) self);
	adw_dialog_present ((AdwDialog*) dialog, (GtkWidget*) _tmp3_);
	_g_object_unref0 (dialog);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static void
clocks_alarm_face_reset_view (ClocksAlarmFace* self)
{
	GtkWidget* _tmp0_ = NULL;
	ClocksContentStore* _tmp1_;
	GtkStack* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->alarms;
	if (g_list_model_get_n_items ((GListModel*) _tmp1_) == ((guint) 0)) {
		GtkWidget* _tmp2_;
		_tmp2_ = self->priv->empty_view;
		_tmp0_ = _tmp2_;
	} else {
		GtkScrolledWindow* _tmp3_;
		_tmp3_ = self->priv->list_view;
		_tmp0_ = (GtkWidget*) _tmp3_;
	}
	_tmp4_ = self->priv->stack;
	gtk_stack_set_visible_child (_tmp4_, _tmp0_);
}

static void
__lambda78_ (ClocksAlarmFace* self,
             ClocksAlarmSetupDialog* dialog,
             gint response)
{
	g_return_if_fail (dialog != NULL);
	if (response == ((gint) GTK_RESPONSE_OK)) {
		ClocksAlarmItem* alarm = NULL;
		ClocksAlarmItem* _tmp0_;
		ClocksAlarmItem* _tmp1_;
		ClocksContentStore* _tmp2_;
		ClocksAlarmItem* _tmp3_;
		ClocksAlarmItem* _tmp4_;
		ClocksAlarmItem* _tmp5_;
		_tmp0_ = clocks_alarm_item_new (NULL);
		alarm = _tmp0_;
		_tmp1_ = alarm;
		clocks_alarm_setup_dialog_apply_to_alarm (G_TYPE_CHECK_INSTANCE_CAST (dialog, CLOCKS_ALARM_TYPE_SETUP_DIALOG, ClocksAlarmSetupDialog), _tmp1_);
		_tmp2_ = self->priv->alarms;
		_tmp3_ = alarm;
		clocks_content_store_add (_tmp2_, (ClocksContentItem*) _tmp3_);
		_tmp4_ = alarm;
		clocks_alarm_face_connect_item (self, _tmp4_);
		_tmp5_ = alarm;
		clocks_alarm_face_show_ring_time_toast (self, _tmp5_);
		clocks_alarm_face_save (self);
		_g_object_unref0 (alarm);
	}
	adw_dialog_close ((AdwDialog*) dialog);
}

static void
___lambda78__clocks_alarm_setup_dialog_response (ClocksAlarmSetupDialog* _sender,
                                                 gint response,
                                                 gpointer self)
{
	__lambda78_ ((ClocksAlarmFace*) self, _sender, response);
}

static void
clocks_alarm_face_real_activate_new (ClocksClock* base)
{
	ClocksAlarmFace * self;
	ClocksAlarmSetupDialog* dialog = NULL;
	ClocksContentStore* _tmp0_;
	ClocksAlarmSetupDialog* _tmp1_;
	GtkRoot* _tmp2_;
	self = (ClocksAlarmFace*) base;
	_tmp0_ = self->priv->alarms;
	_tmp1_ = clocks_alarm_setup_dialog_new (NULL, (GListModel*) _tmp0_);
	g_object_ref_sink (_tmp1_);
	dialog = _tmp1_;
	g_signal_connect_object (dialog, "response", (GCallback) ___lambda78__clocks_alarm_setup_dialog_response, self, 0);
	_tmp2_ = gtk_widget_get_root ((GtkWidget*) self);
	adw_dialog_present ((AdwDialog*) dialog, (GtkWidget*) _tmp2_);
	_g_object_unref0 (dialog);
}

ClocksAlarmFace*
clocks_alarm_face_construct (GType object_type)
{
	ClocksAlarmFace * self = NULL;
	self = (ClocksAlarmFace*) g_object_new (object_type, NULL);
	return self;
}

ClocksAlarmFace*
clocks_alarm_face_new (void)
{
	return clocks_alarm_face_construct (CLOCKS_ALARM_TYPE_FACE);
}

static ClocksPanelId
clocks_alarm_face_real_get_panel_id (ClocksClock* base)
{
	ClocksPanelId result;
	ClocksAlarmFace* self;
	self = (ClocksAlarmFace*) base;
	result = self->priv->_panel_id;
	return result;
}

static void
clocks_alarm_face_real_set_panel_id (ClocksClock* base,
                                     ClocksPanelId value)
{
	ClocksAlarmFace* self;
	ClocksPanelId old_value;
	self = (ClocksAlarmFace*) base;
	old_value = clocks_alarm_face_real_get_panel_id (base);
	if (old_value != value) {
		self->priv->_panel_id = value;
		g_object_notify_by_pspec ((GObject *) self, clocks_alarm_face_properties[CLOCKS_ALARM_FACE_PANEL_ID_PROPERTY]);
	}
}

static ClocksButtonMode
clocks_alarm_face_real_get_button_mode (ClocksClock* base)
{
	ClocksButtonMode result;
	ClocksAlarmFace* self;
	self = (ClocksAlarmFace*) base;
	result = self->priv->_button_mode;
	return result;
}

static void
clocks_alarm_face_real_set_button_mode (ClocksClock* base,
                                        ClocksButtonMode value)
{
	ClocksAlarmFace* self;
	ClocksButtonMode old_value;
	self = (ClocksAlarmFace*) base;
	old_value = clocks_alarm_face_real_get_button_mode (base);
	if (old_value != value) {
		self->priv->_button_mode = value;
		g_object_notify_by_pspec ((GObject *) self, clocks_alarm_face_properties[CLOCKS_ALARM_FACE_BUTTON_MODE_PROPERTY]);
	}
}

static const gchar*
clocks_alarm_face_real_get_new_label (ClocksClock* base)
{
	const gchar* result;
	ClocksAlarmFace* self;
	const gchar* _tmp0_;
	self = (ClocksAlarmFace*) base;
	_tmp0_ = self->priv->_new_label;
	result = _tmp0_;
	return result;
}

static gint
_clocks_alarm_face___lambda79_ (ClocksAlarmFace* self,
                                gconstpointer a,
                                gconstpointer b)
{
	gint result;
	result = clocks_alarm_item_compare (G_TYPE_CHECK_INSTANCE_CAST (a, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem), G_TYPE_CHECK_INSTANCE_CAST (b, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem));
	return result;
}

static gint
__clocks_alarm_face___lambda79__gcompare_data_func (gconstpointer a,
                                                    gconstpointer b,
                                                    gpointer self)
{
	gint result;
	result = _clocks_alarm_face___lambda79_ ((ClocksAlarmFace*) self, a, b);
	return result;
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		ClocksAlarmFace* self;
		self = _data3_->self;
		_g_variant_unref0 (_data3_->param);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gchar*
_variant_get1 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static gboolean
__lambda81_ (Block3Data* _data3_,
             ClocksContentItem* a)
{
	ClocksAlarmFace* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	self = _data3_->self;
	g_return_val_if_fail (a != NULL, FALSE);
	_tmp0_ = clocks_alarm_item_get_id (G_TYPE_CHECK_INSTANCE_CAST (a, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem));
	_tmp1_ = _tmp0_;
	_tmp2_ = _variant_get1 (_data3_->param);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp1_, _tmp3_) == 0;
	_g_free0 (_tmp3_);
	result = _tmp4_;
	return result;
}

static gboolean
___lambda81__clocks_content_store_find_func (ClocksContentItem* item,
                                             gpointer self)
{
	gboolean result;
	result = __lambda81_ (self, item);
	return result;
}

static void
_clocks_alarm_face___lambda80_ (ClocksAlarmFace* self,
                                GSimpleAction* action,
                                GVariant* param)
{
	Block3Data* _data3_;
	GVariant* _tmp0_;
	ClocksContentItem* a = NULL;
	ClocksContentStore* _tmp1_;
	ClocksContentItem* _tmp2_;
	ClocksContentItem* _tmp3_;
	g_return_if_fail (action != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = _g_variant_ref0 (param);
	_g_variant_unref0 (_data3_->param);
	_data3_->param = _tmp0_;
	_tmp1_ = self->priv->alarms;
	_tmp2_ = clocks_content_store_find (_tmp1_, ___lambda81__clocks_content_store_find_func, _data3_);
	a = _tmp2_;
	_tmp3_ = a;
	if (_tmp3_ != NULL) {
		ClocksContentItem* _tmp4_;
		_tmp4_ = a;
		clocks_alarm_item_stop (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem), FALSE);
	}
	_g_object_unref0 (a);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
__clocks_alarm_face___lambda80__g_simple_action_activate (GSimpleAction* _sender,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	_clocks_alarm_face___lambda80_ ((ClocksAlarmFace*) self, _sender, parameter);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		ClocksAlarmFace* self;
		self = _data4_->self;
		_g_variant_unref0 (_data4_->param);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static gchar*
_variant_get2 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static gboolean
__lambda83_ (Block4Data* _data4_,
             ClocksContentItem* a)
{
	ClocksAlarmFace* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	self = _data4_->self;
	g_return_val_if_fail (a != NULL, FALSE);
	_tmp0_ = clocks_alarm_item_get_id (G_TYPE_CHECK_INSTANCE_CAST (a, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem));
	_tmp1_ = _tmp0_;
	_tmp2_ = _variant_get2 (_data4_->param);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp1_, _tmp3_) == 0;
	_g_free0 (_tmp3_);
	result = _tmp4_;
	return result;
}

static gboolean
___lambda83__clocks_content_store_find_func (ClocksContentItem* item,
                                             gpointer self)
{
	gboolean result;
	result = __lambda83_ (self, item);
	return result;
}

static void
_clocks_alarm_face___lambda82_ (ClocksAlarmFace* self,
                                GSimpleAction* action,
                                GVariant* param)
{
	Block4Data* _data4_;
	GVariant* _tmp0_;
	ClocksContentItem* a = NULL;
	ClocksContentStore* _tmp1_;
	ClocksContentItem* _tmp2_;
	ClocksContentItem* _tmp3_;
	g_return_if_fail (action != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = _g_variant_ref0 (param);
	_g_variant_unref0 (_data4_->param);
	_data4_->param = _tmp0_;
	_tmp1_ = self->priv->alarms;
	_tmp2_ = clocks_content_store_find (_tmp1_, ___lambda83__clocks_content_store_find_func, _data4_);
	a = _tmp2_;
	_tmp3_ = a;
	if (_tmp3_ != NULL) {
		ClocksContentItem* _tmp4_;
		_tmp4_ = a;
		clocks_alarm_item_snooze (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem));
	}
	_g_object_unref0 (a);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
__clocks_alarm_face___lambda82__g_simple_action_activate (GSimpleAction* _sender,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	_clocks_alarm_face___lambda82_ ((ClocksAlarmFace*) self, _sender, parameter);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		ClocksAlarmFace* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->item);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
__lambda87_ (Block5Data* _data5_)
{
	ClocksAlarmFace* self;
	self = _data5_->self;
	clocks_alarm_face_show_ring_time_toast (self, G_TYPE_CHECK_INSTANCE_CAST (_data5_->item, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem));
	clocks_alarm_face_save (self);
}

static void
___lambda87__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda87_ (self);
}

static void
__lambda88_ (Block5Data* _data5_)
{
	ClocksAlarmFace* self;
	ClocksContentStore* _tmp0_;
	gboolean _tmp1_ = FALSE;
	AdwToast* _tmp2_;
	self = _data5_->self;
	_tmp0_ = self->priv->alarms;
	clocks_content_store_delete_item (_tmp0_, (ClocksContentItem*) G_TYPE_CHECK_INSTANCE_CAST (_data5_->item, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem));
	_tmp2_ = self->priv->ring_time_toast;
	if (_tmp2_ != NULL) {
		ClocksAlarmItem* _tmp3_;
		_tmp3_ = self->priv->ring_time_toast_alarm;
		_tmp1_ = _data5_->item == G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, G_TYPE_OBJECT, GObject);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		AdwToast* _tmp4_;
		_g_object_unref0 (self->priv->ring_time_toast_alarm);
		self->priv->ring_time_toast_alarm = NULL;
		_tmp4_ = self->priv->ring_time_toast;
		adw_toast_dismiss (_tmp4_);
	}
	clocks_alarm_face_save (self);
}

static void
___lambda88__clocks_alarm_row_remove_alarm (ClocksAlarmRow* _sender,
                                            gpointer self)
{
	__lambda88_ (self);
}

static GtkWidget*
_clocks_alarm_face___lambda84_ (ClocksAlarmFace* self,
                                GObject* item)
{
	Block5Data* _data5_;
	GObject* _tmp0_;
	ClocksAlarmRow* row = NULL;
	ClocksAlarmRow* _tmp1_;
	ClocksAlarmRow* _tmp2_;
	GtkWidget* result;
	g_return_val_if_fail (item != NULL, NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (item);
	_g_object_unref0 (_data5_->item);
	_data5_->item = _tmp0_;
	_tmp1_ = clocks_alarm_row_new (G_TYPE_CHECK_INSTANCE_CAST (_data5_->item, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem));
	g_object_ref_sink (_tmp1_);
	row = _tmp1_;
	g_signal_connect_data (_data5_->item, "notify::ring-time", (GCallback) ___lambda87__g_object_notify, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp2_ = row;
	g_signal_connect_data (_tmp2_, "remove-alarm", (GCallback) ___lambda88__clocks_alarm_row_remove_alarm, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	result = (GtkWidget*) row;
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return result;
}

static GtkWidget*
__clocks_alarm_face___lambda84__gtk_list_box_create_widget_func (GObject* item,
                                                                 gpointer self)
{
	GtkWidget* result;
	result = _clocks_alarm_face___lambda84_ ((ClocksAlarmFace*) self, item);
	return result;
}

static void
_clocks_alarm_face___lambda89_ (ClocksAlarmFace* self,
                                GtkListBoxRow* row)
{
	ClocksAlarmItem* alarm = NULL;
	ClocksAlarmItem* _tmp0_;
	ClocksAlarmItem* _tmp1_;
	ClocksAlarmItem* _tmp2_;
	ClocksAlarmItem* _tmp3_;
	g_return_if_fail (row != NULL);
	_tmp0_ = clocks_alarm_row_get_alarm (G_TYPE_CHECK_INSTANCE_CAST (row, CLOCKS_ALARM_TYPE_ROW, ClocksAlarmRow));
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	alarm = _tmp2_;
	_tmp3_ = alarm;
	clocks_alarm_face_edit (self, _tmp3_);
	_g_object_unref0 (alarm);
}

static void
__clocks_alarm_face___lambda89__gtk_list_box_row_activated (GtkListBox* _sender,
                                                            GtkListBoxRow* row,
                                                            gpointer self)
{
	_clocks_alarm_face___lambda89_ ((ClocksAlarmFace*) self, row);
}

static void
_clocks_alarm_face___lambda90_ (ClocksAlarmFace* self,
                                guint position,
                                guint removed,
                                guint added)
{
	clocks_alarm_face_save (self);
	clocks_alarm_face_reset_view (self);
}

static void
__clocks_alarm_face___lambda90__g_list_model_items_changed (GListModel* _sender,
                                                            guint position,
                                                            guint removed,
                                                            guint added,
                                                            gpointer self)
{
	_clocks_alarm_face___lambda90_ ((ClocksAlarmFace*) self, position, removed, added);
}

static void
__lambda92_ (ClocksAlarmFace* self,
             ClocksContentItem* i)
{
	ClocksAlarmItem* a = NULL;
	ClocksAlarmItem* _tmp0_;
	ClocksAlarmItem* _tmp1_;
	g_return_if_fail (i != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (i, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem));
	a = _tmp0_;
	_tmp1_ = a;
	if (clocks_alarm_item_tick (_tmp1_)) {
		ClocksAlarmItem* _tmp2_;
		ClocksAlarmItemState _tmp3_;
		ClocksAlarmItemState _tmp4_;
		_tmp2_ = a;
		_tmp3_ = clocks_alarm_item_get_state (_tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_ == CLOCKS_ALARM_ITEM_STATE_RINGING) {
			ClocksAlarmItem* _tmp5_;
			_tmp5_ = a;
			g_signal_emit (self, clocks_alarm_face_signals[CLOCKS_ALARM_FACE_RING_SIGNAL], 0, _tmp5_);
		}
	}
	_g_object_unref0 (a);
}

static void
___lambda92__clocks_content_store_foreach_func (ClocksContentItem* item,
                                                gpointer self)
{
	__lambda92_ ((ClocksAlarmFace*) self, item);
}

static void
_clocks_alarm_face___lambda91_ (ClocksAlarmFace* self)
{
	ClocksContentStore* _tmp0_;
	_tmp0_ = self->priv->alarms;
	clocks_content_store_foreach (_tmp0_, ___lambda92__clocks_content_store_foreach_func, self);
}

static void
__clocks_alarm_face___lambda91__clocks_utils_wall_clock_tick (ClocksUtilsWallClock* _sender,
                                                              gpointer self)
{
	_clocks_alarm_face___lambda91_ ((ClocksAlarmFace*) self);
}

static GObject *
clocks_alarm_face_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ClocksAlarmFace * self;
	ClocksContentStore* _tmp0_;
	GSettings* _tmp1_;
	ClocksContentStore* _tmp2_;
	GListModel* _tmp3_;
	GtkCustomSorter* _tmp4_;
	GtkSortListModel* _tmp5_;
	GApplication* app = NULL;
	GApplication* _tmp6_;
	GApplication* _tmp7_;
	GSimpleAction* action = NULL;
	GApplication* _tmp8_;
	GAction* _tmp9_;
	GSimpleAction* _tmp10_;
	GSimpleAction* _tmp11_;
	GApplication* _tmp12_;
	GAction* _tmp13_;
	GSimpleAction* _tmp14_;
	GSimpleAction* _tmp15_;
	GtkListBox* _tmp16_;
	GtkSortListModel* _tmp17_;
	GtkListBox* _tmp18_;
	ClocksContentStore* _tmp19_;
	ClocksUtilsWallClock* _tmp20_;
	ClocksUtilsWallClock* _tmp21_;
	parent_class = G_OBJECT_CLASS (clocks_alarm_face_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_ALARM_TYPE_FACE, ClocksAlarmFace);
	clocks_clock_set_panel_id ((ClocksClock*) self, CLOCKS_PANEL_ID_ALARM);
	_tmp0_ = clocks_content_store_new ();
	_g_object_unref0 (self->priv->alarms);
	self->priv->alarms = _tmp0_;
	_tmp1_ = g_settings_new ("org.gnome.clocks");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	_tmp2_ = self->priv->alarms;
	_tmp3_ = _g_object_ref0 ((GListModel*) _tmp2_);
	_tmp4_ = gtk_custom_sorter_new (__clocks_alarm_face___lambda79__gcompare_data_func, g_object_ref (self), g_object_unref);
	_tmp5_ = gtk_sort_list_model_new (_tmp3_, (GtkSorter*) _tmp4_);
	_g_object_unref0 (self->priv->sorted_alarms);
	self->priv->sorted_alarms = _tmp5_;
	_tmp6_ = g_application_get_default ();
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, g_application_get_type (), GApplication));
	app = _tmp7_;
	_tmp8_ = app;
	_tmp9_ = g_action_map_lookup_action ((GActionMap*) _tmp8_, "stop-alarm");
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, g_simple_action_get_type (), GSimpleAction));
	action = _tmp10_;
	_tmp11_ = action;
	g_signal_connect_object (_tmp11_, "activate", (GCallback) __clocks_alarm_face___lambda80__g_simple_action_activate, self, 0);
	_tmp12_ = app;
	_tmp13_ = g_action_map_lookup_action ((GActionMap*) _tmp12_, "snooze-alarm");
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (action);
	action = _tmp14_;
	_tmp15_ = action;
	g_signal_connect_object (_tmp15_, "activate", (GCallback) __clocks_alarm_face___lambda82__g_simple_action_activate, self, 0);
	_tmp16_ = self->priv->listbox;
	_tmp17_ = self->priv->sorted_alarms;
	gtk_list_box_bind_model (_tmp16_, (GListModel*) _tmp17_, __clocks_alarm_face___lambda84__gtk_list_box_create_widget_func, g_object_ref (self), g_object_unref);
	_tmp18_ = self->priv->listbox;
	g_signal_connect_object (_tmp18_, "row-activated", (GCallback) __clocks_alarm_face___lambda89__gtk_list_box_row_activated, self, 0);
	clocks_alarm_face_load (self);
	_tmp19_ = self->priv->alarms;
	g_signal_connect_object ((GListModel*) _tmp19_, "items-changed", (GCallback) __clocks_alarm_face___lambda90__g_list_model_items_changed, self, 0);
	clocks_alarm_face_reset_view (self);
	_tmp20_ = clocks_utils_wall_clock_get_default ();
	_tmp21_ = _tmp20_;
	g_signal_connect_object (_tmp21_, "tick", (GCallback) __clocks_alarm_face___lambda91__clocks_utils_wall_clock_tick, self, 0);
	_g_object_unref0 (_tmp21_);
	_g_object_unref0 (action);
	_g_object_unref0 (app);
	return obj;
}

static void
clocks_alarm_face_class_init (ClocksAlarmFaceClass * klass,
                              gpointer klass_data)
{
	clocks_alarm_face_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ClocksAlarmFace_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_alarm_face_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_alarm_face_set_property;
	G_OBJECT_CLASS (klass)->constructor = clocks_alarm_face_constructor;
	G_OBJECT_CLASS (klass)->finalize = clocks_alarm_face_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_FACE_PANEL_ID_PROPERTY, clocks_alarm_face_properties[CLOCKS_ALARM_FACE_PANEL_ID_PROPERTY] = g_param_spec_enum ("panel-id", "panel-id", "panel-id", CLOCKS_TYPE_PANEL_ID, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_FACE_BUTTON_MODE_PROPERTY, clocks_alarm_face_properties[CLOCKS_ALARM_FACE_BUTTON_MODE_PROPERTY] = g_param_spec_enum ("button-mode", "button-mode", "button-mode", CLOCKS_TYPE_BUTTON_MODE, CLOCKS_BUTTON_MODE_NEW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_FACE_NEW_LABEL_PROPERTY, clocks_alarm_face_properties[CLOCKS_ALARM_FACE_NEW_LABEL_PROPERTY] = g_param_spec_string ("new-label", "new-label", "new-label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/clocks/ui/alarm-face.ui");
	clocks_alarm_face_signals[CLOCKS_ALARM_FACE_RING_SIGNAL] = g_signal_new ("ring", CLOCKS_ALARM_TYPE_FACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, CLOCKS_ALARM_TYPE_ITEM);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "empty_view", FALSE, ClocksAlarmFace_private_offset + G_STRUCT_OFFSET (ClocksAlarmFacePrivate, empty_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "listbox", FALSE, ClocksAlarmFace_private_offset + G_STRUCT_OFFSET (ClocksAlarmFacePrivate, listbox));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "list_view", FALSE, ClocksAlarmFace_private_offset + G_STRUCT_OFFSET (ClocksAlarmFacePrivate, list_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, ClocksAlarmFace_private_offset + G_STRUCT_OFFSET (ClocksAlarmFacePrivate, stack));
}

static void
clocks_alarm_face_clocks_clock_interface_init (ClocksClockIface * iface,
                                               gpointer iface_data)
{
	clocks_alarm_face_clocks_clock_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate_new = (void (*) (ClocksClock*)) clocks_alarm_face_real_activate_new;
	iface->get_panel_id = clocks_alarm_face_real_get_panel_id;
	iface->set_panel_id = clocks_alarm_face_real_set_panel_id;
	iface->get_button_mode = clocks_alarm_face_real_get_button_mode;
	iface->set_button_mode = clocks_alarm_face_real_set_button_mode;
	iface->get_new_label = clocks_alarm_face_real_get_new_label;
}

static void
clocks_alarm_face_instance_init (ClocksAlarmFace * self,
                                 gpointer klass)
{
	gchar* _tmp0_;
	self->priv = clocks_alarm_face_get_instance_private (self);
	self->priv->_button_mode = CLOCKS_BUTTON_MODE_NEW;
	_tmp0_ = g_strdup (_ ("New Alarm"));
	self->priv->_new_label = _tmp0_;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
clocks_alarm_face_finalize (GObject * obj)
{
	ClocksAlarmFace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_ALARM_TYPE_FACE, ClocksAlarmFace);
	_g_free0 (self->priv->_new_label);
	_g_object_unref0 (self->priv->alarms);
	_g_object_unref0 (self->priv->sorted_alarms);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->ring_time_toast);
	_g_object_unref0 (self->priv->ring_time_toast_alarm);
	G_OBJECT_CLASS (clocks_alarm_face_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
clocks_alarm_face_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ClocksAlarmFaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_alarm_face_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksAlarmFace), 0, (GInstanceInitFunc) clocks_alarm_face_instance_init, NULL };
	static const GInterfaceInfo clocks_clock_info = { (GInterfaceInitFunc) clocks_alarm_face_clocks_clock_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType clocks_alarm_face_type_id;
	clocks_alarm_face_type_id = g_type_register_static (adw_bin_get_type (), "ClocksAlarmFace", &g_define_type_info, 0);
	g_type_add_interface_static (clocks_alarm_face_type_id, CLOCKS_TYPE_CLOCK, &clocks_clock_info);
	ClocksAlarmFace_private_offset = g_type_add_instance_private (clocks_alarm_face_type_id, sizeof (ClocksAlarmFacePrivate));
	return clocks_alarm_face_type_id;
}

GType
clocks_alarm_face_get_type (void)
{
	static gsize clocks_alarm_face_type_id__once = 0;
	if (g_once_init_enter (&clocks_alarm_face_type_id__once)) {
		GType clocks_alarm_face_type_id;
		clocks_alarm_face_type_id = clocks_alarm_face_get_type_once ();
		g_once_init_leave (&clocks_alarm_face_type_id__once, clocks_alarm_face_type_id);
	}
	return clocks_alarm_face_type_id__once;
}

static void
_vala_clocks_alarm_face_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	ClocksAlarmFace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_ALARM_TYPE_FACE, ClocksAlarmFace);
	switch (property_id) {
		case CLOCKS_ALARM_FACE_PANEL_ID_PROPERTY:
		g_value_set_enum (value, clocks_clock_get_panel_id ((ClocksClock*) self));
		break;
		case CLOCKS_ALARM_FACE_BUTTON_MODE_PROPERTY:
		g_value_set_enum (value, clocks_clock_get_button_mode ((ClocksClock*) self));
		break;
		case CLOCKS_ALARM_FACE_NEW_LABEL_PROPERTY:
		g_value_set_string (value, clocks_clock_get_new_label ((ClocksClock*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_clocks_alarm_face_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	ClocksAlarmFace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_ALARM_TYPE_FACE, ClocksAlarmFace);
	switch (property_id) {
		case CLOCKS_ALARM_FACE_PANEL_ID_PROPERTY:
		clocks_clock_set_panel_id ((ClocksClock*) self, g_value_get_enum (value));
		break;
		case CLOCKS_ALARM_FACE_BUTTON_MODE_PROPERTY:
		clocks_clock_set_button_mode ((ClocksClock*) self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

