/* UIManager.c generated by valac 0.56.17, the Vala compiler
 * generated from UIManager.vala, do not modify */

/* UIManager.vala
 *
 * Copyright 2020-2021 Dylan McCall <dylan@dylanmccall.ca>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "daemon.h"
#include <gtk/gtk.h>
#include "common.h"
#include <gsound.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gio/gio.h>

#define BREAK_TIMER_DAEMON_UI_MANAGER_TRANSIENT_NOTIFICATION_INTERVAL_SECONDS ((guint) 30)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BREAK_TIMER_DAEMON_UI_MANAGER_0_PROPERTY,
	BREAK_TIMER_DAEMON_UI_MANAGER_NUM_PROPERTIES
};
static GParamSpec* break_timer_daemon_ui_manager_properties[BREAK_TIMER_DAEMON_UI_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;

struct _BreakTimerDaemonUIManagerPrivate {
	GtkApplication* application;
	BreakTimerCommonISessionStatus* session_status;
	GSoundContext* gsound;
	GHashTable* transient_notification_timeout_ids;
};

struct _Block1Data {
	int _ref_count_;
	BreakTimerDaemonUIManager* self;
	gchar* id;
};

static gint BreakTimerDaemonUIManager_private_offset;
static gpointer break_timer_daemon_ui_manager_parent_class = NULL;
static GInitableIface * break_timer_daemon_ui_manager_g_initable_parent_iface = NULL;

static void _g_free0_ (gpointer var);
static void break_timer_daemon_ui_manager_on_session_unlocked_cb (BreakTimerDaemonUIManager* self);
static void _break_timer_daemon_ui_manager_on_session_unlocked_cb_break_timer_common_isession_status_unlocked (BreakTimerCommonISessionStatus* _sender,
                                                                                                        gpointer self);
static gboolean break_timer_daemon_ui_manager_real_init (GInitable* base,
                                                  GCancellable* cancellable,
                                                  GError** error);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean ___lambda5_ (Block1Data* _data1_);
static gboolean ____lambda5__gsource_func (gpointer self);
static void __lambda4_ (BreakTimerDaemonUIManager* self,
                 const gchar* notification_id,
                 guint source_id);
static void ___lambda4__gh_func (gconstpointer key,
                          gconstpointer value,
                          gpointer self);
static void break_timer_daemon_ui_manager_finalize (GObject * obj);
static GType break_timer_daemon_ui_manager_get_type_once (void);

static inline gpointer
break_timer_daemon_ui_manager_get_instance_private (BreakTimerDaemonUIManager* self)
{
	return G_STRUCT_MEMBER_P (self, BreakTimerDaemonUIManager_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_break_timer_daemon_ui_manager_on_session_unlocked_cb_break_timer_common_isession_status_unlocked (BreakTimerCommonISessionStatus* _sender,
                                                                                                   gpointer self)
{
	break_timer_daemon_ui_manager_on_session_unlocked_cb ((BreakTimerDaemonUIManager*) self);
}

BreakTimerDaemonUIManager*
break_timer_daemon_ui_manager_construct (GType object_type,
                                         GtkApplication* application,
                                         BreakTimerCommonISessionStatus* session_status)
{
	BreakTimerDaemonUIManager * self = NULL;
	BreakTimerCommonISessionStatus* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	BreakTimerCommonISessionStatus* _tmp4_;
	g_return_val_if_fail (application != NULL, NULL);
	g_return_val_if_fail (session_status != NULL, NULL);
	self = (BreakTimerDaemonUIManager*) break_timer_daemon_util_simple_focus_manager_construct (object_type);
	self->priv->application = application;
	_tmp0_ = _g_object_ref0 (session_status);
	_g_object_unref0 (self->priv->session_status);
	self->priv->session_status = _tmp0_;
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, NULL);
	_g_hash_table_unref0 (self->priv->transient_notification_timeout_ids);
	self->priv->transient_notification_timeout_ids = _tmp3_;
	_tmp4_ = self->priv->session_status;
	g_signal_connect_object (_tmp4_, "unlocked", (GCallback) _break_timer_daemon_ui_manager_on_session_unlocked_cb_break_timer_common_isession_status_unlocked, self, 0);
	return self;
}

BreakTimerDaemonUIManager*
break_timer_daemon_ui_manager_new (GtkApplication* application,
                                   BreakTimerCommonISessionStatus* session_status)
{
	return break_timer_daemon_ui_manager_construct (BREAK_TIMER_DAEMON_TYPE_UI_MANAGER, application, session_status);
}

static gboolean
break_timer_daemon_ui_manager_real_init (GInitable* base,
                                         GCancellable* cancellable,
                                         GError** error)
{
	BreakTimerDaemonUIManager * self;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (BreakTimerDaemonUIManager*) base;
	{
		GSoundContext* _tmp0_ = NULL;
		GSoundContext* _tmp1_;
		GSoundContext* _tmp2_;
		GSoundContext* _tmp3_;
		_tmp1_ = gsound_context_new (NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->gsound);
		self->priv->gsound = _tmp2_;
		_tmp3_ = self->priv->gsound;
		g_initable_init ((GInitable*) _tmp3_, cancellable, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			goto __catch0_g_error;
		}
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = _error_;
		_tmp5_ = _tmp4_->message;
		g_warning ("UIManager.vala:57: Error initializing gsound: %s", _tmp5_);
		_g_object_unref0 (self->priv->gsound);
		self->priv->gsound = NULL;
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp6_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp6_;
	}
	result = TRUE;
	return result;
}

/**
     * Show a notification, ensuring that the application is only showing one
     * notification at any time.
     */
void
break_timer_daemon_ui_manager_show_notification (BreakTimerDaemonUIManager* self,
                                                 const gchar* id,
                                                 GNotification* notification)
{
	GtkApplication* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (notification != NULL);
	_tmp0_ = self->priv->application;
	g_application_send_notification ((GApplication*) _tmp0_, id, notification);
}

/**
     * Show a notification which will disappear after a short time. The XDG
     * Notification portal doesn't support transient notifications, so we need
     * to implement this ourselves by withdrawing a notification after a
     * timeout.
     * In the case that the screen is locked, we will instead wait until the
     * screen is unlocked before withdrawing the notification.
     */
static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		BreakTimerDaemonUIManager* self;
		self = _data1_->self;
		_g_free0 (_data1_->id);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gboolean
___lambda5_ (Block1Data* _data1_)
{
	BreakTimerDaemonUIManager* self;
	GtkApplication* _tmp0_;
	GHashTable* _tmp1_;
	gboolean result;
	self = _data1_->self;
	_tmp0_ = self->priv->application;
	g_application_withdraw_notification ((GApplication*) _tmp0_, _data1_->id);
	_tmp1_ = self->priv->transient_notification_timeout_ids;
	g_hash_table_remove (_tmp1_, _data1_->id);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda5_ (self);
	return result;
}

void
break_timer_daemon_ui_manager_show_transient_notification (BreakTimerDaemonUIManager* self,
                                                           const gchar* id,
                                                           GNotification* notification)
{
	Block1Data* _data1_;
	gchar* _tmp0_;
	GtkApplication* _tmp1_;
	guint old_source_id = 0U;
	GHashTable* _tmp2_;
	gconstpointer _tmp3_;
	BreakTimerCommonISessionStatus* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (notification != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = g_strdup (id);
	_g_free0 (_data1_->id);
	_data1_->id = _tmp0_;
	_tmp1_ = self->priv->application;
	g_application_send_notification ((GApplication*) _tmp1_, _data1_->id, notification);
	_tmp2_ = self->priv->transient_notification_timeout_ids;
	_tmp3_ = g_hash_table_lookup (_tmp2_, _data1_->id);
	old_source_id = (guint) ((guintptr) _tmp3_);
	if (old_source_id > ((guint) 0)) {
		GHashTable* _tmp4_;
		_tmp4_ = self->priv->transient_notification_timeout_ids;
		g_hash_table_remove (_tmp4_, _data1_->id);
		g_source_remove (old_source_id);
	}
	_tmp5_ = self->priv->session_status;
	if (break_timer_common_isession_status_is_locked (_tmp5_)) {
		GHashTable* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = self->priv->transient_notification_timeout_ids;
		_tmp7_ = g_strdup (_data1_->id);
		g_hash_table_insert (_tmp6_, _tmp7_, (gpointer) ((guintptr) 0));
	} else {
		guint source_id = 0U;
		GHashTable* _tmp8_;
		gchar* _tmp9_;
		source_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, BREAK_TIMER_DAEMON_UI_MANAGER_TRANSIENT_NOTIFICATION_INTERVAL_SECONDS, ____lambda5__gsource_func, block1_data_ref (_data1_), block1_data_unref);
		_tmp8_ = self->priv->transient_notification_timeout_ids;
		_tmp9_ = g_strdup (_data1_->id);
		g_hash_table_insert (_tmp8_, _tmp9_, (gpointer) ((guintptr) source_id));
	}
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

/**
     * Close a notification proactively, if it is still open.
     */
void
break_timer_daemon_ui_manager_hide_notification (BreakTimerDaemonUIManager* self,
                                                 const gchar* id)
{
	GtkApplication* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = self->priv->application;
	g_application_withdraw_notification ((GApplication*) _tmp0_, id);
}

static void
__lambda4_ (BreakTimerDaemonUIManager* self,
            const gchar* notification_id,
            guint source_id)
{
	GtkApplication* _tmp0_;
	g_return_if_fail (notification_id != NULL);
	_tmp0_ = self->priv->application;
	g_application_withdraw_notification ((GApplication*) _tmp0_, notification_id);
	if (source_id > ((guint) 0)) {
		GHashTable* _tmp1_;
		_tmp1_ = self->priv->transient_notification_timeout_ids;
		g_hash_table_remove (_tmp1_, notification_id);
	}
}

static void
___lambda4__gh_func (gconstpointer key,
                     gconstpointer value,
                     gpointer self)
{
	__lambda4_ ((BreakTimerDaemonUIManager*) self, (const gchar*) key, (guint) ((guintptr) value));
}

static void
break_timer_daemon_ui_manager_on_session_unlocked_cb (BreakTimerDaemonUIManager* self)
{
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->transient_notification_timeout_ids;
	g_hash_table_foreach (_tmp0_, ___lambda4__gh_func, self);
}

void
break_timer_daemon_ui_manager_play_sound_from_id (BreakTimerDaemonUIManager* self,
                                                  const gchar* event_id)
{
	GSoundContext* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event_id != NULL);
	_tmp0_ = self->priv->gsound;
	if (_tmp0_ != NULL) {
		{
			GSoundContext* _tmp1_;
			_tmp1_ = self->priv->gsound;
			gsound_context_play_simple (_tmp1_, NULL, &_inner_error0_, "event.id", event_id, NULL);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* _error_ = NULL;
			GError* _tmp2_;
			const gchar* _tmp3_;
			_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp2_ = _error_;
			_tmp3_ = _tmp2_->message;
			g_warning ("UIManager.vala:134: Error playing sound: %s", _tmp3_);
			_g_error_free0 (_error_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
break_timer_daemon_ui_manager_lock_screen (BreakTimerDaemonUIManager* self)
{
	BreakTimerCommonISessionStatus* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->session_status;
	if (!break_timer_common_isession_status_is_locked (_tmp0_)) {
		BreakTimerCommonISessionStatus* _tmp1_;
		_tmp1_ = self->priv->session_status;
		break_timer_common_isession_status_lock_screen (_tmp1_);
	}
}

void
break_timer_daemon_ui_manager_add_break (BreakTimerDaemonUIManager* self,
                                         BreakTimerDaemonBreakBreakView* break_view)
{
	GtkApplication* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (break_view != NULL);
	_tmp0_ = self->priv->application;
	g_application_hold ((GApplication*) _tmp0_);
}

void
break_timer_daemon_ui_manager_remove_break (BreakTimerDaemonUIManager* self,
                                            BreakTimerDaemonBreakBreakView* break_view)
{
	GtkApplication* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (break_view != NULL);
	break_timer_daemon_util_simple_focus_manager_release_focus ((BreakTimerDaemonUtilSimpleFocusManager*) self, (BreakTimerDaemonUtilIFocusable*) break_view);
	_tmp0_ = self->priv->application;
	g_application_release ((GApplication*) _tmp0_);
}

static void
break_timer_daemon_ui_manager_class_init (BreakTimerDaemonUIManagerClass * klass,
                                          gpointer klass_data)
{
	break_timer_daemon_ui_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BreakTimerDaemonUIManager_private_offset);
	G_OBJECT_CLASS (klass)->finalize = break_timer_daemon_ui_manager_finalize;
}

static void
break_timer_daemon_ui_manager_g_initable_interface_init (GInitableIface * iface,
                                                         gpointer iface_data)
{
	break_timer_daemon_ui_manager_g_initable_parent_iface = g_type_interface_peek_parent (iface);
	iface->init = (gboolean (*) (GInitable*, GCancellable*, GError**)) break_timer_daemon_ui_manager_real_init;
}

static void
break_timer_daemon_ui_manager_instance_init (BreakTimerDaemonUIManager * self,
                                             gpointer klass)
{
	self->priv = break_timer_daemon_ui_manager_get_instance_private (self);
}

static void
break_timer_daemon_ui_manager_finalize (GObject * obj)
{
	BreakTimerDaemonUIManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BREAK_TIMER_DAEMON_TYPE_UI_MANAGER, BreakTimerDaemonUIManager);
	_g_object_unref0 (self->priv->session_status);
	_g_object_unref0 (self->priv->gsound);
	_g_hash_table_unref0 (self->priv->transient_notification_timeout_ids);
	G_OBJECT_CLASS (break_timer_daemon_ui_manager_parent_class)->finalize (obj);
}

/**
 * Central place to manage UI throughout the application. We need this to
 * maintain a simple, modal structure. This uses SimpleFocusManager to make
 * sure only one break is affecting the UI at a time. This class also tries to
 * keep UI events nicely spaced so they don't generate excessive noise.
 */
static GType
break_timer_daemon_ui_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BreakTimerDaemonUIManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) break_timer_daemon_ui_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BreakTimerDaemonUIManager), 0, (GInstanceInitFunc) break_timer_daemon_ui_manager_instance_init, NULL };
	static const GInterfaceInfo g_initable_info = { (GInterfaceInitFunc) break_timer_daemon_ui_manager_g_initable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType break_timer_daemon_ui_manager_type_id;
	break_timer_daemon_ui_manager_type_id = g_type_register_static (BREAK_TIMER_DAEMON_UTIL_TYPE_SIMPLE_FOCUS_MANAGER, "BreakTimerDaemonUIManager", &g_define_type_info, 0);
	g_type_add_interface_static (break_timer_daemon_ui_manager_type_id, g_initable_get_type (), &g_initable_info);
	BreakTimerDaemonUIManager_private_offset = g_type_add_instance_private (break_timer_daemon_ui_manager_type_id, sizeof (BreakTimerDaemonUIManagerPrivate));
	return break_timer_daemon_ui_manager_type_id;
}

GType
break_timer_daemon_ui_manager_get_type (void)
{
	static volatile gsize break_timer_daemon_ui_manager_type_id__once = 0;
	if (g_once_init_enter (&break_timer_daemon_ui_manager_type_id__once)) {
		GType break_timer_daemon_ui_manager_type_id;
		break_timer_daemon_ui_manager_type_id = break_timer_daemon_ui_manager_get_type_once ();
		g_once_init_leave (&break_timer_daemon_ui_manager_type_id__once, break_timer_daemon_ui_manager_type_id);
	}
	return break_timer_daemon_ui_manager_type_id__once;
}

