/* geary-service-provider.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from geary-service-provider.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2018 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))

VALA_EXTERN void geary_imap_engine_gmail_account_setup_account (GearyAccountInformation* account);
VALA_EXTERN void geary_imap_engine_outlook_account_setup_account (GearyAccountInformation* account);
VALA_EXTERN void geary_imap_engine_gmail_account_setup_service (GearyServiceInformation* service);
VALA_EXTERN void geary_imap_engine_outlook_account_setup_service (GearyServiceInformation* service);

/**
 * A representation of the various built-in email service providers Geary supports.
 */
GearyServiceProvider
geary_service_provider_for_value (const gchar* value,
                                  GError** error)
{
	GearyServiceProvider _tmp0_ = 0;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gpointer _tmp3_;
	GearyServiceProvider _tmp4_;
	GError* _inner_error0_ = NULL;
	GearyServiceProvider result;
	g_return_val_if_fail (value != NULL, 0);
	_tmp1_ = g_ascii_strdown (value, (gssize) -1);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_object_utils_from_enum_nick (GEARY_TYPE_SERVICE_PROVIDER, NULL, NULL, GEARY_TYPE_SERVICE_PROVIDER, _tmp2_, &_inner_error0_);
	_tmp4_ = (GearyServiceProvider) ((gintptr) _tmp3_);
	_g_free0 (_tmp2_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return 0;
		}
	}
	result = _tmp0_;
	return result;
}

gchar*
geary_service_provider_to_value (GearyServiceProvider self)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = geary_object_utils_to_enum_nick (GEARY_TYPE_SERVICE_PROVIDER, NULL, NULL, GEARY_TYPE_SERVICE_PROVIDER, (gpointer) ((gintptr) self));
	result = _tmp0_;
	return result;
}

void
geary_service_provider_set_account_defaults (GearyServiceProvider self,
                                             GearyAccountInformation* service)
{
	g_return_if_fail (GEARY_IS_ACCOUNT_INFORMATION (service));
	switch (self) {
		case GEARY_SERVICE_PROVIDER_GMAIL:
		{
			geary_imap_engine_gmail_account_setup_account (service);
			break;
		}
		case GEARY_SERVICE_PROVIDER_OUTLOOK:
		{
			geary_imap_engine_outlook_account_setup_account (service);
			break;
		}
		case GEARY_SERVICE_PROVIDER_OTHER:
		{
			break;
		}
		default:
		break;
	}
}

void
geary_service_provider_set_service_defaults (GearyServiceProvider self,
                                             GearyServiceInformation* service)
{
	g_return_if_fail (GEARY_IS_SERVICE_INFORMATION (service));
	switch (self) {
		case GEARY_SERVICE_PROVIDER_GMAIL:
		{
			geary_imap_engine_gmail_account_setup_service (service);
			break;
		}
		case GEARY_SERVICE_PROVIDER_OUTLOOK:
		{
			geary_imap_engine_outlook_account_setup_service (service);
			break;
		}
		case GEARY_SERVICE_PROVIDER_OTHER:
		{
			break;
		}
		default:
		break;
	}
}

 G_GNUC_NO_INLINE static GType
geary_service_provider_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_SERVICE_PROVIDER_GMAIL, "GEARY_SERVICE_PROVIDER_GMAIL", "gmail"}, {GEARY_SERVICE_PROVIDER_OUTLOOK, "GEARY_SERVICE_PROVIDER_OUTLOOK", "outlook"}, {GEARY_SERVICE_PROVIDER_OTHER, "GEARY_SERVICE_PROVIDER_OTHER", "other"}, {0, NULL, NULL}};
	GType geary_service_provider_type_id;
	geary_service_provider_type_id = g_enum_register_static ("GearyServiceProvider", values);
	return geary_service_provider_type_id;
}

GType
geary_service_provider_get_type (void)
{
	static gsize geary_service_provider_type_id__once = 0;
	if (g_once_init_enter (&geary_service_provider_type_id__once)) {
		GType geary_service_provider_type_id;
		geary_service_provider_type_id = geary_service_provider_get_type_once ();
		g_once_init_leave (&geary_service_provider_type_id__once, geary_service_provider_type_id);
	}
	return geary_service_provider_type_id__once;
}

