/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-wacom-raw-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

/**
 * fu_wacom_raw_operation_mode_to_string:
 * @val: value, e.g. %FU_WACOM_RAW_OPERATION_MODE_BOOTLOADER
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
static const gchar *
fu_wacom_raw_operation_mode_to_string(FuWacomRawOperationMode val)
{
    if (val == FU_WACOM_RAW_OPERATION_MODE_RUNTIME)
        return "runtime";
    if (val == FU_WACOM_RAW_OPERATION_MODE_BOOTLOADER)
        return "bootloader";
    return NULL;
}



/**
 * fu_wacom_raw_bl_report_id_to_string:
 * @val: value, e.g. %FU_WACOM_RAW_BL_REPORT_ID_SET
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
static const gchar *
fu_wacom_raw_bl_report_id_to_string(FuWacomRawBlReportId val)
{
    if (val == FU_WACOM_RAW_BL_REPORT_ID_TYPE)
        return "type";
    if (val == FU_WACOM_RAW_BL_REPORT_ID_SET)
        return "set";
    if (val == FU_WACOM_RAW_BL_REPORT_ID_GET)
        return "get";
    return NULL;
}

/**
 * fu_wacom_raw_bl_cmd_to_string:
 * @val: value, e.g. %FU_WACOM_RAW_BL_CMD_WRITE_FLASH
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
static const gchar *
fu_wacom_raw_bl_cmd_to_string(FuWacomRawBlCmd val)
{
    if (val == FU_WACOM_RAW_BL_CMD_ERASE_FLASH)
        return "erase-flash";
    if (val == FU_WACOM_RAW_BL_CMD_WRITE_FLASH)
        return "write-flash";
    if (val == FU_WACOM_RAW_BL_CMD_VERIFY_FLASH)
        return "verify-flash";
    if (val == FU_WACOM_RAW_BL_CMD_ATTACH)
        return "attach";
    if (val == FU_WACOM_RAW_BL_CMD_GET_BLVER)
        return "get-blver";
    if (val == FU_WACOM_RAW_BL_CMD_GET_MPUTYPE)
        return "get-mputype";
    if (val == FU_WACOM_RAW_BL_CMD_CHECK_MODE)
        return "check-mode";
    if (val == FU_WACOM_RAW_BL_CMD_ERASE_DATAMEM)
        return "erase-datamem";
    if (val == FU_WACOM_RAW_BL_CMD_ALL_ERASE)
        return "all-erase";
    return NULL;
}

/**
 * fu_wacom_raw_fw_report_id_to_string:
 * @val: value, e.g. %FU_WACOM_RAW_FW_REPORT_ID_STATUS
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
static const gchar *
fu_wacom_raw_fw_report_id_to_string(FuWacomRawFwReportId val)
{
    if (val == FU_WACOM_RAW_FW_REPORT_ID_GENERAL)
        return "general";
    if (val == FU_WACOM_RAW_FW_REPORT_ID_STATUS)
        return "status";
    return NULL;
}

/**
 * fu_struct_wacom_raw_request_ref: (skip):
 **/
FuStructWacomRawRequest *
fu_struct_wacom_raw_request_ref(FuStructWacomRawRequest *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_wacom_raw_request_unref: (skip):
 **/
void
fu_struct_wacom_raw_request_unref(FuStructWacomRawRequest *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructWacomRawRequest refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_wacom_raw_request_new_internal: (skip):
 **/
static FuStructWacomRawRequest *
fu_struct_wacom_raw_request_new_internal(void)
{
    FuStructWacomRawRequest *st = g_new0(FuStructWacomRawRequest, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_wacom_raw_request_get_report_id: (skip):
 **/
FuWacomRawBlReportId
fu_struct_wacom_raw_request_get_report_id(const FuStructWacomRawRequest *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_wacom_raw_request_get_cmd: (skip):
 **/
guint8
fu_struct_wacom_raw_request_get_cmd(const FuStructWacomRawRequest *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_wacom_raw_request_get_echo: (skip):
 **/
guint8
fu_struct_wacom_raw_request_get_echo(const FuStructWacomRawRequest *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_wacom_raw_request_get_addr: (skip):
 **/
guint32
fu_struct_wacom_raw_request_get_addr(const FuStructWacomRawRequest *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 3, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_wacom_raw_request_get_size8: (skip):
 **/
guint8
fu_struct_wacom_raw_request_get_size8(const FuStructWacomRawRequest *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[7];
}
/**
 * fu_struct_wacom_raw_request_get_data: (skip):
 **/
const guint8 *
fu_struct_wacom_raw_request_get_data(const FuStructWacomRawRequest *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 128;
    return st->buf->data + 8;
}
/**
 * fu_struct_wacom_raw_request_get_data_unused: (skip):
 **/
const guint8 *
fu_struct_wacom_raw_request_get_data_unused(const FuStructWacomRawRequest *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 121;
    return st->buf->data + 136;
}

/* setters */
/**
 * fu_struct_wacom_raw_request_set_report_id: (skip):
 **/
void
fu_struct_wacom_raw_request_set_report_id(FuStructWacomRawRequest *st, FuWacomRawBlReportId value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_wacom_raw_request_set_cmd: (skip):
 **/
void
fu_struct_wacom_raw_request_set_cmd(FuStructWacomRawRequest *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_wacom_raw_request_set_echo: (skip):
 **/
void
fu_struct_wacom_raw_request_set_echo(FuStructWacomRawRequest *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_wacom_raw_request_set_addr: (skip):
 **/
void
fu_struct_wacom_raw_request_set_addr(FuStructWacomRawRequest *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 3, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_wacom_raw_request_set_size8: (skip):
 **/
void
fu_struct_wacom_raw_request_set_size8(FuStructWacomRawRequest *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[7] = value;
}
/**
 * fu_struct_wacom_raw_request_set_data: (skip):
 **/
gboolean
fu_struct_wacom_raw_request_set_data(FuStructWacomRawRequest *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 8, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_wacom_raw_request_set_data_unused: (skip):
 **/
gboolean
fu_struct_wacom_raw_request_set_data_unused(FuStructWacomRawRequest *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 136, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_wacom_raw_request_new: (skip):
 **/
FuStructWacomRawRequest *
fu_struct_wacom_raw_request_new(void)
{
    FuStructWacomRawRequest *st = fu_struct_wacom_raw_request_new_internal();
    st->buf = g_byte_array_sized_new(257);
    fu_byte_array_set_size(st->buf, 257, 0x0);
    return st;
}
/**
 * fu_struct_wacom_raw_response_ref: (skip):
 **/
FuStructWacomRawResponse *
fu_struct_wacom_raw_response_ref(FuStructWacomRawResponse *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_wacom_raw_response_unref: (skip):
 **/
void
fu_struct_wacom_raw_response_unref(FuStructWacomRawResponse *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructWacomRawResponse refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_wacom_raw_response_new_internal: (skip):
 **/
static FuStructWacomRawResponse *
fu_struct_wacom_raw_response_new_internal(void)
{
    FuStructWacomRawResponse *st = g_new0(FuStructWacomRawResponse, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_wacom_raw_response_get_report_id: (skip):
 **/
FuWacomRawBlReportId
fu_struct_wacom_raw_response_get_report_id(const FuStructWacomRawResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_wacom_raw_response_get_cmd: (skip):
 **/
guint8
fu_struct_wacom_raw_response_get_cmd(const FuStructWacomRawResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_wacom_raw_response_get_echo: (skip):
 **/
guint8
fu_struct_wacom_raw_response_get_echo(const FuStructWacomRawResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_wacom_raw_response_get_resp: (skip):
 **/
guint8
fu_struct_wacom_raw_response_get_resp(const FuStructWacomRawResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}

/* setters */
/**
 * fu_struct_wacom_raw_response_to_string: (skip):
 **/
static gchar *
fu_struct_wacom_raw_response_to_string(const FuStructWacomRawResponse *st)
{
    g_autoptr(GString) str = g_string_new("FuStructWacomRawResponse:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_wacom_raw_bl_report_id_to_string(fu_struct_wacom_raw_response_get_report_id(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  report_id: 0x%x [%s]\n", (guint) fu_struct_wacom_raw_response_get_report_id(st), tmp);
        } else {
            g_string_append_printf(str, "  report_id: 0x%x\n", (guint) fu_struct_wacom_raw_response_get_report_id(st));
        }
    }
    g_string_append_printf(str, "  cmd: 0x%x\n",
                           (guint) fu_struct_wacom_raw_response_get_cmd(st));
    g_string_append_printf(str, "  echo: 0x%x\n",
                           (guint) fu_struct_wacom_raw_response_get_echo(st));
    g_string_append_printf(str, "  resp: 0x%x\n",
                           (guint) fu_struct_wacom_raw_response_get_resp(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_wacom_raw_response_validate_internal(FuStructWacomRawResponse *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_wacom_raw_response_parse_internal(FuStructWacomRawResponse *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_wacom_raw_response_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_wacom_raw_response_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_wacom_raw_response_parse: (skip):
 **/
FuStructWacomRawResponse *
fu_struct_wacom_raw_response_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructWacomRawResponse) st = fu_struct_wacom_raw_response_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 136, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructWacomRawResponse: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 136);
    if (!fu_struct_wacom_raw_response_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_wacom_raw_bl_verify_response_ref: (skip):
 **/
FuStructWacomRawBlVerifyResponse *
fu_struct_wacom_raw_bl_verify_response_ref(FuStructWacomRawBlVerifyResponse *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_wacom_raw_bl_verify_response_unref: (skip):
 **/
void
fu_struct_wacom_raw_bl_verify_response_unref(FuStructWacomRawBlVerifyResponse *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructWacomRawBlVerifyResponse refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_wacom_raw_bl_verify_response_new_internal: (skip):
 **/
static FuStructWacomRawBlVerifyResponse *
fu_struct_wacom_raw_bl_verify_response_new_internal(void)
{
    FuStructWacomRawBlVerifyResponse *st = g_new0(FuStructWacomRawBlVerifyResponse, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_wacom_raw_bl_verify_response_get_report_id: (skip):
 **/
FuWacomRawBlReportId
fu_struct_wacom_raw_bl_verify_response_get_report_id(const FuStructWacomRawBlVerifyResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_wacom_raw_bl_verify_response_get_cmd: (skip):
 **/
FuWacomRawBlCmd
fu_struct_wacom_raw_bl_verify_response_get_cmd(const FuStructWacomRawBlVerifyResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_wacom_raw_bl_verify_response_get_echo: (skip):
 **/
guint8
fu_struct_wacom_raw_bl_verify_response_get_echo(const FuStructWacomRawBlVerifyResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_wacom_raw_bl_verify_response_get_addr: (skip):
 **/
guint32
fu_struct_wacom_raw_bl_verify_response_get_addr(const FuStructWacomRawBlVerifyResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 3, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_wacom_raw_bl_verify_response_get_size8: (skip):
 **/
guint8
fu_struct_wacom_raw_bl_verify_response_get_size8(const FuStructWacomRawBlVerifyResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[7];
}
/**
 * fu_struct_wacom_raw_bl_verify_response_get_pid: (skip):
 **/
guint16
fu_struct_wacom_raw_bl_verify_response_get_pid(const FuStructWacomRawBlVerifyResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 14, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_wacom_raw_bl_verify_response_to_string: (skip):
 **/
static gchar *
fu_struct_wacom_raw_bl_verify_response_to_string(const FuStructWacomRawBlVerifyResponse *st)
{
    g_autoptr(GString) str = g_string_new("FuStructWacomRawBlVerifyResponse:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_wacom_raw_bl_report_id_to_string(fu_struct_wacom_raw_bl_verify_response_get_report_id(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  report_id: 0x%x [%s]\n", (guint) fu_struct_wacom_raw_bl_verify_response_get_report_id(st), tmp);
        } else {
            g_string_append_printf(str, "  report_id: 0x%x\n", (guint) fu_struct_wacom_raw_bl_verify_response_get_report_id(st));
        }
    }
    {
        const gchar *tmp = fu_wacom_raw_bl_cmd_to_string(fu_struct_wacom_raw_bl_verify_response_get_cmd(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  cmd: 0x%x [%s]\n", (guint) fu_struct_wacom_raw_bl_verify_response_get_cmd(st), tmp);
        } else {
            g_string_append_printf(str, "  cmd: 0x%x\n", (guint) fu_struct_wacom_raw_bl_verify_response_get_cmd(st));
        }
    }
    g_string_append_printf(str, "  echo: 0x%x\n",
                           (guint) fu_struct_wacom_raw_bl_verify_response_get_echo(st));
    g_string_append_printf(str, "  addr: 0x%x\n",
                           (guint) fu_struct_wacom_raw_bl_verify_response_get_addr(st));
    g_string_append_printf(str, "  size8: 0x%x\n",
                           (guint) fu_struct_wacom_raw_bl_verify_response_get_size8(st));
    g_string_append_printf(str, "  pid: 0x%x\n",
                           (guint) fu_struct_wacom_raw_bl_verify_response_get_pid(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_wacom_raw_bl_verify_response_validate_internal(FuStructWacomRawBlVerifyResponse *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_wacom_raw_bl_verify_response_parse_internal(FuStructWacomRawBlVerifyResponse *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_wacom_raw_bl_verify_response_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_wacom_raw_bl_verify_response_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_wacom_raw_bl_verify_response_parse: (skip):
 **/
FuStructWacomRawBlVerifyResponse *
fu_struct_wacom_raw_bl_verify_response_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructWacomRawBlVerifyResponse) st = fu_struct_wacom_raw_bl_verify_response_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 136, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructWacomRawBlVerifyResponse: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 136);
    if (!fu_struct_wacom_raw_bl_verify_response_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_wacom_raw_fw_status_request_ref: (skip):
 **/
FuStructWacomRawFwStatusRequest *
fu_struct_wacom_raw_fw_status_request_ref(FuStructWacomRawFwStatusRequest *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_wacom_raw_fw_status_request_unref: (skip):
 **/
void
fu_struct_wacom_raw_fw_status_request_unref(FuStructWacomRawFwStatusRequest *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructWacomRawFwStatusRequest refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_wacom_raw_fw_status_request_new_internal: (skip):
 **/
static FuStructWacomRawFwStatusRequest *
fu_struct_wacom_raw_fw_status_request_new_internal(void)
{
    FuStructWacomRawFwStatusRequest *st = g_new0(FuStructWacomRawFwStatusRequest, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_wacom_raw_fw_status_request_set_report_id: (skip):
 **/
static void
fu_struct_wacom_raw_fw_status_request_set_report_id(FuStructWacomRawFwStatusRequest *st, FuWacomRawFwReportId value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_wacom_raw_fw_status_request_new: (skip):
 **/
FuStructWacomRawFwStatusRequest *
fu_struct_wacom_raw_fw_status_request_new(void)
{
    FuStructWacomRawFwStatusRequest *st = fu_struct_wacom_raw_fw_status_request_new_internal();
    st->buf = g_byte_array_sized_new(16);
    fu_byte_array_set_size(st->buf, 16, 0x0);
    fu_struct_wacom_raw_fw_status_request_set_report_id(st, FU_WACOM_RAW_FW_REPORT_ID_STATUS);
    return st;
}
/**
 * fu_struct_wacom_raw_fw_status_response_ref: (skip):
 **/
FuStructWacomRawFwStatusResponse *
fu_struct_wacom_raw_fw_status_response_ref(FuStructWacomRawFwStatusResponse *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_wacom_raw_fw_status_response_unref: (skip):
 **/
void
fu_struct_wacom_raw_fw_status_response_unref(FuStructWacomRawFwStatusResponse *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructWacomRawFwStatusResponse refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_wacom_raw_fw_status_response_new_internal: (skip):
 **/
static FuStructWacomRawFwStatusResponse *
fu_struct_wacom_raw_fw_status_response_new_internal(void)
{
    FuStructWacomRawFwStatusResponse *st = g_new0(FuStructWacomRawFwStatusResponse, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_wacom_raw_fw_status_response_get_report_id: (skip):
 **/
static FuWacomRawFwReportId
fu_struct_wacom_raw_fw_status_response_get_report_id(const FuStructWacomRawFwStatusResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_wacom_raw_fw_status_response_get_version_major: (skip):
 **/
guint16
fu_struct_wacom_raw_fw_status_response_get_version_major(const FuStructWacomRawFwStatusResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 11, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_wacom_raw_fw_status_response_get_version_minor: (skip):
 **/
guint8
fu_struct_wacom_raw_fw_status_response_get_version_minor(const FuStructWacomRawFwStatusResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[13];
}

/* setters */
/**
 * fu_struct_wacom_raw_fw_status_response_to_string: (skip):
 **/
static gchar *
fu_struct_wacom_raw_fw_status_response_to_string(const FuStructWacomRawFwStatusResponse *st)
{
    g_autoptr(GString) str = g_string_new("FuStructWacomRawFwStatusResponse:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  version_major: 0x%x\n",
                           (guint) fu_struct_wacom_raw_fw_status_response_get_version_major(st));
    g_string_append_printf(str, "  version_minor: 0x%x\n",
                           (guint) fu_struct_wacom_raw_fw_status_response_get_version_minor(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_wacom_raw_fw_status_response_validate_internal(FuStructWacomRawFwStatusResponse *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_wacom_raw_fw_status_response_get_report_id(st) != FU_WACOM_RAW_FW_REPORT_ID_STATUS) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructWacomRawFwStatusResponse.report_id was not valid, "
                    "expected 'FuWacomRawFwReportId' and got '%s'",
                    fu_wacom_raw_fw_report_id_to_string(fu_struct_wacom_raw_fw_status_response_get_report_id(st)));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_wacom_raw_fw_status_response_parse_internal(FuStructWacomRawFwStatusResponse *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_wacom_raw_fw_status_response_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_wacom_raw_fw_status_response_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_wacom_raw_fw_status_response_parse: (skip):
 **/
FuStructWacomRawFwStatusResponse *
fu_struct_wacom_raw_fw_status_response_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructWacomRawFwStatusResponse) st = fu_struct_wacom_raw_fw_status_response_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 16, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructWacomRawFwStatusResponse: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 16);
    if (!fu_struct_wacom_raw_fw_status_response_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_wacom_raw_fw_detach_request_ref: (skip):
 **/
FuStructWacomRawFwDetachRequest *
fu_struct_wacom_raw_fw_detach_request_ref(FuStructWacomRawFwDetachRequest *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_wacom_raw_fw_detach_request_unref: (skip):
 **/
void
fu_struct_wacom_raw_fw_detach_request_unref(FuStructWacomRawFwDetachRequest *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructWacomRawFwDetachRequest refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_wacom_raw_fw_detach_request_new_internal: (skip):
 **/
static FuStructWacomRawFwDetachRequest *
fu_struct_wacom_raw_fw_detach_request_new_internal(void)
{
    FuStructWacomRawFwDetachRequest *st = g_new0(FuStructWacomRawFwDetachRequest, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_wacom_raw_fw_detach_request_set_report_id: (skip):
 **/
static void
fu_struct_wacom_raw_fw_detach_request_set_report_id(FuStructWacomRawFwDetachRequest *st, FuWacomRawFwReportId value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_wacom_raw_fw_detach_request_set_cmd: (skip):
 **/
static void
fu_struct_wacom_raw_fw_detach_request_set_cmd(FuStructWacomRawFwDetachRequest *st, FuWacomRawFwCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_wacom_raw_fw_detach_request_new: (skip):
 **/
FuStructWacomRawFwDetachRequest *
fu_struct_wacom_raw_fw_detach_request_new(void)
{
    FuStructWacomRawFwDetachRequest *st = fu_struct_wacom_raw_fw_detach_request_new_internal();
    st->buf = g_byte_array_sized_new(2);
    fu_byte_array_set_size(st->buf, 2, 0x0);
    fu_struct_wacom_raw_fw_detach_request_set_report_id(st, FU_WACOM_RAW_FW_REPORT_ID_GENERAL);
    fu_struct_wacom_raw_fw_detach_request_set_cmd(st, FU_WACOM_RAW_FW_CMD_DETACH);
    return st;
}
/**
 * fu_struct_wacom_raw_fw_query_mode_request_ref: (skip):
 **/
FuStructWacomRawFwQueryModeRequest *
fu_struct_wacom_raw_fw_query_mode_request_ref(FuStructWacomRawFwQueryModeRequest *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_wacom_raw_fw_query_mode_request_unref: (skip):
 **/
void
fu_struct_wacom_raw_fw_query_mode_request_unref(FuStructWacomRawFwQueryModeRequest *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructWacomRawFwQueryModeRequest refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_wacom_raw_fw_query_mode_request_new_internal: (skip):
 **/
static FuStructWacomRawFwQueryModeRequest *
fu_struct_wacom_raw_fw_query_mode_request_new_internal(void)
{
    FuStructWacomRawFwQueryModeRequest *st = g_new0(FuStructWacomRawFwQueryModeRequest, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_wacom_raw_fw_query_mode_request_set_report_id: (skip):
 **/
static void
fu_struct_wacom_raw_fw_query_mode_request_set_report_id(FuStructWacomRawFwQueryModeRequest *st, FuWacomRawFwReportId value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_wacom_raw_fw_query_mode_request_set_cmd: (skip):
 **/
static void
fu_struct_wacom_raw_fw_query_mode_request_set_cmd(FuStructWacomRawFwQueryModeRequest *st, FuWacomRawFwCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_wacom_raw_fw_query_mode_request_new: (skip):
 **/
FuStructWacomRawFwQueryModeRequest *
fu_struct_wacom_raw_fw_query_mode_request_new(void)
{
    FuStructWacomRawFwQueryModeRequest *st = fu_struct_wacom_raw_fw_query_mode_request_new_internal();
    st->buf = g_byte_array_sized_new(2);
    fu_byte_array_set_size(st->buf, 2, 0x0);
    fu_struct_wacom_raw_fw_query_mode_request_set_report_id(st, FU_WACOM_RAW_FW_REPORT_ID_GENERAL);
    fu_struct_wacom_raw_fw_query_mode_request_set_cmd(st, FU_WACOM_RAW_FW_CMD_QUERY_MODE);
    return st;
}
/**
 * fu_struct_wacom_raw_fw_query_mode_response_ref: (skip):
 **/
FuStructWacomRawFwQueryModeResponse *
fu_struct_wacom_raw_fw_query_mode_response_ref(FuStructWacomRawFwQueryModeResponse *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_wacom_raw_fw_query_mode_response_unref: (skip):
 **/
void
fu_struct_wacom_raw_fw_query_mode_response_unref(FuStructWacomRawFwQueryModeResponse *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructWacomRawFwQueryModeResponse refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_wacom_raw_fw_query_mode_response_new_internal: (skip):
 **/
static FuStructWacomRawFwQueryModeResponse *
fu_struct_wacom_raw_fw_query_mode_response_new_internal(void)
{
    FuStructWacomRawFwQueryModeResponse *st = g_new0(FuStructWacomRawFwQueryModeResponse, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_wacom_raw_fw_query_mode_response_get_report_id: (skip):
 **/
static FuWacomRawFwReportId
fu_struct_wacom_raw_fw_query_mode_response_get_report_id(const FuStructWacomRawFwQueryModeResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_wacom_raw_fw_query_mode_response_get_mode: (skip):
 **/
FuWacomRawOperationMode
fu_struct_wacom_raw_fw_query_mode_response_get_mode(const FuStructWacomRawFwQueryModeResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}

/* setters */
/**
 * fu_struct_wacom_raw_fw_query_mode_response_to_string: (skip):
 **/
static gchar *
fu_struct_wacom_raw_fw_query_mode_response_to_string(const FuStructWacomRawFwQueryModeResponse *st)
{
    g_autoptr(GString) str = g_string_new("FuStructWacomRawFwQueryModeResponse:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_wacom_raw_operation_mode_to_string(fu_struct_wacom_raw_fw_query_mode_response_get_mode(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  mode: 0x%x [%s]\n", (guint) fu_struct_wacom_raw_fw_query_mode_response_get_mode(st), tmp);
        } else {
            g_string_append_printf(str, "  mode: 0x%x\n", (guint) fu_struct_wacom_raw_fw_query_mode_response_get_mode(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_wacom_raw_fw_query_mode_response_validate_internal(FuStructWacomRawFwQueryModeResponse *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_wacom_raw_fw_query_mode_response_get_report_id(st) != FU_WACOM_RAW_FW_REPORT_ID_GENERAL) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructWacomRawFwQueryModeResponse.report_id was not valid, "
                    "expected 'FuWacomRawFwReportId' and got '%s'",
                    fu_wacom_raw_fw_report_id_to_string(fu_struct_wacom_raw_fw_query_mode_response_get_report_id(st)));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_wacom_raw_fw_query_mode_response_parse_internal(FuStructWacomRawFwQueryModeResponse *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_wacom_raw_fw_query_mode_response_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_wacom_raw_fw_query_mode_response_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_wacom_raw_fw_query_mode_response_parse: (skip):
 **/
FuStructWacomRawFwQueryModeResponse *
fu_struct_wacom_raw_fw_query_mode_response_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructWacomRawFwQueryModeResponse) st = fu_struct_wacom_raw_fw_query_mode_response_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 2, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructWacomRawFwQueryModeResponse: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 2);
    if (!fu_struct_wacom_raw_fw_query_mode_response_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
