/* internal.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from internal.vala, do not modify */

/*
 * Copyright 2011,2023 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *       Corentin Noël <corentin.noel@collabora.com>
 */

#include "folks-internal.h"
#include <glib-object.h>
#include <gee.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <sysprof-capture.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _folks_internal_profile_block_free0(var) ((var == NULL) ? NULL : (var = (folks_internal_profile_block_free (var), NULL)))

static void folks_internal_profile_block_instance_init (FolksInternalProfileBlock * self);
VALA_EXTERN FolksInternalProfileBlock* folks_internal_profile_block_new (gchar* name);

gboolean
folks_internal_equal_sets (GType g_type,
                           GBoxedCopyFunc g_dup_func,
                           GDestroyNotify g_destroy_func,
                           GeeSet* a,
                           GeeSet* b)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp0_ = gee_collection_get_size ((GeeCollection*) a);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_collection_get_size ((GeeCollection*) b);
	_tmp3_ = _tmp2_;
	if (_tmp1_ != _tmp3_) {
		result = FALSE;
		return result;
	}
	{
		GeeIterator* _a_elem_it = NULL;
		GeeIterator* _tmp4_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) a);
		_a_elem_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			gpointer a_elem = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			gconstpointer _tmp8_;
			_tmp5_ = _a_elem_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _a_elem_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			a_elem = _tmp7_;
			_tmp8_ = a_elem;
			if (!gee_collection_contains ((GeeCollection*) b, _tmp8_)) {
				result = FALSE;
				((a_elem == NULL) || (g_destroy_func == NULL)) ? NULL : (a_elem = (g_destroy_func (a_elem), NULL));
				_g_object_unref0 (_a_elem_it);
				return result;
			}
			((a_elem == NULL) || (g_destroy_func == NULL)) ? NULL : (a_elem = (g_destroy_func (a_elem), NULL));
		}
		_g_object_unref0 (_a_elem_it);
	}
	result = TRUE;
	return result;
}

/**
   * Emit a profiling point.
   *
   * This emits a profiling point with the given message (printf-style), which
   * can be picked up by profiling tools and timing information extracted.
   *
   * @param format printf-style message format
   * @param ... message arguments
   */
inline void
folks_internal_profiling_point (const gchar* format,
                                ...)
{
	va_list args = {0};
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (format != NULL);
	va_start (args, format);
	_tmp0_ = g_strdup_vprintf (format, args);
	_tmp1_ = _tmp0_;
	sysprof_collector_log (0, "folks", _tmp1_);
	_g_free0 (_tmp1_);
	va_end (args);
}

FolksInternalProfileBlock*
folks_internal_profile_block_new (gchar* name)
{
	FolksInternalProfileBlock* self;
	gchar* _tmp0_;
	g_return_val_if_fail (name != NULL, NULL);
	self = g_slice_new0 (FolksInternalProfileBlock);
	folks_internal_profile_block_instance_init (self);
	_tmp0_ = name;
	name = NULL;
	_g_free0 (self->name);
	self->name = _tmp0_;
	self->start = SYSPROF_CAPTURE_CURRENT_TIME;
	_g_free0 (name);
	return self;
}

static void
folks_internal_profile_block_instance_init (FolksInternalProfileBlock * self)
{
}

void
folks_internal_profile_block_free (FolksInternalProfileBlock * self)
{
	_g_free0 (self->name);
	g_slice_free (FolksInternalProfileBlock, self);
}

/**
   * Start a profiling block.
   *
   * This emits a profiling start point with the given message (printf-style),
   * which can be picked up by profiling tools and timing information extracted.
   *
   * This is typically used in a pair with {@link Internal.profiling_end} to
   * delimit blocks of processing which need timing.
   *
   * @param format printf-style message format
   * @param ... message arguments
   */
inline FolksInternalProfileBlock*
folks_internal_profiling_start (const gchar* format,
                                ...)
{
	va_list args = {0};
	gchar* _tmp0_;
	FolksInternalProfileBlock* _tmp1_;
	FolksInternalProfileBlock* result;
	g_return_val_if_fail (format != NULL, NULL);
	va_start (args, format);
	_tmp0_ = g_strdup_vprintf (format, args);
	_tmp1_ = folks_internal_profile_block_new (_tmp0_);
	result = _tmp1_;
	va_end (args);
	return result;
}

/**
   * End a profiling block.
   *
   * This emits a profiling end point with the given message (printf-style),
   * which can be picked up by profiling tools and timing information extracted.
   *
   * This is typically used in a pair with {@link Internal.profiling_start} to
   * delimit blocks of processing which need timing.
   *
   * @param block the ProfileBlock given by profiling_start
   */
inline void
folks_internal_profiling_end (FolksInternalProfileBlock* block)
{
	const gchar* _tmp0_;
	_tmp0_ = block->name;
	sysprof_collector_mark (block->start, SYSPROF_CAPTURE_CURRENT_TIME - block->start, "folks", _tmp0_, NULL);
	_folks_internal_profile_block_free0 (block);
}

