#pragma once
#include <stdint.h>
#include <stdbool.h>

struct emoji {
    bool emoji_presentation:1;
    bool modifier:1;
    bool modifier_base:1;
    bool component:1;
    bool pictographic:1;
    uint32_t cp:24;
    uint8_t count;
} __attribute__((packed));
_Static_assert(sizeof(struct emoji) == 5, "unexpected struct size");

#if defined(FCFT_HAVE_HARFBUZZ)

static const struct emoji emojis[264] = {
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = true,
       .pictographic = false,
       .cp = 0x00023,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = true,
       .pictographic = false,
       .cp = 0x0002a,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = true,
       .pictographic = false,
       .cp = 0x00030,
       .count = 10,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x000a9,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x000ae,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x0203c,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02049,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02122,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02139,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02194,
       .count = 6,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x021a9,
       .count = 2,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x0231a,
       .count = 2,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02328,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x023cf,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x023e9,
       .count = 4,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x023ed,
       .count = 3,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x023f0,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x023f1,
       .count = 2,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x023f3,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x023f8,
       .count = 3,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x024c2,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x025aa,
       .count = 2,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x025b6,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x025c0,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x025fb,
       .count = 2,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x025fd,
       .count = 2,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02600,
       .count = 5,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x0260e,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02611,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02614,
       .count = 2,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02618,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x0261d,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02620,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02622,
       .count = 2,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02626,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x0262a,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x0262e,
       .count = 2,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02638,
       .count = 3,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02640,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02642,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02648,
       .count = 12,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x0265f,
       .count = 2,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02663,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02665,
       .count = 2,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02668,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x0267b,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x0267e,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x0267f,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02692,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02693,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02694,
       .count = 4,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02699,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x0269b,
       .count = 2,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x026a0,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x026a1,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x026a7,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x026aa,
       .count = 2,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x026b0,
       .count = 2,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x026bd,
       .count = 2,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x026c4,
       .count = 2,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x026c8,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x026ce,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x026cf,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x026d1,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x026d3,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x026d4,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x026e9,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x026ea,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x026f0,
       .count = 2,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x026f2,
       .count = 2,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x026f4,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x026f5,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x026f7,
       .count = 2,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x026f9,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x026fa,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x026fd,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02702,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02705,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02708,
       .count = 2,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x0270a,
       .count = 2,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x0270c,
       .count = 2,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x0270f,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02712,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02714,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02716,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x0271d,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02721,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02728,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02733,
       .count = 2,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02744,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02747,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x0274c,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x0274e,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02753,
       .count = 3,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02757,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02763,
       .count = 2,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02795,
       .count = 3,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x027a1,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x027b0,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x027bf,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02934,
       .count = 2,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02b05,
       .count = 3,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02b1b,
       .count = 2,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02b50,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x02b55,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x03030,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x0303d,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x03297,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x03299,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f004,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f0cf,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f170,
       .count = 2,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f17e,
       .count = 2,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f18e,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f191,
       .count = 10,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = true,
       .pictographic = false,
       .cp = 0x1f1e6,
       .count = 26,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f201,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f202,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f21a,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f22f,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f232,
       .count = 5,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f237,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f238,
       .count = 3,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f250,
       .count = 2,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f300,
       .count = 33,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f321,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f324,
       .count = 9,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f32d,
       .count = 9,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f336,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f337,
       .count = 70,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f37d,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f37e,
       .count = 7,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f385,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f386,
       .count = 14,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f396,
       .count = 2,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f399,
       .count = 3,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f39e,
       .count = 2,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f3a0,
       .count = 34,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f3c2,
       .count = 3,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f3c5,
       .count = 2,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f3c7,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f3c8,
       .count = 2,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f3ca,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f3cb,
       .count = 2,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f3cd,
       .count = 2,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f3cf,
       .count = 5,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f3d4,
       .count = 12,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f3e0,
       .count = 17,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f3f3,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f3f4,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f3f5,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f3f7,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f3f8,
       .count = 3,
    },
    {
       .emoji_presentation = true,
       .modifier = true,
       .modifier_base = false,
       .component = true,
       .pictographic = false,
       .cp = 0x1f3fb,
       .count = 5,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f400,
       .count = 63,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f43f,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f440,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f441,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f442,
       .count = 2,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f444,
       .count = 2,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f446,
       .count = 11,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f451,
       .count = 21,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f466,
       .count = 19,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f479,
       .count = 3,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f47c,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f47d,
       .count = 4,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f481,
       .count = 3,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f484,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f485,
       .count = 3,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f488,
       .count = 7,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f48f,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f490,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f491,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f492,
       .count = 24,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f4aa,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f4ab,
       .count = 82,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f4fd,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f4ff,
       .count = 63,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f549,
       .count = 2,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f54b,
       .count = 4,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f550,
       .count = 24,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f56f,
       .count = 2,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f573,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f574,
       .count = 2,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f576,
       .count = 4,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f57a,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f587,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f58a,
       .count = 4,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f590,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f595,
       .count = 2,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f5a4,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f5a5,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f5a8,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f5b1,
       .count = 2,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f5bc,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f5c2,
       .count = 3,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f5d1,
       .count = 3,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f5dc,
       .count = 3,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f5e1,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f5e3,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f5e8,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f5ef,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f5f3,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f5fa,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f5fb,
       .count = 74,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f645,
       .count = 3,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f648,
       .count = 3,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f64b,
       .count = 5,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f680,
       .count = 35,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f6a3,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f6a4,
       .count = 16,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f6b4,
       .count = 3,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f6b7,
       .count = 9,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f6c0,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f6c1,
       .count = 5,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f6cb,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f6cc,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f6cd,
       .count = 3,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f6d0,
       .count = 3,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f6d5,
       .count = 3,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f6dc,
       .count = 4,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f6e0,
       .count = 6,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f6e9,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f6eb,
       .count = 2,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f6f0,
       .count = 1,
    },
    {
       .emoji_presentation = false,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f6f3,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f6f4,
       .count = 9,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f7e0,
       .count = 12,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f7f0,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f90c,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f90d,
       .count = 2,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f90f,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f910,
       .count = 8,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f918,
       .count = 8,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f920,
       .count = 6,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f926,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f927,
       .count = 9,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f930,
       .count = 10,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f93a,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f93c,
       .count = 3,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f93f,
       .count = 7,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f947,
       .count = 48,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f977,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f978,
       .count = 56,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = true,
       .pictographic = true,
       .cp = 0x1f9b0,
       .count = 4,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f9b4,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f9b5,
       .count = 2,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f9b7,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f9b8,
       .count = 2,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f9ba,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f9bb,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f9bc,
       .count = 17,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f9cd,
       .count = 3,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f9d0,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1f9d1,
       .count = 13,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1f9de,
       .count = 34,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1fa70,
       .count = 13,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1fa80,
       .count = 10,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1fa8f,
       .count = 52,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1fac3,
       .count = 3,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1fac6,
       .count = 1,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1face,
       .count = 15,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = false,
       .component = false,
       .pictographic = true,
       .cp = 0x1fadf,
       .count = 11,
    },
    {
       .emoji_presentation = true,
       .modifier = false,
       .modifier_base = true,
       .component = false,
       .pictographic = true,
       .cp = 0x1faf0,
       .count = 9,
    },
};
#else  /* !FCFT_HAVE_HARFBUZZ */
static const struct emoji emojis[0];
#endif  /* !FCFT_HAVE_HARFBUZZ */
