
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "sitesettingsmanager_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

// inner classes
#include "sitesettingsmanager_sitesettings_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_SiteSettingsManager_Type = nullptr;
static PyTypeObject *Sbk_SiteSettingsManager_TypeF(void)
{
    return _Sbk_SiteSettingsManager_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void SiteSettingsManagerWrapper::pysideInitQtMetaTypes()
{
    qRegisterMetaType< ::SiteSettingsManager::Permission >("SiteSettingsManager::Permission");
    qRegisterMetaType< ::SiteSettingsManager::PageOptions >("SiteSettingsManager::PageOptions");
}

void SiteSettingsManagerWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

SiteSettingsManagerWrapper::SiteSettingsManagerWrapper(::QObject * parent) : SiteSettingsManager(parent)
{
}

void SiteSettingsManagerWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SiteSettingsManager_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("SiteSettingsManager", funcName, gil, pyOverride, event);
}

void SiteSettingsManagerWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SiteSettingsManager_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("SiteSettingsManager", funcName, gil, pyOverride, signal);
}

void SiteSettingsManagerWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SiteSettingsManager_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("SiteSettingsManager", funcName, gil, pyOverride, event);
}

void SiteSettingsManagerWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SiteSettingsManager_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("SiteSettingsManager", funcName, gil, pyOverride, signal);
}

bool SiteSettingsManagerWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SiteSettingsManager_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return WebViewWrapper::sbk_o_event("SiteSettingsManager", funcName, gil, pyOverride, event);
}

bool SiteSettingsManagerWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SiteSettingsManager_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("SiteSettingsManager", funcName, gil, pyOverride, watched, event);
}

void SiteSettingsManagerWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SiteSettingsManager_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("SiteSettingsManager", funcName, gil, pyOverride, event);
}

const QMetaObject *SiteSettingsManagerWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return SiteSettingsManager::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int SiteSettingsManagerWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = SiteSettingsManager::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *SiteSettingsManagerWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< SiteSettingsManagerWrapper *>(this));
    }
    return SiteSettingsManager::qt_metacast(_clname);
}

SiteSettingsManagerWrapper::~SiteSettingsManagerWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_SiteSettingsManager_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_SiteSettingsManager_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::SiteSettingsManager >()))
        return -1;

    SiteSettingsManagerWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:SiteSettingsManager", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: SiteSettingsManager::SiteSettingsManager(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // SiteSettingsManager(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // SiteSettingsManager(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // SiteSettingsManager(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) SiteSettingsManagerWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new SiteSettingsManagerWrapper(cppArg0);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< SiteSettingsManager >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]);
    };


    return 1;
}

static PyObject *Sbk_SiteSettingsManagerFunc_adjustUrl(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static SiteSettingsManager::adjustUrl(QUrl)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArg)))) {
        overloadId = 0; // adjustUrl(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "adjustUrl", errInfo, SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // adjustUrl(QUrl)
            QString cppResult = ::SiteSettingsManager::adjustUrl(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SiteSettingsManagerFunc_featureToSqlColumn(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SiteSettingsManagerWrapper *>(reinterpret_cast< ::SiteSettingsManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: SiteSettingsManager::featureToSqlColumn(QWebEnginePage::Feature)const->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEnginePage_Feature_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // featureToSqlColumn(QWebEnginePage::Feature)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "featureToSqlColumn", errInfo, SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]);

    // Call function/method
    {
        ::QWebEnginePage::Feature cppArg0{QWebEnginePage::Notifications};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // featureToSqlColumn(QWebEnginePage::Feature)const
            QString cppResult = const_cast<const SiteSettingsManagerWrapper *>(cppSelf)->featureToSqlColumn(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SiteSettingsManagerFunc_getDefaultPermission(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SiteSettingsManagerWrapper *>(reinterpret_cast< ::SiteSettingsManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: SiteSettingsManager::getDefaultPermission(QWebEnginePage::Feature)const->SiteSettingsManager::Permission
    // 1: SiteSettingsManager::getDefaultPermission(QWebEngineSettings::WebAttribute)const->SiteSettingsManager::Permission
    // 2: SiteSettingsManager::getDefaultPermission(SiteSettingsManager::PageOptions)->SiteSettingsManager::Permission
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_PageOptions_IDX])))->converter, (pyArg)))) {
        overloadId = 2; // getDefaultPermission(SiteSettingsManager::PageOptions)
    } else if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineSettings_WebAttribute_IDX])))->converter, (pyArg)))) {
        overloadId = 1; // getDefaultPermission(QWebEngineSettings::WebAttribute)const
    } else if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEnginePage_Feature_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // getDefaultPermission(QWebEnginePage::Feature)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getDefaultPermission", errInfo, SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // getDefaultPermission(const QWebEnginePage::Feature feature) const
        {
            ::QWebEnginePage::Feature cppArg0{QWebEnginePage::Notifications};
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // getDefaultPermission(QWebEnginePage::Feature)const
                SiteSettingsManager::Permission cppResult = SiteSettingsManager::Permission(const_cast<const SiteSettingsManagerWrapper *>(cppSelf)->getDefaultPermission(cppArg0));
                pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_Permission_IDX])))->converter, &cppResult);
            }
            break;
        }
        case 1: // getDefaultPermission(const QWebEngineSettings::WebAttribute attribute) const
        {
            ::QWebEngineSettings::WebAttribute cppArg0{QWebEngineSettings::AutoLoadImages};
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // getDefaultPermission(QWebEngineSettings::WebAttribute)const
                SiteSettingsManager::Permission cppResult = SiteSettingsManager::Permission(const_cast<const SiteSettingsManagerWrapper *>(cppSelf)->getDefaultPermission(cppArg0));
                pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_Permission_IDX])))->converter, &cppResult);
            }
            break;
        }
        case 2: // getDefaultPermission(const SiteSettingsManager::PageOptions option)
        {
            ::SiteSettingsManager::PageOptions cppArg0{SiteSettingsManager::poAllowCookies};
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // getDefaultPermission(SiteSettingsManager::PageOptions)
                SiteSettingsManager::Permission cppResult = SiteSettingsManager::Permission(cppSelf->getDefaultPermission(cppArg0));
                pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_Permission_IDX])))->converter, &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SiteSettingsManagerFunc_getOptionName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SiteSettingsManagerWrapper *>(reinterpret_cast< ::SiteSettingsManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: SiteSettingsManager::getOptionName(QWebEnginePage::Feature)const->QString
    // 1: SiteSettingsManager::getOptionName(QWebEngineSettings::WebAttribute)const->QString
    // 2: SiteSettingsManager::getOptionName(SiteSettingsManager::PageOptions)const->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_PageOptions_IDX])))->converter, (pyArg)))) {
        overloadId = 2; // getOptionName(SiteSettingsManager::PageOptions)const
    } else if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineSettings_WebAttribute_IDX])))->converter, (pyArg)))) {
        overloadId = 1; // getOptionName(QWebEngineSettings::WebAttribute)const
    } else if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEnginePage_Feature_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // getOptionName(QWebEnginePage::Feature)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getOptionName", errInfo, SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // getOptionName(const QWebEnginePage::Feature feature) const
        {
            ::QWebEnginePage::Feature cppArg0{QWebEnginePage::Notifications};
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // getOptionName(QWebEnginePage::Feature)const
                QString cppResult = const_cast<const SiteSettingsManagerWrapper *>(cppSelf)->getOptionName(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
            }
            break;
        }
        case 1: // getOptionName(const QWebEngineSettings::WebAttribute attribute) const
        {
            ::QWebEngineSettings::WebAttribute cppArg0{QWebEngineSettings::AutoLoadImages};
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // getOptionName(QWebEngineSettings::WebAttribute)const
                QString cppResult = const_cast<const SiteSettingsManagerWrapper *>(cppSelf)->getOptionName(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
            }
            break;
        }
        case 2: // getOptionName(const SiteSettingsManager::PageOptions option) const
        {
            ::SiteSettingsManager::PageOptions cppArg0{SiteSettingsManager::poAllowCookies};
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // getOptionName(SiteSettingsManager::PageOptions)const
                QString cppResult = const_cast<const SiteSettingsManagerWrapper *>(cppSelf)->getOptionName(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SiteSettingsManagerFunc_getPermission(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SiteSettingsManagerWrapper *>(reinterpret_cast< ::SiteSettingsManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "getPermission", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: SiteSettingsManager::getPermission(QString,QString)->SiteSettingsManager::Permission
    // 1: SiteSettingsManager::getPermission(QString,QUrl)->SiteSettingsManager::Permission
    // 2: SiteSettingsManager::getPermission(QWebEnginePage::Feature,QString)->SiteSettingsManager::Permission
    // 3: SiteSettingsManager::getPermission(QWebEnginePage::Feature,QUrl)->SiteSettingsManager::Permission
    // 4: SiteSettingsManager::getPermission(QWebEngineSettings::WebAttribute,QString)->SiteSettingsManager::Permission
    // 5: SiteSettingsManager::getPermission(QWebEngineSettings::WebAttribute,QUrl)->SiteSettingsManager::Permission
    // 6: SiteSettingsManager::getPermission(SiteSettingsManager::PageOptions,QString)->SiteSettingsManager::Permission
    // 7: SiteSettingsManager::getPermission(SiteSettingsManager::PageOptions,QUrl)->SiteSettingsManager::Permission
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_PageOptions_IDX])))->converter, (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            overloadId = 6; // getPermission(SiteSettingsManager::PageOptions,QString)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[1])))) {
            overloadId = 7; // getPermission(SiteSettingsManager::PageOptions,QUrl)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineSettings_WebAttribute_IDX])))->converter, (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            overloadId = 4; // getPermission(QWebEngineSettings::WebAttribute,QString)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[1])))) {
            overloadId = 5; // getPermission(QWebEngineSettings::WebAttribute,QUrl)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEnginePage_Feature_IDX])))->converter, (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            overloadId = 2; // getPermission(QWebEnginePage::Feature,QString)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[1])))) {
            overloadId = 3; // getPermission(QWebEnginePage::Feature,QUrl)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            overloadId = 0; // getPermission(QString,QString)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[1])))) {
            overloadId = 1; // getPermission(QString,QUrl)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "getPermission", errInfo, SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // getPermission(const QString &column, const QString &host)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // getPermission(QString,QString)
                SiteSettingsManager::Permission cppResult = SiteSettingsManager::Permission(cppSelf->getPermission(cppArg0, cppArg1));
                pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_Permission_IDX])))->converter, &cppResult);
            }
            break;
        }
        case 1: // getPermission(const QString &column, const QUrl &url)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QUrl cppArg1_local;
            ::QUrl *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1].isValue())
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (Shiboken::Errors::occurred() == nullptr) {
                // getPermission(QString,QUrl)
                SiteSettingsManager::Permission cppResult = SiteSettingsManager::Permission(cppSelf->getPermission(cppArg0, *cppArg1));
                pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_Permission_IDX])))->converter, &cppResult);
            }
            break;
        }
        case 2: // getPermission(const QWebEnginePage::Feature feature, const QString &host)
        {
            ::QWebEnginePage::Feature cppArg0{QWebEnginePage::Notifications};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // getPermission(QWebEnginePage::Feature,QString)
                SiteSettingsManager::Permission cppResult = SiteSettingsManager::Permission(cppSelf->getPermission(cppArg0, cppArg1));
                pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_Permission_IDX])))->converter, &cppResult);
            }
            break;
        }
        case 3: // getPermission(const QWebEnginePage::Feature feature, const QUrl &url)
        {
            ::QWebEnginePage::Feature cppArg0{QWebEnginePage::Notifications};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QUrl cppArg1_local;
            ::QUrl *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1].isValue())
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (Shiboken::Errors::occurred() == nullptr) {
                // getPermission(QWebEnginePage::Feature,QUrl)
                SiteSettingsManager::Permission cppResult = SiteSettingsManager::Permission(cppSelf->getPermission(cppArg0, *cppArg1));
                pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_Permission_IDX])))->converter, &cppResult);
            }
            break;
        }
        case 4: // getPermission(const QWebEngineSettings::WebAttribute attribute, const QString &host)
        {
            ::QWebEngineSettings::WebAttribute cppArg0{QWebEngineSettings::AutoLoadImages};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // getPermission(QWebEngineSettings::WebAttribute,QString)
                SiteSettingsManager::Permission cppResult = SiteSettingsManager::Permission(cppSelf->getPermission(cppArg0, cppArg1));
                pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_Permission_IDX])))->converter, &cppResult);
            }
            break;
        }
        case 5: // getPermission(const QWebEngineSettings::WebAttribute attribute, const QUrl &url)
        {
            ::QWebEngineSettings::WebAttribute cppArg0{QWebEngineSettings::AutoLoadImages};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QUrl cppArg1_local;
            ::QUrl *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1].isValue())
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (Shiboken::Errors::occurred() == nullptr) {
                // getPermission(QWebEngineSettings::WebAttribute,QUrl)
                SiteSettingsManager::Permission cppResult = SiteSettingsManager::Permission(cppSelf->getPermission(cppArg0, *cppArg1));
                pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_Permission_IDX])))->converter, &cppResult);
            }
            break;
        }
        case 6: // getPermission(const SiteSettingsManager::PageOptions option, const QString &host)
        {
            ::SiteSettingsManager::PageOptions cppArg0{SiteSettingsManager::poAllowCookies};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // getPermission(SiteSettingsManager::PageOptions,QString)
                SiteSettingsManager::Permission cppResult = SiteSettingsManager::Permission(cppSelf->getPermission(cppArg0, cppArg1));
                pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_Permission_IDX])))->converter, &cppResult);
            }
            break;
        }
        case 7: // getPermission(const SiteSettingsManager::PageOptions option, const QUrl &url)
        {
            ::SiteSettingsManager::PageOptions cppArg0{SiteSettingsManager::poAllowCookies};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QUrl cppArg1_local;
            ::QUrl *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1].isValue())
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (Shiboken::Errors::occurred() == nullptr) {
                // getPermission(SiteSettingsManager::PageOptions,QUrl)
                SiteSettingsManager::Permission cppResult = SiteSettingsManager::Permission(cppSelf->getPermission(cppArg0, *cppArg1));
                pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_Permission_IDX])))->converter, &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SiteSettingsManagerFunc_getPermissionName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SiteSettingsManagerWrapper *>(reinterpret_cast< ::SiteSettingsManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: SiteSettingsManager::getPermissionName(SiteSettingsManager::Permission)const->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_Permission_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // getPermissionName(SiteSettingsManager::Permission)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getPermissionName", errInfo, SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]);

    // Call function/method
    {
        ::SiteSettingsManager::Permission cppArg0{SiteSettingsManager::Default};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // getPermissionName(SiteSettingsManager::Permission)const
            QString cppResult = const_cast<const SiteSettingsManagerWrapper *>(cppSelf)->getPermissionName(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SiteSettingsManagerFunc_getPermissionsLike(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SiteSettingsManagerWrapper *>(reinterpret_cast< ::SiteSettingsManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "getPermissionsLike", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: SiteSettingsManager::getPermissionsLike(QString,QString)->QMap<QString,SiteSettingsManager::Permission>
    // 1: SiteSettingsManager::getPermissionsLike(SiteSettingsManager::PageOptions,QString)->QMap<QString,SiteSettingsManager::Permission>
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_PageOptions_IDX])))->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 1; // getPermissionsLike(SiteSettingsManager::PageOptions,QString)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // getPermissionsLike(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "getPermissionsLike", errInfo, SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // getPermissionsLike(const QString &column, const QString &host)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // getPermissionsLike(QString,QString)
                QMap<QString,SiteSettingsManager::Permission> cppResult = cppSelf->getPermissionsLike(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PyFalkon_QMap_QString_SiteSettingsManager_Permission_IDX], &cppResult);
            }
            break;
        }
        case 1: // getPermissionsLike(const SiteSettingsManager::PageOptions option, const QString &host)
        {
            ::SiteSettingsManager::PageOptions cppArg0{SiteSettingsManager::poAllowCookies};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // getPermissionsLike(SiteSettingsManager::PageOptions,QString)
                QMap<QString,SiteSettingsManager::Permission> cppResult = cppSelf->getPermissionsLike(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PyFalkon_QMap_QString_SiteSettingsManager_Permission_IDX], &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SiteSettingsManagerFunc_getSiteSettings(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SiteSettingsManagerWrapper *>(reinterpret_cast< ::SiteSettingsManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: SiteSettingsManager::getSiteSettings(QUrl&)->SiteSettingsManager::SiteSettings
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArg)))) {
        overloadId = 0; // getSiteSettings(QUrl&)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getSiteSettings", errInfo, SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // getSiteSettings(QUrl&)
            SiteSettingsManager::SiteSettings cppResult = cppSelf->getSiteSettings(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_SiteSettings_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SiteSettingsManagerFunc_getSupportedAttribute(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SiteSettingsManagerWrapper *>(reinterpret_cast< ::SiteSettingsManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getSupportedAttribute()const
        QList<QWebEngineSettings::WebAttribute> cppResult = const_cast<const SiteSettingsManagerWrapper *>(cppSelf)->getSupportedAttribute();
        pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QWebEngineSettings_WebAttribute_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SiteSettingsManagerFunc_getSupportedFeatures(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SiteSettingsManagerWrapper *>(reinterpret_cast< ::SiteSettingsManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getSupportedFeatures()const
        QList<QWebEnginePage::Feature> cppResult = const_cast<const SiteSettingsManagerWrapper *>(cppSelf)->getSupportedFeatures();
        pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QWebEnginePage_Feature_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SiteSettingsManagerFunc_getWebAttributes(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SiteSettingsManagerWrapper *>(reinterpret_cast< ::SiteSettingsManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: SiteSettingsManager::getWebAttributes(QUrl)->QHash<QWebEngineSettings::WebAttribute,bool>
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArg)))) {
        overloadId = 0; // getWebAttributes(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getWebAttributes", errInfo, SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // getWebAttributes(QUrl)
            QHash<QWebEngineSettings::WebAttribute,bool> cppResult = cppSelf->getWebAttributes(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PyFalkon_QHash_QWebEngineSettings_WebAttribute_bool_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SiteSettingsManagerFunc_intToPermission(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SiteSettingsManagerWrapper *>(reinterpret_cast< ::SiteSettingsManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: SiteSettingsManager::intToPermission(int)const->SiteSettingsManager::Permission
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // intToPermission(int)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "intToPermission", errInfo, SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // intToPermission(int)const
            SiteSettingsManager::Permission cppResult = SiteSettingsManager::Permission(const_cast<const SiteSettingsManagerWrapper *>(cppSelf)->intToPermission(cppArg0));
            pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_Permission_IDX])))->converter, &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SiteSettingsManagerFunc_loadSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SiteSettingsManagerWrapper *>(reinterpret_cast< ::SiteSettingsManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // loadSettings()
        cppSelf->loadSettings();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_SiteSettingsManagerFunc_optionToSqlColumn(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SiteSettingsManagerWrapper *>(reinterpret_cast< ::SiteSettingsManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: SiteSettingsManager::optionToSqlColumn(SiteSettingsManager::PageOptions)const->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_PageOptions_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // optionToSqlColumn(SiteSettingsManager::PageOptions)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "optionToSqlColumn", errInfo, SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]);

    // Call function/method
    {
        ::SiteSettingsManager::PageOptions cppArg0{SiteSettingsManager::poAllowCookies};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // optionToSqlColumn(SiteSettingsManager::PageOptions)const
            QString cppResult = const_cast<const SiteSettingsManagerWrapper *>(cppSelf)->optionToSqlColumn(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SiteSettingsManagerFunc_saveSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SiteSettingsManagerWrapper *>(reinterpret_cast< ::SiteSettingsManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // saveSettings()
        cppSelf->saveSettings();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_SiteSettingsManagerFunc_setOption(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SiteSettingsManagerWrapper *>(reinterpret_cast< ::SiteSettingsManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setOption", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: SiteSettingsManager::setOption(QString,QUrl,int)
    // 1: SiteSettingsManager::setOption(QWebEnginePage::Feature,QUrl,SiteSettingsManager::Permission)
    // 2: SiteSettingsManager::setOption(QWebEngineSettings::WebAttribute,QUrl,SiteSettingsManager::Permission)
    // 3: SiteSettingsManager::setOption(SiteSettingsManager::PageOptions,QUrl,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_PageOptions_IDX])))->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 3; // setOption(SiteSettingsManager::PageOptions,QUrl,int)
    } else if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineSettings_WebAttribute_IDX])))->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_Permission_IDX])))->converter, (pyArgs[2])))) {
        overloadId = 2; // setOption(QWebEngineSettings::WebAttribute,QUrl,SiteSettingsManager::Permission)
    } else if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEnginePage_Feature_IDX])))->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_Permission_IDX])))->converter, (pyArgs[2])))) {
        overloadId = 1; // setOption(QWebEnginePage::Feature,QUrl,SiteSettingsManager::Permission)
    } else if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // setOption(QString,QUrl,int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setOption", errInfo, SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // setOption(const QString &column, const QUrl &url, const int value)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QUrl cppArg1_local;
            ::QUrl *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1].isValue())
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // setOption(QString,QUrl,int)
                cppSelf->setOption(cppArg0, *cppArg1, cppArg2);
            }
            break;
        }
        case 1: // setOption(const QWebEnginePage::Feature &feature, const QUrl &url, const SiteSettingsManager::Permission value)
        {
            ::QWebEnginePage::Feature cppArg0{QWebEnginePage::Notifications};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QUrl cppArg1_local;
            ::QUrl *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1].isValue())
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            ::SiteSettingsManager::Permission cppArg2{SiteSettingsManager::Default};
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // setOption(QWebEnginePage::Feature,QUrl,SiteSettingsManager::Permission)
                cppSelf->setOption(cppArg0, *cppArg1, cppArg2);
            }
            break;
        }
        case 2: // setOption(const QWebEngineSettings::WebAttribute &attribute, const QUrl &url, const SiteSettingsManager::Permission value)
        {
            ::QWebEngineSettings::WebAttribute cppArg0{QWebEngineSettings::AutoLoadImages};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QUrl cppArg1_local;
            ::QUrl *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1].isValue())
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            ::SiteSettingsManager::Permission cppArg2{SiteSettingsManager::Default};
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // setOption(QWebEngineSettings::WebAttribute,QUrl,SiteSettingsManager::Permission)
                cppSelf->setOption(cppArg0, *cppArg1, cppArg2);
            }
            break;
        }
        case 3: // setOption(const SiteSettingsManager::PageOptions option, const QUrl &url, const int value)
        {
            ::SiteSettingsManager::PageOptions cppArg0{SiteSettingsManager::poAllowCookies};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QUrl cppArg1_local;
            ::QUrl *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1].isValue())
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // setOption(SiteSettingsManager::PageOptions,QUrl,int)
                cppSelf->setOption(cppArg0, *cppArg1, cppArg2);
            }
            break;
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_SiteSettingsManagerFunc_setSiteSettings(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SiteSettingsManagerWrapper *>(reinterpret_cast< ::SiteSettingsManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: SiteSettingsManager::setSiteSettings(SiteSettingsManager::SiteSettings&)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_SiteSettings_IDX]), (pyArg)))) {
        overloadId = 0; // setSiteSettings(SiteSettingsManager::SiteSettings&)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setSiteSettings", errInfo, SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::SiteSettingsManager::SiteSettings cppArg0_local;
        ::SiteSettingsManager::SiteSettings *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setSiteSettings(SiteSettingsManager::SiteSettings&)
            cppSelf->setSiteSettings(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_SiteSettingsManagerFunc_sqlTable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SiteSettingsManagerWrapper *>(reinterpret_cast< ::SiteSettingsManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // sqlTable()
        QString cppResult = cppSelf->sqlTable();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SiteSettingsManagerFunc_webAttributeToSqlColumn(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SiteSettingsManagerWrapper *>(reinterpret_cast< ::SiteSettingsManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: SiteSettingsManager::webAttributeToSqlColumn(QWebEngineSettings::WebAttribute)const->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineSettings_WebAttribute_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // webAttributeToSqlColumn(QWebEngineSettings::WebAttribute)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "webAttributeToSqlColumn", errInfo, SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]);

    // Call function/method
    {
        ::QWebEngineSettings::WebAttribute cppArg0{QWebEngineSettings::AutoLoadImages};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // webAttributeToSqlColumn(QWebEngineSettings::WebAttribute)const
            QString cppResult = const_cast<const SiteSettingsManagerWrapper *>(cppSelf)->webAttributeToSqlColumn(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_SiteSettingsManager_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_SiteSettingsManager_EnumFlagInfo[] = {
    "PageOptions:IntEnum",
    "Permission:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_SiteSettingsManager_methods[] = {
    {"adjustUrl", reinterpret_cast<PyCFunction>(Sbk_SiteSettingsManagerFunc_adjustUrl), METH_O|METH_STATIC, nullptr},
    {"featureToSqlColumn", reinterpret_cast<PyCFunction>(Sbk_SiteSettingsManagerFunc_featureToSqlColumn), METH_O, nullptr},
    {"getDefaultPermission", reinterpret_cast<PyCFunction>(Sbk_SiteSettingsManagerFunc_getDefaultPermission), METH_O, nullptr},
    {"getOptionName", reinterpret_cast<PyCFunction>(Sbk_SiteSettingsManagerFunc_getOptionName), METH_O, nullptr},
    {"getPermission", reinterpret_cast<PyCFunction>(Sbk_SiteSettingsManagerFunc_getPermission), METH_VARARGS, nullptr},
    {"getPermissionName", reinterpret_cast<PyCFunction>(Sbk_SiteSettingsManagerFunc_getPermissionName), METH_O, nullptr},
    {"getPermissionsLike", reinterpret_cast<PyCFunction>(Sbk_SiteSettingsManagerFunc_getPermissionsLike), METH_VARARGS, nullptr},
    {"getSiteSettings", reinterpret_cast<PyCFunction>(Sbk_SiteSettingsManagerFunc_getSiteSettings), METH_O, nullptr},
    {"getSupportedAttribute", reinterpret_cast<PyCFunction>(Sbk_SiteSettingsManagerFunc_getSupportedAttribute), METH_NOARGS, nullptr},
    {"getSupportedFeatures", reinterpret_cast<PyCFunction>(Sbk_SiteSettingsManagerFunc_getSupportedFeatures), METH_NOARGS, nullptr},
    {"getWebAttributes", reinterpret_cast<PyCFunction>(Sbk_SiteSettingsManagerFunc_getWebAttributes), METH_O, nullptr},
    {"intToPermission", reinterpret_cast<PyCFunction>(Sbk_SiteSettingsManagerFunc_intToPermission), METH_O, nullptr},
    {"loadSettings", reinterpret_cast<PyCFunction>(Sbk_SiteSettingsManagerFunc_loadSettings), METH_NOARGS, nullptr},
    {"optionToSqlColumn", reinterpret_cast<PyCFunction>(Sbk_SiteSettingsManagerFunc_optionToSqlColumn), METH_O, nullptr},
    {"saveSettings", reinterpret_cast<PyCFunction>(Sbk_SiteSettingsManagerFunc_saveSettings), METH_NOARGS, nullptr},
    {"setOption", reinterpret_cast<PyCFunction>(Sbk_SiteSettingsManagerFunc_setOption), METH_VARARGS, nullptr},
    {"setSiteSettings", reinterpret_cast<PyCFunction>(Sbk_SiteSettingsManagerFunc_setSiteSettings), METH_O, nullptr},
    {"sqlTable", reinterpret_cast<PyCFunction>(Sbk_SiteSettingsManagerFunc_sqlTable), METH_NOARGS, nullptr},
    {"webAttributeToSqlColumn", reinterpret_cast<PyCFunction>(Sbk_SiteSettingsManagerFunc_webAttributeToSqlColumn), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_SiteSettingsManager_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::SiteSettingsManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<SiteSettingsManagerWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_SiteSettingsManager_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_SiteSettingsManager_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_SiteSettingsManager_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_SiteSettingsManager_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_SiteSettingsManager_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_SiteSettingsManager_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_SiteSettingsManager_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_SiteSettingsManager_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_SiteSettingsManager_spec = {
    "1:PyFalkon.SiteSettingsManager",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_SiteSettingsManager_slots
};

} //extern "C"

static void *Sbk_SiteSettingsManager_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::SiteSettingsManager *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_SiteSettingsManager_Permission(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::SiteSettingsManager::Permission>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::SiteSettingsManager::Permission *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_SiteSettingsManager_Permission_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_Permission_IDX])))
        return Enum_PythonToCpp_SiteSettingsManager_Permission;
    return {};
}

static PyObject *SiteSettingsManager_Permission_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::SiteSettingsManager::Permission>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::SiteSettingsManager::Permission *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Enum_PythonToCpp_SiteSettingsManager_PageOptions(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::SiteSettingsManager::PageOptions>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::SiteSettingsManager::PageOptions *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_SiteSettingsManager_PageOptions_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_PageOptions_IDX])))
        return Enum_PythonToCpp_SiteSettingsManager_PageOptions;
    return {};
}

static PyObject *SiteSettingsManager_PageOptions_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::SiteSettingsManager::PageOptions>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::SiteSettingsManager::PageOptions *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void SiteSettingsManager_PythonToCpp_SiteSettingsManager_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_SiteSettingsManager_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_SiteSettingsManager_PythonToCpp_SiteSettingsManager_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_SiteSettingsManager_TypeF()))
        return SiteSettingsManager_PythonToCpp_SiteSettingsManager_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *SiteSettingsManager_PTR_CppToPython_SiteSettingsManager(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::SiteSettingsManager *>(const_cast<void *>(cppIn)), Sbk_SiteSettingsManager_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *SiteSettingsManager_SignatureStrings[] = {
    "PyFalkon.SiteSettingsManager(self,parent:PySide6.QtCore.QObject=nullptr)",
    "PyFalkon.SiteSettingsManager.adjustUrl(url:typing.Union[PySide6.QtCore.QUrl, QString])->QString",
    "PyFalkon.SiteSettingsManager.featureToSqlColumn(self,feature:PySide6.QtWebEngineCore.QWebEnginePage.Feature)->QString",
    "2:PyFalkon.SiteSettingsManager.getDefaultPermission(self,feature:PySide6.QtWebEngineCore.QWebEnginePage.Feature)->PyFalkon.SiteSettingsManager.Permission",
    "1:PyFalkon.SiteSettingsManager.getDefaultPermission(self,attribute:PySide6.QtWebEngineCore.QWebEngineSettings.WebAttribute)->PyFalkon.SiteSettingsManager.Permission",
    "0:PyFalkon.SiteSettingsManager.getDefaultPermission(self,option:PyFalkon.SiteSettingsManager.PageOptions)->PyFalkon.SiteSettingsManager.Permission",
    "2:PyFalkon.SiteSettingsManager.getOptionName(self,feature:PySide6.QtWebEngineCore.QWebEnginePage.Feature)->QString",
    "1:PyFalkon.SiteSettingsManager.getOptionName(self,attribute:PySide6.QtWebEngineCore.QWebEngineSettings.WebAttribute)->QString",
    "0:PyFalkon.SiteSettingsManager.getOptionName(self,option:PyFalkon.SiteSettingsManager.PageOptions)->QString",
    "7:PyFalkon.SiteSettingsManager.getPermission(self,column:QString,host:QString)->PyFalkon.SiteSettingsManager.Permission",
    "6:PyFalkon.SiteSettingsManager.getPermission(self,column:QString,url:typing.Union[PySide6.QtCore.QUrl, QString])->PyFalkon.SiteSettingsManager.Permission",
    "5:PyFalkon.SiteSettingsManager.getPermission(self,feature:PySide6.QtWebEngineCore.QWebEnginePage.Feature,host:QString)->PyFalkon.SiteSettingsManager.Permission",
    "4:PyFalkon.SiteSettingsManager.getPermission(self,feature:PySide6.QtWebEngineCore.QWebEnginePage.Feature,url:typing.Union[PySide6.QtCore.QUrl, QString])->PyFalkon.SiteSettingsManager.Permission",
    "3:PyFalkon.SiteSettingsManager.getPermission(self,attribute:PySide6.QtWebEngineCore.QWebEngineSettings.WebAttribute,host:QString)->PyFalkon.SiteSettingsManager.Permission",
    "2:PyFalkon.SiteSettingsManager.getPermission(self,attribute:PySide6.QtWebEngineCore.QWebEngineSettings.WebAttribute,url:typing.Union[PySide6.QtCore.QUrl, QString])->PyFalkon.SiteSettingsManager.Permission",
    "1:PyFalkon.SiteSettingsManager.getPermission(self,option:PyFalkon.SiteSettingsManager.PageOptions,host:QString)->PyFalkon.SiteSettingsManager.Permission",
    "0:PyFalkon.SiteSettingsManager.getPermission(self,option:PyFalkon.SiteSettingsManager.PageOptions,url:typing.Union[PySide6.QtCore.QUrl, QString])->PyFalkon.SiteSettingsManager.Permission",
    "PyFalkon.SiteSettingsManager.getPermissionName(self,permission:PyFalkon.SiteSettingsManager.Permission)->QString",
    "1:PyFalkon.SiteSettingsManager.getPermissionsLike(self,column:QString,host:QString)->QMap[QString, PyFalkon.SiteSettingsManager.Permission]",
    "0:PyFalkon.SiteSettingsManager.getPermissionsLike(self,option:PyFalkon.SiteSettingsManager.PageOptions,host:QString)->QMap[QString, PyFalkon.SiteSettingsManager.Permission]",
    "PyFalkon.SiteSettingsManager.getSiteSettings(self,url:typing.Union[PySide6.QtCore.QUrl, QString])->PyFalkon.SiteSettingsManager.SiteSettings",
    "PyFalkon.SiteSettingsManager.getSupportedAttribute(self)->QList[PySide6.QtWebEngineCore.QWebEngineSettings.WebAttribute]",
    "PyFalkon.SiteSettingsManager.getSupportedFeatures(self)->QList[PySide6.QtWebEngineCore.QWebEnginePage.Feature]",
    "PyFalkon.SiteSettingsManager.getWebAttributes(self,url:typing.Union[PySide6.QtCore.QUrl, QString])->QHash[PySide6.QtWebEngineCore.QWebEngineSettings.WebAttribute, bool]",
    "PyFalkon.SiteSettingsManager.intToPermission(self,permission:int)->PyFalkon.SiteSettingsManager.Permission",
    "PyFalkon.SiteSettingsManager.loadSettings(self)",
    "PyFalkon.SiteSettingsManager.optionToSqlColumn(self,option:PyFalkon.SiteSettingsManager.PageOptions)->QString",
    "PyFalkon.SiteSettingsManager.saveSettings(self)",
    "3:PyFalkon.SiteSettingsManager.setOption(self,column:QString,url:typing.Union[PySide6.QtCore.QUrl, QString],value:int)",
    "2:PyFalkon.SiteSettingsManager.setOption(self,feature:PySide6.QtWebEngineCore.QWebEnginePage.Feature,url:typing.Union[PySide6.QtCore.QUrl, QString],value:PyFalkon.SiteSettingsManager.Permission)",
    "1:PyFalkon.SiteSettingsManager.setOption(self,attribute:PySide6.QtWebEngineCore.QWebEngineSettings.WebAttribute,url:typing.Union[PySide6.QtCore.QUrl, QString],value:PyFalkon.SiteSettingsManager.Permission)",
    "0:PyFalkon.SiteSettingsManager.setOption(self,option:PyFalkon.SiteSettingsManager.PageOptions,url:typing.Union[PySide6.QtCore.QUrl, QString],value:int)",
    "PyFalkon.SiteSettingsManager.setSiteSettings(self,siteSettings:PyFalkon.SiteSettingsManager.SiteSettings)",
    "PyFalkon.SiteSettingsManager.sqlTable(self)->QString",
    "PyFalkon.SiteSettingsManager.webAttributeToSqlColumn(self,attribute:PySide6.QtWebEngineCore.QWebEngineSettings.WebAttribute)->QString",
    nullptr}; // Sentinel
#else
static constexpr size_t SiteSettingsManager_SignatureByteSize = 564;
static constexpr uint8_t SiteSettingsManager_SignatureBytes[564] = {
    0x78, 0xda, 0xc5, 0x97, 0x4d, 0x4f, 0xe3, 0x30, 0x10, 0x86, 0xef, 0xfc, 0x8a, 0x1e, 0x41, 0xca,
    0x46, 0x2d, 0xec, 0xb2, 0x52, 0x24, 0x90, 0x10, 0x0b, 0xda, 0x03, 0x2c, 0x89, 0x52, 0xc4, 0xa1,
    0xea, 0xc1, 0xa1, 0xd3, 0x12, 0x70, 0xed, 0x60, 0x4f, 0x58, 0xf5, 0xdf, 0x6f, 0x68, 0x92, 0xd6,
    0xa4, 0x52, 0xfc, 0xd1, 0xa4, 0x7b, 0x4b, 0x1c, 0x7b, 0xde, 0x67, 0xc6, 0xf6, 0x6b, 0x27, 0x5c,
    0xdd, 0x12, 0xfa, 0xc6, 0x99, 0x1f, 0xa7, 0x08, 0x31, 0x20, 0xa6, 0x6c, 0x21, 0xef, 0x09, 0x23,
    0x0b, 0x10, 0xc7, 0x12, 0xe8, 0xdc, 0xcb, 0x88, 0x00, 0x86, 0x41, 0xb8, 0x8a, 0xd3, 0x19, 0x9c,
    0xfb, 0x11, 0x5e, 0x73, 0x01, 0x7e, 0xf4, 0x90, 0xbc, 0xc2, 0x33, 0x5e, 0xb0, 0x9c, 0xd2, 0x0c,
    0xc5, 0xc9, 0x51, 0xd8, 0x12, 0xc8, 0x27, 0xb3, 0xd7, 0x5c, 0xe2, 0xa3, 0xa0, 0xc7, 0xb9, 0xa0,
    0x01, 0xae, 0xb2, 0xe2, 0xa3, 0xff, 0xc8, 0x52, 0xce, 0x26, 0xcd, 0xb8, 0x45, 0x27, 0x6f, 0x10,
    0xc5, 0x28, 0x8a, 0x2e, 0xd3, 0x93, 0x6f, 0x97, 0xd5, 0x63, 0x7b, 0xfc, 0x39, 0x10, 0xcc, 0x05,
    0x8c, 0x79, 0xfc, 0x4e, 0xaf, 0x39, 0xcd, 0x97, 0xac, 0x64, 0xaf, 0xda, 0x15, 0xf8, 0x27, 0x48,
    0x6e, 0xd8, 0x22, 0x65, 0x50, 0xaa, 0x6d, 0x5e, 0xc3, 0x22, 0x8e, 0x7f, 0x5b, 0x76, 0x57, 0x54,
    0x4f, 0x83, 0x56, 0xdd, 0x05, 0xe0, 0x2f, 0x98, 0x93, 0x9c, 0x62, 0x08, 0x62, 0x99, 0x4a, 0x59,
    0x64, 0xb4, 0xa7, 0x72, 0xab, 0xde, 0x56, 0xe5, 0x68, 0xe4, 0x4a, 0x46, 0xb0, 0x48, 0x2d, 0xc9,
    0xd1, 0x84, 0xad, 0x8e, 0xea, 0x17, 0x2d, 0x57, 0xf5, 0x38, 0x0b, 0xc8, 0xa1, 0x2b, 0x24, 0xcf,
    0xb0, 0x78, 0x6e, 0x1f, 0xfd, 0x59, 0xb8, 0x87, 0x75, 0x3f, 0x69, 0x81, 0xa4, 0x9f, 0xd1, 0x32,
    0xe6, 0x1f, 0xb2, 0x84, 0x8e, 0x16, 0xd1, 0xc8, 0x5a, 0xb2, 0x8b, 0x39, 0xaa, 0xd5, 0x87, 0xd6,
    0xea, 0xf6, 0xc5, 0xaf, 0xb5, 0x7e, 0x6a, 0xb5, 0x9a, 0x13, 0xfd, 0xbc, 0xde, 0xad, 0x41, 0x15,
    0xc0, 0x7b, 0xe1, 0x12, 0xeb, 0x17, 0x8b, 0x49, 0x3d, 0xdf, 0x57, 0xd7, 0xda, 0x96, 0x4c, 0xc9,
    0x7e, 0x58, 0x93, 0xb9, 0x2d, 0x37, 0xd7, 0xca, 0x7d, 0x3f, 0x14, 0x5f, 0x6f, 0x15, 0x3e, 0xb3,
    0xce, 0x60, 0xef, 0xdd, 0xe5, 0x5a, 0xec, 0xd3, 0xff, 0x80, 0xda, 0x5b, 0xdd, 0x47, 0xd6, 0xc9,
    0x58, 0xfa, 0x8a, 0x6b, 0x95, 0x87, 0xbd, 0x83, 0xf5, 0x56, 0x53, 0x73, 0xf0, 0xad, 0x5b, 0x67,
    0x9b, 0xb6, 0xc0, 0x50, 0xc6, 0xea, 0x68, 0xda, 0x0e, 0x93, 0x77, 0xe9, 0x1b, 0x98, 0xb8, 0x76,
    0x74, 0x4f, 0xb2, 0x49, 0xfd, 0x6d, 0x60, 0x08, 0x35, 0xb5, 0x9a, 0x37, 0x85, 0x65, 0xcf, 0x55,
    0xe5, 0x08, 0xab, 0x43, 0x55, 0x9b, 0x4b, 0xce, 0x6e, 0x17, 0x8d, 0xda, 0xa6, 0x87, 0xc9, 0xb3,
    0x8c, 0x0b, 0x84, 0xd9, 0xc6, 0x16, 0xd6, 0x48, 0x9f, 0xd9, 0xdf, 0xa5, 0x12, 0x27, 0x8e, 0xde,
    0x32, 0x35, 0x17, 0xae, 0x4e, 0x01, 0x69, 0xab, 0xab, 0x1e, 0x21, 0x7a, 0x39, 0x15, 0xce, 0xb5,
    0xea, 0xd1, 0x6f, 0x22, 0x5f, 0x5c, 0x2b, 0xe2, 0x0d, 0x12, 0xce, 0xa9, 0x06, 0x34, 0x65, 0x38,
    0xe6, 0x4d, 0x0b, 0x52, 0x76, 0x71, 0xf1, 0xbd, 0x2b, 0xcb, 0xa0, 0x9c, 0xcc, 0xbe, 0xac, 0x42,
    0xcd, 0x7f, 0x5a, 0xb9, 0x97, 0x76, 0x7e, 0xa3, 0xdc, 0x2f, 0x84, 0xad, 0x43, 0x24, 0xf9, 0x80,
    0x06, 0x9d, 0xe6, 0x30, 0x97, 0xf5, 0x65, 0xb5, 0x83, 0x4b, 0x9c, 0xf7, 0x41, 0x68, 0x0e, 0xeb,
    0x6a, 0xeb, 0x0e, 0xe6, 0x86, 0xec, 0x41, 0x6e, 0x40, 0x15, 0x9e, 0xa9, 0xa5, 0xeb, 0x9c, 0xbc,
    0x91, 0xc2, 0xa1, 0xef, 0x15, 0xb6, 0xd9, 0x0c, 0xad, 0xb2, 0xe9, 0xf7, 0xfc, 0x56, 0x17, 0x8a,
    0x8e, 0x6a, 0xd7, 0xf6, 0xa5, 0xd2, 0x12, 0x18, 0x5b, 0xba, 0x4e, 0xe9, 0x9d, 0x8e, 0x49, 0x42,
    0xb7, 0x36, 0x6e, 0xb2, 0xdd, 0xfe, 0x2a, 0xd3, 0xb7, 0xb3, 0xc5, 0xbb, 0xfc, 0xe3, 0xfc, 0x07,
    0xcb, 0x42, 0xdf, 0xdb
};
#endif

PyTypeObject *init_SiteSettingsManager(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX].type;

    Shiboken::AutoDecRef Sbk_SiteSettingsManager_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_SiteSettingsManager_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "SiteSettingsManager",
        "SiteSettingsManager*",
        &Sbk_SiteSettingsManager_spec,
        &Shiboken::callCppDestructor< SiteSettingsManager >,
        Sbk_SiteSettingsManager_Type_bases.object(),
        0);
    auto *pyType = _Sbk_SiteSettingsManager_Type; // references _Sbk_SiteSettingsManager_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, SiteSettingsManager_SignatureStrings);
#else
    InitSignatureBytes(pyType, SiteSettingsManager_SignatureBytes, SiteSettingsManager_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_SiteSettingsManager_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        SiteSettingsManager_PythonToCpp_SiteSettingsManager_PTR,
        is_SiteSettingsManager_PythonToCpp_SiteSettingsManager_PTR_Convertible,
        SiteSettingsManager_PTR_CppToPython_SiteSettingsManager);

    Shiboken::Conversions::registerConverterName(converter, "SiteSettingsManager");
    Shiboken::Conversions::registerConverterName(converter, "SiteSettingsManager*");
    Shiboken::Conversions::registerConverterName(converter, "SiteSettingsManager&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::SiteSettingsManager).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(SiteSettingsManagerWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_SiteSettingsManager_TypeF(), &Sbk_SiteSettingsManager_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_SiteSettingsManager_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'Permission'.
    const char *Permission_Initializer[] = {
        "Default",
        "Allow",
        "Deny",
        "Ask",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t Permission_InitializerValues[] = {
        uint8_t(SiteSettingsManager::Permission::Default), //  0x00  0
        uint8_t(SiteSettingsManager::Permission::Allow),   //  0x01  1
        uint8_t(SiteSettingsManager::Permission::Deny),    //  0x02  2
        uint8_t(SiteSettingsManager::Permission::Ask)      //  0x03  3
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_SiteSettingsManager_TypeF(),
        "1:PyFalkon.SiteSettingsManager.Permission",
        Permission_Initializer, Permission_InitializerValues);
    SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_Permission_IDX].type = EType;
    // Register converter for enum 'SiteSettingsManager::Permission'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            SiteSettingsManager_Permission_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_SiteSettingsManager_Permission,
            is_Enum_PythonToCpp_SiteSettingsManager_Permission_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "SiteSettingsManager::Permission");
        Shiboken::Conversions::registerConverterAlias(converter, "Permission");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'Permission' enum.

    // Initialization of enum 'PageOptions'.
    const char *PageOptions_Initializer[] = {
        "poAllowCookies",
        "poZoomLevel",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t PageOptions_InitializerValues[] = {
        uint8_t(SiteSettingsManager::PageOptions::poAllowCookies), //  0x00  0
        uint8_t(SiteSettingsManager::PageOptions::poZoomLevel)     //  0x01  1
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_SiteSettingsManager_TypeF(),
        "1:PyFalkon.SiteSettingsManager.PageOptions",
        PageOptions_Initializer, PageOptions_InitializerValues);
    SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_PageOptions_IDX].type = EType;
    // Register converter for enum 'SiteSettingsManager::PageOptions'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            SiteSettingsManager_PageOptions_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_SiteSettingsManager_PageOptions,
            is_Enum_PythonToCpp_SiteSettingsManager_PageOptions_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "SiteSettingsManager::PageOptions");
        Shiboken::Conversions::registerConverterAlias(converter, "PageOptions");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'PageOptions' enum.

    SiteSettingsManagerWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::SiteSettingsManager::staticMetaObject, sizeof(SiteSettingsManagerWrapper));

    return pyType;
}
