#ifndef _EFL_UI_SIZE_MODEL_EO_H_
#define _EFL_UI_SIZE_MODEL_EO_H_

#ifndef _EFL_UI_SIZE_MODEL_EO_CLASS_TYPE
#define _EFL_UI_SIZE_MODEL_EO_CLASS_TYPE

typedef Eo Efl_Ui_Size_Model;

#endif

#ifndef _EFL_UI_SIZE_MODEL_EO_TYPES
#define _EFL_UI_SIZE_MODEL_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief Class to be used to store object item size for List/Grid View.
 *
 * This model provide the following properties that can be retrieved by
 * @ref efl_model_properties_get : - <tt>"self.width"</tt> and
 * <tt>"self.height"</tt> define the size of this object from the point of view
 * of the @ref Efl_Ui_View that use it. They only apply to children and not to
 * the top root object. - <tt>"item.width"</tt> and
 * <tt>"item.height"</tt> define all the children size and are available only
 * on @ref Efl_Ui_Size_Model that do have children. -
 * <tt>"total.width"</tt> and <tt>"total.height"</tt> define the
 * accumulated size used by all the children. Only vertical list accumulation
 * logic is implemented at this point.
 *
 * @ingroup Efl_Ui_Size_Model
 */
#define EFL_UI_SIZE_MODEL_CLASS efl_ui_size_model_class_get()

EAPI EAPI_WEAK const Efl_Class *efl_ui_size_model_class_get(void) EINA_CONST;
#endif /* EFL_BETA_API_SUPPORT */

#endif
