#ifndef _ECTOR_SURFACE_EO_H_
#define _ECTOR_SURFACE_EO_H_

#ifndef _ECTOR_SURFACE_EO_CLASS_TYPE
#define _ECTOR_SURFACE_EO_CLASS_TYPE

typedef Eo Ector_Surface;

#endif

#ifndef _ECTOR_SURFACE_EO_TYPES
#define _ECTOR_SURFACE_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/** Surface interface for Ector
 *
 * @ingroup Ector_Surface
 */
#define ECTOR_SURFACE_MIXIN ector_surface_mixin_get()

ECTOR_API ECTOR_API_WEAK const Efl_Class *ector_surface_mixin_get(void) EINA_CONST;

/**
 * @brief This defines where (0,0) is in pixel coordinates inside the surface
 *
 * @param[in] obj The object.
 * @param[in] x X coordinate for reference point
 * @param[in] y Y coordinate for reference point
 *
 * @ingroup Ector_Surface
 */
ECTOR_API ECTOR_API_WEAK void ector_surface_reference_point_set(Eo *obj, int x, int y);

/**
 * @brief This defines where (0,0) is in pixel coordinates inside the surface
 *
 * @param[in] obj The object.
 * @param[out] x X coordinate for reference point
 * @param[out] y Y coordinate for reference point
 *
 * @ingroup Ector_Surface
 */
ECTOR_API ECTOR_API_WEAK void ector_surface_reference_point_get(const Eo *obj, int *x, int *y);

/**
 * @brief Create a new renderer factory for the given type
 *
 * @param[in] obj The object.
 * @param[in] type Efl class
 *
 * @return Renderer factory object
 *
 * @ingroup Ector_Surface
 */
ECTOR_API ECTOR_API_WEAK Efl_Object *ector_surface_renderer_factory_new(Eo *obj, const Efl_Class *type);

/**
 * @brief Draw image's buffer to surface buffer.
 *
 * @param[in] obj The object.
 * @param[in] image Image buffer
 * @param[in] x Buffer position x
 * @param[in] y Buffer position y
 * @param[in] alpha Buffer alpha value
 *
 * @return True if drawing was successful
 *
 * @ingroup Ector_Surface
 */
ECTOR_API ECTOR_API_WEAK Eina_Bool ector_surface_draw_image(Eo *obj, Ector_Buffer *image, int x, int y, int alpha);
#endif /* EFL_BETA_API_SUPPORT */

#endif
