/* Generated by wayland-scanner 1.23.0 */

#ifndef DDE_SHELL_SERVER_PROTOCOL_H
#define DDE_SHELL_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_dde_shell The dde_shell protocol
 * @section page_ifaces_dde_shell Interfaces
 * - @subpage page_iface_dde_shell - get window info
 * - @subpage page_iface_dde_shell_surface - dde shell surface
 * @section page_copyright_dde_shell Copyright
 * <pre>
 *
 * Copyright © 2020  wugang <wugang@uniontech.com>
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct dde_shell;
struct dde_shell_surface;
struct wl_surface;

#ifndef DDE_SHELL_INTERFACE
#define DDE_SHELL_INTERFACE
/**
 * @page page_iface_dde_shell dde_shell
 * @section page_iface_dde_shell_desc Description
 *
 * Eg: window position.
 * @section page_iface_dde_shell_api API
 * See @ref iface_dde_shell.
 */
/**
 * @defgroup iface_dde_shell The dde_shell interface
 *
 * Eg: window position.
 */
extern const struct wl_interface dde_shell_interface;
#endif
#ifndef DDE_SHELL_SURFACE_INTERFACE
#define DDE_SHELL_SURFACE_INTERFACE
/**
 * @page page_iface_dde_shell_surface dde_shell_surface
 * @section page_iface_dde_shell_surface_desc Description
 *
 *
 * @section page_iface_dde_shell_surface_api API
 * See @ref iface_dde_shell_surface.
 */
/**
 * @defgroup iface_dde_shell_surface The dde_shell_surface interface
 *
 *
 */
extern const struct wl_interface dde_shell_surface_interface;
#endif

#ifndef DDE_SHELL_STATE_ENUM
#define DDE_SHELL_STATE_ENUM
enum dde_shell_state {
	DDE_SHELL_STATE_ACTIVE = 1 << 0,
	DDE_SHELL_STATE_MINIMIZED = 1 << 1,
	DDE_SHELL_STATE_MAXIMIZED = 1 << 2,
	DDE_SHELL_STATE_FULLSCREEN = 1 << 3,
	DDE_SHELL_STATE_KEEP_ABOVE = 1 << 4,
	DDE_SHELL_STATE_KEEP_BELOW = 1 << 5,
	DDE_SHELL_STATE_ON_ALL_DESKTOPS = 1 << 6,
	DDE_SHELL_STATE_DEMANDS_ATTENTION = 1 << 7,
	DDE_SHELL_STATE_CLOSEABLE = 1 << 8,
	DDE_SHELL_STATE_MINIMIZABLE = 1 << 9,
	DDE_SHELL_STATE_MAXIMIZABLE = 1 << 10,
	DDE_SHELL_STATE_FULLSCREENABLE = 1 << 11,
	DDE_SHELL_STATE_SKIPTASKBAR = 1 << 12,
	DDE_SHELL_STATE_SHADEABLE = 1 << 13,
	DDE_SHELL_STATE_SHADED = 1 << 14,
	DDE_SHELL_STATE_MOVABLE = 1 << 15,
	DDE_SHELL_STATE_RESIZABLE = 1 << 16,
	DDE_SHELL_STATE_VIRTUAL_DESKTOP_CHANGEABLE = 1 << 17,
	DDE_SHELL_STATE_SKIPSWITCHER = 1 << 18,
	DDE_SHELL_STATE_ACCEPT_FOCUS = 1 << 19,
	DDE_SHELL_STATE_MODALITY = 1 << 20,
	DDE_SHELL_STATE_TWO_SPLIT = 1 << 21,
	DDE_SHELL_STATE_FOUR_SPLIT = 1 << 22,
	DDE_SHELL_STATE_NO_SPLIT = 1 << 23,
};
/**
 * @ingroup iface_dde_shell
 * Validate a dde_shell state value.
 *
 * @return true on success, false on error.
 * @ref dde_shell_state
 */
static inline bool
dde_shell_state_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case DDE_SHELL_STATE_ACTIVE:
		return version >= 1;
	case DDE_SHELL_STATE_MINIMIZED:
		return version >= 1;
	case DDE_SHELL_STATE_MAXIMIZED:
		return version >= 1;
	case DDE_SHELL_STATE_FULLSCREEN:
		return version >= 1;
	case DDE_SHELL_STATE_KEEP_ABOVE:
		return version >= 1;
	case DDE_SHELL_STATE_KEEP_BELOW:
		return version >= 1;
	case DDE_SHELL_STATE_ON_ALL_DESKTOPS:
		return version >= 1;
	case DDE_SHELL_STATE_DEMANDS_ATTENTION:
		return version >= 1;
	case DDE_SHELL_STATE_CLOSEABLE:
		return version >= 1;
	case DDE_SHELL_STATE_MINIMIZABLE:
		return version >= 1;
	case DDE_SHELL_STATE_MAXIMIZABLE:
		return version >= 1;
	case DDE_SHELL_STATE_FULLSCREENABLE:
		return version >= 1;
	case DDE_SHELL_STATE_SKIPTASKBAR:
		return version >= 1;
	case DDE_SHELL_STATE_SHADEABLE:
		return version >= 1;
	case DDE_SHELL_STATE_SHADED:
		return version >= 1;
	case DDE_SHELL_STATE_MOVABLE:
		return version >= 1;
	case DDE_SHELL_STATE_RESIZABLE:
		return version >= 1;
	case DDE_SHELL_STATE_VIRTUAL_DESKTOP_CHANGEABLE:
		return version >= 1;
	case DDE_SHELL_STATE_SKIPSWITCHER:
		return version >= 1;
	case DDE_SHELL_STATE_ACCEPT_FOCUS:
		return version >= 1;
	case DDE_SHELL_STATE_MODALITY:
		return version >= 1;
	case DDE_SHELL_STATE_TWO_SPLIT:
		return version >= 1;
	case DDE_SHELL_STATE_FOUR_SPLIT:
		return version >= 1;
	case DDE_SHELL_STATE_NO_SPLIT:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* DDE_SHELL_STATE_ENUM */

#ifndef DDE_SHELL_PROPERTY_ENUM
#define DDE_SHELL_PROPERTY_ENUM
enum dde_shell_property {
	DDE_SHELL_PROPERTY_NOTITLEBAR = 1 << 0,
	DDE_SHELL_PROPERTY_THEME = 1 << 1,
	DDE_SHELL_PROPERTY_WINDOWRADIUS = 1 << 2,
	DDE_SHELL_PROPERTY_BORDERWIDTH = 1 << 3,
	DDE_SHELL_PROPERTY_BORDERCOLOR = 1 << 4,
	DDE_SHELL_PROPERTY_SHADOWRADIUS = 1 << 5,
	DDE_SHELL_PROPERTY_SHADOWOFFSET = 1 << 6,
	DDE_SHELL_PROPERTY_SHADOWCOLOR = 1 << 7,
	DDE_SHELL_PROPERTY_MOUSEINPUTAREAMARGINS = 1 << 8,
	DDE_SHELL_PROPERTY_WINDOWPIXELRATIO = 1 << 9,
	DDE_SHELL_PROPERTY_QUICKTILE = 1 << 10,
};
/**
 * @ingroup iface_dde_shell
 * Validate a dde_shell property value.
 *
 * @return true on success, false on error.
 * @ref dde_shell_property
 */
static inline bool
dde_shell_property_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case DDE_SHELL_PROPERTY_NOTITLEBAR:
		return version >= 1;
	case DDE_SHELL_PROPERTY_THEME:
		return version >= 1;
	case DDE_SHELL_PROPERTY_WINDOWRADIUS:
		return version >= 1;
	case DDE_SHELL_PROPERTY_BORDERWIDTH:
		return version >= 1;
	case DDE_SHELL_PROPERTY_BORDERCOLOR:
		return version >= 1;
	case DDE_SHELL_PROPERTY_SHADOWRADIUS:
		return version >= 1;
	case DDE_SHELL_PROPERTY_SHADOWOFFSET:
		return version >= 1;
	case DDE_SHELL_PROPERTY_SHADOWCOLOR:
		return version >= 1;
	case DDE_SHELL_PROPERTY_MOUSEINPUTAREAMARGINS:
		return version >= 1;
	case DDE_SHELL_PROPERTY_WINDOWPIXELRATIO:
		return version >= 1;
	case DDE_SHELL_PROPERTY_QUICKTILE:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* DDE_SHELL_PROPERTY_ENUM */

/**
 * @ingroup iface_dde_shell
 * @struct dde_shell_interface
 */
struct dde_shell_interface {
	/**
	 * get a dde shell surface bind to a wayland surface
	 *
	 * 
	 */
	void (*get_shell_surface)(struct wl_client *client,
				  struct wl_resource *resource,
				  uint32_t id,
				  struct wl_resource *surface);
};


/**
 * @ingroup iface_dde_shell
 */
#define DDE_SHELL_GET_SHELL_SURFACE_SINCE_VERSION 1

/**
 * @ingroup iface_dde_shell_surface
 * @struct dde_shell_surface_interface
 */
struct dde_shell_surface_interface {
	/**
	 * request get the window geometry
	 *
	 * reques windo geometry, will notify by "geometry" event.
	 */
	void (*get_geometry)(struct wl_client *client,
			     struct wl_resource *resource);
	/**
	 * request to activate shell
	 *
	 * request to activate current shell if it's not active
	 */
	void (*request_active)(struct wl_client *client,
			       struct wl_resource *resource);
	/**
	 * set window state
	 *
	 * Set window state.
	 *
	 * Values for state argument are described by dde_shell.state and
	 * can be used together in a bitfield. The flags bitfield describes
	 * which flags are supposed to be set, the state bitfield the value
	 * for the set flags
	 * @param flags bitfield of set state flags
	 * @param state bitfield of state flags
	 */
	void (*set_state)(struct wl_client *client,
			  struct wl_resource *resource,
			  uint32_t flags,
			  uint32_t state);
	/**
	 * set window property
	 *
	 * Set window property.
	 *
	 * Values for property argument are described by dde_shell.property
	 * and can be used together in a bitfield. The flags bitfield
	 * describes which property are supposed to be set.
	 * @param property property type
	 * @param dataArr property value
	 */
	void (*set_property)(struct wl_client *client,
			     struct wl_resource *resource,
			     uint32_t property,
			     struct wl_array *dataArr);
};

#define DDE_SHELL_SURFACE_GEOMETRY 0
#define DDE_SHELL_SURFACE_STATE_CHANGED 1

/**
 * @ingroup iface_dde_shell_surface
 */
#define DDE_SHELL_SURFACE_GEOMETRY_SINCE_VERSION 1
/**
 * @ingroup iface_dde_shell_surface
 */
#define DDE_SHELL_SURFACE_STATE_CHANGED_SINCE_VERSION 1

/**
 * @ingroup iface_dde_shell_surface
 */
#define DDE_SHELL_SURFACE_GET_GEOMETRY_SINCE_VERSION 1
/**
 * @ingroup iface_dde_shell_surface
 */
#define DDE_SHELL_SURFACE_REQUEST_ACTIVE_SINCE_VERSION 1
/**
 * @ingroup iface_dde_shell_surface
 */
#define DDE_SHELL_SURFACE_SET_STATE_SINCE_VERSION 1
/**
 * @ingroup iface_dde_shell_surface
 */
#define DDE_SHELL_SURFACE_SET_PROPERTY_SINCE_VERSION 1

/**
 * @ingroup iface_dde_shell_surface
 * Sends an geometry event to the client owning the resource.
 * @param resource_ The client's resource
 * @param x x pos
 * @param y y pos
 * @param w width
 * @param h height
 */
static inline void
dde_shell_surface_send_geometry(struct wl_resource *resource_, int32_t x, int32_t y, uint32_t w, uint32_t h)
{
	wl_resource_post_event(resource_, DDE_SHELL_SURFACE_GEOMETRY, x, y, w, h);
}

/**
 * @ingroup iface_dde_shell_surface
 * Sends an state_changed event to the client owning the resource.
 * @param resource_ The client's resource
 * @param flags bitfield of state flags
 */
static inline void
dde_shell_surface_send_state_changed(struct wl_resource *resource_, uint32_t flags)
{
	wl_resource_post_event(resource_, DDE_SHELL_SURFACE_STATE_CHANGED, flags);
}

#ifdef  __cplusplus
}
#endif

#endif
